"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@oclif/core");
const fs = require("node:fs/promises");
const fileExists = async (path) => {
    try {
        await fs.access(path);
        return true;
    }
    catch (_b) {
        return false;
    }
};
class Lock extends core_1.Command {
    async run() {
        if (await fileExists('yarn.lock')) {
            this.log('Copying yarn.lock to oclif.lock');
            await fs.copyFile('yarn.lock', 'oclif.lock');
        }
        else {
            throw this.error('yarn.lock does not exist');
        }
    }
}
exports.default = Lock;
_a = Lock;
(() => {
    _a.summary = 'Copy the yarn.lock to oclif.lock';
    _a.description = `Using oclif.lock allows your plugins dependencies to be locked to the version specified in the lock file during plugin install.
Once the oclif.lock file is created you can include it your npm package by adding it to the files property of your package.json. We do not recommend committing the oclif.lock file to git.`;
})();
