"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.configTest = void 0;
const prettier_1 = require("prettier");
/**
 * Test a config with Prettier
 * @param config Config to check
 * @param good A properly formatted script
 * @param bad An improperly formatted version of the `good` script
 * @param t AVA execution context
 */
function configTest(config, good, bad, t) {
    const pathedConfig = { ...config, filepath: 'file.ts' };
    t.notThrows(() => prettier_1.format('', pathedConfig), 'config is valid');
    t.is(prettier_1.format(good, pathedConfig), good, "doesn't format when input is good");
    t.is(prettier_1.format(bad, pathedConfig), good, 'formats when input is bad');
}
exports.configTest = configTest;
//# sourceMappingURL=util-for-testing.js.map