
<a href="https://linksnatch.pages.dev">
  <div align="center">
    <img alt="LinkSnatch" src="public/icon.svg" width="80">
  </div>
  <h1 align="center">LinkSnatch</h1>
</a>

<p align="center">
  An effortlessly simple bookmarks app that lets you save the links on your device on the go.
</p>

![](/public/linksnatch-cover.png)

## Introduction

This is a dead simple bookmarks app that lets you save the links on your device on the go.

I built [LinkSnatch](https://linksnatch.pages.dev) because I wanted something really simple to save links that I wanted to read later. I didn't want to have to sign up for an account, I didn't want to have to install a browser extension, and I didn't want to have to use a bookmarking service that was going to track me. I wanted something pretty simple that just works. And here I am!

The app is fairly opinionated and comes with a set of bare minimum features I would need:

- A beautiful interface with minimal distractions.
- Extracts URL metadata using [jsonlink.io](https://jsonlink.io) and saves it to the browser's local storage.
- Save and search links all from a single place.
- Dark mode.
- It doesn't track you.
- No signup needed.
- It doesn't require you to install a browser extension.
- It's open source.
  
I started building it to solve my own itch but later realized that someone might be in need of something like this. And so, I decided to set it free out in the wild!

> Read the story: [Building LinkSnatch](https://www.amitmerchant.com/building-a-bookmarks-app-with-nextjs-and-tailwind-css/)

## Tech Stack

- [Next.js](https://nextjs.org/)
- [Tailwind CSS](https://tailwindcss.com/)
- [Preline](https://preline.co/index.html)
- [jsonlink.io](https://jsonlink.io)
- [React Hot Toast](https://react-hot-toast.com/)
- [AutoAnimate](https://auto-animate.formkit.com/)

## Development

First, clone the repository.

```bash  
git clone git@github.com:amitmerchant1990/linksnatch.git
```

Then install the dependencies.

```bash
npm install
```

Go to [jsonlink.io](https://jsonlink.io) and get your API key. Then, create a `.env.local` file in the root of the project and add the following.

```env
NEXT_PUBLIC_JSONLINK_API_KEY=add_your_api_key_here
```

Finally, run the development server.

```bash
npm run dev
# or
yarn dev
# or
pnpm dev
```

Open [http://localhost:3000](http://localhost:3000) with your browser to see LinkSnatch in action.

## Community

- [docker-linksnatch](https://github.com/varunsridharan/docker-linksnatch) - A dockerized version of LinkSnatch directly installable from [Docker Hub](https://hub.docker.com/) and [GitHub Container Registry](https://github.com/features/packages) by [@varunsridharan](https://github.com/varunsridharan).
- [linksnatch-docker](https://github.com/obiequack/linksnatch-docker/) - A docker setup repository for LinkSnatch by [@obiequack](https://github.com/obiequack).

## Support

<a href="https://paypal.me/AmitMerchant" target="_blank"><img src="https://www.buymeacoffee.com/assets/img/custom_images/purple_img.png" alt="Buy Me A Coffee" style="height: 41px !important;width: 174px !important;box-shadow: 0px 3px 2px 0px rgba(190, 190, 190, 0.5) !important;-webkit-box-shadow: 0px 3px 2px 0px rgba(190, 190, 190, 0.5) !important;" ></a>

<p>Or</p> 

[Become a GitHub Sponsor](https://github.com/sponsors/amitmerchant1990)

## License

MIT

---

> [amitmerchant.com](https://www.amitmerchant.com) &nbsp;&middot;&nbsp;
> GitHub [@amitmerchant1990](https://github.com/amitmerchant1990) &nbsp;&middot;&nbsp;
> Twitter [@amit_merchant](https://twitter.com/amit_merchant)



