# Generated by Django 3.2.6 on 2021-11-05 01:58

from django.core.exceptions import ObjectDoesNotExist
from django.db import migrations


def update_agent_field(apps, schema_editor):
    AuditLog = apps.get_model("logs", "AuditLog")
    Agent = apps.get_model("agents", "Agent")
    for log in AuditLog.objects.exclude(agent_id=None):
        try:
            log.agent_id = Agent.objects.get(pk=log.agent_id).agent_id
            log.save()
        except (ObjectDoesNotExist, ValueError):
            pass


class Migration(migrations.Migration):

    dependencies = [
        ('logs', '0021_alter_auditlog_agent_id'),
    ]

    operations = [
        migrations.RunPython(update_agent_field, migrations.RunPython.noop),
    ]
