# Generated by Django 4.2.3 on 2023-07-05 05:33

import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion
import ee.reporting.storage
import uuid


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="ReportAsset",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                        unique=True,
                    ),
                ),
                (
                    "file",
                    models.FileField(
                        storage=ee.reporting.storage.get_report_assets_fs,
                        unique=True,
                        upload_to="",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="ReportDataQuery",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=50, unique=True)),
                ("json_query", models.JSONField()),
            ],
        ),
        migrations.CreateModel(
            name="ReportHTMLTemplate",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=50, unique=True)),
                ("html", models.TextField()),
            ],
        ),
        migrations.CreateModel(
            name="ReportTemplate",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=50, unique=True)),
                ("template_md", models.TextField()),
                ("template_css", models.TextField(blank=True, null=True)),
                (
                    "type",
                    models.CharField(
                        choices=[("markdown", "Markdown"), ("html", "Html")],
                        default="markdown",
                        max_length=15,
                    ),
                ),
                ("template_variables", models.TextField(blank=True, default="")),
                (
                    "depends_on",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.CharField(blank=True, max_length=20),
                        blank=True,
                        default=list,
                        size=None,
                    ),
                ),
                (
                    "template_html",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="htmltemplate",
                        to="reporting.reporthtmltemplate",
                    ),
                ),
            ],
        ),
    ]
