# Generated by Django 3.2.12 on 2022-04-01 22:48

from django.db import migrations, transaction
from django.db.utils import IntegrityError

from tacticalrmm.constants import CheckType


def migrate_check_results(apps, schema_editor):
    Check = apps.get_model("checks", "Check")
    CheckResult = apps.get_model("checks", "CheckResult")
    for check in Check.objects.exclude(agent=None).iterator():

        try:
            with transaction.atomic():
                if check.managed_by_policy:
                    CheckResult.objects.create(
                        assigned_check_id=check.parent_check,
                        agent_id=check.agent.id,
                        status=check.status,
                        more_info=check.more_info,
                        last_run=check.last_run,
                        fail_count=check.fail_count,
                        outage_history=check.outage_history,
                        extra_details=check.extra_details,
                        stdout=check.stdout,
                        stderr=check.stderr,
                        retcode=check.retcode,
                        execution_time=check.execution_time,
                        history=check.history,
                        alert_severity=check.alert_severity
                        if check.check_type
                        in [
                            CheckType.MEMORY,
                            CheckType.CPU_LOAD,
                            CheckType.DISK_SPACE,
                            CheckType.SCRIPT,
                        ]
                        else None,
                    )

                else:
                    CheckResult.objects.create(
                        assigned_check_id=check.id,
                        agent_id=check.agent.id,
                        status=check.status,
                        more_info=check.more_info,
                        last_run=check.last_run,
                        fail_count=check.fail_count,
                        outage_history=check.outage_history,
                        extra_details=check.extra_details,
                        stdout=check.stdout,
                        stderr=check.stderr,
                        retcode=check.retcode,
                        execution_time=check.execution_time,
                        history=check.history,
                        alert_severity=check.alert_severity
                        if check.check_type
                        in [
                            CheckType.MEMORY,
                            CheckType.CPU_LOAD,
                            CheckType.DISK_SPACE,
                            CheckType.SCRIPT,
                        ]
                        else None,
                    )
        except IntegrityError:
            pass


class Migration(migrations.Migration):
    atomic = False

    dependencies = [
        ("checks", "0026_auto_20220401_2244"),
    ]

    operations = [
        migrations.RunPython(migrate_check_results),
    ]
