# Generated by Django 3.2.12 on 2022-04-01 22:44

import django.contrib.postgres.fields
import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('agents', '0046_alter_agenthistory_command'),
        ('checks', '0025_auto_20210917_1954'),
    ]

    operations = [
        migrations.RenameField(
            model_name='check',
            old_name='overriden_by_policy',
            new_name='overridden_by_policy',
        ),
        migrations.AddField(
            model_name='checkhistory',
            name='agent_id',
            field=models.CharField(blank=True, max_length=200, null=True),
        ),
        migrations.CreateModel(
            name='CheckResult',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.CharField(choices=[('passing', 'Passing'), ('failing', 'Failing'), ('pending', 'Pending')], default='pending', max_length=100)),
                ('alert_severity', models.CharField(blank=True, choices=[('info', 'Informational'), ('warning', 'Warning'), ('error', 'Error')], default='warning', max_length=15, null=True)),
                ('more_info', models.TextField(blank=True, null=True)),
                ('last_run', models.DateTimeField(blank=True, null=True)),
                ('fail_count', models.PositiveIntegerField(default=0)),
                ('outage_history', models.JSONField(blank=True, null=True)),
                ('extra_details', models.JSONField(blank=True, null=True)),
                ('stdout', models.TextField(blank=True, null=True)),
                ('stderr', models.TextField(blank=True, null=True)),
                ('retcode', models.IntegerField(blank=True, null=True)),
                ('execution_time', models.CharField(blank=True, max_length=100, null=True)),
                ('history', django.contrib.postgres.fields.ArrayField(base_field=models.IntegerField(blank=True), blank=True, default=list, null=True, size=None)),
                ('agent', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='checkresults', to='agents.agent')),
                ('assigned_check', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='checkresults', to='checks.check')),
            ],
            options={
                'unique_together': {('agent', 'assigned_check')},
            },
        ),
    ]
