# Generated by Django 3.2.12 on 2022-04-01 22:49

from django.db import migrations, transaction
from django.db.utils import IntegrityError


def migrate_task_results(apps, schema_editor):
    AutomatedTask = apps.get_model("autotasks", "AutomatedTask")
    TaskResult = apps.get_model("autotasks", "TaskResult")
    for task in AutomatedTask.objects.exclude(agent=None):

        try:
            with transaction.atomic():
                if task.managed_by_policy:
                    TaskResult.objects.create(
                        task_id=task.parent_task,
                        agent_id=task.agent_id,
                        retcode=task.retcode,
                        stdout=task.stdout,
                        stderr=task.stderr,
                        execution_time=task.execution_time,
                        last_run=task.last_run,
                        status=task.status,
                        sync_status=task.sync_status,
                    )
                else:
                    TaskResult.objects.create(
                        task_id=task.id,
                        agent_id=task.agent.id,
                        retcode=task.retcode,
                        stdout=task.stdout,
                        stderr=task.stderr,
                        execution_time=task.execution_time,
                        last_run=task.last_run,
                        status=task.status,
                        sync_status=task.sync_status,
                    )
        except IntegrityError:
            continue


class Migration(migrations.Migration):
    atomic = False
    dependencies = [
        ("autotasks", "0030_auto_20220401_2244"),
    ]

    operations = [
        migrations.RunPython(migrate_task_results),
    ]
