# Generated by Django 3.1.2 on 2020-11-01 22:54

from django.db import migrations


def link_sites_to_agents(apps, schema_editor):
    Agent = apps.get_model("agents", "Agent")
    Site = apps.get_model("clients", "Site")
    for agent in Agent.objects.all():
        site = Site.objects.get(client__client=agent.client, site=agent.site)
        agent.site_link = site
        agent.save()


def reverse(apps, schema_editor):
    Agent = apps.get_model("agents", "Agent")
    for agent in Agent.objects.all():
        agent.site = agent.site_link.site
        agent.client = agent.site_link.client.client
        agent.save()


class Migration(migrations.Migration):

    dependencies = [
        ("agents", "0021_agent_site_link"),
    ]

    operations = [
        migrations.RunPython(link_sites_to_agents, reverse),
    ]
