# Generated by Django 3.1.2 on 2020-11-01 22:54

from django.db import migrations


def link_agents_to_users(apps, schema_editor):
    Agent = apps.get_model("agents", "Agent")
    User = apps.get_model("accounts", "User")
    for agent in Agent.objects.all():
        user = User.objects.filter(username=agent.agent_id).first()

        if user:
            user.agent = agent
            user.save()


class Migration(migrations.Migration):

    dependencies = [
        ("accounts", "0006_user_agent"),
    ]

    operations = [
        migrations.RunPython(link_agents_to_users, migrations.RunPython.noop),
    ]
