<?php
defined('BASEPATH') or exit('No direct script access allowed');
?>

<main class="bg-light border-end border-primary w-100 h-100 d-flex flex-column align-items-center">
    <!-- Top Navigations -->
    <div class="col-12 p-4 border-bottom border-primary">
        <div class="row">
            <div class="col-lg-4 fs-5 d-flex align-items-center gap-3 text-primary ">
                <!-- <i class="fs-4 fa-solid fa-circle"></i> -->
                <span class="material-symbols-rounded">
                    person
                </span>

                <h5>MY PROFILE</h5>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="w-100 h-100 overflow-auto position-relative d-flex flex-column">
        <div class="w-100 d-flex align-items-center justify-content-center">
            <div class="w-100 position-relative profileBoard d-flex justify-content-center justify-content-md-start">
                <div
                    class="overflow-hidden d-flex align-items-center justify-content-center bg-primary bg-opacity-25 w-100 coverPhoto">

                    <?php if ($usersDetails['coverPhoto']) { ?>
                        <img src="<?= $usersDetails['coverPhoto'] ?>" alt="coverPhoto" class="">
                    <?php } ?>

                </div>

                <div class="position-absolute p-4 pt-5">
                    <div
                        class="position-relative profilePicture d-flex align-items-center justify-content-center bg-light border border-2 border-primary">
                        <div class="overflow-hidden rounded-circle">

                            <?php if ($usersDetails['profilePicture']) { ?>
                                <img src="<?= $usersDetails['profilePicture'] ?>" alt="profilePicture" class="">
                            <?php } else { ?>
                                <span class="material-symbols-rounded picture">
                                    person
                                </span>
                            <?php } ?>

                        </div>

                        <button type="button" role="button" data-bs-toggle="dropdown" aria-expanded="false"
                            class="text-light d-flex align-items-center justify-content-center focus-ring focus-ring-primary border-2 border border-primary bg-primary position-absolute borderRadiusFull">
                            <span class="material-symbols-rounded fs-2">
                                arrow_drop_down
                            </span>
                        </button>

                        <ul class="dropdown-menu dropdown-menu-start m-2 p-1 border-0 shadow rounded-3">
                            <li class="dropdown-item p-0 rounded">
                                <a data-bs-toggle="modal"
                                    class="viewProfilePictureBtn focus-ring focus-ring-primary rounded-1 px-4 p-3 btn btn-outline-primary border-0 border d-flex align-items-center gap-3"
                                    href="#modalFP">
                                    <span class="material-symbols-rounded">
                                        photo
                                    </span>

                                    View Profile Picture
                                </a>
                            </li>
                            <li class="dropdown-item p-0 rounded">
                                <a data-bs-toggle="modal"
                                    class="updateProfilePicture focus-ring focus-ring-primary rounded-1 px-4 py-3 btn btn-outline-primary border-0 border d-flex align-items-center gap-3"
                                    href="#modal">
                                    <span class="material-symbols-rounded">
                                        filter
                                    </span>

                                    Update Profile Picture
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <div class="w-100 p-4 pt-5 border-1 border-bottom border-primary text-md-start text-center">
            <h3>
                <?= $usersDetails['firstName'] . ($usersDetails['middleName'] ? " " . $usersDetails['middleName'] : "") . " " . $usersDetails['lastName'] . ($usersDetails['suffix'] ? " " . $usersDetails['suffix'] : ""); ?>
            </h3>
        </div>

        <div class="fs-5 w-100 d-flex flex-column gap-3 justify-content-center align-items-center">
            <div class="w-100 p-4 row m-0 row-gap-5">
                <div class="col-lg-6 col-12 p-0 d-flex flex-column gap-3">
                    <div>
                        <h5>Other Personal Information</h5>
                    </div>
                    <div class="d-flex gap-3 align-items-center">
                        <span class="material-symbols-rounded">
                            <?= $usersDetails['gender'] ?>
                        </span>
                        <p>
                            <?= $usersDetails['gender'] ?>
                        </p>
                    </div>
                    <div class="d-flex gap-3 align-items-center">
                        <span class="material-symbols-rounded">
                            event
                        </span>
                        <p>
                            <?= $usersDetails['birthDate'] ?>
                        </p>
                    </div>
                    <div class="d-flex gap-3 align-items-center">
                        <span class="material-symbols-rounded">
                            calendar_clock
                        </span>
                        <p>
                            <?= $usersDetails['age'] ?> Years Old
                        </p>
                    </div>
                </div>

                <div class="col-lg-6 col-12 p-0 d-flex flex-column gap-3">
                    <div>
                        <h5>Contact Information</h5>
                    </div>
                    <div class="d-flex gap-3 align-items-center">
                        <span class="material-symbols-rounded">
                            phone
                        </span>
                        <p>
                            <?= $usersDetails['contactNumber'] ?>
                        </p>
                    </div>
                    <div class="d-flex gap-3 align-items-center">
                        <span class="material-symbols-rounded">
                            mail
                        </span>
                        <p>
                            <?= $usersDetails['emailAddress'] ?>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<!-- Modal -->
<?php $this->load->view('simple_crud/components/Modal'); ?>