<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Users extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();

        // Helpers
        $this->load->helper('form');

        // Models
        $this->load->model('simple_crud/AuthenticationModel', 'Authenticate');
        $this->load->model('simple_crud/UsersModel', 'Users');

        // Libraries
        $this->load->library('form_validation');
        $this->load->library('pagination');

        $this->Authenticate->users();
    }

    public function index($viewsData = "")
    {
        // * Default View Variables
        if (!$viewsData) {
            $activeUsers = $this->Users->activeUsers();
            $inactiveUsers = $this->Users->inactiveUsers();
            $totalRows = $this->Users->searchUsers("", "", "", "", "", TRUE);

            // echo '<script> console.log(`Active: `, ' . json_encode($inactiveUsers) . '); </script>';

            $viewsData = array(
                "view" => "simple_crud/users/DashBoard",
                "cards" => array(
                    "usersList" => array(
                        "cardTotalNumber" => $totalRows,
                        "cardTitle" => "USERS",
                        "cardIcon" => "person",
                        "cardTextColor" => "text-primary"
                    ),
                    "activeUsers" => array(
                        "cardTotalNumber" => $activeUsers,
                        "cardTitle" => "ACTIVE USERS",
                        "cardIcon" => "person_check",
                        "cardTextColor" => "text-success"
                    ),
                    "inactiveUsers" => array(
                        "cardTotalNumber" => $inactiveUsers,
                        "cardTitle" => "INACTIVE USERS",
                        "cardIcon" => "person_cancel",
                        "cardTextColor" => "text-danger"
                    )
                )
            );
        }

        // echo '<script> console.log(`User Data: `, ' . json_encode($this->session->userdata('usersDetails')) . '); </script>';

        $userDetails = $this->session->userdata();

        $userDetails['usersDetails']['coverPhoto'] = "https://passion-stickers.com/5210-large_default/lilo-of-lilo-and-stitch.jpg";
        $userDetails['usersDetails']['profilePicture'] = "https://passion-stickers.com/5210-large_default/lilo-of-lilo-and-stitch.jpg";
        
        $this->session->set_userdata($userDetails);

        // echo '<script> console.log(`User Data: `, ' . json_encode($userDetails) . '); </script>';

        // $this->session->userdata('usersDetails')['coverPhoto'] = "https://passion-stickers.com/5210-large_default/lilo-of-lilo-and-stitch.jpg";
        // $this->session->userdata('usersDetails')['profilePicture'] = "https://passion-stickers.com/5210-large_default/lilo-of-lilo-and-stitch.jpg";

        echo '<script> console.log(`User Data: `, ' . json_encode($this->session->userdata('usersDetails')) . '); </script>';

        // * Main View Variables
        $viewsMainData = array(
            "documentData" => array(
                "title" => "| " . $this->session->userdata('usersDetails')['firstName'] . " " . $this->session->userdata('usersDetails')['lastName'],
                "css" => "",
                "script" => "Users"
            ),
            "usersDetails" => array(
                "usersID" => $this->session->userdata('usersDetails')['usersID'],
                "firstName" => $this->session->userdata('usersDetails')['firstName'],
                "middleName" => $this->session->userdata('usersDetails')['middleName'] ? substr($this->session->userdata('usersDetails')['middleName'], 0, 1) : "",
                "lastName" => $this->session->userdata('usersDetails')['lastName'],
                "suffix" => $this->session->userdata('usersDetails')['suffix'] ? $this->session->userdata('usersDetails')['suffix'] : "",
                "gender" => $this->session->userdata('usersDetails')['gender'],
                "birthDate" => date("M d, Y", strtotime($this->session->userdata('usersDetails')['birthDate'])),
                "age" => $this->session->userdata('usersDetails')['age'],
                "contactNumber" => $this->session->userdata('usersDetails')['contactNumber'],
                "emailAddress" => $this->session->userdata('usersDetails')['emailAddress'],
                "coverPhoto" => $this->session->userdata('usersDetails')['coverPhoto'],
                "profilePicture" => $this->session->userdata('usersDetails')['profilePicture'],
            ),
            "viewsData" => $viewsData,
            "sideBar" => array(
                "anchor" => array(
                    array(
                        "baseURL" => "simple_crud/users",
                        "icon" => "space_dashboard",
                        "linkName" => "Dashboard"
                    ),
                    array(
                        "baseURL" => "simple_crud/users/users_list",
                        "icon" => "user_attributes",
                        "linkName" => "Users List"
                    ),
                    array(
                        "baseURL" => "simple_crud/users/my_profile",
                        "icon" => "person",
                        "linkName" => "My Profile"
                    )
                ),
                "dropDown" => array(
                    array(
                        "icon" => "settings",
                        "linkName" => "Settings",
                        "links" => array(
                            array(
                                "baseURL" => "simple_crud/users/edit_my_profile",
                                "icon" => "person_edit",
                                "linkName" => "Edit My Profile"
                            ),
                            array(
                                "baseURL" => "simple_crud/users/change_password",
                                "icon" => "passkey",
                                "linkName" => "Change Password"
                            )
                        )
                    )
                )
            )

        );

        // Views
        $this->load->view('simple_crud/components/Header', $viewsMainData);
        $this->load->view('simple_crud/users/Users', $viewsMainData);
        $this->load->view('simple_crud/components/Footer', $viewsMainData);

        // echo '<script> console.log(`Views Data: `, ' . json_encode($viewsMainData) . '); </script>';
    }

    public function usersList()
    {
        // * Pagination
        $pageFilters = array(
            "5",
            "10",
            "20",
            "50",
            "100"
        );

        $startIndex = 0;
        $totalRows = 0;
        $dbTotalRows = $this->Users->searchUsers("", "", "", "", "", TRUE);

        // echo '<script> console.log(`DB Row Count (Controller): `, ' . json_encode($dbTotalRows) . '); </script>';

        $page = $this->input->get('page') ? $this->input->get('page') : 0;
        $rowFilter = $this->input->get('rowFilter') ? $this->input->get('rowFilter') : 0;
        $searchFor = $this->input->get('searchFor') ? $this->input->get('searchFor') : "";
        $sortBy = $this->input->get('sortBy') ? $this->input->get('sortBy') : "USERS_ID";
        $orderBy = $this->input->get('orderBy') ? $this->input->get('orderBy') : "ASC";

        // if($this->input->get('page')) {
        //     $page = $this->input->get('page');
        // }

        // if($this->input->get('rowFilter')) {
        //     $rowFilter = $this->input->get('rowFilter');
        // }

        if ($page != 0) {
            $startIndex = $rowFilter * ($page - 1);
        }

        // echo '<script> console.log(`Page (Controller): `, ' . json_encode($page) . '); </script>';
        // echo '<script> console.log(`Page Filter (Controller): `, ' . json_encode($rowFilter) . '); </script>';
        // echo '<script> console.log(`Start Index (Controller): `, ' . json_encode($startIndex) . '); </script>';

        if ($searchFor) {
            $usersListSeeds = $this->Users->searchUsers($sortBy, $orderBy, $rowFilter, $startIndex, $searchFor, FALSE);
            $totalRows = $this->Users->searchUsers("", "", "", "", $searchFor, TRUE);
        } else {
            $usersListSeeds = $this->Users->searchUsers($sortBy, $orderBy, $rowFilter, $startIndex, "", FALSE);
            $totalRows = $this->Users->searchUsers("", "", "", "", "", TRUE);
        }

        // * Pagination Configurations
        $paginationConfig['base_url'] = base_url('simple_crud/users/users_list');
        $paginationConfig['attributes'] = array('class' => 'page-link bg-primary bg-opacity-10 fs-6 p-3 px-4 border-0 btn btn-primary d-flex justify-content-center align-items-center');
        $paginationConfig['total_rows'] = $totalRows;
        $paginationConfig['per_page'] = $rowFilter;
        $paginationConfig['num_links'] = 1;
        $paginationConfig['enable_query_strings'] = TRUE;
        $paginationConfig['use_page_numbers'] = TRUE;
        $paginationConfig['page_query_string'] = TRUE;
        $paginationConfig['query_string_segment'] = 'page';
        $paginationConfig['reuse_query_string'] = TRUE;
        $paginationConfig['full_tag_open'] = '<ul class="pagination pagination-lg justify-content-center flex-wrap align-items-center gap-2 m-0">';
        $paginationConfig['full_tag_close'] = '</ul>';
        $paginationConfig['first_link'] = '<span class="material-symbols-rounded">keyboard_double_arrow_left</span> First';
        $paginationConfig['first_tag_open'] = '<li class="page-item">';
        $paginationConfig['first_tag_close'] = '</li>';
        $paginationConfig['prev_link'] = '<span class="material-symbols-rounded">keyboard_arrow_left</span> Previous';
        $paginationConfig['prev_tag_open'] = '<li class="page-item">';
        $paginationConfig['prev_tag_close'] = '</li>';
        $paginationConfig['next_link'] = 'Next <span class="material-symbols-rounded">keyboard_arrow_right</span>';
        $paginationConfig['next_tag_open'] = '<li class="page-item">';
        $paginationConfig['next_tag_close'] = '</li>';
        $paginationConfig['last_link'] = 'Last <span class="material-symbols-rounded">keyboard_double_arrow_right</span>';
        $paginationConfig['last_tag_open'] = '<li class="page-item">';
        $paginationConfig['last_tag_close'] = '</li>';
        $paginationConfig['cur_tag_open'] = '<li class="page-item active"><a href="#" class="page-link fs-6 p-3 px-4 border-0 btn btn-primary">';
        $paginationConfig['cur_tag_close'] = '</a></li>';
        $paginationConfig['num_tag_open'] = '<li class="page-item">';
        $paginationConfig['num_tag_close'] = '</li>';

        // * Initialize the Pagination
        $this->pagination->initialize($paginationConfig);

        // echo '<script> console.log(`Pagination: `, ' . json_encode($pagination) . '); </script>';

        // * Table
        // $usersListSeeds = $this->Users->usersListSeeds();
        // $usersList = $this->Users->usersList();

        // * Table Columns to be shown
        $tableColumns = array(
            array("tableColumn" => "FIRST NAME", "dbColumn" => "FIRST_NAME"),
            array("tableColumn" => "MIDDLE NAME", "dbColumn" => "MIDDLE_NAME"),
            array("tableColumn" => "LAST NAME", "dbColumn" => "LAST_NAME"),
            array("tableColumn" => "SUFFIX", "dbColumn" => "SUFFIX"),
            array("tableColumn" => "GENDER", "dbColumn" => "GENDER"),
            array("tableColumn" => "BIRTH DATE", "dbColumn" => "BIRTH_DATE"),
            array("tableColumn" => "AGE", "dbColumn" => "AGE"),
            array("tableColumn" => "CONTACT NUMBER", "dbColumn" => "CONTACT_NUMBER"),
            array("tableColumn" => "EMAIL ADDRESS", "dbColumn" => "EMAIL_ADDRESS"),
            array("tableColumn" => "STATUS", "dbColumn" => "STATUS")
        );

        // * Table Columns not to be shown
        $tableColumnsNotShown = array(
            "USERS_ID",
            "USER_TYPE",
            "PASSWORD",
            "CREATED_DATE",
        );

        $itemTo = min((int) $totalRows, ((int) $startIndex + (int) $rowFilter));

        // * View Data
        $viewsData = array(
            "view" => "simple_crud/users/UsersList",
            "usersSeedsTable" => array(
                "tableData" => $usersListSeeds,
                "tableColumns" => $tableColumns,
                "tableColumnsNotShown" => $tableColumnsNotShown
            ),
            // "usersTable" => array(
            //     "tableData" => $usersList,
            //     "tableColumns" => $tableColumns,
            //     "tableColumnsNotShown" => $tableColumnsNotShown
            // ),
            "page" => $page,
            "itemTo" => $itemTo ? $itemTo : $totalRows,
            "pageFilters" => $pageFilters,
            "startIndex" => $startIndex,
            "rowFilter" => $rowFilter,
            "searchFor" => $searchFor,
            "sortBy" => $sortBy,
            "orderBy" => $orderBy,
            "totalRows" => $totalRows,
            "dbTotalRows" => $dbTotalRows,
            "paginationLinks" => $this->pagination->create_links()
        );

        $this->index($viewsData);
    }

    public function myProfile()
    {
        $viewsData = array(
            "view" => "simple_crud/users/MyProfile",
        );

        $this->index($viewsData);
    }

    public function editMyProfile()
    {
        $viewsData = array(
            "view" => "simple_crud/users/EditMyProfile",
        );

        $this->index($viewsData);
    }

    public function changePassword()
    {
        $viewsData = array(
            "view" => "simple_crud/users/ChangePassword",
        );

        $this->index($viewsData);
    }

    public function viewProfilePicture()
    {
        log_message('info', 'Log Info');

        $profilePicture = array(
            "profilePicture" => $this->session->userdata('usersDetails')['profilePicture'],
        );

        $modal = array(
            "modalHeader" => array(
                "title" => "View Profile Picture",
                "titleLogo" => "photo",
                "titleTextColor" => "text-primary"
            ),
            "modalBody" => $this->load->view('simple_crud/users/ViewProfilePicture', $profilePicture, TRUE),
            // "modalFooter" => "",
        );

        // echo $this->load->view('simple_crud/users/ViewProfilePicture', $profilePicture, TRUE);

        // echo json_encode(array("" => ""));

        echo json_encode($modal);
    }
}