var path = require('path')
var webpack = require('webpack')
var ExtractTextPlugin = require('extract-text-webpack-plugin')

// Common to 'dev' and 'prod' environments
module.exports = {
    entry: [
      './src/js/main.js'
    ],
    output: {
      path: path.resolve(__dirname, './dist'),
      publicPath: '/dist/',
      filename: 'build.js'
    },
    module: {
      rules: [
        {
          test: /\.css$/,
          use: [ 'style-loader', 'css-loader' ]
        },
        {
          test: /\.vue$/,
          loader: 'vue-loader',
          options: {
            loaders: {
            }
          }
        },
        {
          test: /\.js$/,
          loader: 'babel-loader',
          exclude: /node_modules/
        },
        {
          test: /\.(png|jpg|gif|svg)$/,
          loader: 'file-loader',
          options: {
            name: '[name].[ext]?[hash]'
          }
        },
        { test: /\.svg$/, use: 'url-loader?limit=65000&mimetype=image/svg+xml&name=public/fonts/[name].[ext]' },
        { test: /\.woff$/, use: 'url-loader?limit=65000&mimetype=application/font-woff&name=public/fonts/[name].[ext]' },
        { test: /\.woff2$/, use: 'url-loader?limit=65000&mimetype=application/font-woff2&name=public/fonts/[name].[ext]' },
        { test: /\.[ot]tf$/, use: 'url-loader?limit=65000&mimetype=application/octet-stream&name=public/fonts/[name].[ext]' },
        { test: /\.eot$/, use: 'url-loader?limit=65000&mimetype=application/vnd.ms-fontobject&name=public/fonts/[name].[ext]' }
      ]
    },
    resolve: {
      alias: {
        'vue$': 'vue/dist/vue.common.js',
        'tippy$': 'tippy.js/dist/tippy.js'
      }
    },
    performance: {
      hints: false
    }
}


// Specific to 'prod' environment
if (process.env.NODE_ENV === 'production') {

  module.exports.module.rules = (module.exports.module.rules || []).concat([
    {
      test: /\.less$/,
      use: ExtractTextPlugin.extract({
        fallback: 'style-loader',
        use: [
          'css-loader?importLoaders=1',
          'postcss-loader',
          'less-loader'
        ]
      })
    }
  ])

  module.exports.devtool = '#source-map'

  module.exports.plugins = [
    new ExtractTextPlugin('style.css'),
    new webpack.DefinePlugin({
      'process.env': {
        NODE_ENV: '"production"'
      }
    }),
    new webpack.optimize.UglifyJsPlugin({
      sourceMap: true,
      compress: {
        warnings: false
      }
    }),
    new webpack.LoaderOptionsPlugin({
      minimize: true
    })
  ]
} 

// Specific to 'dev' environment
else {

  module.exports.module.rules = (module.exports.module.rules || []).concat([
    {
      test: /\.less$/,
      use: [
        'style-loader',
        'css-loader?importLoaders=1',
        'postcss-loader',
        'less-loader'
      ]
    }
  ])

  module.exports.devServer = {
    historyApiFallback: true,
    noInfo: true,
    watchOptions: {
      aggregateTimeout: 300,
      poll: 1000
    },
    host: "192.168.33.10" // <--- If you work with vagrant
  }

  module.exports.devtool = '#eval-source-map'
}
