# Argon & Benzene - SPI NOR Flash programmer & reader

![schema](img/banner2.jpg)

### ◾ About the project

This project consists of two boards: **Argon** and **Benzene**.

<img align="left" width="100" height="100" src="http://alicja.space/argon-logo.png"> **Argon** is a SPI NOR flash programmer & reader. It's based on the FT2232H microcontroller (with two UARTs - A & B). The board has three LED indicators of data - on TX, RX and CS lines and some sockets to be able to plug in the logic analyzer. Version 1.0 of Argon is available [in the releases section](https://github.com/alicjamusial/argon/releases/tag/argon-1.0). 

<br>

<img align="left" width="100" height="100" src="http://alicja.space/benzene2.png"> **Benzene** is a DIP-8/DIP-16 to Argon adapter. It includes mostly a few capacitors and resistors to allow SPI flash to run smoothly. There is also a 555 timer with LED indicator on CS line goldpins to attach the logic analyzer.
Version 1.0 of Benzene is available [in the releases section](https://github.com/alicjamusial/argon/releases/tag/benzene-1.0).

<br>
Argon works best with Benzene attached - they are designed to match each other (you can put two Benzene boards on top of the Argon). Argon can be also used separately as USB<->UART/FIFO/I2C/SPI converter (similar to FTDI Mini Module). 

Both boards were designed using [KiCad 5.1.6](https://kicad.org/).

### ◾ Software
Argon software is available in [this repository](https://github.com/alicjamusial/argon-driver).


### ◾ Known issues
**Argon 1.1**
- No known issues, but wasn't assembled yet.

**Benzene 1.0**
- Logo is too small and illegible (not very important, so won't be fixed by now)

**Project**
- KiCad libraries are a bit chaotic (not very important, so won't be fixed by now)

### ◾ Usage examples
![schema](img/usage.jpg)
Argon is meant to be used as SPI NOR flash reader & writer with:
- Benzene & flash soldered to DIP-8/DIP-16 board adapter
- Benzene & flash inside DIP-8/DIP-16 adapter
- Benzene & clip with DIP-8/16 adapter to read or program flash placed on another board

It can be also used standalone as USB<->UART/FIFO/I2C/SPI converter (all FTDI Mini Module functionalities in the nicer and more readable form).

Note: all photos show Argon in version 1.0.


### ◾ Schematics and designs
All of them can be found [in the releases section](https://github.com/alicjamusial/argon/releases) as KiCad files, gerber files, pdf and svg format.

#### ▪️ Argon 1.1
![schema](releases/argon-1.1/argon.svg)
![board](releases/argon-1.1/argon-brd.svg)
![3d_front](releases/argon-1.1/argon.png)
![3d_back](releases/argon-1.1/argon_back.png)
![3d](releases/argon-1.1/argon_3d.png)

#### ▪️ Benzene 1.0
![schema](releases/benzene-1.0/benzene.svg)
![board](releases/benzene-1.0/benzene-brd.svg)
![3d_front](releases/benzene-1.0/benzene_front.png)
![3d_back](releases/benzene-1.0/benzene_back.png)
![3d](releases/benzene-1.0/benzene_3d.png)

### ◾ Other hints
When assembling your own Argon or Benzene please use LED's resistors calculated for your chosen colours.

### ◾ License
Argon and Benzene are available on Creative Commons Attribution Share Alike 4.0 International license (more in [license file](LICENSE.txt)). You are free to use it, modify it and produce as many of your own boards as you need :)
