# coding=utf-8
# Copyright 2021-2022 The Alibaba DAMO NLP Team Authors.
# All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import os
from .compat import _report_compat_error

_report_compat_error()
sofa_backend = os.environ["SOFA_BACKEND"]
"""
Select the proper tokenizer class according to the runtime backend.
"""
if sofa_backend == "huggingface":
    import transformers
    _is_control = transformers.tokenization_utils._is_control
    _is_punctuation = transformers.tokenization_utils._is_punctuation
    _is_whitespace = transformers.tokenization_utils._is_whitespace
    PreTrainedTokenizer = transformers.tokenization_utils.PreTrainedTokenizer
    AddedToken = transformers.AddedToken
    BatchEncoding = transformers.BatchEncoding
elif sofa_backend == "easytexminer":
    import easytexminer.model_zoo
    _is_control = easytexminer.model_zoo.tokenization_utils._is_control
    _is_punctuation = easytexminer.model_zoo.tokenization_utils._is_punctuation
    _is_whitespace = easytexminer.model_zoo.tokenization_utils._is_whitespace
    PreTrainedTokenizer = easytexminer.model_zoo.tokenization_utils.PreTrainedTokenizer
    AddedToken = easytexminer.model_zoo.AddedToken
    BatchEncoding = easytexminer.model_zoo.BatchEncoding
elif sofa_backend == "easynlp":
    import easynlp.modelzoo
    _is_control = easynlp.modelzoo.tokenization_utils._is_control
    _is_punctuation = easynlp.modelzoo.tokenization_utils._is_punctuation
    _is_whitespace = easynlp.modelzoo.tokenization_utils._is_whitespace
    PreTrainedTokenizer = easynlp.modelzoo.tokenization_utils.PreTrainedTokenizer
    AddedToken = easynlp.modelzoo.AddedToken
    BatchEncoding = easynlp.modelzoo.BatchEncoding
elif sofa_backend == "sofa":
    from .backend import tokenization_utils
    _is_control = tokenization_utils._is_control
    _is_punctuation = tokenization_utils._is_punctuation
    _is_whitespace = tokenization_utils._is_whitespace
    PreTrainedTokenizer = tokenization_utils.PreTrainedTokenizer
    AddedToken = tokenization_utils.AddedToken
    BatchEncoding = tokenization_utils.BatchEncoding

