/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.spdf;

import com.darwinsys.spdf.PDFDict;
import com.darwinsys.spdf.PDFObject;
import com.darwinsys.spdf.Page;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class PDF {
    protected static final String PDF_MAGIC = "%PDF-1.0";
    protected PrintWriter out;
    protected ArrayList pages;
    protected ArrayList xrefs;
    PDFObject rootObj;
    InfoObject infoObj;
    OutlinesObject outlinesObj;
    PagesObject pagesObj;
    FontDict fontDict;
    protected int currObj;
    protected boolean startedWriting;
    long offset;
    DecimalFormat nf10;
    DecimalFormat nf5;
    long xrefStart;

    public void add(Page page) {
        this.pages.add(page);
    }

    public void insertPage(int n, Page page) {
        this.pages.add(n, page);
    }

    protected void print(String string) {
        this.out.print(string);
        this.offset += (long)string.length();
    }

    protected void println(String string) {
        this.print(string);
        this.print("\n");
    }

    protected void print(Object object) {
        this.print(object.toString());
    }

    protected void println(Object object) {
        this.println(object.toString());
    }

    protected void print(int n) {
        String string = Integer.toString(n);
        this.print(string);
    }

    protected void println(int n) {
        String string = Integer.toString(n);
        this.print(string);
    }

    protected void println() {
        this.print("\n");
    }

    protected void addXref() {
        this.xrefs.add(new Long(this.offset));
    }

    public void writePDF() {
        if (this.startedWriting) {
            throw new IllegalStateException("writePDF() can only be called once.");
        }
        this.startedWriting = true;
        this.writePDFHeader();
        this.writePDFbody();
        this.writeXrefs();
        this.writePDFTrailer();
        this.out.flush();
        this.out.close();
    }

    protected void writePDFHeader() {
        this.println(PDF_MAGIC);
        this.rootObj.print();
        this.infoObj.print();
        this.outlinesObj.print();
        this.pagesObj.print();
    }

    protected void writePDFbody() {
        int n = 0;
        while (n < this.pages.size()) {
            ((Page)this.pages.get(n)).print();
            ++n;
        }
        this.addXref();
        this.print(this.currObj++);
        this.println(" 0 obj");
        this.println("[/PDF /Text]");
        this.println("endobj");
        this.fontDict.print();
    }

    protected void printXref(long l, int n, char c) {
        this.println(this.nf10.format(l) + " " + this.nf5.format(n) + " " + c);
    }

    protected void writeXrefs() {
        this.xrefStart = this.offset;
        this.println("xref");
        this.print(0);
        this.print(" ");
        this.print(this.xrefs.size() + 1);
        this.println();
        this.printXref(0L, 65535, 'f');
        int n = 0;
        while (n < this.xrefs.size()) {
            Long l = (Long)this.xrefs.get(n);
            long l2 = l;
            this.printXref(l2, 0, 'n');
            ++n;
        }
    }

    protected void writePDFTrailer() {
        this.println("trailer");
        this.println("<<");
        this.println("/Size " + (this.xrefs.size() + 1));
        this.println("/Root 1 0 R");
        this.println("/Info 2 0 R");
        this.println(">>");
        this.println("% startxref");
        this.println("% " + this.xrefStart);
        this.println("%%EOF");
    }

    public void setAuthor(String string) {
        this.infoObj.dict.put("Author", "(" + string + ")");
    }

    public PDF(PrintWriter printWriter) {
        PDF pDF = this;
        if (pDF == null) {
            throw null;
        }
        this.rootObj = pDF.new RootObject(this);
        PDF pDF2 = this;
        if (pDF2 == null) {
            throw null;
        }
        this.infoObj = pDF2.new InfoObject(this);
        PDF pDF3 = this;
        if (pDF3 == null) {
            throw null;
        }
        this.outlinesObj = pDF3.new OutlinesObject(this);
        PDF pDF4 = this;
        if (pDF4 == null) {
            throw null;
        }
        this.pagesObj = pDF4.new PagesObject(this);
        PDF pDF5 = this;
        if (pDF5 == null) {
            throw null;
        }
        this.fontDict = pDF5.new FontDict(this);
        this.currObj = 1;
        this.startedWriting = false;
        this.offset = 0L;
        this.nf10 = new DecimalFormat("0000000000");
        this.nf5 = new DecimalFormat("00000");
        this.out = printWriter;
        this.pages = new ArrayList();
        this.xrefs = new ArrayList();
    }

    class RootObject
    extends PDFDict {
        protected RootObject(PDF pDF2) {
            super(pDF2);
            this.dict.put("Type", "/Catalog");
            this.dict.put("Outlines", "3 0 R");
            this.dict.put("Pages", "4 0 R");
        }
    }

    class InfoObject
    extends PDFDict {
        protected InfoObject(PDF pDF2) {
            super(pDF2);
            this.dict.put("Title", "(Sample PDF by SPDF)");
            this.dict.put("Creator", "(Darwin Open Systems SPDF Software)");
            this.dict.put("Created", "(D:20000516010203)");
        }
    }

    class OutlinesObject
    extends PDFDict {
        protected OutlinesObject(PDF pDF2) {
            super(pDF2);
            this.dict.put("Type", "/Outlines");
            this.dict.put("Count", "0");
        }
    }

    class PagesObject
    extends PDFDict {
        protected PagesObject(PDF pDF2) {
            super(pDF2);
            this.dict.put("Type", "/Pages");
            this.dict.put("Count", "1");
            this.dict.put("Kids", "[5 0 R]");
        }
    }

    class FontDict
    extends PDFDict {
        protected FontDict(PDF pDF2) {
            super(pDF2);
            this.dict.put("Type", "/Font");
            this.dict.put("Subtype", "/Type1");
            this.dict.put("Name", "/F1");
            this.dict.put("BaseFont", "/Helvetica");
            this.dict.put("Encoding", "/MacRomanEncoding");
        }
    }
}

