import { INestApplication } from '@nestjs/common';
import { expect } from 'chai';
import * as request from 'supertest';
import { createTestAppModule } from './helpers';

describe('E2e tests related to the MongoPagination ParamDecorator', () => {
  let app: INestApplication;

  beforeAll(async () => {
    app = await createTestAppModule();
    await app.init();
  });

  afterAll(async () => {
    await app.close();
  });

  describe('Tests with a pagination query', () => {
    it('MPPDE01 - should successfully create the mongoQuery from the request', async () => {
      const res: request.Response = await request(app.getHttpServer())
        .get(
          '/pagination?page=5&per_page=35&sort=%7B%22createdAt%22%3A-1%7D&project=%7B%22id%22%3A1%2C%22applicationId%22%3A1%7D&filter=%7B%22status%22%3A%7B%22%24options%22%3A%22i%22%2C%22%24regex%22%3A%22ACCEPTED%22%7D%2C%22%24where%22%3A%22function%20%28%29%20%7B%20return%20true%3B%20%7D%22%7D',
        )
        .expect(200);

      expect(res.body.pagination).to.deep.equal({
        filter: {
          status: {
            $options: 'i',
            $regex: 'ACCEPTED',
          },
        },
        limit: 35,
        skip: 140,
        sort: {
          createdAt: -1,
        },
        project: {
          id: 1,
          applicationId: 1,
        },
      });
    });

    it('MPPDE02 - should successfully create the mongoQuery from the request with query pagination', async () => {
      const res: request.Response = await request(app.getHttpServer()).get('/pagination?page=5&limit=10').expect(200);

      expect(res.body.pagination).to.deep.equal({
        filter: {},
        limit: 200,
        project: {},
        skip: 800,
        sort: {},
      });
    });
  });
});
