# F I N F O C U S

## About

_FinFocus_ is a trusted provider of financial news and services for individuals and businesses alike.

With rising prices for essential goods and services, COVID impact, global inflation & local currency devaluation put a strain on households budgets and created significant implications for many families. _FinFocus_ is a financial portal concept that provides latest insights on the news, access to the latest stock/shares values and crypto exchange rates.

### User story

Project has been created with a user in mind - a finance novice interested in all things economics and finance.

> As a financial novice interested in all things economics and finance to help strengthen my financial savings and investments portfolio, I want to:
>
> - [x] Have access to financial articles for the latest insights
> - [x] Search articles by keyword
> - [x] Save top articles for later and access them anytime
> - [x] Have the latest information for crypto exchange rates against USD
> - [x] Get the latest stocks and shares updates
> - [x] Find financial news categories
> - [x] See live exchange status
> - [x] Know about the financial news provider by accessing it's about and contact pages

## Web app

Web application build with JavaScript/jQuery and Bootstrap for pages structure and featuring detailed and minimal responsive desing.

### Features:

- [x] Easy to navigate financial news website
- [x] Pages: main, about, contact and terms.
- [x] Financial news rendered in several categories with featured articles
- [x] Add articles to favourites and retain them between refreshes
- [x] Search NY times financial articles by keywords
- [x] Full list of top articles in the aside section
- [x] Sliders with stock and crypto data (swiperjs)
- [x] Current date and weather display in the header
- [x] Sticky on page navigation
- [x] Footer on-site global navigation
- [x] On scroll animations on about and terms pages

### Tools:

- [Jquery](https://jquery.com/)
- [Bootstrap](https://getbootstrap.com/docs/5.3/getting-started/introduction/)
- [Moment.js](https://momentjs.com/)
- [Swiper.js](https://swiperjs.com/)
- [AOS](https://github.com/michalsnik/aos)
- [PureCounter](https://github.com/srexi/purecounterjs)

### [View Project](https://alexandrabatrak.github.io/fin-focus)

![screenshot](/assets/img/screenshot.png)
![about](/assets/img/screenshot-about.png)
![contact](/assets/img/screenshot-contact.png)

### Future development plans

- Separate section for more stock display with filter and sorting options
- Integrate the option to search historical data for stocks and crypto
- Have an option to favourite selected crypto/stocks to follow
- Introduce another news API to expand the scope of news
- Add on-site search
- Live currency converter

## Credits

- [Bunny Fonts](https://fonts.bunny.net) :rabbit2: [The Barlow Project Authors](https://github.com/jpt/barlow) & [The Cormorant Project Authors](github.com/CatharsisFonts/Cormorant)
- [FontAwesome](https://fontawesome.com/)

API

- [NY Times](https://developer.nytimes.com/)
- [Polygon.io](https://polygon.io/docs/stocks/getting-started)
- [OpenWeatherMap](https://openweathermap.org/api)

Other

- [MidJourney](https://midjourney.com/)
- [Unsplash](https://unsplash.com/)
- @alexandrabatrak's endless attention to detail :ok_hand:

## Contributors

_Lost Mary_ development team:

- [@alexandrabatrak](https://github.com/alexandrabatrak) Alexandra Batrak
- [@mrBimsy](https://github.com/mrBimsy) Damian Rosiak
- [@ademolaalashe](https://github.com/ademolaalashe) Ademola Alashe

## Licence

Licenced under the [CC BY-NC 4.0](https://creativecommons.org/licenses/by-nc/4.0/) license.

[![Image of github-profile-views-counter](https://github.com/alexandrabatrak/github-profile-views-counter/blob/master/svg/598676123/badge.svg)](https://github.com/alexandrabatrak/github-profile-views-counter/blob/master/readme/598676123/week.md)

_Copyright © 2023 Lost Mary_
