#ifndef SINCOS_H
#define SINCOS_H

const u8 precalculated_sin_table[] = {
    0x7F, 0x81, 0x82, 0x84, 0x86, 0x87, 0x89, 0x8A,
    0x8C, 0x8D, 0x8F, 0x90, 0x92, 0x94, 0x95, 0x97,
    0x98, 0x9A, 0x9B, 0x9D, 0x9E, 0xA0, 0xA1, 0xA3,
    0xA4, 0xA6, 0xA7, 0xA9, 0xAA, 0xAC, 0xAD, 0xAF,
    0xB0, 0xB1, 0xB3, 0xB4, 0xB6, 0xB7, 0xB9, 0xBA,
    0xBB, 0xBD, 0xBE, 0xBF, 0xC1, 0xC2, 0xC3, 0xC5,
    0xC6, 0xC7, 0xC9, 0xCA, 0xCB, 0xCC, 0xCE, 0xCF,
    0xD0, 0xD1, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7, 0xD8,
    0xD9, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF, 0xE0, 0xE1,
    0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE7, 0xE8,
    0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xED, 0xEE, 0xEF,
    0xF0, 0xF0, 0xF1, 0xF2, 0xF3, 0xF3, 0xF4, 0xF4,
    0xF5, 0xF6, 0xF6, 0xF7, 0xF7, 0xF8, 0xF8, 0xF9,
    0xF9, 0xFA, 0xFA, 0xFB, 0xFB, 0xFB, 0xFC, 0xFC,
    0xFC, 0xFD, 0xFD, 0xFD, 0xFD, 0xFE, 0xFE, 0xFE,
    0xFE, 0xFE, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFE,
    0xFE, 0xFE, 0xFE, 0xFE, 0xFD, 0xFD, 0xFD, 0xFD,
    0xFC, 0xFC, 0xFC, 0xFB, 0xFB, 0xFB, 0xFA, 0xFA,
    0xF9, 0xF9, 0xF8, 0xF8, 0xF7, 0xF7, 0xF6, 0xF6,
    0xF5, 0xF4, 0xF4, 0xF3, 0xF3, 0xF2, 0xF1, 0xF0,
    0xF0, 0xEF, 0xEE, 0xED, 0xED, 0xEC, 0xEB, 0xEA,
    0xE9, 0xE8, 0xE7, 0xE7, 0xE6, 0xE5, 0xE4, 0xE3,
    0xE2, 0xE1, 0xE0, 0xDF, 0xDE, 0xDD, 0xDC, 0xDB,
    0xD9, 0xD8, 0xD7, 0xD6, 0xD5, 0xD4, 0xD3, 0xD1,
    0xD0, 0xCF, 0xCE, 0xCC, 0xCB, 0xCA, 0xC9, 0xC7,
    0xC6, 0xC5, 0xC3, 0xC2, 0xC1, 0xBF, 0xBE, 0xBD,
    0xBB, 0xBA, 0xB9, 0xB7, 0xB6, 0xB4, 0xB3, 0xB1,
    0xB0, 0xAF, 0xAD, 0xAC, 0xAA, 0xA9, 0xA7, 0xA6,
    0xA4, 0xA3, 0xA1, 0xA0, 0x9E, 0x9D, 0x9B, 0x9A,
    0x98, 0x97, 0x95, 0x94, 0x92, 0x90, 0x8F, 0x8D,
    0x8C, 0x8A, 0x89, 0x87, 0x86, 0x84, 0x82, 0x81,
    0x7F, 0x7E, 0x7C, 0x7B, 0x79, 0x77, 0x76, 0x74,
    0x73, 0x71, 0x70, 0x6E, 0x6D, 0x6B, 0x69, 0x68,
    0x66, 0x65, 0x63, 0x62, 0x60, 0x5F, 0x5D, 0x5C,
    0x5A, 0x59, 0x57, 0x56, 0x54, 0x53, 0x51, 0x50,
    0x4E, 0x4D, 0x4C, 0x4A, 0x49, 0x47, 0x46, 0x45,
    0x43, 0x42, 0x40, 0x3F, 0x3E, 0x3C, 0x3B, 0x3A,
    0x38, 0x37, 0x36, 0x35, 0x33, 0x32, 0x31, 0x30,
    0x2E, 0x2D, 0x2C, 0x2B, 0x2A, 0x28, 0x27, 0x26,
    0x25, 0x24, 0x23, 0x22, 0x21, 0x20, 0x1F, 0x1E,
    0x1D, 0x1C, 0x1B, 0x1A, 0x19, 0x18, 0x17, 0x16,
    0x15, 0x14, 0x14, 0x13, 0x12, 0x11, 0x10, 0x10,
    0x0F, 0x0E, 0x0D, 0x0D, 0x0C, 0x0B, 0x0B, 0x0A,
    0x09, 0x09, 0x08, 0x08, 0x07, 0x07, 0x06, 0x06,
    0x05, 0x05, 0x04, 0x04, 0x04, 0x03, 0x03, 0x03,
    0x02, 0x02, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02,
    0x02, 0x03, 0x03, 0x03, 0x04, 0x04, 0x04, 0x05,
    0x05, 0x06, 0x06, 0x07, 0x07, 0x08, 0x08, 0x09,
    0x09, 0x0A, 0x0B, 0x0B, 0x0C, 0x0D, 0x0D, 0x0E,
    0x0F, 0x10, 0x10, 0x11, 0x12, 0x13, 0x14, 0x14,
    0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C,
    0x1D, 0x1E, 0x1F, 0x20, 0x21, 0x22, 0x23, 0x24,
    0x25, 0x26, 0x27, 0x28, 0x2A, 0x2B, 0x2C, 0x2D,
    0x2E, 0x30, 0x31, 0x32, 0x33, 0x35, 0x36, 0x37,
    0x38, 0x3A, 0x3B, 0x3C, 0x3E, 0x3F, 0x40, 0x42,
    0x43, 0x45, 0x46, 0x47, 0x49, 0x4A, 0x4C, 0x4D,
    0x4E, 0x50, 0x51, 0x53, 0x54, 0x56, 0x57, 0x59,
    0x5A, 0x5C, 0x5D, 0x5F, 0x60, 0x62, 0x63, 0x65,
    0x66, 0x68, 0x69, 0x6B, 0x6D, 0x6E, 0x70, 0x71,
    0x73, 0x74, 0x76, 0x77, 0x79, 0x7B, 0x7C, 0x7E};

const u8 precalculated_cos_table[] = {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFE,
    0xFE, 0xFE, 0xFE, 0xFE, 0xFD, 0xFD, 0xFD, 0xFD,
    0xFC, 0xFC, 0xFC, 0xFB, 0xFB, 0xFB, 0xFA, 0xFA,
    0xF9, 0xF9, 0xF8, 0xF8, 0xF7, 0xF7, 0xF6, 0xF6,
    0xF5, 0xF4, 0xF4, 0xF3, 0xF3, 0xF2, 0xF1, 0xF0,
    0xF0, 0xEF, 0xEE, 0xED, 0xED, 0xEC, 0xEB, 0xEA,
    0xE9, 0xE8, 0xE7, 0xE7, 0xE6, 0xE5, 0xE4, 0xE3,
    0xE2, 0xE1, 0xE0, 0xDF, 0xDE, 0xDD, 0xDC, 0xDB,
    0xD9, 0xD8, 0xD7, 0xD6, 0xD5, 0xD4, 0xD3, 0xD1,
    0xD0, 0xCF, 0xCE, 0xCC, 0xCB, 0xCA, 0xC9, 0xC7,
    0xC6, 0xC5, 0xC3, 0xC2, 0xC1, 0xBF, 0xBE, 0xBD,
    0xBB, 0xBA, 0xB9, 0xB7, 0xB6, 0xB4, 0xB3, 0xB1,
    0xB0, 0xAF, 0xAD, 0xAC, 0xAA, 0xA9, 0xA7, 0xA6,
    0xA4, 0xA3, 0xA1, 0xA0, 0x9E, 0x9D, 0x9B, 0x9A,
    0x98, 0x97, 0x95, 0x94, 0x92, 0x90, 0x8F, 0x8D,
    0x8C, 0x8A, 0x89, 0x87, 0x86, 0x84, 0x82, 0x81,
    0x7F, 0x7E, 0x7C, 0x7B, 0x79, 0x77, 0x76, 0x74,
    0x73, 0x71, 0x70, 0x6E, 0x6D, 0x6B, 0x69, 0x68,
    0x66, 0x65, 0x63, 0x62, 0x60, 0x5F, 0x5D, 0x5C,
    0x5A, 0x59, 0x57, 0x56, 0x54, 0x53, 0x51, 0x50,
    0x4E, 0x4D, 0x4C, 0x4A, 0x49, 0x47, 0x46, 0x45,
    0x43, 0x42, 0x40, 0x3F, 0x3E, 0x3C, 0x3B, 0x3A,
    0x38, 0x37, 0x36, 0x35, 0x33, 0x32, 0x31, 0x30,
    0x2E, 0x2D, 0x2C, 0x2B, 0x2A, 0x28, 0x27, 0x26,
    0x25, 0x24, 0x23, 0x22, 0x21, 0x20, 0x1F, 0x1E,
    0x1D, 0x1C, 0x1B, 0x1A, 0x19, 0x18, 0x17, 0x16,
    0x15, 0x14, 0x14, 0x13, 0x12, 0x11, 0x10, 0x10,
    0x0F, 0x0E, 0x0D, 0x0D, 0x0C, 0x0B, 0x0B, 0x0A,
    0x09, 0x09, 0x08, 0x08, 0x07, 0x07, 0x06, 0x06,
    0x05, 0x05, 0x04, 0x04, 0x04, 0x03, 0x03, 0x03,
    0x02, 0x02, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02,
    0x02, 0x03, 0x03, 0x03, 0x04, 0x04, 0x04, 0x05,
    0x05, 0x06, 0x06, 0x07, 0x07, 0x08, 0x08, 0x09,
    0x09, 0x0A, 0x0B, 0x0B, 0x0C, 0x0D, 0x0D, 0x0E,
    0x0F, 0x10, 0x10, 0x11, 0x12, 0x13, 0x14, 0x14,
    0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C,
    0x1D, 0x1E, 0x1F, 0x20, 0x21, 0x22, 0x23, 0x24,
    0x25, 0x26, 0x27, 0x28, 0x2A, 0x2B, 0x2C, 0x2D,
    0x2E, 0x30, 0x31, 0x32, 0x33, 0x35, 0x36, 0x37,
    0x38, 0x3A, 0x3B, 0x3C, 0x3E, 0x3F, 0x40, 0x42,
    0x43, 0x45, 0x46, 0x47, 0x49, 0x4A, 0x4C, 0x4D,
    0x4E, 0x50, 0x51, 0x53, 0x54, 0x56, 0x57, 0x59,
    0x5A, 0x5C, 0x5D, 0x5F, 0x60, 0x62, 0x63, 0x65,
    0x66, 0x68, 0x69, 0x6B, 0x6D, 0x6E, 0x70, 0x71,
    0x73, 0x74, 0x76, 0x77, 0x79, 0x7B, 0x7C, 0x7E,
    0x7F, 0x81, 0x82, 0x84, 0x86, 0x87, 0x89, 0x8A,
    0x8C, 0x8D, 0x8F, 0x90, 0x92, 0x94, 0x95, 0x97,
    0x98, 0x9A, 0x9B, 0x9D, 0x9E, 0xA0, 0xA1, 0xA3,
    0xA4, 0xA6, 0xA7, 0xA9, 0xAA, 0xAC, 0xAD, 0xAF,
    0xB0, 0xB1, 0xB3, 0xB4, 0xB6, 0xB7, 0xB9, 0xBA,
    0xBB, 0xBD, 0xBE, 0xBF, 0xC1, 0xC2, 0xC3, 0xC5,
    0xC6, 0xC7, 0xC9, 0xCA, 0xCB, 0xCC, 0xCE, 0xCF,
    0xD0, 0xD1, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7, 0xD8,
    0xD9, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF, 0xE0, 0xE1,
    0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE7, 0xE8,
    0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xED, 0xEE, 0xEF,
    0xF0, 0xF0, 0xF1, 0xF2, 0xF3, 0xF3, 0xF4, 0xF4,
    0xF5, 0xF6, 0xF6, 0xF7, 0xF7, 0xF8, 0xF8, 0xF9,
    0xF9, 0xFA, 0xFA, 0xFB, 0xFB, 0xFB, 0xFC, 0xFC,
    0xFC, 0xFD, 0xFD, 0xFD, 0xFD, 0xFE, 0xFE, 0xFE,
    0xFE, 0xFE, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};

u8 sin_table(u16 number)
{
    return precalculated_sin_table[number];
}
u8 cos_table(u16 number)
{
    return precalculated_cos_table[number];
}

#endif