(defvar *vocabulary* '((кот . cat)
                       (собака . dog)
                       (человек . human)
                       (дом . house)
                       (книга . book)
                       (стол . table)
                       (лёгкий . easy)
                       (трудный . hard)
                       (красный . red)
                       (действительно . really)
                       (открыть . open)
                       (чёрный . black)
                       (наверное . probably)
                       (вполне . fully)
                       (писатель . writer)
                       (судьба . fate)
                       (улыбнуться . smile)
                       (согласиться . agree)
                       (холодный . cold)
                       (самолёт . airplane)
                       (враг . enemy)
                       (наука . science)
                       (потерять . to lose)
                       (кожа . skin)
                       (природа . nature)
                       (толпа . crowd)
                       (дождь . rain)
                       (неделя . week)
                       (год . year)
                       (сегодня . today)
                       (использовать . use)
                       (приходить . come)
                       (смотреть . see)
                       (маленький . small)
                       (гадкий . ugly)
                       (говядина . beef)
                       (курица . chicken)
                       (рыба . fish)
                       (нога . leg)
                       (ступня . foot)
                       (голова . head)
                       (медсестра . nurse)
                       (сотрудник . employee)
                       (повар . cook)
                       (программист . programmer)
                       (буква . letter)
                       (вопрос . question)
                       (газета . newspaper)
                       (голубой . blue)
                       (машина . car)
                       (работать . work)
                       (юный . young)
                       (тёплый . warm)
                       (темнота . dark)
                       (счастье . happiness)
                       (счастливый . happy)
                       (разговор . conversation)
                       (общество . society)
                       (ненавидеть . hate)
                       (мысль . thought)
                       (лицо .face)
                       (кровать . bed)))

(defun quiz ()
  (let ((word (random-word)))
    (format t "Translate the word: ~a~%" (car word))
    (let ((answer (read-line)))
      (if (equal answer (cdr word))
          (format t "Correct!~%")
          (format t "Incorrect, the correct answer is ~a~%" (cdr word))))))

(defun random-word ()
  (nth (random (length *vocabulary*)) *vocabulary*))

(defun play-again ()
  (let ((answer (read-line)))
    (if (string-equal "y" (string-trim answer))
        (progn
          (quiz)
          (play-again))
        (progn
          (format t "Goodbye!~%")
          nil))))

(defun start-quiz ()
  (format t "Привет, ты готов?!!~%")
  (quiz)
  (play-again))

(start-quiz)
