# Lisperatu
Experimenting with **Lisp** dialects while trying to gain a personal knowledge about the language, by reading books, documentations, following courses and just trying to understand how Lisp works *under the hood*. My little personal compendium of **snippets** of **code** and probably even some notes. I hope this repo will get pretty huge in the near future.

*In Lisp we Trust.*

---

### Contents: 
- [`bin-search`](https://github.com/alcestide/CLisping/blob/main/bin-search.lisp)  ([Binary Search](https://en.wikipedia.org/wiki/Binary_search_algorithm))
- [`climbing-stairs`](https://github.com/alcestide/CLisping/blob/main/climbing-stairs.lisp)  ([Staircase Problem](https://leetcode.com/problems/climbing-stairs/))
- [`cointoss`](https://github.com/alcestide/CLisping/blob/main/cointoss.lisp)  (Coin toss)
- [`factorial`](https://github.com/alcestide/CLisping/blob/main/factorial.clj) (Factorial function)
-  [`fibonacci`](https://github.com/alcestide/CLisping/blob/main/fibonacci.lisp)  ([Fibonacci](https://en.wikipedia.org/wiki/Fibonacci_sequence))
-  [`fizzbuzz`](https://github.com/alcestide/CLisping/blob/main/fizzbuzz.lisp)  ([Fizzbuzz](https://en.wikipedia.org/wiki/Fizz_buzz) Game)
-  [`insertion_sort`](https://github.com/alcestide/CLisping/blob/main/insertion_sort.lisp) ⎯ ([_Insertion Sort_](https://it.wikipedia.org/wiki/Insertion_sort))
-  [`lcg`](https://github.com/alcestide/CLisping/blob/main/lcg.lisp)  ([Linear Congruential Generator](https://en.wikipedia.org/wiki/Linear_congruential_generator) from [Rosetta Code](https://rosettacode.org/wiki/Rosetta_Code))
-  [`lettervaluesum`](https://github.com/alcestide/CLisping/blob/main/lettervaluesum.lisp)  (Convert alphabet letters to a numerical value each and compute the total sum of a given string.)
-  [`matrix_multiplication`](https://github.com/alcestide/CLisping/blob/main/matrix_multiplication.lisp)  (Simple [_matrix multiplication_](https://en.wikipedia.org/wiki/Matrix_multiplication))
-  [`open_addressing_ht`](https://github.com/alcestide/CLisping/blob/main/open_addressing_ht.lisp)  ([_Open Addressing_](https://en.wikipedia.org/wiki/Open_addressing) Hash Table)
-  [`orc_battle`](https://github.com/alcestide/CLisping/blob/main/orc_battle.lisp)  (_Orc Battle_ CLI game from [_"Land of Lisp"_](http://landoflisp.com/))
- [`palindrome-number`](https://github.com/alcestide/CLisping/blob/main/palindrome-number.lisp)  ([_Palindrome_](https://en.wikipedia.org/wiki/Palindrome) Number)
- [`quicksort`](https://github.com/alcestide/CLisping/blob/main/quicksort.lisp)  ([_Quicksort_](https://it.wikipedia.org/wiki/Quicksort))
- [`quiz-russian-vocabulary`](https://github.com/alcestide/CLisping/blob/main/quiz-russian-vocabulary.lisp)  (_Anki_-like _quiz_ of russian vocabs)
- [`rock-paper-scissors`](https://github.com/alcestide/CLisping/blob/main/rock-paper-scissors.lisp)  (Pretty self-explainatory. _Multi-player_ to be implemented in a future update)
- [`roman_to_int`](https://github.com/alcestide/CLisping/blob/main/roman_to_int.lisp)  (Implementation of a famous _LeetCode_ Challenge that involves _roman numbers_.)
- [`simple_random_sentence`](https://github.com/alcestide/CLisping/blob/main/simple_random_sentence.lisp)  (Super simple code that prints a """_random_""" sentence in english.)
- [`tictactoe`](https://github.com/alcestide/CLisping/blob/main/tictactoe.lisp)  (Tic-Tac-Toe, Neil Munro tutorial)
- [`towerhanoi`](https://github.com/alcestide/CLisping/blob/main/towerhanoi.clj)  (Implementation of the Tower of Hanoi Puzzle in Clojure.)
- [`webserversample`](https://github.com/alcestide/CLisping/blob/main/webserversample.lisp)  (Hunchentoot Library Sample.)

---
