# Contributing to sbt-dependency-check

## Reporting Bugs

- Ensure you're running the latest version of sbt-dependency-check.
- Ensure the bug has not [already been reported](https://github.com/albuch/sbt-dependency-check/issues).
- If you're unable to find an open issue addressing the problem, please [submit a new issue](https://github.com/albuch/sbt-dependency-check/issues/new).
  - Please fill out the appropriate section of the bug report template provided. Please delete any sections not needed in the template.

Also please have a look at the docs of the [dependency-check-core library](https://github.com/jeremylong/DependencyCheck) library to understand how the library works before you report a bug:
* [How does DependencyCheck work?](http://jeremylong.github.io/DependencyCheck/general/internals.html)
* [How to read the report](http://jeremylong.github.io/DependencyCheck/general/thereport.html)
* [Suppressing False Positives](http://jeremylong.github.io/DependencyCheck/general/suppression.html)

## Reporting Vulnerabilities

- If you believe you have found a vulnerability in sbt-dependency-check itself (not that sbt-dependency-check found a vulnerability); please send a DM on Twitter to [@vonBuchholtz](https://twitter.com/vonBuchholtz).

## Asking Questions

- Your question may be answered by taking a look at the [documentation](https://github.com/albuch/sbt-dependency-check) and related docs from the [dependency-check-core library](https://jeremylong.github.io/DependencyCheck/).
- If you still have a question consider opening a [new issue](https://github.com/albuch/sbt-dependency-check/issues/new)

## Enhancement Requests

- Suggest changes by [submitting a new issue](https://github.com/albuch/sbt-dependency-check/issues/new) and begin coding.

## Contributing Code

- If you have written a new feature or have fixed a bug please open a new pull request with the patch.
- Ensure the PR description clearly describes the problem and solution. Include any related issue number(s) if applicable.
- Please ensure the PR passes the automated checks performed (travis-ci, codacy, etc.)
- Please consider adding test cases for any new functionality

We appreciate all your contributions! 
