export const themes = [
    {
        name: "zinc",
        label: "Zinc",
        activeColor: {
            light: "240 5.9% 10%",
            dark: "240 5.2% 33.9%",
        },
        cssVars: {
            light: {
                background: "0 0% 100%",
                foreground: "240 10% 3.9%",
                card: "0 0% 100%",
                "card-foreground": "240 10% 3.9%",
                popover: "0 0% 100%",
                "popover-foreground": "240 10% 3.9%",
                primary: "240 5.9% 10%",
                "primary-foreground": "0 0% 98%",
                secondary: "240 4.8% 95.9%",
                "secondary-foreground": "240 5.9% 10%",
                muted: "240 4.8% 95.9%",
                "muted-foreground": "240 3.8% 46.1%",
                accent: "240 4.8% 95.9%",
                "accent-foreground": "240 5.9% 10%",
                destructive: "0 84.2% 60.2%",
                "destructive-foreground": "0 0% 98%",
                border: "240 5.9% 90%",
                input: "240 5.9% 90%",
                ring: "240 5.9% 10%",
                radius: "0.5rem",
                translucent: "0, 0%, 9.8%, 0.3",
                highlight: "192.94, 100%, 50%",
            },
            dark: {
                background: "240 10% 3.9%",
                foreground: "0 0% 98%",
                card: "240 10% 3.9%",
                "card-foreground": "0 0% 98%",
                popover: "240 10% 3.9%",
                "popover-foreground": "0 0% 98%",
                primary: "0 0% 98%",
                "primary-foreground": "240 5.9% 10%",
                secondary: "240 3.7% 15.9%",
                "secondary-foreground": "0 0% 98%",
                muted: "240 3.7% 15.9%",
                "muted-foreground": "240 5% 64.9%",
                accent: "240 3.7% 15.9%",
                "accent-foreground": "0 0% 98%",
                destructive: "0 62.8% 30.6%",
                "destructive-foreground": "0 0% 98%",
                border: "240 3.7% 15.9%",
                input: "240 3.7% 15.9%",
                ring: "240 4.9% 83.9%",
                translucent: "0, 0%, 9.8%, 0.3",
                highlight: "192.94, 100%, 50%",
            },
        },
    },
    {
        name: "slate",
        label: "Slate",
        activeColor: {
            light: "215.4 16.3% 46.9%",
            dark: "215.3 19.3% 34.5%",
        },
        cssVars: {
            light: {
                background: "0 0% 100%",
                foreground: "222.2 84% 4.9%",
                card: "0 0% 100%",
                "card-foreground": "222.2 84% 4.9%",
                popover: "0 0% 100%",
                "popover-foreground": "222.2 84% 4.9%",
                primary: "222.2 47.4% 11.2%",
                "primary-foreground": "210 40% 98%",
                secondary: "210 40% 96.1%",
                "secondary-foreground": "222.2 47.4% 11.2%",
                muted: "210 40% 96.1%",
                "muted-foreground": "215.4 16.3% 46.9%",
                accent: "210 40% 96.1%",
                "accent-foreground": "222.2 47.4% 11.2%",
                destructive: "0 84.2% 60.2%",
                "destructive-foreground": "210 40% 98%",
                border: "214.3 31.8% 91.4%",
                input: "214.3 31.8% 91.4%",
                ring: "222.2 84% 4.9%",
                radius: "0.5rem",
                translucent: "227.59, 47.54%, 11.96%, 0.3",
                highlight: "192.94, 100%, 50%",
            },
            dark: {
                background: "222.2 84% 4.9%",
                foreground: "210 40% 98%",
                card: "222.2 84% 4.9%",
                "card-foreground": "210 40% 98%",
                popover: "222.2 84% 4.9%",
                "popover-foreground": "210 40% 98%",
                primary: "210 40% 98%",
                "primary-foreground": "222.2 47.4% 11.2%",
                secondary: "217.2 32.6% 17.5%",
                "secondary-foreground": "210 40% 98%",
                muted: "217.2 32.6% 17.5%",
                "muted-foreground": "215 20.2% 65.1%",
                accent: "217.2 32.6% 17.5%",
                "accent-foreground": "210 40% 98%",
                destructive: "0 62.8% 30.6%",
                "destructive-foreground": "210 40% 98%",
                border: "217.2 32.6% 17.5%",
                input: "217.2 32.6% 17.5%",
                ring: "212.7 26.8% 83.9",
                translucent: "227.59, 47.54%, 11.96%, 0.3",
                highlight: "192.94, 100%, 50%",
            },
        },
    },
    {
        name: "stone",
        label: "Stone",
        activeColor: {
            light: "25 5.3% 44.7%",
            dark: "33.3 5.5% 32.4%",
        },
        cssVars: {
            light: {
                background: "0 0% 100%",
                foreground: "20 14.3% 4.1%",
                card: "0 0% 100%",
                "card-foreground": "20 14.3% 4.1%",
                popover: "0 0% 100%",
                "popover-foreground": "20 14.3% 4.1%",
                primary: "24 9.8% 10%",
                "primary-foreground": "60 9.1% 97.8%",
                secondary: "60 4.8% 95.9%",
                "secondary-foreground": "24 9.8% 10%",
                muted: "60 4.8% 95.9%",
                "muted-foreground": "25 5.3% 44.7%",
                accent: "60 4.8% 95.9%",
                "accent-foreground": "24 9.8% 10%",
                destructive: "0 84.2% 60.2%",
                "destructive-foreground": "60 9.1% 97.8%",
                border: "20 5.9% 90%",
                input: "20 5.9% 90%",
                ring: "20 14.3% 4.1%",
                radius: "0.95rem",
                translucent: "40, 6.12%, 9.61%, 0.3",
                highlight: "192.94, 100%, 50%",
            },
            dark: {
                background: "20 14.3% 4.1%",
                foreground: "60 9.1% 97.8%",
                card: "20 14.3% 4.1%",
                "card-foreground": "60 9.1% 97.8%",
                popover: "20 14.3% 4.1%",
                "popover-foreground": "60 9.1% 97.8%",
                primary: "60 9.1% 97.8%",
                "primary-foreground": "24 9.8% 10%",
                secondary: "12 6.5% 15.1%",
                "secondary-foreground": "60 9.1% 97.8%",
                muted: "12 6.5% 15.1%",
                "muted-foreground": "24 5.4% 63.9%",
                accent: "12 6.5% 15.1%",
                "accent-foreground": "60 9.1% 97.8%",
                destructive: "0 62.8% 30.6%",
                "destructive-foreground": "60 9.1% 97.8%",
                border: "12 6.5% 15.1%",
                input: "12 6.5% 15.1%",
                ring: "24 5.7% 82.9%",
                translucent: "40, 6.12%, 9.61%, 0.3",
                highlight: "192.94, 100%, 50%",
            },
        },
    },
    {
        name: "gray",
        label: "Gray",
        activeColor: {
            light: "220 8.9% 46.1%",
            dark: "215 13.8% 34.1%",
        },
        cssVars: {
            light: {
                background: "0 0% 100%",
                foreground: "224 71.4% 4.1%",
                card: "0 0% 100%",
                "card-foreground": "224 71.4% 4.1%",
                popover: "0 0% 100%",
                "popover-foreground": "224 71.4% 4.1%",
                primary: "220.9 39.3% 11%",
                "primary-foreground": "210 20% 98%",
                secondary: "220 14.3% 95.9%",
                "secondary-foreground": "220.9 39.3% 11%",
                muted: "220 14.3% 95.9%",
                "muted-foreground": "220 8.9% 46.1%",
                accent: "220 14.3% 95.9%",
                "accent-foreground": "220.9 39.3% 11%",
                destructive: "0 84.2% 60.2%",
                "destructive-foreground": "210 20% 98%",
                border: "220 13% 91%",
                input: "220 13% 91%",
                ring: "224 71.4% 4.1%",
                radius: "0.35rem",
                translucent: "232.17, 34.33%, 13.14%, 0.3",
                highlight: "192.94, 100%, 50%",
            },
            dark: {
                background: "224 71.4% 4.1%",
                foreground: "210 20% 98%",
                card: "224 71.4% 4.1%",
                "card-foreground": "210 20% 98%",
                popover: "224 71.4% 4.1%",
                "popover-foreground": "210 20% 98%",
                primary: "210 20% 98%",
                "primary-foreground": "220.9 39.3% 11%",
                secondary: "215 27.9% 16.9%",
                "secondary-foreground": "210 20% 98%",
                muted: "215 27.9% 16.9%",
                "muted-foreground": "217.9 10.6% 64.9%",
                accent: "215 27.9% 16.9%",
                "accent-foreground": "210 20% 98%",
                destructive: "0 62.8% 30.6%",
                "destructive-foreground": "210 20% 98%",
                border: "215 27.9% 16.9%",
                input: "215 27.9% 16.9%",
                ring: "216 12.2% 83.9%",
                translucent: "232.17, 34.33%, 13.14%, 0.3",
                highlight: "192.94, 100%, 50%",
            },
        },
    },
    {
        name: "neutral",
        label: "Neutral",
        activeColor: {
            light: "0 0% 45.1%",
            dark: "0 0% 32.2%",
        },
        cssVars: {
            light: {
                background: "0 0% 100%",
                foreground: "0 0% 3.9%",
                card: "0 0% 100%",
                "card-foreground": "0 0% 3.9%",
                popover: "0 0% 100%",
                "popover-foreground": "0 0% 3.9%",
                primary: "0 0% 9%",
                "primary-foreground": "0 0% 98%",
                secondary: "0 0% 96.1%",
                "secondary-foreground": "0 0% 9%",
                muted: "0 0% 96.1%",
                "muted-foreground": "0 0% 45.1%",
                accent: "0 0% 96.1%",
                "accent-foreground": "0 0% 9%",
                destructive: "0 84.2% 60.2%",
                "destructive-foreground": "0 0% 98%",
                border: "0 0% 89.8%",
                input: "0 0% 89.8%",
                ring: "0 0% 3.9%",
                translucent: "192.94, 100%, 50%, 0.3",
                highlight: "192.94, 100%, 50%",
            },
            dark: {
                background: "0 0% 3.9%",
                foreground: "0 0% 98%",
                card: "0 0% 3.9%",
                "card-foreground": "0 0% 98%",
                popover: "0 0% 3.9%",
                "popover-foreground": "0 0% 98%",
                primary: "0 0% 98%",
                "primary-foreground": "0 0% 9%",
                secondary: "0 0% 14.9%",
                "secondary-foreground": "0 0% 98%",
                muted: "0 0% 14.9%",
                "muted-foreground": "0 0% 63.9%",
                accent: "0 0% 14.9%",
                "accent-foreground": "0 0% 98%",
                destructive: "0 62.8% 30.6%",
                "destructive-foreground": "0 0% 98%",
                border: "0 0% 14.9%",
                input: "0 0% 14.9%",
                ring: "0 0% 83.1%",
                translucent: "192.94, 100%, 50%, 0.3",
                highlight: "192.94, 100%, 50%",
            },
        },
    },
    {
        name: "red",
        label: "Red",
        activeColor: {
            light: "0 72.2% 50.6%",
            dark: "0 72.2% 50.6%",
        },
        cssVars: {
            light: {
                background: "0 0% 100%",
                foreground: "0 0% 3.9%",
                card: "0 0% 100%",
                "card-foreground": "0 0% 3.9%",
                popover: "0 0% 100%",
                "popover-foreground": "0 0% 3.9%",
                primary: "0 72.2% 50.6%",
                "primary-foreground": "0 85.7% 97.3%",
                secondary: "0 0% 96.1%",
                "secondary-foreground": "0 0% 9%",
                muted: "0 0% 96.1%",
                "muted-foreground": "0 0% 45.1%",
                accent: "0 0% 96.1%",
                "accent-foreground": "0 0% 9%",
                destructive: "0 84.2% 60.2%",
                "destructive-foreground": "0 0% 98%",
                border: "0 0% 89.8%",
                input: "0 0% 89.8%",
                ring: "0 72.2% 50.6%",
                radius: "0.4rem",
                translucent: "0, 60.48%, 51.37%, 0.3",
                highlight: "0, 60.48%, 51.37%",
            },
            dark: {
                background: "0 0% 3.9%",
                foreground: "0 0% 98%",
                card: "0 0% 3.9%",
                "card-foreground": "0 0% 98%",
                popover: "0 0% 3.9%",
                "popover-foreground": "0 0% 98%",
                primary: "0 72.2% 50.6%",
                "primary-foreground": "0 85.7% 97.3%",
                secondary: "0 0% 14.9%",
                "secondary-foreground": "0 0% 98%",
                muted: "0 0% 14.9%",
                "muted-foreground": "0 0% 63.9%",
                accent: "0 0% 14.9%",
                "accent-foreground": "0 0% 98%",
                destructive: "0 62.8% 30.6%",
                "destructive-foreground": "0 0% 98%",
                border: "0 0% 14.9%",
                input: "0 0% 14.9%",
                ring: "0 72.2% 50.6%",
                translucent: "0, 60.48%, 51.37%, 0.3",
                highlight: "0, 60.48%, 51.37%",
            },
        },
    },
    {
        name: "rose",
        label: "Rose",
        activeColor: {
            light: "346.8 77.2% 49.8%",
            dark: "346.8 77.2% 49.8%",
        },
        cssVars: {
            light: {
                background: "0 0% 100%",
                foreground: "240 10% 3.9%",
                card: "0 0% 100%",
                "card-foreground": "240 10% 3.9%",
                popover: "0 0% 100%",
                "popover-foreground": "240 10% 3.9%",
                primary: "346.8 77.2% 49.8%",
                "primary-foreground": "355.7 100% 97.3%",
                secondary: "240 4.8% 95.9%",
                "secondary-foreground": "240 5.9% 10%",
                muted: "240 4.8% 95.9%",
                "muted-foreground": "240 3.8% 46.1%",
                accent: "240 4.8% 95.9%",
                "accent-foreground": "240 5.9% 10%",
                destructive: "0 84.2% 60.2%",
                "destructive-foreground": "0 0% 98%",
                border: "240 5.9% 90%",
                input: "240 5.9% 90%",
                ring: "346.8 77.2% 49.8%",
                radius: "0.5rem",
                translucent: "327.8, 57.75%, 41.76%, 0.3",
                highlight: "327.8, 57.75%, 41.76%",
            },
            dark: {
                background: "20 14.3% 4.1%",
                foreground: "0 0% 95%",
                popover: "0 0% 9%",
                "popover-foreground": "0 0% 95%",
                card: "24 9.8% 10%",
                "card-foreground": "0 0% 95%",
                primary: "346.8 77.2% 49.8%",
                "primary-foreground": "355.7 100% 97.3%",
                secondary: "240 3.7% 15.9%",
                "secondary-foreground": "0 0% 98%",
                muted: "0 0% 15%",
                "muted-foreground": "240 5% 64.9%",
                accent: "12 6.5% 15.1%",
                "accent-foreground": "0 0% 98%",
                destructive: "0 62.8% 30.6%",
                "destructive-foreground": "0 85.7% 97.3%",
                border: "240 3.7% 15.9%",
                input: "240 3.7% 15.9%",
                ring: "346.8 77.2% 49.8%",
                translucent: "327.8, 57.75%, 41.76%, 0.3",
                highlight: "327.8, 57.75%, 41.76%",
            },
        },
    },
    {
        name: "orange",
        label: "Orange",
        activeColor: {
            light: "24.6 95% 53.1%",
            dark: "20.5 90.2% 48.2%",
        },
        cssVars: {
            light: {
                background: "0 0% 100%",
                foreground: "20 14.3% 4.1%",
                card: "0 0% 100%",
                "card-foreground": "20 14.3% 4.1%",
                popover: "0 0% 100%",
                "popover-foreground": "20 14.3% 4.1%",
                primary: "24.6 95% 53.1%",
                "primary-foreground": "60 9.1% 97.8%",
                secondary: "60 4.8% 95.9%",
                "secondary-foreground": "24 9.8% 10%",
                muted: "60 4.8% 95.9%",
                "muted-foreground": "25 5.3% 44.7%",
                accent: "60 4.8% 95.9%",
                "accent-foreground": "24 9.8% 10%",
                destructive: "0 84.2% 60.2%",
                "destructive-foreground": "60 9.1% 97.8%",
                border: "20 5.9% 90%",
                input: "20 5.9% 90%",
                ring: "24.6 95% 53.1%",
                radius: "0.95rem",
                translucent: "5.32, 89.43%, 44.51%, 0.3",
                highlight: "5.32, 89.43%, 44.51%",
            },
            dark: {
                background: "20 14.3% 4.1%",
                foreground: "60 9.1% 97.8%",
                card: "20 14.3% 4.1%",
                "card-foreground": "60 9.1% 97.8%",
                popover: "20 14.3% 4.1%",
                "popover-foreground": "60 9.1% 97.8%",
                primary: "20.5 90.2% 48.2%",
                "primary-foreground": "60 9.1% 97.8%",
                secondary: "12 6.5% 15.1%",
                "secondary-foreground": "60 9.1% 97.8%",
                muted: "12 6.5% 15.1%",
                "muted-foreground": "24 5.4% 63.9%",
                accent: "12 6.5% 15.1%",
                "accent-foreground": "60 9.1% 97.8%",
                destructive: "0 72.2% 50.6%",
                "destructive-foreground": "60 9.1% 97.8%",
                border: "12 6.5% 15.1%",
                input: "12 6.5% 15.1%",
                ring: "20.5 90.2% 48.2%",
                translucent: "5.32, 89.43%, 44.51%, 0.3",
            },
        },
    },
    {
        name: "green",
        label: "Green",
        activeColor: {
            light: "142.1 76.2% 36.3%",
            dark: "142.1 70.6% 45.3%",
        },
        cssVars: {
            light: {
                background: "0 0% 100%",
                foreground: "240 10% 3.9%",
                card: "0 0% 100%",
                "card-foreground": "240 10% 3.9%",
                popover: "0 0% 100%",
                "popover-foreground": "240 10% 3.9%",
                primary: "142.1 76.2% 36.3%",
                "primary-foreground": "355.7 100% 97.3%",
                secondary: "240 4.8% 95.9%",
                "secondary-foreground": "240 5.9% 10%",
                muted: "240 4.8% 95.9%",
                "muted-foreground": "240 3.8% 46.1%",
                accent: "240 4.8% 95.9%",
                "accent-foreground": "240 5.9% 10%",
                destructive: "0 84.2% 60.2%",
                "destructive-foreground": "0 0% 98%",
                border: "240 5.9% 90%",
                input: "240 5.9% 90%",
                ring: "142.1 76.2% 36.3%",
                translucent: "144.44, 55.1%, 28.82%, 0.3",
                highlight: "144.44, 55.1%, 28.82%",
            },
            dark: {
                background: "20 14.3% 4.1%",
                foreground: "0 0% 95%",
                popover: "0 0% 9%",
                "popover-foreground": "0 0% 95%",
                card: "24 9.8% 10%",
                "card-foreground": "0 0% 95%",
                primary: "142.1 70.6% 45.3%",
                "primary-foreground": "144.9 80.4% 10%",
                secondary: "240 3.7% 15.9%",
                "secondary-foreground": "0 0% 98%",
                muted: "0 0% 15%",
                "muted-foreground": "240 5% 64.9%",
                accent: "12 6.5% 15.1%",
                "accent-foreground": "0 0% 98%",
                destructive: "0 62.8% 30.6%",
                "destructive-foreground": "0 85.7% 97.3%",
                border: "240 3.7% 15.9%",
                input: "240 3.7% 15.9%",
                ring: "142.4 71.8% 29.2%",
                translucent: "144.44, 55.1%, 28.82%, 0.3",
                highlight: "144.44, 55.1%, 28.82%",
            },
        },
    },
    {
        name: "blue",
        label: "Blue",
        activeColor: {
            light: "221.2 83.2% 53.3%",
            dark: "217.2 91.2% 59.8%",
        },
        cssVars: {
            light: {
                background: "0 0% 100%",
                foreground: "222.2 84% 4.9%",
                card: "0 0% 100%",
                "card-foreground": "222.2 84% 4.9%",
                popover: "0 0% 100%",
                "popover-foreground": "222.2 84% 4.9%",
                primary: "221.2 83.2% 53.3%",
                "primary-foreground": "210 40% 98%",
                secondary: "210 40% 96.1%",
                "secondary-foreground": "222.2 47.4% 11.2%",
                muted: "210 40% 96.1%",
                "muted-foreground": "215.4 16.3% 46.9%",
                accent: "210 40% 96.1%",
                "accent-foreground": "222.2 47.4% 11.2%",
                destructive: "0 84.2% 60.2%",
                "destructive-foreground": "210 40% 98%",
                border: "214.3 31.8% 91.4%",
                input: "214.3 31.8% 91.4%",
                ring: "221.2 83.2% 53.3%",
                translucent: "238.26, 58.97%, 45.88%, 0.3",
                highlight: "238.26, 58.97%, 45.88%",
            },
            dark: {
                background: "222.2 84% 4.9%",
                foreground: "210 40% 98%",
                card: "222.2 84% 4.9%",
                "card-foreground": "210 40% 98%",
                popover: "222.2 84% 4.9%",
                "popover-foreground": "210 40% 98%",
                primary: "217.2 91.2% 59.8%",
                "primary-foreground": "222.2 47.4% 11.2%",
                secondary: "217.2 32.6% 17.5%",
                "secondary-foreground": "210 40% 98%",
                muted: "217.2 32.6% 17.5%",
                "muted-foreground": "215 20.2% 65.1%",
                accent: "217.2 32.6% 17.5%",
                "accent-foreground": "210 40% 98%",
                destructive: "0 62.8% 30.6%",
                "destructive-foreground": "210 40% 98%",
                border: "217.2 32.6% 17.5%",
                input: "217.2 32.6% 17.5%",
                ring: "224.3 76.3% 48%",
                translucent: "238.26, 58.97%, 45.88%, 0.3",
                highlight: "238.26, 58.97%, 45.88%",
            },
        },
    },
    {
        name: "yellow",
        label: "Yellow",
        activeColor: {
            light: "47.9 95.8% 53.1%",
            dark: "47.9 95.8% 53.1%",
        },
        cssVars: {
            light: {
                background: "0 0% 100%",
                foreground: "20 14.3% 4.1%",
                card: "0 0% 100%",
                "card-foreground": "20 14.3% 4.1%",
                popover: "0 0% 100%",
                "popover-foreground": "20 14.3% 4.1%",
                primary: "47.9 95.8% 53.1%",
                "primary-foreground": "26 83.3% 14.1%",
                secondary: "60 4.8% 95.9%",
                "secondary-foreground": "24 9.8% 10%",
                muted: "60 4.8% 95.9%",
                "muted-foreground": "25 5.3% 44.7%",
                accent: "60 4.8% 95.9%",
                "accent-foreground": "24 9.8% 10%",
                destructive: "0 84.2% 60.2%",
                "destructive-foreground": "60 9.1% 97.8%",
                border: "20 5.9% 90%",
                input: "20 5.9% 90%",
                ring: "20 14.3% 4.1%",
                radius: "0.95rem",
                translucent: "58.83, 88.03%, 54.12%, 0.3",
                highlight: "58.83, 88.03%, 54.12%",
            },
            dark: {
                background: "20 14.3% 4.1%",
                foreground: "60 9.1% 97.8%",
                card: "20 14.3% 4.1%",
                "card-foreground": "60 9.1% 97.8%",
                popover: "20 14.3% 4.1%",
                "popover-foreground": "60 9.1% 97.8%",
                primary: "47.9 95.8% 53.1%",
                "primary-foreground": "26 83.3% 14.1%",
                secondary: "12 6.5% 15.1%",
                "secondary-foreground": "60 9.1% 97.8%",
                muted: "12 6.5% 15.1%",
                "muted-foreground": "24 5.4% 63.9%",
                accent: "12 6.5% 15.1%",
                "accent-foreground": "60 9.1% 97.8%",
                destructive: "0 62.8% 30.6%",
                "destructive-foreground": "60 9.1% 97.8%",
                border: "12 6.5% 15.1%",
                input: "12 6.5% 15.1%",
                ring: "35.5 91.7% 32.9%",
                translucent: "58.83, 88.03%, 54.12%, 0.3",
                highlight: "58.83, 88.03%, 54.12%",
            },
        },
    },
    {
        name: "violet",
        label: "Violet",
        activeColor: {
            light: "262.1 83.3% 57.8%",
            dark: "263.4 70% 50.4%",
        },
        cssVars: {
            light: {
                background: "0 0% 100%",
                foreground: "224 71.4% 4.1%",
                card: "0 0% 100%",
                "card-foreground": "224 71.4% 4.1%",
                popover: "0 0% 100%",
                "popover-foreground": "224 71.4% 4.1%",
                primary: "262.1 83.3% 57.8%",
                "primary-foreground": "210 20% 98%",
                secondary: "220 14.3% 95.9%",
                "secondary-foreground": "220.9 39.3% 11%",
                muted: "220 14.3% 95.9%",
                "muted-foreground": "220 8.9% 46.1%",
                accent: "220 14.3% 95.9%",
                "accent-foreground": "220.9 39.3% 11%",
                destructive: "0 84.2% 60.2%",
                "destructive-foreground": "210 20% 98%",
                border: "220 13% 91%",
                input: "220 13% 91%",
                ring: "262.1 83.3% 57.8%",
                translucent: "286.33, 89.96%, 46.86%, 0.3",
                highlight: "286.33, 89.96%, 46.86%",
            },
            dark: {
                background: "224 71.4% 4.1%",
                foreground: "210 20% 98%",
                card: "224 71.4% 4.1%",
                "card-foreground": "210 20% 98%",
                popover: "224 71.4% 4.1%",
                "popover-foreground": "210 20% 98%",
                primary: "263.4 70% 50.4%",
                "primary-foreground": "210 20% 98%",
                secondary: "215 27.9% 16.9%",
                "secondary-foreground": "210 20% 98%",
                muted: "215 27.9% 16.9%",
                "muted-foreground": "217.9 10.6% 64.9%",
                accent: "215 27.9% 16.9%",
                "accent-foreground": "210 20% 98%",
                destructive: "0 62.8% 30.6%",
                "destructive-foreground": "210 20% 98%",
                border: "215 27.9% 16.9%",
                input: "215 27.9% 16.9%",
                ring: "263.4 70% 50.4%",
                translucent: "286.33, 89.96%, 46.86%, 0.3",
                highlight: "286.33, 89.96%, 46.86%",
            },
        },
    },
    {
        name: "github",
        label: "Github",
        activeColor: {
            light: "210 13% 21%",
            dark: "214 13% 90%",
        },
        cssVars: {
            light: {
                background: "0 0% 100%",
                foreground: "210 12% 16%",
                muted: "0 12% 90%",
                "muted-foreground": "0 12% 30%",
                popover: "0 0% 97%",
                "popover-foreground": "210 12% 6%",
                card: "0 0% 98%",
                "card-foreground": "210 12% 11%",
                border: "0 0% 95%",
                input: "0 0% 92%",
                primary: "210 13% 21%",
                "primary-foreground": "210 13% 81%",
                secondary: "210 3% 75%",
                "secondary-foreground": "210 3% 15%",
                accent: "0 0% 85%",
                "accent-foreground": "0 0% 25%",
                destructive: "9 92% 38%",
                "destructive-foreground": "0 0% 100%",
                ring: "210 13% 21%",
                radius: "0.5rem",
                translucent: "210, 13%, 21%, 0.3",
                highlight: "210, 13%, 21%",
            },
            dark: {
                background: "210 12% 16%",
                foreground: "214 13% 90%",
                muted: "210 12% 20%",
                "muted-foreground": "210 12% 70%",
                popover: "210 12% 13%",
                "popover-foreground": "214 13% 100%",
                card: "210 12% 14%",
                "card-foreground": "214 13% 95%",
                border: "210 2% 21%",
                input: "210 2% 24%",
                primary: "214 13% 90%",
                "primary-foreground": "214 13% 30%",
                secondary: "214 3% 25%",
                "secondary-foreground": "214 3% 85%",
                accent: "210 12% 31%",
                "accent-foreground": "210 12% 91%",
                destructive: "1 94% 54%",
                "destructive-foreground": "0 0% 100%",
                ring: "214 13% 90%",
                radius: "0.5rem",
                translucent: "214, 13%, 90%, 0.3",
                highlight: "214, 13%, 90%",
            },
        },
    },
    {
        name: "material",
        label: "Material",
        activeColor: {
            light: "174 42% 65%",
            dark: "174 42% 65%",
        },
        cssVars: {
            light: {
                background: "0 0% 98%",
                foreground: "0 0% 18%",
                muted: "0 12% 90%",
                "muted-foreground": "0 12% 30%",
                popover: "0 0% 95%",
                "popover-foreground": "0 0% 8%",
                card: "0 0% 96%",
                "card-foreground": "0 0% 13%",
                border: "0 0% 93%",
                input: "0 0% 90%",
                primary: "174 42% 65%",
                "primary-foreground": "174 42% 5%",
                secondary: "174 30% 25%",
                "secondary-foreground": "174 30% 85%",
                accent: "0 0% 83%",
                "accent-foreground": "0 0% 23%",
                destructive: "2 87% 45%",
                "destructive-foreground": "0 0% 100%",
                ring: "174 42% 65%",
                radius: "0.5rem",
                translucent: "174, 42%, 65%, 0.3",
                highlight: "174, 42%, 65%",
            },
            dark: {
                background: "229 27% 8%",
                foreground: "232 28% 79%",
                muted: "229 12% 15%",
                "muted-foreground": "229 12% 65%",
                popover: "229 27% 5%",
                "popover-foreground": "232 28% 89%",
                card: "229 27% 6%",
                "card-foreground": "232 28% 84%",
                border: "229 17% 13%",
                input: "229 17% 16%",
                primary: "174 42% 65%",
                "primary-foreground": "174 42% 5%",
                secondary: "174 30% 25%",
                "secondary-foreground": "174 30% 85%",
                accent: "229 27% 23%",
                "accent-foreground": "229 27% 83%",
                destructive: "2 93% 47%",
                "destructive-foreground": "0 0% 100%",
                ring: "174 42% 65%",
                radius: "0.5rem",
                translucent: "174, 42%, 65%, 0.3",
                highlight: "174, 42%, 65%",
            },
        },
    },
    {
        name: "ayu",
        label: "Ayu",
        activeColor: {
            light: "35 100% 60%",
            dark: "40 75% 61%",
        },
        cssVars: {
            light: {
                background: "210 17% 98%",
                foreground: "210 5% 38%",
                muted: "210 12% 90%",
                "muted-foreground": "210 12% 30%",
                popover: "210 17% 95%",
                "popover-foreground": "210 5% 28%",
                card: "210 17% 96%",
                "card-foreground": "210 5% 33%",
                border: "210 7% 93%",
                input: "210 7% 90%",
                primary: "35 100% 60%",
                "primary-foreground": "0 0% 0%",
                secondary: "35 30% 25%",
                "secondary-foreground": "35 30% 85%",
                accent: "210 17% 83%",
                "accent-foreground": "210 17% 23%",
                destructive: "5 83% 33%",
                "destructive-foreground": "5 83% 93%",
                ring: "35 100% 60%",
                radius: "0.5rem",
                translucent: "35, 100%, 60%, 0.3",
                highlight: "35 100% 60%",
            },
            dark: {
                background: "220 29% 6%",
                foreground: "47 7% 73%",
                muted: "220 12% 15%",
                "muted-foreground": "220 12% 65%",
                popover: "220 29% 3%",
                "popover-foreground": "47 7% 83%",
                card: "220 29% 4%",
                "card-foreground": "47 7% 78%",
                border: "220 19% 11%",
                input: "220 19% 14%",
                primary: "40 75% 61%",
                "primary-foreground": "40 75% 1%",
                secondary: "40 30% 25%",
                "secondary-foreground": "40 30% 85%",
                accent: "220 29% 21%",
                "accent-foreground": "220 29% 81%",
                destructive: "2 90% 60%",
                "destructive-foreground": "0 0% 100%",
                ring: "40 75% 61%",
                radius: "0.5rem",
                translucent: "40, 75%, 61%, 0.3",
                highlight: "40, 75%, 61%",
            },
        },
    },
] as const;

export type Theme = (typeof themes)[number];
