
<div align="center"> 
    <a href="https://github.com/akshat-OwO/syllabusx-client">
        <img src="https://github.com/akshat-OwO/syllabusx-client/blob/main/.github/assets/banner.png?raw=true" alt="SyllabusX Banner">
    </a>
    <br />
    <p align="center">
    The open-source, IPU's ultimate academic GPS.
    <br />
    <a href="https://syllabusx.live">Website</a>
    ·
    <a href="https://github.com/akshat-OwO/syllabusx-client/issues">Feedback</a>
  </p>
</div>

# 🧭 Table of Contents

- [Introduction 🚀](#Introduction)
- [Usage](#Usage)
- [Docker Setup for Development](#Docker-Setup-for-Development)
- [Technologies Used 📫](#Technologies-Used)
- [Features](#Features)
- [How to Contribute](#How-to-Contribute)
- [Maintainers](#Maintainers)
- [License](#License)
- [Contributors](#Contributors)
- [Support](#Support)


<br>

# Introduction

### Why SyllabusX?

-   Gathering syllabus for each of your subjects whenever you need is quite hassling, isn't it?
-   At SyllabusX, we understand the challenge of collecting syllabus documents in PDF format. For B.Tech students at GGSIPU, it can be overwhelming to gather all these resources in one centralized place. . That's why we stepped in and created this solution. Currently, syllabusX offers syllabus for batch 2021 - 2025 and onwards. We've added syllabus for all the branches with syllabus you'll find handwritten notes, previous year questions, recommended books, and practical files – everything you need for a successful semester.

# Usage

To access syllabus information for your branch and semester, follow these simple steps:

1. Visit the [SyllabusX website](https://syllabusx.live/).
2. Select your branch from the available options.
3. Choose your semester.
4. Explore the syllabus, recommended books, handwritten notes, previous year questions, and practical files for your selected semester.

It's that easy! Enjoy using SyllabusX for all your academic needs.

# Docker Setup for Development

To run this project with Docker  follow these steps:

### Starting the Application

1. **Start Docker Engine**  
   Ensure that Docker is installed and running on your system.

2. **Copy Environment Variables**  
   Copy the example environment file to create a local `.env` file:
   ```bash
   cp .env.example .env
   ```

3. **Start Docker Compose with Watch Mode**  
   Use Docker Compose to start the application in watch mode:
   ```bash
   docker compose up --watch
   ```

### Stopping the Application

To stop the Docker containers, run:
```bash
docker compose down
```

# Technologies-Used 💻

[![NextJS](https://img.shields.io/badge/NextJS-blue?style=for-the-badge)](https://nextjs.org/docs)
[![Shadcn Ui](https://img.shields.io/badge/Shadcn_Ui-purple?style=for-the-badge)](https://ui.shadcn.com/)
[![Typescript](https://img.shields.io/badge/Typescript-2ea44f?style=for-the-badge)](https://www.typescriptlang.org/docs/)

</br>

# Features✨

-   Syllabus for Batch 2021 and Onwards: Access up-to-date syllabus information for B.Tech courses starting from the batch of 2021 and beyond.
-   Handwritten Notes: Gain access to high-quality handwritten notes to supplement your learning and understanding of key concepts.
-   Previous Year Questions (PYQs): Prepare effectively by practicing with the previous year's questions to get a feel for the exam patterns and important topics.
-   Practical Files: Access practical files and resources to excel in laboratory sessions and hands-on coursework.

# Contributing to SyllabusX

Remember, Good PR makes you a Good contributor!

While we don't require a specific pull request format, we kindly ask our contributors to maintain a reasonable level of organization when submitting pull requests. This includes providing a clear and concise description of the changes and their purpose. Pull requests that are unclear or do not align with the project's goals may be subject to closure or further review.

-   Have a look at [Contributing guidelines](/.github/Contributing.md) before contributing.

# Maintainers

<table>
 <tbody>
        <tr>
            <td align="center">
                <a href="https://github.com/akshat-OwO">
                    <img src="https://avatars.githubusercontent.com/u/95408545?v=4" width="100px;" alt="Akshat Singh"/>
                    <br />
                    <sub><b>Akshat Singh</b></sub>
                </a>
            </td>
            <td align="center">
                <a href="https://github.com/ShouryaPal">
                    <img src="https://avatars.githubusercontent.com/u/104789024?v=4" width="100px;" alt="Shourya Pal"/>
                    <br />
                    <sub><b>Shourya Pal</b></sub>
                </a>
            </td>
            <td align="center">
                <a href="https://github.com/yom4n">
                    <img src="https://avatars.githubusercontent.com/u/27628105?v=4" width="100px;" alt="Sparsh"/>
                    <br />
                    <sub><b>Sparsh</b></sub>
                </a>
            </td>
            <td align="center">
                <a href="https://github.com/Jain-Pranjal">
                    <img src="https://avatars.githubusercontent.com/u/111055946?v=4" width="100px;" alt="Pranjal Jain"/>
                    <br />
                    <sub><b>Pranjal Jain</b></sub>
                </a>
            </td>
</table>

# License 👮

SyllabusX is Licensed under the <a href="./LICENSE">GPL License</a>. Please go through the License at least once before contributing.

# Contributors

<a href="https://github.com/akshat-OwO/syllabusx-client/graphs/contributors">
 <img src="https://contrib.rocks/image?repo=akshat-OwO/syllabusx-client&v=1" />

</a>

Made with [contrib.rocks](https://contrib.rocks).

# Support 🙏

If you like the project and want to support us, please consider starring our repository as a token of appreciation. A heartfelt thank you to those who have contributed to this project. We are really grateful for your contribution. You all are amazing. Opensource for the win 🚀
