function(enable_doxygen)
	option(ENABLE_DOXYGEN "Enable doxygen doc builds of source" OFF)
	if(ENABLE_DOXYGEN)
		set(DOXYGEN_CALLER_GRAPH YES)
		set(DOXYGEN_CALL_GRAPH YES)
		set(DOXYGEN_EXTRACT_ALL YES)
		find_package(Doxygen REQUIRED)
		set(DOXYGEN_GENERATE_TREEVIEW YES) # optional. Also works without treeview
		set(DOXYGEN_HTML_EXTRA_STYLESHEET cmake/doxygen-theme/doxygen-awesome.css)
		set(DOXYGEN_HAVE_DOT YES)
		set(DOXYGEN_DOT_IMAGE_FORMAT svg)
		set(DOXYGEN_DOT_TRANSPARENT YES)
		set(DOXYGEN_HTML_COLORSTYLE_HUE 209)
		set(DOXYGEN_HTML_COLORSTYLE_SAT 255)
		set(DOXYGEN_HTML_COLORSTYLE_GAMMA 113)
		doxygen_add_docs(doxygen-docs ${PROJECT_SOURCE_DIR})
	endif()
endfunction()
