"use client"

import { ChatWindow } from "@/component/chatWindow"
import { useState } from "react"
import ShortUniqueId from "short-unique-id"
import { usePathname } from 'next/navigation'
import { ChatWindowUser } from "./chatWindowsUser"

const Chat: React.FC = () => {
  const pathname = usePathname()
	const [show, setShow] = useState<boolean>(false)
	const [dialog, setDialog] = useState<boolean>(false)

	const [name, setName] = useState<string>("Anonymous User")
	const [id, setId] = useState<string>(new ShortUniqueId({ length: 5 }).rnd())

	return (
		<>
			<div className={`fixed right-10 top-10 max-md:right-5 max-md:top-5 cursor-pointer ${show || dialog ? "hidden" : ""}`} onClick={() => setDialog(true)}>
				<div className="relative hover:text-[#1E1E1E] hover:scale-110 hover:-rotate-6">
					<div className="absolute w-full h-full flex justify-center items-center">
						<svg xmlns="http://www.w3.org/2000/svg" width="36" height="36" viewBox="0 0 24 24" fill="none" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round" className="lucide lucide-bot">
							<path d="M12 8V4H8" />
							<rect width="16" height="12" x="4" y="8" rx="2" />
							<path d="M2 14h2" />
							<path d="M20 14h2" />
							<path d="M15 13v2" />
							<path d="M9 13v2" />
						</svg>
					</div>
					<svg width="90" height="90" viewBox="0 0 243 242" fill="none" xmlns="http://www.w3.org/2000/svg" className="animate-[spin_5s_ease-in-out_infinite]">
						<path
							d="M111.714 228H114.356C114.513 228.76 114.786 229.428 115.177 230.003C115.56 230.578 116.029 231.061 116.583 231.452C117.13 231.849 117.737 232.148 118.405 232.347C119.072 232.545 119.768 232.645 120.493 232.645C121.814 232.645 123.01 232.311 124.083 231.643C125.148 230.976 125.997 229.992 126.629 228.692C127.254 227.393 127.566 225.798 127.566 223.909C127.566 222.02 127.254 220.425 126.629 219.126C125.997 217.826 125.148 216.842 124.083 216.175C123.01 215.507 121.814 215.173 120.493 215.173C119.768 215.173 119.072 215.273 118.405 215.472C117.737 215.67 117.13 215.965 116.583 216.356C116.029 216.754 115.56 217.24 115.177 217.815C114.786 218.398 114.513 219.065 114.356 219.818H111.714C111.913 218.703 112.275 217.705 112.801 216.825C113.326 215.944 113.98 215.195 114.761 214.577C115.542 213.966 116.419 213.501 117.392 213.181C118.358 212.862 119.392 212.702 120.493 212.702C122.353 212.702 124.008 213.156 125.457 214.065C126.906 214.974 128.046 216.267 128.877 217.943C129.708 219.619 130.123 221.608 130.123 223.909C130.123 226.21 129.708 228.199 128.877 229.875C128.046 231.551 126.906 232.844 125.457 233.753C124.008 234.662 122.353 235.116 120.493 235.116C119.392 235.116 118.358 234.957 117.392 234.637C116.419 234.317 115.542 233.849 114.761 233.231C113.98 232.62 113.326 231.874 112.801 230.994C112.275 230.12 111.913 229.122 111.714 228Z"
							fill="black"
						/>
						<path d="M100.557 220.853L102.912 211.295L105.353 211.897L100.132 233.081L97.6909 232.479L99.6081 224.701L99.4013 224.65C98.8266 225.379 98.1074 225.893 97.2437 226.192C96.3714 226.496 95.3111 226.494 94.063 226.187C92.9803 225.92 92.0857 225.469 91.379 224.834C90.6707 224.206 90.202 223.392 89.9731 222.392C89.7355 221.397 89.785 220.217 90.1215 218.851L92.6099 208.756L95.051 209.358L92.6035 219.288C92.2924 220.55 92.3795 221.606 92.8646 222.457C93.3412 223.313 94.1552 223.883 95.3068 224.167C96.1068 224.364 96.8656 224.372 97.5833 224.191C98.2941 224.007 98.9121 223.637 99.4374 223.079C99.9557 222.519 100.329 221.777 100.557 220.853Z" fill="black" />
						<path
							d="M79.1636 202.511C80.0818 202.993 80.8243 203.603 81.3911 204.342C81.9547 205.086 82.2832 205.905 82.3769 206.796C82.4672 207.694 82.2649 208.614 81.7698 209.557C81.3341 210.388 80.8174 210.975 80.2198 211.319C79.6188 211.669 78.9672 211.848 78.265 211.857C77.5627 211.865 76.8435 211.768 76.1072 211.567C75.3614 211.368 74.6289 211.136 73.9098 210.87C72.97 210.522 72.2117 210.232 71.6349 210.001C71.0484 209.774 70.5915 209.666 70.264 209.679C69.9303 209.688 69.6693 209.872 69.4812 210.231L69.4416 210.306C68.9531 211.237 68.8282 212.094 69.067 212.877C69.2994 213.656 69.9282 214.315 70.9533 214.853C72.0161 215.411 72.9714 215.616 73.8194 215.467C74.6674 215.319 75.3526 215.045 75.8751 214.645L77.5921 216.509C76.7526 217.191 75.8898 217.613 75.0035 217.773C74.1076 217.936 73.2343 217.919 72.3836 217.721C71.5233 217.527 70.7284 217.238 69.9989 216.855C69.5336 216.611 69.0287 216.274 68.4844 215.843C67.9305 215.416 67.4597 214.885 67.0719 214.248C66.6779 213.608 66.4721 212.846 66.4545 211.963C66.437 211.079 66.7302 210.062 67.3342 208.911L72.3445 199.365L74.5707 200.533L73.5409 202.495L73.6541 202.555C73.9701 202.32 74.3982 202.115 74.9385 201.942C75.4788 201.768 76.1074 201.709 76.8243 201.764C77.5412 201.82 78.321 202.068 79.1636 202.511ZM77.7745 204.332C76.894 203.87 76.0612 203.654 75.276 203.683C74.4844 203.708 73.791 203.914 73.1957 204.299C72.5941 204.681 72.1349 205.174 71.818 205.778L70.7486 207.816C70.9024 207.752 71.1644 207.757 71.5346 207.831C71.8952 207.908 72.3012 208.021 72.7526 208.17C73.1944 208.321 73.6234 208.474 74.0397 208.629C74.4464 208.786 74.7775 208.912 75.033 209.006C75.6512 209.234 76.2564 209.395 76.8486 209.489C77.4312 209.586 77.9641 209.549 78.4472 209.378C78.9207 209.209 79.3059 208.842 79.603 208.276C80.009 207.502 80.0298 206.767 79.6654 206.071C79.2915 205.377 78.6612 204.798 77.7745 204.332Z"
							fill="black"
						/>
						<path d="M45.797 199.148L47.2099 197.553L53.5573 203.177L52.1444 204.772L45.797 199.148ZM47.6947 206.067L45.8128 204.4L56.1552 192.726C56.6262 192.194 56.9023 191.727 56.9836 191.325C57.0549 190.923 57.0083 190.569 56.8439 190.261C56.6694 189.955 56.4439 189.679 56.1675 189.435C55.9601 189.251 55.7806 189.111 55.6288 189.014C55.4724 188.923 55.3472 188.85 55.2534 188.795L56.3683 186.766C56.5383 186.831 56.7587 186.941 57.0297 187.096C57.3054 187.245 57.6187 187.475 57.9695 187.786C58.5012 188.257 58.9209 188.833 59.2287 189.513C59.5312 190.189 59.6427 190.91 59.5632 191.674C59.4783 192.434 59.1204 193.17 58.4893 193.883L47.6947 206.067Z" fill="black" />
						<path d="M37.508 160.293L19.2231 173.608L18.2712 171.098L33.2694 160.533L33.1939 160.334L14.9316 162.293L13.8738 159.503L28.8419 148.859L28.7663 148.66L10.5343 150.698L9.58232 148.188L32.0982 146.029L33.0653 148.579L18.5163 159.247L18.5768 159.406L36.5409 157.743L37.508 160.293Z" fill="black" />
						<path d="M29.8225 133.339L13.5781 135.311L13.2751 132.815L29.5194 130.843L29.8225 133.339ZM10.7167 134.371C10.7757 134.857 10.661 135.297 10.3724 135.69C10.083 136.075 9.70561 136.296 9.24028 136.353C8.77494 136.409 8.35562 136.285 7.9823 135.98C7.60812 135.667 7.3915 135.268 7.33243 134.782C7.27336 134.295 7.38853 133.859 7.67796 133.473C7.96653 133.081 8.34348 132.856 8.80881 132.799C9.27414 132.743 9.6939 132.871 10.0681 133.183C10.4414 133.488 10.6576 133.884 10.7167 134.371Z" fill="black" />
						<path d="M13.9651 103.502L16.0802 103.759L15.058 112.178L12.9429 111.921L13.9651 103.502ZM9.34894 108.995L9.652 106.499L25.1349 108.379C25.8399 108.464 26.3811 108.426 26.7585 108.265C27.1296 108.095 27.3948 107.855 27.5541 107.546C27.7071 107.228 27.8059 106.886 27.8504 106.519C27.8838 106.244 27.8971 106.017 27.8903 105.837C27.8764 105.657 27.8654 105.512 27.857 105.404L30.1607 105.168C30.2036 105.345 30.2384 105.589 30.2651 105.9C30.2988 106.212 30.2874 106.6 30.2309 107.066C30.1452 107.771 29.9098 108.443 29.5244 109.083C29.1399 109.716 28.6105 110.217 27.9361 110.586C27.2626 110.948 26.4534 111.071 25.5087 110.957L9.34894 108.995Z" fill="black" />
						<path d="M24.3394 88.6697L33.5434 92.1603L32.6519 94.5112L12.2515 86.7743L13.1431 84.4235L20.6338 87.2644L20.7094 87.0651C20.0551 86.4068 19.6316 85.6309 19.4387 84.7374C19.2418 83.8348 19.3712 82.7825 19.827 81.5805C20.2224 80.5379 20.7779 79.7041 21.4935 79.0792C22.2024 78.4517 23.067 78.0846 24.0874 77.9779C25.1036 77.8619 26.2692 78.0533 27.584 78.552L37.3061 82.2391L36.4145 84.5899L26.8519 80.9632C25.6366 80.5024 24.5773 80.4614 23.674 80.8404C22.7665 81.2103 22.1025 81.9497 21.6819 83.0587C21.3898 83.8291 21.2905 84.5814 21.3842 85.3158C21.4804 86.0435 21.7739 86.7017 22.2647 87.2904C22.7579 87.8724 23.4495 88.3322 24.3394 88.6697Z" fill="black" />
						<path d="M37.8878 42.5715L40.2481 40.4804L57.8078 49.1196L57.9992 48.9501L51.5396 30.477L53.8999 28.3859L68.3681 44.7171L66.5181 46.3561L55.5257 33.9482L55.3662 34.0895L61.2551 51.0186L59.4689 52.6011L43.373 44.7145L43.2135 44.8558L54.2059 57.2637L52.3559 58.9026L37.8878 42.5715Z" fill="black" />
						<path
							d="M72.7783 42.4074L62.6389 23.0884L64.8651 21.92L68.608 29.0514L68.7967 28.9524C68.8282 28.615 68.8862 28.1755 68.9709 27.6337C69.0585 27.0824 69.295 26.5091 69.6804 25.9138C70.0688 25.3089 70.7346 24.7589 71.678 24.2638C72.898 23.6235 74.1334 23.3641 75.3843 23.4857C76.6352 23.6072 77.8154 24.0907 78.9249 24.9361C80.0343 25.7816 80.9884 26.9652 81.7872 28.4871C82.5925 30.0216 83.0296 31.4886 83.0985 32.8882C83.164 34.2816 82.8963 35.529 82.2953 36.6305C81.691 37.7257 80.7851 38.5901 79.5777 39.2238C78.647 39.7123 77.8209 39.9494 77.0994 39.935C76.3747 39.9143 75.7575 39.7851 75.2477 39.5473C74.7346 39.3033 74.3269 39.0921 74.0248 38.9138L73.7607 39.0524L74.9291 41.2786L72.7783 42.4074ZM71.1645 34.0142C71.7389 35.1084 72.4059 35.9896 73.1656 36.6576C73.922 37.3194 74.7321 37.7244 75.5959 37.8726C76.4565 38.0145 77.3332 37.8511 78.2262 37.3825C79.157 36.894 79.8049 36.2411 80.1701 35.4238C80.5382 34.5969 80.66 33.6828 80.5354 32.6813C80.4139 31.6703 80.0825 30.6491 79.5412 29.6178C79.0065 28.599 78.3674 27.7634 77.6238 27.1109C76.8833 26.4488 76.0732 26.0438 75.1935 25.8959C74.3167 25.7384 73.4067 25.9072 72.4634 26.4023C71.5578 26.8776 70.9174 27.5065 70.542 28.289C70.1634 29.0653 70.0313 29.9447 70.146 30.9273C70.2573 31.9035 70.5968 32.9325 71.1645 34.0142Z"
							fill="black"
						/>
						<path
							d="M98.2634 32.2457C97.2566 32.4939 96.2961 32.5294 95.382 32.3524C94.4662 32.1685 93.6777 31.774 93.0166 31.1689C92.3537 30.5569 91.8948 29.7338 91.6398 28.6994C91.4154 27.7891 91.4129 27.0071 91.6321 26.3532C91.8496 25.6925 92.2184 25.1261 92.7384 24.6541C93.2585 24.1822 93.861 23.7776 94.546 23.4406C95.2362 23.0949 95.9383 22.7829 96.6523 22.5044C97.5872 22.1424 98.3469 21.8564 98.9316 21.6464C99.5214 21.4279 99.9347 21.2053 100.171 20.9787C100.415 20.7504 100.488 20.4398 100.392 20.0467L100.371 19.9639C100.12 18.9434 99.6449 18.2192 98.9469 17.7914C98.2559 17.3619 97.3484 17.2857 96.2243 17.5627C95.0589 17.85 94.2081 18.3303 93.6719 19.0038C93.1356 19.6772 92.8044 20.3368 92.6783 20.9823L90.1573 20.7259C90.3331 19.6585 90.6995 18.7708 91.2565 18.063C91.8187 17.3466 92.4838 16.7803 93.2517 16.3643C94.0248 15.9397 94.8113 15.6288 95.6113 15.4316C96.1216 15.3058 96.723 15.2234 97.4156 15.1844C98.1134 15.1367 98.8185 15.2226 99.5309 15.442C100.25 15.6597 100.909 16.0934 101.508 16.7431C102.107 17.3927 102.562 18.3486 102.874 19.6105L105.454 30.0785L103.012 30.6802L102.482 28.5286L102.358 28.5592C102.278 28.9448 102.093 29.3817 101.803 29.87C101.514 30.3582 101.083 30.8193 100.509 31.2532C99.9361 31.6871 99.1874 32.018 98.2634 32.2457ZM98.0952 29.961C99.0607 29.7231 99.8276 29.3329 100.396 28.7904C100.972 28.2463 101.354 27.6326 101.544 26.9494C101.741 26.2645 101.758 25.591 101.595 24.929L101.044 22.6947C100.971 22.8443 100.772 23.0142 100.446 23.2043C100.125 23.3859 99.746 23.5706 99.3095 23.7587C98.8783 23.9381 98.4557 24.1081 98.0418 24.2687C97.633 24.4206 97.3019 24.5461 97.0483 24.6452C96.4343 24.8843 95.8744 25.1649 95.3686 25.4871C94.868 25.8007 94.4938 26.1818 94.246 26.6306C94.0034 27.0708 93.9586 27.6012 94.1115 28.2218C94.3206 29.07 94.7924 29.634 95.527 29.9138C96.2668 30.1849 97.1229 30.2007 98.0952 29.961Z"
							fill="black"
						/>
						<path d="M117.986 23.0341L117.943 19.9233H118.454L125.614 12.6364H128.724L121.097 20.3494H120.883L117.986 23.0341ZM115.642 29V7.18182H118.156V29H115.642ZM126.04 29L119.648 20.9034L121.437 19.1563L129.236 29H126.04Z" fill="black" />
						<path d="M158.353 36.7033L155.901 35.4161L173.134 19.8201L175.549 21.0876L172.503 44.1297L170.051 42.8424L172.813 23.5498L172.662 23.4706L158.353 36.7033ZM163.22 29.6321L173.106 34.8207L172.016 36.8959L162.131 31.7074L163.22 29.6321Z" fill="black" />
						<path d="M197.459 36.6775L182.991 53.0086L181.014 51.2566L195.482 34.9255L197.459 36.6775Z" fill="black" />
						<path d="M204.198 80.9323L224.599 73.1954L225.536 75.6658L216.451 79.1111L220.576 89.9886L229.661 86.5433L230.598 89.0137L210.197 96.7505L209.261 94.2801L218.385 90.8197L214.26 79.9422L205.135 83.4026L204.198 80.9323Z" fill="black" />
						<path
							d="M212.043 110.38C211.853 108.815 212.034 107.423 212.587 106.204C213.148 104.991 214.016 104.002 215.189 103.237C216.37 102.478 217.793 101.998 219.457 101.796C221.121 101.594 222.624 101.719 223.967 102.171C225.318 102.63 226.415 103.362 227.26 104.368C228.113 105.381 228.628 106.621 228.806 108.087C228.909 108.933 228.869 109.786 228.688 110.645C228.506 111.504 228.139 112.311 227.586 113.064C227.041 113.817 226.274 114.458 225.287 114.986C224.299 115.513 223.047 115.869 221.532 116.053L220.474 116.182L218.954 103.66L221.111 103.398L222.323 113.381C223.24 113.27 224.035 112.988 224.71 112.534C225.386 112.087 225.891 111.503 226.225 110.783C226.561 110.07 226.674 109.262 226.564 108.359C226.443 107.365 226.092 106.535 225.511 105.869C224.937 105.209 224.235 104.732 223.405 104.439C222.576 104.147 221.713 104.055 220.818 104.163L219.379 104.338C218.153 104.487 217.138 104.825 216.337 105.351C215.543 105.884 214.97 106.558 214.618 107.374C214.274 108.188 214.162 109.1 214.285 110.108C214.364 110.763 214.528 111.345 214.776 111.851C215.031 112.364 215.369 112.791 215.79 113.134C216.218 113.475 216.726 113.718 217.316 113.861L216.932 116.354C216.083 116.2 215.312 115.86 214.619 115.336C213.933 114.812 213.364 114.13 212.911 113.29C212.466 112.45 212.176 111.48 212.043 110.38Z"
							fill="black"
						/>
						<path d="M212.725 128.833L228.969 130.806L228.676 133.217L226.223 132.919L226.202 133.088C226.97 133.482 227.557 134.097 227.963 134.933C228.37 135.77 228.514 136.674 228.396 137.647C228.373 137.831 228.342 138.059 228.302 138.334C228.261 138.608 228.225 138.814 228.194 138.954L225.656 138.645C225.687 138.563 225.743 138.373 225.822 138.075C225.907 137.785 225.97 137.474 226.01 137.143C226.106 136.353 226.026 135.628 225.77 134.968C225.52 134.315 225.128 133.774 224.593 133.344C224.065 132.922 223.434 132.666 222.701 132.577L212.422 131.329L212.725 128.833Z" fill="black" />
						<path
							d="M206.55 153.906C207.109 152.432 207.917 151.284 208.973 150.461C210.033 149.648 211.261 149.176 212.655 149.044C214.054 148.921 215.537 149.157 217.104 149.751C218.671 150.345 219.944 151.155 220.923 152.179C221.906 153.213 222.537 154.371 222.818 155.655C223.102 156.948 222.983 158.285 222.459 159.666C222.156 160.463 221.725 161.2 221.165 161.876C220.605 162.552 219.905 163.096 219.065 163.506C218.232 163.92 217.256 164.131 216.136 164.139C215.017 164.147 213.743 163.881 212.315 163.339L211.319 162.961L215.792 151.167L217.824 151.938L214.258 161.341C215.121 161.669 215.957 161.788 216.765 161.7C217.571 161.618 218.289 161.336 218.921 160.854C219.549 160.378 220.025 159.715 220.347 158.865C220.702 157.929 220.777 157.031 220.571 156.17C220.37 155.319 219.97 154.571 219.371 153.926C218.773 153.282 218.052 152.799 217.209 152.479L215.854 151.966C214.698 151.527 213.643 151.355 212.689 151.449C211.738 151.552 210.918 151.883 210.227 152.441C209.544 153.002 209.022 153.757 208.661 154.707C208.427 155.325 208.302 155.915 208.286 156.479C208.274 157.051 208.374 157.587 208.588 158.086C208.808 158.587 209.146 159.038 209.602 159.439L208.103 161.468C207.423 160.937 206.898 160.278 206.528 159.492C206.164 158.709 205.977 157.84 205.966 156.887C205.962 155.936 206.157 154.942 206.55 153.906Z"
							fill="black"
						/>
						<path d="M213.563 187.261L200.778 178.177L202.182 176.143L215.209 184.876L213.563 187.261ZM196.289 173.578C196.588 173.145 196.999 172.881 197.523 172.785C198.046 172.689 198.524 172.79 198.957 173.089C199.389 173.387 199.654 173.799 199.75 174.322C199.846 174.846 199.744 175.324 199.446 175.756C199.147 176.189 198.736 176.453 198.213 176.549C197.689 176.645 197.211 176.544 196.778 176.245C196.492 176.048 196.279 175.793 196.14 175.481C195.998 175.176 195.936 174.853 195.955 174.512C195.976 174.181 196.088 173.87 196.289 173.578Z" fill="black" />
						<path d="M164.416 214.002L163.327 211.926L171.779 207.49L172.869 209.566L164.416 214.002Z" fill="black" />
					</svg>
				</div>
			</div>
			<div className={`fixed right-10 top-10 w-[250px] max-md:max-w-full rounded bg-white/80 z-40 p-4 ${dialog ? "" : "hidden"}`}>
				<div className={`absolute top-5 right-5 z-50 cursor-pointer`} onClick={() => setDialog(false)}>
					<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round" className="lucide lucide-circle-x hover:text-[#1E1E1E]">
						<circle cx="12" cy="12" r="10" />
						<path d="m15 9-6 6" />
						<path d="m9 9 6 6" />
					</svg>
				</div>
				<br />
				<h2 className="text-[#FB7C33] text-xl text-center">
					Chat bareng
					<br />
					Mbak AI 🙋‍♀️
				</h2>
				<br />
				<input
					onChange={(e) => {
						if (e.target.value === "") {
							setName("Anonymous User")
							setId(new ShortUniqueId({ length: 5 }).rnd())
						} else {
							const value = e.target.value.split("#")
							if (value.length > 1) {
								setId(value[1])
								setName(value[0])
							} else {
								setName(value[0])
							}
						}
					}}
					className="w-full rounded px-4 py-2 text-center text-[#1E1E1E]"
					placeholder="Input your name"
				/>
				<div className="text-[#1E1E1E] text-center my-4">Or leave blank to be Anonymous user</div>
				<button
					className="bg-[#FB7C33] hover:bg-[#FB7C33]/80 px-4 py-2 rounded w-full"
					onClick={() => {
						setShow(true)
						setDialog(false)
					}}
				>
					Submit
				</button>
			</div>
			<div className={`fixed right-10 top-10 w-[500px] h-[80vh] max-md:h-[85vh] max-md:max-w-full rounded bg-white/80 z-40 max-md:inset-0 ${show ? "" : "hidden"}`}>
				<div className={`absolute top-5 right-5 z-50 cursor-pointer`} onClick={() => setShow(false)}>
					<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round" className="lucide lucide-circle-x hover:text-[#1E1E1E]">
						<circle cx="12" cy="12" r="10" />
						<path d="m15 9-6 6" />
						<path d="m9 9 6 6" />
					</svg>
				</div>
				{pathname !== "/chat" ? 
				<ChatWindow endpoint="/api/chat" name={name} id={id} placeholder="Hi, I am an AI Agent behind this website, you can call me Mbak AI. What's your name?"></ChatWindow> : 
				<ChatWindowUser endpoint="/api/chat/retrieval" name={name} id={id}></ChatWindowUser> }
			</div>
		</>
	)
}

export default Chat
