
<!-- Project Title -->
![Banner](docs/banner.png)

<!-- Badges -->
<p align="center">
<img src="https://img.shields.io/github/stars/ajnart/homarr?label=%E2%AD%90%20Stars&style=flat-square?branch=master&kill_cache=1%22">
<a href="https://github.com/ajnart/homarr/releases/latest">
  <img alt="Latest Release (Semver)" src="https://img.shields.io/github/v/release/ajnart/homarr?label=%F0%9F%9A%80%20Release">
</a>
<a href="https://github.com/ajnart/homarr/actions/workflows/docker.yml">
  <img title="Docker CI Status" src="https://github.com/ajnart/homarr/actions/workflows/docker.yml/badge.svg" alt="CI Status">
</a>
<a href=https://translate.homarr.dev/>
<img title="Translations" src="https://badges.crowdin.net/homarr/localized.svg" />
</a>
<a href="https://discord.gg/aCsmEV5RgA">
  <img title="Discord" src="https://discordapp.com/api/guilds/972958686051962910/widget.png?style=shield">
</a>
</p>

<!-- Links -->
<p align="center">
  <a href="https://demo.homarr.dev/">
    <strong>Demo ✨</strong>
  </a>
  •
  <a href="https://homarr.dev/docs/getting-started/installation/">
    <strong>Install 💻</strong>
  </a> •
  <a href="https://translate.homarr.dev/">
    <strong>Translations 🈺</strong>
  </a> •
  <a href="https://discord.com/invite/aCsmEV5RgA">
    <strong>Discord 👋</strong>
  </a>
</p>

Simplify the management of your server with Homarr - a sleek, modern dashboard that puts all of your apps and services at your fingertips. With Homarr, you can access and control everything in one convenient location. Homarr seamlessly integrates with the apps you've added, providing you with valuable information and giving you complete control. Installation is a breeze, and Homarr supports a wide range of deployment methods.

<br/>
<br/>

![Features Section](docs/section-features.png)

- 🖌️ Highly customizable with an extensive drag and drop grid system
- ✨ Integrates seamlessly with your favorite self-hosted applications
- 📌 Easy and fast app management - no YAML involved
- 🙊 Advanced secrets' management system for enhanced security
- 📄 Detailed documentation and active community
- 🔍 Search through the web or supported integrations in an instant
- 🏴󠁧󠁢󠁮󠁩󠁲󠁿 Monitor your application with a built-in status system
- 🦞 Comprehensive built-in icon picker with over 7000 icons
- 🐳 Easy deployment with Docker, unRAID, and Synology
- 🚀 Compatible with any major consumer hardware (x86, Raspberry Pi, old laptops, ...)

<br/>
<br/>

![Widgets & Integrations Section](docs/section-widgets-and-integrations.png)

Homarr has a [built-in collection of widgets and integrations](https://homarr.dev/docs/category/integrations), that connect to your applications and enable you to control them directly from the dashboard.
Each widget and integration has a comprehensive documentation
Homarr will integrate with the following applications:

📥 Torrent clients
- [Deluge](https://homarr.dev/docs/integrations/torrent#deluge)
- [Transmission](https://homarr.dev/docs/integrations/torrent#transmission)
- [qBittorent](https://homarr.dev/docs/integrations/torrent#qbittorrent-integration)

📥 Usenet clients
- [SABnzbd](https://homarr.dev/docs/integrations/usenet#sabnzbd)
- [NZBGet](https://homarr.dev/docs/integrations/usenet#nzbget)

📺 Media servers
- [Plex](https://homarr.dev/docs/integrations/media-server/#plex)
- [Jellyfin](https://homarr.dev/docs/integrations/media-server#jellyfin-and-emby)

📚 Media collection managers
- [Sonarr](https://homarr.dev/docs/integrations/servarr#sonarr)
- [Radarr](https://homarr.dev/docs/integrations/servarr#radarr)
- [Lidarr](https://homarr.dev/docs/integrations/servarr#lidarr)
- [Readarr](https://homarr.dev/docs/integrations/servarr#readarr)
 
🎞️ Media request managers
- [Overseerr](https://homarr.dev/docs/integrations/media-requester)
- [Jellyseerr](https://homarr.dev/docs/integrations/media-requester)

🚫 DNS ad-blockers
- [Pihole](https://homarr.dev/docs/integrations/dns#pihole)
- [AdGuard Home](https://homarr.dev/docs/integrations/dns#adguard-home)

Other integrations
- [🔌 Dash.](https://homarr.dev/docs/integrations/hardware)
- [🐳 Docker](https://homarr.dev/docs/integrations/containers)  

We're constantly adding new integrations and widgets, which will enhance your experience even further.

<br/>
<br/>

![Preview Section](docs/section-preview.png)

https://user-images.githubusercontent.com/30572287/217098893-5880e7de-13d0-42c5-b505-f7921593396f.mp4

<br/>
<br/>

![Installation Section](docs/section-installation.png)

Since we are updating Homarr very frequently, we recommend reading our official installation guides:

<a href="https://homarr.dev/docs/getting-started/installation/">
  <img src="docs/installation-button.png" width="200" />
</a>

<br/>
<br/>

![Contribute Section](docs/section-contribute.png)
Homarr is maintained by motivated developers in their free-time.
We work for fun and learning on this project.

Hence, we're glad for all the help and support we can get.
Although a donation is appreciated, there are other ways you can support us.

<a href="https://ko-fi.com/ajnart">
  <img src="https://cdn.ko-fi.com/cdn/kofi3.png?v=3" width="200" />
</a>

You can also support us by helping with [translating the entire project](https://homarr.dev/docs/community/translations) to as many language as possible or contributing directly to the code or documentation.

**Please read our [Contribution Guidelines](/CONTRIBUTING.md)**

All contributions, regardless of their size or scope, are welcome and highly appreciated! Thank you ❤️

![Alt](https://repobeats.axiom.co/api/embed/60a6f68f193faf831f64221bdf90782adec51c93.svg "Repobeats analytics image")
[![Covered by Argos Visual Testing](https://argos-ci.com/badge-large.svg)](https://argos-ci.com?utm_source=%5Bhomarr%5D&utm_campaign=oss)
