---
title: 为什么不能引入全部组件？
---

# 为什么不能引入全部组件

移动端引入全部组件会导致体积过大，加载速度慢，浪费用户等待时间并且浪费(cdn)带宽。

另一方面随着组件库迭代，组件数量增加，这个体积会逐渐变得不可接受。

因此 `VUX` 没有像其他组件库一样直接提供全部引入的使用方式，按需使用是最佳实践。

如果你只是不想每次在单个 `.vue` 文件里重复地 `import`，那么你可以直接在 `main.js` 里进行全局注册。

``` js
import { Group, Cell } from 'vux'

Vue.component('group', Group)
Vue.component('cell', Cell)
``` 

::: tip
`VUX@3.0` 将会实现无声明使用组件。
:::