---
description: >-
  The GenAI Agents platform enables developers to create solutions with
  autonomous agents by setting up the agents using the specified parameters.
---

# Agent Configuration



<table data-header-hidden><thead><tr><th width="145">Attribute</th><th width="176">Paramter type</th><th width="191">Description</th><th width="307"></th></tr></thead><tbody><tr><td><strong>Agent Attribute and default value</strong></td><td>Parameter type</td><td><strong>Description</strong></td><td><strong>Remarks</strong></td></tr><tr><td>agentName</td><td>Mandatory</td><td>Indicates the name of the agent</td><td></td></tr><tr><td>role</td><td>Mandatory</td><td>Indicates the role of the agent</td><td></td></tr><tr><td>goal</td><td>Mandatory</td><td>Goal that the agent needs to achieve</td><td></td></tr><tr><td>backstory</td><td>Mandatory</td><td>Background of the agent</td><td></td></tr><tr><td>capability</td><td>Mandatory</td><td>The capabilities of the agent</td><td>Only limited capabilities are supported. In future they will be extended. At present it supports search_executor and llm_task_executor.</td></tr><tr><td>task</td><td>Mandatory</td><td>Task that needs to be accomplished by the agent</td><td></td></tr><tr><td>output_consumer_agent</td><td>Mandatory</td><td>Name of the agent which consumes the output produced by the agent</td><td>The value “HGI” indicates human agent which is the final receiver of the output from the agent</td></tr><tr><td>llm_api</td><td>Optional</td><td>LLM that need to be used for generating responses</td><td>To be used for local LLM as mentioned in <a href="../../architecture/configuration-for-local-llm-integration-of-agents.md">section</a></td></tr><tr><td>llm</td><td>Optional</td><td>LLM that need to be used for generating responses</td><td>used for passing LLM name to the agent. Please refer to <a href="../../architecture/configuration-for-using-multiple-llms.md">section</a> </td></tr><tr><td>tools_list=[]</td><td>Optional</td><td>Ordered list of tools that the agent need to execute to accomplish the task</td><td>The agent will execute the tools in the given order with relevant parameters after generating using AI</td></tr><tr><td>feedback=False</td><td>Optional</td><td>If the agent needs to generate feedback and pass the response to the sender agent</td><td>Refer to example "usecases/ProfAgentFeedback_Review.py"</td></tr><tr><td></td><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td><td></td></tr><tr><td>agent_type=”STATIC”</td><td>Optional</td><td>Whether the agent is created at the initialization of the program.</td><td>Will also be used in future for indicating “special agents types”. Specific example for dynamic usage  can be found "usecases/ProfAgentDynamic.py"</td></tr><tr><td></td><td></td><td></td><td></td></tr><tr><td>multiplicity=0</td><td>Optional</td><td>Number of concurrent tasks that the agent execute</td><td>For future usage</td></tr><tr><td>aggregator=0</td><td>Optional</td><td>If the agent is an aggregator, the field indicates number of input messages that the agent needs to receive to accomplish the task</td><td>Ex: aggregator=2 indicates that the agent needs to wait for 2 messages from the other agents to execute its task. Example "usecases/ProfAgentAggr.py"</td></tr><tr><td>onAggregationAction=None</td><td>Optional</td><td>Callback function provided to perform the aggregation of input messages</td><td>The developer needs to pass the function to handle the aggregation of input generated by various agents. Refer to above example.</td></tr><tr><td>creator=None</td><td>Optional</td><td>Refers to the object of agent, which gets created dynamically</td><td>A thread will be created based on the object description to handle the task. Example: "usecases/ProfAgentDynamic.py"</td></tr><tr><td>HGI_Intf=None</td><td>Optional</td><td>Human tool to get the control after the execution of the task</td><td>Refer to example: "usecases/ProfAgentHumanToolInteration.py"</td></tr><tr><td>llm_resp_timer_value=2000</td><td>Optional</td><td>Maximum time that the agent can wait for the response from LLM/tool</td><td>For future use</td></tr></tbody></table>

Example Configurations



