using System.Diagnostics.CodeAnalysis;
using Helpers.Essentials;

namespace AINotes {
    // IDEA: Use https://img.icons8.com/{pack_name}/48/{hex_color}/{icon_name}.png to provide users with more options
    // example: http://img.icons8.com/material/48/FFFFFF/search.png
    
    [SuppressMessage("ReSharper", "MemberHidesStaticFromOuterClass")]
    public static class Icon {
        public static class White {
            public static string People => BaseUrl.GetImages() + "icons8_white_people_48.png";
            public static string Star => BaseUrl.GetImages() + "icons8_white_star_filled_48.png";
        }
        
        public static string Access => BaseUrl.GetImages() + "icons8_access_48.png";
        public static string Add => BaseUrl.GetImages() + "icons8_add_48.png";
        public static string AddFile => BaseUrl.GetImages() + "icons8_add_file_48.png";
        public static string AlignCenter => BaseUrl.GetImages() + "icons8_align_center_48.png";
        public static string AlignLeft => BaseUrl.GetImages() + "icons8_align_left_48.png";
        public static string AlignRight => BaseUrl.GetImages() + "icons8_align_right_48.png";
        public static string ArrowLeft => BaseUrl.GetImages() + "icons8_back_48.png";
        public static string Pen => BaseUrl.GetImages() + "icons8_ball_point_pen_48.png";
        public static string Bold => BaseUrl.GetImages() + "icons8_bold_48.png";
        public static string Bookmark => BaseUrl.GetImages() + "icons8_bookmark_48.png";
        public static string BookmarkPage => BaseUrl.GetImages() + "icons8_bookmark_page_48.png";
        public static string BringToFront => BaseUrl.GetImages() + "icons8_bring_to_front_48.png";
        public static string Calculator => BaseUrl.GetImages() + "icons8_calculator_48.png";
        public static string Camera => BaseUrl.GetImages() + "icons8_camera_48.png";
        public static string Chat => BaseUrl.GetImages() + "icons8_chat_48.png";
        public static string Checkmark => BaseUrl.GetImages() + "icons8_checkmark_48.png";
        public static string ChiselTipMarker => BaseUrl.GetImages() + "icons8_chisel_tip_marker_48.png";
        public static string CloudRefresh => BaseUrl.GetImages() + "icons8_cloud_refresh_48.png";
        public static string CloudOk => BaseUrl.GetImages() + "icons8_cloud_checked_48.png";
        public static string CloudDashed => BaseUrl.GetImages() + "icons8_dashed_cloud_48.png";
        public static string CollapseArrow => BaseUrl.GetImages() + "icons8_collapse_arrow_48.png";
        public static string ColorDropper => BaseUrl.GetImages() + "icons8_color_dropper_48.png";
        public static string Comments => BaseUrl.GetImages() + "icons8_comments_48.png";
        public static string Crop => BaseUrl.GetImages() + "icons8_crop_48.png";
        public static string DescendingSorting => BaseUrl.GetImages() + "icons8_descending_sorting_48.png";
        public static string Details => BaseUrl.GetImages() + "icons8_details_48.png";
        public static string AddFolder => BaseUrl.GetImages() + "icons8_add_folder_48.png";
        public static string DocumentsFolder => BaseUrl.GetImages() + "icons8_documents_folder_48.png";
        public static string Move => BaseUrl.GetImages() + "icons8_drag_96.png";
        public static string Resize => BaseUrl.GetImages() + "icons8_enlarge_96.png";
        public static string Eraser => BaseUrl.GetImages() + "icons8_eraser_48.png";
        public static string CloudError => BaseUrl.GetImages() + "icons8_error_cloud_48.png";
        public static string ExpandArrow => BaseUrl.GetImages() + "icons8_expand_arrow_48.png";
        public static string Expired => BaseUrl.GetImages() + "icons8_expired_48.png";
        public static string Feedback => BaseUrl.GetImages() + "icons8_feedback_48.png";
        public static string FlipHorizontal => BaseUrl.GetImages() + "icons8_flip_horizontal_48.png";
        public static string FlipVertical => BaseUrl.GetImages() + "icons8_flip_vertical_48.png";
        public static string Folder => BaseUrl.GetImages() + "icons8_folder_48.png";
        public static string FolderSettings => BaseUrl.GetImages() + "icons8_folder_settings_48.png";
        public static string ArrowRight => BaseUrl.GetImages() + "icons8_forward_48.png";
        public static string FullScreen => BaseUrl.GetImages() + "icons8_full_screen_48.png";
        public static string Grid => BaseUrl.GetImages() + "icons8_grid_48.png";
        public static string ImageDocument => BaseUrl.GetImages() + "icons8_image_document_48.png";
        public static string Italic => BaseUrl.GetImages() + "icons8_italic_48.png";
        public static string LassoTool => BaseUrl.GetImages() + "icons8_lasso_tool_48.png";
        public static string List => BaseUrl.GetImages() + "icons8_list_48.png";
        public static string Menu => BaseUrl.GetImages() + "icons8_menu_48.png";
        public static string MenuVertical => BaseUrl.GetImages() + "icons8_menu_vertical_48.png";
        public static string MindMap => BaseUrl.GetImages() + "icons8_mind_map_48.png";
        public static string More => BaseUrl.GetImages() + "icons8_more_48.png";
        public static string Note => BaseUrl.GetImages() + "icons8_note_48.png";
        public static string Pencil => BaseUrl.GetImages() + "icons8_pencil_48.png";
        public static string People => BaseUrl.GetImages() + "icons8_people_48.png";
        public static string Planner => BaseUrl.GetImages() + "icons8_planner_48.png";
        public static string Plus => BaseUrl.GetImages() + "icons8_plus_math_48.png";
        public static string Redo => BaseUrl.GetImages() + "icons8_redo_48.png";
        public static string Reset => BaseUrl.GetImages() + "icons8_reset_48.png";
        public static string ResizeHorizontal => BaseUrl.GetImages() + "icons8_resize_horizontal_96.png";
        public static string Search => BaseUrl.GetImages() + "icons8_search_48.png";
        public static string SearchFolder => BaseUrl.GetImages() + "icons8_search_folder_48.png";
        public static string SearchInCloud => BaseUrl.GetImages() + "icons8_search_in_cloud_48.png";
        public static string SendToBack => BaseUrl.GetImages() + "icons8_send_to_back_48.png";
        public static string Settings => BaseUrl.GetImages() + "icons8_settings_48.png";
        public static string TaskPlanning => BaseUrl.GetImages() + "icons8_task_planning_48.png";
        public static string Text => BaseUrl.GetImages() + "icons8_text_48.png";
        public static string Recent => BaseUrl.GetImages() + "icons8_time_machine_48.png";
        public static string Timetable => BaseUrl.GetImages() + "icons8_timetable_48.png";
        public static string TodoList => BaseUrl.GetImages() + "icons8_todo_list_48.png";
        public static string TrashCan => BaseUrl.GetImages() + "icons8_trash_can_48.png";
        public static string UnavailableCloud => BaseUrl.GetImages() + "icons8_unavailable_cloud_48.png";
        public static string Underline => BaseUrl.GetImages() + "icons8_underline_48.png";
        public static string Undo => BaseUrl.GetImages() + "icons8_undo_48.png";
        public static string UpdateLeftRotation => BaseUrl.GetImages() + "icons8_update_left_rotation_48.png";
        public static string View => BaseUrl.GetImages() + "icons8_view_48.png";
        public static string VoiceRecognition => BaseUrl.GetImages() + "icons8_voice_recognition_48.png";
        public static string HandwritingRecognition => BaseUrl.GetImages() + "icons8_general_ocr_48.png";
        public static string InkRecognition => BaseUrl.GetImages() + "icons8_pentagon_48.png";
        public static string Close => BaseUrl.GetImages() + "icons8_delete_48.png";
        public static string Circle => BaseUrl.GetImages() + "icons8_circle_48.png";
        public static string Filter => BaseUrl.GetImages() + "icons8_filter_48.png";
        public static string Sort => BaseUrl.GetImages() + "icons8_sorting_48.png";
        public static string Insert => BaseUrl.GetImages() + "icons8_insert_48.png";
        public static string Scan => BaseUrl.GetImages() + "icons8_scan_48.png";
        public static string SwitchCamera => BaseUrl.GetImages() + "icons8_switch_camera_48.png";
        public static string EditFile => BaseUrl.GetImages() + "icons8_edit_file_48.png";
        public static string Finish => BaseUrl.GetImages() + "icons8_save_close_48.png";
        public static string DataSheet => BaseUrl.GetImages() + "icons8_data_sheet_48.png";
        public static string File => BaseUrl.GetImages() + "icons8_file_48.png";
        public static string FilePreview => BaseUrl.GetImages() + "icons8_file_preview_48.png";
        public static string EmptyNote => BaseUrl.GetImages() + "icons8_empty_note_48.png";
        public static string Presentation => BaseUrl.GetImages() + "icons8_presentation_48.png";
        public static string SharedDocument => BaseUrl.GetImages() + "icons8_shared_document_48.png";
        public static string SpreadsheetFile => BaseUrl.GetImages() + "icons8_spreadsheet_file_48.png";
        public static string Polygon => BaseUrl.GetImages() + "icons8_triangle_48.png";
        public static string EmptyMailingBox => BaseUrl.GetImages() + "icons8_empty_box_48.png";
        public static string Account => BaseUrl.GetImages() + "icons8_account_48.png";
        public static string IncomingMessage => BaseUrl.GetImages() + "icons8_mailing_48.png";
        public static string Reload => BaseUrl.GetImages() + "icons8_synchronize_48.png";
        public static string Export => BaseUrl.GetImages() + "icons8_export_48.png";
        public static string Exit => BaseUrl.GetImages() + "icons8_exit_48.png";
        public static string AccountGroup => BaseUrl.GetImages() + "icons8_user_account_48.png";
        public static string Info => BaseUrl.GetImages() + "icons8_info_48.png";
        public static string DatabaseImport => BaseUrl.GetImages() + "icons8_database_import_48.png";
        public static string Help => BaseUrl.GetImages() + "icons8_help_48.png";
        public static string Mailbox => BaseUrl.GetImages() + "icons8_mailbox_48.png";
        public static string MailboxAnimated => BaseUrl.GetImages() + "icons8_mailbox.gif";
        
        // Document Line Modes
        public static string Grid0 => BaseUrl.GetImages() + "grid0.png";
        public static string Grid1 => BaseUrl.GetImages() + "grid1.png";
        public static string Grid2 => BaseUrl.GetImages() + "grid2.png";
        
        public static string Lines0 => BaseUrl.GetImages() + "lines0.png";
        public static string Lines1 => BaseUrl.GetImages() + "lines1.png";
        public static string Lines2 => BaseUrl.GetImages() + "lines2.png";
    }
}