import 'package:auto_route/auto_route.dart';
import 'package:easy_localization/easy_localization.dart';
import 'package:flutter/material.dart';
import 'package:store_ify/core/router/app_router.dart';
import 'package:store_ify/core/themes/app_text_styles.dart';
import 'package:store_ify/generated/locale_keys.g.dart';

class SignUpTextButton extends StatelessWidget {
  const SignUpTextButton({super.key});

  @override
  Widget build(BuildContext context) {
    return TextButton(
      style: TextButton.styleFrom(
        textStyle: AppTextStyles.textStyle16Regular,
      ),
      onPressed: () => context.pushRoute(const RegisterRoute()),
      child: Text(context.tr(LocaleKeys.signUp)),
    );
  }
}
