﻿using System;
using System.Collections.Generic;
using System.Text;
using LLCD.CourseContent;

namespace LLCD.CourseExtractor.Tests
{
    static class CourseObjects
    {
        internal static readonly Course VALIDCOURSE = new Course
        {
            Chapters = new List<Chapter>
            {
              new Chapter
              {
                Title = "Introduction",
                Videos = new List<Video>
                {
                  new Video
                  {
                    Title = "Welcome",
                    Slug = "welcome",
                    Duration = 53,
                    DownloadUrl = "https://dms.licdn.com/playlist/C560DAQHWEqAHXYrTpQ/learning-original-video-iphone-360/0/1598507051468?e=1619539200&v=beta&t=70MFcPLTMNfQLzGiZ7yZRpQqbj0FQjXkWbR6ueahL_c#.mp4",
                    TranscriptLines = null,
                    Transcript = "1\r\n00:00:00,060 --> 00:00:02,020\r\n- Hi, I\'m Chris Croft and welcome to\r\n\r\n2\r\n00:00:02,020 --> 00:00:04,070\r\nthis assertiveness course.\r\n\r\n3\r\n00:00:04,070 --> 00:00:07,000\r\nAssertiveness is incredibly important,\r\n\r\n4\r\n00:00:07,000 --> 00:00:09,000\r\nbecause it underpins everything you do,\r\n\r\n5\r\n00:00:09,000 --> 00:00:11,030\r\nevery interaction you have with other people,\r\n\r\n6\r\n00:00:11,030 --> 00:00:14,020\r\nboth at home and at work, whether it\'s one to one,\r\n\r\n7\r\n00:00:14,020 --> 00:00:17,030\r\nin meetings, or with groups of friends.\r\n\r\n8\r\n00:00:17,030 --> 00:00:20,000\r\nIf you think about it, leadership requires assertiveness,\r\n\r\n9\r\n00:00:20,000 --> 00:00:23,020\r\ntime management also requires you to be assertive.\r\n\r\n10\r\n00:00:23,020 --> 00:00:27,060\r\nAnd even giving a good presentation requires assertiveness.\r\n\r\n11\r\n00:00:27,060 --> 00:00:31,050\r\nAnd it\'s hard to do, it\'s not a natural skill.\r\n\r\n12\r\n00:00:31,050 --> 00:00:34,040\r\nIt\'s much easier to be submissive or aggressive\r\n\r\n13\r\n00:00:34,040 --> 00:00:35,060\r\nin difficult situations,\r\n\r\n14\r\n00:00:35,060 --> 00:00:38,010\r\nor when you\'re dealing with difficult people.\r\n\r\n15\r\n00:00:38,010 --> 00:00:39,090\r\nSo in this course, I\'m gonna explain\r\n\r\n16\r\n00:00:39,090 --> 00:00:42,030\r\nwhat assertiveness consists of,\r\n\r\n17\r\n00:00:42,030 --> 00:00:45,040\r\nand I\'m going to cover a whole lot of practical techniques,\r\n\r\n18\r\n00:00:45,040 --> 00:00:48,000\r\nthat you\'ll be able to use immediately.\r\n\r\n19\r\n00:00:48,000 --> 00:00:51,070\r\nSo what is assertiveness, and how can we get better at it?\r\n\r\n20\r\n00:00:51,070 --> 00:00:53,000\r\nLet\'s find out.\r\n\r\n"
                  }
                }
              },
              new Chapter
              {
                Title = "1. Understanding Assertiveness",
                Videos = new List<Video>
                {
                  new Video
                  {
                    Title = "Discovering why assertion doesn\'t come naturally",
                    Slug = "discovering-why-assertion-doesn-t-come-naturally",
                    Duration = 376,
                    DownloadUrl = "https://dms.licdn.com/playlist/C4E0DAQFQXBRIEFYKBA/learning-original-video-iphone-360/0/1598507241412?e=1619539200&v=beta&t=HgK5FUrGLyTFWqUXOB3U0f7olARDqS8S8jAZSNPJ6rs#.mp4",
                    TranscriptLines = null,
                    Transcript = "1\r\n00:00:00,080 --> 00:00:03,050\r\n- So why is not easy to be assertive?\r\n\r\n2\r\n00:00:03,050 --> 00:00:06,050\r\nWhy does it not come naturally?\r\n\r\n3\r\n00:00:06,050 --> 00:00:07,090\r\nAnd I think the first reason for this\r\n\r\n4\r\n00:00:07,090 --> 00:00:10,040\r\nis that we are actually animals, really.\r\n\r\n5\r\n00:00:10,040 --> 00:00:11,060\r\nWe still are animals,\r\n\r\n6\r\n00:00:11,060 --> 00:00:14,050\r\nand we have fight or flight built into us.\r\n\r\n7\r\n00:00:14,050 --> 00:00:16,060\r\nAnd what happens in a stressful situation\r\n\r\n8\r\n00:00:16,060 --> 00:00:18,030\r\nis that chemicals like adrenaline\r\n\r\n9\r\n00:00:18,030 --> 00:00:19,080\r\npump into our bloodstream,\r\n\r\n10\r\n00:00:19,080 --> 00:00:21,020\r\nand the objective of those chemicals\r\n\r\n11\r\n00:00:21,020 --> 00:00:24,040\r\nis to help us run away or put up a stronger fight.\r\n\r\n12\r\n00:00:24,040 --> 00:00:26,080\r\nBut running away and fighting harder\r\n\r\n13\r\n00:00:26,080 --> 00:00:29,000\r\nare not really appropriate\r\n\r\n14\r\n00:00:29,000 --> 00:00:32,010\r\nresponses to most work situations.\r\n\r\n15\r\n00:00:32,010 --> 00:00:34,050\r\nNow animals only have these two choices: fight or flight.\r\n\r\n16\r\n00:00:34,050 --> 00:00:36,000\r\nBut we have third one,\r\n\r\n17\r\n00:00:36,000 --> 00:00:38,030\r\nwhich is to talk calmly about an outcome\r\n\r\n18\r\n00:00:38,030 --> 00:00:40,050\r\nthat can work for both parties.\r\n\r\n19\r\n00:00:40,050 --> 00:00:43,000\r\nAnd this is really the essence of assertiveness.\r\n\r\n20\r\n00:00:43,000 --> 00:00:44,040\r\nNot being aggressive.\r\n\r\n21\r\n00:00:44,040 --> 00:00:45,070\r\nNot being too submissive.\r\n\r\n22\r\n00:00:45,070 --> 00:00:50,020\r\nBut calmly working out an acceptable outcome for all.\r\n\r\n23\r\n00:00:50,020 --> 00:00:52,030\r\nI\'ll give you an example of how easy it is\r\n\r\n24\r\n00:00:52,030 --> 00:00:54,050\r\nto get into a fight or flight situation,\r\n\r\n25\r\n00:00:54,050 --> 00:00:56,090\r\nand also how ineffective it is.\r\n\r\n26\r\n00:00:56,090 --> 00:00:58,020\r\nI was going on a cycle ride.\r\n\r\n27\r\n00:00:58,020 --> 00:01:00,000\r\nIt was about 20 miles.\r\n\r\n28\r\n00:01:00,000 --> 00:01:02,040\r\nAnd after the first mile, we went past a house.\r\n\r\n29\r\n00:01:02,040 --> 00:01:05,010\r\nAnd this German Shepherd Alsatian dog\r\n\r\n30\r\n00:01:05,010 --> 00:01:07,010\r\ncame rushing out barking at me.\r\n\r\n31\r\n00:01:07,010 --> 00:01:09,050\r\nIt gave me a real shock, and I quickly cycled away.\r\n\r\n32\r\n00:01:09,050 --> 00:01:10,060\r\nAnd I went into flight mode.\r\n\r\n33\r\n00:01:10,060 --> 00:01:11,070\r\nThe adrenaline pumped in.\r\n\r\n34\r\n00:01:11,070 --> 00:01:12,070\r\nI cycled away.\r\n\r\n35\r\n00:01:12,070 --> 00:01:14,010\r\nI was faster than the dog.\r\n\r\n36\r\n00:01:14,010 --> 00:01:15,040\r\nAnd I got away.\r\n\r\n37\r\n00:01:15,040 --> 00:01:17,040\r\nAnd I was thinking about it as I cycled around.\r\n\r\n38\r\n00:01:17,040 --> 00:01:18,030\r\nAnd I was thinking,\r\n\r\n39\r\n00:01:18,030 --> 00:01:20,030\r\nThat dog, I\'m gonna get him.\r\n\r\n40\r\n00:01:20,030 --> 00:01:22,030\r\nBecause I knew that at the end of the ride,\r\n\r\n41\r\n00:01:22,030 --> 00:01:24,080\r\nwe were going to go back past the same house.\r\n\r\n42\r\n00:01:24,080 --> 00:01:29,040\r\nAnd I spent the whole 20 miles thinking about this dog.\r\n\r\n43\r\n00:01:29,040 --> 00:01:31,010\r\nI\'m gonna reach down and I\'m gonna get my bike pump.\r\n\r\n44\r\n00:01:31,010 --> 00:01:35,020\r\nI\'m gonna jump off my bike, and I\'m gonna shout at the dog.\r\n\r\n45\r\n00:01:35,020 --> 00:01:37,050\r\nAnd as we approached the house, I did just that.\r\n\r\n46\r\n00:01:37,050 --> 00:01:38,040\r\nI was reaching down.\r\n\r\n47\r\n00:01:38,040 --> 00:01:39,070\r\nI had the bike pump ready.\r\n\r\n48\r\n00:01:39,070 --> 00:01:41,000\r\nI was all ready to get him.\r\n\r\n49\r\n00:01:41,000 --> 00:01:42,050\r\nAnd of course he didn\'t come out.\r\n\r\n50\r\n00:01:42,050 --> 00:01:45,040\r\nHe was asleep or something like that.\r\n\r\n51\r\n00:01:45,040 --> 00:01:47,050\r\nAnd I\'d wasted the whole bike ride\r\n\r\n52\r\n00:01:47,050 --> 00:01:49,070\r\nbeing angry, ready for this dog.\r\n\r\n53\r\n00:01:49,070 --> 00:01:50,080\r\nAnd I never got closure.\r\n\r\n54\r\n00:01:50,080 --> 00:01:52,040\r\nEven now, I\'m kind of thinking about it.\r\n\r\n55\r\n00:01:52,040 --> 00:01:53,040\r\nI never got closure.\r\n\r\n56\r\n00:01:53,040 --> 00:01:55,080\r\nI never got a chance to have a go at the dog.\r\n\r\n57\r\n00:01:55,080 --> 00:01:57,030\r\nAnd what I should have done was let it go,\r\n\r\n58\r\n00:01:57,030 --> 00:01:59,010\r\nbut it\'s hard to do because you\'ve got these chemicals\r\n\r\n59\r\n00:01:59,010 --> 00:02:01,070\r\ngoing through your bloodstream.\r\n\r\n60\r\n00:02:01,070 --> 00:02:03,010\r\nSo the moral of this story I think is\r\n\r\n61\r\n00:02:03,010 --> 00:02:05,050\r\nthat with an animal there\'s no other option.\r\n\r\n62\r\n00:02:05,050 --> 00:02:08,000\r\nIt\'s either dominate or be dominated.\r\n\r\n63\r\n00:02:08,000 --> 00:02:09,040\r\nBut if it was a person,\r\n\r\n64\r\n00:02:09,040 --> 00:02:13,010\r\nthe third option would have been much better.\r\n\r\n65\r\n00:02:13,010 --> 00:02:16,000\r\nNow another reason why it\'s not automatic\r\n\r\n66\r\n00:02:16,000 --> 00:02:18,050\r\nto be assertive is our upbringing.\r\n\r\n67\r\n00:02:18,050 --> 00:02:20,050\r\nSchool is pretty much a jungle.\r\n\r\n68\r\n00:02:20,050 --> 00:02:22,090\r\nIt\'s pretty much a fight or flight jungle.\r\n\r\n69\r\n00:02:22,090 --> 00:02:25,000\r\nKids haven\'t learned about assertiveness yet.\r\n\r\n70\r\n00:02:25,000 --> 00:02:26,090\r\nThey\'re still animals in this sense.\r\n\r\n71\r\n00:02:26,090 --> 00:02:28,060\r\nAnd kids understand this.\r\n\r\n72\r\n00:02:28,060 --> 00:02:31,080\r\nI can remember at school there was one of my classmates\r\n\r\n73\r\n00:02:31,080 --> 00:02:33,090\r\nwho was terrified of wasps.\r\n\r\n74\r\n00:02:33,090 --> 00:02:35,020\r\nAnd guess what happened?\r\n\r\n75\r\n00:02:35,020 --> 00:02:36,080\r\nEvery time he used to open his desk,\r\n\r\n76\r\n00:02:36,080 --> 00:02:38,010\r\nthere\'d be another wasp in there.\r\n\r\n77\r\n00:02:38,010 --> 00:02:39,060\r\nWe were awful to him,\r\n\r\n78\r\n00:02:39,060 --> 00:02:42,030\r\nand it was a jungle there.\r\n\r\n79\r\n00:02:42,030 --> 00:02:45,010\r\nAnd so our upbringing, our first experience really\r\n\r\n80\r\n00:02:45,010 --> 00:02:46,080\r\nof socialization\r\n\r\n81\r\n00:02:46,080 --> 00:02:49,000\r\nprobably doesn\'t encourage assertiveness.\r\n\r\n82\r\n00:02:49,000 --> 00:02:51,060\r\nAnd the role models that we have at that age.\r\n\r\n83\r\n00:02:51,060 --> 00:02:54,030\r\nThey might be our parents who might be great role models,\r\n\r\n84\r\n00:02:54,030 --> 00:02:56,050\r\nbut may not.\r\n\r\n85\r\n00:02:56,050 --> 00:02:58,000\r\nThey might be rock stars.\r\n\r\n86\r\n00:02:58,000 --> 00:02:59,090\r\nThey might be people in films.\r\n\r\n87\r\n00:02:59,090 --> 00:03:02,090\r\nAction heroes or cartoon princesses.\r\n\r\n88\r\n00:03:02,090 --> 00:03:05,030\r\nIt\'s pretty random who our role models are.\r\n\r\n89\r\n00:03:05,030 --> 00:03:06,080\r\nAnd often they\'re not very constructive\r\n\r\n90\r\n00:03:06,080 --> 00:03:08,050\r\nwhen it comes to learning to be assertive\r\n\r\n91\r\n00:03:08,050 --> 00:03:11,080\r\nin real life difficult situations.\r\n\r\n92\r\n00:03:11,080 --> 00:03:13,090\r\nSo that\'s two reasons already.\r\n\r\n93\r\n00:03:13,090 --> 00:03:16,060\r\nThe animal side of us and then our upbringing.\r\n\r\n94\r\n00:03:16,060 --> 00:03:19,070\r\nBut there\'s a third reason why assertiveness is difficult.\r\n\r\n95\r\n00:03:19,070 --> 00:03:21,070\r\nAnd that\'s that the other two options\r\n\r\n96\r\n00:03:21,070 --> 00:03:25,090\r\nof being aggressive and being too submissive or passive,\r\n\r\n97\r\n00:03:25,090 --> 00:03:29,030\r\nboth have perceived payoffs which are quite tempting.\r\n\r\n98\r\n00:03:29,030 --> 00:03:32,030\r\nBut actually are not as good as we hope.\r\n\r\n99\r\n00:03:32,030 --> 00:03:33,090\r\nThey\'re only perceived payoffs.\r\n\r\n100\r\n00:03:33,090 --> 00:03:36,040\r\nIf you think about the payoff of being aggressive.\r\n\r\n101\r\n00:03:36,040 --> 00:03:38,000\r\nYou tend to think that if you\'re aggressive\r\n\r\n102\r\n00:03:38,000 --> 00:03:39,060\r\nyou\'re going to bend other people to your will,\r\n\r\n103\r\n00:03:39,060 --> 00:03:41,030\r\nand you\'re going to get what you want.\r\n\r\n104\r\n00:03:41,030 --> 00:03:44,080\r\nAnd being aggressive can work sometimes,\r\n\r\n105\r\n00:03:44,080 --> 00:03:47,050\r\nbut all too often it doesn\'t work,\r\n\r\n106\r\n00:03:47,050 --> 00:03:49,040\r\nbecause the other person will fight back\r\n\r\n107\r\n00:03:49,040 --> 00:03:51,070\r\nor they\'ll get revenge later.\r\n\r\n108\r\n00:03:51,070 --> 00:03:54,030\r\nYou\'ll make an enemy, and it\'ll cost you more in the end.\r\n\r\n109\r\n00:03:54,030 --> 00:03:58,020\r\nAnd so being aggressive is not a good life strategy overall.\r\n\r\n110\r\n00:03:58,020 --> 00:03:59,050\r\nWhat about being a submissive?\r\n\r\n111\r\n00:03:59,050 --> 00:04:00,090\r\nWhat about letting other people have their way\r\n\r\n112\r\n00:04:00,090 --> 00:04:02,070\r\nin the hope that they\'re going to like you?\r\n\r\n113\r\n00:04:02,070 --> 00:04:05,020\r\nAnd the perceived payoff is that you\'ll have an easy life\r\n\r\n114\r\n00:04:05,020 --> 00:04:06,090\r\nand you\'ll be liked.\r\n\r\n115\r\n00:04:06,090 --> 00:04:09,030\r\nBut of course, instead of saying something at the time,\r\n\r\n116\r\n00:04:09,030 --> 00:04:10,090\r\nyou end up bottling it up.\r\n\r\n117\r\n00:04:10,090 --> 00:04:12,080\r\nYou end up not getting what you want,\r\n\r\n118\r\n00:04:12,080 --> 00:04:15,000\r\nand it all it does is add to your stress,\r\n\r\n119\r\n00:04:15,000 --> 00:04:17,000\r\nand you never get closure.\r\n\r\n120\r\n00:04:17,000 --> 00:04:18,010\r\nI\'ll give you a quick example of a time\r\n\r\n121\r\n00:04:18,010 --> 00:04:20,060\r\nwhen I wasn\'t assertive enough.\r\n\r\n122\r\n00:04:20,060 --> 00:04:23,050\r\nI used to share an office with a guy called Paul.\r\n\r\n123\r\n00:04:23,050 --> 00:04:25,090\r\nAnd he used to irritate me anyway,\r\n\r\n124\r\n00:04:25,090 --> 00:04:28,070\r\n\'cause he used to not answer my phone when I was away.\r\n\r\n125\r\n00:04:28,070 --> 00:04:29,080\r\nHe never left me messages.\r\n\r\n126\r\n00:04:29,080 --> 00:04:32,020\r\nI used to leave him messages of people who\'d called.\r\n\r\n127\r\n00:04:32,020 --> 00:04:34,010\r\nBut one day he did something which really upset me,\r\n\r\n128\r\n00:04:34,010 --> 00:04:36,050\r\nwas he brought his lunch back to the office,\r\n\r\n129\r\n00:04:36,050 --> 00:04:39,080\r\nand he was eating fried egg and baked beans.\r\n\r\n130\r\n00:04:39,080 --> 00:04:42,050\r\nAnd the whole office stank of beans.\r\n\r\n131\r\n00:04:42,050 --> 00:04:45,050\r\nAnd I remember thinking if he does it again,\r\n\r\n132\r\n00:04:45,050 --> 00:04:48,010\r\nI\'m going to say something to him about it.\r\n\r\n133\r\n00:04:48,010 --> 00:04:49,060\r\nBut I thought I won\'t say something this time.\r\n\r\n134\r\n00:04:49,060 --> 00:04:51,020\r\nI\'ll wait and I\'ll see if he does it a second time\r\n\r\n135\r\n00:04:51,020 --> 00:04:52,060\r\nand then I\'ll say something.\r\n\r\n136\r\n00:04:52,060 --> 00:04:54,050\r\nBut he never did it again.\r\n\r\n137\r\n00:04:54,050 --> 00:04:56,040\r\nAnd the ridiculous thing is\r\n\r\n138\r\n00:04:56,040 --> 00:04:59,050\r\nI\'ve still got that thought in my mind years later\r\n\r\n139\r\n00:04:59,050 --> 00:05:00,090\r\nthat if he does it again I\'ll say something.\r\n\r\n140\r\n00:05:00,090 --> 00:05:02,090\r\nBecause I never got closure on it.\r\n\r\n141\r\n00:05:02,090 --> 00:05:04,010\r\nI never needed to.\r\n\r\n142\r\n00:05:04,010 --> 00:05:05,010\r\nAnd of course what probably have happened\r\n\r\n143\r\n00:05:05,010 --> 00:05:06,060\r\nis if he\'d done it again I would have bottled it up\r\n\r\n144\r\n00:05:06,060 --> 00:05:08,040\r\nuntil he\'d done it about five times,\r\n\r\n145\r\n00:05:08,040 --> 00:05:10,020\r\nand then suddenly I would have flipped\r\n\r\n146\r\n00:05:10,020 --> 00:05:12,060\r\nfrom being too submissive to being aggressive.\r\n\r\n147\r\n00:05:12,060 --> 00:05:13,040\r\nAnd I suddenly would have gone,\r\n\r\n148\r\n00:05:13,040 --> 00:05:15,050\r\nPaul, stop eating those beans!\r\n\r\n149\r\n00:05:15,050 --> 00:05:17,040\r\nAnd then that would have been totally the wrong approach.\r\n\r\n150\r\n00:05:17,040 --> 00:05:18,070\r\nHe would\'ve said, \"Well I didn\'t know it was a problem.\r\n\r\n151\r\n00:05:18,070 --> 00:05:20,010\r\n\"You never told me.\"\r\n\r\n152\r\n00:05:20,010 --> 00:05:22,080\r\nSo bottling it up and then exploding and swinging\r\n\r\n153\r\n00:05:22,080 --> 00:05:28,010\r\nfrom one end of the scale to the other is not a good plan.\r\n\r\n154\r\n00:05:28,010 --> 00:05:30,030\r\nSulking, what can we do about this?\r\n\r\n155\r\n00:05:30,030 --> 00:05:31,090\r\nI suppose the first thing is to realize\r\n\r\n156\r\n00:05:31,090 --> 00:05:33,020\r\nthat we are animals.\r\n\r\n157\r\n00:05:33,020 --> 00:05:34,050\r\nWe have to make allowance for the fact\r\n\r\n158\r\n00:05:34,050 --> 00:05:37,060\r\nthat we\'ve got these chemicals that go through our systems.\r\n\r\n159\r\n00:05:37,060 --> 00:05:40,050\r\nAnd then we should use the power of our conscious brains\r\n\r\n160\r\n00:05:40,050 --> 00:05:42,070\r\nto take control of how we react.\r\n\r\n161\r\n00:05:42,070 --> 00:05:45,050\r\nTo think before we act, because we do have control\r\n\r\n162\r\n00:05:45,050 --> 00:05:47,080\r\nover how we act in situations.\r\n\r\n163\r\n00:05:47,080 --> 00:05:50,010\r\nAnd that\'s really what this course is about.\r\n\r\n164\r\n00:05:50,010 --> 00:05:52,080\r\nBeing aware of yourself in situations,\r\n\r\n165\r\n00:05:52,080 --> 00:05:55,040\r\nand then using the best strategies for those.\r\n\r\n166\r\n00:05:55,040 --> 00:05:58,000\r\nSo I\'d like you start thinking about situations\r\n\r\n167\r\n00:05:58,000 --> 00:06:00,040\r\nwhere maybe you could\'ve been more assertive.\r\n\r\n168\r\n00:06:00,040 --> 00:06:02,030\r\nMaybe you became a bit more aggressive\r\n\r\n169\r\n00:06:02,030 --> 00:06:05,020\r\nthan you should\'ve been, or maybe where you were too passive\r\n\r\n170\r\n00:06:05,020 --> 00:06:06,090\r\nand you let other people get away with things,\r\n\r\n171\r\n00:06:06,090 --> 00:06:07,080\r\nwhich is retrospect,\r\n\r\n172\r\n00:06:07,080 --> 00:06:09,080\r\nyou shouldn\'t have let them get away with.\r\n\r\n173\r\n00:06:09,080 --> 00:06:11,070\r\nStart thinking about those situations\r\n\r\n174\r\n00:06:11,070 --> 00:06:13,010\r\nand start thinking about whether\r\n\r\n175\r\n00:06:13,010 --> 00:06:16,000\r\nthe middle way would\'ve been more productive for you.\r\n\r\n"
                  },
                  new Video
                  {
                    Title = "Understanding your rights and responsibilities",
                    Slug = "understanding-your-rights-and-responsibilities",
                    Duration = 155,
                    DownloadUrl = "https://dms.licdn.com/playlist/C4D0DAQGTR3TpIjLqgg/learning-original-video-iphone-360/0/1598507260818?e=1619539200&v=beta&t=2IKTylBTZGgEhD6alDV5ussemD7dk9xtIQBskbYIdj0#.mp4",
                    TranscriptLines = null,
                    Transcript = "1\r\n00:00:00,050 --> 00:00:03,070\r\n- Now a major part of assertiveness is about rights.\r\n\r\n2\r\n00:00:03,070 --> 00:00:06,010\r\nIt\'s about your rights and the rights of other people.\r\n\r\n3\r\n00:00:06,010 --> 00:00:09,030\r\nSo, the objective is to stand up for your own rights,\r\n\r\n4\r\n00:00:09,030 --> 00:00:12,050\r\nwhile also respecting the rights of other people.\r\n\r\n5\r\n00:00:12,050 --> 00:00:15,020\r\nSo for example, I\'ve got a right to wear this shirt.\r\n\r\n6\r\n00:00:15,020 --> 00:00:18,010\r\nYou\'ve got a right to dislike this shirt.\r\n\r\n7\r\n00:00:18,010 --> 00:00:19,080\r\nI\'ve got a right to ignore the fact that you don\'t\r\n\r\n8\r\n00:00:19,080 --> 00:00:21,000\r\nlike this shirt.\r\n\r\n9\r\n00:00:21,000 --> 00:00:22,080\r\nI think it\'s okay, I\'m happy.\r\n\r\n10\r\n00:00:22,080 --> 00:00:24,090\r\nBy the way, if you really hate this shirt,\r\n\r\n11\r\n00:00:24,090 --> 00:00:28,020\r\nI should respect your right to hate this shirt\r\n\r\n12\r\n00:00:28,020 --> 00:00:30,010\r\nand I should wear a different shirt.\r\n\r\n13\r\n00:00:30,010 --> 00:00:32,000\r\nOther rights to be heard.\r\n\r\n14\r\n00:00:32,000 --> 00:00:34,020\r\nSo for example in a meeting, you might speak up\r\n\r\n15\r\n00:00:34,020 --> 00:00:36,060\r\nthey may not hear you and you might think\r\n\r\n16\r\n00:00:36,060 --> 00:00:38,000\r\noh well, I don\'t want to say it a second time\r\n\r\n17\r\n00:00:38,000 --> 00:00:39,040\r\nbecause I don\'t want to be boring,\r\n\r\n18\r\n00:00:39,040 --> 00:00:40,050\r\nbut you\'ve got a right to be heard.\r\n\r\n19\r\n00:00:40,050 --> 00:00:42,010\r\nYou\'ve got a right to repeat yourself\r\n\r\n20\r\n00:00:42,010 --> 00:00:43,090\r\nuntil they acknowledge what you\'ve said\r\n\r\n21\r\n00:00:43,090 --> 00:00:46,000\r\neven if they disagree with it.\r\n\r\n22\r\n00:00:46,000 --> 00:00:49,060\r\nAnd you\'ve also got a right to be able to say how you feel.\r\n\r\n23\r\n00:00:49,060 --> 00:00:51,040\r\nEveryone has a right to say how they feel.\r\n\r\n24\r\n00:00:51,040 --> 00:00:52,080\r\nIf they\'re not happy about something,\r\n\r\n25\r\n00:00:52,080 --> 00:00:57,010\r\nthey\'ve got a right to have that feeling and to express it.\r\n\r\n26\r\n00:00:57,010 --> 00:01:00,000\r\nOne of the things I regret teaching my wife a long time ago\r\n\r\n27\r\n00:01:00,000 --> 00:01:03,060\r\nis the little phrase, \"I don\'t have to justify how I feel.\"\r\n\r\n28\r\n00:01:03,060 --> 00:01:05,070\r\nand she uses this on me quite often, actually.\r\n\r\n29\r\n00:01:05,070 --> 00:01:06,060\r\nWhen I\'m saying to her,\r\n\r\n30\r\n00:01:06,060 --> 00:01:08,030\r\n\"Why don\'t you want to see this film?\"\r\n\r\n31\r\n00:01:08,030 --> 00:01:10,020\r\nor, \"Why don\'t you like that?\"\r\n\r\n32\r\n00:01:10,020 --> 00:01:13,030\r\nShe just says, \"Well, I don\'t have to justify how I feel.\"\r\n\r\n33\r\n00:01:13,030 --> 00:01:15,050\r\nAnd she\'s right, she doesn\'t have to justify.\r\n\r\n34\r\n00:01:15,050 --> 00:01:16,090\r\nShe can have any feeling she likes\r\n\r\n35\r\n00:01:16,090 --> 00:01:20,030\r\nand she can express them.\r\n\r\n36\r\n00:01:20,030 --> 00:01:23,000\r\nSome other examples of rights might be\r\n\r\n37\r\n00:01:23,000 --> 00:01:26,040\r\nsaying something that\'s a little bit unpopular in a meeting.\r\n\r\n38\r\n00:01:26,040 --> 00:01:29,050\r\nI can remember once in a meeting it was losing it\'s thread.\r\n\r\n39\r\n00:01:29,050 --> 00:01:30,070\r\nIt had gone way off track.\r\n\r\n40\r\n00:01:30,070 --> 00:01:32,030\r\nThere was no progress being made\r\n\r\n41\r\n00:01:32,030 --> 00:01:33,080\r\nand I remember I suddenly said this; I just said,\r\n\r\n42\r\n00:01:33,080 --> 00:01:35,010\r\n\"Look, this meeting\'s...\r\n\r\n43\r\n00:01:35,010 --> 00:01:37,020\r\n\'but where are we going in this meeting?\"\r\n\r\n44\r\n00:01:37,020 --> 00:01:38,050\r\nAnd they all went a bit quiet\r\n\r\n45\r\n00:01:38,050 --> 00:01:40,030\r\nand then afterwards they all said to me,\r\n\r\n46\r\n00:01:40,030 --> 00:01:42,030\r\n\"Chris, we\'re really glad you said that.\r\n\r\n47\r\n00:01:42,030 --> 00:01:43,050\r\n\'We all thought that.\"\r\n\r\n48\r\n00:01:43,050 --> 00:01:45,030\r\nBut none of them had been assertive enough\r\n\r\n49\r\n00:01:45,030 --> 00:01:47,020\r\nto just stand up for themselves in the meeting\r\n\r\n50\r\n00:01:47,020 --> 00:01:48,090\r\nand say, \"Look what\'s going on?\"\r\n\r\n51\r\n00:01:48,090 --> 00:01:50,080\r\nSo, speaking up in front of other people\r\n\r\n52\r\n00:01:50,080 --> 00:01:53,020\r\nis a right you\'ve got.\r\n\r\n53\r\n00:01:53,020 --> 00:01:54,060\r\nSo, I want you to think about\r\n\r\n54\r\n00:01:54,060 --> 00:01:57,010\r\ndo you stand up enough for your personal rights?\r\n\r\n55\r\n00:01:57,010 --> 00:01:57,080\r\nWhich of your rights\r\n\r\n56\r\n00:01:57,080 --> 00:02:00,070\r\nhave you perhaps not stood up for recently?\r\n\r\n57\r\n00:02:00,070 --> 00:02:04,010\r\nAnd also, are you respecting the rights of other people\r\n\r\n58\r\n00:02:04,010 --> 00:02:06,040\r\nand this second one can be difficult\r\n\r\n59\r\n00:02:06,040 --> 00:02:09,020\r\nbecause it\'s hard to see it from their point of view.\r\n\r\n60\r\n00:02:09,020 --> 00:02:10,090\r\nSo, are you sure\r\n\r\n61\r\n00:02:10,090 --> 00:02:13,000\r\nthat you\'re respecting the rights of others?\r\n\r\n62\r\n00:02:13,000 --> 00:02:15,070\r\nAnd remember that you are responsible for everything\r\n\r\n63\r\n00:02:15,070 --> 00:02:18,050\r\nthat you think and say and do.\r\n\r\n64\r\n00:02:18,050 --> 00:02:20,060\r\nSo, if you don\'t respect the rights of somebody else,\r\n\r\n65\r\n00:02:20,060 --> 00:02:22,020\r\nor if you don\'t stand up for your own,\r\n\r\n66\r\n00:02:22,020 --> 00:02:23,070\r\nyou are responsible for that\r\n\r\n67\r\n00:02:23,070 --> 00:02:26,020\r\nand you\'ve chosen to not do that.\r\n\r\n68\r\n00:02:26,020 --> 00:02:29,010\r\nSo, have a think about rights and see if there are areas\r\n\r\n69\r\n00:02:29,010 --> 00:02:31,060\r\nwhere maybe you could be a little bit stronger,\r\n\r\n70\r\n00:02:31,060 --> 00:02:35,000\r\nbut also a little bit more respectful to other people.\r\n\r\n"
                  },
                  new Video
                  {
                    Title = "Identifying your current mindset",
                    Slug = "identifying-your-current-mindset",
                    Duration = 297,
                    DownloadUrl = "https://dms.licdn.com/playlist/C560DAQG8umlJSkFFmA/learning-original-video-iphone-360/0/1598507057834?e=1619539200&v=beta&t=88XkNWMeAlCn_MDsn2jQo7XGhspCYIJRr82AYrSWuH8#.mp4",
                    TranscriptLines = null,
                    Transcript = "1\r\n00:00:00,090 --> 00:00:03,010\r\n- Now we\'ve been talking about rights.\r\n\r\n2\r\n00:00:03,010 --> 00:00:05,020\r\nWhether you stand up for your own rights or not\r\n\r\n3\r\n00:00:05,020 --> 00:00:07,030\r\nreally depends on whether you believe\r\n\r\n4\r\n00:00:07,030 --> 00:00:09,050\r\nthat you deserve to be able to stand up for your rights,\r\n\r\n5\r\n00:00:09,050 --> 00:00:11,060\r\nare you okay about yourself.\r\n\r\n6\r\n00:00:11,060 --> 00:00:13,040\r\nAnd similarly, whether you stand up for\r\n\r\n7\r\n00:00:13,040 --> 00:00:16,000\r\nother people\'s rights and respect their views\r\n\r\n8\r\n00:00:16,000 --> 00:00:19,010\r\ndepends on whether you believe that they are ok enough\r\n\r\n9\r\n00:00:19,010 --> 00:00:21,030\r\nto deserve to have those rights.\r\n\r\n10\r\n00:00:21,030 --> 00:00:24,000\r\nThis idea of being okay is essential\r\n\r\n11\r\n00:00:24,000 --> 00:00:26,020\r\nto the subject of assertiveness.\r\n\r\n12\r\n00:00:26,020 --> 00:00:29,040\r\nThe word \"okay\" is quite an important word to define.\r\n\r\n13\r\n00:00:29,040 --> 00:00:31,090\r\nWe\'re not talking about believing that you\'re perfect,\r\n\r\n14\r\n00:00:31,090 --> 00:00:34,040\r\nor believing that you\'re better than everybody else.\r\n\r\n15\r\n00:00:34,040 --> 00:00:36,070\r\nYou\'ve just gotta believe that you\'re okay as a person.\r\n\r\n16\r\n00:00:36,070 --> 00:00:38,070\r\nYou\'re good enough to deserve to have rights\r\n\r\n17\r\n00:00:38,070 --> 00:00:40,090\r\nand to stand up for them.\r\n\r\n18\r\n00:00:40,090 --> 00:00:44,020\r\nIt\'s important to think about, are you okay?\r\n\r\n19\r\n00:00:44,020 --> 00:00:47,000\r\nDo you think that you\'re generally all right as a person?\r\n\r\n20\r\n00:00:47,000 --> 00:00:49,040\r\nAnd also other people. Is your starting point with\r\n\r\n21\r\n00:00:49,040 --> 00:00:52,040\r\nother people that they\'re generally okay or not.\r\n\r\n22\r\n00:00:52,040 --> 00:00:54,090\r\nIt\'s not gonna be good for relationships if your starting\r\n\r\n23\r\n00:00:54,090 --> 00:00:59,030\r\nposition is that other people are generally not okay.\r\n\r\n24\r\n00:00:59,030 --> 00:01:02,030\r\nWe can draw a little 2x2 matrix of this.\r\n\r\n25\r\n00:01:02,030 --> 00:01:04,040\r\nOn the vertical axis we\'re gonna have\r\n\r\n26\r\n00:01:04,040 --> 00:01:06,000\r\nwhether you\'re okay or not.\r\n\r\n27\r\n00:01:06,000 --> 00:01:07,090\r\nSo we\'re gonna have you\'re okay and you\'re not ok\r\n\r\n28\r\n00:01:07,090 --> 00:01:09,050\r\non the vertical axis.\r\n\r\n29\r\n00:01:09,050 --> 00:01:11,000\r\nOn the horizontal axis we\'re gonna have\r\n\r\n30\r\n00:01:11,000 --> 00:01:12,090\r\nhow you feel about other people.\r\n\r\n31\r\n00:01:12,090 --> 00:01:15,010\r\nDo you generally believe that other people are okay,\r\n\r\n32\r\n00:01:15,010 --> 00:01:17,000\r\nor that they\'re not okay.\r\n\r\n33\r\n00:01:17,000 --> 00:01:18,030\r\nIf you look at the combinations,\r\n\r\n34\r\n00:01:18,030 --> 00:01:21,010\r\nclearly the top left is where we want to be\r\n\r\n35\r\n00:01:21,010 --> 00:01:25,040\r\nfor the best results in any relationship.\r\n\r\n36\r\n00:01:25,040 --> 00:01:28,080\r\nThe problems start to happen in the other boxes.\r\n\r\n37\r\n00:01:28,080 --> 00:01:32,000\r\nThis top left one, where we believe we\'re okay and they are,\r\n\r\n38\r\n00:01:32,000 --> 00:01:33,090\r\nthat\'s where assertiveness is\r\n\r\n39\r\n00:01:33,090 --> 00:01:35,050\r\nand that\'s where we want to be.\r\n\r\n40\r\n00:01:35,050 --> 00:01:37,080\r\nBut what about the top right?\r\n\r\n41\r\n00:01:37,080 --> 00:01:39,060\r\nWhere you believe that you\'re okay,\r\n\r\n42\r\n00:01:39,060 --> 00:01:41,060\r\nbut the other person is not.\r\n\r\n43\r\n00:01:41,060 --> 00:01:43,060\r\nThis is the aggressive box, and there are\r\n\r\n44\r\n00:01:43,060 --> 00:01:46,020\r\npeople who naturally gravitate to this box.\r\n\r\n45\r\n00:01:46,020 --> 00:01:48,090\r\nTheir starting position is, \"The world is stupid.\"\r\n\r\n46\r\n00:01:48,090 --> 00:01:51,000\r\nI\'ve got an example of this\r\n\r\n47\r\n00:01:51,000 --> 00:01:52,090\r\nsomebody told me about in a hospital.\r\n\r\n48\r\n00:01:52,090 --> 00:01:55,030\r\nThere was a doctor there who had touched a patient,\r\n\r\n49\r\n00:01:55,030 --> 00:01:57,090\r\nand he was washing his hands after doing that.\r\n\r\n50\r\n00:01:57,090 --> 00:02:00,010\r\nWhen he looked around there were no towels,\r\n\r\n51\r\n00:02:00,010 --> 00:02:03,010\r\nso he pulled the curtain down off the wall,\r\n\r\n52\r\n00:02:03,010 --> 00:02:04,070\r\ndried his hands on the curtain,\r\n\r\n53\r\n00:02:04,070 --> 00:02:06,030\r\nand just threw it away on the floor and said,\r\n\r\n54\r\n00:02:06,030 --> 00:02:08,080\r\n\"Nurse, there\'s no towels!\"\r\n\r\n55\r\n00:02:08,080 --> 00:02:10,030\r\nAnd that\'s really aggressive.\r\n\r\n56\r\n00:02:10,030 --> 00:02:11,040\r\nHis belief is that he\'s the\r\n\r\n57\r\n00:02:11,040 --> 00:02:13,010\r\nonly person with a brain in that place,\r\n\r\n58\r\n00:02:13,010 --> 00:02:14,080\r\nand the rest of them are all idiots;\r\n\r\n59\r\n00:02:14,080 --> 00:02:16,050\r\nThat\'s really aggressive.\r\n\r\n60\r\n00:02:16,050 --> 00:02:18,010\r\nNot a good starting point.\r\n\r\n61\r\n00:02:18,010 --> 00:02:21,040\r\nThat\'s gonna harm the results that that doctor gets.\r\n\r\n62\r\n00:02:21,040 --> 00:02:23,050\r\nIf he needs help from other people they\'re not\r\n\r\n63\r\n00:02:23,050 --> 00:02:26,090\r\ngonna be on his side, it\'s not a good starting point.\r\n\r\n64\r\n00:02:26,090 --> 00:02:28,070\r\nThe nurses on the other hand in that situation,\r\n\r\n65\r\n00:02:28,070 --> 00:02:30,060\r\nthey were pushed into the bottom left,\r\n\r\n66\r\n00:02:30,060 --> 00:02:32,060\r\ninto the \"I\'m not okay\" box.\r\n\r\n67\r\n00:02:32,060 --> 00:02:34,070\r\nThey were submissively hiding behind\r\n\r\n68\r\n00:02:34,070 --> 00:02:35,090\r\none of the beds probably,\r\n\r\n69\r\n00:02:35,090 --> 00:02:38,040\r\nthinking, \"Oh no, we\'ve probably upset the doctor.\"\r\n\r\n70\r\n00:02:38,040 --> 00:02:39,060\r\nAnd you might think,\r\n\r\n71\r\n00:02:39,060 --> 00:02:42,060\r\n\"Not many people are gonna be in the I\'m not okay box.\"\r\n\r\n72\r\n00:02:42,060 --> 00:02:46,070\r\nBut actually it\'s very easy to be in the not okay box.\r\n\r\n73\r\n00:02:46,070 --> 00:02:49,060\r\nDo you like the sight of yourself in a mirror?\r\n\r\n74\r\n00:02:49,060 --> 00:02:51,070\r\nDo you like the sound of your voice\r\n\r\n75\r\n00:02:51,070 --> 00:02:53,070\r\non an answer phone message?\r\n\r\n76\r\n00:02:53,070 --> 00:02:55,030\r\nAnd people are often not even okay about\r\n\r\n77\r\n00:02:55,030 --> 00:02:57,030\r\nhow they look or how they sound.\r\n\r\n78\r\n00:02:57,030 --> 00:03:00,030\r\nLet alone all of the other intricacies of their personality.\r\n\r\n79\r\n00:03:00,030 --> 00:03:01,090\r\nThe thing is that the world is trying\r\n\r\n80\r\n00:03:01,090 --> 00:03:04,070\r\nto push us down into this not okay box.\r\n\r\n81\r\n00:03:04,070 --> 00:03:07,090\r\nYou look at women\'s magazines, they\'ve got beautiful people,\r\n\r\n82\r\n00:03:07,090 --> 00:03:10,000\r\nairbrushed, looking perfect.\r\n\r\n83\r\n00:03:10,000 --> 00:03:12,000\r\nAnd there\'s pressure on us\r\n\r\n84\r\n00:03:12,000 --> 00:03:13,060\r\nto look like the women on the cover,\r\n\r\n85\r\n00:03:13,060 --> 00:03:15,090\r\nor the man on the cover of men\'s magazines\r\n\r\n86\r\n00:03:15,090 --> 00:03:17,090\r\nincreasingly as well.\r\n\r\n87\r\n00:03:17,090 --> 00:03:20,050\r\nSo it\'s very important to believe that you\'re okay\r\n\r\n88\r\n00:03:20,050 --> 00:03:23,020\r\nand to have, maybe a mantra, which is,\r\n\r\n89\r\n00:03:23,020 --> 00:03:26,010\r\n\"Nobody\'s gonna push me into the not okay box.\r\n\r\n90\r\n00:03:26,010 --> 00:03:27,070\r\n\"I\'m okay as a person.\r\n\r\n91\r\n00:03:27,070 --> 00:03:29,020\r\n\"I\'m not perfect, but I\'m good enough,\r\n\r\n92\r\n00:03:29,020 --> 00:03:31,040\r\n\"and the world is not gonna tell me that I\'m not.\r\n\r\n93\r\n00:03:31,040 --> 00:03:34,060\r\n\"I\'ll decide whether I\'m okay or not.\"\r\n\r\n94\r\n00:03:34,060 --> 00:03:36,070\r\nNow there is one more box that I haven\'t mentioned:\r\n\r\n95\r\n00:03:36,070 --> 00:03:40,080\r\nThe I\'m not okay and the world is also not okay box.\r\n\r\n96\r\n00:03:40,080 --> 00:03:44,090\r\nThis box is unsustainable, you can\'t live in this box.\r\n\r\n97\r\n00:03:44,090 --> 00:03:48,060\r\nApparently teenagers quite often start in the bottom left,\r\n\r\n98\r\n00:03:48,060 --> 00:03:51,030\r\nfeeling not okay, maybe they\'re spotty,\r\n\r\n99\r\n00:03:51,030 --> 00:03:54,000\r\nthey can\'t get a girlfriend, everything\'s too difficult.\r\n\r\n100\r\n00:03:54,000 --> 00:03:57,010\r\nAnd then as they start to lose respect for their parents\r\n\r\n101\r\n00:03:57,010 --> 00:03:59,050\r\nand discover their parents don\'t know all the answers either\r\n\r\n102\r\n00:03:59,050 --> 00:04:02,090\r\nthey start to move across into that bottom right box.\r\n\r\n103\r\n00:04:02,090 --> 00:04:05,000\r\nBut of course the problem is then you\'ve\r\n\r\n104\r\n00:04:05,000 --> 00:04:06,080\r\ngot nothing to cling to at all, nothing\'s all right.\r\n\r\n105\r\n00:04:06,080 --> 00:04:09,070\r\nThe theory goes that you have to come out\r\n\r\n106\r\n00:04:09,070 --> 00:04:12,040\r\neither by going upwards into the aggressive box of,\r\n\r\n107\r\n00:04:12,040 --> 00:04:15,040\r\n\"(scoffs) Everybody\'s a fool, they don\'t understand me.\r\n\r\n108\r\n00:04:15,040 --> 00:04:17,060\r\n\"They\'ve got no taste in cloths,\r\n\r\n109\r\n00:04:17,060 --> 00:04:19,020\r\n\"they\'ve got no musical taste.\"\r\n\r\n110\r\n00:04:19,020 --> 00:04:22,010\r\nOr they have to go back into the depressed box of,\r\n\r\n111\r\n00:04:22,010 --> 00:04:24,000\r\n\"Oh, I\'m just not good enough.\"\r\n\r\n112\r\n00:04:24,000 --> 00:04:26,030\r\nBut hopefully whichever box they come out into\r\n\r\n113\r\n00:04:26,030 --> 00:04:28,020\r\nthey will eventually find their way up into that\r\n\r\n114\r\n00:04:28,020 --> 00:04:31,010\r\ntop left box of believing that they\'re not too bad, really,\r\n\r\n115\r\n00:04:31,010 --> 00:04:33,000\r\nand the world isn\'t too bad really,\r\n\r\n116\r\n00:04:33,000 --> 00:04:35,060\r\nand they can get on with life.\r\n\r\n117\r\n00:04:35,060 --> 00:04:38,000\r\nI\'d like you to just think about yourself,\r\n\r\n118\r\n00:04:38,000 --> 00:04:39,070\r\nwhich is your home box.\r\n\r\n119\r\n00:04:39,070 --> 00:04:42,050\r\nDo you tend to be a bit too not okay about yourself,\r\n\r\n120\r\n00:04:42,050 --> 00:04:45,090\r\nor do you tend to assume that other people are not okay?\r\n\r\n121\r\n00:04:45,090 --> 00:04:48,030\r\nHopefully you\'re safely in that top left box\r\n\r\n122\r\n00:04:48,030 --> 00:04:51,010\r\nof believing that you\'re okay and that everyone else is.\r\n\r\n123\r\n00:04:51,010 --> 00:04:54,020\r\nNow remember: You decide whether you\'re okay.\r\n\r\n124\r\n00:04:54,020 --> 00:04:57,000\r\nNobody else can push you into that not okay box.\r\n\r\n"
                  },
                  new Video
                  {
                    Title = "Avoiding the passive-aggressive trap",
                    Slug = "avoiding-the-passive-aggressive-trap",
                    Duration = 171,
                    DownloadUrl = "https://dms.licdn.com/playlist/C4D0DAQEeq7CIGE4mgA/learning-original-video-iphone-360/0/1598507247837?e=1619539200&v=beta&t=rmro2QYex52e6d3yE9iBmdMrBg2RZghjOW2d-uOG0m4#.mp4",
                    TranscriptLines = null,
                    Transcript = "1\r\n00:00:00,070 --> 00:00:02,000\r\n- Now, there\'s one more combination\r\n\r\n2\r\n00:00:02,000 --> 00:00:03,040\r\nI haven\'t mentioned yet,\r\n\r\n3\r\n00:00:03,040 --> 00:00:05,020\r\nwhich is passive-aggressive.\r\n\r\n4\r\n00:00:05,020 --> 00:00:07,060\r\nWe\'ve only been looking at passive or submissive,\r\n\r\n5\r\n00:00:07,060 --> 00:00:08,090\r\nthey mean the same thing.\r\n\r\n6\r\n00:00:08,090 --> 00:00:12,010\r\nAnd aggressive, and then assertive as the right way.\r\n\r\n7\r\n00:00:12,010 --> 00:00:14,090\r\nBut what about if you didn\'t respect anybody\'s rights?\r\n\r\n8\r\n00:00:14,090 --> 00:00:16,040\r\nNot yours or theirs.\r\n\r\n9\r\n00:00:16,040 --> 00:00:17,080\r\nThat would be passive-aggressive,\r\n\r\n10\r\n00:00:17,080 --> 00:00:20,000\r\nand this is really the worst combination.\r\n\r\n11\r\n00:00:20,000 --> 00:00:24,060\r\nIt\'s not a halfway point, it\'s a lose-lose situation.\r\n\r\n12\r\n00:00:24,060 --> 00:00:26,080\r\nI\'m gonna give you a quick example of this,\r\n\r\n13\r\n00:00:26,080 --> 00:00:28,030\r\na story somebody told me on a training course,\r\n\r\n14\r\n00:00:28,030 --> 00:00:30,050\r\nI\'m sure it\'s true.\r\n\r\n15\r\n00:00:30,050 --> 00:00:32,020\r\nShe just bought this new car,\r\n\r\n16\r\n00:00:32,020 --> 00:00:34,020\r\nit\'s quite a cheap make of car.\r\n\r\n17\r\n00:00:34,020 --> 00:00:36,040\r\nBut it was new, it\'s the first ever new car she\'d had,\r\n\r\n18\r\n00:00:36,040 --> 00:00:37,060\r\nshe was really proud of it.\r\n\r\n19\r\n00:00:37,060 --> 00:00:39,090\r\nShe drove to the super-market in it.\r\n\r\n20\r\n00:00:39,090 --> 00:00:40,060\r\nAnd when she got there,\r\n\r\n21\r\n00:00:40,060 --> 00:00:43,070\r\nshe pulled up next to a Rolls-Royce,\r\n\r\n22\r\n00:00:43,070 --> 00:00:46,010\r\nand there was a very posh lady\r\n\r\n23\r\n00:00:46,010 --> 00:00:47,090\r\nwho was driving the Rolls-Royce,\r\n\r\n24\r\n00:00:47,090 --> 00:00:49,050\r\nand when the posh lady got out,\r\n\r\n25\r\n00:00:49,050 --> 00:00:52,080\r\nshe just slammed her door into the side of this new car,\r\n\r\n26\r\n00:00:52,080 --> 00:00:56,050\r\nand it put a big dent in the side of the car.\r\n\r\n27\r\n00:00:56,050 --> 00:00:59,040\r\nThose Rolls-Royce doors are really heavy.\r\n\r\n28\r\n00:00:59,040 --> 00:01:00,090\r\nThe Rolls-Royce lady didn\'t even notice,\r\n\r\n29\r\n00:01:00,090 --> 00:01:02,070\r\nshe just banged into the car, got out,\r\n\r\n30\r\n00:01:02,070 --> 00:01:04,090\r\nand she just walked her way to the super-market.\r\n\r\n31\r\n00:01:04,090 --> 00:01:06,060\r\nMeanwhile, the lady who\'d turned up\r\n\r\n32\r\n00:01:06,060 --> 00:01:08,030\r\nin her pride and joy new car,\r\n\r\n33\r\n00:01:08,030 --> 00:01:09,060\r\nwent running around to the side,\r\n\r\n34\r\n00:01:09,060 --> 00:01:11,070\r\nhad a look and saw the dent.\r\n\r\n35\r\n00:01:11,070 --> 00:01:15,010\r\nNow, what would you do if that happened to you?\r\n\r\n36\r\n00:01:15,010 --> 00:01:16,080\r\nReally, you\'ve got various options.\r\n\r\n37\r\n00:01:16,080 --> 00:01:18,020\r\nYou could be passive and just think,\r\n\r\n38\r\n00:01:18,020 --> 00:01:20,080\r\n\"Ugh, typical of my luck.\"\r\n\r\n39\r\n00:01:20,080 --> 00:01:23,020\r\nYou could be aggressive and go and shout at the woman,\r\n\r\n40\r\n00:01:23,020 --> 00:01:25,050\r\n\"You\'ve ruined my car!\"\r\n\r\n41\r\n00:01:25,050 --> 00:01:27,050\r\nOf course, the best option is to be assertive\r\n\r\n42\r\n00:01:27,050 --> 00:01:28,080\r\nand to go running after the lady and say,\r\n\r\n43\r\n00:01:28,080 --> 00:01:30,050\r\n\"Excuse me, you probably didn\'t notice,\r\n\r\n44\r\n00:01:30,050 --> 00:01:32,020\r\n\"you\'ve just dented my car,\r\n\r\n45\r\n00:01:32,020 --> 00:01:33,030\r\n\"would you be able to pay for it?\"\r\n\r\n46\r\n00:01:33,030 --> 00:01:34,090\r\nShe\'d probably be fine about paying for it,\r\n\r\n47\r\n00:01:34,090 --> 00:01:36,080\r\nso it\'d probably be fine.\r\n\r\n48\r\n00:01:36,080 --> 00:01:38,050\r\nBut the worst option, the fourth one,\r\n\r\n49\r\n00:01:38,050 --> 00:01:40,000\r\nis to be passive-aggressive.\r\n\r\n50\r\n00:01:40,000 --> 00:01:41,090\r\nAnd this is what the lady actually did.\r\n\r\n51\r\n00:01:41,090 --> 00:01:44,050\r\nShe got out her keys of her brand new car\r\n\r\n52\r\n00:01:44,050 --> 00:01:47,030\r\nand she went up and down the side of the Rolls-Royce,\r\n\r\n53\r\n00:01:47,030 --> 00:01:50,020\r\ngreat big scratch down the Rolls-Royce.\r\n\r\n54\r\n00:01:50,020 --> 00:01:52,040\r\nIf you think about it, that\'s just lose-lose,\r\n\r\n55\r\n00:01:52,040 --> 00:01:53,090\r\nit doesn\'t help anybody.\r\n\r\n56\r\n00:01:53,090 --> 00:01:55,080\r\nBecause her new car still got a dent,\r\n\r\n57\r\n00:01:55,080 --> 00:01:58,000\r\nnow the Rolls-Royce is scratched as well.\r\n\r\n58\r\n00:01:58,000 --> 00:02:00,030\r\nShe\'s being aggressive, not against the woman,\r\n\r\n59\r\n00:02:00,030 --> 00:02:01,080\r\nbut against her car,\r\n\r\n60\r\n00:02:01,080 --> 00:02:03,010\r\nand that doesn\'t solve anything.\r\n\r\n61\r\n00:02:03,010 --> 00:02:04,060\r\nShe\'s gonna come back to her car and think,\r\n\r\n62\r\n00:02:04,060 --> 00:02:06,050\r\n\"Ugh, look what someone\'s done.\"\r\n\r\n63\r\n00:02:06,050 --> 00:02:08,080\r\nShe\'s not even gonna know why.\r\n\r\n64\r\n00:02:08,080 --> 00:02:12,080\r\nPassive-aggressive is quite a tempting option,\r\n\r\n65\r\n00:02:12,080 --> 00:02:14,050\r\nbecause the chemicals are in our blood,\r\n\r\n66\r\n00:02:14,050 --> 00:02:15,090\r\nwe feel aggressive,\r\n\r\n67\r\n00:02:15,090 --> 00:02:17,050\r\nbut we\'re not actually assertive enough to actually\r\n\r\n68\r\n00:02:17,050 --> 00:02:21,020\r\nconfront the person, so we take it out against the car.\r\n\r\n69\r\n00:02:21,020 --> 00:02:24,000\r\nA common work example of passive-aggressive\r\n\r\n70\r\n00:02:24,000 --> 00:02:27,000\r\nwould be criticizing people behind their back.\r\n\r\n71\r\n00:02:27,000 --> 00:02:28,080\r\nYou\'re being aggressive about the person,\r\n\r\n72\r\n00:02:28,080 --> 00:02:30,060\r\nbut you\'re being passive in terms of,\r\n\r\n73\r\n00:02:30,060 --> 00:02:33,010\r\nyou\'re not actually confronting them.\r\n\r\n74\r\n00:02:33,010 --> 00:02:36,000\r\nSo, you might find it interesting just to think about,\r\n\r\n75\r\n00:02:36,000 --> 00:02:38,020\r\nhave you been passive-aggressive at all recently?\r\n\r\n76\r\n00:02:38,020 --> 00:02:40,000\r\nIs it a tendency that you have?\r\n\r\n77\r\n00:02:40,000 --> 00:02:42,060\r\nAnd what would the assertive option look like?\r\n\r\n78\r\n00:02:42,060 --> 00:02:45,060\r\nWhat would it look and feel like to calmly\r\n\r\n79\r\n00:02:45,060 --> 00:02:48,000\r\nconfront the person and tell them about\r\n\r\n80\r\n00:02:48,000 --> 00:02:51,000\r\nhow you feel, and what you would like to happen.\r\n\r\n"
                  },
                  new Video
                  {
                    Title = "Changing your inner dialogue",
                    Slug = "changing-your-inner-dialogue",
                    Duration = 206,
                    DownloadUrl = "https://dms.licdn.com/playlist/C4D0DAQG_GnbHkt896A/learning-original-video-iphone-360/0/1598507257910?e=1619539200&v=beta&t=sEMc_JUjSMYHX9-GNfYAJCh6-f4HVbtCG0AkeyRveik#.mp4",
                    TranscriptLines = null,
                    Transcript = "1\r\n00:00:00,070 --> 00:00:03,090\r\n- So can you change yourself?\r\n\r\n2\r\n00:00:03,090 --> 00:00:06,090\r\nUndoubtedly there\'s a small amount of you that\'s inherited,\r\n\r\n3\r\n00:00:06,090 --> 00:00:08,010\r\nbut I think you\'ll agree\r\n\r\n4\r\n00:00:08,010 --> 00:00:10,070\r\nthat things like a short temper or shyness\r\n\r\n5\r\n00:00:10,070 --> 00:00:12,040\r\nare learned behaviors\r\n\r\n6\r\n00:00:12,040 --> 00:00:16,030\r\nrather than inherited, unchangeable traits.\r\n\r\n7\r\n00:00:16,030 --> 00:00:18,080\r\nMost of your personality consists of learned habits\r\n\r\n8\r\n00:00:18,080 --> 00:00:21,020\r\nthat you\'ve built up during your life so far.\r\n\r\n9\r\n00:00:21,020 --> 00:00:23,090\r\nAnd these are known as life scripts.\r\n\r\n10\r\n00:00:23,090 --> 00:00:25,070\r\nExamples of life scripts could be:\r\n\r\n11\r\n00:00:25,070 --> 00:00:27,000\r\nI\'m impatient.\r\n\r\n12\r\n00:00:27,000 --> 00:00:28,020\r\nI\'m shy.\r\n\r\n13\r\n00:00:28,020 --> 00:00:30,000\r\nI hate giving talks.\r\n\r\n14\r\n00:00:30,000 --> 00:00:32,040\r\nI always think of the best thing to say afterwards\r\n\r\n15\r\n00:00:32,040 --> 00:00:34,020\r\nwhen it\'s too late.\r\n\r\n16\r\n00:00:34,020 --> 00:00:35,080\r\nThose are typical life scripts.\r\n\r\n17\r\n00:00:35,080 --> 00:00:37,070\r\nYou can have good scripts too.\r\n\r\n18\r\n00:00:37,070 --> 00:00:39,060\r\nLike I\'m good under pressure.\r\n\r\n19\r\n00:00:39,060 --> 00:00:41,000\r\nI love giving talks.\r\n\r\n20\r\n00:00:41,000 --> 00:00:43,000\r\nI like meeting new people.\r\n\r\n21\r\n00:00:43,000 --> 00:00:44,060\r\nAny statement that starts with,\r\n\r\n22\r\n00:00:44,060 --> 00:00:47,000\r\n\"I can\'t help,\" or \"I always seem to,\"\r\n\r\n23\r\n00:00:47,000 --> 00:00:49,090\r\nor \"I\'m hopeless at,\" or \"I\'m great at,\"\r\n\r\n24\r\n00:00:49,090 --> 00:00:52,020\r\nthese are all scripts.\r\n\r\n25\r\n00:00:52,020 --> 00:00:54,060\r\nAnd they can be changed.\r\n\r\n26\r\n00:00:54,060 --> 00:00:56,020\r\nScripts get stronger with time,\r\n\r\n27\r\n00:00:56,020 --> 00:00:59,030\r\nbecause beliefs lead to thoughts and behaviors,\r\n\r\n28\r\n00:00:59,030 --> 00:01:02,000\r\nwhich then lead to events happening.\r\n\r\n29\r\n00:01:02,000 --> 00:01:05,020\r\nAnd these strengthen your beliefs.\r\n\r\n30\r\n00:01:05,020 --> 00:01:06,030\r\nI know I\'m impatient.\r\n\r\n31\r\n00:01:06,030 --> 00:01:08,070\r\nI\'ve got 50 years of evidence of myself\r\n\r\n32\r\n00:01:08,070 --> 00:01:10,090\r\nstamping my feet in cues.\r\n\r\n33\r\n00:01:10,090 --> 00:01:13,060\r\nAnd my belief about myself leads to my behavior,\r\n\r\n34\r\n00:01:13,060 --> 00:01:17,070\r\nwhich gives me more and more evidence that that\'s how I am.\r\n\r\n35\r\n00:01:17,070 --> 00:01:20,000\r\nSo to change yourself means\r\n\r\n36\r\n00:01:20,000 --> 00:01:22,030\r\nchanging at the very least your behaviors,\r\n\r\n37\r\n00:01:22,030 --> 00:01:25,020\r\nbut ideally your underlying thoughts and beliefs\r\n\r\n38\r\n00:01:25,020 --> 00:01:26,060\r\nabout yourself too.\r\n\r\n39\r\n00:01:26,060 --> 00:01:27,080\r\nBut can this be done?\r\n\r\n40\r\n00:01:27,080 --> 00:01:29,040\r\nAnd the answer is yes.\r\n\r\n41\r\n00:01:29,040 --> 00:01:32,000\r\nAnd you can do it by changing your self talk.\r\n\r\n42\r\n00:01:32,000 --> 00:01:35,010\r\nThe words that you say in your head.\r\n\r\n43\r\n00:01:35,010 --> 00:01:37,020\r\nYour subconscious is listening to everything\r\n\r\n44\r\n00:01:37,020 --> 00:01:39,020\r\nthat you say to yourself.\r\n\r\n45\r\n00:01:39,020 --> 00:01:42,030\r\nBy the way, do you have a voice in your head?\r\n\r\n46\r\n00:01:42,030 --> 00:01:44,040\r\nOne voice in your head is good.\r\n\r\n47\r\n00:01:44,040 --> 00:01:45,070\r\nHopefully you haven\'t got two voices\r\n\r\n48\r\n00:01:45,070 --> 00:01:47,070\r\nthat are arguing with each other.\r\n\r\n49\r\n00:01:47,070 --> 00:01:50,040\r\nSo most people have one talking voice,\r\n\r\n50\r\n00:01:50,040 --> 00:01:53,040\r\nand this talking voice is your conscious mind.\r\n\r\n51\r\n00:01:53,040 --> 00:01:55,080\r\nAnd the silent listener that\'s also in your head\r\n\r\n52\r\n00:01:55,080 --> 00:01:58,050\r\nis your subconscious, which then acts\r\n\r\n53\r\n00:01:58,050 --> 00:01:59,090\r\non whatever you tell it.\r\n\r\n54\r\n00:01:59,090 --> 00:02:01,060\r\nIt\'s quite a scary thought.\r\n\r\n55\r\n00:02:01,060 --> 00:02:03,070\r\nSo if you say, \"When I give this presentation\r\n\r\n56\r\n00:02:03,070 --> 00:02:05,070\r\n\"it\'s going to go horribly wrong,\"\r\n\r\n57\r\n00:02:05,070 --> 00:02:09,010\r\nyour subconscious listens to that, it acts on that,\r\n\r\n58\r\n00:02:09,010 --> 00:02:12,070\r\nand it then makes the talk go horribly wrong.\r\n\r\n59\r\n00:02:12,070 --> 00:02:14,090\r\nSo if you can change your self talk\r\n\r\n60\r\n00:02:14,090 --> 00:02:17,000\r\nto only positive statements,\r\n\r\n61\r\n00:02:17,000 --> 00:02:19,060\r\nyour subconscious will hear these,\r\n\r\n62\r\n00:02:19,060 --> 00:02:21,090\r\nand gradually it will come to believe you,\r\n\r\n63\r\n00:02:21,090 --> 00:02:25,030\r\nuntil the new state has become true.\r\n\r\n64\r\n00:02:25,030 --> 00:02:27,080\r\nSo if you say, \"I love giving talks.\r\n\r\n65\r\n00:02:27,080 --> 00:02:28,080\r\n\"I\'m looking forward to the big\r\n\r\n66\r\n00:02:28,080 --> 00:02:30,050\r\n\"conference that\'s coming up,\"\r\n\r\n67\r\n00:02:30,050 --> 00:02:32,040\r\nat first it will feel very weird.\r\n\r\n68\r\n00:02:32,040 --> 00:02:34,050\r\nYou\'ll feel something called cognitive dissonance,\r\n\r\n69\r\n00:02:34,050 --> 00:02:37,000\r\nwhich is where you consciously say,\r\n\r\n70\r\n00:02:37,000 --> 00:02:38,020\r\n\"I\'m looking forward to the talk,\"\r\n\r\n71\r\n00:02:38,020 --> 00:02:40,080\r\nand your subconscious says, \"What?\r\n\r\n72\r\n00:02:40,080 --> 00:02:41,090\r\n\"He\'s never said this before.\r\n\r\n73\r\n00:02:41,090 --> 00:02:43,020\r\n\"This can\'t be true.\"\r\n\r\n74\r\n00:02:43,020 --> 00:02:45,030\r\nBut after awhile, you start to accept it.\r\n\r\n75\r\n00:02:45,030 --> 00:02:47,030\r\nYour subconscious starts to think that...\r\n\r\n76\r\n00:02:47,030 --> 00:02:48,090\r\nThat something\'s changed somewhere,\r\n\r\n77\r\n00:02:48,090 --> 00:02:50,040\r\nand maybe you are actually looking forward\r\n\r\n78\r\n00:02:50,040 --> 00:02:51,090\r\nto giving the talk.\r\n\r\n79\r\n00:02:51,090 --> 00:02:55,050\r\nAnd the battleship of 50 years of experience and evidence\r\n\r\n80\r\n00:02:55,050 --> 00:02:57,090\r\nis starting to be slowly turned.\r\n\r\n81\r\n00:02:57,090 --> 00:02:59,050\r\nAnd you just keep pushing and pushing\r\n\r\n82\r\n00:02:59,050 --> 00:03:00,060\r\na little bit every day.\r\n\r\n83\r\n00:03:00,060 --> 00:03:02,060\r\nPositive statements every day.\r\n\r\n84\r\n00:03:02,060 --> 00:03:04,000\r\nAnd you can change anything\r\n\r\n85\r\n00:03:04,000 --> 00:03:06,000\r\nyou want to change about yourself.\r\n\r\n86\r\n00:03:06,000 --> 00:03:08,020\r\nAnd it only takes about a month.\r\n\r\n87\r\n00:03:08,020 --> 00:03:10,020\r\nWhich is amazing, isn\'t it?\r\n\r\n88\r\n00:03:10,020 --> 00:03:12,060\r\nSo, what\'s your pet negative script\r\n\r\n89\r\n00:03:12,060 --> 00:03:14,060\r\nthat you\'d like to change?\r\n\r\n90\r\n00:03:14,060 --> 00:03:16,080\r\nWhat aspect of your personality and behavior\r\n\r\n91\r\n00:03:16,080 --> 00:03:19,040\r\nwould you like to change?\r\n\r\n92\r\n00:03:19,040 --> 00:03:21,020\r\nDesign a new script today\r\n\r\n93\r\n00:03:21,020 --> 00:03:23,040\r\nand start repeating it every day\r\n\r\n94\r\n00:03:23,040 --> 00:03:26,000\r\nuntil it becomes the new you.\r\n\r\n"
                  },
                  new Video
                  {
                    Title = "Reducing your negative emotions",
                    Slug = "reducing-your-negative-emotions",
                    Duration = 315,
                    DownloadUrl = "https://dms.licdn.com/playlist/C4D0DAQF3XfD6wf3SYw/learning-original-video-iphone-360/0/1598507156967?e=1619539200&v=beta&t=ZQyGh6eMzKyllHPa3d345Blys6R8PgS0pjuzHyCz9Ao#.mp4",
                    TranscriptLines = null,
                    Transcript = "1\r\n00:00:00,080 --> 00:00:02,080\r\n- I want to talk to you about negative emotions.\r\n\r\n2\r\n00:00:02,080 --> 00:00:07,000\r\nWould you like to get rid of all of your negative emotions?\r\n\r\n3\r\n00:00:07,000 --> 00:00:11,010\r\nGet rid of worry, fear, anger, hate,\r\n\r\n4\r\n00:00:11,010 --> 00:00:15,080\r\njealousy, regret, blame, impatience,\r\n\r\n5\r\n00:00:15,080 --> 00:00:18,060\r\nembarrassment, guilt.\r\n\r\n6\r\n00:00:18,060 --> 00:00:20,050\r\nYes, of course you would.\r\n\r\n7\r\n00:00:20,050 --> 00:00:22,050\r\nAlthough some people have a couple of\r\n\r\n8\r\n00:00:22,050 --> 00:00:24,040\r\npet negative emotions they want to cling to,\r\n\r\n9\r\n00:00:24,040 --> 00:00:25,060\r\nI\'ll let you keep a couple of your\r\n\r\n10\r\n00:00:25,060 --> 00:00:27,020\r\nfavorite ones if you\'d like.\r\n\r\n11\r\n00:00:27,020 --> 00:00:30,000\r\nAlthough really, why would you?\r\n\r\n12\r\n00:00:30,000 --> 00:00:32,040\r\nTo get rid of any negative emotion,\r\n\r\n13\r\n00:00:32,040 --> 00:00:35,050\r\nthe first step is taking responsibility.\r\n\r\n14\r\n00:00:35,050 --> 00:00:37,050\r\nRealizing that you are responsible for\r\n\r\n15\r\n00:00:37,050 --> 00:00:39,090\r\nmost situations that you find yourself in,\r\n\r\n16\r\n00:00:39,090 --> 00:00:42,010\r\nand you are always responsible for\r\n\r\n17\r\n00:00:42,010 --> 00:00:45,000\r\nhow you handle that situation.\r\n\r\n18\r\n00:00:45,000 --> 00:00:47,040\r\nOften, the things that make us most angry\r\n\r\n19\r\n00:00:47,040 --> 00:00:50,070\r\nare things that we know are our fault, really.\r\n\r\n20\r\n00:00:50,070 --> 00:00:53,020\r\nWe\'ll take another negative emotion, worry.\r\n\r\n21\r\n00:00:53,020 --> 00:00:55,070\r\nOnce we realize that we need to take responsibility\r\n\r\n22\r\n00:00:55,070 --> 00:00:58,040\r\nfor the outcome rather than just worrying about it,\r\n\r\n23\r\n00:00:58,040 --> 00:01:01,040\r\nwe can start to plan and work on getting it right,\r\n\r\n24\r\n00:01:01,040 --> 00:01:04,000\r\nand the worry is reduced.\r\n\r\n25\r\n00:01:04,000 --> 00:01:06,060\r\nI think it\'s amazing that responsibility is involved in\r\n\r\n26\r\n00:01:06,060 --> 00:01:09,050\r\npretty much every negative emotion, when you think about it.\r\n\r\n27\r\n00:01:09,050 --> 00:01:13,090\r\nJealousy, blame, regret, guilt.\r\n\r\n28\r\n00:01:13,090 --> 00:01:14,080\r\nBut the more I think about it,\r\n\r\n29\r\n00:01:14,080 --> 00:01:17,040\r\nthe more convinced I am that this is true.\r\n\r\n30\r\n00:01:17,040 --> 00:01:19,060\r\nI suppose you could say that you\'re responsible\r\n\r\n31\r\n00:01:19,060 --> 00:01:24,000\r\neven for whether you choose that negative emotion at all.\r\n\r\n32\r\n00:01:24,000 --> 00:01:27,090\r\nAre you aware that you are choosing negative emotions?\r\n\r\n33\r\n00:01:27,090 --> 00:01:29,030\r\nIt may feel that they automatically\r\n\r\n34\r\n00:01:29,030 --> 00:01:31,030\r\nspring up from within you.\r\n\r\n35\r\n00:01:31,030 --> 00:01:32,030\r\nBut think about it,\r\n\r\n36\r\n00:01:32,030 --> 00:01:34,080\r\nmaybe you\'re responsible for choosing them.\r\n\r\n37\r\n00:01:34,080 --> 00:01:37,050\r\nDid you choose to get angry?\r\n\r\n38\r\n00:01:37,050 --> 00:01:38,080\r\nOr, to put it another way,\r\n\r\n39\r\n00:01:38,080 --> 00:01:40,090\r\ncould you choose to not get angry?\r\n\r\n40\r\n00:01:40,090 --> 00:01:43,010\r\nI think you could.\r\n\r\n41\r\n00:01:43,010 --> 00:01:45,030\r\nSo, why would someone choose\r\n\r\n42\r\n00:01:45,030 --> 00:01:49,000\r\na negative emotion like anger or guilt?\r\n\r\n43\r\n00:01:49,000 --> 00:01:52,000\r\nWell, we\'re choosing them due to false payoffs.\r\n\r\n44\r\n00:01:52,000 --> 00:01:53,040\r\nWe believe we\'re gonna get a payoff,\r\n\r\n45\r\n00:01:53,040 --> 00:01:56,050\r\nwhich we actually don\'t really get.\r\n\r\n46\r\n00:01:56,050 --> 00:01:57,080\r\nLet\'s look at both anger and guilt\r\n\r\n47\r\n00:01:57,080 --> 00:01:59,090\r\nand look at the false payoffs.\r\n\r\n48\r\n00:01:59,090 --> 00:02:01,000\r\nWhat would be the payoff that you\r\n\r\n49\r\n00:02:01,000 --> 00:02:04,000\r\nmight get from becoming angry?\r\n\r\n50\r\n00:02:04,000 --> 00:02:05,030\r\nWell, I think there are two payoffs\r\n\r\n51\r\n00:02:05,030 --> 00:02:06,010\r\nwe think we\'re gonna get.\r\n\r\n52\r\n00:02:06,010 --> 00:02:08,080\r\nOne is that it will make us stronger.\r\n\r\n53\r\n00:02:08,080 --> 00:02:12,000\r\nBut actually, does it make you stronger if you get angry?\r\n\r\n54\r\n00:02:12,000 --> 00:02:13,000\r\nAre you most likely to get\r\n\r\n55\r\n00:02:13,000 --> 00:02:15,000\r\nwhat you want by getting angry?\r\n\r\n56\r\n00:02:15,000 --> 00:02:17,020\r\nAnd I would say, probably not.\r\n\r\n57\r\n00:02:17,020 --> 00:02:19,010\r\nThe other payoff is a feeling\r\n\r\n58\r\n00:02:19,010 --> 00:02:20,060\r\nthat we might be able to let off steam\r\n\r\n59\r\n00:02:20,060 --> 00:02:22,090\r\nand feel better afterwards.\r\n\r\n60\r\n00:02:22,090 --> 00:02:24,020\r\nBut actually, do you feel better\r\n\r\n61\r\n00:02:24,020 --> 00:02:26,010\r\nafter you\'ve got angry?\r\n\r\n62\r\n00:02:26,010 --> 00:02:27,080\r\nProbably not.\r\n\r\n63\r\n00:02:27,080 --> 00:02:29,050\r\nOnce you realize that actually,\r\n\r\n64\r\n00:02:29,050 --> 00:02:32,010\r\nanger doesn\'t make you stronger,\r\n\r\n65\r\n00:02:32,010 --> 00:02:33,090\r\nand it doesn\'t give you a feeling\r\n\r\n66\r\n00:02:33,090 --> 00:02:35,060\r\nof letting off steam and feeling better afterwards,\r\n\r\n67\r\n00:02:35,060 --> 00:02:38,090\r\nyou can then decide to not choose anger.\r\n\r\n68\r\n00:02:38,090 --> 00:02:41,040\r\nMoving on to guilt, the second one,\r\n\r\n69\r\n00:02:41,040 --> 00:02:42,080\r\nwhat are the payoffs we might think\r\n\r\n70\r\n00:02:42,080 --> 00:02:44,020\r\nthat we\'re gonna get from guilt?\r\n\r\n71\r\n00:02:44,020 --> 00:02:46,000\r\nI think, again, there are two main ones.\r\n\r\n72\r\n00:02:46,000 --> 00:02:47,090\r\nOne is that maybe feeling guilty\r\n\r\n73\r\n00:02:47,090 --> 00:02:50,040\r\nabout something you\'ve done makes you feel\r\n\r\n74\r\n00:02:50,040 --> 00:02:52,010\r\nthat you\'re an okay person, really.\r\n\r\n75\r\n00:02:52,010 --> 00:02:53,080\r\nEven though you did a bad thing,\r\n\r\n76\r\n00:02:53,080 --> 00:02:55,030\r\nat least you\'re a good person.\r\n\r\n77\r\n00:02:55,030 --> 00:02:56,040\r\nBut on the other hand,\r\n\r\n78\r\n00:02:56,040 --> 00:02:59,030\r\ndoes guilt make you an okay person\r\n\r\n79\r\n00:02:59,030 --> 00:03:00,020\r\nafter you\'ve done a bad thing?\r\n\r\n80\r\n00:03:00,020 --> 00:03:01,030\r\nAnd I would say, \"No, it doesn\'t.\"\r\n\r\n81\r\n00:03:01,030 --> 00:03:03,040\r\nYou did the bad thing.\r\n\r\n82\r\n00:03:03,040 --> 00:03:05,090\r\nThe other payoff that you might think you get from guilt,\r\n\r\n83\r\n00:03:05,090 --> 00:03:09,090\r\nis that it makes less likely to do the bad thing again.\r\n\r\n84\r\n00:03:09,090 --> 00:03:12,020\r\nBut again, do you get that payoff?\r\n\r\n85\r\n00:03:12,020 --> 00:03:13,070\r\nAnd I would say, probably not.\r\n\r\n86\r\n00:03:13,070 --> 00:03:15,030\r\nI think guilt almost gives you permission\r\n\r\n87\r\n00:03:15,030 --> 00:03:16,090\r\nto keep doing the bad thing,\r\n\r\n88\r\n00:03:16,090 --> 00:03:19,020\r\nat least you feel guilty every time you do it.\r\n\r\n89\r\n00:03:19,020 --> 00:03:21,020\r\nSo, I think guilt is actually gonna make you\r\n\r\n90\r\n00:03:21,020 --> 00:03:24,060\r\nmore likely to keep doing that bad thing.\r\n\r\n91\r\n00:03:24,060 --> 00:03:27,040\r\nOnce you realize that you\'re choosing these emotions,\r\n\r\n92\r\n00:03:27,040 --> 00:03:29,000\r\nand that the payoffs that you think you\'re\r\n\r\n93\r\n00:03:29,000 --> 00:03:31,050\r\ngonna get are actually false,\r\n\r\n94\r\n00:03:31,050 --> 00:03:36,060\r\nyou can then begin to choose to not have them.\r\n\r\n95\r\n00:03:36,060 --> 00:03:40,010\r\nWhat would a life of no guilt be like?\r\n\r\n96\r\n00:03:40,010 --> 00:03:42,080\r\nWould it possible to get rid of guilt?\r\n\r\n97\r\n00:03:42,080 --> 00:03:44,010\r\nWhen you start thinking about this,\r\n\r\n98\r\n00:03:44,010 --> 00:03:46,040\r\nthere are two main ways that you could\r\n\r\n99\r\n00:03:46,040 --> 00:03:48,020\r\nlive a life free from guilt.\r\n\r\n100\r\n00:03:48,020 --> 00:03:50,020\r\nOne would be, to be a complete angel.\r\n\r\n101\r\n00:03:50,020 --> 00:03:52,020\r\nTo be perfect, never do a bad thing.\r\n\r\n102\r\n00:03:52,020 --> 00:03:54,040\r\nI think that would be impossible,\r\n\r\n103\r\n00:03:54,040 --> 00:03:56,040\r\nAt least it would for me.\r\n\r\n104\r\n00:03:56,040 --> 00:03:58,050\r\nThe other option would be to be a complete devil.\r\n\r\n105\r\n00:03:58,050 --> 00:04:01,040\r\nDo bad things all the time, and not care.\r\n\r\n106\r\n00:04:01,040 --> 00:04:02,020\r\nI think we all agree,\r\n\r\n107\r\n00:04:02,020 --> 00:04:05,040\r\nthat would be an unacceptable option.\r\n\r\n108\r\n00:04:05,040 --> 00:04:08,030\r\nBut of course, what about a mixture of these two things.\r\n\r\n109\r\n00:04:08,030 --> 00:04:10,070\r\nIf you could be a mixture of the angel option\r\n\r\n110\r\n00:04:10,070 --> 00:04:12,000\r\nand the devil option,\r\n\r\n111\r\n00:04:12,000 --> 00:04:15,020\r\nthat would be possible to do, that would work.\r\n\r\n112\r\n00:04:15,020 --> 00:04:17,080\r\nFor example, when my neighbor\'s cat comes\r\n\r\n113\r\n00:04:17,080 --> 00:04:19,090\r\nthrough into my garden, trying to eat my goldfish\r\n\r\n114\r\n00:04:19,090 --> 00:04:21,040\r\nthat I\'ve got in my pond,\r\n\r\n115\r\n00:04:21,040 --> 00:04:24,060\r\nI could squirt the cat with my garden hose.\r\n\r\n116\r\n00:04:24,060 --> 00:04:26,020\r\nBut if I did, I\'d feel bad about that,\r\n\r\n117\r\n00:04:26,020 --> 00:04:27,040\r\nI\'d feel guilty about that.\r\n\r\n118\r\n00:04:27,040 --> 00:04:29,080\r\nSo, I\'m gonna choose the angel option for that,\r\n\r\n119\r\n00:04:29,080 --> 00:04:31,050\r\nand I\'m gonna not do it.\r\n\r\n120\r\n00:04:31,050 --> 00:04:34,000\r\nWhen it comes to eating a second doughnut,\r\n\r\n121\r\n00:04:34,000 --> 00:04:35,060\r\nI think I\'m gonna go for the devil option\r\n\r\n122\r\n00:04:35,060 --> 00:04:37,040\r\nand just do that.\r\n\r\n123\r\n00:04:37,040 --> 00:04:39,040\r\nIf I have a mixture of the angel choice\r\n\r\n124\r\n00:04:39,040 --> 00:04:41,020\r\nand the devil choice in my life,\r\n\r\n125\r\n00:04:41,020 --> 00:04:44,010\r\nI can live a life free from guilt.\r\n\r\n126\r\n00:04:44,010 --> 00:04:45,080\r\nThe answer to get rid of guilt is actually\r\n\r\n127\r\n00:04:45,080 --> 00:04:48,090\r\nto change what you do, which is the angel option.\r\n\r\n128\r\n00:04:48,090 --> 00:04:51,050\r\nOr, change what you say to yourself,\r\n\r\n129\r\n00:04:51,050 --> 00:04:53,050\r\nwhich is the devil option,\r\n\r\n130\r\n00:04:53,050 --> 00:04:55,070\r\nand banish guilt forever.\r\n\r\n131\r\n00:04:55,070 --> 00:04:58,040\r\nIt\'s the same for all other negative emotions.\r\n\r\n132\r\n00:04:58,040 --> 00:05:01,080\r\nI want you to think about, what\'s your pet one?\r\n\r\n133\r\n00:05:01,080 --> 00:05:04,090\r\nWhat\'s the payoff that you think you\'re getting from it?\r\n\r\n134\r\n00:05:04,090 --> 00:05:06,070\r\nAnd is that payoff forced?\r\n\r\n135\r\n00:05:06,070 --> 00:05:09,000\r\nWhich, of course, it is.\r\n\r\n136\r\n00:05:09,000 --> 00:05:11,000\r\nAnd then, decide not to have that\r\n\r\n137\r\n00:05:11,000 --> 00:05:15,000\r\nnegative emotion in your life anymore.\r\n\r\n"
                  }
                }
              },
              new Chapter
              {
                Title = "2. Responding to Challenges",
                Videos = new List<Video>
                {
                  new Video
                  {
                    Title = "Handling everyday put-downs",
                    Slug = "handling-everyday-put-downs",
                    Duration = 140,
                    DownloadUrl = "https://dms.licdn.com/playlist/C4D0DAQEgw6KNEpsl5Q/learning-original-video-iphone-360/0/1598507236138?e=1619539200&v=beta&t=AMOnwVYM5lY8xfWcpI7lKO1WVMIPCBRDL5PisVrgTj8#.mp4",
                    TranscriptLines = null,
                    Transcript = "1\r\n00:00:00,080 --> 00:00:01,070\r\n- Now, I wanted to say a little bit\r\n\r\n2\r\n00:00:01,070 --> 00:00:05,080\r\nabout handling everyday put-downs.\r\n\r\n3\r\n00:00:05,080 --> 00:00:07,010\r\nWhen someone puts you down verbally,\r\n\r\n4\r\n00:00:07,010 --> 00:00:09,010\r\nit\'s really a form of aggression.\r\n\r\n5\r\n00:00:09,010 --> 00:00:10,050\r\nMost aggression these days is actually\r\n\r\n6\r\n00:00:10,050 --> 00:00:12,050\r\nnot physical, it\'s verbal.\r\n\r\n7\r\n00:00:12,050 --> 00:00:13,040\r\nAnd as we\'ve seen,\r\n\r\n8\r\n00:00:13,040 --> 00:00:15,090\r\nthe temptation is to be aggressive back,\r\n\r\n9\r\n00:00:15,090 --> 00:00:18,080\r\nor to be submissive and let them get away with it.\r\n\r\n10\r\n00:00:18,080 --> 00:00:22,020\r\nBut to confront them assertively would be the best option.\r\n\r\n11\r\n00:00:22,020 --> 00:00:26,000\r\nThe one that\'s most likely to give you a successful outcome.\r\n\r\n12\r\n00:00:26,000 --> 00:00:28,000\r\nSome examples of common put-downs at work\r\n\r\n13\r\n00:00:28,000 --> 00:00:29,020\r\nwould be things like,\r\n\r\n14\r\n00:00:29,020 --> 00:00:32,030\r\nstereotyping you, patronizing you,\r\n\r\n15\r\n00:00:32,030 --> 00:00:34,010\r\ninterfering with your work,\r\n\r\n16\r\n00:00:34,010 --> 00:00:36,020\r\nignoring things that you\'ve said,\r\n\r\n17\r\n00:00:36,020 --> 00:00:37,070\r\nimplying that you have a fault\r\n\r\n18\r\n00:00:37,070 --> 00:00:38,090\r\nor are under-performing,\r\n\r\n19\r\n00:00:38,090 --> 00:00:41,090\r\nwithout actually coming out and saying it.\r\n\r\n20\r\n00:00:41,090 --> 00:00:44,000\r\nAnd using emotive words like \"stupid\",\r\n\r\n21\r\n00:00:44,000 --> 00:00:47,000\r\nor \"useless\", or \"that was a crazy decision\".\r\n\r\n22\r\n00:00:47,000 --> 00:00:50,050\r\nThese are all types of everyday put-downs.\r\n\r\n23\r\n00:00:50,050 --> 00:00:52,010\r\nThe approach to take with these types\r\n\r\n24\r\n00:00:52,010 --> 00:00:55,060\r\nof verbal aggression is, number one,\r\n\r\n25\r\n00:00:55,060 --> 00:00:59,000\r\nto realize that it is aggression.\r\n\r\n26\r\n00:00:59,000 --> 00:01:00,080\r\nNumber two, to realize that they may not\r\n\r\n27\r\n00:01:00,080 --> 00:01:03,040\r\nbe a bad person, maybe they don\'t realize\r\n\r\n28\r\n00:01:03,040 --> 00:01:05,020\r\nthat they have an effectively\r\n\r\n29\r\n00:01:05,020 --> 00:01:07,070\r\nanti-social habit, like interrupting.\r\n\r\n30\r\n00:01:07,070 --> 00:01:10,030\r\nOr maybe they\'re having a bad day.\r\n\r\n31\r\n00:01:10,030 --> 00:01:12,000\r\nBut then number three, to decide that you\'re not\r\n\r\n32\r\n00:01:12,000 --> 00:01:13,090\r\ngoing to be submissive and taken.\r\n\r\n33\r\n00:01:13,090 --> 00:01:17,000\r\nBut you\'re also not going to bite back aggressively.\r\n\r\n34\r\n00:01:17,000 --> 00:01:19,080\r\nNumber four, then, is to remain calm,\r\n\r\n35\r\n00:01:19,080 --> 00:01:22,050\r\nand speak calmly to them.\r\n\r\n36\r\n00:01:22,050 --> 00:01:23,090\r\nEven if you decide to tell someone\r\n\r\n37\r\n00:01:23,090 --> 00:01:26,060\r\nthat you\'re very upset by what they\'ve just said,\r\n\r\n38\r\n00:01:26,060 --> 00:01:28,050\r\ndo it calmly.\r\n\r\n39\r\n00:01:28,050 --> 00:01:31,060\r\nNumber five is to tell them how you feel,\r\n\r\n40\r\n00:01:31,060 --> 00:01:35,000\r\nand what you would like them to do differently next time.\r\n\r\n41\r\n00:01:35,000 --> 00:01:36,090\r\nI\'ll cover the exact words for how to do this\r\n\r\n42\r\n00:01:36,090 --> 00:01:39,080\r\nin a later video on this course.\r\n\r\n43\r\n00:01:39,080 --> 00:01:41,030\r\nIt feels good to remain calm,\r\n\r\n44\r\n00:01:41,030 --> 00:01:43,020\r\nand it feels good to be nice.\r\n\r\n45\r\n00:01:43,020 --> 00:01:44,000\r\nDo you find that?\r\n\r\n46\r\n00:01:44,000 --> 00:01:45,070\r\nBeing nice to someone horrible\r\n\r\n47\r\n00:01:45,070 --> 00:01:47,040\r\ngives you a great feeling of control,\r\n\r\n48\r\n00:01:47,040 --> 00:01:50,010\r\nand they usually apologize to you later.\r\n\r\n49\r\n00:01:50,010 --> 00:01:51,070\r\nSo, I\'d like you to ask yourself\r\n\r\n50\r\n00:01:51,070 --> 00:01:53,060\r\nwhat types of put-down you sometimes,\r\n\r\n51\r\n00:01:53,060 --> 00:01:55,080\r\nor often experience at work.\r\n\r\n52\r\n00:01:55,080 --> 00:01:57,090\r\nAnd then plan your answer.\r\n\r\n53\r\n00:01:57,090 --> 00:02:00,020\r\nImagine yourself calmly telling them that,\r\n\r\n54\r\n00:02:00,020 --> 00:02:02,090\r\nfor example, you don\'t like being interrupted,\r\n\r\n55\r\n00:02:02,090 --> 00:02:05,010\r\nand you\'d like to just finish your statement.\r\n\r\n56\r\n00:02:05,010 --> 00:02:06,070\r\nOr maybe, when they say,\r\n\r\n57\r\n00:02:06,070 --> 00:02:08,050\r\n\"That\'s typical of a technician!\"\r\n\r\n58\r\n00:02:08,050 --> 00:02:10,020\r\nThat you\'d like to be given the chance to show\r\n\r\n59\r\n00:02:10,020 --> 00:02:13,030\r\nthat your plan is a good one.\r\n\r\n60\r\n00:02:13,030 --> 00:02:15,080\r\nPlan how you\'re going to tell them how you feel,\r\n\r\n61\r\n00:02:15,080 --> 00:02:18,040\r\nand what you want them to do differently in future,\r\n\r\n62\r\n00:02:18,040 --> 00:02:20,000\r\nwhen they deal with you.\r\n\r\n"
                  },
                  new Video
                  {
                    Title = "Fogging",
                    Slug = "fogging",
                    Duration = 80,
                    DownloadUrl = "https://dms.licdn.com/playlist/C4E0DAQFgGQ36OJeUYA/learning-original-video-iphone-360/0/1598507119389?e=1619539200&v=beta&t=BIKyQCrr8VTIo3or4I0L0kyWDTz2uy5tDfdbb-qnCcs#.mp4",
                    TranscriptLines = null,
                    Transcript = "1\r\n00:00:00,060 --> 00:00:01,070\r\n- Now I want to tell you about a really\r\n\r\n2\r\n00:00:01,070 --> 00:00:04,090\r\nuseful technique called fogging.\r\n\r\n3\r\n00:00:04,090 --> 00:00:08,000\r\nIf you\'re suddenly and fiercely verbally attacked,\r\n\r\n4\r\n00:00:08,000 --> 00:00:10,020\r\nmaybe somebody comes charging into your office going,\r\n\r\n5\r\n00:00:10,020 --> 00:00:11,030\r\n\"I can\'t believe you\'ve done this!\"\r\n\r\n6\r\n00:00:11,030 --> 00:00:13,020\r\nor \"You\'re useless!\" or whatever,\r\n\r\n7\r\n00:00:13,020 --> 00:00:16,000\r\nyou can buy time with fogging,\r\n\r\n8\r\n00:00:16,000 --> 00:00:19,070\r\nand this is a technique where you concede only partially.\r\n\r\n9\r\n00:00:19,070 --> 00:00:21,080\r\nYou might say something like, \"I accept that\r\n\r\n10\r\n00:00:21,080 --> 00:00:23,060\r\n\"I could probably improve in that area,\"\r\n\r\n11\r\n00:00:23,060 --> 00:00:26,040\r\nor, \"Yes, the meeting probably could\'ve been better,\"\r\n\r\n12\r\n00:00:26,040 --> 00:00:30,000\r\nor, \"Well, there\'s always room for improvement, I guess.\"\r\n\r\n13\r\n00:00:30,000 --> 00:00:31,090\r\nThe great thing about fogging is that\r\n\r\n14\r\n00:00:31,090 --> 00:00:34,070\r\nthey no longer have a target to attack.\r\n\r\n15\r\n00:00:34,070 --> 00:00:36,090\r\nYou\'ve accepted that they might be right,\r\n\r\n16\r\n00:00:36,090 --> 00:00:40,020\r\nbut without accepting that you\'re wrong.\r\n\r\n17\r\n00:00:40,020 --> 00:00:42,010\r\nIf you refuse to admit any fault,\r\n\r\n18\r\n00:00:42,010 --> 00:00:44,040\r\nthey will continue to attack you.\r\n\r\n19\r\n00:00:44,040 --> 00:00:46,020\r\nAnd if you concede completely,\r\n\r\n20\r\n00:00:46,020 --> 00:00:49,010\r\nthen they\'ve got away with a potentially unfair accusation.\r\n\r\n21\r\n00:00:49,010 --> 00:00:51,040\r\nBut if you partially concede,\r\n\r\n22\r\n00:00:51,040 --> 00:00:53,080\r\nthen they\'ve got nothing left to attack.\r\n\r\n23\r\n00:00:53,080 --> 00:00:56,030\r\nNow fogging isn\'t a complete solution, but it\'s great\r\n\r\n24\r\n00:00:56,030 --> 00:00:59,050\r\nfor diffusing a sudden attack from somebody, and it gives\r\n\r\n25\r\n00:00:59,050 --> 00:01:03,020\r\nyou a bit of time to prepare your counter-attack.\r\n\r\n26\r\n00:01:03,020 --> 00:01:05,020\r\nCan you think of a recent example of when\r\n\r\n27\r\n00:01:05,020 --> 00:01:09,000\r\nyou\'ve been taken by surprise by a sudden verbal attack\r\n\r\n28\r\n00:01:09,000 --> 00:01:12,010\r\nand what a good fogging phrase would have been?\r\n\r\n29\r\n00:01:12,010 --> 00:01:14,090\r\nHave this one ready for next time.\r\n\r\n30\r\n00:01:14,090 --> 00:01:16,070\r\nFogging\'s the first of a number of techniques\r\n\r\n31\r\n00:01:16,070 --> 00:01:20,000\r\nthat I\'m now going to cover in the next few videos.\r\n\r\n"
                  },
                  new Video
                  {
                    Title = "Viewing the interaction with detachment",
                    Slug = "viewing-the-interaction-with-detachment",
                    Duration = 156,
                    DownloadUrl = "https://dms.licdn.com/playlist/C4E0DAQE9J6G4X7diAA/learning-original-video-iphone-360/0/1598550635197?e=1619539200&v=beta&t=wytnzhMw5YPZB82KbI8n2dX4hDjZx0RA38rby-17gfQ#.mp4",
                    TranscriptLines = null,
                    Transcript = "1\r\n00:00:00,070 --> 00:00:04,030\r\n- A very useful assertiveness technique is detachment.\r\n\r\n2\r\n00:00:04,030 --> 00:00:06,030\r\nBetween the stimulus and the response,\r\n\r\n3\r\n00:00:06,030 --> 00:00:09,020\r\nthere\'s a tiny moment when you can decide\r\n\r\n4\r\n00:00:09,020 --> 00:00:11,050\r\nhow you will react.\r\n\r\n5\r\n00:00:11,050 --> 00:00:13,000\r\nYou\'ve already seen how you can do this\r\n\r\n6\r\n00:00:13,000 --> 00:00:16,030\r\nwith negative emotions and choose not to have them.\r\n\r\n7\r\n00:00:16,030 --> 00:00:19,050\r\nBut you can also take control of what you say and do,\r\n\r\n8\r\n00:00:19,050 --> 00:00:21,060\r\nwhen dealing with someone aggressive.\r\n\r\n9\r\n00:00:21,060 --> 00:00:26,000\r\nFirst, ask yourself if it\'s their problem or yours.\r\n\r\n10\r\n00:00:26,000 --> 00:00:27,020\r\nMaybe what they\'re doing is fine,\r\n\r\n11\r\n00:00:27,020 --> 00:00:29,040\r\nand it\'s you that has the problem with it.\r\n\r\n12\r\n00:00:29,040 --> 00:00:32,010\r\nFor example, people playing music next door.\r\n\r\n13\r\n00:00:32,010 --> 00:00:34,010\r\nMaybe it\'s not that late in the evening,\r\n\r\n14\r\n00:00:34,010 --> 00:00:35,060\r\nand they\'re entitled to some fun.\r\n\r\n15\r\n00:00:35,060 --> 00:00:38,000\r\nDoes it matter that much?\r\n\r\n16\r\n00:00:38,000 --> 00:00:40,010\r\nThe person who\'s irritating you immensely\r\n\r\n17\r\n00:00:40,010 --> 00:00:43,060\r\nin the meeting by checking his messages on his phone.\r\n\r\n18\r\n00:00:43,060 --> 00:00:45,010\r\nIs it affecting you?\r\n\r\n19\r\n00:00:45,010 --> 00:00:46,030\r\nIs it such a big deal?\r\n\r\n20\r\n00:00:46,030 --> 00:00:48,020\r\nIs it a battle worth fighting?\r\n\r\n21\r\n00:00:48,020 --> 00:00:50,060\r\nMaybe the problem\'s in your head.\r\n\r\n22\r\n00:00:50,060 --> 00:00:53,000\r\nThis is the first detachment question.\r\n\r\n23\r\n00:00:53,000 --> 00:00:55,060\r\nIs it worth getting involved?\r\n\r\n24\r\n00:00:55,060 --> 00:00:56,050\r\nOne more example of this,\r\n\r\n25\r\n00:00:56,050 --> 00:00:58,060\r\nmy next-door neighbor used to drop in,\r\n\r\n26\r\n00:00:58,060 --> 00:01:01,040\r\nand he would criticize aspects of my house.\r\n\r\n27\r\n00:01:01,040 --> 00:01:01,090\r\nHe would say,\r\n\r\n28\r\n00:01:01,090 --> 00:01:03,070\r\n\"Oh, I see you\'ve got your new windows, Chris.\r\n\r\n29\r\n00:01:03,070 --> 00:01:04,060\r\n\"What did you go for?\r\n\r\n30\r\n00:01:04,060 --> 00:01:06,090\r\n\"Oh, you went for the plastic ones.\r\n\r\n31\r\n00:01:06,090 --> 00:01:07,090\r\n\"I wouldn\'t have done that,\r\n\r\n32\r\n00:01:07,090 --> 00:01:10,020\r\n\"but still, it\'s up to you.\"\r\n\r\n33\r\n00:01:10,020 --> 00:01:11,090\r\nIt used to be really annoying.\r\n\r\n34\r\n00:01:11,090 --> 00:01:15,000\r\nBut then, his behavior was his problem, not mine.\r\n\r\n35\r\n00:01:15,000 --> 00:01:17,020\r\nSo, maybe it was best just to be detached\r\n\r\n36\r\n00:01:17,020 --> 00:01:20,070\r\nand just quietly laugh at it rather than getting annoyed.\r\n\r\n37\r\n00:01:20,070 --> 00:01:23,010\r\nThe second detachment question is,\r\n\r\n38\r\n00:01:23,010 --> 00:01:25,060\r\n\"What\'s my objective in this situation,\r\n\r\n39\r\n00:01:25,060 --> 00:01:28,050\r\n\"and what\'s the best way to get it?\"\r\n\r\n40\r\n00:01:28,050 --> 00:01:30,060\r\nOnce you know what you want to achieve,\r\n\r\n41\r\n00:01:30,060 --> 00:01:33,020\r\nyou can calmly act without emotion\r\n\r\n42\r\n00:01:33,020 --> 00:01:35,010\r\nin order to get it.\r\n\r\n43\r\n00:01:35,010 --> 00:01:37,000\r\nI play in a band in my spare time,\r\n\r\n44\r\n00:01:37,000 --> 00:01:40,060\r\nand we have a bass player of questionable abilities,\r\n\r\n45\r\n00:01:40,060 --> 00:01:42,030\r\nand the guitarist is always criticizing him\r\n\r\n46\r\n00:01:42,030 --> 00:01:43,030\r\nbehind his back.\r\n\r\n47\r\n00:01:43,030 --> 00:01:45,020\r\n\"Did you hear what he played on that last song?\r\n\r\n48\r\n00:01:45,020 --> 00:01:46,090\r\n\"It was rubbish!\"\r\n\r\n49\r\n00:01:46,090 --> 00:01:48,040\r\nAnd my question is always,\r\n\r\n50\r\n00:01:48,040 --> 00:01:50,060\r\n\"What do you want to do about it?\r\n\r\n51\r\n00:01:50,060 --> 00:01:52,010\r\n\"Do you think we should tell him?\r\n\r\n52\r\n00:01:52,010 --> 00:01:54,010\r\n\"Should we get him to write the chords down?\r\n\r\n53\r\n00:01:54,010 --> 00:01:56,000\r\n\"Would you want to replace him?\"\r\n\r\n54\r\n00:01:56,000 --> 00:01:58,020\r\nThe guitar player never has an answer to this.\r\n\r\n55\r\n00:01:58,020 --> 00:02:00,030\r\nHe would rather waste time complaining\r\n\r\n56\r\n00:02:00,030 --> 00:02:01,060\r\nthan have a clear objective,\r\n\r\n57\r\n00:02:01,060 --> 00:02:04,060\r\nand then calmly put it into practice.\r\n\r\n58\r\n00:02:04,060 --> 00:02:07,020\r\nSo, are you detached enough?\r\n\r\n59\r\n00:02:07,020 --> 00:02:10,020\r\nDo you take on things that are not worth the effort,\r\n\r\n60\r\n00:02:10,020 --> 00:02:12,030\r\nor are never going to succeed?\r\n\r\n61\r\n00:02:12,030 --> 00:02:15,050\r\nWhat can you detach from and just let it go?\r\n\r\n62\r\n00:02:15,050 --> 00:02:18,070\r\nIn the situations that you are determined to change,\r\n\r\n63\r\n00:02:18,070 --> 00:02:20,030\r\ndo you have clear objectives\r\n\r\n64\r\n00:02:20,030 --> 00:02:23,000\r\nthat are feasible for you to achieve?\r\n\r\n65\r\n00:02:23,000 --> 00:02:25,070\r\nAre there situations about which you are unhappy,\r\n\r\n66\r\n00:02:25,070 --> 00:02:27,090\r\nbut where you don\'t yet have a plan\r\n\r\n67\r\n00:02:27,090 --> 00:02:31,020\r\nfor what you are going to do?\r\n\r\n68\r\n00:02:31,020 --> 00:02:34,000\r\nTake a moment from this course to think\r\n\r\n69\r\n00:02:34,000 --> 00:02:36,000\r\nabout these important questions.\r\n\r\n"
                  },
                  new Video
                  {
                    Title = "Learning to disagree by questioning",
                    Slug = "learning-to-disagree-by-questioning",
                    Duration = 273,
                    DownloadUrl = "https://dms.licdn.com/playlist/C4D0DAQHUOQ1aw83mFg/learning-original-video-iphone-360/0/1598507256091?e=1619539200&v=beta&t=tOKyVqwviPvAFP2qZJoHA2vq2Yd9w9dI1bKPigoqdbY#.mp4",
                    TranscriptLines = null,
                    Transcript = "1\r\n00:00:00,070 --> 00:00:02,020\r\n- The next technique I want to share with you\r\n\r\n2\r\n00:00:02,020 --> 00:00:05,010\r\nis called \"Question to Clarify\".\r\n\r\n3\r\n00:00:05,010 --> 00:00:08,060\r\nBecause, after all, the other person might be right.\r\n\r\n4\r\n00:00:08,060 --> 00:00:09,060\r\nIf somebody says,\r\n\r\n5\r\n00:00:09,060 --> 00:00:11,050\r\n\"The report you\'ve written is rubbish!\"\r\n\r\n6\r\n00:00:11,050 --> 00:00:14,070\r\nAsk them, \"What don\'t you like about it?\"\r\n\r\n7\r\n00:00:14,070 --> 00:00:18,000\r\nWe tend to avoid situations where we might get criticized,\r\n\r\n8\r\n00:00:18,000 --> 00:00:21,030\r\nbut either they\'re right and you can learn something,\r\n\r\n9\r\n00:00:21,030 --> 00:00:22,030\r\nor they\'re wrong,\r\n\r\n10\r\n00:00:22,030 --> 00:00:23,090\r\nin which case you can decide whether\r\n\r\n11\r\n00:00:23,090 --> 00:00:25,090\r\nit\'s worth arguing your case,\r\n\r\n12\r\n00:00:25,090 --> 00:00:28,090\r\nor just fogging and letting it go with something like,\r\n\r\n13\r\n00:00:28,090 --> 00:00:31,070\r\n\"Okay, yes, it probably could have been better.\"\r\n\r\n14\r\n00:00:31,070 --> 00:00:33,080\r\nSometimes it\'s not worth the fight.\r\n\r\n15\r\n00:00:33,080 --> 00:00:35,040\r\nThere\'s a great technique for finding out\r\n\r\n16\r\n00:00:35,040 --> 00:00:37,080\r\nwhat someone\'s problem really is,\r\n\r\n17\r\n00:00:37,080 --> 00:00:39,060\r\ncalled \"peeling the onion.\"\r\n\r\n18\r\n00:00:39,060 --> 00:00:41,000\r\nAnd this is where you say,\r\n\r\n19\r\n00:00:41,000 --> 00:00:43,000\r\n\"Apart from that ...\"\r\n\r\n20\r\n00:00:43,000 --> 00:00:43,060\r\nSo you could say,\r\n\r\n21\r\n00:00:43,060 --> 00:00:45,040\r\n\"Apart from the page numbering error,\r\n\r\n22\r\n00:00:45,040 --> 00:00:47,010\r\n\"what did you think of it?\"\r\n\r\n23\r\n00:00:47,010 --> 00:00:47,050\r\nAnd they may say,\r\n\r\n24\r\n00:00:47,050 --> 00:00:50,000\r\n\"Well, the report was fine apart from that.\"\r\n\r\n25\r\n00:00:50,000 --> 00:00:52,060\r\nBut if they give another thing about it they don\'t like,\r\n\r\n26\r\n00:00:52,060 --> 00:00:54,010\r\nthen it means that the first one\r\n\r\n27\r\n00:00:54,010 --> 00:00:56,020\r\nwasn\'t the real reason.\r\n\r\n28\r\n00:00:56,020 --> 00:00:57,050\r\nJust keep going and say,\r\n\r\n29\r\n00:00:57,050 --> 00:01:00,050\r\n\"Apart from those things, was the report okay?\"\r\n\r\n30\r\n00:01:00,050 --> 00:01:01,020\r\nAnd when they finally say,\r\n\r\n31\r\n00:01:01,020 --> 00:01:02,070\r\n\"No, no, that\'s it.\"\r\n\r\n32\r\n00:01:02,070 --> 00:01:06,040\r\nThen you know you\'ve got the real reasons out.\r\n\r\n33\r\n00:01:06,040 --> 00:01:08,080\r\nQuite often, the last reason is the one\r\n\r\n34\r\n00:01:08,080 --> 00:01:11,030\r\nthat you really need to deal with.\r\n\r\n35\r\n00:01:11,030 --> 00:01:15,080\r\nWhy don\'t they come up with the first reason, first time?\r\n\r\n36\r\n00:01:15,080 --> 00:01:17,010\r\nThe reason for that is that people often\r\n\r\n37\r\n00:01:17,010 --> 00:01:19,010\r\nhave a fear that if they come out with\r\n\r\n38\r\n00:01:19,010 --> 00:01:21,030\r\na real objection straight away,\r\n\r\n39\r\n00:01:21,030 --> 00:01:24,080\r\nthat you might be able to handle that in some way.\r\n\r\n40\r\n00:01:24,080 --> 00:01:27,000\r\nThis particularly applies when you get a \"No.\"\r\n\r\n41\r\n00:01:27,000 --> 00:01:28,060\r\nYou should always consider peeling the onion\r\n\r\n42\r\n00:01:28,060 --> 00:01:29,090\r\nwhen you get a \"no\".\r\n\r\n43\r\n00:01:29,090 --> 00:01:31,050\r\nI\'ll tell you what I mean about this.\r\n\r\n44\r\n00:01:31,050 --> 00:01:32,020\r\nSuppose you said to somebody,\r\n\r\n45\r\n00:01:32,020 --> 00:01:34,060\r\n\"I\'d like you to use this new computer system.\"\r\n\r\n46\r\n00:01:34,060 --> 00:01:36,050\r\nAnd he says, \"Oh, I don\'t like using it.\"\r\n\r\n47\r\n00:01:36,050 --> 00:01:38,040\r\nAsk them why, and suppose they say,\r\n\r\n48\r\n00:01:38,040 --> 00:01:41,000\r\n\"Well, the screen gives me a headache.\"\r\n\r\n49\r\n00:01:41,000 --> 00:01:42,070\r\nRather than dealing with that, say,\r\n\r\n50\r\n00:01:42,070 --> 00:01:44,070\r\n\"Apart from that, is there any other reason\r\n\r\n51\r\n00:01:44,070 --> 00:01:47,070\r\n\"why you find the system bad to use?\"\r\n\r\n52\r\n00:01:47,070 --> 00:01:48,020\r\nSuppose they say,\r\n\r\n53\r\n00:01:48,020 --> 00:01:51,070\r\n\"Well yeah. Also, I find the menus confusing.\"\r\n\r\n54\r\n00:01:51,070 --> 00:01:52,090\r\nYou could then say,\r\n\r\n55\r\n00:01:52,090 --> 00:01:54,040\r\n\"Anything else apart from that?\"\r\n\r\n56\r\n00:01:54,040 --> 00:01:56,040\r\nIf they say, \"No, that\'s it, really.\"\r\n\r\n57\r\n00:01:56,040 --> 00:01:58,090\r\nYou now know that the menus are the real reason,\r\n\r\n58\r\n00:01:58,090 --> 00:02:01,010\r\nnot the screen.\r\n\r\n59\r\n00:02:01,010 --> 00:02:03,080\r\nOften, they won\'t come out with the real reason first,\r\n\r\n60\r\n00:02:03,080 --> 00:02:08,030\r\nso you have to peel the onion to find the real problem.\r\n\r\n61\r\n00:02:08,030 --> 00:02:10,050\r\nOnce you\'ve found the real reason,\r\n\r\n62\r\n00:02:10,050 --> 00:02:12,020\r\nyou can then move on to three more types\r\n\r\n63\r\n00:02:12,020 --> 00:02:14,070\r\nof questioning, if you choose to.\r\n\r\n64\r\n00:02:14,070 --> 00:02:18,010\r\nThe first one is \"Questioning to undermine.\"\r\n\r\n65\r\n00:02:18,010 --> 00:02:20,020\r\nThis works really well on me, actually.\r\n\r\n66\r\n00:02:20,020 --> 00:02:22,050\r\nIf someone tells me I\'m wrong, I don\'t believe them.\r\n\r\n67\r\n00:02:22,050 --> 00:02:25,020\r\nBut if they ask me how I know I\'m right,\r\n\r\n68\r\n00:02:25,020 --> 00:02:27,060\r\nthen I get a bit stuck for words.\r\n\r\n69\r\n00:02:27,060 --> 00:02:31,080\r\nSo, questioning to undermine is subtle, but very powerful.\r\n\r\n70\r\n00:02:31,080 --> 00:02:32,090\r\nThe second type of questioning is,\r\n\r\n71\r\n00:02:32,090 --> 00:02:35,010\r\n\"Questioning to persuade.\"\r\n\r\n72\r\n00:02:35,010 --> 00:02:36,050\r\nSuppose you wanted to, I don\'t know,\r\n\r\n73\r\n00:02:36,050 --> 00:02:38,050\r\npersuade somebody to give up smoking.\r\n\r\n74\r\n00:02:38,050 --> 00:02:39,020\r\nIf you just say,\r\n\r\n75\r\n00:02:39,020 --> 00:02:40,090\r\n\"You should give up smoking.\"\r\n\r\n76\r\n00:02:40,090 --> 00:02:42,050\r\nThat\'s not gonna work, they\'re just going to say,\r\n\r\n77\r\n00:02:42,050 --> 00:02:45,000\r\n\"No, no. I\'m addicted, I don\'t want to.\"\r\n\r\n78\r\n00:02:45,000 --> 00:02:46,020\r\nIt\'s much better to ask them,\r\n\r\n79\r\n00:02:46,020 --> 00:02:49,010\r\n\"Have you ever thought of giving up?\r\n\r\n80\r\n00:02:49,010 --> 00:02:51,060\r\n\"And, when you did think about giving up,\r\n\r\n81\r\n00:02:51,060 --> 00:02:53,060\r\n\"What was your motivation?\"\r\n\r\n82\r\n00:02:53,060 --> 00:02:54,010\r\nSuppose they say,\r\n\r\n83\r\n00:02:54,010 --> 00:02:57,040\r\n\"Well, I\'d like to be better at playing football.\"\r\n\r\n84\r\n00:02:57,040 --> 00:02:58,030\r\nYou could then say,\r\n\r\n85\r\n00:02:58,030 --> 00:03:00,020\r\n\"Well, why is playing football important?\"\r\n\r\n86\r\n00:03:00,020 --> 00:03:00,070\r\nAnd they might say,\r\n\r\n87\r\n00:03:00,070 --> 00:03:02,060\r\n\"Well, I want to play with my grandchildren.\"\r\n\r\n88\r\n00:03:02,060 --> 00:03:04,040\r\nAnd you can ask them about that.\r\n\r\n89\r\n00:03:04,040 --> 00:03:06,010\r\nAnd you can really start to drill into\r\n\r\n90\r\n00:03:06,010 --> 00:03:07,070\r\nwhat their motivation really is,\r\n\r\n91\r\n00:03:07,070 --> 00:03:09,020\r\nand this is useful information when it comes\r\n\r\n92\r\n00:03:09,020 --> 00:03:11,040\r\nto persuading them to give up.\r\n\r\n93\r\n00:03:11,040 --> 00:03:12,010\r\nThen you can ask them,\r\n\r\n94\r\n00:03:12,010 --> 00:03:15,000\r\n\"What\'s the barrier to giving up? Why don\'t you give up?\r\n\r\n95\r\n00:03:15,000 --> 00:03:17,090\r\n\"And what would it take to overcome that barrier?\"\r\n\r\n96\r\n00:03:17,090 --> 00:03:19,050\r\nThese questions are giving you all sorts\r\n\r\n97\r\n00:03:19,050 --> 00:03:21,010\r\nof really important information about\r\n\r\n98\r\n00:03:21,010 --> 00:03:23,050\r\nwhat\'s going on in their head.\r\n\r\n99\r\n00:03:23,050 --> 00:03:27,010\r\nRemember that everything that they say is true to them.\r\n\r\n100\r\n00:03:27,010 --> 00:03:29,050\r\nIf you say, \"You should give up.\"\r\n\r\n101\r\n00:03:29,050 --> 00:03:30,070\r\nThat\'s probably not true.\r\n\r\n102\r\n00:03:30,070 --> 00:03:33,040\r\nBut if they say, \"I need to give up.\"\r\n\r\n103\r\n00:03:33,040 --> 00:03:36,030\r\nThen that is true to them.\r\n\r\n104\r\n00:03:36,030 --> 00:03:39,070\r\nThe third type of questioning is \"questioning to disagree.\"\r\n\r\n105\r\n00:03:39,070 --> 00:03:41,090\r\nSuppose you wanted to convince somebody\r\n\r\n106\r\n00:03:41,090 --> 00:03:45,000\r\nthat diesel cars are great.\r\n\r\n107\r\n00:03:45,000 --> 00:03:45,060\r\nYou could say to them,\r\n\r\n108\r\n00:03:45,060 --> 00:03:47,070\r\n\"Do you know the facts on acceleration\r\n\r\n109\r\n00:03:47,070 --> 00:03:51,020\r\n\"of diesel cars, and economy of diesel cars.\"\r\n\r\n110\r\n00:03:51,020 --> 00:03:52,000\r\nAnd you can say to them,\r\n\r\n111\r\n00:03:52,000 --> 00:03:54,040\r\n\"If there was proof that diesel cars were really good,\r\n\r\n112\r\n00:03:54,040 --> 00:03:56,040\r\n\"would you be prepared to have a look at it?\"\r\n\r\n113\r\n00:03:56,040 --> 00:03:57,050\r\nOr, we could even say,\r\n\r\n114\r\n00:03:57,050 --> 00:03:59,040\r\n\"Presumably, you\'d be open-minded enough\r\n\r\n115\r\n00:03:59,040 --> 00:04:02,000\r\n\"to try driving one.\"\r\n\r\n116\r\n00:04:02,000 --> 00:04:05,010\r\nThose are questions to disagree.\r\n\r\n117\r\n00:04:05,010 --> 00:04:09,010\r\nI\'d like you to think, has there been a recent situation\r\n\r\n118\r\n00:04:09,010 --> 00:04:10,080\r\nwhere you came up against a brick wall,\r\n\r\n119\r\n00:04:10,080 --> 00:04:12,030\r\nand could maybe have got past it\r\n\r\n120\r\n00:04:12,030 --> 00:04:15,060\r\nby using questioning rather than statements.\r\n\r\n121\r\n00:04:15,060 --> 00:04:18,000\r\nCan you think of times when peeling the onion\r\n\r\n122\r\n00:04:18,000 --> 00:04:19,090\r\nwill be a way to find out more about\r\n\r\n123\r\n00:04:19,090 --> 00:04:23,000\r\nwhat\'s really on someone\'s mind.\r\n\r\n124\r\n00:04:23,000 --> 00:04:24,030\r\nCan you think about people who might\r\n\r\n125\r\n00:04:24,030 --> 00:04:26,080\r\nrespond well to questioning?\r\n\r\n126\r\n00:04:26,080 --> 00:04:28,090\r\nEither questioning to undermine,\r\n\r\n127\r\n00:04:28,090 --> 00:04:33,000\r\nquestioning to persuade, or questioning to disagree.\r\n\r\n"
                  },
                  new Video
                  {
                    Title = "Highlighting their unspoken signals (body language)",
                    Slug = "highlighting-their-unspoken-signals-body-language",
                    Duration = 120,
                    DownloadUrl = "https://dms.licdn.com/playlist/C4D0DAQFiMeLDG3-n7g/learning-original-video-iphone-360/0/1598507141465?e=1619539200&v=beta&t=mVNNGKvoaUE_IkWnleZZ3dKbkTVfd3lY3xcFqSYIXYs#.mp4",
                    TranscriptLines = null,
                    Transcript = "1\r\n00:00:00,090 --> 00:00:02,030\r\n- A great little technique for handling\r\n\r\n2\r\n00:00:02,030 --> 00:00:04,040\r\naggressive body language is\r\n\r\n3\r\n00:00:04,040 --> 00:00:08,030\r\nI notice, I interpret, am I right?\r\n\r\n4\r\n00:00:08,030 --> 00:00:09,090\r\nNow the key here is we\'re only talking about\r\n\r\n5\r\n00:00:09,090 --> 00:00:11,060\r\naggressive body language.\r\n\r\n6\r\n00:00:11,060 --> 00:00:14,010\r\nThese people are probably not saying anything particularly.\r\n\r\n7\r\n00:00:14,010 --> 00:00:15,080\r\nThere\'s just something in their body language\r\n\r\n8\r\n00:00:15,080 --> 00:00:17,080\r\nthat showing that they\'re not happy with you.\r\n\r\n9\r\n00:00:17,080 --> 00:00:19,020\r\nAnd we want to pick them up on this\r\n\r\n10\r\n00:00:19,020 --> 00:00:21,010\r\nand find out what the problem is,\r\n\r\n11\r\n00:00:21,010 --> 00:00:23,070\r\nbut in a non-aggressive way.\r\n\r\n12\r\n00:00:23,070 --> 00:00:26,030\r\nSo we\'re clarifying.\r\n\r\n13\r\n00:00:26,030 --> 00:00:27,090\r\nAn example this might be in a meeting\r\n\r\n14\r\n00:00:27,090 --> 00:00:31,030\r\nmaybe when you mention the production department,\r\n\r\n15\r\n00:00:31,030 --> 00:00:33,090\r\nsomebody else in the meeting rolls their eyes\r\n\r\n16\r\n00:00:33,090 --> 00:00:36,040\r\nor keeps looking at their colleague\r\n\r\n17\r\n00:00:36,040 --> 00:00:39,030\r\nand you feel that\'s unacceptable and you want to\r\n\r\n18\r\n00:00:39,030 --> 00:00:40,040\r\npick them up on it.\r\n\r\n19\r\n00:00:40,040 --> 00:00:43,010\r\nSo you can calmly say, \"Dave, I notice that every time\r\n\r\n20\r\n00:00:43,010 --> 00:00:45,090\r\n\'I mention the production department, you go...\r\n\r\n21\r\n00:00:45,090 --> 00:00:47,050\r\n\'and I interpret that to mean\r\n\r\n22\r\n00:00:47,050 --> 00:00:51,070\r\n\'that you\'re not with us in some way. Am I right?\"\r\n\r\n23\r\n00:00:51,070 --> 00:00:53,060\r\nNow this could be done during the meeting\r\n\r\n24\r\n00:00:53,060 --> 00:00:55,060\r\nor it could be done one-to-one afterwards.\r\n\r\n25\r\n00:00:55,060 --> 00:00:56,040\r\nYou can pick them up and say,\r\n\r\n26\r\n00:00:56,040 --> 00:00:58,050\r\n\"During the meeting I just had a feeling each time\r\n\r\n27\r\n00:00:58,050 --> 00:00:59,090\r\n\'I said this, I noticed this\r\n\r\n28\r\n00:00:59,090 --> 00:01:03,090\r\n\'and I just interpret it as this; am I right?\"\r\n\r\n29\r\n00:01:03,090 --> 00:01:05,000\r\nIt\'s non-aggressive.\r\n\r\n30\r\n00:01:05,000 --> 00:01:08,010\r\nIt\'s just clarifying.\r\n\r\n31\r\n00:01:08,010 --> 00:01:10,060\r\nWhat are they going to do when you say this?\r\n\r\n32\r\n00:01:10,060 --> 00:01:12,050\r\nWell, they\'ve really only got two options.\r\n\r\n33\r\n00:01:12,050 --> 00:01:13,060\r\nThey can either say, \"No sorry,\r\n\r\n34\r\n00:01:13,060 --> 00:01:15,030\r\n\'I didn\'t mean anything by it.\"\r\n\r\n35\r\n00:01:15,030 --> 00:01:18,000\r\nSome people just have unfortunate body language.\r\n\r\n36\r\n00:01:18,000 --> 00:01:21,010\r\nBut the other thing is, they may say, \"Well yeah, actually\r\n\r\n37\r\n00:01:21,010 --> 00:01:23,020\r\n\'I do think that the production department are not\r\n\r\n38\r\n00:01:23,020 --> 00:01:25,050\r\n\'doing their job properly; been late on the last three jobs\"\r\n\r\n39\r\n00:01:25,050 --> 00:01:28,050\r\nor whatever, \"And this is what I want\".\r\n\r\n40\r\n00:01:28,050 --> 00:01:30,080\r\nSo we can have a decent conversation about what\r\n\r\n41\r\n00:01:30,080 --> 00:01:31,060\r\nthe problem is.\r\n\r\n42\r\n00:01:31,060 --> 00:01:33,020\r\nWe flushed it out.\r\n\r\n43\r\n00:01:33,020 --> 00:01:34,050\r\nSo what we\'re doing here is we\'re clarifying\r\n\r\n44\r\n00:01:34,050 --> 00:01:36,060\r\nwith this little technique.\r\n\r\n45\r\n00:01:36,060 --> 00:01:39,000\r\nSo have you had any recent examples\r\n\r\n46\r\n00:01:39,000 --> 00:01:40,090\r\nwhen you could have used this?\r\n\r\n47\r\n00:01:40,090 --> 00:01:43,040\r\nWere there some situations that came up in meetings\r\n\r\n48\r\n00:01:43,040 --> 00:01:45,010\r\nor just to one-to-one perhaps\r\n\r\n49\r\n00:01:45,010 --> 00:01:46,060\r\nwhere the person\'s body language\r\n\r\n50\r\n00:01:46,060 --> 00:01:48,040\r\nwas a little bit aggressive?\r\n\r\n51\r\n00:01:48,040 --> 00:01:52,020\r\nOr, are there any people who tend to use subtly aggressive\r\n\r\n52\r\n00:01:52,020 --> 00:01:55,040\r\nbody language that you can try this out on?\r\n\r\n53\r\n00:01:55,040 --> 00:01:57,020\r\nI\'d like you just to think about that.\r\n\r\n54\r\n00:01:57,020 --> 00:02:00,000\r\nHow could you apply this technique?\r\n\r\n"
                  },
                  new Video
                  {
                    Title = "Commenting on the process",
                    Slug = "commenting-on-the-process",
                    Duration = 130,
                    DownloadUrl = "https://dms.licdn.com/playlist/C4D0DAQGuGNrc3md9eg/learning-original-video-iphone-360/0/1598507237244?e=1619539200&v=beta&t=O8WYxAoP_gCXgPqpMfWC4AFhEJfnb4u3mdoz-Xd_aw8#.mp4",
                    TranscriptLines = null,
                    Transcript = "1\r\n00:00:01,000 --> 00:00:02,050\r\n- Now I\'d like to say a bit about commenting\r\n\r\n2\r\n00:00:02,050 --> 00:00:05,070\r\non the process between you and the other person.\r\n\r\n3\r\n00:00:05,070 --> 00:00:07,040\r\nMaybe the words that they\'re using\r\n\r\n4\r\n00:00:07,040 --> 00:00:10,000\r\nor the emotions that they\'re having.\r\n\r\n5\r\n00:00:10,000 --> 00:00:13,020\r\nSo in terms of the words, if they describe a decision\r\n\r\n6\r\n00:00:13,020 --> 00:00:15,030\r\nas stupid or crazy\r\n\r\n7\r\n00:00:15,030 --> 00:00:17,000\r\nyou could pick them up on those words and say,\r\n\r\n8\r\n00:00:17,000 --> 00:00:20,000\r\n\"Well I agree that the decision in retrospect\r\n\r\n9\r\n00:00:20,000 --> 00:00:22,040\r\n\"could have been better but I think it\'s a bit harsh\r\n\r\n10\r\n00:00:22,040 --> 00:00:25,020\r\n\"to call it crazy.\"\r\n\r\n11\r\n00:00:25,020 --> 00:00:27,010\r\nAnd then if necessary you could point out\r\n\r\n12\r\n00:00:27,010 --> 00:00:30,090\r\ntheir behavior and emotional state as well.\r\n\r\n13\r\n00:00:30,090 --> 00:00:32,090\r\nFor example if somebody\'s shouting at you\r\n\r\n14\r\n00:00:32,090 --> 00:00:34,050\r\nyou can say to them,\r\n\r\n15\r\n00:00:34,050 --> 00:00:36,020\r\n\"You\'re shouting at me and disturbing everyone\r\n\r\n16\r\n00:00:36,020 --> 00:00:37,060\r\n\"else in the office.\r\n\r\n17\r\n00:00:37,060 --> 00:00:40,040\r\n\"Is this the best way to resolve this problem?\r\n\r\n18\r\n00:00:40,040 --> 00:00:41,070\r\n\"Maybe we could meet later when\r\n\r\n19\r\n00:00:41,070 --> 00:00:43,050\r\n\"you\'re in a calmer mood.\"\r\n\r\n20\r\n00:00:43,050 --> 00:00:47,000\r\nSo you calmly point out their behavior and their emotions\r\n\r\n21\r\n00:00:47,000 --> 00:00:49,000\r\nand this works because often people aren\'t\r\n\r\n22\r\n00:00:49,000 --> 00:00:50,060\r\nconscious of their behavior.\r\n\r\n23\r\n00:00:50,060 --> 00:00:52,090\r\nThey\'ve slipped into autopilot.\r\n\r\n24\r\n00:00:52,090 --> 00:00:54,020\r\nAnd the hope is that they\'ll say,\r\n\r\n25\r\n00:00:54,020 --> 00:00:56,010\r\n\"Oh yeah, sorry about that.\"\r\n\r\n26\r\n00:00:56,010 --> 00:00:57,020\r\nIf they say,\r\n\r\n27\r\n00:00:57,020 --> 00:00:59,010\r\n\"I\'ll damn well shout if I want to!\r\n\r\n28\r\n00:00:59,010 --> 00:01:00,050\r\n\"I\'m really annoyed!\"\r\n\r\n29\r\n00:01:00,050 --> 00:01:03,030\r\nthen you now know what you\'re dealing with\r\n\r\n30\r\n00:01:03,030 --> 00:01:04,070\r\nand you\'re fully justified in saying\r\n\r\n31\r\n00:01:04,070 --> 00:01:06,050\r\n\"Well I\'m not going to try to resolve this\r\n\r\n32\r\n00:01:06,050 --> 00:01:10,040\r\n\"when you\'re in that state, we\'ll talk in half an hour.\"\r\n\r\n33\r\n00:01:10,040 --> 00:01:12,000\r\nPointing out their behavior can also be used\r\n\r\n34\r\n00:01:12,000 --> 00:01:14,090\r\nto show that you\'re on to their game.\r\n\r\n35\r\n00:01:14,090 --> 00:01:17,020\r\nFor example a perennial problem I get\r\n\r\n36\r\n00:01:17,020 --> 00:01:18,070\r\nis trying to get a gig in a pub\r\n\r\n37\r\n00:01:18,070 --> 00:01:21,000\r\nand trying to get a meeting with the landlord\r\n\r\n38\r\n00:01:21,000 --> 00:01:22,010\r\nand there\'s always somebody saying,\r\n\r\n39\r\n00:01:22,010 --> 00:01:24,000\r\n\"Oh he\'s not here I\'m afraid.\"\r\n\r\n40\r\n00:01:24,000 --> 00:01:26,040\r\nI suspect he probably is there upstairs\r\n\r\n41\r\n00:01:26,040 --> 00:01:28,020\r\nand just isn\'t talking to visitors.\r\n\r\n42\r\n00:01:28,020 --> 00:01:30,010\r\nSo the thing is to comment on the process\r\n\r\n43\r\n00:01:30,010 --> 00:01:31,000\r\nand say to them,\r\n\r\n44\r\n00:01:31,000 --> 00:01:33,040\r\n\"Well I\'ve been in several times now\r\n\r\n45\r\n00:01:33,040 --> 00:01:36,050\r\n\"and these random visits just aren\'t working\r\n\r\n46\r\n00:01:36,050 --> 00:01:38,070\r\n\"so can you help me and maybe suggest\r\n\r\n47\r\n00:01:38,070 --> 00:01:41,080\r\n\"a better way to contact him?\"\r\n\r\n48\r\n00:01:41,080 --> 00:01:44,030\r\nSo by highlighting the process you\'re saying\r\n\r\n49\r\n00:01:44,030 --> 00:01:46,040\r\n\"I\'m on to your game, it can\'t go on,\r\n\r\n50\r\n00:01:46,040 --> 00:01:47,060\r\n\"we need to find another way.\"\r\n\r\n51\r\n00:01:47,060 --> 00:01:50,090\r\nAsking them for help is quite powerful too.\r\n\r\n52\r\n00:01:50,090 --> 00:01:53,060\r\nSo maybe there are people in your work\r\n\r\n53\r\n00:01:53,060 --> 00:01:55,050\r\nor your personal life who would benefit\r\n\r\n54\r\n00:01:55,050 --> 00:01:58,040\r\nfrom having their aggressive words pointed out\r\n\r\n55\r\n00:01:58,040 --> 00:02:02,060\r\nor their unhelpful behaviors calmly highlighted.\r\n\r\n56\r\n00:02:02,060 --> 00:02:04,050\r\nCan you think of some recent situations\r\n\r\n57\r\n00:02:04,050 --> 00:02:06,060\r\nwhere you could\'ve done this?\r\n\r\n58\r\n00:02:06,060 --> 00:02:08,040\r\nSo that you can be ready for them\r\n\r\n59\r\n00:02:08,040 --> 00:02:10,000\r\nwhen it next happens.\r\n\r\n"
                  },
                  new Video
                  {
                    Title = "Escalating from the one-off to the habit",
                    Slug = "escalating-from-the-one-off-to-the-habit",
                    Duration = 163,
                    DownloadUrl = "https://dms.licdn.com/playlist/C560DAQFPKHEWGpvwTA/learning-original-video-iphone-360/0/1598507052119?e=1619539200&v=beta&t=g5IPqDtDLHZccOt01k-hwanLIcEN6xpJwtZul0yNKqg#.mp4",
                    TranscriptLines = null,
                    Transcript = "1\r\n00:00:00,060 --> 00:00:02,090\r\n- Now, with any assertiveness situation,\r\n\r\n2\r\n00:00:02,090 --> 00:00:06,030\r\nyou\'ve always got two levels you can choose between.\r\n\r\n3\r\n00:00:06,030 --> 00:00:08,010\r\nThere\'s confronting the one-off,\r\n\r\n4\r\n00:00:08,010 --> 00:00:09,060\r\nand then, if that doesn\'t work after\r\n\r\n5\r\n00:00:09,060 --> 00:00:11,030\r\nyou\'ve done it several times,\r\n\r\n6\r\n00:00:11,030 --> 00:00:12,090\r\nyou can confront them with their habit.\r\n\r\n7\r\n00:00:12,090 --> 00:00:16,010\r\nYou can go from the one-off to the habit.\r\n\r\n8\r\n00:00:16,010 --> 00:00:16,060\r\nAn example of this,\r\n\r\n9\r\n00:00:16,060 --> 00:00:19,070\r\nmy son has a friend who likes to crash on the sofa\r\n\r\n10\r\n00:00:19,070 --> 00:00:22,060\r\nin my son\'s room when they get in from a night out.\r\n\r\n11\r\n00:00:22,060 --> 00:00:25,070\r\nAnd this friend doesn\'t ask, he just comes in,\r\n\r\n12\r\n00:00:25,070 --> 00:00:27,070\r\nand this is starting to irritate my son,\r\n\r\n13\r\n00:00:27,070 --> 00:00:29,040\r\nso what should he do?\r\n\r\n14\r\n00:00:29,040 --> 00:00:33,030\r\nWell, he should try the one-off two or three times first.\r\n\r\n15\r\n00:00:33,030 --> 00:00:34,080\r\nHe should say something like,\r\n\r\n16\r\n00:00:34,080 --> 00:00:36,090\r\n\"It\'s not convenient for you to stay here tonight.\"\r\n\r\n17\r\n00:00:36,090 --> 00:00:41,000\r\nOr, \"Is it okay if you don\'t crash on my sofa this time?\"\r\n\r\n18\r\n00:00:41,000 --> 00:00:42,070\r\nBut then, if he has to,\r\n\r\n19\r\n00:00:42,070 --> 00:00:45,050\r\nhe could maybe go up a level and point out the habit,\r\n\r\n20\r\n00:00:45,050 --> 00:00:46,080\r\nand you could say something like,\r\n\r\n21\r\n00:00:46,080 --> 00:00:49,000\r\n\"You quite often come in without checking with me first,\r\n\r\n22\r\n00:00:49,000 --> 00:00:50,080\r\n\"which sometimes gives me a problem.\r\n\r\n23\r\n00:00:50,080 --> 00:00:53,070\r\n\"So, can we agree at the start of the evening\r\n\r\n24\r\n00:00:53,070 --> 00:00:56,020\r\n\"how you\'re going to get home?\"\r\n\r\n25\r\n00:00:56,020 --> 00:00:59,040\r\nUseful phrases for pointing out habits are,\r\n\r\n26\r\n00:00:59,040 --> 00:01:00,070\r\n\"I don\'t like it when ...\",\r\n\r\n27\r\n00:01:00,070 --> 00:01:04,000\r\nor, \"Have you noticed how you tend to ...\"\r\n\r\n28\r\n00:01:04,000 --> 00:01:05,090\r\nA great example of a habit that was\r\n\r\n29\r\n00:01:05,090 --> 00:01:08,000\r\nnever assertively confronted was that,\r\n\r\n30\r\n00:01:08,000 --> 00:01:09,080\r\none of my customers knows a bunch of\r\n\r\n31\r\n00:01:09,080 --> 00:01:12,010\r\nreally nice engineers,\r\n\r\n32\r\n00:01:12,010 --> 00:01:14,010\r\nand they worked with a very chatty lady\r\n\r\n33\r\n00:01:14,010 --> 00:01:16,040\r\nwho had a habit of interrupting them.\r\n\r\n34\r\n00:01:16,040 --> 00:01:17,040\r\nShe would come into their office\r\n\r\n35\r\n00:01:17,040 --> 00:01:20,080\r\nand she would sit down and just talk for ages,\r\n\r\n36\r\n00:01:20,080 --> 00:01:23,020\r\nwhen they were busy.\r\n\r\n37\r\n00:01:23,020 --> 00:01:24,070\r\nThey weren\'t assertive enough to say,\r\n\r\n38\r\n00:01:24,070 --> 00:01:26,070\r\n\"Look, we don\'t like it when you come in.\"\r\n\r\n39\r\n00:01:26,070 --> 00:01:27,070\r\nWhat they used to do,\r\n\r\n40\r\n00:01:27,070 --> 00:01:30,050\r\nthey used to phone each other up from a different office,\r\n\r\n41\r\n00:01:30,050 --> 00:01:32,090\r\nso if you saw across the hall that somebody\r\n\r\n42\r\n00:01:32,090 --> 00:01:36,030\r\nhad this lady in there, you\'d ring them up.\r\n\r\n43\r\n00:01:36,030 --> 00:01:37,090\r\nThen, his phone would go, and he\'d go,\r\n\r\n44\r\n00:01:37,090 --> 00:01:40,000\r\n\"Oh, really? Sorry I\'ve got to go.\"\r\n\r\n45\r\n00:01:40,000 --> 00:01:41,080\r\nSo, they used to bail each other out,\r\n\r\n46\r\n00:01:41,080 --> 00:01:44,000\r\nNone of them were assertive enough just to say to her,\r\n\r\n47\r\n00:01:44,000 --> 00:01:45,010\r\n\"Actually, do you mind?\r\n\r\n48\r\n00:01:45,010 --> 00:01:46,030\r\n\"It would be great if you didn\'t come\r\n\r\n49\r\n00:01:46,030 --> 00:01:48,040\r\n\"and interrupt us when we\'re busy.\"\r\n\r\n50\r\n00:01:48,040 --> 00:01:52,040\r\nNow, was it nicer for her to not tell her\r\n\r\n51\r\n00:01:52,040 --> 00:01:54,000\r\nthat she was too chatty?\r\n\r\n52\r\n00:01:54,000 --> 00:01:57,020\r\nAnd I would say, perhaps in the short term, yes.\r\n\r\n53\r\n00:01:57,020 --> 00:01:59,010\r\nBut now in the long run.\r\n\r\n54\r\n00:01:59,010 --> 00:02:02,010\r\nThey\'d have done her a favor to tell her, I think.\r\n\r\n55\r\n00:02:02,010 --> 00:02:04,000\r\nAll this stuff was going on behind her back,\r\n\r\n56\r\n00:02:04,000 --> 00:02:08,010\r\nand that was authentic and was a bit of a shame.\r\n\r\n57\r\n00:02:08,010 --> 00:02:10,000\r\nAnyway, if you do have to give somebody news\r\n\r\n58\r\n00:02:10,000 --> 00:02:11,030\r\nthey don\'t want to hear, like,\r\n\r\n59\r\n00:02:11,030 --> 00:02:12,070\r\n\"You interrupt too often.\"\r\n\r\n60\r\n00:02:12,070 --> 00:02:14,020\r\nBlame it on yourself.\r\n\r\n61\r\n00:02:14,020 --> 00:02:16,070\r\nJust say, \"I\'m really funny about anyone interrupting me.\"\r\n\r\n62\r\n00:02:16,070 --> 00:02:17,070\r\nOr something like that,\r\n\r\n63\r\n00:02:17,070 --> 00:02:20,010\r\njust in order to get the result that you want.\r\n\r\n64\r\n00:02:20,010 --> 00:02:22,030\r\nYou know you\'re still okay\r\n\r\n65\r\n00:02:22,030 --> 00:02:25,070\r\nhowever you word the request to her.\r\n\r\n66\r\n00:02:25,070 --> 00:02:27,030\r\nAnd you are doing her a favor,\r\n\r\n67\r\n00:02:27,030 --> 00:02:28,050\r\nyou\'re also doing a favor\r\n\r\n68\r\n00:02:28,050 --> 00:02:31,090\r\nfor all of your work mates, as well.\r\n\r\n69\r\n00:02:31,090 --> 00:02:34,020\r\nAre there any people with habits out there\r\n\r\n70\r\n00:02:34,020 --> 00:02:35,070\r\nthat you need to confront?\r\n\r\n71\r\n00:02:35,070 --> 00:02:37,000\r\nAnd do you think maybe,\r\n\r\n72\r\n00:02:37,000 --> 00:02:40,010\r\nit\'s time to go up from the one-off that isn\'t working,\r\n\r\n73\r\n00:02:40,010 --> 00:02:43,000\r\nto telling them about their habit?\r\n\r\n"
                  },
                  new Video
                  {
                    Title = "Using the \'broken record\' technique",
                    Slug = "using-the-broken-record-technique",
                    Duration = 94,
                    DownloadUrl = "https://dms.licdn.com/playlist/C4D0DAQFyFRJqb4H7Kg/learning-original-video-iphone-360/0/1598507093574?e=1619539200&v=beta&t=it_WuZWOOYKrbZFpk5yef71XiQt5qoQjpobD6OaOkzo#.mp4",
                    TranscriptLines = null,
                    Transcript = "1\r\n00:00:00,070 --> 00:00:03,000\r\n- Now there’s a well-known assertiveness technique called\r\n\r\n2\r\n00:00:03,000 --> 00:00:05,040\r\nthe broken-record technique.\r\n\r\n3\r\n00:00:05,040 --> 00:00:06,070\r\nIn some ways, I don’t really like this,\r\n\r\n4\r\n00:00:06,070 --> 00:00:08,070\r\nbecause it feels a bit boring to use,\r\n\r\n5\r\n00:00:08,070 --> 00:00:12,090\r\nbut it can be very affective, so you need to know about it.\r\n\r\n6\r\n00:00:12,090 --> 00:00:18,010\r\nThis a technique where you repeat one phrase over and over.\r\n\r\n7\r\n00:00:18,010 --> 00:00:21,020\r\nThe reason that you do this is you’re sending a message\r\n\r\n8\r\n00:00:21,020 --> 00:00:23,020\r\nto the other person that they are not\r\n\r\n9\r\n00:00:23,020 --> 00:00:24,040\r\ngoing to get passed you.\r\n\r\n10\r\n00:00:24,040 --> 00:00:26,050\r\nLet’s say, for example, you work in a restaurant,\r\n\r\n11\r\n00:00:26,050 --> 00:00:27,080\r\nsomeone’s complaining about their meal\r\n\r\n12\r\n00:00:27,080 --> 00:00:29,070\r\nafter they’ve eaten all of it.\r\n\r\n13\r\n00:00:29,070 --> 00:00:31,040\r\nSo, it wasn’t obviously all that bad.\r\n\r\n14\r\n00:00:31,040 --> 00:00:32,020\r\nYou could say to them,\r\n\r\n15\r\n00:00:32,020 --> 00:00:34,040\r\n“It’s not our policy to give full refunds\r\n\r\n16\r\n00:00:34,040 --> 00:00:36,040\r\n“after you’ve eaten the whole meal.”\r\n\r\n17\r\n00:00:36,040 --> 00:00:38,090\r\nAnd If they say, “But the meal was terrible.”\r\n\r\n18\r\n00:00:38,090 --> 00:00:41,000\r\nYou can just say, “Well I’m afraid it’s not our policy\r\n\r\n19\r\n00:00:41,000 --> 00:00:43,090\r\n\"to give full refunds after you’ve eaten the whole meal.”\r\n\r\n20\r\n00:00:43,090 --> 00:00:46,030\r\nAnd if they say, “But, it’s only $10.00 I want back.”\r\n\r\n21\r\n00:00:46,030 --> 00:00:48,080\r\nYou can say, “Well I’m afraid it just not our policy\r\n\r\n22\r\n00:00:48,080 --> 00:00:51,050\r\n“to give full refunds after you’re eaten the whole meal.”\r\n\r\n23\r\n00:00:51,050 --> 00:00:53,080\r\nAnd you can feel the power of this, can’t you?\r\n\r\n24\r\n00:00:53,080 --> 00:00:55,000\r\nThe other person’s thinking,\r\n\r\n25\r\n00:00:55,000 --> 00:00:56,080\r\n“I’m not going to get passed this guy.”\r\n\r\n26\r\n00:00:56,080 --> 00:01:00,050\r\nSo, it’s easy to use, and it is powerful.\r\n\r\n27\r\n00:01:00,050 --> 00:01:02,080\r\nIt’s tempting to try to be cleaver and to come up with\r\n\r\n28\r\n00:01:02,080 --> 00:01:04,070\r\ndifferent arguments each time,\r\n\r\n29\r\n00:01:04,070 --> 00:01:06,010\r\nbut the problem is, if you do that,\r\n\r\n30\r\n00:01:06,010 --> 00:01:08,060\r\nthey’ll pick on your weakest argument.\r\n\r\n31\r\n00:01:08,060 --> 00:01:12,000\r\nThen if they defeat that, you can’t retreat back to one of\r\n\r\n32\r\n00:01:12,000 --> 00:01:13,040\r\nyour other arguments and say,\r\n\r\n33\r\n00:01:13,040 --> 00:01:15,010\r\n“Well, okay, I didn’t really mean that one,\r\n\r\n34\r\n00:01:15,010 --> 00:01:17,040\r\n\"but how about this argument?”\r\n\r\n35\r\n00:01:17,040 --> 00:01:19,090\r\nSo, the thing is just to pick a really strong argument like,\r\n\r\n36\r\n00:01:19,090 --> 00:01:24,040\r\nit’s not our policy, and then just keep repeating that.\r\n\r\n37\r\n00:01:24,040 --> 00:01:27,020\r\nSo, that’s the broken-record technique.\r\n\r\n38\r\n00:01:27,020 --> 00:01:29,000\r\nSometimes, if you’re dealing with a person\r\n\r\n39\r\n00:01:29,000 --> 00:01:30,060\r\nwho\'s very persistent,\r\n\r\n40\r\n00:01:30,060 --> 00:01:34,000\r\nit’s the only assertiveness technique that will work.\r\n\r\n"
                  },
                  new Video
                  {
                    Title = "Planning a second meeting",
                    Slug = "planning-a-second-meeting",
                    Duration = 84,
                    DownloadUrl = "https://dms.licdn.com/playlist/C4E0DAQHDOi9b0U7SMg/learning-original-video-iphone-360/0/1598507286116?e=1619539200&v=beta&t=fEnMIuIUtPQB0XCcy_kj03svzVjm9PCN_gXReC-2JTU#.mp4",
                    TranscriptLines = null,
                    Transcript = "1\r\n00:00:00,070 --> 00:00:02,090\r\n- Now a really useful assertiveness concept\r\n\r\n2\r\n00:00:02,090 --> 00:00:06,030\r\nis that it\'s never too late to go back.\r\n\r\n3\r\n00:00:06,030 --> 00:00:08,090\r\nSometimes, in fact probably quite often,\r\n\r\n4\r\n00:00:08,090 --> 00:00:11,030\r\nyou wish you\'d said something at the time,\r\n\r\n5\r\n00:00:11,030 --> 00:00:12,090\r\nbut you missed your chance.\r\n\r\n6\r\n00:00:12,090 --> 00:00:14,060\r\nThe good news is that it\'s okay.\r\n\r\n7\r\n00:00:14,060 --> 00:00:16,060\r\nYou can go back and have another go.\r\n\r\n8\r\n00:00:16,060 --> 00:00:18,080\r\nAnd in fact, it\'s probably going to work better.\r\n\r\n9\r\n00:00:18,080 --> 00:00:20,060\r\nYou\'ll probably be stronger when you\'ve had\r\n\r\n10\r\n00:00:20,060 --> 00:00:23,070\r\na chance to plan and then go back.\r\n\r\n11\r\n00:00:23,070 --> 00:00:25,080\r\nFor example, suppose somebody shouts at you\r\n\r\n12\r\n00:00:25,080 --> 00:00:28,080\r\nin the office and you don\'t know what to say.\r\n\r\n13\r\n00:00:28,080 --> 00:00:31,000\r\nYou\'re so surprised, you let them get away with it.\r\n\r\n14\r\n00:00:31,000 --> 00:00:33,040\r\nYou could go away, you could plan your words,\r\n\r\n15\r\n00:00:33,040 --> 00:00:35,060\r\nand then you could go back in and just quietly\r\n\r\n16\r\n00:00:35,060 --> 00:00:37,060\r\nsay to them, \"I was thinking about earlier\r\n\r\n17\r\n00:00:37,060 --> 00:00:39,030\r\n\"when you had that go at me, and I just think it was\r\n\r\n18\r\n00:00:39,030 --> 00:00:42,020\r\n\"a bit rude to do it like that, and maybe next time\r\n\r\n19\r\n00:00:42,020 --> 00:00:45,000\r\n\"you could talk to me quietly offline\r\n\r\n20\r\n00:00:45,000 --> 00:00:48,040\r\n\"rather than in front of everybody else.\"\r\n\r\n21\r\n00:00:48,040 --> 00:00:51,050\r\nMaybe there\'s a small but regular insult that you get\r\n\r\n22\r\n00:00:51,050 --> 00:00:54,070\r\nfrom somebody or something bad that they do to you.\r\n\r\n23\r\n00:00:54,070 --> 00:00:57,070\r\nWhy not quietly just sit down, plan how you\'re going\r\n\r\n24\r\n00:00:57,070 --> 00:01:02,010\r\nto tell them, pick a moment that suits you, and go for it.\r\n\r\n25\r\n00:01:02,010 --> 00:01:04,020\r\nBecause if you think about it, when they first attack you,\r\n\r\n26\r\n00:01:04,020 --> 00:01:05,060\r\nit\'s probably a moment that suits them.\r\n\r\n27\r\n00:01:05,060 --> 00:01:06,090\r\nIt probably doesn\'t suit you.\r\n\r\n28\r\n00:01:06,090 --> 00:01:10,030\r\nBut with this, you can choose the right moment for you.\r\n\r\n29\r\n00:01:10,030 --> 00:01:12,090\r\nSo have you had anything recently that you\'re still\r\n\r\n30\r\n00:01:12,090 --> 00:01:16,010\r\nthinking about, maybe even seething about?\r\n\r\n31\r\n00:01:16,010 --> 00:01:19,000\r\nAnd maybe for that, it\'d be a good idea to sit down,\r\n\r\n32\r\n00:01:19,000 --> 00:01:24,000\r\nmake a plan, go back to them, and get closure on it.\r\n\r\n"
                  },
                  new Video
                  {
                    Title = "Knowing the most effective words to use",
                    Slug = "knowing-the-most-effective-words-to-use",
                    Duration = 397,
                    DownloadUrl = "https://dms.licdn.com/playlist/C4D0DAQEs1G5X3IPZRg/learning-original-video-iphone-360/0/1598507500530?e=1619539200&v=beta&t=gS8o1f68xJxNlQUAEArnfm-aBzEmoX9AFj3ve7UgV2s#.mp4",
                    TranscriptLines = null,
                    Transcript = "1\r\n00:00:00,080 --> 00:00:04,090\r\n- Now the question is, what exact words should you use\r\n\r\n2\r\n00:00:04,090 --> 00:00:06,070\r\nwhen you want to tell someone something\r\n\r\n3\r\n00:00:06,070 --> 00:00:09,010\r\nthat they\'re not going to like hearing?\r\n\r\n4\r\n00:00:09,010 --> 00:00:11,040\r\nAnd this could be anything from,\r\n\r\n5\r\n00:00:11,040 --> 00:00:14,010\r\ntelling your boss that you want a raise,\r\n\r\n6\r\n00:00:14,010 --> 00:00:16,000\r\ntelling somebody that the noise of their music\r\n\r\n7\r\n00:00:16,000 --> 00:00:18,080\r\nthrough the wall is keeping you awake,\r\n\r\n8\r\n00:00:18,080 --> 00:00:21,090\r\nwanting to tell somebody that their meeting is badly run,\r\n\r\n9\r\n00:00:21,090 --> 00:00:25,010\r\nit could be anything, at home or at work.\r\n\r\n10\r\n00:00:25,010 --> 00:00:27,090\r\nWouldn\'t it be amazing if there was a magic\r\n\r\n11\r\n00:00:27,090 --> 00:00:30,020\r\nfour-step process that you could use\r\n\r\n12\r\n00:00:30,020 --> 00:00:33,000\r\nthat would work in any situation.\r\n\r\n13\r\n00:00:33,000 --> 00:00:36,090\r\nAnd there is, and I\'m gonna go through it with you now.\r\n\r\n14\r\n00:00:36,090 --> 00:00:39,050\r\nNow this four-step process isn\'t actually\r\n\r\n15\r\n00:00:39,050 --> 00:00:41,070\r\nguaranteed to work in any situation.\r\n\r\n16\r\n00:00:41,070 --> 00:00:45,000\r\nThis isn\'t gonna work if the person has no vested interest\r\n\r\n17\r\n00:00:45,000 --> 00:00:47,040\r\nin a good working relationship with you.\r\n\r\n18\r\n00:00:47,040 --> 00:00:49,080\r\nBut of course, in most home and work situations,\r\n\r\n19\r\n00:00:49,080 --> 00:00:52,050\r\nthe other person does have a vested interest\r\n\r\n20\r\n00:00:52,050 --> 00:00:54,090\r\nin keeping the relationship going, in which case,\r\n\r\n21\r\n00:00:54,090 --> 00:00:59,040\r\nthis four-step process is absolutely the best thing to use.\r\n\r\n22\r\n00:00:59,040 --> 00:01:02,090\r\nThe four-step process has the basic outline of\r\n\r\n23\r\n00:01:02,090 --> 00:01:08,030\r\nI understand, I feel, I want, Is that OK?\r\n\r\n24\r\n00:01:08,030 --> 00:01:10,000\r\nSo it consists of, first of all,\r\n\r\n25\r\n00:01:10,000 --> 00:01:12,020\r\nunderstanding their position and showing that\r\n\r\n26\r\n00:01:12,020 --> 00:01:14,000\r\nyou understand their position.\r\n\r\n27\r\n00:01:14,000 --> 00:01:18,050\r\nSecondly, explaining to them clearly how you feel.\r\n\r\n28\r\n00:01:18,050 --> 00:01:19,060\r\nAnd we\'ve already said you\'re gonna do this\r\n\r\n29\r\n00:01:19,060 --> 00:01:22,040\r\ncalmly and quietly, saying how you feel.\r\n\r\n30\r\n00:01:22,040 --> 00:01:26,010\r\nNot using facts and logic, but feelings.\r\n\r\n31\r\n00:01:26,010 --> 00:01:29,020\r\nThe third bit is to say what you want from the situation,\r\n\r\n32\r\n00:01:29,020 --> 00:01:31,050\r\nand a bit of planning beforehand might be required\r\n\r\n33\r\n00:01:31,050 --> 00:01:34,010\r\nto decide what it is that you want.\r\n\r\n34\r\n00:01:34,010 --> 00:01:37,070\r\nAnd then the fourth one is to say, \"Is that OK?\r\n\r\n35\r\n00:01:37,070 --> 00:01:39,090\r\n\"Is that a reasonable request do you think?\r\n\r\n36\r\n00:01:39,090 --> 00:01:42,020\r\n\"Could you do that for me?\"\r\n\r\n37\r\n00:01:42,020 --> 00:01:44,020\r\nI\'ll give you an example of this and then I\'ll explain\r\n\r\n38\r\n00:01:44,020 --> 00:01:47,070\r\nwhy this process is so important.\r\n\r\n39\r\n00:01:47,070 --> 00:01:48,090\r\nSuppose somebody\'s interrupting you\r\n\r\n40\r\n00:01:48,090 --> 00:01:50,030\r\nwhen you\'re busy at work.\r\n\r\n41\r\n00:01:50,030 --> 00:01:51,060\r\nYou could just say, \"Go away I\'m busy,\"\r\n\r\n42\r\n00:01:51,060 --> 00:01:53,000\r\nbut that\'s quite aggressive.\r\n\r\n43\r\n00:01:53,000 --> 00:01:55,060\r\nA nice assertive answer would be to use my\r\n\r\n44\r\n00:01:55,060 --> 00:01:59,040\r\nfour-step process and you\'d say,\r\n\r\n45\r\n00:01:59,040 --> 00:02:03,050\r\n\"I understand how urgent this is and see why you want it,\r\n\r\n46\r\n00:02:03,050 --> 00:02:06,000\r\n\"but I just feel a bit under pressure at the moment\r\n\r\n47\r\n00:02:06,000 --> 00:02:07,060\r\n\"with this work I\'m doing here.\r\n\r\n48\r\n00:02:07,060 --> 00:02:08,060\r\n\"I\'m doing this report.\r\n\r\n49\r\n00:02:08,060 --> 00:02:10,030\r\n\"I need to get it done by lunch time.\r\n\r\n50\r\n00:02:10,030 --> 00:02:12,020\r\n\"Maybe we could talk this afternoon.\r\n\r\n51\r\n00:02:12,020 --> 00:02:14,030\r\n\"Would that be OK?\"\r\n\r\n52\r\n00:02:14,030 --> 00:02:16,020\r\nSo you just follow the four-step process.\r\n\r\n53\r\n00:02:16,020 --> 00:02:18,060\r\nIt tells you what to say.\r\n\r\n54\r\n00:02:18,060 --> 00:02:22,070\r\nNow, why these four steps in the order they are?\r\n\r\n55\r\n00:02:22,070 --> 00:02:25,000\r\nAnd the reason is that steps two and three\r\n\r\n56\r\n00:02:25,000 --> 00:02:27,000\r\nare the slightly aggressive ones.\r\n\r\n57\r\n00:02:27,000 --> 00:02:29,010\r\nThe feel and the want steps of,\r\n\r\n58\r\n00:02:29,010 --> 00:02:30,070\r\nyou know, \"I don\'t wanna talk to you now.\r\n\r\n59\r\n00:02:30,070 --> 00:02:31,080\r\n\"Can we do it later?\"\r\n\r\n60\r\n00:02:31,080 --> 00:02:34,070\r\nis quite aggressive if you waded straight into that.\r\n\r\n61\r\n00:02:34,070 --> 00:02:38,070\r\nBut they\'ve got this fluffy exterior of steps one and four.\r\n\r\n62\r\n00:02:38,070 --> 00:02:41,010\r\nSo you say, \"I do understand, but,\"\r\n\r\n63\r\n00:02:41,010 --> 00:02:43,000\r\nI feel like this, I want this.\r\n\r\n64\r\n00:02:43,000 --> 00:02:44,080\r\n\"Is that OK?\"\r\n\r\n65\r\n00:02:44,080 --> 00:02:46,070\r\nSo, it\'s nice the way that two and three\r\n\r\n66\r\n00:02:46,070 --> 00:02:49,020\r\nhave got steps one and four outside them.\r\n\r\n67\r\n00:02:49,020 --> 00:02:51,000\r\nThat\'s why they\'re in that order.\r\n\r\n68\r\n00:02:51,000 --> 00:02:53,000\r\nAnd all four of them must be done.\r\n\r\n69\r\n00:02:53,000 --> 00:02:54,060\r\nIf you miss one of them out,\r\n\r\n70\r\n00:02:54,060 --> 00:02:56,080\r\nit won\'t be anything like as effective.\r\n\r\n71\r\n00:02:56,080 --> 00:02:59,050\r\nNow, after you\'ve done step four,\r\n\r\n72\r\n00:02:59,050 --> 00:03:02,000\r\nthere are two things that they might say.\r\n\r\n73\r\n00:03:02,000 --> 00:03:04,060\r\nThey may yes or they may say no.\r\n\r\n74\r\n00:03:04,060 --> 00:03:07,070\r\nNow what if they say yes and then they don\'t do it?\r\n\r\n75\r\n00:03:07,070 --> 00:03:09,020\r\nThey go, \"Yep, we\'re really sorry.\r\n\r\n76\r\n00:03:09,020 --> 00:03:10,070\r\n\"We\'ll turn the music down.\"\r\n\r\n77\r\n00:03:10,070 --> 00:03:12,040\r\nAnd then they don\'t.\r\n\r\n78\r\n00:03:12,040 --> 00:03:14,080\r\nWell, that\'s relatively straightforward because now\r\n\r\n79\r\n00:03:14,080 --> 00:03:17,030\r\nyou can get them on not keeping their promise.\r\n\r\n80\r\n00:03:17,030 --> 00:03:18,090\r\nYou can go back and say, \"Do you remember we had\r\n\r\n81\r\n00:03:18,090 --> 00:03:20,050\r\n\"that little conversation ten minutes ago\r\n\r\n82\r\n00:03:20,050 --> 00:03:21,090\r\n\"and you said you\'d turn the music down?\r\n\r\n83\r\n00:03:21,090 --> 00:03:24,020\r\n\"And you haven\'t.\r\n\r\n84\r\n00:03:24,020 --> 00:03:26,060\r\n\"Would it be possible to do that for me please?\"\r\n\r\n85\r\n00:03:26,060 --> 00:03:29,040\r\nSo once you\'ve got a yes out of them, it\'s fairly easy\r\n\r\n86\r\n00:03:29,040 --> 00:03:33,070\r\nto go back and say you haven\'t done what you said you\'d do.\r\n\r\n87\r\n00:03:33,070 --> 00:03:37,090\r\nBut what if they say, \"No, I\'m just not prepared to do that.\r\n\r\n88\r\n00:03:37,090 --> 00:03:40,010\r\n\"It\'s my party, I\'m having music, get stuffed.\"\r\n\r\n89\r\n00:03:40,010 --> 00:03:41,050\r\nWhat can you do then?\r\n\r\n90\r\n00:03:41,050 --> 00:03:43,080\r\nAnd what I\'d recommend if they say no is,\r\n\r\n91\r\n00:03:43,080 --> 00:03:46,010\r\ngo back around again.\r\n\r\n92\r\n00:03:46,010 --> 00:03:48,030\r\nAnd you can say, \"Well, I do understand it\'s your party.\r\n\r\n93\r\n00:03:48,030 --> 00:03:50,060\r\n\"It\'s great that you\'re doing that, but I really am\r\n\r\n94\r\n00:03:50,060 --> 00:03:52,080\r\n\"upset about the noise and all I want\r\n\r\n95\r\n00:03:52,080 --> 00:03:54,060\r\n\"is for you to turn it down a little bit.\r\n\r\n96\r\n00:03:54,060 --> 00:03:56,020\r\n\"Surely you could do that for me.\"\r\n\r\n97\r\n00:03:56,020 --> 00:03:58,040\r\nSo you go back around and you just jack up the words\r\n\r\n98\r\n00:03:58,040 --> 00:04:01,060\r\na little bit with, \"I really feel strongly,\"\r\n\r\n99\r\n00:04:01,060 --> 00:04:03,020\r\nand \"All I want\".\r\n\r\n100\r\n00:04:03,020 --> 00:04:05,030\r\nAnd if you go back around a second time,\r\n\r\n101\r\n00:04:05,030 --> 00:04:08,070\r\nit\'s gonna be a pretty good chance that it\'s gonna work.\r\n\r\n102\r\n00:04:08,070 --> 00:04:11,060\r\nNow, I just want to finally stress with this that\r\n\r\n103\r\n00:04:11,060 --> 00:04:16,030\r\nthis is not designed to batter the person into submission.\r\n\r\n104\r\n00:04:16,030 --> 00:04:19,000\r\nWe might be looking for some sort of working compromise\r\n\r\n105\r\n00:04:19,000 --> 00:04:21,020\r\nthat both parties can be happy with.\r\n\r\n106\r\n00:04:21,020 --> 00:04:23,090\r\nBecause, as we\'ve said earlier on this course,\r\n\r\n107\r\n00:04:23,090 --> 00:04:25,020\r\nit\'s all about rights.\r\n\r\n108\r\n00:04:25,020 --> 00:04:28,030\r\nYou\'ve got rights but so have they.\r\n\r\n109\r\n00:04:28,030 --> 00:04:31,000\r\nAnd sometimes what you\'ll find is the other person\r\n\r\n110\r\n00:04:31,000 --> 00:04:32,070\r\nis reasonably assertive as well.\r\n\r\n111\r\n00:04:32,070 --> 00:04:36,010\r\nIn fact, what if both of you have watched this video\r\n\r\n112\r\n00:04:36,010 --> 00:04:37,040\r\nand know about this technique?\r\n\r\n113\r\n00:04:37,040 --> 00:04:39,010\r\nWhat\'s gonna happen then?\r\n\r\n114\r\n00:04:39,010 --> 00:04:41,000\r\nAnd the answer is, it will still be fine.\r\n\r\n115\r\n00:04:41,000 --> 00:04:43,030\r\nIt\'s just good communication.\r\n\r\n116\r\n00:04:43,030 --> 00:04:45,000\r\nI\'ve got an example here that actually is\r\n\r\n117\r\n00:04:45,000 --> 00:04:46,090\r\nbased on a real friend of mine.\r\n\r\n118\r\n00:04:46,090 --> 00:04:49,060\r\nAnd what happened was that his wife said to him,\r\n\r\n119\r\n00:04:49,060 --> 00:04:53,020\r\nand she pretty much used the four-step process of,\r\n\r\n120\r\n00:04:53,020 --> 00:04:55,030\r\n\"I know that you don\'t like cooking\r\n\r\n121\r\n00:04:55,030 --> 00:04:57,080\r\n\"but I feel a bit neglected when you don\'t cook me food.\r\n\r\n122\r\n00:04:57,080 --> 00:05:00,060\r\n\"I would really like it if you cook me an occasional meal.\r\n\r\n123\r\n00:05:00,060 --> 00:05:03,060\r\n\"Would you do that for me?\"\r\n\r\n124\r\n00:05:03,060 --> 00:05:07,060\r\nAnd he then could have replied,\r\n\r\n125\r\n00:05:07,060 --> 00:05:10,040\r\n\"Well, I can understand why you\'d like me to cook for you,\r\n\r\n126\r\n00:05:10,040 --> 00:05:14,020\r\n\"but I feel really tired when I get back home from work\r\n\r\n127\r\n00:05:14,020 --> 00:05:17,030\r\n\"and I hate cooking and, all I want\r\n\r\n128\r\n00:05:17,030 --> 00:05:18,090\r\n\"is for you to cook the food.\r\n\r\n129\r\n00:05:18,090 --> 00:05:21,010\r\n\"Surely you could do that for me, couldn\'t you?\"\r\n\r\n130\r\n00:05:21,010 --> 00:05:22,060\r\nAnd then she could use the next one and say,\r\n\r\n131\r\n00:05:22,060 --> 00:05:24,090\r\n\"Well, I can understand why you would hate cooking\r\n\r\n132\r\n00:05:24,090 --> 00:05:26,060\r\n\"but I do really feel quite neglected\r\n\r\n133\r\n00:05:26,060 --> 00:05:28,050\r\n\"and all I want is the occasional meal.\r\n\r\n134\r\n00:05:28,050 --> 00:05:30,030\r\n\"Surely you could cook for me occasionally?\"\r\n\r\n135\r\n00:05:30,030 --> 00:05:33,000\r\nAnd they could go round and round forever, couldn\'t they?\r\n\r\n136\r\n00:05:33,000 --> 00:05:36,010\r\nBut the point is, by using this process,\r\n\r\n137\r\n00:05:36,010 --> 00:05:39,050\r\nthey\'re both saying how they feel and what they want.\r\n\r\n138\r\n00:05:39,050 --> 00:05:42,000\r\nAnd they\'re both checking with the other person\r\n\r\n139\r\n00:05:42,000 --> 00:05:44,010\r\nand saying, \"Can you see it from my point of view?\"\r\n\r\n140\r\n00:05:44,010 --> 00:05:45,070\r\nAnd hopefully they can work out some sort of\r\n\r\n141\r\n00:05:45,070 --> 00:05:49,020\r\nworking compromise where, maybe he cooks occasionally\r\n\r\n142\r\n00:05:49,020 --> 00:05:50,090\r\nor maybe they eat out once a week\r\n\r\n143\r\n00:05:50,090 --> 00:05:53,030\r\nor have a takeaway or something like that.\r\n\r\n144\r\n00:05:53,030 --> 00:05:56,050\r\nSo this technique could save a marriage.\r\n\r\n145\r\n00:05:56,050 --> 00:05:59,050\r\nSo, that\'s the four-step process.\r\n\r\n146\r\n00:05:59,050 --> 00:06:03,040\r\nI understand, I feel, I want, Is that OK?\r\n\r\n147\r\n00:06:03,040 --> 00:06:05,020\r\nAnd I\'d like you to just think about\r\n\r\n148\r\n00:06:05,020 --> 00:06:08,000\r\nwhich of those four steps you tend to forget.\r\n\r\n149\r\n00:06:08,000 --> 00:06:09,080\r\nYou know, maybe you don\'t always say how you feel\r\n\r\n150\r\n00:06:09,080 --> 00:06:12,000\r\nor maybe you\'re not very clear on what you want\r\n\r\n151\r\n00:06:12,000 --> 00:06:13,080\r\nor perhaps, you don\'t always finish\r\n\r\n152\r\n00:06:13,080 --> 00:06:16,000\r\nwith that fourth step of saying,\r\n\r\n153\r\n00:06:16,000 --> 00:06:18,000\r\n\"Do you think that\'s a reasonable request?\"\r\n\r\n154\r\n00:06:18,000 --> 00:06:20,070\r\nSo you can practice one step at a time\r\n\r\n155\r\n00:06:20,070 --> 00:06:24,020\r\nuntil you get really smooth at using all the four steps.\r\n\r\n156\r\n00:06:24,020 --> 00:06:26,030\r\nBut you could also think of a particularly difficult\r\n\r\n157\r\n00:06:26,030 --> 00:06:28,090\r\nsituation you\'ve got coming up\r\n\r\n158\r\n00:06:28,090 --> 00:06:31,030\r\nand you could actually work out what you\'re gonna say\r\n\r\n159\r\n00:06:31,030 --> 00:06:33,070\r\nfor each of those four steps so that\r\n\r\n160\r\n00:06:33,070 --> 00:06:37,000\r\nyou\'re ready to use it in a real situation.\r\n\r\n"
                  }
                }
              },
              new Chapter
              {
                Title = "Conclusion",
                Videos = new List<Video>
                {
                  new Video
                  {
                    Title = "Wrapping up",
                    Slug = "wrapping-up",
                    Duration = 51,
                    DownloadUrl = "https://dms.licdn.com/playlist/C4D0DAQFDi67nl0eY1A/learning-original-video-iphone-360/0/1598507325810?e=1619539200&v=beta&t=12oCHsZGlN6zt6H5fPfnOgBYsobHzRqu_J5q-EN-Kzk#.mp4",
                    TranscriptLines = null,
                    Transcript = "1\r\n00:00:01,010 --> 00:00:01,080\r\n- So in this course,\r\n\r\n2\r\n00:00:01,080 --> 00:00:04,030\r\nI\'ve covered what assertiveness is\r\n\r\n3\r\n00:00:04,030 --> 00:00:06,090\r\nand a whole lot of techniques that you can use\r\n\r\n4\r\n00:00:06,090 --> 00:00:09,020\r\nincluding my four step process.\r\n\r\n5\r\n00:00:09,020 --> 00:00:12,000\r\nGoing up from the one-off to the habit.\r\n\r\n6\r\n00:00:12,000 --> 00:00:14,040\r\nI notice, I interpret, am I right?\r\n\r\n7\r\n00:00:14,040 --> 00:00:18,070\r\nDetachment and commenting on the process.\r\n\r\n8\r\n00:00:18,070 --> 00:00:22,020\r\nThe next step for you now is to try some of these out.\r\n\r\n9\r\n00:00:22,020 --> 00:00:24,070\r\nMaybe pick your most difficult work colleague\r\n\r\n10\r\n00:00:24,070 --> 00:00:26,060\r\nand make a plan for how you\'re going to use this\r\n\r\n11\r\n00:00:26,060 --> 00:00:29,080\r\nnew material to handle that person better.\r\n\r\n12\r\n00:00:29,080 --> 00:00:32,070\r\nAnd I\'d be delighted if you wanted to keep in touch with me.\r\n\r\n13\r\n00:00:32,070 --> 00:00:36,000\r\nYou could follow my blog at chriscrofttraining.co.uk\r\n\r\n14\r\n00:00:36,000 --> 00:00:38,000\r\nand get my email tip of the month\r\n\r\n15\r\n00:00:38,000 --> 00:00:40,030\r\nat free-management-tips.co.uk\r\n\r\n16\r\n00:00:40,030 --> 00:00:43,020\r\nand connect with me on LinkedIn.\r\n\r\n17\r\n00:00:43,020 --> 00:00:45,060\r\nIt\'s been a pleasure having you with me on this course\r\n\r\n18\r\n00:00:45,060 --> 00:00:48,040\r\nand I\'d like to wish you good luck with how you apply it\r\n\r\n19\r\n00:00:48,040 --> 00:00:51,000\r\nand the results that it will give you.\r\n\r\n"
                  }
                }
              }
            },
                      Title = "Learning to Be Assertive",
                      ExerciseFiles = new List<ExerciseFile>
            {
              new ExerciseFile
              {
                FileName = "Ex_Files_Assertive.zip",
                DownloadUrl = "https://files3.lynda.com/secure/courses/175640/exercises/Ex_Files_Assertive.zip?FeAuFkiW5Jr6IliZwFyZTEBFci40dNqRlSJMsuCNIxWeROLgTGxdE8YRnENUviXzxLybIR7YJra4E4C05JvhQz254IEYLDZWuOXnqMISomjU37cmS8OKz0_jbVWqnXsfoffFiYtKNT_-h95D__W_7H3Gh45c"
              }
            },
                      Slug = "learning-to-be-assertive"
                  };
        internal static readonly Course INVALIDCOURSE = new Course
        {
            Chapters = new List<Chapter>
            {
              new Chapter
              {
                Title = "Introduction",
                Videos = new List<Video>
                {
                  new Video
                  {
                    Title = "Welcome",
                    Slug = "welcome",
                    Duration = 53,
                    DownloadUrl = "https://dms.licdn.com/playlist/C560DAQHWEqAHXYrTpQ/learning-original-video-iphone-360/0/1598507051468?e=1619539200&v=beta&t=70MFcPLTMNfQLzGiZ7yZRpQqbj0FQjXkWbR6ueahL_c#.mp4",
                    TranscriptLines = null,
                    Transcript = "1\r\n00:00:00,060 --> 00:00:02,020\r\n- Hi, I\'m Chris Croft and welcome to\r\n\r\n2\r\n00:00:02,020 --> 00:00:04,070\r\nthis assertiveness course.\r\n\r\n3\r\n00:00:04,070 --> 00:00:07,000\r\nAssertiveness is incredibly important,\r\n\r\n4\r\n00:00:07,000 --> 00:00:09,000\r\nbecause it underpins everything you do,\r\n\r\n5\r\n00:00:09,000 --> 00:00:11,030\r\nevery interaction you have with other people,\r\n\r\n6\r\n00:00:11,030 --> 00:00:14,020\r\nboth at home and at work, whether it\'s one to one,\r\n\r\n7\r\n00:00:14,020 --> 00:00:17,030\r\nin meetings, or with groups of friends.\r\n\r\n8\r\n00:00:17,030 --> 00:00:20,000\r\nIf you think about it, leadership requires assertiveness,\r\n\r\n9\r\n00:00:20,000 --> 00:00:23,020\r\ntime management also requires you to be assertive.\r\n\r\n10\r\n00:00:23,020 --> 00:00:27,060\r\nAnd even giving a good presentation requires assertiveness.\r\n\r\n11\r\n00:00:27,060 --> 00:00:31,050\r\nAnd it\'s hard to do, it\'s not a natural skill.\r\n\r\n12\r\n00:00:31,050 --> 00:00:34,040\r\nIt\'s much easier to be submissive or aggressive\r\n\r\n13\r\n00:00:34,040 --> 00:00:35,060\r\nin difficult situations,\r\n\r\n14\r\n00:00:35,060 --> 00:00:38,010\r\nor when you\'re dealing with difficult people.\r\n\r\n15\r\n00:00:38,010 --> 00:00:39,090\r\nSo in this course, I\'m gonna explain\r\n\r\n16\r\n00:00:39,090 --> 00:00:42,030\r\nwhat assertiveness consists of,\r\n\r\n17\r\n00:00:42,030 --> 00:00:45,040\r\nand I\'m going to cover a whole lot of practical techniques,\r\n\r\n18\r\n00:00:45,040 --> 00:00:48,000\r\nthat you\'ll be able to use immediately.\r\n\r\n19\r\n00:00:48,000 --> 00:00:51,070\r\nSo what is assertiveness, and how can we get better at it?\r\n\r\n20\r\n00:00:51,070 --> 00:00:53,000\r\nLet\'s find out.\r\n\r\n"
                  }
                }
              },
              new Chapter
              {
                Title = "2. Understanding Assertiveness",
                Videos = new List<Video>
                {
                  new Video
                  {
                    Title = "Discovering why assertion doesn\'t come naturally",
                    Slug = "discovering-why-assertion-doesn-t-come-naturally",
                    Duration = 376,
                    DownloadUrl = "https://dms.licdn.com/playlist/C4E0DAQFQXBRIEFYKBA/learning-original-video-iphone-360/0/1598507241412?e=1619539200&v=beta&t=HgK5FUrGLyTFWqUXOB3U0f7olARDqS8S8jAZSNPJ6rs#.mp4",
                    TranscriptLines = null,
                    Transcript = "1\r\n00:00:00,080 --> 00:00:03,050\r\n- So why is not easy to be assertive?\r\n\r\n2\r\n00:00:03,050 --> 00:00:06,050\r\nWhy does it not come naturally?\r\n\r\n3\r\n00:00:06,050 --> 00:00:07,090\r\nAnd I think the first reason for this\r\n\r\n4\r\n00:00:07,090 --> 00:00:10,040\r\nis that we are actually animals, really.\r\n\r\n5\r\n00:00:10,040 --> 00:00:11,060\r\nWe still are animals,\r\n\r\n6\r\n00:00:11,060 --> 00:00:14,050\r\nand we have fight or flight built into us.\r\n\r\n7\r\n00:00:14,050 --> 00:00:16,060\r\nAnd what happens in a stressful situation\r\n\r\n8\r\n00:00:16,060 --> 00:00:18,030\r\nis that chemicals like adrenaline\r\n\r\n9\r\n00:00:18,030 --> 00:00:19,080\r\npump into our bloodstream,\r\n\r\n10\r\n00:00:19,080 --> 00:00:21,020\r\nand the objective of those chemicals\r\n\r\n11\r\n00:00:21,020 --> 00:00:24,040\r\nis to help us run away or put up a stronger fight.\r\n\r\n12\r\n00:00:24,040 --> 00:00:26,080\r\nBut running away and fighting harder\r\n\r\n13\r\n00:00:26,080 --> 00:00:29,000\r\nare not really appropriate\r\n\r\n14\r\n00:00:29,000 --> 00:00:32,010\r\nresponses to most work situations.\r\n\r\n15\r\n00:00:32,010 --> 00:00:34,050\r\nNow animals only have these two choices: fight or flight.\r\n\r\n16\r\n00:00:34,050 --> 00:00:36,000\r\nBut we have third one,\r\n\r\n17\r\n00:00:36,000 --> 00:00:38,030\r\nwhich is to talk calmly about an outcome\r\n\r\n18\r\n00:00:38,030 --> 00:00:40,050\r\nthat can work for both parties.\r\n\r\n19\r\n00:00:40,050 --> 00:00:43,000\r\nAnd this is really the essence of assertiveness.\r\n\r\n20\r\n00:00:43,000 --> 00:00:44,040\r\nNot being aggressive.\r\n\r\n21\r\n00:00:44,040 --> 00:00:45,070\r\nNot being too submissive.\r\n\r\n22\r\n00:00:45,070 --> 00:00:50,020\r\nBut calmly working out an acceptable outcome for all.\r\n\r\n23\r\n00:00:50,020 --> 00:00:52,030\r\nI\'ll give you an example of how easy it is\r\n\r\n24\r\n00:00:52,030 --> 00:00:54,050\r\nto get into a fight or flight situation,\r\n\r\n25\r\n00:00:54,050 --> 00:00:56,090\r\nand also how ineffective it is.\r\n\r\n26\r\n00:00:56,090 --> 00:00:58,020\r\nI was going on a cycle ride.\r\n\r\n27\r\n00:00:58,020 --> 00:01:00,000\r\nIt was about 20 miles.\r\n\r\n28\r\n00:01:00,000 --> 00:01:02,040\r\nAnd after the first mile, we went past a house.\r\n\r\n29\r\n00:01:02,040 --> 00:01:05,010\r\nAnd this German Shepherd Alsatian dog\r\n\r\n30\r\n00:01:05,010 --> 00:01:07,010\r\ncame rushing out barking at me.\r\n\r\n31\r\n00:01:07,010 --> 00:01:09,050\r\nIt gave me a real shock, and I quickly cycled away.\r\n\r\n32\r\n00:01:09,050 --> 00:01:10,060\r\nAnd I went into flight mode.\r\n\r\n33\r\n00:01:10,060 --> 00:01:11,070\r\nThe adrenaline pumped in.\r\n\r\n34\r\n00:01:11,070 --> 00:01:12,070\r\nI cycled away.\r\n\r\n35\r\n00:01:12,070 --> 00:01:14,010\r\nI was faster than the dog.\r\n\r\n36\r\n00:01:14,010 --> 00:01:15,040\r\nAnd I got away.\r\n\r\n37\r\n00:01:15,040 --> 00:01:17,040\r\nAnd I was thinking about it as I cycled around.\r\n\r\n38\r\n00:01:17,040 --> 00:01:18,030\r\nAnd I was thinking,\r\n\r\n39\r\n00:01:18,030 --> 00:01:20,030\r\nThat dog, I\'m gonna get him.\r\n\r\n40\r\n00:01:20,030 --> 00:01:22,030\r\nBecause I knew that at the end of the ride,\r\n\r\n41\r\n00:01:22,030 --> 00:01:24,080\r\nwe were going to go back past the same house.\r\n\r\n42\r\n00:01:24,080 --> 00:01:29,040\r\nAnd I spent the whole 20 miles thinking about this dog.\r\n\r\n43\r\n00:01:29,040 --> 00:01:31,010\r\nI\'m gonna reach down and I\'m gonna get my bike pump.\r\n\r\n44\r\n00:01:31,010 --> 00:01:35,020\r\nI\'m gonna jump off my bike, and I\'m gonna shout at the dog.\r\n\r\n45\r\n00:01:35,020 --> 00:01:37,050\r\nAnd as we approached the house, I did just that.\r\n\r\n46\r\n00:01:37,050 --> 00:01:38,040\r\nI was reaching down.\r\n\r\n47\r\n00:01:38,040 --> 00:01:39,070\r\nI had the bike pump ready.\r\n\r\n48\r\n00:01:39,070 --> 00:01:41,000\r\nI was all ready to get him.\r\n\r\n49\r\n00:01:41,000 --> 00:01:42,050\r\nAnd of course he didn\'t come out.\r\n\r\n50\r\n00:01:42,050 --> 00:01:45,040\r\nHe was asleep or something like that.\r\n\r\n51\r\n00:01:45,040 --> 00:01:47,050\r\nAnd I\'d wasted the whole bike ride\r\n\r\n52\r\n00:01:47,050 --> 00:01:49,070\r\nbeing angry, ready for this dog.\r\n\r\n53\r\n00:01:49,070 --> 00:01:50,080\r\nAnd I never got closure.\r\n\r\n54\r\n00:01:50,080 --> 00:01:52,040\r\nEven now, I\'m kind of thinking about it.\r\n\r\n55\r\n00:01:52,040 --> 00:01:53,040\r\nI never got closure.\r\n\r\n56\r\n00:01:53,040 --> 00:01:55,080\r\nI never got a chance to have a go at the dog.\r\n\r\n57\r\n00:01:55,080 --> 00:01:57,030\r\nAnd what I should have done was let it go,\r\n\r\n58\r\n00:01:57,030 --> 00:01:59,010\r\nbut it\'s hard to do because you\'ve got these chemicals\r\n\r\n59\r\n00:01:59,010 --> 00:02:01,070\r\ngoing through your bloodstream.\r\n\r\n60\r\n00:02:01,070 --> 00:02:03,010\r\nSo the moral of this story I think is\r\n\r\n61\r\n00:02:03,010 --> 00:02:05,050\r\nthat with an animal there\'s no other option.\r\n\r\n62\r\n00:02:05,050 --> 00:02:08,000\r\nIt\'s either dominate or be dominated.\r\n\r\n63\r\n00:02:08,000 --> 00:02:09,040\r\nBut if it was a person,\r\n\r\n64\r\n00:02:09,040 --> 00:02:13,010\r\nthe third option would have been much better.\r\n\r\n65\r\n00:02:13,010 --> 00:02:16,000\r\nNow another reason why it\'s not automatic\r\n\r\n66\r\n00:02:16,000 --> 00:02:18,050\r\nto be assertive is our upbringing.\r\n\r\n67\r\n00:02:18,050 --> 00:02:20,050\r\nSchool is pretty much a jungle.\r\n\r\n68\r\n00:02:20,050 --> 00:02:22,090\r\nIt\'s pretty much a fight or flight jungle.\r\n\r\n69\r\n00:02:22,090 --> 00:02:25,000\r\nKids haven\'t learned about assertiveness yet.\r\n\r\n70\r\n00:02:25,000 --> 00:02:26,090\r\nThey\'re still animals in this sense.\r\n\r\n71\r\n00:02:26,090 --> 00:02:28,060\r\nAnd kids understand this.\r\n\r\n72\r\n00:02:28,060 --> 00:02:31,080\r\nI can remember at school there was one of my classmates\r\n\r\n73\r\n00:02:31,080 --> 00:02:33,090\r\nwho was terrified of wasps.\r\n\r\n74\r\n00:02:33,090 --> 00:02:35,020\r\nAnd guess what happened?\r\n\r\n75\r\n00:02:35,020 --> 00:02:36,080\r\nEvery time he used to open his desk,\r\n\r\n76\r\n00:02:36,080 --> 00:02:38,010\r\nthere\'d be another wasp in there.\r\n\r\n77\r\n00:02:38,010 --> 00:02:39,060\r\nWe were awful to him,\r\n\r\n78\r\n00:02:39,060 --> 00:02:42,030\r\nand it was a jungle there.\r\n\r\n79\r\n00:02:42,030 --> 00:02:45,010\r\nAnd so our upbringing, our first experience really\r\n\r\n80\r\n00:02:45,010 --> 00:02:46,080\r\nof socialization\r\n\r\n81\r\n00:02:46,080 --> 00:02:49,000\r\nprobably doesn\'t encourage assertiveness.\r\n\r\n82\r\n00:02:49,000 --> 00:02:51,060\r\nAnd the role models that we have at that age.\r\n\r\n83\r\n00:02:51,060 --> 00:02:54,030\r\nThey might be our parents who might be great role models,\r\n\r\n84\r\n00:02:54,030 --> 00:02:56,050\r\nbut may not.\r\n\r\n85\r\n00:02:56,050 --> 00:02:58,000\r\nThey might be rock stars.\r\n\r\n86\r\n00:02:58,000 --> 00:02:59,090\r\nThey might be people in films.\r\n\r\n87\r\n00:02:59,090 --> 00:03:02,090\r\nAction heroes or cartoon princesses.\r\n\r\n88\r\n00:03:02,090 --> 00:03:05,030\r\nIt\'s pretty random who our role models are.\r\n\r\n89\r\n00:03:05,030 --> 00:03:06,080\r\nAnd often they\'re not very constructive\r\n\r\n90\r\n00:03:06,080 --> 00:03:08,050\r\nwhen it comes to learning to be assertive\r\n\r\n91\r\n00:03:08,050 --> 00:03:11,080\r\nin real life difficult situations.\r\n\r\n92\r\n00:03:11,080 --> 00:03:13,090\r\nSo that\'s two reasons already.\r\n\r\n93\r\n00:03:13,090 --> 00:03:16,060\r\nThe animal side of us and then our upbringing.\r\n\r\n94\r\n00:03:16,060 --> 00:03:19,070\r\nBut there\'s a third reason why assertiveness is difficult.\r\n\r\n95\r\n00:03:19,070 --> 00:03:21,070\r\nAnd that\'s that the other two options\r\n\r\n96\r\n00:03:21,070 --> 00:03:25,090\r\nof being aggressive and being too submissive or passive,\r\n\r\n97\r\n00:03:25,090 --> 00:03:29,030\r\nboth have perceived payoffs which are quite tempting.\r\n\r\n98\r\n00:03:29,030 --> 00:03:32,030\r\nBut actually are not as good as we hope.\r\n\r\n99\r\n00:03:32,030 --> 00:03:33,090\r\nThey\'re only perceived payoffs.\r\n\r\n100\r\n00:03:33,090 --> 00:03:36,040\r\nIf you think about the payoff of being aggressive.\r\n\r\n101\r\n00:03:36,040 --> 00:03:38,000\r\nYou tend to think that if you\'re aggressive\r\n\r\n102\r\n00:03:38,000 --> 00:03:39,060\r\nyou\'re going to bend other people to your will,\r\n\r\n103\r\n00:03:39,060 --> 00:03:41,030\r\nand you\'re going to get what you want.\r\n\r\n104\r\n00:03:41,030 --> 00:03:44,080\r\nAnd being aggressive can work sometimes,\r\n\r\n105\r\n00:03:44,080 --> 00:03:47,050\r\nbut all too often it doesn\'t work,\r\n\r\n106\r\n00:03:47,050 --> 00:03:49,040\r\nbecause the other person will fight back\r\n\r\n107\r\n00:03:49,040 --> 00:03:51,070\r\nor they\'ll get revenge later.\r\n\r\n108\r\n00:03:51,070 --> 00:03:54,030\r\nYou\'ll make an enemy, and it\'ll cost you more in the end.\r\n\r\n109\r\n00:03:54,030 --> 00:03:58,020\r\nAnd so being aggressive is not a good life strategy overall.\r\n\r\n110\r\n00:03:58,020 --> 00:03:59,050\r\nWhat about being a submissive?\r\n\r\n111\r\n00:03:59,050 --> 00:04:00,090\r\nWhat about letting other people have their way\r\n\r\n112\r\n00:04:00,090 --> 00:04:02,070\r\nin the hope that they\'re going to like you?\r\n\r\n113\r\n00:04:02,070 --> 00:04:05,020\r\nAnd the perceived payoff is that you\'ll have an easy life\r\n\r\n114\r\n00:04:05,020 --> 00:04:06,090\r\nand you\'ll be liked.\r\n\r\n115\r\n00:04:06,090 --> 00:04:09,030\r\nBut of course, instead of saying something at the time,\r\n\r\n116\r\n00:04:09,030 --> 00:04:10,090\r\nyou end up bottling it up.\r\n\r\n117\r\n00:04:10,090 --> 00:04:12,080\r\nYou end up not getting what you want,\r\n\r\n118\r\n00:04:12,080 --> 00:04:15,000\r\nand it all it does is add to your stress,\r\n\r\n119\r\n00:04:15,000 --> 00:04:17,000\r\nand you never get closure.\r\n\r\n120\r\n00:04:17,000 --> 00:04:18,010\r\nI\'ll give you a quick example of a time\r\n\r\n121\r\n00:04:18,010 --> 00:04:20,060\r\nwhen I wasn\'t assertive enough.\r\n\r\n122\r\n00:04:20,060 --> 00:04:23,050\r\nI used to share an office with a guy called Paul.\r\n\r\n123\r\n00:04:23,050 --> 00:04:25,090\r\nAnd he used to irritate me anyway,\r\n\r\n124\r\n00:04:25,090 --> 00:04:28,070\r\n\'cause he used to not answer my phone when I was away.\r\n\r\n125\r\n00:04:28,070 --> 00:04:29,080\r\nHe never left me messages.\r\n\r\n126\r\n00:04:29,080 --> 00:04:32,020\r\nI used to leave him messages of people who\'d called.\r\n\r\n127\r\n00:04:32,020 --> 00:04:34,010\r\nBut one day he did something which really upset me,\r\n\r\n128\r\n00:04:34,010 --> 00:04:36,050\r\nwas he brought his lunch back to the office,\r\n\r\n129\r\n00:04:36,050 --> 00:04:39,080\r\nand he was eating fried egg and baked beans.\r\n\r\n130\r\n00:04:39,080 --> 00:04:42,050\r\nAnd the whole office stank of beans.\r\n\r\n131\r\n00:04:42,050 --> 00:04:45,050\r\nAnd I remember thinking if he does it again,\r\n\r\n132\r\n00:04:45,050 --> 00:04:48,010\r\nI\'m going to say something to him about it.\r\n\r\n133\r\n00:04:48,010 --> 00:04:49,060\r\nBut I thought I won\'t say something this time.\r\n\r\n134\r\n00:04:49,060 --> 00:04:51,020\r\nI\'ll wait and I\'ll see if he does it a second time\r\n\r\n135\r\n00:04:51,020 --> 00:04:52,060\r\nand then I\'ll say something.\r\n\r\n136\r\n00:04:52,060 --> 00:04:54,050\r\nBut he never did it again.\r\n\r\n137\r\n00:04:54,050 --> 00:04:56,040\r\nAnd the ridiculous thing is\r\n\r\n138\r\n00:04:56,040 --> 00:04:59,050\r\nI\'ve still got that thought in my mind years later\r\n\r\n139\r\n00:04:59,050 --> 00:05:00,090\r\nthat if he does it again I\'ll say something.\r\n\r\n140\r\n00:05:00,090 --> 00:05:02,090\r\nBecause I never got closure on it.\r\n\r\n141\r\n00:05:02,090 --> 00:05:04,010\r\nI never needed to.\r\n\r\n142\r\n00:05:04,010 --> 00:05:05,010\r\nAnd of course what probably have happened\r\n\r\n143\r\n00:05:05,010 --> 00:05:06,060\r\nis if he\'d done it again I would have bottled it up\r\n\r\n144\r\n00:05:06,060 --> 00:05:08,040\r\nuntil he\'d done it about five times,\r\n\r\n145\r\n00:05:08,040 --> 00:05:10,020\r\nand then suddenly I would have flipped\r\n\r\n146\r\n00:05:10,020 --> 00:05:12,060\r\nfrom being too submissive to being aggressive.\r\n\r\n147\r\n00:05:12,060 --> 00:05:13,040\r\nAnd I suddenly would have gone,\r\n\r\n148\r\n00:05:13,040 --> 00:05:15,050\r\nPaul, stop eating those beans!\r\n\r\n149\r\n00:05:15,050 --> 00:05:17,040\r\nAnd then that would have been totally the wrong approach.\r\n\r\n150\r\n00:05:17,040 --> 00:05:18,070\r\nHe would\'ve said, \"Well I didn\'t know it was a problem.\r\n\r\n151\r\n00:05:18,070 --> 00:05:20,010\r\n\"You never told me.\"\r\n\r\n152\r\n00:05:20,010 --> 00:05:22,080\r\nSo bottling it up and then exploding and swinging\r\n\r\n153\r\n00:05:22,080 --> 00:05:28,010\r\nfrom one end of the scale to the other is not a good plan.\r\n\r\n154\r\n00:05:28,010 --> 00:05:30,030\r\nSulking, what can we do about this?\r\n\r\n155\r\n00:05:30,030 --> 00:05:31,090\r\nI suppose the first thing is to realize\r\n\r\n156\r\n00:05:31,090 --> 00:05:33,020\r\nthat we are animals.\r\n\r\n157\r\n00:05:33,020 --> 00:05:34,050\r\nWe have to make allowance for the fact\r\n\r\n158\r\n00:05:34,050 --> 00:05:37,060\r\nthat we\'ve got these chemicals that go through our systems.\r\n\r\n159\r\n00:05:37,060 --> 00:05:40,050\r\nAnd then we should use the power of our conscious brains\r\n\r\n160\r\n00:05:40,050 --> 00:05:42,070\r\nto take control of how we react.\r\n\r\n161\r\n00:05:42,070 --> 00:05:45,050\r\nTo think before we act, because we do have control\r\n\r\n162\r\n00:05:45,050 --> 00:05:47,080\r\nover how we act in situations.\r\n\r\n163\r\n00:05:47,080 --> 00:05:50,010\r\nAnd that\'s really what this course is about.\r\n\r\n164\r\n00:05:50,010 --> 00:05:52,080\r\nBeing aware of yourself in situations,\r\n\r\n165\r\n00:05:52,080 --> 00:05:55,040\r\nand then using the best strategies for those.\r\n\r\n166\r\n00:05:55,040 --> 00:05:58,000\r\nSo I\'d like you start thinking about situations\r\n\r\n167\r\n00:05:58,000 --> 00:06:00,040\r\nwhere maybe you could\'ve been more assertive.\r\n\r\n168\r\n00:06:00,040 --> 00:06:02,030\r\nMaybe you became a bit more aggressive\r\n\r\n169\r\n00:06:02,030 --> 00:06:05,020\r\nthan you should\'ve been, or maybe where you were too passive\r\n\r\n170\r\n00:06:05,020 --> 00:06:06,090\r\nand you let other people get away with things,\r\n\r\n171\r\n00:06:06,090 --> 00:06:07,080\r\nwhich is retrospect,\r\n\r\n172\r\n00:06:07,080 --> 00:06:09,080\r\nyou shouldn\'t have let them get away with.\r\n\r\n173\r\n00:06:09,080 --> 00:06:11,070\r\nStart thinking about those situations\r\n\r\n174\r\n00:06:11,070 --> 00:06:13,010\r\nand start thinking about whether\r\n\r\n175\r\n00:06:13,010 --> 00:06:16,000\r\nthe middle way would\'ve been more productive for you.\r\n\r\n"
                  },
                  new Video
                  {
                    Title = "Understanding your rights and responsibilities",
                    Slug = "understanding-your-rights-and-responsibilities",
                    Duration = 155,
                    DownloadUrl = "https://dms.licdn.com/playlist/C4D0DAQGTR3TpIjLqgg/learning-original-video-iphone-360/0/1598507260818?e=1619539200&v=beta&t=2IKTylBTZGgEhD6alDV5ussemD7dk9xtIQBskbYIdj0#.mp4",
                    TranscriptLines = null,
                    Transcript = "1\r\n00:00:00,050 --> 00:00:03,070\r\n- Now a major part of assertiveness is about rights.\r\n\r\n2\r\n00:00:03,070 --> 00:00:06,010\r\nIt\'s about your rights and the rights of other people.\r\n\r\n3\r\n00:00:06,010 --> 00:00:09,030\r\nSo, the objective is to stand up for your own rights,\r\n\r\n4\r\n00:00:09,030 --> 00:00:12,050\r\nwhile also respecting the rights of other people.\r\n\r\n5\r\n00:00:12,050 --> 00:00:15,020\r\nSo for example, I\'ve got a right to wear this shirt.\r\n\r\n6\r\n00:00:15,020 --> 00:00:18,010\r\nYou\'ve got a right to dislike this shirt.\r\n\r\n7\r\n00:00:18,010 --> 00:00:19,080\r\nI\'ve got a right to ignore the fact that you don\'t\r\n\r\n8\r\n00:00:19,080 --> 00:00:21,000\r\nlike this shirt.\r\n\r\n9\r\n00:00:21,000 --> 00:00:22,080\r\nI think it\'s okay, I\'m happy.\r\n\r\n10\r\n00:00:22,080 --> 00:00:24,090\r\nBy the way, if you really hate this shirt,\r\n\r\n11\r\n00:00:24,090 --> 00:00:28,020\r\nI should respect your right to hate this shirt\r\n\r\n12\r\n00:00:28,020 --> 00:00:30,010\r\nand I should wear a different shirt.\r\n\r\n13\r\n00:00:30,010 --> 00:00:32,000\r\nOther rights to be heard.\r\n\r\n14\r\n00:00:32,000 --> 00:00:34,020\r\nSo for example in a meeting, you might speak up\r\n\r\n15\r\n00:00:34,020 --> 00:00:36,060\r\nthey may not hear you and you might think\r\n\r\n16\r\n00:00:36,060 --> 00:00:38,000\r\noh well, I don\'t want to say it a second time\r\n\r\n17\r\n00:00:38,000 --> 00:00:39,040\r\nbecause I don\'t want to be boring,\r\n\r\n18\r\n00:00:39,040 --> 00:00:40,050\r\nbut you\'ve got a right to be heard.\r\n\r\n19\r\n00:00:40,050 --> 00:00:42,010\r\nYou\'ve got a right to repeat yourself\r\n\r\n20\r\n00:00:42,010 --> 00:00:43,090\r\nuntil they acknowledge what you\'ve said\r\n\r\n21\r\n00:00:43,090 --> 00:00:46,000\r\neven if they disagree with it.\r\n\r\n22\r\n00:00:46,000 --> 00:00:49,060\r\nAnd you\'ve also got a right to be able to say how you feel.\r\n\r\n23\r\n00:00:49,060 --> 00:00:51,040\r\nEveryone has a right to say how they feel.\r\n\r\n24\r\n00:00:51,040 --> 00:00:52,080\r\nIf they\'re not happy about something,\r\n\r\n25\r\n00:00:52,080 --> 00:00:57,010\r\nthey\'ve got a right to have that feeling and to express it.\r\n\r\n26\r\n00:00:57,010 --> 00:01:00,000\r\nOne of the things I regret teaching my wife a long time ago\r\n\r\n27\r\n00:01:00,000 --> 00:01:03,060\r\nis the little phrase, \"I don\'t have to justify how I feel.\"\r\n\r\n28\r\n00:01:03,060 --> 00:01:05,070\r\nand she uses this on me quite often, actually.\r\n\r\n29\r\n00:01:05,070 --> 00:01:06,060\r\nWhen I\'m saying to her,\r\n\r\n30\r\n00:01:06,060 --> 00:01:08,030\r\n\"Why don\'t you want to see this film?\"\r\n\r\n31\r\n00:01:08,030 --> 00:01:10,020\r\nor, \"Why don\'t you like that?\"\r\n\r\n32\r\n00:01:10,020 --> 00:01:13,030\r\nShe just says, \"Well, I don\'t have to justify how I feel.\"\r\n\r\n33\r\n00:01:13,030 --> 00:01:15,050\r\nAnd she\'s right, she doesn\'t have to justify.\r\n\r\n34\r\n00:01:15,050 --> 00:01:16,090\r\nShe can have any feeling she likes\r\n\r\n35\r\n00:01:16,090 --> 00:01:20,030\r\nand she can express them.\r\n\r\n36\r\n00:01:20,030 --> 00:01:23,000\r\nSome other examples of rights might be\r\n\r\n37\r\n00:01:23,000 --> 00:01:26,040\r\nsaying something that\'s a little bit unpopular in a meeting.\r\n\r\n38\r\n00:01:26,040 --> 00:01:29,050\r\nI can remember once in a meeting it was losing it\'s thread.\r\n\r\n39\r\n00:01:29,050 --> 00:01:30,070\r\nIt had gone way off track.\r\n\r\n40\r\n00:01:30,070 --> 00:01:32,030\r\nThere was no progress being made\r\n\r\n41\r\n00:01:32,030 --> 00:01:33,080\r\nand I remember I suddenly said this; I just said,\r\n\r\n42\r\n00:01:33,080 --> 00:01:35,010\r\n\"Look, this meeting\'s...\r\n\r\n43\r\n00:01:35,010 --> 00:01:37,020\r\n\'but where are we going in this meeting?\"\r\n\r\n44\r\n00:01:37,020 --> 00:01:38,050\r\nAnd they all went a bit quiet\r\n\r\n45\r\n00:01:38,050 --> 00:01:40,030\r\nand then afterwards they all said to me,\r\n\r\n46\r\n00:01:40,030 --> 00:01:42,030\r\n\"Chris, we\'re really glad you said that.\r\n\r\n47\r\n00:01:42,030 --> 00:01:43,050\r\n\'We all thought that.\"\r\n\r\n48\r\n00:01:43,050 --> 00:01:45,030\r\nBut none of them had been assertive enough\r\n\r\n49\r\n00:01:45,030 --> 00:01:47,020\r\nto just stand up for themselves in the meeting\r\n\r\n50\r\n00:01:47,020 --> 00:01:48,090\r\nand say, \"Look what\'s going on?\"\r\n\r\n51\r\n00:01:48,090 --> 00:01:50,080\r\nSo, speaking up in front of other people\r\n\r\n52\r\n00:01:50,080 --> 00:01:53,020\r\nis a right you\'ve got.\r\n\r\n53\r\n00:01:53,020 --> 00:01:54,060\r\nSo, I want you to think about\r\n\r\n54\r\n00:01:54,060 --> 00:01:57,010\r\ndo you stand up enough for your personal rights?\r\n\r\n55\r\n00:01:57,010 --> 00:01:57,080\r\nWhich of your rights\r\n\r\n56\r\n00:01:57,080 --> 00:02:00,070\r\nhave you perhaps not stood up for recently?\r\n\r\n57\r\n00:02:00,070 --> 00:02:04,010\r\nAnd also, are you respecting the rights of other people\r\n\r\n58\r\n00:02:04,010 --> 00:02:06,040\r\nand this second one can be difficult\r\n\r\n59\r\n00:02:06,040 --> 00:02:09,020\r\nbecause it\'s hard to see it from their point of view.\r\n\r\n60\r\n00:02:09,020 --> 00:02:10,090\r\nSo, are you sure\r\n\r\n61\r\n00:02:10,090 --> 00:02:13,000\r\nthat you\'re respecting the rights of others?\r\n\r\n62\r\n00:02:13,000 --> 00:02:15,070\r\nAnd remember that you are responsible for everything\r\n\r\n63\r\n00:02:15,070 --> 00:02:18,050\r\nthat you think and say and do.\r\n\r\n64\r\n00:02:18,050 --> 00:02:20,060\r\nSo, if you don\'t respect the rights of somebody else,\r\n\r\n65\r\n00:02:20,060 --> 00:02:22,020\r\nor if you don\'t stand up for your own,\r\n\r\n66\r\n00:02:22,020 --> 00:02:23,070\r\nyou are responsible for that\r\n\r\n67\r\n00:02:23,070 --> 00:02:26,020\r\nand you\'ve chosen to not do that.\r\n\r\n68\r\n00:02:26,020 --> 00:02:29,010\r\nSo, have a think about rights and see if there are areas\r\n\r\n69\r\n00:02:29,010 --> 00:02:31,060\r\nwhere maybe you could be a little bit stronger,\r\n\r\n70\r\n00:02:31,060 --> 00:02:35,000\r\nbut also a little bit more respectful to other people.\r\n\r\n"
                  },
                  new Video
                  {
                    Title = "Identifying your current mindset",
                    Slug = "identifying-your-current-mindset",
                    Duration = 297,
                    DownloadUrl = "https://dms.licdn.com/playlist/C560DAQG8umlJSkFFmA/learning-original-video-iphone-360/0/1598507057834?e=1619539200&v=beta&t=88XkNWMeAlCn_MDsn2jQo7XGhspCYIJRr82AYrSWuH8#.mp4",
                    TranscriptLines = null,
                    Transcript = "1\r\n00:00:00,090 --> 00:00:03,010\r\n- Now we\'ve been talking about rights.\r\n\r\n2\r\n00:00:03,010 --> 00:00:05,020\r\nWhether you stand up for your own rights or not\r\n\r\n3\r\n00:00:05,020 --> 00:00:07,030\r\nreally depends on whether you believe\r\n\r\n4\r\n00:00:07,030 --> 00:00:09,050\r\nthat you deserve to be able to stand up for your rights,\r\n\r\n5\r\n00:00:09,050 --> 00:00:11,060\r\nare you okay about yourself.\r\n\r\n6\r\n00:00:11,060 --> 00:00:13,040\r\nAnd similarly, whether you stand up for\r\n\r\n7\r\n00:00:13,040 --> 00:00:16,000\r\nother people\'s rights and respect their views\r\n\r\n8\r\n00:00:16,000 --> 00:00:19,010\r\ndepends on whether you believe that they are ok enough\r\n\r\n9\r\n00:00:19,010 --> 00:00:21,030\r\nto deserve to have those rights.\r\n\r\n10\r\n00:00:21,030 --> 00:00:24,000\r\nThis idea of being okay is essential\r\n\r\n11\r\n00:00:24,000 --> 00:00:26,020\r\nto the subject of assertiveness.\r\n\r\n12\r\n00:00:26,020 --> 00:00:29,040\r\nThe word \"okay\" is quite an important word to define.\r\n\r\n13\r\n00:00:29,040 --> 00:00:31,090\r\nWe\'re not talking about believing that you\'re perfect,\r\n\r\n14\r\n00:00:31,090 --> 00:00:34,040\r\nor believing that you\'re better than everybody else.\r\n\r\n15\r\n00:00:34,040 --> 00:00:36,070\r\nYou\'ve just gotta believe that you\'re okay as a person.\r\n\r\n16\r\n00:00:36,070 --> 00:00:38,070\r\nYou\'re good enough to deserve to have rights\r\n\r\n17\r\n00:00:38,070 --> 00:00:40,090\r\nand to stand up for them.\r\n\r\n18\r\n00:00:40,090 --> 00:00:44,020\r\nIt\'s important to think about, are you okay?\r\n\r\n19\r\n00:00:44,020 --> 00:00:47,000\r\nDo you think that you\'re generally all right as a person?\r\n\r\n20\r\n00:00:47,000 --> 00:00:49,040\r\nAnd also other people. Is your starting point with\r\n\r\n21\r\n00:00:49,040 --> 00:00:52,040\r\nother people that they\'re generally okay or not.\r\n\r\n22\r\n00:00:52,040 --> 00:00:54,090\r\nIt\'s not gonna be good for relationships if your starting\r\n\r\n23\r\n00:00:54,090 --> 00:00:59,030\r\nposition is that other people are generally not okay.\r\n\r\n24\r\n00:00:59,030 --> 00:01:02,030\r\nWe can draw a little 2x2 matrix of this.\r\n\r\n25\r\n00:01:02,030 --> 00:01:04,040\r\nOn the vertical axis we\'re gonna have\r\n\r\n26\r\n00:01:04,040 --> 00:01:06,000\r\nwhether you\'re okay or not.\r\n\r\n27\r\n00:01:06,000 --> 00:01:07,090\r\nSo we\'re gonna have you\'re okay and you\'re not ok\r\n\r\n28\r\n00:01:07,090 --> 00:01:09,050\r\non the vertical axis.\r\n\r\n29\r\n00:01:09,050 --> 00:01:11,000\r\nOn the horizontal axis we\'re gonna have\r\n\r\n30\r\n00:01:11,000 --> 00:01:12,090\r\nhow you feel about other people.\r\n\r\n31\r\n00:01:12,090 --> 00:01:15,010\r\nDo you generally believe that other people are okay,\r\n\r\n32\r\n00:01:15,010 --> 00:01:17,000\r\nor that they\'re not okay.\r\n\r\n33\r\n00:01:17,000 --> 00:01:18,030\r\nIf you look at the combinations,\r\n\r\n34\r\n00:01:18,030 --> 00:01:21,010\r\nclearly the top left is where we want to be\r\n\r\n35\r\n00:01:21,010 --> 00:01:25,040\r\nfor the best results in any relationship.\r\n\r\n36\r\n00:01:25,040 --> 00:01:28,080\r\nThe problems start to happen in the other boxes.\r\n\r\n37\r\n00:01:28,080 --> 00:01:32,000\r\nThis top left one, where we believe we\'re okay and they are,\r\n\r\n38\r\n00:01:32,000 --> 00:01:33,090\r\nthat\'s where assertiveness is\r\n\r\n39\r\n00:01:33,090 --> 00:01:35,050\r\nand that\'s where we want to be.\r\n\r\n40\r\n00:01:35,050 --> 00:01:37,080\r\nBut what about the top right?\r\n\r\n41\r\n00:01:37,080 --> 00:01:39,060\r\nWhere you believe that you\'re okay,\r\n\r\n42\r\n00:01:39,060 --> 00:01:41,060\r\nbut the other person is not.\r\n\r\n43\r\n00:01:41,060 --> 00:01:43,060\r\nThis is the aggressive box, and there are\r\n\r\n44\r\n00:01:43,060 --> 00:01:46,020\r\npeople who naturally gravitate to this box.\r\n\r\n45\r\n00:01:46,020 --> 00:01:48,090\r\nTheir starting position is, \"The world is stupid.\"\r\n\r\n46\r\n00:01:48,090 --> 00:01:51,000\r\nI\'ve got an example of this\r\n\r\n47\r\n00:01:51,000 --> 00:01:52,090\r\nsomebody told me about in a hospital.\r\n\r\n48\r\n00:01:52,090 --> 00:01:55,030\r\nThere was a doctor there who had touched a patient,\r\n\r\n49\r\n00:01:55,030 --> 00:01:57,090\r\nand he was washing his hands after doing that.\r\n\r\n50\r\n00:01:57,090 --> 00:02:00,010\r\nWhen he looked around there were no towels,\r\n\r\n51\r\n00:02:00,010 --> 00:02:03,010\r\nso he pulled the curtain down off the wall,\r\n\r\n52\r\n00:02:03,010 --> 00:02:04,070\r\ndried his hands on the curtain,\r\n\r\n53\r\n00:02:04,070 --> 00:02:06,030\r\nand just threw it away on the floor and said,\r\n\r\n54\r\n00:02:06,030 --> 00:02:08,080\r\n\"Nurse, there\'s no towels!\"\r\n\r\n55\r\n00:02:08,080 --> 00:02:10,030\r\nAnd that\'s really aggressive.\r\n\r\n56\r\n00:02:10,030 --> 00:02:11,040\r\nHis belief is that he\'s the\r\n\r\n57\r\n00:02:11,040 --> 00:02:13,010\r\nonly person with a brain in that place,\r\n\r\n58\r\n00:02:13,010 --> 00:02:14,080\r\nand the rest of them are all idiots;\r\n\r\n59\r\n00:02:14,080 --> 00:02:16,050\r\nThat\'s really aggressive.\r\n\r\n60\r\n00:02:16,050 --> 00:02:18,010\r\nNot a good starting point.\r\n\r\n61\r\n00:02:18,010 --> 00:02:21,040\r\nThat\'s gonna harm the results that that doctor gets.\r\n\r\n62\r\n00:02:21,040 --> 00:02:23,050\r\nIf he needs help from other people they\'re not\r\n\r\n63\r\n00:02:23,050 --> 00:02:26,090\r\ngonna be on his side, it\'s not a good starting point.\r\n\r\n64\r\n00:02:26,090 --> 00:02:28,070\r\nThe nurses on the other hand in that situation,\r\n\r\n65\r\n00:02:28,070 --> 00:02:30,060\r\nthey were pushed into the bottom left,\r\n\r\n66\r\n00:02:30,060 --> 00:02:32,060\r\ninto the \"I\'m not okay\" box.\r\n\r\n67\r\n00:02:32,060 --> 00:02:34,070\r\nThey were submissively hiding behind\r\n\r\n68\r\n00:02:34,070 --> 00:02:35,090\r\none of the beds probably,\r\n\r\n69\r\n00:02:35,090 --> 00:02:38,040\r\nthinking, \"Oh no, we\'ve probably upset the doctor.\"\r\n\r\n70\r\n00:02:38,040 --> 00:02:39,060\r\nAnd you might think,\r\n\r\n71\r\n00:02:39,060 --> 00:02:42,060\r\n\"Not many people are gonna be in the I\'m not okay box.\"\r\n\r\n72\r\n00:02:42,060 --> 00:02:46,070\r\nBut actually it\'s very easy to be in the not okay box.\r\n\r\n73\r\n00:02:46,070 --> 00:02:49,060\r\nDo you like the sight of yourself in a mirror?\r\n\r\n74\r\n00:02:49,060 --> 00:02:51,070\r\nDo you like the sound of your voice\r\n\r\n75\r\n00:02:51,070 --> 00:02:53,070\r\non an answer phone message?\r\n\r\n76\r\n00:02:53,070 --> 00:02:55,030\r\nAnd people are often not even okay about\r\n\r\n77\r\n00:02:55,030 --> 00:02:57,030\r\nhow they look or how they sound.\r\n\r\n78\r\n00:02:57,030 --> 00:03:00,030\r\nLet alone all of the other intricacies of their personality.\r\n\r\n79\r\n00:03:00,030 --> 00:03:01,090\r\nThe thing is that the world is trying\r\n\r\n80\r\n00:03:01,090 --> 00:03:04,070\r\nto push us down into this not okay box.\r\n\r\n81\r\n00:03:04,070 --> 00:03:07,090\r\nYou look at women\'s magazines, they\'ve got beautiful people,\r\n\r\n82\r\n00:03:07,090 --> 00:03:10,000\r\nairbrushed, looking perfect.\r\n\r\n83\r\n00:03:10,000 --> 00:03:12,000\r\nAnd there\'s pressure on us\r\n\r\n84\r\n00:03:12,000 --> 00:03:13,060\r\nto look like the women on the cover,\r\n\r\n85\r\n00:03:13,060 --> 00:03:15,090\r\nor the man on the cover of men\'s magazines\r\n\r\n86\r\n00:03:15,090 --> 00:03:17,090\r\nincreasingly as well.\r\n\r\n87\r\n00:03:17,090 --> 00:03:20,050\r\nSo it\'s very important to believe that you\'re okay\r\n\r\n88\r\n00:03:20,050 --> 00:03:23,020\r\nand to have, maybe a mantra, which is,\r\n\r\n89\r\n00:03:23,020 --> 00:03:26,010\r\n\"Nobody\'s gonna push me into the not okay box.\r\n\r\n90\r\n00:03:26,010 --> 00:03:27,070\r\n\"I\'m okay as a person.\r\n\r\n91\r\n00:03:27,070 --> 00:03:29,020\r\n\"I\'m not perfect, but I\'m good enough,\r\n\r\n92\r\n00:03:29,020 --> 00:03:31,040\r\n\"and the world is not gonna tell me that I\'m not.\r\n\r\n93\r\n00:03:31,040 --> 00:03:34,060\r\n\"I\'ll decide whether I\'m okay or not.\"\r\n\r\n94\r\n00:03:34,060 --> 00:03:36,070\r\nNow there is one more box that I haven\'t mentioned:\r\n\r\n95\r\n00:03:36,070 --> 00:03:40,080\r\nThe I\'m not okay and the world is also not okay box.\r\n\r\n96\r\n00:03:40,080 --> 00:03:44,090\r\nThis box is unsustainable, you can\'t live in this box.\r\n\r\n97\r\n00:03:44,090 --> 00:03:48,060\r\nApparently teenagers quite often start in the bottom left,\r\n\r\n98\r\n00:03:48,060 --> 00:03:51,030\r\nfeeling not okay, maybe they\'re spotty,\r\n\r\n99\r\n00:03:51,030 --> 00:03:54,000\r\nthey can\'t get a girlfriend, everything\'s too difficult.\r\n\r\n100\r\n00:03:54,000 --> 00:03:57,010\r\nAnd then as they start to lose respect for their parents\r\n\r\n101\r\n00:03:57,010 --> 00:03:59,050\r\nand discover their parents don\'t know all the answers either\r\n\r\n102\r\n00:03:59,050 --> 00:04:02,090\r\nthey start to move across into that bottom right box.\r\n\r\n103\r\n00:04:02,090 --> 00:04:05,000\r\nBut of course the problem is then you\'ve\r\n\r\n104\r\n00:04:05,000 --> 00:04:06,080\r\ngot nothing to cling to at all, nothing\'s all right.\r\n\r\n105\r\n00:04:06,080 --> 00:04:09,070\r\nThe theory goes that you have to come out\r\n\r\n106\r\n00:04:09,070 --> 00:04:12,040\r\neither by going upwards into the aggressive box of,\r\n\r\n107\r\n00:04:12,040 --> 00:04:15,040\r\n\"(scoffs) Everybody\'s a fool, they don\'t understand me.\r\n\r\n108\r\n00:04:15,040 --> 00:04:17,060\r\n\"They\'ve got no taste in cloths,\r\n\r\n109\r\n00:04:17,060 --> 00:04:19,020\r\n\"they\'ve got no musical taste.\"\r\n\r\n110\r\n00:04:19,020 --> 00:04:22,010\r\nOr they have to go back into the depressed box of,\r\n\r\n111\r\n00:04:22,010 --> 00:04:24,000\r\n\"Oh, I\'m just not good enough.\"\r\n\r\n112\r\n00:04:24,000 --> 00:04:26,030\r\nBut hopefully whichever box they come out into\r\n\r\n113\r\n00:04:26,030 --> 00:04:28,020\r\nthey will eventually find their way up into that\r\n\r\n114\r\n00:04:28,020 --> 00:04:31,010\r\ntop left box of believing that they\'re not too bad, really,\r\n\r\n115\r\n00:04:31,010 --> 00:04:33,000\r\nand the world isn\'t too bad really,\r\n\r\n116\r\n00:04:33,000 --> 00:04:35,060\r\nand they can get on with life.\r\n\r\n117\r\n00:04:35,060 --> 00:04:38,000\r\nI\'d like you to just think about yourself,\r\n\r\n118\r\n00:04:38,000 --> 00:04:39,070\r\nwhich is your home box.\r\n\r\n119\r\n00:04:39,070 --> 00:04:42,050\r\nDo you tend to be a bit too not okay about yourself,\r\n\r\n120\r\n00:04:42,050 --> 00:04:45,090\r\nor do you tend to assume that other people are not okay?\r\n\r\n121\r\n00:04:45,090 --> 00:04:48,030\r\nHopefully you\'re safely in that top left box\r\n\r\n122\r\n00:04:48,030 --> 00:04:51,010\r\nof believing that you\'re okay and that everyone else is.\r\n\r\n123\r\n00:04:51,010 --> 00:04:54,020\r\nNow remember: You decide whether you\'re okay.\r\n\r\n124\r\n00:04:54,020 --> 00:04:57,000\r\nNobody else can push you into that not okay box.\r\n\r\n"
                  },
                  new Video
                  {
                    Title = "Avoiding the passive-aggressive trap",
                    Slug = "avoiding-the-passive-aggressive-trap",
                    Duration = 171,
                    DownloadUrl = "https://dms.licdn.com/playlist/C4D0DAQEeq7CIGE4mgA/learning-original-video-iphone-360/0/1598507247837?e=1619539200&v=beta&t=rmro2QYex52e6d3yE9iBmdMrBg2RZghjOW2d-uOG0m4#.mp4",
                    TranscriptLines = null,
                    Transcript = "1\r\n00:00:00,070 --> 00:00:02,000\r\n- Now, there\'s one more combination\r\n\r\n2\r\n00:00:02,000 --> 00:00:03,040\r\nI haven\'t mentioned yet,\r\n\r\n3\r\n00:00:03,040 --> 00:00:05,020\r\nwhich is passive-aggressive.\r\n\r\n4\r\n00:00:05,020 --> 00:00:07,060\r\nWe\'ve only been looking at passive or submissive,\r\n\r\n5\r\n00:00:07,060 --> 00:00:08,090\r\nthey mean the same thing.\r\n\r\n6\r\n00:00:08,090 --> 00:00:12,010\r\nAnd aggressive, and then assertive as the right way.\r\n\r\n7\r\n00:00:12,010 --> 00:00:14,090\r\nBut what about if you didn\'t respect anybody\'s rights?\r\n\r\n8\r\n00:00:14,090 --> 00:00:16,040\r\nNot yours or theirs.\r\n\r\n9\r\n00:00:16,040 --> 00:00:17,080\r\nThat would be passive-aggressive,\r\n\r\n10\r\n00:00:17,080 --> 00:00:20,000\r\nand this is really the worst combination.\r\n\r\n11\r\n00:00:20,000 --> 00:00:24,060\r\nIt\'s not a halfway point, it\'s a lose-lose situation.\r\n\r\n12\r\n00:00:24,060 --> 00:00:26,080\r\nI\'m gonna give you a quick example of this,\r\n\r\n13\r\n00:00:26,080 --> 00:00:28,030\r\na story somebody told me on a training course,\r\n\r\n14\r\n00:00:28,030 --> 00:00:30,050\r\nI\'m sure it\'s true.\r\n\r\n15\r\n00:00:30,050 --> 00:00:32,020\r\nShe just bought this new car,\r\n\r\n16\r\n00:00:32,020 --> 00:00:34,020\r\nit\'s quite a cheap make of car.\r\n\r\n17\r\n00:00:34,020 --> 00:00:36,040\r\nBut it was new, it\'s the first ever new car she\'d had,\r\n\r\n18\r\n00:00:36,040 --> 00:00:37,060\r\nshe was really proud of it.\r\n\r\n19\r\n00:00:37,060 --> 00:00:39,090\r\nShe drove to the super-market in it.\r\n\r\n20\r\n00:00:39,090 --> 00:00:40,060\r\nAnd when she got there,\r\n\r\n21\r\n00:00:40,060 --> 00:00:43,070\r\nshe pulled up next to a Rolls-Royce,\r\n\r\n22\r\n00:00:43,070 --> 00:00:46,010\r\nand there was a very posh lady\r\n\r\n23\r\n00:00:46,010 --> 00:00:47,090\r\nwho was driving the Rolls-Royce,\r\n\r\n24\r\n00:00:47,090 --> 00:00:49,050\r\nand when the posh lady got out,\r\n\r\n25\r\n00:00:49,050 --> 00:00:52,080\r\nshe just slammed her door into the side of this new car,\r\n\r\n26\r\n00:00:52,080 --> 00:00:56,050\r\nand it put a big dent in the side of the car.\r\n\r\n27\r\n00:00:56,050 --> 00:00:59,040\r\nThose Rolls-Royce doors are really heavy.\r\n\r\n28\r\n00:00:59,040 --> 00:01:00,090\r\nThe Rolls-Royce lady didn\'t even notice,\r\n\r\n29\r\n00:01:00,090 --> 00:01:02,070\r\nshe just banged into the car, got out,\r\n\r\n30\r\n00:01:02,070 --> 00:01:04,090\r\nand she just walked her way to the super-market.\r\n\r\n31\r\n00:01:04,090 --> 00:01:06,060\r\nMeanwhile, the lady who\'d turned up\r\n\r\n32\r\n00:01:06,060 --> 00:01:08,030\r\nin her pride and joy new car,\r\n\r\n33\r\n00:01:08,030 --> 00:01:09,060\r\nwent running around to the side,\r\n\r\n34\r\n00:01:09,060 --> 00:01:11,070\r\nhad a look and saw the dent.\r\n\r\n35\r\n00:01:11,070 --> 00:01:15,010\r\nNow, what would you do if that happened to you?\r\n\r\n36\r\n00:01:15,010 --> 00:01:16,080\r\nReally, you\'ve got various options.\r\n\r\n37\r\n00:01:16,080 --> 00:01:18,020\r\nYou could be passive and just think,\r\n\r\n38\r\n00:01:18,020 --> 00:01:20,080\r\n\"Ugh, typical of my luck.\"\r\n\r\n39\r\n00:01:20,080 --> 00:01:23,020\r\nYou could be aggressive and go and shout at the woman,\r\n\r\n40\r\n00:01:23,020 --> 00:01:25,050\r\n\"You\'ve ruined my car!\"\r\n\r\n41\r\n00:01:25,050 --> 00:01:27,050\r\nOf course, the best option is to be assertive\r\n\r\n42\r\n00:01:27,050 --> 00:01:28,080\r\nand to go running after the lady and say,\r\n\r\n43\r\n00:01:28,080 --> 00:01:30,050\r\n\"Excuse me, you probably didn\'t notice,\r\n\r\n44\r\n00:01:30,050 --> 00:01:32,020\r\n\"you\'ve just dented my car,\r\n\r\n45\r\n00:01:32,020 --> 00:01:33,030\r\n\"would you be able to pay for it?\"\r\n\r\n46\r\n00:01:33,030 --> 00:01:34,090\r\nShe\'d probably be fine about paying for it,\r\n\r\n47\r\n00:01:34,090 --> 00:01:36,080\r\nso it\'d probably be fine.\r\n\r\n48\r\n00:01:36,080 --> 00:01:38,050\r\nBut the worst option, the fourth one,\r\n\r\n49\r\n00:01:38,050 --> 00:01:40,000\r\nis to be passive-aggressive.\r\n\r\n50\r\n00:01:40,000 --> 00:01:41,090\r\nAnd this is what the lady actually did.\r\n\r\n51\r\n00:01:41,090 --> 00:01:44,050\r\nShe got out her keys of her brand new car\r\n\r\n52\r\n00:01:44,050 --> 00:01:47,030\r\nand she went up and down the side of the Rolls-Royce,\r\n\r\n53\r\n00:01:47,030 --> 00:01:50,020\r\ngreat big scratch down the Rolls-Royce.\r\n\r\n54\r\n00:01:50,020 --> 00:01:52,040\r\nIf you think about it, that\'s just lose-lose,\r\n\r\n55\r\n00:01:52,040 --> 00:01:53,090\r\nit doesn\'t help anybody.\r\n\r\n56\r\n00:01:53,090 --> 00:01:55,080\r\nBecause her new car still got a dent,\r\n\r\n57\r\n00:01:55,080 --> 00:01:58,000\r\nnow the Rolls-Royce is scratched as well.\r\n\r\n58\r\n00:01:58,000 --> 00:02:00,030\r\nShe\'s being aggressive, not against the woman,\r\n\r\n59\r\n00:02:00,030 --> 00:02:01,080\r\nbut against her car,\r\n\r\n60\r\n00:02:01,080 --> 00:02:03,010\r\nand that doesn\'t solve anything.\r\n\r\n61\r\n00:02:03,010 --> 00:02:04,060\r\nShe\'s gonna come back to her car and think,\r\n\r\n62\r\n00:02:04,060 --> 00:02:06,050\r\n\"Ugh, look what someone\'s done.\"\r\n\r\n63\r\n00:02:06,050 --> 00:02:08,080\r\nShe\'s not even gonna know why.\r\n\r\n64\r\n00:02:08,080 --> 00:02:12,080\r\nPassive-aggressive is quite a tempting option,\r\n\r\n65\r\n00:02:12,080 --> 00:02:14,050\r\nbecause the chemicals are in our blood,\r\n\r\n66\r\n00:02:14,050 --> 00:02:15,090\r\nwe feel aggressive,\r\n\r\n67\r\n00:02:15,090 --> 00:02:17,050\r\nbut we\'re not actually assertive enough to actually\r\n\r\n68\r\n00:02:17,050 --> 00:02:21,020\r\nconfront the person, so we take it out against the car.\r\n\r\n69\r\n00:02:21,020 --> 00:02:24,000\r\nA common work example of passive-aggressive\r\n\r\n70\r\n00:02:24,000 --> 00:02:27,000\r\nwould be criticizing people behind their back.\r\n\r\n71\r\n00:02:27,000 --> 00:02:28,080\r\nYou\'re being aggressive about the person,\r\n\r\n72\r\n00:02:28,080 --> 00:02:30,060\r\nbut you\'re being passive in terms of,\r\n\r\n73\r\n00:02:30,060 --> 00:02:33,010\r\nyou\'re not actually confronting them.\r\n\r\n74\r\n00:02:33,010 --> 00:02:36,000\r\nSo, you might find it interesting just to think about,\r\n\r\n75\r\n00:02:36,000 --> 00:02:38,020\r\nhave you been passive-aggressive at all recently?\r\n\r\n76\r\n00:02:38,020 --> 00:02:40,000\r\nIs it a tendency that you have?\r\n\r\n77\r\n00:02:40,000 --> 00:02:42,060\r\nAnd what would the assertive option look like?\r\n\r\n78\r\n00:02:42,060 --> 00:02:45,060\r\nWhat would it look and feel like to calmly\r\n\r\n79\r\n00:02:45,060 --> 00:02:48,000\r\nconfront the person and tell them about\r\n\r\n80\r\n00:02:48,000 --> 00:02:51,000\r\nhow you feel, and what you would like to happen.\r\n\r\n"
                  },
                  new Video
                  {
                    Title = "Changing your inner dialogue",
                    Slug = "changing-your-inner-dialogue",
                    Duration = 206,
                    DownloadUrl = "https://dms.licdn.com/playlist/C4D0DAQG_GnbHkt896A/learning-original-video-iphone-360/0/1598507257910?e=1619539200&v=beta&t=sEMc_JUjSMYHX9-GNfYAJCh6-f4HVbtCG0AkeyRveik#.mp4",
                    TranscriptLines = null,
                    Transcript = "1\r\n00:00:00,070 --> 00:00:03,090\r\n- So can you change yourself?\r\n\r\n2\r\n00:00:03,090 --> 00:00:06,090\r\nUndoubtedly there\'s a small amount of you that\'s inherited,\r\n\r\n3\r\n00:00:06,090 --> 00:00:08,010\r\nbut I think you\'ll agree\r\n\r\n4\r\n00:00:08,010 --> 00:00:10,070\r\nthat things like a short temper or shyness\r\n\r\n5\r\n00:00:10,070 --> 00:00:12,040\r\nare learned behaviors\r\n\r\n6\r\n00:00:12,040 --> 00:00:16,030\r\nrather than inherited, unchangeable traits.\r\n\r\n7\r\n00:00:16,030 --> 00:00:18,080\r\nMost of your personality consists of learned habits\r\n\r\n8\r\n00:00:18,080 --> 00:00:21,020\r\nthat you\'ve built up during your life so far.\r\n\r\n9\r\n00:00:21,020 --> 00:00:23,090\r\nAnd these are known as life scripts.\r\n\r\n10\r\n00:00:23,090 --> 00:00:25,070\r\nExamples of life scripts could be:\r\n\r\n11\r\n00:00:25,070 --> 00:00:27,000\r\nI\'m impatient.\r\n\r\n12\r\n00:00:27,000 --> 00:00:28,020\r\nI\'m shy.\r\n\r\n13\r\n00:00:28,020 --> 00:00:30,000\r\nI hate giving talks.\r\n\r\n14\r\n00:00:30,000 --> 00:00:32,040\r\nI always think of the best thing to say afterwards\r\n\r\n15\r\n00:00:32,040 --> 00:00:34,020\r\nwhen it\'s too late.\r\n\r\n16\r\n00:00:34,020 --> 00:00:35,080\r\nThose are typical life scripts.\r\n\r\n17\r\n00:00:35,080 --> 00:00:37,070\r\nYou can have good scripts too.\r\n\r\n18\r\n00:00:37,070 --> 00:00:39,060\r\nLike I\'m good under pressure.\r\n\r\n19\r\n00:00:39,060 --> 00:00:41,000\r\nI love giving talks.\r\n\r\n20\r\n00:00:41,000 --> 00:00:43,000\r\nI like meeting new people.\r\n\r\n21\r\n00:00:43,000 --> 00:00:44,060\r\nAny statement that starts with,\r\n\r\n22\r\n00:00:44,060 --> 00:00:47,000\r\n\"I can\'t help,\" or \"I always seem to,\"\r\n\r\n23\r\n00:00:47,000 --> 00:00:49,090\r\nor \"I\'m hopeless at,\" or \"I\'m great at,\"\r\n\r\n24\r\n00:00:49,090 --> 00:00:52,020\r\nthese are all scripts.\r\n\r\n25\r\n00:00:52,020 --> 00:00:54,060\r\nAnd they can be changed.\r\n\r\n26\r\n00:00:54,060 --> 00:00:56,020\r\nScripts get stronger with time,\r\n\r\n27\r\n00:00:56,020 --> 00:00:59,030\r\nbecause beliefs lead to thoughts and behaviors,\r\n\r\n28\r\n00:00:59,030 --> 00:01:02,000\r\nwhich then lead to events happening.\r\n\r\n29\r\n00:01:02,000 --> 00:01:05,020\r\nAnd these strengthen your beliefs.\r\n\r\n30\r\n00:01:05,020 --> 00:01:06,030\r\nI know I\'m impatient.\r\n\r\n31\r\n00:01:06,030 --> 00:01:08,070\r\nI\'ve got 50 years of evidence of myself\r\n\r\n32\r\n00:01:08,070 --> 00:01:10,090\r\nstamping my feet in cues.\r\n\r\n33\r\n00:01:10,090 --> 00:01:13,060\r\nAnd my belief about myself leads to my behavior,\r\n\r\n34\r\n00:01:13,060 --> 00:01:17,070\r\nwhich gives me more and more evidence that that\'s how I am.\r\n\r\n35\r\n00:01:17,070 --> 00:01:20,000\r\nSo to change yourself means\r\n\r\n36\r\n00:01:20,000 --> 00:01:22,030\r\nchanging at the very least your behaviors,\r\n\r\n37\r\n00:01:22,030 --> 00:01:25,020\r\nbut ideally your underlying thoughts and beliefs\r\n\r\n38\r\n00:01:25,020 --> 00:01:26,060\r\nabout yourself too.\r\n\r\n39\r\n00:01:26,060 --> 00:01:27,080\r\nBut can this be done?\r\n\r\n40\r\n00:01:27,080 --> 00:01:29,040\r\nAnd the answer is yes.\r\n\r\n41\r\n00:01:29,040 --> 00:01:32,000\r\nAnd you can do it by changing your self talk.\r\n\r\n42\r\n00:01:32,000 --> 00:01:35,010\r\nThe words that you say in your head.\r\n\r\n43\r\n00:01:35,010 --> 00:01:37,020\r\nYour subconscious is listening to everything\r\n\r\n44\r\n00:01:37,020 --> 00:01:39,020\r\nthat you say to yourself.\r\n\r\n45\r\n00:01:39,020 --> 00:01:42,030\r\nBy the way, do you have a voice in your head?\r\n\r\n46\r\n00:01:42,030 --> 00:01:44,040\r\nOne voice in your head is good.\r\n\r\n47\r\n00:01:44,040 --> 00:01:45,070\r\nHopefully you haven\'t got two voices\r\n\r\n48\r\n00:01:45,070 --> 00:01:47,070\r\nthat are arguing with each other.\r\n\r\n49\r\n00:01:47,070 --> 00:01:50,040\r\nSo most people have one talking voice,\r\n\r\n50\r\n00:01:50,040 --> 00:01:53,040\r\nand this talking voice is your conscious mind.\r\n\r\n51\r\n00:01:53,040 --> 00:01:55,080\r\nAnd the silent listener that\'s also in your head\r\n\r\n52\r\n00:01:55,080 --> 00:01:58,050\r\nis your subconscious, which then acts\r\n\r\n53\r\n00:01:58,050 --> 00:01:59,090\r\non whatever you tell it.\r\n\r\n54\r\n00:01:59,090 --> 00:02:01,060\r\nIt\'s quite a scary thought.\r\n\r\n55\r\n00:02:01,060 --> 00:02:03,070\r\nSo if you say, \"When I give this presentation\r\n\r\n56\r\n00:02:03,070 --> 00:02:05,070\r\n\"it\'s going to go horribly wrong,\"\r\n\r\n57\r\n00:02:05,070 --> 00:02:09,010\r\nyour subconscious listens to that, it acts on that,\r\n\r\n58\r\n00:02:09,010 --> 00:02:12,070\r\nand it then makes the talk go horribly wrong.\r\n\r\n59\r\n00:02:12,070 --> 00:02:14,090\r\nSo if you can change your self talk\r\n\r\n60\r\n00:02:14,090 --> 00:02:17,000\r\nto only positive statements,\r\n\r\n61\r\n00:02:17,000 --> 00:02:19,060\r\nyour subconscious will hear these,\r\n\r\n62\r\n00:02:19,060 --> 00:02:21,090\r\nand gradually it will come to believe you,\r\n\r\n63\r\n00:02:21,090 --> 00:02:25,030\r\nuntil the new state has become true.\r\n\r\n64\r\n00:02:25,030 --> 00:02:27,080\r\nSo if you say, \"I love giving talks.\r\n\r\n65\r\n00:02:27,080 --> 00:02:28,080\r\n\"I\'m looking forward to the big\r\n\r\n66\r\n00:02:28,080 --> 00:02:30,050\r\n\"conference that\'s coming up,\"\r\n\r\n67\r\n00:02:30,050 --> 00:02:32,040\r\nat first it will feel very weird.\r\n\r\n68\r\n00:02:32,040 --> 00:02:34,050\r\nYou\'ll feel something called cognitive dissonance,\r\n\r\n69\r\n00:02:34,050 --> 00:02:37,000\r\nwhich is where you consciously say,\r\n\r\n70\r\n00:02:37,000 --> 00:02:38,020\r\n\"I\'m looking forward to the talk,\"\r\n\r\n71\r\n00:02:38,020 --> 00:02:40,080\r\nand your subconscious says, \"What?\r\n\r\n72\r\n00:02:40,080 --> 00:02:41,090\r\n\"He\'s never said this before.\r\n\r\n73\r\n00:02:41,090 --> 00:02:43,020\r\n\"This can\'t be true.\"\r\n\r\n74\r\n00:02:43,020 --> 00:02:45,030\r\nBut after awhile, you start to accept it.\r\n\r\n75\r\n00:02:45,030 --> 00:02:47,030\r\nYour subconscious starts to think that...\r\n\r\n76\r\n00:02:47,030 --> 00:02:48,090\r\nThat something\'s changed somewhere,\r\n\r\n77\r\n00:02:48,090 --> 00:02:50,040\r\nand maybe you are actually looking forward\r\n\r\n78\r\n00:02:50,040 --> 00:02:51,090\r\nto giving the talk.\r\n\r\n79\r\n00:02:51,090 --> 00:02:55,050\r\nAnd the battleship of 50 years of experience and evidence\r\n\r\n80\r\n00:02:55,050 --> 00:02:57,090\r\nis starting to be slowly turned.\r\n\r\n81\r\n00:02:57,090 --> 00:02:59,050\r\nAnd you just keep pushing and pushing\r\n\r\n82\r\n00:02:59,050 --> 00:03:00,060\r\na little bit every day.\r\n\r\n83\r\n00:03:00,060 --> 00:03:02,060\r\nPositive statements every day.\r\n\r\n84\r\n00:03:02,060 --> 00:03:04,000\r\nAnd you can change anything\r\n\r\n85\r\n00:03:04,000 --> 00:03:06,000\r\nyou want to change about yourself.\r\n\r\n86\r\n00:03:06,000 --> 00:03:08,020\r\nAnd it only takes about a month.\r\n\r\n87\r\n00:03:08,020 --> 00:03:10,020\r\nWhich is amazing, isn\'t it?\r\n\r\n88\r\n00:03:10,020 --> 00:03:12,060\r\nSo, what\'s your pet negative script\r\n\r\n89\r\n00:03:12,060 --> 00:03:14,060\r\nthat you\'d like to change?\r\n\r\n90\r\n00:03:14,060 --> 00:03:16,080\r\nWhat aspect of your personality and behavior\r\n\r\n91\r\n00:03:16,080 --> 00:03:19,040\r\nwould you like to change?\r\n\r\n92\r\n00:03:19,040 --> 00:03:21,020\r\nDesign a new script today\r\n\r\n93\r\n00:03:21,020 --> 00:03:23,040\r\nand start repeating it every day\r\n\r\n94\r\n00:03:23,040 --> 00:03:26,000\r\nuntil it becomes the new you.\r\n\r\n"
                  },
                  new Video
                  {
                    Title = "Reducing your negative emotions",
                    Slug = "reducing-your-negative-emotions",
                    Duration = 315,
                    DownloadUrl = "https://dms.licdn.com/playlist/C4D0DAQF3XfD6wf3SYw/learning-original-video-iphone-360/0/1598507156967?e=1619539200&v=beta&t=ZQyGh6eMzKyllHPa3d345Blys6R8PgS0pjuzHyCz9Ao#.mp4",
                    TranscriptLines = null,
                    Transcript = "1\r\n00:00:00,080 --> 00:00:02,080\r\n- I want to talk to you about negative emotions.\r\n\r\n2\r\n00:00:02,080 --> 00:00:07,000\r\nWould you like to get rid of all of your negative emotions?\r\n\r\n3\r\n00:00:07,000 --> 00:00:11,010\r\nGet rid of worry, fear, anger, hate,\r\n\r\n4\r\n00:00:11,010 --> 00:00:15,080\r\njealousy, regret, blame, impatience,\r\n\r\n5\r\n00:00:15,080 --> 00:00:18,060\r\nembarrassment, guilt.\r\n\r\n6\r\n00:00:18,060 --> 00:00:20,050\r\nYes, of course you would.\r\n\r\n7\r\n00:00:20,050 --> 00:00:22,050\r\nAlthough some people have a couple of\r\n\r\n8\r\n00:00:22,050 --> 00:00:24,040\r\npet negative emotions they want to cling to,\r\n\r\n9\r\n00:00:24,040 --> 00:00:25,060\r\nI\'ll let you keep a couple of your\r\n\r\n10\r\n00:00:25,060 --> 00:00:27,020\r\nfavorite ones if you\'d like.\r\n\r\n11\r\n00:00:27,020 --> 00:00:30,000\r\nAlthough really, why would you?\r\n\r\n12\r\n00:00:30,000 --> 00:00:32,040\r\nTo get rid of any negative emotion,\r\n\r\n13\r\n00:00:32,040 --> 00:00:35,050\r\nthe first step is taking responsibility.\r\n\r\n14\r\n00:00:35,050 --> 00:00:37,050\r\nRealizing that you are responsible for\r\n\r\n15\r\n00:00:37,050 --> 00:00:39,090\r\nmost situations that you find yourself in,\r\n\r\n16\r\n00:00:39,090 --> 00:00:42,010\r\nand you are always responsible for\r\n\r\n17\r\n00:00:42,010 --> 00:00:45,000\r\nhow you handle that situation.\r\n\r\n18\r\n00:00:45,000 --> 00:00:47,040\r\nOften, the things that make us most angry\r\n\r\n19\r\n00:00:47,040 --> 00:00:50,070\r\nare things that we know are our fault, really.\r\n\r\n20\r\n00:00:50,070 --> 00:00:53,020\r\nWe\'ll take another negative emotion, worry.\r\n\r\n21\r\n00:00:53,020 --> 00:00:55,070\r\nOnce we realize that we need to take responsibility\r\n\r\n22\r\n00:00:55,070 --> 00:00:58,040\r\nfor the outcome rather than just worrying about it,\r\n\r\n23\r\n00:00:58,040 --> 00:01:01,040\r\nwe can start to plan and work on getting it right,\r\n\r\n24\r\n00:01:01,040 --> 00:01:04,000\r\nand the worry is reduced.\r\n\r\n25\r\n00:01:04,000 --> 00:01:06,060\r\nI think it\'s amazing that responsibility is involved in\r\n\r\n26\r\n00:01:06,060 --> 00:01:09,050\r\npretty much every negative emotion, when you think about it.\r\n\r\n27\r\n00:01:09,050 --> 00:01:13,090\r\nJealousy, blame, regret, guilt.\r\n\r\n28\r\n00:01:13,090 --> 00:01:14,080\r\nBut the more I think about it,\r\n\r\n29\r\n00:01:14,080 --> 00:01:17,040\r\nthe more convinced I am that this is true.\r\n\r\n30\r\n00:01:17,040 --> 00:01:19,060\r\nI suppose you could say that you\'re responsible\r\n\r\n31\r\n00:01:19,060 --> 00:01:24,000\r\neven for whether you choose that negative emotion at all.\r\n\r\n32\r\n00:01:24,000 --> 00:01:27,090\r\nAre you aware that you are choosing negative emotions?\r\n\r\n33\r\n00:01:27,090 --> 00:01:29,030\r\nIt may feel that they automatically\r\n\r\n34\r\n00:01:29,030 --> 00:01:31,030\r\nspring up from within you.\r\n\r\n35\r\n00:01:31,030 --> 00:01:32,030\r\nBut think about it,\r\n\r\n36\r\n00:01:32,030 --> 00:01:34,080\r\nmaybe you\'re responsible for choosing them.\r\n\r\n37\r\n00:01:34,080 --> 00:01:37,050\r\nDid you choose to get angry?\r\n\r\n38\r\n00:01:37,050 --> 00:01:38,080\r\nOr, to put it another way,\r\n\r\n39\r\n00:01:38,080 --> 00:01:40,090\r\ncould you choose to not get angry?\r\n\r\n40\r\n00:01:40,090 --> 00:01:43,010\r\nI think you could.\r\n\r\n41\r\n00:01:43,010 --> 00:01:45,030\r\nSo, why would someone choose\r\n\r\n42\r\n00:01:45,030 --> 00:01:49,000\r\na negative emotion like anger or guilt?\r\n\r\n43\r\n00:01:49,000 --> 00:01:52,000\r\nWell, we\'re choosing them due to false payoffs.\r\n\r\n44\r\n00:01:52,000 --> 00:01:53,040\r\nWe believe we\'re gonna get a payoff,\r\n\r\n45\r\n00:01:53,040 --> 00:01:56,050\r\nwhich we actually don\'t really get.\r\n\r\n46\r\n00:01:56,050 --> 00:01:57,080\r\nLet\'s look at both anger and guilt\r\n\r\n47\r\n00:01:57,080 --> 00:01:59,090\r\nand look at the false payoffs.\r\n\r\n48\r\n00:01:59,090 --> 00:02:01,000\r\nWhat would be the payoff that you\r\n\r\n49\r\n00:02:01,000 --> 00:02:04,000\r\nmight get from becoming angry?\r\n\r\n50\r\n00:02:04,000 --> 00:02:05,030\r\nWell, I think there are two payoffs\r\n\r\n51\r\n00:02:05,030 --> 00:02:06,010\r\nwe think we\'re gonna get.\r\n\r\n52\r\n00:02:06,010 --> 00:02:08,080\r\nOne is that it will make us stronger.\r\n\r\n53\r\n00:02:08,080 --> 00:02:12,000\r\nBut actually, does it make you stronger if you get angry?\r\n\r\n54\r\n00:02:12,000 --> 00:02:13,000\r\nAre you most likely to get\r\n\r\n55\r\n00:02:13,000 --> 00:02:15,000\r\nwhat you want by getting angry?\r\n\r\n56\r\n00:02:15,000 --> 00:02:17,020\r\nAnd I would say, probably not.\r\n\r\n57\r\n00:02:17,020 --> 00:02:19,010\r\nThe other payoff is a feeling\r\n\r\n58\r\n00:02:19,010 --> 00:02:20,060\r\nthat we might be able to let off steam\r\n\r\n59\r\n00:02:20,060 --> 00:02:22,090\r\nand feel better afterwards.\r\n\r\n60\r\n00:02:22,090 --> 00:02:24,020\r\nBut actually, do you feel better\r\n\r\n61\r\n00:02:24,020 --> 00:02:26,010\r\nafter you\'ve got angry?\r\n\r\n62\r\n00:02:26,010 --> 00:02:27,080\r\nProbably not.\r\n\r\n63\r\n00:02:27,080 --> 00:02:29,050\r\nOnce you realize that actually,\r\n\r\n64\r\n00:02:29,050 --> 00:02:32,010\r\nanger doesn\'t make you stronger,\r\n\r\n65\r\n00:02:32,010 --> 00:02:33,090\r\nand it doesn\'t give you a feeling\r\n\r\n66\r\n00:02:33,090 --> 00:02:35,060\r\nof letting off steam and feeling better afterwards,\r\n\r\n67\r\n00:02:35,060 --> 00:02:38,090\r\nyou can then decide to not choose anger.\r\n\r\n68\r\n00:02:38,090 --> 00:02:41,040\r\nMoving on to guilt, the second one,\r\n\r\n69\r\n00:02:41,040 --> 00:02:42,080\r\nwhat are the payoffs we might think\r\n\r\n70\r\n00:02:42,080 --> 00:02:44,020\r\nthat we\'re gonna get from guilt?\r\n\r\n71\r\n00:02:44,020 --> 00:02:46,000\r\nI think, again, there are two main ones.\r\n\r\n72\r\n00:02:46,000 --> 00:02:47,090\r\nOne is that maybe feeling guilty\r\n\r\n73\r\n00:02:47,090 --> 00:02:50,040\r\nabout something you\'ve done makes you feel\r\n\r\n74\r\n00:02:50,040 --> 00:02:52,010\r\nthat you\'re an okay person, really.\r\n\r\n75\r\n00:02:52,010 --> 00:02:53,080\r\nEven though you did a bad thing,\r\n\r\n76\r\n00:02:53,080 --> 00:02:55,030\r\nat least you\'re a good person.\r\n\r\n77\r\n00:02:55,030 --> 00:02:56,040\r\nBut on the other hand,\r\n\r\n78\r\n00:02:56,040 --> 00:02:59,030\r\ndoes guilt make you an okay person\r\n\r\n79\r\n00:02:59,030 --> 00:03:00,020\r\nafter you\'ve done a bad thing?\r\n\r\n80\r\n00:03:00,020 --> 00:03:01,030\r\nAnd I would say, \"No, it doesn\'t.\"\r\n\r\n81\r\n00:03:01,030 --> 00:03:03,040\r\nYou did the bad thing.\r\n\r\n82\r\n00:03:03,040 --> 00:03:05,090\r\nThe other payoff that you might think you get from guilt,\r\n\r\n83\r\n00:03:05,090 --> 00:03:09,090\r\nis that it makes less likely to do the bad thing again.\r\n\r\n84\r\n00:03:09,090 --> 00:03:12,020\r\nBut again, do you get that payoff?\r\n\r\n85\r\n00:03:12,020 --> 00:03:13,070\r\nAnd I would say, probably not.\r\n\r\n86\r\n00:03:13,070 --> 00:03:15,030\r\nI think guilt almost gives you permission\r\n\r\n87\r\n00:03:15,030 --> 00:03:16,090\r\nto keep doing the bad thing,\r\n\r\n88\r\n00:03:16,090 --> 00:03:19,020\r\nat least you feel guilty every time you do it.\r\n\r\n89\r\n00:03:19,020 --> 00:03:21,020\r\nSo, I think guilt is actually gonna make you\r\n\r\n90\r\n00:03:21,020 --> 00:03:24,060\r\nmore likely to keep doing that bad thing.\r\n\r\n91\r\n00:03:24,060 --> 00:03:27,040\r\nOnce you realize that you\'re choosing these emotions,\r\n\r\n92\r\n00:03:27,040 --> 00:03:29,000\r\nand that the payoffs that you think you\'re\r\n\r\n93\r\n00:03:29,000 --> 00:03:31,050\r\ngonna get are actually false,\r\n\r\n94\r\n00:03:31,050 --> 00:03:36,060\r\nyou can then begin to choose to not have them.\r\n\r\n95\r\n00:03:36,060 --> 00:03:40,010\r\nWhat would a life of no guilt be like?\r\n\r\n96\r\n00:03:40,010 --> 00:03:42,080\r\nWould it possible to get rid of guilt?\r\n\r\n97\r\n00:03:42,080 --> 00:03:44,010\r\nWhen you start thinking about this,\r\n\r\n98\r\n00:03:44,010 --> 00:03:46,040\r\nthere are two main ways that you could\r\n\r\n99\r\n00:03:46,040 --> 00:03:48,020\r\nlive a life free from guilt.\r\n\r\n100\r\n00:03:48,020 --> 00:03:50,020\r\nOne would be, to be a complete angel.\r\n\r\n101\r\n00:03:50,020 --> 00:03:52,020\r\nTo be perfect, never do a bad thing.\r\n\r\n102\r\n00:03:52,020 --> 00:03:54,040\r\nI think that would be impossible,\r\n\r\n103\r\n00:03:54,040 --> 00:03:56,040\r\nAt least it would for me.\r\n\r\n104\r\n00:03:56,040 --> 00:03:58,050\r\nThe other option would be to be a complete devil.\r\n\r\n105\r\n00:03:58,050 --> 00:04:01,040\r\nDo bad things all the time, and not care.\r\n\r\n106\r\n00:04:01,040 --> 00:04:02,020\r\nI think we all agree,\r\n\r\n107\r\n00:04:02,020 --> 00:04:05,040\r\nthat would be an unacceptable option.\r\n\r\n108\r\n00:04:05,040 --> 00:04:08,030\r\nBut of course, what about a mixture of these two things.\r\n\r\n109\r\n00:04:08,030 --> 00:04:10,070\r\nIf you could be a mixture of the angel option\r\n\r\n110\r\n00:04:10,070 --> 00:04:12,000\r\nand the devil option,\r\n\r\n111\r\n00:04:12,000 --> 00:04:15,020\r\nthat would be possible to do, that would work.\r\n\r\n112\r\n00:04:15,020 --> 00:04:17,080\r\nFor example, when my neighbor\'s cat comes\r\n\r\n113\r\n00:04:17,080 --> 00:04:19,090\r\nthrough into my garden, trying to eat my goldfish\r\n\r\n114\r\n00:04:19,090 --> 00:04:21,040\r\nthat I\'ve got in my pond,\r\n\r\n115\r\n00:04:21,040 --> 00:04:24,060\r\nI could squirt the cat with my garden hose.\r\n\r\n116\r\n00:04:24,060 --> 00:04:26,020\r\nBut if I did, I\'d feel bad about that,\r\n\r\n117\r\n00:04:26,020 --> 00:04:27,040\r\nI\'d feel guilty about that.\r\n\r\n118\r\n00:04:27,040 --> 00:04:29,080\r\nSo, I\'m gonna choose the angel option for that,\r\n\r\n119\r\n00:04:29,080 --> 00:04:31,050\r\nand I\'m gonna not do it.\r\n\r\n120\r\n00:04:31,050 --> 00:04:34,000\r\nWhen it comes to eating a second doughnut,\r\n\r\n121\r\n00:04:34,000 --> 00:04:35,060\r\nI think I\'m gonna go for the devil option\r\n\r\n122\r\n00:04:35,060 --> 00:04:37,040\r\nand just do that.\r\n\r\n123\r\n00:04:37,040 --> 00:04:39,040\r\nIf I have a mixture of the angel choice\r\n\r\n124\r\n00:04:39,040 --> 00:04:41,020\r\nand the devil choice in my life,\r\n\r\n125\r\n00:04:41,020 --> 00:04:44,010\r\nI can live a life free from guilt.\r\n\r\n126\r\n00:04:44,010 --> 00:04:45,080\r\nThe answer to get rid of guilt is actually\r\n\r\n127\r\n00:04:45,080 --> 00:04:48,090\r\nto change what you do, which is the angel option.\r\n\r\n128\r\n00:04:48,090 --> 00:04:51,050\r\nOr, change what you say to yourself,\r\n\r\n129\r\n00:04:51,050 --> 00:04:53,050\r\nwhich is the devil option,\r\n\r\n130\r\n00:04:53,050 --> 00:04:55,070\r\nand banish guilt forever.\r\n\r\n131\r\n00:04:55,070 --> 00:04:58,040\r\nIt\'s the same for all other negative emotions.\r\n\r\n132\r\n00:04:58,040 --> 00:05:01,080\r\nI want you to think about, what\'s your pet one?\r\n\r\n133\r\n00:05:01,080 --> 00:05:04,090\r\nWhat\'s the payoff that you think you\'re getting from it?\r\n\r\n134\r\n00:05:04,090 --> 00:05:06,070\r\nAnd is that payoff forced?\r\n\r\n135\r\n00:05:06,070 --> 00:05:09,000\r\nWhich, of course, it is.\r\n\r\n136\r\n00:05:09,000 --> 00:05:11,000\r\nAnd then, decide not to have that\r\n\r\n137\r\n00:05:11,000 --> 00:05:15,000\r\nnegative emotion in your life anymore.\r\n\r\n"
                  }
                }
              },
              new Chapter
              {
                Title = "2. Responding to Challenges",
                Videos = new List<Video>
                {
                  new Video
                  {
                    Title = "Handling everyday put-downs",
                    Slug = "handling-everyday-put-downs",
                    Duration = 140,
                    DownloadUrl = "https://dms.licdn.com/playlist/C4D0DAQEgw6KNEpsl5Q/learning-original-video-iphone-360/0/1598507236138?e=1619539200&v=beta&t=AMOnwVYM5lY8xfWcpI7lKO1WVMIPCBRDL5PisVrgTj8#.mp4",
                    TranscriptLines = null,
                    Transcript = "1\r\n00:00:00,080 --> 00:00:01,070\r\n- Now, I wanted to say a little bit\r\n\r\n2\r\n00:00:01,070 --> 00:00:05,080\r\nabout handling everyday put-downs.\r\n\r\n3\r\n00:00:05,080 --> 00:00:07,010\r\nWhen someone puts you down verbally,\r\n\r\n4\r\n00:00:07,010 --> 00:00:09,010\r\nit\'s really a form of aggression.\r\n\r\n5\r\n00:00:09,010 --> 00:00:10,050\r\nMost aggression these days is actually\r\n\r\n6\r\n00:00:10,050 --> 00:00:12,050\r\nnot physical, it\'s verbal.\r\n\r\n7\r\n00:00:12,050 --> 00:00:13,040\r\nAnd as we\'ve seen,\r\n\r\n8\r\n00:00:13,040 --> 00:00:15,090\r\nthe temptation is to be aggressive back,\r\n\r\n9\r\n00:00:15,090 --> 00:00:18,080\r\nor to be submissive and let them get away with it.\r\n\r\n10\r\n00:00:18,080 --> 00:00:22,020\r\nBut to confront them assertively would be the best option.\r\n\r\n11\r\n00:00:22,020 --> 00:00:26,000\r\nThe one that\'s most likely to give you a successful outcome.\r\n\r\n12\r\n00:00:26,000 --> 00:00:28,000\r\nSome examples of common put-downs at work\r\n\r\n13\r\n00:00:28,000 --> 00:00:29,020\r\nwould be things like,\r\n\r\n14\r\n00:00:29,020 --> 00:00:32,030\r\nstereotyping you, patronizing you,\r\n\r\n15\r\n00:00:32,030 --> 00:00:34,010\r\ninterfering with your work,\r\n\r\n16\r\n00:00:34,010 --> 00:00:36,020\r\nignoring things that you\'ve said,\r\n\r\n17\r\n00:00:36,020 --> 00:00:37,070\r\nimplying that you have a fault\r\n\r\n18\r\n00:00:37,070 --> 00:00:38,090\r\nor are under-performing,\r\n\r\n19\r\n00:00:38,090 --> 00:00:41,090\r\nwithout actually coming out and saying it.\r\n\r\n20\r\n00:00:41,090 --> 00:00:44,000\r\nAnd using emotive words like \"stupid\",\r\n\r\n21\r\n00:00:44,000 --> 00:00:47,000\r\nor \"useless\", or \"that was a crazy decision\".\r\n\r\n22\r\n00:00:47,000 --> 00:00:50,050\r\nThese are all types of everyday put-downs.\r\n\r\n23\r\n00:00:50,050 --> 00:00:52,010\r\nThe approach to take with these types\r\n\r\n24\r\n00:00:52,010 --> 00:00:55,060\r\nof verbal aggression is, number one,\r\n\r\n25\r\n00:00:55,060 --> 00:00:59,000\r\nto realize that it is aggression.\r\n\r\n26\r\n00:00:59,000 --> 00:01:00,080\r\nNumber two, to realize that they may not\r\n\r\n27\r\n00:01:00,080 --> 00:01:03,040\r\nbe a bad person, maybe they don\'t realize\r\n\r\n28\r\n00:01:03,040 --> 00:01:05,020\r\nthat they have an effectively\r\n\r\n29\r\n00:01:05,020 --> 00:01:07,070\r\nanti-social habit, like interrupting.\r\n\r\n30\r\n00:01:07,070 --> 00:01:10,030\r\nOr maybe they\'re having a bad day.\r\n\r\n31\r\n00:01:10,030 --> 00:01:12,000\r\nBut then number three, to decide that you\'re not\r\n\r\n32\r\n00:01:12,000 --> 00:01:13,090\r\ngoing to be submissive and taken.\r\n\r\n33\r\n00:01:13,090 --> 00:01:17,000\r\nBut you\'re also not going to bite back aggressively.\r\n\r\n34\r\n00:01:17,000 --> 00:01:19,080\r\nNumber four, then, is to remain calm,\r\n\r\n35\r\n00:01:19,080 --> 00:01:22,050\r\nand speak calmly to them.\r\n\r\n36\r\n00:01:22,050 --> 00:01:23,090\r\nEven if you decide to tell someone\r\n\r\n37\r\n00:01:23,090 --> 00:01:26,060\r\nthat you\'re very upset by what they\'ve just said,\r\n\r\n38\r\n00:01:26,060 --> 00:01:28,050\r\ndo it calmly.\r\n\r\n39\r\n00:01:28,050 --> 00:01:31,060\r\nNumber five is to tell them how you feel,\r\n\r\n40\r\n00:01:31,060 --> 00:01:35,000\r\nand what you would like them to do differently next time.\r\n\r\n41\r\n00:01:35,000 --> 00:01:36,090\r\nI\'ll cover the exact words for how to do this\r\n\r\n42\r\n00:01:36,090 --> 00:01:39,080\r\nin a later video on this course.\r\n\r\n43\r\n00:01:39,080 --> 00:01:41,030\r\nIt feels good to remain calm,\r\n\r\n44\r\n00:01:41,030 --> 00:01:43,020\r\nand it feels good to be nice.\r\n\r\n45\r\n00:01:43,020 --> 00:01:44,000\r\nDo you find that?\r\n\r\n46\r\n00:01:44,000 --> 00:01:45,070\r\nBeing nice to someone horrible\r\n\r\n47\r\n00:01:45,070 --> 00:01:47,040\r\ngives you a great feeling of control,\r\n\r\n48\r\n00:01:47,040 --> 00:01:50,010\r\nand they usually apologize to you later.\r\n\r\n49\r\n00:01:50,010 --> 00:01:51,070\r\nSo, I\'d like you to ask yourself\r\n\r\n50\r\n00:01:51,070 --> 00:01:53,060\r\nwhat types of put-down you sometimes,\r\n\r\n51\r\n00:01:53,060 --> 00:01:55,080\r\nor often experience at work.\r\n\r\n52\r\n00:01:55,080 --> 00:01:57,090\r\nAnd then plan your answer.\r\n\r\n53\r\n00:01:57,090 --> 00:02:00,020\r\nImagine yourself calmly telling them that,\r\n\r\n54\r\n00:02:00,020 --> 00:02:02,090\r\nfor example, you don\'t like being interrupted,\r\n\r\n55\r\n00:02:02,090 --> 00:02:05,010\r\nand you\'d like to just finish your statement.\r\n\r\n56\r\n00:02:05,010 --> 00:02:06,070\r\nOr maybe, when they say,\r\n\r\n57\r\n00:02:06,070 --> 00:02:08,050\r\n\"That\'s typical of a technician!\"\r\n\r\n58\r\n00:02:08,050 --> 00:02:10,020\r\nThat you\'d like to be given the chance to show\r\n\r\n59\r\n00:02:10,020 --> 00:02:13,030\r\nthat your plan is a good one.\r\n\r\n60\r\n00:02:13,030 --> 00:02:15,080\r\nPlan how you\'re going to tell them how you feel,\r\n\r\n61\r\n00:02:15,080 --> 00:02:18,040\r\nand what you want them to do differently in future,\r\n\r\n62\r\n00:02:18,040 --> 00:02:20,000\r\nwhen they deal with you.\r\n\r\n"
                  },
                  new Video
                  {
                    Title = "Fogging",
                    Slug = "fogging",
                    Duration = 80,
                    DownloadUrl = "https://dms.licdn.com/playlist/C4E0DAQFgGQ36OJeUYA/learning-original-video-iphone-360/0/1598507119389?e=1619539200&v=beta&t=BIKyQCrr8VTIo3or4I0L0kyWDTz2uy5tDfdbb-qnCcs#.mp4",
                    TranscriptLines = null,
                    Transcript = "1\r\n00:00:00,060 --> 00:00:01,070\r\n- Now I want to tell you about a really\r\n\r\n2\r\n00:00:01,070 --> 00:00:04,090\r\nuseful technique called fogging.\r\n\r\n3\r\n00:00:04,090 --> 00:00:08,000\r\nIf you\'re suddenly and fiercely verbally attacked,\r\n\r\n4\r\n00:00:08,000 --> 00:00:10,020\r\nmaybe somebody comes charging into your office going,\r\n\r\n5\r\n00:00:10,020 --> 00:00:11,030\r\n\"I can\'t believe you\'ve done this!\"\r\n\r\n6\r\n00:00:11,030 --> 00:00:13,020\r\nor \"You\'re useless!\" or whatever,\r\n\r\n7\r\n00:00:13,020 --> 00:00:16,000\r\nyou can buy time with fogging,\r\n\r\n8\r\n00:00:16,000 --> 00:00:19,070\r\nand this is a technique where you concede only partially.\r\n\r\n9\r\n00:00:19,070 --> 00:00:21,080\r\nYou might say something like, \"I accept that\r\n\r\n10\r\n00:00:21,080 --> 00:00:23,060\r\n\"I could probably improve in that area,\"\r\n\r\n11\r\n00:00:23,060 --> 00:00:26,040\r\nor, \"Yes, the meeting probably could\'ve been better,\"\r\n\r\n12\r\n00:00:26,040 --> 00:00:30,000\r\nor, \"Well, there\'s always room for improvement, I guess.\"\r\n\r\n13\r\n00:00:30,000 --> 00:00:31,090\r\nThe great thing about fogging is that\r\n\r\n14\r\n00:00:31,090 --> 00:00:34,070\r\nthey no longer have a target to attack.\r\n\r\n15\r\n00:00:34,070 --> 00:00:36,090\r\nYou\'ve accepted that they might be right,\r\n\r\n16\r\n00:00:36,090 --> 00:00:40,020\r\nbut without accepting that you\'re wrong.\r\n\r\n17\r\n00:00:40,020 --> 00:00:42,010\r\nIf you refuse to admit any fault,\r\n\r\n18\r\n00:00:42,010 --> 00:00:44,040\r\nthey will continue to attack you.\r\n\r\n19\r\n00:00:44,040 --> 00:00:46,020\r\nAnd if you concede completely,\r\n\r\n20\r\n00:00:46,020 --> 00:00:49,010\r\nthen they\'ve got away with a potentially unfair accusation.\r\n\r\n21\r\n00:00:49,010 --> 00:00:51,040\r\nBut if you partially concede,\r\n\r\n22\r\n00:00:51,040 --> 00:00:53,080\r\nthen they\'ve got nothing left to attack.\r\n\r\n23\r\n00:00:53,080 --> 00:00:56,030\r\nNow fogging isn\'t a complete solution, but it\'s great\r\n\r\n24\r\n00:00:56,030 --> 00:00:59,050\r\nfor diffusing a sudden attack from somebody, and it gives\r\n\r\n25\r\n00:00:59,050 --> 00:01:03,020\r\nyou a bit of time to prepare your counter-attack.\r\n\r\n26\r\n00:01:03,020 --> 00:01:05,020\r\nCan you think of a recent example of when\r\n\r\n27\r\n00:01:05,020 --> 00:01:09,000\r\nyou\'ve been taken by surprise by a sudden verbal attack\r\n\r\n28\r\n00:01:09,000 --> 00:01:12,010\r\nand what a good fogging phrase would have been?\r\n\r\n29\r\n00:01:12,010 --> 00:01:14,090\r\nHave this one ready for next time.\r\n\r\n30\r\n00:01:14,090 --> 00:01:16,070\r\nFogging\'s the first of a number of techniques\r\n\r\n31\r\n00:01:16,070 --> 00:01:20,000\r\nthat I\'m now going to cover in the next few videos.\r\n\r\n"
                  },
                  new Video
                  {
                    Title = "Viewing the interaction with detachment",
                    Slug = "viewing-the-interaction-with-detachment",
                    Duration = 156,
                    DownloadUrl = "https://dms.licdn.com/playlist/C4E0DAQE9J6G4X7diAA/learning-original-video-iphone-360/0/1598550635197?e=1619539200&v=beta&t=wytnzhMw5YPZB82KbI8n2dX4hDjZx0RA38rby-17gfQ#.mp4",
                    TranscriptLines = null,
                    Transcript = "1\r\n00:00:00,070 --> 00:00:04,030\r\n- A very useful assertiveness technique is detachment.\r\n\r\n2\r\n00:00:04,030 --> 00:00:06,030\r\nBetween the stimulus and the response,\r\n\r\n3\r\n00:00:06,030 --> 00:00:09,020\r\nthere\'s a tiny moment when you can decide\r\n\r\n4\r\n00:00:09,020 --> 00:00:11,050\r\nhow you will react.\r\n\r\n5\r\n00:00:11,050 --> 00:00:13,000\r\nYou\'ve already seen how you can do this\r\n\r\n6\r\n00:00:13,000 --> 00:00:16,030\r\nwith negative emotions and choose not to have them.\r\n\r\n7\r\n00:00:16,030 --> 00:00:19,050\r\nBut you can also take control of what you say and do,\r\n\r\n8\r\n00:00:19,050 --> 00:00:21,060\r\nwhen dealing with someone aggressive.\r\n\r\n9\r\n00:00:21,060 --> 00:00:26,000\r\nFirst, ask yourself if it\'s their problem or yours.\r\n\r\n10\r\n00:00:26,000 --> 00:00:27,020\r\nMaybe what they\'re doing is fine,\r\n\r\n11\r\n00:00:27,020 --> 00:00:29,040\r\nand it\'s you that has the problem with it.\r\n\r\n12\r\n00:00:29,040 --> 00:00:32,010\r\nFor example, people playing music next door.\r\n\r\n13\r\n00:00:32,010 --> 00:00:34,010\r\nMaybe it\'s not that late in the evening,\r\n\r\n14\r\n00:00:34,010 --> 00:00:35,060\r\nand they\'re entitled to some fun.\r\n\r\n15\r\n00:00:35,060 --> 00:00:38,000\r\nDoes it matter that much?\r\n\r\n16\r\n00:00:38,000 --> 00:00:40,010\r\nThe person who\'s irritating you immensely\r\n\r\n17\r\n00:00:40,010 --> 00:00:43,060\r\nin the meeting by checking his messages on his phone.\r\n\r\n18\r\n00:00:43,060 --> 00:00:45,010\r\nIs it affecting you?\r\n\r\n19\r\n00:00:45,010 --> 00:00:46,030\r\nIs it such a big deal?\r\n\r\n20\r\n00:00:46,030 --> 00:00:48,020\r\nIs it a battle worth fighting?\r\n\r\n21\r\n00:00:48,020 --> 00:00:50,060\r\nMaybe the problem\'s in your head.\r\n\r\n22\r\n00:00:50,060 --> 00:00:53,000\r\nThis is the first detachment question.\r\n\r\n23\r\n00:00:53,000 --> 00:00:55,060\r\nIs it worth getting involved?\r\n\r\n24\r\n00:00:55,060 --> 00:00:56,050\r\nOne more example of this,\r\n\r\n25\r\n00:00:56,050 --> 00:00:58,060\r\nmy next-door neighbor used to drop in,\r\n\r\n26\r\n00:00:58,060 --> 00:01:01,040\r\nand he would criticize aspects of my house.\r\n\r\n27\r\n00:01:01,040 --> 00:01:01,090\r\nHe would say,\r\n\r\n28\r\n00:01:01,090 --> 00:01:03,070\r\n\"Oh, I see you\'ve got your new windows, Chris.\r\n\r\n29\r\n00:01:03,070 --> 00:01:04,060\r\n\"What did you go for?\r\n\r\n30\r\n00:01:04,060 --> 00:01:06,090\r\n\"Oh, you went for the plastic ones.\r\n\r\n31\r\n00:01:06,090 --> 00:01:07,090\r\n\"I wouldn\'t have done that,\r\n\r\n32\r\n00:01:07,090 --> 00:01:10,020\r\n\"but still, it\'s up to you.\"\r\n\r\n33\r\n00:01:10,020 --> 00:01:11,090\r\nIt used to be really annoying.\r\n\r\n34\r\n00:01:11,090 --> 00:01:15,000\r\nBut then, his behavior was his problem, not mine.\r\n\r\n35\r\n00:01:15,000 --> 00:01:17,020\r\nSo, maybe it was best just to be detached\r\n\r\n36\r\n00:01:17,020 --> 00:01:20,070\r\nand just quietly laugh at it rather than getting annoyed.\r\n\r\n37\r\n00:01:20,070 --> 00:01:23,010\r\nThe second detachment question is,\r\n\r\n38\r\n00:01:23,010 --> 00:01:25,060\r\n\"What\'s my objective in this situation,\r\n\r\n39\r\n00:01:25,060 --> 00:01:28,050\r\n\"and what\'s the best way to get it?\"\r\n\r\n40\r\n00:01:28,050 --> 00:01:30,060\r\nOnce you know what you want to achieve,\r\n\r\n41\r\n00:01:30,060 --> 00:01:33,020\r\nyou can calmly act without emotion\r\n\r\n42\r\n00:01:33,020 --> 00:01:35,010\r\nin order to get it.\r\n\r\n43\r\n00:01:35,010 --> 00:01:37,000\r\nI play in a band in my spare time,\r\n\r\n44\r\n00:01:37,000 --> 00:01:40,060\r\nand we have a bass player of questionable abilities,\r\n\r\n45\r\n00:01:40,060 --> 00:01:42,030\r\nand the guitarist is always criticizing him\r\n\r\n46\r\n00:01:42,030 --> 00:01:43,030\r\nbehind his back.\r\n\r\n47\r\n00:01:43,030 --> 00:01:45,020\r\n\"Did you hear what he played on that last song?\r\n\r\n48\r\n00:01:45,020 --> 00:01:46,090\r\n\"It was rubbish!\"\r\n\r\n49\r\n00:01:46,090 --> 00:01:48,040\r\nAnd my question is always,\r\n\r\n50\r\n00:01:48,040 --> 00:01:50,060\r\n\"What do you want to do about it?\r\n\r\n51\r\n00:01:50,060 --> 00:01:52,010\r\n\"Do you think we should tell him?\r\n\r\n52\r\n00:01:52,010 --> 00:01:54,010\r\n\"Should we get him to write the chords down?\r\n\r\n53\r\n00:01:54,010 --> 00:01:56,000\r\n\"Would you want to replace him?\"\r\n\r\n54\r\n00:01:56,000 --> 00:01:58,020\r\nThe guitar player never has an answer to this.\r\n\r\n55\r\n00:01:58,020 --> 00:02:00,030\r\nHe would rather waste time complaining\r\n\r\n56\r\n00:02:00,030 --> 00:02:01,060\r\nthan have a clear objective,\r\n\r\n57\r\n00:02:01,060 --> 00:02:04,060\r\nand then calmly put it into practice.\r\n\r\n58\r\n00:02:04,060 --> 00:02:07,020\r\nSo, are you detached enough?\r\n\r\n59\r\n00:02:07,020 --> 00:02:10,020\r\nDo you take on things that are not worth the effort,\r\n\r\n60\r\n00:02:10,020 --> 00:02:12,030\r\nor are never going to succeed?\r\n\r\n61\r\n00:02:12,030 --> 00:02:15,050\r\nWhat can you detach from and just let it go?\r\n\r\n62\r\n00:02:15,050 --> 00:02:18,070\r\nIn the situations that you are determined to change,\r\n\r\n63\r\n00:02:18,070 --> 00:02:20,030\r\ndo you have clear objectives\r\n\r\n64\r\n00:02:20,030 --> 00:02:23,000\r\nthat are feasible for you to achieve?\r\n\r\n65\r\n00:02:23,000 --> 00:02:25,070\r\nAre there situations about which you are unhappy,\r\n\r\n66\r\n00:02:25,070 --> 00:02:27,090\r\nbut where you don\'t yet have a plan\r\n\r\n67\r\n00:02:27,090 --> 00:02:31,020\r\nfor what you are going to do?\r\n\r\n68\r\n00:02:31,020 --> 00:02:34,000\r\nTake a moment from this course to think\r\n\r\n69\r\n00:02:34,000 --> 00:02:36,000\r\nabout these important questions.\r\n\r\n"
                  },
                  new Video
                  {
                    Title = "Learning to disagree by questioning",
                    Slug = "learning-to-disagree-by-questioning",
                    Duration = 273,
                    DownloadUrl = "https://dms.licdn.com/playlist/C4D0DAQHUOQ1aw83mFg/learning-original-video-iphone-360/0/1598507256091?e=1619539200&v=beta&t=tOKyVqwviPvAFP2qZJoHA2vq2Yd9w9dI1bKPigoqdbY#.mp4",
                    TranscriptLines = null,
                    Transcript = "1\r\n00:00:00,070 --> 00:00:02,020\r\n- The next technique I want to share with you\r\n\r\n2\r\n00:00:02,020 --> 00:00:05,010\r\nis called \"Question to Clarify\".\r\n\r\n3\r\n00:00:05,010 --> 00:00:08,060\r\nBecause, after all, the other person might be right.\r\n\r\n4\r\n00:00:08,060 --> 00:00:09,060\r\nIf somebody says,\r\n\r\n5\r\n00:00:09,060 --> 00:00:11,050\r\n\"The report you\'ve written is rubbish!\"\r\n\r\n6\r\n00:00:11,050 --> 00:00:14,070\r\nAsk them, \"What don\'t you like about it?\"\r\n\r\n7\r\n00:00:14,070 --> 00:00:18,000\r\nWe tend to avoid situations where we might get criticized,\r\n\r\n8\r\n00:00:18,000 --> 00:00:21,030\r\nbut either they\'re right and you can learn something,\r\n\r\n9\r\n00:00:21,030 --> 00:00:22,030\r\nor they\'re wrong,\r\n\r\n10\r\n00:00:22,030 --> 00:00:23,090\r\nin which case you can decide whether\r\n\r\n11\r\n00:00:23,090 --> 00:00:25,090\r\nit\'s worth arguing your case,\r\n\r\n12\r\n00:00:25,090 --> 00:00:28,090\r\nor just fogging and letting it go with something like,\r\n\r\n13\r\n00:00:28,090 --> 00:00:31,070\r\n\"Okay, yes, it probably could have been better.\"\r\n\r\n14\r\n00:00:31,070 --> 00:00:33,080\r\nSometimes it\'s not worth the fight.\r\n\r\n15\r\n00:00:33,080 --> 00:00:35,040\r\nThere\'s a great technique for finding out\r\n\r\n16\r\n00:00:35,040 --> 00:00:37,080\r\nwhat someone\'s problem really is,\r\n\r\n17\r\n00:00:37,080 --> 00:00:39,060\r\ncalled \"peeling the onion.\"\r\n\r\n18\r\n00:00:39,060 --> 00:00:41,000\r\nAnd this is where you say,\r\n\r\n19\r\n00:00:41,000 --> 00:00:43,000\r\n\"Apart from that ...\"\r\n\r\n20\r\n00:00:43,000 --> 00:00:43,060\r\nSo you could say,\r\n\r\n21\r\n00:00:43,060 --> 00:00:45,040\r\n\"Apart from the page numbering error,\r\n\r\n22\r\n00:00:45,040 --> 00:00:47,010\r\n\"what did you think of it?\"\r\n\r\n23\r\n00:00:47,010 --> 00:00:47,050\r\nAnd they may say,\r\n\r\n24\r\n00:00:47,050 --> 00:00:50,000\r\n\"Well, the report was fine apart from that.\"\r\n\r\n25\r\n00:00:50,000 --> 00:00:52,060\r\nBut if they give another thing about it they don\'t like,\r\n\r\n26\r\n00:00:52,060 --> 00:00:54,010\r\nthen it means that the first one\r\n\r\n27\r\n00:00:54,010 --> 00:00:56,020\r\nwasn\'t the real reason.\r\n\r\n28\r\n00:00:56,020 --> 00:00:57,050\r\nJust keep going and say,\r\n\r\n29\r\n00:00:57,050 --> 00:01:00,050\r\n\"Apart from those things, was the report okay?\"\r\n\r\n30\r\n00:01:00,050 --> 00:01:01,020\r\nAnd when they finally say,\r\n\r\n31\r\n00:01:01,020 --> 00:01:02,070\r\n\"No, no, that\'s it.\"\r\n\r\n32\r\n00:01:02,070 --> 00:01:06,040\r\nThen you know you\'ve got the real reasons out.\r\n\r\n33\r\n00:01:06,040 --> 00:01:08,080\r\nQuite often, the last reason is the one\r\n\r\n34\r\n00:01:08,080 --> 00:01:11,030\r\nthat you really need to deal with.\r\n\r\n35\r\n00:01:11,030 --> 00:01:15,080\r\nWhy don\'t they come up with the first reason, first time?\r\n\r\n36\r\n00:01:15,080 --> 00:01:17,010\r\nThe reason for that is that people often\r\n\r\n37\r\n00:01:17,010 --> 00:01:19,010\r\nhave a fear that if they come out with\r\n\r\n38\r\n00:01:19,010 --> 00:01:21,030\r\na real objection straight away,\r\n\r\n39\r\n00:01:21,030 --> 00:01:24,080\r\nthat you might be able to handle that in some way.\r\n\r\n40\r\n00:01:24,080 --> 00:01:27,000\r\nThis particularly applies when you get a \"No.\"\r\n\r\n41\r\n00:01:27,000 --> 00:01:28,060\r\nYou should always consider peeling the onion\r\n\r\n42\r\n00:01:28,060 --> 00:01:29,090\r\nwhen you get a \"no\".\r\n\r\n43\r\n00:01:29,090 --> 00:01:31,050\r\nI\'ll tell you what I mean about this.\r\n\r\n44\r\n00:01:31,050 --> 00:01:32,020\r\nSuppose you said to somebody,\r\n\r\n45\r\n00:01:32,020 --> 00:01:34,060\r\n\"I\'d like you to use this new computer system.\"\r\n\r\n46\r\n00:01:34,060 --> 00:01:36,050\r\nAnd he says, \"Oh, I don\'t like using it.\"\r\n\r\n47\r\n00:01:36,050 --> 00:01:38,040\r\nAsk them why, and suppose they say,\r\n\r\n48\r\n00:01:38,040 --> 00:01:41,000\r\n\"Well, the screen gives me a headache.\"\r\n\r\n49\r\n00:01:41,000 --> 00:01:42,070\r\nRather than dealing with that, say,\r\n\r\n50\r\n00:01:42,070 --> 00:01:44,070\r\n\"Apart from that, is there any other reason\r\n\r\n51\r\n00:01:44,070 --> 00:01:47,070\r\n\"why you find the system bad to use?\"\r\n\r\n52\r\n00:01:47,070 --> 00:01:48,020\r\nSuppose they say,\r\n\r\n53\r\n00:01:48,020 --> 00:01:51,070\r\n\"Well yeah. Also, I find the menus confusing.\"\r\n\r\n54\r\n00:01:51,070 --> 00:01:52,090\r\nYou could then say,\r\n\r\n55\r\n00:01:52,090 --> 00:01:54,040\r\n\"Anything else apart from that?\"\r\n\r\n56\r\n00:01:54,040 --> 00:01:56,040\r\nIf they say, \"No, that\'s it, really.\"\r\n\r\n57\r\n00:01:56,040 --> 00:01:58,090\r\nYou now know that the menus are the real reason,\r\n\r\n58\r\n00:01:58,090 --> 00:02:01,010\r\nnot the screen.\r\n\r\n59\r\n00:02:01,010 --> 00:02:03,080\r\nOften, they won\'t come out with the real reason first,\r\n\r\n60\r\n00:02:03,080 --> 00:02:08,030\r\nso you have to peel the onion to find the real problem.\r\n\r\n61\r\n00:02:08,030 --> 00:02:10,050\r\nOnce you\'ve found the real reason,\r\n\r\n62\r\n00:02:10,050 --> 00:02:12,020\r\nyou can then move on to three more types\r\n\r\n63\r\n00:02:12,020 --> 00:02:14,070\r\nof questioning, if you choose to.\r\n\r\n64\r\n00:02:14,070 --> 00:02:18,010\r\nThe first one is \"Questioning to undermine.\"\r\n\r\n65\r\n00:02:18,010 --> 00:02:20,020\r\nThis works really well on me, actually.\r\n\r\n66\r\n00:02:20,020 --> 00:02:22,050\r\nIf someone tells me I\'m wrong, I don\'t believe them.\r\n\r\n67\r\n00:02:22,050 --> 00:02:25,020\r\nBut if they ask me how I know I\'m right,\r\n\r\n68\r\n00:02:25,020 --> 00:02:27,060\r\nthen I get a bit stuck for words.\r\n\r\n69\r\n00:02:27,060 --> 00:02:31,080\r\nSo, questioning to undermine is subtle, but very powerful.\r\n\r\n70\r\n00:02:31,080 --> 00:02:32,090\r\nThe second type of questioning is,\r\n\r\n71\r\n00:02:32,090 --> 00:02:35,010\r\n\"Questioning to persuade.\"\r\n\r\n72\r\n00:02:35,010 --> 00:02:36,050\r\nSuppose you wanted to, I don\'t know,\r\n\r\n73\r\n00:02:36,050 --> 00:02:38,050\r\npersuade somebody to give up smoking.\r\n\r\n74\r\n00:02:38,050 --> 00:02:39,020\r\nIf you just say,\r\n\r\n75\r\n00:02:39,020 --> 00:02:40,090\r\n\"You should give up smoking.\"\r\n\r\n76\r\n00:02:40,090 --> 00:02:42,050\r\nThat\'s not gonna work, they\'re just going to say,\r\n\r\n77\r\n00:02:42,050 --> 00:02:45,000\r\n\"No, no. I\'m addicted, I don\'t want to.\"\r\n\r\n78\r\n00:02:45,000 --> 00:02:46,020\r\nIt\'s much better to ask them,\r\n\r\n79\r\n00:02:46,020 --> 00:02:49,010\r\n\"Have you ever thought of giving up?\r\n\r\n80\r\n00:02:49,010 --> 00:02:51,060\r\n\"And, when you did think about giving up,\r\n\r\n81\r\n00:02:51,060 --> 00:02:53,060\r\n\"What was your motivation?\"\r\n\r\n82\r\n00:02:53,060 --> 00:02:54,010\r\nSuppose they say,\r\n\r\n83\r\n00:02:54,010 --> 00:02:57,040\r\n\"Well, I\'d like to be better at playing football.\"\r\n\r\n84\r\n00:02:57,040 --> 00:02:58,030\r\nYou could then say,\r\n\r\n85\r\n00:02:58,030 --> 00:03:00,020\r\n\"Well, why is playing football important?\"\r\n\r\n86\r\n00:03:00,020 --> 00:03:00,070\r\nAnd they might say,\r\n\r\n87\r\n00:03:00,070 --> 00:03:02,060\r\n\"Well, I want to play with my grandchildren.\"\r\n\r\n88\r\n00:03:02,060 --> 00:03:04,040\r\nAnd you can ask them about that.\r\n\r\n89\r\n00:03:04,040 --> 00:03:06,010\r\nAnd you can really start to drill into\r\n\r\n90\r\n00:03:06,010 --> 00:03:07,070\r\nwhat their motivation really is,\r\n\r\n91\r\n00:03:07,070 --> 00:03:09,020\r\nand this is useful information when it comes\r\n\r\n92\r\n00:03:09,020 --> 00:03:11,040\r\nto persuading them to give up.\r\n\r\n93\r\n00:03:11,040 --> 00:03:12,010\r\nThen you can ask them,\r\n\r\n94\r\n00:03:12,010 --> 00:03:15,000\r\n\"What\'s the barrier to giving up? Why don\'t you give up?\r\n\r\n95\r\n00:03:15,000 --> 00:03:17,090\r\n\"And what would it take to overcome that barrier?\"\r\n\r\n96\r\n00:03:17,090 --> 00:03:19,050\r\nThese questions are giving you all sorts\r\n\r\n97\r\n00:03:19,050 --> 00:03:21,010\r\nof really important information about\r\n\r\n98\r\n00:03:21,010 --> 00:03:23,050\r\nwhat\'s going on in their head.\r\n\r\n99\r\n00:03:23,050 --> 00:03:27,010\r\nRemember that everything that they say is true to them.\r\n\r\n100\r\n00:03:27,010 --> 00:03:29,050\r\nIf you say, \"You should give up.\"\r\n\r\n101\r\n00:03:29,050 --> 00:03:30,070\r\nThat\'s probably not true.\r\n\r\n102\r\n00:03:30,070 --> 00:03:33,040\r\nBut if they say, \"I need to give up.\"\r\n\r\n103\r\n00:03:33,040 --> 00:03:36,030\r\nThen that is true to them.\r\n\r\n104\r\n00:03:36,030 --> 00:03:39,070\r\nThe third type of questioning is \"questioning to disagree.\"\r\n\r\n105\r\n00:03:39,070 --> 00:03:41,090\r\nSuppose you wanted to convince somebody\r\n\r\n106\r\n00:03:41,090 --> 00:03:45,000\r\nthat diesel cars are great.\r\n\r\n107\r\n00:03:45,000 --> 00:03:45,060\r\nYou could say to them,\r\n\r\n108\r\n00:03:45,060 --> 00:03:47,070\r\n\"Do you know the facts on acceleration\r\n\r\n109\r\n00:03:47,070 --> 00:03:51,020\r\n\"of diesel cars, and economy of diesel cars.\"\r\n\r\n110\r\n00:03:51,020 --> 00:03:52,000\r\nAnd you can say to them,\r\n\r\n111\r\n00:03:52,000 --> 00:03:54,040\r\n\"If there was proof that diesel cars were really good,\r\n\r\n112\r\n00:03:54,040 --> 00:03:56,040\r\n\"would you be prepared to have a look at it?\"\r\n\r\n113\r\n00:03:56,040 --> 00:03:57,050\r\nOr, we could even say,\r\n\r\n114\r\n00:03:57,050 --> 00:03:59,040\r\n\"Presumably, you\'d be open-minded enough\r\n\r\n115\r\n00:03:59,040 --> 00:04:02,000\r\n\"to try driving one.\"\r\n\r\n116\r\n00:04:02,000 --> 00:04:05,010\r\nThose are questions to disagree.\r\n\r\n117\r\n00:04:05,010 --> 00:04:09,010\r\nI\'d like you to think, has there been a recent situation\r\n\r\n118\r\n00:04:09,010 --> 00:04:10,080\r\nwhere you came up against a brick wall,\r\n\r\n119\r\n00:04:10,080 --> 00:04:12,030\r\nand could maybe have got past it\r\n\r\n120\r\n00:04:12,030 --> 00:04:15,060\r\nby using questioning rather than statements.\r\n\r\n121\r\n00:04:15,060 --> 00:04:18,000\r\nCan you think of times when peeling the onion\r\n\r\n122\r\n00:04:18,000 --> 00:04:19,090\r\nwill be a way to find out more about\r\n\r\n123\r\n00:04:19,090 --> 00:04:23,000\r\nwhat\'s really on someone\'s mind.\r\n\r\n124\r\n00:04:23,000 --> 00:04:24,030\r\nCan you think about people who might\r\n\r\n125\r\n00:04:24,030 --> 00:04:26,080\r\nrespond well to questioning?\r\n\r\n126\r\n00:04:26,080 --> 00:04:28,090\r\nEither questioning to undermine,\r\n\r\n127\r\n00:04:28,090 --> 00:04:33,000\r\nquestioning to persuade, or questioning to disagree.\r\n\r\n"
                  },
                  new Video
                  {
                    Title = "Highlighting their unspoken signals (body language)",
                    Slug = "highlighting-their-unspoken-signals-body-language",
                    Duration = 120,
                    DownloadUrl = "https://dms.licdn.com/playlist/C4D0DAQFiMeLDG3-n7g/learning-original-video-iphone-360/0/1598507141465?e=1619539200&v=beta&t=mVNNGKvoaUE_IkWnleZZ3dKbkTVfd3lY3xcFqSYIXYs#.mp4",
                    TranscriptLines = null,
                    Transcript = "1\r\n00:00:00,090 --> 00:00:02,030\r\n- A great little technique for handling\r\n\r\n2\r\n00:00:02,030 --> 00:00:04,040\r\naggressive body language is\r\n\r\n3\r\n00:00:04,040 --> 00:00:08,030\r\nI notice, I interpret, am I right?\r\n\r\n4\r\n00:00:08,030 --> 00:00:09,090\r\nNow the key here is we\'re only talking about\r\n\r\n5\r\n00:00:09,090 --> 00:00:11,060\r\naggressive body language.\r\n\r\n6\r\n00:00:11,060 --> 00:00:14,010\r\nThese people are probably not saying anything particularly.\r\n\r\n7\r\n00:00:14,010 --> 00:00:15,080\r\nThere\'s just something in their body language\r\n\r\n8\r\n00:00:15,080 --> 00:00:17,080\r\nthat showing that they\'re not happy with you.\r\n\r\n9\r\n00:00:17,080 --> 00:00:19,020\r\nAnd we want to pick them up on this\r\n\r\n10\r\n00:00:19,020 --> 00:00:21,010\r\nand find out what the problem is,\r\n\r\n11\r\n00:00:21,010 --> 00:00:23,070\r\nbut in a non-aggressive way.\r\n\r\n12\r\n00:00:23,070 --> 00:00:26,030\r\nSo we\'re clarifying.\r\n\r\n13\r\n00:00:26,030 --> 00:00:27,090\r\nAn example this might be in a meeting\r\n\r\n14\r\n00:00:27,090 --> 00:00:31,030\r\nmaybe when you mention the production department,\r\n\r\n15\r\n00:00:31,030 --> 00:00:33,090\r\nsomebody else in the meeting rolls their eyes\r\n\r\n16\r\n00:00:33,090 --> 00:00:36,040\r\nor keeps looking at their colleague\r\n\r\n17\r\n00:00:36,040 --> 00:00:39,030\r\nand you feel that\'s unacceptable and you want to\r\n\r\n18\r\n00:00:39,030 --> 00:00:40,040\r\npick them up on it.\r\n\r\n19\r\n00:00:40,040 --> 00:00:43,010\r\nSo you can calmly say, \"Dave, I notice that every time\r\n\r\n20\r\n00:00:43,010 --> 00:00:45,090\r\n\'I mention the production department, you go...\r\n\r\n21\r\n00:00:45,090 --> 00:00:47,050\r\n\'and I interpret that to mean\r\n\r\n22\r\n00:00:47,050 --> 00:00:51,070\r\n\'that you\'re not with us in some way. Am I right?\"\r\n\r\n23\r\n00:00:51,070 --> 00:00:53,060\r\nNow this could be done during the meeting\r\n\r\n24\r\n00:00:53,060 --> 00:00:55,060\r\nor it could be done one-to-one afterwards.\r\n\r\n25\r\n00:00:55,060 --> 00:00:56,040\r\nYou can pick them up and say,\r\n\r\n26\r\n00:00:56,040 --> 00:00:58,050\r\n\"During the meeting I just had a feeling each time\r\n\r\n27\r\n00:00:58,050 --> 00:00:59,090\r\n\'I said this, I noticed this\r\n\r\n28\r\n00:00:59,090 --> 00:01:03,090\r\n\'and I just interpret it as this; am I right?\"\r\n\r\n29\r\n00:01:03,090 --> 00:01:05,000\r\nIt\'s non-aggressive.\r\n\r\n30\r\n00:01:05,000 --> 00:01:08,010\r\nIt\'s just clarifying.\r\n\r\n31\r\n00:01:08,010 --> 00:01:10,060\r\nWhat are they going to do when you say this?\r\n\r\n32\r\n00:01:10,060 --> 00:01:12,050\r\nWell, they\'ve really only got two options.\r\n\r\n33\r\n00:01:12,050 --> 00:01:13,060\r\nThey can either say, \"No sorry,\r\n\r\n34\r\n00:01:13,060 --> 00:01:15,030\r\n\'I didn\'t mean anything by it.\"\r\n\r\n35\r\n00:01:15,030 --> 00:01:18,000\r\nSome people just have unfortunate body language.\r\n\r\n36\r\n00:01:18,000 --> 00:01:21,010\r\nBut the other thing is, they may say, \"Well yeah, actually\r\n\r\n37\r\n00:01:21,010 --> 00:01:23,020\r\n\'I do think that the production department are not\r\n\r\n38\r\n00:01:23,020 --> 00:01:25,050\r\n\'doing their job properly; been late on the last three jobs\"\r\n\r\n39\r\n00:01:25,050 --> 00:01:28,050\r\nor whatever, \"And this is what I want\".\r\n\r\n40\r\n00:01:28,050 --> 00:01:30,080\r\nSo we can have a decent conversation about what\r\n\r\n41\r\n00:01:30,080 --> 00:01:31,060\r\nthe problem is.\r\n\r\n42\r\n00:01:31,060 --> 00:01:33,020\r\nWe flushed it out.\r\n\r\n43\r\n00:01:33,020 --> 00:01:34,050\r\nSo what we\'re doing here is we\'re clarifying\r\n\r\n44\r\n00:01:34,050 --> 00:01:36,060\r\nwith this little technique.\r\n\r\n45\r\n00:01:36,060 --> 00:01:39,000\r\nSo have you had any recent examples\r\n\r\n46\r\n00:01:39,000 --> 00:01:40,090\r\nwhen you could have used this?\r\n\r\n47\r\n00:01:40,090 --> 00:01:43,040\r\nWere there some situations that came up in meetings\r\n\r\n48\r\n00:01:43,040 --> 00:01:45,010\r\nor just to one-to-one perhaps\r\n\r\n49\r\n00:01:45,010 --> 00:01:46,060\r\nwhere the person\'s body language\r\n\r\n50\r\n00:01:46,060 --> 00:01:48,040\r\nwas a little bit aggressive?\r\n\r\n51\r\n00:01:48,040 --> 00:01:52,020\r\nOr, are there any people who tend to use subtly aggressive\r\n\r\n52\r\n00:01:52,020 --> 00:01:55,040\r\nbody language that you can try this out on?\r\n\r\n53\r\n00:01:55,040 --> 00:01:57,020\r\nI\'d like you just to think about that.\r\n\r\n54\r\n00:01:57,020 --> 00:02:00,000\r\nHow could you apply this technique?\r\n\r\n"
                  },
                  new Video
                  {
                    Title = "Commenting on the process",
                    Slug = "commenting-on-the-process",
                    Duration = 130,
                    DownloadUrl = "https://dms.licdn.com/playlist/C4D0DAQGuGNrc3md9eg/learning-original-video-iphone-360/0/1598507237244?e=1619539200&v=beta&t=O8WYxAoP_gCXgPqpMfWC4AFhEJfnb4u3mdoz-Xd_aw8#.mp4",
                    TranscriptLines = null,
                    Transcript = "1\r\n00:00:01,000 --> 00:00:02,050\r\n- Now I\'d like to say a bit about commenting\r\n\r\n2\r\n00:00:02,050 --> 00:00:05,070\r\non the process between you and the other person.\r\n\r\n3\r\n00:00:05,070 --> 00:00:07,040\r\nMaybe the words that they\'re using\r\n\r\n4\r\n00:00:07,040 --> 00:00:10,000\r\nor the emotions that they\'re having.\r\n\r\n5\r\n00:00:10,000 --> 00:00:13,020\r\nSo in terms of the words, if they describe a decision\r\n\r\n6\r\n00:00:13,020 --> 00:00:15,030\r\nas stupid or crazy\r\n\r\n7\r\n00:00:15,030 --> 00:00:17,000\r\nyou could pick them up on those words and say,\r\n\r\n8\r\n00:00:17,000 --> 00:00:20,000\r\n\"Well I agree that the decision in retrospect\r\n\r\n9\r\n00:00:20,000 --> 00:00:22,040\r\n\"could have been better but I think it\'s a bit harsh\r\n\r\n10\r\n00:00:22,040 --> 00:00:25,020\r\n\"to call it crazy.\"\r\n\r\n11\r\n00:00:25,020 --> 00:00:27,010\r\nAnd then if necessary you could point out\r\n\r\n12\r\n00:00:27,010 --> 00:00:30,090\r\ntheir behavior and emotional state as well.\r\n\r\n13\r\n00:00:30,090 --> 00:00:32,090\r\nFor example if somebody\'s shouting at you\r\n\r\n14\r\n00:00:32,090 --> 00:00:34,050\r\nyou can say to them,\r\n\r\n15\r\n00:00:34,050 --> 00:00:36,020\r\n\"You\'re shouting at me and disturbing everyone\r\n\r\n16\r\n00:00:36,020 --> 00:00:37,060\r\n\"else in the office.\r\n\r\n17\r\n00:00:37,060 --> 00:00:40,040\r\n\"Is this the best way to resolve this problem?\r\n\r\n18\r\n00:00:40,040 --> 00:00:41,070\r\n\"Maybe we could meet later when\r\n\r\n19\r\n00:00:41,070 --> 00:00:43,050\r\n\"you\'re in a calmer mood.\"\r\n\r\n20\r\n00:00:43,050 --> 00:00:47,000\r\nSo you calmly point out their behavior and their emotions\r\n\r\n21\r\n00:00:47,000 --> 00:00:49,000\r\nand this works because often people aren\'t\r\n\r\n22\r\n00:00:49,000 --> 00:00:50,060\r\nconscious of their behavior.\r\n\r\n23\r\n00:00:50,060 --> 00:00:52,090\r\nThey\'ve slipped into autopilot.\r\n\r\n24\r\n00:00:52,090 --> 00:00:54,020\r\nAnd the hope is that they\'ll say,\r\n\r\n25\r\n00:00:54,020 --> 00:00:56,010\r\n\"Oh yeah, sorry about that.\"\r\n\r\n26\r\n00:00:56,010 --> 00:00:57,020\r\nIf they say,\r\n\r\n27\r\n00:00:57,020 --> 00:00:59,010\r\n\"I\'ll damn well shout if I want to!\r\n\r\n28\r\n00:00:59,010 --> 00:01:00,050\r\n\"I\'m really annoyed!\"\r\n\r\n29\r\n00:01:00,050 --> 00:01:03,030\r\nthen you now know what you\'re dealing with\r\n\r\n30\r\n00:01:03,030 --> 00:01:04,070\r\nand you\'re fully justified in saying\r\n\r\n31\r\n00:01:04,070 --> 00:01:06,050\r\n\"Well I\'m not going to try to resolve this\r\n\r\n32\r\n00:01:06,050 --> 00:01:10,040\r\n\"when you\'re in that state, we\'ll talk in half an hour.\"\r\n\r\n33\r\n00:01:10,040 --> 00:01:12,000\r\nPointing out their behavior can also be used\r\n\r\n34\r\n00:01:12,000 --> 00:01:14,090\r\nto show that you\'re on to their game.\r\n\r\n35\r\n00:01:14,090 --> 00:01:17,020\r\nFor example a perennial problem I get\r\n\r\n36\r\n00:01:17,020 --> 00:01:18,070\r\nis trying to get a gig in a pub\r\n\r\n37\r\n00:01:18,070 --> 00:01:21,000\r\nand trying to get a meeting with the landlord\r\n\r\n38\r\n00:01:21,000 --> 00:01:22,010\r\nand there\'s always somebody saying,\r\n\r\n39\r\n00:01:22,010 --> 00:01:24,000\r\n\"Oh he\'s not here I\'m afraid.\"\r\n\r\n40\r\n00:01:24,000 --> 00:01:26,040\r\nI suspect he probably is there upstairs\r\n\r\n41\r\n00:01:26,040 --> 00:01:28,020\r\nand just isn\'t talking to visitors.\r\n\r\n42\r\n00:01:28,020 --> 00:01:30,010\r\nSo the thing is to comment on the process\r\n\r\n43\r\n00:01:30,010 --> 00:01:31,000\r\nand say to them,\r\n\r\n44\r\n00:01:31,000 --> 00:01:33,040\r\n\"Well I\'ve been in several times now\r\n\r\n45\r\n00:01:33,040 --> 00:01:36,050\r\n\"and these random visits just aren\'t working\r\n\r\n46\r\n00:01:36,050 --> 00:01:38,070\r\n\"so can you help me and maybe suggest\r\n\r\n47\r\n00:01:38,070 --> 00:01:41,080\r\n\"a better way to contact him?\"\r\n\r\n48\r\n00:01:41,080 --> 00:01:44,030\r\nSo by highlighting the process you\'re saying\r\n\r\n49\r\n00:01:44,030 --> 00:01:46,040\r\n\"I\'m on to your game, it can\'t go on,\r\n\r\n50\r\n00:01:46,040 --> 00:01:47,060\r\n\"we need to find another way.\"\r\n\r\n51\r\n00:01:47,060 --> 00:01:50,090\r\nAsking them for help is quite powerful too.\r\n\r\n52\r\n00:01:50,090 --> 00:01:53,060\r\nSo maybe there are people in your work\r\n\r\n53\r\n00:01:53,060 --> 00:01:55,050\r\nor your personal life who would benefit\r\n\r\n54\r\n00:01:55,050 --> 00:01:58,040\r\nfrom having their aggressive words pointed out\r\n\r\n55\r\n00:01:58,040 --> 00:02:02,060\r\nor their unhelpful behaviors calmly highlighted.\r\n\r\n56\r\n00:02:02,060 --> 00:02:04,050\r\nCan you think of some recent situations\r\n\r\n57\r\n00:02:04,050 --> 00:02:06,060\r\nwhere you could\'ve done this?\r\n\r\n58\r\n00:02:06,060 --> 00:02:08,040\r\nSo that you can be ready for them\r\n\r\n59\r\n00:02:08,040 --> 00:02:10,000\r\nwhen it next happens.\r\n\r\n"
                  },
                  new Video
                  {
                    Title = "Escalating from the one-off to the habit",
                    Slug = "escalating-from-the-one-off-to-the-habit",
                    Duration = 163,
                    DownloadUrl = "https://dms.licdn.com/playlist/C560DAQFPKHEWGpvwTA/learning-original-video-iphone-360/0/1598507052119?e=1619539200&v=beta&t=g5IPqDtDLHZccOt01k-hwanLIcEN6xpJwtZul0yNKqg#.mp4",
                    TranscriptLines = null,
                    Transcript = "1\r\n00:00:00,060 --> 00:00:02,090\r\n- Now, with any assertiveness situation,\r\n\r\n2\r\n00:00:02,090 --> 00:00:06,030\r\nyou\'ve always got two levels you can choose between.\r\n\r\n3\r\n00:00:06,030 --> 00:00:08,010\r\nThere\'s confronting the one-off,\r\n\r\n4\r\n00:00:08,010 --> 00:00:09,060\r\nand then, if that doesn\'t work after\r\n\r\n5\r\n00:00:09,060 --> 00:00:11,030\r\nyou\'ve done it several times,\r\n\r\n6\r\n00:00:11,030 --> 00:00:12,090\r\nyou can confront them with their habit.\r\n\r\n7\r\n00:00:12,090 --> 00:00:16,010\r\nYou can go from the one-off to the habit.\r\n\r\n8\r\n00:00:16,010 --> 00:00:16,060\r\nAn example of this,\r\n\r\n9\r\n00:00:16,060 --> 00:00:19,070\r\nmy son has a friend who likes to crash on the sofa\r\n\r\n10\r\n00:00:19,070 --> 00:00:22,060\r\nin my son\'s room when they get in from a night out.\r\n\r\n11\r\n00:00:22,060 --> 00:00:25,070\r\nAnd this friend doesn\'t ask, he just comes in,\r\n\r\n12\r\n00:00:25,070 --> 00:00:27,070\r\nand this is starting to irritate my son,\r\n\r\n13\r\n00:00:27,070 --> 00:00:29,040\r\nso what should he do?\r\n\r\n14\r\n00:00:29,040 --> 00:00:33,030\r\nWell, he should try the one-off two or three times first.\r\n\r\n15\r\n00:00:33,030 --> 00:00:34,080\r\nHe should say something like,\r\n\r\n16\r\n00:00:34,080 --> 00:00:36,090\r\n\"It\'s not convenient for you to stay here tonight.\"\r\n\r\n17\r\n00:00:36,090 --> 00:00:41,000\r\nOr, \"Is it okay if you don\'t crash on my sofa this time?\"\r\n\r\n18\r\n00:00:41,000 --> 00:00:42,070\r\nBut then, if he has to,\r\n\r\n19\r\n00:00:42,070 --> 00:00:45,050\r\nhe could maybe go up a level and point out the habit,\r\n\r\n20\r\n00:00:45,050 --> 00:00:46,080\r\nand you could say something like,\r\n\r\n21\r\n00:00:46,080 --> 00:00:49,000\r\n\"You quite often come in without checking with me first,\r\n\r\n22\r\n00:00:49,000 --> 00:00:50,080\r\n\"which sometimes gives me a problem.\r\n\r\n23\r\n00:00:50,080 --> 00:00:53,070\r\n\"So, can we agree at the start of the evening\r\n\r\n24\r\n00:00:53,070 --> 00:00:56,020\r\n\"how you\'re going to get home?\"\r\n\r\n25\r\n00:00:56,020 --> 00:00:59,040\r\nUseful phrases for pointing out habits are,\r\n\r\n26\r\n00:00:59,040 --> 00:01:00,070\r\n\"I don\'t like it when ...\",\r\n\r\n27\r\n00:01:00,070 --> 00:01:04,000\r\nor, \"Have you noticed how you tend to ...\"\r\n\r\n28\r\n00:01:04,000 --> 00:01:05,090\r\nA great example of a habit that was\r\n\r\n29\r\n00:01:05,090 --> 00:01:08,000\r\nnever assertively confronted was that,\r\n\r\n30\r\n00:01:08,000 --> 00:01:09,080\r\none of my customers knows a bunch of\r\n\r\n31\r\n00:01:09,080 --> 00:01:12,010\r\nreally nice engineers,\r\n\r\n32\r\n00:01:12,010 --> 00:01:14,010\r\nand they worked with a very chatty lady\r\n\r\n33\r\n00:01:14,010 --> 00:01:16,040\r\nwho had a habit of interrupting them.\r\n\r\n34\r\n00:01:16,040 --> 00:01:17,040\r\nShe would come into their office\r\n\r\n35\r\n00:01:17,040 --> 00:01:20,080\r\nand she would sit down and just talk for ages,\r\n\r\n36\r\n00:01:20,080 --> 00:01:23,020\r\nwhen they were busy.\r\n\r\n37\r\n00:01:23,020 --> 00:01:24,070\r\nThey weren\'t assertive enough to say,\r\n\r\n38\r\n00:01:24,070 --> 00:01:26,070\r\n\"Look, we don\'t like it when you come in.\"\r\n\r\n39\r\n00:01:26,070 --> 00:01:27,070\r\nWhat they used to do,\r\n\r\n40\r\n00:01:27,070 --> 00:01:30,050\r\nthey used to phone each other up from a different office,\r\n\r\n41\r\n00:01:30,050 --> 00:01:32,090\r\nso if you saw across the hall that somebody\r\n\r\n42\r\n00:01:32,090 --> 00:01:36,030\r\nhad this lady in there, you\'d ring them up.\r\n\r\n43\r\n00:01:36,030 --> 00:01:37,090\r\nThen, his phone would go, and he\'d go,\r\n\r\n44\r\n00:01:37,090 --> 00:01:40,000\r\n\"Oh, really? Sorry I\'ve got to go.\"\r\n\r\n45\r\n00:01:40,000 --> 00:01:41,080\r\nSo, they used to bail each other out,\r\n\r\n46\r\n00:01:41,080 --> 00:01:44,000\r\nNone of them were assertive enough just to say to her,\r\n\r\n47\r\n00:01:44,000 --> 00:01:45,010\r\n\"Actually, do you mind?\r\n\r\n48\r\n00:01:45,010 --> 00:01:46,030\r\n\"It would be great if you didn\'t come\r\n\r\n49\r\n00:01:46,030 --> 00:01:48,040\r\n\"and interrupt us when we\'re busy.\"\r\n\r\n50\r\n00:01:48,040 --> 00:01:52,040\r\nNow, was it nicer for her to not tell her\r\n\r\n51\r\n00:01:52,040 --> 00:01:54,000\r\nthat she was too chatty?\r\n\r\n52\r\n00:01:54,000 --> 00:01:57,020\r\nAnd I would say, perhaps in the short term, yes.\r\n\r\n53\r\n00:01:57,020 --> 00:01:59,010\r\nBut now in the long run.\r\n\r\n54\r\n00:01:59,010 --> 00:02:02,010\r\nThey\'d have done her a favor to tell her, I think.\r\n\r\n55\r\n00:02:02,010 --> 00:02:04,000\r\nAll this stuff was going on behind her back,\r\n\r\n56\r\n00:02:04,000 --> 00:02:08,010\r\nand that was authentic and was a bit of a shame.\r\n\r\n57\r\n00:02:08,010 --> 00:02:10,000\r\nAnyway, if you do have to give somebody news\r\n\r\n58\r\n00:02:10,000 --> 00:02:11,030\r\nthey don\'t want to hear, like,\r\n\r\n59\r\n00:02:11,030 --> 00:02:12,070\r\n\"You interrupt too often.\"\r\n\r\n60\r\n00:02:12,070 --> 00:02:14,020\r\nBlame it on yourself.\r\n\r\n61\r\n00:02:14,020 --> 00:02:16,070\r\nJust say, \"I\'m really funny about anyone interrupting me.\"\r\n\r\n62\r\n00:02:16,070 --> 00:02:17,070\r\nOr something like that,\r\n\r\n63\r\n00:02:17,070 --> 00:02:20,010\r\njust in order to get the result that you want.\r\n\r\n64\r\n00:02:20,010 --> 00:02:22,030\r\nYou know you\'re still okay\r\n\r\n65\r\n00:02:22,030 --> 00:02:25,070\r\nhowever you word the request to her.\r\n\r\n66\r\n00:02:25,070 --> 00:02:27,030\r\nAnd you are doing her a favor,\r\n\r\n67\r\n00:02:27,030 --> 00:02:28,050\r\nyou\'re also doing a favor\r\n\r\n68\r\n00:02:28,050 --> 00:02:31,090\r\nfor all of your work mates, as well.\r\n\r\n69\r\n00:02:31,090 --> 00:02:34,020\r\nAre there any people with habits out there\r\n\r\n70\r\n00:02:34,020 --> 00:02:35,070\r\nthat you need to confront?\r\n\r\n71\r\n00:02:35,070 --> 00:02:37,000\r\nAnd do you think maybe,\r\n\r\n72\r\n00:02:37,000 --> 00:02:40,010\r\nit\'s time to go up from the one-off that isn\'t working,\r\n\r\n73\r\n00:02:40,010 --> 00:02:43,000\r\nto telling them about their habit?\r\n\r\n"
                  },
                  new Video
                  {
                    Title = "Using the \'broken record\' technique",
                    Slug = "using-the-broken-record-technique",
                    Duration = 94,
                    DownloadUrl = "https://dms.licdn.com/playlist/C4D0DAQFyFRJqb4H7Kg/learning-original-video-iphone-360/0/1598507093574?e=1619539200&v=beta&t=it_WuZWOOYKrbZFpk5yef71XiQt5qoQjpobD6OaOkzo#.mp4",
                    TranscriptLines = null,
                    Transcript = "1\r\n00:00:00,070 --> 00:00:03,000\r\n- Now there’s a well-known assertiveness technique called\r\n\r\n2\r\n00:00:03,000 --> 00:00:05,040\r\nthe broken-record technique.\r\n\r\n3\r\n00:00:05,040 --> 00:00:06,070\r\nIn some ways, I don’t really like this,\r\n\r\n4\r\n00:00:06,070 --> 00:00:08,070\r\nbecause it feels a bit boring to use,\r\n\r\n5\r\n00:00:08,070 --> 00:00:12,090\r\nbut it can be very affective, so you need to know about it.\r\n\r\n6\r\n00:00:12,090 --> 00:00:18,010\r\nThis a technique where you repeat one phrase over and over.\r\n\r\n7\r\n00:00:18,010 --> 00:00:21,020\r\nThe reason that you do this is you’re sending a message\r\n\r\n8\r\n00:00:21,020 --> 00:00:23,020\r\nto the other person that they are not\r\n\r\n9\r\n00:00:23,020 --> 00:00:24,040\r\ngoing to get passed you.\r\n\r\n10\r\n00:00:24,040 --> 00:00:26,050\r\nLet’s say, for example, you work in a restaurant,\r\n\r\n11\r\n00:00:26,050 --> 00:00:27,080\r\nsomeone’s complaining about their meal\r\n\r\n12\r\n00:00:27,080 --> 00:00:29,070\r\nafter they’ve eaten all of it.\r\n\r\n13\r\n00:00:29,070 --> 00:00:31,040\r\nSo, it wasn’t obviously all that bad.\r\n\r\n14\r\n00:00:31,040 --> 00:00:32,020\r\nYou could say to them,\r\n\r\n15\r\n00:00:32,020 --> 00:00:34,040\r\n“It’s not our policy to give full refunds\r\n\r\n16\r\n00:00:34,040 --> 00:00:36,040\r\n“after you’ve eaten the whole meal.”\r\n\r\n17\r\n00:00:36,040 --> 00:00:38,090\r\nAnd If they say, “But the meal was terrible.”\r\n\r\n18\r\n00:00:38,090 --> 00:00:41,000\r\nYou can just say, “Well I’m afraid it’s not our policy\r\n\r\n19\r\n00:00:41,000 --> 00:00:43,090\r\n\"to give full refunds after you’ve eaten the whole meal.”\r\n\r\n20\r\n00:00:43,090 --> 00:00:46,030\r\nAnd if they say, “But, it’s only $10.00 I want back.”\r\n\r\n21\r\n00:00:46,030 --> 00:00:48,080\r\nYou can say, “Well I’m afraid it just not our policy\r\n\r\n22\r\n00:00:48,080 --> 00:00:51,050\r\n“to give full refunds after you’re eaten the whole meal.”\r\n\r\n23\r\n00:00:51,050 --> 00:00:53,080\r\nAnd you can feel the power of this, can’t you?\r\n\r\n24\r\n00:00:53,080 --> 00:00:55,000\r\nThe other person’s thinking,\r\n\r\n25\r\n00:00:55,000 --> 00:00:56,080\r\n“I’m not going to get passed this guy.”\r\n\r\n26\r\n00:00:56,080 --> 00:01:00,050\r\nSo, it’s easy to use, and it is powerful.\r\n\r\n27\r\n00:01:00,050 --> 00:01:02,080\r\nIt’s tempting to try to be cleaver and to come up with\r\n\r\n28\r\n00:01:02,080 --> 00:01:04,070\r\ndifferent arguments each time,\r\n\r\n29\r\n00:01:04,070 --> 00:01:06,010\r\nbut the problem is, if you do that,\r\n\r\n30\r\n00:01:06,010 --> 00:01:08,060\r\nthey’ll pick on your weakest argument.\r\n\r\n31\r\n00:01:08,060 --> 00:01:12,000\r\nThen if they defeat that, you can’t retreat back to one of\r\n\r\n32\r\n00:01:12,000 --> 00:01:13,040\r\nyour other arguments and say,\r\n\r\n33\r\n00:01:13,040 --> 00:01:15,010\r\n“Well, okay, I didn’t really mean that one,\r\n\r\n34\r\n00:01:15,010 --> 00:01:17,040\r\n\"but how about this argument?”\r\n\r\n35\r\n00:01:17,040 --> 00:01:19,090\r\nSo, the thing is just to pick a really strong argument like,\r\n\r\n36\r\n00:01:19,090 --> 00:01:24,040\r\nit’s not our policy, and then just keep repeating that.\r\n\r\n37\r\n00:01:24,040 --> 00:01:27,020\r\nSo, that’s the broken-record technique.\r\n\r\n38\r\n00:01:27,020 --> 00:01:29,000\r\nSometimes, if you’re dealing with a person\r\n\r\n39\r\n00:01:29,000 --> 00:01:30,060\r\nwho\'s very persistent,\r\n\r\n40\r\n00:01:30,060 --> 00:01:34,000\r\nit’s the only assertiveness technique that will work.\r\n\r\n"
                  },
                  new Video
                  {
                    Title = "Planning a second meeting",
                    Slug = "planning-a-second-meeting",
                    Duration = 84,
                    DownloadUrl = "https://dms.licdn.com/playlist/C4E0DAQHDOi9b0U7SMg/learning-original-video-iphone-360/0/1598507286116?e=1619539200&v=beta&t=fEnMIuIUtPQB0XCcy_kj03svzVjm9PCN_gXReC-2JTU#.mp4",
                    TranscriptLines = null,
                    Transcript = "1\r\n00:00:00,070 --> 00:00:02,090\r\n- Now a really useful assertiveness concept\r\n\r\n2\r\n00:00:02,090 --> 00:00:06,030\r\nis that it\'s never too late to go back.\r\n\r\n3\r\n00:00:06,030 --> 00:00:08,090\r\nSometimes, in fact probably quite often,\r\n\r\n4\r\n00:00:08,090 --> 00:00:11,030\r\nyou wish you\'d said something at the time,\r\n\r\n5\r\n00:00:11,030 --> 00:00:12,090\r\nbut you missed your chance.\r\n\r\n6\r\n00:00:12,090 --> 00:00:14,060\r\nThe good news is that it\'s okay.\r\n\r\n7\r\n00:00:14,060 --> 00:00:16,060\r\nYou can go back and have another go.\r\n\r\n8\r\n00:00:16,060 --> 00:00:18,080\r\nAnd in fact, it\'s probably going to work better.\r\n\r\n9\r\n00:00:18,080 --> 00:00:20,060\r\nYou\'ll probably be stronger when you\'ve had\r\n\r\n10\r\n00:00:20,060 --> 00:00:23,070\r\na chance to plan and then go back.\r\n\r\n11\r\n00:00:23,070 --> 00:00:25,080\r\nFor example, suppose somebody shouts at you\r\n\r\n12\r\n00:00:25,080 --> 00:00:28,080\r\nin the office and you don\'t know what to say.\r\n\r\n13\r\n00:00:28,080 --> 00:00:31,000\r\nYou\'re so surprised, you let them get away with it.\r\n\r\n14\r\n00:00:31,000 --> 00:00:33,040\r\nYou could go away, you could plan your words,\r\n\r\n15\r\n00:00:33,040 --> 00:00:35,060\r\nand then you could go back in and just quietly\r\n\r\n16\r\n00:00:35,060 --> 00:00:37,060\r\nsay to them, \"I was thinking about earlier\r\n\r\n17\r\n00:00:37,060 --> 00:00:39,030\r\n\"when you had that go at me, and I just think it was\r\n\r\n18\r\n00:00:39,030 --> 00:00:42,020\r\n\"a bit rude to do it like that, and maybe next time\r\n\r\n19\r\n00:00:42,020 --> 00:00:45,000\r\n\"you could talk to me quietly offline\r\n\r\n20\r\n00:00:45,000 --> 00:00:48,040\r\n\"rather than in front of everybody else.\"\r\n\r\n21\r\n00:00:48,040 --> 00:00:51,050\r\nMaybe there\'s a small but regular insult that you get\r\n\r\n22\r\n00:00:51,050 --> 00:00:54,070\r\nfrom somebody or something bad that they do to you.\r\n\r\n23\r\n00:00:54,070 --> 00:00:57,070\r\nWhy not quietly just sit down, plan how you\'re going\r\n\r\n24\r\n00:00:57,070 --> 00:01:02,010\r\nto tell them, pick a moment that suits you, and go for it.\r\n\r\n25\r\n00:01:02,010 --> 00:01:04,020\r\nBecause if you think about it, when they first attack you,\r\n\r\n26\r\n00:01:04,020 --> 00:01:05,060\r\nit\'s probably a moment that suits them.\r\n\r\n27\r\n00:01:05,060 --> 00:01:06,090\r\nIt probably doesn\'t suit you.\r\n\r\n28\r\n00:01:06,090 --> 00:01:10,030\r\nBut with this, you can choose the right moment for you.\r\n\r\n29\r\n00:01:10,030 --> 00:01:12,090\r\nSo have you had anything recently that you\'re still\r\n\r\n30\r\n00:01:12,090 --> 00:01:16,010\r\nthinking about, maybe even seething about?\r\n\r\n31\r\n00:01:16,010 --> 00:01:19,000\r\nAnd maybe for that, it\'d be a good idea to sit down,\r\n\r\n32\r\n00:01:19,000 --> 00:01:24,000\r\nmake a plan, go back to them, and get closure on it.\r\n\r\n"
                  },
                  new Video
                  {
                    Title = "Knowing the most effective words to use",
                    Slug = "knowing-the-most-effective-words-to-use",
                    Duration = 397,
                    DownloadUrl = "https://dms.licdn.com/playlist/C4D0DAQEs1G5X3IPZRg/learning-original-video-iphone-360/0/1598507500530?e=1619539200&v=beta&t=gS8o1f68xJxNlQUAEArnfm-aBzEmoX9AFj3ve7UgV2s#.mp4",
                    TranscriptLines = null,
                    Transcript = "1\r\n00:00:00,080 --> 00:00:04,090\r\n- Now the question is, what exact words should you use\r\n\r\n2\r\n00:00:04,090 --> 00:00:06,070\r\nwhen you want to tell someone something\r\n\r\n3\r\n00:00:06,070 --> 00:00:09,010\r\nthat they\'re not going to like hearing?\r\n\r\n4\r\n00:00:09,010 --> 00:00:11,040\r\nAnd this could be anything from,\r\n\r\n5\r\n00:00:11,040 --> 00:00:14,010\r\ntelling your boss that you want a raise,\r\n\r\n6\r\n00:00:14,010 --> 00:00:16,000\r\ntelling somebody that the noise of their music\r\n\r\n7\r\n00:00:16,000 --> 00:00:18,080\r\nthrough the wall is keeping you awake,\r\n\r\n8\r\n00:00:18,080 --> 00:00:21,090\r\nwanting to tell somebody that their meeting is badly run,\r\n\r\n9\r\n00:00:21,090 --> 00:00:25,010\r\nit could be anything, at home or at work.\r\n\r\n10\r\n00:00:25,010 --> 00:00:27,090\r\nWouldn\'t it be amazing if there was a magic\r\n\r\n11\r\n00:00:27,090 --> 00:00:30,020\r\nfour-step process that you could use\r\n\r\n12\r\n00:00:30,020 --> 00:00:33,000\r\nthat would work in any situation.\r\n\r\n13\r\n00:00:33,000 --> 00:00:36,090\r\nAnd there is, and I\'m gonna go through it with you now.\r\n\r\n14\r\n00:00:36,090 --> 00:00:39,050\r\nNow this four-step process isn\'t actually\r\n\r\n15\r\n00:00:39,050 --> 00:00:41,070\r\nguaranteed to work in any situation.\r\n\r\n16\r\n00:00:41,070 --> 00:00:45,000\r\nThis isn\'t gonna work if the person has no vested interest\r\n\r\n17\r\n00:00:45,000 --> 00:00:47,040\r\nin a good working relationship with you.\r\n\r\n18\r\n00:00:47,040 --> 00:00:49,080\r\nBut of course, in most home and work situations,\r\n\r\n19\r\n00:00:49,080 --> 00:00:52,050\r\nthe other person does have a vested interest\r\n\r\n20\r\n00:00:52,050 --> 00:00:54,090\r\nin keeping the relationship going, in which case,\r\n\r\n21\r\n00:00:54,090 --> 00:00:59,040\r\nthis four-step process is absolutely the best thing to use.\r\n\r\n22\r\n00:00:59,040 --> 00:01:02,090\r\nThe four-step process has the basic outline of\r\n\r\n23\r\n00:01:02,090 --> 00:01:08,030\r\nI understand, I feel, I want, Is that OK?\r\n\r\n24\r\n00:01:08,030 --> 00:01:10,000\r\nSo it consists of, first of all,\r\n\r\n25\r\n00:01:10,000 --> 00:01:12,020\r\nunderstanding their position and showing that\r\n\r\n26\r\n00:01:12,020 --> 00:01:14,000\r\nyou understand their position.\r\n\r\n27\r\n00:01:14,000 --> 00:01:18,050\r\nSecondly, explaining to them clearly how you feel.\r\n\r\n28\r\n00:01:18,050 --> 00:01:19,060\r\nAnd we\'ve already said you\'re gonna do this\r\n\r\n29\r\n00:01:19,060 --> 00:01:22,040\r\ncalmly and quietly, saying how you feel.\r\n\r\n30\r\n00:01:22,040 --> 00:01:26,010\r\nNot using facts and logic, but feelings.\r\n\r\n31\r\n00:01:26,010 --> 00:01:29,020\r\nThe third bit is to say what you want from the situation,\r\n\r\n32\r\n00:01:29,020 --> 00:01:31,050\r\nand a bit of planning beforehand might be required\r\n\r\n33\r\n00:01:31,050 --> 00:01:34,010\r\nto decide what it is that you want.\r\n\r\n34\r\n00:01:34,010 --> 00:01:37,070\r\nAnd then the fourth one is to say, \"Is that OK?\r\n\r\n35\r\n00:01:37,070 --> 00:01:39,090\r\n\"Is that a reasonable request do you think?\r\n\r\n36\r\n00:01:39,090 --> 00:01:42,020\r\n\"Could you do that for me?\"\r\n\r\n37\r\n00:01:42,020 --> 00:01:44,020\r\nI\'ll give you an example of this and then I\'ll explain\r\n\r\n38\r\n00:01:44,020 --> 00:01:47,070\r\nwhy this process is so important.\r\n\r\n39\r\n00:01:47,070 --> 00:01:48,090\r\nSuppose somebody\'s interrupting you\r\n\r\n40\r\n00:01:48,090 --> 00:01:50,030\r\nwhen you\'re busy at work.\r\n\r\n41\r\n00:01:50,030 --> 00:01:51,060\r\nYou could just say, \"Go away I\'m busy,\"\r\n\r\n42\r\n00:01:51,060 --> 00:01:53,000\r\nbut that\'s quite aggressive.\r\n\r\n43\r\n00:01:53,000 --> 00:01:55,060\r\nA nice assertive answer would be to use my\r\n\r\n44\r\n00:01:55,060 --> 00:01:59,040\r\nfour-step process and you\'d say,\r\n\r\n45\r\n00:01:59,040 --> 00:02:03,050\r\n\"I understand how urgent this is and see why you want it,\r\n\r\n46\r\n00:02:03,050 --> 00:02:06,000\r\n\"but I just feel a bit under pressure at the moment\r\n\r\n47\r\n00:02:06,000 --> 00:02:07,060\r\n\"with this work I\'m doing here.\r\n\r\n48\r\n00:02:07,060 --> 00:02:08,060\r\n\"I\'m doing this report.\r\n\r\n49\r\n00:02:08,060 --> 00:02:10,030\r\n\"I need to get it done by lunch time.\r\n\r\n50\r\n00:02:10,030 --> 00:02:12,020\r\n\"Maybe we could talk this afternoon.\r\n\r\n51\r\n00:02:12,020 --> 00:02:14,030\r\n\"Would that be OK?\"\r\n\r\n52\r\n00:02:14,030 --> 00:02:16,020\r\nSo you just follow the four-step process.\r\n\r\n53\r\n00:02:16,020 --> 00:02:18,060\r\nIt tells you what to say.\r\n\r\n54\r\n00:02:18,060 --> 00:02:22,070\r\nNow, why these four steps in the order they are?\r\n\r\n55\r\n00:02:22,070 --> 00:02:25,000\r\nAnd the reason is that steps two and three\r\n\r\n56\r\n00:02:25,000 --> 00:02:27,000\r\nare the slightly aggressive ones.\r\n\r\n57\r\n00:02:27,000 --> 00:02:29,010\r\nThe feel and the want steps of,\r\n\r\n58\r\n00:02:29,010 --> 00:02:30,070\r\nyou know, \"I don\'t wanna talk to you now.\r\n\r\n59\r\n00:02:30,070 --> 00:02:31,080\r\n\"Can we do it later?\"\r\n\r\n60\r\n00:02:31,080 --> 00:02:34,070\r\nis quite aggressive if you waded straight into that.\r\n\r\n61\r\n00:02:34,070 --> 00:02:38,070\r\nBut they\'ve got this fluffy exterior of steps one and four.\r\n\r\n62\r\n00:02:38,070 --> 00:02:41,010\r\nSo you say, \"I do understand, but,\"\r\n\r\n63\r\n00:02:41,010 --> 00:02:43,000\r\nI feel like this, I want this.\r\n\r\n64\r\n00:02:43,000 --> 00:02:44,080\r\n\"Is that OK?\"\r\n\r\n65\r\n00:02:44,080 --> 00:02:46,070\r\nSo, it\'s nice the way that two and three\r\n\r\n66\r\n00:02:46,070 --> 00:02:49,020\r\nhave got steps one and four outside them.\r\n\r\n67\r\n00:02:49,020 --> 00:02:51,000\r\nThat\'s why they\'re in that order.\r\n\r\n68\r\n00:02:51,000 --> 00:02:53,000\r\nAnd all four of them must be done.\r\n\r\n69\r\n00:02:53,000 --> 00:02:54,060\r\nIf you miss one of them out,\r\n\r\n70\r\n00:02:54,060 --> 00:02:56,080\r\nit won\'t be anything like as effective.\r\n\r\n71\r\n00:02:56,080 --> 00:02:59,050\r\nNow, after you\'ve done step four,\r\n\r\n72\r\n00:02:59,050 --> 00:03:02,000\r\nthere are two things that they might say.\r\n\r\n73\r\n00:03:02,000 --> 00:03:04,060\r\nThey may yes or they may say no.\r\n\r\n74\r\n00:03:04,060 --> 00:03:07,070\r\nNow what if they say yes and then they don\'t do it?\r\n\r\n75\r\n00:03:07,070 --> 00:03:09,020\r\nThey go, \"Yep, we\'re really sorry.\r\n\r\n76\r\n00:03:09,020 --> 00:03:10,070\r\n\"We\'ll turn the music down.\"\r\n\r\n77\r\n00:03:10,070 --> 00:03:12,040\r\nAnd then they don\'t.\r\n\r\n78\r\n00:03:12,040 --> 00:03:14,080\r\nWell, that\'s relatively straightforward because now\r\n\r\n79\r\n00:03:14,080 --> 00:03:17,030\r\nyou can get them on not keeping their promise.\r\n\r\n80\r\n00:03:17,030 --> 00:03:18,090\r\nYou can go back and say, \"Do you remember we had\r\n\r\n81\r\n00:03:18,090 --> 00:03:20,050\r\n\"that little conversation ten minutes ago\r\n\r\n82\r\n00:03:20,050 --> 00:03:21,090\r\n\"and you said you\'d turn the music down?\r\n\r\n83\r\n00:03:21,090 --> 00:03:24,020\r\n\"And you haven\'t.\r\n\r\n84\r\n00:03:24,020 --> 00:03:26,060\r\n\"Would it be possible to do that for me please?\"\r\n\r\n85\r\n00:03:26,060 --> 00:03:29,040\r\nSo once you\'ve got a yes out of them, it\'s fairly easy\r\n\r\n86\r\n00:03:29,040 --> 00:03:33,070\r\nto go back and say you haven\'t done what you said you\'d do.\r\n\r\n87\r\n00:03:33,070 --> 00:03:37,090\r\nBut what if they say, \"No, I\'m just not prepared to do that.\r\n\r\n88\r\n00:03:37,090 --> 00:03:40,010\r\n\"It\'s my party, I\'m having music, get stuffed.\"\r\n\r\n89\r\n00:03:40,010 --> 00:03:41,050\r\nWhat can you do then?\r\n\r\n90\r\n00:03:41,050 --> 00:03:43,080\r\nAnd what I\'d recommend if they say no is,\r\n\r\n91\r\n00:03:43,080 --> 00:03:46,010\r\ngo back around again.\r\n\r\n92\r\n00:03:46,010 --> 00:03:48,030\r\nAnd you can say, \"Well, I do understand it\'s your party.\r\n\r\n93\r\n00:03:48,030 --> 00:03:50,060\r\n\"It\'s great that you\'re doing that, but I really am\r\n\r\n94\r\n00:03:50,060 --> 00:03:52,080\r\n\"upset about the noise and all I want\r\n\r\n95\r\n00:03:52,080 --> 00:03:54,060\r\n\"is for you to turn it down a little bit.\r\n\r\n96\r\n00:03:54,060 --> 00:03:56,020\r\n\"Surely you could do that for me.\"\r\n\r\n97\r\n00:03:56,020 --> 00:03:58,040\r\nSo you go back around and you just jack up the words\r\n\r\n98\r\n00:03:58,040 --> 00:04:01,060\r\na little bit with, \"I really feel strongly,\"\r\n\r\n99\r\n00:04:01,060 --> 00:04:03,020\r\nand \"All I want\".\r\n\r\n100\r\n00:04:03,020 --> 00:04:05,030\r\nAnd if you go back around a second time,\r\n\r\n101\r\n00:04:05,030 --> 00:04:08,070\r\nit\'s gonna be a pretty good chance that it\'s gonna work.\r\n\r\n102\r\n00:04:08,070 --> 00:04:11,060\r\nNow, I just want to finally stress with this that\r\n\r\n103\r\n00:04:11,060 --> 00:04:16,030\r\nthis is not designed to batter the person into submission.\r\n\r\n104\r\n00:04:16,030 --> 00:04:19,000\r\nWe might be looking for some sort of working compromise\r\n\r\n105\r\n00:04:19,000 --> 00:04:21,020\r\nthat both parties can be happy with.\r\n\r\n106\r\n00:04:21,020 --> 00:04:23,090\r\nBecause, as we\'ve said earlier on this course,\r\n\r\n107\r\n00:04:23,090 --> 00:04:25,020\r\nit\'s all about rights.\r\n\r\n108\r\n00:04:25,020 --> 00:04:28,030\r\nYou\'ve got rights but so have they.\r\n\r\n109\r\n00:04:28,030 --> 00:04:31,000\r\nAnd sometimes what you\'ll find is the other person\r\n\r\n110\r\n00:04:31,000 --> 00:04:32,070\r\nis reasonably assertive as well.\r\n\r\n111\r\n00:04:32,070 --> 00:04:36,010\r\nIn fact, what if both of you have watched this video\r\n\r\n112\r\n00:04:36,010 --> 00:04:37,040\r\nand know about this technique?\r\n\r\n113\r\n00:04:37,040 --> 00:04:39,010\r\nWhat\'s gonna happen then?\r\n\r\n114\r\n00:04:39,010 --> 00:04:41,000\r\nAnd the answer is, it will still be fine.\r\n\r\n115\r\n00:04:41,000 --> 00:04:43,030\r\nIt\'s just good communication.\r\n\r\n116\r\n00:04:43,030 --> 00:04:45,000\r\nI\'ve got an example here that actually is\r\n\r\n117\r\n00:04:45,000 --> 00:04:46,090\r\nbased on a real friend of mine.\r\n\r\n118\r\n00:04:46,090 --> 00:04:49,060\r\nAnd what happened was that his wife said to him,\r\n\r\n119\r\n00:04:49,060 --> 00:04:53,020\r\nand she pretty much used the four-step process of,\r\n\r\n120\r\n00:04:53,020 --> 00:04:55,030\r\n\"I know that you don\'t like cooking\r\n\r\n121\r\n00:04:55,030 --> 00:04:57,080\r\n\"but I feel a bit neglected when you don\'t cook me food.\r\n\r\n122\r\n00:04:57,080 --> 00:05:00,060\r\n\"I would really like it if you cook me an occasional meal.\r\n\r\n123\r\n00:05:00,060 --> 00:05:03,060\r\n\"Would you do that for me?\"\r\n\r\n124\r\n00:05:03,060 --> 00:05:07,060\r\nAnd he then could have replied,\r\n\r\n125\r\n00:05:07,060 --> 00:05:10,040\r\n\"Well, I can understand why you\'d like me to cook for you,\r\n\r\n126\r\n00:05:10,040 --> 00:05:14,020\r\n\"but I feel really tired when I get back home from work\r\n\r\n127\r\n00:05:14,020 --> 00:05:17,030\r\n\"and I hate cooking and, all I want\r\n\r\n128\r\n00:05:17,030 --> 00:05:18,090\r\n\"is for you to cook the food.\r\n\r\n129\r\n00:05:18,090 --> 00:05:21,010\r\n\"Surely you could do that for me, couldn\'t you?\"\r\n\r\n130\r\n00:05:21,010 --> 00:05:22,060\r\nAnd then she could use the next one and say,\r\n\r\n131\r\n00:05:22,060 --> 00:05:24,090\r\n\"Well, I can understand why you would hate cooking\r\n\r\n132\r\n00:05:24,090 --> 00:05:26,060\r\n\"but I do really feel quite neglected\r\n\r\n133\r\n00:05:26,060 --> 00:05:28,050\r\n\"and all I want is the occasional meal.\r\n\r\n134\r\n00:05:28,050 --> 00:05:30,030\r\n\"Surely you could cook for me occasionally?\"\r\n\r\n135\r\n00:05:30,030 --> 00:05:33,000\r\nAnd they could go round and round forever, couldn\'t they?\r\n\r\n136\r\n00:05:33,000 --> 00:05:36,010\r\nBut the point is, by using this process,\r\n\r\n137\r\n00:05:36,010 --> 00:05:39,050\r\nthey\'re both saying how they feel and what they want.\r\n\r\n138\r\n00:05:39,050 --> 00:05:42,000\r\nAnd they\'re both checking with the other person\r\n\r\n139\r\n00:05:42,000 --> 00:05:44,010\r\nand saying, \"Can you see it from my point of view?\"\r\n\r\n140\r\n00:05:44,010 --> 00:05:45,070\r\nAnd hopefully they can work out some sort of\r\n\r\n141\r\n00:05:45,070 --> 00:05:49,020\r\nworking compromise where, maybe he cooks occasionally\r\n\r\n142\r\n00:05:49,020 --> 00:05:50,090\r\nor maybe they eat out once a week\r\n\r\n143\r\n00:05:50,090 --> 00:05:53,030\r\nor have a takeaway or something like that.\r\n\r\n144\r\n00:05:53,030 --> 00:05:56,050\r\nSo this technique could save a marriage.\r\n\r\n145\r\n00:05:56,050 --> 00:05:59,050\r\nSo, that\'s the four-step process.\r\n\r\n146\r\n00:05:59,050 --> 00:06:03,040\r\nI understand, I feel, I want, Is that OK?\r\n\r\n147\r\n00:06:03,040 --> 00:06:05,020\r\nAnd I\'d like you to just think about\r\n\r\n148\r\n00:06:05,020 --> 00:06:08,000\r\nwhich of those four steps you tend to forget.\r\n\r\n149\r\n00:06:08,000 --> 00:06:09,080\r\nYou know, maybe you don\'t always say how you feel\r\n\r\n150\r\n00:06:09,080 --> 00:06:12,000\r\nor maybe you\'re not very clear on what you want\r\n\r\n151\r\n00:06:12,000 --> 00:06:13,080\r\nor perhaps, you don\'t always finish\r\n\r\n152\r\n00:06:13,080 --> 00:06:16,000\r\nwith that fourth step of saying,\r\n\r\n153\r\n00:06:16,000 --> 00:06:18,000\r\n\"Do you think that\'s a reasonable request?\"\r\n\r\n154\r\n00:06:18,000 --> 00:06:20,070\r\nSo you can practice one step at a time\r\n\r\n155\r\n00:06:20,070 --> 00:06:24,020\r\nuntil you get really smooth at using all the four steps.\r\n\r\n156\r\n00:06:24,020 --> 00:06:26,030\r\nBut you could also think of a particularly difficult\r\n\r\n157\r\n00:06:26,030 --> 00:06:28,090\r\nsituation you\'ve got coming up\r\n\r\n158\r\n00:06:28,090 --> 00:06:31,030\r\nand you could actually work out what you\'re gonna say\r\n\r\n159\r\n00:06:31,030 --> 00:06:33,070\r\nfor each of those four steps so that\r\n\r\n160\r\n00:06:33,070 --> 00:06:37,000\r\nyou\'re ready to use it in a real situation.\r\n\r\n"
                  }
                }
              },
              new Chapter
              {
                Title = "Conclusion",
                Videos = new List<Video>
                {
                  new Video
                  {
                    Title = "Wrapping up",
                    Slug = "wrapping-up",
                    Duration = 51,
                    DownloadUrl = "https://dms.licdn.com/playlist/C4D0DAQFDi67nl0eY1A/learning-original-video-iphone-360/0/1598507325810?e=1619539200&v=beta&t=12oCHsZGlN6zt6H5fPfnOgBYsobHzRqu_J5q-EN-Kzk#.mp4",
                    TranscriptLines = null,
                    Transcript = "1\r\n00:00:01,010 --> 00:00:01,080\r\n- So in this course,\r\n\r\n2\r\n00:00:01,080 --> 00:00:04,030\r\nI\'ve covered what assertiveness is\r\n\r\n3\r\n00:00:04,030 --> 00:00:06,090\r\nand a whole lot of techniques that you can use\r\n\r\n4\r\n00:00:06,090 --> 00:00:09,020\r\nincluding my four step process.\r\n\r\n5\r\n00:00:09,020 --> 00:00:12,000\r\nGoing up from the one-off to the habit.\r\n\r\n6\r\n00:00:12,000 --> 00:00:14,040\r\nI notice, I interpret, am I right?\r\n\r\n7\r\n00:00:14,040 --> 00:00:18,070\r\nDetachment and commenting on the process.\r\n\r\n8\r\n00:00:18,070 --> 00:00:22,020\r\nThe next step for you now is to try some of these out.\r\n\r\n9\r\n00:00:22,020 --> 00:00:24,070\r\nMaybe pick your most difficult work colleague\r\n\r\n10\r\n00:00:24,070 --> 00:00:26,060\r\nand make a plan for how you\'re going to use this\r\n\r\n11\r\n00:00:26,060 --> 00:00:29,080\r\nnew material to handle that person better.\r\n\r\n12\r\n00:00:29,080 --> 00:00:32,070\r\nAnd I\'d be delighted if you wanted to keep in touch with me.\r\n\r\n13\r\n00:00:32,070 --> 00:00:36,000\r\nYou could follow my blog at chriscrofttraining.co.uk\r\n\r\n14\r\n00:00:36,000 --> 00:00:38,000\r\nand get my email tip of the month\r\n\r\n15\r\n00:00:38,000 --> 00:00:40,030\r\nat free-management-tips.co.uk\r\n\r\n16\r\n00:00:40,030 --> 00:00:43,020\r\nand connect with me on LinkedIn.\r\n\r\n17\r\n00:00:43,020 --> 00:00:45,060\r\nIt\'s been a pleasure having you with me on this course\r\n\r\n18\r\n00:00:45,060 --> 00:00:48,040\r\nand I\'d like to wish you good luck with how you apply it\r\n\r\n19\r\n00:00:48,040 --> 00:00:51,000\r\nand the results that it will give you.\r\n\r\n"
                  }
                }
              }
            },
            Title = "Learning to Be Assertive",
            ExerciseFiles = new List<ExerciseFile>
            {
              new ExerciseFile
              {
                FileName = "Ex_Files_Assertive.zip",
                DownloadUrl = "https://files3.lynda.com/secure/courses/175640/exercises/Ex_Files_Assertive.zip?FeAuFkiW5Jr6IliZwFyZTEBFci40dNqRlSJMsuCNIxWeROLgTGxdE8YRnENUviXzxLybIR7YJra4E4C05JvhQz254IEYLDZWuOXnqMISomjU37cmS8OKz0_jbVWqnXsfoffFiYtKNT_-h95D__W_7H3Gh45c"
              }
            },
            Slug = "learning-to-be-assertive"
        };
    }
}
