# PostBot 3000 AI Agent

Try it out: [PostBot 3000](https://postbot3000.vercel.app/)

PostBot 3000 is an `open-source` project that shows how to build a powerful AI agent and stream responses and generate artifacts. This project makes it easier for anyone looking to implement similar solutions.

## Features

1. **OpenSource:** All the code (`agent-ui` & `agent-service`) is open-source and available on GitHub.
2. **Artifacts:** The posts content generated by agent is streamed in Artifacts (like `Claude`).
3. **Agent Python Backend:** The agent is built using `LangGraph` `Python`, for AI workflows and FastAPI for creating a robust API.

### Agent Workflow

![agent](./agent-service//app/graph_image.png)

### Agent In Action

![AgentUI Action](agentui-action.png)

## Tech Stack

- [LangGraph](https://langchain-ai.github.io/langgraph)
- [Vercel AI SDK](https://sdk.vercel.ai/docs/introduction)
- [gpt-4o-mini](https://platform.openai.com/docs/models/gpt-4o-mini)
- [FastAPI](https://fastapi.tiangolo.com)
- [Next.js](https://nextjs.org/)
- [TailwindCSS](https://tailwindcss.com)
- [Clerk Auth](https://clerk.com)
- [Upstash Redis](https://upstash.com)

## Try it Out

1. Clone the repository

```bash
git clone https://github.com/ahmad2b/postbot3000.git
```

2. Create a `.env` file based on the `.env.example` file and add your API in both `agent-service` and `agent-ui` directory.

3. Install the dependencies for `agent-service`:

```bash
cd agent-service
poetry install
```

4. Run the development server for `agent-service`:

```bash
poetry run uvicorn app.main:app --reload
```

5. Install the dependencies for `agent-ui`:

```bash
cd agent-ui
npm install
# or
yarn install
# or
pnpm install
```

6. Run the development server for `agent-ui`:

```bash
npm run dev
# or
yarn dev
# or
pnpm dev
```

7. Open http://localhost:3000 with your browser to see the result.

---

## Community & Connect

I'm excited to see this project helping developers build better AI agents! If you're exploring AI agents or building something exciting, I'd love to hear about your journey.

Find me around the web:

- 📧 Email: ahmadshaukat_4@outlook.com
- 📍 LinkedIn: [ahmad2b](https://www.linkedin.com/in/ahmad2b)
- 🐦 Twitter: [@mahmad2b](https://x.com/mahmad2b)

If this project helped your development journey, consider giving it a ⭐ to help others find it!

---

#### Inspiration

- Agent UI: [Vercel Template](https://vercel.com/templates/next.js/nextjs-ai-chatbot)
- Agent Service: [MLExpert by Venelin Valkov](https://www.mlexpert.io/bootcamp/write-social-media-content-with-agents)
