# Cafe duty
Simple web application that, given a list of people, schedules a task that should be executed in pairs.
Includes a dashboard to show the people currently assigned to the task.

## How to use
- **Create a Team:** Navigate to `<your-host>:3000/` and click on `New team`. Follow the instructions.
- **Show Dashboard:** Navigate to `<your-host>:3000/web/team/<Your team name>`

## How to install
- Install Docker. Instructions [here](https://docs.docker.com/engine/installation/)
- Pull image `afcastano/hs-cafe-duty` from [DockerHub](https://hub.docker.com/r/afcastano/hs-cafe-duty/)
- Run `docker run --rm -p 3000:3000 -v ${LOCAL_DB_PATH}:/cafe-duty/db afcastano/hs-cafe-duty`
- Navigate to http://localhost:3000

## Development
- This is a Haskell application. You need to install [stack](https://docs.haskellstack.org/en/stable/README/).
- First time usage: `stack setup`
- build: `stack build`
- run: `./run.sh`
- ghci: `stack ghci`

## Deploy
- To create a docker image to deploy: `docker build -t afcastano/hs-cafe-duty:latest .` this will create the image afcastano/hs-cafe-duty
- to run the image: `docker run --rm -p 3000:3000 -v ${LOCAL_DB_PATH}:/cafe-duty/db afcastano/hs-cafe-duty`

## Extra info
- The scheduling algorithm is based on [this](http://stackoverflow.com/questions/41896889/algorithm-to-schedule-people-to-an-activity-that-should-be-done-in-pairs) and [this](https://en.wikipedia.org/wiki/Round-robin_tournament#Scheduling_algorithm)
- The app does not use any database. Just plain json files.
- There is no security enabled in the app. Anyone can complete the task and assign new people.

# Contributors are welcome!
Contact me for instructions.

# Extra links
- [TODO's](docs/TODO.md)
- [Dev tips](docs/dev_tips.md)
