# The AI Wiki

Let's explore some of the most common Ai-related terms. 


## The AI Vocabulary

|Term|Definition|Links and Related Material|
|---|---|---|
|AI - Artificial Intelligence|A branch of computer science that teaches computers to make predictions and decisions|You find a number of tutorials and readings [here](README.md)|
|AI Engineer|---|---|
|AI Researcher|---|---|
|Algorithm|A process or set of rules to be followed in calculations or other problem-solving operations, especially by a computer, like a recipe instruction. |For exploring more[join me](https://en.wikipedia.org/wiki/Algorithm)|
|Bias|---|---|
|Big Data|---|---|
|CNN - Convolutional Neural Network|---|---|
|Computer Vision|A branch of AI that works on computer's abilitis to understand visual information, like pictures or videos.|---|
|Data|Information, that is recorded in different ways, e.g. numbers, text, pictures |---|
|Data Analyst|---|---|
|Data Architect|---|---|
|Data Cleaning|Often data comes with errors, like sensor errors, missing data, etc. Before it is used as training data, the errors need to be eliminated. e.g. the outliers filtered, the missing fields dropped or filled with mean data etc.|---|
|Data Preprocessing| Often data does not come in a way that can be directly used by the AI. The data has to be restructured, reshaped and cleaned|---|
|Data Set|A collection of data|---|
|Data Scientist|---|---|
|Decision Tree|---|---|
|Feature|---|---|
|GAN - Generative Adversarian Network|---|---|
|GPT-3|---|
|Impact|---|---|
|Intelligence|---|---|
|Interaction Bias|---|---|
|Keras| Keras is an open-source AI tool- a neural network library written in Python just like TensorFlow, but it is not meant to be an end-to-end machine learning framework. |[Keras](https://keras.io/)|
|Latent Bias|---|---|
|Learning|---|---|
|Library| A group of functions for a programming language that can be used by the programmers so that they do not have to rewrite them by theirself.|---|
|Metadata|Information in about an object. Taking a picture as example, the metadata is information about when it was taken, where, by whom etc.|---|
|ML - Machine Learning|A branch of AI, where computers build models to classify and categorize data|You find a number of tutorials and readings [here](README.md)|
|ML Engineer|---|---|
|Model|The functions a machine has learned to make predictions and decisions.|---|
|Naive Bayes|---|---|
|Natural Interaction|---|---|
|NLP - Natural Language Processing|---|---|
|Neural Network|Several conncted functions, that collectively recognize patterns and make decisions|---|
|Selection Bias|---|---|
|Scki-kit Learn| Sci-kit learn is a very powerful Python library for machine learning that is majorly used in building models. Built using other libraries such as numpy, SciPy, and matplotlib, it is very efficient for statistical modeling techniques such as classification, regression, and clustering. Sci-kit learn comes with features such as supervised learning algorithms, unsupervised learning algorithms, and cross-validation.|[scikit-learn](https://scikit-learn.org/stable/)  [Linear Regression Using Python scikit-learn](https://dzone.com/articles/linear-regression-using-python-scikit-learn)|
|Strong AI|A strong AI is an AI that develops general concepts of the world around it, it gains a common understanding. A stong AI is what we encounter in sci-fi films, like Terminator, Matrix or EX-Machina. It does not exist in the real world at the presence. |---|
|TensorFlow| TensorFlow is a free and open-source software library for dataflow and differentiable programming across a range of tasks. It is a symbolic math library, and is also used for machine learning applications such as neural networks. |[TensorFlow](https://www.tensorflow.org/) |
|Testing / Validating|---|---|
|Test Set|A data set, that is used to test the AI's results. Usually a data set is split between training and testing data. The testing data set is usually smaller than the training set, but can also be up to 50%, depending on the size of the dataset.|---|
|Training|---|---|
|Training Set|A data set, that is used to train an AI. Usually a data set is split between training and testing data. The training data set is usually larger than the testing data set.|---|
|Perception|---|---|
|Population|---|---|
|Python|An open source programming language with a broad collection of libraries for data science and machine learning.|[Python](https://www.python.org/)|
|Pytorch| PyTorch is an open source machine learning library based on the Torch library, used for applications such as computer vision and natural language processing, primarily developed by Facebook's AI Research lab. |[Pytorch](https://pytorch.org/) |
|R|---|---|
|RNN - Recurrent Neural Networks|---|---|
|Regression|---|---|
|Researcher|---|---|
|Representation and Reasoning|---|---|
|Watson|---|---|
|Weak AI|An AI that is designed to fulfill one specific task only, like detecting faces in images.|---|
