# 搜索引擎指南
[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square)](https://github.com/aeilot/HowToUseSearchEngines/pulls)

这份教程由 [@aeilot](https://aeilot.top) 创作，语言简洁，专门解决青少年不熟悉搜索引擎而去问别人的情况。当然作者也有时会出现一些错误，欢迎提交 PR 来纠正，也欢迎大家把这份教程翻译到其他语言！👏 [Gitee 镜像](https://gitee.com/louis-code/HowToUseSearchEngines)

## 目录
  * [简介](#简介)
  * [认识搜索引擎](#认识搜索引擎)
    * [搜索引擎的代表](#搜索引擎的代表)
  * [如何高效检索](#如何高效检索)
    * [言简](#言简)
    * [意骇](#意骇)
  * [高级技巧](#高级技巧)
    * [一举多得](#一举多得)
    * [让搜索引擎为你做减法](#让搜索引擎为你做减法)
    * [我只想看这一个网站怎么办](#我只想看这一个网站怎么办)
    * [限定文件格式](#限定文件格式)
    * [限定网址](#限定网址)
    * [限定标题](#限定标题)
    * [告诉搜索引擎搜索的是作品](#告诉搜索引擎搜索的是作品)
    * [告诉搜索引擎不要拆开关键词](#告诉搜索引擎不要拆开关键词)
  * [推荐阅读](#推荐阅读)
  * [特别鸣谢](#特别鸣谢)
  * [参考资料](#参考资料)

## 简介

最近我经常遇到一些同学，经常跑来问我一些很明显在搜索引擎上面就可以搜到的问题。我问他们为什么不去网上搜，却发现其实他们搜过，只是效果不好：有些人直接把一整个问句打上去了，还有人漏关键字。这些都是他们没有掌握搜索引擎使用的精髓。所以，我写了这个教程，帮助解决搜索引擎的使用问题。

## 认识搜索引擎

我这里说的搜索引擎是指网络搜索引擎。下面给出[维基百科](https://zh.wikipedia.org/wiki/网络搜索引擎)中的定义：

> 网络搜索引擎（英语：web search engine）是设计在万维网上进行搜索，意思是指自动从万维网搜集特定的信息，提供给用户进行查询的系统。

搜索引擎的工作原理大致可以分为搜集信息、整理信息和接受查询。**为了使文章简单，更深入的知识我在这里就不展开了，本文以如何使用为主。** 

### 搜索引擎的代表

* [百度](https://www.baidu.com)
* [必应](https://www.bing.com)
* [搜狗](https://www.sogou.com)
* [360搜索](https://www.so.com)
* [谷歌](https://www.google.com)
* [Yandex](https://yandex.com)

还有学术型搜索引擎：
* [百度学术](https://xueshu.baidu.com)
* [谷歌学术](https://scholar.google.com)

## 如何高效检索

我认为，高效检索只需要注意：言简、意骇

### 言简

言简，顾名思义，就是让你的搜索尽可能更简单。在搜索的时候，应该对问题提取关键词。比如，我想要知道`高锰酸钾制取氧气的文字表达式是什么`时，我仅仅需要写`高锰酸钾制取氧气 文字表达式` 即可；同样的，在查询`怎么写检讨书时`，甚至只需搜索`检讨书`；在想知道`《将进酒》是谁写的`，只用查询`将进酒 作者`。如果不确定要搜索的内容名称，应该做更少的准确限定，换为更零散的关键词。如果是英文，则应去除复数和第三人称复数。虽然某些搜索引擎在进行查询的时候会自动去除掉 「xxx的xxx」这种词汇和标点符号，但在搜索时还是应该尽量减少他们的使用。也尽可能不要出现 「如何」「怎样」这些疑问词，更不需要和搜索引擎讲礼貌——不要出现类似「请问寒假什么时候放假？」而是写成「寒假放假时间」。

### 意骇

意骇，就是把你的搜索描述的尽可能完备。不要一昧地追求简单，在有些情况下还是需要给出限定的：比如，在搜索`苹果`时，如果你指的是水果的苹果，那为了提升效率，最好写`苹果 水果`；同理，想要搜索苹果公司，则应该写`苹果 公司`，这可以简化为`苹果公司`。如果不进行限定，有可能搜索结果第一页都会被此关键词的其他意思所充满，在搜寻时，就会降低效率。

更加高级的限定方法，请见[高级技巧](#高级技巧)。

## 高级技巧

### 一举多得

如果我在搜索的时候，想同时获得多个关键词的结果，我可以使用 `|`，即“或”。**注意：用`|`分隔关键词的时候，一定要加上空格，`|`必须要是半角的**，举个例子：`东京 | 塔`。

### 让搜索引擎为你做减法

如果我在搜索的时候，不想获得某个关键词的结果，我可以使用 `-`，即“减”。**注意：用`-`，一定要在之前加上空格**，举个例子：`苹果 -水果`。

### 我只想看这一个网站怎么办

如果我只想获得某个网站的结果，可以在**整个搜索之前或之后**加上 `site:xxx网站`，比如：`site:blog.aeilot.top 数码`。

### 限定文件格式

如果我只想搜索一种格式的文件，可以在**整个搜索之前或之后**加上 `filetype:xxx网站`，比如：`filetype:pdf 物理课本`。不指定文件类型搜索文件时，可以使用`filetype:all`。

### 限定网址

如果我想让我的搜索结果的网址都包含某一字段，可以加上 `inurl:xxx`，比如：`inurl:pan PPT模版`，就可以找到网址带`pan`的所有相关结果。

### 限定标题

如果我想让我的搜索结果的标题都包含某一字段，可以加上 `intitle:xxx`，比如：`intitle:免费 PPT模版`，就可以找到标题带`免费`的所有相关结果。

### 告诉搜索引擎搜索的是作品

如果我搜索的是作品，如文学作品、艺术作品，可以加上书名号，比如：`《星际穿越》`。

### 告诉搜索引擎不要拆开关键词

如果我不想要拆开搜索的关键词，可以加上引号，比如：`“九年级化学“`

## 推荐阅读
1. [知乎 - 如何高效地使用搜索引擎](https://www.zhihu.com/question/28013848)

## 特别鸣谢
* [MrWillCom](https://github.com/MrWillCom) 他对我的创作进行了指导。
* [Cathy Aeilot](https://github.com/QD-lazy-tm) 她启发了我写这份教程。

## 参考资料
1. [网络搜索引擎 -- 维基百科](https://zh.wikipedia.org/wiki/网络搜索引擎)
