<!--lint disable awesome-list-item-->
<div align="center">
  <p align="center">
    <img alt="Medusa" src="https://uploads-ssl.webflow.com/61fba9f6deac297b7b22017d/62000006ce573a706c92546c_logo.svg" width="200" />
  </p>
<h1>Awesome MedusaJS</h1>
<p>A curated list of awesome resources related to MedusaJS</p>

<a href="#resources">Resources</a>
&nbsp;&nbsp;&nbsp;
<a href="CONTRIBUTING.md">Contribution guide</a>
&nbsp;&nbsp;&nbsp;
<a href="https://docs.medusajs.com/">Official documentation</a>

  <a href="https://awesome.re">
    <img src="https://awesome.re/badge.svg" alt="Awesome">
  </a>
</div>

[![GitNFT](https://img.shields.io/badge/%F0%9F%94%AE-Open%20in%20GitNFT-darkviolet?style=flat)](https://gitnft.quine.sh/app/commits/list/repo/awesome-medusajs)

# Contents <!-- omit in toc -->

- [Resources](#resources)
- [Projects using MedusaJS](#projects-using-medusajs)
- [Starters](#starters)
- [Packages and plugins](#plugins-and-packages)
- [Contribute](#contribute)
---

<!--lint enable awesome-list-item-->

![Admin dashboard revamp](https://uploads-ssl.webflow.com/61fba9f6deac297b7b22017d/61fec76b67fa73688f7b7d2d_test-oli-p-2000.png)

# Resources

- Information
    - [Notion](https://medusajs.notion.site/medusajs/Medusa-Home-3485f8605d834a07949b17d1a9f7eafd)

- Official Resources
  - [Website](https://www.medusajs.com/)
  - [Official Guide](https://docs.medusajs.com/)
  - [GitHub Repo](https://github.com/medusajs/medusa)

- Demo
  - [Admin panel](https://demo.medusa-commerce.com/) - Maqnage your anything related to your store
  - [Gatsby storefront](https://start.medusajs.com/) - Sell your product across the web
  - [Medusa express checkout](https://www.medusa.express/) - Easy checkout flow where you need it
  
- Community
  - [Discord](https://discord.gg/xpCwq3Kfn8)
  - [Twitter](https://twitter.com/intent/follow?screen_name=medusajs)
  - [Twitch](https://www.twitch.tv/medusajs)
  - [Linkedin](https://www.linkedin.com/company/medusa-commerce)
  - [dev.to](https://dev.to/medusajs)

# Projects using MedusaJS

We are aware of a lot of different projects using Medusa in production - from scale ups to public companies. Unfortunately we cannot share all of them as most are larger projects guarded by NDAs or without explicit consent to be shared.
A few of the projects we are allowed to share are Tekla, Dubray, Palmes and Bryant Dental.

- [Teklafabrics](https://teklafabrics.com/)
- [Palmes](https://palmes.co/)
- [Dubray Books](https://www.dubraybooks.ie/)
- [Bryant Dental](https://bryant.dental/)

# Starters

- [Gatsby starter](https://github.com/medusajs/gatsby-starter-medusa)
- [Nextjs starter](https://github.com/medusajs/nextjs-starter-medusa)
- [Gatsby Medusa express](https://github.com/medusajs/medusa-express-gatsby)
- [Nextjs Medusa express](https://github.com/medusajs/medusa-express-nextjs)
- [Plugin starter (Typescript)](https://github.com/adrien2p/medusa-plugin-starter-ts)
- [Next.js Medusa Tailwind starter](https://github.com/avneesh0612/next-medusa-tailwind-template)
- [Medusa-extender server](https://github.com/adrien2p/medusa-extender/tree/main/starters/server)
- [Medusa-extender Shareable module](https://github.com/adrien2p/medusa-extender/tree/main/starters/plugin-module)
- [Medusa marketplace tutorial](https://github.com/shahednasser/medusa-marketplace-tutorial)
- [Medusa marketplace plugin tutorial](https://github.com/shahednasser/medusa-marketplace)
- [Medusa storefront](https://github.com/itswadesh/svelte-commerce)

# Plugins and packages

### Customisation

- [medusa extender](https://github.com/adrien2p/medusa-extender) ![source](https://img.shields.io/static/v1?label=community&message=&nbsp;&color=blue&style=flat-square) ![stars](https://img.shields.io/github/stars/adrien2p/medusa-extender)  
Customise your medusa project eith ease and create whatever you need with a scalable and testable architecture.

### Authentication

- [OAuth 2 authentication](https://github.com/adrien2p/medusa-plugins/tree/main/packages/medusa-plugin-auth) ![source](https://img.shields.io/static/v1?label=community&message=&nbsp;&color=blue&style=flat-square) ![stars](https://img.shields.io/github/stars/adrien2p/medusa-plugins)  
Social authentication for the admin and store client. Google, Facebook, Twitter, etc... (Google is available but a lot more will come soon)

### Analytics

- [Segment](https://docs.medusajs.com/add-plugins/segment)  ![source](https://img.shields.io/static/v1?label=official&message=&nbsp;&color=green&style=flat-square) ![stars](https://img.shields.io/github/stars/medusajs/medusa?color=green)  
Segment collects events from your web & mobile apps and provides a complete data toolkit to every team in your company

- [Jitsu](https://github.com/joseantcordeiro/medusa-plugin-jitsu) ![source](https://img.shields.io/static/v1?label=official&message=&nbsp;&color=green&style=flat-square) ![stars](https://img.shields.io/github/stars/medusajs/medusa?color=green)  
Jitsu is a fully-scriptable data ingestion engine for modern data teams. Set-up a real-time data pipeline in minutes, not days

- [Sentry](https://github.com/adrien2p/medusa-plugins/tree/main/packages/medusa-plugin-sentry) ![source](https://img.shields.io/static/v1?label=community&message=&nbsp;&color=blue&style=flat-square) ![stars](https://img.shields.io/github/stars/adrien2p/medusa-plugins)  
A sentry integration. JavaScript Error and Performance Monitoring Resolve JavaScript errors with max efficiency, not max effort. Get actionable insights to resolve JavaScript performance issues with the ability to track, debug, and resolve JavaScript errors across platforms.

- [Sentry UI](https://github.com/adrien2p/medusa-plugins/tree/main/packages/medusa-plugin-sentry-use) ![source](https://img.shields.io/static/v1?label=community&message=&nbsp;&color=blue&style=flat-square) ![stars](https://img.shields.io/github/stars/adrien2p/medusa-plugins)  
An admin sentry dashboard. JavaScript Error and Performance Monitoring Resolve JavaScript errors with max efficiency, not max effort. Get actionable insights to resolve JavaScript performance issues with the ability to track, debug, and resolve JavaScript errors across platforms.

- [Prometheus](https://github.com/adrien2p/medusa-plugins/tree/main/packages/medusa-plugin-prometheus) ![source](https://img.shields.io/static/v1?label=community&message=&nbsp;&color=blue&style=flat-square) ![stars](https://img.shields.io/github/stars/adrien2p/medusa-plugins)  
A prometheus integration. swagger-stats traces REST API requests and responses in Node.js Microservices, and collects statistics per API Operation. swagger-stats detects API operations based on express routes. You may also provide Swagger (Open API) specification, and swagger-stats will match API requests with API Operations defined in swagger specification. The data can be served to kibana through ElasticSearch or can also be consumed by Grafana

### Contente Management System

- [Contentful](https://docs.medusajs.com/add-plugins/contentful) ![source](https://img.shields.io/static/v1?label=official&message=&nbsp;&color=green&style=flat-square) ![stars](https://img.shields.io/github/stars/medusajs/medusa?color=green)  
By integrating Contentful to Medusa, you can benefit from powerful features in your ecommerce store including detailed product CMS details, easy-to-use interface to use for static content and pages, localization, and much more.

- [Strapi](https://docs.medusajs.com/add-plugins/strapi) ![source](https://img.shields.io/static/v1?label=official&message=&nbsp;&color=green&style=flat-square) ![stars](https://img.shields.io/github/stars/medusajs/medusa?color=green)  
By integrating Strapi to Medusa, you can benefit from powerful features in your ecommerce store including detailed product CMS details, two-way sync, an easy-to-use interface to use for static content and pages, and much more.

### Search
  
- [Meilisearch](https://docs.medusajs.com/add-plugins/meilisearch) ![source](https://img.shields.io/static/v1?label=official&message=&nbsp;&color=green&style=flat-square) ![stars](https://img.shields.io/github/stars/medusajs/medusa?color=green)  
MeiliSearch also provides a pleasant developer experience, as it is extremely intuitive and newcomer-friendly. So, even if you're new to the search engine ecosystem, their documentation is resourceful enough for everyone to go through and understand.

- [Algolia](https://docs.medusajs.com/add-plugins/algolia) ![source](https://img.shields.io/static/v1?label=official&message=&nbsp;&color=green&style=flat-square) ![stars](https://img.shields.io/github/stars/medusajs/medusa?color=green)  
Algolia can be used for a wide range of use cases, including ecommerce websites. By integrating Algolia into your ecommerce website, you can provide your customers with a better user experience and help them find what they’re looking for swifltly.

- [Elasticsearch](https://www.npmjs.com/package/medusa-plugin-elasticsearch) ![source](https://img.shields.io/static/v1?label=community&message=&nbsp;&color=blue&style=flat-square) ![stars](https://img.shields.io/github/stars/peterborodatyy/medusa-plugin-elasticsearch) 
Elasticsearch is a seamless and intuitive search engine solution. Its developer-friendly nature and comprehensive documentation make it accessible to all. Enhance your ecommerce website with Elasticsearch for swift and efficient searches, providing a superior user experience to your customers.

### File storage and management
  
- [Spaces](https://docs.medusajs.com/add-plugins/spaces) ![source](https://img.shields.io/static/v1?label=official&message=&nbsp;&color=green&style=flat-square) ![stars](https://img.shields.io/github/stars/medusajs/medusa?color=green)  
S3-compatible object storage with a built-in CDN that makes data storage and delivery easy, reliable, and affordable.

- [S3](https://docs.medusajs.com/add-plugins/s3) ![source](https://img.shields.io/static/v1?label=official&message=&nbsp;&color=green&style=flat-square) ![stars](https://img.shields.io/github/stars/medusajs/medusa?color=green)  
Amazon Simple Storage Service (Amazon S3) is an object storage service that offers industry-leading scalability, data availability, security, and performance

- [Minio](https://github.com/medusajs/medusa/tree/master/packages/medusa-file-minio) ![source](https://img.shields.io/static/v1?label=official&message=&nbsp;&color=green&style=flat-square) ![stars](https://img.shields.io/github/stars/medusajs/medusa?color=green)  
Minio is an open source distributed object storage server written in Go, designed for Private Cloud infrastructure providing S3 storage functionality.

- [Cloudflare Images](https://github.com/drewdecarme/medusa-file-cloudflare-images) ![source](https://img.shields.io/static/v1?label=community&message=&nbsp;&color=blue&style=flat-square) ![stars](https://img.shields.io/github/stars/drewdecarme/medusa-file-cloudflare-images)  
Cloudflare Images provides a straightforward, end-to-end solution to cost-effectively build and maintain your image infrastructure. Store, resize, and optimize images at scale using one unified product.

- [Local Storage](https://github.com/blechlawine/medusa-plugin-filestorage-local) ![source](https://img.shields.io/static/v1?label=community&message=&nbsp;&color=blue&style=flat-square) ![stars](https://img.shields.io/github/stars/blechlawine/medusa-plugin-filestorage-local)

- [GCP](https://github.com/kingwill101/medusa-file-gcp) ![source](https://img.shields.io/static/v1?label=community&message=&nbsp;&color=blue&style=flat-square) ![stars](https://img.shields.io/github/stars/kingwill101/medusa-file-gcp)

- [Cloudinary](https://www.npmjs.com/package/medusa-file-cloudinary) ![source](https://img.shields.io/static/v1?label=community&message=&nbsp;&color=blue&style=flat-square)

- [Supabase](https://github.com/yinkakun/medusa-file-supabase) ![source](https://img.shields.io/static/v1?label=community&message=&nbsp;&color=blue&style=flat-square) ![stars](https://img.shields.io/github/stars/yinkakun/medusa-file-supabase) Supabase Storage plugin for MedusaJS.

- [Cloudflare R2](https://github.com/yinkakun/medusa-file-r2) ![source](https://img.shields.io/static/v1?label=community&message=&nbsp;&color=blue&style=flat-square) ![stars](https://img.shields.io/github/stars/yinkakun/medusa-file-r2)  
Cloudflare R2 storage plugin for Medusa. This plugin also supports CSV exports and imports. R2 is S3-compatible object storage service by Cloudflare and has a 10GB/month forever-free tier.

- [Imgur](https://github.com/samyarkd/medusa-imgur) ![source](https://img.shields.io/static/v1?label=community&message=&nbsp;&color=blue&style=flat-square) ![stars](https://img.shields.io/github/stars/samyarkd/medusa-imgur)
Use free Imgur-Api as your fileservice to upload images.

- [Aliyun OSS](https://github.com/wangjue666/medusa-file-ali) ![source](https://img.shields.io/static/v1?label=community&message=&nbsp;&color=blue&style=flat-square) ![stars](https://img.shields.io/github/stars/wangjue666/medusa-file-ali)
Aliyun OSS file connector for Medusa.

### Loader
  
- [Shopify](https://github.com/medusajs/medusa/tree/master/packages/medusa-source-shopify) ![source](https://img.shields.io/static/v1?label=official&message=&nbsp;&color=green&style=flat-square) ![stars](https://img.shields.io/github/stars/medusajs/medusa?color=green)  
This plugin will copy all of your products and collections from Shopify to Medusa.

- [Magento](https://github.com/shahednasser/medusa-source-magento) ![source](https://img.shields.io/static/v1?label=community&message=&nbsp;&color=blue&style=flat-square) ![stars](https://img.shields.io/github/stars/shahednasser/medusa-source-magento?color=blue)  
This plugin will copy all of your products and collections from Magento to Medusa.

- [Prestashop](https://github.com/juansoler/medusa-source-prestashop) ![source](https://img.shields.io/static/v1?label=community&message=&nbsp;&color=blue&style=flat-square) ![stars](https://img.shields.io/github/stars/juansoler/medusa-source-prestashop)  
This plugin imports Prestashop categories and products into Medusa. It creates categories and products that don't exist, and updates those that have been imported previously.


### Invoice
  
- [Economic](https://github.com/medusajs/medusa/tree/master/packages/medusa-plugin-economic) ![source](https://img.shields.io/static/v1?label=official&message=&nbsp;&color=green&style=flat-square) ![stars](https://img.shields.io/github/stars/medusajs/medusa?color=green)

### Discount
  
- [Generator](https://github.com/medusajs/medusa/tree/master/packages/medusa-plugin-discount-generator) ![source](https://img.shields.io/static/v1?label=official&message=&nbsp;&color=green&style=flat-square) ![stars](https://img.shields.io/github/stars/medusajs/medusa?color=green)

### Inventory
  
- [Brightpearl](https://github.com/medusajs/medusa/tree/master/packages/medusa-plugin-brightpearl) ![source](https://img.shields.io/static/v1?label=official&message=&nbsp;&color=green&style=flat-square) ![stars](https://img.shields.io/github/stars/medusajs/medusa?color=green)  
Sends orders to Brightpearl, listens for stock movements, handles returns.

### Payment

- [Manual](https://github.com/medusajs/medusa/tree/master/packages/medusa-payment-manual) ![source](https://img.shields.io/static/v1?label=official&message=&nbsp;&color=green&style=flat-square) ![stars](https://img.shields.io/github/stars/medusajs/medusa?color=green)

- [Stripe](https://docs.medusajs.com/add-plugins/stripe) ![source](https://img.shields.io/static/v1?label=official&message=&nbsp;&color=green&style=flat-square) ![stars](https://img.shields.io/github/stars/medusajs/medusa?color=green)  
Stripe's products power payments for online and in-person retailers, subscriptions businesses, software platforms and marketplaces, and everything in between.

- [Klarna](https://docs.medusajs.com/add-plugins/klarna) ![source](https://img.shields.io/static/v1?label=official&message=&nbsp;&color=green&style=flat-square) ![stars](https://img.shields.io/github/stars/medusajs/medusa?color=green)  
Buy now, pay later is an alternative to credit and gives you the flexibility to shop what you want, when you want, without breaking the bank. When you split the cost of your purchase into 4 smaller payments with Klarna, you'll never pay any interest.

- [Paypal](https://docs.medusajs.com/add-plugins/paypal) ![source](https://img.shields.io/static/v1?label=official&message=&nbsp;&color=green&style=flat-square) ![stars](https://img.shields.io/github/stars/medusajs/medusa?color=green)  
PayPal is the faster, safer way to send and receive money or make an online payment. Get started or create a merchant account to accept payments.

- [Adyen](https://github.com/medusajs/medusa/tree/master/packages/medusa-payment-adyen) ![source](https://img.shields.io/static/v1?label=official&message=&nbsp;&color=green&style=flat-square) ![stars](https://img.shields.io/github/stars/medusajs/medusa?color=green)  
End-to-end payments, data, and financial management in one solution. Meet the financial technology platform that helps you realize your ambitions faster.

- [Subscriptions plugin](https://github.com/rrums123/medusa-plugin-subscription) ![source](https://img.shields.io/static/v1?label=community&message=&nbsp;&color=blue&style=flat-square) ![stars](https://img.shields.io/github/stars/rrums123/medusa-plugin-subscription)

- [Stripe subscriptions](https://github.com/rrums123/medusa-payment-stripe-subscription) ![source](https://img.shields.io/static/v1?label=community&message=&nbsp;&color=blue&style=flat-square) ![stars](https://img.shields.io/github/stars/rrums123/medusa-payment-stripe-subscription)

- [Razorpay](https://www.npmjs.com/package/medusa-payment-razorpay) ![source](https://img.shields.io/static/v1?label=community&message=&nbsp;&color=blue&style=flat-square)  

### Fullfilment

- [Manual](https://github.com/medusajs/medusa/tree/master/packages/medusa-fulfillment-manual) ![source](https://img.shields.io/static/v1?label=official&message=&nbsp;&color=green&style=flat-square) ![stars](https://img.shields.io/github/stars/medusajs/medusa?color=green)

- [Webshiper](https://github.com/medusajs/medusa/tree/master/packages/medusa-fulfillment-webshipper) ![source](https://img.shields.io/static/v1?label=official&message=&nbsp;&color=green&style=flat-square) ![stars](https://img.shields.io/github/stars/medusajs/medusa?color=green)

- [Shiprocket](https://github.com/Hemann55/medusa-fulfillment-shiprocket) ![source](https://img.shields.io/static/v1?label=community&message=&nbsp;&color=blue&style=flat-square) ![stars](https://img.shields.io/github/stars/Hemann55/medusa-fulfillment-shiprocket)  
Shiprocket is a popular eCommerce logistics and shipping service provider in India. Fulfill your Medusa orders, swaps and returns using medusa-fulfillment-shiprocket

### Notification
  
- [Sendgrid](https://docs.medusajs.com/add-plugins/sendgrid) ![source](https://img.shields.io/static/v1?label=official&message=&nbsp;&color=green&style=flat-square) ![stars](https://img.shields.io/github/stars/medusajs/medusa?color=green)  
SendGrid delivers your transactional and marketing emails through the world's largest cloud-based email delivery platform. Send with confidence

- [Mailchimp](https://github.com/medusajs/medusa/tree/master/packages/medusa-plugin-mailchimp) ![source](https://img.shields.io/static/v1?label=official&message=&nbsp;&color=green&style=flat-square) ![stars](https://img.shields.io/github/stars/medusajs/medusa?color=green)  
Mailchimp is an all-in-one marketing platform that helps you manage and talk to your clients, customers, and other interested parties

- [Twilio](https://github.com/medusajs/medusa/tree/master/packages/medusa-plugin-twilio-sms) ![source](https://img.shields.io/static/v1?label=official&message=&nbsp;&color=green&style=flat-square) ![stars](https://img.shields.io/github/stars/medusajs/medusa?color=green)  
Twilio powers personalized interactions and trusted global communications to connect you with customers.

- [node mailer](https://github.com/Blechlawine/medusa-plugin-nodemailer) ![source](https://img.shields.io/static/v1?label=community&message=&nbsp;&color=blue&style=flat-square) ![stars](https://img.shields.io/github/stars/Blechlawine/medusa-plugin-nodemailer)

- [Amazon SES](https://github.com/pevey/medusa-plugin-ses#readme) ![source](https://img.shields.io/static/v1?label=community&message=&nbsp;&color=blue&style=flat-square) ![stars](https://img.shields.io/github/stars/pevey/medusa-plugin-ses#readme)  
Notifications plugin for Medusa ecommerce server that sends transactional emails via AWS SES (Simple Email Service).

- [Mailjet](https://github.com/Hemann55/medusa-plugin-mailjet) ![source](https://img.shields.io/static/v1?label=community&message=&nbsp;&color=blue&style=flat-square) ![stars](https://img.shields.io/github/stars/Hemann55/medusa-plugin-mailjet)  
Use medusa-plugin-mailjet to send transactional and marketing emails to your customers.
  
- [Postmark](https://github.com/Fullstak-nl/medusa-plugin-postmark) ![source](https://img.shields.io/static/v1?label=community&message=&nbsp;&color=blue&style=flat-square) ![stars](https://img.shields.io/github/stars/Fullstak-nl/medusa-plugin-postmark)  
Mail notifications powered by Postmark templates including PDF invoices that can be configured with json files

- [Seven](https://github.com/seven-io/medusa) ![source](https://img.shields.io/static/v1?label=community&message=&nbsp;&color=blue&style=flat-square) ![stars](https://img.shields.io/github/stars/seven-io/medusa)  
SMS and text-to-speech notifications powered by Seven

### Customer content

- [Wish list](https://github.com/medusajs/medusa/tree/master/packages/medusa-plugin-wishlist) ![source](https://img.shields.io/static/v1?label=official&message=&nbsp;&color=green&style=flat-square) ![stars](https://img.shields.io/github/stars/medusajs/medusa?color=green)

### Bot

- [Slack](https://docs.medusajs.com/add-plugins/slack) ![source](https://img.shields.io/static/v1?label=official&message=&nbsp;&color=green&style=flat-square) ![stars](https://img.shields.io/github/stars/medusajs/medusa?color=green)

### Event Module

- [AWS EventBridge](https://github.com/ikhvost/medusa-event-bus-aws) ![source](https://img.shields.io/static/v1?label=community&message=&nbsp;&color=blue&style=flat-square) ![stars](https://img.shields.io/github/stars/ikhvost/medusa-event-bus-aws?color=green)  
A Medusa module for seamless integration with AWS EventBridge, enabling real-time event handling in headless e-commerce applications.

### Blog

- [Medusa Plugin Blogger](https://github.com/MoscatelliMarco/medusa-plugin-blogger) ![source](https://img.shields.io/static/v1?label=community&message=&nbsp;&color=blue&style=flat-square) ![stars](https://img.shields.io/github/stars/MoscatelliMarco/medusa-plugin-blogger)  
A blog integration for your MedusaJS admin page, enabling you to create and manage blog articles directly from the admin interface.

# Contribute

Contributions welcome! Read the [contribution guidelines](CONTRIBUTING.md) first.
