﻿using Microsoft.EntityFrameworkCore.Migrations;

namespace MyCookbook.Infrastructure.Data.Migrations
{
    public partial class seedupdate : Migration
    {
        protected override void Up(MigrationBuilder migrationBuilder)
        {
            migrationBuilder.UpdateData(
                table: "Category",
                keyColumn: "CategoryId",
                keyValue: 2,
                column: "Icon",
                value: "data:image/png;base64,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\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");

            migrationBuilder.UpdateData(
                table: "Recipe",
                keyColumn: "RecipeId",
                keyValue: 1,
                column: "Ingredients",
                value: "1/2 xícara (chá) de óleo \n3 cenouras médias raladas \n4 ovos \n2 xícaras(chá) de açúcar \n2 e 1 / 2 xícaras(chá) de farinha de trigo\n1 colher(sopa) de fermento em pó");
        }

        protected override void Down(MigrationBuilder migrationBuilder)
        {
            migrationBuilder.UpdateData(
                table: "Category",
                keyColumn: "CategoryId",
                keyValue: 2,
                column: "Icon",
                value: "data:image/png;base64,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");

            migrationBuilder.UpdateData(
                table: "Recipe",
                keyColumn: "RecipeId",
                keyValue: 1,
                column: "Ingredients",
                value: "1/2 xícara (chá) de óleo /n3 cenouras médias raladas /n4 ovos \n2 xícaras(chá) de açúcar \n2 e 1 / 2 xícaras(chá) de farinha de trigo\n1 colher(sopa) de fermento em pó");
        }
    }
}
