[English](https://github.com/adobe-type-tools/Adobe-Japan1/) [日本語](README-JP.md)

# Adobe-Japan1-7 文字コレクション

© 1992–2019 Adobe Inc.

Permission is hereby granted, free of charge, to any person obtaining a copy of this documentation file to use, copy, publish, distribute, sublicense, and/or sell copies of the documentation, and to permit others to do the same, provided that:

No modification, editing or other alteration of this document is allowed; and

The above copyright notice and this permission notice shall be included in all copies of the documentation.

Permission is hereby granted, free of charge, to any person obtaining a copy of this documentation file, to create their own derivative works from the content of this document to use, copy, publish, distribute, sublicense, and/or sell the derivative works, and to permit others to do the same, provided that the derived work is not represented as being a copy or version of this document.

Adobe shall not be liable to any party for any loss of revenue or profit or for indirect, incidental, special, consequential, or other similar damages, whether based on tort (including without limitation negligence or strict liability), contract or other legal or equitable grounds even if Adobe has been advised or had reason to know of the possibility of such damages. The Adobe materials are provided on an “AS IS” basis. Adobe specifically disclaims all express, statutory, or implied warranties relating to the Adobe materials, including but not limited to those concerning merchantability or fitness for a particular purpose or non-infringement of any third party rights regarding the Adobe materials.

Adobe holds no patents on the subject matter of this specification.

Last updated 2019-06-11

---
## はじめに

この文書の目的は、Adobe-Japan1-7 文字コレクションを定義して解説することです。この文字コレクションは、23,060 のグリフ（字形）を収録し、その名称は次の三つの「/CIDSystemInfo」辞書の項目にもとづいています。

* /Registry (Adobe)
* /Ordering (Japan1)
* /Supplement 7

この文字コレクションを参照する CIDFont リソースは、上記の「/Registry」（登録者）と「/Ordering」（版）に割り当てられた文字列と一致する「/CIDSystemInfo」辞書を含まなければなりません。

この文書は、PostScript 製品と併用する目的で日本語フォントを開発するフォント製作者、または OpenType/CFF 日本語フォントを開発するフォント製作者を対象としています。さらに、この文字コレクションに含まれるグリフについてより詳しく知る必要のあるアプリケーション開発者やエンドユーザーにこの文書は有益です。この文書では、読者が [Adobe テクニカルノート #5014](https://www.adobe.com/devnet/font.html)「Adobe CMap and CIDFont Files Specification」に記述されている CID キー方式フォントのファイル形式に精通していることを前提とします。

文字コレクションは、特定の言語、書記体系（用字系）または市場に対応するフォント製品の開発に必要となるグリフを収録したものです。個別のエンコーディングは、具体的にはファイルの形をとる CMap リソースを通して定義され、一般に、文字コレクションのサブセット（部分集合）を参照します。

各追補（Supplement）の文字コレクションには、それ以前の追補のグリフがすべて含まれています。例えば、追補 7 には、追補 0 から 6 で定義されたグリフがすべて収録されています。

Adobe-Japan1-7 文字コレクションには、八つの追補（0 から 7）中の CID 番号 0（CID+0）から 23059 で構成される 23,060 のグリフが収録されています。Adobe-Japan1-7 は、現在の JIS（日本工業規格）文字コード規格とそれ以前の規格、特に JIS X 0208:1997、JIS X 0213:2004、JIS X 0212-1990 および 2019 年 5 月 1 日の日本の改元にともなって用いられる新元号の漢字で構成される二個の合字グリフに完全に対応しています。以下の表はこれら八つの追補をまとめたもので、本書中「[Adobe-Japan1-7.pdf](https://github.com/adobe-type-tools/Adobe-Japan1/raw/master/Adobe-Japan1-7.pdf)」で各々のグリフについて記述されているページ番号も掲載しています。

**追補** | **CID 追加数** | **CID 収容範囲** | **CID 合計** | **制定年月** | **ページ番号**
--- | --- | --- | --- | --- | ---
0 | 8,284 | 0～8283 | 8,284 | 1992 | 1～17
1 | 75 | 8284～8358 | 8,359 | 1993 | 17
2 | 361 | 8359～8719 | 8,720 | 1993 | 17～18
3 | 634 | 8720～9353 | 9,354 | 1998-09 | 18～19
4 | 6,090 | 9354～15443 | 15,444 | 2000-02-21 | 19～31
5 | 4,873 | 15444～20316 | 20,317 | 2002-09 | 31～41
6 | 2,741 | 20317～23057 | 23,058 | 2004-03-05 | 41～47
7 | 2 | 23058～23059 | 23,060 | 2019-04-01 | 47

ある文字コレクション中の個々の CID（文字 ID）は、ある（文字形状やグリフによって決めらる）クラスに関連づけられています。あるグリフクラス中の特別なグリフの形状は、対応するタイプフェースの形式やその他の要因に依存して形成されます。この文書では、あらゆる CID のグリフを列挙し、各 CID とそのグリフ形状クラスとの対応関係を例をあげて具体的に示しています。フォント開発者は、文字コレクションに含まれる各 CID に対してそれぞれグリフをデザインすることが望ましく、CIDFont リソースの検査・確認を行う際には本文書を参考としてご利用いただけます。

以下では、Adobe-Japan1-7 文字コレクションの八つの追補のそれぞれの開発の経緯と内容を説明します。

---
## 追補 0：Adobe-Japan1-0

この追補（グリフ数 8,284、CID 番号 0～8283）は、OCF（Original Composite Format）フォントとのグリフ互換性を維持するために設計されたものです。そのグリフ集合は、Adobe テクニカルノート #5031「Kanji Glyph Collections and Glyph Sets」（このプロジェクトの「[5031.JapaneseOCF.pdf](https://github.com/adobe-type-tools/Adobe-Japan1/raw/master/5031.JapaneseOCF.pdf)」というファイルを参照）に記述されています。したがって、追補 0 は、グリフ数においては 1978 年と 1983 年の JIS X 0208 文字コード規格、また JIS X 0201-1997 および Apple（Macintosh KanjiTalk バージョン 6）、富士通、および NEC により策定された JIS83 準拠のベンダー文字集合に対応するために必要なグリフを含みます。

### 特記事項

CID 番号 1125～7477 のグリフについては、安定性と予測可能性を維持するため、JIS90 互換であるようデザインする必要があります。

また、CID 番号 243 と 245 のグリフについては、追補 3 に実装されている CID 番号 8962 と 8964（CID 番号 243 と 245 の 90° 回転形）と併せてデザインするよう推奨します。これらのグリフを半角（500 単位）幅内で中央揃いとなるようにデザインすることで、数字と数字の間に組んだ場合により良い体裁が得られます。

---
## 追補 1：Adobe-Japan1-1

この追補には、JIS X 0208-1990（別名、JIS90）、Apple（Macintosh KanjiTalk バージョン 7.1）文字集合、および富士通や NEC に実装された JIS90 準拠のベンダー文字集合の対応に必要な 75 のグリフ（CID 番号 8284～8358）が追加されています。これには、JIS90 の二つの漢字、具体的には、JIS X 0208-1990「凜」（84-05；U+51DC）、および「熙」（84-06；U+7199）が含まれます。また、「平成」の元号の合字「㍻」（JIS X 0213:2000 1-13-63；U+337B）も追加されています。

### 特記事項

CID 番号 8284～8285 のグリフについては、安定性と予測可能性を維持するため、JIS90互換であるようデザインする必要があります。

---
## 追補 2：Adobe-Japan1-2

これには、マイクロソフト Windows 3.1J 文字集合をサポートする 361 のグリフ（CID 番号 8359～8719）が追加されています。その大部分（359 グリフ）は、IBM 選定漢字で占められています。IBM 選定漢字には 360 漢字が含まれていますが、追補 2 に IBM 選定漢字が 359 文字しか実装されていない理由は、「昂」（IBM 0xFAD0；JIS X 0208:1997 25-23；U+6602）が、すでに追補 0 に含まれている（CID+1993）ためです。

---
## 追補 3：Adobe-Japan1-3

この追補には、追補 2、または、それ以前の追補に含まれる非全角のラテングリフとラテン様グリフの回転バージョンだけを加えるために、634 のグリフ（CID 番号 8720～9353）が拡張されており、具体的には、OpenType の「[vrt2](https://docs.microsoft.com/en-us/typography/opentype/spec/features_uz#tag-vrt2)」（Vertical Alternates and Rotation）GSUB（Glyph SUBstitution）フィーチャをサポートしています。

### 特記事項

CID 番号 8962 と 8964 のグリフについては、追補 0 に実装されている CID 番号 243 と 245（CID 番号 8962 と 8964 の非回転形）と併せてデザインすることを推奨します。これらのグリフを半角（500 単位）幅内で中央揃いとなるようにデザインすることで、数字と数字の間に組んだ場合により良い体裁が得られます。

---
## 追補 4：Adobe-Japan1-4

プロフェッショナルの商業印刷分野でのニーズに対応すべく、この追補には、初の「Pro」文字コレクションで、6,090 のグリフ（CID 番号 9354～15443）が追加されています。これに対し、追補 3 は、「Std」（文字収容範囲のほとんどが文字コード規格に基づく、という意味での「標準」）と称されます。したがって、「Pro」フォントは、プロフェッショナルの商業印刷に必要な、標準文字コード規格の収容範囲を超えた文字集合を提供するものです。

### 特記事項

CID 番号 12220～12227 は装飾的なグリフであるため、デザインやフォントメーカーによりデザインが異なっていても構いません。この範囲の八つの CID に対する本書での例示グリフには、あくまで小塚明朝の書体デザインの場合のグリフが示されています。

### Adobe-Japan1-4 のデザイン目的

日本のプロフェッショナルな商業印刷分野のニーズに対応するために、数多くの文字やグリフ集合を参照しました。これらには、一般的なベンダー拡張文字、各社の専用グリフ集合、一般的な外字集合、JIS X 0212-1990 文字コード規格などが含まれます。追補 4 の設計目標は「外字ソリューション」を提供することではなく、プロフェッショナルや商業印刷業者の大半のニーズをカバーすることです。つまり、プロフェッショナルユーザに対し、外字フォントの使用を最小限に抑えながら、複雑なデザインの文書を作成できるようにすること、それが本追補の設計目標となっています。

### Adobe-Japan1-4 設計目標

各メーカーが開発するフォントにおいてグリフの一貫性を確保するためには、追補 0 と 1 に実装されている JIS X 0208:1997 の漢字（CID 番号 1125～7477、8284～8285）が JIS90 互換である必要があります。これは、追補 4 に含まれる JIS X 0208:1997 漢字のいくつかの異体字が、JIS90 中のそれらの標準形と微妙に形状が異なっていることに起因します。以下は、追補 4 に含まれるグリフの種別の要約です。

* 日本語テキスト音訳に使われる長音符つき母音などのプロポーショナルの欧文グリフや、プロポーショナルの欧文のグリフ集合に対応する純正のイタリック体グリフの追加
* 全角、プロポーショナル、およびプロポーショナルのイタリックの「ユーロ」通貨記号（U+20AC €「EURO SIGN」）
* 縦中横（縦組み中での横組み）印字で威力を発揮する三分および四分のグリフ
* 二種類の分数形：分子と分母の間の水平または斜めの括線（0/3～1/100 まで）
* 数字 0～100（00～09 も対応）、ラテンアルファベットの大文字・小文字、ひらがな、カタカナ、および一部の漢字を含む、約 2,000 のバリエーションの追加
* 括弧、丸、黒丸、白四角、黒四角、角丸四角、黒角丸四角などのバリエーション
* 欧文合字、横書き・縦書きかな合字、および横書き・縦書き漢字合字の追加
* 半角・全角の句読点と記号、平仮名および片仮名の横書き・縦書きの捨て仮名「こ／コ」の追加
* 横書き・縦書き用に最適化された仮名グリフ
* ルビグリフ：アプリケーションでグリフを半分サイズに縮小して印字することを想定してデザインされていますが、元々このグリフは小さなサイズに最適化してデザインして、それを拡大したものなので、結果として、より良い体裁に仕上がります
* すべてのプロポーショナル、半角、三分、および四分の回転グリフ

2,000 以上の漢字、および異体字を追加。その詳細は以下の通りです。

* 常用漢字表（1981 年 10 月 1 日）に記載されている旧字体。
* 追加の JIS78（別名、JIS C 6226-1978）の漢字
* JIS83（別名、JIS X 0208-1983）の漢字
* その他の JIS X 0208:1997 の漢字の異体字
* IBM 選定漢字の異体字
* JIS X 0212-1990 の一部の漢字
* JIS X 0212-1990 の漢字の異体字
* Unicode の一部の漢字
* K-JIS 漢字
* 「大漢和辞典」の一部の漢字

上記の漢字および漢字の異体字のリストは、先に記述されたグリフの種別中のグリフのいくつかが以後に出てくる種別に含まれる可能性があるため、分かりにくいかもしれません。例えば、JIS X 0212-1990 漢字はすべて Unicode にありますが、そのうちのいくつかは、K-JIS 漢字にも含まれています。これらの約 2,000 に及ぶ漢字および漢字の異体字は、以下の漢字および漢字異体集合に対応しています。ただし、そのうちのいくつかは追補 2 以前では、部分的にしか対応していなかったものです。

* 常用漢字表（1981 年 10 月 1 日制定）記載されている旧字体の残りの部分
* 追加の JIS78 の漢字
* JIS83 の漢字
* 共通の JIS X 0208:1997 の漢字の異体字
* IBM 選定漢字の異体字
* JIS X 0221-1995 附属書 1 中の追加漢字集合（Japanese Ideographic Supplement 1）の文字（JIS X 0212-1990 からの 918 文字の漢字）
* 『校正必携』収録の漢字の異体字すべて
* すべての K-JIS 漢字
* その他の要請に基づく文字

---
## 追補 5：Adobe-Japan1-5

引き続く「Pro」文字コレクションの拡張により、4,873 のグリフ（CID 番号 15444～20316）が追加され、Apple Mac OS X Version 10.2 搭載の文字集合（別名、APGS［Apple Publishing Glyph Set］）に対応しています。また、JIS X 0213:2000 文字集合、国語審議会（NLC）が 2000 年 12 月 8 日に答申した印刷標準字体の漢字にも対応しています。

### JIS X 0213:2000 文字への対応

JIS X 0213:2000 には、4,344 文字が含まれます。さらに、JIS X 0213:2004 と呼ばれる 2004 年の改訂で、10 文字の漢字が追加され、総数が 4,354 文字となりました。JIS X 0213:2004 の漢字の中には、そのグリフが追補 4 に含まれるものもありますが、大多数は追補 5 に属しています。以下は、JIS X 0213:2004 とその異体字、または縦組みみ用グリフ、その他に対応した追補 5 のグリフの CID 番号と CID 収容範囲を示したものです。

15462～15463、15472～15479、15486～15490、15505～15516、15600～15607、15694～15722、15725～15882、15912～15975、15983～15984、16068～16070、16071～16075、16162～16190、16193～16282、16299～16311、16327、16329～16349、16352～16411、16414～16447、16450～16466、16483～16490、16497～16501、16516～16685、16715～19129、19312、19346、20297～20316

JIS X 0213:2004 には、追補 6 で実装される三つのグリフ（CID 番号 21072～21074）が含まれることにご注意ください。

### 印刷標準字体への対応

追補 5 には、2000 年に国語審議会で定められた 1,022 文字の漢字に対応するための 38 のグリフが含まれています。それら印刷標準字体の多くは、JIS X 0208:1997 に（そのままの形で）、または追補 4 に包含されています。以下は、追補 5 に含まれる印刷標準字体のグリフ（計 38 個）のリストです。括弧内は、それぞれに対応する JIS X 0208:1997 の CID 番号です。

19312 (4570)、19346 (4738)、20175 (5741)、20222 (3505)、20263 (1666)、20264 (5020)、20265 (4036)、20266 (5976)、20267 (5704)、20268 (6662)、20269 (1402)、20270 (1662)、20271 (1243)、20272 (1791)、20273 (1850)、20274 (6481)、20275 (6258)、20276 (1892)、20277 (4368)、20278 (5629)、20279 (1998)、20280 (2171)、20281 (2085)、20282 (2523)、20283 (5707)、20284 (2059)、20285 (5937)、20286 (3086)、20287 (3251)、20288 (3379)、20289 (3538)、20290 (1494)、20291 (3628)、20292 (6325)、20293 (3822)、20294 (3832)、20295 (6537)、20296 (6510)

---
## 追補 6：Adobe-Japan1-6

追補 6 には、JIS X 0212-1990 文字集合に完全対応するために、2,741 のグリフ（CID 番号 20317～23057）が追加され、それにより、Adobe テクニカルノート #5097「Adobe-Japan2-0 Character Collection for CID-Keyed Fonts」（このプロジェクトの「[5097.Adobe-Japan2-0.pdf](https://github.com/adobe-type-tools/Adobe-Japan1/raw/master/5097.Adobe-Japan2-0.pdf)」というファイルを参照）に記述される Adobe-Japan2-0 文字コレクションの必要性がなくなりました。また、共同通信社の固有文字集合「U-PRESS」に対応するグリフも追加されています。

### 特記事項

CID+20958 は全角スペースで表示されていますが、それは NTT のフリーダイアル記号の代わりの仮のグリフです。NTT のフリーダイアル記号のグリフを使用する権利を有する、または、その許諾を受けているフォント開発者だけが、それを CID+20958 に割り当てることが可能です。最新の Unicode の CMap リソースにおいては、U+27BF &#x27BF;「DOUBLE CURLY LOOP」は、CID+20958 にマッピングされています。

### JIS C 6226-1978 への対応

この追補には、追加の JIS78（別名、JIS C 6226-1978）のグリフ「&#x6EA2;&#xE0102;」（CID+21071）が一つ追加されています。

### JIS X 0213:2004 への対応

JIS X 0213:2004 に完全対応するために、三つのグリフ（CID 番号 21072～21074）が追加されています。この三つのグリフは、2004 年の改訂で追加された 10 文字の漢字ではなく、JIS X 0213:2000 本来の漢字に対応する目的で追加されたものです。

### JIS X 0212-1990 への対応

この追補には、JIS X 0212-1990 の文字集合（文字総数 6,067）に完全対応するのに必要なグリフが追加されています。JIS X 0212-1990 文字のグリフの殆どは、以前の追補に含まれています。CID 番号 21075～23057 のグリフは、JIS X 0212-1990 の漢字をサポートするために収納されています。

JIS X 0212-1990 と JIS X 0213:2004 の文字集合中には多数の文字が重複しており、それらの文字の中には、同じ Unicode のマッピングを共有しながら、グリフの形状が微妙に異なる場合があります。以下は、追補 6 に含まれる 37 組の CID 番号（JIS X 0213:2004 中の CID 番号）と、それに対応する JIS X 0212-1990 中の CID 番号（括弧内）を示しています。

144 (20319)、140 (20320)、7610 (20321)、15739 (20341)、15747 (20359)、16786 (21164)、17469 (21371)、17510 (20107)、15390 (14510)、14541 (21558)、16889 (14609)、17755 (21722)、17850 (21791)、15395 (14741)、14762 (21933)、15397 (14766)、16977 (8561)、18115 (22006)、14160 (22010)、16987 (20177)、13893 (7725)、16994 (22045)、18201 (22063)、17014 (14904)、18316 (22186)、17041 (8592)、18514 (22341)、18713 (22583)、17168 (15238)、18858 (20239)、18854 (22788)、15405 (15269)、18905 (22843)、15319 (22920)、17205 (13372)、19068 (20257)、19091 (23006)

### U-PRESS への対応

ごく少数の例外を除き、CID 番号 20473～20960 のグリフは、共同通信社の固有文字集合「U-PRESS」に対応するために追加されたものです。

---
## 追補 7：Adobe-Japan1-7

追補 7 には、CID 番号 23058～23059 の二つのグリフだけが追加されています。それらのグリフは、日本で 2019 年 5 月 1 日に実施された改元における新元号「令和」の 2 文字の漢字からなる正方形の合字の、横組み用と縦組みみ用の形状を、それぞれが表しています。この文字は [Unicode のバージョン 12.1](https://www.unicode.org/versions/Unicode12.1.0/) で U+32FF &#x32FF;「SQUARE ERA NAME REIWA」として追加されました。

---
## かなサブセットの定義

アドビシステム社のフォント製品では、三種類のかなサブセットが定義され、書体ファミリーと追補別に分類されています。かなフォントは単独で使用することも可能ですが、収録グリフ数が限られているため、Adobe InDesign などの高級なアプリケーションでサポートされている合成フォントなどの機能を利用して、そのコンポーネントとして使用するのが最適です。以下の表では、各かなサブセットと、そのグリフ数、CID 番号、および CID 収容範囲が示されています。

**かなサブ集合** | **追補** | **収録グリフ数** | **CID番号とCID収容範囲**
--- | --- | --- | ---
「鴨野かな」ファミリ | 1 | 373 | **0**—0、232～233、238～240、243、245～258、262、290、292、295、326～331、503～514、633～642、651～655、659～661、663、665～666、668、670～679、682～693、695～697、708～709、711～719、723～739、780～789、842～1010、7612、7887～7888、7891～7892、7894～7895、7897、7899～7904、7907～7939、7958～7960、8009～8014、8210、8264～8265、8268、8273～8283 & **1**—8307、8313～8316
「鴨野かな」ファミリ | 3 | 415 | **0**—0、232～233、238～240、243、245～258、262、290、292、295、326～331、503～514、633～642、651～655、659～661、663、665～666、668、670～679、682～693、695～697、708～709、711～719、723～739、780～789、842～1010、7612、7887～7888、7891～7892、7894～7895、7897、7899～7904、7907～7939、7958～7960、8009～8014、8210、8264～8265、8268、8273～8283 & **1**—8307、8313～8316 & **3**—8951、8952、8957～8959、8962、8964～8977、8981、9009、9011、9014、9048、9084～9089、9265～9275
「りょう」ファミリー | 1 | 214 | **0**—0、633～635、651～654、657～658、660、842～1010、7887～7888、7891、7918～7939、7958～7960、8264～8265 & **1**—8313～8316

単独のフォントとして用いる場合の利便性を向上させるために、プロポーショナルの欧文グリフをかなフォント製品に含めたい場合には、CID 番号 1～230（追補番号 0 および CID 番号 8720～8949（追補 3）のグリフを追加することを推奨します。

---
## 特殊グリフとその他の注意点

以下は、フォント開発者にとって有益な、特殊グリフと、その他の注意点に関する説明です。Adobe-Japan1-7 が対応するグリフの種別のいくつかは複雑な構成になっており、詳細に記述する必要があります。

### スペース（空白）グリフ

以下の表では、スペースと分類される、すべての Adobe-Japan1-7 グリフが示されており、それらの推奨設定字幅と使用目的に関する情報がリストされています。

**CID 番号** | **設定字幅** | **記述**
--- | --- | ---
1 | プロポーショナル | ラテンスペース（U+0020）
231 | 半角 | ラテンスペース（U+2002）
326 | 半角 | カタカナスペース
422 | 半角 | 汎用スペース
515 | 半角 | ひらがなスペース
633 | 全角 | 和文スペース（U+3000）
8229 | 全角 | 汎用スペース
8720 | 全角 | CID+1 を 90° 回転したバージョン
8950 | 全角 | CID+231 を 90° 回転したバージョン
9084 | 全角 | CID+326 を 90° 回転したバージョン
9179 | 全角 | CID+515 を 90° 回転したバージョン
9276 | 全角 | CID+422 を 90° 回転したバージョン
9444 | プロポーショナル | イタリック体スペース（U+0020）
12960 | 全角 | CID+9444 を 90° 回転したバージョン
15444 | 全角 | AAT（Apple Advanced Typography）互換目的（U+F860）
15445 | 全角 | AAT 互換目的（U+F861）
15446 | 全角 | AAT 互換目的（U+F862）
15447 | 全角 | AAT 互換目的（U+F87A）
15448 | 全角 | AAT 互換目的（U+F87F）
20958 | 全角 | NTT のフリーダイアル記号用 CID 番号（U+27BF）

別のスペースグリフを回転させたバージョンのスペースグリフには、水平方向の字幅として全角を設定する必要がありますが、OpenType フォントとして定義されている場合は、「[vmtx](https://docs.microsoft.com/en-us/typography/opentype/spec/vmtx)」（Vertical Metrics）で設定する垂直方向の字幅は、回転していないバージョンの設定値と一致しなければなりません。

### かなグリフ

グリフクラスに関しては、Adobe-Japan1-7 には、半角、全角、横組み・縦組み用に最適化した全角かな、プロポーショナル、ルビ、そして共同通信社の固有文字集合「U-PRESS」など、多種類のかな文字が含まれています。

**かなグリフの種別** | **横組み用 CID 番号と CID 収容範囲** | **縦組み用 CID 番号と CID 収容範囲**
--- | --- | ---
半角 | 326、332～389、391～422、516～598 | 9084、9090～9262
全角 | 643～644、651～654、660、842～1010、7958～7960、8313～8316、12181、12269、12271、16195、16209～16221、16236～16252、16326～16327 | 7891、7918～7939、8264～8265、8271～8272、12108～12110、12270、12272、16333～16349
組み方向ごとに最適化した全角かな | 12273～12455、16352～16381 | 12456～12638、16382～16411
プロポーショナル | 15449～15452、15455、15462～15463、15517～15724 | 15976～15979、15982～16192
ルビ | 12649～12652、12671～12854、12867、16414～16449 | 12855～12866、12868、16450～16468
U-PRESS | 20473～20496 | 無し

### 漢字グリフ

Adobe-Japan1-7 では、14,664 のグリフが漢字として分類されており、それらの CID 番号と CID 収容範囲を追補別に示すと以下のようになります。

**追補** | **CID 番号と CID 収容範囲**
--- | ---
0 | 656、1125～7477、7633～7886、7961～8004、8266～8267
1 | 8284～8285
2 | 8359～8717
4 | 13320～15443
5 | 16779～20316
6 | 21071～23057

収容されている 14,664 文字の各漢字の詳細は、添付の「[aj17-kanji.txt](https://github.com/adobe-type-tools/Adobe-Japan1/raw/master/aj17-kanji.txt)」というデータベース様のファイルをご参照ください。

### ルビグリフ

追補 4 と 5 には、ルビ（別名、振り仮名）を組むのに適したグリフが収納されており、1 文字の漢字といくつかの記号が含まれている以外、これらのグリフの大半はかな用です。これらのグリフは明らかにエンコードされていませんが、OpenType の「[ruby](https://docs.microsoft.com/en-us/typography/opentype/spec/features_pt#tag-ruby)」（Ruby Notation Forms）GSUBフィーチャをサポートするアプリケーションで使用することができます。以下は、追補 4 と 5 に含まれるグリフの CID 収容範囲を示す表です。

**追補** | **CID 収容範囲**
--- | ---
4 | 12639～12869
5 | 16412～16468

### イタリック体グリフ

イタリック体グリフ（別名、斜体グリフ）は、追補 4 で初めて追加され、追補 5 と 6 にも収められています。以下は、これら三つの追補に含まれるイタリック体グリフの CID 収容範囲と、それらを回転したときのグリフの CID 収容範囲を示したものです。

**追補** | **イタリック体 CID 収容範囲** | **回転した CID の収容範囲**
--- | --- | ---
4 | 9444～9737 | 12960～13253
5 | 15912～15975 | 16715～16778
6 | 20372～20426 | 21016～21070

### 回転グリフ

OpenType の「[vrt2](https://docs.microsoft.com/en-us/typography/opentype/spec/features_uz#tag-vrt2)」（Vertical Alternates and Rotation）GSUB フィーチャに対応するために、Adobe-Japan1-7 文字コレクションは、全角でないラテングリフとラテン様グリフのすべてをあらかじめ回転させた形のグリフを含みます。次の表に、横組み用の CID と CID の範囲が、あらかじめ回転させた形のグリフの CID レンジにどのように対応づけられるかを示します。

**追補** | **横組み用の CID 番号と CID 収容範囲** | **回転した CID の収容範囲**
--- | --- | ---
3 | 1～325、390、501～503、599～628、630～632、8718～8719、326～389、391～421、515～598、423～424、504～514、422、425～500、629 | 8720～9353
4 | 9354～9778、12063～12087 | 12870～13319
5 | 15456～15461、15464～15516、15725～15975 | 16469～16778
6 | 20317～20426 | 20961～21070

### グリフの字幅

以下の表は、プロポーショナル、半角、三分、または四分の幅に設定されているグリフの CID 番号および CID 収容範囲を示したものです。その他のグリフは、すべて全角になります。

**字幅** | **CID 収容範囲**
--- | ---
プロポーショナル | 1～230、9354～9737、15449～15975、20317～20426
半角 | 231～632、8718～8719、12063～12087
三分 | 9758～9778
四分 | 9738～9757

このプロジェクトに掲載されているグリフ表には、相対的な字幅を示すトンボが含まれています。トンボ間の距離を測るよりも、上記の表のように、字幅の種類を明示的に設定することで、正確さと信頼性が高まります。グリフ表と上記の表をガイドとしてお役立てください。

グリフ表に使用したトンボは、異なるレイヤーに配置されています。トンボを表示したくない場合は、このレイヤーをオフにして「非表示」としてください。

### 重複した漢字グリフ

これまでの経緯や JIS90 準拠の理由により、追補 0 に含まれる以下の３対の漢字グリフは、完全に重複したものです。また、対応する追補 4 内の JIS83（別名、JIS X 0208-1983）の CID 番号は、比較のために示したものです。

**最初のグリフ** | **重複グリフ** | **JIS83 のグリフ**
--- | --- | ---
4301—&#x5315;&#xE0100; | 7983—&#x5315;&#xE0101; | 13523—&#x2090E;&#xE0100;
4411—&#x55A9;&#xE0100; | 7984—&#x55A9;&#xE0101; | 13526—&#x55A9;&#xE0102;
5459—&#x6E23;&#xE0100; | 7994—&#x6E23;&#xE0101; | 13558—&#x6E23;&#xE0102;

完全準拠および文字コレクションの整合性のため、上記の重複グリフは保持する必要があります。

また、CID+3603 「&#x853D;&#xE0100;」（追補 0）と CID+13505「&#x853D;&#xE0102;」（追補 4）のグリフは、小塚明朝のデザインで表示される場合は同一ですが、他の書体デザインの場合は、異って表示されることがあります。

### グリフのバリエーション

Adobe-Japan1-7 文字集合をもとにしたフォントを、便利で、意味があり、高い一貫性と予測可能性をもつものにするには、JIS X 0208:1997 文字集合中の漢字のグリフを、JIS90 に準拠するようデザインする必要があります。つまり、JIS X 0208-1990「規格」で定められた例示字形に対応するよう、グリフをデザインしなければなりません。前述のように、このことが影響を与えるのは、追補 0 中の CID 番号 1125～7477（グリフ数 6,353）と、追補 1 の中の CID 番号 8284 と 8285 となります。このことが必要な理由は、追補 4（およびそれ以降）に、微細な形状の差異を含むグリフが含まれるからです。

JIS2004 に準拠した OpenType/CFF フォントの制作しようとする開発者、特に JIS X 0213:2004「規格」の例示字形に対応するをデフォルトのグリフにしようと考える開発者は、この JIS90 の形状への準拠を強く推奨いたします。同じ Unicode コードを、JIS X 0213:2004 の例示字形に対応するグリフの CID に対応付ける、JIS2004 準拠の CMap リソースを通じて、CID レベルではなく、文字コードレベルで JIS2004 準拠は実現されるからです。JIS2004 に準拠したフォントの開発については、後述しますのでご参照ください。

JIS 規格、すなわち、JIS X 0208:1997、JIS X 0212-1990、JIS X 0213:2004 とその以前のバージョンは、『[CJKV Information Processing](http://shop.oreilly.com/product/9780596514471.do)』第二版（O’Reilly Media、2009 年）の付記に記載されている JIS 関連の資料とともに、Adobe-Japan1-7 のグリフを参照する上では（少なくとも、これら規格に対応するグリフについては）、理想的なものといえます。ただし、グリフの中には、どの JIS 規格の文字にも対応しないものがあり、このような場合、本書以外では、[Unicode](https://www.unicode.org/charts/) と [ISO/IEC 10646](https://standards.iso.org/ittf/PubliclyAvailableStandards/) が適切なグリフの参考資料といえるでしょう。添付の「[aj17-kanji.txt](https://github.com/adobe-type-tools/Adobe-Japan1/raw/master/aj17-kanji.txt)」というデータベース様のファイルも、他の規格とグリフとの対応関係についての有益な情報を提供するものです。

---
## CMap リソース

Adobe-Japan1-7 文字コレクションに関連した CMap リソースは、より完全な記述およびフォント開発者に追加の詳細情報を提供する「[cid2code.txt](https://raw.githubusercontent.com/adobe-type-tools/cmap-resources/master/Adobe-Japan1-7/cid2code.txt)」データファイルがオープンソースの「[CMap Resources](https://github.com/adobe-type-tools/cmap-resources/)」プロジェクトの一部として入手可能です。

一般に、Shift-JIS などの旧エンコーディングに基づく CMap リソースは更新されていません。それに対し、Unicode の UTF-8、UTF-16（UTF-16BE）、および UTF-32（UTF-32BE） エンコーディング用の CMap リソースについては、相互間の完全な同期が確保され、新しい追補、または Unicode の新バージョンの発表に伴って必要となる新規のマッピングが追加され、定期的にアップデートされています。また、UCS-2 の CMap リソースは既に旧式のものであり、用いないことを推奨します。開発者は、UCS-2 の代わりに、旧式となった UCS-2 の CMap リソースと互換性がある UTF-16 の CMap リソースを使用することを推奨します。

「[aj17-kanji.txt](https://github.com/adobe-type-tools/Adobe-Japan1/raw/master/aj17-kanji.txt)」データファイルには、Adobe-Japan1-7 文字コレクションに含まれる 14,664 の漢字のすべてに関する追加の情報が提供されています。

---
## Unicode 字形指示列

「[Adobe-Japan1_sequences.txt](https://github.com/adobe-type-tools/Adobe-Japan1/raw/master/Adobe-Japan1_sequences.txt)」データファイルで指定されている漢字の字形指示列（IVS）は The Unicode Consortium が [UTS #37](http://www.unicode.org/reports/tr37/)（Unicode Ideographic Variation Database）によって [IVD](http://www.unicode.org/ivd/)（Ideographic Variation Database）に登録されています。そのデータファイルには、[標準字形指示列](http://www.unicode.org/Public/UCD/latest/ucd/StandardizedVariants.txt)（SVS）が少数含まれ、それらは二つを除いてすべて CJK 互換漢字に対応するものです。

---
## OpenType/CFF フォントの開発

近年、OpenType フォントの優位が増す中、本項では、Adobe-Japan1-7 文字コレクションに基づいた OpenType/CFF フォントの開発に役立つ情報について述べることにします。Adobe では、OpenType/CFF 日本語フォントが持ちうる最小の追補は、「3」、すなわち、Adobe-Japan1-3 であると考えます。以下では、JIS2004 基準の OpenType/CFF フォント開発に関する情報と、業界標準となっている命名規則について説明します。

### JIS2004 基準の OpenType/CFF フォント

どんな Adobe-Japan1-7 対応フォントも、JIS X 0213:2004 中の例示字形に対応するグリフがすべて含まれているという意味で、JIS2004 と互換性があります。しかし、それらのグリフがエンコーディングされているか否かという点については、それがデフォルトになっているとは限りません。グリフがエンコーディングされているかどうかは、使用している CMap リソースに左右され、さらに、OpenType/CFF フォントの場合は、フォーマット 4（BMP だけの UTF-16） と 12（UTF-32）の「[cmap](https://docs.microsoft.com/en-us/typography/opentype/spec/cmap)」サブテーブルの構築にどの CMap リソースを用いるかによります。

JIS2004 基準の OpenType/CFF フォント、すなわちデフォルトのグリフが符号化文字集合を定めた JIS X 0213:2004 の規格票に例示されているグリフと一致する OpenType/CFF フォントを開発するときには、UTF-32 の符号化に対応する適切な CMap リソースを用いて Format 4 と 12 の「cmap」サブテーブルを構築する必要があります。追補 3 から追補 5 に基づくフォントでは、それぞれの追補の範囲を超えた追加のグリフが必要となり、そのため、表示の追補は 6 とする必要があります。追補 3 から追補 5 について、それらの追補を超えるグリフの数の追補ごとの詳細、および、どの JIS2004 基準の CMap リソースを Format 4 と 12 の「cmap」サブテーブルの構築のために用いるべきかを以下の表に示します。

**追補** | **技術上宣言される公示追補** | **CMap リソース** | **CID**
--- | --- | --- | ---
3 | 7 | UniJIS2004-UTF32-H または UniJISX02132004-UTF32-H | Adobe-Japan1-3 および追補 4～7 の 145 のグリフ
4 | 7 | UniJIS2004-UTF32-H または UniJISX02132004-UTF32-H | Adobe-Japan1-4 および追補 5～7 の 83 のグリフ
5 | 7 | UniJIS2004-UTF32-H または UniJISX02132004-UTF32-H | Adobe-Japan1-5 および追補 6～7 の 12 のグリフ

技術上宣言される追補は、CIDFont リソース内にある辞書「/CIDSystemInfo」中の「/Supplement」（追補）項目に記録されている整数値です。以下は、上述の三つの特例的な JIS2004 基準の OpenType/CFF フォントに不可欠な追加グリフのリストを追補別に示したものです。

**追補** | **グリフ数** | **CID 番号と CID 収容範囲**
--- | --- | ---
3 | 145 | **4**—9354、9779、12101、12870、13320～13327、13330、13332～13333、13335～13341、13343、13345～13355、13358～13369、13371、13373～13382、13385～13388、13391～13400、13402、13460、13495、13538、13624、13650、13673、13731、13803、13860、13893、13915、13949、13964、14013、14066、14074、14111、14116、14196、14272、14290 & **5**—16977、17041、18760、19312、19346、20175、20222、20263～20296、20301～20305、20307、20314 & **6**—21072～21074 & **7**—23058
4 | 83 | **5**—16413、16444～16449、16467～16468、16889、16905、16977、17014、17041、17168、17205、18759～18760、19061、19312、19346、20175、20222、20263～20296、20299～20310、20312～20315 & **6**—21071～21074、21558、21933、22010、22920 & **7**—23058～23059
5 | 12 | **6**—21071～21074、21371、21558、21722、21933、22010、22920 & **7**—23058～23059

なお、JIS 規格の対応という点では、各追補収録範囲が異なるため、各追補番号ごとに必要となる追加グリフは、サブセット（部分集合）／スーパーセット（上位集合）の関係にはありません。例えば、追補 3 と 4 がカバーするのは JIS X 0208、追補 5 については JIS X 0208 と JIS X 0213、さらに追補 6 については JIS X 0208、JIS X 0213、および JIS X 0212 となります。

### OpenType/CFF フォント命名規則

異なる追補ごとに OpenType/CFF 日本語フォントを明確に区別するには、フォントに使用する名前（具体的には、「/CIDFontName」文字列と「name」テーブル中の OpenType メニュー名）が、そのための識別文字列を含むことを強く推奨します。以下の表では、現行の業界標準の命名規則、そして、「/CIDFontName」と OpenType メニュー名の文字列の例を示したものです（太字は識別文字列）。

**追補** | **識別文字列** | **JIS2004 基準識別文字列** | **「/CIDFontName」とメニュー名の例**
--- | --- | --- | ---
3 | Std | StdN | KozMin**Std**-Regular、小塚明朝 **Std** R；KozMin**StdN**-Regular、小塚明朝 **StdN** R
4 | Pro | ProN | KozMin**Pro**-Regular、小塚明朝 **Pro** R；KozMin**ProN**-Regular、小塚明朝 **ProN** R
5 | Pr5 | Pr5N | KozMin**Pr5**-Regular、小塚明朝 **Pr5** R；KozMin**Pr5N**-Regular、小塚明朝 **Pr5N** R
6 | Pr6 | Pr6N | KozMin**Pr6**-Regular、小塚明朝 **Pr6** R；KozMin**Pr6N**-Regular、小塚明朝 **Pr6N** R
7 | Pr6 | Pr6N | KozMin**Pr6**-Regular、小塚明朝 **Pr6** R；KozMin**Pr6N**-Regular、小塚明朝 **Pr6N** R

この命名規則によって、JIS2004 基準の OpenType/CFF フォントを同一フォントの過去のバージョンと共存させることが、それらが同じ追補に基づく場合であっても可能となります。また、技術的に宣言される追補によって、追補識別文字列が影響を受けることはありません。例えば、JIS2004 基準の Adobe-Japan1-3 フォントは、追補 4 および 7 から追加された 145 のグリフを含みますが、追補識別文字列には「StdN」を用います。

### 特記事項

上記の表に示したように、Adobe-Japan1-7 文字コレクションにもとづくフォントは、Adobe-Japan1-6 の識別文字列を用いることを推奨します。その主な理由は、追補 7 で追加されたグリフの数は二つだけであるためです。この推奨は、既存の書体デザインの場合にも、新しい書体デザインの場合についても、あてはまります。

---
## グリフ表

このプロジェクトの「[Adobe-Japan1-7.pdf](https://github.com/adobe-type-tools/Adobe-Japan1/raw/master/Adobe-Japan1-7.pdf)」というファイルには、CID 番号 0～23059 の代表字形グリフ（1 ページにつき 500 のグリフ）が掲載されています。各追補の最初のグリフは、読者に分かりやすいように、「左の鉤括弧」のような印が付けられています。各グリフの例示に使用されている書体は、Adobe が開発した「[小塚明朝 Pr6N R](https://fonts.adobe.com/fonts/kozuka-mincho-pr6n/)」（PostScript 名、KozMinPr6N-Regular）で、Adobe のオリジナル書体としてライセンスを購入することができます。ここで用いられているフォントはバージョン 7.000 で、それはフォント中の「/CIDFontVersion」辞書の項目に記述されています。

---
## 以前のバージョンからの変更点

詳細は英語の原文を参照して下さい。

以上
