export const VercelIcon = () => {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="40"
      height="40"
      version="1"
      viewBox="0 0 340 332"
    >
      <path
        d="M371 3259c-69-13-127-47-175-100-87-97-81 19-81-1475V363l35-69c25-50 49-79 85-106 98-74 17-69 1235-75 602-2 1201 0 1330 5 213 8 239 11 282 31 66 32 125 92 156 159l27 57v2650l-33 67c-37 76-82 120-162 157l-55 26-1300 2c-715 0-1320-3-1344-8zm727-547c17-25 25-100 16-134-8-28-85-68-132-68-35 0-44 5-72 40-40 50-49 111-21 139 29 29 62 44 93 43 15 0 28 3 28 7s16 5 36 3c24-3 40-12 52-30zm-443-228c13-14 32-45 41-69 19-51 28-56 80-45 98 21 154 18 154-9 0-4-25-38-55-76s-55-73-55-77 14-29 30-55c35-55 35-55 13-82l-18-22-65 21c-35 11-75 28-89 37-24 15-26 15-67-31-24-25-49-55-58-67-12-18-17-19-36-9-20 11-22 18-17 64 3 28 9 65 13 83 6 29 3 34-27 53-19 11-47 23-62 27-16 3-36 17-44 30-16 24-15 26 13 48 16 14 45 27 64 30 39 7 79 25 78 34-3 30 54 141 73 141 5 0 21-12 34-26zm2297-142c36-35 51-93 38-143-16-57-65-91-135-91-44 0-105 25-105 42 0 6-7 10-15 10-34 0-53 95-29 142 8 15 33 38 56 53 37 22 52 25 102 21 49-4 64-10 88-34zm-948-7c16-5 41-14 55-21 14-8 31-14 37-14s19-9 29-20 24-20 32-20c20 0 134-67 141-83 2-4 23-21 47-37 45-31 135-147 135-174 0-9 5-16 10-16 6 0 10-8 10-17 0-10 6-28 13-40 6-12 20-36 31-55 10-18 24-55 30-83 12-50 13-50 62-59 27-4 83-19 124-33 64-21 83-33 130-82 76-79 94-122 85-200-5-47-14-71-42-106-35-47-101-95-128-95-8 0-15-4-15-9s-21-16-47-24c-111-36-121-44-148-105-28-63-139-177-204-210-20-10-61-34-91-53-55-36-145-74-230-98-25-7-56-18-69-25-15-7-88-11-195-11-169 0-199 3-307 30-30 7-84 17-120 20-108 11-235 53-281 92-9 8-39 27-67 42-61 32-161 156-146 181 8 13-4 17-72 24-57 6-98 13-177 32-36 8-166 134-167 160 0 11-2 39-4 64-4 45 28 170 44 170 4 0 13 11 19 25 17 36 102 125 120 125 8 0 20 6 26 14 15 18 122 55 174 61 44 4 72 19 72 37 0 6 16 43 36 82 51 100 59 114 83 142 11 13 21 28 21 33s14 21 30 34c17 14 30 30 30 36 0 5 26 30 58 54 31 25 66 54 77 66 23 26 215 120 296 145 96 29 371 42 453 21z"
        transform="matrix(.1 0 0 -.1 0 332)"
      ></path>
      <path
        d="M700 2182c0-11 7-23 16-26 24-9 25-4 3 23-18 22-19 22-19 3zM2790 2250c0-5 5-10 10-10 6 0 10 5 10 10 0 6-4 10-10 10-5 0-10-4-10-10zM2907 2208c-15-17-27-34-25-39 4-12 68 46 68 60 0 17-13 11-43-21zM1750 2292c-86-10-202-37-245-57-27-13-77-36-110-51-111-51-229-152-302-259-16-22-31-42-34-45-10-8-75-142-84-170-12-43-30-80-37-80-5 0-8-8-8-17 0-10-6-36-14-58-8-23-15-87-15-151-2-111-2-112 23-118 77-19 1167-25 1266-6 36 6 138 13 228 13l164 2-5 115c-7 179-43 320-128 495-28 57-67 120-91 146-38 41-168 139-184 139-3 0-18 8-32 18-70 48-155 74-262 81-58 3-116 5-130 3zM801 1604c0-11 3-14 6-6 3 7 2 16-1 19-3 4-6-2-5-13zM731 1454c0-11 3-14 6-6 3 7 2 16-1 19-3 4-6-2-5-13zM2639 1453c0-5 0-36 1-70 1-39-3-63-9-63s-11-4-11-10c0-5 20 4 45 21 72 48 84 89 35 114-31 16-60 20-61 8zM552 1429c-7-11-9-25-5-32s10 0 15 18c9 36 6 40-10 14zM793 1410c-44-26-58-54-37-74 8-9 24-16 34-16s22-5 25-10c13-21 25 3 25 48 0 66-9 76-47 52zM2905 1410c-3-5-1-10 4-10 6 0 11 5 11 10 0 6-2 10-4 10-3 0-8-4-11-10zM2911 1378c-1-9-13-26-27-37-15-12-22-21-17-21 17 0 55 48 50 62-4 9-6 8-6-4zM530 1364c0-8 5-12 10-9 6 4 8 11 5 16-9 14-15 11-15-7zM1516 1194c-11-8-16-14-10-14 13 0 39 18 34 24-3 2-14-2-24-10zM1909 1193c-13-15-12-15 9-4 23 12 28 21 13 21-5 0-15-7-22-17zM2505 1140c4-6 11-8 16-5 14 9 11 15-7 15-8 0-12-5-9-10zM1110 1080c0-5 4-10 9-10 6 0 13 5 16 10 3 6-1 10-9 10-9 0-16-4-16-10zM1710 1080c-8-5-10-10-5-10 6 0 17 5 25 10s11 10 5 10c-5 0-17-5-25-10zM2494 1079c-3-6-15-9-25-6-11 3-32 1-47-3-62-20-173-33-407-51-144-10-973-13-1035-3-52 9-52-4 3-71 27-35 63-63 102-84 33-17 71-40 86-51 14-12 57-27 100-35 75-13 189-35 289-55 30-6 66-13 80-15 14-3 91-5 171-5 120 0 158 3 214 21 81 25 193 75 255 114 25 16 46 28 48 27 9-7 92 52 137 98 49 50 88 108 80 120-8 13-42 13-51-1zM1475 1070c4-6 11-8 16-5 14 9 11 15-7 15-8 0-12-5-9-10z"
        transform="matrix(.1 0 0 -.1 0 332)"
      ></path>
    </svg>
  );
}

export const GithubIcon = () => {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="20"
      height="20"
      fill="currentColor"
      viewBox="0 0 24 24"
    >
      <path d="M12 0c-6.626 0-12 5.373-12 12 0 5.302 3.438 9.8 8.207 11.387.599.111.793-.261.793-.577v-2.234c-3.338.726-4.033-1.416-4.033-1.416-.546-1.387-1.333-1.756-1.333-1.756-1.089-.745.083-.729.083-.729 1.205.084 1.839 1.237 1.839 1.237 1.07 1.834 2.807 1.304 3.492.997.107-.775.418-1.305.762-1.604-2.665-.305-5.467-1.334-5.467-5.931 0-1.311.469-2.381 1.236-3.221-.124-.303-.535-1.524.117-3.176 0 0 1.008-.322 3.301 1.23.957-.266 1.983-.399 3.003-.404 1.02.005 2.047.138 3.006.404 2.291-1.552 3.297-1.23 3.297-1.23.653 1.653.242 2.874.118 3.176.77.84 1.235 1.911 1.235 3.221 0 4.609-2.807 5.624-5.479 5.921.43.372.823 1.102.823 2.222v3.293c0 .319.192.694.801.576 4.765-1.589 8.199-6.086 8.199-11.386 0-6.627-5.373-12-12-12z" />
    </svg>
  );
};

export const LoadingCircle = () => {
  return (
    <svg
      aria-hidden="true"
      className="h-4 w-4 animate-spin fill-stone-600 text-stone-200"
      viewBox="0 0 100 101"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z"
        fill="currentColor"
      />
      <path
        d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z"
        fill="currentFill"
      />
    </svg>
  );
};

export const SendIcon = ({ className }: { className?: string }) => {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 16 16"
      fill="none"
      className={className}
      strokeWidth="2"
    >
      <path
        d="M.5 1.163A1 1 0 0 1 1.97.28l12.868 6.837a1 1 0 0 1 0 1.766L1.969 15.72A1 1 0 0 1 .5 14.836V10.33a1 1 0 0 1 .816-.983L8.5 8 1.316 6.653A1 1 0 0 1 .5 5.67V1.163Z"
        fill="currentColor"
      ></path>
    </svg>
  );
};

export const XIcon = ({ className }: { className?: string }) => (
  <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" strokeWidth="1.5" stroke="currentColor" className={className}>
    <path strokeLinecap="round" strokeLinejoin="round" d="M9.75 9.75l4.5 4.5m0-4.5l-4.5 4.5M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
  </svg>
);

export const DocumentIcon = ({ className }: { className?: string }) => (
  <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" strokeWidth="1.5" stroke="currentColor"  className="w-6 h-6">
    <path strokeLinecap="round" strokeLinejoin="round" d="M19.5 14.25v-2.625a3.375 3.375 0 00-3.375-3.375h-1.5A1.125 1.125 0 0113.5 7.125v-1.5a3.375 3.375 0 00-3.375-3.375H8.25m0 12.75h7.5m-7.5 3H12M10.5 2.25H5.625c-.621 0-1.125.504-1.125 1.125v17.25c0 .621.504 1.125 1.125 1.125h12.75c.621 0 1.125-.504 1.125-1.125V11.25a9 9 0 00-9-9z" />
  </svg>
);

export const ImageIcon = ({ className }: { className?: string }) => (
  <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" strokeWidth="1.5" stroke="currentColor" className="w-6 h-6">
    <path strokeLinecap="round" strokeLinejoin="round" d="M2.25 15.75l5.159-5.159a2.25 2.25 0 013.182 0l5.159 5.159m-1.5-1.5l1.409-1.409a2.25 2.25 0 013.182 0l2.909 2.909m-18 3.75h16.5a1.5 1.5 0 001.5-1.5V6a1.5 1.5 0 00-1.5-1.5H3.75A1.5 1.5 0 002.25 6v12a1.5 1.5 0 001.5 1.5zm10.5-11.25h.008v.008h-.008V8.25zm.375 0a.375.375 0 11-.75 0 .375.375 0 01.75 0z" />
  </svg>
);