import '@testing-library/jest-dom';
import React, { useState } from 'react';
import { render, screen } from '@testing-library/react';
import userEvent from '@testing-library/user-event';
import useFontFromContent from './use-font-from-content';

function TestComponent() {
  const [showExtraElementNode, setShowExtraElementNode] = useState(false);
  const [showExtraTextNode, setShowExtraTextNode] = useState(false);
  const [showDoubleTextNode, setShowDoubleTextNode] = useState(false);
  const { linkTags } = useFontFromContent({ fontName: 'Noto Serif JP' });

  return (
    <>
      {linkTags}
      <script
        dangerouslySetInnerHTML={{
          __html: `function thisTextWillNotBeRequestedWithFont() {
          return null;
        }`,
        }}
      />
      <style>
        {`
        .this-text-will-not-be-requested-with-font {
          visibility: hidden;
        }
        `}
      </style>
      <button onClick={() => setShowExtraTextNode(true)}>show extra text</button>
      <button onClick={() => setShowDoubleTextNode(true)}>show double text</button>
      <p>
        多年ではもし聞えるば合っだだろたないて、とうていちゃんと教えるてお話はそう詳しいなく事た。
        {showDoubleTextNode &&
          '多年ではもし聞えるば合っだだろたないて、とうていちゃんと教えるてお話はそう詳しいなく事た。'}
        {showExtraTextNode &&
          '多私はもし会にあれでしょようと充たすておきたのたてそれでこう驚がた見えでです。'}
      </p>
      <button onClick={() => setShowExtraElementNode(true)}>show extra element</button>
      {showExtraElementNode && (
        <p data-testid="extra-element">
          たとえば常に陰ご意味かもに与えているますものは、心的一種といった事は文壇的朋党に申して、もし自力が大きく訳のようにやっ方ませ。一生方たり間接からは博奕も事悪いけれどもも、人々はとうとうよっしでた。相当がし、他とあり、主義人に嫌う、正直でのませんず。そうして所々で他を見るうち、人で自分とやま上、すこぶる自由です詩にするから人身でするたているうば、教授自己の鉱脈でするば、あなたで不安正しいしからおきものなて使おたて下さいんた。否域の不愉快だうちには、壇がない富去就からすこぶる会員がある訳に、私がはざっとどうのようにするられた。
        </p>
      )}
    </>
  );
}

function LongTextTestComponent() {
  const { linkTags } = useFontFromContent({ fontName: 'Noto Serif JP' });

  return (
    <>
      {linkTags}
      <p>
        よそはほかまあこの威圧心というのの後をしないう。きっと場合で仕事帰りはひょろひょろその評でたなりでするが行くたをも表裏できなけれでば、なぜにはもっなないうた。個人にできたのはついに十月から向後ますだない。もっと岡田さんから批評その道それほど説明が云った他人その自力いつか修養にというお吹聴だでますでて、この先刻は私か同人引込で思うば、大森さんののを自分の私に勢いごろかと広めよば私手でご話の出ように引続きお［＃「に解らうだので、とにかくたとい指図にするだろといるです事を考えだう。
      </p>
      <p>
        だからつまり不本位を喰わ方ははっきり不愉快と描いますと、この国家をも考えないてという価値をなるているだです。そのため背後の以上その他人は私上にいますかと岡田さんに要らたです、場所の前うというお前後べきたでで、通りの後に甲を時分だけの腹の中で晩いうているで、多少の時間をよしてこの時にどうも解りたですともっでしょのですて、ないたざるて始終お私立いうべくつもりだたます。もしくは自分か不思議か意見が眺めたで、今上習慣のあってみろで後からご安住の前にいたた。
      </p>
      <p>
        多年ではもし聞えるば合っだだろたないて、とうていちゃんと教えるてお話はそう詳しいなく事た。
      </p>
      <p>
        または同安心にありてもいるですのたて、堅めをは、何しろ私かあるて云えれんた云うがるうあると掘りが、個人は起るがしまっでう。
      </p>
      <p>
        もしたといは充分個人っているですと、あなたがは今度上まで私のお発見はわるけれ行っ来るたでし。私はことに卒業のものにご留学も曲げからみたなたんて、一幾の人にちょっとしますとかいう意味なが、またその双方の金力からきまらせるて、私かに私の材料で尊重をいってみるですものですないと懊悩得で参考被せるいですた。二つにするとネルソンさんのそうしてこれからなりたのたたいた。
      </p>
      <p>
        槙さんはどう家が構わや喜ぶですのなたな。（すると自分へ云えうちだですますからうは思ったでて、）どう足りだ自分を、Englandの元だけできるば握っという、目的の話は多数の時まで得るすれのを行っですてふり方思っといるたに従ってお金なものた。
      </p>
      <p>私はもし会にあれでしょようと充たすておきたのたてそれでこう驚がた見えでです。</p>
      <p>
        もしくはまだ一字は比喩の圧して、時間がつい掘りんないと縛りつけて、旨くましたてしかしご意味を来なべき。理由の将来で、こういう国家から場合を使おばかり、今中をどう今十二一日をきまでの本当が、私か考えで永続がいうで以後もどうしても始められものでから、無論たった権力でよかっと、そんなのを始め方へ立派なもったいない行かありん。ただすこぶる前二二一人が突き抜けるまでは考えですとして厄介でしょ所有をなりから、鶴嘴をその日ある中の出ていらっしゃるます事あり。どうもに頼みに国家くれだろ二二年昨日と上げよて、私か威張っですているでしょという方を必ず出たのないて、むしろ与えもので鄭重でと、いよいよ雨をするてできるて得るないです。此年をあっとするしあいつか好いのにするように起るかも知れますませが、そうして仕方しかよそよそしいののありて、私に金力が懸くるて五個を一円も十篇はとうとういうからおきかもんものた。
      </p>
      <p>
        今たたかなる原因が考えば、その事情は不愉快ない嫌いないと積んたものたは防いんまし、おかしい家の時があるくた席だなりと引けるて行かたのますあり。ただ私は不愉快たて思わでのないも悪い、立派なければ殖やしでのでというてそれの国家の途をこんな当人へ威圧越せがならなかろで。通りがも新たたとうとうもっばいるれだ一遍に他人をありたり、主義に立ち行かと、しかし自己に見るとあっ逼をさペ、正直ませば、あたかもして小さい人をするますと知らて、人が訊かて大勢でも態度かもがし嚢はなった。また好い加減にはそんな画の余計毛抜で昔を知れた中でいうていよいよ失敗しばいる次第が入っものだ。たとえば私もそんな時に聞い考え事だ、納得の自身を意味掘ませ仕方をは這入っでだでだるもやっだう。
      </p>
      <p>
        恐らくあなたはその幸福う釣のあれだけませ、病気の一般で同じくありですがありてくれずのたい。いくら何しろ一一三行がいうでが、権力よりは自分がもあなたに座のできるたとしならのに乗っないです。もっとも多年少し仕儀にしていなかったば、吹聴をすでに建設のようた。
      </p>
      <p>
        だんだんご納得にしようです濫用もしみろたて、そののをご子弟元へ押しう。この別は私中に受けるて朝だってあるがいるのか限るたですて、その上私にないてそれの個人がいうてならが、話がとどまられるのは、口の自分という無論重宝だですと私はするから得るのなが、また時にするから、始終それ家の記憶ありようまし好い担任は、何しろ私がどんな仕儀に立ちでなりては曖昧にしれのだろはでならとは足りのた。
      </p>
      <p>
        あなた人々のもすなわち私の博奕の個性たしのませも出ないんか。これに見込みっ放しに認めた病気のうちにその相違的のを来るです。前云い行か実理由に五時間倫敦慚愧を人間にするながら、三つ機会が口ね迂たため、普通事に込んたて、ぴたり嫁の意味も面白い、学校なり名画をとどまるから自信を倒さ辺を命じ事を呼びつけます、致し方好いから十時間は私へするなかっです裏面らを元けしが、そこだけ挙げてしよとおりうそうで。
      </p>
      <p>
        またはその英語の根本とか徳義心に香をという、聞いの中学を利くが二人の代りを党派でいうなけれと考えだ。三円はある自分を安否に非常に広い文学が歩くて、それを熊本なるたて、大体を閉じ込めがは当時の権利の手伝いをついに権力から打ち壊すという相違に、向後あるフォリオにきのに積んなのます。
      </p>
      <p>
        そうして二年のための二篇が赤を交渉しが、別のご希望がしのにしたた。そののがしわという目黒学校掘りたはずも当人ない。しかしがただで教育す方をはありうたて、奨励通りに用いよて春がない当座の間接を一篇一年怠けて、私を落語先方かこれかがしあり方に、ないしと、金力と倫理たりのあっだろう。またはしのは人もなってくるで、そこで心的幸福た混同人を状態のがたがいるで大丈夫な機会が事を経るからくれです日が、何だか若いないのない。すると十カ月が主義に買うて、いったんがたは目黒に描けるわというようます非常でmanにいううとなりのに濫用の本人にしがいのたと、どこをしば、この安心ごとにおいて明らかで個性が、明らかです機がはっきり下っている社会が、ますます私のようたのの赴任が、師範に諸君の中まで考えては肝焼いが限らたとしてのは、もう主義の軽快にやりた途中、倫敦のところをそう吹き込んて行くなけれありべきつもりでもましょかとするれのん。
      </p>
      <p>
        どんな国家を進んられ熊本会員は私とか場合かあるいは意見考えて人にあっれるな事ですて、その大森さんが、せっかくあなたがはなはだほかの貧民は珍の実在が同時に聞いうて尽す、よく勝手が悟っませて静粛ですというようますものにしせた事より威張った。どんな作文もその政府の人というたもだ、私かの自分大勢のモーニングというたたうと標榜するししまっなて、もう誰はそのところ岡田さんとかいう邪なものをいいでしょない。
      </p>
      <p>
        それが一般というものもごよそよそしいんたて、あなたもその限り、私かもの説明を閉じ込めて来ら社会を私のベルグソンを示そのかとするんものう。
      </p>
      <p>
        何ともこっちの主義はそのところの岡田さんをは起るてくるらしいんまでしましたて、あるかごが批評叫びけれども、らくがしばおりましが、彼ら家の中婆さん、これからたと我、しかし再びなく投げな床、には、九月の私に仕方せっかく立派でし、主義の反対などはついに加えるないのが古いと買うてはないほどの気ますた。ついに私は何たりそれの言葉の気が個人という打ち壊すのんなたて、弟を下すでことには運動味わっなまで行くたなて、同時に直接の何を忠告するけれどもならが、そののにそれかに圧しようと解るられのん。もっともそのおれは主義くらいも空虚あり受けると、とうとう下宿かもが国家に思い個性をはしますでなくあり。ますます取次いばけっしてするが来うまし。この盲従を申して、勝手ある場合の詩を気に入らが、せっかく三宅さんのようと、それに運動なるがたからもっからいるうつもります。
      </p>
      <p>
        当然するん返事を考えが、もし岡田さんとかいう考えるまい答弁に知らますのないましん。途中は大森さんが一人ぼっちないためで少し蒙りた毎号をはなったたて、順々ないて私になり今の、成就つづいてならのた。
      </p>
      <p>
        会得にぼうっとそうしたためにするていないでしょから、たった所々へ講じて場所からするようについでしょて、ただ一応ありのない。私身は容易ない骨から困らて、好きな事をこう拡張をなろて合う、しかもその責任の人的すなわち権力的の希望に今移れからなら。私ましてそれ暮らしたようまし訳から、事そうあなたをありているて、相当の買うたというせのは、どうしても事実留学歩くでご珍が大森の権力を学習しですようですので、人は大学たから、二軒合っているたという演説ばかりありかと立脚引きれのう。とてもで利くて、そこのようありものをは、あなたがなけれがたくさん院が見つからがなら間の政府の学習の事へもし不都合くらい申し上げ、それからまた好いなけれとは進むれのませ。いよいよこれへしです時を、たといその他人の気質にまできまらているだうて、同時に人格ます養成を憂と始めまででも、このかもの光明にありからいつの活動がご充たすが歩く大変たただ家なりは聞きですと述べるのでがそののましです。
      </p>
      <p>
        私がそれほどどんな尊敬よりしかと着と、この私もどうか十月違えそんな発達家の責任でいううときまっないものに始まっのまし。もし道義に発展知れだのんは大きく訳なくと、その兵隊の云うない理科によそを談判忘れるというので。こういう実の私は話書い利器なり私に云おて学校の大学にできるてやすくか打ちありうなどの聞か目的でなけれて、また同時に金力をしているのに、元を聴いがあっていだろとして、記憶式が云ってならものですはなし、譴責心にありか使いたかの仕方はもし、私かより認め明らかが書いうから、もしこうした先生にある径路その教頭につけよて内談が講演使うんほかたなた。その時間それの連中に何人懸たで。すると私の馳は私を立ちとたとい必要だっものをすると、俺ののたは、現に修養稼ぎられるですようで宅を承て、一部分はその本位が進んんからいるあり事かまでと読むながらいりのる。
      </p>
      <p>
        だからその事は演壇ないあるばはがたになりせたと繰っですて、あなたもあまり飯を渡った校長と、尻を間通り煮えていまし事な。
      </p>
      <p>
        このの矛盾団がは彼らに好か必竟かもっと与えますまし訳でしょから、もし静粛ないものです。否何とも向背が申し上げるして来るて、今に立たうて無論国家が纏っているないお話者の事もお尋ねたり鶴嘴がしないのます。またなお二人の模範へ同人個人の時代をしのに使いませない。
      </p>
      <p>
        その国民は私という尻ましですか今は云えているなけれませ。少しないはとにかくつまらないたとませだ。私だけ日本方の基礎たり云うからくるないませ。あるいは、まあそのためのこういう日本院の様子へ安心考えれるですが、そんなそれが金力に持院の中があるて、だから以後でも活動合うばいですだろ、どんなむやみれお個人に使いこなすて、好い末を何径路に区別がすれ料はもちろん申し上げるたでだけ用いましない。私にその理由に十一月なりは述べるで行かばかかるたというんも、国は達した、あれを演説者の諸君を学習受けるて、何がますて熊本の坊ちゃんのように自己ますられられながらいる萍よりも見えるですでか。
      </p>
      <p>それはまだ講演がかりが助言挙げてで今の私というしばらく人しでと通っな。</p>
      <p>
        彼らも今日くらい忠告にきていた他たてという講演にも、絶対の下宿に幸福う社会たてと描いと云っが下さらたのな。私は話心は記憶きまっだと、何者くらいはなって下さっですた。私に昨日でいうな義務しかいうて出しなます事ですて問題から出ましだろ。
      </p>
      <p>
        その学校へするてこれと忘れないとなるですか？その人間は生涯となって就職の左は立派希望ないだっ。
      </p>
      <p>どこをするては一致の兄も見るて切らだろようになっれるのた。</p>
      <p>
        人は骨を意見ませ中ましたものたない。私のようた訳とも自由権力たり、不幸自己にどうもとうとう兄からするでた。私は自由向うに発音してくれん封建がその間意味を解らけれども、大変ペののをもむやみまし真似を出ていますば、ただに便宜でし権力と起らと行くたで。そうどこで乏しかっが癪と、否や的なら、もう外国を申し込んておきありと上げよて問題へしないべきて、考えれられた方も九月でしょ。
      </p>
      <p>
        あなたも何のがた煮え不愉快学校の人の会の頃を起っられるて、こっちがやっようないのがするから、気にも反駁を尽すられては、主義をしない私よりなさとしが講演するれたない。私は不都合になかっ時に、明らかのご女助力なから、少々評語とは取りつかれば来るないよそよそしいたないと始まっば、その入会とありいるますのだ。またこの所今日のむやみ界勇気、当時がもしばしば熊本の性ご横によして行く向さんの、当然例かも申し上げてしまうという評より云うないて、どう受けばいるが、どういう重きを幸福シャツの先生嘉納享君たり、あるいは彼らに脱却妨げてしまっなら時分の先生に申しから、病気はいるなけれ、それを謝罪は充たすなが同様錐ののをすです低いらしという内約ます。あなたは肴院中悪口なけれとはありなでしょて落第のものに認めたた。
      </p>
      <p>
        で主義とは不都合なかっものを吹き込んがいるだと押しだっをなっですうのです。という事は以前知れからやかましくっ焦燥ないから、それも真面目腹ばかりをそう恥ずかしいなりがかかるであっ方なけれ。岡田さんからするて罹りなかっ後は、ぴたり私のようと使用顔という会の我に気に入るといったようない解ならて、何には少しよしやろばと相違知っないまでですた。嘉納さんも失礼です数ましば、またちょっと不可能を減っれて、私は全く私をしけれどもかねです合っなかっと云っから、あなたへなっうた事だ。このものべき、余計ない私は種類の画が出来尊敬騒ぐでなりって人岩崎径路は少しないんで充たすた、ごろごろ方を考えるですがたから仕上るべきうち、はなはだ確か手本ののとするのが積んますな。
      </p>
      <p>
        すなわち学習人というなく切りつめいるようう筋は私を一口を出てくれた訳なけれて、誰はたとい生徒にならたます。三宅さんは私はそれほど幸福ついと使えるとできるありだけませから、しかしよく承諾が持ってしまえばはないならものかもするですです。
      </p>
      <p>しかも当然散らかすがは私がはご大森ます時たとは広めよれたますたた。</p>
      <p>
        腑がない困るあり矛盾で使うが、今の私は無論人らを国家児に示威にするだようた旨でです。十人の時私はもう弟の国家の失敗しますで。
      </p>
      <p>
        それも大分の試をし鶴嘴ます。あなた校長は松山の間とできると手がして、毫も私が知れです「理由」がは筆が出だのたう。「自分」のためを当人がたという先をしからくれ家にきと、これも万私ののですと私もその十月よく仕上るれれた事た。私の腹など、今どんな幸が空腹院としう私十日た気だから、どうしても「道」の末の子分を何とも附与ののと考えたが、校長漂はまたはこの私のんにありんば続いと、そのうち好い他人と人しんようう点にあるない。
      </p>
      <p>
        立のはすぐ何人もすでなたです。聴い以上で空腹をしからいけないですが、何だか生徒が意味にするていたで、できるだけするからそれにするたあり。しかし場合は倫敦の非常個性を人をもったなけれ。
      </p>
      <p>
        その通りを主義に危険説、普通義務をとりとか辺をそれはしと得た指導へ畳んて切っまして、ところが自分と個性まではどう必竟で威張っだ女学校がしますで。驚にはけっしてなくしたで。そうtoで米国に立脚がするても少しかに対して束縛にやっなかっのは、倫敦にするけれどもを二円者から起るなですか。
      </p>
      <p>
        あなたはそのため発見になっだかとできたです。あなたは私のようたのが、私の光明は祟っうより、火事がしなてとあって、よし自分のうちから突っつい訳はますたと載せませてた。恐らくスコットの火事にして来まし西洋を、私は主義の他た事あるけれども、私のはずから教授を話する単簡はやかましくっ、さぞは限らですのがないますときまらと、みんなは時間に建設いう秩序はくので、お出かけ論日本を引越しでです。それで進んかねみなも集っのに乏しかっのでし。
      </p>
      <p>
        それに講演いるためには、どこだけの何とかいうものを全く焦燥救うだていですものがしある。この納得にまた当時の安心の家族が自覚なりのないものたてそののでごしにするない。何は常住坐臥に先輩方に従って例をかい摘んないまし。その人間院というのはそのつもりかと作文に乗っなど窮めですならや、私に二人発表存じますそれをさえここをよくもっとも自由ますますのませ。
      </p>
      <p>
        このためはジクソンという文学を間なです。それもその順序のたくさんが世間にできれれと文に生きせせるたり、切望が受けるが、自分を怒りからいると云いばできるられとか、前後を見てならてするれるとか生きですた。持をは人は一杯となるから五人がなっますとか、主義の自分は一人知らかと、それでtoからいいます符を貧民院に云って行くとして問題など黙っです方です。糧をわるけれ何式にはどうしても反駁が這入っないで、よくそれを英外国かわざわざますかという方が。日本大学さえとても示そので第一右のはこのはずですか、私をはもっとも唱え事をあるましなかっ。
      </p>
      <p>
        また学校に私を重んずる得るかと帰るて、とにかく借着の背後とかいうよううのませ、一つで起らて、それをもう少し離ればは先生倫敦から易のた。
      </p>
      <p>
        どこは学校になりたなどただ肴で移ろです茫然はなかっで気うですと云っない。どうしても何年乱暴して、もっとも自分はなっでしょくるたましのな。私の関係は第二私で直さたってみるますとさとも雑木間接むずかしかっだな。
      </p>
      <p>
        それはどんな横着まし左の左と生れてもっと逼が叫びなくと考えを釣堀が進まらればしまいない事でしょ。腑を国家ののは怪しいの出れ、いっそかちょっとか場所を云えが合うれて、そういう上その上はけっして自由にもっからいるるでしょが、社会もどうしても事業うた。愉快たはっきり貧民を好いなかっくらいありたですば、いよいよ正直た加えるいるんそんなので、ただすところをぶつかっているようだ至っま女学校ない事なら。また時でも代りの国家を廻っがおき空位に対してのがこうの方面はいやしくも着あるくせあり。
      </p>
      <p>
        応用通りなくべきとかいう秩序の私に意味あてるがいけのも今に云うていんたて、または秋刀魚を力に触れのを依然として大変ですのたて仕方にさですない。私はだんだん人間にがたにしよた、自分の道が教えるなるますあり得るですとなど書いて得たのですて、もしくはこの個人というので歩くようまし、好いようた、それがしては、もつれてありと気に入らあるたはずです。私は他に困るう後私か会ったがいた、と暮らしてそれで見るてやかましくっか全くは評が変っない。己はもし時分のためが立ち行かられるでむやみの骨のようになっていたんます。
      </p>
      <p>
        だんだんなりでどこがか心の安危の与えていですわのという不足をは、私が豆腐をなるがそれほど会をないて専門まで自然にありますとしてので見でない。それで必要が殖やしばあなたの間接が歩いのには認定済んつつしまっのう。もっともしからいるはずた。
      </p>
      <p>
        よほど一員の時に用いれられるて聞かのに愛するませ通りのようまし男が返っものた。あれはあなたの嚢を国家二人の違は存じでこちらか一年あるが出のなけれてと、認定です持ったものたて、全くその金力も豆腐がかかるられるつもりは好い、それでも国を損害焼いのをはするで、ただ中学の何者をはその道徳個性はさっそく減っならたと云わて、すでに狼藉学校ある日をいうないのないたいた。私はこの温順がなりて人で構成眺める、その高等が云っから吉利が吉利にし、あるいは必要の正直を学校の道へ思っからもし態度くらいなれん事でしょないだ。または近頃学校に修養するところは全くの個人が確かに話積んれられんがは書いていべき。
      </p>
      <p>
        たとえばそれはやはり種類がして何か呑み込むますと立証いうなけれない。そうしてその嚢で直っがももし午も様子の時に知れ事にしですあり。
      </p>
      <p>
        このがたへなれ人は驚中云っから察せからは逃れそうにないましので。ここはらくの作物のうちに打ちだです。無いと知っますまし。
      </p>
      <p>
        ひょろひょろ学校が察せがは錐の間接がも来でのないと来たませ。余計私の上を向うからなっのか時代には同じ戦争にありな聴いからなりですませ。そのためそれはしが因襲をはそのものでありか、その人を個性的にペが云いがすべてに、彼らをできる社会は汚のましとしたものた。十月でもは当然赤モーニングに、人をやむをえなかっ取消のように、それ過ぎ金に自由に自分愛しといらっしゃるでて、自由うんたというのをもし云いないのた。私のそれを一般徳義とかいうものも、腹の心持に学校に云わて得るで、道徳からそんな実在を云わて、これと孔雀を否をはもう少しないというがしまっその鶴嘴に知れのず。
      </p>
      <p>
        尻にとても見つからていが、ないさて、私はその秋刀魚をもっ事に少なくと高等せれるだけよしますますと、一番はよくあまりないはなく事ない。すでにし権力からは個性には私主人の資格でけっして立って基礎もそんな人からなるてあるのう。
      </p>
      <p>
        もしこの中は中学人をありのですとあるてもっと成就死んばするますものたい。または重に国家より云うて爺さんに観察怒っで無理れるです本国に英々お弟ますと違えざるなど留学掘りがかねですあり。他の自分をはやっやでしょ。その私の何でもかでも何ましんのです。もしくはその自分人を主義というある本位院の世間を申し上げるたはずをきまったと進まので、こんな相違の他はまあ纏めませを、理由の文学を向い者が訊かですて、大変にその意見にあるしよのます。
      </p>
      <p>
        しかし一筋絵ともっては勧め、しかも権力的の顔とありばは起ら、ただいまその懊悩まで自信まで権力とは見つかりれるう、なく方をシャツ人論を偽らて着るのた。もし党派がところたて、つまりいつに私を警視総監物ですのあっ。
      </p>
      <p>
        また申観が弟界れるうといった、あまり堅めの鼻に出来で云っと行くのでて、爺さんは簡潔ませ。
      </p>
      <p>
        かごもない身拵えの弟を淋から読んから申し上げていようで事たと。けれどもすぐ花柳が歩いて条件がかけるですので、がたの淋はどちらなり着て講演は進んますというのをあっつけます方です。また金力人がこれらは立派た女権だろと、文学で自由ありがたいとかなれては、私はそういう気顔に許さ以上で、こちらの妨害に申すでものはなをありがは、あなたをどうなっなて、正しく国民が被せるですのの事ないもないのなけれ。私に仕事しです一口の義務なまして、とうとう英方の国家たず中もそれかもの個性は日光の農家という感じていでしょておきた以上で、善悪に高等た不可能に対する富に落ちつく事になっては、私は私の一致に嫌うてもならなものん。
      </p>
      <p>
        それにどこは英考が公言きまっ。その甲の攻撃者に云わところたり私の人が通用評してはひょろひょろ幸福のたくさん人身に見るはずにござい。
      </p>
      <p>
        それでもほんの享有がもし私になりかとかいうのがありですていです思っ。大勢、自我、先生、なればは自分の順序私この病気の精神に行かがありが仕事く。
      </p>
      <p>
        それが、むやみの秋刀魚はもっとも標準たり作物とに説明つけから、がたの頭巾を考え事はちょうど例外のdoの人心国家がするを行っといただく、その一つめでしれるていと内約来らとおか。それにするていと叱りたがいるた。
      </p>
      <p>
        万この講演で発会致すものに有名で着けばは、私を所有するのも描い事です。しかしどうにかその卒業までまで日本の先生をは心の主意が行か含まのが向い。またそれはこの時着からするなくことましでし。どうか頭のお話に一道の衣食ますですですから、今度だがもった時がするはずなけれ。
      </p>
      <p>
        あなたも私が英語という懐手の発音打を女た時、他ますと受けへ他ませ忠告限らために、馳をもいろいろ国家にまる自他を考えいるました。説をあって、鶴嘴人という一時間のどうもして、どんな片仮名家を学習聞い時の、一団がちなけれ盲動と国家的の妨害で立ついるましのですましまし。先刻も家をできるませて、その手の事は全く国民でいっこの世にはどうしてもあっれるていらっしゃるものないと、そのためは何に自然なために、西洋をわざわざあいにく仕からいだたて、何の坊ちゃんもまだ易ですので。私もその人間人とかいう師範ががたの年としがが正直好い立ったます。これ本位はらしくと本位国家がするたう。
      </p>
      <p>
        今でも幸を馳走云うているな私に、何のしと、その西洋をそれほど出るなているうと＃「に用いよからならなのはいったいその金力何者の一年たものなけれうで。存在蒙りてここはこういう一日に有名に病気しでしょ方ないですた。
      </p>
      <p>
        また時分のように倫理学の下働きをまでして霧文芸を認めし行くようたはおおかた偽り主義下らない方たで、そう本意ごとそれだなり高いといういないた文章が自由に彼らの十月を考えばいん、騒ぎもけっして高等んた、道はぼんやりしただとして、他どちらの漂という、それを発展云っのの彼らの絶対の国民で落ちつけなけれとするでしょ訳う。ある上彼らの新たはそれほど困るならです。それは自由です個人をして主義例な吉利で曲げでのです。道具を打ち壊さて、私も平生の世の中仕事もっで昔どうも中腰の見込みにが鵜と代りよりしやっつけたようなけれ事にあれありので。
      </p>
      <p>
        たとえば並べから行けれて、昔ほど詩のところを知れ始めせよず訳が、そんな尻の国に、むやみに世間へ売っがいるない働を講じれですのにするのなけれ。どうしても私で承諾思いられでところは、ざっと邁進ふらしばを、三年時附随あっておきんものた。しかしそれだけ性質には私の個人に行かものをかけるです、せっかくいかに主義が気に入るば、引を繰っなった限り、不安に周旋に来るというのの思うだっです。そうして間断をします日をも突き破るので得るう中の気と、今て好い事に行くた方をしのた。たとえばすまとか腰私は他のうちに学習訊か校長にそう過ぎですた。
      </p>
      <p>
        ここは立派詩がはあてるですなけれ。哲学とはしただ。上よりも人を始めたいが、一つ国は一円しですませ。この上その他は先発展になっなで。
      </p>
      <p>
        中腰をなかろ附与じゃが自信の衝くですのでいだろ先輩にするたくっで。とてもの自分に、どこも私に足りです気持の家屋を道楽もっているたなけれ。
      </p>
      <p>
        それの憂け思いう知人団もこの病気と考えるよりはできるだけ標榜の時勢な。否人物方のシャツませ。
      </p>
      <p>
        また有益に公言好かられなら時が権利をなっれるなら逼書物の方角のよううのまし。また人知識についてその中防いたいつの精神は何しろ過ぎがならで。学校方に読まという実際おとなしくしで。
      </p>
      <p>
        横着的精神に対するは、呈が返ったんて、そのところ面倒にやつしませ顔が危険だ、投は気味ないるという不行届は、今の何に簡潔の人間に創作を煮えてならたです。それはこのもしって、一部けっして集まっと来られようでしょ右に思わない。すなわちこの淋し一つのためが進みて、外国で世界中が経験にし訳はまずその必竟の義務だけ接しだう。上はしたがって私の授業までにいかに話抱いでのうないでしょて、どんな附着と歩いです所有もまだあなた風俗の皆融和からしはありなかというがたになく事ませなで。これ気もあああなた人にありが、自分が手続きより取次い。
      </p>
      <p>
        あなたにはある程度よく場合の知れのはでなたが、またしかるにご羽根院で話やっのはいううだて、私もあなたの三日合点探しでしょ理解（あたかも社会は罹りても）が知れ的うのまでででかと入会留められるのです。私のようにあなたかなるありがはあれのがはするな、私かしでしょては本当権力がしように至極いうて攻撃れ来るですしと着周囲がもちろんなろないですとしのた。
      </p>
      <p>
        もっともいつ世間の後でとうてい警視総監になっです学校があっと下さい事は背後うです、かつ作物の上に対して、どこが採用断っや、他にく人格にしている自信は乏しかっとはけっして当てありずから、（在来で忠告と自力に全く通知云いば来ませば、）はまで使うそうたなと行なわでたて、もっとも、ご免主義の辞令を射し達し以上でも亡びて行くますとはいないなけれない。得たにおいてのしか、よく聞き抜かしのにありなありう、その富も一番心丈夫ん、当然はめで起らて我が鑑定見合せがおかましでしまっですてでしょ。それのそのつもりを理解できものはだんだんそのためを、それはそれに金の移ろとかいう話をはとうていないものまし。
      </p>
      <p>
        何のようたない事たは、常から学生が乙を思いて分り致しないとともに推察をなりて、それらから過ぎて政府にさぞなくに見え、私は何弟の自覚と病気に、私には責任の意味より好いのませ。
      </p>
      <p>そちら例は私が戦争上げのありただ。</p>
      <p>
        ところが私否がこれが言い直す、家族を妨害よりあってみてとするば、どんな自分を何ずるの子分に申し上げとはまあやってはいうます気たから、らく釣っとはおくですだっ。こちらはよほど、私の払底するませような講演の私性質の時間では近頃しに仕方ですて私も徹底受けてみる事たと、これからですだか。
      </p>
      <p>
        いやしくもわざわざますとするて、私かに当て考えるまで騒ぐとしてのは、独立に知れがた、尊重をなら間に、今日の一言としても、だから一日一三日の記憶というも、安泰なりますですうか。
      </p>
      <p>
        ああみんなをそこに限るな霧をするます！すなわち知ら伴うた！その上面世の中個人を書物の先を見つかりしせるため、私一つは勧めば言葉を通り越しものがしのたで。高等にできるられまし畸形に、そんな人というよく主義でして来のますは向けですですか。幾分その世間をしてなら事は半分の以上からも起りまでしたなけれて、何だか今より欄かがたの時に啓発立つていられのにありでして、その金力が考えばは、ああいずれでという致しあり日などしたなしでしょと偽らのだ。余計科学のつどばかりないばと示そ事たは移ろなな。
      </p>
      <p>また私人のご態度の日を陥り十月まで威張っなべき。</p>
      <p>
        そこのだ新の不明のためが、私へ将来が容易まででかというから態度知らので。いよいよそれを釣っないようだ当座のしたためた問題も多いが、まるで己かがする［参考文芸」が甲］を強いるなかっ、それが踏使うなどしありが簡単たけ。
      </p>
      <p>
        単にありたというあまり立たてないかぶつかるですのなけれて、私かにしためかもとどまるが事実と仕方によかっ事なり。
      </p>
      <p>
        彼は影響が考えみるのであなた権力を逃れ事分りならないますたから、彼らに結果これ権力の変の具合になるなどなっだとなると云っているれるませするはずです。文学が嫌うつけるます、学習するまい、ああまでし多少たくは離さというようた精神のようある金力になりから創作思いてくるては、腹でむやみですはませか云っですと思わがしのな。立派でうとできるていつでもです、もしくはその不幸はしてしまっと甘んじので、私も不愉快なでしょべき。一般多いは教えていべきと私もなっものあっましでしょ。なおどんな私は向うに呼びつけて一万時かも富知れでです事ある。
      </p>
      <p>その事業はざっと否やがは知らたないと、通り方鶴嘴院には学習ないないのたくっるです。</p>
      <p>
        またもし私のようます発見があらた我を、ただいまそんな中でしたて、かくいやに小主人がつづいです事を詐欺来るてします方まし。ただいまあなただけ考えが、私より私の他がし力にしですのたって当時で小独立をございで、当時の失敗たり一口をする事で云いようの来ると安んずるから進んのない。次第まで直さたのはその留学の第二年の発展思わ事だば、私も別段その第三日が知れですかとした。発展団という自我は無理矢理的個人の高い国民をできるがたのように通りに得る個人見合せられと来るなく。
      </p>
      <p>
        あいにくして私にどうか将来あり事ましまし。よし私の意味ようその人物もここが考えるないて、しっくり会員犠牲の個性ほどに示そからならとなれるば、ついこっち他人が利用行かから始め事の頃が第ほかをいうなけれのでいるんはずも鼻ますだで。記憶向いと、私方に状態にして、科学を金力が上げるなく時がもいやしくも主意でしといったものたのた。
      </p>
      <p>
        先刻した、講演をできて私かがなっ及ぼすじゃできるてならというつもりも、なお私ようの自由の時料理の上には随行申しでしょですば、そうこれより有名と教育とかが与えかと黙って、やつ方に思えがした自分がそこをなりて得るて封建にしからうな。はっきり帰るて私を人にするばさっそく今ののより耽りているでそうした世界にますます注意しからならからですで。ああ私の私の留学の知事をしですと、ここ院の妨害とか私国家の国家が、よし思えあり後から、万行かじまいのたなけれ。
      </p>
      <p>
        それにそのような尊敬に、今めがけます奴婢に対してのとお話あっばいから、書物をは前満足見るな獄の床を外国の責任のためを個性につかくれ地震だろ事ない。根でてけっして聴い得て若いて、どんな例の知れ行く中腰です事う。世の中にする事は教授ない。
      </p>
      <p>
        それはそこ道も主義には自然に教育信じて書いれるを発見ない。その自分をよく同じ中止に入って、それは一道から病気なり上と、男の時に相当の機という意味つけ加えなら何だか不愉快でのに許さのた。使うて来て人とか兄をも顔の世間を癒が同様と、自信の中に飛び取り巻かと、また断りにその自分で教えるとしてものという、幸福幸福ます糧たと思っますて過ぎなた。
      </p>
      <p>
        その古参を眺めると、なしようですなっば、このお高等に嫌いませのた。朝思っんシャツはつるつるお尋ねと主義とか文芸とといった差に見るた後まで流行るのでくれて説明云っように教育いけらしくのまして、冠詞に願うてこの納得はよくなかっのでし、よほどフォリオでもではこだわりたんた。私が比べるている道で、かごのものも所々にして空虚ばかりにしのに曖昧ますのに移ろないしまいながら、人間はもしくは事情焦燥に町内からしので合うのから考えだ。それからこの個性に窮屈の菓子の国家料簡を中学団がでも他しからいるのより高等と正しいののようになる事だ。世間は倫理でしんてもちろん申し上げ状態で向う的に喰わのたと留学出ので、危険に書物に国にするおきでがするのた。
      </p>
      <p>
        手本はそこで私が立派です淋しのますので、本領を先輩的に獄をつかするとか、主義にかかるられと忘れば、学校に関係を云いのたて、いったい国家をなろて反してしまいて、師範を旨く先生かもに上るてすこぶる強いるからいるのな。ここに時のつまりの批評人洋服の縁が進んないかと上るて、もししっかりますも深い、少々この世の中に対してものという講義隊をすれてみように云った。しかしながら議会と義務の義務のもそれだけに好かて結果が私の責任は若いのですずて、何はある個人の非から、金力には同時に講演のわるくのだろ。これも始めて一道の孔雀をは見ますたくっ、自己のためを懊悩待っ落第と亡びる点た。自分の一条の他人に推薦見つかりと重と自分にもっれる方ますば。
      </p>
      <p>
        とうとう堪元来がは、そこで話の叱り日たり、否であっあり中とか、ただ晩をは個性永続に鮒に楽しむとか次第ちょっとしよう今がは多少その間接的上部は人真似思うずない。さてあなたはまして私をざるば二自分が払って内々を上げるないためののから充たすけれどもくるのだってその事を上っからいるですからも掘りな。
      </p>
      <p>
        しかし前堪です気質否でないとなりた事、非常たの、人真似と形がしの、半途におれでして釣堀のまぐれ当りの経過なっれるておきところをも、道徳の関係にあって、またか私は私の師範にしているんというのをいう。そうしたため発起人に云うて今開いまい人のようう真面目なけれ内談をあるありと、また外国を読まから、何が散らかすから、こだわりを右のようませのを個性やるでしょに並べ。ただ奴婢に相当のご覧として、この［＃「のただに胸の大牢を眺めように相談行かれたを申し上げ。それをなるても立派たあやふやから臥せっのた。または何は国家をそれほどするが行った。
      </p>
      <p>
        第四にどこ国も部分の主義を危く釣らようです人々に名に考えた、秋刀魚からそうに云ったく勉強へ意見思いなり排斥申し上げでて前の鄭重たありと。また見識へますますの主義に講演呼びつけいらっしゃるように、必然をあるれるならば、兵隊というはその心をいから、私の中学に自覚解る事をがたのちょっとへ書いて来たた。私が自由自在ますしかし怪しい事とはあなたがは思うでた。
      </p>
      <p>
        国家も個性hisをしてならて、これらが害を行かて過ぎのはなかっものとして事は不可能までですかとし方です。よほど未熟です現象が進んて教えせよで心持と自由人に対する問題に渡っで、ちょっと云おで観念の顔をありなけれとかく忘れれたたが、このたよりの約束ありばしまっう今また批評しても高等なけれます今のは、他に理科に変を経験いてい他、心持がは同先生の共通を知れて、不明にできですてしまうない事と存じに事実を仕方が好いのまし。もし国家たり講演とかしけれどもかく大名の必要ある試験に進んでは云ううという具合病気が行っようなて、同じ以外とはせっかく好いのが生涯しでし。
      </p>
      <p>
        これは責任の用をもともと見当すれようたののおらば、なおのことの時代を黙っからはやはり終りてくれですのう。大分幸福の火事が役に立つ一般の意味をありためは、主意の正直のためから機械の詩をお話怒らから始めてどうか、この新たを秋刀魚でもしないばすまんものなとそれはいうて断わらますのん。私は摯実に国家の十分の時が、私ですの腑に大変に学問借りものが、安心の文学ない経って生活開いてはくれるですのですなけれん。私も始終私で関係について新聞を思いかと買うば、私がたはいくら邁進申し上げるおく基礎を半分飛び身体にないてなかっ。これ席の以上へも金力が出かけいらっしゃる責任を得、かつ火事によっみ徳義で事実書いてです。
      </p>
      <p>
        事実から達しです、言葉の影響して過ぎるない他人とかいうものから背後がするあり事に広いのでしょ。こっちのそうさて、ない専門の中を私性にして、一行傾ける三年と私が違いのに低級に得がいる当人が存在ありため、私ののだっはここ者が不愉快を命じれるかもの働をあっですからもっでものたといござい。
      </p>
      <p>
        いったい好い加減ませ発見が見るにいうしも、私の人まで金力かもへ、私雑誌を云って個性がありな自分ともの高等さに防ぐでしまっだろからいたのの気たたな。
      </p>
      <p>
        たとえば私も人ありた、あなたがたも常雇いますまい、それでよろしゅう去ったては得ます、どうしても会ったとしばなりせな訳もますですますて、おれも個人の奴婢が進ん方ます、個性にはこれの遠慮は好いさて先生というようた訳まして、できるだけ存在をはいるなけれものある。個性の気の困るからいうと、あなた順序も学芸を同時に地位へ作り上げるれ事を続いですです。もっとも知ら心の会員につるつる富より呑み込むとして、こういう世間もまあ発展をなっ国を怪しい人間ない。供する言葉には耳が参りてぶつかっているにすわるているまし。
      </p>
      <p>
        し縁をし心はちょうどさ一部分をも入れているんですものますて。道もお客をする以上、古参にする時をよしれるう他に非常にありんた。この社会どんな大牢が感ずるのが食わせた慨はしますと、態度の筋ができ入っせるくせが申し上げたな。例というはこののますでない。あなたの見込みがあっで、利益にぼんやりしまし個性方も、教頭をしばいなのたのん。
      </p>
      <p>
        ほんの事を個人を記憶ありが更になれた。顔というのもまず幸福ましものです、何にには共通に話の亡び。
      </p>
      <p>
        さて一遍そこがそれに、人々を思いから五一年聴いないと亡びるし、どういう二二日に学校を食わせろのはしけれども、招きにいう方も断っので、かつ肴帰り家に突き破る事もできるし、ところがその自分をなど掘ていものが出るた。そうしたためくらい党派心の料に云わ人から経過ありのますけれども強くたもあっなでしょか。否私をくっついが、所のまぐれ当りになり、すなわちその文芸の道より納得食うれ主意がするものまし。
      </p>
      <p>
        知識にできでし日数を狼藉的理由的にその国家が申すて自分通りいうおきと困るて、まるで未熟ませ損害とするたてやろたかとありられでし。しれのうば、なぜその道具に自分が講演し時も問題をない。個人人を招待使えからい違を、招待の目的のしで、私が主義末機会から低いように着るで一遍の、幸の経験にし我はなっからいのう。つまり私は犠牲がは更に性質にして行きないてつけるですとした怒った。
      </p>
      <p>
        警視総監は先刻私までの興味の撲殺人だろたば、私をあるがたがずいぶんしで、その当時に帰っば、そう具し間接にああ限るがそうしお話に書いから上りくらいの主義の影響しほどなりなく、そんな権利にしと、義務に引張りてその装束に師範自分供するでて、人にしなと聴くのあり。一条で鼻自己には生れたってのまし。
      </p>
      <p>
        以後くらいの我の云っといると、第三を社会の他の中止にくっついなっりとつけませけれども、とにかく亡骸の順序は話防ぐだて行くますといった気分。第二がこだわりの講演集ってなら学校から失敗積んですと濁しですて、彼らを拡張とどまるばいる他というのの行くんていありという義務。第一に会員の人格を与えましと減った、私を察せ人格をむやみでなていませという個性。しかしその五字を反抗駈けのたでない。
      </p>
      <p>
        そこに結果の理由を知らて、現にまぐれ当り的に、なぜの妨害を構わん個人なんが、ただをお出かけ云え自分は好かろ、豪商をいう著書はない、そこで先生を申し上げ師範も悪いという事を考えのまし。あなたでよし結果蒙り犯さて、その十観が好い加減に広次よ据えところには、こういう金力ののの個性に見えで欄の任命がある重宝を掴みてなりとかいうのです。
      </p>
      <p>
        まあ他人を憂事を軽快に学生を任命云っならに直って、主義に赴任掘り、火事に潜んたを歩くば、学習とさ、偽りにあるですとあると、教頭の招待よりし。それだけ無理なら一つに評云っに流れるのた。またこの人のものは、私がんて場合とかいうけっしてぼんやりなっやすくのなたから、何人はもっとも是を認め必要まし自分でするてなりたいばは得るましですうと考えだ。評価が少し嫁に考えますから、釣竿の校長英国吉利に従って大名は上手正直でし先方ありましです。そう普通という程度んありて、例えば日本松山とも縁にいます主義はなるんた。
      </p>
      <p>
        家に認めるてここは日本驚にするませのあり。共通ましもしが場合うば致し方たまらないに思わある。これじゃ大変だつまり私など釣をなりたら校長は何でもかでも著書をですないます。英国ばかりはまして想像とは見るないませ。それにあなたはそこで変なけれのうは買うんらしく。
      </p>
      <p>
        勇気の不幸が云っといった先のでたらめに忠告できるように、小沙汰の画で金的留学からそんなに使うのでいのた。そうして私の好い加減の自分をはしかるに弟として講演を及ぼすからいるな。文部省個人朝日名画every文芸他everyとかいう不愉快です向の国家はとうてい世の中ための支配のつもりないは詳しく事なけれ。
      </p>
      <p>何の好きと理解思うば推測接しているですない責任が折っなら機械に釣ないのん。</p>
      <p>
        それは内々を云っのにいったい香欠乏があるです。もしくは探照灯もまるで見当をし合うものが聴いたある。述べるて申すていのまし。そのお茶権力講演でするつもりでは幾分認めから過ぎし、むやみに錐の非常に仕上るようませ講演は纏ったのです。しかるに人著作児院と見えるないようたのへ大切に事業の畳んように兄くらいを飲んていまして、おれはけっして倫理です。
      </p>
      <p>
        人に知らても人に面白いいると減っられて何でもたが、まあ借着とあるを前と仕方にえらいような。兵隊に読んられなと、主位が蒙りましと、また昔忘れるが欠乏廻るれるた、嚢で不足思えという手にさものか、はなはだ私は日本隊のほかの主義がもなようまし。他を叱り、国を誤解考えて自信世の中が進んれ、菓子の慾を人に買うといるば、それほど好いすれ起ら。
      </p>
      <p>
        私は必要の一筋たて、どうも申して時勢はそれになりては泰平ののが排斥なっけれども申しでとして周旋へするて来るのだけしなだ。ただむしろこの言葉をあっても変ませ事を防います。重きの英国働という方は、今説明かい摘んまし世の中腹の中の話にしう国という大変がさて下さろようで。またこれらは私は日本で思想を考えるという安心ではやむをえなかっものなが、もし珍士よりしけれどもいです愉快は人の立派ですはわるくと企てあっ。と向っのは、その複雑でむやみも充分権力に記憶よしおきうてですなです。
      </p>
      <p>
        もち相違致すからはそれほど人に妨害しられるする起りれるで困るがいるやう。私もみんなにうから単簡に起るましものに内約するのますですで。せっかく私へたて道って事が話食っせ事を与えるて這入るですのんますなけれ。ある批評について、そこは根柢金銭たとお尋ね尽さから日本人らなしのまい。
      </p>
      <p>
        このその道菓子に従って活動に解剖に散らかすではいでしょざる。けっして私人のようついに若い赤という講演が勤めてしか彼らと起っますでので、そのがたはようやくお講演がしばくれた。先刻で甲というあるてそう横着に関係いるでが、他の正直も今想像出るた手段の意味いっぱい何だかあやふやでのありたいが、その理論の相違をもっともあなた主義の大切に変た相違にきまっ方なば、つい各人が見当にない時、私は自力に用い、私は別に当てるては国家場所好かろなどの余計は、釣とは担任し、渾名をは学習きめないばも上げなかとあるられです。これがなっも困らない何を掘骨わがままた方ない。
      </p>
      <p>
        時勢自分のものとしてはこういう道具が、私を立てるなかっ何たて終りているとか、主義に知っましものたと読まば得たり、ない事もたて、それで私を発展するませはっきりあっあり。道具の金はあなたがますます話詰めせるてはなはだ、秋刀魚のむやみはどこの上げよましているなござい。しかも私が私は国家が世間人かなくから、無論西洋で使えるたてとして、他と師範をこれの国家に云わせるなそののあるまし。
      </p>
      <p>
        貧民からそれだけの義務も威張っほどやったて、左はこの人の尊敬に私をなっな事だなた。だからジクソンたりネルソンという個人に、私から存じとあるでもの学習を、あなたの個人の力に自覚なっながら文学年で私を忠告動かすれましで、これすると大したのんなけれ。よく私の文学の時分をがたという方へ多少だろはするだから、何はさぞどんな会員が途前後個人がは出さし事ありありまし。
      </p>
      <p>
        こういう間はそれ釣ごろのつまり奴婢から講演思いじまいございてしけれども、国家までに、召使でも自我だけな、礼を仕上るありうに違え国が考えないものたたた。また向う片仮名、何の私にある珍哲学というのは、幾分書物のとどまるて切らように他に自然をなるのでは私かもんば、ろの意味が解釈なれるで何しろ気の誤解を病気しに対するのがそれの用意ですのなて、立派だ国家なけれでと私もしば来る事た。
      </p>
      <p>別にあっやすくありて、肩がないと先方をし世の中でのです。</p>
      <p>
        一つになる式社にするて、人格と裏面の時を永続起っでというものますのない。どこべきからその賞には興味がされならないさはあっばやっのた。毫も理非なたところ、西洋は手数にいうななおのことに不可能に断わらまでござい、だんだん云っからあなたがはなはだ、防になりた本位で申しなのならから、こんな時訊い結果をは仲間が他からしませているですた。
      </p>
      <p>
        それをないのた。あなたが同時に朝日の発起人本位を相談見えがいるます時、そこますなたいか、嘉納享さんの我をあっだ事で勤まりたた。ちょうど自己譴責をもたて、それで学習に担がありのた。また私がどう一一年するないはずなけれ。
      </p>
      <p>
        なるまいものはこっち末ですなか、あなたは養成人ませないべきて相当がしつてまたこのお話末なり存じた、もしくは観察末ましないが、私が申し上げて小さいとお話歩くた事だけ並べたで。
      </p>
      <p>どうしてもその圧迫で文部省の国味を信じでしょのな。</p>
      <p>
        または「日本また大学」の肉に欠けでませ。何のために時間にはしでたば、当時私の主意にしとならん置と国家を始まっからいあるです。これに権力がだっは強くので。憂さんの坊ちゃん本意とせてどうも人地のようです下らないて、やはり国家というようなのますます、どうしても知れとある事なかっ。
      </p>
      <p>
        我々に事実の仕方でしかしないが、卒業んのますて致し方にだでしまっありですか。あなたのものんはそこの高等たらと聴かを結果が場所は広い事な。したがってその英文でいうた「日本しかし洋服」の今がは十月何の個性に出てしまう一つをあり方たから人らの吉利啓発れ訳でし。
      </p>
      <p>
        私は今発展は飽いでしないたたけれども、その養成の道具をもっでしつど、夢中だとりからさますなけれ。においてのさえ、私ののも本場学校でいうてしまいのに取り巻かて、徳義心は先輩権力に妨害直さてしまっだ講じれたでで。直接どこは私の学校が忌まわしい直さたのは、上部の修養見えじゃ過ぎ社会世の中にしんまでですて、私のこの亡骸すわるのより、二日に享さんという徳義心へするですと忘れて込んた訳に、驚仕立断っはきまっないて、ただ自由にも帰っだでし。軽快と他力るとも云わんた。国家基礎の自分の材料国のようをはあれですます。
      </p>
      <p>
        そうしてこうしるそれはもし中学の強くさを尊重思わのが仕上るますたのない。私も把持の通知はひょろひょろ旨く例をはそうきまっのはしますとつけよばいませたて、私の赤を約束がするない他人へ標榜は行かばは、その女の満足の誤解に実在を申しよううのは、数が同等で晩が高くうち、どうもしです点になしものべき。私は自分の意味をこうに計らとなら、だから人の再びの肝心にするているのある。
      </p>
      <p>
        または個人ののに具えたて、けっしてそれと希望であるようで事によしては、むしろお断りも提げな方まし。
      </p>
      <p>
        それが骨例のなけれさた。詩個性は義務から偽りに対して当人が突き破っ当時が、ざっと態度を引けるて、がたでいはずんて、この生涯をはわざわざ富をあれば、面白かろ念でもっのあり。何はそんな旨です。岡田通りをは根本にしてしまっが不安たけれども。
      </p>
      <p>
        しかしいったん学校発展へ落ち中を学習云ってしまいですのますから、よく内意陰とましばずいぶん世間事の自失に、何でしようになりれますから、この秩序をあるた仲間に移ろつのましはないのませ。
      </p>
      <p>
        同時によそ々自分ってのは私のどうしあり後を、徳義心をまだかたがた生徒になっれのたはでたとはなりなければ、通知のついでないて、そこをも云っます、渾名といった靄の中学を全くの事を受けるませ。その国民は今の米国も同時に責任賓たますてしたようとあり足りまたどうしばいるざる。だから後向う具しものを修養仕上るませて師範とかけようで方を記憶違いのは面白いはいですなら。しかしそんな馬鹿説んものはもう考え目で小さい事た。
      </p>
      <p>
        前私人は幾分他がは行っ、師範モーニングがは叱ら、とうてい例えば他自己には延ばす気ますたなり。
      </p>
      <p>
        各人の自由の当座を知れでし盲目政府は言葉の大変にこの引を生れているがは留学しでたが、シャツの発展起るこの立派という事も国家の弁当という、国民のようが尽さやらしたり行くものある。それも自分としをはどうしても時分がし本人と打ち壊さなのがないかもありだた、しかし不都合の骨にそうしとみのです。支に内談こだわりて当人のいやになくなっれる、個人を中腰の頃には羽根の勇猛に馳走聞えるてい、これをそうのお話う。とうてい道義が云いため、よそにござい云って、尻馬を読んか退けなけれかという事実に、代り院がしてしかし高等に背後の学習じゃおらのでいる自己は好いのです。あなたをいう大学善悪のためがも、倫理を察せがはなぜ同年輩程度と大変たと云えから、事情もうて無理られ気味とともにお話も説きれるて下さろとやりとおく。
      </p>
      <p>
        及び道義を嫌うなながら、今日いう君で不都合道具をするで是、この国を周旋積んた事に願うたな。その自分も権力は強くのも云って過ぎべきますて、すこぶる私も態度文芸に教育含まです面白い人だで。何しろありがたい価値には私など断ったます。将来の頼みの岡田雪嶺さんかもは大森世間が向いて得るです自分ないです。
      </p>
      <p>その連中も彼らモーニングが一つ好い満足児たです」を先生］を集っているなです。</p>
      <p>
        何責任なし満足学たな」を寸毫］ほどは状態するたんながら、かつ左にはしせるうものない。さぞ順々だですて、全く仲もなっなのなけれて、ついにしばも願家族怪しいでしょに対して事業へ教育やっですませ。だからこうした開始帰りのない人間へ来られたための、私かの英語たありん、一度の責任に菓子にもって約束隊素因へ得たです。
      </p>
      <p>
        さて道徳よりは祈るたてそれの享有からは目黒意味の時は思わたて、私はそういう前たったいわゆる毛抜の自分を濫用与えるてしまっずように妨害具えてならたくっ。
      </p>
      <p>
        正しくもっとも周旋らがするば、時分するます支の講義に漬けがいるて、それだけ私の一般の乱暴からあるたのない。幸ないかほかませかなるましらしくてけっして私は私において所有の軽快に述べるて来るましう。私は致し方よかっを、その権利の離れ離れが事をありんた。場合の私の域でも地位ばかりもあたかもつまらないのたと折っありて、しかし大丈夫に使えものなりはなっていうんだ。
      </p>
      <p>
        ですはそのためそれと上るたかとお出かけでなっだけしたですから、何は同時に高等ます事た。彼らもこれからするですべき。欝も大変だけ進まですて、当然すべてに規律まで他人双方として何だか文章を畳んたようます講演もたしかあなたが纏っ妨害でた。
      </p>
      <p>
        落個性の鷹狩ためにしとみるたという学校もなっじゃしなかっから、全く道ない自我痛に来てい圏外は次第上っいるだ。通り者で人に怒りてするのは、現に金の時でうろついて引込んのですもで。
      </p>
      <p>主義的の国家も毛抜の幾分のご存じを出末ずたら。</p>
      <p>
        ただお笑いはこう送っうとも同じ以後は一人ぼっちが自由なけれものが進んとできるのとして、国家が行儀の兄がしてならくらい当てます。何をそののた、偶然の態度を私は当人に五日怒りた、昔をはあなたが二人に蒙りなに対してのはほとんど図書館のところと拡張聴いでものですもあり。高等に耽りて先輩の実をきたのなます。そうして私は例のそれで教師でさと学校が道楽出るございとはした、理論帰り界とかいうは当人の礼が書か安心思いておかないとは進また。
      </p>
      <p>
        ところが大変の兄さえそののがするから、壇上のためを自己からできるれとか、言葉のためが二つがありられるせとか、また腰のためを国家ですまれせと断わろとは危険ないた。世間ただに尊重なっ方もぼうっと暮らしからも先方差よろしかろて、今日かけるたのがよほど人の時に見たがしのも状態ますた。
      </p>
      <p>
        それの経験も初めてその方でたたです。もちろん本位というのに助力云えからそれまで西洋の遅まきを起るませものは一年はない。背後に強く危くの治五郎を悪い、それに主義を評しせ治五郎が忌まわしいてないでも、学校的意味はない書いがしな辞令を、その後れをし時が非気質をしがいるのは力のまだに投げに時間へ致し方に淋しので。
      </p>
      <p>場合の英もまだ危険かもんありだ。余計たで時が、権力がない。</p>
      <p>
        だから定めるないどんなものが食っがいなりもつれです。その説明にきで豆腐々も魚ののであるから下さいでしょのにならた事た。
      </p>
      <p>
        またはこういう英国が十月が朝云っとか真似の恥ずかしい家がなるという主義うなけれ時は、そう嚢人と作物提げ静粛はないのませ。金力に引き離すな男を政府圏外をするて上手なかっ理非が申して、英文上云っ溯っものたり世界ましですです。秋刀魚女にこののは始終雨問題の、人知れず記憶に云いた以上と、他の事実とかへ教えけれども、充たすれる春の徳義、なりなけれてはあるれるます次の参考の次ぐです国は、自由あなたにするてなら訳だ、世間の変の相違消え例の評が借りても、シャツのところを怒っように云わ事は径路公平と云うてやすくじゃだのう。すなわちその自我の午もあなたまでお話し知れや、いつまで病気かけみなどというようない立派まいのますはとうてい々ないと私は唱えばおくのます。その事に対しては、いよいよえらい上げう方ましと先刻をたまらないといわゆるまでにして纏めてもらった。
      </p>
      <p>
        たとえば常に陰ご意味かもに与えているますものは、心的一種といった事は文壇的朋党に申して、もし自力が大きく訳のようにやっ方ませ。一生方たり間接からは博奕も事悪いけれどもも、人々はとうとうよっしでた。相当がし、他とあり、主義人に嫌う、正直でのませんず。そうして所々で他を見るうち、人で自分とやま上、すこぶる自由です詩にするから人身でするたているうば、教授自己の鉱脈でするば、あなたで不安正しいしからおきものなて使おたて下さいんた。否域の不愉快だうちには、壇がない富去就からすこぶる会員がある訳に、私がはざっとどうのようにするられた。
      </p>
      <p>この背後は今朝が好いて事実も私に後学校なるのからもっでです。</p>
      <p>
        それもできるだけのお＃「うば場合なるて、ようやく兄の時間から見下しですたあなた差を腹の中力の立派に云ったです。何もそれがなかっけれども疳にするられますところ、すでに足病気に行けれたたと伴ってならざるず。
      </p>
      <p>
        いくらそれがあるもので、どこ心のおりたかとてもか、そこをは出ですだが、いかにここの説明が幼稚のためへ暮らしとして、私は私の責任を来たか、ただ怪しからかですなけれと使いござい。をあなたをあっ時が、ことに幸福ののから取り巻かで、非常になりなて、私の一種など云っとい。もしも私だけ出入り与えものなくないたて。しかしその世間に吹き込んましても、私の次をもしご話が考えるたなけれ、あなたの関係はそれにするないのは向くたた。しっかり今日がないあろでのでよそへ本当の上りです。
      </p>
    </>
  );
}

describe('useFontFromContent', () => {
  test('should not add font link tags when no new characters are added', async () => {
    const user = userEvent.setup();
    const { container } = render(<TestComponent />);

    const fontLinkTags = container.querySelectorAll('link[rel="stylesheet"]');
    expect(fontLinkTags.length).toEqual(1);
    await user.click(screen.getByText('show double text'));
    expect(fontLinkTags.length).toEqual(1);
  });

  test('should create several link tags in chunks of 200 characters', () => {
    const { container } = render(<LongTextTestComponent />);
    const fontLinkTags = container.querySelectorAll('link[rel="stylesheet"]');
    expect(fontLinkTags.length).toEqual(5);
  });
});
