/////////////////////////////////////////////////////////////////////////////
/// \project		adaptit
/// \file			Uuid_AI.h
/// \author			Bruce Waters
/// \date_created	5 May 2010
/// \rcs_id $Id$
/// \copyright		2010 Bruce Waters, Bill Martin, SIL International
/// \license		The Common Public License or The GNU Lesser General Public License (see license directory)
/// \description	This is a header file for UUID generation within Adapt It. 
///                 The Windows and Mac ports use open source third party tools 
///                 provided by the Boost software library. The Linux port uses
///                 UUID code packaged with all Ubuntu distros supported by
///                 Adapt It.
///                 
///   Boost Software License - Version 1.0 - August 17th, 2003
///   
///   Permission is hereby granted, free of charge, to any person or organization
///   obtaining a copy of the software and accompanying documentation covered by
///   this license (the "Software") to use, reproduce, display, distribute,
///   execute, and transmit the Software, and to prepare derivative works of the
///   Software, and to permit third-parties to whom the Software is furnished to
///   do so, all subject to the following:
///   
///   The copyright notices in the Software and this entire statement, including
///   the above license grant, this restriction and the following disclaimer,
///   must be included in all copies of the Software, in whole or in part, and
///   all derivative works of the Software, unless such copies or derivative
///   works are solely in the form of machine-executable object code generated by
///   a source language processor.
///   
///   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
///   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
///   FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
///   SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
///   FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
///   ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
///   DEALINGS IN THE SOFTWARE.
///                 
/////////////////////////////////////////////////////////////////////////////
//
#ifndef uuid_ai_h
#define uuid_ai_h

// the following improves GCC compilation performance
#if defined(__GNUG__) && !defined(__APPLE__)
    #pragma interface "Uuid_AI.h"
#endif

#ifndef __WXGTK__
#include <boost/uuid/uuid_generators.hpp>
#endif

class Uuid_AI : public wxObject
{
public:
	Uuid_AI(void); // constructor
	~Uuid_AI(void); // destructor
	// accessor
	wxString GetUUID();
private:
#ifndef __WXGTK__
	boost::uuids::uuid u;
#endif

	DECLARE_DYNAMIC_CLASS(Uuid_AI) 

};

#endif // for uuid_ai_h