/////////////////////////////////////////////////////////////////////////////////
/// \project		adaptit
/// \file			Adapt_ItView.cpp
/// \author			Bill Martin
/// \date_created	05 January 2004
/// \rcs_id $Id$
/// \copyright		2008 Bruce Waters, Bill Martin, SIL International
/// \license		The Common Public License or The GNU Lesser General Public
///                 License (see license directory)
/// \description	This is the implementation file for the CAdapt_ItView class.
/// The CAdapt_ItView class is the most complex class in the application. It controls every
/// aspect of how the data is presented to the user, and most aspects of the user
/// interface. The data for the view is held entirely in memory and is kept logically
/// separate from and independent of the document class's persistent data structures. This
/// schema is an implementation of the document/view framework.
/// \derivation		The CAdapt_ItView class is derived from wxView.
/////////////////////////////////////////////////////////////////////////////////

//#define DrawFT_Bug
//#define FINDNXT

//#define _debugLayout

// Next #define turns on wxLogDebug() calls in the feature where the user clicks on a
// doc location where asterisk shows (a <Not In KB> entry in adaption KB) and then
// clicks the Save To Knowledge Base checkbox to revert the KB entry to a normal one.
// Doing this in one place in one document causes all docs to be scanned for that src
// key where m_bNotInKB is set TRUE, and have them reverted to normal entries, and a
// StoreText() done to the adapting KB (and if kbserver is operating, the remote kb
// will also be updated automatically). m_pSourcePhrases is made available for reuse for
// this feature by auto-closing the current doc with a protected save being done beforehand,
// and the doc aut-reloaded when done. The screen is frozen throughout, and a WaitDlg used,
// and also a progress bar - ticking off each doc as done. All docs, in Adaptations and any
// Bible Book folders, are processed.
//#define NO_ASTERISK

#if defined(__GNUG__) && !defined(__APPLE__)
    #pragma implementation "Adapt_ItView.h"
#endif

// For compilers that support precompilation, includes "wx.h".
#include <wx/wxprec.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
// Include your minimal set of headers here, or wx.h
#include <wx/wx.h>
#endif

extern size_t aSequNum; // use with TOKENIZE_BUG

#if defined(__VISUALC__) && __VISUALC__ >= 1400
#pragma warning(disable:4428)	// VC 8.0 wrongly issues warning C4428: universal-character-name
								// encountered in source for a statement like
								// ellipsis = _T('\u2026');
								// which contains a unicode character \u2026 in a string literal.
								// The MSDN docs for warning C4428 are also misleading!
#endif

//#define _Trace_DrawFreeTrans
//#define CHECK_GEDITSTEP

//#define NOLOGS

// define a resouorce ID integer for the hidden developer menu item
int ID_MENU_ITEM_HIDDEN = 9999;

#include <wx/docview.h>	// includes wxWidgets doc/view framework
#include <wx/file.h>
#include <wx/clipbrd.h>
#include <wx/filesys.h> // for wxFileName
#include <wx/window.h> // for CaptureMouse()
#include <wx/event.h> // for GetCapturedWindow()
#include <wx/tokenzr.h>
#include <wx/textfile.h> // to get EOL info
#include <wx/dir.h> // for wxDir
#include <wx/propdlg.h>
#include <wx/busyinfo.h>
#include <wx/dynlib.h> // for wxDynamicLibrary
#include <wx/odcombo.h>
#include <wx/display.h>  // for wxDisplay

// whm refactored printing 10Oct2016
// ------------------------------------------------------------
#if !wxUSE_PRINTING_ARCHITECTURE
#error "You must set wxUSE_PRINTING_ARCHITECTURE to 1 in setup.h, and recompile the library."
#endif

#include <ctype.h>
#include <wx/metafile.h>
#include <wx/print.h>
#include <wx/printdlg.h>
#include <wx/image.h>
#include <wx/accel.h>

#if wxUSE_POSTSCRIPT
#include <wx/generic/printps.h>
#include <wx/generic/prntdlgg.h>
#endif

#if wxUSE_GRAPHICS_CONTEXT
#include <wx/graphics.h>
#endif

#ifdef __WXMAC__
#include <wx/osx/printdlg.h>
#endif
// ------------------------------------------------------------

// includes below uncomment as implemented
#include "Adapt_ItCanvas.h"
#include "Adapt_It_Resources.h"
#include "Adapt_It.h"
#include "ReadOnlyProtection.h"
#include "Adapt_ItDoc.h"
#include "AIPrintPreviewFrame.h"
#include "helpers.h"
#include "CollabUtilities.h"
#include "XML.h"
#if wxCHECK_VERSION(2,9,0)
	// Use the built-in scrolling dialog features available in wxWidgets  2.9.x
#else
	// The wxWidgets library being used is pre-2.9.x, so use our own modified
	// version named wxScrollingDialog located in scrollingdialog.h
#include "scrollingdialog.h"
#endif

#include "EditPreferencesDlg.h"
#include "RefString.h"
#include "RefStringMetadata.h"
#include "KB.h"
#include "SourcePhrase.h"
#include "Strip.h"
#include "Pile.h"
#include "Cell.h"
#include "Layout.h"
#include "PhraseBox.h"
#include "AdaptitConstants.h"
#include "TargetUnit.h"
#include "RetranslationDlg.h"
#include "ChooseTranslation.h"
#include "MainFrm.h"
#include "Welcome.h"
#include "PlaceInternalPunct.h"
#include "KBEditor.h"
//#include "ConsistencyCheckDlg.h" // moved to CAdapt_ItDoc class 17May10
//#include "ChooseConsistencyCheckTypeDlg.h" //whm added 9Feb04, BEW moved to CAdapt_ItDoc class
//#include "ProgressDlg.h" // removed in svn revision #562
#include "GoToDlg.h"
#include "WaitDlg.h"
#include "UnitsDlg.h"
#include "EarlierTranslationDlg.h"
#include "EditSourceTextDlg.h"
#include "SetDelay.h" // added for version 2.0.2
#include "CollectBacktranslations.h" // BEW added 14Sept05
#include "NoteDlg.h"
#include "AIPrintout.h"
#include "ExportFunctions.h"
#include "PrintOptionsDlg.h"
#include "ConsistentChanger.h"
#include "SilConverterSelectDlg.h"
//#ifdef USE_SIL_CONVERTERS
//#include "ecdriver.h"
//#endif
#include "FreeTrans.h"
#include "Adapt_ItView.h"
#include "Notes.h"
#include "Retranslation.h"
#include "Placeholder.h"
#include "GuesserSettingsDlg.h"
#include "MergeUpdatedSrc.h"
#include "KBExportImportOptionsDlg.h"
#include "StatusBar.h"

// Temporary - while using OnAdvancedDelay() as a way to test code for kbserver class
#include "KbServer.h"

// vectorized toolbar images (for toggle toolbars)
#include "../res/vectorized/bounds_go_16.cpp"
#include "../res/vectorized/bounds_stop_16.cpp"
#include "../res/vectorized/format_hide_punctuation_16.cpp"
#include "../res/vectorized/format_show_punctuation_16.cpp"
#include "../res/vectorized/show_target_16.cpp"
#include "../res/vectorized/show_source_target_16.cpp"
#include "../res/vectorized/punctuation_copy_16.cpp"
#include "../res/vectorized/punctuation_do_not_copy_16.cpp"
#include "../res/vectorized/bounds-go_22.cpp"
#include "../res/vectorized/bounds-stop_22.cpp"
#include "../res/vectorized/format-hide-punctuation_22.cpp"
#include "../res/vectorized/format-show-punctuation_22.cpp"
#include "../res/vectorized/show-target_22.cpp"
#include "../res/vectorized/show-source-target_22.cpp"
#include "../res/vectorized/punctuation-copy_22.cpp"
#include "../res/vectorized/punctuation-do-not-copy_22.cpp"
#include "../res/vectorized/bounds-go_32.cpp"
#include "../res/vectorized/bounds-stop_32.cpp"
#include "../res/vectorized/format-hide-punctuation_32.cpp"
#include "../res/vectorized/format-show-punctuation_32.cpp"
#include "../res/vectorized/show-target_32.cpp"
#include "../res/vectorized/show-source-target_32.cpp"
#include "../res/vectorized/punctuation-copy_32.cpp"
#include "../res/vectorized/punctuation-do-not-copy_32.cpp"

// rde added the following but, if it is actually needed we'll use wxMax()
//#ifndef max
//#define max(a,b)            (((a) > (b)) ? (a) : (b))
//#endif

// Globals

// next global is for passing to SetupCursorGlobals()'s third parameter, for box_cursor
// enum value of cursor_at_offset
int gnBoxCursorOffset = 0;

extern wxDynamicLibrary ecDriverDynamicLibrary;
extern const wxChar *FUNC_NAME_EC_INITIALIZE_CONVERTER_AW;
extern const wxChar *FUNC_NAME_EC_IS_INSTALLED;
extern const wxChar *FUNC_NAME_EC_CONVERT_STRING_AW;

/// This global is defined in SplitDialog.cpp.
extern bool gbIsDocumentSplittingDialogActive; // see SplitDialog.cpp

/// This global is defined in MainFrm.cpp.
extern bool gbIgnoreScriptureReference_Receive;

/// This global is defined in Adapt_It.cpp.
extern bool gbFreeTranslationJustRemovedInVFMdialog;

extern wxString ccErrorStr;	// used in CConsistentChanger

/// This global is defined in Adapt_It.cpp.
extern wxChar gSFescapechar; // the escape char used for start of a standard format marker

/// This global is defined in Adapt_It.cpp.
extern bool gbHasBookFolders; // TRUE when Adaptations folder is found to have Bible book

// extern declarations for free translation support (whm moved these to the app)

/// GDLC 2010-02-13 gnOffsetInMarkersStr and gnLengthInMarkersStr moved to CFreeTrans

/// The global gpCurFreeTransSectionPileArray was defined in Adapt_It.cpp, but was changed to a member variable
/// of the class CFreeTrans. GDLC 2010-02-16

/// This global is defined in Adapt_It.cpp.
extern wxArrayPtrVoid*	gpFreeTransArray; // new creates on heap in InitInstance, and disposes in ExitInstance

/// This global is defined in Adapt_It.cpp.
extern CPile*		gpFirstPile; // pointer to first pile in a free translation section

/// This global is defined in Adapt_It.cpp.
extern wxString	gSpacelessTgtPunctuation; // contents of app's m_punctuation[1] string with spaces removed

/// This global is defined in Adapt_It.cpp.
extern bool		gbSuppressSetup;

/// This global is defined in Adapt_It.cpp.
extern bool		gbSaveHilightingSetting;

// for support of auto-capitalization

/// This global is defined in Adapt_It.cpp.
extern bool	gbAutoCaps;

/// This global is defined in Adapt_It.cpp.
extern bool	gbSourceIsUpperCase;

/// This global is defined in Adapt_It.cpp.
extern bool	gbNonSourceIsUpperCase;

/// This global is defined in Adapt_It.cpp.
extern bool	gbMatchedKB_UCentry;

/// This global is defined in Adapt_It.cpp.
extern wxChar gcharNonSrcUC;

/// Next six defined in Adapt_It.cpp
extern bool	gbNoSourceCaseEquivalents;
extern bool	gbNoTargetCaseEquivalents;
extern wxChar gcharNonSrcLC;
extern wxChar gcharNonSrcUC;
extern wxChar gcharSrcLC;
extern wxChar gcharSrcUC;

extern bool gbUCSrcCapitalAnywhere; // TRUE if searching for capital at non-initial position
									// is enabled, FALSE is legacy initial position only
extern int  gnOffsetToUCcharSrc; // offset to source text location where the upper case
								 // character was found to be located, wxNOT_FOUND if not located

/// This global is defined in Adapt_It.cpp.
extern wxString szProjectConfiguration;

/// This global is defined in Adapt_It.cpp.
extern wxString szAdminProjectConfiguration;

/// This global is defined in Adapt_It.cpp
extern wxMutex s_AutoSaveMutex;

// next four are for version 2.0 which includes the option of a 3rd line for glossing

/// When TRUE it indicates that the application is in the "See Glosses" mode. In the
/// "See Glosses" mode any existing glosses are visible in a separate glossing line in
/// the main window, but words and phrases entered into the phrasebox are not entered
/// into the glossing KB unless gbGlossingVisible is also TRUE.
bool	gbIsGlossing = FALSE; // when TRUE, the phrase box and its line have glossing text

/// When TRUE the application is in true glossing mode. The phrasebox appears in the
/// main window's glossing line and contains glosses rather than normal adaptations.
/// The glosses entered or displayed in the phrasebox are stored in and retrieved from
/// the glossing KB.
bool	gbGlossingVisible = FALSE; // TRUE makes Adapt It revert to Shoebox functionality only

/// When TRUE the font used in glossing is the Navigation language font. Glossing uses
/// the Target font & settings by default, but if TRUE then it uses the Navigation language
/// font & direction settings.
bool	gbGlossingUsesNavFont = FALSE;

/// Defaults to FALSE to allow things like 3:sg:Subj or 1.incl to be put into the glossing
/// KB 'as is'. When TRUE punctuation is stripped out before saving the gloss in the glossing
/// KB; or, the stripping is done after the gloss has been saved
//bool	gbRemovePunctuationFromGlosses = FALSE; << BEW removed 13Nov10, it's never set TRUE

/// This flag is used to indicate that the text being processed is unstructured, i.e.,
/// not containing the standard format markers (such as verse and chapter) that would
/// otherwise make the document be structured. This global is used to restore paragraphing
/// in unstructured data, on export of source or target text.
bool	gbIsUnstructuredData = FALSE;

/// This global is defined in Adapt_It.cpp.
extern bool gbDoingInitialSetup;

// Note: for the following, when TRUE the item is placed into the body of the output text (as boxed
// paragraphs for non-interlinear RTF output; as separate table row for interlinear RTF output). When
// FALSE the item is placed as a footnote (at bottom of page).
extern bool bPlaceFreeTransInRTFText;	// default is TRUE
extern bool bPlaceBackTransInRTFText;	// default is FALSE
extern bool bPlaceAINotesInRTFText;		// default is FALSE

// whm 9Jun12 changed the type for filterMkr and filterMrkEnd to wxString (and remove const) to agree with the actual
// declaration in Adapt_ItDoc. Otherwise wxWidgets 2.9.3 generates a error LNK2001: unresolved external symbol "wchar_t const * const filterMkr"
extern wxString filterMkr; // defined in the Doc, used here in OnLButtonDown() & free translation code, etc
extern wxString filterMkrEnd; // defined in the Doc, used in free translation code, etc

// The following string is a list of markers that affect character formatting and the text
// to which they apply should not be filtered when the marker is filtered, only the markers
// themselves should be filtered out. This string of markers are used in RTF output
// routines
wxString charFormatMkrs = _T("\\qac \\qs \\qt \\nd \\tl \\dc \\bk \\pn \\wj \\k \\no \\bd \\it \\bdit \\em \\sc ");
// and the end marker forms
wxString charFormatEndMkrs = _T("\\qac* \\qs* \\qt* \\nd* \\tl* \\dc* \\bk* \\pn* \\wj* \\k* \\no* \\bd* \\it* \\bdit* \\em* \\sc* ");
// The following string is a list of markers that are embedded content
// markers for footnotes, endnotes and crossrefs
wxString embeddedWholeMkrs = _T("\\fr \\fk \\fq \\fqa \\ft \\fdc \\fv \\fm \\xo \\xt \\xk \\xq \\xdc ");
// and the end marker forms
wxString embeddedWholeEndMkrs = _T("\\fr* \\fk* \\fq* \\fqa* \\ft* \\fdc* \\fv* \\fm* \\xo* \\xt* \\xk* \\xq* \\xdc* ");

// The following string is a list of sfms which are significant enough to become a halting
// point for the immediate placement of pending back translation material.
// NOTE: Before checking if a given Marker is included in these strings any numerical level
// part of the Marker to be checked should be removed, i.e., \th1 should be changed to \th,
// \mt1 should be changed to \mt etc. This is done in IsBTMaterialHaltingPoint().
// The following markers should NOT trigger a halt point:
//   end markers of all kinds
//   running header markers \h \h1 \h2 \h3 (these are removed early from buffer)
//	 \note
//   character formatting markers
// BEW 6Sep10, added functions IsEmbeddedWholeMkr(), and IsAHaltingMarker(), for OXES
// export, which make use of the embeddedWholeMrks, embeddedWholeEndMkrs, and, for the
// IsAHaltingMarker() function, the commonHaltingMarkers list. In the latter case, we are
// using it for OXES parsing of SFM or USFM data, and so we want to halt if we parse to a \h
// or \h1 \h2 or \h3 or a \note, so these are included by forming a wxString in the
// USFM2Oxes class at the beginning of processing
wxString commonHaltingMarkers = _T("\\v \\c \\p \\m \\q \\qc \\qm \\qr \\qa \\pi \\mi \\pc \\pt \\ps \\pgi \\cl \\vn \\f \\fe \\x \\gd \\tr \\th \thr \\tc \\tcr \\mt \\st \\mte \\div \\ms \\s \\sr \\sp \\d \\di \\hl \\r \\dvrf \\mr \\br \\rr \\pp \\pq \\pm \\pmc \\pmr \\cls \\imt \\imte \\is \\ip \\ipi \\ipq \\ipr \\iq \\im \\imi \\imq \\io \\iot \\iex \\ie \\li \\qh \\gm \\gs \\gd \\gp \\tis \\tpi \\tps \\tir \\pb \\hr ");
wxString btHaltingMarkers = commonHaltingMarkers;

// The following string is a list of sfms which are significant enough to become a halting
// point for the immediate placement of pending free translation material.
// NOTE: Before checking if a given Marker is included in these strings any numerical level
// part of the Marker to be checked should be removed, i.e., \th1 should be changed to \th,
// \mt1 should be changed to \mt etc. This is done in IsFreeMaterialHaltingPoint().
wxString freeHaltingMarkers = commonHaltingMarkers;

// The following string arrays are used to construct the cell elements of Interlinear RTF
// output They are populated by BuildInterlinearTextStrArrays(), which is patterned after
// the BuildTargetText() function, but populates the elements of the string into the four
// string arrays below rather than as a single wxString.
wxArrayString SrcStrArray;
wxArrayString TgtStrArray;
wxArrayString GlsStrArray;
wxArrayString NavStrArray;

extern bool gbRTLLayout; // defined in FontPage.cpp
extern bool gbLTRLayout;

/// This global is defined in Adapt_It.cpp.
extern bool	gbRTL_Layout;	// ANSI version is always left to right reading; this flag can only
							// be changed in the Unicode version, using the extra Layout menu

/// This global is defined in Adapt_It.cpp.
extern int	gnVerticalBoxBloat; // see CAdapt_ItApp (bloats vertical dim'n of phrasebox for unicode version)

// basic format integer for use in the DrawText() function (see CDC), since unicode will need
// DrawText()
// MFC has the following bitwise flag set as the default nFormat flag in DrawText:
//UINT gnFormat = DT_SINGLELINE | DT_EXTERNALLEADING | DT_NOCLIP | DT_NOPREFIX | DT_TOP;	// DT_LEFT
																							// is default
// The MFC version ORs other DT flags with the gnFormat flag to produce the globals
// gnRTLFormat and gnLTRFormat; this is done in the View's OnInitialUpdate() as follows:
// gnRTLFormat = gnFormat | DT_RIGHT | DT_RTLREADING;
// gnLTRFormat = gnFormat | DT_LEFT;
// Then, later the appropriate gn...Format is assigned to a local nFormat value which is fed to
// the MFC DrawText(str,rect,nFormat) function to effect both right alignment and right-to-left
// reading of the text being drawn.
// whm note: MFC docs say of DT_LEFT, DT_RIGHT and DT_RTLREADING:
//    "DT_LEFT - Aligns text to the left."
//    "DT_RIGHT - Aligns text to the right."
//    "DT_RTLREADING - Layout in right-to-left reading order for bi-directional text when the
//                    font selected into the hdc is a Hebrew or Arabic font. The default
//                    reading order for all text is left-to-right."

// whm NOTE: wxDC::DrawText(const wxString& text, wxCoord x, wxCoord y) does not have an
// equivalent to the MFC DrawText's nFormat parameter, but instead wxDC has a
// SetLayoutDirection(wxLayoutDirection dir) method to change the logical direction or
// mirroring of the display context. In wxDC the display context is mirrored right-to-left
// when wxLayout_RightToLeft is passed as the parameter; Certain controls that contain text
// strings such as wxTextCtrl and wxListBox, etc., also have an undocumented method called
// SetLayoutDirection(wxLayoutDirection dir), where dir is wxLayout_LeftToRight or
// wxLayout_RightToLeft.
// Setting the layout to wxLayout_RightToLeft on these controls also involves some
// mirroring affecting the control itself, so that any scrollbar that gets displayed, for
// example, displays on the left side of the control rather than on the right, etc.
// In the wx version we have to be careful about the automatic mirroring features involved
// in the SetLayoutDirection() function. Since Adapt It MFC was designed to micromanage the
// layout direction itself as well as alignment in the coding of text, cells, piles,
// strips, etc., we no doubt encounter problems in layout and must avoid inadvertently
// "reversing" parts of the RTL layout because of the micromanaged layout done in the
// coding of the MFC version.

//////////////////////////////////////////////////////////////////////////////////////
// BEW 7May08: the next globals are for source text editing; the refactored functionality
// may not need all these... and including those for the refactored code (after the old
// ones)

int gnCount; // count of old srcphrases (user selected these) after unmerges, etc
int gnNewCount; // count of the new srcphrases (after user finished editing the source text)

/// A pointer to a sourcephrase immediately preceding the first one in a sublist of old
/// source phrase instances.
CSourcePhrase* gpPrecSrcPhrase;

/// A pointer to a sourcephrase immediately following the ones in a sublist of source
/// phrase instances in which their m_srcPhrase attributes have new (edited) values,
/// or 0 if none; we need access to the following sourcephrase in case the user changes
/// markers and then the m_bFirstOfType flag on gpFollSrcPhrase would often need to be
/// reset TRUE.
CSourcePhrase* gpFollSrcPhrase;

// This global was defined in TransferMarkersDlg.cpp in the legacy MFC app.
/// This global is TRUE if the TextType needs to be propagated to sourcephrase instances
/// following the new sublist, after all housekeeping is done & propagation is done in
/// OnEditSourceText().
bool gbPropagationNeeded;

// This global was defined in TransferMarkersDlg.cpp (now removed) in the legacy MFC app.
/// Indicates the TextType to be propagated when the gbPropagationNeeded global is TRUE
TextType gPropagationType; // the TextType to be propagated

/// This global is defined in Adapt_ItDoc.cpp.
extern bool		gbSpecialText;  // the special text boolean which will need to be propagated,
								// if propagation is required


// BEW additional globals and defines, 14Apr08, for support of the vertical editing process

// The next two globals track the vertical edit update process; when
// gbVerticalEditInProgress is turned on (TRUE), the gEntryPoint value specifies what the
// entry point was; this enables the code for any of the vertical edit processing steps to
// be able to determine what kind of edit initiated the vertical update process (eg. a
// source text edit, or an adaptation edit, etc), which in turn enables that code to know
// what members of the gEditRecord struct can be expected to have data in them which can be
// used by the current processing step of the vertical sequence. Each step also has its own
// enum value in the global gEditStep, so that if backtracking through the steps is
// required, the code can know where it must start from in the total process. Also, if the
// user edited a misspelled SF marker, and the marker which results is one nominated for
// filtering or unfiltering, the filtering or unfiltering will take place - changing the
// number of CSourcePhrase instances in the document. The bail out process must be smart
// enough to restore the original doc state when necessary given such a filtering or
// unfiltering has taken place; and we want exceptions to cause restoration of the pre-edit
// document state, rather than application death
/// Tracks whether or not vertical editing is currently in effect, and it has to be TRUE
/// for the drawing of gray text in preceding and following context of the span which is
/// being updated during the vertical edit process
bool gbVerticalEditInProgress = FALSE; // TRUE while any stage of a vertical edit process is active

/// During editing of the source text, up to a certain stage the native document structures
/// are not modified, making it possible to abandon the source text edit without restoring
/// anything in the document while this boolean remains TRUE; once it is FALSE the native
/// structures have begun to be modified and a different source editing abandonment
/// strategy is required (and implemented)
bool gbEditingSourceAndDocNotYetChanged = TRUE; // programmatically cleared to FALSE when doc is changed

/// This global enum tracks the entry point to the vertical editing process - there are
/// five possible values noEntryPoint (0), sourceTextEntryPoint (1), adaptationsEntryPoint
/// (2), glossesEntryPoint (3), freeTranslationsEntryPoint (4). Definition is in
/// Adapt_ItView.h
EntryPoint	gEntryPoint = noEntryPoint;  // from an enum, the value can be one of
			// noEntryPoint (0), sourceTextEntryPoint (1), adaptationsEntryPoint (2),
			// glossesEntryPoint (3), or freeTranslationsEntryPoint (4) (see Adapt_ItView.h)

/// This global enum tracks which step in the vertical editing process is currently in
/// effect. These "steps" are names for various Adapt It modes which otherwise the user
/// would need to manually turn on by menu commands, such as editing the source text,
/// adapting mode, glossing mode, free translation mode, and collecting data from the
/// adaptation or gloss line in order to store it as a filtered back translation; the
/// default value is noEditStep which is the value in effect when vertical editing is not
/// in progress
EditStep gEditStep = noEditStep; // see Adapt_ItView.h

/// Determines the relative order of the adaptationsStep and glossesStep during the
/// vertical process, the default order is to do the adaptations step prior to the glossing
/// step (the TRUE value); the value determines the program counter's path through the code
/// both when stepping forwards through the vertical edit process and also when rolling
/// back changes made at an earlier stage of the process
bool gbAdaptBeforeGloss = TRUE; // TRUE (default) if adaptationsStep is to be done
        // before glossesStep, FALSE for the opposite order (value of this global stored in
        // project configuration file)

/// The EditRecord is a struct, one instance of which persists as long as the session is
/// alive. It stores information about the vertical edit process which enables rollback and
/// cancellation to be supported. Its members are returned to default values, and most
/// lists emptied, when any one invocation of the vertical edit process is completed.
///
/// EditRecord is defined in Adapt_It.h file, here the comments are removed
/// to make reading the members easier
/// typedef struct
/// {
///     CSourcePhrase*  activeCSourcePhrasePtr;
/// 	bool			bGlossingModeOnEntry;
/// 	bool			bSeeGlossesEnabledOnEntry;
/// 	bool			bEditSpanHasAdaptations;
/// 	bool			bEditSpanHasGlosses;
/// 	bool			bEditSpanHasFreeTranslations;
/// 	bool			bEditSpanHasBackTranslations;
/// 	bool			bCollectedFromTargetText;
///
/// 	int				nSaveActiveSequNum;
/// 	wxString		oldPhraseBoxText;
/// 	TextType		nStartingTextType;
/// 	TextType		nEndingTextType;
/// 	wxArrayString		deletedAdaptationsList;
/// 	wxArrayString		deletedGlossesList;
/// 	wxArrayString		deletedFreeTranslationsList;
/// 	wxArrayString		storedNotesList;
/// 	int				nStartingSequNum;
/// 	int				nEndingSequNum;
/// 	int				nFreeTrans_StartingSequNum;
/// 	int				nFreeTrans_EndingSequNum;
/// 	int				nBackTrans_StartingSequNum;
/// 	int				nBackTrans_EndingSequNum;
/// 	int				nCancelSpan_StartingSequNum;
/// 	int				nCancelSpan_EndingSequNum;
/// 	SPList			cancelSpan_SrcPhraseList;
/// 	SPList			modificationsSpan_SrcPhraseList;
/// 	SPList			editableSpan_NewSrcPhraseList;
/// 	SPList			propagationSpan_SrcPhraseList;
/// 	int				nPropagationSpan_StartingSequNum;
/// 	int				nPropagationSpan_EndingSequNum;
/// 	wxArrayInt		arrNotesSequNumbers;
/// 	CArray<int,int> arrNotesSequNumbers;
/// 	int				nOldSpanCount;
/// 	int				nNewSpanCount;
/// 	wxString		strInitialEndmarkers;
/// 	wxString		strFinalEndmarkers;
/// 	wxString		strNewFinalEndmarkers;
/// 	bool			bSpecialText;
/// 	SPList			follNotesMoveSpanList;
/// 	SPList			precNotesMoveSpanList;
/// 	bool			bTransferredFilterStuffFromCarrierSrcPhrase;
/// 	bool			bDocEndPreventedTransfer;
/// 	bool			bExtendedForFiltering;
///
/// 	bool			bAdaptationStepEntered;
/// 	SPList			adaptationStep_SrcPhraseList;
/// 	int				nAdaptationStep_StartingSequNum;
/// 	int				nAdaptationStep_EndingSequNum;
/// 	int				nAdaptationStep_OldSpanCount;
/// 	int				nAdaptationStep_NewSpanCount;
/// 	int				nAdaptationStep_ExtrasFromUserEdits;
///
/// 	bool			bGlossStepEntered;
/// 	SPList			glossStep_SrcPhraseList;
/// 	int				nGlossStep_StartingSequNum;
/// 	int				nGlossStep_EndingSequNum;
/// 	int				nGlossStep_SpanCount;
///
/// 	bool			bFreeTranslationStepEntered;
/// 	bool			bVerseBasedSection;
/// 	SPList			freeTranslationStep_SrcPhraseList;
/// 	int				nFreeTranslationStep_StartingSequNum;
/// 	int				nFreeTranslationStep_EndingSequNum;
/// 	int 			nFreeTranslationStep_SpanCount;
/// } EditRecord;


// The vertical editing process helps the user to edit/update dependent information, when
// editing information at a higher line of a strip invalidates information already entered
// in lower lines which depend on the higher line. The design of the topmost possible level
// of the process, the Edit Source Text functionality, requires a refactored dialog, minus
// the old and complex child dialog where SF markup was separately accessible; the
// refactored design eliminates the latter and shows SF markup and source text together,
// both accessible for editing. To keep the information non-confusing, notes, free
// translations, and any collected back translations defined in any part of the editable
// span, are removed - and retained in lists made accessible to the user later in the
// process (except removed back translations are chucked). The design involves careful
// delineation of four spans where certain types of information are removed from sublists
// -- see the comments for the definition of EditRecord in Adapt_ItView.h for extra
// details. To keep error recovery and cancelling as simple as possible when restoring the
// document to its earlier state, the m_pSourcePhrases list which defines the document is
// not changed until the very last moment when the user's edit is accepted (by the OK
// button press). This means that modifications needed to be done to CSourcePhrase
// instances prior to that, are done on deep copied instances in sublists stored in the
// EditRecord.
// The four spans (implemented as CObList and two int variables per span for the starting
// and ending offsets within the m_pSourcePhrases list on the document) are 1. the editable
// span (the user's selection, but extended to embrace any retranslation/s which the
// selection may overlap), 2. the cancel span - as wide as is necessary to hold deep copies
// of CSourcePhrase instances modified in the edit process (except it perhaps might not
// include all of the propagation span), 3. the modifications span - coextensive with the
// cancel span, but in which needed data modifications (primarily removal of distracting
// information types) are done prior to the Edit Source Text dialog being displayed, and 4.
// the propagation span - a span, possibly empty, or possibly containing numerous deep
// copies of the original CSourcePhrases following the editable span and where propagation
// of a new TextType after the source text edit was done resulted in CSourcePhrase changes.
// Span 1 always lies within spans 2 and 3; span 4 begins, if at all, immediately after
// span 1 and it may overlap completely or partially with instances in the end of spans 2
// and 3.

/// This define specifies the maximum number of etnries in the list of removed data types
/// (whether adaptations, glosses, or free translations) removed programmatically because
/// they have become invalid due to higher level changes during the vertical edit process.
/// Once this limit is reached in any of the three lists, adding more removes drops a
/// corresponding number of entries permanently off the bottom of that particular list
#define DELETIONS_LIST_MAX_ENTRIES 100

/// The vertical edit process tries to determine whether free translation sections, when
/// the user entered the free translations, were defined by punctuation locations, or verse
/// boundaries (for either setting, SF markers also influence the outcome), so that the
/// vertical edit process can use the same setting when the freeTranslationsStep is
/// entered. An algorithm does this but it cannot do it 100% reliably, and if all the
/// strong indicators are absent then it assumes that the 'verse boundaries" setting was in
/// effect if it can count off at least this number of free translation words within the
/// current section being algorithmically checked
#define NUM_WORDS_IMPLYING_VERSE_SECTIONING 15
// Comment out next line to suppress logging when restoring the KB from File menu's Restore Knowledge Base()
//#define LOG_RESTORE

/// This global provides a persistent location during the current session for storage of
/// vertical edit information
EditRecord gEditRecord; // store info pertinent to generalized editing with entry
		// point for an Edit Source Text request, in this global structure

/// This global string variable stores the previous contents of the edit box (either the
/// phrase box or the compose bar's edit box) when the user has just made a choice from the
/// removals combobox's list which replaces the box's text. It enables the Undo Last Copy
/// button to restore the box's previous contents provided further ducks line line up - see
/// the next four global variables for details
wxString gOldEditBoxTextStr; // a place to store the text replaced by the last copy from one of
							// the Removed combobox list's entries

/// This stores the sequence number at which the phrase box was located when the edit box's
/// contents were replaced. The Undo Last Changes button will not undo the last change
/// unless the phrase box has been placed back at this location by the user (the button is
/// disabled until that happens)
int gnWasSequNum;

/// This stores the the m_nSrcWords value when the edit box's contents were replaced. (Just
/// the sequence number value being the same is not sufficient, because the user may
/// subsequently have merged or unmerged at that location - so the merger state (in terms
/// of number of source words) must be the same as a condition for the Undo Last Copy
/// button to be enabled.)
int gnWasNumWordsInSourcePhrase;

/// A further condition for enabling the Undo Last Copy button is that the mode must be the
/// same as it was at the time the replacement was made; this global stores the earlier
/// mode - the values of relevance are whether it was adapting or glossing mode, and so a
/// boolean is suffient for those
bool gbWasGlossingMode; // the mode at last insert, either glossing mode (TRUE) or adapting mode (FALSE)

/// A final condition for enabling the Undo Last Copy button is that whether or not free
/// translation mode was turned on at the time the replacement was made; this mode can be
/// on or off concurrently with either of adapting or glossing modes, and so a further
/// boolean is needed to store the earlier state's value
bool gbWasFreeTranslationMode; // TRUE if free translation mode was in effect at last
    // insert, in which case gbWasGlossingMode value is ignored, the latter is used if
    // gbWasFreeTranslationMode is FALSE

// end of additional gobals and defines for support of the modeless editing process

// BEW added 15July08; definitions for custom events used in the vertical edit process,
// which typically starts with a source text edit, but in the wxWidgets based apps it could
// also be an adaptation edit, gloss edit, or free translation edit that starts it off;
// these events are UINT
// These custom events are implemented in the CMainFrame class in wx version; I'm leaving
// them commented out here in order to document that they exist - but elsewhere
//UINT CUSTOM_EVENT_ADAPTATIONS_EDIT = RegisterWindowMessage(_T("CustomEventAdaptationsEdit"));
//UINT CUSTOM_EVENT_FREE_TRANSLATIONS_EDIT = RegisterWindowMessage(_T("CustomEventFreeTranslationsEdit"));
//UINT CUSTOM_EVENT_BACK_TRANSLATIONS_EDIT = RegisterWindowMessage(_T("CustomEventBackTranslationsEdit"));
//UINT CUSTOM_EVENT_COLLECTED_BACK_TRANSLATIONS_EDIT
//							= RegisterWindowMessage(_T("CustomEventVCollectedBackTranslationsEdit"));
//UINT CUSTOM_EVENT_END_VERTICAL_EDIT = RegisterWindowMessage(_T("CustomEventEndVerticalEdit"));
//UINT CUSTOM_EVENT_CANCEL_VERTICAL_EDIT = RegisterWindowMessage(_T("CustomEventCancelVerticalEdit"));
//UINT CUSTOM_EVENT_GLOSSES_EDIT = RegisterWindowMessage(_T("CustomEventGlossesEdit"));

bool gbVerticalEdit_SynchronizedScrollReceiveBooleanWasON = FALSE;

// BEW 7May08: end of vertical editing's globals, including those
// for the refactored code for src text editing
/////////////////////////////////////////////////////////////////////////////////////

extern int		gnLastEarlierChapter; // preserve chapter and verse number used in last call of
extern int		gnLastEarlierVerse;	  // View Earlier Translation dialog

wxRect			grectViewClient;

/// When TRUE the main window only displays the target text lines.
bool			gbShowTargetOnly = FALSE;

/// Used to store the App's m_curLeading value when switching between views that only
/// display the target language and those that display normal target lines.
int				gnSaveLeading = 4;

/// This global is defined in Adapt_It.cpp.
extern  int		nSequNumForLastAutoSave;

/// This global is defined in Adapt_ItDoc.cpp.
extern	bool	bUserCancelled;

extern  bool	gbJustCancelled; // set TRUE when Find or Find & Replace dialog
        // window has just been cancelled and needed for view's OnButtonMerge() function,
        // the look ahead code block

// global to make source phrase accessible to dialogs and to the callback functions of the
// xml parser (so this has multiple uses - beware)
CSourcePhrase* gpSrcPhrase;

SPList gSrcPhrases; // for list of CSourcePhrase instances in the retranslation

// global pointer to the punctuation remainder list, for use by CPlaceInternalPunct
wxArrayString* gpRemainderList = (wxArrayString*)NULL; // MFC uses CStringList*

/// TRUE if a consistency check is in progress. Used to supress the placement of the
/// phrase box when documents are opened while performing a consistency check.
bool	gbConsistencyCheckCurrent = FALSE;

// some globals for use in merging
wxString gOldConcatStr = _T("");			// may have punctuation
wxString gOldConcatStrNoPunct = _T("");  // has any punctuation removed

// miscellaneous
bool	gbJustClosedProject = FALSE; // use to suppress Welcome to Adapt It window after doc opened

// global, for choosing whether Find... or Find and Replace... comes up
bool	gbFind = TRUE;
bool	gbFindIsCurrent = FALSE;
bool	gbJustReplaced = FALSE;
bool	gbFindOrReplaceCurrent = FALSE; // for use by CMainFrame's OnActive() function

// globals for handling advancement over a found retranslation
//bool gbMatchedRetranslation = FALSE; BEW 3Aug09 changed it to be the app member
//m_bMatchedRetranslation
int  gnRetransEndSequNum; // sequ num of last srcPhrase in a matched retranslation

// global for alerting OnLButtonUp() that selection has been halted at a boundary
// (set in OnMouseMove())
bool	gbHaltedAtBoundary = FALSE;

/// This global is defined in Adapt_It.cpp.
extern wxPoint gptLastClick;

/// For preserving selection across a RecalcLayout() or LayoutStrip().
int		gnSelectionStartSequNum;

/// For preserving selection across a RecalcLayout() or LayoutStrip().
int		gnSelectionEndSequNum;

/// Preserved value of m_selectionLine
int		gnSelectionLine;

bool	gbIsBeingPreviewed = FALSE; // true while a print preview is being done
int		gnPrintingLength; // ditto for the printing length of the page
int		gnFromChapter = 1;
int		gnFromVerse = 1;
int		gnToChapter = 1;
int		gnToVerse = 1;
int		gnRangeStartSequNum;
int		gnRangeEndSequNum;
bool	gbCheckInclFreeTransText = FALSE; // klb 9/9/2011-indicates whether to
					// include Free Translation Text when printing-set in PrintOptionsDlg
bool	gbCheckInclGlossesText = FALSE; // klb 9/9/2011-indicates whether to include
					// Glosses Text when printing-set in PrintOptionsDlg

/// If TRUE print the footer, otherwise skip printing of footer
bool	gbPrintFooter = TRUE;

bool    gbPrintOnlyPgNumInFooter = FALSE;

int		gnTopGap = 100; // units of thousandths of an inch for this and next two
int		gnFooterTextHeight = 150; // for the text of the footer, units of thousandths of an inch
int		gnBottomGap = 0; // assume we can print right to the rtMinMargin.bottom limit on the page
bool	gbSuppressPrecedingHeadingInRange = FALSE;
bool	gbIncludeFollowingHeadingInRange = FALSE;

IMPLEMENT_DYNAMIC_CLASS(CAdapt_ItView, wxView)

BEGIN_EVENT_TABLE(CAdapt_ItView, wxView)
	// Event table data copied from Win AI with ON_COMMAND macro
	// changed to EVT_MENU, and ON_UPDATE_COMMAND_UI changed to
	// EVT_UPDATE_UI for wxWidgets
    EVT_SIZE(CAdapt_ItView::OnSize)

	// File Menu
	EVT_UPDATE_UI(wxID_NEW, CAdapt_ItView::OnUpdateFileNew)
	EVT_UPDATE_UI(wxID_OPEN, CAdapt_ItView::OnUpdateFileOpen)

	// Standard printing commands
	EVT_MENU(wxID_PRINT, CAdapt_ItView::OnPrint)
	EVT_UPDATE_UI(wxID_PRINT, CAdapt_ItView::OnUpdateFilePrint)
	EVT_MENU(wxID_PREVIEW, CAdapt_ItView::OnPrintPreview)
	EVT_UPDATE_UI(wxID_PREVIEW, CAdapt_ItView::OnUpdateFilePrintPreview)
	EVT_MENU(ID_FILE_STARTUP_WIZARD, CAdapt_ItView::OnFileStartupWizard)
	EVT_MENU(ID_FILE_CLOSEKB, CAdapt_ItView::OnFileCloseProject)
	EVT_UPDATE_UI(ID_FILE_CLOSEKB, CAdapt_ItView::OnUpdateFileCloseKB)
	EVT_MENU(ID_FILE_SAVEKB, CAdapt_ItView::OnFileSaveKB)
	EVT_UPDATE_UI(ID_FILE_SAVEKB, CAdapt_ItView::OnUpdateFileSaveKB)
	// End of File Menu

	// Edit Menu
	EVT_MENU(wxID_UNDO, CAdapt_ItView::OnEditUndo)
	EVT_UPDATE_UI(wxID_UNDO, CAdapt_ItView::OnUpdateEditUndo)
	EVT_MENU(ID_EDIT_CUT, CAdapt_ItView::OnEditCut)
	EVT_UPDATE_UI(ID_EDIT_CUT, CAdapt_ItView::OnUpdateEditCut)
	EVT_MENU(ID_EDIT_COPY, CAdapt_ItView::OnEditCopy)
	EVT_UPDATE_UI(ID_EDIT_COPY, CAdapt_ItView::OnUpdateEditCopy)
	EVT_MENU(ID_EDIT_PASTE, CAdapt_ItView::OnEditPaste)
	EVT_UPDATE_UI(ID_EDIT_PASTE, CAdapt_ItView::OnUpdateEditPaste)
	EVT_MENU(ID_GO_TO, CAdapt_ItView::OnGoTo)
	EVT_UPDATE_UI(ID_GO_TO, CAdapt_ItView::OnUpdateGoTo)
	EVT_MENU(ID_EDIT_SOURCE_TEXT, CAdapt_ItView::OnEditSourceText)
	EVT_UPDATE_UI(ID_EDIT_SOURCE_TEXT, CAdapt_ItView::OnUpdateEditSourceText)

	EVT_MENU(wxID_PREFERENCES, CAdapt_ItView::OnEditPreferences)
	EVT_UPDATE_UI(wxID_PREFERENCES, CAdapt_ItView::OnUpdateEditPreferences)
	// End of Edit Menu

	// View Menu
	EVT_MENU(ID_COPY_SOURCE, CAdapt_ItView::OnCopySource)
	EVT_UPDATE_UI(ID_COPY_SOURCE, CAdapt_ItView::OnUpdateCopySource)
    EVT_MENU(ID_SELECT_COPIED_SOURCE, CAdapt_ItView::OnSelectCopiedSource)
    EVT_UPDATE_UI(ID_SELECT_COPIED_SOURCE, CAdapt_ItView::OnUpdateSelectCopiedSource)
	EVT_MENU(ID_MARKER_WRAPS_STRIP, CAdapt_ItView::OnMarkerWrapsStrip)
	EVT_UPDATE_UI(ID_MARKER_WRAPS_STRIP, CAdapt_ItView::OnUpdateMarkerWrapsStrip)
	EVT_MENU(ID_UNITS, CAdapt_ItView::OnUnits)
	EVT_UPDATE_UI(ID_UNITS, CAdapt_ItView::OnUpdateUnits)
	// whm added the following two 16Apr07
	EVT_UPDATE_UI(ID_CHANGE_INTERFACE_LANGUAGE, CAdapt_ItView::OnUpdateChangeInterfaceLanguage)
	EVT_MENU(ID_CHANGE_INTERFACE_LANGUAGE, CAdapt_ItView::OnChangeInterfaceLanguage)
	// End of View Menu

	// Tools Menu
	EVT_MENU(wxID_FIND, CAdapt_ItView::OnFind)
	EVT_UPDATE_UI(wxID_FIND, CAdapt_ItView::OnUpdateFind)
	EVT_MENU(wxID_REPLACE, CAdapt_ItView::OnReplace)
	EVT_UPDATE_UI(wxID_REPLACE, CAdapt_ItView::OnUpdateReplace)
	EVT_MENU(ID_USE_CC, CAdapt_ItView::OnUseConsistentChanges)
	EVT_UPDATE_UI(ID_USE_CC, CAdapt_ItView::OnUpdateUseConsistentChanges)

	EVT_MENU(ID_USE_SILCONVERTER, CAdapt_ItView::OnUseSilConverter)
	EVT_UPDATE_UI(ID_USE_SILCONVERTER, CAdapt_ItView::OnUpdateUseSilConverter)
	EVT_MENU(ID_TOOLS_DEFINE_SILCONVERTER, CAdapt_ItView::OnSelectSilConverters)
	EVT_UPDATE_UI(ID_TOOLS_DEFINE_SILCONVERTER, CAdapt_ItView::OnUpdateSelectSilConverters)

	EVT_MENU(ID_ACCEPT_CHANGES, CAdapt_ItView::OnAcceptChanges)
	EVT_UPDATE_UI(ID_ACCEPT_CHANGES, CAdapt_ItView::OnUpdateAcceptChanges)
	EVT_MENU(ID_TOOLS_KB_EDITOR, CAdapt_ItView::OnToolsKbEditor)
	EVT_UPDATE_UI(ID_TOOLS_KB_EDITOR, CAdapt_ItView::OnUpdateToolsKbEditor)
	// End of Tools Menu

	// Export-Import Menu
	EVT_MENU(ID_FILE_EXPORT_SOURCE, CAdapt_ItView::OnFileExportSource)
	EVT_UPDATE_UI(ID_FILE_EXPORT_SOURCE, CAdapt_ItView::OnUpdateFileExportSource)
	EVT_MENU(ID_FILE_EXPORT, CAdapt_ItView::OnFileExport)
	EVT_UPDATE_UI(ID_FILE_EXPORT, CAdapt_ItView::OnUpdateFileExport)
	EVT_MENU(ID_FILE_EXPORT_TO_RTF, CAdapt_ItView::OnFileExportToRtf)
	EVT_UPDATE_UI(ID_FILE_EXPORT_TO_RTF, CAdapt_ItView::OnUpdateFileExportToRtf)
	EVT_MENU(ID_EXPORT_GLOSSES, CAdapt_ItView::OnExportGlossesAsText)
	EVT_UPDATE_UI(ID_EXPORT_GLOSSES, CAdapt_ItView::OnUpdateExportGlossesAsText)
	EVT_MENU(ID_EXPORT_FREE_TRANS, CAdapt_ItView::OnExportFreeTranslations)
	EVT_UPDATE_UI(ID_EXPORT_FREE_TRANS, CAdapt_ItView::OnUpdateExportFreeTranslations)
	EVT_MENU(ID_IMPORT_TO_KB, CAdapt_ItView::OnImportToKb)
	EVT_UPDATE_UI(ID_IMPORT_TO_KB, CAdapt_ItView::OnUpdateImportToKb)
	EVT_MENU(ID_MENU_IMPORT_EDITED_SOURCE_TEXT, CAdapt_ItView::OnImportEditedSourceText)
	EVT_UPDATE_UI(ID_MENU_IMPORT_EDITED_SOURCE_TEXT, CAdapt_ItView::OnUpdateImportEditedSourceText)
	// End of Export-Import Menu

	// Advanced Menu
	// Event for Enable/Disable Glossing menu item
	EVT_MENU(ID_ADVANCED_SEE_GLOSSES, CAdapt_ItView::OnAdvancedSeeGlosses)
	EVT_UPDATE_UI(ID_ADVANCED_SEE_GLOSSES, CAdapt_ItView::OnUpdateAdvancedEnableglossing)
	// Event for Glossing Uses Nav Font menu item
	EVT_MENU(ID_ADVANCED_GLOSSING_USES_NAV_FONT, CAdapt_ItView::OnAdvancedGlossingUsesNavFont)
	EVT_UPDATE_UI(ID_ADVANCED_GLOSSING_USES_NAV_FONT, CAdapt_ItView::OnUpdateAdvancedGlossingUsesNavFont)
	EVT_MENU(ID_ADVANCED_DELAY, CAdapt_ItView::OnAdvancedDelay)
	EVT_UPDATE_UI(ID_ADVANCED_DELAY, CAdapt_ItView::OnUpdateAdvancedDelay)

	// 12 menu definitions moved to CFreeTrans

	EVT_MENU(ID_ADVANCED_USETRANSLITERATIONMODE, CAdapt_ItView::OnAdvancedUseTransliterationMode)
	EVT_UPDATE_UI(ID_ADVANCED_USETRANSLITERATIONMODE, CAdapt_ItView::OnUpdateAdvancedUseTransliterationMode)
	// End of Advanced Menu

//#ifdef _UNICODE
	// Layout Menu
	EVT_MENU(ID_ALIGNMENT, CAdapt_ItView::OnAlignment)
	EVT_UPDATE_UI(ID_ALIGNMENT, CAdapt_ItView::OnUpdateAlignment)
#if defined(_DEBUG)
	// BEW 10Oct19, want a menu item in Administrator menu
	// in whose handler I can drop code for things I want to develop without
	// affecting the rest of the app. Only in _Debug mode
	EVT_MENU(ID_MENU_ITEM_HIDDEN, CAdapt_ItView::OnHiddenMenuItem)
	EVT_UPDATE_UI(ID_MENU_ITEM_HIDDEN, CAdapt_ItView::OnUpdateHiddenMenuItem)
#endif
//#endif

	// Help menu
	//OnAppAbout is in CMainFrame in wxWidgets version

	// ControlBar event handlers
	EVT_CHECKBOX(IDC_CHECK_ISGLOSSING, CAdapt_ItView::OnCheckIsGlossing)
	EVT_RADIOBUTTON(IDC_RADIO_DRAFTING, CAdapt_ItView::OnRadioDrafting)
	EVT_UPDATE_UI(IDC_RADIO_DRAFTING, CAdapt_ItView::OnUpdateRadioDrafting)
	EVT_RADIOBUTTON(IDC_RADIO_REVIEWING, CAdapt_ItView::OnRadioReviewing)
	EVT_UPDATE_UI(IDC_RADIO_REVIEWING, CAdapt_ItView::OnUpdateRadioReviewing)
	EVT_CHECKBOX(IDC_CHECK_SINGLE_STEP, CAdapt_ItView::OnCheckSingleStep)
	EVT_UPDATE_UI(IDC_CHECK_SINGLE_STEP, CAdapt_ItView::OnUpdateCheckSingleStep)
	EVT_CHECKBOX(ID_CHECKBOX_USE_AUTOCORRECT, CAdapt_ItView::OnCheckUseAutoCorrect) // whm 30Aug2021 added
	EVT_UPDATE_UI(ID_CHECKBOX_USE_AUTOCORRECT, CAdapt_ItView::OnUpdateCheckUseAutoCorrect) // whm 30Aug2021 added
	EVT_CHECKBOX(IDC_CHECK_KB_SAVE, CAdapt_ItView::OnCheckKBSave)
	EVT_CHECKBOX(IDC_CHECK_FORCE_ASK, CAdapt_ItView::OnCheckForceAsk)
	EVT_BUTTON(IDC_BUTTON_NO_ADAPT, CAdapt_ItView::OnButtonNoAdapt)
	EVT_UPDATE_UI(IDC_BUTTON_NO_ADAPT, CAdapt_ItView::OnUpdateButtonNoAdapt)

	// ToolBar event handlers
	// toggle toolbar buttons (these were in 2 separate handlers for the old toolbar)
	EVT_TOOL(ID_BUTTON_RESPECTING_BDRY, CAdapt_ItView::OnToggleRespectBoundary)
	EVT_UPDATE_UI(ID_BUTTON_RESPECTING_BDRY, CAdapt_ItView::OnUpdateToggleRespectBoundary)
	EVT_TOOL(ID_BUTTON_SHOWING_PUNCT, CAdapt_ItView::OnToggleShowPunctuation)
	EVT_UPDATE_UI(ID_BUTTON_SHOWING_PUNCT, CAdapt_ItView::OnUpdateToggleShowPunctuation)
	EVT_TOOL(ID_SHOWING_ALL, CAdapt_ItView::OnToggleShowSourceText)
	EVT_UPDATE_UI(ID_SHOWING_ALL, CAdapt_ItView::OnUpdateToggleShowSourceText)
	EVT_TOOL(ID_BUTTON_NO_PUNCT_COPY, CAdapt_ItView::OnToggleEnablePunctuationCopy)
	EVT_UPDATE_UI(ID_BUTTON_NO_PUNCT_COPY, CAdapt_ItView::OnUpdateToggleEnablePunctuationCopy)

	EVT_TOOL(ID_BUTTON_TO_END, CAdapt_ItView::OnButtonToEnd)
	EVT_UPDATE_UI(ID_BUTTON_TO_END, CAdapt_ItView::OnUpdateButtonToEnd)
	EVT_TOOL(ID_BUTTON_TO_START, CAdapt_ItView::OnButtonToStart)
	EVT_UPDATE_UI(ID_BUTTON_TO_START, CAdapt_ItView::OnUpdateButtonToStart)
	EVT_TOOL(ID_BUTTON_STEP_DOWN, CAdapt_ItView::OnButtonStepDown)
	EVT_UPDATE_UI(ID_BUTTON_STEP_DOWN, CAdapt_ItView::OnUpdateButtonStepDown)
	EVT_TOOL(ID_BUTTON_STEP_UP, CAdapt_ItView::OnButtonStepUp)
	EVT_UPDATE_UI(ID_BUTTON_STEP_UP, CAdapt_ItView::OnUpdateButtonStepUp)
	EVT_TOOL(ID_BUTTON_GO_TO, CAdapt_ItView::OnButtonGoTo) // whm 25Oct2022 changed OnButtonBack() to OnButtonGoTo()
	EVT_UPDATE_UI(ID_BUTTON_GO_TO, CAdapt_ItView::OnUpdateButtonGoTo) // whm 25Oct2022 changed OnUpdateButtonBack() to OnUpdateButtonGoTo()
	EVT_TOOL(ID_BUTTON_MERGE, CAdapt_ItView::OnButtonMerge)
	EVT_UPDATE_UI(ID_BUTTON_MERGE, CAdapt_ItView::OnUpdateButtonMerge)
	EVT_TOOL(ID_BUTTON_RESTORE, CAdapt_ItView::OnButtonRestore)
	EVT_UPDATE_UI(ID_BUTTON_RESTORE, CAdapt_ItView::OnUpdateButtonRestore)
	EVT_TOOL(ID_BUTTON_CHOOSE_TRANSLATION, CAdapt_ItView::OnButtonChooseTranslation)
	EVT_UPDATE_UI(ID_BUTTON_CHOOSE_TRANSLATION, CAdapt_ItView::OnUpdateButtonChooseTranslation)
	EVT_TOOL(ID_BUTTON_EARLIER_TRANSLATION, CAdapt_ItView::OnButtonEarlierTranslation)
	EVT_UPDATE_UI(ID_BUTTON_EARLIER_TRANSLATION, CAdapt_ItView::OnUpdateButtonEarlierTranslation)
	EVT_TOOL(ID_BUTTON_GUESSER, CAdapt_ItView::OnButtonGuesserSettings)
	EVT_UPDATE_UI(ID_BUTTON_GUESSER, CAdapt_ItView::OnUpdateButtonGuesserSettings)
	// End of ToolBar event handlers

	// ComposeBar handlers
	EVT_BUTTON(IDC_BUTTON_CLEAR, CAdapt_ItView::OnClearContentsButton)
	EVT_BUTTON(IDC_BUTTON_SELECT_ALL, CAdapt_ItView::OnSelectAllButton)

	// Free Translation - 13 Composebar Button definitions moved to CFreeTrans

	// The following added for Vertical Editing, implemented by BEW
	EVT_UPDATE_UI(IDC_BUTTON_UNDO_LAST_COPY, CAdapt_ItView::OnUpdateButtonUndoLastCopy)
	EVT_BUTTON(IDC_BUTTON_UNDO_LAST_COPY, CAdapt_ItView::OnButtonUndoLastCopy)
	EVT_UPDATE_UI(IDC_BUTTON_PREV_STEP, CAdapt_ItView::OnUpdateButtonPrevStep)
	EVT_BUTTON(IDC_BUTTON_PREV_STEP, CAdapt_ItView::OnButtonPrevStep)
	EVT_UPDATE_UI(IDC_BUTTON_NEXT_STEP, CAdapt_ItView::OnUpdateButtonNextStep)
	EVT_BUTTON(IDC_BUTTON_NEXT_STEP, CAdapt_ItView::OnButtonNextStep)
	EVT_UPDATE_UI(ID_BUTTON_END_NOW, CAdapt_ItView::OnUpdateButtonEndNow)
	EVT_BUTTON(ID_BUTTON_END_NOW, CAdapt_ItView::OnButtonEndNow)
	EVT_UPDATE_UI(ID_BUTTON_CANCEL_ALL_STEPS, CAdapt_ItView::OnUpdateButtonCancelAllSteps)
	EVT_BUTTON(ID_BUTTON_CANCEL_ALL_STEPS, CAdapt_ItView::OnButtonCancelAllSteps)

	// Mouse events  --  moved to CAdapt_ItCanvas
END_EVENT_TABLE()

CAdapt_ItView::CAdapt_ItView()
{
	// whm All MFC's View variable initializations moved to the App

	// below unique to wxWidgets version
	canvas = (CAdapt_ItCanvas*) NULL;
	pCanvasFrame = (wxFrame*) NULL;
}

CAdapt_ItView::~CAdapt_ItView() // whm added
{
	// All cleanup is to be done in App's OnExit() function
}

CLayout* CAdapt_ItView::GetLayout()
{
	CAdapt_ItApp* pApp = &wxGetApp();
	return pApp->m_pLayout;
}

// Can be used for default print/preview
// as well as drawing on the screen
void CAdapt_ItView::OnDraw(wxDC *pDC)
{
    // the mechanism Bill has is that the canvas class handles the paint event, and the
    // handler (OnPaint()) ignores the contents of the passed in event but creates a
    // wxPaintDC with the call wxPaintDC paintDC(this); and then he explicitly calls
    // DoPrepareDC(paintDC) to get the origin scrolled to agree with the scrollbar and then
    // excutes the CAdapt_ItView's OnDraw(wxDC* pDC) by calling the canvas member
    // pView->OnDraw(&paintDC); - so the original wxDC passed to view's OnDraw() is ignored
    // and replaced with the scrolled one from the canvas before any drawing is done - I
    // don't see any problem with this mechanism (BEW note, 20Mar09)

	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);

	if (GetLayout() == NULL)
		return; // application not fully initialized yet
	if (GetLayout()->GetPileList()->GetCount() == 0)
		return; // still nothing to draw yet, so can't make any strips
	wxSize canvasViewSize;
	canvasViewSize = pApp->GetMainFrame()->GetCanvasClientSize(); // gets the width and height of canvas in pixels

	pDC->DestroyClippingRegion(); // ensure whole client area is drawable

    // BEW 5Oct11; Doing a Print Preview after PrintOptionsDlg did a print of physical
    // pages, failed here (pActivePile below was rubbish) due to m_pActivePile having been
    // clobbered. So recalc m_pActivePile before going on... (yes, this fixed the problem)
	pApp->m_pActivePile = pApp->m_pLayout->GetPile(pApp->m_nActiveSequNum);

#if defined(_DEBUG) && defined(_NEWDRAW) && !defined(__WXGTK__)
	wxLogDebug(_T("CAdapt_ItView::OnDraw(): Active pile's m_pOwningStrip: %p"), pApp->m_pActivePile->GetStrip());
#endif

    // BEW 14Mar11, Gerry Andersen reports that occasionally, for an unknown set of user
    // actions, the display is updated in such a way that the right end of the phrase box
    // overlaps the start of text in the next pile's adaptation. Noone has ever been able
    // to reproduce this error on demand, in the last 6 years or so. The specific
    // screenshot Gerry provided showed a problem I've not ever seen before, the start of
    // the phrase box was overlapping the end of a merger which immediately preceed it (see
    // email of 12 Jan 2011).So here I'm attempting a kludge which will hopefully prevent
    // this, and the more typical occasional problem of the box overlapping what follows,
    // from happening. The errors are different, & cause isn't clear for either, but it's
    // clear what happens. The typical error is that the gap left in the layout for the box
    // isn't wide enough to accomodate the box size. So here I'll test for a box size wider
    // than the gap left for the box at the active pile, and if so, call whatever is
    // required to force a wider gap - probably a RecalcLayout() call initiated from a
    // FixBox() call in which the last param is 1 (ie. base new box size on width of text
    // in it). Hopefully this test will never yield TRUE, but if it does, the code block
    // should prevent the overlap Gerry and others have noted as happening occasionally.
    // The error Gerry reported, is caused by the active pile's left offset being smaller
    // than the previous pile's left offset plus its m_nWidth value. We can test for the
    // latter too, and when that happens, force the recalc before the draw.

	CPile* pActivePile = pApp->m_pActivePile;

	if (pActivePile != NULL && pApp->m_nActiveSequNum != -1)
	{
		// whm 24Jan2023 added back the SetPhraseBoxGapWidth() call, which assigns the 
		// returned value of CalcPhraseBoxGapWidth() to CPile::m_nWidth.
		// BEW reported this date that he was unable to select the source phrase at the active
		// location and that the problem was due to the CPile::m_nWidth member still had a -1
		// uninitializaion value.
		// However, testing with the call commented out indicates that the SetPhraseBoxGapWidth() 
		// call is not really needed here to solve the issue of not being able to select the source
		// phrase at the active location.
		//pActivePile->SetPhraseBoxGapWidth(); // Assigns value of CalcPhraseBoxGapWidth() to m_nWidth
	}

	// draw the layout
	GetLayout()->Draw(pDC);

    // BEW added 7Jul05 for drawing the free translation text substrings in the spaces
    // created under each of the strips - but only when we are not currently printing
    // (drawing is not done outside the client area for the view)
	// BEW 1Oct11, added a new variant for handling printing of free translations; it has
	// to confine its drawing to the strips delineated by the PageOffset struct pointed at
	// by the app member m_nCurPage - which stores indices for first and last strip to be drawn
	// KLB 9/2011 added check for gbCheckInclFreeTransText so free translations would
	// print on print preview

	if (pApp->m_bFreeTranslationMode && !pApp->m_bIsPrinting)
	{
		pApp->GetFreeTrans()->DrawFreeTranslations(pDC, GetLayout());
	}
	else if (pApp->m_bIsPrinting && gbCheckInclFreeTransText)
	{
#if !defined(__WXGTK__)
        // for Windows and Mac, call it here; but for __WXGTK__ build, do this instead in
        // the AIPrintout's OnPrintPage() function
		pApp->GetFreeTrans()->DrawFreeTranslationsForPrinting(pDC, GetLayout());
#endif
	}
}

// UpdateAppearance() is simply intended to cause the view to redraw itself, if something that affects the visual
// appearance might have changed, e.g. the read-only status.  It's proved surprisingly tricky to get this to
// actually update everything completely!  In particular, on the Mac, we need the 1-pixel scroll, to really get
// rid of the pink!
// We also need the PlaceBox() so the box actually gets placed.

void CAdapt_ItView::UpdateAppearance (void)
{
	CLayout*	ptrLayout;
    //wxWindow*   pMyWind = GetFrame(); // removed 16Sep13, it's not needed below
    CAdapt_ItApp* pApp = &wxGetApp();

    ptrLayout = GetLayout();
	if (ptrLayout != NULL)
	{
		ptrLayout->Redraw();	// Not actually needed on Mac, but doesn't hurt
		ptrLayout->PlaceBox();	// Sets the parameters for the updated placement of the phrase box if changing
								// direction, also gets rid of all the pink if making doc editable!
    }
    else
        wxASSERT_MSG(FALSE,_T("WARNING: Redraw() called with GetLayout() == NULL"));

//    pMyWind->Refresh();         // mark whole window area dirty
//    pMyWind->Update();          // force redraw
//    pMyWind->ScrollWindow (0, 1);
    
    // for some unaccountable reason we need this on the Mac at least, 
    // to really get rid of all the pink!!
    pApp->GetMainFrame()->SendSizeEvent();
}

// return the CPile* at the passed in index, or NULL if the index is out of bounds;
// the pile list is at CLayout::m_pileList
// BEW 26Mar10, no changes needed for support of doc version 5
CPile* CAdapt_ItView::GetPile(const int nSequNum)
{
	// refactored 10Mar09, for new view layout design
	CLayout* pLayout = GetLayout();
	wxASSERT(pLayout != NULL);
	//PileList* pPiles = pLayout->GetPileList();
#if defined(_DEBUG) && defined(GUIFIX)
	{
		int count = pLayout->GetPileList()->GetCount();
		if (count == 0)
		{
			CAdapt_ItApp* pApp = &wxGetApp();
			wxLogDebug(_T("   %s::%s() line %d: Pile count is ZERO,  nSequNum = %d, m_bDocReopeningInProgress = %d  in RecalcLayout"),
			__FILE__, __FUNCTION__, __LINE__, nSequNum , (int)pApp->m_bDocReopeningInProgress);
		}
	}
#endif
	PileList* pPileList = pLayout->GetPileList();
	int nCount = pPileList->GetCount();
	//int nCount = pLayout->GetPileList()->GetCount();
	if (nSequNum < 0 || nSequNum >= nCount)
	{
		// bounds error, so return NULL
		return (CPile*)NULL;
	}

	//PileList::Node* pos_pPileList = pPiles->Item(nSequNum); // relies on parallelism of m_pSourcePhrases
												  // and m_pileList lists
	//PileList::Node* pos_pPileList = pLayout->GetPileList()->Item(nSequNum); 
	PileList::Node* pos_pPileList = pPileList->Item(nSequNum);
	wxASSERT(pos_pPileList != NULL);
	CPile* pPile = pos_pPileList->GetData();
	return pPile;
}

// BEW 26Mar10, no changes needed for support of doc version 5
CCell* CAdapt_ItView::GetNextCell(CCell *pCell, const int cellIndex)
{
    // returns the next cell at the level specified by cellIndex (note: switching levels is
    // allowed because we only care about the level of the cell in the next pile), or
    // returns NULL if there is no next pile (and hence no next cell)
	// refactored 17Mar09
	CPile* pPile = pCell->GetPile();
	PileList* pPiles = GetLayout()->GetPileList();
	int index = pPiles->IndexOf(pPile);
	index++; // index of next CPile instance
	if (index >= (int)pPiles->GetCount())
	{
		return NULL; // bounds error - passed end of document
	}
	else
	{
		// not past end of document
		PileList::Node* pos_pPile = pPiles->Item(index);
		pPile = pos_pPile->GetData();
		wxASSERT(pPile != NULL);
	}
	return pPile->GetCell(cellIndex);
}

// returns a pointer to the next pile, or NULL if there is none
// BEW 26Mar10, no changes needed for support of doc version 5
// BEW 5Jun24 refactored a bit to get rid of the use of Node* and the overt pile list,
// Document() has a call that works instead, to get CSourcePhrase* and we can get sequNum from that
CPile* CAdapt_ItView::GetNextPile(CPile* pPile)
{
	// refactored 17Mar09; BEW modified 25Oct09 as pPile can be NULL
	// passed in, in Review mode, so must test for it early!
	if (pPile == NULL)
		return (CPile*)NULL;
	CPile* pNextPile = NULL;
	PileList* pPiles = GetLayout()->GetPileList();

	// BEW  try 5Jun24
	CAdapt_ItApp* pApp = &wxGetApp();
	CAdapt_ItDoc* pDoc = pApp->GetDocument(); wxUnusedVar(pDoc);
	CSourcePhrase* pSP = pPile->GetSrcPhrase();
	int index = pSP->m_nSequNumber;
	//int index = pPiles->IndexOf(pPile);

	index++; // index of next CPile instance
	if (index >= (int)pPiles->GetCount())
	{
		return (CPile*)NULL; // bounds error - passed end of document
	}
	else
	{
		// not past end of document
		//PileList::Node* pos_pPile = pPiles->Item(index);
		//pNextPile = pos_pPile->GetData();
		
		// BEW try 5Jun24
		pNextPile = this->GetPile(index);
		wxASSERT(pNextPile != NULL);
	}
	return pNextPile;
}
// returns a pointer to the next pile, or NULL if there is none
// BEW 26Mar10, no changes needed for support of doc version 5
CPile* CAdapt_ItView::GetNextPile_forFreeTrans()
{
	// refactored 17Mar09; BEW modified 25Oct09 as pPile can be NULL
	// passed in, in Review mode, so must test for it early!
	CPile* pNextPile = NULL;
	CAdapt_ItApp* pApp = &wxGetApp();
	int iStart = 0;
//#ifdef _DEBUG
	if (pApp->m_bStartingFreeTransSetup)
	{
		// Only use the active sequNum to kick off the building of a free trans section
		// thereafter, use pApp->m_nLastSN_forFreeTrans
		pApp->m_nSN_forFreeTrans = pApp->m_nActiveSequNum;
		pApp->m_bStartingFreeTransSetup = FALSE;
		pApp->m_nLastSN_forFreeTrans = -1; // section extent is not yet known
	}
	else
	{
		pApp->m_nSN_forFreeTrans = pApp->m_nLastSN_forFreeTrans;
	}
	
	wxLogDebug(_T("GetNextPile_forFreeTrans() in View, check first sequNum, line= %d, sequNum= %d"),
		__LINE__, pApp->m_nSN_forFreeTrans);
	CSourcePhrase* pSP = NULL;

	iStart = pApp->m_nSN_forFreeTrans;
	PileList* pilesPtr = GetLayout()->GetPileList();

	int anSN = pApp->m_nSN_forFreeTrans; // starter, and use in iterations
	CAdapt_ItDoc* pDoc = pApp->GetDocument();
	CPile* aPilePtr = pDoc->GetPile(anSN);
	pSP = aPilePtr->GetSrcPhrase();
	//wxLogDebug(_T("GetNextPile() in View, At Active Loc?, line= %d, src= %s , tgt= %s , sequNum= %d"),
	//	__LINE__, pSP->m_srcPhrase, pSP->m_targetStr, pSP->m_nSequNumber);

	// How long is the current section of free translation - want number of piles, m_pFreeTrans has that info
	CFreeTrans* pFreeTrans = pApp->GetFreeTrans();
	int nFreeTransLen = pFreeTrans->m_pCurFreeTransSectionPileArray->GetCount();

	// int iStart = pilesPtr->IndexOf(pPile); RHSide fails

	// Start at pile after last one of the current section
	iStart += nFreeTransLen;
#ifdef _DEBUG
	int iEnd = iStart + nFreeTransLen;
	int ndex = 0;
	for (ndex = iStart; ndex <= iEnd; ndex++)
	{
		aPilePtr = pDoc->GetPile(ndex);
		pSP = aPilePtr->GetSrcPhrase();

		// BEW 6Jun24 these two lines return an item which is garbage, and dereferecing gives garbage or crash,
		// so bypass. Doc's GetPile() from a sequNum works correctly, so rebuild using that in code above this comment
		//PileList::Node* mypos_pPile = pilesPtr->Item(ndex);
		//pSP = (CSourcePhrase*)mypos_pPile->GetData();
		wxLogDebug(_T("GetNextPile() in View, TEST 1 or more, line= %d, src= %s , tgt= %s , ndex sequNum= %d"),
						__LINE__, pSP->m_srcPhrase, pSP->m_targetStr, pSP->m_nSequNumber);
	}
#endif

	// BEW removed 5Jun24
	//PileList* pPiles = GetLayout()->GetPileList();
	//int index = pPiles->IndexOf(pPile);

	int index = pApp->m_nSN_forFreeTrans;
	pNextPile = pDoc->GetPile(index);

	//index++; // index of next CPile instance
	if (index >= (int)pilesPtr->GetCount())
	{
		return (CPile*)NULL; // bounds error - passed end of document
	}
	/* BEW removed 5Jun24
	else
	{
		// not past end of document
		PileList::Node* pos_pPile = pPiles->Item(index);
		pNextPile = pos_pPile->GetData();
		wxASSERT(pPile != NULL);
	}
	*/
	pApp->m_nLastSN_forFreeTrans = pApp->m_nSN_forFreeTrans;
	//pApp->m_nSN_forFreeTrans++; // next entry needs to be next pSrcPhrase

	return pNextPile;
}

// BEW 26Mar10, no changes needed for support of doc version 5
CPile* CAdapt_ItView::GetPrevPile(CPile *pPile)
// returns a pointer to the previous pile, or NULL if there is none
{
	// refactored 30Mar09
	CPile* pPrevPile = NULL;
	PileList* pPiles = GetLayout()->GetPileList();
	int index = pPiles->IndexOf(pPile);
	index--; // index of previous CPile instance
	if (index < 0)
	{
		return (CPile*)NULL; // bounds error - passed beginning of document
	}
	else
	{
		// not past beginning of document
		PileList::Node* pos_pPile = pPiles->Item(index);
		pPrevPile = pos_pPile->GetData();
		wxASSERT(pPile != NULL);
	}
	return pPrevPile;
}

// MFC docs say that OnInitialUpdate() is "Called by the framework after the view
// is first attached to the document, but before the view is initially displayed. The
// default implementation of this function calls the OnUpdate member function with no
// hint information (that is, using the default values of 0 for the IHint parameter
// and NULL for the pHint parameter)."
// Design Note: Test of all MFC routines that could potentially call OnInitialUpdate()
// in the App show that OnInitialUpdate() is actually only called at the following
// times in the MFC code:
// 1. At end of OnInit() when app is initially run before the main frame appears (OnInit
//    explicitly calls pView->OnInitialUpdate().
// 2. When File | New menu selection is made (
// 3. When Loading a file from the MRU list.
// 4. When the main window is split (observed Jan07)
// OnInitialUpdate() should be called for only two main scenarios
// (1) for File | New, and (2) when loading a file from the MRU list. It
// doesn't really need to be called in OnInit() because the CreateDocument()
// call there triggers a File | New scenario which includes the OnInitialUpdate()
// call. See notes in App's OnInit().
// TODO: Splitting of the main window in the wxWidgets version is not yet implemented, but
// if/when it is implemented it should be tested to see if OnInitialUpdate should be
// called for that situation too.
// BEW 26Mar10, no changes needed for support of doc version 5
void CAdapt_ItView::OnInitialUpdate()
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxCommandEvent dummyevent; // for use in EVT governed function calls

    // get the checkbox pointer for glossing, and hide it when app is first launched (a
    // command on the Advanced menu can be used for showing it later on); but since we can
    // get here from closing a doc and then creating or opening another, the gbIsGlossing
    // flag might be TRUE - in which case we will leave it unchanged and not hide the
    // checkbox, because presumably once the user is doing glossing, if he works on another
    // document he will most likely be glossing that too (or so we will assume)
	//
	// NOTE: wxWidgets version - this is taken care of in the App's OnInit()
	//
	CMainFrame *pFrame = pApp->GetMainFrame();
	wxASSERT(pFrame != NULL);
	wxPanel* pControlBar = pFrame->m_pControlBar;
	wxASSERT(pControlBar != NULL);

	// update the copy shown on mode bar (it's read only there)
	wxTextCtrl* pDelayBox = (wxTextCtrl*)pControlBar->FindWindowById(IDC_EDIT_DELAY);
	// whm 12Oct10 modified below for user workflow compatibility
	if (pDelayBox != NULL)
	{
		wxString s;
		s.Empty();
		s << pApp->m_nCurDelay; //s = buf;
		pDelayBox->ChangeValue(s);
		pControlBar->Refresh();
	}

	// add the extra menu if it is the Unicode version
#ifdef _RTL_FLAGS
	// Note: The wx version starts with the Layout menu and removes it in the App's OnInit()

	// call AdjustAlignmentMenu to ensure that the Layout menu items text is set correctly
	AdjustAlignmentMenu(gbRTLLayout, gbLTRLayout);
#endif // for _RTL_FLAGS

	pApp->m_selection.Clear();
	pApp->m_pAnchor = (CCell*)NULL;
	pApp->m_selectionLine = -1;

	// need to ensure the initial targetPhrase box's text is not lost across
	// the next calls
	wxString saveText = pApp->m_targetPhrase;

    // WX Note: The App's color member are now set directly without short forms
    // specialTextColor etc.

	if (!gbShowTargetOnly)
	{
		gnSaveLeading = pApp->m_curLeading;
		gbShowTargetOnly = TRUE;
		OnToggleShowSourceText(dummyevent); // normal view, showing source & target lines
	}

	// whm Note 22Aug11. I think it is better to call the
	// MakeMenuInitializationsAndPlatformAdjustments() after setting the App's
	// flags to the desired state, than setting them to the opposite value and
	// calling their associated On...() handlers with a dummy wxCommandEvent,
	// designed to reverse the flag to the opposite state again. Nevertheless,
	// I'm leaving the original coding here in OnInitialUpdate()

    // BEW removed 8Aug09, there is no good reason to store a "punctuation hidden"
    // value because it we do that, the user could get confused if next time his
    // document doesn't show and punctuation and he didn't realize he shut down
    // with this setting toggled from the default, so now we'll ignore the config
    // file value, and always launch the app with this m_bHidePunctuation flag set
    // FALSE -- OnInit() initializes it to FALSE, config file is now ignored
	//if (!pApp->m_bHidePunctuation)
	//{
	//	pApp->m_bHidePunctuation = TRUE; // the function call will reset it to FALSE
	//	OnButtonFromHidingToShowingPunct(dummyevent); // make punctuation visible in lines 1 & 2
	//}

	// BEW note: The OnToggleEnablePunctuationCopy() handler functions as the toolbar toggle 
	// button that toggles between "Copy Punctuation" and "No Copy Punctuation". It sets 
	// m_bCopySourcePunctuation to TRUE if m_bCopySourcePunctuation is FALSE when 
	// OnToggleEnablePunctuationCopy() is called. And FALSE if TRUE when called.
	if (pApp->m_bCopySourcePunctuation)
	{
		pApp->m_bCopySourcePunctuation = FALSE; // the function call will reset it to TRUE
		if (!pApp->m_bCopySourcePunctuation)
		{
			OnToggleEnablePunctuationCopy(dummyevent);
		}
	}

	if (pApp->m_bMarkerWrapsStrip)
	{
		// make sure the menu item is shown with checkmark
		pApp->m_bMarkerWrapsStrip = FALSE; // the function call will set it to TRUE
		OnMarkerWrapsStrip(dummyevent);
	}
	if (pApp->m_bCopySource)
	{
		// make sure the Copy Source menu item is shown with checkmark
		pApp->m_bCopySource = FALSE;
		OnCopySource(dummyevent); // toggle it ON, and set the checkmark
	}
    // whm 2Aug2018 added
    if (pApp->m_bSelectCopiedSource)
    {
        // make sure the Select Copied Source menu item is shown without checkmark.
        // The value of m_bSelectCopiedSource will be set from the project config file's
        // stored value possibly overriding this initial setting.
        pApp->m_bSelectCopiedSource = TRUE;
        OnSelectCopiedSource(dummyevent);
    }

    // wx version: the Save As XML menu item is always shown with checkmark and cannot be
    // changed

	if (pApp->m_bTransliterationMode)
	{
		// make sure the Use Transliteration Mode menu item is shown with checkmark
		pApp->m_bTransliterationMode = FALSE;
		OnAdvancedUseTransliterationMode(dummyevent); // toggle it ON, and set the checkmark
	}
	else
	{
		// make sure the Use Transliteration Mode menu item is shown without checkmark
		pApp->m_bTransliterationMode = TRUE;
		OnAdvancedUseTransliterationMode(dummyevent); // toggle it OFF, and clear the checkmark
	}

	if (gbIgnoreScriptureReference_Receive)
	{
		// scripture reference receiving starts out turned off, so get
		// the command unticked (meaning 'it is disabled', that is, turned off)
		gbIgnoreScriptureReference_Receive = FALSE;
		wxCommandEvent uevent;
		GetDocument()->OnAdvancedReceiveSynchronizedScrollingMessages(uevent); //toggle flag to TRUE ie. OFF
	}
	if (pApp->m_bIgnoreScriptureReference_Send)
	{
		// scripture reference sending starts out turned off, so get
		// the command unticked (meaning 'it is disabled', that is, turned off)
        pApp->m_bIgnoreScriptureReference_Send = FALSE;
		wxCommandEvent uevent;
		GetDocument()->OnAdvancedSendSynchronizedScrollingMessages(uevent); //toggle flag to TRUE ie. OFF
	}

	// turn the Drafting radio button ON, on the toolbar
	//
	// BEW modified 25Oct09, so that if m_bForce_Review_Mode is TRUE, then a call to
	// OnNewDocument() (which calls OnInitialUpdate()) does not change m_bDrafting
	// back to a TRUE setting, thereby ruining the intended effect of the former flag
	// - (m_bForce_Review_Mode, once set TRUE in OnInit() should remain TRUE, and
	// m_bDrafting should remain FALSE, for the life of that session)
	if (!pApp->m_bForce_Review_Mode)
	{
		OnRadioDrafting(dummyevent);
	}

	// set the pointer to the save list
	pApp->m_pSaveList = &pApp->m_saveList;

    // At this point the MFC version copies printing variables from those it had on the App
    // to those it maintined here in the View. Since the wx version maintains its printing
    // variable on the App, and they get updated when the config files are read from the
    // App's OnInit(), it is not necessary to

	pApp->SetPageOrientation(pApp->m_bIsPortraitOrientation);

	wxASSERT(pFrame);
	pFrame->SetSize(pApp->m_ptViewTopLeft.x, pApp->m_ptViewTopLeft.y, pApp->m_szView.x,
					pApp->m_szView.y, wxSIZE_AUTO);

	// Our wxWidgets' wxScrolledWindow is handled by the CAdapt_ItCanvas class.
	// From wxScrolledWindow documentation and samples for info on setting
	// up a sizer to help manage scrolling. Methods of wxScrolledWindow particular
	// interest include:
	// void GetViewStart(int* x, int* y) const. Gets the position at which the
	//		visible portion of the window starts. x receives the first visible x
	//		position in scroll units, y receives the first visible y position in
	//		scroll units. If either of the scrollbars is not at the home position
	//		x and/or y will be greater than zero. Combined with wxWindow::GetClientSize
	//		the application can use this function to efficiently redraw only the
	//		visible portion of the window. The positions are in logical scroll units
	//		not pixels, so to convert to pixels you multiply by the number of
	//		pixels per scroll increment.
	// void GetVirtualSize(int* x, int* y) const. Gets the size in device units of
	//		the scrollable window area (as opposed to the client size, which is the
	//		area of the window currently visible). Parameter x receives the length
	//		of the scrollable window, in pixels. Parameter y receives the height of
	//		the scrollable window, in pixels. Use wxDC::DeviceToLogicalX and
	//		wxDC::DeviceToLogicalY to translate these units to logical units.
	// void Scroll(int x, int y). Scrolls a window so the view start is at the
	//		given point. Parameter x is the x position to scroll to, in scroll units.
	//		Parameter y is the y position to scroll to, in scroll units. The
	//		positions are in scroll units, not pixels, so to convert to pixels
	//		you have to multiply by the number of pixels per scroll increment.
	//		If either parameter is -1, that position will be ignored (no change
	//		in that direction).
	// void SetScrollbars(int pixelsPerUnitX, int pixelsPerUnitY, int noUnitsX,
	//		int noUnitsY, int xPos = 0, int yPos = 0, bool noRefresh = FALSE)
	//		Sets up vertical and/or horizontal scrollbars. Parameters are:
	//		pixelsPerUnitX - pixels per scroll unit in the horizontal direction.
	//		pixelsPerUnitY - pixels per scroll unit in the vertical direction.
	//		noUnitsX - number of units in the horizontal direction.
	//		noUnitsY - number of units in the vertical direction.
	//		xPos - position to initialize the scrollbars in the horizontal
	//			direction, in scroll units.
	//		yPos - Position to initialize the scrollbars in the vertical
	//			direction, in scroll units.
	//		noRefresh - will not refresh window if TRUE.
	//		Remarks: The first pair of parameters give the number of pixels
	//		per 'scroll step', i.e. amount moved when the up or down scroll
	//		arrows are pressed. The second pair gives the length of scrollbar
	//		in scroll steps, which sets the size of the virtual window.
	//		xPos and yPos optionally specify a position to scroll to immediately.
	//		For example, the following gives a window horizontal and vertical
	//		scrollbars with 20 pixels per scroll step, and a size of 50 steps
	//		(1000 pixels) in each direction: window->SetScrollbars(20, 20, 50, 50);
	//		wxScrolledWindow manages the page size itself, using the current
	//		client window size as the page size. Note that for more sophisticated
	//		scrolling applications, for example where scroll steps may be variable
	//		according to the position in the document, it will be necessary to
	//		derive a new class from wxWindow, overriding OnSize and adjusting
	//		the scrollbars appropriately. See also wxWindow::SetVirtualSize
	// void SetScrollRate(int xstep, int ystep).
	//		Set the horizontal and vertical scrolling increment only. See the
	//		pixelsPerUnit parameter in SetScrollbars.
	// wxWindow also has void SetVirtualSize(const wxSize& size), which sets the
	//		virtual size of the window in pixels (i.e., wxMM_TEXT).
	//      SetVirtualSize() is used within the wx app in the following functions:
	//      OnOpenDocument(), OnInitialUpdate() and RecalcLayout().

	//
	// wxWidgets' mapping modes can be one of the following:
	// wxMM_TWIPS		Each lodical unit is 1/20 of a point, or 1/1440 of an inch (same as MFC's)
	// wxMM_POINTS		Each lodical unit is a point, or 1/72 of an inch (= MM_TWIPS*20)
	// wxMM_METRIC		Each lodical unit is 1 mm (= 10*MFC's MM_LOMETRIC below)
	// wxMM_LOMETRIC	Each lodical unit is 1/10 of a mm (same as MFC's MM_LOMETRIC below)
	// wxMM_TEXT		Each lodical unit is 1 pixel (same as MFC's)

	// MFC Docs say of SetScrollSizes: "Call SetScrollSizes when the view is about
	// to be updated. First parameter is the mapping mode to set for this view,
	// where: First paramater can be:
	//		MM_TEXT, one Logical Unit = 1 pizel and positive y-axis extends downward.
	//		MM_HIMETRIC, one Logical Unit = 0.01mm, y-axis extends upward
	//		MM_TWIPS, one Logical Unit = 1/1440 inch, y-axis extends upward
	//		MM_HIENGLISH, one Logical Unit = 0.001 inch, y-axis extends upward
	//		MM_LOWMETRIC, one Logical Unit = 0.1 mm, y-axis extends upward
	//		MM_LOENGLISH, one Logical Unit = 0.01 inch, y-axis extends upward
	// Second parameter is the total size of the scroll view. The cx member contains
	// the horizontal extent. The cy member contains the vertical extent, and sizes
	// are in logical units. Both cx and cy must be >= 0. Call it in your override
	// of the OnUpdate member function to adjust scrolling characteristics when,
	// for example, the document is initially displayed or when it changes size.
	// You will typically obtain size information from the view's associated
	// document by calling a document member function, perhaps called GetMyDocSize,
	// that you supply with your derived document class.

	pApp->GetMainFrame()->canvas->SetVirtualSize(pApp->m_docSize);

	// refactored version:
	CLayout* pLayout = pApp->m_pLayout;
	pLayout->InitializeCLayout(); // sets the app, doc, view, canvas & frame pointers,
								  // and clears m_stripArray
	pLayout->SetLayoutParameters(); // calls InitializeCLayout() and UpdateTextHeights()
									// and other setters
	pApp->m_targetPhrase = saveText;
    // whm 13Jul2018 removed SetSelection() 'select all' code from this location at
    // end of OnInitialUpdate(). OnInitialUpdate() gets called from OnInit() very 
    // early in the program startup process BEFORE the start working wizard runs 
    // and certainly before a document has been opened.
}

// BEW 26Mar10, no changes needed for support of doc version 5
bool CAdapt_ItView::OnCreate(wxDocument* doc, long flags) // a virtual method of wxView
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	doc = doc; // avoid "unreferenced formal parameter" warning
	flags = flags; // avoid "unreferenced formal parameter" warning
	pCanvasFrame = pApp->GetMainFrame();
	canvas = pApp->GetMainFrame()->canvas;
	canvas->pView = this;	// make the view pointer owned by MainFrame's canvas
							// point to the current view
    pCanvasFrame->SetTitle(_T("Adapt It"));
	SetFrame(pCanvasFrame);

#ifdef __X__
    // X seems to require a forced resize
    int x, y;
    pCanvasFrame->GetSize(&x, &y);
    pCanvasFrame->SetSize(-1, -1, x, y);
#endif

	// Create the target box using custom constructor.
	// WX Note: Our TargetBox, its dropdown button and its dropdown list are
    // now children of the view's canvas (which itself is derived from wxScrolledWindow. 
    // As children of the canvas window, m_pTargetBox and its button and dropdown list
    // will be automatically destroyed when pView->canvas is destroyed during doc/view's 
    // normal cleanup. That is, when our View is destroyed, all child windows (including 
    // our target box) are automatically destroyed too. Therefore, the target box must 
    // not be deleted again in the App's OnExit() method, when the App terminates.

    // whm modified 11July2018 to support quick selection of a translation equivalent.
    // The CPhraseBox stored on App's m_pTargetBox is created in the App's 
    // DoCreatePhraseBox() function. See comments there for more details.
    // The ID of the wxTextCtrl within the PhraseBox is set to a value of 22030 at the
    // beginning of the Adapt_It.cpp source file.

    // Here is the legacy Phrasebox creation code:
    //pApp->m_pTargetBox = new CPhraseBox(pApp->GetMainFrame()->canvas, -1, _T(""),
    //    wxDefaultPosition, wxDefaultSize,
    //    wxSIMPLE_BORDER | wxWANTS_CHARS);

    pApp->DoCreatePhraseBox();

	pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(_T(""));
	// hide and disable the target box until input is expected
    pApp->m_pTargetBox->HidePhraseBox(); // hides all three parts of the new phrasebox

	pApp->m_pTargetBox->Enable(FALSE); // whm 12July2018 Note: It is re-enabled in ResizeBox()

	// Old note: Since wxView's OnUpdate() doesn't seem to be automatically
	// called at the point that the View is created we'll try calling
	// it here in the View's OnCreate() method just before the View's
	// pCanvasFrame is shown.
	// New note: wxView does have a virtual OnUpdate() method. So rather
	// than calling our own OnInitialUpdate() here, I tired to override
	// wxView's OnUpdate() to call OnInitialUpdate only once when our view
	// is first created, but that had problems.
	OnUpdate(NULL,NULL);
    Activate(TRUE);

	// see docview sample view.cpp for code on how to set up the edit menu
	// Undo and Redo items using doc->GetCommandProcessor() here

	if (pApp->m_bControlIsWithinOnInit)
	{
		return TRUE; // exit because in OnInit() no project etc is as yet defined
	}
	// whm 28Aug11 Note: I find any scenario within the version 6.x.x of Adapt It
	// that the remainder of this function ever executes. The only time I've found
	// that it is called is when the call in the App's OnInit() is made as follows:
	//   wxCommandEvent event = wxID_NEW;
	//   OnFileNew(event);
	// which I believe was a hack to get the doc-view black box to work as
	// it did in MFC to ensure that a document class and a view class pointer
	// got created early on in the application startup process, and getting the
	// canvas set into the main frame. At any rate, I am implementing the
	// CreateAndLoadKBs() function to take the place of the KB creation and
	// loading code that was added to OnCreate() (by Bruce I think) at some time
	// subsequently. I doubt if execution control ever gets beyond the
	// if (pApp-m_bControlIsWithinOnInit) test above, but if it ever does, and
	// we still need to create and load KBs from here, it will be ready.


	// Note: Because of doc/view framework differences between MFC and WX,
	// a user File | New selection in WX calls CreateDocument, which
	// after calling OnSaveModified, calls OnCloseDocument which in
	// turn calls EraseKB on the adapting and glossing KBs. Hence, we
	// need to reinitialize our KBs here, since immediately after this
	// OnCreate() method finishes, OnNewDocument() will be called and
	// the KB structures need to be reinitialized before OnNewDocument
	// can succeed.

    // we have the desired directory structures. Now we need to get a KB
    // initialized and stored in the languages-specific folder. Ditto for the glossing
    // KB (version 2)

	// BEW changed 1Aug09, because the code was using the old binary filenames *.KB
	// etc, and so creating a new adaptation document using the File / New command was
	// not finding the KB on disk, creating a new empty one and saving it, thereby
	// clobbering the disk's good KB file. So I removed the wrong code and instead
	// called SetupKBPaths() which, for the wx version, sets up the correct normal and
	// alternate path names, file names, and backup paths and filenames.
	pApp->SetupKBPathsEtc();

	// whm revised 28Aug11 to use the CreateAndLoadKBs() function below instead
	// of the previous code (see commented out code below) that created and loaded
	// the KBs.
	// The CreateAndLoadKBs() is called from here as well as from the the App's
	// SetupDirectories(), the CollabUtilities' HookUpToExistingAIProject() and
	// the ProjectPage::OnWizardPageChanging().
	//
	// open the two knowledge bases and load their contents;
	if (!pApp->CreateAndLoadKBs())
	{
		// deal with failures here
		return TRUE; // whm Note: Or should this be FALSE? Probably doesn't matter
					// since this code doesn't seem to ever be executed other than
					// when m_bControlIsWithinOnInit is TRUE (see above)
	}

	// BEW added 13Nov09: give the local user ownership for writing, or deny it if
	// somehow someone else has gotten ownership of the project folder already
	if (!pApp->m_curProjectPath.IsEmpty())
	{
		// whm added 7Mar12 code for fictitious read only access. If the m_bFictitiousReadOnlyAccess
		// flag is set, ForceFictitiousReadOnlyProtection() should be called before the call to
		// SetReadOnlyProtection().
		if (pApp->m_bFictitiousReadOnlyAccess)
		{
			pApp->m_pROP->ForceFictitiousReadOnlyProtection(pApp->m_curProjectPath);
		}

		// Attempt to set it only if not already set...
		//if (!pApp->m_bReadOnlyAccess)
		pApp->m_bReadOnlyAccess = pApp->m_pROP->SetReadOnlyProtection(pApp->m_curProjectPath);
	}

	/* // whm Note: I'm leaving this code here in case Bruce wants to compare it with
	   // what's in the CreateAndLoadKBs() function call above. I don't think the
	   // issue he raised in his 24Aug10 note would apply any more.

	if (::wxFileExists(pApp->m_curKBPath)) //if (cFile.GetStatus(m_curKBPath,status))
	{
		// there is an existing .KB file, so we need to create a CKB instance in
		// memory, open the .KB file on disk, and fill the memory instance's members

		// BEW 23Aug10, replaced the wxASSERT() here because it is possible to get to
		// here with a non-NULL m_pKB and m_pGlossingKB, in which case the asserts
		// trip, and if omitted we'd leak the KB and GlossingKB memory when they are
		// created here anew on the heap. So, we test for non-null pointers, and if
		// true, then we make sure the in-memory ones are deleted before continuing.
		// The sequence of operations which exposed this bug were:
        // 1. User navigation protection was on (5 loadable files in __SOURCE_INPUTS, four
        // of which had had docs made from them (though that was irrelevant) and one
        // was there for listed. When the NavProtectNewDoc() handler's dialog shows, I
        // clicked Cancel.
		// 2. File / New..., double-clicked the loadable source text filename.
		// 3. When "Type a name..." dialog shows, I Cancelled.
        // 4. File / New... again and got the crash here when the wxASSERT() was
        // tripped. (Very possibly the same error would happen with the legacy Open
        // File... dialog, if the same sequence of Cancel, New, double-click, Cancel,
        // New was done. But I didn't test, as the fix here would take care of that as
        // well.)
		//
		// BEW 24Aug10, the above turns out to be a problem in the wxWidgets black box
		// if the Cancel option is taken within OnNewDocument() - whether nav
		// protection is on or not; our event handlers don't get called. No idea why,
		// but the EraseKB() here will prevent the crash. It's not a full solution
		// though, because the toolbar icon buttons for New and particularly for Open
		// will then still not work right, nor will File / New... or File / Open...;
		// so I need to try fix the Cancel problem at its source.
		// Later on 24Aug10 - the problem was caused by returning FALSE from a
		// OnNewDocument() - this clobbers things (I don't know what) which the
		// doc/view support relies on; the solution was to return TRUE from
		// OnNewDocument() whether cancelling or not. That fixed everything, and the
		// New and Open icon buttons on the toolbar now work right in all circumstances.
		//wxASSERT(pApp->m_pKB == NULL);
		if (pApp->m_pKB != NULL)
		{
			// protect from a crash -- strictly speaking this block should never now
			// be entered due to the 24Aug10 fix discussed above, but it can be left
			// here as a safety measure
			pApp->GetDocument()->EraseKB(pApp->m_pKB);
		}

		pApp->m_pKB = new CKB(FALSE);
		wxASSERT(pApp->m_pKB != NULL);

		// whm Note: LoadKB() has its own wxProgressDialog
		bool bOK = pApp->LoadKB(TRUE); // show the progress dialog
		if (bOK)
		{
			pApp->m_bKBReady = TRUE;
			pApp->LoadGuesser(pApp->m_pKB); // whm added 29Oct10

			// now do it for the glossing KB
			// BEW 23Aug10 removed wxASSERT() - see reason in comment above of same date
			//wxASSERT(pApp->m_pGlossingKB == NULL);
			if (pApp->m_pGlossingKB != NULL  || pApp->m_bGlossingKBReady)
			{
				// protect from a crash -- strictly speaking this block should never now
				// be entered due to the 24Aug10 fix discussed above, but it can be left
				// here as a safety measure
				pApp->GetDocument()->EraseKB(pApp->m_pGlossingKB);
			}

			pApp->m_pGlossingKB = new CKB(TRUE);
			wxASSERT(pApp->m_pGlossingKB != NULL);
			bOK = pApp->LoadGlossingKB(TRUE); // show the glossing KB's progress dialog
			if (bOK)
			{
				pApp->m_bGlossingKBReady = TRUE;
				pApp->LoadGuesser(pApp->m_pGlossingKB); // whm added 29Oct10
			}
			else
			{
				wxMessageBox(_(
"Error: loading the glossing knowledge base failed. The application will now close."),_T(""),
				wxICON_ERROR | wxOK);
				wxASSERT(FALSE);
				wxExit();
			}
		}
		else
		{
			wxMessageBox(_(
		"Error: loading a knowledge base failed. The application will now close."),
			_T(""), wxICON_ERROR | wxOK);
			wxASSERT(FALSE);
			wxExit();
		}
	}
	else
	{
        // the KB file does not exist, so make sure there is an initialized CKB
        // instance on the application ready to receive data, and save it to disk. for
        // version 2, do the same for the glossing KB
		wxASSERT(pApp->m_pKB == NULL);
		pApp->m_pKB = new CKB(FALSE);
		wxASSERT(pApp->m_pKB != NULL);

		// store the language names in it
		pApp->m_pKB->m_sourceLanguageName = pApp->m_sourceName;
		pApp->m_pKB->m_targetLanguageName = pApp->m_targetName;

		bool bOK = pApp->StoreKB(FALSE); // first time, so we can't make a backup
		if (bOK)
		{
			pApp->m_bKBReady = TRUE;

			// now do the same for the glossing KB
			wxASSERT(pApp->m_pGlossingKB == NULL);
			pApp->m_pGlossingKB = new CKB(TRUE);
			wxASSERT(pApp->m_pGlossingKB != NULL);

			bOK = pApp->StoreGlossingKB(FALSE); // first time, so we can't make a backup
			if (bOK)
			{
				pApp->m_bGlossingKBReady = TRUE;
			}
			else
			{
				// IDS_STORE_GLOSSINGKB_FAILURE
				wxMessageBox(_(
"Error: storing the glossing knowledge base to disk for the first time failed. The application will now close."),
				_T(""), wxICON_ERROR | wxOK); // something went wrong
				wxASSERT(FALSE);
				wxExit();
			}
		}
		else
		{
			// IDS_STORE_KB_FAILURE
			wxMessageBox(_(
"Error: saving the knowledge base failed. The application will now close."),
			_T(""), wxICON_ERROR | wxOK); // something went wrong
			wxASSERT(FALSE);
			wxExit();
		}

		// BEW added 13Nov09: give the local user ownership for writing, or deny it if
		// somehow someone else has gotten ownership of the project folder already
		if (!pApp->m_curProjectPath.IsEmpty())
		{
			// Attempt to set it only if not already set...
			//if (!pApp->m_bReadOnlyAccess)
			pApp->m_bReadOnlyAccess = pApp->m_pROP->SetReadOnlyProtection(pApp->m_curProjectPath);
		}
	}
	*/
    return TRUE;
}

// whm 20May2020 This function is only used in the View's DoTargetBoxPaste()
int CAdapt_ItView::RecalcPhraseBoxWidth(wxString& phrase)
{
    // a sudden change in the m_targetPhrase's length (eg. due to a paste into the phrase
    // box) and a subsequent RecalcLayout() call, would not allow the box to be smaller
    // than its previous value; so RecalcPhraseBoxWidth() can be called wherever the
    // potential for a resizing of the box is called for
	CAdapt_ItApp* pApp = &wxGetApp();
	wxClientDC dc(pApp->GetMainFrame()->canvas);
	wxClientDC* pDC = &dc;
	int pileWidth;
	int dummyHeight;
	wxFont SaveFont;
	wxFont* pTheFont;
	if (gbIsGlossing && gbGlossingUsesNavFont)
		pTheFont = pApp->m_pNavTextFont;
	else
		pTheFont = pApp->m_pTargetFont;
	SaveFont = dc.GetFont();
	pDC->SetFont(*pTheFont);
	pDC->GetTextExtent(phrase,&pileWidth, &dummyHeight);
	wxString aChar = _T('w');
	int charWidth;
	int charDummyHeight;
	pDC->GetTextExtent(aChar,&charWidth,&charDummyHeight);
	pileWidth += pApp->m_nBoxSlop*charWidth; // allow same slop factor as for 
						// RemakePhraseBox & OnChar; (* is 'multiply by)
	dc.SetFont(SaveFont); // restore original font, don't need wxClientDC any more
	return pileWidth;
}

/////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \param      pPile        -> the m_pActivePile where the phrasebox is located when paste
///                             command is invoked
/// \remarks
/// Called from the View's OnEditPaste().
/// DoTargetBoxPaste() is generally only called when the user pastes something from the
/// clipboard into the phrase box. DoTargetBoxPaste() applies any necessary modifications as
/// the result of Consistent Changes (if m_bUseConsistentChanges is TRUE) or any modifications
/// made by SIL Converters (if m_bUseSilConverter is TRUE) or any modifications made by the
/// Guesser (if m_bUseAdaptationsGuesser is TRUE) before inserting the string to the
/// m_targetPhrase. The Guesser cannot be used if the SIL Converters is being used.
/// Also, the Guesser can be used only if Consistent Changes is not being used
/// OR if it is being used AND m_bAllowGuesseronUnchangedCCOutput was set to true by the
/// administrator checking the appropriate checkbox in the GuesserSettingsDlg.
/////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItView::DoTargetBoxPaste(CPile* pPile)
{
	// Modified to handle glossing or adapting
	// whm modified 29Oct10 to handle Guessing
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	pApp->m_pTargetBox->m_bBoxTextByCopyOnly = FALSE; // set this flag FALSE, so text put in the box won't
            // be thrown away if user subsequently clicks to place box elsewhere
            // without doing anything in the phrase box first
	wxString pasteStr;

	// In wx we'll use the clipboard GetData function directly
	if (wxTheClipboard->Open())
	{
		if (wxTheClipboard->IsSupported( wxDF_TEXT ))
		{
			wxTextDataObject data;
			wxTheClipboard->GetData( data );
			pasteStr = data.GetText();
		}
		wxTheClipboard->Close();
	}

    // if consistent changes is turned on, the user must be given the option of having the
    // changes applied or not applied, since we cannot assume that the text to be pasted
    // was not copied from source text (if it was, the changes should be applied)
	wxString insertionText = pasteStr;
	wxASSERT( !(pApp->m_bUseConsistentChanges && pApp->m_bUseSilConverter) ); // not both TRUE
	if (pApp->m_bUseConsistentChanges)
    {
		//IDS_ASK_USE_CC
        if( wxMessageBox(_(
"Do you wish consistent changes to be applied to the text to be pasted?"),
		_T(""), wxICON_QUESTION | wxYES_NO | wxYES_DEFAULT) == wxYES )
		{
			insertionText = DoConsistentChanges(pasteStr);
		}
    }
    else if( pApp->m_bUseSilConverter )
    {
		// IDS_ASK_USE_SILCONVERTER
        if( wxMessageBox(_(
"Do you wish the configured SILConverter to be applied to the text to be pasted?"),
		_T(""), wxICON_QUESTION | wxYES_NO | wxYES_DEFAULT) == wxYES )
	    {
		    insertionText = DoSilConvert(pasteStr);
	    }
    }

	bool bIsGuess = FALSE;
	if (pApp->m_bUseAdaptationsGuesser && !pApp->m_bUseSilConverter)
	{
		// The Guesser cannot be used if the SIL Converters is being used.
		// Also, the Guesser can be used only if Consistent Changes is not being used
		// OR if it is being used AND m_bAllowGuesseronUnchangedCCOutput
		// was set to true by the administrator checking the appropriate checkbox
		// in the GuesserSettingsDlg.
		if (!pApp->m_bUseConsistentChanges || (pApp->m_bUseConsistentChanges && pApp->m_bAllowGuesseronUnchangedCCOutput))
		{
			// We don't need to query the user in this case because the
			// m_bAllowGuesseronUnchangedCCOutput flag would have been changed
			// explicitly by the administrator ticking the checkbox in the
			// GuesserSettingsDlg.
			insertionText = DoGuess(pasteStr,bIsGuess);
			pApp->m_bIsGuess = bIsGuess;
		}
	}

    // if there is a text selection in the current targetBox, erase the selected chars,
    // then get its text and the caret offset - this is where pasteStr must be inserted wx
    // Note: MFC's CEdit::Clear() deletes (clears) the current selection (if any) in the
    // edit control. wxTextCtrl::Clear() "clears the text in the control, and generates a
    // wxEVT_COMMAND_TEXT_UPDATED event." I'll first check for any existing selection by
    // calling GetStringSelection. If GetStringSelection isn't empty we know there is a
    // selection. If so, then use wxTextCtrl's Remove() method to only remove the
    // selection.
	long nS, nE;
    // whm added to only Remove any selected text
	if (!pApp->m_pTargetBox->GetTextCtrl()->GetStringSelection().IsEmpty()) // whm 14Feb2018 added GetTextCtrl()->
	{
		pApp->m_pTargetBox->GetTextCtrl()->GetSelection(&nS,&nE);
		pApp->m_pTargetBox->GetTextCtrl()->Remove(nS,nE); //m_targetBox.Clear();
	}
	long nStart; long nEnd;
	pApp->m_pTargetBox->GetTextCtrl()->GetSelection(&nStart,&nEnd);
	wxString targetPhrase;
	targetPhrase = pApp->m_pTargetBox->GetTextCtrl()->GetValue();
	wxString saveStr = targetPhrase; // make a copy in case we later have to abort
									 // the operation

	// BEW added 18July08, to support leaving cursor at paste location
	// (see Roland Fumey request below)
	int pasteStrLength = insertionText.Length();

    // insert the insertionText into the targetStr at the desired location wxString doesn't
    // have an Insert method, so we'll do it with our own InsertInString (see helpers.h)
	targetPhrase = InsertInString(targetPhrase,(int)nStart,insertionText);

    // We have to recreate the box after measuring the text, because the existing box is
    // almost certainly too small and it will reject any characters it cannot fit in. Note,
    // this code would fail if we try to paste too much text, so we accept the text for
    // pasting only if its extent fits within a strip's width - if not, clear the text &
    // give a warning message, but allow any merge.

	// use the targetPhrase text only if the resulting phrase box can fit within a single strip
	int width = RecalcPhraseBoxWidth(targetPhrase);
	CStrip* pStrip = pPile->GetStrip();
	int stripWidth = pStrip->Width();
	wxASSERT(stripWidth > 0);
	if (width >= stripWidth)
	{
		// it won't fit within a strip, so try to get out of this fix gracefully
		pApp->m_targetPhrase = saveStr; // restore original text back into m_targetPhrase
		// IDS_PASTE_TEXT_TOO_LONG
		wxMessageBox(_(
"Sorry, the paste operation resulted in text which exceeded the maximum width of a strip, so the operation was aborted."),
		_T(""),wxICON_EXCLAMATION | wxOK); // warn user
	}
	else
	{
		pApp->m_targetPhrase = targetPhrase; // put the composite text into m_targetPhrase
	}

    // if there was a selection in line 1, we will honour the assumed intent to merge
    // first, and then the pasted stuff will be assumed to be its adaptation; however, if
    // the selection is too long, we will just remove it (not do Retranslation instead as
    // in OnChar) Do the next block only if glossing is OFF, if it is on, we don't allow a
    // merge and so proceed to the 'else' block
	int nSaveActiveSequNum = pPile->GetSrcPhrase()->m_nSequNumber;
	if (!gbIsGlossing && pApp->m_selection.GetCount() > 1 &&
		pApp->m_selection.GetCount() <= MAX_WORDS &&
		pApp->m_pActivePile == pApp->m_pAnchor->GetPile())
	{
        // if we selected backwards, we have to be careful - we want nSaveActiveSequNum to
        // be first pile of the selection, so check it out now & if necessary adjust
        // nSaveActiveSequNum
		CCellList::Node* cpos = pApp->m_selection.GetFirst();
		CCell* pCell = (CCell*)cpos->GetData();
		wxASSERT(pCell != NULL);
		CPile* pFirstPile = pCell->GetPile();
		int nFirstSequNum = pFirstPile->GetSrcPhrase()->m_nSequNumber;
		if (nFirstSequNum < nSaveActiveSequNum)
			nSaveActiveSequNum = nFirstSequNum;

		// do the merge
		pApp->m_bSuppressDefaultAdaptation = TRUE; // the global boolean for temporary
										   // suppression only
		MergeWords();
        pApp->m_bSuppressDefaultAdaptation = FALSE;

		// restore the active pile pointers
		pPile = GetPile(nSaveActiveSequNum);
		pApp->m_pActivePile = pPile;
	}

	// remove any existing selection, it would be a confusion if left there
	RemoveSelection();

	// setup the phrase box at the same location, but with new size (probably)
	CSourcePhrase* pSrcPhrase = pPile->GetSrcPhrase();
	wxASSERT(pSrcPhrase != NULL);
	pApp->m_nActiveSequNum = pSrcPhrase->m_nSequNumber;
	wxASSERT(pApp->m_nActiveSequNum >= 0);

	gnBoxCursorOffset = nStart + pasteStrLength;

	// make the layout adjustments get done and then the draw and showing of the
	// relocated phrase box
	Invalidate();
	GetLayout()->PlaceBox();
}

CSourcePhrase* CAdapt_ItView::GetSrcPhrase(int nSequNum)
{
	// refactored, no change needed (18Mar09)
	// does the same job as Jonathan's GetSourcePhraseByIndex(int index)
	// defined in CAdapt_ItApp
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	SPList* pList = pApp->m_pSourcePhrases;
	wxASSERT(pList);
	int nCount;
	nCount = pList->GetCount();
	wxASSERT(nCount != 0);
	nCount = nCount; // avoid warning TODO: test for failure?
	SPList::Node* pos_pList = pList->Item(nSequNum);
	wxASSERT(pos_pList != NULL);
	CSourcePhrase* pSrcPhrase = (CSourcePhrase*)pos_pList->GetData();
	wxASSERT(pSrcPhrase);
	return pSrcPhrase;
}

// return the first CSourcePhrase instance after the nStartingSequNum in m_pSourcePhrases
// list, which has an empty m_adaption member, or NULL if no such instance can be found;
// this searches in the list of stored source phrases, so it will search to the very end of
// the doc if necessary For version 2.0 and onwards, test gbIsGlossing and branch
// accordingly.
CSourcePhrase* CAdapt_ItView::GetNextEmptySrcPhrase(int nStartingSequNum)
{
	// refactored 18Mar09
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	CSourcePhrase* pSrcPhrase;
	SPList::Node* pos_pSP = pApp->m_pSourcePhrases->Item(nStartingSequNum);
	do
	{
		pos_pSP = pos_pSP->GetNext();
		if (pos_pSP == NULL)
			return (CSourcePhrase*)NULL; // we have gone past end of document
		pSrcPhrase = pos_pSP->GetData();
		wxASSERT(pSrcPhrase);
		if (gbIsGlossing)
		{
			if (!pSrcPhrase->m_bHasGlossingKBEntry)
				return pSrcPhrase;
		}
		else
		{
			if (!pSrcPhrase->m_bHasKBEntry && !pSrcPhrase->m_bNotInKB &&
				!pSrcPhrase->m_bRetranslation)
				return pSrcPhrase;
		}
	} while (TRUE);
}

CSourcePhrase* CAdapt_ItView::GetFollSafeSrcPhrase(CSourcePhrase* pSrcPhrase)
{
	// refactored 19Mar09
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	wxASSERT(pSrcPhrase);
	int sn = pSrcPhrase->m_nSequNumber;
	CSourcePhrase* pSP;
	SPList::Node* pos_pSP = pApp->m_pSourcePhrases->Item(sn);
	do
	{
		pos_pSP = pos_pSP->GetNext();
		if (pos_pSP == NULL)
			return (CSourcePhrase*)NULL; // we have gone past end of document
		pSP = pos_pSP->GetData();
		wxASSERT(pSP);
	} while (pSP->m_bRetranslation);
	return pSP; // found one where it is okay to have the phrase box put in the view
}

CSourcePhrase* CAdapt_ItView::GetPrevSafeSrcPhrase(CSourcePhrase* pSrcPhrase)
{
	// refactored 19Mar09
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	wxASSERT(pSrcPhrase);
	int sn = pSrcPhrase->m_nSequNumber;
	CSourcePhrase* pSP;
	SPList::Node* pos_pSP = pApp->m_pSourcePhrases->Item(sn);
	do
	{
		pos_pSP = pos_pSP->GetPrevious();
		if (pos_pSP == NULL)
			return (CSourcePhrase*)NULL; // we have gone back past start of document
		pSP = pos_pSP->GetData();
		wxASSERT(pSP);
	} while (pSP->m_bRetranslation);
	return pSP; // found one where it is okay to have the phrase box put in the view
}

// nSaveActiveSequNum, on input, should be the tentative sequNum value we hope will be a
// valid location but may not be; and nActiveSequNum, on input, should be the current
// active location's sequNum; on output, nSaveActiveSequNum will be a different value if
// the input value landed the box in a retranslation... pSrcPhrases is the list on the app,
// nSaveActiveSequNum - this could be too large since we try place the active location
// after the retranslation and that might be beyond the end of the document, hence the need
// to try find a safe place somewhere (its passed by reference because we want the caller's
// variable of the same name to be automatically updated too); nActiveSequNum is a ref to
// the App's m_nActiveSequNum and we will set it from here; nFinish is the final number of
// piles in the retranslation after all adjustments have been done.
// BEW 22Feb10 no changes needed for support of doc version 5
bool CAdapt_ItView::SetActivePilePointerSafely(CAdapt_ItApp* pApp,
		SPList* pSrcPhrases,int& nSaveActiveSequNum,int& nActiveSequNum,int nFinish)
{
	// refactored 19Mar09
	if (nSaveActiveSequNum >= (int)pSrcPhrases->GetCount())
	{
		// need to put active location before the retranslation
		int sequNum = nSaveActiveSequNum - nFinish;
		bool bAtStart = FALSE; // if we get to doc start, put it there no matter what
		CSourcePhrase* pSP;
		do
		{
			--sequNum;
			if (sequNum == 0)
			{
				bAtStart = TRUE;
				break;
			}
			SPList::Node* pos_pSP = pSrcPhrases->Item(sequNum);
			pSP = (CSourcePhrase*)pos_pSP->GetData();
			wxASSERT(pSP != NULL);
		} while (pSP->m_bRetranslation || pSP->m_bNotInKB);
		if (bAtStart)
			nSaveActiveSequNum = 0;
		else
			nSaveActiveSequNum = sequNum; // new value
		pApp->m_pActivePile = GetPile(nSaveActiveSequNum);
	}
	else
	{
		pApp->m_pActivePile = GetPile(nSaveActiveSequNum);

        // this could be a pile containing a retranslation, so check it out, and if so,
        // advance until we find a safe location, and if that process reaches the end of
        // the document without finding a safe location, then go backwards instead until we
        // find one - one of these processes will definitely succeed.
		CSourcePhrase* pSrcPhrase = pApp->m_pActivePile->GetSrcPhrase();
		if (pSrcPhrase->m_bRetranslation)
		{
			// a retranslation is not a valid phrase box location,
			// so hunt for a safe place nearby
			CSourcePhrase* pSaveSP = pSrcPhrase;
			pSrcPhrase = GetFollSafeSrcPhrase(pSrcPhrase);

			if (pSrcPhrase == NULL)
			{
                // reached end of source phrase list without finding a safe place, so look
                // in the opposite direction - this (almost certainly) MUST succeed - it
                // could only fail if the previous active location was in the selection and
                // the selection comprised all of the srcPhrases which are not already in a
                // retranslation, and the whole doc is now a series of consecutive
                // retranslations (most unlikely!)
				pSrcPhrase = GetPrevSafeSrcPhrase(pSaveSP);

				if (pSrcPhrase == NULL)
				{
					// nowhere is a safe location! (Is the user retranslating everything? !!!)
					// so our only option is to go to the end & put it there no matter what
					int lastSequNum = (int)pSrcPhrases->GetCount()- 1;
					CPile* pPile = GetPile(lastSequNum);
					pApp->m_targetPhrase.Empty();
					nActiveSequNum = lastSequNum;
					pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(_T(""));
					pApp->m_targetPhrase = pPile->GetSrcPhrase()->m_adaption;
					pApp->m_pActivePile = pPile;
					pApp->m_pRetranslation->SetSuppressRemovalOfRefString(FALSE); // ensure it's turned back off
					return FALSE; // Note: of 9 calls in the app, only 2 actually use this returned
					// FALSE VALUE - once in OnButtonRetranslation() and the other in
					// OnButtonEditRetranslation - where they, in the legacy version, caused a
					// warning message to show and the function exited early; in the refactored
					// version the return call after the message is commented out, so the function
					// proceeds normally and the message still shows and the phrase box is put at
					// the document end, visible.
				}
			}
		}

		// jump to whatever pile is not in a retranslation, as close to wanted loc'n as possible
		nSaveActiveSequNum = pSrcPhrase->m_nSequNumber;
        pApp->m_nOldSequNum = nSaveActiveSequNum; // the only safe option, since old location may now
										   // be within the retranslation
		Jump(pApp,pSrcPhrase);
	}
	nActiveSequNum = nSaveActiveSequNum; // ensure value of pApp->m_nActiveSequNum agrees with any
										 // adjustments
	pApp->m_pRetranslation->SetSuppressRemovalOfRefString(FALSE); // ensure it's turned back off
	return TRUE;
}

// returns a pointer to the next pile having no target language (adapted) string, or NULL
// if there is no such empty pile later in the document
// for version 2.0 and on, the check is done on m_glossing instead, when glossing is ON
// BEW 12Mar18 Added a hack to correct a hole which wrongly has m_bHasKBEntry TRUE when in fact
// the adaptation KB's CTargetUnit at that pile's CSourcePhrase has no empty string translation;
// when that happens, unless we correct m_bHasKBEntry to be FALSE, the phrasebox won't stop
// there as OnePass() gets to the hole
// whm 16Mar2018 modified the determination of bTargetUnitHasEmptyTranslation in the do...while
// loop below. It can be TRUE only when there is just one ref strings which is an 
// empty string (i.e., <no adaptation>). 
// BEW 9Sep22, the glossing code block needs a heavy refactoring, to make it work like the
// else block for adapting mode - but the details of some tests will differ. This refactoring
// was needed because GetNextEmptyPile() was stopping at piles which were not glossing "holes".
CPile* CAdapt_ItView::GetNextEmptyPile(CPile *pPile)
{
	// refactored 23Mar09, BEW 12Mar18
	CKB* pKB = GetKB(); // added 12Mar18
	if (gbIsGlossing)
	{
		// BEW 9Sep22, in glossing mode, 'src' is m_adaption, and 'tgt' is m_gloss
		do
		{
			pPile = GetNextPile(pPile);
			if (pPile == NULL)
				break;
			// BEW 9Sep22 The hack mentioned above to fix a CSourcePhrase which thinks it has an
			// empty string in the glossing KB as a gloss here when the Glossing KB knows it hasn't
			CSourcePhrase* pSrcPhrase = pPile->GetSrcPhrase();
			int numWords = pSrcPhrase->GetTgtWordCount();
			bool bIsGlossingKB = pKB->IsThisAGlossingKB();
			if (bIsGlossingKB)
			{
				CTargetUnit* pTU = pKB->GetTargetUnit(numWords, pSrcPhrase->m_gloss);
				int refStrCount = 0; // initialise
				if (pTU != NULL)
				{
					// BEW 9Sep22 modified the determination of bTargetUnitHasEmptyGloss 
					// below. Set TRUE only when there is just one ref string and it stores an 
					// empty gloss string; if there are other ref strings besides the empty
					// one, then set bTargetUnitHasEmptyTranslation FALSE
					refStrCount = pTU->CountNonDeletedRefStringInstances(); // works for adapting or glossing
					bool bTargetUnitHasEmptyGloss = pTU->HasEmptyTranslation(); // works for adapting or glossing
					// HasEmptyTranslation() returns TRUE if at least one ref string is empty 
					// (there may be multiple ref strings, containing, in this case, gloss strings) 
					if (bTargetUnitHasEmptyGloss == TRUE && refStrCount > 1)
					{
						// There is are more than one ref strings, one of which is an empty gloss string.
						// (So the phrasebox will halt in the GUI, and the dropdown combo will open to
						// display the alternatives)
						bTargetUnitHasEmptyGloss = FALSE;
					}
					if (pSrcPhrase->m_bHasGlossingKBEntry && !bTargetUnitHasEmptyGloss && pSrcPhrase->m_gloss.IsEmpty())
					{
						// Correction of the flag value is needed
						pSrcPhrase->m_bHasGlossingKBEntry = FALSE;
					}

				} // end of TRUE block for test: if (pTU != NULL)

			} // end of TRUE block for test: if (bIsGlossingKB)

			// BEW 9Sep22 the while test: the halt versus continue iterating conditions will differ for glossing mode
			// for example, adapting mode may have a retranslation at one or more piles, and we will permit glossing
			// under those piles which are placeholder ones, since glossing mode wants tgt/gloss entries in the
			// glossing KB. But for long retranslations, the target text may partly lie at one or more placeholders
			// to the right. In the retranslation span of piles, because they hold tgt text, we allow glossing to occur.
			// BUT, there is a caveat. It's risky. Why? If the user changes back to adapting mode, and edits the
			// Retranslation, or removes it, the glosses within the Retranslation span will be thrown away. However
			// After the retranslation change is made, the glossing can be redone - but manually, as it's likely
			// that the adaptation words then differ from before. 
		} while (pPile->GetSrcPhrase()->m_bHasGlossingKBEntry // if TRUE, it's not a glossing "hole" - keep iterating
			|| (!pPile->GetSrcPhrase()->m_adaption.IsEmpty() // m_adaption needs to be non-empty, as it's the 
															 // 'src' for a KB storage, and...
			&& !pPile->GetSrcPhrase()->m_gloss.IsEmpty() )   // if there is a non-empty gloss at the pile, it's not a "hole"
			);
	}
	else // currently adapting
	{
#if defined (_DEBUG)
		CSourcePhrase* pSPhr = pPile->GetSrcPhrase();
		int theSN = pSPhr->m_nSequNumber; wxUnusedVar(theSN); // avoid compiler warning variable initialized but not referenced
		if (pPile != NULL && (pSPhr->m_nSequNumber >= 0 && pSPhr->m_nSequNumber <= 3) )
		{
			int halt_here = 1; wxUnusedVar(halt_here);
		}
#endif

		do
		{
			pPile = GetNextPile(pPile);
			if (pPile == NULL)
				break;
			// BEW 12Mar18 The hack mentioned above to fix a CSourcePhrase which thinks it
			// has an empty string in the KB as an adaptation here when the KB knows it hasn't
			CSourcePhrase* pSrcPhrase = pPile->GetSrcPhrase();
			int numWords = pSrcPhrase->m_nSrcWords;
			CTargetUnit* pTU = pKB->GetTargetUnit(numWords, pSrcPhrase->m_key);
            int refStrCount = 0; // whm 16Mar2018 added
			if (pTU != NULL)
			{
                // whm 16Mar2018 modified the determination of bTargetUnitHasEmptyTranslation 
                // below. It can be TRUE only when there is just one ref string which is an 
                // empty string (i.e., <no adaptation>).
                refStrCount = pTU->CountNonDeletedRefStringInstances();
                bool bTargetUnitHasEmptyTranslation = pTU->HasEmptyTranslation(); 
				// HasEmptyTranslation() returns TRUE if at least one ref string is empty (there may be multiple ref strings)
                if (bTargetUnitHasEmptyTranslation == TRUE && refStrCount > 1)
                {
                    // There is are more than one ref strings, one of which is the empty string.
                    bTargetUnitHasEmptyTranslation = FALSE;
                }

                if (pSrcPhrase->m_bHasKBEntry && !bTargetUnitHasEmptyTranslation && pSrcPhrase->m_adaption.IsEmpty())
                {
					// Correction of the flag value is needed
					pSrcPhrase->m_bHasKBEntry = FALSE;
				}
				
			}
		} while (pPile->GetSrcPhrase()->m_bHasKBEntry ||
					pPile->GetSrcPhrase()->m_bNotInKB ||
                    (pPile->GetSrcPhrase()->m_bNullSourcePhrase && !pPile->GetSrcPhrase()->m_adaption.IsEmpty()) || // whm 20May2020 added this test
					pPile->GetSrcPhrase()->m_bRetranslation);
        // whm 20May2020 added a 4th subtest above to prevent GetNextEmptyPile from stopping 
        // at a placeholder that already has some adapted text.
        //
		// BEW 3Sep14, added 3rd subtest to the while () test, because some
		// retranslations in Roland Fumey's glossary document had their padding
		// placeholders with m_bNotInKB FALSE, when TRUE was expected (all the
		// non-placeholders in the retranslation always had this flag TRUE). I don't
		// know why these variations happened - perhaps an old version of AI did
		// things differently. In this doc were 22 retranslations where the placeholders
		// had this flag FALSE, and only 7 with it TRUE. Anyway, by testing for
		// m_bRetranslation being TRUE, which is always correct in the retranslations,
		// we won't get the bug of the search for a hole wrongly halting at the first
		// placeholder (doing padding in a retranslation) with FALSE for the
		// m_bNotInKB flag. That caused the message that editing of a retranslation
		// could not be done by trying to place the box in the retranslation, to
		// wrongly come up. So now this issue is fixed.
	}
	return pPile;
}

void CAdapt_ItView::GetVisibleStrips(int& nFirstStrip,int&nLastStrip)
// nFirstStrip = index of first strip visible (or partly visible) in the view
// nLast Strip = index of last strip visible (or partly visible) in the view
{
	// refactored 1Apr09
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	CLayout* pLayout = GetLayout();
	wxClientDC dc(pLayout->m_pCanvas);
	canvas->DoPrepareDC(dc); // adjust origin

	// find the index of the first strip which is visible
	wxRect rectStrip;
	int nTotalStrips = pLayout->GetStripArray()->GetCount();
	wxRect rectClient;
    // wx note: calling GetClientSize on the canvas produced different results in wxGTK and
    // wxMSW, so I'll use my own GetCanvasClientSize() which calculates it from the main
    // frame's client size.
	wxSize canvasViewSize;
	canvasViewSize = pApp->GetMainFrame()->GetCanvasClientSize();

//#ifdef _DEBUG
//	// Here's sample code for alternative 1:
//	// save a copy of the initial grectViewClient values for use below (alternative 2 changes grectViewClient)
//	wxRect testRectViewClient = rectClient;
//#endif

	//int xScrollUnits, yScrollUnits, xOrigin, yOrigin;
	//pApp->GetMainFrame()->canvas->GetViewStart(&xOrigin, &yOrigin); // gets xOrigin and yOrigin in scroll units
	//pApp->GetMainFrame()->canvas->GetScrollPixelsPerUnit(&xScrollUnits, &yScrollUnits); // gets pixels per scroll unit
	//rectClient.x = xOrigin * xScrollUnits; // number pixels is ScrollUnits * pixelsPerScrollUnit
	//rectClient.y = yOrigin * yScrollUnits;

//#ifdef _DEBUG
//	//wx version uses CalcUnscrolledPosition
//	int newXPos,newYPos;
//	pApp->GetMainFrame()->canvas->CalcUnscrolledPosition(0,0,&newXPos,&newYPos);
//	wxASSERT(newXPos == rectClient.x); //rectClient.x = newXPos; // stays zero since we dont' have horizontal scrolling
//	wxASSERT(newYPos == rectClient.y); //rectClient.y = newYPos;
//#endif

//#ifdef _DEBUG
//	//dc.DPtoLP(&rectClient); // this is like the MFC method
//	int x = dc.DeviceToLogicalX(testRectViewClient.x);// get the device X (width) coord converted to logical coord
//	int y = dc.DeviceToLogicalY(testRectViewClient.y); // get the device Y (height) coord converted to logical coord
//	wxASSERT(x == rectClient.x);
//	wxASSERT(y == rectClient.y);
//#endif

	wxArrayPtrVoid* pStripArray = pLayout->GetStripArray();
	CStrip* pStrip = NULL;
	pLayout->m_pCanvas->CalcUnscrolledPosition(0,0,&rectClient.x,&rectClient.y);
	rectClient.width = canvasViewSize.x;
	rectClient.height = canvasViewSize.y;
	wxPoint ptStripBottomRight;
	wxPoint ptStripTopLeft;
	int i;
	for (i = 0; i < nTotalStrips; i++)
	{
		pStrip = (CStrip*)(*pStripArray)[i];
		pStrip->GetStripRect_CellsOnly(rectStrip);
		ptStripBottomRight.x = rectStrip.GetRight();
		ptStripBottomRight.y = rectStrip.GetBottom();

		if (ptStripBottomRight.y > rectClient.GetTop())
		{
			// this strip is at least partly visible
			nFirstStrip = pStrip->GetStripIndex(); // Hmmm, Bill could have just said
											// nFirstStrip = i; here for the same result
			break;
		}
	}

	int j;
	for (j = i + 1; j < nTotalStrips; j++)
	{
		pStrip = (CStrip*)(*pStripArray)[j];
		pStrip->GetStripRect_CellsOnly(rectStrip);

		ptStripTopLeft.x = rectStrip.GetLeft(); // get TopLeft in 2 steps
		ptStripTopLeft.y = rectStrip.GetTop();
		if (ptStripTopLeft.y >= rectClient.GetBottom())
		{
			nLastStrip = --j;
			wxASSERT(nLastStrip > nFirstStrip);
			break;
		}
	}
	if (j == nTotalStrips)
	{
		// we got to the end of the document
		nLastStrip = nTotalStrips - 1;
		wxASSERT(nLastStrip > nFirstStrip);
	}
}

// DoGetSuitableText_ForPlacePhraseBox() factors out a whole lot of special cases for
// getting suitable text to put in the phrase box when the box is reconstituted at the new
// location at which the user clicked to relocate the box there - it simplifies the flow of
// code in PlacePhraseBox() for the sake of the human trying to follow what is going on
// here
// BEW 21Jul14, no changes needed for ZWSP support
// BEW 18Aug21 no significant changes, just cleaned up a little
// BEW 9Aug23 refactored bits, to get pSrcPhrase as kickoff location when Enter or Tab key
// is pressed, to grab cached values & restore, and bypass call of CopySourceKey()
void CAdapt_ItView::DoGetSuitableText_ForPlacePhraseBox(CAdapt_ItApp* pApp,
		CSourcePhrase* pSrcPhrase, int selector, CPile* pActivePile, wxString& str,
		bool bHasNothing, bool bNoValidText, bool bCopySomethingFromSrc)
{
	selector = selector; // to avoid a compiler warning
	wxASSERT(pApp);
	bool bGotOne = FALSE;

#if defined(_DEBUG) && defined(_OVERLAP)
	{
		CSourcePhrase* pSPhr = pApp->m_pActivePile->GetSrcPhrase();
		wxTextCtrl* pTxtBox = pApp->m_pTargetBox->GetTextCtrl();
		int boxWidth = pTxtBox->GetClientRect().width;
		wxLogDebug(_T("%s::%s() line %d: just ENTERED: boxWidth from wxRect's width: %d, Initial tgt str value: %s , slop %d , tgt = %s"),
			__FILE__, __FUNCTION__, __LINE__, boxWidth, str.c_str(), pApp->GetLayout()->slop,  pSPhr->m_adaption.c_str());
		//if (pSPhr->m_nSequNumber > 0 || pSPhr->m_nSequNumber <= 411)
		if (pSPhr->m_nSequNumber > 0 && pSPhr->m_nSequNumber == 2)
		{
			int halt_here = 1;
			wxUnusedVar(halt_here);
		}
	}
#endif
#if defined(_DEBUG) && defined(FLAGS)
	{
		CAdapt_ItApp* pApp = &wxGetApp();
		wxLogDebug(_T("DoGetSuitableText..(), line %d, sn=%d, m_key= %s, m_bAbandonable %d, m_bRetainBoxContents %d, m_bUserTypedSomething %d, m_bBoxTextByCopyOnly %d, m_bAutoInsert %d"), 
			__LINE__,pSrcPhrase->m_nSequNumber, pSrcPhrase->m_key.c_str(), (int)pApp->m_pTargetBox->m_bAbandonable, (int)pApp->m_pTargetBox->m_bRetainBoxContents,
			(int)pApp->m_bUserTypedSomething, (int)pApp->m_pTargetBox->m_bBoxTextByCopyOnly, (int)pApp->m_bAutoInsert );
		if (pSrcPhrase->m_nSequNumber >= 117)
		{
			int halt_here = 1;
			wxUnusedVar(halt_here);
		}

	}
#endif

	if (bHasNothing)
	{
		// there is as yet no translation for this source phrase & no copy from source
#if defined(ABANDON_NOT)
		pApp->m_pTargetBox->m_bAbandonable = FALSE;
#else
		pApp->m_pTargetBox->m_bAbandonable = TRUE;
#endif
        pApp->m_pTargetBox->m_bBoxTextByCopyOnly = FALSE;
	}
	else
	{
        // This block is for when the current active location has adaptation content (or,
        // in glossing mode, gloss content) -- FALSE for bHasNothing is the default value,
        // so in effect control usually routes through this block unless the caller sets
        // bHasNothing to TRUE explicitly. In fact, the app setting m_bCopySource being set
        // with its default value of TRUE is sufficient to ensure the bHasNothing flag is
        // never set TRUE, regardless of the value of the m_bHasKBEntry and m_bNotInKB
		// flags. It's then the bNoValidText which is significant, and that has to be TRUE
		// (indicative of a "hole") for lookup to take place.
        pApp->m_pTargetBox->m_bBoxTextByCopyOnly = FALSE;
		if (bNoValidText)
		{
            // BEW added 20Dec07 to prevent lookup when in Reviewing mode (some further
            // comments & supporting code changes are in the blocks below)
			if (pApp->m_bDrafting)
			{
                // BEW added 16Jul09; return an empty string if we are in free translation
                // mode and the phrase box at the next section has been put at a "hole"
				if (pApp->m_bFreeTranslationMode)
				{
					str.Empty();
					return;
				}
//#ifdef SHOW_LOOK_AHEAD_BENCHMARKS
//               wxDateTime dt1 = wxDateTime::Now(),
//                   dt2 = wxDateTime::UNow();
//#endif
                // it's not free translation mode, so try find something
				bGotOne = pApp->m_pTargetBox->LookAhead(pApp->m_pActivePile);
//#ifdef SHOW_LOOK_AHEAD_BENCHMARKS
//                dt1 = dt2;
//                dt2 = wxDateTime::UNow();
//                wxLogDebug(_T("In DoGetSuitableText_ForPlacePhraseBox() LookAhead() executed in %s ms"),
 //                   (dt2 - dt1).Format(_T("%l")).c_str());
//#endif
            }
			else // we are in reviewing mode for the code in next block
			{
				// Reviewing mode, we still need to ensure that if the user cancelled a
				// Choose Translation merge, then pSrcPhrase will be valid before we proceed
				pSrcPhrase = pApp->m_pActivePile->GetSrcPhrase();

				// ensure clicks to a location which is a hole don't, on leaving, result in
				// punctuation being copied from the source text if present there
				// BEW 10Sep22 add glossing refactored support
				if (gbIsGlossing)
				{
					if (pSrcPhrase->m_gloss.IsEmpty())
					{
						// BEW 10Sep22  hoping these values make sense when glossing
						pApp->m_pTargetBox->m_bSavedTargetStringWithPunctInReviewingMode = FALSE;
						pApp->m_pTargetBox->m_StrSavedTargetStringWithPunctInReviewingMode = pSrcPhrase->m_gloss;
					}
				}
				else
				{
					// adapting mode
					if (pSrcPhrase->m_targetStr.IsEmpty() || pSrcPhrase->m_adaption.IsEmpty())
					{
						// no text or punctuation, or no text and punctuation not yet placed,
						// or no text and punctuation was earlier placed -- whichever is the case
						// we need to preserve that state
						pApp->m_pTargetBox->m_bSavedTargetStringWithPunctInReviewingMode = TRUE;  // it gets cleared again at
																// end of MakeTargetStringIncludingPunctuation()
						pApp->m_pTargetBox->m_StrSavedTargetStringWithPunctInReviewingMode = pSrcPhrase->m_targetStr; // cleared
																// at end of MakeTargetStringIncludingPunctuation()
					}
				}

				pApp->m_pTargetBox->m_bAbandonable = FALSE;	// don't throw away unedited
                //phrase box contents when the phrase box leaves a location by a user's
                //click and then make sure we retain the contents in the m_targetStr member
                //of pSrcPhrase, (or m_gloss in glossing mode) since user is reviewing; 
				// but use m_gloss if Glossing mode is on
				if (gbIsGlossing)
					str = pSrcPhrase->m_gloss;
				else
					str = pSrcPhrase->m_targetStr;
			} // end of else block for test: if (pApp->m_bDrafting)

			// in Reviewing mode, bGotOne will always be FALSE when control reaches here and so
			// the next block would not be entered - which is fine because in Reviewing mode
			// there is no need to perform a merge when landing on a new pile
			if (bGotOne)
			{
				if (!gbIsGlossing)// do nix here if glossing is on, since glossing disallows merges
				{
                    // whm 24Feb2018 TODO: Bruce should check the logic of using m_bCompletedMergeAndMove with the new dropdown feature!!
					if (!pApp->m_pTargetBox->m_bCompletedMergeAndMove) // (true means phrase box moved before Choose
					{							  // Translation dialog can be shown, see LookAhead( )
						// do this only if the flag was not set
						pApp->m_pTargetBox->m_bAbandonable = FALSE;
						if (pApp->m_pTargetBox->m_nWordsInPhrase > 1) // m_nWordsInPhrase is a member of CPhraseBox
						{
							// do the needed merge, etc.
							pApp->bLookAheadMerge = TRUE; // set static flag to ON
							MergeWords(); // the Choose Translation dialog might be shown in this call
							pApp->bLookAheadMerge = FALSE; // restore static flag to OFF
						}
					}
				}

                // if user cancelled a Choose Translation merge, then pSrcPhrase will be
                // invalid, so we have to make sure the pointer is valid before we proceed
				pSrcPhrase = pApp->m_pActivePile->GetSrcPhrase();
				if (pSrcPhrase->m_nSequNumber >= 117)
				{
					int halt_here = 1;
					wxUnusedVar(halt_here);
				}

                // assign the translation text - but check it's not "<Not In KB>", if it
                // is, we leave the phrase box empty, turn OFF the m_bSaveToKB flag, DON'T
                // halt auto-inserting if it is on, (formerly, I made it halt) from v 1.4.0
                // and onwards, we have to just put default null adaptation there, since a
                // successful lookup of 'not in kb' can't possibly assign any adaptation
                // except null text - unless there already is something on the source
                // phrase - in which case use that
				pApp->m_pTargetBox->m_bAbandonable = FALSE;
                // if we are glossing, then the global variable wxString m_Translation, will
                // have the gloss because a successful lookup was done
				if (!gbIsGlossing)
				{
                    // if adapting, check for a not in kb entry and if it is, then adjust
                    // m_Translation; strictly speaking we only want to clear the string when
                    // in Drafting mode, but in Reviewing mode we want to let whatever was
                    // formerly there continue unchanged, so a test would be appropriate
                    // here if it was not for the fact that above we wrap the LookAhead
                    // call in a test of the m_bDrafting flag, and so in Reviewing mode
                    // bGotOne remains FALSE and so this current block would not be entered
					if (pApp->m_pTargetBox->m_Translation == _T("<Not In KB>"))
					{
						pApp->m_bSaveToKB = FALSE;
						pSrcPhrase->m_bHasKBEntry = FALSE; // ensures * shows above this srcPhrase
						pSrcPhrase->m_bNotInKB = TRUE;
						if (pSrcPhrase->m_targetStr.IsEmpty())
						{
                            pApp->m_pTargetBox->m_Translation.Empty(); // clear the global
							pApp->m_targetPhrase.Empty();
						}
						else
						{
                            pApp->m_pTargetBox->m_Translation = pSrcPhrase->m_targetStr;
						}
					}
				}
				str = pApp->m_pTargetBox->m_Translation; // adapting or glossing, put the final m_Translation into str

			} // end of TRUE block for test: if (bGotOne)
		}
		else // there is valid text -- this is typically the case when in Reviewing mode; it
			 // also is the case when the user uses the mouse to click on a non-hole location
			 // -- but we exclude doing anything in the latter situation by an explicit test
			 // within this block for review mode - ie. we test for m_bDrafting is FALSE
		{
            // when in Reviewing mode and the user clicks on existing adaptation or gloss
            // text, no lookup is done because bNoValidText is FALSE, and so control will
            // have jumped to the present block. At this point, str is still empty, and so
            // we need here to ensure that what is at the clicked location is retained, so
            // we set str etc.
			if (!pApp->m_bDrafting) // ensure we really *are* in Reviewing mode for this stuff
			{
				// Reviewing mode, we still need to ensure that if the user cancelled a
				// Choose Translation merge, then pSrcPhrase will be valid before we proceed
				pSrcPhrase = pApp->m_pActivePile->GetSrcPhrase();

				// ensure clicks to a location which is a hole don't, on leaving, result in
				// punctuation being copied from the source text if present there
				// BEW 10Sep22 add a subtest for 'not glossing' here
				if (!gbIsGlossing && (pSrcPhrase->m_targetStr.IsEmpty() || pSrcPhrase->m_adaption.IsEmpty()) )
				{
					// no text or punctuation, or no text and punctuation not yet placed,
					// or no text and punctuation was earlier placed -- whichever is the case
					// we need to preserve that state
                    pApp->m_pTargetBox->m_bSavedTargetStringWithPunctInReviewingMode = TRUE;	// it gets cleared again at end
															// of MakeTargetStringIncludingPunctuation()
                    pApp->m_pTargetBox->m_StrSavedTargetStringWithPunctInReviewingMode = pSrcPhrase->m_targetStr; // cleared at
																// end of MakeTargetStringIncludingPunctuation()
				}
				pApp->m_pTargetBox->m_bAbandonable = FALSE; // don't throw away unedited
                    // phrase box contents when the phrase box leaves a location by a click
                    // and then make sure we retain the contents in the m_targetStr member
                    // of pSrcPhrase, since user is reviewing; but use m_gloss if Glossing
                    // mode is on
				if (gbIsGlossing)
					str = pSrcPhrase->m_gloss;
				else
					str = pSrcPhrase->m_targetStr;
			} // end block for check that we really are in reviewing mode

		} // end of else block for test:if (bGotOne) -- ie. we did not find something

        // BEW added to the test 02Nov05, so that when the SplitDialog is active, any use
        // of a button in that dialog which results in a PlacePhraseBox being done (eg. by
        // Jump()) will not copy the source text into the phrasebox if the box lands at a
        // hitherto unadapted (or unglossed) location -- so if the document split is then
        // made at that location, it won't save into the KB a spurious copy of the source
        // text as the 'adaptation' at whatever location the box happened to land at. The
        // app setter function SetCurrentSourcePhrase sets and clears the global flag
        // gbIsDocumentSplittingDialogActive to effect this.
		if (!bGotOne && !gbIsDocumentSplittingDialogActive)
		{
            // if user cancelled a Choose Translation merge, then pSrcPhrase will be
            // invalid, so we have to make sure the pointer is valid before we proceed
			pSrcPhrase = pApp->m_pActivePile->GetSrcPhrase();
			// BEW 12Jun13, pActivePile is now invalid, which leads to a crash if the user
			// Canceled from the ChooseTranslation() dialog, so reset it here to fix this
			pActivePile = pApp->m_pActivePile;

            // BEW added test 20Dec07: Reviewing mode must not copy down source text into
            // holes (ie. we assume the holes are there by choice, and we don't want
            // spurious text to fill them, although the user is free to manually type at
            // such locations if he wishes)
			if (pApp->m_bDrafting)
			{
#if defined(_DEBUG) && defined(FLAGS)
				{
					CAdapt_ItApp* pApp = &wxGetApp();
					wxLogDebug(_T("DoGetSuitableText..(), line %d, sn=%d, m_key= %s, m_bAbandonable %d, m_bRetainBoxContents %d, m_bUserTypedSomething %d, m_bBoxTextByCopyOnly %d, m_bAutoInsert %d"),
						__LINE__, pSrcPhrase->m_nSequNumber, pSrcPhrase->m_key.c_str(), (int)pApp->m_pTargetBox->m_bAbandonable, (int)pApp->m_pTargetBox->m_bRetainBoxContents,
						(int)pApp->m_bUserTypedSomething, (int)pApp->m_pTargetBox->m_bBoxTextByCopyOnly, (int)pApp->m_bAutoInsert);
				}
#endif

                // lookup did not find a suitable adaptation, or gloss if in glossing mode,
                // so we want a copy from the sourcePhrase done instead - but not when in
                // Reviewing mode
				wxString theText;
				if (gbIsGlossing)
					theText = pSrcPhrase->m_gloss;
				else
					theText = pSrcPhrase->m_adaption;
				if (!theText.IsEmpty()) // we want a punctuation-less test here
				{
					if (gbIsGlossing)
					{
						str = theText;
					}
					else // adapting
					{
						str = pSrcPhrase->m_adaption; // no punctuation to be shown
						// BEW changed 28Apr05, this is a better choice for the box contents
						// than to show punctuation if the m_bHidePunctuation flag is FALSE;
						// always using m_adaption means MakeTargetStringIncludingPunctuation() can then be
						// allowed to do its work when the phrase box moves on, that's best
					}
					pApp->m_pTargetBox->m_bAbandonable = FALSE;
#if defined(_DEBUG) && defined(FLAGS)
					{
						CAdapt_ItApp* pApp = &wxGetApp();
						wxLogDebug(_T("DoGetSuitableText..(), line %d, sn=%d, m_key= %s, m_bAbandonable %d, m_bRetainBoxContents %d, m_bUserTypedSomething %d, m_bBoxTextByCopyOnly %d, m_bAutoInsert %d"),
							__LINE__, pSrcPhrase->m_nSequNumber, pSrcPhrase->m_key.c_str(), (int)pApp->m_pTargetBox->m_bAbandonable, (int)pApp->m_pTargetBox->m_bRetainBoxContents,
							(int)pApp->m_bUserTypedSomething, (int)pApp->m_pTargetBox->m_bBoxTextByCopyOnly, (int)pApp->m_bAutoInsert);
					}
#endif
				}
				else
				{
					if (bCopySomethingFromSrc) // param in signature
					{
						// the copy sets m_bBoxTextByCopyOnly to TRUE - it's the only place this boolean can be
						// set true, so is a good diagnostic in our logging calls for checking if an unwanted
						// copy of src happens somewhere
						str = CopySourceKey(pSrcPhrase, pApp->m_bUseConsistentChanges);
					}
					else // nothing copied, or its a null source phrase, or a null string, or the menu used to turn copy off
					{
                        // we didn't do a copy, so we will want whatever eventually results
                        // to still be stored later on
                        pApp->m_pTargetBox->m_bBoxTextByCopyOnly = FALSE;
					}
					// if its a null source phrase, or the copy source flag is turned off,
					// or the user stored a null string as the adaption, we don't show anything
					// - but either way it's abandonable - unless we have values stored on app.h making it not abandonable
#if defined(ABANDON_NOT)
					pApp->m_pTargetBox->m_bAbandonable = FALSE;
#else
					pApp->m_pTargetBox->m_bAbandonable = TRUE;
#endif
				}
			} // end of block for m_bDrafting == TRUE, for Reviewing mode we
			  // don't want a copy done
		} // end block for tests: bGotOne == FALSE and "is split dialog is
		  // active currently?" == FALSE
#if defined(_DEBUG) && defined(FLAGS)
		{
			CAdapt_ItApp* pApp = &wxGetApp();
			wxLogDebug(_T("DoGetSuitableText..(), line %d, sn=%d, m_key= %s, m_bAbandonable %d, m_bRetainBoxContents %d, m_bUserTypedSomething %d, m_bBoxTextByCopyOnly %d, m_bAutoInsert %d"),
				__LINE__, pSrcPhrase->m_nSequNumber, pSrcPhrase->m_key.c_str(), (int)pApp->m_pTargetBox->m_bAbandonable, (int)pApp->m_pTargetBox->m_bRetainBoxContents,
				(int)pApp->m_bUserTypedSomething, (int)pApp->m_pTargetBox->m_bBoxTextByCopyOnly, (int)pApp->m_bAutoInsert);
		}
#endif

		// this next call relies for it's success on pActivePile being the CPile* at the
		// new active location, and that the partner CSourcePhrase instance has its
		// m_nSequNumber value set to the same value as the app's member m_nActiveSequNum
		// - these conditions are guaranteed by code in the caller before this function is
		// called.
		// 
		// whm 24Jan2023 added back the SetPhraseBoxGapWidth() call, which assigns the 
		// returned value of CalcPhraseBoxGapWidth() to CPile::m_nWidth.
		// BEW reported this date that he was unable to select the source phrase at the active
		// location and that the problem was due to the CPile::m_nWidth member still had a -1
		// uninitializaion value.
		// However, testing with the call commented out indicates that the SetPhraseBoxGapWidth() 
		// call is not really needed here to solve the issue of not being able to select the source
		// phrase at the active location.
		//pActivePile->SetPhraseBoxGapWidth(); // Assigns value of CalcPhraseBoxGapWidth() to m_nWidth

	} // end of else block for test: if (bHasNothing)
}

// Returns nothing.
// This function is called when a match has been made for a Find button click, also when
// no match is possible or user cancels out of the Find operation. The idea is to place
// the phrase box at the start of the match (the user may have stipulated that the match
// be for more than one word and across piles), and the source text selected there, and
// the PlacePhraseBox() call made, followed by ScrollIntoView() in order to give the user
// all options for what to do next. If several words were selected at the take off
// location, then the match should be for the same number of words at the landing location
// and the selection is set up accordingly as possible. A complication is when the matched
// text is within a retranslation - in this circumstance we select the matched text as
// before, but the active location is moved to be "safe" which in this circumstance means
// immediately before the retranslation. In the case of matching source text, the
// selection is normal yellow background. In the case of matching target text, we'll do
// similarly and no try to be smart, and just select all of the phrase box contents - even
// if only part of the text was matched.
void CAdapt_ItView::FindNextHasLanded(int nLandingLocSequNum, bool bSuppressSelectionExtension)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	CPile* pPile = NULL;
	if (nLandingLocSequNum == -1)
	{
		// should never be called with a value of -1 passed in, but if so, just do nothing
		return;
	}
	pPile = GetPile(nLandingLocSequNum);

	// preserve enough information to be able to recreate the appropriate selection
	// since placing the phrase box will clobber the earlier selection at last landing
	CSourcePhrase* pSrcPhrase = pPile->GetSrcPhrase();
	int nCount = 0;
	if (!pApp->m_selection.IsEmpty())
	{
		nCount = pApp->m_selection.GetCount();
		wxASSERT(nCount > 0);
	}
	int nSaveSelSequNum = pSrcPhrase->m_nSequNumber; // if in a retrans,
								// selection will not be where phrase box ends up

    // pPile is what we will use for the active pile, so set everything up there,
    // provided it is not in a retranslation - if it is, place the box preceding
    // it, if possible; but if glossing is ON, we can have the box within a
    // retranslation in which case ignore the block of code
	CPile* pSavePile = pPile;
	if (!gbIsGlossing)
	{
		while (pSrcPhrase->m_bRetranslation)
		{
			pPile = GetPrevPile(pPile);
			if (pPile == NULL)
			{
				// if we get to the start, try again, going the other way
				pPile = pSavePile;
				while (pSrcPhrase->m_bRetranslation)
				{
					pPile = GetNextPile(pPile);
					wxASSERT(pPile != NULL); // we'll assume this will never fail
					pSrcPhrase = pPile->GetSrcPhrase();
				}
				break;
			}
			pSrcPhrase = pPile->GetSrcPhrase();
		}
	}
	pSrcPhrase = pPile->GetSrcPhrase();
	pApp->m_nActiveSequNum = pSrcPhrase->m_nSequNumber; // what we finally will use
	pApp->m_pActivePile = pPile;
	CCell* pCell = pPile->GetCell(1); // we want the 2nd line, for phrase box

	// place the phrase box
	PlacePhraseBox(pCell,2);

	// get a new active pile pointer, the PlacePhraseBox call did a recalc
	// of the layout
	pApp->m_pActivePile = GetPile(pApp->m_nActiveSequNum);
	wxASSERT(pApp->m_pActivePile != NULL);

	// scroll into view, just in case (but shouldn't be needed) BEW 16Jun09
	// moved this to be after the recalc of the layout, pointless to do it before
	pApp->GetMainFrame()->canvas->ScrollIntoView(pApp->m_nActiveSequNum);

    // get a new pointer to the pile at the start of the selection, since the
	// recalc also clobbered the old one -- this selection could possibly be removed from
	// the active location if the original landing place was in a retranslation, if it
	// wasn't in a retranslation, it should be starting from the active location
	CPile* pSelPile = GetPile(nSaveSelSequNum);
	wxASSERT(pSelPile != NULL);

	Invalidate(); // get the view window redrawn, and the phrase box
	GetLayout()->PlaceBox();

	// restore focus to the targetBox
	if (pApp->m_pTargetBox != NULL)
	{
		if (pApp->m_pTargetBox->IsShown())
		{

            pApp->m_pTargetBox->SetFocusAndSetSelectionAtLanding();// whm 13Aug2018 modified
        }
	}

	// recreate the selection to be in top line; we suppress this in places where another
	// external function called after this one returns will do this job for us
	if (!bSuppressSelectionExtension)
	{
		CCell* pAnchorCell = pSelPile->GetCell(0);
		if (nCount > 0 && pAnchorCell != NULL)
		{
			pApp->m_pAnchor = pAnchorCell;
			CCellList* pSelection = &pApp->m_selection;
			wxASSERT(pSelection->IsEmpty());
			pApp->m_selectionLine = 0;
			wxClientDC aDC(pApp->GetMainFrame()->canvas); // make a device context

			// then do the new selection, start with the anchor cell

			aDC.SetBackgroundMode(pApp->m_backgroundMode);
			aDC.SetTextBackground(wxColour(235,245,40)); // yellow
			pAnchorCell->DrawCell(&aDC, pApp->m_pLayout->GetSrcColor());
			pApp->m_bSelectByArrowKey = FALSE;
			pAnchorCell->SetSelected(TRUE);

			// preserve record of the selection
			pSelection->Append(pAnchorCell);

			// extend the selection to the right, if more than one pile is involved
			if (nCount > 1)
			{
				// extend the selection (shouldn't be called when glossing is ON
				// because we inhibit matching across piles in that circumstance)
				ExtendSelectionForFind(pAnchorCell,nCount);
			}
		}
	}
}

// PlacePhraseBox() selector values: used for inhibiting one or both of two blocks of code.
// The first block should be done only when the user has clicked elsewhere after being in a
// former location, since the first block saves the adaptation text left in the former
// phrase box's location. The second block removes the adaptation text from the KB when the
// focus has moved to the new location clicked. It is not appropriate to do this code when
// returning from being in a dialog such as Choose Translation, since the adaptation text
// will already have been removed before the dialog was entered, so selector = 1 inhibits
// this block. The other two possible situations, a normal click (selector = 0), or the
// target box was previously not at any location - as when the user has just opened a saved
// document file, it is essential to remove the adaption text from the phrase box's
// location, so that when the user hits RETURN to move on, the store will be re-done and
// the ASSERT in start of StoreText function will not trip; so a selector value of 2 is
// used for this case. That is,
// selector = 0 enables both blocks to be done,
// selector = 1 disables both blocks, and
// selector = 2 disables the first block but enables the second block.
// BEW added 27Jun05, For version 3, free translation support requires we can enable
// the first block and disable the second block, so for this combination we will use a
// selector value of 3. For version 2.0, which supports glossing, the function will test
// the gbIsGlossing flag in a number of places; these changes will increase the complexity
// of an already complex function, but it is better than having a separate glossing version
// which would bloat the app's size
// Ammended, July 2003, for auto-capitalization support
// BEW 22Feb10 no changes needed for support of doc version 5
// BEW 22Jun10, no changes needed for support of kbVersion 2
// BEW 21Jul14 for ZWSP support: no changes were necessary
// whm NOTE: As of 26Sep2021, this PlacePhraseBox() function is called from:
//  CAdapt_ItCanvas::OnLButtonDown() 6x
//  CAdapt_ItDoc::PutPhraseBoxAtDocEnd(), OnNewDocument() 2x, OnOpenDocument()
//  CAdapt_ItView::OnButtonChooseTranslation(), DoReplace() 4x, FindNextHasLanded(), Jump(),
//    OnUseConsistentChanges(), OnUseSilConverter(), OnImportEditedSourceText(),
//  CollabUtilities.cpp : SetupLayoutAndView(), OnenDocWithMerger()
//  CReplaceDlg::OnCnacel()
//  CFreeTrans::SwitchScreenFreeTranslationMode(), OnAdvanceButton(), OnPrevButton() 3x, OnNextButton()
//  CJoinDialog::OnBnClickedJoinNow()
//  CMainFrame::OnIdle() 2x
//  CPunctCorrespPagePrefs::OnOK()
void CAdapt_ItView::PlacePhraseBox(CCell* pCell, int selector)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	// refactored 2Apr09
	CLayout* pLayout = GetLayout();
	//#if defined (_DEBUG)
	//	wxLogDebug(_T("\n\n*** Entering PlacePhraseBox()  , selector = %d"), selector);
	//#endif
#if defined (FREETRMODE)
	wxLogDebug(_T("%s:%s():line %d, m_bFreeTranslationMode = %s"), __FILE__, __FUNCTION__, __LINE__,
		(&wxGetApp())->m_bFreeTranslationMode ? _T("TRUE") : _T("FALSE"));
#endif
	//	wxLogDebug(_T("%s:%s():line %d, *************Phrasebox contents %s"), __FILE__, __FUNCTION__, __LINE__,
	//		pApp->m_pTargetBox->GetTextCtrl()->GetValue());


#if defined (_DEBUG) //&& defined (TRACK_PHRBOX_CHOOSETRANS_BOOL)
	wxLogDebug(_T("View, PlacePhraseBox() line  %d - Starting, pApp->m_bTypedNewAdaptationInChooseTranslation = %d"), __LINE__,
		(int)pApp->m_bTypedNewAdaptationInChooseTranslation);
#endif
	pApp->m_bLandingBox = FALSE; // first half of this function is for "Leaving" the current location,
								 // we set it TRUE later below when dealing with the "Landing" location								 
//	wxLogDebug(_T("PlacePhraseBox at start:  m_nCacheLeavingLocation = %d"),
//		pApp->m_nCacheLeavingLocation);


	pApp->m_bDisablePlaceholderInsertionButtons = FALSE;

	if (pCell == NULL)
	{
		pLayout->m_docEditOperationType = relocate_box_op;
		pApp->m_bTypedNewAdaptationInChooseTranslation = FALSE; // re-initialize
		return;
	}
	// BEW 8Aug23 initialise m_bAbandonable to FALSE
	pApp->m_pTargetBox->m_bAbandonable = FALSE;

#if defined (_DEBUG) && defined (_ABANDONABLE)
	pApp->LogDropdownState(_T("PlacePhraseBox()"), _T("Adapt_ItView.cpp"), __LINE__);
#endif
	CPile* pClickedPile = pCell->GetPile();
	wxASSERT(pClickedPile);

#if defined(_DEBUG) && defined(FLAGS)
	{
		CAdapt_ItApp* pApp = &wxGetApp();
		CSourcePhrase* pSrcPhrase = pClickedPile->GetSrcPhrase();
		wxLogDebug(_T("View::PlacePhraseBox(), line %d, sn=%d, m_key= [%s], m_srcPhrase= [%s], m_bAbandonable %d, m_bRetainBoxContents %d, m_bUserTypedSomething %d, m_bBoxTextByCopyOnly %d, m_bAutoInsert %d"),
			__LINE__, pSrcPhrase->m_nSequNumber, pSrcPhrase->m_key.c_str(), pSrcPhrase->m_srcPhrase.c_str(), (int)pApp->m_pTargetBox->m_bAbandonable, (int)pApp->m_pTargetBox->m_bRetainBoxContents,
			(int)pApp->m_bUserTypedSomething, (int)pApp->m_pTargetBox->m_bBoxTextByCopyOnly, (int)pApp->m_bAutoInsert);
		if (pSrcPhrase->m_nSequNumber >= 1)
		{
			int halt_here = 1; wxUnusedVar(halt_here); // avoid compiler warning variable initialized but not referenced
		}
	}
#endif
	//#ifdef _DEBUG
	//	wxLogDebug(_T("PlacePhraseBox at %d ,  Active Sequ Num  %d"),1,pApp->m_nActiveSequNum);
	//#endif
#if defined (_DEBUG) && defined (TRACK_PHRBOX_CHOOSETRANS_BOOL)
	wxLogDebug(_T("View, PlacePhraseBox() line  %d , pApp->m_bTypedNewAdaptationInChooseTranslation = %d"), 2984,
		(int)pApp->m_bTypedNewAdaptationInChooseTranslation);
#endif

	// if there is no active pile defined, construct one at the clicked location,
	// or at whatever cell pointer was passed in - eg. when having just opened a document,
	// the active sequence number can be -1
	int sequNum = -1; //init
	if (pApp->m_pActivePile == NULL)
	{
		sequNum = pCell->GetPile()->GetSrcPhrase()->m_nSequNumber;
		pApp->m_pActivePile = GetPile(sequNum);
		pApp->m_nActiveSequNum = sequNum; // BEW added 14Mar13, now the GetPile() call five
										  // lines down won't give a crash!
	}
	else
	{
		sequNum = pCell->GetPile()->GetSrcPhrase()->m_nSequNumber;
	}


	// BEW 28Jun18, use cached m_nActiveSequNumber value at pApp->m_nCacheLeavingLocation
	// in order to be sure to get the correct pile at the earlier phrasebox location
	CSourcePhrase* pOldActiveSrcPhrase = NULL;
	CPile* pOldActivePile = NULL;
#if defined (_DEBUG)
	wxLogDebug(_T("PlacePhraseBox line = %d at start, LEAVING; What's value of: pApp->m_nCacheLeavingLocation? It's= %d for pOldActiveSrcPhrase"),
		__LINE__, pApp->m_nCacheLeavingLocation);
	//if (pApp->m_nCacheLeavingLocation >= 117)
	//{
	//	int halt_here = 1; wxUnusedVar(halt_here); // avoid compiler warning variable initialized but not referenced
	//}
#endif
	if (pApp->m_nCacheLeavingLocation != wxNOT_FOUND)
	{
		// GetPile returns NULL if m_nCacheLeavingLocation is -1
		pOldActivePile = GetPile(pApp->m_nCacheLeavingLocation);
	}
	if (pOldActivePile != NULL)
	{
		pOldActiveSrcPhrase = pOldActivePile->GetSrcPhrase();
		wxASSERT(pOldActiveSrcPhrase);
	}

	if (pOldActivePile != NULL)
	{
		wxLogDebug(_T("PlacePhraseBox line = %d at start; Leaving pOldActivePile:  sn = %d, m_key= [%s], m_bAbandonable = %d , m_adaption= [%s], m_targetStr= [%s]"),
			__LINE__, pOldActiveSrcPhrase->m_nSequNumber, pOldActiveSrcPhrase->m_key.c_str(), (int)pApp->m_pTargetBox->m_bAbandonable,
			pOldActiveSrcPhrase->m_adaption.c_str(), pOldActiveSrcPhrase->m_targetStr.c_str());
	}
	/* ?? somehow I seem to have succeeded in not requiring a click in the box to make the tgt text m_targetStr "stick" ??
	// BEW 22Nov23, clicking to relocate the phrasebox at a different location will lose a typed
	// meaning in the box at the location being left (pSrcPhrase) if pSrcPhrase does not get its
	// m_targetStr member set. m_srcPhrase is still empty, m_adaption might be too.
	// To avoid loosing tgt value, a nuisance work-around was to click in the box before clicking to
	// relocate the box. 
	// What I want to do is to not require a phrasebox click before clicking elsewhere to move the box somewhere else.
	*/
#if defined (_DEBUG) //&& defined (TRACK_PHRBOX_CHOOSETRANS_BOOL)
	wxLogDebug(_T("View, PlacePhraseBox() line  %d , pApp->m_bTypedNewAdaptationInChooseTranslation = %d"), __LINE__,
		(int)pApp->m_bTypedNewAdaptationInChooseTranslation);
#endif
	wxASSERT(pCell);

	wxLogDebug(_T("PlacePhraseBox() line %d, **Phrasebox contents= [%s]"), __LINE__,
		pApp->m_pTargetBox->GetTextCtrl()->GetValue().c_str());

	if (pCell->GetCellIndex() != 1) // index == 1 is the line of cells
									// which has the phrase box
	{
		pApp->m_pTargetBox->m_SaveTargetPhrase = pApp->m_targetPhrase; // an adaptation, or a gloss, depending on mode
		pLayout->m_docEditOperationType = relocate_box_op;
		pApp->m_bTypedNewAdaptationInChooseTranslation = FALSE; // re-initialize
#if defined (_DEBUG) //&& defined (TRACK_PHRBOX_CHOOSETRANS_BOOL)
		wxLogDebug(_T("View, PlacePhraseBox() line  %d , pApp->m_bTypedNewAdaptationInChooseTranslation = %d"), __LINE__,
			(int)pApp->m_bTypedNewAdaptationInChooseTranslation);
#endif
		return;
	}
	CAdapt_ItDoc* pDoc = GetDocument();
	pDoc->Modify(TRUE);

	// if auto capitalization is on, determine the source text's case propertiess
	bool bNoError = TRUE;
	if (gbAutoCaps)
	{
		if (pApp->m_pActivePile == NULL)
		{
			// active location is undefined because we are at the end of the document
			bNoError = FALSE;
		}
		else
		{
			bNoError = pApp->GetDocument()->SetCaseParameters(pApp->m_pActivePile->GetSrcPhrase()->m_key);

			CSourcePhrase* pSP = pApp->m_pActivePile->GetSrcPhrase(); // BEW 19May18 added
			if (gbIsGlossing) { pApp->m_pTargetBox->m_SaveTargetPhrase = pSP->m_gloss; }
			else { pApp->m_pTargetBox->m_SaveTargetPhrase = pSP->m_adaption; }
		}
	}
#if defined (_DEBUG) && defined (TRACK_PHRBOX_CHOOSETRANS_BOOL)
	wxLogDebug(_T("View, PlacePhraseBox() line  %d , pApp->m_bTypedNewAdaptationInChooseTranslation = %d"), 3056,
		(int)pApp->m_bTypedNewAdaptationInChooseTranslation);
#endif
	// Also inhibit if it is a "<Not In KB>" location where there is something in the
	// phrase box but the m_bSaveToKB flag is still off (FALSE) - but only provided we are
	// in adapting mode
	if (!(pApp->m_nActiveSequNum == -1)) // can't do the following block if there is no
										 // active pile currently in existence
	{
#if defined (_DEBUG) && defined (_ABANDONABLE)
		wxLogDebug(_T("View, PlacePhraseBox() line  %d  'Leaving', pApp->m_SaveTargetPhrase = %s"), 3066,
			pApp->m_pTargetBox->m_SaveTargetPhrase.c_str());
#endif

		if (!gbIsGlossing && pApp->m_pActivePile &&
			!pApp->m_pActivePile->GetSrcPhrase()->m_bHasKBEntry &&
			pApp->m_pActivePile->GetSrcPhrase()->m_bNotInKB &&
			!pApp->m_pActivePile->GetSrcPhrase()->m_bRetranslation)
		{
			// in case the user edited out the <Not In KB> entry from the KB editor, we
			// need to put it back so that the setting is preserved (the "right" way to
			// change the setting is to use the toolbar checkbox)

			// if the user edited out the <Not In KB> entry from the KB editor, we need to
			// put it back so that the setting is preserved (the "right" way to change the
			// setting is to use the toolbar checkbox - this applies when adapting, not
			// glossing)
			pApp->m_pKB->Fix_NotInKB_WronglyEditedOut(pApp->m_pActivePile);
#if defined (_DEBUG) && defined (TRACK_PHRBOX_CHOOSETRANS_BOOL)
			wxLogDebug(_T("View, PlacePhraseBox() line  %d , pApp->m_bTypedNewAdaptationInChooseTranslation = %d"), 3095,
				(int)pApp->m_bTypedNewAdaptationInChooseTranslation);
#endif		
		}
		else // a normal situation, such as a click on a new active location
		{
			// inhibit the save, if we are here not from a click to a new location, eg. as
			// when having exited from the Choose Translation dialog having forced it to
			// show - because when the latter happens, this would be the second time this
			// function is entered for this phrase box location, and so we don't need to do
			// a save. Selector values are used to support these inhibitions on doing the
			// code below.
			// BEW changed 27Jun05, for free translation support - added test for selector
			// == 3 selector values 0 and 3 are the only ones which permit saving the old
			// location's text to the KB
#ifdef _DEBUG
	wxLogDebug(_T("PlacePhraseBox at %d ,  Active Sequ Num  %d"),__LINE__,pApp->m_nActiveSequNum);
#endif
#if defined (_DEBUG) && defined (TRACK_PHRBOX_CHOOSETRANS_BOOL)
			wxLogDebug(_T("View, PlacePhraseBox() line  %d , pApp->m_bTypedNewAdaptationInChooseTranslation = %d"), 3114,
				(int)pApp->m_bTypedNewAdaptationInChooseTranslation);
#endif			
#if defined(_DEBUG) && defined(FLAGS)
			{
				CAdapt_ItApp* pApp = &wxGetApp();
				CSourcePhrase* pSrcPhrase = pApp->m_pActivePile->GetSrcPhrase();
				wxLogDebug(_T("\nPlacePhraseBox(), line %d, sn=%d, m_key= [%s], m_targetStr= [%s], m_bAbandonable %d, m_bRetainBoxContents %d, m_bUserTypedSomething %d, m_bBoxTextByCopyOnly %d, m_bAutoInsert %d"),
					 __LINE__, pSrcPhrase->m_nSequNumber, pSrcPhrase->m_key.c_str(), pSrcPhrase->m_targetStr.c_str(), (int)pApp->m_pTargetBox->m_bAbandonable, (int)pApp->m_pTargetBox->m_bRetainBoxContents,
					(int)pApp->m_bUserTypedSomething, (int)pApp->m_pTargetBox->m_bBoxTextByCopyOnly, (int)pApp->m_bAutoInsert);
			}
#endif
			if (selector == 0 || selector == 3)
			{
				// mark invalid the strip preceding the active strip, so as to allow
				// migration upwards of a small pile at start of active strip if the active
				// location moves further away and so the old active location's pile
				// becomes less wide and able to fit at the end of the previous strip - the
				// only way to get it there is to make that strip m_bValid = FALSE (if
				// there was no active location and we created one at the destination
				// click's pile in the code above, doing this creates no problem)
				if (pApp->m_nActiveSequNum != -1)
				{
					CPile* pile = GetPile(pApp->m_nActiveSequNum);
					wxASSERT(pile != NULL);
					int stripIndex = pile->GetStripIndex();
					if (stripIndex > 0)
					{
						stripIndex--;
						//pLayout->GetInvalidStripArray()->Add(stripIndex);
						// BEW changed 20Jan11, we want only unique indices in the array
						AddUniqueInt(pLayout->GetInvalidStripArray(), stripIndex);
					}
				}
#if defined (_DEBUG) && defined (TRACK_PHRBOX_CHOOSETRANS_BOOL)
				wxLogDebug(_T("View, PlacePhraseBox() line  %d , pApp->m_bTypedNewAdaptationInChooseTranslation = %d"), 3140,
					(int)pApp->m_bTypedNewAdaptationInChooseTranslation);
#endif
				// user has not typed anything at the new location yet <<-- wrong (BEW 30Apr18), this is the 'leaving'
				// first part of PlacePhraseBox() and so there may have been user typing (or a click in box requiring
				// we keep and store the current target text) done, so we need to get this app boolean member set TRUE
				// or FALSE more cleverly - eg. OnPhraseBoxChanged (a PlaceBox.cpp member) will have the flag
				// TRUE if the user typed something, so we need to test it here and get m_adaption from whichever
				// is the appropriate place...
				// pApp->m_bUserTypedSomething = FALSE;  <<-- BEW removed, 30Apr18, and added the test further below

				// make sure pApp->m_targetPhrase doesn't have any final spaces; at this point, m_adaption will be
				// set by the contents of m_targetPhrase (and m_pTargetBox should have the same contents)
				pApp->m_pTargetBox->RemoveFinalSpaces(pApp->m_pTargetBox, &pApp->m_targetPhrase);

				//wxLogDebug(_T("%s:%s():line %d, ****Phrasebox contents %s"), __FILE__, __FUNCTION__, __LINE__,
				//	pApp->m_pTargetBox->GetTextCtrl()->GetValue().c_str());

				// BEW 30Apr18  added next test to fix a bug where 'landing' the phrasebox can get a wrong m_adaption
				// when box moves off - i.e. leaves, because a non-empty list copies top entry to the box before 
				// the store gets done, even though user did not alter the box nor a click in the box happened.
				// In vertical edit mode, we want this block to be done only for adaptationStep or glossingStep -
				// we want the adaptation to 'stick' even if he does it by clicking on the CSourcePhrases rather
				// than advancing using Enter or Tab keypress.
				// BEW 2Feb19, added protection here because Mike got a crash, turned out pOldActivePile was
				// NULL, so we have to test for that and skip code which assumed it would be a valid pointer
				if (pOldActivePile != NULL)
				{
					if ((!gbVerticalEditInProgress && !pApp->m_bUserTypedSomething))
					{
						// BEW 1Jun19, now that m_bAbandonable is forced to always be FALSE, we want content
						// in the phrase box to 'stick' if the user clicks at some other location without
						// clicking in the box. In this scenario m_bHasKBEntry should still be FALSE, because
						// KB storage has not been done. If it is TRUE, then this block should be skipped.
						// When control gets to here, m_adaption and m_targetStr should also be empty if
						// the box is at a hole; if not at a hole, this block should be skipped likewise.
						CSourcePhrase* pSrcPhrase = pOldActivePile->GetSrcPhrase();
						if (!  // if none of these apply, then keep the box contents
							(pApp->m_pTargetBox->m_bAbandonable ||
								pApp->m_pTargetBox->GetTextCtrl()->GetValue().IsEmpty() ||
								pSrcPhrase->m_bHasKBEntry)
							)
						{
							wxString adaption = pApp->m_pTargetBox->GetTextCtrl()->GetValue();

							pApp->m_pTargetBox->m_SaveTargetPhrase = adaption;
							pApp->m_targetPhrase = adaption;
							pApp->m_pTargetBox->RemoveFinalSpaces(pApp->m_pTargetBox, &pApp->m_targetPhrase);
							wxString tgtStr = adaption;
							pApp->GetView()->RemovePunctuation(GetDocument(), &adaption, from_target_text);
							pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(tgtStr); // should make it 'modified'
									// and a block further below will do the store, and the content will 'stick'
						}
					}
					else
						// BEW 1Jun19 split the test, to preserve this block for vertical editing
						if (gbVerticalEditInProgress && (gEditStep == 2 || gEditStep == 3))
						{
							wxLogDebug(_T("%s:%s():line %d, *************Phrasebox contents %s , m_targetPhrase = %s , m_bUserTypedSomething = %d"),
								__FILE__, __FUNCTION__, __LINE__,
								pApp->m_pTargetBox->GetTextCtrl()->GetValue(), pApp->m_targetPhrase.c_str(),
								pApp->m_bUserTypedSomething);


							// User did not type something, AND no user click in the box
							// In this circumstance, the earlier value of m_adaption should be restored. 
							// pApp->m_pActivePile->GetSrcPhrase() still has the old values for src and tgt retained, 
							// so restore the box from its m_adaption member, and likewise m_targetPhrase  and 
							// re-do the call of RemoveFinalSpaces() for safety's sake.
							//pApp->m_pTargetBox->m_SaveTargetPhrase = pApp->m_pActivePile->GetSrcPhrase()->m_adaption;  // BEW added 19May18
							pApp->m_pTargetBox->m_SaveTargetPhrase = pOldActivePile->GetSrcPhrase()->m_adaption;  // BEW changed 6Jul18
	//#if defined (_DEBUG) && defined (_ABANDONABLE)
							pApp->LogDropdownState(_T("In function %s, line = %d , leaving, about to use  m_SaveTargetText, selector = 0"),
								__FUNCTION__, __LINE__);
							wxLogDebug(_T("PlacePhraseBox() leaving, m_SaveTargetText= %s  at line %d"),
								pApp->m_pTargetBox->m_SaveTargetPhrase.c_str(), __LINE__);
							//#endif
							pApp->m_pTargetBox->m_bAbandonable = FALSE;
							wxString adaption = pApp->m_pTargetBox->m_SaveTargetPhrase;
							pApp->m_targetPhrase = adaption;
							pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(adaption);

							pApp->m_pTargetBox->RemoveFinalSpaces(pApp->m_pTargetBox, &pApp->m_targetPhrase);

							wxLogDebug(_T("%s:%s():line %d, *************Phrasebox contents %s"), __FILE__, __FUNCTION__, __LINE__,
								pApp->m_pTargetBox->GetTextCtrl()->GetValue());
						}
				} // end test for a valid pOldActivePile pointer

#if defined (_DEBUG) && defined (TRACK_PHRBOX_CHOOSETRANS_BOOL)
				wxLogDebug(_T("View, PlacePhraseBox() line  %d , pApp->m_bTypedNewAdaptationInChooseTranslation = %d"), 3206,
					(int)pApp->m_bTypedNewAdaptationInChooseTranslation);
#endif


				if (pOldActivePile != NULL)
				{
#if defined(_DEBUG) && defined(FLAGS)
					{
						CAdapt_ItApp* pApp = &wxGetApp();
						CSourcePhrase* pSrcPhrase = pOldActivePile->GetSrcPhrase();
						wxLogDebug(_T("\n%s::%s(), line %d, sn=%d, m_key= %s, m_bAbandonable %d, m_bRetainBoxContents %d, m_bUserTypedSomething %d, m_bBoxTextByCopyOnly %d, m_bAutoInsert %d"),
							__FILE__, __FUNCTION__, __LINE__, pSrcPhrase->m_nSequNumber, pSrcPhrase->m_key.c_str(), (int)pApp->m_pTargetBox->m_bAbandonable, (int)pApp->m_pTargetBox->m_bRetainBoxContents,
							(int)pApp->m_bUserTypedSomething, (int)pApp->m_pTargetBox->m_bBoxTextByCopyOnly, (int)pApp->m_bAutoInsert);
					}
#endif					
					pOldActiveSrcPhrase = pOldActivePile->GetSrcPhrase();
					wxLogDebug(_T("PlacePhraseBox at %d, Leaving:  m_key = %s , m_bAbandonable = %d"), __LINE__,
						pOldActiveSrcPhrase->m_key.c_str(), (int)pApp->m_pTargetBox->m_bAbandonable);
				}
				/* #if defined (_DEBUG)
								{
									if (pOldActivePile != NULL)
									{
										wxLogDebug(_T("%s::%s() line %d : pSrcPhrase m_srcPhrase = %s , sn = %d"), __FILE__, __FUNCTION__, __LINE__,
											pOldActivePile->GetSrcPhrase()->m_targetStr.c_str(), pOldActivePile->GetSrcPhrase()->m_nSequNumber);
									}
								}
				#endif */
				// any existing phraseBox text must be saved to the KB, unless its empty
				bool bOK = TRUE;
				if (!pApp->m_targetPhrase.IsEmpty())
				{
					if (pApp->m_pTargetBox->GetTextCtrl()->IsModified()) // MFC GetModify()  // whm 14Feb2018 added GetTextCtrl()->
					{
						if (pApp->m_pTargetBox->m_bAbandonable)
						{
							// if abandonable, then we want a placement click to throw away
							// the text in the box; which will make the store operation do
							// no store
							pApp->m_targetPhrase.Empty();
							pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(_T("")); // this doesn't generate
							// a wxEVT_COMMAND_TEXT_UPDATED event, we don't need
							// an OnChar() call for the location we are leaving
						}
						else
						{
							// its not empty, not abandonable (text), and has been
							// modified, so do nothing - the storage operation below will
							// then store the text
							; // formerly, relic code to display the empty adapt dialog was here
						}
					}
#if defined (_DEBUG) && defined (TRACK_PHRBOX_CHOOSETRANS_BOOL)
					wxLogDebug(_T("View, PlacePhraseBox() line  %d , pApp->m_bTypedNewAdaptationInChooseTranslation = %d"), 3243,
						(int)pApp->m_bTypedNewAdaptationInChooseTranslation);
#endif
					//					wxLogDebug(_T("PlacePhraseBox at line %d, Leaving:  m_key = %s , m_bAbandonable = %d"), __LINE__,
					//						pApp->m_pActivePile->GetSrcPhrase()->m_key.c_str(), (int)pApp->m_pTargetBox->m_bAbandonable);

					//					wxLogDebug(_T("%s:%s():line %d, *************Phrasebox contents %s"), __FILE__, __FUNCTION__, __LINE__,
					//						pApp->m_pTargetBox->GetTextCtrl()->GetValue());

										// it has to be saved to the relevant KB now
					if (!pApp->m_pTargetBox->m_bAbandonable || !pApp->m_pTargetBox->m_bBoxTextByCopyOnly)
					{
						bOK = pApp->m_pTargetBox->DoStore_ForPlacePhraseBox(pApp, pApp->m_targetPhrase);
#if defined(_DEBUG) && defined(FLAGS)
						if (pOldActivePile != NULL)
						{
							{
								CAdapt_ItApp* pApp = &wxGetApp();
								CSourcePhrase* pSrcPhrase = pApp->m_pActivePile->GetSrcPhrase();
								wxLogDebug(_T("\n%s::%s(), line %d, sn=%d, m_key= %s, m_bAbandonable %d, m_bRetainBoxContents %d, m_bUserTypedSomething %d, m_bBoxTextByCopyOnly %d, m_bAutoInsert %d"),
									__FILE__, __FUNCTION__, __LINE__, pSrcPhrase->m_nSequNumber, pSrcPhrase->m_key.c_str(), (int)pApp->m_pTargetBox->m_bAbandonable, (int)pApp->m_pTargetBox->m_bRetainBoxContents,
									(int)pApp->m_bUserTypedSomething, (int)pApp->m_pTargetBox->m_bBoxTextByCopyOnly, (int)pApp->m_bAutoInsert);
							}
						}
#endif
					}
#if defined (_DEBUG) && defined (TRACK_PHRBOX_CHOOSETRANS_BOOL)
					wxLogDebug(_T("View, PlacePhraseBox() line  %d - after DoStore_ForPlacePhraseBox(), pApp->m_bTypedNewAdaptationInChooseTranslation = %d"), 3255, (int)pApp->m_bTypedNewAdaptationInChooseTranslation);
#endif
					if (pOldActivePile != NULL)
					{
#ifdef _DEBUG
						//						wxLogDebug(_T("PlacePhraseBox at line %d ,  Active Sequ Num  %d"),
						//							__LINE__, pApp->m_nActiveSequNum);
#endif
//						wxLogDebug(_T("PlacePhraseBox at line %d after DoStore...(), Leaving:  m_key = %s , m_bAbandonable = %d  sn = %d m_targetStr = %s"),
//							__LINE__, pOldActiveSrcPhrase->m_key.c_str(), (int)pApp->m_pTargetBox->m_bAbandonable,
//							pOldActiveSrcPhrase->m_nSequNumber, pOldActiveSrcPhrase->m_adaption.c_str(),
//							pOldActiveSrcPhrase->m_targetStr.c_str());

						// BEW 26Apr19, m_targetStr would sometimes inexplicably be empty
						// at this point, even though m_adaption was non empty; so I'm
						// putting this code into the release build, doing a check for
						// that circumstance, and if m_targetStr is wrongly empty, then
						// setting it to what it should be
						if (pOldActivePile == pApp->m_pActivePile)
						{
							// Check and fix if m_targetStr is empty when m_adaption
							// isn't, then we need a hack to regenerate m_targetStr
							CSourcePhrase* pSP = pApp->m_pActivePile->GetSrcPhrase();
							wxString strAdaption = pSP->m_adaption;
							wxString strTargetStr = pSP->m_targetStr;
							if (!strAdaption.IsEmpty())
							{
								// Now test for empty strTargetStr - if it is, then
								// we gotta fix it
								if (strTargetStr.IsEmpty())
								{
									// The fix-it hack is needed

//wxLogDebug(_T("%s, %s() line %d  ** DETECTED TARGET TEXT WRONGLY EMPTIED ** at  sn = %d , m_key = %s , m_adaption = %s , m_targetStr = %s"),
//		__FILE__, __FUNCTION__, __LINE__, pSP->m_nSequNumber, pSP->m_key.c_str(),
//		 pSP->m_adaption.c_str(), pSP->m_targetStr.c_str());
#if defined (_DEBUG)
									wxBell();
#endif
									// Start by copying m_adaption to m_targetStr,
									// and then all that remains is to restore any
									// punctuation to m_targetStr
									strTargetStr = strAdaption;
#if defined (_DEBUG)
									{
										wxLogDebug(_T("%s::%s() line %d : pSrcPhrase m_srcPhrase = %s , sn = %d"), __FILE__, __FUNCTION__, __LINE__,
											pOldActivePile->GetSrcPhrase()->m_targetStr.c_str(), pOldActivePile->GetSrcPhrase()->m_nSequNumber);
									}
#endif

									// Now deal with the punctuation restoration if needed
									pApp->m_bTypedNewAdaptationInChooseTranslation = FALSE;
									pApp->m_nPlacePunctDlgCallNumber = 0; // this allows
										// the next call to do something, otherwise it does
										// nothing useful
									MakeTargetStringIncludingPunctuation(pSP, strTargetStr);
#if defined (_DEBUG)
									{
										wxLogDebug(_T("%s::%s() line %d : pSrcPhrase m_srcPhrase = %s , sn = %d"), __FILE__, __FUNCTION__, __LINE__,
											pOldActivePile->GetSrcPhrase()->m_targetStr.c_str(), pOldActivePile->GetSrcPhrase()->m_nSequNumber);
									}
#endif
								}
							}

						}
					} // end of TRUE block for test: if (pOldActivePile != NULL)

#if defined(_DEBUG) && defined(FLAGS)
					{
						CAdapt_ItApp* pApp = &wxGetApp();
						// whm 25Jul2023 added test to protect against attempting to access/dereference pOldActivePile when it is NULL
						if (pOldActivePile != NULL)
						{
							CSourcePhrase* pSrcPhrase = pOldActivePile->GetSrcPhrase();
							wxLogDebug(_T("\n%s::%s(), line %d, sn=%d, m_key= %s, m_bAbandonable %d, m_bRetainBoxContents %d, m_bUserTypedSomething %d, m_bBoxTextByCopyOnly %d, m_bAutoInsert %d"),
								__FILE__, __FUNCTION__, __LINE__, pSrcPhrase->m_nSequNumber, pSrcPhrase->m_key.c_str(), (int)pApp->m_pTargetBox->m_bAbandonable, (int)pApp->m_pTargetBox->m_bRetainBoxContents,
								(int)pApp->m_bUserTypedSomething, (int)pApp->m_pTargetBox->m_bBoxTextByCopyOnly, (int)pApp->m_bAutoInsert);
						}
					}
#endif
				} // end block for test !pApp->m_targetPhrase.IsEmpty()
				else
				{
					// pApp->m_targetPhrase is empty, so let StoreText handle
					// what needs to happen.
					bOK = pApp->m_pTargetBox->DoStore_ForPlacePhraseBox(pApp, pApp->m_targetPhrase);
#if defined (_DEBUG) && defined (_ABANDONABLE)
					wxLogDebug(_T("View, PlacePhraseBox() line  %d - after DoStore_ForPlacePhraseBox(), pApp->m_bTypedNewAdaptationInChooseTranslation = %d"), 3288, (int)pApp->m_bTypedNewAdaptationInChooseTranslation);
#endif
					// check for a failure, abandon the function if the store failed
					if (!bOK)
					{
						// We must restore the box's selection to what it was
						// earlier before returning.
						// whm 13Aug2018 Note: The SetFocus() call here precedes the SetSelection, so
						// it should work OK on Linux/Mac.
						pApp->m_pTargetBox->GetTextCtrl()->SetFocus();
						// whm 3Aug2018 Note: The following SetSelection should not be suppressed.
						pApp->m_pTargetBox->GetTextCtrl()->SetSelection(pApp->m_nStartChar, pApp->m_nEndChar);
						pApp->m_pTargetBox->m_SaveTargetPhrase = pApp->m_targetPhrase;
						::wxBell(); // ring the bell to say that something wasn't right
						pLayout->m_docEditOperationType = relocate_box_op;
						//#ifdef _DEBUG
						//	wxLogDebug(_T("PlacePhraseBox at %d ,  Active Sequ Num  %d"),__LINE__,pApp->m_nActiveSequNum);
						//#endif
#if defined (_DEBUG) && defined (_ABANDONABLE)
						pApp->LogDropdownState(_T("PlacePhraseBox() leaving, after DoStore() in TRUE block, selector = 0 ELSE block for empty m_targetPhrase test, will now return to caller"), _T("Adapt_ItView.cpp"), __LINE__);
#endif
						pApp->m_bTypedNewAdaptationInChooseTranslation = FALSE; // re-initialize
#if defined (_DEBUG) && defined (TRACK_PHRBOX_CHOOSETRANS_BOOL)
						wxLogDebug(_T("View, PlacePhraseBox() line  %d - end of leaving code, pApp->m_bTypedNewAdaptationInChooseTranslation = %d"), 3311,
							(int)pApp->m_bTypedNewAdaptationInChooseTranslation);
#endif
						wxLogDebug(_T("%s:%s():line %d, *************Phrasebox contents %s , m_targetPhrase = %s"),
							__FILE__, __FUNCTION__, __LINE__,
							pApp->m_pTargetBox->GetTextCtrl()->GetValue(), pApp->m_targetPhrase.c_str());

						return;
					}

				} // end else block for test:  !pApp->m_targetPhrase.IsEmpty()
				  // i.e. block for empty m_targetPhrase
			} // end block for selector equals 0 or 3
		} // end normal block where saving of the text in the KB, for the
		  // old active loc'n, would be done

	}
#if defined (_DEBUG)
	{
		//		CPile* pActivePile = pApp->m_pActivePile;
		//		CSourcePhrase* pSP = pActivePile->GetSrcPhrase();
		//		wxLogDebug(_T("%s::%s() line %d : pSrcPhrase m_srcPhrase = %s , sn = %d"), __FILE__, __FUNCTION__, __LINE__,
		//			pSP->m_targetStr.c_str(), pSP->m_nSequNumber);
	}
#endif

	// before we deal with the clicked location, we want to recalculate the width of the
	// pile at the old active location, but suppress the fact that it is still the active
	// location when we do that calculation, and get the index of the changed strip put in
	// CLayout:m_invalidStripArray and mark the strip invalid as well (by setting m_bValid
	// to FALSE) - this is crucial for a correct recalc of the layout
	if (pOldActiveSrcPhrase != NULL)
	{
		// bNoActiveLocationCalculation is TRUE to suppress the wide gap calculation
		pDoc->ResetPartnerPileWidth(pOldActiveSrcPhrase, TRUE);
	}

	//#ifdef _DEBUG
	//	wxLogDebug(_T("PlacePhraseBox at %d ,  Active Sequ Num  %d"),6,pApp->m_nActiveSequNum);
	//#endif

		// BEW 5Sep22, honour the click? Yes, but not if it's within a retranslation in glossing mode,
		// because adding glosses there will get them thrown away if the user edits or removes
		// the the retranslation. That would consistute possibly serious data loss, if the
		// glossing KB is storing important info. So disallow adding glosses to a retranslation.
		// Code additions will be required to support this prohibition... probably in PlacePhraseBox()
		// and OnChar()
	CPile* pActivePile = pClickedPile;	// the clicked pile now has become the
		// new active location; but this is a problem if the new active pile is
		// within a retranslation and glossing mode is active. Investigate, and if
		// so, programmatically move the phasebox to the first safe location after
		// the pile which ends the retranslation (take care, if two retranslations
		// are in sequence with no safe piles between). If CSourcePhrase had a bool m_bIsRetranslation
		// it would be simple to determine if a given pile was within the span of a retranslation. So
		// because that member is missing from the document model (and I'm not wanting to change the
		// doc model, I think the approach should be to have a function, returning bool, which
		// calculates whether or not (in glossing mode) the glossing location lies within the span
		// of a retranslation - the boolean return value can then be used for an app boolean called
		// m_bGlossingAndWithinRetrans, which defaults to FALSE at every pile except those where a
		// pre-existing retranslation span is present. I'll add to the Retranslation class, a new
		// member, m_pRetransAnchorPile so that every Retranslation has a known anchor (ie. first)
		// pile. Then I can ensure that finding the retranslation span boundaries will apply to the
		// correct pile.
		// whm 3Oct2023 note on above comment. The m_pRetransAnchorPile was never used elsewhere
		// so it was removed this date.

	//wxASSERT(pActivePile != NULL);

	if (gbIsGlossing)
	{

		// TODO? --- might have to build a function to test if pClickedPile is inside a retranslation,
				// and use a new bool to suppress? so far, unneeded 4Oct22 BEW

	} // end of TRUE block for test: if (gbIsGlossing)

	pApp->m_bLandingBox = TRUE;

	// remove any existing selection
	RemoveSelection();
	//#ifdef _DEBUG
	//	wxLogDebug(_T("PlacePhraseBox at %d ,  Active Sequ Num  %d"),7,pApp->m_nActiveSequNum);
	//#endif
#if defined (_DEBUG) //&& defined (_ABANDONABLE)
	wxLogDebug(_T("View, PlacePhraseBox() line  %d  Committing to 'Landing' location, TextCtrl value= [%s] , pApp->m_SaveTargetPhrase = %s"), __LINE__,
		pApp->m_pTargetBox->GetTextCtrl()->GetValue().c_str(), pApp->m_pTargetBox->m_SaveTargetPhrase.c_str());
#endif

#if defined (_DEBUG) && defined (TRACK_PHRBOX_CHOOSETRANS_BOOL)
	wxLogDebug(_T("View, PlacePhraseBox() line  %d - started landing code, pApp->m_bTypedNewAdaptationInChooseTranslation = %d"), 3366,
		(int)pApp->m_bTypedNewAdaptationInChooseTranslation);
#endif
	pLayout->m_curBoxWidth = pApp->m_nMinPileWidth; // reset small for new location

// whm note 10Jan2018 to support quick selection of a translation equivalent.
// See similar code in GetNextEmptyPile().
// This PlacePhraseBox() ends up by calling the Layout's PlaceBox().
// Therefore we don't need to mess with calling CloseDropDown() or
// ClearDropDown() here in PlacePhraseBox().

// setup the layout and phrase box at the new location; in the refactored design this
// boils down to working out what the new active location's sequence number is, and
// then setting the active pile to be the correct one, getting an appropriate gap
// calculated for the "hole" the box is to occupy, tweaking the layout to conform to
// these changes (either by a RecalcLayout() call, or AdjustForUserEdits() call -
// either of which will make a new pile pointer, appropriately sized, for that
// location), updating the m_pActivePile pointer on the app class, and then calling the
// view class's Invalidate() function to get the tweaked layout drawn and the box made
// visible, appropriately sized, at the new active location

	pApp->m_pActivePile = pActivePile;
	CSourcePhrase* pSrcPhrase = pActivePile->GetSrcPhrase();
	wxASSERT(pSrcPhrase);
	pApp->m_nActiveSequNum = pSrcPhrase->m_nSequNumber;
	wxASSERT(pApp->m_nActiveSequNum >= 0);
#if defined(_DEBUG)
	if (pSrcPhrase->m_nSequNumber >= 1)
	{
		int halt_here = 1; wxUnusedVar(halt_here); // avoid compiler warning variable initialized but not referenced
	}
#endif

#if defined(_DEBUG) && defined(FLAGS)
	{
		//CAdapt_ItApp* pApp = &wxGetApp();
		wxLogDebug(_T("PlacePhraseBox(), LANDING, line %d, sn = %d, m_key = %s, m_bAbandonable %d, m_bRetainBoxContents %d, m_bUserTypedSomething %d, m_bBoxTextByCopyOnly %d, m_bAutoInsert %d"),
			__LINE__, pSrcPhrase->m_nSequNumber, pSrcPhrase->m_key.c_str(), (int)pApp->m_pTargetBox->m_bAbandonable, (int)pApp->m_pTargetBox->m_bRetainBoxContents,
			(int)pApp->m_bUserTypedSomething, (int)pApp->m_pTargetBox->m_bBoxTextByCopyOnly, (int)pApp->m_bAutoInsert);
	}
#endif

	// BEW 26Apr18, logging reveals that the earlier location's values were being left
	// in important places like the phrasebox contents and m_targetPhrase, so fix these
	// now from what's already in this location's pSrcPhrase
	// BEW 9Sep22, adjust here for support of refactored glossing
	if (gbIsGlossing)
	{
		pApp->m_targetPhrase = pSrcPhrase->m_gloss;
	}
	else
	{
		pApp->m_targetPhrase = pSrcPhrase->m_adaption;
	}
	pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(pApp->m_targetPhrase);

	// BEW 12Mar18 add a fix-it hack if CSourcePhrase at the clicked location has
	// no adaptation (or no gloss if glossing is on) but the KB entry does not have
	// a saved empty string in its relevant CTargetUnit. In such a circumstance, the
	// relevant CSourcePhrase has to have the appropriate flag set back to FALSE
	// BEW 12Mar18 The hack mentioned above to fix a CSourcePhrase which thinks it
	// has an empty string in the KB as an adaptation here when the KB knows it hasn't
	CKB* pKB = GetKB();
	int numWords = pSrcPhrase->m_nSrcWords;
	CTargetUnit* pTU = pKB->GetTargetUnit(numWords, pSrcPhrase->m_key);
	int refStrCount = 0; // whm 16Mar2018 added

#if defined (_DEBUG) && defined (_ABANDONABLE)
	pApp->LogDropdownState(_T("PlacePhraseBox() landing, after pKB->GetTargetUnit(), selector = 0, initializing for next bit..."), _T("Adapt_ItView.cpp"), __LINE__);
#endif
#if defined (_DEBUG) && defined (TRACK_PHRBOX_CHOOSETRANS_BOOL)
	wxLogDebug(_T("View, PlacePhraseBox() line  %d , pApp->m_bTypedNewAdaptationInChooseTranslation = %d"), 3417,
		(int)pApp->m_bTypedNewAdaptationInChooseTranslation);
#endif

	if (pTU != NULL)
	{
		if (pTU != NULL)
		{
			// whm 16Mar2018 modified the determination of bTargetUnitHasEmptyTranslation 
			// below. It can be TRUE only when there is just one ref string which is an 
			// empty string (i.e., <no adaptation>).
			refStrCount = pTU->CountNonDeletedRefStringInstances();
			bool bTargetUnitHasEmptyTranslation = pTU->HasEmptyTranslation(); // HasEmptyTranslation() returns TRUE if at least one ref string is empty (there may be multiple ref strings)
			if (bTargetUnitHasEmptyTranslation == TRUE && refStrCount > 1)
			{
				// There is are more than one ref strings, one of which is the empty string.
				bTargetUnitHasEmptyTranslation = FALSE;
			}
			if (gbIsGlossing)
			{
				if (pSrcPhrase->m_bHasGlossingKBEntry && !bTargetUnitHasEmptyTranslation && pSrcPhrase->m_gloss.IsEmpty())
				{
					// Correction of the flag value is needed
					pSrcPhrase->m_bHasGlossingKBEntry = FALSE;
				}
			}
			else
			{
				if (pSrcPhrase->m_bHasKBEntry && !bTargetUnitHasEmptyTranslation && pSrcPhrase->m_adaption.IsEmpty())
				{
					// Correction of the flag value is needed
					pSrcPhrase->m_bHasKBEntry = FALSE;

#if defined (_DEBUG) && defined (_ABANDONABLE)
					pApp->LogDropdownState(_T("PlacePhraseBox() landing, after counting non-deleted RefStrings, in correction block for m_adaption is empty"), _T("Adapt_ItView.cpp"), __LINE__);
#endif
				}
			}
		}
	} // end of the flag correction hack
	//  uncomment out, for a handy way to check the TextType values at various
	//  locations in the doc
	//	wxString sss;
	//	sss = sss.Format(_T("TextType value: %d\n"),pSrcPhrase->m_curTextType);
	//	wxMessageBox(sss);

	wxString str; // to hold whatever text we find at the new location
	str.Empty();

#if defined (_DEBUG)
	if (pSrcPhrase->m_nSequNumber >= 5)
	{
		int halt_here = 1; wxUnusedVar(halt_here); // avoid compiler warning variable initialized but not referenced
	}
#endif
	// the following three booleans are local flags which we set in code further below,
	// they will help in making decisions about which algorithm to follow in setting up
	// the new location correctly
	bool bHasNothing = FALSE;
	bool bNoValidText = FALSE;
	bool bCopySomethingFromSrc = FALSE; // init, but if menu choice has m_bCopySourceText TRUE,
										// it will be changed to TRUE below

#if defined (_DEBUG) && defined (TRACK_PHRBOX_CHOOSETRANS_BOOL)
	wxLogDebug(_T("View, PlacePhraseBox() line  %d , pApp->m_bTypedNewAdaptationInChooseTranslation = %d"), 3473,
		(int)pApp->m_bTypedNewAdaptationInChooseTranslation);
#endif

    // if we have just chosen an empty adaptation or gloss string in the Choose Translation
    // dialog, then ensure that's what appears in the box; m_bEmptyAdaptationChosen will be
    // TRUE if that is how we got here with an empty str
	if (pApp->m_pTargetBox->m_bEmptyAdaptationChosen)
	{
		// str is already empty, so nothing much to do
        pApp->m_pTargetBox->m_bEmptyAdaptationChosen = FALSE;

		// whm 24Jan2023 added back the SetPhraseBoxGapWidth() call, which assigns the 
		// returned value of CalcPhraseBoxGapWidth() to CPile::m_nWidth.
		// BEW reported this date that he was unable to select the source phrase at the active
		// location and that the problem was due to the CPile::m_nWidth member still had a -1
		// uninitializaion value.
		// TODO: Test without the following call to see if it's really needed here - for this
		// situation when pApp->m_pTargetBox->m_bEmptyAdaptationChosen is TRUE.
		pActivePile->SetPhraseBoxGapWidth(); // Assigns value of CalcPhraseBoxGapWidth() to m_nWidth

		goto a;
	}
#if defined (_DEBUG) && defined (TRACK_PHRBOX_CHOOSETRANS_BOOL)
	wxLogDebug(_T("View, PlacePhraseBox() line  %d , pApp->m_bTypedNewAdaptationInChooseTranslation = %d"), 3497,
		(int)pApp-> && defined (TRACK_PHRBOX_CHOOSETRANS_BOOL));
#endif

    // if we are attempting to place the box on a location where the entry is "<Not In
    // KB>", then we do so but adjust the flags to fit this situation; if not locating at a
    // "<Not In KB>" location, we must ensure that m_bSaveToKB is restored to TRUE from
    // version 1.4.0 onwards - but only provided we are not glossing. If there is existing
    // adaptation text at the new location, we leave it there (as per Susanna Imrie's
    // suggestion) even when it's a "not in kb" translation
    // BEW added to test 23Jul05 since m_bNotInKB is also true for retranslations and when
    // in free translation mode if we don't exclude retranslations then <Prev, Next> or
    // Advance buttons, if they land the box in a retranslation, the phrase box text that
    // get's set up is the old location's adaptation, not to mention a spurious save of
    // <Not In KB> to the KB as well.
	if (!gbIsGlossing && ((!pSrcPhrase->m_bHasKBEntry && pSrcPhrase->m_bNotInKB) ||
				pApp->m_pKB->IsItNotInKB(pSrcPhrase)) && !pSrcPhrase->m_bRetranslation)
	{
        // this ensures user has to explicitly type into the box and explicitly check the
        // checkbox if he wants to override the "not in kb" earlier setting at this
        // location
		pApp->m_bSaveToKB = FALSE;

        // this ensures the flags are appropriately set, so that an asterisk will show when
        // the placement is complete, if we arrived here due to IsItNotInKB() returning
        // TRUE & the other test FALSE
		pSrcPhrase->m_bHasKBEntry = FALSE;
		pSrcPhrase->m_bNotInKB = TRUE;
		str = pSrcPhrase->m_adaption;

		// whm 24Jan2023 added back the SetPhraseBoxGapWidth() call, which assigns the 
		// returned value of CalcPhraseBoxGapWidth() to CPile::m_nWidth.
		// BEW reported this date that he was unable to select the source phrase at the active
		// location and that the problem was due to the CPile::m_nWidth member still had a -1
		// uninitializaion value.
		// TODO: Test without the following call to see if it's really needed here - for this
		// situation when the test conditions above are TRUE.
		pActivePile->SetPhraseBoxGapWidth(); // Assigns value of CalcPhraseBoxGapWidth() to m_nWidth

#if defined (_DEBUG) && defined (TRACK_PHRBOX_CHOOSETRANS_BOOL)
		wxLogDebug(_T("View, PlacePhraseBox() line  %d , pApp->m_bTypedNewAdaptationInChooseTranslation = %d"), 3537,
			(int)pApp->m_bTypedNewAdaptationInChooseTranslation);
#endif
#if defined(_DEBUG) && defined(FLAGS)
		{
			CAdapt_ItApp* pApp = &wxGetApp();
			wxLogDebug(_T("\n%s::%s(), line %d, sn=%d, m_key= %s, m_bAbandonable %d, m_bRetainBoxContents %d, m_bUserTypedSomething %d, m_bBoxTextByCopyOnly %d, m_bAutoInsert %d"),
				__FILE__, __FUNCTION__, __LINE__, pSrcPhrase->m_nSequNumber, pSrcPhrase->m_key.c_str(), (int)pApp->m_pTargetBox->m_bAbandonable, (int)pApp->m_pTargetBox->m_bRetainBoxContents,
				(int)pApp->m_bUserTypedSomething, (int)pApp->m_pTargetBox->m_bBoxTextByCopyOnly, (int)pApp->m_bAutoInsert);
		}
#endif		
		goto a;
	}
	else
	{
        // when glossing, permit the save to be done to the glossing KB; but don't change
        // the source phrase's m_bNotInKB value since that only applies when adapting
		pApp->m_bSaveToKB = TRUE;

#if defined (_DEBUG) && defined (_ABANDONABLE)
		pApp->LogDropdownState(_T("PlacePhraseBox() landing, after m_bSaveToKB set TRUE"), _T("Adapt_ItView.cpp"), __LINE__);
#endif
	}

	// BEW added to test, 27Jun05, for free translation support (added selector == 3 test)
	if ((selector == 1 || selector == 3) && !pApp->m_pTargetBox->m_Translation.IsEmpty())
	{
		// bypass the removal from KB, since if m_Translation is non-empty, it will have
		// been done within code higher up in the current call tree (that's what
		// selector == 1 possibly means in this context)
		// The selector == 3 case is when the last PlacePhraseBox() call was just to the
		// start of the bundle's sourcephrase as a temporary placement to force bundle
		// adjustment so a second call can be made after the iterating backwards finishes
		// -- but later changes mean we need selector == 3 case anyway, even though we no
		// longer have bundles
		str = pApp->m_pTargetBox->m_Translation;

		// whm 24Jan2023 added back the SetPhraseBoxGapWidth() call, which assigns the 
		// returned value of CalcPhraseBoxGapWidth() to CPile::m_nWidth.
		// BEW reported this date that he was unable to select the source phrase at the active
		// location and that the problem was due to the CPile::m_nWidth member still had a -1
		// uninitializaion value.
		// TODO: Test without the following call to see if it's really needed here - for this
		// situation when the test conditions above are TRUE.
		// TODO: Test without the following call to see if it's really needed here.
		pActivePile->SetPhraseBoxGapWidth(); // Assigns value of CalcPhraseBoxGapWidth() to m_nWidth

#if defined (_DEBUG) && defined (_ABANDONABLE)
		pApp->LogDropdownState(_T("PlacePhraseBox() landing, after str set to m_pTargetBox->m_Translation, & before goto a;"), _T("Adapt_ItView.cpp"), 3576);
#endif
#if defined (_DEBUG) && defined (TRACK_PHRBOX_CHOOSETRANS_BOOL)
		wxLogDebug(_T("View, PlacePhraseBox() line  %d , pApp->m_bTypedNewAdaptationInChooseTranslation = %d"), 3579,
			(int)pApp->m_bTypedNewAdaptationInChooseTranslation);
#endif
		goto a;
	}

	// this block added in support of adaption KB versus glossing KB, to get booleans
	// to control branching in the code lower down
	if (gbIsGlossing)
	{
		if (!pSrcPhrase->m_bHasGlossingKBEntry && !pApp->m_bCopySource)
			bHasNothing = TRUE;
		if (!pSrcPhrase->m_bHasGlossingKBEntry)
			bNoValidText = TRUE;
		// BEW 9Aug23 NOTE: NEVER change m_bCopySource anywhere, except from the AI menu item for turning it on or off
		if (!pSrcPhrase->m_bNullSourcePhrase && pApp->m_bCopySource)
		{
			// It's not a placeholder, but m_bCopySource is TRUE. This will result in CopySourceKey() being 
			// called from DoGetSuitableText...(), to get the src key value into pApp->m_targetPhrase (for a gloss)
			bCopySomethingFromSrc = TRUE;
		}
		else
		{
			bCopySomethingFromSrc = FALSE;
		}
	}
	else // adapting
	{
		if (!pSrcPhrase->m_bHasKBEntry && !pSrcPhrase->m_bNotInKB && !pApp->m_bCopySource)
			bHasNothing = TRUE;
		if (!pSrcPhrase->m_bHasKBEntry && !pSrcPhrase->m_bNotInKB)
			bNoValidText = TRUE;
		// BEW 9Aug23 NOTE: NEVER change m_bCopySource anywhere, except from the AI menu item for turning it on or off
		if (!pSrcPhrase->m_bNullSourcePhrase && pApp->m_bCopySource)
		{
			// It's not a placeholder, but m_bCopySource is TRUE. This will result in CopySourceKey() being 
			// called from DoGetSuitableText...(), to get the src key value into pApp->m_targetPhrase (for a gloss)
			bCopySomethingFromSrc = TRUE;
		}
		else
		{
			bCopySomethingFromSrc = FALSE;
		}
	}

//#if defined (_DEBUG) && defined (_ABANDONABLE)
//	pApp->LogDropdownState(_T("PlacePhraseBox() landing, after setting bHasNothing, bNoValidText, bSomethingIsCopied (all false?)"), _T("Adapt_ItView.cpp"), __LINE__);
//#endif

	// get the auto capitalization parameters for the sourcephrase's key
	if (gbAutoCaps)
	{
		bNoError = pApp->GetDocument()->SetCaseParameters(pSrcPhrase->m_key);
	}

    // the next call factors out various blocks of code which all have one objective, to
    // find suitable text (adaptation in adapting mode, gloss in glossing mode) to put in
    // the passed in str parameter, which will then on return be used for the phrase box
    // contents which are to be shown in the box when it becomes visible at the new
    // location
    // BEW addition 25May13, don't call DoGetSuitableText_ForPlacePhraseBox() when
    // the Find operation is in progress for a search of source text, and the match
	// was made at a "hole" - because otherwise we could be shown a ChooseTranslation
	// dialog, or have a merge forced on us, or a copy of source text if we cancel.
	// I've put code to suppress the copy of source text in this circumstance, so just
	// need a test here, and if it is true, set str to the empty string instead; we
	// need do this only for a Find dialog (ie. gbFind is TRUE) because the Replace dlg
	// will not permit source text searching.
#if defined (_DEBUG) && defined (TRACK_PHRBOX_CHOOSETRANS_BOOL)
	wxLogDebug(_T("View, PlacePhraseBox() line  %d , pApp->m_bTypedNewAdaptationInChooseTranslation = %d"), 3632,
		(int)pApp->m_bTypedNewAdaptationInChooseTranslation);
#endif
	// BEW 16Aug23 if control is within the empty USFM mkrs loop, then don't try to get suitable
	// text for the box, as there isn't any to get - this change may allow a click on empty \s1 to lodge
	// the empty phrase box at the empty \s1 marker location
	//
	// whm 28Sep2023 comment:
	// While tracing the code to determine why the phrasebox was being emptied at times I found that
	// the Doc's m_bWithinEmptyMkrsLoop flag that is tested for below to almost always be TRUE
	// and this would cause the call of DoGetSuitableText_ForPlacePhraseBox() to be bypassed and
	// the assignment of the str value to remain empty. The reason that the m_bWithinEmptyMkrsLoop 
	// flag was TRUE was due to it not being initialized to FALSE properly. It was only initialized
	// to FALSE at the beginning of TokenizeText() which when loading an existing document is not
	// called before the PlacePhraseBox() function is called. I've fixed that problem by initializing
	// m_bWithinEmptyMkrsLoop to FALSE in the Doc's constructor, and also resetting it to FALSE 
	// after the empty markers loop exist within TokenizeText().
	// Even after the above inisializations, I cannot undersztand why the m_bWithinEmptyMkrsLoop flag
	// would be tested for here within the PlacePhraseBox() routine. I think the test that BEW added
	// on 16Aug23 should probably be removed. At least the flag should be properly initialized now
	// to a FALSE value while the execution is not "within the empty markers loop".
	// whm 17Jan2024 as of this date m_bWithinEmptyMkrsLoop is always FALSE since there is no more
	// markers loop, nor EnterEmptyMkrsLoop() function to set it TRUE. Hence the 
	// m_bWithinEmptyMkrsLoop boolen should be remove from the Doc and the enclosing if test below
	// removed from the enclosed if ... else code blocks.
	if (!pApp->GetDocument()->m_bWithinEmptyMkrsLoop)
	{
		if (gbFind && gbFindIsCurrent && pSrcPhrase->m_adaption.IsEmpty())
		{
			str.Empty();
		}
		else
		{

			DoGetSuitableText_ForPlacePhraseBox(pApp, pSrcPhrase, selector, pActivePile, str,
				bHasNothing, bNoValidText, bCopySomethingFromSrc);

#if defined (_DEBUG)
			wxLogDebug(_T("PlacePhraseBox() RESULTS DoGetSuitableText... line %d, selector= %d, str= [%s], bHasNothing= %d, bNoValidText= %d, bCopySomethingFromSrc= %d"),
				__LINE__, selector, str.c_str(), (int)bHasNothing, (int)bNoValidText, (int)bCopySomethingFromSrc);
			if (pSrcPhrase->m_nSequNumber >= 0)
			{
				int halt_here = 1; wxUnusedVar(halt_here); // avoid compiler warning variable initialized but not referenced
			}
#endif

#if defined (_DEBUG) && defined (TRACK_PHRBOX_CHOOSETRANS_BOOL)
			wxLogDebug(_T("View, PlacePhraseBox() line  %d  after DoGetSuitableText...(), pApp->m_bTypedNewAdaptationInChooseTranslation = %d"), __LINE__,
				(int)pApp->m_bTypedNewAdaptationInChooseTranslation);
#endif
		}
	} // end of TRUE block for test: if (!m_bWithinEmptyMkrsLoop)

a:	pApp->m_targetPhrase = str; // it will lack punctuation, because of BEW change on
				// 28April05 to the code now in the DoGetSuitableText_ForPlacePhraseBox()
	pApp->m_nStartChar = -1;
	pApp->m_nEndChar = -1; // make sure the text is shown selected
	if (gbAutoCaps)
	{
		if (gbSourceIsUpperCase && !gbMatchedKB_UCentry)
		{
			bNoError = pApp->GetDocument()->SetCaseParameters(pApp->m_targetPhrase, FALSE);
			if (bNoError && !gbNonSourceIsUpperCase && (gcharNonSrcUC != _T('\0')))
			{
				// change to upper case initial letter
				pApp->m_targetPhrase.SetChar(0,gcharNonSrcUC);
				pApp->m_pTargetBox->m_bAbandonable = FALSE; // If contents changed, it must become non-Abandonable (BEW added line 7May18)
			}
		}
	}
#if defined (_DEBUG) && defined (TRACK_PHRBOX_CHOOSETRANS_BOOL)
	wxLogDebug(_T("View, PlacePhraseBox() line  %d , pApp->m_bTypedNewAdaptationInChooseTranslation = %d"), 3693,
		(int)pApp->m_bTypedNewAdaptationInChooseTranslation);
#endif
    pApp->m_pTargetBox->m_SaveTargetPhrase = pApp->m_targetPhrase;
	pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(pApp->m_targetPhrase); // BEW 7May18 added line, m_targetPhrase & contents of m_pTargetBox must stay in sync

#if defined (_DEBUG) && defined (_ABANDONABLE)
	pApp->LogDropdownState(_T("PlacePhraseBox() Landing, just set m_SaveTargetPhrase, & box contents, to m_targetPhrase"), _T("Adapt_ItView.cpp"), __LINE__);

	wxLogDebug(_T("View, PlacePhraseBox() line  %d 'Landing' pApp->m_SaveTargetPhrase = %s"), __LINE__,pApp->m_pTargetBox->m_SaveTargetPhrase.c_str());
#endif

	// BEW 1Jun10, moved to here from within DoGetSuitableText_ForPlacePhraseBox(), as it
	// logically makes no sense in the latter, and is more relevant here (particularly as
	// a goto to label a: would bypass the latter function call and so this code would be
	// missed (wrongly so) -- what we do here is to auto-adjust the KB CRefString entry
	// for this new location so as to decrement by one the m_refCount, or if it was
	// already just equal to 1, to 'remove' it (ie. set its m_bDeleted flag to TRUE)
	if (!bHasNothing)
	{
        // don't do the following selection when PlacePhraseBox() is called from deep in
        // some other function before the phrasebox is finally rebuilt (such as in the
        // SetActivePilePointerSafely() call in the OnButtonRetranslation() call; since it
        // would then either decrement a refCount, or remove a translation association,
        // wrongly) - in such instances, we must suppress the removal
		if (pApp->GetRetranslation()->GetSuppressRemovalOfRefString() == FALSE)
		{
//#if defined (_DEBUG) && defined (_ABANDONABLE)
//		pApp->LogDropdownState(_T("PlacePhraseBox() landing, !bHasNothing TRUE block, get ready for removing RefString"), _T("Adapt_ItView.cpp"), 3893);
//#endif
			// remove the CRefString from the KB if it is referenced only once, otherwise
			// decrement its reference count by one, so that if user edits the string the KB
			// (or if glossing, then the glossing KB) will be kept up to date
			if (selector != 1 && selector != 3) // see comments under the function header
												// for an explanation of the selector values
			{
#if defined (_DEBUG) && defined (TRACK_PHRBOX_CHOOSETRANS_BOOL)
				wxLogDebug(_T("View, PlacePhraseBox() line  %d , pApp->m_bTypedNewAdaptationInChooseTranslation = %d"), 3902,
					(int)pApp->m_bTypedNewAdaptationInChooseTranslation);
#endif
				// do this for selector values 0 or 2,
                // (BEW addition 12Jun13) but do so only if the pile which pSrcPhrase is at
                // is the current active pile - if it isn't so, then the active location
                // has become shifted, and the removal shouldn't be attempted; so I've
                // added the test on the next line of code. (A Cancel from
                // ChooseTranslation() at a phrase hole would result in the active location
                // being the new location, and so that shift would cause a crash here. This
                // is prevented now by the test for non-moved location.)
				if (pSrcPhrase == pApp->m_pActivePile->GetSrcPhrase())
				{
					wxString emptyStr = _T("");
					if (gbIsGlossing)
						pApp->m_pGlossingKB->GetAndRemoveRefString(pSrcPhrase, emptyStr, useGlossOrAdaptationForLookup);
					else
						pApp->m_pKB->GetAndRemoveRefString(pSrcPhrase, emptyStr, useGlossOrAdaptationForLookup);

					// BEW 28Apr18 Clicking at a hole in the document will, if CopySourceKey() gets called
					// because KB has no entry available for the source text at that location, the
					// CopySourceKey() will, just before exiting, set m_bAbandonable to TRUE; but if the
					// KB does have one or more adaptations available there, CopySourceKey() will not get
					// called. So we have to here check for the active location's CSourcePhrase being a
					// hole -  which we can detect by its m_adaption member being empty. If it is empty,
					// then set m_bAbandonable here, to be TRUE (failure to do this will leave an unwanted
					// top-of-list entry being copied as target text adaptation if user clicks elsewhere
					// without editing or any action which makes the box become dirty)
					CPile* myActivePile = pCell->GetPile();
					CSourcePhrase* pSP = NULL;
					pSP = myActivePile->GetSrcPhrase();
					if (pSP == pSrcPhrase) // make sure we are at the new landing location
					{
						if (pSP->m_adaption.IsEmpty() || pApp->m_pKB->IsItNotInKB(pSP))
						{
#if defined(ABANDON_NOT)
							pApp->m_pTargetBox->m_bAbandonable = FALSE;
#else
							pApp->m_pTargetBox->m_bAbandonable = TRUE;
#endif

#if defined (_DEBUG) && defined (_ABANDONABLE)
	pApp->LogDropdownState(_T("PlacePhraseBox() landing, line %d, forcing m_bAbandonable to TRUE at hole with KB entry available, selector == 0 or 2"), _T("Adapt_ItView.cpp"), __LINE__);
#endif
						}
					}
#if defined(_DEBUG) && defined(FLAGS)
			{
				CAdapt_ItApp* pApp = &wxGetApp();
				wxLogDebug(_T("PlacePhraseBox(), line %d, sn=%d, m_key= %s, m_bAbandonable %d, m_bRetainBoxContents %d, m_bUserTypedSomething %d, m_bBoxTextByCopyOnly %d, m_bAutoInsert %d"),
					__LINE__, pSP->m_nSequNumber, pSP->m_key.c_str(), (int)pApp->m_pTargetBox->m_bAbandonable, (int)pApp->m_pTargetBox->m_bRetainBoxContents,
					(int)pApp->m_bUserTypedSomething, (int)pApp->m_pTargetBox->m_bBoxTextByCopyOnly, (int)pApp->m_bAutoInsert);
			}
#endif
				}
				else
				{
                    // BEW 12Jun13, If the ref string removal is skipped, then make the
                    // location abandonable if the m_adaption is empty in the source phrase
                    // instance; and the application will have become in a passive event
                    // loop (ie. not calling OnIdle()) and so a subsequent Enter keypress
                    // would not advance the phrase box, because OnePass() which is in
                    // OnIdle() wouldn't get called because OnIdle() wouldn't be called. So
                    // we have to wake up idle event processing - this can be done by
                    // calling RequestMore() from within the idle event handler itself, but
                    // once in passive mode, that won't work, so we need an explicit
                    // command to awaken idle event posting again, and wxWakeUpIdle() is that
                    // command.
					if (pApp->m_pActivePile->GetSrcPhrase()->m_adaption.IsEmpty())
					{
#if defined(ABANDON_NOT)
						pApp->m_pTargetBox->m_bAbandonable = FALSE;
#else
						pApp->m_pTargetBox->m_bAbandonable = TRUE;
#endif
					}
					// make sure idle events are continuing
					wxWakeUpIdle();
				}
#if defined (_DEBUG) && defined (TRACK_PHRBOX_CHOOSETRANS_BOOL)
				wxLogDebug(_T("View, PlacePhraseBox() line  %d , pApp->m_bTypedNewAdaptationInChooseTranslation = %d"), 3972,
					(int)pApp->m_bTypedNewAdaptationInChooseTranslation);
#endif			
			}
//#if defined (_DEBUG) && defined (_ABANDONABLE)
//			pApp->LogDropdownState(_T("PlacePhraseBox() landing, !bHasNothing TRUE block, after any RefString removal"), _T("Adapt_ItView.cpp"), 3977);
//#endif

		}
	}

	// mark invalid the strip following the new active strip, so as to allow
	// migration upwards of pile in a strip which sometimes may not be full; but do this
	// only if there is less than 3/4 of the strip's width occupied by piles currently
	if (pApp->m_nActiveSequNum != -1)
	{
		CPile* pile = GetPile(pApp->m_nActiveSequNum);
		wxASSERT(pile != NULL);
		int stripArrayCount = (int)pLayout->GetStripArray()->GetCount();
		if (stripArrayCount > 0)
		{
			int activeStripIndex = pile->GetStripIndex(); // returns m_pOwningStrip->m_nStrip if Owner strip is not NULL
			if (activeStripIndex >= 0) // do this TRUE block
			{
				// There is an owning strip for the active pile, it's the 'active' strip, so point to it
				CStrip* pStrip = pLayout->GetStripByIndex(activeStripIndex);
				int stripWidth = pStrip->Width();
				int freeS = pStrip->GetFree();
				if (freeS > stripWidth / 4)
				{
					// BEW changed 20Jan11, we want only unique indices in the array
					AddUniqueInt(pLayout->GetInvalidStripArray(), activeStripIndex);
				}
				// That prepares for the RecalcLayout() to know which strip is active one
			}
		} // end of TRUE block for test: if (stripArrayCount > 0)
	} // end of TRUE block for test: if (pApp->m_nActiveSequNum != -1)

    // recalculate the layout; before the actual strips are rebuilt, doc class member
    // ResetPartnerPileWidth(), with bool param, bNoActiveLocationCalculation, default
    // FALSE is called, to get a fresh active pile pointer in m_pileList, and a new gap
    // calculated for the phrase box's new width, before Draw() has it made visible when
    // the view's Invalidate() call is made below (Note: later, we can replace this
    // RecalcLayout() call with a call to the faster AdjustForUserEdits(), which also
    // likewise calls ResetPartnerPileWidth() - for the same reason as given above)
#if defined (_DEBUG)
	{
		wxLogDebug(_T("PlacePhraseBox() line %d : pSrcPhrase m_srcPhrase = %s , sn = %d"), __LINE__,
			pSrcPhrase->m_targetStr.c_str(), pSrcPhrase->m_nSequNumber);
	}
#endif

#ifdef _NEW_LAYOUT
	pLayout->RecalcLayout(pApp->m_pSourcePhrases, keep_strips_keep_piles);
#else
	pLayout->RecalcLayout(pApp->m_pSourcePhrases, create_strips_keep_piles);
#endif
#if defined (_DEBUG) && defined (TRACK_PHRBOX_CHOOSETRANS_BOOL)
	wxLogDebug(_T("View, PlacePhraseBox() line  %d , pApp->m_bTypedNewAdaptationInChooseTranslation = %d"), 4020,
		(int)pApp->m_bTypedNewAdaptationInChooseTranslation);
#endif
    // update the active pile pointer to point at the refreshed pile pointer which the
    // RecalcLayout() call created
	pApp->m_pActivePile = GetPile(pApp->m_nActiveSequNum);
	wxASSERT(pApp->m_pActivePile);
	pLayout->m_docEditOperationType = relocate_box_op;

	CSourcePhrase* pSPhr = pApp->m_pActivePile->GetSrcPhrase();
	if (pSPhr != NULL)
	{
		pDoc->ResetPartnerPileWidth(pSPhr);

		bool bProhibited = pApp->GetDocument()->IsWithinSpanProhibitingPlaceholderInsertion(pSPhr);
		pApp->m_bDisablePlaceholderInsertionButtons = bProhibited;
	}

#if defined (_DEBUG)
	{
//		wxLogDebug(_T("%s::%s() line %d : pSrcPhrase m_srcPhrase = %s , sn = %d"), __FILE__, __FUNCTION__, __LINE__,
//			pSPhr->m_targetStr.c_str(), pSPhr->m_nSequNumber);
	}
#endif

	// BEW 5Jul18, reinstate the line which sets the cached sequence number for the
	// landing location. The next click somewhere will use that this value as the 
	// "Leaving" location from which the phrasebox jumps
	pApp->m_nCacheLeavingLocation = pApp->m_nActiveSequNum;

    pApp->m_pTargetBox->m_bCompletedMergeAndMove = FALSE;
//#ifdef _DEBUG
//	wxLogDebug(_T("PlacePhraseBox at %d ,  Active Sequ Num  %d"),4049,pApp->m_nActiveSequNum);
//#endif

	// whm added 20Nov10 reset the m_bIsGuess flag below. Can't do it in PlaceBox()
	// because PlaceBox() is called first via the MoveToNextPile() call near the beginning
	// of OnePass, then again near the end of OnePass - twice in the normal course of
	// auto-insert adaptations.
	pApp->m_bIsGuess = FALSE;

    // whm 27Feb2018 Note: Here at the end of PlacePhraseBox() is one candidate location 
    // to have the block of code (presently within Layout's PlaceBox) that sets up and 
    // populates the dropdown list. Putting it here in PlacePhraseBox would help to eliminate
    // the repeated execution of that block that it gets in its location in PlaceBox().
    // The down side, however, is that my analysis of all uses of PlacePhraseBox() and PlaceBox()
    // indicates that this same code would have to be (via putting it into a separate function) 
    // put in over 100 places where PlaceBox() is called and there was no prior call of 
    // PlacePhraseBox(). Conclusion: Best I think to leave the setup and populating routines
    // within PlaceBox(), and just ensure that it can tolerate repeated/redundant calls for
    // the phrasebox located at the same location.

	Invalidate();
#if defined (_DEBUG) && defined (TRACK_PHRBOX_CHOOSETRANS_BOOL)
	wxLogDebug(_T("View, PlacePhraseBox() line  %d , pApp->m_bTypedNewAdaptationInChooseTranslation = %d"), __LINE__,
		(int)pApp->m_bTypedNewAdaptationInChooseTranslation);
#endif
#if defined (_DEBUG) && defined (_ABANDONABLE)
	wxLogDebug(_T("View, PlacePhraseBox() line %d - before PlaceBox(), pApp->m_SaveTargetPhrase = %s"), __LINE__,
		pApp->m_pTargetBox->m_SaveTargetPhrase.c_str());
#endif

	pLayout->PlaceBox();

	// BEW 7May18. restore default values for m_bLandingBox etc. We don't do this
	// in PlaceBox itself, as the latter is called at too many places where landing
	// of the box requiring our special list insertion hack is not involved.
	pApp->m_pTargetBox->InitializeComboLandingParams();

	// BEW 25Jul18, Cache the sequence number of this clicked location, so that a subsequent
	// click to a different location can use this value to set the old active pile etc.
	// Epecially app's m_nCacheLeavingLocation - which makes it all happen, and having
	// it the wrong value causes the "Leaving" pile's GUI gaps to be messed up.
	// whm 11Nov2022 removed assignment below of App's m_nCacheLeavingLocation since
	// it was called about 12 code lines above here within PlacePhraseBox().
	//pApp->m_nCacheLeavingLocation = pApp->m_pActivePile->GetSrcPhrase()->m_nSequNumber;

#if defined (_DEBUG) && defined (_ABANDONABLE)
	pApp->LogDropdownState(_T("PlacePhraseBox() landing, after PlaceBox() about to exit PlacePhraseBox()"), _T("Adapt_ItView.cpp"), __LINE__);

	wxLogDebug(_T("View, PlacePhraseBox() line  %d 'Landing' - now exiting, pApp->m_SaveTargetPhrase = %s"), __LINE__,
		pApp->m_pTargetBox->m_SaveTargetPhrase.c_str());
#endif
	pApp->m_bTypedNewAdaptationInChooseTranslation = FALSE; // re-initialize

#if defined (_DEBUG) && defined (TRACK_PHRBOX_CHOOSETRANS_BOOL)
	wxLogDebug(_T("View, PlacePhraseBox() line  %d  - exiting, pApp->m_bTypedNewAdaptationInChooseTranslation = %d"), __LINE__,
		(int)pApp->m_bTypedNewAdaptationInChooseTranslation);
#endif

	// whm 24Jan2023 added back the SetPhraseBoxGapWidth() call, which assigns the 
	// returned value of CalcPhraseBoxGapWidth() to CPile::m_nWidth.
	// BEW reported this date that he was unable to select the source phrase at the active
	// location and that the problem was due to the CPile::m_nWidth member still had a -1
	// uninitializaion value.
	// Testing with the following call of SetPhraseBoxGapWidth() commented out, indicate that
	// the issue of CPile::m_nWidth being uninitialized with a -1 value is not mitigated byi
	// calling SetPhraseBoxGapWidth() here. Therefore, after testing, I've commented the call
	// out below.
	//pActivePile->SetPhraseBoxGapWidth(); // Assigns value of CalcPhraseBoxGapWidth() to m_nWidth

	// whm 11Nov2022 the two calls below have already been done above with the same parameters at
	// the current active location, so I'm commenting them out as a duplication since the old
	// phrasebox sizing just above is no longer needed here in PlacePhraseBox(). The only thing
	// we need here is a main frame size event to get alignment of pile correct.
	pApp->GetMainFrame()->SendSizeEvent();
	//pApp->GetDocument()->ResetPartnerPileWidth(pApp->m_pActivePile->GetSrcPhrase()); // gets strip invalid, etc
	//pApp->GetLayout()->RecalcLayout(pApp->m_pSourcePhrases, keep_strips_keep_piles); //3rd  is default steadyAsSheGoes

#if defined(_DEBUG) && defined(FLAGS)
	{
		CAdapt_ItApp* pApp = &wxGetApp();
		CSourcePhrase* pSrcPhrase = pApp->m_pActivePile->GetSrcPhrase();
		wxLogDebug(_T("PlacePhraseBox(), line %d, sn=%d, m_key= %s, m_bAbandonable %d, m_bRetainBoxContents %d, m_bUserTypedSomething %d, m_bBoxTextByCopyOnly %d, m_bAutoInsert %d"),
			__LINE__, pSrcPhrase->m_nSequNumber, pSrcPhrase->m_key.c_str(), (int)pApp->m_pTargetBox->m_bAbandonable, (int)pApp->m_pTargetBox->m_bRetainBoxContents,
			(int)pApp->m_bUserTypedSomething, (int)pApp->m_pTargetBox->m_bBoxTextByCopyOnly, (int)pApp->m_bAutoInsert);
	}
#endif
	//	wxLogDebug(_T("%s:%s():line %d, m_bFreeTranslationMode = %s"), __FILE__, __FUNCTION__, __LINE__,
	//		(&wxGetApp())->m_bFreeTranslationMode ? _T("TRUE") : _T("FALSE"));

#if defined(_DEBUG) && defined(GUIFIX)
	wxLogDebug(_T("*** Leaving PlacePhraseBox()  , selector = %d"), selector);
#endif
#if defined(_DEBUG) && defined(_OVERLAP)
	{
		CSourcePhrase* pSPhr = pApp->m_pActivePile->GetSrcPhrase();

		{
			wxTextCtrl* pTxtBox = pApp->m_pTargetBox->GetTextCtrl();
			CMyListBox* pListBox = pApp->m_pTargetBox->GetDropDownList();
			int boxWidth = pTxtBox->GetClientRect().width;
			wxSize sizeList = pListBox->GetClientSize();
			int listWidth = sizeList.x;
			wxLogDebug(_T("%s::%s() line %d: boxWidth from GetClientRect().width: %d, listWidth %d , tgt = %s"),
				__FILE__, __FUNCTION__, __LINE__, boxWidth, listWidth, pSPhr->m_adaption.c_str());
		}
	}
#endif
}

// OnPrepareDC() was moved to CAdapt_ItCanvas in the wx version

/////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \param      event   -> unused
/// \remarks
/// Called from: The File -> Print menu selection. Note: This handler is not called when
/// the "Print" button in the print preview dialog is pressed. This handler creates a
/// printer object from the wxPrinter class, associates it with our wxPrintDialogData
/// object (pPrintData), sets the print dialog title and invokes the print dialog by
/// calling printer.Print().
/////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItView::OnPrint(wxCommandEvent& WXUNUSED(event))
{
	CAdapt_ItApp* pApp = &wxGetApp();
#if defined (FREETRMODE)
	wxLogDebug(_T("%s:%s():line %d, m_bFreeTranslationMode = %s"), __FILE__, __FUNCTION__, __LINE__,
		(&wxGetApp())->m_bFreeTranslationMode ? _T("TRUE") : _T("FALSE"));
#endif
// TODO: Remove the following conditional block after fixing the printing issues 
// on Linux Xenial using WX3.x.
#if defined(__WXGTK__) && wxCHECK_VERSION(3,0,0)
    // On Linux Xenial and newer distros which only have wx3.X notify the user of
    // potential print preview and print to printer problems on Linux due to issues
    // in the WX3.x library. Suggest that the user not print from within AI, but
    // do Export-Import > Export Interlinear Text... and print from LibreOffice or
    // MS Word for better, more stable results.
    wxString msg = _T("Warning: The Print Preview and Print (to paper) functions in this version of Linux have some issues that may cause Adapt It to crash, so those Print functions have been disabled.\nYou can get a better view and/or print out of the document by doing the following:\n   On the Export-Import menu select Export Interlinear Text... and export the document to an RTF file.\n   Then open the document file in LibreOffice or Word, where you will be able to view or print the document.\n");
    wxString title = _T("Printing Disabled");
    // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
    pApp->m_bUserDlgOrMessageRequested = TRUE;
    wxMessageBox(msg, title, wxICON_WARNING | wxOK);
    pApp->LogUserAction(msg);
    //return;
#endif
    
    // whm note: The code below is adapted from wxWidgets printing sample
	// See file:.\AIPrintout.cpp#print_flow for the order of calling of OnPrint().

	gbIsBeingPreviewed = FALSE; // from MFC's OnPreparePrinting

#if defined(__WXGTK__) // print-related
    // BEW added 15Nov11  -- set up defaults for page range choice, 'no choice', PageOffsets the initial page only
    pApp->m_bPrintingPageRange = FALSE;
    pApp->m_userPageRangePrintStart = 1; // 1-base indexing
    pApp->m_userPageRangePrintEnd = 1;   // 1-based indexing
    pApp->m_userPageRangeStartPage = 1; // we use this to get a correct number into the printed footer
#endif
#if defined (FREETRMODE)
	wxLogDebug(_T("%s:%s():line %d, m_bFreeTranslationMode = %s  gbSuppressSetup set FALSE"), __FILE__, __FUNCTION__, __LINE__,
		(&wxGetApp())->m_bFreeTranslationMode ? _T("TRUE") : _T("FALSE"));
#endif
	wxPrintDialogData printDialogData(*pApp->pPrintData);

	pApp->m_bIsPrinting = TRUE; // new printing support code needs it set before poDlg InitDialog() is called
	pApp->m_nSaveActiveSequNum = pApp->m_nActiveSequNum; // needed! So Cancel from PrintOptionsDlg
														 // can restore document correctly
	pApp->LogUserAction(_T("Initiated OnPrint()"));
    // In the wx version we implement a chapter and verse selection dialog to supplement the print
    // dialog, since it is not likely we will be able to use custom print dialogs for all platforms.
    // The print options dialog items are:
    // 1. Radio buttons for: "All", "Selection", "Pages", and "Chapter/Verse Range.
    // 2. "from:" and "to:" edit boxes associated with the "Pages" radio button.
	// 3. "from: chapter" and "verse" edit boxes; and "to: chapter" and "verse" edit boxes for range
	//    number(s) entry associated with the "Chapter/Verse Range" radio button.
    // 4. A check box "[ ] Suppress a preceding section heading".
    // 5. A check box "[ ] Include a following section heading".
    // 6. A check box "[ ] Suppress printing of the footer".
	CPrintOptionsDlg poDlg(pApp->GetMainFrame()); //,&printout);
	poDlg.Centre();
#if defined (FREETRMODE)
	wxLogDebug(_T("%s:%s():line %d, m_bFreeTranslationMode = %s  gbSuppressSetup set FALSE"), __FILE__, __FUNCTION__, __LINE__,
		(&wxGetApp())->m_bFreeTranslationMode ? _T("TRUE") : _T("FALSE"));
#endif
	// The CPrintOptionsDlg does all of its own initialization
	if (poDlg.ShowModal() == wxID_OK)
	{
		// Update printDialogData to reflect:
        // 1. Whether the user entered a "from" and a "to" page range so that this carries
        // over to the print dialog below.
		// 2. Whether the user clicked on the "Selection" radio button (if enabled)
#if defined (FREETRMODE)
		wxLogDebug(_T("%s:%s():line %d, m_bFreeTranslationMode = %s  gbSuppressSetup set FALSE"), __FILE__, __FUNCTION__, __LINE__,
			(&wxGetApp())->m_bFreeTranslationMode ? _T("TRUE") : _T("FALSE"));
#endif
		// get user settings for Pages
		if (poDlg.pRadioPages->GetValue() == TRUE)
		{
			wxString strFrom,strTo;
			int nFrom,nTo;
			strFrom = poDlg.pEditPagesFrom->GetValue();
			nFrom = wxAtoi(strFrom);
			strTo = poDlg.pEditPagesTo->GetValue();
			nTo = wxAtoi(strTo);
			printDialogData.SetFromPage(nFrom);
			printDialogData.SetToPage(nTo);
#if defined(__WXGTK__) // print-related
            // BEW added 15Nov11  -- a workaround because the Linux build loses the
            // nFrom and nTo values somewhere in the wxGnomeprinter framework
            pApp->m_bPrintingPageRange = TRUE;
            pApp->m_userPageRangePrintStart = nFrom; // 1-base indexing
            pApp->m_userPageRangePrintEnd = nTo; // 1-based indexing
            pApp->m_userPageRangeStartPage = nFrom; //1-based indexing -- this one for footer
#endif
#if defined (FREETRMODE)
			wxLogDebug(_T("%s:%s():line %d, m_bFreeTranslationMode = %s  gbSuppressSetup set FALSE"), __FILE__, __FUNCTION__, __LINE__,
				(&wxGetApp())->m_bFreeTranslationMode ? _T("TRUE") : _T("FALSE"));
#endif
		}
		else if (poDlg.pRadioSelection->GetValue() == TRUE)
		{
			printDialogData.SetSelection(TRUE);
#if defined (FREETRMODE)
			wxLogDebug(_T("%s:%s():line %d, m_bFreeTranslationMode = %s  gbSuppressSetup set FALSE"), __FILE__, __FUNCTION__, __LINE__,
				(&wxGetApp())->m_bFreeTranslationMode ? _T("TRUE") : _T("FALSE"));
#endif
		}
	}
	else
	{
#if defined (FREETRMODE)
		wxLogDebug(_T("%s:%s():line %d, m_bFreeTranslationMode = %s"), __FILE__, __FUNCTION__, __LINE__,
			(&wxGetApp())->m_bFreeTranslationMode ? _T("TRUE") : _T("FALSE"));
#endif
		// User cancelled the print options, so we assume we should also cancel the print
        // dialog which happens if we simply return here. The MFC version did a lot of work
        // to get the document back into its original state, but the wx version doesn't
        // change the doc's state at this early stage.
		//BEW added 20July(), because we no longer do "simulated" recalc of the layout
		//etc, but a real one and real pagination in order to prepare parameters for the
		//PrintOptionsDlg, and so we need to undo all that to get the original document
		//state back.
		pApp->m_nAIPrintout_Destructor_ReentrancyCount = 1;
		pApp->DoPrintCleanup();
#if defined (FREETRMODE)
		wxLogDebug(_T("%s:%s():line %d, m_bFreeTranslationMode = %s"), __FILE__, __FUNCTION__, __LINE__,
			(&wxGetApp())->m_bFreeTranslationMode ? _T("TRUE") : _T("FALSE"));
#endif
		pApp->m_nAIPrintout_Destructor_ReentrancyCount = 0;
		pApp->m_bIsPrinting = FALSE;
		pApp->LogUserAction(_T("Cancelled OnPrint()"));
#if defined(__WXGTK__) // print-related
        // BEW added 15Nov11  -- restore defaults for page range choice, 'no choice',
        // PageOffsets the initial page only
        pApp->m_bPrintingPageRange = FALSE;
        pApp->m_userPageRangePrintStart = 1; // 1-base indexing
        pApp->m_userPageRangePrintEnd = 1; // 1-based indexing
        pApp->m_userPageRangeStartPage = 1;
#endif
		return;
	}
	wxPrinter printer(& printDialogData);
	wxString printTitle;
	printTitle = printTitle.Format(_T("Printing %s"),pApp->m_curOutputFilename.c_str());
	// klb 9/2011 : If user has requested printing of Glosses in CPrintOptionsDlg and
	//              Glosses are not currently visible, we need to turn glosses on so
	//              that they are printed. Local variable bNeedToToggleGlossing will tell
	//              us whether we need to switch the main screen back (below) after printing
	bool bNeedToToggleGlossing = FALSE;
	if ((gbCheckInclGlossesText == TRUE) && !gbGlossingVisible)
	{
		bNeedToToggleGlossing = TRUE;
		ShowGlosses();
	}
	AIPrintout printout(printTitle); // this calls Freeze() on the canvas
	// for debugging -- yes, user's range of pages, if set, which was input above at line
	// 3380 does output the correct values when GetPrintDialogData() is called here, but
	// somewhere after that the values are lost and so the GTK printing framework defaults
	// to using page 1 as the fromPage and 0 as the toPage value, and the framework checks
	// and sees the 0 value and substitutes 99999. Can't see a way to fix this. (BEW 12Nov11)
	//wxPrintDialogData printDD = printer.GetPrintDialogData();
	// #printer_Print
    if (!printer.Print(pApp->GetMainFrame(), &printout, true)) // true means 'prompt'
    {
		// whm: Other error messages are issued, so we don't need yet another one here
		pApp->LogUserAction(_T("Printer error from OnPrint()"));
    }
    else
    {
        (*pApp->pPrintData) = printer.GetPrintDialogData().GetPrintData();
    }
    // Do not clear m_bPrintingPageRange to FALSE here, it is needed until DoPrintCleanup()'s
    // internal test of it's value is done in the AIPrintout destructor
	// klb 9/2011 : toggle main screen to hide glosses again if necessary
	if (bNeedToToggleGlossing == TRUE)
		ShowGlosses();
#if defined (FREETRMODE)
	wxLogDebug(_T("%s:%s():line %d, m_bFreeTranslationMode = %s"), __FILE__, __FUNCTION__, __LINE__,
		(&wxGetApp())->m_bFreeTranslationMode ? _T("TRUE") : _T("FALSE"));
#endif
}
/////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \param      event   -> unused
/// \remarks
/// Called from: The File -> Print Preview menu selection. This handler creates a preview
// object from the / wxPrintPreview class, creates a frame object from the wxPreviewFrame
// class, positions, sizes and / initializes the frame, and finally shows the print preview
// frame in modal fashion.
/////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItView::OnPrintPreview(wxCommandEvent& WXUNUSED(event))
{
    
	CAdapt_ItApp* pApp = &wxGetApp();

// TODO: Remove the following conditional block after fixing the printing issues 
// on Linux Xenial using WX3.x.
#if defined(__WXGTK__) && wxCHECK_VERSION(3,0,0)
    // On Linux Xenial and newer distros which only have wx3.X notify the user of
    // potential print preview and print to printer problems on Linux due to issues
    // in the WX3.x library. Suggest that the user not print from within AI, but
    // do Export-Import > Export Interlinear Text... and print from LibreOffice or
    // MS Word for better, more stable results.
    wxString msg = _T("Warning: The Print Preview and Print (to paper) functions in this version of Linux have some issues that may cause Adapt It to crash, so those Print functions have been disabled.\nYou can get a better view and/or print out of the document by doing the following:\n   On the Export-Import menu select Export Interlinear Text... and export the document to an RTF file.\n   Then open the document file in LibreOffice or Word, where you will be able to view or print the document.\n");
    wxString title = _T("Print Preview Disabled");
    // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
    pApp->m_bUserDlgOrMessageRequested = TRUE;
    wxMessageBox(msg, title, wxICON_WARNING | wxOK);
    pApp->LogUserAction(msg);
    //return;
#endif
    
    // whm note: The code below is adapted from wxWidgets printing sample
	// See file:.\AIPrintout.cpp#print_flow for the order of calling of OnPrint().
    // Pass two printout objects: for preview, and possible printing.

#if wxCHECK_VERSION(3, 0, 0) // whm added 10Oct2016
    // WX3.0 print sample uses a preview modality
    wxPreviewFrameModalityKind m_previewModality;
    m_previewModality = wxPreviewFrame_AppModal;
#endif


    // whm 25Sep11 modified. As I did in the PrintOptionsDlg::InitDialog() function,
	// we should initialize the values of gbCheckInclGlossesText and gbCheckInclFreeTransText
	// based on whether the document actually has such content or not. If the doc has
	// free translations, we should include them in the Print Preview, otherwise we
	// omit them.
	if (pApp->DocHasFreeTranslations(pApp->m_pSourcePhrases))
	{
		gbCheckInclFreeTransText = TRUE;
	}
	else
	{
		gbCheckInclFreeTransText = FALSE;
	}
	// whm 25Sep11 modified. Likewise, if the doc has glosses, we should include them
	// in the Print Preview, otherwise we omit them.
	if (pApp->DocHasGlosses(pApp->m_pSourcePhrases))
	{
		gbCheckInclGlossesText = TRUE;
	}
	else
	{
		gbCheckInclGlossesText = FALSE;
	}

    // BEW 5Oct11, we'll unilaterally Freeze(), and unlaterally later Thaw(), whether or
    // not we subsequently turn on glossing or free translation modality
    // whm removed Freeze() below for Print Preview. It seems to relate to a crash in
    // the frame->InitializeWithModality(m_previewModality) call below.
	//pApp->GetMainFrame()->Freeze();
	//pApp->m_bFrozenForPrinting = TRUE;

	// klb 9/2011 : If glosses are not visible, we need to make them visible in the
	// underlying document temporarily to have them show in the print preview frame
	// whm 25Sep11 added test below for gbCheckInclGlossesText.
	bool bHideFreeTranslations = FALSE;
	if (gbCheckInclFreeTransText && !pApp->m_bFreeTranslationMode)
	{
		bHideFreeTranslations = TRUE;
		pApp->GetFreeTrans()->SwitchScreenFreeTranslationMode(ftModeON);
	}
	bool bHideGlosses = FALSE;
	if (gbCheckInclGlossesText && !gbGlossingVisible)
	{
		bHideGlosses = TRUE;
		pApp->GetView()->ShowGlosses();
	}

	GetLayout()->RecalcLayout(pApp->GetSourcePhraseList(),create_strips_and_piles);
	// must reset m_pActivePile after a RecalcLayout(), else view's Draw() will crash
	pApp->m_pActivePile = GetPile(pApp->m_nActiveSequNum); // the param hasn't changed

    pApp->LogUserAction(_T("Initiated OnPrintPreview()"));
	wxString previewTitle,printTitle;
	previewTitle = previewTitle.Format(_T("Print Preview of %s"),
										pApp->m_curOutputFilename.c_str());
	printTitle = printTitle.Format(_T("Printing %s"),pApp->m_curOutputFilename.c_str());
	// BEW 21Oct14 set high quality
    // whm 19Oct16 removed this SetQuality() call
	//pApp->pPrintData->SetQuality(wxPRINT_QUALITY_HIGH);
    wxPrintDialogData printDialogData(*pApp->pPrintData);

	// BEW fiddles, 20Oct14, trying to get PrintPreview to show other than fixed 25mm
	// page margins
	AIPrintout* pAIPrOut = new AIPrintout(previewTitle);
	// next line tests if my manually set margin of 2mm is picked up
	wxPoint marginTopLeft = pApp->pPgSetupDlgData->GetMarginTopLeft(); // correctly returns (2,25)
		// because I set the left margin to 100 thousandths of an inch in the basic config file
	wxUnusedVar(marginTopLeft); // whm 21Jan2015 avoid warning

    wxPrintPreview *preview = new wxPrintPreview(pAIPrOut, new AIPrintout(printTitle), & printDialogData);
	
	// End BEW fiddles 20Oct14
	
	//// the following call is pre-6.5.5 - Bill and Kevin's code
    //wxPrintPreview *preview = new wxPrintPreview(new AIPrintout(previewTitle),
	//								new AIPrintout(printTitle), & printDialogData);
    if (!preview->Ok())
    {
		if (preview != NULL) // whm 11Jun12 added NULL test
	        delete preview;
		wxString msg = _T(
		"There was a problem previewing.\nPerhaps your current printer is not set correctly?");
        // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
        pApp->m_bUserDlgOrMessageRequested = TRUE;
        wxMessageBox(msg,_T("Previewing"), wxICON_WARNING | wxOK);
        pApp->LogUserAction(msg);
		return;
    }

	gbIsBeingPreviewed = TRUE; // from MFC's OnPreparePrinting()

    // Note: If we ever want to use it, an AIPreviewFrame object can be created using the
    // currently commented out class AIPreviewFrame, which is derived from wxPreviewFrame
    // (see AIPrintout.h). It could be used so we can get access to wxPreviewFrame's
    // OnCloseWindow method.
    //wxPreviewFrame *frame = new AIPreviewFrame(preview, pApp->GetMainFrame(),
    //                _T("Adapt It Print Preview"), wxPoint(100, 100), wxSize(600, 650));

    // Since we freeze the canvas against screen updates, we may as well size the preview
    // frame to fully cover the canvas in the main window.
	CMainFrame* pFrame = pApp->GetMainFrame();

	// whm 10July2022 modified after Bruce noted that the compose bar was being opened during a Print Preview
	// operation, thus reducing the size of the modal Preview window. It is probably best to have the Preview
	// window created to be the same size at the main frame window.
	// Hence:
	// The previewPosition.x can remain calculated as previously - moving it right by thickness of frame.
	// The previewPosition.y, should be changed upward to simply be the upper left position of the overall main frame,
	// instead of the canvasPosition.
	// The frameClientSize calculation should then be the size of the overall main frame.
	// Since the composebar is automatically opening its height includes the height of the compose bar.
	wxSize frameClientSize = pFrame->GetSize(); // GetClientSize();
	// The controlbar is always visible on the main frame
	//wxSize controlbarSize = pFrame->m_pControlBar->GetSize();
	wxPoint framePosition = pFrame->GetPosition();
	//wxPoint canvasPosition = pFrame->canvas->GetPosition();
	wxPoint previewPosition = framePosition; //wxPoint previewPosition = framePosition + canvasPosition;
	previewPosition.x += wxSystemSettings::GetMetric(wxSYS_FRAMESIZE_X); // move to the
														// right by thickness of frame
	//previewPosition.y += controlbarSize.y; // move the preview down just below the toolbar
	CAIPrintPreviewFrame *frame = new CAIPrintPreviewFrame(pApp, preview, pApp->GetMainFrame(),
								previewTitle, previewPosition, frameClientSize);
	//wxPreviewFrame *frame = new wxPreviewFrame(preview, pApp->GetMainFrame()
	//							previewTitle, previewPosition, frameClientSize);
    // We positioned the preview frame explicitly, so don't call Centre() here
#if wxCHECK_VERSION(3, 0, 0) // whm added 10Oct2016
    // WX3.0 print sample uses a modality
    frame->InitializeWithModality(m_previewModality);
#else
    frame->Initialize();
#endif
    frame->Show();
	// klb 9/2011 : hide glosses if necessary
	if (bHideGlosses == TRUE)
		frame->HideGlossesOnClose( TRUE);
	if (bHideFreeTranslations == TRUE)
		frame->HideFreeTranslationsOnClose( TRUE);
	// whm note: The preview window is closed automatically
	// when the user exits/closes the preview window.
}

/////////////////////////////////////////////////////////////////////////////////
/// \return     FALSE if the document is empty, otherwise TRUE
/// \param      nTotalStripCount        -> total number of strips
/// \param      nPagePrintingLength     -> the length of a printed page between top and
//                                          bottom margins expressed in logical units
/// \remarks
/// Called from: AIPrintout::OnPreparePrinting(), and the View's SetupRangePrintOp().
/// Determines the number of strips that will fit on a page (using the current width
/// between left and right margins), and stores the offsets and strip counts for each page
/// in a list of pOffsets it stores in the App's list of PageOffsets.
/////////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItView::PaginateDoc(const int nTotalStripCount, const int nPagePrintingLength)
{
	//wxLogDebug(_T("PaginateDoc() START"));
	CAdapt_ItApp* pApp = &wxGetApp();
	CLayout* pLayout = GetLayout();

    // whm Observations: PaginateDoc() basically uses the existing indices for the App's
    // strip count as the max number of strips to be paginated into pages, and determines
    // how many pages it will take to print the document. whm Notes: The MFC version
    // paginates the document and lays it out for print preview and printing to fit the
    // page, regardless of the size of the main window of the application. The MFC version
    // also assumes negative offsets. The wx version also paginates the document and lays
    // it out for print preview and printing to fit the printed page, but it keeps the map
    // mode as wxMM_TEXT, scales the output to fit the print/print preview display context,
    // and uses positive offsets instead of negative offsets.
	//
	POList* pList = &pApp->m_pagesList;
	ClearPagesList(); // start with an empty list
	PageOffsets* pOffsets = NULL;
	// Note: RecalcLayout was previously called with the appropriate dc width
	int nMaxStrips = nTotalStripCount;
	if(nMaxStrips <= 0)
	{
        // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
        pApp->m_bUserDlgOrMessageRequested = TRUE;
        wxMessageBox(_T("Error: Cannot paginate an empty document."),_T(""),
			wxICON_EXCLAMATION | wxOK);
		return FALSE;
	}

    // BEW 5Oct11: Note, the mode (glossing, or free trans), if either are to be printed,
    // must have been switched prior to control entering here - eg. in InitDialog() of
    // PrintOptionsDlg, and if not done, the pagination will be wrong (strip height too
    // small)

	int pageCount = 0;
	// strip "height" here includes the vertical space preceding it for navText display
	//
	// BEW 5Oct11, if coming here from  the OnOK() handler of the PrintOptionsDlg,
	// gbIsPrinting is still TRUE, but the GetStripHeight() call will just grab the old
	// value of the strip height before the user had a chance to click of either or both
	// of the checkboxes in the PrintOptionsDlg. So we have to explicitly call pLayout's
	// SetStripHeight() now, so that the values of gbCheckInclGlossesText and
	// gbCheckInclFreeTransText can be used to calculate the appropriate strip height (if
	// this is not done, the relevant data is not printed, but the line where it would be
	// printed remains empty, and so more strips don't get into the page)
	pLayout->SetPileAndStripHeight();
	int nStripHeightWithLeading = pLayout->GetCurLeading() + pLayout->GetStripHeight();
    // The nPagePrintingLength passed in represents the height of the printed page between
    // the top and bottom margins (in logical units).
	int nMaxHeightPerPage = nPagePrintingLength; // the page height between top and
												 // bottom margins in logical units

	int nAccumStripHeightThisPage = 0;
	int nStripCountRunningTotal = 0;
	int nFirstStripOnPage = 0;
    // loop to process pages until we've processed all the strips that need processing
	// BEW 11Jul09, added boolean because if a PageOffset was just closed off when one
	// strip remains to be processed, the loop exits with nAccumStripHeightThisPage reset
	// to 0, and then the block following the loop is not entered, so extra help is needed
	// in that block's test to ensure it gets entered in this circumstance
	bool bJustClosedOff = FALSE;
	while (nStripCountRunningTotal < nMaxStrips)
	{
		if (nAccumStripHeightThisPage + nStripHeightWithLeading > nMaxHeightPerPage)
		{
			// can't fit the next strip on this page so create a PageOffset page and save
            // its starting and ending strip offsets
			pOffsets = new PageOffsets;

			pOffsets->nTop = ((CStrip*)
				(*pLayout->GetStripArray())[nFirstStripOnPage])->Top();
			pOffsets->nBottom = ((CStrip*)
				(*pLayout->GetStripArray())[nStripCountRunningTotal - 1])->Top()
				+ ((CStrip*)(*pLayout->GetStripArray())[nStripCountRunningTotal - 1])->Height();

			pOffsets->nFirstStrip = nFirstStripOnPage;
			pOffsets->nLastStrip = nStripCountRunningTotal - 1; // store index
			pageCount++;
			pList->Append(pOffsets); // store the page information

			// prepare for the next iteration of the loop
			nFirstStripOnPage = nStripCountRunningTotal; // index for first strip
														 // of next PageOffsets instance
			nAccumStripHeightThisPage = 0;
			bJustClosedOff = TRUE;
		}
		else
		{
            // The next strip fits on this page so continue adding strips.
			nAccumStripHeightThisPage += nStripHeightWithLeading;
			bJustClosedOff = FALSE;
 			nStripCountRunningTotal++;

			//CStrip* pStrip = (CStrip*)(*pLayout->GetStripArray())[nStripCountRunningTotal - 1];
			//wxLogDebug(_T("CORRECT: Strip[ %d ]     Pile count:  %d"), pStrip->GetStripIndex(), pStrip->GetPilesArray()->GetCount());
		}
	}

	// BEW added to this test on 11July09, for the reason see comments above the loop above
	if (nAccumStripHeightThisPage > 0 || (bJustClosedOff &&
		((CStrip*)pLayout->GetStripArray()->Last())->GetStripIndex() == nFirstStripOnPage))
	{
		// there is material for one final (partial) page
		pOffsets = new PageOffsets;

		pOffsets->nTop = ((CStrip*)
			(*pLayout->GetStripArray())[nFirstStripOnPage])->Top();
		pOffsets->nBottom = ((CStrip*)
			(*pLayout->GetStripArray())[nStripCountRunningTotal - 1])->Top()
			+ ((CStrip*)(*pLayout->GetStripArray())[nStripCountRunningTotal - 1])->Height();

		pOffsets->nFirstStrip = nFirstStripOnPage;
		pOffsets->nLastStrip = nStripCountRunningTotal - 1;
		pageCount++;
		pList->Append(pOffsets); // store the page information
	}
	wxASSERT(pageCount == (int)pList->GetCount());
	//wxLogDebug(_T("PaginateDoc() END"));
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \remarks
/// Called from: The View's PaginateDoc() and AIPrintout's OnPreparePrinting() and its
/// destructor. ClearPagesList() is a helper function which simply deletes the list of page
/// offset structs from the POList called m_pagesList on the App.
/////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItView::ClearPagesList()
{
	CAdapt_ItApp* pApp = &wxGetApp();
	POList* pList = &pApp->m_pagesList;
	if (pList->GetCount() == 0)
	{
		return;
	}
	else
	{
		POList::Node* pos_pList = pList->GetFirst();
		while(pos_pList != NULL)
		{
			// whm note: PageParams and PageOffsets are similar structs
			// (PageParams has an extra member at the end of the struct called nPageNumber.
			// MFC version of code below casts the pList pointers to (PageParams*) but
			// the pList was originally filled with (PageOffsets*) pointers.
			// In MFC it doesn't complain, but in a wxList the pointers it
			// contains are strongly typed, so I'm casting them instead to
			// (PageOffsets*) which is really what was stored in this POList by the
			// PaginateDoc() function above.
			PageOffsets* pOffsets = (PageOffsets*)pos_pList->GetData();
			pos_pList = pos_pList->GetNext();
			if (pOffsets != NULL)
			{
				delete pOffsets;
			}
		}
		pList->Clear();
	}
}

/////////////////////////////////////////////////////////////////////////////////
/// \return     always TRUE in the wx version (FALSE in the MFC version only if a memory
//               error occurrs)
/// \param      pSaveList       <- a SPList to store all items originally in pOriginalList
/// \param      pOriginalList   <- list of Source phrase items of which only a sublist remain
///                                 at the end of the GetSubList operation
/// \param      nBeginSequNum   -> the first list item composing the intended sub list
/// \param      nEndSequNum     -> the last item composing the intended sub list
/// \remarks
/// Called from: the View's SetupRangePrintOp() function and
/// AIPrintout::OnPreparePrinting(). GetSublist() first removes any existing list items
/// from pSaveList, then it copies all list items from pOriginalList into pSaveList; then
/// removes all items from pOriginalList; and adds back to pOriginalList only those source
/// phrases from pSaveList that are within the range nBeginSequNum to nEndSequNum. Finally
/// GetSublist() updates the indices related to printing of sublists.
///
/// Refactored BEW 16Jul09 to support the refactored view where CPile instances are owned
/// not by their strips which contain them, but by an m_pileList member in CLayout.
/// Accesses to partner piles will not work right when dealing with a shallow copy sublist
/// of CSourcePhrase instances unless the subrange of partner piles is moved also to a
/// sublist and the partner CSourcePhrase instances are renumbered in the sublist using
/// UpdateSequNumbers() -- which itself has been modified to accept the sublist pointer as
/// a second parameter.
/// BEW 14Nov11, refactored to do deep copies, rather than shallow; because we do deep
/// copies there are ramifications:
/// (i)Any RecalcLayout() call will use the create_strips_and_piles enum value,
/// (ii) We won't need to store or restore CLayout's pile list. We'll recreate it on
/// demand by passing create_strips_and_piles to RecalcLayout()
/////////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItView::GetSublist(SPList* pSaveList, SPList* pOriginalList, int nBeginSequNum,
							   int nEndSequNum)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	CLayout* pLayout = GetLayout();
	bool bOK = TRUE;
	wxASSERT(pOriginalList->GetCount() > 0); // ensure the list is not empty
	wxASSERT(nBeginSequNum >= 0 && nEndSequNum >= nBeginSequNum); // ensure valid start and end values
	wxASSERT(nEndSequNum < (int)pOriginalList->GetCount()); // make sure both sequence numbers are in range

	m_pDoc->DeleteSourcePhrases(pSaveList, TRUE); // TRUE means 'delete any partner piles too
												  // (it won't matter if there aren't any)
	// copy the original list of CSourcePhrase instances in m_pSourcePhrases to the saveList
	// wxList doesn't support appending one list onto another so do it manually
	int countOriginals = pOriginalList->GetCount();
	bOK = DeepCopySourcePhraseSublist(pOriginalList, 0, countOriginals - 1, pSaveList); // copies full list
	// destroy the originals in m_pSourcePhrases
	m_pDoc->DeleteSourcePhrases(pOriginalList, TRUE); // TRUE means 'delete partner piles too'

    // deep copy across to pOriginalList the pointers to the CSourcePhrase instances which
    // are wanted for the sublist
    bOK = DeepCopySourcePhraseSublist(pSaveList, nBeginSequNum, nEndSequNum, pOriginalList);

	// inhibit printing the phrase box when printing a sublist, and store the active
	// sequence number for later one when RestoreOriginalList() is called in order to set
	// up the m_pSourcePhrases and m_pileList lists again, after range printing or
	// seletion printing is finished (the destructor ~AIPrintout()does this call)
	pApp->m_nSaveActiveSequNum = pApp->m_nActiveSequNum;
	pApp->m_nActiveSequNum = -1;

    // to make our refactored view code work correctly, the sequence numbers in the
    // CSourcePhrase instances now in m_pSourcePhrases have to be renumbered from zero, to
    // maintain the partnering of each CSourcePhrase with the CPile which points to it (the
    // second parameter for UpdateSequNumbers() is strictly speaking not needed, because
    // the only time we use it it points to m_pSourcePhrases anyway, but it's probably a
    // good idea to retain it to make the code a bit better at self-documenting what is
    // happening)
	pApp->GetDocument()->UpdateSequNumbers(0,pOriginalList);

	// inform RecalcLayout() that it won't need to work out a gap for the phrase box
	pLayout->SetBoxInvisibleWhenLayoutIsDrawn(TRUE);

	return bOK;
}

/////////////////////////////////////////////////////////////////////////////////
/// \return     TRUE, but FALSE if there was a printer error or failure to restore the
///             original list of CSourcePhrase instances
/// \param      pSaveList      -> the (full) list of source phrase items to be moved to
///                                pOriginalList
/// \param      pOriginalList  <- the existing sublist which is to be abandoned and
///                                replaced by the contents of pSaveList
/// \remarks
/// Called from: the AIPrintout's destructor. RestoreOriginalList() is called to restore
/// the original contents of the document's m_pSourcePhrases, after printing the document.
/// During the print operation, the original list from m_pSourcePhrases was stored/saved in
/// pSaveList. RestoreOriginalList() also restores the original active sequence number value
///
/// BEW changed 16Jul09, to support the refactored view code's design. CPile instances are
/// owned by CLayout, not by CStrip, and so for a range print or a selection print, we
/// needed to have separately stored in CLayout::m_pSavePileList the original list of
/// piles, so that CLayout::m_pileList can store just shallow copies of the range of
/// partner piles we need to deal with. After renumbering the m_nSequNumber member of the
/// subset of CSourcePhrase instances, RecalcLayout() will work correctly with what
/// appears to it to be a suddenly shorter, but valid, document. Then RestoreOriginalList
/// has to restore the original document state, putting back both the full set of
/// CSourcePhrase instances, and their partner piles. A call to UpdateSequNumbers() to
/// renumber them from the first CSourcePhrase instance is mandatory, because the shallow
/// copies will have had their m_nSequNumber values reset so that the first in the
/// subrange is 0, and that means a subrange of the original ones will have their sequence
/// number values reset to wrong values. So call UpdateSequNumbers(0) to get everything
/// back as it should be.
/// BEW 14Nov11, print chapter/verse range was not working (all platforms). So I've changed
/// to using deep copies. This means I don't need to save the layout's PileList, and the
/// pile list is recreated by the RecalcLayout() call passin in create_strips_and_piles
/////////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItView::RestoreOriginalList(SPList* pSaveList,SPList* pOriginalList)
// when called, pSaveList has the original (full) list, and pOriginalList has the sublist
// which we wish to abandon in the process of restoring the normal state
{
	CAdapt_ItApp* pApp = &wxGetApp();
	CLayout* pLayout = GetLayout();
	bool bOK = TRUE;

	// BEW changed 21Jul09: it can happen that this function is entered before the culling
	// of a range print's CSourcePhrases to just those needed for printing the range (and
	// the originals saved in m_pSaveList). One scenario I found for this was to do a
	// normal print, specify a range, and turn on and then off a checkbox such as the one
	// for suppressing a preceding header, then click Print to have the print go ahead,
	// but then when the physical print's Print Settings dialog shows, Cancel at that
	// point. The wxWidgets framework correctly calls ~AIPrintout() which is one of the
	// places where the DoPrintCleanup() function is called, and then because
	// gbPrintingRange is TRUE, RestoreOriginalList() is entered - but pOriginalPileList
	// still has the full list of the document's piles, and pSavePileList is empty. So we
	// have to test for this scenario and when we have such a situation, detect it and
	// just return TRUE immediately because there is no restoration required
	if (!pOriginalList->IsEmpty() && pSaveList->IsEmpty())
		return TRUE;

	wxASSERT(pSaveList->GetCount() > 0); // ensure the list is not empty
    // If the list is empty, which may happen if there is a range error, we don't want to
	// copy an empty pSaveList back over a populated pOriginalList
	if (wxPrinter::GetLastError() == wxPRINTER_ERROR)
		return FALSE;

	m_pDoc->DeleteSourcePhrases(pOriginalList, TRUE); // TRUE means 'delete partner piles too'

	// deep copy the saved list back to the original list (i.e. to m_pSourcePhrases list)
	int countOriginals = pSaveList->GetCount();
	bOK = DeepCopySourcePhraseSublist(pSaveList, 0, countOriginals - 1, pOriginalList);
	wxCHECK_MSG(bOK, FALSE, _T("RestoreOriginalList(): DeepCopySourcePhraseSublist() failed, line 4027 in Adapt_ItView.cpp, so the document won't have been restored to its original pre-print state. Shut down WITHOUT saving, and relaunch"));
	// restore the former active sequ number; CSourcePhrase m_nSequNumber values are
	// already correct
	pApp->m_nActiveSequNum = pApp->m_nSaveActiveSequNum;

	// renumber, to get m_nSequNumber members into the correct sequence again (the second
	// parameter for UpdateSequNumbers() is strictly speaking not needed, because the only
	// time we use it it points to m_pSourcePhrases anyway, but it's probably a good idea
	// to retain it to make the code a bit better at self-documenting what is happening)
	pApp->GetDocument()->UpdateSequNumbers(0,pOriginalList); // redundant, but harmless insurance

	// restore assumption that a gap will need to be calculated at the active pile when
	// RecalcLayout() is next called
	pLayout->SetBoxInvisibleWhenLayoutIsDrawn(FALSE);

	// the m_pSavedList contents are no longer needed, so delete them (no partner piles, so the
    // second param can be FALSE)
    m_pDoc->DeleteSourcePhrases(pSaveList, FALSE);

	// Note, with the 14Nov11 changes we have to call RecalcLayout() with create_strips_and_piles
	// rather than with create_strips_keep_piles
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////////
/// \return     the m_chapterVerse member of pSrcPhrase
/// \param pSrcPhrase -> the source phrase whose m_chapterVerse member is to be retrieved
/// \remarks
/// Called from: the App's RefreshStatusBarInfo(), the Doc's
/// ReconstituteAfterFilteringChange(), ReconstituteAfterPunctuationChange(), the View's
/// DoConsistencyCheck() and OnEditSourceText().
/// Gets and returns the m_chapterVerse member of pSrcPhrase.
/// 
/// whm revised 25Oct2022 to correct the logic when the phrasebox is located at
/// the first pile in the document - where m_nSequNumber is 0. The function was wrongly
/// returning a value of "0:0" even though there was a valid ch:vs reference in the first
/// source phrase of the document. It was missing that instance because the test and block 
/// at "if (nActiveSequNum > 0)" fails to check the m_chapterVerse member of the first 
/// source phrase in the document, i.e., at nActiveSequNum 0. To correct this fault,
/// I've added an "else if (nActiveSequNum == 0)" block below to correct the logic so
/// that a Chapter and Verse string in the first pile's source phrase gets checked.
/////////////////////////////////////////////////////////////////////////////////
wxString CAdapt_ItView::GetChapterAndVerse(CSourcePhrase *pSrcPhrase)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	CAdapt_ItView* pView = pApp->GetView();
	wxASSERT(pApp != NULL);
	wxString str; str.Empty();
	SPList* pList = pApp->m_pSourcePhrases;
	wxASSERT(pList);
	int nActiveSequNum = pSrcPhrase->m_nSequNumber;
	SPList::Node* pos_pList = pList->Item(nActiveSequNum); // get the position where this srcphrase is
	wxASSERT(pos_pList != NULL);

	// loop backwards until come to start of a verse or chapter
	str = _T("0:0"); // a "0:0" value is returned if the function was not able to obtain a ch:vs value
	if (nActiveSequNum > 0)
	{
		while (pos_pList != NULL)
		{
			CSourcePhrase* pSP = (CSourcePhrase*)pos_pList->GetData();
			pos_pList = pos_pList->GetPrevious(); // needed for our list
			if (pSP->m_bChapter || pSP->m_bVerse)
			{
				if (!pSP->m_chapterVerse.IsEmpty())
					str = pSP->m_chapterVerse;
				wxASSERT(!str.IsEmpty());
				break;
			}
		}
	}
	else if (nActiveSequNum == 0) // whm 25Oct2022 added this else if block to check first source phrase in document
	{
		CSourcePhrase* pSP = pView->GetSrcPhrase(nActiveSequNum);
		if (pSP->m_bChapter || pSP->m_bVerse)
		{
			if (!pSP->m_chapterVerse.IsEmpty())
				str = pSP->m_chapterVerse;
			wxASSERT(!str.IsEmpty());
		}
	}
	return str;
}

/////////////////////////////////////////////////////////////////////////////////
/// \return     TRUE if a valid c:v scripture reference substring has been constructed
///             in strChapVerse, else FALSE
/// \param      pList               -> a list of CSourcePhrase pointer instances (either
///                                    the current document, or a list constructed from
///                                    parsing in an XML document and storing in a
///                                    temporary SPList)
/// \param      pStartingSrcPhrase  -> pointer to the CSourcePhrase instance which defines
///                                    the current location relative to which we wish to
///                                    return the best possible (and nearest) ch:verse
///                                    substring
/// \param      strChapVerse        <- a scripture reference (minus the book code and
///                                    following space) in the form "Chapter:Verse" for
///                                    example "13:25"; or an empty string if the function
///                                    fails
/// \remarks
/// Called from: the View's SendScriptureReferenceFocusMessage(). Gets the current verse's
/// ch:v substring, or at least tries to do the best possible job of it that it can. The
/// pSrcPhrase defines a location (ie. a given sequence number) in the passed in pList of
/// CSourcePhrase instances (if looking in an active document, pList will be
/// pDoc->m_pSourcePhrases; but if scanning through a set of adaptation documents stored on
/// disk, pList will be a temporary SPList created for holding the list returned by parsing
/// in the XML (or *.adt) document file cryptically). First the function checks pSrcPhrase
/// for a non-empty m_chapterVerse member, if it finds it it puts it into strChapVerse and
/// we are done. If not, then the active location may be within a verse - so the function
/// scans back in pList to find the nearst previous pSrcPhrase instance with a non-empty
/// m_chapterVerse - returning that if it finds one; but if pSrcPhrase is near the start of
/// the document, there might be no previous such instance, so it then scans forward from
/// the passed in pSrcPhrase's location to get the nearest following non-empty
/// m_chapterVerse, and returns that. This algorithm means that we get a valid scripture
/// reference substring even if the active location is in something such as a subheading
/// part of the adaptation document (ie. information marked by \s). But if scanning both
/// backwards and forwards yields no non-empty m_chapterVerse member, we assume the
/// document was not created from a (U)SFM marked plain text source text file, and return
/// FALSE so that the caller will block sending an invalid scripture reference focus
/// message, or responding to one by looking in the document being tested for the location
/// to scroll to.
/// Note: CSourcePhrase instances can store, in their m_chapterVerse member, a chapter
/// followed by colon followed by a verse range - something in the form "13:12-15", or even
/// "13:12,15". When a substring like this has been found. We do not return it 'as is', but
/// rather extract the chapter number, colon, and first verse of the range - the rest is
/// not used in a scripture reference focus broadcast message, so we never send it in one.
/// The work of setting a valid "ch:verse" substring is done by the
/// MakeChapVerseStrForSynchronizedScroll() function defined in MainFrame.cpp.
/////////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItView::GetChapterAndVerse(SPList* pList, CSourcePhrase* pStartingSrcPhrase,
									   wxString& strChapVerse)
{
	CSourcePhrase* pSrcPhrase = NULL;
	wxString chvStr = _T("");
	if (!pStartingSrcPhrase->m_chapterVerse.IsEmpty())
	{
        // this CSourcePhrase instance has a ch:verse or ch:verse_range string, so produce
        // the scripture reference ch:verse substring
		chvStr = MakeChapVerseStrForSynchronizedScroll(pStartingSrcPhrase->m_chapterVerse);
		strChapVerse = chvStr;
		return TRUE;
	}
    // there was no chapter:verse information in the passed in CSourcePhrase instance, so
    // search for it in the neighbourhood - preferably in the preceding neighbourhood, but
    // if not there, then in the following neighbourhood
	SPList::Node* pos_pList = pList->Item(pStartingSrcPhrase->m_nSequNumber);
	SPList::Node* savePos = pos_pList;
	if (pos_pList != NULL)
	{
		pSrcPhrase = (CSourcePhrase*)pos_pList->GetData(); // ignore this one, it is
													 // same as pStartingSrcPhrase
		pos_pList = pos_pList->GetPrevious();
		while (pos_pList != NULL)
		{
			pSrcPhrase = (CSourcePhrase*)pos_pList->GetData();
			pos_pList = pos_pList->GetPrevious();
			if (!pSrcPhrase->m_chapterVerse.IsEmpty())
			{
                // this CSourcePhrase instance has a ch:verse or ch:verse_range string, so
                // produce the scripture reference ch:verse substring
				chvStr = MakeChapVerseStrForSynchronizedScroll(pSrcPhrase->m_chapterVerse);
				strChapVerse = chvStr;
				return TRUE;
			}
		}
		// didn't find it in the previous neighbourhood, so try again looking ahead instead
		pos_pList = savePos;
		pSrcPhrase = (CSourcePhrase*)pos_pList->GetData(); // ignore this one, it is
													 // same as pStartingSrcPhrase
		pos_pList = pos_pList->GetNext();
		while (pos_pList != NULL)
		{
			pSrcPhrase = (CSourcePhrase*)pos_pList->GetData();
			pos_pList = pos_pList->GetNext();
			if (!pSrcPhrase->m_chapterVerse.IsEmpty())
			{
                // this CSourcePhrase instance has a ch:verse or ch:verse_range string, so
                // produce the scripture reference ch:verse substring
				chvStr = MakeChapVerseStrForSynchronizedScroll(pSrcPhrase->m_chapterVerse);
				strChapVerse = chvStr;
				return TRUE;
			}
		}
		// if control reaches here, then there was no c:v information to be had,
		// so return FALSE
		strChapVerse = chvStr;
		return FALSE; // could not find pSrcPhrase's location in the pList list
	}
	else
	{
		strChapVerse = chvStr;
		return FALSE; // could not find pSrcPhrase's location in the pList list
	}
}

/////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \param      pList		->	a list of CSourcePhrase pointer instances (either the current
///                             document, or a list constructed from parsing in an XML document
///                             and storing in a temporary SPList)
/// \param      pSrcPhrase	->	pointer to the CSourcePhrase instance which defines the current
///                             location
/// \remarks
/// Called from: the CPhraseBox::MoveToNextPile() function.
/// This is the function which does the work of determining if a scripture reference focus
/// message needs to be sent, for the current location as defined by where pSrcPhrase
/// happens to be in the document's pList (the list could be pDoc->m_pSourcePhrases, or a
/// tempory SPList pointer used for checking a document not currently open). Internally,
/// the function checks the global CStrings: m_OldChapVerseStr and gCurChapVerseStr, and if
/// these are not different then a message is not sent; but if they are, then the message
/// will be sent provided the global bool pApp->m_bIgnoreScriptureReference_Send is FALSE (the
/// function call needs to be wrapped by an if (!pApp->m_bIgnoreScriptureReference_Send) test --
/// because the GUI command sets or clears this boolean). Also, internally the overloaded
/// version of the GetChapterAndVerse() function, which returns TRUE if successful and
/// FALSE otherwise, is called - and if FALSE is returned then no message is sent. If the
/// current document has no (U)SFM markup, or no 3-letter book code at the start of the
/// pList entries, then the latter function will return FALSE and so no message will ever
/// be sent for a document file which is not built from a properly constituted and marked
/// up scripture text file.
/////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItView::SendScriptureReferenceFocusMessage(SPList* pList, CSourcePhrase* pSrcPhrase)
{
    CAdapt_ItApp* pApp = &wxGetApp();
    wxASSERT(pList != NULL);
	wxASSERT(pSrcPhrase != NULL);
	wxString strChVerse = _T("");
	bool bAllIsOK = GetChapterAndVerse(pList, pSrcPhrase, strChVerse);
	if (!bAllIsOK)
	{
		return; // don't send any message
	}
	if (pApp->m_OldChapVerseStr == strChVerse)
	{
        // the currently found scripture reference substring does not differ from that in
        // the last sent message, so don't resend it
		return;
	}
    // so are all is well, next, try to get the 3-letter code for the scripture book - the
    // function for doing this returns FALSE if the code does not exist, or is invalid. The
    // code returned is upper case always (the function forces this internally)
	wxString strBookCode = _T("");
	bool bValidCode = Get3LetterCode(pList,strBookCode);
	if (!bValidCode)
	{
		// the code is either invalid or is not in the document, so we cannot send a valid
		// sync message
		return;
	}
    // we have a valid substring, and the reference is different than for the last one, so
    // send it (but this function won't be called if the global
    // pApp->m_bIgnoreScriptureReference_Send is TRUE, so if control has got to here, then the
    // global is FALSE and sending is wanted by the user)
	SyncScrollSend(strBookCode, strChVerse);

	// finally, update the global wxString which remembers what the this chap:verse
	// reference was
    pApp->m_OldChapVerseStr = strChVerse;
}

/////////////////////////////////////////////////////////////////////////////////
/// \return     TRUE if we have chapter:verse form, FALSE if the document has no chapters
/// \param      s               <- a wxString representing the source phrase's m_chapterVerse member
/// \param      nChapter        <- an int representing the chapter number
/// \param      nVerse          <- an int representing the verse number (or 1st verse in a range); 0 if
///                                no verses are indicated
/// \param      bHasChapters    <- a bool TRUE if chapter numbers are present FALSE otherwise
/// \param      bIsVerseRange   <- a bool TRUE if there is a range of verses indicated, FALSE otherwise
/// \param      nFinalVerse     <- an int representing the final verse in a range
/// \remarks
/// Called from: the View's SetupRangePrintOp().
/// The usual form for s's contents is n:m where n is a chapter number, and m a verse
/// number, and bIsVerseRange will be set to FALSE; - s is a reference to the source
/// phrase's m_chapterVerse member. However, the contents could be just a verse number (eg.
/// Book without chapters, such as 2John etc), or n:p-q (for a range of verses), or n:p,q
/// (an alternative style for a range) so for the standard situation we set nChapter to n,
/// nVerse to m, and return TRUE; but for a book with no chapters we return FALSE, and
/// nVerse will have the verse number, or 0 if there are no verses; for the range
/// possibilities nVerse will have p the first verse in the range, nFinalVerse will have q
/// (the end verse in the range), and bIsVerseRange will be set to TRUE.
/////////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItView::ExtractChapterAndVerse(wxString& s,int& nChapter,int& nVerse,
							bool& bHasChapters,bool& bIsVerseRange,int& nFinalVerse)
{
	bHasChapters = FALSE;
	bIsVerseRange = FALSE;
	nFinalVerse = 0;
	nChapter = 0;
	nVerse = 0;
	wxString chStr;
	wxString vStr;
	chStr.Empty();
	vStr.Empty();
	wxChar colon = _T(':');
	bool bIsOK = TRUE;
	int nHasChapters = s.Find(colon);
	if (nHasChapters > -1)
	{
		bHasChapters = TRUE;
		chStr = s.Left(nHasChapters);
		wxASSERT(!chStr.IsEmpty());
	}
	if (bHasChapters)
	{
		nChapter = wxAtoi(chStr);
		vStr = s.Mid(nHasChapters + 1);
	}
	else
	{
		// has no chapters, so string must only be a verse number, or number range
		vStr = s;
	}
	wxASSERT(!vStr.IsEmpty());
	if (vStr.IsEmpty())
		return FALSE; // error, so ignore this chap/verse string
	wxString tempStr = vStr;

	// now determine the verse, or verse range
	wxChar hyphen = _T('-');
	wxChar comma = _T(',');
	wxString leftStr;
	wxString rightStr;
	leftStr.Empty();
	rightStr.Empty();
	int	  nHyphenOffset = -1;
	int   nCommaOffset =  vStr.Find(comma);
	if (nCommaOffset == -1)
	{
		// has no comma in the string, so test now for a hyphen
		nHyphenOffset =  vStr.Find(hyphen);
		if (nHyphenOffset == -1)
		{
			// doesn't have a hyphen in the string, so it should only be a verse number
			nVerse = wxAtoi(vStr); // reads digits only until first non-digit, so safe
			//ASSERT(nVerse > 0 && nVerse <= 176); // bible verses are between 1 and about 176
												 // as in (Psalm 119)
            //for version 2.0.5 and onward, we'll allow any value for max verse number,
            //since document may not be scripture, but nevertheless be versified for use by
            //Adapt It eg. film script
			return bIsOK;
		}
		else
		{
			// does have a hyphen, so there must be a range
			bIsVerseRange = TRUE;
			leftStr = vStr.Left(nHyphenOffset);
			wxASSERT(leftStr.Length() > 0);
			nVerse = wxAtoi(leftStr);
			rightStr = vStr.Mid(nHyphenOffset + 1);
			wxASSERT(rightStr.Length() > 0);
			nFinalVerse = wxAtoi(rightStr);
			return bIsOK;
		}
	}
	else
	{
		// has a comma, so there must be a range
		bIsVerseRange = TRUE;
		leftStr = vStr.Left(nCommaOffset);
		wxASSERT(leftStr.Length() > 0);
		nVerse = wxAtoi(leftStr);
a:		rightStr = tempStr.Mid(nCommaOffset + 1);
		wxASSERT(rightStr.Length() > 0);
		// there might be more - continue till we find the final substring in p,q,r,s etc
		nCommaOffset = rightStr.Find(comma);
		if (nCommaOffset > -1)
		{
			// we are not at the rightmost one yet, so iterate
			tempStr = tempStr.Mid(nCommaOffset + 1);
			wxASSERT(tempStr.Length() > 0);
			goto a;
		}
		nFinalVerse = wxAtoi(rightStr);
		return bIsOK;
	}
}

/////////////////////////////////////////////////////////////////////////////////
/// \return     the source phrase's m_nSequNumber which has the start of a section heading
/// \param      nStartingSequNum    -> an int representing the starting sequence number
/// \param      startingPos         <- an SPList node representing the starting position in pList
/// \param      pList               <- the source phrase list (not referenced directly, only via
///                                    the startingPos node)
/// \remarks
/// Called from: the View's SetupRangePrintOp().
/// Scans backwards from the starting position looking for a source phrase with a section
/// head marker indicating that it is the start of a preceding section heading.
/////////////////////////////////////////////////////////////////////////////////
int CAdapt_ItView::IncludeAPrecedingSectionHeading(int nStartingSequNum, SPList::Node* startingPos,
												   SPList* WXUNUSED(pList))
{
	// whm revised 15Feb05 to include all markers of sectionHead textType
	CAdapt_ItApp* pApp = &wxGetApp();
	int nOldSN = nStartingSequNum;
	SPList::Node* pos_pList = startingPos;
    // whm Note: since startingPos is a node already pointing into pList, pList doesn't
    // here need to be explicitly referenced, just call pos_pList->GetData() to return the
    // pSrcPhrase at pos_pList in pList.
	CSourcePhrase* pSrcPhrase = (CSourcePhrase*)pos_pList->GetData();
	pos_pList = pos_pList->GetPrevious();
	wxASSERT(pSrcPhrase);
	CAdapt_ItDoc* pDoc = GetDocument();
	wxString markerStr;
	wxString nonFilteredMkrs;

	while (pos_pList != NULL)
	{
		pSrcPhrase = pos_pList->GetData();
		pos_pList = pos_pList->GetPrevious();
		wxASSERT(pSrcPhrase);

		if (!pSrcPhrase->m_chapterVerse.IsEmpty())
		{
            // we have come to the start of a preceding verse without encountering any
            // section heading
			break;
		}

        // it is not possible for a section heading to be within a merged source phrase, so
        // we do not need to check for medial markers; so just check contents of the
        // m_markers attribute
		if (!pSrcPhrase->m_markers.IsEmpty())
		{
			// whm added 14Feb05 in support of USFM and SFM Filtering
			markerStr = pSrcPhrase->m_markers;
			nonFilteredMkrs = pDoc->GetUnFilteredMarkers(markerStr);
			// NormalizeToSpaces leaves the markers in m_markers delimited by spaces, at
			// lease medially. We'll use the wxStringTokenizer method here.
			wxString sfm;
			wxStringTokenizer tkz(markerStr,_T(" ")); // BEW 21Jul14, ZWSP support: keep this as latin space

			while (tkz.HasMoreTokens())
			{
				sfm = tkz.GetNextToken();
				if (sfm[0] == gSFescapechar)	// Only check actual sfms. Some
                    // tokens will be only numbers (those after \c and \v) which we ignore
				{
					sfm.Trim(TRUE); // trim right end
					sfm.Trim(FALSE); // trim left end
					// BEW 21Jul14, ZWSP support: keep this as latin space
					sfm += _T(' '); // ensure the sfm is followed by a space
                                        // for unique find in our wrap strings.
					// If only one of the sfms within m_markers is a wrap
					// marker, we should return TRUE.
					switch (pApp->gCurrentSfmSet)
					{
						case UsfmOnly:
						{
							if (pApp->UsfmSectionHeadMarkersStr.Find(sfm) != -1)
								// there is a section marker, so we have found the
								// start of a section heading
								return pSrcPhrase->m_nSequNumber;
							break;
						}
						case PngOnly:
						{
							if (pApp->PngSectionHeadMarkersStr.Find(sfm) != -1)
								// there is a section marker, so we have found the
								// start of a section heading
								return pSrcPhrase->m_nSequNumber;
							break;
						}
						case UsfmAndPng:
						{
							if (pApp->UsfmAndPngSectionHeadMarkersStr.Find(sfm) != -1)
								// there is a section marker, so we have found the
								// start of a section heading
								return pSrcPhrase->m_nSequNumber;
							break;
						}
						default:
						{
							// if we got here it would be a program error
							if (pApp->UsfmSectionHeadMarkersStr.Find(sfm) != -1)
								return pSrcPhrase->m_nSequNumber;
						}
					} // end of switch (pApp->gCurrentSfmSet)
				}
			}
		}
	}
	// if we get here, we couldn't find a preceding section heading
	return nOldSN;
}

/////////////////////////////////////////////////////////////////////////////////
/// \return     FALSE if the range op fouled up, otherwise TRUE
/// \param      nBeginSequNum     -> sequence number for the first CSourcePhrase in the range
/// \param      nEndSequNum       -> sequence number for the last CSourcePhrase in the range
/// \param      pPrintData        -> the printer's wxPrintData struct, filled out <<- unused
///                                     we get the value directly from the app (see below)
/// \remarks
/// Called from: view's DoRangePrintOp(); and in the Linux build only, called from a function
/// to handle the printing of a range of pages -- because the page range support in wxGnomeprinter
/// is broken; so we have to get a range print done similarly to the way Bill coded for a
/// chapter/verse range -- the latter converts chapter/verse bounds to sequence numbers for
/// range begining and end, and then uses those; so this DoRangePrintOp() function handles
/// the job from that point onwards. Our __WXGTK__ build function can then call it.
/// NOTE: this function must be entered only once per entrance later on to DoPrintCleanup(),
/// otherwise, double entry but only one cleanup would result in part of the document
/// being lost, and probably a crash
/////////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItView::DoRangePrintOp(const int nRangeStartSequNum, const int nRangeEndSequNum,
                                   wxPrintData* WXUNUSED(pPrintData))
{
    CAdapt_ItApp* pApp = &wxGetApp();
	CLayout* pLayout = GetLayout();
	SPList* pList = pApp->m_pSourcePhrases;
	SPList* pSaveList = pApp->m_pSaveList;

	// we have the required range of sequence numbers, so we can reuse the selection code here
	bool bIsOK = GetSublist(pSaveList, pList, nRangeStartSequNum, nRangeEndSequNum);

	// recalc the layout with the shorter range masquerading as the whole document
#ifdef _NEW_LAYOUT
	pLayout->RecalcLayout(pList, create_strips_and_piles);
#else
	pLayout->RecalcLayout(pList, create_strips_and_piles);
#endif

	// hide the box, and set safe values for a non-active location (leave m_targetPhrase
	// untouched)
	pApp->m_pActivePile = NULL;
	pApp->m_nActiveSequNum = -1;
	// wm: I don't think the phrase box needs to be hidden here

	// The stuff below could go into a separate function -
	// see also CPrintOptionsDlg::InitDialog
	// Determine the length of the printed page in logical units.
	int pageHeightBetweenMarginsMM; // pageWidthBetweenMarginsMM; // not used
	wxSize paperSize_mm;
	paperSize_mm = pApp->pPgSetupDlgData->GetPaperSize();
	wxASSERT(paperSize_mm.x != 0);
	wxASSERT(paperSize_mm.y != 0);
     // We should also have valid (non-zero) margins stored in our pPgSetupDlgData object.
	wxPoint topLeft_mm, bottomRight_mm; // MFC uses CRect for margins, wx uses wxPoint
	topLeft_mm = pApp->pPgSetupDlgData->GetMarginTopLeft(); // returns  top (y)
								// and left (x) margins as wxPoint in milimeters
	bottomRight_mm = pApp->pPgSetupDlgData->GetMarginBottomRight(); // returns bottom (y)
								// and right (x) margins as wxPoint in milimeters
	wxASSERT(topLeft_mm.x != 0);
	wxASSERT(topLeft_mm.y != 0);
	wxASSERT(bottomRight_mm.x != 0);
	wxASSERT(bottomRight_mm.y != 0);
    // The size data returned by GetPageSizeMM is not the actual paper size edge to edge,
    // nor the size within the margins, but it is the usual printable area of a paper,
    // i.e., the limit of where most printers are physically able to print; it is the area
    // in between the actual paper size and the usual margins. We therefore start with the
    // raw paperSize and determine the intended print area between the margins.
	//pageWidthBetweenMarginsMM = paperSize_mm.x - topLeft_mm.x - bottomRight_mm.x;
	pageHeightBetweenMarginsMM = paperSize_mm.y - topLeft_mm.y - bottomRight_mm.y;

    // Now, convert the pageHeightBetweenMarginsMM to logical units for use in calling
    // PaginateDoc.
    //
	// Get the logical pixels per inch of screen and printer.
    // whm NOTE: We can't yet use the wxPrintout::GetPPIScreen() and GetPPIPrinter()
    // methods because the wxPrintout object is not created yet at the time this print
    // options dialog is displayed. But, we can do the same calculations by using the
    // wxDC::GetPPI() method call on both a wxPrinterDC and a wxClientDC of our canvas.
	//
    // Set up printer and screen DCs and determine the scaling factors between printer and screen.
	wxASSERT(pApp->pPrintData->IsOk());

#if defined(__WXGTK__) // print-related
	// Linux requires we use wxPostScriptDC rather than wxPrinterDC
	// Note: If the Print Preview display is drawn with text displaced up and off the display on wxGTK,
	// the wxWidgets libraries probably were not configured properly. They should have included a
	// --with-gnomeprint parameter in the configure call.
	wxPostScriptDC printerDC(*pApp->pPrintData); // MUST use * here otherwise printerDC will not be initialized properly
#else
	wxPrinterDC printerDC(*pApp->pPrintData); // MUST use * here otherwise printerDC will not be initialized properly
#endif

	wxASSERT(printerDC.IsOk());
	wxSize printerSizePPI = printerDC.GetPPI(); // gets the resolution of the printer in pixels per inch (dpi)
	wxClientDC canvasDC(pApp->GetMainFrame()->canvas);
	wxSize canvasSizePPI = canvasDC.GetPPI(); // gets the resolution of the screen/canvas in pixels per inch (dpi)
	float scale = (float)printerSizePPI.GetHeight() / (float)canvasSizePPI.GetHeight();

    // Calculate the conversion factor for converting millimetres into logical units. There
    // are approx. 25.4 mm to the inch. There are ppi device units to the inch. Therefore 1
    // mm corresponds to ppi/25.4 device units. We also divide by the screen-to-printer
    // scaling factor, because we need to unscale to pass logical units to PaginateDoc.
	float logicalUnitsFactor = (float)(printerSizePPI.GetHeight()/(scale*25.4));
									// use the more precise conversion factor
	int nPagePrintingLengthLU; //, nPagePrintingWidthLU; // unused
	//nPagePrintingWidthLU = (int)(pageWidthBetweenMarginsMM * logicalUnitsFactor);
	nPagePrintingLengthLU = (int)(pageHeightBetweenMarginsMM * logicalUnitsFactor);
	// The stuff above could go into a separate function - see also CPrintOptionsDlg::InitDialog

	gnPrintingLength = nPagePrintingLengthLU; //nPrintingLength;

	// Footer adjustments and printing are done in the View's PrintFooter() function

	// do pagination
	//
    // whm: In the following call to PaginateDoc, we use the current m_nStripCount stored
    // on pBundle, because the PaginateDoc() call here is done within SetupRangePrintOp()
    // which is called after the print dialog has been dismissed with OK, and thus we are
    // paginating the actual doc to print and not merely simulating it for purposes of
    // getting the pages edit box values for the print options dialog.
	bIsOK = PaginateDoc(pLayout->GetStripArray()->GetCount(), nPagePrintingLengthLU);
													// doesn't call RecalcLayout()
	if (!bIsOK)
	{
		wxMessageBox(_T("Pagination failed."),_T(""), wxICON_STOP);
		return FALSE;
	}

	wxPrintDialogData printDialogData(*pApp->pPrintData);
	// pagination succeeded, so set the initial values
	int nTotalPages = pApp->m_pagesList.GetCount();
	printDialogData.SetMaxPage(nTotalPages);
	printDialogData.SetMinPage(1);
	printDialogData.SetFromPage(1);
	printDialogData.SetToPage(nTotalPages);

   return TRUE;
}

#if defined(__WXGTK__) // print-related
bool CAdapt_ItView::SetupPageRangePrintOp(const int nFromPage, int nToPage, wxPrintData* pPrintData)
{
    CAdapt_ItApp* pApp = &wxGetApp();
    POList* pList = &pApp->m_pagesList;
    int count;
    count = pList->GetCount();
    if (count < 1)
    {
        // there has to be a range
        return FALSE;
    }
    int nFromSequNum = -1;
    int nToSequNum = -1;
    // find the sequence number of the first pile in the top strip in the nFromPage
    // PageOffsets struct
    POList::Node* pos_pList = pList->Item(nFromPage - 1);
    PageOffsets* pPageOffsets = pos_pList->GetData();
    int nFirstStrip = pPageOffsets->nFirstStrip;
    CLayout* pLayout = pApp->GetLayout();
    wxArrayPtrVoid* pStrips = pLayout->GetStripArray();
    CStrip* pStrip = (CStrip*)pStrips->Item(nFirstStrip);
    CPile* pPile = pStrip->GetPileByIndex(0);
    CSourcePhrase* pSrcPhrase = pPile->GetSrcPhrase();
    nFromSequNum = pSrcPhrase->m_nSequNumber;
    wxASSERT(nFromSequNum >= (int)0 && nFromSequNum < (int)pApp->m_pSourcePhrases->GetCount());
    // find the sequence number of the last pile in the last strip in the nToPage
    // PageOffsets struct
    // BEWARE: pagination for the print options dialog was done on the assumption that if the
    // document has free translations and/or glosses, they'd be wanted, and they increase the
    // pages needed for printint the whole doc. If the user selects are range of pages, and also
    // deselects printing of free translations and/or glosses, we can arrive at a situation where
    // he gives a final page number which can never be reached, because with no free trans or
    // glosses the pages needed are fewer, and his choice for the last page may lie beyond the
    // last actual page. So here we must check how many we've got, and adjust the last value
    // smaller if necessary.
    if (nToPage > count)
    {
        nToPage = count;
    }

	pos_pList = pList->Item(nToPage - 1);
    pPageOffsets = pos_pList->GetData();
    int nLastStrip = pPageOffsets->nLastStrip;
    pStrip = (CStrip*)pStrips->Item(nLastStrip);
    wxArrayPtrVoid* pPilesArray = pStrip->GetPilesArray();
    int pileCount = pPilesArray->GetCount();
    pPile = pStrip->GetPileByIndex(pileCount - 1);
    pSrcPhrase = pPile->GetSrcPhrase();
    nToSequNum = pSrcPhrase->m_nSequNumber;
    wxASSERT(nToSequNum >= (int)0 && nToSequNum >= nFromSequNum && nToSequNum < (int)pApp->m_pSourcePhrases->GetCount());

    // get this range printed
    bool bOK = DoRangePrintOp(nFromSequNum, nToSequNum, pPrintData);
    return bOK;
}
#endif

/////////////////////////////////////////////////////////////////////////////////
/// \return     FALSE if the range could not be determined or found, otherwise TRUE
/// \param      nFromCh     -> an int representing the chapter at the beginning of the range
/// \param      nFromV      -> an int representing the verse at the beginning of the range
/// \param      nToCh       -> an int representing the chapter at the end of the range
/// \param      nToV        -> an int representing the verse at the end of the range
/// \param      pPrintData  -> (unused)
/// \param      bSuppressPrecedingHeadingInRange  -> (unused)
/// \param      bIncludeFollowingHeadingInRange   -> (unused)
/// \remarks
/// Called from: the View's OnPrint() high level handler after the standard print dialog's
/// OK button has been pressed. Determines the sequence numbers for the indicated chapter
/// and verse range and gets the appropriate sublist of source phrases making up that
/// range. From this data it calls RecalcLayout to format the printout for the correct
/// width, and PaginateDoc().
/// BEW 14Nov11, fixed errors in printing a chapter/verse range (errors on all platforms),
/// mainly by using deep copies for saving m_pSourcePhrases, and creating sublist
/// NOTE: this function must be entered only once per entrance later on to DoPrintCleanup(),
/// otherwise, double entry but only one cleanup would result in part of the document
/// being lost, and probably a crash. I removed the WXUNUSED() - Bill's code uses thse
/// 3 params.
/////////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItView::SetupRangePrintOp(const int nFromCh, const int nFromV, const int nToCh,
									  const int nToV, wxPrintData* pPrintData,
									  bool WXUNUSED(bSuppressPrecedingHeadingInRange),
									  bool WXUNUSED(bIncludeFollowingHeadingInRange))
//bool CAdapt_ItView::SetupRangePrintOp(const int nFromCh, const int nFromV, const int nToCh,
//									  const int nToV, wxPrintData* pPrintData,
//									  bool bSuppressPrecedingHeadingInRange,
//									  bool bIncludeFollowingHeadingInRange)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	//CLayout* pLayout = GetLayout();
	pPrintData = pPrintData; // to avoid a spurious compiler warning

	// whm revised 8Mar08 to correct logic of tests for range inclusion
	if (pApp->m_selectionLine != -1)
		RemoveSelection();
	SPList* pList = pApp->m_pSourcePhrases;
	//SPList* pSaveList = pApp->m_pSaveList;
	wxASSERT(nFromCh >= 0);
	wxASSERT(nToCh >= 0);
	wxASSERT(nFromV >= 1);
	wxASSERT(nToV >= 1);
	wxASSERT(nToCh >= nFromCh);

	// check we have a legal range
	if (nFromCh < 0 || nToCh < 0 || nToCh < nFromCh || nToV < 1 || nFromV < 1)
	{
		// IDS_ILLEGAL_RANGE
        // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
        pApp->m_bUserDlgOrMessageRequested = TRUE;
        wxMessageBox(_("Sorry, the range you specified is illegal. Try again."),
		_T(""), wxICON_EXCLAMATION | wxOK);
		return FALSE;
	}
	else if (nFromCh == nToCh && nToV < nFromV)
	{
		// IDS_ILLEGAL_RANGE
        // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
        pApp->m_bUserDlgOrMessageRequested = TRUE;
        wxMessageBox(_("Sorry, the range you specified is illegal. Try again."),
		_T(""), wxICON_EXCLAMATION | wxOK);
		return FALSE;
	}

	int nCh = 0;
	int nV = 0;
	bool bIsVRange = FALSE;
	bool bHasChapters = FALSE;
	int nFinalV = 0;
	SPList::Node* posEnd = NULL;
	SPList::Node* savePos = NULL;

	// find the beginning and ending sequence numbers for the range
	CSourcePhrase* pSrcPhrase = (CSourcePhrase*)NULL;
	SPList::Node* pos_pList = pList->GetFirst();
	while (pos_pList != NULL)
	{
		savePos = pos_pList;
		pSrcPhrase = (CSourcePhrase*)pos_pList->GetData();
		pos_pList = pos_pList->GetNext();
		wxASSERT(pSrcPhrase != NULL);
		wxString chv = pSrcPhrase->m_chapterVerse;
		if (chv.IsEmpty())
			continue;
		else
		{
			// we are at the start of a verse - see if it is where we want to start
			bool bOK = ExtractChapterAndVerse(chv,nCh,nV,bHasChapters,bIsVRange,nFinalV);

            // if something went wrong, just ignore the chapter and verse - and hope it
            // wasn't the range start!
			if (!bOK)
				continue;
			else
			{
				// test what we found
				if (bHasChapters)
				{
					if (nCh != nFromCh)
						continue;
					else
					{
						// we are in the wanted chapter, so test the verse values
						if (bIsVRange)
						{
							// for a verse range, start printing here if the verse falls within
							// the verse range
							if (nFromV >= nV && nFromV <= nFinalV)
							{
								// we have found the start of the printing range, so check for a
								// preceding section heading, and include it if the suppression
								// flag is not TRUE
								int nCurSequNumber = pSrcPhrase->m_nSequNumber;
								SPList::Node* oldPos = savePos; // the position of the current source
														   // phrase
								if (!gbSuppressPrecedingHeadingInRange)
								{
									nCurSequNumber = IncludeAPrecedingSectionHeading(
														nCurSequNumber, oldPos, pList);
								}

								// set the global for the sequence number of the start of the range
								gnRangeStartSequNum = nCurSequNumber;
								goto b;
							}
							else
								continue; // iterate
						}
						else
						{
							// it's not a range, so see if the verse number matches this one
							if (nFromV == nV)
							{
								// we have found the start of the printing range, so check for a
								// preceding section heading, and include it if the suppression
								// flag is not TRUE
								int nCurSequNumber = pSrcPhrase->m_nSequNumber;
								SPList::Node* oldPos = savePos;	// the position of the current source
																// phrase
								if (!gbSuppressPrecedingHeadingInRange)
								{
									nCurSequNumber = IncludeAPrecedingSectionHeading(
																nCurSequNumber, oldPos, pList);
								}

								// set the global for the sequence number of the start of the
								// printing range
								gnRangeStartSequNum = nCurSequNumber;
								goto b;
							}
							else
								continue; // iterate
						}
					}
				}
				else
				{
                    // does not have chapters, so all we can test for is verses (ignore
                    // chapter number if the user typed one in the dialog, provided it is 0
                    // or 1)
					if (nFromCh > 1)
					{
						// IDS_NO_CHAPTERS
                        // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
                        pApp->m_bUserDlgOrMessageRequested = TRUE;
                        wxMessageBox(_(
"Error: a chapter number was specified, but this document does not appear to contain chapter specifications. The print operation has been aborted."),
						_T(""), wxICON_STOP);
						return FALSE; // error condition, non-zero chapter number,
									  // but doc has no chapters
					}
					else
					{
						// try test the verse now, since chapter number is either 0 or 1 & is
						// being ignored
						if (bIsVRange)
						{
							// for a verse range, start printing here if the verse falls within
							// the verse range
							if (nFromV >= nV && nFromV <= nFinalV)
							{
								// we have found the start of the printing range, so check for a
								// preceding section heading, and include it if the suppression
								// flag is not TRUE
								int nCurSequNumber = pSrcPhrase->m_nSequNumber;
								SPList::Node* oldPos = savePos; // the position of the current source
														   // phrase
								if (!gbSuppressPrecedingHeadingInRange)
								{
									nCurSequNumber = IncludeAPrecedingSectionHeading(
															nCurSequNumber, oldPos, pList);
								}

								// set the global for the sequence number of the start of the range
								gnRangeStartSequNum = nCurSequNumber;
								goto b;
							}
							else
								continue; // iterate
						}
						else
						{
							// it's not a range, so see if the verse number matches this one
							if (nFromV == nV)
							{
								// we have found the start of the printing range, so check for a
								// preceding section heading, and include it if the suppression
								// flag is not TRUE
								int nCurSequNumber = pSrcPhrase->m_nSequNumber;
								SPList::Node* oldPos = savePos; // the position of the current source
														   // phrase
								if (!gbSuppressPrecedingHeadingInRange)
								{
									nCurSequNumber = IncludeAPrecedingSectionHeading(
															nCurSequNumber, oldPos, pList);
								}

								// set the global for the sequence number of the start of the range
								gnRangeStartSequNum = nCurSequNumber;
								goto b;
							}
							else
								continue; // iterate
						}
					}
				}
			}
		}
	}

	// if we get here, we didn't find the start of the range - this is an error condition,
	// so abort the print
	//IDS_RANGE_START_FAILURE
    // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
    pApp->m_bUserDlgOrMessageRequested = TRUE;
    wxMessageBox(_(
"Error: the specified chapter and verse for the start of the printing range could not be found. The print operation has been aborted."),
	_T(""), wxICON_STOP);
	return FALSE;

	// now continue searching for the end of the printing range
	// first check in case the end chapter and end verse is the same as the start ones
b:	if (bHasChapters)
	{
		if (nCh != nToCh)
			goto d; // end chapter is different from starting one, so keep looking
		else
		{
			// we are in the wanted chapter, so test the verse values
			if (bIsVRange)
			{
				// for a verse range, end printing here if the verse falls within the verse range
				if (nToV >= nV && nToV <= nFinalV)
				{
					// we have found the end of the printing range, so set the global
					GetVerseEnd(pos_pList,savePos,pList,posEnd);
					wxASSERT(posEnd != NULL);
					pSrcPhrase = (CSourcePhrase*)posEnd->GetData();
					gnRangeEndSequNum = pSrcPhrase->m_nSequNumber;
					goto e;
				}
				else
					goto d; // keep looking
			}
			else
			{
				// it's not a range, so see if the verse number matches this one
				if (nToV == nV)
				{
					// we have found the end of the printing range, so set the global
					GetVerseEnd(pos_pList,savePos,pList,posEnd);
					wxASSERT(posEnd != NULL);
					pSrcPhrase = (CSourcePhrase*)posEnd->GetData();
					gnRangeEndSequNum = pSrcPhrase->m_nSequNumber;
					goto e;
				}
				else
					goto d; // keep looking
			}
		}
	}
	else
	{
        // does not have chapters, so all we can test for is verses (ignore chapter number
        // if the user typed one in the dialog, provided it is 0 or 1)
		if (nToCh > 1)
		{
			// IDS_NO_CHAPTERS
            // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
            pApp->m_bUserDlgOrMessageRequested = TRUE;
            wxMessageBox(_(
"Error: a chapter number was specified, but this document does not appear to contain chapter specifications. The print operation has been aborted."),
			_T(""), wxICON_STOP);
			return FALSE; // error condition, non-zero or non-1 chapter number,
						  // but doc has no chapters
		}
		else
		{
			// try test the verse now, since chapter number is either 0 or 1 & is being ignored
			if (bIsVRange)
			{
				// for a verse range, end printing here if the verse falls within the verse range
				if (nToV >= nV && nToV <= nFinalV)
				{
					// we have found the end of the printing range, so set the global
					GetVerseEnd(pos_pList,savePos,pList,posEnd);
					wxASSERT(posEnd != NULL);
					pSrcPhrase = (CSourcePhrase*)posEnd->GetData();
					gnRangeEndSequNum = pSrcPhrase->m_nSequNumber;
					goto e;
				}
				else
					goto d; // keep looking
			}
			else
			{
				// it's not a range, so see if the verse number matches this one
				if (nToV == nV)
				{
					// we have found the end of the printing range, so set the global
					GetVerseEnd(pos_pList,savePos,pList,posEnd);
					wxASSERT(posEnd != 0);
					pSrcPhrase = (CSourcePhrase*)posEnd->GetData();
					gnRangeEndSequNum = pSrcPhrase->m_nSequNumber;
					goto e;
				}
				else
					goto d; // keep looking
			}
		}
	}

d:	;

	while (pos_pList != 0)
	{
		pSrcPhrase = (CSourcePhrase*)pos_pList->GetData();
		pos_pList = pos_pList->GetNext();
		wxASSERT(pSrcPhrase != NULL);
		wxString chv = pSrcPhrase->m_chapterVerse;
		if (chv.IsEmpty())
			continue;
		else
		{
			// we are at the start of a verse - see if it is where we want to end the printing
			bool bOK = ExtractChapterAndVerse(chv,nCh,nV,bHasChapters,bIsVRange,nFinalV);

			// if something went wrong, just ignore the chapter and verse - and hope it wasn't
			// the range end!
			if (!bOK)
				continue;
			else
			{
				// test what we found
				if (bHasChapters)
				{
					if (nCh != nToCh)
						continue;
					else
					{
						// we are in the wanted chapter, so test the verse values
						if (bIsVRange)
						{
							// for a verse range, end printing here if the verse falls within
							// the verse range
							if (nToV >= nV && nToV <= nFinalV)
							{
								// we have found the end of the printing range, so set the global
								GetVerseEnd(pos_pList,savePos,pList,posEnd);
								wxASSERT(posEnd != 0);
								pSrcPhrase = (CSourcePhrase*)posEnd->GetData();
								gnRangeEndSequNum = pSrcPhrase->m_nSequNumber;
								goto e;
							}
							else
								continue; // iterate
						}
						else
						{
							// it's not a range, so see if the verse number matches this one
							if (nToV == nV)
							{
								// we have found the end of the printing range, so set the global
								GetVerseEnd(pos_pList,savePos,pList,posEnd);
								wxASSERT(posEnd != 0);
								pSrcPhrase = (CSourcePhrase*)posEnd->GetData();
								gnRangeEndSequNum = pSrcPhrase->m_nSequNumber;
								goto b;
							}
							else
								continue; // iterate
						}
					}
				}
				else
				{
                    // does not have chapters, so all we can test for is verses (ignore
                    // chapter number if the user typed one in the dialog, provided it is 0
                    // or 1)
					if (nToCh > 1)
					{
						// IDS_NO_CHAPTERS
                        // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
                        pApp->m_bUserDlgOrMessageRequested = TRUE;
                        wxMessageBox(_(
"Error: a chapter number was specified, but this document does not appear to contain chapter specifications. The print operation has been aborted."),
						_T(""), wxICON_STOP);
						return FALSE; // error condition, non-zero chapter number,
									  // but doc has no chapters
					}
					else
					{
						// try test the verse now, since chapter number is either 0 or 1 & is
						// being ignored
						if (bIsVRange)
						{
							// for a verse range, end printing here if the verse falls within
							// the verse range
							if (nToV >= nV && nToV <= nFinalV)
							{
								// we have found the end of the printing range, so set the global
								GetVerseEnd(pos_pList,savePos,pList,posEnd);
								wxASSERT(posEnd != NULL);
								pSrcPhrase = (CSourcePhrase*)posEnd->GetData();
								gnRangeEndSequNum = pSrcPhrase->m_nSequNumber;
								goto e;
							}
							else
								continue; // iterate
						}
						else
						{
							// it's not a range, so see if the verse number matches this one
							if (nToV == nV)
							{
								// we have found the end of the printing range, so set the global
								GetVerseEnd(pos_pList,savePos,pList,posEnd);
								wxASSERT(posEnd != NULL);
								pSrcPhrase = (CSourcePhrase*)posEnd->GetData();
								gnRangeEndSequNum = pSrcPhrase->m_nSequNumber;
								goto e;
							}
							else
								continue; // iterate
						}
					}
				}
			}
		}
	}

    // if we get here, we didn't find the end of the range - this is an error condition, so
    // abort the print
	// IDS_RANGE_END_FAILURE
    // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
    pApp->m_bUserDlgOrMessageRequested = TRUE;
    wxMessageBox(_(
"Error: the specified chapter and verse for the end of the printing range could not be found. The print operation has been aborted."),
	_T(""), wxICON_STOP);
	return FALSE;

	// we have the required range of sequence numbers, so we can reuse the selection code here
e:	;
    bool bIsOk = DoRangePrintOp(gnRangeStartSequNum, gnRangeEndSequNum, pPrintData);
    return bIsOk;

}

// whm revised 15Feb05 to include all markers of sectionHead textType
void CAdapt_ItView::GetVerseEnd(SPList::Node*& curPos,SPList::Node*& precedingPos,
								SPList* WXUNUSED(pList),SPList::Node*& preLastPos)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	SPList::Node* pos_pList = curPos;
	wxASSERT(curPos != 0);
	CSourcePhrase* pSrcPhrase = NULL;
	SPList::Node* lastPos;
	preLastPos = precedingPos;
	int count = 0;
	CAdapt_ItDoc* pDoc = GetDocument();
	wxString markerStr;
	wxString nonFilteredMkrs;
	while (pos_pList != 0)
	{
		lastPos = pos_pList;
		pSrcPhrase = (CSourcePhrase*)pos_pList->GetData();
		pos_pList = pos_pList->GetNext();
		if (pSrcPhrase == 0)
			break; // break out if we are at the end of the document
		count++;

		// if a following section heading is not wanted, check for it here & break early
		// if one is found
		if (!gbIncludeFollowingHeadingInRange)
		{
			// it is not possible for a section heading to be within a merged source phrase, so
			// we do not need to check for medial markers; so just check contents of the
			// m_markers attribute
			if (!pSrcPhrase->m_markers.IsEmpty())
			{
				// whm added 14Feb05 in support of USFM and SFM Filtering
				markerStr = pSrcPhrase->m_markers;
				nonFilteredMkrs = pDoc->GetUnFilteredMarkers(markerStr);
				// NormalizeToSpaces leaves the markers in m_markers delimited by spaces, at
				// lease medially. We'll use the Tokenize CString method here.
				wxString sfm;
				wxStringTokenizer tkz(markerStr,_T(" ")); // BEW 21Jul14, ZWSP support: keep this as latin space

				while (tkz.HasMoreTokens())
				{
					sfm = tkz.GetNextToken();
					if (sfm[0] == gSFescapechar)	// Only check actual sfms. Some tokens will be only
													// numbers (those after \c and \v) which we ignore
					{
						sfm.Trim(TRUE); // trim right end
						sfm.Trim(FALSE); // trim left end
						// BEW 21Jul14, ZWSP support: keep this as latin space
						sfm += _T(' '); // ensure the sfm is followed by a space for unique find in
											// our wrap strings.
						// If only one of the sfms within m_markers is a wrap marker, we should return TRUE.
						switch (pApp->gCurrentSfmSet)
						{
							case UsfmOnly:
							{
								if (pApp->UsfmSectionHeadMarkersStr.Find(sfm) != -1)
									// there is a section marker, so we have found the place to end the printing range
									return; // preLastPos value is the value the caller wants
								break;
							}
							case PngOnly:
							{
								if (pApp->PngSectionHeadMarkersStr.Find(sfm) != -1)
                                    // there is a section marker, so we have found the
                                    // place to end the printing range
									return; // preLastPos value is the value the caller wants
								break;
							}
							case UsfmAndPng:
							{
								if (pApp->UsfmAndPngSectionHeadMarkersStr.Find(sfm) != -1)
									// there is a section marker, so we have found the
									// place to end the printing range
									return; // preLastPos value is the value the caller wants
								break;
							}
							default:
							{
								// if we got here it would be a program error
								if (pApp->UsfmSectionHeadMarkersStr.Find(sfm) != -1)
									return; // preLastPos value is the value the caller wants
							}
						} // end of switch (pApp->gCurrentSfmSet)
					}
				}
			}
		}

        // for safety, in a text with no verse numbering, we'll break from the loop after
        // 300 iterations
		if (pSrcPhrase->m_chapterVerse.IsEmpty() && count < 300)
		{
			preLastPos = lastPos;
			continue;
		}
		else
			break;
	}
}

/////////////////////////////////////////////////////////////////////////////////
/// \return		nothing
/// \param      event   -> the wxUpdateUIEvent that is generated when the View Menu is about
///                         to be displayed
/// \remarks
/// Called from: The wxUpdateUIEvent mechanism when the associated menu item is selected, and before
/// the menu is displayed.
/// Enables the "Units of Measurement..." item on the View menu. This menu item is always enabled.
/////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItView::OnUpdateUnits(wxUpdateUIEvent& event)
{
	event.Enable(TRUE);
}

void CAdapt_ItView::OnUnits(wxCommandEvent& WXUNUSED(event))
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	pApp->LogUserAction(_T("Initiated OnUnits()"));
	CUnitsDlg dlg(pApp->GetMainFrame());
	dlg.Centre();
	if (dlg.ShowModal() == wxID_OK)
	{
		// The App's m_bIsInches is set in the CUnitsDlg::OnOK() handler
		;
	}
}

/////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \param      pDC     -> the display context (either print preview, or actual physical printer
/// \param      fitRect -> the rectangle representing the area of the page enclosed by the page margins
/// \param      logicalUnitsFactor -> represents the factor that must be multipled by any linear
///             measurement such as the half inch (12.7mm) that a footer is displaced below fitRect's
///             bottom margin, in order to convert that linear measurement into logical units for
///             correct positioning in the different display contexts
/// \param      page -> the page currently being rendered
/// \remarks
/// Called from: AIPrintout::OnPrintPage(). Composes the text of the footer and draws it at the footer
/// position of the rendered page.
/// BEW 12Nov11, the __GTK__ build does not calculate a correct fitRect param, and so locating the
/// footer a half inch below the bottom of the fitRect would result in the footer being anywhere -
/// mostly off page! The PrintFooter() function for the __GTK__ build takes in parameters for the
/// margin sizes (in pixels, that is logical coords), and the paper (not page) dimensions - again in
/// pixels, and from those we internally constuct a local fitRect based on the paper size - and then
/// we calculate the footer location as a half inch higher than the bottom of the paper.
/////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItView::PrintFooter(wxDC* pDC, wxRect fitRect, float logicalUnitsFactor, int page)
{
    // whm Note: This function's signature has been revised for the wx version. The fitRect
    // parameter is the rectangle that comprises the printing area within the page's
    // margins; its dimensions are in logical units which will differ depending on whether
    // the footer is being drawn on the print preview display context, or on an actual
    // higher resolution printer dc. The logicalUnitsFactor parameter represents the factor
    // that must be multipled by any linear measurement such as the half inch (12.7mm) that
    // a footer is displaced below fitRect's bottom margin, in order to convert that linear
    // measurement into logical units for correct positioning in the different display
    // contexts.

	// get document and app pointers
	CAdapt_ItApp* pApp = &wxGetApp();
	CAdapt_ItDoc* pDoc = GetDocument();
	wxString strPageNum;
	strPageNum = strPageNum.Format(_T("%d"),page);
	wxString tgtName = pApp->m_pKB->m_targetLanguageName;
	wxString srcName = pApp->m_pKB->m_sourceLanguageName;

    // get the filename for the document (include the range if we are printing a
    // chapter/verse range)
	wxString strDocName = pDoc->GetFilename();	// get the name of the document (actually filename,
												// with extension. GetFilename() returns the whole
												// absolute path, so just get the name + ext)
	wxFileName fn(strDocName);
	strDocName = fn.GetFullName();
	wxString strLeft;
	wxString strLeftPlusPageNum;
	if (pApp->m_bPrintingRange)
	{
		strLeft = strLeft.Format(_T("%s/%s  %s   %d:%d to %d:%d"),
			srcName.c_str(),tgtName.c_str(),strDocName.c_str(),
			gnFromChapter,gnFromVerse,gnToChapter,gnToVerse);
		strLeftPlusPageNum = strLeftPlusPageNum.Format(_T("  %s/%s  %s   %d:%d to %d:%d   %d"),
			srcName.c_str(),tgtName.c_str(),strDocName.c_str(),
			gnFromChapter,gnFromVerse,gnToChapter,gnToVerse,page);
	}
	else
	{
		strLeft = strLeft.Format(_T("%s/%s  %s"),
			srcName.c_str(),tgtName.c_str(),strDocName.c_str());
		strLeftPlusPageNum = strLeftPlusPageNum.Format(_T("  %s/%s  %s   %d"),
			srcName.c_str(),tgtName.c_str(),strDocName.c_str(),page);
	}

	// create a 12 point size copy of the system font, colour black
	wxFont* pFont;
	pFont = new wxFont(*wxNORMAL_FONT);
	pFont->SetPointSize(10);
	pFont->SetWeight(wxFONTWEIGHT_BOLD);
	pDC->SetTextForeground(*wxBLACK);
	pDC->SetFont(*pFont);

	// Get the date & time file was last modified on the RHS, if not created yet, use the
	// current system time instead.

    // whm 21Oct07 updated local time calculations below to account for change in Visual
    // Studio from 2003 to 2005. In the process I discovered that CTime::Format already
    // formats the time as local rather than UTC, so no specific call to GetLocalTm is now
    // necessary with its changed parameter behavior between VS 2003 and 2005. whm wx
    // version comment: theTime doesn't need to be initialized, but it doesn't hurt.
    // It is set to the file's modification date/time below.
	wxDateTime theTime = wxDateTime::Now(); //initialize to the current time
	wxString path = pApp->m_curAdaptationsPath + pApp->PathSeparator + strDocName;
	bool bExists;
	bExists = ::wxFileExists(path) && !::wxDirExists(path);
	if (bExists)
	{
		wxFileName fn(path);
		theTime = fn.GetModificationTime(); // use the file's last modified date & time
	}
	wxString timeStr;
	timeStr = theTime.Format(_T("%a, %b %d, %H:%M, %Y")).c_str();

	/*
	// The following code captures the logic for doing a centered header if we decide
	// to print one.
	wxString headerStr = _T("This is a test header");
    // scaling has been done and upper left margin intersection is now 0,0, so we can set
    // coordinates for DrawText based on that reference point in terms of screen
    // coordinates. See AIPrintout::OnPrintPage() for how logicalUnitsFactor is calculated.
	int headerXExt,headerYExt;
	pDC->GetTextExtent(headerStr,&headerXExt,&headerYExt);
    // Position the header 12.7mm (a half inch) above the top margin (the top of fitRect).
    // Since the logical origin is at 0,0, we need to add the fitRect.x position
    // (fitRect.GetLeft()) to xPosHdr. We also calculate in the vertical text extent of the
    // header so that there is 12.7mm of space between the bottom of the header text and
    // the printing margin below it.
	float xPosHdr = (float)(fitRect.GetLeft())+(fitRect.GetWidth()/2.0 - (float)headerXExt/2.0);
	float yPosHdr = (float)(fitRect.GetTop()-12.8*logicalUnitsFactor-headerYExt);
    // Draw header a half inch above top margin. This will be a negative y-axis component
    // because we called SetLogicalOrigin() above on the AIPrintout's DC so that its origin
    // is at the intersection of the top and left page margins. Above this origin is
    // negative y-axis coordinates.
	pDC->DrawText(headerStr, (long)xPosHdr, (long)yPosHdr); // draw header a half inch
															// above top margin
	*/

    // whm 6Apr2016 added the following first block for when the "Footer includes only the 
    // page number" option in the PrintOptionsDlg 
    if (gbPrintOnlyPgNumInFooter == TRUE)
    {
        wxString pageNumStr = _T("");
        pageNumStr = pageNumStr.Format(_T("%d"), page);
        int headerXExt, headerYExt;
        pDC->GetTextExtent(pageNumStr, &headerXExt, &headerYExt);
        // Position the footer 12.7mm (a half inch) below the bottom margin.
        float yPosFtr = (float)(fitRect.GetBottom() + 12.7*logicalUnitsFactor); // y position is same
        int xPosPageNum = fitRect.GetLeft() + fitRect.GetWidth() / 2; // don't worry
                                                                      // about adjusting for x extent of the page number
        pDC->DrawText(pageNumStr, (long)xPosPageNum, (long)yPosFtr);
    }
    else
    {

        // Calculate the position for the footer. The incoming parameter fitRect represents the
        // rectangular printing area within the margins in logical units. The bottom of fitRect
        // is the effective bottom margin, so we'll place the footer 12.7mm (a half inch) in
        // logical units below the bottom of fitRect. Since the logical origin is at 0,0 of the
        // page, we need to add the fitRect.x position (fitRect.GetLeft()) to xPosFtr. In
        // calculating the position of yPosFtr, however, fitRect.GetBottom() returns
        // coordinates in reference to 0,0. See AIPrintout::OnPrintPage() for how
        // logicalUnitsFactor is calculated.
        // BEW added 21Jul09 because '2' is not two spaces of width, but 2 pixels, so need
        // something bigger - otherwise for a range, end of range is too close to page number
        int wXExt; int wYExt;
        pDC->GetTextExtent(_T("W"), &wXExt, &wYExt);
        // Bill's legacy code
        int footerXExt, footerYExt;
        pDC->GetTextExtent(strLeft, &footerXExt, &footerYExt);
        float yPosFtr = (float)(fitRect.GetBottom() + 12.7*logicalUnitsFactor); // y position is same
                                                            // for all segments of the footer
        float xPosFtrLeft = (float)fitRect.GetLeft();
        int timeXExt, timeYExt;
        pDC->GetTextExtent(timeStr, &timeXExt, &timeYExt);
        if (footerXExt + 2 * wXExt >= fitRect.GetWidth() / 2)
        {
            pDC->GetTextExtent(strLeftPlusPageNum, &footerXExt, &footerYExt);
            // The strLeft (language names and file name) extends past the middle point of the
            // footer, so we will not try to draw the page number centered in the footer, but
            // will just add a couple spaces and the page number to the end of strLeft.
            // The timeStr should fit in the right-hand side of the footer, unless the language
            // names and/or file name are extremently long. Check to see if the time string
            // will fit.
            if (footerXExt + timeXExt + 2 * wXExt > fitRect.GetWidth()) // allow 2 W widths
                                                            // between footerXExt and timeXExt
            {
                // There is not enough space for the timeStr to fit on the footer between
                // margins, so we'll position the left part a little higher and draw the time
                // part one line height lower than the left part.
                pDC->DrawText(strLeftPlusPageNum, (long)xPosFtrLeft, (long)yPosFtr - timeYExt / 2);
                int xPosTimeStr = fitRect.GetRight() - timeXExt;
                pDC->DrawText(timeStr, (long)xPosTimeStr, (long)yPosFtr + timeYExt / 2);
            }
            else
            {
                // There is enough space for the timeStr to fit
                pDC->DrawText(strLeftPlusPageNum, (long)xPosFtrLeft, (long)yPosFtr);
                int xPosTimeStr = fitRect.GetRight() - timeXExt;
                pDC->DrawText(timeStr, (long)xPosTimeStr, (long)yPosFtr);
            }
        }
        else
        {
            // There is enough room to draw the page number in the middle of the footer
            pDC->DrawText(strLeft, (long)xPosFtrLeft, (long)yPosFtr);
            int xPosPageNum = fitRect.GetLeft() + fitRect.GetWidth() / 2; // don't worry
                                // about adjusting for x extent of the page number
            pDC->DrawText(strPageNum, (long)xPosPageNum, (long)yPosFtr);
            int xPosTimeStr = fitRect.GetRight() - timeXExt;
            pDC->DrawText(timeStr, (long)xPosTimeStr, (long)yPosFtr);
        }
    }

	// delete pFont for no memory leaks
	if (pFont != NULL) // whm 11Jun12 added NULL test
		delete pFont;
}

#if defined(__WXGTK__) // print-related
void  CAdapt_ItView::PrintFooter(wxDC* pDC, wxPoint marginTopLeft, wxPoint marginBottomRight, wxPoint paperDimensions,
                float logicalUnitsFactor, int page)
{
    // whm Note: This function's signature has been revised for the wx version. The fitRect
    // parameter is the rectangle that comprises the printing area within the page's
    // margins; its dimensions are in logical units which will differ depending on whether
    // the footer is being drawn on the print preview display context, or on an actual
    // higher resolution printer dc. The logicalUnitsFactor parameter represents the factor
    // that must be multipled by any linear measurement such as the half inch (12.7mm) that
    // a footer is displaced below fitRect's bottom margin, in order to convert that linear
    // measurement into logical units for correct positioning in the different display
    // contexts.

	// get document and app pointers
	CAdapt_ItApp* pApp = &wxGetApp();
	CAdapt_ItDoc* pDoc = pApp->GetDocument();
	wxString strPageNum;
	if (pApp->m_bPrintingPageRange)
	{
	    // add the page offset, so the page numbers are what the user chose
	    page += pApp->m_userPageRangeStartPage - 1;
	}
	strPageNum = strPageNum.Format(_T("%d"),page);
	wxString tgtName = pApp->m_pKB->m_targetLanguageName;
	wxString srcName = pApp->m_pKB->m_sourceLanguageName;

	wxRect fitRect;
	fitRect.x = 0;
	fitRect.y = 0;
	fitRect.SetWidth(paperDimensions.x - marginTopLeft.x - marginBottomRight.x);
	fitRect.SetHeight(paperDimensions.y - marginTopLeft.y); // full paper height less the top margin
        // because the caller's SetLogicalOrigin(0,0) puts origin at intersect of left & top margins
	//fitRect.SetHeight(paperDimensions.y); // full paper height
	// remember this is a bigger rectangle than for Win or Mac, the latter two use the page
	// rectangle (which excludes the margins) -- so below we must subtract a half-inch's
	// worth of pixels from the fitRect's bottom to get the yCoord of the footer location
#if defined(Print_failure)
		wxLogDebug(_T("fitRect from paper size & margin settings; x %d  y %d , width %d  height %d"),
			fitRect.GetX(), fitRect.GetY(), fitRect.GetWidth(), fitRect.GetHeight());
#endif
    // get the filename for the document (include the range if we are printing a
    // chapter/verse range)
	wxString strDocName = pDoc->GetFilename();	// get the name of the document (actually filename,
												// with extension. GetFilename() returns the whole
												// absolute path, so just get the name + ext)
	wxFileName fn(strDocName);
	strDocName = fn.GetFullName();
	wxString strLeft;
	wxString strLeftPlusPageNum;
	if (pApp->m_bPrintingRange)
	{
		strLeft = strLeft.Format(_T("%s/%s  %s   %d:%d to %d:%d"),
			srcName.c_str(),tgtName.c_str(),strDocName.c_str(),
			gnFromChapter,gnFromVerse,gnToChapter,gnToVerse);
		strLeftPlusPageNum = strLeftPlusPageNum.Format(_T("  %s/%s  %s   %d:%d to %d:%d   %d"),
			srcName.c_str(),tgtName.c_str(),strDocName.c_str(),
			gnFromChapter,gnFromVerse,gnToChapter,gnToVerse,page);
	}
	else
	{
		strLeft = strLeft.Format(_T("%s/%s  %s"),
			srcName.c_str(),tgtName.c_str(),strDocName.c_str());
		strLeftPlusPageNum = strLeftPlusPageNum.Format(_T("  %s/%s  %s   %d"),
			srcName.c_str(),tgtName.c_str(),strDocName.c_str(),page);
	}

	// create a 12 point size copy of the system font, colour black
	wxFont* pFont;
	pFont = new wxFont(*wxNORMAL_FONT);
	pFont->SetPointSize(10);
	pFont->SetWeight(wxFONTWEIGHT_BOLD);
	pDC->SetTextForeground(*wxBLACK);
	pDC->SetFont(*pFont);

	// Get the date & time file was last modified on the RHS, if not created yet, use the
	// current system time instead.

    // whm 21Oct07 updated local time calculations below to account for change in Visual
    // Studio from 2003 to 2005. In the process I discovered that CTime::Format already
    // formats the time as local rather than UTC, so no specific call to GetLocalTm is now
    // necessary with its changed parameter behavior between VS 2003 and 2005. whm wx
    // version comment: theTime doesn't need to be initialized, but it doesn't hurt.
    // It is set to the file's modification date/time below.
	wxDateTime theTime = wxDateTime::Now(); //initialize to the current time
	wxString path = pApp->m_curAdaptationsPath + pApp->PathSeparator + strDocName;
	bool bExists;
	bExists = ::wxFileExists(path) && !::wxDirExists(path);
	if (bExists)
	{
		wxFileName fn(path);
		theTime = fn.GetModificationTime(); // use the file's last modified date & time
	}
	wxString timeStr;
	timeStr = theTime.Format(_T("%a, %b %d, %H:%M, %Y")).c_str();

    // whm 6Apr2016 added the following first block for when the "Footer includes only the 
    // page number" option in the PrintOptionsDlg 
    if (gbPrintOnlyPgNumInFooter == TRUE)
    {
        wxString pageNumStr = _T("");
        pageNumStr = pageNumStr.Format(_T("%d"), page);
        int headerXExt, headerYExt;
        pDC->GetTextExtent(pageNumStr, &headerXExt, &headerYExt);
        // Position the footer 12.7mm (a half inch) below the bottom margin.
        float yPosFtr = (float)(fitRect.GetBottom() - 12.7*logicalUnitsFactor); // y position is same
		int xPosPageNum = fitRect.GetLeft() + fitRect.GetWidth()/2; // don't worry
							// about adjusting for x extent of the page number
        pDC->DrawText(pageNumStr, (long)xPosPageNum, (long)yPosFtr);
    }
    else
    {

      // Calculate the position for the footer. The incoming parameter fitRect represents the
      // rectangular printing area within the margins in logical units. The bottom of fitRect
      // is the effective bottom margin, so we'll place the footer 12.7mm (a half inch) in
      // logical units below the bottom of fitRect. Since the logical origin is at 0,0 of the
      // page, we need to add the fitRect.x position (fitRect.GetLeft()) to xPosFtr. In
      // calculating the position of yPosFtr, however, fitRect.GetBottom() returns
      // coordinates in reference to 0,0. See AIPrintout::OnPrintPage() for how
      // logicalUnitsFactor is calculated.
      // BEW added 21Jul09 because '2' is not two spaces of width, but 2 pixels, so need
      // something bigger - otherwise for a range, end of range is too close to page number
      int wXExt; int wYExt;
      pDC->GetTextExtent(_T("W"),&wXExt,&wYExt);
      // Bill's legacy code
      int footerXExt,footerYExt;
      pDC->GetTextExtent(strLeft,&footerXExt,&footerYExt);
      //float yPosFtr = (float)(fitRect.GetBottom() + 12.7*logicalUnitsFactor); // y position is same
      //													// for all segments of the footer
      float yPosFtr = (float)(fitRect.GetBottom() - 12.7*logicalUnitsFactor); // y position is same
														// for all segments of the footer
      float xPosFtrLeft = (float)fitRect.GetLeft();
      int timeXExt,timeYExt;
      pDC->GetTextExtent(timeStr,&timeXExt,&timeYExt);
      if (footerXExt+2*wXExt >= fitRect.GetWidth()/2)
      {
		pDC->GetTextExtent(strLeftPlusPageNum,&footerXExt,&footerYExt);
        // The strLeft (language names and file name) extends past the middle point of the
        // footer, so we will not try to draw the page number centered in the footer, but
        // will just add a couple spaces and the page number to the end of strLeft.
        // The timeStr should fit in the right-hand side of the footer, unless the language
        // names and/or file name are extremently long. Check to see if the time string
        // will fit.
		if (footerXExt + timeXExt + 2*wXExt > fitRect.GetWidth()) // allow 2 W widths
														// between footerXExt and timeXExt
		{
            // There is not enough space for the timeStr to fit on the footer between
            // margins, so we'll position the left part a little higher and draw the time
            // part one line height lower than the left part.
			pDC->DrawText(strLeftPlusPageNum, (long)xPosFtrLeft, (long)yPosFtr - timeYExt/2);
			int xPosTimeStr = fitRect.GetRight() - timeXExt;
			pDC->DrawText(timeStr, (long)xPosTimeStr, (long)yPosFtr + timeYExt/2);
		}
		else
		{
			// There is enough space for the timeStr to fit
			pDC->DrawText(strLeftPlusPageNum, (long)xPosFtrLeft, (long)yPosFtr);
			int xPosTimeStr = fitRect.GetRight() - timeXExt;
			pDC->DrawText(timeStr, (long)xPosTimeStr, (long)yPosFtr);
		}
      }
      else
      {
		// There is enough room to draw the page number in the middle of the footer
		pDC->DrawText(strLeft, (long)xPosFtrLeft, (long)yPosFtr);
		int xPosPageNum = fitRect.GetLeft() + fitRect.GetWidth()/2; // don't worry
							// about adjusting for x extent of the page number
		pDC->DrawText(strPageNum, (long)xPosPageNum, (long)yPosFtr);
		int xPosTimeStr = fitRect.GetRight() - timeXExt;
		pDC->DrawText(timeStr, (long)xPosTimeStr, (long)yPosFtr);
      }
	}

	// delete pFont for no memory leaks
	if (pFont != NULL) // whm 11Jun12 added NULL test
		delete pFont;
}
#endif

// wxWidgets Note: This function in the MFC version was called CreateBox, but I've combined
// its functionality and that of ResizeBox into a single function now called ResizeBox in
// the wx version. This was possible because the function now calls SetSize() on the
// already existing target box. The target box is created once in the App and lives while
// the app lives. When the target box should not be shown, it is now simply hidden, rather
// than destroyed and reshown.
// Called from CPhraseBox::FixBox() and CLayout::PlaceBox() and OnPhraseBoxChanged() - this
// last one because it contains an internal ResizeBox() call, (followed by FixedBox(),
// RecalcLayout(), ScrollIntoView(), AdjustForUseredits(), all based on app's current m_pActivePile)
// 
// BEW 11Aug21, juggling the various widths is complex; pileWidth, boxWidth, listWidth, the width
// of the gap in which the final size of the m_pTargetBos must fit, to avoid overlaying part or more
// of a pile or piles which follow in the active strip's layout, buttonWidth, slop, all have to be
// consistently handled in a GUI where sizes of things can vary much in length, particularly 
// pileWidth, boxWidth, listWidth, and the phrasebox gap. My refactoring will try to be consistent
// with Bill's protocols, with the exception that I will try to display the listWidth every time
// fully wide enough that all list members are visible without any horizontal scrolling of the list.
// 
// Remember, despite appearances, the contents of the piles' displayed contents in the layout
// are NOT stored anywhere. They are calculated at the point of need, in the Draw() calls which
// follow the calling of the view's Invalidate() function. That has been the case for many years,
// and it makes for a very responsive GUI, and a quick scrolling response, because our code does
// not draw all strips and piles - but only those that are visible in the client area of the
// frame window. Under the hood, automated movement of piles up or down to fill up strips
// happens as need, including adding or removing of strips when another is needed, or one
// becomes empty.

void CAdapt_ItView::ResizeBox(const wxPoint* pLoc, const int nWidth, const int nHeight,
	wxString& text, int nStartingChar, int nEndingChar, CPile* pActivePile)
{
#ifndef _DEBUG
	wxUnusedVar(pActivePile);
#endif
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp);
	/* BEW commented out to simplify logging output, on 16Sep21
#if defined (_DEBUG)
	{
		wxLogDebug(_T("      %s::%s() line %d : RESIZE BOX entered, const nWidth %d , for text = %s , active SN %d"),
			__FILE__, __FUNCTION__, __LINE__, nWidth, text.c_str(), pActivePile->GetSrcPhrase()->m_nSequNumber);
	}
#endif
*/
	//	wxLogDebug(_T("%s:%s():line %d, m_bFreeTranslationMode = %s"), __FILE__, __FUNCTION__, __LINE__,
	//		(&wxGetApp())->m_bFreeTranslationMode ? _T("TRUE") : _T("FALSE"));

	#if defined(_DEBUG) && defined(_OVERLAP)
		//pApp->MyLogger();
	#endif
	int sequNum = 0; // initialise - for logging
	wxUnusedVar(sequNum);
	
#if defined (_DEBUG) //&& defined(_OVERLAP)
	{
		CSourcePhrase* pSP = pActivePile->GetSrcPhrase();
		int sn = pSP->m_nSequNumber;
		sequNum = sn;
		if (sn == 2)
		{
			int halt_here = 1;
			wxUnusedVar(halt_here);
		}
	}
#endif


	// Check that m_nWidth (the phrasebox at gap's width) has not become less than 
	// the m_nMinWidth value (the box contents's width as shown at non-active locations)
	// and if it has then re-calculate the phrasebox width (it should never happen as
	// the passed in phraseBoxWidth was calculated in the caller just a few lines earlier
	// but no harm in playing safe)
	int aWidth = nWidth; // nWidth is passed in as const, so can't assign to it
	CLayout* pLayout = GetLayout(); // BEW 11Aug21 in case needed within
	wxUnusedVar(pLayout); // avoid compiler warning if unused
	
	
	// BEW 1Sep21 Phrasebox resizes are caused in two different ways. 
	// whm 11Nov2022 BEW's comments on Way 1 and Way 2 are accurate, except that the boolean
	// m_bJustKeyedBackspace is not longer needed in refactored phrasebox resizing
	// 
	// Way 1: for every character typed, OnChar() will set the Layout boolean m_bJustKeyedBackspace
	// to FALSE for normal characters typed into the box, or TRUE when backspace was typed. Typing into
	// the box can lengthen the adaptation till it gets dangerously close to the end of the box. Or,
	// we detect that repeated backspaces have reduced the text extent sufficiently that enough
	// free space exists to allow a box contraction (but disallow contraction less than the dropdown list's
	// width). Since OnPhraseBoxChanged() fires at every character or backspace typed, in that function
	// we interrogate for when expanding or contracting must fire - and do the adjustment, and then call
	// ResizeBox() to get the change updated.
	// Way 2: OnPhraseBoxChanged() might not be called, for instance, PlacePhraseBox() might be called,
	// when the phrasebox moves to a new active location. Typing, therefore, may not happen, but resizing
	// might be needed. So FixBox() and PlaceBox() will have similar code to work out what should happen
	// and call ResizeBox() and follow with a RecalcLayout() call & then view's Invalidate() etc.

	// BEW 1Sep21, the important note to recall is that if a newWidth value for the phrasebox is
	// needed, it must be calculated correctly BEFORE ResizeBox() is called, because the latter
	// takes in a nWidth value which is constant

	// Do the resize
	wxRect rectBox(wxPoint((*pLoc).x, (*pLoc).y), wxPoint((*pLoc).x + aWidth,
		(*pLoc).y + nHeight + 4)); // logical coords

	// BEW 16Aug21 send the new width to Layout's m_curBoxWidth -- 20Aug21 No no! This
	// function might be reentered several times at this active location, so comment
	// out next line because each reentry would set the box width wider
	//pLayout->m_curBoxWidth = (*pLoc).x + aWidth;

	// convert to device coords
	wxClientDC aDC(pApp->GetMainFrame()->canvas);
	canvas->DoPrepareDC(aDC); // adjust origin

//	wxLogDebug(_T("%s:%s():line %d, m_bFreeTranslationMode = %s"), __FILE__, __FUNCTION__, __LINE__,
//		(&wxGetApp())->m_bFreeTranslationMode ? _T("TRUE") : _T("FALSE"));

	// CalcScrolledPosition is the complement of CalcUnscrolledPosition;
	// CalcScrolledPosition translates logical coordinates to device ones.
	int newXPos, newYPos;
	pApp->GetMainFrame()->canvas->CalcScrolledPosition(rectBox.x, rectBox.y, &newXPos, &newYPos);

	// whm 16Aug2018 change. The CalcScrolledPosition() call above eventually returns a bad (highly inflated) value for newXPos.
	// We don't need the x-axis value anyway, just the y-axis value which seems to be behaved at this point. 
	// So I'm commenting out the assignment of newXPos to rectBox.x below.
	//rectBox.x = newXPos;
	rectBox.y = newYPos;
	// we leave the width and height the same

	// Below are (legacy) alternates for calculating scrolled position
//#ifdef _DEBUG
//	// The device coords can be found by subtracting the logical coords of the upper left corner as
//	// reported by GetViewStart, from rectBox's upper left corner coords. This doesn't change the
//	// width and height of a wxRect; the width and height were established in the wxRect rectBox()
//	// construction statement above.
//	int xScrollUnits, yScrollUnits, xOrigin, yOrigin;
//	pApp->GetMainFrame()->canvas->GetViewStart(&xOrigin, &yOrigin); // gets xOrigin and yOrigin in scroll units
//	pApp->GetMainFrame()->canvas->GetScrollPixelsPerUnit(&xScrollUnits, &yScrollUnits); // gets pixels per scroll unit
//	rectBox.x -= xOrigin * xScrollUnits; // number pixels is ScrollUnits * pixelsPerScrollUnit
//	rectBox.y -= yOrigin * yScrollUnits;
//#endif


//#ifdef _DEBUG
//	//aDC.LPtoDP(&rectBox);
//	// whm Note: The following LogicalToDeviceXRel and LogicalToDeviceYRel and their non-Rel functions
//	// adjust the logical position of rectBox after scrolling down from the zero scroll position
//	int x = aDC.LogicalToDeviceXRel(rectBox.x);// get the logical X coord converted to device coord
//	int y = aDC.LogicalToDeviceYRel(rectBox.y);// get the logical Y coord converted to device coord
//	// the above should be equivalent to the non-Rel forms below when using saveRect
//	int xx = aDC.LogicalToDeviceX(saveRect.x);// get the logical X coord converted to device coord
//	int yy = aDC.LogicalToDeviceY(saveRect.y);// get the logical Y coord converted to device coord
//	wxASSERT(x == rectBox.x); //rectBox.x = x;
//	wxASSERT(y == rectBox.y); //rectBox.y = y;
//	wxASSERT(x == xx);
//	wxASSERT(y == yy);
//#endif

	// WX version resizes rather than recreating the target box

	// whm 12Jul2018 added GetTextCtrl()
	pApp->m_pTargetBox->GetTextCtrl()->SetSize(rectBox.GetLeft(), rectBox.GetTop(),
		rectBox.GetWidth(), rectBox.GetHeight());

#if defined (_DEBUG) && defined(_OVERLAP)
	{
		wxLogDebug(_T("%s::%s() line %d, RESIZEBOX'S rectBox WIDTH after resizing = %d   from rectBox.GetWidth()"),
			__FILE__, __FUNCTION__, __LINE__, rectBox.GetWidth());
	}
#endif

    // whm note: Shouldn't the following adjustment come before the SetSize call above???
    // BEW answer: no, SetSize() would then wipe out the effect.
#ifdef _RTL_FLAGS
	// adjust, otherwise box is a bit too small vertically
	rectBox.SetHeight(rectBox.GetHeight() + 5); // allow for the window borders
	if (gnVerticalBoxBloat > 0)
		rectBox.SetHeight(rectBox.GetHeight() + gnVerticalBoxBloat); // allow for the leadings on the font

#if defined(_DEBUG) && defined(GUIFIX)
	{
		// log where the top,left is, and the above calc of the width, and height
		wxLogDebug(_T("   TWEAKED RECTBOX   %s::%s() line %d, TopLeft [ Top %d , Left %d ] Width %d  Height %d  In logical coords"),
			__FILE__, __FUNCTION__, __LINE__, rectBox.GetTop(), rectBox.GetLeft(),
			rectBox.GetWidth(), rectBox.GetHeight());
	}
#endif

	// whm 11Nov2022 added. If a long text segment was pasted into the control that was longer 
	// than the phrasebox's width - before this resize - the first part of the long text will 
	// be pushed or scrolled out of sight (beyond the left edge of the edit box), because the
	// text control was (before the resize) not long enough to contain all of the text and it
	// has scrolled enough of the text beyond the left box edge to keep the pasted end of the
	// new string in view. This creates a visibility problem, however, because, the SetSize() 
	// call above doesn't un-hide any of the scrolled-out-of-view text back into view. Hence,
	// any part of the text that was pushed out of sight will remain out of sight even though 
	// the phrasebox has been now resized to fully accommodate the new and longer text.
	// The following is a work-around to get the new longer text fully back into view within 
	// the newly resized phrasebox. 
	// We save the insertion point, then temporarily set the insertion point to the beginning of
	// the box contents (which forces the scrolled beginning part of the string back into view), 
	// then we reset the insertion point back to its original setting. No part of the string
	// content gets changed in anyi way, but this action just forces the string part that was 
	// hidden/scrolled out of the edic box to reappear unscrolled.
	long saveInsertionPoint = pApp->m_pTargetBox->GetTextCtrl()->GetInsertionPoint();
	pApp->m_pTargetBox->GetTextCtrl()->SetInsertionPoint(0);
	pApp->m_pTargetBox->GetTextCtrl()->SetInsertionPoint(saveInsertionPoint);

	// enable complex rendering
    // whm note for wx version: Right-to-left reading is handled automatically in Uniscribe
    // and Pango, but they differ in how they handle Unicode text chars that are from the
    // first 128 point positions. In wxMSW SetLayoutDirection() aligns these to the right
    // in the phrasebox but in wxGTK (under Pango) SetLahoutDirection() aligns these to the
    // left within the phrasebox.
	//	wxLogDebug(_T("%s:%s():line %d, m_bFreeTranslationMode = %s"), __FILE__, __FUNCTION__, __LINE__,
	//		(&wxGetApp())->m_bFreeTranslationMode ? _T("TRUE") : _T("FALSE"));

	if (pApp->m_bTgtRTL)
	{
		pApp->m_pTargetBox->GetTextCtrl()->SetLayoutDirection(wxLayout_RightToLeft); // whm 12Jul2018 added GetTextCtrl()-> part
		//      whm Note: Pango overrides the following SetStyle() command
		//#ifndef __WXMSW__
		//		pApp->m_pTargetBox->SetStyle(-1,-1,wxTextAttr(wxTEXT_ALIGNMENT_RIGHT));
		//#endif
	}
	else
	{
		pApp->m_pTargetBox->GetTextCtrl()->SetLayoutDirection(wxLayout_LeftToRight); // whm 12Jul2018 added GetTextCtrl()-> part
		// whm Note: Pango overrides the following SetStyle() command
		//#ifndef __WXMSW__
		//		pApp->m_pTargetBox->SetStyle(-1,-1,wxTextAttr(wxTEXT_ALIGNMENT_LEFT));
		//#endif
	}
#endif // for _RTL_FLAGS

    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    // whm 12Jul2018 addition.
    // Note that this ResizeBox() function is called within PlaceBox() shortly before the
    // SetupDropDownPhraseBoxForThisLocation() is called. Now that the new size/position
    // of the legacy phrasebox's edit box has been calculated above to be of sufficient 
    // width and height for the target text it contains (plus slop), the code below takes 
    // care of the relative positioning of the new phrasebox's button, and the sizing and
    // positioning of its dropdown list.
    //
    // First, adjust the placement of the new phrasebox button, centering it to the right 
    // of the phrasebox (using the rectBox size as determined above). We set the button's 
    // upper left position 1 pixel to the right of the rectBox's right side, and center
    // it along the right side of the phrasebox's current rectBox. The rectBox will be
    // changing dynamically, depending on the text extent of its contents, but the
    // phrasebox button won't be changing in size. The code below keeps it aligned
    // along the approximate center of the current rectBox.
    // Important Note: The code below does not change the size of the rectBox as determined
    // above. It merely functions to align the elements of the new phrasebox. The only
    // change in size is done for the DropDown List, to keep it sized and aligned with
    // the current width of the rectBox. The horiz & vertical sizes of the dropdown list are
    // done in the OnIdle() function in MainFrm.cpp (see comment below for the reason).
    wxRect buttonRect = pApp->m_pTargetBox->GetPhraseBoxButton()->GetRect();
    int buttonHeight = buttonRect.GetHeight();
    int phraseboxHeight = rectBox.GetHeight();
    int adjustHeight = ((phraseboxHeight - buttonHeight) / 2) - 1;
    pApp->m_pTargetBox->GetPhraseBoxButton()->SetPosition(wxPoint(rectBox.GetRight() + 1, rectBox.GetTop() + adjustHeight));

	//	wxLogDebug(_T("%s:%s():line %d, m_bFreeTranslationMode = %s"), __FILE__, __FUNCTION__, __LINE__,
	//		(&wxGetApp())->m_bFreeTranslationMode ? _T("TRUE") : _T("FALSE"));


	// whm 12Jul2018 addition - set the width of the dropdown list to be the same as the width of the
    // phrasebox's rectBox. Set its position to be aligned to the bottom of the phrasebox's rectBox.
	// 
	// BEW 27Jul21 the width of the dropdown list always is tied to the phrasebox's
	// rectBox, to facilitate syncing widths ready for adding the (1 + buttonWidth). But we want a wide listWidth
	// to override the calculation here, so that the phrasebox width is wider when aWidth is calculated above. 
	// We can't do this widening here, it has to be done in CalcPhraseBoxWidth(), so that aWidth picks up a
	// wider-than-phrasebox width and widens it before ResizeBox() gets called.

    pApp->m_pTargetBox->GetDropDownList()->SetPosition(wxPoint(rectBox.GetLeft(), rectBox.GetBottom() -2)); // sets left and top for wxPoint
    // whm 11Nov2022 modified the width for the dropdown list's SetSize() call to make the
	// dropdown list stay all the way under the dropdown button, as it is originally sized in
	// the CPhraseBox::PopupDropDownList() function and the CAdapt_ItCanvas::OnTogglePhraseBoxButton() 
	// function. This doesn't affect any list width calculations made elsewhere, it just the width of 
	// the dropdown listbox as drawn on screen extent all the way under the button, otherwise the dropdown
	// list width spans under the button when phrasebox lands, and when the list is manually toggled open
	// or closed, but phrasebox resize events shorten its width/span to end at the phrasebox's border,
	// until the list is toggled again.
	// (see more comment/explanation below in whm 11Nov2022 note).
	int buttonWidth = pApp->m_pTargetBox->GetPhraseBoxButton()->GetRect().GetWidth();
	int rectWidth = rectBox.GetWidth();
	rectWidth += (buttonWidth + 1); // incrememt rectWidth by width of button and 1-pixel space between.
	//pApp->m_pTargetBox->GetDropDownList()->SetSize(rectBox.GetWidth(), -1); // sets .x value for the width, leaves height unchanged (until Popup...)
	pApp->m_pTargetBox->GetDropDownList()->SetSize(rectWidth, -1); // sets .x value for the width, leaves height unchanged (until Popup...)

    // whm Note: The SetSize() call above sets the list width to be that of the phrasebox, however, it
    // just sets the height at the default value set on creation (100 pixels). ResizeBox() is called
    // before the dropdown list is populated (later in PlaceBox() or elsewhere), so we call the 
    // CPhraseBox::SetSizeAndHeightOfDropDownList() within the PopupDropDownList() which
    // is in turn only called from OnIdle() in MainFrm.cpp.
	// BEW 29Jul21 refactoring changes the comment above a bit. Now CalcPhraseBoxWidth() determines
	// an accurate listWidth, from which we can calculate what the phrasebox width needs to be.
	// 
	// whm 11Nov2022 note: When a document is first opened, and at the Layout's PlaceBox()
	// call the list width is drawn all the way under the button width. This is intentional
	// (see comment within the CPhraseBox::PopupDropDownList() function), and this under-button
	// width of the dropdown list is maintained here in CAdapt_ItCanvas::OnTogglePhraseBoxButton().
	// However, when the phrasebox is resized via call of View's ResizeBox() call, which gets
	// called whenever the phrasebox needs resizing and also when a manual resize is done of
	// the main window frame, the calculations for the drop down list change its width to be
	// the same as the phrasebox control itself, resulting in the the drop down list not 
	// being drawn all the way under the button width.
	//rectWidth += (buttonWidth + 1); // incrememt rectWidth by width of button and 1-pixel space between.
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

    pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(text);
    if (gbIsGlossing && gbGlossingUsesNavFont)
    {
        pApp->m_pTargetBox->GetTextCtrl()->SetFont(*pApp->m_pNavTextFont); // whm 12Jul2018 added GetTextCtrl()-> part
        // whm 12Jul2018 added Also set font for the phrasebox's list
        pApp->m_pTargetBox->GetDropDownList()->SetFont(*pApp->m_pNavTextFont); // whm 12Jul2018 added

    }
    else
    {
        pApp->m_pTargetBox->GetTextCtrl()->SetFont(*pApp->m_pTargetFont); // whm 12Jul2018 added GetTextCtrl()-> part
        // whm 12Jul2018 added Also set font for the phrasebox's list
        pApp->m_pTargetBox->GetDropDownList()->SetFont(*pApp->m_pTargetFont); // whm 12Jul2018 added
        //int ptSize;
        //ptSize = pApp->m_pTargetFont->GetPointSize();
        //ptSize = ptSize; // debug line
    }
//	wxLogDebug(_T("%s:%s():line %d, m_bFreeTranslationMode = %s"), __FILE__, __FUNCTION__, __LINE__,
//		(&wxGetApp())->m_bFreeTranslationMode ? _T("TRUE") : _T("FALSE"));

	// whm modified 29Mar12. As of this date, this is the only
	// location in the whole code base where the m_pTargetBox->Show()
	// call is made.
	//
	// Only call m_pTargetBox->Show() if the app is NOT in read-only mode.
	if (!pApp->m_bReadOnlyAccess)
	{
		// whm added following to show and enable the target box
		pApp->m_pTargetBox->Show();
        // whm 12Jul2018 added next two - show the other parts of the new phrasebox
        pApp->m_pTargetBox->GetPhraseBoxButton()->Show();
        pApp->m_pTargetBox->GetTextCtrl()->Show();
        pApp->m_pTargetBox->Enable(TRUE);
		pApp->m_pTargetBox->GetTextCtrl()->SetEditable(TRUE);
	}

	// restore focus and cursor position or selection
	// whm 29Jul11 Note: The following SetFocus() call sometimes
	// generates an API error logged in the Output window during
	// debugging: "..\..\src\msw\window.cpp(643): 'SetFocus' failed
	// with error 0x00000057 (the parameter is incorrect.)."
	// It is annoying to see it appear in the output window but
	// it is of unknown cause and apparently harmless.
    // whm 13Aug2018 Note: The SetFocus() call here precedes the SetSelection, so
    // it should work OK on Linux/Mac.
    pApp->m_pTargetBox->GetTextCtrl()->SetFocus();
    // whm 3Aug2018 Note: The following SetSelection() should not be suppressed
	pApp->m_pTargetBox->GetTextCtrl()->SetSelection(nStartingChar,nEndingChar);
	pApp->m_nStartChar = (int)nStartingChar;
	pApp->m_nEndChar = (int)nEndingChar;

//	wxLogDebug(_T("%s:%s():line %d, m_bFreeTranslationMode = %s"), __FILE__, __FUNCTION__, __LINE__,
//		(&wxGetApp())->m_bFreeTranslationMode ? _T("TRUE") : _T("FALSE"));

	if (pApp->m_bFreeTranslationMode)
	{
		// prevent clicks and editing from being done in the phrase box
		// (do also in OnAdvancedFreeTranslationMode())
        // wx version: by setting the targetbox with SetEditable(FALSE) instead of
        // Enable(FALSE) we get to control the background color, keeping it pink in free
        // trans mode
		pApp->m_pTargetBox->GetTextCtrl()->SetEditable(FALSE);
		pApp->m_pTargetBox->SetBackgroundColour(pApp->m_freeTransCurrentSectionBackgroundColor);
	}
	else
	{
		// enable clicks and editing to be done in the phrase box
		// (do also in OnAdvancedFreeTranslationMode())
		pApp->m_pTargetBox->GetTextCtrl()->SetEditable(TRUE);

		pApp->m_pTargetBox->SetBackgroundColour(wxColour(255,255,255)); // white

	}

//	wxLogDebug(_T("%s:%s():line %d, m_bFreeTranslationMode = %s"), __FILE__, __FUNCTION__, __LINE__,
//		(&wxGetApp())->m_bFreeTranslationMode ? _T("TRUE") : _T("FALSE"));

#if defined(_DEBUG) && defined(GUIFIX)
	{
		wxLogDebug(_T("      %s::%s() line %d : RESIZE BOX leaving, const nWidth %d , contains text = %s , active SN %d"),
			__FILE__, __FUNCTION__, __LINE__, nWidth, pApp->m_pTargetBox->GetTextCtrl()->GetValue().c_str(), pActivePile->GetSrcPhrase()->m_nSequNumber);
	}
#endif
}

void CAdapt_ItView::OnEditPreferences(wxCommandEvent& WXUNUSED(event))
{
	CAdapt_ItApp* pApp = (CAdapt_ItApp*)&wxGetApp();
	wxASSERT(pApp);

	pApp->LogUserAction(_T("Initiated OnEditPreferences()"));
	CEditPreferencesDlg editPrefsDlg(
		pApp->GetMainFrame(),
		-1,
		_("Edit Preferences"),
		wxDefaultPosition,
		wxDefaultSize,
		wxCAPTION|wxRESIZE_BORDER|wxSYSTEM_MENU|wxCLOSE_BOX);  // removed |wxDIALOG_MODAL
					// GDLC wxDIALOG_MODAL is obsolete - ShowModal() does what it used to
	editPrefsDlg.Centre();

	pApp->m_nMaxToDisplay = pApp->GetMaxIndex() + 1;

	// preserve the current active pile location, by preserving the srcPhrases's sequNum
	// (because RecalcLayout will recreate everything any any saved pointers will no longer
	// be valid)
	int activeSequNum;
	if (pApp->m_nActiveSequNum < 0)
	{
		// must not have data yet, or we are at EOF, so no pile is currently active
		activeSequNum = -1;
	}
	else
	{
		// we are possibly somewhere in the midst of the data, so a pile will be active,
		// unless we cancelled from the wizard without getting a doc open - in which case
		// activeSequNum may be 0, but m_pActivePile would still be null, so check
		if (pApp->m_pActivePile != NULL)
		{
			activeSequNum = pApp->m_pActivePile->GetSrcPhrase()->m_nSequNumber;

			// remove any current selection, as we can't be sure of any pointers
			// depending on what user may choose to alter
			RemoveSelection();
		}
		else
		{
			activeSequNum = 0; // to avoid a compiler warning
		}
	}
	pApp->m_nActiveSequNum = activeSequNum;
	wxString strSavePhraseBox = pApp->m_targetPhrase;

    // whm Design Modification NOTE:
    // !!! DO NOT INITIALIZE DATA IN INDIVIDUAL PREFERENCES PAGES HERE !!!
    // Each of the InitDialog() methods of the individual Preferences pages takes care of
    // the initialization of all of their local members directly from the corresponding
    // members in the App (many of which get initialized previously by config file values).
    // This modification attempts to keep initialization encapsulated more in the classes
    // that know how to handle the data. Because of this modification, we don't need to
    // initialize them from here before the CEditPreferencesDlg's ShowModal() call is made
    // - as does the MFC version.

	// Put up the "Edit Preferences" dialog
    // wx note: Since CEditPreferencesDlg is based on wxPropertySheetDialog rather than on
    // wxDialog, it does not get its idle event processing turned off while it is in modal
    // state, therefore we turn off idle processing here manually just before the ShowModal
    // call; and turn it back on afterwards (below).
	wxIdleEvent::SetMode(wxIDLE_PROCESS_SPECIFIED); // turn idle processing off
	if(editPrefsDlg.ShowModal() == wxID_OK)
	{
		// whm Design Modification NOTE:
		// !!! DO NOT UPDATE DATA FROM INDIVIDUAL PREFERENCES PAGES HERE !!!
        // Each of the OnOK() methods of the individual Preferences pages takes care of the
        // updating the App's data members directly from their local temp... members. This
        // modification attempts to keep settings value changes encapsulated more in the
        // classes that know how to handle the data. Because of this modification, we don't
        // need to update them from here after the CEditPreferencesDlg's ShowModal() call
        // is made - as does the MFC version.

		// BEW 14Aug18, ... with one exception. This is the perfect place to calculate the
		// value, for this session, of the phrasebox slop. It will change if the user has
		// altered the multiplier, or if the font size is changed, or both. We only
		// need calculate it here once per entry to Preferences, and the calculation is quick;
		// the slop width it calculates is stored as the CLayout public member: slop
		// We must also do this calculation at the end of OnInit(), to provided a valid
		// value, since the user may not call Preferences
		wxClientDC aDC(pApp->GetMainFrame()->canvas);
		wxChar aChar = _T('w');
		wxString wStr = aChar;
		wxSize charSize;
		aDC.GetTextExtent(wStr, &charSize.x, &charSize.y);
		pApp->GetLayout()->slop = pApp->m_nBoxSlop*charSize.x;
		pApp->m_width_of_w = charSize.x; // BEW 15Aug21 same calc is in OnInit() about line 27921

		// BEW 22Jul21 try a hack to increase the gap with when gbShowTargetOnly is TRUE
		// This restored to 16, but it's not a solution. What needs to happen is that
		// the active strip's "hole" for whatever is the 'gap' needs to be slidden further
		// to the right. The essence of this problem is that we calculate the phrasebox width
		// and its dropdown button, using the 'gap' value in the calcs. And 
		// we open a space for the phrasebox with that 'gap' value too in the calcs - we
		// need to unhinge these two things.
		//if (gbShowTargetOnly)
		//{
		//	pApp->m_curGapWidth = 16;
		//	pApp->GetLayout()->SetGapWidth(pApp);
		//}

	}
	else
	{
		// user cancelled
		if (pApp->m_bShowAdministratorMenu)
		{
			// don't show it if the user cancelled prefs
			pApp->m_bShowAdministratorMenu = FALSE;
#ifdef _DEBUG
			pApp->m_bShowAdministratorMenu = TRUE; // for debugging convenience
#endif
		}
		pApp->LogUserAction(_T("Cancelled OnEditPreferences()"));
	}

	// show the Administrator menu if the admin person requested it and password was valid
	// if flag is FALSE, check if the menu is visible and if so, hide it. This and more is
	// done through the App's MakeMenuInitializationsAndPlatformAdjustments() function.
	pApp->MakeMenuInitializationsAndPlatformAdjustments(); //(collabIndeterminate);

	// We want to be smarter here so that we don't create piles and strips again
    // unnecessarily - eg. if user changes the colour of text only, no recalculation of the
    // layout would be needed
	// BEW 5Jun09, removed the RecalcLayout() call here, in favour of using the
	// DoRecalcLayoutAfterPreferencesDlg() function, which makes a more intelligent
	// decision about which particular kind of RecalcLayout() call to make
	CLayout* pLayout = GetLayout();
	// whm added 5Nov10 the following test block in support of Preferences being
	// made available when no documen is open.
	if (pApp->GetDocument() == NULL || pApp->m_pSourcePhrases->GetCount() == 0)
	{
		// no document is open so there is no need to do pLayout calls nor phrasebox
		// adjustments, etc. We can return here, but first make sure Idle processing
		// is turned back on and the pLayout boolean flags are cleared.
		wxIdleEvent::SetMode(wxIDLE_PROCESS_ALL); // turn idle processing back on
		// it's not necessary to clear these flags here, as they get cleared automatically in
		// the CEditPreferences::InitDialog() function, which is called when the Preferences
		// dialog is first opened. However, it is good defensive practice not to leave them set
		// until then
		pLayout->m_bViewParamsChanged = FALSE;
		pLayout->m_bUSFMChanged = FALSE;
		pLayout->m_bFilteringChanged = FALSE;
		pLayout->m_bPunctuationChanged = FALSE;
		pLayout->m_bCaseEquivalencesChanged = FALSE;
		pLayout->m_bFontInfoChanged = FALSE;
		// return before performing pLayout calls and phrasebox adjustments
		return;
	}
	pLayout->DoRecalcLayoutAfterPreferencesDlg(); // inside are smarts for making the
												  // best possible RecalcLayout() call
	if (pApp->m_nActiveSequNum == -1)
	{
		pApp->m_pActivePile = NULL; // that ought to be safe in update handlers
	}
	else
	{
		pApp->m_pActivePile = GetPile(pApp->m_nActiveSequNum);
	}
	pLayout->m_pCanvas->ScrollIntoView(pApp->m_nActiveSequNum);

	// BEW added 10Jun09, support phrase box matching of the text colour chosen
	if (gbIsGlossing && gbGlossingUsesNavFont)
	{
		pApp->m_pTargetBox->GetTextCtrl()->SetOwnForegroundColour(pLayout->GetNavTextColor());// whm 12Jul2018 added ->GetTextCtrl() part
	}
	else
	{
		pApp->m_pTargetBox->GetTextCtrl()->SetOwnForegroundColour(pLayout->GetTgtColor());// whm 12Jul2018 added ->GetTextCtrl() part
	}

	// BEW 10Dec13, if the user changed the punctuation settings, the global
	// gbSpacelessTgtPunctuation needs recalculating, because free translation mode uses
	// it a lot and if the user is in free translation mode and just edited the punct
	// settings (e.g. to make ] not be a punct character so as to be able to have [ ]
	// brackets within adaptations without them forcing a new section to be shorter than
	// wanted) then his edit needs to "take" immediately
	gSpacelessTgtPunctuation = pApp->m_punctuation[1];
	// get rid of the spaces
	// BEW 21Jul14, ZWSP support: keep this as latin space
	gSpacelessTgtPunctuation.Replace(_T(" "), _T(""));

	// TokenizeText also needs m_strSpacelessSourcePuncts reset, & target ones
	pApp->m_strSpacelessSourcePuncts = MakeSpacelessPunctsString(pApp, sourceLang);
	pApp->m_strSpacelessTargetPuncts = MakeSpacelessPunctsString(pApp, targetLang);

    // BEW 22May09 moved idle processing down to here so that idle events won't come before
    // the m_pActivePile has a chance to be reset to the valid active pile resulting from
    // the shenanigans that go on in RecalcLayout()! Failure to do so can result in system
    // housekekeping calling command update handlers before m_pActivePile points at a real
    // pile, and that gives a flame & burn crash
	wxIdleEvent::SetMode(wxIDLE_PROCESS_ALL); // turn idle processing back on

	int len;
	// BEW modified 3Apr08, restore focus to the phrase box, except when in free translation
	// mode in which case it needs to be restored to the compose bar's editbox
    // whm 3Aug2018 Note: No suppression of a select all would be appropriate within the if...else
    // blocks below.
	if (pApp->m_bFreeTranslationMode)
	{
		CMainFrame* pFrame = pApp->GetMainFrame();
		wxASSERT(pFrame != NULL);
		if (pFrame->m_pComposeBar != NULL)
			if (pFrame->m_pComposeBar->IsShown())
			{
				wxTextCtrl* pComposeBox = (wxTextCtrl*)
							pFrame->m_pComposeBar->FindWindowById(IDC_EDIT_COMPOSE);
				wxString text;
				text = pComposeBox->GetValue();
				len = text.Length();
				pComposeBox->SetSelection(len,len);
				pComposeBox->SetFocus();
			}
	}
	else
	{

		if (pApp->m_pTargetBox->IsShown())
		{
			len = pApp->m_targetPhrase.Length();
			pApp->m_nStartChar = len;
			pApp->m_nEndChar = len;
            pApp->m_pTargetBox->SetFocusAndSetSelectionAtLanding();// whm 13Aug2018 modified
		}
	}

    // it's not necessary to clear these flags here, as they get cleared automatically in
    // the CEditPreferences::InitDialog() function, which is called when the Preferences
    // dialog is first opened. However, it is good defensive practice not to leave them set
    // until then
	pLayout->m_bViewParamsChanged = FALSE;
	pLayout->m_bUSFMChanged = FALSE;
	pLayout->m_bFilteringChanged = FALSE;
	pLayout->m_bPunctuationChanged = FALSE;
	pLayout->m_bCaseEquivalencesChanged = FALSE;
	pLayout->m_bFontInfoChanged = FALSE;

	// BEW 30Jun09, added Invalidate() and PlaceBox() here, not sure but I think they
	// are needed
	Invalidate();
	pLayout->PlaceBox();
}

void CAdapt_ItView::OnFileSaveKB(wxCommandEvent& event)
{
	// whm modified 15Jan11 to save both glossing and adapting KBs when OnFileSaveKB()
	// is called. This is now more important with transitions possible between the new
	// and old KB xml formats.
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp);
	if (event.GetId() == ID_FILE_SAVEKB)
	{
		pApp->LogUserAction(_T("Initiated OnFileSaveKB()"));
	}
	bool bOK1 = FALSE;
	bool bOK2 = FALSE;

	// BEW added 13Nov09, the local user, if he has only read-only access to a remote
	// project folder, must not be able to cause saving of the KB data - otherwise the
	// remote user would probably lose data added to the KB in his machine's memory
	// since his last save; so prevent my machine's in-memory KB copy from being saved
	// to his machine
	if (pApp->m_bReadOnlyAccess)
	{
		pApp->LogUserAction(_T("Aborted OnFileSaveKB() m_bReadOnlyAccess"));
		return;
	}

	wxString mess;
	mess.Empty();
	//if (gbIsGlossing)
	//{
	bOK1 = pApp->SaveGlossingKB(FALSE); // don't want backup produced of the glossing KB
	if (!bOK1)
	{
		mess = _("Failure when trying to save the glossing knowledge base. ");
	}
	//}
	//else
	//{
	bOK2 = pApp->SaveKB(FALSE, TRUE); // don't want backup produced
	if (!bOK2)
	{
		mess = _("Failure when trying to save the knowledge base. ");
	}
	//}
	if (!bOK1 || !bOK2)
	{
		pApp->m_bAutoBackupKB = FALSE;	// turn it off, so if user reopens the app later, the
										// bad glossing KB will not overwrite the backed up one
		mess += _(" You should immediately save the document, then try again.");
		mess += _(" If you have repeated failures, then exit the application ");
		mess += _("and try one of the recovery strategies (either use the backup one ");
		mess += _("or the Restore Knowledge Base command). DO NOT use ");
		mess += _("the Backup Knowledge Base command now!");
        // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
        pApp->m_bUserDlgOrMessageRequested = TRUE;
        wxMessageBox(mess, _T(""), wxICON_EXCLAMATION | wxOK);
		pApp->LogUserAction(mess);
	}
}

/////////////////////////////////////////////////////////////////////////////////
/// \return		nothing
/// \param      event   -> the wxUpdateUIEvent that is generated when the File Menu is about
///                         to be displayed
/// \remarks
/// Called from: The wxUpdateUIEvent mechanism when the associated menu item is selected,
/// and before the menu is displayed.
/// Enables the "Save Knowledge Base" item on the File menu if the appropriate KB is in a
/// ready state, otherwise it disables the menu item.
/////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItView::OnUpdateFileSaveKB(wxUpdateUIEvent& event)
{
	CAdapt_ItApp* pApp = (CAdapt_ItApp*)&wxGetApp();
	if (pApp->m_bReadOnlyAccess)
	{
		event.Enable(FALSE);
		return;
	}
	if (gbIsGlossing)
		event.Enable(pApp->m_bGlossingKBReady);
	else
		event.Enable(pApp->m_bKBReady);
}

// BEW 4Dec14 added ClobberGuesser() at the end, to get the Guesser objects back
// to initialized state - which means emptying all their lists, and the given
// affixes lists as well. We don't want to transfer guesser data between projects.
void CAdapt_ItView::OnFileCloseProject(wxCommandEvent& event)
{
    // Since the Close Project menu item has an accelerator table hot key (CTRL-J see
    // CMainFrame) and wxWidgets accelerator keys call menu and toolbar handlers even when
    // they are disabled, we must check for a disabled button and return if disabled.
    // On Windows, the accelerator key doesn't appear to call the handler for a disabled
    // menu item, but I'll leave the following code here in case it works differently on
    // other platforms.
	//CMainFrame* pFrame = pApp->GetMainFrame();
	//wxMenuBar* pMenuBar = pFrame->GetMenuBar();
	//wxASSERT(pMenuBar != NULL);
	//if (!pMenuBar->IsEnabled(ID_FILE_CLOSEKB))
	//{
	//	::wxBell();
	//	return;
	//}

	CAdapt_ItApp* pApp = (CAdapt_ItApp*)&wxGetApp();
	wxASSERT(pApp);
	CAdapt_ItDoc* pDoc = pApp->GetDocument();

	if (event.GetId() == ID_FILE_CLOSEKB)
	{
		pApp->LogUserAction(_T("User initiated Close Project"));
	}
	else
	{
		pApp->LogUserAction(_T("Program initiated Close Project"));
	}

	// BEW added 6Nov09 because, if recovering within the OnInit() call just after
	// launch because a custom work folder location is not accessible (eg. it may be
	// on a thumb drive not currently plugged in), the GetCustomWorkFolderLocation()
	// call, part of the recovery attempt, will call GetView()->CloseProject(), but
	// that calls OnFileCloseProject() which then tries to set up a pointer to the
	// document class's instance, which at that time does not yet exist. The pointer
	// is returned as NULL, and so the pDoc->OnFileClose() call a little further below
	// would fail unless we here detect a pDoc being NULL and exit immediately
	if (pDoc == NULL)
	{
		wxString msg = _T("Doc == NULL, returned early from OnFileCloseProject(): m_curProjectPath = %s [not reset/emptied in OnFileCloseProject()]");
		msg = msg.Format(msg,pApp->m_curProjectPath.c_str());
		pApp->LogUserAction(msg);
		return; // do nothing because no doc instance exists yet, so prevent crash
	}

	// whm added 28Feb12
	// when the user explicitly selects File > Close Project we want the
	// normal wizard to appear, not the GetSourceTextFromEditor dialog.
	pApp->m_bStartWorkUsingCollaboration = FALSE;

	// whm 28Feb12 modified. With project-specific collaboration the user
	// decides whether collaboration is ON or OFF at the ProjectPage of
	// the wizard. When the user selects Close Project from the File menu
	// we close the project and also turn collaboration OFF, which also
	// is needed to remove the parenthetical information from the
	// File > Open and File > Save labels.
	// whm 25Nov2013 modified. No, it is better to retain the state of which
	// external editor was last used for collaboration, even when
	// m_bStartWorkUsingCollaboration is FALSE. If we don't reset the
	// following settings to FALSE, then the user should see the last selected
	// radio button still selected in the ChooseCollabOptionsDlg. This is
	// better I think that automatically selecting the second radio button
	// after a File > Close Project command. It is better to have the last
	// used setting remain persistent even after a close project command.
	//pApp->m_bCollaboratingWithParatext = FALSE;
	//pApp->m_bCollaboratingWithBibledit = FALSE;
	
	// Remove the parenthetical info from File > Open and File Save menu labels
	pApp->MakeMenuInitializationsAndPlatformAdjustments(); //(collabIndeterminate);

	// whm added 20Feb12. If no project is open, then we should not call
	// pDoc->OnFileClose() below. Although File > Close Projects won't
	// trigger OnFileCloseProject(), the unpacking of a packed document
	// calls CloseProject() which ends up calling this OnFileCloseProject()
	// handler. Then later the app wants to write out a project config
	// file which asserts and isn't appropriate when no project is open.
	// This situation can happen when the user cancels at the
	// Start Working Wizard and then does an Unpack Document... command.
	// Therefore I am adding a test for m_pKB being NULL and if so, we
	// bail out early from OnFileCloseProject().
	if (pApp->m_pKB == NULL)
	{
		wxLogDebug(_T("m_pKB is NULL - project is already closed."));
		// whm added 7Aug12. When the project is closed the m_curProjectPath should be an empty string.
		wxString msg = _T("m_pKB == NULL, returned early from OnFileCloseProject(): m_curProjectPath = %s");
		msg = msg.Format(msg,pApp->m_curProjectPath.c_str());
		pApp->LogUserAction(msg);
		pApp->m_curProjectPath.Empty();
		return;
	}

	// ask for saving of doc & both kbs (normal one and glossing one)
	pDoc->OnFileClose(event);

	if (bUserCancelled)
	{
		bUserCancelled = FALSE; // clear the flag to default situation
		wxString msg = _T("User cancelled from pDoc->OnFileClose() within OnFilecloseProject(): m_curProjectPath = %s");
		msg = msg.Format(msg,pApp->m_curProjectPath.c_str());
		pApp->LogUserAction(msg);
		return;
	}

	if (gbGlossingVisible)
	{
		// glossing is on, so we must ensure the menu toggle is turned off and the
		// glossing checkbox removed, so this can all be done with the following call
		OnAdvancedSeeGlosses(event);
	}

	if (pApp->m_bFreeTranslationMode)
	{
		// free translation mode is on, so we must first turn it off
		wxCommandEvent event;
		pApp->GetFreeTrans()->OnAdvancedFreeTranslationMode(event);
	}

	if (!gbIgnoreScriptureReference_Receive)
	{
		// scripture reference receiving is turned on, and it must be
		// off when there is no project current
		wxCommandEvent uevent;
		GetDocument()->OnAdvancedReceiveSynchronizedScrollingMessages(uevent); //toggle it to TRUE
	}

	if (!pApp->m_bIgnoreScriptureReference_Send)
	{
		// scripture reference sending is turned on, and it must be
		// off when there is no project current
		wxCommandEvent uevent;
		GetDocument()->OnAdvancedSendSynchronizedScrollingMessages(uevent); //toggle it to TRUE
	}

	// BEW 28Sep12, moved the KB erasures to be after the writing of the config file,
	// because ReleaseKBServer(), if called, needs to be called after the config file is
	// written (so that the latter stores correct m_bKBServerProject flag value), and the
	// in-memory KBs are still there in case ReleaseKBServer() needs to do any final
	// updating of the local KBs

	// update status bar with project name
	wxString message;
	// IDS_NO_PROJECT
	message = message.Format(_("No project is currently active - select \"Start Working...\" from the File menu to open a project"));
	if (pApp->m_bBookMode && !pApp->m_bDisableBookMode)
	{
		wxString mssg;
		wxString undef;
		undef = _(" Undefined");
		// IDS_CURFOLDER
		mssg = mssg.Format(_("  Current Folder: %s"),undef.c_str());
		message += mssg;
	}
	pApp->StatusBarMessage(message); // don't want a glossing/adapting prefix, since we are closing

    // restore the glossing support flags to their default values, so an open of another
    // project will have the default 2-rows per strip interface in effect
	gbIsGlossing = FALSE;
	gbGlossingVisible = FALSE;
	gbGlossingUsesNavFont = FALSE;

    // book folder mode may have been on; we can't be sure the next project opened will
    // have that mode on, or even that it may have been on in the project at an earlier
    // time, so the safe thing to do is to turn it off
	pApp->m_bBookMode = FALSE;
	if (pApp->m_pBibleBooks != NULL)
		pApp->m_bDisableBookMode = FALSE;
	else
		pApp->m_bDisableBookMode = TRUE;
	pApp->m_nBookIndex = -1;
	pApp->m_nDefaultBookIndex = 39; // default is Matthew
	pApp->m_nLastBookIndex = -1;
	pApp->m_pCurrBookNamePair = NULL;

	// whm added 27Apr12. When the project is closed, the project config file should be written
	// out to disk and then the m_curProjectPath should become empty so that the project config
	// file won't get written out at time when no project is open. The m_curProjectPaht is given
	// a new value when a project is subsequently opened.
	// Call WriteConfigurationFile(szProjectConfiguration, pApp->m_curProjectPath,projectConfigFile)
	// to save the settings in the project config file.
	bool bOK;
	if (!pApp->m_curProjectPath.IsEmpty())
	{
		if (pApp->m_bUseCustomWorkFolderPath && !pApp->m_customWorkFolderPath.IsEmpty())
		{
			// whm 10Mar10, must save using what paths are current, but when the custom
			// location has been locked in, the filename lacks "Admin" in it, so that it
			// becomes a "normal" project configuration file in m_curProjectPath at the
			// custom location.
			if (pApp->m_bLockedCustomWorkFolderPath)
				bOK = pApp->WriteConfigurationFile(szProjectConfiguration, pApp->m_curProjectPath,projectConfigFile);
			else
				bOK = pApp->WriteConfigurationFile(szAdminProjectConfiguration, pApp->m_curProjectPath,projectConfigFile);
		}
		else
		{
			bOK = pApp->WriteConfigurationFile(szProjectConfiguration, pApp->m_curProjectPath,projectConfigFile);
		}
		// we don't expect a write error, but tell the developer or user if the write
		// fails, and keep on processing
		if (!bOK)
		{
			wxString msg = _T("In OnFileCloseProject() WriteConfigurationFile() failed for project config file or admin project config file.");
			wxMessageBox(msg);
			pApp->LogUserAction(msg);
		}
	}
//#if defined(_KBSERVER)
	// BEW 28Sep12, clean up and make persistent any volatile data, if kbserver
	// support is active
	if (pApp->m_bIsKBServerProject)
	{
		pApp->ReleaseKBServer(1); // the adaptations one
		pApp->LogUserAction(_T("ReleaseKBServer(1) called in OnFileCloseProject()"));
	}
	if (pApp->m_bIsGlossingKBServerProject)
	{
		pApp->ReleaseKBServer(2); // the glossings one
		pApp->LogUserAction(_T("ReleaseKBServer(2) called in OnFileCloseProject()"));
	}
//#endif
	// BEW 28Sep12 moved KB erasure code to be here -- see note above
	// Delete each KB and make the app unable to use either further
	gbJustClosedProject = TRUE;
	if (pApp->m_pKB != NULL)
	{
		pDoc->EraseKB(pApp->m_pKB);
		pApp->m_bKBReady = FALSE;
		pApp->m_pKB = (CKB*)NULL; // done in EraseKB too
	}
	// now the glossing KB and flags
	if (pApp->m_pGlossingKB != NULL)
	{
		pDoc->EraseKB(pApp->m_pGlossingKB);
		pApp->m_bGlossingKBReady = FALSE;
		pApp->m_pGlossingKB = (CKB*)NULL; // done in EraseKB too
	}

	// BEW added 22Jan10, clear the KB search string arrays
    // whm 24Jul2018 added test to only call Clear() on m_arrSearches if its count is > 0.
    // To prevent a crash in a similar Clear() call when the array was empty in the CKBEDitor::OnOK()
    // handler, it was necessary to only call Clear() when the array was non-empty. So, out of
    // caution and to avoid a possible crash due to calling delete on a bad pointer, we'll do the
    // same test here.
    if (pApp->m_arrSearches.GetCount() > 0)
        pApp->m_arrSearches.Clear(); // set of search strings for dialog's multiline wxTextCtrl
    // whm 24JUL2018 added test for m_arrOldSearches below for same reason as for m_arrSearches 
    // above.
    if (pApp->m_arrOldSearches.GetCount() > 0)
	    pApp->m_arrOldSearches.Clear(); // old search strings accumulated while in this project

	// whm added 27Apr12. When the project is closed the m_curProjectPath should be an empty string.
	pApp->m_curProjectPath.Empty();

	// Ensure Guesser settings don't persist over the closure of the project which
	// may have been using them; we clear the flags, and empty the lists and arrays
	// by initializing the two Guesser objects (which are on the heap)
    // whm 13May2020 Note: I removed two assignments in the App's ClobberGuesser() function:
    //     m_bUseAdaptationsGuesser = TRUE; and
    //     m_nGuessingLevel = 50;
    // because, although ClobberGuesser() is called after the >WriteConfigurationFile(szProjectConfiguration,...)
    // call above, another >WriteConfigurationFile(szProjectConfiguration,...) call will happen subsequently
    // that will force a save of the two ClobberGuesser() assignments above - resulting in the user's changes
    // made within the GuesserSettingsDlg to be lost, i.e., the Guesser would otherwise alwyas be ON and at a
    // 50% level each time the project is opened. The Guesser now defaults to OFF for each session of Adapt It,
    // and only is ON for that sesssion if the user explicitly turns it ON in the Guesser Settings dialog.
	pApp->ClobberGuesser(); // it's only OnExit() which deletes the two Guesser objects
							// until then they must persist to be available for a new guesser setup
}

/////////////////////////////////////////////////////////////////////////////////
/// \return		nothing
/// \param      event   -> the wxUpdateUIEvent that is generated when the File Menu is about
///                         to be displayed
/// \remarks
/// Called from: The wxUpdateUIEvent mechanism when the associated menu item is selected,
/// and before the menu is displayed.
/// Disables the "Close Project" item on the File menu if Vertical Editing is in progress.
/// Enables the item if the KBs are in a ready state, otherwise it disables the menu item.
/////////////////////////////////////////////////////////////////////////////////

void CAdapt_ItView::OnUpdateFileCloseKB(wxUpdateUIEvent& event)
{
	if (gbVerticalEditInProgress)
	{
		event.Enable(FALSE);
		return;
	}
    
	CAdapt_ItApp* pApp = (CAdapt_ItApp*)&wxGetApp();
    
	// the kbs are closed or opened together, but if a trial is under way, the item is disabled no matter what
	event.Enable (pApp->m_bKBReady && pApp->m_bGlossingKBReady && (pApp->m_trialVersionNum < 0));
}

/////////////////////////////////////////////////////////////////////////////////
/// \return		nothing
/// \param      event   -> the wxUpdateUIEvent that is generated when the File Menu is about
///                         to be displayed
/// \remarks
/// Called from: The wxUpdateUIEvent mechanism when the associated menu item is selected,
/// and before the menu is displayed.
/// Disables the "New" item on the File menu if Vertical Editing or Paratext Collaboration
/// is in progress. Enables the item if the KB pointers are not NULL, and if the strip
/// count is zero (meaning no document is loaded), otherwise it disables the menu item.
/////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItView::OnUpdateFileNew(wxUpdateUIEvent& event)
{
	CAdapt_ItApp* pApp = (CAdapt_ItApp*)&wxGetApp();
	if (pApp->m_bClipboardAdaptMode)
	{
		event.Enable(FALSE);
		return;
	}
	// whm added 16May11. Disallow File "New" menu item when PT/BE collaboration is active
	if (pApp->m_bCollaboratingWithParatext || pApp->m_bCollaboratingWithBibledit)
	{
		event.Enable(FALSE);
		return;
	}

	if (gbVerticalEditInProgress)
	{
		event.Enable(FALSE);
		return;
	}
	// we can't use m_pSourcePhrases->GetCount() equal to zero because after a File...Close
	// only the view (ie. strips) is clobbered, the source phrases don't get clobbered until
	// DeleteContents() is called, which does not happen until either the user chooses New...
	// or Open... or the Wizard equivalents, or closes the app. So a zero strip count is
	// a sufficient condition.
	// whm 6Nov12 revised to use the more self-documenting
	// IsDocumentOpen() function.
	if (pApp->m_pKB != NULL && pApp->m_pGlossingKB != NULL && !pApp->IsDocumentOpen())
		event.Enable(TRUE);
	else
		event.Enable(FALSE);
}

//////////////////////////////////////////////////////////////////////////////////
/// \return		nothing
/// \param      event   -> the wxUpdateUIEvent that is generated when the File Menu is about
///                         to be displayed
/// \remarks
/// Called from: The wxUpdateUIEvent mechanism when the associated menu item is selected,
/// and before the menu is displayed.
/// Disables the "Open..." item on the File menu if Vertical Editing is in progress.
/// Enables the item if collaborating with Paratext/Bibledit. Enables the item if
/// the KB pointers are not NULL, and if the app's strip count is
/// zero, otherwise it disables the menu item.
/////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItView::OnUpdateFileOpen(wxUpdateUIEvent& event)
{
	CAdapt_ItApp* pApp = (CAdapt_ItApp*)&wxGetApp();
	if (pApp->m_bClipboardAdaptMode)
	{
		event.Enable(FALSE);
		return;
	}
	if (gbVerticalEditInProgress)
	{
		event.Enable(FALSE);
		return;
	}

	// whm added 25May11 When collaborating with Paratext or Bibledit we make the Open... command
	// always available just as we do for the Start Working Wizard in
	// OnUpdateFileStartupWizard().
	if (pApp->m_bCollaboratingWithParatext || pApp->m_bCollaboratingWithBibledit)
	{
		event.Enable(TRUE);
		return;
	}

    // we can't use m_pSourcePhrases->GetCount() equal to zero because after a File...Close
    // only the view (ie. strips) is clobbered, the source phrases don't get clobbered
    // until DeleteContents() is called, which does not happen until either the user
    // chooses New... or Open... or the Wizard equivalents, or closes the app. So a zero
    // strip count is a sufficient condition.
    // I've changed this now, the source phrases now get clobbered, but using the strip
    // count is still perfectly acceptable, so I'll leave it unchanged.
	// whm 6Nov12 revised to use the more self-documenting
	// IsDocumentOpen() function.
	if (pApp->m_pKB != NULL && pApp->m_pGlossingKB != NULL && !pApp->IsDocumentOpen())
		event.Enable(TRUE);
	else
		event.Enable(FALSE);
}

/////////////////////////////////////////////////////////////////////////////////
/// \return		nothing
/// \param      event   -> the wxUpdateUIEvent that is generated when the File Menu is about
///                         to be displayed
/// \remarks
/// Called from: The wxUpdateUIEvent mechanism when the associated menu item is selected,
/// and before the menu is displayed.
/// Disables the "Print..." item on the File menu if Vertical Editing is in progress.
/// Enables the item if the KBs are in a ready state, otherwise it disables the menu item.
/////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItView::OnUpdateFilePrint(wxUpdateUIEvent& event)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	//if (pApp->m_bClipboardAdaptMode || pApp->m_bFreeTranslationMode)
	if (pApp->m_bClipboardAdaptMode)
	{
		event.Enable(FALSE);
		return;
	}
	if (gbVerticalEditInProgress)
	{
		event.Enable(FALSE);
		return;
	}
	event.Enable(pApp->IsDocumentOpen());
}

/////////////////////////////////////////////////////////////////////////////////
/// \return		nothing
/// \param      event   -> the wxUpdateUIEvent that is generated when the File Menu is about
///                         to be displayed
/// \remarks
/// Called from: The wxUpdateUIEvent mechanism when the associated menu item is selected,
/// and before the menu is displayed.
/// Disables the "Print Preview" item on the File menu if Vertical Editing is in progress.
/// Enables the item if the KBs are in a ready state, otherwise it disables the menu item.
/////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItView::OnUpdateFilePrintPreview(wxUpdateUIEvent& event)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	//if (pApp->m_bClipboardAdaptMode || pApp->m_bFreeTranslationMode)
	if (pApp->m_bClipboardAdaptMode)
	{
		event.Enable(FALSE);
		return;
	}
	if (gbVerticalEditInProgress)
	{
		event.Enable(FALSE);
		return;
	}
	event.Enable(pApp->IsDocumentOpen());
}

// Modified by whm 14Feb05 to support USFM and SFM Filtering.
// BEW 22Feb10, modified for support of doc version 5
bool CAdapt_ItView::IsWrapMarker(CSourcePhrase* pSrcPhrase)
{
	// refactored 19Mar09 -- no changes needed
	// Version 3 implementation: We first extract each marker from
	// the pSrcPhrase->m_markers member, and use Find to check if it is
	// in the appropriate wrap string UsfmWrapMarkersStr, PngWrapMarkersStr,
	// or UsfmAndPngWrapMarkersStr, depending on which map set is active.

	CAdapt_ItApp* pApp = &wxGetApp();
	CAdapt_ItDoc* pDoc = GetDocument();
	wxString markerStr = pSrcPhrase->m_markers;

	// combine m_markers (but ignore m_endMarkers) and the m_filteredInfo markers other
	// than the filterMkr and filterMkrEnd ones - use for the tests below
	wxString unwrappedMkrs = _T("");
	if (!pSrcPhrase->GetFilteredInfo().IsEmpty())
	{
		unwrappedMkrs = pSrcPhrase->GetFilteredInfo();
		unwrappedMkrs = pDoc->GetUnFilteredMarkers(unwrappedMkrs);
		markerStr += unwrappedMkrs;
	}
	// NormalizeToSpaces leaves the markers in m_markers delimited by spaces, at
	// lease medially. We'll use the Tokenize CString method here.
	wxString sfm;
	bool bValue = FALSE;

	// BEW 21Jul14, ZWSP support: keep this as latin space
	wxStringTokenizer tkz(markerStr,_T(" "));

	while (tkz.HasMoreTokens())
	{
		sfm = tkz.GetNextToken();
		if (sfm[0] == gSFescapechar)	// Only check actual sfms. Some tokens will be only
										// numbers (those after \c and \v) which we ignore
		{
			// there shouldn't be any end marking asterisk * on a wrap marker, but
			// remove any that might exist for a clean search below.
			int endMkrPos = sfm.Find(_T('*'),TRUE); // TRUE finds from right end
			if (endMkrPos != -1)
				sfm = sfm.Left(endMkrPos);
			sfm.Trim(FALSE); // trim left end
			sfm.Trim(TRUE); // trim right end
			// BEW 21Jul14, ZWSP support: keep this as latin space
			sfm += _T(' '); // ensure the sfm is followed by a space for unique find in
							// our wrap strings.
			// If only one of the sfms within markerStr is a wrap marker, we should return TRUE.
			switch (pApp->gCurrentSfmSet)
			{
				case UsfmOnly:
				{
					if (pApp->UsfmWrapMarkersStr.Find(sfm) != -1)
						return TRUE; // it's in the wrap markers list, so start a new strip
					break;
				}
				case PngOnly:
				{
					if (pApp->PngWrapMarkersStr.Find(sfm) != -1)
						return TRUE; // it's in the wrap markers list, so start a new strip
					break;
				}
				case UsfmAndPng:
				{
					if (pApp->UsfmAndPngWrapMarkersStr.Find(sfm) != -1)
						return TRUE; // it's in the wrap markers list, so start a new strip
					break;
				}
				default:
				{
					// if we got here it would be a program error
					if (pApp->UsfmWrapMarkersStr.Find(sfm) != -1)
						return TRUE; // found the sfm, so start a new strip
				}
			} // end of switch (pApp->gCurrentSfmSet)
		}
	}

	// any other marker, we will just let it be ignored & go on setting up piles
	return bValue;
}

/////////////////////////////////////////////////////////////////////////////////
/// \return     the pointer to the CCell instance the user clicked
/// \param      pPoint  -> pointer to the wxPoint (logical coords) where the
///                        user clicked
/// \remarks
///
/// Interrogates the m_stripArray to termine which strip, pile and cell was clicked in;
/// returning the cell's pointer; it is the caller's responsibility to convert the client
/// coords for the click as returned from the event record, into a logical point, before
/// passing the result to GetClickedCell()
/////////////////////////////////////////////////////////////////////////////////
CCell* CAdapt_ItView::GetClickedCell(const wxPoint *pPoint)
{
	// refactored 6Apr09
	CLayout* pLayout = GetLayout();
	wxASSERT(pLayout != NULL);
	wxPoint point = *pPoint;
	CStrip* pStrip = NULL; // whm initialized to NULL
	CPile* pPile = NULL; // whm initialized to NULL
	CCell* pCell = NULL; // whm initialized to NULL
	wxRect rect;
	int	pileCountInStrip;
	int	pileIndexInStrip;
	int cellIndex;
	int stripIndex;
	wxArrayPtrVoid* pStripArray = pLayout->GetStripArray();
	int nStripCount = pStripArray->GetCount();

	// find the strip the click was in (we don't count a click on free translation text
	// as a valid click on the strip, neither is a click in the navText whiteboard area)
	for (stripIndex = 0; stripIndex < nStripCount; stripIndex++)
	{
		pStrip = (CStrip*)pStripArray->Item(stripIndex);
		wxASSERT(pStrip != NULL);
		pStrip->GetStripRect_CellsOnly(rect);
		rect = NormalizeRect(rect); // use our own from helpers.h
		if (rect.Contains(point))
			break;
	}
	if (stripIndex == nStripCount || pStrip == NULL)
		return NULL; // did not click within a strip
	else
	{
		// find which pile of the strip the click was in
		wxArrayPtrVoid*	pPilesArray = pStrip->GetPilesArray(); // gets ptr to m_arrPiles
		pileCountInStrip = pPilesArray->GetCount();
		for (pileIndexInStrip = 0; pileIndexInStrip < pileCountInStrip; pileIndexInStrip++)
		{
			pPile = (CPile*)pPilesArray->Item(pileIndexInStrip);
			pPile->GetPileRect(rect);
			rect = NormalizeRect(rect); // use our own from helpers.h
			if (rect.Contains(point))
				break;
		}
		if (pileIndexInStrip == pileCountInStrip || pPile == NULL)
			return NULL; // did not click within a pile - clicked in a gap, or at end, or in margin
		else
		{
			// find which cell the click was in
			for (cellIndex = 0; cellIndex < MAX_CELLS; cellIndex++)
			{
				pCell = pPile->GetCellArray()[cellIndex];
				if (pCell == NULL)
					continue;
				pCell->GetCellRect(rect);
				rect = NormalizeRect(rect); // use our own from helpers.h
				if (rect.Contains(point))
					break;
			}
			if (cellIndex == MAX_CELLS)
				return NULL; // click was not in a cell
		}
	}
	return pCell;
}

/////////////////////////////////////////////////////////////////////////////////
/// \return     return NULL if the click was not in a strip or its leading area - it should
///             be impossible to return NULL though; otherwise return the CStrip pointer
/// \param      pPoint  -> pointer to the wxPoint (logical coords) where the user clicked
/// \remarks
///
/// Interrogates the m_stripArray to termine which strip, or the leading just above it, the
/// user clicked in - returning the strip's pointer; it is the caller's responsibility to
/// convert the client coords for the click as returned from the event record, into a
/// logical point, before passing the result to GetNearestStrip()
/// The pStrip pointer passed back is the pointer to a CStrip instance, but we determine
/// that the strip was clicked on if either it or the leading area was clicked on - since
/// the note or wedge icons will be in the leading area.
/////////////////////////////////////////////////////////////////////////////////
CStrip* CAdapt_ItView::GetNearestStrip(const wxPoint *pPoint)
{
	// refactored 6Apr09
	CLayout* pLayout = GetLayout();
	wxASSERT(pLayout != NULL);
	wxArrayPtrVoid* pStripArray = pLayout->GetStripArray();
	int nStripCount = pStripArray->GetCount();

	wxPoint point = *pPoint;
	CStrip* pStrip = NULL;
	wxRect rect;
	int leading = pLayout->GetCurLeading(); // defines the vertical extent of the nav
											// text area above the strip
	int stripIndex;
	for (stripIndex = 0; stripIndex < nStripCount; stripIndex++)
	{
		pStrip = (CStrip*)(*pStripArray)[stripIndex];
		pStrip->GetStripRect_CellsOnly(rect);
		rect = NormalizeRect(rect); // use our own from helpers.h
        // subtract the leading from the top, because it's within there that we expect
        // clicks on the wedge to happen
        rect.SetTop(rect.GetTop()- leading); // In wx's wxRect, this only moves the x,y
                // coordinate and consequently the whole box, leaving the height the same,
                // therefore, we also need to reset the height to include the leading value
		rect.SetHeight(rect.GetHeight() + leading); // whm added
        // BEW changed 02Aug05 to handle RTL layout better - for these the click could be
        // outside the strip rectangle for a wedge offset to the right and at the right
        // edge of the strip; so instead just check that the vertical offset for the click
        // falls on or within the top and bottom coords of the rect
		if (point.y >= rect.GetTop() && point.y <= rect.GetBottom())
			break;
	}
	if (stripIndex == nStripCount)
		return NULL; // did not click within a strip or its leading area above it
	else
		return pStrip;
}

void CAdapt_ItView::RemovePrecedingAnchor(wxClientDC* pDC, CCell *pAnchor)
{
	// refactored 6Apr09
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	CCellList::Node* pos_pCellList = pApp->m_selection.Find(pAnchor);
	wxASSERT(pos_pCellList != NULL); // the anchor MUST be in the list!
	//CCell* pCell; // set but unused
	//pCell = (CCell*)pos_pCellList->GetData(); // the earliest of desired seln
	pos_pCellList = pos_pCellList->GetPrevious();
	if (pos_pCellList != NULL)
	{
		// there is selected CCell previous to the anchor cell,
		// so get rid of it & any earlier ones
		CCell* pPrevCell;
		while (pos_pCellList != NULL)
		{
			CCellList::Node* savePos = pos_pCellList;
			pPrevCell = (CCell*)pos_pCellList->GetData();
			pos_pCellList = pos_pCellList->GetPrevious();
			pDC->SetBackgroundMode(pApp->m_backgroundMode);
			pDC->SetTextBackground(wxColour(255,255,255)); // white
			pPrevCell->DrawCell(pDC, GetLayout()->GetSrcColor());
			pPrevCell->SetSelected(FALSE);
			pApp->m_selection.DeleteNode(savePos);
		}
	}
}

void CAdapt_ItView::RemoveFollowingAnchor(wxClientDC *pDC, CCell *pAnchor)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	CCellList::Node* pos_pCellList = pApp->m_selection.Find(pAnchor);
	wxASSERT(pos_pCellList != NULL); // the anchor MUST be in the list!
	//CCell* pCell; // set but unused
	//pCell = (CCell*)pos_pCellList->GetData(); // the last cell of desired seln
	pos_pCellList = pos_pCellList->GetNext();
	if (pos_pCellList != NULL)
	{
		// there is selected CCell after the anchor cell,
		// so get rid of it & any later ones
		CCell* pFollCell;
		while (pos_pCellList != NULL)
		{
			CCellList::Node* savePos = pos_pCellList;
			pFollCell = (CCell*)pos_pCellList->GetData();
			pos_pCellList = pos_pCellList->GetNext();
			pDC->SetBackgroundMode(pApp->m_backgroundMode);
			pDC->SetTextBackground(wxColour(255,255,255)); // white
			pFollCell->DrawCell(pDC, GetLayout()->GetSrcColor());
			pFollCell->SetSelected(FALSE);
			pApp->m_selection.DeleteNode(savePos);
		}
	}
}

void CAdapt_ItView::RemoveEarlierSelForShortening(wxClientDC *pDC, CCell *pEndCell)
{
    // the "end cell" will be towards the left of the selection list (or at its start) when
    // the layout direction is either LTR or RTL, because we store in logical order. (Lower
    // sequence numbers are to the left.)

	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	//CCell* pCell; // set but unused
	CCellList::Node* pos_pCellList = pApp->m_selection.Find(pEndCell);
	if (pos_pCellList != NULL)
	{
		//pCell = (CCell*)pos_pCellList->GetData(); // the earliest of desired seln, for LTR
		pos_pCellList = pos_pCellList->GetPrevious();
		if (pos_pCellList != NULL)
		{
			// there is previous selected CCell, so user must have shortened sel'n
			// so get rid of it & any earlier ones
			CCell* pPrevCell;
			while (pos_pCellList != NULL)
			{
				CCellList::Node* savePos = pos_pCellList;
				pPrevCell = (CCell*)pos_pCellList->GetData();
				pos_pCellList = pos_pCellList->GetPrevious();
				pDC->SetBackgroundMode(pApp->m_backgroundMode);
				pDC->SetTextBackground(wxColour(255,255,255)); // white
				pPrevCell->DrawCell(pDC, GetLayout()->GetSrcColor());
				pPrevCell->SetSelected(FALSE);
				pApp->m_selection.DeleteNode(savePos);
			}
		}
	}
}

void CAdapt_ItView::RemoveLaterSelForShortening(wxClientDC *pDC, CCell *pEndCell)
{
    // the "end cell" will be towards the right of the selection list (or at its end) when
    // the layout direction is either LTR or RTL, because we store in logical order not
    // visible order (ie. larger sequence numbers are to the right in the list)
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	//CCell* pCell; // set but unused
	CCellList::Node* pos_pCellList = pApp->m_selection.Find(pEndCell);
	if (pos_pCellList != NULL)
	{
		//pCell = (CCell*)pos_pCellList->GetData(); // the last of desired seln
		pos_pCellList = pos_pCellList->GetNext();
		if (pos_pCellList != NULL)
		{
			// there is another selected CCell, so user must have shortened sel'n
			// so get rid of it & any subsequent ones
			CCell* pLaterCell;
			while (pos_pCellList != NULL)
			{
				CCellList::Node* savePos = pos_pCellList;
				pLaterCell = (CCell*)pos_pCellList->GetData();
				pos_pCellList = pos_pCellList->GetNext();
				pDC->SetBackgroundMode(pApp->m_backgroundMode);
				pDC->SetTextBackground(wxColour(255,255,255)); // white
				pLaterCell->DrawCell(pDC, GetLayout()->GetSrcColor());
				pLaterCell->SetSelected(FALSE);
				pApp->m_selection.DeleteNode(savePos);
			}
		}
	}
}

bool CAdapt_ItView::IsBoundaryCell(CCell *pCell)
{
	return pCell->GetPile()->GetSrcPhrase()->m_bBoundary;
}

// returns the cell immediately preceding the pCell one, regardless of where boundaries
// are; returns null if no previous cell
CCell* CAdapt_ItView::GetPrevCell(CCell *pCell, int cellIndex)
{
	// refactored 7Apr09
	CPile* pPile = pCell->GetPile();
	PileList* pPiles = GetLayout()->GetPileList();
	int index = pPiles->IndexOf(pPile);
	index--; // index of previous CPile instance, could exceed bound
	if (index < 0)
	{
		return NULL; // bounds error - passed beginning of document
	}
	else
	{
		// not past beginning of document
		PileList::Node* pos_pPile = pPiles->Item(index);
		pPile = pos_pPile->GetData();
		wxASSERT(pPile != NULL);
	}
	return pPile->GetCell(cellIndex);
}

void CAdapt_ItView::RemoveSelection()
{
	// refactored 7May09
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	wxCommandEvent dummyevent;
	pApp->m_bSelectByArrowKey = FALSE;
	if (pApp->m_selection.IsEmpty())
	{
		// if no selection is current, just ensure sel'n parameters are zeroed
		pApp->m_selectionLine = -1;
		pApp->m_pAnchor = (CCell*)NULL;

		// and the globals also
		gnSelectionLine = -1;
		gnSelectionStartSequNum = -1;
		gnSelectionEndSequNum = -1;
		return;
	}
	wxClientDC aDC(pApp->GetMainFrame()->canvas);
	CCell* pCell;

	// there is a current selection, so clobber it
	CCellList::Node* pos_pCellList = pApp->m_selection.GetFirst();
	while (pos_pCellList != NULL)
	{
		pCell = (CCell*)pos_pCellList->GetData();
		pos_pCellList = pos_pCellList->GetNext();
		aDC.SetBackgroundMode(pApp->m_backgroundMode); // Do not use wxTRANSPARENT!!
												// because background is not updated
		aDC.SetTextBackground(wxColour(255,255,255)); // white
		pCell->DrawCell(&aDC, GetLayout()->GetSrcColor());
		pCell->SetSelected(FALSE);
	}
	pApp->m_selection.Clear();
	pApp->m_selectionLine = -1;
	pApp->m_pAnchor = (CCell*)NULL;

	// and the globals also need to be set to a "no selection" state
	gnSelectionLine = -1;
	gnSelectionStartSequNum = -1;
	gnSelectionEndSequNum = -1;

	// toggle Respect Boundaries button back on, so m_bRespectBoundaries is reset TRUE
	if (!pApp->m_bRespectBoundaries)
		OnToggleRespectBoundary(dummyevent);// FromIgnoringBdryToRespectingBdry(dummyevent);
}

// DeepCopySublist2Sublist was in Helpers.cpp in the legacy version.
// Copies CSourcePhrase instances to an empty pCopiedSublist, as deep copies, and
// preserves m_nSequNumber values in the copies
// Called only once, in OnEditSourceText()
// BEW 22Mar10, updated for support of doc version 5 (no changes needed)
void CAdapt_ItView::DeepCopySublist2Sublist(SPList* pOriginalList, SPList* pCopiedSublist)
{
	if (pOriginalList->GetCount() == 0)
		return;
	SPList::Node* pos_pOriginalList = pOriginalList->Item(0);
	wxASSERT(pos_pOriginalList);
	//SPList::Node* savePos = NULL; // set but unused
	CSourcePhrase* pSrcPhrase = NULL;
	while (pos_pOriginalList != NULL)
	{
		// deep copy each until all are copied
		//savePos = pos_pOriginalList;
		pSrcPhrase = pos_pOriginalList->GetData();
		pos_pOriginalList = pos_pOriginalList->GetNext();
		CSourcePhrase* pNewSP = new CSourcePhrase(*pSrcPhrase); // uses operator=,
															    // does shallow copy
		pNewSP->DeepCopy(); // pNewSP is now a deep copy
		pCopiedSublist->Append(pNewSP);
	}
}

// RemoveFilterWrappersButLeaveContent was in Helpers.cpp in the legacy version.
// removes "\~FILTER" and "\~FILTER*" from str, but leaves the SFM, its content, and any
// following endmarker followed by any whitespace etc.
// BEW 23Mar10 updated for support of doc version 5 (no changes needed)
// BEW 9July10, no changes needed for support of kbVersion 2
void CAdapt_ItView::RemoveFilterWrappersButLeaveContent(wxString& str)
{
	// uses global strings, filterMkr and filterMkrEnd; removes the latter first, and then
	// the former
	CAdapt_ItApp* pApp = &wxGetApp();
	CAdapt_ItDoc* pDoc = pApp->GetDocument();
	wxString strRemoveThis = filterMkrEnd;
	int len = strRemoveThis.Length();
	wxString strBegin;
	wxString strEnd;
	wxChar ch;
	bool bIsWhitespace = FALSE;
	int offset = -1;
	do {
		offset = str.Find(strRemoveThis);
		if (offset != -1)
		{
			// there is one to be removed
			strBegin = str.Left(offset);
			strEnd = str.Mid(offset);
			strEnd = strEnd.Mid(len); // this removes the "\\~FILTER*" which we found
			// now remove any following whitespace, which now is at the start of strEnd
			ch = strEnd[0];
			bIsWhitespace = pDoc->IsWhiteSpace(&ch);
			while (bIsWhitespace)
			{
				strEnd = strEnd.Mid(1); // remove initial white space character
				ch = strEnd[0];
				bIsWhitespace = pDoc->IsWhiteSpace(&ch);
			}
			// now rejoin the begin and end parts
			str = strBegin + strEnd;
		}
	} while (offset != -1);
	// now do the loop to remove any instances of "\\~FILTER" followed by whitespace
	strRemoveThis = filterMkr;
	len = strRemoveThis.Length();
	offset = -1;
	do {
		offset = str.Find(strRemoveThis);
		if (offset != -1)
		{
			// there is one to be removed
			strBegin = str.Left(offset);
			strEnd = str.Mid(offset);
			strEnd = strEnd.Mid(len); // this removes the "\\~FILTER*" which we found
			// now remove any following whitespace, which now is at the start of strEnd
			bIsWhitespace = pDoc->IsWhiteSpace(&ch);
			while (bIsWhitespace)
			{
				strEnd = strEnd.Mid(1); // remove initial white space character
				bIsWhitespace = pDoc->IsWhiteSpace(&ch);
			}
			// now rejoin the begin and end parts
			str = strBegin + strEnd;
		}
	} while (offset != -1);
}

// ReplaceCSourcePhrasesInSpan was in Helpers.cpp in the legacy version.
/////////////////////////////////////////////////////////////////////////////////
/// \return     TRUE if there were no errors, FALSE if there was an error. (Also, if either
///             list is empty, nothing is done and the function returns FALSE.)
/// \param      pMasterList        -> pointer to the list of CSourcePhrase pointers where the
///                                   replacements are to be done (typically, the app's
///                                   m_pSourcePhrases list)
/// \param      nStartAt           -> the 0-based index into the pMasterList which is the first
///                                   CSourcePhrase instance to be replaced (the originals
///                                   are deleted, the replacments are inserted in the gap
///                                   where they were located)
/// \param      nHowMany           -> the 1-based count of how many consecutive CSourcePhrase
///                                   pointers are to be removed from pMasterList to make way
///                                   for the replacements; this value must not be zero
/// \param      pReplacementsList  -> pointer to the list from which all or a subrange of
///                                   replacement CSourcePhrase instances are to be inserted
///                                   where the originals were removed from in pMasterList
/// \param      nReplaceStartAt    -> 0-based index into pReplacementsList which locates the
///                                   first CSourcePhrase instance which is to be inserted
///                                   into pMasterList
/// \param      nReplaceCount      -> 1-based count of how many consecutive CSourcePhrase
///                                   pointers are to be inserted into pMasterList.
///                                   (nReplaceCount can be less, equal, or greater than
///                                   nHowMany.) Note: this value can be zero, in which
///                                   case no insertions are done, but the deletions are done
/// \remarks
/// Called from: the View's RestoreDocAfterSrcTextEditModifiedIt(), OnEditSourceText(),
/// OnCustomEventAdaptationsEdit(), OnCustomEventGlossesEdit(),
/// This is a utility function for clearing out a span of CSourcePhrase instances from a
/// list and replacing them with a different span taken from some part (or the whole) of
/// some other list.
/// The ones cleared out are deleted (their contents are lost), the ones inserted are then
/// managed by the pMasterList, and usually that list is persistent, and the
/// pReplacementsList is temporary, but neither assumption is necessary or assumed. The
/// contents of pReplacementsList are not altered; so what actually are inserted are deep
/// copies of the instances in pReplacementsList. The nHowMany and nReplaceCount parameters
/// must not both be zero, if that is the case, it is an error.
///
/// The nReplaceCount value can be zero, if it is, the function is just being used to
/// delete a range of CSourcePhrase instances within a list.
/// The nHowMany value can be zero, if it is, the function is just being used to insert a
/// range of CSourcePhrase instances within a list, preceding the nStartAt instance's
/// location. BEW added to, 19Jun09. If some replacements are to be done at the doc end
/// (eg. after an edit which removed some words, and it goes belly up and the code tries to
/// restore original doc, calling this function) then nStartAt will be just beyond the
/// current end of the document. The older code did not test for this and then the
/// Item(nStartAt) produced a crash. The fix is to test for this bounds error, and send
/// control to a block of code which merely appends the replacements, rather than trying to
/// do insertions.
/// BEW 22Mar10, updated for support of doc version 5 (no changes needed)
/// BEW 9July10, no changes needed for support of kbVersion 2
/// BEW 23Nov12, refactored the following to remove logic error and improve the needlessly
/// convoluted logic and the goto label
/////////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItView::ReplaceCSourcePhrasesInSpan(SPList* pMasterList, int nStartAt, int nHowMany,
					SPList* pReplacementsList, int nReplaceStartAt, int nReplaceCount)
{
	// 26May08	function created as part of refactoring the Edit Source Text functionality
	// whm note: Bruce has this function in helpers.h and .cpp, but it is only used in the
	// View so I moved it to the View.
    // (BEW 22Mar10, this could go back in helpers.cpp as it is a potential
    // utility function which could be used in other places at a later date.)
	CAdapt_ItApp* pApp = &wxGetApp();
	CAdapt_ItDoc* pDoc = GetDocument();
	SPList::Node* posMaster = NULL; 
	SPList::Node* posReplace = NULL;
	wxString error;
    // do nothing if either list has no elements, or if nothing; treat it as an error state
	if (pMasterList->GetCount() == 0)
		return FALSE;
	if (pReplacementsList->GetCount() == 0)
		return FALSE;
	if (nHowMany == 0 && nReplaceCount == 0)
		return FALSE;
	CSourcePhrase* pSrcPhrase = NULL;
	CSourcePhrase* pReplaceSrcPhrase = NULL;
	CSourcePhrase* pDeepCopiedSrcPhrase = NULL;
//#ifdef _debugLayout
//ShowSPandPile(393, 30);
//ShowSPandPile(394, 30);
//ShowInvalidStripRange();
//#endif
	int maxIndex = pApp->GetMaxIndex();
	if (nStartAt > maxIndex)
	{
		// just append the replacements
		posReplace = pReplacementsList->Item(nReplaceStartAt);
		int anIndex;
		SPList::Node* pos_partialList = NULL;
		int endAt = nReplaceStartAt + nReplaceCount -1;
		for (anIndex = nReplaceStartAt; anIndex <= endAt; anIndex++)
		{
			pReplaceSrcPhrase = posReplace->GetData();
			posReplace = posReplace->GetNext();
			pDeepCopiedSrcPhrase = new CSourcePhrase(*pReplaceSrcPhrase);
			pDeepCopiedSrcPhrase->DeepCopy(); // make the deep copy
			wxASSERT(pDeepCopiedSrcPhrase != NULL);
			// add each deep copy to the end of the master list
			pos_partialList = pMasterList->Append(pDeepCopiedSrcPhrase);
			pos_partialList = pos_partialList; // avoid warning
			pDoc->CreatePartnerPile(pDeepCopiedSrcPhrase);
		}
		return TRUE;
	}
	else
	{
		posMaster = pMasterList->Item(nStartAt);
		if (posMaster == NULL)
		{
			// whm note: I don't think this error needs to be translated for localization
			// an unexpected exception, so inform the caller & advise the user of the error
			error = _T(
"FindIndex() failed in helper function ReplaceCSourcePhrasesInSpan(), posMaster value is NULL. ");
			error += _T("Abandoning current operation.");
			error += _T(" (If restoring document's original state, it is not properly restored.");
			wxMessageBox(error, _T(""), wxICON_EXCLAMATION | wxOK);
			return FALSE;
		}
	}
//#ifdef _debugLayout
//ShowSPandPile(393, 31);
//ShowSPandPile(394, 31);
//ShowInvalidStripRange();
//#endif
	posReplace = pReplacementsList->Item(nReplaceStartAt);
	if (posMaster == NULL)
	{
		// whm note: I don't think this error need to be translated for localization
		// an unexpected exception, so inform the caller & advise the user of the error
		error = _T(
"FindIndex() failed in helper function ReplaceCSourcePhrasesInSpan(), posReplace value is NULL. ");
		error += _T("Abandoning current operation.");
		error += _T(" (If restoring document's original state, it is not properly restored.");
		wxMessageBox(error, _T(""), wxICON_EXCLAMATION | wxOK);
		return FALSE;
	}

	// First delete the old (ie. unwanted) instances from the main list; then insert or
	// append the replacements depending on where the deletions had been done. Note, if
	// nHowMany is 0, then no deletions are wanted, just insertions.
	SPList::Node* posSaved = NULL;
	SPList::Node* pos_partialList = NULL;
	int index;
//#ifdef _debugLayout
//ShowSPandPile(393, 32);
//ShowSPandPile(394, 32);
//ShowInvalidStripRange();
//#endif
	// delete the range of originals from pMasterList, none are deleted if nHowMany is 0
	for (index = 0; index < nHowMany; index++)
	{
		posSaved = posMaster;
		wxASSERT(posSaved);
		pSrcPhrase = posMaster->GetData(); // assume success
		posMaster = posMaster->GetNext();
		pApp->GetDocument()->DeleteSingleSrcPhrase(pSrcPhrase); // delete pSrcPhrase
			// and its elements from memory locations; also calls DeletePartnerPile()
		pMasterList->DeleteNode(posSaved);	// delete the list's pSrcPhrase element
		// break out of the loop if we have come to the end of the pMasterList
		if (posMaster == NULL)
			break;
	}

	// now insert the non-empty range of replacements at the same location, or append
	// them at the end if the deletions were done to the end
	if (nStartAt == (int)pMasterList->GetCount())
	{
        // there is no CSourcePhrase instance now at the nStartAt value, because we
        // deleted right to the end of the master list inclusively, so we only need
        // append each to the tail of the pMasterList
		for (index = 0; index < nReplaceCount; index++)
		{
			// get a deep copy
			pReplaceSrcPhrase = posReplace->GetData();
			posReplace = posReplace->GetNext();
			pDeepCopiedSrcPhrase = new CSourcePhrase(*pReplaceSrcPhrase);
			pDeepCopiedSrcPhrase->DeepCopy(); // make the deep copy
			wxASSERT(pDeepCopiedSrcPhrase != NULL);
			// append each deep copy to the master list
			pos_partialList = pMasterList->Append(pDeepCopiedSrcPhrase);

			// BEW added 13Mar09 for refactored layout
			pDoc->CreatePartnerPile(pDeepCopiedSrcPhrase); // also marks the owning
											// strip, or a nearby one, as invalid
			// break out of loop if we have come to the end of the replacements list
			if (pReplaceSrcPhrase == NULL)
				break;
		}
//#ifdef _debugLayout
//ShowSPandPile(393, 33);
//ShowSPandPile(394, 33);
//ShowInvalidStripRange();
//#endif
	}
	else
	{
        // there is a CSourcePhrase instance at the nStartAt location, it has moved
        // down to occupy the location at which the earlier deletions were
        // started, so we must now insert before it
		posMaster = pMasterList->Item(nStartAt);
		if (posMaster == NULL)
		{
			// an unexpected exception, so inform the caller & advise the developer
			// of the error
			error = _T(
			"FindIndex() failed in helper function ReplaceCSourcePhrasesInSpan(), ");
			error += _T(
			"posMaster value is NULL when finding the position of first CSourcePhrase ");
			error += _T("following the gap. Abandoning current operation.");
			error += _T(
			" (If restoring document's original state, it is not properly restored.");
			wxMessageBox(error, _T(""), wxICON_EXCLAMATION | wxOK);
			return FALSE;
		}
//#ifdef _debugLayout
//ShowSPandPile(393, 35);
//ShowSPandPile(394, 35);
//ShowInvalidStripRange();
//#endif
//#ifdef _DEBUG
		//SPList::Node* posDebug = pMasterList->GetFirst();
		//for (index = 0; index < (int)pMasterList->GetCount(); index++)
		//{
		//	CSourcePhrase* pSrcPh;
		//	pSrcPh = posDebug->GetData();
		//	posDebug = posDebug->GetNext();
		//	wxLogDebug(_T("pMasterList BEFORE Insert: pSrcPh->m_srcPhrase = %s"),
		//	pSrcPh->m_srcPhrase.c_str());
		//}
//#endif
		for (index = 0; index < nReplaceCount; index++)
		{
			// insert them in normal order, each preceding the posMaster position
			pReplaceSrcPhrase = posReplace->GetData();
			posReplace = posReplace->GetNext();
			pDeepCopiedSrcPhrase = new CSourcePhrase(*pReplaceSrcPhrase);
			pDeepCopiedSrcPhrase->DeepCopy(); // make the deep copy
			wxASSERT(pDeepCopiedSrcPhrase != NULL);
			// insert each deep copy before the posMaster location each time
			pos_partialList = pMasterList->Insert(posMaster, pDeepCopiedSrcPhrase);
			pos_partialList = pos_partialList; // avoid warning
			// BEW added 13Mar09 for refactored layout
			pDoc->CreatePartnerPile(pDeepCopiedSrcPhrase); // also marks its or a
														// nearby strip as invalid
//#ifdef _debugLayout
//ShowSPandPile(393, 34);
//ShowSPandPile(394, 34);
//ShowInvalidStripRange();
//#endif
			// break out of loop if we have come to the end of the replacements list
			if (pReplaceSrcPhrase == NULL)
				break;
		}
//#ifdef _DEBUG
		//posDebug = pMasterList->GetFirst();
		//for (index = 0; index < (int)pMasterList->GetCount(); index++)
		//{
		//	CSourcePhrase* pSrcPh;
		//	pSrcPh = posDebug->GetData();
		//	posDebug = posDebug->GetNext();
		//	wxLogDebug(_T("pMasterList AFTER Insert: pSrcPh->m_srcPhrase = %s"),
		//	pSrcPh->m_srcPhrase.c_str());
		//}
//#endif
	}
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////////
///	GetMarkerArrayFromString
///
///	Returns:	a CString containing one or more whole markers (ie. including
///                backslash) and each with a delimiting single space following it,
///                including the last
///	Parameters:
///		pStrArr	<-	populated with CStrings, each being a whole marker
///		            (no delimiting space)
///		str		->	ref to the string containing a mix of markers and text (e.g.
///                 SFM marked up source text) from which the whole markers are
///                 to be found and inserted into the aray returned to the caller
///	Comments:
///    Extracts an array of whole markers, in order of occurrence (not sorted). There might
///    not be might not be any SF markers in the passed in str, in which case an empty
///    array is returned. The array's initial size (0) and growby value (1) are set first
///    here before it is populated. We are not interested in preventing multiple identical
///    entries because the function that will use the returned array is interested only in
///    the unique markers, and works whether there are repeats or not. (Used by the
///    AreMarkerArraysDifferent() helper function, which is used in the Edit Source Text
///    refactored code (see OnEditSourceText()) to detect when the user has modified a
///    marker when doing his edit - such as when correcting a misspelled marker to be what
///    it should be.)
///	History:
///	Created 17June08 by BEW, for support of refactored Source Text Edit functionality
///
/////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItView::GetMarkerArrayFromString(wxArrayString* pStrArr, const wxString& str)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	CAdapt_ItDoc* pDoc = pApp->GetDocument();
	pStrArr->Clear();
	wxString aMarker;
	wxString s(str); // we'll modify only this local copy
	int offset = 0;
	wxChar backslash = _T('\\');
	offset = FindFromPos(s,backslash,offset);
	if (offset == -1)
		return;
	int index = 0;
	while (offset != -1)
	{
		s = s.Mid(offset); // point at the backslash of the marker
		aMarker = pDoc->GetWholeMarker(s);
		// insert in the array
		// whm Note: wxArrayInt doesn't have MFC's SetAtGrow() method, but we can
		// accomplish the same thing. We can use the ::SetCount() method of wxArray to
		// ensure the array has at least anArrayIndex + 1 elements, then assign locIndex
		// to element anArrayIndex. We only call SetCount() if the array is too small.
		if (index+1 > (int)pStrArr->GetCount())
			pStrArr->SetCount(index+1); // any added elements to the array are assigned
										// int(0) by default
		(*pStrArr)[index] = aMarker;
		// point past the backslash & get the offset to the next marker
		offset++;
		offset = FindFromPos(s,backslash,offset);
		index++;
	}
}

/////////////////////////////////////////////////////////////////////////////////
///
///	IsMarkerInArray
///
///	Returns:	TRUE if the array contains at least one instance of the whole marker
///	            being tested, FALSE if the marker is absent from the array, or the
///	            array is empty
///
///	\param	pStrArr	->	populated with CStrings, each being a whole marker (no
///                     delimiting space), derived from a string containing a mix of
///                     markers and their text content
///	\param	marker	->	a SF marker, including initial backslash, and with no
///		                delimiting space at the end
///	\remarks
///    Iterates through the whole array, testing for identity with the passed in marker. As
///    soon as a match is made, it returns. (Used by the AreMarkerArraysDifferent() helper
///    function). If the array contains no elements, the return result is FALSE.
///
///	History:
///	Created 17June08 by BEW, for support of refactored Source Text Edit functionality
///	BEW 23Mar10, no changed needed for support of doc version 5
/////////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItView::IsMarkerInArray(wxArrayString* pStrArr, const wxString& marker)
{
	int index;
	wxString aMarker;
	int nSize = pStrArr->GetCount();
	if (nSize == 0)
		return FALSE;
	for (index = 0; index < nSize; index++)
	{
		aMarker = (*pStrArr)[index];
		wxASSERT(!aMarker.IsEmpty());
		if (aMarker == marker)
			return TRUE;
	}
	return FALSE; // no match was made
}

/////////////////////////////////////////////////////////////////////////////////
///	\return    TRUE if the arrays are different (meaning that one or the other has
///            at least one SF marker which is not in the other, repeated markers will
///            have more than one entry in the passed in array(s), but that is not
///            relevant to the result)
///	\param     str1	                   ->	a string containing marked up (SFM or USFM)
///	                                        text, such as source text
///	\param	   str2	                   ->	a string containing marked up (SFM or USFM)
///	                                        text, such as edited source text
///	\param     bUnfilteringRequired	   <-	TRUE if a "to-be-unfiltered" entry is added
///	                                        to m_FilterStatusMap, FALSE if not
///	\param     bFilteringRequired	   <-	TRUE if a "to-be-filtered" entry is added to
///	                                        m_FilterStatusMap, FALSE if not
///\remarks
///    Compares the unique markers in the strings, looking for evidence that there is at
///    least one marker which is not in the other string. It is done in both directions, in
///    case one of the strings has a subset of markers which are in the other - as testing
///    the contents of just one string agains the contents of the other (with perhaps an
///    extra unique marker) could produce a FALSE result, when doing it the other way round
///    would produce a TRUE result. So we do it both ways to make sure the result is
///    correct. An string without markers tested against one with one or more in it will
///    also generate a TRUE result; both strings lacking SF markers generates a FALSE
///    result.
///
///    IMPORTANT note regarding usage: str1 must be the original editable source text
///    string, str2 must be the new source text string, because the code added on 4July08
///    tests each marker in str2 to see if it is included in str1, and each which fails
///    that test will cause an entry to be added to m_FilterStatusMap which is a document
///    class member which controls the operation of RetokenizeText() when filter changes
///    are relevant to the document rebuild. BEW changed, to exclude dependence on
///    m_FilterStatusMap
///
///	History:
///	Created 17June08 by BEW, for support of refactored Source Text Edit functionality
///    4July08, BEW added code for adding entries to m_FilterStatusMap; the code should
///    handle most situations but is not foolproof, and it relies on the caller supplying
///    the original editable text as str1, and the new editable text as str2.
///    6July08, BEW removed the need to use m_FilterStatusMap entries in the
///    OnEditSourceText() refactored code by using DoMarkerHousekeeping() over the whole
///    document, rather than rebuilding the whole document using the RetokenizeText() call
///    as the legacy function used to do; consequently the calls to
///    AddEntryToFilterStatusMap() below are commented out, and two functions are thereby
///    removed from the code because they are no longer needed (the other is
///    CopyStringToStringMap())
/// BEW 23Mar10, updated for support of doc version 5 (no changes needed)
/// BEW 9July10, no changes needed for support of kbVersion 2
/////////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItView::AreMarkerSetsDifferent(const wxString& str1, const wxString& str2,
								bool& bUnfilteringRequired,bool& bFilteringRequired)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	int index;
	wxString aMarker; // use for a whole marker, with no trailing space
					  // (ie. backslash plus bare marker)
	wxString aMkrWithSpace; // construct a string comprised of marker plus trailing
							// space, here
	bool bShouldBeFiltered;
	bool bReturnValue = FALSE; // start with a safe default (ie. marker sets
							   // are the same)
	bool bMatched = TRUE;
	wxArrayString* pStrArr1 = new wxArrayString;
	wxArrayString* pStrArr2 = new wxArrayString;

	// get their marker inventories in the form of wxArrayString arrays
	GetMarkerArrayFromString(pStrArr1, str1);
	GetMarkerArrayFromString(pStrArr2, str2);

	// initialize the flag values to be returned to the caller
	bUnfilteringRequired = FALSE;
	bFilteringRequired = FALSE;

	// get the sizes of these two arrays
	int nSize1 = pStrArr1->GetCount();
	int nSize2 = pStrArr2->GetCount();

	// bleed out the easy cases
	if (nSize1 == 0 && nSize2 == 0)
	{
		if (pStrArr1 != NULL) // whm 11Jun12 added NULL test
			delete pStrArr1;
		if (pStrArr2 != NULL) // whm 11Jun12 added NULL test
			delete pStrArr2;
		return FALSE; // both empty, they can't be different
	}
	// check for new source text with no markers
	if (nSize2 == 0)
	{
		// new source text has no markers, the other must have at
		// least one, so they are different; and no filtering or
		// unfiltering is involved because there is no marker which
		// could be a candidate (sso m_FilterStatusMap remains empty)
		pStrArr1->Clear();
		if (pStrArr1 != NULL) // whm 11Jun12 added NULL test
			delete pStrArr1;
		if (pStrArr2 != NULL) // whm 11Jun12 added NULL test
			delete pStrArr2;
		return TRUE;
	}
	// check for pre-edit source text with no markers
	// NOTE: see the long comment below for a discussion of the (small) weakness of
	// this simple algorithm for determining what entries to add to m_FilterStatusMap
	if (nSize1 == 0)
	{
		// no markers in the pre-edit source text, the new source text therefore
		// must have at least one, so the sets are different. Moreover, every marker
		// in the new source text as a result of the first set being empty, must be
		// given an entry in m_FilterStatusMap
		for (index = 0; index < nSize2; index++)
		{
			aMarker = (*pStrArr2)[index];
			wxASSERT(!aMarker.IsEmpty());
            // this aMarker SF marker is known not to be in the pre-edit source text, so
            // the arrays are different; and so this marker has to generate an entry for
            // the map m_FilterStatusMap
			bReturnValue = TRUE;

			// determine if this is filterable or not, and set up the entry accordingly
			aMkrWithSpace = aMarker + _T(' ');
			bShouldBeFiltered = IsMarkerWithSpaceInFilterMarkersString(aMkrWithSpace,
														pApp->gCurrentFilterMarkers);
			if (bShouldBeFiltered)
				bFilteringRequired = TRUE;
			else
				bUnfilteringRequired = TRUE;
		}
		if (pStrArr1 != NULL) // whm 11Jun12 added NULL test
			delete pStrArr1;
		pStrArr2->Clear();
		if (pStrArr2 != NULL) // whm 11Jun12 added NULL test
			delete pStrArr2;
		goto b;
	}

    // when both arrays have content, we must test each marker against all those in the
    // other array, doing this in both directions - because we must be sure to get a
    // correct bool result in the situation where one marker set may be a subset of the
    // other

    // iterate across the markers in the first array, testing for a non-match in the second
    // (all we are interested in for this loop is to find any pre-edit markers which are
    // not in the post-edit source text string
	for (index = 0; index < nSize1; index++)
	{
		aMarker = (*pStrArr1)[index];
		wxASSERT(!aMarker.IsEmpty());
		bMatched = IsMarkerInArray(pStrArr2, aMarker);
		if (!bMatched)
		{
			// this aMarker SF marker is not in array 2, so the arrays are different
			bReturnValue = TRUE;
		}
	}
	// iterate across the markers in the second array, (the new source text),
	// testing for a non-match in the first (the original text before editing happened)
	// -- this loop is where we possibly may add entries to m_FilterStatusMap
	//
    // This algorithm has an obvious weakness: if the original pre-edit source text has
    // \mkr1 (a misspelled marker which the user will edit to be \mkr2 which is filterable)
    // and also has an instance of \mkr2 as well, then changing \mkr1 to \mkr2 in the edit
    // dialog results in the new source text having \mkr2; and when we test \mkr2 to see if
    // it is in the pre-edit text string, we would find that it is, and so no entry would
    // get added to m_FilterStatusMap, when in actual fact it really should have, because a
    // misspelled marker has been fixed so as to be a to-be-filtered one, but the caller
    // will subsequently not call RetokenizeText() to do the filtering because the map has
    // had no entry put in it. The user can reduce the likelihood of such a situation by
    // just selecting the one word where the typo marker is stored, and do the change to
    // the correct marker in the dialog; however, if the typo marker is changed to be one
    // which comes with a matching endmarker, then the user's selection needs to be all the
    // words up to where the endmarker is stored (but not necessarily selecting the
    // CSourcePhrase instance because the TextType may change and prevent it being selected
    // anyway, but our code will still pick up the bad endmarker and show it to the user in
    // the edit source text dialog).
	//
    // So, the rule when making a good selection to correct a typo marker is: if it is
    // supposed to have an endmarker, select all the words which are to be enclosed by the
    // marker - endmarker pair, but if the typo marker is to be changed to one which has no
    // endmarker, just select the word which has the typo marker stored in its
    // CSourcePhrase instance. Doing that makes the algorithm 100% reliable.
	//
    // The likelihood of a selection with a bad marker also having an instance of the
    // filterable marker which the user will change the bad marker to be when he edits, is
    // very very small; so our simplistic algorithm should actually do the job quite well,
    // probably for everyone and every time; and it is guaranteed to work if the user
    // adhere's to the above rules for the selection
	for (index = 0; index < nSize2; index++)
	{
		aMarker = (*pStrArr2)[index];
		wxASSERT(!aMarker.IsEmpty());
		bMatched = IsMarkerInArray(pStrArr1, aMarker);
		if (!bMatched)
		{
			// this aMarker SF marker is not in array 1, so the arrays are different
			// and so this marker has to generate an entry for the map m_FilterStatusMap
			bReturnValue = TRUE;

			// determine if this is filterable or not, and set up the entry accordingly
			aMkrWithSpace = aMarker + _T(' ');
			bShouldBeFiltered = IsMarkerWithSpaceInFilterMarkersString(aMkrWithSpace,
														pApp->gCurrentFilterMarkers);
			if (bShouldBeFiltered)
				bFilteringRequired = TRUE;
			else
				bUnfilteringRequired = TRUE;
		}
	}
	// clean up
	pStrArr1->Clear();
	if (pStrArr1 != NULL) // whm 11Jun12 added NULL test
		delete pStrArr1;
	pStrArr2->Clear();
	if (pStrArr2 != NULL) // whm 11Jun12 added NULL test
		delete pStrArr2;
b:	return bReturnValue;
}

// BEW 23Mar10, no change needed for doc version 5
bool CAdapt_ItView::IsMarkerWithSpaceInFilterMarkersString(wxString& mkrWithSpace,
														   wxString& strFilterMarkers)
{
	int offset = strFilterMarkers.Find(mkrWithSpace); // the trailing space
												// prevents spurious matches
	if (offset == -1)
		return FALSE;
	else
		return TRUE;
}

// Used in OnEditCopy()( only, for copying to the clipboard from a selection made in source
// phrase - our copy copies the selection's target text, not the source text.
// BEW 21Jul14, refactored for ZWSP support (& take into account whether its in a
// retranslation or not, or overlapping one) 
// BEW refactored 31Jul16 so that if called when ALT key is down, it instead copies
// the selected m_srcPhrase instances to the clipboard
// whm 16Feb2018 Notes: 
// DoSrcPhraseSelCopy() is only called from OnEditCopy() and OnEditCopy() is not triggered
// by the user invoking Ctrl+C or even Ctrl+ALt+C. Ctrl+ALt+C could call it if it were a defined
// hot-key in a key handler - but currently is not. Hence, the ALT key will be down when this
// function executes ONLY if/when accessing the Edit > Copy from the keyboard using the ALT hot 
// key to access Adapt It's main menu. In fact, the ALT key will NOT be in a down state when 
// accessing the main menu using just the mouse pointer. 
// From his 31Jul16 comment above, I assume Bruce instituted the ALT key down detection as a
// means of copying m_srcPhrase instances to the clipboard (instead of the m_targetPhrase) to
// ONLY be accomplished in the very limited circumstance that a user first selects source phrase
// words, then accesses the main Edit menu by holding down the ALT key + E to open the Edit menu
// and finally selecting the "Copy" command from that Edit menu. 
// Bruce had the App's m_bALT_KEY_DOWN default to FALSE in OnInit(). He sets it to TRUE in 
// CPhraseBox::OnKeyDown(). But he attempted to reset it to FALSE in the OnKeyUp() handler but 
// attempting to do so in OnKeyUp() would never work (ALT+DOWN is never detected there). 
// Hence, assuming the bAltDown functionality in DoSrcPhraseSelCopy() really is desired, I have 
// modified Bruce's code in the following manner:
// 1. Leave m_bALT_KEY_DOWN detection when TRUE as is in OnKeyDown().  
// 2. Resetting m_bALT_KEY_DOWN to FALSE before return from this DoSrcPhraseSelCopy()
void CAdapt_ItView::DoSrcPhraseSelCopy()
{
	// refactored 7Apr09
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	CCellList* pCellList = &pApp->m_selection; // get a local pointer
	wxString str; // accumulate the words / phrases here
	str.Empty();
	CCellList::Node* pos_pCellList = pCellList->GetFirst();
	if (pos_pCellList == NULL)
		return;

	wxTheClipboard->Clear();

	bool bAltDown = pApp->m_bALT_KEY_DOWN;
	//wxLogDebug(_T("DoSrcPhraseSelCopy(): app::m_bALT_KEY_DOWN = %s"), 
	//	(wxString(pApp->m_bALT_KEY_DOWN ? _T("TRUE") : _T("FALSE"))).c_str());

	if (pApp->m_selectionLine == 0)
	{
		while (pos_pCellList != NULL)
		{
			CCell* pCell = (CCell*)pos_pCellList->GetData();
			pos_pCellList = pos_pCellList->GetNext();
			if (pCell == NULL)
				return;
			CSourcePhrase* pSrcPhrase = pCell->GetPile()->GetSrcPhrase();
			wxASSERT(pSrcPhrase != NULL);

			if (pCell->GetPile() == pApp->m_pActivePile)
			{
				if (bAltDown)
				{
					if (!pSrcPhrase->m_srcPhrase.IsEmpty())
					{
						if (str.IsEmpty())
							str = pSrcPhrase->m_srcPhrase;
						else
						{
							str += PutSrcWordBreak(pSrcPhrase) + pSrcPhrase->m_srcPhrase;
						}
					}
				}
				else
				{
					if (!pApp->m_targetPhrase.IsEmpty())
					{
						if (str.IsEmpty())
							str = pApp->m_targetPhrase;
						else
						{
							if (pSrcPhrase->m_bRetranslation)
							{
								str += PutTgtWordBreak(pSrcPhrase) + pApp->m_targetPhrase;
							}
							else
							{
								str += PutSrcWordBreak(pSrcPhrase) + pApp->m_targetPhrase;
							}
						}
					}
				} // end of else block for test: if (bAltDown)
			} // end of TRUE block for test: if (pCell->GetPile() == pApp->m_pActivePile)
			else
			{
				if (bAltDown)
				{
					if (str.IsEmpty())
					{
						if (!pSrcPhrase->m_srcPhrase.IsEmpty())
							str = pSrcPhrase->m_srcPhrase;
					}
					else
					{
						if (!pSrcPhrase->m_srcPhrase.IsEmpty())
						{
							str += PutSrcWordBreak(pSrcPhrase) + pSrcPhrase->m_srcPhrase;
						}
					}
				} // end of TRUE block for test: if (bAltDown)
				else
				{
					if (str.IsEmpty())
					{
						if (gbIsGlossing)
						{
							if (!pSrcPhrase->m_gloss.IsEmpty())
								str = pSrcPhrase->m_gloss;
						}
						else
						{
							if (!pSrcPhrase->m_targetStr.IsEmpty())
								str = pSrcPhrase->m_targetStr;
						}
					}
					else
					{
						if (gbIsGlossing)
						{
							if (!pSrcPhrase->m_gloss.IsEmpty())
								str += _T(" ") + pSrcPhrase->m_gloss;
						}
						else
						{
							if (!pSrcPhrase->m_targetStr.IsEmpty())
							{
								if (pSrcPhrase->m_bRetranslation)
								{
									str += PutTgtWordBreak(pSrcPhrase) + pSrcPhrase->m_targetStr;
								}
								else
								{
									str += PutSrcWordBreak(pSrcPhrase) + pSrcPhrase->m_targetStr;
								}
							}
						}
					}
				} // end of else block for test: if (bAltDown)
			} // end of else block for test: if (pCell->GetPile() == pApp->m_pActivePile)
		}
	}
    else
    {
        pApp->m_bALT_KEY_DOWN = FALSE; // whm 16Feb2018 added
        return;
    }

    pApp->m_bALT_KEY_DOWN = FALSE; // whm 16Feb2018 added

    if (wxTheClipboard->Open())
	{
		// This data objects are held by the clipboard,
		// so do not delete them in the app.
		// SetData clears all previous contents in the clipboard
		// so there is no need to call Clear
		wxTheClipboard->SetData( new wxTextDataObject(str) );
		wxTheClipboard->Close();
	}
	else
	{
		wxMessageBox( _("Cannot open the Clipboard"), _T(""), wxICON_EXCLAMATION | wxOK);
		return;
	}
}

// Return value: TRUE if all was well (whether or not an actual store to KB took place -
// because certain flags inhibit saves, or an empty targetBox does not get anything saved
// to a KB if the <no adaptation> button was not pressed), and FALSE if the store could not
// be done (eg. if the embedded call to StoreText returned FALSE) ammended, July 2003, for
// auto-capitalization support
// BEW ***NOTE *** 4Feb11: Do not call this function in the handler for the user having
// just changed the punctuation settings, that is, do not call it in
// DoPunctuationChanges(), which is an app class member function. In such a context, the
// status of each character, whether punctuation or word-building, and whether or not all
// target text word-building characters are restored to the word proper or not, is not
// determinate -- some kinds of punct changes would be benign (such as changing a
// word-initial or word final word-building character to be a punctuation character) would
// give a correct KB entry, but the opposite would give a faulty KB entry because the
// phrase box contents won't have the required string (unless the user has typed it
// manually, which can't be guaranteed) and so a word-building character would be lost from
// the start or end of the target text word or phrase. A further problem is that
// StoreBeforeProceeding calls MakeTargetStringIncludingPunctuation() and the latter has a
// different protocol regarding punctuation than does the code for handling a user's
// punctuation set changes: the MakeTargetStringIncludingPunctuation() interprets
// differences between the punctuation on the target text, and that stored in the
// m_precPunct & m_follPunct & m_follOuterPunct as indicating manual typing which should
// replace the latter with the former - which would be an incorrect assumption if this
// function is called in the handler for doing changes to the punctuation settings - the
// latter scenario regards such differences as additive, not replacive, and gives
// potentially different results.
bool CAdapt_ItView::StoreBeforeProceeding(CSourcePhrase* pSrcPhrase)
{
	CAdapt_ItApp* pApp = (CAdapt_ItApp*)&wxGetApp();
	CAdapt_ItDoc* pDoc = pApp->GetDocument();
	RemoveSelection(); // ensure we don't have any selection current
	bool bOK = FALSE;

    // OnIdle( ) probably will have done any needed case changing, but just in case we will
    // check and if it has not been done, then do it here instead
	bool bNoError = TRUE;
	if (gbAutoCaps)
	{
		bNoError = pApp->GetDocument()->SetCaseParameters(pApp->m_pActivePile->GetSrcPhrase()->m_key);
		if (bNoError && gbSourceIsUpperCase)
		{
			bNoError = pApp->GetDocument()->SetCaseParameters(pApp->m_targetPhrase,FALSE);
			if (bNoError && !gbNonSourceIsUpperCase && (gcharNonSrcUC != _T('\0')))
			{
				pApp->m_targetPhrase.SetChar(0,gcharNonSrcUC);
			}
		}
	}

	if (gbIsGlossing)
	{
		if (!pSrcPhrase->m_bHasGlossingKBEntry)
		{
			if (!pApp->m_targetPhrase.IsEmpty())
			{
				// it has to be saved to the glossing KB if not empty
				bOK = pApp->m_pGlossingKB->StoreText(pSrcPhrase,pApp->m_targetPhrase);
			}
			else
				bOK = TRUE; // no store, but not an error so return TRUE
		}
		return bOK;
	}
	else
	{
		if (pApp->m_bSaveToKB && !pSrcPhrase->m_bHasKBEntry && !pSrcPhrase->m_bNotInKB)
		{
				// it has to be saved to the KB if not empty
				MakeTargetStringIncludingPunctuation(pSrcPhrase,pApp->m_targetPhrase);
				RemovePunctuation(pDoc,&pApp->m_targetPhrase,from_target_text);
                pApp->m_bInhibitMakeTargetStringCall = TRUE;
				bOK = pApp->m_pKB->StoreText(pSrcPhrase,pApp->m_targetPhrase);
                pApp->m_bInhibitMakeTargetStringCall = FALSE;
		}
		else
		{
				bOK = TRUE; // no store, but not an error so return TRUE
		}
		pApp->m_bSaveToKB = TRUE; // make sure it's turned on
		return bOK;
	}
}

/////////////////////////////////////////////////////////////////////////////////
/// \return		nothing
/// \param      event   -> the wxUpdateUIEvent that is generated by the app's Idle
///                        handler
/// \remarks
/// Called from: The wxUpdateUIEvent mechanism whenever idle processing is enabled.
/// Disables the "Advance To End" toolbar item if Vertical Editing is in progress. If the
/// m_pActivePile pointer is NULL or there are no source phrase in the m_pSourcePhrases
/// list, this handler disables the "Advance To End" toolbar item and returns immediately.
/// It enables the toolbar item if the App's m_endIndex is greater than zero but less than
/// the count in m_pSourcephrases -1, otherwise it disables the toolbar item.
/////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItView::OnUpdateButtonToEnd(wxUpdateUIEvent& event)
{
	// refactored 7Apr09
	if (gbVerticalEditInProgress)
	{
		event.Enable(FALSE);
		return;
	}
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	if (pApp->m_pActivePile == NULL)
	{
		event.Enable(FALSE);
		return;
	}
	if (pApp->m_pSourcePhrases->GetCount() == 0)
	{
		event.Enable(FALSE);
		return;
	}
	if (pApp->m_nActiveSequNum < pApp->GetMaxIndex())
		event.Enable(TRUE);
	else
		event.Enable(FALSE);
}

// BEW 7Aug13 changed, because it was carrying the old phrasebox value to the new location
void CAdapt_ItView::OnButtonToEnd(wxCommandEvent& event)
{
    // refactored 9Apr09 **** TODO **** can be restructured to have only one RecalcLayout()
    // call -- see OnButtonStepDown() for how to do it (relies on fact that the internal
    // code can make all decisions about whether to move or not without having to recalc
    // the layout, and then only do the one recalc call at the end)
	CMainFrame* pFrame;
	wxTextCtrl* pEdit = NULL; // whm initialized to NULL
	CAdapt_ItApp* pApp = (CAdapt_ItApp*)&wxGetApp();
    if (pApp->m_bFreeTranslationMode)
	{
		pFrame = (CMainFrame*)pApp->GetMainFrame();
		wxASSERT(pFrame != NULL);
		wxASSERT(pFrame->m_pComposeBar != NULL);
		pEdit = (wxTextCtrl*)pFrame->m_pComposeBar->FindWindowById(IDC_EDIT_COMPOSE);
		wxASSERT(pEdit != NULL);
		// whm 24Aug06 modified below to eliminate gFreeTranslationStr global
		wxString tempStr;
		tempStr.Empty();
		pEdit->ChangeValue(tempStr);
	}
    pApp->m_nOldSequNum = pApp->m_nActiveSequNum; // save old location

	SPList* pList = pApp->m_pSourcePhrases;

	// remove any selection to be safe from unwanted selection-related side effects
	RemoveSelection();

	wxASSERT(pApp->m_pActivePile != NULL);
	bool bOK;
	bOK = StoreBeforeProceeding(pApp->m_pActivePile->GetSrcPhrase());
    // BEW changed 06May05 because if m_pSrcPhrase contains m_bHasKBEntry == TRUE, then
    // StoreBeforeProceeding() returns FALSE without doing any store, and in that case we
    // don't want to return from OnButtonToEnd immediately because then we have no way to
    // navigate to the end of the document by this button; instead, just ignore the bOK
    // value
	if (!bOK)
	{
		//return;
		; // just do nothing (avoids compiler warning baout bOK not being accessed)
	}

	int nSequNum = pApp->GetMaxIndex(); // make active element be the last one in the list
	pApp->m_nActiveSequNum = nSequNum;

	SPList::Node* spos = pList->GetLast();
	CSourcePhrase* pSrcPhrase = (CSourcePhrase*)spos->GetData();

    // if free translation mode is on, we would not want the box to be at the very end if
    // there was already a free translation ending there - so make the adjustment if
    // required so that box goes instead to the last anchor position
	if (pApp->m_bFreeTranslationMode)
	{
		if (pSrcPhrase->m_bHasFreeTrans && !pSrcPhrase->m_bStartFreeTrans)
		{
			// move back to the sequ num for the anchor position
			SPList::Node* pos_pList = pList->GetLast();
			int count = 0;
			while (TRUE)
			{
				count++;
				pSrcPhrase = (CSourcePhrase*)pos_pList->GetData();
				pos_pList = pos_pList->GetPrevious();
				wxASSERT(pSrcPhrase != NULL);
				nSequNum = pSrcPhrase->m_nSequNumber;
				if (pSrcPhrase->m_bStartFreeTrans ||
					(pSrcPhrase->m_nSequNumber == 0) ||
					pSrcPhrase->m_bChapter ||
					pSrcPhrase->m_bVerse)
				{
                    // don't go back more further than start of a free translation section,
                    // of to start of chapter, or start of verse, or start of document, if
                    // any of those conditions are encountered first
					nSequNum = pSrcPhrase->m_nSequNumber;
					pApp->m_nActiveSequNum = nSequNum;
					break;
				}
			}
		}
	}

	// handle the possibility that the new active location might be a "<Not In KB>" one
	if (gbIsGlossing)
	{
		// A block omitted there, because <Not In KB> entries are not supported in
		// glossing mode
		if (!pSrcPhrase->m_gloss.IsEmpty())
		{
			pApp->m_targetPhrase = pSrcPhrase->m_gloss;
			pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(pApp->m_targetPhrase);
			pApp->m_pTargetBox->m_bAbandonable = FALSE;
		}
		else // the location is a "hole" (ie. empty)
		{
#if defined(ABANDON_NOT)
			pApp->m_pTargetBox->m_bAbandonable = FALSE;
#else
			pApp->m_pTargetBox->m_bAbandonable = TRUE;
#endif
			pApp->m_targetPhrase.Empty();// added 31Jul03
			pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(pApp->m_targetPhrase);
			// the above is better, since then the user can use the To End button and not get
			// spurious copied source text entered into the KB if he does not remember to
			// delete the copied text before stepping elsewhere
		}
	}
	else
	{
		if (!pSrcPhrase->m_bHasKBEntry && pSrcPhrase->m_bNotInKB)
		{
			// this ensures user has to explicitly type into the box and explicitly check the
			// checkbox if he wants to override the "not in kb" earlier setting at this
			// location
			pApp->m_bSaveToKB = FALSE;
			pApp->m_targetPhrase.Empty();
			pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(pApp->m_targetPhrase);
#if defined(ABANDON_NOT)
			pApp->m_pTargetBox->m_bAbandonable = FALSE;
#else
			pApp->m_pTargetBox->m_bAbandonable = TRUE;
#endif
		}
		else if (!pSrcPhrase->m_adaption.IsEmpty())
		{
			pApp->m_targetPhrase = pSrcPhrase->m_adaption;
			pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(pApp->m_targetPhrase);
			pApp->m_pTargetBox->m_bAbandonable = FALSE;
		}
		else // the location is a "hole" (ie. empty)
		{
#if defined(ABANDON_NOT)
			pApp->m_pTargetBox->m_bAbandonable = FALSE;
#else
			pApp->m_pTargetBox->m_bAbandonable = TRUE;
#endif
			pApp->m_targetPhrase.Empty();// added 31Jul03
			pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(pApp->m_targetPhrase);
			// the above is better, since then the user can use the To End button and not get
			// spurious copied source text entered into the KB if he does not remember to
			// delete the copied text before stepping elsewhere
		}
	}

	// update the layout and get a fresh active pile pointer
#ifdef _NEW_LAYOUT
	GetLayout()->RecalcLayout(pList, keep_strips_keep_piles);
#else
	GetLayout()->RecalcLayout(pList, create_strips_keep_piles);
#endif
	pApp->m_pActivePile = GetPile(pApp->m_nActiveSequNum);

    // the active pile must not contain a retranslation, since we want to put the phrase
    // box there, so check and if so, back up until we find a src phrase which is not a
    // retranslation
	if (pApp->m_pActivePile->GetSrcPhrase()->m_bRetranslation)
	{
        // it's a retranslation location, so move active location to earlier sequence
        // numbers until we find a sourcePhrase which is not in the retranslation
		CPile* pPile = pApp->m_pActivePile;
		do
		{
			pPile = GetPrevPile(pPile);
			if (pPile == NULL)
			{
                // we've backed up to the start of the document, so the last active pile
                // location (ie. the first pile in the document) is where we'll remain
				pApp->m_nActiveSequNum = 0;
				pPile = GetPile(0);
				pApp->m_targetPhrase = pPile->GetSrcPhrase()->m_adaption;
#ifdef _NEW_LAYOUT
				GetLayout()->RecalcLayout(pList, keep_strips_keep_piles);
#else
				GetLayout()->RecalcLayout(pList, create_strips_keep_piles);
#endif
				pApp->m_pActivePile = GetPile(0);
				return;
			}
			pApp->m_pActivePile = pPile;
		} while (pPile->GetSrcPhrase()->m_bRetranslation);

		pSrcPhrase = pApp->m_pActivePile->GetSrcPhrase();
		pApp->m_nActiveSequNum = pSrcPhrase->m_nSequNumber;

		// handle the possibility that the new active location might be a "<Not In KB>" one
		if (!pSrcPhrase->m_bHasKBEntry && pSrcPhrase->m_bNotInKB)
		{
            // this ensures user has to explicitly type into the box and explicitly check
            // the checkbox if he wants to override the "not in kb" earlier setting at this
            // location
			pApp->m_bSaveToKB = FALSE;
			pApp->m_targetPhrase.Empty();
			pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(pApp->m_targetPhrase);
#if defined(ABANDON_NOT)
			pApp->m_pTargetBox->m_bAbandonable = FALSE;
#else
			pApp->m_pTargetBox->m_bAbandonable = TRUE;
#endif
		}
		else
		{
			if (!gbIsGlossing && !pSrcPhrase->m_adaption.IsEmpty())
			{
				// there is an adaptation
				pApp->m_targetPhrase = pSrcPhrase->m_adaption;
				pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(pApp->m_targetPhrase);
				pApp->m_pTargetBox->m_bAbandonable = FALSE;
			}
			else if (gbIsGlossing && !pSrcPhrase->m_gloss.IsEmpty())
			{
				// there is a gloss
				pApp->m_targetPhrase = pSrcPhrase->m_gloss;
				pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(pApp->m_targetPhrase);
				pApp->m_pTargetBox->m_bAbandonable = FALSE;
			}
			else
			{
#if defined(ABANDON_NOT)
				pApp->m_pTargetBox->m_bAbandonable = FALSE;
#else
				pApp->m_pTargetBox->m_bAbandonable = TRUE;
#endif
				if (pApp->m_bCopySource)
				{
					pApp->m_targetPhrase = CopySourceKey(pSrcPhrase, pApp->m_bUseConsistentChanges);
				}
				else
				{
					pApp->m_targetPhrase.Empty();
				}
				pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(pApp->m_targetPhrase);
			}
		}
	}

	// remove from the KB, if there is a refString for this source phrase in the KB
	wxString emptyStr = _T("");
	if (gbIsGlossing)
		pApp->m_pGlossingKB->GetAndRemoveRefString(pSrcPhrase,
									emptyStr, useGlossOrAdaptationForLookup);
	else
		pApp->m_pKB->GetAndRemoveRefString(pSrcPhrase,
									emptyStr, useGlossOrAdaptationForLookup);

    // BEW removed call of ResetPartnerPileWidth() 27Apr09, because a call to
    // ResetPartnerPileWidth() is always done in RecalcLayout() for the active pile, just
    // before rebuilding the strips, so we can rely on that one here

	// recalculate the layout
#ifdef _NEW_LAYOUT
	GetLayout()->RecalcLayout(pList, keep_strips_keep_piles);
#else
	GetLayout()->RecalcLayout(pList, create_strips_keep_piles);
#endif

	// recalculate the active pile
	pApp->m_pActivePile = GetPile(pApp->m_nActiveSequNum);

	// scroll the active location into view, if necessary
	pApp->GetMainFrame()->canvas->ScrollIntoView(pApp->m_nActiveSequNum);

	GetLayout()->m_docEditOperationType = default_op;

	// restore default button image, and m_bCopySourcePunctuation to TRUE
	if (!pApp->m_bCopySourcePunctuation)
	{
		OnToggleEnablePunctuationCopy(event);
	}

	Invalidate(); // get the layout redrawn and the phrase box too
	GetLayout()->PlaceBox();

    // if we are in free translation mode, we want the focus to be in the Compose Bar's
    // edit box after the move has been done
	if (pApp->m_bFreeTranslationMode && pEdit != NULL) // whm added && pEdit != NULL)
	{
		pEdit->SetFocus();
	}
}

/// removes both the entry from the adapting KB and the glossing KB, for the one m_key (the
/// function for removal exits if either does not yet exist in the KB, so the call is
/// always safe) - we need this function for document rebuilding, where both KBs have to be
/// updated in the one operation
void CAdapt_ItView::RemoveKBEntryForRebuild(CSourcePhrase* pSrcPhrase)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxString emptyStr = _T("");

	// remove from the adapting KB, if there is a refString for this source phrase in the KB
	pApp->m_pKB->GetAndRemoveRefString(pSrcPhrase, emptyStr, useGlossOrAdaptationForLookup);

	// now the glossing KB
	pApp->m_pGlossingKB->GetAndRemoveRefString(pSrcPhrase, emptyStr, useGlossOrAdaptationForLookup);
}

/// stores both adaptation for the adapting KB and gloss for the glossing KB, for the one
/// m_key (the function for storage exits if either does not yet exist in the KB, so the
/// call is always safe) - we need this function for document rebuilding, where both KBs
/// have to be updated in the one operation
/// BEW note 13Nov09: we don't want to allow the local user to cause a document rebuild
/// on a remote machine if the local use only has read-only access to the remote project
/// folder. We'll therefore not allow access to the remote running instance's preferences
/// in this circumstance.
void CAdapt_ItView::StoreKBEntryForRebuild(CSourcePhrase* pSrcPhrase,
										wxString& adaptationStr, wxString& glossStr)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	// save current glossing state, so we can restore afterwards
	bool bSaveEnableFlag = gbGlossingVisible;
	bool bSaveGlossingFlag = gbIsGlossing;

	// store to the adapting KB
	gbGlossingVisible = FALSE;
	gbIsGlossing = FALSE;

    // inhibit the call to MakeTargetStringIncludingPunctuation() within the StoreText()
    // function otherwise it will add punctuation to the m_targetStr field on the
    // document's pSrcPhrase which is currently active, and that member already has the
    // required punctuation because we have copied the old string prior to the rebuild
    pApp->m_bInhibitMakeTargetStringCall = TRUE;
	bool bOK = pApp->m_pKB->StoreText(pSrcPhrase,adaptationStr);
	bOK = bOK; // avoid warning
	// now the glossing KB
	gbGlossingVisible = TRUE;
	gbIsGlossing = TRUE;
	bOK = pApp->m_pGlossingKB->StoreText(pSrcPhrase,glossStr);

	// restore current mode
	gbGlossingVisible = bSaveEnableFlag;
	gbIsGlossing = bSaveGlossingFlag;
    pApp->m_bInhibitMakeTargetStringCall = FALSE; // restore the default setting
}

/////////////////////////////////////////////////////////////////////////////////
/// \return		nothing
/// \param      event   -> the wxUpdateUIEvent that is generated by the app's Idle handler
/// \remarks
/// Called from: The wxUpdateUIEvent mechanism whenever idle processing is enabled.
/// If any of the following conditions are TRUE, this handler disables the "Back To Start"
/// toolbar item and returns immediately: Vertical Editing is in progress, the Document
/// pointer is NULL, the m_pActivePile pointer is NULL, or the count of source phrases in
/// m_pSourcePhrases is zero. It enables the toolbar item if the App's m_beginIndex and
/// m_endIndex are both greater than zero, otherwise it disables the toolbar item.
/////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItView::OnUpdateButtonToStart(wxUpdateUIEvent& event)
{
	// refactored 9Apr09
	if (gbVerticalEditInProgress)
	{
		event.Enable(FALSE);
		return;
	}
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	if ((CAdapt_ItDoc*)GetDocument() == NULL)
	{
		event.Enable(FALSE);
		return;
	}

	if (pApp->m_nActiveSequNum == -1 && pApp->m_pSourcePhrases->GetCount() > 0)
	{
		// we are past the end, so allow the button to be used to go back to start
		event.Enable(TRUE);
		return;
	}

	// any other time when active pile pointer is null, don't let button be used
	if (pApp->m_pActivePile == NULL)
	{
		event.Enable(FALSE);
		return;
	}
	if (pApp->m_pSourcePhrases->GetCount() == 0)
	{
		event.Enable(FALSE);
		return;
	}
	// if the button is at the start, it should be disabled
	if (pApp->m_nActiveSequNum == 0 && pApp->m_pSourcePhrases->GetCount() > 0)
	{
		// we are at the doc start, so can't go back to start
		event.Enable(FALSE);
		return;
	}
	if (pApp->GetMaxIndex() > 0)
		event.Enable(TRUE);
	else
		event.Enable(FALSE);
}

// BEW 7Aug13, old location's phrase box value was being copied to the new location,
// because there was no call of pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(pApp->m_targetPhrase);
// so I added it and all was well
void CAdapt_ItView::OnButtonToStart(wxCommandEvent& event)
{
    // refactored 9Apr09 **** TODO **** can be restructured to have only one RecalcLayout()
    // call -- see OnButtonStepDown() for how to do it (relies on fact that the internal
    // code can make all decisions about whether to move or not without having to recalc
    // the layout, and then only do the one recalc call at the end)
	CMainFrame* pFrame;
	wxTextCtrl* pEdit = NULL; // whm initialized to NULL
	CAdapt_ItApp* pApp = (CAdapt_ItApp*)&wxGetApp();
    if (pApp->m_bFreeTranslationMode)
	{
		pFrame = (CMainFrame*)pApp->GetMainFrame();
		wxASSERT(pFrame != NULL);
		wxASSERT(pFrame->m_pComposeBar != NULL);
		pEdit = (wxTextCtrl*)pFrame->m_pComposeBar->FindWindowById(IDC_EDIT_COMPOSE);
		wxASSERT(pEdit != NULL);
		// whm 24Aug06 modified below to eliminate gFreeTranslationStr global
		wxString tempStr;
		tempStr.Empty();
		pEdit->ChangeValue(tempStr);
	}

    pApp->m_nOldSequNum = pApp->m_nActiveSequNum; // save old location

	SPList* pList = pApp->m_pSourcePhrases;

	bool bOK;
	if (pApp->m_nActiveSequNum == -1)
	{
		// we are past the end, so skip storage
		bOK = TRUE;

		// and remove any selection, since if it exists then RecalcLayout() would fail when
		// StoreSelection() gets called
		RemoveSelection();
	}
	else
	{
		wxASSERT(pApp->m_pActivePile != NULL);
		bOK = StoreBeforeProceeding(pApp->m_pActivePile->GetSrcPhrase());
	}
    // BEW changed 06May05 because if m_pSrcPhrase contains m_bHasKBEntry == TRUE, then
    // StoreBeforeProceeding() returns FALSE without doing any store, and in that case we
    // don't want to return from OnButtonToStart immediately because then we have no way to
    // navigate back to the start of the document; instead, just ignore the bOK value
	if (!bOK)
	{
		; // just do nothing (avoids compiler warning about bOK not being accessed)
	}

	int nSequNum = 0; // active element is first one in the list
	pApp->m_nActiveSequNum = nSequNum;

	SPList::Node* spos = pList->GetFirst();
	CSourcePhrase* pSrcPhrase = (CSourcePhrase*)spos->GetData();

	// handle the possibility that the new active location might be a "<Not In KB>" one
	// BEW 7Aug13, added test for gbIsGlossing
	if (gbIsGlossing)
	{
		// Glossing mode doesn't support <Not In KB> so that block is omitted here
		if (!pSrcPhrase->m_gloss.IsEmpty())
		{
			pApp->m_targetPhrase = pSrcPhrase->m_gloss;
			pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(pApp->m_targetPhrase);
			pApp->m_pTargetBox->m_bAbandonable = FALSE;
		}
		else
		{
#if defined(ABANDON_NOT)
			pApp->m_pTargetBox->m_bAbandonable = FALSE;
#else
			pApp->m_pTargetBox->m_bAbandonable = TRUE;
#endif
			pApp->m_targetPhrase.Empty(); // added 31Jul03
			pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(pApp->m_targetPhrase);
			// the above is better, since then the user can use the To Start button and not get
			// spurious copied source text entered into the KB if he does not remember to
			// delete the copied text before stepping elsewhere
		}
	}
	else
	{
		if (!pSrcPhrase->m_bHasKBEntry && pSrcPhrase->m_bNotInKB)
		{
			// this ensures user has to explicitly type into the box and explicitly check the
			// checkbox if he wants to override the "not in kb" earlier setting at this location
			pApp->m_bSaveToKB = FALSE;
			pApp->m_targetPhrase.Empty();
			pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(pApp->m_targetPhrase);
#if defined(ABANDON_NOT)
			pApp->m_pTargetBox->m_bAbandonable = FALSE;
#else
			pApp->m_pTargetBox->m_bAbandonable = TRUE;
#endif
		}
		else if (!pSrcPhrase->m_adaption.IsEmpty())
		{
			pApp->m_targetPhrase = pSrcPhrase->m_adaption;
			pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(pApp->m_targetPhrase);
			pApp->m_pTargetBox->m_bAbandonable = FALSE;
		}
		else
		{
#if defined(ABANDON_NOT)
			pApp->m_pTargetBox->m_bAbandonable = FALSE;
#else
			pApp->m_pTargetBox->m_bAbandonable = TRUE;
#endif
			pApp->m_targetPhrase.Empty(); // added 31Jul03
			pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(pApp->m_targetPhrase);
			// the above is better, since then the user can use the To Start button and not get
			// spurious copied source text entered into the KB if he does not remember to
			// delete the copied text before stepping elsewhere
		}
	}

	// update the layout and get a fresh active pile pointer
#ifdef _NEW_LAYOUT
	GetLayout()->RecalcLayout(pList, keep_strips_keep_piles);
#else
	GetLayout()->RecalcLayout(pList, create_strips_keep_piles);
#endif
	pApp->m_pActivePile = GetPile(pApp->m_nActiveSequNum);

    // the active pile must not contain a retranslation, since we want to put the phrase
    // box there, so check and if so, move forward until we find a src phrase which is not
    // a retranslation
	if (pApp->m_pActivePile->GetSrcPhrase()->m_bRetranslation)
	{
        // its a retranslation location, so move active location to later sequence numbers
        // until we find a sourcePhrase which is not in the retranslation
		CPile* pPile = pApp->m_pActivePile;
		do
		{
			pPile = GetNextPile(pPile);
			if (pPile == NULL)
			{
                // we've moved forward past the end of the document, so the last potential
                // active location is where we'll remain
				pApp->m_nActiveSequNum = pApp->GetMaxIndex();
				pPile = GetPile(pApp->m_nActiveSequNum);
				pApp->m_targetPhrase = pPile->GetSrcPhrase()->m_adaption;
#ifdef _NEW_LAYOUT
				GetLayout()->RecalcLayout(pList, keep_strips_keep_piles);
#else
				GetLayout()->RecalcLayout(pList, create_strips_keep_piles);
#endif
				pApp->m_pActivePile = GetPile(pApp->m_nActiveSequNum);
				return;
			}
			pApp->m_pActivePile = pPile;
		} while (pPile->GetSrcPhrase()->m_bRetranslation);

		pSrcPhrase = pApp->m_pActivePile->GetSrcPhrase();
		pApp->m_nActiveSequNum = pSrcPhrase->m_nSequNumber;

		// handle the possibility that the new active location might be a "<Not In KB>" one
		if (!pSrcPhrase->m_bHasKBEntry && pSrcPhrase->m_bNotInKB)
		{
            // this ensures user has to explicitly type into the box and explicitly check
            // the checkbox if he wants to override the "not in kb" earlier setting at this
            // location
			pApp->m_bSaveToKB = FALSE;
			pApp->m_targetPhrase.Empty();
			pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(pApp->m_targetPhrase);
#if defined(ABANDON_NOT)
			pApp->m_pTargetBox->m_bAbandonable = FALSE;
#else
			pApp->m_pTargetBox->m_bAbandonable = TRUE;
#endif
		}
		else
		{
			if (!gbIsGlossing && !pSrcPhrase->m_adaption.IsEmpty())
			{
				// there is an adaptation
				pApp->m_targetPhrase = pSrcPhrase->m_adaption;
				pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(pApp->m_targetPhrase);
				pApp->m_pTargetBox->m_bAbandonable = FALSE;
			}
			else if (gbIsGlossing && !pSrcPhrase->m_gloss.IsEmpty())
			{
				// there is a gloss
				pApp->m_targetPhrase = pSrcPhrase->m_gloss;
				pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(pApp->m_targetPhrase);
				pApp->m_pTargetBox->m_bAbandonable = FALSE;
			}
			else
			{
#if defined (ABANDON_NOT)
				pApp->m_pTargetBox->m_bAbandonable = FALSE;
#else
				pApp->m_pTargetBox->m_bAbandonable = TRUE;
#endif
				if (pApp->m_bCopySource)
				{
					pApp->m_targetPhrase = CopySourceKey(pSrcPhrase, pApp->m_bUseConsistentChanges);
				}
				else
				{
					pApp->m_targetPhrase.Empty();
				}
				pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(pApp->m_targetPhrase);
			}
		}
	}

	// remove the text from the KB, if refString is not null
	wxString emptyStr = _T("");
	if (gbIsGlossing)
		pApp->m_pGlossingKB->GetAndRemoveRefString(pSrcPhrase,
									emptyStr, useGlossOrAdaptationForLookup);
	else
		pApp->m_pKB->GetAndRemoveRefString(pSrcPhrase,
									emptyStr, useGlossOrAdaptationForLookup);

	// recalculate the layout
#ifdef _NEW_LAYOUT
	GetLayout()->RecalcLayout(pList, keep_strips_keep_piles);
#else
	GetLayout()->RecalcLayout(pList, create_strips_keep_piles);
#endif

	// recalculate the active pile
	pApp->m_pActivePile = GetPile(pApp->m_nActiveSequNum);

	// scroll the active location into view, if necessary
	pApp->GetMainFrame()->canvas->ScrollIntoView(pApp->m_nActiveSequNum);

	GetLayout()->m_docEditOperationType = default_op;

	// restore default button image, and m_bCopySourcePunctuation to TRUE
	if (!pApp->m_bCopySourcePunctuation)
	{
		OnToggleEnablePunctuationCopy(event);
	}

	Invalidate();
	GetLayout()->PlaceBox();

    // if we are in free translation mode, we want the focus to be in the Compose Bar's
    // edit box after the move has been done
	if (pApp->m_bFreeTranslationMode && pEdit != NULL)
	{
		pEdit->SetFocus();
	}
}

/////////////////////////////////////////////////////////////////////////////////
/// \return		nothing
/// \param      event   -> the wxUpdateUIEvent that is generated by the app's Idle handler
/// \remarks
/// Called from: The wxUpdateUIEvent mechanism whenever idle processing is enabled.
/// If any of the following conditions are TRUE, this handler disables the "Move Down One
/// Step" toolbar item and returns immediately: Vertical Editing is in progress, the
/// m_pActivePile pointer is NULL, or the count of source phrases in m_pSourcePhrases is
/// zero.
/// It enables the toolbar item if the App's m_endIndex is greater than zero and less than
/// the count of source phrases in m_pSourcePhrases -1, otherwise it disables the toolbar
/// item.
/////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItView::OnUpdateButtonStepDown(wxUpdateUIEvent& event)
{
	CAdapt_ItApp* pApp = (CAdapt_ItApp*)&wxGetApp();
	wxASSERT(pApp != NULL);
	if (pApp->m_bClipboardAdaptMode)
	{
		event.Enable(FALSE);
		return;
	}
	if (gbVerticalEditInProgress)
	{
		event.Enable(FALSE);
		return;
	}
	if (pApp->m_pActivePile == NULL)
	{
		event.Enable(FALSE);
		return;
	}
	if (pApp->m_pSourcePhrases->GetCount() == 0)
	{
		event.Enable(FALSE);
		return;
	}
	if (pApp->m_nActiveSequNum < (int)pApp->GetMaxIndex() && pApp->m_nActiveSequNum >= 0)
		event.Enable(TRUE);
	else
		event.Enable(FALSE);
}

// GoThereSafely() is an alternative to Jump(), because the latter in the __GTK__ build failes
// to do ScrollIntoView() if the new active location is remote from the starting active
// location. So GoThereSafely() is based on the OnButtonStepDown() handler, which does shift
// the active location to remote new locations successfully, and contains code to set the
// phrase box safely there (i.e. not in a retranslation), and calls ScrollIntoView(). Handlers
// which fail to scroll when expected are a few which call Jump() - the latter's ScrollIntoView()
// function does nothing in its Scroll() call if the new location is remote - functions with
// this failure were at least these: handler for Close and Jump Here button in the dialog for
// examining a different part of the document; SetActivePilePointerSafely() - when loading
// a document; and the OnGoTo() handler (there may be more, but I didn't test all
// possibilities). Unlike OnButtonStepDown() wwhich does a StoreText(), GoThereSafely() will
// not do that; and it assumes the passed in sequNum is for the new active location, and the
// old active location is still in effect (ie. m_pActivePile is still pointing at the old
// active location).
// This code is perfectly good, but Jump() does the equivalent so I'll comment it out
// until such time as we need it - which may be never
/* retain, in case we want it later
void CAdapt_ItView::GoThereSafely(int sequNum)
{
	CMainFrame* pFrame;
	wxTextCtrl* pEdit = NULL; // whm initialized to NULL
	CAdapt_ItApp* pApp = (CAdapt_ItApp*)&wxGetApp();
	CLayout* pLayout = pApp->GetLayout();
	SPList* pList = pApp->m_pSourcePhrases;

	// remove any selection to be safe from unwanted selection-related side effects
	RemoveSelection();
	wxASSERT(pApp->m_pActivePile != NULL);

	// find the new active location; but if none is found then just beep and stay at the
	// current active location
	bool bFoundActiveLoc = FALSE;
	int nSequNum = 0; // start searching from beginning of doc
	CPile* pPile = GetPile(nSequNum); // might return NULL (if at doc end)
	int maxIndex = pApp->GetMaxIndex();
	CSourcePhrase* pSrcPhrase = NULL;
	while (pPile != NULL && nSequNum <= maxIndex)
	{
		pSrcPhrase = pPile->GetSrcPhrase();
		if (pSrcPhrase->m_nSequNumber == sequNum)
		{
			bFoundActiveLoc = TRUE;
			break;
		}
		else
		{
			nSequNum++;
			pPile = GetPile(nSequNum);
		}
	}

	// if the new active location was not found, then exit with a beep
	if (!bFoundActiveLoc)
	{
		::wxBell();
		return;
	}
	// the new active location was found, so pSrcPhrase is valid & is the new active one
	pLayout->m_pDoc->ResetPartnerPileWidth(pSrcPhrase); // ensures the strip there is marked invalid

	// if it is free translation mode, get a pointer to the compose bar's wxTextCtrl
	if (pApp->m_bFreeTranslationMode)
	{
		pFrame = (CMainFrame*)pApp->GetMainFrame();
		wxASSERT(pFrame != NULL);
		wxASSERT(pFrame->m_pComposeBar != NULL);
		pEdit = (wxTextCtrl*)pFrame->m_pComposeBar->FindWindowById(IDC_EDIT_COMPOSE);
		wxASSERT(pEdit != NULL);
		wxString tempStr;
		tempStr.Empty();
		pEdit->ChangeValue(tempStr); // make it have an empty string
	}


	wxASSERT(pPile);
	pApp->m_pActivePile = pPile; // set the new active pile's pointer
	pApp->m_nActiveSequNum = pSrcPhrase->m_nSequNumber;
	wxASSERT(pApp->m_nActiveSequNum == sequNum); // this might not be a valid location - could
				// be in a free translation if free trans mode is active, or in a retranslation
				// so we must check for these possibilities and adjust if necessary

	SPList::Node* pos_pList = pList->Item(pApp->m_nActiveSequNum);
	wxASSERT(pos_pList != NULL);
	CSourcePhrase* pSrcPhr = (CSourcePhrase*)pos_pList->GetData();
	wxASSERT(pSrcPhr != NULL);

	// if free translation mode is on, we would not want the box to be anywhere but at the
	// start of a free translation section, so if the found location is not the start of
	// such a section, make the adjustment if required so that box goes instead to that
	// free translation section's anchor position
	if (pApp->m_bFreeTranslationMode)
	{
		if (pSrcPhr->m_bHasFreeTrans && !pSrcPhr->m_bStartFreeTrans)
		{
			// move back to the sequ num for the anchor position
			while (TRUE)
			{
				pos_pList = pos_pList->GetPrevious();
				pSrcPhr = (CSourcePhrase*)pos_pList->GetData();
				pos_pList = pos_pList->GetPrevious();
				wxASSERT(pSrcPhr != NULL);
				nSequNum = pSrcPhr->m_nSequNumber;
				if (pSrcPhr->m_bStartFreeTrans || (pSrcPhr->m_nSequNumber == 0))
				{
                    // don't go back more further than start of a free translation section,
                    // or start of the document
					pApp->m_nActiveSequNum = nSequNum;
					pApp->m_pActivePile = GetPile(nSequNum);
					// ensure the strip there is marked invalid
					pLayout->m_pDoc->ResetPartnerPileWidth(pSrcPhr);
					break;
				}
			}
		}
	}
	else // not free translation mode
	{
		// handle the possibility that the new active location might be a "<Not In KB>" one
		if (!pSrcPhr->m_bHasKBEntry && pSrcPhr->m_bNotInKB)
		{
            // this ensures user has to explicitly type into the box and explicitly check
            // the checkbox if he wants to override the "not in kb" earlier setting at this
            // location
			pApp->m_bSaveToKB = FALSE;
			pApp->m_targetPhrase.Empty();
			pApp->m_pTargetBox->m_bAbandonable = FALSE; // was TRUE;
		}
		else if (!pSrcPhr->m_adaption.IsEmpty())
		{
			// do this if it has a non-empty adaptation or gloss (if in glossing mode)
			// already there
			if (gbIsGlossing)
			{
				pApp->m_targetPhrase = pSrcPhr->m_gloss;
				pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(pSrcPhr->m_gloss);
			}
			else
			{
				pApp->m_targetPhrase = pSrcPhr->m_adaption;
				pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(pSrcPhr->m_adaption);
			}
			pApp->m_pTargetBox->m_bAbandonable = FALSE;
			// make the m_Translation string be empty to avoid any confusions
			pApp->m_pTargetBox->m_Translation.Empty();
		}
		else
		{
			// the location is a "hole"
			pApp->m_pTargetBox->m_bAbandonable = FALSE; // was TRUE;
			pApp->m_pTargetBox->GetTextCtrl()->Clear();
			pApp->m_targetPhrase.Empty();
		}

		// We are not out of the woods yet... the active location just chosen must not
        // contain a retranslation, since we want to put the phrase box there, so check and
        // if so, move backwards until we find a src phrase which is not a retranslation, and
        // not a <Not In KB> location either. Going back is safe, but at least for scripture
        // the initial CSourcePhrase should be for a book ID (such as MAT, or LUK, etc) and
        // that would be a "safe" place even if everything else wasn't!
		if (pApp->m_pActivePile->GetSrcPhrase()->m_bRetranslation)
		{
			// its a retranslation location, so move active location to smaller sequence
			// numbers until we find a sourcePhrase which is not in the retranslation
			CPile* pPile = pApp->m_pActivePile;
			do
			{
				CPile* pSavePile = pPile;
				pPile = GetPrevPile(pPile);
				if (pPile == NULL)
				{
                    // we've gone back before the start of the document, so just make the
                    // earlier (saved) pile the active one unconditionally; control is almost
                    // certainly never going to enter this block
					pApp->m_nActiveSequNum = 0;
					pApp->m_pActivePile = pSavePile;
					if (gbIsGlossing)
					{
						pApp->m_targetPhrase = pApp->m_pActivePile->GetSrcPhrase()->m_gloss;
					}
					else
					{
						pApp->m_targetPhrase = pApp->m_pActivePile->GetSrcPhrase()->m_adaption;
					}
					// update the layout and get a fresh active pile pointer
					// (the next lines down to the return are copied from below)
					#ifdef _NEW_LAYOUT
					GetLayout()->RecalcLayout(pList, keep_strips_keep_piles);
					#else
					GetLayout()->RecalcLayout(pList, create_strips_keep_piles);
					#endif
					pApp->m_pActivePile = GetPile(pApp->m_nActiveSequNum);

					pApp->GetMainFrame()->canvas->ScrollIntoView(pApp->m_nActiveSequNum);
					GetLayout()->m_docEditOperationType = default_op;
					Invalidate();
					GetLayout()->PlaceBox();

					// if we are in free translation mode, we want the focus to be in
					// the Compose Bar's edit box after the move has been done
					if (pApp->m_bFreeTranslationMode && pEdit != NULL)
					{
						pEdit->SetFocus();
					}
					return;
				}
			} while (pPile->GetSrcPhrase()->m_bRetranslation);

			// in the loop above we found a pPile which was not in a retranslation, but we
			// may be unfortunately at a <Not In KB> location, sigh, so check for that and
			// handle it if so after we set a temporary active loc here first
			wxASSERT(pPile);
			pApp->m_pActivePile = pPile; // this one is not in the retranslation
			pSrcPhr = pApp->m_pActivePile->GetSrcPhrase();
			pApp->m_nActiveSequNum = pSrcPhr->m_nSequNumber;

			// handle the possibility that the new active location might be a
			// "<Not In KB>" one -- that's a "safe" location, so we can use it
			if (!pSrcPhr->m_bHasKBEntry && pSrcPhr->m_bNotInKB)
			{
				// this ensures user has to explicitly type into the box and explicitly
				// check the checkbox if he wants to override the "not in kb" earlier
				// setting at this location
				pApp->m_bSaveToKB = FALSE;
				pApp->m_targetPhrase.Empty();
				pApp->m_pTargetBox->m_bAbandonable = FALSE; // was TRUE;
			}
			else // it's not a <Not In KB> location, ie. it's normal
			{
				if (!gbIsGlossing && !pSrcPhr->m_adaption.IsEmpty())
				{
					// there is an adaptation
					pApp->m_targetPhrase = pSrcPhr->m_adaption;
					pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(pSrcPhr->m_adaption);
					pApp->m_pTargetBox->m_bAbandonable = FALSE;
				}
				else if (gbIsGlossing && !pSrcPhr->m_gloss.IsEmpty())
				{
					// there is a gloss
					pApp->m_targetPhrase = pSrcPhr->m_gloss;
					pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(pSrcPhr->m_gloss);
					pApp->m_pTargetBox->m_bAbandonable = FALSE;
				}
				else
				{
					pApp->m_pTargetBox->m_bAbandonable = FALSE; // BEW 31May19 was TRUE;
					if (pApp->m_bCopySource)
					{
						pApp->m_targetPhrase = CopySourceKey(pSrcPhr,pApp->m_bUseConsistentChanges);
					}
					else
					{
						pApp->m_targetPhrase.Empty();
						pApp->m_pTargetBox->GetTextCtrl()->Clear();
					}
				}
			}
			//  make sure our safe active location has it's strip marked as
			// invalid, so that the window is updated here and scrolling to this
			// new location will work right
			pLayout->m_pDoc->ResetPartnerPileWidth(pSrcPhr);
		}

		// remove the text from the KB, if refString is not null
		wxString emptyStr = _T("");
		if (gbIsGlossing)
			pApp->m_pGlossingKB->GetAndRemoveRefString(pSrcPhr, emptyStr, useGlossOrAdaptationForLookup);
		else
			pApp->m_pKB->GetAndRemoveRefString(pSrcPhr, emptyStr, useGlossOrAdaptationForLookup);
	} // end block for "not free translation mode"

	// update the layout and get a fresh active pile pointer
#ifdef _NEW_LAYOUT
	GetLayout()->RecalcLayout(pList, keep_strips_keep_piles);
#else
	GetLayout()->RecalcLayout(pList, create_strips_keep_piles);
#endif
	pApp->m_pActivePile = GetPile(pApp->m_nActiveSequNum);

	pApp->GetMainFrame()->canvas->ScrollIntoView(pApp->m_nActiveSequNum);
	GetLayout()->m_docEditOperationType = default_op;

	//Invalidate();
	GetLayout()->PlaceBox();
    // if we are in free translation mode, we want the focus to be in the Compose Bar's
    // edit box after the move has been done
	if (pApp->m_bFreeTranslationMode && pEdit != NULL)
	{
		pEdit->SetFocus();
	}
}
*/
void CAdapt_ItView::OnButtonStepDown(wxCommandEvent& event)
{
	CMainFrame* pFrame;
	wxTextCtrl* pEdit = NULL; // whm initialized to NULL
	CAdapt_ItApp* pApp = (CAdapt_ItApp*)&wxGetApp();

    SPList* pList = pApp->m_pSourcePhrases;
	int nSaveOldSequNum = pApp->m_pActivePile->GetSrcPhrase()->m_nSequNumber;
	wxString saveTargetPhrase = pApp->m_targetPhrase;

    pApp->m_nOldSequNum = pApp->m_nActiveSequNum; // save old location

	// remove any selection to be safe from unwanted selection-related side effects
	RemoveSelection();
	wxASSERT(pApp->m_pActivePile != NULL);

	// find the next CSourcePhrase instance which has m_bChapter set TRUE, make it the new
	// active location; but if none is found ahead of the current active location, then
	// just beep and stay at the current active location
	bool bFoundChapterBeginning = FALSE;
	int nSequNum = nSaveOldSequNum + 1;
	CPile* pPile = GetPile(nSequNum); // might return NULL (if at doc end)
	if (nSequNum <= pApp->GetMaxIndex())
	{
		while (pPile != NULL)
		{
			CSourcePhrase* pSrcPhr = pPile->GetSrcPhrase();
			if (pSrcPhr->m_bChapter)
			{
				bFoundChapterBeginning = TRUE;
				break;
			}
			else
			{
				nSequNum++;
				pPile = GetPile(nSequNum);
			}
		}
	}

	// if no chapter beginning was found, then exit with a beep
	if (!bFoundChapterBeginning)
	{
		::wxBell();
		return;
	}

	// continuing, because a chapter beginning was found...
	GetLayout()->m_pDoc->ResetPartnerPileWidth(GetSrcPhrase(nSaveOldSequNum)); // update old loc'n

	// if it is free translation mode, get a pointer to the compose bar's wxTextCtrl
	if (pApp->m_bFreeTranslationMode)
	{
		pFrame = (CMainFrame*)pApp->GetMainFrame();
		wxASSERT(pFrame != NULL);
		wxASSERT(pFrame->m_pComposeBar != NULL);
		pEdit = (wxTextCtrl*)pFrame->m_pComposeBar->FindWindowById(IDC_EDIT_COMPOSE);
		wxASSERT(pEdit != NULL);
		// whm 24Aug06 modified below to eliminate gFreeTranslationStr global
		wxString tempStr;
		tempStr.Empty();
		pEdit->ChangeValue(tempStr);
	}

	bool bOK;
	bOK = StoreBeforeProceeding(pApp->m_pActivePile->GetSrcPhrase());
    // BEW changed 06May05 because if m_pSrcPhrase contains m_bHasKBEntry == TRUE, then
    // StoreBeforeProceeding() returns FALSE without doing any store, and in that case we
    // don't want to return from OnButtonStepDown immediately because then we have no way
    // to navigate ahead in the document using this button; instead, just ignore the bOK
    // value
	if (!bOK)
	{
		; // do nothing, need to use bOK to avoid compile warning
	}

	wxASSERT(pPile);
	pApp->m_pActivePile = pPile;
	pApp->m_nActiveSequNum = pPile->GetSrcPhrase()->m_nSequNumber; // the new location, at chapter
	SPList::Node* pos_pList = pList->Item(pApp->m_nActiveSequNum);
	wxASSERT(pos_pList != NULL);
	CSourcePhrase* pSrcPhrase = (CSourcePhrase*)pos_pList->GetData();
	wxASSERT(pSrcPhrase != NULL);

	// if free translation mode is on, we would not want the box to be anywhere but at the
	// start of a free translation section, so if the found location is not the start of
	// such a section, make the adjustment if required so that box goes instead to the previous
	// anchor position
	if (pApp->m_bFreeTranslationMode)
	{
		if (pSrcPhrase->m_bHasFreeTrans && !pSrcPhrase->m_bStartFreeTrans)
		{
			// move back to the sequ num for the anchor position
			while (TRUE)
			{
				pos_pList = pos_pList->GetPrevious();
				pSrcPhrase = (CSourcePhrase*)pos_pList->GetData();
				pos_pList = pos_pList->GetPrevious();
				wxASSERT(pSrcPhrase != NULL);
				nSequNum = pSrcPhrase->m_nSequNumber;
				if (pSrcPhrase->m_bStartFreeTrans ||
					(pSrcPhrase->m_nSequNumber == 0) ||
					pSrcPhrase->m_bChapter ||
					pSrcPhrase->m_bVerse)
				{
                    // don't go back more further than start of a free translation section,
                    // of to start of chapter, or start of verse, or start of document, if
                    // any of those conditions are encountered first
					nSequNum = pSrcPhrase->m_nSequNumber;
					pApp->m_nActiveSequNum = nSequNum;
					break;
				}
			}
		}
	}
	else // not free translation mode
	{
		// handle the possibility that the new active location might be a "<Not In KB>" one
		if (!pSrcPhrase->m_bHasKBEntry && pSrcPhrase->m_bNotInKB)
		{
            // this ensures user has to explicitly type into the box and explicitly check
            // the checkbox if he wants to override the "not in kb" earlier setting at this
            // location
			pApp->m_bSaveToKB = FALSE;
			pApp->m_targetPhrase.Empty();
#if defined (ABANDON_NOT)
			pApp->m_pTargetBox->m_bAbandonable = FALSE;
#else
			pApp->m_pTargetBox->m_bAbandonable = TRUE;
#endif
		}
		else if (!pSrcPhrase->m_adaption.IsEmpty())
		{
			pApp->m_targetPhrase = pSrcPhrase->m_adaption;
			pApp->m_pTargetBox->m_bAbandonable = FALSE;
		}
		else
		{
#if defined (ABANDON_NOT)
			pApp->m_pTargetBox->m_bAbandonable = FALSE;
#else
			pApp->m_pTargetBox->m_bAbandonable = TRUE;
#endif
			pApp->m_targetPhrase.Empty();// added 31Jul03
            // the above is better, since then the user can use the Step Up button
            // repeatedly and not get spurious copied source text entered into the KB each
            // time if he does not remember to delete the copied text first
		}

        // the active pile must not contain a retranslation, since we want to put the
        // phrase box there, so check and if so, move along until we find a src phrase
        // which is not a retranslation
		if (pApp->m_pActivePile->GetSrcPhrase()->m_bRetranslation)
		{
			// its a retranslation location, so move active location to later sequence numbers
			// until we find a sourcePhrase which is not in the retranslation
			CPile* pPile = pApp->m_pActivePile;
			do
			{
				pPile = GetNextPile(pPile);
				if (pPile == NULL)
				{
                    // we've gone forward past the end of the document, so we won't make
                    // any change of location; because the end of the doc has only
                    // retranslations, so restore the old state & tell user
					//IDS_CANNOT_STEP_DOWN //  BEW changed message 10Apr09
                    // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
                    pApp->m_bUserDlgOrMessageRequested = TRUE;
                    wxMessageBox(_(
"Adapt It cannot step down to the beginning of the next chapter because it cannot find a legal place to put the phrase box, retranslations at the end of the document prevent it."),
					_T(""),wxICON_INFORMATION | wxOK);
					// restore old location's values (no RecalcLayout() was done, so
					// layout is valid still)
					pApp->m_targetPhrase = saveTargetPhrase;
					pApp->m_nActiveSequNum = nSaveOldSequNum;
					pApp->m_pActivePile = GetPile(nSaveOldSequNum);
					return;
				}
			} while (pPile->GetSrcPhrase()->m_bRetranslation);

			wxASSERT(pPile);
			pApp->m_pActivePile = pPile; // this one is not in the retranslation
			pSrcPhrase = pApp->m_pActivePile->GetSrcPhrase();
			pApp->m_nActiveSequNum = pSrcPhrase->m_nSequNumber;

			// handle the possibility that the new active location might be a "<Not In KB>" one
			if (!pSrcPhrase->m_bHasKBEntry && pSrcPhrase->m_bNotInKB)
			{
				// this ensures user has to explicitly type into the box and explicitly check the
				// checkbox if he wants to override the "not in kb" earlier setting at this location
				pApp->m_bSaveToKB = FALSE;
				pApp->m_targetPhrase.Empty();
#if defined (ABANDON_NOT)
				pApp->m_pTargetBox->m_bAbandonable = FALSE;
#else
				pApp->m_pTargetBox->m_bAbandonable = TRUE;
#endif
			}
			else // it's not a <Not In KB> location
			{
				if (!gbIsGlossing && !pSrcPhrase->m_adaption.IsEmpty())
				{
					// there is an adaptation
					pApp->m_targetPhrase = pSrcPhrase->m_adaption;
					pApp->m_pTargetBox->m_bAbandonable = FALSE;
				}
				else if (gbIsGlossing && !pSrcPhrase->m_gloss.IsEmpty())
				{
					// there is a gloss
					pApp->m_targetPhrase = pSrcPhrase->m_gloss;
					pApp->m_pTargetBox->m_bAbandonable = FALSE;
				}
				else
				{
#if defined (ABANDON_NOT)
					pApp->m_pTargetBox->m_bAbandonable = FALSE;
#else
					pApp->m_pTargetBox->m_bAbandonable = TRUE;
#endif
					if (pApp->m_bCopySource)
					{
						pApp->m_targetPhrase = CopySourceKey(
										pSrcPhrase,pApp->m_bUseConsistentChanges);
					}
					else
					{
						pApp->m_targetPhrase.Empty();
					}
				}
			}
		}

		// remove the text from the KB, if refString is not null
		wxString emptyStr = _T("");
		if (gbIsGlossing)
			pApp->m_pGlossingKB->GetAndRemoveRefString(pSrcPhrase,
										emptyStr, useGlossOrAdaptationForLookup);
		else
			pApp->m_pKB->GetAndRemoveRefString(pSrcPhrase,
										emptyStr, useGlossOrAdaptationForLookup);
	} // end block for "not free translation mode"

	// update the layout and get a fresh active pile pointer
#ifdef _NEW_LAYOUT
	GetLayout()->RecalcLayout(pList, keep_strips_keep_piles);
#else
	GetLayout()->RecalcLayout(pList, create_strips_keep_piles);
#endif
	pApp->m_pActivePile = GetPile(pApp->m_nActiveSequNum);

	pApp->GetMainFrame()->canvas->ScrollIntoView(pApp->m_nActiveSequNum);
	GetLayout()->m_docEditOperationType = default_op;

	// restore default button image, and m_bCopySourcePunctuation to TRUE
	if (!pApp->m_bCopySourcePunctuation)
	{
		OnToggleEnablePunctuationCopy(event);
	}

	Invalidate();
	GetLayout()->PlaceBox();

    // if we are in free translation mode, we want the focus to be in the Compose Bar's
    // edit box after the move has been done
	if (pApp->m_bFreeTranslationMode && pEdit != NULL)
	{
		pEdit->SetFocus();
	}
}

/////////////////////////////////////////////////////////////////////////////////
/// \return		nothing
/// \param      event   -> the wxUpdateUIEvent that is generated by the app's Idle handler
/// \remarks
/// Called from: The wxUpdateUIEvent mechanism whenever idle processing is enabled.
/// If any of the following conditions are TRUE, this handler disables the "Move Up One
/// Step" toolbar item and returns immediately: Vertical Editing is in progress, the
/// Document pointer is NULL, the m_pActivePile pointer is NULL, or the count of source
/// phrases in m_pSourcePhrases is zero.
/// It generally enables the toolbar button if the App's m_beginIndex and m_endIndex are
/// both greater than zero, otherwise it disables the toolbar item. It also enables the
/// toolbar item in the special circumstance when the phrasebox is past the end of the
/// document (m_pActiveSequNum is -1 and the count of source phrases in m_pSourcePhrases is
/// greater than zero).
/////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItView::OnUpdateButtonStepUp(wxUpdateUIEvent& event)
{
	CAdapt_ItApp* pApp = (CAdapt_ItApp*)&wxGetApp();
	wxASSERT(pApp != NULL);
	if (pApp->m_bClipboardAdaptMode)
	{
		event.Enable(FALSE);
		return;
	}
	if (gbVerticalEditInProgress)
	{
		event.Enable(FALSE);
		return;
	}
	if ((CAdapt_ItDoc*)GetDocument() == NULL)
	{
		event.Enable(FALSE);
		return;
	}
	if (pApp->m_pSourcePhrases->GetCount() == 0)
	{
		event.Enable(FALSE);
		return;
	}
	if (pApp->m_nActiveSequNum == -1 && pApp->m_pSourcePhrases->GetCount() > 0)
	{
		// we are past the end, so allow the button to be used to go back to start
		event.Enable(TRUE);
		return;
	}
	// any other time when active pile pointer is null, don't let button be used
	if (pApp->m_pActivePile == NULL)
	{
		event.Enable(FALSE);
		return;
	}
	// if the button is at the start, it should be disabled
	if (pApp->m_nActiveSequNum == 0 && pApp->m_pSourcePhrases->GetCount() > 0)
	{
		// we are at the doc start, so can't go back to start
		event.Enable(FALSE);
		return;
	}
	if (pApp->GetMaxIndex() > 0)
		event.Enable(TRUE);
	else
		event.Enable(FALSE);
}

void CAdapt_ItView::OnButtonStepUp(wxCommandEvent& event)
{
	CMainFrame* pFrame;
	wxTextCtrl* pEdit = NULL; // whm initialized to NULL
	CAdapt_ItApp* pApp = (CAdapt_ItApp*)&wxGetApp();

    SPList* pList = pApp->m_pSourcePhrases;

	// Beware, the update handler has the button enabled if the active sequ num is -1 and
	// there is data in the document; so we can't try to call GetSrcPhrase() for an active
	// pile pointer which is NULL. The thing to do would be to temporarily place the box
	// at the last CSourcePhrase in the document and let it then search back.
	int nSaveOldSequNum;
	if (pApp->m_nActiveSequNum == -1 || pApp->m_pActivePile == NULL)
	{
		// passed the end of the document
		pApp->m_nActiveSequNum = pApp->GetMaxIndex();
		pApp->m_pActivePile = GetPile(pApp->m_nActiveSequNum);
		pApp->m_targetPhrase = _T("");
	}
	nSaveOldSequNum = pApp->m_pActivePile->GetSrcPhrase()->m_nSequNumber;
	wxString saveTargetPhrase = pApp->m_targetPhrase;

	// return if we are at the start of the document
	if (nSaveOldSequNum == 0)
	{
		::wxBell();
		return;
	}

    pApp->m_nOldSequNum = pApp->m_nActiveSequNum; // save old location

	// remove any selection to be safe from unwanted selection-related side effects
	RemoveSelection();
	wxASSERT(pApp->m_pActivePile != NULL);

    // find the previous CSourcePhrase instance which has m_bChapter set TRUE, make it the
    // new active location; but if none is found before the current active location, then
    // just beep and stay at the current active location
	bool bFoundChapterBeginning = FALSE;
	int nSequNum = nSaveOldSequNum - 1; // first preceding location's sequence number
	CPile* pPile = GetPile(nSequNum);
	if (nSequNum >= 0)
	{
		while (pPile != NULL)
		{
			CSourcePhrase* pSrcPhr = pPile->GetSrcPhrase();
			if (pSrcPhr->m_bChapter)
			{
				bFoundChapterBeginning = TRUE;
				break;
			}
			else
			{
				nSequNum--;
				pPile = GetPile(nSequNum);
			}
		}
	}

	// if no chapter beginning was found, then exit with a beep
	// BEW 10Feb11, in response to Bob Buss's email, changed this behaviour to not beep,
	// but just invoke the To Start button to get the phrase box to the beginning of the
	// document (ie over any intro and title stuff which may precede the first chapter)
	if (!bFoundChapterBeginning)
	{
		//::wxBell();
		OnButtonToStart(event);
		return;
	}

	// continuing, because a chapter beginning was found...
	GetLayout()->m_pDoc->ResetPartnerPileWidth(GetSrcPhrase(nSaveOldSequNum)); // update old loc'n

	// if it is free translation mode, get a pointer to the compose bar's wxTextCtrl
	if (pApp->m_bFreeTranslationMode)
	{
		pFrame = (CMainFrame*)pApp->GetMainFrame();
		wxASSERT(pFrame != NULL);
		wxASSERT(pFrame->m_pComposeBar != NULL);
		pEdit = (wxTextCtrl*)pFrame->m_pComposeBar->FindWindowById(IDC_EDIT_COMPOSE);
		wxASSERT(pEdit != NULL);
		// whm 24Aug06 modified below to eliminate gFreeTranslationStr global
		wxString tempStr;
		tempStr.Empty();
		pEdit->ChangeValue(tempStr);
	}

	bool bOK;
	bOK = StoreBeforeProceeding(pApp->m_pActivePile->GetSrcPhrase());
    // BEW changed 06May05 because if m_pSrcPhrase contains m_bHasKBEntry == TRUE, then
    // StoreBeforeProceeding() returns FALSE without doing any store, and in that case we
    // don't want to return from OnButtonStepDown immediately because then we have no way
    // to navigate ahead in the document using this button; instead, just ignore the bOK
    // value
	if (!bOK)
	{
		; // do nothing, need to use bOK to avoid compile warning
	}

	wxASSERT(pPile);
	pApp->m_pActivePile = pPile; // the new active location's pile pointer
	pApp->m_nActiveSequNum = pPile->GetSrcPhrase()->m_nSequNumber; // the new location, at chapter
	SPList::Node* pos_pList = pList->Item(pApp->m_nActiveSequNum);
	wxASSERT(pos_pList != NULL);
	CSourcePhrase* pSrcPhrase = (CSourcePhrase*)pos_pList->GetData();
	wxASSERT(pSrcPhrase != NULL);

    // if free translation mode is on, we would not want the box to be anywhere but at the
    // start of a free translation section, so if the found location is not the start of
    // such a section, make the adjustment if required so that box goes instead to the
    // previous anchor position
	if (pApp->m_bFreeTranslationMode)
	{
		if (pSrcPhrase->m_bHasFreeTrans && !pSrcPhrase->m_bStartFreeTrans)
		{
			// move back to the sequ num for the anchor position
			while (TRUE)
			{
				pos_pList = pos_pList->GetPrevious();
				pSrcPhrase = (CSourcePhrase*)pos_pList->GetData();
				pos_pList = pos_pList->GetPrevious();
				wxASSERT(pSrcPhrase != NULL);
				nSequNum = pSrcPhrase->m_nSequNumber;
				if (pSrcPhrase->m_bStartFreeTrans ||
					(pSrcPhrase->m_nSequNumber == 0) ||
					pSrcPhrase->m_bChapter ||
					pSrcPhrase->m_bVerse)
				{
					// don't go back more further than start of a free translation section,
					// of to start of chapter, or start of verse, or start of document, if
					// any of those conditions are encountered first
					nSequNum = pSrcPhrase->m_nSequNumber;
					pApp->m_nActiveSequNum = nSequNum;
					break;
				}
			}
		}
	}
	else // not free translation mode
	{
		// handle the possibility that the new active location might be a "<Not In KB>" one
		if (!pSrcPhrase->m_bHasKBEntry && pSrcPhrase->m_bNotInKB)
		{
            // this ensures user has to explicitly type into the box and explicitly check
            // the checkbox if he wants to override the "not in kb" earlier setting at this
            // location
			pApp->m_bSaveToKB = FALSE;
			pApp->m_targetPhrase.Empty();
#if defined (ABANDON_NOT)
			pApp->m_pTargetBox->m_bAbandonable = FALSE;
#else
			pApp->m_pTargetBox->m_bAbandonable = TRUE;
#endif
		}
		else if (!pSrcPhrase->m_adaption.IsEmpty())
		{
			pApp->m_targetPhrase = pSrcPhrase->m_adaption;
			pApp->m_pTargetBox->m_bAbandonable = FALSE;
		}
		else
		{
#if defined (ABANDON_NOT)
			pApp->m_pTargetBox->m_bAbandonable = FALSE;
#else
			pApp->m_pTargetBox->m_bAbandonable = TRUE;
#endif
			pApp->m_targetPhrase.Empty();// added 31Jul03
            // the above is better, since then the user can use the Step Up button
            // repeatedly and not get spurious copied source text entered into the KB each
            // time if he does not remember to delete the copied text first
		}

        // the active pile must not contain a retranslation, since we want to put the
        // phrase box there, so check and if so, move along until we find a src phrase
        // which is not a retranslation
		if (pApp->m_pActivePile->GetSrcPhrase()->m_bRetranslation)
		{
            // its a retranslation location, so move active location to earlier sequence
            // numbers until we find a sourcePhrase which is not in the retranslation
			CPile* pPile = pApp->m_pActivePile;
			do
			{
				pPile = GetPrevPile(pPile);
				if (pPile == NULL)
				{
                    // we've gone back past the start of the document, so we won't make any
                    // change of location; because the start of the doc has only
                    // retranslations, so restore the old state & tell user
					//IDS_CANNOT_STEP_UP //  BEW changed message 11Apr09
                    // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
                    pApp->m_bUserDlgOrMessageRequested = TRUE;
                    wxMessageBox(_(
"Adapt It cannot step up to the beginning of chapter, or to the beginning of the previous chapter because it cannot find a legal place to put the phrase box, retranslations at the beginning of the document prevent it."),
					_T(""),wxICON_INFORMATION | wxOK);
					// restore old location's values (no RecalcLayout() was done, so
					// layout is valid still)
					pApp->m_targetPhrase = saveTargetPhrase;
					pApp->m_nActiveSequNum = nSaveOldSequNum;
					pApp->m_pActivePile = GetPile(nSaveOldSequNum);
					return;
				}
			} while (pPile->GetSrcPhrase()->m_bRetranslation);

			wxASSERT(pPile);
			pApp->m_pActivePile = pPile; // this one is not in the retranslation
			pSrcPhrase = pApp->m_pActivePile->GetSrcPhrase();
			pApp->m_nActiveSequNum = pSrcPhrase->m_nSequNumber;

			// handle the possibility that the new active location might be a
			// "<Not In KB>" one
			if (!pSrcPhrase->m_bHasKBEntry && pSrcPhrase->m_bNotInKB)
			{
                // this ensures user has to explicitly type into the box and explicitly
                // check the checkbox if he wants to override the "not in kb" earlier
                // setting at this location
				pApp->m_bSaveToKB = FALSE;
				pApp->m_targetPhrase.Empty();
#if defined (ABANDON_NOT)
				pApp->m_pTargetBox->m_bAbandonable = FALSE;
#else
				pApp->m_pTargetBox->m_bAbandonable = TRUE;
#endif
			}
			else // it's not a <Not In KB> location
			{
				if (!gbIsGlossing && !pSrcPhrase->m_adaption.IsEmpty())
				{
					// there is an adaptation
					pApp->m_targetPhrase = pSrcPhrase->m_adaption;
					pApp->m_pTargetBox->m_bAbandonable = FALSE;
				}
				else if (gbIsGlossing && !pSrcPhrase->m_gloss.IsEmpty())
				{
					// there is a gloss
					pApp->m_targetPhrase = pSrcPhrase->m_gloss;
					pApp->m_pTargetBox->m_bAbandonable = FALSE;
				}
				else
				{
#if defined (ABANDON_NOT)
					pApp->m_pTargetBox->m_bAbandonable = FALSE;
#else
					pApp->m_pTargetBox->m_bAbandonable = TRUE;
#endif
					if (pApp->m_bCopySource)
					{
						pApp->m_targetPhrase = CopySourceKey(pSrcPhrase,pApp->m_bUseConsistentChanges);
					}
					else
					{
						pApp->m_targetPhrase.Empty();
					}
				}
			}
		}

		// remove the text from the KB, if refString is not null
		wxString emptyStr = _T("");
		if (gbIsGlossing)
			pApp->m_pGlossingKB->GetAndRemoveRefString(pSrcPhrase,
										emptyStr, useGlossOrAdaptationForLookup);
		else
			pApp->m_pKB->GetAndRemoveRefString(pSrcPhrase,
										emptyStr, useGlossOrAdaptationForLookup);
	} // end block for "not free translation mode"

	// update the layout and get a fresh active pile pointer
#ifdef _NEW_LAYOUT
	GetLayout()->RecalcLayout(pList, keep_strips_keep_piles);
#else
	GetLayout()->RecalcLayout(pList, create_strips_keep_piles);
#endif
	pApp->m_pActivePile = GetPile(pApp->m_nActiveSequNum);

	pApp->GetMainFrame()->canvas->ScrollIntoView(pApp->m_nActiveSequNum);
	GetLayout()->m_docEditOperationType = default_op;

	// restore default button image, and m_bCopySourcePunctuation to TRUE
	if (!pApp->m_bCopySourcePunctuation)
	{
		OnToggleEnablePunctuationCopy(event);
	}

	Invalidate();
	GetLayout()->PlaceBox();

    // if we are in free translation mode, we want the focus to be in the Compose Bar's
    // edit box after the move has been done
	if (pApp->m_bFreeTranslationMode && pEdit != NULL)
	{
		pEdit->SetFocus();
	}
}

/////////////////////////////////////////////////////////////////////////////////
/// \return		nothing
/// \param      event   -> the wxUpdateUIEvent that is generated by the app's Idle handler
/// \remarks
/// Called from: The wxUpdateUIEvent mechanism whenever idle processing is enabled.
/// If the application is in glossing mode, or it is showing only the target text, or the m_pActivePile
/// pointer is NULL, this handler disables the "Make A Phrase" toolbar item
/// and returns immediately. If there is an active selection (the App's m_selection list has more than
/// one item in its list), it enables the toolbar button, otherwise it disables the toolbar button.
/////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItView::OnUpdateButtonMerge(wxUpdateUIEvent& event)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);

	// whm added 26Mar12. Disable toolbar button when in read-only mode.
	if (pApp->m_bReadOnlyAccess)
	{
		event.Enable(FALSE);
		return;
	}

	if (gbIsGlossing || gbShowTargetOnly)
	{
		event.Enable(FALSE);
		return;
	}
	if (pApp->m_pActivePile == NULL)
	{
		event.Enable(FALSE);
		return;
	}
	if (pApp->m_selection.GetCount() > 1)
		event.Enable(TRUE);
	else
		event.Enable(FALSE);
}

/////////////////////////////////////////////////////////////////////////////////
/// \return		nothing
/// \param      event   -> the wxUpdateUIEvent that is generated when the View Menu is about
///                         to be displayed
/// \remarks
/// Called from: The wxUpdateUIEvent mechanism when the associated menu item is selected,
/// and before the menu is displayed.
/// If the App's m_pActivePile is NULL this handler disables the "Copy Source" item in the
/// View menu and immediately returns.
/// It enables the "Copy Source" item on the View menu if the number of source phrases in
/// the m_pSourcePhrases list is greater than zero, otherwise it disables the menu item.
/////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItView::OnUpdateCopySource(wxUpdateUIEvent& event)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	if (pApp->m_pActivePile == NULL)
	{
		event.Enable(FALSE);
		return;
	}
	if (pApp->m_pSourcePhrases->GetCount() > 0)
		event.Enable(TRUE);
	else
		event.Enable(FALSE);
}


// IsFilteredMaterialNonInitial() -- BEW added 08June05, to be used in OnButtonMerge() in
// order to abort the merge operation if the user is trying to merge CSourcePhrase
// instances and one of those which is not the initial one contains filtered material in
// its m_filteredInfo, or m_freeTrans, or m_collectedBackTrans, or m_note member
// BEW 16Feb10, updated for support of doc version 5
bool CAdapt_ItView::IsFilteredMaterialNonInitial(SPList* pList)
{
	CSourcePhrase* pSrcPhrase;
	SPList::Node* pos_pList = pList->GetFirst();
	if (pos_pList == NULL)
		return FALSE; // there isn't any content in the list
	bool bIsFirst = TRUE;
	while (pos_pList != NULL)
	{
		pSrcPhrase = (CSourcePhrase*)pos_pList->GetData();
		pos_pList = pos_pList->GetNext();
		// this test assumes empty notes will never occur in the document (currently, if a
		// note is left empty, it doesn't get stored), empty free translations are permitted
		if (!bIsFirst &&
			(
			(!pSrcPhrase->GetFreeTrans().IsEmpty() || pSrcPhrase->m_bStartFreeTrans) ||
			!pSrcPhrase->GetNote().IsEmpty() ||
			!pSrcPhrase->GetCollectedBackTrans().IsEmpty() ||
			!pSrcPhrase->GetFilteredInfo().IsEmpty()
			)
		)
		/* use this test instead of the above if we ever allow storage of empty notes
			(!pSrcPhrase->GetFreeTrans().IsEmpty() || pSrcPhrase->m_bStartFreeTrans) ||
			(pSrcPhrase->m_bHasNote || !pSrcPhrase->GetNote().IsEmpty()) ||
			!pSrcPhrase->GetCollectedBackTrans().IsEmpty() ||
			!pSrcPhrase->GetFilteredInfo().IsEmpty()
		*/
			return TRUE;
		bIsFirst = FALSE;
	}
	return FALSE;
}

// IsSelectionAcrossFreeTranslationEnd() -- BEW added 22Jul05, to be used in
// OnButtonMerge() in order to abort the merge operation if the user is trying to merge
// CSourcePhrase instances where the selection begins before a sourcephrase which is the
// end of a free translation section and extends further into a part of the document in
// which no free translation is defined (the case where what follows is another free
// translation section is already blocked by the requirement that no merge can be done
// across filtered material); pList is the list of selected CSourcePhrase instances
// BEW 16Feb10, no changes needed for support of doc version 5
bool CAdapt_ItView::IsSelectionAcrossFreeTranslationEnd(SPList* pList)
{
	// For doc version 5, no change is needed herein
	CSourcePhrase* pSrcPhrase;
	SPList::Node* pos_pList = pList->GetFirst();
	if (pos_pList == NULL)
		return FALSE; // there isn't any content in the list
	bool bFoundFreeTranslationEnd = FALSE;
	bool bExtendsBeyondFreeTranslation = FALSE;
	while (pos_pList != NULL)
	{
		pSrcPhrase = (CSourcePhrase*)pos_pList->GetData();
		pos_pList = pos_pList->GetNext();
		if (bFoundFreeTranslationEnd)
		{
			bExtendsBeyondFreeTranslation = TRUE;
			continue;
		}
		if (pSrcPhrase->m_bEndFreeTrans)
		{
			bFoundFreeTranslationEnd = TRUE;
			continue;
		}
	}
	return bExtendsBeyondFreeTranslation;
}

// IsSelectionAcrossHiddenAttributesMetdata() -- BEW added 30Sep19, to be used in
// OnButtonMerge(), and Retranslation.cpp's OnButtonRetranslation, in order to abort the 
// merge attempt, or the retranslation attempt, if there are CSourcePhrase instances of
// the selection where there is hidden stored marker attributes metadata on *any* of the 
// instances of the selection.
// The reasons: for or retranslations, the link to the stored metadata becomes broken, 
// and restoration of such metadata in an export to Paratext likely would generate a 
// data error (bad location). For mergers, unhiding for a filtering span gives too many
// difficulties to solve.
// The parameter strAt returns the m_srcPhrase string from the first CSourcePhrase
// instance which contains stored hidden attributes metadata - so the user can be shown
// where the offending storage location is - so as to avoid it.
// BEW 6Apr20, since a CSourcePhrase can store data which is NOT attributes metadata in
// its m_punctsPattern member, and have m_bUnused set TRUE as a consequence of that, we
// must also check that the pSrcPhrase does not have m_bHasInternalPunct set TRUE, because
// if that is true, then the pSrcPhrase is not storing cached metadata, but rather words
// for helping with auto puncts placement that avoids a Placement... dialog
// If ever these two storage options clash on the one CSourcePhrase instance, then the
// hiding of attributes metadata will win - which probably means that a punctuation
// Placement dialog which otherwise would not show, will show and the the user will have
// to do a manual placement within it. (It's safer that way, than letting the cache data
// be lost)
// whm 8Mar2024 modified this function to return more information so the user warning the
// caller creates will be more understandable in the two places this function is called: 
// In the View's OnButtonMerge(), and in Retranslation.cpp's OnButtonRetranslation().
// The additional information is returned via ref parameters srcWords and mkrSpan
//bool CAdapt_ItView::IsSelectionAcrossHiddenAttributesMetadata(SPList* pList, wxString &strAt)
bool CAdapt_ItView::IsSelectionAcrossHiddenAttributesMetadata(SPList* pList, 
	wxString& srcWords,
	wxString& strAt,
	wxString& mkrSpan)
{
	CSourcePhrase* pSrcPhrase;
	SPList::Node* pos_pList = pList->GetFirst();
	strAt = wxEmptyString;
	if (pos_pList == NULL)
		return FALSE; // there isn't any content in the list
	bool bIllegalInternalHiddenMetadata = FALSE;
	// There could be both types of storage in the span; we don't allow both on the
	// same pSrcPhrase - earlier code gives priority to attributes hiding; but if
	// the span has both at different locations, the there is no clash, but the
	// presence of attribute hiding wins out in the suppression stakes. So the
	// simple double test below suffices
	srcWords.Empty();
	mkrSpan.Empty();
	wxString beginMkr; beginMkr.Empty();
	int wordNumber = 1;
	int wordNumberAtHiddenData = -1;
	while (pos_pList != NULL)
	{
		pSrcPhrase = (CSourcePhrase*)pos_pList->GetData();
		srcWords += (_T(" ") + pSrcPhrase->m_srcPhrase);
		beginMkr += pSrcPhrase->GetInlineNonbindingMarkers(); // the \jmp ...\jmp* maker is an inline nonbinding one
		beginMkr += pSrcPhrase->GetInlineBindingMarkers(); // the \w ...\w* marker is an inline binding one
		pos_pList = pos_pList->GetNext();
		if ((pSrcPhrase->m_bUnused == TRUE) && (pSrcPhrase->m_bHasInternalPunct == FALSE))
		{
			bIllegalInternalHiddenMetadata = TRUE;
			mkrSpan = pSrcPhrase->m_punctsPattern; 
			strAt = pSrcPhrase->m_srcPhrase;
			wordNumberAtHiddenData = wordNumber;
			//break; // we want the whole sublist traversed to collect the mkrSpan
		}
		wordNumber++;
	}
	if (bIllegalInternalHiddenMetadata)
	{
		wxString addEllipsis; addEllipsis.Empty();
		srcWords.Trim(FALSE); // remove initial space
		if (wordNumberAtHiddenData > 1)
			addEllipsis = _T(" ... ");
		mkrSpan = addEllipsis + beginMkr + mkrSpan; // the inline binding/nonbinding begin marker + m_punctsPattern contents.
	}
	return bIllegalInternalHiddenMetadata;
}


// BEW updated OnButtonMerge() 16Feb10, for support of doc version 5
// BEW refactored 21Jul14 for support of ZWSP
void CAdapt_ItView::OnButtonMerge(wxCommandEvent& WXUNUSED(event))
{
	// 25Mar09 added partner pile updating
	CLayout* pLayout = GetLayout();
	CAdapt_ItApp* pApp = (CAdapt_ItApp*)&wxGetApp();

	// Indicate that a merger is in progress (see Adapt_It.h for an explanation of
	// why we need this flag)
	pApp->m_bMergerIsCurrent = TRUE;

    // In glossing mode (ie. actually glossing) I think I've managed to silently prevent
    // any merge from happening before OnButtonMerge( ) can get invoked. However, it the
    // user were to explicitly click the button, there is no recourse except to tell him
    // that the merge is not available when doing glossing
	if (gbIsGlossing)
	{
		// IDS_NOT_WHEN_GLOSSING
        // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
        pApp->m_bUserDlgOrMessageRequested = TRUE;
        wxMessageBox(_(
		"This particular operation is not available when you are glossing."),
		_T(""), wxICON_INFORMATION | wxOK);
		pApp->m_bMergerIsCurrent = FALSE;
		return;
	}

	// not glossing, so continue to process the merge request
	SPList* pList = new SPList; // list of the selected CSourcePhrase objects
	wxASSERT(pList != NULL);
	CAdapt_ItDoc* pDoc = GetDocument();
	SPList* pSrcPhrases = pApp->m_pSourcePhrases;
	CPile* pStartingPile;
	CSourcePhrase* pSrcPhrase = NULL;
	int nCount;
	CPile* pPile;
	int nSaveSequNum;
	CCellList::Node* pos_pCellList = NULL;

    // use strOldAdaptation to accumulate any existing adaptations, which will do so
    // regardless of whether some or all of the srcPhrases are already merged

    // BEW 13Nov10;  remove strAdapt, it just wastes processor time.
    // the strAdapt accumulation variable used later only accumulates after any unmerges
    // are done, so we don't use that unless strOldAdaptation is empty

	wxString strOldAdaptation;
	strOldAdaptation.Empty();
	gOldConcatStr.Empty();
	gOldConcatStrNoPunct.Empty();
	bool bSuppressCopyingExtraSourceWords = FALSE;
	bool bNoninitialSelectionsHaveTranslation = FALSE;	// TRUE if a non-active-location
												// selected pile has a translation in it
	if (pApp->m_pTargetBox->m_bRetainBoxContents)
	{
        // whenever this is set, the user will have just deselected the default text in the
        // phrase box and selected some source words- and so we get to this present code
        // block when merging. In this circumstance we don't want the deselected phrase box
        // contents to be thrown away (it was, in earlier versions) since the deselection
        // operation was clearly intended in order to retain that text; so when that
        // happens we take the box contents 'as is' as the initial string of text in
        // strOldAdaptation
		wxString s;
		s = pApp->m_pTargetBox->GetTextCtrl()->GetValue(); // whm 12Jul2018 added GetTextCtrl()-> part
		strOldAdaptation = s;
		pApp->m_targetPhrase = s;
	}

    // if we are merging because of a match when LookAhead was called, set things up using
    // the m_nWordsInPhrase value in the PhraseBox file; otherwise, use the
    // selection (bLookAheadMerge is a static class boolean defined in the CAdapt_ItApp
    // class & set by the LookAhead function in CPhraseBox class)
#if defined(_DEBUG)
	// I want to see what values these app booleans have at this point
	pApp->m_bUseSrcWordBreak = pApp->m_bUseSrcWordBreak;
	pApp->m_bZWSPinDoc = pApp->m_bZWSPinDoc;
#endif
	if (pApp->bLookAheadMerge)
	{
		if (gbDoingInitialSetup && pApp->m_pTargetBox->GetHandle() == NULL)
		{
			gbJustCancelled = FALSE;
		}
		else if (pApp->m_pTargetBox->GetHandle() == NULL || pApp->m_pTargetBox->IsShown())
		{
			if (gbJustCancelled)
			{
				gbJustCancelled = FALSE;
			}
			else
			{
				// try skipping to the rest of the process, rather than aborting
				;
			}
		}
		nCount = pApp->m_pTargetBox->m_nWordsInPhrase; // RHS is a member of CPhraseBox
		pPile = pApp->m_pActivePile;
		wxASSERT(pPile != NULL);
		pStartingPile = pPile; // need this later - see next block for explanation
		pSrcPhrase = pPile->GetSrcPhrase();
		strOldAdaptation = pSrcPhrase->m_adaption; // don't use punctuated string
		pList->Append(pSrcPhrase); // add ptr of first to the temporary list
		nSaveSequNum = pSrcPhrase->m_nSequNumber; // save its sequ number, everything depends
		int i;									  // on this
		for (i = 1; i < nCount; i++)
		{
			pPile = GetNextPile(pPile); // next one in the sequence
			wxASSERT(pPile != NULL);
			pSrcPhrase = pPile->GetSrcPhrase();
			if (strOldAdaptation.IsEmpty())
				strOldAdaptation = pSrcPhrase->m_adaption;
			else
				strOldAdaptation += PutSrcWordBreak(pSrcPhrase) + pSrcPhrase->m_adaption; // always concat in natural order
			pList->Append(pSrcPhrase);  // add the pointer to the list
		}

        // for a look ahead merge, treat it as if user typed it, so that if there is a
        // user-generated extension done, the inserted translation will not be removed and
        // copied source text used instead
		pApp->m_bUserTypedSomething = TRUE;
	} // end block for bLookAhead merge == TRUE
	else // pApp->bLookAheadMerge is FALSE
	{
        // whm 10Sep08 added: The MFC code assumes that we won't get here if the Make a
        // Phrase button is disabled, however, in wx a CTRL-M and other accelerator keys
        // are propagated as key events even when the control they are associated with is
        // disabled, so we must bail out if there is no selection at this point, otherwise
        // we'll get a crash on pos_pCellList->GetData() below.
		if (pApp->m_selection.GetCount() == 0)
		{
			pList->Clear();
			if (pList != NULL) // whm 11Jun12 added NULL test
				delete pList;
			pList = (SPList*)NULL;
			RemoveSelection(); // whm this not really needed as there is no selection
							   // (but doesn't hurt)
			// WX Note: There is no ::IsWindow() equivalent in wxWidgets
			if (pApp->m_pTargetBox->GetHandle() != NULL)
			{
                // whm 13Aug2018 Note: The SetFocus() call here precedes the SetSelection, so
                // it should work OK on Linux/Mac.
                pApp->m_pTargetBox->GetTextCtrl()->SetFocus();
                // whm 3Aug2018 Note: No suppression of any select all would be appropriate for 
                // the SetSelection call below.
				pApp->m_pTargetBox->GetTextCtrl()->SetSelection(pApp->m_nStartChar, pApp->m_nEndChar);
			}
            pApp->m_bMergeSucceeded = FALSE;
			Invalidate(); // get a redraw done, and the phrase box reshown
			GetLayout()->PlaceBox();
			pApp->m_bMergerIsCurrent = FALSE;
			return;
		}

        // get a list of the selected CSourcePhrase instances (some might not be minimal
        // ones so if this is the case we must restore them to minimal ones)
		pos_pCellList = pApp->m_selection.GetFirst();	//MFC pos_pCellList = m_selection.GetHeadPosition();
		nCount = pApp->m_selection.GetCount();
		pPile = ((CCell*)pos_pCellList->GetData())->GetPile();	// get the pile first in selection
		pos_pCellList = pos_pCellList->GetNext();  // need this to effect MFC's GetNext()
		pStartingPile = pPile; // need this for later when we look up the strip which
							   // first pile is in prior to calling RecalcLayout()
		pSrcPhrase = pPile->GetSrcPhrase();

		// at the active location, use pApp->m_targetPhrase if it's different from
		// the stored adaptation;
		if (pStartingPile == pApp->m_pActivePile)
		{
			strOldAdaptation = pApp->m_targetPhrase;

            // version 2.3.0, we don't want to have empty piles in the selection ahead of
            // the active location to have their source text copied to the existing
            // translation, because very seldom will that be useful - mostly the user has
            // to delete such additions, so from now on we will suppress the copy operation
            // using a local flag set here.
			// BEW 12Jan17 RickNivens found CC didn't work with a merger. Testing reveals
			// it is because this next flag was unilaterally set TRUE. It needs to be FALSE
			// if one or more CC tables is in operation, so that strOldAdaptation will
			// accumulate CC-processed substrings from the m_key members of the pSrcPhrase
			// instances. So add the needed test
			if (pApp->m_bUseConsistentChanges)
			{
				bSuppressCopyingExtraSourceWords = FALSE;
			}
			else
			{
				bSuppressCopyingExtraSourceWords = TRUE;
			}
		}
		else
		{
            // if the box is not within the selection, we will want to save the box
            // contents first, otherwise the contents will be lost when the merge takes
            // place
            // BEW 05Oct06; commented out next line, because CopySourceKey() sets
            // m_bBoxTextByCopyOnly to TRUE and if a copy has just been done before this merge, it
            // makes no sense to make the flag FALSE here so as to force a copy; so we want
            // the copy skipped if the flag is still TRUE
			//m_bBoxTextByCopyOnly = FALSE;
			if (!pApp->m_pTargetBox->m_bAbandonable || !pApp->m_pTargetBox->m_bBoxTextByCopyOnly)
			{
				MakeTargetStringIncludingPunctuation(pApp->m_pActivePile->GetSrcPhrase(), pApp->m_targetPhrase);
				RemovePunctuation(pDoc, &pApp->m_targetPhrase, from_target_text);

                // the store will fail if the user edited the entry out of the KB, as the
                // latter cannot know which srcPhrases will be affected, so these will
                // still have their m_bHasKBEntry set true. We have to test for this, ie. a
				// null pRefString or rsEntry returning present_but_deleted. Test, and if
				// the flag is TRUE, set it to FALSE
				CRefString* pRefStr = NULL;
				KB_Entry rsEntry = pApp->m_pKB->GetRefString(pApp->m_pActivePile->GetSrcPhrase()->m_nSrcWords,
							pApp->m_pActivePile->GetSrcPhrase()->m_key, pApp->m_targetPhrase, pRefStr);
				if ((pRefStr == NULL || rsEntry == present_but_deleted) &&
					pApp->m_pActivePile->GetSrcPhrase()->m_bHasKBEntry)
				{
								pApp->m_pActivePile->GetSrcPhrase()->m_bHasKBEntry = FALSE;
				}
                //pApp->m_bInhibitMakeTargetStringCall = TRUE;
				bool bOK;
				bOK = pApp->m_pKB->StoreText(pApp->m_pActivePile->GetSrcPhrase(), pApp->m_targetPhrase);
				bOK = bOK; // avoid warning
                pApp->m_bInhibitMakeTargetStringCall = FALSE;
			}
			// BEW 12Jan17 added this test - copied from block above, see comments in block above for why
			if (pApp->m_bUseConsistentChanges)
			{
				bSuppressCopyingExtraSourceWords = FALSE;
			}
			else
			{
				bSuppressCopyingExtraSourceWords = TRUE;
			}

			// get the first translation string, or something possibly useful, into the list
			if (pSrcPhrase->m_targetStr.IsEmpty())
			{
				if (pApp->m_bCopySource)
				{
					strOldAdaptation = CopySourceKey(pSrcPhrase, pApp->m_bUseConsistentChanges);
				}
			}
			else
			{
				if (!pSrcPhrase->m_bNotInKB)
					strOldAdaptation = pSrcPhrase->m_adaption;
			}
		}
		pList->Append(pSrcPhrase); // add first to the temporary list
		nSaveSequNum = pSrcPhrase->m_nSequNumber; // save its sequ number, all depends on it

        // while we fill the list, also accumulate the translations; remembering that the
        // pSrcPhrase at the active location will not have its m_adaption or m_targetStr
        // members set yet, but the appropriate value will be in the view's
        // pApp->m_targetPhrase member for RTL support we don't reverse the order of words
        // as we accumulate, (Uniscribe will render the string RTL correctly after it is
        // merged in natural order); and for version 2.3.0 we suppress the copying of
        // selected source words as target text to append to the existing target text since
        // this is usually not helpful
		while (pos_pCellList != NULL)
		{
			CCell* pCell = (CCell*)pos_pCellList->GetData();
			pos_pCellList = pos_pCellList->GetNext();
			pPile = pCell->GetPile();
			pSrcPhrase = pPile->GetSrcPhrase();
			wxASSERT(pSrcPhrase != NULL);

            // at the active location, use pApp->m_targetPhrase if it is different from the
            // stored adaptation; works right even if user typed punct explicitly

            // BEW changed 05Oct06: this loop begins at the second pSrcPhrase in the list,
            // so when we've selected leftwards, this could be the active location with
            // copied src text and we'd not really want to use copied src text I think (but
            // at non-active locations we'd allow the copy to be done, as in the else block
            // below for the pPile == m_pActivePile test); so the change I'm making here is
            // just in the TRUE block for the pPile == m_pActivePile test:
            // to suppress copied text then for a backwards selection -- we can test for
            // these by m_curDirection's value, and phrase box's m_bAbandonable being still
            // FALSE; however strOldAdaptation is not our primary source for merged
            // adaptation text, it is only a fall back, so further changes are to be done
            // further down
			if (pPile == pApp->m_pActivePile)
			{
				if (!pApp->m_targetPhrase.IsEmpty())
				{
					// skip if selecting left and src text was copied
					if (!(pApp->m_curDirection == toleft && pApp->m_pTargetBox->m_bAbandonable))
					{
						strOldAdaptation += PutSrcWordBreak(pSrcPhrase) + pApp->m_targetPhrase;
					}
				}
			}
			else
			{
				// this pile is not at the active location
				if (strOldAdaptation.IsEmpty()) // strOldAdaptation is empty
				{
					if (pSrcPhrase->m_adaption.IsEmpty())
					{
						if (pApp->m_bCopySource && !bSuppressCopyingExtraSourceWords)
							strOldAdaptation =
							CopySourceKey(pSrcPhrase,pApp->m_bUseConsistentChanges);
					}
					else
					{
						strOldAdaptation = pSrcPhrase->m_adaption;
						bNoninitialSelectionsHaveTranslation = TRUE;
					}
				}
				else // strOldAdaptation is not empty
				{
					if (pSrcPhrase->m_adaption.IsEmpty())
					{
						if (pApp->m_bCopySource && !bSuppressCopyingExtraSourceWords)
						if (pApp->m_bCopySource)
							strOldAdaptation += PutSrcWordBreak(pSrcPhrase) +
							CopySourceKey(pSrcPhrase, pApp->m_bUseConsistentChanges);
					}
					else
					{
						strOldAdaptation += PutSrcWordBreak(pSrcPhrase) + pSrcPhrase->m_adaption;
						bNoninitialSelectionsHaveTranslation = TRUE;
					}
				}
			}
			pList->Append(pSrcPhrase);
		}
	}

	// set the global strings, in case they are wanted (eg. in a Find & Replace they may be used)
	gOldConcatStr = strOldAdaptation;
	gOldConcatStrNoPunct = strOldAdaptation;
	RemovePunctuation(pDoc, &gOldConcatStrNoPunct, from_target_text);

	// check for a retranslation in the selection, and abort the merge operation if there is one
	if (IsRetranslationInSelection(pList))
	{
		// IDS_NO_RETRANSLATION_IN_SEL
        // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
        pApp->m_bUserDlgOrMessageRequested = TRUE;
        wxMessageBox(_(
"This operation is not permitted when the selection contains any part of a retranslation. First remove the retranslation and then try again."),
		_T(""), wxICON_EXCLAMATION | wxOK);
		pList->Clear();
		if (pList != NULL) // whm 11Jun12 added NULL test
			delete pList;
		pList = (SPList*)NULL;
		RemoveSelection();
		// WX Note: There is no ::IsWindow() equivalent in wxWidgets
		if (pApp->m_pTargetBox->GetHandle() != NULL)
		{
            // whm 13Aug2018 Note: The SetFocus() call here precedes the SetSelection, so
            // it should work OK on Linux/Mac.
            pApp->m_pTargetBox->GetTextCtrl()->SetFocus();
            // whm 3Aug2018 Note: No suppression of any select all would be appropriate for 
            // the SetSelection call below.
            pApp->m_pTargetBox->GetTextCtrl()->SetSelection(pApp->m_nStartChar, pApp->m_nEndChar);
		}
        pApp->m_bMergeSucceeded = FALSE;
		Invalidate();
		GetLayout()->PlaceBox();
		GetLayout()->Redraw();
		pApp->m_bMergerIsCurrent = FALSE;
		return;
	}

    // BEW 11Oct10, added for docVersion5 support: check for a USFM fixedspace symbol (~)
	// in the selection, and abort the merge operation if there is one (while this is
	// strictly speaking not a docVersion5 issue, doc version 5 parses input data
	// containing ~ better - and if there is punctuation before or after then that
	// punctuation is made medial to the word pair, and because we can't distinguish that
	// punctuation from other just-made-medial punctuation due to the merge, it is best to
	// forbid the merger in the first place)
	if (IsFixedSpaceSymbolInSelection(pList))
	{
        // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
        pApp->m_bUserDlgOrMessageRequested = TRUE;
        wxMessageBox(_(
"Merging is not permitted when the selection contains ~ which is the USFM fixed space marker.\nTry a retranslation instead."),
		_T(""), wxICON_EXCLAMATION | wxOK);
		pList->Clear();
		if (pList != NULL) // whm 11Jun12 added NULL test
			delete pList;
		pList = (SPList*)NULL;
		RemoveSelection();
		if (pApp->m_pTargetBox->GetHandle() != NULL)
		{
            // whm 13Aug2018 Note: The SetFocus() call here precedes the SetSelection, so
            // it should work OK on Linux/Mac.
            pApp->m_pTargetBox->GetTextCtrl()->SetFocus();
            // whm 3Aug2018 Note: No suppression of any select all would be appropriate for 
            // the SetSelection call below.
            pApp->m_pTargetBox->GetTextCtrl()->SetSelection(pApp->m_nStartChar, pApp->m_nEndChar);
		}
        pApp->m_bMergeSucceeded = FALSE;
		Invalidate();
		GetLayout()->PlaceBox();
		GetLayout()->Redraw();
		pApp->m_bMergerIsCurrent = FALSE;
		return;
	}

    // check for a null source phrase in the selection, and abort the merge operation if
    // there is one
	if (IsNullSrcPhraseInSelection(pList))
	{
		// IDS_NO_NULL_SRCPHRASE_IN_SEL
        // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
        pApp->m_bUserDlgOrMessageRequested = TRUE;
        wxMessageBox(_(
"Merging a selection which contains a placeholder (represented by ... dots) is not permitted."),
		_T(""), wxICON_EXCLAMATION | wxOK);
		pList->Clear();
		if (pList != NULL) // whm 11Jun12 added NULL test
			delete pList;
		pList = (SPList*)NULL;
		// WX Note: There is no ::IsWindow() equivalent in wxWidgets
		if (pApp->m_pTargetBox->GetHandle() != NULL)
		{
            // whm 13Aug2018 Note: The SetFocus() call here precedes the SetSelection, so
            // it should work OK on Linux/Mac.
            pApp->m_pTargetBox->GetTextCtrl()->SetFocus();
            // whm 3Aug2018 Note: No suppression of any select all would be appropriate for 
            // the SetSelection call below.
            pApp->m_pTargetBox->GetTextCtrl()->SetSelection(pApp->m_nStartChar,pApp->m_nEndChar);
		}
        pApp->m_bMergeSucceeded = FALSE;
		Invalidate();
		GetLayout()->PlaceBox();
		RemoveSelection();
		GetLayout()->Redraw();
		pApp->m_bMergerIsCurrent = FALSE;
		return;
	}

	// check for filtered material in any of the sourcephrase instances,
	// and abort the merge operation if there is some (we could handle it, but
	// we just don't want to - for instance, nav text might be too long to
	// view properly, and the green wedge would disappear and editability of
	// the filtered stuff would be lost)
	// 
	// whm 27Jan2024 removed the following test. I think we should allow
	// a merger across filtered information. I don't think there is a compelling
	// reason to forbid it. The following function actually only forbid it if
	// the filtered information is stored on a non-initial source phrase and
	// the refactored filtering code now actually stores filtered information
	// on the previous source word, or on a previous merger that, when unmerged,
	// ends up on the last word of the un-merged set of words. Even the old 
	// code could save filtered info on a following merged phrase, albeit it
	// wouldn't do a very graceful un-merge when the merged phrase had some
	// filtered info put there by the ReconstituteAfterFilteringChange() function.
	// Therefore I'm commenting out the following if (IsFilteredMaterialNonInitial().
	/*
	if (IsFilteredMaterialNonInitial(pList))
	{
		//IDS_NO_MERGE_FILTERED
        // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
        pApp->m_bUserDlgOrMessageRequested = TRUE;
        wxMessageBox(_(
		"Merging words across filtered material is not allowed."),
		_T(""), wxICON_EXCLAMATION | wxOK);
		pList->Clear();
		if (pList != NULL) // whm 11Jun12 added NULL test
			delete pList;
		pList = (SPList*)NULL;
		RemoveSelection();
		if (pApp->m_pTargetBox->GetHandle() != NULL)
		{
            // whm 13Aug2018 Note: The SetFocus() call here precedes the SetSelection, so
            // it should work OK on Linux/Mac.
            pApp->m_pTargetBox->GetTextCtrl()->SetFocus();
            // whm 3Aug2018 Note: No suppression of any select all would be appropriate for 
            // the SetSelection call below.
            pApp->m_pTargetBox->GetTextCtrl()->SetSelection(pApp->m_nStartChar,pApp->m_nEndChar);
		}
        pApp->m_bMergeSucceeded = FALSE;
		Invalidate();
		GetLayout()->PlaceBox();
		GetLayout()->Redraw();
		pApp->m_bMergerIsCurrent = FALSE;
		return;
	}
	*/

    // check user is not trying to do a merger across the end of a free translation - it
    // can legally be done up to the end, but not across it (BEW added 22Jul05)
	if (IsSelectionAcrossFreeTranslationEnd(pList))
	{
		//IDS_NO_MERGE_ACROSS_FT_END
        // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
        pApp->m_bUserDlgOrMessageRequested = TRUE;
        wxMessageBox(_(
"Merging across the end of a free translation is not permitted. (You can merge up to the end of the free translation, but not beyond that point in the same merger.)"),
		_T(""), wxICON_EXCLAMATION | wxOK);
		pList->Clear();
		if (pList != NULL) // whm 11Jun12 added NULL test
			delete pList;
		pList = (SPList*)NULL;
		RemoveSelection();
		if (pApp->m_pTargetBox->GetHandle() != NULL)
		{
            // whm 13Aug2018 Note: The SetFocus() call here precedes the SetSelection, so
            // it should work OK on Linux/Mac.
            pApp->m_pTargetBox->GetTextCtrl()->SetFocus();
            // whm 3Aug2018 Note: No suppression of any select all would be appropriate for 
            // the SetSelection call below.
            pApp->m_pTargetBox->GetTextCtrl()->SetSelection(pApp->m_nStartChar, pApp->m_nEndChar);
		}
        pApp->m_bMergeSucceeded = FALSE;
		Invalidate();
		GetLayout()->PlaceBox();
		GetLayout()->Redraw();
		pApp->m_bMergerIsCurrent = FALSE;
		return;
	}

	// Check user is not trying to do a merger across hidden USFM3 attributes metadata.
	// To allow it would create too many problems if filtering of the merger was attempted.
	// (BEW added 30Sep19)
	// Similar constraint is appropriate for retranslations, stored metadata is not 
	// allowed on any CSourcePhrase instance of the selection,
	// because the user may do anything he/she likes for the retranslation and so the
	// integrity of the stored metadata would not be determinate
	bool bIllegalInternalHiddenMetadata = FALSE; // If stays FALSE, the merger can go ahead.
	// The signature param bIsMerger is default FALSE - see comment in Adapt_ItView.h for
	// more information; since this is a merger attempt, TRUE must be overtly supplied
	wxString strAt = wxEmptyString;
	wxString srcWords = wxEmptyString;
	wxString mkrSpan = wxEmptyString;
	bIllegalInternalHiddenMetadata = IsSelectionAcrossHiddenAttributesMetadata(pList, srcWords, strAt, mkrSpan);
	if (bIllegalInternalHiddenMetadata)
	{
		// whm 8Mar2024 revised the warning message below to be more understandable to the user and also
		// its original form didn't actually include the warning, only the single word passed into the %s due
		// to a faulty .Format() call that didn't have the msg as first parameter of .Format().
		// Also to supply more helpful information in the warning, I've added two parameters to the
		// IsSelectionAcrossHiddenAttributesMetadata() function call above, with the necessary internal
		// modifications.
		//wxString msg = _("Merging across stored(hidden) USFM3 metadata is not allowed. The metadata is hidden at the word: %s");
		//msg = msg.Format(strAt.c_str());
		wxString msg = _("Adapt It attempted to make a phrase of the source words \" %s\".\nHowever, the word \"%s\" within this marker span:\n\n%s\n\nhas stored (hidden/filtered) data.\nMaking a phrase across stored (hidden/filtered) data is not allowed.");
		msg = msg.Format(msg, srcWords.c_str(), strAt.c_str(), mkrSpan.c_str());
        // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
        pApp->m_bUserDlgOrMessageRequested = TRUE;
        wxMessageBox(msg, _("Making a phrase across hidden data not allowed"), wxICON_EXCLAMATION | wxOK);
		pList->Clear();
		if (pList != NULL) // whm 11Jun12 added NULL test
			delete pList;
		pList = (SPList*)NULL;
		RemoveSelection();
		if (pApp->m_pTargetBox->GetHandle() != NULL)
		{
			// whm 13Aug2018 Note: The SetFocus() call here precedes the SetSelection, so
			// it should work OK on Linux/Mac.
			pApp->m_pTargetBox->GetTextCtrl()->SetFocus();
			// whm 3Aug2018 Note: No suppression of any select all would be appropriate for 
			// the SetSelection call below.
			pApp->m_pTargetBox->GetTextCtrl()->SetSelection(pApp->m_nStartChar, pApp->m_nEndChar);
		}
		pApp->m_bMergeSucceeded = FALSE;
		Invalidate();
		GetLayout()->PlaceBox();
		GetLayout()->Redraw();
		pApp->m_bMergerIsCurrent = FALSE;
		return;
	}

    // there might be some <Not In KB> source phrases in the list, so ensure the srcPhrases
    // have the flag cleared (added 1-Feb-2001)
    // Up to this point pos_pCellList has been assigned as CCellList::Node* and SPList has not had a
    // node assigned to it, so we'll do that now. We can't use pos_pCellList here because it is
    // already a node associated with a CCellList. BE CAREFULL not to mix pos_pCellList and
    // nodeSPTemp below as the condition for while loops, etc!!!
	SPList::Node* nodeSPTemp = pList->GetFirst();

	while (nodeSPTemp != NULL)
	{

		CSourcePhrase* pSP = (CSourcePhrase*)nodeSPTemp->GetData();
		nodeSPTemp = nodeSPTemp->GetNext();
		wxASSERT(pSP != 0);
		pSP->m_bNotInKB = FALSE;
	}

	// if there are too many words in the selection, do a retranslation instead of a merge
	if (GetSelectionWordCount() > MAX_WORDS)
	{
		pApp->GetRetranslation()->DoRetranslation();
        pApp->m_bMergeSucceeded = FALSE;
		pApp->m_bMergerIsCurrent = FALSE;
		return;
	}

	// make pApp->m_targetPhrase cleared, as it must accumulate any existing translations
	// removed from the KB because of the merge
	pApp->m_targetPhrase.Empty();

	// determine if there are any non-minimal phrases selected. If there are, we must
	// restore the original list of minimal phrases (ie. words), and clear the
	// translations from the KB, before proceeding.
	int nNumElements = 1;
	nodeSPTemp = pList->GetFirst();
	while (nodeSPTemp != NULL)
	{
		CSourcePhrase* pSrcPhrase = (CSourcePhrase*)nodeSPTemp->GetData();
		nodeSPTemp = nodeSPTemp->GetNext();
		int nStartingSequNum = pSrcPhrase->m_nSequNumber;
		nNumElements = 1;
		if (pSrcPhrase->m_nSrcWords > 1)
		{
			// have to restore to original state (RestoreOriginalMinPhrases also
			// appends any adaptation(s) to pApp->m_targetPhrase)
			nNumElements = RestoreOriginalMinPhrases(pSrcPhrase, nStartingSequNum);

			// update nCount
			int nExtras = nNumElements - 1;
			nCount += nExtras;

			// BEW added 30Sep08 in support of vertical editing
			if (gbVerticalEditInProgress && gEditStep == adaptationsStep)
			{
				gEditRecord.nAdaptationStep_EndingSequNum += nExtras;
				gEditRecord.nAdaptationStep_ExtrasFromUserEdits += nExtras;
				gEditRecord.nAdaptationStep_NewSpanCount += nExtras;
			}

		}
		else // block for pSrcPhrase->m_nSrcWords == 1
		{
            // append its m_translation in the CRefString to pApp->m_targetPhrase, then
            // remove the refString from the KB, etc.
			CRefString* pRefString = NULL;
			KB_Entry rsEntry = pApp->m_pKB->GetRefString(pSrcPhrase->m_nSrcWords,
											pSrcPhrase->m_key, pSrcPhrase->m_adaption,
											pRefString);
			if (pRefString != NULL && rsEntry == really_present)
			{
				if (pRefString->m_translation != _T("<Not In KB>"))
				{
					if (pApp->m_targetPhrase.IsEmpty())
						pApp->m_targetPhrase = pRefString->m_translation;
					else
					{
						if (!pRefString->m_translation.IsEmpty())
						{
							pApp->m_targetPhrase = pApp->m_targetPhrase + PutSrcWordBreak(pSrcPhrase) +
															pRefString->m_translation;
						}
					}
                    // the following call needs to be within this block, not after it,
                    // because we don't want to also remove any <Not In KB> entries from
                    // the KB (altered 1-Feb-2001)
					pApp->m_pKB->RemoveRefString(pRefString, pSrcPhrase, pSrcPhrase->m_nSrcWords);
				}
			}
			else // pRefString == NULL or rsEntry == present_but_deleted
			{
                // if all else fails to find some text for this box (provided it is the
                // active location), then pull out whatever is stored in the CEdit itself -
                // since if we got here by a click, then the KB will have been modified
				if (pSrcPhrase == pApp->m_pActivePile->GetSrcPhrase())
				{
					// WX Note: There is no ::IsWindow() equivalent in wxWidgets
					if (pApp->m_pTargetBox->GetHandle() != NULL)
					{
						if (pApp->m_targetPhrase.IsEmpty())
							pApp->m_targetPhrase = pApp->m_pTargetBox->GetTextCtrl()->GetValue(); // whm 12Jul2018 added GetTextCtrl()-> part
						else
						{
							wxString str;
							str = pApp->m_pTargetBox->GetTextCtrl()->GetValue(); // whm 12Jul2018 added GetTextCtrl()-> part
							pApp->m_targetPhrase = pApp->m_targetPhrase + PutSrcWordBreak(pSrcPhrase) + str;
						}
					}
				}
			}
		}
	}

    // delete the temporary list, and then do the merge using the restored minimal phrases
    // for the original selection
	pList->Clear();
	if (pList != NULL) // whm 11Jun12 added NULL test
		delete pList;
	pList = (SPList*)NULL;

    // at this point, pApp->m_targetPhrase may not have anything in it, because no
    // accumulation was possible, so check if it is empty and if so then restore it from
    // the window's title text.
	if (pApp->m_targetPhrase.IsEmpty())
	{
		// WX Note: There is no ::IsWindow() equivalent in wxWidgets
		if (pApp->m_pTargetBox->GetHandle() != NULL)
		{
			pApp->m_targetPhrase = pApp->m_pTargetBox->GetTextCtrl()->GetValue(); // whm 12Jul2018 added GetTextCtrl()-> part
		}
	}

	/*
	// a block for debugging, to check adaptation span boundaries before the merge
	if (gbVerticalEditInProgress)
	{
		int nStartSN = gEditRecord.nAdaptationStep_StartingSequNum;
		int nEndSN = gEditRecord.nAdaptationStep_EndingSequNum;
		int nExtrasFromEdits = gEditRecord.nAdaptationStep_ExtrasFromUserEdits;
		int nNewSpanCnt = gEditRecord.nAdaptationStep_NewSpanCount;
	}
	*/
	// determine the first srcPhrase in the merge operation
	nodeSPTemp = pSrcPhrases->Item(nSaveSequNum);
	wxASSERT(nodeSPTemp != NULL);
	CSourcePhrase* pFirstSrcPhrase = (CSourcePhrase*)nodeSPTemp->GetData();
	nodeSPTemp = nodeSPTemp->GetNext();// needed for SPList
	wxASSERT(pFirstSrcPhrase != NULL);
	wxASSERT(pFirstSrcPhrase->m_nSrcWords == 1 ||
							pFirstSrcPhrase->m_nSrcWords == 0); // no phrases allowed
	wxASSERT(nodeSPTemp != NULL);

	// ensure a correct active sequ num when done
	pApp->m_nActiveSequNum = nSaveSequNum;

    // starting from the next minimal srcPhrase, Merge each succeeding one to
    // pFirstSrcPhrase (whether LTR or RTL layout, we always merge in logical order (ie.
    // order of ascending sequence numbers), and unmerge likewise, it is only the relative
    // order of the words in the text strings which are compiled which reverses for RTL)
    //
	// BEW added 22May09. The new RecalcLayout() code for the keep_piles_keep_strips
	// option relies, in the AdjustForUserEdits() function, on m_pActivePile pointing at a
	// valid CPile instance; for a forwards selection, mergers are done to the active
	// pile, and so m_pActivePile remains in existence; but for a leftwards selection, the
	// mergers are done to an earlier pile than the one which was the active one, and then
	// the merged CSourcePhrase instances are deleted - thereby making m_pActivePile point
	// at freed memory. In the old way of doing the layout, this didn't matter because the
	// piles were all recreated and m_pActivePile reset; but now that we retain piles and
	// just tweak certain of the strips in the changed area of the document, we have to
	// restore m_pActivePile before we call RecalcLayout() later below. It would be
	// sufficient to set it to any valid pile near the active one, but we can do better
	// than this hear, and set it to pFirstSrcPhrase after the merging loop below has
	// finished, and then all will be well as that will be the new active pile anyway
	int i;
	for (i = 1; i < nCount; i++)
	{
		CSourcePhrase* pSrcPhrase = (CSourcePhrase*)nodeSPTemp->GetData();
		nodeSPTemp = nodeSPTemp->GetNext(); // needed for SPList
		wxASSERT(pSrcPhrase != NULL);
		wxASSERT(pSrcPhrase->m_nSrcWords == 1 ||
								pSrcPhrase->m_nSrcWords == 0); // no phrases allowed

		pFirstSrcPhrase->Merge(this, pSrcPhrase); // Merge() is updated for doc version 5

		// compose a default adaptation string, as best we can
		if (strOldAdaptation.IsEmpty())
		{
#if defined (ABANDON_NOT)
			pApp->m_pTargetBox->m_bAbandonable = FALSE;
#else
			pApp->m_pTargetBox->m_bAbandonable = TRUE;
#endif
		}
	} // end of for loop which merges all the non-first to the first in the selection

	// BEW added 22May09 -- see comment above the merge loop just above; here we must
	// re-establish the m_pActivePile pointer, in case we did a leftwards merge
	SPList::Node* aPosition = pSrcPhrases->Item(nSaveSequNum);
	CSourcePhrase* aSrcPhrasePtr = aPosition->GetData();
	wxASSERT(aSrcPhrasePtr);
	int itsSequNumber = aSrcPhrasePtr->m_nSequNumber;
	pApp->m_pActivePile = GetPile(itsSequNumber);
	wxASSERT(pApp->m_pActivePile);

	// Because later below we call DeletePartnerPile() on each of the non-first
	// CSourcePhrase instances of the selection which have now been merged, and
	// DeletePartnerPile() calls CLayout::DestroyPile() - freeing the memory for those
	// ones, we can't call RemoveSelection() after that, because the latter assumes the
	// cell pointers are still valid and they aren't. So here we just set the source text
	// line's first CCell of the selection to have m_bSelected set to FALSE, and Clear()
	// the m_selection list, and appropriately set the other selection parameters to
	// indicate there is no longer any selection.
	{
		int nFirstSequNum = pFirstSrcPhrase->m_nSequNumber;
		CPile* pFirstPile = GetPile(nFirstSequNum);
		CCell* pFirstSrcCell = pFirstPile->GetCell(0);
		pFirstSrcCell->SetSelected(FALSE);
		if (!pApp->m_selection.IsEmpty())
		{
			pApp->m_selection.Clear();
		}
		pApp->m_selectionLine = -1;
		pApp->m_pAnchor = (CCell*)NULL;
		// and globals too
		gnSelectionLine = -1;
		gnSelectionStartSequNum = -1;
		gnSelectionEndSequNum = -1;
	}

    // put our default string into pApp->m_targetPhrase to be shown in the phrase box,
    // provided we have not temporarily suppressed the default adaptation using the global
    // flag...

    // BEW added 05Oct06; here we supply a code block to implement a protocol for deriving
    // text for the phrase box when the selection has been made leftwards, so the active
    // location is at the end of the selection; and we have two scenarios- the box contents
    // are all selected (we'll assume that is due to a copy of source text and therefore
    // use m_bAbandonable == TRUE to detect it; if the selection has been made manually
    // then too bad, the user will have to do a little editing to removed the unwanted word
    // which will have been accepted when it was intended to have been removed by what the
    // user typed); or the active location will not have a selection (use m_bAbandonable ==
    // FALSE) and so we assume that the box's text is to be retained and accumulated with
    // the rest which was accumulated earlier
	if (pApp->m_curDirection == toleft)
	{
		// implementing a protocol for leftwards selections...

		// get the number of characters in the phrasebox's text, and determine how far from
		// the end is the cursor
		wxString strBox = _T("");
		strBox = pApp->m_pTargetBox->GetTextCtrl()->GetValue(); // whm 12Jul2018 added GetTextCtrl()-> part
		int strBoxLen = strBox.Length();
		long nStart;
		long nEnd;
		pApp->m_pTargetBox->GetTextCtrl()->GetSelection(&nStart, &nEnd);

		if (pApp->m_pTargetBox->m_bAbandonable)
		{
			// user won't have typed anything, so the box text should have been selected when
			// the merge was initiated
			if (nStart == 1 && nEnd == 1 && strBoxLen == 1)
			{
				// the contents were selected and what the user typed replaced them
				pApp->m_targetPhrase = strBox;
				// make RemakePhraseBox() position the cursor after the character which
				// the user typed to replace the selection
				pApp->m_nStartChar = 1;
				pApp->m_nEndChar = 1;
			}
			else
			{
                // anything else, we'll retain the box contents and accumulate it at the
                // end of strOldAdaptation, and try get the cursor where the user left it
				pApp->m_targetPhrase = strOldAdaptation;
				pApp->m_targetPhrase.Trim(FALSE); // trim left end
				pApp->m_targetPhrase.Trim(TRUE); // trim right end
				int itsLen = pApp->m_targetPhrase.Length();
				int nFromEnd = strBoxLen - nEnd;
				pApp->m_nStartChar = itsLen - nFromEnd;
				pApp->m_nEndChar = itsLen - nFromEnd;
			}
		}
		else
		{
			// retain the box contents and accumulate it at the end of
			// strOldAdaptation, and try get the cursor where the user left it
			pApp->m_targetPhrase = strOldAdaptation;
			pApp->m_targetPhrase.Trim(FALSE); // trim left end
			pApp->m_targetPhrase.Trim(TRUE); // trim right end
			int itsLen = pApp->m_targetPhrase.Length();
			int nFromEnd = strBoxLen - nEnd;
			pApp->m_nStartChar = itsLen - nFromEnd;
			pApp->m_nEndChar = itsLen - nFromEnd;
		}
	}
	else
	{
		// legacy behaviour, that is, typically forward selection. Nothing changed here.
		if (!pApp->m_bSuppressDefaultAdaptation)
		{
			if (strOldAdaptation.IsEmpty())
			{
				// BEW 13Nov10 removed strAdapt support
				;//pApp->m_targetPhrase = strAdapt;
			}
			else
			{
				pApp->m_targetPhrase = strOldAdaptation;
			}
		}
	}

	// count how many have to be removed from the m_pSourcePhrases list on the app
	int nRemoveCount = nCount - 1; // that is, all but the first

	// BEW added 09Sep08 in support of vertical editing
	if (gbVerticalEditInProgress && gEditStep == adaptationsStep)
	{
		gEditRecord.nAdaptationStep_EndingSequNum -= nRemoveCount;
		gEditRecord.nAdaptationStep_ExtrasFromUserEdits -= nRemoveCount; // LHS can become -ve legally
		gEditRecord.nAdaptationStep_NewSpanCount -= nRemoveCount;
	}

	/*
	// a block for debugging, to check adaptation span boundaries after the merge
	if (gbVerticalEditInProgress)
	{
		int nStartSN = gEditRecord.nAdaptationStep_StartingSequNum;
		int nEndSN = gEditRecord.nAdaptationStep_EndingSequNum;
		int nExtrasFromEdits = gEditRecord.nAdaptationStep_ExtrasFromUserEdits;
		int nNewSpanCnt = gEditRecord.nAdaptationStep_NewSpanCount;
	}
	*/
	// check all is well (Debug version only)
	wxASSERT(pApp->m_nActiveSequNum == pFirstSrcPhrase->m_nSequNumber);

    // whm 13Mar2020 added the following line to reset the Layout's m_curBoxWidth
    // to see if this would help solve Roland's observation that pile widths were
    // not keeping good separation and allowing piles to encroach on others after
    // a merger.
    //pLayout->m_curBoxWidth = pApp->m_nMinPileWidth; // reset small for new location

	// next line added for refactored layout support 25Mar09...
	// puts the affected strip's index in CLayout::m_invalidStripArray and sets the
	// strip's m_bValid boolean to FALSE
	pDoc->ResetPartnerPileWidth(pFirstSrcPhrase);

	// remove from the list the ones which have been merged to the first
	nodeSPTemp = pSrcPhrases->Item(pApp->m_nActiveSequNum + 1); // position of first
																// to be removed
	SPList::Node* savePos; // used below
	wxASSERT(nodeSPTemp != NULL);
	int j = 0;
	while (nodeSPTemp != NULL && j < nRemoveCount)
	{
		savePos = nodeSPTemp;
		CSourcePhrase* pSrcPhrase;
		pSrcPhrase = (CSourcePhrase*)nodeSPTemp->GetData();

		// next line added for refactored layout support 25Mar09
		pDoc->DeletePartnerPile(pSrcPhrase);

		nodeSPTemp = nodeSPTemp->GetNext();
		pSrcPhrases->DeleteNode(savePos); // remove pointer, but leave srcPhrase
		j++;							  // on the heap, because it is pointed at
	}									  // from within pFirstSrcPhrase now

	// update the sequence numbers which follow the active sequ num
	// BEW 22May09 moved this call to precede the recalculation of the layout, because it
	// is safer to have all the m_nSequNumber members of the elements in m_pSourcePhrases
	// list set correctly sequential before code in any other part of the app is called,
	// particularly the view layout code
	UpdateSequNumbers(pApp->m_nActiveSequNum);

	// recalculate the layout
#ifdef _NEW_LAYOUT
	pLayout->RecalcLayout(pSrcPhrases, keep_strips_keep_piles);
#else
	pLayout->RecalcLayout(pSrcPhrases, create_strips_keep_piles);
#endif

	// get a new (valid) active pile pointer, now that the layout is recalculated
	pApp->m_pActivePile = GetPile(pApp->m_nActiveSequNum);
	wxASSERT(pApp->m_pActivePile != NULL);

    // we don't want the code after the MergeWords( ) call (which calls OnButtonMerge()) to
    // remove the phrase box's translation if the contents of the box hold more than just
    // the last single character which the user typed, provided that the selections beyond
    // the active location don't have any translation - if they do then we would instead
    // interpret the single keypress as an attempt to replace the earlier stuff. We get
    // what we want by setting pApp->m_pTargetBox->m_bRetainBoxContents to TRUE since 
    // OnChar( ) will test the value on return from MergeWords( ). Two local flags are 
    // needed to get this to happen at just the right times.
	int newLen = pApp->m_targetPhrase.Length();
	if (newLen > 1 && !bNoninitialSelectionsHaveTranslation)
	{
		pApp->m_pTargetBox->m_bRetainBoxContents = TRUE;
	}
	// set up the m_inform attribute, if there are medial markers
	if (pFirstSrcPhrase->m_bHasInternalMarkers)
	{
		wxString s = _(" Medial markers: "); // BEW changed 16Feb10 to make this localizable
		if (!pFirstSrcPhrase->m_pMedialMarkers->IsEmpty())
		{
			// m_pMedialMarkers is a wxArrayString so let iterate
			// through it with a for loop
			for (int i = 0; i < (int)pFirstSrcPhrase->m_pMedialMarkers->GetCount(); i++)
			{
				s += pFirstSrcPhrase->m_pMedialMarkers->Item(i);
			}
			// whm 27Jan2024 modified. The medial markers may contain a \n or \r character separating
			// parts of the medial markers. That is OK, but for what we want to put into the m_inform
			// member, we don't want any \n or \r chars in it, otherwise the part of any nav text 
			// "Medial markers: ..." that contains a \n or \r char gets displayed on a second or third
			// nav text line which then gets overwritten by, or overwrites, the source text line below it.
			// Therefore, I'm using a wxString::Replace() function to replace any \n or \r chars with
			// spaces - and removes any double spaces for the s string below that is added to the 
			// m_inform member.
			s.Replace(_T("\n"), _T(" ")); // replace any \n with a space
			s.Replace(_T("\r"), _T(" ")); // replace any \r with a space
			s.Replace(_T("  "), _T(" ")); // replace any (resulting) double spaces with single space
			pFirstSrcPhrase->m_inform += s;
		}
	}
	Invalidate();
	GetLayout()->PlaceBox();
	pApp->GetMainFrame()->SendSizeEvent(); // whm 29May2024 added to reduce incidence of overlapping piles after merger
	pApp->m_bMergeSucceeded = TRUE;
	pApp->m_bMergerIsCurrent = FALSE;

//#if defined(FWD_SLASH_DELIM)
	// BEW 23Apr15, on pFirstSrcPhrase change both src and both tgt strings to have no /
	// but ZWSP instead, if m_bFwdSlashDelimiter is TRUE and / is in the merged strings
	// so that user won't see the forward slashes in the layout (see helpers.cpp for def'n)
	pFirstSrcPhrase->m_srcPhrase = FwdSlashtoZWSP(pFirstSrcPhrase->m_srcPhrase);
	pFirstSrcPhrase->m_key = FwdSlashtoZWSP(pFirstSrcPhrase->m_key);
	pFirstSrcPhrase->m_adaption = FwdSlashtoZWSP(pFirstSrcPhrase->m_adaption);
	pFirstSrcPhrase->m_targetStr = FwdSlashtoZWSP(pFirstSrcPhrase->m_targetStr);
//#endif
//#define MP_MM_BUG
#ifdef MP_MM_BUG
#ifdef _DEBUG
	// In collaboration mode, mergers are getting 3 empty <MP mp=""/> added to xml for the
	// CSourcePhrase and also 6 empty <MM mm=""/> added too. No idea why. Every extra word
	// merged adds an extra 3 & 6 as above, so seems like a merger bug. This block of code
	// will scan for m_pMedialPuncts and m_pMedialMarkers wxArrayString members with
	// m_count greater than zero, and list them, their sequ number, source text, etc in
	// the hope of getting a handle on when & where these bogus empty strings get added in
	{
		SPList* pSrcPhrases = pApp->m_pSourcePhrases;
		//int count = pSrcPhrases->GetCount();
		SPList::Node* pos_pSP = pSrcPhrases->GetFirst();
		int mpCount = 0;
		int mmCount = 0;
		wxString mpStr; // in case we get a legitimate one
		wxString mmStr; // ditto
		CSourcePhrase* pSrcPhrase = NULL;

		wxLogDebug(_T("\n ********************* Merger *************************"));
		int thisSequNum = pApp->m_pActivePile->GetSrcPhrase()->m_nSequNumber;
		wxString thisSrcPhrase = pApp->m_pActivePile->GetSrcPhrase()->m_srcPhrase;
		wxLogDebug(_T("THIS sequNum = %d ;  THIS srcPhrase = %s"),thisSequNum,thisSrcPhrase.c_str());
		// now scan over the whole doc, show where the bogus MP and MM ones are
		while (pos_pSP != NULL)
		{
			bool bGotPuncts = FALSE;
			bool bGotMarkers = FALSE;
			pSrcPhrase = pos_pSP->GetData();
			pos_pSP = pos_pSP->GetNext();
			int sequNum = pSrcPhrase->m_nSequNumber;
			wxString srctext = pSrcPhrase->m_srcPhrase;
			if (!pSrcPhrase->m_pMedialPuncts->IsEmpty())
			{
				bGotPuncts = TRUE;
				mpStr = pSrcPhrase->m_pMedialPuncts->Item(0); // just want first
				mpCount = pSrcPhrase->m_pMedialPuncts->GetCount(); // count how many
			}
			if (!pSrcPhrase->m_pMedialMarkers->IsEmpty())
			{
				bGotMarkers = TRUE;
				mmStr = pSrcPhrase->m_pMedialMarkers->Item(0); // just want first
				mmCount = pSrcPhrase->m_pMedialMarkers->GetCount(); // count how many
			}
			if (bGotPuncts || bGotMarkers)
			{
				wxLogDebug(_T("sn = %d ; srcPhrase = %s ; MP count = %d , MP text = %s ; MM count = %d , MM text = %s"),
					sequNum, srctext.c_str(), mpCount, mpStr.c_str(), mmCount, mmStr.c_str());
			}
		}
		wxLogDebug(_T("    -------------------------------------------------"));
	}
#endif
#endif
}

void CAdapt_ItView::UpdateSequNumbers(int nFirstSequNum)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	SPList* pList = pApp->m_pSourcePhrases;

	// get the first
	SPList::Node* pos_pList = NULL;
	if (nFirstSequNum == 0)
	{
		// don't do a Find to get the first one, in case numbers are not
		// currently up to date at the beginning
		pos_pList = pList->GetFirst();
	}
	else
	{
		// for non-zero values, trust a Find will succeed - this is a potential
		// source of error, but since we almost always pass in zero, and we
		// try to keep numbers correct anyway, the risk is pretty small
		pos_pList = pList->Item(nFirstSequNum);
	}
	wxASSERT(pos_pList != NULL);
	CSourcePhrase* pSrcPhrase = (CSourcePhrase*)pos_pList->GetData();
	pos_pList = pos_pList->GetNext(); // needed for SPList
	wxASSERT(pSrcPhrase != NULL);
	pSrcPhrase->m_nSequNumber = nFirstSequNum;
	int index = nFirstSequNum;

	while (pos_pList != 0)
	{
		pSrcPhrase = (CSourcePhrase*)pos_pList->GetData();
		pos_pList = pos_pList->GetNext();
		wxASSERT(pSrcPhrase != NULL);
		index++; // next sequence number
		pSrcPhrase->m_nSequNumber = index;
	}
}

// BEW 16Feb10, updated RestoreOriginalMinPhrases for doc version 5
// BEW 17Jul11, changed for GetRefString() to return KB_Entry enum, (and use all 10 maps
// for glossing KB - but that is irrelevant to this function)
// BEW refactored 21Jul14, for ZWSP support ( two calls needed, to PutSrcWordBreak(), and
// two additional lines for transfer of m_srcWordBreak and m_tgtWordBreak )
// 
// whm 27Jan2024 modified the RestoreOriginalMinPhrases() below to move the 4 types
// of filtered info (regular, notes, freetrans, backtrans) from the pBigOne to the
// LAST min phrase that gets restored to the doc list. This change is due to the
// fact that filtered information is now stored on the PREVIOUS source phrase in 
// the doc list, rather than on the FOLLOWING source phrase in the doc list as was
// done previously before this refactoring. And, when we un-merge/restore a merged
// source phrase that contains filtered material, that material needs to be moved
// from the pBigOne to the LAST word of the restored min phrases, when the pBig
// one is deleted from pList. Only one line in the function needed changing:
// pos_pSaved was previously set to pSaved->GetFirst(), and was changed to become
// pos_pSaved = pSaved->GetLast().
int CAdapt_ItView::RestoreOriginalMinPhrases(CSourcePhrase *pSrcPhrase, int nStartingSequNum)
{
	// The following note is copied from Layout.cpp... it is very important
	// NOTE: in the event of an Unmerge operation, the active pile was the one that
	// got unmerged (and hence destroyed and its memory freed) - which; the
	// RestoreOriginalMinPhrases() function inserts the old CSourcePhrase instances
	// back into the app's m_pSourcePhrases list, and creates partner piles for these
	// with CAdapt_ItDoc::CreatePartnerPile() calls. The latter does not know about
	// what strip it will end up in, nor what position in that strip, because when
	// these creations are done the old strips are current (we could have a guess and
	// probably set the strip pointer correctly if the old strips exist, but not reliably
    // set the index within the strip's m_arrPiles array, and sometimes pile creation
    // is done when all strips are destroyed for a full layout rebuild, so there is not
    // much point in trying) - so we only go as far as having RestoreOriginalMinPhrases()
    // point the CAdapt_It::m_pActivePile at the partner pile for the first of the
	// created original minimum CSourcePhrase instances we've replaced in the list -
	// knowing full well that its m_pOwningStrip value will be NULL, and its m_nPile
	// value will be -1. That means that until the strips are updated, those members
	// will have those values, which means any function which depends on them before
	// RecalcLayout() has finished must know what to do if such a pile is the active
	// one - for instance, calling CPile::GetStripIndex() will return the invalid
	// index -1, and any attempt to Draw() such a pile would fail because m_nPile is
	// accessed in order to find its location in a strip in order to work out its
	// drawing rectangle, and garbage would be being accessed.

	// According to the above note, we must (in the refactored layout code) ensure that
	// deleting the pBigOne (merged) pile, which will also be the active pile, does not
	// result in the function exiting with m_pActivePile set to freed memory, so we add
	// code to reset the active pile to the first of the partner CPile pointers created
	// below; this is done at the end, and the passed in nStartingSequNum is the active
	// sequence number we use for resetting m_pActivePile

	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	int nCount = pSrcPhrase->m_nSrcWords;
	SPList* pList = pApp->m_pSourcePhrases;
	SPList::Node* pos_pList = pList->Item(nStartingSequNum);
	wxASSERT(pos_pList != NULL);
	SPList::Node* savePos = pos_pList; // used later below
	CSourcePhrase* pBigOne = (CSourcePhrase*)pos_pList->GetData();
	wxASSERT(pBigOne != NULL);

    // BEW added 01Aug05 for free translation support; the merged source phrase may be part
    // of a free translation, but it's original saved sourcephrase pointers may not have
    // any free translation defined on them (because the user did the free translating
    // after the merge was done); or alternatively, there may have been a free translation
    // defined on the original sourcephrase instances in the merger (because the user
    // merged after doing the free translating -- and if the latter is the case then the
    // first of the original sourcephrases will contain a free translation -- and we can be
    // sure that no medial sourcephrase instance stores a free translation because the app
    // will not allow merging across filtered material, the filtered material can only be
    // on the first sourcephrase of the merge, or there must be no filtered material on any
    // sourcephrase in the merge -- this protocol simplifies what we must test for). If the
    // merged source phrase starts a free translation, we will make all the restored
    // original sourcephrases be within that free translation, and if it also ends the free
    // translation, then the last of the restored ones will also end the retranslation

	// in docVersion 4 & earlier, m_markers stored all filtered info, but in 5, it is
	// split between 4 string members; we'll retain the bool's name, but set or clear it
	// by updated criteria
	bool bHasNonEmptyM_Markers = FALSE;
	// any one of the following tests succeeding is enough to set the flag
	if (!pBigOne->GetFilteredInfo().IsEmpty())
	{
		bHasNonEmptyM_Markers = TRUE;
	}
	else if (!pBigOne->GetFreeTrans().IsEmpty())
	{
		bHasNonEmptyM_Markers = TRUE;
	}
	else if (!pBigOne->GetNote().IsEmpty())
	{
		bHasNonEmptyM_Markers = TRUE;
	}
	else if (!pBigOne->GetCollectedBackTrans().IsEmpty())
	{
		bHasNonEmptyM_Markers = TRUE;
	}
	bool bHasFreeTrans = pBigOne->m_bHasFreeTrans ? TRUE : FALSE; // keep this in doc version 5
					// because the m_freeTrans member may have an empty string, but the bool
					// may be TRUE
	bool bStartsAFreeTranslation = pBigOne->m_bStartFreeTrans ? TRUE : FALSE;
	bool bEndsAFreeTranslation = pBigOne->m_bEndFreeTrans ? TRUE : FALSE;

    // BEW added 27Dec07: to handle preservation of any Note's m_bHasNote == TRUE value
    // across the unmerge; since we now allow a merge if filtered info is on the first word
    // or phrase in the selection
	bool bHasNote = pBigOne->m_bHasNote ? TRUE : FALSE; // the value is used below (retain in
					// doc version 5, for same reason as for bHasFreeTrans)

	// set the first in the saved original srcPhrase objects to have sequ number as passed in
	SPList::Node* pos_pSaved;
	SPList* pSaved = pBigOne->m_pSavedWords;
	// whm 27Jan2024 modified. We need to set pos_pSaved below to pSaved->GetLast() in order for the
	// filtered info, notes, freetrans, backtrans etc to saved on the LAST min source phrase
	// according to the new refactored design. The rest of the function I think can be left
	// as is - even though I think it would be possible to do away with the creation of a
	// dummy final source phrase if the items in the m_pSavedWords list were inserted BEFORE
	// the position of the pBigOne. But, I'll not try to improve on that here, and just change
	// the pos_pSaved position to point at the last item in the sub list rather than the first item.
	pos_pSaved = pSaved->GetLast(); //pos_pSaved = pSaved->GetFirst();
	wxASSERT(pos_pSaved != NULL);
	CSourcePhrase* pSP = (CSourcePhrase*)pos_pSaved->GetData();
	wxASSERT(pSP != NULL);
	pSP->m_nSequNumber = nStartingSequNum; // this ensures we renumber correctly using
										   // UpdateSequNum()
	pSP->m_bHasKBEntry = FALSE;
	pSP->m_bRetranslation = FALSE; // otherwise, after a wrong retranslation & cancel, it is
								   // possible to have this flag wrongly still set TRUE, & text
								   // of wrong colour shows

	// handle any initial filtered material, including any free translation which is filtered
	// and any Note's flag
	if (bHasNote)
	{
		pSP->m_bHasNote = pBigOne->m_bHasNote; // transfer the Note flag's value when TRUE
		pSP->SetNote(pBigOne->GetNote()); // transfer text of the note
	}
	if (bHasNonEmptyM_Markers)
	{
		// this block needs to handle collected back trans, and m_filteredInfo, and m_markers
		if (!pBigOne->GetFilteredInfo().IsEmpty())
		{
			pSP->SetFilteredInfo(pBigOne->GetFilteredInfo());
		}
		if (!pBigOne->GetCollectedBackTrans().IsEmpty())
		{
			pSP->SetCollectedBackTrans(pBigOne->GetCollectedBackTrans());
		}
		// m_markers is not yet private, so it has no getter or setter
		pSP->m_markers = pBigOne->m_markers; // transfer the material in m_markers to the first one
	}

    // BEW 21Jul14 Probably don't need to copy over the m_srcWordBreak and m_tgtWordBreak
    // contents, since they were copied to pBigOne originally themselves. But we'll do so
    // to be safe
	pSP->SetSrcWordBreak(pBigOne->GetSrcWordBreak());
	pSP->SetTgtWordBreak(pBigOne->GetTgtWordBreak());

	// handle the flag for commencement of a free translation section
	if (bStartsAFreeTranslation)
	{
		pSP->m_bStartFreeTrans = TRUE;
		// and since it starts here, transfer it's string as well
		pSP->SetFreeTrans(pBigOne->GetFreeTrans());
	}
	else
	{
		// only clear the flag, the free translation itself is stored on an instance
		// preceding the selected span of CSourcePhrase instances
		pSP->m_bStartFreeTrans = FALSE;
	}
	// insert, starting from tail, after the pBigOne,
	// thereby preserving original element order
	pos_pSaved = pSaved->GetLast();
	// now pos_pSaved points at the last item of pBigOne's pSaved list
	wxASSERT(pos_pSaved != NULL);
	bool bIsLast = TRUE;

    // wx Note: Get a node called newInsertBeforePos which points to the next node beyond
    // savePos in pList and use its position in the Insert() call (which only inserts
    // BEFORE the indicated position). The result should be that the insertions will get
    // placed in the list the same way that MFC's InsertAfter() places them.
	// BEW added 25Oct09: the above logic gives a crash if unmerging a merger at the
	// document's end. Therefore we need to test for this condition and when it occurs
	// we must insert a dummy CSourcePhrase pointer at the doc end so as to use it for
	// the initial "insert before" operation
	bool bDummyAdded = FALSE;
	SPList::Node* newInsertBeforePos = savePos->GetNext();
	if (newInsertBeforePos == NULL)
	{
		bDummyAdded = TRUE;
		CSourcePhrase* pDummySrcPhrase = new CSourcePhrase();
		newInsertBeforePos = pList->Append(pDummySrcPhrase);
		wxASSERT(newInsertBeforePos != NULL);
	}
	while (pos_pSaved != NULL)
	{
		CSourcePhrase* pSP = (CSourcePhrase*)pos_pSaved->GetData();
		pos_pSaved = pos_pSaved->GetPrevious();
		pSP->m_bHasKBEntry = FALSE;

		// wxList has no equivalent to InsertAfter(). The wxList Insert() method
		// inserts the new node BEFORE the current position/node. To emulate what
		// the MFC code does, we insert before using newInsertBeforePos.
		// wx note: If newInsertBeforePos is NULL, it means the insert position is
		// at the end of the list; in this case we just append the item to the end
		// of the list.
		if (newInsertBeforePos == NULL)
			pList->Append(pSP);
		else
			pList->Insert(newInsertBeforePos,pSP);

		// BEW added 13Mar09 for refactored layout
		GetDocument()->CreatePartnerPile(pSP);

		// since we must now insert before the inserted node above, we need to get a
		// previous node (which will actually be the just inserted source phrase)
		newInsertBeforePos = newInsertBeforePos->GetPrevious();

        // handle any free translation booleans needing to be set; a free translation is
        // either to be defined on all the original instances, or it is defined for none -
        // and if the merger was also the end of a free translation, then the end of the
        // originals must have the m_bEndFreeTrans flag set too
		if (bHasFreeTrans)
			pSP->m_bHasFreeTrans = TRUE;
		else
			pSP->m_bHasFreeTrans = FALSE;
		if (bIsLast)
		{
			if (bEndsAFreeTranslation)
				pSP->m_bEndFreeTrans = TRUE;
			else
				pSP->m_bEndFreeTrans = FALSE;
			bIsLast = FALSE; // prevent subsequent access to this block
		}

        // prior to version 2.0, unmerging cleared the m_adaption and m_targetStr members
        // on the restored original minimal sourcephrases. This is too severe a behaviour,
        // there is no good reason why any original adaptations can't remain in place and
        // their entries restored to the KB (if non-null), so this is what I will do here
        // now.
		if (!pSP->m_adaption.IsEmpty())
		{
			// restore its KB entry, and don't inhibit the call of MakeTargetStringincludingPunctuation()
			// BEW 31May24 changed to doing the inhibit, otherwise a merger's long tgt text gets being repeated
			bool bOK;
			pApp->m_bInhibitMakeTargetStringCall = TRUE;
			bOK = pApp->m_pKB->StoreText(pSP,pSP->m_adaption);
			bOK = bOK; // avoid waring
			pApp->m_bInhibitMakeTargetStringCall = FALSE;
		}

		if (pApp->m_pKB->IsItNotInKB(pSP))
			pSP->m_bNotInKB = TRUE;
		else
			pSP->m_bNotInKB = FALSE;
		pSP->m_bRetranslation = FALSE; // otherwise, after a wrong retranslation & cancel, it is
									   // possible to have this flag wrongly still set TRUE, &
									   // text of wrong colour shows
	}
	// BEW added 25Oct09, remove the dummy CSOurcePhrase appended at the list end for
	// supporting insertions, if we appended one above
	if (bDummyAdded)
	{
		SPList::Node* extraPos = pList->GetLast();
		wxASSERT(extraPos != NULL);
		CSourcePhrase* pDummySrcPhrase = extraPos->GetData();
		if (pDummySrcPhrase != NULL) // whm 11Jun12 added NULL test
			delete pDummySrcPhrase;
		pList->DeleteNode(extraPos);
	}

    // pBigOne will not be needed any longer, and its KB stuff must be removed or reference
    // decremented; append any refString's m_translation to the pApp->m_targetPhrase, so
    // user can edit or delete the resulting composite string when the phraseBox is
    // eventually put up (note, next call, pRefString may point to <Not In KB>)
    KB_Entry rsEntry;
	CRefString* pRefString = NULL;
	rsEntry = pApp->m_pKB->GetRefString(pBigOne->m_nSrcWords, pBigOne->m_key,
										pBigOne->m_adaption, pRefString);
	pList->DeleteNode(savePos);
	if (pBigOne->m_bHasKBEntry && rsEntry == really_present)
	{
		pApp->m_pKB->RemoveRefString(pRefString, pBigOne, pBigOne->m_nSrcWords);
		pBigOne->m_bHasKBEntry = FALSE;

		// set up pApp->m_targetPhrase using pBigOne's m_targetStr attribute
		if (pApp->m_targetPhrase.IsEmpty())
			pApp->m_targetPhrase = pBigOne->m_targetStr;
		else
			pApp->m_targetPhrase = pApp->m_targetPhrase + PutSrcWordBreak(pBigOne) + pBigOne->m_targetStr;
	}
	else // might be a deleted KB entry
	{
        // might have had save to KB suppression turned on, so check this case out too - if
        // the m_bNotInKB flag is set, we don't need to remove anything from the KB, but we
        // do need to set pApp->m_targetPhrase using the m_targetStr string's value
		if (pBigOne->m_bNotInKB)
		{
			if (pApp->m_targetPhrase.IsEmpty())
			{
				pApp->m_targetPhrase = pBigOne->m_targetStr;
			}
			else
			{
				if (!pBigOne->m_targetStr.IsEmpty())
					pApp->m_targetPhrase = pApp->m_targetPhrase + PutSrcWordBreak(pBigOne) + pBigOne->m_targetStr;
			}
		}
	}

	if (pBigOne->m_pMedialMarkers->GetCount() > 0)
	{
		pBigOne->m_pMedialMarkers->Clear();
	}
	if (pBigOne->m_pMedialMarkers != NULL) // whm 11Jun12 added NULL test
		delete pBigOne->m_pMedialMarkers;
	pBigOne->m_pMedialMarkers = (wxArrayString*)NULL;
	if (pBigOne->m_pMedialPuncts->GetCount() > 0)
	{
		pBigOne->m_pMedialPuncts->Clear();
	}
	if (pBigOne->m_pMedialPuncts != NULL) // whm 11Jun12 added NULL test
		delete pBigOne->m_pMedialPuncts;
	pBigOne->m_pMedialPuncts = (wxArrayString*)NULL;
	if (pBigOne->m_pSavedWords->GetCount() > 0)
	{
		// only remove pointers, never delete the memory they point to, because
		// any copies of this source phrase will only have copied pointers in the sublist
		pBigOne->m_pSavedWords->Clear();
	}
	if (pBigOne->m_pSavedWords != NULL) // whm 11Jun12 added NULL test
		delete pBigOne->m_pSavedWords;
	pBigOne->m_pSavedWords = (SPList*)NULL;

	// BEW added 13Mar09 for refactor of layout; delete its partner pile too
	GetDocument()->DeletePartnerPile(pBigOne);

	if (pBigOne != NULL) // whm 11Jun12 added NULL test
		delete pBigOne;
	pBigOne = (CSourcePhrase*)NULL;

	// update the sequence numbers for elements subsequent to the first
	UpdateSequNumbers(nStartingSequNum);

    // BEW added 20May09, in the refactored layout, restoring original CSourcePhrase
    // instances requires CPile partners be created and inserted into equivalent positions
    // in the m_pileList list as for their CSourcePhrase partners in m_pSourcePhrases list,
    // but the newly created piles won't have their m_pOwningStrip member set (it will be
    // NULL) nor their m_nPile member set to a valid index, but to -1. Deleting the passed
    // in original CSourcePhrase (it was at the active location) results in m_pActivePile
    // which formerly pointed at its partner pile, and which also got freed, not pointing
    // at a valid CPile pointer in memory; so m_pActivePile has to be re-established here
    // before returning (in the legacy layout, m_pActivePile got reset after the layout was
    // rebuilt, but in our refactored approach, piles are persistent and so we have to
    // reestablish the active pile pointer before RecalcLayout() is called, because code in
    // the latter uses it)
	pApp->m_pActivePile = GetPile(nStartingSequNum);

	return nCount;
}

/////////////////////////////////////////////////////////////////////////////////
/// \return		nothing
/// \param      event   -> the wxUpdateUIEvent that is generated by the app's Idle handler
/// \remarks
/// Called from: The wxUpdateUIEvent mechanism whenever idle processing is enabled.
/// If the application is in glossing mode, or it is showing only the target text, or the
/// m_pActivePile pointer is NULL, or the active pile's m_pSrcPhrase is NULL, this handler
/// disables the "Unmake A Phrase" toolbar item and returns immediately.
/// If the App's m_selectionLine is not -1, and the App's m_selection list has exactly one
/// item in its list associated with a previous merger, or alternatively, if the App's
/// m_selectioniLine is -1, and the first item in in the active pile's m_selection is
/// associated with a previous merger, it enables the toolbar button, otherwise it disables
/// the toolbar button.
/////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItView::OnUpdateButtonRestore(wxUpdateUIEvent& event)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);

	// whm added 26Mar12. Disable tool bar button when in read-only mode.
	if (pApp->m_bReadOnlyAccess)
	{
		event.Enable(FALSE);
		return;
	}

	if (gbIsGlossing || gbShowTargetOnly)
	{
		event.Enable(FALSE);
		return;
	}
	if (pApp->m_pActivePile == NULL || pApp->m_pActivePile->GetSrcPhrase() == NULL)
	{
		event.Enable(FALSE);
		return;
	}
	// Protect against idle time update menu handler at app shutdown time, when
	// piles no longer exist
	if (pApp->GetLayout()->GetPileList() == NULL ||
		pApp->GetLayout()->GetPileList()->IsEmpty())
	{
		event.Enable(FALSE);
		return;
	}
	if (pApp->m_selectionLine != -1 && pApp->m_selection.GetCount() == 1)
	{
		CCellList::Node* cpos = pApp->m_selection.GetFirst();
		CCell* pCell = cpos->GetData();
		CSourcePhrase* pSP = pCell->GetPile()->GetSrcPhrase();
		if (pSP->m_nSrcWords > 1)
			event.Enable(TRUE);
		else
			event.Enable(FALSE);
	}
	else if (pApp->m_selectionLine == -1 && pApp->m_pTargetBox != NULL
										&& pApp->m_pTargetBox->IsShown())
	{
		CSourcePhrase* pSP = pApp->m_pActivePile->GetSrcPhrase();
		if (pSP->m_nSrcWords > 1)
			event.Enable(TRUE);
		else
			event.Enable(FALSE);
	}
	else
	{
		event.Enable(FALSE);
	}
}

// BEW 26Mar10, no changes needed for support of doc version 5
void CAdapt_ItView::UnmergePhrase()
{
	wxCommandEvent dummyevent;
	OnButtonRestore(dummyevent); // since is protected, &
			// we want to call it from OnChar() in CPhraseBox class
}

// removes a merged phrase by restoring it to a sequence of the original CSourcePhrase
// instances which were stored on the merged phrase at the time of merger
// BEW changed 27Dec07: unmerging when there was a note stored on the merger did not retain
// the m_bHasNote flag value by setting it on the first CSourcePhrase instance in the
// unmerged sequence, so I fixed it so it would do so
//
// BEW updated OnButtonRestore() 16Feb10 for support of doc version 5 (nothing needed to be
// done) 
// BEW 21Jul14, no changes for ZWSP support
// whm Note 10Jan2018. Happily, after a restore (un-merge) operation done by this handler
// has been done and the phrasebox is placed at a point where there are multiple translations
// available from the KB, the LookupSrcWord() and PlaceBox() calls near the end of this 
// function also will trigger the placement of the dropdown list. No futher modifications
// are necessary to get this behavior.
//
// whm 27Jan2024 Modified. When a merger holds filtered information, and the top level source
// phrase at the merger is unmerged/restored, the filtered information needs to be moved from
// the top level source phrase's m_filteredInfo member to the LAST source phrase of the lower
// (original) level words being restored. Since we now store fltered information on a 
// "previous" source phrase, it could be stored on one which is the top level source phrase of 
// a merger, and when that top level source phrase is removed and replaced by its lower level 
// original words it is the last lower level word's source phrase where the filtered 
// information needs to be moved to.
void CAdapt_ItView::OnButtonRestore(wxCommandEvent& WXUNUSED(event))
{
    // Since the Restore (Unmerge) toolbar button has an accelerator table hot key (CTRL-U
    // see CMainFrame) and wxWidgets accelerator keys call menu and toolbar handlers even
    // when they are disabled, we must check for a disabled button and return if disabled.
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	CMainFrame* pFrame = pApp->GetMainFrame();
	wxASSERT(pFrame != NULL);
	wxAuiToolBarItem *tbi;
	tbi = pFrame->m_auiToolbar->FindTool(ID_BUTTON_RESTORE);
	// Return if the toolbar item is hidden
	if (tbi == NULL)
	{
		return;
	}
	// Return if this toolbar item is disabled
	if (!pFrame->m_auiToolbar->GetToolEnabled(ID_BUTTON_RESTORE))
	{
		::wxBell();
		return;
	}

    // In glossing mode (ie. actually glossing) I think I've managed to silently prevent
    // any unmerge from happening before OnButtonRestore( ) can get invoked. However, it
    // the user were to explicitly click the button, there is no recourse except to tell
    // him that the removing a merger is not available when doing glossing
	if (gbIsGlossing)
	{
		// IDS_NOT_WHEN_GLOSSING
        // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
        pApp->m_bUserDlgOrMessageRequested = TRUE;
        wxMessageBox(_(
		"This particular operation is not available when you are glossing."),
		_T(""),wxICON_INFORMATION | wxOK);
		return;
	}

	// must be adapting mode, so continue with the request
	CAdapt_ItDoc* pDoc = GetDocument();
	SPList* pSrcPhrases = pApp->m_pSourcePhrases;
	CPile* pStartingPile;
	CPile* pActivePile;
	CPile* pPile;
	CCellList::Node* pos_pCellList;
	CSourcePhrase* pSrcPhrase;
	int nCount;
	int nSaveSequNum;

    // get the single selected CSourcePhrase instance, or the location of phrasebox if no
    // selection
	if (pApp->m_selectionLine != -1)
	{
		pos_pCellList = pApp->m_selection.GetFirst();
		nCount = pApp->m_selection.GetCount();
		// BEW added 25Jun09 to make it safe if the user selects more than one word
		if (nCount > 1)
		{
			// it shouldn't be possible for control to come here, because the update
			// handlers would detect a multipile selection and disable the Restore button,
			// but just in case, ensure no harm is done if somehow this function is called
			RemoveSelection();
			wxMessageBox(_(
			"To undo a merger using a selection, select only one pile."),
			_T(""),wxICON_INFORMATION | wxOK);
			return;
		}
		wxASSERT(nCount == 1); // must only be one

		CCell* pCell = (CCell*)pos_pCellList->GetData();
		pos_pCellList = pos_pCellList->GetNext();
		pPile = pCell->GetPile(); // get the pile for this selection
		pStartingPile = pPile; // need this for later when we look up the strip which
							   // first pile is in prior to calling RecalcLayout()
		pSrcPhrase = pPile->GetSrcPhrase();
		nSaveSequNum = pSrcPhrase->m_nSequNumber; // save its sequ number, everything
												  // depends on it
		// the active location may be remote from where the unmerge is done, so make sure
		// the active strip is marked invalid too
		pDoc->ResetPartnerPileWidth(pSrcPhrase); // FALSE for param
												 // bNoActiveLocationCalculation

        // there could be an edited phrase waiting for a RETURN key press, and the
        // selection may be on a different pile, in which case unless we update the active
        // pile's srcPhrase before doing the restore, the latter would be wrongly cleared
        // of its adaptation text, so we check for such a condition here & do the necessary
        // fixes before proceeding
		pActivePile = pApp->m_pActivePile;
		if (pActivePile != pStartingPile)
		{
            // the selected pile is not the active one, so update the active one then make
            // the selected one the active one; so store the translation in the knowledge
            // base
			MakeTargetStringIncludingPunctuation(pApp->m_pActivePile->GetSrcPhrase(), pApp->m_targetPhrase);
			RemovePunctuation(pDoc, &pApp->m_targetPhrase, from_target_text);
			// BEW 2Mar20 inhibiting the MakeTargetStringIncludingPunctuation() call is NOT wanted here
			bool bOK = pApp->m_pKB->StoreText(pActivePile->GetSrcPhrase(), pApp->m_targetPhrase);
			if (!bOK)
				return; // can't proceed until a valid adaption (which could be null)
                        // is supplied for the former active pile's srcPhrase
			else
			{
				// make the pile at start of former strip have a new pointer - new layout
				// code will then tweak the layout from that point on; if there is no
				// former strip, use the current one instead
				int nFormerStrip = pActivePile->GetStripIndex();
				pDoc->ResetPartnerPileWidth(pActivePile->GetSrcPhrase()); // mark the
																// active strip invalid
				pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(_T("")); // we don't want the former active
										// pile's text to be carried to the selected pile
				int nCurStripIndex = pStartingPile->GetStripIndex();
				if (nCurStripIndex != nFormerStrip)
				{
					CStrip* pFormerStrip = (CStrip*)
										GetLayout()->GetStripArray()->Item(nFormerStrip);
					CPile* pItsFirstPile = (CPile*)pFormerStrip->GetPilesArray()->Item(0);
					CSourcePhrase* pItsFirstSrcPhrase = pItsFirstPile->GetSrcPhrase();
					// also mark the former strip invalid (ensures we include all piles
					// that might require updating)
					pDoc->ResetPartnerPileWidth(pItsFirstSrcPhrase, TRUE); // TRUE is
														// bNoActiveLocationCalculation
				}
			}
		}
		RemoveSelection();
	}
	else // there is no current selection
	{
        // no selection, so just remove the merger at wherever the phraseBox currently is
        // located
		pPile = pApp->m_pActivePile;
		pStartingPile = pPile;
		pSrcPhrase = pPile->GetSrcPhrase();
		nSaveSequNum = pSrcPhrase->m_nSequNumber; // save its sequ number,
												  // everything depends on it
		pDoc->ResetPartnerPileWidth(pSrcPhrase); // FALSE for
												 // bNoActiveLocationCalculation
	}

	// make m_targetPhrase cleared, as it must accumulate any existing translations
	// removed from the KB because of the earlier merge
	pApp->m_targetPhrase.Empty();

	// determine that it is a genuine non-minimal phrase. If it is, we must
	// restore the original list of minimal phrases (ie. words), and clear the
	// translations from the KB.
	wxASSERT(pSrcPhrase->m_nSrcWords > 1);
	int nNumElements = 1;
    // RestoreOriginalMinPhrases also appends any adaptation to m_targetPhrase; it also
    // updates sequ numbers after the restore is done; it calls CreatePartnerPile() for
    // each CSourcePhrase ptr it restores to the doc list, and calls DeletePartnerPile()
    // for before deleting the merged one
	//
	// whm 27Jan2024 modified the RestoreOriginalMinPhrases() below to move the 4 types
	// of filtered info (regular, notes, freetrans, backtrans) from the pBigOne to the
	// LAST min phrase that gets restored to the doc list. This change is due to the
	// fact that filtered information is now stored on the PREVIOUS source phrase in 
	// the doc list, rather than on the FOLLOWING source phrase in the doc list as was
	// done previously before this refactoring. And, when we un-merge/restore a merged
	// source phrase that contains filtered material, that material needs to be moved
	// from the pBigOne to the LAST word of the restored min phrases, when the pBig
	// one is deleted from pList.
	nNumElements = RestoreOriginalMinPhrases(pSrcPhrase,nSaveSequNum);

    // at this point, m_targetPhrase will have the target text in it if the selection was
    // done by clicking with the mouse on the source line; but if the click was on the
    // target cell then the KB will have had the adaption text cleared (or refCount
    // reduced) and the target text will have been preserved only in the phraseBox itself;
    // so we must check for the latter case and restore the text before proceeding
	if (pApp->m_targetPhrase.IsEmpty())
		pApp->m_targetPhrase = pApp->m_pTargetBox->GetTextCtrl()->GetValue(); // whm 12Jul2018 added GetTextCtrl()-> part

	// update the bundle indices
	int nExtras = nNumElements - 1;

	// BEW added 09Sep08 in support of vertical editing
	if (gbVerticalEditInProgress && gEditStep == adaptationsStep)
	{
		gEditRecord.nAdaptationStep_EndingSequNum += nExtras;
		gEditRecord.nAdaptationStep_ExtrasFromUserEdits += nExtras; // LHS can become -ve legally
		gEditRecord.nAdaptationStep_NewSpanCount += nExtras;
	}

	// pos_pCellList is defined as CCellList node above, so we must use a different identifier here
	// since we want a SPList node
	SPList::Node* posSP;
	posSP = pSrcPhrases->Item(nSaveSequNum);
	wxASSERT(posSP != NULL);
	CSourcePhrase* pFirstSrcPhrase;
	pFirstSrcPhrase = (CSourcePhrase*)posSP->GetData();
	posSP = posSP->GetNext();
	wxASSERT(pFirstSrcPhrase != NULL);
	wxASSERT(pFirstSrcPhrase->m_nSrcWords == 1 ||
		pFirstSrcPhrase->m_nSrcWords == 0); // no phrases allowed
	wxASSERT(posSP != NULL);
	pFirstSrcPhrase = pFirstSrcPhrase; // avoid warning (nope, extra stuff for debugging)
	// ensure a correct active sequ num when done
	pApp->m_nActiveSequNum = nSaveSequNum;

	// recalculate the layout
#ifdef _NEW_LAYOUT
	GetLayout()->RecalcLayout(pSrcPhrases, keep_strips_keep_piles);
#else
	GetLayout()->RecalcLayout(pSrcPhrases, create_strips_keep_piles);
#endif

	// get a new (valid) active pile pointer, now that the layout is recalculated
	pApp->m_pActivePile = GetPile(pApp->m_nActiveSequNum);
	wxASSERT(pApp->m_pActivePile != NULL);

    // look up the single src word in the KB; if we can get a translation for it, use that,
    // if not then just retain the old merged phrase's translation
	bool bWantSelect = FALSE;
	bool bGotTranslation;
	bGotTranslation = pApp->m_pTargetBox->LookUpSrcWord(pApp->m_pActivePile);
	pApp->m_pActivePile = GetPile(pApp->m_nActiveSequNum); // restore pointer, since
										// LookUpSrcWord() now calls RecalcLayout()
	if (bGotTranslation)
	{
		// we have to check here, in case the m_Translation it found was a "<Not In KB>"
		// - in which case, we must display an empty box and ensure that the pile has an
		// asterisk above it, etc
		if (pApp->m_pTargetBox->m_Translation == _T("<Not In KB>"))
		{
			pApp->m_targetPhrase.Empty(); // phrase box must be shown empty
			pApp->m_pActivePile->GetSrcPhrase()->m_bHasKBEntry = FALSE;
			pApp->m_pActivePile->GetSrcPhrase()->m_bNotInKB = TRUE;
			pApp->m_pActivePile->GetSrcPhrase()->m_adaption.Empty();
			pApp->m_pActivePile->GetSrcPhrase()->m_targetStr.Empty();
			bWantSelect = FALSE;
		}
		else
		{
			pApp->m_targetPhrase = pApp->m_pTargetBox->m_Translation; // set using the global var,
												// set in LookUpSrcWord()
			bWantSelect = TRUE;
		}
	}
	else // no translation found
	{
		// do the copy of source instead, or nothing if Copy Source flag is not set
		if (pApp->m_bCopySource)
		{
            // copy source key only provided this is not a null source phrase, don't
            // want "..." copied!
			pApp->m_targetPhrase =
					CopySourceKey(pApp->m_pActivePile->GetSrcPhrase(),
									pApp->m_bUseConsistentChanges);
			bWantSelect = TRUE;
#if defined (ABANDON_NOT)
			pApp->m_pTargetBox->m_bAbandonable = FALSE;
#else
			pApp->m_pTargetBox->m_bAbandonable = TRUE;
#endif
		}
		else
		{
			pApp->m_targetPhrase.Empty();
			bWantSelect = FALSE;
		}
	}

	// need to recalc layout again
#ifdef _NEW_LAYOUT
	GetLayout()->RecalcLayout(pSrcPhrases, keep_strips_keep_piles);
	//GetLayout()->RecalcLayout(pSrcPhrases, create_strips_and_piles);
#else
	GetLayout()->RecalcLayout(pSrcPhrases, create_strips_keep_piles);
#endif
	pApp->m_pActivePile = GetPile(pApp->m_nActiveSequNum);
	wxASSERT(pApp->m_pActivePile != NULL);

	if (bWantSelect)
	{
		pApp->m_nStartChar = 0;
		pApp->m_nEndChar = -1;
	}
	else
	{
		int len = pApp->m_targetPhrase.Length();
		pApp->m_nStartChar = len;
		pApp->m_nEndChar = len;
	}
	Invalidate();
	GetLayout()->PlaceBox();
	pApp->GetMainFrame()->SendSizeEvent(); // BEW 31May2024 added to test Bill's solution for cleaning up unmerger
	pApp->m_bMergeSucceeded = FALSE;
	pApp->m_bMergerIsCurrent = FALSE;
}

// return TRUE if the selection extended, FALSE if not (would be false only if at a
// boundary) m_pAnchor is always the pile at which the phraseBox currently is; this
// function is only for the ALT plus arrow key selection method
// BEW 21Jul14 no changes for ZWSP support
bool CAdapt_ItView::ExtendSelectionRight()
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	wxCommandEvent dummyevent;
	// can't extend if we are showing only the target line
	if (gbShowTargetOnly)
		return TRUE; // don't want message about boundaries

	//// remove an existing selection if it was not done using the arrow key, save
	// m_bRespectBoundaries across this operation
	bool bSaveFlag = pApp->m_bRespectBoundaries;
	bSaveFlag = bSaveFlag; // avoid compiler warning

	if (pApp->m_selection.GetCount() > 0 && !pApp->m_bSelectByArrowKey)
	{
		RemoveSelection();
		Invalidate();
		GetLayout()->PlaceBox();
	}

	// need a CClientDC
	wxClientDC aDC(pApp->GetMainFrame()->canvas);

	canvas->DoPrepareDC(aDC); //OnPrepareDC(&aDC); // adjust the origin

	CPile* pActivePile = pApp->m_pActivePile;
	wxASSERT(pActivePile != NULL);
	//pApp->m_pAnchor = pActivePile->m_pCell[1];
	pApp->m_pAnchor = pActivePile->GetCell(0);
	bool bSelExists = pApp->m_selection.GetCount() > 0;
	if (bSelExists && pApp->m_bSelectByArrowKey)
	{
        // if we are extending to the right in a selection to the left, we have to remove
        // the first pile's selection
		if (pApp->m_curDirection == toleft)
		{
			// find the leftmost cell of the selection
			CCellList::Node* cpos = pApp->m_selection.GetFirst();
			CCell* pLeftmost = (CCell*)cpos->GetData();

			// remove this cell's selection...
			// (next line, Do not use wxTRANSPARENT here!!
			// it leaves any existing yellow background)
			aDC.SetBackgroundMode(pApp->m_backgroundMode);
			aDC.SetTextBackground(wxColour(255,255,255)); // white
			pLeftmost->DrawCell(&aDC, GetLayout()->GetSrcColor());
			pLeftmost->SetSelected(FALSE);

			// preserve record of the deselection
			CCellList::Node* pos_pCellList = pApp->m_selection.GetFirst();
			if (pos_pCellList != NULL)
				pApp->m_selection.DeleteNode(pos_pCellList);

			// if the deselection brought us back to the anchor cell, then
			// remove the selection entirely (ie. remove anchor cell seln too)
			CCell* pNextCell = GetNextCell(pLeftmost,0);
			if (pNextCell != NULL)
			{
				CPile* pNextPile = pNextCell->GetPile();
				if (pNextPile == pActivePile)
				{
					// remove this pile's selection too
					pNextCell->DrawCell(&aDC, GetLayout()->GetSrcColor());
					pNextCell->SetSelected(FALSE);

					// make all the parameter agree with no selection
					pApp->m_bSelectByArrowKey = FALSE;
					pApp->m_selectionLine = -1;
					pApp->m_pAnchor = NULL;
					pApp->m_selection.Clear();
					// TODO 30Jun09 Check if below is still needed
					gnSelectionLine = -1; // whm added 21Feb09 to get global
										  // back in sync with reality
					gnSelectionStartSequNum = -1; // whm added 21Feb09 to get global
												  // back in sync with reality
					gnSelectionEndSequNum = -1; // whm added 21Feb09 to get global
												// back in sync with reality
				}
			}
			else
			{
                // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
                pApp->m_bUserDlgOrMessageRequested = TRUE;
                wxMessageBox(_(
				"Error while trying to deselect a cell. Try selecting using the mouse instead.\n"),
                _T(""), wxICON_INFORMATION | wxOK);
				RemoveSelection();	// whm added 7July06 to prevent crash when invoking
						// ALT+Rightarrow at end of document (avoids m_selectionLine becoming 1
						// while m_selection is empty. The crash would happen in a OnUpdateUI
						// handler that tests the status of m_selectionLine != -1
				return FALSE;
			}
#ifdef __WXMAC__
			pApp->GetMainFrame()->SendSizeEvent(); // this is needed for wxMAC to paint
												   // the highlighted source correctly
#endif
			return TRUE;
		}

		// find the rightmost cell of the selection
		CCellList::Node* ccpos = pApp->m_selection.GetLast();
		CCell* pRightmost = (CCell*)ccpos->GetData();
		CPile* pRightPile = pRightmost->GetPile();

		if (pApp->m_bRespectBoundaries)
		{
			if (pRightPile->GetSrcPhrase()->m_bBoundary) // can't extend past a boundary
				return FALSE;
		}

		CCell* pNextCell = GetNextCell(pRightmost,0);

        // if vertical edit is in effect, and we are in adaptationsStep (glossesStep
        // doesn't allow this selection method because glossing mode doesn't), then check
        // that we've not encroached on the gray text to the right, if we have then beep
        // and remove the selection
		if (gbVerticalEditInProgress && gEditStep == adaptationsStep)
		{
			pRightPile = pNextCell->GetPile();
			if (pRightPile->GetSrcPhrase()->m_nSequNumber >
					gEditRecord.nAdaptationStep_EndingSequNum)
			{
				RemoveSelection();
				return FALSE;
			}
		}
		if (pNextCell != NULL)
		{
			wxASSERT(pNextCell != NULL);
			aDC.SetBackgroundMode(pApp->m_backgroundMode);
			aDC.SetTextBackground(wxColour(235,245,40)); // yellow
			pNextCell->DrawCell(&aDC, GetLayout()->GetSrcColor());
			pNextCell->SetSelected(TRUE); // set m_bSelected to TRUE

			// preserve record of the selection
			pApp->m_selection.Append(pNextCell);
			pApp->m_selectionLine = 0;
		}
		else
		{
            // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
            pApp->m_bUserDlgOrMessageRequested = TRUE;
            wxMessageBox(_(
			"Could not get a pointer to the next cell. Try selecting with the mouse instead.\n"),
            _T(""), wxICON_INFORMATION | wxOK);
			RemoveSelection();	// whm added 7July06 to prevent crash when invoking
					// ALT+Rightarrow at end of document (avoids m_selectionLine becoming 1
					// while m_selection is empty. The crash would happen in a OnUpdateUI
					// handler that tests the status of m_selectionLine != -1
			return FALSE;
		}
	}
	else
	{
		// no selection yet, so select the cell in the active pile before extending right
		pApp->m_bSelectByArrowKey = TRUE;
		pApp->m_curDirection = toright;// BEW 2Oct13 changed from right to toright due to ambiguity
		aDC.SetBackgroundMode(pApp->m_backgroundMode);
		aDC.SetTextBackground(wxColour(235,245,40)); // yellow
		CCell* pCell = pActivePile->GetCell(0);
		pCell->DrawCell(&aDC, GetLayout()->GetSrcColor());
		pCell->SetSelected(TRUE);

		// preserve record of the selection
		pApp->m_selection.Append(pCell);
		pApp->m_selectionLine = 0;

		// now try extend it one cell right
		if (pApp->m_bRespectBoundaries)
		{
			if (pActivePile->GetSrcPhrase()->m_bBoundary) // can't extend past a boundary
				return FALSE;
		}
		CCell* pNextCell = GetNextCell(pCell,0);

        // if vertical edit is in effect, and we are in adaptationsStep (glossesStep
        // doesn't allow this selection method because glossing mode doesn't), then check
        // that we've not encroached on the gray text to the right, if we have then beep
        // and remove the selection
		if (gbVerticalEditInProgress && gEditStep == adaptationsStep)
		{
			CPile* pRightPile = pNextCell->GetPile();
			if (pRightPile->GetSrcPhrase()->m_nSequNumber >
					gEditRecord.nAdaptationStep_EndingSequNum)
			{
				RemoveSelection();
				return FALSE;
			}
		}
		if (pNextCell != NULL)
		{
			wxASSERT(pNextCell != NULL);
			pNextCell->DrawCell(&aDC, GetLayout()->GetSrcColor());
			pNextCell->SetSelected(TRUE);

			// preserve record of the selection
			pApp->m_selection.Append(pNextCell);
		}
		else
		{
            // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
            pApp->m_bUserDlgOrMessageRequested = TRUE;
            wxMessageBox(_(
			"Could not get a pointer to the next cell. Try selecting with the mouse instead.\n"),
            _T(""), wxICON_INFORMATION | wxOK);
			RemoveSelection();	// whm added 7July06 to prevent crash when invoking
					// ALT+Rightarrow at end of document (avoids m_selectionLine becoming 1
					// while m_selection is empty. The crash would happen in a OnUpdateUI
					// handler that tests the status of m_selectionLine != -1
			return FALSE;
		}
	}
#ifdef __WXMAC__
	pApp->GetMainFrame()->SendSizeEvent(); // this is needed for wxMAC to paint
										   // the highlighted source correctly
#endif
	return TRUE;
}

// return TRUE if the selection extended, FALSE if not (would be false only if at a
// boundary) this function works with selections on the 2nd line only; m_pAnchor is always
// the pile at which the phraseBox currently is
// BEW 21Jul14 no changes for ZWSP support
bool CAdapt_ItView::ExtendSelectionLeft()
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	wxCommandEvent dummyevent;
	// can't extend if we are showing only the target line
	if (gbShowTargetOnly)
		return TRUE; // don't want message about boundaries

	//// remove an existing selection if it was not done using the arrow key, save
	// m_bRespectBoundaries across this operation
	bool bSaveFlag = pApp->m_bRespectBoundaries;

	bSaveFlag = bSaveFlag; // avoid compiler warning
	if (pApp->m_selection.GetCount() > 0 && !pApp->m_bSelectByArrowKey)
	{
		RemoveSelection();
		Invalidate();
		GetLayout()->PlaceBox();
	}

	// need a CClientDC
	wxClientDC aDC(pApp->GetMainFrame()->canvas);

	canvas->DoPrepareDC(aDC); //OnPrepareDC(&aDC); // adjust the origin

	CPile* pActivePile = pApp->m_pActivePile;
	wxASSERT(pActivePile != NULL);
	pApp->m_pAnchor = pActivePile->GetCell(0);
	bool bSelExists = pApp->m_selection.GetCount() > 0;
	if (bSelExists && pApp->m_bSelectByArrowKey)
	{
		// if we are backing up in a selection to the right, we have to remove
		// the last pile's selection
		if (pApp->m_curDirection == toright)// BEW 2Oct13 changed from right to toright due to ambiguity
		{
			// find the rightmost cell of the selection
			CCellList::Node* cpos = pApp->m_selection.GetLast();
			CCell* pRightmost = (CCell*)cpos->GetData();

			// remove this cell's selection...
			// For next line, do not use wxTRANSPARENT here!!
			// it leaves any existing yellow background
			aDC.SetBackgroundMode(pApp->m_backgroundMode);
			aDC.SetTextBackground(wxColour(255,255,255)); // white
			pRightmost->DrawCell(&aDC, GetLayout()->GetSrcColor());
			pRightmost->SetSelected(FALSE); // set CCell::m_bSelected to FALSE

			// preserve record of the deselection
			CCellList::Node* pos_pCellList = pApp->m_selection.GetLast();
			if (pos_pCellList != NULL)
				pApp->m_selection.DeleteNode(pos_pCellList);

			// if the deselection brought us back to the anchor cell, then
			// remove the selection entirely (ie. remove anchor cell selection too)
			CCell* pPrevCell = GetPrevCell(pRightmost,0);
			if (pPrevCell != NULL)
			{
				CPile* pPrevPile = pPrevCell->GetPile();
				if (pPrevPile == pActivePile)
				{
					// remove this pile's selection too
					pPrevCell->DrawCell(&aDC, GetLayout()->GetSrcColor());
					pPrevCell->SetSelected(FALSE);

					// make all the parameter agree with no selection
					pApp->m_bSelectByArrowKey = FALSE;
					pApp->m_selectionLine = -1;
					pApp->m_pAnchor = NULL;
					pApp->m_selection.Clear();
					// TODO 30Jun09 Check if below is still needed
					gnSelectionLine = -1; // whm added 21Feb09 to get global
										  // back in sync with reality
					gnSelectionStartSequNum = -1; // whm added 21Feb09 to get global
												  // back in sync with reality
					gnSelectionEndSequNum = -1; // whm added 21Feb09 to get global
												// back in sync with reality
				}
			}
			else // pPrevCell is NULL
			{
                // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
                pApp->m_bUserDlgOrMessageRequested = TRUE;
                wxMessageBox(_(
				"Error while trying to deselect a cell. Try selecting using the mouse instead.\n"),
                _T(""), wxICON_INFORMATION | wxOK);
				return FALSE;
			}
#ifdef __WXMAC__
			pApp->GetMainFrame()->SendSizeEvent(); // this is needed for wxMAC to paint
												   // the highlighted source correctly
#endif
			return TRUE;
		}
		// find the leftmost cell of the selection
		CCellList::Node* fpos = pApp->m_selection.GetFirst();
		CCell* pLeftmost = fpos->GetData();
		//CCell* pPrevCell = GetPrevCell(pLeftmost,1);
		CCell* pPrevCell = GetPrevCell(pLeftmost,0);

        // if vertical edit is in effect, and we are in adaptationsStep (glossesStep
        // doesn't allow this selection method because glossing mode doesn't), then check
        // that we've not encroached on the gray text to the left, if we have then beep and
        // remove the selection
		if (gbVerticalEditInProgress && gEditStep == adaptationsStep)
		{
			CPile* pPrevPile = pPrevCell->GetPile();
			if (pPrevPile->GetSrcPhrase()->m_nSequNumber <
					gEditRecord.nAdaptationStep_StartingSequNum)
			{
				RemoveSelection();
				return FALSE;
			}
		}
		if (pPrevCell != NULL)
		{
			wxASSERT(pPrevCell != NULL);
			aDC.SetBackgroundMode(pApp->m_backgroundMode);
			aDC.SetTextBackground(wxColour(235,245,40)); // yellow
			CPile* pPrevPile = pPrevCell->GetPile();

			if (pApp->m_bRespectBoundaries)
			{
				if (pPrevPile->GetSrcPhrase()->m_bBoundary) // can't extend left on to a boundary
					return FALSE;
			}

			pPrevCell->DrawCell(&aDC, GetLayout()->GetSrcColor());
			pPrevCell->SetSelected(TRUE);

			// preserve record of the selection
			pApp->m_selection.Insert(pPrevCell);
			pApp->m_selectionLine = 0;
		}
		else // pPrevCell is NULL
		{
			wxMessageBox(_(
			"Could not get a pointer to the previous cell. Try selecting with the mouse instead.\n"
			), _T(""), wxICON_INFORMATION | wxOK);
			return FALSE;
		}
	}
	else
	{
		// no selection yet, so select the cell in the active pile before extending left
		pApp->m_bSelectByArrowKey = TRUE;
		pApp->m_curDirection = toleft;
		aDC.SetBackgroundMode(pApp->m_backgroundMode);
		aDC.SetTextBackground(wxColour(235,245,40)); // yellow
		CCell* pCell = pActivePile->GetCell(0);
		pCell->DrawCell(&aDC, GetLayout()->GetSrcColor());
		pCell->SetSelected(TRUE);

		// preserve record of the selection
		pApp->m_selection.Insert(pCell);
		pApp->m_selectionLine = 0;

		// now try extend it one cell left
		CCell* pPrevCell = GetPrevCell(pCell,0);
		if (pPrevCell == NULL) // whm added to prevent crash when phrasebox is in first pile
		{
			// we're at the first pile in the doc and can't move left
			RemoveSelection(); // whm added; if test were at top of current
							   // else block this wouldn't be needed
			return FALSE;
		}
		wxASSERT(pPrevCell != NULL);
		CPile* pPrevPile = pPrevCell->GetPile();
		wxASSERT(pPrevPile != NULL);
		if (pApp->m_bRespectBoundaries)
		{
			if (pPrevPile->GetSrcPhrase()->m_bBoundary) // can't extend past a boundary
			{
				// whm added below for situation when phrasebox is at last pile in doc and a
				// boundary prevents selecting previous pile.
				CCell* pNextCell = GetNextCell(pCell,0);
				if (pNextCell == NULL)
				{
					RemoveSelection();
				}
				return FALSE;
			}
		}

        // if vertical edit is in effect, and we are in adaptationsStep (glossesStep
        // doesn't allow this selection method because glossing mode doesn't), then check
        // that we've not encroached on the gray text to the left, if we have then beep and
        // remove the selection
		if (gbVerticalEditInProgress && gEditStep == adaptationsStep)
		{
			if (pPrevPile->GetSrcPhrase()->m_nSequNumber <
					gEditRecord.nAdaptationStep_StartingSequNum)
			{
				RemoveSelection();
				return FALSE;
			}
		}
		if (pPrevCell != NULL)
		{
			pPrevCell->DrawCell(&aDC, GetLayout()->GetSrcColor());
			pPrevCell->SetSelected(TRUE);

			// preserve record of the selection
			pApp->m_selection.Insert(pPrevCell);
		}
		else
		{
            // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
            pApp->m_bUserDlgOrMessageRequested = TRUE;
            wxMessageBox(_(
			"Could not get a pointer to the previous cell. Try selecting with the mouse instead.\n"
			), _T(""), wxICON_INFORMATION | wxOK);
			return FALSE;
		}
	}
#ifdef __WXMAC__
	pApp->GetMainFrame()->SendSizeEvent(); // this is needed for wxMAC to paint
										   // the highlighted source correctly
#endif
	return TRUE;
}

// pass in a pile pointer which we want to know whether or not it is in the gray text area;
// the gEditStep is a global, so does not need to be passed in; return TRUE if the pile is
// in the editable area, FALSE if in the gray area, and if a NULL pile is passed in, treat
// it as equivalent to being in the gray area (ie. return FALSE)
bool CAdapt_ItView::CheckForVerticalEditBoundsError(CPile* pPile)
{
	//bool bBadSwitchValue = FALSE;
	if (pPile == NULL)
		return FALSE;
	int nLeftBoundSN = 0; // whm initialized to avoid "potentially uninitialized local
						  // variable ... used" warning
	int nRightBoundSN = 0; // whm initialized to avoid "potentially uninitialized local
						   // variable ... used" warning
	if (gbVerticalEditInProgress &&
		(gEditStep == adaptationsStep ||
		gEditStep == glossesStep ||
		gEditStep == freeTranslationsStep
		))
	{
		switch(gEditStep)
		{
		case adaptationsStep:
			nLeftBoundSN = gEditRecord.nAdaptationStep_StartingSequNum;
			nRightBoundSN = gEditRecord.nAdaptationStep_EndingSequNum;
			break;
		case glossesStep:
			nLeftBoundSN = gEditRecord.nGlossStep_StartingSequNum;
			nRightBoundSN = gEditRecord.nGlossStep_EndingSequNum;
			break;
		case freeTranslationsStep:
			nLeftBoundSN = gEditRecord.nFreeTranslationStep_StartingSequNum;
			nRightBoundSN = gEditRecord.nFreeTranslationStep_EndingSequNum;
			break;
		case noEditStep:
			break;
		case sourceTextStep:
			break;
		case backTranslationsStep:
			break;
		}
		if ((pPile->GetSrcPhrase()->m_nSequNumber < nLeftBoundSN)
			||(pPile->GetSrcPhrase()->m_nSequNumber > nRightBoundSN))
		{
			RemoveSelection();
			::wxBell();
			return FALSE;
		}
	}
	return TRUE;
}

void CAdapt_ItView::MergeWords()
{
	wxCommandEvent dummyevent;
	OnButtonMerge(dummyevent);
}

/////////////////////////////////////////////////////////////////////////////////
/// \return		nothing
/// \param      event   -> the wxUpdateUIEvent that is generated when the View Menu
///                        is about to be displayed
/// \remarks
/// Called from: The wxUpdateUIEvent mechanism when the associated menu item is selected,
/// and before the menu is displayed.
/// It enables the "Change Interface Language..." item on the View menu. This menu item is
/// always enabled unless Vertical Editing is in progress.
/////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItView::OnUpdateChangeInterfaceLanguage(wxUpdateUIEvent& event)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	if (pApp->m_bClipboardAdaptMode)
	{
		event.Enable(FALSE);
		return;
	}
	if (gbVerticalEditInProgress)
	{
		event.Enable(FALSE);
		return;
	}
	// should always be accessible provided state is not in some non-robust state
	event.Enable(TRUE);
}

void CAdapt_ItView::OnChangeInterfaceLanguage(wxCommandEvent& WXUNUSED(event))
{
	CAdapt_ItApp* pApp = &wxGetApp();
	pApp->LogUserAction(_T("Initiated OnChangeInterfaceLanguage()"));
	pApp->ChangeUILanguage();
}

/////////////////////////////////////////////////////////////////////////////////
/// \return		nothing
/// \param      event   -> the wxUpdateUIEvent that is generated when the View Menu
///                        is about to be displayed
/// \remarks
/// Called from: The wxUpdateUIEvent mechanism when the associated menu item is selected,
/// and before the menu is displayed.
/// If the application is doing a vertical edit, only showing the target language, or the
/// Document pointer is NULL, this handler disables the "Preferences..." item on the View
/// menu and immediately returns.
/// It enables the "Preferences..." item on the View menu if a document is loaded (i.e.,
/// the count of source phrases in m_pSourcePhrases list is greater than zero), otherwise
/// it disables the menu item.
/// BEW note 6Nov09, the requirement that a doc be open is unnecessarily stringent,
/// there are times when you'd want access when no doc is loaded - such as getting
/// access to the Administrator menu should only require you be in an open project (and
/// even that is maybe a bit too stringent). However our code won't support this currently
/// because the USFM and Filtering page does a lot of setup for USFM and filtering and for
/// that it looks into the doc- which therefore has to be open.
/// BEW modified 13Nov09: if the local user has read-only access (to a remote project
/// folder) it must not be possible to change the remote settings so as to initiate a
/// rebuild of the remote document while the remote user is working with it, therefore
/// disable the Preferences access in this circumstance
/////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItView::OnUpdateEditPreferences(wxUpdateUIEvent& event)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	if (pApp->m_bClipboardAdaptMode)
	{
		// Get all the setups done outside this mode being on
		event.Enable(FALSE);
		return;
	}
	if (pApp->m_bReadOnlyAccess)
	{
		event.Enable(FALSE);
		return;
	}
	if (gbVerticalEditInProgress)
	{
		event.Enable(FALSE);
		return;
	}
	if (gbShowTargetOnly && !gbIsGlossing && pApp->m_bKBReady) // was FALSE and just the 1st test
	{
		event.Enable(TRUE);
		return;
	}
	// Allow Edit > Preferences only if a project is open (a doc need not be open)
	if ((!gbIsGlossing && pApp->m_bKBReady) || (gbIsGlossing && pApp->m_bGlossingKBReady))
	{
		event.Enable(TRUE);
	}
	else
	{
		event.Enable(FALSE);
	}
}

// whm added 26Mar12. Disable mode bar control when in read-only mode
void CAdapt_ItView::OnUpdateCheckSingleStep(wxUpdateUIEvent& event)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	if (pApp->m_bReadOnlyAccess)
	{
		event.Enable(FALSE);
		return;
	}
	event.Enable(TRUE);
}

// whm 30Aug2021 added for AutoCorrect support.
// This update handler causes the [ ] Use Auto Correct check box in the control bar to be
// shown in the control bar if a documents is open AND the m_AutoCorrectMap has at least
// one element/rule within it. Otherwise the check box is hidden from the control bar.
// The m_AutoCorrectMap remains empty unless there is an autocorrect.txt file with valid
// rules located within the open document's project folder.
// Note: The check box initially appears ticked, and it is up to the user to either 
// leave it ticked, or to remove the tick from the box if auto-correct is to be temporarily
// suspended during target text editing.
void CAdapt_ItView::OnUpdateCheckUseAutoCorrect(wxUpdateUIEvent& event)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	CKB* pKB;
	if (gbIsGlossing)
		pKB = pApp->m_pGlossingKB;
	else
		pKB = pApp->m_pKB;

	if (pKB != NULL && pApp->m_pLayout->GetStripCount() > 0
		&& pApp->m_AutoCorrectMap.size() > 0)
	{
		// A document is open, and the m_AutoCorrectMap has at least one rule in it, 
		// so show the Use Auto Correct checkbox if it is not shown.
		wxCheckBox* pCheckboxUseAutoCorrect = (wxCheckBox*)pApp->GetMainFrame()->m_pControlBar->FindWindowById(ID_CHECKBOX_USE_AUTOCORRECT);
		if (pCheckboxUseAutoCorrect != NULL)
		{
			if (!pCheckboxUseAutoCorrect->IsShown())
			{
				pCheckboxUseAutoCorrect->Show();
			}
			// The Use Auto Correct checkbox should be enabled while it is being shown
			event.Enable(TRUE);
		}
		
	}
	else
	{
		// No document is open, or there are no elements in the m_AutoCorrectMap, so hide the Use Auto Correct checkbox if it is being shown
		wxCheckBox* pCheckboxUseAutoCorrect = (wxCheckBox*)pApp->GetMainFrame()->m_pControlBar->FindWindowById(ID_CHECKBOX_USE_AUTOCORRECT);
		if (pCheckboxUseAutoCorrect != NULL)
		{
			if (pCheckboxUseAutoCorrect->IsShown())
				pCheckboxUseAutoCorrect->Hide();
			// It doesn't matter whether the checkbox is enabled while it is hidden
		}
	}
}

// whm 30Aug2021 added for AutoCorrect support
// The Use Auto Correct check box remains hidden from the control bar
// unless a document is open within a project that has an autocorrect.txt
// file within the project folder associated with the open document.
// The check box always starts on/ticked. This function allows the user 
// to turn OFF Auto Correct functionality at any time, and turn it back ON 
// for the open document. 
void CAdapt_ItView::OnCheckUseAutoCorrect(wxCommandEvent& event)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	if (event.IsChecked())
	{
		pApp->m_bUsingAutoCorrect = TRUE;
	}
	else
	{
		pApp->m_bUsingAutoCorrect = FALSE;
	}
}

void CAdapt_ItView::OnCheckSingleStep(wxCommandEvent& WXUNUSED(event))
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	// toggle the m_bSingleStep flag
	pApp->m_bSingleStep = pApp->m_bSingleStep == TRUE ? FALSE : TRUE;

	// restore focus to the targetBox, if it is visible
    if (pApp->m_pTargetBox != NULL)
    {
        if (pApp->m_pTargetBox->IsShown())
        {
            pApp->m_pTargetBox->SetFocusAndSetSelectionAtLanding(); // whm 13Aug2018 modified
        }
    }
}

void CAdapt_ItView::OnCheckForceAsk(wxCommandEvent& WXUNUSED(event))
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	// toggle the m_bForceAsk flag
	pApp->m_bForceAsk = pApp->m_bForceAsk == TRUE ? FALSE : TRUE;

	// restore focus to the targetBox, if it is visible
    if (pApp->m_pTargetBox != NULL)
    {
        if (pApp->m_pTargetBox->IsShown())
        {
            pApp->m_pTargetBox->SetFocusAndSetSelectionAtLanding(); // whm 13Aug2018 modified
        }
    }
}

/// whm modified 21Sep10 to make safe for when selected user profile removes this menu item.
void CAdapt_ItView::OnCopySource(wxCommandEvent& event)
{
    CAdapt_ItApp* pApp = &wxGetApp();
    wxASSERT(pApp != NULL);
    CMainFrame *pFrame = wxGetApp().GetMainFrame();
    wxASSERT(pFrame != NULL);
    wxMenuBar* pMenuBar = pFrame->GetMenuBar();
    wxASSERT(pMenuBar != NULL);
    wxMenuItem * pViewCopySource = pMenuBar->FindItem(ID_COPY_SOURCE);

    // whm Note: Since OnMarkerWrapsStrip() is also called from the View's OnInitialUpdate()
    // we test here to make sure we're logging the actual menu item call and not the
    // OnInitialUpdate call.
    if (event.GetId() == ID_COPY_SOURCE)
    {
        if (pApp->m_bCopySource)
            pApp->LogUserAction(_T("Turned Copy Source OFF"));
        else
            pApp->LogUserAction(_T("Turned Copy Source ON"));
    }

    // toggle the setting
    if (pApp->m_bCopySource)
    {
        // toggle the checkmark to OFF
        if (pViewCopySource != NULL)
        {
            pViewCopySource->Check(FALSE);
        }
        pApp->m_bCopySource = FALSE;
    }
    else
    {
        // toggle the checkmark to ON
        if (pViewCopySource != NULL)
        {
            pViewCopySource->Check(TRUE);
        }
        pApp->m_bCopySource = TRUE;
    }

    // restore focus to the targetBox, if it is visible
    if (pApp->m_pTargetBox != NULL)
    {
        if (pApp->m_pTargetBox->IsShown())
        {
            pApp->m_pTargetBox->SetFocusAndSetSelectionAtLanding(); // whm 13Aug2018 modified
        }
    }
}

/// whm added 2Aug2018 to handle Select Copied Source checkable menu item.
/// The Select Copied Source menu item may be disabled (when m_bCopySource
/// is false). This menu handler will only execute when the menu item is
/// enabled, that is, when the toggle menu item above it ("Copy Source")
/// is TRUE. When the Copy Source menu item is toggled to an unticked state
/// the Select Copied Source menu item will be disabled.
void CAdapt_ItView::OnSelectCopiedSource(wxCommandEvent& event)
{
    CAdapt_ItApp* pApp = &wxGetApp();
    wxASSERT(pApp != NULL);
    CMainFrame *pFrame = wxGetApp().GetMainFrame();
    wxASSERT(pFrame != NULL);
    wxMenuBar* pMenuBar = pFrame->GetMenuBar();
    wxASSERT(pMenuBar != NULL);
    wxMenuItem * pViewSelectCopiedSource = pMenuBar->FindItem(ID_SELECT_COPIED_SOURCE);

    // whm Note: Since OnMarkerWrapsStrip() is also called from the View's OnInitialUpdate()
    // we test here to make sure we're logging the actual menu item call and not the
    // OnInitialUpdate call.

    if (event.GetId() == ID_SELECT_COPIED_SOURCE)
    {
        if (pApp->m_bSelectCopiedSource)
            pApp->LogUserAction(_T("Turned Select Copied Source OFF"));
        else
            pApp->LogUserAction(_T("Turned Select Copied Source ON"));
    }

    // toggle the setting
    if (pApp->m_bSelectCopiedSource)
    {
        // toggle the checkmark to OFF
        if (pViewSelectCopiedSource != NULL)
        {
            pViewSelectCopiedSource->Check(FALSE);
        }
        pApp->m_bSelectCopiedSource = FALSE;
    }
    else
    {
        // toggle the checkmark to ON
        if (pViewSelectCopiedSource != NULL)
        {
            pViewSelectCopiedSource->Check(TRUE);
        }
        pApp->m_bSelectCopiedSource = TRUE;
    }

    // Remove or restore any selection from phrasebox text where appropriate
    // based on the new value of pApp->m_bSelectCopiedSource.
    // The SetFocusAndSetSelectionAtLanding() function ensures that the
    // SetFocus() call precedes the SetSelection(len,len) call.
    if (pApp->m_pTargetBox != NULL)
    {
        if (pApp->m_pTargetBox->IsShown())
        {
            pApp->m_pTargetBox->SetFocusAndSetSelectionAtLanding(); // whm 13Aug2018 modified
        }
    }
}

// whm 2Aug2018 added
// The Select Copied Source menu item toggle, should only be enabled when
// the Copy Source menu item (above it) is ticked (TRUE), as indicated by
// a TRUE value for the App's m_bCopySource value.
void CAdapt_ItView::OnUpdateSelectCopiedSource(wxUpdateUIEvent& event)
{
    CAdapt_ItApp* pApp = &wxGetApp();

    if (pApp->m_bCopySource)
    {
        event.Enable(TRUE);
    }
    else
    {
        event.Enable(FALSE);
    }
}


/////////////////////////////////////////////////////////////////////////////////
/// \return		nothing
/// \param      event   -> the wxUpdateUIEvent that is generated when the Tools Menu
///                        is about to be displayed
/// \remarks
/// Called from: The wxUpdateUIEvent mechanism when the associated menu item is selected,
/// and before the menu is displayed.
/// If the application is in Free Translation Mode, this handler disables the "Use
/// Consistent Changes" item on the Tools menu and immediately returns.
/// If one or more cc tables are loaded (i.e., the App's m_bTablesLoaded flag is TRUE), it
/// enables the "Use Consistent Changes" item on the Tools menu, otherwise it disables the
/// menu item.
/////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItView::OnUpdateUseConsistentChanges(wxUpdateUIEvent& event)
{
	CAdapt_ItApp* pApp = &wxGetApp();

	// whm added 26Mar12.
	if (pApp->m_bReadOnlyAccess)
	{
		event.Enable(FALSE);
		return;
	}

	if (pApp->m_bFreeTranslationMode)
	{
		event.Enable(FALSE);
		return;
	}

	// the flags we want are on the view, so get the view
	if (pApp->m_bTablesLoaded)
		event.Enable(TRUE);
	else
		event.Enable(FALSE);
}

/////////////////////////////////////////////////////////////////////////////////
/// \return		nothing
/// \param      event   -> the wxUpdateUIEvent that is generated when the Tools Menu
///                        is about to be displayed
/// \remarks
/// Called from: The wxUpdateUIEvent mechanism when the associated menu item is selected,
/// and before the menu is displayed.
/// If the application is in Free Translation Mode, this handler disables the "Use SIL
/// Converter" item on the Tools menu and immediately returns.
/// If there is an SIL Converter table name configured (i.e., the App's
/// m_strSilEncConverterName string is not empty), it enables the "Use SIL Converter" item
/// on the Tools menu, otherwise it disables the menu item.
/////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItView::OnUpdateUseSilConverter(wxUpdateUIEvent& event)
{
	CAdapt_ItApp* pApp = &wxGetApp();

	// whm added 2i6Mar12.
	if (pApp->m_bReadOnlyAccess)
	{
		event.Enable(FALSE);
		return;
	}

	if (pApp->m_bFreeTranslationMode || !pApp->bECDriverDLLLoaded)
	{
		event.Enable(FALSE);
		return;
	}

#ifdef USE_SIL_CONVERTERS
	// whm added 12Jan09 for SIL Converters support
	typedef int (wxSTDCALL *wxECIsInstalledType)();
	wxECIsInstalledType pfnECisInstalled = (wxECIsInstalledType)NULL;
    // whm Note: The IsEcInstalled() function in ECDriver.dll does not have A and W forms
    // so we must call GetSymbol() instead of GetSymbolAorW() here.
	pfnECisInstalled =
		(wxECIsInstalledType)ecDriverDynamicLibrary.GetSymbol(FUNC_NAME_EC_IS_INSTALLED);
    // enable it if ECisInstalled and there's a configured table name
	event.Enable(pfnECisInstalled != NULL && pfnECisInstalled() == TRUE &&
					!pApp->m_strSilEncConverterName.IsEmpty());
#else
	event.Enable(FALSE); // don't enable the menu item if we're not using SIL Converters
#endif
}

/////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \param      event (unused)
/// \remarks
/// Called from the Tools menu on selection of the "Use Consistent Changes" menu item. This
/// handler toggles the check on the menu item and the value of the m_bUseConsistentChanges
/// variable on the App. The "Use Consistent Changes" menu selection basically works as a
/// switch to turn on or off any change tables the were previously loaded using the "Load
/// Consistent Changes..." menu item.
/// whm modified 21Sep10 to make safe for when selected user profile removes this menu item.
/////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItView::OnUseConsistentChanges(wxCommandEvent& WXUNUSED(event))
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	CMainFrame *pFrame = pApp->GetMainFrame();
	wxASSERT(pFrame != NULL);
	wxMenuBar* pMenuBar = pFrame->GetMenuBar();
	wxASSERT(pMenuBar != NULL);
	wxMenuItem * pToolsMenuUseCC = pMenuBar->FindItem(ID_USE_CC);
	//wxASSERT(pToolsMenuUseCC != NULL);
	wxMenuItem * pToolsMenuUseSilConverter = pMenuBar->FindItem(ID_USE_SILCONVERTER);
	//wxASSERT(pToolsMenuUseSilConverter != NULL);

	// toggle the setting
	if (pApp->m_bUseConsistentChanges)
	{
		// toggle the checkmark to OFF
		if (pToolsMenuUseCC != NULL)
		{
			pApp->LogUserAction(_T("Use Consistent Changes OFF"));
			pToolsMenuUseCC->Check(FALSE);
		}
		pApp->m_bUseConsistentChanges = FALSE;
	}
	else
	{
		// toggle the checkmark to ON
		if (pToolsMenuUseCC != NULL)
		{
			pApp->LogUserAction(_T("Use Consistent Changes ON"));
			pToolsMenuUseCC->Check(TRUE);
		}
		pApp->m_bUseConsistentChanges = TRUE;

        // reset the SILConverter 'use' menu in case it was set
        // (i.e. these two are mutually exclusive)
		if (pToolsMenuUseSilConverter != NULL)
		{
			pToolsMenuUseSilConverter->Check(FALSE);
		}
		pApp->m_bUseSilConverter = FALSE;
	}

    // if the checkbox was just turned on, then have the phrase box placed there again, so
    // as to give consistent changes a chance to work on the current source phrase
	if (pApp->m_bUseConsistentChanges)
	{
		// ensure we are not at eof with no phrase box currently in existence
		if (pApp->m_pActivePile != NULL)
		{
			CCell* pCell = pApp->m_pActivePile->GetCell(1);
			wxASSERT(pCell != NULL);
			int selector = 1; // this value suppresses both removal from the KB and storing
							  // prior adaptation
#if defined (ABANDON_NOT)
			pApp->m_pTargetBox->m_bAbandonable = FALSE;
#else
			pApp->m_pTargetBox->m_bAbandonable = TRUE;
#endif
			PlacePhraseBox(pCell,selector);
		}
	}
	else
	{
        // we have just turned off the use of consistent changes, so we must turn off
        // acceptance of defaults too
		pApp->m_bAcceptDefaults = FALSE;

		// and update the menu command to be unchecked
		if (pToolsMenuUseCC != NULL)
		{
			pToolsMenuUseCC->Check(FALSE);
		}
	}

	// restore focus to the targetBox, if it is visible
    if (pApp->m_pTargetBox != NULL)
    {
        if (pApp->m_pTargetBox->IsShown())
        {
            pApp->m_pTargetBox->SetFocusAndSetSelectionAtLanding();// whm 13Aug2018 modified
        }
    }
}

/// whm modified 21Sep10 to make safe for when selected user profile removes this menu item.
void CAdapt_ItView::OnUseSilConverter(wxCommandEvent& WXUNUSED(event))
{
	CAdapt_ItApp* pApp = (CAdapt_ItApp*)&wxGetApp();
	CMainFrame *pFrame = pApp->GetMainFrame();
	wxASSERT(pFrame != NULL);
	wxMenuBar* pMenuBar = pFrame->GetMenuBar();
	wxASSERT(pMenuBar != NULL);
	wxMenuItem * pToolsMenuUseSilConverter;
	pToolsMenuUseSilConverter = pMenuBar->FindItem(ID_USE_SILCONVERTER);
	//wxASSERT(pToolsMenuUseSilConverter != NULL);
	wxMenuItem * pToolsMenuUseCC;
	pToolsMenuUseCC = pMenuBar->FindItem(ID_USE_CC);
	//wxASSERT(pToolsMenuUseCC != NULL);
	wxMenuItem* pToolsMenuAcceptChanges;
	pToolsMenuAcceptChanges = pMenuBar->FindItem(ID_ACCEPT_CHANGES);
	//wxASSERT(pToolsMenuAcceptChanges != NULL);

	// toggle the setting
	if (pApp->m_bUseSilConverter)
	{
		// toggle the checkmark to OFF
		if (pToolsMenuUseSilConverter != NULL)
		{
			pApp->LogUserAction(_T("Use Sil Converters OFF"));
			pToolsMenuUseSilConverter->Check(FALSE);
		}
		pApp->m_bUseSilConverter = FALSE;
	}
	else
	{
		// toggle the checkmark to ON
		if (pToolsMenuUseSilConverter != NULL)
		{
			pApp->LogUserAction(_T("Use Sil Converters ON"));
			pToolsMenuUseSilConverter->Check(TRUE);
		}
		pApp->m_bUseSilConverter = TRUE;

        // reset the Consistent Changes 'use' menu in case it was set
        // (i.e. these two are mutually exclusive)
		if (pToolsMenuUseCC != NULL)
		{
			pToolsMenuUseCC->Check(FALSE);
		}
		pApp->m_bUseConsistentChanges = FALSE;
	}

    // if the checkbox was just turned on, then have the phrase box placed there again, so
    // as to give consistent changes a chance to work on the current source phrase
	if (pApp->m_bUseSilConverter)
	{
		// ensure we are not at eof with no phrase box currently in existence
		if (pApp->m_pActivePile != NULL)
		{
			CCell* pCell = pApp->m_pActivePile->GetCell(1);
			wxASSERT(pCell != NULL);
			int selector = 1; // this value suppresses both removal from the KB and storing
							  // prior adaptation
#if defined (ABANDON_NOT)
			pApp->m_pTargetBox->m_bAbandonable = FALSE;
#else
			pApp->m_pTargetBox->m_bAbandonable = TRUE;
#endif
			PlacePhraseBox(pCell,selector);
		}
	}
	else
	{
        // we have just turned off the use of the SILConverter, so we must turn off
        // acceptance of defaults too
		pApp->m_bAcceptDefaults = FALSE;

		// and update the menu command to be unchecked
		if (pToolsMenuAcceptChanges != NULL)
		{
			pToolsMenuAcceptChanges->Check(FALSE);
		}
	}

	// restore focus to the targetBox, if it is visible
    if (pApp->m_pTargetBox != NULL)
    {
        if (pApp->m_pTargetBox->IsShown())
        {
            pApp->m_pTargetBox->SetFocusAndSetSelectionAtLanding();// whm 13Aug2018 modified
        }
    }
}

/////////////////////////////////////////////////////////////////////////////////
/// \return		nothing
/// \param      event   -> the wxUpdateUIEvent that is generated when the Tools Menu
///                        is about to be displayed
/// \remarks
/// Called from: The wxUpdateUIEvent mechanism when the associated menu item is selected,
/// and before the menu is displayed.
/// If Vertical Editing is in progress, the "Accept Changes Without Stopping" item on the
/// Tools menu is disabled and this handler returns immediately.
/// If the application is not in Single Step Mode, but is set to Copy the Source text, and,
/// either m_bUseConsistentChanges is TRUE or m_bUseSilConverter is TRUE, then this handler
/// enables the "Accept Changes Without Stopping" item on the Tools menu, otherwise it
/// disables the menu item. Also disables if the clipboard adaptation mode is
/// still running
/////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItView::OnUpdateAcceptChanges(wxUpdateUIEvent& event)
{
	CAdapt_ItApp* pApp = (CAdapt_ItApp*)&wxGetApp();
	if (pApp->m_bClipboardAdaptMode)
	{
		event.Enable(FALSE);
		return;
	}

	// whm added 26Mar12.
	if (pApp->m_bReadOnlyAccess)
	{
		event.Enable(FALSE);
		return;
	}

	if (gbVerticalEditInProgress)
	{
		event.Enable(FALSE);
		return;
	}
	// disable if the 3 flags (single step, cc changes, copy source) are not
	// the right values, but if they are, allow value to be changed
	if (!pApp->m_bSingleStep && pApp->m_bCopySource &&
		(pApp->m_bUseConsistentChanges || pApp->m_bUseSilConverter) )
		event.Enable(TRUE);
	else
		event.Enable(FALSE);
}

/// whm modified 21Sep10 to make safe for when selected user profile removes this menu item.
void CAdapt_ItView::OnAcceptChanges(wxCommandEvent& WXUNUSED(event))
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	CMainFrame *pFrame = wxGetApp().GetMainFrame();
	wxASSERT(pFrame != NULL);

	wxMenuBar* pMenuBar = pFrame->GetMenuBar();
	wxASSERT(pMenuBar != NULL);
	wxMenuItem * pToolsAcceptChanges = pMenuBar->FindItem(ID_ACCEPT_CHANGES);
	//wxASSERT(pToolsAcceptChanges != NULL);

	// toggle the setting
	if (pApp->m_bAcceptDefaults)
	{
		// toggle the checkmark to OFF
		if (pToolsAcceptChanges != NULL)
		{
			pApp->LogUserAction(_T("Accept Changes OFF"));
			pToolsAcceptChanges->Check(FALSE);
		}
		pApp->m_bAcceptDefaults = FALSE;

		// restore the highlighting setting
		pApp->m_bSuppressTargetHighlighting = gbSaveHilightingSetting;
	}
	else
	{
		// toggle the checkmark to ON
		if (pToolsAcceptChanges != NULL)
		{
			pApp->LogUserAction(_T("Accept Changes ON"));
			pToolsAcceptChanges->Check(TRUE);
		}
		pApp->m_bAcceptDefaults = TRUE;

		// save the highlighting setting so it can be restored when the toggle
		// is later turned off, and then suppress highlighting till then
		gbSaveHilightingSetting = pApp->m_bSuppressTargetHighlighting;
		pApp->m_bSuppressTargetHighlighting = TRUE;
	}

	// restore focus to the targetBox, if it is visible
    if (pApp->m_pTargetBox != NULL)
    {
        if (pApp->m_pTargetBox->IsShown())
        {
            pApp->m_pTargetBox->SetFocusAndSetSelectionAtLanding();// whm 13Aug2018 modified
        }
    }
}

// whm added 26Mar12. Disable mode bar control when read-only mode is active
void CAdapt_ItView::OnUpdateRadioDrafting(wxUpdateUIEvent& event)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	if (pApp->m_bReadOnlyAccess)
	{
		event.Enable(FALSE);
		return;
	}
	event.Enable(TRUE);
}

void CAdapt_ItView::OnRadioDrafting(wxCommandEvent& event)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	CMainFrame *pFrame = pApp->GetMainFrame();
	wxASSERT(pFrame != NULL);
	wxPanel* pControlBar;
	pControlBar = pFrame->m_pControlBar;
	wxASSERT(pControlBar);
	wxRadioButton* pDraftingBtn =
		(wxRadioButton*)pControlBar->FindWindowById(IDC_RADIO_DRAFTING);
	wxRadioButton* pReviewingBtn =
		(wxRadioButton*)pControlBar->FindWindowById(IDC_RADIO_REVIEWING);

	// whm Note: Log the action only when OnRadioDrafting() is explicitly
	// called by user clicking on the Drafting radio button, not when
	// OnRadioDrafting() is called by another function.
	if (event.GetId() == IDC_RADIO_DRAFTING)
	{
		pApp->LogUserAction(_T("Drafting selected"));
	}

	// whm modified 12Oct10 for user profiles compatibility
	if (pDraftingBtn != NULL)
	{
		pDraftingBtn->SetValue(TRUE);
	}
	if (pReviewingBtn != NULL)
	{
		pReviewingBtn->SetValue(FALSE);
	}
	pApp->m_bDrafting = TRUE;

	// ensure the Automatic checkbox is enabled
	wxCheckBox* pAuto = (wxCheckBox*)
		pControlBar->FindWindowById(IDC_CHECK_SINGLE_STEP);
	// whm modified 12Oct10 for user profiles compatibility
	if (pAuto != NULL)
	{
		pAuto->Enable(TRUE);
	}

	// restore focus to the targetBox, if it is visible
    if (pApp->m_pTargetBox != NULL)
    {
        if (pApp->m_pTargetBox->IsShown())
        {
            pApp->m_pTargetBox->SetFocusAndSetSelectionAtLanding();// whm 13Aug2018 modified
        }
    }
    pApp->RefreshStatusBarInfo();
}

// whm added 26Mar12. Disable mode bar control when read-only mode is active
void CAdapt_ItView::OnUpdateRadioReviewing(wxUpdateUIEvent& event)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	if (pApp->m_bReadOnlyAccess)
	{
		event.Enable(FALSE);
		return;
	}
	event.Enable(TRUE);
}

void CAdapt_ItView::OnRadioReviewing(wxCommandEvent& event)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	CMainFrame *pFrame = pApp->GetMainFrame();
	wxASSERT(pFrame);
	wxPanel* pControlBar;
	pControlBar = pFrame->m_pControlBar;
	wxASSERT(pControlBar != NULL);
	wxRadioButton* pDraftingBtn =
		(wxRadioButton*)pControlBar->FindWindowById(IDC_RADIO_DRAFTING);
	wxRadioButton* pReviewingBtn =
		(wxRadioButton*)pControlBar->FindWindowById(IDC_RADIO_REVIEWING);

	// whm Note: Log the action only when OnRadioReviewing() is explicitly
	// called by user clicking on the Reviewing radio button, not when
	// OnRadioReviewing() is called by another function.
	if (event.GetId() == IDC_RADIO_REVIEWING)
	{
		pApp->LogUserAction(_T("Reviewing selected"));
	}

	// whm 12Oct10 modified for user profiles compatibility
	if (pDraftingBtn != NULL)
	{
		pDraftingBtn->SetValue(FALSE);
	}
	if (pReviewingBtn)
	{
		pReviewingBtn->SetValue(TRUE);
	}
	pApp->m_bDrafting = FALSE;

	// ensure the Automatic checkbox is disabled
	wxCheckBox* pAuto = (wxCheckBox*)
		pControlBar->FindWindowById(IDC_CHECK_SINGLE_STEP);
	// whm 12Oct10 modified for user profiles compatibility
	if (pAuto != NULL)
	{
		pAuto->Enable(FALSE);
	}

	// restore focus to the targetBox, if it is visible
    if (pApp->m_pTargetBox != NULL)
    {
        if (pApp->m_pTargetBox->IsShown())
        {
            pApp->m_pTargetBox->SetFocusAndSetSelectionAtLanding();// whm 13Aug2018 modified
        }
    }
    pApp->RefreshStatusBarInfo();
}

void CAdapt_ItView::OnClearContentsButton(wxCommandEvent& WXUNUSED(event))
{
	CMainFrame *pFrame = wxGetApp().GetMainFrame();
	wxASSERT(pFrame != NULL);
	wxPanel* pComposeBar = pFrame->m_pComposeBar;
	if(pComposeBar != NULL && pComposeBar->IsShown())
	{
		wxTextCtrl* pEdit = (wxTextCtrl*)
			pComposeBar->FindWindowById(IDC_EDIT_COMPOSE);
		if (pEdit != 0)
		{
			pEdit->ChangeValue(_T(""));
			pEdit->SetFocus();
		}
	}
}

void CAdapt_ItView::OnSelectAllButton(wxCommandEvent& WXUNUSED(event))
{
	CAdapt_ItApp* pApp = &wxGetApp();
	CMainFrame *pFrame = pApp->GetMainFrame();
	wxASSERT(pFrame != NULL);
	wxPanel* pComposeBar = pFrame->m_pComposeBar;
	if(pComposeBar != NULL && pComposeBar->IsShown())
	{
		wxTextCtrl* pEdit = (wxTextCtrl*)
			pComposeBar->FindWindowById(IDC_EDIT_COMPOSE);
		if (pEdit != 0)
		{
            // whm 3Aug2018 Note: No suppression of any select all would be appropriate for 
            // the SetSelection call below as this is compose bar's 'select all'.
            pEdit->SetSelection(-1,-1);
			pApp->m_nStartChar = -1;
			pApp->m_nEndChar = -1;
			pEdit->SetFocus();
		}
	}
}

/////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \param  pDoc    ->  pointer to document class
/// \param  pStr    ->  pointer to the wxString which may have punctuation, and the
///                     punctuation is to be removed (this is done using ParseWord() so the
///                     method of stripping is consistent with how stripping is done during
///                     parsing of source text data
/// \param  nIndex  ->  selector for the punctuation string which is to be used - 0 for
///                     source, 1 for target
/// \remarks
/// Removes punctuation from the beginning and end of the passed in string, doing it in a
/// way consistent with the (U)SFM parser; does not try to store the stripped off
/// punctuation but just returns the punctuation-less string to the caller via the pointer
/// passed in
/// New version coded on 02April05 by BEW
/// BEW 12Apr10, no changes needed for support of doc version 5
/// BEW 11Oct10, changed to use the new version of ParseWord() and added support for
/// stripping from a conjoined pair using ~ fixedspace symbol
/// BEW 21Jul14, for ZWSP support - changes needed
/// BEW 19Feb2020 Various refactorings to handle things like you[sg] or you(sg)
/// as target text, whether or not src punctuation is to follow, and whether or
/// or not ( ) [ and ] are punctuation characters. (Initiated by Roland Fumey's problems)
/// 
/// BEW 3Feb24 refactoring to remove use of ParseWord(), remove support for special handling
/// for ( ) [ and ] - these go according to whether they are puncts listed, or not listed, and
/// so are removed, or retained, respectively. Also removing fixed space ( ~ ) conjoining 
/// support, because ~ is NOT a punctuation character and we no longer separate a conjoined
/// pair of words into two parts. These changes were prompted by the fact that 
/// File > Restore Knowledge Base's code makes an utter mess of a good KB - destroying the
/// meanings of every entries target text.
/// BEW 29May24 Refactored to call a new version of SmartTokenize() that strips puncts from
/// it's internal tokenizing function's output, from substrings "aToken", when filling the
/// internal array. SmartTokenize() is called in 19 places in the app currently, but only
/// here is it vital to strip puncts of each aToken substring, and currently it does not happen
/// and must. So a new version will take in the spaceless puncts string, and use it to remove
/// puncts, if any, that are attached to the internal tokenizer's aToken substrings
/// /////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItView::RemovePunctuation(CAdapt_ItDoc* pDoc, wxString* pStr, int nIndex)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	if (pStr->IsEmpty())
	{
		return;
	}
	wxUnusedVar(pDoc);

	wxString spacelessPunctsStr = wxEmptyString;
	//int offset = wxNOT_FOUND;
	wxString str = *pStr; // get a convenient local copy
	wxString word1 = wxEmptyString; // could be a phrase, of course i.e. spaces allowed
	wxString phrase = wxEmptyString;
	bool bTgtPuncts = nIndex == 1 ? TRUE : FALSE;
	if (bTgtPuncts) // BEW 29May24 moved this determination of spacelessPunctsStr to here, instead of after SmartTokenize()
	{
		spacelessPunctsStr = pApp->m_strSpacelessTargetPuncts;
	}
	else
	{
		spacelessPunctsStr = pApp->m_strSpacelessSourcePuncts;
	}

	wxArrayString wordsArr; // auto initialises to empty
	wxString delimiters = _T(" "); // delimit using Latin space, we want an array of words (with their 
								   // puncts attached, if present)
	bool bStoreEmptyStringsToo = FALSE;
	long numWords = SmartTokenize(delimiters, str, wordsArr, spacelessPunctsStr, nIndex, bStoreEmptyStringsToo);
	if (numWords > 1)
	{
		// set the phrase for potential call of its value further down
		phrase = *pStr;
	}
	
	if (numWords > 1) // was a test for bHasFixedSpaceSymbol which is no longer relevant
	{
		// it's a phrase - this will require a processing loop here for the individual words
		wxLogDebug(_T("RemovePunctuation() line %d , phrase= [%s]  numWords= %d"), __LINE__, phrase.c_str(), (int)numWords);

		// Here handle when wordsArr contains a space-delimited phrase of 2 or more words
		int nEntriesCount = wordsArr.GetCount();
		wxASSERT(nEntriesCount > 1);
		wxString strAccumulate = wxEmptyString;
		wxString space = _T(" ");
		int index;
		wxString aSubstring = wxEmptyString;
		for (index = 0; index < nEntriesCount; index++)
		{
			aSubstring = wordsArr.Item(index);
			if (!aSubstring.IsEmpty())
			{
				strAccumulate += aSubstring + space;
			}
		}
		strAccumulate.Trim(); // remove the final space at phrase end
		*pStr = strAccumulate;
	}
	else
	{
		// not a phrase, so test for no punctuation, if there is none, then we can return immediately,
		// otherwise remove from before or after or both, then return
		wxString oneWord = *pStr;
		oneWord = RemovePunctuationOnOneWord(oneWord, spacelessPunctsStr, nIndex);
		*pStr = oneWord;
	} // end of else block for test: if (numWords > 1)

	wxUnusedVar(bTgtPuncts); // LOG_RESTORE is #defined at line 657 in Adapt_ItView.cpp
	if (bTgtPuncts)
	{
#if defined (_DEBUG) && defined (LOG_RESTORE)
		wxLogDebug(_T("RemovePunctuation() line %d , removing from TARGET string= [%s]"), __LINE__, (*pStr).c_str());
#endif
	}
	else
	{
#if defined (_DEBUG) && defined (LOG_RESTORE)
		wxLogDebug(_T("RemovePunctuation() line %d , removing from SOURCE string= [%s]"), __LINE__, (*pStr).c_str());
#endif
	}
}

// nIndex = 0 for src, 1 for tgt -- nIndex will be the way to handle any processsing difference that requires
// knowing whether the caller is dealing with source text (nIndex is 0) or target text (nIndex is 1)
wxString CAdapt_ItView::RemovePunctuationOnOneWord(wxString oneWord, wxString spacelessPunctsStr, int nIndex)
{
	wxString word1 = oneWord;
	CAdapt_ItApp* pApp = &wxGetApp();
	if (word1.IsEmpty())
	{
		return oneWord;
	}
	wxUnusedVar(pApp);
	wxChar* ptr;
	wxChar* pEnd;
	bool bTgtPuncts = nIndex == 1 ? TRUE : FALSE; // I'll leave this here, and keep the formal param nIndex
		// but don't really need it, except for logging whether or not it's target text - and I'll do that in caller
	int offset = wxNOT_FOUND;
	wxString strFinal = wxEmptyString; // return resulting string with no puncts before or after word/s, in this 

	wxString tempStr = wxEmptyString; // to hold parsed over puncts before they get thrown away
	//wxLogDebug(_T("RemovePunctuation() line %d , initial string= [%s]"), __LINE__, word1.c_str());

	// Remove pre-word punctuation. We do so by parsing here over any initial puncts,
	// put them in tempStr, get its length, and use that to advance ptr to point past them 
	const wxChar* pBuffStart = word1.GetData();
	ptr = (wxChar*)pBuffStart;
	pEnd = ptr + word1.Length(); // points to null

	// Note, protect source text which is a placeholder, it has the string _T("...") and we
	// must not remove those periods. We advance ptr past them by returning _T("...")
	if (bTgtPuncts == FALSE)
	{
		// dealing with source text
		if (word1 == _T("..."))
		{
			return word1;
		}
	}

	// This loop removes initial puncts. (For any puncts at end of word1, do another loop
	// over a reversal of word1 - (word1 will be shortened if some were found)
	do {
		offset = spacelessPunctsStr.Find(*ptr);
		if (offset != wxNOT_FOUND)
		{
			tempStr += *ptr;
		}
		else
		{
			// ptr is not pointing to a punctuation character, so it's
			// time to break out of the loop
			break;
		}
		ptr++;
	} while (ptr < pEnd);
	// If some pre-word puncts were found, now shorten word1 to not have them. Be careful,
	// a sequence of one or more puncts with no "word" content, would be reduced to an
	// empty string - we need to protect against getting hung up in an infinite loop.
	if (tempStr == word1)
	{
		// The string was just punctuation characters, so return these to avoid any
		// possibility of an infinite loop
		return word1;
	}
	else
	{
		// There is non-punctuation content after one or more initial puncts, so
		// shortent word1 to not have those initial puncts
		int nTempLen = tempStr.Length();
		word1 = word1.Mid(nTempLen);
		wxASSERT(!word1.IsEmpty());

		// Now reverse word1, and do the same process to remove any post-word punctuation
		word1 = MakeReverse(word1);

		const wxChar* pBuffStart = word1.GetData();
		ptr = (wxChar*)pBuffStart;
		pEnd = ptr + word1.Length(); // points to null

		// This loop removes final puncts. (Temporarily at the reversed string's beginning)
		tempStr.Empty();
		do {
			offset = spacelessPunctsStr.Find(*ptr);
			if (offset != wxNOT_FOUND)
			{
				tempStr += *ptr;
			}
			else
			{
				// ptr is not pointing to a punctuation character, so it's
				// time to break out of the loop
				break;
			}
			ptr++;
		} while (ptr < pEnd);
		// Shorten
		nTempLen = tempStr.Length();
		word1 = word1.Mid(nTempLen);
		wxASSERT(!word1.IsEmpty());
		word1 = MakeReverse(word1); // restore normal order
	}
	return word1;
}

// BEW added 19Feb20 Look for what comes from the KB which should, in a correctly
// formed m_targetStr member of the current CSourcePhrase instance, have the final
// ] or ) restored, since the KB will have stored the KB entry with either of these
// stripped off, providing they are punctuation rather than word-building. This
// is needed because data like you[sg] or you(sg) when typed as target text will
// provide a final punctuation character unknown to the KB and not recoverable by
// copying from the sourc text which will, of course, lack it - since tgt data of
// this kind is only known by what the user types into m_pTargetPhrase phrasebox.
// We therefore search back in the input string to find an unmatched ( or [, and 
// if successful we return the ) or ] to the caller in the returned wxString, 
// where it can be appended to what was passed in, in the appropriate place -
// that is, where pSrcPhrase->m_targetStr gets rebuilt - see comment below.
// If the function determines that the missing ending ] or ) is already present,
// then return an empty string to the caller.
// 
// BEW 12Oct22 because of data like: you[sg] or you(sg), we need to keep this.
// This function is called only in MakeTatgetStringIncludingPunctuation() in two
// places. Where is is going wrong was for detached [ in m_key and m_srcPhrase,
// it was providing a ] which was absolutely not wanted - we have a refactored
// solution for [ and ], this function should not war against that. My solution is
// that this function should not return a matching ] (I'll leave ) unchanged) when
// there is no text following the [ passed in, but just return an empty string
wxString CAdapt_ItView::ProvideMatchingEndBracketOrParenthesis(wxString keyTgtText)
{
	CAdapt_ItApp* pApp = &wxGetApp();

	// BEW 19Feb20 get a pointer to the current active CSourcePhrase instance, which
	// may or may not have stored source text punctuation in it's m_follPunct member.
	// The passed in pStr pointer may introduce new 'following' punctuation (such
	// as ] or ) if these are listed as punctuation characters) in addition to what
	// is already in m_follPunct; and we will have to identify further below if that
	// is the case; and if so, 
	// [[and because of how the parser works from both ends inwards, ]] <- BEW 6Feb23: this line is no longer true
	// any new punctuation not already in the active CSourcePhrase instance
	// will need to be inserted prior to whatever is already in the active instance's
	// m_follPunct member. Failing to do this results in an xml doc file which lacks
	// that additional punctuation,and hence a doc error of parsing. The addition
	// of any final ] or ) needs to be done in the view's public function:
	// 
	// BEW 6Feb23 it is no longer the case that we parse in from both ends. We parse from
	// left to right now. We do NOT want to try provide a matching ), } or ] when there is
	// one of { , ( or [  occurring word-initially; as this matching function is for things
	// like word(1sg) or word(some phrase), not (word  for example which would be an attempt
	// to override something like word  -- with no final punctuation, with (word   -- with
	// still no final punctuation. To make this work, I think I only need change the .Find()
	// calls to check for offset == 0, rather than >= 0  within this function, and if == 0, then
	// return without attempting a match.
	// This function is called from:
	// MakeTargetStringIncludingPunctuation(CSourcePhrase* pSrcPhrase, wxString targetStr);

	// BEW 25Oct22 added this check. keyTgtText might be empty (e.g. it may have been user-declared
	// as a <Not In KB> entry. If this is so, I need to check here and if empty, then immediately 
	// return an empty string to the caller. Failure to do that in the above circumstance results
	// in a wx assert being tripped. So do a sanity check here...
	if (keyTgtText.IsEmpty())
	{
		return keyTgtText;
	}
	wxString s = keyTgtText;
	wxString strToReturn = wxEmptyString; // initialize to empty
	wxString strLeftBracket(_T('['));

	// BEW 12Oct22 check for just [ passed in. If so, return the empty string; 28Oct22 add empty string protection?
	// No need, KeyTgtText has been checked above, an is non-empty; so got assigned that non-empty string, so
	// GetChar(0) is safe to do.
	wxChar firstChar = s.GetChar(0);
	int sLen = s.Length();
	if ((firstChar == _T('[')) && sLen == 1)
	{
		return strToReturn; // empty string
	}
	
	// BEW 18Feb20 check if [ and ] and { and } are punctuation characters, 
	// or word-building, and same for ( and )

	wxString strRightBracket(_T(']'));
	bool bLeftBracketIsPunct = FALSE;
	bool bRightBracketIsPunct = FALSE;
	int offset = wxNOT_FOUND;
	offset = pApp->m_strSpacelessTargetPuncts.Find(strLeftBracket);
	if (offset >= 0)
	{
		bLeftBracketIsPunct = TRUE;
	}
	offset = pApp->m_strSpacelessTargetPuncts.Find(strRightBracket);
	if (offset >= 0)
	{
		bRightBracketIsPunct = TRUE;
	}

    wxUnusedVar(bRightBracketIsPunct);

	// Now for ( and )
	wxString strLeftParenthesis(_T('('));
	wxString strRightParenthesis(_T(')'));
	bool bLeftParenthesisIsPunct = FALSE;
	bool bRightParenthesisIsPunct = FALSE;
	offset = wxNOT_FOUND;
	offset = pApp->m_strSpacelessTargetPuncts.Find(strLeftParenthesis);
	if (offset >= 0)
	{
		bLeftParenthesisIsPunct = TRUE;
	}
	offset = pApp->m_strSpacelessTargetPuncts.Find(strRightParenthesis);
	if (offset >= 0)
	{
		bRightParenthesisIsPunct = TRUE;
	}

    wxUnusedVar(bRightParenthesisIsPunct);

	// Now for { and }
	wxString strLeftBrace(_T('{'));
	wxString strRightBrace(_T('}'));
	bool bLeftBraceIsPunct = FALSE;
	bool bRightBraceIsPunct = FALSE;
	offset = wxNOT_FOUND;
	offset = pApp->m_strSpacelessTargetPuncts.Find(strLeftBrace);
	if (offset >= 0)
	{
		bLeftBraceIsPunct = TRUE;
	}
	offset = pApp->m_strSpacelessTargetPuncts.Find(strRightBrace);
	if (offset >= 0)
	{
		bRightBraceIsPunct = TRUE;
	}

    wxUnusedVar(bRightBraceIsPunct);

	// =============== Now do the providing of match character ===========

	wxString reversedStr;
	offset = wxNOT_FOUND; // -1, initialize
	if (bLeftParenthesisIsPunct) // '(' is a punctuation character, rather than a word-building one
	{
		// search for a "(" in the s string
		offset = s.Find(strLeftParenthesis);
		// BEW 6Feb23 if offset is 0, then '(' is word initial, so don't try to match with a word-ending ')'
		if (offset == 0)
		{
			return strToReturn = wxEmptyString;
		}
		if (offset > 0)
		{
			// There is a ( non-initial in s string, so check if there is a matching
			// ) at the end of s. Note, data like ([ ... ]) would be a problem for our algorithm.
			// We assume there is either (....) or [....], but not immediate nesting of one in 
			// the other; but non-immediate nesting should be ok. I.e. things like text[text(text)text]
			// should get handled okay, similarly for here, such as: text(text[text]text)
			reversedStr = MakeReverse(s);
			offset = reversedStr.Find(strRightParenthesis);
			if (offset != 0)
			{
				// There is no matching ) at s string's end. So provide it. Otherwise,
				// there is, so return strToReturn as an empty string;
				strToReturn = _T(")");
				return strToReturn;
			}
		} // end of TRUE block for test: if (offset != wxNOT_FOUND)
	} // end of TRUE block for test: if (bLeftParenthesisIsPunct)


	// There was no ( found, so check out is s string has a '[' opening bracket
	// instead
	if (bLeftBracketIsPunct) // '[' is a punctuation character, rather than a word-building one
	{
		// search for a "[" in the s string
		offset = s.Find(strLeftBracket);
		// BEW 6Feb23 if offset is 0, then '[' is word initial, so don't try to match with a word-ending ']'
		if (offset == 0)
		{
			return strToReturn = wxEmptyString; // unchanged
		}
		if (offset > 0)
		{
			// There is a [ non-initial in s string, so check if there is a matching
			// ] at the end of s. Note, data like [( ... )] would be a problem for our algorithm.
			// We assume there is either (....) or [....], but not immediate nesting of one in 
			// the other; but non-immediate nesting should be ok. I.e. things like text[text(text)text]
			// should get handled okay, similarly text(test[text]text)

			reversedStr = MakeReverse(s);
			offset = reversedStr.Find(strRightBracket);
			if (offset != 0)
			{
				// There is no matching ] at s string's end. So provide it. Otherwise,
				// there is, so return strToReturn as an empty string;
				strToReturn = _T("]");
				return strToReturn;
			}
		} // end of TRUE block for test: if (offset != wxNOT_FOUND)
	} // end of TRUE block for test: if (bLeftBracketIsPunct)

	  // There was no [ found, so check out is s string has a '{' opening brace
	  // instead
	if (bLeftBraceIsPunct) // '{' is a punctuation character, rather than a word-building one
	{
		// search for a "{" in the s string
		offset = s.Find(strLeftBrace);
		// BEW 6Feb23 if offset is 0, then '{' is word initial, so don't try to match with a word-ending '}'
		if (offset == 0)
		{
			return strToReturn = wxEmptyString; // unchanged
		}
		if (offset > 0)
		{
			// There is a { non-initial in s string, so check if there is a matching
			// } at the end of s. Note, data like {( ... )} would be a problem for our algorithm.
			// We assume there is either (....) or [....] or {...}, but not immediate nesting 
			// of one in the other; but non-immediate nesting should be ok. I.e. things like 
			// text{text(text)text} should get handled okay, similarly test(test[text]text) etc

			reversedStr = MakeReverse(s);
			offset = reversedStr.Find(strRightBrace);
			if (offset != 0)
			{
				// There is no matching } at s string's end. So provide it. Otherwise,
				// there is, so return strToReturn as an empty string;
				strToReturn = _T("}");
			}
		} // end of TRUE block for test: if (offset != wxNOT_FOUND)
	} // end of TRUE block for test: if (bLeftBraceIsPunct)

	return strToReturn; // return empty string if neither block supplies anything
}

// The copy could be from several places, so these are prioritized. First, if the compose
// box has a selection and has the focus, it is done from there; but if not, then next in
// priority is a selection of source phrases - if such a selection is current, then the
// m_targetStr fields are accumulated as a phrase & copied to the clipboard; if not, the
// phrase box contents is taken, provided it has the focus; if none of these, then nothing
// is copied.
void CAdapt_ItView::OnEditCopy(wxCommandEvent& WXUNUSED(event))
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);

	// get the window which has the current focus
	wxWindow* pWnd = wxWindow::FindFocus(); // gets a CTempWnd
	CMainFrame *pFWnd = wxGetApp().GetMainFrame();
	if (pFWnd == NULL)
	{
		wxMessageBox(_T(
		"Failure to obtain pointer to the frame window in OnEditCopy\n"),
		_T(""), wxICON_EXCLAMATION | wxOK);
		return;
	}
	wxPanel* pBar = pFWnd->m_pComposeBar;
	if (pBar == NULL)
	{
		wxMessageBox(_T("Failure to obtain pointer to the Compose Bar in OnEditCopy\n"),
		_T(""), wxICON_EXCLAMATION | wxOK);
		return;
	}
	wxTextCtrl* pEdit = (wxTextCtrl*)pBar->FindWindowById(IDC_EDIT_COMPOSE);
	if (pEdit == NULL)
	{
		wxMessageBox(_T(
		"Failure to obtain pointer to the Compose Bar's wxTextCtrl control in OnEditCopy\n"),
		_T(""), wxICON_EXCLAMATION | wxOK);
		return;
	}

	// In the wxWidgets version the m_pcomposeBar pointer always exists. The toggle
	// from the view menu merely shows or hides the composeBar. In MFC version the
	// compose bar is recreated each time it becomes visible. Hence, I'll add the
	// condition check to ensure the text control in the composeBar IsShown()
	if (pWnd == pEdit && pEdit->IsShown())
	{
		pEdit->Copy(); // copy to the clipboard using wxTextCtrl's built in function
                       // (CF_TEXT format, or CF_UNICODETEXT for the Unicode version)
		return;
	}

	if (pApp->m_selectionLine == 0)
	{
		// this has priority, ie. if there is or are sourcePhrase(s) selected
		// BEW 21Jul14 refactored this for ZWSP support 
		DoSrcPhraseSelCopy();
	}
	else
	{
	    // BEW 29Nov12 In Ubuntu Unity, pEdit2->Copy() is not getting the wxTextCtrl's text
	    // on to the clipboard, because using the menu bar which Unity stole does this:
	    // 1st, focus drifts back to phrase box from composebar's text ctrl unbidden and
	    // before any of our handlers are invoked,
	    // 2nd, a selection in compose bar's text ctrl becomes a cursor position within or at
	    // the end of the selection or at its start, depending on how user dragged; and that
	    // results in an empty string going to the clipboard. Cut is similarly damaged.
	    // But CTRL+C and CTRL+V appear to work correctly. There's no workaround except to
		// refrain from using Unity interface in Precise Pangolin. (BEW 24Jan13, the
		// problem goes away if the Unity 'global menu' feature is uninstalled - I did so;
		// or it can be disabled on a per-app basis, but this is too tricky for me to bother.)
        wxTextCtrl* pEdit2 = pApp->m_pTargetBox->GetTextCtrl(); // whm 14Feb2018 added ->GetTextCtrl()
        if (pEdit2 == pWnd)
        {
            pEdit2->Copy();
        }
	}
}

/////////////////////////////////////////////////////////////////////////////////
/// \return		nothing
/// \param      event   -> the wxUpdateUIEvent that is generated when the Edit Menu
///                        is about to be displayed
/// \remarks
/// Called from: The wxUpdateUIEvent mechanism when the associated menu item is selected,
/// and before the menu is displayed.
/// If the App's m_pActivePile is NULL this handler disables the "Copy" item in the Edit
/// menu and immediately returns.
/// It enables the "Copy" item on the Edit menu if there is a valid selection in either the
/// composeBar's edit box, the targetBox, or a source phrase selection, otherwise it
/// disables the menu item.
/////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItView::OnUpdateEditCopy(wxUpdateUIEvent& event)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	if (pApp->m_pActivePile == NULL)
	{
		event.Enable(FALSE);
		return;
	}
	bool bComposeSel = FALSE;
	CMainFrame *pFWnd = wxGetApp().GetMainFrame();
	if (pFWnd == NULL)
	{
		event.Enable(FALSE);
		return;
	}
	wxPanel* pBar = pFWnd->m_pComposeBar;
	if (pBar == NULL)
	{
		event.Enable(FALSE);
		return;
	}
	wxTextCtrl* pEdit = (wxTextCtrl*)pBar->FindWindowById(IDC_EDIT_COMPOSE);
	if (pEdit == NULL)
	{
		event.Enable(FALSE);
		return;
	}
	// Protect against idle time update menu handler action at app shutdown 
	// time, when piles no longer exist - we must prevent pile access then
	if (pApp->GetLayout()->GetPileList() == NULL ||
		pApp->GetLayout()->GetPileList()->IsEmpty())
	{
		event.Enable(FALSE);
		return;
	}
	long nStartChar1; long nEndChar1;
	pEdit->GetSelection(&nStartChar1,&nEndChar1);
	bComposeSel = nStartChar1 != nEndChar1;

	bool bTargetBoxSel = FALSE;
	long nStartChar; long nEndChar;
	if (pApp->m_pTargetBox != NULL)
		if (pApp->m_pTargetBox->IsShown())
		{
			pApp->m_pTargetBox->GetTextCtrl()->GetSelection(&nStartChar,&nEndChar);
			bTargetBoxSel = nStartChar != nEndChar;
		}

	bool bSrcPhraseSel = FALSE;
	if (pApp->m_selectionLine == 0)
		bSrcPhraseSel = TRUE;

	event.Enable(bComposeSel || bTargetBoxSel || bSrcPhraseSel);
}

void CAdapt_ItView::OnEditPaste(wxCommandEvent& WXUNUSED(event))
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	wxWindow* pWnd = wxWindow::FindFocus(); // gets a CTempWnd
	CMainFrame *pFWnd = wxGetApp().GetMainFrame();
	if (pFWnd == NULL)
	{
		wxMessageBox(_T(
		"Failure to obtain pointer to the frame window in OnEditPaste\n"),
		_T(""), wxICON_EXCLAMATION | wxOK);
		return;
	}
	wxPanel* pBar = pFWnd->m_pComposeBar;
	if (pBar == NULL)
	{
		wxMessageBox(_T(
		"Failure to obtain pointer to the Compose Bar in OnEditPaste\n"),
		_T(""), wxICON_EXCLAMATION | wxOK);
		return;
	}
	wxTextCtrl* pEdit = (wxTextCtrl*)pBar->FindWindowById(IDC_EDIT_COMPOSE);
	if (pEdit == NULL)
	{
		wxMessageBox(_T(
		"Failure to obtain pointer to the Compose Bar's wxTextCtrl control in OnEditPaste\n"),
		_T(""), wxICON_EXCLAMATION | wxOK);
		return;
	}
    // In the wxWidgets version the m_pcomposeBar pointer always exists. The toggle from
    // the view menu merely shows or hides the composeBar. In MFC version the compose bar
    // is recreated each time it becomes visible. Hence, I'll add the condition check to
    // ensure the text control in the composeBar IsShown()
	if (pWnd == pEdit && pEdit->IsShown())
	{
		// paste from the clipboard using wxTextCtrl's built in function (CF_TEXT format
		// or CF_UNICODETEXT for Unicode version)
		pEdit->Paste();
	}

	if (pApp->m_pTargetBox->GetHandle() != NULL)
		if (pApp->m_pTargetBox->IsShown() && (pApp->m_pTargetBox->GetTextCtrl() == pWnd)) // whm 12Jul2018 added GetTextCtrl()-> part
		{
			DoTargetBoxPaste(pApp->m_pActivePile);
		}
}

/////////////////////////////////////////////////////////////////////////////////
/// \return		nothing
/// \param      event   -> the wxUpdateUIEvent that is generated when the Edit Menu
///                        is about to be displayed
/// \remarks
/// Called from: The wxUpdateUIEvent mechanism when the associated menu item is selected,
/// and before the menu is displayed.
/// If the App's main frame pointer is NULL, or the composeBar is NULL, or the composeBar's
/// edit box is NULL, or both the composeBar and targetBox are not shown this handler
/// disables the "Paste" item in the Edit menu and immediately returns.
/// It enables the "Paste" item on the Edit menu if either the composeBar's edit box is
/// shown or the targetBox is shown, otherwise it disables the menu item.
/// BEW altered 29nov12; in Ubuntu Unity, the app's menu bar is taken over by Unity. This
/// has the unfortunate effect of removing focus from the phrase box when the user clicks
/// the Edit menu to get at the Paste item. So I've made a kludge for __WXGTK__ compile
/// which uses two booleans on the app class, m_bTargetBoxHadFocusLast and
/// m_bComposeBarTextCtrlHadFocusLast, which get set TRUE (and the other FALSE) by an
/// OnSetFocus() event in either the PhraseBox or the ComposeBar's wxTextCtrl. The
/// OnUpdateEditPaste() handler then uses these rather than relying on the focus remaining
/// in the text control when the coopted menu bar is clicked to access the Edit menu. It works.
/////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItView::OnUpdateEditPaste(wxUpdateUIEvent& event)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);

	// whm added 26Mar12. Disable the tool bar button when in read-only mode.
	if (pApp->m_bReadOnlyAccess)
	{
		event.Enable(FALSE);
        //wxLogDebug(_T("OnUpdateEditPaste #1 disabled"));
		return;
	}

	bool bComposeWnd = FALSE;

	wxWindow* pFocusWnd = wxWindow::FindFocus(); // gets a CTempWnd
	CMainFrame *pFWnd = wxGetApp().GetMainFrame();
	if (pFWnd == NULL)
	{
		event.Enable(FALSE);
        //wxLogDebug(_T("OnUpdateEditPaste #2 disabled"));
		return;
	}
	wxPanel* pBar = pFWnd->m_pComposeBar;
	if (pBar == NULL)
	{
		event.Enable(FALSE);
        //wxLogDebug(_T("OnUpdateEditPaste #3 disabled"));
		return;
	}
	wxTextCtrl* pEdit = (wxTextCtrl*)pBar->FindWindowById(IDC_EDIT_COMPOSE);
	if (pEdit == NULL)
	{
		event.Enable(FALSE);
        //wxLogDebug(_T("OnUpdateEditPaste #4 disabled"));
		return;
	}
	bool bTargetBox = FALSE;

	// In the wxWidgets version the m_pcomposeBar pointer always exists. The toggle
	// from the view menu merely shows or hides the composeBar. In MFC version the
	// compose bar is recreated each time it becomes visible. Hence, I'll add the
	// condition check to ensure the text control in the composeBar IsShown()
	if (pFocusWnd == pEdit && pEdit->IsShown())
	{
		bComposeWnd = TRUE;
	}
	if (pApp->m_pTargetBox != NULL)
	{
		bTargetBox = (pApp->m_pTargetBox->IsShown()) && (pApp->m_pTargetBox->GetTextCtrl() == pFocusWnd); // whm 12Jul2018 added GetTextCtrl()-> part
	}
	// remove commenting out to see the problem the Unit interface in Precise Pangolin
	// causes, Paste is disabled because focus wanders away from the text ctrl
	event.Enable(bComposeWnd || bTargetBox);
}

void CAdapt_ItView::OnEditCut(wxCommandEvent& WXUNUSED(event))
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	// get the window which has the current focus
	wxWindow* pWnd = wxWindow::FindFocus(); // gets a CTempWnd
	CMainFrame *pFWnd = wxGetApp().GetMainFrame();
	if (pFWnd == NULL)
	{
		wxMessageBox(_T(
		"Failure to obtain pointer to the frame window in OnEditCut\n"),
		_T(""), wxICON_EXCLAMATION | wxOK);
		return;
	}
	wxPanel* pBar = pFWnd->m_pComposeBar;
	if (pBar == NULL)
	{
		wxMessageBox(_T(
		"Failure to obtain pointer to the Compose Bar in OnEditCut\n"),
		_T(""), wxICON_EXCLAMATION | wxOK);
		return;
	}
	wxTextCtrl* pEdit = (wxTextCtrl*)pBar->FindWindowById(IDC_EDIT_COMPOSE);
	if (pEdit == NULL)
	{
		wxMessageBox(_T(
		"Failure to obtain pointer to the Compose Bar's wxTextCtrl control in OnEditCut\n"),
		_T(""), wxICON_EXCLAMATION | wxOK);
		return;
	}
    // In the wxWidgets version the m_pcomposeBar pointer always exists. The toggle from
    // the view menu merely shows or hides the composeBar. In MFC version the compose bar
    // is recreated each time it becomes visible. Hence, I'll add the condition check to
    // ensure the text control in the composeBar IsShown()
	if (pWnd == pEdit && pEdit->IsShown())
		pEdit->Cut(); // cut to the clipboard using wxTextCtrl's built in function
					  // (CF_TEXT format)

	wxTextCtrl* pEdit2 = pApp->m_pTargetBox->GetTextCtrl(); // whm 14Feb2018 added ->GetTextCtrl()
	if (pEdit2 == pWnd)
	{
		pEdit2->Cut();

        // the phrase box now has different text, but pApp->m_targetPhrase still has the
        // uncut text, so to prevent the cut text from reappearing on the pile, we must put
        // the text remaining in the phrase box's "title" into pApp->m_targetPhrase;
		wxString text;
		text = pEdit2->GetValue();
		pApp->m_targetPhrase = text; // now it agree's with the window contents for the box
	}
}

/////////////////////////////////////////////////////////////////////////////////
/// \return		nothing
/// \param      event   -> the wxUpdateUIEvent that is generated when the Edit Menu
///                        is about to be displayed
/// \remarks
/// Called from: The wxUpdateUIEvent mechanism when the associated menu item is selected,
/// and before the menu is displayed.
/// If the App's main frame is NULL, or the composeBar is NULL, or the composeBar's edit
/// box is NULL, or neither the composeBar nor targetBox have a selection, this handler
/// disables the "Cut" item in the Edit menu, otherwise it enables the "Cut" item on the
/// Edit menu.
/////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItView::OnUpdateEditCut(wxUpdateUIEvent& event)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);

	// whm added 26Mar12 for read-only mode
	if (pApp->m_bReadOnlyAccess)
	{
		event.Enable(FALSE);
		return;
	}

	bool bComposeSel = FALSE;
	CMainFrame *pFWnd = wxGetApp().GetMainFrame();
	if (pFWnd == NULL)
	{
		//wxMessageBox(_T("Failure to obtain pointer to the frame window in OnUpdateEditCut\n"),
		//	_T(""), wxICON_EXCLAMATION | wxOK);
		event.Enable(FALSE);
		return;
	}
	wxPanel* pBar = pFWnd->m_pComposeBar;
	if (pBar == NULL)
	{
		//wxMessageBox(_T("Failure to obtain pointer to the Compose Bar in OnUpdateEditCut\n"),
		//	_T(""), wxICON_EXCLAMATION | wxOK);
		event.Enable(FALSE);
		return;
	}
	wxTextCtrl* pEdit = (wxTextCtrl*)pBar->FindWindowById(IDC_EDIT_COMPOSE);
	if (pEdit == NULL)
	{
		//wxMessageBox(_T(
		//	"Failure to obtain pointer to the Compose Bar's wxTextCtrl control in OnUpdateEditCut\n"),
		//	_T(""), wxICON_EXCLAMATION | wxOK);
		event.Enable(FALSE);
		return;
	}
	long nStartChar; long nEndChar;
	pEdit->GetSelection(&nStartChar,&nEndChar);
	bComposeSel = nStartChar != nEndChar;

	bool bTargetBoxSel = FALSE;
	long nStartChar1; long nEndChar1;
	if (pApp->m_pTargetBox != NULL)
		if (pApp->m_pTargetBox->IsShown())
		{
			pApp->m_pTargetBox->GetTextCtrl()->GetSelection(&nStartChar1,&nEndChar1);
			bTargetBoxSel = nStartChar1 != nEndChar1;
		}


	event.Enable(bComposeSel || bTargetBoxSel);
}

// returns previous source phrase's pointer, or null if there is no previous one
CSourcePhrase* CAdapt_ItView::GetPrevSrcPhrase(SPList::Node*& curPos,SPList::Node*& posPrev)
{
	wxASSERT(curPos != NULL);
	SPList::Node* pos_pList = curPos;
	CSourcePhrase* pSrcPhrase = (CSourcePhrase*)pos_pList->GetData();
	pos_pList = pos_pList->GetPrevious();
	if (pos_pList != NULL)
	{
		posPrev = pos_pList; // this is the previous position
		pSrcPhrase = (CSourcePhrase*)pos_pList->GetData();
		pos_pList = pos_pList->GetPrevious();
		wxASSERT(pSrcPhrase);
		return pSrcPhrase;
	}
	else
	{
		posPrev = (SPList::Node*)NULL;
		return (CSourcePhrase*)0;
	}
}

int CAdapt_ItView::GetSelectionWordCount()
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	if (pApp->m_selectionLine == -1)
		return 0; // no selection
	int nCount = 0;
	CCellList::Node* pos_pCellList = pApp->m_selection.GetFirst();
	wxASSERT(pos_pCellList != NULL);
	while (pos_pCellList != NULL)
	{
		CCell* pCell = (CCell*)pos_pCellList->GetData();
		nCount += pCell->GetPile()->GetSrcPhrase()->m_nSrcWords;
		pos_pCellList = pos_pCellList->GetNext();
	}
	return nCount;
}

CKB* CAdapt_ItView::GetKB()
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);

	if (gbIsGlossing)
		return pApp->m_pGlossingKB;
	else
		return pApp->m_pKB;
}

/////////////////////////////////////////////////////////////////////////////////
/// \return     a wxString representing a copy of the m_key member (which has punctuation
///             stripped off) of pSrcPhrase after m_key has been modified by Consistent Changes
///             (if m_bUseConsistentChanges is TRUE) or by SIL Converters (if m_bUseSilConverter
///             if TRUE) or by the Guesser (if m_bUseAdaptationsGuesser is TRUE)
/// \param      pSrcPhrase              -> the source phrase from which the m_key is copied
/// \param      bUseConsistentChanges   -> flag indicating if Consistent Changes is required
/// \remarks
/// Called from: The CopySourceKey() function is called from the View's PlacePhraseBox(),
/// OnButtonToEnd(), OnButtonToStart(), OnButtonStepDown(), OnButtonStepUp(),
/// OnButtonMerge(), OnButtonRestore(), RestoreTargetBoxText(),
/// JumpForwardToNote_CoreCode(), and JumpBackwardToNote_CoreCode(); and CSourcePhrase's
/// MoveToNextPile(), MoveToPrevPile() and MoveToImmedNextPile().
/// CopySourceKey() is generally only called when the m_bCopySource flag is TRUE and when
/// the m_targetPhrase is empty, because there is no matching translation available from
/// the KB or no previous target phrase has been entered. CopySourceKey() returns the
/// source word or phrase (possibly merged) in a pre-processed form which constitutes a
/// first guess for what might be wanted as a target text in the phrase box. This guess
/// starts as the m_key member of the CSourcePhrase object (which is the form without any
/// punctuation). CopySourceKey() applies any necessary modifications as the result of
/// Consistent Changes (if m_bUseConsistentChanges is TRUE) or any modifications made by
/// SIL Converters (if m_bUseSilConverter if TRUE) before returning the final string to the
/// caller. The Guesser cannot be used if the SIL Converters is being used.
/// Also, the Guesser can be used only if Consistent Changes is not being used
/// OR if it is being used AND m_bAllowGuesseronUnchangedCCOutput was set to true by the
/// administrator checking the appropriate checkbox in the GuesserSettingsDlg.
/// CopySourceKey() is the primary place where Consistent Changes are done, where the SIL
/// Converter changes are done and where Guesser changes are done within the Adapt It
/// application. See also DoTargetBoxPaste() for where these operations can also take
/// place.
/// BEW 25May13, altered so as not to copy source text to the phrasebox when the phrase
/// box as landed at a hole; this is needed only for Find dialog searching in src text, so
/// that condition is gbFind == TRUE, and the "hole" condition is pSrcPhrase->m_adaption
/// is empty
/// BEW 9Sep22 refactored, for better behaviour in glossing mode. Glossing mode should
/// NEVER grab a source text word, now that the glossing KB uses entries of type:
/// m_adaption/m_gloss  So the best thing to do when the phrasebox lands at a glossing
/// "hole", if there is no gloss available in the glossing KB, then just leave the box
/// empty, ready for the user to type a gloss. Glossing mode does not support use of
/// consistent changes, nor SILConverter.
/////////////////////////////////////////////////////////////////////////////////
wxString CAdapt_ItView::CopySourceKey(CSourcePhrase *pSrcPhrase, bool bUseConsistentChanges)
{
	// whm modified 29Oct10 to handle Guessing
	CAdapt_ItApp* pApp = &wxGetApp();
	wxString str;
	if (gbIsGlossing)
	{
		str = pSrcPhrase->m_adaption;
	}
	else
	{
		str = pSrcPhrase->m_key;
	}
	if (str.IsEmpty())
	{
		return _T("");
	}
	// BEW added 25May13
	if (gbIsGlossing)
	{
		if (gbFind && gbFindIsCurrent && pSrcPhrase->m_gloss.IsEmpty())
		{
			return _T("");
		}
	}
	else
	{
		if (gbFind && gbFindIsCurrent && pSrcPhrase->m_adaption.IsEmpty())
		{
			return _T("");
		}
	}
	// BEW 9Sep22 this Fumey request should be supported unchanged
	if (!pApp->m_bLegacySourceTextCopy)
	{
		// the user wants smart copying done to the phrase box when the active location
		// landed on does not have any existing adaptation (in adapting mode), or, gloss
		// (in glossing mode). In the former case, it tries to copy a gloss to the box
		// if a gloss is available, otherwise source text used instead; in the latter case
		// it tries to copy an adaptation as the default gloss, if an adaptation is
		// available, otherwise source text is used instead. Roland Fumey requested these
		// two special behaviours when non-legacy copy (which is to just copy the source text)
		// is not wanted. The Backups and Misc tab of Preferences has the checkbox for choosing
		// these non-legacy behaviours.
		if (gbIsGlossing)
		{
			if (!pSrcPhrase->m_adaption.IsEmpty())
			{
				str = pSrcPhrase->m_adaption;
			}
		}
		else
		{
			if (!pSrcPhrase->m_gloss.IsEmpty())
			{
				str = pSrcPhrase->m_gloss;
			}
		}
	}

    pApp->m_pTargetBox->m_bBoxTextByCopyOnly = TRUE;

	wxString str2 = _T("");
	// BEW 13Jan17 Need to make CTargetBox's m_pAbandonable boolean be FALSE if
	// DoConsistentChanges() causes a change which makes the word differ from
	// m_key. Otherwise, the change is not saved to the KB if the user does no
	// editing or a click in the phasebox. A CC change should be equivalent to
	// a user edit, in terms of how the KB works and GUI displays.
	// BEW 9Sep22 add a subtest !gbIsGlossing
	if (!gbIsGlossing && bUseConsistentChanges)
	{
		wxString saveWord = str;
		// these added spaces are automatically stripped before storage takes place, after cc
		// has had its chance to apply, so no harm is done by these additions
		str = _T(" ") + str;
		str += _T(" ");

		// apply to the merged string (ie. merged with whatever is returned here)
		str2 = DoConsistentChanges(str);

		if (pApp->m_bLegacySourceTextCopy)
		{
			//BEW 13Jan17  str2 may have temporary initial & final spaces
			// still present so get rid of them before testing for inequality
			wxString str3 = str2; 
			str3.Trim(FALSE);
			str3.Trim(TRUE);
			if (str3 != saveWord)
			{
				// Prevent the result from being abandonable
				//pApp->m_pTargetBox->m_bAbandonable = FALSE; <- legacy behaviour
#if defined (ABANDON_NOT)
				pApp->m_pTargetBox->m_bAbandonable = FALSE;
#else
				pApp->m_pTargetBox->m_bAbandonable = TRUE;
#endif
				// BEW 27Apr18 changed, because 
				// a copy, no matter how much it is modified programmatically, 
				// should be abandonable until user does something in the GUI 
				//to make it non-abandonable
			}
		}

		if (str2 != str)
		{
			str.Trim(FALSE); // in case DoGuess is called below
			str.Trim(TRUE); // in case DoGuess is called below
		}

		// strip the added spaces back off
		// whm comment: the following GetChar() operations assume that str2 can never be an
		// empty string when it returns from DoConsistentChanges; for safety sake, I'm just
		// going to use the Trim() function instead.
		//if (str2.GetChar(0) == _T(' '))
		//	str2 = str2.Mid(1); // remove initial space
		//int len = str2.Length();
		//if (str2.GetChar(len-1) == _T(' '))
		//	str2 = str2.Left(len-1); // remove final space
		str2.Trim(FALSE); // trim the left end
		str2.Trim(TRUE); // trim the right end
	} // end of TRUE block for test: if (!gbIsGlossing && bUseConsistentChanges)

	else if( !gbIsGlossing && pApp->m_bUseSilConverter )
	{
		return DoSilConvert(str);
	}
	else
	{
		str2 = str;
	}

	// The guesser can waste a huge amount of time, so we have chosen to force the user to
	// explicitly turn it on, as it's not default OFF. Also, it's inappropriate for glossing mode
	bool bIsGuess = FALSE;
	if (!gbIsGlossing && pApp->m_bUseAdaptationsGuesser && !pApp->m_bUseSilConverter)
	{
        // whm 13May2020 Note: The App's m_bUseAdaptationsGuesser now defaults to FALSE.
        // Therefore, the Guesser remains OFF unless the user explicitly turns it ON for a given session.
        //
        // The Guesser cannot be used if the SIL Converters is being used.
		// Also, the Guesser can be used only if Consistent Changes is not being used
		// OR if it is being used AND m_bAllowGuesseronUnchangedCCOutput
		// was set to true by the administrator checking the appropriate checkbox
		// in the GuesserSettingsDlg.

		// BEW 27Nov14 Store the pre-guesser form of the string, because the user may
		// elect to hit the Esc key to reject the guess, so the OnKeyDown() code which
		// grabs the value in order to restore it can find it in app's m_preGuesserStr
		// public member wxString
		pApp->m_preGuesserStr.Empty(); // we also clear it at the start of any function which moves the phrasebox
		pApp->m_preGuesserStr = str;
		if (!pApp->m_bUseConsistentChanges || (pApp->m_bUseConsistentChanges && pApp->m_bAllowGuesseronUnchangedCCOutput))
		{
			str2 = DoGuess(str,bIsGuess);
//#if defined (_DEBUG)
//			if (bIsGuess)
//			{
//				int break_here = 1;
//			}
//#endif
			pApp->m_bIsGuess = bIsGuess;
		}
	}
#if defined (ABANDON_NOT)
	pApp->m_pTargetBox->m_bAbandonable = FALSE;
#else
	pApp->m_pTargetBox->m_bAbandonable = TRUE; // BEW 27Apr18 added this line, a copy, even if programmatically
			// modified, should be abandonable until the user does something to make it not so
#endif
	if (gbIsGlossing)
	{
		pApp->m_pTargetBox->GetTextCtrl()->SetFocus(); // that should make it a bit nicer for the user as
			// he/she won't have to first click in the box before starting to type a gloss
	}
	return str2;
}

/////////////////////////////////////////////////////////////////////////////////
/// \return     a wxString representing text after any Consistent Changes have been performed
///             on the text
/// \param      str    -> the incoming string on which Consistent Changes is to be performed
/// \remarks
/// Called from: the View's CopySourceKey() and DoTargetBoxPaste().
/// If str is not empty, DoConsistentChanges passes str through up to four successive Consistent
/// Changes processes, once for each of up to four loaded changes tables. DoConsistentChanges()
/// handles the initialization of an input and an output buffer for processing of changes by
/// calling of up to four m_consistentChanger instances on the buffers, employing the
/// utf8ProcessBuffer() method of CConsistentChanger. See the CConsistentChanger and CCModule
/// classes.
/////////////////////////////////////////////////////////////////////////////////
wxString CAdapt_ItView::DoConsistentChanges(wxString& str)
{
	if (str.IsEmpty())
		return _T("");

	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);

#ifndef _UNICODE
	// new ANSI version, uses buffers, and based on the _UNICODE code...
	// for the ANSI version, str will be a byte-oriented wxString. No conversions needed.
	// the strings stored in the buffers will be null delimited
	int nIn = 0;  // index for current input buffer
	int nOut = 1; // index for current output buffer
	char byteBuff[2][1024]; // two 1k byte buffers which will alternate as input and output iteratively
	int nInLength = 0;
	int nOutLength = 1024;
	int nTableIndex = -1;

	nInLength = str.Length(); // in bytes
	nInLength += 1; // allow for the null byte at the end (note: for 2.2.1 and previous
					// I did not realize that CC will strip off this final null byte
					// reducing the length by one, so I got final character chopped off
					// the changed string - I fixed this for 2.3.0 (the next after 2.2.1)
	const wxChar* pbuffer = str.GetData();

	// whm added pEnd and null char below
	wxChar* pEnd;
	pEnd = (wxChar*)pbuffer + nInLength -1; // -1 to compensate for += 1 increment on nInLength above
	wxASSERT(*pEnd == _T('\0')); // ensure there's a null at end of buffer

	// populate the first of the buffers
	wxStrcpy(byteBuff[nIn],pbuffer);

	// apply the tables
	int iResult = 0;
	bool bPreviouslyUsedTable = FALSE; // TRUE after a table has been used
	for (int i = 0; i < 4; i++)
	{
		nTableIndex++; // keep track of which table, in case we get an error

		// do the next table, if present
		if (pApp->m_bCCTableLoaded[i])
		{
			if (bPreviouslyUsedTable)
			{
				// prepare for this next table
				nIn = nIn == 0 ? 1 : 0;
				nOut = nOut == 0 ? 1 : 0;
				nInLength = nOutLength;
				nOutLength = 1024;
				memset(byteBuff[nOut],0,1024); // clear the string in the new output buffer
											   // (CC does not retain the null bytes, but
											   // fills the unused part with -52 bytes,
											   // and input '\0' is lost)
			}
			bPreviouslyUsedTable = TRUE;

			iResult = pApp->m_pConsistentChanger[i]->utf8ProcessBuffer(byteBuff[nIn],nInLength,
																byteBuff[nOut],&nOutLength);

			// if there was an error, just return the unaltered original string & warn user
			if (iResult)
			{
				ccErrorStr = ccErrorStr.Format(
				_(" Processing a CC table failed. Got error code %d with table having index %d."),
									iResult,nTableIndex);
				wxMessageBox(ccErrorStr, _T(""), wxICON_EXCLAMATION | wxOK);
				return str; // if there was a table procesing error then return the
							// original string, ie. no tables used
			}
			else
			{
				// no errors
				if (i == 3)
					break; // at the end, so go convert the output string back to UTF-16
			}
		}
		else
		{
			// that table was not loaded, so try the next one
			continue;
		}
	}

	byteBuff[nOut][nOutLength] = '\0';    // ensure it is null terminated at the correct
										  // location (it will overwrite the first (byte)-52)
	// wx version note: here we need a writable buffer
	wxChar* pStr = str.GetWriteBuf(nOutLength + 1);  // nOutLength is 1024
	wxStrcpy(pStr,byteBuff[nOut]);            // but I ran into some problems, so I've done it the safety first way
	//wxChar* pEnd;
	pEnd = pStr + nOutLength; // whm added 18Jun06
	wxASSERT(*pEnd == _T('\0')); // whm added 18Jun06
	str.UngetWriteBuf();
	return str;

#else // Unicode version

	// for the unicode version, str will be a UTF-16 wxString. We have to convert to UTF8, run the
	// resulting string through the CCProcessBuffer() function with a minimum of string copying
	// to maximize speed, and then convert back to UTF-16 and return it to the caller as an LPTSTR;
	// the strings stored in the buffers will be null delimited

	// BEW changed 8Apr06 to accomodate the buffer-safe new conversion macros in VS 2003, which
	// use malloc for buffer allocation of long string to be converted, etc.

	int nIn = 0;  // index for current input buffer
	int nOut = 1; // index for current output buffer
	char byteBuff[2][1024]; // two 1k byte buffers which will alternate as input and output iteratively
	int nInLength = 0;
	int nOutLength = 1024;
	int nTableIndex = -1;

	// wx version note:
	// The wxString::mb_str() method returns a wxCharBuffer. The wxConvUTF8 is a predefined
	// instance of the wxMBConvUTF8 class which converts between Unicode (UTF-16) and UTF-8.
	wxCharBuffer tempBuf = str.mb_str(wxConvUTF8);
	CBString psz(tempBuf);

	nInLength = strlen(psz) + 1; // + 1 for the null byte at the end
	strcpy(byteBuff[nIn],psz);

	// apply the tables
	int iResult = 0;
	bool bPreviouslyUsedTable = FALSE; // TRUE after a table has been used
	for (int i = 0; i < 4; i++)
	{
		nTableIndex++; // keep track of which table, in case we get an error

		// do the next table, if present
		if (pApp->m_bCCTableLoaded[i])
		{
			if (bPreviouslyUsedTable)
			{
				// prepare for this next table
				nIn = nIn == 0 ? 1 : 0;
				nOut = nOut == 0 ? 1 : 0;
				nInLength = nOutLength;
				nOutLength = 1024;
				memset(byteBuff[nOut],0,1024); // clear the string in the new output buffer

			}
			bPreviouslyUsedTable = TRUE;

			// whm note: the following line is where consistent changes does its work
			iResult = pApp->m_pConsistentChanger[i]->utf8ProcessBuffer(byteBuff[nIn],nInLength,
															byteBuff[nOut],&nOutLength);

			// if there was an error, just return the unaltered original string & warn user
			if (iResult)
			{
				ccErrorStr.Format(
				_(" Processing a CC table failed. Got error code %d with table having index %d."),
				iResult,nTableIndex);
                // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
                pApp->m_bUserDlgOrMessageRequested = TRUE;
                wxMessageBox(ccErrorStr, _T(""), wxICON_EXCLAMATION | wxOK);
				return str; // if there was a table procesing error then return the original
							// string, ie. no tables used
			}
			else
			{
				// no errors
				if (i == 3)
					break; // at the end, so go convert the output string back to UTF-16
			}
		}
		else
		{
			// that table was not loaded, so try the next one
			continue;
		}
	}

	// convert back to UTF-16 and return the converted string
	byteBuff[nOut][nOutLength] = '\0';	// ensure it is null terminated at the correct
										// location
	CBString tempBuff(byteBuff[nOut]);
	return pApp->Convert8to16(tempBuff);

#endif // for _UNICODE
}

/////////////////////////////////////////////////////////////////////////////////
/// \return     a wxString representing text after any Guess has been performed
///             on the text
/// \param      str    -> the incoming string on which a Guess of corresponding target text
///                         is to be performed
/// \param      bIsGuess <- set to TRUE if a guess was returned, FALSE otherwise
/// \remarks
/// Called from: the View's CopySourceKey() and DoTargetBoxPaste().
/// If str is not empty, DoGuess passes str through the Guesser processes. DoGuess()
/// takes care of the selection of the appropriate Guesser object, either the
/// m_pAdaptationsGuesser or the m_pGlossesGuesser. If a target guess is not found for
/// the incoming str, str is not changed and is returned just as it was input.
/// added code for new Guesser functionality 09/2013 -klb
/////////////////////////////////////////////////////////////////////////////////
wxString CAdapt_ItView::DoGuess(const wxString& str, bool& bIsGuess)
{
	wxString tempStr = str;
	if (tempStr.IsEmpty())
		return _T("");

	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);

	wxChar* pszGuess = (wxChar*)malloc( MAX_GUESS_LENGTH ); // Alloc space to pass as pointer, 100 is enough

	bool bGuessReturned = FALSE;
	if (gbIsGlossing)
	{
		bGuessReturned = pApp->m_pGlossesGuesser->bTargetGuess(tempStr,&pszGuess); // Return target guess
	}
	else
	{
		bGuessReturned = pApp->m_pAdaptationsGuesser->bTargetGuess(tempStr,&pszGuess); // Return target guess
	}
	if (bGuessReturned)
	{
		// set the bIsGuess reference parameter for return to the caller
		bIsGuess = bGuessReturned;
		tempStr = pszGuess;
	}
	free (pszGuess);
	return tempStr;
}

void CAdapt_ItView::ChooseTranslation()
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	wxCommandEvent dummyevent;
	if (pApp->m_pTargetBox == NULL || !pApp->m_pTargetBox->IsShown())
	{
		// whm Note: the m_pTargetBox is never NULL in the wx version, but
		// sometimes it is not shown, so if we are getting a bell sound at
		// wrong times, this may be the cause.
		// TODO: check the logic during Find operations and any other cases
		// where the MFC version assumes that the target box might be NULL
		::wxBell();
	}
	else
	{
		if (pApp->m_pActivePile != NULL && !pApp->m_pActivePile->GetSrcPhrase()->m_bNotInKB)
			OnButtonChooseTranslation(dummyevent);
		else
			::wxBell();
	}
}

// Modified for support of glossing.
// BEW 2July10, updated for support of kbVersion 2
void CAdapt_ItView::OnButtonChooseTranslation(wxCommandEvent& WXUNUSED(event))
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	// ensure blank variables
    pApp->m_pTargetBox->m_Translation.Empty();
	pApp->m_pTargetBox->m_CurKey.Empty();
    pApp->m_pTargetBox->m_nWordsInPhrase = 0;
	pApp->pCurTargetUnit = (CTargetUnit*)NULL;
#if defined (_DEBUG)
	wxLogDebug(_T("view, OnButtonChooseTranslation, line  %d  - Starting, pApp->m_bTypedNewAdaptationInChooseTranslation = %d"), __LINE__,
		(int)pApp->m_bTypedNewAdaptationInChooseTranslation);
#endif

	CKB* pKB;
	int nCurLongest;
	// BEW changed next few lines, 6Aug13, because it was not refactored earlier to agree
	// with the change to use all tabs of the glossing KB in glossing mode
	if (gbIsGlossing)
	{
		pKB = pApp->m_pGlossingKB;
	}
	else
	{
		pKB = pApp->m_pKB;
	}
	nCurLongest = pKB->m_nMaxWords; // no matches are possible for phrases longer than nCurLongest

    // BEW added 2July10 if a selection is current, tell the user that the phrase box must
    // first be placed there in order to make the Choose Translation dialog accessible from
    // that location (but say nothing if the box is already at the start of the selection)
	if (!pApp->m_selection.IsEmpty())
	{
		// we don't support opening the dialog on a selection disconnected from the active
		// location because the Choose Translation dialog for an OK click will deposit the
		// selected list item at the active location - which would put a wrong adaptation
		// or gloss at a location for which the source text is not an appropriate
		// translation equivalent
		CCellList::Node* cpos = pApp->m_selection.GetFirst();
		CCell* pCell = cpos->GetData();
		CPile* pPile = pCell->GetPile(); // parent pile for this cell
		if (pApp->m_pActivePile != pPile)
		{
			// we have an illegal situation for opening the dialog, so tell the user and
			// exit when he dismisses the message box
			wxString msg = _(
"The dialog can be opened at a selection only if the phrase box is located at the first word of the selection.");
			wxString title = _("Illegal attempt to open ChooseTranslation dialog");
            // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
            pApp->m_bUserDlgOrMessageRequested = TRUE;
            wxMessageBox(msg, title, wxICON_EXCLAMATION | wxOK);
			return;
		}
	}

	// check we are within bounds
	CSourcePhrase* pSrcPhrase = pApp->m_pActivePile->GetSrcPhrase();
	// BEW removed test here, 6Aug13 - it was setting m_nWordsInPhrase to 1 in glossing
	// mode, and so phrasal lookups never succeeded
    pApp->m_pTargetBox->m_nWordsInPhrase = pSrcPhrase->m_nSrcWords;

	if (pApp->m_pTargetBox->m_nWordsInPhrase > nCurLongest)
	{
		// something is really wrong, this should not be possible
		wxString str =_T("Error: longest phrase in KB is shorter than current source phrase's number of words!\n");
		str += _T("So this command will be ignored.\n");
		wxMessageBox(str, _T(""), wxICON_EXCLAMATION | wxOK);
        pApp->m_pTargetBox->m_nWordsInPhrase = 0;
		pApp->m_pTargetBox->SetFocusAndSetSelectionAtLanding(); // whm 13Aug2018 modified
		return;
	}

    // restore the current phrase box's text in the KB, so that potential singly referenced
    // adaptations not yet in the KB will still show in the dialog; but don't do so if the
    // phrasebox is empty (since we want <no adaptation> to show only when the button of
    // that name has been pressed)
	wxString temp;
	bool bOK = TRUE;
	bool bEmptyBox = FALSE;
	if (pApp->m_targetPhrase.IsEmpty())
	{
		bEmptyBox = TRUE;
	}
	else
	{
		temp = pApp->m_targetPhrase;
		// BEW 13Nov10, the flag below is never set TRUE so remove the code which uses it
		if (!gbIsGlossing) // || gbRemovePunctuationFromGlosses)
		{
			RemovePunctuation(GetDocument(),&temp,from_target_text);
		}
#if defined (_DEBUG)
		wxLogDebug(_T("view, OnButtonChooseTranslation, line  %d  - before StoreText(), pApp->m_bTypedNewAdaptationInChooseTranslation = %d"), __LINE__,
			(int)pApp->m_bTypedNewAdaptationInChooseTranslation);
#endif
		// TRUE in the next call means we can store an empty adaptation or gloss
		//pApp->m_bInhibitMakeTargetStringCall = TRUE; // BEW 2Mar20 added
		bOK = pKB->StoreText(pSrcPhrase, temp, TRUE);
		pApp->m_bInhibitMakeTargetStringCall = FALSE;
		wxASSERT(bOK);
		bOK = bOK; // avoid warning
	}
#if defined (_DEBUG)
	wxLogDebug(_T("view, OnButtonChooseTranslation, line  %d  - after StoreText(), pApp->m_bTypedNewAdaptationInChooseTranslation = %d"), __LINE__,
		(int)pApp->m_bTypedNewAdaptationInChooseTranslation);
#endif
	// Get a pointer to the target unit for the current key
    // whm 10Jan2018 Note: In the Legacy app, the following assignment to pCurTargetUnit 
    // was the ONLY place within the sources where a non-null pointer value is
    // assigned to pCurTargetUnit. In the dropdown phrasebox implementation - if not assigned
    // a value here within OnButtonChooseTranslation() - an attempt to assign it a value for
    // the current location is also made within the SetupDropDownPhraseBoxForThisLocation()
    // function.
    pApp->pCurTargetUnit = pKB->GetTargetUnit(pApp->m_pTargetBox->m_nWordsInPhrase, pSrcPhrase->m_key);
	if (pApp->pCurTargetUnit == NULL)
	{
		// IDS_NO_KB_ENTRY
        // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
        pApp->m_bUserDlgOrMessageRequested = TRUE;
        wxMessageBox(_(
"Sorry, the knowledge base does not yet have an entry matching this source text, so the Choose Translation dialog cannot be shown."),
		_T(""), wxICON_EXCLAMATION | wxOK);
        pApp->m_pTargetBox->m_nWordsInPhrase = 0;
        pApp->m_pTargetBox->SetFocusAndSetSelectionAtLanding(); // whm 13Aug2018 modified
        return;
	}
	else
	{
#if defined (_DEBUG)
		wxLogDebug(_T("view, OnButtonChooseTranslation, line  %d before ShowModal(), pApp->m_bTypedNewAdaptationInChooseTranslation = %d"), __LINE__,
			(int)pApp->m_bTypedNewAdaptationInChooseTranslation);
#endif

        pApp->m_pTargetBox->m_CurKey = pSrcPhrase->m_key;
		CChooseTranslation dlg(pApp->GetMainFrame());
		dlg.Centre();
		// initialize m_chosenTranslation, other initialization is in OnInitDialog()
		dlg.m_chosenTranslation.Empty();

		// put up the dialog
		bool bCancelled = FALSE;
		if(dlg.ShowModal() == wxID_OK)
		{
			// set the translation static var from the member m_chosenText
            pApp->m_pTargetBox->m_Translation = dlg.m_chosenTranslation;
			if (dlg.m_bEmptyAdaptationChosen)
                pApp->m_pTargetBox->m_bEmptyAdaptationChosen = TRUE; // enable PlacePhraseBox to use the
												// null string chosen
#if defined (_DEBUG)
			wxLogDebug(_T("view, OnButtonChooseTranslation, line  %d after ShowModal() wxID_OK, pApp->m_bTypedNewAdaptationInChooseTranslation = %d"), __LINE__,
				(int)pApp->m_bTypedNewAdaptationInChooseTranslation);
#endif
		}
		else
		{
			// must have hit Cancel button
			bCancelled = TRUE;
            pApp->m_pTargetBox->m_bEmptyAdaptationChosen = FALSE;
		}

		// BEW 16May18 Provide a new processing path for when the user has typed a new adaptation
		// into the box for that purpose. The legacy processing path did unhelpful things. See
		// more detailed comment in OnOK() in ChooseTranslation.cpp
		if (!gbIsGlossing && !bCancelled && pApp->m_bTypedNewAdaptationInChooseTranslation)
		//if (!gbIsGlossing && !bCancelled)
		{
#if defined (_DEBUG)
			wxLogDebug(_T("view, OnButtonChooseTranslation, line  %d Start simpler code block, pApp->m_bTypedNewAdaptationInChooseTranslation = %d"), __LINE__,
				(int)pApp->m_bTypedNewAdaptationInChooseTranslation);
#endif
			int len = pApp->m_pTargetBox->GetTextCtrl()->GetLineLength(0); // whm 12Jul2018 added GetTextCtrl()-> part
			pApp->m_nStartChar = len;
			pApp->m_nEndChar = len; // cursor at end of text in the box
			pApp->m_pTargetBox->SetModify(TRUE); // SetModify() is method of CPhraseBox - calls this->GetTextCtrl()->MarkDirty() or this->GetTextCtrl()->DiscardEdits()
			pApp->m_pTargetBox->m_bAbandonable = FALSE;
			pApp->m_pTargetBox->m_Translation.Empty();
			// we may need a RecalcLayout() done, for the moment I'm sticking with the existing layout - it should be okay
			Invalidate(); // get the parts of the screen covered by the dialog repainted

			//int saveBoolean = pApp->m_bTypedNewAdaptationInChooseTranslation;
			GetLayout()->PlaceBox(); // might not be needed? No it is needed - otherwise it rebuids list on 
						// where I move phrasebox too & adds old locations meanings to the list there. Ouch.
			// I didn't notice the next line, that clobbers the boolean too early - so is probably why I
			// got the error. Commenting it out should suffice
			//pApp->m_bTypedNewAdaptationInChooseTranslation = FALSE; // gotta restore initialized value before leaving here

			pApp->m_pTargetBox->CloseDropDown(); // whm 16July2024 added to suppress the opening of the dropdown list on exit from free trans mode
			pApp->m_bChooseTransInitializePopup = FALSE; // whm 16July2024 added to suppress the opening of the dropdown list on exit from free trans mode

#if defined (_DEBUG)
			wxLogDebug(_T("view, OnButtonChooseTranslation, line  %d returning, at end simpler code block, pApp->m_bTypedNewAdaptationInChooseTranslation = %d"), __LINE__,
				(int)pApp->m_bTypedNewAdaptationInChooseTranslation);
#endif
			return;
		}

        // remove the refString again, to restore the phrase box and KB to the proper state
        // for having landed there - if the user removed the refString in the dialog,
        // pRefString will be NULL and no damage will be done as RemoveRefString checks for
        // this condition <<-- BEW 2Jul10, as of kbVersion 2 the user can't physically
        // remove it, but only cause it to be hidden while its m_bDeleted flag is TRUE
		wxString emptyStr = _T("");
		if (!bEmptyBox)
		{
#if defined (_DEBUG)
			wxLogDebug(_T("view, OnButtonChooseTranslation, line  %d Start, legacy code, pApp->m_bTypedNewAdaptationInChooseTranslation = %d"), __LINE__,
				(int)pApp->m_bTypedNewAdaptationInChooseTranslation);
#endif

			// "remove" the CRefString instance, or decrement is m_refCount if the latter
			// is > 1
			if (gbIsGlossing)
			{
				pApp->m_pGlossingKB->GetAndRemoveRefString(pSrcPhrase,
										emptyStr, useGlossOrAdaptationForLookup);
			}
			else
			{
				pApp->m_pKB->GetAndRemoveRefString(pSrcPhrase,
										emptyStr, useGlossOrAdaptationForLookup);
			}
		}
		// if user hit the cancell button, we can return immediately
		if (bCancelled)
		{
            pApp->m_pTargetBox->m_nWordsInPhrase = 0;
            pApp->pCurTargetUnit = (CTargetUnit*)NULL;
            pApp->m_pTargetBox->m_CurKey.Empty();
            pApp->m_pTargetBox->SetFocusAndSetSelectionAtLanding();// whm 13Aug2018 modified
			return;
		}

		// use the m_Translation global variable to set the phrase box to the
		// chosen adaptation
		pApp->m_targetPhrase = pApp->m_pTargetBox->m_Translation;
		pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(pApp->m_pTargetBox->m_Translation);
        // whm Note: PlacePhraseBox() call below ends by calling the Layout's PlaceBox() which
        // in turn calls PopulateDropDownList(). 
		PlacePhraseBox(pApp->m_pActivePile->GetCell(1), 1); // selector = 1 inhibits the
							                                // saving to KB since there was no click to a new location
        pApp->m_pTargetBox->m_bEmptyAdaptationChosen = FALSE; // ensure its safely defused!

		// get a new (valid) active pile pointer, now that the layout is recalculated (again!)
		pApp->m_pActivePile = GetPile(pApp->m_nActiveSequNum);
		wxASSERT(pApp->m_pActivePile);
		int len = pApp->m_pTargetBox->GetTextCtrl()->GetLineLength(0); // whm 12Jul2018 added GetTextCtrl()-> part
		pApp->m_nStartChar = len;
		pApp->m_nEndChar = len; // cursor at end of text in the box
		pApp->m_pTargetBox->SetModify(TRUE); // whm 12Jul2018 SetModify() calls this->GetTextCtrl()->MarkDirty() or this->GetTextCtrl()->DiscardEdits()

		// scroll into view, just in case a lot were inserted
		pApp->GetMainFrame()->canvas->ScrollIntoView(pApp->m_nActiveSequNum);

        pApp->m_pTargetBox->SetFocusAndSetSelectionAtLanding();// whm 13Aug2018 modified

        // whm 19Feb2018 the m_Translation global is used in Layout's PlaceBox() call (called below)
        // by PopulateDropDownList(), so we must not clear it here, but after it is used there.
		//pApp->m_pTargetBox->m_Translation.Empty(); // clear the globals
		//pApp->m_pTargetBox->m_CurKey.Empty();
		Invalidate();
		GetLayout()->PlaceBox(); // whm 24Feb2018 The Layout's PlaceBox gets called twice - once above within
        // the PlacePhraseBox() call, and again here at the end of the OnButtonChooseTranslation() function.
        // So, with such convoluted flow of control, we set the m_Translation variable back to empty
        // here after the second PlaceBox() call rather than after it is used within the 
        // CPhraseBox::PopulateDropDownList() call. Otherwise the m_Translation variable is cleared
        // after the first call of PlaceBox() making it useless for the second PlaceBox() call where
        // it is needed.
        // TODO: Determine if there really is a need for the PlaceBox() call here within the OnButtonChooseTranslation()
        // handler.

		pApp->m_pTargetBox->CloseDropDown(); // whm 16July2024 added to suppress the opening of the dropdown list on exit from free trans mode
		pApp->m_bChooseTransInitializePopup = FALSE; // whm 16July2024 added to suppress the opening of the dropdown list on exit from free trans mode

		pApp->m_pTargetBox->m_Translation.Empty(); // If the PlaceBox() call can be removed, this can go back into Layout's PlaceBox() after the PopulateDropDownList() call
#if defined (_DEBUG)
		wxLogDebug(_T("view, OnButtonChooseTranslation, line  %d End legacy code block, pApp->m_bTypedNewAdaptationInChooseTranslation = %d"), __LINE__,
			(int)pApp->m_bTypedNewAdaptationInChooseTranslation);
#endif
	}
}

/////////////////////////////////////////////////////////////////////////////////
/// \return		nothing
/// \param      event   -> the wxUpdateUIEvent that is generated by the app's Idle handler
/// \remarks
/// Called from: The wxUpdateUIEvent mechanism whenever idle processing is enabled. If any
/// of the following conditions are TRUE, this handler disables the "Show the Choose
/// Translation Dialog" toolbar item and returns immediately: The application is in Free
/// Translation mode, the targetBox is NULL or is not shown, or the application is in
/// glossing mode. Otherwise, it enables the toolbar button if the active pile is valid and
/// the source phrase at that point does not have the m_bNotInKB flag set.
/////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItView::OnUpdateButtonChooseTranslation(wxUpdateUIEvent& event)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);

	if (pApp->m_bReadOnlyAccess)
	{
		event.Enable(FALSE);
		return;
	}

	if (pApp->m_bFreeTranslationMode)
	{
		event.Enable(FALSE);
		return;
	}
	if (pApp->m_pTargetBox == NULL || !pApp->m_pTargetBox->IsShown())
	{
		// whm 12Aug08 Note: the m_pTargetBox is never NULL in the wx version, but
		// sometimes it is not shown, so if the ChooseTranslation button is
		// not enabled when it should be, this may be the cause.
		// TODO: check the logic during Find operations and any other cases
		// where the MFC version assumes that the target box might be NULL
		event.Enable(FALSE);
		return;
	}
	else
	{
		if (!gbIsGlossing && pApp->m_pActivePile != NULL &&
			!pApp->m_pActivePile->GetSrcPhrase()->m_bNotInKB)
		{
			event.Enable(TRUE);
		}
		else
		{
			if (gbIsGlossing)
				event.Enable(TRUE);
			else
				event.Enable(FALSE);
		}
	}
}

// whm 28Feb12 modified. This OnFileStartupWizard() handler is now called only
// by the File > Start Working... menu item. It is no longer called by
// DoStartupWizardOnLaunch(). The original code in this handler that called
// DoStartWorkingWizard() was moved to DoStartupWizardOnLaunch().
void CAdapt_ItView::OnFileStartupWizard(wxCommandEvent& WXUNUSED(event))
{
	// whm Note 28Feb12
	// when the user explicitly clicks on the File > Start Working... item we
	// the App's behavior to be the following:
	// 1. If collaboration is ON at the time File > Start Working... is selected,
	// we want the GetSourceTextFromEditor dialog to appear so the user can select
	// a different book and/or chapter in collaboration mode.
	// 2. If collaboration is OFF at the time File > Start Working... is selected,
	// we want the normal wizard to appear, not the GetSourceTextFromEditor dialog.

	// whm 28Feb12 moved the original code to DoStartupWizardOnLaunch() and
	// this handler now calls DoStartupWizardOnLaunch().
	DoStartupWizardOnLaunch();
}

void CAdapt_ItView::DoStartupWizardOnLaunch()
{
	// whm modified 28Feb12. Moved the code from OnFileStartupWizard() to this
	// function. The OnFileStartupWizard() handler now calls this function instead
	// of this function calling OnFileStartupWizard().

    // Since the Startup Wizard menu item has an accelerator table hot key (CTRL-W see
    // CMainFrame) and wxWidgets accelerator keys call menu and toolbar handlers even when
    // they are disabled, we must check for a disabled button and return if disabled.
    // On Windows, the accelerator key doesn't appear to call the handler for a disabled
    // menu item, but I'll leave the following code here in case it works differently on
    // other platforms.
    // whm 20Aug11 note: only log errors in OnFileStartupWizard()

	CAdapt_ItApp* pApp = (CAdapt_ItApp*)&wxGetApp();
	// for debugging
	//{
	//	bool bExpectsFreeTrans;
	//	bExpectsFreeTrans = pApp->m_bCollaborationExpectsFreeTrans;
	//}
	CMainFrame* pFrame = pApp->GetMainFrame();
	wxMenuBar* pMenuBar = pFrame->GetMenuBar();
	wxASSERT(pMenuBar != NULL);
	if (!pMenuBar->IsEnabled(ID_FILE_STARTUP_WIZARD))
	{
		::wxBell();
		pApp->LogUserAction(_T("Start working wizard called but disabled"));
		return;
	}

	pApp->m_bStartViaWizard = TRUE; // allows the OnIdle handler to force
									// phrase box text to be selected
	bool bSuppress = pApp->m_bSuppressWelcome;

	if (pApp->m_pSourcePhrases->GetCount() > 0)
		goto a;
	if (pApp->m_pKB != NULL)
		goto a;
	if (gbJustClosedProject)
		goto a;

	if (!bSuppress)
	{
		CWelcome wdlg(pApp->GetMainFrame()); // make the view the parent
		wdlg.Centre();
		wdlg.ShowModal();
		pApp->m_bSuppressWelcome = wdlg.m_bSuppressWelcome; // update flag
	}

a:	if (pApp->m_bJustLaunched && !pApp->m_bUseStartupWizardOnLaunch)
		return; // suppress its use if user wants, but only for the program launch
	else
	{
		wxCommandEvent evt;
		bool bSuccess = pApp->DoStartWorkingWizard(evt);
		if (!bSuccess)
		{
            // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
            pApp->m_bUserDlgOrMessageRequested = TRUE;
            wxMessageBox(_T(
"The Startup Wizard failed. Try using either the New...\nor Open... items on the File... menu instead."),
			_T(""), wxICON_EXCLAMATION | wxOK);
			pApp->LogUserAction(_T("The Startup Wizard failed. Try using either the New...\nor Open... items on the File... menu instead."));
		}
	}
}

void CAdapt_ItView::OnCheckKBSave(wxCommandEvent& WXUNUSED(event))
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	if (gbIsGlossing)
	{
		// if glossing is ON, keep the box checked at all times since
		// we won't allow <Not In KB> option when gbIsGlossing is TRUE
		pApp->m_bSaveToKB = TRUE;
		return;
	}
	// glossing is OFF, so box can be toggled on or off
	if (pApp->m_pActivePile == NULL)
		return;
	CSourcePhrase* pSrcPhrase = pApp->m_pActivePile->GetSrcPhrase();
	if (pSrcPhrase == NULL)
		return;

	// call DoNotInKB & then toggle the m_bSaveToKB flag
	if (pApp->m_bSaveToKB)
	{
		// user does not want it to be in the KB
		// we must do the call with m_bSaveToKB TRUE, otherwise the store
		// of "<Not In KB>" will not happen
		pApp->m_pKB->DoNotInKB(pSrcPhrase,TRUE);
		pApp->m_bSaveToKB = FALSE;
	}
	else
	{
		// user wants it in the KB
		pApp->m_bSaveToKB = TRUE;
		pApp->m_pKB->DoNotInKB(pSrcPhrase,FALSE);
		// If there is a subsequent StoreText() call, we'll want m_targetStr
		// in the pSrcPhrase to get any punctuation addition done, so ensure
		// this flag is FALSE so that can happen
        pApp->m_bInhibitMakeTargetStringCall = FALSE;

		// Reversion to "Save In Knowledge base" is only able to be done in
		// adapting mode. In glossing mode, the checkbox is always ticked and
		// clicking it is ignored, and the glossing KB has no <Not In KB> and
		// so no change of state for the glossing KB is able to be achieved by
		// the following call, so wrap it with a test so as to prevent wasting
		// processing time. The second subtest causes a skip of the call if
		// Bob Eaton's special use of the KB in collaboration with the
		// SIL Converters feature is currently turned on
		if (!gbIsGlossing && !pApp->m_pTargetBox->m_bSuppressStoreForAltBackspaceKeypress)
		{
			// BEW 4Sep15 added following function call, to make the reversion
			// happen in every location in every document where it exists as a
			// pSrcPhrase with m_bNotInKB TRUE. Otherwise the user has to search
			// manually for them all and manually switch the value - ugh!
			// Ask the user - he may want a single local change, so give the option
			wxString sourceKey = pSrcPhrase->m_key;
			CMainFrame* pFrame = pApp->GetMainFrame();
			wxString title = _("Here Only, or Everywhere It Occurs");
			wxString msg;
			msg = msg.Format(
				_("You have changed this source text ( %s ) to be stored in the knowledge base, along with its translation.\nDo you want this to happen, in all documents, at every location where the same source text occurs with an asterisk?\n(The translations at other locations can be the same or different, that will not matter.)"),
				sourceKey.c_str());
			int style = wxYES_NO;
            // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
            pApp->m_bUserDlgOrMessageRequested = TRUE;
            int choice = wxMessageBox(msg, title, style, pFrame);
			if (choice == wxYES)
			{
				// DoNotInKB(pSrcPhrase,FALSE) above leaves pSrcPhrase's m_bHasKBEntry
				// cleared to FALSE, because when control doesn't enter this block
				// a move of the phrasebox will cause that flag to get a TRUE value
				// set. But when the user has requested that an 'all documents' fix
				// is to be done, there will be no phrasebox movement, instead, the
				// document will be saved and closed - and so the flag would remain
				// unset for the pSrcPhrase at the active location. So we set it
				// now, so that the document state remains well formed.
				pSrcPhrase->m_bHasKBEntry = TRUE;
				// Now, we can do the global reversion...
				bool bRevertedEverywhere = DoGlobalRestoreOfSaveToKB(pSrcPhrase->m_key);
				wxASSERT(bRevertedEverywhere);
				wxUnusedVar(bRevertedEverywhere); // prevent compiler warning in Release build
			}
		}
	}

	// restore focus to the targetBox, if it is visible
    if (pApp->m_pTargetBox != NULL)
    {
        if (pApp->m_pTargetBox->IsShown())
        {
            pApp->m_pTargetBox->SetFocusAndSetSelectionAtLanding();// whm 13Aug2018 modified
        }
    }

	// BEW added 20May09, next line required in order to get * shown
	GetLayout()->Redraw();
	GetLayout()->PlaceBox(); // this call probably unneeded but no harm done
}

// BEW added 4Sep15, called only in OnCheckKBSave() - see above, when
// the latter is used by the user to ask for a <Not In KB> entry to be
// reverted to saved in the KB; this should be done everywhere in all docs
// for this pSrcPhrase's m_key/m_adaption pair where the GUI would show it
// as asterisked in the navigation text area otherwise. This function does that job.
// Note: no gui is needed for this function. When called, the pSrcPhrase at the
// active location will already have been reverted, but the document unsaved.
// So the first thing we must do is force a save, and let the user know that that
// is necessary, and that all locations will be fixed in all documents. There could
// be places where the searched-for pair are saved to the KB still, so our code
// must test for those just in case there are some, and do nothing at those locations.
// The restoration will involve a storage being done to the KB at each location that 
// is reverted - and so since adapations may be present at some, many or all of the
// relevant pile locations, adaptations (or glosses) will enter the KB and if the
// reference counts incremented etc. When a location has no adapation yet, but the
// location's m_bNotInKB flag is nevertheless TRUE, a <no adaptation> entry is made
// to the KB. This process will not change any of the text in any of the documents,
// so it will not produce any conflict if collaboration mode is in effect. The way
// we will do it is to freeze the screen, with a Please Wait message, save and close
// the current document - but remember what it is for restoring later (Mike Hore has
// a nice function or two for doing that in his DVCS Nav dlg handler) - and when we
// restore we'll unfree the screen and the Please Wait dlg will disappear, and the
// app will be responsive again. Inbetween those times, we'll read in each document,
// do the scans and changes, save any which we made dirty. The whole lot can be
// encapsulated in this DoGlobalRestoreOfSavetoKB() function.
// Return TRUE if the user chooses either of the Yes/No message box options. Return
// FALSE if the function failed at some point.
// The sourceKey param is the pSrcPhrase->m_key value at the active location which
// is being reverted to normal KB storage by the user clicking the checkbox
bool CAdapt_ItView::DoGlobalRestoreOfSaveToKB(wxString sourceKey)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	CAdapt_ItDoc* pDoc = pApp->GetDocument();
	CMainFrame* pFrame = pApp->GetMainFrame();
	pFrame = pFrame; // whm added to avoid warning from gcc
	CKB* pKB = NULL;
	
	// All locations in all documents which have this src and whatever is its adaptation at 
	// that location, providing pSrcPhrase has m_bNotInKB TRUE, are to be switched to 
	// "Save To Knowledge Base" turned ON, and the relevant StoreText() call done there also,
	// so that the KB gets the needed entry or bump of the entry's CRefString count value

	m_nCallCount = 0; // initialize the member int which we'll use to limit
	// calls of void CKB::SetRefCountsTo(int refCountValue, CSourcePhrase* pSrcPhrase)
	// to one per call of RestoreKBStorageForSourceKey() - if we don't do that, calling
	// it at every matching location keeps the KB's m_refCount values at 1 for the 
	// restored entries


	// put up a Wait dialog (we'll also use a progress bar - see below)
	// BEW 5Feb16 this modeless dialog on Linux doesn't display its contents, so show
	// it only for Windows
#if defined(__WXMSW__)
	CWaitDlg waitDlg(pFrame);
	// indicate we want the closing the document wait message
	waitDlg.m_nWaitMsgNum = 23;	// 23 has  _("This may take a while. Identical changes are being done in all the documents...")
	waitDlg.Centre();
	waitDlg.Show(TRUE);// On Linux, the dialog frame appears, but the text in it is not displayed (need ShowModal() for that)
	waitDlg.Update();
	// the wait dialog is automatically destroyed when it goes out of scope below
#endif
	canvas->Freeze();

	// Probably I need to close doc here ?? Yes, do it
	wxString dirPath;
	if (pApp->m_bBookMode && !pApp->m_bDisableBookMode)
		dirPath = pApp->m_bibleBooksFolderPath;
	else
		dirPath = pApp->m_curAdaptationsPath;
	bool bOK;
	// whm 8Apr2021 added wxLogNull block below
	{
		wxLogNull logNo;	// eliminates any spurious messages from the system if the wxSetWorkingDirectory() call returns FALSE
		bOK = ::wxSetWorkingDirectory(dirPath); // ignore failures
	} // end of wxLogNull scope

	// BEW added 05Jan07 to enable work folder on input to be restored when done
	wxString strSaveCurrentDirectoryFullPath = dirPath;

	// get the KB entry for the current active location updated so as to avoid 
	// a spurious entry (we have to assume it's okay, but if not it's not a big
	// deal as when we are done we'll reopen this doc and but the phrasebox at
	// it's former (that is, current) location
	bool bNoStore = FALSE;
	bool bAttemptStoreToKB = TRUE;
	bool bSuppressWarningOnStoreKBFailure = TRUE;
	bOK = TRUE;

	// BEW 9Aug11, in the call below, param1 TRUE is bArremptStoreToKB, param2 bNoStore
	// returns TRUE to the caller if the attempted store fails for some reason, for all
	// other circumstances it returns FALSE, and param3 bSuppressWarningOnStoreKBFailure
	// is TRUE as we don't expect a failure and anyway we will ignore the fact if it does fail
	UpdateDocWithPhraseBoxContents(bAttemptStoreToKB, bNoStore, bSuppressWarningOnStoreKBFailure);
	// We will base our clobbering of the document and later reopening of it on 
	// what OnEditConsistencyCheck() does, it's a doc member function
	wxString savedCurOutputPath = pApp->m_curOutputPath;	// includes filename
	wxString savedCurOutputFilename = pApp->m_curOutputFilename;
	// for resetting the box location, a saved document internally stores the last active sequ num value
	bool	 savedBookmodeFlag = pApp->m_bBookMode;	// for ensuring correct mode
	bool	 savedDisableBookmodeFlag = pApp->m_bDisableBookMode;		// ditto
	int		 savedBookIndex = pApp->m_nBookIndex;
	BookNamePair*	pSavedCurBookNamePair = pApp->m_pCurrBookNamePair;
	bool bDocIsClosed = FALSE; // initialize, set it at next line
	bDocIsClosed = pApp->m_pSourcePhrases->GetCount() == 0; // set bDocIsClosed to either true or false
	bool bDocForcedToClose = FALSE;
	bool savedConflictResolutionFlag = pApp->m_bConflictResolutionTurnedOn; // for resetting later, as 
											// opening a document defaults it to TRUE
	// Next bit is a tweak of the contents of ConsistencyCheck_ClobberDocument()
	// save and remove open doc, if a doc is open
	if (!bDocIsClosed)
	{
		// Save the Doc (and DoFileSave_Protected() also automatically saves, without backup,
		// both the glossing and adapting KBs); FALSE is bool bShowWaitDlg, and the emtpy
		// string is progressItem - it's empty as we don't want any progress shown for this
		bool fsOK = pDoc->DoFileSave_Protected(FALSE, _T(""));
		if (!fsOK)
		{
			// something's real wrong! An English message will do
			wxMessageBox(_T(
				"Could not save the current document. DoGlobalRestoreOfSaveToKB() was aborted. You can continue working."),
				_T(""), wxICON_EXCLAMATION | wxOK);
			// whm note 5Dec06: Since EnumerateDocFiles has not yet been called the
			// current working directory has not changed, so no need here to reset
			// it before return.
			pApp->LogUserAction(_T("Current document not saved. DoGlobalRestoreOfSaveToKB() is aborted, app continues."));
			canvas->Thaw();
			return FALSE; // can't recover the correct operation of this feature after 
						  // this error, but app can continue after the user is warned
		}

		// Ensure the current document's contents are removed. We will reuse this
		// m_pSourcePhrases list for storing the parse of each document read in.
		// The only KB that will be affected is the adapting one. The glossing KB
		// does not support <Not In KB> entries.

		// ClobberDocument() does not clobber the in-memory glossing and adapting
		// KBs - - we will do those separately; it does though empty the gEditRecord - so
		// if that had content it would be lost; however, it's used only when processing
		// the document because editing of the source text has taken place - and this is
		// not likely to ever be the case when doing global restoring of <Not In KB> to having
		// a kb entry in all the places the src/tgt pair occur in all docs.
		pApp->GetView()->ClobberDocument(); // BEW 13Jul19 I think m_bDocumentDestroyed should
			// be allowed to stand as TRUE after this clobber call, as it will prevent (at
		    // least temporarily) DoAutoSaveDoc(), if it gets fired by the timer, from
			// doing anything during this function's operation
		pApp->m_acceptedFilesList.Clear();
		bDocForcedToClose = TRUE;
	} // end of TRUE block for test: if (!bDocIsClosed)

	// Get the list of all docs, in Adaptations folder and in Book Folders as well
	wxArrayString allPaths;
	size_t count = pApp->EnumerateAllDocFiles(allPaths, pApp->m_curAdaptationsPath);
#if defined(_DEBUG) && defined(NO_ASTERISK)
	size_t k;
	for (k = 0; k < count; k++)
	{
		wxLogDebug(_T("EnumerateAllDocFiles() a path is: %s"), allPaths.Item(k).c_str());
	}
#endif
	wxASSERT(pApp->m_bKBReady);
	pKB = pApp->m_pKB;
	wxString saveOutputPath = pApp->m_curOutputPath; // save, because we'll reuse this
		// for saving our temporarily loaded documents back to the original locations

	// Progress Bar initialization is next
	pApp->m_bShowProgress = TRUE;
	wxString msgDisplayed;
	const int nTotal = (int)count;
	wxString progMsg = _("Editing document %d of %d");
	msgDisplayed = progMsg.Format(progMsg,0,nTotal);
	CStatusBar *pStatusBar = NULL;
	pStatusBar = (CStatusBar*)pApp->GetMainFrame()->m_pStatusBar;
	if (pApp->m_bShowProgress)
	{
		pStatusBar->StartProgress(_T("MakeInKB"), msgDisplayed, nTotal);
	}
	
	// I don't need to clobber the kbs, and any current kbserver sharing. All I'm doing 
	// is loading in a doc and running it thru a process that will update it and some 
	// kb entries. We only need that m_pSourcePhrases is available for temporary
	// use for storing each doc that we load in for our scan and fixes. So kbserver
	// connection needs to persist because some entries in the adapting KB will change.
	// So also, the KBs need to be present, for the same reason.
	// Only adaptations can have <Not In KB> entries, so glossing KB is unaffected,
	// and no document adaptations either m_adaption nor m_targetStr get changed, so
	// StoreText() can be used safely, as so can m_pSourcePhrases. The resulting changed
	// document will therefore not have any collaboration conflicts created by the process.

	// Prepare and then loop over all the documents, calling the single-document
	// core processing function: RestoreKBStorageForSourceKey(sourceKey, pKB)
	CLayout* pLayout = pApp->GetLayout();
	bool bShowProgressInDocLoad = FALSE; // suppress the OnOpenDocument()'s internal progress tracking
	pApp->m_bWantSourcePhrasesOnly = TRUE; // this causes OnOpenDocument() to exit immediately after
										   // populating pSrcPhrases list has completed, because that's
										   // all we need done
	pApp->m_bConflictResolutionTurnedOn = FALSE; // keep off for this loop's processing
	size_t i;
	wxString aPath;
	wxASSERT(pApp->m_pSourcePhrases->IsEmpty());
	for (i = 0; i < count; i++)
	{
		aPath = allPaths.Item(i);
#if defined(_DEBUG) && defined(NO_ASTERISK)
		wxLogDebug(_T("\nDoGLobalRestoreOfSaveToKB() Loop iteration number %d of %d  This path: %s"), i, count, aPath.c_str());
#endif
		bOK = pDoc->OnOpenDocument(aPath, bShowProgressInDocLoad /* is set FALSE above */);
		if (!bOK)
		{
			// If we fail to read in a document, just skip it, but inform the user
			pLayout->m_bLayoutWithoutVisiblePhraseBox = TRUE; // suppresses phrasebox stuff
			ClobberDocument(); // let m_bDocumentDestroyed stay TRUE
			// Inform the user
			wxString title = _("File read failure");
			wxFileName fn(aPath);
			wxString fullFilename = fn.GetFullName();
			wxString msg;
			msg = msg.Format(_("Loading the document (  %s ) failed. So processing this document has been skipped."), fullFilename.c_str());
			wxMessageBox(msg, title, wxICON_WARNING | wxOK);
		}
		else
		{
			// Process the document's CSourcePhrase inventory, which is now in app's m_pSourcePhrases list
			RestoreKBStorageForSourceKey(sourceKey, pKB);

			// Save the tweaked document
			bOK = pDoc->DoAbsolutePathFileSave(aPath); // BEW created 7Sep15
			if (!bOK)
			{
				// Inform the user
				wxString title = _("File write failure");
				wxFileName fn(aPath);
				wxString fullFilename = fn.GetFullName();
				wxString msg;
				msg = msg.Format(_("Writing the automatically updated document (  %s ) failed. So the older version remains unchanged."), fullFilename.c_str());
                // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
                pApp->m_bUserDlgOrMessageRequested = TRUE;
                wxMessageBox(msg, title, wxICON_WARNING | wxOK);
			}
			// Clobber the document - clearing pSrcPhrases to empty
			pLayout->m_bLayoutWithoutVisiblePhraseBox = TRUE; // suppresses phrasebox stuff
			ClobberDocument(); // clears pSrcPhrases list; & let m_bDocumentDestroyed stay TRUE
		}

		// Update the progress bar
		if (pApp->m_bShowProgress)
		{
			msgDisplayed = progMsg.Format(progMsg,(int)(i + 1),nTotal);
			pStatusBar->UpdateProgress(_T("MakeInKB"), (int)(i + 1), msgDisplayed);
		}
	}

	// Restore the document before exiting, if one was open formerly
	pApp->m_bWantSourcePhrasesOnly = FALSE; // restore default, so that
					// all of OnOpenDocument()'s code is used from now on
	pApp->m_curOutputPath = saveOutputPath; // restore original doc's output path
	pLayout->m_bLayoutWithoutVisiblePhraseBox = FALSE; // restore default
	pApp->m_bConflictResolutionTurnedOn = savedConflictResolutionFlag; // restore original value
	if (bDocForcedToClose)
	{
		// reopen the doc with all as it was before; TRUE is bMarkAsDirty
		// (This call does not re-establish any kbserver connection that may have
		// been open when this function was entered, so we need to do that separately)
		bOK = pDoc->ReOpenDocument(pApp, strSaveCurrentDirectoryFullPath,
			savedCurOutputPath, savedCurOutputFilename, savedBookmodeFlag,
			savedDisableBookmodeFlag, pSavedCurBookNamePair, savedBookIndex, TRUE);
		wxASSERT(bOK);
		if (!bOK)
		{
			wxString msg = _("The former open document could not be reopened. Adapt It is in a non-stable state. You should close down immediately without saving, then launch and enter your project again.");
			pApp->LogUserAction(msg);
			wxMessageBox(msg, _T(""), wxICON_EXCLAMATION | wxOK);
			canvas->Thaw();
            // whm 23Aug2018 added before return statement, must call FinishProgress()
            if (pApp->m_bShowProgress)
            {
                pStatusBar->FinishProgress(_T("MakeInKB"));
            }
            return FALSE;
		}
	}
	// Close off Progress Bar & thaw the frozen client area
    // whm 23Aug2018, put canvas->Thaw() before the FinishProgress() call just in case.
	canvas->Thaw();
	if (pApp->m_bShowProgress)
	{
		pStatusBar->FinishProgress(_T("MakeInKB"));
	}

	pApp->m_bShowProgress = FALSE;
	return TRUE;
}

/// \return			nothing
/// \param	sourceKey ->	The m_key value at the CSourcePhrase instance which
///							is at the active location where the user has clicked
///							the Save To Knowledge Base checkbox, to cause the
///							m_bNotInKB TRUE instance to become FALSE and have a
///							a norm KB entry done to the adaptations KB.
/// \remarks
/// This function does the above task on all locations within the currently loaded
/// document (in m_pSourcePhrases list) as follows. We scan for each pSrcPhrase
/// which has a m_key value which is an identity match for the passed in sourceKey,
/// and for each of those, and only provided it also has m_bNotInKB TRUE, we change
/// that flag to FALSE and do a StoreText with the sourceKey and whatever is that
/// location's adaptation - it could be an empty string (if it is, we store it), so
/// the KB storages could result in non-empty adaptations going to the KB or empty ones.
/// Cleanup and saving of the tweaked m_pSourcePhrases list contents is done in the
/// caller.
/// BEW created 7Sept15, called only in DoGlobalRestoreOfSaveToKB()'s loop
void CAdapt_ItView::RestoreKBStorageForSourceKey(wxString sourceKey, CKB* pKB)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	SPList* pSPList = pApp->m_pSourcePhrases;
	CSourcePhrase* pSP = NULL;
	if (!pSPList->IsEmpty())
	{
		SPList::Node* pos_pSPList = pSPList->GetFirst();
		while (pos_pSPList != NULL)
		{
			pSP = pos_pSPList->GetData();
			pos_pSPList = pos_pSPList->GetNext();
			if (pSP->m_bNotInKB)
			{
				if (pSP->m_key == sourceKey)
				{
					// We have found a CSourcePhrase instance which has its "not in kb" flag
					// set TRUE, so this is now to be reverted to being KB storable, and then
					// the function restores what used to be there
					wxString adaption = pSP->m_adaption; // could be an empty string, 
							// and if so, we want is in the kb as a <no adaptation> entry
					pKB->DoNotInKB(pSP, FALSE); // FALSE is the user's choice to NOT make it a <Not In KB> entry
					// The DoNotInKB() function internally sets m_bNotInKB to FALSE. Also, DoNotInKB() sets
					// pSP->m_bHasKBEntry to FALSE, because normally it is used with a normal
					// interlinear layout with a phrasebox, and when the phrasebox moves from the current location
					// that is when pSP->m_bHasKBEntry gets set to TRUE. But in this function we have no GUI
					// currently in effect, and no phrasebox, so we must set the flag here to TRUE ourselves
					pSP->m_bHasKBEntry = TRUE;
					// The above call will delete the KB entry's <Not In KB>, and restore to being present in
					// the KB any other deleted entries of normal kind which may be present. Because it does
					// this, the pseudo-deleted entries will reemerge in the KB - with their old reference counts. 
					// However there could have been numerous "Not In KB" doc locations with new adaptations in them
					// that never have been stored in the KB, so we must do a StoreText() call to get those
					// into the KB. This, unfortunately, will skew the reference counts (making them larger than they
					// should be). The only way round this is to have a function which iterates across the normal
					// CRefString instances in the CTargetUnit, and resets them 1 (since a 0 value is illegal) and 
					// then we can do the StoreText() call. The result will then be close to correct when all the 
					// docs have been processed. But note, we can do this call only once, otherwise the StoreText()
					// calls won't be able to accumulate reference counts in the KB. So use a counter to prevent
					// calling it more than once.
					m_nCallCount++;
#if defined(_DEBUG) && defined(NO_ASTERISK)
					wxLogDebug(_T("m_nCallCout: %d  at sequNum  %d"), m_nCallCount, pSP->m_nSequNumber);
#endif
					if (m_nCallCount == 1)
					{
						int refCountWanted = 1;
						pKB->SetRefCountsTo(refCountWanted, pSP);
					}
					// Now do the StoreText call so that the KB gets the adaptation for this src text stored in it
					// and don't suppress MakeTargetStringIncludingPunctuation from being called
					pKB->StoreText(pSP, adaption, TRUE); // TRUE is bool bSupportNoAdaptationButton (so that the
														 // StoreText will do a store of an empty string for adaption
#if defined(_DEBUG) && defined(NO_ASTERISK)
					wxString str;
					if (adaption.IsEmpty())
						str = _T("<no adaptation>");
					else
						str = adaption;
					wxLogDebug(_T("Storing KB entry: [ %s / %s ]  for sequNum %d"), 
						sourceKey.c_str(), str.c_str(), pSP->m_nSequNumber);
#endif
				}
			}
		}
	}
}

// BEW changed 25Aug11, removed the code for unloading the KBs, it is bad design to have
// it in here
/// BEW 12Jul19 moved mutex to start & end of function, because Evelyn at Gali'winku
/// (Warramiri - Matata) had a doc contents emptying experience
void CAdapt_ItView::ClobberDocument()
{
	CAdapt_ItApp* pApp = &wxGetApp();
	pApp->m_bDocumentDestroyed = TRUE;

	s_AutoSaveMutex.Lock();

	NormalizeState();

	wxASSERT(pApp != NULL);

	wxString msg = _T("ClobberDocument() entered; m_pSourcePhrases size = %d");
	int size = 0;
	if (pApp->m_pSourcePhrases->GetCount() > 0)
	{
		size = (int)pApp->m_pSourcePhrases->GetCount();
	}
	msg = msg.Format(msg, size);
	pApp->LogUserAction(msg);

	CAdapt_ItDoc* pDoc = (CAdapt_ItDoc*)GetDocument();
	wxASSERT(pDoc != NULL);
	CLayout* pLayout = GetLayout();

	// BEW 21Aug15, Default the following flag to a TRUE value - just in case 
	// collaboration mode may be in effect, next doc open should not have the 
	// flag with a FALSE value when first opened
	pApp->m_bConflictResolutionTurnedOn = TRUE;

	// when collaborating on a doc is finished, restore the Copy Source flag value to what
	// it was before it was automatically turned off
	if (pApp->m_bSaveCopySourceFlag_For_Collaboration)
	{
		pApp->m_bCopySource = FALSE;
		pApp->GetView()->ToggleCopySource(); // toggles m_bCopySource's value & resets menu item
		pApp->m_bSaveCopySourceFlag_For_Collaboration = FALSE; // when closing doc, always clear

        // whm 2Aug2018 Note: The Select Copied Source menu item is enabled only when the
        // m_bCopySource value is TRUE. Its check status is determined by the value the
        // user stored in the project config file (i.e., it may be ticked, but will be
        // disabled whenever the Copy Source menu item is not ticked.
    }

    // BEW added 21Apr08; clean out the global struct gEditRecord & clear its deletion
    // lists, because each document, on opening it, it must start with a truly empty
    // EditRecord; and on doc closure and app closure, it likewise must be cleaned out
    // entirely (the deletion lists in it have content which persists only for the life of
    // the document currently open)
	InitializeEditRecord(gEditRecord); // clears all except the deletion list
	gEditRecord.deletedAdaptationsList.Clear(); // remove any stored deleted adaptations
	gEditRecord.deletedGlossesList.Clear(); // remove any stored deleted gloss strings
	gEditRecord.deletedFreeTranslationsList.Clear(); // remove stored deleted free translns

// save settings for restoration from config file

	pApp->m_nActiveSequNum = 0;		// with no doc open, this must be zero
	pApp->m_lastDocPath = pApp->m_curOutputPath;

//	pApp->nLastActiveSequNum = pApp->m_nActiveSequNum;  - mrh Oct12 - axed, and last seq num is
//   written out in the doc's xml with docVersion 8.

    // now clobber it all the view stuff associated with the document, leaving an empty
    // document object
	pDoc->Modify(FALSE); // MFC has SetModifiedFlag(FALSE)

	pDoc->DeleteSourcePhrases();

	pLayout->GetInvalidStripArray()->Clear();
	pLayout->DestroyStrips();
	pLayout->DestroyPiles(); // restored, DestroySourcePhrases() no longer destorys
							 // the partner piles
	pApp->m_pActivePile = (CPile*)NULL;
	pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(_T(""));
	pApp->m_nActiveSequNum = -1;
	pApp->m_selectionLine = -1;
	Invalidate(); // our own
	GetLayout()->PlaceBox();

	// this is called from a number of places, and is not the appropriate place for trying
	// to remove read-only protection; on doc closure, do it instead from the more
	// specific document class's function OnFileClose() which calls ClobberDocument()

	gbDoingInitialSetup = TRUE; // MFC note: Needed because the phrase box will not
        //exist after the close is done, so if a <New Document> command is issued, then
        //OnButtonMerge() would otherwise fail if a LookAhead() merge was required on the
        //first words of the new document. I put it here because this is called for a doc
        //close by any method
    // NOTE: we don't change he values of the four flags associated with glossing, because
    // this function will be called for processes which serially open and close each
    // document of a project, and the flags will have to maintain their values across the
    // calls to ClobberDocument()

	// hide and disable the target box until input is expected
    pApp->m_pTargetBox->HidePhraseBox(); // hides all three parts of the new phrasebox

    pApp->m_pTargetBox->Enable(FALSE); // whm 12July2018 Note: It is re-enabled in ResizeBox()

	msg = _T("ClobberDocument() exiting");
	pApp->LogUserAction(msg);

	s_AutoSaveMutex.Unlock();
}

void CAdapt_ItView::CloseProject()
{
	wxCommandEvent dummyevent;
	OnFileCloseProject(dummyevent);
}

// targetStr will normally be the contents of the Phrase Box, but sometimes (such as when
// restoring punctuation when a placeholder is removed), it could be the m_targetStr member
// of a CSourcePhrase; it could have initial punctuation, it may not have, and/or final
// punctuation, or even in the case of a merger it may have medial punctuation, and it
// could have text starting with lower case and needing to become upper. BEW added 20 Apr
// 2005 checking of the app's flag m_bCopySourcePunctuation - which typically is TRUE, but
// for version 3 we wish to be able to temporarily suppress punctuation copy if the user
// clicks the No Punctuation Copy button on the command bar - so this flag was added to
// support this new functionality. The flag is automatically reset TRUE once the phrase box
// moves to a different location by any method.
//
// The goal of this function is to build a correct pSrcPhrase->m_targetStr string on the
// passed in pSrcPhrase instance
//
// BEW 11Oct10, added more members for doc version 5, so changes needed for supporting
// m_follOuterPunct and USFM fixedspace symbol ~ (which we now handle as a merger of two
// words) in order to cope with all punctuation possibilities on a ~ bound pair
// BEW 23Feb12, for docVersion 6, added support for suppression of redundant punctuation
// placement dialog as well as support for redundant marker placement dialogs in the event
// of doing an export; the how and why of all this is explain below in extensive comments
// about a third of the way into the function.
// BEW 21Jul14, for ZWSP support (nothing needed to be done)
// 
// BEW 29Nov23, significant refactoring & simplifications so as to handle grabbed prec or final functs
// and use them properly, and avoid having grabbed puncts clobbered by legacy code towards end
void CAdapt_ItView::MakeTargetStringIncludingPunctuation(CSourcePhrase *pSrcPhrase, wxString targetStr)
{	
	CAdapt_ItApp* pApp = &wxGetApp();
	CAdapt_ItDoc* pDoc = pApp->GetDocument();
	bool bHandledPrecPuncts = FALSE; // init
	bool bHandledFollPuncts = FALSE; // init BEW added 11Oct23

	if (pSrcPhrase->m_nSequNumber >= 4447)
	{
		int halt_here = 1; wxUnusedVar(halt_here);
	}
	
	targetStr = RemoveNulls(targetStr);
	wxString str = wxEmptyString;
	str = targetStr;
#if defined (_DEBUG) && !defined (NOLOGS)
	// whm 12May2023 added if (!str.IsEmpty()) test surrounding the wxLogDebug() statement below to avoid asserting
	// when str.Last() is called on an empty str. This assert occurred many times in Mike H's Exodus data.
	if (!str.IsEmpty())
	{
		wxLogDebug(_T("MakeTgtStrInclPunct JUST OPENED line %d , STRING= [%s]  LASTCHAR= [%d]"), __LINE__, str.c_str(), (int)str.Last());
	}
#endif
	wxChar* pEnd = NULL; // init
	bool bRemoveUnwantedLastChar = FALSE; // initialise

	wxString strFollPuncts;
	strFollPuncts = pSrcPhrase->m_follPunct;
	wxString strFollPunctsConverted;
	strFollPunctsConverted = wxEmptyString;

#if defined (_DEBUG) && !defined (NOLOGS)
	{
		wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], pSrcPhrase->m_key = [%s] , , pSrcPhrase->m_targetStr = [%s] , input targetStr= %s"),
			__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), pSrcPhrase->m_key.c_str(),  pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
		if (pSrcPhrase->m_nSequNumber >= 18)
		{
			int halt_here = 1; wxUnusedVar(halt_here);
		}
	}
#endif

	// The following call gets whatever final puncts are in the phrasebox - these are most
	// likely user typed ones; and this override sets the app boolean m_bFinalTypedPunctsGrabbedAlready
	// to TRUE if there are puncts returned in strGrabbedFinalPuncts. Use the boolean TRUE value
	// to suppress doubling up on the puncts shown, be using it further down; or instead use
	// strGrabbedFinalPuncts non-empty, and/or strGrabbedPrecPuncts non-empty... I use both ways below
	wxString boxContents = pApp->m_pTargetBox->GetValue();
	pApp->m_targetPhrase = boxContents;

	// BEW changed 6Feb23, pApp->m_TargetPhrase won't be uptodate with any manually type preceding or final
	// punctuation yet, but the passed in targetStr value WILL have what the phrasebox currently has, so
	// change to grabbing what's in targetStr, instead, for next two calls
	// 
	// whm 6Oct2023 modification: The above BEW comment of 6Feb23 is not accurate!
	// BEW reported on 6Oct2023 that any user-entered comma was not "sticking" when the 
	// phrasebox moved on.
	// Part of the reason for that comma not "sticking" issue is the change below that BEW 
	// did on 6Feb23 below.
	// Tracing through the code reveals that targetStr itself does not have any of the user 
	// entered final punctuation. However, the previous version of the code line below - before
	// BEW's change of 6Feb23, sets pApp->m_targetPhrase to the boxContents that DOES have 
	// any user-entered punctuation. Therefore I'm reversing BEWs change of 6Feb23 below
	// and am inputing pApp->m_targetPhrase into the GetManuallyAdded...Puncts() functions
	// making them take the pApp->m_targetPhrase as input parameter, rather than the targetStr.
	// This change makes the strGrabbedFinalPuncts contain any user-typed final punctuation.
	wxString strGrabbedFinalPuncts = GetManuallyAddedFinalPuncts(pApp->m_targetPhrase);
	// BEW 13Oct23 added puting the grabbed final puncts into pSrcPhrase->m_follPunct if
	// the latter is empty; and if the MakeTargetStringIncludingPunctuation() is called a
	// second time at the same sequNum, then a check is made on m_follPunct and if the
	// content is there, avoid adding the final punct a second time to m_targetStr
	if (!strGrabbedFinalPuncts.IsEmpty())
	{
		wxString finalPuncts = pSrcPhrase->m_follPunct;
		if (finalPuncts.IsEmpty())
		{
			pSrcPhrase->m_follPunct = strGrabbedFinalPuncts;
		}
		else
		{
			// pSrcPhrase->m_follPunct has content, avoid duplication 
			int offset = -1;
			offset = pSrcPhrase->m_follPunct.Find(strGrabbedFinalPuncts);
			if (offset == wxNOT_FOUND)
			{
				pSrcPhrase->m_follPunct = strGrabbedFinalPuncts;
			}
			// otherwise, it was a duplication situation, so no else block here
		}
	}

	wxString strGrabbedPrecPuncts = GetManuallyAddedPrecPuncts(pApp->m_targetPhrase);
	if (!strGrabbedPrecPuncts.IsEmpty())
	{
		wxString precPuncts = pSrcPhrase->m_precPunct;
		if (precPuncts.IsEmpty())
		{
			pSrcPhrase->m_precPunct = strGrabbedPrecPuncts;
		}
		else
		{
			// pSrcPhrase->m_PrecPunct has content, avoid duplication 
			int offset = -1;
			offset = pSrcPhrase->m_precPunct.Find(strGrabbedPrecPuncts);
			if (offset == wxNOT_FOUND)
			{
				pSrcPhrase->m_precPunct = strGrabbedPrecPuncts;
			}
			// otherwise, it was a duplication situation, so no else block here
		}
	}

#if defined (_DEBUG) && !defined (NOLOGS)
	{
		wxLogDebug(_T("MakeTgtStrIncPunc() line %d: strGrabbedPrecPuncts= %s , strGrabbedFinalPuncts= %s "),
			__LINE__, strGrabbedPrecPuncts.c_str(), strGrabbedFinalPuncts.c_str());
		if (pSrcPhrase->m_nSequNumber >= 18)
		{
			int halt_here = 1; wxUnusedVar(halt_here);
		}
	}
#endif

	// BEW 17May18 added a SimplePunctuationRestoration(pSrcPhrase) call here, which is
	// only called when pApp->m_bTypedNewAdaptationInChooseTranslation is TRUE. This 'simple'
	// function just uses preceding, following and outer following punctuation to recreate
	// a candidate m_targetStr value that can be passed back to the caller. There is no
	// fancy footwork. It is called only once typically, because pApp->m_bTypedNewAdaptationInChooseTranslation
	// is cleared to FALSE at the end of PlacePhraseBox(). PlacePhraseBox() normally only makes one call to
	// MakeTargetStringIncludingPunctuation(), from within the StoreText() call - which in turn is called when
	// the phrasebox is leaving the current location, or the user has clicked for some reason on the present
	// location. The boolean is set only in ChooseTranslation() and only when the user has typed a new
	// (non-empty) adaptation into the text box in the dialog provided for that purpose. Code in
	// the ChooseTranslation() dialog will then transfer the new translation (as an append to bottom of
	// the list) in the phrasebox - destroying and recreating the list in doing so, and ending with the
	// new meaning showing in the list, selected.
	// Note: BEW 29Nov23 MakeTargetStringIncludingPunctuation() gets used more often than suggested above,
	// because an else block has been added - so that the function is called when a store to KB is done
	wxString strResult = wxEmptyString;
	if (pApp->m_bTypedNewAdaptationInChooseTranslation)
	{
		if (pSrcPhrase == NULL)
		{
			::wxBell();
			return;
		}
#if defined (_DEBUG) && !defined (NOLOGS)
		{
			// the presence of 'NEW' will indicate this block was entered
			wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d , pSrcPhrase->m_key = %s , pSrcPhrase->m_adaption = %s , pSrcPhrase->m_targetStr = %s , input targetStr= %s "),
				__LINE__, pSrcPhrase->m_nSequNumber, pSrcPhrase->m_key.c_str(), pSrcPhrase->m_adaption.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
			if (pSrcPhrase->m_nSequNumber >= 18)
			{
				int halt_here = 1; wxUnusedVar(halt_here);
			}
		}
#endif

		// BEW added 19Feb20, handle adding final ) or ], providing that addition is
		// of a punctuation character, to targetStr. This is to handle new word final puncts
		// such as ) or ] or } when these are not in the source text, but only in what the user
		// types in the phrasebox - the first such typing gets ] or ) or } added automatically,
		// but after the kb has received the key string which lacks such final ] or ) or }, the
		// matching ] or ) or } won't get into the document's m_targetStr member unless we 
		// explicitly provide it. But it needs no such addition if the ) or ] or } is already
		// present in targetStr passed in. The next call does this work, and if what's
		// needed was provided by the user manually typing it in, the returned wxString
		// will be empty - so we avoid doubling up - such as )) or ]]
		wxString strEnding = ProvideMatchingEndBracketOrParenthesis(targetStr); // this should return empty string 
																		// if ( [ or { are initial in targetStr
		// BEW 25Oct22, for a location which is <Not In KB>, there may be a user-typed value
		// when the box lands there, but the above call will return the empty string. If we
		// set the later str value to the empty string, we'll run into problems at 17630
		// below where pSrcPhrase->m_targetStr = str (emtpy). I'll just return the empty str.
		if (targetStr.IsEmpty())
		{
			return;
		}

		if (!strEnding.IsEmpty() && !pApp->m_targetPhrase.IsEmpty())
		{
			pApp->m_targetPhrase += strEnding; // add the ) or ]
			targetStr += strEnding; // add it also to what was passed in
			pApp->m_pTargetBox->SetValue(targetStr); // get the phrasebox agreeing
		}
#if defined (_DEBUG) && !defined (NOLOGS)
		{
			wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], pSrcPhrase->m_key = [%s] , , pSrcPhrase->m_targetStr = [%s] , input targetStr= %s"),
				__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), pSrcPhrase->m_key.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
			if (pSrcPhrase->m_nSequNumber >= 18)
			{

				int halt_here = 1; wxUnusedVar(halt_here);
			}
		}
#endif
		bool bHandledPrecedingPunctuation = FALSE;
		bool bHandledFollowingPunctuation = FALSE;
		wxString plusPuncts = pApp->SimplePunctuationRestoration(pSrcPhrase, bHandledPrecedingPunctuation, bHandledFollowingPunctuation);
		if (plusPuncts.IsEmpty())
		{
			// We don't support empty adaptations with the mechanism which gets a new adaptation
			// by the user typing one into the ChooseTranslation() dialog. So if something were to 
			// go wrong and an empty string is returned, our default action is to instead just
			// copy the pSrcPhrase->m_adaption value into the m_targetStr member. Doing so avoids
			// what could be a distressing perception of the newly typed adaptation not 'taking'
			// when the phrasebox is moved on somewhere else, leaving behind a blank 'hole' (but
			// if the user were to reposition the phrasebox there, the dropdown list would have
			// the newly typed adaptation and could be successfully chosen from the list at that
			// time).
			pSrcPhrase->m_targetStr = pSrcPhrase->m_adaption;
		}
		else
		{
			pSrcPhrase->m_targetStr = plusPuncts; // now includes ) or ] from strEnding if required
		}
#if defined (_DEBUG) && !defined (NOLOGS)
		{
			wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], pSrcPhrase->m_key = [%s] , , pSrcPhrase->m_targetStr = [%s] , input targetStr= %s"),
				__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), pSrcPhrase->m_key.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
			if (pSrcPhrase->m_nSequNumber >= 18)
			{
				int halt_here = 1; wxUnusedVar(halt_here);
			}
		}
#endif
		return;
		// Note, m_bTypedNewAdaptationInChooseTranslation is reinitialized to FALSE in PlacePhraseBox() 
		// control exits from it
	} // end of TRUE block for test: if (pApp->m_bTypedNewAdaptationInChooseTranslation)

	// BEW 24Nov22 add an else block here. Why? This function was not adding final puncts early (i.e. here), to
	// pSrcPhrase->m_targetStr. As a result, when below, where the passed in targetStr has a buffer
	// created, for pBuffStart, and also pEnd, if the following punctuation stored in m_follPunct and
	// m_follOuterPunct, is not restored to pSrcPhrase->m_targetStr, then the pEnd created will not be after that
	// restored punctuation. Then, no matter what else happens below, that punctuation will be omitted from the
	// adaptation line of the GUI. So this else block is to fix that problem. 
	else
	{
		// whm 2Oct2023 BEW reported that clicking on the <no adaptation> control button didn't result in the 
		// phrasebox being emptied. It appears that this issue arose after BEW provided this else block to the
		// preceding if block at line  16862 above if (pApp->m_bTypedNewAdaptationInChooseTranslation).
		// Note that within the if block above there is a test if (targetStr.IsEmpty()) which when targetStr 
		// is empty causes this MakeTargetStringIncludingPunctuation() function to exit before calling the
		// SimplePunctuationRestoration() function at line 16906 above, and now again below.
		// I believe that not check for an empty targetStr here (like in the if block abov) in order to
		// cause a premature exit from this function - was an omission here. Because the call of the
		// SimplePunctuationRestoration() below will produce a strResult from the pSrcPhrase's m_key which
		// is then wrongly assigned to pSrcPhrase->m_targetStr which was previously emptied by the <no adaptation>
		// button press. Therefore, to fix this issue I am putting the same if (targetStr.IsEmpty() test here
		// and allowing for the function to exit before the SimplePunctuationRestoration() call is made
		if (targetStr.IsEmpty())
		{
			return;
		}
#if defined (_DEBUG) && !defined (NOLOGS)
		{
			wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], pSrcPhrase->m_key = [%s] , pSrcPhrase->m_targetStr = [%s] , input targetStr= %s"),
				__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), pSrcPhrase->m_key.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
			if (pSrcPhrase->m_nSequNumber >= 18)
			{
				int halt_here = 1; wxUnusedVar(halt_here);
			}
		}
#endif

		// BEW 12Dec22 SimplePunctuationRestoration(pSrcPhrase, strEnding) will return any punctuation from, say,
		// m_follPunct that was stored in pSrcPhrase->m_follPunct etc and preceding puncts too;
		// BEW 25May23, added 2nd param, bHandledPrecPuncts, so that later below we can use it to
		// suppress dealing with m_precPunct a second time, resulting in doubling of the preceding punctuation
		// BEW 11Oct23 added 3rd param, for same kind of reason
		// BEW 29Nov23 SimplePunctuationRestoration() now refactored majorly, to be simpler - and the returned
		// two booleans are no longer needed in code below - (but returned FALSE if manual typed puncts in phrasebox)
		bHandledPrecPuncts = FALSE; // init
		bHandledFollPuncts = FALSE; // init  BEW added 11Oct23 -- note these bools are at function top, 16764-5
		// but the earlier call at 16921 uses longer ones, bHandledPrecedingPunctuation and bHandledFollowingPunctuation
		strResult = pApp->SimplePunctuationRestoration(pSrcPhrase, bHandledPrecPuncts, bHandledFollPuncts);

#if defined (_DEBUG) && !defined (NOLOGS)
		{
			wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, strResult= [%s], pSrcPhrase->m_key = [%s] , pSrcPhrase->m_targetStr = [%s] , input targetStr= %s"),
				__LINE__, pSrcPhrase->m_nSequNumber, strResult.c_str(), pSrcPhrase->m_key.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
			if (pSrcPhrase->m_nSequNumber >= 18)
			{

				int halt_here = 1; wxUnusedVar(halt_here);
			}
		}
#endif
		if (!strResult.IsEmpty())
		{
			pSrcPhrase->m_targetStr = strResult;
// NOLOGS	wxLogDebug(_T("MakeTgtStrInclPunct line %d , STRING= [%s]  LASTCHAR= [%d]"), __LINE__, pSrcPhrase->m_targetStr.c_str(), (int)pSrcPhrase->m_targetStr.Last());
		}
		else
		{
			// BEW 30Dec22 Empty strResult means that targetStr passed in is empty. A diagnostic of a detached openParenthesis
			// The other two diagnostics are that m_precPunct contains only '(', and m_srcPhrase also contains only '('
			// and all other values are empty, except for sequ number, and number of words (which will be 1). Check
			if (pSrcPhrase->m_precPunct == _T('(') && pSrcPhrase->m_srcPhrase == _T('('))
			{
				// The only thing that moving the empty box forward with an Enter or Tab keypress, would be to leave
				// m_adaption empty, and m_targetStr set to _T('(')
				pSrcPhrase->m_targetStr = _T('(');
// NOLOGS	wxLogDebug(_T("MakeTgtStrInclPunct line %d , STRING= [%s]  LASTCHAR= [%d]"), __LINE__, pSrcPhrase->m_targetStr.c_str(), (int)pSrcPhrase->m_targetStr.Last());
				return;
			}
			// Another isolate punct is the [ on its own line following \p marker, and then a newline follows (or after a space)
			if (pSrcPhrase->m_precPunct == _T('[') && pSrcPhrase->m_srcPhrase == _T('['))
			{
				pSrcPhrase->m_targetStr = _T('[');
// NOLOGS				wxLogDebug(_T("MakeTgtStrInclPunct line %d , STRING= [%s]  LASTCHAR= [%d]"), __LINE__, pSrcPhrase->m_targetStr.c_str(), (int)pSrcPhrase->m_targetStr.Last());
				return;
			}
		}
	}
	// BEW 6Apr23 test for SimplePunctuationRestoration() having added pSrcPhrase->m_follPunct, use .Find(). and if
	// offset is >0, then the punct(s) are already added. Have a bool here that we can then text below where
	// bAlreadyHasFollPunct is, and don't default it to FALSE at initialization, make it TRUE if the puncts were added
	// just above
	bool bSimpleHasAppendedPuncts = FALSE; // init
	bSimpleHasAppendedPuncts = bSimpleHasAppendedPuncts; // avoid gcc warning set but not used warning
	int offsett = wxNOT_FOUND;
	wxString follPunctsStr = pSrcPhrase->m_follPunct;
	if (!follPunctsStr.IsEmpty())
	{
		offsett = strResult.Find(follPunctsStr);
		if (offsett != wxNOT_FOUND)
		{
			bSimpleHasAppendedPuncts = TRUE;
		}
	}

	pApp->m_nPlacePunctDlgCallNumber++;
	int theSequNum = pSrcPhrase->m_nSequNumber;

#if defined (_DEBUG) && !defined (NOLOGS)
	{
		wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], pSrcPhrase->m_key = [%s] , , pSrcPhrase->m_targetStr = [%s] , input targetStr= %s"),
			__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), pSrcPhrase->m_key.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
		if (pSrcPhrase->m_nSequNumber >= 18)
		{
			int halt_here = 1; wxUnusedVar(halt_here);
		}
	}
#endif

    // BEW added 19Dec07: bleed out the case when Reviewing mode is on and the box is about
    // to leave a hole which may or may not have had punctuation there; the former
    // m_targetStr is preserved in m_StrSavedTargetStringWithPunctInReviewingMode, and the
    // test for needing to do this restoration is that the global flag
    // m_bSavedTargetStringWithPunctInReviewingMode is TRUE, and we must clear the flag
    // before returning
    // Don't do the next block if the function was called before at same location
	if ( !(theSequNum == pApp->m_nCurSequNum_ForPlacementDialog && pApp->m_nPlacePunctDlgCallNumber > 1) )
	{
		if (pApp->m_pTargetBox->m_bSavedTargetStringWithPunctInReviewingMode)
		{
			// the flag will only be true when the location was a hole when the box
			// landed there, so we can rely on m_targetPhrase being empty provided the
			// user has not decided to edit the document by typing something. So we
			// check for a still empty m_targetPhrase, and if so we restore m_targetStr
			// to what it was before and return; but if the user has typed something
			// then we abandon what we saved and we do a normal pass through the rest
			// of this function
			if (pApp->m_targetPhrase.IsEmpty())
			{
				// it is still empty, so do the restoration etc.
				pSrcPhrase->m_targetStr = pApp->m_pTargetBox->m_StrSavedTargetStringWithPunctInReviewingMode;
                pApp->m_pTargetBox->m_StrSavedTargetStringWithPunctInReviewingMode.Empty();
                pApp->m_pTargetBox->m_bSavedTargetStringWithPunctInReviewingMode = FALSE; // restore default value
#if defined (_DEBUG) && !defined (NOLOGS)
				if (!pSrcPhrase->m_targetStr.IsEmpty())
					wxLogDebug(_T("MakeTgtStrInclPunct line %d , STRING= [%s]  LASTCHAR= [%d]"),
						__LINE__, pSrcPhrase->m_targetStr.c_str(), (int)pSrcPhrase->m_targetStr.Last());
#endif
				return;
			}
			// user must have typed something, so clean up and control can fall thru
			// to the rest
            pApp->m_pTargetBox->m_StrSavedTargetStringWithPunctInReviewingMode.Empty();
            pApp->m_pTargetBox->m_bSavedTargetStringWithPunctInReviewingMode = FALSE; // restore default value
		}
	}
    // BEW added 1Jul09, don't do the code in this function if the function has been called
    // once before at this current active location
	if ( !(theSequNum == pApp->m_nCurSequNum_ForPlacementDialog && pApp->m_nPlacePunctDlgCallNumber > 1) )
	{
/* #if defined(_DEBUG)
	wxLogDebug(_T("MakeTargetStringIncludingPunctuation() second: sn = %d , targetStr = %s , m_targetPhrase = %s , m_targetStr = %s"),
		theSequNum, targetStr.c_str(), pApp->m_targetPhrase.c_str(), pSrcPhrase->m_targetStr.c_str());
#endif */

        // BEW 11Oct10, have to handle ~ -- need a separate block for this as it is more
        // complex, and also need to take m_follOuterPunct into consideration in both
        // blocks
		// BEW 29Nov23 because we now ignore tilde (~) USFM fixed space marker, but treat
		// conjoined words simply as a larger single word, we no longer need to determine
		// if ~ is within pSrcPhrase members. So IsFixedSpaceSymbolWithin() always now returns FALSE
		if (!IsFixedSpaceSymbolWithin(pSrcPhrase))
		{
			// BEW 28Nov23 IsFixedSpaceSymbolWithin() now always returns FALSE
			// also, there is no good reason why the user might not manually type
			// more than one final punct, so we should allow grabbedLen to be >= 1.
			// Moreover, m_bFinalTypedPunctsGrabbedAlready, and m_bPrecTypedPunctsGrabbedAlready
			// will have been set already - before SimplePunctuationRestoration() gets called,
			// and so may be either or both TRUE here. So it's an error to force these to false
			// in the code below - doing so make it cumbersome to set pSrcPhrase->m_targetStr
			// correctly, as that's all that remains to be done. So heavily refactor what follows.
			// Moreover, handle post word puncts separately from pre-word puncts, don't have an OR test
			int grabbedLen = 0;
			int anOffset = wxNOT_FOUND;
			wxUnusedVar(anOffset); // BEW added 28Nov23
			if (!strGrabbedFinalPuncts.IsEmpty())
			{
				// do any needed punct conversion
				wxString tgtFinalPunct = GetConvertedPunct(strGrabbedFinalPuncts);
				grabbedLen = tgtFinalPunct.Len();
				strGrabbedFinalPuncts = tgtFinalPunct;

#if defined (_DEBUG) && !defined (NOLOGS)
				{
					wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], pSrcPhrase->m_key = [%s] , , pSrcPhrase->m_targetStr = [%s] , input targetStr= %s"),
						__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), pSrcPhrase->m_key.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
					if (pSrcPhrase->m_nSequNumber >= 18)
					{
						int halt_here = 1; wxUnusedVar(halt_here);
					}
				}
#endif
			} // end of true block for test: if (!strGrabbedFinalPuncts.IsEmpty())

			if (pApp->m_bFinalTypedPunctsGrabbedAlready) // || pApp->m_bPrecTypedPunctsGrabbedAlready)
			{
				// Allow what user typed, to stand 'as is'; and there is no fixedspace conjoining
#if defined (_DEBUG) && !defined (NOLOGS)
				{
					wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], strGrabbedFinalPuncts= [%s] , , pSrcPhrase->m_targetStr = [%s] , input targetStr= %s"),
						__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), strGrabbedFinalPuncts.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
					if (pSrcPhrase->m_nSequNumber >= 18)
					{
						int halt_here = 1; wxUnusedVar(halt_here);
					}
				}
#endif
				// BEW 28Nov23, strGrabbedFinalPuncts has what was grabbed for final puncts, e.g. ')' or ').' or ']" or '}' etc
				// so getting the correct m_targetStr value should just be a matter of appending strGrabbedFinalPuncts to the
				// already correctly set pSrcPhrase->m_adaption value-- but we above initialised m_targetStr to the value of
				// m_adaption, so we can just append to m_targetStr
				wxASSERT(grabbedLen > 0);
				pSrcPhrase->m_targetStr += strGrabbedFinalPuncts;

				// BEW 23Apr15 if in a merger, we want / converted to ZWSP for the target text
				if (pSrcPhrase->m_nSrcWords > 1)
				{
					// No changes are made if app->m_bFwdSlashDelimiter is FALSE
					pSrcPhrase->m_targetStr = FwdSlashtoZWSP(pSrcPhrase->m_targetStr);
				}
			} // end of TRUE block for test: if (pApp->m_bFinalTypedPunctsGrabbedAlready // || pApp->m_bPrecTypedPunctsGrabbedAlready)

			// BEW 28Nov23 now handle any preceding manually typed puncts, or none
			grabbedLen = 0;
			if (!strGrabbedPrecPuncts.IsEmpty())
			{
				// do any needed punct conversion
				wxString tgtPrecPunct = GetConvertedPunct(strGrabbedPrecPuncts);
				grabbedLen = tgtPrecPunct.Len();
				strGrabbedPrecPuncts = tgtPrecPunct;
#if defined (_DEBUG) && !defined (NOLOGS)
				{
					wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], strGrabbedPrecPuncts= [%s], pSrcPhrase->m_targetStr = [%s] , input targetStr= %s"),
						__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), strGrabbedPrecPuncts.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
					if (pSrcPhrase->m_nSequNumber >= 18)
					{
						int halt_here = 1; wxUnusedVar(halt_here);
					}
				}
#endif
			} // end of true block for test: if (!strGrabbedFinalPuncts.IsEmpty())

			// BEW 28Nov23 now deal with any preceding puncts that were grabbed
			if (pApp->m_bPrecTypedPunctsGrabbedAlready)
			{
				// Allow what user typed, to stand 'as is'; and there is no fixedspace conjoining
#if defined (_DEBUG) && !defined (NOLOGS)
				{
					wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], strGrabbedPrecPuncts= [%s], pSrcPhrase->m_targetStr = [%s] , input targetStr= %s"),
						__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), strGrabbedPrecPuncts.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
					if (pSrcPhrase->m_nSequNumber >= 18)
					{
						int halt_here = 1; wxUnusedVar(halt_here);
					}
				}
#endif
				// BEW 28Nov23, strGrabbedPrecPuncts has what was grabbed for preceding puncts, e.g. '(' or '[' or '{' etc
				// so getting the correct m_targetStr value should just be a matter of inserting strGrabbedPrecPuncts before the
				// m_targetStr value - except that autocapitalization of the adaption string may be required in this block as well
				wxASSERT(grabbedLen > 0);
				
				// BEW 28Nov23, only two things needed here: (2) setting any manually typed preceding puncts into pSrcPhrase
				// to form a correct m_targetStr value; and (1) do any needed autocapitalizing of first char of adaptation

				wxChar chFirst = pSrcPhrase->m_targetStr.GetChar(0); // we don't want this to be a punctuation character.
				CAdapt_ItApp* pApp = &wxGetApp();
				CAdapt_ItDoc* pDoc = pApp->GetDocument();
				anOffset = pApp->m_punctuation[1].Find(chFirst);
				// do (1)
				if (anOffset == wxNOT_FOUND)
				{
					// m_targetStr currently begins with no punctuation of tgt type, so we assume it's tgt text - so capitalizable
					// and capitalized if should be so
					bool bNoError = pDoc->SetCaseParameters(pSrcPhrase->m_targetStr, FALSE); // FALSE is bIsSrcText
					if (bNoError && !gbNonSourceIsUpperCase && (gcharNonSrcUC != _T('\0')))
					{
						// do the change to upper case for the wxChar at index 0
						str.SetChar(0, gcharNonSrcUC);
					}
				}
				// do (2)
				pSrcPhrase->m_targetStr = strGrabbedPrecPuncts + pSrcPhrase->m_targetStr; // that should give correct m_targetStr,

#if defined (_DEBUG) && !defined (NOLOGS)
				{
					wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], pSrcPhrase->m_key = [%s] , pSrcPhrase->m_targetStr= [%s] , input targetStr= %s"),
						__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), pSrcPhrase->m_key.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
					if (pSrcPhrase->m_nSequNumber >= 18)
					{
						int halt_here = 1; wxUnusedVar(halt_here);
					}
				}
#endif
				// BEW 23Apr15 if in a merger, we want / converted to ZWSP for the target text
				if (pSrcPhrase->m_nSrcWords > 1)
				{
					// No changes are made if app->m_bFwdSlashDelimiter is FALSE
					pSrcPhrase->m_targetStr = FwdSlashtoZWSP(pSrcPhrase->m_targetStr);
				}
#if defined (_DEBUG) && !defined (NOLOGS)
				{
					wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], pSrcPhrase->m_key = [%s] , pSrcPhrase->m_targetStr= [%s] , input targetStr= %s"),
						__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), pSrcPhrase->m_key.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
					if (pSrcPhrase->m_nSequNumber >= 18)
					{
						int halt_here = 1; wxUnusedVar(halt_here);
					}
				}
#endif
				// end of copied code, to tweak for preceding puncts support
			} //  end of TRUE block for test: if (pApp->m_bPrecTypedPunctsGrabbedAlready)

			// refactor span ends here BEW 28NOV23
			else
			{
			// the legacy situation, and no ~ fixedspace conjoining...

			// BEW 20Feb20, this is where we need to call ProvideMatchingEndBracketOrParenthesis()
			// -- see top of function for full explanation of why it is needed
			// BEW 12Oct22 refactor the following function a little - it conflicts with
			// our "detached [" support code, by providing an unwanted ']', so that m_targetStr
			// becomes (wrongly) "[]" rather than remaining as "[". Fuller explanation, see comments
			// prior to the function body. Our refactor returns empty string, if just "[" was passed in.
			wxString strEnding = ProvideMatchingEndBracketOrParenthesis(targetStr);
			if (!strEnding.IsEmpty() && !pApp->m_targetPhrase.IsEmpty())
			{
				pApp->m_targetPhrase += strEnding; // add the ) or ]
				targetStr += strEnding; // add it also to what was passed in
				pApp->m_pTargetBox->SetValue(targetStr); // get the phrasebox agreeing
			}

			// Legacy code continues...
			str = targetStr; // make a copy
			wxArrayString remainderList;
			wxString strCorresp;	// where we build target punctuation strings (from the
				// punctuation correspondences pairs) before inserting them into m_targetStr
			strCorresp.Empty();

#if defined (_DEBUG) && !defined (NOLOGS)
			{
				wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], pSrcPhrase->m_key = [%s] , , pSrcPhrase->m_targetStr = [%s] , input targetStr= %s"),
					__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), pSrcPhrase->m_key.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
				if (pSrcPhrase->m_nSequNumber >= 18)
				{
					int halt_here = 1; wxUnusedVar(halt_here);
				}
			}
#endif
			// for auto-capitalization we will attempt to do any needed change to upper
			// case, no matter what the punctuation behaviour is. If a lookup was done
			// earlier, and a store not yet done, then the value of the gbMatchedKB_UCentry
			// flag will also be valid here (if it is TRUE then we don't want a change to
			// upper case done because the lookup was done with upper case source data - so
			// we take the adaptation or gloss 'as is')

			// first find out what the key's case status is
			bool bNoError = TRUE;
			bool bWantChangeToUC = FALSE; // if TRUE, we want the change to upper case
											// done if possible
			if (gbAutoCaps)
			{
				bNoError = pDoc->SetCaseParameters(pSrcPhrase->m_key);
				if (bNoError && gbSourceIsUpperCase && !gbMatchedKB_UCentry)
				{
					bWantChangeToUC = TRUE;
				}
			}

			// if it is <Not In KB> then suppress punctuation insertion - there is nothing
			// supposed to be "there" anyway -- from version 1.4.0 and onwards, by Susanna
			// Imrie's suggestion, we will allow a non-null adaptation for a <not in kb> entry;
			// we just won't store it in the kb -- so just go on...

			// we don't worry about internal punctuation in the target if the target is empty
			// in fact, we don't want any punctuation if the target is empty
			bool bEmptyTarget = FALSE;
			// BEW 2Mar15 some refactoring to better support [ and ] brackets replacements
			bool bSquareBracketOnlyAsPunct = FALSE; // initialize
			if (str.IsEmpty())
			{
				// [ if present, needs to be initial if there is more than one preceding punct;
				// and ] if present, needs to be final if there is more than one following punct
				// (The TokenizeText() parser nevertheless should immediately break out an [
				// (whenever encountered) as a separate CSourcePhrase, and coming to a ] it
				// immediately terminate the word parse, so that the ] will be broken out as
				// a separate CSourcePhrase on the next iteration -- so it should never be the
				// case that [ or ] are not the only punctuation character in m_precPunct or
				// in m_follPunct. The code below could therefore be written more simply
				// if we prefer - just assume [ or ] if present are the whole punct string.)
				int offset1 = pSrcPhrase->m_precPunct.Find(_T("["));
				int offset2 = pSrcPhrase->m_follPunct.Find(_T("]"));
				if (offset1 == 0)
				{
					bSquareBracketOnlyAsPunct = TRUE;
				}
				else  if ((offset2 > wxNOT_FOUND) &&
					(pSrcPhrase->m_follPunct.GetChar(pSrcPhrase->m_follPunct.Len() - 1) == (wxChar)_T(']')))
				{
					bSquareBracketOnlyAsPunct = TRUE;
				}
			} // end of TRUE block for test: if (str.IsEmpty())
#if defined (_DEBUG) && !defined (NOLOGS)
			{
				wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], pSrcPhrase->m_key = [%s] , , pSrcPhrase->m_targetStr = [%s] , input targetStr= %s"),
					__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), pSrcPhrase->m_key.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
				if (pSrcPhrase->m_nSequNumber >= 18)
				{
					int halt_here = 1; wxUnusedVar(halt_here);
				}
			}
#endif

			if (!str.IsEmpty() && pApp->m_bCopySourcePunctuation)
			{
				// Check for any medial punctuation, if there is any, see if it is all in
				// the targetStr already; if not, ask user for whatever is missing (if he
				// wants he can then place the extra stuff, or ignore it).
				if (pSrcPhrase->m_bHasInternalPunct)
				{
					if (!pSrcPhrase->m_lastAdaptionsPattern.IsEmpty())
					{
						// m_lastAdaptionsPattern is not empty, therefore it contains the
						// m_adaptions value (& that NEVER has punctuation not stripped
						// off) as it was at the last time the above placement dialog was
						// invoked -- so now we compare with the contents of the passed in
						// targetStr parameter, with the m_lastAdaptionsPattern member of
						// the current active pSrcPhrase instance passed in
						bool bNoChange = IsPhraseBoxAdaptionUnchanged(pSrcPhrase, str);
						if (bNoChange)
						{
							// let control continue to the block further below
							;
						}
						else
						{
							// there has been a change, so empty the 4 state-storing
							// docVersion 6 string members (we empty them all for safety's
							// sake, because the change may also require that in an export
							// of the target text, or glosses-as-text, marker placement
							// may need redoing as well. At worst this can only result in
							// one further showing of a relevant placement dialog at a
							// later export invocation.
							// BEW 30Sep19 - I hope soon to have either removed the need
							// for placement dialogs, or reduced their incidence severely.
							// When doing that refactoring, these 3 may be repurposable.
							pSrcPhrase->m_lastAdaptionsPattern = _T("");
							pSrcPhrase->m_tgtMkrPattern = _T("");
							pSrcPhrase->m_glossMkrPattern = _T("");

							// BEW 30Sep19 m_punctsPattern is now used for hiding 
							// bar-to-endmarker attributes-having metadata.
							// So,I can no longer initialize it unconditionally to
							// empty - instead, just comment it out
							//pSrcPhrase->m_punctsPattern = _T("");
						}
					}
#if defined (_DEBUG) && !defined (NOLOGS)
					{
						wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], pSrcPhrase->m_key = [%s] , , pSrcPhrase->m_targetStr = [%s] , input targetStr= %s"),
							__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), pSrcPhrase->m_key.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
						if (pSrcPhrase->m_nSequNumber >= 18)
						{
							int halt_here = 1; wxUnusedVar(halt_here);
						}
					}
#endif

					// BEW 11Oct23 since a couple of months ago I decided to change fixed space ~ support
					// to just accept the conjoined-by-tilde words as wholes, for the KB, we no longer
					// need to call this CPlaceInternalPunct dialog, m_targetStr is already correct

					// If the m_lastAdaptionsPattern is empty, for any reason, we must do
					// a punctuation placement using the dialog for that purpose
					if (pSrcPhrase->m_lastAdaptionsPattern.IsEmpty())
					{

#if defined (_DEBUG) && !defined (NOLOGS)
						{
							wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], pSrcPhrase->m_key = [%s] , , pSrcPhrase->m_targetStr = [%s] , input targetStr= %s"),
								__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), pSrcPhrase->m_key.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
							if (pSrcPhrase->m_nSequNumber >= 18)
							{
								int halt_here = 1; wxUnusedVar(halt_here);
							}
						}
#endif

						// BEW 23Feb12, Store the placed-punctuation state pending the
						// possibility that this current active location may be returned to
						// at some later time, by the user -- if so, we want the stored
						// state to be used for setting m_targetStr, rather than showing
						// the placement dialog again. Two strings need to be stored,
						// m_adaptions (and we call RemovePunctuation() on it to ensure no
						// punctuation slips through the net here), and the value of str
						// as set from the dialog's m_tgtPhrase member above - the latter
						// has, of course, the punctuation unambiguously placed (that, of
						// course, doesn't preclude the possibility of user error in doing
						// the placement; for that eventuality, there is a Change
						// Punctuation or Markers Pattern menu item in the GUI by which
						// the user can, after putting the phrase box back at the current
						// active location, click the menu item and answer Yes in the
						// resulting Yes/No message box, which will force all four of the
						// state-saving wxString members discussed above, to be emptied
						// (which in turn causes the relevant placement dialog(s) to open
						// at this location again, at the appropriate time, for the user
						// to correct his former placement error(s).)
						wxString nopunctsForSureStr = pSrcPhrase->m_adaption;
						RemovePunctuation(pDoc, &nopunctsForSureStr, 1); // 1 means "tgt
														// text punctuation is to be used"
						// now save state as described above
						pSrcPhrase->m_lastAdaptionsPattern = nopunctsForSureStr;
#if defined (_DEBUG) && !defined (NOLOGS)
						{
							wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], pSrcPhrase->m_key = [%s] , , pSrcPhrase->m_targetStr = [%s] , input targetStr= %s"),
								__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), pSrcPhrase->m_key.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
							if (pSrcPhrase->m_nSequNumber >= 18)
							{
								int halt_here = 1; wxUnusedVar(halt_here);
							}
						}
#endif
						// BEW 30Sep19 comment out - this function needs refactoring:  	pSrcPhrase->m_punctsPattern = str; <<-- I've repurposed this
					} // end of TRUE block for test: if (pSrcPhrase->m_lastAdaptionsPattern.IsEmpty())
					else
					{
						// if control enters here, we've determined that the word or words
						// of the target text aren't changed, and the user hasn't
						// explicitly typed punctuation into the phrase box, so we've
						// every reason to expect that the former saved state for
						// punctuation placement, and word spellings, are unchanged and so
						// can be restored here without recourse to the placement dialog
						;
					}
				} // end of TRUE block for test: if (pSrcPhrase->m_bHasInternalPunct) -- matched, correct indent level

			} // end of TRUE block for test: if (!str.IsEmpty() && pApp->m_bCopySourcePunctuation) -- matched, indent right
			else
			{
				bEmptyTarget = TRUE; // BEW 20May16, the test being false is an excuse
						// for setting this boolean TRUE, since there's no test of the
						// phrasebox contents - so make such a test next, as that's what matters
			}
#if defined (_DEBUG) && !defined (NOLOGS)
			{
				wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], pSrcPhrase->m_key = [%s] , , pSrcPhrase->m_targetStr = [%s] , input targetStr= %s"),
					__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), pSrcPhrase->m_key.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
				if (pSrcPhrase->m_nSequNumber >= 18)
				{
					int halt_here = 1; wxUnusedVar(halt_here);
				}
			}
#endif

			// BEW 20May16 added this block. We need to support scenarios where the user 
			// may want to override by not having any copy done, but explicitly type his 
			// different puntuation (which may be preceding or following the word, or both), 
			// or omit some or all of the punctuation, and have only that/those punctuation
			// characters, or lack thereof, handled automatically when the box moves
			if (pSrcPhrase->m_nSequNumber <= pApp->GetMaxIndex() && !pApp->m_bReadOnlyAccess)
			{
				// A phrase box should be visible at the active location
				if (!pApp->m_pTargetBox->GetTextCtrl()->GetValue().IsEmpty()) // whm 12Jul2018 added GetTextCtrl()-> part
				{
					// The phrasebox has content, so we must conform so the protocol for the
					// user overriding the otherwise-copied src punctuation can operate...
					bEmptyTarget = FALSE;
				}
			}

			// BEW addition 23March05, to allow detached punctuation to be reconstructed in
			// the target text I do it here and not for the internal punctuation case above
			// because it would make no sense to do the block of code above when the target
			// is empty
			bool bWantPrecCopy;
			int punctLen;
			// BEW added 20 April 2005 to support the use of the new No Punctuation Copy
			// button. Don't restore the TRUE value for this flag at the end of this
			// function because the function can be called more than once while the phrase
			// box is unmoved. Do the flag restoration to TRUE in code which moves the
			// phrase box elsewhere
			if (!pApp->m_bCopySourcePunctuation)
			{
				// BEW addition 27Mar13. If AutoCaps is turned on, and the source text
				// commences with a capital letter, check if capitalization is needed here.
				// Beware, str may have initial punctuation (e.g. the user may have typed
				// it) so remove and replace it after any needed capitalization is done.
				// Then control can exit here, after a little housekeeping. Any puncts
				// stored in m_precPunct etc won't be copied in this block, so we only
				// have to consider that the user may have typed some
				punctLen = 0; // for auto caps support
				wxString punctlessStr;
				wxString strInitialPunct;
				strInitialPunct = wxEmptyString;
				if (!bEmptyTarget && bWantChangeToUC)
				{
					// span using target lang's punctuation - wxWidgets version
					// SpanIncluding() in helpers.h; spanning done in tgt text puncts
					strInitialPunct = SpanIncluding(str, pApp->m_punctuation[1]);
					if (!strInitialPunct.IsEmpty())
					{
						// first, remove and store the initial punctuation
						punctLen = strInitialPunct.Length();
						punctlessStr = str.Mid(punctLen); // it's irrelevant if there are word-final
															// puncts on punctlessStr

						// now check if punctlessStr commences with a lower case letter,
						// if so, convert to upper case and then re-attach the intial
						// punctuation character/s (FALSE in next line means "bIsSrcText")
						bNoError = pDoc->SetCaseParameters(punctlessStr, FALSE);
						if (bNoError && !gbNonSourceIsUpperCase && (gcharNonSrcUC != _T('\0')))
						{
							// do the change to upper case
							punctlessStr.SetChar(0, gcharNonSrcUC);
						}

						// If strGrabbedPrecPunct is not empty, the user typed initial punctuation
						// to replace any that were there previously, or add if there was none
						if (strGrabbedPrecPuncts.IsEmpty())
						{
							str = strInitialPunct + punctlessStr;
						}
						else
						{
							// a replacive situation
							str = strGrabbedPrecPuncts + punctlessStr; // presumably user typed tgt puncts
						}
					}
				}
				pSrcPhrase->m_targetStr = str;

#if defined (_DEBUG) && !defined (NOLOGS)
				{
					wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], pSrcPhrase->m_key = [%s] , , pSrcPhrase->m_targetStr = [%s] , input targetStr= %s"),
						__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), pSrcPhrase->m_key.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
					if (pSrcPhrase->m_nSequNumber >= 18)
					{
						int halt_here = 1; wxUnusedVar(halt_here);
					}
				}
#endif

				// do housekeeping
				pApp->m_nCurSequNum_ForPlacementDialog = theSequNum;

				//#if defined(FWD_SLASH_DELIM)
				// BEW 23Apr15 if in a merger, we want / converted to ZWSP for the target text
				if (pSrcPhrase->m_nSrcWords > 1)
				{
					// No changes are made if app->m_bFwdSlashDelimiter is FALSE
					pSrcPhrase->m_targetStr = FwdSlashtoZWSP(pSrcPhrase->m_targetStr);
				}
				//#endif
				return;
			} // end of TRUE block for test: if (!pApp->m_bCopySourcePunctuation) -- matched, correct indent
			else // *Do* copy the source punctuation
			{
				// BEW 2Mar15, bleed out the [ or ] as punctuation requiring restoration
				if (bEmptyTarget && bSquareBracketOnlyAsPunct)
				{
					// The string to place is either in m_precPunct or m_follPunct
					if (!pSrcPhrase->m_precPunct.IsEmpty() &&
						pSrcPhrase->m_precPunct.GetChar(0) == (wxChar)_T('['))
					{
						pSrcPhrase->m_targetStr = pSrcPhrase->m_precPunct;
					}
					else if (!pSrcPhrase->m_follPunct.IsEmpty() &&
						pSrcPhrase->m_follPunct.GetChar(pSrcPhrase->m_follPunct.Len() - 1) == (wxChar)_T(']'))
					{
						pSrcPhrase->m_targetStr = pSrcPhrase->m_follPunct;
					}
					// store the sequence number on the app class, so that if we reenter while at the same
					// sequence number, the test at the top of the function can detect this and if the
					// m_nPlacePunctDlgCallNumber value has just been incremented to be 2 or higher, we
					// will skip the code contained in this function; the m_nPlacePunctDlgCallNumber value
					// is reset to 0 at the end of CLayout::Draw(), and at the same place the
					// m_nCurSequNum_ForPlacementDialog is reset to default -1
					pApp->m_nCurSequNum_ForPlacementDialog = theSequNum;
					//#if defined(FWD_SLASH_DELIM)
										// BEW 23Apr15 if in a merger, we want / converted to ZWSP for the target text
					if (pSrcPhrase->m_nSrcWords > 1)
					{
						// No changes are made if app->m_bFwdSlashDelimiter is FALSE
						pSrcPhrase->m_targetStr = FwdSlashtoZWSP(pSrcPhrase->m_targetStr);
					}
					return;
				} // end of TRUE block for test: if (bEmptyTarget && bSquareBracketOnlyAsPunct)  matched, correct indent

				// Preceding punctuation can be handled silently. If the user typed
				// different punctuation, then the user's must override the original
				// punctuation. The target text string might be a phrase and hence contain
				// spaces, but space is a delimiter in m_punctSet from version 1.3.6
				// onwards, so we must be careful in the next code blocks - SpanIncluding()
				// can still be used safely, because there will be nonpunctuation and
				// nonspace characters prior to any spaces in the phrase; and similarly
				// when reversed
				bWantPrecCopy = FALSE;
				punctLen = 0; // for auto caps support
				if (!bEmptyTarget)
				{
					// BEW 27Mar13, moved the autocapitalization support out of the
					// preceding punctuation block below, so that it applies to any
					// non-empty target string

					// span using target lang's punctuation - wxWidgets version
					// SpanIncluding() in helpers.h
					wxString strInitialPunct = SpanIncluding(str, pApp->m_punctuation[1]);
					// If strInitialPunct is non-empty, then the user must have typed some
					// initial punctuation intending it be retained rather than whatever is
					// in m_prevPuncts being copied to the start of str
					if (!strInitialPunct.IsEmpty())
					{
						punctLen = strInitialPunct.Len();
					}
#if defined (_DEBUG) && !defined (NOLOGS)
					{
						wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], pSrcPhrase->m_key = [%s] , , pSrcPhrase->m_targetStr = [%s] , input targetStr= %s"),
							__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), pSrcPhrase->m_key.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
						if (pSrcPhrase->m_nSequNumber >= 18)
						{
							int halt_here = 1; wxUnusedVar(halt_here);
						}
					}
#endif
					// Do any needed capitalizing of the first non-punctuation letter
					if (bWantChangeToUC)
					{
						// check first that the change to upper case is possible, and if
						// needed then do it
						wxString noInitialPunctStr = str.Mid(punctLen);
						bNoError = pDoc->SetCaseParameters(noInitialPunctStr, FALSE);
						if (bNoError && !gbNonSourceIsUpperCase && (gcharNonSrcUC != _T('\0')))
						{
							// do the change to upper case for the wxChar at [punctLen] index
							str.SetChar(punctLen, gcharNonSrcUC);
						}
					}
					// Remember, when control gets to here, str may have user-typed initial
					// punctuation added already
					// BEW 12Oct23 testing m_precPunct non-empty would be problematic if there
					// was grabbed preceding punct, so the next test should probably have a 2nd subtest
					if (!pSrcPhrase->m_precPunct.IsEmpty() && strGrabbedPrecPuncts.IsEmpty())
					{
						// If the user did not manually type any initial punctuation, then
						// we want to later have the m_precPuncts contents copied to the
						// start of str, later on below (i.e. set bWantPrecCopy to TRUE)
						if (strInitialPunct.IsEmpty())
						{
							// there was no initial punctuation typed, so silently copy
							// original's to the target later on (not here, in case it mucks up
							// the check for following punct) Note: original's may be empty
							bWantPrecCopy = TRUE;
						}
						else
						{
							// let the punctuation typed by the user stand unchanged, if
							// there was any typed that is 
							// BEW 12Oct, presumably if the user manually
							// typed preceding punct/s when pSrcPhrase did not have any, then we
							// should update m_precPunct to have what the user typed
							if (pSrcPhrase->m_precPunct.IsEmpty() && !strGrabbedPrecPuncts.IsEmpty())
							{
								pSrcPhrase->m_precPunct = strGrabbedPrecPuncts;
							}
						}
					}
#if defined (_DEBUG) && !defined (NOLOGS)
					{
						wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], pSrcPhrase->m_key = [%s] , pSrcPhrase->m_targetStr = [%s] , input targetStr= %s"),
							__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), pSrcPhrase->m_key.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
						if (pSrcPhrase->m_nSequNumber >= 18)
						{
							int halt_here = 1; wxUnusedVar(halt_here);
						}
					}
#endif

					// If the word or phrase in the source had no preceding punctuation,
					// then MakeTargetStringIncludingPunctuation will do nothing at the
					// start of the word or phrase, so that if the user elects to
					// explicitly type some preceding punctuation, it will be accepted
					// unconditionally in that location

					// NOTE: str has had any needed auto-capitalization already done by now

					// BEW 25Feb20, refactored next section to avoid having to reverse str. 
					// If str happens to end in puncts like ) ] or }, and the normal puncts
					// additions are wanted, the legacy code ignored the normal (from pSrcPhrase)
					// puncts and wrongly treated the ) etc as manually typed and is
					// intended to replace the normal punctuation additions. That led
					// to punctuation loss in the document. The next function was created
					// , to predict when to check for user-typed ending puncts (for
					// FALSE returned), or to go ahead and add the normal puncts in the 
					// normal way (TRUE returned)
					bool bNoUserTypedFinalPuncts = TRUE; // initialise
					int matchedAt = -1; // initialise
					const wxChar* pBuffStart = targetStr.GetData();
					wxChar* pBeginBuff = const_cast<wxChar*>(pBuffStart); // LHS not const
					int buffLen = (int)targetStr.Len();
					pEnd = pBeginBuff + (size_t)buffLen; // points to null
					// Get last character in the targetStr  (it might, or might not,
					// be final punctuation the user typed in to replace the stored
					// punctuation characters in m_follPunct and m_follOuterPunct)
					wxChar charLast = (wxChar)str.Last();

					// check out what the targetStr ending characters imply should
					// be done. Return TRUE if control should go straight to the
					// block for adding stored puncts from the pSrcPhrase. Return
					// FALSE if it's likely there may be user-typed final punctuation
					// - we can't be certain, but if FALSE was typed, then we will
					// scan backwards in targetStr's buffer to identify any such,
					// and if none, we'll send control to the block for adding puncts
					// from pSrcPhrase's members in the normal way; if we find some,
					// we will interpret them as being replacive and ignore what's
					// in pSrcPhrase's two 'following' puncts members
					wxChar* pOldEnd = pEnd;
					bRemoveUnwantedLastChar = FALSE; // initialise (it's local to this function)
#if defined (_DEBUG) && !defined (NOLOGS)
					{
						wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], pSrcPhrase->m_key = [%s] , pSrcPhrase->m_targetStr = [%s] , input targetStr= %s"),
							__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), pSrcPhrase->m_key.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
						if (pSrcPhrase->m_nSequNumber >= 18)
						{
							int halt_here = 1; wxUnusedVar(halt_here);
						}
					}
#endif
					bNoUserTypedFinalPuncts = FindMatchingParenthesisBracketOrBrace(pBeginBuff, pEnd, (size_t)buffLen, matchedAt, charLast);
					// Returning TRUE means the charLast set above, has not been changed by user typing
					if ((matchedAt >= 0) && bNoUserTypedFinalPuncts)
					{
						// The situation when ) or ] or } gets added at buffer end, but
						// is not wanted because, whichever it is, is actually already in
						// its correct place e.g. in a tgt phrase like "into your(sg) hands",
						// requires a flag for indicating that kind of state. So code in
						// FindMatchingParen.....OrBrace() detects the need and points pEnd 
						// to the character preceding the true pEnd. That change is reversed
						// here, so no damage is done, but that hack enables the 
						// bRemoveUnwantedLastChar boolean to be set TRUE, and the boolean flag 
						// then functions to signal for last character removal going forward
						// 
						// BEW 21Nov22 there's a problem here - Roland Fumey's dat requires TRUE,
						// but I don't what this removal when the phrasebox moving forward
						// gets DoStore_NormalOrTransliterateMode(), because I want final ')' to
						// persist beyond the store call to the ParseWord() call - where the
						// final ')' needs to be there in the adaptation text. So I have a new
						// app boolean, m_bInNormalStore which I can use it's TRUE value to
						// give an alternative path thru the rest of MakeTargetString...()
						if (!pApp->m_bInNormalStore)
						{
							bRemoveUnwantedLastChar = TRUE;
						}
						else
						{
							bRemoveUnwantedLastChar = FALSE;
						}
					}
					pEnd = pOldEnd;  // restore old pEnd
#if defined (_DEBUG) && !defined (NOLOGS)
					{
						wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], pSrcPhrase->m_key = [%s] , pSrcPhrase->m_targetStr = [%s] , input targetStr= %s"),
							__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), pSrcPhrase->m_key.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
						if (pSrcPhrase->m_nSequNumber >= 18)
						{
							int halt_here = 1; wxUnusedVar(halt_here);
						}
					}
#endif

					// Do next check first, it may result in the value of bNoUserTypedFinalPuncts
					// being changed to TRUE if we don't find any candidate final puncts for
					// being user-typed with replacive intention
					if (!bNoUserTypedFinalPuncts)
					{
						// bNoUserTypedFinalPuncts was FALSE, so see if we can find some
						wxString typedFinalPuncts = GetManuallyAddedFinalPuncts(pBeginBuff, pEnd);
						if (typedFinalPuncts.IsEmpty())
						{
							bNoUserTypedFinalPuncts = TRUE;
						}
						else
						{
							// There exists one or more final puncts which are deemed to be
							// typed in by the user. These must replace the contents of
							// pSrcPhrase's current m_follPunct and m_follOuterPunct
							// members, and be stored in just the m_follPunct member
							pSrcPhrase->m_follPunct.Empty();
							wxString strEmpty = wxEmptyString;
							pSrcPhrase->SetFollowingOuterPunct(strEmpty);
							pSrcPhrase->m_follPunct = typedFinalPuncts;
#if defined (_DEBUG) && !defined (NOLOGS)
							{
								wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], pSrcPhrase->m_key = [%s] , pSrcPhrase->m_targetStr = [%s] , input targetStr= %s"),
									__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), pSrcPhrase->m_key.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
								if (pSrcPhrase->m_nSequNumber >= 18)
								{
									int halt_here = 1; wxUnusedVar(halt_here);
								}
							}
#endif
						}
					}
#if defined (_DEBUG) && !defined (NOLOGS)
					{
						wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], pSrcPhrase->m_key = [%s] , pSrcPhrase->m_targetStr = [%s] , input targetStr= %s"),
							__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), pSrcPhrase->m_key.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
						if (pSrcPhrase->m_nSequNumber >= 18)
						{
							int halt_here = 1; wxUnusedVar(halt_here);
						}
					}
#endif
					// Do the normal word- or phrase-final punctuation additions
					if (bNoUserTypedFinalPuncts)
					{
						// Check for an unwanted final ) or ] or }, there is one if
						// bRemoveUnwatedLastChar is TRUE, and if so, then remove
						// that before adding final puncts, if any.
						// This block deals with the problem caused by Rolan Fumey's
						// data of this kind: into your(sg) hands  (as an adaptation
						// for a single CSourcePhrase). See his VE project:
						// Kuni to KuniVE adaptations, on laptop
						if (bRemoveUnwantedLastChar)
						{
							int aLength = targetStr.Len();
							wxString lastChar = targetStr.GetChar(aLength - 1); // BEW 12Oct23 added
							targetStr = targetStr.Left(aLength - 1);
							pApp->m_targetPhrase = targetStr;
							// and in the phrasebox too
							pApp->m_pTargetBox->SetValue(targetStr);

							// have to also do it for str
							aLength = str.Len();
							str = str.Left(aLength - 1);
#if defined (_DEBUG) && !defined (NOLOGS)
							{
								wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], pSrcPhrase->m_key = [%s] , pSrcPhrase->m_targetStr = [%s] , input targetStr= %s"),
									__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), pSrcPhrase->m_key.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
								if (pSrcPhrase->m_nSequNumber >= 18)
								{
									int halt_here = 1; wxUnusedVar(halt_here);
								}
							}
#endif
							bRemoveUnwantedLastChar = FALSE; // restore default
						}

						wxString tgtFollPunct;
						tgtFollPunct.Empty();
						wxString tgtPrecPunct;
						tgtPrecPunct.Empty();
						if (!pApp->m_bInNormalStore)
						{
							//BEW 4Oct22 added 2nd subtest, because if there was nothing in m_follPunct, there would
							// be no test for something in m_follOuterPunct <- it could indeed have punctuation, as
							// when an inline endmarker preceded some punctuation. Introduce a separating hairspace if
							// two curly end-quotes occur in sequence - it looks better in the GUI
							wxChar hairspace = (wxChar)0x200A;
							if (!pSrcPhrase->m_follPunct.IsEmpty() || !pSrcPhrase->GetFollowingOuterPunct().IsEmpty())
							{
								// copy original's to the target; and also copy any in m_follOuterPunct
								tgtFollPunct = GetConvertedPunct(pSrcPhrase->m_follPunct);
								// BEW 11Oct10, added to support m_follOuterPunct
								if (!pSrcPhrase->GetFollowingOuterPunct().IsEmpty())
								{
									wxString tgtFollPunctOuter;
									tgtFollPunctOuter.Empty();
									tgtFollPunctOuter = GetConvertedPunct(pSrcPhrase->GetFollowingOuterPunct());
									tgtFollPunct += tgtFollPunctOuter; // join it together
									// put a space between consecutive curly quotes
									size_t length = tgtFollPunct.Len();
									size_t index;
									for (index = 0; index < length - 1; index++)
									{

										wxChar aChar = tgtFollPunct[index];
										wxChar nxtChar = tgtFollPunct[index + 1];
										if (pDoc->IsClosingQuote(&aChar) && pDoc->IsClosingQuote(&nxtChar))
										{
											// this handles not just curly endquotes, but
											// straights as well
											wxString leftStr = tgtFollPunct.Left(index + 1);
											wxString rightStr = tgtFollPunct.Mid(index + 1);
											leftStr += hairspace;
											tgtFollPunct = leftStr + rightStr;
											length = tgtFollPunct.Len();
											index += 1;
										}
									}
								} // end of TRUE block for test: 
									// if (!pSrcPhrase->GetFollowingOuterPunct().IsEmpty())
							} // end of TRUE block for test: if (!pSrcPhrase->m_follPunct.IsEmpty())
							str += tgtFollPunct;
#if defined (_DEBUG) && !defined (NOLOGS)
							{
								wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], pSrcPhrase->m_key = [%s] , pSrcPhrase->m_targetStr = [%s] , input targetStr= %s"),
									__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), pSrcPhrase->m_key.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
								if (pSrcPhrase->m_nSequNumber >= 18)
								{
									int halt_here = 1; wxUnusedVar(halt_here);
								}
							}
#endif
						} // end of TRUE block for test: if (!pApp->m_bInNormalStore)
					} // end of TRUE block for test: if (bNoUserTypedFinalPuncts)

					// add the preceding punctuation, if any
					if (bWantPrecCopy && !pApp->m_bInNormalStore)
					{
						// BEW added comment, 24Dec22. Why no check to add hairspace between successive
						// preceding puncts? Because typically there are intervening words between the
						// start of quotes, and so no need to have a hairspace insertion check here
						wxString tgtPrecPunct;
						tgtPrecPunct.Empty();
						tgtPrecPunct = GetConvertedPunct(pSrcPhrase->m_precPunct);
						str = tgtPrecPunct + str;

#if defined (_DEBUG) && !defined (NOLOGS)
						{
							wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], pSrcPhrase->m_key = [%s] , pSrcPhrase->m_targetStr = [%s] , input targetStr= %s"),
								__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), pSrcPhrase->m_key.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
							if (pSrcPhrase->m_nSequNumber >= 18)
							{
								int halt_here = 1; wxUnusedVar(halt_here);
							}
						}
#endif
					}
				} // end of TRUE block for test: if (!bEmptyTarget)  -- matched at this level

				// now add the final form of the target string to the source phrase

				// BEW 24Nov22, my refactor of SimplePunctuationRestore() near top,
				// may have produced a pSrcPhrase->m_targetStr value already correctly set
				// with the restored following and preceding punctuation. So give the blocks which 
				// add puncts protection - check if the puncts have already been added, and if so
				// then skip the additions
				// 
				// BEW 12Dec22 oops, str can be here expected to have an m_adaptation non-empty value,
				// but very possibly pSrcPhrase->m_targetStr could be empty. If the latter is so, then
				// an attempt to call .Last() on an empty string, will generate a bounds error crash.
				// So make the following lines smarter. Calling .Length() on an empty string returns 0,
				// so that is safe

				// BEW 29Nov23 the code from here to end two major code blocks at 18,736 approx, does two things, based on pSrcPhrase contents
				// (1) removes any punctuation (which clobbers any already added manually typed final puncts) to build a m_targetStr based on
				// the contents of pSrcPhrase m_follPunct and m_follOuterPunct.
				// (2) following that, a similar major block deals with m_precPunct in the same kind of way (mucking up any manually added
				// preceding puncts grabbed from phrasebox contents as manually typed - if any were typed there).
				// So we must prevent these code blocks from doing pSrcPhrase-based punctuation additions, when strGrabbedFinalPuncts has
				// content (it replaces what pSrcPhrase may have in src text), and when strGrabbedPrecPuncts has content (it likewise replaces)
				// So here I'll add to this pSrcPhrase-based code with subtests for the relevant grabbed punct string being empty, 
				// thereby protecting what the grabbed strings have already added appropriately

				wxString follPuncts = wxEmptyString;
				wxString follOuterPuncts = wxEmptyString;
				int tgtStrLen = pSrcPhrase->m_targetStr.Length();
				if (strGrabbedFinalPuncts.IsEmpty() && tgtStrLen == 0)
				{
					// There is no m_targetStr value defined as yet
					pSrcPhrase->m_targetStr = str;  // set the best possible value so far, and it may
							// actually have preceding and/or following punctuation already in place
							// due to SimplePunctuationRestoration() call near start, above
#if defined (_DEBUG) && !defined (NOLOGS)
					{
						wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], pSrcPhrase->m_key = [%s] , pSrcPhrase->m_targetStr = [%s] , input targetStr= %s"),
							__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), pSrcPhrase->m_key.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
						if (pSrcPhrase->m_nSequNumber >= 18)
						{
							int halt_here = 1; wxUnusedVar(halt_here);
						}
					}
#endif
				}
#if defined (_DEBUG) && !defined (NOLOGS)
				{
					wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], pSrcPhrase->m_key = [%s] , pSrcPhrase->m_targetStr = [%s] , input targetStr= %s"),
						__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), pSrcPhrase->m_key.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
					if (pSrcPhrase->m_nSequNumber >= 18)
					{
						int halt_here = 1; wxUnusedVar(halt_here);
					}
				}
#endif
				// BEW 24Dec22, don't do the next block for adding following puncts, if str already
				// has following puncts - otherwise, we'd double them up
				bool bAlreadyHasFollPunct = FALSE; // init
				if (!strGrabbedFinalPuncts.IsEmpty())
				{
					bAlreadyHasFollPunct = TRUE;
				}
				// BEW 24Dec22, added 3rd subtest BEW 29Nov23 added first subtest to skip this block when final manual puncts were typed
				if (strGrabbedFinalPuncts.IsEmpty() && (!str.IsEmpty() && !pSrcPhrase->m_follPunct.IsEmpty() && !bAlreadyHasFollPunct) )
				{
					// What puncts set? If first char of follPuncts belongs in the pApp->m_strSpacelessSourcePuncts,
					// the we should do punctuation conversion of the whole of follPuncts to target puncts; otherwise
					// the need for conversion can be assumed absent
					wxChar chfirstPunct = strFollPuncts.GetChar(0); // we can be certain there is at least one
					int anOffset = pApp->m_strSpacelessSourcePuncts.Find(chfirstPunct);
					if (anOffset >= 0)
					{
						// it's src punctuation, so do a conversion. Tgt punctuation may be identical, but
						// that won't matter; but if there are different tgt punct glyphs, this will catch it
						strFollPunctsConverted = GetConvertedPunct(strFollPuncts);
#if defined (_DEBUG) && !defined (NOLOGS)
						{
							wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], pSrcPhrase->m_key = [%s] , pSrcPhrase->m_targetStr = [%s] , input targetStr= %s"),
								__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), pSrcPhrase->m_key.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
							if (pSrcPhrase->m_nSequNumber >= 18)
							{
								int halt_here = 1; wxUnusedVar(halt_here);
							}
						}
#endif
						// str may have user-typed punctuation, remove it <<-- Eh! if user typed puncts are there, they are replacive,
						// so only do this below section of code when strGrabbedFinalPunts is empty
						int nUseTgtPuncts = 1;
						CAdapt_ItDoc* pDoc = pApp->GetDocument();
#if defined (_DEBUG) && !defined (NOLOGS)
						{
							wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], pSrcPhrase->m_key = [%s] , , pSrcPhrase->m_targetStr = [%s] , input targetStr= %s"),
								__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), pSrcPhrase->m_key.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
							if (pSrcPhrase->m_nSequNumber >= 18)
							{
								int halt_here = 1; wxUnusedVar(halt_here);
							}
						}
#endif
						RemovePunctuation(pDoc, &str, nUseTgtPuncts);
						// BEW 13Oct23 stepping thru determined that str had the following ) punct, for your(sg) but
						// the RemovePunctuation() call returns str as "your(sg<space>", so we here need to Trim()
						// whites from the returned str value's end
						str.Trim(); // this makes the stripping off of ) below, though unnecessary, safe to do, as the ) will be re
						// RemovePunctuation(), if str has no puncts, may return str with a <null> within it, so
						// protect from null messing wth the operation of << += or = operators
						//str = RemoveNulls(str);
//#if defined (_DEBUG) && !defined (NOLOGS)
//						if (!str.IsEmpty())
//							wxLogDebug(_T("MakeTgtStrInclPunct line %d , STRING= [%s]  LASTCHAR= [%d]"), __LINE__, str.c_str(), (int)str.Last());
//#endif
						if (pSrcPhrase->m_adaption.IsEmpty())
						{
							pSrcPhrase->m_adaption = str;
						}
						wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d , pSrcPhrase->m_adaption = [%s] , strAdapt = [%s] , input targetStr= %s "),
							__LINE__, pSrcPhrase->m_nSequNumber, pSrcPhrase->m_adaption.c_str(), str.c_str(), targetStr.c_str());
#if defined (_DEBUG) && !defined (NOLOGS)
						{
							wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], pSrcPhrase->m_key = [%s] , pSrcPhrase->m_targetStr = [%s] , input targetStr= %s"),
								__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), pSrcPhrase->m_key.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
							if (pSrcPhrase->m_nSequNumber >= 18)
							{
								int halt_here = 1; wxUnusedVar(halt_here);
							}
						}
#endif
						// Now add the contents of follPuncts
						wxString tgtText = wxEmptyString;
						tgtText << str; // does this append strAdapt?
						tgtText << strFollPunctsConverted; // does this append strFollPunctsConverted?
#if defined (_DEBUG) && !defined (NOLOGS)
						{
							wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], pSrcPhrase->m_key = [%s] , , pSrcPhrase->m_targetStr = [%s] , input targetStr= %s"),
								__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), pSrcPhrase->m_key.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
							if (pSrcPhrase->m_nSequNumber >= 18)
							{
								int halt_here = 1; wxUnusedVar(halt_here);
							}
						}
#endif
						// also try appending ')' to str directly
						str << strFollPunctsConverted; // does this work?
						wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d , tgtText = [%s] , strFollPunctsConverted = [%s] , str= [%s]"),
							__LINE__, pSrcPhrase->m_nSequNumber, tgtText.c_str(), strFollPunctsConverted.c_str(), str.c_str());

						// Now, can I assign tgtText to overwrite what it in pSrcPhrase->m_targetStr ?
						pSrcPhrase->m_targetStr = tgtText;
#if defined (_DEBUG) && !defined (NOLOGS)
						{
							wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], pSrcPhrase->m_key = [%s] , , pSrcPhrase->m_targetStr = [%s] , input targetStr= %s"),
								__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), pSrcPhrase->m_key.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
							if (pSrcPhrase->m_nSequNumber >= 18)
							{
								int halt_here = 1; wxUnusedVar(halt_here);
							}
						}
#endif
/*
#if defined (_DEBUG) //&& !defined (NOLOGS)
						{
							wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d , pSrcPhrase->m_key = %s , pSrcPhrase->m_adaption = %s , pSrcPhrase->m_targetStr = %s , input targetStr= %s "),
								__LINE__, pSrcPhrase->m_nSequNumber, pSrcPhrase->m_key.c_str(), pSrcPhrase->m_adaption.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
						}
#endif
*/
					}
				} // end of TRUE block for test: 
				  // if (strGrabbedFinalPuncts.IsEmpty() && (!str.IsEmpty() && !pSrcPhrase->m_follPunct.IsEmpty() && !bAlreadyHasFollPunct) )
				
				// BEW 24Dec22, don't do the next block for adding following puncts, if str already
				// has following puncts - otherwise, we'd double them up
				wxChar follOuterPunctFirst;
				bool bAlreadyHasFollOuterPunct = FALSE; // init
				wxString strFollOuterPuncts = pSrcPhrase->GetFollowingOuterPunct();
				if (!strFollOuterPuncts.IsEmpty())
				{
					follOuterPunctFirst = strFollOuterPuncts.GetChar(0);// a following punct exists in m_follOuterPunct
					if (strGrabbedFinalPuncts.IsEmpty()) // only make this test if strGrabbedFinalPuncts has no content
					{
						// Does str have this following outer punct within it - reverse str first, to make sure we are
						// finding on the following puncts, not preceding ones
						wxString revStr = MakeReverse(str);
						int offset = wxNOT_FOUND;
						offset = revStr.Find(follOuterPunctFirst);
						if (offset >= 0)
						{
							// following outer puncts have already been added to str, so skip next code block
							bAlreadyHasFollOuterPunct = TRUE;
						}
					}
				} // end of TRUE block for test: if (!strFollOuterPuncts.IsEmpty())
#if defined (_DEBUG) && !defined (NOLOGS)
				{
					wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], pSrcPhrase->m_key = [%s] , pSrcPhrase->m_targetStr = [%s] , input targetStr= %s"),
						__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), pSrcPhrase->m_key.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
					if (pSrcPhrase->m_nSequNumber >= 18)
					{
						int halt_here = 1; wxUnusedVar(halt_here);
					}
				}
#endif
				// pSrcPhrase->m_follOuterPuncts may have content, if so, add these too, and do conversions
				// if appropriate (like above)
				if (strGrabbedFinalPuncts.IsEmpty())
				{
					// Do this test only if user manually typed final puncts were not typed in the phrasebox
					follOuterPuncts = pSrcPhrase->GetFollowingOuterPunct();
					if (!str.IsEmpty() && !follOuterPuncts.IsEmpty() && !bAlreadyHasFollOuterPunct) // BEW 24Dec22 added 3rd subtest
					{
						wxChar chfirstOuterPunct = follOuterPuncts.GetChar(0); // we can be certain there is at least one
						int anOffset = pApp->m_strSpacelessSourcePuncts.Find(chfirstOuterPunct);
						if (anOffset >= 0)
						{
							// it's src punctuation, so do a conversion. Tgt punctuation may be identical, but
							// that won't matter; but if there are different tgt punct glyphs, this will catch it
							follOuterPuncts = GetConvertedPunct(follOuterPuncts);
						}
						// Now add them to m_targetStr
						pSrcPhrase->m_targetStr += follOuterPuncts;
					} // end of TRUE block for test: if (!str.IsEmpty() && !follOuterPuncts.IsEmpty() && !bAlreadyHasFollOuterPunct)
				}
				// BEW 14Oct22, this function may not register that detached ] is
				// to be treated as content for m_adaption, so check, and do so if empty still
				if (strGrabbedFinalPuncts.IsEmpty())
				{
					// Only do this block if the user did not type a final ']' in the phrasebox
					if (pSrcPhrase->m_adaption.IsEmpty() && (str == _T("]")))
					{
						pSrcPhrase->m_adaption = _T("]");
					}
					else if (pSrcPhrase->m_adaption.IsEmpty() && pApp->m_bInNormalStore)
					{
						wxString tgtStr = pSrcPhrase->m_targetStr;
						pSrcPhrase->m_adaption = tgtStr;
					}
				}
#if defined (_DEBUG) && !defined (NOLOGS)
				{
					wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], pSrcPhrase->m_key = [%s] , pSrcPhrase->m_targetStr = [%s] , input targetStr= %s"),
						__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), pSrcPhrase->m_key.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
					if (pSrcPhrase->m_nSequNumber >= 18)
					{
						int halt_here = 1; wxUnusedVar(halt_here);
					}
				}
#endif
				// Preceding puncts... only do this block of code if there were no manually 
				// typed (replacive) preceding punct(s) in the phrasebox
				if (strGrabbedPrecPuncts.IsEmpty())
				{
					// BEW 24Dec22, don't do the next block for adding preceding puncts, if str already
					// has preceding puncts - otherwise, we'd double them up
					wxChar precPunctFirst; // = (wxChar)0; NEVER set to null; BEW 29May23
					wxString precPuncts = wxEmptyString; // init
					bool bAlreadyHasPrecPunct = FALSE; // init
					// BEW 29May23 added next text and its TRUE block
					if (!pSrcPhrase->m_precPunct.IsEmpty())
					{
						// There is at least one, so I can safely get the first
						precPuncts = pSrcPhrase->m_precPunct;
					}
					if (!pSrcPhrase->m_precPunct.IsEmpty() && !bHandledPrecPuncts)
					{
						precPunctFirst = precPuncts.GetChar(0); // a preceding punct exists in m_precPunct
						// Does str have this following punct within it?
						int offset = wxNOT_FOUND;
						offset = str.Find(precPunctFirst);
						if (offset >= 0)
						{
							// preceding puncts have already been added to str, so skip next code block
							bAlreadyHasPrecPunct = TRUE;
						}
					}
					// BEW 24Dec22, added 3rd subtest // BEW 25May23 added 2nd subtest
					if (!str.IsEmpty() && !bHandledPrecPuncts && !pSrcPhrase->m_precPunct.IsEmpty() && !bAlreadyHasPrecPunct)
					{
						precPuncts = pSrcPhrase->m_precPunct;
						// What puncts set? If first char of precPuncts belongs in the pApp->m_strSpacelessSourcePuncts,
						// the we should do punctuation conversion of the whole of precPuncts to target puncts; otherwise
						// the need for conversion can be assumed absent
						wxChar chfirstPunct = precPuncts.GetChar(0); // we can be certain there is at least one
						int anOffset = pApp->m_strSpacelessSourcePuncts.Find(chfirstPunct);
						if (anOffset >= 0)
						{
							// it's src punctuation, so do a conversion. Tgt punctuation may be identical, but
							// that won't matter; but if there are different tgt punct glyphs, this will catch it
							precPuncts = GetConvertedPunct(precPuncts);

							// Now add them to m_targetStr, providing they (or it) are not there yet
							int precPunctsLen = precPuncts.Length();
							wxString strTheRest = wxEmptyString;
							wxString strTgt = pSrcPhrase->m_targetStr;
							if (bAlreadyHasPrecPunct && precPunctsLen > 0)
							{
								// Removed inital precPuncts, they were already added to strTgt, so don't add them a second time
								strTheRest = strTgt.Mid(precPunctsLen);
								pSrcPhrase->m_targetStr = precPuncts + strTheRest;
							}
							else
							{
								// pSrcPhrase->m_targetStr did not have precPuncts already added, so do so here
								pSrcPhrase->m_targetStr = precPuncts + pSrcPhrase->m_targetStr;
							}
#if defined (_DEBUG) && !defined (NOLOGS)
							{
								wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], pSrcPhrase->m_key = [%s] , pSrcPhrase->m_targetStr = [%s] , input targetStr= %s"),
									__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), pSrcPhrase->m_key.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
								if (pSrcPhrase->m_nSequNumber >= 18)
								{
									int halt_here = 1; wxUnusedVar(halt_here);
								}
							}
#endif
						}
					} // end of TRUE block for test: 
					  // if (!str.IsEmpty() && !bHandledPrecPuncts && !pSrcPhrase->m_precPunct.IsEmpty() && !bAlreadyHasPrecPunct)
				} // end of TRUE block for test: if (strGrabbedPrecPuncts.IsEmpty())

				//#if defined(FWD_SLASH_DELIM)
				// BEW 23Apr15 if in a merger, we want / converted to ZWSP for the target text
				if (pSrcPhrase->m_nSrcWords > 1)
				{
					// No changes are made if app->m_bFwdSlashDelimiter is FALSE
					pSrcPhrase->m_targetStr = FwdSlashtoZWSP(pSrcPhrase->m_targetStr);
				}
				//#endif

				} // end of else block for test: if (!pApp->m_bCopySourcePunctuation) -- correct indent, matched { }

			} // end of else block for test: if (pApp->m_bFinalTypedPunctsGrabbedAlready) -- correct indent, matched { }

		} // end of TRUE block for test: if (!IsFixedSpaceSymbolWithin(pSrcPhrase))

	} // jump to here if the function has already been called at current location

    // store the sequence number on the app class, so that if we reenter while at the same
    // sequence number, the test at the top of the function can detect this and if the
    // m_nPlacePunctDlgCallNumber value has just been incremented to be 2 or higher, we
    // will skip the code contained in this function; the m_nPlacePunctDlgCallNumber value
    // is reset to 0 at the end of CLayout::Draw(), and at the same place the
    // m_nCurSequNum_ForPlacementDialog is reset to default -1
	pApp->m_nCurSequNum_ForPlacementDialog = theSequNum;

#if defined (_DEBUG) && !defined (NOLOGS)
	{
		wxLogDebug(_T("MakeTgtStrIncPunc() line %d: sn= %d, str= [%s], pSrcPhrase->m_key = [%s] , pSrcPhrase->m_targetStr = [%s] , input targetStr= %s"),
			__LINE__, pSrcPhrase->m_nSequNumber, str.c_str(), pSrcPhrase->m_key.c_str(), pSrcPhrase->m_targetStr.c_str(), targetStr.c_str());
		if (pSrcPhrase->m_nSequNumber >= 18)
		{
			int halt_here = 1; wxUnusedVar(halt_here);
		}
	}
#endif

}

// BEW 27Feb20, override for wxString CAdapt_ItView::GetManuallyAddedFinalPuncts(wxChar* pBeginBuff, wxChar* pEnd)
// when we need to check the phrasebox for any ending puncts manually added before we commit
// to my latest code for getting the wanted ending puncts
wxString CAdapt_ItView::GetManuallyAddedFinalPuncts(wxString targetStr)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxString typedPuncts = wxEmptyString;
	pApp->m_bFinalTypedPunctsGrabbedAlready = FALSE; // initialise

	//Get starting and ending ptrs
	const wxChar* pBuffStart = targetStr.GetData();
	wxChar* pBeginBuff = const_cast<wxChar*>(pBuffStart); // LHS not const
	int buffLen = (int)targetStr.Len();
	wxChar* pEnd = pBeginBuff + (size_t)buffLen; // points to null

	typedPuncts = GetManuallyAddedFinalPuncts(pBeginBuff, pEnd);

	if (!typedPuncts.IsEmpty())
	{
		pApp->m_bFinalTypedPunctsGrabbedAlready = TRUE;
	}
	return typedPuncts;
}

// This one parses backwards from pEnd (a small local pEnd, not whole doc's one), 
// collecting following punts, until a character not in the target spaceless 
// punctuation set is reached, returns the collected string of puncts
wxString CAdapt_ItView::GetManuallyAddedFinalPuncts(wxChar* pBeginBuff, wxChar* pEnd)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxString finalPuncts = pApp->m_finalTgtPuncts; // do Find() on this string

	wxString typedPuncts = wxEmptyString;
	int offset = wxNOT_FOUND;
	wxChar* ptr = pEnd; // initialise, we scan backwards; & finalPuncts includes a space
						// to allow for the user typing a space to separate nested quotes
	// Sanity check
	if (pBeginBuff == pEnd)
	{
		return typedPuncts; // it's still empty
	}
	ptr--; // point at last character in the string buffer
	while (ptr > pBeginBuff)
	{
		offset = finalPuncts.Find(*ptr);
		if (offset != wxNOT_FOUND)
		{
			typedPuncts = *ptr + typedPuncts; // preserve puncts order
		}
		else
		{
			break;
		}
		// iterate to check earlier one
		ptr--;
	} // end of loop: while (ptr > pBeginBuff)

	return typedPuncts;
}

// BEW 23Dec22 added, so that it's easier to get MakeTargetStringIncludingPunctuation()
// support the restoration of m_precPunct non-empty content using SimplePunctuationRestoration()
// This one parses forward from pBeginBuff, collecting preceding punts, until a character not
// in the target spaceless punctuation set is reached, returns the collected string
// (Have not added U+200A hairspace support. Maybe we don't need to include space either here,
// as our ParseWord() is smarter in its code now - I won't change here until I learn I should)
wxString CAdapt_ItView::GetManuallyAddedPrecPuncts(wxChar* pBeginBuff, wxChar* pEnd)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxString precPuncts = pApp->m_precTgtPuncts; // do Find() for preceding puncts on this string

	wxString typedPuncts = wxEmptyString;
	int offset = wxNOT_FOUND;
	wxChar* ptr = pBeginBuff; // initialise, we scan forwards; & precPuncts may include a space
						// to allow for the user typing a space to separate nested quotes
	// Sanity check
	if (pBeginBuff == pEnd)
	{
		return typedPuncts; // it's still empty
	}

	while (ptr < pEnd)
	{
		offset = precPuncts.Find(*ptr);
		if (offset != wxNOT_FOUND)
		{
			typedPuncts = typedPuncts + *ptr; // preserve puncts order
		}
		else
		{
			break;
		}
		// iterate to check next one
		ptr++;
	} // end of loop: while (ptr < pEnd)

	return typedPuncts;
}

// BEW 23Dec22 added, so that it's easier to get MakeTargetStringIncludingPunctuation()
// support the restoration of m_precPunct non-empty content using SimplePunctuationRestoration()
wxString CAdapt_ItView::GetManuallyAddedPrecPuncts(wxString targetStr)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxString typedPuncts = wxEmptyString;
	pApp->m_bPrecTypedPunctsGrabbedAlready = FALSE; // initialise

	// BEW 6Feb23 It may be the case that app's m_precTgtPuncts is still empty. Check,
	// and set it's content if so.
	if (pApp->m_precTgtPuncts.IsEmpty())
	{
		pApp->m_precTgtPuncts = pApp->MakeTargetPrecPuncts(pApp->m_strSpacelessTargetPuncts);
	}

	//Get starting and ending ptrs
	const wxChar* pBuffStart = targetStr.GetData();
	wxChar* pBeginBuff = const_cast<wxChar*>(pBuffStart); // LHS not const
	int buffLen = (int)targetStr.Len();
	wxChar* pEnd = pBeginBuff + (size_t)buffLen; // points to null

	typedPuncts = GetManuallyAddedPrecPuncts(pBeginBuff, pEnd);

	if (!typedPuncts.IsEmpty())
	{
		pApp->m_bPrecTypedPunctsGrabbedAlready = TRUE;
	}
	return typedPuncts;
}

// Return TRUE if the matching one is found, before scanning comes to the start of the
// buffer. Pass in the closing one - whether ) or ] or }, and the function will search
// for the matching ( or [ or {   There has to be at least one non-punctuation character
// preceding the matched character, that is, matchedAt returns 1 or more. This is to
// guarantee we are NOT finding a pre-word ( or { or { character. We are wanting to verify
// or disprove that there is a block of text abutting the adaptation and that the block
// is wrapped by ( ... ) or [ .... ] or { .... } - whether or not these are punctuation
// characters. Returning TRUE means the caller will go on to add stored source text
// punctuation in the normal way. Returning FALSE is interpretted as the user has typed
// new word or phrase final punctuation which is to replace what otherwise would have
// been programmatically added from the current pSrcPhrase. Returning -1 in matchedAt
// indicates that no match was made and/or the value to return in this member is
// indeterminate (typically associated with returning FALSE).
// BEW 2Mar20 extra smarts needed, for an adaptation like "in your(sg) hands" where
// there is no final ) or ] or } and the completing character is on an internal word
// in this case, on your(sg). Without the extra smarts, the code will check for the
// ( or [ or { and find it prior to the ) or ] or } already there, and then if FALSE
// is returned, the ) gets added at the end of hands, wrongly giving:  hands)
// To prevent this, our backwards scan should break out of the loop if ) or ] or }
// is encountered before coming to the opening ( or [ or {  and return TRUE, and
// matched at = -1, and the additional constraint that a space follows is TRUE and
// that occurs before pEnd
bool CAdapt_ItView::FindMatchingParenthesisBracketOrBrace(wxChar* pBuffStart, wxChar*& pEnd,
	size_t len, int& matchedAt, wxChar matchThis)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxChar charParenthesis = _T(')');
	wxChar charBracket = _T(']');
	wxChar charBrace = _T('}');
	wxString charIn(matchThis);
	if (len == 0)
	{
		// No target text, but allow stored source text punctuation to be added
		// and so return TRUE;
		matchedAt = 0;
		return TRUE;
	}
	bool bOneOfTheThreeWasPassedIn = FALSE; // initialise
	wxString tgtPuncts = pApp->m_strSpacelessTargetPuncts;
	wxChar charToFind = _T(' '); // inintialise to space, to avoid compiler error
	int offset = wxNOT_FOUND; // initialise
	if ((matchThis != charParenthesis) && (matchThis != charBracket) && (matchThis != charBrace))
	{
		// What was passed in was not one of the three we are interested in, so we can't
		// search for a match. However, we need then to check whether matchThis is a punct
		// or is a word-building character. If the former, then return FALSE so as to treat
		// it as manually typed replacive punctuation; if the latter, then return TRUE so
		// that the caller will use the stored punctuation in the normal way.
		// The user may have provided one of the three, but it's not at the buffer end - that
		// will be tested for further below.

		offset = tgtPuncts.Find(charIn);
		if (offset >= 0)
		{
			// It's a punctuation character 
			matchedAt = -1;
			return FALSE;
		}
		else
		{
			// It's a word-building character
			matchedAt = -1;
			return TRUE;
		}
	}
	else
	{
		// One of the three was passed in, determine which one and scan for the match
		bOneOfTheThreeWasPassedIn = TRUE; // matchThis contained one of ) or ] or }
		if (matchThis == charParenthesis)
		{
			charToFind = _T('(');
		}
		else if (matchThis == charBracket)
		{
			charToFind = _T('[');
		}
		else if (matchThis == charBrace)
		{
			charToFind = _T('{');
		}
	}

	// Our first test is to ensure that the passed in matchThis character occurred
	// at the end of the string buffer - if that's where it is, then the caller
	// should not assume that the user typed it in manually as a replacement
	if (*(pEnd - 1) == matchThis && bOneOfTheThreeWasPassedIn)
	{
		// Okay, go deeper - we potentially have an end of string wrapped substring
		// using parentheses, brackets or braces; because what was passed in occurs
		// last in the caller's string buffer. We scan from the buffer end, backwards
		size_t curLocation = len - 1;
		if (curLocation > 1) // TRUE means caller's string is at least 2 characters long
		{
			// There is room, so we can scan back for a match...
			do {
				//Check that the matchThis character is not encountered before 
				// the iterator's character to be matched is arrived at. If we
				// get to it, then don't add the closing matchThis because it
				// is not wanted at the string end
				wxChar* ptr2 = pBuffStart + curLocation + 1;
				if (*(pBuffStart + curLocation) == matchThis)
				{
					// It's closed off earlier than our arrival at the charToFind
					// location, so break out and return FALSE and matchedAt = -1
					if ((ptr2 < pEnd) && (*ptr2 == _T(' ')))
					{
						// Testing show that the ) or ] or } to be matched is already
						// (wrongly) added at the end of the buffer; so check there
						// for it's presence and remove it before returning
						if (*(pEnd - 1) == matchThis)
						{
							// It's there, shorten pEnd as a flag for the caller,
							// but restore the old pEnd in caller but also there
							// set the app boolean m_bRemoveUnwantedLastChar to TRUE
							// so as to carry this determination forward in the caller
							// so that MakeTargetStringIncludingPunctuation() can
							// get rid of the unwanted ) or ] or } at an appropriate place
							pEnd--; 
						}
						matchedAt = -1;
						return TRUE; // we want normal addition of any final puncts
					}
				}
				if (*(pBuffStart + curLocation) == charToFind)
				{
					// We have a match

					matchedAt = len - curLocation;
					if (matchedAt > 0)
					{
						// Matched, but not at the buffer start, so we know that the wrapped
						// substring is post-word or post-phrase, and to the left of the 
						// match location is target text - so we infer that the user typed 
						// no replacive final punctuation, and so normal puncts copy should
						// happen
						return TRUE;
					}
					else
					{
						// Matched, but at start of buffer, which implies the matchup
						// matched pre-word punctuation. This also suggests letting the
						// normal punctuation process happen - so return TRUE
						return TRUE;
					}
				}
				else
				{
					curLocation--; // point at the preceding char on next iteration
				}
			} while (curLocation >= 0);

			// There was no match, so the caller will need to work out if there are
			// string final puncts - if there are, then we assume they were user-typed
			// with the intention that they will replace whatever are the stored puncts
			// (if any) from the current pSrcPhrase.
			matchedAt = -1;
			return FALSE;
		} // end of TRUE block for test: if (curLocation > 1)
		else
		{
			// String is too short, max of 2 characters and one of ) ] or } is already
			// matched, so gotta check what the first char is - it might be a matching
			// ( or [ or { (that would mean an empty adaptation - no tgt text), but
			// maybe it could happen. So check for the match; if matching wxChar is 
			// found, return TRUE, and matchedAt = 0, to allow any stored puncts to
			// be added in the normal way. If no match, return FALSE, so caller will
			// assume the contents of matchThis could be user typed & therefore replacive,
			// and caller's check will deal correctly with ths scenario
			if (*(pBuffStart) == charToFind)
			{
				// Got a match, so let normal puncts additions happen, if there are any
				matchedAt = 0;
				return TRUE;
			}
			else
			{
				// Whatever is at pBuffStart is not a match for what what was passed in
				// in matchThis. It could be tgt text with a user-typed ) or ] or } 
				// following. So return FALSE, with matchedAt = -1, so that the caller
				// will investigate further for last char being replacive punct typed
				// by the user (criterion? if last is punctuation, assume user typed it)
				matchedAt = -1;
				return FALSE;
			}
		} // end of else block for test: if (curLocation > 1)

	}  // end of TRUE block for test: if (*(pEnd - 1) == matchThis)
	else
	{
		// What happens if the user types some punctuation in final position manually,
		// in phrasebox and it's not one of the three ) ] or } characters? If it's
		// word-building, or final punctuation, the "bleed out" code at the top
		// will return either TRUE or FALSE. If he does type one of ) ] or }, the
		// TRUE block above handles that. So what's left for here? Nothing as 
		// far as I can see - so just return FALSE to get the check for final puntuation
		// done, and if there isn't any, then infer no manual puncts were typed. 
		// Caller can then decide to let the normal puncts be added if there are 
		// any available on pSrcPhrase
		matchedAt = -1;
		return FALSE;
	} // end of else block for test: if (*(pEnd - 1) == matchThis)
}


void CAdapt_ItView::DoFileSaveKB()
{
	wxCommandEvent dummyevent;
	OnFileSaveKB(dummyevent); // protected, so make it accessible
}


// BEW added 16Apr08; pList is a passed in list of CSourcePhrase pointers, such as
// m_pSourcePhrases; parameters two and three define which part of the passed in list is
// used for doing the deep copies, and the pCopiedSublist passes the sublist back to the
// caller. Normally pCopiedSublist will be empty when passed in, but it does not have to
// be. Internally AddTail() is used, and so the function can also be used to append deep
// copies to an existing sublist of deep copies (but I've no plans to do the latter, at
// least none yet).
// returns TRUE if there was no error, FALSE if there was an error
// BEW 22Mar10, updated for support of doc version 5 (no changes needed)
// BEW 9July10, no changes needed for support of kbVersion 2
bool CAdapt_ItView::DeepCopySourcePhraseSublist(SPList* pList, int nStartingSequNum,
								int nEndingSequNum, SPList* pCopiedSublist)
{
	wxString errStr;
    // it is the caller's responsibility to ensure that nStartingSequNum and nEndingSequNum
    // are valid indexes into the pList list
	SPList::Node* pos_pList = pList->Item(nStartingSequNum);
	if (pos_pList == NULL)
	{
		// error condition exists
		// whm Note: Leave these error strings untranslated; not for localization
		errStr = _T(
"DeepCopySourcePhraseSublist() returned NULL for position pos_pList on .FindIndex() call. Saving document. ");
		errStr += _T(
		"Edit process abandoned. Document restored to pre-edit state.");
		wxMessageBox(errStr,_T(""), wxICON_EXCLAMATION | wxOK);
		return FALSE;
	}
	SPList::Node* endpos = pList->Item(nEndingSequNum);
	if (endpos == NULL)
	{
		// error condition exists
		errStr = _T(
"DeepCopySourcePhraseSublist() returned NULL for position endpos on .FindIndex() call. Saving document. ");
		errStr += _T(
		"Edit process abandoned. Document restored to pre-edit state.");
		wxMessageBox(errStr,_T(""), wxICON_EXCLAMATION | wxOK);
		return FALSE;
	}

	SPList::Node* savePos = NULL;
	CSourcePhrase* pSrcPhrase = NULL;
	// BEW added 7Sep10, because if the nStartingSequNum and nEndingSequNum are the same
	// value (ie. only one CSourcePhrase in the editable span), then the while loop below
	// ran to the end of the document, so we need to handle this case in a bleeding block
	if (nStartingSequNum == nEndingSequNum)
	{
		pSrcPhrase = pos_pList->GetData();
		CSourcePhrase* pNewSP = new CSourcePhrase(*pSrcPhrase); // a shallow copy
		pNewSP->DeepCopy(); // pNewSP is now a deep copy
		pCopiedSublist->Append(pNewSP);
		return TRUE;
	}
	// if control gets to here, the while loop is safe
	while (pos_pList != NULL)
	{
		savePos = pos_pList;
		pSrcPhrase = pos_pList->GetData();
		pos_pList = pos_pList->GetNext();
        // whm Checked that the CSourcePhrase(*pSrcPhrase) call below actually does use
        // operator= shallow copy in wx version. Probably wouldn't make any difference in
        // this case since DeepCopy() is called on pNewSP immediately after creation of
        // pNewSP.
		CSourcePhrase* pNewSP = new CSourcePhrase(*pSrcPhrase); // uses operator=,
																// does shallow copy
		pNewSP->DeepCopy(); // pNewSP is now a deep copy
		pCopiedSublist->Append(pNewSP);
		if (savePos == endpos)
		{
			// we have just added the final deep copy to pCopiedSublist, so break out
			break;
		}
	}
	return TRUE;
}


// Tokenize the source text string, str, storing the CSourcePhrase instances in pNewList.
// nInitialSequNum is what will be used for the sequence number of the first element
// tokenized. The tokenizing creates one CSourcePhrase instance per word in str, where
// "word" is a sequence of non-punctuation characters (the parser will skip word-internal
// punctuation, if present, as it works from both ends inwards); and the parser will deal
// with fixed-space (~) marker, SFM or USFM markup, distinquishing between inline binding
// (ie. next to the word, inside of any punctuation) markers, non-binding inline markers,
// and non-inline markers; and strip off and store punctuation at either or both ends of
// the word - it also supports USFM markup where punctuation can both precede and follow an
// endmarker such as \f* (footnote) \fe* (endnote) or \x* (cross reference). The grunt work
// is done by the ParseWord() function which is called within the internal TokenizeText()
// call. Punctuation settings for the source text are used by default. A count of how many
// CSourcePhrase instances were created is returned.
// BEW 23Mar10, updated for support of doc version 5 (no changes needed, except in internally
// called function)
// BEW 9July10, no changes needed for support of kbVersion 2
int CAdapt_ItView::TokenizeTextString(SPList* pNewList, wxString& str, int nInitialSequNum)
{
	CAdapt_ItDoc* pDoc = GetDocument();
	int	length = str.Length();
	if (!str.IsEmpty())
	{
#if defined(_DEBUG) && defined(TOKENIZE_BUG)
		aSequNum = 0;
#endif
		return pDoc->TokenizeText(nInitialSequNum,pNewList,str,length);
	}
	else
		return 0;
}

// TokenizeTargetTextString() overloads TokenizeTextString, to do the parsing with str
// assumed to containing target text (it is up to the caller to ensure that is so), and the
// TokenizeText() internal call will use the m_punctuation[1] (target text punctuation
// characters delimited by space between each) to calculate the spaceless punctuation
// string to be used for tokenizing. If pUseTargetTextPuncts is passed in as FALSE, or
// omitted, then source text punctuation characters are used when parsing the contents of
// str - often source and target punctuation sets are identical and which set is used wouldn't
// then matter, but it can't be assumed that is so, and so the caller should specify TRUE
// when str is target text, in order to guarantee correct results
int CAdapt_ItView::TokenizeTargetTextString(SPList* pNewList, wxString& str,
											int nInitialSequNum, bool bUseTargetTextPuncts)
{
	CAdapt_ItDoc* pDoc = GetDocument();
	int	length = str.Length();
	if (!str.IsEmpty())
	{
//#if defined (_DEBUG)
//		{
//			CPile* pmyPile = this->GetPile(2322);
//			wxString mytgt = pmyPile->GetSrcPhrase()->m_adaption;
//			wxLogDebug(_T("%s::%s() line %d, pile for walala, tgt = %s"), __FILE__, __FUNCTION__, __LINE__, mytgt.c_str());
//		}
//#endif

		int number = pDoc->TokenizeText(nInitialSequNum,pNewList,str,length,bUseTargetTextPuncts);

//#if defined (_DEBUG)
//		{
//			CPile* pmyPile = this->GetPile(2322);
//			wxString mytgt = pmyPile->GetSrcPhrase()->m_adaption;
//			wxLogDebug(_T("%s::%s() line %d, pile for walala, tgt = %s"), __FILE__, __FUNCTION__, __LINE__, mytgt.c_str());
//		}
//#endif
		return number;
	}
	else
		return 0;
}

/////////////////////////////////////////////////////////////////////////////////
/// \return		nothing
/// \param      event   -> the wxUpdateUIEvent that is generated when the Tools Menu
///                        is about to be displayed
/// \remarks
/// Called from: The wxUpdateUIEvent mechanism when the associated menu item is selected,
/// and before the menu is displayed. This handler disables the "Knowledge Base Editor..."
/// item in the Tools menu if the appropriate KB is not in a ready state, otherwise it
/// enables the "Knowledge Base Editor..." item on the Tools menu.
/////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItView::OnUpdateToolsKbEditor(wxUpdateUIEvent& event)
{
	CAdapt_ItApp* pApp = (CAdapt_ItApp*)&wxGetApp();
	wxASSERT( pApp != NULL );

	if ((!gbIsGlossing && pApp->m_bKBReady && pApp->m_pKB != NULL) ||
		(gbIsGlossing && pApp->m_bGlossingKBReady && pApp->m_pGlossingKB != NULL))
	{
		event.Enable(TRUE);
	}
	else
	{
		event.Enable(FALSE);
	}
}

void CAdapt_ItView::OnToolsKbEditor(wxCommandEvent& WXUNUSED(event))
{
 	CAdapt_ItApp* pApp = &wxGetApp();
	pApp->LogUserAction(_T("Initiated OnToolsKbEditor()"));

	pApp->m_bKBEditorEntered = TRUE; // TRUE if View.cpp function
		// OnToolKbEditor(unused wxCommandEvent event) is invoked.
		// FALSE when the handler is exited. Used for invoking the speedier
		// CreateEntry function, for enum value create_entry (=4) when user
		// is NOT in the KB Editor tabbed dialog.

	// whm 23Jan09 Refactored the CKBEditor class and this handler. Changes to this handler
    // involved moving most of the intitializations of CKBEditor members to the CKBEditor
    // class itself, and eliminating several global variables that were only used in this
    // handler and in CKBEditor.
    //
    // wx version: Since the Tools KB Edit menu item has an accelerator table hot key
    // (CTRL-K see CMainFrame) and wxWidgets accelerator keys call menu and toolbar
    // handlers even when they are disabled, we must check for a disabled button and return
    // if disabled. On Windows, the accelerator key doesn't appear to call the handler for
    // a disabled menu item, but I'll leave the following code here in case it works
    // differently on other platforms.
	CMainFrame* pFrame = pApp->GetMainFrame();
	wxMenuBar* pMenuBar = pFrame->GetMenuBar();
	wxASSERT(pMenuBar != NULL);
	if (!pMenuBar->IsEnabled(ID_TOOLS_KB_EDITOR))
	{
		::wxBell();
		pApp->LogUserAction(_T("KB Editor menu item disabled"));
		pApp->m_bKBEditorEntered = FALSE; // restore default
		return;
	}
#if defined (_DEBUG)
    wxLogDebug(_T("view, OnToolsKbEditor, line  %d  - Starting, pApp->m_targetPhrase = %s phrasebox = %s ctItems = %d"), __LINE__,
        pApp->m_targetPhrase.c_str(),pApp->m_pTargetBox->GetTextCtrl()->GetValue().c_str(), pApp->m_pTargetBox->GetDropDownList()->GetCount());
#endif

	CKBEditor editorPage(pApp->GetMainFrame());
	editorPage.Centre();

	if (editorPage.ShowModal() == wxID_OK)
	{
#if defined (_DEBUG)
        wxLogDebug(_T("view, OnToolsKbEditor, line  %d  - After wxID_OK, pApp->m_targetPhrase = %s phrasebox = %s ctItems = %d"), __LINE__,
            pApp->m_targetPhrase.c_str(), pApp->m_pTargetBox->GetTextCtrl()->GetValue().c_str(), pApp->m_pTargetBox->GetDropDownList()->GetCount());
#endif
        // make the user's changes to the KB persistent (FALSE = no Auto backup)
		// whm TODO: Saving of KBs should only be done if a change was made in the KB Editor
		if (gbIsGlossing)
			pApp->SaveGlossingKB(FALSE);
		else
			pApp->SaveKB(FALSE, TRUE);
	}

	// restore focus to the targetBox
	if (pApp->m_pTargetBox != NULL)
	{
		if (pApp->m_pTargetBox->IsShown())
		{
			int len = pApp->m_targetPhrase.Length();
			pApp->m_nStartChar = len;
			pApp->m_nEndChar = len;
            pApp->m_pTargetBox->SetFocusAndSetSelectionAtLanding();// whm 13Aug2018 modified
        }
	}

	// BEW added 20May09, next line required in order to remove the selection
	// Note, this function can be called after having done a Restore Knowledge Base
	// command and the latter requires no document be open, and in that case a call to
	// Redraw() will fail, so we have to wrap the Redraw() and PlaceBox() calls with a
	// test to ensure the box exists and a layout is available for redrawing - but the
	// latter is sufficient, because if the layout is available, so will the phrase box be
	if (GetLayout()->GetPileList()->GetCount() > 0 && GetLayout()->GetStripArray()->GetCount() > 0)
	{
		// a layout exists
		GetLayout()->Redraw();
//#if defined (_DEBUG)
//        wxLogDebug(_T("view, OnToolsKbEditor, line  %d  - BEFORE PlaceBox, pApp->m_targetPhrase = %s phrasebox = %s ctItems = %d"), __LINE__,
//            pApp->m_targetPhrase.c_str(), pApp->m_pTargetBox->GetTextCtrl()->GetValue().c_str(), pApp->m_pTargetBox->GetDropDownList()->GetCount());
//#endif
        // whm 11Sept2018 Note: The user may have changed the KB entries within the KBEditor before
        // it was dismissed above. Therefore we leave the PlaceBox() call below without adding the
        // noDropDownInitialization parameter in its call - which then uses the default initializeDropDown
        // enum internally and calls the SetupDropDownPhraseBoxForThisLocation() to initialize the dropdown
        // list - to include any changes made in the editor.
		GetLayout()->PlaceBox(); // this call probably unneeded but no harm done
		pApp->m_pTargetBox->CloseDropDown(); // whm 16July2024 added to suppress the opening of the dropdown list on exit from free trans mode
		pApp->m_bChooseTransInitializePopup = FALSE; // whm 16July2024 added to suppress the opening of the dropdown list on exit from free trans mode

//#if defined (_DEBUG)
//        wxLogDebug(_T("view, OnToolsKbEditor, line  %d  -  AFTER PlaceBox, pApp->m_targetPhrase = %s phrasebox = %s ctItems = %d"), __LINE__,
//            pApp->m_targetPhrase.c_str(), pApp->m_pTargetBox->GetTextCtrl()->GetValue().c_str(), pApp->m_pTargetBox->GetDropDownList()->GetCount());
//#endif
    }

	if (pApp->m_bForceFullConsistencyCheck)
	{
		// actually, let user choose current doc only, or full check
		wxCommandEvent dummy;
		GetDocument()->OnEditConsistencyCheck(dummy);
	}
	pApp->m_bForceFullConsistencyCheck = FALSE; // restore default value
	pApp->m_bKBEditorEntered = FALSE; // restore default
}

// whm 25Oct2022 revised for new Go To dialog.
// This is a convenience function that is called at 4 places in the OnGoTo() function
// below in order to update the App's m_prevVisitedChVsReferences wxArrayString before jumping
// to a new Ch:Vs reference location.
void CAdapt_ItView::UpdatePrevVisitedChVsLocationsArray()
{
	CAdapt_ItApp* pApp = (CAdapt_ItApp*)&wxGetApp();
	wxString ChVs, Ch, Vs;
	ChVs = GetChVsRefFromActiveLocation(); // usally of the form ch:vs, but may be of form ch:vs1-vs2, or ch:vs1, vs2
	ParseChVsFromReference(ChVs, Ch, Vs);
	ChVs = NormalizeChVsRefToInitialVsOfAnyBridge(ChVs);
	pApp->m_prevVisitedChVsReferences.Insert(ChVs, 0); // inserting at index 0 puts added element at beginning of string
	// Remove any following duplicate ChVs references from array
	size_t chvsRefCount = pApp->m_prevVisitedChVsReferences.GetCount();
	size_t index = chvsRefCount - 1; // start comparison at last element
	wxString elementToCompare;
	while (index > 0)
	{
		elementToCompare = pApp->m_prevVisitedChVsReferences.Item(index);
		if (elementToCompare == ChVs)
		{
			pApp->m_prevVisitedChVsReferences.RemoveAt(index);
		}
		index--;
	}
	chvsRefCount = pApp->m_prevVisitedChVsReferences.GetCount();
	if (chvsRefCount > MAX_SAVED_GO_TO_REFERENCES)
	{
		pApp->m_prevVisitedChVsReferences.RemoveAt(chvsRefCount - 1); // index is zero-based so last entry's index is chvsRefCount-1
	}
}

// BEW 17Jul11, changed for GetRefString() to return KB_Entry enum, and use all 10 maps
// for glossing KB
// whm 25Oct2022 revised for new Go To dialog
void CAdapt_ItView::OnGoTo(wxCommandEvent& WXUNUSED(event))
{
	// refactored 17Apr09
    // Since the Edit Go To... menu item has an accelerator table hot key (CTRL-G see
    // CMainFrame) and wxWidgets accelerator keys call menu and toolbar handlers even when
    // they are disabled, we must check for a disabled button and return if disabled. On
    // Windows, the accelerator key doesn't appear to call the handler for a disabled menu
    // item, but I'll leave the following code here in case it works differently on other
    // platforms.
	CAdapt_ItApp* pApp = (CAdapt_ItApp*)&wxGetApp();
	pApp->LogUserAction(_T("Initiated OnGoTo()"));
	CAdapt_ItDoc* pDoc = GetDocument();
	CMainFrame* pFrame = pApp->GetMainFrame();
	wxMenuBar* pMenuBar = pFrame->GetMenuBar();
	wxASSERT(pMenuBar != NULL);
	if (!pMenuBar->IsEnabled(ID_GO_TO))
	{
		::wxBell();
		pApp->LogUserAction(_T("But Go To menu item disabled"));
		return;
	}

	SPList* pList = pApp->m_pSourcePhrases;
	wxASSERT(pList != NULL);
	SPList::Node* pos_pList;
	if (pList->IsEmpty())
	{
		::wxBell();
		pApp->LogUserAction(_T("Doc is empty in OnGoTo()"));
		return;
	}

    // provided the phrase box exists, unconditionally enter the old phrase box's text into
    // the KB - we assume it is complete, if not, too bad - it can be fixed later if it's
    // wrong. Oct 2004, Wolfgang Stradner requested that nothing be put in KB when Go To...
    // is being used to move around. So we look at the srcphrase and if it's m_adaption
    // member is null and the m_bAbandonable flag on the box is TRUE, then the m_targetBox
    // contents can be assumed to be unwanted and so not stored. (The step up/down buttons
    // make this kind of check already.)
	bool bOK;
	CRefString* pRefStr = NULL;
	KB_Entry rsEntry;
	if (pApp->m_nActiveSequNum != -1)
	{
        pApp->m_nOldSequNum = pApp->m_nActiveSequNum; // preserve old location
		if (pApp->m_pTargetBox->GetHandle() != NULL && pApp->m_pTargetBox->IsShown())
		{
			// abandon storage when not wanted (test added Oct 2004 - see above comment)
			bool bSkipStorage = FALSE;
			if (!pApp->m_pActivePile->GetSrcPhrase()->m_adaption.IsEmpty())
			{
				pApp->m_targetPhrase = pApp->m_pActivePile->GetSrcPhrase()->m_adaption;
				pApp->m_pTargetBox->m_bAbandonable = FALSE;
			}
			else
			{
#if defined (ABANDON_NOT)
				pApp->m_pTargetBox->m_bAbandonable = FALSE;
#else
				pApp->m_pTargetBox->m_bAbandonable = TRUE;
#endif
				pApp->m_targetPhrase.Empty();
				bSkipStorage = TRUE;
			}

			if (!bSkipStorage && gbIsGlossing)
			{
                // the store will fail if the user edited the entry out of the glossing KB,
                // the latter cannot know which srcPhrases will be affected, so these will
                // still have their m_bHasGlossingKBEntry set true. We have to test for
                // this, ie. a null pRefString but the m_bHasGlossing KBEntry set TRUE is a
                // sufficient test, and if so, set the flag to FALSE
				rsEntry = pApp->m_pGlossingKB->GetRefString(pApp->m_pActivePile->GetSrcPhrase()->m_nSrcWords,
						pApp->m_pActivePile->GetSrcPhrase()->m_key,pApp->m_targetPhrase, pRefStr);
				if ((pRefStr == NULL || rsEntry == present_but_deleted) &&
					pApp->m_pActivePile->GetSrcPhrase()->m_bHasGlossingKBEntry)
				{
					pApp->m_pActivePile->GetSrcPhrase()->m_bHasGlossingKBEntry = FALSE;
				}
				bOK = pApp->m_pGlossingKB->StoreText(pApp->m_pActivePile->GetSrcPhrase(), pApp->m_targetPhrase);
				bOK = bOK; // avoid warning
			}
			else if (!bSkipStorage && !gbIsGlossing)
			{
				MakeTargetStringIncludingPunctuation(pApp->m_pActivePile->GetSrcPhrase(),pApp->m_targetPhrase);
				RemovePunctuation(pDoc, &pApp->m_targetPhrase, from_target_text);

                // the store will fail if the user edited the entry out of the KB, as the
                // latter cannot know which srcPhrases will be affected, so these will
                // still have their m_bHasKBEntry set true. We have to test for this, ie. a
                // null pRefString but the m_bHasKBEntry set TRUE is a sufficient test, and
                // if so, set the flag to FALSE
				rsEntry = pApp->m_pKB->GetRefString(pApp->m_pActivePile->GetSrcPhrase()->m_nSrcWords,
								pApp->m_pActivePile->GetSrcPhrase()->m_key,pApp->m_targetPhrase, pRefStr);
				if ((pRefStr == NULL || rsEntry == present_but_deleted) &&
					pApp->m_pActivePile->GetSrcPhrase()->m_bHasKBEntry)
				{
					pApp->m_pActivePile->GetSrcPhrase()->m_bHasKBEntry = FALSE;
				}
                //pApp->m_bInhibitMakeTargetStringCall = TRUE;
				bOK = pApp->m_pKB->StoreText(pApp->m_pActivePile->GetSrcPhrase(), pApp->m_targetPhrase);
                pApp->m_bInhibitMakeTargetStringCall = FALSE;
			}
		}
	}
	else
	{
        pApp->m_nOldSequNum = -1; // if we were at the eof, need -1
						   // to signal no earlier valid location
	}

	// remove any selection to be safe from unwanted selection-related side effects
	RemoveSelection();

	wxString str;
	int nWantedChapter = 1;
	int nWantedVerse = 1;
	CGoToDlg dlg(pApp->GetMainFrame());
	if (dlg.ShowModal() == wxID_OK)
	{
		nWantedChapter = dlg.m_nChapter;
		nWantedVerse = dlg.m_nVerse; // from Oct 2004 extended version, this can be 0
						// which means "ignore the verse number, use chapter number only"

		// whm 25Oct2022 addition. Bleed off the special case where the user entered "0:0" which
		// for purposes of the Go To dialog, now means to go to the first source phrase that is
		// not a Retranslation at the beginning of the document. This is a handy way to go to
		// the beginning of a Scripture document that has a lot of introductory material before 
		// the actual 1:1 reference.
		if (dlg.m_nChapter == 0 && dlg.m_nVerse == 0)
		{
			// Jump directly to the first source phrase of the document, unless there is a 
			// retranslation there, in which case jump to the next non-retranslation source phrase
			// if available.
			pos_pList = pList->GetFirst();
			wxASSERT(pos_pList != NULL);
			while (pos_pList != NULL)
			{
				CSourcePhrase* pSrcPhrase = (CSourcePhrase*)pos_pList->GetData();
				pos_pList = pos_pList->GetNext();
				wxASSERT(pSrcPhrase != NULL);
				if (!gbIsGlossing)
				{
					// when adapting, we must prevent placing the phrasebox within a
					// retranslation, but when glossing this does not matter
					if (pSrcPhrase->m_bRetranslation)
					{
						CSourcePhrase* pSaveSP = pSrcPhrase;
						pSrcPhrase = GetPrevSafeSrcPhrase(pSrcPhrase);

						if (pSrcPhrase == NULL)
						{
							pSrcPhrase = GetFollSafeSrcPhrase(pSaveSP);

							if (pSrcPhrase == NULL)
							{
								// nowhere is a safe location! (Is the user retranslating
								// everything? !!!)
								//IDS_GOTO_FAILED
								// whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
								pApp->m_bUserDlgOrMessageRequested = TRUE;
								wxMessageBox(_(
									"Sorry, the Go To command failed. No valid location for the phrase box could be found before or after your chosen chapter and verse. (Are all your adaptations in the form of retranslations?)"),
									_T(""), wxICON_EXCLAMATION | wxOK);
								pApp->m_pTargetBox->SetFocusAndSetSelectionAtLanding();// whm 13Aug2018 modified
								pApp->LogUserAction(_T("Go To command failed. No valid location for the phrase box..."));
								goto b; // don't jump anywhere
							}
						}
					}
				}
				// whm 25Oct2022 added line below for revised Go To dialog.
				// UpdatePrevVisitedChVsLocationsArray() nserts the current location reference to index 0 before 
				// jumping to the new location so that the App's m_prevVisitedChVsReferences array will always 
				// have the last visited location as the first element in the array.
				UpdatePrevVisitedChVsLocationsArray();
				// jump to whatever pile is not in a retranslation, as close to wanted
				// loc'n as possible

				// jump to whatever pile is not in a retranslation,
				// as close to wanted loc'n as possible
				Jump(pApp, pSrcPhrase);

				// BEW added 10Dec12 as a workaround for GTK version bogusly resetting scrollPos to earlier value
#if defined(SCROLLPOS) && defined(__WXGTK__)
				pApp->SetAdjustScrollPosFlag(TRUE); // OnIdle() will pick it up, post a
					// wxEVT_Adjust_Scroll_Pos custom event & it's handler will restore
					// correct scrollPos value, get a draw of the view done, and then
					// OnIdle() will reset the m_bAdjustScrollPos flag back to its
					// default FALSE value
#endif
					// if the user has turned on the sending of synchronized scrolling
					// messages, send the relevant message
				// whm commented out block below as we didn't jump to a normal ch:vs Scripture reference
				//if (!pApp->m_bIgnoreScriptureReference_Send)
				//{
				//	SendScriptureReferenceFocusMessage(pApp->m_pSourcePhrases, pSrcPhrase);
				//}
				return;
			}
		}

		// find the nominated chapter and verse, if possible, using the CString for chapt:verse;
		// if it fails, assume a range & try again with integers; but if verse is 0, then go straight
		// to the range block
		if (dlg.m_nVerse == 0)
			goto v;
		if (dlg.m_nChapter == 0)
		{
			// special case, either its non-scripture, or a chapterless book like 2John
			pos_pList = pList->GetFirst();
			wxASSERT(pos_pList != NULL);

			// first, assume it's a chapterless book like 2 John, try find the verse
			while (pos_pList != NULL)
			{
				CSourcePhrase* pSrcPhrase = (CSourcePhrase*)pos_pList->GetData();
				pos_pList = pos_pList->GetNext();
				wxASSERT(pSrcPhrase != NULL);
				if (pSrcPhrase->m_chapterVerse == dlg.m_verse)
				{
					if (!gbIsGlossing)
					{
						// when adapting, we must prevent placing the phrasebox within a
						// retranslation, but when glossing this does not matter
						if (pSrcPhrase->m_bRetranslation)
						{
							CSourcePhrase* pSaveSP = pSrcPhrase;
							pSrcPhrase = GetPrevSafeSrcPhrase(pSrcPhrase);

							if (pSrcPhrase == NULL)
							{
								pSrcPhrase = GetFollSafeSrcPhrase(pSaveSP);

								if (pSrcPhrase == NULL)
								{
									// nowhere is a safe location! (Is the user retranslating
									// everything? !!!)
									//IDS_GOTO_FAILED
                                    // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
                                    pApp->m_bUserDlgOrMessageRequested = TRUE;
                                    wxMessageBox(_(
"Sorry, the Go To command failed. No valid location for the phrase box could be found before or after your chosen chapter and verse. (Are all your adaptations in the form of retranslations?)"),
									_T(""), wxICON_EXCLAMATION | wxOK);
                                    pApp->m_pTargetBox->SetFocusAndSetSelectionAtLanding();// whm 13Aug2018 modified
									pApp->LogUserAction(_T("Go To command failed. No valid location for the phrase box..."));
									goto b; // don't jump anywhere
								}
							}
						}
					}

					// whm 25Oct2022 added line below for revised Go To dialog.
					// UpdatePrevVisitedChVsLocationsArray() nserts the current location reference to index 0 before 
					// jumping to the new location so that the App's m_prevVisitedChVsReferences array will always 
					// have the last visited location as the first element in the array.
					UpdatePrevVisitedChVsLocationsArray();
					// jump to whatever pile is not in a retranslation, as close to wanted
					// loc'n as possible

                    // jump to whatever pile is not in a retranslation,
					// as close to wanted loc'n as possible
					Jump(pApp,pSrcPhrase);

    // BEW added 10Dec12 as a workaround for GTK version bogusly resetting scrollPos to earlier value
#if defined(SCROLLPOS) && defined(__WXGTK__)
                    pApp->SetAdjustScrollPosFlag(TRUE); // OnIdle() will pick it up, post a
                        // wxEVT_Adjust_Scroll_Pos custom event & it's handler will restore
                        // correct scrollPos value, get a draw of the view done, and then
                        // OnIdle() will reset the m_bAdjustScrollPos flag back to its
                        // default FALSE value
#endif
					// if the user has turned on the sending of synchronized scrolling
					// messages, send the relevant message
					if (!pApp->m_bIgnoreScriptureReference_Send)
					{
						SendScriptureReferenceFocusMessage(pApp->m_pSourcePhrases,pSrcPhrase);
					}
					return;
				}
			}

			// didn't find the verse, so instead put the phrase box at the first sourcephrase
			// with TextType of 'verse'
			pos_pList = pList->GetFirst();
			wxASSERT(pos_pList != NULL);
			while (pos_pList != NULL)
			{
				CSourcePhrase* pSrcPhrase = (CSourcePhrase*)pos_pList->GetData();
				pos_pList = pos_pList->GetNext();
				wxASSERT(pSrcPhrase != NULL);
				if (pSrcPhrase->m_curTextType == verse)
				{
					if (!gbIsGlossing)
					{
						if (pSrcPhrase->m_bRetranslation)
						{
							CSourcePhrase* pSaveSP = pSrcPhrase;
							pSrcPhrase = GetPrevSafeSrcPhrase(pSrcPhrase);

							if (pSrcPhrase == NULL)
							{
								pSrcPhrase = GetFollSafeSrcPhrase(pSaveSP);

								if (pSrcPhrase == NULL)
								{
									// nowhere is a safe location! (Is the user retranslating
									// everything? !!!)
									// IDS_GOTO_FAILED
                                    // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
                                    pApp->m_bUserDlgOrMessageRequested = TRUE;
                                    wxMessageBox(_(
"Sorry, the Go To command failed. No valid location for the phrase box could be found before or after your chosen chapter and verse. (Are all your adaptations in the form of retranslations?)"),
									_T(""),wxICON_EXCLAMATION | wxOK);
                                    pApp->m_pTargetBox->SetFocusAndSetSelectionAtLanding();// whm 13Aug2018 modified
									pApp->LogUserAction(_T("Go To command failed. No valid location for the phrase box..."));
									goto b; // don't jump anywhere
								}
							}
						}
					}

					// whm 25Oct2022 added line below for revised Go To dialog.
					// UpdatePrevVisitedChVsLocationsArray() nserts the current location reference to index 0 before 
					// jumping to the new location so that the App's m_prevVisitedChVsReferences array will always 
					// have the last visited location as the first element in the array.
					UpdatePrevVisitedChVsLocationsArray();
					// jump to whatever pile is not in a retranslation, as close to wanted
					// loc'n as possible

                    // jump to whatever pile is not in a retranslation, as close to wanted
					// loc'n as possible
					Jump(pApp,pSrcPhrase);

    // BEW added 10Dec12 as a workaround for GTK version bogusly resetting scrollPos to earlier value
#if defined(SCROLLPOS) && defined(__WXGTK__)
                    pApp->SetAdjustScrollPosFlag(TRUE); // OnIdle() will pick it up, post a
                        // wxEVT_Adjust_Scroll_Pos custom event & it's handler will restore
                        // correct scrollPos value, get a draw of the view done, and then
                        // OnIdle() will reset the m_bAdjustScrollPos flag back to its
                        // default FALSE value
#endif
					// if the user has turned on the sending of synchronized scrolling
					// messages, send the relevant message
					if (!pApp->m_bIgnoreScriptureReference_Send)
					{
						SendScriptureReferenceFocusMessage(pApp->m_pSourcePhrases,pSrcPhrase);
					}

					return;
				}
			}
		} // end chapter number == zero block
		else
		{
			// look for chapter & verse in the form  n:m
			pos_pList = pList->GetFirst();
			wxASSERT(pos_pList != NULL);
			while (pos_pList != NULL)
			{
				CSourcePhrase* pSrcPhrase = (CSourcePhrase*)pos_pList->GetData();
				pos_pList = pos_pList->GetNext();
				wxASSERT(pSrcPhrase != NULL);
				if (pSrcPhrase->m_chapterVerse == dlg.m_chapterVerse)
				{
					if (!gbIsGlossing)
					{
						if (pSrcPhrase->m_bRetranslation)
						{
							CSourcePhrase* pSaveSP = pSrcPhrase;
							pSrcPhrase = GetPrevSafeSrcPhrase(pSrcPhrase);

							if (pSrcPhrase == NULL)
							{
								pSrcPhrase = GetFollSafeSrcPhrase(pSaveSP);

								if (pSrcPhrase == NULL)
								{
									// nowhere is a safe location! (Is the user retranslating
									// everything? !!!)
									// IDS_GOTO_FAILED
                                    // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
                                    pApp->m_bUserDlgOrMessageRequested = TRUE;
                                    wxMessageBox(_(
"Sorry, the Go To command failed. No valid location for the phrase box could be found before or after your chosen chapter and verse. (Are all your adaptations in the form of retranslations?)"),
									_T(""), wxICON_EXCLAMATION | wxOK);
                                    pApp->m_pTargetBox->SetFocusAndSetSelectionAtLanding();// whm 13Aug2018 modified
									pApp->LogUserAction(_T("Go To command failed. No valid location for the phrase box..."));
									goto b; // don't jump anywhere
								}
							}
						}
					}

					// whm 25Oct2022 added line below for revised Go To dialog.
					// UpdatePrevVisitedChVsLocationsArray() nserts the current location reference to index 0 before 
					// jumping to the new location so that the App's m_prevVisitedChVsReferences array will always 
					// have the last visited location as the first element in the array.
					UpdatePrevVisitedChVsLocationsArray();
					
					// jump to whatever pile is not in a retranslation, as close to wanted
					// loc'n as possible
					Jump(pApp,pSrcPhrase);

    // BEW added 10Dec12 as a workaround for GTK version bogusly resetting scrollPos to earlier value
#if defined(SCROLLPOS) && defined(__WXGTK__)
                    pApp->SetAdjustScrollPosFlag(TRUE); // OnIdle() will pick it up, post a
                        // wxEVT_Adjust_Scroll_Pos custom event & it's handler will restore
                        // correct scrollPos value, get a draw of the view done, and then
                        // OnIdle() will reset the m_bAdjustScrollPos flag back to its
                        // default FALSE value
#endif
					// if the user has turned on the sending of synchronized scrolling
					// messages, send the relevant message
					if (!pApp->m_bIgnoreScriptureReference_Send)
					{
						SendScriptureReferenceFocusMessage(pApp->m_pSourcePhrases,pSrcPhrase);
					}


					return;
				}
			}

			// not found, so try again, this time assuming we may have the wanted ch & verse
			// within a range in the text, such as 3-7, or 3,4 etc; or the verse may have been
			// set to zero so that only chapter numbers are to be considered
v:			pos_pList = pList->GetFirst();
			wxASSERT(pos_pList != NULL);
			while (pos_pList != NULL)
			{
				CSourcePhrase* pSrcPhrase = (CSourcePhrase*)pos_pList->GetData();
				pos_pList = pos_pList->GetNext();
				wxASSERT(pSrcPhrase != NULL);

				int chapter;
				int firstVerse;
				int lastVerse;
                // BW, Oct 04, extended the signature to take the nWantedVerse as an extra
                // parameter, so that when it is zero in value we can force a return once a
                // chapter beginning has been located; this extra parameter has no other
                // internal function in the AnalyseReference function, and since this
                // function is called in nearly a dozen other places, those places just
                // need an arbitrary non-zero number passed in for the nWantedVerse number
                // so as to retain the previous functionality unchanged
				bool bOK =
					AnalyseReference(pSrcPhrase->m_chapterVerse,chapter,firstVerse,
									lastVerse,nWantedVerse);

				// if we've already passed the chapter, return
				if (bOK && chapter > nWantedChapter)
					goto a;

				if (bOK && chapter == nWantedChapter && nWantedVerse == 0)
					goto f;

				if (bOK && chapter == nWantedChapter && (nWantedVerse >= firstVerse
					&& nWantedVerse <= lastVerse))
				{
f:					if (!gbIsGlossing)
					{
						if (pSrcPhrase->m_bRetranslation)
						{
							CSourcePhrase* pSaveSP = pSrcPhrase;
							pSrcPhrase = GetPrevSafeSrcPhrase(pSrcPhrase);

							if (pSrcPhrase == NULL)
							{
								pSrcPhrase = GetFollSafeSrcPhrase(pSaveSP);

								if (pSrcPhrase == NULL)
								{
									// nowhere is a safe location! (Is the user retranslating
									// everything? !!!)
									// IDS_GOTO_FAILED
                                    // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
                                    pApp->m_bUserDlgOrMessageRequested = TRUE;
                                    wxMessageBox(_(
"Sorry, the Go To command failed. No valid location for the phrase box could be found before or after your chosen chapter and verse. (Are all your adaptations in the form of retranslations?)"),
									_T(""), wxICON_EXCLAMATION | wxOK);
                                    pApp->m_pTargetBox->SetFocusAndSetSelectionAtLanding();// whm 13Aug2018 modified
									pApp->LogUserAction(_T("Go To command failed. No valid location for the phrase box..."));
									goto b; // don't jump anywhere
								}
							}
						}
					}

					// whm 25Oct2022 added line below for revised Go To dialog.
					// UpdatePrevVisitedChVsLocationsArray() nserts the current location reference to index 0 before 
					// jumping to the new location so that the App's m_prevVisitedChVsReferences array will always 
					// have the last visited location as the first element in the array.
					UpdatePrevVisitedChVsLocationsArray();
					// jump to whatever pile is not in a retranslation, as close to wanted
					// loc'n as possible

					Jump(pApp,pSrcPhrase);

    // BEW added 10Dec12 as a workaround for GTK version bogusly resetting scrollPos to earlier value
#if defined(SCROLLPOS) && defined(__WXGTK__)
                    pApp->SetAdjustScrollPosFlag(TRUE); // OnIdle() will pick it up, post a
                        // wxEVT_Adjust_Scroll_Pos custom event & it's handler will restore
                        // correct scrollPos value, get a draw of the view done, and then
                        // OnIdle() will reset the m_bAdjustScrollPos flag back to its
                        // default FALSE value
#endif
					// if the user has turned on the sending of synchronized scrolling
					// messages, send the relevant message
					if (!pApp->m_bIgnoreScriptureReference_Send)
					{
						SendScriptureReferenceFocusMessage(pApp->m_pSourcePhrases,pSrcPhrase);
					}

					return;
				}

				if (bOK && chapter == nWantedChapter &&  nWantedVerse != 0
						&& lastVerse > nWantedVerse) // if beyond the wanted verse
					goto a;
			}

			// not found, so tell the user
			//IDS_NO_SUCH_CHAPTER
a:			str = str.Format(_(
"Sorry, but the chapter and verse combination  %s  does not exist in this document. The command will be ignored."),
			dlg.m_chapterVerse.c_str());
            // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
            pApp->m_bUserDlgOrMessageRequested = TRUE;
            wxMessageBox(str,_T(""), wxICON_EXCLAMATION | wxOK);
            pApp->m_pTargetBox->SetFocusAndSetSelectionAtLanding();// whm 13Aug2018 modified
			pApp->LogUserAction(str);
			goto b;
		}
	}
	else
	{
        // user cancelled, so do nothing except remove the ref string that we stored above
        // (and most importantly, this will clear the m_bHasKBEntry on the source phrase
        // too)
b:		if (gbIsGlossing)
			pApp->m_pGlossingKB->GetAndRemoveRefString(pApp->m_pActivePile->GetSrcPhrase(),
												pApp->m_targetPhrase, useTargetPhraseForLookup);
		else
			pApp->m_pKB->GetAndRemoveRefString(pApp->m_pActivePile->GetSrcPhrase(),
												pApp->m_targetPhrase, useTargetPhraseForLookup);
	}
}

// BEW 10Apr10, no changes for support of doc version 5;
// returns FALSE only if there is no : in the chapter:verse string passed in string
bool CAdapt_ItView::AnalyseReference(wxString& chVerse,int& chapter,int& vFirst,
									 int& vLast,int nWantedVerse)
{
	int chap = -1;
	int firstVerse = -1;
	int lastVerse = -1;
	if (chVerse.IsEmpty())
		return FALSE; // premature exit, no chapter or verse on this srcPhrase
	wxString range;
	range.Empty();

	// first determine if there is a chapter number present
	int nFound = chVerse.Find(_T(':'));
	if (nFound < 0)
	{
		// no chapter number, so  set chapter to zero
		range = chVerse;
		chap = 0;
	}
	else
	{
		// chapter number exists, extract it and put the remainder after the colon into range
		wxString strChapter = SpanExcluding(chVerse,_T(":"));
#ifdef __WXMAC__
// Kludge because the atoi() function in the MacOS X standard library can't handle Arabic digits
		for (size_t imak=0; imak < strChapter.Len(); imak++)
		{
			wxChar imaCh = strChapter.GetChar(imak);
			if (imaCh >= (wchar_t)0x6f0 && imaCh <= (wchar_t)0x6f9)
				strChapter.SetChar(imak, imaCh & (wchar_t)0x3f);	// zero out the higher bits of these Arabic digits
		}
#endif /* __WXMAC__ */
		chap = wxAtoi(strChapter);

		nFound++; // index the first char after the colon
		range = chVerse.Mid(nFound);

		// if wanted verse is zero, then exit now since we have a chapter located
		if (nWantedVerse == 0)
		{
			chapter = chap;
			return TRUE;
		}
	}

	// potentially we have a range, so first see if it is a range specified by a hyphen separator
	nFound = range.Find(_T('-'));
	if (nFound >= 0)
	{
		// it is a range, find first & last verse numbers
		wxASSERT(nFound != 0); // must be an initial verse number
		wxString verseFirst = SpanExcluding(range,_T("-"));
		firstVerse = wxAtoi(verseFirst);
		nFound++;
		wxString verseLast = range.Mid(nFound);
		lastVerse = wxAtoi(verseLast);
	}
	else
	{
		// no hyphenated range, so try a comma-delimited range
		nFound = range.Find(_T(','));
		if (nFound < 0)
		{
			// its neither, so it's something unknown, so assume its just a single verse number
			firstVerse = lastVerse = wxAtoi(range);
			// from version 2.0.5 and onwards we allow verse numbers to have unlimited maximum
			// value
			chapter = chap;
			vFirst = firstVerse;
			vLast = lastVerse;
			return TRUE;
		}
		else
		{
            // it's a comma-delimited range, so get first and last verse numbers (assume
            // n,m structure) note: printing code will allow comma delimited ranges of form
            // n,m,o,p,q etc (see ExtractChapterAndVerse in ..view.cpp), so if the fact
            // that AnalyseReference permits only n,m ever becomes an issue for someone,
            // the copy the extra bit of code needed into the block below (actually, it may
            // be possible to get rid of the latter function and just use the Extract....
            // one.)
			wxASSERT(nFound != 0); // must be an initial verse number
			wxString verseFirst = SpanExcluding(range,_T(","));
			firstVerse = wxAtoi(verseFirst);
			nFound++;
			wxString verseLast = range.Mid(nFound);
			lastVerse = wxAtoi(verseLast);
		}
	}

	// return the values found
	chapter = chap;
	vFirst = firstVerse;
	vLast = lastVerse;
	return TRUE;
}

// while this appears to be coded for a forward jump only, actually it works equally well
// for arbitrary distance forward or backwards jumps
void CAdapt_ItView::Jump(CAdapt_ItApp* pApp, CSourcePhrase* pNewSrcPhrase)
{
	wxASSERT(pNewSrcPhrase);

	// jump to here
	int nNewSequNum = pNewSrcPhrase->m_nSequNumber;
	pApp->m_pActivePile = GetPile(nNewSequNum);
	CCell* pCell = pApp->m_pActivePile->GetCell(1); // the cell where the phraseBox is to be
	pApp->m_targetPhrase = pNewSrcPhrase->m_adaption; // make it look normal,
													  // don't use m_targetStr here
	pApp->GetMainFrame()->canvas->ScrollIntoView(nNewSequNum);
    pApp->m_bMovingToDifferentPile = TRUE; // whm 22Mar2018 added
	PlacePhraseBox(pCell,2);
    pApp->m_bMovingToDifferentPile = FALSE; // whm 22Mar2018 added

	// update status bar with project name
	pApp->RefreshStatusBarInfo();
	Invalidate();
	GetLayout()->PlaceBox();
}

/////////////////////////////////////////////////////////////////////////////////
/// \return		nothing
/// \param      event   -> the wxUpdateUIEvent that is generated when the Edit Menu
///                        is about to be displayed
/// \remarks
/// Called from: The wxUpdateUIEvent mechanism when the associated menu item is selected,
/// and before the menu is displayed. If Vertical Editing is in progress, or the pointers
/// to the KBs are NULL or the bundle's m_nStripCount is not greater than zero, this
/// handler disables the "Go To..." item in the Edit menu, otherwise it enables the "Go
/// To..." item on the Edit menu.
/////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItView::OnUpdateGoTo(wxUpdateUIEvent& event)
{
	CAdapt_ItApp* pApp = (CAdapt_ItApp*)&wxGetApp();
	if (gbVerticalEditInProgress)
	{
		event.Enable(FALSE);
		return;
	}
	if (pApp->m_pKB != NULL && pApp->m_pGlossingKB != NULL &&
		pApp->IsDocumentOpen())
		event.Enable(TRUE);
	else
		event.Enable(FALSE);
}

// nNewSequNum is the index of the first srcPhrase in the new selection, nCount is how many
// srcPhrases are to be selected, and nSelectionLine is the 0-based line index to put the
// selection it - it can be any of the first two line indices in a strip (ie. 0 or 1)
// Called from CAdapt_ItView::DoFindNext() and CPhraseBox::DoCancelAndSelect().
// CPhraseBox::DoCancelAndSelect() requires that a RecalcLayout() call, and resetting of
// the active sequence number and active pile be done internally, but DoFindNext() doesn't
// require these calls because they are done further up in the call hierarchy - and in fact
// if done when a match is made for text in a retranslation, the active location would be
// set wrongly if done here. So we use the bDoRecalcLayout flag to suppress the unwanted
// code when used in the context of a Find operation.
// BEW added 2Aug09, the bDoRecalcLayout flag
// BEW 26Mar10 updated for support of doc version 5 (changes needed, and also did removal of a
// global boolean, gbUserWantsSelection which was default FALSE, throughout the app -- it
// made the logic unnecessarily convoluted here and elsewhere)
void CAdapt_ItView::MakeSelectionForFind(int nNewSequNum, int nCount, int nSelectionLine,
											bool bDoRecalcLayout)
{
	// refactored 17Apr09
	wxASSERT(nSelectionLine == 0);
	CAdapt_ItApp* pApp = &wxGetApp();
	CLayout* pLayout = GetLayout();
	wxASSERT(pApp != NULL);

	// BEW 26Mar10, added the second param to the test, this makes a match in a
	// retranslation automatically skip the recalc layout and placement
	if (bDoRecalcLayout)
	{
        // the above flag is never TRUE when this function is being called in association
        // with a Find Next operation; but since this function is also used for making a
        // selection when user hits the "Cancel And Select" button in CChooseTranslation
        // dialog when called from LookAhead(), the flag will be TRUE when that happens
        // BEW added 19Dec08: also we will use this function witht TRUE passed to create
        // the needed selection, along with a recalc of the layout, within the
        // RecreateCollectedBackTranslationsInVerticalEdit() function
		if (!pApp->m_bMatchedRetranslation)
			// don't put the active location at the match location if the match was in a
			// retranslation
			pApp->m_nActiveSequNum = nNewSequNum;

#ifdef _NEW_LAYOUT
		pLayout->RecalcLayout(pApp->m_pSourcePhrases, keep_strips_keep_piles);
#else
		pLayout->RecalcLayout(pApp->m_pSourcePhrases, create_strips_keep_piles);
#endif
		pApp->m_pActivePile = GetPile(pApp->m_nActiveSequNum);
		pApp->GetMainFrame()->canvas->ScrollIntoView(nNewSequNum);
	}
	// get the cell which will show the selection
	CCell* pCell = NULL;
	CPile* pFirstPileInRetrans = NULL;
	if (pApp->m_bMatchedRetranslation)
	{
		// active pile is outside the retranslation, so the matched location will be the
		// first cell of the retranslation, but we must not put the phrase box there - 
		// put it at the previous CSourcePhrase, if that exists
		pFirstPileInRetrans = GetPile(nNewSequNum);
		pCell = pFirstPileInRetrans->GetCell(nSelectionLine);
		CPile* pPrevPile = GetPile( nNewSequNum - 1);
		if (pPrevPile != NULL)
		{
			pApp->m_pActivePile = pPrevPile;
			pApp->m_nActiveSequNum = nNewSequNum - 1;
		}
		else
		{
			// for no previous pile, we have to use the pFirstPileInRetrans one instead
			pApp->m_pActivePile = pFirstPileInRetrans;
			pApp->m_nActiveSequNum = nNewSequNum;

		}
	}
	else
	{
		// whm 12May2021 Observation: code going through this path results in pFirstPileInRetrans remaining NULL
		// the new active location needs to be at the match location
		pApp->m_pActivePile = GetPile(nNewSequNum);
		pApp->m_nActiveSequNum = nNewSequNum;
		pCell = pApp->m_pActivePile->GetCell(nSelectionLine);
	}

    // make the selection; first, get rid of any old selection
	wxClientDC aDC(pApp->GetMainFrame()->canvas); // make a device context
	if (pApp->m_selection.GetCount() != 0)
	{
		CCellList::Node* pos_pCellList = pApp->m_selection.GetFirst();
		CCell* pOldSel;
		while (pos_pCellList != NULL)
		{
			pOldSel = (CCell*)pos_pCellList->GetData();
			pos_pCellList = pos_pCellList->GetNext();
			aDC.SetBackgroundMode(pApp->m_backgroundMode);
			aDC.SetTextBackground(wxColour(255,255,255)); // white
			pOldSel->SetSelected(FALSE);
			pOldSel->DrawCell(&aDC,pOldSel->GetColor());
		}
		pApp->m_selection.Clear();
		pApp->m_selectionLine = -1; // no selection
		pApp->m_pAnchor = (CCell*)NULL;
	}

	// then do the new selection
	aDC.SetBackgroundMode(pApp->m_backgroundMode);
	aDC.SetTextBackground(wxColour(235,245,40));// yellow
	pApp->m_bSelectByArrowKey = FALSE;
	pCell->SetSelected(TRUE);
	pCell->DrawCell(&aDC, pCell->GetColor());

	// preserve record of the selection
	pApp->m_selection.Append(pCell);
	pApp->m_selectionLine = nSelectionLine;
	pApp->m_pAnchor = pCell;

	// whm 12May2021 modified to prevent crash observed by Mike H in Linux due to the pFirstPileInRetrans pointer being NULL
	// BEW should check my logic below in adding the test for detecting whether PFirstPileInRetrans id NULL
	//if (pApp->m_pFindDlg != NULL)
	if (pApp->m_pFindDlg != NULL && pFirstPileInRetrans != NULL)
	{
		CFindDlg* pDlg = pApp->m_pFindDlg;
		wxASSERT(pDlg != NULL);

		if (pDlg->m_bFindRetranslation)
		{
			// BEW 31Mar21 added next 6 lines, to get an accurate nCount value,
			// when searching for retranslation locations
			int firstSequNum = pFirstPileInRetrans->GetSrcPhrase()->m_nSequNumber; // <== Crash happened here because pFirstPileInRetrans was still NULL
			int howMany = pApp->GetRetranslation()->CountRetransPiles(pApp->m_pSourcePhrases, firstSequNum);
			if (howMany > nCount)
			{
				nCount = howMany;
			}
		}

		if (nCount > 1)
		{
			// extend the selection
			ExtendSelectionForFind(pCell, nCount);
		}
		else
		{
			// if not extending, we still need a Redraw() in order to get the highlighted
			// single cell shown selected
			GetLayout()->Redraw();
		}
		// BEW 31Mar21 get the m_adaption value at the active location, and write it to
		// app's m_targetPhrase, and into the phrasebox
		wxString tgtPhrase = pApp->m_pActivePile->GetSrcPhrase()->m_adaption;
		pApp->m_targetPhrase = tgtPhrase;
		pApp->m_pTargetBox->ChangeValue(tgtPhrase);

		// BEW 31Mar21 finding retranslations, at each success, the radio button goes
		// unticked, so reset it

		if (pApp->m_bMatchedRetranslation)
		{
			pDlg->m_bFindRetranslation = TRUE; // this bool got cleared to false
			pDlg->m_pFindRetranslation->SetValue(TRUE);
		}
	} // end of TRUE block for test:  if (pApp->m_pFindDlg != NULL)
	else // BEW 6Apr21 added else block
	{
		// we are doing a Find Next in the m_pReplaceDlg
		// whm 12Mqy2021 modified the test below to check for m_pReplaceDlg being NULL to avoid crash reported by Mike H.
		//if (pApp->m_pReplaceDlg->m_bReplaceDlg != NULL)
		if (pApp->m_pReplaceDlg != NULL && pApp->m_pReplaceDlg->m_bReplaceDlg != FALSE)
		{
			CReplaceDlg* pDlg = pApp->m_pReplaceDlg;
			pDlg = pDlg; //  // avoid gcc set but not used warning in release builds
			wxASSERT(pDlg != NULL);
			nCount = 1; // disallow replacing across multiple piles
			// anchor pCell is already selected, and backgounded yellow
			GetLayout()->Redraw(); // get the pCell shown selected

		// BEW 31Mar21 get the m_adaption value at the active location, and write it to
		// app's m_targetPhrase, and into the phrasebox
			wxString tgtPhrase = pApp->m_pActivePile->GetSrcPhrase()->m_adaption;
			pApp->m_targetPhrase = tgtPhrase;
			pApp->m_pTargetBox->ChangeValue(tgtPhrase);

		} // end of true block for test: if (pApp->m_pReplaceDlg->m_bReplaceDlg != NULL)
	}

	Invalidate();
	GetLayout()->PlaceBox();
}

// pAnchorCell is pointer to the first cell in the selection, nCount is the number cells in
// the selection (there is always one in existence, the first, when this function is
// entered) Because the caller supports selections in src and phrase box line (either tgt
// or gloss), the pAnchorCell's m_nCell index value may be 0 or 1)
// BEW 26Mar10, no changes needed for support of doc version 5
void CAdapt_ItView::ExtendSelectionForFind(CCell* pAnchorCell, int nCount)
{
	// refactored 17Apr09
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	wxClientDC aDC(pApp->GetMainFrame()->canvas); // make a device context

	// local variables to use in the loops below
	CPile*	pCurPile; // the one we use in the loop
	//CStrip* pCurStrip; // the strip the starting pile is in // set but unused
	CCell*	pCurCell; // the current cell in the current pile (used in loop)
	//int nCurPileCount; // how many piles in current strip // set but unused
	//int nCurPile; // index of current pile (in loop) // set but unused
	//int nCurStrip; // index of current strip in which the current pile is located // set but unused
	CSourcePhrase* pCurSrcPhrase; // the current pile's source phrase pointer (in loop)

	// set the above local variables from pAnchorCell
	pCurPile = pAnchorCell->GetPile();
	//pCurStrip = pCurPile->GetStrip();
	//nCurPileCount = pCurStrip->GetPileCount();
	//nCurPile = pCurPile->GetPileIndex();
	//nCurStrip = pCurStrip->GetStripIndex();

	int nAnchorSequNum = pCurPile->GetSrcPhrase()->m_nSequNumber;
	int nEndSequNum = nAnchorSequNum + nCount - 1;
	wxASSERT(nEndSequNum > 0 && nEndSequNum <= pApp->GetMaxIndex());
	int sequ = nAnchorSequNum;
	while (sequ < nEndSequNum)
	{
		sequ++; // next one

		// get the next cell
		pCurPile = GetPile(sequ);
		wxASSERT(pCurPile != NULL);
		pCurSrcPhrase = pCurPile->GetSrcPhrase();
		wxASSERT(pCurSrcPhrase->m_nSequNumber == sequ); // must match
		pCurSrcPhrase = pCurSrcPhrase; // avoid warning
		pCurCell = pCurPile->GetCell(pApp->m_selectionLine); // get the cell...
					// Note: pApp->m_selectionLine might be 0 or 1, not just 0

		// if it is already selected then iterate to do next one, else select it
		if (!pCurCell->IsSelected())
		{
			aDC.SetBackgroundMode(pApp->m_backgroundMode);
			aDC.SetTextBackground(wxColour(235,245,40)); // yellow
			pCurCell->DrawCell(&aDC, pCurCell->GetColor());
			pCurCell->SetSelected(TRUE);

			// keep a record of it
			pApp->m_selection.Append(pCurCell);
		}
	}
}

// BEW 26Mar10, no changes needed for support of doc version 5
void CAdapt_ItView::OnFind(wxCommandEvent& event)
{
	// refactored 17Apr09
 	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
   // check that a Find & Replace dialog is not currently open, if it is, delete it
    // preserving contents of the src & tgt edit boxes
	wxString saveSrc;
	saveSrc.Empty();
	wxString saveTgt;
	saveTgt.Empty();
	pApp->LogUserAction(_T("Initiated OnFind()"));

	if (pApp->m_pFindDlg != NULL)
	{
		if (gbFind == FALSE)
		{
			//pApp->m_pFindDlg->TransferDataFromWindow(); // no longer used
			saveSrc = pApp->m_pFindDlg->m_srcStr;
			saveTgt = pApp->m_pFindDlg->m_tgtStr;
			pApp->m_pFindDlg->Destroy();
			pApp->m_pFindDlg = NULL;
		}
	}
	gbFind = TRUE;
	gbJustReplaced = FALSE;

	// we must not be in 'show target only' mode,
	// so if so, switch back to normal view mode
	if (gbShowTargetOnly)
	{
		OnToggleShowSourceText(event);
	}
	if (pApp->m_pFindDlg == NULL)
	{
		pApp->m_pFindDlg = new CFindDlg(pApp->GetMainFrame());

		// set default parameter values
		pApp->m_pFindDlg->m_srcStr = saveSrc;
		pApp->m_pFindDlg->m_tgtStr = saveTgt;
		pApp->m_pFindDlg->m_replaceStr.Empty();
		pApp->m_pFindDlg->m_marker = 0;
		pApp->m_pFindDlg->m_markerStr.Empty();
		pApp->m_pFindDlg->m_sfm.Empty();
		pApp->m_pFindDlg->m_bFindRetransln = FALSE;
		pApp->m_pFindDlg->m_bFindNullSrcPhrase = FALSE;
		pApp->m_pFindDlg->m_bFindSFM = FALSE;
		pApp->m_pFindDlg->m_bSrcOnly = TRUE;
		pApp->m_pFindDlg->m_bTgtOnly = FALSE;
		pApp->m_pFindDlg->m_bSrcAndTgt = FALSE;
		pApp->m_pFindDlg->m_bSpecialSearch = FALSE;
		pApp->m_pFindDlg->m_bFindDlg = TRUE;
		pApp->m_pFindDlg->m_bSpanSrcPhrases = FALSE;
		pApp->m_pFindDlg->m_bIncludePunct = FALSE;
		pApp->m_pFindDlg->m_bIgnoreCase = FALSE;
		//pApp->m_pFindDlg->TransferDataToWindow(); // no longer used

		pApp->m_pFindDlg->Centre(); // this sets the horizontal positioh,
				// AdjustDialogPosition below overrides the vertical one
		AdjustDialogPosition(pApp->m_pFindDlg);
		pApp->m_pFindDlg->Show(TRUE);
		gbFindOrReplaceCurrent = TRUE;
	}
	else
	{
		// BEW 27Mar21 - restore config values from the cache struct
		bool bRestoredValues = pApp->ReadFindCache();
		wxUnusedVar(bRestoredValues);
		/*
		// set default parameter values
		pApp->m_pFindDlg->m_srcStr = saveSrc;
		pApp->m_pFindDlg->m_tgtStr = saveTgt;
		pApp->m_pFindDlg->m_replaceStr.Empty();
		pApp->m_pFindDlg->m_marker = 0;
		pApp->m_pFindDlg->m_markerStr.Empty();
		pApp->m_pFindDlg->m_sfm.Empty();
		pApp->m_pFindDlg->m_bFindRetransln = FALSE;
		pApp->m_pFindDlg->m_bFindNullSrcPhrase = FALSE;
		pApp->m_pFindDlg->m_bFindSFM = FALSE;
		pApp->m_pFindDlg->m_bSrcOnly = TRUE;
		pApp->m_pFindDlg->m_bTgtOnly = FALSE;
		pApp->m_pFindDlg->m_bSrcAndTgt = FALSE;
		pApp->m_pFindDlg->m_bSpecialSearch = FALSE;
		pApp->m_pFindDlg->m_bFindDlg = TRUE;
		pApp->m_pFindDlg->m_bSpanSrcPhrases = FALSE;
		pApp->m_pFindDlg->m_bIncludePunct = FALSE;
		pApp->m_pFindDlg->m_bIgnoreCase = FALSE;
		//pApp->m_pFindDlg->TransferDataToWindow(); no longer used
		*/
		pApp->m_pFindDlg->Centre(); // this sets the horizontal position,
				// AdjustDialogPosition below overrides the vertical one
		AdjustDialogPosition(pApp->m_pFindDlg);
		wxLogDebug(_T("%s:%s() line %d, srcTextRadio %d , tgtTextRadio %d"),
			__FILE__, __FUNCTION__, __LINE__, (int)pApp->m_pFindDlg->m_pRadioSrcTextOnly->GetValue(),
			(int)pApp->m_pFindDlg->m_pRadioTransTextOnly->GetValue());

		//pApp->m_pFindDlg->Show(TRUE); // step in, this fouls up the radio button settings
		CFindDlg* pDlg = pApp->m_pFindDlg;
		CacheFindReplaceConfig* pStruct = &pApp->readwriteFindConfig;

		bool bSrcOnlyRadio = pApp->m_pFindDlg->m_pRadioSrcTextOnly->GetValue();
		bool bTgtOnlyRadio = pApp->m_pFindDlg->m_pRadioTransTextOnly->GetValue();
		bool bSrcTgtRadio = pApp->m_pFindDlg->m_pRadioBothSrcAndTransText->GetValue();
		pDlg->Show();

		if (bSrcOnlyRadio == TRUE)
		{
			wxString src = pDlg->m_pEditSrc->GetValue();
			wxString cachedSrc = pStruct->srcStr; // use this if values differ
			if (src != cachedSrc)
			{
				pDlg->m_pEditSrc->ChangeValue(cachedSrc); // source string is reset
			}
			pDlg->m_pEditSrc->SetFocus();
			pDlg->m_pEditTgt->Hide();

			// make the radio buttons comply
			wxRadioButton* pRadioSrc = pDlg->m_pRadioSrcTextOnly;
			bool bRadioSrc = pRadioSrc->GetValue();
			if (bRadioSrc != bSrcOnlyRadio) // LHS is current gui value, RHS is cache value
			{
				pRadioSrc->SetValue(bSrcOnlyRadio);
			}
			else
			{
				pRadioSrc->SetValue(TRUE);
			}
			// The other two must be opposite value, so set accordingly
			bool bOtherValue = !bSrcOnlyRadio;
			wxASSERT(bOtherValue == FALSE);
			wxRadioButton* pRadioTgt = pDlg->m_pRadioTransTextOnly;
			pRadioTgt->SetValue(bOtherValue); // FALSE
			wxRadioButton* pRadioSrcTgt = pDlg->m_pRadioBothSrcAndTransText;
			pRadioSrcTgt->SetValue(bOtherValue); // FALSE
		}
		else if (bTgtOnlyRadio == TRUE)
		{
			wxString tgt = pDlg->m_pEditTgt->GetValue();
			wxString cachedTgt = pStruct->tgtStr; // use this if values differ
			if (tgt != cachedTgt)
			{
				pDlg->m_pEditTgt->ChangeValue(cachedTgt); // transln string is reset
			}
			pDlg->m_pEditTgt->SetFocus();
			pDlg->m_pEditSrc->Hide();

			// make the radio buttons comply
			wxRadioButton* pRadioTgt = pDlg->m_pRadioTransTextOnly;
			bool bRadioTgt = pRadioTgt->GetValue();
			if (bRadioTgt != bTgtOnlyRadio) // LHS is current gui value, RHS is cache value
			{
				pRadioTgt->SetValue(bTgtOnlyRadio);
			}
			else
			{
				pRadioTgt->SetValue(TRUE);
			}
			// The other two must be opposite value, so set accordingly
			bool bOtherValue = !bTgtOnlyRadio;
			wxASSERT(bOtherValue == FALSE);
			wxRadioButton* pRadioSrc = pDlg->m_pRadioSrcTextOnly;
			pRadioSrc->SetValue(bOtherValue); // FALSE
			wxRadioButton* pRadioSrcTgt = pDlg->m_pRadioBothSrcAndTransText;
			pRadioSrcTgt->SetValue(bOtherValue); // FALSE
		}
		else if (bSrcTgtRadio == TRUE)
		{
			wxString src = pDlg->m_pEditSrc->GetValue();
			wxString tgt = pDlg->m_pEditTgt->GetValue();
			wxString srcCached = pStruct->srcStr;
			wxString tgtCached = pStruct->tgtStr;
			if (src != srcCached)
			{
				pDlg->m_pEditSrc->ChangeValue(srcCached); // source string is reset
			}
			if (tgt != tgtCached)
			{
				pDlg->m_pEditTgt->ChangeValue(tgtCached); // transln string is reset
			}
			pDlg->m_pEditTgt->SetFocus(); // put input focus here

			// make the radio buttons comply
			wxRadioButton* pRadioSrcTgt = pDlg->m_pRadioBothSrcAndTransText;
			bool bRadioSrcTgt = pRadioSrcTgt->GetValue();
			if (bRadioSrcTgt != bSrcTgtRadio) // LHS is current gui value, RHS is cache value
			{
				pRadioSrcTgt->SetValue(bSrcTgtRadio);
			}
			// The other two must be opposite value, so set accordingly
			bool bOtherValue = !bSrcTgtRadio;
			wxASSERT(bOtherValue == FALSE);
			wxRadioButton* pRadioSrc = pDlg->m_pRadioSrcTextOnly;
			pRadioSrc->SetValue(bOtherValue); // FALSE
			wxRadioButton* pRadioTgt = pDlg->m_pRadioTransTextOnly;
			pRadioTgt->SetValue(bOtherValue); // FALSE
		}
		// The checkboxes should be okay, as is; but ->Show(TRUE) cannot be used
		// as it uses wx code and that results in src radio button ticked even
		// when tgtOnly button was chosen, and tgtText then shows as srcText. Ouch!
		// Gotta find another way to get Ctrl+F to make the config window reappear
//#if defined( _DEBUG)
//		unsigned long findDlg = (unsigned int)pApp->m_pFindDlg;
//		unsigned long pdlg = (unsigned int)pDlg;
//		wxASSERT(findDlg == pdlg); // they are the same pointer
//#endif
		// BEW 30Mar21 I had a great (almost desparing) fight to get Ctrl+F to
		// (a) get the dialog to reappear when the user had switched to be in
		// the frame's layout of the doc, and (b) to reappear with the right
		// radio button still selected and the search text still present. The
		// Show(TRUE) command had to be done above, early, just after the
		// setting of the flags bSrcOnlyRadio, bTgtOnlyRadio, and  bSrcTgtRadio
		// above, was done. But Show() takes control into the base classes for
		// a dialog, and that results in reverting to src radio button wrongly
		// being active (assuming some other button was chosen, such as tgtOnly)
		// and therefore the search text being dumped in the possibly wrong text
		// control. What was needed was Show() to get the dialog to reappear,
		// and then subsequently, code to restore config values (as preserved in
		// in the caching struct, running that code, and then it still was not
		// enough. The final thing was to programmatically simulate the effect
		// of a user click on the radiobutton handler - that's what is done
		// in the code which follows here. Calling these On...() handlers gets
		// a Do....() function called, and following that, a call to the sizer
		// to have it rebuilt with the restored parameters. Took days to get
		// sequencing of all this right. Sigh:-(
		wxCommandEvent cmdDummyOnly; // a dummy
		if (bSrcOnlyRadio)
		{
			pDlg->OnRadioSrcOnly(cmdDummyOnly);
		}
		if (bTgtOnlyRadio)
		{
			pDlg->OnRadioTgtOnly(cmdDummyOnly); 
		}
		if (bSrcTgtRadio)
		{
			pDlg->OnRadioSrcAndTgt(cmdDummyOnly);
		}

		wxLogDebug(_T("%s:%s() line %d, srcTextRadio %d , tgtTextRadio %d"),
			__FILE__, __FUNCTION__, __LINE__, (int)pApp->m_pFindDlg->m_pRadioSrcTextOnly->GetValue(),
			(int)pApp->m_pFindDlg->m_pRadioTransTextOnly->GetValue());

		gbFindOrReplaceCurrent = TRUE;
	}
}

/////////////////////////////////////////////////////////////////////////////////
/// \return		nothing
/// \param      event   -> the wxUpdateUIEvent that is generated when the Tools Menu
///                        is about to be displayed
/// \remarks
/// Called from: The wxUpdateUIEvent mechanism when the associated menu item is selected,
/// and before the menu is displayed.
/// This handler disables the "Find..." item in the Tools menu if Vertical Editing is in
/// progress, or if the application is in Free Translation mode, or if there are no source
/// phrases in the App's m_pSourcePhrases list. Otherwise it enables the "Find..." item on
/// the Tools menu.
/////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItView::OnUpdateFind(wxUpdateUIEvent& event)
{
	if (gbVerticalEditInProgress)
	{
		event.Enable(FALSE);
		return;
	}
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	if (pApp->m_bFreeTranslationMode)
	{
		event.Enable(FALSE);
		return;
	}
	if (pApp->m_pSourcePhrases->GetCount() > 0)
		event.Enable(TRUE);
	else
		event.Enable(FALSE);
}

//#if defined(_KBSERVER)

void CAdapt_ItView::PositionDlgNearTop(wxDialog* pDlg)
{
	// Keep it within the CMainFrame bounds, but near it's top, and centered
	CAdapt_ItApp* pApp = &wxGetApp();
	int dlgWidth;
	int dlgHeight;
	pDlg->GetSize(&dlgWidth, &dlgHeight); // dialog's window; gets the width and height in pixels
	wxASSERT(dlgHeight > 0);

    // It doesn't look good if we use screen position, because the user may be on a large
    // screen and using a smallish frame window moved to the side, for Adapt It's frame
    // window. So find where the frame window is (in device coords), and do our
    // calculations relative to the screen position of the top left of the frame window
	CMainFrame* pFrame = pApp->GetMainFrame();
	wxRect frameRect;
	frameRect = pFrame->GetScreenRect();
	int frameHeight = frameRect.GetHeight();
	int frameWidth = frameRect.GetWidth();
	int frameTop = frameRect.y;
	int frameLeft = frameRect.x;

	int myTopCoord;
	if (frameHeight < 650)
	{
		myTopCoord = frameTop + 30;
	}
	else if (frameHeight < 850)
	{
		myTopCoord = frameTop + 36;
	}
	else if (frameHeight < 1100)
	{
		myTopCoord = frameTop + 40;
	}
	else
	{
		myTopCoord = frameTop + 44;
	}
	int myLeftCoord;
	myLeftCoord = frameLeft + frameWidth/2 - dlgWidth/2;

	pDlg->SetSize( // set size in device/screen pixels
		myLeftCoord, // position of left of dlg
		myTopCoord,  // position of top of dlg
		wxDefaultCoord, // use wxSIZE_USE_EXISTING with this param value for width
		wxDefaultCoord, // use wxSIZE_USE_EXISTING with this param value for height
		wxSIZE_USE_EXISTING);
}

// BEW 7Aapr16, the function is now a little misleading in its name. I've brought it up
// further and further to the left - now it's a little to the right of centre
void CAdapt_ItView::PositionDlgNearBottomRight(wxDialog* pDlg)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	CMainFrame* pFrame = pApp->GetMainFrame();

	int dlgWidth;
	int dlgHeight;
	pDlg->GetSize(&dlgWidth, &dlgHeight); // dialog's window; gets the width and height in pixels
	wxASSERT(dlgHeight > 0);

	wxRect frameRect;
	frameRect = pFrame->GetScreenRect();
	int frameHeight = frameRect.GetHeight();
	int frameWidth = frameRect.GetWidth();
	int frameTop = frameRect.y;
	int frameLeft = frameRect.x;

	int myTopCoord = frameTop + frameHeight; // near bottom of frame
	myTopCoord -= dlgHeight; // go back up a bit, allow for height of the dialog
	// And now raise it higher a tad more
	myTopCoord = myTopCoord - (frameHeight/4 +10);

	int myLeftCoord;
	//myLeftCoord = frameLeft + frameWidth - (dlgWidth + 30); // right is 30 pixels in from left of frame
	myLeftCoord = frameLeft + frameWidth/2 - (dlgWidth/2 + 40);

	pDlg->SetSize( // set size in device/screen pixels
		myLeftCoord, // position of left of dlg
		myTopCoord,  // position of top of dlg
		wxDefaultCoord, // use wxSIZE_USE_EXISTING with this param value for width
		wxDefaultCoord, // use wxSIZE_USE_EXISTING with this param value for height
		wxSIZE_USE_EXISTING);
}
//#endif

void CAdapt_ItView::AdjustDialogPosition(wxDialog* pDlg)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	CLayout* pLayout = GetLayout();
	wxASSERT(pApp != NULL);

	// place the dialog window so as not to obscure things
	// work out where to place the dialog window
	int nTwoLineDepth = 2 * pLayout->GetTgtTextHeight();
	wxPoint ptBoxTopLeft = pApp->m_pActivePile->GetCell(1)->GetTopLeft();
	wxRect rectScreen;

    // The wxWidgets docs say, "::wxClientDisplayRect() method returns the dimensions of
    // the work area on the display. On Windows this means the area not covered by the
    // taskbar, etc. Other platforms are currently defaulting to the whole display until a
    // way is found to provide this info for all window managers, etc."
    // Note: All calls that have no wxDC as a parameter deal in display device/pixels, and
    // MM_TEXT mapping mode, never in logical coordinates (or other mapping modes).
	//int displayX;
	//int displayY;
	//int displayWidth;
	//int displayHeight;

    // whm 9Apr2019 modified to do dialog position adjustments taking into 
    // consideration the resolution of the particular display on which AI is 
    // actually running on. That makes for a more accurate positioning of the 
    // dialog, especially when running on a secondary monitor that has a 
    // significantly smaller vertical resolution than the primary monitor.
    unsigned int mainFrmDisplayIndex = 0; // index 0 is the primary monitor, 1 and higher are secondary monitors
    // Detect which display index our AI main frame is displaying on
    mainFrmDisplayIndex = wxDisplay::GetFromWindow(pApp->GetMainFrame());
   
    unsigned int numMonitors;
    numMonitors = wxDisplay::GetCount();
    // whm 11Apr2019 added the following test to check whether mainFrmDisplayIndex is 
    // within the range of detected monitors. If it is a bad value it will generate a crash.
    // We can avoid the crash by checking for a bad mainFrmDisplayIndex value, and if so,
    // we just set some reasonable myTopCoord and myLeftCoord values that would center the 
    // dialog on the primary monitor.
    if (mainFrmDisplayIndex == wxNOT_FOUND || mainFrmDisplayIndex < 0 || mainFrmDisplayIndex >(numMonitors - 1))
    {
        // Couldn't determine a valid myMonitor value, so just put the dialog
        // centered on the primary monitor (index 0).
        unsigned int primaryDisplay = 0;
        wxDisplay thisDisplay(primaryDisplay);
        rectScreen = thisDisplay.GetClientArea();
        // Now get the dialog metrics - width and height
        // whm note: Best to use GetSize() rather than GetClientSize() when determining 
        // the rect of the dialog's window.
        wxRect rectDlg = pDlg->GetSize();
        rectDlg = NormalizeRect(rectDlg); // in case we ever change from MM_TEXT mode // use our own
        int dlgHeight = rectDlg.GetHeight();
        int dlgWidth = rectDlg.GetWidth();
        wxASSERT(dlgHeight > 0);
        int halfDisplayH, halfDisplayW, halfDlgH, halsDlgW, myTopCoord, myLeftCoord, x, y;
        x = 0;
        y = 0;
        halfDisplayH = rectScreen.GetHeight() / 2;
        halfDisplayW = rectScreen.GetWidth() / 2;
        halfDlgH = dlgHeight / 2;
        halsDlgW = dlgWidth / 2;
        myTopCoord = y + halfDisplayH - halfDlgH;
        myLeftCoord = x + halfDisplayW - halsDlgW;
        pDlg->SetSize(
            myLeftCoord, 
            myTopCoord,
            wxDefaultCoord, //300, // width, dummy value overridden by wxSIZE_USE_EXISTING below
            wxDefaultCoord, //200, // height, ditto
            wxSIZE_USE_EXISTING);
        wxLogDebug("MainFrm NOT VISIBLE on any monitor - placing dialog centered on primary monitor!");
        return;
    }
    
    wxASSERT(mainFrmDisplayIndex != wxNOT_FOUND); // if wxNOT_FOUND value -1 is returned the main frame is not displaying on any monitor
    // create an instance of wxDisplay for thisDisplay and get its rectScreen (may be primary or a secondary display)
    wxDisplay thisDisplay(mainFrmDisplayIndex);
    rectScreen = thisDisplay.GetClientArea();
    // The following old coding only gets the rectScreen of the primary monitor.
    // If the app is running on a secondary monitor, the wxRect size returned in
    // the ::wxClientDisplayRect() ref parameters does not accurately represent the 
    // secondary monitor's rectangular resolution. If it has significantly lower
    // resolution, this will skew the adjusted position placing the dialog partly 
    // or completely out of view on the monitor the dialog is displaying on.
	//::wxClientDisplayRect(&displayX,&displayY,&displayWidth,&displayHeight);
	// units for returned values from next call are in screen/device coords (pixels)
	//rectScreen = wxRect(displayX,displayY,displayWidth,displayHeight);
	wxClientDC dc(pApp->GetMainFrame()->canvas);
	canvas->DoPrepareDC(dc); //OnPrepareDC(&dc); // adjust origin

	// CalcScrolledPosition translates logical coordinates to device ones
	int newXPos, newYPos;
	pApp->GetMainFrame()->canvas->CalcScrolledPosition(ptBoxTopLeft.x,
										ptBoxTopLeft.y,&newXPos,&newYPos);
	ptBoxTopLeft.x = newXPos;
	ptBoxTopLeft.y = newYPos;

    // In the ClientToScreen call below the x and y coords are adjusted; in wxRect the
    // width and height remain unchanged, i.e., the rectangle retains the same size
    // dimensions, but the x and y coords change from (0,0) to a new (x,y) position for
    // the rectangle in relation to screen coords.
	pApp->GetMainFrame()->canvas->ClientToScreen(&ptBoxTopLeft.x,&ptBoxTopLeft.y);

	int height = nTwoLineDepth;
	int dlgWidth;
	int dlgHeight;
	wxASSERT(pDlg != NULL);
    // whm - for the dialog we should use GetSize, rather than GetClientSize as we want to
    // include the whole window
	pDlg->Centre(); // start with centered as default (for horizontal position especially)
	pDlg->GetSize(&dlgWidth,&dlgHeight); // dialog's window; gets the width and height in pixels
	wxASSERT(dlgHeight > 0);
    // wx note: displayWidth determined above (takes place of rectScreen.right -
    // rectScreen.left) below: because the actual width (before items are hidden) is much
    // greater than the displayed width, the following calculations place the dialog much
    // left of center. We won't bother setting the horizontal position.
    //
    // whm 9Apr2019 Note: The more important reason to retain the horizontal position
    // rather than using the ptBoxTopLeft.x value in width calculations here, is because
    // the ptBoxTopLeft.x value as determined by the ClientToScreen() call gives a horizontal
    // x-value based on the whole desktop - even when it represents the "screen" as it is 
    // extended across two monitors - either left or right of the monitor which is displaying 
    // the app's main frame window. Whereas the rectScreen value calculated above is based 
    // on just the display monitor which the app's main frame window is displaying on.
    // We note also that, although the ptBoxTopLeft.y vertical position in "screen coords" 
    // may also differ on a secondary monitor due to a different vertical resolution, the 
    // difference is not as great since the vertical resolution of most monitors doesn't 
    // differ a lot between higher and lower resolution monitors especially with the trend 
    // toward wide-screen monitors.
	if (ptBoxTopLeft.y + height < rectScreen.GetBottom() - 50 - dlgHeight)
	{
        // put dlg near the bottom of screen, or 30 pixels under the box's strip Roland
        // Fumey is reporting the Choose Translation dialog being shown above the client
        // area and so invisible, so my fix for 2.4.1f did not work, so try do something
        // here and send to Roland for evaluation (BEW changed, 12Jul05)
		int topAdjusted = wxMin(ptBoxTopLeft.y + height + 30,
								rectScreen.GetBottom()-dlgHeight-80);
		if (topAdjusted < rectScreen.GetTop())
			topAdjusted = rectScreen.GetBottom() - dlgHeight - 80;
		// WX Note: We'll use the wxWindow::SetSize() method
		pDlg->SetSize( // set size in device/screen pixels
			-1, //left,
			topAdjusted,
			wxDefaultCoord, //300, // width, dummy value overridden by wxSIZE_USE_EXISTING below
			wxDefaultCoord, //200, // height, ditto
			wxSIZE_USE_EXISTING);
	}
	else
	{
        // put dlg near the top of the screen, or if possible, 60 pixels above the strip
        // (version 2.4.0 altered this below from max(ptBoxTopLeft.y - dlgHeight - height -
        // 60, rectScreen.top+40) so that now we put the box 2 pixels down from the top of
        // the screen, to minimize the need to scroll or move the box because it may be
        // obscuring some of the automatically inserted text); BEW altered 09Sep05 for it
        // to be 100 pixels down from the screen top - even if it sometimes obscures some
        // inserted text, it is better to have a reasonable chance of not obscuring the
        // command bar buttons
		pDlg->SetSize(
			-1, //left,
			rectScreen.GetTop()+100,
			wxDefaultCoord, //300, // width, dummy value overridden by wxSIZE_USE_EXISTING below
			wxDefaultCoord, //200, // height, ditto
			wxSIZE_USE_EXISTING);
	}
	pDlg->Update();
}

void CAdapt_ItView::SetWhichBookPosition(wxDialog* pDlg)
{
	// WX NOTE: This is used only in WhichBook.cpp's InitDialog()
	int xPos,yPos;
	pDlg->GetPosition(&xPos,&yPos); // whatever position the OS assigns to it by default
	pDlg->Move(xPos,200); // use the xPos but move it down 200 pixels from top

	pDlg->Update();
}

void CAdapt_ItView::AdjustDialogPositionByClick(wxDialog* pDlg,wxPoint ptClick)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	CLayout* pLayout = GetLayout();

    // place the dialog window so as not to obscure things work out where to place the
    // dialog window; the passed in ptClick value comes from the saved point value for the
    // user's click in the client area of the view, and the coords for that point will be
    // device coords (ie. relative to top left of the client area of the view)

	// first calculate the height of two target text lines
	int height = 2 * pLayout->GetTgtTextHeight();

	// get the size of the screen - use screen coords
	wxRect rectScreen;
    // wx note: According to wx docs, wxGetClientDisplayRect() "returns the dimensions of
    // the work area on the display. On Windows this means the area not covered by the
    // taskbar, etc. Other platforms are currently defaulting to the whole display until a
    // way is found to provide this info for all window managers, etc."
    // whm 9Apr2019 modified to do dialog position adjustments taking into 
    // consideration the resolution of the particular display on which AI is 
    // actually running on. That makes for a more accurate positioning of the 
    // dialog, especially when running on a secondary monitor that has a 
    // significantly smaller vertical resolution than the primary monitor.
    unsigned int mainFrmDisplayIndex = 0; // index 0 is the primary monitor, 1 and higher are secondary monitors
                                          // Detect which display index our AI main frame is displaying on
    mainFrmDisplayIndex = wxDisplay::GetFromWindow(pApp->GetMainFrame());

    unsigned int numMonitors;
    numMonitors = wxDisplay::GetCount();
    // whm 11Apr2019 added the following test to check whether mainFrmDisplayIndex is 
    // within the range of detected monitors. If it is a bad value it will generate a crash.
    // We can avoid the crash by checking for a bad mainFrmDisplayIndex value, and if so,
    // we just set some reasonable myTopCoord and myLeftCoord values that would center the 
    // dialog on the primary monitor.
    if (mainFrmDisplayIndex == wxNOT_FOUND || mainFrmDisplayIndex < 0 || mainFrmDisplayIndex >(numMonitors - 1))
    {
        // Couldn't determine a valid myMonitor value, so just put the dialog
        // centered on the primary monitor (index 0).
        unsigned int primaryDisplay = 0;
        wxDisplay thisDisplay(primaryDisplay);
        rectScreen = thisDisplay.GetClientArea();
        // Now get the dialog metrics - width and height
        wxRect rectDlg = pDlg->GetSize();
        rectDlg = NormalizeRect(rectDlg); // in case we ever change from MM_TEXT mode // use our own
        int dlgHeight = rectDlg.GetHeight();
        int dlgWidth = rectDlg.GetWidth();
        wxASSERT(dlgHeight > 0);
        int halfDisplayH, halfDisplayW, halfDlgH, halsDlgW, myTopCoord, myLeftCoord, x, y;
        x = 0;
        y = 0;
        halfDisplayH = rectScreen.GetHeight() / 2;
        halfDisplayW = rectScreen.GetWidth() / 2;
        halfDlgH = dlgHeight / 2;
        halsDlgW = dlgWidth / 2;
        myTopCoord = y + halfDisplayH - halfDlgH;
        myLeftCoord = x + halfDisplayW - halsDlgW;
        pDlg->SetSize(
            myLeftCoord,
            myTopCoord,
            wxDefaultCoord, //300, // width, dummy value overridden by wxSIZE_USE_EXISTING below
            wxDefaultCoord, //200, // height, ditto
            wxSIZE_USE_EXISTING);
        wxLogDebug("MainFrm NOT VISIBLE on any monitor - placing dialog centered on primary monitor!");
        return;
    }

    wxASSERT(mainFrmDisplayIndex != wxNOT_FOUND); // if wxNOT_FOUND value -1 is returned the main frame is not displaying on any monitor
                                                  // create an instance of wxDisplay for thisDisplay and get its rectScreen (may be primary or a secondary display)
    wxDisplay thisDisplay(mainFrmDisplayIndex);
    rectScreen = thisDisplay.GetClientArea();
    // The following old coding only gets the rectScreen of the primary monitor.
    // If the app is running on a secondary monitor, the wxRect size returned in
    // the ::wxClientDisplayRect() ref parameters does not accurately represent the 
    // secondary monitor's rectangular resolution. If it has significantly lower
    // resolution, this will skew the adjusted position placing the dialog partly 
    // or completely out of view on the monitor the dialog is displaying on.
    //::wxClientDisplayRect(&displayX,&displayY,&displayWidth,&displayHeight);
    // units for returned values from next call are in screen/device coords (pixels)
    //rectScreen = wxGetClientDisplayRect();

	// we need to know where the view's client rect is located, in screen coords
	wxRect rectView;
    // wx note: calling GetClientSize on the canvas produced different results in wxGTK and
    // wxMSW, so I'll use my own GetCanvasClientSize() which calculates it from the main
    // frame's client size.
	wxSize canvasSize;
	canvasSize = pApp->GetMainFrame()->GetCanvasClientSize();
	rectView.width = canvasSize.x;
	rectView.height = canvasSize.y;

    // In the ClientToScreen call below the x and y coords are adjusted; in wxRect the
    // width and height remain unchanged, i.e., the rectangle retains the same size
    // dimensions, but the x and y coords change from (0,0) to a new (x,y) position for
    // the rectangle in relation to screen coords.
	pApp->GetMainFrame()->canvas->ClientToScreen(&rectView.x,&rectView.y);

	// we need to know the location and size of the dialog which is to have
	// its location adjusted
	wxRect rectDlg;
    // whm 11Apr2019 revised next call to use GetSize() rather than GetClientSize()
    // when determining the rect of the dialog's window.
    // pDlg->GetClientSize(&rectDlg.width, &rectDlg.height); // dialog's window
    pDlg->GetSize(&rectDlg.width, &rectDlg.height); // dialog's window
    rectDlg = NormalizeRect(rectDlg); // use our own from helpers.h
	int dlgHeight = rectDlg.GetHeight();
	int dlgWidth = rectDlg.GetWidth();
	wxASSERT(dlgHeight > 0);

    // whm 10Apr2019 added. Get an xOffset
    int xOffsetToSecondaryMonitor = 0; // default to no offset for single monitor calcs
    // Calculate an xOffsetToSecondaryMonitor if thisDisplay is not the primary display.
    if (!thisDisplay.IsPrimary())
    {
        // AI and its dialog is displaying on a secondary monitor, so get an xOffsetToSecondaryMonitor
        // value for use in myLeftCoord below.
        // The primary monitor is always the one having index 0, so get the primary monitor's
        // metrics.
        unsigned int primaryDisplayIndex = 0;
        wxDisplay primaryDisplay(primaryDisplayIndex);
        wxRect rectScreenPrimary = primaryDisplay.GetClientArea();
        xOffsetToSecondaryMonitor = rectScreenPrimary.GetWidth();
    }

    // determine how far from the left of the screen we will make the left side of the
    // dialog be so it is centered
	int left = (rectScreen.GetWidth() - dlgWidth)/2 + xOffsetToSecondaryMonitor; // whm 10Apr2019 added + xOffsetToSecondaryMonitor to calcs

    // put it above the click if there is enough screen real estate to fit it between the
    // command bar and a 1.5 linepair height values above the click's y coordinate; else
    // put it near the screen bottom, making sure it clears the status bar
	if (dlgHeight + ((height * 3) / 2) < ptClick.y)
	{
		pDlg->SetSize(left,rectView.GetTop() + 5,300,200,wxSIZE_USE_EXISTING);
	}
	else
	{
		pDlg->SetSize(left,rectScreen.GetBottom() - dlgHeight - 80,300,200,wxSIZE_USE_EXISTING);
	}
	pDlg->Update();
}

void CAdapt_ItView::OnReplace(wxCommandEvent& event)
{
	// refactored 17Apr09; next refactor - BEW 3Apr21
	CAdapt_ItApp* pApp = &wxGetApp();
	if (event.GetId() == wxID_REPLACE)
	{
		pApp->LogUserAction(_T("Initiated OnReplace()"));
	}
	//CLayout* pLayout = GetLayout();
	// check that a Find dialog is not currently open, if it is, delete it
	// preserving contents of the src & tgt edit boxes
	wxString saveSrc;
	saveSrc.Empty();
	wxString saveTgt;
	saveTgt.Empty();

	if (pApp->m_pReplaceDlg != NULL)
	{
		if (gbFind == TRUE)
		{
			//pApp->m_pReplaceDlg->TransferDataFromWindow(); // no longer used
			saveSrc = pApp->m_pReplaceDlg->m_srcStr;
			saveTgt = pApp->m_pReplaceDlg->m_tgtStr;
			pApp->m_pReplaceDlg->Destroy();
			pApp->m_pReplaceDlg = NULL;
		}
	}

	gbFind = FALSE; // make dialog appearance be for Find & Replace (m_bReplaceDlg later set TRUE too)
	gbJustReplaced = FALSE;

	// we must not be in 'show target only' mode, so if so, switch back to normal view mode
	if (gbShowTargetOnly)
	{
		OnToggleShowSourceText(event);
	}

	if (pApp->m_pReplaceDlg == NULL)
	{
		pApp->m_pReplaceDlg = new CReplaceDlg(pApp->GetMainFrame());

		gbJustReplaced = FALSE;

		// set default parameter values
		pApp->m_pReplaceDlg->m_srcStr = wxEmptyString;
		pApp->m_pReplaceDlg->m_tgtStr = wxEmptyString;
		pApp->m_pReplaceDlg->m_replaceStr.Empty();
		pApp->m_pReplaceDlg->m_bSrcOnly = FALSE; // we don't want default to be changing src text values
		pApp->m_pReplaceDlg->m_bTgtOnly = TRUE;
		pApp->m_pReplaceDlg->m_bFindDlg = FALSE;
		pApp->m_pReplaceDlg->m_bReplaceDlg = TRUE; // must be TRUE for find/replace
		// checkboxes start off unticked
		pApp->m_pReplaceDlg->m_bSpanSrcPhrases = FALSE;
		pApp->m_pReplaceDlg->m_bIncludePunct = FALSE;
		pApp->m_pReplaceDlg->m_bIgnoreCase = FALSE;

		pApp->m_pReplaceDlg->Centre(); // this sets the horizontal position
		// AdjustDialogPosition below overrides the vertical one
		AdjustDialogPosition(pApp->m_pReplaceDlg);

		pApp->m_pReplaceDlg->Show(TRUE); // We have to show it, but control wanders round in
			// wx basic resources,  which clobbers vital config values, so we have to restore
			// from what we set on the app above, and set the text boxes too
		CReplaceDlg* pDlg = pApp->m_pReplaceDlg; // easier to work with pDlg

		pDlg->m_pEditSrc_Rep->ChangeValue(pDlg->m_srcStr);
		pDlg->m_pEditTgt_Rep->ChangeValue(pDlg->m_tgtStr);
		pDlg->m_pEditReplace->ChangeValue(pDlg->m_replaceStr);

		pDlg->m_bFindDlg = FALSE;
		pDlg->m_bReplaceDlg = TRUE;

		// Turn off all 3 checkboxes if any are ticked
		bool bIsTicked = pDlg->m_pCheckSpanSrcPhrases->GetValue();
		if (bIsTicked)
		{
			pDlg->m_pCheckSpanSrcPhrases->SetValue(!bIsTicked);
		}
		bIsTicked = pDlg->m_pCheckIncludePunct->GetValue();
		if (bIsTicked)
		{
			pDlg->m_pCheckIncludePunct->SetValue(!bIsTicked);
		}
		bIsTicked = pDlg->m_pCheckIgnoreCase->GetValue();
		if (bIsTicked)
		{
			pDlg->m_pCheckIgnoreCase->SetValue(!bIsTicked);
		}

		gbFindOrReplaceCurrent = TRUE;
	}
	else
	{

		// Put ReadReplaceCache() here.....
		// BEW 6Apr21 Trying to do a replace in tgt text across multiple piles, is a bridge too far.
		// The pDlg->m_pCheckSpanSrcPhrases will be disabled for the m_pReplaceDlg instance

		bool bRestoredValues = pApp->ReadReplaceCache();
		wxUnusedVar(bRestoredValues);

		if (pApp->m_pReplaceDlg != NULL)
		{
			AdjustDialogPosition(pApp->m_pReplaceDlg);


			pApp->m_pReplaceDlg->Show(TRUE);
			gbFindOrReplaceCurrent = TRUE;
		}
		else
		{
			// wx doesn't need to call Create
			gbJustReplaced = FALSE;

			/* // BEW 6Apr21 we don't want to reset defaults, but rather to preserve the configuration
			// set default parameter values
			pApp->m_pReplaceDlg->m_srcStr = saveSrc;
			pApp->m_pReplaceDlg->m_tgtStr = saveTgt;
			pApp->m_pReplaceDlg->m_replaceStr.Empty();
			pApp->m_pReplaceDlg->m_markerStr.Empty();
			pApp->m_pReplaceDlg->m_sfm.Empty();
			pApp->m_pReplaceDlg->m_bSrcOnly = FALSE;
			pApp->m_pReplaceDlg->m_bTgtOnly = TRUE;
			pApp->m_pReplaceDlg->m_bSrcAndTgt = FALSE;
			pApp->m_pReplaceDlg->m_bFindDlg = FALSE;
			pApp->m_pReplaceDlg->m_bReplaceDlg = TRUE;
			pApp->m_pReplaceDlg->m_bSpanSrcPhrases = FALSE;
			pApp->m_pReplaceDlg->m_bIncludePunct = FALSE;
			pApp->m_pReplaceDlg->m_bIgnoreCase = FALSE;
			//pApp->m_pReplaceDlg->TransferDataToWindow();
			*/

			pApp->m_pReplaceDlg->Centre(); // this sets the horizontal position,
					// AdjustDialogPosition() below sets vertical position
			AdjustDialogPosition(pApp->m_pReplaceDlg);

			pApp->m_pReplaceDlg->Show(TRUE); // Necessary for getting the config dlg
						// shown, but this mucks up the config; so reset it from cache

			CReplaceDlg* pDlg = pApp->m_pReplaceDlg; // easier to work with pDlg
			CacheReplaceConfig* pStruct = &pApp->readwriteReplaceConfig;

			bool bSrcRadio = FALSE; // must be so
			bool bTgtRadio = TRUE; // must be so
			bool bReplaceBox = TRUE; // must be able to see the replace text in its box
			wxUnusedVar(bReplaceBox);

			// Check the restored settings agree, if not, reconfigure each as needed
			pDlg->m_pRadioSrcTextOnly->SetValue(bSrcRadio);
			pDlg->m_pRadioTransTextOnly->SetValue(bTgtRadio);

			// Now the text boxes
			pDlg->m_pEditSrc_Rep->SetValue(wxEmptyString); // must be empty for find/replace

			if (bTgtRadio == TRUE) // of course, it will be, but the redundancy is harmless
			{
				wxString tgt = pDlg->m_pEditTgt_Rep->GetValue();
				wxString cachedTgt = pStruct->tgtStr; // use this if values don't agree
				if (tgt != cachedTgt)
				{
					pDlg->m_pEditTgt_Rep->ChangeValue(cachedTgt);
				}
			}
			
			if (!pDlg->m_pEditReplace->IsEnabled())
			{
				pDlg->m_pEditReplace->Enable(TRUE);
				pDlg->m_pEditReplace->Show();
			}

			if (bReplaceBox)
			{
				wxString replaceStr = pDlg->m_pEditReplace->GetValue();
				wxString replaceCacheStr = pStruct->replaceStr; // use this if values don't match
				if (replaceStr != replaceCacheStr)
				{
					pDlg->m_pEditReplace->ChangeValue(replaceCacheStr);
				}
			}

			// Disable the pDlg->m_pCheckSpanSrcPhrases checkbox
			bool bIsSet = pDlg->m_pCheckSpanSrcPhrases->GetValue();
			if (bIsSet)
			{
				pDlg->m_bSpanSrcPhrases = FALSE;
				pDlg->m_pCheckSpanSrcPhrases->SetValue(FALSE); // force it to unticked
				// And disable it
				if (pDlg->m_pCheckSpanSrcPhrases->IsEnabled())
				{
					pDlg->m_pCheckSpanSrcPhrases->Disable();
				}
			}

			gbFindOrReplaceCurrent = TRUE;
		}
	}
}

/////////////////////////////////////////////////////////////////////////////////
/// \return		nothing
/// \param      event   -> the wxUpdateUIEvent that is generated when the Tools Menu
///                        is about to be displayed
/// \remarks
/// Called from: The wxUpdateUIEvent mechanism when the associated menu item is selected,
/// and before the menu is displayed. This handler disables the "Find And Replace..." item
/// in the Tools menu if Vertical Editing is in progress, or if the application is in Free
/// Translation mode, or if there are no source phrases in the App's m_pSourcePhrases list.
/// Otherwise it enables the "Find And Replace..." item on the Tools menu.
/////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItView::OnUpdateReplace(wxUpdateUIEvent& event)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);

	// whm added 26Mar12. Disable the Find and Replace menu item when in read-only mode.
	if (pApp->m_bReadOnlyAccess)
	{
		event.Enable(FALSE);
		return;
	}

	if (gbVerticalEditInProgress)
	{
		event.Enable(FALSE);
		return;
	}
	if (pApp->m_bFreeTranslationMode)
	{
		event.Enable(FALSE);
		return;
	}
	if (pApp->m_pSourcePhrases->GetCount() > 0)
		event.Enable(TRUE);
	else
		event.Enable(FALSE);
}

// All parameters relevant when glossing is OFF. When glossing is ON, the following
// applies: bIncludePunct and bSpanSrcPhrases will be FALSE, since the checkboxes
// for those flags are hidden; tgt parameter will hold, if relevant, text to be searched
// for in the m_gloss line; and nCount should never be anything except 1 when glossing.
// BEW 26Mar10, some changes needed for support of doc version 5
bool CAdapt_ItView::DoFindNext(int nCurSequNum, bool bIncludePunct, bool bSpanSrcPhrases,
						bool bSpecialSearch,bool bSrcOnly, bool bTgtOnly,
						bool bSrcAndTgt, bool bFindRetranslation, bool bFindNullSrcPhrase,
						bool bFindSFM, wxString& src, wxString& tgt, wxString& sfm,
						bool bIgnoreCase, int& nSequNum, int& nCount)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	if (gbIsGlossing)
	{
		wxASSERT(nCount == 1);;
	}
	wxASSERT(!(nCurSequNum > pApp->GetMaxIndex()));
	wxASSERT(pApp != NULL);
	CAdapt_ItDoc* pDoc = GetDocument();
	wxASSERT(pDoc != NULL);

    // if the targetBox is visible, store the contents in KB since we will advance the
    // active location to the pile having the text matched in the source phrase; and even
    // if there is no match, we want to do the save to KB before any bundle advances,
    // otherwise the old active location's pointer will be garbage & we'll crash if we try
    // to use it
	if (pApp->m_pTargetBox != NULL)
	{
		if (pApp->m_pTargetBox->IsShown())
		{
			if (!gbIsGlossing)
				MakeTargetStringIncludingPunctuation(pApp->m_pActivePile->GetSrcPhrase(),pApp->m_targetPhrase);
			if (!gbIsGlossing)
				RemovePunctuation(pDoc,&pApp->m_targetPhrase,from_target_text);

			// the store will fail if the user edited the entry out of the KB, as the latter
			// cannot know which srcPhrases will be affected, so these will still have their
			// m_bHasKBEntry set true. We have to test for this, ie. a null pRefString but
			// the above flag TRUE is a sufficient test, and if so, set the flag to FALSE
			// BEW modified 17Jul11 to use KB_Entry enum as the return value...
			CRefString* pRefStr = NULL;
			KB_Entry rsEntry;
			bool bOK;
			if (gbIsGlossing)
			{
				rsEntry = pApp->m_pGlossingKB->GetRefString(pApp->m_pActivePile->GetSrcPhrase()->m_nSrcWords,
							pApp->m_pActivePile->GetSrcPhrase()->m_key, pApp->m_targetPhrase, pRefStr);
				if ((pRefStr == NULL || rsEntry == present_but_deleted) &&
					pApp->m_pActivePile->GetSrcPhrase()->m_bHasGlossingKBEntry)
				{
					pApp->m_pActivePile->GetSrcPhrase()->m_bHasGlossingKBEntry = FALSE;
				}
				// now do the store
				bOK = pApp->m_pGlossingKB->StoreText(pApp->m_pActivePile->GetSrcPhrase(),
									pApp->m_targetPhrase);
			}
			else
			{
				rsEntry = pApp->m_pKB->GetRefString(pApp->m_pActivePile->GetSrcPhrase()->m_nSrcWords,
							pApp->m_pActivePile->GetSrcPhrase()->m_key, pApp->m_targetPhrase, pRefStr);
				if ((pRefStr == NULL || rsEntry == present_but_deleted) &&
					pApp->m_pActivePile->GetSrcPhrase()->m_bHasKBEntry)
				{
					pApp->m_pActivePile->GetSrcPhrase()->m_bHasKBEntry = FALSE;
				}
				// now do the store
                //pApp->m_bInhibitMakeTargetStringCall = TRUE;
				bOK = pApp->m_pKB->StoreText(pApp->m_pActivePile->GetSrcPhrase(),
									pApp->m_targetPhrase);
                pApp->m_bInhibitMakeTargetStringCall = FALSE;
			}
			bOK = bOK; // avoid warning
			// now get rid of the phrase box, until we need it again
            pApp->m_pTargetBox->HidePhraseBox(); // hides all three parts of the new phrasebox

            pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(_T("")); // need to set it to null str
													 // since it won't get recreated
			pApp->m_targetPhrase.Empty(); // the box will move on, so this old
										  // location is now invalid
		}
	}

	if (nCurSequNum == pApp->GetMaxIndex() || nCurSequNum == -1)
		return FALSE; // we are at the end, so cannot search further
					  // (we won't wrap the search)
	if (bSpecialSearch)
	{
		bool bFound;

		// a special search is wanted
		if (bFindRetranslation)
		{
			bFound = pApp->GetRetranslation()->DoFindRetranslation(nCurSequNum+1,nSequNum,nCount);
		}
		else if (bFindNullSrcPhrase)
		{
			bFound = DoFindNullSrcPhrase(nCurSequNum+1,nSequNum,nCount);
		}
		else
		{
			// must want to find a standard format marker
			if (bFindSFM != TRUE)
			{
				::wxBell();
				wxASSERT(FALSE);
			}
			// the following function had changes for support of doc version 5
			bFound = DoFindSFM(sfm,nCurSequNum+1,nSequNum,nCount);
		}
		if (!bFound)
		{
			// clear the globals
			pApp->m_bMatchedRetranslation = FALSE;
			gnRetransEndSequNum = -1;
			::wxBell(); // alert user there was no match
			Invalidate();
			GetLayout()->PlaceBox();
			return FALSE;
		}
		else
		{
			if (gbIsGlossing)
			{
				wxASSERT(nCount == 1);
			}
			// BEW changed 3Aug09 to always have the selection display be on the source
			// text line for Find Next - this makes the interface more consistent
			int nSelLineIndex = 0;

			// make the appropriate selection... recalc of layout not wanted yet (that's
			// the meaning of FALSE param in the call), MakeSelectionForFind()
			// automatically refrains from putting the active location at the match point
			// if the app boolean flag m_bMatchedRetranslation is TRUE
			MakeSelectionForFind(nSequNum,nCount,nSelLineIndex, FALSE);

			// update the active sequ number, only if not matching text in a pile of a
			// retranslation (because we can't put the phrase box at such a pile)
			if (!pApp->m_bMatchedRetranslation)
				pApp->m_nActiveSequNum = nSequNum;
			return TRUE;
		}
	}
	else
	{
		// not a special search, just a normal one
		bool bFound;
		//bool bInSrc = TRUE; // set but not used

        // if we previously matched a retranslation, we have to advance to its end before
        // we can continue searching for a new match; but if glossing is ON, retranslations
        // are irrelevant, so we would skip the block in that case
		if (!gbIsGlossing && pApp->m_bMatchedRetranslation)
		{
			wxASSERT(gnRetransEndSequNum >= 0);
			nCurSequNum = gnRetransEndSequNum;
			pApp->m_bMatchedRetranslation = FALSE;
			gnRetransEndSequNum = -1;
		}

		// a normal type of search is wanted & the following functions search in
		// m_pSourcePhrases list
		if (bSrcOnly)
		{
			// search only in m_srcPhrase field or m_key field, depending on bIncludePunct
			// flag value
			bFound = DoSrcOnlyFind(nCurSequNum+1,bIncludePunct,bSpanSrcPhrases,src,
									bIgnoreCase,nSequNum,nCount);
		}
		else if (bTgtOnly)
		{
			// search only in m_targetStr field or m_adaption field
			bFound = DoTgtOnlyFind(nCurSequNum+1,bIncludePunct,bSpanSrcPhrases,tgt,
									bIgnoreCase,nSequNum,nCount);
			//bInSrc = FALSE;
		}
		else
		{
			// search both m_srcPhrase and m_targetStr fields, trying to match both
			if (bSrcAndTgt != TRUE)
			{
				::wxBell();
				wxASSERT(FALSE);
			}
			bFound = DoSrcAndTgtFind(nCurSequNum+1,bIncludePunct,bSpanSrcPhrases,src,tgt,
									bIgnoreCase,nSequNum,nCount);
			//bInSrc = FALSE;
		}
		if (!bFound)
		{
			// clear the globals
			pApp->m_bMatchedRetranslation = FALSE;
			gnRetransEndSequNum = -1;
			::wxBell(); // alert user there was no match
			Invalidate();
			GetLayout()->PlaceBox();
			return FALSE;
		}
		else
		{
			// found a matching string, in the srcPhrase with sequ num nSequNum
			FindNextHasLanded(nSequNum); // bSuppressSelectionExtention is default TRUE
										 // because SelectFoundSrcPhrases() will do it
			if (gbIsGlossing)
			{
				wxASSERT(nCount == 1);
			}
			// BEW changed 3Aug09 to always have the selection display be on the source
			// text line for Find Next - this makes the interface more consistent
			int nSelLineIndex = 0;

			// make the appropriate selection... recalc of layout not wanted yet (that's
			// the meaning of FALSE param in the call), MakeSelectionForFind()
			// automatically refrains from putting the active location at the match point
			// if the app boolean flag m_bMatchedRetranslation is TRUE
			MakeSelectionForFind(nSequNum,nCount,nSelLineIndex, FALSE);

			// update the active sequ number, only if not matching text in a pile of a
			// retranslation (because we can't put the phrase box at such a pile)
			if (!pApp->m_bMatchedRetranslation)
			{
				pApp->m_nActiveSequNum = nSequNum;

				// BEW addition 4Sep15. If landing at a pile where m_bNotInKB is TRUE, the
				// Save To Knowledge Base checkbox should be unticked, but won't be. So here
				// we must get the pSrcPhrase value of the m_bNotInKB, set to opposite value,
				// then call view class's OnCheckKBSave() passing in a dummy wxCommandEvent
				// to get the checkbox to be in sync with the CSourcePhrase instance's setting
				CPile* pPile = GetPile(nSequNum);
				CSourcePhrase* pSrcPhrase = pPile->GetSrcPhrase();
				if (pSrcPhrase->m_bNotInKB)
				{
					// It's a pile with an asterisk above, indicating there is no value in KB
					// for this pile's source text; make the checkbox agree
					CMainFrame* pFrame = pApp->GetMainFrame();
					wxPanel* pPanel = pFrame->m_pControlBar;
					// ensure the Save To Knowledge Base checkbox is in sync
					wxCheckBox* pKBSave = (wxCheckBox*)pFrame->FindWindowById(IDC_CHECK_KB_SAVE);
					bool bTicked = pKBSave->GetValue();
					if (bTicked)
					{
						// The checkbox is out of sync, so fix it
						pApp->m_bSaveToKB = TRUE; // this is the opposite of the value we want
						wxCommandEvent dummyEvent; // anything command event will do
						OnCheckKBSave(dummyEvent); // this gets the sync done
					}
					pPanel->Refresh(); // make sure the change is visible
				}
			}
			return TRUE;
		}
	}
}


// finds only those null src phases (ie. placeholders) which are not within a retranslation
// for padding purposes; the search is also allowed when glossing is ON
// BEW 26Mar10, no changes needed for support of doc version 5
bool CAdapt_ItView::DoFindNullSrcPhrase(int nStartSequNum, int& nSequNum, int& nCount)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	SPList* pList = pApp->m_pSourcePhrases;
	wxASSERT(pList != NULL);
	SPList::Node* pos_pList = pList->Item(nStartSequNum); // starting position
	wxASSERT(pos_pList != NULL);
	int sn = nStartSequNum;
	CSourcePhrase* pSrcPhrase = NULL;

	while (pos_pList != NULL)
	{
		pSrcPhrase = (CSourcePhrase*)pos_pList->GetData();
		pos_pList = pos_pList->GetNext();
		wxASSERT(pSrcPhrase != NULL);
		if (pSrcPhrase->m_bNullSourcePhrase && !pSrcPhrase->m_bRetranslation)
		{
			// we found a null source phrase (exclude those which may be in a retranslation)
			nSequNum = sn;
			nCount = 1;
			return TRUE;
		}
		else
		{
			sn++; // index for next CSourcePhrase instance to be searched
		}
	}

	// if we get here, we didn't find a match
	return FALSE;
}

// BEW 26Mar10, no changes needed for support of doc version 5
bool CAdapt_ItView::IsSameMarker(int str1Len, int nFirstChar, const wxString& str1,
								 const wxString& testStr)
{
	wxASSERT(str1.Length() > 1);
	wxString extracted = testStr.Mid(nFirstChar,str1Len);

    // if the testStr has a marker which has the str1 marker in it as a substring, we have
    // to extend the "extracted" string, otherwise we will end up returning a TRUE value
    // incorrectly
	int nNext = nFirstChar + str1Len;
	int totalLen = testStr.Length();

	wxChar c;
    // while we are not beyond the textStr bounds, and the character at the nNext offset is
    // not a space character, add the next character to the extracted marker stub, and
    // iterate until the whole marker is built
	while ( nNext < totalLen && (c = testStr.GetChar(nNext)) != _T(' '))
	{
		extracted += c;
		nNext++;
	}

	if ((int)extracted.Length() < str1Len)
		return FALSE; // can't be the same, since it's shorter
	return (extracted == str1);
}

// we allow this search when glossing or when adapting
// BEW 26Mar10, some changes needed for support of doc version 5
bool CAdapt_ItView::DoFindSFM(wxString& sfm, int nStartSequNum, int& nSequNum, int& nCount)
{
	// nCount just returns how many were found, this is a bit of a white elephant as we
	// only ever find one instance at a time, so just return 1
	CAdapt_ItApp* pApp = &wxGetApp();
	SPList* pList = pApp->m_pSourcePhrases;
	wxASSERT(pList != NULL);
	SPList::Node* pos_pList = pList->Item(nStartSequNum); // starting position
	wxASSERT(pos_pList != NULL);
	int sn = nStartSequNum;
	CSourcePhrase* pSrcPhrase = NULL;
	int len = sfm.Length();
	wxString freeTransMkr = _T("\\free");
	wxString noteMkr = _T("\\note");
	wxString backTransMkr = _T("\\bt");

	int nFound = -1; // assume not found
	while (pos_pList != NULL)
	{
		pSrcPhrase = (CSourcePhrase*)pos_pList->GetData();
		pos_pList = pos_pList->GetNext();
		wxASSERT(pSrcPhrase != NULL);

		// For doc version 5, we don't actually have \free, \free*, \note, \note*, nor \bt
		// markers actually stored with the content of free translations, notes, or
		// collected back translations. The list which the user saw lists the \free,
		// \note, and \bt as findable markers - but the list was populated from
		// AI_USFM.xml, and we are keeping our custom markers in that file. We'll trick
		// the user - he or she doesn't need to know that in the data model for version
		// these data types are stored in wxString members with name m_freeTrans, m_note,
		// and m_collectedBackTrans, and hence our GUI stuff will show the markers, but
		// our search will actually check for non-empty member strings as above. Also, our
		// filtered markers are now stored in m_filteredInfo, not m_markers, and so we'll
		// also have to search in there too. We'll do these searches before we hand over
		// to the legacy code which just checks the m_markers member. (When checking the
		// wxString members for non-empty content, we don't need to make the call to
		// IsSameMarker(), as there is no possibility of a spurious 'find'.)
		if (sfm == freeTransMkr)
		{
			if (!pSrcPhrase->GetFreeTrans().IsEmpty())
			{
#ifdef _DEBUG
#ifdef FINDNXT
				//wxLogDebug(_T("Found free translation: at sn = %d  word is:  %s"),sn,pSrcPhrase->m_srcPhrase);
#endif
#endif
				// found location where a free translation commences
				nSequNum = sn;
				nCount = 1;
				return TRUE;
			}
		}
		if (sfm == noteMkr)
		{
			if (!pSrcPhrase->GetNote().IsEmpty())
			{
				// found location where a note is stored
#ifdef _DEBUG
#ifdef FINDNXT
				//wxLogDebug(_T("Found note: at sn = %d  word is:  %s"),sn,pSrcPhrase->m_srcPhrase);
#endif
#endif
				nSequNum = sn;
				nCount = 1;
				return TRUE;
			}
		}
		wxString filteredInfo = pSrcPhrase->GetFilteredInfo();
		if (sfm == backTransMkr)
		{
			if (!pSrcPhrase->GetCollectedBackTrans().IsEmpty())
			{
#ifdef _DEBUG
#ifdef FINDNXT
				//wxLogDebug(_T("Found back trans: at sn = %d  word is:  %s"),sn,pSrcPhrase->m_srcPhrase);
#endif
#endif
				// found location where a collected back translation is stored
				nSequNum = sn;
				nCount = 1;
				return TRUE;
			}
			else
			{
				// We have to search also for a \bt-derived marker - any of these would be
				// stored in the m_filteredInfo member, each wrapped with \~FILTER and
				// \~FILTER* filter markers. So we'll have to search.
				if (!filteredInfo.IsEmpty())
				{
					nFound = filteredInfo.Find(sfm); // we search just for \bt because we
													 // don't know what the inventory of
													 // such custom markers might be - eg.
													 // \btv \bth and so forth
					if (nFound >= 0)
					{
#ifdef _DEBUG
#ifdef FINDNXT
						//wxLogDebug(_T("Found bt-derived marker in m_filteredInfo: at sn = %d  word is:  %s"),sn,pSrcPhrase->m_srcPhrase);
#endif
#endif
						// we'll make the reasonable assumption that the marker will not
						// be in any content string for some other marker, and so not try
						// test for this - we just assume we've found one
						nSequNum = sn;
						nCount = 1;
						return TRUE;
					}
				}
			}
		}
		else
		{
            // if control gets to here, we know we have not located a \free, \note, \bt nor
            // \bt-derived marker, so all that remains is to check any other marker passed
            // in. We must here check if the passed in marker occurs in the filteredInfo
            // string. If it does, we handle it like the legacy code below (ie. call
            // IsSameMarker() etc), but if we don't match anything, then only m_markers
            // remains to be checked, and we can leave that for the legacy code further
            // below
			if (!filteredInfo.IsEmpty())
			{
				nFound = filteredInfo.Find(sfm);
				if (nFound >= 0)
				{
                    // we can assume m_filteredInfo does not have two markers one of which
                    // is a substring of the other (if that was the case, and the longer
                    // was first and we were looking for the shorter, we'd never find the
                    // shorter one with the following code)
					bool bSame = IsSameMarker(len,nFound,sfm,filteredInfo);
					if (bSame)
					{
#ifdef _DEBUG
#ifdef FINDNXT
						//wxLogDebug(_T("Found chosen filterable marker in m_filteredInfo: at sn = %d  word is:  %s"),sn,pSrcPhrase->m_srcPhrase);
#endif
#endif
						// we found a matching standard format marker
						nSequNum = sn;
						nCount = 1;
						return TRUE;
					}
				}
			}
		}

		// this is the legacy code, before doc version 5; if control reaches here, no
		// target marker has been matched yet, so we check for it in m_markers
		nFound = pSrcPhrase->m_markers.Find(sfm); // nFound is index of first
												  // char of matched str
		if (nFound >= 0)
		{
            // we can assume m_markers does not have two markers one of which is a
            // substring of the other (if that was the case, and the longer was first and
            // we were looking for the shorter, we'd never find the shorter one with the
            // following code)
			bool bSame = IsSameMarker(len,nFound,sfm,pSrcPhrase->m_markers);
			if (!bSame)
			{
				nFound = -1;
				goto b;
			}
			else
			{
#ifdef _DEBUG
#ifdef FINDNXT
				//wxLogDebug(_T("Found the chosen marker in m_markers: at sn = %d  word is:  %s"),sn,pSrcPhrase->m_srcPhrase);
#endif
#endif
				// we found a matching standard format marker in m_markers
				nSequNum = sn;
				nCount = 1;
				return TRUE;
			}
		}
		else
		{
b:			if (pSrcPhrase->m_nSrcWords > 1)
			{
				// there could be medial markers in the phrase, so check it out
				if (!pSrcPhrase->m_pMedialMarkers->IsEmpty())
				{
					wxArrayString* pSL = pSrcPhrase->m_pMedialMarkers;
					int ct;
					for (ct = 0; ct < (int)pSL->GetCount(); ct++)
					{
						wxString markers = pSL->Item(ct);
						nFound = markers.Find(sfm);
						if (nFound >= 0)
						{
							bool bSame = IsSameMarker(len,nFound,sfm,markers);
							if (bSame)
							{
#ifdef _DEBUG
#ifdef FINDNXT
								//wxLogDebug(_T("Found the marker among medial markers: at sn = %d  word is:  %s"),sn,pSrcPhrase->m_srcPhrase);
#endif
#endif
								// we found a matching standard format marker,in the
								// stored medial markers for a merger
								nSequNum = sn;
								nCount = 1;
								return TRUE;
							}
							else
							{
								nFound = -1;
							}
						}
					}
				}
			}
		} // end else block for last nFound >= 0 test
		sn++; // increment index for next CSourcePhrase instance to be searched
	} // end of loop

	// if we get here, we didn't find a match
	return FALSE;
}

void CAdapt_ItView::DeleteTempList(SPList* pList)
{
	// BEW refactor 13Mar09, do nothing here, these are temporary incomplete ones,
	// no partner piles
	SPList::Node* p;
	if (pList->IsEmpty())
	{
		if (pList != NULL) // whm 11Jun12 added NULL test
			delete pList;
		pList = (SPList*)NULL;
		return;
	}
	p = pList->GetFirst();
	while (p != 0)
	{
		CSourcePhrase* pSP = (CSourcePhrase*)p->GetData();
		p = p->GetNext();
		if (pSP->m_pMedialMarkers != NULL) // whm 11Jun12 added NULL test
			delete pSP->m_pMedialMarkers;
		pSP->m_pMedialMarkers = (wxArrayString*)NULL;
		if (pSP->m_pMedialPuncts != NULL) // whm 11Jun12 added NULL test
			delete pSP->m_pMedialPuncts;
		pSP->m_pMedialPuncts = (wxArrayString*)NULL;
		if (pSP->m_pSavedWords != NULL) // whm 11Jun12 added NULL test
			delete pSP->m_pSavedWords;
		pSP->m_pSavedWords = (SPList*)NULL;
		if (pSP != NULL) // whm 11Jun12 added NULL test
			delete pSP;
		pSP = (CSourcePhrase*)NULL;
	}
	pList->Clear();
	if (pList != NULL) // whm 11Jun12 added NULL test
		delete pList;
	pList = (SPList*)NULL;
}

// when IsMatchedToEnd is called, it will be the case that we are trying to match less than
// the whole of the user's typed search string, and we will be doing the test for the match
// only in the text supplied from the first source phrase of a potential multi-sourcePhrase
// match. In the first srcPhrse, we have no way of knowing how many of the user's first
// typed words will be able to match, so we have to test all possibilities - in the caller,
// an nIteration variable keeps track of which attempt we are making, each iteration tests
// a string one word shorter than the one tested earlier in the last call to
// IsMatchedToEnd(). However, any match within IsMatchedToEnd is not valid unless the last
// matched character is also the very last character of the strTarget string. The reason
// for this is that since there is more to be matched in a later sourcePhrase, we cannot
// allow a discontinuity between what is matched in the current one, and any potential
// match in the next one. So IsMatchedToEnd looks specifically for a match which is
// coextensive with the end of the strTarget string; returns the offset to the first
// matched character if it finds such a match, or -1 otherwise (mimicking CString's Find()
// function)
// BEW 26Mar10, no changes needed for support of doc version 5
int CAdapt_ItView::IsMatchedToEnd(wxString& strSearch, wxString& strTarget)
{
	int nTargetLen = strTarget.Length();
	int nSearchLen = strSearch.Length();
	int nFirstChar = -1;
	int nStart = 0;
a:	nFirstChar = FindFromPos(strTarget,strSearch,nStart);
	if (nFirstChar == -1)
	{
		// no match
		return -1;
	}
	else
	{
		// got a match, check it out
		if (nFirstChar + nSearchLen == nTargetLen)
		{
			// it matches up to the end, so we have a successful match
			return nFirstChar;
		}
		else
		{
			// not coextensive with the end, so see if we can get a match
			// later in the string
			nStart = ++nFirstChar;
			goto a;
		}
	}
}

// selector = 0 means, a src only search
// selector = 1 means, a tgt only search
// pList is a pointer to the list of CSourcePhrase instances in the document's
// m_pSourcePhrases member, pTempList holds a temporary list created in the caller, of
// pSrcPhrase instances which are the result of parsing src string using TokenizeText()
// function - we use these to construct search strings which we wish to match within the
// appropriate members of each pSrcPhrase in the pList, starting from the location pos_callers
// If glossing is ON, this should never get called.
//
/////////////////////////////////////////////////////////////////////////////////
/// \return		TRUE if an extended match was made, FALSE if not
/// \param      selector    ->  0 means, a src search, 1 means a tgt search
/// \param      pos_callers ->  iterator through the list of CSourcePhrase instances in
///                             the application's m_pSourcePhrases member; if selector is
///                             0, the tests for matches will be done in the m_key or
///                             m_srcPhrase members of CSourcePhrase instances from that
///                             list; if selector = 1, the tests for matches will be done
///                             in the m_adaption or m_targetStr members, depending on the
///                             bIncludePunct value passed in
/// \param      pDoc        ->  pointer to CAdapt_ItDoc class, needed for accessing
///                             TokenizeText() function
/// \param      pTempList   ->  pointer to a temporary list created in the caller, of
///                             pSrcPhrase instances which are the result of parsing src
///                             string using TokenizeText() function - we use these to
///                             construct search strings which we wish to match within the
///                             appropriate members of each pSrcPhrase in the pList,
///                             starting from the location pos_callers
/// \param      nElements   ->  the number of elements in pTempList. If matching across
///                             multiple piles, nElements will be greater than 1; or if
///                             matching even a single word but the "unit" to be searched
///                             is a retranslation's target text (since we treat
///                             retranslations as a whole), nElements can be 1 but still
///                             require extended matching by this function because there
///                             may be more than one pile in the retranslation
/// \param      bIncludePunct -> if TRUE, uses m_srcPhrase for tests in src, m_targetStr
///                             for tests in tgt. Otherwise, m_key & m_adaption, respectively
/// \param      bIgnoreCase ->  Default is FALSE in caller, if TRUE passed in, strings are
///                             reset to lower case before testing for a match
/// \param      nCount      ->  a count of how many words are to be matched (note, the
///                             function is required even when nCount is 1 if the source
///                             text matched within a retranslation)
/// \remarks
/// Used for matching several words across more than one pile, or matching within a
/// retranslation. In the case of a retranslation, the matching, if source and target text
/// matches are required, does not have to be for piles vertically aligned; so for
/// retranslations a single source text word may match at one point in the retranslation
/// but the target text line might match at a different pile within the retranslation,
/// because we consider retranslations a textual "unit", and so when that is the case, a
/// TRUE value would be returned.
/// This is a complex function, BEWARE.
/// If glossing is ON, this function should never get called.
// BEW 26Mar10, no changes needed for support of doc version 5
// BEW 21Jul14, refactored for support of ZWSP (4 places had PutSrcWordBreak() used)
/////////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItView::DoExtendedSearch(int			selector,
									 SPList::Node*&	pos_callers,
									 CAdapt_ItDoc*	pDoc,
									 SPList*		pTempList,
									 int			nElements,
									 bool			bIncludePunct,
                                     bool			bIgnoreCase,
									 int&			nCount)
{
	wxASSERT(!gbIsGlossing);
	SPList::Node* pos_search = pos_callers;  // local copy to use in iterations
	SPList::Node* pos_pTempList = NULL; // position within the pTempList
	bool bFirstOnly = TRUE; // true when we are dealing with the first of a
			// possible string of srcPhrases in the m_pSourcePhrases list of pDoc
	int nTotal = nElements; // number of words (ie. elements in pTempList)
							// in search string
	wxString strConstruct;	// we construct strings in this, in which to search
							// for a match using src
	strConstruct.Empty();
	nCount = 0; // count of how many m_pSourcePhrases elements were used in
				// making the match, garbage if no match
	int bFirstAttempt = TRUE; // used when making first attempt at a match - the
                // first matching character does not have to be at the start of the string
                // being searched in this instance, but subsequent matches must match
                // exactly from the start
	wxString strSearchTarget; // we search in this string for a match
	strSearchTarget.Empty();
	CSourcePhrase* pSrcPhrase = NULL; // a source phase in doc's m_pSourcePhrases list
	CSourcePhrase* pSP = NULL; // a source phrase in the tokenized pTempList,
							   // from which we build search strings
	int nTargetLength = 0;
	int nSearchLength = 0;
	int nAddParts= 0;
	int nFound = -1;
	int nWordCount = 0;
	int count = 0;
	int nIteration = 0; // iteration number for the try in first source phrase,
                        // starting with longest & decreasing by one word per iteration
	int nLimit = 0; // max number of search words which can be constructed in strConstruct for
					// matching in the strSearchTarget string built from the current pSrcPhrase
					// in the loop
	if (pos_callers == 0)
		return FALSE;
	switch (selector)
	{
	case 0: // source only
	{
		while (pos_search != NULL)
		{
			pSrcPhrase = (CSourcePhrase*)pos_search->GetData();
			pos_search = pos_search->GetNext();
			wxASSERT(pSrcPhrase != NULL);
			nWordCount = pSrcPhrase->m_nSrcWords;
			nLimit = wxMin(nTotal, nWordCount);
			nCount++; // count this source phrase (it could have more than
					  // one word in its m_key or m_srcPhrase)
			if (bFirstOnly)
			{
				bFirstOnly = FALSE;
				pos_callers = pos_search; // we need to return only this one, because the caller
							// needs to know when the end of pList has been reached, so
							// that the caller's loop can be exited cleanly
			}
			else
			{
				nIteration = 0; // no iterations allowed for src phrases
								// other than the first
			}
			if (pSrcPhrase->m_bNullSourcePhrase)
			{
				if (nCount == 1)
					return FALSE; // if first is a null source phrase,
								  // cause progression to next
				else
				{
					// not the first srcPhrase, so just skip it
					continue;
				}
			}

			// compute strSearchTarget
			if (bIncludePunct)
			{
				strSearchTarget = pSrcPhrase->m_srcPhrase;
			}
			else
			{
				strSearchTarget = pSrcPhrase->m_key;
			}
			if (bIgnoreCase)
				strSearchTarget.MakeLower();

			// how many iterations left to be tried, for the first phrase
		a:			if (nCount == 1)
		{
			nTotal = nElements; // reset, for each iteration
			nIteration++;  // which iteration within the nCount == 1 loop are we on
			nLimit = wxMin(nTotal, nWordCount) - nIteration + 1;
		}
		else
			nLimit = wxMin(nTotal, nWordCount);

		if (nIteration > wxMin(nTotal, nWordCount))
			return FALSE; // couldn't make a match in the first source phrase,
						  // and the rest match also

		// we use nWordCount together with pTempList data in order to build a
		// strConstruct which has nWordCount words in it - either with or without
		// punctuation depending on the bIncludePunct value, (or there can be less than
		// nWordCount words, if the search string is short enough); then for each
		// nIterations decrement, try building one word less each time (provided no
		// earlier iteration produced a match)
		if (nCount == 1)
		{
			// go back to the start of the user's typed string,
			// for every iteration while nCount == 1
			pos_pTempList = pTempList->GetFirst();
		}
		count = 0; // count of words from user's typed string which
				   // are to be used for this test
		while (pos_pTempList != NULL)
		{
			pSP = (CSourcePhrase*)pos_pTempList->GetData();
			pos_pTempList = pos_pTempList->GetNext();
			wxASSERT(pSP != NULL);
			if (bIncludePunct)
			{
				if (count == 0)
				{
					strConstruct = pSP->m_srcPhrase;
				}
				else
				{
					strConstruct += PutSrcWordBreak(pSP) + pSP->m_srcPhrase;
				}
			}
			else
			{
				if (count == 0)
				{
					strConstruct = pSP->m_key;
				}
				else
				{
					strConstruct += PutSrcWordBreak(pSP) + pSP->m_key;
				}
			}
			count++; // count the word represented by this source phrase
			if (count == nLimit)
			{
				break;
			}
		}
		if (bIgnoreCase)
			strConstruct.MakeLower();

		// we exit either because nTotal is less than nLimit (in which case pos_pTempList became
		// null before count was able to become equal to nLimit), or because count
		// equals nLimit. So now we must update the value of nTotal, so that it equals
		// the number of remaining words (ie. srcPhrases) in the pTempList list.
		nTotal -= count;
		wxASSERT(nTotal >= 0);

		// now we must check for a match. If nTotal is zero, the match can be a
		// substring, and if bFirstAttempt is TRUE, that substring can be not at the
		// start of the search string, etc. The test is different if we are on an
		// iteration other than 1st, for nCount == 1
		if (nCount == 1 && nIteration > 1)
		{
			nFound = IsMatchedToEnd(strConstruct, strSearchTarget);
		}
		else
		{
			nFound = strSearchTarget.Find(strConstruct);
		}
		if (nFound == -1)
		{
			// no match, so goto a: to try next iteration, provided nCount is still 1;
			// if nCount is greater than 1 we are not in the first SrcPhrase, and so a
			// non-match means we must return FALSE
			if (nCount == 1)
			{
				// try next iteration (with a shorter search string)
				goto a;
			}
			else
			{
				return FALSE;
			}
		}

		// we have a match, so check out whether it is exact, or a substring, etc.
		nTargetLength = strSearchTarget.Length();
		nSearchLength = strConstruct.Length();
		nAddParts = 0;
		if (nTotal > 0)
		{
			// there is more in the search string yet to be matched, so we are not at
			// the last source phrase to be tested when in this nTotal > 0 == TRUE code
			// block
			if (bFirstAttempt)
			{
				// nFound can be non-zero, but the matching must be done up to the end
				// of the strSearchTarget string, else we have a discontinuity and so
				// return FALSE or iterate
				nAddParts = nFound + nSearchLength;
				if (nAddParts < nTargetLength)
				{
					if (nCount == 1 && nIteration < nLimit)
					{
						// no match: we can try with a shorter search string, so
						// iterate
						goto a;
					}
					else
					{
						// nCount > 1, can't possibly match because of discontinuity,
						// so return FALSE
						return FALSE;
					}
				}
				wxASSERT(nAddParts == nTargetLength); // we can continue,
													  // valid matching so far
			}
			else
			{
				// there was a previous match or matches, so this matched string must
				// be coextensive with strSearchTarget itself, to avoid a discontinuity
				// in the matching, since there is yet more waiting to be tested for a
				// match in a later srcPhrase; if there is a discontinuity, check for
				// the possibility of an iteration and do so if the conditions are
				// right, else return FALSE
				if (nSearchLength != nTargetLength)
				{
					// discontinuity, check for iteration possibility
					if (nCount == 1 && nIteration < nLimit)
					{
						goto a; // have another try with a shorter search string
					}
					else
					{
						return FALSE;
					}
				}
				wxASSERT(nSearchLength == nTargetLength); // okay so far, so continue
			}
		}
		else
		{
			// nTotal must be zero, and so this current match is the last - but it must
			// match from the beginning of strSearchTarget, unless bFirstAttempt is
			// also TRUE
			wxASSERT(nTotal == 0);
			if (bFirstAttempt)
			{
				// we have just made our first match, ie, we are at the start of the
				// search string, so nFind can be non-zero legitimately, so we can
				// return TRUE, since we are done
				return TRUE;
			}
			else
			{
				// we are at the end of the search string, and there were previous
				// matches, so the offset to the first matched character must be zero,
				// if not, we do not have continuity in the matching, hence not a
				// legitimate match
				if (nFound == 0)
				{
					return TRUE;
				}
				else
				{
					// discontinuity, check for iteration possibility
					if (nCount == 1 && nIteration < nLimit)
					{
						goto a; // have another try with a shorter search string
					}
					else
					{
						return FALSE;
					}
				}
			}
		}

		// we have finished our first attempt (ie. trying to match in first srcPhrase),
		// so make bFirstAttempt FALSE for subsequent traverses through the loop
		bFirstAttempt = FALSE;
		}
		return FALSE;
	} // end of case 0:
	break;

	case 1: // target only; fall thru
	{
	}
	default:
	{
		while (pos_search != NULL)
		{
			pSrcPhrase = (CSourcePhrase*)pos_search->GetData();
			pos_search = pos_search->GetNext();
			wxASSERT(pSrcPhrase != NULL);

			// count the words in the m_adaption member, using TokenizeText, which is more
			// sophisticated than just counting white space etc.
			wxString aString = pSrcPhrase->m_adaption;
			SPList* pAList = new SPList;
			int	length = aString.Length();
			int numElements = 0;
			if (!aString.IsEmpty())
			{
				numElements = pDoc->TokenizeText(0, pAList, aString, length);
				DeleteTempList(pAList);
			}
			else
			{
				// if aString is empty, we've nothing to search in on this srcPhrase,
				// so cause progression
				if (pAList != NULL) // whm 11Jun12 added NULL test
					delete pAList; // don't leak memory
				if (bFirstOnly)
					pos_callers = pos_search;
				return FALSE;
			}
			nWordCount = numElements;

			nLimit = wxMin(nTotal, nWordCount);
			nCount++; // count this source phrase (it could have more than one word in its
					  // m_key or m_srcPhrase)
			if (bFirstOnly)
			{
				bFirstOnly = FALSE;
				pos_callers = pos_search; // we need to return only this one, because the caller needs to
							// know when the end of pList has been reached, so that the
							// caller's loop can be exited cleanly
			}
			else
			{
				nIteration = 0; // no iterations allowed for src phrases other than the first
			}

			// compute strSearchTarget
			if (bIncludePunct)
			{
				strSearchTarget = pSrcPhrase->m_targetStr;
			}
			else
			{
				strSearchTarget = pSrcPhrase->m_adaption;
			}
			if (bIgnoreCase)
				strSearchTarget.MakeLower();

			// how many iterations left to be tried, for the first phrase
		b:			if (nCount == 1)
		{
			nTotal = nElements; // reset, for each iteration
			nIteration++;  // which iteration within the nCount == 1 loop are we on
			nLimit = wxMin(nTotal, nWordCount) - nIteration + 1;
		}
		else
			nLimit = wxMin(nTotal, nWordCount);

		if (nIteration > wxMin(nTotal, nWordCount))
			return FALSE; // couldn't make a match in the first source phrase,
						  // and the rest match also

		// we use nWordCount together with pTempList data in order to build a
		// strConstruct which has nWordCount words in it - either with or without
		// punctuation depending on the bIncludePunct value, (or there can be less than
		// nWordCount words, if the search string is short enough); then for each
		// nIterations decrement, try building one word less each time (provided no
		// earlier iteration produced a match)
		if (nCount == 1)
		{
			// go back to the start of the user's typed string, for every
			// iteration while nCount == 1
			pos_pTempList = pTempList->GetFirst();
		}
		count = 0; // count of words from user's typed string which are
				   // to be used for this test
		while (pos_pTempList != NULL)
		{
			pSP = (CSourcePhrase*)pos_pTempList->GetData();
			pos_pTempList = pos_pTempList->GetNext();
			wxASSERT(pSP != NULL);
			if (bIncludePunct)
			{
				if (count == 0)
				{
					strConstruct = pSP->m_srcPhrase;
				}
				else
				{
					strConstruct += PutSrcWordBreak(pSP) + pSP->m_srcPhrase;
				}
			}
			else
			{
				if (count == 0)
				{
					strConstruct = pSP->m_key;
				}
				else
				{
					strConstruct += PutSrcWordBreak(pSP) + pSP->m_key;
				}
			}
			count++; // count the word represented by this source phrase
			if (count == nLimit)
			{
				break;
			}
		}
		if (bIgnoreCase)
			strConstruct.MakeLower();

		// we exit either because nTotal is less than nLimit (in which case pos_pTempList became
		// null before count was able to become equal to nLimit), or because count
		// equals nLimit. So now we must update the value of nTotal, so that it equals
		// the number of remaining words (ie. srcPhrases) in the pTempList list.
		nTotal -= count;
		wxASSERT(nTotal >= 0);

		// now we must check for a match. If nTotal is zero, the match can be a
		// substring, and if bFirstAttempt is TRUE, that substring can be not at the
		// start of the search string, etc. The test is different if we are on an
		// iteration other than 1st, for nCount == 1
		if (nCount == 1 && nIteration > 1)
		{
			nFound = IsMatchedToEnd(strConstruct, strSearchTarget);
		}
		else
		{
			nFound = strSearchTarget.Find(strConstruct);
		}
		if (nFound == -1)
		{
			// no match, so goto a: to try next iteration, provided nCount is still 1;
			// if nCount is greater than 1 we are not in the first SrcPhrase, and so a
			// non-match means we must return FALSE
			if (nCount == 1)
			{
				// try next iteration (with a shorter search string)
				goto b;
			}
			else
			{
				return FALSE;
			}
		}

		// we have a match, so check out whether it is exact, or a substring, etc.
		nTargetLength = strSearchTarget.Length();
		nSearchLength = strConstruct.Length();
		nAddParts = 0;
		if (nTotal > 0)
		{
			// there is more in the search string yet to be matched, so we are not at
			// the last source phrase to be tested when in this nTotal > 0 == TRUE code
			// block
			if (bFirstAttempt)
			{
				// nFound can be non-zero, but the matching must be done up to the end
				// of the strSearchTarget string, else we have a discontinuity and so
				// return FALSE or iterate
				nAddParts = nFound + nSearchLength;
				if (nAddParts < nTargetLength)
				{
					if (nCount == 1 && nIteration < nLimit)
					{
						// no match: we can try with a shorter search string,
						// so iterate
						goto b;
					}
					else
					{
						// nCount > 1, can't possibly match because of discontinuity,
						// so return FALSE
						return FALSE;
					}
				}
				wxASSERT(nAddParts == nTargetLength); // we can continue,
													  // valid matching so far
			}
			else
			{
				// there was a previous match or matches, so this matched string must
				// be coextensive with strSearchTarget itself, to avoid a discontinuity
				// in the matching, since there is yet more waiting to be tested for a
				// match in a later srcPhrase; if there is a discontinuity, check for
				// the possibility of an iteration and do so if the conditions are
				// right, else return FALSE
				if (nSearchLength != nTargetLength)
				{
					// discontinuity, check for iteration possibility
					if (nCount == 1 && nIteration < nLimit)
					{
						goto b; // have another try with a shorter search string
					}
					else
					{
						return FALSE;
					}
				}
				wxASSERT(nSearchLength == nTargetLength); // okay so far, so continue
			}
		}
		else
		{
			// nTotal must be zero, and so this current match is the last - but it must
			// match from the beginning of strSearchTarget, unless bFirstAttempt is
			// also TRUE
			wxASSERT(nTotal == 0);
			if (bFirstAttempt)
			{
				// we have just made our first match, ie, we are at the start of the
				// search string, so nFind can be non-zero legitimately, so we can
				// return TRUE, since we are done
				return TRUE;
			}
			else
			{
				// we are at the end of the search string, and there were previous
				// matches, so the offset to the first matched character must be zero,
				// if not, we do not have continuity in the matching, hence not a
				// legitimate match
				if (nFound == 0)
				{
					return TRUE;
				}
				else
				{
					// discontinuity, check for iteration possibility
					if (nCount == 1 && nIteration < nLimit)
					{
						goto b; // have another try with a shorter search string
					}
					else
					{
						return FALSE;
					}
				}
			}
		}

		// we have finished our first attempt (ie. trying to match in first srcPhrase),
		// so make bFirstAttempt FALSE for subsequent traverses through the loop
		bFirstAttempt = FALSE;
		}
		return FALSE;
	} // end of case default or case 1:
		break;
	} // end of switch (selector)
#ifndef __VISUALC__
	return FALSE; // unreachable according to VC7.1, but gcc says it is needed!!!
#endif
}

// searches in the list of source phrases for a match, ignores the view; if glossing is ON
// then bIncludePunct and bSpanSrcPhrases will be obligatorily FALSE; and nCount should not
// get set to anything except 1 (when glossing is ON)
// ALSO NOTE: for simplicity I had a test of gbIsGlossing set the bIncludePunct flag to FALSE,
// which strictly speaking is too strong a condition when the search is done only in the
// source text; however, since few people use the Find... command, and fewer still are likely
// to use it with glossing ON and at the same time want a punctuated search in the source text,
// I figure I can get this past muster without anyone ever discovering it! In other words, when
// glossing is ON, the search will be in source text where punctuation has been excluded.
// BEW 26Mar10, no changes needed for support of doc version 5
// BEW 21Jul14, no changes for ZWSP support (however, there were changes to one function
// it calls, DoExtendedSearch() - four calls of PutSrcWordBreak() replacing _T(" "))
bool CAdapt_ItView::DoSrcOnlyFind(int nStartSequNum, bool bIncludePunct, bool bSpanSrcPhrases,
								  wxString& src,bool bIgnoreCase, int& nSequNum, int& nCount)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	if (gbIsGlossing)
	{
		wxASSERT(!bIncludePunct && !bSpanSrcPhrases);
	}
	CAdapt_ItDoc* pDoc = GetDocument();
	wxASSERT(pDoc != NULL);
	SPList* pList = pApp->m_pSourcePhrases;
	wxASSERT(pList != NULL);
	SPList::Node* pos_pList = pList->Item(nStartSequNum); // starting position
	wxASSERT(pos_pList != NULL);
	int sn = nStartSequNum;
	CSourcePhrase* pSrcPhrase = NULL;
	int nRetransFirst = -1;
	int nRetransLast = -1;
	bool bInRetrans = FALSE;
	int nFound;
	wxString srcCopy; // for caseless matching
	wxString searchCopy; // for caseless searching in it
	wxString srcNoPunct; // for making a copy from which we can remove punctuation

	if (bSpanSrcPhrases)
	{
		// must never enter here when glossing is ON
		bool bFound = FALSE;

        // parse a copy of the src text string, storing the results in temporary
        // CSourcePhrase instances so that the m_key members hold the punctuation-less
        // words, and the m_srcPhrase members the punctuated words
		SPList* pTempList = new SPList; // a temporary list
		wxASSERT(pTempList != NULL);

		// tokenize the string into a list of new CSourcePhrase instances on the heap
		// (they are incomplete - only m_key, m_srcPhrase and m_nSequNumber are set)
		wxString theString = src;
		int	length = theString.Length();
		int nElements = 0;
		if (!theString.IsEmpty())
		{
			nElements = pDoc->TokenizeText(0,pTempList,theString,length);
		}
		else
		{
			// if theString is empty, we've nothing to search for, so return FALSE
			if (pTempList != NULL) // whm 11Jun12 added NULL test
				delete pTempList; // don't leak memory
			return FALSE;
		}

		// do the search, and permit matching text across discrete CSourcePhrase instances
		SPList::Node* savePos;
e:		while (pos_pList != NULL)
		{
			wxString tgt;
			tgt.Empty();
			savePos = pos_pList; // test for initial matched srcPhrase in a retranslation
			bFound = DoExtendedSearch(0, pos_pList,pDoc,pTempList,nElements,
										bIncludePunct,bIgnoreCase,nCount);
			if (bFound)
			{
				nSequNum = sn;
				goto d;
			}
			else
			{
				sn++;
			}
		}
		// if we get here, pos_pList is null, and so we have no match possible
		DeleteTempList(pTempList);
		return FALSE;

		// we found a match, check if it is in a retranslation & adjust nCount &
		// nSequNum if it is contained within the retranslation
d:		pSrcPhrase = (CSourcePhrase*)savePos->GetData();
		wxASSERT(pSrcPhrase != NULL);
		if (pSrcPhrase->m_bRetranslation)
		{
			bInRetrans = IsContainedByRetranslation(nSequNum,nCount,
													nRetransFirst,nRetransLast);
			if (bInRetrans)
			{
				// adjust values, so that the match is the whole retranslation
				CPile* pP = GetPile(nRetransFirst);
				wxASSERT(pP != NULL);
				CSourcePhrase* pSP = pP->GetSrcPhrase();
				wxASSERT(pSP != NULL);
				nSequNum = pSP->m_nSequNumber;
				nCount = nRetransLast - nRetransFirst + 1;

				// set the globals
				pApp->m_bMatchedRetranslation = TRUE;
				gnRetransEndSequNum = nRetransLast;
				DeleteTempList(pTempList);
				return TRUE;
			}
			else
			{
				// clear the globals
				pApp->m_bMatchedRetranslation = FALSE;
				gnRetransEndSequNum = -1;
				goto e; // continue iterating, looking for a match
			}
		}
		// clear the globals
		pApp->m_bMatchedRetranslation = FALSE;
		gnRetransEndSequNum = -1;
		DeleteTempList(pTempList);
		return TRUE; // return with unchanged nSequNum and nCount values
	}
	else // could be glossing or adapting
	{
		// do the search, confining attempts to match the text within
		// a single CSourcePhrase instance
		nFound = -1; // assume not found
		srcCopy = src; // for caseless matching
		srcNoPunct = src; // make a copy from which we can remove punctuation
		RemovePunctuation(pDoc,&srcNoPunct,from_source_text);
		if (bIgnoreCase)
		{
			srcCopy.MakeLower();
			srcNoPunct.MakeLower();
		}
f:		while (pos_pList != NULL)
		{
			pSrcPhrase = (CSourcePhrase*)pos_pList->GetData();
			pos_pList = pos_pList->GetNext();
			wxASSERT(pSrcPhrase != NULL);

			// do the searching either in m_srcPhrase or m_key, depending on
			// whether punctuation is to be included in the search or not
			if (bIncludePunct)
			{
				// use the m_srcPhrase attribute if adapting; don't enter this block
				// if glossing is ON
				if (pSrcPhrase->m_srcPhrase.IsEmpty() || pSrcPhrase->m_bNullSourcePhrase)
				{
					goto b;
				}
				searchCopy = pSrcPhrase->m_srcPhrase;
				if (bIgnoreCase)
					searchCopy.MakeLower();
				nFound = searchCopy.Find(srcCopy);
b:				if (nFound >= 0)
				{
					// we found a matching (sub)string
					nSequNum = sn;
					nCount = 1;
					goto c;
				}
				else
				{
					sn++; // index for next CSourcePhrase instance to be searched
				}
			}
			else // bIncludePunct is FALSE, so if glossing is ON it too will use this block
			{
				// use the m_key attribute
				if (pSrcPhrase->m_key.IsEmpty() || pSrcPhrase->m_bNullSourcePhrase)
				{
					goto a;
				}
				searchCopy = pSrcPhrase->m_key;
				if (bIgnoreCase)
					searchCopy.MakeLower();
				nFound = searchCopy.Find(srcNoPunct);
a:				if (nFound >= 0)
				{
					// we found a matching (sub)string
					nSequNum = sn;
					nCount = 1;
					goto c;
				}
				else
				{
					sn++; // index for next CSourcePhrase instance to be searched
				}
			}
		}
	}

	// if we get here, we didn't find a match
	return FALSE;

    // we found a match, check if it is in a retranslation & adjust nCount & nSequNum if it
    // is contained within the retranslation; but we don't want to test this if glossing is
    // ON because matching can be within a translation in that circumstance
c: if (gbIsGlossing)
   {
		pApp->m_bMatchedRetranslation = FALSE;
		gnRetransEndSequNum = -1;
		return TRUE;
   }
   // when not glossing we have to consider the possibility that we may be in, out, or
   // partially within a retranslation
	if (pSrcPhrase->m_bRetranslation)
	{
		bInRetrans = IsContainedByRetranslation(nSequNum,nCount,
												nRetransFirst,nRetransLast);
		if (bInRetrans)
		{
			// adjust values, so that the match is the whole retranslation
			CPile* pP = GetPile(nRetransFirst);
			wxASSERT(pP != NULL);
			CSourcePhrase* pSP = pP->GetSrcPhrase();
			wxASSERT(pSP != NULL);
			nSequNum = pSP->m_nSequNumber;
			nCount = nRetransLast - nRetransFirst + 1;

			// set the globals
			pApp->m_bMatchedRetranslation = TRUE;
			gnRetransEndSequNum = nRetransLast;
			return TRUE;
		}
		else
		{
			// clear the globals
			pApp->m_bMatchedRetranslation = FALSE;
			gnRetransEndSequNum = -1;
			goto f; // continue iterating, looking for a match
		}
	}
	// clear the globals
	pApp->m_bMatchedRetranslation = FALSE;
	gnRetransEndSequNum = -1;
	return TRUE; // return with unchanged nSequNum and nCount values
}

// searches in the list of source phrases for a match, ignores the view; when glossing is
// ON the 'tgt' will be the glossing line; and the 2nd and 3rd parameters will be FALSE,
// and nCount must only return 1 (when glossing is ON). Glossing text by default allows any
// typed punctuation to be stored; so bIncludePunct == FALSE does nothing to affect whether
// gloss text has punctuation, it just stops certain blocks of code being entered.
// BEW 21Jul14, no changes for ZWSP support (however, there were changes to one function
// it calls, DoExtendedSearch() - four calls of PutSrcWordBreak() replacing _T(" "))
bool CAdapt_ItView::DoTgtOnlyFind(int		nStartSequNum,
								  bool		bIncludePunct,
								  bool		bSpanSrcPhrases,
								  wxString& tgt,
								  bool		bIgnoreCase,
								  int&		nSequNum,
								  int&		nCount)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	CAdapt_ItDoc* pDoc = GetDocument();
	wxASSERT(pDoc != NULL);
	SPList* pList = pApp->m_pSourcePhrases;
	wxASSERT(pList != NULL);
	SPList::Node* pos_pList = pList->Item(nStartSequNum); // starting position
	wxASSERT(pos_pList != NULL);
	int sn = nStartSequNum;
	CSourcePhrase* pSrcPhrase = NULL;
	int nRetransFirst = -1;
	int nRetransLast = -1;
	bool bInRetrans = FALSE;
	int nFound; // -1 = assume not found
	wxString tgtCopy; // for caseless matching
	wxString searchCopy; // for caseless searching in it
	wxString tgtNoPunct; // for making a copy from which we can remove punctuation

    // if bSpanSrcPhrases is TRUE,but the tgt string is empty, then it makes no sense to
    // span source phrases, so this case reduces to a normal search within a single
    // srcPhrase
	if (bSpanSrcPhrases && tgt.IsEmpty())
		goto c;

	if (bSpanSrcPhrases)
	{
		wxASSERT(!gbIsGlossing); // must not be glossing if we enter this block
		// do the search, and permit matching text across discrete
		// CSourcePhrase instances
		bool bFound = FALSE;

        // parse a copy of the tgt text string, storing the results in temporary
        // CSourcePhrase instances so that the m_key members hold the punctuation-less
        // words, and the m_srcPhrase members the punctuated words
		SPList* pTempList = new SPList; // a temporary list
		wxASSERT(pTempList != NULL);

		// tokenize the string into a list of new CSourcePhrase instances on the heap
		// (they are incomplete - only m_key, m_srcPhrase and m_nSequNumber are set)
		wxString theString = tgt;
		int	length = theString.Length();
		int nElements = 0;
		if (!theString.IsEmpty())
		{
			nElements = pDoc->TokenizeText(0,pTempList,theString,length);
		}
		else
		{
			// if theString is empty, we've nothing to search for, so return FALSE
			if (pTempList != NULL) // whm 11Jun12 added NULL test
				delete pTempList; // don't leak memory
			return FALSE;
		}

		// do the search, and permit matching text across discrete CSourcePhrase instances
		SPList::Node* savePos;
h:		while (pos_pList != NULL)
		{
			wxString src;
			src.Empty();
			savePos = pos_pList;
			// BEW 21Jul14, this call has been refactored to support ZWSP
			bFound = DoExtendedSearch(1, pos_pList,pDoc,pTempList,nElements,
									bIncludePunct,bIgnoreCase,nCount);
			if (bFound)
			{
				nSequNum = sn;
				goto d;
			}
			else
			{
				sn++;
			}
		}
		// if we get here, pos_pList is null, and so we have no match possible
		DeleteTempList(pTempList);
		return FALSE;

		// we found a match, check if it is in a retranslation & adjust nCount &
		// nSequNum if it is contained within the retranslation
d:		pSrcPhrase = (CSourcePhrase*)savePos->GetData();
		wxASSERT(pSrcPhrase != NULL);
		if (pSrcPhrase->m_bRetranslation)
		{
			bInRetrans = IsContainedByRetranslation(nSequNum,nCount,
												nRetransFirst,nRetransLast);
			if (bInRetrans)
			{
				// adjust values, so that the match is the whole retranslation
				CPile* pP = GetPile(nRetransFirst);
				wxASSERT(pP != NULL);
				CSourcePhrase* pSP = pP->GetSrcPhrase();
				wxASSERT(pSP != NULL);
				nSequNum = pSP->m_nSequNumber;
				nCount = nRetransLast - nRetransFirst + 1;

				// set the globals
				pApp->m_bMatchedRetranslation = TRUE;
				gnRetransEndSequNum = nRetransLast;
				DeleteTempList(pTempList);
				return TRUE;
			}
			else
			{
				// clear the globals
				pApp->m_bMatchedRetranslation = FALSE;
				gnRetransEndSequNum = -1;
				goto h; // continue iterating, looking for a match
			}
		}
		// clear the globals
		pApp->m_bMatchedRetranslation = FALSE;
		gnRetransEndSequNum = -1;
		DeleteTempList(pTempList);
		return TRUE; // return with unchanged nSequNum and nCount values
	}
	else // bSpanSrcPhrases == FALSE branch; glossing ON uses this branch always
	{
		// do the search, confining attempts to match the text within
		// a single CSourcePhrase instance
c:		nFound = -1; // assume not found
		tgtCopy = tgt; // for caseless matching (tgt would contain search string
					   // for finding within glosses if glossing is ON)
		tgtNoPunct = tgt; // make a copy from which we can remove punctuation
		if (!gbIsGlossing)
			RemovePunctuation(pDoc,&tgtNoPunct,from_target_text);
		if (bIgnoreCase)
		{
			tgtCopy.MakeLower();
			tgtNoPunct.MakeLower();
		}
i:		while (pos_pList != NULL)
		{
			pSrcPhrase = (CSourcePhrase*)pos_pList->GetData();
			pos_pList = pos_pList->GetNext();
			wxASSERT(pSrcPhrase != NULL);

            // do the searching either in m_targetStr or m_adaption, depending on whether
            // punctuation is to be included in the search or not
			if (bIncludePunct) // glossing ON forces this boolean FALSE in the caller,
				// so glossing does not use this block, but only the ELSE block
			{
				// use the m_targetStr attribute
				if (pSrcPhrase->m_targetStr.IsEmpty())
				{
					// since we allow null matches, check for this
					if (tgt.IsEmpty())
					{
						// we have a null match, so success
						nSequNum = sn;
						nCount = 1;
						goto e;
					}
					else
						goto b;
				}
				else
				{
					if (tgt.IsEmpty())
						goto b; // can't allow a Find with a null phrase,
								// it would match anything
				}
				searchCopy = pSrcPhrase->m_targetStr;
				if (bIgnoreCase)
					searchCopy.MakeLower();
				nFound = searchCopy.Find(tgtCopy);
b:				if (nFound >= 0)
				{
					// we found a matching (sub)string
					nSequNum = sn;
					nCount = 1;
					goto e;
				}
				else
				{
					sn++; // index for next CSourcePhrase instance to be searched
				}
			}
			else // bIncludePunct == FALSE branch; glossing ON also uses this branch
			{
				// use the m_adaption attribute when adapting, m_gloss when glossing
				bool bTest;
				if (gbIsGlossing)
					bTest = pSrcPhrase->m_gloss.IsEmpty();
				else
					bTest = pSrcPhrase->m_adaption.IsEmpty();
				if (bTest)
				{
					// no text, since we allow null matches check for a null match
					if (tgt.IsEmpty())
					{
						// we have a null match, so success
						nSequNum = sn;
						nCount = 1;
						goto e;
					}
					else
						goto a;
				}
				else // there is some adaptation, or gloss, text
				{
					if (tgt.IsEmpty())
						goto a; // can't allow a Find with a null phrase,
							// (except for a null match) because it would match anything
				}
				if (gbIsGlossing)
					searchCopy = pSrcPhrase->m_gloss;
				else
					searchCopy = pSrcPhrase->m_adaption;
				if (bIgnoreCase)
					searchCopy.MakeLower();
				if (gbIsGlossing)
				{
					nFound = pSrcPhrase->m_gloss.Find(tgt); // possibly
										// a punctuation-containing search
				}
				else // not glossing
				{
					nFound = pSrcPhrase->m_adaption.Find(tgtNoPunct);
				}
a:				if (nFound >= 0)
				{
					// we found a matching (sub)string
					nSequNum = sn;
					nCount = 1;
					goto e;
				}
				else
				{
					sn++; // index for next CSourcePhrase instance to be searched
				}
			}
		}
	}

	// if we get here, we didn't find a match
	return FALSE;

	// we found a match, check if it is in a retranslation & adjust nCount &
	// nSequNum if it is contained within the retranslation
e:	if (gbIsGlossing)
	{
		pApp->m_bMatchedRetranslation = FALSE;
		gnRetransEndSequNum = -1;
		return TRUE;
	}
	// if not glossing, we have to check out if we landed in, or partly in, or out of
	// a retranslation - and fix things accordingly.
	if (pSrcPhrase->m_bRetranslation)
	{
		bInRetrans = IsContainedByRetranslation(nSequNum,nCount,
												nRetransFirst,nRetransLast);
		if (bInRetrans)
		{
			// adjust values, so that the match is the whole retranslation
			CPile* pP = GetPile(nRetransFirst);
			wxASSERT(pP != NULL);
			CSourcePhrase* pSP = pP->GetSrcPhrase();
			wxASSERT(pSP != NULL);
			nSequNum = pSP->m_nSequNumber;
			nCount = nRetransLast - nRetransFirst + 1;

			// set the globals
			pApp->m_bMatchedRetranslation = TRUE;
			gnRetransEndSequNum = nRetransLast;
			return TRUE;
		}
		else
		{

			// clear the globals
			pApp->m_bMatchedRetranslation = FALSE;
			gnRetransEndSequNum = -1;
			goto i; // continue iterating, looking for a match
		}
	}
	// clear the globals
	pApp->m_bMatchedRetranslation = FALSE;
	gnRetransEndSequNum = -1;
	return TRUE; // return with unchanged nSequNum and nCount values
}

// see the comments at the start of the DoSrcOnlyFind( ) and DoTgtOnlyFind( ) - same stuff
// applies here; and tgt could be text to check in adaptations, or glosses, depending on
// gbIsGlossing value
// BEW 21Jul14, no changes for ZWSP support (however, there were changes to one function
// it calls, DoExtendedSearch() - four calls of PutSrcWordBreak() replacing _T(" "))
bool CAdapt_ItView::DoSrcAndTgtFind(int			nStartSequNum,
									bool		bIncludePunct,
									bool		bSpanSrcPhrases,
									wxString&	src,
									wxString&	tgt,
									bool		bIgnoreCase,
									int&		nSequNum,
									int&		nCount)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	CAdapt_ItDoc* pDoc = GetDocument();
	wxASSERT(pDoc != NULL);
	SPList* pList = pApp->m_pSourcePhrases;
	wxASSERT(pList != NULL);
	SPList::Node* pos_pList = pList->Item(nStartSequNum); // starting position
	wxASSERT(pos_pList != NULL);
	int sn = nStartSequNum;
	CSourcePhrase* pSrcPhrase = NULL;
	int nSaveSrcSequNum = -1;
	int nCount1 = 0;
	int nCount2 = 0;
	int nRetransFirst = -1;
	int nRetransLast = -1;
	bool bInRetrans = FALSE;
	bool bSrcMatchIsRetrans = FALSE;
	bool bFound = FALSE;
	SPList* pTempList = NULL;
	int length = 0;
	int nElements = 0;
	int nElements2 = 0;
	wxString theString;
	theString.Empty();
	SPList::Node* savePos = NULL;
	int nFound; // -1 = assume not found
	wxString srcCopy;
	wxString tgtCopy;
	wxString searchStr;
	wxString srcNoPunct; // for making a copy from which we can remove punctuation

	if (bSpanSrcPhrases)
	{
		wxASSERT(!gbIsGlossing); // cannot enter this block when glossing is ON
		// do the search, and permit matching text across discrete
		// CSourcePhrase instances
		bFound = FALSE;

        // parse a copy of the src text string, storing the results in temporary
        // CSourcePhrase instances so that the m_key members hold the punctuation-less
        // words, and the m_srcPhrase members the punctuated words
		pTempList = new SPList; // a temporary list
		wxASSERT(pTempList != NULL);

		// tokenize the string into a list of new CSourcePhrase instances on the heap
		// (they are incomplete - only m_key, m_srcPhrase and m_nSequNumber are set)
		theString = src;
		length = theString.Length();
		nElements = 0;
		if (!theString.IsEmpty())
		{
			nElements = pDoc->TokenizeText(0,pTempList,theString,length);
		}
		else
		{
			// if theString is empty, we've nothing to search for, so return FALSE
			if (pTempList != NULL) // whm 11Jun12 added NULL test
				delete pTempList; // don't leak memory
			return FALSE;
		}

		// do the search, and permit matching text across discrete
		// CSourcePhrase instances
		SPList::Node* savePos = NULL; // whm initialized to NULL
e:		while (pos_pList != NULL)
		{
			wxString tgt;
			tgt.Empty();
			savePos = pos_pList;
			// BEW 21Jul14, this call supports ZWSP
			bFound = DoExtendedSearch(0, pos_pList,pDoc,pTempList,nElements,
									bIncludePunct,bIgnoreCase,nCount1);
			if (bFound)
			{
				nSaveSrcSequNum = sn;
				break;
			}
			else
			{
				sn++;
			}
		}
		// if we get here, pos_pList is null, or we have a src match, if the latter,
		// do the target search
		if (pos_pList == NULL || nSaveSrcSequNum == -1 || savePos == NULL)
		{
			// we didn't get a src match, so return
			DeleteTempList(pTempList);
			return FALSE;
		}

		// we found a match, check if it is in a retranslation & adjust nCount1 &
		// nSequNum if it is contained within the retranslation
		pSrcPhrase = (CSourcePhrase*)savePos->GetData();
		wxASSERT(pSrcPhrase != NULL);
		if (pSrcPhrase->m_bRetranslation)
		{
			bInRetrans = IsContainedByRetranslation(nSaveSrcSequNum,nCount1,
													nRetransFirst,nRetransLast);
			if (bInRetrans)
			{
                 // adjust values, so that the match is the whole retranslation
				CPile* pP = GetPile(nRetransFirst);
				wxASSERT(pP != NULL);
				CSourcePhrase* pSP = pP->GetSrcPhrase();
				wxASSERT(pSP != NULL);
				nSaveSrcSequNum = pSP->m_nSequNumber;
				nCount1 = nRetransLast - nRetransFirst + 1;
				bSrcMatchIsRetrans = TRUE;
			}
			else
			{
				// clear the globals
				bSrcMatchIsRetrans = FALSE;
				pApp->m_bMatchedRetranslation = FALSE;
				gnRetransEndSequNum = -1;
				sn++;
				nSaveSrcSequNum = -1;
				goto e; // continue iterating, looking for a match
			}
		}
		else
		{
			bSrcMatchIsRetrans = FALSE;
		}

        // before doing the target search, we must check for an empty tgt string. If it is
        // empty, then the only meaningful "match" is that nCount1 source phrases matched
        // so far must each have an empty string in their m_adaption member. So if that is
        // so, we have a null match and can exit TRUE. So do the check next.
		if (tgt.IsEmpty())
		{
			SPList::Node* pos_pList = pList->Item(nSaveSrcSequNum);
			wxASSERT(pos_pList != 0);
			for (int j=0; j < nCount1; j++)
			{
				CSourcePhrase* pSP = (CSourcePhrase*)pos_pList->GetData();
				pos_pList = pos_pList->GetNext();
				wxASSERT(pos_pList != 0);
				if (!pSP->m_adaption.IsEmpty())
				{
					bSrcMatchIsRetrans = FALSE;
					pApp->m_bMatchedRetranslation = FALSE;
					gnRetransEndSequNum = -1;
					sn++;
					nSaveSrcSequNum = -1;
					goto e; // continue iterating, looking for a match
				}
			}

			// if we get here, we have a valid match, so return
			nSequNum = nSaveSrcSequNum;
			nCount = nCount1;
			DeleteTempList(pTempList);
			return TRUE;
		}

		// now try the target search - (use code copied from
		// DoTgtFindOnly() & modified a bit)
		bFound = FALSE;

		// start at the sequ number just defined
		SPList::Node* pos_pList = pList->Item(nSaveSrcSequNum);
		sn = nSaveSrcSequNum;

        // parse a copy of the tgt text string, storing the results in temporary
        // CSourcePhrase instances so that the m_key members hold the punctuation-less
        // words, and the m_srcPhrase members the punctuated words
		SPList* pTempList2 = new SPList; // a temporary list for the tgt ones
		wxASSERT(pTempList2 != NULL);

		// tokenize the string into a list of new CSourcePhrase instances on the heap
		// (they are incomplete - only m_key, m_srcPhrase and m_nSequNumber are set)
		theString = tgt;
		length = theString.Length();
		nElements2 = 0;
		if (!theString.IsEmpty())
		{
			nElements2 = pDoc->TokenizeText(0,pTempList2,theString,length);
		}
		// note, we will permit "matching" an empty string in the target text

        // if the target's nElements2 > nElements, no match is possible (the target must
        // match within the scope of the source match), though it may be possible if the
        // source match was in a retranslation
		if (nElements2 > nElements && !bSrcMatchIsRetrans)
		{
			pApp->m_bMatchedRetranslation = FALSE;
			gnRetransEndSequNum = -1;
			sn = nSaveSrcSequNum; // prepare for outer loop
			sn++;
			nSaveSrcSequNum = -1;
			goto e;
		}

		// do the search, and permit matching text across discrete
		// CSourcePhrase instances
		while (pos_pList != NULL)
		{
			wxString src;
			src.Empty();
			savePos = pos_pList; // DoExtendedSearch returns pos_pList value at next
							// location to the input parameter pos_pList value,
							// so to preserve the input one, we need savePos as well
			// BEW 21Jul14, this call supports ZWSP
			bFound = DoExtendedSearch(1, pos_pList,pDoc,pTempList2,nElements2,
									bIncludePunct,bIgnoreCase,nCount2);
			if (bFound)
			{
				nSequNum = sn;
				DeleteTempList(pTempList2);

                // we have a double match only if the sequence number for the first
                // srcPhrase of each match is the same and the target selection is no
                // longer than the source one; or if not the same, then both nSequNum and
                // the end of the target match lie within the source text selection, which
                // amounts to conditions on nCount1 and nCount2 values

				// we found a match, check if it is in same retranslation if the
				// first match was in one
				pSrcPhrase = (CSourcePhrase*)savePos->GetData();
				wxASSERT(pSrcPhrase != NULL);
				if (pSrcPhrase->m_bRetranslation && bSrcMatchIsRetrans)
				{
					bInRetrans = IsContainedByRetranslation(nSequNum,nCount2,
															nRetransFirst,nRetransLast);
					if (bInRetrans)
					{
						// the match is the whole retranslation
						nSequNum = nSaveSrcSequNum;
						nCount = nCount1;

						// set the globals
						pApp->m_bMatchedRetranslation = TRUE;
						gnRetransEndSequNum = nRetransLast;
						if (pTempList != NULL) DeleteTempList(pTempList);
						return TRUE;
					}
					else
					{
                        // continue iterating the source loop, since the src string matched
                        // the retranslation but the tgt string matched at bes