/////////////////////////////////////////////////////////////////////////////
/// \project		adaptit
/// \file			Adapt_ItDoc.cpp
/// \author			Bill Martin
/// \date_created	05 January 2004
/// \rcs_id $Id$
/// \copyright		2008 Bruce Waters, Bill Martin, SIL International
/// \license		The Common Public License or The GNU Lesser General Public License (see license directory)
/// \description	This is the implementation file for the CAdapt_ItDoc class.
/// The CAdapt_ItDoc class implements the storage structures and methods
/// for the Adapt It application's persistent data. Adapt It's document
/// consists mainly of a list of CSourcePhrases stored in order of occurrence
/// of source text words. The document's data structures are kept logically
/// separate from and independent of the view class's in-memory data structures.
/// This schema is an implementation of the document/view framework.
/// \derivation		The CAdapt_ItDoc class is derived from wxDocument.
/////////////////////////////////////////////////////////////////////////////

//#define _debugLayout
// comment out next line to turn of the wxLogDebug calls in this file
//#define LOG_USFM3
#define maxLen 60
//#define _AT_PTR
//#define FIXORDER
//#define LOGMKRS
//#define WHERE
const int logStart = 2;
const int logEnd = 5;
//#define SEEPTR
//#define NOLOGS
//#define NOPAREN

#if defined(__GNUG__) && !defined(__APPLE__)
#pragma implementation "Adapt_ItDoc.h"
#endif

// For compilers that support precompilation, includes "wx.h".
#include <wx/wxprec.h>

// BEW 29Jun16, for debugging support
//#define TOKENIZE_BUG
size_t aSequNum; // use with TOKENIZE_BUG



#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
// Include your minimal set of headers here, or wx.h
#include <wx/wx.h>
#endif

#include <wx/docview.h>	// includes wxWidgets doc/view framework
#include "Adapt_ItCanvas.h"
#include "Adapt_It_Resources.h"
#include <wx/filesys.h>
#include <wx/file.h>
#include <wx/wfstream.h>
#include <wx/zipstrm.h> // for wxZipInputStream & wxZipOutputStream
#include <wx/datstrm.h> // permanent
#include <wx/txtstrm.h> // temporary
#include <wx/mstream.h> // for wxMemoryInputStream
#include <wx/font.h> // temporary
#include <wx/fontmap.h> // temporary
#include <wx/fontenum.h> // temporary
#include <wx/list.h>
#include <wx/tokenzr.h>
#include <wx/progdlg.h>
#include <wx/busyinfo.h>
#include <wx/dir.h> // for wxDir
#include <wx/textfile.h>

#if !defined(__APPLE__)
#include <malloc.h>
#else
#include <malloc/malloc.h>
#endif

// The following are from IBM's International Components for Unicode (icu) used under the LGPL license.
//#include "csdetect.h" // used in GetNewFile().
//#include "csmatch.h" // " "

// Other includes uncomment as implemented

#include "Adapt_It.h"
#include "OutputFilenameDlg.h"
#include "helpers.h"
#include "CollabUtilities.h"
#include "MainFrm.h"
#include "SourcePhrase.h"
#include "KB.h"
#include "AdaptitConstants.h"
#include "TargetUnit.h"
#include "Adapt_ItDoc.h"
#include "Adapt_ItView.h"
#include "Strip.h"
#include "Pile.h" // must precede the include for the document
#include "Cell.h"
#include "Layout.h"
#include "BookNameDlg.h" // BEW added 7Aug12
#include "RefString.h"
#include "RefStringMetadata.h"
//#include "ProgressDlg.h" // removed in svn revision #562
#include "WaitDlg.h"
#include "XML.h"
#include "MoveDialog.h"
#include "SplitDialog.h"
#include "JoinDialog.h"
#include "UnpackWarningDlg.h"
#include "FreeTrans.h"
#include "Notes.h"
#include "ExportFunctions.h"
#include "ReadOnlyProtection.h"
#include "ConsistencyCheckDlg.h"
#include "ChooseConsistencyCheckTypeDlg.h" //whm added 9Feb04
#include "NavProtectNewDoc.h"
#include "ConsChk_Empty_noTU_Dlg.h"
#include "conschk_exists_notu_dlg.h"
#include "DVCS.h"
#include "DVCSNavDlg.h"
#include "DVCSLogDlg.h"
#include "StatusBar.h"
#include "ChooseTranslation.h"
#include "BString.h"
#include "md5.h" // whm 26Mar2024 added


// GDLC Removed conditionals for PPC Mac (with gcc4.0 they are no longer needed)
void init_utf8_char_table();
const char* tellenc(const char* const buffer, const size_t len);

// Define type safe pointer lists
#include "wx/listimpl.cpp"

/// This macro together with the macro list declaration in the .h file
/// complete the definition of a new safe pointer list class called AFList.
WX_DEFINE_LIST(AFList);
WX_DEFINE_LIST(AFGList);

// BEW 11Jul23 added
//WX_DEFINE_LIST(mySPList);

/// This global is defined in Adapt_ItView.cpp.
extern bool gbVerticalEditInProgress;

/// This global is defined in Adapt_ItView.cpp.
extern EditRecord gEditRecord; // defined at start of Adapt_ItView.cpp

/// This global is defined in Adapt_It.cpp.
extern enum TextType gPreviousTextType; // moved to global space in the App, made extern here

// Other declarations from MFC version below

/// Length of the byte-order-mark (BOM) which consists of the three bytes 0xEF, 0xBB and 0xBF
/// in UTF-8 encoding.
#define nBOMLen 3

extern wxMutex s_AutoSaveMutex;

/// Length of the byte-order-mark (BOM) which consists of the two bytes 0xFF and 0xFE in
/// in UTF-16 encoding.
#define nU16BOMLen 2

//#define LOG_CREATES

//#define SETH_16OCT15

#ifdef _UNICODE

/// The UTF-8 byte-order-mark (BOM) consists of the three bytes 0xEF, 0xBB and 0xBF
/// in UTF-8 encoding. Some applications like Notepad prefix UTF-8 files with
/// this BOM.
//static wxUint8 szBOM[nBOMLen] = {0xEF, 0xBB, 0xBF}; // MFC uses BYTE

/// The UTF-16 byte-order-mark (BOM) which consists of the two bytes 0xFF and 0xFE in
/// in UTF-16 encoding.
//static wxUint8 szU16BOM[nU16BOMLen] = {0xFF, 0xFE}; // MFC uses BYTE

#endif

/// This global boolean informs the Doc's BackupDocument() function whether a split or
/// join operation is in progress. If gbDoingSplitOrJoin is TRUE BackupDocument() exits
/// immediately without performing any backup operations. Split operations especially
/// could produce a plethora of backup docs, especially for a single-chapters document split.
bool gbDoingSplitOrJoin = FALSE; // TRUE during one of these 3 operations

/// This global is defined in DocPage.cpp.
extern bool gbMismatchedBookCode; // BEW added 21Mar07

// This global is defined in Adapt_It.cpp.
//extern bool	gbTryingMRUOpen; // whm 1Oct12 removed

/// This global is defined in MainFrm.cpp.
extern bool gbIgnoreScriptureReference_Receive;

/// This global is used only in RetokenizeText() to increment the number n associated with
/// the final number n composing the "Rebuild Logn.txt" files, which inform the user of
/// any problems encountered during document rebuilding.
int gnFileNumber = 0; // used for output of Rebuild Logn.txt file, to increment n each time

/// This global is defined in TransferMarkersDlg.cpp.
extern bool gbPropagationNeeded;

/// This global is defined in TransferMarkersDlg.cpp.
extern TextType gPropagationType;

/// This global is defined in Adapt_ItView.cpp.
extern bool gbIsUnstructuredData;

// next four are for version 2.0 which includes the option of a 3rd line for glossing

/// This global is defined in Adapt_ItView.cpp.
extern bool	gbIsGlossing; // when TRUE, the phrase box and its line have glossing text

/// This global is defined in Adapt_ItView.cpp.
extern bool	gbGlossingVisible; // TRUE makes Adapt It revert to Shoebox functionality only

/// This global is defined in Adapt_ItView.cpp.
extern bool gbGlossingUsesNavFont;

// This global is defined in DocPage.cpp.
//extern bool  gbForceUTF8; // defined in CDocPage // not used within Adapt_ItDoc.cpp

/// This global is defined in Adapt_It.cpp.
extern wxChar gSFescapechar; // the escape char used for start of a standard format marker

// BEW 8Jun10, removed support for checkbox "Recognise standard format
// markers only following newlines"
// This global is defined in Adapt_It.cpp.
//extern bool  gbSfmOnlyAfterNewlines;

/// This global is defined in Adapt_It.cpp.
extern bool  gbDoingInitialSetup;

/// This global is defined in Adapt_It.cpp.
extern CAdapt_ItApp* gpApp; // if we want to access it fast

/// Indicates if a source word or phrase is to be considered special text when the propagation
/// of text attributes needs to be considered as after editing the source text or after rebuilding
/// the source text subsequent to filtering changes. Normally used to set or store the m_bSpecialText
/// attribute of a source phrase instance.
bool   gbSpecialText = FALSE;

/// This global is defined in Adapt_ItView.cpp.
extern CSourcePhrase* gpPrecSrcPhrase;

/// This global is defined in Adapt_ItView.cpp.
extern CSourcePhrase* gpFollSrcPhrase;

/// This global is defined in Adapt_ItView.cpp.
extern	bool	gbShowTargetOnly;

/// This global is defined in Adapt_ItView.cpp.
extern	int		gnSaveLeading;

/// Indicates if the user has cancelled an operation.
bool	bUserCancelled = FALSE;

// This global is defined in Adapt_It.cpp.
//extern	bool	gbViaMostRecentFileList; // whm removed 1Oct12

/// This global is defined in Adapt_ItView.cpp.
extern	bool	gbConsistencyCheckCurrent;

// This global is defined in Adapt_It.cpp.
//extern	bool	gbAbortMRUOpen; // whm 1Oct12 removed

/// This global is defined in Adapt_It.cpp.
extern wxString szProjectConfiguration;

/// This global is defined in Adapt_It.cpp.
extern wxString szAdminProjectConfiguration;

/// This global is defined in Adapt_It.cpp.
extern bool gbHackedDataCharWarningGiven;

// next group for auto-capitalization support; defined in Adapt_It.cpp around line 660+/-
extern bool	gbAutoCaps;
extern bool	gbSourceIsUpperCase;
extern bool	gbNonSourceIsUpperCase;
extern bool	gbNoSourceCaseEquivalents;
extern bool	gbNoTargetCaseEquivalents;
extern bool	gbNoGlossCaseEquivalents;
extern wxChar gcharNonSrcLC;
extern wxChar gcharNonSrcUC;
extern wxChar gcharSrcLC;
extern wxChar gcharSrcUC;
extern bool   gbUCSrcCapitalAnywhere; // TRUE if searching for captial at non-initial position
							   // is enabled, FALSE is legacy initial position only
extern int    gnOffsetToUCcharSrc; // offset to source text location where the upper case
							// character was found to be located, wxNOT_FOUND if not located

//bool	gbIgnoreIt = FALSE; // used when "Ignore it (do nothing)" button was hit
							// in consistency check dlg

// whm added 6Apr05 for support of export filtering of sfms and RTF output of the same in
// the appropriate functions in the Export-Import file, etc. These globals are defined
// in ExportSaveAsDlg.cpp
extern wxArrayString m_exportMarkerAndDescriptions;
extern wxArrayString m_exportBareMarkers;
extern wxArrayInt m_exportFilterFlags;
extern wxArrayInt m_exportFilterFlagsBeforeEdit;

extern bool gbIsUnstructuredData;
// BEW 12Sep22 earlier, I had the comment for each of \w and \w*: " \w removed, it's a special case "  but removal of \w and \w*
// led to a parsing failure for source text \w ensel\\w*  (indicating ensel 'angel') was to be in the glossary. The failure crashed
// the TokenizeText() parse, and so Steve White could not create a perfectly normal source text with that data in it. So I've
// refactored, so that there is a new function in the Doc class  bool IsWmkrWithBar(wxChar* ptr) where ptr points to where the
// parsing has gotten to in the input source text's buffer. If there is a bar following a \w marker's text, then return TRUE, all
// other possibilities return FALSE. (and flag bit 22, m_bUnused in CSourcePhrase is set to 1 if pupat has cacheable content).
// Now it's no longer necessary to remove \w from the fast access string, as the choice of control's path can now be controlled
// by the value returned by IsWmkrWithBar(wxChar* ptr).
// 
// whm 24Oct2023 comment update: The IsWmkrWithBar() function mentioned above is not used anywhere in code.
//	Note: The USFM docs define \\qt-s,  \\qt-e, \\qt-s\\*, \\qt-e\\*, and \\* as starting and ending "milestones" usually 
//	marking the beginning and ending of a quotation/speaker. They can also employ a bar | character to separate the attribute 
//	parts, usually with no text to left of the bar except for the begin marker.

// support for USFM and SFM Filtering
// Since these special filter markers will be visible to the user in certain dialog
// controls, I've opted to use marker labels that should be unique (starting with \~) and
// yet still recognizable by containing the word 'FILTER' as part of their names.

/// A marker string used to signal the beginning of filtered material stored in a source
/// phrase's m_filteredInfo member.
wxString filterMkr = _T("\\~FILTER"); //const wxString filterMkr = _T("\\~FILTER"); // whm 9Jun12 removed const

/// A marker string used to signal the end of filtered material stored in a source phrase's
/// m_filteredInfo member.
wxString filterMkrEnd = _T("\\~FILTER*"); //const wxString filterMkrEnd = _T("\\~FILTER*"); // whm 9Jun12 removed const

/////////////////////////////////////////////////////////////////////////////
// CAdapt_ItDoc

IMPLEMENT_DYNAMIC_CLASS(CAdapt_ItDoc, wxDocument)

BEGIN_EVENT_TABLE(CAdapt_ItDoc, wxDocument)

// The events that are normally handled by the doc/view framework use predefined
// event identifiers, i.e., wxID_NEW, wxID_SAVE, wxID_CLOSE, wxID_OPEN, etc.
EVT_MENU(wxID_NEW, CAdapt_ItDoc::OnFileNew)
EVT_MENU(wxID_SAVE, CAdapt_ItDoc::OnFileSave)
EVT_UPDATE_UI(wxID_SAVE, CAdapt_ItDoc::OnUpdateFileSave)

EVT_MENU(ID_FILE_SAVE_COMMIT, CAdapt_ItDoc::OnSaveAndCommit)
EVT_UPDATE_UI(ID_FILE_SAVE_COMMIT, CAdapt_ItDoc::OnUpdateDVCS_item)
EVT_MENU(ID_FILE_REVERT_FILE, CAdapt_ItDoc::OnShowPreviousVersions)
EVT_UPDATE_UI(ID_FILE_REVERT_FILE, CAdapt_ItDoc::OnUpdateDVCS_item)
EVT_MENU(ID_FILE_LIST_VERSIONS, CAdapt_ItDoc::OnShowFileLog)
EVT_UPDATE_UI(ID_FILE_LIST_VERSIONS, CAdapt_ItDoc::OnUpdateDVCS_item)
EVT_MENU(ID_FILE_TAKE_OWNERSHIP, CAdapt_ItDoc::OnTakeOwnership)
EVT_UPDATE_UI(ID_FILE_TAKE_OWNERSHIP, CAdapt_ItDoc::OnUpdateTakeOwnership)
EVT_MENU(ID_DVCS_VERSION, CAdapt_ItDoc::OnDVCS_Version)
//    EVT_UPDATE_UI(ID_DVCS_VERSION, CAdapt_ItDoc::OnUpdateDVCS_item) - now leaving this one always enabled.

EVT_MENU(wxID_CLOSE, CAdapt_ItDoc::OnFileClose)
EVT_UPDATE_UI(wxID_CLOSE, CAdapt_ItDoc::OnUpdateFileClose)
EVT_MENU(ID_SAVE_AS, CAdapt_ItDoc::OnFileSaveAs)
EVT_UPDATE_UI(ID_SAVE_AS, CAdapt_ItDoc::OnUpdateFileSaveAs)
EVT_MENU(wxID_OPEN, CAdapt_ItDoc::OnFileOpen)
EVT_MENU(ID_TOOLS_SPLIT_DOC, CAdapt_ItDoc::OnSplitDocument)
EVT_UPDATE_UI(ID_TOOLS_SPLIT_DOC, CAdapt_ItDoc::OnUpdateSplitDocument)
EVT_MENU(ID_TOOLS_JOIN_DOCS, CAdapt_ItDoc::OnJoinDocuments)
EVT_UPDATE_UI(ID_TOOLS_JOIN_DOCS, CAdapt_ItDoc::OnUpdateJoinDocuments)
EVT_MENU(ID_TOOLS_MOVE_DOC, CAdapt_ItDoc::OnMoveDocument)
EVT_UPDATE_UI(ID_TOOLS_MOVE_DOC, CAdapt_ItDoc::OnUpdateMoveDocument)
EVT_UPDATE_UI(ID_FILE_PACK_DOC, CAdapt_ItDoc::OnUpdateFilePackDoc)
EVT_UPDATE_UI(ID_FILE_UNPACK_DOC, CAdapt_ItDoc::OnUpdateFileUnpackDoc)
EVT_MENU(ID_FILE_PACK_DOC, CAdapt_ItDoc::OnFilePackDoc)
EVT_MENU(ID_FILE_UNPACK_DOC, CAdapt_ItDoc::OnFileUnpackDoc)
EVT_MENU(ID_EDIT_CONSISTENCY_CHECK, CAdapt_ItDoc::OnEditConsistencyCheck)
EVT_MENU(ID_EDITMENU_CHANGE_PUNCTS_MKRS_PLACE, CAdapt_ItDoc::OnChangePunctsOrMarkersPlacement)
EVT_UPDATE_UI(ID_EDIT_CONSISTENCY_CHECK, CAdapt_ItDoc::OnUpdateEditConsistencyCheck)
EVT_UPDATE_UI(ID_EDITMENU_CHANGE_PUNCTS_MKRS_PLACE, CAdapt_ItDoc::OnUpdateChangePunctsOrMarkersPlacement)
EVT_MENU(ID_ADVANCED_RECEIVESYNCHRONIZEDSCROLLINGMESSAGES, CAdapt_ItDoc::OnAdvancedReceiveSynchronizedScrollingMessages)
EVT_UPDATE_UI(ID_ADVANCED_RECEIVESYNCHRONIZEDSCROLLINGMESSAGES, CAdapt_ItDoc::OnUpdateAdvancedReceiveSynchronizedScrollingMessages)
EVT_MENU(ID_ADVANCED_SENDSYNCHRONIZEDSCROLLINGMESSAGES, CAdapt_ItDoc::OnAdvancedSendSynchronizedScrollingMessages)
EVT_UPDATE_UI(ID_ADVANCED_SENDSYNCHRONIZEDSCROLLINGMESSAGES, CAdapt_ItDoc::OnUpdateAdvancedSendSynchronizedScrollingMessages)

// whm added 10Jul2015 for temporary testing of the CCollabVerseConflictDlg dialog
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//	EVT_MENU(ID_VERSE_CONFLICT_DLG, CAdapt_ItDoc::OnVerseConflictDlg)
//	EVT_UPDATE_UI(ID_VERSE_CONFLICT_DLG, CAdapt_ItDoc::OnUpdateVerseConflictDlg)
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

END_EVENT_TABLE()


/////////////////////////////////////////////////////////////////////////////
// CAdapt_ItDoc construction/destruction

/// **** DO NOT PUT INITIALIZATIONS IN THE DOCUMENT'S CONSTRUCTOR *****
/// **** ONLY INITIALIZATIONS OF DOCUMENT'S PRIVATE MEMBERS SHOULD ****
/// **** BE DONE HERE; DO OTHER INITIALIZATIONS IN THE APP'S      *****
/// **** OnInit() METHOD                                          *****
CAdapt_ItDoc::CAdapt_ItDoc()
{
	m_bHasPrecedingStraightQuote = FALSE;   // this one needs to be initialized to
											// FALSE every time a doc is recreated
	m_bLegacyDocVersionForSaveAs = FALSE;   // whm added 14Jan11
	m_bReopeningAfterClosing = FALSE;       // mrh Oct12 - normal default

	m_bIsWithinUnfilteredInlineSpan = FALSE; // initialization, for things like
											 // \xt embedded within unfiltered footnote
	m_bIsWithinCrossRef_X_Span = FALSE; // whm 4Mar2024 added
	m_strUnfilteredInlineBeginMarker = wxEmptyString; // for temporary store of, say,
							// \f awaiting ptr coming to \f* where the above bool
							// needs to be made FALSE if it was TRUE
	m_bWithinMkrAttributeSpan = FALSE; // FOR USFM3 support, should start off FALSE

	// whm 5Jan2024 added. We will assume the SetupUsfmStructArrayAndFile() succeeded
	// in has access to the <filename>.usfmstruct file and its m_UsfmStructArr structure
	// here on the Doc. If the SetupUsfmStructArrayAndFile() returns FALSE, the code
	// sets this flag to FALSE, and the assistance that the usfm structure will be
	// unavailble for usfm ordering during usfm filtering operations.
	m_bUsfmStructEnabled = TRUE; 

	// whm 24Dec2019 moved the following initialization here from Adapt_ItDoc.h
	// using _T('°') to represent the degree character \u00B0 causes a compiler warning 
	// "warning C4066: characters beyond first in wide-character constant ignored", so
	// I've changed the representation to _T('\u00B0').
	uselessDegreeChar = _T('\u00B0'); //uselessDegreeChar = _T('°');
	m_strBar = _T("|");
	m_strSpace = _T(" ");
	m_asterisk = _T('*');
	m_barChar = _T('|');
	m_strInitialPuncts = wxString::FromUTF8("“‘\"[(<{«¿¡—"); // 11 of them

	// whm 28Sep2023 added initialization of following here in the Doc's constructor
	// See comments in the PlacePhraseBox() function 
	m_bWithinEmptyMkrsLoop = FALSE; // set TRUE when entering, FALSE when exiting

	// WX Note: Nearly all Doc constructor initializations moved to the App
	// **** DO NOT PUT INITIALIZATIONS HERE IN THE DOCUMENT'S CONSTRUCTOR *****
	// **** ONLY INITIALIZATIONS OF DOCUMENT'S PRIVATE MEMBERS SHOULD     *****
	// **** BE DONE HERE; DO OTHER INITIALIZATIONS IN THE APP'S           *****
	// **** OnInit() METHOD  - but some exceptions are permitted          *****
}


/// **** ALL CLEANUP SHOULD BE DONE IN THE APP'S OnExit() METHOD ****
CAdapt_ItDoc::~CAdapt_ItDoc() // from MFC version
{
	// **** ALL CLEANUP SHOULD BE DONE IN THE APP'S OnExit() METHOD ****
}

///////////////////////////////////////////////////////////////////////////////
/// \return TRUE if new document was created successfully, FALSE otherwise
/// \remarks
/// Called from: the DocPage's OnWizardFinish() function.
/// In OnNewDocument, we aren't creating the document via serialization
/// of data from persistent storage (as does OnOpenDocument()), rather
/// we are creating the new document from scratch, by doing the following:
/// 1. Making sure our working directory is set properly.
/// 2. Calling parts of the virtual base class wxDocument::OnNewDocument() method
/// 3. Create the buffer and list structures that will hold our data
/// 4. Providing KB strm_bIsWithinUnfilteredInlineSpanuctures are ready, call GetNewFile() to get
///    the sfm file for import into our app.
/// 5. Get an output file name from the user.
/// 6. Tidy up the frame's window title.
/// 7. Create/Recreate the list of paired source and target punctuation
///    correspondences, updating also the View's punctuation settings
/// 8. Remove any Ventura Publisher optional hyphens from the text buffer.
/// 9. Call TokenizeText, which separates the text into words, stores them
///    in m_pSourcePhrases list and returns the number
/// 10. Calculate the App's text heights, and get the View to calculate
///     its initial indices and do its RecalcLayout()
/// 11. Show/place the initial phrasebox at first empty target slot
/// 12. Keep track of sequence numbers and set initial global src phrase
///     node position.
/// 13. [added] call OnInitialUpdate() which needs to be called before the
///     view is shown.
/// BEW added 13Nov09: call of m_bReadOnlyAccess = SetReadOnlyProtection(), in order to give
/// the local user in the project ownership for writing permission (if FALSE is returned)
/// or READ-ONLY access (if TRUE is returned). (Also added to LoadKB() and OnOpenDocument()
/// and OnCreate() for the view class.)
///////////////////////////////////////////////////////////////////////////////

//void CAdapt_ItDoc::OnUpdateVerseConflictDlg(wxUpdateUIEvent& event)
//{
//	event.Enable(TRUE);
//}
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


bool CAdapt_ItDoc::OnNewDocument()
// amended for support of glossing or adapting
{
	// BEW 30May17 next two initializations, also in CAdapt_ItDoc creator
	m_bIsWithinUnfilteredInlineSpan = FALSE; // initialization, for things like
											 // \xt embedded within unfiltered footnote
	m_bIsWithinUnfilteredInlineSpan = FALSE; 
	m_strUnfilteredInlineBeginMarker = wxEmptyString; // for temporary store of, say,
													  // \f awaiting ptr coming to \f* where the above bool
													  // needs to be made FALSE if it was TRUE
	// refactored 10Mar09
	CAdapt_ItApp* pApp = GetApp();
	pApp->m_nSaveActiveSequNum = 0; // reset to a default initial value, safe for any length of doc

#if defined (_DEBUG)
	// BEW 24Oct22 track the pApp->m_bParsingSource value, where goes TRUE and back to FALSE
	wxLogDebug(_T("%s::%s(), line %d : app->m_bParsingSource = %d"), __FILE__, __FUNCTION__, __LINE__, (int)gpApp->m_bParsingSource);
#endif

	// Initialize m_bTokenizingTargetText to FALSE
	m_bTokenizingTargetText = FALSE; // assumes will be parsing source text

#if defined(_DEBUG) && defined (FIXORDER)
	wxLogDebug(_T("OnNewDocument line %d  m_bTokenizingTargetText = %d"),
		__LINE__, (int)m_bTokenizingTargetText);
#endif
	// BEW 16Aug16, Restore the default, which is Shift_Launch no longer on, if it was on
	pApp->m_bDoNormalProjectOpening = TRUE;

	pApp->m_owner = pApp->m_strUserID;  // this is our doc
	pApp->m_trialVersionNum = -1;		// negative means no trial going on - the normal case

	// BEW changed 9Apr12, support discontinuous auto-inserted spans highlighting
	gpApp->m_pLayout->ClearAutoInsertionsHighlighting();

	// get a pointer to the view
	CAdapt_ItView* pView = (CAdapt_ItView*)pApp->GetView();
	wxASSERT(pView->IsKindOf(CLASSINFO(CAdapt_ItView)));

	// BEW comment 6May09 -- this OnInitialUpdate() call contains a RecalcLayout() call
	// within its call of OnSize() call. If the RecalcLayout() call is late enough, it can
	// try the recalculation while piles do not exist, leading to a crash. So I've moved
	// OnInitialUpdate() to be early in OnNewDocument() and protected from a crash by
	// having the recalculation do nothing at all with the layout until all the layout
	// components are in place... (moved here from end of function)
	//
	// whm added OnInitialUpdate(), since in WX the doc/view framework doesn't call it
	// automatically we need to call it manually here. MFC calls its OnInitialUpdate()
	// method sometime after exiting its OnNewDocument() and before showing the View. See
	// Notes at OnInitialUpdate() for more info.
	pView->OnInitialUpdate(); // need to call it here because wx's doc/view doesn't
								// automatically call it

	// force m_bookName_Current to be empty -- it will stay empty unless set from what is
	// stored in a document just loaded; or in collaboration mode by copying to it the
	// value of the m_CollabBookSelected member; or doing an export of xhtml or for
	// Pathway export, no book name is current and the user fills one out using the
	// CBookName dialog which opens for that purpose
	gpApp->m_bookName_Current.Empty();

	// whm 26Jul11 revised. When m_lastSourceInputPath is empty, use the special folder
	// __SOURCE_INPUTS. See similar code in DocPage.cpp::OnWizardFinish().
	wxString dirPath;
	if (pApp->m_lastSourceInputPath.IsEmpty())
	{
		if (!pApp->m_curProjectPath.IsEmpty())
			dirPath = pApp->m_curProjectPath + pApp->PathSeparator + pApp->m_sourceInputsFolderName; // __SOURCE_INPUTS
		else
			dirPath = pApp->m_workFolderPath; // typically, C:\Users\<userName>\Documents\Adapt It <Unicode> Work

	}
	else
	{
		dirPath = pApp->m_lastSourceInputPath; // from the path that was last used
	}
	bool bOK;
	// whm 8Apr2021 added wxLogNull block below
	{
		wxLogNull logNo;	// eliminates any spurious messages from the system if the wxSetWorkingDirectory() call returns FALSE
		bOK = ::wxSetWorkingDirectory(dirPath);
	} // end of wxLogNull scope

	// the above may have failed, so if so use m_workFolderPath as the folder,
	// so we can proceed to the file dialog safely
	if (!bOK)
	{
		dirPath = pApp->m_workFolderPath;
		pApp->m_lastSourceInputPath = dirPath;
		// whm 8Apr2021 added wxLogNull block below
		{
			wxLogNull logNo;	// eliminates any spurious messages from the system if the wxSetWorkingDirectory() call returns FALSE
			bOK = ::wxSetWorkingDirectory(dirPath); // this should work, since m_workFolderPath can hardly be wrong!
		} // end of wxLogNull scope
		if (!bOK)
		{
			if (!bOK)
			{
				// we should never get a failure for the above, so just an English message will do
				wxString msg = _T("OnNewDocument() failed, when setting current directory to:\n%s");
				msg = msg.Format(msg, dirPath.c_str());
				wxMessageBox(msg, _T(""), wxICON_ERROR | wxOK);
				pApp->LogUserAction(msg);

				pApp->m_bDocumentDestroyed = FALSE; // re-initialize (to permit DoAutoSaveDoc() to work)
				
				return TRUE; // BEW 25Aug10, never return FALSE from OnNewDocument() if
							 // you want the doc/view framework to keep working right
			}
		}
	}

	//if (!wxDocument::OnNewDocument()) // don't use this because it calls OnCloseDocument()
	//	return FALSE;
	// whm NOTES: The wxWidgets base class OnNewDocument() calls OnCloseDocument()
	// which fouls up the KB structures due to the OnCloseDocument() calls to
	// EraseKB(), etc. To get around this problem which arises because of
	// different calling orders in the two doc/view frameworks, we'll not
	// call the base class wxDocument::OnNewDocument() method in wxWidgets,
	// but instead we call the remainder of its contents here:
	// whm verified the need for this 20July2006
	DeleteContents();
	Modify(FALSE);
	SetDocumentSaved(FALSE);
	wxString name;
	// whm 13May12 modified for wxWidgets-2.9.3
	//GetDocumentManager()->MakeDefaultName(name);
	name = GetDocumentManager()->MakeNewDocumentName();
	SetTitle(name);
	SetFilename(name, TRUE);
	// above calls come from wxDocument::OnNewDocument()
	// Note: The OnSaveModified() call is handled when needed in
	// the Doc's Close() and/or OnOpenDocument()

   // (SDI documents will reuse this document)
	if (pApp->m_pBuffer != NULL)
	{
		delete pApp->m_pBuffer; // make sure wxString is not in existence
		pApp->m_pBuffer = (wxString*)NULL; // MFC had = 0
	}

	// BEW added 21Apr08; clean out the global struct gEditRecord & clear its deletion lists,
	// because each document, on opening it, it must start with a truly empty EditRecord; and
	// on doc closure and app closure, it likewise must be cleaned out entirely (the deletion
	// lists in it have content which persists only for the life of the document currently open)
	pView->InitializeEditRecord(gEditRecord);
	if (!gEditRecord.deletedAdaptationsList.IsEmpty())
		gEditRecord.deletedAdaptationsList.Clear(); // remove any stored deleted adaptation strings
	if (!gEditRecord.deletedGlossesList.IsEmpty())
		gEditRecord.deletedGlossesList.Clear(); // remove any stored deleted gloss strings
	if (!gEditRecord.deletedFreeTranslationsList.IsEmpty())
		gEditRecord.deletedFreeTranslationsList.Clear(); // remove any stored deleted free translations


	int width = wxSystemSettings::GetMetric(wxSYS_SCREEN_X);
#ifdef _RTL_FLAGS
	pApp->m_docSize = wxSize(width - 40, 600); // a safe default width, the length doesn't matter
											  // (it will change shortly)
#else
	pApp->m_docSize = wxSize(width - 80, 600); // ditto
#endif

	// need a SPList to store the source phrases
	if (pApp->m_pSourcePhrases == NULL)
		pApp->m_pSourcePhrases = new SPList;
	wxASSERT(pApp->m_pSourcePhrases != NULL);


	bool bKBReady = FALSE;
	if (gbIsGlossing)
		bKBReady = pApp->m_bGlossingKBReady;
	else
		bKBReady = pApp->m_bKBReady;
	if (bKBReady)
	{
		pApp->m_nActiveSequNum = -1; // default, till positive value on layout of file

		pApp->m_pBuffer = new wxString; // on the heap, because this could be a large block of source text
		wxASSERT(pApp->m_pBuffer != NULL);
		pApp->m_nInputFileLength = 0;
		wxString filter = _T("*.*");
		wxString fileTitle = _T(""); // stores name (including extension) of user's
				// chosen source file; however, when taken into the COutFilenameDlg
				// dialog below, the latter's InitDialog() call strips off any
				// filename extension before showing what's left to the user
		wxString pathName; // stores the path (including filename & extension) to the
						   // chosen input source text file to be used for doc create

		// The following wxFileDialog part was originally in GetNewFile(), but moved here
		// 19Jun09 to consolidate file error message processing.
		wxString defaultDir;
		if (gpApp->m_lastSourceInputPath.IsEmpty())
		{
			defaultDir = gpApp->m_workFolderPath;
		}
		else
		{
			defaultDir = gpApp->m_lastSourceInputPath;
		}

		// BEW addition, 15Aug10, test for user navigation protection feature turned on,
		// and if so, show the monocline list of files in the __SOURCE_INPUTS folder only,
		// otherwise, show the standard File Open dialog, wxFileDialog, supplied by
		// wxWidgets which allows the user to navigate the hierarchical file/folder system
		// BEW 22Aug10, included m_bShowAdministratorMenu in the test, so that we don't
		// make the administrator have the __SOURCE_INPUTS folder restriction and
		// navigation-protection feature be forced on him when the Administrator menu is
		// visible. I've also put a conditional compile here so that when the developer is
		// debugging, he can choose which behaviour he wants for testing purposes
		//
		// whm modified 16Aug11. When the __SOURCE_INPUTS folder is NOT protected we need
		// to bypass the call to UseSourceDataFolderOnlyForInputFiles()
		bool bUseSourceDataFolderOnly;
		if (gpApp->m_bProtectSourceInputsFolder)
		{
			bUseSourceDataFolderOnly = gpApp->UseSourceDataFolderOnlyForInputFiles();
		}
		else
		{
			bUseSourceDataFolderOnly = FALSE;
		}
		bool bUserNavProtectionInForce = FALSE;
#ifdef _DEBUG
		// un-comment out the next line to have navigation protection for loading source
		// text files turned on when debugging only provided the administrator menu is not
		// showing - this is the way it is in the distributed application, that is, even
		// if user navigation protection is on, making the administrator menu visible will
		// override the 'on' setting so that the legacy File Open dialog is used; and
		// making the administrator menu invisible again automatically restores user
		// navigation protection to being 'on'

		//if (bUseSourceDataFolderOnly && !gpApp->m_bShowAdministratorMenu)

		// un-comment out the next line to have navigation protection for loading source
		// text files turned on when debugging, whether or not administrator menu is
		// visible; and comment out the line above
		bUserNavProtectionInForce = FALSE; // use this for allowing or suppressing
		// the COutputFilenameDlg further below, depending on whether the legacy
		// File New dialog is used, or the NavProtectNewDoc's dialog, respectively

		if (bUseSourceDataFolderOnly)
#else
		if (bUseSourceDataFolderOnly && !gpApp->m_bShowAdministratorMenu)
#endif
		{
			// This block encapsulates user file/folder navigation protection, by showing
			// to the user only all, or a subset of, the files in the monocline list of
			// files in the folder named "__SOURCE_INPUTS" within the current project's folder.
			// All the user can do is either Cancel, or select a single file to be loaded
			// as a new adaptation document, no navigation functionality is provided here
			bUserNavProtectionInForce = TRUE;

			gpApp->m_sortedLoadableFiles.Clear(); // we always recompute the array every
				// time the user tries to create a new document, because the administrator
				// may have added new source text files to the '__SOURCE_INPUTS' folder since
				// the time of the last document creation attempt
			gpApp->EnumerateLoadableSourceTextFiles(gpApp->m_sortedLoadableFiles,
				gpApp->m_sourceInputsFolderPath, filterOutUnloadableFiles);

			// now remove any array entries which have their filename title part
			// clashing with a document filename's title part (and book mode may be
			// currently on, so if it is we get the list of doc filenames from the
			// currently active bible book folder); to do this, first calculate the path
			// to the storage folder for the documents, and enumerate their filenames to a
			// wxArrayString local array, then call RemoveNameDuplicatesFromArray() to
			// compare the file titles and remove the duplicates
			wxString docsPath;
			if (gpApp->m_bBookMode && !gpApp->m_bDisableBookMode)
			{
				docsPath = gpApp->m_bibleBooksFolderPath; // path to a book folder within
														  // the "Adaptations" folder
			}
			else
			{
				docsPath = gpApp->m_curAdaptationsPath; // path to the "Adaptations"
													  // folder of the project
			}
			wxArrayString arrDocFilenames;
			gpApp->EnumerateDocFiles_ParametizedStore(arrDocFilenames, docsPath);
			// the following call removes any items from the first param's array which
			// have a duplicate file title for a filename in the second param's array;
			// the TRUE parameter is bSorted, we want the final list which the user sees
			// to be in alphabetical order (for Windows, a caseless compare is done, for
			// other operating systems, a case-sensitive compare is done - see the
			// sortCompareFunc() in helpers.cpp)
			RemoveNameDuplicatesFromArray(gpApp->m_sortedLoadableFiles, arrDocFilenames,
				TRUE, excludeExtensionsFromComparison);
			wxString strSelectedFilename;
			strSelectedFilename.Empty();
			// whm modified 1Feb2018. The NavProtectNewDoc dialog is a modal dialog and as
			// such it should not be created with a call to new and its heap pointer kept
			// on the App. As a modal dialog it should be just created on the stack here in
			// OnNewDocument(). On the GTK/Linux version we sometimes get a crash if a modal
			// dialog is created with the new command. Bruce's comment below about re "we
			// want the dialog handler's InitDialog() function called each time the dialog
			// it to be shown using ShowModal() so that the two buttons will be initialized
			// correctly" is not really applicable to this dialog. Therefore, to prevent
			// crashes in the GTK/Linux version, I've refactored the NavProtectNewDoc dialog
			// creation to be done the normal way, and removed the m_pNavProtectDlg pointers
			// from the app.

			// BEW 16Aug10, Note: we create the one and only instance of m_pNavProtectDlg here
			// rather than in the app's OnInit() function, because we want the dialog
			// handler's InitDialog() function called each time the dialog is to be shown using
			// ShowModal() so that the two buttons will be initialized correctly
			//wxWindow* docWindow = GetDocumentWindow();
			//gpApp->m_pNavProtectDlg = new NavProtectNewDoc(docWindow);
			NavProtectNewDoc navProtectDlg(gpApp->GetMainFrame());

#if defined (_DEBUG) && !defined(NOLOGS)
			// BEW 24Oct22 track the pApp->m_bParsingSource value, where goes TRUE and back to FALSE
			wxLogDebug(_T("%s::%s(), line %d : app->m_bParsingSource = %d"), __FILE__, __FUNCTION__, __LINE__, (int)gpApp->m_bParsingSource);
#endif

			// display the dialog, it's list of filenames is monocline & no navigation
			// capability is provided
			//if (gpApp->m_pNavProtectDlg->ShowModal() == wxID_CANCEL)
			if (navProtectDlg.ShowModal() == wxID_CANCEL)
			{
				// the user has hit the Cancel button
				wxASSERT(strSelectedFilename.IsEmpty());
				wxMessageBox(_(
					"Adapt It cannot do any useful work unless you select a source file to adapt. Please try again."),
					_T(""), wxICON_INFORMATION | wxOK);

				pApp->m_bDocumentDestroyed = FALSE; // re-initialize (to permit DoAutoSaveDoc() to work)

				// check if there was a document current, and if so, reinitialize everything
				if (pView != 0)
				{
					//if (gpApp->m_pNavProtectDlg != NULL) // whm 11Jun12 added NULL test
					//	delete gpApp->m_pNavProtectDlg;
					//gpApp->m_pNavProtectDlg = NULL;
					pApp->m_pTargetBox->GetTextCtrl()->SetValue(_T("")); // whm 12Jul2018 added GetTextCtrl()-> part
					if (pApp->m_pBuffer != NULL) // whm 11Jun12 added NULL test
						delete pApp->m_pBuffer;
					pApp->m_pBuffer = (wxString*)NULL; // MFC had = 0

					pView->Invalidate();
					GetLayout()->PlaceBox();
				}
				//return FALSE; BEW removed 24Aug10 as it clobbers part of the wxWidgets
				//doc/view black box on which we rely, leading to our event handlers
				//failing to be called, so return TRUE instead
				pApp->LogUserAction(_T("User cancelled OnNewDocument() while bUseSourceDataFolderOnly"));

				pApp->m_bZWSPinDoc = FALSE; // BEW 7Oct14, restore default

#if defined (_DEBUG) && !defined(NOLOGS)
	// BEW 24Oct22 track the pApp->m_bParsingSource value, where goes TRUE and back to FALSE
				wxLogDebug(_T("%s::%s(), line %d : app->m_bParsingSource = %d"), __FILE__, __FUNCTION__, __LINE__, (int)gpApp->m_bParsingSource);
#endif
				return TRUE;
			}
			else
			{
				// the user has hit the "Input file" button
				//strSelectedFilename = gpApp->m_pNavProtectDlg->GetUserFileName();
				strSelectedFilename = navProtectDlg.GetUserFileName();
				wxASSERT(!strSelectedFilename.IsEmpty());

				// the dialog handler can now be deleted and its point set to NULL
				//if (pApp->m_pNavProtectDlg != NULL) // whm 11Jun12 added NULL test
				//	delete gpApp->m_pNavProtectDlg;
				//pApp->m_pNavProtectDlg = NULL;

				// create the path to the selected file (m_sourceInputsFolderPath is always
				// defined when the app enters a project, as a folder "__SOURCE_INPUTS" which
				// is a direct child of the folder m_curProjectPath)
				pathName = gpApp->m_sourceInputsFolderPath + gpApp->PathSeparator + strSelectedFilename;
				wxASSERT(::wxFileExists(pathName));

				// set fileTitle to the selected file's name (including extension, as the
				// latter will be removed later below)
				fileTitle = strSelectedFilename;
			}
		} // end of TRUE block for test: if (bUseSourceDataFolderOnly)
		else
		{
			bool bGotLoadableFile = FALSE;
			int returnValue = -1;
			while (!bGotLoadableFile && returnValue != wxID_CANCEL)
			{
				// This block uses the legacy wxFileDialog call, which allows the user to
				// navigate the folder hierarchy to find loadable source text files anywhere
				// within any volume accessible to the system, there is no user navigation
				// protection in force if control enters this block
				wxFileDialog fileDlg(
					(wxWindow*)wxGetApp().GetMainFrame(), // MainFrame is parent window for file dialog
					_("Input Text File For Adaptation"),
					defaultDir,	// default dir (either m_workFolderPath, or m_lastSourceInputPath)
					_T(""),		// default filename
					filter,
					wxFD_OPEN); // | wxHIDE_READONLY); wxHIDE_READONLY deprecated in 2.6 - the checkbox is never shown
								// GDLC wxOPEN deprecated in 2.8
				fileDlg.Centre();
				// open as modal dialog
				int returnValue = fileDlg.ShowModal(); // MFC has DoModal()
				if (returnValue == wxID_CANCEL)
				{
					// user cancelled, so cancel the New... command, or <New Document> choice,
					// as the case may be -- either user choice will have caused
					// OnNewDocument() to be called
					wxMessageBox(_(
						"Adapt It cannot do any useful work unless you select a source file to adapt. Please try again."),
						_T(""), wxICON_INFORMATION | wxOK);

					pApp->m_bDocumentDestroyed = FALSE; // re-initialize (to permit DoAutoSaveDoc() to work)
														// check if there was a document current, and if so, reinitialize everything
					if (pView != 0)
					{
						pApp->m_pTargetBox->GetTextCtrl()->SetValue(_T("")); // whm 12Jul2018 added GetTextCtrl()-> part
						if (pApp->m_pBuffer != NULL) // whm 11Jun12 added NULL test
							delete pApp->m_pBuffer;

						pApp->m_pBuffer = (wxString*)NULL; // MFC had = 0
						pView->Invalidate();
						GetLayout()->PlaceBox();
					}
					//return FALSE; BEW removed 24Aug10 as it clobbers part of the wxWidgets
					//doc/view black box on which we rely, leading to our event handlers
					//failing to be called, so return TRUE instead
					pApp->LogUserAction(_T("User cancelled OnNewDocument() from wxFileDialog"));

					// BEW 7Oct14, restore default
					pApp->m_bZWSPinDoc = FALSE;
#if defined (_DEBUG) && !defined(NOLOGS)
					// BEW 24Oct22 track the pApp->m_bParsingSource value, where goes TRUE and back to FALSE
					wxLogDebug(_T("%s::%s(), line %d : app->m_bParsingSource = %d"), __FILE__, __FUNCTION__, __LINE__, (int)gpApp->m_bParsingSource);
#endif
					return TRUE;
				}
				else // must be wxID_OK
				{
					pathName = fileDlg.GetPath(); //MFC's GetPathName() and wxFileDialog.GetPath both get whole dir + file name.
					fileTitle = fileDlg.GetFilename(); // just the file name (including any extension)
					if (!IsLoadableFile(pathName))
					{
						wxFileName fn(pathName);
						wxString msg, title;
						title = _("Adapt It requires plain text files for input"); //
						msg = _("The following file:\n\n%s\n\nhas a %s extension which indicates that it is not loadable as an input file for Adapt It.\n\nPlease try again or click Cancel at the file selection dialog.");
						msg = msg.Format(msg, pathName.c_str(), fn.GetExt().c_str());
						wxMessageBox(msg, title, wxICON_EXCLAMATION | wxOK);
						pApp->LogUserAction(msg);
						bGotLoadableFile = FALSE;
					}
					else
					{
						bGotLoadableFile = TRUE;
					}

					pApp->m_bDocumentDestroyed = FALSE; // re-initialize (to permit DoAutoSaveDoc() to work)

				} // end of else wxID_OK
				  // & fileDlg goes out of scope here
			} // end of while
		} // end of else block for test: if (bUseSourceDataFolderOnly)

		// If control gets to here, (and it cannot do so if the user hit the Cancel
		// button), we've pathName and fileTitle wxString variables set ready for creating
		// the new document and getting an output document name from the user (the latter
		// calls COutFilenameDlg class, and it includes built-in invalid character
		// protection, and protection from a name conflict)
		wxFileName fn(pathName);
		wxString fnExtensionOnly = fn.GetExt(); // GetExt() returns the extension NOT including the dot
#if defined (_DEBUG) && !defined(NOLOGS)
	// BEW 24Oct22 track the pApp->m_bParsingSource value, where goes TRUE and back to FALSE
		wxLogDebug(_T("%s::%s(), line %d : app->m_bParsingSource = %d"), __FILE__, __FUNCTION__, __LINE__, (int)gpApp->m_bParsingSource);
#endif
		// BEW 24Oct22 !!! Prior to this date, gpApp->m_bParsingSource was nowhere set TRUE.
		// This should be a good place to rectify that omission
		pApp->m_bParsingSource = TRUE;
		 
		// get the file, and it's length (which includes null termination byte/s) whm
		// modified 18Jun09 GetNewFile() now returns an enum getNewFileState (see
		// Adapt_It.h) which more specifically reports the success or error state
		// encountered in getting the file for input. It now uses a switch() structure.
		switch (GetNewFile(pApp->m_pBuffer, pApp->m_nInputFileLength, pathName))
		{
		case getNewFile_success:
		{
			//wxString tempSelectedFullPath = fileDlg.GetPath(); BEW changed 15Aug10 to
			// remove the second call to fileDlg.GetPath() here, as pathName has the path
			wxString tempSelectedFullPath = pathName;

			// wxFileDialog.GetPath() returns the full path with directory and filename. We
			// only want the path part, so we also call ::wxPathOnly() on the full path to
			// get only the directory part.
			gpApp->m_lastSourceInputPath = ::wxPathOnly(tempSelectedFullPath);

			// Check if it has an \id line. If it does, get the 3-letter book code. If
			// a valid code is present, check that it is a match for the currently
			// active book folder. If it isn't tell the user and abort the <New
			// Document> operation, leaving control in the Document page of the wizard
			// for a new attempt with a different source text file, or a change of book
			// folder to be done and the same file reattempted after that. If it is a
			// matching book code, continue with setting up the new document.
			if (gpApp->m_bBookMode && !gpApp->m_bDisableBookMode)
			{
				// do the test only if Book Mode is turned on
				wxString strIDMarker = _T("\\id");
				int nPos = (*gpApp->m_pBuffer).Find(strIDMarker);
				if (nPos != -1)
				{
					// the marker is in the file, so we need to go ahead with the check, but first
					// work out what the current book folder is and then what its associated code is
					wxString aBookCode = ((BookNamePair*)(*gpApp->m_pBibleBooks)[gpApp->m_nBookIndex])->bookCode;
					wxString seeNameStr = ((BookNamePair*)(*gpApp->m_pBibleBooks)[gpApp->m_nBookIndex])->seeName;
					gbMismatchedBookCode = FALSE;

					// get the code by advancing over the white space after the \id marker, and then taking
					// the next 3 characters as the code
					const wxChar* pStr = gpApp->m_pBuffer->GetData();
					wxChar* ptr = (wxChar*)pStr;
					ptr += nPos;
					ptr += 4; // advance beyond \id and whatever white space character is next
					while (*ptr == _T(' ') || *ptr == _T('\n') || *ptr == _T('\r') || *ptr == _T('\t'))
					{
						// advance over any additional space, newline, carriage return or tab
						ptr++;
					}
					wxString theCode(ptr, 3);	// make a 3-letter code, but it may be rubbish as we can't be
												// sure there is actually a valid one there

					// test to see if the string contains a valid 3-letter code
					bool bMatchedBookCode = CheckBibleBookCode(gpApp->m_pBibleBooks, theCode);
					if (bMatchedBookCode)
					{
						// it matches one of the 67 codes known to Adapt It, so we need to check if it
						// is the correct code for the active folder; if it's not, tell the user and
						// go back to the Documents page of the wizard; if it is, just let processing
						// continue (the Title of a message box is just "Adapt It", only Palm OS permits naming)
						if (theCode != aBookCode)
						{
							// the codes are different, so the document does not belong in the active folder
							wxString aTitle;
							// IDS_INVALID_DATA_BOX_TITLE
							aTitle = _("Invalid Data For Current Book Folder");
							wxString msg1;
							// IDS_WRONG_THREELETTER_CODE_A
							msg1 = msg1.Format(_(
								"The source text file's \\id line contains the 3-letter code %s which does not match the 3-letter \ncode required for storing the document in the currently active %s book folder.\n"),
								theCode.c_str(), seeNameStr.c_str());
							wxString msg2;
							//IDS_WRONG_THREELETTER_CODE_B
							msg2 = _(
								"\nChange to the correct book folder and try again, or try inputting a different source text file \nwhich contains the correct code.");
							msg1 += msg2; // concatenate the messages
							wxMessageBox(msg1, aTitle, wxICON_EXCLAMATION | wxOK); // I want a title on this other than "Adapt It"
							gbMismatchedBookCode = TRUE;// tell the caller about the mismatch

							pApp->LogUserAction(msg1);

							pApp->m_bZWSPinDoc = FALSE; // BEW 6Oct14 restore default

							pApp->m_bDocumentDestroyed = FALSE; // re-initialize (to permit DoAutoSaveDoc() to work)

#if defined (_DEBUG) && !defined(NOLOGS)
	// BEW 24Oct22 track the pApp->m_bParsingSource value, where goes TRUE and back to FALSE
							wxLogDebug(_T("%s::%s(), line %d : app->m_bParsingSource = %d"), __FILE__, __FUNCTION__, __LINE__, (int)gpApp->m_bParsingSource);
#endif
							return TRUE; // returns to OnWizardFinish() in DocPage.cpp (BEW 24Aug10, if
										// that claim always is true, then no harm will be done;
										// but if it returns FALSE to the wxWidgets doc/view
										// framework, it partially clobbers the latter -- this can be
										// tested by returning FALSE here and then clicking the Open
										// icon button on the toolbar -- if that bypasses our event
										// handlers and just directly opens the "Select a file"
										// wxWidgets dialog, then the app is unstable and New and Open
										// whether on the File menu or as toolbar buttons will not
										// work right. In that case, we would need to return TRUE
										// here, not FALSE. BEW 22Jul16 made it TRUE)
						}
					}
					else
					{
						// not a known code, so we'll assume we accessed random text after the \id marker,
						// and so we just let processing proceed & the user can live with whatever happens
						;
					}
				}
				else
				{
					// if the \id marker is not in the source text file, then it is up to the user
					// to keep the wrong data from being stored in the current book folder, so all
					// we can do for that situation is to let processing proceed
					;
				}
			}

			pApp->m_bDocumentDestroyed = FALSE; // re-initialize (to permit DoAutoSaveDoc() to work)

			// get a suitable output filename for use with the auto-save feature
			// BEW 23Aug10, changed so that if user navigation protection is in force,
			// this dialog is not put up, and so the user will have no chance to change
			// the filename title to anything different that the filename title of the
			// input source text file used to create the dialog. This inability to change
			// the filename makes the filename list's bleeding behaviour work reliably as
			// the user successively creates documents - until when all docs have been
			// created that can be created from the files in the __SOURCE_INPUTS folder, the
			// list will be empty
			wxString strUserTyped;
			if (bUserNavProtectionInForce)
			{
				// don't let the user have any chance to alter the filename
				strUserTyped = fileTitle; // while the RHS suggests it's a fileTitle, it's
						// actually still got the filename extension on it (if there was
						// one there originally); it doesn't get removed until
						// SetDocumentWindowTitle() is called below
				// remove any extension user may have typed -- we'll keep control ourselves
				SetDocumentWindowTitle(strUserTyped, strUserTyped); // extensionless name is
											// returned as the last parameter in the signature
				// for XML output
				pApp->m_curOutputFilename = strUserTyped + _T(".xml");
				pApp->m_curOutputBackupFilename = strUserTyped + _T(".BAK");
			}
			else
			{
				// legacy behaviour, the file title can be user-edited or typed to be
				// anything he wants
				COutputFilenameDlg dlg(GetDocumentWindow());
				dlg.Centre();
				dlg.m_strFilename = fileTitle;
				if (dlg.ShowModal() == wxID_OK)
				{
					// get the filename
					strUserTyped = dlg.m_strFilename;

					// The COutputFilenameDlg::OnOK() handler checks for duplicate file
					// name or a file name with bad characters in it.
					// abort the operation if user gave no explicit or bad output filename
					if (strUserTyped.IsEmpty())
					{
						// warn user to specify a non-null document name with valid chars
						if (strUserTyped.IsEmpty())
							wxMessageBox(_(
								"Sorry, Adapt It needs an output document name. (An .xml extension will be automatically added.) Please try the New... command again."),
								_T(""), wxICON_INFORMATION | wxOK);

						// reinitialize everything
						pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(_T(""));
						if (pApp->m_pBuffer != NULL) // whm 11Jun12 added NULL test
							delete pApp->m_pBuffer;
						pApp->m_pBuffer = (wxString*)NULL; // MFC had = 0
						pApp->m_curOutputFilename = _T("");
						pApp->m_curOutputPath = _T("");
						pApp->m_curOutputBackupFilename = _T("");
						pView->Invalidate(); // our own

						GetLayout()->PlaceBox();
						//return FALSE; BEW removed 24Aug10 as it clobbers part of the wxWidgets
						//doc/view black box on which we rely, leading to our event handlers
						//failing to be called, so return TRUE instead

#if defined (_DEBUG) && !defined(NOLOGS)
	// BEW 24Oct22 track the pApp->m_bParsingSource value, where goes TRUE and back to FALSE
						wxLogDebug(_T("%s::%s(), line %d : app->m_bParsingSource = %d"), __FILE__, __FUNCTION__, __LINE__, (int)gpApp->m_bParsingSource);
#endif
						pApp->m_bZWSPinDoc = FALSE; // BEW 7Oct14 restore default

						return TRUE;
					}

					// remove any extension user may have typed -- we'll keep control
					// ourselves
					SetDocumentWindowTitle(strUserTyped, strUserTyped); // extensionless name
										// is returned as the last parameter in the signature

					// for XML output
					pApp->m_curOutputFilename = strUserTyped + _T(".xml");
					pApp->m_curOutputBackupFilename = strUserTyped + _T(".BAK");
				} // end of true block for test: if (dlg.ShowModal() == wxID_OK)
				else
				{
					// user cancelled, so cancel the New... command too
					wxMessageBox(_(
						"Sorry, Adapt It will not work correctly unless you specify an output document name. Please try again."),
						_T(""), wxICON_INFORMATION | wxOK);

					// reinitialize everything
					pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(_T(""));
					if (pApp->m_pBuffer != NULL) // whm 11Jun12 added NULL test
						delete pApp->m_pBuffer;
					pApp->m_pBuffer = (wxString*)NULL; // MFC had = 0
					pApp->m_curOutputFilename = _T("");
					pApp->m_curOutputPath = _T("");
					pApp->m_curOutputBackupFilename = _T("");

					pView->Invalidate();
					GetLayout()->PlaceBox();
					//return FALSE; BEW removed 24Aug10 as it clobbers part of the wxWidgets
					//doc/view black box on which we rely, leading to our event handlers
					//failing to be called, so return TRUE instead
					pApp->LogUserAction(_T("User canceled in OnNewDocument()"));

					pApp->m_bZWSPinDoc = FALSE; // BEW 7Oct14 restore default
#if defined (_DEBUG) && !defined(NOLOGS)
	// BEW 24Oct22 track the pApp->m_bParsingSource value, where goes TRUE and back to FALSE
					wxLogDebug(_T("%s::%s(), line %d : app->m_bParsingSource = %d"), __FILE__, __FUNCTION__, __LINE__, (int)gpApp->m_bParsingSource);
#endif

					return TRUE;
				} // end of else block for test: if (dlg.ShowModal() == wxID_OK)
			} // end of else block for test: if (bUserNavProtectionInForce)

			// BEW modified 11Nov05, because the SetDocumentWindowTitle() call now updates
			// the window title
			// Set the document's path to reflect user input; the destination folder will
			// depend on whether book mode is ON or OFF; likewise for backups if turned on
			if (gpApp->m_bBookMode && !gpApp->m_bDisableBookMode)
			{
				pApp->m_curOutputPath = pApp->m_bibleBooksFolderPath + pApp->PathSeparator
					+ pApp->m_curOutputFilename; // to send to the app when saving
												 // m_lastDocPath to config files
			}
			else
			{
				pApp->m_curOutputPath = pApp->m_curAdaptationsPath + pApp->PathSeparator
					+ pApp->m_curOutputFilename; // to send to the app when saving
												 // m_lastDocPath to config files
			}

			// Write the first couple log lines of our logging file to log the filename and 
			// date-time. Also write a line telling what function we are calling from.
			// See comments above the LogDocCreationData() function in the App for more details.
			// If there is a parse failure, it happened after the last m_srcPhrase in
			// this file. It is stored in the folder _LOGS_EMAIL_REPORTS in work folder
			// when "Make diagnostic logfile during document creation and opening" check box
			// is ticked in the docPage or the GetSourceTextFromEditor dialog.
			if (gpApp->m_bMakeDocCreationLogfile) // turn this ON in docPage of the Wizard or in GetSourceTextFromEditor dialog; it is OFF by default
			{
				// Construct the parameter string composed of the current output filename + date-time stamp for Now().
				wxString fileNameLine;
				wxDateTime theTime = wxDateTime::Now(); //initialize to the current time
				wxString timeStr;
				timeStr = theTime.Format();
				// whm 13Apr2020 changed to log whole path/name of doc being created/opened + date-time stamp
				fileNameLine = pApp->m_curOutputPath + _T(" ") + timeStr;
				gpApp->LogDocCreationData(fileNameLine);
				// whm 6Apr2020 the following m_bParsingSource is set TRUE during logging 
				// to prevent TokenizeText() from doing unwanted logging in other operations
				// where TokenizeText is used.
				gpApp->m_bParsingSource = TRUE;
				// whm 14Apr2020 added following log line to indicate source of Data
				gpApp->LogDocCreationData(_T("In OnNewDocument() logging Data via TokenizeText() below:"));
			}

			SetFilename(pApp->m_curOutputPath, TRUE);// TRUE notify all views
			Modify(FALSE);

			// BEW added 26Aug10. In case we are loading a marked up file we earlier
			// exported, our custom markers in the exported output would have been changed
			// to \z-prefixed forms, \zfree, \zfree*, \znote, etc. Here we must convert
			// back to our internal marker forms, which lack the 'z'. (The z was to support
			// Paratext import of data containing 3rd party markers unknown to
			// Paratext/USFM.)
			ChangeParatextPrivatesToCustomMarkers(*pApp->m_pBuffer);

			// remove any optional hyphens in the source text for use by Ventura Publisher
			 // (skips over any <-> sequences, and gives new m_pBuffer contents & new
			 // m_nInputFileLength value)
			RemoveVenturaOptionalHyphens(pApp->m_pBuffer);

			// whm wx version: moved the following OverwriteUSFMFixedSpaces and
			// OverwriteUSFMDiscretionaryLineBreaks calls here from within TokenizeText if
			// user requires, change USFM fixed spaces (marked by the ~ character) to a
			// space - this does not change the length of the data in the buffer
			if (gpApp->m_bChangeFixedSpaceToRegularSpace)
				OverwriteUSFMFixedSpaces(pApp->m_pBuffer);

			// Change USFM discretionary line breaks // to a pair of spaces. We do this
			// unconditionally because these types of breaks are not likely to be
			// located in the same place if allowed to pass through to the target text,
			// and are usually placed in the translation in the final typesetting
			// stage. This does not change the length of the data in the buffer.
			OverwriteUSFMDiscretionaryLineBreaks(pApp->m_pBuffer);

			// whm 1Sep2023 testing of function to normalize all EOLs to CRLF for non-collab
			// input of usfm text for parsing.
			NormalizeTextEOLsToCRLF(*pApp->m_pBuffer, TRUE);

#ifndef __WXMSW__
#ifndef _UNICODE
			// whm added 12Apr2007
			OverwriteSmartQuotesWithRegularQuotes(pApp->m_pBuffer);
#endif
#endif
			// BEW 16Dec10, added needed code to set gCurrentSfmSet to the current value
			// of the project's SfmSet. This code has been lacking from version 3 onwards
			// to 5.2.3 at least
			if (gpApp->gCurrentSfmSet != gpApp->gProjectSfmSetForConfig)
			{
				// the project's setting is not the same as the current setting for the
				// doc (the latter is either UsfmOnly if the app has just been launched,
				// as that is the default; or if there was some previous doc open, it has
				// the same value as that previous doc had)
				gpApp->gCurrentSfmSet = gpApp->gProjectSfmSetForConfig;
			}

			// whm 24Aug2018 added. A new document should initially adopt the App's gProjectFilterMarkersForConfig
			// as the document's gCurrentFilterMarkers for the new document. The user can change the
			// filter markers after document creation as desired, but the filter markers as set in the
			// project's filter marker list should be the initial default.
			gpApp->gCurrentFilterMarkers = gpApp->gProjectFilterMarkersForConfig;

			//#if defined(FWD_SLASH_DELIM)
			// BEW 23Apr15, if supporting / as a whitespace word-breaking character, preprocess
			// the input text to have no ZWSP in it, and to insert / at the correct places where
			// there is punctuation (since the users do not type it in such locations, so we do
			// it using CC table processing)
			*pApp->m_pBuffer = ZWSPtoFwdSlash(*pApp->m_pBuffer);
			*pApp->m_pBuffer = DoFwdSlashConsistentChanges(insertAtPunctuation, *pApp->m_pBuffer);
			//#endif
			
			// whm 15Nov2023 added. Here is where we should create the original .usfmstruct file
			// for a non-collab document that is being created from *pApp->m_pBuffer input text.
			// Note: This SetupUsfmStructArrayAndFile() should be called BEFORE the TokenizeText[String]()
			// call below. Then, there should be a call to UpdateCurrentFilterStatusOfUsfmStructFileAndArray()
			// AFTER the TokenizeText[String]() call below.
			bool bSetupOK;
			bSetupOK = SetupUsfmStructArrayAndFile(createNewFile, *pApp->m_pBuffer);
			wxUnusedVar(bSetupOK);

			//if (!bSetupOK)
			//{
			//	// Not likely to happen so an English message is OK.
			//	wxString msg = _T("Adapt It could not set up the Usfm Struct Array or the .usfmstruct file.\n\nThis may affect the ability of Adapt It to filter or unfilter adjacent markers in correct sequence.");
			//	wxMessageBox(msg, _T(""), wxICON_WARNING | wxOK);
			//	pApp->LogUserAction(msg);
			//	m_bUsfmStructEnabled = FALSE; // the usfm struct routines are disabled
			//}

			/*
			// whm 13Nov2023 added the following code to create a wxArrayString UsfmStructArr from 
			// the source input *pApp->m_pBuffer text, then save that array of strings to a file 
			// named <filename>.usfmstruct that is saved to a hidden sub-directory at the following 
			// path:
			// /Adapt It Unicode Work/<project-directory/Adaptations/.usfmstruct/<filename>.usfmstruct
			// where <filename> is the name of the document file being created via gpApp->m_curOutputPath
			// which already has an .xml extension. We add the additional extension .usfmstruct to 
			// the usfm struct file we're creating.
			// This usfm struct file will get updated with filter status fields in the 
			// UpdateCurrentFilterStatusOfUsfmStructFileAndArray() function call made after TokenizeText() is
			// called later below.
			m_usfmStructDirName = _T(".usfmstruct");
			wxFileName structFn(gpApp->m_curOutputPath);
			m_usfmStructFilePath = structFn.GetPath();
			m_usfmStructFileName = structFn.GetFullName(); // gets full name including extension, but excluding directories
			m_usfmStructDirPath = m_usfmStructFilePath + gpApp->PathSeparator + m_usfmStructDirName;
			if (!::wxDirExists(m_usfmStructDirPath))
			{
				// The hidden dir .usfmstruct doesn't exist yet so create it.
				bool bOK;
				bOK = ::wxMkdir(m_usfmStructDirPath);
				if (!bOK)
				{
					// failure to make the directory not expected so English message to the user log is sufficient
					wxString msg = _T("In OnNewDocument() - Failed to Create hidden directory at %s");
					msg = msg.Format(msg, m_usfmStructDirPath.c_str());
					gpApp->LogUserAction(msg);
				}
			}

			m_usfmStructFilePathAndName = m_usfmStructDirPath + gpApp->PathSeparator + m_usfmStructFileName + m_usfmStructDirName;
			// The wxArrayString m_UsfmStructArr array is on the Doc class, and its contents persist while a doc is open.
			m_UsfmStructArr = GetUsfmStructureAndExtent(*gpApp->m_pBuffer, TRUE);
			// Get the wxArrayString's lines and save them in the <filename>.usfmstruct file at:
			// .../Adapt It Unicode Work/<project-directory/Adaptations/.usfmstruct/<filename>.usfmstruct
			m_UsfmStructStringBuffer.Empty();
			size_t len = 0;
			// scan our array and determine its required character length including EOL chars
			int totCt = (int)m_UsfmStructArr.GetCount();
			for (int i = 0; i < totCt; i++)
			{
				m_UsfmStructStringBuffer = m_UsfmStructStringBuffer + m_UsfmStructArr.Item(i) + _T("\r\n");
				len += m_UsfmStructArr.Item(i).Length();
				len += 2; // for the EOLs _T("\r\n") to be added
			}

			// We should ensure it doesn't exist because we want to start afresh for a new usfmstruct file.
			if (::wxFileExists(m_usfmStructFilePathAndName))
			{
				bool bRemoved = FALSE;
				bRemoved = ::wxRemoveFile(m_usfmStructFilePathAndName);
				if (!bRemoved)
				{
					// Not likely to happen, so an English message will suffice.
					wxString msg = _T("Unable to remove existing usfmstruct file at:\n%s");
					msg = msg.Format(msg, m_usfmStructFilePathAndName.c_str());
					gpApp->LogUserAction(msg);
				}
			}
			
			// Write the usfmstruct string to the .usfmstruct file
			wxFile f;
			if (!f.Open(m_usfmStructFilePathAndName, wxFile::write))
			{
				wxString msg = _T("Failed f.Open() for writing usfmstruct info to %s");
				msg = msg.Format(msg, m_usfmStructFilePathAndName.c_str());
				gpApp->LogUserAction(msg);
			}
			else
			{
				f.Write(m_UsfmStructStringBuffer, len);
			}

			f.Close();
			*/

			// parse the input file
			// whm 6Apr2020 Note: If the parsing routine in TokenizeText() below crashes, is is NOT likely 
			// that the warning message below would ever be show to the user since the wxMessageBox that
			// displays the message below TokenizeText().
			int nHowMany;
			wxString msg = _("Aborting document creation. A significant parsing error occurred.\n\nThe most recent diagnostic log file named %s is in the __LOGS_EMAIL_REPORTS folder.\n\nThe last line in that diagnostic file shows the last source word/phrase processed before the error. Please send that diagnostic file to the developers.");
			msg = msg.Format(msg, gpApp->m_docCreationFilePathAndName);
			wxString msgEnglish = _T("Aborting document creation. A significant parsing error occurred.\n\nThe most recent diagnostic log file named %s is in the __LOGS_EMAIL_REPORTS folder.\n\nThe last line in that diagnostic file shows the last source word/phrase processed before the error. Please send that diagnostic file to the developers.");
			msgEnglish = msgEnglish.Format(msgEnglish, gpApp->m_docCreationFilePathAndName);
#if defined (_DEBUG) && !defined(NOLOGS)
			// BEW 24Oct22 track the pApp->m_bParsingSource value, where goes TRUE and back to FALSE
			wxLogDebug(_T("%s::%s(), line %d : app->m_bParsingSource = %d"), __FILE__, __FUNCTION__, __LINE__, (int)gpApp->m_bParsingSource);
#endif

			if (pApp->m_bMakeDocCreationLogfile)
			{
				// whm 6Apr2020 modified the CWaitDlg routine below. The TokenizeText() routine
				// takes more time now making it desirable to have a wait dialog show while the document
				// is being created. Logging the doc creation also takes time, so I've re-instituted the 
				// wait dialog to the outer block so that it will be visible during doc creation here - 
				// both for when logging and when not logging the doc creation.
#if defined(__WXMSW__)
				CWaitDlg waitDlg(pApp->GetMainFrame());
				// indicate we want the follwoing wait wait message
				waitDlg.m_nWaitMsgNum = 29;	// 29 has "Please wait while creating a new document - and creating a diagnostic log in folder _LOGS_EMAIL_REPORTS..."
				waitDlg.Centre();
				waitDlg.Show(TRUE);
				waitDlg.Update();
				// the wait dialog is automatically destroyed when it goes out of scope below
#endif
#if defined(_DEBUG) && defined (FIXORDER)
				wxLogDebug(_T("OnNewDocument line %d  m_bTokenizingTargetText = %d"),
					__LINE__, (int)m_bTokenizingTargetText);
#endif

#ifdef SHOW_DOC_I_O_BENCHMARKS
				wxDateTime dt1 = wxDateTime::Now(),
					dt2 = wxDateTime::UNow();
#endif
#if defined (_DEBUG) && !defined(NOLOGS)
				// BEW 24Oct22 track the pApp->m_bParsingSource value, where goes TRUE and back to FALSE
				wxLogDebug(_T("%s::%s(), line %d : app->m_bParsingSource = %d"), __FILE__, __FUNCTION__, __LINE__, (int)gpApp->m_bParsingSource);
#endif

				nHowMany = TokenizeText(0, pApp->m_pSourcePhrases, *pApp->m_pBuffer,
					(int)pApp->m_nInputFileLength);

				// whm 2Sep2023 testing below 
				// Add a call of the  DoMarkerHousekeeping() function here after TokenizeText()
				// code here directly copied from in the SetupLayoutAndView() function that gets
				// called when collaborating. This is to see if it removes the differences between
				// the xml docs created here in the non-collaboration scenario and the collaboration
				// scenario. The collaboration scenario had more correct xml encoding for certain
				// pSrcPhrase members including m_curTextType and m_inform.
				int unusedInt = 0;
				TextType dummyType = verse;
				bool bPropagationRequired = FALSE;
				pApp->GetDocument()->DoMarkerHousekeeping(pApp->m_pSourcePhrases, unusedInt,
					dummyType, bPropagationRequired);
				pApp->GetDocument()->GetUnknownMarkersFromDoc(pApp->gCurrentSfmSet,
					&pApp->m_unknownMarkers,
					&pApp->m_filterFlagsUnkMkrs,
					pApp->m_currentUnknownMarkersStr,
					useCurrentUnkMkrFilterStatus);
				// whm 2Sep2023 testing above

#ifdef SHOW_DOC_I_O_BENCHMARKS
				dt1 = dt2;
				dt2 = wxDateTime::UNow();
				wxLogDebug(_T("OnNewDocument-with-logging TokenizeText() executed in %s ms"),
					(dt2 - dt1).Format(_T("%l")).c_str());
#endif
				if (nHowMany == -1)
				{
					// whm 6Apr2020 Note: If the parsing routine in TokenizeText() below crashes, is is NOT likely 
					// that the warning message below would ever be show to the user since the wxMessageBox that
					// displays the message below TokenizeText().
					// Abort the document creation, there has been a significant parsing error.
					// Do a diagnostic run (see View page of Preferences)
					pApp->LogUserAction(msgEnglish);
					wxMessageBox(msg, _T(""), wxICON_WARNING | wxOK);

#if defined (_DEBUG) && !defined(NOLOGS)
	// BEW 24Oct22 track the pApp->m_bParsingSource value, where goes TRUE and back to FALSE
					wxLogDebug(_T("%s::%s(), line %d : app->m_bParsingSource = %d"), __FILE__, __FUNCTION__, __LINE__, (int)gpApp->m_bParsingSource);
#endif
					return TRUE;
				}
			}
			else
			{
				// No logfile is to be created
#if defined(__WXMSW__)
				CWaitDlg waitDlg(pApp->GetMainFrame());
				// indicate we want the following wait message
				waitDlg.m_nWaitMsgNum = 27;	// 27 has "Please wait while creating a new document..."
				waitDlg.Centre();
				waitDlg.Show(TRUE);
				waitDlg.Update();
				// the wait dialog is automatically destroyed when it goes out of scope below
#endif

#if defined(_DEBUG) && defined (FIXORDER)
				wxLogDebug(_T("OnNewDocument line %d  m_bTokenizingTargetText = %d"),
					__LINE__, (int)m_bTokenizingTargetText);
#endif
#ifdef SHOW_DOC_I_O_BENCHMARKS
				wxDateTime dt1 = wxDateTime::Now(),
					dt2 = wxDateTime::UNow();
#endif
#if defined (_DEBUG) && !defined(NOLOGS)
				// BEW 24Oct22 track the pApp->m_bParsingSource value, where goes TRUE and back to FALSE
				wxLogDebug(_T("%s::%s(), line %d : app->m_bParsingSource = %d"), __FILE__, __FUNCTION__, __LINE__, (int)gpApp->m_bParsingSource);
#endif
				nHowMany = TokenizeText(0, pApp->m_pSourcePhrases, *pApp->m_pBuffer,
					(int)pApp->m_nInputFileLength);

				// whm 2Sep2023 testing below 
				// Add a call of the  DoMarkerHousekeeping() function here after TokenizeText()
				// code here directly copied from in the SetupLayoutAndView() function that gets
				// called when collaborating. This is to see if it removes the differences between
				// the xml docs created here in the non-collaboration scenario and the collaboration
				// scenario. The collaboration scenario had more correct xml encoding for certain
				// pSrcPhrase members including m_curTextType and m_inform.
				int unusedInt = 0;
				TextType dummyType = verse;
				bool bPropagationRequired = FALSE;
				pApp->GetDocument()->DoMarkerHousekeeping(pApp->m_pSourcePhrases, unusedInt,
					dummyType, bPropagationRequired);
				pApp->GetDocument()->GetUnknownMarkersFromDoc(pApp->gCurrentSfmSet,
					&pApp->m_unknownMarkers,
					&pApp->m_filterFlagsUnkMkrs,
					pApp->m_currentUnknownMarkersStr,
					useCurrentUnkMkrFilterStatus);
				// whm 2Sep2023 testing above

#ifdef SHOW_DOC_I_O_BENCHMARKS
				dt1 = dt2;
				dt2 = wxDateTime::UNow();
				wxLogDebug(_T("OnNewDocument-without-logging TokenizeText() executed in %s ms"),
					(dt2 - dt1).Format(_T("%l")).c_str());
#endif
				if (nHowMany == -1)
				{
					// whm 6Apr2020 Note: If the parsing routine in TokenizeText() below crashes, is is NOT likely 
					// that the warning message below would ever be shown to the user since the wxMessageBox that
					// displays the message below is below the code execution point in TokenizeText() where crash 
					// would likely happen.
					//
					// Abort the document creation, there has been a significant parsing error.
					// Do a diagnostic run (see View page of Preferences)
					pApp->LogUserAction(msgEnglish);
					pApp->m_bParsingSource = FALSE;
					pApp->m_bMakeDocCreationLogfile = FALSE;
					wxMessageBox(msg, _T(""), wxICON_WARNING | wxOK);

#if defined (_DEBUG) && !defined(NOLOGS)
	// BEW 24Oct22 track the pApp->m_bParsingSource value, where goes TRUE and back to FALSE
					wxLogDebug(_T("%s::%s(), line %d : app->m_bParsingSource = %d"), __FILE__, __FUNCTION__, __LINE__, (int)gpApp->m_bParsingSource);
#endif

					return TRUE;
				}
			}

			// whm 13Nov2023 added the following function call to update the filter status fields in the 
			// .usfmstruct file that was created for the newly created document from the input source text
			// file before the TokenizeText() call above.
			// The following function uses the gCurrentFilterMarkers string to add or update the last colon
			// delimited field in the .sfmstruct file, making the field ":1" if the marker is present in
			// gCurrentFilterMarkers, or making it ":0" if the marker is NOT present in gCurrentFilterMarkers.
			// Note: SetupUsfmStructArrayAndFile() should be called BEFORE the TokenizeText[String]()
			// call above. Then, then a call to UpdateCurrentFilterStatusOfUsfmStructFileAndArray()
			// AFTER the TokenizeText[String]() call is made here below - probably best at the time the
			// current document is saved.
			if (m_bUsfmStructEnabled)
			{
				UpdateCurrentFilterStatusOfUsfmStructFileAndArray(m_usfmStructFilePathAndName);
			}

			// whm 13Apr2020 added line at end of document creation log to indicate we reached end of the document
			// This essentially signals within the log file that the document creation was successful.
			if (pApp->m_bMakeDocCreationLogfile)
			{
				pApp->LogDocCreationData(_T("***End-of-Document***"));
			}
			pApp->m_bParsingSource = FALSE; // make sure doc creation logging stays OFF
											 // until explicitly turned on at another time
			pApp->m_bMakeDocCreationLogfile = FALSE; // turn this OFF to prevent user
				// leaving it turned on, and wondering why doc creation takes minutes to complete

#if defined(_DEBUG) && !defined(NOLOGS) //&& defined(FWD_SLASH_DELIM)
			if (pApp->m_bFwdSlashDelimiter)
			{
				SPList::Node* pos_pSP = gpApp->m_pSourcePhrases->GetFirst();
				CSourcePhrase* pSP;
				do
				{
					pSP = pos_pSP->GetData();
					wxString bracketed = _T('[');
					bracketed += pSP->GetSrcWordBreak();
					bracketed += _T(']');
					wxLogDebug(_T("SrcPhrase: %s  sequnum  %d   [m_srcWordBreak] =  %s"),
						pSP->m_srcPhrase.c_str(), pSP->m_nSequNumber, bracketed.c_str());
					pos_pSP = pos_pSP->GetNext();
				} while (pos_pSP != NULL);
			}
#endif
			// Get any unknown markers stored in the m_markers member of the Doc's
			// source phrases whm ammended 29May06: Bruce desired that the filter
			// status of unk markers be preserved for new documents created within the
			// same project within the same session, so I've changed the last parameter
			// of GetUnknownMarkersFromDoc from setAllUnfiltered to
			// useCurrentUnkMkrFilterStatus.
			GetUnknownMarkersFromDoc(gpApp->gCurrentSfmSet, &gpApp->m_unknownMarkers,
				&gpApp->m_filterFlagsUnkMkrs,
				gpApp->m_currentUnknownMarkersStr,
				useCurrentUnkMkrFilterStatus);

#ifdef _Trace_UnknownMarkers
			TRACE0("In OnNewDocument AFTER GetUnknownMarkersFromDoc (setAllUnfiltered) call:\n");
			TRACE1(" Doc's unk mrs from arrays  = %s\n", GetUnknownMarkerStrFromArrays(&m_unknownMarkers, &m_filterFlagsUnkMkrs));
			TRACE1(" m_currentUnknownMarkersStr = %s\n", m_currentUnknownMarkersStr);
#endif
#if defined (_DEBUG) && !defined(NOLOGS)
			// BEW 24Oct22 track the pApp->m_bParsingSource value, where goes TRUE and back to FALSE
			wxLogDebug(_T("%s::%s(), line %d : app->m_bParsingSource = %d"), __FILE__, __FUNCTION__, __LINE__, (int)gpApp->m_bParsingSource);
#endif

			// calculate the layout in the view
			int srcCount;
			srcCount = pApp->m_pSourcePhrases->GetCount();
			srcCount = srcCount; // unused  (retain to avoid compiler warning)
			if (pApp->m_pSourcePhrases->IsEmpty())
			{
				// IDS_NO_SOURCE_DATA
				wxMessageBox(_(
					"Sorry, but there was no source language data in the file you input, so there is nothing to be displayed. Try a different file."),
					_T(""), wxICON_EXCLAMATION | wxOK);

				// restore everything
				pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(_T(""));
				if (pApp->m_pBuffer != NULL) // whm 11Jun12 added NULL test
					delete pApp->m_pBuffer;
				pApp->m_pBuffer = (wxString*)NULL; // MFC had = 0
				pView->Invalidate();
				GetLayout()->PlaceBox();
				pApp->LogUserAction(_T("No source language data in input file in OnNewDocument()"));

				pApp->m_bZWSPinDoc = FALSE; // BEW 7Oct14 restore default

#if defined (_DEBUG) && !defined(NOLOGS)
	// BEW 24Oct22 track the pApp->m_bParsingSource value, where goes TRUE and back to FALSE
				wxLogDebug(_T("%s::%s(), line %d : app->m_bParsingSource = %d"), __FILE__, __FUNCTION__, __LINE__, (int)gpApp->m_bParsingSource);
#endif

				return TRUE; // BEW 25Aug10, never return FALSE from OnNewDocument() if
							 // you want the doc/view framework to keep working right
			}

			// try this for the refactored layout design....
			CLayout* pLayout = GetLayout();

			pLayout->SetLayoutParameters(); // calls InitializeCLayout() and
						// UpdateTextHeights() and calls other relevant setters
#ifdef _NEW_LAYOUT
			bool bIsOK = pLayout->RecalcLayout(pApp->m_pSourcePhrases, create_strips_and_piles);
#else
			bool bIsOK = pLayout->RecalcLayout(pApp->m_pSourcePhrases, create_strips_and_piles);
#endif
			if (!bIsOK)
			{
				// unlikely to fail, so just have something for the developer here
				wxMessageBox(_T("Error. RecalcLayout(TRUE) failed in OnNewDocument()"),
					_T(""), wxICON_STOP);
				wxASSERT(FALSE);
				pApp->LogUserAction(_T("Error. RecalcLayout(TRUE) failed in OnNewDocument()"));
				wxExit();
			}
#if defined (_DEBUG) && !defined(NOLOGS)
			// BEW 24Oct22 track the pApp->m_bParsingSource value, where goes TRUE and back to FALSE
			wxLogDebug(_T("%s::%s(), line %d : app->m_bParsingSource = %d"), __FILE__, __FUNCTION__, __LINE__, (int)gpApp->m_bParsingSource);
#endif

			// mark document as modified
			Modify(TRUE);

			// show the initial phraseBox - place it at the first empty target slot
			pApp->m_pActivePile = GetPile(0);

			pApp->m_nActiveSequNum = 0;
			bool bTestForKBEntry = FALSE;
			CKB* pKB;
			if (gbIsGlossing) // should not be allowed to be TRUE when OnNewDocument is called,
							  // but I will code for safety, since it can be handled okay
			{
				bTestForKBEntry = pApp->m_pActivePile->GetSrcPhrase()->m_bHasGlossingKBEntry;
				pKB = pApp->m_pGlossingKB;
			}
			else
			{
				bTestForKBEntry = pApp->m_pActivePile->GetSrcPhrase()->m_bHasKBEntry;
				pKB = pApp->m_pKB;
			}
			pKB = pKB; // avoid warning
			if (bTestForKBEntry)
			{
				// it's not an empty slot, so search for the first empty one & do it there; but if
				// there are no empty ones, then revert to the first pile
				CPile* pPile = pApp->m_pActivePile;
				pPile = pView->GetNextEmptyPile(pPile);
				if (pPile == NULL)
				{
					// there was none, so we must place the box at the first pile
					pApp->m_pTargetBox->m_textColor = pApp->m_targetColor;
					pView->PlacePhraseBox(pApp->m_pActivePile->GetCell(1));
					pView->Invalidate();
					pApp->m_nActiveSequNum = 0;

					pApp->m_nOldSequNum = -1; // no previous location exists yet
					// get rid of the stored rebuilt source text, leave a space there instead
					if (pApp->m_pBuffer)
						*pApp->m_pBuffer = _T(' ');

					pApp->m_bZWSPinDoc = FALSE; // BEW 7Oct14 restore default

					return TRUE;
				}
				else
				{
					pApp->m_pActivePile = pPile;
					pApp->m_nActiveSequNum = pPile->GetSrcPhrase()->m_nSequNumber;
				}
			}
#if defined (_DEBUG) && !defined(NOLOGS)
			// BEW 24Oct22 track the pApp->m_bParsingSource value, where goes TRUE and back to FALSE
			wxLogDebug(_T("%s::%s(), line %d : app->m_bParsingSource = %d"), __FILE__, __FUNCTION__, __LINE__, (int)gpApp->m_bParsingSource);
#endif

			// BEW added 10Jun09, support phrase box matching of the text colour chosen
			if (gbIsGlossing && gbGlossingUsesNavFont)
			{
				pApp->m_pTargetBox->GetTextCtrl()->SetOwnForegroundColour(pLayout->GetNavTextColor());// whm 12Jul2018 added ->GetTextCtrl() part
			}
			else
			{
				pApp->m_pTargetBox->GetTextCtrl()->SetOwnForegroundColour(pLayout->GetTgtColor());// whm 12Jul2018 added ->GetTextCtrl() part
			}

			// set initial location of the targetBox
			pApp->m_targetPhrase = pView->CopySourceKey(pApp->m_pActivePile->GetSrcPhrase(), FALSE);
			pApp->m_pTargetBox->m_Translation = pApp->m_targetPhrase;
			pApp->m_pTargetBox->m_textColor = pApp->m_targetColor;
			pView->PlacePhraseBox(pApp->m_pActivePile->GetCell(1), 2); // calls RecalcLayout()

			// save old sequ number in case required for toolbar's Back button - in this case
			// there is no earlier location, so set it to -1
			pApp->m_nOldSequNum = -1;
#if defined (_DEBUG) && !defined(NOLOGS)
			// BEW 24Oct22 track the pApp->m_bParsingSource value, where goes TRUE and back to FALSE
			wxLogDebug(_T("%s::%s(), line %d : app->m_bParsingSource = %d"), __FILE__, __FUNCTION__, __LINE__, (int)gpApp->m_bParsingSource);
#endif

			// set the initial global position variable
			break;
		}// end of case getNewFile_success
		case getNewFile_error_at_open:
		{
			wxString strMessage;
			strMessage = strMessage.Format(_("Error opening file %s."), pathName.c_str());
			wxMessageBox(strMessage, _T(""), wxICON_ERROR | wxOK);
			gpApp->m_lastSourceInputPath = gpApp->m_workFolderPath;
			pApp->LogUserAction(strMessage);
			pApp->m_bDocumentDestroyed = FALSE; // re-initialize (to permit DoAutoSaveDoc() to work)
			break;
		} // end of case getNewFile_error_at_open:
		case getNewFile_error_opening_binary:
		{
			// A binary file - probably not a valid input file such as a MS Word doc.
			// Notify user that Adapt It cannot read binary input files, and abort the
			// loading of the file.
			wxString strMessage = _(
				"The file you selected for input appears to be a binary file.");
			if (fnExtensionOnly.MakeUpper() == _T("DOC"))
			{
				strMessage += _T("\n");
				strMessage += _(
					"Adapt It cannot use Microsoft Word Document (doc) files as input files.");
			}
			else if (fnExtensionOnly.MakeUpper() == _T("ODT"))
			{
				strMessage += _T("\n");
				strMessage += _(
					"Adapt It cannot use OpenOffice's Open Document Text (odt) files as input files.");
			}
			strMessage += _T("\n");
			strMessage += _("Adapt It input files must be plain text files.");
			wxString strMessage2;
			strMessage2 = strMessage2.Format(_("Error opening file %s."), pathName.c_str());
			strMessage2 += _T("\n");
			strMessage2 += strMessage;
			wxMessageBox(strMessage2, _T(""), wxICON_ERROR | wxOK);
			gpApp->m_lastSourceInputPath = gpApp->m_workFolderPath;
			pApp->LogUserAction(strMessage2);
			pApp->m_bDocumentDestroyed = FALSE; // re-initialize (to permit DoAutoSaveDoc() to work)
			break;
		} // end of case getNewFile_error_opening_binary:
		case getNewFile_error_ansi_CRLF_not_in_sequence:
		{
			// this error cannot occur, because the code where it may be generated is
			// never entered for a GetNewFile() call made in OnNewDocument, but the
			// compiler needs a case for this enum value otherwise there is a warning
			// generated
			wxMessageBox(_T("Input data malformed: CR and LF not in sequence"),
				_T(""), wxICON_ERROR | wxOK);
			pApp->LogUserAction(_T("Input data malformed: CR and LF not in sequence"));
			pApp->m_bDocumentDestroyed = FALSE; // re-initialize (to permit DoAutoSaveDoc() to work)
			break;
		} // end of case getNewFile_error_ansi_CRLF_not_in_sequence:
		case getNewFile_error_no_data_read:
		{
			// we got no data, so this constitutes a read failure
			wxMessageBox(_("File read error: no data was read in"), _T(""), wxICON_ERROR | wxOK);
			pApp->LogUserAction(_T("File read error: no data was read in"));
			pApp->m_bDocumentDestroyed = FALSE; // re-initialize (to permit DoAutoSaveDoc() to work)
			break;
		} // end of case getNewFile_error_no_data_read:
		case getNewFile_error_unicode_in_ansi:
		{
			// The file is a type of Unicode, which is an error since this is the ANSI build. Notify
			// user that Adapt It Regular cannot read Unicode input files, and abort the loading of the
			// file.
			wxString strMessage = _("The file you selected for input is a Unicode file.");
			strMessage += _T("\n");
			strMessage += _("This Regular version of Adapt It cannot process Unicode text files.");
			strMessage += _T("\n");
			strMessage += _(
				"You should install and use the Unicode version of Adapt It to process Unicode text files.");
			wxString strMessage2;
			strMessage2 = strMessage2.Format(_("Error opening file %s."), pathName.c_str());
			strMessage2 += _T("\n");
			strMessage2 += strMessage;
			wxMessageBox(strMessage2, _T(""), wxICON_ERROR | wxOK);
			gpApp->m_lastSourceInputPath = gpApp->m_workFolderPath;
			pApp->LogUserAction(strMessage2);
			pApp->m_bDocumentDestroyed = FALSE; // re-initialize (to permit DoAutoSaveDoc() to work)
			break;
		} // end of case getNewFile_error_unicode_in_ansi:

		}// end of switch (GetNewFile(pApp->m_pBuffer, pApp->m_nInputFileLength, pathName))

	} // end of if (bKBReady)

	// get rid of the stored rebuilt source text, leave a space there instead (the value of
	// m_nInputFileLength can be left unchanged)
	if (pApp->m_pBuffer)
		*pApp->m_pBuffer = _T(' ');
	gbDoingInitialSetup = FALSE; // turn it back off, the pApp->m_targetBox now exists, etc

	// BEW added 01Oct06: to get an up-to-date project config file saved (in case user
	// turned on or off the book mode in the wizard) so that if the app subsequently
	// crashes, at least the next launch will be in the expected mode
	if (pApp->m_bPassedAppInitialization && !pApp->m_curProjectPath.IsEmpty())
	{
		bool bOK;
		if (pApp->m_bUseCustomWorkFolderPath && !pApp->m_customWorkFolderPath.IsEmpty())
		{
			// whm 10Mar10, must save using what paths are current, but when the custom
			// location has been locked in, the filename lacks "Admin" in it, so that it
			// becomes a "normal" project configuration file in m_curProjectPath at the
			// custom location.
			if (pApp->m_bLockedCustomWorkFolderPath)
			{
				pApp->LogUserAction(_T("In OnNewDocument with custom work folder locked: writing proj config file"));
				bOK = pApp->WriteConfigurationFile(szProjectConfiguration, pApp->m_curProjectPath, projectConfigFile);
			}
			else
			{
				pApp->LogUserAction(_T("In OnNewDocument with custom work folder not locked: writing proj config file"));
				bOK = pApp->WriteConfigurationFile(szAdminProjectConfiguration, pApp->m_curProjectPath, projectConfigFile);
			}
		}
		else
		{
			pApp->LogUserAction(_T("In OnNewDocument with normal work folder: writing proj config file"));
			bOK = pApp->WriteConfigurationFile(szProjectConfiguration, pApp->m_curProjectPath, projectConfigFile);
		}
		// we don't expect a write error, but tell the developer or user if the write
		// fails, and keep on processing
		if (!bOK)
		{
			pApp->LogUserAction(_T("In OnNewDocument WriteConfigurationFile() failed"));
			wxMessageBox(_T("Adapt_ItDoc.cpp, WriteConfigurationFile() failed, for project config file or admin project config file, in OnNewDocument() at lines 1393+"));
		}
		pApp->m_bDocumentDestroyed = FALSE; // re-initialize (to permit DoAutoSaveDoc() to work)
	}

	// whm 1Oct12 removed MRU code
	/*
	// Note: On initial program startup OnNewDocument() is executed from OnInit()
	// to get a temporary doc and view. pApp->m_curOutputPath will be empty in
	// that case, so only call AddFileToHistory() when it's not empty.
	if (!pApp->m_curOutputPath.IsEmpty())
	{
		wxFileHistory* fileHistory = pApp->m_pDocManager->GetFileHistory();
		fileHistory->AddFileToHistory(pApp->m_curOutputPath);
		// The next two lines are a trick to get past AddFileToHistory()'s behavior of
		// extracting the directory of the file you supply and stripping the path of all
		// files in history that are in this directoy. RemoveFileFromHistory() doesn't do
		// any tricks with the path, so the following is a dirty fix to keep the full
		// paths.
		fileHistory->AddFileToHistory(wxT("[tempDummyEntry]"));
		fileHistory->RemoveFileFromHistory(0); //
	}
	*/

	// BEW added 13Nov09, for setting or denying ownership for writing permission. This is
	// something we want to do each time a doc is created (or opened) - if the local user
	// already has ownership for writing, no change is done and he retains it; but if he
	// had read only access, and the other person has relinquished the project, then the
	// local user will now get ownership. BEW modified 18Nov09: there is an OnFileNew()
	// call made in OnInit() at application initialization time, and control goes to
	// wxWidgets CreateDocument() which internally calls its OnNewDocument() function which
	// then calls Adapt_ItDoc::OnNewDocument(). If, therefore, we here allow
	// SetReadOnlyProtection() to be called while control is within OnInit(), we'll end up
	// setting read-only access off when the application is the only instance running and
	// accessing the last used project folder (and OnInit() then has to be given code to
	// RemoveReadOnlyProtection() immediately after the OnFileNew() call, because the
	// latter is bogus, it is just to get the wxWidgets doc/view framework set up, and the
	// "real" access of a project folder comes later, after OnInit() ends and OnIdle() runs
	// and so the start working wizard runs, etc. All that is fine until the user does the
	// following: the user starts Adapt It and opens a certain project; then the user
	// starts a second instance of Adapt It and opens the same project -- when this second
	// process runs, and while still within the OnInit() function, it detects that the
	// read-only protection file is currently open - and it is unable to remove it because
	// this is not the original process (although a 'bogus' one) that obtained ownership of
	// the project - and our code then aborts the second running Adapt It instance giving a
	// message that it is going to abort. This is unsatisfactory because we want anyone,
	// whether the same user or another, to be able to open a second instance of Adapt It
	// in read-only mode to look at what is being done, safely, in the first running
	// instance. Removing another process's open file is forbidden, so the only recourse is
	// to prevent the 'bogus' OnFileNew() call within OnInit() from creating a read-only
	// protection file here in OnNewDocument() if the call of the latter is caused from
	// within OnInit(). We can do this by having an app boolean which is TRUE during
	// OnInit() and FALSE thereafter. We'll call it:   m_bControlIsWithinOnInit
	if (!pApp->m_bControlIsWithinOnInit)
	{
		// whm added 7Mar12 code for fictitious read only access. If the m_bFictitiousReadOnlyAccess
		// flag is set, ForceFictitiousReadOnlyProtection() should be called before the call to
		// SetReadOnlyProtection().
		if (pApp->m_bFictitiousReadOnlyAccess)
		{
			pApp->m_pROP->ForceFictitiousReadOnlyProtection(pApp->m_curProjectPath);
		}

		pApp->m_bReadOnlyAccess = pApp->m_pROP->SetReadOnlyProtection(pApp->m_curProjectPath);

		if (pApp->m_bReadOnlyAccess)
		{
			// if read only access is turned on, force the background colour change to show
			// now, instead of waiting for a user action requiring a canvas redraw
			pApp->GetView()->canvas->Refresh(); // needed? the call in OnIdle() is more efffective
		}
		pApp->m_bDocumentDestroyed = FALSE; // re-initialize (to permit DoAutoSaveDoc() to work)
	}
	pApp->LogUserAction(_T("Return TRUE from OnNewDocument()"));

	// BEW added 7Oct14
	pApp->m_bZWSPinDoc = pApp->IsZWSPinDoc(pApp->m_pSourcePhrases);

	pApp->m_bDocumentDestroyed = FALSE; // re-initialize (to permit DoAutoSaveDoc() to work)

#if defined (_DEBUG) && !defined(NOLOGS)
	// BEW 24Oct22 track the pApp->m_bParsingSource value, where goes TRUE and back to FALSE
	wxLogDebug(_T("%s::%s(), line %d : app->m_bParsingSource = %d"), __FILE__, __FUNCTION__, __LINE__, (int)gpApp->m_bParsingSource);
#endif

	return TRUE;
}

/*
void CAdapt_ItDoc::UpdateDocCreationLog(CSourcePhrase* pSrcPhrase, wxString& chapter, wxString& verse)
{
	wxString myLine;
	size_t count;
	wxString logsPath = gpApp->m_logsEmailReportsFolderPath;
	wxString logFilename = gpApp->m_filename_for_ParsingSource; // OnInit() sets it to "Log_For_Document_Creation.txt"
					// ReadDoc_XML() temporarily sets it to "Log_Doc_XML_Load_Attempt", and restores the above after the load
	wxString path = logsPath + gpApp->PathSeparator + logFilename;
	wxTextFile f(path);
	myLine = myLine.Format(_T("%s  %d  %s:%s"),
			pSrcPhrase->m_srcPhrase.c_str(), pSrcPhrase->m_nSequNumber, chapter.c_str(), verse.c_str());
	if (!f.IsOpened())
	{
		if (f.Open())
		{
			count = f.GetLineCount();

			if (count < 6)
			{
				f.AddLine(myLine);
				f.Write();
			}
			else
			{
				f.RemoveLine((size_t)1);
				f.AddLine(myLine);
				f.Write();
			}
			f.Close();
		}
	}
}
*/

///////////////////////////////////////////////////////////////////////////////
/// \return nothing
/// \param	event	-> wxCommandEvent (unused)
/// \remarks
/// Called from: the doc/view framework when wxID_SAVE event is generated. Also called from
/// CMainFrame's SyncScrollReceive() when it is necessary to save the current document before
/// opening another document when sync scrolling is on.
/// OnFileSave simply calls DoFileSave() and the latter sets an enum value of normal_save
///
/// BEW changed 28Apr10 A failure might be due to the Open call failing, in which case the
/// document's file is probably unchanged, or an unknown error, in which case the
/// document's file may have been truncated to zero length by the f.Open call done
/// beforehand. So we need code added in order to recover the document; also we have to
/// handle the possibility that the document may not yet have ever been saved, which
/// changes what we need to do in the event of failure.
/// BEW 29Apr10, added a public DoFileSave_Protected() file which returns boolean, because
/// the DoFileSave() function was called in a number of places and it was dangerous if it
/// failed (data would be lost), so I wrapped it with data protection code and called the
/// new function DoFileSave_Protected(), and put that in place of the other throughout the
/// app.
/// BEW 16Apr10, added enum, for support of Save As... menu item as well as Save
/// BEW 28Jul11, added some initial support for collaboration scenario's tranfer of data to
/// external editor
///////////////////////////////////////////////////////////////////////////////

void CAdapt_ItDoc::OnFileSave(wxCommandEvent& WXUNUSED(event))
{
	// whm 26Aug11 Open a wxProgressDialog instance here for save operations.
	// The dialog's pProgDlg pointer is passed along through various functions that
	// get called in the process.
	// whm WARNING: The maximum range of the wxProgressDialog (nTotal below) cannot
	// be changed after the dialog is created. So any routine that gets passed the
	// pProgDlg pointer, must make sure that value in its Update() function does not
	// exceed the same maximum value (nTotal).

	wxString msgDisplayed;
	const int nTotal = gpApp->GetMaxRangeForProgressDialog(App_SourcePhrases_Count) + 1;
	wxString progMsg = _("Saving File %s  - %d of %d Total words and phrases");
	wxFileName fn(gpApp->m_curOutputFilename);
	msgDisplayed = progMsg.Format(progMsg, fn.GetFullName().c_str(), 1, nTotal);
	CStatusBar* pStatusBar = NULL;
	pStatusBar = (CStatusBar*)gpApp->GetMainFrame()->m_pStatusBar;
	if (gpApp->m_bShowProgress)
	{
		pStatusBar->StartProgress(_("Saving File"), msgDisplayed, nTotal);
	}

	if (gpApp->m_bCollaboratingWithParatext || gpApp->m_bCollaboratingWithBibledit)
	{
		// whm modified 17Jan12 consolidated the code for collab mode file saves
		// in a DoCollabFileSave() function as it needs to also be called from
		// OnSaveModified(), otherwise saves can be lost if user closes the main
		// frame window - which triggers OnSaveModified() but not OnFileSave().
		// Notes:
		// 1. DoCollabFileSave() returns a bool as does DoFileSave_Protected()
		// and DoFileSave(), but they (and hence DoCollabFileSave() too) make
		// no use of the bool value that is returned - although the code probably
		// should.
		// 2. DoCollabFilesave() also calls DoFileSave_Protected(TRUE,pProgDlg)
		DoCollabFileSave((gpApp->m_bShowProgress) ? _("Saving File") : _T(""), msgDisplayed);
	}
	else
	{
		// no collaboration - do a normal protected save

		// we are not interested in the returned boolean from the following call
		DoFileSave_Protected(gpApp->m_bShowProgress, (gpApp->m_bShowProgress) ? _("Saving File") : _T("")); // only show wait/progress dialog if flag is TRUE
	}
	if (gpApp->m_bShowProgress)
	{
		pStatusBar->FinishProgress(_("Saving File"));
	}
}


void CAdapt_ItDoc::OnTakeOwnership(wxCommandEvent& WXUNUSED(event))
{
	wxCommandEvent	dummy;

	// BEW comment 3Jun13. This function works to support NOOWNER (#defined as the string
	// ****) as a default owner so long as KB Sharing, or DVCS, is not invoked. Once one of
	// those is invoked, a unique owner (e.g. a full email address, or other unique name
	// string) and an informal username (such as "John Doe") need to be supplied - and the
	// dialog for doing that won't allow dismissal of itself without something other than
	// **** being typed in each of its two wxTextCtl widgets. The function which checks for
	// empty string or **** is CheckUsername() - it's in helpers.cpp.

	gpApp->LogUserAction(_T("OnTakeOwnership() called - m_owner = ") + gpApp->m_owner + _T(" m_strUserID = ") + gpApp->m_strUserID);

	if (gpApp->m_strUserID.IsEmpty() || gpApp->m_strFullname.IsEmpty())   // this can happen if AI is launched with shift down
	{
		wxCommandEvent	dummy;

		gpApp->OnEditChangeUsername(dummy);

		// BEW 4Nov13, added 2nd test for empty m_strUserID
		if (gpApp->m_strUserID == NOOWNER || gpApp->m_strUserID.IsEmpty()) // did we get a username?
		{                                               // nope - whinge and bail out.
			wxMessageBox(_("No username entered -- owner not changed."));
			gpApp->LogUserAction(_T("No username entered -- owner not changed."));
			return;
		}
	}

	// BEW 4Nov13 added outer test. It was possible to get here with m_bReadOnlyAccess
	// TRUE, but no username in the config file -- by running 6.4.3 for instance, which
	// shows doc read only, but my username was already in the doc from earlier runs with
	// the 6.5.0 code, so after the Username Input dialog allowed me to reset username and
	// informal name, the unprotected inner test would return control to the caller without
	// read-only status being removed, hence the need for the outer test
	if (!gpApp->m_bReadOnlyAccess)
	{
		if (gpApp->m_owner == gpApp->m_strUserID)
			return;                             // if we're already the owner, there's nothing to do
	}

	gpApp->m_owner = gpApp->m_strUserID;	// force doc's owner to be logged-in user, no matter what
	gpApp->m_bReadOnlyAccess = FALSE;		// make doc editable
	Modify(TRUE);							// mark doc dirty, to ensure new owner gets saved

	gpApp->GetView()->UpdateAppearance();   // get rid of the pink
}

/*	mrh - May 2012.
	This function is needed for the version control stuff, but might be more generally useful
	as well.  It's called when something external to AdaptIt has modified the current document.
	We need to re-read it, and refresh the screen display.  The code below is largely lifted from
	OnEditConsistencyCheck().
*/

void CAdapt_ItDoc::DocChangedExternally()
{
	bool			bOK;

	wxString		savedCurOutputPath = gpApp->m_curOutputPath;			// includes filename
	wxString		savedCurOutputFilename = gpApp->m_curOutputFilename;
	//	int				savedCurSequNum = gpApp->m_nActiveSequNum;				// for resetting the box location
	bool			savedBookmodeFlag = gpApp->m_bBookMode;					// for ensuring correct mode
	bool			savedDisableBookmodeFlag = gpApp->m_bDisableBookMode;	// ditto
	int				savedBookIndex = gpApp->m_nBookIndex;
	BookNamePair* pSavedCurBookNamePair = gpApp->m_pCurrBookNamePair;
	int				savedCommitCount = gpApp->m_commitCount;				// We'll have this count up monotonically, not
																			//  use the value we read in.  Change if necessary.
	int				savedTrialVersionNum = gpApp->m_trialVersionNum;
	wxString		dirPath;

	gpApp->LogUserAction(_T("Entering DocChangedExternally()"));

	if (gpApp->m_bBookMode && !gpApp->m_bDisableBookMode)
		dirPath = gpApp->m_bibleBooksFolderPath;
	else
		dirPath = gpApp->m_curAdaptationsPath;

	wxString		strSaveCurrentDirectoryFullPath = dirPath;

	// whm 8Apr2021 added wxLogNull block below
	{
		wxLogNull logNo;	// eliminates any spurious messages from the system if the wxSetWorkingDirectory() call returns FALSE
		bOK = ::wxSetWorkingDirectory(dirPath); // ignore failures
	} // end of wxLogNull scope
	bOK = bOK; // whm added 13Aug12 to suppress gcc warning "set but not used"

	m_bReopeningAfterClosing = TRUE;	// to prevent KB being clobbered -- we want only the doc closed
	OnCloseDocument();
	m_bReopeningAfterClosing = FALSE;	// restore normal default

	gpApp->m_bDocReopeningInProgress = TRUE;	// suppresses warning message about project folder with same name

	bOK = ReOpenDocument(gpApp,
		strSaveCurrentDirectoryFullPath,
		savedCurOutputPath,
		savedCurOutputFilename,
		//							savedCurSequNum,
		savedBookmodeFlag,
		savedDisableBookmodeFlag,
		pSavedCurBookNamePair,
		savedBookIndex,
		FALSE					// don't mark as dirty
	);

	gpApp->m_bDocReopeningInProgress = FALSE;
	gpApp->m_commitCount = savedCommitCount;
	gpApp->m_trialVersionNum = savedTrialVersionNum;

	// BEW added 3June14 Since in general the phrasebox position in the restored
	// document will be different than its position in the former current document, in
	// free translation mode this would lead to the free translation (if one has been
	// typed) in the ComposeBar's editbox being left there - and of course it would be
	// wrong, because the restored doc would still be in free translation mode and the
	// new box location would, if in no former free trans section, become the new anchor
	// location for a newly created section - and it would be a bogus meaning; but if
	// the phrasebox was within a free trans section, AI's code would move it automatically
	// back to the section's anchor - which is fine, and that should have the bogus free
	// translation replaced by that section's correct one. So this would be okay. It's when
	// the box is put at a location with no section that we get a problem. The safest thing
	// to do is to check for free translation mode, and if turned ON, then clear the
	// compose bar so that at least the user won't start out with a confusing wrong free
	// translation string
	if (gpApp->m_bFreeTranslationMode)
	{
		CMainFrame* pFrame = gpApp->GetMainFrame();
		wxASSERT(pFrame != NULL);
		wxPanel* pBar = pFrame->m_pComposeBar;
		if (pBar != NULL && pBar->IsShown())
		{
			wxTextCtrl* pEdit = (wxTextCtrl*)pBar->FindWindow(IDC_EDIT_COMPOSE);
			if (pEdit != 0)
			{
				wxString tempStr;
				// clear the Compose Bar's edit box
				tempStr.Empty();
				pEdit->ChangeValue(tempStr);
			}
		}
	}
}


bool  CAdapt_ItDoc::Git_installed()
{
	if (!gpApp->m_DVCS_installed)
	{
		wxString msg = _("Adapt It cannot maintain a history of its documents because the Git program is not installed on this computer. Git can be installed by selecting the 'Install the Git program...' item on the Tools menu. If you just installed Git using the Tools menu item, you need to quit Adapt It and restart the computer for Git to work.");
		wxMessageBox(msg, _("Git program is not available for use by Adapt It"), wxICON_EXCLAMATION | wxOK);
		gpApp->LogUserAction(msg);

		return FALSE;
	}
	return TRUE;
}


/*  mrh - 5Jun14.
	CollaborationEditorAcceptsDataTransfers() checks if safe to Save with regard to collaboration.

	If we're collaborating with Paratext or BibleEdit, and if the one we're collaborating with is currently running,
	it would be unsafe to do a Save which would involve transferring data to the other application, as it might
	cause VCS conflicts when the user of that application next does a Save there.
	In this situation, we warn the user to close the other application now and then try again, and we return
	false from here which will block any Save or DVCS operation.

	If we're not collaborating or the collaboration application isn't running, a Save is safe and we return true.
*/

/* app member variables
 bool m_bCollaboratingWithParatext;
 bool m_bCollaboratingWithBibledit;
 bool m_bCollaborationExpectsFreeTrans;
 bool m_bCollaborationDocHasFreeTrans;
 wxString m_collaborationEditor;
 */

 // whm 11May2017 changed name of function from CollaborationAllowsSaving() to CollaborationEditorAcceptsDataTransfers()
bool  CAdapt_ItDoc::CollaborationEditorAcceptsDataTransfers()
{
#ifndef __WXMAC__       // collaboration doesn't happen on the Mac, so we just return true.
	//wxASSERT(!gpApp->m_collaborationEditor.IsEmpty());

	if ((gpApp->m_bCollaboratingWithParatext && gpApp->ParatextIsRunning()) || (gpApp->m_bCollaboratingWithBibledit && gpApp->BibleditIsRunning()))
	{
		// No, it's unsafe to Save.  Put up a message and return false.

			//wxString msg;
			//msg = msg.Format(_("Adapt It cannot transfer your work to %s while %s is running.\nClick on OK to close this dialog. Leave Adapt It running, switch to %s and shut it down. Then switch back to Adapt It and do the save operation again."),
			//                 gpApp->m_collaborationEditor.c_str(), gpApp->m_collaborationEditor.c_str(), gpApp->m_collaborationEditor.c_str());

			//wxMessageBox(msg, _("Collaboration editor is running"), wxOK);
		return false;
	}

	// All OK.
#endif
	return true;
}

// whm added 11May2017 a function that returns TRUE if the currently open collaboration
// document is designated as 'protected' from transferring data to the external editor,
// FALSE if the collaboration document is not designated as 'protected'.
// Assumes that the caller will only call the function when the document is a collaboration
// document and is open within Adapt It's main window, so that the App's collab values
// are current for the open document.
bool CAdapt_ItDoc::DocumentIsProtectedFromTransferringDataToEditor()
{
	// whm added 17April2017 code to allow collab books/chapters to be protected from
	// writing changes to PT/BE during collaboration saves. These books/chapters would
	// still be saved normally as AI documents in the Adaptations folder - just not to PT/BE.
	// Here is where we should interrupt the transfer of information to PT/BE when the
	// current document is marked as "protected from making changes to PT/BE".
	// We call a new function named IsCollabDocProtectedFromSaving(). If it returns TRUE,
	// DoCollabFileSave() return's FALSE immediately. If IsCollabDocProtectedFromSaving()
	// returns FALSE the book/chapter currently open in collaboration is not marked
	// as protected in the AI-ProjectConfiguration.aic's CollabBooksProtectedFromSavingToEditor
	// field.
	bool bProtectedFromSavingChangesToExternalEditor = FALSE;
	wxString bookCode = gpApp->m_Collab_BookCode;
	bool bCollabByChapterOnly = gpApp->m_bCollabByChapterOnly;
	wxString collabChapterSelected = gpApp->m_CollabChapterSelected; // a wxString represengin a chapter number if collabByChapterOnly is "1"
	wxASSERT(!bookCode.IsEmpty());
	bProtectedFromSavingChangesToExternalEditor = IsCollabDocProtectedFromSavingToEditor(bookCode, bCollabByChapterOnly, collabChapterSelected);

	return bProtectedFromSavingChangesToExternalEditor;
}


bool  CAdapt_ItDoc::Commit_valid()
{
	wxCommandEvent	dummy;

	if (!CollaborationEditorAcceptsDataTransfers())
	{
		wxString msg;
		msg = msg.Format(_("Adapt It cannot transfer your work to %s while %s is running.\nClick on OK to close this dialog. Leave Adapt It running, switch to %s and shut it down. Then switch back to Adapt It and do the save operation again."),
			gpApp->m_collaborationEditor.c_str(), gpApp->m_collaborationEditor.c_str(), gpApp->m_collaborationEditor.c_str());
		// whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
		gpApp->m_bUserDlgOrMessageRequested = TRUE;

		wxMessageBox(msg, _("Collaboration editor is running"), wxOK);
		return false;    // Bail out on an unsafe collaboration situation
	}

	if (gpApp->m_strUserID == NOOWNER)
	{
		// whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
		gpApp->m_bUserDlgOrMessageRequested = TRUE;
		wxMessageBox(_("Before saving in the document history, you must enter a username for yourself."));
		gpApp->LogUserAction(_T("Before saving in the document history, you must enter a username for yourself."));
		gpApp->OnEditChangeUsername(dummy);

		if (gpApp->m_strUserID == NOOWNER)           // did we get a username?
		{                                              // nope - whinge and bail out.
													   // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
			gpApp->m_bUserDlgOrMessageRequested = TRUE;
			wxMessageBox(_("No username entered -- document not saved."));
			gpApp->LogUserAction(_T("No username entered -- document not saved."));
			return false;
		}
	}

	if (gpApp->m_owner == NOOWNER)  return true;        // if the doc doesn't have an owner, it's always OK to commit it

	if (gpApp->m_strUserID != gpApp->m_owner)
	{
		// whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
		gpApp->m_bUserDlgOrMessageRequested = TRUE;
		wxMessageBox(_("Sorry, it appears the owner of this document is ") + gpApp->m_owner
			+ _(" but the currently logged in user is ") + gpApp->m_strUserID
			+ _(".  Only the document's owner can save in the document history."));
		gpApp->LogUserAction(_T("Sorry, it appears the owner of this document is ") + gpApp->m_owner
			+ _T(" but the currently logged in user is ") + gpApp->m_strUserID
			+ _T(".  Only the document's owner can save in the document history."));
		return false;
	}

	// All OK!
	return true;
}


//  (Feb 2013) - similarly to what Paratext does, if the doc isn't under version control yet, we add it silently.
//  (Mar 2013) - added a parameter "blurb" which gives the informative text that appears in the "save and commit"
//      dialog.  If left empty, the default text appears.mac

int CAdapt_ItDoc::DoSaveAndCommit(wxString blurb)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	int				resultCode;
	wxCommandEvent	dummy;
	wxDateTime		localDate,
		origDate = gpApp->m_versionDate;
	wxString		origOwner = gpApp->m_owner;
	int             origCommitCnt = gpApp->m_commitCount;

	pApp->LogUserAction(_T("Entering DoSaveAndCommit()"));

	if (pApp->m_trialVersionNum >= 0)
	{
		// whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
		gpApp->m_bUserDlgOrMessageRequested = TRUE;
		wxMessageBox(_("Before saving in the document history, you must either ACCEPT the revision or RETURN to the latest one."));
		pApp->LogUserAction(_T("Before saving in the document history, you must either ACCEPT the revision or RETURN to the latest one."));
		return -1;
	}

	if (!Commit_valid())
		return -1;              // bail out if the ownership etc. isn't right

	if (!pApp->m_pDVCS->AskSaveAndCommit(blurb))
		return -1;              // or if user cancelled dialog

// Now we find the date/time and the commit count, which we'll save in the file before we do the commit.
// We use UTC for the date/time, which may avoid problems when we're pushing/pulling to a remote location.

	localDate = wxDateTime::Now();
	pApp->m_versionDate = localDate.ToUTC(FALSE);

	if (pApp->m_commitCount < 0)
		pApp->m_commitCount = 0;

	pApp->m_commitCount += 1;					// bump the commit count

	pApp->m_owner = gpApp->m_strUserID;		// owner may have been NOOWNER, but must be assigned on a commit

	pApp->m_bShowProgress = true;	// edb 16Oct12: explicitly set m_bShowProgress before OnFileSave()
	OnFileSave(dummy);							// save the file, ready to commit

	resultCode = pApp->m_pDVCS->DoDVCS(DVCS_COMMIT_FILE, 0);

	if (resultCode)
	{
		// What do we do here??  We've already saved the document with the above info updated.  I think we
		//  should roll everything back and re-save.  The DVCS code will already have given a message.

		pApp->LogUserAction(_T("Rolling back and re-saving"));

		pApp->m_versionDate = origDate;
		pApp->m_commitCount = origCommitCnt;
		pApp->m_owner = origOwner;

		pApp->m_bShowProgress = true;	// edb 16Oct12: explicitly set m_bShowProgress before OnFileSave()
		OnFileSave(dummy);
		return -2;
	}

	// all OK
	return 0;
}

void CAdapt_ItDoc::OnSaveAndCommit(wxCommandEvent& WXUNUSED(event))
{
	if (!Git_installed())
		return;                     // Shows message if git not installed

	// BEW added 3Feb14, If the user has finished adapting to the end of the document, and
	// the phrasebox is no longer visible, and he chooses to save & commit, then the
	// DoSaveAndCommit() call below crashes if the phrasebox is not at some pile - thereby
	// making the pile active. So check and if not visible, put it at the end of the
	// document first.
	if (gpApp->m_pActivePile == NULL || gpApp->m_nActiveSequNum == -1)
	{
		//gpApp->m_bSuppressPseudoDeleteWhenClosingDoc = TRUE;
		PutPhraseBoxAtDocEnd();
		//gpApp->m_bSuppressPseudoDeleteWhenClosingDoc = FALSE;
	}
	DoSaveAndCommit(_T(""));        // Ignore returned result - if an error occurred, a message will have been shown.
}

void CAdapt_ItDoc::EndTrial(bool restoreBackup)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	bool            backupExists = pApp->m_bBackedUpForTrial;

	pApp->m_pDVCSNavDlg->Destroy();         // take down the dialog
	pApp->m_pDVCSNavDlg = NULL;
	pApp->m_trialVersionNum = -1;           // no trial now
	pApp->m_bBackedUpForTrial = FALSE;      // restore normal default here at the start

// now if we did a backup because of uncommitted changes when we started the trial, we may need to restore from the backup:
	if (backupExists)
	{
		wxString    backupPath = pApp->m_curOutputPath + _T("__bak");

		if (restoreBackup)
		{
			pApp->m_bBackedUpForTrial = FALSE;

			bool        bCopiedSuccessfully = ::wxCopyFile(backupPath, pApp->m_curOutputPath, TRUE);   // summarily overwrite!
			wxASSERT(bCopiedSuccessfully);
			bCopiedSuccessfully = bCopiedSuccessfully; // prevent compiler warning in release build
		}

		// so far so good, so we remove the backup:
		bool        bRemovedSuccessfully = ::wxRemoveFile(backupPath);
		if (!bRemovedSuccessfully)
		{
			// tell developer or user, if the removal failed.  This isn't critical - just a warning.
			wxMessageBox(_T("Adapt_ItDoc.cpp, EndTrial()'s call of wxRemoveFile() failed, at line 1709."));
			gpApp->LogUserAction(_T("Adapt_ItDoc.cpp, EndTrial()'s call of wxRemoveFile() failed, at line 1709."));
		}

	}
	DocChangedExternally();                     // Even if we didn't restore from the backup, the read-only status
												//  has changed, so we need this.
	pApp->GetView()->UpdateAppearance();        // whatever happened, the on-screen appearance will have changed
}

void CAdapt_ItDoc::DoChangeVersion(int revNum)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	int             returnCode;
	wxString        temp;

	temp = temp.Format(_T("DoChangeVersion() called with revNum = %d"), revNum);
	pApp->LogUserAction(temp);

	wxASSERT(revNum >= -2);

	if (revNum == -2)       // "return to latest" was clicked in the dialog.  Whatever we do, we first need to go to the
							// latest committed version.
	{
		returnCode = pApp->m_pDVCS->DoDVCS(DVCS_GET_VERSION, 0);			// get the latest committed revision

		wxASSERT(returnCode >= 0);      // a negative returnCode means a bug
		if (returnCode)  return;        // positive nonzero returnCode means git returned an error -- an error
										//  message should have been displayed already.

		EndTrial(TRUE);                 // end the trial, restoring the backup
		return;
	}

	if (revNum < 0)
	{                   // bail out if no more, coming forward
		// whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
		gpApp->m_bUserDlgOrMessageRequested = TRUE;
		wxMessageBox(_("There are no more recent versions in the history!"));
		return;
	}

	if (revNum >= gpApp->m_versionCount)
	{                   // bail out if no more, going back
		// whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
		gpApp->m_bUserDlgOrMessageRequested = TRUE;
		wxMessageBox(_("We're already back at the earliest version saved!"));
		return;
	}

	returnCode = pApp->m_pDVCS->DoDVCS(DVCS_GET_VERSION, revNum);			// get the requested revision

	wxASSERT(returnCode >= 0);      // a negative returnCode means a bug
	if (returnCode)  return;        // positive nonzero returnCode means git returned an error -- an error
									//  message should have been displayed already.

// So far so good.  But we need to re-read the doc.  If we're not at the latest revision,
// the doc becomes read-only since ReadOnlyProtection sees that m_trialVersionNum is non-negative.
// If an error has come up, we've already bailed out, leaving the trial status alone.

	pApp->LogUserAction(_T("Successfully got the version - now calling EndTrial() or DocChangedExternally()"));
	pApp->m_trialVersionNum = revNum;           // successfully got to requested revision

	DocChangedExternally();

	if (revNum == 0 && !pApp->m_bBackedUpForTrial)
		EndTrial(TRUE);                        // we're at the latest committed version, and that's really the latest.  The trial's over.
	else
		pApp->GetView()->UpdateAppearance();    // still going, but we have to update the on-screen appearance
}

// IsLatestVersionChanged() calls DVCS to check if the current version on disk is the same as the latest version
//  committed.  It returns TRUE if there are any changes.

bool CAdapt_ItDoc::IsLatestVersionChanged(void)
{
	int  returnCode = gpApp->m_pDVCS->DoDVCS(DVCS_ANY_CHANGES, 0);		// returns 0 if no changes, nonzero otherwise
	return (returnCode != 0);
}

/*
	DoShowPreviousVersions() does the main work for setting up a "trial" of looking at earlier versions and
	deciding what to do.  It's either called directly from the menu choice, or via the "show history" dialog
	where we can select any earlier version and look at it.  In this case we pass TRUE for fromLogDialog.
	If we haven't just done a commit, we need to do one so that we can come back to the latest version if we
	need to.  In this case, and always if we're called directly, we need to call DVCS to (re-)read the version log.
	If we're called from the dialog, OnShowFileLog() below has already read the log, so we don't need to do it
	again unless we do another commit.
	startHere gives the version number we're to show initially, with zero as the latest.  If we're called
	directly, we'll always start with version 1.  If called from the dialog, any version can be asked for,
	but if we do another commit and re-read the log, all the numbers will go up by 1 so we also increment
	startHere.
*/
void CAdapt_ItDoc::DoShowPreviousVersions(bool fromLogDialog, int startHere)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	int				returnCode;
	wxCommandEvent	dummy;
	int				trialRevNum = gpApp->m_trialVersionNum;
	DVCSNavDlg* pNavDlg;
	bool            needBackup = FALSE;
	wxString        temp;

	temp = temp.Format(_T("DoShowPreviousVersions() called with startHere = %d"), startHere);
	pApp->LogUserAction(temp);

	wxASSERT(startHere >= 0);          // 0 is the latest version committed, 1 the next previous, and so on.

	if (pApp->m_commitCount <= 0)
	{
		// whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
		gpApp->m_bUserDlgOrMessageRequested = TRUE;
		wxMessageBox(_("There are no earlier versions saved!"));
		return;
	}

	if (trialRevNum == 0)
	{
		// whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
		gpApp->m_bUserDlgOrMessageRequested = TRUE;
		wxMessageBox(_("We're already back at the earliest version saved!"));
		return;
	}

	if (trialRevNum > 0)
	{
		// whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
		gpApp->m_bUserDlgOrMessageRequested = TRUE;
		wxMessageBox(_T("We shouldn't have got here!"));
		return;
	}

	// We're initiating a trial review of previous versions.  The current version needs to be backed up so we can come
	// back to it if necessary, so we copy it to a file with the same name with "__bak" appended, in the same folder.
	// But we don't need to do this if the doc has just been committed with no subsequent changes.

#if defined(_DEBUG) && !defined(NOLOGS)
	// BEW 3Jun14 added cast (void*) because without it, on Windows I got an assert trip saying that there was
	// a format specifier which did not match its argument; %d is certainlyl save for the sequ num, so must have been
	// the CPile pointer. The cast should fix it.
	// whm 18Mar2019 removed the (size_t) cast and changed the %x to %p which eliminate the assert. %p is the format specifier for a pointer address.
	wxLogDebug(_T("m_pActivePile = %p  , m_nActiveSequNum =  %d"), pApp->m_pActivePile, pApp->m_nActiveSequNum);
#endif
	pApp->m_bBackedUpForTrial = FALSE;
	if (IsModified())
	{
		pApp->DoAutoSaveDoc();       // if the doc is modified, we have to save it, so it's just like an autosave, and we'll need a backup
#if defined(_DEBUG) && !defined(NOLOGS)
	// BEW 3Jun14 added cast (void*) because without it, on Windows I got an assert trip saying that there was
	// a format specifier which did not match its argument; %d is certainlyl save for the sequ num, so must have been
	// the CPile pointer. The cast should fix it.
	// whm 18Mar2019 removed the (size_t) cast and changed the %x to %p which eliminate the assert. %p is the format specifier for a pointer address.
		wxLogDebug(_T("m_pActivePile = %p  , m_nActiveSequNum =  %d"), pApp->m_pActivePile, pApp->m_nActiveSequNum);
#endif
		needBackup = TRUE;
	}
	else
		needBackup = IsLatestVersionChanged();      // if not modified, but the latest version isn't the same as the latest committed, we need a backup.

// (Oct 13 -- we're now always doing the backup, no matter what, so "return to latest" will always have the expected result of returning to exactly where
//  we started.
//    if (needBackup)
	needBackup = needBackup; // whm added to prevent GCC warning about variable set but not used
	{
		wxString    backupPath = pApp->m_curOutputPath + _T("__bak");
		bool        bCopiedSuccessfully = ::wxCopyFile(pApp->m_curOutputPath, backupPath, TRUE);   // overwrite any previous copy
		wxASSERT(bCopiedSuccessfully);
		bCopiedSuccessfully = bCopiedSuccessfully; // prevent compiler warning in release build
		pApp->m_bBackedUpForTrial = TRUE;
		if (!fromLogDialog)  startHere--;       // if we've been called sraight from the menu, the "previous version" is actually the
												//  last committed, since subsequent changes have been made to the doc.  So we need to
												//  adjust where we start from.  But if we were called from the dialog, the actual version
												//  has been specified, so we mustn't change it.
	}

	if (!fromLogDialog)
	{
		returnCode = pApp->m_pDVCS->DoDVCS(DVCS_SETUP_VERSIONS, 0);		// (re-)reads the log, and hangs on to it
		if (returnCode < 0)
			return;                             // bail out on error

		pApp->m_versionCount = returnCode;      // success - now we have the current total number of log entries
	}

	if (startHere == 0 && !pApp->m_bBackedUpForTrial)  return;
	// presumably the latest version was chosen in the log dialog,
	// and we didn't backup a later one, so there's nothing more to do!

	gpApp->m_trialVersionNum = startHere;                       // and here's where we'll start from

	pApp->LogUserAction(_T("Bringing up the DVCSNavDlg"));

	pNavDlg = new (DVCSNavDlg) (gpApp->GetMainFrame());		// create the version navigation dialog
	pNavDlg->Move(100, 100);                                    // put it near the top left corner initially
	pNavDlg->ChooseVersion(startHere);                         // changes the doc version, and sets fields in the dialog
	DoChangeVersion(startHere);								// we seem to need this on Windows, and is harmless otherwise
	pNavDlg->Show();                                            // show it, non-modally.  By showing it after changing the
																// doc version, it appears on top so we avoid having to Raise()
																//  it which would look uglier.
	pNavDlg->AcceptsFocus();
	pNavDlg->InitDialog();
	pApp->m_pDVCSNavDlg = pNavDlg;
}

// The "look at previous version" menu item takes us to the last one saved, which is item 1 in the log.

void CAdapt_ItDoc::OnShowPreviousVersions(wxCommandEvent& WXUNUSED(event))
{
	if (!Git_installed())
		return;                     // Shows message if git not installed

	DoShowPreviousVersions(FALSE, 1);
}


void CAdapt_ItDoc::DoAcceptVersion(void)
{
	gpApp->LogUserAction(_T("Entering DoAcceptVersion()"));

	if (gpApp->m_trialVersionNum < 0)
	{
		// whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
		gpApp->m_bUserDlgOrMessageRequested = TRUE;
		wxMessageBox(_("We're not looking at earlier revisions!"));
		gpApp->LogUserAction(_T("We're not looking at earlier revisions!"));
		return;
	}
	EndTrial(FALSE);           // the trial's over, but we don't restore from any backup.
}


bool  CallOpenDocument(wxString path)
{
	return gpApp->GetDocument()->OnOpenDocument(path, false);
}

#if defined(_DEBUG) && defined(DEBUG_ZWSP)
// copied from PunctCorrespPage.cpp for use here while debugging
wxString MakeUNNNN(wxString& chStr)
{
	wxString prefix = _T(""); // some people said U+ makes the strings too wide, so leave
							 // it off_T("U+");
	// whm 11Jun12 Note: I think chStr will always have at least a value of T('\0'), so
	// GetChar(0) won't ever be called on an empty string, but to be safe test for empty
	// string.
	wxChar theChar;
	if (!chStr.IsEmpty())
		theChar = chStr.GetChar(0);
	else
		theChar = _T('\0');
	wxChar str[6] = { _T('\0'),_T('\0'),_T('\0'),_T('\0'),_T('\0'),_T('\0') };
	wxChar* pStr = str;
	wxSnprintf(pStr, 6, _T("%x"), (int)theChar);
	wxString s = pStr;
	if (s == _T("0"))
	{
		s.Empty();
		return s;
	}
	int len = s.Length();
	if (len == 2)
		s = _T("00") + s;
	else if (len == 3)
		s = _T("0") + s;
	return prefix + s;
}
#endif


// RecoverLatestVersion() is called when an xml error comes up while reading a document.  If we can, we
// revert to the latest committed version.  We return TRUE on success, FALSE otherwise.

bool CAdapt_ItDoc::RecoverLatestVersion(void)
{
	int             returnCode;
	wxCommandEvent  dummyEvent;
	wxString        docPath, docName;
	CAdapt_ItApp* pApp = gpApp;

	pApp->LogUserAction(_T("Entering RecoverLatestVersion()"));

	pApp->m_recovery_pending = FALSE;                  // restore normal default, so opening the doc after recovery works properly

	if (!pApp->m_DVCS_installed)  return FALSE;        // can't do it if git not installed -- don't want a message

	if (pApp->m_commitCount <= 0)  return FALSE;       // can't do it if there are no saved versions

	returnCode = gpApp->m_pDVCS->DoDVCS(DVCS_SETUP_VERSIONS, 0);		// (re-)reads the log, and hangs on to it
	if (returnCode < 0)  return FALSE;                  // can't do it if an error came up here

// OK, so far so good...
	returnCode = gpApp->m_pDVCS->DoDVCS(DVCS_GET_VERSION, 0);		// get the latest revision (zero is the latest)

//  a negative returnCode would normally be a bug, but it can come up here if the corrupted
//  doc has a wrong name. So on any nonzero returnCode we return FALSE since we can't
//  recover the doc.

	if (returnCode)
	{
		wxString    temp;
		temp = temp.Format(_T("Returning FALSE from RecoverLatestVersion() - returnCode = %d"), returnCode);
		pApp->LogUserAction(temp);

		return FALSE;
	}

	/*  OK, the doc's recovered!  What we do now depends on what was happening when the doc was opened.  The normal situation
		is a simple doc opening, and in this case m_reopen_recovered_doc will be TRUE.  In this situation we'd like to
		call DocChangedExternally() and display the doc, but since the opening process has been partly started, and the doc's
		probably corrupt, this doesn't work.  What works is to completely close the doc (which we've already done)
		and re-open it by calling OnOpenDocument().  We also include some code from CDocPage::OnWizardFinish()
		that looks like  it might be doing something useful.

		There are currently two other places where we read a document.  We don't attempt to continue these ops from partway
		through, but just ask the user to re-attempt what they were doing.
	*/

	if (!pApp->m_reopen_recovered_doc)          // here the caller will display a message, so we don't do it here.
		return TRUE;

	pApp->m_reopen_recovered_doc = FALSE;       // restore normal default

												// whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
	gpApp->m_bUserDlgOrMessageRequested = TRUE;
	wxMessageBox(_("This document was corrupt, but we have restored the latest version saved in the document history."));
	pApp->LogUserAction(_T("This document was corrupt, but we have restored the latest version saved in the document history."));

	CAdapt_ItView* pView = pApp->GetView();

	docName = pApp->m_curOutputFilename;
	docPath = pApp->m_curOutputPath;

	//bool bOK = OnOpenDocument (docPath, false);  -- for some reason this bounces back without doing anything.  But calling it
	//indirectly seems to work...

	if (!CallOpenDocument(docPath))  return FALSE;

	// put the focus in the phrase box, after any text
	if (pApp->m_pTargetBox->GetHandle() != NULL && !pApp->m_targetPhrase.IsEmpty()
		&& (pApp->m_pTargetBox->IsShown()))
	{
		int len = pApp->m_pTargetBox->GetTextCtrl()->GetLineLength(0); // line number zero
		// for our phrasebox
		pApp->m_nStartChar = len;
		pApp->m_nEndChar = len;
		pApp->m_pTargetBox->SetFocusAndSetSelectionAtLanding();// whm 13Aug2018 modified
	}
	else
	{
		if (pApp->m_pTargetBox->GetHandle() != NULL && (pApp->m_pTargetBox->IsShown()))
		{
			pApp->m_nStartChar = 0;
			pApp->m_nEndChar = 0;
			pApp->m_pTargetBox->SetFocusAndSetSelectionAtLanding();// whm 13Aug2018 modified
		}
	}

	CMainFrame* pFrame = (CMainFrame*)pView->GetFrame();
	pFrame->Raise();
	if (pApp->m_bZoomed)
		pFrame->SetWindowStyle(wxDEFAULT_FRAME_STYLE
			| wxFRAME_NO_WINDOW_MENU | wxMAXIMIZE);
	else
		pFrame->SetWindowStyle(wxDEFAULT_FRAME_STYLE
			| wxFRAME_NO_WINDOW_MENU);

	gbDoingInitialSetup = FALSE;

	// make sure the menu command is checked or unchecked as necessary
	wxMenuBar* pMenuBar = pFrame->GetMenuBar();
	wxASSERT(pMenuBar != NULL);
	wxMenuItem* pAdvBookMode = pMenuBar->FindItem(ID_ADVANCED_BOOKMODE);
	//wxASSERT(pAdvBookMode != NULL);
	if (pApp->m_bBookMode && !pApp->m_bDisableBookMode)
	{
		// mark it checked
		if (pAdvBookMode != NULL)
		{
			pAdvBookMode->Check(TRUE);
		}
	}
	else
	{
		// mark it unchecked
		if (pAdvBookMode != NULL)
		{
			pAdvBookMode->Check(FALSE);
		}
	}

	if (pApp->m_bReadOnlyAccess)
	{
		// try get an extra paint job done, so background will show all pink from the
		// outset.  Yes, we really DO need this here!!!
		pView->canvas->Refresh();
	}
	return TRUE;                            // success!
}

void CAdapt_ItDoc::OnShowFileLog(wxCommandEvent& WXUNUSED(event))
{
	int     returnCode;
	long    itemIndex = -1;

	gpApp->m_pDVCS->m_version_to_open = -1;     // ensure this is initialized to something

	if (!Git_installed())
		return;                    // Shows message if git not installed

// need to check if a trial is already under way, and if so, bail out

	returnCode = gpApp->m_pDVCS->DoDVCS(DVCS_SETUP_VERSIONS, 0);		// reads the log, and hangs on to it
	if (returnCode < 0)
	{                                           // an error probably means this is a new repository so there's nothing there yet.
		// whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
		gpApp->m_bUserDlgOrMessageRequested = TRUE;
		wxMessageBox(_("There are no previous versions in the history!"));
		return;                                 // in this case we don't show the dialog
	}

	gpApp->m_versionCount = returnCode;         // this is the total number of log entries

	if (returnCode == 0)
	{                                           // there's a repository, but no versions saved yet
		// whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
		gpApp->m_bUserDlgOrMessageRequested = TRUE;
		wxMessageBox(_("There are no previous versions in the history!"));
		return;                                 // in this case we don't show the dialog either
	}

	DVCSLogDlg  logDlg(gpApp->GetMainFrame());
	logDlg.InitDialog();
	returnCode = logDlg.ShowModal();

	// now, which button was hit?
	if (returnCode == wxID_OK)
	{                   // Show selected version
		wxCommandEvent      eventCustom(wxEVT_Show_version);

		itemIndex = logDlg.m_pList->GetNextItem(itemIndex, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
		if (itemIndex == -1) return;

		// We've found that if we just open the nav dialog from here, it doesn't appear as properly in focus on Windows.  So instead
		// we'll post a custom event to do it.

		gpApp->LogUserAction(_T("Posting custom event to open the DVCSNavDlg"));
		gpApp->m_pDVCS->m_version_to_open = (int)itemIndex;     // put the version we want in our DVCS object for the
																// event to pick up
		wxPostEvent(gpApp->GetMainFrame(), eventCustom);       // Custom event handlers are in CMainFrame
	}
}

void CAdapt_ItDoc::OnShowProjectLog(wxCommandEvent& WXUNUSED(event))
{
	if (!Git_installed())
		return;                    // Shows message if git not installed

// We might be going to deprecate this one...
//    gpApp->m_pDVCS->DoDVCS (DVCS_LOG_PROJECT, 0);
}

void CAdapt_ItDoc::OnDVCS_Version(wxCommandEvent& WXUNUSED(event))
{
	if (!gpApp->m_DVCS_installed)
	{
		// whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
		gpApp->m_bUserDlgOrMessageRequested = TRUE;
		wxMessageBox(_T("Git is apparently not yet installed on this computer."));
		return;
	}
	gpApp->m_pDVCS->DoDVCS(DVCS_CHECK, 1);     // nonzero parm means display the returned result in a wxMessageBox.
}

// Update handler for DVCS-related menu items -- these used to be disabled if git wasn't installed, but now they're
//  always enabled, and we give a message if git isn't installed.  We just disable the items if a trial is current,
//  and just have one handler for all the items.

void CAdapt_ItDoc::OnUpdateDVCS_item(wxUpdateUIEvent& event)
{
	if (gpApp->m_bClipboardAdaptMode)
	{
		event.Enable(FALSE);
		return;
	}
	int	 trialRevNum = gpApp->m_trialVersionNum;

	event.Enable((trialRevNum < 0) && (gpApp->m_pKB != NULL) && (gpApp->IsDocumentOpen()));
}

void CAdapt_ItDoc::OnUpdateTakeOwnership(wxUpdateUIEvent& event)
{
	if (gpApp->m_bClipboardAdaptMode)
	{
		event.Enable(FALSE);
		return;
	}
	event.Enable((gpApp->m_owner != gpApp->m_strUserID) && (gpApp->m_trialVersionNum == -1) && (gpApp->m_pKB != NULL) && (gpApp->IsDocumentOpen()));
	// enable only if user isn't the owner, and a trial is not under way
}

void CAdapt_ItDoc::PutPhraseBoxAtDocEnd()
{
	CAdapt_ItApp* pApp = &wxGetApp();
	int sequNumAtEnd = pApp->GetMaxIndex();
	pApp->m_pActivePile = GetPile(sequNumAtEnd); // this may return NULL
	if (pApp->m_pActivePile != NULL)
	{
		pApp->m_nActiveSequNum = sequNumAtEnd;
		wxString boxValue;
		if (gbIsGlossing)
		{
			boxValue = pApp->m_pActivePile->GetSrcPhrase()->m_gloss;
		}
		else
		{
			boxValue = pApp->m_pActivePile->GetSrcPhrase()->m_adaption;
			pApp->m_pTargetBox->m_Translation = boxValue;
		}
		pApp->m_targetPhrase = boxValue;
		pApp->m_pTargetBox->GetTextCtrl()->ChangeValue(boxValue);
		pApp->GetView()->PlacePhraseBox(pApp->m_pActivePile->GetCell(1), 2);
		pApp->GetView()->Invalidate();
	}
}

// a smarter wrapper for DoFileSave(), to replace where that is called in various places
// Is called from the following 8 functions: the App's DoAutoSaveDoc(), OnFileSave(),
// OnSaveModified() and OnFilePackDoc(), the Doc's OnEditConsistencyCheck() and
// DoConsistencyCheck(), and SplitDialog's SplitAtPhraseBoxLocation_Interactive() and
// DoSplitIntoChapters(). Created 29Apr10.
// whm added pProgDlg 24Aug11

bool CAdapt_ItDoc::DoFileSave_Protected(bool bShowWaitDlg, const wxString& progressItem)
{
	wxString pathToSaveFolder;
	wxULongLong originalSize = 0;
	wxULongLong copiedSize = 0;
	bool bRemovedSuccessfully = TRUE;
	ValidateFilenameAndPath(gpApp->m_curOutputFilename, gpApp->m_curOutputPath, pathToSaveFolder);
	bool bOutputFileExists = ::wxFileExists(gpApp->m_curOutputPath);
	wxString prefixStr = _T("tempSave_"); // don't localize this, it's never seen
	wxString newNameStr = prefixStr + gpApp->m_curOutputFilename;
	wxString newFileAbsPath = pathToSaveFolder + gpApp->PathSeparator + newNameStr;
	bool bCopiedSuccessfully = TRUE;
	if (bOutputFileExists)
	{
		// make a unique renamed copy which acts as a temporary backup in case of failure
		// in the call of DoFileSave()
		bCopiedSuccessfully = ::wxCopyFile(gpApp->m_curOutputPath, newFileAbsPath);
		wxASSERT(bCopiedSuccessfully);
		wxFileName fn(gpApp->m_curOutputPath);
		originalSize = fn.GetSize();
		if (bCopiedSuccessfully)
		{
			wxFileName fnNew(newFileAbsPath);
			copiedSize = fnNew.GetSize();
			wxASSERT(copiedSize == originalSize);
		}
	}
	// the call below to DoFileSave() requires that there be an active location - check,
	// and and if the box is at the doc end and not visible, then put it at the end of
	// the document before going on
	if (gpApp->m_pActivePile == NULL || gpApp->m_nActiveSequNum == -1)
	{
		if (gpApp->m_pActivePile != NULL)
		{
			// No use trying if the active pile is NULL - we may be processing a doc
			// which has no visible phrasebox, or the normal GUI isn't being used
			//gpApp->m_bSuppressPseudoDeleteWhenClosingDoc = TRUE;
			PutPhraseBoxAtDocEnd();
			//gpApp->m_bSuppressPseudoDeleteWhenClosingDoc = FALSE;
#if defined(_DEBUG) && !defined(NOLOGS)
			wxLogDebug(_T("DoFileSave_Protected() relocation codeblock: translation = %s , m_pTargetBox has: %s"),
				gpApp->m_pTargetBox->m_Translation.c_str(), gpApp->m_pTargetBox->GetTextCtrl()->GetValue().c_str());
#endif
		}
	}

	// SaveType enum value (2nd param) for the following call is default: normal_save BEW
	// added type, renamed filename, and bUserCancelled params 20Aug10, because they are
	// needed for when this DoFileSave() function is called in OnFileSaveAs(), however
	// other than the normal_save 2nd param, they are not needed when the call is here,
	// within DoFileSave_Protected() and so here we make no use here of the last two
	// returned values
	wxString renamedFilename; renamedFilename.Empty();
	bool bUserCancelled = FALSE;
	bool bSuccess = DoFileSave(bShowWaitDlg, normal_save, &renamedFilename, bUserCancelled, progressItem);
	if (bSuccess)
	{
		// We should update the .usfmstruct file (that was created when 
		// document was first created) with current filter status information. We do that by calling the Doc function:
		// UpdateCurrentFilterStatusOfUsfmStructFileAndArray().
		if (m_bUsfmStructEnabled)
		{
			UpdateCurrentFilterStatusOfUsfmStructFileAndArray(m_usfmStructFilePathAndName);
		}
		if (bOutputFileExists && bCopiedSuccessfully)
		{
			// remove the temporary backup, the original was saved successfully
			bRemovedSuccessfully = wxRemoveFile(newFileAbsPath);
			if (!bRemovedSuccessfully)
			{
				// tell developer or user, if the removal failed
				wxMessageBox(_T("Adapt_ItDoc.cpp, DoFileSave_Protected()'s call of wxRemoveFile() failed, at line 2904. Processing continues, but you should immediately shut down WITHOUT saving, manually remove the old file copy, and then relaunch the application"));
				gpApp->LogUserAction(_T("Adapt_ItDoc.cpp, DoFileSave_Protected()'s call of wxRemoveFile() failed, at line 2904. Processing continues, but you should immediately shut down WITHOUT saving, manually remove the old file copy, and then relaunch the application"));
				return TRUE;
			}
		}
		//#if defined(_DEBUG)
		//		CPile* myPilePtr = gpApp->m_pActivePile;
		//		CSourcePhrase* mySrcPhrasePtr = myPilePtr->GetSrcPhrase();
		//		wxLogDebug(_T("DoFileSave_Protected() before returns TRUE: sn = %d , src key = %s , m_adaption = %s , m_targetStr = %s , m_targetPhrase = %s"),
		//			mySrcPhrasePtr->m_nSequNumber, mySrcPhrasePtr->m_key.c_str(), mySrcPhrasePtr->m_adaption.c_str(),
		//			mySrcPhrasePtr->m_targetStr.c_str(), gpApp->m_targetPhrase.c_str());
		//#endif
		return TRUE;
	}
	else // handle failure
	{
		wxASSERT(!bUserCancelled); // DoFileSave_Protected shows no GUI,
								   // so bUserCancelled should be FALSE
		if (bOutputFileExists)
		{
			if (bCopiedSuccessfully)
			{
				// something failed, but we have a backup to fall back on. Determine if the
				// original remains untruncated, if so, retain it and remove the backup; if
				// not, remove the original and rename the backup to be the original
				bool bSomethingOfThatNameExists = ::wxFileExists(gpApp->m_curOutputPath);
				if (bSomethingOfThatNameExists)
				{
					wxULongLong thatSomethingsSize = 0;
					wxFileName fn(gpApp->m_curOutputPath);
					thatSomethingsSize = fn.GetSize();
					if (thatSomethingsSize == originalSize)
					{
						// we are in luck, the original is still good, so remove the backup
						bRemovedSuccessfully = wxRemoveFile(newFileAbsPath);
						wxASSERT(bRemovedSuccessfully);
					}
					else
					{
						// the size is different, therefore the original was truncated, so
						// restore the document file using the backup renamed
						bRemovedSuccessfully = wxRemoveFile(gpApp->m_curOutputPath);
						wxASSERT(bRemovedSuccessfully);
						bool bRenamedSuccessfully;
						bRenamedSuccessfully = ::wxRenameFile(newFileAbsPath, gpApp->m_curOutputPath);
						if (!bRenamedSuccessfully)
						{
							// tell developer or user, if the rename failed
							wxMessageBox(_T("Adapt_ItDoc.cpp, DoFileSave_Protected()'s call of ::wxRenameFile() failed, at line 2952. Processing continues, but you should immediately shut down WITHOUT saving, manually remove the truncated old file, and then relaunch the application"));
							return TRUE;
						}
					}
				}
				// whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
				gpApp->m_bUserDlgOrMessageRequested = TRUE;
				wxMessageBox(_("Warning: document save failed for some reason.\n"), _T(""), wxICON_EXCLAMATION | wxOK);
				gpApp->LogUserAction(_T("Warning: document save failed for some reason."));
			}
			else // the original was not copied
			{
				// with no backup copy to fall back on, we have to do the best we can;
				// check if the original is still on disk: it may be, and untouched, or it
				// may be, but truncated; in the former case, if its size is unchanged, the
				// just retain it; but if the size is less, we must remove the truncated
				// fragment and tell the user to do an immediate File / Save
				bool bSomethingOfThatNameExists = ::wxFileExists(gpApp->m_curOutputPath);
				bool bOutOfLuck = FALSE;
				if (bSomethingOfThatNameExists)
				{
					wxULongLong thatSomethingsSize = 0;
					wxFileName fn(gpApp->m_curOutputPath);
					thatSomethingsSize = fn.GetSize();
					if (thatSomethingsSize < originalSize)
					{
						// we are out of luck, the original is truncated
						bOutOfLuck = TRUE;
						bRemovedSuccessfully = wxRemoveFile(gpApp->m_curOutputPath);
						if (!bRemovedSuccessfully)
						{
							// tell developer or user, if the removal failed
							wxMessageBox(_T("Adapt_ItDoc.cpp, DoFileSave_Protected()'s call of wxRemoveFile() failed, at line 2984. Processing continues, but you should immediately attempt a re-save of the document, shut down Adapt It, and then relaunch"));
							return TRUE;
						}
					}
				}
				if (bOutOfLuck || !bSomethingOfThatNameExists)
				{
					// warn user to do a file save now while the doc is still in memory
					wxString msg;
					msg = msg.Format(_("Something went wrong. The adaptation document's file on disk was lost or destroyed. If the document is still visible, please click the Save command on the File menu immediately."));
					// whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
					gpApp->m_bUserDlgOrMessageRequested = TRUE;
					wxMessageBox(msg, _("Immediate Save Is Recommended"), wxICON_EXCLAMATION | wxOK);
					gpApp->LogUserAction(_T("Something went wrong. The adaptation document's file on disk was lost or destroyed. If the document is still visible, please click the Save command on the File menu immediately."));
				}
			}
		}
		else // there was no original already saved to disk when OnFileSaveAs() was invoked
		{
			// either there is no original on disk still, or, there may be a truncated
			// save, either way, we must remove anything there..
			bool bTruncatedFragmentExists = ::wxFileExists(gpApp->m_curOutputPath);
			if (bTruncatedFragmentExists)
			{
				bRemovedSuccessfully = wxRemoveFile(gpApp->m_curOutputPath);
				wxASSERT(bRemovedSuccessfully);
				// warn user to do a file save now while the doc is still in memory
				wxString msg;
				msg = msg.Format(_("Something went wrong. The adaptation document was not saved to disk. Please click the Save command on the File menu immediately, and if the error persists, try the Save As... command instead - if that does not work, you are out of luck and the open document will not be saved, so shut down and start again."));
				gpApp->LogUserAction(msg);
				// whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
				gpApp->m_bUserDlgOrMessageRequested = TRUE;
				wxMessageBox(msg, _("Immediate Save Is Recommended"), wxICON_EXCLAMATION | wxOK);
			}
		}
	}
	return FALSE;
}

bool CAdapt_ItDoc::DoCollabFileSave(const wxString& progressItem, wxString msgDisplayed) // whm added 17Jan12
{
	// we want the phrase box's contents put into the document, so that the export of
	// the pre-user-editing-happens adaptation text will have the box contents in it -
	// so get it done here, but don't bother about the save to KB because the
	// DoFileSave_Protected(TRUE) call later below will get that job done
	bool bAttemptStoreToKB = FALSE;
	bool bNoStore = FALSE; // default, it's initialized to FALSE internally anyway
	bool bSuppressWarningOnStoreKBFailure = TRUE; // we don't want a warning (we won't try

	// If this document is "protected" just save the changes locally by calling the
	// DoFileSave_Protected() function, then return without executing the code below
	// that prepares and saves changes to the external editor
	bool bProtectedFromSavingChangesToExternalEditor = FALSE;
	bProtectedFromSavingChangesToExternalEditor = DocumentIsProtectedFromTransferringDataToEditor();
	if (bProtectedFromSavingChangesToExternalEditor)
	{
		UpdateDocWithPhraseBoxContents(bAttemptStoreToKB, bNoStore, bSuppressWarningOnStoreKBFailure);

		// Do a local normal protected save to AI's native storage
		DoFileSave_Protected(TRUE, progressItem); // // TRUE means - show wait/progress dialog
		return TRUE;
	}

	// mrh 5Jun14 -- we now put our check for the collaborative editor running right here at the start, and do absolutely
	//  nothing if it's unsafe.

	if (!CollaborationEditorAcceptsDataTransfers())
	{
		wxString msg;
		msg = msg.Format(_("Adapt It cannot transfer your work to %s while %s is running.\nClick on OK to close this dialog. Leave Adapt It running, switch to %s and shut it down. Then switch back to Adapt It and do the save operation again."),
			gpApp->m_collaborationEditor.c_str(), gpApp->m_collaborationEditor.c_str(), gpApp->m_collaborationEditor.c_str());

		// whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
		gpApp->m_bUserDlgOrMessageRequested = TRUE;
		wxMessageBox(msg, _("Collaboration editor is running"), wxOK);
		return false;    // Bail out on an unsafe collaboration situation
	}

	UpdateDocWithPhraseBoxContents(bAttemptStoreToKB, bNoStore, bSuppressWarningOnStoreKBFailure);

	wxString postEditText;
	wxString updatedText;
	updatedText = MakeUpdatedTextForExternalEditor(gpApp->m_pSourcePhrases,
		makeTargetText, postEditText);
	// comment out the #define when a wxLogDebug listing of the updated text is not wanted
//#define _HAVE_A_LOOK
#if defined (_HAVE_A_LOOK) && !defined(NOLOGS)
#ifdef _DEBUG
	// have a look at what we got
	wxLogDebug(_T("\n *** OnFileSave(): updatedText to transfer to PT or BE when collaborating ***\n"));
	// wxLogDebug refuses to show updatedText, so maybe text is too long, so try
	// cutting it up into 3 pieces first -- yes, that works, the text was about 35,000
	// characters, so wxLogDebug happily outputs 1but 12,000, maybe more, but perhaps
	// it is limited to a 32 Kb buffer.
	//wxLogDebug(_T("%s\n"), updatedText.c_str());
	int count = updatedText.Len();
	int abit = count / 3;
	wxString acopy = updatedText;
	wxString first = acopy.Left(abit);
	acopy = acopy.Mid(abit);
	wxString second = acopy.Left(abit);
	acopy = acopy.Mid(abit);
	wxLogDebug(_T("%s\n"), first.c_str());
	wxLogDebug(_T("%s\n"), second.c_str());
	wxLogDebug(_T("%s\n"), acopy.c_str());

#endif
#endif
	// For testing purposes, assume it's target text, and a single-chapter
	// document...actually, there's nothing in the MakeUpdatedTextForExternalEditor()
	// internals that predisposes towards a single chapter doc or a whole book doc - it
	// is deliberately written so as to be agnostic about which is the case, it just
	// knows there is a doc containing information to extract and send to PT or BE,
	// with possibly some automated conflict resolution to be done when doing so.

	bool bMovedTextOK = TRUE;
	long resultTgt = -1; // reset to 0 if all goes well
	long resultFreeTrans = -1; // ditto
	wxArrayString outputTgt, outputFreeTrans; // for feedback from ::wxExecute()
	wxArrayString errorsTgt, errorsFreeTrans; // for feedback from ::wxExecute()

	if (!updatedText.IsEmpty())
	{
		// Get the updatedText to a file of the required name (overwriting the older
		// one already there) in the .temp folder; then make the command line for
		// target text and transfer the text to the external editor -- the following
		// calls internally make all the decisions necessary, such as whether a whole
		// book or just a chapter is to be sent, its filename, whether to Bibledit or
		// Paratext, and so forth, using member variables stored in the application
		// class  (don't add a BOM)
		if (gpApp->m_bCollaboratingWithParatext)
		{
			msgDisplayed = _("Please wait while the translation is sent to Paratext...");
		}
		else if (gpApp->m_bCollaboratingWithBibledit)
		{
			msgDisplayed = _("Please wait while the translation is sent to Bibledit...");
		}

		// whm 21Sep11 modified. For chapter sized transfers back to the external editor
		// we need to remove the \id XXX line from the updatedText string.
		// BEW 8Oct11, it needs to be earlier and also done on a free trans text too, so now
		// it's in MakeUpdatedTextForExternalEditor(), with the call RemoveIDMarkerAndCode()
		//if (gpApp->m_bCollabByChapterOnly && updatedText.Find(_T("\\id")) != wxNOT_FOUND)
		//{
			// the \id XXX line should be of the form:
		//	wxString idLine = _T("\\id XXX") + gpApp->m_eolStr;
		//	int idLineLen = idLine.Length();
		//	updatedText = updatedText.Mid(idLineLen); // retains the rest of the string after the idLineLen
		//}
		bMovedTextOK = MoveTextToTempFolderAndSave(collab_target_text, updatedText);
		// we don't expect an error, but tell the developer or user if there was one
		// and keep on processing
		if (!bMovedTextOK)
		{
			wxMessageBox(_T("Adapt_ItDoc.cpp, OnFileSave()'s call of MoveTextToTempFolderAndSave() failed, at line 3138. Processing continues, but you should immediately shut down WITHOUT saving, and then relaunch the application"));
			return FALSE;
		}
		resultTgt = -1;  outputTgt.Clear(); errorsTgt.Clear();
		TransferTextBetweenAdaptItAndExternalEditor(writing, collab_target_text,
			outputTgt, errorsTgt, resultTgt);

		// error handling
		wxString msg;
		// BEW 27Feb15 added more details about a possible fix for the likely cause of the problem
		if (resultTgt != 0)
		{
			wxASSERT(!gpApp->m_collaborationEditor.IsEmpty());
			// Not likely to happen, but it is possible if there are no books created for the PT/BE
			// project, or the files are locked/access denied.
			//msg = msg.Format(msg,gpApp->m_collaborationEditor.c_str(),gpApp->m_collaborationEditor.c_str());
			wxString temp1;
			temp1 = temp1.Format(_T("PT/BE Collaboration wxExecute returned error when writing target text. resultTgt = %d (Paratext permissions problem? rdwrtp7 returned: )"), resultTgt);
			gpApp->LogUserAction(temp1);
//			wxLogDebug(temp1);
			int ct;
			wxString temp;
			temp.Empty();
			for (ct = 0; ct < (int)outputTgt.GetCount(); ct++)
			{
				temp += outputTgt.Item(ct);
				gpApp->LogUserAction(temp);
//				wxLogDebug(temp);
			}
			temp1 += temp;
			temp.Empty();
			for (ct = 0; ct < (int)errorsTgt.GetCount(); ct++)
			{
				temp += errorsTgt.Item(ct);
				gpApp->LogUserAction(temp);
//				wxLogDebug(temp);
			}
			temp1 += temp;
			msg = temp1;
			wxMessageBox(msg, _T(""), wxICON_EXCLAMATION | wxOK);
			wxString msg2;
			wxString title = _("Elevate Permission Level?");
			msg2 = msg2.Format(_("Probably the owner of the text being transferred lacks Translator or Administrator permission level for the target text project within Paratext, or Bibledit.\nA permissison level that allows editing is necessary for a successful transfer of text when collaborating."));
			wxMessageBox(msg2, title, wxICON_INFORMATION | wxOK);
			return FALSE;
		} // end of TRUE block for test: if (resultTgt != 0)

		// The returned postEditText (as exported from the AI document at the time the
		// File / Save was invoked) now has to replace the saved preEditText in the
		// private app member for that purpose, becoming the new preEditTargetText
//#if defined(_DEBUG)
//		wxLogDebug(_T("\n\nStoreTargetText_PreEdit(postEditText) in Doc.cpp 2512: %s"), postEditText.c_str());
//#endif
		gpApp->StoreTargetText_PreEdit(postEditText);

		if (gpApp->m_bCollaborationExpectsFreeTrans)
		{
			// make a second call of MakeUpdatedTextForExternalEditor(), this time with
			// param2 set to makeFreeTransText, param1 and param3 are the same, and
			// when it returns, postEditFreeTransText is the free translation which has
			// to be saved in the app member for that purpose, becoming the new
			// preEditFreeTransText -- use StoreFreeTransText_PreEdit() to do that
			wxString postEditFreeTransText;
			wxString updatedFreeTransText = MakeUpdatedTextForExternalEditor(gpApp->m_pSourcePhrases,
				makeFreeTransText, postEditFreeTransText);
#if defined (_HAVE_A_LOOK)  && !defined(NOLOGS)
#ifdef _DEBUG
			// have a look at what we got
			wxLogDebug(_T("\n *** OnFileSave(): updatedFreeTransText to transfer to PT or BE when collaborating ***\n"));
			//wxLogDebug(_T("%s\n"), updatedFreeTransText.c_str());
			// wxLogDebug refuses to show updatedText, so maybe text is too long, so try
			// cutting it up into 3 pieces first -- yes, that works, the text was about 35,000
			// characters, so wxLogDebug happily outputs about 12,000, maybe more, but perhaps
			// it is limited to a 32 Kb buffer.
			int count = updatedFreeTransText.Len();
			int abit = count / 3;
			wxString acopy = updatedFreeTransText;
			wxString first = acopy.Left(abit);
			acopy = acopy.Mid(abit);
			wxString second = acopy.Left(abit);
			acopy = acopy.Mid(abit);
			wxLogDebug(_T("%s\n"), first.c_str());
			wxLogDebug(_T("%s\n"), second.c_str());
			wxLogDebug(_T("%s\n"), acopy.c_str());
#endif
#endif
			if (!updatedFreeTransText.IsEmpty())
			{
				// Get the updatedFreeTransText to a file of the required name
				// (overwriting the older one already there) in the .temp folder; then
				// make the command line for free translation text and transfer the
				// text to the external editor -- the following calls internally make
				// all the decisions necessary, such as whether a whole book or just a
				// chapter is to be sent, its filename, whether to Bibledit or
				// Paratext, and so forth, using member variables stored in the
				// application class (don't add a BOM)
				if (gpApp->m_bCollaboratingWithParatext)
				{
					msgDisplayed = _("Please wait while the free translation is sent to Paratext...");
				}
				else if (gpApp->m_bCollaboratingWithBibledit)
				{
					msgDisplayed = _("Please wait while the free translation is sent to Bibledit...");
				}

				bMovedTextOK = MoveTextToTempFolderAndSave(collab_freeTrans_text, updatedFreeTransText);
				resultFreeTrans = -1;  outputFreeTrans.Clear(); errorsFreeTrans.Clear();
				TransferTextBetweenAdaptItAndExternalEditor(writing, collab_freeTrans_text,
					outputFreeTrans, errorsFreeTrans, resultFreeTrans);
				// error handling
				if (resultFreeTrans != 0)
				{
					wxASSERT(!gpApp->m_collaborationEditor.IsEmpty());
					// Not likely to happen, but it is possible if there are no books created for the PT/BE
					// project, or the files are locked/access denied.
					//msg = msg.Format(msg,gpApp->m_collaborationEditor.c_str(),gpApp->m_collaborationEditor.c_str());
					wxString temp1;
					temp1 = temp1.Format(_T("PT/BE Collaboration wxExecute returned error when writing free translation text. resultFreeTrans = %d (PT permissions problem?) rdwrtp7 returned: "), resultFreeTrans);
					gpApp->LogUserAction(temp1);
//					wxLogDebug(temp1);
					int ct;
					wxString temp;
					temp.Empty();
					for (ct = 0; ct < (int)outputFreeTrans.GetCount(); ct++)
					{
						temp += outputFreeTrans.Item(ct);
						gpApp->LogUserAction(temp);
//						wxLogDebug(temp);
					}
					temp1 += temp;
					temp.Empty();
					for (ct = 0; ct < (int)errorsFreeTrans.GetCount(); ct++)
					{
						temp += errorsFreeTrans.Item(ct);
						gpApp->LogUserAction(temp);
//						wxLogDebug(temp);
					}
					temp1 += temp;
					msg = temp1;
					wxMessageBox(msg, _T(""), wxICON_EXCLAMATION | wxOK);
					wxString msg2;
					wxString title = _("Elevate Permission Level?");
					msg2 = msg2.Format(_("Probably the owner of the text being transferred lacks Translator or Administrator permission level for the target text project within Paratext, or Bibledit.\nA permissison level that allows editing is necessary for a successful transfer of text when collaborating."));
					wxMessageBox(msg2, title, wxICON_INFORMATION | wxOK);
					return FALSE;
				} // end of TRUE block for test: if (resultFreeTrans != 0)

				// the returned postEditFreeTransText (as exported from the AI document
				// at the time the File / Save was invoked) now has to replace the
				// saved preEditFreeTransText in the private app member for that
				// purpose, becoming the new preEditFreeTransText
				gpApp->StoreFreeTransText_PreEdit(postEditFreeTransText);
			}
		}

		// and then also do a local normal protected save to AI's native storage;
		DoFileSave_Protected(TRUE, progressItem); // // TRUE means - show wait/progress dialog
	}
	else
	{
		// returned an empty string, this indicates some kind error or unsafe situation
		// - which should have been seen already -- this is unlikely to ever happen so
		// just beep but still do the protected local save - the word done should never
		// be lost
		wxBell();
		DoFileSave_Protected(TRUE, progressItem); // // TRUE means - show wait/progress dialog
		// whm added 11Mar12. This situation occurrs if the user attempted to save while
		// Paratext is running, and instead of closing down Paratext, clicks the Cancel
		// button of the message prompt. The local AI doc gets saved by the DoFileSave_Protected()
		// call above, but the doc is then marked "clean" rather than "dirty" which with
		// respect to the Paratext data is not true. Immediately after getting here the
		// AI doc is not dirty and so the Save button and File | Save are disabled. To give
		// the user the opportunity of doing another save without having to do something
		// to make the doc dirty again, we'll set the doc as modified here
		this->Modify(TRUE);
		return FALSE;
	}
	return TRUE;
}


///////////////////////////////////////////////////////////////////////////////
/// \return TRUE if file was successfully saved; FALSE otherwise ( the return value
///         may not be used by some functions which call this one, such as OnFileSave()
///         or OnFileSaveAs() )
/// \param	bShowWaitDlg	 -> if TRUE the wait/progress dialog is shown, otherwise it
///                             is not shown
/// \param  type             -> an enum value, either normal_save or, save_as, depending
///                             whether the user chose Save or Save As... command, respectively
/// \param  pRenamedFilename -> pointer to a string which is the new filename (it may
///                             have an attached extension which our code will remove
///                             and replace with .xml), if the user requested a rename,
///                             but will be (default) NULL if no renamed filename was
///                             supplied, or if the user chose Save command.
/// \param  bUserCancelled   <- ref to boolean, to tell caller when the return was due to
///                             user clicking the Cancel button in the OnFileSaveAs()
///                             function, however most calls (8 of the 9) are made from
///                             DoFileSave_Protected() and the latter makes no use of the
///                             values returned in the 3rd and 4th params.
/// \param pProgDlg         <-> pointer to an wxProgress dialog started up in OnFileSave()
/// \remarks
/// Called from: the Doc's OnFileSaveAs(); also called within DoFileSave_Protected() where
/// the latter is called from the following 8 functions: the App's DoAutoSaveDoc(),
/// OnFileSave(), OnSaveModified() and OnFilePackDoc(), the Doc's OnEditConsistencyCheck()
/// and DoConsistencyCheck(), and SplitDialog's SplitAtPhraseBoxLocation_Interactive() and
/// DoSplitIntoChapters().
/// Saves the current document and KB files in XML format and takes care of the necessary
/// housekeeping involved.
/// Ammended for handling saving when glossing or adapting.
/// BEW modified 13Nov09, if the local user has only read-only access to a remote
/// project folder, the local user must not be able to cause his local copy of the
/// remote document to be saved to the remote user's disk; if that could happen, the
/// remote user would almost certainly lose some of his edits
/// BEW 16Apr10, added SaveType param, for support of Save As... menu item
/// BEW 20Aug10, changed 2nd and 3rd params to have no default, and added the bool
/// reference 4th param (needed for OnFileSaveAs())
///////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItDoc::DoFileSave(bool bShowWaitDlg, enum SaveType type,
	wxString* pRenamedFilename, bool& bUserCancelled,
	const wxString& progressItem)
{
	bUserCancelled = FALSE;

#if defined(_DEBUG) && !defined(NOLOGS)
	CPile* myPilePtr = gpApp->m_pActivePile;
	if (myPilePtr != NULL)
	{
		CSourcePhrase* mySrcPhrasePtr = myPilePtr->GetSrcPhrase();
		wxLogDebug(_T("DoFileSave() start: sn = %d , src key = %s , m_adaption = %s , m_targetStr = %s , m_targetPhrase = %s"),
			mySrcPhrasePtr->m_nSequNumber, mySrcPhrasePtr->m_key.c_str(), mySrcPhrasePtr->m_adaption.c_str(),
			mySrcPhrasePtr->m_targetStr.c_str(), gpApp->m_targetPhrase.c_str());
	}
#endif

	// BEW added 19Apr10 -- ensure we start with the latest doc version for saving if the
	// save is a normal_save, but if a Save As... was asked for, the user may be about to
	// choose a legacy doc version number for the save, in which case the call of the
	// wxFileDialog below may result in a different value being set by the code further
	// below
	RestoreCurrentDocVersion();  // assume the default
	m_bLegacyDocVersionForSaveAs = FALSE; // initialize private member
	m_bDocRenameRequestedForSaveAs = FALSE; // initialize private member
	bool bDummySrcPhraseAdded = FALSE;
	SPList::Node* posLast = NULL;

	// refactored 9Mar09
	wxFile f; // create a CFile instance with default constructor
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);

	if (pApp->m_bReadOnlyAccess)
	{
		return TRUE; // let the caller think all is well, even though the save is suppressed
	}

	CAdapt_ItView* pView = (CAdapt_ItView*)GetFirstView();

	pApp->LogUserAction(_T("Initiated File Save by calling DoFileSave()"));

	// make the working directory the "Adaptations" one; or the current Bible book folder
	// if the m_bBookMode flag is TRUE

	// There are at least three ways within wxWidgets to change the current
	// working directory:
	// (1) Use ChangePathTo() method of the wxFileSystem class,
	// (2) Use the static SetCwd() method of the wxFileName class,
	// (3) Use the global namespace method ::wxSetWorkingDirectory()
	// We'll regularly use ::wxSetWorkingDirectory()
	bool bOK;
	wxString pathToSaveFolder; // use this with Save As... to prevent a change of working directory

	// whm 8Apr2021 added wxLogNull block below
	{
		wxLogNull logNo;	// eliminates any spurious messages from the system if the wxSetWorkingDirectory() call returns FALSE

		if (pApp->m_bBookMode && !pApp->m_bDisableBookMode)
		{
			// save to the folder specified by app's member  m_bibleBooksFolderPath
			bOK = ::wxSetWorkingDirectory(pApp->m_bibleBooksFolderPath);
			pathToSaveFolder = pApp->m_bibleBooksFolderPath;
		}
		else
		{
			// do legacy save, to the Adaptations folder
			bOK = ::wxSetWorkingDirectory(pApp->m_curAdaptationsPath);
			pathToSaveFolder = pApp->m_curAdaptationsPath;
		}
	} // end of wxLogNull scope
	if (!bOK)
	{
		// BEW changed 23Apr10, I've never know the working directory set call to fail if a
		// valid path is supplied, so this would be an extraordinary situation - to proceed
		// may or may not result in a valid save, but we risk a crash, so we should play
		// save and abort the save attempt. But the message should not be localizable as it
		// is almost certain that it will never be seen.
		wxMessageBox(_T(
			"Failed to set the current working directory. The save operation was not attempted."),
			_T(""), wxICON_EXCLAMATION | wxOK);
		m_bLegacyDocVersionForSaveAs = FALSE; // restore default
		m_bDocRenameRequestedForSaveAs = FALSE; // ditto
		pApp->LogUserAction(_T("Failed to set the current working directory. The save operation was not attempted."));
		return FALSE;
	}


	// if the phrase box is visible and has the focus, then its contents will have been
	// removed from the KB, so we must restore them to the KB, then after the save is done,
	// remove them again; but only provided the pApp->m_targetBox's window exists
	// (otherwise GetStyle call will assert)
	bool bNoStore = FALSE;
	bOK = FALSE;

	// BEW 9Aug11, in the call below, param1 TRUE is bAttemptStoreToKB, param2 bNoStore
	// returns TRUE to the caller if the attempted store fails for some reason, for all
	// other circumstances it returns FALSE, and param3 bSuppressWarningOnStoreKBFailure
	// has its default value of FALSE; this call replaces the commented out stuff
	// immediately following the call. The function is defined in helpers.cpp because we
	// need it elsewhere besides here
	UpdateDocWithPhraseBoxContents(TRUE, bNoStore);

	// get the path correct, including correct filename extension (.xml) and the backup
	// doc filenames too; the m_curOutputPath returns is the full path, that is, it ends
	// with the contents of the returned m_curOutputFilename value built in; the third
	// param may be useful in some contexts (see OnFileSave() and OnFileSaveAs()), but not
	// here
	wxString unwantedPathToSaveFolder;
	ValidateFilenameAndPath(gpApp->m_curOutputFilename, gpApp->m_curOutputPath,
		unwantedPathToSaveFolder); // we don't use 3rd param here
	if (!f.Open(gpApp->m_curOutputFilename, wxFile::write))
	{
		gpApp->LogUserAction(_T("Failed f.Open() for writing in DoFileSave()"));
		return FALSE; // if we get here, we'll miss unstoring from the KB, but its not likely
					  // to happen, so we'll not worry about it - it wouldn't matter much anyway
	}

	CSourcePhrase* pSrcPhrase;
	CBString aStr;
	CBString openBraceSlash = "</"; // to avoid "warning: deprecated conversion from string constant to 'char*'"

	// prologue (Changed BEW 02July07 at Bob Eaton's request)
	gpApp->GetEncodingStringForXmlFiles(aStr);
	DoWrite(f, aStr);

	// add the comment with the warning about not opening the XML file in MS WORD
	// 'coz is corrupts it - presumably because there is no XSLT file defined for it
	// as well. When the file is then (if saved in WORD) loaded back into Adapt It,
	// the latter goes into an infinite loop when the file is being parsed in.
	aStr = MakeMSWORDWarning(); // the warning ends with \r\n so we don't need to add them here

	// doc opening tag
	aStr += "<";
	aStr += xml_adaptitdoc;
	aStr += ">\r\n"; // eol chars OK for cross-platform???
	DoWrite(f, aStr);

	// in case file rename is wanted... from the Save As dialog
	wxString theNewFilename = _T("");
	bool bFileIsRenamed = FALSE;

	// if Save As... was chosen, its dialog should be shown here because the xml from this
	// point on needs to know which docVersion number to use
	if (type == save_as)
	{
		// get a file dialog (note: the user may ask for a save done with a legacy doc
		// version number in this dialog)
		wxString defaultDir = pathToSaveFolder; // set above
		wxString filter;
		filter = _("New XML format, for 6.0.0 and later (default)|*.xml|Legacy XML format, as in versions 3, 4 or 5. |*.xml||");
		wxString filename = gpApp->m_curOutputFilename;

	retry:	bFileIsRenamed = FALSE;
		wxFileDialog fileDlg(
			(wxWindow*)wxGetApp().GetMainFrame(), // MainFrame is parent window for file dialog
			_("Save As"),
			defaultDir,	// an empty string would cause it to use the current working directory
			filename,	// the current document's filename
			filter, // the SaveType option - currently there are two, default is doc version 5, the other is doc version 4
			wxFD_SAVE); // don't want wxFD_OVERWRITE_PROMPT as part of the style param
						 // because if user changes filename, we'll save with the new
						 // name and after verifying the file is on disk and okay, we'll
						 // silently remove the old version, so that there is only one
						 // file with the document's data after a save of any kind
		fileDlg.Centre();

		// make the dialog visible
		if (fileDlg.ShowModal() != wxID_OK)
		{
			// user cancelled, while this is not strictly a failure we return FALSE
			// because the original will have been truncated, and so the caller must
			// restore it
			RestoreCurrentDocVersion(); // ensure a subsequent save uses latest doc version number
			m_bLegacyDocVersionForSaveAs = FALSE; // restore default
			m_bDocRenameRequestedForSaveAs = FALSE; // ditto
			f.Close();
			bUserCancelled = TRUE; // inform the caller that the user hit the Cancel button
			gpApp->LogUserAction(_T("Cancelled from Save As at wxFileDialog()"));
			return FALSE;
		}

		// check that the user did not change the folder's path, the user must not be able
		// to do this in Adapt It, the location for saving documents is fixed and the
		// pathToSaveFolder has been set to whatever it is for this session
		wxFileName fn(fileDlg.GetPath());
		wxString usersChosenFolderPath = fn.GetPath();
		if (pathToSaveFolder != usersChosenFolderPath)
		{
			// warn user to try again
			wxString msg;
			msg = msg.Format(_("You must not use the Save As... dialog to change where Adapt It stores its document files. You can only rename the file, or make a different 'Save as type' choice, or both."));
			// whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
			gpApp->m_bUserDlgOrMessageRequested = TRUE;
			wxMessageBox(msg, _("Folder Change Is Not Allowed"), wxICON_EXCLAMATION | wxOK);
			gpApp->LogUserAction(_T("Folder Change Is Not Allowed"));
			goto retry;
		}

		// Determine if a file rename is wanted and ensure there is no name clash; for a
		// clash, reenter the dialog and start afresh after warning the user, if no clash,
		// set a boolean because we will do the rename **AFTER** document backup (which may
		// or may not be wanted), at the end of the calling function (renames are only
		// possible from a call of the OnFileSaveAs() function. (And document backup will
		// also do the needed backup file renaming at the end of the BackupDocument()
		// function -- fortunately, BackupDocument() uses an independent
		// m_curOutputBackupFilename (an app member currently, but that may change soon so
		// as to be on the doc class) and so the backup document file and its path updating
		// can be done completely within BackupDocument() without affecting the delay of
		// renaming the document until control returns to OnFileSaveAs(); and we'll leave
		// OnFileSaveAs to do the needed path updates for the renamed doc file.)
		theNewFilename = fileDlg.GetFilename();
		if (theNewFilename != filename)
		{
			// whm added 27Jun11 check for attempt to rename a _Collab... file using the
			// File | Save As function. Adapt It documents created under Collaboration with
			// PT or BE should not be renamed, otherwise it may break the internal linkage
			// of the PT/BE projects and their book files to a given set of AI docs.
			if (pApp->m_bCollaboratingWithParatext || pApp->m_bCollaboratingWithBibledit)
			{
				wxString msg;
				msg = _("Adapt It documents cannot be renamed when collaborating with Paratext or Bibledit.");
				// whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
				gpApp->m_bUserDlgOrMessageRequested = TRUE;
				wxMessageBox(msg, _("Cannot Change The Document's Filename"), wxICON_EXCLAMATION | wxOK);
				theNewFilename.Empty();
				gpApp->LogUserAction(_T("Cannot Change The Document's Filename"));
				goto retry;
			}

			// check for illegal characters in the user's typed new filename (this code
			// taken from OutputFilenameDlg::OnOK() and tweaked a bit)
			wxString fn = theNewFilename;
			wxString illegals = wxFileName::GetForbiddenChars(); //_T(":?*\"\\/|<>");
			wxString scanned = SpanExcluding(fn, illegals);
			if (scanned != fn)
			{
				// there is at least one illegal character,; beep and show the illegals to the
				// user and then re-enter the dialog to start over from scratch; illegals
				// are characters such as:  :?*\"\|/<>
				::wxBell();
				wxString message;
				message = message.Format(
					_("Filenames cannot include these characters: %s Please type a valid filename using none of those characters."), illegals.c_str());
				// whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
				gpApp->m_bUserDlgOrMessageRequested = TRUE;
				wxMessageBox(message, _("Bad Characters In Filename"), wxICON_INFORMATION | wxOK);
				theNewFilename.Empty();
				gpApp->LogUserAction(_T("Bad Characters In Filename"));
				goto retry;
			}

			// check for a name conflict
			if (FilenameClash(theNewFilename))
			{
				wxString msg;
				msg = msg.Format(_("The new filename you have typed conflicts with an existing filename. You cannot use that name, please type another."));
				// whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
				gpApp->m_bUserDlgOrMessageRequested = TRUE;
				wxMessageBox(msg, _("Conflicting Filename"), wxICON_EXCLAMATION | wxOK);
				theNewFilename.Empty();
				gpApp->LogUserAction(_T("Conflicting Filename"));
				goto retry;
			}
			else
			{
				bFileIsRenamed = TRUE; // theNewFilename has the renamed filename string
			}
		}
		if (bFileIsRenamed)
		{
			m_bDocRenameRequestedForSaveAs = TRUE; // set the private member, as the caller
												   // will need this flag for updating
												   // the window Title, and caller will
												   // restore its default FALSE value
			if (theNewFilename.IsEmpty())
			{
				// can't use an empty string as a filename, so stick with the current one,
				// return to the caller an empty string so that no rename is done
				pRenamedFilename->Empty();
			}
			else
			{
				// we've a string to return to caller for it to set up the new filename;
				// but first make sure we have an .xml extension on the new filename
				wxString thisFilename = theNewFilename;
				thisFilename = MakeReverse(thisFilename);
				wxString extn = thisFilename.Left(4);
				extn = MakeReverse(extn);
				// BEW 29Oct22 protect call
				int extnLen = extn.Len();
				bool bIsDot = TRUE; // initialise
				if (extnLen > 0)
				{
					bIsDot = (extn.GetChar(0) == _T('.'));
					if (bIsDot)
					{
						// we can assume it is an extension because it begins with a period
						if (extn != _T(".xml"))
						{
							thisFilename = thisFilename.Mid(4); // remove the .adt extension or whatever
							thisFilename = MakeReverse(thisFilename);
							thisFilename += _T(".xml"); // it's now *.xml
						}
						else
						{
							thisFilename = MakeReverse(thisFilename); // it's already *.xml
						}
						*pRenamedFilename = thisFilename;
					}
					else // extn doesn't begin with a period
					{
						// assume the user didn't add and extension and that what we cut off
						// was part of his file title, so add .xml to what he typed
						theNewFilename += _T(".xml");
						*pRenamedFilename = theNewFilename;
					}
				} // end of TRUE block for test: if (extnLen > 0)
			}
		}
		else
		{
			pRenamedFilename->Empty();  // tells caller no rename is wanted
		}
		// delay any requested doc file rename to the end of the calling function...

		// get the docVersion number the user wants used for the save, an index value of 0
		// always uses the VERSION_NUMBER as currently set, as does leaving any any
		// parameter (since 0 is the default if left out), but index values 1 or higher
		// select a legacy docVersion number (which gives different XML structure)
		// (currently the only other index value supported is 1, which maps to doc version
		// 4) Don't permit the possibility of a File Type change until the tests above
		// leading to reentrancy have been passed successfully
		int filterIndex = fileDlg.GetFilterIndex();
		SetDocVersion(filterIndex);

		// Execution control now takes one of two paths: if the user chose filterIndex ==
		// 0 item, which is VERSION_NUMBER's docVersion (currently == 6), then the code
		// for a norm Save is to be executed (except that in the Save As.. dialog he may
		// have also requested a document rename, in which case a block at the end of this
		// function will do that as well, as well as for when he makes the docVersion 4
		// choice). But if he chose filterIndex == 1 item, this is for docVersion set to
		// DOCVERSION4 (always == 4), in which case extra work has to be done - deep
		// copies of CSourcePhrase need to be created, and passed to a conversion function
		// FromDocVersion5ToDocVersion4() and the XML built from the converted deep copy
		// (to prevent corrupting the internal data structures which are docVersion5
		// compliant)
		// BEW 13Feb12, the old test won't work right now that 6 rather than 5 is the
		// current value of VERSION_NUMBER, so comment out the legacy way to set the
		// boolean, and do a better way -- that will work right if we later version the
		// document to 7 or 8, etc
		//m_bLegacyDocVersionForSaveAs = m_docVersionCurrent != (int)VERSION_NUMBER;
		if (filterIndex > 0)
		{
			// docVersion4 is wanted
			m_bLegacyDocVersionForSaveAs = TRUE;
		}
		else
		{
			// docVersion = the current VERSION_NUMBER value is wanted; currently it's 8
			m_bLegacyDocVersionForSaveAs = FALSE;
		}

		if (m_bLegacyDocVersionForSaveAs)
		{
			// Saving in doc version 4 may require the addition of a doc-final dummy
			// CSourcePhrase instance to carry moved endmarkers. We'll add such temporarily,
			// but only when needed, and remove it when done. It's needed if the very last
			// CSourcePhrase instance has a non-empty m_endMarkers member.
			posLast = gpApp->m_pSourcePhrases->GetLast();
			CSourcePhrase* pLastSP = posLast->GetData();
			wxASSERT(pLastSP != NULL);
			if (!pLastSP->GetEndMarkers().IsEmpty())
			{
				// we need a dummy one at the end
				bDummySrcPhraseAdded = TRUE;
				int aCount = gpApp->m_pSourcePhrases->GetCount();
				CSourcePhrase* pDummyForLast = new CSourcePhrase;
				gpApp->m_pSourcePhrases->Append(pDummyForLast);
				pDummyForLast->m_nSequNumber = aCount;
			}
		}
	} // end of TRUE block for test: if (type == save_as)

	// place the <Settings> element at the start of the doc (this has to know what the
	// user chose for the SaveType, so this call has to be made after the
	// SetDocVersion() call above - as that call sets the doc's save state which
	// remains in force until changed, or restored by a RestoreCurrentDocVersion() call
	//
	// BEW 27Feb12, internally checks the value of m_bLegacyDocVersionForSaveAs flag, and
	// if TRUE, then it doesn't construct the docV6 attribute (first used in release
	// 6.2.0) for the m_bDefineFreeTransByPunctuation flag (see Adapt_It.h) as part of the
	// <Settings? tag
	aStr = ConstructSettingsInfoAsXML(1); // internally sets the docVersion attribute
							// to whatever is the current value of m_docVersionCurrent
	DoWrite(f, aStr);

	// prepare for progress dialog
	int counter;
	counter = 0;
	int nTotal = gpApp->m_pSourcePhrases->GetCount();
	wxString progMsg = _("Saving File %s  - %d of %d Total words and phrases");
	wxFileName fn(gpApp->m_curOutputFilename);
	wxString msgDisplayed = progMsg.Format(progMsg, fn.GetFullName().c_str(), 0, nTotal);
	CStatusBar* pStatusBar = NULL;
	pStatusBar = (CStatusBar*)gpApp->GetMainFrame()->m_pStatusBar;
	// whm 28Aug11 Note: pProgDlg can be NULL when DoFileSave_Protected() and
	// DoFileSave() are called from DoAutoSaveDoc() which does not set up a
	// wxProgressDialog(). Therefore we must test for NULL here.
	if (!progressItem.IsEmpty() && bShowWaitDlg) // whm 10Aug12 added && bShowWaitDlg test
	{
		pStatusBar->UpdateProgress(progressItem, 1, msgDisplayed);
	}
	// whm 24Aug11 moved the progress dialog to the top level OnFileSave() function. This
	// function (DoFileSave) receives a wxProgressDialog* pProgDlg pointer passed along
	// from OnFileSave(). When passed from DoAutoSaveDoc() pProgDlg is NULL.

	// process through the list of CSourcePhrase instances, building an xml element from
	// each
	SPList::Node* pos_pSP = gpApp->m_pSourcePhrases->GetFirst();

	// Branch and loop according to which doc version number is wanted. For a File / Save
	// it is VERSION_NUMBER's docVersion, also that is true for a Save As... in which the
	// top item (the default) was chosen as the filterIndex value of 0; but for a
	// filterIndex value of 1, the choice was for a legacy save (only DOCVERSION4 is
	// supported so far), and in this latter case, and only in this latter case, does
	// m_bLegacyDocVersionForSaveAs have a value of TRUE
	if (m_bLegacyDocVersionForSaveAs)
	{
		// user chose a legacy xml doc build, and so far there is only one such
		// choice, which is docVersion == 4
		wxString endMarkersStr; endMarkersStr.Empty();
		wxString inlineNonbindingEndMkrs; inlineNonbindingEndMkrs.Empty();
		wxString inlineBindingEndMkrs; inlineBindingEndMkrs.Empty();
		while (pos_pSP != NULL)
		{
			if (bShowWaitDlg)
			{
				counter++;
				if (counter % 1000 == 0)
				{
					msgDisplayed = progMsg.Format(progMsg, fn.GetFullName().c_str(), counter, nTotal);
					// whm 28Aug11 Note: pProgDlg can be NULL when DoFileSave_Protected() and
					// DoFileSave() are called from DoAutoSaveDoc() which does not set up a
					// wxProgressDialog(). Therefore we must test for NULL here.
					if (bShowWaitDlg)
					{
						pStatusBar->UpdateProgress(progressItem, counter, msgDisplayed);
					}
				}
			}
			pSrcPhrase = (CSourcePhrase*)pos_pSP->GetData();
			// get a deep copy, so that we can change the data to what is compatible with
			// doc version 4 without corrupting the pSrcPhrase which remains in doc
			// version 5
			CSourcePhrase* pDeepCopy = new CSourcePhrase(*pSrcPhrase);
			pDeepCopy->DeepCopy();

			// do the conversion from docVersion 5 to docVersion 4 (if endMarkersStr is
			// passed in non-empty, the endmarkers are inserted internally at the start of
			// pDeepCopy's m_markers member (and if pDeepCopy is a merger, they are also
			// inserted in the first instance of pDeepCopy->m_pSavedWords's m_markers
			// member too); and before returning it must check for endmarkers stored on
			// pDeepCopy (whether a merger or not makes no difference in this case) and
			// reset endMarkersStr to whatever endmarker(s) are found there - so that the
			// next iteration of the caller's loop can place them on the next pDeepCopy
			// passed in. (FromDocVersion5ToDocVersion4() leverages the fact that the
			// legacy code for docVersion 4 xml construction knows nothing about the new
			// members m_endMarkers, m_freeTrans, etc - so as long as pDeepCopy's
			// m_markers member is reset correctly, and m_endMarkers's content is returned
			// to the caller for placement on the next iteration, the legacy xml code will
			// build correct docVersion 4 xml from the docVersion 5 CSourcePhrase instances)
			FromDocVersion5ToDocVersion4(pDeepCopy, &endMarkersStr, &inlineNonbindingEndMkrs,
				&inlineBindingEndMkrs);

			pos_pSP = pos_pSP->GetNext();
			aStr = pDeepCopy->MakeXML(1); // 1 = indent the element lines with a single tab
			DeleteSingleSrcPhrase(pDeepCopy, FALSE); // FALSE means "don't try delete a partner pile"
			DoWrite(f, aStr);
		}
	}
	else // use chose a normal docVersion 5 (or later) xml build
	{
		// this is identical to what the File / Save choice does, for building the
		// doc's XML, for VERSION_NUMBER (currently 5 or later) for docVersion
#if defined (_DEBUG) && !defined(NOLOGS)
		int howmany;
		howmany = 9; // interested only in first nine items
		int countHowmany;
		countHowmany = 0;
#endif
		while (pos_pSP != NULL)
		{
			if (bShowWaitDlg)
			{
				counter++;
				if (counter % 100 == 0)
				{
					msgDisplayed = progMsg.Format(progMsg, fn.GetFullName().c_str(), counter, nTotal);
					// whm 28Aug11 Note: pProgDlg can be NULL when DoFileSave_Protected() and
					// DoFileSave() are called from DoAutoSaveDoc() which does not set up a
					// wxProgressDialog(). Therefore we must test for NULL here.
					if (bShowWaitDlg)
					{
						pStatusBar->UpdateProgress(progressItem, counter, msgDisplayed);
					}
				}
			}
			pSrcPhrase = (CSourcePhrase*)pos_pSP->GetData();
#if defined (_DEBUG) && !defined(NOLOGS)
			countHowmany++;
			if (countHowmany < howmany)
			{
				wxLogDebug(_T("DoFileSave() line %d: sequNum= %d , m_srcPhrase= %s , m_markers= %s"),
					__LINE__, pSrcPhrase->m_nSequNumber, pSrcPhrase->m_srcPhrase.c_str(), pSrcPhrase->m_markers.c_str());
			}
#endif
			pos_pSP = pos_pSP->GetNext();
			aStr = pSrcPhrase->MakeXML(1); // 1 = indent the element lines with a single tab
			DoWrite(f, aStr);
		}
	}

	// doc closing tag
	aStr = xml_adaptitdoc;
	aStr = openBraceSlash + aStr; //"</" + aStr;
	aStr += ">\r\n"; // eol chars OK for cross-platform???
	DoWrite(f, aStr);

	// close the file
	f.Flush();
	f.Close();

	// remove the dummy that was appended, if we did append one in the code above
	if (type == save_as && m_bLegacyDocVersionForSaveAs)
	{
		if (bDummySrcPhraseAdded)
		{
			posLast = gpApp->m_pSourcePhrases->GetLast();
			CSourcePhrase* pDummyWhichIsLast = posLast->GetData();
			wxASSERT(pDummyWhichIsLast != NULL);
			gpApp->GetDocument()->DeleteSingleSrcPhrase(pDummyWhichIsLast);
		}
	}

	// recompute m_curOutputPath, so it can be saved to config files as m_lastDocPath,
	// because the path computed at the end of OnOpenDocument() will have been invalidated
	// if the filename extension was changed by code earlier in DoFileSave()
	if (gpApp->m_bBookMode && !gpApp->m_bDisableBookMode)
	{
		gpApp->m_curOutputPath = pApp->m_bibleBooksFolderPath +
			gpApp->PathSeparator + gpApp->m_curOutputFilename;
	}
	else
	{
		gpApp->m_curOutputPath = pApp->m_curAdaptationsPath +
			gpApp->PathSeparator + gpApp->m_curOutputFilename;
	}
	gpApp->m_lastDocPath = gpApp->m_curOutputPath; // make it agree with what path was
												   // used for this save operation

	// Do the document backup if required (This call supports a docVersion 4 choice, and
	// also a request to rename the document; by internally accessing the private members
	// bool	m_bLegacyDocVersionForSaveAs, and bool m_bDocRenameRequestedForSaveAs either
	// or both of which may have been changed from their default values of FALSE depending
	// on the execution path through the code above
	if (gpApp->m_bBackupDocument)
	{
		bool bBackedUpOK;
		if (bFileIsRenamed)
		{
			bBackedUpOK = BackupDocument(gpApp, pRenamedFilename);
		}
		else
		{
			bBackedUpOK = BackupDocument(gpApp); // 2nd param is default NULL (no rename wanted)
		}
		if (!bBackedUpOK)
		{
			wxMessageBox(_(
				"Warning: the attempt to backup the current document failed."),
				_T(""), wxICON_EXCLAMATION | wxOK);
			gpApp->LogUserAction(_T("Warning: the attempt to backup the current document failed."));
		}
	}

	// Restore the latest document version number, in case the save done above was actually
	// a Save As... using an earlier doc version number. Must not restore earlier than
	// this, as a call of BackupDocument() will need to know what the user's chosen state
	// value currently is for docVersion.
	RestoreCurrentDocVersion();

	Modify(FALSE); // declare the document clean
	if (gpApp->m_bBookMode && !gpApp->m_bDisableBookMode)
		SetFilename(pApp->m_bibleBooksFolderPath + pApp->PathSeparator +
			pApp->m_curOutputFilename, TRUE); // TRUE = notify all views
	else
		SetFilename(pApp->m_curAdaptationsPath + pApp->PathSeparator +
			pApp->m_curOutputFilename, TRUE); // TRUE = notify all views

	// the KBs (whether glossing KB or normal KB) must always be kept up to date with a
	// file, so must store both KBs, since the user could have altered both since the last
	// save
	gpApp->StoreGlossingKB(bShowWaitDlg, FALSE); // FALSE = don't want backup produced
	gpApp->StoreKB(bShowWaitDlg, FALSE);

	// remove the phrase box's entry again (this code is sensitive to whether glossing is on
	// or not, because it is an adjustment pertaining to the phrasebox contents only, to undo
	// what was done above - namely, the entry put into either the glossing KB or the normal KB)
	if (pApp->m_pTargetBox != NULL)
	{
		if (pApp->m_pTargetBox->IsShown() &&
			pView->GetFrame()->FindFocus() == (wxWindow*)pApp->m_pTargetBox->GetTextCtrl() && !bNoStore) // whm 12Jul2018 added GetTextCtrl()-> part
		{
			wxString emptyStr = _T("");
			if (gbIsGlossing)
			{
				if (!bNoStore)
				{
					pApp->m_pGlossingKB->GetAndRemoveRefString(pApp->m_pActivePile->GetSrcPhrase(),
						emptyStr, useGlossOrAdaptationForLookup);
				}
				pApp->m_pActivePile->GetSrcPhrase()->m_bHasGlossingKBEntry = FALSE;
			}
			else
			{
				if (!bNoStore)
				{
					pApp->m_pKB->GetAndRemoveRefString(pApp->m_pActivePile->GetSrcPhrase(),
						emptyStr, useGlossOrAdaptationForLookup);
				}
				pApp->m_pActivePile->GetSrcPhrase()->m_bHasKBEntry = FALSE;
			}
		}
	}
	// whm 24Aug11 Note: We don't destroy pProgDlg here because it is
	// created in the caller and will be destroyed there.
	if (m_bLegacyDocVersionForSaveAs)
	{
		wxString msg;
		wxString appVerStr;
		appVerStr = pApp->GetAppVersionOfRunningAppAsString();
		msg = msg.Format(_("This document (%s) is now saved on disk in the older (version 3, 4, 5) xml format.\nHowever, if you now make any additional changes to this document or cause it to be saved using this version (%s) of Adapt It, the format of the disk file will be upgraded again to the newer format.\nIf you do not want this to happen, you should immediately close the document, or exit from this version of Adapt It."), gpApp->m_curOutputFilename.c_str(), appVerStr.c_str());
		// whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
		gpApp->m_bUserDlgOrMessageRequested = TRUE;
		wxMessageBox(msg, _T(""), wxICON_INFORMATION | wxOK);
		gpApp->LogUserAction(_T("Save As done as version 3,4,5 xml format."));
	}
	m_bLegacyDocVersionForSaveAs = FALSE; // restore default
	// whm 20Aug11 note: since a file save operation is very frequent, we avoid inflating the user log
	// with successful saves.
	return TRUE;
}

// Return TRUE if the save was successful, FALSE if some error
// absPath is an absolute path to the file to be saved - it can be in either
// the Adaptations folder, or to any of the Bible Book folders, and it ignores
// whether the app is in Bible Book folder mode or not. It just does the save,
// overwriting the former file contents. Use this when we do 'all document'
// tweaks that involve loading in each doc file, tweaking its contents in
// m_pSourcePhrases, and then saving over the top of the old file on disk.
// This function has no GUI information in it.
bool CAdapt_ItDoc::DoAbsolutePathFileSave(wxString absPath)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	if (!absPath.IsEmpty())
	{
		wxFile f; // create a CFile instance with default constructor

		wxFileName fn(absPath);
		wxString pathToFolder = fn.GetPath();
		wxASSERT(!pathToFolder.IsEmpty());
		// Set the current working directory
		wxString saveCurWorkingDir = _T("");
		saveCurWorkingDir = fn.GetCwd(); // so we can restore it later
		// Get the filename, since we are working with a relative path now
		wxString fullName = fn.GetFullName();
		wxASSERT(!fullName.IsEmpty());
		bool bOK = fn.SetCwd(pathToFolder);
		if (bOK)
		{
			if (!f.Open(fullName, wxFile::write))
			{
				pApp->LogUserAction(_T("Failed f.Open() for writing in doc::DoAbsolutePathFileSave(wxString absPath)"));
				return FALSE;
			}
			// The following code is taken from doc::DoSaveFile(), and many comments removed to
			// keep it short. If anything is unclear then look there for the details
			CSourcePhrase* pSrcPhrase;
			CBString aStr;
			CBString openBraceSlash = "</"; // to avoid "warning: deprecated conversion from string constant to 'char*'"

			// prologue (Changed BEW 02July07 at Bob Eaton's request)
			gpApp->GetEncodingStringForXmlFiles(aStr);
			DoWrite(f, aStr);

			// add the comment with the warning about not opening the XML file in MS WORD
			// 'coz is corrupts it - presumably because there is no XSLT file defined for it
			// as well. When the file is then (if saved in WORD) loaded back into Adapt It,
			// the latter goes into an infinite loop when the file is being parsed in.
			aStr = MakeMSWORDWarning(); // the warning ends with \r\n so we don't need to add them here

			// doc opening tag
			aStr += "<";
			aStr += xml_adaptitdoc;
			aStr += ">\r\n"; // eol chars OK for cross-platform???
			DoWrite(f, aStr);
			// Construct the initial <Settings> tag
			aStr = ConstructSettingsInfoAsXML(1); // internally sets the docVersion attribute
			// to whatever is the current value of m_docVersionCurrent
			DoWrite(f, aStr);
			// Process the list of CSourcePhrase instances
			SPList::Node* pos_pSP = gpApp->m_pSourcePhrases->GetFirst();
			while (pos_pSP != NULL)
			{
				pSrcPhrase = (CSourcePhrase*)pos_pSP->GetData();
				pos_pSP = pos_pSP->GetNext();
				aStr = pSrcPhrase->MakeXML(1); // 1 = indent the element lines with a single tab
				DoWrite(f, aStr);
			}
			// doc closing tag
			aStr = xml_adaptitdoc;
			aStr = openBraceSlash + aStr; //"</" + aStr;
			aStr += ">\r\n"; // eol chars OK for cross-platform???
			DoWrite(f, aStr);

			// close the file
			f.Flush();
			f.Close();
			// Restore original current working directory
			bOK = fn.SetCwd(saveCurWorkingDir);
			wxASSERT(bOK);
			return TRUE;
		}
	}
	else
	{
		pApp->LogUserAction(_T("Passed in empty path in signature. In doc::DoAbsolutePathFileSave(wxString absPath)"));
	}
	// Path was empty, or could not reset the current working volume to the
	// document's folder, or the attempt to do f.Open() for writing failed; so
	// could not save the file - the old version of it will remain on disk
	return FALSE;
}

///////////////////////////////////////////////////////////////////////////////
/// \return nothing
/// \param	event	-> wxCommandEvent (unused)
/// \remarks
/// Called from: the doc/view framework when wxID_SAVEAS event is generated. Also called from
/// CMainFrame's SyncScrollReceive() when it is necessary to save the current document before
/// opening another document when sync scrolling is on.
/// OnFileSaveAs simply calls DoFileSave() and the latter sets an enum value of save_as
///
/// BEW changed 28Apr10 A failure might be due to the Open call failing, in which case the
/// document's file is unchanged, or to the user clicking the Cancel buton in the Save As
/// dialog, in which case the document's file will have been truncated to zero length by
/// the f.Open call done before the Save As dialog was opened. So we need code added in
/// order to recover the document, if either was the case; also we have to handle the
/// possibility that the document may not yet have ever been saved, which changes what we
/// need to do in the event of failure.
/// BEW 16Apr10, added enum, for support of Save As... menu item as well as Save
/// BEW 20Aug10, changed so that the temporary file with derived name
/// "tempSave_<filename>.xml" is saved in the project folder, and restored from there if
/// needed. Doing this means that the GUI never reveals it to the user, which is how it
/// should behave.
/// BEW 1Jul13, refactored so as to work happily in a DVCS context. The earlier versio of
/// this function aimed to keep just one copy of the data (to avoid user confusion), so it
/// did the rename by renaming the current document only, and in the evente of failurer or
/// Cancel, it restored the document (and filename) to it's original state. This old
/// protocol is dangerous in a DVCS environment, we don't want to give the user the
/// capability of renaming a currently open document, which could be under version
/// control, to something else - that would require us to complicate DVCS to accomodate
/// such a possibility. It's likely the user wants a copy for some reason, such as for
/// training purposes or similar, and so a renamed copy which can be removed from the
/// project without damaging anything is a better idea. So the refactored version renames
/// a COPY of the current document, and does not switch the open document to be this
/// renamed copy. Therefore, the name of the open document, after a successful SaveAs...,
/// is the same and all that's happened is a second, renamed, copy now resides on disk .
///////////////////////////////////////////////////////////////////////////////
void CAdapt_ItDoc::OnFileSaveAs(wxCommandEvent& WXUNUSED(event))
{
	SaveType saveType = save_as;
	wxString renamedFilename; renamedFilename.Empty();
	wxString* pRenamedFilename = &renamedFilename;

	wxString pathToSaveFolder;
	wxULongLong originalSize = 0;
	wxULongLong copiedSize = 0;
	bool bRemovedSuccessfully = TRUE;
	ValidateFilenameAndPath(gpApp->m_curOutputFilename, gpApp->m_curOutputPath, pathToSaveFolder);
	m_bDocRenameRequestedForSaveAs = FALSE; // restore default (ValidateFilenameAndPath()
											// may have set it to TRUE)
	bool bOutputFileExists = ::wxFileExists(gpApp->m_curOutputPath); // original doc file

	// In the following call, if pRenamedFilename returns an empty string, then no rename has been
	// requested; first param, value being TRUE, means "show wait/progress dialog"
	bool bUserCancelled = FALSE; // it's initialized to FALSE inside the DoFileSave() call to
	if (bOutputFileExists)
	{
		gpApp->LogUserAction(_T("Initiated Save As..."));
	}
	else
	{
		gpApp->LogUserAction(_T("Initiated Save As... but no doc file exists, so returning"));
		return;
	}
	// Now make a copy with a different name, which we can later rename; put it in the
	// project folder - otherwise when the DoSaveFile() dialog opens, it would be listed
	// with all the document names (which we don't want to happen, it would confuse the
	// user), so later when we've renamed it, we'll move it to the pathToSaveFolder
	wxString prefixStr = _T("tempSave_"); // don't localize this, it's never seen
	wxString newNameStr = prefixStr + gpApp->m_curOutputFilename;
	wxString tempFileAbsPath = gpApp->m_curProjectPath + gpApp->PathSeparator + newNameStr;
	bool bCopiedSuccessfully = TRUE;
	if (bOutputFileExists)
	{
		bCopiedSuccessfully = ::wxCopyFile(gpApp->m_curOutputPath, tempFileAbsPath);
		wxASSERT(bCopiedSuccessfully);
		wxFileName fn(gpApp->m_curOutputPath);
		originalSize = fn.GetSize();
		if (bCopiedSuccessfully)
		{
			wxFileName fnNew(tempFileAbsPath);
			copiedSize = fnNew.GetSize();
			wxASSERT(copiedSize == originalSize);
		}
	}

	// whm 26Aug11 Open a wxProgressDialog instance here for transform to glosses operations.
	// The dialog's pProgDlg pointer is passed along through various functions that
	// get called in the process.
	// whm WARNING: The maximum range of the wxProgressDialog (nTotal below) cannot
	// be changed after the dialog is created. So any routine that gets passed the
	// pProgDlg pointer, must make sure that value in its Update() function does not
	// exceed the same maximum value (nTotal).
	// BEW 1Jul13, the above warning of Bill's no longer applies, because the renamed file will
	// not be the current document, but will be a copy thereof, and the current document will
	// stay 'as is' and so it's nTotal value will not change, and the view will not switch to
	// displaying the renamed document on return, but retain the current one unchanged.
	wxString msgDisplayed;
	const int nTotal = gpApp->GetMaxRangeForProgressDialog(App_SourcePhrases_Count) + 1;
	wxString progMsg = _("Saving File %s  - %d of %d Total words and phrases");
	wxFileName fn(gpApp->m_curOutputFilename);
	msgDisplayed = progMsg.Format(progMsg, fn.GetFullName().c_str(), 1, nTotal);
	wxString newAbsPath; newAbsPath.Empty(); // renamed file (including its path) will be put here

	bool bSuccess = DoFileSave(TRUE, saveType, pRenamedFilename, bUserCancelled, _T(""));
	if (bSuccess)
	{
		// BEW 1Jul13, we do the rename on a copy, and only provided the save was
		// successful (there won't be a filename clash because that was checked for and
		// prevented within DoFileSave())
		if (!pRenamedFilename->IsEmpty())
		{
			// a rename is wanted, make the renamed copy from the temp copy created above
			// by moving and renaming (::wxRenameFile() does both at the one time)
			// FALSE is bool overwrite, which defaults to TRUE, but we want FALSE here
			newAbsPath = pathToSaveFolder + gpApp->PathSeparator + renamedFilename;
			bool bSuccess = ::wxRenameFile(tempFileAbsPath, newAbsPath, FALSE);
			if (bSuccess)
			{
				// The renamed file copy was created, nothing to do but make sure no temp
				// copy remains, then then return
				bool bSomethingOfThatNameExists = ::wxFileExists(tempFileAbsPath);
				if (bSomethingOfThatNameExists)
				{
					bRemovedSuccessfully = wxRemoveFile(tempFileAbsPath);
					wxASSERT(bRemovedSuccessfully);
				}
				return;
			}
			else
			{
				// the rename failed, tell the user and exit; remove any fragment if present
				wxString msg;
				if (renamedFilename.IsEmpty())
				{
					msg = _("Warning: the SaveAs... attempt failed for some reason, the file was not created.");
					wxMessageBox(msg, _("SaveAs... failed"), wxICON_EXCLAMATION | wxOK);
					gpApp->LogUserAction(_T("Warning: SaveAs failed at ::wxRenameFile() call, empty filename."));
				}
				else
				{
					msg = _("Warning: the SaveAs... attempt failed for some reason, the file: %s was not created.");
					msg = msg.Format(renamedFilename.c_str());
					wxMessageBox(msg, _("SaveAs... failed"), wxICON_EXCLAMATION | wxOK);
					gpApp->LogUserAction(_T("Warning: SaveAs failed at ::wxRenameFile() call."));
				}
				bool bSomethingOfThatNameExists = ::wxFileExists(newAbsPath);
				if (bSomethingOfThatNameExists)
				{
					bRemovedSuccessfully = wxRemoveFile(newAbsPath);
					wxASSERT(bRemovedSuccessfully);
					bRemovedSuccessfully = bRemovedSuccessfully;  // prevent compiler warning, one of these is enough
				}
				// and also the temp copy
				bSomethingOfThatNameExists = ::wxFileExists(tempFileAbsPath);
				if (bSomethingOfThatNameExists)
				{
					bRemovedSuccessfully = wxRemoveFile(tempFileAbsPath);
					wxASSERT(bRemovedSuccessfully);
				}
				return;
			}
		}
		else
		{
			// an empty filename'd file should not have been created, so just remove the
			// temporary copy & return; similarly for one with same name
			bool bSomethingOfThatNameExists = ::wxFileExists(tempFileAbsPath);
			if (bSomethingOfThatNameExists)
			{
				bRemovedSuccessfully = wxRemoveFile(tempFileAbsPath);
				wxASSERT(bRemovedSuccessfully);
				wxString msg = _("Warning: a SaveAs... file with the same name is illegal, so nothing was done.");
				wxMessageBox(msg, _("SaveAs... failed"), wxICON_EXCLAMATION | wxOK);
				gpApp->LogUserAction(msg);
			}
			return;
		}
	}
	else // handle failure at the DoSaveFile dialog, or a user Cancel button click
	{
		if (bUserCancelled)
		{
			// nothing to do except make sure any temporary fragment is gone, & then return
			bool bSomethingOfThatNameExists = ::wxFileExists(tempFileAbsPath);
			if (bSomethingOfThatNameExists)
			{
				bRemovedSuccessfully = wxRemoveFile(tempFileAbsPath);
				wxASSERT(bRemovedSuccessfully);
			}
			return;
		}
		else
		{
			// something went wrong, tell the user and remove any fragmet, then return
			wxString msg;
			if (renamedFilename.IsEmpty())
			{
				msg = _("Warning: the SaveAs... attempt failed for some reason, the file was not created.");
				wxMessageBox(msg, _("SaveAs... failed"), wxICON_EXCLAMATION | wxOK);
				gpApp->LogUserAction(_T("Warning: SaveAs failed at ::wxRenameFile() call, empty filename."));
			}
			else
			{
				msg = _("Warning: the SaveAs... attempt failed for some reason, the file: %s was not created.");
				msg = msg.Format(renamedFilename.c_str());
				wxMessageBox(msg, _("SaveAs... failed"), wxICON_EXCLAMATION | wxOK);
				gpApp->LogUserAction(_T("Warning: SaveAs failed at ::wxRenameFile() call."));
			}
			bool bSomethingOfThatNameExists = ::wxFileExists(newAbsPath);
			if (bSomethingOfThatNameExists)
			{
				bRemovedSuccessfully = wxRemoveFile(newAbsPath);
				wxASSERT(bRemovedSuccessfully);
			}
			// and also the temp copy
			bSomethingOfThatNameExists = ::wxFileExists(tempFileAbsPath);
			if (bSomethingOfThatNameExists)
			{
				bRemovedSuccessfully = wxRemoveFile(tempFileAbsPath);
				wxASSERT(bRemovedSuccessfully);
			}
			return;
		}

	} // end else block for test: if (bSuccess)

}

///////////////////////////////////////////////////////////////////////////////
/// \return nothing
/// \param  curFilename       -> the current output filename (app's m_curOutputFilename member)
/// \param  curPath           <- the full path to current doc folder for saves, including the
///                               filename (app's m_curOutputPath)
/// \param  pathForSaveFolder <-  absolute path to the folder in which the doc will be saved
///                               (returned as a potential convenience to the caller,
///                               which may want to use this for some special purpose)
/// \remarks
/// Called from: OnFileSave(), OnFileSaveAs(), DoFileSave()
/// Takes the current save folder and the current doc filename, and rebuilds the output
/// full absolute path to the document, and ensuring the document filename has .xml
/// extension (version 4.0.0 and higher of Adapt It no longer save *.adt binary files)
/// BEW created 28Apr10, because this encapsulation of checks is need in more than one
/// place. Strictly speaking, the function is unneeded because now that we only save in
/// xml, nothing should ever change the extention to anything else - nevertheless, we'll
/// retain it
///////////////////////////////////////////////////////////////////////////////
void CAdapt_ItDoc::ValidateFilenameAndPath(wxString& curFilename, wxString& curPath,
	wxString& pathForSaveFolder)
{
	// m_curOutputFilename was set when user created the doc; or it an existing doc was
	// read back in; the extension will be .xml
	wxString thisFilename = curFilename;

	// we want an .xml extension - make it so if it happens to be .adt
	thisFilename = MakeReverse(thisFilename);
	wxString extn = thisFilename.Left(4);
	extn = MakeReverse(extn);
	if (extn != _T(".xml"))
	{
		thisFilename = thisFilename.Mid(4); // remove any extension
		thisFilename = MakeReverse(thisFilename);
		thisFilename += _T(".xml"); // it's now guaranteed to be *.xml
	}
	else
	{
		thisFilename = MakeReverse(thisFilename); // it's already *.xml
	}
	curFilename = thisFilename;

	// make sure the backup filename complies too (BEW added 23June07)
	MakeOutputBackupFilenames(curFilename);

	// the m_curOutputPath member can be redone now that m_curOutputFilename is what is wanted
	if (gpApp->m_bBookMode && !gpApp->m_bDisableBookMode)
	{
		pathForSaveFolder = gpApp->m_bibleBooksFolderPath;
	}
	else
	{
		pathForSaveFolder = gpApp->m_curAdaptationsPath;
	}

	curPath = pathForSaveFolder + gpApp->PathSeparator + curFilename;
}

///////////////////////////////////////////////////////////////////////////////
/// \return nothing
/// \param      event   -> the wxUpdateUIEvent that is generated when the File Menu is about
///                         to be displayed
/// \remarks
/// Called from: The wxUpdateUIEvent mechanism when the associated menu item is selected,
/// and before the menu is displayed.
/// Enables or disables menu and/or toolbar items associated with the wxID_SAVE identifier.
/// If Vertical Editing is in progress the File Save menu item is always disabled, and this
/// handler returns immediately. Otherwise, the item is enabled if the KB exists, and if
/// m_pSourcePhrases has at least one item in its list, and IsModified() returns TRUE;
/// otherwise the item is disabled.
/// BEW modified 13Nov09, if the local user has only read-only access to a remote
/// project folder, do not let him save his local copy of the remote document to the
/// remote machine, otherwise the remote user is almost certainly to lose some edits
///////////////////////////////////////////////////////////////////////////////
void CAdapt_ItDoc::OnUpdateFileSave(wxUpdateUIEvent& event)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	if (pApp->m_bClipboardAdaptMode)
	{
		event.Enable(FALSE);
		return;
	}

	if (pApp->m_bReadOnlyAccess)
	{
		event.Enable(FALSE);
		return;
	}

	if (gbVerticalEditInProgress)
	{
		event.Enable(FALSE);
		return;
	}
	// whm 25May11 Note: When collaborating with Paratext/Bibledit the Save... command is
	// available under the same conditions as when not collaborating with Paratext/Bibledit,
	// i.e., a Doc is open and it is dirty/modified.
	// whm 6Nov12 revised to use the more self-documenting
	// IsDocumentOpen() function.
	if (pApp->m_pKB != NULL && pApp->IsDocumentOpen() && IsModified())
		event.Enable(TRUE);
	else
		event.Enable(FALSE);
}

///////////////////////////////////////////////////////////////////////////////
/// \return nothing
/// \param      event   -> the wxUpdateUIEvent that is generated when the File Menu is
///                        about to be displayed
/// \remarks
/// Called from: The wxUpdateUIEvent mechanism when the associated menu item is selected,
/// and before the menu is displayed.
/// Enables or disables menu and/or toolbar items associated with the wxID_SAVEAS
/// identifier. If Vertical Editing is in progress the File Save As... menu item is always
/// disabled, and this handler returns immediately. Otherwise, the item is enabled if the
/// KB exists, and if m_pSourcePhrases has at least one item in its list, and IsModified()
/// returns TRUE; otherwise the item is disabled.
/// BEW modified 13Nov09, if the local user has only read-only access to a remote
/// project folder, do not let him save his local copy of the remote document to the
/// remote machine, otherwise the remote user is almost certainly to lose some edits
/// BEW 9Aug11, disabled when in collaboration mode with Paratext or Bibledit
///////////////////////////////////////////////////////////////////////////////
void CAdapt_ItDoc::OnUpdateFileSaveAs(wxUpdateUIEvent& event)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	if (pApp->m_bClipboardAdaptMode)
	{
		event.Enable(FALSE);
		return;
	}
	if (pApp->m_bReadOnlyAccess)
	{
		event.Enable(FALSE);
		return;
	}
	if (gbVerticalEditInProgress)
	{
		event.Enable(FALSE);
		return;
	}
	// BEW 9Aug11 disable SaveAs... when collaborating with an external editor (at such a
	// time we don't want to support doc conversion to kbVersion 1, nor a doc name change)
	if (pApp->m_bCollaboratingWithParatext || pApp->m_bCollaboratingWithBibledit)
	{
		event.Enable(FALSE);
		return;
	}
	// whm 14Jan11 removed the && IsModified() test below. Save As should be available
	// whether the document is "dirty" or not.
	//if (pApp->m_pKB != NULL && pApp->m_pSourcePhrases->GetCount() > 0 && IsModified())
	if (pApp->m_pKB != NULL && pApp->m_pSourcePhrases->GetCount() > 0)
		event.Enable(TRUE);
	else
		event.Enable(FALSE);
}

void CAdapt_ItDoc::OnUpdateSaveAndCommit(wxUpdateUIEvent& event)
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	if (pApp->m_bClipboardAdaptMode)
	{
		event.Enable(FALSE);
		return;
	}
	if (pApp->m_bReadOnlyAccess)
	{
		event.Enable(FALSE);
		return;
	}
	if (gbVerticalEditInProgress)
	{
		event.Enable(FALSE);
		return;
	}
	if (pApp->m_pKB != NULL && pApp->m_pSourcePhrases->GetCount() > 0)
		event.Enable(TRUE);
	else
		event.Enable(FALSE);
}

///////////////////////////////////////////////////////////////////////////////
/// \return TRUE if the document is successfully opened, otherwise FALSE.
/// \param	lpszPathName	-> the name and path of the document to be opened
/// \remarks
/// Called from: the App's DoTransformationsToGlosses( ) function.
/// Opens a document in another project in preparation for transforming its adaptations into
/// glosses in the current project. The other project's documents get copied in the process, but
/// are left unchanged in the other project. Since we are not going to look at the contents of
/// the document, we don't do anything except get it into memory ready for transforming.
/// BEW changed 31Aug05 so it would handle either .xml or .adt documents automatically (code pinched
/// from start of OnOpenDocument())
///////////////////////////////////////////////////////////////////////////////

bool CAdapt_ItDoc::OpenDocumentInAnotherProject(wxString lpszPathName)
{
	CAdapt_ItApp* pApp = GetApp();

	// BEW added 31Aug05 for XML doc support (we have to find out what extension it has
	// and then choose the corresponding code for loading that type of doc
	wxString thePath = lpszPathName;
	wxString extension = thePath.Right(4);
	extension.MakeLower();
	wxASSERT(extension[0] == _T('.')); // check it really is an extension

	wxFileName fn(thePath);
	wxString fullFileName;
	fullFileName = fn.GetFullName();

	// whm 26Aug11 Open a wxProgressDialog instance here for opening doc operations.
	// The dialog's pProgDlg pointer is passed along through various functions that
	// get called in the process.
	// whm WARNING: The maximum range of the wxProgressDialog (nTotal below) cannot
	// be changed after the dialog is created. So any routine that gets passed the
	// pProgDlg pointer, must make sure that value in its Update() function does not
	// exceed the same maximum value (nTotal).
	wxString msgDisplayed;
	wxString progMsg;
	CStatusBar* pStatusBar = NULL;
	// add 1 chunk to insure that we have enough after int division above
	const int nTotal = gpApp->GetMaxRangeForProgressDialog(XML_Input_Chunks) + 1;
	// Only show the progress dialog when there is at lease one chunk of data
	// Only create the progress dialog if we have data to progress
	if (nTotal > 0)
	{
		progMsg = _("Reading file %s - part %d of %d");
		//wxFileName fn(fullFileName); done above
		msgDisplayed = progMsg.Format(progMsg, fn.GetFullName().c_str(), 1, nTotal);
		pStatusBar = (CStatusBar*)gpApp->GetMainFrame()->m_pStatusBar;
		pStatusBar->StartProgress(_("Opening Document In Another Project"), msgDisplayed, nTotal);
	}

	if (extension == _T(".xml"))
	{
		// we have to input an xml document
		bool bReadOK = ReadDoc_XML(thePath, this, _("Opening Document In Another Project"), nTotal);

		if (!bReadOK)
		{
			// Let's see if we can recover the doc:
			if (pApp->m_commitCount > 0)
			{
				wxCommandEvent  dummyEvent;
				wxString        savedOutputFilename = pApp->m_curOutputFilename;
				wxString        savedAdaptationsPath = pApp->m_curAdaptationsPath;

				OnFileClose(dummyEvent);                            // the file's corrupt, so we close it to avoid crashes
				pApp->m_reopen_recovered_doc = FALSE;               // so the recovery code doesn't try to re-open the doc
				pApp->m_curOutputFilename = thePath;                // have to make these source values current for the recovery
				pApp->m_curAdaptationsPath = pApp->m_sourcePath;
				bReadOK = RecoverLatestVersion();
				pApp->m_curOutputFilename = savedOutputFilename;    // restore target values
				pApp->m_curAdaptationsPath = savedAdaptationsPath;

				if (bReadOK)                                        // if we recovered the doc, we retry the original read
					bReadOK = ReadDoc_XML(thePath, this, _("Opening Document In Another Project"), nTotal);

				if (bReadOK)
				{
					wxString msg;
					msg.Format(_T("The document %s was corrupt, but we have restored the latest version saved in the document history."), thePath.c_str());
					// whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
					gpApp->m_bUserDlgOrMessageRequested = TRUE;
					wxMessageBox(msg);
				}
			}

			if (!bReadOK)
			{
				wxString s;
				s = _(
					"There was an error parsing in the XML file.\nIf you edited the XML file earlier, you may have introduced an error.\nEdit it in a word processor then try again.");
				wxMessageBox(s, fullFileName, wxICON_INFORMATION | wxOK);
				if (nTotal > 0)
					pStatusBar->FinishProgress(_("Opening Document In Another Project"));
				return FALSE; // return FALSE to tell caller we failed
			}
		}
	}
	else
	{
		wxMessageBox(_(
			"Sorry, the wxWidgets version of Adapt It does not read legacy .adt document format; it only reads the .xml format.")
			, fullFileName, wxICON_EXCLAMATION | wxOK);
		if (nTotal > 0)
			pStatusBar->FinishProgress(_("Opening Document In Another Project"));
		return FALSE;
	}
	if (nTotal > 0)
		pStatusBar->FinishProgress(_("Opening Document In Another Project"));

	// The doc in the other project may have been under version control, but in this project of course it isn't yet.  So we
	//  must initialize the appropriate variables.

	pApp->m_owner = pApp->m_strUserID;  // this is our doc
	pApp->m_commitCount = -1;			//  means not under version control (yet)
	pApp->m_versionDate = wxInvalidDateTime;
	pApp->m_nActiveSequNum = 0;         // sensible default if we don't get a "real" value

	return TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \return nothing
/// \param	event	-> wxCommandEvent (unused)
/// \remarks
/// Called automatically within the doc/view framework when an event associated with the
/// wxID_OPEN identifier (such as File | Open) is generated within the framework. It is
/// also called by the Doc's OnOpenDocument(), by the DocPage's OnWizardFinish() and by
/// SplitDialog's SplitIntoChapters_Interactive() function.
/// Rather than using the doc/view's default behavior for OnFileOpen() this function calls
/// our own DoFileOpen() function after setting the current work folder to the Adaptations
/// path, or the current book folder if book mode is on.
///////////////////////////////////////////////////////////////////////////////
void CAdapt_ItDoc::OnFileOpen(wxCommandEvent& WXUNUSED(event))
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);

	// BEW 21Aug15, Default the following flag to a TRUE value - just in case
	// collaboration mode may be in effect
	pApp->m_bConflictResolutionTurnedOn = TRUE;

	// ensure that the current work folder is the Adaptations one for default; unless book
	// mode is ON, in which case it must the the current book folder.
	wxString dirPath;
	if (pApp->m_bBookMode && !pApp->m_bDisableBookMode)
		dirPath = pApp->m_bibleBooksFolderPath;
	else
		dirPath = pApp->m_curAdaptationsPath;
	bool bOK;
	// whm 8Apr2021 added wxLogNull block below
	{
		wxLogNull logNo;	// eliminates any spurious messages from the system if the wxSetWorkingDirectory() call returns FALSE
		bOK = ::wxSetWorkingDirectory(dirPath); // ignore failures
	} // end of wxLogNull scope
	bOK = bOK; // avoid warning
	// NOTE: This OnFileOpen() handler calls DoFileOpen() in the App, which now simply
	// calls DoStartWorkingWizard().
	pApp->DoFileOpen();
	// BEW added 7Oct14
	pApp->m_bZWSPinDoc = pApp->IsZWSPinDoc(pApp->m_pSourcePhrases);
}

///////////////////////////////////////////////////////////////////////////////
/// \return nothing
/// \param	event	-> wxCommandEvent associated with the wxID_CLOSE identifier.
/// \remarks
/// This function is called automatically by the doc/view framework when an event
/// associated with the wxID_CLOSE identifier is generated. It is also called by: the App's
/// OnFileChangeFolder() and OnAdvancedBookMode(), by the View's OnFileCloseProject(), and
/// by DocPage's OnButtonChangeFolder() and OnWizardFinish() functions.
/// This override of OnFileClose does not close the app, it just clears out all the current view
/// structures, after calling our version of SaveModified. It simply closes files & leave the
/// app ready for other files to be opened etc. Our SaveModified() & this OnFileClose are
/// not OLE compliant. (A New... or Open... etc. will call DeleteContents on the doc structures
/// before a new doc can be made or opened). For version 2.0, which supports glossing, if one KB
/// gets saved, then the other should be too - this needs to be done in our SaveModified( ) function
/// NOTE: we don't change the values of the four flags associated with glossing, because this
/// function may be called for processes which serially open and close each document of a
/// project, and the flags will have to maintain their values across the calls to ClobberDocument;
/// and certainly ClobberDocumen( ) will be called each time even if this one isn't.
///////////////////////////////////////////////////////////////////////////////
void CAdapt_ItDoc::OnFileClose(wxCommandEvent& event)
{
	NormalizeState();

	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	if (gbVerticalEditInProgress)
	{
		// don't allow doc closure until the vertical edit is finished
		::wxBell();
		pApp->LogUserAction(_T("Disallow File Close - gbVerticalEditInProgress"));
		return;
	}

	// when collaborating on a doc is finished, restore the Copy Source flag value to what
	// it was before it was automatically turned off
	if (pApp->m_bSaveCopySourceFlag_For_Collaboration)
	{
		pApp->m_bCopySource = FALSE;
		pApp->GetView()->ToggleCopySource(); // toggles m_bCopySource's value & resets menu item
		pApp->m_bSaveCopySourceFlag_For_Collaboration = FALSE; // when closing doc, always clear

		// whm 2Aug2018 Note: The Select Copied Source menu item is enabled only when the
		// m_bCopySource value is TRUE. Its check status is determined by the value the
		// user stored in the project config file (i.e., it may be ticked, but will be
		// disabled whenever the Copy Source menu item is not ticked.
	}

	// whm 19Sep11 modified. The UnloadKBs() call below during collaboration should
	// not be done before the OnSaveModified() call a little farther below. Otherwise
	// the KB pointers become NULL and a crash can result in StoreText() farther down
	// the calling chain, when UpdateDocWithPhraseBoxContents( is called with bAttemptStoreToKB
	// == TRUE) and KB::StoreText() is called on NULL KBs. I've moved the block containing
	// the UnLoadKBs() call below down past the OnSaveModified() call. I've also added tests
	// in CKB::StoreText() for NULL KBs.

	// ensure no selection remains, in case the layout is destroyed later and the app
	// tries to do a RemoveSelection() call on a non-existent layout
	gpApp->GetView()->RemoveSelection();

	if (gpApp->m_bFreeTranslationMode)
	{
		// free translation mode is on, so we must first turn it off
		gpApp->GetFreeTrans()->OnAdvancedFreeTranslationMode(event);
	}

	bUserCancelled = FALSE; // default
	if (!OnSaveModified())
	{
		bUserCancelled = TRUE;
		pApp->LogUserAction(_T("Cancelled OnSaveModified() from OnFileClose()"));
		return;
	}

	// whm 2Sep2021 added. Here seems to be a location that gets executed when
	// a document is closed, both for regular non-collab docs and for collab docs.
	// We need to clear the auto-correct has map when the document closes.
	pApp->EmptyMapAndInitializeAutoCorrect();

	// whm 19Sep11 moved this block here from above the OnSaveModified() call. See
	// comment where the code is commented out above for reason for the move.
	// Remove KBs from the heap, when colloborating with an external editor
	if (pApp->m_bCollaboratingWithBibledit || pApp->m_bCollaboratingWithParatext)
	{
		// closure of the collaboration document should clobber the KBs as well, just in
		// case the user switches to a different language in PT for the next "get" - so we
		// set up for each document making no assumptions about staying within a certain
		// AI project each time - each setup is independent of what was setup last time
		// (we always create and delete these as a pair, so one test would suffice)
		if (pApp->m_pKB != NULL || pApp->m_pGlossingKB != NULL)
		{
			UnloadKBs(pApp); // also sets m_pKB and m_pGlossingKB each to NULL
		}
	}
	// BEW added 19Nov09, for read-only support; when a document is closed, attempt
	// to remove any read-only protection that is current for this project folder, because
	// the owning process may have come to have abandoned its ownership prior to the local
	// user closing this document, and that gives the next document opened in this project
	// by the local user the chance to own it for writing
	if (!pApp->m_curProjectPath.IsEmpty())
	{
		// if unowned, or if my process has the ownership, then ownership will be removed
		// at the doc closure (the ~AIROP-*.lock file will have been deleted), and TRUE
		// will be returned to bRemoved - which is then used to clear m_bReadOnlyAccess
		// to FALSE. This makes this project ownable by whoever next opens a document in it.
		bool bRemoved = pApp->m_pROP->RemoveReadOnlyProtection(pApp->m_curProjectPath);
		if (bRemoved)
		{
			pApp->m_bReadOnlyAccess = FALSE; // project folder is now ownable for writing
			// whm 7Mar12 Note: We do not reset the m_bFictitiousReadOnlyAccess	here because
			// if it is TRUE it should stay set to TRUE until a project close (in EraseKB)
			// or App exit. Note: the RemoveReadOnlyProtection() call above also removes our
			// fictitious ROPFile, but it gets created again when the next doc is opened as
			// long as the project has not closed (EraseKB called), since the
			// m_bFictitiousReadOnlyAccess flag does not get reset here.
			pApp->GetView()->canvas->Refresh(); // try force color change back to normal
			// white background -- it won't work as the canvas is empty, but the
			// removal of read only protection is still done if possible
		}
		else
		{
			pApp->m_bReadOnlyAccess = TRUE; // this project folder is still read-only
				// for this running process, as we are still in this project folder
		}
	}

	bUserCancelled = FALSE;
	CAdapt_ItView* pView = (CAdapt_ItView*)GetFirstView();
	wxASSERT(pView != NULL);
	pView->RemoveSelection(); // required, else if a selection exists and user closes doc and
			// does a Rebuild Knowledge Base, the m_selection array will retain hanging
			// pointers, and Rebuild Knowledge Base's RemoveSelection() call will cause a
			// crash
	pView->ClobberDocument(); // BEW 13Jul19 sets m_bDocumentDestroyed to TRUE (only DoAutoSaveDoc() uses)

	// delete the buffer containing the filed-in source text
	if (pApp->m_pBuffer != NULL)
	{
		delete pApp->m_pBuffer;
		pApp->m_pBuffer = (wxString*)NULL; // MFC had = 0
	}

	// show "Untitled" etc
	wxString viewTitle = _("Untitled - Adapt It");
	SetTitle(viewTitle);
	SetFilename(viewTitle, TRUE);	// here TRUE means "notify the views" whereas
									// in the MFC version TRUE meant "add to MRU list"
	// Note: SetTitle works, but the doc/view framework overwrites the result with "Adapt
	// It [unnamed1]", etc unless SetFilename() is also used.
	//
	// whm modified 13Mar09:
	// When the doc is explicitly closed on Linux, the Ctrl+O hot key doesn't work unless the focus is
	// placed on an existing element such as the toolbar's Open icon (which is where the next action
	// would probably happen).
	CMainFrame* pFrame = pApp->GetMainFrame();
	wxASSERT(pFrame != NULL);
	wxASSERT(pFrame->m_pControlBar != NULL);
	pFrame->m_pControlBar->SetFocus();
}

///////////////////////////////////////////////////////////////////////////////
/// \return nothing
/// \param      event   -> the wxUpdateUIEvent that is generated when the File Menu is about
///                         to be displayed
/// \remarks
/// Called from: The wxUpdateUIEvent mechanism when the associated menu item is selected, and before
/// the menu is displayed.
/// Enables or disables menu item associated with the wxID_CLOSE identifier.
/// If Vertical Editing is in progress the File Close menu item is disabled, and this handler
/// immediately returns. Otherwise, the item is enabled if m_pSourcePhrases has at least one
/// item in its list; otherwise the item is disabled.
///////////////////////////////////////////////////////////////////////////////

void CAdapt_ItDoc::OnUpdateFileClose(wxUpdateUIEvent& event)
{
	// BEW 10May14 I won't disable the close if clipboard adapting mode is still
	// in effect, rather, the OnFileClose() call will automatically restore the
	// cached document before doing anything else, and what will be closed will then
	// correctly be the cached-but-now-has-become-the-active document. This is a nicer
	// protocol than simply disabling all the File or document i/o, since a new user may
	// not know why he can't save or get a new file, so he may want to just close to make
	// things okay the brute force way - so we'll let him
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	if (gbVerticalEditInProgress)
	{
		event.Enable(FALSE);
		return;
	}

	if (gpApp->m_trialVersionNum >= 0)
	{
		event.Enable(FALSE);
		return;
	}

	if (pApp->m_pSourcePhrases->GetCount() > 0)
	{
		event.Enable(TRUE);
	}
	else
	{
		event.Enable(FALSE);
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \return TRUE if the document is successfully backed up, otherwise FALSE.
/// \param	pApp	         -> currently unused
/// \param  pRenamedFilename -> points to NULL (the default value), but if a valid
///                             different filename was supplied by the user in the
///                             Save As dialog, then it points to the wxString which
///                             holds that name (the caller will have verified
///                             beforehand that it is a valid filename))
/// \remarks
/// Called by the Doc's DoFileSave() function.
/// BEW added 23June07; do no backup if gbDoingSplitOrJoin is TRUE;
/// these operations could produce a plethora of backup docs, especially for a
/// single-chapters document split, so we just won't permit splitting, or joining
/// (except for the resulting joined file), or moving to generate new backups.
/// If rename is requested, we hold off on it to the very end because it will be the case
/// that any pre-existing backup will have the old filename, so we do the backup with the
/// old name, and only after that do we handle the rename. (We don't support renames nor
/// backing up when doing Split Document or Join Document either.)
/// BEW changed 29Apr10, to allow a rename option from user's use of the rename
/// functionality within the Save As dialog
///////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItDoc::BackupDocument(CAdapt_ItApp* WXUNUSED(pApp), wxString* pRenamedFilename)
{
	if (gbDoingSplitOrJoin)
		return TRUE;

	wxFile f; // create a CFile instance with default constructor

	// make the working directory the "Adaptations" one; or a bible book folder
	// if in book mode
	wxString basePath;
	bool bOK;
	// whm 8Apr2021 added wxLogNull block below
	{
		wxLogNull logNo;	// eliminates any spurious messages from the system if the wxSetWorkingDirectory() call returns FALSE

		if (gpApp->m_bBookMode && !gpApp->m_bDisableBookMode)
		{
			basePath = gpApp->m_bibleBooksFolderPath;
			bOK = ::wxSetWorkingDirectory(gpApp->m_bibleBooksFolderPath);
		}
		else
		{
			basePath = gpApp->m_curAdaptationsPath;
			bOK = ::wxSetWorkingDirectory(gpApp->m_curAdaptationsPath);
		}
	} // end of wxLogNull scope
	if (!bOK)
	{
		wxString str;
		//IDS_DOC_BACKUP_PATH_ERR
		if (gpApp->m_bBookMode && !gpApp->m_bDisableBookMode)
			str = str.Format(_(
				"Warning: document backup failed for the path:  %s   No backup was done."),
				GetApp()->m_bibleBooksFolderPath.c_str());
		else
			str = str.Format(_(
				"Warning: document backup failed for the path:  %s   No backup was done."),
				GetApp()->m_curAdaptationsPath.c_str());
		wxMessageBox(str, _T(""), wxICON_EXCLAMATION | wxOK);
		return FALSE;
	}

	// make sure the backup filename complies too (BEW added 23June07) -- the function sets
	// m_curOutputBackupFilename based on the passed in filename string

	// BEW changed 29Apr10, MakeOutputBackupFilenames() will reset
	// m_curOutputBackupFilename and if there is to be a filename rename done below, we
	// would lose the old value of m_curOutputBackupFilename; so we store the latter so
	// that we can be sure to remove the old backup file if it exists on disk (it won't
	// exist, for example, if the use has only just turned on document backups), and then
	// we'll use m_curOutputBackupFilename's contents, whether renamed or not, to create
	// the wanted backup file
	//bool bOldBackupExists = FALSE; // set below but unused unused
	wxString saveOldFilename = gpApp->m_curOutputBackupFilename;
	if (pRenamedFilename == NULL)
	{
		// no rename is requested, so go ahead with the legacy call
		MakeOutputBackupFilenames(gpApp->m_curOutputFilename);
	}
	else
	{
		// a rename is requested, so the first param should be the new filename
		MakeOutputBackupFilenames(*pRenamedFilename);
	}

	// remove the old backup
	wxString aFilename = saveOldFilename;
	if (wxFileExists(aFilename))
	{
		// this backed up document file is on the disk, so delete it
		//bOldBackupExists = TRUE;
		if (!wxRemoveFile(aFilename))
		{
			wxString s;
			s = s.Format(_(
				"Could not remove the backed up document file: %s; the application will continue"),
				aFilename.c_str());
			wxMessageBox(s, _T(""), wxICON_EXCLAMATION | wxOK);
			// do nothing else, let the app continue
		}
	}

	// the new backup will have the name which is now in m_curOutputBackupFilename,
	// whether based on the original filename, or a user-renamed filename
	int len = gpApp->m_curOutputBackupFilename.Length();
	if (gpApp->m_curOutputBackupFilename.IsEmpty() || len <= 4)
	{
		wxString str;
		// IDS_DOC_BACKUP_NAME_ERR
		str = str.Format(_(
			"Warning: document backup failed because the following name is not valid: %s    No backup was done."),
			gpApp->m_curOutputBackupFilename.c_str());
		wxMessageBox(str, _T(""), wxICON_EXCLAMATION | wxOK);
		return FALSE;
	}

	// copied from DoFileSave - I didn't change the share options, not likely to matter here
	bool bFailed = FALSE;
	if (!f.Open(gpApp->m_curOutputBackupFilename, wxFile::write))
	{
		wxString s;
		s = s.Format(_(
			"Could not open a file stream for backup, in BackupDocument(), for file %s"),
			gpApp->m_curOutputBackupFilename.c_str());
		wxMessageBox(s, _T(""), wxICON_EXCLAMATION | wxOK);
		// if f failed to Open(), we've just lost any earlier backup file we already had;
		// well, we could build some protection code but we'll not bother as failure to
		// Open() is unlikely, and it's only a backup which gets lost - presumably the doc
		// file itself is still good
		return FALSE;
	}

	CSourcePhrase* pSrcPhrase;
	CBString aStr;
	CBString openBraceSlash = "</"; // to avoid "warning:
			// deprecated conversion from string constant to 'char*'"

	// prologue (BEW changed 02July07 to use Bob's huge switch in the
	// GetEncodingStrongForXmlFiles() function which he did, to better support
	// legacy KBs & doc conversions in SILConverters conversion engines)
	gpApp->GetEncodingStringForXmlFiles(aStr);
	DoWrite(f, aStr);

	// add the comment with the warning about not opening the XML file in MS WORD
	// 'coz is corrupts it - presumably because there is no XSLT file defined for it
	// as well. When the file is then (if saved in WORD) loaded back into Adapt It,
	// the latter goes into an infinite loop when the file is being parsed in.
	aStr = MakeMSWORDWarning(); // the warning ends with \r\n
								// so we don't need to add them here
	// doc opening tag
	aStr += "<";
	aStr += xml_adaptitdoc;
	aStr += ">\r\n";
	DoWrite(f, aStr);

	// place the <Settings> element at the start of the doc
	aStr = ConstructSettingsInfoAsXML(1);
	DoWrite(f, aStr);

	// add the list of sourcephrases
	SPList::Node* pos_pSP = gpApp->m_pSourcePhrases->GetFirst();

	if (m_bLegacyDocVersionForSaveAs)
	{
		// user chose a legacy xml doc build, and so far there is only one such
		// choice, which is docVersion == 4
		wxString endMarkersStr; endMarkersStr.Empty();
		wxString inlineNonbindingEndMkrs; inlineNonbindingEndMkrs.Empty();
		wxString inlineBindingEndMkrs; inlineBindingEndMkrs.Empty();
		while (pos_pSP != NULL)
		{
			pSrcPhrase = (CSourcePhrase*)pos_pSP->GetData();
			// get a deep copy, so that we can change the data to what is compatible
			// with doc version 4 without corrupting the pSrcPhrase which remains in
			// doc version 5
			CSourcePhrase* pDeepCopy = new CSourcePhrase(*pSrcPhrase);
			pDeepCopy->DeepCopy();

			// see comments in DoFileSave()
			FromDocVersion5ToDocVersion4(pDeepCopy, &endMarkersStr, &inlineNonbindingEndMkrs,
				&inlineBindingEndMkrs);

			pos_pSP = pos_pSP->GetNext();
			aStr = pDeepCopy->MakeXML(1); // 1 = indent the element lines with a single tab
			DeleteSingleSrcPhrase(pDeepCopy, FALSE); // FALSE means "don't try delete a partner pile"
			DoWrite(f, aStr);
		}
	}
	else // use chose a normal docVersion 5 xml build
	{
		while (pos_pSP != NULL)
		{
			pSrcPhrase = (CSourcePhrase*)pos_pSP->GetData();
			pos_pSP = pos_pSP->GetNext();
			aStr = pSrcPhrase->MakeXML(1);
			DoWrite(f, aStr);
		}
	}
	// doc closing tag
	aStr = xml_adaptitdoc;
	aStr = openBraceSlash + aStr; //"</" + aStr;
	aStr += ">\r\n";
	DoWrite(f, aStr);

	// close the file
	f.Close();
	f.Flush();
	if (bFailed)
		return FALSE;
	else
		return TRUE;
}

int CAdapt_ItDoc::GetCurrentDocVersion()
{
	return m_docVersionCurrent;
}

/*
// The following function is currently unused.
// whm 10Nov2023 added the following function to aid in insertion of 
// the marker-being-unfiltered into pList.
// Why have the ThisMarkerMustRelocateBeforeOfAfterAdjacentMarker() 
// function?
// Our filtering code now does a good job of filtering markers and
// associated text - filtering any of the above 4 markers in any
// order, including carrying forward filtered material to a previous 
// location, and combining it with any already existing filtered 
// material that might exist on the previous source phrase.
// Filtering is relatively easy as we can readily determine where
// the filtered material should go - prior to the source phrase that
// precedes the marker being filtered. And, if the last word of the 
// associated text of this marker is currently storing filtered 
// material itself, and the marker itself gets filtered, its last
// word's stored material can be easily combined with the currently-
// being filtered marker, and both carried forward to be re-stored
// on the first visible source phrase preceding the marker being 
// filtered.
// Unfiltering is more complex especially when unfiltering one of
// several adjacent markers that had previously been filtered at a
// given location. It is more complex because once adjacent markers
// have been filtered we loose ordering information about the 
// filtered markers and their ordering with respect to any adjacent
// markers that are currently unfiltered and possibly visible before 
// or after the current source phrase. We don't know from their
// storage order within m_filteredInfo whether the marker being
// unfiltered from there should be inserted before or after any
// marker and its associated text that is already in an unfiltered 
// state adjacent to the marker being filtered. 
// 
// This function was created to deal with the following situation:
// Whevever multiple adjacent markers have previously been filtered,
// knowledge of their original ordering in the text can be lost, and
// that knowledge is needed to accurately determine the position 
// where the marker-being-unfiltered should be inserted back into the
// main text, especially when text that is adjacent to the marker-
// being-unfiltered's storage location is itself part of a filterable
// marker. Always unfiltering a marker and its associated text 
// following the storage source phrase, can easily result in two 
// adjacent markers ending up in an order that is reverse of their
// original order.
// For example, sapos 2 originally adjacent markers \s and \r were
// filtered. Our current unfiltering routine unfilters markers
// back to the main text immediately following their storage location.
// If the user unfilters the \r marker, then unfilters the
// \s marker they will end up being in the correct order in the main 
// text \s followed by \r. However, if the user unfilters the \s 
// marker, then unfilters the \r marker they will end up being 
// restored to the main text in the wrong/reverse order \r followed
// by \s. The situation only gets more complex when 3 or 4 adjacent
// markers have all been filtered and are all unfiltered one-by-one
// in different unfiltering orders. In the Nyindrou Scripture texts 
// one sometimes finds 4 filterable markers adjacent to each other:
// \ms, \mr, \s, and \r - each having its own associated text. When
// these texts are first created the \mr and \r markers are parsed
// as filtered, but a user can easily also filter \mr and \r so that
// all 4 markers \ms, \mr, \s, and \r get filtered and stored together
// on the same source phrase's m_filteredInfo member, that source 
// phrase being the last word of text just before the original 
// location of the first first of the 4 adjacent markers now in a
// filtered state. The user can choose to unfilter all of the 4
// already-filtered markers, and may unfilter all 4 of them in any 
// one of 24 different ways! Here are those 24 ways to unfilter them:
// \ms \mr \s \r, \ms \mr \r \s, \ms \s \mr \r, \ms \s \r \mr, \ms \r \mr \s, \ms \r \s \mr, 
// \mr \ms \s \r, \mr \ms \r \s, \mr \s \ms \r, \mr \s \r \ms, \mr \r \ms \s, \mr \r \s \ms,
// \s \ms \mr \r, \s \ms \r \mr, \s \mr \ms \r, \s \mr \r \ms, \s \r \ms \mr, \s \r \mr \ms,
// \r \ms \mr \s, \r \ms \s \mr, \r \mr \ms \s, \r \mr \s \ms, \r \s \ms \mr, \r \s \mr \ms.
// Within the above 24 different unfiltering sequences, only one
// sequence, the first one: \ms \mr \s \r, is the correct sequence.
// Unfiltering. The same possible sequences for filtering these
// four markers area also possible, and the m_filteredInfo storage
// member might also have the order of filtered marker strings 
// within \~FILTER ...\~FILTER* markers stored in similarly 
// different orders.
// Our algorithm mmust be able to unfilter markers and their
// associated words stored in any one of the above 23 incorrect
// sequences, and decide where to insert the marker strings in 
// the one correct order in the main text!
// My assumption is that we can indeed devise a function that can
// decide the correct position/node to insert the subList of source 
// phrases representing each marker-being-unfiltered string, 
// inserting it into the main pList of source phrases, and thereby
// end up with the correct order of all adjacent markers as they 
// are being unfiltered.
// I think we can gain sufficient knowledge to unfilter adjacent 
// filtered markers by examining the marker-being-unfiltered's 
// occursUnder information and scanning to determine what markers 
// may be adjacent - either following or preceding - the current 
// marker being unfiltered. 
// Depending on the occursUnder information available, it may be
// necessary to unfilter the current marker:
// a. immediately following the current marker being unfiltered (this
//    is the usual case when there are no adjacent markers).
// b. before an adjacent preceding marker and its associated text
//    (this requires scanning preceding associated text words to
//    locate the SP that contains the associated text marker and
//    return the position of the SP BEFORE that marker).
// c. after an adjacent following marker and its associated text.
//    (this requires scanning the following SP, and if it contains
//    the adjacent marker, continue scanning followin SPs until it
//    locates the SP that is the last word of associated text and
//    return the position of the SP AFTER that ending word's SP).
// 
// Let's say that all 4 markers \ms, \mr, \s, and \r were 
// previously filtered, and are stored within in a source phrase 
// with sequence number say 20.
// And, at a later time the user decides to unfilter some or all
// of the filtered material. There are a number of different ways
// the user might proceed since the unfiltering might be done in
// any of 23 possible orders, but the user decides to unfilter \s
// first. 
// The occursUnder string list of markers for the \s marker has:
//    "c"
// And the occursUnder string list of markers for the \r marker has:
//    "c s s1 s2 s3 s4"
// From these occursUnder lists we know the following about the 
// relative ordering of the \r and \s markers:
// While \s can occurs most anywhere under the "c" chapter marker,
// The \r marker occurs UNDER any adjacent section heading including
// \s.
// OK, let's now look at the following unfiltering scenario:
// The user decides first to unfilter the \s marker, and then unfilter
// the \r marker, both of which are currently stored at the source 
// phrase sequence number 20. The user first unfilters the \s marker
// which is inserted along with its associated text AFTER its storage
// location (sequence 20) starging at sequence numbers 21 and 
// following. Then after that, the user decides to unfilter the
// \r maker which is still stored at sequence number 20. The usual
// location for inserting filtered information is AFTER the source 
// phrase location where the filtered info is stored, which would
// usually be starting at sequence 21, but we already unfiltered the
// \s marker and its associated text starting at sequence number 21
// and following. If the \r marker were to be unfiltered starting at
// sequence number 21, it would push the already-unfiltered \s marker
// and its associated text AFTER its location - resulting in the \s
// marker and associated text being ordered AFTER the \r marker and
// its associated text. But \s "occurring under" \r is NOT the correct
// ordering. The ordering should be \r "occurring under" \s.
// Therefore, our unfiltering routine - when unfiltering \r in this
// situation, needs to check to see if there is an adjacent unfiltered
// marker in the text immediately AFTER its stored location, and if 
// so, check whether that adjacent marker is present in the currently 
// being unfiltered marker's occursUnder list. If so, the routine 
// needs to scan through the adjacent marker and its associated text 
// to find the sequence number of the last word of the adjacent 
// marker's text, and insert the \r marker and its associated text 
// AFTER that last word's SP sequence number.
// If we insert the \r marker and its associated text after that last
// word associated with the \s marker, then we will get the proper
// order of both markers \s and \r once both of them have been 
// unfiltered. 
// Hence, it isn't really feasible to rely on the ordering of 
// still-filtered marker information that is stored within the 
// pSP->m_filteredInfo member. The information we need is no longer 
// within that m_filteredInfo member! The \s member was already 
// unfiltered, and now that we are in the process of unfiltering an 
// adjacent \r marker, there is nothing within the m_filteredInfo 
// member's current storage alone to inform us that the \r marker and
// its associated text should be restored or unfiltered to a source 
// phrase that may be located many SP sequence numbers following the 
// current pSP source phrase - i.e., inserted at the source phrase 
// immediately following the last word of the \s marker's associated 
// text.
// With my recent refactoring of USFMAnalysis struct to include the usfm
// occursUnder information, we now have ordering information readily 
// available for the marker that is now being unfiltered. To utilize 
// that information we call the following function with the long name:
// bool ThisMarkerMustRelocateBeforeOfAfterAdjacentMarker(SPList::Node* currPos, 
//		SPList::Node*& prevPos, wxString occursUnderStr)
// This function then is called from the ReconstituteAfterFilteringChange() 
// function's if (bUnfilteringRequired) block.
// 
// TODO: Revise comment below !!!
// 1. Get the occursUnder list, if any, call LookupSFM(bareMarker) to get
//    the pUsfmAnalysis instance of the current marker being unfilterd,
//    and retrieve the pUsfmAnalysis->occursUnder information into a 
//    string list.
// 2. If the above list from occursUnder is not empty, call a new function
//     named with these input parameters:
//     ThisMarkerMustRelocateBeforeOfAfterAdjacentMarker(
//			saveNextPos, filterableMarkers)
//     This above mentioned function returns the SPList::Node* pointer to 
//     a pList position tempPos which, if non-NULL, points to the position 
//     in pList to insert the current pSublist.
//     This function scans backwards through pList checking previous source 
//     phrases for any "filterable" begin markers that satisfy these 
//     conditions:
//     a. A found marker must be "filterable", i.e., its 
//        pUsfmAnalysis->userCanSetFilter == TRUE.
//     b. It is an "adjacent" marker, that is, no non-marker text occurs
//        between the curent marker and the text assoicated with the
//        candidate marker.
// 3. If the ThisMarkerMustRelocateBeforeOfAfterAdjacentMarker()
//    function locates and returns a non-NULL pointer to the position of a 
//    source phrase (in pList) matching the conditions in 2 above, we then 
//    check to see if any of the filterableMarkersArr markers are present
//    within the currently being-unfiltered-marker's occursUnder list. 
// 4. If the adjacent marker is present within the occursUnder list, we
//    know we can asign our insertPos to be that returned position - the
//    position at which point we start inserting the source phrases of our 
//    pSublist that represent the unfiltered text being inserted into the 
//    document's pList of source phrases. If a tempPos is non-NULL, the 
//    third parameter filterableMarkersArr array will contain any potential
//    markers to check if present in the occursUnder string list.
// TODO: Update above comments
// whm 10Nov2023 added the following to aid in insertion of marker-being-unfiltered into pList
// when a previous adjacent marker must occur under the current marker-being-unfiltered.
bool CAdapt_ItDoc::ThisMarkerMustRelocateBeforeOfAfterAdjacentMarker(SPList::Node* currPos, 
	SPList::Node*& prevPos, wxString occursUnderStr)
{
	SPList::Node* currentPos = currPos; // use local node pointer
	wxArrayString filterableMkrsArr;
	filterableMkrsArr.Clear(); // initialize
	if (currentPos == NULL)
	{
		prevPos = NULL;
		return FALSE;
	}
	// The incoming parameter Node* pointer currPos is a pointer to a position in the pList.
	// That currPos pointer is actually the saveNextPos back in the caller, i.e., the position
	// of the source phrase FOLLOWING the source phrase containing the filtered marker that's 
	// currently being unfiltered. Therefore we need to start scanning backwards one (two???) 
	// position prior to that saveNextPos position for eligible markers in pList. 
	// TODO: If need to start scanning two positions prior uncomment the second block below.
	if (currentPos != NULL)
	{
		currentPos = currentPos->GetPrevious(); // Backup one to get the current position.
	}
	//if (currPos != NULL)
	//{
	//	currPos = currPos->GetPrevious(); // Backup one more to get previous position before the current one.
	//}
	bool bKeepSearching = TRUE;
	while (currentPos != NULL && bKeepSearching)
	{
		CSourcePhrase* ptempSP = currentPos->GetData();
		if (ptempSP != NULL)
		{
			// Examine ptempSP's m_markers and m_filteredInfo members. 
			if (ptempSP->m_markers.IsEmpty() && ptempSP->GetFilteredInfo().IsEmpty())
			{
				currentPos = currentPos->GetPrevious();
			}
			else
			{
				// There is content in m_markers and/or m_filteredInfo, so collect any
				// content present into a filterableMkrs array to make it easier to 
				// examine the markers one-by-one to see if they are present within the
				// occursUnderStr string of the current marker.
				// If a marker is present in occursUnderStr we return TRUE to the caller
				// ReconstituteAfterFilteringChange(), and return its pList node position 
				// in the prePos reference parameter.
				// We can combine any m_markers and m_filteredInfo strings together, since
				// the GetFilteredAndSweptUpMarkersFromString() function called below internally
				// calls the GetMarkersAndEndMarkersFromString() function which knows how to
				// deal with any \~FILTER ... \~FILTER* markers that may be enclosing a
				// candidate marker within the previous marker's m_filteredInfo member.
				// Our GetFilteredAndSweptUpMarkersFromString() function ensures that the return
				// filterableMkrs array only contains whole markers, and not any 
				// associated text that would be present together with a marker enclosed
				// within \~FILTER ...\~FILTER* markers.
				wxArrayString filteredMkrsArray;
				filteredMkrsArray.Clear(); // need to start each location check with empty array
				wxArrayString filteredMkrsArrayWithFilterBrackets;
				filteredMkrsArrayWithFilterBrackets.Clear();
				bool bInsertAtThisPos = FALSE;
				wxString markerStr = ptempSP->m_markers + ptempSP->GetFilteredInfo();
				GetFilteredAndSweptUpMarkersFromString(markerStr, filteredMkrsArrayWithFilterBrackets, filteredMkrsArray);
				size_t fm_ct = filteredMkrsArray.GetCount();
				wxString mkrToCheck;
				if (fm_ct > 0)
				{
					for (int i = 0; i < (int)fm_ct; i++)
					{
						mkrToCheck = filteredMkrsArray.Item(i);
						if (occursUnderStr.Find(mkrToCheck) != wxNOT_FOUND)
						{
							bInsertAtThisPos = TRUE;
						}
					}
					if (bInsertAtThisPos == TRUE)
					{
						bKeepSearching = FALSE;
						prevPos = currentPos; //return currPos;
						return TRUE;
					}
				}
				currentPos = currentPos->GetPrevious();
			}
		}
		else
		{
			bKeepSearching = FALSE;
		}
	}
	prevPos = NULL;
	return FALSE;
}
*/

/*
// This function is currently unused but saved for possible future use
// whm 26Nov2023 added the following function to aid in insertion of 
// the marker-being-unfiltered into pList.
// This function returns a list of any adjacent markers before and after 
// the input mkr and indicates the filter status of those markers
// The input parameters are:
//	wxString mkr - the marker being unfiltered
//	wxString ChVs - the chapter:verse context where the current pSrcPhrase is located
//	wxArrayString m_UsfmStructArr - the m_UsfmStructArr array that is on the Doc
// This function does the following:
// 1. Locates the marker-being-unfiltered (mkr) within the m_UsfmStructArr array
// 2. To narrow down its search it first locates the chapter:verse reference using
//    the context indicated by the ChVs incoming parameter.
// 3. Once the marker is located within the array, this function determines if
//    the marker mkr is adjacent to other markers, occurring before the mkr and
//    after the mkr. 
// 4. Adjacent markers are returned in a string of the form:
//    mkrBefore1:n:mkrBefore2:n@mkr@mkrAfter1:n:mkrAfter2:n
// 	  where the mkr itself is delimited by @ chars before and after
//    where the found markers are delimited by colons, and n is the filter status 1 or 0. 
// 5. The filter starus of each marker returned in 4 above is contained in a string
//    called filterStatusStr which contains a 0 or 1 for each marker concatenated together
//    into a string with the status of the marker mkr delimited by @, so the form of the
//    filterStatusStr is: "0001@1@1100" or "100@1@0" etc. 
wxString CAdapt_ItDoc::GetAdjacentUsfmMarkersAndTheirFilterStatus(wxString mkr, wxString ChVs, 
	wxArrayString m_UsfmStructArr, wxString& filterStatusStr, wxString& filterableMkrStr)
{
	wxString adjacentMkrStr;
	adjacentMkrStr.Empty();
	wxString sStatStr; 
	sStatStr.Empty();
	wxASSERT(!mkr.IsEmpty());
	wxString ch, vs;
	bool bNoColonInRef = FALSE;
	wxString colon = _T(":");
	if (!ChVs.IsEmpty())
	{
		int posColon = ChVs.Find(colon);
		if (posColon != wxNOT_FOUND)
		{
			ch = ChVs.Mid(0, posColon);
			vs = ChVs.Mid(posColon + 1);
		}
		else
		{
			// no colon in ch:vs so assume its just a ch number
			bNoColonInRef = TRUE;
			ch = ChVs;
		}
	}
	// Lines in the m_UsfmStructARR array are of the form:
	// \mkr:numChars:0
	// \mkr:numChars:1
	// \c n:numChars:0
	// \v nn:numChars:0
	// where:
	//   the marker (and any chapter or verse number) is the first field (before 1st colon)
	//   the numChars field is a number representing the character count of the marker and its assoc text
	//   the 0 or 1 is the filter status of the marker

	int totLines = 0;
	totLines = (int)m_UsfmStructArr.GetCount();
	wxString arrLine;
	wxString marker;
	wxString numChars;
	wxString filterStatus;
	int lineIndex = 0;
	wxString chapter = _T("\\c ") + ch;
	wxString verse = _T("\\v ") + vs;
	// Scan the m_UsfmStructArr array to find the ch:vs reference specified in the incoming parameter ChVs
	bool bRefFound = FALSE;
	bool bMkrFound = FALSE;
	bool bChFound = FALSE;
	bool bVsFound = FALSE;
	while (lineIndex < totLines && !bRefFound)
	{
		arrLine = m_UsfmStructArr.Item(lineIndex);
		ParseUsfmStructLine(arrLine, marker, numChars, filterStatus);
		if (marker.Find(chapter) != wxNOT_FOUND)
		{
			bChFound = TRUE;
		}
		if (bChFound && marker.Find(verse) != wxNOT_FOUND)
		{
			bVsFound = TRUE;
		}
		if (bChFound && bVsFound)
		{
			bRefFound = TRUE;
		}
		lineIndex++;
	}
	if (bRefFound || (!bRefFound && bChFound))
	{
		// We found a ch:vs reference, or at least a ch without a verse to narrow down
		// our search context.
		// Now continue searching from lineNum to locate the marker we're wanting to use
		// as the starting point for collecting any filterable markers that are following
		// that marker and adjacent to it. Being adjacent means there are no non-filterable
		// markers such as chapter or verse numbers.
		// Note: lineNum is now pointing to the line following the ch:vs reference
		while (lineIndex < totLines && !bMkrFound)
		{
			arrLine = m_UsfmStructArr.Item(lineIndex);
			ParseUsfmStructLine(arrLine, marker, numChars, filterStatus);
			if (marker == mkr)
			{
				bMkrFound = TRUE;
				break;
			}
			lineIndex++;
		}
		if (bMkrFound)
		{
			// The lineIndex now points at the array line containing the marker.
			// We will extract up to 5 lines before the marker and up to 5 lines after the marker
			// and examine them for adjacent markers. The number of lines extracted before and 
			// after the @mkr...@ can be less than 5 if the mkr being unfiltered is closer than 5
			// lines to the first line in the array, or to the last line in the array.
			adjacentMkrStr = _T("@") + marker + colon + numChars + colon + filterStatus +_T("@");
			sStatStr = _T("@") + filterStatus + _T("@");
			USFMAnalysis* pUsfmAnalysis;
			bool bUserCSF = FALSE;
			int nUserCSF = 0;
			wxString userCSF;
			userCSF.Empty();
			wxString bareMarker; 
			bareMarker.Empty();
			bareMarker = GetBareMarkerForLookup(marker);
			pUsfmAnalysis = LookupSFM(bareMarker);
			if (pUsfmAnalysis != NULL)
			{
				bUserCSF = pUsfmAnalysis->userCanSetFilter;
				nUserCSF = (int)bUserCSF;
				userCSF << nUserCSF;
				filterableMkrStr = _T("@") + userCSF + _T("@");
			}
			else
			{
				// marker must be an unknown marker, assume it is filterable i.e., userCanSetFilter is TRUE
				filterableMkrStr = _T("@1@");

			}
			wxString m;
			wxString c;
			wxString f;
			int nBefore = 5;
			int nAfter = 5;
			int tempLineIndex = lineIndex - 1; // don't include the marker line itself
			while (tempLineIndex >= 0 && nBefore > 0)
			{
				// Accumulate lines working backwards accumulating up to 5 lines before the marker
				arrLine = m_UsfmStructArr.Item(tempLineIndex);
				ParseUsfmStructLine(arrLine, m, c, f);
				bUserCSF = FALSE;
				nUserCSF = 0;
				userCSF.Empty();
				bareMarker.Empty();
				bareMarker = GetBareMarkerForLookup(m);
				pUsfmAnalysis = LookupSFM(bareMarker);
				if (pUsfmAnalysis != NULL)
				{
					bUserCSF = pUsfmAnalysis->userCanSetFilter;
					nUserCSF = (int)bUserCSF;
					userCSF << nUserCSF;
					filterableMkrStr = userCSF + filterableMkrStr;
				}
				else
				{
					// marker m must be an unknown marker, assume it is filterable i.e., userCanSetFilter is TRUE
					filterableMkrStr = _T("1") + filterableMkrStr;
				}
				adjacentMkrStr = arrLine + adjacentMkrStr;
				sStatStr = f + sStatStr;
				tempLineIndex--;
				nBefore--;
			}
			tempLineIndex = lineIndex + 1; // don't include the marker line itself
			while (tempLineIndex < totLines && nAfter > 0)
			{
				// Accumulate lines working forwards accumulating up to 5 lines after the marker.
				arrLine = m_UsfmStructArr.Item(tempLineIndex);
				ParseUsfmStructLine(arrLine, m, c, f);
				bUserCSF = FALSE;
				nUserCSF = 0;
				userCSF.Empty();
				bareMarker.Empty();
				bareMarker = GetBareMarkerForLookup(m);
				pUsfmAnalysis = LookupSFM(bareMarker);
				if (pUsfmAnalysis != NULL)
				{
					bUserCSF = pUsfmAnalysis->userCanSetFilter;
					nUserCSF = (int)bUserCSF;
					userCSF << nUserCSF;
					filterableMkrStr = filterableMkrStr + userCSF;
				}
				else
				{
					// marker m must be an unknown marker, assume it is filterable i.e., userCanSetFilter is TRUE
					filterableMkrStr = filterableMkrStr + _T("1");
				}
				adjacentMkrStr = adjacentMkrStr + arrLine;
				sStatStr = sStatStr + f;
				tempLineIndex++;
				nAfter--;
			}
			int dummyDebug = 1; wxUnusedVar(dummyDebug);
		}
	}
	filterStatusStr = sStatStr;
	return adjacentMkrStr;
}
*/

// This function parses a line from the m_USfmStructArr array into its components delimited by colon chars.
// This function is used within the ReorderFilterMaterialUsingUsfmStructData() function
// whm 26Mar2024 revised to utilize the MD5 sum data in identifying multiple markers which are
// the same marker and only differ by the MD5 sums, i.e., \ip <text1> \id <text2 \id <text3> etc.
void CAdapt_ItDoc::ParseUsfmStructLine(wxString lineStr, wxString& mkr, wxString& numChars, wxString& MD5sum, wxString& filterStatus)
{
	// Lines in the m_UsfmStructArr array have 4 fields delimited by 3 colons, and are of the form:
	// \mkr:numChars:abcdefghabcdefghabcdefghabcdefgh:0
	// \mkr:numChars:abcdefghabcdefghabcdefghabcdefgh:1
	// \c n:numChars:0:0
	// \v nn:numChars:abcdefghabcdefghabcdefghabcdefgh:0
	// where:
	//   The marker \mkr (and any chapter or verse number) is the marker field (before 1st colon) with
	//     initial backslash, but no following space. \c and \v markers have following space + number.
	//   The numChars field is a number representing the character count of the marker and its assoc text
	//   The abcdefghabcdefghabcdefghabcdefgh represents the 32 char MD5 hash string value of any text
	//     following the marker. For markers like \c nn (and empty content markers) which don't have 
	//     associated text, the MD5 hash value field is just 0
	//   The last field is a 0 or 1 which is the filter status of the marker.
	mkr.Empty();
	numChars.Empty();
	filterStatus.Empty();
	MD5sum.Empty();
	wxString colon = _T(":");
	int posColon = -1;
	wxString remainderStr;
	posColon = lineStr.Find(colon);
	if (posColon != wxNOT_FOUND)
	{
		mkr = lineStr.Mid(0, posColon);
		mkr.Trim(FALSE);
		mkr.Trim(TRUE);
		wxASSERT(!mkr.IsEmpty());
		remainderStr = lineStr.Mid(posColon + 1);
		posColon = remainderStr.Find(colon);
		if (posColon != wxNOT_FOUND)
		{
			numChars = remainderStr.Mid(0, posColon);
			numChars.Trim(FALSE);
			numChars.Trim(TRUE);
			wxASSERT(!numChars.IsEmpty());
			remainderStr = remainderStr.Mid(posColon + 1);
			posColon = remainderStr.Find(colon);
			if (posColon != wxNOT_FOUND)
			{
				MD5sum = remainderStr.Mid(0, posColon);
				MD5sum.Trim(FALSE);
				MD5sum.Trim(TRUE);
				wxASSERT(!MD5sum.IsEmpty());
				remainderStr = remainderStr.Mid(posColon + 1);
				filterStatus = remainderStr;
				filterStatus.Trim(FALSE);
				filterStatus.Trim(TRUE);
				wxASSERT(!filterStatus.IsEmpty());
			}
		}
	}
}

// whm 16Nov2023 added for support of the .usfmstruct file and the doc's m_UsfmStructArr array.
// This function is used to assign values to the the Doc's variables related to the creation
// and maintenance of the m_usfmStructArr in-memory array and related variables on the Doc, 
// and ensure that there is an appropriately populated external .usfmstruct file for the current 
// document, the <projname>.usfmstruct file being stored in the hidden .usfmstruct folder, which is
// a sub-folder of the current project's "Adaptations" folder.
// This function takes as its first parameter an enum value of: createNewFile, recreateExistingFile, 
// openExistingFile, or createFromSPList. 
// The second parameter is a reference parameter inputBuffer which is replaced by an internally
// built string by calling RebuildSourceText() if the first parameter enum is createFromSPList.
// The third parameter is an SPList* pointer to a source phrase list which is also used if the
// first parameter enum is createFromSPList.
// whm 26Mar2024 Modified this function to incorporate the MD5 hash sum value back into the
// usfmstruct file that is generated for each AI document.
// whm 2Apr2024 BEW's tessting revealed some significant issues with this function when opening
// and existing document. It wasn't calling RebuildSourceText from the SPList for one thing, and
// the GetLine(0) caused a crash when wny existing usfmstruct file existed but was empty. So the
// revisions of this date will hopefully fix those issues, and improve/simplify the function.
// The SetupUsfmStructArrayAndFile() function is called at the following time:
// 1. When a new document is created in the Doc's OnNewDocument()
// 2. When an existing document is opened in the Doc's OnOpenDocument()
// 3. When the source text of the document has been edited the View's OnEditSourceText()
// 4. When opening a document under collaboration in CollabUtilities.cpp's OpenDocWithMerger()
// 5. When OK_btn_delayedHandler_GetSourceTextFromEditor(), either for chapter only text, or whole book text.
// This function makes use of the GetUsfmStructureAndExtent() function - without the TRUE parameter, which 
// will result in the m_UsfmStructArr strings having the MD5 hash value - a 32 char string - being included 
// as a 4th colon delimited field for lines stored in the m_UsfmStructArr array. Each string in the array 
// will appear as:
// \mkr:numChars:abcdefghabcdefghabcdefghabcdefgh:0
// \mkr:numChars:abcdefghabcdefghabcdefghabcdefgh:1
// \c n:numChars:0:0
// \v nn:numChars:abcdefghabcdefghabcdefghabcdefgh:0
// where:
//   The marker \mkr (and any chapter or verse number) is the marker field (before 1st colon) with
//     initial backslash, but no following space. \c and \v markers have following space + number.
//   The numChars field is a number representing the character count of the marker and its assoc text
//   The abcdefghabcdefghabcdefghabcdefgh represents the 32 char MD5 hash string value of any text
//     following the marker. For markers like \c nn (and empty content markers) which don't have 
//     associated text, the MD5 hash value field is just 0
//   The last field is a 0 or 1 which is the filter status of the marker.
// In the GetUsfmStructureAndExtent() call below leeave out the 2nd parameter so that it defaults to FALSE
// value which then includes the MD5 has sum values in each marker line that goes into the array.
bool CAdapt_ItDoc::SetupUsfmStructArrayAndFile(enum UsfmStructFileProcess fileProcess,
	wxString& inputBuffer, SPList* pList)
{
	// whm 13Nov2023 added the following code to create a wxArrayString UsfmStructArr from 
	// the source input *pApp->m_pBuffer text, or alternately from a pList of source phrases,
	// and then save that array of strings to a file named <filename>.usfmstruct that is 
	// saved to a hidden sub-directory at the following path:
	//    /Adapt It Unicode Work/<project-directory/Adaptations/.usfmstruct/<filename>.usfmstruct
	// where <filename> is the name of the document file being created via gpApp->m_curOutputPath
	// which already has an .xml extension. We add the additional extension .usfmstruct to 
	// the usfm struct file we're creating.
	// This usfm struct file will get updated with current filter status fields by calling the 
	// UpdateCurrentFilterStatusOfUsfmStructFileAndArray() function here needed in other code.
	m_usfmStructDirName = _T(".usfmstruct");
	wxFileName structFn(gpApp->m_curOutputPath);
	m_usfmStructFilePath = structFn.GetPath();
	m_usfmStructFileName = structFn.GetFullName(); // gets full name including extension, but excluding directories
	m_usfmStructDirPath = m_usfmStructFilePath + gpApp->PathSeparator + m_usfmStructDirName;
	if (!::wxDirExists(m_usfmStructDirPath))
	{
		// The hidden dir .usfmstruct doesn't exist yet so create it.
		bool bOK;
		bOK = ::wxMkdir(m_usfmStructDirPath);
		if (!bOK)
		{
			// failure to make the directory not expected so English message to the user log is sufficient
			wxString msg = _T("In OnNewDocument() - Failed to Create hidden directory at %s");
			msg = msg.Format(msg, m_usfmStructDirPath.c_str());
			gpApp->LogUserAction(msg);
			m_bUsfmStructEnabled = FALSE; // set m_bUsfmStructEnabled to FALSE to disable usfmStruct processing
			return FALSE;
		}
	}

	// First determine if we have an existing and valid usfmstruct file for this document. If one exists, it
	// must not be empty and must have MD5 hash sum data. Set some flags to store the initial properties for the
	// usfmstruct file for this document.
	bool bTextFileNeedsRecreating = FALSE;
	bool bReadDataFromExistingUsfmFile = FALSE;
	m_usfmStructFilePathAndName = m_usfmStructDirPath + gpApp->PathSeparator + m_usfmStructFileName + m_usfmStructDirName;
	wxLogNull nolog; // avoid spurious messages from the system
	// Check whether we're opening an existing usfmstruct file. If so we set the bTextFileNeedsRecreating and
	// bReadDataFromExistingUsfmFile to TRUE if needed.
	if (::wxFileExists(m_usfmStructFilePathAndName) && fileProcess == openExistingFile)
	{
		wxTextFile textFile(m_usfmStructFilePathAndName);
		bool bOpened = textFile.Open();
		if (!bOpened)
		{
			wxString msg = _T("Failed f.Open() for reading usfmstruct info to %s");
			msg = msg.Format(msg, m_usfmStructFilePathAndName.c_str());
			gpApp->LogUserAction(msg);
			m_bUsfmStructEnabled = FALSE; // set m_bUsfmStructEnabled to FALSE to disable usfmStruct processing
			return FALSE;
		}
		else
		{
			// File is open for reading, and we read its contents into the m_UsfmStructArr
			// 
			// whm 26Mar2024 added. We'll check the first line of the existing file and see if it lacks MD5 hash 
			// sum data or not. If so, we need to first remove the existing file and create a new usfmstruct file 
			// in its place that contains the MD5 data that now exists in the m_UsfmStructArr array.
			// If the file has MD5 hash sum data fields, there will be 3 colons in each line, otherwise just
			// 2 colons will be present in each line.
			// If the existing file has the MD5 hash sum data, then we just read its data lines into the
			// m_UsfmStructArr array.
			// whm 2Apr2024 BEW reported a crash that was caused by the usfmstruct file existing but being
			// empty, and if empty the textFile.GetLine(0) call below would cause a crash due to index out of
			// range. So we must first check that the textFile has at least one line of text.
			wxString testLine; testLine.Empty();
			if (textFile.GetLineCount() > 0)
			{
				// The textFile has at least one text line in it. Does the file have MD5 hash sum data?
				testLine = textFile.GetLine(0);
				if (testLine.Replace(_T(":"), _T(":")) == 2) // Replace returns the number of replacements 
				{
					// The textFile doesn't have hash sum data so set flag to recreate it below.
					bTextFileNeedsRecreating = TRUE;
				}
				else
				{
					// The textFile has MD5 hash sum data, so set the flag indicating we can read from it
					// into the m_UsfmStructArr below
					bReadDataFromExistingUsfmFile = TRUE;
				}
			}
			else
			{
				// The textFile was empty so set flag to recreate it below.
				bTextFileNeedsRecreating = TRUE;
			}
		}
	}
	else
	{
		// No usfmstruct file exists so it needs to be recreated.
		bTextFileNeedsRecreating = TRUE;
	}

	// Substitute a string generated from RebuildSourceText if the fileProcess is createFromSPList
	if (fileProcess == createFromSPList)
	{
		int textLen;
		textLen = RebuildSourceText(inputBuffer, pList);
		if (textLen == 0)
		{
			// Not likely to happen so an English message is OK.
			wxString msg = _T("RebuildSourceText could not create an inputBuffer.\n\nThis may affect the ability of Adapt It to filter or unfilter adjacent markers in correct sequence.");
			wxMessageBox(msg, _T(""), wxICON_WARNING | wxOK);
			gpApp->LogUserAction(msg);
			m_bUsfmStructEnabled = FALSE; // set m_bUsfmStructEnabled to FALSE to disable usfmStruct processing
			return FALSE;
		}
		// At this point we should have a new inputBuffer ready into the 
		// GetUsfmStructureAndExtent(inputBuffer) call below.
	}

	if (fileProcess == createNewFile || fileProcess == recreateExistingFile)
	{
		// This block is executed when creating a new document in OnNewDocument() in non-collaboration
		// scenarios, and when creating a new document or opening an existing document in collaboration
		// scenarios.
		// In this scenario the incoming inputBuffer passed in to this function should already have 
		// the text we can use to input to the GetUsfmStructureAndExtent(inputBuffer) call below.

		// We should ensure the .usfmstruct file doesn't exist because we want to start afresh for a new 
		// usfmstruct file.
		wxLogNull nolog; // avoid spurious messages from the system
		if (::wxFileExists(m_usfmStructFilePathAndName))
		{
			bool bRemoved = FALSE;
			bRemoved = ::wxRemoveFile(m_usfmStructFilePathAndName);
			if (!bRemoved)
			{
				// Not likely to happen, so an English message will suffice.
				wxString msg = _T("Unable to remove existing usfmstruct file at:\n%s");
				msg = msg.Format(msg, m_usfmStructFilePathAndName.c_str());
				gpApp->LogUserAction(msg);
				m_bUsfmStructEnabled = FALSE; // set m_bUsfmStructEnabled to FALSE to disable usfmStruct processing
				return FALSE;
			}
		}
		// At this point we should have an existing inputBuffer that was passed in to this 
		// SetupUsfmStructArrayAndFile() function.
	}

	if (fileProcess == openExistingFile)
	{
		// The openExistingFile is used when AI is opening an existing file in
		// non-collaboration scenarios via the Doc's OnOpenDocument() method. 
		// In this case the inputBuffer will be empty, but there may or may not
		// already be a valid usfmstruct file associated with this document that
		// was created previously. If not, we need to create one using a call to
		// RebuildSourceText(). If a previous and valid usfmstruct file already
		// exists, we can just open it and get our m_UsfmStructArr array filled
		// with the content of the existing usfmstruct file.
		// For some users with documents created before version 6.11.1, their
		// existing documents won't have any usfmstruct file in existence.
		wxLogNull nolog; // avoid spurious messages from the system
		if (!::wxFileExists(m_usfmStructFilePathAndName) || bTextFileNeedsRecreating)
		{
			int textLen;
			textLen = RebuildSourceText(inputBuffer, pList);
			wxUnusedVar(textLen);
			wxASSERT(!inputBuffer.IsEmpty());
			// At this point we should have a new inputBuffer ready to feed into the 
			// GetUsfmStructureAndExtent(inputBuffer) call below.
		}
		else
		{
			// At this point there should be an existing usfmstruct file
		}
	}

	// Now, when opening an existing and valie usfmstruct file we just read the text data via 
	// wxTextFile into the array. Otherwise (when inputBuffer is not empty) we execute the else
	// block below where we call GetUsfmStructureAndExtent(inputBuffer) to create the Doc's 
	// m_UsfmStructArr array and fill the m_UsfmStructStringBuffer string. After
	// GetUsfmStructureAndExtent() is called we then use the m_UsfmStructStringBuffer to write 
	// the data out to the external usfmstruct file.
	if (bReadDataFromExistingUsfmFile && fileProcess == openExistingFile)
	{
		// A usfmstruct file should now exist if it did not already exist, so now we can 
		// open/reopen it and read its data into the m_UsfmStructArr array.
		// The m_UsfmStructArr array and the m_UsfmStructStringBuffer string are then
		// available/active for the life of the current open document.
		wxLogNull nolog; // avoid spurious messages from the system
		wxTextFile textFile(m_usfmStructFilePathAndName);
		bool bOpened = textFile.Open();
		if (!bOpened)
		{
			wxString msg = _T("Failed f.Open() for reading usfmstruct info to %s");
			msg = msg.Format(msg, m_usfmStructFilePathAndName.c_str());
			gpApp->LogUserAction(msg);
			m_bUsfmStructEnabled = FALSE; // set m_bUsfmStructEnabled to FALSE to disable usfmStruct processing
			return FALSE;
		}
		else
		{
			// The testFile exists, is open for reading and has MD5 hash sum data fields, so we can empty 
			// the array and add this file's data to the m_UsfmStructArr array.
			// The Doc's m_UsfmStructArr should be empty
			m_UsfmStructArr.Clear();
			int totLines = textFile.GetLineCount();
			wxString lineStr;
			// Read each line of text and store it into the m_UsfmStructArr wxArrayString on the Doc
			for (int i = 0; i < totLines; i++)
			{
				lineStr = textFile.GetLine(i);
				m_UsfmStructArr.Add(lineStr);
			}
			textFile.Close();
		}
	}
	else if (!inputBuffer.IsEmpty())
	{
		// Call GetUsfmStructureAndExtent(inputBuffer) to create the Doc's m_UsfmStructArr array and 
		// fill the m_UsfmStructStringBuffer string. After GetUsfmStructureAndExtent() is called we 
		// then use the m_UsfmStructStringBuffer to write the data out to the external usfmstruct file.
		// 
		// Note: The wxArrayString m_UsfmStructArr array is on the Doc class, and its contents persist 
		// while a doc is open. 
		// whm 26Mar2024 modified. Call the GetUsfmStructureAndExtent() without the TRUE parameter, 
		// which will result in the m_UsfmStructArr strings having the MD5 hash value - a 32 char 
		// string - being included now as the 3rd colon delimited field for lines stored in the 
		// m_UsfmStructArr array. The filter status is now the 4th field delimited by 3 colons in
		// each line.
		// Each string in the array will now appear as:
		// \mkr:numChars:abcdefghabcdefghabcdefghabcdefgh:0
		// \mkr:numChars:abcdefghabcdefghabcdefghabcdefgh:1
		// \c n:numChars:0:0
		// \v nn:numChars:abcdefghabcdefghabcdefghabcdefgh:0
		// where:
		//  The marker \mkr (and any chapter or verse number) is the marker field (before 1st colon) with
		//    initial backslash, but no following space. \c and \v markers have following space + number.
		//  The numChars field is a number representing the character count of the marker and its assoc text
		//  The abcdefghabcdefghabcdefghabcdefgh represents the 32 char MD5 hash string value of any text
		//     following the marker. For markers like \c nn (and empty content markers) which don't have 
		//     associated text, the MD5 hash value field is just 0
		//  The last field is a 0 or 1 which is the filter status of the marker.
		// In the GetUsfmStructureAndExtent() call below we previously added a TRUE second parameter to 
		// suppress the creation of MD5 hash sum values. But, as of 26Mar2024 we leeave out the 2nd 
		// parameter so that it defaults to a FALSE value which then causes the function to include the 
		// MD5 has sum values in each marker line that goes into the array.
		m_UsfmStructArr = GetUsfmStructureAndExtent(inputBuffer); //m_UsfmStructArr = GetUsfmStructureAndExtent(inputBuffer, TRUE);
		// Get the wxArrayString's lines and save them in the <filename>.usfmstruct file at:
		//.../Adapt It Unicode Work/<project-directory/Adaptations/.usfmstruct/<filename>.usfmstruct
		m_UsfmStructStringBuffer.Empty();
		size_t len = 0;
		// scan our array and determine its required character length including EOL chars
		int totCt = (int)m_UsfmStructArr.GetCount();
		for (int i = 0; i < totCt; i++)
		{
			m_UsfmStructStringBuffer = m_UsfmStructStringBuffer + m_UsfmStructArr.Item(i) + _T("\r\n");
			len += m_UsfmStructArr.Item(i).Length();
			len += 2; // for the EOLs _T("\r\n") to be added
		}

		// Lastsly, write out the data in the m_UsfmStructStringBuffer to the usfmstruct file using
		// a generic wxFile descriptor.
		wxLogNull nolog; // avoid spurious messages from the system
		wxFile file;
		if (!file.Open(m_usfmStructFilePathAndName, wxFile::write))
		{
			wxString msg = _T("Failed f.Open() for writing usfmstruct info to %s");
			msg = msg.Format(msg, m_usfmStructFilePathAndName.c_str());
			gpApp->LogUserAction(msg);
			m_bUsfmStructEnabled = FALSE; // set m_bUsfmStructEnabled to FALSE to disable usfmStruct processing
			return FALSE;
		}
		else
		{
			file.Write(m_UsfmStructStringBuffer, len);
			file.Close();
			// Note: now that the m_UsfmStructStringBuffer data has been written out to the 
			// external usfmstruct file the Doc's populated m_UsfmStructArr array remains in 
			// memory, for use in other parts of the App without having to reopen the usfmstruct file.
		}
	}
	return TRUE;
}

// whm 8Feb2024 verified that this function needs no revision for when the filteredStuff
// input into the function contains swept up markers prefixed to one or more of the
// filtered markers enclosed by \~FILTER ...\~FILTER* brackets. It works well whether
// such swept up markers are present or not.
bool CAdapt_ItDoc::FilteredMaterialContainsMoreThanOneItem(wxString filteredStuff)
{
	// Check whether filteredStuff has more than one filtered item.
	// Each filtered item will be enclosed by \~FILTER ...\~FILTER* bracket markers
	// If there are more than one set of filter bracket markers return TRUE,
	// otherwise return FALSE
	wxString filterStr = filteredStuff;
	int posFilterMarker = -1;
	posFilterMarker = filterStr.Find(_T("\\~FILTER ")); // following space in find string uniquely gets the beginning bracket marker
	if (posFilterMarker != wxNOT_FOUND)
	{
		// Found one, remove it and check for another. If there is at least two markers
		// we can return TRUE, otherwise FALSE
		int posFilterEndMarker = -1;
		posFilterEndMarker = filterStr.Find(_T("\\~FILTER*"));
		int len = (int)filterStr.Length();
		if (posFilterEndMarker != wxNOT_FOUND && len > posFilterEndMarker + 9)
		{
			filterStr = filterStr.Mid(posFilterEndMarker + 9);
			if (filterStr.Find(_T("\\~FILTER ")) != wxNOT_FOUND)
			{
				// We found a second "\\~FILTER " substring, so return TRUE
				return TRUE;
			}
		}
	}
	return FALSE;
}

// whm 10Nov2023 added and revised 8Feb2024. Gets a list of markers and marker info
// contained in 3 parallel arrays from the input string filterStr.
// The filterStr input string should be one or more filtered strings encased with
// \~FILTER ... \~FILTER* brackets that are concatenated together typically coming
// from a m_filteredInfo member (via GetFilteredInfo() call).
// The filterStr string may have preceding markers occurring BEFORE a given filtered
// string enclosed by the filter brackets. These would be one or more markers which 
// are swept up during the filtering process by ReconstituteAfterFilteringChange(),
// and if existing are NOT enclosed within the following \~FILTER ... \~FILTER* 
// string. Any such swept up markers found are stored within the parallel 
// markersPrecedingFilteredOnes array. Even when no such swept up markers exist
// before a filtered string, the markersPrecedingFilteredOnes array item stores an
// empty string for that situation. This is in order to keep all 3 arrays in
// parallel for use by the caller.
// This function makes a call to GetMarkersAndEndMarkersFromString() which returns
// a wxArrayString of markers via the filteredMkrsArray in its third 
// reference parameter. 
// The filtered marker - including its \~FILTER and \~FILTER* brackets - is 
// returned in the filteredMkrsArrayWithFilterBrackets reference parameter.
// The markersPrecedingFilteredOnes() will contain any swept up markers that
// preceed the filtered marker or empty string for any filtered marker that does
// not have preceding swept up markers.
// The filteredMkrsArray array simply contains augmented whole markers. Note
// that are taken from inside the filtered brackets \~FILTER ...\~FILTER*.
// The filteredMkrsArray array doesn't not contain any of the swept up markers 
// that might preceed the filtered material. They go into the 
// markersPrecedingFilteredOnes array instead.
// All 3 arrays returned by reference from this function should always contain
// the same number of elements and are always in parallel.
// This function is called from the ReorderFilterMaterialUsingUsfmStructData()
// function.
// The input string filterStr is expected to contain filtered markers that are
// concatenated into the whole temMkrs string. The filtered markers will be
// embedded within \~FILTER ... \~FILTER* markers. Some of these may be preceded
// by swept up markers that were placed there by the 
// ReconstituteAfterFilteringChange() function or by TokenizeText() during initial 
// parsing of the document.
// We make a temporary copy of the marker that is embedded within the filter
// brackets \~FILTER ... \~FILTER* and look it up using the LookupSFM() function 
// which returns a pAnalysis struct of that marker. For each marker whose 
// pAnalysis->userCanSetFilter is TRUE the function returns it as an item within
// its returned filteredMkrsArray wxArrayString. The parallel arrays then 
// contains any/all filterable markers (and swept up markers) that were found
// returning the three arrays by reference to the caller.
void CAdapt_ItDoc::GetFilteredAndSweptUpMarkersFromString(wxString filterStr, 
	wxArrayString& markersPrecedingFilteredOnes,
	wxArrayString& filteredMkrsArrayWithFilterBrackets,
	wxArrayString& filteredMkrsAndAssocTextNoBrackets,
	wxArrayString& filteredMkrsArray)
{
	markersPrecedingFilteredOnes.Clear();
	filteredMkrsArrayWithFilterBrackets.Clear();
	filteredMkrsAndAssocTextNoBrackets.Clear();
	filteredMkrsArray.Clear();

	if (!filterStr.IsEmpty())
	{
		// Collect all marker(s) found in filterStr, check each marker, and 
		// return only those that are "filterable", that is, those whose 
		// pUsfmAnalysis->userCanSetFilter == TRUE.
		wxArrayString MkrList; 
		wxString endMarkers = _T("");
		// Here below is the revised coding as of 8Feb2024.
		// 
		// Populates 3 parallel wxArrayString arrays from the input string tfilterStrempMkrs which
		// contains mainly filtered markers within filter brackets |~FILTER ...\~FILTER*, 
		// and may contain swept up markers preceding those filtered markers. 
		// The markers are maintained to be parallel wxArrayString arrays.
		// The filterStr string might look something like this (broken up into one filtered 
		// segment per line for easier reading):
		// \~FILTER \ms Jises, iy are lau handru?\~FILTER*
		// \~FILTER \mr (Kalan 11:1-16:20)\~FILTER*
		// \c 11 \~FILTER \s Jon ta alomwa suni oro lau tan ala atou Jises\~FILTER*
		// \~FILTER \r (Luk 7:18-35)\~FILTER*
		//int nLen = filterStr.Length();
		// Break up the filterStr string into filter segments with any swept up markers
		// remaining at the beginning of each filtered segment
		wxString beginFilterBracket = _T("\\~FILTER");
		int posBeginFilterBracket = -1;
		wxString tempFilteredStr;
		wxString tempPreFilteredMkrs;
		wxArrayString segmentsArr;
		// Get the filterStr's filtered "segments". A given segment may now have a swept up
		// marker like \c 11 prefixing the bracketed filtered material.
		segmentsArr = GetFilteredInfoSegments(filterStr);
		int totSegments = (int)segmentsArr.GetCount();

		for (int i = 0; i < totSegments; i++)
		{
			wxString sweptUpStuff;
			tempFilteredStr = segmentsArr.Item(i);
			posBeginFilterBracket = tempFilteredStr.Find(beginFilterBracket);
			if (posBeginFilterBracket > 0)
			{
				// Get any sweptUpStuff from the tempFilteredStr - the stuff BEFORE the beginFilterBracket
				sweptUpStuff = tempFilteredStr.Mid(0, posBeginFilterBracket);
			}
			else
				sweptUpStuff = wxEmptyString;
			markersPrecedingFilteredOnes.Add(sweptUpStuff);
			wxString filteredStrMinusSweptUpStuff;
			filteredStrMinusSweptUpStuff.Empty();
			if (!sweptUpStuff.IsEmpty())
			{
				// There was some sweptUpStuff so remove it then store actual filtered material
				int lenSUS = (int)sweptUpStuff.Length();
				filteredStrMinusSweptUpStuff = tempFilteredStr.Mid(lenSUS);
				filteredMkrsArrayWithFilterBrackets.Add(filteredStrMinusSweptUpStuff);
				filteredMkrsAndAssocTextNoBrackets.Add(RemoveAnyFilterBracketsFromString(filteredStrMinusSweptUpStuff));
			}
			else
			{
				// There was no sweptUpStuff so just store the actual filtered material
				filteredMkrsArrayWithFilterBrackets.Add(tempFilteredStr);
				filteredMkrsAndAssocTextNoBrackets.Add(RemoveAnyFilterBracketsFromString(tempFilteredStr));
				filteredStrMinusSweptUpStuff = tempFilteredStr;
			}
			// Now populate the filteredMkrsArray with just the marker from inside the filtered material
			// now stored in filteredStrMinusSweptUpStuff
			wxString mkr; mkr.Empty();
			mkr = GetMarkerFromWithinOneFilteredString(filteredStrMinusSweptUpStuff);
			filteredMkrsArray.Add(mkr);
		}
		int nCount1 = (int)markersPrecedingFilteredOnes.GetCount();
		int nCount2 = (int)filteredMkrsArrayWithFilterBrackets.GetCount();
		int nCount3 = (int)filteredMkrsArray.GetCount();
		int nCount4 = (int)filteredMkrsAndAssocTextNoBrackets.GetCount();
		wxASSERT(nCount1 == nCount2);
		wxASSERT(nCount2 == nCount3);
		wxASSERT(nCount3 == nCount4);
		int break_here = 1; wxUnusedVar(break_here);
	}
}

// whm 8Feb2024 added. 
// This function gets the marker that is after the augmented begin filter bracket  "\\~FILTER "
// inside the input filteredMkrString that represents ONE filtered string enclosed by 
// \~FILTER ...\~FILTER* markers.
// Note: There should not be any prefixed swept up markers on filteredMkrString.
// This function is called from: GetFilteredAndSweptUpMarkersFromString()
wxString CAdapt_ItDoc::GetMarkerFromWithinOneFilteredString(wxString filteredMkrString)
{
	wxString tempStr = filteredMkrString;
	wxString augBeginFilterBracket = _T("\\~FILTER ");
	wxString backslash = _T("\\");
	wxString space = _T(" ");
	int posFilterBeginBracket = (int)tempStr.Find(augBeginFilterBracket);
	if (posFilterBeginBracket != wxNOT_FOUND)
	{
		tempStr = tempStr.Mid(posFilterBeginBracket + augBeginFilterBracket.Length());
		int posBackslash = tempStr.Find(backslash);
		wxString bareMkr = tempStr.Mid(posBackslash + 1);
		int posSpace = bareMkr.Find(space);
		bareMkr = bareMkr.Mid(0, posSpace);
		// Add the backslash and space back to the bare marker
		tempStr = backslash + bareMkr;
	}
	return tempStr;
}

// whm 20Feb2024 added IsNextFilterableMkrToBeFiltered() for use in the 
// TokenizeText() function - in the outer while (ptr < pEnd) loop between the 
// if (IsWhiteSpace(ptr)) and itemLen = ParseWhiteSpace(ptr) calls.
// This function is called when ptr is pointing at some whitespace in the input
// text. It looks forward in the input text to see if the next filterable marker
// that occurs in the text is currently designated to be filtered. Whitespace and
// certain markers may lie between the whitespace at the ptr and the 
// marker-to-be-filtered which will be the "swept up" stuff. The markers that
// qualify for being "swept up" are restricted to those in the set:
// m_markersCanBeSweptUpByFilteredMarker = _T("\c \p \m \mi \nb \b \ib \ie \po ").
// When scanning for any marker-to-be-filtered, if any marker is encountered that
// is NOT in the above set, the function returns FALSE, and TokenizeText() then
// deals with the material between the space that ptr is pointing at. 
// Hence, this IsNextFilterableMkrToBeFiltered() function only provides a means of
// collecting and parsing over any eligible "swep up stuff" to be prefixed to an
// upcoming marker-to-be-filtered elsewhere within TokenizeText().
// If nothing is availble to be "swept up" this function does nothing and the else
// block parses the whitespace as usual.
// Note: When a chapter marker is encountered, both the \c and followoing chapter 
// number are swept up as would be expected.
// Any non-marker text word(s) encountered or any marker NOT in the set
// _T("\c \p \m \mi \nb \b \ib \ie \po ") - or pEnd - encountered in the forward 
// scanning halts the scanning and returns a FALSE value with empty reference parameters. 
// Getting any existing swept up stuff put into m_filteredInfo, with it prefixed 
// to its following filtered and bracketed marker is important to the proper ordering
// of material in the RebuildSourceText() function.
// Note: While parsing and iterating ptr to check for a following marker to be filtered,
// we may encounter spurious periods that may follow one of the markers in the set
// such as \p ... etc, which are removed as part of the sweeping up process.
// Hence, we need to build any sweptUpStuff piecemeal to allow for skipping of such
// spurious periods.
bool CAdapt_ItDoc::IsNextFilterableMkrToBeFiltered(wxChar* ptr, wxChar* pEnd, 
		wxString& sweptUpStuff, int& nLenSweptUpStuff, bool& sweptStuffInclChOrVs)
{
	sweptStuffInclChOrVs = FALSE;
	wxChar* pAux = ptr;
	int chCount = 0;
	int lenSweptStuff = 0; // a local variable to keep track of length of swept material
	wxString tempSweptUpMaterial; tempSweptUpMaterial.Empty();
	wxString tempStr; tempStr.Empty();
	// When this function is called in TokenizeText() ptr should be pointing
	// at whitespace, so we'll parse the whitespace.
	while (pAux <= pEnd)
	{
		int wsLen = 0;
		wsLen = ParseWhiteSpace(pAux);
		lenSweptStuff += wsLen;
		// Add whitespace to the tempSweptUpMaterial we've parsed over so far
		AppendItem(tempSweptUpMaterial, tempStr, pAux, wsLen);
		pAux += wsLen;
		//int ctVerse = 0; // unused here
		if (IsMarker(pAux))
		{
			// The following initializations are local values since we're just interested here in dealing
			// with any bogus periods and not the bIsEmptyMkr value that IsEmptyMkr() returns.
			bool bHasBogusPeriods = FALSE;
			int nWhitesLenIncludingBogusPeriods = 0; 
			int nPeriodsInWhitesLen = 0;

			// Deal with any spurious periods that might follow our marker. The EsEmptyMkr() function can do this.
			// Here we only use its reference parameter values and not its function return value.
			bool bIsEmptyMkr = IsEmptyMkr(pAux, pEnd, bHasBogusPeriods, nWhitesLenIncludingBogusPeriods, nPeriodsInWhitesLen);
			bIsEmptyMkr = bIsEmptyMkr; // avoid gcc warning
			if (bHasBogusPeriods)
			{
				// There is likely a space between the marker and the bogus periods.
				// We should NOT include this space and NOT include the periods within
				// the tempSweepUpMaterial. However, we add the length of the space
				// to the onPassItemLen
				int whiteSpLen = ParseWhiteSpace(pAux);
				// Here we don't append the whitespace to tempSweptUpMaterial
				pAux += whiteSpLen;
				lenSweptStuff += whiteSpLen;
				int nPeriods = 0;
				IteratePtrPastBogusPeriods(pAux, pEnd, nPeriods); // iterates pAux but not lenSweptStuff
				// Since we are returning to the caller a value for nLenSweptUpStuff which
				// needs to include the length of the periods, even though the actual
				// periods are not included within our returned value for tempSweptUpMaterial.
				// The caller may use the nLenSweptUpStuff to move its ptr value past
				// the tempSweptUpMaterial and periods too. So in this case
				lenSweptStuff += nPeriods;
				whiteSpLen = ParseWhiteSpace(pAux); // this whitespace we add to tempSweptUpMaterial.
				AppendItem(tempSweptUpMaterial, tempStr, pAux, whiteSpLen);
				pAux += whiteSpLen;
				lenSweptStuff += whiteSpLen;
			}
			else
			{
				int whiteSpLen = ParseWhiteSpace(pAux);
				// Append the whitespace to the tempSweptUpMaterial
				AppendItem(tempSweptUpMaterial, tempStr, pAux, whiteSpLen);
				pAux += whiteSpLen;
				lenSweptStuff += whiteSpLen;
			}

			int lenMkr = 0;
			lenMkr = ParseMarker(pAux);
			// Don't increment lenSweptStuff here, but below in the next if () test.
			// We don't know if this marker will be stored in tempSweptUpMaterial until we
			// determine that is it a member of the m_markersCanBeSweptUpByFilteredMarker set.
			// We also delay the AppendItem(tempSweptUpMaterial, tempStr, pAux, lenSweptStuff) 
			// call to the TRUE block below.
			wxString augWholeMkr = wxString(pAux, lenMkr);
			augWholeMkr += _T(" ");
			if (gpApp->m_markersCanBeSweptUpByFilteredMarker.Find(augWholeMkr) != wxNOT_FOUND)
			{
				// It's in our m_markersCanBeSweptUpByFilteredMarker marker set.
				// We parsed the marker intially above to get an augWholeMkr value
				// but we didn't increment pAux or lenSweptStuff there. Since we now
				// know we have a potential swept up marker, parse the marker again 
				// here and this time we increment pAux, lenSweptStuff, and add any 
				// tempSweptUpMaterial.
				// Check if we have a chapter marker.
				if (IsChapterMarker(pAux))
				{
					sweptStuffInclChOrVs = TRUE; // return flag value via ref param
					// Count the number of chapter markers we encountered and return
					// FALSE if this is a second chapter marker.
					chCount++;
					if (chCount > 1)
					{
						// We've encountered a second chapter marker, so we abort the
						// scan and return FALSE to let TokenizeText() deal with what
						// we saw up to this point - including the initial chapter 
						// marker we encountered.
						sweptStuffInclChOrVs = FALSE; // return flag value via ref param
						sweptUpStuff.Empty();
						nLenSweptUpStuff = 0;
						return FALSE;
					}
					// If we get here we parse the chapter marker, space and following number
					int lenCh = 0;
					lenCh = ParseMarker(pAux);
					// Append the marker to the tempSweptUpMaterial
					lenSweptStuff += lenCh;
					AppendItem(tempSweptUpMaterial, tempStr, pAux, lenCh);
					pAux += lenCh;
					// Parse the space and following number.
					lenCh = ParseWhiteSpace(pAux);
					lenSweptStuff += lenCh;
					AppendItem(tempSweptUpMaterial, tempStr, pAux, lenCh);
					pAux += lenCh;
					// parse the following number and increment
					lenCh = ParseNumber(pAux);
					lenSweptStuff += lenCh;
					AppendItem(tempSweptUpMaterial, tempStr, pAux, lenCh);
					pAux += lenCh;
					// Any following whitespace is caught at top of while loop
				}
				else
				{
					// It's one of the other non-chapter markers in the set
					// Parse the whitespace following the marker
					int wsLen = 0;
					wsLen = ParseMarker(pAux);
					lenSweptStuff += wsLen;
					// Append the marker to the tempSweptUpMaterial
					AppendItem(tempSweptUpMaterial, tempStr, pAux, wsLen);
					pAux += wsLen;
					wsLen = ParseWhiteSpace(pAux);
					lenSweptStuff += wsLen;
					AppendItem(tempSweptUpMaterial, tempStr, pAux, wsLen);
					pAux += wsLen;
					// The marker at this point is a member of the set and will be part of any 
					// swept up aterial, but only as long as it is actually followed by a marker
					// that is to-be-filtered, otherwise this function returns FALSE and 
					// TokenizeText() will put it into the current source phrase's member.
				}
			}
			else if (gpApp->gCurrentFilterMarkers.Find(augWholeMkr) != wxNOT_FOUND)
			{
				// The marker we're pointing at is a marker designated to be filtered
				// We don't parse it here but the caller will do it; here we just set
				// the return bool to TRUE.
				// This marker is NOT to be included within the swept up material. Instead
				// the caller will deal with filtering it.
				sweptUpStuff = tempSweptUpMaterial;
				nLenSweptUpStuff = lenSweptStuff;
				// Note: It is up to the caller in TokenizeText() to advance ptr past the 
				// sweptUpStuff by using the returned nLenSweptUpStuff.
				return TRUE;
			}
			else
			{
				// It's some other marker which stops our scan and returns FALSE.
				sweptUpStuff.Empty();
				nLenSweptUpStuff = 0;
				return FALSE;
			}
		}
		else
		{
			// What follows the whitespace is non-marker material so just return FALSE.
			sweptUpStuff.Empty();
			nLenSweptUpStuff = 0;
			return FALSE;
		}

		/*
		if (IsChapterMarker(pAux) || IsVerseMarker(pAux, ctVerse))
		{
			// When this block is first entered sweptStuffInclChOrVs will be FALSE
			// We don's want more than one chapter or verse marker in the same
			// swept up stuff, so if sweptStuffInclChOrVs is already TRUE at this
			// point in this block, we should return what swept up stuff we have
			// detected so far even before we determine whether the next marker is
			// to be filtered ot not. So, if pAux is not pointing at a second instance
			// of a chapter or verse marker we return FALSE for the function, but we
			// leave boolean flag sweptStuffInclChOrVs parameter set to TRUE.
			if (sweptStuffInclChOrVs == TRUE)
			{
				return FALSE;
			}
			// If control gets here this is the first instance seen of a chqapter or
			// verse marker, so parse the marker and keep scanning.
			int lenChVs = 0;
			lenChVs = ParseMarker(pAux);
			lenSweptStuff += lenChVs;
			AppendItem(tempSweptUpMaterial, tempStr, pAux, lenChVs);
			pAux += lenChVs;
			lenChVs = ParseWhiteSpace(pAux);
			lenSweptStuff += lenChVs;
			AppendItem(tempSweptUpMaterial, tempStr, pAux, lenChVs);
			pAux += lenChVs;
			// parse the following number and increment
			lenChVs = ParseNumber(pAux);
			lenSweptStuff += lenChVs;
			AppendItem(tempSweptUpMaterial, tempStr, pAux, lenChVs);
			pAux += lenChVs;
			// A chapter or verse marker is probably followed by whitespace so parse that too
			lenChVs = ParseWhiteSpace(pAux);
			lenSweptStuff += lenChVs;
			AppendItem(tempSweptUpMaterial, tempStr, pAux, lenChVs);
			pAux += lenChVs;
			sweptStuffInclChOrVs = TRUE;
		}
		else if (IsMarker(pAux))
		{
			int lenMkr = 0;
			lenMkr = ParseMarker(pAux);
			// Don't increment lenSweptStuff here, but below in the while loop
			// We don't know if this marker will be stored in tempSweptUpMaterial until we
			// determine that both of these conditions are TRUE:
			// 1. It IS NOT a marker-to-be-filtered, and 
			// 2. It IS an empty marker
			// Hence, we delay the AppendItem(tempSweptUpMaterial, tempStr, pAux, lenSweptStuff) 
			// call to the IsEmptyMkr() TRUE block below.
			wxString augWholeMkr = wxString(pAux, lenMkr);
			augWholeMkr += _T(" ");
			if (gpApp->gCurrentFilterMarkers.Find(augWholeMkr) != wxNOT_FOUND)
			{
				// The marker we're pointing at is a marker designated to be filtered
				// We don't parse it here but the caller will do it; here we just set
				// the return bool to TRUE.
				bFoundMkrToBeFiltered = TRUE;
				// This marker is NOT to be included within the swept up material. Instead
				// the caller will deal with filtering it.
				break; // No need to go further beyond this marker
			}
			else
			{
				// pAux is pointing at some kind of not-to-be filtered marker and NOT at 
				// whitespace at this point.
				// There could be one or more contentless markers preceding a marker
				// currently being filtered. If so they should also be swept up here.
				bool bHasBogusPeriods = FALSE;
				int nWhitesLenIncludingBogusPeriods = 0;
				int nPeriodsInWhitesLen = 0;
				int accumItemLen = 0; // accumulate item len value for pass through while loop
				//wxString tempSweptUpMaterial; tempSweptUpMaterial.Empty();
				wxChar* tempAux = pAux; // preserve pAux for use after the while loop below
				bool bIsEmptyMkr = IsEmptyMkr(tempAux, pEnd, bHasBogusPeriods, nWhitesLenIncludingBogusPeriods, nPeriodsInWhitesLen);
				while (bIsEmptyMkr && tempAux < pEnd)
				{
					// We parsed the marker intially above to get an augWholeMkr value
					// but we didn't increment pAux or lenSweptStuff there. Since we are now
					// within a while loop, parse the marker again here and this time we
					// increment pAux, lenSweptStuff, and add any tempSweptUpMaterial.
					int onePassItemLen = 0;
					onePassItemLen = ParseMarker(tempAux);
					// Append the marker to the tempSweptUpMaterial
					AppendItem(tempSweptUpMaterial, tempStr, tempAux, onePassItemLen);
					wxString augWholeMkr = wxString(tempAux, onePassItemLen);
					augWholeMkr += _T(" ");
					tempAux += onePassItemLen;
					// A contentless marker could be a marker like \p \m and other markers
					// that are not followed by non-marker text. These will be part of any
					// swept up material, but only as long as they are actually followed by
					// a marker that is currently being filtered - otherwise TokenizeText()
					// will put them into the current source phrase's m_markers member.
					// Deal with any spurious periods 
					if (bHasBogusPeriods)
					{
						// There is likely a space between the marker and the bogus periods.
						// We should NOT include this space and NOT include the periods within
						// the tempSweepUpMaterial. However, we add the length of the space
						// to the onPassItemLen
						int whiteSpLen = ParseWhiteSpace(tempAux);
						// Here we don't append the whitespace to tempSweptUpMaterial
						tempAux += whiteSpLen;
						onePassItemLen += whiteSpLen;
						int nPeriods = 0;
						IteratePtrPastBogusPeriods(tempAux, pEnd, nPeriods); // iterates pAux but not lenSweptStuff
						// Since we are returning to the caller a value for nLenSweptUpStuff which
						// needs to include the length of the periods, even though the actual
						// periods are not included within our returned value for sweptUpStuff.
						// The caller may use the nLenSweptUpStuff to move its ptr value past
						// the sweptUpStuff and periods too. So in this case
						onePassItemLen += nPeriods;
						whiteSpLen = ParseWhiteSpace(tempAux); // this whitespace we add to tempSweptUpMaterial.
						AppendItem(tempSweptUpMaterial, tempStr, tempAux, whiteSpLen);
						tempAux += whiteSpLen;
						onePassItemLen += whiteSpLen;
					}
					else
					{
						int whiteSpLen = ParseWhiteSpace(tempAux);
						// Append the whitespace to the tempSweptUpMaterial
						AppendItem(tempSweptUpMaterial, tempStr, tempAux, whiteSpLen);
						tempAux += whiteSpLen;
						onePassItemLen += whiteSpLen;
					}
					// Is this marker one to be filtered? If so we're done. If not we continue
					// with the while loop iteration.
					if (gpApp->gCurrentFilterMarkers.Find(augWholeMkr) != wxNOT_FOUND)
					{
						// The marker we're pointing at is a marker designated to be filtered
						// We don't parse it here but the caller will do it; here we just set
						// the return bool to TRUE.
						bFoundMkrToBeFiltered = TRUE;
						// This marker is NOT to be included within the swept up material. Instead
						// the caller will deal with filtering it.
						break; // No need to go further beyond this marker
					}
					// If we get here the augWholeMkr above was not to be filtered, so we 
					// continue to iterate
					// The pAux pointer is now pointing past any whitespace that followed
					// the augWholeMkr above - could be another marker or non-marker text.
					accumItemLen += onePassItemLen;
					bIsEmptyMkr = IsEmptyMkr(tempAux, pEnd, bHasBogusPeriods, nWhitesLenIncludingBogusPeriods, nPeriodsInWhitesLen);
				} // end of while (IsEmptyMkr(tempAux, pEnd, bHasBogusPeriods, nWhitesLenIncludingBogusPeriods, nPeriodsInWhitesLen))
				int mkrLen = ParseMarker(tempAux); // The marker at tempAux is not empty, so we don't add it to the tempSweptUpMaterial
				wxString augmkr = wxString(tempAux, mkrLen);
				augmkr += _T(" ");
				if (gpApp->gCurrentFilterMarkers.Find(augmkr) != wxNOT_FOUND)
				{
					bFoundMkrToBeFiltered = TRUE;
					pAux += accumItemLen; // move pAux to point past the marker at tempAux
					lenSweptStuff += accumItemLen; // add the accumItemLen but not the mkrLen
					break; // since the marker at tempAux is not an empty marker we can break out of the while loop

				}
				else
				{
					pAux += accumItemLen; // move pAux to point past the marker at tempAux
					lenSweptStuff += accumItemLen; // add the accumItemLen but not the mkrLen
					break; 
				}
			}
		}
		else
		{
			// what follows the whitespace is non-marker material so just return FALSE
			bFoundMkrToBeFiltered = FALSE;
			return FALSE;
		}
		*/
	} // end of while (pAux <= pEnd)

	// If we get here we probably got to the end of the file
	// so set ref parameters to not-found situation and return FALSE
	sweptUpStuff.Empty();
	nLenSweptUpStuff = 0;
	return 	FALSE;
}

void CAdapt_ItDoc::RestoreCurrentDocVersion()
{
	m_docVersionCurrent = (int)VERSION_NUMBER; // VERSION_NUMBER is #defined in AdaptitConstants.h
}

void CAdapt_ItDoc::SetDocVersion(int index)
{
	switch (index)
	{
	default: // default to the current doc version number, fall thru
	{
	}
	case 0:
	{
		m_docVersionCurrent = (int)VERSION_NUMBER; // currently #defined as 9 in AdaptitConstant.h
		break;
	}
	case 1:
	{
		m_docVersionCurrent = (int)DOCVERSION4;  // #defined as 4 in AdaptitConstants.h
		break;
	}
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \return a CBString composed of settings info formatted as XML.
/// \param	nTabLevel	-> defines how many indenting tab characters are placed before each
///			               constructed XML line; 1 gives one tab, 2 gives two, etc.
/// Called by the Doc's BackupDocument(), DoFileSave(), and DoTransformedDocFileSave()
/// functions. Creates a CBString that contains the XML prologue and settings information
/// formatted as XML.
/// BEW 27Feb12, added the ftsbp attribute to store the m_bDefineFreeTransByPunctuation
/// boolean value, as per the user's last choice for "Verse" or "Punctuation" sectioning
/// prior to the last save of the doc in the current session
///////////////////////////////////////////////////////////////////////////////

CBString CAdapt_ItDoc::ConstructSettingsInfoAsXML(int nTabLevel)
{
	CBString	bstr;  bstr.Empty();
	CBString	btemp;
	int			i, commitCount;
	wxString	tempStr;
	// wx note: the wx version in Unicode build refuses to assign a CBString to char
	// numStr[24] so I'll declare numStr as a CBString also
	CBString	numStr; //char numStr[24];

#ifdef _UNICODE

	// first line -- element name and 4 attributes
	for (i = 0; i < nTabLevel; i++)
	{
		bstr += "\t"; // tab the start of the line
	}
	bstr += "<Settings docVersion=\"";
	// wx note: The itoa() operator is Microsoft specific and not standard; unknown to g++
	// on Linux/Mac. The wxSprintf() statement below in Unicode build won't accept CBString
	// or char numStr[24] for first parameter, therefore, I'll simply do the int to string
	// conversion in UTF-16 with wxString's overloaded insertion operatior << then convert
	// to UTF-8 with Bruce's Convert16to8() method. [We could also do it here directly with
	// wxWidgets' conversion macros rather than calling Convert16to8() - see the
	// Convert16to8() function in the App.]
	tempStr.Empty();
	// BEW 19Apr10, changed next line for support of Save As... command
	tempStr << GetCurrentDocVersion(); // tempStr is UTF-16
	numStr = gpApp->Convert16to8(tempStr);
	bstr += numStr; // add versionable schema number string

	// BEW 9Aug12 addition: support saving the content of wxString m_bookName_Current, it
	// could be empty, or some book name from the Paratext list, or a custom user-defined
	// name (possibly in a vernacular); this addition is part of the docVersion7 additions
	tempStr = gpApp->m_bookName_Current; // could be an empty string
	btemp = gpApp->Convert16to8(tempStr);
	InsertEntities(btemp); // escape any xml metacharacters
	bstr += "\" bookName=\"";
	bstr += btemp; // add the book name
	tempStr.Empty();

	// mrh - new fields with docVersion 7:
	btemp = gpApp->Convert16to8(gpApp->m_owner);
	InsertEntities(btemp);				// ensure any XML metacharacters in the owner name are escaped properly
	bstr += "\" owner=\"";
	bstr += btemp; // add owner name

	tempStr.Empty();
	commitCount = gpApp->m_commitCount;
	if (commitCount < 0)
		tempStr << NOOWNER;				// this doc isn't under version control
	else
		tempStr << commitCount;			// this many commits have been done
	numStr = gpApp->Convert16to8(tempStr);

	bstr += "\" ";
	bstr += xml_commitcnt;
	bstr += "=\"";
	bstr += numStr;						// add the commit count

	if (gpApp->m_versionDate.IsValid())
		numStr = gpApp->Convert16to8(gpApp->m_versionDate.Format(_T("%Y-%m-%d %H:%M:%S")));
	// %T gives an error on Windows, so we have to spell it out!
	else
		numStr = "";
	bstr += "\" revdate=\"";
	bstr += numStr;	// add revision date, empty if we don't have one

// mrh - new field with docVersion 8 - we save m_nActiveSequNum:
	tempStr.Empty();
	tempStr << gpApp->m_nActiveSequNum;	// "<<" handles num->wxString conversion
	numStr = gpApp->Convert16to8(tempStr);

	bstr += "\" ";
	bstr += xml_activeSequNum;
	bstr += "=\"";
	bstr += numStr;						// add the active sequence number

// now we add the doc's width and height - currently I don't think we use these on input, but may sometime.
	tempStr.Empty();
	tempStr << gpApp->m_docSize.x;
	numStr = gpApp->Convert16to8(tempStr);

	bstr += "\" ";
	bstr += xml_sizex;
	bstr += "=\"";
	bstr += numStr;						// add the doc width

	tempStr.Empty();
	tempStr << gpApp->m_docSize.y;
	numStr = gpApp->Convert16to8(tempStr);

	bstr += "\" ";
	bstr += xml_sizey;
	bstr += "=\"";
	bstr += numStr;						// add the doc height

	// BEW added 27Feb12, for docV6 support; but if m_bLegacyDocVersionForSaveAs is TRUE,
	// then skip this docV6 attribute's construction
	if (!m_bLegacyDocVersionForSaveAs)
	{
		// we aren't constructing a docV4 legacy document from a File / SaveAs... user choice
		tempStr.Empty(); // needs to start empty, otherwise << will append the string value of the int
		// BEW 20Oct14, if force verse sectioning is currently on, then ensure that
		// 'verse' sectioning is in effect at doc save time
		if (gpApp->m_bForceVerseSectioning)
		{
			// get m_bDefineFreeTransByPunction forced to value FALSE, and radio buttons
			// synced to that value if free trans mode is in effect currently
			gpApp->GetFreeTrans()->ForceVerseSectioning();
		}
		if (gpApp->m_bDefineFreeTransByPunctuation)
		{
			tempStr << (int)1;
		}
		else
		{
			tempStr << (int)0;
		}
		bstr += "\" ftsbp=\"";
		numStr = gpApp->Convert16to8(tempStr);
		bstr += numStr;
	}

	bstr += "\" specialcolor=\"";
	tempStr.Empty(); // needs to start empty, otherwise << will append the string value of the int
	tempStr << WxColour2Int(gpApp->m_specialTextColor);
	numStr = gpApp->Convert16to8(tempStr);
	bstr += numStr; // add specialText color number string
	bstr += "\"\r\n";

	// second line -- 5 attributes
	for (i = 0; i < nTabLevel; i++)
	{
		bstr += "\t"; // tab the start of the line
	}
	bstr += "retranscolor=\"";
	tempStr.Empty(); // needs to start empty, otherwise << will append the string value of the int
	tempStr << WxColour2Int(gpApp->m_reTranslnTextColor);
	numStr = gpApp->Convert16to8(tempStr);
	bstr += numStr; // add retranslation text color number string
	bstr += "\" navcolor=\"";
	tempStr.Empty(); // needs to start empty, otherwise << will append the string value of the int
	tempStr << WxColour2Int(gpApp->m_navTextColor);
	numStr = gpApp->Convert16to8(tempStr);
	bstr += numStr; // add navigation text color number string
	bstr += "\" curchap=\"";
	btemp = gpApp->Convert16to8(gpApp->m_curChapter);
	bstr += btemp; // add current chapter text color number string (app makes no use of this)
	bstr += "\" srcname=\"";
	btemp = gpApp->Convert16to8(gpApp->m_sourceName);
	bstr += btemp; // add name of source text's language
	bstr += "\" tgtname=\"";
	btemp = gpApp->Convert16to8(gpApp->m_targetName);
	bstr += btemp; // add name of target text's language

// mrh June 2012 - new fields for docVersion 7:
	if (gpApp->m_sourceLanguageCode.IsEmpty())
		gpApp->m_sourceLanguageCode = NOCODE;
	if (gpApp->m_targetLanguageCode.IsEmpty())
		gpApp->m_targetLanguageCode = NOCODE;		// ensure we output something
	bstr += "\" ";
	bstr += xml_srccode;
	btemp = gpApp->Convert16to8(gpApp->m_sourceLanguageCode);		// source language code
	bstr += "=\"";
	bstr += btemp;

	bstr += "\" ";
	bstr += xml_tgtcode;
	btemp = gpApp->Convert16to8(gpApp->m_targetLanguageCode);		// target language code
	bstr += "=\"";
	bstr += btemp;

	bstr += "\"\r\n"; // TODO: EOL chars need adjustment for Linux and Mac???

	// third line - one attribute (potentially large, containing unix strings with filter markers,
	// unknown markers, etc -- entities should not be needed for it though)
	for (i = 0; i < nTabLevel; i++)
	{
		bstr += "\t"; // tab the start of the line
	}
	bstr += "others=\"";
	btemp = gpApp->Convert16to8(SetupBufferForOutput(gpApp->m_pBuffer));
	bstr += btemp; // all all the unix string materials (could be a lot)
	bstr += "\"/>\r\n"; // TODO: EOL chars need adjustment for Linux and Mac??
	return bstr;

#else // non-Unicode version

	// first line -- element name and 4 attributes
	for (i = 0; i < nTabLevel; i++)
	{
		bstr += "\t"; // tab the start of the line
	}
	bstr += "<Settings docVersion=\"";
	// wx note: The itoa() operator is Microsoft specific and not standard; unknown to g++ on Linux/Mac.
	// The use of wxSprintf() below seems to work OK in ANSI builds, but I'll use the << insertion
	// operator here as I did in the Unicode build block above, so the code below should be the same
	// as that for the Unicode version except for the Unicode version's use of Convert16to8().
	tempStr.Empty(); // needs to start empty, otherwise << will append the string value of the int
	// BEW 19Apr10, changed next line for support of Save As... command
	tempStr << GetCurrentDocVersion();
	numStr = tempStr;
	bstr += numStr; // add versionable schema number string

// mrh - new fields with docVersion 7:
	btemp = gpApp->m_owner;				// no unicode conversion needed
	InsertEntities(btemp);				// ensure any XML metacharacters in the owner name are escaped properly
	bstr += "\" owner=\"" + btemp;		// add owner name

	tempStr.Empty();
	commitCount = gpApp->m_commitCount;
	if (commitCount < 0)
		tempStr << NOOWNER;			// this doc isn't under version control
	else
		tempStr << commitCount;			// this many commits have been done

	bstr += "\" commitcnt=\"" + tempStr;	// add commit count, without unicode conversion needed

	if (gpApp->m_versionDate.IsValid())
		numStr = gpApp->m_versionDate.Format(_T("%Y-%m-%d %H:%M:%S"));	// without unicode conversion
	else
		numStr = "";
	bstr += "\" revdate=\"" + numStr;	// add revision date, empty if we don't have one

	// now we add the doc's width and height - currently I don't think we use these on input, but may sometime.
	tempStr.Empty();
	tempStr << gpApp->m_docSize.x;
	numStr = tempStr;

	bstr += "\" ";
	bstr += xml_sizex;
	bstr += "=\"";
	bstr += numStr;						// add the doc width

	tempStr.Empty();
	tempStr << gpApp->m_docSize.y;
	numStr = tempStr;

	bstr += "\" ";
	bstr += xml_sizey;
	bstr += "=\"";
	bstr += numStr;						// add the doc height



	bstr += "\" specialcolor=\"";
	tempStr.Empty(); // needs to start empty, otherwise << will append the string value of the int
	tempStr << WxColour2Int(gpApp->m_specialTextColor);
	numStr = tempStr;
	bstr += numStr; // add specialText color number string
	bstr += "\"\r\n"; // TODO: EOL chars need adjustment for Linux and Mac??

	// second line -- 5 attributes
	for (i = 0; i < nTabLevel; i++)
	{
		bstr += "\t"; // tab the start of the line
	}
	bstr += "retranscolor=\"";
	tempStr.Empty(); // needs to start empty, otherwise << will append the string value of the int
	tempStr << WxColour2Int(gpApp->m_reTranslnTextColor);
	numStr = tempStr;
	bstr += numStr; // add retranslation text color number string
	bstr += "\" navcolor=\"";
	tempStr.Empty(); // needs to start empty, otherwise << will append the string value of the int
	tempStr << WxColour2Int(gpApp->m_navTextColor);
	numStr = tempStr;
	bstr += numStr; // add navigation text color number string
	bstr += "\" curchap=\"";
	btemp = gpApp->m_curChapter;
	bstr += btemp; // add current chapter text color number string (app makes no use of this)
	bstr += "\" srcname=\"";
	btemp = gpApp->m_sourceName;
	bstr += btemp; // add name of source text's language
	bstr += "\" tgtname=\"";
	btemp = gpApp->m_targetName;
	bstr += btemp; // add name of target text's language

	// mrh June 2012 - new fields for docVersion 7:
	bstr += "\" ";
	bstr += xml_srccode;
	btemp = gpApp->m_sourceLanguageCode;		// source language code
	bstr += "=\"" + btemp;

	bstr += "\" ";
	bstr += xml_tgtcode;
	btemp = gpApp->m_targetLanguageCode;		// target language code
	bstr += "=\"" + btemp;

	bstr += "\"\r\n"; // TODO: EOL chars need adjustment for Linux and Mac??

	// third line - one attribute (potentially large, containing unix strings with filter markers,
	// unknown markers, etc -- entities should not be needed for it though)
	for (i = 0; i < nTabLevel; i++)
	{
		bstr += "\t"; // tab the start of the line
	}
	bstr += "others=\"";
	btemp = SetupBufferForOutput(gpApp->m_pBuffer);
	bstr += btemp; // add all the unix string materials (could be a lot)
	bstr += "\"/>\r\n"; // TODO: EOL chars need adjustment for Linux and Mac??
	return bstr;
#endif
}

///////////////////////////////////////////////////////////////////////////////
/// \return nothing
/// \param	buffer	-> a wxString formatted into delimited fields containing the book mode,
///						the book index, the current sfm set, a list of the filtered markers,
///						and a list of the unknown markers
/// \remarks
/// Called from: the AtDocAttr() in XML.cpp.
/// RestoreDocParamsOnInput parses the buffer string and uses its stored information to
/// update the variables held on the App that hold the corresponding information.
///////////////////////////////////////////////////////////////////////////////
void CAdapt_ItDoc::RestoreDocParamsOnInput(wxString buffer)
{
	int dataLen = buffer.Length();
	// This function encapsulates code which formerly was in the Serialize() function, but
	// now that version 3 allows xml i/o, we need this functionality for both binary input
	// and for xml input. For version 2.3.0 and onwards, we don't store the source text in
	// the document so when reading in a document produced from earlier versions, we change
	// the contents of the buffer to a space so that a subsequent save will give a smaller
	// file; recent changes to use this member for serializing in/out the book mode
	// information which is needed for safe use of the MRU list, mean that we might have
	// that info read in, or it could be a legacy document's source text data. We can
	// distinguish these by the fact that the book mode information will be a string of 3,
	// 4 at most, characters followed by a null byte and EOF; whereas a valid legacy doc's
	// source text will be much much longer [see more comments within the function].
	// whm revised 6Jul05
	// We have to account for three uses of the wxString buffer here:
	// 1. Legacy use in which the buffer contained the entire source text.
	//    In this case we simply ignore the text and overwrite it with a space
	// 2. The extended app version in which only the first 3 or 4 characters were
	//    used to store the m_bBookMode and m_nBookIndex values.
	//    In this case the length of buffer string will be < 5 characters, and we handle
	//    the parsing of the book mode and book index as did the extended app.
	// 3. The current version 3 app which adds a unique identifier @#@#: to the beginning
	//    of the string buffer, then follows this by colon delimited fields concatenated in
	//    the buffer string to represent config data.
	//    In this case we verify we have version 3 structure by presence of the @#@#: initial
	//    5 characters, then parse the string like a unix data string. The book mode and book
	//    index will be the first two fields, followed by version 3 specific config values.
	// Note: The gCurrentSfmSet is always changed to be the same as was last saved in the
	// document. The gCurrentFilterMarkers is also always changed to be the same as way
	// last saved in the document. To ensure that the current settings in the active
	// USFMAnalysis structs are in agreement with what was last saved in the document we
	// call ResetUSFMFilterStructs().
	//
	// BEW modified 09Nov05 as follows:
	// The current value for the Book Folder mode (True or False), and the current book
	// index (-1 if book mode is not currently on) have to be made to override the values
	// saved in the document if different than what is in the document - but only provided
	// the project is still the same one as the project under which the document was last
	// saved. The reason is as follows. Suppose book mode is off, and you save the document
	// - it goes into the Adaptations folder. Now suppose you use turn book mode on and use
	// the enabled Move command to move the document to the oppropriate book folder. The
	// document is now in a book folder, but internally it still contains the information
	// that it was saved with book mode off, and so no book index is stored there either
	// but just a -1 value. If you then, from within the Start Working wizard open the
	// moved document, the RestoreDocParamsOnInput() function would, unless modified to not
	// do so, restore book mode to off, and set the book index to -1 (whether for an XML
	// file read, or a binary one). This is not what we want or expect. We must also check
	// that the project is unchanged, because the user has the option of opening an
	// arbitary recent document from any project by clicking its name in the MRU list, and
	// the stored source and target language names and book mode info is then used to set
	// up the right path to the document and work out what its project was and make that
	// project the current one -- when you do this, it would be most unlikely that that
	// document was saved after a Move and you did not then open it but changed to the
	// current project, so in this case the book mode and book index as stored in the
	// document SHOULD be used (ie. potentially can reset the mode and change the book
	// index) so that you are returning to the most likely former state. There is no way to
	// detect that the former project's document was moved without being opened within the
	// project, so if the current mode differs, then the constructed path would not be
	// valid and Adapt It will not do the file read -- but this failure is detected and the
	// user is told the document probably no longer exists and is then put into the Start
	// Working wizard -- where he can then turn the mode back on (or off) and locate the
	// document and open it safely and continue working, so the MRU open will not lead to a
	// crash even if the above very unlikely scenario obtains. But if the doc was opened in
	// the earlier project, then using the saved book mode and index values as described
	// above will indeed find it successfully. So, in summary, if the project is different,
	// we must use the stored info in the doc, but if the project is unchanged, then we
	// must override the info in the doc because the fact that it was just opened means
	// that we got it from whatever folder is consistent with the current mode (ie.
	// Adaptations if book folder mode is off, a book folder if it is on) and so the
	// current setting is what we must go with. Whew!! Hope you cotton on to all this!
	wxString curSourceName; // can't use app's m_sourceName & m_targetName because these will already be
	wxString curTargetName; // overwritten so we set curSourceName and curTargetName
				// by extracting the names from the app's m_curProjectName member which
				// doesn't get updated until the doc read has been successfully completed
	gpApp->GetSrcAndTgtLanguageNamesFromProjectName(gpApp->m_curProjectName, curSourceName, curTargetName);
	bool bSameProject = (curSourceName == gpApp->m_sourceName) && (curTargetName == gpApp->m_targetName);
	// BEW added 27Nov05 to keep settings straight when doc may have been pasted here in
	// Win Explorer but was created and stored in another project

	// whm 1Oct12 removed  && !gbTryingMRUOpen test from if block below
	if (!bSameProject)
	{
		// bSameProject being FALSE may be because we opened a doc created and saved in a
		// different project and it was a legacy *adt doc and so m_sourceName and
		// m_targetName will have been set wrongly, so we override the document's stored
		// values in favour of curSourceName and curTargetName which we know to be correct
		gpApp->m_sourceName = curSourceName;
		gpApp->m_targetName = curTargetName;
	}

	bool bVersion3Data;
	wxString strFilterMarkersSavedInDoc; // inventory of filtered markers read from the Doc's Buffer

	// initialize strFilterMarkersSavedInDoc to the App's gCurrentFilterMarkers
	strFilterMarkersSavedInDoc = gpApp->gCurrentFilterMarkers;

	// initialize SetSavedInDoc to the App's gCurrentSfmSet
	// Note: The App's Get proj config routine may change the gCurrentSfmSet to PngOnly
	enum SfmSet SetSavedInDoc = gpApp->gCurrentSfmSet;

	// check for version 3 special buffer prefix
	bVersion3Data = (buffer.Find(_T("@#@#:")) == 0);
	wxString field;
	if (bVersion3Data)
	{
		// case 3 above
		// assume we have book mode and index information followed by version 3 data
		//int curPos; // unused
		//curPos = 0;
		int fieldNum = 0;

		// Ensure that first token is _T("@#@#");
		wxASSERT(buffer.Find(_T("@#@#:")) == 0);

		wxStringTokenizer tkz(buffer, _T(":"), wxTOKEN_RET_EMPTY_ALL);

		while (tkz.HasMoreTokens())
		{
			field = tkz.GetNextToken();
			switch (fieldNum)
			{
			case 0: // this is the first field which should be "@#@#" - we don't do anything with it
			{
				break;
			}
			case 1: // book mode field
			{
				// whm 1Oct12 removed MRU related code
				/*
				// BEW modified 27Nov05 to only use the T or F values when doing an MRU
				// open; since for an Open done by a wizard selection in the Document
				// page, the doc is accessed either in Adaptations folder or a book
				// folder, and so we must go with whichever mode was the case when we
				// did that (m_bBookMode false for the former, true for the latter) and
				// we certainly don't want the document to be able to set different
				// values (which it could do if it was a foreign document just copied
				// into a folder and we are opening it on our computer for the first
				// time). I think the bSameProject value is not needed actually, an MRU
				// open requires we try using what's on the doc, and an ordinary wizard
				// open requires us to ignore what's on the doc.
				if (gbTryingMRUOpen)
				{
					// let the app's current setting stand except when an MRU open is tried
					if (field == _T("T"))
					{
						gpApp->m_bBookMode = TRUE;
					}
					else if (field == _T("F"))
					{
						gpApp->m_bBookMode = FALSE;
					}
					else
						goto t;
				}
				*/
				break;
			} // end of case 1:
			case 2: // book index field
			{
				// whm 1Oct12 removed MRU related code
				/*
				// see comments above about MRU
				if (gbTryingMRUOpen)
				{
					// let the app's current setting stand except when an MRU open is tried
					// use the file's saved index setting
					int i = wxAtoi(field);
					gpApp->m_nBookIndex = i;
					if (i >= 0  && !gpApp->m_bDisableBookMode)
					{
						gpApp->m_pCurrBookNamePair = ((BookNamePair*)(*gpApp->m_pBibleBooks)[i]);
					}
					else
					{
						// it's a -1 index, or the mode is disabled due to a bad parse of the
						//  books.xml file, so ensure no named pair and the folder path is empty
						gpApp->m_nBookIndex = -1;
						gpApp->m_pCurrBookNamePair = NULL;
						gpApp->m_bibleBooksFolderPath.Empty();
					}
				}
				*/
				break;
			} // end of case 2:
			case 3: // gCurrentSfmSet field
			{
				// gCurrentSfmSet is updated below.
				SetSavedInDoc = (SfmSet)wxAtoi(field); //_ttoi(field);
				break;
			} // end of case 3:
			case 4: // filtered markers string field
			{
				// gCurrentFilterMarkers is updated below.
				// Note: All Unknown markers that were also filtered, will also be listed
				// in the field input string.
				strFilterMarkersSavedInDoc = field;
				// whm added 9Jul12. It is possible that some documents have been saved before
				// we corrected the filtering and unfiltering of \x, \f and \fe markers, in which
				// case this filtered markers string field could have orphaned content markers
				// \xo ... etc without a parent \x, and \ft .... etc without parent \f or \fe.
				// We should clean up any orphaned content markers so that they won't make for
				// problems in marker filtering during the session. We can assume that if \x
				// if present in the filtered markers string field, that its content markers should
				// also be present. If \x is absent the content markers associated with \x should
				// also be absent. Same story for the \f and \fe markers and their associated
				// content markers. I've written a function called CleanupFilterMarkerOrphansInString()
				// to do the job.
				strFilterMarkersSavedInDoc = gpApp->CleanupFilterMarkerOrphansInString(strFilterMarkersSavedInDoc);
				break;
			} // end of case 4:
			case 5: // unknown markers string field
			{
				// The doc has not been serialized in yet so we cannot use
				// GetUnknownMarkersFromDoc() here, so we'll populate the
				// unknown markers arrays here.
				gpApp->m_currentUnknownMarkersStr = field;

				// Initialize the unknown marker data arrays to zero, before we populate them
				// with any unknown markers saved with this document being serialized in
				gpApp->m_unknownMarkers.Clear();
				gpApp->m_filterFlagsUnkMkrs.Clear(); // wxArrayInt

				wxString tempUnkMrksStr = gpApp->m_currentUnknownMarkersStr;

				// Parse out the unknown markers in tempUnkMrksStr
				wxString unkField, wholeMkr, fStr;

				wxStringTokenizer tkz2(tempUnkMrksStr); // use default " " whitespace here

				while (tkz2.HasMoreTokens())
				{
					unkField = tkz2.GetNextToken();
					// field1 should contain a token in the form of "\xx=0 " or "\xx=1 "
					int dPos1 = unkField.Find(_T("=0"));
					int dPos2 = unkField.Find(_T("=1"));
					wxASSERT(dPos1 != -1 || dPos2 != -1);
					int dummyIndex;
					if (dPos1 != -1)
					{
						// has "=0", so the unknown marker is unfiltered
						wholeMkr = unkField.Mid(0, dPos1);
						fStr = unkField.Mid(dPos1, 2); // get the "=0" filtering delimiter part
						if (!MarkerExistsInArrayString(&gpApp->m_unknownMarkers, wholeMkr, dummyIndex))
						{
							gpApp->m_unknownMarkers.Add(wholeMkr);
							gpApp->m_filterFlagsUnkMkrs.Add(FALSE);
						}
					}
					else
					{
						// has "=1", so the unknown marker is filtered
						wholeMkr = unkField.Mid(0, dPos2);
						fStr = unkField.Mid(dPos2, 2); // get the "=1" filtering delimiter part
						if (!MarkerExistsInArrayString(&gpApp->m_unknownMarkers, wholeMkr, dummyIndex))
						{
							gpApp->m_unknownMarkers.Add(wholeMkr);
							gpApp->m_filterFlagsUnkMkrs.Add(TRUE);
						}
					}
				}

				break;
			} // end of case 5:
			default:
			{
				// unknown field - ignore
				;
			}
			} // end of switch (fieldNum)
			fieldNum++;
		} // end of while (tkz.HasMoreTokens())
	}
	else if (dataLen < 5)
	{
		// case 2 above
		// assume we have book mode information - so restore it
		// whm modified to eliminate calling GetChar(0) on a possibly
		// empty string.
		wxChar ch;
		if (buffer.IsEmpty())
			ch = _T('\0');
		else
			ch = buffer.GetChar(0);
		if (ch == _T('T'))
			gpApp->m_bBookMode = TRUE;
		else if (ch == _T('F'))
			gpApp->m_bBookMode = FALSE;
		else
		{
			// oops, it's not book mode info, so do the other block instead
			goto t;
		}
		buffer = buffer.Mid(1); // get the index's string
		int i = wxAtoi(buffer);
		gpApp->m_nBookIndex = i;

		// set the BookNamePair pointer, but we don't have enough info for recreating the
		// m_bibleBooksFolderPath here, but SetupDirectories() can recreate it from the
		// doc-serialized m_sourceName and m_targetName strings, and so we do it there;
		// however, if book mode was off when this document was serialized out, then the
		// saved index value was -1, so we must check for this and not try to set up a
		// name pair when that is the case
		if (i >= 0 && !gpApp->m_bDisableBookMode)
		{
			gpApp->m_pCurrBookNamePair = ((BookNamePair*)(*gpApp->m_pBibleBooks)[i]);
		}
		else
		{
			// it's a -1 index, or the mode is disabled due to a bad parse of the books.xml file,
			// so ensure no named pair and the folder path is empty
			gpApp->m_pCurrBookNamePair = NULL;
			gpApp->m_bibleBooksFolderPath.Empty();
		}
	}
	else
	{
		// BEW changed 27Nov05, because we only let doc settings be used when MRU was being tried
	t:
		;
		// whm 1Oct12 removed MRU related code
		//if (gbTryingMRUOpen /* && !bSameProject */)
		//{
		//	// case 1 above
		//	// assume we have legacy source text data - for this there was no such thing
		//	// as book mode in those legacy application versions, so we can have book mode off
		//	gpApp->m_bBookMode = FALSE;
		//	gpApp->m_nBookIndex = -1;
		//	gpApp->m_pCurrBookNamePair = NULL;
		//	gpApp->m_bibleBooksFolderPath.Empty();
		//}
	}

	// whm ammended 6Jul05 below in support of USFM and SFM Filtering
	// Apply any changes to the App's gCurrentSfmSet and gCurrentFilterMarkers indicated
	// by any existing values saved in the Doc's Buffer member
	gpApp->gCurrentSfmSet = SetSavedInDoc;
	gpApp->gCurrentFilterMarkers = strFilterMarkersSavedInDoc;

	// ResetUSFMFilterStructs also calls SetupMarkerStrings() and SetupMarkerStrings
	// builds the various rapid access marker strings including the Doc's unknown marker
	// string pDoc->m_currentUnknownMarkersStr, and adds the unknown markers to the App's
	// gCurrentFilterMarkers string.
	ResetUSFMFilterStructs(gpApp->gCurrentSfmSet, strFilterMarkersSavedInDoc, allInSet);
}


///////////////////////////////////////////////////////////////////////////////
/// \return a wxString
/// \param	pCString	-> pointer to a wxString formatted into delimited fields containing the
///						book mode, the book index, the current sfm set, a list of the filtered
///						markers, and a list of the unknown markers
/// \remarks
/// Called from: ConstructSettingsInfoAsXML().
/// Creates a wxString composed of delimited fields containing the current book mode, the
/// book index, the current sfm set, a list of the filtered markers, and a list of the
/// unknown markers used in the document.
///////////////////////////////////////////////////////////////////////////////
wxString CAdapt_ItDoc::SetupBufferForOutput(wxString* pCString)
{
	// This function encapsulates code which formerly was in the Serialize() function, but now that
	// version 3 allows xml i/o, we need this code for both binary output and for xml output
	pCString = pCString; // to quiet warning
	// wx version: whatever contents pCString had will be ignored below
	wxString buffer; // = *pCString;
	// The legacy app (pre version 2+) used to save the source text to the document file, but this
	// no longer happens; so since doc serializating is not versionable I can use this CString buffer
	// to store book mode info (T for true, F for false, followed by the _itot() conversion of the
	// m_nBookIndex value; and reconstruct these when serializing back in. The doc has to have
	// the book mode info in it, otherwise I cannot make MRU list choices restore the correct state
	// and folder when a document was saved in book mode, from a Bible book folder
	// whm added 26Feb05 in support of USFM and SFM Filtering
	// Similar reasons require that we use this m_pBuffer space to store some things pertaining
	// to USFM and Filtering support that did not exist in the legacy app. The need for this
	// arises due to the fact that with version 3, what is actually adapted in the source text
	// is dependent upon which markers are filtered and on which sfm set the user has chosen,
	// which the user can change at any time.
	wxString strResult;
	// add the version 3 special buffer prefix
	buffer.Empty();
	buffer << _T("@#@#:"); // RestoreDocParamsOnInput case 0:
	// add the book mode
	if (gpApp->m_bBookMode)
	{
		buffer << _T("T:");  // RestoreDocParamsOnInput case 1:
	}
	else
	{
		buffer << _T("F:");  // RestoreDocParamsOnInput case 1:
	}
	// add the book index
	buffer << gpApp->m_nBookIndex;  // RestoreDocParamsOnInput case 2:
	buffer << _T(":");

#if defined (_Trace_FilterMarkers) && !defined(NOLOGS)
	// BEW commented out these logging calls, they just make the log window harder to read for 
	// other content than what these are for
//	wxLogDebug(_T("In SERIALIZE OUT DOC SAVE:\n"));
//	wxLogDebug(_T("   App's gCurrentSfmSet = %d\n"), gpApp->gCurrentSfmSet);
//	wxLogDebug(_T("   App's gCurrentFilterMarkers = %s\n"), gpApp->gCurrentFilterMarkers.c_str());
//	wxLogDebug(_T("   Doc's m_sfmSetBeforeEdit = %d\n"), gpApp->m_sfmSetBeforeEdit);
//	wxLogDebug(_T("   Doc's m_filterMarkersBeforeEdit = %s\n"), gpApp->m_filterMarkersBeforeEdit.c_str());
#endif

	// add the sfm user set enum
	// whm note 6May05: We store the gCurrentSfmSet value, not the gProjectSfmSetForConfig in the doc
	// value which may have been different.
	buffer << (int)gpApp->gCurrentSfmSet;
	buffer << _T(":");

	buffer << gpApp->gCurrentFilterMarkers;
	buffer << _T(":");

	buffer << gpApp->m_currentUnknownMarkersStr;
	buffer << _T(":");
	return buffer;
}

///////////////////////////////////////////////////////////////////////////////
/// \return TRUE if file at path was successfully saved; FALSE otherwise
/// \param	path	-> path of the file to be saved
/// \remarks
/// Called from: the App's DoTransformationsToGlosses( ) in order to save another project's
/// document, which has just had its adaptations transformed into glosses in the current
/// project. The full path is passed in - it will have been made an *.xml path in the
/// caller.
/// We don't have to worry about the view, since the document is not visible during any
/// part of the transformation process.
/// We return TRUE if all went well, FALSE if something went wrong; but so far the caller
/// makes no use of the returned Boolean value and just assumes the function succeeded.
/// The save is done to a Bible book folder when that is appropriate, whether or not book
/// mode is currently in effect.
///////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItDoc::DoTransformedDocFileSave(wxString path)
{
	wxFile f; // create a CFile instance with default constructor
	bool bFailed = FALSE;

	if (!f.Open(path, wxFile::write))
	{
		wxString s;
		s = s.Format(_(
			"When transforming documents, the Open function failed, for the path: %s"),
			path.c_str());
		wxMessageBox(s, _T(""), wxICON_EXCLAMATION | wxOK);
		return FALSE;
	}

	CSourcePhrase* pSrcPhrase;
	CBString aStr;
	CBString openBraceSlash = "</"; // to avoid "warning:
				// deprecated conversion from string constant to 'char*'"

	// prologue (BEW changed 02July07)
	gpApp->GetEncodingStringForXmlFiles(aStr);
	DoWrite(f, aStr);

	// add the comment with the warning about not opening the XML file in MS WORD
	// 'coz is corrupts it - presumably because there is no XSLT file defined for it
	// as well. When the file is then (if saved in WORD) loaded back into Adapt It,
	// the latter goes into an infinite loop when the file is being parsed in.
	aStr = MakeMSWORDWarning(); // the warning ends with \r\n so
								// we don't need to add them here

	// doc opening tag
	aStr += "<";
	aStr += xml_adaptitdoc;
	aStr += ">\r\n"; // eol chars OK in cross-platform version ???
	DoWrite(f, aStr);

	// place the <Settings> element at the start of the doc
	aStr = ConstructSettingsInfoAsXML(1);
	DoWrite(f, aStr);

	// add the list of sourcephrases
	SPList::Node* pos_pSP = gpApp->m_pSourcePhrases->GetFirst();
	while (pos_pSP != NULL)
	{
		pSrcPhrase = (CSourcePhrase*)pos_pSP->GetData();
		pos_pSP = pos_pSP->GetNext();
		aStr = pSrcPhrase->MakeXML(1); // 1 = indent the element lines with a single tab
		DoWrite(f, aStr);
	}

	// doc closing tag
	aStr = xml_adaptitdoc;
	aStr = openBraceSlash + aStr; //"</" + aStr;
	aStr += ">\r\n"; // eol chars OK in cross-platform version ???
	DoWrite(f, aStr);

	// close the file
	f.Close();
	f.Flush();
	if (bFailed)
		return FALSE;
	else
		return TRUE;
}


///////////////////////////////////////////////////////////////////////////////
/// \return TRUE if currently opened document was successfully saved; FALSE otherwise
/// \remarks
/// Called from: the Doc's OnFileClose().
/// Takes care of saving a modified document, saving the project configuration file, and
/// other housekeeping tasks related to file saves.
/// BEW modified 13Nov09: if local user has read-only access to a remote project
/// folder, don't let any local actions result in saving the local copy of the document
/// on the remote machine, otherwise some loss of edits may happen
///////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItDoc::OnSaveModified()
{
	NormalizeState();

	// save project configuration fonts and settings
	CAdapt_ItApp* pApp = &wxGetApp();

	if (pApp->m_bReadOnlyAccess)
	{
		return TRUE; // make the caller think a save etc was done
	}

	wxCommandEvent dummyevent;

	// should not close a document or project while in "show target only" mode; so detect if that
	// mode is still active & if so, restore normal mode first
	if (gbShowTargetOnly)
	{
		//restore normal mode
		pApp->GetView()->OnToggleShowSourceText(dummyevent);
	}

	// get name/title of document
	wxString name = pApp->m_curOutputFilename;

	wxString prompt;
	bool bUserSavedDoc = FALSE; // use this flag to cause the KB to be automatically saved
								// if the user saves the Doc, without asking; but if the user
								// does not save the doc, he should be asked for the KB
	bool bOK; // we won't care whether it succeeds or not,
			  // since the later Get... can use defaults
	if (!pApp->m_curProjectPath.IsEmpty())
	{
		if (pApp->m_bUseCustomWorkFolderPath && !pApp->m_customWorkFolderPath.IsEmpty())
		{
			// whm 10Mar10, must save using what paths are current, but when the custom
			// location has been locked in, the filename lacks "Admin" in it, so that it
			// becomes a "normal" project configuration file in m_curProjectPath at the
			// custom location.
			if (pApp->m_bLockedCustomWorkFolderPath)
				bOK = pApp->WriteConfigurationFile(szProjectConfiguration, pApp->m_curProjectPath, projectConfigFile);
			else
				bOK = pApp->WriteConfigurationFile(szAdminProjectConfiguration, pApp->m_curProjectPath, projectConfigFile);
		}
		else
		{
			bOK = pApp->WriteConfigurationFile(szProjectConfiguration, pApp->m_curProjectPath, projectConfigFile);
		}
		// we don't expect a write error, but tell the developer or user if the write
		// fails, and keep on processing
		if (!bOK)
		{
			wxMessageBox(_T("Adapt_ItDoc.cpp, WriteConfigurationFile() failed, for project config file or admin project config file, in OnSaveModified() at lines 5986+"));
		}
	}

	bool bIsModified = IsModified();
	if (!bIsModified)
		return TRUE;        // ok to continue

	// BEW added 11Aug06; for some reason IsModified() returns TRUE in the situation when the
	// user first launches the app, creates a project but cancels out of document creation, and
	// then closes the application by clicking the window's close box at top right. We don't
	// want MFC to put up the message "Save changes for ?", because if the user says OK, then
	// the app crashes. So we detect an empty document next and prevent the message from appearing
	if (pApp->m_pSourcePhrases->GetCount() == 0)
	{
		// if there are none, there is no document to save, so useless to go on,
		// so return TRUE immediately
		return TRUE;
	}

	prompt = prompt.Format(_("The document %s has changed. Do you want to save it? "), name.c_str());
	// whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
	gpApp->m_bUserDlgOrMessageRequested = TRUE;
	int result = wxMessageBox(prompt, _T(""), wxICON_QUESTION | wxYES_NO | wxYES_DEFAULT | wxCANCEL); //AFX_IDP_ASK_TO_SAVE
	wxCommandEvent dummyEvent; // BEW added 29Apr10
	switch (result)
	{
	case wxCANCEL:
	{
		return FALSE;       // don't continue
	}
	case wxYES:
	{
		// If so, either Save or Update, as appropriate
		// BEW changed 29Apr10, DoFileSave_Protected() protects against loss of the
		// document file, which is safer
		//bUserSavedDoc = DoFileSave(TRUE); // TRUE - show wait/progress dialog

		// whm 26Aug11 Open a wxProgressDialog instance here for save operations.
		// The dialog's pProgDlg pointer is passed along through various functions that
		// get called in the process.
		// whm WARNING: The maximum range of the wxProgressDialog (nTotal below) cannot
		// be changed after the dialog is created. So any routine that gets passed the
		// pProgDlg pointer, must make sure that value in its Update() function does not
		// exceed the same maximum value (nTotal).
		wxString msgDisplayed;
		const int nTotal = gpApp->GetMaxRangeForProgressDialog(App_SourcePhrases_Count) + 1;
		wxString progMsg = _("Saving file %s - %d of %d Total words and phrases");
		wxFileName fn(gpApp->m_curOutputFilename);
		msgDisplayed = progMsg.Format(progMsg, fn.GetFullName().c_str(), 1, nTotal);
		CStatusBar* pStatusBar = NULL;
		pStatusBar = (CStatusBar*)gpApp->GetMainFrame()->m_pStatusBar;
		pStatusBar->StartProgress(_("Saving File"), msgDisplayed, nTotal);

		// whm added 17Jan12 code block below which is parallel to OnFileSave() to
		// save the collab files and do the DoFileSave_Protected() call too for AI's
		// own files.
		if (gpApp->m_bCollaboratingWithParatext || gpApp->m_bCollaboratingWithBibledit)
		{
			// Collaboration is ON
			// whm modified 17Jan12 consolidated the code for collab mode file saves
			// in a DoCollabFileSave() function as it needs to also be called from
			// OnSaveModified(), otherwise saves can be lost if user closes the main
			// frame window - which triggers OnSaveModified() but not OnFileSave().
			// Notes:
			// 1. DoCollabFileSave() returns a bool as does DoFileSave_Protected()
			// and DoFileSave().
			// 2. DoCollabFilesave() also calls DoFileSave_Protected(TRUE,pProgDlg)
			bUserSavedDoc = DoCollabFileSave(_("Saving File"), msgDisplayed);
		}
		else
		{
			// Collaboration is OFF
			bUserSavedDoc = DoFileSave_Protected(TRUE, _("Saving File")); // TRUE - show wait/progress dialog
		}
		if (!bUserSavedDoc)
		{
			wxMessageBox(_("Warning: document save failed for some reason.\n"),
				_T(""), wxICON_EXCLAMATION | wxOK);
			pStatusBar->FinishProgress(_("Saving File"));
			return FALSE;       // don't continue
		}
		pStatusBar->FinishProgress(_("Saving File"));
		break;
	} // end of case wxYES:

	case wxNO:
	{
		// If not saving changes, revert the document (& ask for a KB save)
		break;
	}
	default:
	{
		wxASSERT(FALSE);
		break;
	}
	} // end of switch (result)

	// whm Note: Since the progDlg is created on the stack, it will automatically
	// be disposed of when this funciton returns.
	return TRUE;    // keep going
}

////////////////////////////////////////////////////////////////////////////////////////
// NOTE: This OnSaveDocument() is from the docview sample program.
//
// The wxWidgets OnSaveDocument() method "Constructs an output file stream
// for the given filename (which must not be empty), and then calls SaveObject.
// If SaveObject returns TRUE, the document is set to unmodified; otherwise,
// an error message box is displayed.
//
//bool CAdapt_ItDoc::OnSaveDocument(const wxString& filename) // from wxWidgets mdi sample
//{
//    CAdapt_ItView* view = (CAdapt_ItView*) GetFirstView();
//
//    if (!view->textsw->SaveFile(filename))
//        return FALSE;
//    Modify(FALSE);
//    return TRUE;
//}

// below is code from the docview sample's original override (which doesn't call the
// base class member) converted to the first Adapt It prototype.
// The wxWidgets OnOpenDocument() "Constructs an input file stream
// for the given filename (which must not be empty), and calls LoadObject().
// If LoadObject returns TRUE, the document is set to unmodified; otherwise,
// an error message box is displayed. The document's views are notified that
// the filename has changed, to give windows an opportunity to update their
// titles. All of the document's views are then updated."
//
//bool CAdapt_ItDoc::OnOpenDocument(const wxString& filename) // from wxWidgets mdi sample
//{
//    CAdapt_ItView* view = (CAdapt_ItView*) GetFirstView();
//
//    if (!view->textsw->LoadFile(filename))
//        return FALSE;
//
//    SetFilename(filename, TRUE);
//    Modify(FALSE);
//    UpdateAllViews();
//
//    return TRUE;
//}

////////////////////////////////////////////////////////////////////////////////////////
// NOTE: The differences in design between MFC's doc/view framework
// and the wxWidgets implementation of doc/view necessitate some
// adjustments in order to not foul up the state of AI's data structures.
//
// Here below is the contents of the MFC base class CDocument::OnOpenDocument()
// method (minus _DEBUG statements):
//bool CDocument::OnOpenDocument(LPCTSTR lpszPathName)
//{
//	CFileException fe;
//	CFile* pFile = GetFile(lpszPathName,
//		CFile::modeRead|CFile::shareDenyWrite, &fe);
//	if (pFile == NULL)
//	{
//		ReportSaveLoadException(lpszPathName, &fe,
//			FALSE, AFX_IDP_FAILED_TO_OPEN_DOC);
//		return FALSE;
//	}
//	DeleteContents();
//	SetModifiedFlag();  // dirty during de-serialize
//
//	CArchive loadArchive(pFile, CArchive::load | CArchive::bNoFlushOnDelete);
//	loadArchive.m_pDocument = this;
//	loadArchive.m_bForceFlat = FALSE;
//	TRY
//	{
//		CWaitCursor wait;
//		if (pFile->GetLength() != 0)
//			Serialize(loadArchive);     // load me
//		loadArchive.Close();
//		ReleaseFile(pFile, FALSE);
//	}
//	CATCH_ALL(e)
//	{
//		ReleaseFile(pFile, TRUE);
//		DeleteContents();   // remove failed contents
//
//		TRY
//		{
//			ReportSaveLoadException(lpszPathName, e,
//				FALSE, AFX_IDP_FAILED_TO_OPEN_DOC);
//		}
//		END_TRY
//		DELETE_EXCEPTION(e);
//		return FALSE;
//	}
//	END_CATCH_ALL
//
//	SetModifiedFlag(FALSE);     // start off with unmodified
//
//	return TRUE;
//}

// Here below is the contents of the wxWidgets base class WxDocument::OnOpenDocument()
// method (minus alternate wxUSE_STD_IOSTREAM statements):
//bool wxDocument::OnOpenDocument(const wxString& file)
//{
//    if (!OnSaveModified())
//        return FALSE;
//
//    wxString msgTitle;
//    if (wxTheApp->GetAppName() != wxT(""))
//        msgTitle = wxTheApp->GetAppName();
//    else
//        msgTitle = wxString(_("File error"));
//
//    wxFileInputStream store(file);
//    if (store.GetLastError() != wxSTREAM_NO_ERROR)
//    {
//        (void)wxMessageBox(_("Sorry, could not open this file."), msgTitle, wxOK|wxICON_EXCLAMATION,
//                           GetDocumentWindow());
//        return FALSE;
//    }
//    int res = LoadObject(store).GetLastError();
//    if ((res != wxSTREAM_NO_ERROR) &&
//        (res != wxSTREAM_EOF))
//    {
//        (void)wxMessageBox(_("Sorry, could not open this file."), msgTitle, wxOK|wxICON_EXCLAMATION,
//                           GetDocumentWindow());
//        return FALSE;
//    }
//    SetFilename(file, TRUE);
//    Modify(FALSE);
//    m_savedYet = TRUE;
//
//    UpdateAllViews();
//
//    return TRUE;
//}

// The significant differences in the BASE class methods are:
// 1. MFC OnOpenDocument() calls DeleteContents() before loading the archived
//    file (with Serialize(loadArchive)). The base class DeleteContents() of
//    both MFC and wxWidgets do nothing themselves. The overrides of DeleteContents()
//    have the same code in both versions.
// 2. wxWidgets' OnOpenDocument() does NOT call DeleteContents(), but first calls
//    OnSaveModified(). OnSaveModified() calls Save() if the doc is dirty. Save()
//    calls either SaveAs() or OnSaveDocument() depending on whether the doc was
//    previously saved with a name. SaveAs() takes care of getting a name from
//    user, then eventually also calls OnSaveDocument(). OnSaveDocument() finally
//    calls SaveObject(store).
// The Implications for our conversion to wxWidgets:
// 1. In our OnOpenDocument() override we need to first call DeleteContents().
// 2. We just comment out the call to the wxDocument::OnOpenDocument() base class
//    transfer its calls to our override and make any appropriate adjustments to
//    the stream error messages.

///////////////////////////////////////////////////////////////////////////////
/// \return TRUE if file at filename was successfully opened; FALSE otherwise
/// \param	filename	-> the path/name of the file to open
/// \remarks
/// Called from: the App's DoKBRestore() and DiscardDocChanges(), the Doc's
/// LoadSourcePhraseListFromFile() and DoUnpackDocument(), the View's OnEditConsistencyCheck(),
/// DoConsistencyCheck() and DoRetranslationReport(), the DocPage's OnWizardFinish(), and
/// CMainFrame's SyncScrollReceive().
/// Opens the document at filename and does the necessary housekeeping and initialization of
/// KB data structures for an open document.
/// [see also notes within in the function]
/// BEW added 13Nov09: call of m_bReadOnlyAccess = SetReadOnlyProtection(), in order to give
/// the local user in the project ownership for writing permission (if FALSE is returned)
/// or READ-ONLY access (if TRUE is returned). (Also added to LoadKB() and OnNewDocument()
/// and OnCreate() for the view class.)
///////////////////////////////////////////////////////////////////////////////

bool CAdapt_ItDoc::OnOpenDocument(const wxString& filename, bool bShowProgress /* = true */)
{
	CAdapt_ItApp* pApp = GetApp();
	CAdapt_ItView* pView = pApp->GetView();

	// BEW 16Aug16, Restore the default, which is Shift_Launch no longer on, if it was on
	pApp->m_bDoNormalProjectOpening = TRUE;

	// refactored 10Mar09
	pApp->m_nSaveActiveSequNum = 0;     // reset to a default initial value, safe for any length of doc

	// whm Version 3 Note: Since the WX version i/o is strictly XML, we do not need nor use
	// the legacy version's OnOpenDocument() serialization facilities, and can thus avoid
	// the black box problems it caused.
	// Old legacy version notes below:
	// The MFC code called the virtual methods base class OnOpenDocument here:
	//if (!CDocument::OnOpenDocument(lpszPathName)) // The MFC code
	//	return FALSE;
	// The wxWidgets equivalent is:
	//if (!wxDocument::OnOpenDocument(filename))
	//	return FALSE;
	// wxWidgets Notes:
	// 1. The wxWidgets base class wxDocument::OnOpenDocument() method DOES NOT
	//    automatically call DeleteContents(), so we must do so here. Also,
	// 2. The OnOpenDocument() base class handles stream errors with some
	//    generic messages. For these reasons then, rather than calling the base
	//    class method, we first call DeleteContents(), then we just transfer
	//    and/or merge the relevant contents of the base class method here, and
	//    taylor its stream error messages to Adapt It's needs, as was done in
	//    DoFileSave().

	// BEW added 06Aug05 for XML doc support (we have to find out what extension it has
	// and then choose the corresponding code for loading that type of doc
	// BEW modified 14Nov05 to add the doc instance to the XML doc reading call, and to
	// remove the assert which assumed that there would always be a backslash in the
	// lpszPathName string, and replace it with a test on curPos instead (when doing a
	// consistency check, the full path is not passed in)

	pApp->m_nActiveSequNum = 0;		// mrh - initialize this to a sensible default -- should
									//  be set to a new value when we read in the xml for the doc.

	// BEW changed 9Apr12, support discontinuous auto-inserted spans highlighting
	gpApp->m_pLayout->ClearAutoInsertionsHighlighting();

	wxString thePath = filename;
	wxString extension = thePath.Right(4);
	extension.MakeLower();
	wxASSERT(extension[0] == _T('.')); // check it really is an extension
	bool bWasXMLReadIn = TRUE;

	//bool bBookMode;
	//bBookMode = gpApp->m_bBookMode; // for debugging only. 01Oct06
	//int nItsIndex;
	//nItsIndex = gpApp->m_nBookIndex; // for debugging only

	// get the filename
	wxString fname = thePath;
	fname = MakeReverse(fname);
	int curPos = fname.Find(gpApp->PathSeparator);
	if (curPos != -1)
	{
		fname = fname.Left(curPos);
	}
	fname = MakeReverse(fname);
	wxString extensionlessName;

	// whm 26Aug11 Open a wxProgressDialog instance here for loading KB operations.
	// The dialog's pProgDlg pointer is passed along through various functions that
	// get called in the process.
	// whm WARNING: The maximum range of the wxProgressDialog (nTotal below) cannot
	// be changed after the dialog is created. So any routine that gets passed the
	// pProgDlg pointer, must make sure that value in its Update() function does not
	// exceed the same maximum value (nTotal).
	wxString msgDisplayed;
	wxString progMsg;
	// add 1 chunk to insure that we have enough after int division above
	const int nTotal = gpApp->GetMaxRangeForProgressDialog(XML_Input_Chunks) + 1;

	// Only show the progress dialog when there is at lease one chunk of data, AND we're wanting
	//  to show progress dialogs just now.

	CStatusBar* pStatusBar = NULL;
	pStatusBar = (CStatusBar*)gpApp->GetMainFrame()->m_pStatusBar;
	if (nTotal > 0 && bShowProgress)
	{
		progMsg = _("Reading file %s - part %d of %d");
		wxFileName fn(filename);
		msgDisplayed = progMsg.Format(progMsg, fn.GetFullName().c_str(), 1, nTotal);
		pStatusBar->StartProgress(_("Opening the Document"), msgDisplayed, nTotal);
	}

	// force m_bookName_Current to be empty -- it will stay empty unless set from what is
	// stored in a document just loaded; or in collaboration mode by copying to it the
	// value of the m_CollabBookSelected member; or doing an export of xhtml or for
	// Pathway export, no book name is current and the user fills one out using the
	// CBookName dialog which opens for that purpose
	pApp->m_bookName_Current.Empty();

	// BEW 19Apr18 Provide more failure diagnostics here, for LogUserAction() - we want to know
	// the filesize (in case it got trucated; the path and filename - tells us from where and
	// whether it is a collaboration file, and the last 15 characters which should contain the
	// </AdaptItDoc> string
	wxFile f;
	long fileLen;
	int nReadBytes;
	if (f.Exists(filename) && f.Open(filename, wxFile::read))
	{
		fileLen = f.Length(); // get length of file in bytes.
		if (fileLen > 15) // bytes
		{
			char* pBuff = new char[fileLen + 1]; // create on the heap just in case it is a huge file
			memset(pBuff, 0, fileLen + 1);
			nReadBytes = f.Read(pBuff, fileLen);
			char* pShortBuff = new char[16];
			memset(pShortBuff, 0, 16); // fill with nulls

			long nStart = nReadBytes - 15;
			char* ptr = pBuff + nStart;
			char* pShort = pShortBuff;
			while (*ptr != 0)
			{
				// copy the last 15 characters to the short buffer
				// which should contain </AdaptItDoc> and maybe crlf after it)
				*pShort++ = *ptr++;
			}
			CBString bytes(pShortBuff);
			wxString endingStr;
			pApp->Convert8to16(bytes, endingStr);
			endingStr.Trim(FALSE); endingStr.Trim(TRUE); // both ends, in case some whitespace is present

			// Now construct the log entry for LogUserAction and insert it into the log
			wxString strLog = _T("OnOpenDocument: Path&Filename = %s , size (in bytes) = %d , File ending = %s");
			strLog = strLog.Format(strLog, filename.c_str(), nReadBytes, endingStr.c_str());
			pApp->LogUserAction(strLog);

			delete[] pBuff;
			delete[] pShortBuff;
			f.Close();
		}
		pApp->m_bDocumentDestroyed = FALSE; // re-initialize (to permit DoAutoSaveDoc() to work)
	}

	wxFileName fn(filename);

	if (extension == _T(".xml"))
	{
		// we have to input an xml document
		// BEW modified 07Nov05, to add pointer to the document, since we may be reading
		// in XML documents for joining to the current document, and we want to
		// populate the correct document's CSourcePhrase list
		wxString thePath = filename;
		wxFileName fn(thePath);
		wxString fullFileName;
		fullFileName = fn.GetFullName();

		// whm 6Apr2020 Note: For document creation logging in ReadDoc_XML, the App's m_curOutputFilename needs to be
		// set to the current output file name, before the ReadDoc_XML() function call below. 
		pApp->m_curOutputPath = thePath;
		gpApp->m_curOutputFilename = fullFileName;

		// Write the first couple log lines of our logging file to log the filename and 
		// date-time. Also write a line telling what function we are calling from.
		// See comments above the LogDocCreationData() function in the App for more details.
		// If there is a parse failure, it happened after the last m_srcPhrase in
		// this file. It is stored in the folder _LOGS_EMAIL_REPORTS in work folder
		// when "Make diagnostic logfile during document creation and opening" check box
		// is ticked in the docPage or the GetSourceTextFromEditor dialog.
		if (gpApp->m_bMakeDocCreationLogfile) // turn this ON in docPage of the Wizard or in GetSourceTextFromEditor dialog; it is OFF by default
		{
			// Construct the parameter string composed of the current output filename + date-time stamp for Now().
			wxString fileNameLine;
			wxDateTime theTime = wxDateTime::Now(); //initialize to the current time
			wxString timeStr;
			timeStr = theTime.Format();
			// whm 13Apr2020 changed to log whole path/name of doc being created/opened + date-time stamp
			fileNameLine = pApp->m_curOutputPath + _T(" ") + timeStr;
			gpApp->LogDocCreationData(fileNameLine);
			// whm 6Apr2020 the following m_bParsingSource is set TRUE during logging 
			// to prevent TokenizeText() from doing unwanted logging in other operations
			// where TokenizeText is used.
			gpApp->m_bParsingSource = TRUE;
			// whm 14Apr2020 added following log line to indicate source of Data
			gpApp->LogDocCreationData(_T("In OnOpenDocument() logging Data via ReadDoc_XML() below:"));
		}

		bool bReadOK = ReadDoc_XML(thePath, this, _("Opening the Document"), nTotal); // pProgDlg can be NULL

		pApp->m_bDocumentDestroyed = FALSE; // re-initialize (to permit DoAutoSaveDoc() to work)

		if (!bReadOK)
		{
			// if we could possibly recover the doc, but haven't posted the "recover doc" event yet, we do it now:
			if (pApp->m_commitCount > 0 && !pApp->m_recovery_pending)
			{
				//               wxCommandEvent  eventCustom (wxEVT_Recover_Doc);
				//               wxPostEvent (pApp->GetMainFrame(), eventCustom);       // Custom event handlers are in CMainFrame

				pApp->m_recovery_pending = TRUE;
				pApp->m_reopen_recovered_doc = TRUE;    // In this one case we just reopen the doc after recovery.  It should be the
														//  most common case.
			}

			// at this point, if we can't attempt a recovery, we just display a message and give up.  If we are attempting a recovery,
			//  we skip this block and continue with some of the initialization we need before we can bail out.

			if (!pApp->m_recovery_pending)
			{
				wxString s;
				// ugly message because we expect a good read, but we allow the user to continue
				// IDS_XML_READ_ERR
				s = _(
					"There was an error parsing in the XML file.\nIf you edited the XML file earlier, you may have introduced an error.\nEdit it in a word processor then try again.");
				wxMessageBox(s, fullFileName, wxICON_INFORMATION | wxOK);
				gpApp->LogUserAction(s);
				//}
				if (nTotal > 0 && bShowProgress)
				{
					pStatusBar->FinishProgress(_("Opening the Document"));
				}
				return FALSE;     // mrh - returning TRUE causes mayhem higher up!
			}
			gpApp->m_bParsingSource = FALSE; // make sure doc creation logging stays OFF
											// until explicitly turned on at another time
			gpApp->m_bMakeDocCreationLogfile = FALSE; // turn this OFF to prevent user
											// leaving it turned on, and wondering why doc creation takes minutes to complete

		}
		// whm 13Apr2020 added line at end of document opening log to indicate we reached end of the document
		// This essentially signals within the log file that the XML document opening was successful.
		if (gpApp->m_bMakeDocCreationLogfile)
		{
			gpApp->LogDocCreationData(_T("***End-of-Document***"));
		}
	}

	if (pApp->m_bWantSourcePhrasesOnly)
	{
		// From here on in for the rest of this function, all we do is set globals,
		// filenames, config file parameters, and change the view, all things we're not to
		// do if m_bWantSourcePhrasesOnly is set. Hence, we simply exit early; because all
		// we are wanting is the list of CSourcePhrase instances.
		gpApp->LogUserAction(_T("Return TRUE early from OnOpenDocument() m_bWantSourcePhrasesOnly"));
		ValidateNoteStorage();
		if (nTotal > 0 && bShowProgress)
		{
			pStatusBar->FinishProgress(_("Opening the Document"));
		}
		pApp->m_bDocumentDestroyed = FALSE; // re-initialize (to permit DoAutoSaveDoc() to work)

		return TRUE; // Added by JF.
	}

	// update the window title
	SetDocumentWindowTitle(fname, extensionlessName);

	wxString filenameStr = fn.GetFullName(); //GetFileName(filename);
	if (bWasXMLReadIn)
	{
		// it was an *.xml file the user opened
		gpApp->m_curOutputFilename = filenameStr;

		// construct the backup's filename
		// BEW changed 23June07 to allow for the possibility that more than one period
		// may be used in a filename
		filenameStr = MakeReverse(filenameStr);
		filenameStr.Remove(0, 4); //filenameStr.Delete(0,4); // remove "lmx."
		filenameStr = MakeReverse(filenameStr);
		filenameStr += _T(".BAK");
		//filenameStr += _T(".xml"); // produces *.BAK.xml BEW removed 3Mar11
	}
	gpApp->m_curOutputBackupFilename = filenameStr;
	gpApp->m_curOutputPath = filename;

	// Now the filename strings are set up, if we're recovering a corrupt doc, we can bail out.

	if (gpApp->m_recovery_pending)
	{
		// whm 23Aug2018 added pStatusBar->FinishProgress(...) below
		// The progress bar should call FinishProgress before all return statements.
		if (nTotal > 0 && bShowProgress)
		{
			pStatusBar->FinishProgress(_("Opening the Document"));
		}
		pApp->m_bDocumentDestroyed = FALSE; // re-initialize (to permit DoAutoSaveDoc() to work)
		return FALSE;
	}

	// filenames and paths for the doc and any backup are now guaranteed to be
	// what they should be
	// CAdapt_ItApp* pApp = GetApp();		// mrh - moved to start of function
	// CAdapt_ItView* pView = pApp->GetView();
//#ifdef _DEBUG
//	wxLogDebug(_T("OnOpenDocument at %d ,  Active Sequ Num  %d"),1,pApp->m_nActiveSequNum);
//#endif

	int width = wxSystemSettings::GetMetric(wxSYS_SCREEN_X);
	if (pApp->m_docSize.GetWidth() < 100 || pApp->m_docSize.GetWidth() > width)
	{
		::wxBell(); // tell me it was wrong
		pApp->m_docSize = wxSize(width - 40, 600); // ensure a correctly sized document
		pApp->GetMainFrame()->canvas->SetVirtualSize(pApp->m_docSize);
	}

	// refactored version: try the following here
	CLayout* pLayout = GetLayout();
	pLayout->SetLayoutParameters(); // calls InitializeCLayout() and UpdateTextHeights()
									// and other setters

	bool bIsOK = TRUE; // initialise

#ifdef _NEW_LAYOUT
	bIsOK = pLayout->RecalcLayout(pApp->m_pSourcePhrases, create_strips_and_piles);
#else
	bIsOK = pLayout->RecalcLayout(pApp->m_pSourcePhrases, create_strips_and_piles);
#endif
	if (!bIsOK)
	{
		// unlikely to fail, so just have something for the developer here
		wxMessageBox(_T("Error. RecalcLayout() failed in OnOpenDocument()"),
			_T(""), wxICON_STOP);
		gpApp->LogUserAction(_T("Error. RecalcLayout() failed in OnOpenDocument()"));
		if (nTotal > 0 && bShowProgress)
		{
			pStatusBar->FinishProgress(_("Opening the Document"));
		}
		wxASSERT(FALSE);
		wxExit();
	}

	if (pApp->m_pSourcePhrases->GetCount() == 0)
	{
		// nothing to show
		wxString msg;
		msg = _("Nothing was read in successfully.\nThis can happen if the document being loaded was created with a later version of Adapt It that has either a higher docVersion value, or extra attributes in the <Settings> tag, or both.\nYou can try manual editing in Notepad or a similar PlainText editor (on a copy of the document xml file) removing attributes added recently to the <Settings> element, or lowering the docVersion number, or both, and then saving (as UTF-8).\nThen try to load the edited document file.\nComparing the docVersion and attributes of documents not opened for a long time may help you work out which are the things to remove or change. Confine such editing to lines 5 to 7 of the xml document file.\nPerhaps contacting the developers for help is best.");
		wxMessageBox(msg, fn.GetFullName(), wxICON_EXCLAMATION | wxOK);
		gpApp->LogUserAction(msg);
		if (nTotal > 0 && bShowProgress)
		{
			pStatusBar->FinishProgress(_("Opening the Document"));
		}
		pApp->m_bDocumentDestroyed = FALSE; // re-initialize (to permit DoAutoSaveDoc() to work)
		return FALSE;
	}

	// BEW 25Jun13, test the activesequnum value, because if it is large but the user has
	// manually fiddled with the document to make it have fewer piles, then the doc's
	// carried value of the active location may be beyond the end of the shortened
	// document, and then trying to set it returns NULL as the m_pActivePile value. So
	// check and if necessary give it a safe smaller value
	int nMaxCurrentSequNum = pApp->m_pSourcePhrases->GetCount() - 1;
	if (pApp->m_nActiveSequNum > nMaxCurrentSequNum)
	{
		pApp->m_nActiveSequNum = 0; // generally the most safe value it can have
	}
	pApp->m_pActivePile = GetPile(pApp->m_nActiveSequNum);	// seq num was initially zero but should have been set
															// to a "real" value when the xml was read in

	pApp->m_pLayout = pApp->m_pLayout; // for debugging


	// BEW added 21Apr08; clean out the global struct gEditRecord & clear its deletion lists,
	// because each document, on opening it, it must start with a truly empty EditRecord; and
	// on doc closure and app closure, it likewise must be cleaned out entirely (the deletion
	// lists in it have content which persists only for the life of the document currently open)
	pView->InitializeEditRecord(gEditRecord);
	gEditRecord.deletedAdaptationsList.Clear(); // remove any stored deleted adaptation strings
	gEditRecord.deletedGlossesList.Clear(); // remove any stored deleted gloss strings
	gEditRecord.deletedFreeTranslationsList.Clear(); // remove any stored deleted free translations

	// whm added 1Oct12. After removing the MRU stuff from
	// OnOpenDocument(), I've retained the initial test, i.e., if
	// (pApp->m_pKB == NULL), and if that test passes, then there may
	// be something more that needs to be accounted for in the removal
	// of the MRU material. I'll signal that with a "Probable Programming
	// Error..." message
	if (pApp->m_pKB == NULL)
	{
		wxASSERT_MSG(FALSE, _T("In OnOpenDocument() m_pKB is NULL. Probable Programming Error after disabling MRU code."));
		pApp->LogUserAction(_T("In OnOpenDocument() m_pKB is NULL. Probable Programming Error after disabling MRU code."));
	}
	gbDoingInitialSetup = FALSE; // turn it back off, the pApp->m_targetBox now exists, etc

	// place the phrase box, but inhibit placement on first pile if doing a consistency
	// check, because otherwise whatever adaptation is in the KB for the first word/phrase
	// gets removed unconditionally from the KB when that is NOT what we want to occur!
	if (!gbConsistencyCheckCurrent)
	{
		// ensure its not a retranslation - if it is, move the active location to first
		// non-retranslation pile
		if (pApp->m_pActivePile->GetSrcPhrase()->m_bRetranslation)
		{
			// it is a retranslation, so move active location
			CPile* pNewPile;
			CPile* pOldPile = pApp->m_pActivePile;
			do {
				pNewPile = pView->GetNextPile(pOldPile);
				wxASSERT(pNewPile);
				pOldPile = pNewPile;
			} while (pNewPile->GetSrcPhrase()->m_bRetranslation);
			pApp->m_pActivePile = pNewPile;
			pApp->m_nActiveSequNum = pNewPile->GetSrcPhrase()->m_nSequNumber;
		}

		// BEW added 10Jun09, support phrase box matching of the text colour chosen
		if (gbIsGlossing && gbGlossingUsesNavFont)
		{
			pApp->m_pTargetBox->GetTextCtrl()->SetOwnForegroundColour(pLayout->GetNavTextColor());// whm 12Jul2018 added ->GetTextCtrl() part
		}
		else
		{
			pApp->m_pTargetBox->GetTextCtrl()->SetOwnForegroundColour(pLayout->GetTgtColor());// whm 12Jul2018 added ->GetTextCtrl() part
		}

		// whm 28Mar2018 Note: This next PlacePhraseBox() call is called from the DocPage's
		// OnWizardFinish(), which was in turn called by DocPage's OnWizardPageChanging().
		// The OnWizardPageChanging() function itself will end up calling PlaceBox(), so
		// we should suppress PlacePhraseBox()'s own PlaceBox() call and its execution of
		// code in SetupDropDownPhraseBoxForThisLocation() here by setting the App's
		// m_bMovingToDifferentPile flag to TRUE during the PlacePhraseBox() call.
		pApp->m_bMovingToDifferentPile = TRUE;
		pView->PlacePhraseBox(pApp->m_pActivePile->GetCell(1), 2); // selector = 2, because we
			// were not at any previous location, so inhibit the initial StoreText call,
			// but enable the removal from KB storage of the adaptation text (see comments under
			// the PlacePhraseBox function header, for an explanation of selector values)
		pApp->m_bMovingToDifferentPile = FALSE;

		// save old sequ number in case required for toolbar's Back button - no earlier one yet,
		// so just use the value -1
		pApp->m_nOldSequNum = -1;
	}

	// determine m_curOutputPath, so it can be saved to config files as m_lastDocPath
	if (gpApp->m_bBookMode && !gpApp->m_bDisableBookMode)
	{
		pApp->m_curOutputPath = pApp->m_bibleBooksFolderPath + pApp->PathSeparator
			+ pApp->m_curOutputFilename;
	}
	else
	{
		pApp->m_curOutputPath = pApp->m_curAdaptationsPath + pApp->PathSeparator
			+ pApp->m_curOutputFilename;
	}

	// BEW added 01Oct06: to get an up-to-date project config file saved (in case user
	// turned on or off the book mode in the wizard) so that if the app subsequently
	// crashes, at least the next launch will be in the expected mode (see near top of
	// CAdapt_It.cpp for an explanation of the m_bPassedAppInitialization flag)
	// BEW added 12Nov09, m_bAutoExport test to suppress writing the project config file
	// when export is done from the command line export command
	if (pApp->m_bPassedAppInitialization && !pApp->m_curProjectPath.IsEmpty() && !pApp->m_bAutoExport)
	{
		// BEW on 4Jan07 added change to WriteConfiguration to save the external current
		// work directory and reestablish it at the end of the WriteConfiguration call,
		// because the latter function resets the current directory to the project folder
		// before saving the project config file - and this clobbered the restoration of a
		// KB from the 2nd doc file accessed
		bool bOK;
		if (pApp->m_bUseCustomWorkFolderPath && !pApp->m_customWorkFolderPath.IsEmpty())
		{
			// whm 10Mar10, must save using what paths are current, but when the custom
			// location has been locked in, the filename lacks "Admin" in it, so that it
			// becomes a "normal" project configuration file in m_curProjectPath at the
			// custom location.
			if (pApp->m_bLockedCustomWorkFolderPath)
				bOK = pApp->WriteConfigurationFile(szProjectConfiguration, pApp->m_curProjectPath, projectConfigFile);
			else
				bOK = pApp->WriteConfigurationFile(szAdminProjectConfiguration, pApp->m_curProjectPath, projectConfigFile);
		}
		else
		{
			bOK = pApp->WriteConfigurationFile(szProjectConfiguration, pApp->m_curProjectPath, projectConfigFile);
		}
		// we don't expect a write error, but tell the developer or user if the write
		// fails, and keep on processing
		if (!bOK)
		{
			wxMessageBox(_T("Adapt_ItDoc.cpp, WriteConfigurationFile() failed, for project config file or admin project config file, in OnOpenDocument() at lines 6392+"));
		}
	}

	// whm 1Oct12 removed MRU code
	/*
	// wx version addition:
	// Add the file to the file history MRU
	// BEW added 12Nov09, m_bAutoExport test to suppress history update when export is
	// done from the command line export command
	// whm added 29Mar12, omit file history when in collaboration mode
	if (!pApp->m_curOutputPath.IsEmpty() && !pApp->m_bAutoExport
		&& !pApp->m_bCollaboratingWithParatext && !pApp->m_bCollaboratingWithBibledit)
	{
		wxFileHistory* fileHistory = pApp->m_pDocManager->GetFileHistory();
		fileHistory->AddFileToHistory(pApp->m_curOutputPath);
		// The next two lines are a trick to get past AddFileToHistory()'s behavior of
		// extracting the directory of the file you supply and stripping the path of all
		// files in history that are in this directoy. RemoveFileFromHistory() doesn't do
		// any tricks with the path, so the following is a dirty fix to keep the full
		// paths.
		fileHistory->AddFileToHistory(wxT("[tempDummyEntry]"));
		fileHistory->RemoveFileFromHistory(0); //
	}
	*/

	// BEW added 12Nov09, do the auto-export here, if asked for, and shut
	// down the app before returning; otherwise, continue for normal user
	// GUI interaction
	if (pApp->m_bAutoExport)
	{
		pApp->LogUserAction(_T("Doing m_bAutoExport from OnOpenDocument()"));
		wxLogNull logNo; // avoid spurious messages from the system

		// set up output path using m_autoexport_outputpath
		wxString docName = pApp->m_autoexport_docname;
		docName = MakeReverse(docName);
		docName = docName.Mid(4); // remove reversed ".xml"
		docName = MakeReverse(docName); // back to normal order without extension
		docName = docName + _T(".txt"); // make a plain text file
		pApp->m_curOutputFilename = docName;
		pApp->m_curOutputPath = pApp->m_autoexport_outputpath + pApp->PathSeparator + docName;

		// pinch what I need from ExportFunctions.cpp
		wxString target;	// a export data's buffer
		target.Empty();
		int nTextLength;
		nTextLength = RebuildTargetText(target);
		nTextLength = nTextLength; // avoid warning
		FormatMarkerBufferForOutput(target, targetTextExport);
		target = RemoveMultipleSpaces(target);
		// whm 19Sept2023 added to regularize the EOLs to CRLF and reduce multiple CRLFs to
		// a single CRLF
		NormalizeTextEOLsToCRLF(target, TRUE); // TRUE second parameter defaults bEndWithEOL to TRUE 

		// now write out the exported data string
		wxFile f;
		if (!f.Open(pApp->m_curOutputPath, wxFile::write))
		{
			wxString msg;
			msg = msg.Format(_("Unable to open the file for exporting the target text with path:\n%s"), pApp->m_curOutputPath.c_str());
			wxMessageBox(msg, _T(""), wxICON_EXCLAMATION | wxOK);
			pApp->LogUserAction(msg);
			if (nTotal > 0 && bShowProgress)
			{
				pStatusBar->FinishProgress(_("Opening the Document"));
			}
			pApp->OnExit();
			return FALSE;
		}
#ifndef _UNICODE // ANSI
		f.Write(target);
#else // _UNICODE
		wxFontEncoding enc = wxFONTENCODING_UTF8;
		pApp->ConvertAndWrite(enc, &f, target);
#endif // for _UNICODE
		f.Close();
		// shut down forcefully
		//pApp->OnExit();
		unsigned long pid = ::wxGetProcessId();
		enum wxKillError killErr;
		int rv = ::wxKill(pid, wxSIGTERM, &killErr); // makes OnExit() be called
		rv = rv; // prevent compiler warning
		if (nTotal > 0 && bShowProgress)
		{
			pStatusBar->FinishProgress(_("Opening the Document"));
		}

		return FALSE;
	}
	else
	{
		// whm added 7Mar12 code for fictitious read only access. If the m_bFictitiousReadOnlyAccess
		// flag is set, ForceFictitiousReadOnlyProtection() should be called before the call to
		// SetReadOnlyProtection().
		if (pApp->m_bFictitiousReadOnlyAccess)
		{
			pApp->m_pROP->ForceFictitiousReadOnlyProtection(pApp->m_curProjectPath);
		}

		// BEW added 13Nov09, for setting or denying ownership for writing permission.
		// This is something we want to do each time a doc is opened - if the local user
		// already has ownership for writing, no change is done and he retains it; but
		// if he had read only access, and the other person has relinquished the project,
		// then the local user will now get ownership. We do this here in the else block
		// because we don't want to support this functionality for automated adaptation
		// exports from the command line because those have the app open only for a few
		// seconds at most, and when they happen they change nothing so can be done
		// safely no matter who currently has ownership for writing.
		pApp->m_bReadOnlyAccess = pApp->m_pROP->SetReadOnlyProtection(pApp->m_curProjectPath);

		if (pApp->m_bReadOnlyAccess)
		{
			// if read only access is turned on, force the background colour change to show
			// now, instead of waiting for a user action requiring a canvas redraw
			pApp->GetView()->canvas->Refresh(); // needed? the call in OnIdle() is more effective

			// whm added 29Mar12. When read-only access is active, we don't show the phrasebox
			pApp->m_pTargetBox->HidePhraseBox(); // hides all three parts of the new phrasebox

			pApp->m_pTargetBox->Enable(FALSE); // whm 12July2018 Note: It is re-enabled in ResizeBox()
			pApp->m_pTargetBox->GetTextCtrl()->SetEditable(FALSE); // whm 12July2018 Note: SetEditable(TRUE) done in ResizeBox()
		}
		else
		{
			ValidateNoteStorage(); // ensure there are no bogus m_bHasNote flag values present
		}
	}

	if (nTotal > 0 && bShowProgress)
	{
		pStatusBar->FinishProgress(_("Opening the Document"));
	}

	// whm 15Oct2023 added. We're near the end of OnOpenDocument() and we need to ensure that
	// the Doc's variables and m_UsfmStructArr array are set up and populated for the current
	// document being opened by calling the Doc's SetupUsfmStructArrayAndFile() function.
	// When opening an existing document, there is a good chance that the user will be opening
	// a document that AI created before version 6.11.1 and there would not be any existing
	// <filename>.usfmstruct file to process. 
	// whm 2Apr2024 revision. The SetupUsfmStructArrayAndFile() function itself now internally
	// checks for the existence of the m_usfmStructDirPath and an appropriately populated 
	// <filename.usfmstruct file, and it creates them if necessary so we need not handle dir
	// and file existence matters here. Here we will just call the SetupUsfmStructArrayAndFile() 
	// function with appropriate parameters. 
	// . 
	m_usfmStructDirName = _T(".usfmstruct");
	wxFileName structFn(gpApp->m_curOutputPath);
	m_usfmStructFilePath = structFn.GetPath();
	m_usfmStructFileName = structFn.GetFullName(); // gets full name including extension, but excluding directories
	m_usfmStructDirPath = m_usfmStructFilePath + gpApp->PathSeparator + m_usfmStructDirName;
	m_usfmStructFilePathAndName = m_usfmStructDirPath + gpApp->PathSeparator + m_usfmStructFileName + m_usfmStructDirName;
	
	wxString unusedString; unusedString.Empty();
	bool bSetupOK;
	bSetupOK = SetupUsfmStructArrayAndFile(openExistingFile, unusedString, gpApp->m_pSourcePhrases);
	wxUnusedVar(bSetupOK);

	//if (!bSetupOK)
	//{
	//	// Not likely to happen so an English message is OK.
	//	wxString msg = _T("Adapt It could not set up the Usfm Struct Array or the .usfmstruct file.\n\nThis may affect the ability of Adapt It to filter or unfilter adjacent markers in correct sequence.");
	//	wxMessageBox(msg, _T(""), wxICON_WARNING | wxOK);
	//	pApp->LogUserAction(msg);
	//	m_bUsfmStructEnabled = FALSE; // the usfm struct routines are disabled
	//}
	/*

	if (!::wxDirExists(m_usfmStructDirPath))
	{
		// The hidden dir .usfmstruct doesn't exist yet so create it.
		bool bOK;
		bOK = ::wxMkdir(m_usfmStructDirPath);
		if (!bOK)
		{
			// failure to make the directory not expected so English message to the user log is sufficient
			wxString msg = _T("In OnNewDocument() - Failed to Create hidden directory at %s");
			msg = msg.Format(msg, m_usfmStructDirPath.c_str());
			gpApp->LogUserAction(msg);
			m_bUsfmStructEnabled = FALSE; // the usfm struct routines are disabled
		}
	}

	if (!::wxFileExists(m_usfmStructFilePathAndName))
	{

		wxString inputBuffer;
		inputBuffer.Empty();
		bool bSetupOK;
		bSetupOK = SetupUsfmStructArrayAndFile(createFromSPList, inputBuffer, gpApp->m_pSourcePhrases);
		if (!bSetupOK)
		{
			// Not likely to happen so an English message is OK.
			wxString msg = _T("Adapt It could not set up the Usfm Struct Array or the .usfmstruct file.\n\nThis may affect the ability of Adapt It to filter or unfilter adjacent markers in correct sequence.");
			wxMessageBox(msg, _T(""), wxICON_WARNING | wxOK);
			pApp->LogUserAction(msg);
			m_bUsfmStructEnabled = FALSE; // the usfm struct routines are disabled
		}
	}
	else
	{
		wxString unusedString; unusedString.Empty();
		bool bSetupOK;
		bSetupOK = SetupUsfmStructArrayAndFile(openExistingFile, unusedString);
		if (!bSetupOK)
		{
			// Not likely to happen so an English message is OK.
			wxString msg = _T("Adapt It could not set up the Usfm Struct Array or the .usfmstruct file.\n\nThis may affect the ability of Adapt It to filter or unfilter adjacent markers in correct sequence.");
			wxMessageBox(msg, _T(""), wxICON_WARNING | wxOK);
			pApp->LogUserAction(msg);
			m_bUsfmStructEnabled = FALSE; // the usfm struct routines are disabled
		}
	}
	*/

	// We should update the .usfmstruct file (that was created when 
	// document was first created) with current filter status information. We do that by calling the Doc function:
	// UpdateCurrentFilterStatusOfUsfmStructFileAndArray().
	if (m_bUsfmStructEnabled)
	{
		UpdateCurrentFilterStatusOfUsfmStructFileAndArray(m_usfmStructFilePathAndName);
	}

	// BEW 12Feb20 added call to check if the adaptation KB has any placeholder items stored
	// within - if any are found then this function removes them. Observing workflow as
	// Yolngu translators did their adapting at Milingimbi island, a placehold coming up with
	// a huge long list of useless saved tgt text items is just a nuisance. It needs to come
	// up with its phrasebox empty, ready for a meaning to be typed; and the meaning needs
	// to be blocked from entering the adapting KB (there are no stored placeholders in the
	// glossing KB) - so there's also a little block of code near top of StoreText() to cause
	// control to exit if the CSourcePhrase is m_bNullSourcePhrase TRUE and m_bRetranslation
	// is FALSE. The adaptation KB for this project is guaranteed to be read in and ready by now.
//	pApp->m_pKB->RemoveManuallyEnteredPlaceholdersFromKB();

	// update status bar with project name
	pApp->RefreshStatusBarInfo();

	//#if defined(_KBSERVER)
	if (pApp->m_bIsKBServerProject || pApp->m_bIsGlossingKBServerProject)
	{
		// BEW 28Apr16 cause OnIdle() to get authentication done, after wizard completes
		pApp->m_bEnteringKBserverProject = TRUE;
	}
	//#endif

		// whm 2Sept2021 added support for setting up an AutoCorrect feature to operate within 
		// the opened non-collaboration document.
		// NOTE: OnOpenDocument() only handles the opening of non-Collaboration documents. 
		// The setup up of AutoCorrect for collaboration document openings is done at the
		// end of the OK_btn_delayedHandler_GetSourceTextFromEditor() function in the 
		// CollabUtilities.cpp file.
	SetupAutoCorrectHashMap();

	pApp->m_bDocumentDestroyed = FALSE; // re-initialize (to permit DoAutoSaveDoc() to work)

	return TRUE;
}

CLayout* CAdapt_ItDoc::GetLayout()
{
	CAdapt_ItApp* pApp = &wxGetApp();
	return pApp->m_pLayout;
}

// return the CPile* at the passed in index, or NULL if the index is out of bounds;
// the pile list is at CLayout::m_pileList.
// CAdapt_ItView also has a member function of the same name
CPile* CAdapt_ItDoc::GetPile(const int nSequNum)
{
	// refactored 10Mar09, for new view layout design (no bundles)
	CLayout* pLayout = GetLayout();
	wxASSERT(pLayout != NULL);
	PileList* pPiles = pLayout->GetPileList();
	int nCount = pPiles->GetCount();
	if (nSequNum < 0 || nSequNum >= nCount)
	{
		// bounds error, so return NULL
		return (CPile*)NULL;
	}
	PileList::Node* pos_pPle = pPiles->Item(nSequNum); // relies on parallelism of
								// the m_pSourcePhrases and m_pileList lists
	wxASSERT(pos_pPle != NULL);
	return pos_pPle->GetData();
}

///////////////////////////////////////////////////////////////////////////////
/// \return TRUE if the current document has been modified; FALSE otherwise
/// \remarks
/// Called from: the App's GetDocHasUnsavedChanges(), OnUpdateFileSave(), OnSaveModified(),
/// CMainFrame's SyncScrollReceive() and OnIdle().
/// Internally calls the wxDocument::IsModified() method and the canvas->IsModified() method.
///////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItDoc::IsModified() const // from wxWidgets mdi sample
{
	CAdapt_ItView* view = (CAdapt_ItView*)GetFirstView();

	if (view)
	{
		return (wxDocument::IsModified() || wxGetApp().GetMainFrame()->canvas->IsModified());
	}
	else
		return wxDocument::IsModified();
}

///////////////////////////////////////////////////////////////////////////////
/// \return nothing
/// \param mod		-> if FALSE, discards any edits
/// \remarks
/// Called from: all places that need to set the document as either dirty or clean including:
/// the App's DoUsfmFilterChanges() and DoUsfmSetChanges(), the Doc's OnNewDocument(),
/// OnFileSave(), OnCloseDocument(), the View's PlacePhraseBox(), StoreText(), StoreTextGoingBack(),
/// ClobberDocument(), OnAdvancedRemoveFilteredFreeTranslations(), OnButtonDeleteAllNotes(),
/// OnAdvancedRemoveFilteredBacktranslations(), the DocPage's OnWizardFinish(), the CKBEditor's
/// OnButtonUpdate(), OnButtonAdd(), OnButtonRemove(), OnButtonMoveUp(), OnButtonMoveDown(),
/// the CNoteDlg's OnBnClickedNextBtn(), OnBnClickedPrevBtn(),
/// OnBnClickedFirstBtn(), OnBnClickedLastBtn(), OnBnClickedFindNextBtn(), the CPhraseBox's
/// OnPhraseBoxChanged(), CViewFilteredMaterialDlg's UpdateContentOnRemove(), OnOK(),
/// OnBnClickedRemoveBtn(), and (BEW added 28Nov12), the ViewFilteredMaterialDlg's OnOK() button.
/// Sets the Doc's dirty flag according to the value of mod by calling wxDocument::Modify(mod).
///////////////////////////////////////////////////////////////////////////////
void CAdapt_ItDoc::Modify(bool mod) // from wxWidgets mdi sample
{
	CAdapt_ItView* view = (CAdapt_ItView*)GetFirstView();
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	wxDocument::Modify(mod);

	if (!mod && view && pApp->GetMainFrame()->canvas)
		pApp->GetMainFrame()->canvas->DiscardEdits();
}


///////////////////////////////////////////////////////////////////////////////
/// \return nothing
/// \param      pList -> pointer to a SPList of source phrases
/// \remarks
/// Called from: the View's InitializeEditRecord(), OnEditSourceText(),
/// OnCustomEventAdaptationsEdit(), and OnCustomEventGlossesEdit().
/// If pList has any items this function calls DeleteSingleSrcPhrase() for each
/// item in the list. The boolean parameter is default FALSE (i.e. default is to
/// not attempt partner pile deletion)
/// BEW 26Mar10, no changes needed for support of doc version 5
///////////////////////////////////////////////////////////////////////////////
void CAdapt_ItDoc::DeleteSourcePhrases(SPList* pList, bool bDoPartnerPileDeletionAlso)
{
	// BEW added 21Apr08 to pass in a pointer to the list which is to be deleted (overload
	// of the version which has no input parameters and internally assumes the list is
	// m_pSourcePhrases) This new version is required so that in the refactored Edit Source
	// Text functionality we can delete the deep-copied sublists using this function.
	// BEW modified 27May09, to take the bool bDoPartnerPileDeletionAlso parameter,
	// defaulting to FALSE because the deep copied sublists never have partner piles
	//CAdapt_ItApp* pApp = &wxGetApp();
	//wxASSERT(pApp != NULL);
	// BEW 25Jun13 added next two lines, somehow on a new project this pList pointer would
	// go NULL, when first opening a doc file copied from elsewhere as the first doc of
	// the project
	if (pList == NULL)
		return;
	if (pList != NULL)
	{
		if (!pList->IsEmpty())
		{
			// delete all the tokenizations of the source text
			SPList::Node* node = pList->GetFirst();
			while (node)
			{
				CSourcePhrase* pSrcPhrase = (CSourcePhrase*)node->GetData();
				node = node->GetNext();
#ifdef _DEBUG
				//wxLogDebug(_T("   DeleteSourcePhrases pSrcPhrase at %p = %s"),
				//pSrcPhrase->m_srcPhrase, pSrcPhrase->m_srcPhrase.c_str());
#endif
				DeleteSingleSrcPhrase(pSrcPhrase, bDoPartnerPileDeletionAlso); // default
					// for the boolean passed in to DeleteSourcePhrases() is FALSE
			}
			pList->Clear();
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \return nothing
/// \remarks
/// Called from: the Doc's DeleteContents(), the View's ClobberDocument().
/// If the App's m_pSourcePhrases SPList has any items this function calls
/// DeleteSingleSrcPhrase() for each item in the list.
///////////////////////////////////////////////////////////////////////////////
void CAdapt_ItDoc::DeleteSourcePhrases()
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);

	//#define BOGUS_PREDELETE_OF_CSOURCEPHRASE_BUG
#ifdef BOGUS_PREDELETE_OF_CSOURCEPHRASE_BUG
#ifdef _DEBUG
	// In collaboration mode, one or more CSourcePhrase instances are being prematurely
	// deleted, and so when DeleteSingleSrcPhrase() is called on such ones (eg. as when
	// shutting down the app with the X button at top of window, which causes
	// OnCloseDocument() to be called) then a heap corruption error message results with
	// the message:
	// HEAP: Free Heap block <hex address> modified at <hex address> after it was freed
	// and the error can happen at an unexpected time too (but much rarer). Doc layout
	// doesn't crash, which makes me think it is in the saved m_pSavedWords instances that
	// the bogus deletions have happened. The code below scans all the parent pSrcPhrase
	// instances in the doc, and also any in their non-empty m_pSavedWords members, to
	// show in the Output window the sequ number the m_srcPhrase member. The idea is that
	// if there is a hanging ptr somewhere, the scan and display in the Output window will
	// cease at that point -- which tells us at least something useful. Added display of
	// the heap pointer value  (in hex) for each CSourcePhrase instance - so as to match
	// with the error report, since the error happens after this successful display of all of
	// the CSourcePhrase instances in the m_pSourcePhrase list.
	//
	// The bug fix? Bill found I'd used UngetWriteBuf() in wxString to restore a read-only
	// buffer I'd created with GetData() call - this is verbotten, and leads to heap
	// corruption; UngetWriteBuf() should only be used after a GetWriteBuf() call. I'd
	// made this error in two places.
	{

		SPList* pSrcPhrases = pApp->m_pSourcePhrases;
		if (pSrcPhrases != NULL)
		{
			SPList::Node* pos_pSP = pSrcPhrases->GetFirst();
			int sequnum = 0;
			int originalSN = 0;
			wxString srcStr;
			wxString originalSrcStr;
			CSourcePhrase* pOriginalSP = NULL;
			CSourcePhrase* pSrcPhrase = NULL; // parent ones, the ones laid out by RecalcLayout()
			// now scan over the whole doc, showing the info needed
			while (pos_pSP != NULL)
			{
				pSrcPhrase = pos_pSP->GetData();
				pos_pSP = pos_pSP->GetNext();
				sequnum = pSrcPhrase->m_nSequNumber;
				srcStr = pSrcPhrase->m_srcPhrase;
//				wxLogDebug(_T("\n ********************* Parent CSourcePhrase *************************"));
//				wxLogDebug(_T("sn = %d  srcPhrase = %s   HEX  %p"), sequnum, srcStr.c_str(), pSrcPhrase);
				if (!pSrcPhrase->m_pSavedWords->IsEmpty())
				{
//					wxLogDebug(_T("\n              ********       Originals      ********"));
					SPList* pOriginals = pSrcPhrase->m_pSavedWords;
					SPList::Node* posOriginal = pOriginals->GetFirst();
					while (posOriginal != NULL)
					{
						pOriginalSP = posOriginal->GetData();
						posOriginal = posOriginal->GetNext();
						// access members for display (this will crash if it's heap block has been freed)
						originalSN = pOriginalSP->m_nSequNumber;
						originalSrcStr = pOriginalSP->m_srcPhrase;
						// display info in the Output window
//						wxLogDebug(_T("              sn = %d  srcPhrase = %s   HEX  %p"),
//							originalSN, originalSrcStr.c_str(), pOriginalSP);
					}
				}
//				wxLogDebug(_T("    -------------------------------------------------"));
			} // loop ends
		}
	}
#endif
#endif

	if (pApp->m_pSourcePhrases != NULL)
	{
		if (!pApp->m_pSourcePhrases->IsEmpty())
		{
			// delete all the tokenizations of the source text
			SPList::Node* node = pApp->m_pSourcePhrases->GetFirst();
			while (node)
			{
				CSourcePhrase* pSrcPhrase = (CSourcePhrase*)node->GetData();
				node = node->GetNext();
#ifdef BOGUS_PREDELETE_OF_CSOURCEPHRASE_BUG
#ifdef _DEBUG && !defined(NOLOGS)
				wxString msg;
				msg = msg.Format(_T("Deleting    %s    at sequ num =  %d"),
					pSrcPhrase->m_srcPhrase.c_str(), pSrcPhrase->m_nSequNumber);
				wxLogDebug(msg);
#endif
#endif
				DeleteSingleSrcPhrase(pSrcPhrase, FALSE); // FALSE is the
					// value for bDoPartnerPileDeletionAlso, because it is
					// more efficient to delete them later en masse with a call
					// to CLayout::DestroyPiles(), rather than one by one, as
					// the  one by one way involves a search to find the
					// partner, so it is slower
			}
			pApp->m_pSourcePhrases->Clear();
		}
	}
#ifdef BOGUS_PREDELETE_OF_CSOURCEPHRASE_BUG
#ifdef _DEBUG && !defined(NOLOGS)
	{
		wxString msg;
		msg = msg.Format(_T("Cleared  m_pSourcePhrases at end of DeleteSourcePhrases()"));
		wxLogDebug(msg);
	}
#endif
#endif
}

///////////////////////////////////////////////////////////////////////////////
/// \return nothing
/// \param		pSrcPhrase -> the source phrase to be deleted
/// \remarks
/// Deletes the passed in CSourcePhrase instance, and if the bDoPartnerPileDeletionAlso bool value
/// is TRUE (its default value), then the partner pile in the CLayout::m_pileList list which
/// points at it is also deleted. Pass FALSE for this boolean if the CSourcePhrase being destroyed
/// is a temporary one in a list other than m_pSourcePhrases.
///
/// Called from: the App's DoTransformationsToGlosses(), DeleteSourcePhraseListContents(),
/// the Doc's DeleteSourcePhrases(), ConditionallyDeleteSrcPhrase(),
/// ReconstituteOneAfterPunctuationChange(), ReconstituteOneAfterFilteringChange(),
/// DeleteListContentsOnly(), ReconstituteAfterPunctuationChange(), the View's
/// ReplaceCSourcePHrasesInSpan(), TransportWidowedEndmarkersToFollowingContext(),
/// TransferCOmpletedSrcPhrases(), and CMainFrame's DeleteSourcePhrases_ForSyncScrollReceive().
///
/// Clears and deletes any m_pMedialMarkers, m_pMedialPuncts and m_pSavedWords before deleting
/// pSrcPhrase itself.
/// BEW 11Oct10, to support doc version 5's better handling of USFM fixedspace symbol ~,
/// we also must delete instances storing word1~word2 kind of content - if ~ is present,
/// then m_pSavedWords will contain two child CSourcePhrase pointers also to be deleted -
/// fortunately no code changes are needed to handle this.
/// BEW 13Sep22 add code to delete any cached data
///////////////////////////////////////////////////////////////////////////////
void CAdapt_ItDoc::DeleteSingleSrcPhrase(CSourcePhrase* pSrcPhrase, bool bDoPartnerPileDeletionAlso)
{
	// refactored 12Mar09
	if (pSrcPhrase == NULL)
		return;

	// if requested delete the CPile instance in CLayout::m_pileList which
	// points to this pSrcPhrase
	if (bDoPartnerPileDeletionAlso)
	{
		// this call is safe to make even if there is no partner pile, or if a matching
		// pointer is not in the list
		DeletePartnerPile(pSrcPhrase); // marks its strip as invalid as well
	}

	// 13Sep22 remove any cached string, only works right if pSrcPhrase->m_bHasInternalPunct is FALSE,
	// so set it false then call ClearCachedAttributesMetadata()
	pSrcPhrase->m_bHasInternalPunct = FALSE;
	//pSrcPhrase->ClearCachedAttributesMetadata();

	if (pSrcPhrase->m_pMedialMarkers != NULL)
	{
		if (pSrcPhrase->m_pMedialMarkers->GetCount() > 0)
		{
			pSrcPhrase->m_pMedialMarkers->Clear();
		}
		delete pSrcPhrase->m_pMedialMarkers;
		pSrcPhrase->m_pMedialMarkers = (wxArrayString*)NULL;
	}

	if (pSrcPhrase->m_pMedialPuncts != NULL)
	{
		if (pSrcPhrase->m_pMedialPuncts->GetCount() > 0)
		{
			pSrcPhrase->m_pMedialPuncts->Clear();
		}
		delete pSrcPhrase->m_pMedialPuncts;
		pSrcPhrase->m_pMedialPuncts = (wxArrayString*)NULL;
	}

	// also delete any saved CSourcePhrase instances forming a phrase (and these
	// will never have medial puctuation nor medial markers nor will they store
	// any saved minimal phrases since they are CSourcePhrase instances for single
	// words only (nor will it point to any CRefString instances) (but these will
	// have SPList instances on heap, so must delete those)
	// BEW note, 11Oct10, this block will also handle deletion of conjoined words using
	// USFM fixedspace symbol, ~
	if (pSrcPhrase->m_pSavedWords != NULL)
	{
		if (pSrcPhrase->m_pSavedWords->GetCount() > 0)
		{
			SPList::Node* node = pSrcPhrase->m_pSavedWords->GetFirst();
			while (node)
			{
				CSourcePhrase* pSP = (CSourcePhrase*)node->GetData();
				node = node->GetNext(); // need this for wxList
				if (pSP->m_pSavedWords != NULL) // whm 11Jun12 added NULL test
					delete pSP->m_pSavedWords;
				pSP->m_pSavedWords = (SPList*)NULL;
				if (pSP->m_pMedialMarkers != NULL) // whm 11Jun12 added NULL test
					delete pSP->m_pMedialMarkers;
				pSP->m_pMedialMarkers = (wxArrayString*)NULL;
				if (pSP->m_pMedialPuncts != NULL) // whm 11Jun12 added NULL test
					delete pSP->m_pMedialPuncts;
				pSP->m_pMedialPuncts = (wxArrayString*)NULL;
				if (pSP != NULL) // whm 11Jun12 added NULL test
					delete pSP;
				pSP = (CSourcePhrase*)NULL;
			}
		}
		if (pSrcPhrase->m_pSavedWords != NULL) // whm 11Jun12 added NULL test
			delete pSrcPhrase->m_pSavedWords; // delete the SPList* too
		pSrcPhrase->m_pSavedWords = (SPList*)NULL;
	}
	if (pSrcPhrase != NULL) // whm 11Jun12 added NULL test
		delete pSrcPhrase;
	pSrcPhrase = (CSourcePhrase*)NULL;
}

///////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \param		pSrcPhrase -> the source phrase that was deleted
/// \remarks
/// Created 12Mar09 for layout refactoring. The m_pileList's CPile instances point to
/// CSourcePhrase instances and deleting a CSourcePhrase from the doc's m_pSourcePhrases
/// list usually needs to also have the CPile instance which points to it also deleted from
/// the corresponding place in the m_pileList. That task is done here. Called from
/// DeleteSingleSrcPhrase(), the latter having a bool parameter,
/// bDoPartnerPileDeletionAlso, which defaults to TRUE, and when FALSE is passed in this
/// function will not be called. (E.g. when the source phrase belongs to a temporary list
/// and so has no partner pile)
/// Note: the deletion will be done for some particular pSrcPhrase in the app's
/// m_pSourcePhrases list, and we want to have at least an approximate idea of the index
/// of which strip the copy of the pile pointer was in, because when we tweak the layout
/// we will want to know which strips to concentrate our efforts on. Therefore before we
/// do the deletion, we work out which strip the pile belongs to, mark it as invalid, and
/// store its index in CLayout::m_invalidStripArry. Later, our strip tweaking code will
/// use this information to make a speedy tweak of the layout before drawing is done (but
/// the information is not used whenever RecalcLayout() does a full rebuild of the
/// document's strips)
///////////////////////////////////////////////////////////////////////////////
void CAdapt_ItDoc::DeletePartnerPile(CSourcePhrase* pSrcPhrase)
{
	// refactored 4May09
	CLayout* pLayout = GetLayout();
	PileList* pPiles = pLayout->GetPileList();
	if (pPiles->IsEmpty())
		return;
	PileList::Node* posPile = pPiles->GetFirst();
	wxASSERT(posPile != NULL);
	CPile* pPile = NULL;
	while (posPile != NULL)
	{
		pPile = posPile->GetData();
		if (pSrcPhrase == pPile->GetSrcPhrase())
		{
			// we have found the partner pile, so break out
			break;
		}
		posPile = posPile->GetNext(); // go to next Node*
	} // end of while loop with test: posPile != NULL
	if (posPile == NULL)
	{
		return; // we didn't find a partner pile, so just return;
	}
	else
	{
		// found the partner pile in CLayout::m_pileList, so delete it...

		// get the CPile* instance currently at index, from it we can determine which strip
		// the deletion will take place from (even if we get this a bit wrong, it won't
		// matter)
		pPile = posPile->GetData();
		wxASSERT(pPile != NULL);
		MarkStripInvalid(pPile); // sets CStrip::m_bValid to FALSE, and adds the
								 // strip index to CLayout::m_invalidStripArray

		// now go ahead and get rid of the partner pile for the passed in pSrcPhrase
		pPile->SetStrip(NULL);

		// if destroying the CPile instance pointed at by app's m_pActivePile, set the
		// latter to NULL as well (otherwise, in the debugger it would have the value
		// 0xfeeefeee which is useless for pile ptr != NULL tests as it gives a spurious
		// positive result
		if (pLayout->m_pApp->m_nActiveSequNum != -1 && pLayout->m_pApp->m_pActivePile == pPile)
		{
			pLayout->m_pApp->m_pActivePile = NULL;
		}
		pLayout->DestroyPile(pPile, pLayout->GetPileList()); // destroy the pile, & remove
					// its node from m_pileList, because bool param, bRemoveFromListToo, is
					// default TRUE
		pPile = NULL;
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \param		pSrcPhrase -> the source phrase that was created and inserted in the
///                           application's m_pSourcePhrases list
/// \remarks
/// Created 13Mar09 for layout refactoring. The m_pileList's CPile instances point to
/// CSourcePhrase instances and creating a new CSourcePhrase for the doc's m_pSourcePhrases
/// list always needs to have the CPile instance which points to it also created,
/// initialized and inserted into the corresponding place in the m_pileList. That task is
/// done here.
///
/// Called from various places. It is not made a part of the CSourcePhrase creation process
/// for a good reason. Quite often CSourcePhrase instances are created and are only
/// temporary - such as those deep copied to be saved in various local lists during the
/// vertical edit process, and in quite a few other contexts as well. Also, when documents
/// are loaded from disk and very many CSourcePhrase instances are created in that process,
/// it is more efficient to not create CPile instances as part of that process, but rather
/// to create them all in a loop after the document has been loaded. For example, the
/// current code creates new CSourcePhrases on the heap in about 30 places in the app's
/// code, but only about 25% of those instances require a CPile partner created for the
/// CLayout::m_pileList; therefore we call CreatePartnerPile() only when needed, and it
/// should be called immediately after a newly created CSourcePhrase has just been inserted
/// into the app's m_pSourcePhrases list - so that the so that the strip where the changes
/// happened can be marked as "invalid".
/// Note: take care when CSourcePhrase(s) are appended to the end of the m_pSourcePhrases
/// list, because Creating the partner piles cannot handle discontinuities in the sequence
/// of piles in PileList. So, iterate from left to right over the new pSrcPhrase at the
/// list end, so that each CreatePartnerPile call is creating the CPile instance which is
/// next to be appended to PileList. We test for non-compliance with this rule and abort
/// the application if it happens, because to continue would inevitably lead to an app crash.
/// BEW 20Jan11, replacing partner piles is a problem in some circumstances, because the
/// pile count could change larger and so some new piles can't then be assigned to a
/// strip. This circumstance needs create_strips_keep_piles to be used for the
/// layout_selector enum value in RecalcLayout() in order to get the strips and piles in
/// sync; this comment is for information only, no code was changed below, except the
/// addition of AddUniqueInt() (an unrelated issue, the latter is to prevent duplicate
/// strip indices being stored in the m_invalidStripArray of CLayout)
///////////////////////////////////////////////////////////////////////////////
void CAdapt_ItDoc::CreatePartnerPile(CSourcePhrase* pSrcPhrase)
{
	// refactor 13Mar09
	CLayout* pLayout = GetLayout();
	int index = IndexOf(pSrcPhrase); // the index in m_pSourcePhrases for the passed
									 // in pSrcPhrase

	PileList::Node* aPosition = NULL;
	CPile* aPilePtr = NULL;
	wxASSERT(index != wxNOT_FOUND); // it must return a valid index!
	PileList* pPiles = pLayout->GetPileList();

	// if the pSrcPhrase is one added to the end of the document, there won't be any
	// existing pile pointers in the PileList with indices that large, so check for this
	// because an Item(index) call with an index out of range will crash the app, it
	// doesn't return a NULL which is what I erroneously though would happen
	PileList::Node* posPile = NULL;
	int lastPileIndex = pLayout->GetPileList()->GetCount() - 1;
	bool bAppending = FALSE;
	if (index > lastPileIndex + 1)
	{
		// we've skipped a pile somehow, this is a fatal error, tell developer and abort
		wxMessageBox(_T(
			"Ouch! CreatePartnerPile() has skipped a pSrcPhrase added to doc end, or they creations are not being done in left to right sequence. Must abort now."),
			_T(""), wxICON_ERROR | wxOK);
		wxASSERT(FALSE);
		wxExit();
	}
	else if (index == lastPileIndex + 1)
	{
		// we are creating the CPile instance which is due to be appended next tp PileList
		bAppending = TRUE;
	}
	else
	{
		// if control gets here with bAppending still FALSE, then an insertion is required
		posPile = pPiles->Item(index);
	}
	CPile* pNewPile = pLayout->CreatePile(pSrcPhrase); // creates a detached CPile
					// instance, initializes it, sets m_nWidth and m_nMinWidth etc
	if (!bAppending)
	{
		// we are inserting a new partner pile's pointer in the CLayout::m_pileList does
		// not get it also inserted in the CLayout::m_stripArray, and so the laid out
		// strips don't know of it. However, we can work out which strip it would be
		// inserted within, or thereabouts, and mark that strip as invalid and put its
		// index into CLayout::m_invalidStripArray. The inventory of invalid strips does
		// not have to be 100% reliable - they are approximate indicators where the layout
		// needs to be tweaked, which is all we need for the RecalcLayout() call later on.
		// Therefore, use the current pPile pointer in the m_pileList at index, and find
		// which strip that one is in, even though it is not the newly created CPile
		aPosition = pPiles->Item(index);
		aPilePtr = aPosition->GetData();
		if (aPilePtr != NULL)
			MarkStripInvalid(aPilePtr); // use aPilePtr to have a good shot at which strip
				// will receive the newly created pile, and mark it as invalid, and save
				// its index in CLayout::m_invalidStripArray; nothing is done if
				// aPilePtr->m_pOwningStrip is NULL

		// the indexed location is within the unaugmented CLayout::m_pileList; therefore an
		// insert operation is required; the index posPile value determined by index is the
		// place where the insertion must be done
		posPile = pPiles->Insert(posPile, pNewPile);
	}
	else
	{
		// appending, (see comment in block above for more details), so just mark the last
		// strip in m_stripArray as invalid, don't call MarkStripInvalid()
		aPosition = pPiles->GetLast(); // the one after which we will append the new one
		aPilePtr = aPosition->GetData();
		if (aPilePtr != NULL)
		{
			// do this manually... just mark the last strip as the invalid one, etc
			CStrip* pLastStrip = (CStrip*)pLayout->GetStripArray()->Last();
			pLastStrip->SetValidityFlag(FALSE); // makes m_bValid be FALSE
			int nStripIndex = pLastStrip->GetStripIndex();
			// BEW 20Jan11, changed to only add unique index values to the array
			AddUniqueInt(pLayout->GetInvalidStripArray(), nStripIndex); // this array makes
									// it easy to quickly compute which strips are invalid
		}
		// now do the append
		posPile = pPiles->Append(pNewPile); // do this only after aPilePtr is calculated
	}
}

// return the index in m_pSourcePhrases for the passed in pSrcPhrase
int CAdapt_ItDoc::IndexOf(CSourcePhrase* pSrcPhrase)
{
	wxASSERT(pSrcPhrase != NULL);
	SPList* pList = GetApp()->m_pSourcePhrases;
	int nIndex = pList->IndexOf(pSrcPhrase);
	return nIndex;
}

void CAdapt_ItDoc::ResetPartnerPileWidth(CSourcePhrase* pSrcPhrase,
	bool bNoActiveLocationCalculation)
{
	wxUnusedVar(bNoActiveLocationCalculation);

		// refactored 13Mar09 & some more on 27Apr09
	int index = IndexOf(pSrcPhrase); // the index in m_pSourcePhrases for the passed in
									 // pSrcPhrase, in the app's m_pSourcePhrases list
	wxASSERT(index != wxNOT_FOUND); // it must return a valid index!
	PileList* pPiles = GetLayout()->GetPileList();
	PileList::Node* posPile = pPiles->Item(index); // returns NULL if index lies beyond
												   // the end of m_pileList
	if (posPile != NULL)
	{
		CPile* pPile = posPile->GetData();
		wxASSERT(pPile != NULL);
		pPile->m_nMinWidth = pPile->CalcPileWidth(); // set m_nMinWidth - it's the maximum extent of the src,
							  // adapt or gloss text
		// mark the strip invalid and put the parent strip's index into
		// CLayout::m_invalidStripArray if it is not in the array already
		MarkStripInvalid(pPile);
	}
	else
	{
		// if it is null, this is a catastrophic error, and we must terminate the application;
		// or in DEBUG mode, give the developer a chance to look at the call stack
		wxMessageBox(_T(
			"Ouch! ResetPartnerPileWidth() was unable to find the partner pile. Must abort now."),
			_T(""), wxICON_EXCLAMATION | wxOK);
		wxASSERT(FALSE);
		wxExit();
	}
}

void CAdapt_ItDoc::MarkStripInvalid(CPile* pChangedPile)
{
	CLayout* pLayout = GetLayout();
	// we can mark a strip invalid only provided it exists; so if calling this in
	// RecalcLayout() after the strips were destroyed, and before they are rebuilt, we'd
	// be trying to access freed memory if we went ahead here without a test for strips
	// being in existence - so return if the m_stripArray has no contents currently
	if (pLayout->GetStripArray()->IsEmpty())
		return;
	// pChangedPile has to have a valid m_pOwningStrip (ie. a non-zero value), which may
	// not be the case for a set of newly created piles at the end of the document, so for
	// end-of-document scenarios we will code the caller to just assume the last of the
	// current strips and not call MarkStripInvalid() at all; but just in case one sneaks
	// through, test here and if it has a zero m_pOwningStrip value then exit without
	// doing anything (unfortunately we can't assume it will always be at the doc end)
	if (pChangedPile->GetStrip() == NULL)
	{
		// it's a newly created pile not yet within the current set of strips, so its
		// m_pOwningStrip member returned was NULL, we shouldn't have called this
		// function for this pChangedPile pointer, but since we did, we can only return
		// without doing anything
		return;
	}
	// if control gets to here, there are CStrip pointers stored in m_stripArray, and there
	// is an owning strip defined, so go ahead and mark the owning strip invalid
	wxArrayInt* pInvalidStripArray = pLayout->GetInvalidStripArray();
	CStrip* pStrip = pChangedPile->GetStrip();
	pStrip->SetValidityFlag(FALSE); // makes m_bValid be FALSE
	int nStripIndex = pStrip->GetStripIndex();
	// BEW 20Jan11, changed to only add unique index values to the array
	AddUniqueInt(pInvalidStripArray, nStripIndex); // this array makes it easy to quickly
												   // compute which strips are invalid
}

///////////////////////////////////////////////////////////////////////////////
/// \return nothing
/// \param		pSrcPhrase -> the source phrase to be deleted
/// \param		pOtherList -> another list of source phrases
/// \remarks
/// Called from : the Doc's ReconstituteAfterPunctuationChange().
/// This function is used in document reconstitution after a punctuation change forces a
/// rebuild.
/// Clears and deletes any m_pMedialMarkers, m_pMedialPuncts before deleting
/// pSrcPhrase itself.
/// SmartDeleteSingleSrcPhrase deletes only those pSrcPhrase instances in its m_pSavedWords
/// list which are not also in the pOtherList.
///////////////////////////////////////////////////////////////////////////////
void CAdapt_ItDoc::SmartDeleteSingleSrcPhrase(CSourcePhrase* pSrcPhrase, SPList* pOtherList)
{
	// refactored 12Mar09 - nothing was done here because it can be called only in
	// ReconstituteAdfterPunctuationChange() - and only then provided a merger could not be
	// reconstituted -- and so because all partner piles will need to be recreated anyway,
	//  just dealing with a few is pointless; code in that function will handle all instead
	if (pSrcPhrase == NULL)
		return;

	if (pSrcPhrase->m_pMedialMarkers != NULL)
	{
		if (pSrcPhrase->m_pMedialMarkers->GetCount() > 0)
		{
			pSrcPhrase->m_pMedialMarkers->Clear();
		}
		delete pSrcPhrase->m_pMedialMarkers;
	}

	if (pSrcPhrase->m_pMedialPuncts != NULL)
	{
		if (pSrcPhrase->m_pMedialPuncts->GetCount() > 0)
		{
			pSrcPhrase->m_pMedialPuncts->Clear();
		}
		delete pSrcPhrase->m_pMedialPuncts;
	}

	// also delete any saved CSourcePhrase instances forming a phrase (and these
	// will never have medial puctuation nor medial markers nor will they store
	// any saved minimal phrases since they are CSourcePhrase instances for single
	// words only (nor will it point to any CRefString instances) (but these will
	// have SPList instances on heap, so must delete those)
	if (pSrcPhrase->m_pSavedWords != NULL)
	{
		if (pSrcPhrase->m_pSavedWords->GetCount() > 0)
		{
			SPList::Node* pos_pSavedWords = pSrcPhrase->m_pSavedWords->GetFirst();
			while (pos_pSavedWords != NULL)
			{
				CSourcePhrase* pSP = (CSourcePhrase*)pos_pSavedWords->GetData();
				pos_pSavedWords = pos_pSavedWords->GetNext();
				SPList::Node* pos_otherList = pOtherList->Find(pSP);
				if (pos_otherList != NULL)
					continue; // it's in the other list, so don't delete it
				if (pSP->m_pSavedWords != NULL) // whm 11Jun12 added NULL test
					delete pSP->m_pSavedWords;
				if (pSP->m_pMedialMarkers != NULL) // whm 11Jun12 added NULL test
					delete pSP->m_pMedialMarkers;
				if (pSP->m_pMedialPuncts != NULL) // whm 11Jun12 added NULL test
					delete pSP->m_pMedialPuncts;
				if (pSP != NULL) // whm 11Jun12 added NULL test
					delete pSP;
			}
		}
		pSrcPhrase->m_pSavedWords->Clear();
		if (pSrcPhrase->m_pSavedWords != NULL) // whm 11Jun12 added NULL test
			delete pSrcPhrase->m_pSavedWords; // delete the SPList* too
	}
	if (pSrcPhrase != NULL) // whm 11Jun12 added NULL test
		delete pSrcPhrase;
}

// transfer info about punctuation which got changed, but which doesn't get transferred to
// the original pSrcPhrase (here, pDestSrcPhrase) from the new one resulting from the
// tokenization, for a conjoined pair (the new one is pFromSrcPhrase), unless we do it herein
void CAdapt_ItDoc::TransferFixedSpaceInfo(CSourcePhrase* pDestSrcPhrase, CSourcePhrase* pFromSrcPhrase)
{
	CSourcePhrase* pDestWord1SPh = NULL;
	CSourcePhrase* pDestWord2SPh = NULL;
	CSourcePhrase* pFromWord1SPh = NULL;
	CSourcePhrase* pFromWord2SPh = NULL;
	SPList::Node* destPos = pDestSrcPhrase->m_pSavedWords->GetFirst();
	pDestWord1SPh = destPos->GetData();
	destPos = pDestSrcPhrase->m_pSavedWords->GetLast();
	pDestWord2SPh = destPos->GetData();
	SPList::Node* fromPos = pFromSrcPhrase->m_pSavedWords->GetFirst();
	pFromWord1SPh = fromPos->GetData();
	fromPos = pFromSrcPhrase->m_pSavedWords->GetLast();
	pFromWord2SPh = fromPos->GetData();
	pDestWord1SPh->m_precPunct = pFromWord1SPh->m_precPunct; // copy any m_precPunct to list's first one
	pDestSrcPhrase->m_precPunct = pFromWord1SPh->m_precPunct; // put it also at top level
	pDestWord2SPh->m_follPunct = pFromWord2SPh->m_follPunct; // copy any 2nd word's m_follPunct to list's second one
	pDestSrcPhrase->m_follPunct = pFromWord2SPh->m_follPunct; // put it also at top level
	// handle transfer of m_follOuterPunct data
	pDestWord2SPh->SetFollowingOuterPunct(pFromWord2SPh->GetFollowingOuterPunct());
	pDestSrcPhrase->SetFollowingOuterPunct(pFromWord2SPh->GetFollowingOuterPunct()); // put it also at top level
	// the "outer" ones are handled, the "inner ones" are next - these are stored only on
	// the instances in each top level's m_pSavedWords list, and so we don't also copy
	// them to the top level
	pDestWord1SPh->m_follPunct = pFromWord1SPh->m_follPunct;
	// we do the next line, be it should always just be copying empty string to empty string
	pDestWord1SPh->SetFollowingOuterPunct(pFromWord1SPh->GetFollowingOuterPunct());
	pDestWord2SPh->m_precPunct = pFromWord2SPh->m_precPunct;

	// that handles the punctuation, now we must copy across any stored inline markers; in
	// a fixedspace conjoining, we store these only at the m_pSavedWords level, not at the
	// top level
	// First, do the inline ones for the first CSourcePhrase instance in m_pSavedWords
	pDestWord1SPh->SetInlineBindingEndMarkers(pFromWord1SPh->GetInlineBindingEndMarkers());
	pDestWord1SPh->SetInlineBindingMarkers(pFromWord1SPh->GetInlineBindingMarkers());
	pDestWord1SPh->SetInlineNonbindingMarkers(pFromWord1SPh->GetInlineNonbindingMarkers());
	pDestWord1SPh->SetInlineNonbindingEndMarkers(pFromWord1SPh->GetInlineNonbindingEndMarkers());
	// Second, do the inline ones for the second CSourcePhrase instance in m_pSavedWords
	pDestWord2SPh->SetInlineBindingEndMarkers(pFromWord2SPh->GetInlineBindingEndMarkers());
	pDestWord2SPh->SetInlineBindingMarkers(pFromWord2SPh->GetInlineBindingMarkers());
	pDestWord2SPh->SetInlineNonbindingMarkers(pFromWord2SPh->GetInlineNonbindingMarkers());
	pDestWord2SPh->SetInlineNonbindingEndMarkers(pFromWord2SPh->GetInlineNonbindingEndMarkers());

	// the caller will have already transferred data for m_markers and m_endMarkers at the
	// top level; here we have to copy the first to pDestWord1SPh, and the second to pDestWord2SPh
	pDestWord1SPh->m_markers = pDestSrcPhrase->m_markers;
	pDestWord2SPh->SetEndMarkers(pDestSrcPhrase->GetEndMarkers());

	// the lower level m_key members will need to be updated too, pFromSrcPhrase's lower
	// level instances have the new values which need to be transferred to the lower level
	// instances in pDestSrcPhrase
	pDestWord1SPh->m_key = pFromWord1SPh->m_key;
	pDestWord2SPh->m_key = pFromWord2SPh->m_key;
	// that should do it!
}

///////////////////////////////////////////////////////////////////////////////
/// \return     TRUE to indicate to the caller all is OK (the pSrcPhrase was updated),
///             otherwise return FALSE to indicate to the caller that fixesStr must have
///             a reference added, and the new CSourcePhrase instances must be abandoned
///             and the passed in pSrcPhrase retained unchanged
/// \param		pView		-> pointer to the View
/// \param		pList		-> pointer to m_pSourcePhrases (its use herein is deprecated)
/// \param		pos_callers	-> the iterator position locating the passed in pSrcPhrase
///                            pointer (its use herein is deprecated)
/// \param		pSrcPhrase	<- pointer of the source phrase
/// \param		fixesStr	-> (its use herein is deprecated, the caller adds to it if
///                            FALSE is returned)
/// \param		pNewList	<- the parsed new source phrase instances
/// \param		bIsOwned	-> specifies whether or not the pSrcPhrase passed in is one which is
///                            owned by another sourcephrase instance or not (ie. TRUE
///                            means that it is one of the originals stored in an owning
///                            CSourcePhrase's m_pSavedWords list member, FALSE means it
///                            is not owned by another and so is a candidate for
///                            adaptation/glossing and entry of its data in the KB;
///                            owned ones cannot be stored in the KB - at least not
///                            while they continue as owned ones)
/// \remarks
/// Called from: the Doc's ReconstituteAfterPunctuationChange()
/// Handles one pSrcPhrase and ignores the m_pSavedWords list, since that is handled within
/// the ReconstituteAfterPunctuationChange() function for the owning srcPhrase with
/// m_nSrcWords > 1. For the return value, see ReconstituteAfterPunctuationChange()'s
/// return value - same deal applies here.
/// BEW 11Oct10 (actually 21Jan11) modified to use FromSingleMakeSstr2(), and to use the
/// TokenizeText() parser - but using target text and punctuation in order to obtain the
/// punctuation-less target text
/// BEW 8Mar11, changed so as not to try inserting new CSourcePhrase instances if the
/// pSrcPhrase passed in results in numElements > 1 in the TokenizeTextString() call
/// below, but just to leave pSrcPhrase unchanged in that case, abandon the new instances,
/// and return FALSE to have the caller put an appropriate entry in fixesStr
///////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItDoc::ReconstituteOneAfterPunctuationChange(CAdapt_ItView* pView,
	SPList*& WXUNUSED(pList), SPList::Node* WXUNUSED(pos_callers), CSourcePhrase*& pSrcPhrase,
	wxString& WXUNUSED(fixesStr), SPList*& pNewList, bool bIsOwned)
{
	// BEW added 5Apr05
	bool bHasTargetContent = TRUE; // assume it has an adaptation, clear below if not true
	bool bPlaceholder = FALSE; // default
	bool bNotInKB = FALSE; // default
	bool bRetranslation = FALSE; // default
	if (pSrcPhrase->m_bNullSourcePhrase) bPlaceholder = TRUE;
	if (pSrcPhrase->m_bRetranslation) bRetranslation = TRUE;
	if (pSrcPhrase->m_bNotInKB) bNotInKB = TRUE;

	wxString srcPhrase; // copy of m_srcPhrase member
	wxString targetStr; // copy of m_targetStr member
	wxString key; // copy of m_key member
	wxString adaption; // copy of m_adaption member
	wxString gloss; // copy of m_gloss member
	key.Empty(); adaption.Empty(); gloss.Empty();

	// setup the srcPhrase, targetStr and gloss strings - we must handle glosses too
	// regardless of the current mode (whether adapting or not)
	int numElements = 1; // default

	srcPhrase = FromSingleMakeSstr2(pSrcPhrase); // whm 5Feb2024 removed unused parameters - now calls FromSingleMakeSstr2()

	gloss = pSrcPhrase->m_gloss; // we don't care if glosses have punctuation or not
	if (pSrcPhrase->m_adaption.IsEmpty())
	{
		bHasTargetContent = FALSE;	// use to suppress copying of source punctuation
									// to an adaptation not yet existing
	}
	else
	{
		targetStr = pSrcPhrase->m_targetStr; // likewise, has punctuation, if any
	}

	// handle placeholders - these have elipsis ... as their m_key and m_srcPhrase
	// members, and so there is no possibility of punctuation changes having any effect
	// on these except possibly for the m_adaption member. Placeholders can occur
	// independently, or as part of a retranslation - the same treatment can be given
	// to instances occurring in either environment.
	SPList::Node* fpos;
	fpos = NULL;
	CSourcePhrase* pNewSrcPhrase;
	//SPList::Node* newpos;
	if (bPlaceholder)
	{
		// the adaptation, and gloss if any, is already presumably what the user wants,
		// so we'll just remove punctuation from the adaptation, and set the relevant members
		// (m_targetStr is already correct) - but only provided there is an existing adaptation
		pSrcPhrase->m_gloss = gloss;
		// remove any initial or final spaces before using it
		targetStr.Trim(TRUE); // trim right end
		targetStr.Trim(FALSE); // trim left end
		if (bHasTargetContent)
		{
			adaption = targetStr;
			// Note: RemovePunctuation() calls ParseWord() in order to give consistent
			// punctuation stripping with parsing text, src or tgt, in the rest of the app
			pView->RemovePunctuation(this, &adaption, from_target_text);
			pSrcPhrase->m_adaption = adaption;

			// update the KBs (both glossing and adapting KBs) provided it is
			// appropriate to do so
			if (!bPlaceholder && !bRetranslation && !bNotInKB && !bIsOwned)
				pView->StoreKBEntryForRebuild(pSrcPhrase, adaption, gloss);
		}
		return TRUE;
	}

	// BEW 8Jul05: a pSrcPhrase with empty m_srcPhrase and empty m_key can't produce
	// anything when passed to TokenizeTextString, and so to prevent numElements being
	// set to zero we must here detect any such sourcephrases and just return TRUE -
	// for these punctuation changes can produce no effect
	if (pSrcPhrase->m_srcPhrase.IsEmpty() && pSrcPhrase->m_key.IsEmpty())
		return TRUE; // causes the caller to use pSrcPhase 'as is'

	// reparse the srcPhrase string - if we get a single CSourcePhrase as the result,
	// we have a simple job to complete the rebuild for this passed in pSrcPhrase; if
	// we get more than one, we'll have to do something smarter... actually, it's too
	// complex to be smart, so we'll rely on visual editing after the fact to fix problems
	// that may have arisen
	srcPhrase.Trim(TRUE); // trim right end
	srcPhrase.Trim(FALSE); // trim left end
	numElements = pView->TokenizeTextString(pNewList, srcPhrase, pSrcPhrase->m_nSequNumber);
	//#ifdef _DEBUG
		//if (halt_here == 1)
		//{
		//	wxLogDebug(_T("  ReconsistuteOneAfterPunctuationChange: 5145  numElements = %d "),numElements);
		//}
	//#endif
	wxASSERT(numElements >= 1);
	pNewSrcPhrase = NULL;
	//newpos = NULL;
	if (numElements == 1)
	{
		// simple case - we can complete the rebuild in this block; note, the passed in
		// pSrcPhrase might be storing quite complex data - such as filtered material,
		// chapter & verse information and so forth, so we have to copy everything
		// across as well as update the source and target string members and
		// punctuation. The simplest direction for this copy is to copy from the parsed
		// new source phrase instance back to the original, since only m_key,
		// m_adaption, m_targetStr, precPunct and follPunct can possibly be different
		// in the new parse; it's unlikely m_srcPhrase will have changed, but just in case
		// I'll copy that too
		fpos = pNewList->GetFirst();
		pNewSrcPhrase = fpos->GetData();

		// BEW changed 10Mar11, so as to not copy anything other than the things affected,
		// as noted in the comment above. I'll leave the old code, which copied everything
		// redundantly, just in case I later change my mind.

		// next the text info and m_markers member
		pSrcPhrase->m_srcPhrase = pNewSrcPhrase->m_srcPhrase;
		pSrcPhrase->m_key = pNewSrcPhrase->m_key;
		pSrcPhrase->m_precPunct = pNewSrcPhrase->m_precPunct;
		pSrcPhrase->m_follPunct = pNewSrcPhrase->m_follPunct;

		// finally, the new docV5 members...
		pSrcPhrase->SetFollowingOuterPunct(pNewSrcPhrase->GetFollowingOuterPunct());

		// the adaptation, and gloss if any, is already presumably what the user wants,
		// so we'll just remove punctuation from the adaptation, and set the relevant members
		// (m_targetStr is already correct) - but only provided there is an existing adaptation

		// remove any initial or final spaces before using it
		targetStr.Trim(TRUE); // trim right end
		targetStr.Trim(FALSE); // trim left end
		pSrcPhrase->m_targetStr = targetStr;
		if (bHasTargetContent)
		{
			adaption = targetStr;
			pView->RemovePunctuation(this, &adaption, from_target_text);
			pSrcPhrase->m_adaption = adaption;

			// update the KBs (both glossing and adapting KBs) provided it is
			// appropriate to do so
			if (!bPlaceholder && !bRetranslation && !bNotInKB && !bIsOwned)
				pView->StoreKBEntryForRebuild(pSrcPhrase, pSrcPhrase->m_adaption, pSrcPhrase->m_gloss);
		}
		if (IsFixedSpaceSymbolWithin(pSrcPhrase))
		{
			// it's a conjoined pair, so there is more data to be transferred for the
			// instances in m_pSavedWords member (this actually transfers heaps of stuff
			// redundantly, but fixedspace conjoinings are so rare, it's not worth the
			// bother of making the adjustments to eliminate the redundant transfers)
			TransferFixedSpaceInfo(pSrcPhrase, pNewSrcPhrase);
		}
		return TRUE;
	}
	else
	{
		// BEW 8Mar11, deprecated the code for replacing pSrcPhrase with the two or more
		// tokenized instances resulting from the punctuation change - it's better to just
		// accept pSrcPhrase unchanged, add a ref to fixesStr in the caller, and return
		// FALSE to ensure that happens. (Caller cleans up pNewList, so can just return
		// here without any prior cleanup.)
		return FALSE;
	} // end of else block for test: if (numElements == 1)
}

/////////////////////////////////////////////////////////////////////////////////
/// \return		FALSE if the rebuild fails internally at one or more locations so that the
///				user must later inspect the doc visually and do something corrective at such
///				locations; TRUE if the rebuild was successful everywhere.
/// \param		pView		-> pointer to the View
/// \param		pList		-> pointer to m_pSourcePhrases
/// \param		fixesStr	-> currently unused
/// \remarks
/// Called from: the Doc's RetokenizeText().
/// Rebuilds the document after a filtering change is indicated. The new document reflects
/// the new filtering changes.
/// BEW added 18May05
/// BEW (?)refactored 18Mar09
/// BEW 20Sep10, old code expected filtered info to only be in m_markers, so for
/// docVersion 5 the code for unfiltering needs to use m_filteredInfo instead; similarly
/// for the code for filtering (that is, store in m_filteredInfo, not m_markers)
/// BEW 22Sep10, finished updated for support of docVersion 5 (significant changes
/// required, and I expanded the comments considerably to make the logic easier to follow,
/// but I didn't remove the goto statements)
/// BEW 11Oct10, radically rewrote the inner loop and got rid of gotos (except one) and
/// used RebuildSourceText() call to construct the filteredStr -- which saves mobs of code
/// BEW 20Sep19 refactored the unfiltering to unfilter to the position in the list which
/// is after (rather than before) the CSourcePhrase which carries the filtered info; and likewise
/// if filtering, to store it to the CSourcePhrase which precedes.
///  information on the CSourcePhrase which precedes the unfiltered information in the doc
/// BEW 30Aug22 fixed the following bug: filtering \f ... \f* did not stop at the end of the
/// filter span, but continued filtering of piles until the next marker was encountered. This
/// resulted in adaptations being thrown away in the piles following the correct filter span.
/// The error was a logic error in the code in HasMatchingEndMarker() which caused FALSE to
/// be returned, instead of TRUE (for a successful match) - and so filtering did not halt.
/// whm 24Oct2023-29Mar2024 significantly refactored the filtering and unfiltering parts, 
/// fixed some errors and removed two goto statements and labels for simplification.
/// The unfiltering routine now has an outer for loop to process one marker-being-unfiltered
/// at a time.
/// Filtering can now robustly store filtered material, and especially filter multiple
/// adjacent filtered markers, storing them in a previous non-placeholder source phrase
/// location.
/// Unfiltering can now robustly unfilter multiple filtered markers stored in
/// a pSrcPhrase->m_filteredInfo member, unfiltering those that are markerd to unfilter,
/// and re-storing other filtered markers that need to be stored back at the precise 
/// location when they need to be in case they later get unfiltered.
//////////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItDoc::ReconstituteAfterFilteringChange(CAdapt_ItView* pView,
	SPList*& pList, wxString& fixesStr)
{
	// Filtering has changed
	bool bSuccessful = TRUE;
	wxString endingMkrsStr; // BEW added 25May05 to handle endmarker sequences like \fq*\f*

	// Recalc the layout in case the view does some painting when the progress
	// was removed earlier or when the bar is recreated below
	UpdateSequNumbers(0); // get the numbers updated, as a precaution
#ifdef _NEW_LAYOUT
	GetLayout()->RecalcLayout(gpApp->m_pSourcePhrases, keep_strips_keep_piles);
#else
	GetLayout()->RecalcLayout(gpApp->m_pSourcePhrases, create_strips_keep_piles);
#endif
	gpApp->m_pActivePile = pView->GetPile(gpApp->m_nActiveSequNum);
	GetLayout()->PlaceBox();

	// put up a progress indicator
	int nOldTotal = pList->GetCount();
	if (nOldTotal == 0)
	{
		return 0;
	}
	int nOldCount = 0;

	// whm 26Aug11 Open a wxProgressDialog instance here for filtering change operations.
	// The dialog's pProgDlg pointer is passed along through various functions that
	// get called in the process.
	// whm WARNING: The maximum range of the wxProgressDialog (nTotal below) cannot
	// be changed after the dialog is created. So any routine that gets passed the
	// pProgDlg pointer, must make sure that value in its Update() function does not
	// exceed the same maximum value (nTotal).
	wxString msgDisplayed;
	const int nTotal = gpApp->GetMaxRangeForProgressDialog(App_SourcePhrases_Count) + 1;
	wxString progMsg = _("Pass 1 - %d of %d Total words and phrases");
	msgDisplayed = progMsg.Format(progMsg, 1, nOldTotal);
	CStatusBar* pStatusBar = NULL;
	pStatusBar = (CStatusBar*)gpApp->GetMainFrame()->m_pStatusBar;
	pStatusBar->StartProgress(_("Processing Filtering Change(s)"), msgDisplayed, nTotal);

	// BEW added 29Jul09, turn off CLayout Draw() while strips and piles could get
	// inconsistent with each other
	GetLayout()->m_bInhibitDraw = TRUE;

	// Set up a rapid access string for the markers changed to be now unfiltered,
	// and another for the markers now to be filtered. Unfiltering has to be done
	// before filtering is done.
	// whm 3Jan2024 addition.
	// Add two arrays markersToBeFilteredArr and markersToBeUnfilteredArr. This
	// will allow some simplification in processing the filtering changes received from
	// changes to the filter state of markers done in the "USFM and Filtering" tab of
	// Preferences.
	wxString strMarkersToBeUnfiltered;
	wxString strMarkersToBeFiltered;
	strMarkersToBeUnfiltered.Empty();
	strMarkersToBeFiltered.Empty();

	wxArrayString markersToBeUnfilteredArr;
	markersToBeUnfilteredArr.Clear();
	wxArrayString markersToBeFilteredArr;
	markersToBeFilteredArr.Clear();

	wxString valStr;
	// whm 29Feb2024 modified the way we get the markers for the strMarkersToBeFiltered and
	// strMarkersToBeUnfiltered. Using the m_FilterStatusMap is problematic because it includes
	// the medial markers of cross references \x ...\x* and of footnotes \f ...\f* etc. For
	// scanning through the text pSrcPhrase by pSrcPhrase, we only really want the actual marker(s)
	// whose check box was ticked/unticked in the USFM and Filtering tab of Preferences. The previous
	// code before this modification, when unfiltering, would scan through the whole list of 
	// pSrcPhrases for the \x marker, for example, and unfilter the \x marker along with all of its
	// medial markers during the first scan. Then it would scan all the pSrcPhrases again and again
	// for each of the medial markers such as \xot \xt \xnt \xq \xk \xo \xdc - all of which were
	// already dealt with during the first scan. The m_FilterStatusMap moreover would also include
	// the \xt marker to be unfiltered which is definitely not what we want when only unfiltering
	// the \x marker. Therefore, I added two App string values markersChangedToBeUnfiltered and
	// markersChangedToBeFiltered which simply contain only the markers whose checkboxes within the
	// USFM and Filtering page actually changed before this ReconstituteAfterFilteringChange() was
	// entered. These are now assigned to strMarkersToBeFiltered and strMarkersToBeUnfiltered in 
	// place of the code commented out below
	/*
	MapWholeMkrToFilterStatus::iterator iter;
	for (iter = gpApp->m_FilterStatusMap.begin(); iter != gpApp->m_FilterStatusMap.end(); ++iter)
	{
		if (iter->second == _T("1"))
		{
			strMarkersToBeFiltered += iter->first + _T(' ');
		}
		else
		{
			wxString augMkrTemp = iter->first + _T(' ');
			augMkrTemp.Trim(FALSE); // trim any whitespace off front of marker
			strMarkersToBeUnfiltered += augMkrTemp;
			markersToBeUnfilteredArr.Add(augMkrTemp); // the array holds augmented space final marker elements
		}
	}
	*/
	strMarkersToBeFiltered = gpApp->markersChangedToBeFiltered;

	strMarkersToBeUnfiltered = gpApp->markersChangedToBeUnfiltered;
	GetMarkersAndFollowingWhiteSpaceFromString(markersToBeUnfilteredArr, strMarkersToBeUnfiltered);

	// whm 4Mar2024 added the following initialization to keep track of when we're within
	// a cross-reference span \x ...\x*, and be able to adequately handle the dual
	// purpose nature of the \xt ...\xt* marker.
	m_bIsWithinCrossRef_X_Span = FALSE;

	// define some useful flags which will govern the code blocks to be entered
	bool bUnfilteringRequired = TRUE;
	bool bFilteringRequired = TRUE;
	// next two can have no markers but a single space, so the IsEmpty() test won't be
	// valid unless any whitespace preceding the markers is removed - which, of course,
	// removes any whitespace which comprises the whole content of either
	strMarkersToBeFiltered.Trim(FALSE); // trim whitespace off left end
	strMarkersToBeUnfiltered.Trim(FALSE); // trim whitespace off left end
	if (strMarkersToBeFiltered.IsEmpty())
		bFilteringRequired = FALSE;
	if (strMarkersToBeUnfiltered.IsEmpty())
		bUnfilteringRequired = FALSE;

	// BEW 30Sep19 If filtering, set the m_bCurrentlyFiltering boolean, in case
	// what's to be filtered contains hidden USFM3 attributes metadata that
	// needs to be un-hidden before the string for being filtered is finalized
	if (bFilteringRequired)
	{
		m_bCurrentlyFiltering = TRUE;
	}
	else
	{
		m_bCurrentlyFiltering = FALSE;
	}

	// whm 20Mar2024 added. If unfiltering, set the m_bCurrentlyUnfiltering boolean
	// so that TokenizeText() can properly point pPrevSrcPhrase to its beginning 
	// value.
	if (bUnfilteringRequired)
	{
		m_bCurrentlyUnfiltering = TRUE;
	}
	else
	{
		m_bCurrentlyUnfiltering = FALSE;
	}


	// in the block below we determine which SFM set's map to use, and determine what the full list
	// of filter markers is (the changed ones will be in m_FilterStatusMap); we need the map so we
	// can look up USFMAnalysis struct instances
	MapSfmToUSFMAnalysisStruct* pSfmMap;
	pSfmMap = gpApp->GetCurSfmMap(gpApp->gCurrentSfmSet);

	// reset the appropriate USFMAnalysis structs so that TokenizeText() calls will access
	// the changed filtering settings rather than the old settings (this also updates the app's
	// rapid access strings, by a call to SetupMarkerStrings() done just before returning)
	ResetUSFMFilterStructs(gpApp->gCurrentSfmSet, strMarkersToBeFiltered, strMarkersToBeUnfiltered);

	// Initialize for the loops. We must loop through the sourcephrases list twice - the
	// first pass will do all the needed unfilterings, the second pass will do the
	// required new filterings - trying to do these tasks in one pass would be much more
	// complicated and therefore error-prone.
	SPList::Node* pos_pList;
	CSourcePhrase* pSrcPhrase = NULL;
	CSourcePhrase* pPrevSrcPhrase = NULL; // whm 19Mar2024 renamed pLastSrcPhrase to pPrevSrcPhrase
	int nFound = -1;
	// whm 3Jan2024 note: offset is now only used in the if (!pSrcPhrase->GetFilteredInfo_After().IsEmpty()) block much later below
	int offset = 0; 
	int nEnd = 0;
	wxString filterBeginMkr = _T("\\~FILTER "); // note: includes a following space
	wxString filterEndMkr = _T("\\~FILTER*"); // note: includes final asterisk but no following space

	SPList* pSublist = new SPList;
	// BEW 20Sep10, for docVersion 5, the former tests of m_markers become tests of
	// m_filteredInfo, and restorage  to preStr uses content only from that

	// do the unfiltering pass through m_pSourcePhrases
	int curSequNum = -1;
	if (bUnfilteringRequired)
	{
		// whm 3Jan2024 modification. 
		// To simplify the "carry backwards" of filtered material being unfiltered, we 
		// need to process one marker-to-be-unfiltered at a time within a for loop that
		// processes one element of markersToBeUnfilteredArr array for each iteration of
		// the for loop below. 
		int mkrCount = (int)markersToBeUnfilteredArr.GetCount();
		for (int mkrIndex = 0; mkrIndex < mkrCount; mkrIndex++)
		{
			wxString augMarkerBeingUnfiltered = markersToBeUnfilteredArr.Item(mkrIndex);// whm 3Jan2024 added

			pos_pList = pList->GetFirst();
			bool bDidSomeUnfiltering;
			// bool bIsFirstNode = TRUE; // 29Feb2024 removed
			bool bDidSomeUnfiltering_After;

			// [deprecated] BEW 30Sep19 We filter to the first pSrcPhrase after the span, 
			// so when unfiltering we must insert the unfiltered content immediately before
			// that pSrcPhase. 
			// 
			// whm 15Nov2023 refactored and coding and comments simplified 3Jan2024.
			// As a general rult, we now filter to a PREVIOUS pSrcPhrase position BEFORE 
			// the being-filtered-span, and we now unfilter to a FOLLOWING pSrcPhrase
			// position AFTER the being-unfiltered-span.
			// The simple case is when there is a single non-adjacent marker. When it
			// is being filtered the filtered marker and associated text is "carried
			// forward" and stored on the source phrase immediately preceding the marker-
			// being-filtered. When a marker is being unfiltered the marker and its
			// associated text is extracted from storage, tokenized into a sub-list and
			// "carried backward" where the sub-list is inserted immediately following 
			// the source phrase location where the marker and associated text had been
			// stored.
			// The more complicated case is when more than one filterable marker is 
			// involved in either the filtering or unfiltering process, that is where
			// adjacent markers need to be filtered to a given source phrase, or unfiltered
			// from a given source phrase. This can happen during filtering when the last
			// word of text associated with a marker that is being filtered, has itself
			// already stored some filtered information from a previously filtered marker
			// (adjacent) following the marker being filtered. In such cases the filtered
			// information needs to be combined together during the "carrying forward"
			// process and stored together on the same source phrase. In such cases it is
			// important that the ordering of multiple filtered markers be correctly
			// stored so that the order reflects the order the markers had in the original
			// input text. This makes the unfiltering process simpler, and is generally
			// required in order for the RebuildSourceText() routine to correctly handle
			// filtered information when recreating the source text for export.
			// When more than one filterable marker is stored on a single source phrase
			// the process of unfiltering is a bit more complex. In such cases, any
			// filtered information being stored BEFORE the marker currently-being-unfiltered
			// needs to remain stored on the source phrase, and any filtered information that
			// was stored AFTER the marker currently-being-unfiltered needs to be "carried
			// backwards" to the last word of the associated text of the marker-being-
			// unfiltered once its associated text has been tokenized and inserted into
			// the main document.
			// 
			// For example, suppose the following 4 markers were all adjacent in the
			// original text and occured in the following order: \ms \mr \s \r. This
			// is a common occurrence in the Nyindrou NT books. By default the \mr and 
			// \r markers are filtered when the document is intially parsed. However,
			// it is quite possible a user might also filter the \ms and \s markers 
			// while intially adapting the sacred text withoutk having any major \ms or
			// regular \s section headings visible in the sacred text.
			// Then, let's suppose that the user decides to unfilter each of the 4 
			// markers separately. With a dumb method - that doesn't treat the stored
			// filtered information discretely - but simply inserts the marker-
			// being-unfiltered AFTER the pSrcPhrase where it was stored, the markers
			// would get unfiltered in their original adjacent ordering, only if the 
			// user were to unfilter them in reverse order starting with \r, then \s, 
			// then \mr, then \ms - would the resulting order get back to the original 
			// ordering of \ms \mr \s \r. This would work out OK because the usual
			// insertion point would be immediately following the pSrcPhrase that 
			// contains the filtered information for all 4 markers. 
			// However, let's suppose that the user decides to unfilter all 4 markers, 
			// starting with the \ms marker. With the dumb method, the \ms marker gets 
			// unfiltered immediately AFTER the pSrcPhrase that contained all 4 markers 
			// in its m_filteredInfo member. In this case, the \ms marker is unfiltered 
			// in its correct position/ordering, immediately following the pSrcPhrase 
			// where it was stored as filtered information. 
			// However, let's suppose the user then decides to unfilter the \s marker. 
			// If we unfilter the \s marker and its associated text in the usual place 
			// - immediately after the pSrcPhrase containing the filtered information - 
			// the \s marker and its associated text would get placed AFTER pSrcPhrase, 
			// but BEFORE the previously unfiltered \ms marker and its associated 
			// text - resulting in a wrong ordering of the markers and associated text:
			// \s ... \ms ... instead of \ms ... \s .... 
			// Proper handling of the filtered information needs to be smarter when
			// unfiltering multiple adjacent markers. Stored filtered material that is
			// adjacent to, but PRIOR to, the marker currently-being-unfiltered needs
			// to stay stored in its current location, the currently-being-unfiltered
			// marker's associated text tokenized and its sub-list of source phrases
			// inserted into the main text, and then any other stored filtered material
			// that is adjacent to, but FOLLOWING, the marker currently-being-unfiltered
			// needs to be "carried backwards" and stored on the last source phrase word
			// of the sub-list that was inserted for the currently-being-unfiltered
			// marker.
			// The above strategy only works if we ensure that multiple adjacent markers
			// are stored in their original ordering that they had in the input text
			// when it was intially parsed into AI as a source text. See comments
			// in the if (bFilteringRequired) block below for more information on how
			// we ensure that filtered information for multiple adjacent markers is
			// stored in the original ordering.

			// NOTE: We are currently in the TRUE block if (bUnfilteringRequired)

			// [BEW comment] At doc start, there won't be any unfilterable info
			// yet because there was no opportunity for filtering something.
			// Use bIsFirstNode == FALSE  to suppress that scenario
			// 
			// whm 29Feb2024 update to above comment. I've removed the bIsFirstNoe
			// flag and the block where it was used below because filtered information
			// is now stored on the previous pSrcPhrase. The reason for this modification
			// is that it is quite possible (and occurs in a unit test) that filtered 
			// information is stored on the very irst pSrcPhrase (at sn="0") of a text.
			// Therefore, this bUnfilteringRequired block needs to check the first
			// pSrcPhrase for filtered information.
			//
			// whm 26Nov2023 modification.
			// I've changed the insertion of markers-being-unfiltered to AFTER the
			// current pSrcPhrase instance, rather than BEFORE the pSrcPhrase location.
			// Hence, I've added a follPos node pointer and changed the name of the
			// saveNextPos node pointer to saveFollPos with corresponding adjustments
			// to their assignments below.

			SPList::Node* saveNextPos = NULL;
			//SPList::Node* prevPos = NULL;
			SPList::Node* follPos = NULL; // whm 26Nov2023 added but unused.
			follPos = follPos;  // avoid gcc set but not used warning

			// Unfiltering loop starts - each iteration deals with one CSourcePhrase instance
			while (pos_pList != NULL)
			{
				// whm 29Feb2024 Now, since filtered info is stored on a previous source phrase, we
				// should not skip the first node/pSrcPhrase as was done previously. Even in my unit
				// test data the unfiltering of an \x...\x* span was skipped because it was stored
				// on the first node/pSrcPhrase. Therefore I'm removing the bIsFirstNode block below
				// and the bIsFirsNode flag.
				//prevPos = saveNextPos; // RHS was set before moving to next Node ptr, so is 'previous' still
				saveNextPos = pos_pList; // now we  can update it to current Node
				SPList::Node* insertPos = NULL;
				CSourcePhrase* pInsertSP = NULL;
				insertPos = GetFollowingNonPlaceholderInsertPosition(saveNextPos, pInsertSP);
				if (pos_pList != NULL)
				{
					pSrcPhrase = (CSourcePhrase*)pos_pList->GetData(); // Get pSrcPhrase
				}
				else
				{
					break; // at doc end
				}
				// Get pos_pList ready for next iteration
				pos_pList = pos_pList->GetNext(); // moves the pointer/iterator to the next node
				if (pos_pList != NULL)
				{
					follPos = pos_pList;
				}

				// [BEW] The block above does this: (1) saveNextPos is where inserts happen before it
				// (2) pSrcPhrase was obtained before pos_pList moved move one past saveNextPos location
				// (3) there's not much need for prevPos, but we calculate it since it's used
				//     for setting pPrevSrcPhrase at appox line 7802 (now deprecated), and approx 
				//     line 8480 for dealing with a merger
				//}
#if defined (_DEBUG) && !defined(NOLOGS)
				wxString filteredInfo = pSrcPhrase->GetFilteredInfo();
				if (!filteredInfo.IsEmpty())
				{
					wxLogDebug(_T("Doc,Unfiltering, Line %d : At sequNum = %d , m_srcPhrase = %s ,  m_filteredInfo: %s"),
						__LINE__, pSrcPhrase->m_nSequNumber, pSrcPhrase->m_srcPhrase.c_str(), filteredInfo.c_str());
				}
				else
				{
					wxLogDebug(_T("Doc,Unfiltering, Line %d : At sequNum = %d , m_srcPhrase = %s  , NO FILTERING STORED"),
						__LINE__, pSrcPhrase->m_nSequNumber, pSrcPhrase->m_srcPhrase.c_str());
				}
#endif
#if defined (_DEBUG)				
				if (pSrcPhrase->m_nSequNumber == 6)
				{
					int halt_here = 1; halt_here = halt_here; // avoid gcc warning
				}
#endif
				curSequNum = pSrcPhrase->m_nSequNumber;
				bDidSomeUnfiltering = FALSE;

				bool bWeUnfilteredSomething = FALSE;
				wxString bareMarker;

				// [BEW} acts on ONE instance of pSrcPhrase only each time it loops, but in so doing
				// it may add many by removing FILTERED status for a series of sourcephrase instances
				// (all such will be sourced from within m_filteredInfo {or m_filteredInfo_After
				// if using ParseWord2() rather than the legacy parser; I expect we will never use ParseWord2()}
				// because notes, free trans, and collected free translations are not unfilterable)

				// whm 3Jan2024 Simplified code below by testing if the augMarkerBeingUnfiltered string
				// is found within the m_filteredInfo member, rather than parsing through all the filtered
				// info using the while loop as done previously.
				wxString theFilteredInfo = pSrcPhrase->GetFilteredInfo();
				if (!theFilteredInfo.IsEmpty()) // do nothing when m_filteredInfo is empty
				{
					// m_markers often has an initial space, which is a nuisance, so check and remove
					// it if present (this can remain here, the change, if done, is benign)
					// whm modified 7Jul12. Eliminated the m_markers[0] array access. Any initial space
					// can more reliably be removed by the using the wxString::Trim() method. The m_markers
					// here is not likely to be empty, but to be safe we should not use m_markers[0] array
					// access.
					pSrcPhrase->m_markers.Trim(FALSE); // trim any space from left end

					// ****************************
					// for pSrcPhrase, loop across any filtered substrings in m_filteredInfo, 
					// until no more are found. Often there is one only, but if storing more
					// than one (can be the case where 2 or more adjacent markers along with
					// their associated text have been filtered), the loop lets us cherry-pick
					// the content with the matching filterMkr, that's what we will unfilter.
					// 
					// whm 25Mar2024 added a different way for processing multiple filtered
					// items having the same filtered marker within the current pSrcPhrase's
					// m_filteredInfo member. We extract all filtered strings that are to be
					// unfiltered into an array and process them in a for loop, leaving any 
					// other filtered material, not currently being unfiltered, to be stored 
					// back into the appropriate source phrase's m_filteredInfo member. Each 
					// marker-to-be-unfiltered string will be tokenized and its sublist inserted 
					// after the current pSrcPhrase, or when 2 or more are being unfiltered, 
					// their sublist(s) inserted sequentially after any previous filtered marker's 
					// sublist has been inserted. 
					// Any filtered markers that we encounter within pSrcPhrase's m_filteredInfo
					// member that are NOT currently being unfiltered, will get stored back on
					// the last word of whatever precedes it - which may well be the last word
					// of a previously unfiltered marker's text.
					// 
					wxArrayString filteredStrItemsWithBrackets; filteredStrItemsWithBrackets.Empty();
					wxArrayPtrVoid LastWordSrcPhrofUnfilteredMkrsArr; LastWordSrcPhrofUnfilteredMkrsArr.Empty();
					wxString thisWholeMkrInFilterBrackets;  thisWholeMkrInFilterBrackets.Empty();
					wxString nextWholeMkrInFilterBrackets; nextWholeMkrInFilterBrackets.Empty();
					wxString previousWholeMkrInFilterBrackets; previousWholeMkrInFilterBrackets.Empty();
					bool bThisMkrToBeUnfiltered;
					//bool bNextMkrToBeUnfiltered;
					//bool bPreviousMkrWasUnfiltered;
					bool bAnyPreviousMkrWasUnfiltered = FALSE;
					filteredStrItemsWithBrackets = GetFilteredInfoSegments(theFilteredInfo);
					int nTotFilterItems = (int)filteredStrItemsWithBrackets.GetCount();
					if (nTotFilterItems > 0)
						pSrcPhrase->SetFilteredInfo(wxEmptyString); // empty its m_filteredInfo, it might get populated again below
					for (int itemCt = 0; itemCt < nTotFilterItems; itemCt++)
					{
						thisWholeMkrInFilterBrackets = filteredStrItemsWithBrackets.Item(itemCt);
						if (itemCt + 1 < nTotFilterItems)
							nextWholeMkrInFilterBrackets = filteredStrItemsWithBrackets.Item(itemCt + 1);
						else
							nextWholeMkrInFilterBrackets.Empty();
						if (itemCt - 1 >= 0)
							previousWholeMkrInFilterBrackets = filteredStrItemsWithBrackets.Item(itemCt - 1);
						else
							previousWholeMkrInFilterBrackets.Empty();
						wxString augMkrWithInitialFilterBracket = filterBeginMkr + augMarkerBeingUnfiltered;
						int posFilteredMkr = thisWholeMkrInFilterBrackets.Find(augMkrWithInitialFilterBracket);
						if (posFilteredMkr != wxNOT_FOUND)
							bThisMkrToBeUnfiltered = TRUE;
						else
							bThisMkrToBeUnfiltered = FALSE;
						//int posNextFilteredMkr = nextWholeMkrInFilterBrackets.Find(augMkrWithInitialFilterBracket);
						//if (posNextFilteredMkr != wxNOT_FOUND)
						//	bNextMkrToBeUnfiltered = TRUE;
						//else
						//	bNextMkrToBeUnfiltered = FALSE;
						//int posPrevFilteredMkr = previousWholeMkrInFilterBrackets.Find(augMkrWithInitialFilterBracket);
						//if (posPrevFilteredMkr != wxNOT_FOUND)
						//	bPreviousMkrWasUnfiltered = TRUE;
						//else
						//	bPreviousMkrWasUnfiltered = FALSE;
						if (!bThisMkrToBeUnfiltered)
						{
							// This marker was in m_filteredInfo, but NOT currently to be unfiltered, so it should be
							// stored back on a previous source phrase, but which one? If ANY previous marker was
							// unfiltered, then thisWholeMkrInFilterBrackets should be stored on the last SP word of 
							// the most recently unfiltered previous marker's sublist. 
							// If NO previous marker was unfiltered, then thisWholeMkrInFilterBrackets should be stored
							// on the original pSrcPhrase.
							LastWordSrcPhrofUnfilteredMkrsArr.Add((void*)NULL); // This marker won't have a pSrcPhr once unfiltered
							if (!bAnyPreviousMkrWasUnfiltered)
							{
								// No previous marker was unfiltered, so store thisWholeMkrInFilterBrackets back on 
								// pSrcPhrase by adding it to any filtered material already there.
								pSrcPhrase->AddToFilteredInfo(thisWholeMkrInFilterBrackets);
							}
							else
							{
								// A previous marker was unfiltered, so scan backwards in the filterStatusOfProcessedMkrs 
								// array and locate the most recent marker item in there with a non-NULL value, if any.
								//bool bFound = FALSE;
								int itemIndex = -1;
								int startIndex = itemCt; // don't allow itemCt to change here!
								for (int i = startIndex; i > 0; i--)
								{
									if (LastWordSrcPhrofUnfilteredMkrsArr.Item(i) != NULL)
									{
										//bFound = TRUE;
										itemIndex = i;
										break; // Don't iterate back any further. We want the last SP that wasn't NULL
									}
								}
								wxString mkrNotUnfiltered; mkrNotUnfiltered.Empty();
								if (itemIndex != -1)
								{
									// We found a "last" word source phrase of the most recently unfiltered marker's
									// associated text. We need to find it within the main document's pList.
									CSourcePhrase* pLastWordSP = NULL;
									CSourcePhrase* pStoreSP = NULL;
									pLastWordSP = (CSourcePhrase*)LastWordSrcPhrofUnfilteredMkrsArr.Item(itemIndex);
									SPList::Node* savePos = pList->Find((pLastWordSP));
									if (savePos != NULL)
									{
										pStoreSP = savePos->GetData();
										wxASSERT(pStoreSP != NULL);
										pStoreSP->AddToFilteredInfo(thisWholeMkrInFilterBrackets);
									}
								}
								else
								{
									// We didn't find any previous place to store the filtered marker, so add it
									// to any filtered info already stored on the original pSrcPhrase.
									pSrcPhrase->AddToFilteredInfo(thisWholeMkrInFilterBrackets);
								}
							}
						}
						if (bThisMkrToBeUnfiltered)
						{
							// This marker is to be unfiltered.
							bAnyPreviousMkrWasUnfiltered = TRUE;

							// *****************
							// whm 3Jan2024 Testing NOTE concerning unknown markers:
							// A unit test with unknown markers indicates that
							// the unknown marker is inserted as unfiltered into the document's 
							// marker list in the "USFM and Filtering" tab of Preferences.
							// From there it can be unfiltered or filtered at will without
							// problems. While the marker itself \unm is stored within the source
							// phrase's m_markers field and as ?unm? in the m_inform field, and
							// any associated text displayed in red in the main window.
							// When filtered the unknown marker is stored in the previous source
							// phrase's m_filteredInfo field in the usual way. 
							// Therefore it doesn't appear that any further action needs to be
							// taken to properly handle the occurrence of unknown markers. 
							// *****************

							// Setup for unfiltering and do so
							bDidSomeUnfiltering = TRUE; // used for updating navText on original pSrcPhrase when done
							bWeUnfilteredSomething = TRUE; // used for reseting initial conditions in inner loop

							m_bCurrentlyUnfiltering = TRUE; // whm 20Mar2024 added

							pSublist->Clear(); // clear list in preparation for Tokenizing

							wxString extractedStr = RemoveAnyFilterBracketsFromString(thisWholeMkrInFilterBrackets); // we'll tokenize LHSide
							extractedStr.Trim(FALSE); // remove any initial space
							extractedStr.Trim(TRUE); // remove any final space

							// tokenize the substring (using this we get its inline marker handling for free)
							// whm 22Mar2024 added. If the marker-being-unfiltered is \x the extractedStr will
							// have "\\x " at the beginning of its string. If the \x marker is indeed the marker
							// being unfiltered we want to set the Doc's m_bIsWithinCrossRef_X_Span flag to TRUE
							// before the TokenizeTextString() call below, and then set that same flag to FALSE
							// after the TokenizeTextString call. This will inform the TokenizeText() function
							// that gets called by TokenizeTextString() that it is parsing the an \x ...\x* span
							// and if so TokenizeText() should save any embedded \xt marker as a regular cross-ref
							// marker in the m_markers member, rather than as a stand-alone \xt begin marker which
							// gets stored within the m_inlineNonbindingMArkers member.
							if (augMarkerBeingUnfiltered == _T("\\x ") && extractedStr.Find(augMarkerBeingUnfiltered) == 0)
							{
								m_bIsWithinCrossRef_X_Span = TRUE;
							}
							int count = pView->TokenizeTextString(pSublist, extractedStr, pSrcPhrase->m_nSequNumber);
							if (augMarkerBeingUnfiltered == _T("\\x ") && extractedStr.Find(augMarkerBeingUnfiltered) == 0)
							{
								m_bIsWithinCrossRef_X_Span = FALSE;
							}
							// pSublist now has the tokenized unfiltered data
							if (!pSublist->IsEmpty())
							{
								SPList::Node* lastPos = pSublist->GetLast();
								CSourcePhrase* pTailSrcPhrase = lastPos->GetData();
								if (pTailSrcPhrase)
								{
									LastWordSrcPhrofUnfilteredMkrsArr.Add(pTailSrcPhrase);
								}
							}

							// set the members appropriately, note intial and final require
							// extra code -- the TokenizeTextString call tokenizes without any
							// context, and so we can assume that some sourcephrase members are
							// not set up correctly (eg. m_bSpecialText, and m_curTextType) so
							// we'll have to use some of TokenizeText's processing code to get
							// things set up right. (a position pos_partialList value of zero is
							// sufficient test for being at the final sourcephrase, after the
							// GetNext() call has obtained the final one)
							// 
							// whm 3Jan2024 removed h: jump label that was previously at this location

							USFMAnalysis* pSfm = NULL;	// initialize before call to AnalyseMarker
							bareMarker = augMarkerBeingUnfiltered.Mid(1); // remove backslash
							bareMarker.Trim(TRUE); // remove augmented final space
							bool bFound = FALSE;
							MapSfmToUSFMAnalysisStruct::iterator f_iter;
							f_iter = pSfmMap->find(bareMarker); // find returns an iterator
							if (f_iter != pSfmMap->end())
								bFound = TRUE;
							if (bFound)
							{
								pSfm = f_iter->second;
								// if it was not found, then pSfm will remain NULL, and we know
								// it must be an unknown marker
							}
							else
							{
								pSfm = (USFMAnalysis*)NULL;
							}

							bool bIsInitial = TRUE;
							int nWhich = -1;

							int extractedStrLen = extractedStr.Length();
							// wx version note: Since we require a read-only buffer we use
							// GetData which just returns a const wxChar* to the data in the
							// string.
							const wxChar* pChar = extractedStr.GetData();
							wxChar* pBufStart = (wxChar*)pChar;
							wxChar* pEnd;
							pEnd = (wxChar*)pChar + extractedStrLen; // whm added
							wxASSERT(*pEnd == _T('\0'));
							pEnd = pEnd; // avoid warning
							// lookup the marker in the active USFMAnalysis struct map,
							// get its struct
							wxString wholeMkrBeingUnfiltered = augMarkerBeingUnfiltered;
							wholeMkrBeingUnfiltered.Trim(TRUE); // remove following space
							int mkrLen = (int)wholeMkrBeingUnfiltered.Length(); // we want the length including
														// backslash for AnalyseMarker()
							SPList::Node* pos_SubList = pSublist->GetFirst();
							CSourcePhrase* pSPprevious = NULL;
							while (pos_SubList != NULL)
							{
								CSourcePhrase* pSP_SubList = (CSourcePhrase*)pos_SubList->GetData();
								pos_SubList = pos_SubList->GetNext();
								wxASSERT(pSP_SubList);
								nWhich++; // 0-based value for the iteration number
								if (bIsInitial)
								{
									// [BEW comment] call AnalyseMarker() and set the flags 
									// etc correctly, taking context into account, for this 
									// we need the pPrevSrcPhrase pointer - but it is okay if 
									// it is NULL/
									// (Note: pSP_SubList is still in the temporary list pSublist,
									// while pPrevSrcPhrase is in the m_pSourcePhrases main
									// list of the document.)
									pSP_SubList->m_curTextType = verse; // assume verse unless AnalyseMarker changes it
									pSP_SubList->m_bSpecialText = AnalyseMarker(pSP_SubList, pPrevSrcPhrase, pBufStart, mkrLen, pSfm);

									// whm 3Jan2024 Notes: Testing indicates that all "unknown" 
									// markers get listed at the top of the Doc's marker list 
									// in "USFM and Filtering" tab of Preferences, where they
									// can be filtered and unfiltered like all other known
									// markers.
									// 
									// whm 3Jan2024 Notes: Unknown markers are stored within 
									// pSrcPhrase's m_markers like other markers and also are
									// surrounded with question markers as ?\unk? in the 
									// pSrcPhrase's m_inform member. When an unknown marker is
									// filtered, it is stored in a previous source phrase's
									// m_filteredInfo member as is other known markers.
									// I believe that the blocks of code below that deal with 
									// bIsContentlessMarker and with bHaventAClueWhatItIs are 
									// not relevant any more and so I've commented them out.
									
									// is it PNG SFM or USFM footnote marker?
									// comparing first two chars in mkr
									// whm 31Oct2023 modified the following test and block. The reason
									// is that it wrongly detects the \\fig marker in addition to detecting
									// footnotes, and in such cases it makes the pSP_SubList for the \fig marker's 
									// m_bFootnote = TRUE.
									// The AnalyseMarker() call above should adequately handle footnote
									// properties and assign its m_bFootnote member to TRUE.

									//if (mkr.Left(2) == _T("\\f")) // is it PNG SFM or USFM footnote marker?
									if (wholeMkrBeingUnfiltered != _T("\\fig") && wholeMkrBeingUnfiltered.Left(2) == _T("\\f")) // is it PNG SFM or USFM footnote marker?
									{
										// if not already set, then do it here
										if (!pSP_SubList->m_bFootnote)
											pSP_SubList->m_bFootnote = TRUE;
									}

									pSPprevious = pSP_SubList; // set pSPprevious for the next iteration, for propagation
									bIsInitial = FALSE;
								} // end of TRUE block for test: if (bIsInitial)

								// when not the 0th iteration, we need to propagate the flags,
								// texttype, etc
								if (nWhich > 0)
								{
									// do propagation
									wxASSERT(pSPprevious);
									pSP_SubList->CopySameTypeParams(*pSPprevious);
								}

								// for the last pSP_SubList instance, there could be an endmarker which
								// follows it; if that is the case, we can assume the main
								// list's sourcephrase which will follow this final pSP_SubList
								// instance after we've inserted pSublist into the main list,
								// will already have its correct TextType and m_bSpecialText
								// value set, and so we won't try change it (and won't call
								// AnalyseMarker() again to invoke its endmarker-support code
								// either) instead we will just set sensible end conditions -
								// such as m_bBoundary set TRUE, and we'll let the TextType
								// propagation do its job. We will need to check if we have
								// just unfiltererd a footnote, and if so, set the
								// m_bFootnoteEnd flag.
								if (pos_SubList == NULL || count == 1)
								{
									// pSP_SubList is the final in pSublist, so do what needs to be
									// done for such an instance; (if there is only one
									// instance in pSublist, then the first one is also the
									// last one, so we check for that using the count == 1 test
									// -- which is redundant really since pos_SubList should be NULL
									// in that case too, but no harm is done with the extra
									// test)
									pSP_SubList->m_bBoundary = TRUE;
									// rely on the foonote TextType having been propagated
									if (pSP_SubList->m_curTextType == footnote)
										pSP_SubList->m_bFootnoteEnd = TRUE;
								}
							} // end of while (pos_SubList != NULL)

							// whm 29Mar2024 TODO: Instead of using an insertPos I think it is
							// more reliable to have an pInsertSP identified above just inside
							// of the current for loop. We can then use that pInsertSP and 
							// execute an insertPos = pList->Find(pInsertSP) here to identify
							// a current insertPos before which to insert the tokenized sublist
							insertPos = pList->Find(pInsertSP);
							wxASSERT(insertPos != NULL);
							if (insertPos != NULL)
							{
								pInsertSP = insertPos->GetData();
							}
							else
							{
								// insertPos is NULL, so we are at the end of the Doc
								// Instead of calling pList->Insert(insertPos, pSP_SubList) below, 
								// we will call pList->Append(pSP_SubList)
								int break_here = 0; wxUnusedVar(break_here);
							}

#if defined(_DEBUG)
							// whm 31Oct2023 Debug block for inspection of source phrases at insertPos
							if (insertPos != NULL)
							{
								CSourcePhrase* pInsertSP = insertPos->GetData();
								// For debugging and inspecting the 
								if (pInsertSP)
								{
									int sn = pInsertSP->m_nSequNumber;
									sn = sn;
									wxString tempKey = pInsertSP->m_key;
									tempKey = tempKey;
								}
							}
#endif
							CSourcePhrase* pSP_SubList = NULL;
							//SPList::Node* pos_LastInSubList = pSublist->GetLast();
							//CSourcePhrase* pSP_LastInSubList = NULL;
							SPList::Node* pos_FirstInSubList = pSublist->GetFirst(); // used in a block below
							CSourcePhrase* pSP_FirstInSubList = NULL;
							//if (pos_LastInSubList != NULL)
							//	pSP_LastInSubList = pos_LastInSubList->GetData();
							if (pos_FirstInSubList != NULL)
								pSP_FirstInSubList = pos_FirstInSubList->GetData();
							pos_SubList = pSublist->GetFirst();
							while (pos_SubList != NULL)
							{
								pSP_SubList = (CSourcePhrase*)pos_SubList->GetData();
								pos_SubList = pos_SubList->GetNext();

								// whm 31Oct2023 modified the routines below, because the unfiltering
								// of markers is not inserting them at the correct soure phrase location
								// in the sacred text. 
#if defined(_DEBUG)
								// whm 31Oct2023 Debug block for inspection of source phrases at insertPos
								if (insertPos != NULL)
								{
									CSourcePhrase* pInsertSP = (CSourcePhrase*)insertPos->GetData();
									if (pInsertSP != NULL)
									{
										int sn = pInsertSP->m_nSequNumber;
										sn = sn;
										wxString tempKey = pInsertSP->m_key;
										tempKey = tempKey;
									}
								}
#endif
								// whm 31Oct2023 modified the following to execute pList->Insert() before 
								// the insertPos instead of the saveNextPos position.
								if (insertPos != NULL)
								{
									// There exists a fixed location CSourcePhrase before which we can
									// insert
									pList->Insert(insertPos, pSP_SubList);
								}
								else
								{
									// We must append the unfiltered instances to the
									// m_pSourcePhrases list
									pList->Append(pSP_SubList);
								}
								// m_pSourcePhrases will manage these unfiltered ones now
							} // end of while (pos_SubList != NULL)

							pSublist->Clear(); // clear the local list (but leave the memory chunks in RAM)

							// BEW 20Sep19, this would be a good place to ensure that the
							// sequence numbers are updated
							UpdateSequNumbers(0); // starting at 0, the start of the doc
#if defined (_DEBUG)  && !defined(NOLOGS)
							wxLogDebug(_T("%s::%s(), line %d; INNER LOOP ; before SequNum Update: curSequNum %d ,  SN = %d , count %d"),
								__FILE__, __FUNCTION__, __LINE__, curSequNum, gpApp->m_nActiveSequNum, count);
#endif

							// update the active sequence number on the App
							// BEW changed 29Jul09, the test needs to be > rather than >=,
							// because otherwise a spurious increment by 1 can happen at the
							// end of the first run through this block
							if (gpApp->m_nActiveSequNum > curSequNum)
							{
								// adjustment of the value is needed (for unfilterings, the box
								// location remains a valid one (but not necessarily so when
								// filtering)
								gpApp->m_nActiveSequNum += count;
							}

							// Do the unfiltering adjustments needed when we unfiltered something.
							if (bWeUnfilteredSomething)
							{
								bWeUnfilteredSomething = FALSE; // reset for next iteration of inner loop

								// BEW added 8Mar11, I forgot to remove the unfiltered info from
								// the saved originals of a merger! If the pSrcPhrase at oldPos is
								// a merger, then the first of the stored original list of
								// CSourcePhrase instances will also store in its m_filteredInfo
								// member the same filtered information - so we must check here,
								// and if filterMkr is within that instances m_filteredInfo, we
								// must replace its m_filteredInfo content with remainderStr as set
								// above.
								//
								// whm 29Feb2024 revised. Filtered information is now stored on a
								// previous sourc phrase, which would be the last word of a merged
								// source phrase. So now when unfiltering that marker and data, we
								// must remove it and its data from the filtered into of that last 
								// source phrase of a merger.
								// First get the first or top level source phrase and see if it is
								// a merger.
								CSourcePhrase* pSrcPhraseTopLevel = NULL;
								pos_FirstInSubList = pList->Find(pSP_FirstInSubList);
								if (pos_FirstInSubList != NULL)
								{
									pSrcPhraseTopLevel = pos_FirstInSubList->GetData();
								}
								// we deliberately check for a non-empty m_pSavedWords list,
								// rather than looking at m_nSrcWords; we want our test to handle
								// fixedspace (~) pseudo-merger conjoining, as well as a real merger
								if (pSrcPhraseTopLevel != NULL && !pSrcPhraseTopLevel->m_pSavedWords->IsEmpty())
								{
									// it's either a merger, or a fixedspace conjoining of two; in
									// either case, any filtered info can only be on the last in
									// the m_pSavedWords list
									SPList::Node* posOriginalsList = pSrcPhraseTopLevel->m_pSavedWords->GetLast();
									if (posOriginalsList != NULL)
									{
										CSourcePhrase* pLastOriginal = posOriginalsList->GetData();
										wxASSERT(pLastOriginal != NULL);
										wxString lastOriginalFilteredInfo = pLastOriginal->GetFilteredInfo();
										if (!lastOriginalFilteredInfo.IsEmpty())
										{
											int anOffset = lastOriginalFilteredInfo.Find(wholeMkrBeingUnfiltered); // is the
												// just-unfiltered marker also within this stored filtered material?
											if (anOffset != wxNOT_FOUND)
											{
												// it's present, so it has to be removed, as it was
												// from the parent - we do this by simply replacing
												// the content with the parent's altered content for
												// this member
												// whm 29Mar2024 remainderStr is no longer relevant, so
												// set pLastOriginal with wxEmptyString.
												pLastOriginal->SetFilteredInfo(wxEmptyString); //pLastOriginal->SetFilteredInfo(remainderStr);
											}
										}
									}
								} // end of if (pSrcPhraseTopLevel != NULL && !pSrcPhraseTopLevel->m_pSavedWords->IsEmpty())

								// do the setup for next iteration of the loop
								UpdateSequNumbers(0); // get all the sequence numbers into correct order
							} // end of TRUE block for test: if (bWeUnfilteredSomething)
						} // end of if (posFilteredMkr != wxNOT_FOUND)
					} // end of for (int itemCt = 0; itemCt < nTotFilterItems; itemCt++)
					// ****************************

				} // end of TRUE block for test: if (!theFilteredInfo.IsEmpty())

				bDidSomeUnfiltering_After = FALSE; // reinitialize, for working with m_filteredInfo_After

				// BEW 18Apr17 CSourcePhrase now has a new member m_filteredInfo_After, where post-word
				// filtered information along with metadata for guiding replacement into m_pSourcePhrases
				// gets stored. We now check for that member having content, and we unfilter those bits
				// designated for unfiltering from there
				//preStr.Empty();
				//remainderStr.Empty();
				bareMarker.Empty();
				// BEW 18Apr17 added support for metadata for unfiltering marker placement(s)
				// Will be empty string if there is no contained metadata; the metadata, if
				// present has a form like  [[after_punct^^]] where there will be a punctuation
				// character between the ^^, or [[after_endMkr^^]] where there will be an
				// endmarker between the ^^, or [[after_word^^]] where the parsed word will
				// be between the ^^
				wxString unfilter_metadata = wxEmptyString;
				wxString inlineNBEndMkrs = wxEmptyString;

				// Unfiltering from m_filteredInfo_After will have to be done a bit differently. There
				// will be a [[after_......^]] substring immediately preceding each filtered \mkr which
				// we need to separate from the marker content; and we need to unfilter in a loop because
				// there could be several markers to be unfiltered. Third, we have to build a post-word
				// string (rather like helpers::FromSingleMakeSstr2) initially (before unfiltering) with
				// inline binding endmarkers, puncts from m_punct, inline non-binding endmarkers,
				// puncts from m_follOuterPunct - doing this as a once off, then in a loop find where
				// to insert each unfiltered string without the \~FILTER & \~FILTER* markers in their
				// correct places. remainderStr will probably be not used because anything remaining
				// in m_filteredInfo_After must stay on that same *pSrcPhrase, and not be moved to
				// any other

				// We need two wxArrayString local arrays, because we extract in stored string order
				// within m_filteredInfo_After, and we have to get all unfilting bits 'n pieces from
				// that member, removing the bits for unfiltering as we go, and storing them somewhere
				// before we attempt restoration within the source text, then tokenizing, then melding
				// into the m_pSourcePhrases list. The following two arrays are our temporary storage.
				wxArrayString metaArr;
				wxArrayString unfilterArr;
				wxArrayString mkrsToMatchArr; // store each \mkr<space> here, repeats are possible
				wxString wordPlusAfter; // this is where we build the pSrcPhrase m_key + ending puncts and
										// inline markers (except non-binding inline markers - we store
										// those separately if any are found). Anything unfiltered can
										// then be melded into the post-word part of this string
				wxString finalInlineNonbindingEndmarker; // if a non-binding endmarker (like \wj* for 'words of Jesus')
										// is encountered, there should be only one possible per pSrcPhrase,
										// so store it here. It gets added at the end the CSourcePhrase at
										// the end of the unfiltered info tokenization

				// whm 29Mar2024 TODO: I don't think the GetFilteredInfo_After is relevant any more. If this
				// proves to be the case remove the code block belwo.
				if (!pSrcPhrase->GetFilteredInfo_After().IsEmpty()) // do nothing when m_filteredInfo_After is empty
					// This is the added unfiltering block, when m_filteredInfo_After was added in 18Apr17
				{
					// First task is to get the post-word string, with puncts and inline markers in place,
					// before we do the unfilterings and placements within it in the while loop below
					wordPlusAfter = BuildPostWordStringWithoutUnfiltering(pSrcPhrase, inlineNBEndMkrs);
					wxASSERT(!wordPlusAfter.IsEmpty());
					wxString filteredInfo_After; // each filtered content with its preceding marker
												 // and following endmarker is extracted to here
					nEnd = 0; // initialize, use this with offset, to remove a being-unfiltered
							  // text span from m_filteredInfo_After
					if (!inlineNBEndMkrs.IsEmpty())
					{
						finalInlineNonbindingEndmarker = inlineNBEndMkrs;
					}

					wxString mkrAfter; // whm 3Jan2024 added for routines below instead of mkr

					// For pSrcPhrase, loop across any filtered substrings in m_filteredInfo_After, until no
					// more are found ( filterMkr is \~FILTER ); the loop iterates so long as offset points
					// at a \~FILTER to be processed for its content and metadata and ending \~FILTER*; depending
					// on the user's marker choices for unfiltering, we may here unfilter all content, or only
					// matched bits of it
					while ((offset = FindFromPos(pSrcPhrase->GetFilteredInfo_After(), filterMkr, offset)) != -1)
					{
						// get the next one, its prestring and remainderstring too; on return start
						// will contain the offset to \~FILTER and end will contain the offset to the
						// character immediately following the space following the matching \~FILTER*
						wxString theFilteredInfo_After = pSrcPhrase->GetFilteredInfo_After(); // gets the contents
										// of m_filteredInfo_After, which will shorten as to-be-unfiltered strings
										// are extracted by successive iterations of the loop

						// Here, instead of calling GetNextFilteredMarker(theFilteredInfo,offset, start, end);
						// and returning the mkr (which was filtered), we need a similar function which does
						// that job but also skips removes the metadata substring & returns it via the signature.
						// This Reconstitute... function will need some local array variables (see above)
						// to store the separated bits, and a wxArrayString for the to-be-unfiltered markers -
						// since there may be more than one marker being unfiltered. These are for
						// testing for presence in strMarkersToBeUnfiltered). Such a new function has been
						// defined: GetNextFilteredMarker_After(). We use it below. We also must remove
						// the filtered stuff we are unfiltering, from m_filteredInfo_After, as we iterate,
						// after determining that the marker returned is a match for one of the marker
						// strings within strMarkersToBeUnfiltered. We add a space to the marker to make
						// sure the space is matched also, to prevent bogus matches

						// Now we can safely call GetNextFilteredMarker_After()
						unfilter_metadata = wxEmptyString;
						filteredInfo_After.Empty();
						mkrAfter = GetNextFilteredMarker_After(theFilteredInfo_After, filteredInfo_After,
							unfilter_metadata, offset, nEnd);

						if (mkrAfter.IsEmpty() || (offset == nEnd))
						{
							// there was an error in the call above... post a reference to its location
							// sequence numbers may not be uptodate, so do so first over whole list so that
							// the attempt to find the chapter:verse reference string will not fail
							pView->UpdateSequNumbers(0);
							if (!gbIsUnstructuredData)
							{
								fixesStr += pView->GetChapterAndVerse(pSrcPhrase);
								fixesStr += _T(" after word: pSrcPhrase->m_key  at sequ num wxItoa(pSrcPhrase->m_nSequNumber)   ");
							}
							bSuccessful = FALSE; // make sure the caller will show the error box
							break; // exit this inner loop & iterate to the next CSourcePhrase instance
						}
						else
						{
							// We successfully extracted a copy of something from m_filteredInfo_After. However,
							// we don't yet know if what we extracted is information which should be unfiltered.
							// So test for unfiltering it, and if so get the bits into the arrays above, and
							// if not so, abandon the extraction. The offset value will be updated differently
							// depending on what is the case: if we are going to unfilter the extracted info,
							// then we remove it from m_filteredInfo_After wxString member, and so the stuff
							// following it will slide down so that offset stays unchanged and possibly points
							// at another \~FILTER marker for something which may or may not be filterable. But if
							// the info is not for filtering then offset needs to be increased by the nEnd value
							// to be ready for a possible subsequent iteration of the loop
							wxString augmentedMkr = mkrAfter + _T(' '); // add final space
							// Test for unfiltering of mkr
							int offset3 = strMarkersToBeUnfiltered.Find(augmentedMkr);
							if (offset3 == wxNOT_FOUND)
							{
								// It's not one for being unfiltered
								offset = nEnd; // point offset past it
								nEnd = 0; // re-initialize
							}
							else
							{
								// It's one for being unfiltered, so get the relevant data stored
								// and remove the relevant stuff from m_filteredInfo_After
								if (bDidSomeUnfiltering_After == FALSE)
								{
									// Make sure RedoNavigationText() is called later
									bDidSomeUnfiltering_After = TRUE;
								}
								metaArr.Add(unfilter_metadata);
								unfilterArr.Add(filteredInfo_After);
								mkrsToMatchArr.Add(mkrAfter);

								// Next, remove from m_filteredInfo_After the stuff extracted,
								// do it with the help of offset and nEnd values
								size_t spanToRemove = (size_t)(nEnd - offset);
								wxString str = theFilteredInfo_After.Remove(offset, spanToRemove);
								pSrcPhrase->SetFilteredInfo_After(str); // shortened, or perhaps now empty
								nEnd = 0;
							}

						} // end of else block for test:  if (mkr.IsEmpty() || (offset == nEnd))

					} //  end of while loop with test: (offset = FindFromPos(pSrcPhrase->GetFilteredInfo_After(), filterMkr, offset)) != -1

					if (bDidSomeUnfiltering_After)
					{

						wxASSERT(FALSE); // tell developer this stuff is incomplete

					}
				} // end of TRUE block for test: if (!pSrcPhrase->GetFilteredInfo_After().IsEmpty())

				if (bDidSomeUnfiltering)
				{
					// the original pSrcPhrase still stores its original nav text in its
					// m_inform member and this is now out of date because some of its content
					// has been unfiltered and made visible, so we have to recalculate its
					// navtext now
					pSrcPhrase->m_inform = RedoNavigationText(pSrcPhrase);
				}

				// update progress bar every 200 iterations
				++nOldCount;
				if (nOldCount % 200 == 0) //if (20 * (nOldCount / 20) == nOldCount)
				{
					pStatusBar->UpdateProgress(_("Processing Filtering Change(s)"), nOldCount, msgDisplayed);
				}

				endingMkrsStr.Empty();
			} // loop end for checking each pSrcPhrase for presence of material to be unfiltered

			// BEW 20Sep19, with the change to storing filtered info on the prececing CSourcePhrase,
			// this check should now be unnecessary - but no harm in retaing it.

			// Check for an orphan carrier of filtered info at the end of the document, which
			// has no longer got any filtered info, and if that is the case, remove it from the
			// document
			SPList::Node* posLast = pList->GetLast();
			CSourcePhrase* pLastSP = posLast->GetData();
			if (pLastSP->m_key.IsEmpty() && pLastSP->GetFilteredInfo().IsEmpty())
			{
				// it needs to be deleted
				gpApp->GetDocument()->DeleteSingleSrcPhrase(pLastSP); // delete it and its partner pile
				pList->DeleteNode(posLast);
			}
		}

	} // end block for test bUnfilteringRequired

	// reinitialize the variables we need
	pos_pList = NULL;
	pSrcPhrase = NULL;
	wxString mkr; // whm 3Jan2024 temporarily added mkr initialization here
	mkr.Empty();
	nFound = -1;

	// Do the filtering pass now
	curSequNum = -1;
	if (bFilteringRequired)
	{
		// reinitialize the progress bar, and recalc the layout in case the view
		// does some painting when the progress bar is tampered with below
		UpdateSequNumbers(0); // get the numbers updated, as a precaution

		// reinitialize the progress window for the filtering loop
		nOldTotal = pList->GetCount();
		if (nOldTotal == 0)
		{
			pSublist->Clear();
			if (pSublist != NULL) // whm 11Jun12 added NULL test
				delete pSublist;
			pSublist = NULL;
			pStatusBar->FinishProgress(_("Processing Filtering Change(s)"));
			return FALSE;
		}
		nOldCount = 0;

		progMsg = _("Pass 2 - %d of %d Total words and phrases");
		msgDisplayed = progMsg.Format(progMsg, 1, nOldTotal);
		pStatusBar->UpdateProgress(_("Processing Filtering Change(s)"), nOldCount, msgDisplayed);

		// the following variables are for tracking how the active sequence number has to
		// be updated after each span of material designated for filtering is filtered out
		bool bBoxBefore = TRUE; // TRUE when the active location is before the first sourcephrase being filtered
		bool bBoxAfter = FALSE; // TRUE when it is located after the last sourcephrase being filtered
		// if both are FALSE, then the active location is within the section being filtered out
		int nStartLocation = -1; // gets set to the sequence number for the first sourcephrase being filtered
		int nAfterLocation = -1; // gets set to the sequ num for the first source phrase after the filter section
		int nCurActiveSequNum = gpApp->m_nActiveSequNum;
		wxASSERT(nCurActiveSequNum >= 0);

		// whm 4Mar2024 renamed the wholeMkr to wholeMkrBeingFiltered, bareMkr to bareMkrBeingFiltered,
		// wholeShortMkr to wholeShortMkrBeingFiltered, etc, to avoid confusion with the 
		// markers stored within the pSrcPhrase instances examined within the while (pos_pList != NULL) 
		// loop iteration of source phrases.
		wxString wholeMkrBeingFiltered;
		wxString bareMkrBeingFiltered; // wholeMkrBeingFiltered without the latter's backslash
		wxString shortMkr; // wholeShortMkr without the latter's initial backslash
		wxString wholeShortMkBeingFiltered;
		wxString endMkrBeingFiltered;
		endMkrBeingFiltered.Empty();
		bool bHasEndmarker = FALSE;
		pos_pList = pList->GetFirst();
		SPList::Node* posStart = NULL; // location of first sourcephrase instance
									   // being filtered out
		SPList::Node* posEnd = NULL; // location of first sourcephrase instance
									 // after the section being filtered out
		wxString filteredStr; // accumulate filtered source text here
		wxString existingFilteredInfo; // accumulate existing filtered source text here // whm 24Oct2023 added
		wxString tempStr;
		wxString preStr; preStr.Empty(); // store in here m_filteredInfo content (from first pSrcPhrase)
						// which is already in m_filteredInfo; we need to carry preStr
						// contents forward to the pSrcPhrase which follows our filtered
						// out span, and insert it at top of m_filteredInfo so that
						// if we do some unfiltering sometime, we do it top down, and
						// that will keep our unfiltered information in correct order -
						// because what we filter is immediately preceding the
						// pSrcPhrase which is going to store the filtered info.
		wxString remainderStr; remainderStr.Empty(); // store here anything in m_filteredInfo which follows
							  // the to-be-filtered marker (from first pSrcPhrase)
		wxString strFilteredStuffToCarryForward; // put already filtered stuff which
				// is stored on the first CSourcePhrase of a to-be-filtered section
				// in here, and at the end of the inner loop, deal with it
		int filterableMkrOffset = -1; // initialize
		int filterableMkrOffset_NB = -1; // non-binding equivalent for filterableMkrOffset
		wxChar backslash[2] = { gSFescapechar,_T('\0') }; // Bill made it a null-terminated array,
			 // gSFescapechar is already defined as unicode wxChar = _T('\\') in AI.cpp
		int nStartingOffset = 0;     // initialize
		int nStartingOffset_NB = 0;  // initialize
		bool bIsUnknownMkr = FALSE;
		bool bMarkerInNonbindingSet = FALSE;
#if defined (_DEBUG)
		{
			if (pSrcPhrase != NULL && pSrcPhrase->m_nSequNumber == 43)
			{
				int halt_here = 1;
				wxUnusedVar(halt_here);
				wxString mmkrs = pSrcPhrase->m_markers;
			}
		}
#endif

		// We are currently in the TRUE block if (bFilteringRequired)

		// Filtering loop starts - each iteration deals with one CSourcePhrase instance
		while (pos_pList != NULL)
		{
			wholeMkrBeingFiltered = wxEmptyString; // must start empty at each iteration

			// acts on ONE instance of pSrcPhrase only each time it loops, but in so doing
			// it may remove many by imposing FILTERED status on a series of instances
			// starting from when it finds a marker which is to be filtered out in an
			// instance's m_markers member - when that happens the loop takes up again at
			// the sourcephrase immediately after the section just filtered out
			SPList::Node* oldPos = pos_pList;
			pSrcPhrase = (CSourcePhrase*)pos_pList->GetData();
			#if defined (_DEBUG) //&& !defined(NOLOGS)
			{
				if (pSrcPhrase != NULL && pSrcPhrase->m_nSequNumber == 39)
				{
					int halt_here = 1;
					wxUnusedVar(halt_here);
					wxString mmkrs = pSrcPhrase->m_markers;
				}
			}
			#endif

			// whm 6Nov2023 provide a pointer to the previous source phrase. We'll use
			// this to store filtered info from a previously unfiltered char attribute
			// marker.
			//CSourcePhrase* pPrevSrcPhrase = NULL;
			SPList::Node* prevPos = pos_pList->GetPrevious();
			//if (prevPos != NULL)
			//{
			//	pPrevSrcPhrase = (CSourcePhrase*)prevPos->GetData();
			//}

			pos_pList = pos_pList->GetNext();
			curSequNum = pSrcPhrase->m_nSequNumber;
			nCurActiveSequNum = gpApp->m_nActiveSequNum;

			// BEW 21Sep10, docVersion 5 changes some of the requirements below, as noted.
			// BEW 30Sep19 docVersion 9, added m_inlineNonbindingMarkers as a place to check...
			// loop until we find a sourcephrase which is a candidate for filtering - such
			// a one will satisfy all of the following requirements:
			// 1. m_markers is not empty, or m_inlineNonbindingMarkers is not empty
			// 2. there is at least one marker in one of the above (look for gSFescapechar)
			// 3. the candidate marker, will be in m_markers currently, or in
			//      m_inlineNonbindingMarkers currently
			// 4. the candidate marker will NEVER be an endmarker (docVersion 9 stores
			//      them now in the m_endMarkers member, or m_inlineNonbindingEndMarkers)
			// 5. the marker's USFMAnalysis struct's filter member is currently set to TRUE
			//		(note: markers like xk, xr, xt, xo, fk, fr, ft etc which are inline
			//      between \x and its matching \x* or \f and its matching \f*, etc, are
			//      marked filter==TRUE, but they have to be skipped, and their
			//      userCanSetFilter member is **always** FALSE. We won't use that fact,
			//      but we use the facts that the first character of their markers is
			//      always the same, x for cross references, f for footnotes, etc, and that
			//      they will have inLine="1" ie, their inLine value in the struct will be
			//      TRUE. Then when parsing over a stretch of text which is marked by a
			//      marker which has no endmarker, we'll know to halt parsing if we come to
			//      a marker with inLine == FALSE; but if TRUE, then a second test is
			//      needed, textType="none" NOT being current will effect the halt - so
			//      this pair of tests should enable us to prevent parsing overrun. (Note:
			//      we want our code to correctly filter a misspelled marker which is
			//      always to be filtered, after the user has edited it to be spelled
			//      correctly.
			// 6. the marker is listed for filtering in the wxString strMarkersToBeFiltered
			//      (determined from the m_FilterStatusMap map which is set from the
			//      Filtering page of the GUI)
			wxString markersStr = wxEmptyString;
			wxString endMarkersStr = wxEmptyString; // whm 5Mar2024 added
			wxString inlineNonbindingMarkersStr = wxEmptyString;
			// We don't test inlineBindingMarkers - these are character marking type, the
			// nonbinding ones can be several, such as \fig ... \fig*, \esb ... and ending at \esbe
			// and so forth. So we extend our testing to look at inline non-binding markers too.
			// The next block speeds processing - if there are no begin-markers in the two
			// relevant storage locations, we can immediately iterate to the next pSrcPhrase
			markersStr = pSrcPhrase->m_markers;
			endMarkersStr = pSrcPhrase->GetEndMarkers();
			inlineNonbindingMarkersStr = pSrcPhrase->GetInlineNonbindingMarkers();

			if (markersStr.IsEmpty() && inlineNonbindingMarkersStr.IsEmpty())
			{
				++nOldCount;
				if (nOldCount % 200 == 0) //if (20 * (nOldCount / 20) == nOldCount)
				{
					msgDisplayed = progMsg.Format(progMsg, nOldCount, nOldTotal);
					pStatusBar->UpdateProgress(_("Processing Filtering Change(s)"), nOldCount, msgDisplayed);
				}
				if (!endMarkersStr.IsEmpty())
				{
					if (endMarkersStr.Find(_T("\\x*")) != wxNOT_FOUND)
					{
						m_bIsWithinCrossRef_X_Span = FALSE;
					}
				}

				continue;
			}

			// whm 5Mar2024 the check for \x* end marker is needed here too as well as within 
			// the block above, since the continue statement above would skip checking for end
			// marker \x* here if markerStr was empty, and the check for end marker \x* would 
			// be skipped there is markerStr was not empty. Hence this check is needed in both
			// places.
			if (!endMarkersStr.IsEmpty())
			{
				if (endMarkersStr.Find(_T("\\x*")) != wxNOT_FOUND)
				{
					m_bIsWithinCrossRef_X_Span = FALSE;
				}
			}

			// BEW 30Sep19 For simplicity, the best way to handle filtering when
			// m_markers and m_inlineNonbindingMarkers could, either one, contain
			// the begin-marker which is, with its content, to be filtered out, is
			// to here create two if TRUE blocks based on testing m_inlineNonbindingMarkers
			// for non-empty, and m_markers for non-empty. Order of these tests is
			// immaterial - I've put the m_inlineNonbindingMarkers test first; any
			// marker for filtering cannot be in both storage locations on the one
			// pSrcPhrase. m_inlineNonbindingMarkers, if it contains anything,
			// won't contain contentless markers like \b, so we can code more simply.
			// After determining where the marker is located, control is directed
			// to one of two processing blocks, depending in the value of the flag
			// bMarkerInNonbindingSet. (If the begin marker is in m_inlineNonbindingMarkers,
			// then the relevant processing block will, of course, need to hunt for its
			// endmarker in m_inlineNonbindingEndMarkers, not m_endMarkers.)
			// whm 28May2024 removed title and msg strings below
			//wxString title = _("Marker cannot be filtered at beginning of document");
			/*
			wxString msg, msg1, msg2, msg3, msg4, msg5, msg6, msg7, msg8, msg9, msg10, msg11;
			wxString msg12, msg13, msg14, msg15, msg16, msg17, msg18, msg19, msg20, msg21, msg22;
			msg1 = _("   You have chosen to filter the \\%s marker, but that marker is at the very beginning of the Document.\n");
			msg2 = _("A marker at the beginning of the document CANNOT be filtered when there also is no \\id <CODE> line\n");
			msg3 = _("or other text at the beginning of the document. The USFM standard specified that Scripture should have an\n");
			msg4 = _("\\id <CODE> line at the beginning of the document. You can continue filtering the \\%s marker, or abort this\n");
			msg5 = _("filtering operation. If you continue, not all of the \\%s markers will be filtered.\n");
			msg6 = _("   We recommend that you ABORT the current filtering operation and instead do the Edit Source Text (from the\n");
			msg7 = _("Edit menu), and ADD an appropriate \\id <CODE> identification line in the text before the first \\%s marker.\n");
			msg8 = _("Please do the following:\n\n");
			msg9 = _("   1. Read and write down these steps to Edit the Source Text, and add an \\id <CODE> line at the beginning\n");
			msg10 = _("      of the document.\n");
			msg11 = _("   2. Abort the current filtering process by clicking on \"YES\" below.\n");
			msg12 = _("   3. Click on the first word of the \\%s marker's source text to select it - it will have a yellow background\n");
			msg13 = _("      when selected.\n");
			msg14 = _("   4. Select \"Edit Source Text\" from Adapt It's \"Edit\" menu.\n");
			msg15 = _("   5. In the \"Edit Source Text\" dialog, type: \\id XXX\n");
			msg16 = _("      before the \\%s marker. XXX is the 3-letter Scripture book code for the document that is displaying\n");
			msg17 = _("      on screen. Click \"OK\" once you've added that line to the beginning of the document.\n");
			msg18 = _("   6. You can now fully filter the \\%s marker using the \"USFM and Filtering\" tab in the Edit > Preferences.\n");
			msg19 = _("       All of the \\%s markers will then be filtered (and can be viewed by clicking on the green wedges).\n\n");
			msg20 = _("Do you want to abort?\n");
			msg21 = _("Click YES to abort, or NO to continue with the filtering operation.");
			msg = msg1 + msg2 + msg3 + msg3 + msg5 + msg6 + msg7 + msg8 + msg9 + msg10 + msg11 + msg12 + msg13 + msg14 + msg15 + msg16 + msg17 + msg18 + msg19 + msg20 + msg21;
			*/
			/*
			wxString msg = _(
"   You have chosen to filter the \\%s marker, but that marker is at the very beginning of the Document. A marker at the beginning of the document CANNOT be filtered when there also is no \\id <CODE> line or other text at the beginning of the document.\n"
"   The USFM standard specifies that Scripture should have an \\id <CODE> line at the beginning of the document. You can continue filtering the \\% s marker, or abort this filtering operation. If you continue, not all of the \\%s markers will be filtered.\n"
"   We recommend that you ABORT the current filtering operation, and instead do the Edit Source Text (from the Edit menu), and ADD an appropriate \\id <CODE> identification line in the text before the first \\%s marker.\n"
"Please do the following:\n"
"   1. Read and write down these steps to Edit the Source Text, and add an \\id <CODE> line at the beginning of the document.\n"
"   2. Abort the current filtering process by clicking on \"YES\" below.\n"
"   3. Click on the first word of the \\%s marker's source text (%s) to select it - it will have a yellow background when selected.\n"
"   4. Select \"Edit Source Text\" from Adapt It's \"Edit\" menu. In the \"Edit Source Text\" dialog, type before the \\%s marker:\n"
"      \\id XXX\n"
"Note: XXX is the 3-letter Scripture book code for the document that is displaying on screen, for example MRK for The Gospel of Mark.\n"
"   5. Click \"OK\" once you've added that line to the beginning of the document.\n"
"   6. You can now fully filter the \\%s marker using the \"USFM and Filtering\" tab in the Edit > Preferences. All of the \\%s markers will then be filtered (and can be viewed by clicking on the green wedges).\n\n"
"Do you want to abort?\n\n"
"Click YES to abort, or NO to continue with the filtering operation.");
			*/
			if (!inlineNonbindingMarkersStr.IsEmpty())
			{

				nStartingOffset_NB = 0;

				bMarkerInNonbindingSet = FALSE; // initialize
				bIsUnknownMkr = FALSE; // unknown markers will NEVER be in
					// m_inlineNonbindingMarkers, but needed for the call below

				filterableMkrOffset_NB = ContainsMarkerToBeFiltered(
					gpApp->gCurrentSfmSet,           // in
					inlineNonbindingMarkersStr,      // in
					strMarkersToBeFiltered,          // in
					wholeMkrBeingFiltered, wholeShortMkBeingFiltered, endMkrBeingFiltered, // each is 'out'
					bHasEndmarker, bIsUnknownMkr,    // both are 'out'
					nStartingOffset_NB);			 // in
				//wxLogDebug(_T("%s::%s() , line  %d  wholeMarker =  %s"), __FILE__, __FUNCTION__, __LINE__, wholeMkrBeingFiltered.c_str());
				
				// If not in nonbinding mkr storage, exit block and let control 
				// go on to check m_markers block just below
				if (filterableMkrOffset_NB == wxNOT_FOUND)
				{
					// This marker is in pSrcPhrase->m_inlineNonbindingMarkers but it is NOT to be filtered, 
					// so iterate to the next sourcephrase at top of loop
					++nOldCount;
					if (nOldCount % 200 == 0) //if (20 * (nOldCount / 20) == nOldCount)
					{
						msgDisplayed = progMsg.Format(progMsg, nOldCount, nOldTotal);
						pStatusBar->UpdateProgress(_("Processing Filtering Change(s)"), nOldCount, msgDisplayed);
					}

					continue;
				}
				else
				{
					/*
					// whm 28May2024 commented out the check for m_nSequNumber == 0 below
					// as it is no longer needed with changes made in UsfmFilterPage.cpp

					// whm 6Apr2024 added. We've found a marker that is to be filtered.
					// Check whether the sequence number of pSrcPhrase is zero. If so,
					// there will be no valid pPrevSrcPhrase on which to store the marker.
					// We'll warn the user that this marker at the beginning of the document 
					// will not be filtered due to there not being an \id XXX line within
					// this document. If this same marker occurs later within this document 
					// they will be filtered if the user decides to continue with the 
					// filtering operation. If the user opts to abort the filter operation
					// no filtering will take place.
					if (pSrcPhrase->m_nSequNumber == 0)
					{
						// We're at the first pSrcPhrase in the document's pList. There is 
						// no valid pPrevSrcPhrase available to store filtered material which
						// means that there is no \id XXX line at the beginning of the document.
						// This violates the USFM standard that says of the \id <CODE> marker:
						//    "This is the initial USFM marker in any scripture text file."
						// Since this Scripture file is non-standard we will warn the user and
						// allow the user to decide whether to continue - and not get the current
						// marker filtered here at the beginning of the file, or abort the filtering
						// operation. Continuing would mean the user would have the first marker 
						// here at the beginning of the document be unfiltered whereas the same
						// marker in other parts of the document would be filtered. The marker
						// within the USFM and Filtering tab, will indicate that the marker is 
						// unticked/unfiltered, but that would be a discrepancy for that marker
						// here at the beginning of the Doc which would remain unfiltered. In 
						// order to fix this situation the user would have to edit the document
						// and add the proper \id XXX line at the beginning of the document, then
						// unfilter that same marker, then re-filter that same marker again.
						// Another alternative would be for the user to edit the input file that
						// was used to create the document originally and add the \id XXX line to
						// that input file, and then re-create the document afresh from the input
						// file - a process that might wipe out some work if the document has had
						// many adaptations added to it before the user initiated the current
						// filtering process.
						msg = msg.Format(msg, wholeMkrBeingFiltered.c_str(), wholeMkrBeingFiltered.c_str(), wholeMkrBeingFiltered.c_str(), wholeMkrBeingFiltered.c_str(),
							wholeMkrBeingFiltered.c_str(), pSrcPhrase->m_srcPhrase.c_str(), wholeMkrBeingFiltered.c_str(), wholeMkrBeingFiltered.c_str(), wholeMkrBeingFiltered.c_str());

						int response = 0;
						response = wxMessageBox(msg, title, wxICON_WARNING | wxYES_NO | wxYES_DEFAULT);
						if (response == wxYES)
						{
							// User opted to sbort the filtering operation (and maybe do the recommended
							// Edit Source Text to add an \id XXX line to the beginning of the document).
							// Return TRUE here from ReconstisuteAfterFilteringChange() as we have no 
							// fixesStr to report in this case.
							return TRUE;
						}
						else
						{
							// User opted to continue the filtering process, but we must skip this first
							// marker in the document.
							continue; // to skip over the filtering of this marker
						}
					}
					*/
					// we found the filter marker within pSrcPhrase->m_inlineNonbindingMarkers
					bMarkerInNonbindingSet = TRUE; // TRUE causes the m_markers test block to be skipped
				}

			} // end of TRUE block for test: if (!inlineNonbindingMarkersStr.IsEmpty())

#if defined (_DEBUG) && !defined(NOLOGS)
			{
				if (pSrcPhrase != NULL && pSrcPhrase->m_nSequNumber >= 24)
				{
					int halt_here = 1;
					wxUnusedVar(halt_here);
					wxString mmkrs = pSrcPhrase->m_markers;
				}
			}
#endif

			// Legacy code....  Skip this block if the marker was found in the
			// m_inlineNonbindingMarkers storage member of pSrcPhrase
			if (pSrcPhrase != NULL && !pSrcPhrase->m_markers.IsEmpty() && !bMarkerInNonbindingSet)
			{
				// Legacy block, which looks only at m_markers

				// NOTE: **** the legacy algorithm allows the user to put italics 
				// substrings (marked by \it ... \it*), or similar marker & endmarker
				// pairs, within text spans potentially filterable - this should be
				// safe because such embedded content marker pairs should have a 
				// TextType of none in the XML marker specifications document, and 
				// Adapt It will skip such ones, but stop scanning when either
				// inLine is FALSE, or if TRUE, then when TextType is not none ****

				nStartingOffset = 0;

g:				bIsUnknownMkr = FALSE;

				filterableMkrOffset = ContainsMarkerToBeFiltered(
					gpApp->gCurrentSfmSet,
					markersStr, 
					strMarkersToBeFiltered, 
					wholeMkrBeingFiltered, wholeShortMkBeingFiltered, endMkrBeingFiltered,
					bHasEndmarker, bIsUnknownMkr, 
					nStartingOffset);

				if (filterableMkrOffset == wxNOT_FOUND)
				{
					// either wholeMkrBeingFiltered is not filterable, or its not in strMarkersToBeFiltered
					// and its not in m_inlineNonbindingMarkers
					// -- if so, just iterate to the next sourcephrase
					++nOldCount;
					if (nOldCount % 200 == 0) //if (20 * (nOldCount / 20) == nOldCount)
					{
						msgDisplayed = progMsg.Format(progMsg, nOldCount, nOldTotal);
						pStatusBar->UpdateProgress(_("Processing Filtering Change(s)"), nOldCount, msgDisplayed);
					}

					continue;
				}
				else
				{
					/*
					// whm 28May2024 commented out the check for m_nSequNumber == 0 below
					// as it is no longer needed with changes made in UsfmFilterPage.cpp

					// whm 6Apr2024 added. We've found a marker that is to be filtered.
					// Check whether the sequence number of pSrcPhrase is zero. If so,
					// there will be no valid pPrevSrcPhrase on which to store the marker.
					// We'll warn the user that this marker at the beginning of the document 
					// will not be filtered due to there not being an \id XXX line within
					// this document. If this same marker occurs later within this document 
					// they will be filtered if the user decides to continue with the 
					// filtering operation. If the user opts to abort the filter operation
					// no filtering will take place.
					if (pSrcPhrase->m_nSequNumber == 0)
					{
						// We're at the first pSrcPhrase in the document's pList. There is 
						// no valid pPrevSrcPhrase available to store filtered material which
						// means that there is no \id XXX line at the beginning of the document.
						// This violates the USFM standard that says of the \id <CODE> marker:
						//    "This is the initial USFM marker in any scripture text file."
						// Since this Scripture file is non-standard we will warn the user and
						// allow the user to decide whether to continue - and not get the current
						// marker filtered here at the beginning of the file, or abort the filtering
						// operation. Continuing would mean the user would have the first marker 
						// here at the beginning of the document be unfiltered whereas the same
						// marker in other parts of the document would be filtered. The marker
						// within the USFM and Filtering tab, will indicate that the marker is 
						// unticked/unfiltered, but that would be a discrepancy for that marker
						// here at the beginning of the Doc which would remain unfiltered. In 
						// order to fix this situation the user would have to edit the document
						// and add the proper \id XXX line at the beginning of the document, then
						// unfilter that same marker, then re-filter that same marker again.
						// Another alternative would be for the user to edit the input file that
						// was used to create the document originally and add the \id XXX line to
						// that input file, and then re-create the document afresh from the input
						// file - a process that might wipe out some work if the document has had
						// many adaptations added to it before the user initiated the current
						// filtering process.
						msg = msg.Format(msg, wholeMkrBeingFiltered.c_str(), wholeMkrBeingFiltered.c_str(), wholeMkrBeingFiltered.c_str(), wholeMkrBeingFiltered.c_str(),
							wholeMkrBeingFiltered.c_str(), pSrcPhrase->m_srcPhrase.c_str(), wholeMkrBeingFiltered.c_str(), wholeMkrBeingFiltered.c_str(), wholeMkrBeingFiltered.c_str());

						int response = 0;
						response = wxMessageBox(msg, title, wxICON_WARNING | wxYES_NO | wxYES_DEFAULT);
						if (response == wxYES)
						{
							// User opted to sbort the filtering operation (and maybe do the recommended
							// Edit Source Text to add an \id XXX line to the beginning of the document).
							// Return TRUE here from ReconstisuteAfterFilteringChange() as we have no 
							// fixesStr to report in this case.
							return TRUE;
						}
						else
						{
							// User opted to continue the filtering process, but we must skip this first
							// marker in the document.
							continue; // to skip over the filtering of this marker
						}
					}
					*/
				}

			} // end of TRUE block for test: if (!pSrcPhrase->m_markers.IsEmpty() && !bMarkerInNonbindingSet)

			// First, get whatever is currently in m_filteredInfo and put in
			// strFilteredStuffToCarryForward; because after our new span is filtered,
			// the next pSrcPhrase must have this prepended in its m_filteredInfo member
			// - which could, of course, be empty and usually would be; but if filtering
			// more than one marker, we must take care to try preserve information order.
			//								IMPORTANT
			// Sadly, the Filtering tab of Preferences lets the user choose more than one
			// marker for unfiltering at a time, and that can introduce a reordering of the
			// unfiltered information. Best we can do is filter to the start of the m_filteredInfo
			// string, and hope that the user has a look first in the FilteredInformationDialog
			// before unfiltering, and unfilters first, top down, anything preceding the marker
			// he/she wants to unfilter. That way, the m_filteredInfo string will behave like
			// a LIFO stack, because the pSrcPhrase carrying the more-than-one filtered strings
			// will stay fixed in location and all the unfiltering will get inserted before it
			// in correct information order.
			// Adapt It will do best if the user filters only one marker at a time, and unfilters
			// only one at a time, via Preferences' USFM & Filtering tab.
			// 
			// whm 31Oct2023-14Oct2023 comment about the above comments on the reordering issue. 
			// There are a number of scenarios where filtering can result in different 
			// orderings of multiple adjacent filtered markers within the m_filteredInfo source
			// phrase mamber string including the carrying forward of filtered material when
			// a previously filtered marker is already stored on the last word of associated 
			// text of a marker currently being filtered. After exploring a number of ways of 
			// handling the filtering and subsequent unfiltering of adjacent filterable markers
			// I came up with 2 possible methods to help determine the proper ordering of 
			// filtered markers within the m_filteredInfo string, and deterining the position
			// of previously filtered material now being unfiltered:
			//		Method 1. Reworking our USFMAnalysis struct to include the "occursUnder"
			// information available from the usfm 3.0 standard's usfm.sty stylesheet, then 
			// drawing on that information when it is not clear at what position in 
			// m_filteredInfo subsequently filtered adjacent markers should be inserted within 
			// that string. I refactored the USFMAnalysis struct and its related functions to 
			// incorporate the "occursUnder" information so that it is now easily available by 
			// just calling LookupSFM() and examining the new pUSFMAnalysis->occursUnder member. 
			// This method worked for some situations, however, later I found the occursUnder 
			// information to be incomplete, especially for some common adjacent marker sequences 
			// such as \ms \mr \s \r (all filterable) which commonly occur within the Nyindrou
			// Scriptures - and marker sequences that are likely in other projects that work from
			// highly marked up, already published Scriptures. The problem is that the occursUnder
			// info can help order \mr AFTER/"occursUnder" the \ms marker, and also order the \r 
			// marker under the \s marker, but the occursUnder information doesn't help order 
			// the \s marker in relation to the \mr marker since the occursUnder list of markers 
			// for \s only lists the \c marker, and not others like \mr and \ms. Hence, after 
			// refactoring to include access to the occursUnder information (which may eventually
			// be of some help), I decided on a more determinate and hopefully more comprehensive 
			// methos of determining the proper ordering of multiple adjacent filtered markers 
			// within m_filteredInfo, but also where the marker-being-unfiltered along with its
			// accociated text should be inserted back into the text. 
			// The unfiltering process is more complex than the filtereing process since, when
			// unfiltering, one must often deal with determining how many source phrases forward 
			// or backwards to position the insertion point of the sublist of source phrases 
			// composing the associated text of the marker being unfiltered. This issue can be
			// quite complex when the situation involves 4 or more filterable adjacent markers 
			// that were previously filtered (such as \ms \mr \s and \r), and are now being
			// unfiltered. The ordering possibilities for 4 adjacent markers can involve 24
			// different orders of unfiltering!
			// 
			// Update 20Nov2023 Method 1 above is insufficient due to the occursUnder info not
			// being exhaustive. When the markers \ms \mr \s \r are all adjacent the occursUnder
			// information can be used to determine the relative ordering of the pair \ms and \mr, 
			// as well as the pair \s and \r. However it cannot determine the relative ordering 
			// of the first pair \ms mr when occuring adjacent to \s \r. Therefore, I've opted to
			// develop Method 2 below as the preferred solution.
			//		Mehod 2. A more determinate method for the positioning of filtered marterial, 
			// and positioning the insertion point of material being unfiltered, can be had by
			// storing a slightly modified usfm structure file in a hidden folder .usfmstruct
			// residing in the project's Adaptations folder. The usfm struct file is easily
			// and quickly generated by our existing function GetUsfmStructureAndExtent()
			// from CollabUtilities.cpp. This function creates a wxArrayString of lines,
			// each line having one usfm marker followed by colon-separated fields of
			// information including a field that represents the number of characters tallied
			// for the marker and its associated text, and a field that has an MD5 sum for
			// the marker and its associated text. The text file generated by the 
			// GetUsfmStructureAndExtent() function is called at the time a source text
			// is loaded from disk or received from Paratext and before TokenizeText() is
			// called on to parse the source input file. At this time the usfm struct file
			// is created and lives in its hidden folder for the life of the document. I
			// tweaked the usfm file to remove the MD5 information and in its place keep a
			// single "0" or "1" in its last field to indicate whether the particular marker
			// listed on each line is filtered ("1"), or not-filtered ("0"). The filtering
			// status recorded in the file is done by a separate function call that is
			// done after TokenizeText() has processed the input file and at other times
			// such as after editing the source text. That function is called 
			// UpdateCurrentFilterStatusOfUsfmStructFileAndArray().

			strFilteredStuffToCarryForward = pSrcPhrase->GetFilteredInfo(); // could be empty

			// Direct the program execution to the next block if m_inlineNonbindingMarkers 
			// has the filter marker. Else to the block of legacy code if m_markers has the 
			// filter marker - the legacy block has a little more stuff in it, but basically
			// each does the same job in the same way - the differences being due to scanning
			// for the matching endMarker in m_inlineNonbindingEndMarkers versus m_endMarkers
#if defined (_DEBUG) && !defined(NOLOGS)
			{
				if (pSrcPhrase != NULL && pSrcPhrase->m_nSequNumber >= 2)
				{
					int halt_here = 1;
					wxUnusedVar(halt_here);
					wxString mmkrs = pSrcPhrase->m_markers;
				}
			}
#endif
			// whm 29Mar2024 TODO: Merge the "legacy" else part of the filtering
			// routines below together into a single filtering block!!!
			// Except for small differences the following if (bMarkerInNonbindingSet) 
			// block and the else block farther below, and a goto g; jump, they are 
			// almost identical.
			// It is somewhat error prone to have two almost identical blocks,
			// as it is easy to make a change in one block and forget to make
			// a similar change to the other block - which has cause considerable
			// grief in debugging. 
			if (bMarkerInNonbindingSet)
			{
				// whm 24Oct2023 Note: The only non-binding markers are the inline ones:
				// _T("\\wj \\sls \\tl \\+wj \\+qt \\+sls \\+tl \\fig \\+fig \\jmp \\+jmp ")
				// and the only filterable ones of the above are the \fig and \jmp markers 
				// - the \fig and \jmp markers being the only ones with the property 
				// userCanSetFilter="1".
				// Therefore this block should only be entered when the \fig \+fig,
				// or \jmp \+jmp makers have had a filtering change.
				// 
				// [BEW] Non-binding markers do not nest. So there should only be the one
				// begin marker to filter out, from m_inlineNonbindingMarkers member.
				// So we will simply set preStr and remainderStr to empty (we won't try
				// any fancy stuff, such as to move preceding stored markers to the 
				// pPrevSrcPhrase defined later below - first in the post-span list,
				// they should not be present anyway, and if so, let them die).
				// 
				// whm 24Oct2023 Comment on BEW comment above: The \+fig and \+jmp marker
				// forms are "nested markers" and they are included within the inline non-
				// binding markers - see above.
				preStr = wxEmptyString;
				remainderStr = wxEmptyString;
				// m_inlineNonbindingMarkers can now be cleared, we've got the info we need
				// whm 6Mar2024 Modified. We must not clear the m_inlineNonbindingMarkers at
				// this point. When filtering we need the inline nonbinding begin marker when
				// we rebuild the text from all the sub-list including the first SP in the
				// list which is this pSrcPhrase.
				//wxString strEmpty = wxEmptyString;
				//pSrcPhrase->SetInlineNonbindingMarkers(strEmpty);

				// okay, we've found a begin-marker to be filtered, we now have to look ahead to find
				// which CSourcePhrase instance is the last one in this filtering sequence - we
				// will assume the following (Our tokenising function should ensure these constraints):
				// 1. unknown markers never get stored in m_inlineNonbindingMarkers, so
				//      we don't have to code for their presence
				// 2. if the marker has an endmarker, then any other markers are skipped over -
				//      we just look for the matching endmarker as the last marker in the 
				//	    m_inlineNonbindingEndMarkers member - and that owning CSourcePhrase
				//		instance would then be the last in the span 
				// 3. filterable content markers which lack an endmarker will never occur
				//	    in m_inlineNonbindingMarkers
				// 4. filterable footnotes, endnotes or cross references likewise, though they
				//      are inline and take end-markers, will also never occur in 
				//      m_inlineNonbindingMarkers; they are handled by the legacy code block
				//      which deals only with m_markers and m_filteredInfo

#if defined (_DEBUG) && defined(WHERE)
				{
					if (pSrcPhrase != NULL && pSrcPhrase->m_nSequNumber >= 2)
					{
						int halt_here = 1;
						wxUnusedVar(halt_here);
						wxString mmkrs = pSrcPhrase->m_markers;
					}
				}
#endif

				// we can now partly or fully determine where the active location is in
				// relation to this location
				if (nCurActiveSequNum < pSrcPhrase->m_nSequNumber)
				{
					// if control comes here, the location is determinate
					bBoxBefore = TRUE;
					bBoxAfter = FALSE;
				}
				else
				{
					// if control comes here, the location is indeterminate - it might yet be
					// within the filtering section, or after it - we'll assume the latter, and
					// change it later if it is wrong when we get to the first sourcephrase
					// instance following the section for filtering
					bBoxBefore = FALSE;
					bBoxAfter = TRUE;
				}
				nStartLocation = pSrcPhrase->m_nSequNumber;
				// NOTE: we'll deal with preStr and remainderStr later

				// whm 24Oct2023 added a wxString existingFilteredInfo to deal with any 
				// existing filtered info found within the marker's associated text being 
				// currently processed. This existingFilteredInfo will consist of one or
				// more filter string(s) already delimited by \~FILTER ... \~FILTER* markers. 
				// Later below, if existingFilteredInfo is NOT empty, its contents will be 
				// prefixed to the filteredStr variable below after it has been completely 
				// processed, then the entire filtered information (existing and current)
				// will be set to the proper source phrase preceding the location where
				// this current pSrcPhrase's deep copy will be placed.
				existingFilteredInfo.Empty();

				posStart = oldPos; // preserve this starting location for later on

				// we can commence to build filteredStr now (Note: because filtering stores a
				// string, rather than a sequence of CSourcePhrase instances, any adaptations
				// will be thrown away irrecoverably. USFM3 attributes metadata restoration,
				// if needed, will take place later outside this function. 
				// whm 8Feb2024 delay adding the filterMkr  adn _T(' ') to filteredStr until
				// later below, since there may be swept up markers to add to filteredStr first
				// before adding the filterMkr
				//filteredStr = filterMkr; // add the \~FILTER beginning marker
				//filteredStr += _T(' '); // add space
				// 
				// whm 6Mar2024 removed this early appending of pSrcPhraseFirst (below), and 
				// instead we now only do the appending of new source phrases within the for loop:
				//   for (pos_partialList = pos_pList; pos_partialList != NULL; ). This avoidance 
				// of appending a source phrase here is needed since in some situations pSubList 
				// will have only one item in the list which is common for the \xt...\xt*
				// standalone marker being re-filtered. We also call 
				// pos_pList = posPList->GetPrevious() below to ensure we start the loop with the
				// first source phrase.
				//CSourcePhrase* pSrcPhraseFirst = new CSourcePhrase(*pSrcPhrase);
				//pSrcPhraseFirst->DeepCopy();
				//pSublist->Append(pSrcPhraseFirst); // we've already got the first to go in
					// the sublist, so put it there and then loop to get the rest

				// Enter an inner loop which has as it's sole purpose finding which
				// CSourcePhrase instance at pos_pList or beyond is the last one for filtering out
				// as part of the current filterable span. In the loop we make deep copies in
				// order to create a sublist of accepted within-the-span CSourcePhrase
				// instances; we then use UpdateSequNumbers() to renumber from 0 those
				// instances in the sublist, and then after the loop ends we process all the
				// sublist's contents in one hit by using the ExportFunctions.cpp function,
				// RebuildSourceText(), passing in a pointer to the sublist. Doing it this way
				// means that we have one place only for reconstituting the source text,
				// giving us consistency, and we get the inline markers handling done 'for
				// free' rather than having to add it to the complex code this approach replaces.
				// BEW 30Sep19, And that's where also, if needed, USFM3 attributes metadata in
				// m_punctsPattern, gets restored from being hidden.

				SPList::Node* pos_partialList; // this is for tracking the 'next' location
				CSourcePhrase* pSrcPhr; // we will look for a section-ending matching endmarker
					// in this one, if we don't find one, we iterate and try the
					// m_inlineNonbindingMarkers member of the next instance; if
					// we find a matching endmarker, pSrcPhr would be
					// WITHIN and at the end of the filterable section
				CSourcePhrase* pSrcPhraseNext; // we track the 'next' one at each
					// loop iteration, and if we fail to get correct halt location
					// we call IsEndingSrcPhrase() to make various safety checks
					// to try avoid span overrun and/or marker content overlap
				// whm 6Mar2024 correction. The pos_pList already advanced past the position of
				// the inline nonbingind begin marker. It is possible, especially when stand-alone
				// \xt is the inline nonbinding begin marekr, that there is only one source phrase
				// in the sublist that is not hidden away. In such cases the inline nonbinding END MARKER
				// may be on the same source phrase. Therefore, we should always start our search for 
				// the inline nonbinding end marker back at the previous source phrase where the begin
				// marker was located, and so we set pos_pList back to that position.
				pos_pList = pos_pList->GetPrevious();
				pSrcPhr = (CSourcePhrase*)pos_pList->GetData(); // avoids compiler warning
				//wxASSERT(pSrcPhr != NULL);

				// The scanning loop for the matching endmarker commences
				// note: execution breaks out when a halt location is determined
				// or at end of document
				for (pos_partialList = pos_pList; pos_partialList != NULL; )
				{
					//wxLogDebug(_T("%s::%s() , line  %d  wholeMarker =  %s"), __FILE__, __FUNCTION__, __LINE__, wholeMkrBeingFiltered.c_str());
					pSrcPhr = (CSourcePhrase*)pos_partialList->GetData();
					pos_partialList = pos_partialList->GetNext(); // advance to next Node of the passed in pList
					wxASSERT(pSrcPhr);
					posEnd = pos_partialList; // on exit of the loop, posEnd will be where
								   // pSrcPhraseNext is located, or NULL if we reached
								   // the end of the document
					if (pos_partialList == NULL)
					{
						pSrcPhraseNext = NULL;
					}
					else
					{
						pSrcPhraseNext = (CSourcePhrase*)pos_partialList->GetData();
					}

					// Check for a loop halt to scanning caused by finding the required
					// matching endMkrBeingFiltered for the contents of wholeMkrBeingFiltered. 
					// If no match is found (as would be the case if wholeMkrBeingFiltered is 
					// not an SFM which has a pairing endMkrBeingFiltered defined), then the 
					// pSrcPhraseNext instance needs to be checked - for a halt-causing 
					// begin-marker etc. If any of the criteria for halting the loop is not 
					// satisfied, the spanning loop continues.
					// A deep copy of the CSourcePhrase instance would then be made, and
					// accumulated to the sublist, and the loop iterates one or more times
					// until a halt is achieved - then control breaks from the loop and the
					// last pSrcPhrase (deep copy) is made & is added to the sublist which
					// constitutes the filtering span of instances.
					if (HasMatchingEndMarker(wholeMkrBeingFiltered, pSrcPhr, TRUE)) // 3rd param is
									// bSearchInNonbindingEndMkrs, which is default FALSE
									// doing the search in m_markers content, but here it is TRUE
					{
						// wxLogDebug(_T("%s::%s() , line  %d  wholeMarker =  %s"), __FILE__, __FUNCTION__, __LINE__, wholeMkrBeingFiltered.c_str());
						// whm 31Oct2023 correction. The following line gets pSrcPhr assigned to 
						// the following source phrase at pos_partialList with the result that the source
						// phrase pSrcPhr that gets appended to the pSubList below is NOT the
						// last word of the caption text being filtered, but the word of sacred
						// text following it!! That is not what we want, so I'm commenting out
						// the following line so that pSrcPhr remains the last word of caption
						// text and gets appended as the last source phrase in pSubList.
						//pSrcPhr = (CSourcePhrase*)pos_partialList->GetData();

						// halt here, this pSrcPhr is last in the filterable span
						break;
					}
					else if (pSrcPhraseNext != NULL)
					{

						// No match found, so check criteria for forcing a halt,
						// if no cause is found then continue iterating loop
						if (IsEndingSrcPhrase(gpApp->gCurrentSfmSet, pSrcPhraseNext, existingFilteredInfo)) // whm 24Oct2023 added 3rd parameter
						{
							// this 'next' CSourcePhrase instance causes a halt, and is not
							// itself to be within the filterable span, so the present
							// pSrcPhr instance is last in the span
							break;
						}
						// a FALSE value in the above test means that scanning should
						// continue, so just fall through to the code below which makes and
						// appends to the sublist the required deep copy of pSrcPhr
					}
					else // pSrcPhraseNext does not exist (the pointer is NULL)
					{
						// so pSrcPhr is the last CSourcePhrase instance in the document
						break;
					}
					// if control has not broken out of the loop, then we must continue
					// scanning over more CSourcePhrase instances till we halt; but first we
					// must create the needed deep copy and append it to the sublist
					CSourcePhrase* pSrcPhraseCopy = new CSourcePhrase(*pSrcPhr); // a shallow copy
					pSrcPhraseCopy->DeepCopy(); // now it's a deep copy of pSrcPhrase
					pSublist->Append(pSrcPhraseCopy);
				} // end of for loop: for (pos_partialList = pos_pList; pos_partialList != NULL; )
#if defined (_DEBUG) && !defined(NOLOGS)
				{
					if (pSrcPhrase != NULL && pSrcPhrase->m_nSequNumber >= 2)
					{
						int halt_here = 1;
						wxUnusedVar(halt_here);
						wxString mmkrs = pSrcPhrase->m_markers;
					}
				}
#endif

				// do the final needed deep copy of pSrcPhrase and append to the sublist
				CSourcePhrase* pSrcPhraseCopy = new CSourcePhrase(*pSrcPhr); // a shallow copy

				// whm 31Oct2023 added block below taken from the legacy filtering block farther below 
				wxString tempFInfo = pSrcPhr->GetFilteredInfo();
				if (!tempFInfo.IsEmpty() && existingFilteredInfo.Find(tempFInfo) != wxNOT_FOUND)
				{
					// The existingFilteredInfo we retrieved is located in this final pSrcPhr, 
					// and we will be carrying that filtered info forward to a different source
					// phrase below, so we need to remove it from this pSrcPhr.
					pSrcPhr->SetFilteredInfo(wxEmptyString);
				}

				pSrcPhraseCopy->DeepCopy(); // now it's a deep copy of pSrcPhrase
				pSublist->Append(pSrcPhraseCopy);
				// get the sequence numbers in the stored instances consecutive from 0
				UpdateSequNumbers(0, pSublist);

				// complete the determination of where the active location is in relation to
				// this filtered section, and work out the active sequ number adjustment needed
				// and make the adjustment
				if (bBoxBefore == FALSE)
				{
					// adjustment maybe needed only when we know the box was not located
					// preceding the filter section
					if (posEnd == NULL)
					{
						// at the document end, so everything up to the end is to be filtered;
						// so either the active location is before the filtered section (i.e.
						// bBoxBefore == TRUE), or it is within the filtered section (i.e.
						// bBoxBefore == FALSE)
						bBoxAfter = FALSE;
					}
					else
					{
						// posEnd is defined, so get the sequence number for this location
						nAfterLocation = posEnd->GetData()->m_nSequNumber;

						// work out if an adjustment to bBoxAfter is needed (bBoxAfter is
						// set TRUE so far)
						if (nCurActiveSequNum < nAfterLocation)
							bBoxAfter = FALSE; // the box lay within this section
											   // being filtered
					}
				}
				bool bPosEndNull = posEnd == NULL ? TRUE : FALSE; // used below
						// to work out where to set the final active location

				// Here we'export' or "rebuild" the src text into a wxString, and then append 
				// that to filteredStr farther below.
				wxString strFilteredStuff;
				strFilteredStuff.Empty();
				if (!pSublist->IsEmpty())
				{
					// BEW addition 9Apr15
					// After strFilteredStuffToCarryForward (that is, forward into  the m_filteredInfo
					// member string of the pSrcPhrase first after the span which gets removed)
					// but before RebuildSourceText() is called, we have to check (here) if the 
					// pSrcPhrase in pSublist contains any content from unfiltered custom markers,
					// and clear it out, and also clear out m_filteredInfo as well.

					// So, we'll do a loop now to unlaterally empty every member from which we don't want
					// any custom content to contribute to the value of strFilteredStuff that gets passed
					// back from the rebuild call.
					SPList::Node* pos_subList;
					CSourcePhrase* pSrcPhr = NULL;
					if (!pSublist->IsEmpty())
					{
						pos_subList = pSublist->GetFirst();
						while (pos_subList != NULL)
						{
							pSrcPhr = pos_subList->GetData();
							pos_subList = pos_subList->GetNext();
							pSrcPhr->SetFilteredInfo(_T(""));
							pSrcPhr->SetCollectedBackTrans(_T(""));
							pSrcPhr->SetNote(_T(""));
							pSrcPhr->SetFreeTrans(_T(""));
						}
					}
					// whm 6Nov2023 added. Need to reset m_bCurrentlyFiltering to TRUE,
					// because more than one marker may be filtered, and the RebuildSourceText()
					// sets the m_bCurrentlyFiltering to FALSE near the end of its function.
					// If we don't reinitialize m_bCurrentlyFiltering to TRUE, then subsequent
					// calls of RebuildSourceText() for any second and following char attribute 
					// markers will fail to have their hidden metadata included within their
					// filtered material.
					m_bCurrentlyFiltering = TRUE;

					// end of addition done on 9Apr15
					// BEW changed 29Mar23, pass in pointer, not a reference
					int textLen = RebuildSourceText(strFilteredStuff, pSublist);
					wxUnusedVar(textLen); // to avoid a compiler warning
					//wxLogDebug(_T("%s::%s() , line  %d  wholeMarker =  %s"), __FILE__, __FUNCTION__, __LINE__, wholeMkrBeingFiltered.c_str());

					// BEW 30Sep19 the above RebuildSourceText() will, embedded in it,
					// check for the existence of hidden USFM5 attributes metadata, and
					// unhide it. The returned textLen value will include the length of
					// that meta data in the returned strFilteredStuff

					// remove any initial whitespace
					strFilteredStuff.Trim(FALSE);
#if defined (_DEBUG) && !defined(NOLOGS)
					{
						if (pSrcPhrase != NULL && pSrcPhrase->m_nSequNumber >= 2)
						{
							int halt_here = 1;
							wxUnusedVar(halt_here);
							wxString mmkrs = pSrcPhrase->m_markers;
						}
					}
#endif
				}
				else
				{
					// we don't ever expect such an error, so an English message will do
					wxString msg;
					wxBell();
					msg = msg.Format(_T("Filtering the content for marker %s failed.\nDeep copies were not stored.\nSome source text data has been lost at sequNum %d.\nDo NOT save the document, exit, relaunch and try again."),
						wholeMkrBeingFiltered.c_str(), nStartLocation);
					wxMessageBox(msg, _T(""), wxICON_ERROR | wxOK);
					// put a message into the document so it is easy to track down where it
					// went wrong
					strFilteredStuff = _T("THIS IS WHERE THE FAILURE TO STORE DEEP COPIES OCCURRED. ");
				}

				// whm 24Oct2023 modification. When a filtered marker is adjacent to other non-filtered 
				// markers such as a chapter marker, for example, \c 11 the strFilteredStuff string that
				// was generated by the RebuildSourceText(strFilteredStuff...) call above, it will 
				// potentially contain one or more marker(s) and associated text that must not be included 
				// in the filteredStr assignment from strFilteredStuff below.
				// We need to purge the non-filtered material from the strFilteredStuff variable before 
				// assigning its content to filteredStr. So, for example, when the chapter marker 
				// \c 11 CRLF is adjacent to the \ms ... filtered part, the strFilteredStuff as returned 
				// from RebuildSourceText() might look like this:
				//	"\\c 11\r\n\\ms Jises akohok sisi-in ma iy imek, ano iy amak ja"
				// In this case we need to purge the "\\c 11\r\n" part from the string, leaving just the 
				// filtered material:
				//	\\ms Jises akohok sisi-in ma iy imek, ano iy amak ja
				// Note: wholeMkrBeingFiltered still holds the whole marker we are currently filtering out, 
				// so use it to find the index into strFilteredStuff of that marker
				// 
				// whm 8Feb2024 modification update. BEW and I decided that the filtered information should
				// retain the swept up markers like the "\\c 11\r\n" part mentioned above, instead of
				// purging it from the filtered information. We now leave it prefixed to the filtered info
				// and enclose the actual marker-being-filtered and its associated text within the filtered
				// bracket markers. The will allow us to later determine where the swept up markers should
				// be placed when rebuilding the source text.
				int posWholeMkr = (int)strFilteredStuff.Find(wholeMkrBeingFiltered);
				// First get the swept up stuff before the wholeMkrBeingFiltered since we'll keep it outside
				// the filter begin marker \~FILTER
				wxString sweptUpStr = wxEmptyString;
				if (posWholeMkr != wxNOT_FOUND)
				{
					// Separate any swept up preceding material from the strFilteredStuff that's going to 
					// be enclosed in the filter bracket markers.
					sweptUpStr = strFilteredStuff.Mid(0, posWholeMkr);
					strFilteredStuff = strFilteredStuff.Mid(posWholeMkr);
				}

				filteredStr += sweptUpStr; // sweptUpStr is empty when no swept up material is present
				filteredStr = filterMkr; // add the \~FILTER beginning marker - after any sweptUpStr
				filteredStr += _T(' '); // add space
				filteredStr += strFilteredStuff;

				// add the bracketing end filtermarker \~FILTER*
				filteredStr.Trim(); // don't need a final space before \~FILTER*
				filteredStr += filterMkrEnd; // adds \~FILTER*

				// delete the sublist's deep copied CSourcePhrase instances
				bool bDoPartnerPileDeletionAlso = FALSE; // there are no partner piles to delete
				DeleteSourcePhrases(pSublist, bDoPartnerPileDeletionAlso);
				pSublist->Clear(); // ready it for a later filtering out

				// Remove the pointers from the m_pSourcePhrases list (ie. those which were
				// filtered out), and delete their memory chunks; any adaptations on these are
				// lost forever, but not from the KB unless the latter is rebuilt from the
				// document contents at a later time.
				SPList::Node* pos_delNode; // use this to save the old location so as to delete the
									// old node once the iterator has moved past it
				int filterCount = 0;
				for (pos_partialList = posStart; (pos_delNode = pos_partialList) != posEnd; )
				{
					filterCount++;
					CSourcePhrase* pSP = (CSourcePhrase*)pos_partialList->GetData();
					pos_partialList = pos_partialList->GetNext();
					DeleteSingleSrcPhrase(pSP, TRUE); // don't leak memory, do also
						// delete their partner piles, as the latter should exist for
						// information unfiltered up to now and therefore was visible
						// in the view
					pList->DeleteNode(pos_delNode);
				}

				// update the sequence numbers on the sourcephrase instances which remain in
				// the document's list and reset nAfterLocation and nStartLocation accordingly
				UpdateSequNumbers(0);
				nAfterLocation = nStartLocation;
				nStartLocation = nStartLocation > 0 ? nStartLocation - 1 : 0;

				// we can now work out what adjustment is needed for the phrasebox
				// 1. if the active location was before the filter section, no adjustment is
				//     needed
				// 2. if it was after the filter section, the active sequence number must be
				//     decreased by the number of sourcephrase instances in the section being
				//     filtered out
				// 3. if it was within the filter section, it will not be possible to preserve
				//     its location in which case we must try find a safe location (a) as close
				//     as possible after the filtered section (when posEnd exists), or (b), as
				//     close as possible before the filtered section (when posEnd is NULL)
				if (!bBoxBefore)
				{
					if (bBoxAfter)
					{
						nCurActiveSequNum -= filterCount;
					}
					else
					{
						// the box was located within the span of the material which was
						// filtered out
						if (bPosEndNull)
						{
							// put the box before the filtered section (this may not be a valid
							// location, eg. it might be a retranslation section - but we'll
							// adjust later when we set the bundle indices)
							nCurActiveSequNum = nStartLocation;
						}
						else
						{
							// put it after the filtered section (this may not be a valid
							// location, eg. it might be a retranslation section - but we'll
							// adjust later )
							nCurActiveSequNum = nAfterLocation;
						}
					}
				}
				gpApp->m_nActiveSequNum = nCurActiveSequNum;

#if defined (_DEBUG) && !defined(NOLOGS)
				{
					if (pSrcPhrase != NULL && pSrcPhrase->m_nSequNumber >= 2)
					{
						int halt_here = 1;
						wxUnusedVar(halt_here);
						wxString mmkrs = pSrcPhrase->m_markers;
					}
				}
#endif

				// Construct m_inlineNonbindingMarkers on the first sourcephrase following 
				// the filtered section if there is nonbinding marker content needing to be
				// carried forward. A filtered section going as far as to the end of the 
				// document will manifest by pos_partialList being NULL on exit of the relevant loop 
				// above. That CSourcePhrase after the filtered span should be pointed to
				// by pPrevSrcPhrase (defined below) if we are not at doc end.
				// If we *are* at doc end, then preStr and remainderStr should be empty,
				// and we need do nothing with them.
				// BEW 30Sep19 changes
				// (1) define pPrevSrcPhrase
				// 
				// (2) filteredStr has to be appropriately stored, it no longer is embedded in
				// pPrevSrcPhrase's m_markers member, but at the START of its
				// m_filteredInfo member (to preserve the order of source text information
				// across filtering/unfiltering changes)
				// (3) the new storage for already filtered stuff being carried forward, the
				// string strFilteredStuffToCarryForward, has to be handled here too (it
				// could, of course, be an empty string)
				// 
				// whm 28May2024 modification/revision. Coding changes in the UsfmFilterPage.cpp
				// now ensure that the problem of a document starting with a to-be-filtered 
				// marker should no longer happen. Therefore, we should now expect that such
				// cases will always have an \id XXX line inserted that precedes any such
				// marker-being-filtered in the document. Hence, BEW's instance of a Scripture 
				// text that didn't have an \id XXX marker at the beginning of the file and 
				// that also started with a section heading (\s ...) will no longer be an issue
				// since the code within the UsfmFilterPage now detects such situations at the
				// time the user clicks on the checkbox to filter any marker that resides at
				// the very beginning of a document and won't allow filtering to take place
				// unless the user enters a book abbreviation code, which AI then places into
				// a new SP that gets inserted at the start of the document's m_pSourcePhrases
				// list.
				// Therefore, the afore-mentioned change in UsfmFilterPage now allows us to be 
				// able to expect that there will always be a non-null prevPos that we can use 
				// to store the filtered info of such a marker that was at the beginning of the
				// document.
				CSourcePhrase* pPrevSrcPhrase = NULL;
				if (prevPos != NULL)
				{
					pPrevSrcPhrase = prevPos->GetData();
					// In the next call GetPreviousNonPlaceholderSrcPhrase() it immediately 
					// returns NULL if pPrevSrcPhrase is NULL on entry
					pPrevSrcPhrase = GetPreviousNonPlaceholderSrcPhrase(pPrevSrcPhrase);
				}
				if (pPrevSrcPhrase == NULL)
				{
					// The pPrevSrcPhrase determined above is NULL which would indicate a
					// very unexpected programming problem, which we'll just record in the 
					// user log.
					wxString msg = _T("While filtering the %s marker the pPrevSrcPhrase was unexpectedly NULL.");
					msg = msg.Format(msg, wholeMkrBeingFiltered.c_str());
					gpApp->LogUserAction(msg);
				}
				// We are done with wholeMkrBeingFiltered for this filtering span, so clear it, likewise strFilteredStuff
				wholeMkrBeingFiltered = wxEmptyString;
				strFilteredStuff = wxEmptyString;

				// whm Note: The parallel section outside the if (bMarkerInNonbindingSet)
				// farther below has code to prepend markers into m_markers, but this is
				// not needed here within the if (bMarkerInNonbindingSet) block since such
				// markers don't store stuff within their m_markers member.

				// insert any already filtered stuff we needed to carry forward before the newly
				// filtered material (because if it was unfiltered, it would appear in the
				// view before pPrevSrcPhrase, and so we must retain that order)
				if (!strFilteredStuffToCarryForward.IsEmpty())
				{
					filteredStr = strFilteredStuffToCarryForward + filteredStr;
				}
				// we've carried the already filtered info forward, so make sure it goes no further
				strFilteredStuffToCarryForward.Empty();

				// whm 24Oct2023 added. Here would seem to be the proper place to carry forward 
				// (toward doc beginning) any existingFilteredInfo that was found during the 
				// processing of the current filtered marker, prefixing it now to the filteredStr 
				// before it gets stored in the appropriate source phrase.
				if (!existingFilteredInfo.IsEmpty())
				{
					// whm 24Oct2023 devised a smarter way to know where to put the newly filtered 
					// filterStr within the string that goes into the m_filteredInfo member. When there 
					// already exists one or more filtered markers within existingFilteredInfo, we now
					// have a more precise method of ordering multiple adjacent filtered markers - see 
					// the ReorderFilterMaterialUsingUsfmStructData() function call below and the
					// comments preceding it.
					filteredStr = filteredStr + existingFilteredInfo;
				}

				existingFilteredInfo.Empty();

				// Insert the newly filtered material (and any carried forward filtered info
				// which we inserted above) to the start of m_filteredInfo on the CSourcePhrase
				// which follows the filtered out section - that one might have filtered material
				// already, so we have to check and take the appropriate branch.
				wxString filteredStuff = pPrevSrcPhrase->GetFilteredInfo();

				// whm 15Nov2023 update to the previous strategy, which was not sufficiently robust 
				// for when multiple adjacent markers are filtered. Before storing the filteredStuff,
				// we need to ensure that we have the correct order of multiple instances of filtered 
				// info that may be within the filteredStuff string. This is important as it needs to
				// reflect what the original ordering of the filtered markers was in the original
				// document, otherwise when RebuildSourceText() is called to export the source text
				// the markers won't be in their correct ordering. 
				// 
				// We insert the filteredStr prefixing it on the filteredStuff string. However, the
				// order of markers can't be positivley determined as to where exactly the inserted 
				// material should go within filteredStuff. Therefore, we call the 
				// ReorderFilterMaterialUsingUsfmStructData() function which consults the 
				// Doc's m_UsfmStructArr array, and determine from it what the order of any adjacent
				// filtered markers should be, and if needed, reorders the incoming filteredStuff
				// string of markers to the order they existed within the original m_UsfmStructArr
				// array.
				// The ReorderFilterMaterialUsingUsfmStructData() guarantees that we preserve the 
				// relative ordering of the adjacent filtered markers in filteredStuff.
				// 
				// whm 26Mar2024 modified. Rather than prefixing the newly filtered material to the
				// existing material, I now think it generally results in a more natural order by
				// suffixing the newly filtered material to the existing material.
				//filteredStuff = filteredStr + filteredStuff; // inserted at start of string, but it may need reordering
				filteredStuff = filteredStuff + filteredStr; // insert at end of string; it still may need reordering
				// To avoid un-needed warnings, test filteredStuff to see if more than one filtered 
				// item is in filteredStuff. If it only has a single filtered item reordering isn't
				// necessary, and even if the .usfmstruct apparratus is not enabled, we need not
				// warn the user about it.
				if (FilteredMaterialContainsMoreThanOneItem(filteredStuff))
				{
					if (m_bUsfmStructEnabled)
					{
						wxString ChVs = pView->GetChapterAndVerse(pPrevSrcPhrase);
						filteredStuff = ReorderFilterMaterialUsingUsfmStructData(filteredStuff, ChVs, m_UsfmStructArr);
					}
					else
					{
						// Give a warning message to the user
						wxString msg = _("Adapt It could not set up the Usfm Struct Array or the .usfmstruct file.\n\nThis may affect the ability of Adapt It to filter or unfilter adjacent markers in correct sequence.");
						wxMessageBox(msg, _T(""), wxICON_WARNING | wxOK);
						gpApp->LogUserAction(msg);

					}
				}
				// Store it back on the pPrevSrcPhrase CSourcePhrase.
				pPrevSrcPhrase->SetFilteredInfo(filteredStuff);

				// These should be empty already, but make sure
				preStr.Empty();
				remainderStr.Empty();

				// Turn off the boolean for dealting with filtering nonbinding begin mkr
				bMarkerInNonbindingSet = FALSE;

				// get the navigation text set up correctly
				// 
				// whm 31Oct2023 removed the following call to RedoNavigationText(pPrevSrcPhrase).
				// The reason for removal is that some markers like \fig will
				// not have any content in their pSP's m_markers member. The
				// RedoNavigationText() function was apparently created when filtered info
				// was stored in m_markers. It is not helpful anymore since it immediately 
				// returns an empty string when m_markers is empty which then, wipes out the
				// already correct m_inform value of markers like \fig. 
				// Here we are within the TRUE block of if (bMarkerInNonbindingSet) so
				// we can assume that pPrevSrcPhrase now has filtered info within its
				// m_filteredInfo member, and it will be marked by a green caret above this
				// pPrevSrcPhrase. Also its m_inform will still be intact and should display
				// accordingly.
				//pPrevSrcPhrase->m_inform = RedoNavigationText(pPrevSrcPhrase);

				// enable iteration from this location
				if (posEnd == NULL)
				{
					pos_pList = NULL;
				}
				else
				{
#if defined (_DEBUG)
					CSourcePhrase* posEndSP = posEnd->GetData();
					wxUnusedVar(posEndSP);
#endif
					pos_pList = posEnd; // this could be the start of a consecutive section
									// for filtering out
				}
				// update progress bar every 200 iterations (1000 is a bit too many)

				++nOldCount;
				if (nOldCount % 200 == 0) //if (20 * (nOldCount / 20) == nOldCount)
				{
					msgDisplayed = progMsg.Format(progMsg, nOldCount, nOldTotal);
					pStatusBar->UpdateProgress(_("Processing Filtering Change(s)"), nOldCount, msgDisplayed);
				}

			} // end of TRUE block for test: if (bMarkerInNonbindingSet)
			else
			{
				// whm 29Mar2024 TODO: Merge this "Legacy code" block with the (bMarkerInNonbindingSet)
				// code above. We really only need one filtering block since both blocks are almost
				// identical, and have become more identical with refactoring of the filtering routines.
				// 
				// Legacy code...
				
				// whm 24Oct2023 Note: This else block is for all filterable markers except for
				// the \fig \+fig \jmp and \+jmp markers which get treated in the 
				// if (bMarkerInNonbindingSet) block above.

				// if we get here, it's a marker NOT in the inline nonbinding set:
				//		_T("\\wj \\sls \\tl \\+wj \\+qt \\+sls \\+tl \\fig \\+fig \\jmp \\+jmp ")
				// which is to be filtered out, and we know its offset - so set up preStr and 
				// remainderStr so we can commence the filtering properly...

				// Question: What if we filter a section containing within it filtered
				// information? 
				// Legacy Answer: This is not possible, except if there is filtered
				// information stored on the CSourcePhrase which has the wholeMkrBeingFiltered in its
				// m_markers member -- in that case and that case alone, the to-be-filtered
				// section CAN contain filtered material which is to remain filtered -- if so,
				// we must carry that already filtered information forward along with the
				// to-be-filtered material eventually placed after it (to preserve the correct
				// order of the information should all be unfiltered).
				// SFM and USFM markup does not permit marker nesting, except for \f and \x,
				// and we've a TextType and special code to handle such information as wholes,
				// and so there will never be nesting of filtered information within the Adapt
				// It document; but the CSourcePhrase instance with the filterable marker is
				// the exception -- because if filtered markers all happened to stack at the
				// one CSourcePhrase, then unfiltering and refiltering must restore that
				// stacking in m_filteredInfo and do it in the correct order. So we have to
				// check now for this special case, and any m_filteredInfo content there has to
				// be carried forward....
				// BEW Answer later (30Sep19): later versions of USFM2 and USFM3 are more
				// complex. Some inline non-binding markers are filterable; and are not
				// stored in m_markers. Recent CSourcePhrase definitions have extra storage
				// to be considered - m_inlineNonbindingMarkers and m_inlineNonbindingEndMarkers.
				// However the algorithm of taking forward prestring and poststring not-to-be
				// filtered markers, below, should be sound in principal - but require changes
				// to cope with looking into two storage locations per pSrcPhrase - m_markers
				// (as before) and now also m_inlineNonbindingMarkers as well.

				// BEW 21Sep10 -- read the next two paragraphs carefully, because for
				// docVersion 5 the protocols described in them need changing slightly - the
				// variations will be explained after these two paragraphs...
				//
				// Legacy comments (when filtered info was all stored in m_markers):
				// We have to be careful here, we can't assume that .Mid(filterableMkrOffset)
				// will deliver the correct remainderStr to be stored till later on, because a
				// filterable marker like \b could be followed by an unfiltered marker like \v,
				// or something filtered (and hence \~FILTER would follow), or even a different
				// filterable marker (like \x), and so we have to check here for the presence
				// of another marker which follows it - if there is one, we have found a marker
				// which is to be filtered, but which has no content - such as \b, and in that
				// case all we need do is bracket it with \~FILTER and \~FILTER* and then retry
				// the ContainsMarkerToBeFiltered() call above.
				//
				// Note: markers like \b which have no content must always be
				// userCanSetFilter="0" because they must always be filtered, or always be
				// unfiltered, but never be able to have their filtering status changed. This
				// is because our code for filtering out when a marker has been changed always
				// assumes there is some following content to the marker, but in the case of \b
				// or similar contentless markers this would not be the case, and our code
				// would then incorrectly filter out whatever follows (it could be inspired
				// text!) until the next marker is encountered. At present, we have specified
				// that \b is always to be filtered, so the code below will turn \b as an
				// unknown and unfiltered marker when PngOnly is the SFM set, to \~FILTER \b
				// \~FILTER* when the user changes to the UsfmOnly set, or the UsfmAndPng set.
				// Similarly for other contentless markers.
				//
				// Variations for docVersion 5: \~FILTER and \~FILTER* no longer will appear
				// in the CSourcePhrase m_markers member; \b and similar markers can still
				// appear there, and the protocols for this and other contentless filterable
				// markers are unchanged. If we encounter such a marker, we do not bracket it
				// with \~FILTER and \~FILTER* in the m_markers member, but rather move it to
				// the end of the m_filteredInfo member and provide \~FILTER and \~FILTER*
				// bracketing markers for it there instead.
				int wholeMkrLen = wholeMkrBeingFiltered.Length();
				int nOffsetToNextBit = filterableMkrOffset + wholeMkrLen;
				// whm 16Sep2022 moved the assignment of nFound before the if test in order to
				// utilize the value of nFound in the else/else if part which determines what
				// to do when a marker like \fv follows \f within the m_markers member.
				nFound = FindFromPos(markersStr, backslash, nOffsetToNextBit);
				//if ((wholeMkrBeingFiltered != _T("\\f")) && (wholeMkrBeingFiltered != _T("\\x")) &&
				//	(nFound = FindFromPos(markersStr, backslash, nOffsetToNextBit)) != wxNOT_FOUND)
				if ((wholeMkrBeingFiltered != _T("\\f")) && (wholeMkrBeingFiltered != _T("\\x")) &&
					(nFound != wxNOT_FOUND))
				{
					// there is a following SF marker which is not a \f or \x (the latter two
					// can have a following marker within their scope, so whether that happens
					// or not, they are not to be considered as contentless), so the current
					// one cannot have any text content -- this follows from the fact that the
					// text content of a marker cannot appear in m_markers (because in
					// docVersion 5 filtered markers are now not stored in m_markers, but in
					// m_filteredInfo), so if we find another marker using the FindFromPos()
					// call then we know the one found at the ContainsMarkerToBeFiltered() call
					// is a contentless marker.
					// Also, docVersion 5's storage in the CSourcePhrase implies that if a
					// marker which has content visible in the interlinear main window display
					// is encountered in m_markers, then it will be the last marker in
					// m_markers - this fact makes further assumptions below, safe to make
//					wxLogDebug(_T("%s::%s() , line  %d  wholeMarker =  %s"), __FILE__, __FUNCTION__, __LINE__, wholeMkrBeingFiltered.c_str());

					// extract the marker (marker only, no following space included)
					wxString contentlessMkr = markersStr.Mid(filterableMkrOffset, nOffsetToNextBit - filterableMkrOffset);
					// wx version note: Since we require a read-only buffer we use GetData
					// which just returns a const wxChar* to the data in the string.
					const wxChar* ptr = contentlessMkr.GetData();
#if defined (_DEBUG) && !defined(NOLOGS)
					{
						if (pSrcPhrase != NULL && pSrcPhrase->m_nSequNumber >= 2)
						{
							int halt_here = 1;
							wxUnusedVar(halt_here);
							wxString mmkrs = pSrcPhrase->m_markers;
						}
					}
#endif

					// whm added ensure buffer ends with null char
					wxChar* pEnd;
					pEnd = (wxChar*)ptr + wholeMkrLen;
					wxASSERT(*pEnd == _T('\0'));
					pEnd = pEnd; // avoid warning
					wxString temp;
					temp = GetFilteredItemBracketed(ptr, wholeMkrLen); // temp lacks a final space
					temp += _T(' '); // add the required trailing space

					// BEW 21Sep10, new code needed here for docVersion 5 - we have to remove
					// the contentless marker from the m_markers string (and chuck it away), and put the
					// bracketed version of it, stored in temp, into the end of m_filteredInfo
					markersStr.Remove(filterableMkrOffset, nOffsetToNextBit - filterableMkrOffset);
					// for an unknown reason it does not delete the space, so I have to test and
					// if so, delete it
					// whm modified 7Jul12 to include array access out-of-range tests
					if (!markersStr.IsEmpty() && markersStr.Len() > (size_t)filterableMkrOffset && markersStr[filterableMkrOffset] == _T(' ')) //if (markersStr[filterableMkrOffset] == _T(' '))
					{
						// wxString::Remove needs 1 as second parameter otherwise it truncates
						// remainder of string
						markersStr.Remove(filterableMkrOffset, 1); // delete extra space
																	// if one is here
					}
					// now update the m_filteredInfo member to contain this marker
					// appropriately filtered
					wxString filteredStr = pSrcPhrase->GetFilteredInfo();
					filteredStr += temp;
					pSrcPhrase->SetFilteredInfo(filteredStr);
					// update the local string populated above, since we've added to m_filteredInfo
					strFilteredStuffToCarryForward = pSrcPhrase->GetFilteredInfo();
					// update the m_markers member with the shorter markersStr contents
					pSrcPhrase->m_markers = markersStr;
#if defined (_DEBUG) && !defined(NOLOGS)
					{
						if (pSrcPhrase != NULL && pSrcPhrase->m_nSequNumber >= 2)
						{
							int halt_here = 1;
							wxUnusedVar(halt_here);
							wxString mmkrs = pSrcPhrase->m_markers;
						}
					}
#endif

					// get the navigation text set up correctly (the contentless marker just
					// now filtered out should then no longer appear in the nav text line)
					pSrcPhrase->m_inform = RedoNavigationText(pSrcPhrase);

					// advance beyond this just-filtered contentless marker's location and try
					// again
					// BEW 21Sep10, for docVersion 5 the calculation is different (simpler)
					nStartingOffset = nFound; // point at the next marker found at
												// the above FindFromPos() call
					// The g jump label is at start of the 
					// if (pSrcPhrase != NULL && !pSrcPhrase->m_markers.IsEmpty() && !bMarkerInNonbindingSet) block about a 1,000 lines above
					goto g; 
				} // end of TRUE block for test:
				// if ((wholeMkrBeingFiltered != _T("\\f")) && (wholeMkrBeingFiltered != _T("\\x")) &&
				//	(nFound = FindFromPos(markersStr, backslash, nOffsetToNextBit)) != wxNOT_FOUND)
				// 
				// whm 16Sep2022 added an else if test for when a marker like \fv immediately follows \f
				// wihtin m_markers
				else if (nFound != wxNOT_FOUND
					&& (markersStr.Mid(nFound, 2) == _T("\\f") || markersStr.Mid(nFound, 2) == _T("\\x")))
				{
					// Either \f or \x is the current wholMkr being examined, and
					// there is a marker directly following \f or \x which is of the form \f? or \x?,
					// where \f? might be one of the 2 or 3 letter footnote markers \\fq \\fl \\ft \\fdc 
					// \\fe \\fv \\fp \\fqa \\fr \\fk \\fm, (other than 1-letter \f itself),
					// or \x? might be one of the cross reference markers ... other than \x itself.
					// Hence, there is a following SF marker that is NOT \f nor \x, but is a related marker 
					// that begins with "\f..." or "\x...".
					// A prine example of when this "else if" block is entered is when the current wholeMrk
					// if \f and it is followed immediately by a \fv "Footnote - Embedded Verse Number" which
					// has \fv* as an end marker but the end marker is optional (its embedded text ends at the
					// next embedded marker or the footnote end marker \f*), and often the end marker is
					// not used in real text. 
					// An example would be \f \fv 4:1 ...(other embedded footnote markers and text)... \f*.
					// In the above example "4:1" is the content that follows the \fv marker, and that content
					// is filterable along with the rest of the footnote.
					// [TODO]
					//
					int HaltHere = 1;
					HaltHere = HaltHere;
#if defined (_DEBUG) && !defined(NOLOGS)
					{
						if (pSrcPhrase != NULL && pSrcPhrase->m_nSequNumber >= 2)
						{
							int halt_here = 1;
							wxUnusedVar(halt_here);
							wxString mmkrs = pSrcPhrase->m_markers;
						}
					}
#endif
				}
				else
				{
					// there is no following SF marker, so the current one may be assumed to
					// have content currently visible in the interlinear display
					;
				}

#if defined(_DEBUG)
				if (pSrcPhrase->m_nSequNumber == 2)
				{
					int break_here = 0; wxUnusedVar(break_here);
				}
#endif

				preStr = markersStr.Left(filterableMkrOffset); // this stuff we
					// accumulate for later on -- it will later go to the CSourcePhrase
					// which follows the instances about to be filtered out; in
					// docVersion 5 I can't think of anything that might be in preStr
					// and so it is likely to always be empty, but just in case it
					// isn't, we must preserve whatever is there & transfer it
				remainderStr = markersStr.Mid(filterableMkrOffset + wholeMkrLen); // this stuff is whatever
					// stuff follows the one we are about to filter, -- there may
					// be other following markers - such as \p or \v etc which need
					// to be accumulated and forwarded to the CSourcePhrase which
					// follows the instance about to be filtered out (in docVersion
					// 5, remainderStr won't ever have any filtered content data,
					// but only markers and possibly a verse or chapter number)
					// We retain anything which remains following our found marker
					//remainderStr = remainderStr.Mid(wholeMkrLen); // wholeMkrLen is the length of wholeMkrBeingFiltered
				remainderStr.Trim(FALSE); // trim off any initial spaces, or if only spaces
											// remain, then this will empty remainderStr
											// 
				// BEW 29Aug22 a reminder, wholeMarker was set earlier at lines 9162++ by this call:
				//filterableMkrOffset = ContainsMarkerToBeFiltered(gpApp->gCurrentSfmSet,
				//	markersStr, strMarkersToBeFiltered, wholeMkrBeingFiltered, wholeShortMkr, endMkr,
				//	bHasEndmarker, bIsUnknownMkr, nStartingOffset); and further down from here
				// m_markers is set to the shorter remainder string, after the current wholeMarker
				// has been dealt with - somewhere near 9760+ or -

#if defined (_DEBUG) && !defined(NOLOGS)
				{
					if (pSrcPhrase != NULL && pSrcPhrase->m_nSequNumber >= 2)
					{
						int halt_here = 1;
						wxUnusedVar(halt_here);
						wxString mmkrs = pSrcPhrase->m_markers;
					}
				}
#endif

				//wxLogDebug(_T("%s::%s() , line  %d  wholeMarker =  %s"), __FILE__, __FUNCTION__, __LINE__, wholeMkrBeingFiltered.c_str());
				// okay, we've found a marker to be filtered, we now have to look ahead to find
				// which sourcephrase instance is the last one in this filtering sequence - we
				// will assume the following:
				// BEW 21Sep10: the following protocols are valid also for docVersion 5
				// 1. unknown markers never have an associated endmarker - so their extent ends
				//      when a subsequent marker is encounted which is not an inline one, and
				//      is found in m_markers - the owning CSourcePhrase instance is NOT in
				//      the filterable span
				// 2. if the marker has an endmarker, then any other markers are skipped over -
				//      we just look for the matching endmarker as the last marker in m_endMarkers
				//      member - that owning CSourcePhrase instance would then be the last in the
				//      span 
				//		BEW 30Sep19 The complexity of what precedes argues for handling filterable
				//		content in m_inlineNonbindingMarkers in its own (large) processing block,
				//		because lots of the above apparatus won't apply in that situation.
				// 3. filterable markers which lack an endmarker will end their content when the
				//      next marker is encountered in a subsequent CSourcePhrase instance
				//      whose m_markers member contains that marker - which must not be an
				//      inline one (easily satisfied, since docV5 NEVER stores inline markers
				//      in m_markers, with the exception of \f, \fe or \x)
				//		BEW 30Sep19 This point continues to be valid I think, for USFM3
				// 4. markers which have an optional endmarker will end using criterion 3. above,
				//      unless the marker at that location has its first two characters
				//      identical to wholeShortMkr - in which case the section will end when
				//      the first marker is encountered for which that is not so (this allows
				//		skipping over markers internal to \f .... \f*, and/or \x .... \x*)

				// we can now partly or fully determine where the active location is in
				// relation to this location
				if (nCurActiveSequNum < pSrcPhrase->m_nSequNumber)
				{
					// if control comes here, the location is determinate
					bBoxBefore = TRUE;
					bBoxAfter = FALSE;
				}
				else
				{
					// if control comes here, the location is indeterminate - it might yet be
					// within the filtering section, or after it - we'll assume the latter, and
					// change it later if it is wrong when we get to the first sourcephrase
					// instance following the section for filtering
					bBoxBefore = FALSE;
					bBoxAfter = TRUE;
				}
				nStartLocation = pSrcPhrase->m_nSequNumber;
				// NOTE: we'll deal with preStr when we set up pPrevSrcPhrase's
				// m_markers member later on; likewise for anything still in remainderStr

				// whm 24Oct2023 added a wxString existingFilteredInfo to deal with any 
				// existing filtered info found within the marker's associated text being 
				// currently processed. This existingFilteredInfo will consist of one or
				// more filter string(s) already delimited by \~FILTER ... \~FILTER* markers. 
				// Later below, if existingFilteredInfo is NOT empty, its contents will be 
				// prefixed to the filteredStr variable below after it has been completely 
				// processed, then the entire filtered information (existing and current)
				// will be set to the proper source phrase preceding the location where
				// this current pSrcPhrase's deep copy will be placed.
				existingFilteredInfo.Empty();

				posStart = oldPos; // preserve this starting location for later on
//				wxLogDebug(_T("%s::%s() , line  %d  STARTING THE FILTERED SPAN wholeMarker =  %s , at nStartLocation sn = %d"),
//					__FILE__, __FUNCTION__, __LINE__, wholeMkrBeingFiltered.c_str(), nStartLocation);
				// we can commence to build filteredStr now (Note: because filtering stores a
				// string, rather than a sequence of CSourcePhrase instances, any adaptations
				// will be thrown away irrecoverably.
				// whm 8Feb2024 delay adding filterMkr and _T(' ') until later.
				//filteredStr = filterMkr; // add the \~FILTER beginning marker
				//filteredStr += _T(' '); // add space
				// whm 28Mar2024 modification. Adding the first source phrase of being filtered
				// text here outside the for loop (below) complicates things needlessly; And,
				// it might miss situations where the marker being filtered has just a single word
				// of text which, if the first SP is created here outside the for loop, the
				// IsEndingSrcPhrase(..., pSrcPhraseNext,...) function call may miss single-word 
				// situations where the next SP would qualify as an "ending src phrase". Therefore,
				// I'm removing the creation of a new source phrase here before the for loop, and 
				// having the for loop below start with the first SP creation of text associated 
				// with the marker-being-filtered.
				// These changes need also be done in an earlier part of ReconstituteAfterFilteringChange()
				// within the bMarkerInNonbindingSet TRUE block.
				//CSourcePhrase* pSrcPhraseFirst = new CSourcePhrase(*pSrcPhrase);
				//pSrcPhraseFirst->DeepCopy();
				//pSublist->Append(pSrcPhraseFirst); // we've already got the first to go in
												// the sublist, so put it there and then loop
												// to get the rest
				// Enter an inner loop which has as it's sole purpose finding which
				// CSourcePhrase instance at pos_pList or beyond is the last one for filtering out
				// as part of the current filterable span. In the loop we make deep copies in
				// order to create a sublist of accepted within-the-span CSourcePhrase
				// instances; we then use UpdateSequNumbers() to renumber from 0 those
				// instances in the sublist, and then after the loop ends we process all the
				// sublist's contents in one hit by using the ExportFunctions.cpp function,
				// RebuildSourceText(), passing in a pointer to the sublist. Doing it this way
				// means that we have one place only for reconstituting the source text,
				// giving us consistency, and we get the inline markers handling done 'for
				// free' rather than having to add it to the complex code this approach replaces.
				//
				// BEW 7Dec10:
				// Question: What if we filter a section where there is a note, or free
				// translation or a collected backtranslation?
				// Answer: note information is irreversibly lost. Free and / or collected back
				// translation information halts parsing, so we retain those. (Legacy code
				// didn't retain those though.)
				SPList::Node* pos_partialList; // this is the 'next' location
				CSourcePhrase* pSrcPhr; // we look for a section-ending matching endmarker
										// in this one, if we don't find one, we try the
										// m_markers member of pSrcPhraseNext instead; if
										// we find a matching endmarker, pSrcPhrase would be
										// WITHIN and at the end of the filterable section
				CSourcePhrase* pSrcPhraseNext; // this could have in its m_markers member
												// a non-inline marker which ends the section
												// that is, this one would NOT be part of the
												// filterable section
				// put our deep copies of the span's CSourcePhrase instances in pSublist (see
				// above, it's on the heap)
				//wxLogDebug(_T("%s::%s() , line  %d  wholeMarker =  %s"), __FILE__, __FUNCTION__, __LINE__, wholeMkrBeingFiltered.c_str());
				// Initialize pSrcPhr, to avoid a compiler warning after the loop
				// whm 28Mar2024 correction. The pos_pList already advanced past the position 
				// of the begin marker. It is possible, that there is only one source phrase
				// in the sublist. In such cases the END MARKER may be on the same source phrase. 
				// Therefore, we should always start our search for end marker back at the 
				// previous source phrase where the begin marker was located, and so we set 
				// pos_pList back to that position. This same thing need to be done for both
				// here and in the bMarkerInNonbindingSet TRUE block of 
				// ReconstituteAfterFilteringChange().
				pos_pList = pos_pList->GetPrevious();
				pSrcPhr = (CSourcePhrase*)pos_pList->GetData(); // redundant, avoids the warning later
#if defined (_DEBUG) && !defined(NOLOGS)
				{
					if (pSrcPhrase != NULL && pSrcPhrase->m_nSequNumber >= 2)
					{
						int halt_here = 1;
						wxUnusedVar(halt_here);
						wxString mmkrs = pSrcPhrase->m_markers;
					}
				}
#endif

				for (pos_partialList = pos_pList; pos_partialList != NULL; )
				{
					pSrcPhr = (CSourcePhrase*)pos_partialList->GetData();

					pos_partialList = pos_partialList->GetNext(); // advance to next Node of the passed in pList
					wxASSERT(pSrcPhr);
					posEnd = pos_partialList; // on exit of the loop, posEnd will be where
									// pSrcPhraseNext is located, or NULL if we reached
									// the end of the document
					if (pos_partialList == NULL)
					{
						// BEW 20Sep19 deprecated comment
						// we've come to the doc end, and that forces the span end too with
						// pSrcPhrase as the last one (and so we'll need an ophan created
						// later in order to "carry" the filtered information)
						// End deprecated comment.

						// BEW 30Sep19 the above comment is now wrong; since we now store
						// to the preceding CSourcePhrase, coming to the end of the doc
						// does not require creation of a dummy CSourcePhrase to carry the
						// filtered info
						pSrcPhraseNext = NULL;
					}
					else
					{
						pSrcPhraseNext = (CSourcePhrase*)pos_partialList->GetData();
					}

					// Check for a loop halt to scanning caused by finding the required
					// matching endmarker for the contents of wholeMkrBeingFiltered. If no match is found
					// (as would be the case if wholeMkrBeingFiltered is not an SFM which has a pairing
					// endmarker defined), then the pSrcPhraseNext instance needs to be
					// checked - for a halt-causing begin-marker etc. If any of the criteria
					// for halting the loop is not satisfied, the spanning loop continues.
					// A deep copy of the CSourcePhrase instance would then be made, and
					// accumulated to the sublist, and the loop iterate one or more times
					// until a halt is achieved - then control breaks from the loop and the
					// last pSrcPhrase (deep copy is made) is added to the sublist which
					// constitutes the filtering span of instances.
					if (HasMatchingEndMarker(wholeMkrBeingFiltered, pSrcPhr)) // 3rd param is 
						// bSearchInNonbindingMkrs, which is default FALSE for
						// doing the search in m_markers content
					{
//						wxLogDebug(_T("%s::%s() , line  %d  wholeMarker =  %s"), __FILE__, __FUNCTION__, __LINE__, wholeMkrBeingFiltered.c_str());
						// halt here, this pSrcPhr is last in the filterable span
						break;
					}
					else if (pSrcPhraseNext != NULL)
					{
						if (IsEndingSrcPhrase(gpApp->gCurrentSfmSet, pSrcPhraseNext, existingFilteredInfo)) // whm 24Oct2023 added 3rd parameter
						{
							// this 'next' CSourcePhrase instance causes a halt, and is not
							// itself to be within the filterable span, so the present
							// pSrcPhr instance is last in the span
							//bAtEnd = TRUE;  // and bAtDocEnd remains FALSE
							break;
						}
						// a FALSE value in the above test means that scanning should
						// continue, so just fall through to the code below which makes and
						// appends to the sublist the required deep copy of pSrcPhr
					}
					else // pSrcPhraseNext does not exist (the pointer is NULL)
					{
						// so pSrcPhr is the last CSourcePhrase instance in the document
						break;
					}
					// if control has not broken out of the loop, then we must continue
					// scanning over more CSourcePhrase instances till we halt; but first we
					// must create the needed deep copy and append it to the sublist
					CSourcePhrase* pSrcPhraseCopy = new CSourcePhrase(*pSrcPhr); // a shallow copy
					pSrcPhraseCopy->DeepCopy(); // now it's a deep copy of pSrcPhrase
					pSublist->Append(pSrcPhraseCopy);
				} // end of for loop: for (pos_partialList = pos_pList; pos_partialList != NULL; )
#if defined (_DEBUG) && !defined(NOLOGS)
				{
					if (pSrcPhrase != NULL && pSrcPhrase->m_nSequNumber >= 2)
					{
						int halt_here = 1;
						wxUnusedVar(halt_here);
						wxString mmkrs = pSrcPhrase->m_markers;
					}
				}
#endif

				// do the final needed deep copy of pSrcPhrase and append to the sublist
				CSourcePhrase* pSrcPhraseCopy = new CSourcePhrase(*pSrcPhr); // a shallow copy

				// whm 31Oct2023 added block below
				wxString tempFInfo = pSrcPhr->GetFilteredInfo();
				if (!tempFInfo.IsEmpty() && existingFilteredInfo.Find(tempFInfo) != wxNOT_FOUND)
				{
					// The existingFilteredInfo we retrieved is located in this final pSrcPhr, 
					// and we will be carrying that filtered info forward to a different source
					// phrase below, so we need to remove it from this pSrcPhr.
					pSrcPhr->SetFilteredInfo(wxEmptyString);
				}

				pSrcPhraseCopy->DeepCopy(); // now it's a deep copy of pSrcPhrase
				pSublist->Append(pSrcPhraseCopy);
				// get the sequence numbers in the stored instances consecutive from 0
				UpdateSequNumbers(0, pSublist);
				//wxLogDebug(_T("%s::%s() , line  %d  wholeMarker =  %s"), __FILE__, __FUNCTION__, __LINE__, wholeMkrBeingFiltered.c_str());

				// complete the determination of where the active location is in relation to
				// this filtered section, and work out the active sequ number adjustment needed
				// and make the adjustment
				if (bBoxBefore == FALSE)
				{
					// adjustment maybe needed only when we know the box was not located
					// preceding the filter section
					if (posEnd == NULL)
					{
						// at the document end, so everything up to the end is to be filtered;
						// so either the active location is before the filtered section (ie.
						// bBoxBefore == TRUE), or it is within the filtered section (it.
						// bBoxBefore == FALSE)
						bBoxAfter = FALSE;
					}
					else
					{
						// posEnd is defined, so get the sequence number for this location
						nAfterLocation = posEnd->GetData()->m_nSequNumber;

						// work out if an adjustment to bBoxAfter is needed (bBoxAfter is
						// set TRUE so far)
						if (nCurActiveSequNum < nAfterLocation)
							bBoxAfter = FALSE; // the box lay within this section
												// being filtered
					}
				}
				bool bPosEndNull = posEnd == NULL ? TRUE : FALSE; // used below to work out
												// where to set the final active location

				// here 'export' the src text into a wxString, and then append that to
				// filteredStr
				wxString strFilteredStuff;
				strFilteredStuff.Empty();
				if (!pSublist->IsEmpty())
				{
					// BEW addition 9Apr15 to fix a bug where two consecutive filterable spans such
					// as \f...\f*\x...\x* get filtered as \f...\f*\f...\f*\x...\x*. The reason is that
					// RebuildSourceText() call, in this block, rebuilds from pSublist; but earlier,
					// in the first filtering pass (which filtered \f...\f*) the filtered string got
					// stored in the CSourcePhrase which is the first in the second filterable span,
					// in the instance's m_filteredInfo member; and the second iteration then produced
					// the pSublist and the second iteration's call of RebuildSourceText then rebuilt
					// using the source text but prepended with the stored m_filteredInfo contents,
					// thereby doubling up the \f...\f* information. The fix is the following:
					// After strFilteredStuffToCarryForward (that is, forward into a new iteration of
					// the outer loop) is set, but before RebuildSourceText() is called,
					// we have to check (here) if the first pSrcPhrase in pSublist contains content in
					// its m_filteredInfo member - and if it does, we must here empty out that content.
					// We don't expect free translation, notes, collected back translations in pSublist,
					// but we can't rule out that there might be some, so we must clear that stuff too.
					// And we can't rule out a non-first pSrcPhrase in pSublist won't have filtered stuff.
					// So, to be safe, we here need to build only from the source text, markers and punctuation
					// in the instances in pSublist. To ensure that is so, we'll do a loop now to unlaterally
					// empty every member from which we don't want any content to contribute to the value of
					// strFilteredStuff that gets passed back from the rebuild call.
					// The reason why we have an earlier iteration stored in m_filteredInfo already is because
					// usually there is only one span to filter on any CSourcePhrase, and so the outer loop
					// terminates at the end of the first iteration, so we want m_filteredInfo set already if
					// that was the case.
					//wxLogDebug(_T("%s::%s() , line  %d  wholeMarker =  %s"), __FILE__, __FUNCTION__, __LINE__, wholeMkrBeingFiltered.c_str());
					SPList::Node* pos_subList;
					CSourcePhrase* pSrcPhr = NULL;
					if (!pSublist->IsEmpty())
					{
						pos_subList = pSublist->GetFirst();
						while (pos_subList != NULL)
						{
							pSrcPhr = pos_subList->GetData();
							pos_subList = pos_subList->GetNext();
							pSrcPhr->SetFilteredInfo(_T(""));
							pSrcPhr->SetCollectedBackTrans(_T(""));
							pSrcPhr->SetNote(_T(""));
							pSrcPhr->SetFreeTrans(_T(""));
						}
					}
					
					// whm 6Nov2023 added. Need to reset m_bCurrentlyFiltering to TRUE,
					// because more than one marker may be filtered, and the RebuildSourceText()
					// sets the m_bCurrentlyFiltering to FALSE near the end of its function.
					// If we don't reinitialize m_bCurrentlyFiltering to TRUE, then subsequent
					// calls of RebuildSourceText() for any second and following char attribute 
					// markers will fail to have their hidden metadata included within their
					// filtered material.
					m_bCurrentlyFiltering = TRUE;

					// end of addition done on 9Apr15
					int textLen = RebuildSourceText(strFilteredStuff, pSublist);
					wxUnusedVar(textLen); // to avoid a compiler warning

					// BEW 30Sep19 the above RebuildSourceText() will, embedded in it,
					// check for the existence of hidden USFM5 attributes metadata, and
					// unhide it. The returned textLen value will include the length of
					// that meta data in the returned strFilteredStuff
					//wxLogDebug(_T("%s::%s() , line  %d  wholeMarker =  %s"), __FILE__, __FUNCTION__, __LINE__, wholeMkrBeingFiltered.c_str());
					// remove any initial whitespace
					strFilteredStuff.Trim(FALSE);
				}
				else
				{
					// we don't ever expect such an error, so an English message will do
					wxString msg;
					wxBell();
					msg = msg.Format(_T("Filtering the content for marker %s failed.\nDeep copies were not stored.\nSome source text data has been lost at sequNum %d.\nDo NOT save the document, exit, relaunch and try again."),
						wholeMkrBeingFiltered.c_str(), nStartLocation);
					wxMessageBox(msg, _T(""), wxICON_ERROR | wxOK);
					// put a message into the document so it is easy to track down where it
					// went wrong
					strFilteredStuff = _T("THIS IS WHERE THE FAILURE TO STORE DEEP COPIES OCCURRED. ");
				}
				//wxLogDebug(_T("%s::%s() , line  %d  wholeMarker =  %s"), __FILE__, __FUNCTION__, __LINE__, wholeMkrBeingFiltered.c_str());

				// whm 24Oct2023 modification. When a filtered marker is adjacent to other non-filtered 
				// markers such as a chapter marker, for example, \c 11 the strFilteredStuff string here 
				// was generated by the RebuildSourceText(strFilteredStuff...) call above, and it will 
				// potentially contain a lot of marker(s) and associated text that must not be included 
				// in the filteredStr assignment from strFilteredStuff below.
				// We need to purge the non-filtered material from the strFilteredStuff variable before 
				// assigning its content to filteredStr. So, for example, when the chapter marker 
				// \c 11 CRLF is adjacent to the \ms ... filtered part, the strFilteredStuff as returned 
				// from RebuildSourceText() might look like this:
				//	"\\c 11\r\n\\ms Jises akohok sisi-in ma iy imek, ano iy amak ja"
				// In this case we need to purge the "\\c 11\r\n" part from the string, leaving just the 
				// filtered material:
				//	\\ms Jises akohok sisi-in ma iy imek, ano iy amak ja
				// Note: wholeMkrBeingFiltered still holds the whole marker we are currently filtering out, 
				// so use it to find the index into strFilteredStuff of that marker
				// 
				// whm 8Feb2024 modification update. BEW and I decided that the filtered information should
				// retain the swept up markers like the "\\c 11\r\n" part mentioned above, instead of
				// purging it from the filtered information. We now leave it prefixed to the filtered info
				// and enclose the actual marker-being-filtered and its associated text within the filtered
				// bracket markers. The will allow us to later determine where the swept up markers should
				// be placed when rebuilding the source text.
				int posWholeMkr = (int)strFilteredStuff.Find(wholeMkrBeingFiltered);
				// First get the swept up stuff before the wholeMkrBeingFiltered since we'll keep it outside the filter
				// begin marker \~FILTER
				wxString sweptUpStr = wxEmptyString;
				if (posWholeMkr != wxNOT_FOUND)
				{
					// Separate any swept up preceding material from the strFilteredStuff that's going to 
					// be enclosed in the filter bracket markers.
					sweptUpStr = strFilteredStuff.Mid(0, posWholeMkr);
					strFilteredStuff = strFilteredStuff.Mid(posWholeMkr);
				}

				filteredStr = sweptUpStr; // sweptUpStr is empty when no swept up material is present
				filteredStr += filterMkr; // add the \~FILTER beginning marker - after any sweptUpStr
				filteredStr += _T(' '); // add space
				filteredStr += strFilteredStuff;

				// add the bracketing end filtermarker \~FILTER*
				filteredStr.Trim(); // don't need a final space before \~FILTER*
				filteredStr += filterMkrEnd; // adds \~FILTER*

				// delete the sublist's deep copied CSourcePhrase instances
				bool bDoPartnerPileDeletionAlso = FALSE; // there are no partner piles to delete
				DeleteSourcePhrases(pSublist, bDoPartnerPileDeletionAlso);
				pSublist->Clear(); // ready it for a later filtering out

				// remove the pointers from the m_pSourcePhrases list (ie. those which were
				// filtered out), and delete their memory chunks; any adaptations on these are
				// lost forever, but not from the KB unless the latter is rebuilt from the
				// document contents at a later time
				SPList::Node* pos_delNode; // use this to save the old location so as to delete the
									// old node once the iterator has moved past it
				int filterCount = 0;
				for (pos_partialList = posStart; (pos_delNode = pos_partialList) != posEnd; )
				{
					filterCount++;
					CSourcePhrase* pSP = (CSourcePhrase*)pos_partialList->GetData();
					pos_partialList = pos_partialList->GetNext();
					DeleteSingleSrcPhrase(pSP, TRUE); // don't leak memory, do also delete their
								// partner piles, as the latter should exist for information
								// unfiltered up to now and therefore was visible in the view
					pList->DeleteNode(pos_delNode);
				}

				// update the sequence numbers on the sourcephrase instances which remain in
				// the document's list and reset nAfterLocation and nStartLocation accordingly
				UpdateSequNumbers(0);
				nAfterLocation = nStartLocation;
				nStartLocation = nStartLocation > 0 ? nStartLocation - 1 : 0;

				// we can now work out what adjustment is needed
				// 1. if the active location was before the filter section, no adjustment is
				//     needed
				// 2. if it was after the filter section, the active sequence number must be
				//     decreased by the number of sourcephrase instances in the section being
				//     filtered out
				// 3. if it was within the filter section, it will not be possible to preserve
				//     its location in which case we must try find a safe location (a) as close
				//     as possible after the filtered section (when posEnd exists), or (b), as
				//     close as possible before the filtered section (when posEnd is NULL)
				if (!bBoxBefore)
				{
					if (bBoxAfter)
					{
						nCurActiveSequNum -= filterCount;
					}
					else
					{
						// the box was located within the span of the material which was
						// filtered out
						if (bPosEndNull)
						{
							// put the box before the filtered section (this may not be a valid
							// location, eg. it might be a retranslation section - but we'll
							// adjust later when we set the bundle indices)
							nCurActiveSequNum = nStartLocation;
						}
						else
						{
							// put it after the filtered section (this may not be a valid
							// location, eg. it might be a retranslation section - but we'll
							// adjust later when we set the bundle indices)
							nCurActiveSequNum = nAfterLocation;
						}
					}
				}

				// Construct m_markers on the first sourcephrase following the filtered
				// section; if the filtered section is at the end of the document (shouldn't
				// happen, but who knows what a user will do?) then we will need to detect this
				// and create a CSourcePhrase instance with empty key in order to be able to
				// store the filtered content in its m_markers member, and add it to the tail
				// of the doc. A filtered section at the end of the document will manifest by
				// pos_partialList being NULL on exit of the above loop
				// BEW 22Sep10, changes for docVersion 5:
				// (1) preStr and remainderStr will need to be inserted at the start of the
				// pPrevSrcPhrase's m_markers member, if either or both are non-empty
				// (they'll almost certainly be both empty)
				// (2) filteredStr has to be appropriately stored, it no longer is embedded in
				// pPrevSrcPhrase's m_markers member, but at the START of its
				// m_filteredInfo member (to preserve the order of source text information
				// across filtering/unfiltering changes)
				// (3) the new storage for already filtered stuff being carried forward, the
				// string strFilteredStuffToCarryForward, has to be handled here too (it
				// could, of course, be an empty string)
				// 
				// whm 19Mar2024 added. Filtered material is now being stored on a previous SP.
				// Here we need to ensure that the pPrevSrcPhrase is not a placeholder source 
				// phrase, especially one that is at the end of a retranslation.
				// If it is a placeholder, we need to iterate to a previous source phrase
				// that is not a placeholder. This is also what is done within TokenizeText().
				// For unfiltering a filtered marker the process is reversed, so that filtered
				// material that was stored on a particular source phrase that is followed by 
				// one or more placeholders, unfiltering the tokenized sublist of source phrases
				// properly requires that we advance over any placeholder source phrases that
				// follow it until we came to a non-placeholder source phrase and there we can
				// insert the marker-being-unfiltered's sublist of tokenized source phrases 
				// there.
				// Note: There is a parallel block later below to iterate past placeholder 
				// source phrases in the block where bIsMarkerInNonbindingSet is FALSE.
				// 
				// whm 28May2024 modification/revision. Coding changes in the UsfmFilterPage.cpp
				// now ensure that the problem of a document starting with a to-be-filtered 
				// marker should no longer happen. Therefore, we should now expect that such
				// cases will always have an \id XXX line inserted that precedes any such
				// marker-being-filtered in the document. Hence, BEW's instance of a Scripture 
				// text that didn't have an \id XXX marker at the beginning of the file and 
				// that also started with a section heading (\s ...) will no longer be an issue
				// since the code within the UsfmFilterPage now detects such situations at the
				// time the user clicks on the checkbox to filter any marker that resides at
				// the very beginning of a document and won't allow filtering to take place
				// unless the user enters a book abbreviation code, which AI then places into
				// a new SP that gets inserted at the start of the document's m_pSourcePhrases
				// list.
				// Therefore, the afore-mentioned change in UsfmFilterPage now allows us to be 
				// able to expect that there will always be a non-null prevPos that we can use 
				// to store the filtered info of such a marker that was at the beginning of the
				// document.
				CSourcePhrase* pPrevSrcPhrase = NULL;
				if (prevPos != NULL)
				{
					pPrevSrcPhrase = prevPos->GetData();
					// In the next call GetPreviousNonPlaceholderSrcPhrase() it immediately 
					// returns NULL if pPrevSrcPhrase is NULL on entry
					pPrevSrcPhrase = GetPreviousNonPlaceholderSrcPhrase(pPrevSrcPhrase);
				}
				if (pPrevSrcPhrase == NULL)
				{
					// The pPrevSrcPhrase determined above is NULL which would indicate a
					// very unexpected programming problem, which we'll just record in the 
					// user log.
					wxString msg = _T("While filtering the %s marker the pPrevSrcPhrase was unexpectedly NULL.");
					msg = msg.Format(msg, wholeMkrBeingFiltered.c_str());
					gpApp->LogUserAction(msg);
				}
				// We are done with wholeMkrBeingFiltered for this filtering span, so clear it, likewise strFilteredStuff
				wholeMkrBeingFiltered = wxEmptyString;
				strFilteredStuff = wxEmptyString;


				// fill its m_markers with the material it needs to store,
				// in the correct order

				// whm 4Feb2024 NOTE. The storage of m_markers from preStr in the
				// pPrevSrcPhrase location can result in loss of ordering information,
				// that we will need when it comes to unfiltereing and rebuilding the source
				// text. For example, consider the following original source text lines:
				//		\ms Jesus brought Good News for all people
				//		\c 1
				//		\s1 The Preaching of John the Baptist
				//		\p
				//		\v 1 This is the Good News about \em Jesus Christ\em*, the Son of God.
				// And, suppose we then filter the \s1 marker and its text. 
				// m_markers content: 
				// pPrevSrcPhrase->m_markers is: 
				//	"\\c 1\r\n\\p\r\n\\v 1 ", and
				// pPrevSrcPhrase->m_filteredInfo is: 
				//	"\\~FILTER \\s1 The Preaching of John the Baptist\\~FILTER*"
				// When the \s1 marker was filtered we lost the ordering information, namely that
				// the \s1 marker and its associated text was ordered between the "\\c 1\r\n"
				// and \\p\r\n\\v1 parts of the original input text. To properly unfilter and/or
				// rebuild the source text, we need to regain that lost ordering information so 
				// that for proper:
				//    Unfiltering we put the "\\c 1\r\n" first part of m_markers on the 
				// the FIRST word of the \s1 associated text "The", but we need to put the 
				// second \\p\r\n\\v1 part on the first word of \v 1 "This"
				// 
				// whm 8Feb2024 update to above comment: BEW and I decided that it would be good
				// to actually leave the swept up material - the "\\c 1\r\n" part mentioned above,
				// WITHIN the m_filteredInfo member, but PREFIXED to the filtered marker that it
				// was associated with, i.e., the \s1 marker above. Hence upon filtering the s1 
				// marker and its associated text would be stored as:
				//   "\\c 1\r\n\\~FILTER \\s1 The Preaching of John the Baptist\\~FILTER*"
				// in which the \\c 1\r\n" part is stored OUTSIDE the filter brackets.

				// whm 8Feb2024 modified. Since we are now storing in m_filteredInfo the swept up 
				// markers prefixing them to the filter-bracketed marker-being-filtered, we do 
				// not want to store such swept up material in m_markers where it just looses all
				// ordering information. Therefore, we should remove the swept up stuff from the
				// preStr below before storing preStr into m_markers.
				// I'm commenting out the next line until tests show that we need to
				// just remove swept up stuff from preStr. When filtering the \s1 marker
				// preStr was "\\c 1\r\n" which was equivalent to the swept up part, but what
				// about when there is other bracketed filtered stuff within preStr???
				// Also when testing this by filtering \s1 in the Hezekiah doc, it was clear that
				// the RebuildSourceText() call above wasn't producing a correct string
				//pPrevSrcPhrase->m_markers = preStr; // any previously assumulated
														// filtered info, or markers


				// BEW 22Sep10 added next 3 lines
				// whm TODO: The next 4 assignments to pPrevSrcPhrase member are NOT present in
				// the almost identical bMarkerInNonbindingSet block above. Shoule it be there too?
				// or can it just be removed from this block as it appears that remainderStr is
				// always an empty string at this point???
				pPrevSrcPhrase->m_markers.Trim();
				pPrevSrcPhrase->m_markers += _T(" "); //ensure an intervening space
				pPrevSrcPhrase->m_markers += remainderStr;
				pPrevSrcPhrase->m_markers.Trim(FALSE); // delete contents if only spaces are present

				// insert any already filtered stuff we needed to carry forward before the newly
				// filtered material (because if it was unfiltered, it would appear in the
				// view before it, and so we must retain that order)
				if (!strFilteredStuffToCarryForward.IsEmpty())
				{
					//(in the legacy code, this bit of work was done by remainderStr, because
					//filtered info was all in m_markers; but for docVersion 5 that was
					//inappropriate -- so I retained remainderStr only for contentless markers stuff
					//which might come after the marker to be filtered out, and stored already
					//filtered stuff in strFilteredStuffToCarryForward)
					filteredStr = strFilteredStuffToCarryForward + filteredStr;

				}
				// we've carried the already filtered info forward, so make sure it goes no further
				strFilteredStuffToCarryForward.Empty();

				// whm 24Oct2023 added. Here would seem to be the proper place to carry forward 
				// any existingFilteredInfo that was found during the processing of the current
				// filtered marker, prefixing it now to the filteredStr before it gets stored
				// in the appropriate source phrase.
				if (!existingFilteredInfo.IsEmpty())
				{
					// whm 24Oct2023 devised a smarter way to know where to put the newly filtered 
					// filterStr within the string that goes into the m_filteredInfo member. When there 
					// already exists one or more filtered markers within existingFilteredInfo, we now
					// have a more precise method of ordering multiple adjacent filtered markers - see 
					// the ReorderFilterMaterialUsingUsfmStructData() function call below and the
					// comments preceding it.
					filteredStr = filteredStr + existingFilteredInfo;
				}

				existingFilteredInfo.Empty();

				// Insert the newly filtered material (and any carried forward filtered info
				// which we appended above) to the start of m_filteredInfo on the CSourcePhrase
				// which follows the filtered out section - that one might have filtered material
				// already, so we have to check and take the appropriate branch.
				wxString filteredStuff = pPrevSrcPhrase->GetFilteredInfo();

				// whm 15Nov2023 update to the previous strategy, which was not sufficiently robust 
				// for when multiple adjacent markers are filtered. Before storing the filteredStuff,
				// we need to ensure that we have the correct order of multiple instances of filtered 
				// info that may be within the filteredStuff string. This is important as it needs to
				// reflect what the original ordering of the filtered markers was in the original
				// document, otherwise when RebuildSourceText() is called to export the source text
				// the markers won't be in their correct ordering. 
				// 
				// We insert the filteredStr prefixing it on the filteredStuff string. However, the
				// order of markers can't be positivley determined as to where exactly the inserted 
				// material should go within filteredStuff. Therefore, we call the 
				// ReorderFilterMaterialUsingUsfmStructData() function which consults the 
				// Doc's m_UsfmStructArr array, and determine from it what the order of any adjacent
				// filtered markers should be, and if needed, reorders the incoming filteredStuff
				// string of markers to the order they existed within the original m_UsfmStructArr
				// array.
				// The ReorderFilterMaterialUsingUsfmStructData() guarantees that we preserve the 
				// relative ordering of the adjacent filtered markers in filteredStuff.
				// 
				// whm 26Mar2024 modified. Rather than prefixing the newly filtered material to the
				// existing material, I now think it generally results in a more natural order by
				// suffixing the newly filtered material to the existing material.
				//filteredStuff = filteredStr + filteredStuff; // inserted at start of string, but it may need reordering
				filteredStuff = filteredStuff + filteredStr; // insert at end of string; it still may need reordering
				// To avoid un-needed warnings, test filteredStuff to see if more than one filtered 
				// item is in filteredStuff. If it only has a single filtered item reordering isn't
				// necessary, and even if the .usfmstruct apparratus is not enabled, we need not
				// warn the user about it.
				if (FilteredMaterialContainsMoreThanOneItem(filteredStuff))
				{
					if (m_bUsfmStructEnabled)
					{
						wxString ChVs = pView->GetChapterAndVerse(pPrevSrcPhrase);
						filteredStuff = ReorderFilterMaterialUsingUsfmStructData(filteredStuff, ChVs, m_UsfmStructArr);
					}
					else
					{
						// Give a warning message to the user
						wxString msg = _("Adapt It could not set up the Usfm Struct Array or the .usfmstruct file.\n\nThis may affect the ability of Adapt It to filter or unfilter adjacent markers in correct sequence.");
						wxMessageBox(msg, _T(""), wxICON_WARNING | wxOK);
						gpApp->LogUserAction(msg);

					}
				}
				// Store it back on the pPrevSrcPhrase CSourcePhrase.
				pPrevSrcPhrase->SetFilteredInfo(filteredStuff);

				// These should be empty already, but make sure
				preStr.Empty();
				remainderStr.Empty();

				// get the navigation text set up correctly
				// whm 2Feb2024 Note: In the bMarkerInNonbindingSet section farther 
				// above the RedoNavigationText() call was commented out because for \fig
				// markers being filtered will not have any content in their PSP's
				// m_markers member, and the RedoNavigationText() function immediately
				// returns an empty string when m_markers is empty which then, wipes out the
				// already correct m_inform value of markers like \fig.
				// However, here it doesn't seem to have negative effects.
				pPrevSrcPhrase->m_inform = RedoNavigationText(pPrevSrcPhrase);

				// enable iteration from this location
				if (posEnd == NULL)
				{
					pos_pList = NULL;
				}
				else
				{
#if defined (_DEBUG)
					CSourcePhrase* posEndSP = posEnd->GetData();
					wxUnusedVar(posEndSP);
#endif
					pos_pList = posEnd; // this could be the start of a consecutive section
									// for filtering out
				}
				// update progress bar every 200 iterations (1000 is a bit too many)

				++nOldCount;
				if (nOldCount % 200 == 0) //if (20 * (nOldCount / 20) == nOldCount)
				{
					msgDisplayed = progMsg.Format(progMsg, nOldCount, nOldTotal);
					pStatusBar->UpdateProgress(_("Processing Filtering Change(s)"), nOldCount, msgDisplayed);
				}

			} // end of else block for test: if (bMarkerInNonbindingSet)

		} // end of while loop for scanning contents of successive pSrcPhrase instances
		  // the test being:  while (pos_pList != NULL)

		// prepare for update of view... locate the phrase box approximately where it was,
		// but if that is not a valid location then put it at the end of the doc
		int numElements = pList->GetCount();
		if (gpApp->m_nActiveSequNum > gpApp->GetMaxIndex())
			gpApp->m_nActiveSequNum = numElements - 1;

	} // end of TRUE block for test:  if (bFilteringRequired)

	// whm 23Aug2018 Change. Moved the pStatusBar->FinishProgress() call that is about
	// 10 lines above within the bIsFilteringRequired == TRUE block to this outer block.
	// where it will be parallel to the pStatusBar->StartProgress() call near the
	// beginning of ReconstituteAfterFilteringChange()
	// remove the progress indicator window
	pStatusBar->FinishProgress(_("Processing Filtering Change(s)"));


	// GetSavePhraseBoxLocationUsingList calculates a safe location (ie. not in a
	// retranslation), sets the app's m_nActiveSequNum member to that value, and
	// calculates and sets m_targetPhrase to agree with what will be the new phrase box
	// location; it doesn't move the location if it is already safe; in either case it
	// sets the box text to be the m_adaption contents for the current or new active
	// location after this call is made
	gpApp->GetSafePhraseBoxLocationUsingList(pView);

	// remove the progress window, clear out the sublist from memory
	// wx version note: Since the progress dialog is modeless we do not need to destroy
	// or otherwise end its modeless state; it will be destroyed when
	// ReconstituteAfterFilteringChange goes out of scope
	if (pSublist != NULL)
	{
		pSublist->Clear();
		delete pSublist;
		pSublist = NULL;
	}
	// BEW added 29Jul09, turn back on CLayout Draw() so drawing of the view
	// can now be done
	GetLayout()->m_bInhibitDraw = FALSE;
#if defined (_DEBUG) && !defined(NOLOGS)
	{
		if (pSrcPhrase != NULL && pSrcPhrase->m_nSequNumber >= 2)
		{
			int halt_here = 1;
			wxUnusedVar(halt_here);
			wxString mmkrs = pSrcPhrase->m_markers;
		}
	}
#endif

	return bSuccessful;
}

///////////////////////////////////////////////////////////////////////////////
/// \return		TRUE when we want the caller to copy the pPrevSrcPhrase->m_curTextType value to the
///				global enum, gPreviousTextType; otherwise we return FALSE to suppress that global
///				from being changed by whatever marker has just been parsed (and the caller will
///				reset the global to default TextType verse when an endmarker is encountered).
/// \param		pChar		-> points at the marker just found (ie. at its backslash)
/// \param		pAnalysis	-> points at the USFMAnalysis struct for this marker, if the marker
///								is not unknown otherwise it is NULL.
/// \remarks
/// Called from: the Doc's RetokenizeText().
/// TokenizeText() calls AnalyseMarker() to try to determine, among other things, what the TextType
/// propagation characteristics should be for any given marker which is not an endmarker; for some
/// such contexts, AnalyseMarker will want to preserve the TextType in the preceding context so it
/// can be restored when appropriate - so IsPreviousTextTypeWanted determines when this preservation
/// is appropriate so the caller can set the global which preserves the value
///////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItDoc::IsPreviousTextTypeWanted(wxChar* pChar, USFMAnalysis* pAnalysis)
{
	wxString bareMkr = GetBareMarkerForLookup(pChar);
	//wxASSERT(!bareMkr.IsEmpty());  // BEW 6Sep23 this asserted during my unittest for missing ch2 and ch7
	// so if bareMkr is empty, the only option is to return FALSE and let parsing continue
	if (bareMkr.IsEmpty())
	{
#if defined (_DEBUG)
		wxString pointsAt = wxString(pChar, 16);
		wxLogDebug(_T("IsPreviousTextTypeWanted() line %d, bareMkr empty at: pointsAt= [%s], returning FALSE"), __LINE__, pointsAt.c_str());
#endif
		return FALSE;
	}
	wxString markerWithoutBackslash = GetMarkerWithoutBackslash(pChar);

	// if we have a \f or \x marker, then we always want to get the TextType on whatever
	// is the sourcephrase preceding either or these
	if (markerWithoutBackslash == _T("f") || markerWithoutBackslash == _T("x"))
		return TRUE;
	// for other markers, we want the preceding sourcephrase's TextType whenever we
	// have encountered some other inLine == TRUE marker which has TextType of none
	// because these are the ones we'll want to propagate the previous type across
	// their text content - to check for these, we need to look inside pAnalysis
	if (pAnalysis == NULL)
	{
		return FALSE;
	}
	else
	{
		// its a known marker, so check if it's an inline one 
		// BEW 8Jun23 added to the test - as nested markers were unknown when this
		// function was first built; so added: || *(pChar + 1) == _T('+')
		// So i tests: either its none type, or there is a + character after the 
		// backslash (i.e. nested, and nested markers DO NOT change the textType
		// - the outer type applies, so propagate from pPrevSrcPhrase
		if (pAnalysis->inLine && (pAnalysis->textType == none || *(pChar + 1) == _T('+')) )
		{
			return TRUE;
		}
		else
		{
			return FALSE;
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \return
/// \param		filename	-> the filename to associate with the current document
/// \param		notifyViews	-> defaults to FALSE; if TRUE wxView's OnChangeFilename
///                            is called for all views
/// \remarks
/// Called from: the App's OnInit(), DoKBRestore(), DoTransformationsToGlosses(),
/// ChangeDocUnderlyingFileDetailsInPlace(), the Doc's OnNewDocument(), OnFileClose(),
/// DoFileSave(), SetDocumentWindowTitle(), DoUnpackDocument(), the View's
/// OnEditConsistencyCheck(), DoConsistencyCheck(), DoRetranslationReport(), the DocPage's
/// OnWizardFinish(), and CMainFrame's SyncScrollReceive().
/// Sets the file name associated internally with the current document.
///////////////////////////////////////////////////////////////////////////////
void CAdapt_ItDoc::SetFilename(const wxString& filename, bool notifyViews)
{
	m_documentFile = filename;
	if (notifyViews)
	{
		// Notify the views that the filename has changed
		wxNode* node = m_documentViews.GetFirst();
		while (node)
		{
			wxView* view = (wxView*)node->GetData();
			view->OnChangeFilename();
			// OnChangeFilename() is called when the filename has changed. The default
			// implementation constructs a suitable title and sets the title of
			// the view frame (if any).
			node = node->GetNext();
		}
	}
}


///////////////////////////////////////////////////////////////////////////////
/// \return		a pointer to the running application (CAdapt_ItApp*)
/// \remarks
/// Called from: Most routines in the Doc which need a pointer to refer to the App.
/// A convenience function.
///////////////////////////////////////////////////////////////////////////////
CAdapt_ItApp* CAdapt_ItDoc::GetApp()
{
	return (CAdapt_ItApp*)&wxGetApp();
}

///////////////////////////////////////////////////////////////////////////////
/// \return		TRUE if the character immediately before prt is a newline character (\n)
/// \param		ptr			-> a pointer to a character being examined/referenced
/// \param		pBufStart	-> the start of the buffer being examined
/// \remarks
/// Called from: ExportFunctions's IsMarkerRTF().
/// Determines if the previous character in the buffer is a newline character, providing ptr
/// is not pointing at the beginning of the buffer (pBufStart).
/// whm 16Aug2023 No longer used. IsPreCharANewline() was used only in ExportFunctions's 
/// IsMarkerRTF() but is now commented out.
///////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItDoc::IsPrevCharANewline(wxChar* ptr, wxChar* pBufStart)
{
	if (ptr <= pBufStart)
		return TRUE; // treat start of buffer as a virtual newline
	--ptr; // point at previous character
	if (*ptr == _T('\n'))
		return TRUE;
	else
		return FALSE;
}


// BEW 23Apr15 added provisional support for Dennis Walters request for / as a
// like-whitespace wordbreak; only in Unicode version
// 
// BEW 23Nov22 This function does not return TRUE for *pChar == _T('\n'), so when
// ParseWhiteSpace(wxChar* pChar) is called, it does not include the newline in the
// span - probably it should, so that at newlines in the input data parsing, we advance
// ptr over them. Probably safer for ParseWord(). I'll try the change and see if it
// produces problems.
// 
// whm 18Aug2023 modified. BEW's comment above about the function not returning TRUE for
// *pChar == _T('\n') is not correct at least now as of 18Aug2023. Testing shows that the
// wxWidgets wxIsspace() function does return TRUE for all common whitespace characters 
// including TAB '\t', LF '\n', CR '\r', and Space ' ', and does so on all platforms (at 
// least Windows and Linux).
// .  
// As of 18Aug2023, this IsWhiteSpace() function here in the doc now simply calls the 
// exact same global function that is defined in helpers.cpp. 
// ***** ALL CHANGES TO WHITE SPACE DETECTING SHOULD NOW BE MADE IN THE VERSION IN helpers.cpp *******
bool CAdapt_ItDoc::IsWhiteSpace(wxChar* pChar)
{
	// *******************************************************************************************************
	// ********* ALL CHANGES TO IsWhiteSpace() SHOULD BE MADE TO IsWhiteSpace() DEFINED IN helpers.cpp *******
	// ********* THIS FUNCTION HERE NOW JUST CALLS THE GLOBAL FUNCTION IsWhiteSpace() IN helpers.cpp   *******
	// ********* SEE THE return STATEMENT BELOW WHERE THE GLOBAL FUNCTION IN helpers.cpp IS CALLED     *******
	// *******************************************************************************************************
	/*	
	// BEW 30July11 -- the following block also needs to be added to the beginning of the
	// following similar functions in helpers.cpp: IsWhiteSpace() and
	// Is_NonEol_WhiteSpace() and has been
#ifdef _UNICODE
	wxChar NBSP = (wxChar)0x00A0; // standard Non-Breaking SPace
	wxChar HairSpace = (wxChar)0x200A; // used between curly quotes in MATBVM.SFM doc
#else
	wxChar NBSP = (unsigned char)0xA0;  // standard Non-Breaking SPace
#endif

	// handle common ones first...
	// returns true for tab 0x09, return 0x0D or space 0x20
	// _istspace not recognized by g++ under Linux; the wxIsspace() fn and those it relies
	// on return non-zero if a space type of character is passed in
	// BEW added 3rd subtest 23Nov2. And HairSpace on 17Dec22, 19Aug23 added test for '\r'
	if (wxIsspace(*pChar) != 0 || *pChar == NBSP || *pChar == _T('\r') || *pChar == _T('\n') || *pChar == HairSpace)
	{
		return TRUE;
	}
	else
	{
#ifdef _UNICODE
		//#if defined(FWD_SLASH_DELIM)
				// BEW 23Apr15, support / as if a whitespace word-breaker
		if (gpApp->m_bFwdSlashDelimiter)
		{
			if (*pChar == _T('/'))
				return TRUE;
		}
		//#endif
				// BEW 3Aug11, support ZWSP (zero-width space character, U+200B) as well, and from
				// Dennis Drescher's email of 3Aug11, also various others - more common exotic ones
				// tried first, and if not those then the less common ones
				// BEW 4Aug11 changed the code to not test each individually, but just test if
				// wxChar value falls in the range 0x2000 to 0x200D - which is much quicker; and
				// treat U+2060 individually
				// BEW 24Mar12, removed 0x200C and 0x200D from being word-breaking, because Mark
				// Penny said (13Mar12) in an email that those two are used as word-forming
				// characters in many Indian languages
		wxChar WJ = (wxChar)0x2060; // WJ is "Word Joiner"
		// Better to do the check with a range, rather than the commented out stuff below
		// BEW added 3rd subtest 23Nov22
		if (*pChar == WJ || (*pChar >= (wxChar)0x2000 && *pChar <= (wxChar)0x200B) || *pChar == _T('\n'))
		{
			return TRUE;
		}

#endif
	}
	return FALSE;
	*/
	// whm 18Aug2023 note: the IsWhiteSpace() function in helpers.cpp is a "global function"
	// being in global scope (i.e., not part of a class). To avoid a re-entry situation call
	// here within the CAdapt_ItDoc class we prefix :: on the function call of IsWhiteSpace()
	// below which forces the call to the global function in helpers.cpp which also takes a
	// const parameter.
	// ********* CALL THE GLOBAL FUNCTION IN helpers.cpp  *******
	// ********* DO NOT CHANGE THE LINES BELOW ******************
	const wxChar* pcChar = pChar;
	return ::IsWhiteSpace(pcChar);
	// ********* DO NOT CHANGE THE LINES ABOVE ******************
}


///////////////////////////////////////////////////////////////////////////////
/// \return		the number of whitespace characters parsed
/// \param		pChar	-> a pointer to a character being examined/referenced
/// \remarks
/// Called from: the Doc's GetMarkersAndEndMarkersFromString(), TokenizeText(), DoMarkerHousekeeping(),
/// the View's DetachedNonQuotePunctuationFollows(), FormatMarkerBufferForOutput(),
/// FormatUnstructuredTextBufferForOutput(), DoExportInterlinearRTF(), DoExportSrcOrTgtRTF(),
/// DoesTheRestMatch(), ProcessAndWriteDestinationText(), ApplyOutputFilterToText(),
/// ParseAnyFollowingChapterLabel(), NextMarkerIsFootnoteEndnoteCrossRef(),
/// IsFixedSpaceAhead() and from Usfm2Oxes ParseMarker_Content_Endmarker(),
/// and GetNextFilteredMarker_After()
/// Parses through a buffer's whitespace beginning at pChar.
///////////////////////////////////////////////////////////////////////////////
int CAdapt_ItDoc::ParseWhiteSpace(wxChar* pChar)
{
	int	length = 0;
	wxChar* ptr = pChar;
	while (IsWhiteSpace(ptr))
	{
		length++;
		ptr++;
	}
	return length;
}

///////////////////////////////////////////////////////////////////////////////
/// \return		the number of filtering sfm characters parsed
/// \param		wholeMkr	-> the whole marker (including backslash) to be parsed
/// \param		pChar		-> pointer to the backslash character at the beginning of the marker
/// \param		pBufStart	-> pointer to the start of the buffer
/// \param		pEnd		-> pointer at the end of the buffer
/// \remarks
/// Called from: the Doc's TokenizeText()
/// Parses through the filtering marker beginning at pChar (the initial backslash).
/// Upon entry pChar must point to a filtering marker determined by a prior call to
/// IsAFilteringSFM(). 
/// 
/// whm 24Oct2023 comment. The above comment is incorrect. It should read:
/// "Upon entry pChar must point to a filtering marker determined by examining the
/// gCurrentFilterMarkers string." The reason why is The IsAFilteringSFM() function
/// only returns the DEFAULT state of the marker as defined in the AI_USFM.xml control
/// file. It's filter="0" does NOT change from that value even when the user ticks the
/// filtering box within the USFM/Filtering tab in Preferences.
/// 
/// Parsing will include any embedded (inline) markers belonging
/// to the parent marker.
/// BEW 9Sep10 removed need for param pBufStart, since only IsMarker() used to use
/// it as its second param and with docVersion 5 changes that became unnecessary
/// BEW additions 24Oct14 for support of USFM nested markers
/// BEW Filtering of \fig ... \fig* exited early because the figure information carried
/// a windows path string, so the rest of the figure configuration data ended up in
/// the data. Fixed this to span across the contents without checking for a marker other
/// than \fig*
///////////////////////////////////////////////////////////////////////////////
int CAdapt_ItDoc::ParseFilteringSFM(const wxString wholeMkr, wxChar* pChar,
									wxChar* pBufStart, wxChar* pEnd)
{
	wxUnusedVar(pBufStart);
	// whm added 10Feb2005 in support of USFM and SFM Filtering support
	// BEW ammended 10Jun05 to have better parse termination criteria
	// Used in TokenizeText(). For a similar named function used
	// only in DoMarkerHousekeeping(), see ParseFilteredMarkerText().
	// Upon entry pChar must point to a filtering marker determined
	// by prior call to IsAFilteringSFM().
	// ParseFilteringSFM advances the ptr until one of the following
	// conditions is true:
	// 1. ptr == pEnd (end of buffer is reached).
	// 2. ptr points just past a corresponding end marker to the one passed in.
	// 3. ptr points to a subsequent non-inLine and non-end marker. This
	//    means the "content markers"
	// whm ammended 30Apr05 to include "embedded content markers" in
	// the parsed filtered marker, i.e., any \xo, \xt, \xk, \xq, and
	// \xdc that follow the marker to be parsed will be included within
	// the span that is parsed. The same is true for any footnote content
	// markers (see notes below).
	int	length = 0;
	int endMkrLength = 0;
	wxChar* ptr = pChar;
	if (ptr < pEnd)
	{
		// advance pointer one to point past wholeMkr's initial backslash
		length++;
		ptr++;
	}
	// BEW 24Oct14 added next 3 lines
	//bool bIsNestedMkr = FALSE;
	bool bIsWholeMkr = TRUE;
	wxString theTag; theTag.Empty();
	wxString baseOfEndMkr;

	while (ptr != pEnd)
	{
		//if (IsMarker(ptr,pBufStart)) BEW changed 7Sep10
		if (IsMarker(ptr))
		{
			if (IsCorresEndMarker(wholeMkr, ptr, pEnd))
			{
				// it is the corresponding end marker so parse it
				// Since end markers may not be followed by a space we cannot
				// use ParseMarker to reliably parse the endmarker, so
				// we'll just add the length of the end marker to the length
				// of the filtered text up to the end marker
				endMkrLength = wholeMkr.Length() + 1; // add 1 for *
				return length + endMkrLength;
			}
			else if (IsInLineMarker(ptr, pEnd) &&
				IsNestedMarkerOrMarkerTag(ptr, theTag, baseOfEndMkr, bIsWholeMkr))
			{
				// BEW 24Oct14 addition. Bleed the \+tag nested markers here, because
				// the block following is for non-nested inline ones, like the content
				// markers within footnotes or crossrefs or endnotes, and the next block's
				// test checks the char following the backslash and we don't want that to
				// be a +, so we handle the nested ones here first (note: IsInLineMarker()
				// has been refactored to support USFM nested markers)
				; // continue parsing, nested ones get included within a filtering, if encountered
			}
			else if (IsInLineMarker(ptr, pEnd) && *(ptr + 1) == wholeMkr.GetChar(1))
			{
				; // continue parsing
				// We continue incrementing ptr past all inLine markers following a
				// filtering marker that start with the same initial letter (after
				// the backslash) since those can be assumed to be "content markers"
				// embedded within the parent marker. For example, if our filtering
				// marker is the footnote marker \f, any of the footnote content
				// markers \fr, \fk, \fq, \fqa, \ft, \fdc, \fv, and \fm that happen to
				// follow \f will also be filtered. Likewise, if the cross reference
				// marker \x if filtered, any inLine "content" markers such as \xo,
				// \xt, \xq, etc., that might follow \x will also be subsumed in the
				// parse and therefore become filtered along with the \x and \x*
				// markers. The check to match initial letters of the following markers
				// with the parent marker should eliminate the possibility that another
				// unrelated inLine marker (such as \em emphasis) would accidentally
				// be parsed over
			}
			else
			{
				wxString bareMkr = GetBareMarkerForLookup(ptr);
				wxASSERT(!bareMkr.IsEmpty());
				// BEW 24Oct14, LookupSFM() has been refactored for support of USFM nested markers
				USFMAnalysis* pAnalysis = LookupSFM(bareMkr);
				if (pAnalysis)
				{
					if (pAnalysis->textType == none)
					{
						; // continue parsing
						// We also increment ptr past all inLine markers following a filtering
						// marker, if those inLine markers are ones which pertain to character
						// formatting for a limited stretch, such as italics, bold, small caps,
						// words of Jesus, index entries, ordinal number specification, hebrew or
						// greek words, and the like. Currently, these are: ord, bd, it, em, bdit,
						// sc, pro, ior, w, wr, wh, wg, ndx, k, pn, qs -- and their corresponding
						// endmarkers (not listed here) -- this list is specific to Adapt It, it
						// is not a formally defined subset within the USFM standard
					}
					else
					{
						break;	// it's another marker other than corresponding end marker, or
								// a subsequent inLine marker or one with TextType none, so break
								// because we are at the end of the filtered text.
					}
				}
				else
				{
					// pAnalysis is null, this indicates either an unknown marker, or a marker from
					// a different SFM set which is not in the set currently active - eiher way, we
					// treat these as inLine == FALSE, and so such a marker halts parsing
					break;
				}
			}
		}
		length++;
		ptr++;
	}
	return length;
}

///////////////////////////////////////////////////////////////////////////////
/// \return		the number of numeric characters parsed
/// \param		pChar		-> pointer to the first numeric character
/// \remarks
/// Called from: the Doc's TokenizeText(), DoMarkerHousekeeping(), and
/// DoExportInterlinearRTF().
/// Parses through the number until whitespace is encountered (generally a newline)
/// BEW added test for a null, because this function is used in DoMarkerHousekeeping() and
/// so looks at m_markers strings, where it is sometimes possible for a verse number, for
/// example, to end the m_markers string (we try to have a space there), and I got a crash
/// when parsing "\v 4" from a Dynamic Tok Pisin file of James, in chapter 1 -- length had
/// somehow run on to a value of 779 before a crash happened!
//////////////////////////////////////////////////////////////////////////////////
int CAdapt_ItDoc::ParseNumber(wxChar* pChar)
{
	wxChar* ptr = pChar;
	int length = 0;
	wxChar hyphen = _T('-');
	wxChar chA = _T('a');
	wxChar chB = _T('b');
	// BEW 24Aug11, added 2nd test to next line
	// BEW 9Sep14, added subtest for \ of a marker, otherwise \c 4 followed by a line
	// \s Stori.... gives m_markers with "\c 4\s " which gets interpretted by ParseNumber
	// as "4\s" is the 'number' for the chapter, & carries it through each verse in doc!
	// BEW 11Jun23 added subtest: && *ptr != _T('\n')
	// whm 21Aug2023 Note: The IsWhiteSpace() function detects both '\n' and '\r' so those EOL
	// chars need not be explicitly tested for here, but testing for them doesn't hurt anything.
	// BEW 8Sep23, oops, this will parse beyond the end of the number digits, as the while loop
	// does not check that ptr is a digit at each iteration - Fix this: add, && IsAnsiDigit(*ptr)
	// BEW 20Sep23 adding  AND IsAnsiDigit(*ptr) to the test was too strong, it destroyed the
	// ability to parse through the hyphen of a bridge verse number, eg. "3-5", so that the -5
	// ended up as GUI src text in the layout. The fix is to OR it with a hyphen.
	while (!IsWhiteSpace(ptr) && (*ptr != _T('\0')) && (*ptr != _T('\r')) && (*ptr != _T('\n')) && (*ptr != gSFescapechar) && (IsAnsiDigit(*ptr) || hyphen) )
	{
		// BEW 18Oct23 for unknown reason, for a string like:  37).\f* after parsing the 37 correctly, so that ptr 
		// points at ')', IsAnsiDigit(*ptr) in the while test returns TRUE, similarly for the '.' following; so that
		// if I do nothing more, the a length of 4 is returned, rather than the correct value of 2. So my fix will
		// be to explicitly check for *ptr == ')', and when matched, to break from the loop with correct length 2,
		// because on return, code checks for ')' to complete the bracketed number
		if (*ptr == _T(')'))
		{
			break;
		}
		else
		{
			ptr++;
			length++;
		}
	}
	// Handle verse parts where a or b is suffixed
	if (*ptr == chA)
	{
		ptr++;
		length++;
	}
	else if (*ptr == chB)
	{
		ptr++;
		length++;
	}
	return length;
}

// BEW 1Aug23, to get a number string without having to use wxChar*
wxString CAdapt_ItDoc::ParseNumberInStr(wxString strStartingWithNumber)
{
	wxString strReturn = wxEmptyString;
	if (strStartingWithNumber.IsEmpty())
	{
		return strReturn;
	}
	int numLen;
	numLen = 0; // init
	const wxChar* pBuffStart = strStartingWithNumber.GetData();
	wxChar* ptr = (wxChar*)pBuffStart; // this is not const
	wxChar* pEnd = ptr + strStartingWithNumber.Len(); // points to null if .c_str() called
	wxUnusedVar(pEnd);
	numLen = ParseNumber(ptr);
	strReturn = wxString(ptr, numLen);
	return strReturn;
}

///////////////////////////////////////////////////////////////////////////////
/// \return		TRUE if the marker being pointed to by pChar is a verse marker, FALSE otherwise.
/// \param		pChar		-> pointer to the first character to be examined (a backslash)
/// \param		nCount		<- returns the number of characters forming the marker
/// \remarks
/// Called from: the Doc's TokenizeText() and DoMarkerHousekeeping(),
/// DoExportInterlinearRTF() and DoExportSrcOrTgtRTF().
/// Determines if the marker at pChar is a verse marker. Intelligently handles verse markers
/// of the form \v and \vn.
/// BEW 24Oct14 no changes needed for support of USFM nested markers
///////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItDoc::IsVerseMarker(wxChar* pChar, int& nCount)
// version 1.3.6 and onwards will accomodate Indonesia branch's use
// of \vn as the marker for the number part of the verse (and \vt for
// the text part of the verse - AnalyseMarker() handles the latter)
{
	wxChar* ptr = pChar;
	ptr++;
	if (*ptr == _T('v'))
	{
		ptr++;
		if (*ptr == _T('n'))
		{
			// must be an Indonesia branch \vn 'verse number' marker
			// if white space follows
			ptr++;
			nCount = 3;
		}
		else
		{
			nCount = 2;
		}
		return IsWhiteSpace(ptr);
	}
	else
		return FALSE;
}

// whm 21Feb2024 added. This is a convenience function that allows a determination
// of whether the marker at pChar is an unknown marker without having to parse over
// the marker, etc.
// Currently used to jump out of an inner loop and to the finishup: label when an
// empty unknown marker has been detected, so that the current pSrcPhrase can be
// appended to pList and a new source phrase created to store the empty unknown
// marker.
// This function should only be called when pChar is pointing at the backslash of
// a marker.
// It returns TRUE if the maker is an unknown marker, otherwise for a known marker
// (or not pointing at any marker) it returns FALSE;
bool CAdapt_ItDoc::IsUnknownMarker(wxChar* pChar)
{
	if (*pChar != _T('\\'))
		return FALSE;
	// parse the marker and get a bareMkr
	int itemLen = 0;
	itemLen = ParseMarker(pChar);
	wxString bareMkr;
	bareMkr = wxString(pChar, itemLen);
	bareMkr = bareMkr.Mid(1);
	// in the next call NULL is returned if bareMkr is an unknown marker
	USFMAnalysis* pUsfmAnalysis = LookupSFM(bareMkr);
	if (pUsfmAnalysis == NULL)
		return TRUE;
	else
		return FALSE;
}

///////////////////////////////////////////////////////////////////////////////
/// \return		TRUE if pChar points at a \~FILTER (beginning filtered material marker)
/// \param		pChar		-> a pointer to the first character to be examined (a backslash)
/// \param		pEnd		-> a pointer to the end of the buffer
/// \remarks
/// Called from: the Doc's GetMarkersAndEndMarkersFromString()
/// Determines if the marker being pointed at is a \~FILTER marking the beginning of filtered
/// material.
/// BEW 24Mar10 no changes needed for support of doc version 5
///////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItDoc::IsFilteredBracketMarker(wxChar* pChar, wxChar* pEnd)
{
	// whm added 10Feb2005 in support of USFM and SFM Filtering support
	// determines if pChar is pointing at the filtered text begin bracket \~FILTER
	wxChar* ptr = pChar;
	// whm 8Jun12 modified for wxWidgets-2.9.3 wxStrlen_() is invalid, use wxStrlen()
	//for (int i = 0; i < (int)wxStrlen_(filterMkr); i++) //_tcslen
	for (int i = 0; i < (int)wxStrlen(filterMkr); i++) //_tcslen
	{
		if (ptr + i >= pEnd)
			return FALSE;
		if (*(ptr + i) != filterMkr[i])
			return FALSE;
	}
	return TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \return		TRUE if pChar points at a \~FILTER* (ending filtered material marker)
/// \param		pChar		-> a pointer to the first character to be examined (a backslash)
/// \param		pEnd		-> a pointer to the end of the buffer
/// \remarks
/// Called from: the Doc's GetMarkersAndEndMarkersFromString().
/// Determines if the marker being pointed at is a \~FILTER* marking the end of filtered
/// material.
/// BEW 24Mar10 no changes needed for support of doc version 5
///////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItDoc::IsFilteredBracketEndMarker(wxChar* pChar, wxChar* pEnd)
{
	// whm added 18Feb2005 in support of USFM and SFM Filtering support
	// determines if pChar is pointing at the filtered text end bracket \~FILTER*
	wxChar* ptr = pChar;
	// whm 8Jun12 modified for wxWidgets-2.9.3 wxStrlen_() is invalid, use wxStrlen()
	//for (int i = 0; i < (int)wxStrlen_(filterMkrEnd); i++) //_tcslen
	for (int i = 0; i < (int)wxStrlen(filterMkrEnd); i++) //_tcslen
	{
		if (ptr + i >= pEnd)
			return FALSE;
		if (*(ptr + i) != filterMkrEnd[i])
			return FALSE;
	}
	return TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \return		the number of characters parsed
/// \param		pChar		-> a pointer to the first character to be parsed (a backslash)
/// \remarks
/// Called from: the Doc's ReconstituteAfterFilteringChange(), GetWholeMarker(), TokenizeText(),
/// DoMarkerHousekeeping(), IsEndingSrcPhrase(), ContainsMarkerToBeFiltered(),
/// RedoNavigationText(), GetNextFilteredMarker(), the View's FormatMarkerBufferForOutput(),
/// DoExportSrcOrTgtRTF(), FindFilteredInsertionLocation(), IsFreeTranslationEndDueToMarker(),
/// ParseFootnote(), ParseEndnote(), ParseCrossRef(), ProcessAndWriteDestinationText(),
/// ApplyOutputFilterToText(), ParseMarkerAndAnyAssociatedText().
/// Parses through to the end of a standard format marker.
/// Caution: This function will fail unless the marker pChar points at is followed
/// by whitespace of some sort - a potential crash problem if ParseMarker is used for parsing
/// markers in local string buffers; ensure the buffer ends with a space so that if an end
/// marker is at the end of a string ParseMarker won't crash (TCHAR(0) won't help at the end
/// of the buffer here because _istspace which is called from IsWhiteSpace() only recognizes
/// 0x09 ?0x0D or 0x20 as whitespace for most locales.)
/// BEW 1Feb11, added test for forbidden marker characters using app::m_forbiddenInMarkers
/// BEW 24Oct14 no changes needed for support of USFM nested markers
/// BEW 30Nov22, there was no sanity check. So if pChar points at, say, "2.22" which is  NOT
/// a marker, it returns itemLen = 4 !!! Fix this, pChar must point at gSFescapechar
///////////////////////////////////////////////////////////////////////////////
int CAdapt_ItDoc::ParseMarker(wxChar* pChar)
{
	// whm Note: Caution: This function will fail unless the marker pChar points at is
	// followed by whitespace of some sort - a potential crash problem if ParseMarker is
	// used for parsing markers in local string buffers; ensure the buffer ends with a
	// space so that if an end marker is at the end of a string ParseMarker won't crash
	// (TCHAR(0) won't help at the end of the buffer here because _istspace which is called
	// from IsWhiteSpace() only recognizes 0x09 ?0x0D or 0x20 as whitespace for most
	// locales.
	// whm modified 24Nov07 added the test to end the while loop if *ptr points to a null
	// char. Otherwise in the wx version a buffer containing "\fe" could end up with a
	// length of something like 115 characters, with an embedded null char after the third
	// character in the string. This would foul up subsequent comparisons and Length()
	// checks on the string, resulting in tests such as if (mkrStr == _T("\fe")) failing
	// even though mkrStr would appear to contain the simple string "\fe".
	// I still consider ParseMarker as designed to be dangerous and think it appropriate to
	// TODO: add a wxChar* pEnd parameter so that tests for the end of the buffer can be
	// made to prevent any such problems. The addition of the test for null seems to work
	// for the time being.
	// whm ammended 7June06 to halt if another marker is encountered before whitespace
	// BEW ammended 11Oct10 to halt if a closing bracket ] follows the (end)marker
	int len = 0;
	wxChar* ptr = pChar; // was wchar_t
	if (*pChar != gSFescapechar)
	{
		return len; // BEW 30Nov22 added this sanity check
	}
	wxChar* pBegin = ptr;
	while (!IsWhiteSpace(ptr) && *ptr != _T('\0') && gpApp->m_forbiddenInMarkers.Find(*ptr) == wxNOT_FOUND)
	{
		if (ptr != pBegin && (*ptr == gSFescapechar || *ptr == _T(']')))
			break;
		ptr++;
		len++;
		if (*(ptr - 1) == _T('*')) // whm ammended 17May06 to halt after asterisk (end marker)
			break;
	}
	return len;
}

///////////////////////////////////////////////////////////////////////////////
/// \return		a wxString representing the marker being pointe to by pChar
/// \param		pChar		-> a pointer to the first character to be examined (a backslash)
/// \param		pEnd		-> a pointer to the end of the buffer
/// \remarks
/// Called from: the Doc's GetMarkersAndEndMarkersFromString().
/// Returns the whole marker by parsing through an existing marker until either whitespace is
/// encountered or another backslash is encountered.
/// BEW fixed 10Sep10, the last test used forward slash, and should be backslash
/// BEW 24Oct14, no changes needed for support of USFM nested markers
/// BEW 25Mar15, refactored - it was returning nothing because pChar was pointing at
/// backslash on entry, so added a code block to accumulate the backslash before doing
/// the loop
///////////////////////////////////////////////////////////////////////////////
wxString CAdapt_ItDoc::MarkerAtBufPtr(wxChar* pChar, wxChar* pEnd) // whm added 18Feb05
{
	int len = 0;
	wxChar* ptr = pChar;
	// To make this code safe when the m_markers member contains \p\v sequence (with no
	// intervening space) or the more common \p \v sequence (with intervening space),
	// requires changes. First, on entry pChar points at the initial backslash, and so
	// the && *ptr != _T('\\') subtest causes immediate break from the loop, leading to
	// nothing being returned. So we need to accumulate that initial backslash unilaterally.
	// After that, the loop will work correctly for either \p\v  or  \p \v  sequences
	if (*ptr == _T('\\'))
	{
		ptr++;
		len++;
	}
	// Now traverse the rest of the marker, up to the next whitespace or backslash
	while (ptr < pEnd && !IsWhiteSpace(ptr) && *ptr != _T('\\'))
	{
		ptr++;
		len++;
	}
	return wxString(pChar, len);
}

// return TRUE if the quotation character at pChar is either " or '
bool CAdapt_ItDoc::IsStraightQuote(wxChar* pChar)
{
	if (gpApp->m_bDoubleQuoteAsPunct)
	{
		if (*pChar == _T('\"')) return TRUE; // ordinary double quote
	}
	if (gpApp->m_bSingleQuoteAsPunct)
	{
		if (*pChar == _T('\'')) return TRUE; // ordinary single quote
	}
	return FALSE;
}

bool CAdapt_ItDoc::IsFootnoteInternalEndMarker(wxChar* pChar)
{
	wxString endMkr = GetWholeMarker(pChar);
	if (endMkr[0] != gSFescapechar)
		return FALSE;
	if (endMkr == _T("\\fig*"))
		return FALSE;
	wxString reversed = MakeReverse(endMkr);
	if (reversed[0] != _T('*'))
		return FALSE;
	else
	{
		reversed = reversed.Mid(1); // remove initial *
		endMkr = MakeReverse(reversed); // now \f should be first 2 characters
									// if it is an internal footnote endmarker
		int length = endMkr.Len();
		if (length < 3)
			return FALSE; // it could be \f at best, and that is not enough
		if (endMkr.Find(_T("\\f")) != 0)
			return FALSE; // \f has to be at the start of the marker, to qualify
		endMkr = endMkr.Mid(2); // chop off the initial \f
		if (endMkr.Len() > 0)
		{
			// if it has any content left, then it is an internal footnote endmarker,
			// any other value disqualifies it
			return TRUE;
		}
	}
	return FALSE;
}

bool CAdapt_ItDoc::IsCrossReferenceInternalEndMarker(wxChar* pChar)
{
	wxString endMkr = GetWholeMarker(pChar);
	if (endMkr[0] != gSFescapechar)
		return FALSE;
	wxString reversed = MakeReverse(endMkr);
	if (reversed[0] != _T('*'))
		return FALSE;
	else
	{
		reversed = reversed.Mid(1); // remove initial *
		endMkr = MakeReverse(reversed); // now \x should be first 2 characters
							// if it is an internal crossReference endmarker
		int length = endMkr.Len();
		if (length < 3)
			return FALSE; // it could be \x at best, and that is not enough
		if (endMkr.Find(_T("\\x")) != 0)
			return FALSE; // \x has to be at the start of the marker, to qualify
		endMkr = endMkr.Mid(2); // chop off the initial \x
		if (endMkr.Len() > 0)
		{
			// if it has any content left, then it is an internal crossReference
			// endmarker, any other value disqualifies it
			return TRUE;
		}
	}
	return FALSE;
}

// BEW 30Sep19 added 3rd param, the boolean is default FALSE for checking for a match
// in pSrcPhrase->m_endMarkers member. If the bool is passed in as TRUE, the check is
// done instead in the pSrcPhrase->m_inlineNonbindingEndMarkers member. The mkr passed
// in is a begin-mkr which is to be matched to wherever its endmarker is in the span
// of CSourcePhrase instances being accumulated for filtering out, so we must internally
// construct from it the endMkr we want to match.
// And some refactoring here and there to take m_inlineNonbindingMarkers, and
// m_inlineNonbindingEndMarkers into account.
// If the return value is TRUE, then that passed in pSrcPhrase is the end-of-span one,
// and the caller will not call the safety checking function IsEndingSrcPhrase() on
// pSrcPhraseNext which acts to prevent span overrun or marker content overlap.
bool CAdapt_ItDoc::HasMatchingEndMarker(wxString mkr, CSourcePhrase* pSrcPhrase, bool bSearchInNonbindingEndMkrs)
{
	wxString mymkr = mkr;
	wxString endMkr = wxEmptyString;
	// Handle \esb and \esbe  in USFM3 standard
	if (mymkr == wxString(_T("\\esb")))
	{
		endMkr = _T("\\esbe");
	}
	else
	{
		mymkr = mymkr.Trim(); // remove any ending whitespace (there shouldn't be any anyway)
		mymkr += _T('*');

	}
	// Check in the non-binding end marker storage...
	if (bSearchInNonbindingEndMkrs)
	{
		// whm 31Oct2023 correction. Within this bSearchInNonbindingEndMkrs TRUE block
		// the endMkr that we may be dealing with could be "\\fig*". The if-else test
		// above does NOT set endMkr to anything, but leaves it wxEmptyString when 
		// the incoming mkr parameter is "\\fig". Below the if (endMkr == wholeNonbindingEndMkr)
		// test will fail for any "\\fig*" end marker stored within the 
		// pSrcPhrase->m_inlineNonbindingEndMarkers member. To fix this shortcoming, I'm
		// assigning the mymkr value determined above to the endMkr here within the
		// bSearchInNonbindingEndMkrs TRUE block.
		// whm 26Feb2024 comment: This should now catch end markers:
		// "\\fig*" "\\jmp*" "\\w*" "\\rb*" and "\\xt*".
		endMkr = mymkr;

		wxString inlineNonbindingEndMkrs = pSrcPhrase->GetInlineNonbindingEndMarkers();

		// return FALSE if pSrcPhrase->GetInlineNonbindingEndMarkers() is empty
		if (inlineNonbindingEndMkrs.IsEmpty())
		{
			return FALSE;
		}
		// the UsfmOnly set must be currently in use; the matching endmarker, 
		// if it exists, the caller says to look in m_inlineNonbindingEndMarkers;
		// and it will ALWAYS be the last one if that member stores more than one
		// - because if the earlier one was the filter marker, then it being filtered 
		// would remove the next one from contention for being available to 
		// the filtering mechanism ... so, there would not be a 'next' one
		// we need to consider.
		// A note about USFM3: our quick access marker strings include in the
		// inLine Non-binding set, the non-inline but Non-binding markers
		// \esb and its endmarker \esbe in the Non-binding End markers set.
		// These markers are used for extended sidebar markup, and are
		// filterable = 1, and useCanSetFilter = 1; there could be a lot
		// of text content between them.
		wxString wholeNonbindingEndMkr = GetLastMarker(inlineNonbindingEndMkrs);
		// Trim off any final whitespace
		wholeNonbindingEndMkr.Trim();
		if (endMkr == wholeNonbindingEndMkr)
		{
			// we have a match
			return TRUE;
		}
		return FALSE; // no match
	} // end of TRUE block for test: if (bSearchInNonbindingEndMkrs)

	else
	{
		wxString endMkrs = pSrcPhrase->GetEndMarkers();
		if (gpApp->gCurrentSfmSet == PngOnly)
		{
			// check for one of the 'footnote end' markers, the only endmarkers in the PNG 1998
			// marker set
			if (endMkrs.IsEmpty())
			{
				return FALSE;
			}
			if (endMkrs == _T("\\fe") || endMkrs == _T("\\F"))
			{
				// it's one of those two, so if mkr is \f, we've got a match
				wxString mkrPlusSpace = mkr + _T(' ');
				if (mkrPlusSpace == _T("\\f "))
				{
					return TRUE;
				}
				else
				{
					return FALSE;
				}
			}
		}
		// the UsfmOnly set must be currently in use; the matching endmarker, 
		// if it exists, must be in m_endMarkers and it will ALWAYS be the last one 
		// if that member stores more than one - because it the earlier one was the
		// filter marker, then it being filtered would remove the next one from 
		// being available to the filtering mechanism, hence, there cannot be
		// a 'next' one
		wxString endmarkers = pSrcPhrase->GetEndMarkers();
		if (endmarkers.IsEmpty())
		{
			return FALSE; // no match is possible
		}
		wxString wholeEndMkr = GetLastMarker(endmarkers);
		if (mymkr == wholeEndMkr)
		{
			// we have a match
			if (wholeEndMkr == _T("\\x*"))
			{
				m_bIsWithinCrossRef_X_Span = FALSE;
			}
			return TRUE;
		}
		return FALSE; // no match
	} // end of else block for test: if (bSearchInNonbindingEndMkrs)
}

// NOTE: the endmarker for endnote is included in the test, so while the name of this
// function suggests only \f* and \x* return TRUE, \fe* will also return TRUE
// BEW 7Dec10, added check for \fe or \f when SFM set is PngOnly
// BEW 24Oct14 no changes needed for support of USFM nested markers
// BEW 15Apr20 extended & refactored to support \ef* and \ex* USFM3
// extended footnotes and extended cross-references
bool CAdapt_ItDoc::IsFootnoteOrCrossReferenceEndMarker(wxChar* pChar)
{
	wxString endMkr = GetWholeMarker(pChar);
	if (gpApp->gCurrentSfmSet == PngOnly)
	{
		// check for 'footnote end' markers, the only endmarkers in the PNG 1998
		// marker set
		if (endMkr == _T("\\fe") || endMkr == _T("\\F"))
			return TRUE;
	}
	// whm 23Feb2024 To be safe, added test for endMkr == _T("\\jmp*) to also return FALSE below.
	if (endMkr == _T("\\fig*") || endMkr == _T("\\jmp*")) //if (endMkr == _T("\\fig*"))
		return FALSE;
	if (endMkr == _T("\\fe*"))
	{
		// we include a test for the endmarker of an endnote in this function, because we
		// want the handling for \f* and \fe* to be the same  - either, if found, should
		// be stored in m_endMarkers, and either can have outer punctuation following it
		return TRUE;
	}
	// whm 9Jul12 added endMkr.IsEmpty() test to prevent out-of-range array access
	// return if endMkr is empty or if its first character is not '\'
	if (endMkr.IsEmpty() || endMkr[0] != gSFescapechar)
		return FALSE;
	wxString rev = MakeReverse(endMkr);
	if (rev[0] != _T('*'))
		return FALSE;
	else
	{
		rev = rev.Mid(1); // remove initial *
		// rev is maybe one of:   f\  fe\  x\  xe\  <== ending backslash in comment. GCC warns about muitiline comment
		// To qualify for correctness, the [0] index one must be either f or x
		// For each of those, also test [1] for 'e' - and for each each the
		// backslash must follow. First, footnote and extended footnote
		if (rev[0] == _T('f'))
		{
			if (rev[1] == gSFescapechar)
			{
				// it's a \f* end marker
				m_bIsWithinUnfilteredInlineSpan = FALSE; // BEW added 2Dec22, as few places restore it to FALSE
				return TRUE;
			}
			else
			{
				if (rev[1] == _T('e') && rev[2] == gSFescapechar)
				{
					// it's a \ef* extended footnote end marker
					m_bIsWithinUnfilteredInlineSpan = FALSE; // BEW added 2Dec22, as few places restore it to FALSE
					return TRUE;
				}
			}
		}
		// Next, handle cross refs ones
		if (rev[0] == _T('x'))
		{
			if (rev[1] == gSFescapechar)
			{
				// it's a \x* end marker
				m_bIsWithinUnfilteredInlineSpan = FALSE; // BEW added 2Dec22, as few places restore it to FALSE
				return TRUE;
			}
			else
			{
				if (rev[1] == _T('e') && rev[2] == gSFescapechar)
				{
					// it's a \ex* extended x-ref end marker
					return TRUE;
				}
			}
		}
		/* legacy code
				endMkr = MakeReverse(reversed);
				int length = endMkr.Len();
				if (length > 2)
					return FALSE; // what remains is more than \x or \f, so disqualified
				if ((endMkr.Find(_T("\\x")) == 0) || (endMkr.Find(_T("\\f")) == 0))
					return TRUE; // what remains is either \x or \f, so it qualifies
		*/
	}
	// It's none of these
	return FALSE;
}


///////////////////////////////////////////////////////////////////////////////
/// \return		TRUE if pChar is pointing to an opening quote mark
/// \param		pChar		-> a pointer to the character to be examined
/// \remarks
/// Called from: the Doc's ParseWord(), the View's DetachedNonQuotePunctuationFollows().
/// Determines is the character being examined is some sort of opening quote mark. An
/// opening quote mark may be a left angle wedge <, a Unicode opening quote char L'\x201C'
/// or L'\x2018', or an ordinary quote or double quote or char 145 or 147 in the ANSI set.
/// Assumes that " is defined as m_bDoubleQuoteAsPunct in the App and/or that ' is defined
/// as m_bSingleQuoteAsPunct in the App.
///////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItDoc::IsOpeningQuote(wxChar* pChar)
{
	// next three functions added by BEW on 17 March 2005 for support of
	// more clever parsing of sequences of quotes with delimiting space between
	// -- these are to be used in a new version of ParseWord(), which will then
	// enable the final couple of hundred lines of code in TokenizeText() to be
	// removed
	// include legacy '<' as in SFM standard, as well as smart quotes
	// and normal double-quote, and optional single-quote
	if (*pChar == _T('<')) return TRUE; // left wedge
#ifdef _UNICODE
	if (*pChar == L'\x201C') return TRUE; // unicode Left Double Quotation Mark
	if (*pChar == L'\x2018') return TRUE; // unicode Left Single Quotation Mark
#else // ANSI version
	if ((unsigned char)*pChar == 147) return TRUE; // Left Double Quotation Mark
	if ((unsigned char)*pChar == 145) return TRUE; // Left Single Quotation Mark
#endif
	if (gpApp->m_bDoubleQuoteAsPunct)
	{
		if (*pChar == _T('\"')) return TRUE; // ordinary double quote
	}
	if (gpApp->m_bSingleQuoteAsPunct)
	{
		if (*pChar == _T('\'')) return TRUE; // ordinary single quote
	}
	// the left-pointing double angle quotation mark
#ifdef _UNICODE
	if (*pChar == L'\x00AB') return TRUE; // left-pointing double chevron
#else
	if (*pChar == '\xAB') return TRUE; // left-pointing double chevron
#endif
	return FALSE;
}

///////////////////////////////////////////////////////////////////////////////
/// \return		TRUE if pChar is pointing to a " or to a ' (apostrophe) quote mark
/// \param		pChar		-> a pointer to the character to be examined
/// \remarks
/// Called from: the Doc's ParseWord().
/// Assumes that " is defined as m_bDoubleQuoteAsPunct in the App and/or that ' is defined
/// as m_bSingleQuoteAsPunct in the App.
///////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItDoc::IsAmbiguousQuote(wxChar* pChar)
{
	if (gpApp->m_bDoubleQuoteAsPunct)
	{
		if (*pChar == _T('\"')) return TRUE; // ordinary double quote
	}
	if (gpApp->m_bSingleQuoteAsPunct)
	{
		if (*pChar == _T('\'')) return TRUE; // ordinary single quote (ie. apostrophe)
	}
	return FALSE;
}

///////////////////////////////////////////////////////////////////////////////
/// \return		TRUE if pChar is pointing to a closing quote mark
/// \param		pChar		-> a pointer to the character to be examined
/// \remarks
/// Called from: the Doc's ParseWord().
/// Determines is the character being examined is some sort of closing quote mark.
/// An closing quote mark may be a right angle wedge >, a Unicode closing quote char L'\x201D'
/// or L'\x2019', or an ordinary quote or double quote or char 146 or 148 in the ANSI set.
/// Assumes that " is defined as m_bDoubleQuoteAsPunct in the App and/or that ' is defined
/// as m_bSingleQuoteAsPunct in the App.
///////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItDoc::IsClosingQuote(wxChar* pChar)
{
	// include legacy '>' as in SFM standard, as well as smart quotes
	// and normal double-quote, and optional single-quote
	if (*pChar == _T('>')) return TRUE; // right wedge
#ifdef _UNICODE
	if (*pChar == L'\x201D') return TRUE; // unicode Right Double Quotation Mark
	if (*pChar == L'\x2019') return TRUE; // unicode Right Single Quotation Mark
#else // ANSI version
	if ((unsigned char)*pChar == 148) return TRUE; // Right Double Quotation Mark
	if ((unsigned char)*pChar == 146) return TRUE; // Right Single Quotation Mark
#endif
	if (gpApp->m_bDoubleQuoteAsPunct)
	{
		if (*pChar == _T('\"')) return TRUE; // ordinary double quote
	}
	if (gpApp->m_bSingleQuoteAsPunct)
	{
		if (*pChar == _T('\'')) return TRUE; // ordinary single quote
	}
	// the right-pointing double angle quotation mark
#ifdef _UNICODE
	if (*pChar == L'\x00BB') return TRUE; // the double chevron
#endif
	return FALSE;
}

bool CAdapt_ItDoc::IsClosingDoubleChevron(wxChar* pChar)
{
	// the right-pointing double angle quotation mark
#ifdef _UNICODE
	if (*pChar == L'\x00BB') return TRUE; // right-pointing double chevron
#else
	if (*pChar == '\xBB') return TRUE; // right-pointing double chevron
#endif
	return FALSE;
}

///////////////////////////////////////////////////////////////////////////////
/// \return		TRUE if pChar is pointing to a closing curly quote mark
/// \param		pChar		-> a pointer to the character to be examined
/// \remarks
/// Called from: the Doc's ParseWord().
/// Determines is the character being examined is some sort of non-straight closing quote
/// mark, that is, not one of ' or ". So a closing curly quote mark may be a right angle
/// wedge >, or a Unicode closing quote char L'\x201D' or L'\x2019'.
///////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItDoc::IsClosingCurlyQuote(wxChar* pChar)
{
	// include legacy '>' as in SFM standard, as well as smart quotes
	// but not normal double-quote, nor single-quote
	if (*pChar == _T('>')) return TRUE; // right wedge
#ifdef _UNICODE
	if (*pChar == L'\x201D') return TRUE; // unicode Right Double Quotation Mark
	if (*pChar == L'\x2019') return TRUE; // unicode Right Single Quotation Mark
#else // ANSI version
	if ((unsigned char)*pChar == 148) return TRUE; // Right Double Quotation Mark
	if ((unsigned char)*pChar == 146) return TRUE; // Right Single Quotation Mark
#endif
	return FALSE;
}

///////////////////////////////////////////////////////////////////////////////
/// \return		TRUE if pChar is pointing to a closing doublequote " (straight, not curly)
///             which should NOT be interpretted as a closing quote, but rather as an
///             opening quote for the word which follows; FALSE if it is acceptable as
///             a closing quote to the just parsed word
/// \param		pChar		-> a pointer to the character to be examined
/// \param      pPunctStart -> a pointer to the start of the string being parsed
///             (typically, it would point at a space which is ambiguous as to
///             whether it is a word delimiting space, or a closing punctuation
///             delimiting space)
/// \remarks
/// Called from: the Doc's ParseAdditionalFinalPuncts(). This is a hack. It's "protection"
/// just in case the clearing of the flag m_bHasPrecedingStraightQuote did not stop the
/// caller from recognising a straight doublequote wrongly as a closing quote - so this
/// hack should catch anything that leaks through. m_bHasPrecedingStraightQuote is TRUE
/// only when " is encountered as a word initial quote, ' is now (2Nov16, BEW)interpretted
/// the same, because while ' is often preceding a vowel in some Pacific languages to
/// indicate the vowel is "hard",this is an issue only when the vowel is word initial.
/// ' needs to be defaulted to being punctuation so that '\it <some word> gets parsed
/// properly - otherwise the ' ends up as a word in its own right on its own CSourcePhrase.
/// The function looks at what follows *ptr, and what precedes, since *ptr is " character.
/// If what follows it not a whitespace, then " must be interpretted as belonging to the
/// next word in the parse, and so we return TRUE. It can't be a closing quote. Looking
/// to what precedes, we examine the character immediately preceding *pPunctStart - that
/// will typically be a parsed over punctuation character. The " we are concerned about
/// should only be a 'detached quote' if there was, prior to any just-pased-over whitespace,
/// another straight quote, or a curly closed quote, or a > chevron.
///////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItDoc::CannotBeClosingQuote(wxChar* ptr, wxChar* pPunctStart)
{
	wxChar charNext = *(ptr + 1);
	if (!IsWhiteSpace(&charNext))
	{
		return TRUE;
	}
	wxChar charBeforeParseStartLoc = *(pPunctStart - 1);
	if (!IsClosingQuote(&charBeforeParseStartLoc))
	{
		return TRUE;
	}
	return FALSE;
}


// BEW 15Dec10, changes needed to handle PNG 1998 marker set's \fe and \F
// BEW 24Oct14 no changes needed for support of USFM nested markers, the ones dealt
// with here never take +
// BEW 30Sep19 added \fig* to this, as for USFM3 it needs to be m_bSpecialText TRUE
// when not filtered, so that the caption text is in the special text colour (red)
// Required a significant amount of refactoring, as the earlier version was not all
// that hot anyway!
// BEW 3Jul23 needed a deep refactor, to prevent red runon, and to properly handle all 5 possible
// spans; and added typeChangingEndMkr to return to the caller what marker actually caused the type
// to change, whether \f* \x* \fe* \ef* or \ex*. When TRUE is returned, the typeChangingEndMkr will
// tell us which code block to use in the caller to effect the closing off of the span, etc.
// When FALSE is returned, the return typeChangingEndMkr as wxEmptyString - to act as a flag
bool CAdapt_ItDoc::IsTextTypeChangingEndMarker(CSourcePhrase* pPrevSrcPhrase, wxString& typeChangingEndMkr)
{
	CAdapt_ItApp* pApp = &wxGetApp();

	if (gpApp->gCurrentSfmSet == PngOnly || gpApp->gCurrentSfmSet == UsfmAndPng)
	{
		// in the PNG 1998 set, there is no marker for endnotes, and cross references were
		// not included in the standard but inserted manually from a separate file, and so
		// there is no \x nor any endmarker for a cross reference either; there were only
		// two marker synonyms for ending a footnote, \fe or \F
		wxString fnoteEnd1 = _T("\\fe");
		wxString fnoteEnd2 = _T("\\F");
		wxString endmarkers = pPrevSrcPhrase->GetEndMarkers();
		if (endmarkers.IsEmpty())
			return FALSE;
		if (endmarkers.Find(fnoteEnd1) != wxNOT_FOUND)
		{
			return TRUE;
		}
		else if (endmarkers.Find(fnoteEnd2) != wxNOT_FOUND)
		{
			return TRUE;
		}
	}
	else
	{
		wxString fnoteEnd = _T("\\f*");
		wxString endnoteEnd = _T("\\fe*"); // endnote text item, textType = footnote (9), navText = "endnote"
		wxString crossRefEnd = _T("\\x*");
		wxString extfnoteEnd = _T("\\ef*"); // BEW added 21Apr20, "study note text item" like \f* ... \f* span, textType = note (34)
		wxString extcrossRefEnd = _T("\\ex*"); // BEW added 21Apr20 "list of study bible extended cross references" - a span, textType = note (34)
		wxString figEnd = _T("\\fig*"); // BEW 30Sep19, added (the endmarker will be in the 'inline non-binding endmarkers' member variable
		wxString jmpEnd = _T("\\jmp*"); // whm 23Feb2024 added here and below. Ditto below for the figEnd above.
			// & it has a span, but is ignored for span purposes (i.e. m_bIsWithinUnfilteredInlineSpan is FALSE), because
			// nonbinding markers should not alter the textType.
		// whm 23Feb2024 Comment. The above figEnd variable is not used below, nor will the logic there at the last else block
		// catch it, so I've added an if () test for both figEnd and jumpEnd below to return TRUE if found in endmarkers.
		// TODO: 
		// BEW 3July23, so there are 5 spans to be supported, and when in one of these, m_bIsWithinUnfilteredInlineSpan
		// should be TRUE. Do not change the value of m_bIsWithinUnfilteredInlineSpan within this present function, but only
		// in the function's caller IsTextTypeChangingEndMarker() when this function returns TRUE for bool bIsChanger

		wxString endmarkers = pPrevSrcPhrase->GetEndMarkers();
		wxString lastMkr = wxEmptyString; // init  -- BEW deprecate after refactor

		// BEW 9Jan23 add support for endMkr being one of the pApp->m_RedEndMarkers set, 
		// pPrevSrcPhrase is what was passed in, when the pPrevSrcPhrase is the one which
		// ends one of the five spans, it's m_endMarkers member should have the relevant
		// endmarker (even if not final in m_endMarkers)
		int offset = wxNOT_FOUND; // init
		wxString augEndMkr;
		if (endmarkers.IsEmpty())
		{
			// Can't possibly be the pPrevSrcPhrase which ends the span
			return FALSE;
		}
		else
		{
			// BEW 3Jul23 complete refactor here. Handle each of the possible spans, in
			// sequence. If a given span type's endMkr is detected, return that endMkr
			// via the signature, and return TRUE so that bIsChanger in the caller can
			// get the span closed off correctly, without any red runon.

			// First, span internal endmarkers - like \fv* \ft* etc do not close a span,
			// check the pApp->m_EmbeddedIgnoreEndMarkers fast-access string, and if in
			// it, return FALSE. Test inludes also embedded \xo* etc. Then we can check
			// for one of the five known span-ending endMkrs. Embedded endMkrs in a span
			// will not have a following inlineNonbindingEndMkr following, so we can
			// use GetLastEndMarker() and test m_EmbeddedIgnoreEndMarkers using that.
			lastMkr = GetLastEndMarker(endmarkers);
			augEndMkr = lastMkr + _T(' ');
			offset = pApp->m_EmbeddedIgnoreEndMarkers.Find(augEndMkr);
			if (offset >= 0)
			{
				// Control is within a span, and so it's not a pPrevSrcPhrase for closing the span
				return FALSE;
			}
			// Now deal with each possible span. Footnotes are common, so handle first
			offset = wxNOT_FOUND;
			offset = endmarkers.Find(fnoteEnd);
			if (offset >= 0)
			{
				// We found \f* within endmarkers, so this pPrevSrcPhrase finishes the footnote span
				typeChangingEndMkr = fnoteEnd;
				return TRUE;
			}
			offset = endmarkers.Find(crossRefEnd);
			if (offset >= 0)
			{
				// We found \x* within endmarkers, so this pPrevSrcPhrase finishes the cross-ref span
				typeChangingEndMkr = crossRefEnd;
				return TRUE;
			}
			offset = endmarkers.Find(endnoteEnd);
			if (offset >= 0)
			{
				// We found \fe* within endmarkers, so this pPrevSrcPhrase finishes the end note span
				typeChangingEndMkr = endnoteEnd;
				return TRUE;
			}
			offset = endmarkers.Find(extfnoteEnd);
			if (offset >= 0)
			{
				// We found \ef* within endmarkers, so this pPrevSrcPhrase finishes the external study note span
				typeChangingEndMkr = extfnoteEnd;
				return TRUE;
			}
			offset = endmarkers.Find(extcrossRefEnd);
			if (offset >= 0)
			{
				// We found \ex* within endmarkers, so this pPrevSrcPhrase finishes the extended study note span
				typeChangingEndMkr = extcrossRefEnd;
				return TRUE;
			}
			offset = endmarkers.Find(figEnd); // whm 23Feb2024 added to return TRUE for \fig*
			if (offset >= 0)
			{
				// We found \ex* within endmarkers, so this pPrevSrcPhrase finishes the extended study note span
				typeChangingEndMkr = figEnd; // whm 23Feb2024 added to return TRUE for \jmp* too.
				return TRUE;
			}
			offset = endmarkers.Find(jmpEnd);
			if (offset >= 0)
			{
				// We found \ex* within endmarkers, so this pPrevSrcPhrase finishes the extended study note span
				typeChangingEndMkr = jmpEnd;
				return TRUE;
			}
			else
			{
				// If none of those above was in endMarkers, then return an empty marker, and FALSE
				
				return FALSE;
			}
			// Note: embedded end markers of type \+endMkr do not occur in the parse of the spans,
			// because it's in the adaptations that they may occur because there they are designated
			// as 'embedded' and so would require the + in the target text's marker

		} // end of else block for test: if (endmarkers.IsEmpty())

	} // end of else block for test: if (gpApp->gCurrentSfmSet == PngOnly || gpApp->gCurrentSfmSet == UsfmAndPng)

	// If control gets to here, returning FALSE is the right story
	typeChangingEndMkr = wxEmptyString;
	return FALSE;
}

bool CAdapt_ItDoc::IsPunctuation(wxChar* ptr, bool bSource) // bSource is default TRUE
{
	if (bSource)
	{
		if (gpApp->m_strSpacelessSourcePuncts.IsEmpty())
		{
			return FALSE;
		}
		int offset = wxNOT_FOUND;
		offset = gpApp->m_strSpacelessSourcePuncts.Find(*ptr);
		if (offset == wxNOT_FOUND)
		{
			return FALSE;
		}
		return TRUE;
	}
	else
	{
		if (gpApp->m_strSpacelessTargetPuncts.IsEmpty())
		{
			return FALSE;
		}
		int offset = wxNOT_FOUND;
		offset = gpApp->m_strSpacelessTargetPuncts.Find(*ptr);
		if (offset == wxNOT_FOUND)
		{
			return FALSE;
		}
		return TRUE;
	}
}



//////////////////////////////////////////////////////////////////////////////////
/// \return		nothing
/// \param	span		           -> span of characters extracted from the text buffer
///                                   by the FindParseHaltLocation() function; we parse this
/// \param  wordProper             <- the word itself [see a) below]
/// \param  firstFollPuncts	       <- any punctuation characters (out-of-place ones, [see b)
///                                   below])
/// \param	nEndMkrsCount          <- how many inline binding endmarkers there are in the
///                                   span string [this is known to the caller beforehand]
/// \param	inlineBindingEndMarkers <- one of more inline binding endmarkers following the
///                                    wordProper in the span string
/// \param  secondFollPuncts        <- normal "following punctuation" which, if an inline
///                                    binding endmarker is present, should (if the USFM
///                                    markup is correctly done) follow the marker [Note:
///                                    if there is no inline binding endmarker present,
///                                    only firstFollPuncts will have punctuation chars in
///                                    it, and they will be in standard position (of course)]
/// \param  ignoredWhiteSpaces      <- one or more characters of whitespace - because
///                                    Adapt It normalizes most \n and \r characters out of
///                                    the data (using space instead) typically this will just
///                                    be one of more spaces, but we don't rely on that being
///                                    true
/// \param  wordBuildersForPostWordLoc <- For storing one or more wordbuilding characters     // <<-- deprecate, asap BEW 7Nov22, comment out 11874 and easily find where to refactor
///                                    which are at the end of m_follPunct because they were
///                                    formerly punctuation but the user has changed the
///                                    punctuation set and now they are word-building ones
///                                    (the caller will restore them to their word-final
///                                    location)
/// \param  spacelessPuncts          -> the (spaceless) punctuation set being used (usually
///                                    src punctuation, but target punctuation can be passed
///                                    if we want to parse target text for some reason - in
///                                    which case span should contain target text) Note, if
///                                    we want space to be part of the punctuation set, we
///                                    must add it here explicitly in a local string before
///                                    doing anything else
/// \remarks
/// Called from: IsFixedSpaceAhead()
/// FindParseHaltLocation() is used within IsFixedSpaceAhead() (itself within ParseWord()
/// called from TokenizeText()) to extract characters from the input buffer until a
/// halting location is reached - which could be at a ~ fixedspace marker, or if certain
/// other post-word data is encountered. That defines a span of characters which commence
/// with the characters of the word being parsed, but which could end with quite complex
/// possibilities. This ParseSpanBackwards() function parsed from the end of that span,
/// backwards towards its start, extracting each information type which it returns via the
/// signature's parameters. The material being parsed, in storage order (in a RTL script
/// this would be rendered RTL, not LTR of course, but both are stored in LTR order) may
/// be this:
/// a) the word proper (it may contain embedded punctuation which must remain invisible to
/// our parsers, that's why we parse backwards - we expect to reach characters at the end
/// of the word before the backwards parse has a chance to hit an embedded punct character)
/// b) out-of-place (for canonical USFM markup) following punctuation (which may contain
/// embedded space - such as for closing curly quote sequences)
/// c) inline binding endmarker(s) (we allow for more than one - we'll extract them as a
/// sequence and not try to remove any unneeded spaces between them - they normally would
/// have no space between any such pair) -- the FindParseHaltLocation() knows how many such
/// markers it scanned over to get to the halt location, and it returned a count for that,
/// and so we pass in that count value in the nEndMkrsCount param
/// d) more following punctuation (this is in the canonical location if there is an inline
/// binding marker present - punctuation should only follow such an endmarker in good USFM
/// markup, never precede it -- so the caller will coalesce the out of place puncts with
/// the in place puncts, to restore good USFM markup [white space between word and puncts,
/// keep it if present, because some languages require space between word and puncts at
/// either end.
/// e) some white space - this would be ignorable, and we'll return it so that the caller
/// can get it's iterator position set correctly, but the caller will then just ignore any
/// such white space returned
/// BEW created 11Oct10 (actually 27Jan11), to support the improved USFM parser build into
/// doc version 5
/// BEW 2Feb11, added a string to signature for storing punctuation characters that have
/// changed their status to being word-building
/// BEW 24Oct14, no changes needed to support USFM nested markers
//////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItDoc::ParseSpanBackwards(wxString& span, wxString& wordProper,
	wxString& firstFollPuncts, int nEndMkrsCount, wxString& inlineBindingEndMarkers,
	wxString& secondFollPuncts, wxString& ignoredWhiteSpaces,
	wxString& wordBuildersForPostWordLoc, wxString& spacelessPuncts)
{
	// initialize
	wordProper.Empty(); firstFollPuncts.Empty(); inlineBindingEndMarkers.Empty();
	secondFollPuncts.Empty(); ignoredWhiteSpaces.Empty();
	wordBuildersForPostWordLoc.Empty(); // potentially used when parsing the first or
										// second word of a conjoined pair, or when
										// parsing a non-conjoined word
#if defined(_DEBUG) && defined(TOKENIZE_BUG)
	if (aSequNum >= 1367)
	{
		int halt_here = 1;
		wxUnusedVar(halt_here);
	}
#endif

	// reverse the string
	if (span.IsEmpty())
	{
		// BEW 6Jan23 we make limited use of this function, it's for fixed-space support, and 
		// if span is empty, return without showing a message box, and don't sound the bell.
		//wxBell();
		//wxMessageBox(_T("Error: in ParseSpanBackwards(), input string 'span' is empty"));
		return;
	}
	int length = span.Len();
	wxString str = MakeReverse(span);

	// check we have a non-empty punctuation characters set - if it's empty, we can skip
	// parsing for punctuation characters
	bool bPunctSetNonEmpty = TRUE;
	wxString punctSet; punctSet.Empty();
	if (spacelessPuncts.IsEmpty())
	{
		bPunctSetNonEmpty = FALSE;
	}
	else
	{
		// we need space to be in the punctuation set, so add it to a local string and use the
		// local string thereafter; we don't add it if there are no punctuation characters set
		punctSet = spacelessPuncts + _T(' ');
	}

	// get access to the wxString's buffer - then iterate across it, collecting the
	// substrings as we go
	const wxChar* pBuffer = str.GetData();
	wxChar* p = (wxChar*)pBuffer;
	wxChar* pEnd = p + length;
	wxChar* pStartHere = p;
	int punctsLen2 = 0;
	int punctsLen1 = 0;
	int ignoredWhitespaceLen = 0;
	int bindingEndMkrsLen = 0;

	// first get any ignorable whitespace
	ignoredWhitespaceLen = ParseWhiteSpace(p);
	if (ignoredWhitespaceLen > 0)
	{
		wxString ignoredSpaceRev(p, p + ignoredWhitespaceLen);
		ignoredWhiteSpaces = MakeReverse(ignoredSpaceRev); // normal order
		pStartHere = p + ignoredWhitespaceLen; // advance starting location
	}
	// next, any punctuation characters -- we'll put them in secondFollPuncts string
	// whether of not nEndMkrsCount is zero (because this is where we'd expect good USFM
	// markup to have them); skip this step if there are no punctuation characters defined
	p = pStartHere;
	wxString puncts; puncts.Empty();
	if (bPunctSetNonEmpty)
	{
		// allow \n and \r to be parsed over too (ie. whitespace, not just space),
		// space character is already in punctSet, so no need to add an explicit test;
		// Note, the loop will also end if it encounters what used to be a word-building
		// character which, due to user changing punctuation set, it became a punctuation
		// character and so got pulled off the word's end and stored in m_follPunct, but
		// subsequent to that the user again changed the punctuation set making it back
		// into a word building character - so that it is still in m_follPunct at its end
		// (it may be the only character in m_follPunct), and so we will have to test for
		// this and store it and any like it in a special string,
		// wordBuildersForPostWordLoc, to return such characters to the caller for
		// placement there back at the end of the parsed word
		while (p < pEnd)
		{
			if (punctSet.Find(*p) != wxNOT_FOUND || *p == _T('\n') || *p == _T('\r'))
				puncts += *p++;
			else
				break;
		}
		// add the puncts to secondFollPuncts, if any were found -- note, there could be a
		// space (it's not necessarily bad USFM markup, some languages require it) at the
		// end of the (reversed)substring -- we'll collect it & retain it if present
		if (!puncts.IsEmpty())
		{
			secondFollPuncts = MakeReverse(puncts); // normal order
			punctsLen2 = secondFollPuncts.Len();
			puncts.Empty(); // in case we reuse it for a subsequent inline binding endmarker
			pStartHere = pStartHere + punctsLen2; // advance starting location
		}
	}
	// now, however many (reversed) inline binding endmarkers were found to be present --
	// since any such are reversed, and because there are no inline markers in the PNG
	// 1998 SFM marker set, we know that asterisk * must be the first character
	// encountered if a marker is present...
	// since we parse backwards we could use the version of ParseMarker() that is in
	// helpers.cpp, in a loop, because it checks for initial * and so can find reversed
	// USFM endmarkers, however the easiest way is to assume that the nEndMkrsCount value
	// passed in is correct, and just use FindFromPos() in a loop - searching for a
	// backslash on each iteration. Until the latter proves to be non-robust, that will
	// suffice
	// Note: we know that the marker or markers to be parsed next are all inline
	// binding endmarkers - that was verified in the prior call of
	// FindParseHaltLocation() which did the requisite test and set nEndMkrsCount
	p = pStartHere;

	// it's possible that changed punctuation resulted in a word-final character moving to
	// be in m_follPunct; this is benign except when there was also an inline binding
	// endmarker present - because Adapt It will restore the character to after the inline
	// marker, thinking it is to remain as punctuation, and if it is now no longer in the
	// punctuation set being used, then it needs to be stored for the caller to process it,
	// and the parsing point set to follow it before further parsing takes place. Test and
	// do that now. There could be more than one.
	wxString nowWordBuilding; nowWordBuilding.Empty();
	//bool bStoredSome = FALSE; // set but unused
	if (nEndMkrsCount > 0 && *p != _T('*') && punctSet.Find(*p) == wxNOT_FOUND)
	{
		while (*p != _T('*') && punctSet.Find(*p) == wxNOT_FOUND)
		{
			//bStoredSome = TRUE;
			nowWordBuilding += *p;
			p++;
			pStartHere = p;
		}
	}
	// any additional puncts which are between where p points and the * of the reversed
	// marker have to be taken to the end of the word - this will "bury" any such as
	// word-internal punctuation -- this is the cost we pay for refusing to generate a
	// pair of CSourcePhrase instances from a single instance when the user changes
	// punctuation settings - otherwise, we get potential messes, and this 'solution' is
	// the best compromise.
	// To generate data to illustrate this, a sequence like \k extreme\k* is useful,
	// make m and e become punctuation characters, then unmake e as a punctuation
	// (returning it to word-building status) -- when the reverse parse comes to the eme
	// 3-char sequence, the first e goes to the end of the word, but m continuing as
	// punctuation blocks the loop above, leaving 2-char sequence, me, before the * of the
	// reversed \k* endmarker. If we don't also move that "me" sequence to the end of the
	// word, the wxASSERT below would trip, and that "m" character would cause the
	// generation, of a second CSourcePhrase, and a rather unhelpful mess at that point in
	// the document. We have to get p pointing at * before we continue the parse.
	if (!nowWordBuilding.IsEmpty() && *p != _T('*'))
	{
		// grab and append the rest
		while (*p != _T('*'))
		{
			nowWordBuilding += *p;
			p++;
		}
	}
	if (!nowWordBuilding.IsEmpty())
	{
		wordBuildersForPostWordLoc = MakeReverse(nowWordBuilding); // return these to
				// IsFixedSpaceAhead() which in turn will return these to ParseWord() where,
				// if the string is not empty, they'll be appended to the word; ptr will
				// get updated in IsFixedSpaceAhead() I think, as probably will the len
				// value, if this function was called from there, else in
				// FinishOffConjoinedWordsParse() if called from the latter
	}
	// p should now be pointing at an * if nEndMkrsCount is not zero
#ifdef _DEBUG
	if (nEndMkrsCount > 0)
	{
		wxASSERT(*p == _T('*'));
	}
#endif
	if (nEndMkrsCount > 0)
	{
		int lastPos = 0;
		wxString aReversedSpan(p, pEnd);
		int index;
		for (index = 0; index < nEndMkrsCount; index++)
		{
			// use the helpers.cpp function: int FindFromPos(const wxString& inputStr,
			// const wxString& subStr, int startAtPos), it allows us to find several
			// instances of a substring within the string
			lastPos = FindFromPos(aReversedSpan, _T("\\"), lastPos);
			lastPos++; // include the backslash marker
		}
		wxString theBindingEndMarkers(p, p + lastPos);
		bindingEndMkrsLen = theBindingEndMarkers.Len();
		inlineBindingEndMarkers = MakeReverse(theBindingEndMarkers); // normal order
		pStartHere = p + bindingEndMkrsLen; // advance starting location
	}
	// next, any pre-marker punctuation characters in the unreversed string -- we'll put
	// them in firstFollPuncts string whether of not nEndMkrsCount is zero (because if
	// there was no inline binding endmarker just parsed, we'd have already collected all
	// the punctuation characters which follow the word; so any collected now must not have
	// been collected because of an intervening inline binding endmarker; but skip this
	// step if there are no punctuation characters defined
	p = pStartHere;
	if (bPunctSetNonEmpty)
	{
		// allow \n and \r to be parsed over too (ie. whitespace, not just space),
		// space character is already in punctSet, so no need to add an explicit test
		while (p < pEnd)
		{
			if (punctSet.Find(*p) != wxNOT_FOUND || *p == _T('\n') || *p == _T('\r'))
				puncts += *p++;
			else
				break;
		}
		// add the puncts to firstFollPuncts, if any were found -- note, there could be a
		// space (it's not necessarily bad USFM markup, some languages require it) at the
		// end of the (reversed)substring -- we'll collect it & retain it if present
		if (!puncts.IsEmpty())
		{
			firstFollPuncts = MakeReverse(puncts); // normal order
			punctsLen1 = firstFollPuncts.Len();
			puncts.Empty();
			pStartHere = pStartHere + punctsLen1; // advance starting location
		}
	}


	// finally, what remains is the word proper (it could have embedded punctuation
	// 'invisible' to our parsing algorithms - it's invisible provided it has a
	// non-punctuation character both before and after it)
	p = pStartHere;
	wxString theReversedWord(p, pEnd);
	wordProper = MakeReverse(theReversedWord);

#ifdef _DEBUG
	int wordLen = wordProper.Len();
	int storedRevertedPunctsLen = wordBuildersForPostWordLoc.Len();
	wxASSERT(bindingEndMkrsLen + wordLen + punctsLen1 + punctsLen2 +
		ignoredWhitespaceLen + storedRevertedPunctsLen == length);
#endif
}


//////////////////////////////////////////////////////////////////////////////////
/// \return		TRUE if ~ conjoins the word and the next, FALSE if there is no such
///             conjoining
/// \param		ptr			    <-> ref to the pointer to the next character to be parsed
///                                (it will be the first character of word about to be
///                                parsed)
/// \param      pEnd            -> pointer to first char past the end of the buffer
///                                (to ensure we don't overrun buffer end)
/// \param		pWdStart	    <- ptr value when function is just entered
/// \param	    pWdEnd          <- points at the first character past the last character
///                                of the first word parsed over
/// \param	    punctBefore     <- any punctuation (it can have space within, provided
///                                that it does not end with a space) which follows
///                                the word (*** this should always be empty, because the
///                                caller has already parsed over initial punctuation, and
///                                so this member never gets filled) -- remove later on ***
/// \param      endMkr          <- any inline binding endmarker, if present
/// \param      spacelessPuncts -> the (spaceless) punctuation set to be used herein
/// \remarks
/// Called from: ParseWord()
/// ******************************************************** NOTE *********************
/// NOTE: (this is now different, see next paragraph!) our parsing algorithms for scanning
/// words which are conjoined by ~ assumes that there is no punctuation within the word
/// proper - so xyz:abc would NOT be parsed as a single word; our general parser,
/// ParseWord() DOES handle this type of thing as a single word, but for word1~word2 type
/// of conjoining, word1 and word2 must have no internal punctuation. For the moment, we
/// feel this is a satisfactory simplification, because use of ~ in actual data is rare (no
/// known instances in a decade of Adapt It use), and so too is the use of punctuation as a
/// word-building character.
///
/// BEW 25Jan11: ***BIGGER NOTE**** I've left the above NOTE here, at the time it seemed a
/// reasonable simplification. But user's dynamic changes to punctuation settings proved
/// it be it's archilles heel. The early code used ScanExcluding() to parse over the word
/// proper, and if there is embedded punctuation (as there might be if a file is loaded
/// while inadequate punctuation settings were in effect), then the internal punctuation
/// can become visible to such a scan - and cause a disastrous result. The correct way to
/// handle scanning a word is to honour the fact that there may be internal punctuation
/// which must remain "unseen" by any scanning process - the way to do that is to scan
/// inward over punctuation from the start of the word, until a non-punct is reached, and
/// for scanning at the end of the word, reverse the word and scan inwards in the reversed
/// string until a non-punct is reached, and then undo the reversals. So to do these scans,
/// ScanIncluding() is to be used from either end, WE MUST NOT SCAN ACROSS THE WORD ITSELF
/// LOOKING FOR PUNCTUATION AT THE OTHER END OF IT. Instead, scan in from either end. That
/// gives us the problem of determining where the "other end" is before we can do the
/// reversal of what lies between and then do the scan in. If there is a ~ fixed space, we
/// can use that as defining the other end. But if there is no fixed space (~) present, we
/// have to define the other end as whitespace or a backslash (ie. ignore punctuation for
/// determining where the other end is). In support of these observations the code will be
/// re-written below.
/// ******************************************************** END NOTE *****************
/// When the scanning ptr points at a word, we don't know whether the word will be a
/// singleton, or the first word of a pair conjoined by USFM ~ fixed space marker. We
/// support punctuation and inline binding markers before or after ~ too, so these
/// substrings may be present. The caller needs to know if it has to handle the word about
/// to be parsed as a conjoined pair, or not. To find this out, we first try to find if ~
/// is present. If it is, that's the dividing point between a conjoined pair (and we return
/// TRUE eventually). If there is no such character (we return FALSE eventually), it's not
/// a conjoined pair and the end of the word will be determined by scanning back from later
/// whitespace or a later marker. A ] character also is considered as an end point for the
/// word. We pass in references to the start and end locations for the word, etc, so that
/// the useful info we learn as we parse does not have to be reparsed in the caller. If
/// TRUE is returned, another function in the caller will be called in order to complete
/// the delimitation of the conjoined word pair, as far as the final character of the
/// second word. The ptr value returned must be, if ~ was detected, following the character
/// ~. If FALSE is returned, we've a normal word parsing, and the caller will only use the
/// pWdEnd value - resetting the caller's ptr variable to that location, since the caller
/// can successfully parse on from that point (this would mean throwing information away
/// about following punctuation, but that is a small matter because the latter is low
/// frequency in the text, and the caller will reparse that information quickly anyway).
/// BEW created 11Oct10, to support the improved USFM parser build into doc version 5
/// BEW 24Oct14 no changes needed for support of USFM nested markers
//////////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItDoc::IsFixedSpaceAhead(wxChar*& ptr, wxChar* pEnd, wxChar*& pWdStart,
	wxChar*& pWdEnd, wxString& punctBefore, wxString& endMkr,
	wxString& wordBuildersForPostWordLoc, wxString& spacelessPuncts,
	bool bTokenizingTargetText)
{
	wxUnusedVar(bTokenizingTargetText); // avoid compiler warning unreferenced formal parameter
	wxUnusedVar(spacelessPuncts); // avoid compiler warning unreferenced formal parameter
	wxUnusedVar(wordBuildersForPostWordLoc); // avoid compiler warning unreferenced formal parameter
	wxUnusedVar(endMkr); // avoid compiler warning unreferenced formal parameter
	wxUnusedVar(punctBefore); // avoid compiler warning unreferenced formal parameter
	wxUnusedVar(pWdEnd); // avoid compiler warning unreferenced formal parameter
	wxUnusedVar(pWdStart); // avoid compiler warning unreferenced formal parameter
	wxUnusedVar(pEnd); // avoid compiler warning unreferenced formal parameter
	wxUnusedVar(ptr); // avoid compiler warning unreferenced formal parameter

	/* BEW 17Jul23 we no longer call this
	wxChar* pSave = ptr; // BEW 30Sep22, because despite what the comment just
			// below says, I didn't scan with p, but fiddled with ptr. I want 
			// pSave so that if no ~ is found, I can return ptr as the pSave value
	wxChar* p = ptr; // scan with p, so that we can return a ptr value which is at
					 // the place we want the caller to pick up from (and that will
					 // be determined by what we find herein)
	wxString FixedSpace = _T("~");
	punctBefore.Empty();
	endMkr.Empty();
	pWdStart = ptr;

	// Find where ~ is, if present; we can't just call .Find() in the string defined by
	// ptr and pEnd, because it could contain thousands of words and a ~ may be many
	// hundreds of words ahead. Instead, we must scan ahead, parsing over any ignorable
	// white space, until we come to either ~, or non-ignorable whitespace, or a closing
	// bracket (]) - halting immediately before any such character. We need a function for
	// this and it can return, via its signature, what the specific halt condition was. If
	// we halt due to ] or whitespace, then we infer that we do not have conjoining of the
	// word being defined from the parse. We also may parse over an inline binding
	// endmarker, (perhaps more than one), these don't halt parsing - but we'll return the
	// info in the signature, along with a count of how many such markers we parsed over.
	wxChar* pHaltLoc = NULL;
	bool bFixedSpaceIsAhead = FALSE;
	bool bFoundInlineBindingEndMarker = FALSE;
	bool bFoundFixedSpaceMarker = FALSE;
	bool bFoundClosingBracket = FALSE;
	bool bFoundHaltingWhitespace = FALSE;
	int nFixedSpaceOffset = -1;
	int nEndMarkerCount = 0;
	pHaltLoc = FindParseHaltLocation(p, pEnd, &bFoundInlineBindingEndMarker,
		&bFoundFixedSpaceMarker, &bFoundClosingBracket,
		&bFoundHaltingWhitespace, nFixedSpaceOffset, nEndMarkerCount,
		bTokenizingTargetText);
	bFixedSpaceIsAhead = bFoundFixedSpaceMarker;
	// BEW 11Feb14, test for ~ found, but it is followed by whitespace or buffer end or
	// closing ] character.
	// BEW 3Oct22, this next test and it's TRUE block should not be here. We advance over ~ just before
	// the else block below. Until then don't advance, so that ~ does not get included in the aSpan calculation
	//if (bFixedSpaceIsAhead && (bFoundFixedSpaceMarker || bFoundHaltingWhitespace || bFoundClosingBracket))
	//{
	//	// pHaltLoc will have been returned as pointing at the ~ character, so advance
	//	// pHaltLoc to point past it, and then reset bFixedSpaceIsAhead to FALSE
	//	pHaltLoc += 1;
	//	bFixedSpaceIsAhead = FALSE;
	//}
	wxString aSpan(ptr, pHaltLoc); // this could be up to ~, or a [ or ], or a whitespace

	// we know whether or not we found a USFM fixedspace marker, what we do next depends
	// on whether we did or not
	wxString wordProper; // emptied at start of ParseSpanBackwards() call below
	wxString firstFollPuncts; // ditto
	wxString inlineBindingEndMarkers; // ditto
	wxString secondFollPuncts; // ditto
	wxString ignoredWhiteSpaces; // ditto
	// if ptr is already at pEnd (perhaps punctuation changes made a short word into all
	// puncts), then no point in calling ParseSpanBackwards() and generating a message
	// about an empty span, instead code to jump the call
	if (!aSpan.IsEmpty())
	{
		ParseSpanBackwards(aSpan, wordProper, firstFollPuncts, nEndMarkerCount,
			inlineBindingEndMarkers, secondFollPuncts,
			ignoredWhiteSpaces, wordBuildersForPostWordLoc,
			spacelessPuncts);
	}
	else
	{
		wordProper.Empty();
		firstFollPuncts.Empty();
		nEndMarkerCount = 0;
		secondFollPuncts.Empty();
		ignoredWhiteSpaces.Empty();
		wordBuildersForPostWordLoc.Empty();
		inlineBindingEndMarkers.Empty();
		pWdEnd = NULL;
	}
	// now use the info extracted to set the IsFixedSpaceAhead() param values ready
	// for returning to ParseWord()
	if (bFixedSpaceIsAhead)
	{
		// now use the info extracted to set the IsFixedSpaceAhead() param values ready
		// for returning to ParseWord()

		// first, pWdEnd -- this will be the length of wordProper after pWdStart
		pWdEnd = pWdStart + wordProper.Len();

		// second, punctuation which follows the word but precedes the fixed space; if
		// there is correct markup and there is an inline binding endmarker, it would all be
		// after that marker (or markers, if there is more than one here), but user markup
		// errors might have some or all before such a marker - if so, we move the
		// before-marker puncts to be immediately after the endmarker(s) and append
		// whatever is already after the endmarkers. We won't remove any initial whitespace
		// before the puncts, as that would be inappropriate -- some languages'
		// punctuation conventions are to have a space between the word and preceding or
		// following punctuation - so if there is space there, we must retain it
		if (nEndMarkerCount == 0)
		{
			// all the punctuation is together in secondFollPuncts, if there is any at all
			if (secondFollPuncts.IsEmpty())
			{
				punctBefore.Empty();
			}
			else
			{
				punctBefore = secondFollPuncts;
			}
		}
		else
		{
			// handle any out-of-place puncts (will be in firstFollPuncts if there is any)
			// first, and then append any which follows the inline binding endmarker() to it
			if (firstFollPuncts.IsEmpty())
			{
				punctBefore.Empty();
			}
			else
			{
				punctBefore = firstFollPuncts;
			}
			if (!secondFollPuncts.IsEmpty())
			{
				punctBefore += secondFollPuncts;
			}
		}

		// third, the contents for endMkr; there could be space(s) in the string, and
		// they should be removed as they contribute nothing except to make things more
		// complicated than is necessary for rendering the markup for publishing, so we
		// remove them
		endMkr.Empty();
		if (!inlineBindingEndMarkers.IsEmpty())
		{
			while (inlineBindingEndMarkers.Find(_T(' ')) != wxNOT_FOUND)
			{
				// remove all spaces, leaving only the one or more inline binding endmarkers
				inlineBindingEndMarkers.Remove(inlineBindingEndMarkers.Find(_T(' ')), 1);
			}
			endMkr = inlineBindingEndMarkers;
		}

		// last, since ~ is not in aSpan but immediately after it, set ptr to point past
		// the ~ fixedspace character
		ptr = ptr + nFixedSpaceOffset + 1;
	} // end of TRUE block for test: if (bFixedSpaceIsAhead)
	else
	{
		// BEW 30Sep22, no ~ means no ptr advancement, and all the above wxStrings emptied
		// at lines 12001-7. So if ptr is not to be advance, set ptr to pSave which I added
		// above. And pWdEnd should be set to NULL.
		ptr = pSave;
		pWdEnd = NULL;
		return FALSE; // tell the caller that no fixedspace was encountered
	} // end of else block for test: if (bFixedSpaceIsAhead)
	*/
	return FALSE; // was TRUE;
}

//////////////////////////////////////////////////////////////////////////////////
/// \return		                   nothing
/// \param		ptr			   <-> ref to the pointer to the next character to be parsed
///                                (it will be the first character after ~ character pair)
/// \param      pEnd            -> pointer to first char past the end of the buffer
///                                (to ensure we don't overrun buffer end)
/// \param		pWord2Start	    <- points at where 2nd of conjoined words starts (actual word)
/// \param	    pWord2End       <- points at the first character past the last character
///                                of the second of the conjoined words parsed over
/// \param	    punctAfter      <- any punctuation (it can have space within, provided
///                                that it does not end with a space) which follows ~ and
///                                precedes the second (conjoined) word
/// \param      bindingMkr      <- any inline binding beginmarker, if present
/// \remarks
/// Called from: ParseWord()
/// ******************************************************** NOTE *********************
/// NOTE: our parsing algorithms for scanning words which are conjoined by ~ assumes that
/// there is no punctuation within the word proper - so xyz:abc would NOT be parsed as a
/// single word; our general parser, ParseWord() DOES handle this type of thing as a single
/// word, but for word1~word2 type of conjoining, word1 and word2 must have no internal
/// punctuation. For the moment, we feel this is a satisfactory simplification, because
/// use of ~ in actual data is rare (no known instances in a decade of Adapt It use), and
/// so too is the use of punctuation as a word-building character.
/// ******************************************************** END NOTE *****************
/// On input, we know we have a USFM ~ marker conjoining two words (the words may have
/// punctuation before or after and inline binding marker and endmarker wrapping too), and
/// this function does the parsing from the character following ~ to the end of the
/// second word proper - but it does NOT attempt to parse into any following punctuation
/// or binding endmarker which may follow the second word - the caller will do that. When
/// ready to return, ptr must be set to point at whatever character following the end of
/// the second word. If the completion of the parse encounters any or all of, in the
/// following order, preceding punctuation before the second word (it may legally contain
/// space, eg. between nested quote symbols), or an inline binding beginmarker, these are
/// stored in the relevant strings in the signature to return their values to the caller.
/// The caller then has to use the returned ptr value to work out how many characters were
/// parsed over, update the callers len (length) value, and then parse on over anything
/// which may lie beyond the end of the second word (such as final punctuation, etc).
/// BEW created 11Oct10, to support the improved USFM parser build into doc version 5
/// BEW refactored 28Jan11, to parse 'inwards' from the ends, rather than across the word
/// BEW 2Feb11, added 4 more strings to signature, to return punctuation pulled off ends
/// of the word due to word-building status becoming punctuation status (2 of them), or to
/// return word-building characters to be added to ends of the word due to punctuation
/// status becoming changed to word-building status (because user used Preferences
/// Punctuation tab to dynamically change the punctuation settings)
/// BEW 24Oct14, no changes for support of USFM nested markers. (But bTokenizingTargetText
/// needed to be added to signature because the call FindMarseHaltLocation() had a hard-
/// coded tgt punctuation string within it, which needed to be set to be src or target
/// depending on what was passed to TokenizeText() - this produced a small cascade of
/// signature changes in a few functions, since FindMarseHaltLocation() as used in
/// various places - but at least now TokenizeText() uses either src or tgt puncts
/// throughout, and consistently one or the other, depending on bTokenizingTargetText
//////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItDoc::FinishOffConjoinedWordsParse(wxChar*& ptr, wxChar* pEnd, wxChar*& pWord2Start,
	wxChar*& pWord2End, wxString& punctAfter, wxString& bindingMkr,
	wxString& newPunctFrom2ndPreWordLoc, wxString& newPunctFrom2ndPostWordLoc,
	wxString& wordBuildersFor2ndPreWordLoc, wxString& wordBuildersFor2ndPostWordLoc,
	wxString& spacelessPuncts, bool bTokenizingTargetText)
{
	wxUnusedVar(bTokenizingTargetText); // avoid compiler warning unreferenced formal parameter
	wxUnusedVar(spacelessPuncts); // avoid compiler warning unreferenced formal parameter
	wxUnusedVar(wordBuildersFor2ndPostWordLoc); // avoid compiler warning unreferenced formal parameter
	wxUnusedVar(wordBuildersFor2ndPreWordLoc); // avoid compiler warning unreferenced formal parameter
	wxUnusedVar(newPunctFrom2ndPostWordLoc); // avoid compiler warning unreferenced formal parameter
	wxUnusedVar(newPunctFrom2ndPreWordLoc); // avoid compiler warning unreferenced formal parameter
	wxUnusedVar(bindingMkr); // avoid compiler warning unreferenced formal parameter
	wxUnusedVar(punctAfter); // avoid compiler warning unreferenced formal parameter
	wxUnusedVar(pWord2End); // avoid compiler warning unreferenced formal parameter
	wxUnusedVar(pWord2Start); // avoid compiler warning unreferenced formal parameter
	wxUnusedVar(pEnd); // avoid compiler warning unreferenced formal parameter
	wxUnusedVar(ptr); // avoid compiler warning unreferenced formal parameter

	/* BEW 17Jul23 we not longer support the legacy way of fixed space processing
	// Note: the punctAfter param is "punctuation after the ~ fixedspace, which, since
	// this function is only used to parse the second of two conjoined words, is also the
	// preceding punctuation for the second of the two words (it is NOT the *'punctuation
	// after the second word' - the latter will be determined in the caller, ParseWord())
	wxChar* p = ptr;
	punctAfter.Empty();
	bindingMkr.Empty();
	pWord2Start = NULL;
	pWord2End = NULL;
	int length = 0;
	// this two for punctuation returning to word-building status
	wordBuildersFor2ndPreWordLoc.Empty();
	wordBuildersFor2ndPostWordLoc.Empty();
	// this two for word-building characters becoming punctuation characters
	newPunctFrom2ndPreWordLoc.Empty();
	newPunctFrom2ndPostWordLoc.Empty();
	// the FinishOffConjoinedWordsParse() needs all 4, of these, but for the first word or
	// a conjoined pair, or the only word when parsing a word not conjoined, the
	// equivalent tweaks and storage is scattered over several functions - in ParseWord(),
	// in IsFixedSpaceAhead() and in ParseSpanBackwards().

	// we need a punctuation string which includes space
	wxString punctuation = spacelessPuncts + _T(' ');
	if (p < pEnd)
	{
		// check out the possibility of word-initial punctuation preceding word2's
		// characters, and beware there may be detached opening quote, and so we can't
		// assume there won't be a space within the punctuation string (if there is a
		// punctuation string, that is)
		punctAfter = SpanIncluding(p, pEnd, punctuation);
		length = punctAfter.Len();
		if (length > 0)
		{
			p = p + length;
		}
		// we've stopped because either we have come to a beginmarker, or to the
		// second word of the conjoined pair, or to the end of the buffer, or to a former
		// punctuation character which has just become a word-building one, and so is not
		// in the punctuation set
		if (p >= pEnd)
		{
			// this would be totally unexpected, all we can do is set the pointers to the
			// end and start of the second word to point where pEnd points, and return
			pWord2Start = p;
			pWord2End = p;
			ptr = p;
			return;
		}
		else
		{
			// there's more, so check out what is next - could be the start of the word,
			// or an inline binding beginmarker (could even be a sequence of these)
			// BEW 28Jan11, changed to using IsMarker() because it tests for \ followed by
			// a single alphabetic character, and so we don't have \ followed by space
			// giving a false positive
			// BEW 3Feb11, *p might be a punctuation character made into a word-building
			// one by the user just having altered the punctuation settings -- so if
			// inline marker(s) follow, such a character will need to end up at the start of the
			// word -- that is, jump the marker. We have a function for handling this
			// check etc.
			wordBuildersFor2ndPreWordLoc = SquirrelAwayMovedFormerPuncts(p, pEnd, spacelessPuncts);
			if (!wordBuildersFor2ndPreWordLoc.IsEmpty())
			{
				// advance pointer p, to point beyond the one or more puncts which are now
				// word-building and needing to be moved later on to start of the word proper
				size_t numChars = wordBuildersFor2ndPreWordLoc.Len();
				p += numChars;
			}

			// when we get here, p must be pointing at the marker if it is present, or at
			// the word proper if no marker is present
			bindingMkr.Empty();
			while (IsMarker(p))
			{
				wxString aBindingMkr = GetWholeMarker(p);
				length = aBindingMkr.Len();
				wxString mkrPlusSpace = aBindingMkr + _T(' ');
				if (gpApp->m_inlineBindingMarkers.Find(mkrPlusSpace) != wxNOT_FOUND)
				{
					// it is a beginmarker of the inline binding type (what USFM calls
					// 'Special Markers'), and so we need to deal with it - we store these
					// with their trailing space
					bindingMkr += mkrPlusSpace; // caller will store returned string(s) in
												// m_inlineBindingMarkers member
					p += length;
					length = ParseWhiteSpace(p); // get past the whitespace after the marker
												 // (it might not be a single character)
					p += length;
				}
				else
				{
					// the marker is not the expected inline binding beginmarker, this
					// constitutes a USFM markup error. We can't process it as if it were
					// a binding marker, because it may be a marker preceding the next
					// word in the data and not conjoined, so we'll just return what we have
					// and put ptr back preceding any punctuation we may have found -- and
					// since we've not changed ptr yet, all we need do is return
					return;
				}
			} // end of loop for test: while (IsMarker(p))

			// We are potentially at the start of word2; the user may have changed
			// punctuation settings in such a way that one or more characters at the start
			// of the word have just become punctuation characters - we have to store these
			// in a string to return them to the caller (where they will be added to the
			// m_precPunct member of secondWord after any other puncts already in there) --
			// note that doing this means that if the source text is reconstituted, any
			// such puncts would move to being immediately preceding an inline binding
			// marker(s) if one or more of the latter precede the word). We must check
			// here for any such and remove them to the passed in storage string, and
			// advance our parsing pointer, p, to point beyond them ready to setting
			// pWord2Start further below.
			while (spacelessPuncts.Find(*p) != wxNOT_FOUND)
			{
				// *p is a punctuation character now, so store it and advance p
				newPunctFrom2ndPreWordLoc += *p++;
			}

			// we are at the start of word2, we can't scan over it using SpanExcluding()
			// because if there is embedded punctuation, it would foul the integrity of
			// the parse; so use FindParseHaltLocation() and ParseSpanBackwards() as the
			// IsFixedSpaceAhead() function does - this combination adhere's to our
			// word-parsing protocol, which is to parse inwards from either end, never
			// across it
			pWord2Start = p;
			ptr = p;

			// Find a halting location which is beyond the currently to-be-parsed word, but
			// not past the start of information which belongs to the following of what
			// could be thousands of words. Instead, we must scan ahead, parsing over any
			// ignorable white space, until we come to either ~, or non-ignorable
			// whitespace, or a closing bracket (]) - halting immediately before any such
			// character. We need a function for this and it can return, via its signature,
			// what the specific halt condition was. We also may parse over an inline
			// binding endmarker, (perhaps more than one), these don't halt parsing - but
			// we'll return the info in the signature, along with a count of how many such
			// markers we parsed over. We don't use much of what we find, just the
			// wordProper, because we let the caller handle everything to be parsed from
			// the end of the wordProper onwards
			wxChar* pHaltLoc = NULL;
			bool bFoundInlineBindingEndMarker = FALSE;
			bool bFoundFixedSpaceMarker = FALSE;
			bool bFoundClosingBracket = FALSE;
			bool bFoundHaltingWhitespace = FALSE;
			int nFixedSpaceOffset = -1;
			int nEndMarkerCount = 0;
			pHaltLoc = FindParseHaltLocation(p, pEnd, &bFoundInlineBindingEndMarker,
				&bFoundFixedSpaceMarker, &bFoundClosingBracket,
				&bFoundHaltingWhitespace, nFixedSpaceOffset, nEndMarkerCount,
				bTokenizingTargetText);
			wxString aSpan(ptr, pHaltLoc); // this could be up to a [ or ], or a
										  // whitespace or a beginmarker
			// now parse backwards to extract the span's info
			wxString wordProper; // emptied at start of ParseSpanBackwards() call below
			wxString firstFollPuncts; // ditto
			wxString inlineBindingEndMarkers; // ditto
			wxString secondFollPuncts; // ditto
			wxString ignoredWhiteSpaces; // ditto
			ParseSpanBackwards(aSpan, wordProper, firstFollPuncts, nEndMarkerCount,
				inlineBindingEndMarkers, secondFollPuncts, ignoredWhiteSpaces,
				wordBuildersFor2ndPostWordLoc, spacelessPuncts);
			// now use the info extracted to set the FinishedOffConjoinedWordsParse() param
			// values ready for returning to ParseWord() -- all we want is wordProper --
			// note, if there is one or more now-word-building-characters in the
			// wordBuildersFor2ndPostWordLoc string, they are passed back to the caller
			// via the signature and will be appended to secondWord there, and the
			// caller's ptr value incremented by however many there are (we don't do it
			// here because it would return a wrong location for ptr and pWord2End to the
			// caller)
			newPunctFrom2ndPostWordLoc = firstFollPuncts; // new puncts pulled of end of word
			length = wordProper.Len();
			pWord2End = ptr + length;
			ptr = pWord2End;
		} // end of else block for test: if (p >= pEnd)
	} // end of TRUE block for test: if (p < pEnd)
	*/
}

///////////////////////////////////////////////////////////////////////////////
/// \return		the number of characters parsed over
/// \param  ptr            -> pointer to the next wxChar to be parsed (it should
///                           point at the starting character of the word proper,
///                           and after preceding punctuation for that word (if any)
/// \param  pEnd		   -> a pointer to the first character beyond the input
///                           buffer's end (could be tens of kB ahead of ptr)
///                           marker, or an inline binding marker)
/// \param	pbFoundInlineBindingEndMarker   <- ptr to boolean, its name explains it; there
///                                    might be two or more in sequence, so a count of how
///                                    many of these there are is return in nEndMarkerCount
/// \param	pbFoundInlineNonbindingEndMarker <- ptr to boolean, its name explains it; these
///                                    are rare and only one will be at any one CSourcePhrase
/// \param	pbFoundFixedSpaceMarker <- ptr to boolean, TRUE if ~ encountered at or before
///                                    the halting location (~ IS the halting location
///                                    provided it precedes non-ignorable whitespace)
/// \param	pbFoundBracket          <- ptr to boolean, TRUE if ] or [ encountered (either
///                                    halts the scan, if it precedes ~ or whitespace)
/// \param  pbFoundHaltingWhitespace <- ptr to bool, TRUE if space or \n or \r encountered
///                                    and that whitespace is not ignorable (see comments
///                                    below for a definition of what is ignorable whitespace)
/// \remarks
/// Called from: the Doc's IsFixedSpaceAhead(), from TokenizeText(), from
/// FinishOffConjoinedWordsParse(), and from ParseWordInwardsFromEnd()
/// The IsFixedSpaceAhead() function, which is mission critical for delimiting a parsed
/// word or conjoined pair of words in the ParseWord() function, requires a smart subparser
/// which looks ahead for a fixed space marker (~), but only looks ahead a certain distance
/// - ensuring the parsing pointer does not encroach into material which belongs to any of
/// the words which follow. This is that subparser. In doing it's job, it may parse over
/// whitespace which is ignorable, and possibly one or more inline binding endmarkers.
/// The halting conditions are:
/// a) finding non-ignorable whitespace
/// b) finding ~ (the fixed space marker of USFM)
/// c) finding a closing bracket, ] or an opening bracket [
/// d) finding a begin-marker, or an endmarker which is not an inline binding one
/// We return, via the signature, information about the data types parsed over, to help
/// the caller to do it's more definitive parsing and data storage more easily.
/// The following conditions define ignorable whitespace for the scanning process:
/// i)  immediately after an inline binding endmarker - provided what follows the whitespace
///     is either ] or ~ or another inline binding endmarker or punctuation which is a
///     closing quote or closing doublequote
/// ii) between non-punctuation and an immediately following inline binding endmarker
/// iii)after punctuation, provided a closing quote or closing doublequote follows
/// No punctuation set is passed in, because this function deliberately does not
/// distinguish between punctuation and word-building characters -- halt location is
/// determined solely by ~ or [ or ] or certain SF markers.
/// BEW 11Oct10, (actually created 25Jan11)
/// BEW 4Jan2012, altered FindParseHaltLocation() so that it does not halt at a ] (closing
/// bracket) when ] is not included in the list of punctuation characters. (Data which
/// revealed the problem: adapt a word with the adaptation "voice [lit:neck]"  -- the ParseWord()
/// function hung at the [ character.)
/// BEW 24Oct14, no changes needed to support USFM nested markers (internally uses
/// marker fast access strings, and the inlineBinding and nonBinding ones have
/// nested markers within them explicitly as of 24Oct14)
/// BEW 24Oct14 no changes needed for support of USFM nested markers
//////////////////////////////////////////////////////////////////////////////////
wxChar* CAdapt_ItDoc::FindParseHaltLocation(wxChar* ptr, wxChar* pEnd,
	bool* pbFoundInlineBindingEndMarker,
	bool* pbFoundFixedSpaceMarker,
	bool* pbFoundClosingBracket,
	bool* pbFoundHaltingWhitespace,
	int& nFixedSpaceOffset,
	int& nEndMarkerCount,
	bool bTokenizingTargetText)
{
	wxChar* p = ptr; // scan with p
	wxChar* pHaltLoc = ptr; // initialize to the start of the word proper
	enum SfmSet whichSFMSet = gpApp->gCurrentSfmSet;
	wxChar fixedSpaceChar = _T('~');
	// intialize return parameters
	*pbFoundInlineBindingEndMarker = FALSE;
	*pbFoundFixedSpaceMarker = FALSE;
	*pbFoundClosingBracket = FALSE;
	*pbFoundHaltingWhitespace = FALSE;
	nFixedSpaceOffset = -1;
	nEndMarkerCount = 0;
	wxString lastEndMarker; lastEndMarker.Empty();
	wxString puncts;
	if (bTokenizingTargetText)
	{
		puncts = gpApp->m_punctuation[1];
	}
	else
	{
		puncts = gpApp->m_punctuation[0];
	}
	int offsetToEndOfLastBindingEndMkr = -1;
	// scan ahead, looking for the halt location prior to a following word or
	// end-of-buffer
	while (p < pEnd)
	{
		// the test
		// BEW 2Mar15, refactored because we store ] on m_follPunct if it is punctuation, but
		// instead on m_key & m_srcPhrase if word-building, and there is no need to call
		// IsClosingBracketWordBuilding() here, it instead needs to be called in TokenizeText()
		// where the storage decision will be made on the next iteration of that function's
		// parsing loop. Here we unilaterally halt parsing when ] is reached
		if (!IsMarker(p) && !IsWhiteSpace(p) && !IsFixedSpace(p) && (*p != _T(']')))
		{
			// if none of those, then it's part of the word, or part of punctuation which
			// follows it, so keep scanning
			p++;
		}
		else
		{
			// it's one of those - handle each possibility appropriately
			if (*p == fixedSpaceChar)
			{
				nFixedSpaceOffset = (int)(p - ptr);
				*pbFoundFixedSpaceMarker = TRUE;
				// BEW added 11Feb14, the comment in IsFixedSpaceAhead() which immediately
				// precedes the call of this FindParseHaltLocation() function has not been
				// implemented correctly. Without the addition which follows here, control
				// would break from the loop now, and *pbFoundHaltingWhitespace = TRUE; would
				// not be set if a halting space followed the ~ character [that wouldn't be
				// correct USFM markup, but someone has marked up their text in just that
				// way!] and got a parser crash as a consequence], hence this fix. So test
				// for whitespace following the tilde, or buffer end. Also test for ]
				// following the tilde - that too is a halting condition
				if (!(p + 1 < pEnd) || IsWhiteSpace(p + 1))
				{
					*pbFoundHaltingWhitespace = TRUE;
				}
				else if (*(p + 1) == _T(']'))
				{
					*pbFoundClosingBracket = TRUE;
				}
				break;
			}
			else if (*p == _T(']'))
			{
				*pbFoundClosingBracket = TRUE;
				break;
			}
			// if neither of the above, it must be one of the other conditions - try
			// endmarkers next; if it is one, and if it is an inline binding marker, we
			// note the fact and continue scanning; but other endmarkers halt scanning
			// (including the non-binding inline ones, like \wj*)
			if (IsMarker(p))
			{
				wxString wholeMkr = GetWholeMarker(p);
				int offset = wholeMkr.Find(_T('*'));
				if (whichSFMSet == PngOnly)
				{
					// this is a sufficient condition for determining that there is no ~
					// conjoining (endmarkers in this set are only \F or \fe - either is a
					// footnote end, and there would not be conjoining across that kind of
					// a boundary) and so we are at the end of a word for sure, so return
					break;
				}
				else // must be UsfmOnly or UsfmAndPng - we assume UsfmOnly
				{
					if (offset == wxNOT_FOUND)
					{
						//  there is no asterisk in the marker, so it is not an endmarker
						//  - it must then be a beginmarker, and they halt scanning
						break;
					}
					else
					{
						// it's an endmarker, but we parse over only those which are
						// inline binding ones, otherwise the marker halts scanning
						wxString beginMkr = wholeMkr;
						// BEW 24Oct14 no change needed here for support of USFM nested
						// markers, and likewise for the text .Find() just below
						beginMkr = beginMkr.Truncate(beginMkr.Len() - 1); // remove
											// the * (we are assuming the asterisk was at
											// the end where it should be)
						wxString mkrPlusSpace = beginMkr + _T(' '); // append a space
						int offset2 = gpApp->m_inlineBindingMarkers.Find(mkrPlusSpace);
						if (offset2 == wxNOT_FOUND)
						{
							// it's not one of the space-delimited markers in the fast access
							// string of inline binding beginmarkers, so it halts scanning
							break;
						}
						else
						{
							// it's an inline binding endmarker, so we scan over it and
							// let the caller handle it when parsing backwards to find the
							// end of the text part of the word just parsed over
							*pbFoundInlineBindingEndMarker = TRUE;
							lastEndMarker = wholeMkr;
							nEndMarkerCount++;
							unsigned int markerLen = wholeMkr.Len(); // use this to jump p forwards
							offsetToEndOfLastBindingEndMkr = (int)(p - ptr) + markerLen;
							p = p + markerLen;
						}
					}
				} // end of else block for test: if (whichSFMSet == PngOnly)
			} // end of TRUE block for test: if (IsMarker(p))
			else if (IsWhiteSpace(p))
			{
				// it's whitespace - some such can just be ignored, others constitute the
				// end of the word or word plus punctuation (and possibly binding
				// endmarker(s)) and so constitute grounds for halting - determine which
				// is the case
				// first, handle condition (i) in the remarks of the function description
				if (*pbFoundInlineBindingEndMarker == TRUE && p == (ptr + offsetToEndOfLastBindingEndMkr))
				{
					// The iterator, p, is pointing at a whitespace character immediately
					// following an inline binding marker just parsed over. This halts
					// scanning except when this whitespace (or several whitespace
					// characters) is followed by ~ or one of [ or ], or another inline
					// binding endmarker -- check these subconditions out, if one of them
					// is satisfied, then advance p to the ~ or [ or ] and halt there, but
					// if another inline binding endmarker follows, advance p to its start
					// and let the scanning loop continue
					int whitespaceSpan = ParseWhiteSpace(p);
					if (*(p + whitespaceSpan) == fixedSpaceChar)
					{
						// there is a fixedspace marker following, so return with p
						// pointing at it, etc
						p = p + whitespaceSpan;
						nFixedSpaceOffset = (int)(p - ptr);
						*pbFoundFixedSpaceMarker = TRUE;
						break;
					}
					else if (*(p + whitespaceSpan) == _T(']') || *(p + whitespaceSpan) == _T('['))
					{
						// there is an opening or closing bracket following the
						// whitespace(s), this halts scanning and also means there is no
						// conjoining (the whitespace is ignorable)
						p = p + whitespaceSpan;
						break;
					}
					else if (IsMarker(p + whitespaceSpan))
					{
						// it's a marker -- if it is an inline binding endmarker, then
						// jump over it, etc, and continue scanning, otherwise, it halts
						// scanning (and might as well halt at the space where p currently
						// is if that is the case)
						wxString wholeMkr = GetWholeMarker(p + whitespaceSpan);
						int offset = wholeMkr.Find(_T('*'));
						if (whichSFMSet == PngOnly)
						{
							// this is a sufficient condition for determining that there is no ~
							// conjoining (endmarkers in this set are only \F or \fe - either is a
							// footnote end, and there would not be conjoining across that kind of
							// a boundary) and so we are at the end of a word for sure, so return
							*pbFoundHaltingWhitespace = TRUE;
							break;
						}
						else // must be UsfmOnly or UsfmAndPng - we assume UsfmOnly
						{
							if (offset == wxNOT_FOUND)
							{
								//  there is no asterisk in the marker, so it is not an endmarker
								//  - it must then be a beginmarker, and they halt scanning
								*pbFoundHaltingWhitespace = TRUE;
								break;
							}
							else
							{
								// it's an endmarker, but we parse over only those which are
								// inline binding ones, otherwise the marker halts scanning
								// BEW 24Oct14 no change needed here for support of USFM nested
								// markers, and likewise for the text .Find() just below
								wxString beginMkr = wholeMkr.Truncate(wholeMkr.Len() - 1); // remove
													// the * (we are assuming the asterisk was at
													// the end where it should be)
								wxString mkrPlusSpace = beginMkr + _T(' '); // append a space
								int offset2 = gpApp->m_inlineBindingMarkers.Find(mkrPlusSpace);
								if (offset2 == wxNOT_FOUND)
								{
									// it's not one of the space-delimited markers in the fast access
									// string of inline binding beginmarkers, so it halts scanning
									*pbFoundHaltingWhitespace = TRUE;
									break;
								}
								else
								{
									// it's an inline binding endmarker, so we scan over it and
									// let the caller handle it when parsing backwards to find the
									// end of the text part of the word just parsed over,
									// continue iterating
									*pbFoundInlineBindingEndMarker = TRUE;
									nEndMarkerCount++;
									unsigned int markerLen = wholeMkr.Len(); // use this to jump p forwards
									p = p + whitespaceSpan; // point p at the start of the binding endmarker
									offsetToEndOfLastBindingEndMkr = (int)(p - ptr) + markerLen;
									p = p + markerLen;
								}
							}
						} // end of else block for test: if (whichSFMSet == PngOnly)
					} // end of TRUE block for test: else if (IsMarker(p + whitespaceSpan))
					else if (IsClosingCurlyQuote(p + whitespaceSpan))
					{
						// it's a closing curly quote, or a > chevron -- so scan over it &
						// continue
						p = p + whitespaceSpan;
					}
					else
					{
						// any other punctuation coming after a space or spaces should be
						// considered as opening punctuation for the following word, so
						// halt now
						*pbFoundHaltingWhitespace = TRUE;
						break;
					}

				} // end of TRUE block for test: if (*pbFoundInlineBindingEndMarker == TRUE &&
				  //                                 p == (ptr + offsetToEndOfLastBindingEndMkr))
				else
				{
					// subcondition (i) does not apply, so now test for subcondition (ii)
					// -- between something and a following inline binding endmarker
					int whitespaceSpan = ParseWhiteSpace(p);
					if (IsMarker(p + whitespaceSpan))
					{
						// it's a marker -- if it is an inline binding endmarker, then
						// jump over it, etc, and continue scanning, otherwise, it halts
						// scanning (and might as well halt at the space where p currently
						// is if that is the case)
						wxString wholeMkr = GetWholeMarker(p + whitespaceSpan);
						int offset = wholeMkr.Find(_T('*'));
						if (whichSFMSet == PngOnly)
						{
							// this is a sufficient condition for determining that there is no ~
							// conjoining (endmarkers in this set are only \F or \fe - either is a
							// footnote end, and there would not be conjoining across that kind of
							// a boundary) and so we are at the end of a word for sure, so return
							*pbFoundHaltingWhitespace = TRUE;
							break;
						}
						else // must be UsfmOnly or UsfmAndPng - we assume UsfmOnly
						{
							if (offset == wxNOT_FOUND)
							{
								//  there is no asterisk in the marker, so it is not an endmarker
								//  - it must then be a beginmarker, and they halt scanning
								*pbFoundHaltingWhitespace = TRUE;
								break;
							}
							else
							{
								// it's an endmarker, but we parse over only those which are
								// inline binding ones, otherwise the marker halts scanning
								// BEW 24Oct14 no change needed here for support of USFM nested
								// markers, and likewise for the text .Find() just below
								wxString beginMkr = wholeMkr.Truncate(wholeMkr.Len() - 1); // remove
													// the * (we are assuming the asterisk was at
													// the end where it should be)
								wxString mkrPlusSpace = beginMkr + _T(' '); // append a space
								int offset2 = gpApp->m_inlineBindingMarkers.Find(mkrPlusSpace);
								if (offset2 == wxNOT_FOUND)
								{
									// it's not one of the space-delimited markers in the fast access
									// string of inline binding beginmarkers, so it halts scanning
									*pbFoundHaltingWhitespace = TRUE;
									break;
								}
								else
								{
									// it's an inline binding endmarker, so we scan over it and
									// let the caller handle it when parsing backwards to find the
									// end of the text part of the word just parsed over,
									// continue iterating
									*pbFoundInlineBindingEndMarker = TRUE;
									nEndMarkerCount++;
									unsigned int markerLen = wholeMkr.Len(); // use this to jump p forwards
									p = p + whitespaceSpan; // point p at the start of the binding endmarker
									offsetToEndOfLastBindingEndMkr = (int)(p - ptr) + markerLen;
									p = p + markerLen;
								}
							}
						} // end of else block for test: if (whichSFMSet == PngOnly)
					} // end of TRUE block for test: else if (IsMarker(p + whitespaceSpan))
					else
					{
						// subcondition (ii) doesn't apply, so try subconditon (iii) --
						// this boils down to testing for a closing (curly) quote or >
						// wedge after the whitespace, if we find that ignore the space
						// and continue scanning, otherwise we halt here
						int whitespaceSpan = ParseWhiteSpace(p);
						if (IsClosingCurlyQuote(p + whitespaceSpan))
						{
							// this space(s) is/are to be ignored, continue scanning
							p = p + whitespaceSpan;
						}
						else
						{
							// none of the subconditions for regarding this space as ignorable are
							// satisfied, so halt here
							*pbFoundHaltingWhitespace = TRUE;
							break;
						}
					}
				} // end of else block for test: if (*pbFoundInlineBindingEndMarker == TRUE &&
				  //                                 p == (ptr + offsetToEndOfLastBindingEndMkr))
			} // end of TRUE block for test: else if (IsWhiteSpace(p))
			else
			{
				// it's not whitespace -- control should never enter here, but if it does,
				// then halt for safety's sake
				break;
			}
		} // end of else block for test: if (!IsMarker(p) && !IsWhiteSpace(p) && !IsFixedSpaceOrBracket(p))
	}
	pHaltLoc = p;
	return pHaltLoc;
}

wxString CAdapt_ItDoc::SquirrelAwayMovedFormerPuncts(wxChar* ptr, wxChar* pEnd, wxString& spacelessPuncts)
{
	wxString squirrel; squirrel.Empty();
	// first, find out if there is an inline binding beginmarker no more than
	// MAX_MOVED_FORMER_PUNCTS characters ahead of where ptr points on entry; if there
	// isn't, return an empty string because the caller must then assume that ptr on entry
	// is pointing at the actual start of the word which is to be parsed; if there is,
	// then make a further check - there must not be a space preceding the marker - if
	// there is, then return an empty string, because ptr must be pointing at a word to be
	// parsed
	int numCharsToCheck = (int)MAX_MOVED_FORMER_PUNCTS;
	bool bMarkerExists = FALSE;
	bool bItsAnInlineBindingMarker = FALSE;
	int count = 1;
	while (count <= numCharsToCheck)
	{
		if (IsWhiteSpace(ptr + count))
		{
			// white space encountered before a marker was reached, so return the empty
			// string
			return squirrel;
		}
		else if (IsMarker(ptr + count))
		{
			bMarkerExists = TRUE; // we must exit at the first found, we can't look beyond it
			break;
		}
		else
		{
			count++;
		}
	}
	// did we find a marker?
	if (!bMarkerExists)
	{
		// no marker within the allowed small span of following characters (3 is
		// MAX_MOVED_FORMER_PUNCTS value -- see AdaptItConstants.h) so the caller must
		// assume that ptr is the actual start of the word - it will deduce that fact if
		// the returned string is empty
		return squirrel;
	}
	else
	{
		// we found a marker, but it has to be an inline binding marker (and not an inline
		// binding endmarker); so check if it is an inline binding marker - if so, and
		// providing there was no preceding whitespace (tested in the loop above), we can
		// test for squirreling some non-restored word initial word-building characters
		// that got moved earlier to precede the inline binding marker, into the squirrel
		// string for safekeeping until the caller needs to insert them at the start of the
		// word to be parsed
		wxString wholeMkr = GetWholeMarker(ptr + count);
		// if it's an endmarker, return, we've not the situation we expect could happen
		if (wholeMkr[wholeMkr.Len() - 1] == _T('*'))
		{
			// it's an endmarker - return
			return squirrel;
		}
		wxString bareMkr = wholeMkr.Mid(1); // remove the initial backslash
		USFMAnalysis* pUsfmAnalysis = LookupSFM(bareMkr);
		if (pUsfmAnalysis == NULL)
		{
			// it's an unknown marker, therefore not an inline binding marker
			return squirrel; // caller will have to assume the char(s) at ptr are start of a word
		}
		else
		{
			wxString wholeMkrPlusSpace = wholeMkr + _T(' ');
			if (gpApp->m_inlineBindingMarkers.Find(wholeMkrPlusSpace) != wxNOT_FOUND)
			{
				// we've found a valid beginmarker from the set of inline binding markers
				bItsAnInlineBindingMarker = TRUE;
			}
		}
	}
	if (!bItsAnInlineBindingMarker)
	{
		squirrel.Empty();
		return squirrel;
	}
	wxChar* pNewEnd = ptr + count; // where the inline binding marker commences
	// now move each of them up to the marker, to squirrel string, provided they are not
	// in the punctuation set -- do this only if an inline binding marker was found ahead
	// of the characters at issue (because it's only such a marker that caused the move of
	// the former word-building char to become a punt in the first place, so it's only
	// from that kind of movement round the marker that we need a recovery mechanism for)
	while (bItsAnInlineBindingMarker && ptr < pNewEnd && ptr < pEnd &&
		spacelessPuncts.Find(*ptr) == wxNOT_FOUND)
	{
		squirrel += *ptr++;
	}
	if (bItsAnInlineBindingMarker && !squirrel.IsEmpty() && *ptr != gSFescapechar)
	{
		// there is at least one more moved here when it became punctuation, but it
		// remains as punctuation still... so to enable the caller to get the parsing ptr
		// to point at the marker's backslash when we return, we have to grab all the
		// rest, whether punctuation or not, and squirrel them away too. This can result
		// in punctuation being "buried" in word-medial location. We can't help this, it's
		// the price we pay for having one CSourcePhrase under punctuation changes
		// generate just one altered CSourcePhrase -- if not, we'll get more than one and
		// then things get messy
		while (*ptr != gSFescapechar)
		{
			squirrel += *ptr++;
		}
	}
	return squirrel;
}


void CAdapt_ItDoc::ValidateNoteStorage()
{
	SPList* pList = gpApp->m_pSourcePhrases;
	if (pList == NULL || pList->IsEmpty())
		return;
	SPList::Node* pos_pList = pList->GetFirst();
	while (pos_pList != NULL)
	{
		CSourcePhrase* pSrcPhrase = pos_pList->GetData();
		pos_pList = pos_pList->GetNext();
		if ((pSrcPhrase->GetNote()).IsEmpty())
		{
			pSrcPhrase->m_bHasNote = FALSE;
		}
		else
		{
			// it has a note string, so ensure the flag is set
			pSrcPhrase->m_bHasNote = TRUE;
		}
	}
}

// TRUE if not punct, or ~, or a marker, or not [ nor ], & not whitespace etc
// Note: the m_spacelessPuncts used here has already been set to source text
// punctuation characters, or target text punctuation characters, according to
// what TokenizeText() currently, or at last call, used when parsing
// BEW created 9Sep16, for use in a refactored & simplified ParseWord() function
// that handles ~ (USFM fixed space) better
bool CAdapt_ItDoc::IsInWordProper(wxChar* ptr, wxString& spacelessPuncts)
{
	// First test, is it a punctuation character, or a ~ character
	if (IsOneOf(ptr, spacelessPuncts))
	{
		return FALSE; // it's one of those, so not in the word proper
	}
	// Test for it being whitespace
	if (IsWhiteSpace(ptr))
	{
		return FALSE;
	}
	// Test for it being the first character of an SFM or USFM marker
	// Test for it being [ or ] or a solidus (forward slash)
	if ((*ptr == _T('\\')))
	{
		return FALSE;
	}
	// Test for it being [ or ] or a solidus (forward slash)
	if ((*ptr == _T('[')) || (*ptr == _T(']')))  // || (*ptr == _T('/'))) <- not here,
		// so we can parse dates like 12/04/2016 as a 'word' ** Check this works with / <-> ZWSP choice **
	{
		return FALSE;
	}
	return TRUE; // the only possibility left is that it is a word-building character
}

// TRUE if it is a ~ (tilde), the USFM fixed-space character
bool CAdapt_ItDoc::IsFixedSpace(wxChar* ptr)
{
	return *ptr == _T('~');
}


/// returns     TRUE if the marker is \f* or \fe* or \x* for USFM set, or if PNG 1998 set
///             is current, if the marker is \F or \fe
/// ptr        ->  the scanning pointer for the parse
/// pWholeMkr  <-  ptr to the endmarker string, empty if there is no marker at ptr
/// Called when ptr has possibly reached an endmarker following parsing of the word (and
/// possibly some following whitespace, the case when there was following puncts and ptr
/// points past them will be handled somewhere else probably). The intention of this function
/// is to alert the caller that any endmarker which should be stored in m_endMarkers and which
/// is currently being pointed at by ptr, must be flagged as present (so the caller can
/// then get it stored in m_endMarkers before returning from the caller to TokenizeText().
/// This function is very specific to making the ParseWord() parser work properly, so is
/// private in the document class. It the sfm set is PNG 1998 one, and the marker is \fe,
/// elsewhere in the app we default to assuming \fe is a USFM marker, since it is in both
/// sets with different meaning. Here we have a problem, if the set is the combined
/// UsfmAndPng, because it could then be a footnote endmarker of PNG 1998 set, or an
/// endnote beginmarker of the USFM set - and either could occur in the context where the
/// parser's ptr is currently at, so that's no help. So we'll require the set to be
/// explicitly PngOnly before we interpret it as the former. If it's UsfmAndPng, we'll
/// interpret it as the latter - and it that gives a false parse, then too bad. People
/// should be using only Usfm by now anyway!
/// BEW 24Oct14 no change needed for support of USFM nested markers
bool CAdapt_ItDoc::IsEndMarkerRequiringStorageBeforeReturning(wxChar* ptr, wxString* pWholeMkr)
{
	if (gpApp->gCurrentSfmSet == PngOnly)
	{
		//if (*ptr == gSFescapechar)
		if (IsMarker(ptr))
		{
			(*pWholeMkr) = GetWholeMarker(ptr);
			if (*pWholeMkr != _T("\\fe") && *pWholeMkr != _T("\\F"))
			{
				return FALSE;
			}
		}
		else
		{
			(*pWholeMkr).Empty();
			return FALSE;
		}
	}
	else
	{
		// it's either USFM set or UsfmAndPng set --  treat both as if USFM
		//if (*ptr == gSFescapechar)
		if (IsMarker(ptr))
		{
			(*pWholeMkr) = GetWholeMarker(ptr);
			if (*pWholeMkr != _T("\\f*") && *pWholeMkr != _T("\\fe*") && *pWholeMkr != _T("\\x*"))
			{
				return FALSE;
			}
		}
		else
		{
			(*pWholeMkr).Empty();
			m_bIsWithinUnfilteredInlineSpan = FALSE; // BEW added 2Dec22, as few places restore it to FALSE
			return FALSE;
		}
	}
	return TRUE;
}

// returns     the updated value of len, agreeing with where updated ptr is on return
// ptr            <->  the scanning pointer for the parse
// pEnd            ->  first character past the end of the data buffer we are parsing
// pSrcPhrase     <->  where we are storing information parsed, here it is final
//                     endmarker(s) and any immediately following punctuation for each;
//					   the endmarkers to be appended to its m_follOuterPunct member
// len             ->  the len value before ptr is maybe advanced in this internal scan
// bInlineBindingEndMkrFound <-> input FALSE, and returned as TRUE if an inline binding
//                               endmarker was detected and parsed over & stored (we
//                               use the TRUE value in the caller to enable a second
//                               attempt to collect final punctuation following such a
//                               marker) When  true, length returned is updated larger
// bNonbindingEndMkrFound	<-> input FALSE, returned as TRUE if an inline non-binding
//								marker found and stored, and  length returned updated
// bNormalEndMkrFound		<-> input FALSE, return TRUE if \x* \ex* \f* or \ef* was
//								found & stored, with ptr & length updated as above.
//								These four (two are new in USFM3) are stored in m_endMarkers
// endMkr          <-  the endmarker parsed over, in case the caller needs it
//
// Called when ptr has reached an endmarker following parsing of the word (and possibly
// also having parsed over punctuation too). There are three kinds of endmarker parse we
// handle here; first kind is parsing over one or more sequential inline binding
// endmarkers, that is, not \f* \ef* \x* \ex* nor any of the 5 in the 
// m_inlineNonbindingEndMarkers set. Any of these we will store in the 
// m_inlineBindingEndMarkers member of pSrcPhrase.
//
// The other kind of endmarkers we must deal with are those internal to footnotes or
// crossReferences, or internal to extended footnotes or crossreferences. These endmarkers
// in the case of footnotes start with \f and end with *, and for crossReferences, start
// with \x and end with *, and each has other characters between the \f and *, or the \x
// and *. These are \fdc* and \fm*, and we can include \fe* too (for endnotes); & for
// crossReferences, \xot* \xnt* \xdc* etc (these may be lacking).
// New USFM3 ones like \ef* and \ex*, these are to be stored in the m_endMarkers member.
//
// If this function finds no end marker of the type it deals with, then ptr and len are 
// returned unchanged to the caller, and further possibilities are then tried. 
// If it finds an endmarker (it finds ONLY ONE PER CALL) there may be following
// final punctuation characters - we have a pre-exit loop to check herin to parse over
// and put them in the m_follOuterPunct member of the current pSrcPhrase, advancing ptr 
// and len to point past them.
//
// The function has no loop, and must stay that way;
// however it is called in a loop, so can deal with successive endMarkers that way. So it
// deals with just one endMarker if ptr points to one; stores same, and returns an updated
// len value so caller's len can be updated to point to the same location. 
// BEW refactored 11Mar20. What I'm adding now is a punctuation-collecting loop after the 
// end marker has been dealt with, providing a single endmarker was found - because USFM3
// markup has things like: footnote:xref data spans where the : is word final punctuation
// that should get stored in pSrcPhrase's m_follOuterPunct -- otherwise it gets wrongly 
// assigned to a following empty CSourcePhrase instance.
// BEW 16Apr20 refactored for better support of USFM3 and cleaner algorithm
int CAdapt_ItDoc::ParseInlineEndMarkers(wxChar*& ptr, wxChar* pEnd,
	CSourcePhrase*& pSrcPhrase, wxString& inlineNonBindingEndMkrs, int len,
	bool& bBindingEndMkrFound, bool& bNonbindingEndMkrFound,
	bool& bNormalEndMkrFound, wxString& endMkr)
{
//#if defined (_DEBUG)
	//if (pSrcPhrase->m_nSequNumber == 2) // data: _punct_between_footnote_and_xref2.txt
	//if (pSrcPhrase->m_nSequNumber == 84 || pSrcPhrase->m_nSequNumber == 136)
	//if (pSrcPhrase->m_nSequNumber >= logStart && pSrcPhrase->m_nSequNumber <= logEnd) // 136 &  137 
	//{
	//	int halt_here = 1;
	//	wxUnusedVar(halt_here);
	//}
//#endif
	int inputLen = len; // save the input len value - so that if a marker is found and
						// stored, we can easily test for that fact
	endMkr.Empty();
	bool bIs_f_x_fe_xe_endMkr = FALSE;
	bool bIsMkr = IsMarker(ptr);
	wxUnusedVar(bIsMkr);
	bool bIsEndMkr = IsEndMarker(ptr, pEnd);
	if (!bIsEndMkr)
	{
		// do no parse if we are not pointing to an end- marker
		return len;
	}
	else
	{
		// BEW 16Apr20 USFM3 adds some more inLine "extended" markers, such as \ef ... \ef* 
		// (extended footnote) and \ex .... \ex* (extended cross reference), and we will
		// handle \ef* and \ex* here too. So below I'll refactor the code - the 'normal'
		// endmarker storage suggested by the name bInlineNormalMkrFound is to use
		// m_endMarkers member of the CSourcePhrase instance; with the exception that
		// if the endMarker is \+jmp then that will be included in the 'normal'
		// set and so be stored in m_endMarkers also

		// BEW 15Apr20 for \f* \x* \ef* \ex*
		bIs_f_x_fe_xe_endMkr = IsFootnoteOrCrossReferenceEndMarker(ptr);
		if (bIs_f_x_fe_xe_endMkr)
		{
			// Get it stored
			endMkr = GetWholeMarker(ptr);
			// it's one of \f* \ef* \x* or \ex*; these are all stored in m_endMarkers
			int length = endMkr.Len();
			wxString endMkrs = pSrcPhrase->GetEndMarkers();
			endMkrs += endMkr;
			pSrcPhrase->SetEndMarkers(endMkrs);

			// Update len value, and set ptr to point at the next character 
			// immediately after the end marker - it might be whitespace, punctuation,
			// a further endMarker, ] (bracket), or the beginning of the next word to
			// be parsed - this function returns to a loop, which will iterate this
			// function and break out when len does not advance because there are no
			// more final puncts or endmarkers to deal with for the current pSrcPhrase
			bNormalEndMkrFound = TRUE;
			len += length;
			ptr += length;
			m_bIsWithinUnfilteredInlineSpan = FALSE; // BEW added 2Dec22, as few places restore it to FALSE
		}
		// The following are the storage attempts for the rest of what markers may occur
		else if (!bIs_f_x_fe_xe_endMkr)
		{
			// it's not one of \f* \ef* \x* or \ex*; and we also in the function do not parse
			// over any of the 5 inline non-binding endmarkers (\wj* \qt* \sls* \tl*
			// \fig*) so test for these and exit without doing anything if we are pointing
			// at one of them
			// BEW 30Sep19, refactor a bit, because \ef* otherwise ends up wrongly
			// in the storage for inline binding endmarker, rather than m_endMarkers;
			// similarly for \ex*
			wxString wholeEndMkr = GetWholeMarker(ptr);
			wxString wholeEndMkrPlusSpace = wholeEndMkr + _T(" ");
			int length = wholeEndMkr.Len();
			int offset = wxNOT_FOUND; // initialise
			if (inlineNonBindingEndMkrs.Find(wholeEndMkrPlusSpace) == wxNOT_FOUND)
			{
				// It's not in the non-binding fast access string...

				// There are now several possibilities... distinguish between & process ...
				// The protocol: we are pointing at an inline endmarker - so determine
				// what it is, and store appropriately. It's either a binding type,
				// or a normal type (normal types include markers internal to footnotes,
				// end notes and cross references, including for \ef and \ex spans)
				// and return (there may be more than one, so the caller will repeat the
				// call until the len value returned is equal to what was input - which is
				// a sufficient test for parsing over nothing during the call)
				//
				// option (1) we are pointing at an inline endmarker internal to a footnote,
				// endnote or crossReference - and if that is the case, parse it, store,
				// and return to the caller -- again, the caller receiving a len value
				// equal to what was input indicates the caller's loop must end
				// option (2) we must also test for the marker plus space being in the
				// gpApp->m_inlineBindingEndMarkers fast access string, and only
				// store to m_endMarkers when its neither binding nor nonbinding
				// option (3) the left-overs: when its neither binding nor nonbinding -
				// put it in m_endMarkers
				if (IsCrossReferenceInternalEndMarker(ptr) || IsFootnoteInternalEndMarker(ptr))
				{
					// option (1) obtains
					pSrcPhrase->AddEndMarker(wholeEndMkr);  // add to m_endMarkers
					bNormalEndMkrFound = TRUE;
				}
				else
				{
					// checkfor binding endmarker which slipped thru the net
					offset = wholeEndMkr.Find(_T("*"));
					if (offset == wxNOT_FOUND)
					{
						// It's not an endmarker, so don't advance len value,
						// just return what length was passed in
						return len;
					}
					else
					{
						// Make the begin-mkr  (we don't have a fast-access
						// string defined for inline binding end markers)
						wxString beginMkr = wholeEndMkr.Left(offset);
						beginMkr += _T(' '); // add following space
						offset = gpApp->m_inlineBindingMarkers.Find(beginMkr);
						if (offset == wxNOT_FOUND)
						{
							// It's not an inline binding end marker, so must
							// be the 'remainder' solution - a normal endmarker
							// to be stored in m_endMarkers; but it could be
							// one of the USFM3 character attribute end markers -
							// these we store in the non-binding end marker
							// storage. Check it out & store accordingly
							offset = gpApp->m_charAttributeEndMkrs.Find(wholeEndMkrPlusSpace);
							if (offset == wxNOT_FOUND)
							{
								// It's not one of the USFM3 character attribute end markers,
								// so it needs to go in m_endMarkers
								pSrcPhrase->AddEndMarker(wholeEndMkr);  // add to m_endMarkers
								bNormalEndMkrFound = TRUE;
							}
							else
							{
								// It's found within the set of USFM3 character attribute
								// end markers; these we store in the non-binding end mkr
								// storage - with the exception of \+jmp* which, because it's
								// embedded within some other non-filtered span, we need to
								// append it m_endMarkers member of pSrcPhrase
								wxString plusJmpEndMkr(_T("\\+jmp*"));
								if (wholeEndMkr == plusJmpEndMkr)
								{
									pSrcPhrase->AddEndMarker(plusJmpEndMkr);
									bNormalEndMkrFound = TRUE;
								}
								else
								{
									wxString strNonbinding = pSrcPhrase->GetInlineNonbindingEndMarkers();
									strNonbinding += wholeEndMkr;
									pSrcPhrase->SetInlineNonbindingEndMarkers(strNonbinding);
									bNonbindingEndMkrFound = TRUE;
								}
							}
						}
						else
						{
							// it's an inline binding end marker
							pSrcPhrase->AppendToInlineBindingEndMarkers(wholeEndMkr);
							bBindingEndMkrFound = TRUE;
						}
					} // end of else block for test: if (offset == wxNOT_FOUND)

				} // end of else block for test: if (IsCrossReferenceInternalEndMarker(ptr) 
				  //								|| IsFootnoteInternalEndMarker(ptr))
			} // end of TRUE block for test:
			  // if (inlineNonBindingEndMkrs.Find(wholeEndMkrPlusSpace) == wxNOT_FOUND)
			else
			{
				wxString strNonbinding = pSrcPhrase->GetInlineBindingEndMarkers();
				strNonbinding += wholeEndMkr;
				pSrcPhrase->SetInlineNonbindingEndMarkers(strNonbinding);
				bNonbindingEndMkrFound = TRUE;
			}
			// Return the marker in endMkr, update len value, and set ptr
			// to point at the next character immediately after the end marker
			endMkr = wholeEndMkr;
			len += length;
			ptr += length;

		} // end of TRUE block for test: else if (!bIs_f_x_fe_xe_endMkr)

	} // end of else block for test: if (!IsEndMkr)

	// Did we parse and store an endmarker? Loop to get any further final puncts
	if (len > inputLen)
	{
		int offset = wxNOT_FOUND; // initialise
		bool bUseTgtPuncts = m_bTokenizingTargetText; // from Doc.h to preserve bool value
													  // passed in, in TokenizeText() call
		// Yes we did; so parse over any following punctuation that belongs to the
		// m_follOuterPunct member and store it, updating len and ptr before returning
		// - include space in the parse so long as a final punct follows it
		wxString space = _T(" ");
		bool bIncludeSpace = FALSE;
		while (
			(ptr < pEnd) &&
			(*ptr != _T(']')) &&
			(!IsMarker(ptr) && !IsEndMarker(ptr, pEnd)))
		{
			bIncludeSpace = FALSE;
			if (*ptr == _T(' '))
			{
				wxString afterSpace = *(ptr + 1);
				int offset2 = wxNOT_FOUND;
				if (bUseTgtPuncts)
				{
					// use the word-final set of target language punctuation characters
					offset2 = gpApp->m_finalTgtPuncts.Find(afterSpace);
				}
				else
				{
					// use the word-final set of source language punctuation characters
					offset2 = gpApp->m_finalSrcPuncts.Find(afterSpace);
				}
				if (offset2 != wxNOT_FOUND)
				{
					bIncludeSpace = TRUE;
				}
			}

			if (bIncludeSpace)
			{
				pSrcPhrase->AddFollOuterPuncts(space);
				// Add it also to end of m_srcPhrase so it's seen in the GUI
				pSrcPhrase->m_srcPhrase += space;
				len++;
				ptr++;
			}
			else
			{
				if (bUseTgtPuncts)
				{
					// use the word-final set of target language punctuation characters
					offset = gpApp->m_finalTgtPuncts.Find(*ptr);
				}
				else
				{
					// use the word-final set of source language punctuation characters
					offset = gpApp->m_finalSrcPuncts.Find(*ptr);
				}
				if (offset == wxNOT_FOUND)
				{
					// The character at ptr is not a punctuation character
					return len;

				}
				else
				{
					// A punctuation character is at ptr. Deal with it, and advance ptr and len,
					// and iterate the loop until all consecutive final puncts are collected
					// and appended to m_follOuterPunct
					wxChar aPunct = *ptr;
					pSrcPhrase->AddFollOuterPuncts(aPunct);
					// Add it also to end of m_srcPhrase so it's seen in the GUI
					pSrcPhrase->m_srcPhrase += aPunct;
					len++;
					ptr++;
				} // end of else block for test: if (offset == wxNOT_FOUND)
			} // end  of else block for test: if (bIncludeSpace)

		}  // end of while loop for scanning and storing final puncts in m_follOuterPunct

	} // end of TRUE block for test: if (len > inputLen) i.e. a marker was
	  // found and stored, len & ptr updated, and maybe some further puncts too -
	  // and additional increase of len and ptr for them as well
	return len;
}

// returns     the updated value of len, agreeing with where ptr is on return
// ptr            <->  the scanning pointer for the parse
// pEnd            ->  first character past the end of the data buffer we are parsing
// pSrcPhrase     <->  where we are storing information parsed, here it is final
//                     punctuation to be appended to its m_follPunct member
// spacelessPuncts ->  the punctuation set being used (either source puncts, or target ones)
// len             ->  the len value before ptr is advanced in this internal scan
// bExitOnReturn  <-   return TRUE if ParseWord() should be exited on return
// bHasPrecedingStraightQuote <-> default is FALSE, the boolean passed in is stored
//                                on the CAdapt_ItDoc class with public access; and
//                                is set TRUE if a straight quote (" or ') is detected
//                                in TokenizeText() when parsing punctuation preceding
//                                a word. The matching closing straight quote could be
//                                many word parses further on, and so we leave it set
//                                until one of the following happens, whichever is first:
//                                a new verse is started, or, its TRUE value is used to
//                                assign ownership of ' or " to the currently being parsed
//                                word as its final punctuation, or part of its final
//                                punctuation (if there are more than one, we'll assign them
//                                all - which could lead to a misparse if an opening
//                                straight quote occurs prior to the next word - it's
//                                opening quote would wrongly be put in the following puncts
//                                of the preceding word -- but probably this would never
//                                happen in practice [we hope])
// additions	<-	what we to what we already have for m_srcPhrase final punctuation
//					and for adding to m_follPunct
// bPutInOuterStorage   ->		 pass in false, but we'll just set it internally
//								 to whatever it needs to be depending on what we parse
// Called after a sequence of word-final punctuation ends at space - there could be
// additional detached endquotes, single or double - this function collects these, stores
// them appropriately in pSrcPhrase, and advances len and ptr to the end of the material
// parsed over.
// BEW created 11Oct10
// BEW 2Dec10 added ] character as cause to return, ptr should be pointing at it on return
// BEW 24Oct14, no changes needed for support of USFM nested markers
// BEW 30Sep19, added code for endmarker being parsed and stored too
// BEW 16Apr20 refactored somewhat
int CAdapt_ItDoc::ParseAdditionalFinalPuncts(wxChar*& ptr, wxChar* pEnd,
	CSourcePhrase*& pSrcPhrase, wxString& spacelessPuncts,
	int len, bool& bExitOnReturn, bool& bHasPrecedingStraightQuote,
	wxString& additions, bool bPutInOuterStorage)
{
	wxChar* pPunctStart = ptr;
	wxChar* pPunctEnd = ptr;
	size_t counter = 0;
	bool bFoundClosingQuote = FALSE;
	wxChar* pLocation_OK = ptr;
	// The test is complex, and setting bFoundClosingQuote  is what we
	// mainly want to know, whether true or false, but the while loop
	// can exit with bFoundClosingQuote set TRUE, but ptr and pLocation_OK
	// having same value but pointing a one or more punctuation characters
	// not yet parsed. So after the while loop another loop will parse over
	// any puncts that remain before whatever causes halting (e.g. a marker)
	while (!IsEnd(ptr) && (IsWhiteSpace(ptr) || IsClosingQuote(ptr)) && !IsMarker(ptr)
		&& *ptr != _T(']'))
	{
		if (IsClosingQuote(ptr))
		{
			bFoundClosingQuote = TRUE;
			// now determine if it is a curly endquote or right chevron, and if so
			// then it is definitely to be included in the following punctuation of
			// the current pSrcPhrase
			if (IsClosingCurlyQuote(ptr))
			{
				// mark the location following it
				pLocation_OK = ptr;
				pLocation_OK = (wxChar*)(pLocation_OK + 1);
			}
		}
		counter++;
		ptr++;
		pPunctEnd = ptr;
		// if the punctuation end is also pEnd, then tell the caller not to parse further
		// on return
		if (IsEnd(pPunctEnd))
		{
			bExitOnReturn = TRUE;
		}
	}
	// BEW 17Apr20 The complex test will exit after detecting a closing curly quote,
	// leaving ptr and pLocation_OK possibly pointing at a punctuation character or
	// characters without accumulating all up to a halting point - such as an endmarker
	// then code further below will  not match with comments, and misbehave. So get
	// as many as there are before an endmarker or ] or doc end. counter tracks how many
	wxString strPuncts = m_spacelessPuncts; // RHS is Doc.cpp member, set by TokenizeText()
											// to src or tgt set, as required
	int anOffset = wxNOT_FOUND;
	while (!IsMarker(ptr) && (*ptr != _T(']')) && !IsEnd(ptr))
	{
		wxString s(*ptr);
		anOffset = strPuncts.Find(s);
		if (anOffset == wxNOT_FOUND)
		{
			break;
		}
		else
		{
			counter++;
			ptr++;
			pLocation_OK++;
			pPunctEnd = ptr;
		}
	}
	// On exit of the loop we are either at buffer end, or backslash of a marker, or a ]
	// closing bracket, or some character which is not whitespace nor a closing quote
	// (IsClosingQuote() also tests for a straightquote or doublequote, so
	// IsCLosingCurlyQuote() was also used as it does not test for straight ones)
	if (bFoundClosingQuote)
	{
		// we matched something more than just whitespace and the something is
		// curly endquote(s) and possibly a straight one (or more than one) - pLocation_OK
		// will point at the character following the last curly endquote scanned over, so
		// only white space and one or more straight quotes can follow that location
		//
		// BEW 3Aug17 added text on next line, IsMarker() and not IsEndMarker() so as
		// to enter the TRUE block when a begin marker is being pointed at, whether \v, or
		// \x or \f or \fe etc because we need to go back to TokenizeText to parse these
		// and possibly filter one or more, so we need to just accept what we've parsed
		// over here, if anything, and return with ptr pointing at the marker, or pointing
		// at the start of any previous whitespace if there is any just parsed over.
		// Use IsEndMarker(ptr, pEnd) call here too? dunno; change IsEndMarker() call into
		// IsMarker() call here; snd also some code to test that if it is a marker here, it
		// is not an inline binding marker
		int offset = wxNOT_FOUND;
		if (IsMarker(ptr))
		{
			// Check it's not a binding type, as these insignificant ones
			// should not affect storage nor the text stream parsing in any
			// significant way - that is, we want wxNOT_FOUND to be the
			// value in the test which follows
			wxString aWholeMkr = GetWholeMarker(ptr);
			wxString augmentedMkr = aWholeMkr + _T(' ');
			offset = gpApp->m_inlineBindingMarkers.Find(augmentedMkr);
		}

		if ((IsMarker(ptr) && offset == wxNOT_FOUND) || IsEnd(ptr))
		{
			// an endmarker or a begin marker is what ptr points at now, or the buffer's end,
			// so we'll accept everything as valid final punctuation for the current
			// pSrcPhrase; and if not at buffer end then further parsing is needed in the
			// caller because there may be more markers and punctuation to be handled for
			// the end of the current word. The marker is NOT an inlinebinding one
			bExitOnReturn = FALSE; // BEW 17Apr20 -- needs to be FALSE, so that further
								   // processing can happen, otherwise exits to TokenizeText
								   // prematurely (about line 31,195)

			// Back up over any preceding space & adjust ptr & counter
			int aWhiteSpanLength = 0;
			wxChar* pTemp = ptr;
			while ((size_t)aWhiteSpanLength < counter)
			{
				pTemp--;
				if (IsWhiteSpace(pTemp))
				{
					aWhiteSpanLength++;
				}
				else
				{
					break;
				}
			}

			if (aWhiteSpanLength > 0)
			{
				counter -= aWhiteSpanLength;
				ptr = ptr - (size_t)aWhiteSpanLength;
			}

			wxString finalPunct(pPunctStart, counter);
			if (bPutInOuterStorage)
			{
				pSrcPhrase->AddFollOuterPuncts(finalPunct);
			}
			else
			{
				pSrcPhrase->m_follPunct += finalPunct;
			}
			pSrcPhrase->m_srcPhrase += finalPunct; // add any detached punct'n
			additions += finalPunct; // accumulate here, so that the caller can add any
				// additions to secondWord of ~ conjoining, in the
				// m_srcPhrase and m_follPunct members; note this
				// setting of additions is done whether fixedspace
				// was encountered or not
			// What ptr points at now could be an inline non-binding endmarker (like \wj*)
			// or one of \f* \x* \ef* or \ex* - so while our parse of the punctuation in
			// this function halts, the caller's parse may continue over potential 
			// endmarkers or puncts further on, and there could be outer following
			// punctuation too; it won't though if bExitOnReturn is TRUE - so we set
			// it to FALSE above
			len += counter;

//#if defined (_DEBUG)
			//if (pSrcPhrase->m_nSequNumber == 2) // data: _punct_between_footnote_and_xref2.txt
			//if (pSrcPhrase->m_nSequNumber == 84 || pSrcPhrase->m_nSequNumber == 136)
			//if (pSrcPhrase->m_nSequNumber >= logStart && pSrcPhrase->m_nSequNumber <= logEnd) // 136 &  137 
			//{
			//	int halt_here = 1;
			//	wxUnusedVar(halt_here);
			//}
//#endif
		} // end of TRUE block for test: if (IsEndMarker(ptr,pEnd) || IsEnd(ptr))
		else
		{
			// ptr is not pointing at the start of a marker; the situation is somewhat
			// ambiguous - the difficulty here is that we may have some ending
			// punctuation parsed over which belongs to the final punctuation of the
			// current pSrcPhrase, followed by some initial punctuation (it can only be
			// straight singlequote or straight doublequote) which belongs to the start
			// of the next word to be parsed - so we'll accept only up to where
			// pLocation_OK points as belonging to final punctuation of pSrcPhrase, and
			// anything after that belongs to the next call of ParseWord() as initial
			// punctuation for that call's word; however if bHasPrecedingStraightQuote is
			// TRUE, then we'll accept the whole lot, because we assume that any straight
			// quotes match any found earlier somewhere.
			size_t shortCount = 0;
			if (pLocation_OK > pPunctStart)
			{
				// we found at least one curly endquote, so work out if they all were
				// curly endquotes that we parsed over (and accept them all) or if
				// only some of them were (we accept only those up to pLocation_OK,
				// and if any quotes follow we assume they belong to the next word -
				// unless bHasPrecedingStraightQuote is TRUE)
				shortCount = pLocation_OK - pPunctStart;
				if (shortCount < counter)
				{
					// we parsed over non-curly (& non-right-chevron) non-endquote
					// quote character lying beyond pLocation_OK, or, we may have just
					// whitespace following pLocation_OK -- handle these possibilities
					wxString finalPunct(pPunctStart, shortCount);
					if (bPutInOuterStorage)
					{
						pSrcPhrase->AddFollOuterPuncts(finalPunct);
					}
					else
					{
						pSrcPhrase->m_follPunct += finalPunct;
					}
					pSrcPhrase->m_srcPhrase += finalPunct;
					additions += finalPunct;
					size_t theRest = pPunctEnd - pLocation_OK;
					wxString remainder(pLocation_OK, theRest);
					wxString minusEndingSpaces = remainder.Trim();
					if (minusEndingSpaces.IsEmpty())
					{
						// there was only whitespace in remainder, so we can include
						// it in the parsed over data span & tell the caller to return
						len += counter;
						bExitOnReturn = TRUE;
						return len;
					}
					else
					{
						// remainer has some nonwhitespace content, but that must
						// belong (we assume) to the next word's parse, so set the ptr
						// location to be pLocation_OK; but if bHasPrecedingStraightQuote
						// is TRUE, accept it all
						if (bHasPrecedingStraightQuote)
						{
							if (bPutInOuterStorage)
							{
								pSrcPhrase->AddFollOuterPuncts(remainder);
							}
							else
							{
								pSrcPhrase->m_follPunct += remainder;
							}
							pSrcPhrase->m_srcPhrase += remainder;
							additions += remainder;
							ptr += theRest;
							len += (int)theRest;
							bHasPrecedingStraightQuote = FALSE; // we've made a decision
								// based on it's TRUE value, so we must now restore
								// its default FALSE value in case further matching
								// of preceding and following straight quotes is
								// required in the parse of further words
						}
						else
						{
							ptr = pLocation_OK;
							len += shortCount;
							bExitOnReturn = TRUE;
							return len;
						}
					}
				}
				else
				{
					// shortCount and counter are the same value, so we accept it all
					// and we must tell the caller to return because ptr is not pointing
					// at a marker but something else which is not a quote symbol.
					// Possibly it could be other punctuation ptr is pointing at, and if
					// it is so without any spaces, then we should accept it as belonging
					// to the end of the current final punctuation - so accumulate it
					// until space or non-puncts are encountered. But check for ] first,
					// if pointing at that, (it's defaulted as punctuation) don't
					// accumulate it but return instead
					wxString finalPunct(pPunctStart, counter);
					if (bPutInOuterStorage)
					{
						pSrcPhrase->AddFollOuterPuncts(finalPunct);
					}
					else
					{
						pSrcPhrase->m_follPunct += finalPunct;
					}
					pSrcPhrase->m_srcPhrase += finalPunct;
					additions += finalPunct;
					len += counter;
					// are we pointing at ] bracket?
					if (*ptr == _T(']'))
					{
						// we must return
						bExitOnReturn = TRUE;
						return len;
					}
					// else, accumulate any more puncts until space or non-punct or a
					// ] bracket is reached
					while (ptr < pEnd && (spacelessPuncts.Find(*ptr) != wxNOT_FOUND)
						&& *ptr != _T(']'))
					{
						wxString aPunct = *ptr;
						if (bPutInOuterStorage)
						{
							pSrcPhrase->AddFollOuterPuncts(aPunct);
						}
						else
						{
							pSrcPhrase->m_follPunct += *ptr;
						}
						pSrcPhrase->m_srcPhrase += *ptr;
						additions += *ptr;
						len++;
						ptr++;
					}
					bExitOnReturn = TRUE;
					return len;
				}
			} // end of TRUE block for test: if (pLocation_OK > pPunctStart)
			else
			{
				// pLocation_OK has not advanced from pPunctStart where we started this
				// parse, so we didn't find any curly endquotes; so count all the punct and
				// whitespace parsed over as belonging to a later word -- and ptr is not
				// pointing at an endmarker, but if might be pointing at ] closing bracket,
				// so either way we must be done & can return after we finish off the
				// pSrcPhrase members; however, if bHasPrecedingStraightQuote is TRUE, then
				// we assume that only straight quotes were in the parse and that they
				// should be included as following punctuation for the current word. This
				// might be a faulty decsion if some belong to the current word and some to
				// the following word yet to be parsed, but our code can't reasonably be
				// made smart enough to decide where to make the division - and so we'll
				// just hope that that situation won't ever occur.
				if (bHasPrecedingStraightQuote || *ptr == _T(']'))
				{
					// Do a sanity (hack) test here, just in case markup inconsistency
					// let a straight doublequote get to here wrongly as a candidate
					// for closing quote, when it should be opening quote for the
					// word which follows (Seth's bug) BEW 19Oct15
					if (CannotBeClosingQuote(ptr, pPunctStart))
					{
						// reject the extras just parsed over
						ptr = pPunctStart; // restore ptr to location where we started from
						bExitOnReturn = TRUE;
						return len;
					}
					// okay, take the extras just parsed over
					if (counter > 0)
					{
						wxString finalPunct(pPunctStart, counter);
						if (bPutInOuterStorage)
						{
							pSrcPhrase->AddFollOuterPuncts(finalPunct);
						}
						else
						{
							pSrcPhrase->m_follPunct += finalPunct;
						}
						pSrcPhrase->m_srcPhrase += finalPunct;
						additions += finalPunct;
						len += counter;
						return len;
					}
				}
				else
				{
					// reject the extras just parsed over
					ptr = pPunctStart; // restore ptr to location where we started from
					bExitOnReturn = TRUE;
					return len;
				}
			} // end of else block for test: if (pLocation_OK > pPunctStart)
		} // end of else block for test: if marker and not an inline binding mkr or is at buffer end
	} // end of TRUE block for test: if (bFoundClosingQuote)
	else if (IsEndMarker(ptr, pEnd) || IsEnd(ptr))
	{
		bExitOnReturn = FALSE;
		if (counter > 0)
		{
			if (IsEnd(ptr))
			{
				// ensure that if ptr is at pEnd, the caller does not parse further
				bExitOnReturn = TRUE;
			}
			// an endmarker is what ptr points at now, or the buffer's end, so we'll accept
			// everything as valid final punctuation for the current pSrcPhrase; and if not
			// at buffer end then further parsing is needed in the caller because there may
			// be more markers and punctuation to be handled for the end of the current
			// word
			wxString finalPunct(pPunctStart, counter);
			pSrcPhrase->m_follPunct += finalPunct;
			pSrcPhrase->m_srcPhrase += finalPunct; // add any punct'n
			additions += finalPunct; // accumulate here, so that the caller
				// can add any additions to secondWord of ~ conjoining, in the
				// m_srcPhrase and m_follPunct members (if there is conjoining)
			// What ptr points at now could be an inline non-binding endmarker (like \wj*)
			// or one of \f* \x* \ef* or \ex* etc, so while our parse of the
			// punctuation in this function halts, the caller's parse must 
			// continue over potential endmarkers further on, and there could 
			// be outer following punctuation too
			len += counter;
		} // end of TRUE block for test: if (counter > 0)
		else
		{
			// nothing extra, so return, but continue parsing in ParseWord() on return
			ptr = pPunctStart; // restore ptr to location where we started from
			bExitOnReturn = FALSE;
			return len;
		}
	}
	else if (*ptr == _T(']'))
	{
		// accept everything up to that point
		if (counter > 0)
		{
			wxString finalPunct(pPunctStart, counter);
			if (bPutInOuterStorage)
			{
				pSrcPhrase->AddFollOuterPuncts(finalPunct);
			}
			else
			{
				pSrcPhrase->m_follPunct += finalPunct;
			}
			pSrcPhrase->m_srcPhrase += finalPunct;
			additions += finalPunct;
			len += counter;
			bExitOnReturn = TRUE;
			return len;
		}
	}
	else
	{
		// we either didn't parse over anything, including white space; or we only
		// parsed over whitespace -- the latter is of no interest (we let the caller
		// advance over it)
		ptr = pPunctStart; // restore ptr to location where we started from
		bExitOnReturn = FALSE; // BEW 17Apr20 was FALSE
		return len;
	} // end of else block for test: if (bFoundClosingQuote)
	return len;
}

// BEW 25Jul23 added. It seems weird to use ParseFinalPuncts on a, say, reversed string
// with final punct before reversing. But ParseFinalPuncts returns correct length, parsing
// left to right, so I made ParsePuncts() to look more normal to someone maintaining AI
// One thing I added, and it's what messed with ParseAWord(), is that AI normally does not
// contain straight single quote ( '\'' ) as a punctuation character (it's often a glottal
// stop in many languages), so here, before ParseFinalPuncts is called, I'll add single
// straight to a temporary copy of spacelessPuncts.
int CAdapt_ItDoc::ParsePuncts(wxChar* pChar, wxChar* pEnd, wxString spacelessPuncts)
{
	wxString punctsSet;
	punctsSet = spacelessPuncts;
	// whm 22Sep2023 removed the following line thinking it to be illogical to add a word-
	// building glottal stop to a punctsSet.
	//punctsSet << _T('\'');
	int parsedPunctsLen;
	parsedPunctsLen = ParseFinalPuncts(pChar, pEnd, punctsSet);
	return parsedPunctsLen;
}

// BEW 29May23 if I'm to support data like  "laughter"\\f*... etc, where these puncts,
// or the ' punct, bracket a word intended to be considered by the reader has a meaning
// for what precedes, then I have to allow " or 1 to be considered by Adapt It as legit
// "final punctuation". Up to now, it refuses to consider either as a punctuation character
// but clearly each is. So, refactor accordingly. The while loop therefore needs fixing
//
// *********  NOTE ***** BEW 3Jun23 if I get a message, errorC2248: cannot access private member declared in class
// *********  regarding operator= , when using ParseFinalPuncts() , it's because I was assuming that the function
// *********  ParseFinaPuncts() returns a wxString, when it actually returns an int!!!!! Duh! Homer brain struck again
// *********  I've done this a sufficient number of times, and found the explanations opaque, I need a note somewhere.
int CAdapt_ItDoc::ParseFinalPuncts(wxChar* pChar, wxChar* pEnd, wxString spacelessPuncts)
{
	int length = 0;
	wxChar* ptr = pChar; // iterator
	//int offset = wxNOT_FOUND;
	if (ptr < pEnd && (spacelessPuncts.Find(*ptr) == wxNOT_FOUND))
	{
		// ptr is not pointing at a punctuation character, so return 0
		return length;
	}
	else
	{
		// There is at least one punctuation character, so parse over each in a loop
		// until the loop exit condition is met. A while loop suffices. Punctuation characters
		// which are not word-final, have to be excluded, so the loop will exit if one such is at ptr
		while ( !IsEnd(ptr) && !IsWhiteSpace(ptr) && (spacelessPuncts.Find(*ptr) != wxNOT_FOUND) 
				&& (*ptr != _T('[')) && (*ptr != _T('(')) && (*ptr != _T('{')) && (*ptr != gSFescapechar)
				//&& (!IsOpeningQuote(ptr)) && (*ptr != _T('\"')) && (*ptr != _T('\'')) ) BEW 29May23 removed, gotta allow " or ' as storable in m_finalPunct
			)
		{
			length++;
			ptr++;
		}
	}
	return length;
}


//BEW added 12Sep22 in support of the dual identities of \w .. \w* markers - for Tokenising properly
// ptr points at the current parsing location of the in-buffer source text USFM (or no usfm) data.
// When ptr encounters an augmented _T("\\w ") i.e. \w<space>, marker, there are two possible parsing
// paths. One is for \w word\w* just wrapping word, where word is valid source text information, but
// the word is also intended for Paratext to copy it out for a glossary dictionary. The other path is
// for when there is a bar ( | ) following the augmented marker, where the bar indicates that information
// follows which is not part of the inspired text, and so should be hidden from view by caching it on
// the current pile's current pSrcPhrase instance in a (repurposed) location called "pupat" -- see the
// declaration of CSourcePhrase. When a bar is present, then the CSourcePhrase instance will receive
// in pupat (called the m_punctsPattern member, but has no relationship to punctuation anymore, it's been
// repurposed for caching) the material to be cached: the first 3 characters of which will be <sp>|<sp>
// with the rest or the material to be hidden, following - and the correct endmarker at the end. There
// may be punctuation in the string, in which case entity changes will have been done, e.g. &quot; 
// replacing " because the information has to be stored in XML when the document is saved to disk.
// Also, every time pupat has content, the 22nd bool bit-flag,(corresponding to the CSourcePhrase
// member m_bUnused) will be set to 1. CSourcePhrase has member storage markers for certain types of
// inLine markers, such as inlineBindingMarkers (iBM) and endmarkers (iBEM), inlineNonbindingMmarkers (iNM)
// and endmarkers (iNEM) which hold marker forms relevant to caching, or non-caching but as non-typed
// indicators for wrapping a word or phrase which AI is to give minimal support to. \w and \w* are one
// of the latter, when there is no bar in the data so-wrapped.
// The algorithm for IsWmkrNoBar(ptr) as follows: 1. check if ptr is pointing at \w<sp>, if not, return FALSE.
// If its \w<SP>, search forward until the matching \w* endmarker terminates the search. IN the search,
// look for a bar character. If no matching endmarker is found (but some other one is, or end of doc) then
// return FALSE. If bar is encountered, then return TRUE; otherwise, return FALSE
bool CAdapt_ItDoc::IsWmkrWithBar(wxChar* ptr)
{
	wxChar bar = _T('|');
	wxString augBeginMkr = _T("\\w ");
	// Get the marker at ptr, and augment it by appending space - but check first that ptr points at a marker
	// and that it is not pointing at an end marker (since GetWholeMarker will return both marker or endmarker)
	// Then we can be sure that if ptr is pointing at a marker, it is a beginMkr
	wxString wholeMkr = GetWholeMarker(ptr);
	if (wholeMkr.IsEmpty())
	{
		// ptr is not pointing at a marker, whether beginMkr or endMkr
		return FALSE;
	}
	bool bEndMkr = IsEndMarker2(ptr);
	if (bEndMkr)
	{
		// ptr is pointing at an endMkr, we want a beginMkr, so return FALSE
		return FALSE;
	}
	// augment the marker by appending space
	wxString augMkr = wholeMkr + _T(' ');
	// Test for identity with augBeginMkr
	if (augMkr == augBeginMkr)
	{
		// we have a match so scan for a bar, or till enMkr (or some other marker, or doc end
		wxChar* auxPtr = ptr; // make sure we don't alter value of ptr
		// get past the backslash, w, and following space before beginning search
		auxPtr += 2; // we could be pointing at char prior to bar now, but more than one space may precede the bar so code accordingly
		bool bAnotherMkr = FALSE;
		do {
			auxPtr++;
			if (*auxPtr == bar)
			{
				// Found a bar character, so we need to return TRUE immediately
				return TRUE;
			}
			else
			{
				// If bAnotherMkr is TRUE, even if it is the endMkr _T("\\w*"), control getting to the marker
				// means that no bar was present in the span of \w .... \w*, so exit the scan & return FALSE
				bAnotherMkr = IsMarker(auxPtr);
			}
		} while (!IsEnd(auxPtr) && !bAnotherMkr);
	}
	return FALSE; // we didn't find a bar
}

// returns the new updated value for len, and ptr, after parsing over any whitespace
int CAdapt_ItDoc::ParseOverAndIgnoreWhiteSpace(wxChar*& ptr, wxChar* pEnd, int len)
{
	wxChar* pParseStartLoc = ptr;
	wxChar* pParseHaltLoc = NULL;
	while (IsWhiteSpace(ptr) && ptr < pEnd)
	{
		ptr++;
	}
	pParseHaltLoc = ptr;
	if (pParseHaltLoc > pParseStartLoc)
	{
		len += (int)(pParseHaltLoc - pParseStartLoc);
	}
	return len;
}

///////////////////////////////////////////////////////////////////////////////
/// \return		nothing
///	\param		useSfmSet	->	which of the three sfm set possibilities we are dealing with
/// \param		filterMkrs	->	concatenated markers (each with a following space) which are
///								the markers formerly unfiltered but now designated by the user
///								as to be filtered,
/// \param		unfilterMkrs ->	concatenated markers (each with a following space) which are
///								the markers formerly filtered but now designated by the user
///								as to be unfiltered.
/// \remarks
/// Called from: the App's DoUsfmFilterChanges(), the Doc's RestoreDocParamsOnInput(),
/// ReconstituteAfterFilteringChange(), RetokenizeText().
/// This is an overloaded version of another function called ResetUSFMFilterStructs.
/// Changes only the USFMAnalysis structs which deal with the markers in the filterMkrs
/// string and the unfilterMkrs string.
///////////////////////////////////////////////////////////////////////////////
void CAdapt_ItDoc::ResetUSFMFilterStructs(enum SfmSet useSfmSet, wxString filterMkrs,
	wxString unfilterMkrs)
{
	// BEW added 25May05 in support of changing filtering settings for USFM, SFM or
	// combined Filtering set The second and third strings must have been set up in the
	// caller by iterating through the map m_FilterStatusMap, which contains associations
	// between the bare marker as key (ie. no backslash or final *) and a literal string
	// which is "1" when the marker is unfiltered and about to be filtered, and "0" when it
	// is filtered and about to be unfiltered. This map is constructed when the user exits
	// the Filter tab of the Preferences or Start Working... wizard.
	MapSfmToUSFMAnalysisStruct* pSfmMap;
	USFMAnalysis* pSfm;
	wxString fullMkr;

	pSfmMap = gpApp->GetCurSfmMap(useSfmSet);

	MapSfmToUSFMAnalysisStruct::iterator iter;
	// enumerate through all markers in pSfmMap and set those markers that occur in the
	// filterMkrs string to the equivalent of filter="1" and those in unfilterMkrs to the
	// equivalent of filter="0"; doing this means that any call of TokenizeText() (or
	// functions which call it such as TokenizeTextString() etc) will, when they get to the
	// LookupSFM(marker) call, get the USFMAnalysis with the filtering settings which need
	// to be in place at the time the lookup is done

	for (iter = pSfmMap->begin(); iter != pSfmMap->end(); ++iter)
	{
		wxString key = iter->first; // use only for inspection
		pSfm = iter->second;
		fullMkr = gSFescapechar + pSfm->marker + _T(' '); // each marker in filterMkrs is
														  // delimited by a space
		if (filterMkrs.Find(fullMkr) != -1)
		{
			pSfm->filter = TRUE;
			// because of how the caller constructs filterMkrs and unfilterMkrs, it is
			// never possible that a marker will be in both these strings, so if we do this
			// block we can skip the next
			continue;
		}
		if (unfilterMkrs.Find(fullMkr) != -1)
		{
			pSfm->filter = FALSE;
		}
	}
	// redo the special fast access marker strings to reflect any changes to pSfm->filter
	// attributes
	gpApp->SetupMarkerStrings();
}

///////////////////////////////////////////////////////////////////////////////
/// \return		nothing
///	\param		useSfmSet	->	which of the three sfm set possibilities we are dealing with
/// \param		filterMkrs	->	concatenated markers (each with a following space) which are
///								the markers formerly unfiltered but now designated by the user
///								as to be filtered,
/// \param		resetMkrs	-> an enum indicating whether to reset allInSet or onlyThoseInString
/// \remarks
/// Called from: the Doc's RestoreDocParamsOnInput().
/// The filterMkrs parameter is a wxString of concatenated markers delimited by following spaces.
/// If resetMkrs == allInSet, ResetUSFMFilterStructs() sets the filter attributes of the
/// appropriate SfmSet of markers to filter="1" if the marker is present in the
/// filterMkrs string, and for all others the filter attribute is set to filter="0"
/// if it is not already zero.
/// If resetMkrs == onlyThoseInString ResetUSFMFilterStructs() sets the filter attributes
/// of the appropriate SfmSet of markers to filter="1" of only those markers which
/// are present in the filterMkrs string.
/// ResetUSFMFilterStructs does nothing to the USFMAnalysis structs nor their
/// maps in response to the presence of unknown markers (filtered or not), since unknown markers
/// do not have any identifiable attributes, except for being considered userCanSetFilter
/// as far as the filterPage is concerned.
///////////////////////////////////////////////////////////////////////////////
void CAdapt_ItDoc::ResetUSFMFilterStructs(enum SfmSet useSfmSet, wxString filterMkrs,
	enum resetMarkers resetMkrs)
{
	// whm added 5Mar2005 in support of USFM and SFM Filtering support
	MapSfmToUSFMAnalysisStruct* pSfmMap;
	USFMAnalysis* pSfm;
	wxString key;
	wxString fullMkr;

	pSfmMap = gpApp->GetCurSfmMap(useSfmSet);

	MapSfmToUSFMAnalysisStruct::iterator iter;
	// enumerate through all markers in pSfmMap and set those markers that
	// occur in the filterMkrs string to filter="1" and, if resetMkrs is allInSet,
	// we also set those that don't occur in filterMkrs to filter="0"

	for (iter = pSfmMap->begin(); iter != pSfmMap->end(); ++iter)
	{
		wxString key = iter->first; // use only for inspection
		pSfm = iter->second;
		fullMkr = gSFescapechar + pSfm->marker + _T(' '); // each marker in filterMkrs
														  // is delimited by a space
		if (filterMkrs.Find(fullMkr) != -1)
		{
			pSfm->filter = TRUE;
		}
		else if (resetMkrs == allInSet)
		{
			pSfm->filter = FALSE;
		}
	}
	// The m_filterFlagsUnkMkrs flags are already changed in the filterPage
	// so they should not be changed (reversed) here

	// redo the special fast access marker strings to reflect any changes to pSfm->filter
	// attributes or the presence of unknown markers
	gpApp->SetupMarkerStrings();
}


///////////////////////////////////////////////////////////////////////////////
/// \return		the whole standard format marker including the initial backslash and any ending *
/// \param		pChar			-> a pointer to the first character of the marker (a backslash)
/// \remarks
/// Called from: the Doc's GetMarkerWithoutBackslash(), IsInLineMarker(), IsCorresEndMarker(),
/// TokenizeText(), the View's RebuildSourceText(), FormatMarkerBufferForOutput(),
/// DoExportInterlinearRTF(), ParseFootnote(), ParseEndnote(), ParseCrossRef(),
/// ProcessAndWriteDestinationText(), ApplyOutputFilterToText(), IsCharacterFormatMarker(),
/// DetermineRTFDestinationMarkerFlagsFromBuffer().
/// Returns the whole standard format marker including the initial backslash and any ending
/// asterisk.
/// BEW 15Sep10, it helps to have a predictable return if pChar on input is not pointing
/// at a backslash - so test and return the empty string. (Better this way for OXES support)
/// BEW 24Oct14, no changes needed for support of USFM nested markers
///////////////////////////////////////////////////////////////////////////////
wxString CAdapt_ItDoc::GetWholeMarker(wxChar* pChar)
{
	//if (*pChar != gSFescapechar)
	if (!IsMarker(pChar))
	{
		wxString s; s.Empty();
		return s;
	}
	// whm added 10Feb2005 in support of USFM and SFM Filtering support
	// returns the whole marker including backslash and any ending *
	wxChar* ptr = pChar;
	int itemLen = ParseMarker(ptr);
	return wxString(ptr, itemLen);
}

///////////////////////////////////////////////////////////////////////////////
/// \return		the whole standard format marker including the initial backslash
///             and any ending *
/// \param		str	-> a wxString in which the initial backslash of the marker to be
///					   obtained is at the beginning of the string
/// \remarks
/// Called from: the View's RebuildSourceText(), and many other places
/// Returns the whole standard format marker including the initial backslash and any ending
/// asterisk. Internally uses ParseMarker() just like the version of GetWholeMarker() that
/// uses a pointer to a buffer.
/// BEW 15Sep10, it helps to have a predictable return if pChar on input is not pointing
/// at a backslash - so test and return the empty string. (Better this way for OXES support)
/// BEW 24Oct14, no changes needed for support of USFM nested markers
///////////////////////////////////////////////////////////////////////////////
wxString CAdapt_ItDoc::GetWholeMarker(wxString str)
{
	if (str[0] != gSFescapechar)
	{
		wxString s; s.Empty();
		return s;
	}
	// BEW added 2Jun2006 for situations where a marker is at the start of a CString
	// returns the whole marker including backslash and any ending *
	int len = str.Length();
	// wx version note: Since we require a read-only buffer we use GetData which just
	// returns a const wxChar* to the data in the string.
	const wxChar* pChar = str.GetData();
	wxChar* pEnd;
	pEnd = (wxChar*)pChar + len;
	wxChar* pBufStart = (wxChar*)pChar;
	wxASSERT(*pEnd == _T('\0'));
	pEnd = pEnd; // avoid warning
	int itemLen = ParseMarker(pBufStart);
	wxString mkr = wxString(pChar, itemLen);
	return mkr;
}

// BEW added 31May23 for use in propagation code (in TokenizeText)
// return empty string if endMkrs is empty
wxString CAdapt_ItDoc::GetLastEndMarker(wxString endMkrs)
{
	wxString endMkr = wxEmptyString; // init
	if (endMkrs.IsEmpty())
	{
		return endMkr; // empty
	}
	wxString reversed = MakeReverse(endMkrs);
	// Take Left() substring up to first backslash, include backslash in Left()
	int offset = wxNOT_FOUND; // init
	offset = reversed.Find(gSFescapechar);
	if (offset == wxNOT_FOUND)
	{
		// there are no markers in endMkrs
		return endMkr; // still empty
	}
	else
	{
		// Found a backslash
		endMkr = reversed.Left(offset + 1); // include the backslash
		wxASSERT(endMkr.GetChar(0) == _T('*'));
		endMkr = MakeReverse(endMkr);
		wxASSERT(endMkr.GetChar(0) == gSFescapechar);
	}
	return endMkr;
}

///////////////////////////////////////////////////////////////////////////////
/// \return		the standard format marker without the initial backslash, but including
///             any ending *
/// \param		pChar	-> a pointer to the first character of the marker (a backslash)
/// \remarks
/// Called from: the Doc's IsPreviousTextTypeWanted(), GetBareMarkerForLookup(),
/// IsEndMarkerForTextTypeNone(), the View's InsertNullSourcePhrase().
/// Returns the standard format marker without the initial backslash, but includes any end
/// marker asterisk. Internally calls GetWholeMarker().
/// BEW 24Oct14, no changes needed for support of USFM nested markers
/// BEW 7Nov16, Updated for supporting nested TextType none markers, these have
/// + after the backslash; we need to remove the + if present
/// whm 4Sep2023 modified to handle situations where pChar points at string content 
/// that starts with a backslash, but it gets an empty string from GetWholeMakrer(ptr)
/// In this situation with Mkr being an empty string we must protect the GetChar(1)
/// call ensuring that it doesn't get called on an empty string. In this case we don't
/// call GetChar(1) unless the Mkr string has a length >= 2 to avoid an exception crash.
///////////////////////////////////////////////////////////////////////////////
wxString CAdapt_ItDoc::GetMarkerWithoutBackslash(wxChar* pChar)
{
	// whm added 10Feb2005 in support of USFM and SFM Filtering support
	// Strips off initial backslash but leaves any final asterisk in place.
	// The bare marker string returned is suitable for marker lookup only if
	// it is known that no asterisk is present; if unsure, call
	// GetBareMarkerForLookup() instead.
	wxChar* ptr = pChar;
	if (*pChar == gSFescapechar)
	{
		wxString Mkr = GetWholeMarker(ptr);
		// Check for + after the backslash
		if (Mkr.Length() >=2 && Mkr.GetChar(1) == _T('+'))
		{
			return Mkr.Mid(2); // strip of the initial backslash and the '+'
		}
		else
		{
			return Mkr.Mid(1); // strip off initial backslash
		}
	}
	else
	{
		return wxEmptyString;
	}
}


///////////////////////////////////////////////////////////////////////////////
/// \return		the standard format marker without the initial backslash and
///             without any ending *
/// \param		pChar	-> a pointer to the first character of the marker in the
///                        buffer (a backslash)
/// \remarks
/// Called from: the Doc's IsPreviousTextTypeWanted(), ParseFilteringSFM(), LookupSFM(),
/// AnalyseMarker(), IsEndMarkerForTextTypeNone(), the View's InsertNullSourcePhrase(),
/// DoExportInterlinearRTF(), IsFreeTranslationEndDueToMarker(), HaltCurrentCollection(),
/// ParseFootnote(), ParseEndnote(), ParseCrossRef(), ProcessAndWriteDestinationText(),
/// ApplyOutputFilterToText().
/// Returns the standard format marker without the initial backslash, and without any end
/// marker asterisk. Internally calls GetMarkerWithoutBackslash().
/// BEW 24Oct14, no changes needed for support of USFM nested markers
/// BEW 7Nov16, updated to handle nested markers like \+it and \+it*  If + is present
/// it has to be stripped off too, to get a valid bare tag for lookup purposes
///////////////////////////////////////////////////////////////////////////////
wxString CAdapt_ItDoc::GetBareMarkerForLookup(wxChar* pChar)
{
	// whm added 10Feb2005 in support of USFM and SFM Filtering support
	// Strips off initial backslash and any ending asterisk.
	// The bare marker string returned is suitable for marker lookup.
	wxChar* ptr = pChar;
	wxString bareMkr = GetMarkerWithoutBackslash(ptr); // The calls GetWholeMarker()
			// and just returns the result of stripping off the initial backslash,
			// so if + is present, it will be the first character. Check and remove it
	// BEW 29Oct10 protect Get Char(0)
	wxChar first; //= _T('\0'); // initialise BEW dangerous to set to NULL, comment that out
	int length = bareMkr.Len();
	if (length > 0)
	{
		first = bareMkr.GetChar(0); // safe now
		if (first == _T('+'))
		{
			// Only markers which are inline & which we assign TextType value of none
			// can qualify for having \+ before the tag. We've found one such
			bareMkr = bareMkr.Mid(1);
		}
		int posn = bareMkr.Find(_T('*'));
		// The following GetLength() call could on rare occassions return a
		// length of 1051 when processing the \add* marker.
		// whm comment: the reason for the erroneous result from GetLength
		// stems from the problem with the original code used in ParseMarker.
		// (see caution statement in ParseMarker).
		if (posn >= 0)
		{// whm revised 7Jun05
			// strip off asterisk for attribute lookup
			bareMkr = bareMkr.Mid(0, posn);
		}
	}
	else
	{
		// Must be empty string
		return wxEmptyString;
	}
	return bareMkr;
}

// whm 30Nov2023 added.
// An override of above function that gets a bare marker from a whole marker.
// For markers that have a following space and number, such as \c 1 and \v 22
// this function leaves off the following space and number.
// any following space and number
wxString CAdapt_ItDoc::GetBareMarkerForLookup(wxString wholeMkr)
{
	wxString bareMarker;
	bareMarker.Empty();
	int mkrpos = wxNOT_FOUND;
	wholeMkr.Trim(FALSE); // trim any initial space
	// remove the backslash
	mkrpos = wholeMkr.Find(gSFescapechar);
	if (mkrpos != wxNOT_FOUND)
		bareMarker = wholeMkr.Mid(mkrpos + 1);
	else
		bareMarker = wholeMkr; // no gSFescapechar found so wholeMkr is malformed and not really a whole marker, but continue in case a bare marker was imput
	bareMarker.Trim(FALSE); // remove any leading space
	// remove any '+' char after the removed backslash 
	mkrpos = bareMarker.Find(_T("+"));
	if (mkrpos != wxNOT_FOUND)
		bareMarker.Remove(mkrpos, 1);
	bareMarker.Trim(FALSE); // again remove any leading space
	// remove any marker content consisting of a following space and number
	mkrpos = bareMarker.Find(_T(" "));
	if (mkrpos != wxNOT_FOUND)
	{
		// a space follows the bareMarker; remove any space and following number or whatever follows any space
		bareMarker = bareMarker.Mid(0, mkrpos);
	}
	// just to make sure remove any leading and following spaces
	bareMarker.Trim(FALSE);
	bareMarker.Trim(TRUE);
	return bareMarker;
}

///////////////////////////////////////////////////////////////////////////////
/// \return		nothing
/// \param		pMkrList	<- a wxArrayString that holds standard format markers 
/// \param		str			-> the string containing standard format markers and associated text
/// \remarks
/// Called from: the Doc's GetUnknownMarkersFromDoc(), the View's GetMarkerInventoryFromCurrentDoc(),
/// CPlaceInternalMarkers::InitDialog().
/// Scans str and collects all standard format markers (but not their associated text) into
/// pMkrList, one marker per array item (and final endmarker if there is one).
/// whm added str param 18Feb05
/// BEW 24Mar10 no changes needed for support of doc version 5
/// BEW 24Oct14, no changes needed for support of USFM nested markers
/// BEW 25Mar15, some refactoring to fix non-robust marker handling code - it failed
/// when two markers (like \p\v ) occurred in sequence with no intervening space. The
/// function GetMarkerAtBuf() was also similarly changed because it returned nothing
/// when control was pointing at a \p\v sequence.
/// BEW 25Mar15, as well as the above changes, the endmarker detection code in the
/// legacy version of this function was made redundant by the docVersion change at 5
/// if I remember correctly, where endmarkers no longer get stored in m_markers after their
/// corresponding beginmarker, but rather in a separate m_endMarkers member of CSourcePhrase.
/// So we have to look for a matching endmarker in m_endMarkers, rather than in m_markers.
/// whm 22Jan2024 Note: This function doesn't include associated text within the pMkrList
/// items, but only begin and end markers; and does not include the chapter or verse
/// numbers within the markers. I've changed the name of this function from it's original
/// GetMarkersAndTextFromString() to GetMarkersAndEndMarkersFromString() - a function name 
/// which more accurately describes what it actually does.
///////////////////////////////////////////////////////////////////////////////
void CAdapt_ItDoc::GetMarkersAndEndMarkersFromString(wxArrayString* pMkrList, wxString str, wxString endmarkers)
{
	// Populates a wxArrayString containing sfms parsed from the input str. 
	// pMkrList will contain one list item for each marker found in str in order from 
	// beginning of str to end.
	int nLen = str.Length();
	// wx version note: Since we require a read-only buffer we use GetData which just
	// returns a const wxChar* to the data in the string.
	const wxChar* pBuf = str.GetData();
	wxChar* pEnd = (wxChar*)pBuf + nLen; // cast necessary because pBuf is const
	wxASSERT(*pEnd == _T('\0')); // whm added 18Jun06
	wxChar* ptr = (wxChar*)pBuf;
	//wxChar* pBufStart = (wxChar*)pBuf; // BEW 9Sep10, IsMarker() call no longer needs this
	wxString accumStr = _T("");
	// caller needs to call Clear() to start with empty list
	while (ptr < pEnd)
	{
		if (IsFilteredBracketMarker(ptr, pEnd))
		{
			// It's a filtered marker opening bracket. There should always
			// be a corresponding closing bracket, so parse and accumulate
			// chars until end of filterMkrEnd.
			while (ptr < pEnd && !IsFilteredBracketEndMarker(ptr, pEnd))
			{
				accumStr += *ptr;
				ptr++;
			}
			if (ptr < pEnd)
			{
				// accumulate the filterMkrEnd
				// whm 8Jun12 modified for wxWidgets-2.9.3 wxStrlen_() is invalid, use wxStrlen()
				//for (int i = 0; i < (int)wxStrlen_(filterMkrEnd); i++)
				for (int i = 0; i < (int)wxStrlen(filterMkrEnd); i++)
				{
					accumStr += *ptr;
					ptr++;
				}
			}
			accumStr.Trim(FALSE); // trim left end
			accumStr.Trim(TRUE); // trim right end
			// add the filter sfm and associated text to list
			pMkrList->Add(accumStr);
			accumStr.Empty();
		}
		//else if (IsMarker(ptr,pBufStart))
		else if (IsMarker(ptr))
		{
			// It's a non-filtered sfm. Non-filtered sfms can be followed by
			// a corresponding markers or no end markers. We'll parse and
			// accumulate chars until we reach the next marker (or end of buffer).
			// If the marker is a corresponding end marker we'll parse and
			// accumulate it too, otherwise we'll not accumulate it with the
			// current accumStr.
			// First save the marker we are at to check that any end marker
			// that follows is indeed a corresponding end marker.
			wxString currMkr = MarkerAtBufPtr(ptr, pEnd); // BEW 25Mar15, refactored this
			int itemLen;
			//while (ptr < pEnd && *(ptr + 1) != gSFescapechar) <<-- unsafe for a \p\v sequence
			// Must accumulate the backslash being pointed at before entering the loop
			accumStr += *ptr;
			ptr++;
			while (ptr < pEnd && (!IsWhiteSpace(ptr) && *ptr != gSFescapechar))
			{
				accumStr += *ptr;
				ptr++;
			}
			itemLen = ParseWhiteSpace(ptr); // ignore return value
			ptr += itemLen;
			if (itemLen > 0)
				accumStr += _T(' ');
			// BEW 25Mar15, the endmarker code here was made redundant at docVersion 5 (?) and
			// above, because from that point onwards endmarkers are never stored in the
			// m_markers member of a CSourcePhrase. Instead, they are stored in the
			// m_endMarkers member. To get the endmarker showing correctly at the end of
			// the string being composed, we therefore must take the currMkr string found
			// above, append * to make it a 'correponding endmarker' possibility, and search
			// to find out if that putative endmarker is indeed stored in m_endMarkers.
			// If so, we can append it to accumStr

			// If there is a matching endmarker, add it to accumStr too
			if (!endmarkers.IsEmpty())
			{
				int offset = wxNOT_FOUND;
				wxString endMkr = currMkr + _T('*');
				offset = endmarkers.Find(endMkr);
				if (offset != wxNOT_FOUND)
				{
					// A matching endmarker exists on this CSourcePhrase instance
					accumStr += endMkr;
				}
			}
			accumStr.Trim(TRUE); // trim right end
			accumStr.Trim(FALSE); // trim left end
			// add the non-filter sfm and associated text to list
			pMkrList->Add(accumStr);
			accumStr.Empty();
		}
		else
			ptr++;
	} // end of while (ptr < pEnd)
	// We've finished building the wxArrayString
}

// whm 8Jan2024 added. This function is similar to the GetMarkersAndEndMarkersFromString() function
// above, but includes any white space following the Marker. 
// The pMkrList will contain a list of all markers and following whitespace, one marker/whitespace
// per list item.
// The str is the input string from pSrcPhrase->m_markers provided by the caller.
// This function is designed to be called from the RemoveDuplicateMarkersFromMkrString() function. 
// It provides that function with an inventory of markers existing in the m_markers member passed
// in here as str. Each marker in the inventory includes any following whitespace (usually a
// space or CR (\r), LF (\n) or combination CRLF \r\n). The RemoveDuplicateMarkersFromMkrString() 
// can then use the information provided from this function to remove duplicate markers from the 
// m_markers input string. Within the RemoveDuplicateMarkersFromMkrString() function, if the 
// marker has following white space and a duplicate marker also has that same white space, the 
// duplicate white space is also removed along with any duplicate marker found in the callers 
// m_markers member.
// Note: filtered markers and end markers are not expected in m_markers and so are not treated
// here.
void CAdapt_ItDoc::GetMarkersAndFollowingWhiteSpaceFromString(wxArrayString& MkrList, wxString str)
{
	// Populates a wxArrayString containing usfm markers and any white space
	// following the marker parsed from the input str. pMkrList will contain one list item for
	// each marker and following white space found in str, in order from beginning of
	// str to end.
	MkrList.Clear();
	int nLen = str.Length();
	// wx version note: Since we require a read-only buffer we use GetData which just
	// returns a const wxChar* to the data in the string.
	const wxChar* pBuf = str.GetData();
	wxChar* pEnd = (wxChar*)pBuf + nLen; // cast necessary because pBuf is const
	wxASSERT(*pEnd == _T('\0')); // whm added 18Jun06
	wxChar* ptr = (wxChar*)pBuf;
	//wxChar* pBufStart = (wxChar*)pBuf; // BEW 9Sep10, IsMarker() call no longer needs this
	wxString accumStr = _T("");
	// caller needs to call Clear() to start with empty list
	while (ptr < pEnd)
	{
		// Filtered markers with brackets are not stored within m_markers
		// an so we won't expect them in str.
		/*
		if (IsFilteredBracketMarker(ptr, pEnd))
		{
			// It's a filtered marker opening bracket. There should always
			// be a corresponding closing bracket, so parse and accumulate
			// chars until end of filterMkrEnd.
			while (ptr < pEnd && !IsFilteredBracketEndMarker(ptr, pEnd))
			{
				accumStr += *ptr;
				ptr++;
			}
			if (ptr < pEnd)
			{
				// accumulate the filterMkrEnd
				// whm 8Jun12 modified for wxWidgets-2.9.3 wxStrlen_() is invalid, use wxStrlen()
				//for (int i = 0; i < (int)wxStrlen_(filterMkrEnd); i++)
				for (int i = 0; i < (int)wxStrlen(filterMkrEnd); i++)
				{
					accumStr += *ptr;
					ptr++;
				}
			}
			accumStr.Trim(FALSE); // trim left end
			accumStr.Trim(TRUE); // trim right end
			// add the filter sfm and associated text to list
			pMkrList->Add(accumStr);
			accumStr.Empty();
		}
		else 
		*/
		if (IsMarker(ptr))
		{
			// We'll parse and accumulate chars until we reach the next marker (or 
			// end of buffer).
			// If the marker is a corresponding end marker we'll parse and
			// accumulate it too, otherwise we'll not accumulate it with the
			// current accumStr.
			// First save the marker we are at to check that any end marker
			// that follows is indeed a corresponding end marker.
			wxString currMkr = MarkerAtBufPtr(ptr, pEnd); // BEW 25Mar15, refactored this
			int itemLen;
			// Must accumulate the backslash being pointed at before entering the loop
			accumStr += *ptr;
			ptr++;
			// The marker could be a \c n or \v n marker which has whitespace as part
			// of the marker itself, wo the while loop below should not stop at whitespace
			// as part of its iteration through the m_marker string.
			// TODO: Is this stopping at whitespace a flaw in the logic of the similar-named
			// GetMarkersAndEndMarkersFromString() function above???
			while (ptr < pEnd && *ptr != gSFescapechar) //while (ptr < pEnd && (!IsWhiteSpace(ptr) && *ptr != gSFescapechar))
			{
				accumStr += *ptr;
				ptr++;
			}
			// If ptr is now pointing at white we accumulate it along with the marker
			itemLen = ParseWhiteSpace(ptr); 
			wxString whiteSp = wxString(ptr, itemLen);
			if (!whiteSp.IsEmpty())
			{
				accumStr += whiteSp;
				ptr += itemLen;
			}
			ptr += itemLen;
			// We don't add any extra space as we don't expect any associated text in m_markers (str)
			//if (itemLen > 0)
			//	accumStr += _T(' ');
			// 
			// BEW 25Mar15, the endmarker code here was made redundant at docVersion 5 (?) and
			// above, because from that point onwards endmarkers are never stored in the
			// m_markers member of a CSourcePhrase. Instead, they are stored in the
			// m_endMarkers member. To get the endmarker showing correctly at the end of
			// the string being composed, we therefore must take the currMkr string found
			// above, append * to make it a 'correponding endmarker' possibility, and search
			// to find out if that putative endmarker is indeed stored in m_endMarkers.
			// If so, we can append it to accumStr

			// End markers are not treated here
			/*
			if (!endmarkers.IsEmpty())
			{
				int offset = wxNOT_FOUND;
				wxString endMkr = currMkr + _T('*');
				offset = endmarkers.Find(endMkr);
				if (offset != wxNOT_FOUND)
				{
					// A matching endmarker exists on this CSourcePhrase instance
					accumStr += endMkr;
				}
			}
			*/
			// accumStr.Trim(TRUE); // Do not trim off any white space from right end!
			accumStr.Trim(FALSE); // trim left end
			// add the non-filter sfm and associated text to list
			MkrList.Add(accumStr);
			accumStr.Empty();
		}
		else
			ptr++;
	} // end of while (ptr < pEnd)
	// We've finished building the wxArrayString
}

// This function inputs via str parameter a filtered string - with filter brackets - that
// contains multiple filtered items, it separates out each filtered material string, removes
// the filter brackets, and stored each filtered item in the pMkrList array, one per array
// item.
// This function is called in the bUnfilteringRequired block of the ReconstituteAfterFilteringChange()
// function.
// Note: Filtered items within the m_filteredInfo member can be prefixed by any of the markers in the
// set m_markersCanBeSweptUpByFilteredMarker = _T("\\c \\p \\m \\mi \\nb \\b \\ib \\ie \\po ") and
// these may be intermixed with EOL "\r\n" sequences. Therefore each array item may be prefixed with
// some swept up markers and EOL characters.
// 
void CAdapt_ItDoc::GetMarkersAndAssocTextsFromFilteredString(wxArrayString& pMkrList, wxString str)
{
	// Populates a wxArrayString containing sfms parsed from the input str. 
	// pMkrList will contain one list item for each marker found in str in order from 
	// beginning of str to end.
	pMkrList.Empty();
	wxString filterStr = str;
	int nLen = filterStr.Length();
	if (nLen == 0)
		return;
	wxString endFilterMkr = _T("\\~FILTER*");
	wxString strFilteredItem; strFilteredItem.Empty();
	wxString remainingStuff; remainingStuff.Empty();
	// I think here it will be easiest to just find the end filter marker /~FILTER* and use the .Mid()
	// method to separate the filtered items along with any prefixed swept up material
	int posEndFilterMkr = 0;
	posEndFilterMkr = filterStr.Find(endFilterMkr);

	while (posEndFilterMkr != wxNOT_FOUND)
	{
		strFilteredItem = filterStr.Mid(0, posEndFilterMkr + endFilterMkr.Length());
		strFilteredItem = RemoveAnyFilterBracketsFromString(strFilteredItem); // This should leave swept up stuff intact
		pMkrList.Add(strFilteredItem);
		filterStr = filterStr.Mid(posEndFilterMkr + endFilterMkr.Length());
		posEndFilterMkr = filterStr.Find(endFilterMkr);
	}
	// We've finished building the wxArrayString
}

// whm 8Feb2024 added.
// This function gets the filtered info "segments" contained in filterStr.
// The "segments" contain the usual filtered info enclosed by \~FILTER ...\~FILTER*
// brackets. As of this date those "segments" may be prefixed by swept up markers
// that prefix a given segment. For example, now a segment may be comething like:
//   \c 11 \~FILTER \s Jon ta alomwa suni oro lau tan ala atou Jises\~FILTER*
// which has the swept up marker "\\c 11 " prefixing the bracketed filtered material.
// Note: This function is similar to the GetMarkersAndAssocTextsFromFilteredString()
// function. The GetMarkersAndAssocTextsFromFilteredString() fills the returned array
// with strings that already have the filter brakets removed, whereas this function
// fills its reference array parameter with strings that still have their filter
// brackets intact in each array item.
wxArrayString CAdapt_ItDoc::GetFilteredInfoSegments(wxString filterStr)
{
	wxArrayString segmentsArr;
	segmentsArr.Clear();
	int posEndFilterBracket = -1;
	wxString remainingStr = filterStr; // start with the whole string
	wxString endFilterBracket = _T("\\~FILTER*");
	int nLenEndnFilterBracket = (int)endFilterBracket.Length();
	posEndFilterBracket = remainingStr.Find(endFilterBracket);
	while (posEndFilterBracket != wxNOT_FOUND)
	{
		wxString tempStr;
		tempStr = remainingStr.Mid(0, posEndFilterBracket + nLenEndnFilterBracket);
		segmentsArr.Add(tempStr);
		remainingStr = remainingStr.Mid(posEndFilterBracket + nLenEndnFilterBracket);
		posEndFilterBracket = remainingStr.Find(endFilterBracket);
	}
	return segmentsArr;
}

///////////////////////////////////////////////////////////////////////////////
/// \return     TRUE if there is a filename clash, FALSE if the typed name is unique
///
/// \remarks
/// Get the active document folder's document names into the app class's
/// m_acceptedFilesList and test them against the user's typed filename.
/// Use in OutputFilenameDlg.cpp's OnOK()button handler.
/// Before this protection was added in 22July08, an existing document with lots of
/// adaptation and other work contents already done could be wiped out without warning
/// merely by the user creating a new document with the same name as that document file.
///////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItDoc::FilenameClash(wxString& typedName)
{
	gpApp->m_acceptedFilesList.Clear();
	wxString dirPath;
	if (gpApp->m_bBookMode && !gpApp->m_bDisableBookMode)
		dirPath = gpApp->m_bibleBooksFolderPath;
	else
		dirPath = gpApp->m_curAdaptationsPath;
	bool bOK;
	// whm 8Apr2021 added wxLogNull block below
	{
		wxLogNull logNo;	// eliminates any spurious messages from the system if the wxSetWorkingDirectory() call returns FALSE
		bOK = ::wxSetWorkingDirectory(dirPath); // ignore failures
	} // end of wxLogNull scope
	bOK = bOK; // avoid warning
	wxString docName;
	gpApp->GetPossibleAdaptionDocuments(&gpApp->m_acceptedFilesList, dirPath);
	int offset = -1;

	// remove any .xml or .adt which the user may have added to the passed in filename
	wxString rev = typedName;
	rev = MakeReverse(rev);

	// BEW note 26Apr10, .adt extensions occurred on in versions 1-3, but there is no harm
	// in leaving this line unremoved and similarly the test a little further below
	wxString adtExtn = _T(".adt");

	wxString xmlExtn = _T(".xml");
	adtExtn = MakeReverse(adtExtn);
	adtExtn = MakeReverse(adtExtn);

	// BEW note 26Apr10, these next 6 lines could be removed for versions 4.0.0 onwards,
	// but we'll leave them is they waste very little time, and do no harm
	offset = rev.Find(adtExtn);
	if (offset == 0)
	{
		// it's there, so remove it
		rev = rev.Mid(4);
	}

	offset = rev.Find(xmlExtn);
	if (offset == 0)
	{
		// it's there, so remove it
		rev = rev.Mid(4);
	}
	rev = MakeReverse(rev);
	int len = rev.Length();

	// test for filename clash
	int ct;
	for (ct = 0; ct < (int)gpApp->m_acceptedFilesList.GetCount(); ct++)
	{
		docName = gpApp->m_acceptedFilesList.Item(ct);
		offset = docName.Find(rev);
		if (offset == 0)
		{
			// this one is a candidate for a clash, check further
			int docNameLen = docName.Length();
			if (docNameLen >= len + 1)
			{
				// there is a character at len, so see if it is the . of an extension
				wxChar ch = docName.GetChar(len);
				if (ch == _T('.'))
				{
					// the names clash
					gpApp->m_acceptedFilesList.Clear();
					return TRUE;
				}
			}
			else
			{
				// BEW changed 26Apr10, (to include a 'shorter' option) same length or
				// shorter; if equal then this is a clash and we'll return TRUE and give a
				// beep as well; but if shorter, then it's a different name & we'll accept
				// it by falling through and returning FALSE
				if (docNameLen == len)
				{
					// it's the same name
					::wxBell();
					gpApp->m_acceptedFilesList.Clear();
					return TRUE;
				}
			}
		}
	}
	gpApp->m_acceptedFilesList.Clear();
	return FALSE;
}

///////////////////////////////////////////////////////////////////////////////
/// \return		a pointer to the USFMAnalysis struct associated with the marker at pChar,
///				or NULL if the marker was not found in the MapSfmToUSFMAnalysisStruct.
/// \param		pChar	-> a pointer to the first character of the marker in the
///                        buffer (a backslash)
/// \remarks
/// Called from: the Doc's ParseWord(), IsMarker(), TokenizeText(), DoMarkerHousekeeping(),
/// IsEndMarkerForTextTypeNone(), the View's InsertNullSourcePhrase(),
/// Determines the marker pointed to at pChar and performs a look up in the
/// MapSfmToUSFMAnalysisStruct hash map. If the marker has an association in the map it
/// returns a pointer to the USFMAnalysis struct. NULL is returned if no marker could be
/// parsed from pChar, or if the marker could not be found in the hash map.
/// BEW 24Oct14 changes needed for support of USFM nested markers
/// whm 23Sep2023 removed the block forcing values for marker "fig". The attribute 
/// values for the \fig marker need to be specified within the AI_USFM.xml control 
/// file rather than the LookupSFM() functions - which I have done as of this date.
/// Note also that the navigationText was already "figure" in AI_USFM.xml which I 
/// think is better than "illustration" below - being shorter for use as navigation 
/// text and, more mnemonic for association with the \fig marker.
///////////////////////////////////////////////////////////////////////////////
USFMAnalysis* CAdapt_ItDoc::LookupSFM(wxChar* pChar)
{
	// Looks up the sfm pointed at by pChar
	// Returns a USFMAnalysis struct filled out with attributes
	// if the marker is found in the appropriate map, otherwise
	// returns NULL.
	// whm ammended 11July05 to return the \bt USFM Analysis struct whenever
	// any bare marker of the form bt... exists at pChar
	wxChar* ptr = pChar;
	bool bFound = FALSE;
	// get the bare marker
	wxString bareMkr = GetBareMarkerForLookup(ptr);
	// look up and Retrieve the USFMAnalysis into our local usfmAnalysis struct
	// variable.
	// If bareMkr begins with bt... we will simply use bt which will return the
	// USFMAnalysis struct for \bt for all back-translation markers based on \bt...
	if (bareMkr.Find(_T("bt")) == 0)
	{
		// bareMkr starts with bt... so shorten it to simply bt for lookup purposes
		bareMkr = _T("bt");
	}
	// BEW 24Oct14, add support here for USFM nested markers, these are of form \+tag
	// so for any such, we have to extract the tag so as to be able to lookup the
	// appropriate struct
	bool bIsNestedMkr = FALSE;
	bool bIsWholeMkr = FALSE;
	wxString baseOfEndMkr;
	wxString theTag; theTag.Empty();
	bIsNestedMkr = IsNestedMarkerOrMarkerTag(&bareMkr, theTag, baseOfEndMkr, bIsWholeMkr);
	wxUnusedVar(bIsNestedMkr); // here we don't need the boolean returned, we just want a lookup
	if (baseOfEndMkr.IsEmpty())
	{
		bareMkr = theTag; // it was not an endmarker
	}
	else
	{
		bareMkr = baseOfEndMkr; // it was an endmarker
	}
	MapSfmToUSFMAnalysisStruct::iterator iter;
	// The particular MapSfmToUSFMAnalysisStruct used for lookup below depends the appropriate
	// sfm set being used as stored in gCurrentSfmSet enum.
	switch (gpApp->gCurrentSfmSet)
	{
	case UsfmOnly:
	{
		iter = gpApp->m_pUsfmStylesMap->find(bareMkr);
		bFound = (iter != gpApp->m_pUsfmStylesMap->end());
	}
		break;
	case PngOnly:
	{
		iter = gpApp->m_pPngStylesMap->find(bareMkr);
		bFound = (iter != gpApp->m_pPngStylesMap->end());
	}
		break;
	case UsfmAndPng:
	{
		iter = gpApp->m_pUsfmAndPngStylesMap->find(bareMkr);
		bFound = (iter != gpApp->m_pUsfmAndPngStylesMap->end());
	}
		break;
	default:
	{
		iter = gpApp->m_pUsfmStylesMap->find(bareMkr);
		bFound = (iter != gpApp->m_pUsfmStylesMap->end());
	}
	} // end o fo switch (gpApp->gCurrentSfmSet)

	if (bFound)
	{
		// iter->second points to the USFMAnalysis struct

		// BEW 30Sep19 alter some of \fig's attributes, so in USFM3 we can show it's
		// unfiltered caption string with navtext and m_bSpecialText colouring
		USFMAnalysis* pUsfmAnalyis = iter->second;
		wxString bareMkr = pUsfmAnalyis->marker;
		// whm 23Sep2023 removed the following block for marker "fig" that forces the 
		// attribute values locally here. The \fig marker's attributes need to be 
		// specified within the AI_USFM.xml control file, rather than here - which I 
		// have done as of this date.
		// Note also that the navigationText was already "figure" in AI_USFM.xml which I 
		// think is better than "illustration" below - being shorter for use as navigation 
		// text and, more mnemonic for association with the \fig marker for users.
		/*
		if (bareMkr == _T("fig"))
		{
			pUsfmAnalyis->special = TRUE;
			pUsfmAnalyis->bdryOnLast = TRUE;
			pUsfmAnalyis->inform = TRUE;
			pUsfmAnalyis->navigationText = _T("illustration");
		}
		*/
		return pUsfmAnalyis;
	}
	else
	{
		return (USFMAnalysis*)NULL;
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \return		a pointer to the USFMAnalysis struct associated with the marker at pChar,
///				or NULL if the marker was not found in the MapSfmToUSFMAnalysisStruct.
/// \param		pChar	      -> a pointer to the first character of the marker in the
///                              buffer (a backslash)
/// \param      tagOnly       <- Whether \tag or \+tag or tag or +tag was passed in, it
///                              returns the tag string here (it may have * at its end)
/// \param      baseOfEndMkr  <- If an endmarker was passed in, it is the tagOnly without the
///                              final * character; if not an endmarker passed in, then
///                              empty string is returned (This can be used as a defacto
///                              test of whether what was passed in was an endmarker or
///                              from an endmarker.)
/// \param      bIsNestedMkr  <- TRUE if of form \+tag, FALSE if of form \tag
/// \remarks
/// Called from: the Doc's ParseWord(), IsMarker(), TokenizeText(), DoMarkerHousekeeping(),
/// IsEndMarkerForTextTypeNone(), the View's InsertNullSourcePhrase(),
/// Determines the marker pointed to at pChar and performs a look up in the
/// MapSfmToUSFMAnalysisStruct hash map. If the marker has an association in the map it
/// returns a pointer to the USFMAnalysis struct. NULL is returned if no marker could be
/// parsed from pChar, or if the marker could not be found in the hash map.
/// BEW 24Oct14 variant useful for support of USFM nested markers, used in ParseWord()
/// whm 23Sep2023 removed the block forcing values for marker "fig". The attribute 
/// values for the \fig marker need to be specified within the AI_USFM.xml control 
/// file rather than the LookupSFM() functions - which I have done as of this date.
/// Note also that the navigationText was already "figure" in AI_USFM.xml which I 
/// think is better than "illustration" below - being shorter for use as navigation 
/// text and, more mnemonic for association with the \fig marker.
///////////////////////////////////////////////////////////////////////////////
USFMAnalysis* CAdapt_ItDoc::LookupSFM(wxChar* pChar, wxString& tagOnly,
	wxString& baseOfEndMkr, bool& bIsNestedMkr)
{
	// Looks up the sfm pointed at by pChar
	// Returns a USFMAnalysis struct filled out with attributes
	// if the marker is found in the appropriate map, otherwise
	// returns NULL.
	// whm ammended 11July05 to return the \bt USFM Analysis struct whenever
	// any bare marker of the form bt... exists at pChar
	wxChar* ptr = pChar;
	bool bFound = FALSE;
	// BEW 9Nov16, There is a years-old error below. bareMkr should NEVER be what
	// is passed to IsNestedMarkerOrMarkerTag() below, because GetBareMarkerForLookup()
	// strips not just the \ and any *, but also the + of a nested marker, and so the
	// function below would, for a \+it marker, return bIsNested set incorrectly to
	// FALSE. So the safe thing to do is to pass it the whole marker.
	wxString aWholeMkr = GetWholeMarker(pChar);
	// get the bare marker
	wxString bareMkr = GetBareMarkerForLookup(ptr);
	// look up and Retrieve the USFMAnalysis into our local usfmAnalysis struct
	// variable.
	// If bareMkr begins with bt... we will simply use bt which will return the
	// USFMAnalysis struct for \bt for all back-translation markers based on \bt...
	if (bareMkr.Find(_T("bt")) == 0)
	{
		// bareMkr starts with bt... so shorten it to simply bt for lookup purposes
		bareMkr = _T("bt");
	}
	// BEW 24Oct14, add support here for USFM nested markers, these are of form \+tag
	// so for any such, we have to extract the tag so as to be able to lookup the
	// appropriate struct, and if a USFM endmarker, remove the * at the end
	bIsNestedMkr = FALSE; // initialize
	bool bIsWholeMkr = FALSE;  // initialize
	wxString theTag; theTag.Empty(); // initialize
	tagOnly.Empty(); baseOfEndMkr.Empty(); // initialize both
	bIsNestedMkr = IsNestedMarkerOrMarkerTag(&aWholeMkr, tagOnly, baseOfEndMkr, bIsWholeMkr);
	wxUnusedVar(bIsWholeMkr);
	if (baseOfEndMkr.IsEmpty())
	{
		bareMkr = tagOnly;
	}
	else
	{
		bareMkr = baseOfEndMkr;
	}
	MapSfmToUSFMAnalysisStruct::iterator iter;
	// The particular MapSfmToUSFMAnalysisStruct used for lookup below depends the appropriate
	// sfm set being used as stored in gCurrentSfmSet enum.
	switch (gpApp->gCurrentSfmSet)
	{
	case UsfmOnly:
	{
		iter = gpApp->m_pUsfmStylesMap->find(bareMkr);
		bFound = (iter != gpApp->m_pUsfmStylesMap->end());
	}
		break;
	case PngOnly:
	{
		iter = gpApp->m_pPngStylesMap->find(bareMkr);
		bFound = (iter != gpApp->m_pPngStylesMap->end());
	}
		break;
	case UsfmAndPng:
	{
		iter = gpApp->m_pUsfmAndPngStylesMap->find(bareMkr);
		bFound = (iter != gpApp->m_pUsfmAndPngStylesMap->end());
	}
		break;
	default:
	{
		iter = gpApp->m_pUsfmStylesMap->find(bareMkr);
		bFound = (iter != gpApp->m_pUsfmStylesMap->end());
	}
	} // end of switch (gpApp->gCurrentSfmSet)

	if (bFound)
	{
		// iter->second points to the USFMAnalysis struct

		// BEW 30Sep19 alter some of \fig's attributes, so in USFM3 we can show it's
		// unfiltered caption string with navtext and m_bSpecialText colouring
		USFMAnalysis* pUsfmAnalyis = iter->second;
		wxString bareMkr = pUsfmAnalyis->marker;
		// whm 23Sep2023 removed the following block for marker "fig" that forces the 
		// attribute values locally here. The \fig marker's attributes need to be 
		// specified within the AI_USFM.xml control file, rather than here - which I 
		// have done as of this date.
		// Note also that the navigationText was already "figure" in AI_USFM.xml which I 
		// think is better than "illustration" below - being shorter for use as navigation 
		// text and, more mnemonic for association with the \fig marker for users.
		/*
		if (bareMkr == _T("fig"))
		{
			pUsfmAnalyis->special = TRUE;
			pUsfmAnalyis->bdryOnLast = TRUE;
			pUsfmAnalyis->inform = TRUE;
			pUsfmAnalyis->navigationText = _T("illustration");
		}
		*/
		return pUsfmAnalyis;
	}
	else
	{
		return (USFMAnalysis*)NULL;
	}
}



///////////////////////////////////////////////////////////////////////////////
/// \return		a pointer to the USFMAnalysis struct associated with the bareMkr,
///				or NULL if the marker was not found in the MapSfmToUSFMAnalysisStruct.
/// \param		bareMkr	-> a wxString containing the bare marker to use in the lookup
/// \remarks
/// Called from: the Doc's ReconstituteAfterFilteringChange(), ParseFilteringSFM(),
/// GetUnknownMarkersFromDoc(), AnalyseMarker(), IsEndingSrcPhrase(),
/// ContainsMarkerToBeFiltered(), RedoNavigationText(), DoExportInterlinearRTF(),
/// IsFreeTranslationEndDueToMarker(), HaltCurrentCollection(), ParseFootnote(),
/// ParseEndnote(), ParseCrossRef(), ParseMarkerAndAnyAssociatedText(),
/// GetMarkerInventoryFromCurrentDoc(), MarkerTakesAnEndMarker(),
/// CViewFilteredMaterialDlg::GetAndShowMarkerDescription().
/// Looks up the bareMkr in the MapSfmToUSFMAnalysisStruct hash map. If the marker has an
/// association in the map it returns a pointer to the USFMAnalysis struct. NULL is
/// returned if the marker could not be found in the hash map.
/// BEW 10Apr10, no changes for support of doc version 5
/// BEW 24Oct14 changes needed for support of USFM nested markers. LookupSFM() does
/// not try to lookup endmarkers, it is intended that TokenizeText() - which calls it,
/// handles the begin markers, and then passes off parsing the word and any endmarkers
/// to ParseWord() - so we don't bother in LookupSFM() to determine if a marker is
/// an endmarker, because it should never encounter any.
/// BEW 24Oct14 refactored for support of USFM nested markers
/// whm 23Sep2023 removed the block forcing values for marker "fig". The attribute 
/// values for the \fig marker need to be specified within the AI_USFM.xml control 
/// file rather than the LookupSFM() functions - which I have done as of this date.
/// Note also that the navigationText was already "figure" in AI_USFM.xml which I 
/// think is better than "illustration" below - being shorter for use as navigation 
/// text and, more mnemonic for association with the \fig marker.
///////////////////////////////////////////////////////////////////////////////
USFMAnalysis* CAdapt_ItDoc::LookupSFM(wxString bareMkr)
{
	// overloaded version of the LookupSFM above to take bare marker
	// Looks up the bareMkr CString sfm in the appropriate map
	// Returns a USFMAnalysis struct filled out with attributes
	// if the marker is found in the appropriate map, otherwise
	// returns NULL.
	// whm ammended 11July05 to return the \bt USFM Analysis struct whenever
	// any bare marker of the form bt... is passed in
	if (bareMkr.IsEmpty())
		return (USFMAnalysis*)NULL;
	bool bFound = FALSE;
	// look up and Retrieve the USFMAnalysis into our local usfmAnalysis struct
	// variable.
	// If bareMkr begins with bt... we will simply use bt which will return the
	// USFMAnalysis struct for \bt for all back-translation markers based on \bt...
	if (bareMkr.Find(_T("bt")) == 0)
	{
		// bareMkr starts with bt... so shorten it to simply bt for lookup purposes
		bareMkr = _T("bt"); // bareMkr is value param so only affects local copy
	}
	// BEW 24Oct14, add support here for USFM nested markers, these are of form \+tag
	// so for any such, we have to extract the tag so as to be able to lookup the
	// appropriaate struct
	bool bIsNestedMkr = FALSE;
	bool bIsWholeMkr = FALSE;
	wxString tagOnly; tagOnly.Empty();
	wxString baseOfEndMkr;
	bIsNestedMkr = IsNestedMarkerOrMarkerTag(&bareMkr, tagOnly, baseOfEndMkr, bIsWholeMkr);
	wxUnusedVar(bIsNestedMkr);
	if (baseOfEndMkr.IsEmpty())
	{
		bareMkr = tagOnly;
	}
	else
	{
		bareMkr = baseOfEndMkr;
	}
	MapSfmToUSFMAnalysisStruct::iterator iter;
	// The particular MapSfmToUSFMAnalysisStruct used for lookup below depends the
	// appropriate sfm set being used as stored in gCurrentSfmSet enum.
	switch (gpApp->gCurrentSfmSet)
	{
	case UsfmOnly:
	{
		iter = gpApp->m_pUsfmStylesMap->find(bareMkr);
		bFound = (iter != gpApp->m_pUsfmStylesMap->end());
	}
		break;
	case PngOnly:
	{
		iter = gpApp->m_pPngStylesMap->find(bareMkr);
		bFound = (iter != gpApp->m_pPngStylesMap->end());
	}
		break;
	case UsfmAndPng:
	{
		iter = gpApp->m_pUsfmAndPngStylesMap->find(bareMkr);
		bFound = (iter != gpApp->m_pUsfmAndPngStylesMap->end());
	}
		break;
	default:
	{
		iter = gpApp->m_pUsfmStylesMap->find(bareMkr);
		bFound = (iter != gpApp->m_pUsfmStylesMap->end());
	}
	} // end of switch (gpApp->gCurrentSfmSet)

	if (bFound)
	{
		// iter->second points to the USFMAnalysis struct

		// BEW 30Sep19 alter some of \fig's attributes, so in USFM3 we can show it's
		// unfiltered caption string with navtext and m_bSpecialText colouring
		USFMAnalysis* pUsfmAnalyis = iter->second;
		wxString bareMkr = pUsfmAnalyis->marker;
		// whm 23Sep2023 removed the following block for marker "fig" that forces the 
		// attribute values locally here. The \fig marker's attributes need to be 
		// specified within the AI_USFM.xml control file, rather than here - which I 
		// have done as of this date.
		// Note also that the navigationText was already "figure" in AI_USFM.xml which I 
		// think is better than "illustration" below - being shorter for use as navigation 
		// text and, more mnemonic for association with the \fig marker for users.
		/*
		if (bareMkr == _T("fig"))
		{
			pUsfmAnalyis->special = TRUE;
			pUsfmAnalyis->bdryOnLast = TRUE;
			pUsfmAnalyis->inform = TRUE;
			pUsfmAnalyis->navigationText = _T("illustration");
		}
		*/
		return pUsfmAnalyis;
	}
	else
	{
		return (USFMAnalysis*)NULL;
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \return		TRUE if the passed-in marker unkMkr exists in any element of the pUnkMarkers
///				array, FALSE otherwise
/// \param		pUnkMarkers		-> a pointer to a wxArrayString that contains a list of
///									markers
/// \param		unkMkr			-> the whole marker being checked to see if it exists
///                                in pUnkMarkers
/// \param		MkrIndex		<- the index into the pUnkMarkers array if unkMkr is
///                                found, otherwise -1
/// \remarks
/// Called from: the Doc's RestoreDocParamsOnInput(), GetUnknownMarkersFromDoc(),
/// CFilterPageCommon::AddUnknownMarkersToDocArrays().
/// Determines if a standard format marker (whole marker including backslash) exists in any
/// element of the array pUnkMarkers.
/// If the whole marker exists, the function returns TRUE and the array's index where the
/// marker was found is returned in MkrIndex. If the marker doesn't exist in the array
/// MkrIndex returns -1.
/// BEW 24Oct14 no changes needed for support of USFM nested markers (note, coding logic
/// errors leading to a nested marker being unrecognised as a USFM would cause the nested
/// marker to end up in pUnkMarkers probably - and be marked as ??\+tag?? in the view)
///////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItDoc::MarkerExistsInArrayString(wxArrayString* pUnkMarkers,
	wxString unkMkr, int& MkrIndex)
{
	// returns TRUE if the passed-in marker unkMkr already exists in the pUnkMarkers
	// array. MkrIndex is the index of the marker returned by reference.
	int ct;
	wxString arrayStr;
	MkrIndex = -1;
	for (ct = 0; ct < (int)pUnkMarkers->GetCount(); ct++)
	{
		arrayStr = pUnkMarkers->Item(ct);
		if (arrayStr.Find(unkMkr) != -1)
		{
			MkrIndex = ct;
			return TRUE;
		}
	}
	// if we get to here we didn't find unkMkr in the array;
	// MkrIndex is still -1 and return FALSE
	return FALSE;
}

///////////////////////////////////////////////////////////////////////////////
/// \return		TRUE if the passed-in marker wholeMkr exists in MarkerStr, FALSE otherwise
/// \param		MarkerStr	-> a wxString to be examined
/// \param		wholeMkr	-> the whole marker being checked to see if it exists in MarkerStr
/// \param		markerPos	<- the index into the MarkerStr if wholeMkr is found, otherwise -1
/// \remarks
/// Called twice, but only from: the App's SetupMarkerStrings().
/// Determines if a standard format marker (whole marker including backslash) exists in a
/// given string. If the whole marker exists, the function returns TRUE and the zero-based
/// index into MarkerStr is returned in markerPos. If the marker doesn't exist in the
/// string markerPos returns -1.
/// BEW 24Oct14, the SetupMarkerStrings() calling function builds rapid access wxString
/// marker collections based on the marker definitions in the m_pUsfmAndPngStylesMap, and so
/// knows nothing about USFM nested markers. So, to support USFM nested markers here, nothing
/// needs to be done. We do have rapid access strings not constructed from m_pUsfmAndPngStylesMap,
/// and for those, markes of form \+tag are included when appropriate (that is, only for
/// inline binding and nonbinding markers) - so for those a Find() operation is appropriate,
/// but for the strings made by SetupMarkerStrings(), a Find() should only be done after
/// the tag of a \+tag structured marker has been extracted, and the appropriate equivalent
/// unnested marker form (i.e. \tag ) reconstructed for the Find() lookup.
///////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItDoc::MarkerExistsInString(wxString MarkerStr, wxString wholeMkr, int& markerPos)
{
	// returns TRUE if the passed-in marker wholeMkr already exists in the string of
	// markers MarkerStr. markerPos is the position of the wholeMkr in MarkerStr returned
	// by reference.
	markerPos = MarkerStr.Find(wholeMkr);
	if (markerPos != -1)
		return TRUE;
	// if we get to here we didn't find wholeMkr in the string MarkerStr, so markerPos is
	// -1 and return FALSE
	return FALSE;
}

///////////////////////////////////////////////////////////////////////////////
/// \return		TRUE if the pUsfmAnalysis represents a filtering marker by default
///				FALSE otherwise. Note this return value DOES NOT indicate what the
///				current filtering status of a marker is, only what its DEFAULT value
///				is as indicated in the AI_USFM.xml control file.
/// \param		pUsfmAnalysis	-> a pointer to a USFMAnalysis struct
/// \remarks
/// Called from: the Doc's TokenizeText().
/// Determines if a USFMAnalysis struct indicates that the associated standard format marker
/// is a filtering marker.
/// Prior to calling IsAFilteringSFM, the caller should have called LookupSFM(wxChar* pChar)
/// or LookupSFM(wxString bareMkr) to populate the pUsfmAnalysis struct, which should then
/// be passed to this function.
/// BEW 24Oct14, no changes for support of USFM nested markers
/// whm 24Oct2023 removed this IsAFilteringSFM() from active use since it has been mis-used
/// due to a mis-understanding. The value returned by this function DOES NOT reliably indicate 
/// the current filtering status of the marker whose properties were determined by a 
/// prior call of LookupSFM(). It only indicates relaibly what the default filter="0" or 
/// filter="1" settings are within the AI_USFM.xml control file. 
/// The most reliable method is by examining whether the sfm marker exists within the 
/// gCurrentFilterMarkers string to determine the current filtering status of a marker.
///////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItDoc::IsAFilteringSFM(USFMAnalysis* pUsfmAnalysis)
{
	// whm added 10Feb2005 in support of USFM and SFM Filtering support
	// whm removed 2nd parameter 9Jun05
	// Prior to calling IsAFilteringSFM, the caller should have called LookupSFM(TCHAR
	// *pChar) or LookupSFM(CString bareMkr) to determine pUsfmAnalysis which should then
	// be passed to this function.

	// Determine the filtering state of the marker
	if (pUsfmAnalysis != NULL)
	{
		// we have a known marker so return its DEFALUT filter status from the USFMAnalysis
		// struct found by previous call to LookupSFM().
		// WARNING: The pUsfmAnalysis->filter property below comes from the AI_USFM.xml 
		// control file and DOES NOT indicate the current filtering status of any USFM 
		// maker!! To get the current filtering status of a USFM marker you must examing 
		// the App's gCurrentFilterMarkers string.
		return (bool)pUsfmAnalysis->filter;
	}
	else
	{
		// the passed in pUsfmAnalysis was NULL so
		return FALSE;
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \return		TRUE if unkMkr is both an unknown marker and it also is designated as a
///				filtering marker, FALSE otherwise.
/// \param		unkMkr	-> a bare marker (without a backslash)
/// \remarks
/// Called from: the Doc's AnalyseMarker(), RedoNavigationText().
/// Determines if a marker is both an unknown marker and it also is designated as a
/// filtering marker.
/// unkMKr should be an unknown marker in bare form (without backslash)
/// Returns TRUE if unkMKr exists in the m_unknownMarkers array, and its filter flag
/// in m_filterFlagsUnkMkrs is TRUE.
/// BEW 24Oct14, no changes for support of USFM nested markers. A nested marker always has
/// an known (to the USFM standard) unnested marker associated with it. So if our
/// application's logic handles nested markers correctly, they should never be mistakenly
/// be "unknown", but if one becomes unknown, it will be shown between ?? ?? in the view's
/// whiteboard area - and so would signal that I've some wrong logic which I need to fix.
/// So the appropriate thing to do here is to allow unknown markers with + as their initial
/// character to be treated as unknowns. So make no changes herein.
///////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItDoc::IsAFilteringUnknownSFM(wxString unkMkr)
{
	// unkMKr should be an unknown marker in bare form (without backslash)
	// Returns TRUE if unkMKr exists in the m_unknownMarkers array, and its filter flag
	// in m_filterFlagsUnkMkrs is TRUE.
	int ct;
	unkMkr = gSFescapechar + unkMkr; // add the backslash
	for (ct = 0; ct < (int)gpApp->m_unknownMarkers.GetCount(); ct++)
	{
		if (unkMkr == gpApp->m_unknownMarkers.Item(ct))
		{
			// we've found the unknown marker so check its filter status
			if (gpApp->m_filterFlagsUnkMkrs.Item(ct) == TRUE)
				return TRUE;
		}
	}
	// the unknown marker either wasn't found (an error), or wasn't flagged to be filtered, so
	return FALSE;
}

// BEW 20Oct22 get count of characters from a wrapper character, ( or [ or { , halting when
// pointing at the first following whitespace, or at pEnd if no whites follow. Use this to
// determine a halting place when the input source text being parsed has a missing ) or ] or
// } character. The idea is to provide the missing closing wrapper character prior to the first
// space, to "heal" this kind of data glitch on the user's behalf. It probably would heal most
// such situations, where the missing halter causes one or more extra pSrcPhrase instances to
// appear in the source text, contaianing stuff from what the closing wrapper should have 
// enclosed. Data like    "word(data1 data2)" but the loaded source text has "word(data1 data2"
// instead. For such data, often there is no data2 word or more, just "word(data1"<space>, so
// knowing where that <space> is allows me to put a closing ) or } or ] before it. Then
// the message from something like: IsClosedParenthesisAhead() below can tell the user about
// the healing. If there is a closing wrapper, and data2, data3 not enclosed, editing the 
// source text in the running AI, and moving such words into the wrapped section may allow
// a simple doc fix, once the warning has been seen.
// pChar  ->, must point at ( or } or [
// counter <-, counts including the opening wrapper char, up to but not inclusing the next whitespace
// pEnd   ->, end of document
// return 0 if fails, but the num whitespace chars if scans to one, or to pEnd
void  CAdapt_ItDoc::GetLengthToWhitespace(wxChar* pChar, unsigned int& counter, wxChar* pEnd)
{
	wxChar* ptr = pChar; // initialise
	wxChar openParen = _T('(');
	wxChar openBrace = _T('{');
	wxChar openBracket = _T('[');
	counter = 0; // initialise
	// Sanity check
	if ( !((*ptr == openParen) || (*ptr == openBrace) || (*ptr == openBracket)) )
	{
		return;
	}
	ptr++;
	counter++; // get past the initial wrapper character
	while (!IsWhiteSpace(ptr) && (ptr < pEnd))
	{
		ptr++;
		counter++;
	}
	return;
}

// BEW 18Oct22 added, in support of parsing data like "word(singular person)" The returned
// count value will be the count of all wxChars sanned over, including the initial '(' but
// excluding the closing ')'. If the user's document contains '(' but does not close it off
// with a ')' matching the halt criterion (see comment after bGoodParse below), then we
// return FALSE, without moving pChar forward. I have included a hack to programmatically
// add a closing ), and giving the user an informative message. Remember, when moving the
// the phrasebox on while adapting, ParseWord() gets called within RemovePunctuation(),
// acting on a temporary pSrcPhrase on heap, with its m_nSequNumber set to zero. So when
// IsClosedParenthesisAhead() returns false, control in the caller enters the else block,
// and that's where the programmatic addition of ) happens; but if the sequ number is
// 0, (indicating control is in RemovePunctuation()'s call of ParseWord()) then that
// else block is skipped - as it does nothing useful since that pSrcPhrase is deleted
// before RemovePunctuation() exits
bool CAdapt_ItDoc::IsClosedParenthesisAhead(wxChar* pChar, unsigned int& count, wxChar* pEnd, CSourcePhrase* pSrcPhrase, bool& bTokenizingTargetText)
{
	wxChar* ptr = pChar; // initialise
	wxChar closeParen = _T(')');
	wxChar openParen = _T('(');
	//wxChar space = _T(' '); //assuming Latin space suffices, Asian languages using zwsp 
							// unlikely to have text data enclosed in ( and ), and even
							// if they did, the function would scan over zwsp just fine
	wxASSERT(*ptr == openParen); // gotta start at the open parenthesis
	count = 0;
	unsigned int max = 99;
	unsigned int nCountToWhitespace = 0; // initialise
	unsigned int distance = 0;
	bool bGoodParse = TRUE; // inintialise
	// We scan forward for the halt condition. We don't assume it will be at the first
	// space, or any space for that matter. We halt when ptr points at ')' AND that
	// *(ptr + 1) points at space (probably use IsWhiteSpace() for that test, as it's
	// to be the separation whitespace between the current pSrcPhrase and the next)
	// If, while scanning, ptr points at another openParen before the halt condition is
	// satisfied, then the parse fails.

	// How many chars are available between ptr and pEnd?
	distance = (unsigned int)(pEnd - ptr);
	// get past the opening '('
	ptr++;
	count++;
	while ( (ptr < pEnd) && (*ptr != closeParen) )
	{
		ptr++;
		count++;
		// adjust the max distance, if it exceed the number of chars available ahead
		if (max > distance)
		{
			max = distance;
		}
		if ((*ptr == openParen) || (count > max) || (ptr == pEnd))
		{
			// Try a healing hack, on the assumption that usually the word following the
			// opening '(' is what should have been closed off with a missing ')'
			wxChar* ptr2 = pChar;
			GetLengthToWhitespace(ptr2, nCountToWhitespace, pEnd);
			if (nCountToWhitespace == 0)
			{
				// Hopefully control will never enter here
				wxString title = _("Caution: maybe location lacks closing parenthesis )");
				wxString msg;
				msg = msg.Format(_("Function: %s(): At source word: %s , the text in (...) was too long (max 99), or a closing ) is missing, or document end reached. Adapt It will keep running."),
					__FUNCTION__, pSrcPhrase->m_key.c_str());
				// Don't show the message box, if pSrcPhrase has sn = 0, as is the case when ParseWord()
				// is called in RemovePunctuation(), working on target text, not src text
				if (!(pSrcPhrase->m_nSequNumber == 0 && bTokenizingTargetText == TRUE))
				{
					wxMessageBox(msg, title, wxICON_EXCLAMATION | wxOK);
					gpApp->LogUserAction(msg);
				}
				count = 0; // this keeps ParseWord() from advancing pChar past the '('
				return FALSE;
			}
			else
			{
				// characters were parsed over, so return  count = nCountToWhitespace, then after
				// showing the message below, return FALSE. The caller should then check for FALSE,
				// and if the count value returned is > 0, add a closing '}' character to m_follPunct,
				// and make sure m_srcPhrase will display correctly due to this hack; and do so
				// without advancing ptr, and then return ptr and updated len to TokenizeText immediately
				count = nCountToWhitespace;

				wxString title = _("Warning: a closing ) character was missing");
				wxString msg;
				msg = msg.Format(_("Function: %s(): At source word: %s , a closing parenthesis ) was inserted by Adapt It preceding the next space character. You might need to edit the source text."),
					__FUNCTION__, pSrcPhrase->m_key.c_str());
				// Don't show the message box, if pSrcPhrase has sn = 0, as is the case when ParseWord()
				// is called in RemovePuntuation(), working on target text, not src text
				if (!(pSrcPhrase->m_nSequNumber == 0 && bTokenizingTargetText == TRUE))
				{
					wxMessageBox(msg, title, wxICON_EXCLAMATION | wxOK);
					gpApp->LogUserAction(msg);
				}
				return FALSE;

			} // end of else block for test: if (nLengthToWhitespace == 0)
		}
		// To exit from the loop, ptr should be pointing at ')', so check if the char after
		// ')' is a whitespace, if so the exit the loop - the halt condition is satisfied
		if ((*ptr == closeParen) && IsWhiteSpace(ptr + 1))
		{
			break;
		}
	}
	return bGoodParse;
}

// BEW 21Oct22 added, in support of parsing data like "word{singular person}" The returned
// count value will be the count of all wxChars sanned over, including the initial '{' but
// excluding the closing '}'. If the user's document contains '{' but does not close it off
// with a '}' matching the halt criterion (see comment after bGoodParse below), then we
// return FALSE, without moving pChar forward. I have included a hack to programmatically
// add a closing }, and giving the user an informative message. Remember, when moving the
// the phrasebox on while adapting, ParseWord() gets called within RemovePunctuation(),
// acting on a temporary pSrcPhrase on heap, with its m_nSequNumber set to zero. So when
// IsClosedParenthesisAhead() returns false, control in the caller enters the else block,
// and that's where the programmatic addition of } happens; but if the sequ number is
// 0, (indicating control is in RemovePunctuation()'s call of ParseWord()) then that
// else block is skipped - as it does nothing useful since that pSrcPhrase is deleted
// before RemovePunctuation() exits
bool CAdapt_ItDoc::IsClosedBraceAhead(wxChar* pChar, unsigned int& count, wxChar* pEnd, CSourcePhrase* pSrcPhrase, bool& bTokenizingTargetText)
{
	wxChar* ptr = pChar; // initialise
	wxChar closeBrace = _T('}');
	wxChar openBrace = _T('{');
	//wxChar space = _T(' '); //assuming Latin space suffices, Asian languages using zwsp 
							// unlikely to have text data enclosed in { and }, and even
							// if they did, the function would scan over zwsp just fine
	wxASSERT(*ptr == openBrace); // gotta start at the open brace
	count = 0;
	unsigned int max = 99;
	unsigned int nCountToWhitespace = 0; // initialise
	unsigned int distance = 0;
	bool bGoodParse = TRUE; // inintialise
	// We scan forward for the halt condition. We don't assume it will be at the first
	// space, or any space for that matter. We halt when ptr points at '}' AND that
	// *(ptr + 1) points at space (probably use IsWhiteSpace() for that test, as it's
	// to be the separation whitespace between the current pSrcPhrase and the next)
	// If, while scanning, ptr points at another openBrace before the halt condition is
	// satisfied, then the parse fails.
	ptr++;
	count++; // get past the initial '('
	while ((*ptr != closeBrace) && (ptr < pEnd))
	{
		ptr++;
		count++;

		// How many chars are available between ptr and pEnd?
		distance = (unsigned int)(pEnd - ptr) - 1;
		if (max > distance)
		{
			max = distance;
		}
		if ((*ptr == openBrace) || (count > max) || (ptr == pEnd))
		{
			// Try a healing hack, on the assumption that usually the word following the
			// opening '{' is what should have been closed off with a missing '}'
			wxChar* ptr2 = pChar;
			GetLengthToWhitespace(ptr2, nCountToWhitespace, pEnd);
			if (nCountToWhitespace == 0)
			{
				// Hopefully control will never enter here
				wxString title = _("Caution: maybe location lacks closing brace }");
				wxString msg;
				msg = msg.Format(_("Function: %s(): At source word: %s , the text in {...} was too long (max 99), or a closing } is missing, or document end reached. Adapt It will keep running."),
					__FUNCTION__, pSrcPhrase->m_key.c_str());
				// Don't show the message box, if pSrcPhrase has sn = 0, as is the case when ParseWord()
				// is called in RemovePuntuation(), working on target text, not src text
				if (!(pSrcPhrase->m_nSequNumber == 0 && bTokenizingTargetText == TRUE))
				{
					wxMessageBox(msg, title, wxICON_EXCLAMATION | wxOK);
					gpApp->LogUserAction(msg);
				}
				count = 0; // this keeps ParseWord() from advancing pChar past the '{'
				return FALSE;
			}
			else
			{
				// characters were parsed over, so return  count = nCountToWhitespace, then after
				// showing the message below, return FALSE. The caller should then check for FALSE,
				// and if the count value returned is > 0, add a closing '}' character to m_follPunct,
				// and make sure m_srcPhrase will display correctly due to this hack; and do so
				// without advancing ptr, and then return ptr and updated len to TokenizeText immediately
				count = nCountToWhitespace;

				wxString title = _("Warning: a closing } character was missing");
				wxString msg;
				msg = msg.Format(_("Function: %s(): At source word: %s , a closing brace } was inserted by Adapt It preceding the next space character. You might need to edit the source text."),
					__FUNCTION__, pSrcPhrase->m_key.c_str());
				// Don't show the message box, if pSrcPhrase has sn = 0, as is the case when ParseWord()
				// is called in RemovePuntuation(), working on target text, not src text
				if (!(pSrcPhrase->m_nSequNumber == 0 && bTokenizingTargetText == TRUE))
				{
					wxMessageBox(msg, title, wxICON_EXCLAMATION | wxOK);
					gpApp->LogUserAction(msg);
				}
				return FALSE;

			} // end of else block for test: if (nLengthToWhitespace == 0)
		}
		// To exit from the loop, ptr should be pointing at '}', so check if the char after
		// '}' is a whitespace, if so the exit the loop - the halt condition is satisfied
		if ((*ptr == closeBrace) && IsWhiteSpace(ptr + 1))
		{
			break;
		}
	}
	return bGoodParse;
}

// BEW 21Oct22 added, in support of parsing data like "word[singular person]" The returned
// count value will be the count of all wxChars sanned over, including the initial '[' but
// excluding the closing ']'. If the user's document contains '[' but does not close it off
// with a ']' matching the halt criterion (see comment after bGoodParse below), then we
// return FALSE, without moving pChar forward. I have included a hack to programmatically
// add a closing ], and giving the user an informative message. Remember, when moving the
// the phrasebox on while adapting, ParseWord() gets called within RemovePunctuation(),
// acting on a temporary pSrcPhrase on heap, with its m_nSequNumber set to zero. So when
// IsClosedBracketAhead() returns false, control in the caller enters the else block,
// and that's where the programmatic addition of ] happens; but if the sequ number is
// 0, (indicating control is in RemovePunctuation()'s call of ParseWord()) then that
// else block is skipped - as it does nothing useful since that pSrcPhrase is deleted
// before RemovePunctuation() exits
// Note, since this is almost identical to the two above, I've removed commenting
bool CAdapt_ItDoc::IsClosedBracketAhead(wxChar* pChar, unsigned int& count, wxChar* pEnd, CSourcePhrase* pSrcPhrase, bool& bTokenizingTargetText)
{
	wxChar* ptr = pChar;
	wxChar closeBracket = _T(']');
	wxChar openBracket = _T('[');
	wxASSERT(*ptr == openBracket);
	count = 0;
	unsigned int max = 99;
	unsigned int nCountToWhitespace = 0;
	unsigned int distance = 0;
	bool bGoodParse = TRUE;
	ptr++;
	count++;
	while ((*ptr != closeBracket) && (ptr < pEnd))
	{
		ptr++;
		count++;
		distance = (unsigned int)(pEnd - ptr) - 1;
		if (max > distance)
		{
			max = distance;
		}
		if ((*ptr == openBracket) || (count > max) || (ptr == pEnd))
		{
			wxChar* ptr2 = pChar;
			GetLengthToWhitespace(ptr2, nCountToWhitespace, pEnd);
			if (nCountToWhitespace == 0)
			{
				wxString title = _("Caution: maybe location lacks closing bracket ]");
				wxString msg;
				msg = msg.Format(_("Function: %s(): At source word: %s , the text in [...] was too long (max 99), or a closing ] is missing, or document end reached. Adapt It will keep running."),
					__FUNCTION__, pSrcPhrase->m_key.c_str());
				if (!(pSrcPhrase->m_nSequNumber == 0 && bTokenizingTargetText == TRUE))
				{
					wxMessageBox(msg, title, wxICON_EXCLAMATION | wxOK);
					gpApp->LogUserAction(msg);
				}
				count = 0;
				return FALSE;
			}
			else
			{
				count = nCountToWhitespace;
				wxString title = _("Warning: a closing ] character was missing");
				wxString msg;
				msg = msg.Format(_("Function: %s(): At source word: %s , a closing bracket ] was inserted by Adapt It preceding the next space character. You might need to edit the source text."),
					__FUNCTION__, pSrcPhrase->m_key.c_str());
				if (!(pSrcPhrase->m_nSequNumber == 0 && bTokenizingTargetText == TRUE))
				{
					wxMessageBox(msg, title, wxICON_EXCLAMATION | wxOK);
					gpApp->LogUserAction(msg);
				}
				return FALSE;

			}
		}
		if ((*ptr == closeBracket) && IsWhiteSpace(ptr + 1))
		{
			break;
		}
	}
	return bGoodParse;
}

int CAdapt_ItDoc::CountWhitesSpan(wxChar* pChar, wxChar* pEnd)
{
	int countWhites = 0;
	wxChar* pAux = pChar; // initialise
	// \r and \n are each whitespace characters, so for windows build, each gets counted
	while (IsWhiteSpace(pAux) && (pAux < pEnd))
	{
		countWhites++;
		pAux++;
	}
	return countWhites;
}

// BEW 5Nov20 added for ParseWord(): ptr-> points at ).<space>(<space>nxtwrd, 
// after parsing in TokeniseText() before dealing with following punctuations
// Without a block dedicated to identifying the first space as the word separator,
// the punctuation ").<space>(" wrongly ends up as following punctuation
bool CAdapt_ItDoc::IsOpenParenthesisAhead(wxChar* pChar, wxChar* pEnd)
{
	wxChar* ptr = pChar; // initialise
	wxChar closeParen = _T(')');
	wxChar openParen = _T('(');
	wxChar space = _T(' ');
	// If ptr is not pointing at ) then return FALSE
	if (*ptr != closeParen)
	{
		return FALSE;
	}
	if ((ptr + 1) < pEnd) // ensure there's room to find a ( ahead
	{
		ptr++; // point past the ) character
	}
	else
	{
		// No room
		return FALSE;
	}
	// We allow for a ( character to be as far as 3 characters further; if
	// it isn't found by then, return FALSE; if it is found then return TRUE,
	// but only provided intervening characters are each either a punctuation
	// character or a space.
	int offset = wxNOT_FOUND;
	offset = m_spacelessPuncts.Find(*ptr);
	if (offset == wxNOT_FOUND)
	{
		if (*ptr != space)
		{
			// ptr is not pointing at a punctuation character, nor space
			return FALSE;
		}
	}
	else
	{
		// Found a punctuation character, is it an open parenthesis?
		if (*ptr == openParen)
		{
			// Yes, there is one ahead of the passed in location
			return TRUE;
		}
	}

	// No success yet, so keep looking...
	if ((ptr + 1) < pEnd) // ensure there's room to find a ( ahead
	{
		ptr++;// ptr is now past, say, ). (two characters)
	}
	else
	{
		// No room
		return FALSE;
	}
	// What is at ptr location?
	offset = m_spacelessPuncts.Find(*ptr);
	if (offset == wxNOT_FOUND)
	{
		// ptr is not pointing at punctuation
		if (*ptr != space)
		{
			// ptr is not pointing at punctuation, nor a space
			return FALSE;
		}
	}
	else // ptr is pointing at a punctuation character. 
	{
		// Is it a ( character ?
		if (*ptr == openParen)
		{
			// Yep, there is a ( character ahead
			return TRUE;
		}
	}

	// No success yet, so keep looking...
	if ((ptr + 1) < pEnd) // ensure there's room to find a ( ahead
	{
		ptr++;// ptr is now past, say,<space> ). (three characters)
	}
	else
	{
		// No room
		return FALSE;
	}
	// One last shot... What is at ptr location?
	offset = m_spacelessPuncts.Find(*ptr);
	if (offset == wxNOT_FOUND)
	{
		// ptr is not pointing at punctuation [and ( is a punct char]
		if (*ptr != space)
		{
			// ptr is not pointing at punctuation, nor a space, nor (
			return FALSE;
		}
	}
	else // ptr is pointing at a punctuation character. 
	{
		// Is it a ( character ?
		if (*ptr == openParen)
		{
			// Yep, there is a ( character ahead
			return TRUE;
		}
	}
	// look no further - we assume there's no point in having a 
	// parse of )....( in a block, because we can't be sure that
	// there is an opening parenthesis ahead which makes certain
	// that the parser must call a halt to parsing between the
	// ) and following ( somewhere.
	// This function will be in the caller's test, and if it fails
	// then the block is skipped and legacy code will operate to
	// determine what's punctuation and where the word break will be	
	return FALSE;
}

// whm 16Feb2024 added to detect any old bar code formatting markers in texts that predate the full
// adoption of the USFM standard. We still have in our archives from 2021 Nyindrou SFM files that had
// used old bar codes - thousands of them. 
// While I think the Paratext repositories, and ebible.org website now probably have filtered out or
// converted old bar codes, it is possilbe that some users might try to load bar code laden files into
// Adapt It. 
// This function detects the presence of bar codes and, if a bar code is found, it returns TRUE, and
// also returns via its barCode reference parameter what bar code it found to the caller.
// The bar codes detected by this function and their Usfm equivalents (more or less) are:
// |b (bold) --> \bd 
// |i (italic) --> \it
// |sc (small caps) --> \sc
// |u (underline) --> \em - assuming anything underlined is for emphasis
// The usfm equivalent end markers should be returned when a particular bar code is canceled with |r:
// \bd* for when |r cancels a |b - after a \bd begin code
// \it* for when |r cancels a |i - - after a \it begin code
// \sc* for when |r cancels a |sc - after a \sc begin code
// \em* for when |r cancels a |u - after a \em begin code
// The new Usfm scheme also has a \no ... \no* for return to normal text - when multiple formatting is
// to be canceled at once. This however, I think is adequately covered by returning an end marker for
// when |r is encountered in the text.
// Note that the USFM standard also has a formatting markers for superscript \sup ...\sup* which didn't 
// exist as a bar code, and so we don't expect to see a bar code for that.
// A followup function ParseOldBarCodeAndReturnNewBarCode() can then be called which can automatically parse 
// the old bar code and return the usfm equivalent usfm code to the caller via its newUsfmCode 
// reference parameter.
// This function is primarily used in the ParseWord() function at the point that ParseWord() detects the
// presence of a bar '|' character at its pointer ptr.
// The old bar codes generally did not have spaces required after the bar code and might be used right in
// the middle of a word. This makes it a bit of a challenge for identifying a true bar code from other
// possible uses of a vertical bar character found within text material, espeically the use of the vertical
// bar character to separate text from meta data in attribute markers. To avoid confusing a vertical bar |
// with its use in attribute markers, we need to scan backwards to see if the vertical bar is within an
// attribute marker's span, that is if a preceding begin marker is an attribute matker like \w or \fig, etc.
bool CAdapt_ItDoc::IsOldBarCodeAhead(wxChar* pChar, const wxChar* pBufStart, wxChar* pEnd, wxString& barCode) // whm 16Feb2024 added
{
	wxChar* ptr = pChar; // initialise
	// When this function is called the caller's pointer ptr should be pointing directly at a '|' character.
	
	// First we need to bleed out any consideration of a '|' char that falls within a character
	// attribute marker like \w ...\w*, \fig ...\fig*, or a linking marker like \jmp ...\jmp* which use
	// the '|' char to delimit attribute/linking metadata from the normal text/caption of such markers.
	// To bleed out such valid uses of the '|' character, we need to search back from the ptr location
	// to see if the current '|' character is within a span delimited by:
	//    a character attribute marker: \w ...\w*, \rb ...\rb*, \xt ...\xt*, \fig ...\fig*
	//    a linking marker: \jmp ...\jmp*.
	// So if when scanning back we come to \w, \rb, \xt, \fig, or \jmp we can assume that the '|' character
	// is not to be cosidered part of an old-style bar code.
	wxString mkr; mkr.Empty();
	wxString augMkr; augMkr.Empty();
	//wxString endMkr; endMkr.Empty();
	//wxString lastFoundMkr; lastFoundMkr.Empty();
	//bool bFoundFormatBeginMarker = FALSE;
	bool bFoundCharAttributeBeginMarker = FALSE; // gpApp->m_charAttributeMkrs = _T("\\fig \\jmp \\+jmp \\w \\rb \\qt-s \\qt-e ")
	bool bFoundCharAttributeEndMarker = FALSE;
	bool bKeepScanning = TRUE;
	wxChar space = _T(' ');
	wxString backslash = _T("\\");
	//wxString usfmFormatBeginMkrSet = _T("\\bd \\it \\em \\sc ");
	while (ptr >= pBufStart && bKeepScanning)
	{
		// Check for prior markers
		if (*ptr == backslash)
		{
			// We're at a backslash so parse the marker to see what it is
			int mkrLen;

			mkrLen = ParseMarker(ptr);
			mkr = wxString(ptr, mkrLen);
			mkr.Trim();
			augMkr = mkr + space;
			bFoundCharAttributeEndMarker = gpApp->m_charAttributeEndMkrs.Find(augMkr) != wxNOT_FOUND;
			bFoundCharAttributeBeginMarker = gpApp->m_charAttributeMkrs.Find(augMkr) != wxNOT_FOUND;
			if (bFoundCharAttributeBeginMarker || bFoundCharAttributeEndMarker)
			{
				// The previous marker found was a either a begin or end attribute marker
				// We stop scanning having detected a begin or end attribute marker
				bKeepScanning = FALSE;
			}
		}
		// keep scanning backwards in the buffer
		ptr--; // point at previous char
	} // end of while (ptr >= pBufStart && !bFoundFormatBeginMarker)

	if (bFoundCharAttributeBeginMarker)
	{
		// The last attribute marker was a begin marker, which indicates our current
		// bar '|' char being pointed at by ptr is being used within the current span 
		// of an attribute/linking marker, and so we must return FALSE.
		// Note: If we found an character attribute END marker we would know that any
		// previous attribute marker span had already ended, and it would be safe to
		// continue looking ahead below for an old bar code.
		return FALSE;
	}

	// If we get to this point, we are certain that we have a bar char '|' that is NOT
	// part of an character attribute marker span - as determined above - so we can 
	// proceed now to scan forward to see whether it's an old bar code ahead of the 
	// '|' character.
	ptr = pChar; // reset the ptr to point again at the '|' character

	// Look aheaad of the '|' character and see what follows the bar character.
	// The longest bar codes are "|sc" and "\bi" so we can limit our forward
	// scanning to the bar char and 2 additional characters or a maxBarCodeChars of 3.
	int maxBarCodeChars = 3;
	wxChar chBar = _T('|');
	wxString barCodeFirstCharSet = _T("birsu"); // first letter of |b |i |r |sc |u
	wxString barCodeSecondCharSet = _T("c"); // second letter of |sc
	wxString barCodeStr; barCodeStr.Empty();
	wxString debugStr; debugStr.Empty();
	wxChar chAtPtr;
	wxChar nextCh;

	if (pEnd - (ptr + maxBarCodeChars) >= 0)
	{
		// We have at least 4 characters of text ahead to work with
		debugStr = wxString(ptr, maxBarCodeChars);
		debugStr = debugStr; // avoid gcc not used warning
		int count = 1;
		while (count < maxBarCodeChars)
		{
			chAtPtr = *ptr;
			nextCh = *(ptr + 1);
			if (count == 1) // the bar '|' char should be at count == 0
			{
				if (chAtPtr == chBar)
				{
					barCodeStr += chBar;
				}
				else
				{
					// ptr wasn't pointing initially at a bar '|' char so
					// set barCode to wxEmptyString and return FALSE
					barCode = wxEmptyString;
					return FALSE;
				}
			}
			if (count == 2) // the first character of a potential bar code, is it in barCodeFirstCharSet?
			{
				if (*ptr == space)
				{
					// a space follows the '|' char so it can't be a bar code but is an isolated '|' char
					barCode = wxEmptyString;
					return FALSE;
				}
				else if (IsOneOf(ptr, barCodeFirstCharSet))
				{
					// char at pointer is: b, i, r, s, or u
					barCodeStr += *ptr; // add the first barcode char


					if (barCodeSecondCharSet.Find(nextCh) == wxNOT_FOUND)
					{
						// No match for a 2-letter bar code, so it's a single-letter bar code
						barCode = barCodeStr;
						return TRUE;
					}
					else
					{
						// The nextCh is a match for a 2-letter bar code
						barCodeStr += nextCh; // add the second barcode char
						barCode = barCodeStr;
						return TRUE;
					}
				}
			}
			count++;
			ptr++; // increment to point to next ch
		}
	}
	// if we get here no bar code was found or there were not maxBarCodeChars to work with
	barCode = wxEmptyString;
	return FALSE;
}

// whm 16Feb2024 added. This function is designed to be called after the bool IsOldBarCodeAhead() funcation 
// defined above.
// This function parses the old code and returns its length as int to caller. The new usfm equivalent code
// is also returned via the newUsfmCode reference parameter.
// Note: Special handling is required when the barCode parameter indicates that a |r code was found, since 
// |r is the return to normal formatting for all the bar codes. If |r is in the barCode parameter, we search
// backwards in the text to see what was the last USFM formatting begin marker that was used - and not 
// cancelled by its equivalent formatting end marker. 
// This function then returns the equivalent Usfm marker for the format - a Usfm begin marker for all 
// incoming markers:
// \bd for |b (bold)
// \it for |i (italic)
// \sc for |sc (small caps)
// \em for |u (assuming anything underlined is for emphasis)
// \bd* for when |r cancels a |b (\bd)
// \it* for when |r cancels a |i (\it)
// \sc* for when |r cancels a |sc (\sc)
// \em* for when |r cancels a |u (\em)
// The new Usfm scheme also has a \no ... \no* for return to normal text - when multiple formatting is
// to be canceled at once. This however, I think is adequately covered by returning an end marker for
// when |r is encountered in the text.
// Finally, the USFM standard also has a formatting markers for superscript \sup ...\sup* which didn't exist 
// as a bar code, and so we don't expect to see a bar code for that.
int CAdapt_ItDoc::ParseOldBarCodeAndReturnNewBarCode(wxChar* pChar, const wxChar* pBufStart, wxString barCode, wxString& newUsfmCode)
{
	wxChar* ptr = pChar;
	//wxChar backslash = _T('\\');
	//wxChar asterisk = _T('*');
	wxChar bar = _T('|');
	//wxChar space = _T(' ');
	//wxString usfmFormatBeginMkrSet = _T("\\bd \\it \\em \\sc ");
	int lenBarCode = (int)barCode.Length();
	// The newUsfmCode returned via ref parameter newUsfmCode should have a final space for
	// storage in the m_inlineBindingMarkers member by the caller.
	if (barCode == _T("|b"))
	{
		newUsfmCode = _T("\\bd ");
	}
	else if (barCode == _T("|i"))
	{
		newUsfmCode = _T("\\it ");
	}
	else if (barCode == _T("|r"))
	{
		// We've encountered a |r code which cancels the format specified for any/all of the formatting
		// bar codes, including |b |i |u and |sc. The |r bar code itself doesn't tell us which one.
		// it's canceling. It's equivalent will be a Usfm format END marker.
		// So, to determing which Usfm end marker to return to caller, we have to look back in the input
		// text to find the last bar code that set a format (|b |i |u or |sc), and determine the 
		// equivalent Usfm end marker (\bd*, \it*, \em*, or \sc*) to assign to newUsfmCode for 
		// return to the caller.
		// We could scan back through the pSrcPhrases to do the same search for Usfm format markers that
		// we stored previously in the pSrcPhrase's m_inlineBindingMarkers member, but I think it is simpler
		// to scan back through the text we're processing - the bar codes are still in the text even through
		// we've parsed over them and converted them to their corresponding Usfm equivalents which we've stored
		// within the pSrcPhrases.
		wxString barCode; barCode.Empty();
		//wxString barCodeFirstCharSet = _T("birsu"); // first letter of |b |i |r |sc |u
		//wxString barCodeSecondCharSet = _T("c"); // second letter of |sc
		//wxString lastFoundMkr; lastFoundMkr.Empty();
		bool bFoundFormatBeginMarker = FALSE;
		wxChar firstCharAhead;
		wxChar secondCharAhead;
		// At the start of the backwards scan the ptr is pointing at the "|r" bar code, so
		// we back up the ptr one char in the buffer so we're not pointing at the bar of "|r"
		ptr--; 
		while (ptr >= pBufStart && !bFoundFormatBeginMarker)
		{
			// Since we are scanning backwards in the input buffer towards pBufStart we need not
			// concern ourselves with the pEnd of the buffer.
			// Check for prior bar codes processed in this input text.
			// Typically, we don't have to search far since often the format setting bar code is at the 
			// beginning of the current word, or at the beginning of a previous word not much earlier in
			// the input text.
			if (*ptr == bar)
			{
				// We're at a bar, so get the bar code to see what it is. We can't call ParseOldBarCodeAndReturnNewBarCode()
				// from within the same function without re-entrancy problems. So here we'll do it more directly
				firstCharAhead = *(ptr + 1);
				secondCharAhead = *(ptr + 2);

				if (firstCharAhead == _T('b') || firstCharAhead == _T('i') || firstCharAhead == _T('u'))
				{
					barCode = wxString(bar) + wxString(firstCharAhead);
					bFoundFormatBeginMarker = TRUE;
				}
				else if (firstCharAhead == _T('s') && secondCharAhead == _T('c'))
				{
					barCode = wxString(bar) + wxString(firstCharAhead) + wxString(secondCharAhead);
					bFoundFormatBeginMarker = TRUE;
				}
			} // end of if (*ptr == bar)
			// keep scanning backwards in the buffer
			ptr--; // point at previous char
		} // end of while (ptr >= pBufStart && !bFoundFormatBeginMarker)
		if (bFoundFormatBeginMarker)
		{
			// Set newUsfmCode to the Usfm end marker form. End markers don't have a final space for
			// storage by the caller in m_indlineBindingEndMarkers
			if (barCode == _T("|i"))
				newUsfmCode = _T("\\it*");
			else if (barCode == _T("|b"))
				newUsfmCode = _T("\\bd*");
			else if (barCode == _T("|u"))
				newUsfmCode = _T("\\em*");
			else if (barCode == _T("|sc"))
				newUsfmCode = _T("\\sc*");
		}
		else
		{
			// We didn't find a bar code preceding the current |r bar code
			// Probably the safest thing to do here is to return an empty string
			newUsfmCode = wxEmptyString;
		}
	}
	else if (barCode == _T("|u"))
	{
		newUsfmCode = _T("\\em ");

	}
	else if (barCode == _T("|sc"))
	{
		newUsfmCode = _T("\\sc ");

	}
	else
	{
		// an unrecognized code was passed into this function as barCode
		lenBarCode = 0;
		newUsfmCode = wxEmptyString;
	}
	return lenBarCode;
}

// whm 19Feb2024 added to consolidate above two function since this is called in several places
// within ParseWord().
// This function returns the parsed len to the caller that the caller needs to advance its
// ptr value past the old bar code. 
// The pSrcPhrase ref parameter may get bar code equivalents added to it's m_inlineBindingMarkers 
// and/or m_inlineBindingEndMarkers members.
// The bProcessedOldBarCode ref parameter signals to ParseWord() that an old bar code has been
// processed.
// See more details within the function below.
int CAdapt_ItDoc::ParseOldBarCode(wxChar* pChar, const wxChar* pBufStart, wxChar* pEnd, 
								CSourcePhrase*& pSrcPhrase, bool& bProcessedOldBarCode)
{
	// This function handles the parsing and upgrading of any old character formatting codes 
	// to use the Usfm equivalent format markers.
	// The old bar codes that were most common were: |b |i |r |sc |u
	// I reworked the following code block to identify any old bar codes, parse over them, and
	// convert them to their corresponding equivalent in Usfm markup, such as:
	//	\em …\em* for emphasis text.
	//	Syntax \em_text...\em*
	//	\bd …\bd* bold text
	//	Syntax \bd_text...\bd*
	//	\it …\it* italic text
	//	Syntax \it_text...\it
	//	\bdit …\bdit* bold and italic text
	//	Syntax \bdit_text...\bdit*
	//	\no …\no* normal text
	//	Syntax \no_text...\no*
	//	May be used when a larger paragraph element is set in an alternate font style(e.g.italic), 
	//    and a selected section of text should be displayed in normal text.
	//	\sc …\sc* small - cap text
	//	Syntax \sc_text...\sc *
	//	\sup …\sup * superscript text
	//	Typically for use in critical edition footnotes.
	//
	// Note: This function is called in several places within ParseAWord() where an old
	// bar code might appear. 
	// The function avoids processing a |r bar code when it is used it is part of a \free marker 
	// that has a sequence "|@number@|" which is not part of an old bar code sequence.
	wxChar chBar = _T('|');
	wxChar asterisk = _T('*');
	int nLenToReturn = 0;
	wxChar* ptr = pChar;
	if (*ptr == chBar && (ptr + 1) != pEnd && *(ptr + 1) != _T('@')) // if (*pAux == chBar)
	{
		// whm 16Feb2024 added code here to upgrade any old character format bar codes found to the
		// Usfm equivalent codes..
		wxString barCode; barCode.Empty();
		wxString newUsfmCode; newUsfmCode.Empty();
		int barLen = 0;
		if (IsOldBarCodeAhead(ptr, pBufStart, pEnd, barCode))
		{
			barLen = ParseOldBarCodeAndReturnNewBarCode(ptr, pBufStart, barCode, newUsfmCode);
			if (!newUsfmCode.IsEmpty())
			{
				// Store the newUsfmCode in pSrcPhrase
				// Note: Generally it will be the Usfm BEGIN marker that will be stored at this 
				// point in ParseWord().
				if (newUsfmCode.Find(asterisk) != wxNOT_FOUND)
					pSrcPhrase->SetInlineBindingEndMarkers(newUsfmCode);
				else
					pSrcPhrase->SetInlineBindingMarkers(newUsfmCode);
				bProcessedOldBarCode = TRUE;
			}
		}
		if (barLen > 0)
		{
			nLenToReturn += barLen; // increment the overall len value of ParaseWord()
		}
		// whm 19Feb2024 modified below. When ptr was pointing at a bar char that was not
		// an old bar code (barLen was 0), we should NOT advance past the bar but allow 
		// ParseWord() to deal with it.
		//else
		//{
		//	// When no bar code was parsed and barLen was zero, we must advance part the '|'
		//	nLenToReturn++;
		//}
		//// return to the caller ParseAWord()
	} // end of TRUE block for test: if (*ptr == chBar && (ptr + 1) != pEnd && *(ptr + 1) != _T('@'))
	return nLenToReturn;
}

// BEW 5Nov20 added for ParseWord(): ptr-> points at ).<space>(<space>nxtwrd, 
// after parsing in TokeniseText() before dealing with following punctuations
// Without a block dedicated to identifying the first space as the word separator,
// the punctuation ").<space>(" wrongly ends up as following punctuation
bool CAdapt_ItDoc::IsOpenParenthesisAhead2(wxChar* pChar, wxChar* pEnd)
{
	wxChar* ptr = pChar; // initialise
	//wxChar closeParen = _T(')');
	wxChar openParen = _T('(');
	wxChar space = _T(' ');
	// If ptr is not pointing at ) then return FALSE
	if ((ptr + 1) < pEnd) // ensure there's room to find a ( ahead
	{
		ptr++; // point past the ) character
	}
	else
	{
		// No room
		return FALSE;
	}
	// We allow for a ( character to be as far as 3 characters further; if
	// it isn't found by then, return FALSE; if it is found then return TRUE,
	// but only provided intervening characters are each either a punctuation
	// character or a space.
	int offset = wxNOT_FOUND;
	offset = m_spacelessPuncts.Find(*ptr);
	if (offset == wxNOT_FOUND)
	{
		if (*ptr != space)
		{
			// ptr is not pointing at a punctuation character, nor space
			return FALSE;
		}
	}
	else
	{
		// Found a punctuation character, is it an open parenthesis?
		if (*ptr == openParen)
		{
			// Yes, there is one ahead of the passed in location
			return TRUE;
		}
	}

	// No success yet, so keep looking...
	if ((ptr + 1) < pEnd) // ensure there's room to find a ( ahead
	{
		ptr++;// ptr is now past, say, ). (two characters)
	}
	else
	{
		// No room
		return FALSE;
	}
	// What is at ptr location?
	offset = m_spacelessPuncts.Find(*ptr);
	if (offset == wxNOT_FOUND)
	{
		// ptr is not pointing at punctuation
		if (*ptr != space)
		{
			// ptr is not pointing at punctuation, nor a space
			return FALSE;
		}
	}
	else // ptr is pointing at a punctuation character. 
	{
		// Is it a ( character ?
		if (*ptr == openParen)
		{
			// Yep, there is a ( character ahead
			return TRUE;
		}
	}

	// No success yet, so keep looking...
	if ((ptr + 1) < pEnd) // ensure there's room to find a ( ahead
	{
		ptr++;// ptr is now past, say,<space> ). (three characters)
	}
	else
	{
		// No room
		return FALSE;
	}
	// One last shot... What is at ptr location?
	offset = m_spacelessPuncts.Find(*ptr);
	if (offset == wxNOT_FOUND)
	{
		// ptr is not pointing at punctuation [and ( is a punct char]
		if (*ptr != space)
		{
			// ptr is not pointing at punctuation, nor a space, nor (
			return FALSE;
		}
	}
	else // ptr is pointing at a punctuation character. 
	{
		// Is it a ( character ?
		if (*ptr == openParen)
		{
			// Yep, there is a ( character ahead
			return TRUE;
		}
	}
	// look no further - we assume there's no point in having a 
	// parse of )....( in a block, because we can't be sure that
	// there is an opening parenthesis ahead which makes certain
	// that the parser must call a halt to parsing between the
	// ) and following ( somewhere.
	// This function will be in the caller's test, and if it fails
	// then the block is skipped and legacy code will operate to
	// determine what's punctuation and where the word break will be	
	return FALSE;
}


///////////////////////////////////////////////////////////////////////////////
/// \return		TRUE if pChar is pointing at a standard format marker, FALSE otherwise
/// \param		pChar		-> a pointer to a character in a buffer
/// \remarks
/// Called from: the Doc's ParseFilteringSFM(), ParseFilteredMarkerText(),
/// GetMarkerAndTextFromString(), TokenizeText(), DoMarkerHousekeeping(), the View's
/// FormatMarkerBufferForOutput(), FormatUnstructuredTextBufferForOutput(),
/// ApplyOutputFilterToText(), ParseMarkerAndAnyAssociatedText(), IsMarkerRTF(), and in
/// Usfm2Oxes class
/// Determines if pChar is pointing at a standard format marker in the given buffer
/// BEW 26Jan11, added test for character after the backslash, that it is alphabetic (this
/// prevents spurious TRUE returns if a \ is followed by whitespace)
/// BEW 31Jan11, made it smarter still
/// BEW 24Oct14, added support for USFM nested markers (\+tag)
///////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItDoc::IsMarker(wxChar* pChar)
{
	// also use bool IsAnsiLetter(wxChar c) for checking character after backslash is an
	// alphabetic one; and in response to issues Bill raised in any email on Jan 31st about
	// spurious marker match positives, make the test smarter so that more which is not a
	// genuine marker gets rejected (and also, use IsMarker() in ParseWord() etc, rather
	// than testing for *ptr == gSFescapechar)
	if (*pChar == gSFescapechar)
	{
		// reject \n but allow the valid USFM markers \nb \nd \nd* \no \no* \ndx \ndx*
		if (*(pChar + 1) == _T('n'))
		{
			if (IsAnsiLetter(*(pChar + 2)))
			{
				// assume this is one of the allowed USFM characters listed in the above
				// comment
				return TRUE;
			}
			else if (IsWhiteSpace(pChar + 2)) // see helpers.cpp for definition
			{
				// it's an \n escaped linefeed indicator, not an SFM
				return FALSE;
			}
			else
			{
				// the sequence \n followed by some nonalphabetic character nor
				// non-whitespace character is unlikely to be a valid SFM or USFM, so
				// return FALSE here too -- if we later want to make the function more
				// specific, we can put extra tests here
				return FALSE;
			}
		}
		else if (*(pChar + 1) == _T('+') && IsAnsiLetter(*(pChar + 2)))
		{
			// BEW 24Oct14 added support for USFM nested markers
			return TRUE;
		}
		else if (!IsAnsiLetter(*(pChar + 1)))
		{
			return FALSE;
		}
		else
		{
			// after the backslash is an alphabetic character, so assume its a valid marker
			return TRUE;
		}
	}
	else
	{
		// not pointing at a backslash, so it is not a marker
		return FALSE;
	}
}

// BEW 24Oct14 no changes needed for support of USFM nested markers
bool CAdapt_ItDoc::IsMarker(wxString& mkr)
{
	const wxChar* pConstBuff = mkr.GetData();
	wxChar* ptr = (wxChar*)pConstBuff;
	return IsMarker(ptr);
}

///////////////////////////////////////////////////////////////////////////////
/// \return		TRUE if pChar is pointing at a standard format marker which is also an end
///				marker (ends with an asterisk), FALSE otherwise.
/// \param		pChar	-> a pointer to a character in a buffer
/// \param		pEnd	-> a pointer to the end of the buffer
/// \remarks
/// Called from: the Doc's GetMarkersAndEndMarkersFromString(), AnalyseMarker(), the View's
/// FormatMarkerBufferForOutput(), DoExportInterlinearRTF(), ProcessAndWriteDestinationText(),
/// and helper.cpp's FindSplitLocationForPunctsAndMkrsSubstringsPair().
/// Determines if the marker at pChar is a USFM end marker (ends with an asterisk).
/// BEW added to it, 11Feb10, to handle SFM endmarkers \F or \fe for 'footnote end'
/// BEW added 11Oct10, support for halting at ] bracket
/// BEW 24Oct14, no changes needed for support of USFM nested markers
///////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItDoc::IsEndMarker(wxChar* pChar, wxChar* pEnd)
{
	// Returns TRUE if pChar points to a marker that ends with *
	wxChar* ptr = pChar;
	// Advance the pointer forward until one of the following conditions ensues:
	// 1. ptr == pEnd (return FALSE)
	// 2. ptr points to a any whitespace character (return FALSE)
	// 3. ptr points to another marker (return FALSE)
	// 4. ptr points to a * (return TRUE)
	// 5. ptr points to a ] (return FALSE)
	// 6. ptr points at \F or \fe and  PngOnly is the marker set being used (return TRUE)

	// First, handle the PngOnly special case of \fe or \F footnote end markers
	if (gpApp->gCurrentSfmSet == PngOnly)
	{
		wxString tempStr1(ptr, 2);
		if (tempStr1 == _T("\\F"))
			return TRUE;
		wxString tempStr2(ptr, 3);
		if (tempStr2 == _T("\\fe"))
			return TRUE;
	}

	// neither of those, so must be USFM endmarker if it is one at all
	while (ptr < pEnd)
	{
		ptr++;
		if (*ptr == _T('*'))
			return TRUE;
		else if (IsWhiteSpace(ptr) || *ptr == gSFescapechar || *ptr == _T(']'))
			return FALSE;
	}
	return FALSE;
}

bool CAdapt_ItDoc::IsEndMarker2(wxChar* pChar)
{
	// Returns TRUE if pChar points to a marker that ends with *
	wxChar* ptr = pChar;
	// Advance the pointer forward until one of the following conditions ensues:
	// 1. ptr == (wxChar*)NULL (return FALSE)
	// 2. ptr points to a any whitespace character (return FALSE)
	// 3. ptr points to another marker (return FALSE)
	// 4. ptr points to a * (return TRUE)
	// 5. ptr points to a ] (return FALSE)
	// 6. ptr points at \F or \fe and  PngOnly is the marker set being used (return TRUE)

	// First, handle the PngOnly special case of \fe or \F footnote end markers
	if (gpApp->gCurrentSfmSet == PngOnly)
	{
		wxString tempStr1(ptr, 2);
		if (tempStr1 == _T("\\F"))
			return TRUE;
		wxString tempStr2(ptr, 3);
		if (tempStr2 == _T("\\fe"))
			return TRUE;
	}

	// neither of those, so must be USFM endmarker if it is one at all
	while (ptr != (wxChar*)NULL)
	{
		ptr++;
		if (*ptr == _T('*'))
			return TRUE;
		else if (IsWhiteSpace(ptr) || *ptr == gSFescapechar || *ptr == _T(']') || ptr == (wxChar*)NULL)
			return FALSE;
	}
	return FALSE;
}

///////////////////////////////////////////////////////////////////////////////
/// \return		TRUE if pChar is pointing at a standard format marker which is also
///             an inLine marker (or embedded marker), FALSE otherwise.
/// \param		pChar	-> a pointer to a character in a buffer
/// \param		pEnd	<- currently unused
/// \remarks
/// Called from: the Doc's ParseFilteringSFM(), the View's FormatMarkerBufferForOutput().
/// Determines if the marker at pChar is a USFM inLine marker, i.e., one which is defined
/// in AI_USFM.xml with inLine="1" attribute. InLine markers are primarily "character
/// style" markers and also include all the embedded content markers whose parent markers
/// are footnote, endnotes and crossrefs.
/// BEW 24Oct14, Such markers are typically the ones which potentially may be nested.
/// Therefore, some additions are below to support determining when a nested marker
/// is in-line; nested markers are not enumerated in the USFM standard, but are constructable
/// on-demand from any unnested one by addition of + following the backspace. So our
/// approach here is to determine if the marker at pChar is a nested one, and construct
/// its equivalent legacy associated marker - and use that for the lookup. (Footnote,
/// endnote and crossref markers do not have nested equivalents however, but other inline
/// markers legally may have them.)
/// BEW 24Oct14 additions for support of USFM nested markers
///////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItDoc::IsInLineMarker(wxChar* pChar, wxChar* WXUNUSED(pEnd))
{
	// Returns TRUE if pChar points to a marker that has inLine="1" [true] attribute
	wxChar* ptr = pChar;
	wxString wholeMkr = GetWholeMarker(ptr);

	// BEW 24Oct14, addition for support of nested UFSM markers (i.e. of form \+tag )
	bool bIsNestedMkr = FALSE;
	bool bIsWholeMkr = TRUE;
	wxString tagOnly; tagOnly.Empty();
	wxString baseOfEndMkr;
	bIsNestedMkr = IsNestedMarkerOrMarkerTag(&wholeMkr, tagOnly, baseOfEndMkr, bIsWholeMkr);
	wxUnusedVar(bIsNestedMkr);
	wxUnusedVar(bIsWholeMkr);
	// Prepare the correct lookup marker string
	wholeMkr = gSFescapechar;
	if (baseOfEndMkr.IsEmpty())
	{
		// not an endmarker, so tagOnly has the wanted tag
		wholeMkr += tagOnly;
	}
	else
	{
		// it was an endmarker, so baseOfEndMkr has the wanted tag
		wholeMkr += baseOfEndMkr;
	}
	// note: no + is present now, if it in fact was a ptr to \+tag passed in

	// end of 24Oct14 addition, and next 3 lines no longer needed
	//int aPos = wholeMkr.Find(_T('*'));
	//if (aPos != -1)
	//	wholeMkr.Remove(aPos,1);
	// whm revised 13Jul05. In order to get an accurate Find of wholeMkr below we
	// need to ensure that the wholeMkr is followed by a space, otherwise Find would
	// give a false positive when wholeMkr is "\b" and the searched string has \bd, \bk
	// \bdit etc.
	wholeMkr.Trim(TRUE); // trim right end
	wholeMkr.Trim(FALSE); // trim left end
	wholeMkr += _T(' '); // ensure wholeMkr has a single final space
	// These rapid access strings don't have nested marker definitions in them, that's
	// why we constructed the whole marker without any + indicating nesting, above
	switch (gpApp->gCurrentSfmSet)
	{
	case UsfmOnly:
	{
		if (gpApp->UsfmInLineMarkersStr.Find(wholeMkr) != -1)
		{
			// it's an inLine marker
			return TRUE;
		}
		break;
	}
	case PngOnly:
	{
		if (gpApp->PngInLineMarkersStr.Find(wholeMkr) != -1)
		{
			// it's an inLine marker
			return TRUE;
		}
		break;
	}
	case UsfmAndPng:
	{
		if (gpApp->UsfmAndPngInLineMarkersStr.Find(wholeMkr) != -1)
		{
			// it's an inLine marker
			return TRUE;
		}
		break;
	}
	default:
	{
		if (gpApp->UsfmInLineMarkersStr.Find(wholeMkr) != -1)
		{
			// it's an inLine marker
			return TRUE;
		}
		break;
	}
	} // end of switch (gpApp->gCurrentSfmSet)
	return FALSE;
}

///////////////////////////////////////////////////////////////////////////////
/// \return		TRUE if pChar is pointing at a standard format marker which is also a
///				corresponding end marker for the specified wholeMkr, FALSE otherwise.
/// \param		wholeMkr	-> a wxString containing the marker (including backslash)
/// \param		pChar		-> a pointer to a character in a buffer
/// \param		pEnd		-> a pointer to the end of the buffer
/// \remarks
/// Called from: the Doc's ParseFilteringSFM(), ParseFilteredMarkerText(),
/// GetMarkersAndEndMarkersFromString(), the View's ParseFootnote(), ParseEndnote(),
/// ParseCrossRef(), ProcessAndWriteDestinationText(), ApplyOutputFilterToText()
/// ParseMarkerAndAnyAssociatedText(), and CViewFilteredMaterialDlg::InitDialog().
/// Determines if the marker at pChar is the corresponding end marker for the
/// specified wholeMkr.
/// IsCorresEndMarker returns TRUE if the marker matches wholeMkr and ends with an
/// asterisk. It also returns TRUE if the gCurrentSfmSet is PngOnly and wholeMkr
/// passed in is \f and marker being checked at ptr is \fe or \F.
/// BEW 24Oct14, no changes needed for support of USFM nested markers. (Since
/// this function is used for filtering, and because inline binding and inline
/// nonbinding markers cannot be filtered, it's unlikely this function will
/// be called for wholeMkr being a nested one (ie. of form \+tag ). However, it
/// would handle such correctly without any changes being needed.
///////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItDoc::IsCorresEndMarker(wxString wholeMkr, wxChar* pChar, wxChar* pEnd)
{
	// Returns TRUE if the marker matches wholeMkr and ends with *
	// Also returns TRUE if the gCurrentSfmSet is PngOnly and wholeMkr passed in
	// is \f and marker being checked at ptr is \fe or \F
	wxChar* ptr = pChar;

	// First, handle the PngOnly special case of \fe footnote end marker
	if (gpApp->gCurrentSfmSet == PngOnly && wholeMkr == _T("\\f"))
	{
		wxString tempStr = GetWholeMarker(ptr);
		// debug
		//int len;
		//len = tempStr.Length();
		// debug
		if (tempStr == _T("\\fe") || tempStr == _T("\\F"))
		{
			return TRUE;
		}
	}

	// not a PngOnly footnote situation so do regular USFM check
	// for like a marker ending with *
	int wholeMkrLen = wholeMkr.Length(); // only needs to be calculated once
	for (int i = 0; i < wholeMkrLen; i++)
	{
		if (ptr < pEnd)
		{
			if (*ptr != wholeMkr[i])
				return FALSE;
			ptr++;
		}
		else
			return FALSE;
	}
	// markers match through end of wholeMkr
	if (ptr < pEnd)
	{
		if (*ptr != _T('*'))
			return FALSE;
	}
	// the marker at pChar has an asterisk on it so we have the corresponding end marker
	return TRUE;
}

bool CAdapt_ItDoc::IsLegacyDocVersionForFileSaveAs()
{
	return m_bLegacyDocVersionForSaveAs;
}

///////////////////////////////////////////////////////////////////////////////
/// \return		TRUE if pChar is pointing at a standard format marker which is also a
///				chapter marker (\c ), FALSE otherwise.
/// \param		pChar		-> a pointer to a character in a buffer
/// \remarks
/// Called from: the Doc's TokenizeText(), DoMarkerHousekeeping(),
/// DoExportInterlinearRTF(), DoExportSrcOrTgtRTF().
/// Returns TRUE only if the character following the backslash is a c followed by whitespace,
/// FALSE otherwise. Does not check to see if a number follows the whitespace.
///////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItDoc::IsChapterMarker(wxChar* pChar)
{
	wxChar* ptr = pChar;
	ptr++;
	if (*ptr == _T('c'))
	{
		ptr++;
		return IsWhiteSpace(ptr);
	}
	else
		return FALSE;
}

///////////////////////////////////////////////////////////////////////////////
/// \return		TRUE if pChar is pointing at a Null character, i.e., (wxChar)0.
/// \param		pChar		-> a pointer to a character in a buffer
/// \remarks
/// Called from: the Doc's ParseWord(), TokenizeText(), DoMarkerHousekeeping(), the View's
/// DoExportSrcOrTgtRTF() and ProcessAndWriteDestinationText().
/// Returns TRUE if the buffer character at pChar is the null character (wxChar)0.
///////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItDoc::IsEnd(wxChar* pChar)
{
	return *pChar == (wxChar)0;
}

///////////////////////////////////////////////////////////////////////////////
/// \return		a wxString constructed of the characters from the buffer, starting with the
///				character at ptr and including the next itemLen-1 characters.
/// \param		dest		<- a wxString that gets concatenated with the composed src string
/// \param		src			<- a wxString constructed of the characters from the buffer, starting with the
///								character at ptr and including the next itemLen-1 characters
/// \param		ptr			-> a pointer to a character in a buffer
/// \param		itemLen		-> the number of buffer characters to use in composing the src string
/// \remarks
/// Called from: the Doc's DoMarkerHousekeeping(), ParsePreWord(), and TokenizeText().
/// AppendItem() actually does double duty. It not only returns the wxString constructed from
/// itemLen characters (starting at ptr); it also returns by reference the composed
/// string concatenated to whatever was previously in dest.
/// In actual code, no use is made of the returned wxString of the AppendItem()
/// function itself; only the value returned by reference in dest is used.
/// TODO: Change to a Void function since no use is made of the wxString returned.
/// BEW 13Jul11, the legacy version formed the string including any final \r\n or in other
/// OSes, \n or \r; and we relied on post-processing to remove these as a 'normalization'
/// of the data. But for supporting contentless USFM verses from Paratext, the \r and/or
/// \n are not getting removed which puts vertical white space into the layout - so we may as
/// well test here for final carriage return and or line feed, and remove them from the
/// formed string after itemLen has been used to form it.
/// whm 22Aug2023 revised to remove the "endianness" conditionally compiled code blocks as
/// unneeded.
///////////////////////////////////////////////////////////////////////////////
wxString& CAdapt_ItDoc::AppendItem(wxString& dest, wxString& src, const wxChar* ptr, int itemLen)
{
	src = wxString(ptr, itemLen);

	// whm 22Aug2023 modified. The conditionally compiled code blocks below for __WXMSW__ and the other
	// platforms is not really needed. There is no need to account for endianness is most of our code
	// which doesn't apply to whole wxChar characters, nor to the wxChars indexed within wxStrings.
	// Hence, I'm commenting out the conditional tests below as unneeded. The code is also too
	// dangerous as it attempts to assign null characters to a wxChar buffer. All that is needed is
	// for this function to append the wxString sub-string to the dest wxString and return the src
	// wxString. 
	// According to the comment above the function, the caller of AppendItem() never captures
	// its return value so it could be made into a void function, but I'll not do that for this
	// revision.
	/*
	// BEW added 13Jul11
#ifdef __WXMSW__
	// handle either endianness
	if (itemLen >= 2 && ((*(ptr - 1) == _T('\n') && *(ptr - 2) == _T('\r')) ||
		(*(ptr - 1) == _T('\r') && *(ptr - 2) == _T('\n'))))
	{
		const wxChar* pBuffer = src.GetData();
		wxChar* pBufStart = (wxChar*)pBuffer; // point to start of text
		wxChar* pEnd = pBufStart + itemLen;
		wxASSERT(*pEnd == _T('\0')); // ensure there is a null there
		if (*(pEnd - 1) == _T('\n') || *(pEnd - 1) == _T('\r'))
		{
			*(pEnd - 1) = _T('\0'); // overwrite with a null wxChar
		}
		if (*(pEnd - 2) == _T('\r') || *(pEnd - 2) == _T('\n'))
		{
			*(pEnd - 2) = _T('\0'); // overwrite with a null wxChar
		}
		// whm 12Aug11 removed this UngetWriteBuf() call, which should NEVER be done on a READ-ONLY
		// buffer established with ::GetData().
		//src.UngetWriteBuf(); // cause str's length to be recalculated
	}
#else
	if (itemLen >= 1 && (*(ptr - 1) == _T('\n') || *(ptr - 1) == _T('\r')))
	{
		const wxChar* pBuffer = src.GetData();
		wxChar* pBufStart = (wxChar*)pBuffer; // point to start of text
		wxChar* pEnd = pBufStart + itemLen;
		wxASSERT(*pEnd == _T('\0')); // ensure there is a null there
		if (*(pEnd - 1) == _T('\n') || *(pEnd - 1) == _T('\r'))
		{
			*(pEnd - 1) = _T('\0'); // overwrite with a null wxChar
		}
		// whm 12Aug11 removed this UngetWriteBuf() call, which should NEVER be done on a READ-ONLY
		// buffer established with ::GetData().
		//src.UngetWriteBuf(); // cause str's length to be recalculated
	}
#endif
	*/

	dest += src;
	return src; // whm 22Aug2023 note: This return value could be removed if the function were changed to a void function.
}

///////////////////////////////////////////////////////////////////////////////
/// \return		a wxString constructed of dest + src (with inserted space between them if
///				dest doesn't already end with a space).
/// \param		dest		<- a wxString that gets concatenated with the composed src string
/// \param		src			-> a wxString to be appended/concatenated to dest
/// \remarks
/// Called from: the Doc's TokenizeText().
/// AppendFilteredItem() actually does double duty. It not only returns the wxString src;
/// it also returns by reference in dest the composed/concatenated dest + src (insuring
/// that a space intervenes between unless dest was originally empty.
/// In actual code, no use is made of the returned wxString of the AppendFilteredItem()
/// function itself; only the value returned by reference in dest is used.
/// TODO: Change to a Void function since no use is made of the wxString returned.
///////////////////////////////////////////////////////////////////////////////
wxString& CAdapt_ItDoc::AppendFilteredItem(wxString& dest, wxString& src)
{
	// whm added 11Feb05
	// ensure the filtered item is padded with space if it is not first
	// in dest
	if (!dest.IsEmpty())
	{
		if (dest[dest.Length() - 1] != _T(' '))
			// append a space, but only if there is not already one at the end
			dest += _T(' ');
	}
	dest += src;
	dest += _T(' ');
	return src;
}

///////////////////////////////////////////////////////////////////////////////
/// \return		the wxString starting at ptr and composed of itemLen characters
///             after enclosing the string between \~FILTER and \~FILTER* markers.
/// \param		ptr			-> a pointer to a character in a buffer
/// \param		itemLen		-> the number of buffer characters to use in composing the
///                            bracketed string
/// \remarks
/// Called from: the Doc's ReconstituteAfterFilteringChange(), TokenizeText(), and
/// PaarsePostWordStuff().
/// Constructs the string starting at ptr (whose length is itemLen in the buffer); then
/// makes the string a "filtered" item by bracketing it between \~FILTER ... \~FILTER*
/// markers. The passed in string may be just a marker (contentless, and having no
/// following space), or a marker followed by a space and some text content (and possibly
/// then a space and then possibly an endmarker as well)
/// BEW 21Sep10, no change needed for docVersion 5
///////////////////////////////////////////////////////////////////////////////
wxString CAdapt_ItDoc::GetFilteredItemBracketed(const wxChar* ptr, int itemLen)
{
	// whm added 11Feb05; BEW changed 06Oct05 to simpify a little and remove the unneeded
	// first argument (which was a CString& -- because it was being called with wholeMkr
	// supplied as that argument's string, which was clobbering the marker in the caller)
	// bracket filtered info with unique markers \~FILTER and \~FILTER*
	// wxString src;
	wxString temp(ptr, itemLen);
	temp.Trim(TRUE); // trim right end
	temp.Trim(FALSE); // trim left end
	//wx version handles embedded new lines correctly
	wxString temp2;
	temp2 << filterMkr << _T(' ') << temp << _T(' ') << filterMkrEnd;
	temp = temp2;
	return temp;
}

///////////////////////////////////////////////////////////////////////////////
/// \return		a wxString with any \~FILTER and \~FILTER* filter bracketing markers removed
/// \param		src		-> the string to be processed (which has \~FILTER and \~FILTER* markers)
/// \remarks
/// Called from: the View's IsWrapMarker().
/// Returns the string after removing any \~FILTER ... \~FILTER* filter bracketing markers
/// that exist in the string. Strips out multiple sets of bracketing filter markers if found
/// in the string. If src does not have any \~FILTER and \~FILTER* bracketing markers, src is
/// returned unchanged. Trims off any remaining space at left end of the returned string.
/// BEW 22Feb10, no changes for support of doc version 5
///////////////////////////////////////////////////////////////////////////////
wxString CAdapt_ItDoc::GetUnFilteredMarkers(wxString& src)
{
	// whm added 11Feb05
	// If src does not have the unique markers \~FILTER and \~FILTER* we only need return
	// the src unchanged
	// The src may have embedded \n chars in it. Note: Testing shows that use
	// of CString's Find method here, even with embedded \n chars works OK.
	int beginMkrPos = src.Find(filterMkr);
	int endMkrPos = src.Find(filterMkrEnd);
	while (beginMkrPos != -1 && endMkrPos != -1)
	{
		// Filtered material markers exist so we can remove all text between
		// the two filter markers inclusive of the markers. Filtered material
		// is never embedded within other filtered material so we can assume
		// that each sequence of filtered text we encounter can be deleted as
		// we progress linearly from the beginning of the src string to its end.
		wxString temps = filterMkrEnd;
		src.Remove(beginMkrPos, endMkrPos - beginMkrPos + temps.Length());
		beginMkrPos = src.Find(filterMkr);
		endMkrPos = src.Find(filterMkrEnd);
	}
	// Note: The string returned by GetUnFilteredMarkers may have an initial
	// space, which I think would not usually happen in the legacy app before
	// filtering. I have therefore added the following line, which is also
	// probably needed for proper functioning of IsWrapMarker in the View:
	src.Trim(FALSE); // FALSE trims left end only
	return src;
}

/*
///////////////////////////////////////////////////////////////////////////////
/// \return		0 (zero)
/// \remarks
/// Called from: the Doc's TokenizeText(), DoMarkerHousekeeping(),
/// Clear's the App's working buffer.
/// TODO: Eliminate this function and the App's working buffer and just declare and use a local
/// wxString buffer in the two Doc functions that call ClearBuffer(), and the View's version of
/// ClearBuffer().
/// whm 4Sep2023 removed this function along with the buffer on the App
///////////////////////////////////////////////////////////////////////////////
int CAdapt_ItDoc::ClearBuffer()
{
	CAdapt_ItApp* pApp = &wxGetApp();
	wxASSERT(pApp != NULL);
	pApp->buffer.Empty();
	return 0;
}
*/

///////////////////////////////////////////////////////////////////////////////
/// \return		TRUE unless the text in rText contains at least one marker that defines it
///				as "structured" text, in which case returns FALSE
/// \param		rText	-> the string buffer being examined
/// \remarks
/// Called from: the Doc's TokenizeText().
/// Returns TRUE if rText does not have any of the following markers: \id \v \vt \vn \c \p \f \s \q
/// \q1 \q2 \q3 or \x.
/// BEW 24Oct14, no changes needed for support of USFM nested markers. (Lack of \+ does
/// not logically imply that it is not a USFM marked up text.)
/// 
/// whm 16Mar2024 revised. The current criterial for determining a return of FALSE for this function
/// relies on detecting just a small subset of USFM markers. This limited criterial is bound to fail
/// at some points - especially when the buffer being sent to TokenizeText() is extremely limited,
/// which is normally the case when Editing the Source Text and the substring sent to TokenizeText()
/// contains just a single marker that may have been edited to correct a marker mis-spelling. That
/// single marker could really be any marker in the USFM set!
/// Therefore, as of this date, I'm radically revising this function to return FALSE, except when the
/// rText has no USFM markers at all within the text OR when the only marker(s) in rText are \p 
/// marker(s).
/// Also the Doc's m_currentUnfilterMkr member is no longer relevant with these revisions.
///////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItDoc::IsUnstructuredPlainText(wxString& rText)
// we deem the absence of \id and any of \v \vt \vn \c \p \f \s \q
// \q1 \q2 \q3 or \x standard format markers to be sufficient
// evidence that it is unstructured plain text
{
	int nPosBackslash;
	nPosBackslash = rText.Find(gSFescapechar);
	if (nPosBackslash == wxNOT_FOUND)
	{
		// There are no backslash chars at all in rText, so it is unstructured
		return TRUE;
	}
	// Collect all markers from rText, and check whether there is one that is NOT \p. If only \p is
	// found in the marker inventory, then return TRUE. If any other marker besides \p is found in
	// rText, then return FALSE as it would be considered structured text.
	wxArrayString mkrsArray; mkrsArray.Clear();
	wxString endMarkers;
	GetMarkersAndEndMarkersFromString(&mkrsArray, rText, endMarkers);
	if (mkrsArray.GetCount() == 0)
	{
		// No markers were found so it is unstructured.
		// Note: Any backslash found from the test above was an isolated backslash and not a marker.
		return TRUE;
	}
	else
	{
		// Markers were found so, scan through the mkrsArray and examine the inventory. Any non \p
		// marker found in the array means we can immediately return FALSE. If we get to the end of
		// our examination of the array without finding any marker other than \p, then we return TRUE.
		int nTot = 0;
		nTot = (int)mkrsArray.GetCount();
		wxString mkr; mkr.Empty();
		for (int ct = 0; ct < nTot; ct++)
		{
			mkr = mkrsArray.Item(ct);
			mkr.Trim(); // remove final space
			if (mkr != _T("\\p"))
			{
				// There is a marker other than \p, so it is NOT unstructured; retrn FALSE
				return FALSE;
			}
		}
		// If we get here, we've not found any marker other than \p so we can conclude it 
		// is unstructured and we return TRUE to indicate that to the caller
		return TRUE;
	}
	/*
	wxString s1 = gSFescapechar;
	int nFound = -1;
	wxString s = s1 + _T("id ");
	nFound = rText.Find(s);
	if (nFound >= 0)
		return FALSE; // has \id
	s = s1 + _T("v ");
	nFound = rText.Find(s);
	if (nFound >= 0)
		return FALSE; // has \v
	s = s1 + _T("vn ");
	nFound = rText.Find(s);
	if (nFound >= 0)
		return FALSE; // has \vn
	s = s1 + _T("vt ");
	nFound = rText.Find(s);
	if (nFound >= 0)
		return FALSE; // has \vt
	s = s1 + _T("c ");
	nFound = rText.Find(s);
	if (nFound >= 0)
		return FALSE; // has \c

	// BEW added 10Apr06 to support small test files with just a few markers
	s = s1 + _T("p ");
	nFound = rText.Find(s);
	if (nFound >= 0)
		return FALSE; // has \p
	s = s1 + _T("f ");
	nFound = rText.Find(s);
	if (nFound >= 0)
		return FALSE; // has \f
	s = s1 + _T("s ");
	nFound = rText.Find(s);
	if (nFound >= 0)
		return FALSE; // has \s
	s = s1 + _T("q ");
	nFound = rText.Find(s);
	if (nFound >= 0)
		return FALSE; // has \q
	s = s1 + _T("q1 ");
	nFound = rText.Find(s);
	if (nFound >= 0)
		return FALSE; // has \q1
	s = s1 + _T("q2 ");
	nFound = rText.Find(s);
	if (nFound >= 0)
		return FALSE; // has \q2
	s = s1 + _T("q3 ");
	nFound = rText.Find(s);
	if (nFound >= 0)
		return FALSE; // has \q3
	s = s1 + _T("x ");
	nFound = rText.Find(s);
	if (nFound >= 0)
		return FALSE; // has \x
	// that should be enough, ensuring correct identification <<-- not so 6Dec19
	// of even small test files with only a few SFM markers

	// BEW 6Dec19 It turns out that the 10Apr16	addition is
	// only adequate for parsing small test files - having
	// one of those markers - such as \v marker. It fails to 
	// return the correct result when this function is called in
	// TokenizeTextString() which internally calls TokenizeText(),
	// in the context of a short string with a filterable marker,
	// such as when unfiltering \fig marker. So I have provided
	// the unfilter marker in doc's new member string:
	// m_currentUnfilterMkr. The latter, once the unfiltering
	// loop has gotten the marker, gets the marker copied there
	// so as to be available here when TokenizeTextString() is
	// called. If the marker is a valid one, then we know
	// the data is structured. m_currentUnfilterMkr is cleared
	// to FALSE at the end of each iteration of the unfiltering
	// loop (the user may have requested unfiltering of more
	// than one filtered markers).
	// whm 16Mar2024 the m_currentUnfilterMkr value is no longer relevant
	// for unstructured text considerations.
	if (m_currentUnfilterMkr.IsEmpty())
	{
		// Either we are not unfiltering, or we are but the filtered
		// data is bad by not having a begin-marker starting the
		// filtered content. In either case, we have no way to avoid
		// returning TRUE - and doing that will prevent USFM3 cache
		// metadata from being mis-handed
		;
	}
	else
	{
		// m_currentUnfilterMkr has a begin marker. That's all we
		// need to know; as even an unknown marker such as \y is
		// considered to be indicative of a USFM structured text.
		// But unstructured text gets \p markers auto-inserted to
		// preserve paragraphing structure, so play safe by excluding
		// \p from consideration here.
		wxString strParagraph(_T("\\p"));
		if (m_currentUnfilterMkr != strParagraph)
		{
			return FALSE;
		}
		// But if they match, returning TRUE is appropriate, so fall thru
	}
	return TRUE; // assume unstructured plain text
	*/
}

///////////////////////////////////////////////////////////////////////////////
/// \return		TRUE if some character other than end-of-line char(s) (\n and/or \r) is found
///				past the nFound position in rText, otherwise FALSE.
/// \param		rText		-> the string being examined
/// \param		nTextLength	-> the length of the rText string
/// \param		nFound		-> the position in rText beyond which we examine content
/// \remarks
/// Called from: the Doc's AddParagraphMarkers().
/// Determines if there are any characters other than \n or \r beyond the nFound position in
/// rText. Used in AddParagraphMarkers() to add "\p " after each end-of-line in rText.
///////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItDoc::NotAtEnd(wxString& rText, const int nTextLength, int nFound)
{
	nFound++; // get past the newline
	if (nFound >= nTextLength - 1)
		return FALSE; // we are at the end

	int index = nFound;
	wxChar ch;
	while ( (index < nTextLength) && ((ch = rText.GetChar(index)) == _T('\r') || (ch = rText.GetChar(index)) == _T('\n')) )
	{
		index++; // skip the carriage return or newline
		if (index >= nTextLength)
			return FALSE; // we have arrived at the end
	}

	return TRUE; // we found some other character before the end was reached
}

///////////////////////////////////////////////////////////////////////////////
/// \return		nothing
/// \param		rText		-> the string being examined
/// \param		nTextLength	-> the length of the rText string
/// \remarks
/// Called from: the Doc's TokenizeText().
/// Adds "\p " after each end-of-line in rText. The addition of \p markers is done to provide
/// minimal structuring of otherwise "unstructured" text for Adapt It's internal operations.
/// whm 16Mar2024 added the NormalizeTextEOLsToCRLF() function call to regularize the text
/// to have "\r\n" EOLs before adding any \p markers. Before this normalization, any isolated
/// \r CR EOL found in the text would not receive a \p marker inserted after the \r leaving
/// the \r as an extraneous char in the file not followed by a \p marker.
///////////////////////////////////////////////////////////////////////////////
void CAdapt_ItDoc::AddParagraphMarkers(wxString& rText, int& nTextLength)
{
	// adds \p followed by a space following every \n in the text buffer
	wxString s = gSFescapechar;
	s += _T("p ");
	const wxChar* paragraphMarker = (const wxChar*)s;
	int nFound = 0;

	// whm 16Mar2024 added the following to normalize the EOLs to "\r\n" before adding 
	// any \p markers after the EOLs.
	NormalizeTextEOLsToCRLF(rText, FALSE);

	int nNewLength = nTextLength;
	while (((nFound = FindFromPos(rText, _T("\n"), nFound)) >= 0) &&
		NotAtEnd(rText, nNewLength, nFound))
	{
		nFound++; // point past the newline

		// we are not at the end, so we insert \p here
		rText = InsertInString(rText, nFound, paragraphMarker);
		nNewLength = rText.Length();
	}
	nTextLength = nNewLength;
}

///////////////////////////////////////////////////////////////////////////////
/// \return		nothing
/// \param		pstr	<- the wxString buffer
/// \remarks
/// Called from: the Doc's OnNewDocument(),
/// Removes any existing fixed space ~ in pstr by overwriting it with a space. The
/// processed text is returned by reference in pstr. This function call would normally be
/// followed by a call to RemoveMultipleSpaces() to remove any remaining multiple spaces.
/// In our case, the subsequent call of TokenizeText() in OnNewDocument() discards any
/// extra spaces left by OverwriteUSFMFixedSpaces().
/// BEW 23Nov10, changed to support ~ rather than !$ (the latter is deprecated)
///////////////////////////////////////////////////////////////////////////////
void CAdapt_ItDoc::OverwriteUSFMFixedSpaces(wxString*& pstr)
{
	// whm revised in wx version to have input string by reference in first parameter and
	// to set up a write buffer within this function.
	int len = (*pstr).Length();
	// whm 8Jun12 modified for 2.9.3 use wxStringBuffer.
	// Create the wxStringBuffer in a specially scoped block. This is not crucial here
	// in this function since the wxString never needs to be accessed directly within
	// this function (as *pstr) after the wxStringBuffer is created. It is good practice
	// however to put it within a specially scoped block, in case someone later uses
	// this function as an example of how to set up a wxStringBuffer.
	{ // begin special scoped block
		wxStringBuffer pBuffer((*pstr), len + 1);
		//wxChar* pBuffer = (*pstr).GetWriteBuf(len + 1);
		wxChar* pBufStart = pBuffer;
		wxChar* pEnd = pBufStart + len;
		wxASSERT(*pEnd == _T('\0'));
		wxChar* ptr = pBuffer;
		while (ptr < pEnd)
		{
			if (*ptr == _T('~'))
			{
				// we are pointing at an instance of ~,
				// so overwrite it and continue processing
				*ptr++ = _T(' ');
			}
			else
			{
				ptr++;
			}
		}
		// whm len should not have changed, just release the buffer
	} // end special scoped block - (*pstr) is put back into a normal state at this point
	//(*pstr).UngetWriteBuf(); // whm 8Jun12 removed - not needed with wxStringBuffer above
}

///////////////////////////////////////////////////////////////////////////////
/// \return		nothing
/// \param		pstr	<- the wxString buffer
/// \remarks
/// Called from: the Doc's OnNewDocument(),
/// Removes any existing discretionary line break // sequences in pstr by overwriting the
/// sequence with spaces. The processed text is returned by reference in pstr.
/// This function call would normally be followed by a call to RemoveMultipleSpaces() to
/// remove any remaining multiple spaces. In our case, the subsequent call of
/// TokenizeText() in OnNewDocument() discards any extra spaces left by
/// .OverwriteUSFMDiscretionaryLineBreaks().
void CAdapt_ItDoc::OverwriteUSFMDiscretionaryLineBreaks(wxString*& pstr)
{
	int len = (*pstr).Length();
	// whm 8Jun12 modified for 2.9.3 use wxStringBuffer
	// Create the wxStringBuffer in a specially scoped block. This is not crucial here
	// in this function since the wxString never needs to be accessed directly within
	// this function (as *pstr) after the wxStringBuffer is created. It is good practice
	// however to put it within a specially scoped block, in case someone later uses
	// this function as an example of how to set up a wxStringBuffer.
	{ // begin special scoped block
		wxStringBuffer pBuffer((*pstr), len + 1);

		//wxChar* pBuffer = (*pstr).GetWriteBuf(len + 1);
		wxChar* pBufStart = pBuffer;
		wxChar* pEnd = pBufStart + len;
		wxASSERT(*pEnd == _T('\0'));
		wxChar* ptr = pBuffer;
		while (ptr < pEnd)
		{
			if (wxStrncmp(ptr, _T("//"), 2) == 0)
			{
				// we are pointing at an instance of //,
				// so overwrite it and continue processing
				*ptr++ = _T(' ');
				*ptr++ = _T(' ');
			}
			else
			{
				ptr++;
			}
		}
		// whm len should not have changed, just release the buffer
	} // end special scoped block - (*pstr) is put back into a normal state at this point
	//(*pstr).UngetWriteBuf(); // whm 8Jun12 removed - not needed with wxStringBuffer above
}

#ifndef __WXMSW__
#ifndef _UNICODE
///////////////////////////////////////////////////////////////////////////////
/// \return		nothing
/// \param		pstr	<- the wxString buffer
/// \remarks
/// Called from: the Doc's OnNewDocument().
/// Changes MS Word "smart quotes" to regular quotes. The character values for smart quotes
/// are negative (-108, -109, -110, and -111). Warns the user if other negative character
/// values are encountered in the text, i.e., that he should use TecKit to convert the data
/// to Unicode then use the Unicode version of Adapt It.
///////////////////////////////////////////////////////////////////////////////
void CAdapt_ItDoc::OverwriteSmartQuotesWithRegularQuotes(wxString*& pstr)
{
	// whm added 12Apr2007
	bool hackedFontCharPresent = FALSE;
	int hackedCt = 0;
	wxString hackedStr;
	hackedStr.Empty();
	int len = (*pstr).Length();
	// whm 8Jun12 modified for 2.9.3 use wxStringBuffer
	// Create the wxStringBuffer in a specially scoped block. This is not crucial here
	// in this function since the wxString never needs to be accessed directly within
	// this function (as *pstr) after the wxStringBuffer is created. It is good practice
	// however to put it within a specially scoped block, in case someone later uses
	// this function as an example of how to set up a wxStringBuffer.
	{ // begin special scoped block
		wxStringBuffer pBuffer((*pstr), len + 1);
		//wxChar* pBuffer = (*pstr).GetWriteBuf(len + 1);
		wxChar* pBufStart = pBuffer;
		wxChar* pEnd = pBufStart + len;
		wxASSERT(*pEnd == _T('\0'));
		wxChar* ptr = pBuffer;
		while (ptr < pEnd)
		{
			if (*ptr == -111) // left single smart quotation mark
			{
				// we are pointing at a left single smart quote mark, so convert it to a regular single quote mark
				*ptr++ = _T('\'');
			}
			else if (*ptr == -110) // right single smart quotation mark
			{
				// we are pointing at a right single smart quote mark, so convert it to a regular single quote mark
				*ptr++ = _T('\'');
			}
			else if (*ptr == -109) // left double smart quotation mark
			{
				// we are pointing at a left double smart quote mark, so convert it to a regular double quote mark
				*ptr++ = _T('\'');
			}
			else if (*ptr == -108) // right double smart quotation mark
			{
				// we are pointing at a left double smart quote mark, so convert it to a regular double quote mark
				*ptr++ = _T('\'');
			}
			else if (*ptr < 0)
			{
				// there is a hacked 8-bit character besides smart quotes. Warn user that the data will not
				// display correctly in this version, that he should use TecKit to convert the data to Unicode
				// then use the Unicode version of Adapt It
				hackedFontCharPresent = TRUE;
				hackedCt++;
				if (hackedCt < 10)
				{
					int charValue = (int)(*ptr);
					hackedStr += _T("\n   character with ASCII value: ");
					hackedStr << (charValue + 256);
				}
				else if (hackedCt == 10)
					hackedStr += _T("...\n");
				ptr++; // advance but don't change the char (we warn user below)
			}
			else
			{
				ptr++;
			}
		}
		// whm len should not have changed, just release the buffer
	} // end special scoped block - (*pstr) is put back into a normal state at this point
	//(*pstr).UngetWriteBuf(); // whm 8Jun12 removed - not needed with wxStringBuffer above

	// In this case we should warn every time a new doc is input that has the hacked chars
	// so we don't test for  && !gbHackedDataCharWarningGiven here.
	if (hackedFontCharPresent)
	{
		gbHackedDataCharWarningGiven = TRUE;
		wxString msg2 = _("\nYou should not use this non-Unicode version of Adapt It.\nYour data should first be converted to Unicode using TecKit\nand then you should use the Unicode version of Adapt It.");
		wxString msg1 = _("Extended 8-bit ASCII characters were detected in your\ninput document:");
		msg1 += hackedStr + msg2;
		wxMessageBox(msg1, _("Warning: Invalid Characters Detected"), wxICON_EXCLAMATION | wxOK);
	}
}
#endif
#endif


///////////////////////////////////////////////////////////////////////////////
/// \return		TRUE if the passed in (U)SFM marker is \free, \note, or \bt or a derivative
///             FALSE otherwise
/// \param		mkr                     ->  the augmented marker (augmented means it ends with a space)
/// \param      bIsForeignBackTransMkr  <-  default FALSE, TRUE if the marker is \btxxx
///                                         where xxx is one or more non-whitespace
///                                         characters (such as \btv 'back trans of
///                                         verse', \bts 'back trans of subtitle' or
///                                         whatever - Bob Eaton uses such markers in SAG)
/// \remarks
/// Called from: the Doc's TokenizeText().
/// Test for one of the custom Adapt It markers which require the filtered information to
/// be stored on m_freeTrans, m_note, or m_collectedBackTrans string members used for
/// document version 5 (see docVersion in the xml)
///
/// BEW modified 19Feb10 for support of doc version = 5. Bob Eaton's markers will be
/// parsed, and when identified, will be wrapped with filterMkr and filterMkrEnd, and
/// stored in m_filteredInfo; and got from there for any exports where requested; but
/// Adapt It will no longer attempt to treat such foreign markers as "collected", it will
/// just ignore them - but they will be displayed in the Filtered Information dialog.
/// Adapt It's \bt marker will have its content stored in m_collectedBackTrans member
/// instead, and without any preceding \bt. So the added parameter allows us to determine
/// when we are parsing a marker starting with \bt but is not our own because of extra
/// characters in it.
/// BEW 24Oct14, no changes needed for support of USFM nested markers - because these
/// three marker types are never nested, and so \+free, \+note, \+bt etc will never
/// occur in valid USFM marked up text
///////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItDoc::IsMarkerFreeTransOrNoteOrBackTrans(const wxString& mkr, bool& bIsForeignBackTransMkr)
{
	bIsForeignBackTransMkr = FALSE; // initialize to default value
	if (mkr == _T("\\free "))
	{
		return TRUE;
	}
	else if (mkr == _T("\\note "))
	{
		return TRUE;
	}
	else
	{
		int offset = mkr.Find(_T("\\bt"));
		if (offset == 0)
		{
			// check for whether it is our own, or a foreign back trans marker
			int length = mkr.Len();
			if (length > 4)
			{
				// it has at least one extra character before the final space,
				// so it is a foreign one
				bIsForeignBackTransMkr = TRUE;
			}
			return TRUE;
		}
	}
	return FALSE;
}

// BEW March 2010 for support of doc version 5
void CAdapt_ItDoc::SetFreeTransOrNoteOrBackTrans(const wxString& mkr, wxChar* ptr,
	size_t itemLen, CSourcePhrase* pSrcPhrase)
{
	// if it is one of the three custom markers, set the relevent
	// CSourcePhrase member directly here
	wxString filterStr(ptr, (size_t)itemLen);
	size_t len;
	wxChar aChar;
	if (mkr == _T("\\free"))
	{
		filterStr = filterStr.Mid(6); // start from after "\free "
		// remove |@number@| string -- don't bother to return the number value because it
		// is done later in TokenizeText() after this present function returns
		int nFound = filterStr.Find(_T("|@"));
		if (nFound != wxNOT_FOUND)
		{
			// there is the src word count number substring present, remove it and its
			// following space
			int nFound2 = filterStr.Find(_T("@| "));
			wxASSERT(nFound2 - nFound < 10);
			filterStr.Remove(nFound, nFound2 + 3 - nFound);
		}
		len = filterStr.Len();
		// end of filterStr will be "\free*" == 6 characters
		filterStr = filterStr.Left((size_t)len - 6);
		// it may also end in a space now, so remove it if there
		filterStr.Trim();
		// we now have the free translation text, so store it
		pSrcPhrase->SetFreeTrans(filterStr);
	}
	else if (mkr == _T("\\note"))
	{
		filterStr = filterStr.Mid(6); // start from after "\note "
		len = filterStr.Len();
		// end of filterStr will be "\note*" == 6 characters
		filterStr = filterStr.Left((size_t)len - 6);
		// it may also end in a space now, so remove it if there
		filterStr.Trim();
		// we now have the note text, so store it
		pSrcPhrase->SetNote(filterStr);
	}
	else
	{
		// could be \bt, or longer markers beginning with those 3 chars
		wxASSERT(!filterStr.IsEmpty()); // whm 11Jun12 added. GetChar(0) should never be called on an empty string
		int fLen = filterStr.Len();
		if (fLen > 0)
		{
			aChar = filterStr.GetChar(0);
			while (!IsWhiteSpace(&aChar))
			{
				// trim off from the front the marker info, a character at
				// a time
				filterStr = filterStr.Mid(1);
				aChar = filterStr.GetChar(0);
			}
			filterStr.Trim(FALSE); // trim any initial white space
			// it may also end in a space now, so remove it if there
			filterStr.Trim();
			// we now have the back trans text, so store it
			pSrcPhrase->SetCollectedBackTrans(filterStr);
		}
		else
		{
			pSrcPhrase->SetCollectedBackTrans(wxEmptyString);
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \return		pointer to the rest of the input text yet to be parsed
/// \param		ptr			->  ptr to input text, pointing at the next character
///							    after ]
/// \param		pSrcPhrase	->  the CSourcePhrase instance which will store the ] and
///								any punctuation immediately following it
/// \remarks
/// The character sequence, ]"<newline>\s caused a misparse leading to an assert tripping
/// in ParseWord(). The former algorithm of putting only the ] on the pSrcPhrase is
/// deficient. Instead, ] and any puncts after it are to be stored, stop parsing at
/// next whitespace or marker - whichever is first.
/// We assume that punctuation after a ] is only going to be word-final, that is, not
/// belonging to an input word which follows the ] somewhere; and we also assume that
/// a following word will not abutt the preceding ] character
wxChar* CAdapt_ItDoc::HandlePostBracketPunctuation(wxChar* ptr, CSourcePhrase* pSrcPhrase, bool bParsingSrcText)
{
	wxASSERT(*(ptr - 1) == _T(']')); // check ptr is pointing to character after the ] character
	wxChar* p = ptr;
	bool bIsWhitespace = IsWhiteSpace(p);
	bool bIsPunctuation = IsPunctuation(p, bParsingSrcText);
	bool bIsMkr = IsMarker(p);

	while (!bIsWhitespace && !bIsMkr & bIsPunctuation)
	{
		pSrcPhrase->m_follPunct += *p; // store it
		p++; // point at the next character

		bIsWhitespace = IsWhiteSpace(p);
		bIsPunctuation = IsPunctuation(p, bParsingSrcText);
		bIsMkr = IsMarker(p);
	}
	// Provided p is not pointing at a marker, check the possibility that there
	// maybe a further closing curly quote or doublequote (with an intervening
	// space) also following the punctuation characters currently scanned over
	// and saved. If there is, add them to m_follPunct too
	if (!bIsMkr)
	{
		if (!IsEnd(p) && (*p == _T(' ')))
		{
			if (!IsEnd(p + 1L) && IsClosingCurlyQuote(p + 1L))
			{
				// We've a detached closing single or doublequote, so add it in
				// along with the preceding space
				pSrcPhrase->m_follPunct += *p; // the space
				pSrcPhrase->m_follPunct += *(p + 1L); // the curly endquote
				p = p + 2L;
			}
		}
	}
	return p;
}


// We can use this for testing whether the xref span lies before the word or phrase, or
// after it. It's a helper for filtering cross references, so we can determine what kind
// of metadata information to included in the filtered xref string - whether, when
// unfiltering, to restore to pre-word position, or to post word position.
// BEW 30Sep19 created
bool CAdapt_ItDoc::IsXRefNext(wxChar* ptr, wxChar* pEnd) // does a \x marker occur at ptr?
{
	if ((ptr + 20) >= pEnd)
	{
		// not enough space for a xref 
		return FALSE;
	}
	if (*ptr != gSFescapechar)
	{
		return FALSE;
	}
	wxString wholeMkr = GetWholeMarker(ptr);
	wxString augmentedWholeMkr = wholeMkr + _T(' ');
	wxString xref = _T("\\x ");
	return augmentedWholeMkr == xref;
}

wxString CAdapt_ItDoc::FindWordBreakChar(wxChar* ptr, wxChar* pBufStart)
{
	wxUnusedVar(pBufStart); // avoid gcc warning
	wxString strReturn; strReturn = wxEmptyString; // initialize to a "safe" value
	wxChar* pSpann; pSpann = ptr; wxUnusedVar(pSpann);
	wxString mySpan;
	mySpan = wxEmptyString; // init
	// BEW 22Mar23, MUST not return a NULL. pBufStart is a small local span, typically starting with
	// a begin mkr. So what we want to return is the first whitespace earlier than pBufStart, which is
	// where ptr starts off pointing at as well.
	// BEW 13JUL23 the code can currently insert NULL when these no whitespace to grab, so probably the
	// best thing to do is to remove NULL from the function, turn chReturn into strReturn and initialise
	// it to empty string, and handle initial values of other values similarly
	wxChar* pTemp = ptr; // don't corrupt ptr value
	wxChar chLast1 = *(pTemp - 1);
	bool bIsWhitespace = FALSE;
	bIsWhitespace = IsWhiteSpace(pTemp - 1);
	if (bIsWhitespace)
	{
		return (wxString)chLast1;
	}
	else
	{
		mySpan = wxEmptyString;
		return strReturn;
	}
}

// return TRUE if we have an empty CSourcePhrase which has a verse marker and verse number (actually,
// tokBuffer will have the verse marker and number at the time this function is called),
// and a following \p or other marker without content (also in tokBuffer), and ptr is pointing at the
// \v of the next verse. We can get such a situation, for example, if merging to a
// document with some empty CSourcePhrase instances which come from Paratext empty verse
// markers, and the data for merging has an introduced \p marker (or other contentless
// marker) between the empty markers -- without this function, the legacy parser would
// accumulate the preceding \v, verse number, \p, and following \v into the one
// CSourcePhrase, effectively removing the earlier verse from the merged source text
bool CAdapt_ItDoc::ForceAnEmptyUSFMBreakHere(wxString tokBuffer,
	CSourcePhrase* pSrcPhrase, wxChar* ptr)
{
	// the condition for returning TRUE is:
	// 1. tokBuffer has a \v in it already AND
	// 2. ptr points at a \v marker AND
	// 3. m_key is still empty
	wxString aVerseMkr = _T("\\v");
	int offset = tokBuffer.Find(aVerseMkr);
	int nCount = 0;
	if (offset != wxNOT_FOUND && pSrcPhrase->m_key.IsEmpty() && IsVerseMarker(ptr, nCount))
	{
		if (nCount == 2 || nCount == 3)
		{
			// it's a verse marker, ie either \v or \vn
			return TRUE;
		}
	}
	return FALSE;
}

///////////////////////////////////////////////////////////////////////////////
/// \return		nothing
/// \param		useSfmSet		-> an enum of type SfmSet: UsfmOnly, PngOnly, or UsfmAndPng
/// \param		pUnkMarkers		<- a wxArrayString that gets populated with unknown (whole) markers,
///									always populated in parallel with pUnkMkrsFlags.
/// \param		pUnkMkrsFlags	<- a wxArrayInt of flags that gets populated with ones or zeros,
///									always populated in parallel with pUnkMarkers.
/// \param		unkMkrsStr		-> a wxString containing the current unknown (whole) markers within
///									the string - the markers are delimited by spaces following each
///									whole marker.
/// \param		mkrInitStatus	-> an enum of type SetInitialFilterStatus: setAllUnfiltered,
///									setAllFiltered, useCurrentUnkMkrFilterStatus, or
///									preserveUnkMkrFilterStatusInDoc
/// \remarks
/// Called from: the Doc's OnNewDocument(), CFilterPageCommon::AddUnknownMarkersToDocArrays()
/// and CFilterPagePrefs::OnOK().
/// Scans all the doc's source phrase m_markers and m_filteredInfo members and inventories
/// all the unknown markers used in the current document; it stores all unique markers in
/// pUnkMarkers, stores a flag (1 or 0) indicating the filtering status of the marker in
/// pUnkMkrsFlags, and maintains a string called unkMkrsStr which contains the unknown
/// markers delimited by following spaces.
/// An unknown marker may occur more than once in a given document, but is only stored once
/// in the unknown marker inventory arrays and string.
/// The SetInitialFilterStatus enum values can be used as follows:
///	  The setAllUnfiltered enum would gather the unknown markers into m_unknownMarkers
///      and set them all to unfiltered state in m_filterFlagsUnkMkrs (currently
///      unused);
///	  The setAllFiltered could be used to gather the unknown markers and set them all to
///      filtered state (currently unused);
///	  The useCurrentUnkMkrFilterStatus would gather the markers and use any currently
///      listed filter state for unknown markers it already knows about (by inspecting
///     m_filterFlagsUnkMkrs), but process any other "new" unknown markers as unfiltered.
///   The preserveUnkMkrFilterStatusInDoc causes GetUnknownMarkersFromDoc to preserve
///     the filter state of an unknown marker in the Doc, i.e., set m_filterFlagsUnkMkrs
///     to TRUE if the unknown marker in the Doc was within \~FILTER ... \~FILTER* brackets,
///     otherwise sets the flag in the array to FALSE.
/// BEW 24Mar10 updated for support of doc version 5 (some changes were needed)
/// BEW 25Mar15, added 3rd argument to GetMarkersAndEndMarkersFromString() to accomodate the fact
/// that in recent versions (docVersion >= 5?) endmarkers are no longer stored in m_markers
/// but in m_endMarkers
///////////////////////////////////////////////////////////////////////////////
void CAdapt_ItDoc::GetUnknownMarkersFromDoc(enum SfmSet useSfmSet,
	wxArrayString* pUnkMarkers,
	wxArrayInt* pUnkMkrsFlags,
	wxString& unkMkrsStr,
	enum SetInitialFilterStatus mkrInitStatus)
{
	CAdapt_ItDoc* pDoc = gpApp->GetDocument();
	SPList* pList = gpApp->m_pSourcePhrases;
	wxArrayString MarkerList; // gets filled with all the currently used markers including
							// filtered ones
	wxArrayString* pMarkerList = &MarkerList;

	// save the previous state of m_unknownMarkers and m_filterFlagsUnkMkrs to be able to
	// restore any previously set filter settings for the unknown markers, i.e., when the
	// useCurrentUnkMkrFilterStatus enum parameter is passed-in.
	wxArrayString saveUnknownMarkers;
	// wxArrayString does not have a ::Copy method like MFC's CStringArray::Copy, so we'll
	// do it by brute force CStringArray::Copy removes any existing items in the
	// saveUnknownMarkers array before copying all items from the m_unknownMarkers array
	// into it.
	saveUnknownMarkers.Clear();// start with an empty array
	int act;
	for (act = 0; act < (int)gpApp->m_unknownMarkers.GetCount(); act++)
	{
		// copy all items from m_unknownMarkers into saveUnknownMarkers note: do NOT use
		// subscript notation to avoid assert; i.e., do not use saveUnknownMarkers[act] =
		// gpApp->m_unknownMarkers[act]; instead use form below
		saveUnknownMarkers.Add(gpApp->m_unknownMarkers.Item(act));
	}
	wxArrayInt saveFilterFlagsUnkMkrs;
	// again copy by brute force elements from m_filterFlagsUnkMkrs to
	// saveFilterFlagsUnkMkrs
	saveFilterFlagsUnkMkrs.Empty();
	for (act = 0; act < (int)gpApp->m_filterFlagsUnkMkrs.GetCount(); act++)
	{
		// copy all items from m_unknownMarkers into saveUnknownMarkers
		saveFilterFlagsUnkMkrs.Add(gpApp->m_filterFlagsUnkMkrs.Item(act));
	}

	// start with empty data
	pUnkMarkers->Empty();
	pUnkMkrsFlags->Empty();
	unkMkrsStr.Empty();
	wxString EqZero = _T("=0 "); // followed by space for parsing efficiency
	wxString EqOne = _T("=1 "); // " " "

	USFMAnalysis* pSfm;
	wxString key;

	//MapSfmToUSFMAnalysisStruct* pSfmMap; // unused
	//pSfmMap = gpApp->GetCurSfmMap(useSfmSet);
	useSfmSet = useSfmSet; // avoid warning

	// Gather markers from all source phrase m_markers strings
	MapSfmToUSFMAnalysisStruct::iterator iter;
	SPList::Node* posn;
	posn = pList->GetFirst();
	CSourcePhrase* pSrcPhrase;
	while (posn != 0)
	{
		// process the markers in each source phrase m_markers string individually
		pSrcPhrase = (CSourcePhrase*)posn->GetData();
		posn = posn->GetNext();
		wxASSERT(pSrcPhrase);
		if (!pSrcPhrase->m_markers.IsEmpty() || !pSrcPhrase->GetFilteredInfo().IsEmpty())
		{
			// m_markers and/or m_filteredInfo for this source phrase has content to examine
			pMarkerList->Empty(); // start with an empty marker list

			// The GetMarkersAndEndMarkersFromString function below fills the CStringList
			// pMarkerList with all the markers and their associated texts, one per list
			// item. Each item will include end markers for those that have them. Also,
			// Filtered material enclosed within \~FILTER...\~FILTER* brackets will also be
			// listed as a single item (even though there may be other markers embedded
			// within the filtering brackets.
			GetMarkersAndEndMarkersFromString(pMarkerList, pSrcPhrase->m_markers + pSrcPhrase->GetFilteredInfo(),
				pSrcPhrase->GetEndMarkers());
			// Now iterate through the strings in pMarkerList, check if the markers they
			// contain are known or unknown.
			wxString resultStr;
			resultStr.Empty();
			wxString wholeMarker, bareMarker;
			bool markerIsFiltered;
			int mlct;
			for (mlct = 0; mlct < (int)pMarkerList->GetCount(); mlct++)
			{
				// examine this string list item
				resultStr = pMarkerList->Item(mlct);
				wxASSERT(resultStr.Find(gSFescapechar) == 0);
				markerIsFiltered = FALSE;
				if (resultStr.Find(filterMkr) != -1)
				{
					resultStr = pDoc->RemoveAnyFilterBracketsFromString(resultStr);
					markerIsFiltered = TRUE;
				}
				resultStr.Trim(FALSE); // trim left end
				resultStr.Trim(TRUE);  // trim right end
				int strLen = resultStr.Length();
				int posm = 1;
				wholeMarker.Empty();
				// get the whole marker from the string
				while (posm < strLen && resultStr[posm] != _T(' ') &&
					resultStr[posm] != gSFescapechar)
				{
					wholeMarker += resultStr[posm];
					posm++;
				}
				wholeMarker = gSFescapechar + wholeMarker;
				// do not include end markers in this inventory, so remove any final *
				int aPos = wholeMarker.Find(_T('*'));
				if (aPos == (int)wholeMarker.Length() - 1)
					wholeMarker.Remove(aPos, 1);

				wxString tempStr = wholeMarker;
				tempStr.Remove(0, 1);
				bareMarker = tempStr;
				wholeMarker.Trim(TRUE); // trim right end
				wholeMarker.Trim(FALSE); // trim left end
				bareMarker.Trim(TRUE); // trim right end
				bareMarker.Trim(FALSE); // trim left end
				wxASSERT(wholeMarker.Length() > 0);
				// Note: The commented out wxASSERT above can trip if the input text had an
				// incomplete end marker \* instead of \f* for instance, or just an
				// isolated backslash marker by itself \ in the text. Such typos become
				// unknown markers and show in the nav text line as ?\*? etc.

				// lookup the bare marker in the active USFMAnalysis struct map
				// whm ammended 11Jul05 Here we want to use the LookupSFM() routine which
				// treats all \bt... initial back-translation markers as known markers all
				// under the \bt marker with its description "Back-translation"
				pSfm = LookupSFM(bareMarker); // use LookupSFM which properly handles
											  // \bt... forms as \bt
				bool bFound = pSfm != NULL;
				if (!bFound)
				{
					// it's an unknown marker, so process it as such only add marker to
					// m_unknownMarkers if it doesn't already exist there
					int newArrayIndex = -1;
					if (!MarkerExistsInArrayString(pUnkMarkers, wholeMarker,
						newArrayIndex))
					{
						bool bFound = FALSE;
						// set the filter flag to unfiltered for all unknown markers
						pUnkMarkers->Add(wholeMarker);
						if (mkrInitStatus == setAllUnfiltered) // unused condition
						{
							pUnkMkrsFlags->Add(FALSE);
						}
						else if (mkrInitStatus == setAllFiltered) // unused condition
						{
							pUnkMkrsFlags->Add(TRUE);
						}
						else if (mkrInitStatus == preserveUnkMkrFilterStatusInDoc)
						{
							// whm added 27Jun05. After any doc rebuild is finished, we
							// need to ensure that the unknown marker arrays and
							// m_currentUnknownMarkerStr are up to date from what is now
							// the situation in the Doc.
							// Use preserveUnkMkrFilterStatusInDoc to cause
							// GetUnknownMarkersFromDoc to preserve the filter state of an
							// unknown marker in the Doc, i.e., set m_filterFlagsUnkMkrs to
							// TRUE if the unknown marker in the Doc was within \~FILTER
							// ... \~FILTER* brackets, otherwise the flag is FALSE.
							pUnkMkrsFlags->Add(markerIsFiltered);
						}
						else // mkrInitStatus == useCurrentUnkMkrFilterStatus
						{
							// look through saved passed-in arrays and try to make the
							// filter status returned for any unknown markers now in the
							// Doc conform to the filter status in any corresponding saved
							// passed-in arrays.
							int mIndex;
							for (mIndex = 0; mIndex < (int)saveUnknownMarkers.GetCount(); mIndex++)
							{
								if (saveUnknownMarkers.Item(mIndex) == wholeMarker)
								{
									// the new unknown marker is same as was in the saved
									// marker list so make the new unknown marker use the
									// same filter status as the saved one had
									bFound = TRUE;
									int oldFlag = saveFilterFlagsUnkMkrs.Item(mIndex);
									pUnkMkrsFlags->Add(oldFlag);
									break;
								}
							}
							if (!bFound)
							{
								// new unknown markers should always start being unfiltered
								pUnkMkrsFlags->Add(FALSE);
							}
						}
						unkMkrsStr += wholeMarker; // add it to the unknown markers string
						if (pUnkMkrsFlags->Item(pUnkMkrsFlags->GetCount() - 1) == FALSE)
						{
							unkMkrsStr += EqZero; // add "=0 " unfiltered unknown marker
						}
						else
						{
							unkMkrsStr += EqOne; // add "=1 " filtered unknown marker
						}
					}
				}// end of if (!bFound)
			}// end of while (posMkrList != NULL)
		}// end of if (!pSrcPhrase->m_markers.IsEmpty())
	}// end of while (posn != 0)
}

///////////////////////////////////////////////////////////////////////////////
/// \return		a wxString containing a list of whole unknown markers; each
///             marker (xx) formatted as "\xx=0 " or "\xx=1 " with following space within
///             the string.
/// \param		pUnkMarkers*	-> pointer to a wxArrayString of whole unknown markers
/// \param		pUnkMkrsFlags*	-> pointer to a wxArrayInt of int flags indicating
///                                whether the unknown marker is filtered (1)
///                                or unfiltered (0).
/// \remarks
/// Called from: Currently GetUnknownMarkerStrFromArrays() is only called from debug trace
/// blocks of code and only when the _Trace_UnknownMarkers define is activated.
/// Composes a string of unknown markers suffixed with a zero flag and following space ("=0
/// ") if the filter status of the unknown marker is unfiltered; or with a one flag and
/// followoing space ("=1 ") if the filter status of the unknown marker is filtered. The
/// function also verifies the integrity of the arrays, i.e., that they are consistent in
/// length - required for them to operate in parallel.
///////////////////////////////////////////////////////////////////////////////
wxString CAdapt_ItDoc::GetUnknownMarkerStrFromArrays(wxArrayString* pUnkMarkers,
	wxArrayInt* pUnkMkrsFlags)
{
	int ctMkrs = pUnkMarkers->GetCount();
	// verify that our arrays are parallel
	pUnkMkrsFlags = pUnkMkrsFlags; // to avoid compiler warning
	wxASSERT(ctMkrs == (int)pUnkMkrsFlags->GetCount());
	wxString tempStr, mkrStr;
	tempStr.Empty();
	for (int ct = 0; ct < ctMkrs; ct++)
	{
		mkrStr = pUnkMarkers->Item(ct);
		mkrStr.Trim(FALSE); // trim left end
		mkrStr.Trim(TRUE); // trim right end
		mkrStr += _T("="); // add '='
		mkrStr << pUnkMkrsFlags->Item(ct); // add a 1 or 0 flag formatted as string
		mkrStr += _T(' '); // ensure a single final space
		tempStr += mkrStr;
	}
	return tempStr;
}
bool CAdapt_ItDoc::IsGenuineFollPunct(wxChar chPunct)
{
	int offset = wxNOT_FOUND;
	offset = m_strInitialPuncts.Find(chPunct);
	if (offset == wxNOT_FOUND)
	{
		return TRUE;
	}
	return FALSE;
}

// Return -1 if unable to parse to the next whitespace
int CAdapt_ItDoc::ScanToWhiteSpace(wxChar* pChar, wxChar* pEnd)
{
	if (pChar > (pEnd - 1))
	{
		return -1;
	}
	int charCount = 0;
	wxChar* ptr = pChar;
	while (ptr < (pEnd - 1) && !IsWhiteSpace(ptr)) // (pEnd -1) to allow for a terminating whitespace to exist
	{
		ptr++;
		charCount++;
	}
	return charCount;
}

//BEW 16Nov23 need a parser for things like:  12-nha  28-ŋura  26-dja etc. ParseAWord could do it, but that
// is much further below and ParseDate() or ParseChVerseUnchanged() would unhelpfully get called before control
// can get that far. So need something which starts off like ParseDate(), and after the first number there must
// be a hyphen, and after that alphabetic chars. We don't have a reliable test for alphabetics when exotic languages
// are to be supported, so we could just require that after the hyphen every character until whitespace is 
// (a) not punctuation, (b) not a digit. Failure of those tests, return emptyString, (and ParseDate() can have a go)
// else return the whole as wxString non-empty (and caller treats that as signal to skip call of ParseDate() ).
// Declarlation is in .h public access, about line 280
wxString CAdapt_ItDoc::ParseNumberHyphenSuffix(wxChar* pChar, wxChar* pEnd, wxString spacelessPuncts)
{
	wxChar* ptr = pChar;
	wxString strResult = wxEmptyString;
	bool bIsDigit = IsAnsiDigit(*pChar);
	if (!bIsDigit)
	{
		return strResult; // empty
	}
	wxString hyphen = _T("-");
	int nSpanLen = 0; // init
	int offset = wxNOT_FOUND; // init
	wxString strBefore = wxEmptyString;
	wxString strAfter = wxEmptyString;
	// Starts with a digit
	nSpanLen = ScanToWhiteSpace(ptr, pEnd);
	if (nSpanLen > 0)
	{
		strResult = wxString(ptr, nSpanLen);
		offset = strResult.Find(hyphen);
		if (offset == wxNOT_FOUND)
		{
			// no internal hyphen, so return empty string
			strResult.Empty();
			return strResult;
		}
		// We know there is at least one or more initial digits, and there is
		// also a hyphen. But the digits may have a non-digit within, and the
		// post-hyphen content may not be purely alphabetic, so separate into
		// strBefore (check all are digits), and strAfter (check all are not puncts
		// and not digits) in two loops
		strBefore = strResult.Left(offset); //wxString(ptr, offset);
		offset++; // point at what follows the hyphen
		strAfter = strResult.Mid(offset);
		// To be valid, strAfter must contain at least one character. If not, return empty str
		if (strAfter.IsEmpty())
		{
			strResult.Empty();
			return strResult;
		}
		// Now test that contents of strBefore are all digits, and of strAfter neither digits
		// nor alphabetics.
		bool bIsAnsiDigit = FALSE; // init
		wxChar* pEnd;
		int beforeLen = (int)strBefore.Length();
		const wxChar* pBefore = strBefore.GetData(); // pBefore is constant, the loop changes nothing
		pEnd = (wxChar*)pBefore + beforeLen;
		wxChar* pBufStart = (wxChar*)pBefore;
		wxChar* pAux = pBufStart; // init
		while (pAux < pEnd)
		{
			bIsAnsiDigit = IsAnsiDigit(*pAux);
			if (!bIsAnsiDigit)
			{
				// Initial digits string has a non-digit, so function fails to satisfy the structure constraint
				strResult.Empty();
				return strResult;
			}
			// ptr pointed at a digit, so advance ptr to next character
			pAux++;
		}
		// If control did not return within the above loop, then all characters preceding the hyphen are digits
		// Now do similarly for the strAfter: in this case we want no puncts, and no digits in the post-hyphen string
		bIsAnsiDigit = FALSE;
		int afterLen = (int)strAfter.Length();
		const wxChar* pAfter = strAfter.GetData();
		pEnd = (wxChar*)pAfter + afterLen;
		pBufStart = (wxChar*)pAfter;
		pAux = pBufStart; // init
		while (pAux < pEnd)
		{
			bIsAnsiDigit = IsAnsiDigit(*pAux);
			if (bIsAnsiDigit)
			{
				// post-hyphen string has a digit, so function fails to satisfy the structure constraint
				strResult.Empty();
				return strResult;
			}
			// Now test that pAux is not punctuation character
			offset = -1; // init
			offset = spacelessPuncts.Find(*pAux);
			if (offset >= 0)
			{
				// The suffix string contains a punctuation character, so function fails
				// to satisfy the structure constrint
				strResult.Empty();
				return strResult;
			}
			// ptr pointed at a digit, so advance ptr to next character
			pAux++;
		}
		// If control gets to here, all's well: strResult is one or more digits, then a hyphen,
		// and then a suffix string up to the first instance of whitespace, and the suffix
		// string has no digits nor any punctuation. So it's a kosher parsing result.
	}
	return strResult;
	/*  loop processing - clone & tweak from this code from Bill.... 
		// wx version note: Since we require a read-only buffer we use GetData which just
		// returns a const wxChar* to the data in the string theRest.
		const wxChar* ptr = theRest.GetData();
		wxChar* pEnd;
		pEnd = (wxChar*)ptr + len2 - metadataLength; 
		wxChar* pBufStart = (wxChar*)ptr;
	*/
}

// BEW added 16Jun23 for parsing data like 02/26/01 or 02/26/2001, or 2010/05/24, or 12/02
// If parsed successfully, returns the length of the date string. Any error or inconsistency,
// return -1. The date must not include an internal whitespace, return -1 if it does. We
// parse for at least one separator. If there is a second, it mustbe the same - eg, / and / , 
// : and : , or - and - (hyphens); and the string must start and end with a digit. First character,
// a digit, must be what pChar points at. It's okay if what follows, on return, is puncts.
// Bummer. In Gupapuyngu Mark, there is one sequence which is not yet parsed right:  "10:4-ŋuru"
// which means "from 10:4" -- the 10:4 is a chapter:verse, and ParseNumberHyphenSuffix() will have
// rejected it, returning empty string. So ParseDate gets to try next. The suffix is present, after
// a hyphen, but what precedes the hyphen is a substring which contains punctuation (could be : or .)
// and there's no '/' (which by itself is an insufficient test, but is a good test if : or . precede
// a present hyphen. So I need to refactor to reject a string like "10:4-ŋuru"
int CAdapt_ItDoc::ParseDate(wxChar* pChar, wxChar* pEnd, wxString spacelessPuncts)
{
	wxChar* ptr = pChar; wxUnusedVar(ptr); // avoid warning variable initialized but not referenced
	wxString strDate = wxEmptyString; // init
	wxString legal_separators = _T("/-"); // BEW 30Jun23 removed ':' from list, as 7:14 would be 
										  // handled as a date, not ch:verse
	int offset = wxNOT_FOUND; // init
	wxString theSeparator = wxEmptyString; // init
	int separatorCount = 0; // init
	int nSaveOriginalLength = 0; // init
	bool bIsPunct = FALSE; // init
	bIsPunct = bIsPunct;  // avoid gcc set but not used warning

	int dateSpanLen = 0;
	wxChar aChar;
	int charCount = 0;
	//int maxLen = 10; // 2 for days, 2 for months, 4 for year, 2 for separators = 10
	//int minLen = 6;  // 1 for days, 1 for months, 2 for year, 2 for separator = 6
	if (IsAnsiDigit(*pChar))
	{
		// Starts with a digit
		dateSpanLen = ScanToWhiteSpace(pChar, pEnd);
		strDate = wxString(pChar, dateSpanLen);

		{ // scoping span
			//BEW 22Jun23 added code for shortening span if one or more puncts follow.
			int count = 0; // count final puncts that get removed
			wxString revDate = MakeReverse(strDate);

			// loop from start, chucking away every wxChar which is punctuation
			//bool bIsPunct = FALSE;
			aChar = revDate.GetChar(0);

			// BEW 17Nov23 add code to reject data like: "10:4-ŋuru", or same with . instead of :
			// First test is for offset to : or .
			int offset1 = -1;
			int offset2 = -1;
			wxChar chsep1 = _T(':');
			wxChar chsep2 = _T('.');
			offset1 = strDate.Find(chsep1);
			offset2 = strDate.Find(chsep2);
			//bool bHasASeparator = FALSE; // init
			if (offset1 >= 0 || offset2 >= 0)
			{
				return 0;
				// This bool being true is probably sufficient
				//bHasASeparator = TRUE;
			}
			/* for now, comment out
			// What might matter is where the : or . punct separator is in relation to valid date
			// separators ( / or - ), if prior to '/' or especially to '-', then reject the
			// strDate as a valid date
			int offset3 = -1;
			int offset4 = -1;
			wxChar chsep3 = _T('-');
			wxChar chsep4 = _T('/');
			offset3 = strDate.Find(chsep3);
			offset4 = strDate.Find(chsep4);
			// I've not made any comparison tests of the 4 offsets here, as I think bHasASeparator
			// is probably sufficient for rejection
			*/

			int myoffset = wxNOT_FOUND;
			myoffset = spacelessPuncts.Find(aChar);
			// If myoffset returns >= zero, aChar is a final punctuation to be chucked away
			// as we want to parse over only a genuine date - starting and ending with a digit
			while (myoffset >= 0)
			{
				revDate = revDate.Mid(1); // removes 1st punct, shortening revDate
				count++;
				// Prepare for next iteration
				aChar = revDate.GetChar(0);
				myoffset = spacelessPuncts.Find(aChar);
			} // end of punctuation removals loop
			if (count > 0)
			{
				// revString was shortened, and now has no final puncts at end 
				// when reversed back to normal order
				strDate = MakeReverse(revDate);
				dateSpanLen -= count;
			}
		} // end scoping span

		nSaveOriginalLength = dateSpanLen; // needed at end

		// Check the date is well-formed as far as length is concerned.
		// 
		// whm 20Jan2024 removed the following arbitrary length limit of the
		// date. It is not uncommon for people to have dates like 10/May/2020
		// or 10/September/2020 or 10/<some foreign language month name>/2020
		// etc. Even the Hezekiah test file has a 19/May/2025 date in its \id
		// line. The dateSpanLen was determined by scanning to the next white
		// space or pEnd so we should not place an arbitrary limit on the
		// length of the date string.
		//if (dateSpanLen > 10)
		//{
		//	// date format is too long
		//	return -1;
		//}
		int index;
		// Loop until we come to the first separator, then exit after determining what
		// the separator is. If it's not legal, then return -1. (We have up to 3 fields to deal
		// with, so we will use up to 3 loops to traverse them all, shortening strDate and dateSpanLen
		// after each field is handled)
		
		// First loop
		for (index = 0; index < dateSpanLen && separatorCount == 0; index++)
		{
			// We are in the first field of the date
			aChar = strDate.GetChar(index);
			// What is aChar? Either Ansi digit character, or theSeparator, or if neither, 
			// then it's a malformed date --  so return -1 if so
			if (IsAnsiDigit(aChar))
			{
				charCount++;
			}
			else
			{
				// Not a digit, so might be theSeparator character, or the date is malformed
				offset = legal_separators.Find(aChar);
				if (offset >= 0)
				{
					// It's a legal separator, so set theSeparator etc
					theSeparator = aChar;
					charCount++; // count the separator too
					separatorCount = 1;
					break; // this first loop is finished
				}
				else
				{
					// Not a legal separator, so is a malformed date, return -1
					return -1;
				}
			}
		} // end of first loop, with test: for (index = 0; index < dateSpanLen && separatorCount == 0; index++)

		// Prepare for the middle loop, or the last loop (if a field is absent). This is field 2
		strDate = strDate.Mid(charCount);
		dateSpanLen = strDate.Length();
		index = 0;
		charCount = 0;
		wxChar lastChar; // set this for each iteration, so when we exit we can verify that it's an ANSI digit
		lastChar = _T(' '); // initialise to something benign and non-digit - use space (avoids compiler warning)

		// Second loop
		// whm 20Jan2024 modified this loop to accept non-ansi chars for the second loop
		// for dates like 19/May/2005 used in the Hezekiah \id line.
		for (index = 0; index < dateSpanLen && separatorCount == 1; index++)
		{
			// We are in the 2nd field of the date
			aChar = strDate.GetChar(index);
			// What is aChar? Either Ansi digit character, or theSeparator, or if neither, it might be
			// a 2 field date
			// whm 20Jan2024 valid dates should allow the month name or abbreviation to be used

			//if (IsAnsiDigit(aChar))
			//{
				charCount++;
				lastChar = aChar;
			//}
			//else
			//{
				// Not a digit, so might be theSeparator character (for a 3 field date), 
				// or whitespace if it's a 2 field date
				if (aChar == theSeparator)
				{
					// It's a 3 field date, and it's the same legal separator, so this 2nd loop is finished
					charCount++;
					separatorCount++; // now equals 2
					break; // this 2nd loop is finished, successfully
				}
				else
				{
					// aChar is not the separator, so this might be a 2 field date. If so, aChar will be
					// either a whitespace, or punctuation -- check it out. If it checks out, and lastChar
					// is a digit, it's a valid 2-field date
					bIsPunct = FALSE; // re-initialise
					offset = wxNOT_FOUND;
					offset = spacelessPuncts.Find(aChar);
					if (IsWhiteSpace(&aChar) || offset >= 0)
					{
						// It was either whitespace (typically latin space, or newline, or others) or 
						// a punctuation character; so this is a 2 field date, and parsing is done
						if (!IsAnsiDigit(lastChar))
						{
							return -1; // malformed date
						}
						dateSpanLen = nSaveOriginalLength;
						return dateSpanLen;
					}
					//else
					//{
						// Not the same separator, or not at date's end or punctuation which follows,
						// so gotta aasume it's a malformed date, return -1
						//return -1;
					//}
				}
			//}
		} // end of the second loop for test: for (index = 0; index < dateSpanLen && separatorCount == 1; index++)

		// Prepare for the 3rd and final loop
		strDate = strDate.Mid(charCount - 1);
		dateSpanLen = strDate.Length();
		index = 0;
		charCount = 0;
		offset = strDate.Find(theSeparator);
		if (offset >= 0)
		{
			// Error, there can't be 3 or more separators in a valid date
			return -1;
		}

		// Third loop
		for (index = 0; index < dateSpanLen && separatorCount == 2; index++)
		{
			// We are in the last (3rd) field of the date
			aChar = strDate.GetChar(index);
			// What is aChar? Either Ansi character, or theSeparator, or if neither, it's a malformed
			// date so return -1
			if (IsAnsiDigit(aChar))
			{
				charCount++;
				lastChar = aChar;
			}
			else
			{
				// Not a digit, so must be whitespace, or punctuation, or it's a malformed date
				offset = wxNOT_FOUND;
				offset = spacelessPuncts.Find(aChar);
				if (IsWhiteSpace(&aChar) || offset >= 0)
				{
					// It's the same and legal separator, so this 2nd loop is finished & valid
					break; // this 3rd loop is finished, successfully if lastChar is a digit
				}
			}
		} // end of the third loop, for test: for (index = 0; index < dateSpanLen && separatorCount == 2; index++)
		// Check that the lastChar is an Ansi digit, if not, the date is malformed
		if (!IsAnsiDigit(lastChar))
		{
			return -1; //malformed date
		}
		// If control gets here, all was well - for a 3-field valid date
		dateSpanLen = nSaveOriginalLength;
	} // end of TRUE block for test: if (IsAnsiDigit(*pChar))
	else
	{ 
		//pChar does not point at a digit, return -1
		return -1;
	}
	return dateSpanLen;
}

// BEW 7Jun23 created next, for parsing final puncts, which may be all or some detached by preceding
// whitespace(s), and getting to the puncts may require parsing first over one or more inlineBindingEndMarkers
wxChar* CAdapt_ItDoc::ParsePostWordPunctsAndEndMkrs(wxChar* pChar, wxChar* pEnd, CSourcePhrase* pSrcPhrase, int& itemLen, wxString spacelessPuncts)
{
	// pChar comes in, pointing at the first wxChar following whatever ParseAWord() parsed over, and the caller will have
	// a len value which is not zero. We parse over binding endMkr if present, then over puncts (detached or not) - and there
	// maybe a more than one sequence of "<whitespace(s)><followingPunct(s)>" to parse over, e.g. "jooni ! » Daaru" in Steve White's
	// source data. pSrcPhrase is needed so anything parsed over can be appropriately stored. itemLen tracks how many characters are
	// parsed over up to the point control returns to ParseWord(); and our internal ptr will have advanced that far, so is returned
	// to ParseWord(). After this function returns, we test for what to do next - as further down in ParseWord() we have a lot of smarts
	// for parsing complex markup - like in foonotes, and nonbinding endMkrs, and even more detached or non-detached puncts.
	// itemLen is returned to the caller, so that the caller's len value can be increased to match where ptr got to.
	wxChar* ptr = pChar;
	CAdapt_ItApp* pApp = &wxGetApp(); // for access to the m_charFormatEndMkrs fast-access string (inline binding endMkrs)
	wxChar space = _T(' ');
	// BEW 20Jun23, the following assert causes infinite loop if pSrcPhrase->m_key is empty. Being empty is unusual, but
	// if we don't advance ptr by at least one wxChar, then the infinite loop happens. So I'll try saving a asterisk in m_key and
	// m_srcPhrase, and return itemLen = 1,  and ptr advanced by 1. If no subsequent content is added in the caller, an 
	// isolated asterisk will be seen but carry no meaning, it would be in the GUI as a pSrcPhrase, & prevent an app infinite loop

	if (pSrcPhrase == NULL)
		return ptr;

	if (pSrcPhrase->m_key.IsEmpty())
	{
		// BEW 18Jul23, putting * was not a good idea to Bill, nor to me. Perhaps do something meaningful instead, like
		// <empty-key> ( length 11 ) as m_key and m_srcPhrase, which still protects from an infinite loop
		// BEW 25Aug23 the < and > are not essential, and might be causing an infinite loop (Bill reported 25Aug23), 
		// especially for src data where m_srcPhrase has valid puncts "<<" preceding; so I'll remove them
		// whm 13Mar2024 removed. I don't think it is necessary to put "empty-key" into the text, and I don't think
		// returning the ptr now without advancing it would cause an infinite loop. Basically this pSrcPhrase can be
		// treated as just an "empty" marker source phrase like any other empty content marker.
		//pSrcPhrase->m_key << _T("empty-key");
		//pSrcPhrase->m_srcPhrase << _T("empty-key");
		//ptr += 9;
		//itemLen = 9;
		return ptr;
	}
	//wxASSERT(!pSrcPhrase->m_key.IsEmpty());
	int offset = wxNOT_FOUND; // init
	wxString wholeMkr = wxEmptyString;
	wxString augWholeMkr = wxEmptyString;
	int numEndPuncts; numEndPuncts = 0; // init
	wxString strEndPuncts; strEndPuncts = wxEmptyString; // init
	
	int itemSpan = 0; // this is an item length valid only for the current iteration, the loop may iterate several times, and
					  // each time set a new itemItemSpan when parsed data is stored in pSrcPhrase; but we need to accumulate
					  // these small spans' lengths for as long as the loop iterates, so use itemLenAccum for that.
	int itemLenAccum = 0; // When ParsePostWordPuncts() is exited, set parameter itemLen to its value, with ptr agreeing
						  // (we can do that in one line, itemLen = itemLenAccum). It's not possible to know ahead of
						  // calling ParsePostWordPuncts() just how many iterations will be needed.
	int mkrLen = 0; // init
	itemLen = 0; // init
	// What might follow pSrcPhrase->m_key?
	// 1. no endMkr or puncts, but just a space or newline signalling it's time to return in caller, to generate next pSrcPhrase
	// 2. An endmkr belonging to m_charFormatEndMkrs fast-access string. Inline binding end markers 'bind', so we can assumme
	//    there is no punctuation before it, but there may be after it - either attached, or detached by whitespace
	// 3. Punctuation character(s) - may be more than one in sequence, but usually one; or the same but following the endMkr of 2.
#if defined (_DEBUG) && !defined(NOLOGS)
	if (pSrcPhrase->m_nSequNumber >= 8)
	{
		int halt_here = 1; wxUnusedVar(halt_here); // avoid warning variable initialized but not referenced
	}
#endif
	if (*ptr == gSFescapechar)
	{
		// the marker at ptr may be an endMkr, belonging to the m_charFormatEndMkrs set. 
		wholeMkr = GetWholeMarker(ptr);
		wxASSERT(!wholeMkr.IsEmpty());
		augWholeMkr = wholeMkr + space;
		offset = pApp->m_charFormatEndMkrs.Find(augWholeMkr);
		//if (offset == wxNOT_FOUND)
		if (offset >= 0)
		{
			// It's an inline binding end marker, so parse over it, and store in the pSrcPhrase->m_inlineBindingEndMarkers
			mkrLen = wholeMkr.Length();
			wxString strBinds = pSrcPhrase->GetInlineBindingEndMarkers();
			strBinds << wholeMkr;
			pSrcPhrase->SetInlineBindingEndMarkers(strBinds);
			itemSpan = mkrLen;
			itemLenAccum += itemSpan;
			ptr += itemSpan; // ptr has advanced
			itemLen += itemSpan;
		}
	} // end of TRUE block for test: if (*ptr = gSFescapeChar)
	else
	{
		// BEW 18Jul23, not having this else block earlier was a source of error when
		// the input source data at this current pSrcPhrase was ptr pointing at ",\\it*\n....".
		// The do loop below expects ptr to point at backslash, but unparsed comma prevents that,
		// so the do loop below skips where the \it* marker would get correctly parsed, and control
		// enters the else block, where comma does get parsed, but a bad test of pNext (I'll fix
		// this now too) causes a break from the do loop, and \it* is left unparsed - so that the
		// next pSrcPhrase sees it as an unknown endMkr and puts up an error message telling the
		// user what marker it is and presenting it in a context of surrounding words. So here,
		// I need to parse over the punct, to get to the endMkr
		numEndPuncts = ParseFinalPuncts(ptr, pEnd, spacelessPuncts);  // a span of puncts, or none
		if (numEndPuncts > 0)
		{
			// Parsed one or more puncts, deal with them, update ptr, augment itemSpan, & itemLenAccum
			strEndPuncts = wxString(ptr, numEndPuncts); // will be empty if ptr is not at a punct
			pSrcPhrase->m_follPunct << strEndPuncts;
			pSrcPhrase->m_srcPhrase << strEndPuncts;
			itemSpan += numEndPuncts;
			itemLenAccum += itemSpan;
			ptr += itemSpan; // ptr has advanced, so for data like ",\\it*" ptr now points at the \it* endMkr
				// and so the do loop below will correctly pick up the \it* marker and process it right. But
				// if a beginMkr (e.g. \f ) is at ptr, then that belongs on the next pSrcPhrase - so check
				// and if so, force return here after doing necessary updates
			itemLen += itemSpan;

			/* Remove this stuff, best idea is to hand over now to the do loop
			wxString wholeMkr; wholeMkr = wxEmptyString;
			bool bIsEndMkr; bIsEndMkr = FALSE; // init
			bool bIsBeginMkr; bIsBeginMkr = FALSE; // init
			bIsBeginMkr = IsBeginMarker(ptr, pEnd, wholeMkr, bIsEndMkr);
			if (*ptr == gSFescapechar && bIsBeginMkr)
			{
				// If TRUE, then the beginMkr at ptr belongs on the next pSrcPhrase, so return itemLen in
				// signature, and ptr value 
				itemLen = itemLenAccum;
				return ptr;
			}
			*/
		} // end of TRUE block for test: if (numEndPuncts > 0)
	} // end of the else block for test: if (*ptr == gSFescapechar)

#if defined (_DEBUG) && !defined(NOLOGS) // && defined (LOGMKRS)
	wxString mypointsAt = wxString(ptr, 16);
	wxLogDebug(_T("ParsePostWordPunctsAndEndMkrs(), before its while loop: line %d, sn= %d, in ParseWord() ptr= [%s]"),
		__LINE__,  pSrcPhrase->m_nSequNumber, mypointsAt.c_str() );
	if (pSrcPhrase->m_nSequNumber >= 13)
	{
		int halt_here = 1; wxUnusedVar(halt_here); // avoid warning variable initialized but not referenced
	}
#endif

	// Now ptr points at one of these options (longest first, shortest last):
	// 1. One or more substrings of type: space + punct(s)
	// 2. A mix of undetached puncts and substrings of type: space + punct(s)
	// 3. No whitespace(s) but post-word punctuation (but not including any pre-word begining puncts for 
	//    m_precPunct on next pSrcPhrase)
	// 4. No whitespace(s), but another post-word endMkr
	// 5. A whitespace (or newline, or gSfescapechar) preceding which, ptr should be returned to ParseWord(), 
	//    for the caller to initiate returning len to start off a new pSrcPhrase

	// Start with 1. above
	int numSpaces;
	wxString strEndSpaces;
	int numGoodOnes = 0;
	int numBadOnes = 0;
	wxChar* pAux;

	pAux = ptr;  // use pAux for parsing over one or more following puncts; do all options for each iteration
	bool bIterateAgain = TRUE;
	bool bParsedOverNonbindingEndMarker = FALSE; // whm 30Mar2024 added
	while (bIterateAgain)
	{
		// pAux and itemSpan apply only to the current iteration, they are reset to ptr and 0 at every new iteration
		pAux = ptr;  // use pAux for parsing over one or more following puncts; do all options for each iteration
		itemSpan = 0; // init to zero at each iteration

		// BEW 8Jul23 following a parsed endMkr, item 4 above is the possibility that another endMkr follows
		// immediately, there could be more than one, so check for ptr pointing at gSFescapechar, and if that
		// is an endMkr, parse over, update ptr, store it in m_endMarkers, update itemSpan for this iteration
		// add to itemLenAccum, set bIterateAgain TRUE
		if (*pAux == gSFescapechar)
		{
			// First try for an inline binding endMkr
			wholeMkr = GetWholeMarker(pAux);
			wxASSERT(!wholeMkr.IsEmpty());
			augWholeMkr = wholeMkr + space;
			offset = pApp->m_charFormatEndMkrs.Find(augWholeMkr);
			if (offset >= 0)
			{
				// It's an inline binding end marker, so parse over it, and store in
				// pSrcPhrase->m_inlineBindingEndMarkers
				mkrLen = wholeMkr.Length();
				wxString strBinds = pSrcPhrase->GetInlineBindingEndMarkers();
				strBinds << wholeMkr;
				pSrcPhrase->SetInlineBindingEndMarkers(strBinds);
				itemSpan = mkrLen;
				pAux += itemSpan;
				ptr += itemSpan; // ptr has advanced
				itemLenAccum += itemSpan;
				// whm 19Jul2023 added. The itemLenAccum value is here being updated, but the function's
				// ref parameter itemLen doesn't get updated below for the parsing of a \fk* end marker
				// within the 41MATNYNT.SFM input file. This ultimately results in the item len back in
				// TokenizeText() having a value of 6 instead of 10 when ptr points at "ai.\\fk*\\f*\n..."
				// which taking 6 chars results in "ai.\\fk" instead of "ai.\\fk*\\f*". That situation
				// results in an extraneous source phrase created that just contains an asterisk m_key.
				// and going through more loops that eventually result in the footnote end marker \f*
				// being duplicated and stored in the source phrase that follows the extraneous asterisk
				// one.
				itemLen = itemLenAccum;
				bIterateAgain = TRUE;
			}
			else
			{
				// offset returned wxNOT_FOUND, so (ptr and) pAux while pointing at a marker,
				// it may be of a different type - of the inline non-binding type, like \wj*
				wholeMkr = GetWholeMarker(pAux);
				wxASSERT(!wholeMkr.IsEmpty());
				augWholeMkr = wholeMkr + space;
				offset = pApp->m_inlineNonbindingEndMarkers.Find(augWholeMkr);
				if (offset >= 0)
				{
					// blue end markers fast access set includes \wj* and 13 others
					mkrLen = wholeMkr.Length();
					wxString strNonbinding = pSrcPhrase->GetInlineNonbindingEndMarkers();
					strNonbinding << wholeMkr;
					pSrcPhrase->SetInlineNonbindingEndMarkers(strNonbinding);
					itemSpan = mkrLen;
					pAux += itemSpan;
					ptr += itemSpan; // ptr has advanced
					itemLenAccum += itemSpan;
					bIterateAgain = TRUE;
					bParsedOverNonbindingEndMarker = TRUE; // whm 30Mar2024 added
				} // end of TRUE block for test: if (*pAux == gSFescapechar) -- inner
				else
				{
					// Quite possibly pAux is pointing at a beginMkr. We must deal with that
					// if so, otherwise control will enter the block for showing the user
					// a message dialog saying the marker is unknown - and then the next
					// pSrcPhrase will fail if it is asked to handle a beginMkr
					bool bIsEndMkr; bIsEndMkr = FALSE; // init
					wxString nextWholeMkr; nextWholeMkr = wxEmptyString; // init
					bool bIsBeginMkr; wxString endMkrs;
					bIsBeginMkr = IsBeginMarker(pAux, pEnd, nextWholeMkr, bIsEndMkr);
					// BEW 17Oct23 need a block here to handle legitimate endmkrs, e.g. \f* when unfiltering
					bIsEndMkr = IsEndMarker(pAux, pEnd);
					if (pAux < pEnd && bIsEndMkr)
					{
						nextWholeMkr = GetWholeMarker(pAux);
						augWholeMkr = nextWholeMkr + space;
						offset = pApp->m_RedEndMarkers.Find(augWholeMkr); // this set includes \f* and many others
						if (offset >= 0)
						{

							mkrLen = nextWholeMkr.Length();
							itemSpan = mkrLen;
							endMkrs = pSrcPhrase->GetEndMarkers();
							endMkrs << nextWholeMkr;
							pSrcPhrase->SetEndMarkers(endMkrs); 
							pAux += itemSpan;
							ptr += itemSpan; // ptr has advanced
							itemLenAccum += itemSpan;
							bIterateAgain = TRUE;
						} // end of TRUE block for test: if (pAux < pEnd && bIsEndMkr)
						else
						{
							goto unknown;
						}
					}
					else if (pAux < pEnd && bIsBeginMkr )
					{
						// Must exit the loop immediately, beginMkrs belong on the next pSrcPhrase
						ptr = pAux;
						itemLen = itemLenAccum;
						bIterateAgain = FALSE;
					} // end of TRUE block for test: if (pAux < pEnd && bIsBeginMkr )
					else
					{
unknown:				bool bIsAnEndMkr;
						bIsAnEndMkr = FALSE; // initialize
						bIsAnEndMkr = bIsAnEndMkr; // avoid gcc warning set but not used warning
						int myOffset; myOffset = wxNOT_FOUND; // init
						myOffset = wholeMkr.Find(wxString(_T('*')));
						wxString wholeEndMkr;
						wxString strBefore;
						wxString strAfter;
						if (myOffset != wxNOT_FOUND)
						{
							// The whole mkr contains *, so is an endmarker -- this is
							// a parsing error because the endmarker should have been
							// included in the parse done by ParseWord() for the previous
							// CSourcePhrase instance, because it's ParseWord which handles
							// post-word endmarkers
							wholeEndMkr = wholeMkr;
							bIsAnEndMkr = TRUE;
						}
						wxString strApproxLocation;
						strApproxLocation = wxEmptyString; // init
						int curSN = pSrcPhrase->m_nSequNumber;
						CAdapt_ItView* pView;
						pView = gpApp->GetView();
						CPile* pCurPile;
						pCurPile = pView->GetPile(curSN);
						if (pCurPile != NULL)
						{
							CSourcePhrase* pCurSrcPhrase;
							// BEW 17Oct23 a better choice for pCurSrcPhrase is the passed in pSrcPhrase
							//pCurSrcPhrase = pCurPile->GetSrcPhrase();
							pCurSrcPhrase = pSrcPhrase;
							if (pCurSrcPhrase != NULL)
							{
								wxString curKey;
								curKey = pCurSrcPhrase->m_key;
								// BEW15Dec22 try to provide an approximate src string for the error - 30 chars
								// either side of the ptr value, or less if near start of end of input source text
								CSourcePhrase* pSPLocBefore = NULL; // go back 5 pSrcPhases, or to the sn = 0 one
								pSPLocBefore = pSPLocBefore; // avoid gcc warning set but not used warning
								CSourcePhrase* pSPLocAfter = NULL; // go forward 5 pSrcPhases, or to the sn = MAXINDEX one
								pSPLocAfter = pSPLocAfter; // avoid gcc warning set but not used warning
								CPile* pLocBefore_Pile;
								CPile* pLocAfter_Pile;
								int maxIndex; maxIndex = gpApp->GetMaxIndex();
								int snLocBefore; snLocBefore = curSN; // initialise
								int snLocAfter; snLocAfter = curSN; // initialise
								int snLocAfterEnd; snLocAfterEnd = curSN; // initialise
								snLocBefore -= 2; // BEW 17Oct23 was 5 
								snLocAfter += 1; // starting at next after curSN
								snLocAfterEnd = snLocAfter + 2; // BEW 17Oct23 was 5
								if (snLocBefore > 0)
								{
									// At least 2 previous pSrcPhrase instances are available
									pLocBefore_Pile = pView->GetPile(snLocBefore);
									wxASSERT(pLocBefore_Pile != NULL); // change later into an if/else test ********
								}
								else
								{
									// Too close to start of doc to fit 2, so start at sn = 0 pile
									pLocBefore_Pile = pView->GetPile(0);
									wxASSERT(pLocBefore_Pile != NULL);
								}
								pSPLocBefore = pLocBefore_Pile->GetSrcPhrase();
								// while loop in GetAccumulatedKeys() finishes one short of curSN
								strBefore = GetAccumulatedKeys(pApp->m_pSourcePhrases, snLocBefore, curSN);

								// Next, similar calulations to  get strAfter set, starting from curSN + 1
								pLocAfter_Pile = pView->GetPile(snLocAfter);
								wxASSERT(pLocAfter_Pile != NULL);
								pSPLocAfter = pLocAfter_Pile->GetSrcPhrase();
								if (snLocAfterEnd < maxIndex)
								{
									// There is enough room for 5 piles following curSN  to be accessed
									strAfter = GetAccumulatedKeys(pApp->m_pSourcePhrases, snLocAfter, snLocAfterEnd);
								}
								else
								{
									// Not enough room to access five, so access to maxIndex
									strAfter = GetAccumulatedKeys(pApp->m_pSourcePhrases, snLocAfter, maxIndex);
								}
								wxString space; space = _T(" ");
								strApproxLocation = strBefore;
								strApproxLocation << curKey;
								strApproxLocation << space;
								strApproxLocation << strAfter;

								// We must not lose the unknown endMkr, append it in pSrcPhrase's m_endMarkers, update ptr and
								// itemLenAccum (that advances ptr, which prevents infinite looping, and break from the loop
								int theMkrLen; theMkrLen = wholeEndMkr.Length();
								wxString m_endmkrs; m_endmkrs = pSrcPhrase->GetEndMarkers();
								m_endmkrs << wholeEndMkr;
								pSrcPhrase->SetEndMarkers(m_endmkrs);
								ptr += theMkrLen;
								itemLenAccum += theMkrLen;
								itemLen += theMkrLen; // returned by signature, keep ptr and what's parsed over, in sync

								wxString msg = _("Warning: While loading source text, encountered unexpected end-marker: %s \nPossibly occurs in the pile following: %s\n in the span: %s \n Either correct the unknown end-marker and reload the file, or just ignore the error.");
								msg = msg.Format(msg, wholeEndMkr.c_str(), curKey.c_str(), strApproxLocation.c_str());
								//wxString title = _T("Warning: Unexpected End Marker"); // BEW 17Oct23 don't display the msg box, just use LogUserAction()
								//wxMessageBox(msg, title, wxICON_WARNING | wxOK);
								pApp->LogUserAction(msg); // whm 17Oct2023 commented out - see note above.
								bIterateAgain = FALSE;
							} // end of TRUE block for test: if (pCurSrcPhrase != NULL)

						} // end of TRUE block for test: if (pPile != NULL)
						bIterateAgain = FALSE;

					} // end of else block for test: if (pAux < pEnd && bIsBeginMkr )
				} // end of else block for test: if (offset >= 0)

			} // end of else block for more outer test: if (offset >= 0)

		} // end of TRUE block for test: if (*pAux == gSFescapechar)
		else
		{
			// pAux does not point at gSFescapechar
			numSpaces = CountWhitesSpan(pAux, pEnd);
			strEndSpaces = wxString(pAux, numSpaces); // empty if numSpaces is 0
			if (numSpaces == 0)
			{
				// No spaces parsed over, so pAux remains at ptr so far, for this iteration,
				// and if there is a final punct at pAux (or more than one punct), they are
				// genuine following ones, provided it or each does not belong to strInitialPuncts
				numEndPuncts = ParseFinalPuncts(pAux, pEnd, spacelessPuncts);  // a span of puncts, or none
				strEndPuncts = wxString(pAux, numEndPuncts); // a string, will be empty if pAux is not at a punct
				if (numEndPuncts == 0)
				{
					// If zero whites and zero puncts, we have a word which either has only a
					// m_charFormatMarker we've already parsed and stored on pSrcPhrase, or no
					// inline binding endMkr, so a word with no ending punctuation. So we have
					// enough information to exit the do loop here - beware, it may not be the
					// first iteration
					itemLen = itemLenAccum;
					ptr = pChar + itemLen;
					return ptr;
				} // end of TRUE block for test: if (numEndPuncts == 0)
				else
				{
					// numEndPuncts is 1 or more. So get them (they are not detached; e.g. Iisa, 
					// where the comma punct follows a name for Jesus), and check that begin puncts
					// for next pSrcPhrase are counted, so we can adjust numEndPunct and strEndPuncts
					// to only have genuine word-following final puncts. (They may all be rejected as
					// non-genuine, return ptr unmoved in this iteration, beware, previous iterations
					// may have parsed puncts, stored on pSrcPhrase, and accumulated itemSpan into
					// itemLenAccum, so use the latter for returning a value to itemLen.)
					CountGoodAndBadEndPuncts(strEndPuncts, numGoodOnes, numBadOnes); // for this iteration
					if (numEndPuncts == numGoodOnes)
					{
						// All of the puncts parsed over, are genuine following puncts, for storing in m_follPunct
						// at this iteration; so do the stores and updates and continue looping - a detached punct
						// may follow - keep looping until ptr does not advance
#if defined (_DEBUG) && !defined(NOLOGS)
						if (pSrcPhrase->m_nSequNumber >= 2)
						{
							int halt_here = 1;
	