/////////////////////////////////////////////////////////////////////////////
/// \project		adaptit
/// \file			Adapt_It.cpp
/// \author			Bill Martin
/// \date_created	05 January 2004
/// \rcs_id $Id$
/// \copyright		2008 Bruce Waters, Bill Martin, SIL International
/// \license		The Common Public License or The GNU Lesser General Public
///                 License (see license directory)
/// \description This is the implementation file for the CAdapt_ItApp class and the
/// AIModalDialog class. The CAdapt_ItApp class initializes Adapt It's application and gets
/// it running. Most of Adapt It's global enums, structs and variables are declared either
/// as members of the CAdapt_ItApp class or in this source file's global space. The
/// AIModalDialog class provides Adapt It with a modal dialog base class which turns off
/// Idle and UIUpdate processing while the dialog is being shown. \derivation The
/// CAdapt_ItApp class is derived from wxApp, and inherits its support for the
/// document/view framework. The AIModalDialog class is derived from wxDialog.
/////////////////////////////////////////////////////////////////////////////


#if defined(__GNUG__) && !defined(__APPLE__) //The GNU C++ compiler defines this.
// Testing it is equivalent to testing (__GNUC__ && __cplusplus).
#pragma implementation "Adapt_It.h"
#endif


// For compilers that support precompilation, includes "wx.h".
#include <wx/wxprec.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
// Include your minimal set of headers here, or wx.h
#include <wx/wx.h>
#endif

// whm refactored printing 10Oct2016
// ------------------------------------------------------------
#if !wxUSE_PRINTING_ARCHITECTURE
#error "You must set wxUSE_PRINTING_ARCHITECTURE to 1 in setup.h, and recompile the library."
#endif

#include <ctype.h>
#include <wx/metafile.h>
#include <wx/print.h>
#include <wx/printdlg.h>
#include <wx/image.h>
#include <wx/accel.h>

#if wxUSE_POSTSCRIPT
#include <wx/generic/printps.h>
#include <wx/generic/prntdlgg.h>
#endif

#if wxUSE_GRAPHICS_CONTEXT
#include <wx/graphics.h>
#endif

#ifdef __WXMAC__
#include <wx/osx/printdlg.h>
#endif
#ifdef __WXMSW__
#define NOMINMAX
#include <windows.h>
int __cdecl system(const char*); // used in CallExecute()
//extern "C"
//{
//   int main(const char* args)
//    {
//        ShowWindow(GetConsole(), 0);
//        system(args);
//    }   
//}
#endif
// ------------------------------------------------------------

// wxWidgets library includes
#include <wx/docview.h>	// includes wxWidgets doc/view framework
#include "Adapt_ItCanvas.h"
#include "Adapt_It_Resources.h"
#include <wx/snglinst.h> // for wxSingleInstanceChecker in OnInit
#include <wx/config.h> // for wxConfig in OnInit
#include <wx/fileconf.h> // for wxFileConfig in Oninit
#include <wx/datetime.h> // for wxDateTime in OnInit
#include <wx/filesys.h> // for wxFileName
#include <wx/utils.h> // for ::wxDirExists, ::wxSetWorkingDirectory, etc
#include <wx/textfile.h> // for wxTextFile
#include <wx/encconv.h> // for wxEncodingConverter

// whm 14Jun12 modified to #include <wx/fontdate.h> for wxWidgets 2.9.x and later
#if wxCHECK_VERSION(2,9,0)
#include <wx/fontdata.h>
#endif

#include <wx/fontmap.h> // for wxFontMapper
#include <wx/dir.h> // for wxDir
#include <wx/hashmap.h> // for equivalent to MFC's CMapStringToOb* pMap in DoKBIntegrityCheck()
#include <wx/datstrm.h> // for wxDataOutputStream() and wxDataInputStream()
#include <wx/wfstream.h> // for wxFileOutputStream() and wxFileInputStream()
#include <wx/txtstrm.h> // for wxTextOutputStream()
#include <wx/cmdline.h> // for wxCmdLineParser
#include <wx/wizard.h> // for wxWizard
#include <wx/fdrepdlg.h> // for wxFindReplaceDialog
#include <wx/fontenum.h> // for wxFontEnumerator
#include <wx/busyinfo.h>
#include <wx/propdlg.h> // for wxPropertySheetDialog
#include <wx/stdpaths.h> // for GetResourcesDir and GetLocalizedResourcesDir
#include <wx/tooltip.h>
#include <wx/process.h> // for wxProcess::Exists()
#include <wx/toolbar.h> // (to allow wxWidgets to select an appropriate toolbar class)
#include <wx/tbarbase.h> // (the base class)
#include <wx/clipbrd.h> // for the clipboard support needed for Bob Eaton's adapting of clipboard text feature

// the next are for wxHtmlHelpController (wxWidgets chooses the appropriate help controller
// class)
#include <wx/filesys.h>
#include <wx/fs_arc.h>
#include <wx/html/helpctrl.h> //(wxHTML based help controller: wxHtmlHelpController)
#include <wx/cshelp.h> // for wxHelpControllerHelpProvider

#include <wx/html/htmlwin.h> // for display of the "Help for Administrators.htm" file from the Administrator menu

#include <wx/display.h> // for wxDisplay

#include <wx/dynlib.h> // for wxDynamicLibrary and ECDriver.dll on Windows
#include <wx/filepicker.h> // for wxDirPickerCtrl
#include <wx/log.h> // for wxLogStream
#include <wx/timer.h> // for wxTimer
#include <wx/tokenzr.h>
#include <wx/stockitem.h> // for ::wxGetStockLabel()
//#if defined(_KBSERVER)
//#include <wx/thread.h>

//#endif

// whm 4Jul2021 commented out all curl code reference
// libcurl
//#include <curl/curl.h>

extern bool gbShowTargetOnly;

wxMutex	kbsvr_arrays;

extern wxCriticalSection g_jsonCritSect;

wxMutex s_AutoSaveMutex;

// Comment out to prevent DoServiceDiscovery() from logging with wxLogDebug()
//#define _DOSERVDISC
//#define ERR_DUPLICATE
//#define FREETRMODE

//#define NOLOGS

// vectorized bitmaps
#include "../res/vectorized/document_new_16.cpp"
#include "../res/vectorized/document_open_16.cpp"
#include "../res/vectorized/document_save_16.cpp"
#include "../res/vectorized/edit_cut_16.cpp"
#include "../res/vectorized/edit_copy_16.cpp"
#include "../res/vectorized/edit_paste_16.cpp"
#include "../res/vectorized/document_print_16.cpp"
#include "../res/vectorized/dialog_guesser_16.cpp"
#include "../res/vectorized/dialog_notes_16.cpp"
#include "../res/vectorized/note_next_16.cpp"
#include "../res/vectorized/note_prev_16.cpp"
#include "../res/vectorized/note_delete_all_16.cpp"
#include "../res/vectorized/bounds_go_16.cpp"
#include "../res/vectorized/bounds_stop_16.cpp"
#include "../res/vectorized/format_hide_punctuation_16.cpp"
#include "../res/vectorized/format_show_punctuation_16.cpp"
#include "../res/vectorized/go_first_16.cpp"
#include "../res/vectorized/go_last_16.cpp"
#include "../res/vectorized/go-to_16.cpp" // whm 25Oct2022 changed go_previous_16.cpp to go-to_16.cpp
#include "../res/vectorized/go_up_16.cpp"
#include "../res/vectorized/go_down_16.cpp"
#include "../res/vectorized/phrase_new_16.cpp"
#include "../res/vectorized/phrase_remove_16.cpp"
#include "../res/vectorized/retranslation_new_16.cpp"
#include "../res/vectorized/retranslation_edit_16.cpp"
#include "../res/vectorized/retranslation_delete_16.cpp"
#include "../res/vectorized/insplaceholder_left_16.cpp" // whm 20Mar2020 changed placeholder_new_16.cpp to insplaceholder_left_16.cpp
#include "../res/vectorized/insplaceholder_right_16.cpp" // whm 20Mar2020 added insplaceholder_right_16.cpp for better directional control
#include "../res/vectorized/placeholder-delete_16.cpp"
#include "../res/vectorized/dialog_choose_translation_16.cpp"
#include "../res/vectorized/show_target_16.cpp"
#include "../res/vectorized/show_source_target_16.cpp"
#include "../res/vectorized/dialog_view-translation-or-glosses_16.cpp"
#include "../res/vectorized/punctuation_copy_16.cpp"
#include "../res/vectorized/punctuation_do_not_copy_16.cpp"
#include "../res/vectorized/help_browser_16.cpp"
#include "../res/vectorized/document-new_22.cpp"
#include "../res/vectorized/document-open_22.cpp"
#include "../res/vectorized/document-save_22.cpp"
#include "../res/vectorized/edit-cut_22.cpp"
#include "../res/vectorized/edit-copy_22.cpp"
#include "../res/vectorized/edit-paste_22.cpp"
#include "../res/vectorized/document-print_22.cpp"
#include "../res/vectorized/dialog-guesser_22.cpp"
#include "../res/vectorized/dialog-notes_22.cpp"
#include "../res/vectorized/note-next_22.cpp"
#include "../res/vectorized/note-prev_22.cpp"
#include "../res/vectorized/note-delete-all_22.cpp"
#include "../res/vectorized/bounds-go_22.cpp"
#include "../res/vectorized/bounds-stop_22.cpp"
#include "../res/vectorized/format-hide-punctuation_22.cpp"
#include "../res/vectorized/format-show-punctuation_22.cpp"
#include "../res/vectorized/go-first_22.cpp"
#include "../res/vectorized/go-last_22.cpp"
#include "../res/vectorized/go-to_22.cpp" // whm 25Oct2022 changed go-previous_22.cpp to go-to_22.cpp
#include "../res/vectorized/go-up_22.cpp"
#include "../res/vectorized/go-down_22.cpp"
#include "../res/vectorized/phrase-new_22.cpp"
#include "../res/vectorized/phrase-remove_22.cpp"
#include "../res/vectorized/retranslation-new_22.cpp"
#include "../res/vectorized/retranslation-edit_22.cpp"
#include "../res/vectorized/retranslation-delete_22.cpp"
#include "../res/vectorized/insplaceholder_left_22.cpp" // whm 20Mar2020 changed placeholder_new_22.cpp to insplaceholder_left_22.cpp
#include "../res/vectorized/insplaceholder_right_22.cpp" // whm 20Mar2020 added insplaceholder_right_22.cpp for better directional control
#include "../res/vectorized/placeholder-delete_22.cpp"
#include "../res/vectorized/dialog-choose-translation_22.cpp"
#include "../res/vectorized/show-target_22.cpp"
#include "../res/vectorized/show-source-target_22.cpp"
#include "../res/vectorized/dialog-view-translation-or-glosses_22.cpp"
#include "../res/vectorized/punctuation-copy_22.cpp"
#include "../res/vectorized/punctuation-do-not-copy_22.cpp"
#include "../res/vectorized/help-browser_22.cpp"
#include "../res/vectorized/document-new_32.cpp"
#include "../res/vectorized/document-open_32.cpp"
#include "../res/vectorized/document-save_32.cpp"
#include "../res/vectorized/edit-cut_32.cpp"
#include "../res/vectorized/edit-copy_32.cpp"
#include "../res/vectorized/edit-paste_32.cpp"
#include "../res/vectorized/document-print_32.cpp"
#include "../res/vectorized/dialog-guesser_32.cpp"
#include "../res/vectorized/dialog-notes_32.cpp"
#include "../res/vectorized/note-next_32.cpp"
#include "../res/vectorized/note-prev_32.cpp"
#include "../res/vectorized/note-delete-all_32.cpp"
#include "../res/vectorized/bounds-go_32.cpp"
#include "../res/vectorized/bounds-stop_32.cpp"
#include "../res/vectorized/format-hide-punctuation_32.cpp"
#include "../res/vectorized/format-show-punctuation_32.cpp"
#include "../res/vectorized/go-first_32.cpp"
#include "../res/vectorized/go-last_32.cpp"
#include "../res/vectorized/go-to_32.cpp" // whm 25Oct2022 changed go-previous_32.cpp to go-to_32.cpp
#include "../res/vectorized/go-up_32.cpp"
#include "../res/vectorized/go-down_32.cpp"
#include "../res/vectorized/phrase-new_32.cpp"
#include "../res/vectorized/phrase-remove_32.cpp"
#include "../res/vectorized/retranslation-new_32.cpp"
#include "../res/vectorized/retranslation-edit_32.cpp"
#include "../res/vectorized/retranslation-delete_32.cpp"
#include "../res/vectorized/insplaceholder_left_32.cpp" // whm 20Mar2020 changed placeholder_new_32.cpp to insplaceholder_left_32.cpp
#include "../res/vectorized/insplaceholder_right_32.cpp" // whm 20Mar2020 added insplaceholder_right_32.cpp for better directional control
#include "../res/vectorized/placeholder-delete_32.cpp"
#include "../res/vectorized/dialog-choose-translation_32.cpp"
#include "../res/vectorized/show-target_32.cpp"
#include "../res/vectorized/show-source-target_32.cpp"
#include "../res/vectorized/dialog-view-translation-or-glosses_32.cpp"
#include "../res/vectorized/punctuation-copy_32.cpp"
#include "../res/vectorized/punctuation-do-not-copy_32.cpp"
#include "../res/vectorized/help-browser_32.cpp"

// Added for win32 API calls required to determine if Paratext is running on a windows host - KLB
#ifdef __WXMSW__
#define WIN32_LEAN_AND_MEAN
// BEW added the above #define on 21Nov15, because it prevents WinSock.h being #included withint windows.h
// which is what we need, since our service discovery module needs to use WinSock2.h; and if WinSock.h
// is present we get 118 compile conflicts, mostly redefinitions and conflicting definitions etc. Hmmm,
// I did this, but I still got the 118 compile errors, so there must be somewhere else that needs this protection
//#include <windows.h>
#include <tlhelp32.h>
#include <tchar.h>
#endif

// whm 13Jul2018 the following values are the IDs for the wxTextCtrl, button, and dropdown list
// of our new 3-part phrasebox.
int ID_PHRASE_BOX = 22030;
int ID_BMTOGGLEBUTTON_PHRASEBOX = 22040;
int ID_DROP_DOWN_LIST = 22050;


// The following include was originally Copyright (c) 2005 by Dan
// Moulding, but the features of version 2.0 were implemented by
// Arkadiy Shapkin. It is used under the GNU General Public License
// version 2 (GPLv2).
//
// Note: The Visual Leak Detector (vld) and how it works are found at:
// http://vld.codeplex.com/
//
// Note: Vld's code is not compiled into the program in release
// versions, and vld.h need only be included when memory leaks are
// detected by the debugger's Output report and it is not obvious what
// is the cause of the leak from the report. Vld will pinpoint
//
// How to make this work with VC 11.0:
// 1. Download and install VLD. The installer will prompt about adding
// its bin path (C:\...\Visual Leak Detector\bin) to the PATH
// environment variable. Accept it or add it manually yourself. Either
// way, you will need to log out and log back in for the addition to
// the PATH to take effect. vld.dll and dbghelp.dll, from the bin
// directory need to be available on the system path.
//
// 2. Make sure the Visual C++ project is in Unicode Debug mode.
//
// 3. Add the VLD include paths ($(ProgramFiles)\Visual Leak
// Detector\include) to the C++ compiler's "Additional Include
// Directories" and ($(ProgramFiles)\Visual Leak
// Detector\lib\win32) to the Linker's "Additional Library
// Directories" of the project. The use of the $(ProgramFiles) macro
// will ensure that the "Program Files (x86)" directory is referenced
// on 64-bit Windows and the "Program Files" directory is referenced
// on 32-bit Windows systems. This makes the Visual Studio's project
// file work on either 64-bit or 32-bit Windows OS.
//
// 4. Uncomment the #include "vld.h" line below. This header will
// bring in vld.lib during the linking stage.
//
// 5. Rebuild the project and execute the compiled program in Debug
// mode. On program exit, VLD will print out the memory leak
// information it detected in the Output window.
//
// 6. After debugging, comment out the #include "vld.h" line since
// debugging with vld active slows down debugging in the IDE somewhat.
//
// If Visual Studio reports "memory leaks detected" and the source of
// leak is unclear, uncomment the following include, recompile, run and
// exit the program for a more detailed report of the memory leaks:
#ifdef __WXMSW__
#ifdef _DEBUG
//#include "vld.h"
#endif
#endif

// Other includes
#include "Adapt_It_Resources.h"
#include "AIPrintout.h"
#include "ReadOnlyProtection.h"
#include "Adapt_It.h"
#include "MainFrm.h"
#include "Adapt_ItDoc.h"
#include "Adapt_ItView.h"
#include "AdaptitConstants.h"
#include "KB.h"
#include "helpers.h"
#include "CollabUtilities.h"
#include "ChooseCollabOptionsDlg.h"
#include "FontPage.h"
#include "PhraseBox.h"
#include "LanguagesPage.h"
#include "UsfmFilterPage.h"
#include "PunctCorrespPage.h"
#include "CaseEquivPage.h"
#include "OpenExistingProjectDlg.h"
#include "ProjectPage.h"
#include "DocPage.h"
#include "StatusBar.h"
#include "WaitDlg.h"
#include "GuesserAffixesListsDlg.h" //klb 9/2014
#include "InstallGitOptionsDlg.h" // whm 26March2017
#include "Authenticate2Dlg.h" // BEW 9Sep20
#include "NewUserCredentialsDlg.h" // BEW 3Jan22

#if wxCHECK_VERSION(2,9,0)
// Use the built-in scrolling wizard features available in wxWidgets  2.9.x
#else
// The wxWidgets library being used is pre-2.9.x, so use our own modified
// version named wxScrollingWizard located in scrollingwizard.h
#include "scrollingwizard.h" // whm added 13Nov11 - needs to be included before "StartWorkingWizard.h" below
#endif

#include "StartWorkingWizard.h"
#include "TargetUnit.h"
#include "RefString.h"
#include "CCTabbedDialog.h"
#include "WhichFilesDlg.h" // renamed from original "RestoreKBDlg.h"
#include "SourcePhrase.h"
#include "Strip.h"
#include "Pile.h"
#include "TransformToGlossesDlg.h"
#include "EarlierTranslationDlg.h"
#include "Cell.h"
#include "WhichBook.h"
#include "BString.h"
#include "XML.h"
#include "NoteDlg.h"
#include "ViewFilteredMaterialDlg.h"
#include "WaitDlg.h"
#include "ConsistentChanger.h"
#include "ChooseLanguageDlg.h"
#include "Layout.h"
#include "AdminMoveOrCopy.h"
#include "FreeTrans.h"
#include "Notes.h"
#include "Retranslation.h"
#include "Placeholder.h"
#include "ExportFunctions.h"
//#include "Uuid_AI.h" // for testing, then comment out
#include "NavProtectNewDoc.h"
#include "AdminEditMenuProfile.h"
// BEW removed 15Jun11 until we support OXES
// BEW reinstated 19May12, for OXES v1 support
//#include "Oxes.h" // deprecated, remove later
#include "Xhtml.h" // BEW 9Jun12
#include "CorGuess.h"
#include "SetupEditorCollaboration.h"
#include "GetSourceTextFromEditor.h"
#include "CollabProtectEditorBulkSettingsDlg.h"
#include "AssignLocationsForInputsAndOutputs.h"
#include "HtmlFileViewer.h"
#include "DVCS.h"
#include "UsernameInput.h" // BEW added 28May13
#include "ChooseTranslation.h" // whm added 10Jan2018

//#include "md5.h"
#include "md5_SB.h"

//#if defined (_KBSERVER)

#include "KbServer.h"
//#include "KBSharingSetupDlg.h"
#include "KBSharingAuthenticationDlg.h"
#include "Timer_KbServerChangedSince.h"
#include "KBSharingMgrTabbedDlg.h"
#include "ServDisc_KBserversDlg.h" // BEW 12Jan16
#include "KbSvrHowGetUrl.h"
extern std::string str_CURLbuffer;
extern std::string str_CURLheaders;

//#endif // _KBSERVER

// whm 4Jul2021 commented out all curl code reference
// whm added 8Oct12
//#include <curl/curl.h>

#if wxCHECK_VERSION(2,9,1)
// Use the built-in wxConvAuto from <wx/version.h>
#include <wx/version.h>
#else
// The wxWidgets library being used is pre-2.9.1, so use our own modified
// version named wxConvAuto_AI located in convauto.h
#include "convauto.h"
#endif

#include "KBExportImportOptionsDlg.h"
#include "ClientServerConnection.h"

// wx docs say: "By default, the DDE implementation is used under Windows. DDE works within one computer only.
// If you want to use IPC between different workstations you should define wxUSE_DDE_FOR_IPC as 0 before
// including this header [<wx/ipc.h>]-- this will force using TCP/IP implementation even under Windows."
#ifdef useTCPbasedIPC
#define wxUSE_DDE_FOR_IPC 0
#endif
#include <wx/ipc.h> // for wxServer, wxClient and wxConnection

// Added for win32 API calls required to determine if Paratext is running on a windows host - KLB
#ifdef __WXMSW__
// Each of the next 2 lines is supposed to effect excluding winsock.h from <windows.h>,
// but they don't work - perhaps <windows.h> is being compiled with it in wxWidgets.
// winsock.h and winsock2.h are incompatible, and service discovery in Windows needs
// the lattter
#define WIN32_LEAN_AND_MEAN
#define _WINSOCKAPI_
#include <windows.h>
#include <tlhelp32.h>
#include <tchar.h>

// BEW 20Oct21 added, for helping refactor DoDiscoverKBservers()
// comment out when the old code is to be ignored, after refactoring
//#define _DO_DISCOVER
#endif

#include <stdio.h>
#include <stdlib.h>

#if !wxUSE_WXHTML_HELP
#error "This program can't be built without wxUSE_WXHTML_HELP set to 1"
#endif // wxUSE_WXHTML_HELP

// BEW added to on 18Jul09, the final set of booleans for support of printing
extern bool gbIsBeingPreviewed;
extern bool gbSuppressPrecedingHeadingInRange;
extern bool gbIncludeFollowingHeadingInRange;
extern int	gnFromChapter;
extern int	gnFromVerse;
extern int	gnToChapter;
extern int	gnToVerse;

/// This global is defined in CAdapt_ItView
extern bool	gbCheckInclFreeTransText;

/// This global is defined in CAdapt_ItView
extern bool gbFind;

/// This global is defined in TransferMarkersDlg.cpp.
extern bool gbPropagationNeeded;

/// This global is defined in TransferMarkersDlg.cpp.
extern TextType gPropagationType;

/// This global is defined in FontPage.cpp
extern bool gbLTRLayout;

/// This global is defined in FontPage.cpp
extern bool gbRTLLayout;

/// BEW added 23May05, for support of returning to the previous context's TextType value
/// after an inline section with TextType none, or after a footnote (since the latter can
/// be embedded inline within verse, poetry, headings, subtitles, section headings, etc).
TextType gPreviousTextType; // moved here to global space in the Doc

/// A compatibility struct for the source language font, which is only used to hold the
/// Logfont info used by MFC and which is stored within Adapt It's config files. Many of
/// the values stored in the fontInfo structs are not used by the wxWidgets version, but
/// are read and written back out to the config files to maintain backward compatibility.
fontInfo SrcFInfo;

/// A compatibility struct for the target language font, which is only used to hold the
/// Logfont info used by MFC and which is stored within Adapt It's config files. Many of
/// the values stored in the fontInfo structs are not used by the wxWidgets version, but
/// are read and written back out to the config files to maintain backward compatibility.
fontInfo TgtFInfo;

/// A compatibility struct for the navigation language font, which is only used to hold the
/// Logfont info used by MFC and which is stored within Adapt It's config files. Many of
/// the values stored in the fontInfo structs are not used by the wxWidgets version, but
/// are read and written back out to the config files to maintain backward compatibility.
fontInfo NavFInfo;

/// A global instance of PageOffsets. Used for saving top and bottom logical coord offsets
/// for printing pages, stored in m_pagesList. The pgOffsets are populated in the
/// PaginateDoc() function in the CAdapt_ItView and AIPrintout classes.
PageOffsets pgOffsets;

// wxList definitions
#include <wx/listimpl.cpp>

/// This macro together with the macro list declaration in the .h file
/// complete the definition of a new safe pointer list class called POList.
WX_DEFINE_LIST(POList);

/// This macro together with the macro list declaration in the .h file
/// complete the definition of a new safe pointer list class called CCellList.
WX_DEFINE_LIST(CCellList);

/// This macro together with the macro list declaration in the .h file
/// complete the definition of a new safe pointer list class called KPlusCList.
WX_DEFINE_LIST(KPlusCList);

/// This macro together with the macro list declaration in the .h file
/// complete the definition of a new safe pointer list class called ProfileItemList.
WX_DEFINE_LIST(ProfileItemList);

/// This macro together with the macro list declaration in the .h file
/// complete the definition of a new safe pointer list class called SubMenuItemList.
WX_DEFINE_LIST(SubMenuItemList);


/// This macro together with the macro list declaration in the .h file
/// complete the definition of a new safe pointer list class called MainMenuItemList.
WX_DEFINE_LIST(MainMenuItemList);

/// Length of the byte-order-mark (BOM) which consists of the three bytes 0xEF, 0xBB and
/// 0xBF in UTF-8 encoding.
#define nBOMLen 3

/// Length of the byte-order-mark (BOM) which consists of the two bytes 0xFF and 0xFE in
/// UTF-16 encoding.
#define nU16BOMLen 2

// globals

/// This global is defined in Adapt_ItView.cpp.
extern bool gbVerticalEditInProgress; // defined in Adapt_ItView.cpp
                                      // (for vertical edit functionality)

                                      /// This global is defined in Adapt_ItView.cpp.
extern bool gbAdaptBeforeGloss; // defined in Adapt_ItView.cpp
                                // (for vertical edit functionality)

/// When TRUE gbUpdateDocTitleNeeded causes OnIdle() to update the window title if the open
/// attempt failed, otherwise the failed doc name remains in the window's title bar. Note,
/// since OnOpenRecentFile always returns TRUE, we have to unilaterally cause OnIdle to do
/// the update of the title to ensure we catch the failures.
bool gbUpdateDocTitleNeeded = FALSE; // is set only by a failed MRU document open

/// This global is defined in DocPage.cpp.
extern bool gbReachedDocPage; // BEW added 10Nov05  (see DocPage.cpp, & OnInitDialog())

/// This global is defined in SplitDialog.cpp. (It has nothing to do with window
/// splitting, but is for splitting the document's list of source phrase instances into
/// two or more shorter lists, and hence into two or more shorter documents)
extern bool gbIsDocumentSplittingDialogActive; // see SplitDialog.cpp

/// This global is defined in MainFrm.cpp.
extern bool gbIgnoreScriptureReference_Receive;

/// This global is defined in MainFrm.cpp.
extern SPList* gpDocList;

/// whm 4Feb2020 added.
/// The following bool values below represent what versions of Paratext are installed
/// as determined by the App's IsThisParatextVersionInstalled() function.
/// They are located here in the App's global space because both the App
/// and the App class and the CSetupEditorCollaboration class set them and use
/// their values.
bool gbPTVer7Installed = FALSE;
bool gbPTVer8Installed = FALSE;
bool gbPTVer9Installed = FALSE;
bool gbPTLinuxVer7Installed = FALSE;
bool gbPTLinuxVer8Installed = FALSE;
bool gbPTLinuxVer9Installed = FALSE;

bool gbPTNotInstalled = FALSE;

bool gbPTVer7OnlyInstalled = FALSE;
bool gbPTVer8OnlyInstalled = FALSE;
bool gbPTVer9OnlyInstalled = FALSE;
bool gbPTLinuxVer7OnlyInstalled = FALSE;
bool gbPTLinuxVer8OnlyInstalled = FALSE;
bool gbPTLinuxVer9OnlyInstalled = FALSE;

// The following declarations moved here from the View's global space

///BEW added 11Oct05 to support hiliting the cell under the clicked green wedge, or note
///icon.
CPile* gpGreenWedgePile;

/// BEW added 11Oct05, to allow clicked wedge's topmost cell in the layout to be given
/// background highlighting, so user has visual feedback as to which pile the View Filtered
/// Material dialog pertains to.
CPile* gpNotePile;

/// BEW added 17Sep05, to support adjusting the dialog position according to where the
/// click on the wedge or note icon was (because the phrase box might be a long way away -
/// even off screen). The point is in screen coords, as set at start of OnLButtonDown().
wxPoint gptLastClick;

// BEW added 24Jun05; globals for free translation support

///GDLC removed 2010-02-12 because it is no longer used anywhere
/// BEW added 27Jun05 for free trans support, make sure it is always FALSE when
/// OnLButtonDown() is entered. Default FALSE, TRUE if pile pointer is NULL on
/// GetPrevPile() call.
//bool gbBundleStartIteratingBack;

/// GDLC 2010-02-13 gnOffsetInMarkersStr and gnLengthInMarkersStr moved to CFreeTrans

//GDLC 2010-02-12,16
// The arrays gpCurFreeTransSectionPileArray and gpFreeTransArray were changed to
// member variables of CFreeTrans; as was the pointer gpFirstPile; the pointer
// gpLastPile was deleted because it is no longer used anywhere.

/// The contents of App's m_punctuation[1] string with spaces removed.
wxString gSpacelessTgtPunctuation;

/// Suppress the calling of SetupCurrentFreeTransSection() when the Shorten or Lengthen
/// button has been pressed (otherwise it wipes out the action of the button)
bool gbSuppressSetup;

/// whm added 13Apr07, a flag to ensure that the warning about hacked character data being
/// detected is only issued once - upon first detection of such data in config files and/or
/// data files.
bool gbHackedDataCharWarningGiven = FALSE;

/// BEW added 29Apr06, so that Remove Free Translation button in ViewFilteredMaterial
/// dialog can be used to delete the free translation and its markers, and then a
/// subsequent <Prev, Next> or Advance clicked without that click inserting an empty \free
/// \free* filtered marker pair in the location just left (which had its free translation
/// just removed) - this, of course, only is relevant while Free Trans Mode is turned on.
bool gbFreeTranslationJustRemovedInVFMdialog = FALSE;

/// Save m_bSuppressTargetHighlighting flag's value while the 'Accept Changes Without
/// Stopping' toggle is ON. When the latter is ON, the app's m_bSuppressTargetHighlighting
/// value must be TRUE, otherwise MFC's lazy window updates get out of synch with updates
/// of the pointers on which the layout relies and the app crashes. This does not happen if
/// no highlighting takes place. The original setting for highlighting is restored when the
/// toggle command is turned back off.
bool gbSaveHilightingSetting = FALSE; // *** NOTE *** in version 6 & higher, this protection might not be needed - noone has checked as yet

// The above declarations moved here from the View's global space

/// For support of book folders mode and the option of binary or xml intput/output when
/// doing the Transform Adaptations to Glosses operation - which needs to work whether book
/// mode is currently on or not and whether book folders are present or not, (and for any
/// possible mix of xml or binary kb files and document files; in fact, the same
/// considerations about file type and book folders mode are relevant to any operation
/// involving the enumerated set of documents - so also relevant to restoring the knowledge
/// base from the existing documents and reporting retranslatiszons). TRUE if the current
/// project's Adaptations folder contains Bible book folders (whether or not book mode is
/// currently on) (for XML or binary, a local Boolean will suffice).
bool gbHasBookFolders = FALSE; //

// for support of auto-capatalization

/// whm added 12Aug04 Initial flag for auto-cap support possible. This flag keeps track of
/// initial checkbox on "Define Any Lower To Upper Case Equivalences" Wizard panel/Dialog
/// that reads: [ ]Check here if the source text contains both capital letters (upper case)
/// and small letters (lower case). The remaining controls on the panel do not appear
/// unless this checkbox is checked. This value is now stored in the
/// AI-ProjectConfiguration.aic file.
bool gbSrcHasUcAndLc = FALSE;

/// Switch for turning auto-capitalization support on or off.
bool gbAutoCaps = FALSE;

/// Refers to first character of the source word or phrase; TRUE if the source is upper
/// case, otherwise FALSE.
bool gbSourceIsUpperCase = FALSE;

/// Refers to first character of the contents of the phrase box, which may contain a gloss
/// or an adaptation depending on the value of gbIsGlossing.
bool gbNonSourceIsUpperCase = FALSE;

/// if the source has an initial UC character and the first KB lookup fails, then a KB
/// lookup is done with UC first character, and if found this flag is set TRUE.
bool gbMatchedKB_UCentry = FALSE;

/// Set TRUE if source language is caseless, or user does not define any case equivalences.
bool gbNoSourceCaseEquivalents = FALSE;

/// Set TRUE if user does not define any case equivalences for the target language.
bool gbNoTargetCaseEquivalents = FALSE;

/// Set TRUE if user does not define any case equivalences for the gloss language.
bool gbNoGlossCaseEquivalents = FALSE;

/// Store first character of adaption or gloss when it is lower case.
wxChar gcharNonSrcLC;

/// Store first character of adaption or gloss when it is upper case.
wxChar gcharNonSrcUC;

/// Store first lwr case char of source text word or phrase (after punct stripped).
wxChar gcharSrcLC;

/// Store first upr case char of source text word or phrase (after punct stripped).
wxChar	gcharSrcUC;

bool   gbUCSrcCapitalAnywhere; // TRUE if searching for captial at non-initial position
                               // is enabled, FALSE is legacy initial position only
int    gnOffsetToUCcharSrc; // offset to source text location where the upper case
                            // character was found to be located, wxNOT_FOUND if not located

/// Use to suppress the message box asking if the src language has upper/lower case
/// distinction, when the flag is being restored to TRUE from reading the project's config
/// file.
bool gbSuppressAutoCapsAsk = FALSE;

/// This global is defined in OpenExistingProjectDlg.cpp.
extern bool gbExcludeCurrentProject;

/// This global is defined in Adapt_ItView.cpp.
extern bool gbGlossingUsesNavFont;

/// This global is defined in Adapt_ItView.cpp.
//extern bool gbRemovePunctuationFromGlosses; << BEW removed 13Nov10, it's nowhere set TRUE

/// This global is defined in Adapt_ItView.cpp.
extern int gnSelectionLine;

/// This global is defined in Adapt_ItView.cpp.
extern int gnSelectionStartSequNum;

/// This global is defined in Adapt_ItView.cpp.
extern int gnSelectionEndSequNum;

/// This global is defined in Adapt_ItView.cpp.
extern bool gbPrintFooter;

/// This global is defined in Adapt_ItView.cpp.
extern bool gbPrintOnlyPgNumInFooter;

// next two are for version 2.0 which includes the option of a 3rd line for glossing

/// This global is defined in Adapt_ItView.cpp.
extern bool	gbIsGlossing; // when TRUE, the phrase box and its line have glossing text

                          /// This global is defined in Adapt_ItView.cpp.
extern bool	gbGlossingVisible; // TRUE makes Adapt It revert to Shoebox functionality only

                               // When FALSE back slash characters found anywhere in a text are interpreted as
                               // introducing standard format markers (the default). When TRUE back slash characters may
                               // be interpreted as word-building characters. When the gbSfmOnlyAfterNewlines flag is
                               // TRUE, any standard format marker escape characters which do not follow a newline are
                               // not assumed to belong to a sfm, and so we treat them in such cases as ordinary
                               // word-building characters (on the assumption we are dealing with a hacked legacy
                               // encoding in which the escape character is an alphabetic glyph in the font)

                               // BEW 8Jun10, removed support for checkbox "Recognise standard format
                               // markers only following newlines"
                               //bool gbSfmOnlyAfterNewlines = FALSE;

                               /// Defined as the backslash character.
                               /// NOTE: Older versions of Adapt It allowed the user to designate the character to be
                               /// used, but in all recent versions, gSFescapechar is always defined as the backslash
                               /// character. For cross-platform considerations, the gSFescapechar is handled totally
                               /// apart from the wxWidgets PathSeparator.
wxChar gSFescapechar = _T('\\'); // standard format escape char, default is backslash

                                 /// TRUE while there is no m_targetBox created, during setup of the view. It is used to
                                 /// prevent premature merges, and at 6May09, also to suppress the interpretation of a null
                                 /// active pile pointer being due to having reached the doc end (because at initial launch
                                 /// we can have a null active pile due to the sequence number starting with value -1)
bool gbDoingInitialSetup = FALSE;

/// A global pointer to the application instance.
CAdapt_ItApp* gpApp;

/// ANSI version is always left to right (LTR) reading; this flag can only be changed in
/// the NRoman version, using the extra Layout menu. When TRUE text is right to left (RTL)
/// layout.
bool gbRTL_Layout = FALSE;

/// For ANSI version, no bloating of the size of the phrase box is needed, but for an
/// unknown reason, the CRichEditCtrl's vertical size is smaller than required for showing
/// all the text; adding in external and internal leadings helps (at expense of making the
/// line height too large, but is not enough because the style is diff. So I'll the sum of
/// the ext & int leadings to the box height, and +4 to allow for the thicker boundary at
/// top and bottom.
int gnVerticalBoxBloat = 0;

/// TRUE if <New Project> selected in the Wizard, otherwise FALSE.
bool gbWizardNewProject = FALSE;

/// Global pointer to the help controller instance.
wxHtmlHelpController* m_pHelpController = (wxHtmlHelpController*)NULL;

/// Global pointer to the help controller instance.
//wxHelpController* m_pHelpController = (wxHelpController*)NULL;

/// Pointer to the Start Working Wizard instance.
CStartWorkingWizard* pStartWorkingWizard = (CStartWorkingWizard*)NULL;

/// Pointer to the ChooseCollabOptionsDlg instance
CChooseCollabOptionsDlg* pChooseCollabOptionsDlg = (CChooseCollabOptionsDlg*)NULL;

/// Pointer to the project page instance
CProjectPage* pProjectPage = (CProjectPage*)NULL;

/// Pointer to the languages page instance
CLanguagesPage* pLanguagesPage = (CLanguagesPage*)NULL;

/// Pointer to the Wizard's font page instance
CFontPageWiz* pFontPageWiz = (CFontPageWiz*)NULL;

/// Pointer to the Wizard's punct correspondence page instance
CPunctCorrespPageWiz* pPunctCorrespPageWiz = (CPunctCorrespPageWiz*)NULL;

/// Pointer to the Wizard's case equivalences page instance
CCaseEquivPageWiz* pCaseEquivPageWiz = (CCaseEquivPageWiz*)NULL;

/// Pointer to the Wizard's usfmFilterPage instance
CUsfmFilterPageWiz*	pUsfmFilterPageWiz = (CUsfmFilterPageWiz*)NULL;

/// Pointer to the doc page instance
CDocPage* pDocPage = (CDocPage*)NULL;

/// Pointer to the Preferences usfmFilterPage instance
CUsfmFilterPagePrefs* pUsfmFilterPageInPrefs = (CUsfmFilterPagePrefs*)NULL;

/// Contains the sequence number for the last auto save operation; -1 if auto save is
/// turned off.
int nSequNumForLastAutoSave;

// Bible books folders support - folder name defaults for when there is no "books.XML" file
// in work folder. NT and OT book name string constants, for GUI - especially setting up a
// folder for every Bible book, and the 67th will be "Other Texts" for all non-scripture
// work.

/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _00BK = _T("Genesis");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _01BK = _T("Exodus");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _02BK = _T("Leviticus");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _03BK = _T("Numbers");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _04BK = _T("Deuteronomy");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _05BK = _T("Joshua");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _06BK = _T("Judges");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _07BK = _T("Ruth");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _08BK = _T("1 Samuel");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _09BK = _T("2 Samuel");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _10BK = _T("1 Kings");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _11BK = _T("2 Kings");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _12BK = _T("1 Chronicles");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _13BK = _T("2 Chronicles");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _14BK = _T("Ezra");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _15BK = _T("Nehemiah");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _16BK = _T("Esther");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _17BK = _T("Job");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _18BK = _T("Psalms");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _19BK = _T("Proverbs");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _20BK = _T("Ecclesiastes");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _21BK = _T("Song of Songs");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _22BK = _T("Isaiah");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _23BK = _T("Jeremiah");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _24BK = _T("Lamentations");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _25BK = _T("Ezekiel");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _26BK = _T("Daniel");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _27BK = _T("Hosea");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _28BK = _T("Joel");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _29BK = _T("Amos");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _30BK = _T("Obadiah");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _31BK = _T("Jonah");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _32BK = _T("Micah");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _33BK = _T("Nahum");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _34BK = _T("Habakkuk");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _35BK = _T("Zephaniah");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _36BK = _T("Haggai");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _37BK = _T("Zechariah");
/// Bible books folders suppo(rt - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _38BK = _T("Malachi");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _39BK = _T("Matthew");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _40BK = _T("Mark");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _41BK = _T("Luke");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _42BK = _T("John");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _43BK = _T("Acts");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _44BK = _T("Romans");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _45BK = _T("1 Corinthians");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _46BK = _T("2 Corinthians");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _47BK = _T("Galatians");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _48BK = _T("Ephesians");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _49BK = _T("Philippians");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _50BK = _T("Colossians");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _51BK = _T("1 Thessalonians");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _52BK = _T("2 Thessalonians");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _53BK = _T("1 Timothy");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _54BK = _T("2 Timothy");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _55BK = _T("Titus");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _56BK = _T("Philemon");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _57BK = _T("Hebrews");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _58BK = _T("James");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _59BK = _T("1 Peter");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _60BK = _T("2 Peter");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _61BK = _T("1 John");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _62BK = _T("2 John");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _63BK = _T("3 John");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _64BK = _T("Jude");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _65BK = _T("Revelation");
/// Bible books folders support - folder name defaults for when there is no "books.XML" file in work folder.
const wxChar* _66BK = _T("Other Texts");

// now the book codes

/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _00BKCODE = _T("GEN");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _01BKCODE = _T("EXO");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _02BKCODE = _T("LEV");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _03BKCODE = _T("NUM");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _04BKCODE = _T("DEU");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _05BKCODE = _T("JOS");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _06BKCODE = _T("JDG");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _07BKCODE = _T("RUT");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _08BKCODE = _T("1SA");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _09BKCODE = _T("2SA");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _10BKCODE = _T("1KI");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _11BKCODE = _T("2KI");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _12BKCODE = _T("1CH");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _13BKCODE = _T("2CH");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _14BKCODE = _T("EZR");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _15BKCODE = _T("NEH");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _16BKCODE = _T("EST");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _17BKCODE = _T("JOB");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _18BKCODE = _T("PSA");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _19BKCODE = _T("PRO");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _20BKCODE = _T("ECC");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _21BKCODE = _T("SNG");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _22BKCODE = _T("ISA");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _23BKCODE = _T("JER");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _24BKCODE = _T("LAM");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _25BKCODE = _T("EZK");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _26BKCODE = _T("DAN");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _27BKCODE = _T("HOS");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _28BKCODE = _T("JOL");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _29BKCODE = _T("AMO");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _30BKCODE = _T("OBA");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _31BKCODE = _T("JON");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _32BKCODE = _T("MIC");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _33BKCODE = _T("NAH");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _34BKCODE = _T("HAB");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _35BKCODE = _T("ZEP");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _36BKCODE = _T("HAG");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _37BKCODE = _T("ZEC");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _38BKCODE = _T("MAL");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _39BKCODE = _T("MAT");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _40BKCODE = _T("MRK");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _41BKCODE = _T("LUK");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _42BKCODE = _T("JHN");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _43BKCODE = _T("ACT");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _44BKCODE = _T("ROM");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _45BKCODE = _T("1CO");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _46BKCODE = _T("2CO");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _47BKCODE = _T("GAL");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _48BKCODE = _T("EPH");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _49BKCODE = _T("PHP");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _50BKCODE = _T("COL");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _51BKCODE = _T("1TH");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _52BKCODE = _T("2TH");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _53BKCODE = _T("1TI");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _54BKCODE = _T("2TI");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _55BKCODE = _T("TIT");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _56BKCODE = _T("PHM");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _57BKCODE = _T("HEB");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _58BKCODE = _T("JAS");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _59BKCODE = _T("1PE");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _60BKCODE = _T("2PE");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _61BKCODE = _T("1JN");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _62BKCODE = _T("2JN");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _63BKCODE = _T("3JN");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _64BKCODE = _T("JUD");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _65BKCODE = _T("REV");
/// Bible books folders support - 3-letter book code defaults for when there is no "books.XML" file in work folder.
const wxChar* _66BKCODE = _T("OTX");

wxString dummyBack = _T("&Finish"); // the wxstd.mo file doesn't seem to have
                                    // this wizard button for localizing, so I add it here
wxString dummyFinish = _T("< &Back"); // the wxstd.mo file doesn't seem to have
                                      // this wizard button for localizing, so I add it here

// support for USFM and SFM Filtering

/// An array of wxStrings which, when parsed by ParseAndFillStruct(), is used as default
/// standard format marker style definitions if, for some reason, the program cannot find
/// the AI_USFM.xml control file.
/// The default data strings can be produced automatically by making the following
/// temporary changes in the code:
/// 1. Temporarily uncomment the #define Output_Default_Style_Strings line at the
/// beginning of XML.h file.
/// 2. Copy the current AI_USFM_full.xml file from the project's xml folder to the "Adapt
/// Unicode It Work" folder (this file which contains the full style information and from which the
/// AI_USFM.xml file for distribution to users is produced via the UsfmXml.cct and
/// UsfmXmlTidy.cct changes operations). While the Output_Default_Strings define is active,
/// running the Adapt It program (Debug) up through the appearance of the Start Working
/// Wizard causes the routines in XML.cpp to read the full AI_USFM_full.xml file (instead
/// of AI_USFM.xml) and produce the temporary AI_USFM_full.txt file which simply contains
/// the Unix-format default strings ready to paste into the code block below.
/// 3. Copy the strings from the AI_USFM_full.txt file and paste them here for
/// recompilation. Note that the last line of the file contains the number of usfm strings
/// which should be equivalent to the calculation of gnDefaultSFMs =
/// sizeof(defaultSFM)/sizeof(wxString) below. Also, Remember to remove the last comma from
/// the last string item once it is pasted into this array initialization list.
/// 4. Comment out the #define Output_Default_Style_Strings line at the beginning of XML.h
/// file so that the application won't continue to produce the temporary AI_USFM_full.txt
/// file in the work folder, but will instead revert back to using the normal (abbreviated)
/// AI_USFM.xml file on program startup.
const wxString defaultSFM[] =
{
    // whm 9Nov2023 revised defaultSFM[] array again to reflect the extended usfm 3.0.9 additions and changes (now with 371 elements)
    // which are defined in the Paratext usfm_sb.sty stylesheet. The extensions in usfm_sb.sty include study Bible marker extensions
    // that are not included in the standard usfm.sty that we've used in the past. All future revisions should be based on the
    // usfm_sb.sty file which includes all of the usfm.sty markers plus the bible study extensions added in this revision.
_T("id::File identification (BOOKID, FILENAME, EDITOR, MODIFICATION DATE)::1:1::::1::1:id:11::id - File - Identification:0:1:65535::::::0::::::__normal:id::1:"),
_T("ide::File encoding information:id:1::1::::1:::0::ide - File - Encoding:0:12:65535::::::0::::::__normal:ide:::"),
_T("h::Running header text for a book (basic):id:1:1::1::1:1:1:hdr:10::h - File - Header:0:9:::::::0::::::_vernacular_base:h:::"),
_T("h1::Running header text:id:1:::1::1:1:1:hdr:10::DEPRECATED h1 - File - Header:0:9:::::::1::::::h:h1:::"),
_T("h2::Running header text, left side of page:id:1:::1::1:1:1:hdr-left:10::DEPRECATED h2 - File - Left Header:0:9:::::::0::::::h1:h2:::"),
_T("h3::Running header text, right side of page:id:1:::1::1:1:1:hdr-rght:10::DEPRECATED h3 - File - Right Header:0:9:::::::2::::::h1:h3:::"),
_T("rem::Comments and remarks:id ide c:1::1:1::1:1:1:comment:34::rem - File - Remark:0:9:16711680::::::0::::::_notes_base:rem:::"),
_T("sts::Status of this file:id ide c:1::1:1::1:1:1:comment:34::rem - File - Status:0:9:16711680::::::0::::::_notes_base:sts:::"),
_T("restore::Project restore information:id:1::1::::1:::34::restore - File - Restore Information:0:12:16711680::::::0::::::__normal:restore:::"),
_T("lit::For a comment or note inserted for liturgical use:c:1::1:1::1:1:1:lit-note:34::lit - Special Text - Liturgical note:0:12:::1::::2::::::p:lit:1:1:"),
_T("nt::Note:::1:1:1::1:1:1:note:34::nt - Note:0:9:16711680::::::0::::::_notes_base:nt:::"),
_T("nc::Note centered:::1:1:1::1:1:1:note:34::nc - Note centered:0:9:16711680::::::1::::::nt:nc:::"),
_T("c::Chapter number (basic):id:1:1:::::1:1::1:1:c - Chapter Number:0:18:::1::::1:8:4::::_heading_base:p:1:1:"),
_T("ca:ca*:Second (alternate) chapter number (for coding dual versification; useful for places where different traditions of chapter breaks need to be supported in the same translation):c:1:::1:::1:::1::ca...ca* - Chapter Number - Alternate:1:16:2263842:1:::::0::::::::::"),
_T("cl::Chapter label used for translations that add a word such as 'Chapter' before chapter numbers (e.g. Psalms). The subsequent text is the chapter label.:id c ms ms1 ms2 ms3 mr:1:::1:::1:::1::cl - Chapter - Publishing Label:0:18:::1::::1:8:4::::_heading_base:p:1:1:"),
_T("cp::Published chapter number (chapter string that should appear in the published text):c:1:::1:::1:::1::cp - Chapter Number - Publishing Alternate:0:18:16711680::1::::1:8:4::::_heading_base:p:1:1:"),
_T("cd::Chapter Description (Publishing option D, e.g. in Russian Bibles):c:1:::1:::1:1:chapter descr:1::cd - Chapter - Description:0:11:::::::0:8:4::::_heading_base:p:1:1:"),
_T("v::A verse number (basic):lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 tr tc1 tc2 tc3 tc4 tcr1 tcr2 tcr3 tcr4 s3 d sp:1:1:::::1:1::1::v - Verse Number:1:10:16711935::1:::1:0::::::::::"),
_T("vt::Verse text::1:1:::::1:1::1::vt - Verse text vt:1:12::::::1:0::::::::::"),
_T("vn::Verse number::1:1:::::1:1::1::vn - Verse number vn:1:10:16711935::1:::1:0::::::::::"),
_T("va:va*:Second (alternate) verse number (for coding dual numeration in Psalms; see also NRSV Exo 22.1-4):lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 tr tc1 tc2 tc3 tc4 tcr1 tcr2 tcr3 tcr4 s3 d sp:1:::1:1:::::1::va...va* - Verse Number - Alternate:1:10:2263842::1:::1:0::::::::::"),
_T("vp:vp*:Published verse marker (verse string that should appear in the published text):cd lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 tr tc1 tc2 tc3 tc4 tcr1 tcr2 tcr3 tcr4 s3 d sp:1:::1:1:::::1::vp...vp* - Verse Number - Publishing Alternate:1:10:16711680::1:::1:0::::::::::"),
_T("mt::The main title of the book (if single level):id:1:1::1::1:1:1:main title:4:1:mt - Title - Major Title Level 1:0:20:::1::::1:8:4::::_heading_base:c:1:1:"),
_T("mt1::The main title of the book (if multiple levels) (basic):id:1:::1::1:1:1:main title L1:4:1:mt1 - Title - Major Title Level 1:0:20:::1::::1:2:4::::_heading_base:c:1:1:"),
_T("mt2::A secondary title usually occurring before the main title (basic):id:1:::1::1:1:1:secondary title L2:5:1:mt2 - Title - Major Title Level 2:0:16::1:::::1::2::::_heading_base:mt:1:1:"),
_T("mt3::A secondary title occurring after the main title:id:1:::1::1:1:1:secondary title L3:5:1:mt3 - Title - Major Title Level 3:0:14:::1::::1:2:2::::_heading_base:c:1:1:"),
_T("mt4::A small secondary title sometimes occuring within parentheses:id:1:::1::1:1:1:secondary title L4:5:1:mt4 - Title - Major Title level 4:0:12:::::::1:2:2::::_heading_base:c:1:1:"),
_T("st::Secondary title:::1::1::1:1:1:secondary title:5:1:st - Secondary title:0:16:::1::::1::2::::_heading_base:mt:1:1:"),
_T("mte::The main title of the book repeated at the end of the book (if single level):c:1:::1::1:1:1:main title at end:4:1:mte - Title - [Uncommon] Major Title Ending Level 1:0:20:::1::::1:8:4::::_heading_base::1::"),
_T("mte1::The main title of the book repeated at the end of the book (if multiple levels):lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 tc1 tc2 tc3 tc4 s3 d:1:::1::1:1:1:main title at end L1:4:1:mte1 - Title - [Uncommon] Major Title Ending Level 1:0:20:::1::::1:8:4::::_heading_base::1::"),
_T("mte2::A secondary title occurring before or after the 'ending' main title:mte1:1:::1::1:1:1:secondary title at end L2:5:1:mte2 - Title - [Uncommon] Major Title Ending Level 2:0:16::1:::::1::2::::_heading_base::1::"),
_T("div::Division heading:::1::1::1:1:1:division head:3:1:div - Division heading:0:16:::1::::1:6:3::::s:dvrf:1:1:"),
_T("bn::Psalms book number:::1::1::1:1:1:Psalm book number:0:1:bn - Psalms book number:0:11:::1::::1:6:3::::s:br:1:1:"),
_T("ms::A major section division heading, level 1 (if single level) (basic):c esb:1:::1::1:1:1:major sect head:3:1:ms - Heading - Major Section Level 1:0:14:::1::::1:16:4::::_heading_base:mr:1:1:"),
_T("mse::A major section division ending heading, level 1 (if single level):c:1:::1::1:1:1:major sect ending:3:1:mse - Heading - Major Section Ending Level 1:0:14:::1::::1:16:4::::_heading_base:mr:1:1:"),
_T("ms1::A major section division heading, level 1 (if multiple levels):c:1:::1::1:1:1:major sect head L1:3:1:ms1 - Heading - Major Section Level 1:0:14:::1::::1:16:4::::_heading_base:mr:1:1:"),
_T("ms2::A major section division heading, level 2:c:1:::1::1:1:1:major sect head L2:3:1:ms2 - Heading - Major Section Level 2:0:14:::1::::1:16:4::::_heading_base:mr:1:1:"),
_T("ms2e::A major section division ending heading, level 2:c:1:::1::1:1:1:major sect ending L2:3:1:ms2e - Heading - Major Section Ending Level 2:0:14:::1::::1:16:4::::_heading_base:mr:1:1:"),
_T("ms3::A major section division heading, level 3:c:1:::1::1:1:1:major sect head L3:3:1:ms3 - Heading - Major Section Level 3:0:14::1:::::1:16:4::::_heading_base:mr:1:1:"),
_T("ms3e::A major section division ending heading, level 3:c:1:::1::1:1:1:major sect ending L3:3:1:ms3e - Heading - Major Section Ending Level 3:0:14::1:::::1:16:4::::_heading_base:mr:1:1:"),
_T("s::A section heading, level 1 (if single level) (basic):c:1:1::1::1:1:1:sect head:3:1:s - Heading - Section Level 1:0:12:::1::::1:8:4::::_heading_base:p:1:1:"),
_T("s1::A section heading, level 1 (if multiple levels):c:1:::1::1:1:1:sect head L1:3:1:s1 - Heading - Section Level 1:0:12:::1::::1:8:4::::_heading_base:p:1:1:"),
_T("s1e::A section ending heading, level 1 (if multiple levels):c:1:::1::1:1:1:sect head ending L1:3:1:s1e - Heading - Section Ending Level 1:0:12:::1::::1:8:4::::_heading_base:p:1:1:"),
_T("s2::A section heading, level 2 (e.g. Proverbs 22-24):c:1:::1::1:1:1:sect head L2:3:1:s2 - Heading - Section Level 2:0:12::1:::::1:8:4::::_heading_base:p:1:1:"),
_T("s2e::A section ending heading, level 2:c:1:::1::1:1:1:sect head ending L2:3:1:s2e - Heading - Section Ending Level 2:0:12::1:::::1:8:4::::_heading_base:p:1:1:"),
_T("s3::A section heading, level 3 (e.g. Genesis 'The First Day'):c:1:::1::1:1:1:sect head L3:3:1:s3 - Heading - Section Level 3:0:12::1:::::0:6:3::::_heading_base:p:1:1:"),
_T("s3e::A section ending heading, level 3:c:1:::1::1:1:1:sect head ending L3:3:1:s3e - Heading - Section Ending Level 3:0:12::1:::::??:6:3::::_heading_base:p:1:1:"),
_T("s4::A section heading, level 4:c:1:::1::1:1:1:sect head L4:3:1:s4 - Heading - Section Level 4:0:12::1:::::0:6:3::::_heading_base:p:1:1:"),
_T("s4e::A section ending heading, level 4:c:1:::1::1:1:1:sect head ending L4:3:1:s4e - Heading - Section Ending Level 4:0:12::1:::::0:6:3::::_heading_base:p:1:1:"),
_T("sr::A section division references range heading:s s1 s2 s3 s4:1:::1::1:1:1:sect head range refs:3:1:sr - Heading - Section Range References:0:12:::1::::1::4::::_heading_base:p:1:1:"),
_T("sx::Extra heading 1:::1::1::1:1:1:sect head extra 1:3:1:sx - Extra heading 1:0:12:::1::::1:6:3::::_heading_base:p:1:1:"),
_T("sz::Extra heading 2:::1::1::1:1:1:sect head extra 2:3:1:sz - Extra heading 2:0:12::1:::::1:6:3::::_heading_base:p:1:1:"),
_T("sp::A heading, to identify the speaker (e.g. Job):c:1:1::1::1:1:1:speaker:0:1:sp - Label - Speaker:0:12::1:::::0:8:4::::_heading_base:q:1:1:"),
_T("d::A Hebrew text heading, to provide description (e.g. Psalms):c:1:::::1:1:1:descr title:1:1:d - Label - Descriptive Title - Hebrew Subtitle:0:12::1:::::1:4:4::::_heading_base:q:1:1:"),
_T("sd::Vertical space used to divide the text into sections, level 1 (if single level):c:1::1:::1:1:::6:1:sd - Label - Semantic Division Location - Level 1:0:12:::::::1:24:24::::_heading_base:sd:1::"),
_T("sd1::Vertical space used to divide the text into sections, level 1 (if single level):c:1::1:::1:1:::6:1:sd1 - Label - Semantic Division Location - Level 1:0:12:::::::1:24:24::::_heading_base:sd1:1::"),
_T("sd2::Vertical space used to divide the text into sections, level 2:c:1::1:::1:1:::6:1:sd2 - Label - Semantic Division Location - Level 2:0:12:::::::1:18:18::::_heading_base:sd2:1::"),
_T("sd3::Vertical space used to divide the text into sections, level 3:c:1::1:::1:1:::6:1:sd2 - Label - Semantic Division Location - Level 3:0:12:::::::1:12:12::::_heading_base:sd3:1::"),
_T("sd4::Vertical space used to divide the text into sections, level 4:c:1::1:::1:1:::6:1:sd2 - Label - Semantic Division Location - Level 4:0:12:::::::1:8:8::::_heading_base:sd4:1::"),
_T("di::Descriptive title (Hebrew subtitle):::1::::1:1:1:descr title:1:1:di - Descr title or Heb subtitle di:0:12::1:::::1:4:4::::_heading_base:q:1:1:"),
_T("hl::Hebrew letter:::1:::::1:::0::hl - Hebrew letter:0:12:::::::1:4:4::::_heading_base:q:1:1:"),
_T("r::Parallel reference(s) (basic):c s s1 s2 s3 s4:1:1:1:1::1:1:1:ref:33::r - Heading - Parallel References:0:12::1:::::1::4::::_heading_base:p:1:1:"),
_T("dvrf::Division reference:::1:1:1::1::1:div-ref:0::dvrf - Division ref:0:12::1:::::1::3::::_heading_base:p:1:1:"),
_T("mr::A major section division references range heading (basic):ms ms1 ms2 ms3:1::1:1::1::1:mjr-sect-refs:0::mr - Heading - Major Section Range References:0:12::1:::::1::4::::ms:p:1:1:"),
_T("br::Psalms book reference:::1:1:1::1::1:Ps-bk-ref:0::br - Psalms book ref:0:12::1:::::1::4::::r:c:1:1:"),
_T("x:x*:A list of cross references (basic):lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 qs sp tc1 tc2 tc3 tc4 mt mt1 mt2 mt3 ms ms1 ms2 s s1 s2 s3 d:1::1:1:1:1:1:1:x-refs:33::x...x* - Cross Reference:4:10:::::::0::::::_notes_base:x:::"),
_T("xo:xo*:The cross reference origin reference (basic):x ex:1::1::1:1::1:origin-ref:33::xo - Cross Reference - Origin Reference:1:10:::1::::0::::::::::"),
_T("xop:xop*:Published cross reference origin reference (origin reference that should appear in the published text):x:1::1::1:1::1:origin-ref:33::xop - Cross Reference - Origin Reference Publishing Alternate:1:10:::::::0::::::::::"),
_T("xt:xt*:The cross reference target reference(s), protocanon only (basic):ip im ipi imi ipq imq ipr iq iq1 iq2 iq3 io io1 io2 io3 io4 ms ms1 ms2 s s1 s2 s3 s4 cd sp d lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 tr th1 th2 th3 th4 thr1 thr2 thr3 thr4 tc1 tc2 tc3 tc4 tcr1 tcr2 tcr3 tcr4 f fe x ef efe ex NEST:1::1:1:1:1::1:tgt-ref:33::xt - Cross Reference - Target References:1:10:::::::0::::::::::"),
_T("xta:xta*:Cross reference target references added text:x:1::1::1:1::1:tgt-ref:33::xta - Cross Reference - Target References Added Text:1:10:::::::0::::::::::"),
_T("xk:xk*:A cross reference keyword:x ex:1::1::1:1::1:keyword:33::xk - Cross Reference - Keyword:1:10::1:::::0::::::::::"),
_T("xq:xq*:A cross-reference quotation from the scripture text:x ex:1::1::1:1::1:quote:33::xq - Cross Reference - Quotation:1:10::1:::::0::::::::::"),
_T("xot:xot*:Cross-reference target reference(s), Old Testament only:x ex:1::1::1:1::1:OldT-ref:33::xot...xot* - Cross Reference - OT Target Refs (optional):1:12:::::::0::::::::::"),
_T("xnt:xnt*:Cross-reference target reference(s), New Testament only:x ex:1::1::1:1::1:NewT-ref:33::xnt...xnt* - Cross Reference - NT Target Refs (optional):1:12:::::::0::::::::::"),
_T("xdc:xdc*:Cross-reference target reference(s), Deuterocanon only:x ex:1::1::1:1::1:deut-canon-ref:33::DEPRECATED xdc...xdc* - Cross Reference - DC Target Refs:1:10:::::::0::::::::::"),
_T("rr::Right margin reference:::1:1:1::1::1:rt-marg-ref:32::rr - Right margin ref:0:9::1:::::2::::::qr:rr:::"),
_T("rq:rq*:A cross-reference indicating the source text for the preceding quotation:lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 NEST:1::1:1::1::1:x-ref to source:32::rq...rq* - Cross Reference - Inline Quotation References:1:10::1:::::2::::::::::"),
_T("@::Cross reference, origin reference:::1:1:1::1::1:x-refs orig:33::@ - Cross ref origin ref:1:10:::1::::0::::::::::"),
_T("xr::Cross reference target references:::1:1:1::1::1:x-refs tgt:33::xr - Cross ref target ref:1:10:::::::0::::::::::"),
_T("p::Paragraph text, with first line indent (basic):c esb ms ms1 ms2 s s1 s2 s3 s4 ip:1:1:::::1:1:paragraph:1:1:p - Paragraph - Normal - First Line Indent:0:12:::::::0:::::.125:_body_text:p:::"),
_T("pi::Paragraph text, level 1 indent (if sinlge level), with first line indent; often used for discourse (basic):c esb ms ms1 ms2 s s1 s2 s3 s4 ip:1:1:::::1:1:para indented:1:1:pi - Paragraph - Indented - Level 1 - First Line Indent:0:12:::::::0:::.25:.25:.125:p:pi:::"),
_T("pi1::Paragraph text, level 1 indent (if multiple levels), with first line indent; often used for discourse:c esb ms ms1 ms2 s s1 s2 s3 s4 ip:1::::::1:1:para indented L1:1:1:pi1 - Paragraph - Indented - Level 1 - First Line Indent:0:12:::::::0:::.25:.25:.125:pi:pi1:::"),
_T("pi2::Paragraph text, level 2 indent, with first line indent; often used for discourse:c esb ms ms1 ms2 s s1 s2 s3 s4 ip:1::::::1:1:para indented L2:1:1:pi2 - Paragraph - Indented - Level 2 - First Line Indent:0:12:::::::0:::.5:.25:.125:pi1:pi2:::"),
_T("pi3::Paragraph text, level 3 indent, with first line indent; often used for discourse:c esb ms ms1 ms2 s s1 s2 s3 s4 ip:1::::::1:1:para indented L3:1:1:pi3 - Paragraph - Indented - Level 3 - First Line Indent:0:12:::::::0:::.75:.25:.125:pi2:pi3:::"),
_T("pgi::Indented paragraph:::1:::::1:1:para indented:1:1:pgi - Indented paragraph:0:12:::::::0:::.25:.25:.125:p:pgi:::"),
_T("ph::Paragraph text, with level 1 hanging indent (if single level):c:1::::::1:1:para hang indent:1:1:DEPRECATED ph - Paragraph - Hanging Indent - Level 1:0:12:::::::0:::.5::-.25:_body_text:ph:::"),
_T("ph1::Paragraph text, with level 1 hanging indent (if multiple levels):c:1::::::1:1:para hang indent L1:1:1:DEPRECATED ph1 - Paragraph - Hanging Indent - Level 1:0:12:::::::0:::.5::-.25:ph:ph1:::"),
_T("ph2::Paragraph text, with level 2 hanging indent:c:1::::::1:1:para hang indent L2:1:1:DEPRECATED ph2 - Paragraph - Hanging Indent - Level 2:0:12:::::::0:::.75::-.25:ph1:ph2:::"),
_T("ph3::Paragraph text, with level 3 hanging indent:c:1::::::1:1:para hang indent L3:1:1:DEPRECATED ph3 - Paragraph - Hanging Indent - Level 3:0:12:::::::0:::1::-.25:ph2:ph3:::"),
_T("phi::Paragraph text, indented with hanging indent:c:1::::::1:1:para indent hang indent:1:1:DEPRECATED phi - Paragraph - Indented - Hanging Indent:0:12:::::::0:::1:::_body_text:phi:::"),
_T("m::Paragraph text, with no first line indent (may occur after poetry) (basic):c esb ms ms1 ms2 s s1 s2 s3 s4 ip:1:1:::::1:1:paragraph margin:1:1:m - Paragraph - Margin - No First Line Indent:0:12:::::::0::::::p:m:::"),
_T("po::Letter opening:c:1:1:::::1:1:paragraph:1:1:po - Paragraph - Letter Opening:0:12:::::::0:4:4:::.125:_body_text:po:::"),
_T("pr::Text refrain (paragraph text, right aligned):c:1:1:::::1:1:paragraph:1:1:pr - Paragraph - Text Refrain (right aligned):0:12:::::::2:::::.125:_body_text:pr:::"),
_T("pmo::Embedded text opening:m mi nb p pc ph phi pi pi1 pi2 pi3 pr q q1 q2 q3 q4 qc qr b s1 s2 s3 s4:1::::::1:1:para embedded text opening:1:1:pmo - Paragraph - Embedded Text Opening:0:12:::::::0:::.25:.25::pm:pm:::"),
_T("mi::Paragraph text, indented, with no first line indent; often used for discourse:c esb ms ms1 ms2 s s1 s2 s3 s4 ip:1:1:::::1:1:para indent no 1st line indent:1:1:mi - Paragraph - Indented - No First Line Indent:0:12:::::::0:::.25:.25::pi:mi:::"),
_T("pc::Paragraph spanning chapters:::1:::::1:1:para spans chapters:1:1:pc - Paragraph spanning chapters:0:12:::::::0::::::m:pc:::"),
_T("pc::Paragraph text, centered (for Inscription):c esb ms ms1 ms2 s s1 s2 s3 s4 ip:1::::::1:1:para centered inscription:1:1:pc - Paragraph - Centered (for Inscription):0:12:::::::1::::::_body_text:pc:::"),
_T("pt::Preface title:::1::1::1:1:1:preface title:0:1:pt - Preface title:0:14:::1::::1::6::::_heading_base:pp:1:1:"),
_T("ps::Preface section heading:::1::1::1:1:1:preface sect head:0:1:ps - Preface sect heading:0:12:::1::::1:4:2::::s:pp:1:1:"),
_T("ps::Paragraph text, no break with next paragraph text at chapter boundary:c:1::::::1:1:para spans chapters:1:1:OBSOLETE ps - Paragraph - No Break with Next Paragraph:0:12:::::::0::::::m:ps:::"),
_T("psi::Paragraph text, indented, with no break with next paragraph text (at chapter boundary):c:1::::::1:1:para spans chapters indent:1:1:OBSOLETE psi - Paragraph - Indented - No Break with Next:0:12:::::::0:::.25:.25:.125:pi:pi:::"),
_T("pp::Preface paragraph:::1::1::1:1:1:preface paragraph:0:1:pp - Preface paragraph:0:10:::::::0:::::.125:p:pp:::"),
_T("pq::Preface poetry:::1::1::1:1:1:preface poetry:0:1:pq - Preface poetry:0:10:::::::0:::.5:::q:pq:::"),
_T("pm::Preface continue at margin:::1::1::1:1:1:preface at margin:0:1:pm - Preface continue at margin:0:10:::::::0::::::m:pm:::"),
_T("pm::Embedded text paragraph:m mi nb p pc ph phi pi pi1 pi2 pi3 pr psi q q1 q2 q3 q4 qc qr b s1 s2 s3 s4:1:::::1:1:1:paragraph embedded text:1:1:pm - Paragraph - Embedded Text:0:12:::::::0:::.25:.25:.125:p:pm:::"),
_T("pmc::Embedded text closing:m mi nb p pc ph phi pi pi1 pi2 pi3 pr q q1 q2 q3 q4 qc qr b s1 s2 s3 s4:1:::::1:1:1:para embedded text closing:1:1:pmc - Paragraph - Embedded Text Closing:0:12:::::::0:::.25:.25::pm:pmc:::"),
_T("pmr::Embedded text refrain (e.g. Then all the people shall say, 'Amen!'):li li1 li2 li3 li4 lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr po q q1 q2 q3 q4 qc qr b s1 s2 s3 s4:1:::::1:1:1:para embedded text refrain:1:1:pmr - Paragraph - Embedded Text Refrain:0:12:::::::2:::.25:.25::pm:p:::"),
_T("nb::Paragraph text, with no break from previous paragraph text (at chapter boundary) (basic):c:1::::::1:1:para no break:1:1:nb - Paragraph - No Break with Previous Paragraph:0:12:::::::0::::::m:p:::"),
_T("cls::Letter Closing:c:1::::::1:1:Letter closing:1::cls - Paragraph - Letter Closing:0:12:::::::2::::::p:cls:1::"),
_T("q::Poetry text, level 1 indent (if single level):c:1:1:::::1:1:poetry:2:1:q - Poetry - Indent Level 1 - Single Level Only:0:12:::::::0:::1.25::-1:_body_text:q:::"),
_T("q1::Poetry text, level 1 indent (if multiple levels) (basic):c:1::::::1:1:poetry L1:2:1:q1 - Poetry - Indent Level 1:0:12:::::::0:::1.25::-1:q:q1:::"),
_T("q2::Poetry text, level 2 indent (basic):c:1:1:::::1:1:poetry L2:2:1:q2 - Poetry - Indent Level 2:0:12:::::::0:::1.25::-.75:q:q2:::"),
_T("q3::Poetry text, level 3 indent:c:1:1:::::1:1:poetry L3:2:1:q3 - Poetry - Indent Level 3:0:12:::::::0:::1.25::-.5:q2:q3:::"),
_T("q4::Poetry text, level 4 indent:c:1:1:::::1:1:poetry L3:2:1:q4 - Poetry - Indent Level 4:0:12:::::::0:::1.25::-.25:q3:q4:::"),
_T("qc::Poetry text, centered:c esb ms ms1 ms2 s s1 s2 s3 s4 ip:1:1:::::1:1:poetry centered:2:1:qc - Poetry - Centered:0:12:::::::1::::::q:qc:::"),
_T("qr::Poetry text, Right Aligned:c esb ms ms1 ms2 s s1 s2 s3 s4 ip:1:1:::::1:1:poetry right margin:2:1:qr - Poetry - Right Aligned:0:12:::::::2::::::q:qr:::"),
_T("qa::Poetry text, Acrostic marker/heading:c esb ms ms1 ms2 s s1 s2 s3 s4 ip:1:::1:::1:1:acrostic hdg:2:1:qa - Poetry - Acrostic Heading/Marker:0:12::1:::::0::::::_heading_base:q:1:1:"),
_T("qac:qac*:Poetry text, Acrostic markup of the first character of a line of acrostic poetry:q q1 q2 q3 q4 qc qr  NEST:1::::1::1:::2::qac...qac* - Poetry Text - Acrostic Letter:1:12::1:::::0::::::::::"),
_T("qs:qs*:Poetry text, Selah:q q1 q2 q3 q4 qc qr NEST:1::::1::1:::1::qs...qs* - Poetry Text - Selah:1:12::1:::::0::::::::::"),
_T("qm::Poetry, left margin:::1:::::1:1:poetry margin:2:1:qm - Poetry left margin:0:12:::::::0::::::q:qm:::"),
_T("qm::Poetry text, embedded, level 1 indent (if single level):m mi nb p pc ph phi pi pi1 pi2 pi3 pr q q1 q2 q3 q4 qc qr b:1::::::1:1:poetry embed:2:1:qm - Poetry - Embedded Text - Indent Level 1 - Single Level Only:0:12:::::::0:::1::-.75:q:qm:::"),
_T("qm1::Poetry text, embedded, level 1 indent (if multiple levels):m mi nb p pc ph phi pi pi1 pi2 pi3 pr q q1 q2 q3 q4 qc qr b:1::::::1:1:poetry embed L1:2:1:qm1 - Poetry - Embedded Text - Indent Level 1:0:12:::::::0:::1::-.75:qm:qm1:::"),
_T("qm2::Poetry text, embedded, level 2 indent:m mi nb p pc ph phi pi pi1 pi2 pi3 pr q q1 q2 q3 q4 qc qr b:1::::::1:1:poetry embed L2:2:1:qm2 - Poetry - Embedded Text - Indent Level 2:0:12:::::::0:::1::-.5:qm1:qm2:::"),
_T("qm3::Poetry text, embedded, level 3 indent:m mi nb p pc ph phi pi pi1 pi2 pi3 pr q q1 q2 q3 q4 qc qr b:1::::::1:1:poetry embed L3:2:1:qm3 - Poetry - Embedded Text - Indent Level 3:0:12:::::::0:::1::-.25:qm2:qm3:::"),
_T("qd::A Hebrew musical performance annotation, similar in content to Hebrew descriptive title.:c:1::::::1:1:Hebrew note:2:1:qd - Poetry - Hebrew Note:0:12::1:::::0:::.25:::q:qd:1:1:"),
_T("f:f*:A Footnote text item (basic):c cp lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 qs sp tc1 tc2 tc3 tc4 mt mt1 mt2 mt3 ms ms1 ms2 ms3 s s1 s2 s3 d ip:1:1::1:1:1:1:1:footnote:9::f...f* - Footnote:4:10:::::::0::::::_notes_base:f:::"),
_T("fe::Footnote (end):::1:::::1:::1::fe - Footnote end PNG:1:10:::::::0::::::::::"),
_T("fe:fe*:An Endnote text item:c lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 sp tc1 tc2 tc3 tc4 ms ms1 ms2 ms3 s s1 s2 s3 d ip:1:::1:1:1:1:1:endnote:9::fe...fe* - Endnote:4:10:::::::0::::::_notes_base:fe:::"),
_T("fr:fr*:The origin reference for the footnote (basic):f fe ef efe:1::::1:1:1:1:ref:9::fr - Footnote - Reference:1:10:::1::::0::::::::::"),
_T("fk:fk*:A footnote keyword (basic):f fe ef efe:1::::1:1:1:1:keyword:9::fk - Footnote - Keyword:1:10::1:1::::0::::::::::"),
_T("fq:fq*:A footnote scripture quote or alternate rendering (basic):f fe ef efe:1::::1:1:1:1:quote:9::fq - Footnote - Quotation or Alternate Rendering:1:10::1:::::0::::::::::"),
_T("fqa:fqa*:A footnote alternate rendering for a portion of scripture text:f fe ef efe:1::::1:1:1:1:alt-transln:9::fqa - Footnote - Alternate Translation Rendering:1:10::1:::::0::::::::::"),
_T("fl:fl*:A footnote label text item, for marking or 'labelling' the type or alternate translation being provided in the note.:f fe ef efe:1::::1:1:1:1:label:9::fl - Footnote - Label Text:1:10::1:1::::0::::::::::"),
_T("fw:fw*:A footnote witness list, for distinguishing a list of sigla representing witnesses in critical editions.:f fe:1::::1:1:1:1:witness list:9::fw - Footnote - Witness List:1:12:::::::0::::::::::"),
_T("fp:fp*:A Footnote additional paragraph marker:f fe ef efe:1::::1:1:1:1:new-paragr:9::fp - Footnote Paragraph Mark:1:10:::::::0::::::::::"),
_T("ft:ft*:Footnote text, Protocanon (basic):f fe ef efe:1::::1:1:1:1:fn-text:9::ft - Footnote - Text:1:10:::::::0::::::::::"),
_T("fdc:fdc*:Footnote text, applies to Deuterocanon only:f fe ef efe:1::::1:1:1:1:deut-canon:9::DEPRECATED fdc...fdc* - Footnote - DC text:1:10:::::::0::::::::::"),
_T("fv:fv*:A verse number within the footnote text:f fe ef efe:1::::1:1::1:verse#:9::fv...fv* - Footnote - Embedded Verse Number:1:10:::1:::1:0::::::::::"),
_T("fm:fm*:An additional footnote marker location for a previous footnote:lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 sp tc1 tc2 tc3 tc4 ms ms1 ms2 s s1 s2 s3 d ip:1::::1:1::1:call-prev:9::fm - Footnote - Additional Caller to Previous Note:1:10::::::1:0::::::::::"),
_T("F::Footnote (end):::1:::::1:::1::F - Footnote end PNG:1:10:::::::0::::::::::"),
_T("qt:qt*:For Old Testament quoted text appearing in the New Testament (basic):ip im ipi imi ipq imq ipr iq iq1 iq2 iq3 io io1 io2 io3 io4 ms ms1 ms2 s s1 s2 s3 s4 cd sp d lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 tr th1 th2 th3 th4 thr1 thr2 thr3 thr4 tc1 tc2 tc3 tc4 tcr1 tcr2 tcr3 tcr4 f fe NEST:1::::1::1:1:Quotation:1::qt...qt* - Special Text - Quoted Text - OT in NT:1:12::1:::::0::::::::::"),
_T("nd:nd*:For name of deity (basic):ip im ipi imi ipq imq ipr iq iq1 iq2 iq3 io io1 io2 io3 io4 ms ms1 ms2 s s1 s2 s3 s4 cd sp d lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 tr th1 th2 th3 th4 thr1 thr2 thr3 thr4 tc1 tc2 tc3 tc4 tcr1 tcr2 tcr3 tcr4 f fe NEST:1::::1:::::1::nd...nd* - Special Text - Name of Deity:1:12::::1:::0::::::::::"),
_T("tl:tl*:For transliterated words:ip im ipi imi ipq imq ipr iq iq1 iq2 iq3 io io1 io2 io3 io4 ms ms1 ms2 s s1 s2 s3 s4 cd sp d lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 cls tr th1 th2 th3 th4 thr1 thr2 thr3 thr4 tc1 tc2 tc3 tc4 tcr1 tcr2 tcr3 tcr4 f fe NEST:1::::1:::::1::tl...tl* - Special Text - Transliterated Word:1:12::1:::::0::::::::::"),
_T("dc:dc*:Deuterocanonical/LXX additions or insertions in the Protocanonical text:ip im ipi imi ipq imq ipr iq iq1 iq2 iq3 io io1 io2 io3 io4 ms ms1 ms2 s s1 s2 s3 s4 cd sp d lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 tr th1 th2 th3 th4 thr1 thr2 thr3 thr4 tc1 tc2 tc3 tc4 tcr1 tcr2 tcr3 tcr4 f fe NEST:1::::1:::::1::dc...dc* - Special Text - Deuterocanonical/LXX Additions:1:12::1:::::0::::::::::"),
_T("bk:bk*:For the quoted name of a book:imt imt1 imt2 imt3 imt4 imte imte1 imte2 is is1 is2 ili ili1 ili2 ip im ipi imi ipq imq ipr iq iq1 iq2 iq3 io io1 io2 io3 io4 ms ms1 ms2 s s1 s2 s3 s4 cd sp d lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 tr th1 th2 th3 th4 thr1 thr2 thr3 thr4 tc1 tc2 tc3 tc4 tcr1 tcr2 tcr3 tcr4 f fe NEST:1::::1:::::1::bk...bk* - Special Text - Quoted book title:1:12::1:::::0::::::::::"),
_T("sig:sig*:For the signature of the author of an Epistle:ip im ipi imi ipq imq ipr iq iq1 iq2 iq3 io io1 io2 io3 io4 ms ms1 ms2 s s1 s2 s3 s4 cd sp d lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 cls tr th1 th2 th3 th4 thr1 thr2 thr3 thr4 tc1 tc2 tc3 tc4 tcr1 tcr2 tcr3 tcr4 f fe NEST:1::::1:::::1::sig...sig* - Special Text - Author's Signature (Epistles):1:12::1:::::0::::::::::"),
_T("pn:pn*:For a proper name:ip im ipi imi ipq imq ipr iq iq1 iq2 iq3 io io1 io2 io3 io4 ms ms1 ms2 s s1 s2 s3 s4 cd sp d lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 cls tr th1 th2 th3 th4 thr1 thr2 thr3 thr4 tc1 tc2 tc3 tc4 tcr1 tcr2 tcr3 tcr4 f fe NEST:1::::1:::::1::pn...pn* - Special Text - Proper Name:1:12:::1:1:::0::::::::::"),
_T("png:png*:For a geographic proper name:ip im ipi imi ipq imq ipr iq iq1 iq2 iq3 io io1 io2 io3 io4 ms ms1 ms2 s s1 s2 s3 s4 cd sp d lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 cls tr th1 th2 th3 th4 thr1 thr2 thr3 thr4 tc1 tc2 tc3 tc4 tcr1 tcr2 tcr3 tcr4 f fe NEST:1::::1:::::1::png...png* - Special Text - Geographic Proper Name:1:12::::1:::0::::::::::"),
_T("wj:wj*:For marking the words of Jesus:ip im ipi imi ipq imq ipr iq iq1 iq2 iq3 io io1 io2 io3 io4 ms ms1 ms2 s s1 s2 s3 s4 cd sp d lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 tr th1 th2 th3 th4 thr1 thr2 thr3 thr4 tc1 tc2 tc3 tc4 tcr1 tcr2 tcr3 tcr4 f fe NEST:1::::1:::::1::wj...wj* - Special Text - Words of Jesus:1:12:255::::::0::::::::::"),
_T("k:k*:For a keyword:ip im ipi imi ipq imq ipr iq iq1 iq2 iq3 io io1 io2 io3 io4 ms ms1 ms2 s s1 s2 s3 s4 cd sp d lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 tr th1 th2 th3 th4 thr1 thr2 thr3 thr4 tc1 tc2 tc3 tc4 tcr1 tcr2 tcr3 tcr4 f fe NEST:1::::1:::::1::k...k* - Special Text - Keyword:1:12::1:1::::0::::::::::"),
_T("sls:sls*:To represent where the original text is in a secondary language or from an alternate text source:lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 sp tr th1 th2 th3 th4 thr1 thr2 thr3 thr4 tc1 tc2 tc3 tc4 tcr1 tcr2 tcr3 tcr4 f fe NEST:1::::1:::::1::sls...sls* - Special Text - Secondary Language or Text Source:1:12::1:::::0::::::::::"),
_T("ord:ord*:For the text portion of an ordinal number:ip im ipi imi ipq imq ipr iq iq1 iq2 iq3 io io1 io2 io3 io4 ms ms1 ms2 s s1 s2 s3 s4 cd sp d lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 tr th1 th2 th3 th4 thr1 thr2 thr3 thr4 tc1 tc2 tc3 tc4 tcr1 tcr2 tcr3 tcr4 f fe NEST:1::::1:::::1::ord...ord* - Special Text - Ordinal number text portion:1:12::::::1:0::::::::::"),
_T("add:add*:For a translational addition to the text:ip im ipi imi ipq imq ipr iq iq1 iq2 iq3 io io1 io2 io3 io4 ms ms1 ms2 s s1 s2 s3 s4 cd sp d lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 cls tr th1 th2 th3 th4 thr1 thr2 thr3 thr4 tc1 tc2 tc3 tc4 tcr1 tcr2 tcr3 tcr4 f fe NEST:1::::1:1:1:1:addl material:1::add...add* - Special Text - Translational Addition:1:12:2263842:1:1::::0::::::::::"),
_T("no:no*:A character style, use normal text:is ip ipi im imi ili ili1 ili2 imq ipq iex iq iot io1 io2 io3 io4 s s1 s2 s3 NEST:1::::1:::::1::no...no* - Character - Normal Text:1:12:::::::0::::::::::"),
_T("bd:bd*:A character style, use bold text:ip im ipi imi ipq imq ipr iq iq1 iq2 iq3 io io1 io2 io3 io4 ms ms1 ms2 s s1 s2 s3 s4 cd sp d lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 tr th1 th2 th3 th4 thr1 thr2 thr3 thr4 tc1 tc2 tc3 tc4 tcr1 tcr2 tcr3 tcr4 f fe x NEST:1::::1:::::1::bd...bd* - Character - Bold Text:1:12:::1::::0::::::::::"),
_T("it:it*:A character style, use italic text:ip im ipi imi ipq imq ipr iq iq1 iq2 iq3 io io1 io2 io3 io4 ms ms1 ms2 s s1 s2 s3 s4 cd sp d lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 tr th1 th2 th3 th4 thr1 thr2 thr3 thr4 tc1 tc2 tc3 tc4 tcr1 tcr2 tcr3 tcr4 f fe x NEST:1::::1:::::1::it...it* - Character - Italic Text:1:12::1:::::0::::::::::"),
_T("bdit:bdit*:A character style, use bold + italic text:ip im ipi imi ipq imq ipr iq iq1 iq2 iq3 io io1 io2 io3 io4 ms ms1 ms2 s s1 s2 s3 s4 cd sp d lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 tr th1 th2 th3 th4 thr1 thr2 thr3 thr4 tc1 tc2 tc3 tc4 tcr1 tcr2 tcr3 tcr4 f fe x NEST:1::::1:::::1::bdit...bdit* - Character - BoldItalic Text:1:12::1:1::::0::::::::::"),
_T("em:em*:A character style, use emphasized text style:ip im ipi imi ipq imq ipr iq iq1 iq2 iq3 io io1 io2 io3 io4 ms ms1 ms2 s s1 s2 s3 s4 cd sp d lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 tr th1 th2 th3 th4 thr1 thr2 thr3 thr4 tc1 tc2 tc3 tc4 tcr1 tcr2 tcr3 tcr4 f fe x NEST:1::::1:::::1::em...em* - Character - Emphasized Text:1:12::1:::::0::::::::::"),
_T("sc:sc*:A character style, for small capitalization text:ip im ipi imi ipq imq ipr iq iq1 iq2 iq3 io io1 io2 io3 io4 ms ms1 ms2 s s1 s2 s3 s4 cd sp d lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 tr th1 th2 th3 th4 thr1 thr2 thr3 thr4 tc1 tc2 tc3 tc4 tcr1 tcr2 tcr3 tcr4 f fe x NEST:1::::1:::::1::sc...sc* - Character - Small Caps:1:12:::::1::0::::::::::"),
_T("sup:sup*:A character style, for superscript text. Typically for use in critical edition footnotes.:ip im ipi imi ipq imq ipr iq iq1 iq2 iq3 io io1 io2 io3 io4 ms ms1 ms2 s s1 s2 s3 s4 cd sp d lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 tr th1 th2 th3 th4 thr1 thr2 thr3 thr4 tc1 tc2 tc3 tc4 tcr1 tcr2 tcr3 tcr4 f fe x NEST:1::::1:::::6::sup...sup* - Character - Superscript:1:10::::::1:0::::::::::"),
_T("pro:pro*:For indicating pronunciation in CJK texts:ip im ipi imi ipq imq ipr iq iq1 iq2 iq3 li li1 li2 li3 li4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr q q1 q2 q3 q4 qc qr qm qm1 qm2 qm3 sp tr th1 th2 th3 th4 thr1 thr2 thr3 thr4 tc1 tc2 tc3 tc4 tcr1 tcr2 tcr3 tcr4 ms ms1 ms2 s s1 s2 s3 d ip f fe NEST:1::1:1:1:::::6::DEPRECATED pro...pro* - Special Text - CJK Pronunciation:1:10:::::::0::::::::::"),
_T("imt::Introduction main title, level 1 (if single level) (basic):id:1:::1::1:1:1:intro main title:0:1:imt - Introduction - Major Title Level 1:0:14:::1::::1:8:4::::_intro_base:ip:1:1:"),
_T("imt1::Introduction major title, level 1 (if multiple levels):id:1:::1::1:1:1:intro major title L1:0:1:imt1 - Introduction - Major Title Level 1:0:14:::1::::1:8:4::::imt:ip:1:1:"),
_T("imt2::Introduction major title, level 2:id:1:::1::1:1:1:intro major title L2:0:1:imt2 - Introduction - Major Title Level 2:0:13::1:::::1:6:3::::imt1:ip:1:1:"),
_T("imt3::Introduction major title, level 3:id:1:::1::1:1:1:intro major title L3:0:1:imt3 - Introduction - Major Title Level 3:0:12:::1::::1:2:2::::imt2:ip:1:1:"),
_T("imt4::Introduction major title, level 4 (usually within parenthesis):id:1:::1::1:1:1:intro major title L4:0:1:imt4 - Introduction - Major Title Level 4:0:12::1:::::1:2:2::::imt3:ip:1:1:"),
_T("imte::Introduction major title at introduction end, level 1 (if single level):id:1:::1::1:1:1:intro major title at end:0:1:imte - Introduction - [Uncommon] Major Title at Introduction End Level 1:0:20:::1::::1:8:4::::imt:ie:::"),
_T("imte1::Introduction major title at introduction end, level 1 (if multiple levels):id:1:::1::1:1:1:intro major title at end:0:1:imte1 - Introduction - [Uncommon] Major Title at Introduction End Level 1:0:20:::1::::1:8:4::::imt:ie:::"),
_T("imte2::Introduction major title at introduction end, level 2:id:1:::1::1:1:1:intro major title at end:0:1:imte2 - Introduction - [Uncommon] Major Title at Introduction End Level 2:0:16::1:::::1:8:4::::imt:ie:::"),
_T("is::Introduction section heading, level 1 (if single level) (basic):id:1:1::1::1:1:1:intro sect head:0:1:is - Introduction - Section Heading Level 1:0:12:::1::::1:8:4::::s:ip:1:1:"),
_T("is1::Introduction section heading, level 1 (if multiple levels):id:1:::1::1:1:1:intro sect head L1:0:1:is1 - Introduction - Section Heading Level 1:0:12:::1::::1:8:4::::is:ip:1:1:"),
_T("is2::Introduction section heading, level 2:id:1:::1::1:1:1:intro sect head L2:0:1:is2 - Introduction - Section Heading Level 2:0:12:::1::::1:8:4::::is1:ip:1:1:"),
_T("ip::Introduction prose paragraph (basic):id c:1:1::1::1:1:1:intro paragraph:0:1:ip - Introduction - Paragraph:0:10:::::::0:::::.125:_intro_base:ip:::"),
_T("ipi::Introduction prose paragraph, indented, with first line indent:id:1:1::1::1:1:1:intro paragraph indented:0:1:ipi - Introduction - Indented Para - first line indent:0:10:::::::0:::.25:.25:.125:ip:ipi:::"),
_T("ipq::Introduction prose paragraph, quote from the body text:id:1:::1::1:1:1:intro para quote:0:1:ipq - Introduction - Paragraph - quote from text:0:10::1:::::0:::.25:.25:.125:ip:ipq:::"),
_T("ipr::Introduction prose paragraph, right aligned:id:1:::1::1:1:1:intro para right align:0:1:ipr - Introduction - Paragraph - right aligned:0:10::1:::::2:::.25:.25::ip:ipr:::"),
_T("iq::Introduction poetry text, level 1 (if single level):id:1:1::1::1:1:1:intro poetry:0:1:iq - Introduction - Poetry Level 1:0:10::1:::::0:::1::-.75:ip:iq:::"),
_T("iq1::Introduction poetry text, level 1 (if multiple levels):id:1:::1::1:1:1:intro poetry L1:0:1:iq1 - Introduction - Poetry Level 1:0:10::1:::::0:::1::-.75:iq:iq1:::"),
_T("iq2::Introduction poetry text, level 2:id:1:1::1::1:1:1:intro poetry L2:0:1:iq2 - Introduction - Poetry Level 2:0:10::1:::::0:::1::-.5:iq:iq2:::"),
_T("iq3::Introduction poetry text, level 3:id:1:::1::1:1:1:intro poetry L3:0:1:iq3 - Introduction - Poetry Level 3:0:10::1:::::0:::1::-.25:iq:iq3:::"),
_T("im::Introduction prose paragraph, with no first line indent (may occur after poetry):id:1:1::1::1:1:1:intro para no indent:0:1:im - Introduction - Paragraph - no first line indent:0:10:::::::0::::::ip:im:::"),
_T("imi::Introduction prose paragraph text, indented, with no first line indent:id:1:1::1::1:1:1:intro para no indent:0:1:imi - Introduction - Indented Para - no first line indent:0:10:::::::0:::.25:.25::ipi:imi:::"),
_T("ili::A list entry, level 1 (if single level):id:1:::1::1:1:1:intro list L1:0:1:ili - Introduction - List Entry - Level 1:0:12:::::::0:::.625::-.375:_list_base:ili:::"),
_T("ili1::A list entry, level 1 (if multiple levels):id:1:::1::1:1:1:intro list L1:0:1:ili1 - Introduction - List Entry - Level 1:0:12:::::::0:::.5::-.25:ili:ili1:::"),
_T("ili2::A list entry, level 2:id:1:::1::1:1:1:intro list L2:0:1:ili2 - Introduction - List Entry - Level 2:0:12:::::::0:::.75::-.25:ili1:ili2:::"),
_T("imq::Introduction prose paragraph, quote from the body text, with no first line indent:id:1:::1::1:1:1:intro para quote no indent:0:1:imq - Introduction - Paragraph - quote from text - no first line indent:0:10::1:::::0:::.25:.25::imi:imq:::"),
_T("ib::Introduction blank line:id:1::1:1::1::::0:1:ib - Introduction - Blank Line:0:12:::::::0::::::_intro_base:ib:::"),
_T("iot::Introduction outline title (basic):id:1:::1::1:1:1:intro outline title:0:1:iot - Introduction - Outline Title:0:12:::1::::1:8:4::::imt:io1:1:1:"),
_T("io::Introduction outline text, level 1 (if single level):id:1:1::1::1:1:1:intro outline:0:1:io - Introduction - Outline Level 1:0:10:::::::0:::.5:::_intro_base:io:::"),
_T("io1::Introduction outline text, level 1 (if multiple levels) (basic):id:1:1::1::1:1:1:intro outline L1:0:1:io1 - Introduction - Outline Level 1:0:10:::::::0:::.5:::io:io1:::"),
_T("io2::Introduction outline text, level 2:id:1:1::1::1:1:1:intro outline L2:0:1:io2 - Introduction - Outline Level 2:0:10:::::::0:::.75:::io1:io2:::"),
_T("io3::Introduction outline text, level 3:id:1:1::1::1:1:1:intro outline L3:0:1:io3 - Introduction - Outline Level 3:0:10:::::::0:::1:::io2:io3:::"),
_T("io4::Introduction outline text, level 4:id:1:1::1::1:1:1:intro outline L4:0:1:io4 - Introduction - Outline Level 4:0:10:::::::0:::1.25:::io3:io4:::"),
_T("ior:ior*:Introduction references range for outline entry; for marking references separately:id io io1 io2 io3 io4 NEST:1:::1:1:1::::6::ior...ior* - Introduction - Outline References Range:1:10:::::::0::::::::::"),
_T("iex::Introduction explanatory or bridge text (e.g. explanation of missing book in Short Old Testament):id:1:::1::1:1:1:intro explain text:0:1:iex - Introduction - Explanatory or Bridge Text:0:10:::::::0:4:4:::.125:ip:iex:::"),
_T("iqt:iqt*:For quoted scripture text appearing in the introduction:id NEST:1:::1:1:1::::6::iqt...iqt* - Special Text - Quoted Scripture Text in Introduction:1:12::1:::::0::::::::::"),
_T("ie::Introduction ending marker:id:1::1:::1:1:::0::ie - Introduction - End Marker:8:12:::::::0:12:4:1.5:1.5::_intro_base:ie:::"),
_T("li::A list entry, level 1 (if single level):c esb ms ms1 ms2 s s1 s2 s3 s4 ip:1::::::1:1:list item:1:1:li - List Entry - Level 1:0:12:::::::0:::.625::-.375:_list_base:li:::"),
_T("lh::List header (introductory remark):c esb ms ms1 ms2 s s1 s2 s3 s4 ip:1::::::1:1:list header:1:1:lh - List Header:0:12:::::::0:::::.125:_list_base:lh:1:1:"),
_T("lf::List footer (concluding remark):c esb ms ms1 ms2 s s1 s2 s3 s4 ip:1::::::1:1:list footer:1:1:lf - List Footer:0:12:::::::0::::::_list_base:lf:::"),
_T("lim::An embedded list entry, level 1 (if single level):c:1::::::1:1:embedded list item:1:1:lim - Embedded List Entry - Level 1:0:12:::::::0:::.75::-.375:_list_base:lim:::"),
_T("lim1::An embedded list entry, level 1 (if multiple levels):c:1::::::1:1:embedded list item:1:1:lim1 - Embedded List Entry - Level 1:0:12:::::::0:::.75::-.375:_list_base:lim1:::"),
_T("lim2::An embedded list entry, level 2:c:1::::::1:1:embedded list item:1:1:lim2 - Embedded List Entry - Level 2:0:12:::::::0:::1.0::-.375:_list_base:lim2:::"),
_T("lim3::An embedded list entry, level 3:c:1::::::1:1:embedded list item:1:1:lim3 - Embedded List Entry - Level 3:0:12:::::::0:::1.25::-.375:_list_base:lim3:::"),
_T("lim4::An embedded list entry, level 4:c:1::::::1:1:embedded list item:1:1:lim4 - Embedded List Entry - Level 4:0:12:::::::0:::1.5::-.375:_list_base:lim4:::"),
_T("litl:litl*:List entry total text:li li1 li2 li3 li4 lim lim1 lim2 lim3 lim4 NEST:1::::1::1:1:list item total:1:1:litl...litl* - List Entry - Total:1:12::1:::::0::::::::::"),
_T("lik:lik*:Structured list entry key text:li li1 li2 li3 li4 lim lim1 lim2 lim3 lim4 NEST:1::::1::1:1:structured list key:1:1:lik...lik* - Structured List Entry - Key:1:12::1:::::0::::::::::"),
_T("liv:liv*:Structured list entry value 1 content (if single value):li li1 li2 li3 li4 lim lim1 lim2 lim3 lim4 NEST:1::::1::1:1:structured list entry:1:1:liv...liv* - Structured List Entry - Value 1:1:12:::::::0::::::::::"),
_T("liv1:liv1*:Structured list entry value 1 content (if multiple values):li li1 li2 li3 li4 lim lim1 lim2 lim3 lim4 NEST:1::1::::1:1:structured list entry:1:1:liv1...liv1* - Structured List Entry - Value 1:1:12:::::::0::::::::::"),
_T("liv2:liv2*:Structured list entry value 2 content:li li1 li2 li3 li4 lim lim1 lim2 lim3 lim4 NEST:1::::1::1:1:structured list entry:1:1:liv2...liv2* - Structured List Entry - Value 2:1:12:::::::0::::::::::"),
_T("liv3:liv3*:Structured list entry value 3 content:li li1 li2 li3 li4 lim lim1 lim2 lim3 lim4 NEST:1::::1::1:1:structured list entry:1:1:liv3...liv3* - Structured List Entry - Value 3:1:12:::::::0::::::::::"),
_T("liv4:liv4*:Structured list entry value 4 content:li li1 li2 li3 li4 lim lim1 lim2 lim3 lim4 NEST:1::::1::1:1:structured list entry:1:1:liv4...liv4* - Structured List Entry - Value 4:1:12:::::::0::::::::::"),
_T("liv5:liv5*:Structured list entry value 5 content:li li1 li2 li3 li4 lim lim1 lim2 lim3 lim4 NEST:1::::1::1:1:structured list entry:1:1:liv5...liv5* - Structured List Entry - Value 5:1:12:::::::0::::::::::"),
_T("li1::A list entry, level 1 (if multiple levels):c esb ms ms1 ms2 s s1 s2 s3 s4 ip:1::::::1:1:list item L1:1:1:li1 - List Entry - Level 1:0:12:::::::0:::.5::-.25:li:li1:::"),
_T("li2::A list entry, level 2:c esb ms ms1 ms2 s s1 s2 s3 s4 ip:1::::::1:1:list item L2:1:1:li2 - List Entry - Level 2:0:12:::::::0:::.75::-.25:li1:li2:::"),
_T("li3::A list entry, level 3:c esb ms ms1 ms2 s s1 s2 s3 s4 ip:1::::::1:1:list item L3:1:1:li3 - List Entry - Level 3:0:12:::::::0:::1::-.25:li2:li3:::"),
_T("li4::A list entry, level 4:c esb ms ms1 ms2 s s1 s2 s3 s4 ip:1::::::1:1:list item L4:1:1:li4 - List Entry - Level 4:0:12:::::::0:::1.25::-.25:li3:li4:::"),
_T("qh::List or Genealogy:::1:::::1:1:list item:1:1:qh - List or Genealogy:0:12:::::::0:::.625::-.375:q:qh:::"),
_T("tr::A new table row:c esb ms ms1 ms2 s s1 s2 s3 s4 ip:1::::::1:1:tbl row:1:1:tr - Table - Row:0:12:::::::0:::.5::-.25:_body_text:tr:::"),
_T("tr1::A table Row:c:1::::::1:1:tbl row L1:1:1:OBSOLETE tr1 - Table - Row - Level 1:0:12:::::::0:::.5::-.25:tr:tr1:::"),
_T("tr2::A table Row:c:1::::::1:1:tbl row L2:1:1:OBSOLETE tr2 - Table - Row - Level 2:0:12:::::::0:::.75::-.25:tr1:tr2:::"),
_T("th1::A table heading, column 1:tr:1::::::1:1:tbl hdg c1:1::th1 - Table - Column 1 Heading:1:12::1:::::0::::::::::"),
_T("th2::A table heading, column 2:tr:1::::::1:1:tbl hdg c2:1::th2 - Table - Column 2 Heading:1:12::1:::::0::::::::::"),
_T("th3::A table heading, column 3:tr:1::::::1:1:tbl hdg c3:1::th3 - Table - Column 3 Heading:1:12::1:::::0::::::::::"),
_T("th4::A table heading, column 4:tr:1::::::1:1:tbl hdg c4:1::th4 - Table - Column 4 Heading:1:12::1:::::0::::::::::"),
_T("th5::A table heading, column 5:tr:1::::::1:1:tbl hdg c5:1::th5 - Table - Column 5 Heading:1:12::1:::::0::::::::::"),
_T("th6::A table heading, column 6:tr:1::::::1:1:tbl hdg c6:1::th6 - Table - Column 6 Heading:1:12::1:::::0::::::::::"),
_T("th7::A table heading, column 7:tr:1::::::1:1:tbl hdg c7:1::th7 - Table - Column 7 Heading:1:12::1:::::0::::::::::"),
_T("th8::A table heading, column 8:tr:1::::::1:1:tbl hdg c8:1::th8 - Table - Column 8 Heading:1:12::1:::::0::::::::::"),
_T("th9::A table heading, column 9:tr:1::::::1:1:tbl hdg c9:1::th9 - Table - Column 9 Heading:1:12::1:::::0::::::::::"),
_T("th10::A table heading, column 10:tr:1::::::1:1:tbl hdg c10:1::th10 - Table - Column 10 Heading:1:12::1:::::0::::::::::"),
_T("th11::A table heading, column 11:tr:1::::::1:1:tbl hdg c11:1::th11 - Table - Column 11 Heading:1:12::1:::::0::::::::::"),
_T("th12::A table heading, column 12:tr:1::::::1:1:tbl hdg c12:1::th12 - Table - Column 12 Heading:1:12::1:::::0::::::::::"),
_T("thr1::A table heading, column 1, right aligned:tr:1::::::1:1:tbl hdg c1r:1::thr1 - Table - Column 1 Heading - Right Aligned:1:12::1:::::2::::::::::"),
_T("thr2::A table heading, column 2, right aligned:tr:1::::::1:1:tbl hdg c2r:1::thr2 - Table - Column 2 Heading - Right Aligned:1:12::1:::::2::::::::::"),
_T("thr3::A table heading, column 3, right aligned:tr:1::::::1:1:tbl hdg c3r:1::thr3 - Table - Column 3 Heading - Right Aligned:1:12::1:::::2::::::::::"),
_T("thr4::A table heading, column 4, right aligned:tr:1::::::1:1:tbl hdg c4r:1::thr4 - Table - Column 4 Heading - Right Aligned:1:12::1:::::2::::::::::"),
_T("thr5::A table heading, column 5, right aligned:tr:1::::::1:1:tbl hdg c5r:1::thr5 - Table - Column 5 Heading - Right Aligned:1:12::1:::::2::::::::::"),
_T("thr6::A table heading, column 6, right aligned:tr:1::::::1:1:tbl hdg c6r:1::thr6 - Table - Column 6 Heading - Right Aligned:1:12::1:::::2::::::::::"),
_T("thr7::A table heading, column 7, right aligned:tr:1::::::1:1:tbl hdg c7r:1::thr7 - Table - Column 7 Heading - Right Aligned:1:12::1:::::2::::::::::"),
_T("thr8::A table heading, column 8, right aligned:tr:1::::::1:1:tbl hdg c8r:1::thr8 - Table - Column 8 Heading - Right Aligned:1:12::1:::::2::::::::::"),
_T("thr9::A table heading, column 9, right aligned:tr:1::::::1:1:tbl hdg c9r:1::thr9 - Table - Column 9 Heading - Right Aligned:1:12::1:::::2::::::::::"),
_T("thr10::A table heading, column 10, right aligned:tr:1::::::1:1:tbl hdg c10r:1::thr10 - Table - Column 10 Heading - Right Aligned:1:12::1:::::2::::::::::"),
_T("thr11::A table heading, column 11, right aligned:tr:1::::::1:1:tbl hdg c11r:1::thr11 - Table - Column 11 Heading - Right Aligned:1:12::1:::::2::::::::::"),
_T("thr12::A table heading, column 12, right aligned:tr:1::::::1:1:tbl hdg c12r:1::thr12 - Table - Column 12 Heading - Right Aligned:1:12::1:::::2::::::::::"),
_T("tc1::A table cell item, column 1:tr:1::::::1:1:tbl cell c1:1::tc1 - Table - Column 1 Cell:1:12:::::::0::::::::::"),
_T("tc2::A table cell item, column 2:tr:1::::::1:1:tbl cell c2:1::tc2 - Table - Column 2 Cell:1:12:::::::0::::::::::"),
_T("tc3::A table cell item, column 3:tr:1::::::1:1:tbl cell c3:1::tc3 - Table - Column 3 Cell:1:12:::::::0::::::::::"),
_T("tc4::A table cell item, column 4:tr:1::::::1:1:tbl cell c4:1::tc4 - Table - Column 4 Cell:1:12:::::::0::::::::::"),
_T("tc5::A table cell item, column 5:tr:1::::::1:1:tbl cell c5:1::tc5 - Table - Column 5 Cell:1:12:::::::0::::::::::"),
_T("tc6::A table cell item, column 6:tr:1::::::1:1:tbl cell c6:1::tc6 - Table - Column 6 Cell:1:12:::::::0::::::::::"),
_T("tc7::A table cell item, column 7:tr:1::::::1:1:tbl cell c7:1::tc7 - Table - Column 7 Cell:1:12:::::::0::::::::::"),
_T("tc8::A table cell item, column 8:tr:1::::::1:1:tbl cell c8:1::tc8 - Table - Column 8 Cell:1:12:::::::0::::::::::"),
_T("tc9::A table cell item, column 9:tr:1::::::1:1:tbl cell c9:1::tc9 - Table - Column 9 Cell:1:12:::::::0::::::::::"),
_T("tc10::A table cell item, column 10:tr:1::::::1:1:tbl cell c10:1::tc10 - Table - Column 10 Cell:1:12:::::::0::::::::::"),
_T("tc11::A table cell item, column 11:tr:1::::::1:1:tbl cell c11:1::tc11 - Table - Column 11 Cell:1:12:::::::0::::::::::"),
_T("tc12::A table cell item, column 12:tr:1::::::1:1:tbl cell c12:1::tc12 - Table - Column 12 Cell:1:12:::::::0::::::::::"),
_T("thc1::A table heading, column 1, center aligned:tr:1::::::1:1:tbl hdg c1c:1::thc1 - Table - Column 1 Heading - Center Aligned:1:12::1:::::1::::::::::"),
_T("thc2::A table heading, column 2, center aligned:tr:1::::::1:1:tbl hdg c2c:1::thc2 - Table - Column 2 Heading - Center Aligned:1:12::1:::::1::::::::::"),
_T("thc3::A table heading, column 3, center aligned:tr:1::::::1:1:tbl hdg c3c:1::thc3 - Table - Column 3 Heading - Center Aligned:1:12::1:::::1::::::::::"),
_T("thc4::A table heading, column 4, center aligned:tr:1::::::1:1:tbl hdg c4c:1::thc4 - Table - Column 4 Heading - Center Aligned:1:12::1:::::1::::::::::"),
_T("thc5::A table heading, column 5, center aligned:tr:1::::::1:1:tbl hdg c5c:1::thc5 - Table - Column 5 Heading - Center Aligned:1:12::1:::::1::::::::::"),
_T("thc6::A table heading, column 6, center aligned:tr:1::::::1:1:tbl hdg c6c:1::thc6 - Table - Column 6 Heading - Center Aligned:1:12::1:::::1::::::::::"),
_T("thc7::A table heading, column 7, center aligned:tr:1::::::1:1:tbl hdg c7c:1::thc7 - Table - Column 7 Heading - Center Aligned:1:12::1:::::1::::::::::"),
_T("thc8::A table heading, column 8, center aligned:tr:1::::::1:1:tbl hdg c8c:1::thc8 - Table - Column 8 Heading - Center Aligned:1:12::1:::::1::::::::::"),
_T("thc9::A table heading, column 9, center aligned:tr:1::::::1:1:tbl hdg c9c:1::thc9 - Table - Column 9 Heading - Center Aligned:1:12::1:::::1::::::::::"),
_T("thc11::A table heading, column 11, center aligned:tr:1::::::1:1:tbl hdg c11c:1::thc11 - Table - Column 11 Heading - Center Aligned:1:12::1:::::1::::::::::"),
_T("thc12::A table heading, column 12, center aligned:tr:1::::::1:1:tbl hdg c12c:1::thc12 - Table - Column 12 Heading - Center Aligned:1:12::1:::::1::::::::::"),
_T("tcr1::A table cell item, column 1, right aligned:tr:1::::::1:1:tbl cell c1r:1::tcr1 - Table - Column 1 Cell - Right Aligned:1:12:::::::2::::::::::"),
_T("tcr2::A table cell item, column 2, right aligned:tr:1::::::1:1:tbl cell c2r:1::tcr2 - Table - Column 2 Cell - Right Aligned:1:12:::::::2::::::::::"),
_T("tcr3::A table cell item, column 3, right aligned:tr:1::::::1:1:tbl cell c3r:1::tcr3 - Table - Column 3 Cell - Right Aligned:1:12:::::::2::::::::::"),
_T("tcr4::A table cell item, column 4, right aligned:tr:1::::::1:1:tbl cell c4r:1::tcr4 - Table - Column 4 Cell - Right Aligned:1:12:::::::2::::::::::"),
_T("tcr5::A table cell item, column 5, right aligned:tr:1::::::1:1:tbl cell c5r:1::tcr5 - Table - Column 5 Cell - Right Aligned:1:12:::::::2::::::::::"),
_T("tcr6::A table cell item, column 6, right aligned:tr:1::::::1:1:tbl cell c6r:1::tcr6 - Table - Column 6 Cell - Right Aligned:1:12:::::::2::::::::::"),
_T("tcr7::A table cell item, column 7, right aligned:tr:1::::::1:1:tbl cell c7r:1::tcr7 - Table - Column 7 Cell - Right Aligned:1:12:::::::2::::::::::"),
_T("tcr8::A table cell item, column 8, right aligned:tr:1::::::1:1:tbl cell c8r:1::tcr8 - Table - Column 8 Cell - Right Aligned:1:12:::::::2::::::::::"),
_T("tcr9::A table cell item, column 9, right aligned:tr:1::::::1:1:tbl cell c9r:1::tcr9 - Table - Column 9 Cell - Right Aligned:1:12:::::::2::::::::::"),
_T("tcr10::A table cell item, column 10, right aligned:tr:1::::::1:1:tbl cell c10r:1::tcr10 - Table - Column 10 Cell - Right Aligned:1:12:::::::2::::::::::"),
_T("tcr11::A table cell item, column 11, right aligned:tr:1::::::1:1:tbl cell c11r:1::tcr11 - Table - Column 11 Cell - Right Aligned:1:12:::::::2::::::::::"),
_T("tcr12::A table cell item, column 12, right aligned:tr:1::::::1:1:tbl cell c12r:1::tcr12 - Table - Column 12 Cell - Right Aligned:1:12:::::::2::::::::::"),
_T("gm::Glossary main entry:::1::1::1:1:1:glossary main entry:0:1:gm - Glossary main entry:0:12:::::::0::::::_body_text:gp:::"),
_T("gs::Glossary subentry:::1::1::1:1:1:glossary subentry:0:1:gs - Glossary subentry:0:12:::::::0::::::gm:gp:::"),
_T("gd::Glossary definition:::1::1:1:1:1:1:glossary definition:0:1:gd - Glossary definition:1:12:::::::0::::::::::"),
_T("gp::Glossary paragraph:::1::1::1:1:1:glossary paragraph:0:1:gp - Glossary paragraph:0:12:::::::0::::::_body_text:gp:::"),
_T("tis::Topical index heading (level 1):::1::1:::1:1:topical index L1:0:1:tis - Topical index heading L1:0:12:::::::0::::::_heading_base:tpi:::"),
_T("tpi::Topical index heading (level 2):::1::1:::1:1:topical index L2:0:1:tpi - Topical index heading L2:0:12:::::::0::::::tis:tps:::"),
_T("tps::Topical index heading (level 3):::1::1:::1:1:topical index L3:0:1:tps - Topical index heading L3:0:12:::::::0::::::tpi:tir:::"),
_T("tir::Topical index reference:::1::1:::1:1:topical index reference:0:1:tir - Topical index ref:0:12:::::::0::::::_body_text:tir:::"),
_T("w:w*:A wordlist text item:ip im ipi imi ipq imq ipr iq iq1 iq2 iq3 io io1 io2 io3 io4 ms ms1 ms2 s s1 s2 s3 s4 cd sp d lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 tr th1 th2 th3 th4 thr1 thr2 thr3 thr4 tc1 tc2 tc3 tc4 tcr1 tcr2 tcr3 tcr4 f fe ef efe erq esb x ex NEST:1::::1::1:::1::w...w* - Peripheral Ref - Wordlist Entry:1:12:::::::0::::::::::"),
_T("wr:wr*:A Wordlist text item:ms s li li1 li2 li3 li4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr q q1 q2 q3 q4 qc qr tc1 tc2 tc3 tc4 f fe NEST:1::::1::1:::1::OBSOLETE wr...wr* - Auxiliary - Wordlist/Glossary Reference:1:12::1:::::0::::::::::"),
_T("wh:wh*:A Hebrew wordlist text item:ip im ipi imi ipq imq ipr iq iq1 iq2 iq3 io io1 io2 io3 io4 ms ms1 ms2 s s1 s2 s3 s4 cd sp d lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 tr th1 th2 th3 th4 thr1 thr2 thr3 thr4 tc1 tc2 tc3 tc4 tcr1 tcr2 tcr3 tcr4 f fe ef efe erq esb x ex NEST:1::::1::1:::1::wh...wh* - Peripheral Ref - Hebrew Wordlist Entry:1:12:::::::0::::::::::"),
_T("wg:wg*:A Greek Wordlist text item:ip im ipi imi ipq imq ipr iq iq1 iq2 iq3 io io1 io2 io3 io4 ms ms1 ms2 s s1 s2 s3 s4 cd sp d lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 tr th1 th2 th3 th4 thr1 thr2 thr3 thr4 tc1 tc2 tc3 tc4 tcr1 tcr2 tcr3 tcr4 f fe ef efe erq esb x ex NEST:1::::1::1:::1::wg...wg* - Peripheral Ref - Greek Wordlist Entry:1:12:::::::0::::::::::"),
_T("wa:wa*:An Aramaic Wordlist text item:ip im ipi imi ipq imq ipr iq iq1 iq2 iq3 io io1 io2 io3 io4 ms ms1 ms2 s s1 s2 s3 s4 cd sp d lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 tr th1 th2 th3 th4 thr1 thr2 thr3 thr4 tc1 tc2 tc3 tc4 tcr1 tcr2 tcr3 tcr4 f fe ef efe erq esb x ex NEST:1::::1::1:::1::wa...wa* - Peripheral Ref - Aramaic Wordlist Entry:1:12:::::::0::::::::::"),
_T("ndx:ndx*:A subject index text item:ip im ipi imi ipq imq ipr iq iq1 iq2 iq3 io io1 io2 io3 io4 ms ms1 ms2 s s1 s2 s3 s4 cd sp d lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 tr th1 th2 th3 th4 thr1 thr2 thr3 thr4 tc1 tc2 tc3 tc4 tcr1 tcr2 tcr3 tcr4 f fe ef efe erq esb x ex NEST:1::::1::1:::6::ndx...ndx* - Peripheral Ref - Subject Index Entry:1:12:::::::0::::::::::"),
_T("periph::Periheral content division marker which should be followed by an additional division argument/title.::1:::1:::1:1:Periph matter div:0::periph - Peripherals - Content Division Marker:0:14:33023::1::::0:16:4::::_peripherals_base:periph:::"),
_T("p1::Front or back matter text paragraph, level 1 (if multiple levels):id:1:::1::1:1:1:Periph matter para L1:0:1:p1 - Periph - Front/Back Matter Paragraph Level 1:0:12:::::::0:::::.125:_peripherals_base:p1:::"),
_T("p2::Front or back matter text paragraph, level 2 (if multiple levels):id:1:::1::1:1:1:Periph matter para L2:0:1:p2 - Periph - Front/Back Matter Paragraph Level 2:0:12:::::::0:::.125::.125:_peripherals_base:p2:::"),
_T("k1::Concordance main entry text or keyword, level 1:id:1:::1::1:1:1:conc main entry/keyword L1:0:1:k1 - Periph - Concordance Keyword Level 1:0:12:::::::0::::::_peripherals_base:k1:::"),
_T("k2::Concordance main entry text or keyword, level 2:id:1:::1::1:1:1:conc main entry/keyword L2:0:1:k2 - Periph - Concordance Keyword Level 2:0:12:::::::0::::::_peripherals_base:k2:::"),
_T("xtSee:xtSee*:Concordance and Names Index markup for an alternate entry target reference.:p:1:::1:1::1:::0::xtSee - Concordance and Names Index - Alternate Entry Target Reference:1:12:16711680:1:::::0::::::::::"),
_T("xtSeeAlso:xtSeeAlso*:Concordance and Names Index markup for an additional entry target reference.:p:1:::1:1::1:::0::xtSeeAlso - Concordance and Names Index - Additional Entry Target Reference:1:12:16711680:1:::::0::::::::::"),
_T("pub::Front matter publication data:id:1:::1:::1:::0::OBSOLETE pub Peripherals - Front Matter Publication Data:0:10:::::::0::::::_peripherals_base:pub:::"),
_T("toc::Front matter table of contents:id:1:::1:::1:::0::OBSOLETE toc Peripherals - Front Matter Table of Contents:0:10:::::::0::::::_peripherals_base:toc:::"),
_T("toc1::Long table of contents text:h h1 h2 h3 id:1:::1::1:1:1:toc1:0::toc1 - File - Long Table of Contents Text:0:12:16384:1:1::::0::::::_peripherals_base:toc1:::"),
_T("toc2::Short table of contents text:h h1 h2 h3 id:1:::1::1:1:1:toc2:0::toc2 - File - Short Table of Contents Text:0:12:16384:1:::::0::::::_peripherals_base:toc2:::"),
_T("toc3::Book Abbreviation:h h1 h2 h3 id:1:::1::1:1:1:toc3:0::toc3 - File - Book Abbreviation:0:12:128:1:1::::0::::::_peripherals_base:toc3:::"),
_T("toca1::Alternative Language Long Table of Contents Text:h h1 h2 h3:1:::1:::1:::0::toca1 - File - Alternative Language Long Table of Contents Text:0:10:8421504:1:::::0::::::_peripherals_base:toca1:::"),
_T("toca2::Alternative language short table of contents text:h h1 h2 h3:1:::1:::1:::0::toca2 - File - Alternative Language Short Table of Contents Text:0:10:8421504:1:::::0::::::_peripherals_base:toca2:::"),
_T("toca3::Alternative language book Abbreviation:h h1 h2 h3:1:::1:::1:::0::toca3 - File - Alternative Language Book Abbreviation:0:10:8421504:1:::::0::::::_peripherals_base:toca3:::"),
_T("pref::Front matter preface:id:1:::1:::1:::0::OBSOLETE pref Peripherals - Front Matter Preface:0:10:::::::0::::::_peripherals_base:pref:::"),
_T("intro::Front matter introduction:id:1:::1:::1:::0::OBSOLETE intro Peripherals - Front Matter Introduction:0:10:::::::0::::::_peripherals_base:intro:::"),
_T("conc::Back matter concordance:id:1:::1:::1:::0::OBSOLETE conc Peripherals - Back Matter Concordance:0:10:::::::0::::::_peripherals_base:conc:::"),
_T("glo::Back matter glossary:id:1:::1:::1:::0::OBSOLETE glo Peripherals - Back Matter Glossary:0:10:::::::0::::::_peripherals_base:glo:::"),
_T("idx::Back matter index:id:1:::1:::1:::0::OBSOLETE idx Peripherals - Back Matter Index:0:10:::::::0::::::_peripherals_base:idx:::"),
_T("maps::Back matter map index:id:1:::1:::1:::0::OBSOLETE maps Peripherals - Back Matter Map Index:0:10:::::::0::::::_peripherals_base:maps:::"),
_T("cov::Other peripheral materials - cover:id:1:::1:::1:::0::OBSOLETE cov Peripherals - Other - Cover:0:10:::::::0::::::_peripherals_base:cov:::"),
_T("spine::Other peripheral materials - spine:id:1:::1:::1:::0::OBSOLETE spine Peripherals - Other - Spine:0:10:::::::0::::::_peripherals_base:spine:::"),
_T("pubinfo::Publication information - Lang,Credit,Version,Copies,Publisher,Id,Logo:id ide:1:::1:::1:::0::OBSOLETE pubinfo - Publication - Information:0:12:16711680::::::0::::::__normal:pubinfo:::"),
_T("pb::Page Break used for new reader portions and children's bibles where content is controlled by the page:c:1:::1:::1:1:new page:0:1:pb - Break - Page Break:0:12:::::::0::::::p:p:::"),
_T("b::Poetry text stanza break (e.g. stanza break) (basic):c esb ms ms1 ms2 s s1 s2 s3 s4 ip:1:::1:::1:1:stanza break:0::b - Poetry - Stanza Break (Blank Line):0:12:::::::0::::::_body_text:b:::"),
_T("hr::Horizontal rule:::1:1:::1:1:::0::hr - Horizontal rule:8:12:::::::0:4:4::::_body_text:hr:::"),
_T("fig:fig*:Illustration [Columns to span, height, filename, caption text]:lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 sp tr th1 th2 th3 th4 thr1 thr2 thr3 thr4 tc1 tc2 tc3 tc4 tcr1 tcr2 tcr3 tcr4 ms ms1 ms2 s s1 s2 s3 d ip:1::1:1:1:1:1:1:figure:0::fig...fig* - Auxiliary - Figure/Illustration/Map:1:12:::::::0::::::::::"),
_T("jmp:jmp*:For associating linking attributes to a span of text:ip im ipi imi ipq imq ipr iq iq1 iq2 iq3 io io1 io2 io3 io4 ms ms1 ms2 s s1 s2 s3 s4 cd sp d lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 tr th1 th2 th3 th4 thr1 thr2 thr3 thr4 tc1 tc2 tc3 tc4 tcr1 tcr2 tcr3 tcr4 f fe x NEST:1::1:1:1:1:1:1:jump link:0::jmp...jmp* - Link text:1:12:16711680:::1:::0::::::::::"),
_T("rb:rb*:Most often used to provide a reading / pronunciation guide in ideographic scripts:ip im ipi imi ipq imq ipr iq iq1 iq2 iq3 io io1 io2 io3 io4 lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 sp tr th1 th2 th3 th4 thr1 thr2 thr3 thr4 tc1 tc2 tc3 tc4 tcr1 tcr2 tcr3 tcr4 ms ms1 ms2 s s1 s2 s3 d ip f fe NEST:1::::1::1:::1:1:rb...rb* - Special Text - Ruby Glossing:1:12:::::::0::::::::::"),
_T("loc::Picture location:::1:1::::1:::0::loc - Picture location:0:12:::::::0::::::_body_text:loc:::"),
_T("cap::Picture caption:::1:1:1::1:1:1:picture caption:0::cap - Picture caption:0:12:::::::0::::::_body_text:cap:::"),
_T("des::Picture description:::1:1:1:::1:::0::des - Picture description:0:12:::::::0::::::_body_text:des:::"),
_T("px::Paragraph extra 1:::1::1:::1:1:para extra 1:1:1:px - Paragraph extra 1:0:12:::::::0::::::p:px:::"),
_T("pz::Paragraph extra 2:::1::1:::1:1:para extra 2:1:1:pz - Paragraph extra 2:0:12:::::::0::::::p:pz:::"),
_T("qx::Poetry extra 1:::1::1:::1:1:poetry extra 1:2:1:qx - Poetry extra 1:0:12:::::::0::::::q:qx:::"),
_T("qz::Poetry extra 2:::1::1:::1:1:poetry extra 2:2:1:qz - Poetry extra 2:0:12:::::::0::::::q:qz:::"),
_T("addpn:addpn*:For chinese words to be dot underline and underline:ip im ipi imi ipq imq ipr iq iq1 iq2 iq3 io io1 io2 io3 io4 ms ms1 ms2 s s1 s2 s3 s4 cd sp d lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qd qm qm1 qm2 qm3 cls tr th1 th2 th3 th4 thr1 thr2 thr3 thr4 tc1 tc2 tc3 tc4 tcr1 tcr2 tcr3 tcr4 f fe NEST:1::::1::1:::1::DEPRECATED addpn...addpn* - Special Text for Chinese:1:12:2263842:1:1:1:::0::::::::::"),
_T("ef:ef*:A Study Note text item:c lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qm qm1 qm2 qm3 qs sp tc1 tc2 tc3 tc4 mt mt1 mt2 mt3 ms ms1 ms2 ms3 s s1 s2 s3 d ip cp:1::1:1:1:1:1:1:study note text item:34::ef...ef* - Study Note:1:12:::::::0::::::_notes_base:ef:::"),
_T("ex:ex*:List of study Bible extended cross references:c lh li li1 li2 li3 li4 lf lim lim1 lim2 lim3 lim4 m mi nb p pc ph phi pi pi1 pi2 pi3 pr pmo pm pmc pmr po q q1 q2 q3 q4 qc qr qm qm1 qm2 qm3 qs sp tc1 tc2 tc3 tc4 mt mt1 mt2 mt3 ms ms1 ms2 ms3 s s1 s2 s3 d ip cp:1:::1:1:1:1:1:ext xref list:34::ex...ex* - Study - Extended Cross Reference:1:12:::::::0::::::_notes_base:ex:::"),
_T("esb::Study Bible sidebar (mini article):id c:1:::1::1::1:study Bible sidebar:6::esb - Study - Sidebar (Mini Article):0:12:::::::0::::::::::"),
_T("esbe::Study Bible sidebar ending:id c esb:1:::1::1:1:1:study Bible sidebar end:6::esbe - Study - Sidebar Ending:0:12:::::::0::::::::::"),
_T("erq::Study Bible reflective questions:id c:1:::1::1::1:study Bible questions:6::erq - Study - Reflective Questions:0:12:::::::0::::::::::"),
_T("erqe::Study Bible reflective questions ending:id c erq:1:::1::1:1:1:study Bible questions end:6::erqe - Study - Reflective Questions Ending:0:12:::::::0::::::::::"),
_T("efm:efm*:ID or Caller for an extended (study) note. Used within a source project duplicte (target) text when autoring study material.::1::1::1:1:1:::0::efm - Study Note - ID/Caller:1:10:255::1::::0::::::::::"),
_T("cat:cat*:Study note category::1:::1:1:1:1:1:study note cat:0::cat - Study - Note Category:1:14:8388736::::::0::::::_notes_base:cat:::"),
_T("bt::Back-translation (and all \bt... initial forms)::1:1:1:::1::1:back-trans:0::bt - Back-translation:1:11:16711680::::::0::::::::::"),
_T("free:free*:Free translation::1:1:1:::1::1:free-trans:0::free - Free translation:1:11:4194500::::::0::::::::::"),
_T("note:note*:Adapt It note::1:1:1:::1::1:note:0::note - Adapt It note:1:10:16711680::::::0::::::::::"),
_T("__normal::Normal::1:1:1:::::::0::Normal:0:11:::::::0:::::::__normal:::"),
_T("_src_lang_interlinear::Source Language Interlinear Text::1:1:1:::::::0::Source Language:0:11:::::::0::::::__normal:_src_lang_interlinear::1:"),
_T("_tgt_lang_interlinear::Target Language Interlinear Text::1:1:1:::::::0::Target Language:0:11:::::::0::::::__normal:_tgt_lang_interlinear::1:"),
_T("_gls_lang_interlinear::Gloss Language Interlinear Text::1:1:1:::::::0::Gloss Language:0:11:::::::0::::::__normal:_gls_lang_interlinear::1:"),
_T("_nav_lang_interlinear::Navigation Language Interlinear Text::1:1:1:::::::0::Navigation Language:0:11:::::::0::::::__normal:_nav_lang_interlinear::1:"),
_T("_hdr_ftr_interlinear::Header-Footer Interlinear Text::1:1:1:::::::0::Hdr-Ftr Interlinear:7:9:::::::0::::::__normal:_hdr_ftr_interlinear:::"),
_T("_small_para_break::Small Paragraph Break::1:1:1:::::::0::Small Para Break:0:4:::::::0::::::__normal:_small_para_break:::"),
_T("_body_text::Body Text::1:1:1:::::::0::_BodyText_Base:0:11:::::::0::::::_vernacular_base:_body_text:::"),
_T("_heading_base::Heading Base::1:1:1:::1::::0::_Heading_Base:0:12:::::::1:6::.1:.1::_vernacular_base:_heading_base:1:1:"),
_T("_intro_base::Intro Base::1:1:1:::1::::0::_Intro_Base:0:11::1:::::0::::::_vernacular_base:_intro_base:::"),
_T("_list_base::List Base::1:1:1:::1::::0::_List_Base:0:12:::::::0::::::_vernacular_base:_list_base:::"),
_T("_notes_base::Notes Base::1:1:1:::1::::0::_Notes_Base:0:9:::::::0::::::_vernacular_base:_notes_base:::"),
_T("_peripherals_base::Peripherals Base::1:1:1:::1::::0::_Peripherals_Base:0:10:::::::0::::::_vernacular_base:_peripherals_base:::"),
_T("_vernacular_base::Vernacular Base::1:1:1:::::::0::_Vernacular_Base:0:11:::::::0::::::__normal:_vernacular_base:::"),
_T("_annotation_ref::Annotation Reference::1:1:1:::::::0::_annotation_reference:1:10:4210943:::::1:0::::::::::"),
_T("_annotation_text::Annotation Text::1:1:1:::::::0::_annotation_text:0:10:::::::0::::::__normal:_annotation_text:::"),
_T("_dft_para_font::Default Paragraph Font::1:1:1:::::::0::Default Paragraph Font:5:10:::::::0::::::::::"),
_T("_footnote_caller::Footnote Caller::1:1:1:::::::0::Footnote Caller:3:10:16711680:::::1:0::::::::::"),
_T("_normal_table::Normal Table::1:1:1:::::::0::Normal Table:2:10:::::::0:::::::_normal_table:::"),
_T("_table_grid::Table Grid::1:1:1:::::::0::Table Grid:2:10:::::::0::::::_normal_table:_table_grid:::"),
_T("_footer::Footer::1:1:1:::::::0::footer:6:10:::::::0::::::_body_text:_footer:::"),
_T("_header::Header::1:1:1:::::::0::header:7:9:::::::0::::::_body_text:_header:::"),
_T("_horiz_rule::Horizontal Rule::1:1:1:::::::0::Horizontal rule:8:10:::::::0:::::::_horiz_rule:::"),
_T("_single_boxed_para::Single Boxed Paragraph::1:1:1:::::::0::Single Boxed Paragraph:9:10:::::::0::::::__normal:_single_boxed_para:::"),
_T("_double_boxed_para::Double Boxed Paragraph::1:1:1:::::::0::Double Boxed Paragraph:9:10:::::::0::::::__normal:_double_boxed_para:::"),
_T("_unknown_para_style::Unknown Paragraph Style Marker::1:1:1:::::::0::Unknown Para Style Marker:0:12:255::::::0::::::_body_text:_unknown_para_style:::"),
_T("_unknown_char_style::Unknown Character Style Marker::1:1:1:::::::0::Unknown Char Style Marker:1:12:255::::::0::::::::::"),
_T("_hidden_note::Hidden Note::1:1:1:::::::0::Hidden Note:10:10:8388608:1:::::0:2::::.3:p:_hidden_note:::")


    /*
    // Below are the 17Aug2019 strings - created before incorporating the extended markers in Paratext's usfm_sb.sty stylesheet
    // whm 17Aug2019 updated defaultSFM[] array to reflect usfm 3.0.0 additions and changes (now with 317 elements).
    // Note: The previous version had 283 elements and is commented out at end of the block
    _T("id::File identification (BOOKID, FILENAME, EDITOR, MODIFICATION DATE):1:1::::1::1:id:11::id - File - Identification:0:1:65535::::::0::::::__normal:id::1:"),
    _T("ide::File encoding information:1::1::::1:::0::ide - File - Encoding:0:1:65535::::::0::::::__normal:ide::1:"),
    _T("h::Running header text for a book (basic):1:1::1::1:1:1:hdr:10::h - File - Header:0:9:::::::0::::::_vernacular_base:h:::"),
    _T("h1::Running header text:1:::1::1:1:1:hdr:10::DEPRECATED h1 - File - Header:0:9:::::::1::::::h:h1:::"),
    _T("h2::Running header text, left side of page:1:::1::1:1:1:hdr-left:10::DEPRECATED h2 - File - Left Header:0:9:::::::0::::::h1:h2:::"),
    _T("h3::Running header text, right side of page:1:::1::1:1:1:hdr-rght:10::DEPRECATED h3 - File - Right Header:0:9:::::::2::::::h1:h3:::"),
    _T("rem::Comments and remarks:1::1:1::1:1:1:comment:34::rem - File - Remark:0:9:16711680::::::0::::::_notes_base:rem:::"),
    _T("sts::Status of this file:1::1:1::1:1:1:comment:34::rem - File - Status:0:9:16711680::::::0::::::_notes_base:sts:::"),
    _T("restore::Project restore information:1::1::::1:::34::restore - File - Restore Information:0:12:16711680::::::0::::::__normal:restore:::"),
    _T("lit::For a comment or note inserted for liturgical use:1::1:1::1:1:1:lit-note:34::lit - Special Text - Liturgical note:0:12:::1::::2::::::p:lit:1:1:"),
    _T("nt::Note::1:1:1::1:1:1:note:34::nt - Note:0:9:16711680::::::0::::::_notes_base:nt:::"),
    _T("nc::Note centered::1:1:1::1:1:1:note:34::nc - Note centered:0:9:16711680::::::1::::::nt:nc:::"),
    _T("c::Chapter number (basic):1:1:::::1:1::1:1:c - Chapter Number:0:18:::1::::1:8:4::::_heading_base:p:1:1:"),
    _T("ca:ca*:Second (alternate) chapter number (for coding dual versification; useful for places where different traditions of chapter breaks need to be supported in the same translation):1:::1:::1:::1::ca...ca* - Chapter Number - Alternate:1:16:2263842:1:::::0::::::::::"),
    _T("cl::Chapter label used for translations that add a word such as 'Chapter' before chapter numbers (e.g. Psalms). The subsequent text is the chapter label.:1:::1:::1:::1::cl - Chapter - Publishing Label:0:18:::1::::1:8:4::::_heading_base:p:1:1:"),
    _T("cp::Published chapter number (chapter string that should appear in the published text):1:::1:::1:::1::cp - Chapter Number - Publishing Alternate:0:18:16711680::1::::1:8:4::::_heading_base:p:1:1:"),
    _T("cd::Chapter Description (Publishing option D, e.g. in Russian Bibles):1:::1:::1:1:chapter descr:1::cd - Chapter - Description:0:11:::::::0:8:4::::_heading_base:p:1:1:"),
    _T("v::A verse number (basic):1:1:::::1:1::1::v - Verse Number:1:10:16711935::1:::1:0::::::::::"),
    _T("vt::Verse text:1:1:::::1:1::1::vt - Verse text vt:1:12::::::1:0::::::::::"),
    _T("vn::Verse number:1:1:::::1:1::1::vn - Verse number vn:1:10:16711935::1:::1:0::::::::::"),
    _T("va:va*:Second (alternate) verse number (for coding dual numeration in Psalms; see also NRSV Exo 22.1-4):1:::1:1:::::1::va...va* - Verse Number - Alternate:1:10:2263842::1:::1:0::::::::::"),
    _T("vp:vp*:Published verse marker (verse string that should appear in the published text):1:::1:1:::::1::vp...vp* - Verse Number - Publishing Alternate:1:10:16711680::1:::1:0::::::::::"),
    _T("mt::The main title of the book (if single level):1:1::1::1:1:1:main title:4:1:mt - Title - Major Title Level 1:0:20:::1::::1:8:4::::_heading_base:c:1:1:"),
    _T("mt1::The main title of the book (if multiple levels) (basic):1:::1::1:1:1:main title L1:4:1:mt1 - Title - Major Title Level 1:0:20:::1::::1:2:4::::_heading_base:c:1:1:"),
    _T("mt2::A secondary title usually occurring before the main title (basic):1:::1::1:1:1:secondary title L2:5:1:mt2 - Title - Major Title Level 2:0:16::1:::::1::2::::_heading_base:mt:1:1:"),
    _T("mt3::A secondary title occurring after the main title:1:::1::1:1:1:secondary title L3:5:1:mt3 - Title - Major Title Level 3:0:14:::1::::1:2:2::::_heading_base:c:1:1:"),
    _T("mt4::A small secondary title sometimes occuring within parentheses:1:::1::1:1:1:secondary title L4:5:1:mt4 - Title - Major Title level 4:0:12:::::::1:2:2::::_heading_base:c:1:1:"),
    _T("st::Secondary title::1::1::1:1:1:secondary title:5:1:st - Secondary title:0:16:::1::::1::2::::_heading_base:mt:1:1:"),
    _T("mte::The main title of the book repeated at the end of the book (if single level):1:::1::1:1:1:main title at end:4:1:mte - Title - [Uncommon] Major Title Ending Level 1:0:20:::1::::1:8:4::::_heading_base::1::"),
    _T("mte1::The main title of the book repeated at the end of the book (if multiple levels):1:::1::1:1:1:main title at end L1:4:1:mte1 - Title - [Uncommon] Major Title Ending Level 1:0:20:::1::::1:8:4::::_heading_base::1::"),
    _T("mte2::A secondary title occurring before or after the 'ending' main title:1:::1::1:1:1:secondary title at end L2:5:1:mte2 - Title - [Uncommon] Major Title Ending Level 2:0:16::1:::::1::2::::_heading_base::1::"),
    _T("div::Division heading::1::1::1:1:1:division head:3:1:div - Division heading:0:16:::1::::1:6:3::::s:dvrf:1:1:"),
    _T("bn::Psalms book number::1::1::1:1:1:Psalm book number:0:1:bn - Psalms book number:0:11:::1::::1:6:3::::s:br:1:1:"),
    _T("ms::A major section division heading, level 1 (if single level) (basic):1:::1::1:1:1:major sect head:3:1:ms - Heading - Major Section Level 1:0:14:::1::::1:16:4::::_heading_base:mr:1:1:"),
    _T("ms1::A major section division heading, level 1 (if multiple levels):1:::1::1:1:1:major sect head L1:3:1:ms1 - Heading - Major Section Level 1:0:14:::1::::1:16:4::::_heading_base:mr:1:1:"),
    _T("ms2::A major section division heading, level 2:1:::1::1:1:1:major sect head L2:3:1:ms2 - Heading - Major Section Level 2:0:14:::1::::1:16:4::::_heading_base:mr:1:1:"),
    _T("ms3::A major section division heading, level 3:1:::1::1:1:1:major sect head L3:3:1:ms3 - Heading - Major Section Level 3:0:14::1:::::1:16:4::::_heading_base:mr:1:1:"),
    _T("s::A section heading, level 1 (if single level) (basic):1:1::1::1:1:1:sect head:3:1:s - Heading - Section Level 1:0:12:::1::::1:8:4::::_heading_base:p:1:1:"),
    _T("s1::A section heading, level 1 (if multiple levels):1:::1::1:1:1:sect head L1:3:1:s1 - Heading - Section Level 1:0:12:::1::::1:8:4::::_heading_base:p:1:1:"),
    _T("s2::A section heading, level 2 (e.g. Proverbs 22-24):1:::1::1:1:1:sect head L2:3:1:s2 - Heading - Section Level 2:0:12::1:::::1:8:4::::_heading_base:p:1:1:"),
    _T("s3::A section heading, level 3 (e.g. Genesis 'The First Day'):1:::1::1:1:1:sect head L3:3:1:s3 - Heading - Section Level 3:0:12::1:::::0:6:3::::_heading_base:p:1:1:"),
    _T("s4::A section heading, level 4:1:::1::1:1:1:sect head L4:3:1:s4 - Heading - Section Level 4:0:12::1:::::0:6:3::::_heading_base:p:1:1:"),
    _T("sr::A section division references range heading:1:::1::1:1:1:sect head range refs:3:1:sr - Heading - Section Range References:0:12:::1::::1::4::::_heading_base:p:1:1:"),
    _T("sx::Extra heading 1::1::1::1:1:1:sect head extra 1:3:1:sx - Extra heading 1:0:12:::1::::1:6:3::::_heading_base:p:1:1:"),
    _T("sz::Extra heading 2::1::1::1:1:1:sect head extra 2:3:1:sz - Extra heading 2:0:12::1:::::1:6:3::::_heading_base:p:1:1:"),
    _T("sp::A heading, to identify the speaker (e.g. Job):1:1::1::1:1:1:speaker:0:1:sp - Label - Speaker:0:12::1:::::0:8:4::::_heading_base:q:1:1:"),
    _T("d::A Hebrew text heading, to provide description (e.g. Psalms):1:::::1:1:1:descr title:1:1:d - Label - Descriptive Title - Hebrew Subtitle:0:12::1:::::1:4:4::::_heading_base:q:1:1:"),
    _T("sd::Vertical space used to divide the text into sections, level 1 (if single level):1::1:::1:1:::6:1:sd - Label - Semantic Division Location - Level 1:0:12:::::::1:24:24::::_heading_base:sd:1::"),
    _T("sd1::Vertical space used to divide the text into sections, level 1 (if single level):1::1:::1:1:::6:1:sd1 - Label - Semantic Division Location - Level 1:0:12:::::::1:24:24::::_heading_base:sd1:1::"),
    _T("sd2::Vertical space used to divide the text into sections, level 2:1::1:::1:1:::6:1:sd2 - Label - Semantic Division Location - Level 2:0:12:::::::1:18:18::::_heading_base:sd2:1::"),
    _T("sd3::Vertical space used to divide the text into sections, level 3:1::1:::1:1:::6:1:sd2 - Label - Semantic Division Location - Level 3:0:12:::::::1:12:12::::_heading_base:sd3:1::"),
    _T("sd4::Vertical space used to divide the text into sections, level 4:1::1:::1:1:::6:1:sd2 - Label - Semantic Division Location - Level 4:0:12:::::::1:8:8::::_heading_base:sd4:1::"),
    _T("di::Descriptive title (Hebrew subtitle)::1::::1:1:1:descr title:1:1:di - Descr title or Heb subtitle di:0:12::1:::::1:4:4::::_heading_base:q:1:1:"),
    _T("hl::Hebrew letter::1:::::1:::0::hl - Hebrew letter:0:12:::::::1:4:4::::_heading_base:q:1:1:"),
    _T("r::Parallel reference(s) (basic):1:1:1:1::1:1:1:ref:33::r - Heading - Parallel References:0:12::1:::::1::4::::_heading_base:p:1:1:"),
    _T("dvrf::Division reference::1:1:1::1::1:div-ref:0::dvrf - Division ref:0:12::1:::::1::3::::_heading_base:p:1:1:"),
    _T("mr::A major section division references range heading (basic):1::1:1::1::1:mjr-sect-refs:0::mr - Heading - Major Section Range References:0:12::1:::::1::4::::ms:p:1:1:"),
    _T("br::Psalms book reference::1:1:1::1::1:Ps-bk-ref:0::br - Psalms book ref:0:12::1:::::1::4::::r:c:1:1:"),
    _T("x:x*:A list of cross references (basic):1::1:1:1:1:1:1:x-refs:33::x...x* - Cross Reference:4:10:::::::0::::::_notes_base:x:::"),
    _T("xo:xo*:The cross reference origin reference (basic):1::1::1:1::1:origin-ref:33::xo - Cross Reference - Origin Reference:1:10:::1::::0::::::::::"),
    _T("xop:xop*:Published cross reference origin reference (origin reference that should appear in the published text):1::1::1:1::1:origin-ref:33::xop - Cross Reference - Origin Reference Publishing Alternate:1:10:::::::0::::::::::"),
    _T("xt:xt*:The cross reference target reference(s), protocanon only (basic):1::1::1:1::1:tgt-ref:33::xt - Cross Reference - Target References:1:10:::::::0::::::::::"),
    _T("xta:xta*:Cross reference target references added text:1::1::1:1::1:tgt-ref:33::xta - Cross Reference - Target References Added Text:1:10:::::::0::::::::::"),
    _T("xk:xk*:A cross reference keyword:1::1::1:1::1:keyword:33::xk - Cross Reference - Keyword:1:10::1:::::0::::::::::"),
    _T("xq:xq*:A cross-reference quotation from the scripture text:1::1::1:1::1:quote:33::xq - Cross Reference - Quotation:1:10::1:::::0::::::::::"),
    _T("xot:xot*:Cross-reference target reference(s), Old Testament only:1::1::1:1::1:OldT-ref:33::xot...xot* - Cross Reference - OT Target Refs (optional):1:12:::::::0::::::::::"),
    _T("xnt:xnt*:Cross-reference target reference(s), New Testament only:1::1::1:1::1:NewT-ref:33::xnt...xnt* - Cross Reference - NT Target Refs (optional):1:12:::::::0::::::::::"),
    _T("xdc:xdc*:Cross-reference target reference(s), Deuterocanon only:1::1::1:1::1:deut-canon-ref:33::DEPRECATED xdc...xdc* - Cross Reference - DC Target Refs:1:10:::::::0::::::::::"),
    _T("rr::Right margin reference::1:1:1::1::1:rt-marg-ref:32::rr - Right margin ref:0:9::1:::::2::::::qr:rr:::"),
    _T("rq:rq*:A cross-reference indicating the source text for the preceding quotation:1::1:1::1::1:x-ref to source:32::rq...rq* - Cross Reference - Inline Quotation References:1:10::1:::::2::::::::::"),
    _T("@::Cross reference, origin reference::1:1:1::1::1:x-refs orig:33::@ - Cross ref origin ref:1:10:::1::::0::::::::::"),
    _T("xr::Cross reference target references::1:1:1::1::1:x-refs tgt:33::xr - Cross ref target ref:1:10:::::::0::::::::::"),
    _T("p::Paragraph text, with first line indent (basic):1:1:::::1:1:paragraph:1:1:p - Paragraph - Normal - First Line Indent:0:12:::::::0:::::.125:_body_text:p:::"),
    _T("pi::Paragraph text, level 1 indent (if sinlge level), with first line indent; often used for discourse (basic):1:1:::::1:1:para indented:1:1:pi - Paragraph - Indented - Level 1 - First Line Indent:0:12:::::::0:::.25:.25:.125:p:pi:::"),
    _T("pi1::Paragraph text, level 1 indent (if multiple levels), with first line indent; often used for discourse:1::::::1:1:para indented L1:1:1:pi1 - Paragraph - Indented - Level 1 - First Line Indent:0:12:::::::0:::.25:.25:.125:pi:pi1:::"),
    _T("pi2::Paragraph text, level 2 indent, with first line indent; often used for discourse:1::::::1:1:para indented L2:1:1:pi2 - Paragraph - Indented - Level 2 - First Line Indent:0:12:::::::0:::.5:.25:.125:pi1:pi2:::"),
    _T("pi3::Paragraph text, level 3 indent, with first line indent; often used for discourse:1::::::1:1:para indented L3:1:1:pi3 - Paragraph - Indented - Level 3 - First Line Indent:0:12:::::::0:::.75:.25:.125:pi2:pi3:::"),
    _T("pgi::Indented paragraph::1:::::1:1:para indented:1:1:pgi - Indented paragraph:0:12:::::::0:::.25:.25:.125:p:pgi:::"),
    _T("ph::Paragraph text, with level 1 hanging indent (if single level):1::::::1:1:para hang indent:1:1:DEPRECATED ph - Paragraph - Hanging Indent - Level 1:0:12:::::::0:::.5::-.25:_body_text:ph:::"),
    _T("ph1::Paragraph text, with level 1 hanging indent (if multiple levels):1::::::1:1:para hang indent L1:1:1:DEPRECATED ph1 - Paragraph - Hanging Indent - Level 1:0:12:::::::0:::.5::-.25:ph:ph1:::"),
    _T("ph2::Paragraph text, with level 2 hanging indent:1::::::1:1:para hang indent L2:1:1:DEPRECATED ph2 - Paragraph - Hanging Indent - Level 2:0:12:::::::0:::.75::-.25:ph1:ph2:::"),
    _T("ph3::Paragraph text, with level 3 hanging indent:1::::::1:1:para hang indent L3:1:1:DEPRECATED ph3 - Paragraph - Hanging Indent - Level 3:0:12:::::::0:::1::-.25:ph2:ph3:::"),
    _T("phi::Paragraph text, indented with hanging indent:1::::::1:1:para indent hang indent:1:1:DEPRECATED phi - Paragraph - Indented - Hanging Indent:0:12:::::::0:::1:::_body_text:phi:::"),
    _T("m::Paragraph text, with no first line indent (may occur after poetry) (basic):1:1:::::1:1:paragraph margin:1:1:m - Paragraph - Margin - No First Line Indent:0:12:::::::0::::::p:m:::"),
    _T("po::Letter opening:1:1:::::1:1:paragraph:1:1:po - Paragraph - Letter Opening:0:12:::::::0:4:4:::.125:_body_text:po:::"),
    _T("pr::Text refrain (paragraph text, right aligned):1:1:::::1:1:paragraph:1:1:pr - Paragraph - Text Refrain (right aligned):0:12:::::::2:::::.125:_body_text:pr:::"),
    _T("pmo::Embedded text opening:1::::::1:1:para embedded text opening:1:1:pmo - Paragraph - Embedded Text Opening:0:12:::::::0:::.25:.25::pm:pm:::"),
    _T("mi::Paragraph text, indented, with no first line indent; often used for discourse:1:1:::::1:1:para indent no 1st line indent:1:1:mi - Paragraph - Indented - No First Line Indent:0:12:::::::0:::.25:.25::pi:mi:::"),
    _T("pc::Paragraph spanning chapters::1:::::1:1:para spans chapters:1:1:pc - Paragraph spanning chapters:0:12:::::::0::::::m:pc:::"),
    _T("pc::Paragraph text, centered (for Inscription):1::::::1:1:para centered inscription:1:1:pc - Paragraph - Centered (for Inscription):0:12:::::::1::::::_body_text:pc:::"),
    _T("pt::Preface title::1::1::1:1:1:preface title:0:1:pt - Preface title:0:14:::1::::1::6::::_heading_base:pp:1:1:"),
    _T("ps::Preface section heading::1::1::1:1:1:preface sect head:0:1:ps - Preface sect heading:0:12:::1::::1:4:2::::s:pp:1:1:"),
    _T("ps::Paragraph text, no break with next paragraph text at chapter boundary:1::::::1:1:para spans chapters:1:1:OBSOLETE ps - Paragraph - No Break with Next Paragraph:0:12:::::::0::::::m:ps:::"),
    _T("psi::Paragraph text, indented, with no break with next paragraph text (at chapter boundary):1::::::1:1:para spans chapters indent:1:1:OBSOLETE psi - Paragraph - Indented - No Break with Next:0:12:::::::0:::.25:.25:.125:pi:pi:::"),
    _T("pp::Preface paragraph::1::1::1:1:1:preface paragraph:0:1:pp - Preface paragraph:0:10:::::::0:::::.125:p:pp:::"),
    _T("pq::Preface poetry::1::1::1:1:1:preface poetry:0:1:pq - Preface poetry:0:10:::::::0:::.5:::q:pq:::"),
    _T("pm::Preface continue at margin::1::1::1:1:1:preface at margin:0:1:pm - Preface continue at margin:0:10:::::::0::::::m:pm:::"),
    _T("pm::Embedded text paragraph:1:::::1:1:1:paragraph embedded text:1:1:pm - Paragraph - Embedded Text:0:12:::::::0:::.25:.25:.125:p:pm:::"),
    _T("pmc::Embedded text closing:1:::::1:1:1:para embedded text closing:1:1:pmc - Paragraph - Embedded Text Closing:0:12:::::::0:::.25:.25::pm:pmc:::"),
    _T("pmr::Embedded text refrain (e.g. Then all the people shall say, 'Amen!'):1:::::1:1:1:para embedded text refrain:1:1:pmr - Paragraph - Embedded Text Refrain:0:12:::::::2:::.25:.25::pm:p:::"),
    _T("nb::Paragraph text, with no break from previous paragraph text (at chapter boundary) (basic):1::::::1:1:para no break:1:1:nb - Paragraph - No Break with Previous Paragraph:0:12:::::::0::::::m:p:::"),
    _T("cls::Letter Closing:1::::::1:1:Letter closing:1::cls - Paragraph - Letter Closing:0:12:::::::2::::::p:cls:1::"),
    _T("q::Poetry text, level 1 indent (if single level):1:1:::::1:1:poetry:2:1:q - Poetry - Indent Level 1 - Single Level Only:0:12:::::::0:::1.25::-1:_body_text:q:::"),
    _T("q1::Poetry text, level 1 indent (if multiple levels) (basic):1::::::1:1:poetry L1:2:1:q1 - Poetry - Indent Level 1:0:12:::::::0:::1.25::-1:q:q1:::"),
    _T("q2::Poetry text, level 2 indent (basic):1:1:::::1:1:poetry L2:2:1:q2 - Poetry - Indent Level 2:0:12:::::::0:::1.25::-.75:q:q2:::"),
    _T("q3::Poetry text, level 3 indent:1:1:::::1:1:poetry L3:2:1:q3 - Poetry - Indent Level 3:0:12:::::::0:::1.25::-.5:q2:q3:::"),
    _T("q4::Poetry text, level 4 indent:1:1:::::1:1:poetry L3:2:1:q4 - Poetry - Indent Level 4:0:12:::::::0:::1.25::-.25:q3:q4:::"),
    _T("qc::Poetry text, centered:1:1:::::1:1:poetry centered:2:1:qc - Poetry - Centered:0:12:::::::1::::::q:qc:::"),
    _T("qr::Poetry text, Right Aligned:1:1:::::1:1:poetry right margin:2:1:qr - Poetry - Right Aligned:0:12:::::::2::::::q:qr:::"),
    _T("qa::Poetry text, Acrostic marker/heading:1:::1:::1:1:acrostic hdg:2:1:qa - Poetry - Acrostic Heading/Marker:0:12::1:::::0::::::_heading_base:q:1:1:"),
    _T("qac:qac*:Poetry text, Acrostic markup of the first character of a line of acrostic poetry:1::::1::1:::2::qac...qac* - Poetry Text - Acrostic Letter:1:12::1:::::0::::::::::"),
    _T("qs:qs*:Poetry text, Selah:1::::1::1:::1::qs...qs* - Poetry Text - Selah:1:12::1:::::0::::::::::"),
    _T("qm::Poetry, left margin::1:::::1:1:poetry margin:2:1:qm - Poetry left margin:0:12:::::::0::::::q:qm:::"),
    _T("qm::Poetry text, embedded, level 1 indent (if single level):1::::::1:1:poetry embed:2:1:qm - Poetry - Embedded Text - Indent Level 1 - Single Level Only:0:12:::::::0:::1::-.75:q:qm:::"),
    _T("qm1::Poetry text, embedded, level 1 indent (if multiple levels):1::::::1:1:poetry embed L1:2:1:qm1 - Poetry - Embedded Text - Indent Level 1:0:12:::::::0:::1::-.75:qm:qm1:::"),
    _T("qm2::Poetry text, embedded, level 2 indent:1::::::1:1:poetry embed L2:2:1:qm2 - Poetry - Embedded Text - Indent Level 2:0:12:::::::0:::1::-.5:qm1:qm2:::"),
    _T("qm3::Poetry text, embedded, level 3 indent:1::::::1:1:poetry embed L3:2:1:qm3 - Poetry - Embedded Text - Indent Level 3:0:12:::::::0:::1::-.25:qm2:qm3:::"),
    _T("qd::A Hebrew musical performance annotation, similar in content to Hebrew descriptive title.:1::::::1:1:Hebrew note:2:1:qd - Poetry - Hebrew Note:0:12::1:::::0:::.25:::q:qd:1:1:"),
    _T("f:f*:A Footnote text item (basic):1:1::1:1:1:1:1:footnote:9::f...f* - Footnote:4:10:::::::0::::::_notes_base:f:::"),
    _T("fe::Footnote (end)::1:::::1:::1::fe - Footnote end PNG:1:10:::::::0::::::::::"),
    _T("fe:fe*:An Endnote text item:1:::1:1:1:1:1:endnote:9::fe...fe* - Endnote:4:10:::::::0::::::_notes_base:fe:::"),
    _T("fr:fr*:The origin reference for the footnote (basic):1::::1:1:1:1:ref:9::fr - Footnote - Reference:1:10:::1::::0::::::::::"),
    _T("fk:fk*:A footnote keyword (basic):1::::1:1:1:1:keyword:9::fk - Footnote - Keyword:1:10::1:1::::0::::::::::"),
    _T("fq:fq*:A footnote scripture quote or alternate rendering (basic):1::::1:1:1:1:quote:9::fq - Footnote - Quotation or Alternate Rendering:1:10::1:::::0::::::::::"),
    _T("fqa:fqa*:A footnote alternate rendering for a portion of scripture text:1::::1:1:1:1:alt-transln:9::fqa - Footnote - Alternate Translation Rendering:1:10::1:::::0::::::::::"),
    _T("fl:fl*:A footnote label text item, for marking or 'labelling' the type or alternate translation being provided in the note.:1::::1:1:1:1:label:9::fl - Footnote - Label Text:1:10::1:1::::0::::::::::"),
    _T("fw:fw*:A footnote witness list, for distinguishing a list of sigla representing witnesses in critical editions.:1::::1:1:1:1:witness list:9::fw - Footnote - Witness List:1:12:::::::0::::::::::"),
    _T("fp:fp*:A Footnote additional paragraph marker:1::::1:1:1:1:new-paragr:9::fp - Footnote Paragraph Mark:1:10:::::::0::::::::::"),
    _T("ft:ft*:Footnote text, Protocanon (basic):1::::1:1:1:1:fn-text:9::ft - Footnote - Text:1:10:::::::0::::::::::"),
    _T("fdc:fdc*:Footnote text, applies to Deuterocanon only:1::::1:1:1:1:deut-canon:9::DEPRECATED fdc...fdc* - Footnote - DC text:1:10:::::::0::::::::::"),
    _T("fv:fv*:A verse number within the footnote text:1::::1:1::1:verse#:9::fv...fv* - Footnote - Embedded Verse Number:1:10:::1:::1:0::::::::::"),
    _T("fm:fm*:An additional footnote marker location for a previous footnote:1::::1:1::1:call-prev:9::fm - Footnote - Additional Caller to Previous Note:1:10::::::1:0::::::::::"),
    _T("F::Footnote (end)::1:::::1:::1::F - Footnote end PNG:1:10:::::::0::::::::::"),
    _T("qt:qt*:For Old Testament quoted text appearing in the New Testament (basic):1::::1::1:1:Quotation:1::qt...qt* - Special Text - Quoted Text - OT in NT:1:12::1:::::0::::::::::"),
    _T("nd:nd*:For name of deity (basic):1::::1:::::1::nd...nd* - Special Text - Name of Deity:1:12::::1:::0::::::::::"),
    _T("tl:tl*:For transliterated words:1::::1:::::1::tl...tl* - Special Text - Transliterated Word:1:12::1:::::0::::::::::"),
    _T("dc:dc*:Deuterocanonical/LXX additions or insertions in the Protocanonical text:1::::1:::::1::dc...dc* - Special Text - Deuterocanonical/LXX Additions:1:12::1:::::0::::::::::"),
    _T("bk:bk*:For the quoted name of a book:1::::1:::::1::bk...bk* - Special Text - Quoted book title:1:12::1:::::0::::::::::"),
    _T("sig:sig*:For the signature of the author of an Epistle:1::::1:::::1::sig...sig* - Special Text - Author's Signature (Epistles):1:12::1:::::0::::::::::"),
    _T("pn:pn*:For a proper name:1::::1:::::1::pn...pn* - Special Text - Proper Name:1:12:::1:1:::0::::::::::"),
    _T("png:png*:For a geographic proper name:1::::1:::::1::png...png* - Special Text - Geographic Proper Name:1:12::::1:::0::::::::::"),
    _T("wj:wj*:For marking the words of Jesus:1::::1:::::1::wj...wj* - Special Text - Words of Jesus:1:12:255::::::0::::::::::"),
    _T("k:k*:For a keyword:1::::1:::::1::k...k* - Special Text - Keyword:1:12::1:1::::0::::::::::"),
    _T("sls:sls*:To represent where the original text is in a secondary language or from an alternate text source:1::::1:::::1::sls...sls* - Special Text - Secondary Language or Text Source:1:12::1:::::0::::::::::"),
    _T("ord:ord*:For the text portion of an ordinal number:1::::1:::::1::ord...ord* - Special Text - Ordinal number text portion:1:12::::::1:0::::::::::"),
    _T("add:add*:For a translational addition to the text:1::::1:1:1:1:addl material:1::add...add* - Special Text - Translational Addition:1:12:2263842:1:1::::0::::::::::"),
    _T("no:no*:A character style, use normal text:1::::1:::::1::no...no* - Character - Normal Text:1:12:::::::0::::::::::"),
    _T("bd:bd*:A character style, use bold text:1::::1:::::1::bd...bd* - Character - Bold Text:1:12:::1::::0::::::::::"),
    _T("it:it*:A character style, use italic text:1::::1:::::1::it...it* - Character - Italic Text:1:12::1:::::0::::::::::"),
    _T("bdit:bdit*:A character style, use bold + italic text:1::::1:::::1::bdit...bdit* - Character - BoldItalic Text:1:12::1:1::::0::::::::::"),
    _T("em:em*:A character style, use emphasized text style:1::::1:::::1::em...em* - Character - Emphasized Text:1:12::1:::::0::::::::::"),
    _T("sc:sc*:A character style, for small capitalization text:1::::1:::::1::sc...sc* - Character - Small Caps:1:12:::::1::0::::::::::"),
    _T("sup:sup*:A character style, for superscript text. Typically for use in critical edition footnotes.:1::::1:::::6::sup...sup* - Character - Superscript:1:10::::::1:0::::::::::"),
    _T("pro:pro*:For indicating pronunciation in CJK texts:1::1:1:1:::::6::DEPRECATED pro...pro* - Special Text - CJK Pronunciation:1:10:::::::0::::::::::"),
    _T("imt::Introduction main title, level 1 (if single level) (basic):1:::1::1:1:1:intro main title:0:1:imt - Introduction - Major Title Level 1:0:14:::1::::1:8:4::::_intro_base:ip:1:1:"),
    _T("imt1::Introduction major title, level 1 (if multiple levels):1:::1::1:1:1:intro major title L1:0:1:imt1 - Introduction - Major Title Level 1:0:14:::1::::1:8:4::::imt:ip:1:1:"),
    _T("imt2::Introduction major title, level 2:1:::1::1:1:1:intro major title L2:0:1:imt2 - Introduction - Major Title Level 2:0:13::1:::::1:6:3::::imt1:ip:1:1:"),
    _T("imt3::Introduction major title, level 3:1:::1::1:1:1:intro major title L3:0:1:imt3 - Introduction - Major Title Level 3:0:12:::1::::1:2:2::::imt2:ip:1:1:"),
    _T("imt4::Introduction major title, level 4 (usually within parenthesis):1:::1::1:1:1:intro major title L4:0:1:imt4 - Introduction - Major Title Level 4:0:12::1:::::1:2:2::::imt3:ip:1:1:"),
    _T("imte::Introduction major title at introduction end, level 1 (if single level):1:::1::1:1:1:intro major title at end:0:1:imte - Introduction - [Uncommon] Major Title at Introduction End Level 1:0:20:::1::::1:8:4::::imt:ie:::"),
    _T("imte1::Introduction major title at introduction end, level 1 (if multiple levels):1:::1::1:1:1:intro major title at end:0:1:imte1 - Introduction - [Uncommon] Major Title at Introduction End Level 1:0:20:::1::::1:8:4::::imt:ie:::"),
    _T("imte2::Introduction major title at introduction end, level 2:1:::1::1:1:1:intro major title at end:0:1:imte2 - Introduction - [Uncommon] Major Title at Introduction End Level 2:0:16::1:::::1:8:4::::imt:ie:::"),
    _T("is::Introduction section heading, level 1 (if single level) (basic):1:1::1::1:1:1:intro sect head:0:1:is - Introduction - Section Heading Level 1:0:12:::1::::1:8:4::::s:ip:1:1:"),
    _T("is1::Introduction section heading, level 1 (if multiple levels):1:::1::1:1:1:intro sect head L1:0:1:is1 - Introduction - Section Heading Level 1:0:12:::1::::1:8:4::::is:ip:1:1:"),
    _T("is2::Introduction section heading, level 2:1:::1::1:1:1:intro sect head L2:0:1:is2 - Introduction - Section Heading Level 2:0:12:::1::::1:8:4::::is1:ip:1:1:"),
    _T("ip::Introduction prose paragraph (basic):1:1::1::1:1:1:intro paragraph:0:1:ip - Introduction - Paragraph:0:10:::::::0:::::.125:_intro_base:ip:::"),
    _T("ipi::Introduction prose paragraph, indented, with first line indent:1:1::1::1:1:1:intro paragraph indented:0:1:ipi - Introduction - Indented Para - first line indent:0:10:::::::0:::.25:.25:.125:ip:ipi:::"),
    _T("ipq::Introduction prose paragraph, quote from the body text:1:::1::1:1:1:intro para quote:0:1:ipq - Introduction - Paragraph - quote from text:0:10::1:::::0:::.25:.25:.125:ip:ipq:::"),
    _T("ipr::Introduction prose paragraph, right aligned:1:::1::1:1:1:intro para right align:0:1:ipr - Introduction - Paragraph - right aligned:0:10::1:::::2:::.25:.25::ip:ipr:::"),
    _T("iq::Introduction poetry text, level 1 (if single level):1:1::1::1:1:1:intro poetry:0:1:iq - Introduction - Poetry Level 1:0:10::1:::::0:::1::-.75:ip:iq:::"),
    _T("iq1::Introduction poetry text, level 1 (if multiple levels):1:::1::1:1:1:intro poetry L1:0:1:iq1 - Introduction - Poetry Level 1:0:10::1:::::0:::1::-.75:iq:iq1:::"),
    _T("iq2::Introduction poetry text, level 2:1:1::1::1:1:1:intro poetry L2:0:1:iq2 - Introduction - Poetry Level 2:0:10::1:::::0:::1::-.5:iq:iq2:::"),
    _T("iq3::Introduction poetry text, level 3:1:::1::1:1:1:intro poetry L3:0:1:iq3 - Introduction - Poetry Level 3:0:10::1:::::0:::1::-.25:iq:iq3:::"),
    _T("im::Introduction prose paragraph, with no first line indent (may occur after poetry):1:1::1::1:1:1:intro para no indent:0:1:im - Introduction - Paragraph - no first line indent:0:10:::::::0::::::ip:im:::"),
    _T("imi::Introduction prose paragraph text, indented, with no first line indent:1:1::1::1:1:1:intro para no indent:0:1:imi - Introduction - Indented Para - no first line indent:0:10:::::::0:::.25:.25::ipi:imi:::"),
    _T("ili::A list entry, level 1 (if single level):1:::1::1:1:1:intro list L1:0:1:ili - Introduction - List Entry - Level 1:0:12:::::::0:::.625::-.375:_list_base:ili:::"),
    _T("ili1::A list entry, level 1 (if multiple levels):1:::1::1:1:1:intro list L1:0:1:ili1 - Introduction - List Entry - Level 1:0:12:::::::0:::.5::-.25:ili:ili1:::"),
    _T("ili2::A list entry, level 2:1:::1::1:1:1:intro list L2:0:1:ili2 - Introduction - List Entry - Level 2:0:12:::::::0:::.75::-.25:ili1:ili2:::"),
    _T("imq::Introduction prose paragraph, quote from the body text, with no first line indent:1:::1::1:1:1:intro para quote no indent:0:1:imq - Introduction - Paragraph - quote from text - no first line indent:0:10::1:::::0:::.25:.25::imi:imq:::"),
    _T("ib::Introduction blank line:1::1:1::1::::0:1:ib - Introduction - Blank Line:0:12:::::::0::::::_intro_base:ib:::"),
    _T("iot::Introduction outline title (basic):1:::1::1:1:1:intro outline title:0:1:iot - Introduction - Outline Title:0:12:::1::::1:8:4::::imt:io1:1:1:"),
    _T("io::Introduction outline text, level 1 (if single level):1:1::1::1:1:1:intro outline:0:1:io - Introduction - Outline Level 1:0:10:::::::0:::.5:::_intro_base:io:::"),
    _T("io1::Introduction outline text, level 1 (if multiple levels) (basic):1:1::1::1:1:1:intro outline L1:0:1:io1 - Introduction - Outline Level 1:0:10:::::::0:::.5:::io:io1:::"),
    _T("io2::Introduction outline text, level 2:1:1::1::1:1:1:intro outline L2:0:1:io2 - Introduction - Outline Level 2:0:10:::::::0:::.75:::io1:io2:::"),
    _T("io3::Introduction outline text, level 3:1:1::1::1:1:1:intro outline L3:0:1:io3 - Introduction - Outline Level 3:0:10:::::::0:::1:::io2:io3:::"),
    _T("io4::Introduction outline text, level 4:1:1::1::1:1:1:intro outline L4:0:1:io4 - Introduction - Outline Level 4:0:10:::::::0:::1.25:::io3:io4:::"),
    _T("ior:ior*:Introduction references range for outline entry; for marking references separately:1:::1:1:1::::6::ior...ior* - Introduction - Outline References Range:1:10:::::::0::::::::::"),
    _T("iex::Introduction explanatory or bridge text (e.g. explanation of missing book in Short Old Testament):1:::1::1:1:1:intro explain text:0:1:iex - Introduction - Explanatory or Bridge Text:0:10:::::::0:4:4:::.125:ip:iex:::"),
    _T("iqt:iqt*:For quoted scripture text appearing in the introduction:1:::1:1:1::::6::iqt...iqt* - Special Text - Quoted Scripture Text in Introduction:1:12::1:::::0::::::::::"),
    _T("ie::Introduction ending marker:1::1:::1:1:::0::ie - Introduction - End Marker:8:12:::::::0:12:4:1.5:1.5::_intro_base:ie:::"),
    _T("li::A list entry, level 1 (if single level):1::::::1:1:list item:1:1:li - List Entry - Level 1:0:12:::::::0:::.625::-.375:_list_base:li:::"),
    _T("lh::List header (introductory remark):1::::::1:1:list header:1:1:lh - List Header:0:12:::::::0:::::.125:_list_base:lh:1:1:"),
    _T("lf::List footer (concluding remark):1::::::1:1:list footer:1:1:lf - List Footer:0:12:::::::0::::::_list_base:lf:::"),
    _T("lim::An embedded list entry, level 1 (if single level):1::::::1:1:embedded list item:1:1:lim - Embedded List Entry - Level 1:0:12:::::::0:::.75::-.375:_list_base:lim:::"),
    _T("lim1::An embedded list entry, level 1 (if multiple levels):1::::::1:1:embedded list item:1:1:lim1 - Embedded List Entry - Level 1:0:12:::::::0:::.75::-.375:_list_base:lim1:::"),
    _T("lim2::An embedded list entry, level 2:1::::::1:1:embedded list item:1:1:lim2 - Embedded List Entry - Level 2:0:12:::::::0:::1.0::-.375:_list_base:lim2:::"),
    _T("lim3::An embedded list entry, level 3:1::::::1:1:embedded list item:1:1:lim3 - Embedded List Entry - Level 3:0:12:::::::0:::1.25::-.375:_list_base:lim3:::"),
    _T("lim4::An embedded list entry, level 4:1::::::1:1:embedded list item:1:1:lim4 - Embedded List Entry - Level 4:0:12:::::::0:::1.5::-.375:_list_base:lim4:::"),
    _T("litl:litl*:List entry total text:1::::1::1:1:list item total:1:1:litl...litl* - List Entry - Total:1:12::1:::::0::::::::::"),
    _T("lik:lik*:Structured list entry key text:1::::1::1:1:structured list key:1:1:lik...lik* - Structured List Entry - Key:1:12::1:::::0::::::::::"),
    _T("liv:liv*:Structured list entry value 1 content (if single value):1::::1::1:1:structured list entry:1:1:liv...liv* - Structured List Entry - Value 1:1:12:::::::0::::::::::"),
    _T("liv1:liv1*:Structured list entry value 1 content (if multiple values):1::1::::1:1:structured list entry:1:1:liv1...liv1* - Structured List Entry - Value 1:1:12:::::::0::::::::::"),
    _T("liv2:liv2*:Structured list entry value 2 content:1::::1::1:1:structured list entry:1:1:liv2...liv2* - Structured List Entry - Value 2:1:12:::::::0::::::::::"),
    _T("liv3:liv3*:Structured list entry value 3 content:1::::1::1:1:structured list entry:1:1:liv3...liv3* - Structured List Entry - Value 3:1:12:::::::0::::::::::"),
    _T("liv4:liv4*:Structured list entry value 4 content:1::::1::1:1:structured list entry:1:1:liv4...liv4* - Structured List Entry - Value 4:1:12:::::::0::::::::::"),
    _T("liv5:liv5*:Structured list entry value 5 content:1::::1::1:1:structured list entry:1:1:liv5...liv5* - Structured List Entry - Value 5:1:12:::::::0::::::::::"),
    _T("li1::A list entry, level 1 (if multiple levels):1::::::1:1:list item L1:1:1:li1 - List Entry - Level 1:0:12:::::::0:::.5::-.25:li:li1:::"),
    _T("li2::A list entry, level 2:1::::::1:1:list item L2:1:1:li2 - List Entry - Level 2:0:12:::::::0:::.75::-.25:li1:li2:::"),
    _T("li3::A list entry, level 3:1::::::1:1:list item L3:1:1:li3 - List Entry - Level 3:0:12:::::::0:::1::-.25:li2:li3:::"),
    _T("li4::A list entry, level 4:1::::::1:1:list item L4:1:1:li4 - List Entry - Level 4:0:12:::::::0:::1.25::-.25:li3:li4:::"),
    _T("qh::List or Genealogy::1:::::1:1:list item:1:1:qh - List or Genealogy:0:12:::::::0:::.625::-.375:q:qh:::"),
    _T("tr::A new table row:1::::::1:1:table row:1:1:tr - Table - Row:0:12:::::::0:::.5::-.25:_body_text:tr:::"),
    _T("tr1::A table Row:1::::::1:1:table row L1:1:1:OBSOLETE tr1 - Table - Row - Level 1:0:12:::::::0:::.5::-.25:tr:tr1:::"),
    _T("tr2::A table Row:1::::::1:1:table row L2:1:1:OBSOLETE tr2 - Table - Row - Level 2:0:12:::::::0:::.75::-.25:tr1:tr2:::"),
    _T("th1::A table heading, column 1:1::::::1:::1::th1 - Table - Column 1 Heading:1:12::1:::::0::::::::::"),
    _T("th2::A table heading, column 2:1::::::1:::1::th2 - Table - Column 2 Heading:1:12::1:::::0::::::::::"),
    _T("th3::A table heading, column 3:1::::::1:::1::th3 - Table - Column 3 Heading:1:12::1:::::0::::::::::"),
    _T("th4::A table heading, column 4:1::::::1:::1::th4 - Table - Column 4 Heading:1:12::1:::::0::::::::::"),
    _T("th5::A table heading, column 5:1::::::1:::1::th5 - Table - Column 5 Heading:1:12::1:::::0::::::::::"),
    _T("thr1::A table heading, column 1, right aligned:1::::::1:::1::thr1 - Table - Column 1 Heading - Right Aligned:1:12::1:::::2::::::::::"),
    _T("thr2::A table heading, column 2, right aligned:1::::::1:::1::thr2 - Table - Column 2 Heading - Right Aligned:1:12::1:::::2::::::::::"),
    _T("thr3::A table heading, column 3, right aligned:1::::::1:::1::thr3 - Table - Column 3 Heading - Right Aligned:1:12::1:::::2::::::::::"),
    _T("thr4::A table heading, column 4, right aligned:1::::::1:::1::thr4 - Table - Column 4 Heading - Right Aligned:1:12::1:::::2::::::::::"),
    _T("thr5::A table heading, column 5, right aligned:1::::::1:::1::thr5 - Table - Column 5 Heading - Right Aligned:1:12::1:::::2::::::::::"),
    _T("tc1::A table cell item, column 1:1::::::1:::1::tc1 - Table - Column 1 Cell:1:12:::::::0::::::::::"),
    _T("tc2::A table cell item, column 2:1::::::1:::1::tc2 - Table - Column 2 Cell:1:12:::::::0::::::::::"),
    _T("tc3::A table cell item, column 3:1::::::1:::1::tc3 - Table - Column 3 Cell:1:12:::::::0::::::::::"),
    _T("tc4::A table cell item, column 4:1::::::1:::1::tc4 - Table - Column 4 Cell:1:12:::::::0::::::::::"),
    _T("tc5::A table cell item, column 5:1::::::1:::1::tc5 - Table - Column 5 Cell:1:12:::::::0::::::::::"),
    _T("thc1::A table heading, column 1, center aligned:1::::::1:::1::thc1 - Table - Column 1 Heading - Center Aligned:1:12::1:::::1::::::::::"),
    _T("thc2::A table heading, column 2, center aligned:1::::::1:::1::thc2 - Table - Column 2 Heading - Center Aligned:1:12::1:::::1::::::::::"),
    _T("thc3::A table heading, column 3, center aligned:1::::::1:::1::thc3 - Table - Column 3 Heading - Center Aligned:1:12::1:::::1::::::::::"),
    _T("thc4::A table heading, column 4, center aligned:1::::::1:::1::thc4 - Table - Column 4 Heading - Center Aligned:1:12::1:::::1::::::::::"),
    _T("thc5::A table heading, column 5, center aligned:1::::::1:::1::thc5 - Table - Column 5 Heading - Center Aligned:1:12::1:::::1::::::::::"),
    _T("tcr1::A table cell item, column 1, right aligned:1::::::1:::1::tcr1 - Table - Column 1 Cell - Right Aligned:1:12:::::::2::::::::::"),
    _T("tcr2::A table cell item, column 2, right aligned:1::::::1:::1::tcr2 - Table - Column 2 Cell - Right Aligned:1:12:::::::2::::::::::"),
    _T("tcr3::A table cell item, column 3, right aligned:1::::::1:::1::tcr3 - Table - Column 3 Cell - Right Aligned:1:12:::::::2::::::::::"),
    _T("tcr4::A table cell item, column 4, right aligned:1::::::1:::1::tcr4 - Table - Column 4 Cell - Right Aligned:1:12:::::::2::::::::::"),
    _T("tcr5::A table cell item, column 5, right aligned:1::::::1:::1::tcr5 - Table - Column 5 Cell - Right Aligned:1:12:::::::2::::::::::"),
    _T("gm::Glossary main entry::1::1::1:1:1:glossary main entry:0:1:gm - Glossary main entry:0:12:::::::0::::::_body_text:gp:::"),
    _T("gs::Glossary subentry::1::1::1:1:1:glossary subentry:0:1:gs - Glossary subentry:0:12:::::::0::::::gm:gp:::"),
    _T("gd::Glossary definition::1::1:1:1:1:1:glossary definition:0:1:gd - Glossary definition:1:12:::::::0::::::::::"),
    _T("gp::Glossary paragraph::1::1::1:1:1:glossary paragraph:0:1:gp - Glossary paragraph:0:12:::::::0::::::_body_text:gp:::"),
    _T("tis::Topical index heading (level 1)::1::1:::1:1:topical index L1:0:1:tis - Topical index heading L1:0:12:::::::0::::::_heading_base:tpi:::"),
    _T("tpi::Topical index heading (level 2)::1::1:::1:1:topical index L2:0:1:tpi - Topical index heading L2:0:12:::::::0::::::tis:tps:::"),
    _T("tps::Topical index heading (level 3)::1::1:::1:1:topical index L3:0:1:tps - Topical index heading L3:0:12:::::::0::::::tpi:tir:::"),
    _T("tir::Topical index reference::1::1:::1:1:topical index reference:0:1:tir - Topical index ref:0:12:::::::0::::::_body_text:tir:::"),
    _T("w:w*:A wordlist text item:1::::1::1:::1::w...w* - Peripheral Ref - Wordlist Entry:1:12:::::::0::::::::::"),
    _T("wr:wr*:A Wordlist text item:1::::1::1:::1::OBSOLETE wr...wr* - Auxiliary - Wordlist/Glossary Reference:1:12::1:::::0::::::::::"),
    _T("wh:wh*:A Hebrew wordlist text item:1::::1::1:::1::wh...wh* - Peripheral Ref - Hebrew Wordlist Entry:1:12:::::::0::::::::::"),
    _T("wg:wg*:A Greek Wordlist text item:1::::1::1:::1::wg...wg* - Peripheral Ref - Greek Wordlist Entry:1:12:::::::0::::::::::"),
    _T("wa:wa*:An Aramaic Wordlist text item:1::::1::1:::1::wa...wa* - Peripheral Ref - Aramaic Wordlist Entry:1:12:::::::0::::::::::"),
    _T("ndx:ndx*:A subject index text item:1::::1::1:::6::ndx...ndx* - Peripheral Ref - Subject Index Entry:1:12:::::::0::::::::::"),
    _T("periph::Periheral content division marker which should be followed by an additional division argument/title.:1:::1:::1:1:Periph matter div:0::periph - Peripherals - Content Division Marker:0:14:33023::1::::0:16:4::::_peripherals_base:periph:::"),
    _T("p1::Front or back matter text paragraph, level 1 (if multiple levels):1:::1::1:1:1:Periph matter para L1:0:1:p1 - Periph - Front/Back Matter Paragraph Level 1:0:12:::::::0:::::.125:_peripherals_base:p1:::"),
    _T("p2::Front or back matter text paragraph, level 2 (if multiple levels):1:::1::1:1:1:Periph matter para L2:0:1:p2 - Periph - Front/Back Matter Paragraph Level 2:0:12:::::::0:::.125::.125:_peripherals_base:p2:::"),
    _T("k1::Concordance main entry text or keyword, level 1:1:::1::1:1:1:conc main entry/keyword L1:0:1:k1 - Periph - Concordance Keyword Level 1:0:12:::::::0::::::_peripherals_base:k1:::"),
    _T("k2::Concordance main entry text or keyword, level 2:1:::1::1:1:1:conc main entry/keyword L2:0:1:k2 - Periph - Concordance Keyword Level 2:0:12:::::::0::::::_peripherals_base:k2:::"),
    _T("xtSee:xtSee*:Concordance and Names Index markup for an alternate entry target reference.:1:::1:1::1:::0::xtSee - Concordance and Names Index - Alternate Entry Target Reference:1:12:16711680:1:::::0::::::::::"),
    _T("xtSeeAlso:xtSeeAlso*:Concordance and Names Index markup for an additional entry target reference.:1:::1:1::1:::0::xtSeeAlso - Concordance and Names Index - Additional Entry Target Reference:1:12:16711680:1:::::0::::::::::"),
    _T("pub::Front matter publication data:1:::1:::1:::0::OBSOLETE pub Peripherals - Front Matter Publication Data:0:10:::::::0::::::_peripherals_base:pub:::"),
    _T("toc::Front matter table of contents:1:::1:::1:::0::OBSOLETE toc Peripherals - Front Matter Table of Contents:0:10:::::::0::::::_peripherals_base:toc:::"),
    _T("toc1::Long table of contents text:1:::1:::1:::0::toc1 - File - Long Table of Contents Text:0:12:16384:1:1::::0::::::_peripherals_base:toc1:::"),
    _T("toc2::Short table of contents text:1:::1:::1:::0::toc2 - File - Short Table of Contents Text:0:12:16384:1:::::0::::::_peripherals_base:toc2:::"),
    _T("toc3::Book Abbreviation:1:::1:::1:::0::toc3 - File - Book Abbreviation:0:12:128:1:1::::0::::::_peripherals_base:toc3:::"),
    _T("toca1::Alternative Language Long Table of Contents Text:1:::1:::1:::0::toca1 - File - Alternative Language Long Table of Contents Text:0:10:8421504:1:::::0::::::_peripherals_base:toca1:::"),
    _T("toca2::Alternative language short table of contents text:1:::1:::1:::0::toca2 - File - Alternative Language Short Table of Contents Text:0:10:8421504:1:::::0::::::_peripherals_base:toca2:::"),
    _T("toca3::Alternative language book Abbreviation:1:::1:::1:::0::toca3 - File - Alternative Language Book Abbreviation:0:10:8421504:1:::::0::::::_peripherals_base:toca3:::"),
    _T("pref::Front matter preface:1:::1:::1:::0::OBSOLETE pref Peripherals - Front Matter Preface:0:10:::::::0::::::_peripherals_base:pref:::"),
    _T("intro::Front matter introduction:1:::1:::1:::0::OBSOLETE intro Peripherals - Front Matter Introduction:0:10:::::::0::::::_peripherals_base:intro:::"),
    _T("conc::Back matter concordance:1:::1:::1:::0::OBSOLETE conc Peripherals - Back Matter Concordance:0:10:::::::0::::::_peripherals_base:conc:::"),
    _T("glo::Back matter glossary:1:::1:::1:::0::OBSOLETE glo Peripherals - Back Matter Glossary:0:10:::::::0::::::_peripherals_base:glo:::"),
    _T("idx::Back matter index:1:::1:::1:::0::OBSOLETE idx Peripherals - Back Matter Index:0:10:::::::0::::::_peripherals_base:idx:::"),
    _T("maps::Back matter map index:1:::1:::1:::0::OBSOLETE maps Peripherals - Back Matter Map Index:0:10:::::::0::::::_peripherals_base:maps:::"),
    _T("cov::Other peripheral materials - cover:1:::1:::1:::0::OBSOLETE cov Peripherals - Other - Cover:0:10:::::::0::::::_peripherals_base:cov:::"),
    _T("spine::Other peripheral materials - spine:1:::1:::1:::0::OBSOLETE spine Peripherals - Other - Spine:0:10:::::::0::::::_peripherals_base:spine:::"),
    _T("pubinfo::Publication information - Lang,Credit,Version,Copies,Publisher,Id,Logo:1:::1:::1:::0::OBSOLETE pubinfo - Publication - Information:0:12:16711680::::::0::::::__normal:pubinfo:::"),
    _T("pb::Page Break used for new reader portions and children's bibles where content is controlled by the page:1:::1:::1:1:new page:0:1:pb - Break - Page Break:0:12:::::::0::::::p:p:::"),
    _T("b::Poetry text stanza break (e.g. stanza break) (basic):1:::1:::1:1:stanza break:0::b - Poetry - Stanza Break (Blank Line):0:12:::::::0::::::_body_text:b:::"),
    _T("hr::Horizontal rule::1:1:::1:1:::0::hr - Horizontal rule:8:12:::::::0:4:4::::_body_text:hr:::"),
    _T("fig:fig*:Illustration [Columns to span, height, filename, caption text]:1::1:1:1::1:::0::fig...fig* - Auxiliary - Figure/Illustration/Map:1:12:::::::0::::::::::"),
    _T("jmp:jmp*:For associating linking attributes to a span of text:1::1:1:1::1:::0::jmp...jmp* - Link text:1:12:16711680:::1:::0::::::::::"),
    _T("rb:rb*:Most often used to provide a reading / pronunciation guide in ideographic scripts:1::::1::1:::1:1:rb...rb* - Special Text - Ruby Glossing:1:12:::::::0::::::::::"),
    _T("loc::Picture location::1:1::::1:::0::loc - Picture location:0:12:::::::0::::::_body_text:loc:::"),
    _T("cap::Picture caption::1:1:1::1:1:1:picture caption:0::cap - Picture caption:0:12:::::::0::::::_body_text:cap:::"),
    _T("cat::Picture catalog number::1:1::::1:::0::cat - Picture catalog number:0:12:::::::0::::::_body_text:cat:::"),
    _T("des::Picture description::1:1:1:::1:::0::des - Picture description:0:12:::::::0::::::_body_text:des:::"),
    _T("px::Paragraph extra 1::1::1:::1:1:para extra 1:1:1:px - Paragraph extra 1:0:12:::::::0::::::p:px:::"),
    _T("pz::Paragraph extra 2::1::1:::1:1:para extra 2:1:1:pz - Paragraph extra 2:0:12:::::::0::::::p:pz:::"),
    _T("qx::Poetry extra 1::1::1:::1:1:poetry extra 1:2:1:qx - Poetry extra 1:0:12:::::::0::::::q:qx:::"),
    _T("qz::Poetry extra 2::1::1:::1:1:poetry extra 2:2:1:qz - Poetry extra 2:0:12:::::::0::::::q:qz:::"),
    _T("addpn:addpn*:For chinese words to be dot underline and underline:1::::1::1:::1::DEPRECATED addpn...addpn* - Special Text for Chinese:1:12:2263842:1:1:1:::0::::::::::"),
    _T("efm:efm*:ID or Caller for an extended (study) note. Used within a source project duplicte (target) text when autoring study material.:1::1::1:1:1:::0::efm - Study Note - ID/Caller:1:10:255::1::::0::::::::::"),
    _T("ef:ef*:A Study Note text item:1::1::1:1:1:::0::ef...ef* - Study Note:1:12:::::::0::::::::::"),
    _T("bt::Back-translation (and all \bt... initial forms):1:1:1:::1::1:back-trans:0::bt - Back-translation:1:11:16711680::::::0::::::::::"),
    _T("free:free*:Free translation:1:1:1:::1::1:free-trans:0::free - Free translation:1:11:4194500::::::0::::::::::"),
    _T("note:note*:Adapt It note:1:1:1:::1::1:note:0::note - Adapt It note:1:10:16711680::::::0::::::::::"),
    _T("__normal::Normal:1:1:1:::::::0::Normal:0:11:::::::0:::::::__normal:::"),
    _T("_src_lang_interlinear::Source Language Interlinear Text:1:1:1:::::::0::Source Language:0:11:::::::0::::::__normal:_src_lang_interlinear::1:"),
    _T("_tgt_lang_interlinear::Target Language Interlinear Text:1:1:1:::::::0::Target Language:0:11:::::::0::::::__normal:_tgt_lang_interlinear::1:"),
    _T("_gls_lang_interlinear::Gloss Language Interlinear Text:1:1:1:::::::0::Gloss Language:0:11:::::::0::::::__normal:_gls_lang_interlinear::1:"),
    _T("_nav_lang_interlinear::Navigation Language Interlinear Text:1:1:1:::::::0::Navigation Language:0:11:::::::0::::::__normal:_nav_lang_interlinear::1:"),
    _T("_hdr_ftr_interlinear::Header-Footer Interlinear Text:1:1:1:::::::0::Hdr-Ftr Interlinear:7:9:::::::0::::::__normal:_hdr_ftr_interlinear:::"),
    _T("_small_para_break::Small Paragraph Break:1:1:1:::::::0::Small Para Break:0:4:::::::0::::::__normal:_small_para_break:::"),
    _T("_body_text::Body Text:1:1:1:::::::0::_BodyText_Base:0:11:::::::0::::::_vernacular_base:_body_text:::"),
    _T("_heading_base::Heading Base:1:1:1:::1::::0::_Heading_Base:0:12:::::::1:6::.1:.1::_vernacular_base:_heading_base:1:1:"),
    _T("_intro_base::Intro Base:1:1:1:::1::::0::_Intro_Base:0:11::1:::::0::::::_vernacular_base:_intro_base:::"),
    _T("_list_base::List Base:1:1:1:::1::::0::_List_Base:0:12:::::::0::::::_vernacular_base:_list_base:::"),
    _T("_notes_base::Notes Base:1:1:1:::1::::0::_Notes_Base:0:9:::::::0::::::_vernacular_base:_notes_base:::"),
    _T("_peripherals_base::Peripherals Base:1:1:1:::1::::0::_Peripherals_Base:0:10:::::::0::::::_vernacular_base:_peripherals_base:::"),
    _T("_vernacular_base::Vernacular Base:1:1:1:::::::0::_Vernacular_Base:0:11:::::::0::::::__normal:_vernacular_base:::"),
    _T("_annotation_ref::Annotation Reference:1:1:1:::::::0::_annotation_reference:1:10:4210943:::::1:0::::::::::"),
    _T("_annotation_text::Annotation Text:1:1:1:::::::0::_annotation_text:0:10:::::::0::::::__normal:_annotation_text:::"),
    _T("_dft_para_font::Default Paragraph Font:1:1:1:::::::0::Default Paragraph Font:5:10:::::::0::::::::::"),
    _T("_footnote_caller::Footnote Caller:1:1:1:::::::0::Footnote Caller:3:10:16711680:::::1:0::::::::::"),
    _T("_normal_table::Normal Table:1:1:1:::::::0::Normal Table:2:10:::::::0:::::::_normal_table:::"),
    _T("_table_grid::Table Grid:1:1:1:::::::0::Table Grid:2:10:::::::0::::::_normal_table:_table_grid:::"),
    _T("_footer::Footer:1:1:1:::::::0::footer:6:10:::::::0::::::_body_text:_footer:::"),
    _T("_header::Header:1:1:1:::::::0::header:7:9:::::::0::::::_body_text:_header:::"),
    _T("_horiz_rule::Horizontal Rule:1:1:1:::::::0::Horizontal rule:8:10:::::::0:::::::_horiz_rule:::"),
    _T("_single_boxed_para::Single Boxed Paragraph:1:1:1:::::::0::Single Boxed Paragraph:9:10:::::::0::::::__normal:_single_boxed_para:::"),
    _T("_double_boxed_para::Double Boxed Paragraph:1:1:1:::::::0::Double Boxed Paragraph:9:10:::::::0::::::__normal:_double_boxed_para:::"),
    _T("_unknown_para_style::Unknown Paragraph Style Marker:1:1:1:::::::0::Unknown Para Style Marker:0:12:255::::::0::::::_body_text:_unknown_para_style:::"),
    _T("_unknown_char_style::Unknown Character Style Marker:1:1:1:::::::0::Unknown Char Style Marker:1:12:255::::::0::::::::::"),
    _T("_hidden_note::Hidden Note:1:1:1:::::::0::Hidden Note:10:10:8388608:1:::::0:2::::.3:p:_hidden_note:::")
    */

    // Below are the old USFM 2 strings
    //_T("id::File identification (BOOKID, FILENAME, EDITOR, MODIFICATION DATE):1:1::::1::1:id:11::id - File - Identification:0:1:65535::::::3::::::__normal:id::1:"),
    //_T("ide::File encoding information:1::1::::1:::0::ide - File - Encoding:0:1:65535::::::3::::::__normal:ide::1:"),
    //_T("h::Running header text for a book (basic):1:1:1:1::1:1:1:hdr:10::h - File - Header:0:9:::::::3::::::_vernacular_base:h:::"),
    //_T("h1::Running header text:1::1:1::1:1:1:hdr:10::h1 - File - Header:0:9:::::::1::::::h:h1:::"),
    //_T("h2::Running header text, left side of page:1::1:1::1:1:1:hdr-left:10::h2 - File - Left Header:0:9:::::::0::::::h1:h2:::"),
    //_T("h3::Running header text, right side of page:1::1:1::1:1:1:hdr-rght:10::h3 - File - Right Header:0:9:::::::2::::::h1:h3:::"),
    //_T("rem::Comments and remarks:1::1:1::1:1:1:comment:34::rem - File - Remark:0:9:16711680::::::0::::::_notes_base:rem:::"),
    //_T("sts::Status of this file:1::1:1::1:1:1:comment:34::rem - File - Status:0:9:16711680::::::0::::::_notes_base:sts:::"),
    //_T("restore::Project restore information:1::1::::1:::34::restore - File - Restore Information:0:12:16711680::::::3::::::__normal:restore:::"),
    //_T("lit::For a comment or note inserted for liturgical use:1::1:1::1:1:1:lit-note:34::lit - Special Text - Liturgical note:0:12:::1::::2::::::p:lit:1:1:"),
    //_T("nt::Note::1:1:1::1:1:1:note:34::nt - Note:0:9:16711680::::::0::::::_notes_base:nt:::"),
    //_T("nc::Note centered::1:1:1::1:1:1:note:34::nc - Note centered:0:9:16711680::::::1::::::nt:nc:::"),
    //_T("c::Chapter number (basic):1:1:::::1:1::1:1:c - Chapter Number:0:18:::1::::1:8:4::::_heading_base:p:1:1:"),
    //_T("ca:ca*:Second (alternate) chapter number (for coding dual versification; useful for places where different traditions of chapter breaks need to be supported in the same translation):1::1:1:::1:::1::ca...ca* - Chapter Number - Alternate:1:16:2263842::1::::3::::::::::"),
    //_T("cl::Chapter label used for translations that add a word such as 'Chapter' before chapter numbers (e.g. Psalms). The subsequent text is the chapter label.:1::1:1:::1:::1::cl - Chapter - Publishing Label:0:18:::1::::1:8:4::::_heading_base:p:1:1:"),
    //_T("cp::Published chapter number (this is a chapter marking that would be used in the published text):1::1:1:::1:::1::cp - Chapter Number - Publishing Alternate:0:18:16711680::1::::1:8:4::::_heading_base:p:1:1:"),
    //_T("cd::Chapter Description (Publishing option D, e.g. in Russian Bibles):1:::1:::1:1:chapter descr:1::cd - Chapter - Description:0:11:::::::3:8:4::::_heading_base:p:1:1:"),
    //_T("v::A verse number (basic):1:1:::::1:1::1::v - Verse Number:1:10:16711935::1:::1:3::::::::::"),
    //_T("vt::Verse text:1:1:::::1:1::1::vt - Verse text vt:1:12::::::1:3::::::::::"),
    //_T("vn::Verse number:1:1:::::1:1::1::vn - Verse number vn:1:10:16711935::1:::1:3::::::::::"),
    //_T("va:va*:Second (alternate) verse number (for coding dual numeration in Psalms; see also NRSV Exo 22.1-4):1::1:1:1:::::1::va...va* - Verse Number - Alternate:1:10:2263842::1:::1:3::::::::::"),
    //_T("vp:vp*:Published verse marker - this is a verse marking that would be used in the published text:1::1:1:1:::::1::vp...vp* - Verse Number - Publishing Alternate:1:10:16711680::1:::1:3::::::::::"),
    //_T("mt::The main title of the book (if single level):1:1::1::1:1:1:main title:4:1:mt - Title - Major Title Level 1:0:20:::1::::1:8:4::::_heading_base:c:1:1:"),
    //_T("mt1::The main title of the book (if multiple levels) (basic):1:::1::1:1:1:main title L1:4:1:mt1 - Title - Major Title Level 1:0:20:::1::::1:2:4::::_heading_base:c:1:1:"),
    //_T("mt2::A secondary title usually occurring before the main title (basic):1:::1::1:1:1:secondary title L2:5:1:mt2 - Title - Major Title Level 2:0:16::1:::::1::2::::_heading_base:mt:1:1:"),
    //_T("mt3::A secondary title occurring after the main title:1:::1::1:1:1:secondary title L3:5:1:mt3 - Title - Major Title Level 3:0:14:::1::::1:2:2::::_heading_base:c:1:1:"),
    //_T("mt4::A small secondary title sometimes occuring within parentheses:1:::1::1:1:1:secondary title L4:5:1:mt4 - Title - Major Title level 4:0:12:::::::1:2:2::::_heading_base:c:1:1:"),
    //_T("st::Secondary title::1::1::1:1:1:secondary title:5:1:st - Secondary title:0:16:::1::::1::2::::_heading_base:mt:1:1:"),
    //_T("mte::The main title of the book repeated at the end of the book (if single level):1:::1::1:1:1:main title at end:4:1:mte - Title - [Uncommon] Major Title Ending Level 1:0:20:::1::::1:8:4::::_heading_base::1::"),
    //_T("mte1::The main title of the book repeated at the end of the book (if multiple levels):1:::1::1:1:1:main title at end L1:4:1:mte1 - Title - [Uncommon] Major Title Ending Level 1:0:20:::1::::1:8:4::::_heading_base::1::"),
    //_T("mte2::A secondary title occurring before or after the 'ending' main title:1:::1::1:1:1:secondary title at end L2:5:1:mte2 - Title - [Uncommon] Major Title Ending Level 2:0:16::1:::::1::2::::_heading_base::1::"),
    //_T("div::Division heading::1::1::1:1:1:division head:3:1:div - Division heading:0:16:::1::::1:6:3::::s:dvrf:1:1:"),
    //_T("bn::Psalms book number::1::1::1:1:1:Psalm book number:0:1:bn - Psalms book number:0:11:::1::::1:6:3::::s:br:1:1:"),
    //_T("ms::A major section division heading, level 1 (if single level) (basic):1:::1::1:1:1:major sect head:3:1:ms - Heading - Major Section Level 1:0:14:::1::::1:16:4::::_heading_base:mr:1:1:"),
    //_T("ms1::A major section division heading, level 1 (if multiple levels):1:::1::1:1:1:major sect head L1:3:1:ms1 - Heading - Major Section Level 1:0:14:::1::::1:16:4::::_heading_base:mr:1:1:"),
    //_T("ms2::A major section division heading, level 2:1:::1::1:1:1:major sect head L2:3:1:ms2 - Heading - Major Section Level 2:0:14:::1::::1:16:4::::_heading_base:mr:1:1:"),
    //_T("ms3::A major section division heading, level 3:1:::1::1:1:1:major sect head L3:3:1:ms3 - Heading - Major Section Level 3:0:14::1:::::1:16:4::::_heading_base:mr:1:1:"),
    //_T("s::A section heading, level 1 (if single level) (basic):1:1::1::1:1:1:sect head:3:1:s - Heading - Section Level 1:0:12:::1::::1:8:4::::_heading_base:p:1:1:"),
    //_T("s1::A section heading, level 1 (if multiple levels):1:::1::1:1:1:sect head L1:3:1:s1 - Heading - Section Level 1:0:12:::1::::1:8:4::::_heading_base:p:1:1:"),
    //_T("s2::A section heading, level 2 (e.g. Proverbs 22-24):1:::1::1:1:1:sect head L2:3:1:s2 - Heading - Section Level 2:0:12::1:::::1:8:4::::_heading_base:p:1:1:"),
    //_T("s3::A section heading, level 3 (e.g. Genesis 'The First Day'):1:::1::1:1:1:sect head L3:3:1:s3 - Heading - Section Level 3:0:12::1:::::0:6:3::::_heading_base:p:1:1:"),
    //_T("s4::A section heading, level 4:1:::1::1:1:1:sect head L4:3:1:s4 - Heading - Section Level 4:0:12::1:::::0:6:3::::_heading_base:p:1:1:"),
    //_T("sr::A section division references range heading:1:::1::1:1:1:sect head range refs:3:1:sr - Heading - Section Range References:0:12:::1::::1::4::::_heading_base:p:1:1:"),
    //_T("sx::Extra heading 1::1::1::1:1:1:sect head extra 1:3:1:sx - Extra heading 1:0:12:::1::::1:6:3::::_heading_base:p:1:1:"),
    //_T("sz::Extra heading 2::1::1::1:1:1:sect head extra 2:3:1:sz - Extra heading 2:0:12::1:::::1:6:3::::_heading_base:p:1:1:"),
    //_T("sp::A heading, to identify the speaker (e.g. Job) (basic):1:1::1::1:1:1:speaker:0:1:sp - Heading - Speaker:0:12::1:::::0:8:4::::_heading_base:q:1:1:"),
    //_T("d::A Hebrew text heading, to provide description (e.g. Psalms):1:::1::1:1:1:descr title:1:1:d - Heading - Descriptive Title - Hebrew Subtitle:0:12::1:::::1:4:4::::_heading_base:q:1:1:"),
    //_T("di::Descriptive title (Hebrew subtitle)::1::1::1:1:1:descr title:1:1:di - Descr title or Heb subtitle di:0:12::1:::::1:4:4::::_heading_base:q:1:1:"),
    //_T("hl::Hebrew letter::1:1:1:::1:::0::hl - Hebrew letter:0:12:::::::1:4:4::::_heading_base:q:1:1:"),
    //_T("r::Parallel reference(s) (basic):1:1:1:1::1:1:1:ref:33::r - Heading - Parallel References:0:12::1:::::1::4::::_heading_base:p:1:1:"),
    //_T("dvrf::Division reference::1:1:1::1::1:div-ref:0::dvrf - Division ref:0:12::1:::::1::3::::_heading_base:p:1:1:"),
    //_T("mr::A major section division references range heading (basic):1::1:1::1::1:mjr-sect-refs:0::mr - Heading - Major Section Range References:0:12::1:::::1::4::::ms:p:1:1:"),
    //_T("br::Psalms book reference::1:1:1::1::1:Ps-bk-ref:0::br - Psalms book ref:0:12::1:::::1::4::::r:c:1:1:"),
    //_T("x:x*:A list of cross references (basic):1::1:1:1:1:1:1:x-refs:33::x...x* - Cross Reference:4:10:::::::0::::::_notes_base:x:::"),
    //_T("xo:xo*:The cross reference origin reference (basic):1::1::1:1::1:origin-ref:33::xo - Cross Reference - Origin Reference:1:10:::1::::3::::::::::"),
    //_T("xt:xt*:The cross reference target reference(s), protocanon only (basic):1::1::1:1::1:tgt-ref:33::xt - Cross Reference - Target References:1:10:::::::3::::::::::"),
    //_T("xk:xk*:A cross reference keyword:1::1::1:1::1:keyword:33::xk - Cross Reference - Keyword:1:10::1:::::3::::::::::"),
    //_T("xq:xq*:A cross-reference quotation from the scripture text:1::1::1:1::1:quote:33::xq - Cross Reference - Quotation:1:10::1:::::3::::::::::"),
    //_T("xot:xot*:Cross-reference target reference(s), Old Testament only:1::1::1:1::1:OldT-ref:33::xot...xot* - Cross Reference - OT Target Refs (optional):1:12:::::::3::::::::::"),
    //_T("xnt:xnt*:Cross-reference target reference(s), New Testament only:1::1::1:1::1:NewT-ref:33::xnt...xnt* - Cross Reference - NT Target Refs (optional):1:12:::::::3::::::::::"),
    //_T("xdc:xdc*:Cross-reference target reference(s), Deuterocanon only:1::1::1:1::1:deut-canon-ref:33::xdc...xdc* - Cross Reference - DC Target Refs:1:10:::::::3::::::::::"),
    //_T("rr::Right margin reference::1:1:1::1::1:rt-marg-ref:32::rr - Right margin ref:0:9::1:::::2::::::qr:rr:::"),
    //_T("rq:rq*:A cross-reference indicating the source text for the preceding quotation:1::1:1::1::1:x-ref to source:32::rq...rq* - Cross Reference - Inline Quotation References:1:10::1:::::2::::::::::"),
    //_T("@::Cross reference, origin reference::1:1:1::1::1:x-refs orig:33::@ - Cross ref origin ref:1:10:::1::::3::::::::::"),
    //_T("xr::Cross reference target references::1:1:1::1::1:x-refs tgt:33::xr - Cross ref target ref:1:10:::::::3::::::::::"),
    //_T("p::Paragraph text, with first line indent (basic):1:1:::::1:1:paragraph:1:1:p - Paragraph - Normal - First Line Indent:0:12:::::::3:::::.125:_body_text:p:::"),
    //_T("pi::Paragraph text, level 1 indent (if single level), with first line indent; often used for discourse (basic):1:1:::::1:1:para indented:1:1:pi - Paragraph - Indented - Level 1 - First Line Indent:0:12:::::::3:::.25:.25:.125:p:pi:::"),
    //_T("pi1::Paragraph text, level 1 indent (if multiple levels), with first line indent; often used for discourse:1::::::1:1:para indented L1:1:1:pi1 - Paragraph - Indented - Level 1 - First Line Indent:0:12:::::::3:::.25:.25:.125:pi:pi1:::"),
    //_T("pi2::Paragraph text, level 2 indent, with first line indent; often used for discourse:1::::::1:1:para indented L2:1:1:pi2 - Paragraph - Indented - Level 2 - First Line Indent:0:12:::::::3:::.5:.25:.125:pi1:pi2:::"),
    //_T("pi3::Paragraph text, level 3 indent, with first line indent; often used for discourse:1::::::1:1:para indented L3:1:1:pi3 - Paragraph - Indented - Level 3 - First Line Indent:0:12:::::::3:::.75:.25:.125:pi2:pi3:::"),
    //_T("pgi::Indented paragraph::1:::::1:1:para indented:1:1:pgi - Indented paragraph:0:12:::::::3:::.25:.25:.125:p:pgi:::"),
    //_T("ph::Paragraph text, with level 1 hanging indent (if single level):1::::::1:1:para hang indent:1:1:DEPRECATED ph - Paragraph - Hanging Indent - Level 1:0:12:::::::3:::.5::-.25:_body_text:ph:::"),
    //_T("ph1::Paragraph text, with level 1 hanging indent (if multiple levels):1::::::1:1:para hang indent L1:1:1:DEPRECATED ph1 - Paragraph - Hanging Indent - Level 1:0:12:::::::3:::.5::-.25:ph:ph1:::"),
    //_T("ph2::Paragraph text, with level 2 hanging indent:1::::::1:1:para hang indent L2:1:1:DEPRECATED ph2 - Paragraph - Hanging Indent - Level 2:0:12:::::::3:::.75::-.25:ph1:ph2:::"),
    //_T("ph3::Paragraph text, with level 3 hanging indent:1::::::1:1:para hang indent L3:1:1:DEPRECATED ph3 - Paragraph - Hanging Indent - Level 3:0:12:::::::3:::1::-.25:ph2:ph3:::"),
    //_T("phi::Paragraph text, indented with hanging indent:1::::::1:1:para indent hang indent:1:1:DEPRECATED phi - Paragraph - Indented - Hanging Indent:0:12:::::::3:::1:::_body_text:phi:::"),
    //_T("m::Paragraph text, with no first line indent (may occur after poetry) (basic):1:1:::::1:1:paragraph margin:1:1:m - Paragraph - Margin - No First Line Indent:0:12:::::::3::::::p:m:::"),
    //_T("pmo::Embedded text opening:1::::::1:1:para embedded text opening:1:1:pmo - Paragraph - Embedded Text Opening:0:12:::::::3:::.25:.25::pm:pm:::"),
    //_T("mi::Paragraph text, indented, with no first line indent; often used for discourse:1:1:::::1:1:para indent no 1st line indent:1:1:mi - Paragraph - Indented - No First Line Indent:0:12:::::::3:::.25:.25::pi:mi:::"),
    //_T("pc::Paragraph spanning chapters::1::1:::1:1:para spans chapters:1:1:pc - Paragraph spanning chapters:0:12:::::::3::::::m:pc:::"),
    //_T("pc::Paragraph text, centered (for Inscription):1::::::1:1:para centered inscription:1:1:pc - Paragraph - Centered (for Inscription):0:12:::::::1::::::_body_text:pc:::"),
    //_T("pr::Paragraph text, right aligned:1::::::1:1:para right aligned:1:1:DEPRECATED pr - Paragraph - Right Aligned:0:12:::::::2::::::p:pr:::"),
    //_T("pt::Preface title::1::1::1:1:1:preface title:0:1:pt - Preface title:0:14:::1::::1::6::::_heading_base:pp:1:1:"),
    //_T("ps::Preface section heading::1::1::1:1:1:preface sect head:0:1:ps - Preface sect heading:0:12:::1::::1:4:2::::s:pp:1:1:"),
    //_T("ps::Paragraph text, no break with next paragraph text at chapter boundary:1:::1:::1:1:para spans chapters:1:1:OBSOLETE ps - Paragraph - No Break with Next Paragraph:0:12:::::::3::::::m:ps:::"),
    //_T("psi::Paragraph text, indented, with no break with next paragraph text (at chapter boundary):1::::::1:1:para spans chapters indent:1:1:OBSOLETE psi - Paragraph - Indented - No Break with Next:0:12:::::::3:::.25:.25:.125:pi:pi:::"),
    //_T("pp::Preface paragraph::1::1::1:1:1:preface paragraph:0:1:pp - Preface paragraph:0:10:::::::3:::::.125:p:pp:::"),
    //_T("pq::Preface poetry::1::1::1:1:1:preface poetry:0:1:pq - Preface poetry:0:10:::::::3:::.5:::q:pq:::"),
    //_T("pm::Preface continue at margin::1::1::1:1:1:preface at margin:0:1:pm - Preface continue at margin:0:10:::::::3::::::m:pm:::"),
    //_T("pm::Embedded text paragraph:1:::::1:1:1:paragraph embedded text:1:1:pm - Paragraph - Embedded Text:0:12:::::::3:::.25:.25:.125:p:pm:::"),
    //_T("pmc::Embedded text closing:1:::::1:1:1:para embedded text closing:1:1:pmc - Paragraph - Embedded Text Closing:0:12:::::::3:::.25:.25::pm:pmc:::"),
    //_T("pmr::Embedded text refrain (e.g. Then all the people shall say, 'Amen!'):1:::::1:1:1:para embedded text refrain:1:1:pmr - Paragraph - Embedded Text Refrain:0:12:::::::2:::.25:.25::pm:p:::"),
    //_T("nb::Paragraph text, with no break from previous paragraph text (at chapter boundary) (basic):1::::::1:1:para no break:1:1:nb - Paragraph - No Break with Previous Paragraph:0:12:::::::3::::::m:p:::"),
    //_T("cls::Closure of an Epistle:1::::::1:1:Epistle close:1::cls - Paragraph - Closure of an Epistle:0:12:::::::2::::::p:cls:1:1:"),
    //_T("q::Poetry text, level 1 indent (if single level):1:1:::::1:1:poetry:2:1:q - Poetry - Indent Level 1 - Single Level Only:0:12:::::::3:::1.25::-1:_body_text:q:::"),
    //_T("q1::Poetry text, level 1 indent (if multiple levels) (basic):1::::::1:1:poetry L1:2:1:q1 - Poetry - Indent Level 1:0:12:::::::3:::1.25::-1:q:q1:::"),
    //_T("q2::Poetry text, level 2 indent (basic):1:1:::::1:1:poetry L2:2:1:q2 - Poetry - Indent Level 2:0:12:::::::3:::1.25::-.75:q:q2:::"),
    //_T("q3::Poetry text, level 3 indent:1:1:::::1:1:poetry L3:2:1:q3 - Poetry - Indent Level 3:0:12:::::::3:::1.25::-.5:q2:q3:::"),
    //_T("q4::Poetry text, level 4 indent:1:1:::::1:1:poetry L3:2:1:q4 - Poetry - Indent Level 4:0:12:::::::3:::1.25::-.25:q3:q4:::"),
    //_T("qc::Poetry text, centered:1:1:::::1:1:poetry centered:2:1:qc - Poetry - Centered:0:12:::::::1::::::q:qc:::"),
    //_T("qr::Poetry text, Right Aligned:1:1:::::1:1:poetry right margin:2:1:qr - Poetry - Right Aligned:0:12:::::::2::::::q:qr:::"),
    //_T("qa::Poetry text, Acrostic marker/heading:1:::1:::1:1:acrostic hdg:2:1:qa - Poetry - Acrostic Heading/Marker:0:12::1:::::3::::::_heading_base:q:1:1:"),
    //_T("qac:qac*:Poetry text, Acrostic markup of the first character of a line of acrostic poetry:1::::1::1:::2::qac...qac* - Poetry Text - Acrostic Letter:1:12::1:::::3::::::::::"),
    //_T("qs:qs*:Poetry text, Selah:1:::1:1::1:::6::qs...qs* - Poetry Text - Selah:1:12::1:::::3::::::::::"),
    //_T("qm::Poetry, left margin::1:::::1:1:poetry margin:2:1:qm - Poetry left margin:0:12:::::::3::::::q:qm:::"),
    //_T("qm::Poetry text, embedded, level 1 indent (if single level):1::::::1:1:poetry embed:2:1:qm - Poetry - Embedded Text - Indent Level 1 - Single Level Only:0:12:::::::3:::1::-.75:q:qm:::"),
    //_T("qm1::Poetry text, embedded, level 1 indent (if multiple levels):1::::::1:1:poetry embed L1:2:1:qm1 - Poetry - Embedded Text - Indent Level 1:0:12:::::::3:::1::-.75:qm:qm1:::"),
    //_T("qm2::Poetry text, embedded, level 2 indent:1::::::1:1:poetry embed L2:2:1:qm2 - Poetry - Embedded Text - Indent Level 2:0:12:::::::3:::1::-.5:qm1:qm2:::"),
    //_T("qm3::Poetry text, embedded, level 3 indent:1::::::1:1:poetry embed L3:2:1:qm3 - Poetry - Embedded Text - Indent Level 3:0:12:::::::3:::1::-.25:qm2:qm3:::"),
    //_T("f:f*:A Footnote text item (basic):1:1::1:1:1:1:1:footnote:9::f...f* - Footnote:4:10:::::::0::::::_notes_base:f:::"),
    //_T("fe::Footnote (end)::1:::::1:::1::fe - Footnote end PNG:1:10:::::::3::::::::::"),
    //_T("fe:fe*:An Endnote text item:1:::1:1:1:1:1:endnote:9::fe...fe* - Endnote:4:10:::::::0::::::_notes_base:fe:::"),
    //_T("fr:fr*:The origin reference for the footnote (basic):1::::1:1:1:1:ref:9::fr - Footnote - Reference:1:10:::1::::3::::::::::"),
    //_T("fk:fk*:A footnote keyword (basic):1::::1:1:1:1:keyword:9::fk - Footnote - Keyword:1:10::1:1::::3::::::::::"),
    //_T("fq:fq*:A footnote scripture quote or alternate rendering (basic):1::::1:1:1:1:quote:9::fq - Footnote - Quotation or Alternate Rendering:1:10:::::::3::::::::::"),
    //_T("fqa:fqa*:A footnote alternate rendering for a portion of scripture text:1::::1:1:1:1:alt-transln:9::fqa - Footnote - Alternate Translation Rendering:1:10::1:::::3::::::::::"),
    //_T("fl:fl*:A footnote label text item, for marking or 'labelling' the type or alternate translation being provided in the note.:1::::1:1:1:1:label:9::fl - Footnote - Label Text:1:10::1:1::::3::::::::::"),
    //_T("fp:fp*:A Footnote additional paragraph marker:1::::1:1:1:1:new-paragr:9::fp - Footnote Paragraph Mark:1:10:::::::3::::::::::"),
    //_T("ft:ft*:Footnote text, Protocanon (basic):1::::1:1:1:1:fn-text:9::ft - Footnote - Text:1:10:::::::3::::::::::"),
    //_T("fdc:fdc*:Footnote text, applies to Deuterocanon only:1::::1:1:1:1:deut-canon:9::fdc...fdc* - Footnote - DC text:1:10:::::::3::::::::::"),
    //_T("fv:fv*:A verse number within the footnote text:1::::1:1::1:verse#:9::fv...fv* - Footnote - Embedded Verse Number:1:10:::1:::1:3::::::::::"),
    //_T("fm:fm*:An additional footnote marker location for a previous footnote:1::::1:1::1:call-prev:9::fm - Footnote - Additional Caller to Previous Note:1:10::::::1:3::::::::::"),
    //_T("F::Footnote (end)::1:::::1:::1::F - Footnote end PNG:1:10:::::::3::::::::::"),
    //_T("qt:qt*:For Old Testament quoted text appearing in the New Testament (basic):1::::1::1:1:Quotation:1::qt...qt* - Special Text - Quoted Text - OT in NT:1:12::1:::::3::::::::::"),
    //_T("nd:nd*:For name of deity (basic):1::::1:::::6::nd...nd* - Special Text - Name of Deity:1:12::::1:::3::::::::::"),
    //_T("tl:tl*:For transliterated words:1::::1:::::6::tl...tl* - Special Text - Transliterated Word:1:12::1:::::3::::::::::"),
    //_T("dc:dc*:Deuterocanonical/LXX additions or insertions in the Protocanonical text:1::::1:::::6::dc...dc* - Special Text - Deuterocanonical/LXX Additions:1:12::1:::::3::::::::::"),
    //_T("bk:bk*:For the quoted name of a book:1::::1:::::6::bk...bk* - Special Text - Quoted book title:1:12::1:::::3::::::::::"),
    //_T("sig:sig*:For the signature of the author of an Epistle:1::::1:::::6::sig...sig* - Special Text - Author's Signature (Epistles):1:12::1:::::3::::::::::"),
    //_T("pn:pn*:For a proper name:1::::1:::::6::pn...pn* - Special Text - Proper Name:1:12:::1:1:::3::::::::::"),
    //_T("wj:wj*:For marking the words of Jesus:1::::1:::::1::wj...wj* - Special Text - Words of Jesus:1:12:255::::::3::::::::::"),
    //_T("k:k*:For a keyword:1::::1:::::6::k...k* - Special Text - Keyword:1:12::1:1::::3::::::::::"),
    //_T("sls:sls*:To represent where the original text is in a secondary language or from an alternate text source:1::::1:::::1::sls...sls* - Special Text - Secondary Language or Text Source:1:12::1:::::3::::::::::"),
    //_T("ord:ord*:For the text portion of an ordinal number:1::::1:::::6::ord...ord* - Special Text - Ordinal number text portion:1:12::::::1:3::::::::::"),
    //_T("add:add*:For a translational addition to the text:1::::1:1:1:1:addl material:0::add...add* - Special Text - Translational Addition:1:12::1:1::::3::::::::::"),
    //_T("no:no*:A character style, use normal text:1::::1:::::1::no...no* - Character - Normal Text:1:12:::::::3::::::::::"),
    //_T("bd:bd*:A character style, use bold text:1::::1:::::6::bd...bd* - Character - Bold Text:1:12:::1::::3::::::::::"),
    //_T("it:it*:A character style, use italic text:1::::1:::::6::it...it* - Character - Italic Text:1:12::1:::::3::::::::::"),
    //_T("bdit:bdit*:A character style, use bold + italic text:1::::1:::::6::bdit...bdit* - Character - BoldItalic Text:1:12::1:1::::3::::::::::"),
    //_T("em:em*:A character style, use emphasized text style:1::::1:::::6::em...em* - Character - Emphasized Text:1:12::1:::::3::::::::::"),
    //_T("sc:sc*:A character style, for small capitalization text:1::::1:::::6::sc...sc* - Character - Small Caps:1:12:::::1::3::::::::::"),
    //_T("pro:pro*:For indicating pronunciation in CJK texts:1::1:1:1:::::6::pro...pro* - Special Text - CJK Pronunciation:1:10:::::::3::::::::::"),
    //_T("imt::Introduction main title, level 1 (if single level) (basic):1:::1::1:1:1:intro main title:0:1:imt - Introduction - Major Title Level 1:0:14:::1::::1:8:4::::_intro_base:ip:1:1:"),
    //_T("imt1::Introduction major title, level 1 (if multiple levels):1:::1::1:1:1:intro major title L1:0:1:imt1 - Introduction - Major Title Level 1:0:14:::1::::1:8:4::::imt:ip:1:1:"),
    //_T("imt2::Introduction major title, level 2:1:::1::1:1:1:intro major title L2:0:1:imt2 - Introduction - Major Title Level 2:0:13::1:::::1:6:3::::imt1:ip:1:1:"),
    //_T("imt3::Introduction major title, level 3:1:::1::1:1:1:intro major title L3:0:1:imt3 - Introduction - Major Title Level 3:0:12:::1::::1:2:2::::imt2:ip:1:1:"),
    //_T("imt4::Introduction major title, level 4 (usually within parenthesis):1:::1::1:1:1:intro major title L4:0:1:imt4 - Introduction - Major Title Level 4:0:12::1:::::1:2:2::::imt3:ip:1:1:"),
    //_T("imte::Introduction major title at introduction end, level 1 (if single level):1:::1::1:1:1:intro major title at end:0:1:imte - Introduction - [Uncommon] Major Title at Introduction End Level 1:0:20:::1::::1:8:4::::imt:ie:::"),
    //_T("imte1::Introduction major title at introduction end, level 1 (if multiple levels):1:::1::1:1:1:intro major title at end:0:1:imte1 - Introduction - [Uncommon] Major Title at Introduction End Level 1:0:20:::1::::1:8:4::::imt:ie:::"),
    //_T("imte2::Introduction major title at introduction end, level 2:1:::1::1:1:1:intro major title at end:0:1:imte2 - Introduction - [Uncommon] Major Title at Introduction End Level 2:0:16::1:::::1:8:4::::imt:ie:::"),
    //_T("is::Introduction section heading, level 1 (if single level) (basic):1:1::1::1:1:1:intro sect head:0:1:is - Introduction - Section Heading Level 1:0:12:::1::::1:8:4::::s:ip:1:1:"),
    //_T("is1::Introduction section heading, level 1 (if multiple levels):1:::1::1:1:1:intro sect head L1:0:1:is1 - Introduction - Section Heading Level 1:0:12:::1::::1:8:4::::is:ip:1:1:"),
    //_T("is2::Introduction section heading, level 2:1:::1::1:1:1:intro sect head L2:0:1:is2 - Introduction - Section Heading Level 2:0:12:::1::::1:8:4::::is1:ip:1:1:"),
    //_T("ip::Introduction prose paragraph (basic):1:1::1::1:1:1:intro paragraph:0:1:ip - Introduction - Paragraph:0:10:::::::3:::::.125:_intro_base:ip:::"),
    //_T("ipi::Introduction prose paragraph, indented, with first line indent:1:1::1::1:1:1:intro paragraph indented:0:1:ipi - Introduction - Indented Para - first line indent:0:10:::::::3:::.25:.25:.125:ip:ipi:::"),
    //_T("ipq::Introduction prose paragraph, quote from the body text:1:::1::1:1:1:intro para quote:0:1:ipq - Introduction - Paragraph - quote from text:0:10::1:::::3:::.25:.25:.125:ip:ipq:::"),
    //_T("ipr::Introduction prose paragraph, right aligned:1:::1::1:1:1:intro para right align:0:1:ipr - Introduction - Paragraph - right aligned:0:10::1:::::2:::.25:.25::ip:ipr:::"),
    //_T("iq::Introduction poetry text, level 1 (if single level):1:1::1::1:1:1:intro poetry:0:1:iq - Introduction - Poetry Level 1:0:10::1:::::3:::1::-.75:ip:iq:::"),
    //_T("iq1::Introduction poetry text, level 1 (if multiple levels):1:::1::1:1:1:intro poetry L1:0:1:iq1 - Introduction - Poetry Level 1:0:10:::::::3:::1::-.75:iq:iq1:::"),
    //_T("iq2::Introduction poetry text, level 2:1:1::1::1:1:1:intro poetry L2:0:1:iq2 - Introduction - Poetry Level 2:0:10:::::::3:::1::-.5:iq:iq2:::"),
    //_T("iq3::Introduction poetry text, level 3:1:::1::1:1:1:intro poetry L3:0:1:iq3 - Introduction - Poetry Level 3:0:10:::::::3:::1::-.25:iq:iq3:::"),
    //_T("im::Introduction prose paragraph, with no first line indent (may occur after poetry):1:1::1::1:1:1:intro para no indent:0:1:im - Introduction - Paragraph - no first line indent:0:10:::::::3::::::ip:im:::"),
    //_T("imi::Introduction prose paragraph text, indented, with no first line indent:1:1::1::1:1:1:intro para no indent:0:1:imi - Introduction - Indented Para - no first line indent:0:10:::::::3:::.25:.25::ipi:imi:::"),
    //_T("ili::A list entry, level 1 (if single level):1:::1::1:1:1:intro list L1:0:1:ili - Introduction - List Entry - Level 1:0:12:::::::3:::.625::-.375:_list_base:ili:::"),
    //_T("ili1::A list entry, level 1 (if multiple levels):1:::1::1:1:1:intro list L1:0:1:ili1 - Introduction - List Entry - Level 1:0:12:::::::3:::.5::-.25:ili:ili1:::"),
    //_T("ili2::A list entry, level 2:1:::1::1:1:1:intro list L2:0:1:ili2 - Introduction - List Entry - Level 2:0:12:::::::3:::.75::-.25:ili1:ili2:::"),
    //_T("imq::Introduction prose paragraph, quote from the body text, with no first line indent:1:::1::1:1:1:intro para quote no indent:0:1:imq - Introduction - Paragraph - quote from text - no first line indent:0:10::1:::::3:::.25:.25::imi:imq:::"),
    //_T("ib::Introduction blank line:1::1:1::1::::0:1:ib - Introduction - Blank Line:0:12:::::::3::::::_intro_base:ib:::"),
    //_T("iot::Introduction outline title (basic):1:::1::1:1:1:intro outline title:0:1:iot - Introduction - Outline Title:0:12:::1::::1:8:4::::imt:io1:1:1:"),
    //_T("io::Introduction outline text, level 1 (if single level):1:1::1::1:1:1:intro outline:0:1:io - Introduction - Outline Level 1:0:10:::::::3:::.5:::_intro_base:io:::"),
    //_T("io1::Introduction outline text, level 1 (if multiple levels) (basic):1:1::1::1:1:1:intro outline L1:0:1:io1 - Introduction - Outline Level 1:0:10:::::::3:::.5:::io:io1:::"),
    //_T("io2::Introduction outline text, level 2:1:1::1::1:1:1:intro outline L2:0:1:io2 - Introduction - Outline Level 2:0:10:::::::3:::.75:::io1:io2:::"),
    //_T("io3::Introduction outline text, level 3:1:1::1::1:1:1:intro outline L3:0:1:io3 - Introduction - Outline Level 3:0:10:::::::3:::1:::io2:io3:::"),
    //_T("io4::Introduction outline text, level 4:1:1::1::1:1:1:intro outline L4:0:1:io4 - Introduction - Outline Level 4:0:10:::::::3:::1.25:::io3:io4:::"),
    //_T("ior:ior*:Introduction references range for outline entry; for marking references separately:1:::1:1:1::::6::ior...ior* - Introduction - Outline References Range:1:10:::::::3::::::::::"),
    //_T("iex::Introduction explanatory or bridge text (e.g. explanation of missing book in Short Old Testament):1:::1::1:1:1:intro explain text:0:1:iex - Introduction - Explanatory or Bridge Text:0:10:::::::3:4:4:::.125:ip:iex:::"),
    //_T("iqt:iqt*:For quoted scripture text appearing in the introduction:1:::1:1:1::::6::iqt...iqt* - Special Text - Quoted Scripture Text in Introduction:1:12::1:::::3::::::::::"),
    //_T("ie::Introduction ending marker:1::1:::1:1:::0::ie - Introduction - End Marker:8:12:::::::3:12:4:1.5:1.5::_intro_base:ie:::"),
    //_T("li::A list entry, level 1 (if single level):1::::::1:1:list item:1:1:li - List Entry - Level 1:0:12:::::::0:::.625::-.375:_list_base:li:::"),
    //_T("li1::A list entry, level 1 (if multiple levels):1::::::1:1:list item L1:1:1:li1 - List Entry - Level 1:0:12:::::::0:::.5::-.25:li:li1:::"),
    //_T("li2::A list entry, level 2:1::::::1:1:list item L2:1:1:li2 - List Entry - Level 2:0:12:::::::0:::.75::-.25:li1:li2:::"),
    //_T("li3::A list entry, level 3:1::::::1:1:list item L3:1:1:li3 - List Entry - Level 3:0:12:::::::0:::1::-.25:li2:li3:::"),
    //_T("li4::A list entry, level 4:1::::::1:1:list item L4:1:1:li4 - List Entry - Level 4:0:12:::::::0:::1.25::-.25:li3:li4:::"),
    //_T("qh::List or Genealogy::1:::::1:1:list item:1:1:qh - List or Genealogy:0:12:::::::0:::.625::-.375:q:qh:::"),
    //_T("tr::A new table row:1::::::1:1:table row:1:1:tr - Table - Row:0:12:::::::0:::.5::-.25:_body_text:tr:::"),
    //_T("tr1::A table Row:1::::::1:1:table row L1:1:1:OBSOLETE tr1 - Table - Row - Level 1:0:12:::::::0:::.5::-.25:tr:tr1:::"),
    //_T("tr2::A table Row:1::::::1:1:table row L2:1:1:OBSOLETE tr2 - Table - Row - Level 2:0:12:::::::0:::.75::-.25:tr1:tr2:::"),
    //_T("th1::A table heading, column 1:1::::::1:::1::th1 - Table - Column 1 Heading:1:12::1:::::0::::::::::"),
    //_T("th2::A table heading, column 2:1::::::1:::1::th2 - Table - Column 2 Heading:1:12::1:::::0::::::::::"),
    //_T("th3::A table heading, column 3:1::::::1:::1::th3 - Table - Column 3 Heading:1:12::1:::::0::::::::::"),
    //_T("th4::A table heading, column 4:1::::::1:::1::th4 - Table - Column 4 Heading:1:12::1:::::0::::::::::"),
    //_T("thr1::A table heading, column 1, right aligned:1::::::1:::1::thr1 - Table - Column 1 Heading - Right Aligned:1:12::1:::::2::::::::::"),
    //_T("thr2::A table heading, column 2, right aligned:1::::::1:::1::thr2 - Table - Column 2 Heading - Right Aligned:1:12::1:::::2::::::::::"),
    //_T("thr3::A table heading, column 3, right aligned:1::::::1:::1::thr3 - Table - Column 3 Heading - Right Aligned:1:12::1:::::2::::::::::"),
    //_T("thr4::A table heading, column 4, right aligned:1::::::1:::1::thr4 - Table - Column 4 Heading - Right Aligned:1:12::1:::::2::::::::::"),
    //_T("tc1::A table cell item, column 1:1::::::1:::1::tc1 - Table - Column 1 Cell:1:12:::::::0::::::::::"),
    //_T("tc2::A table cell item, column 2:1::::::1:::1::tc2 - Table - Column 2 Cell:1:12:::::::0::::::::::"),
    //_T("tc3::A table cell item, column 3:1::::::1:::1::tc3 - Table - Column 3 Cell:1:12:::::::0::::::::::"),
    //_T("tc4::A table cell item, column 4:1::::::1:::1::tc4 - Table - Column 4 Cell:1:12:::::::0::::::::::"),
    //_T("tcr1::A table cell item, column 1, right aligned:1::::::1:::1::tcr1 - Table - Column 1 Cell - Right Aligned:1:12:::::::2::::::::::"),
    //_T("tcr2::A table cell item, column 2, right aligned:1::::::1:::1::tcr2 - Table - Column 2 Cell - Right Aligned:1:12:::::::2::::::::::"),
    //_T("tcr3::A table cell item, column 3, right aligned:1::::::1:::1::tcr3 - Table - Column 3 Cell - Right Aligned:1:12:::::::2::::::::::"),
    //_T("tcr4::A table cell item, column 4, right aligned:1::::::1:::1::tcr4 - Table - Column 4 Cell - Right Aligned:1:12:::::::2::::::::::"),
    //_T("gm::Glossary main entry::1::1::1:1:1:glossary main entry:0:1:gm - Glossary main entry:0:12:::::::3::::::_body_text:gp:::"),
    //_T("gs::Glossary subentry::1::1::1:1:1:glossary subentry:0:1:gs - Glossary subentry:0:12:::::::3::::::gm:gp:::"),
    //_T("gd::Glossary definition::1::1:1:1:1:1:glossary definition:0:1:gd - Glossary definition:1:12:::::::3::::::::::"),
    //_T("gp::Glossary paragraph::1::1::1:1:1:glossary paragraph:0:1:gp - Glossary paragraph:0:12:::::::3::::::_body_text:gp:::"),
    //_T("tis::Topical index heading (level 1)::1::1:::1:1:topical index L1:0:1:tis - Topical index heading L1:0:12:::::::3::::::_heading_base:tpi:::"),
    //_T("tpi::Topical index heading (level 2)::1::1:::1:1:topical index L2:0:1:tpi - Topical index heading L2:0:12:::::::3::::::tis:tps:::"),
    //_T("tps::Topical index heading (level 3)::1::1:::1:1:topical index L3:0:1:tps - Topical index heading L3:0:12:::::::3::::::tpi:tir:::"),
    //_T("tir::Topical index reference::1::1:::1:1:topical index reference:0:1:tir - Topical index ref:0:12:::::::3::::::_body_text:tir:::"),
    //_T("w:w*:A wordlist text item:1::::1::1:::6::w...w* - Peripheral Ref - Wordlist Entry:1:12:::::::3::::::::::"),
    //_T("wr:wr*:A Wordlist text item:1::::1::1:::6::OBSOLETE wr...wr* - Auxiliary - Wordlist/Glossary Reference:1:12::1:::::3::::::::::"),
    //_T("wh:wh*:A Hebrew wordlist text item:1::::1::1:::6::wh...wh* - Peripheral Ref - Hebrew Wordlist Entry:1:12:::::::3::::::::::"),
    //_T("wg:wg*:A Greek Wordlist text item:1::::1::1:::6::wg...wg* - Peripheral Ref - Greek Wordlist Entry:1:12:::::::3::::::::::"),
    //_T("ndx:ndx*:A subject index text item:1::::1::1:::6::ndx...ndx* - Peripheral Ref - Subject Index Entry:1:12:::::::3::::::::::"),
    //_T("periph::Periheral content division marker which should be followed by an additional division argument/title.:1:::1:::1:1:Periph matter div:0::periph - Peripherals - Content Division Marker:0:14:33023::1::::3:16:4::::_peripherals_base:periph:::"),
    //_T("p1::Front or back matter text paragraph, level 1 (if multiple levels):1:::::1:1:1:Periph matter para L1:0:1:p1 - Periph - Front/Back Matter Paragraph Level 1:0:12:::::::3:::::.125:_peripherals_base:p1:::"),
    //_T("p2::Front or back matter text paragraph, level 2 (if multiple levels):1:::1::1:1:1:Periph matter para L2:0:1:p2 - Periph - Front/Back Matter Paragraph Level 2:0:12:::::::3:::.125::.125:_peripherals_base:p2:::"),
    //_T("k1::Concordance main entry text or keyword, level 1:1:::::1:1:1:conc main entry/keyword L1:0:1:k1 - Periph - Concordance Keyword Level 1:0:12:::::::3::::::_peripherals_base:k1:::"),
    //_T("k2::Concordance main entry text or keyword, level 2:1:::::1:1:1:conc main entry/keyword L2:0:1:k2 - Periph - Concordance Keyword Level 2:0:12:::::::3::::::_peripherals_base:k2:::"),
    //_T("xtSee:xtSee*:Concordance and Names Index markup for an alternate entry target reference.:1:::1:::1:::0::xtSee - Concordance and Names Index - Alternate Entry Target Reference:1:12:16711680:1:::::3::::::::::"),
    //_T("xtSeeAlso:xtSeeAlso*:Concordance and Names Index markup for an additional entry target reference.:1:::1:::1:::0::xtSeeAlso - Concordance and Names Index - Additional Entry Target Reference:1:12:16711680:1:::::3::::::::::"),
    //_T("pub::Front matter publication data:1:::1:::1:::0::OBSOLETE pub Peripherals - Front Matter Publication Data:0:10:::::::3::::::_peripherals_base:pub:::"),
    //_T("toc::Front matter table of contents:1:::1:::1:::0::OBSOLETE toc Peripherals - Front Matter Table of Contents:0:10:::::::3::::::_peripherals_base:toc:::"),
    //_T("toc1::Long table of contents text:1:::1:::1:::0::toc1 - File - Long Table of Contents Text:0:12:16384:1:1::::3::::::_peripherals_base:toc1:::"),
    //_T("toc2::Short table of contents text:1:::1:::1:::0::toc2 - File - Short Table of Contents Text:0:12:16384:1:::::3::::::_peripherals_base:toc2:::"),
    //_T("toc3::Book Abbreviation:1:::1:::1:::0::toc3 - File - Book Abbreviation:0:12:128:1:1::::3::::::_peripherals_base:toc3:::"),
    //_T("pref::Front matter preface:1:::1:::1:::0::OBSOLETE pref Peripherals - Front Matter Preface:0:10:::::::3::::::_peripherals_base:pref:::"),
    //_T("intro::Front matter introduction:1:::1:::1:::0::OBSOLETE intro Peripherals - Front Matter Introduction:0:10:::::::3::::::_peripherals_base:intro:::"),
    //_T("conc::Back matter concordance:1:::1:::1:::0::OBSOLETE conc Peripherals - Back Matter Concordance:0:10:::::::3::::::_peripherals_base:conc:::"),
    //_T("glo::Back matter glossary:1:::1:::1:::0::OBSOLETE glo Peripherals - Back Matter Glossary:0:10:::::::3::::::_peripherals_base:glo:::"),
    //_T("idx::Back matter index:1:::1:::1:::0::OBSOLETE idx Peripherals - Back Matter Index:0:10:::::::3::::::_peripherals_base:idx:::"),
    //_T("maps::Back matter map index:1:::1:::1:::0::OBSOLETE maps Peripherals - Back Matter Map Index:0:10:::::::3::::::_peripherals_base:maps:::"),
    //_T("cov::Other peripheral materials - cover:1:::1:::1:::0::OBSOLETE cov Peripherals - Other - Cover:0:10:::::::3::::::_peripherals_base:cov:::"),
    //_T("spine::Other peripheral materials - spine:1:::1:::1:::0::OBSOLETE spine Peripherals - Other - Spine:0:10:::::::3::::::_peripherals_base:spine:::"),
    //_T("pubinfo::Publication information - Lang,Credit,Version,Copies,Publisher,Id,Logo:1:::1:::1:::0::OBSOLETE pubinfo - Publication - Information:0:12:16711680::::::3::::::__normal:pubinfo:::"),
    //_T("pb::Page Break used for new reader portions and children's bibles where content is controlled by the page:1::::::1:1:new page:0:1:pb - Break - Page Break:0:12:::::::3::::::p:p:::"),
    //_T("b::Poetry text stanza break (e.g. stanza break) (basic):1::::::1:1:stanza break:2::b - Poetry - Stanza Break (Blank Line):0:12:::::::0::::::_body_text:b:::"),
    //_T("hr::Horizontal rule::1:1:::1:1:::0::hr - Horizontal rule:8:12:::::::3:4:4::::_body_text:hr:::"),
    //_T("fig:fig*:Illustration [Columns to span, height, filename, caption text]:1::1:1:1::1:::0::fig...fig* - Auxiliary - Figure/Illustration/Map:1:12:::::::3::::::::::"),
    //_T("loc::Picture location::1:1::::1:::0::loc - Picture location:0:12:::::::3::::::_body_text:loc:::"),
    //_T("cap::Picture caption::1:1:1::1:1:1:picture caption:0::cap - Picture caption:0:12:::::::3::::::_body_text:cap:::"),
    //_T("cat::Picture catalog number::1:1::::1:::0::cat - Picture catalog number:0:12:::::::3::::::_body_text:cat:::"),
    //_T("des::Picture description::1:1::::1:::0::des - Picture description:0:12:::::::3::::::_body_text:des:::"),
    //_T("px::Paragraph extra 1::1:::::1:1:para extra 1:1:1:px - Paragraph extra 1:0:12:::::::3::::::p:px:::"),
    //_T("pz::Paragraph extra 2::1:::::1:1:para extra 2:1:1:pz - Paragraph extra 2:0:12:::::::3::::::p:pz:::"),
    //_T("qx::Poetry extra 1::1:::::1:1:poetry extra 1:2:1:qx - Poetry extra 1:0:12:::::::3::::::q:qx:::"),
    //_T("qz::Poetry extra 2::1:::::1:1:poetry extra 2:2:1:qz - Poetry extra 2:0:12:::::::3::::::q:qz:::"),
    //_T("addpn:addpn*:For chinese words to be dot underline and underline:1::::1::1:::1::(addpn...addpn*) - Special Text for Chinese:1:12::1:1:1:::3::::::::::"),
    //_T("efm:efm*:ID or Caller for an extended (study) note. Used within a source project duplicte (target) text when autoring study material.:1::1:::1:1:::0::efm - Study Note - ID/Caller:1:10:255::1::::3::::::::::"),
    //_T("ef:ef*:A Study Note text item:1::1:::1:1:::0::ef...ef* - Study Note:1:12:::::::3::::::::::"),
    //_T("bt::Back-translation (and all \bt... initial forms):1:1:1:::1::1:back-trans:0::bt - Back-translation:1:11:16711680::::::3::::::::::"),
    //_T("free:free*:Free translation:1:1:1:::1::1:free-trans:0::free - Free translation:1:11:4194500::::::3::::::::::"),
    //_T("note:note*:Adapt It note:1:1:1:::1::1:note:0::note - Adapt It note:1:10:16711680::::::3::::::::::"),
    //_T("__normal::Normal:1:1:1:::::::0::Normal:0:11:::::::3:::::::__normal:::"),
    //_T("_src_lang_interlinear::Source Language Interlinear Text:1:1:1:::::::0::Source Language:0:11:::::::0::::::__normal:_src_lang_interlinear::1:"),
    //_T("_tgt_lang_interlinear::Target Language Interlinear Text:1:1:1:::::::0::Target Language:0:11:::::::0::::::__normal:_tgt_lang_interlinear::1:"),
    //_T("_gls_lang_interlinear::Gloss Language Interlinear Text:1:1:1:::::::0::Gloss Language:0:11:::::::0::::::__normal:_gls_lang_interlinear::1:"),
    //_T("_nav_lang_interlinear::Navigation Language Interlinear Text:1:1:1:::::::0::Navigation Language:0:11:::::::0::::::__normal:_nav_lang_interlinear::1:"),
    //_T("_hdr_ftr_interlinear::Header-Footer Interlinear Text:1:1:1:::::::0::Hdr-Ftr Interlinear:7:9:::::::0::::::__normal:_hdr_ftr_interlinear:::"),
    //_T("_small_para_break::Small Paragraph Break:1:1:1:::::::0::Small Para Break:0:4:::::::3::::::__normal:_small_para_break:::"),
    //_T("_body_text::Body Text:1:1:1:::::::0::_BodyText_Base:0:11:::::::3::::::_vernacular_base:_body_text:::"),
    //_T("_heading_base::Heading Base:1:1:1:::1::::0::_Heading_Base:0:12:::::::1:6::.1:.1::_vernacular_base:_heading_base:1:1:"),
    //_T("_intro_base::Intro Base:1:1:1:::1::::0::_Intro_Base:0:11::1:::::3::::::_vernacular_base:_intro_base:::"),
    //_T("_list_base::List Base:1:1:1:::1::::0::_List_Base:0:12:::::::3::::::_vernacular_base:_list_base:::"),
    //_T("_notes_base::Notes Base:1:1:1:::1::::0::_Notes_Base:0:9:::::::0::::::_vernacular_base:_notes_base:::"),
    //_T("_peripherals_base::Peripherals Base:1:1:1:::1::::0::_Peripherals_Base:0:10:::::::3::::::_vernacular_base:_peripherals_base:::"),
    //_T("_vernacular_base::Vernacular Base:1:1:1:::::::0::_Vernacular_Base:0:11:::::::3::::::__normal:_vernacular_base:::"),
    //_T("_annotation_ref::Annotation Reference:1:1:1:::::::0::_annotation_reference:1:10:4210943:::::1:0::::::::::"),
    //_T("_annotation_text::Annotation Text:1:1:1:::::::0::_annotation_text:0:10:::::::0::::::__normal:_annotation_text:::"),
    //_T("_dft_para_font::Default Paragraph Font:1:1:1:::::::0::Default Paragraph Font:5:10:::::::3::::::::::"),
    //_T("_footnote_caller::Footnote Caller:1:1:1:::::::0::Footnote Caller:3:10:16711680:::::1:3::::::::::"),
    //_T("_normal_table::Normal Table:1:1:1:::::::0::Normal Table:2:10:::::::0:::::::_normal_table:::"),
    //_T("_table_grid::Table Grid:1:1:1:::::::0::Table Grid:2:10:::::::0::::::_normal_table:_table_grid:::"),
    //_T("_footer::Footer:1:1:1:::::::0::footer:6:10:::::::0::::::_body_text:_footer:::"),
    //_T("_header::Header:1:1:1:::::::0::header:7:9:::::::0::::::_body_text:_header:::"),
    //_T("_horiz_rule::Horizontal Rule:1:1:1:::::::0::Horizontal rule:8:10:::::::3:::::::_horiz_rule:::"),
    //_T("_single_boxed_para::Single Boxed Paragraph:1:1:1:::::::0::Single Boxed Paragraph:9:10:::::::3::::::__normal:_single_boxed_para:::"),
    //_T("_double_boxed_para::Double Boxed Paragraph:1:1:1:::::::0::Double Boxed Paragraph:9:10:::::::3::::::__normal:_double_boxed_para:::"),
    //_T("_unknown_para_style::Unknown Paragraph Style Marker:1:1:1:::::::0::Unknown Para Style Marker:0:12:255::::::0::::::_body_text:_unknown_para_style:::"),
    //_T("_unknown_char_style::Unknown Character Style Marker:1:1:1:::::::0::Unknown Char Style Marker:1:12:255::::::0::::::::::"),
    //_T("_hidden_note::Hidden Note:1:1:1:::::::0::Hidden Note:10:10:8388608:1:::::3:2::::.3:p:_hidden_note:::")
};

/// The actual count of default Unix-style strings contained in the defaultSFM string
/// array. This number is calculated dynamically here, but is also calculated by
/// uncommenting the #define Output_Default_Style_Strings line at the beginning of XML.h
/// file (see instructions in documentation for the defaultSFM[] string array). The number
/// is automatically produced as the last line of string output written to AI_USFM_full.txt
/// file when Output_Default_Style_Strings is defined in XML.h.
const int gnDefaultSFMs = sizeof(defaultSFM) / sizeof(wxString); // In version 4.1.3 the
                                                                 // gnDefaultSFMs value is 283, but it will change as UBS adds markers to USFM

                                                                 // whm added 10Sep10
                                                                 /// An array of wxStrings which, when parsed by SetupDefaultUserProfiles(), is used as
                                                                 /// default list of User Workflow Profile dialog item definitions. There definitions are
                                                                 /// used only if, for some reason, the program cannot find the AI_UserProfiles.xml control
                                                                 /// file.
const wxString defaultProfileItems[] =
{
    // Note: In the strings below, the itemText field must use the & ALT-key shortcut as well as the
    // accelerator substrings, i.e., \tCtrl-A. However, since this is not xml, we don't use any
    // xml "entities", i.e., &amp; &lt; or &gt; for '&', '<' and '>' within the itemText strings.
    // Since the descriptionProfileN strings are administrator editable, it is possible that an administrator
    // might edit into the string one of the entity characters '<', '>', '&', ''', or '"'. While these
    // strings are internal within the program we retain their character representations in order to
    // facilitate accurate comparisons of the descriptionProfileN strings. When the descriptionProfileN
    // string data is about to be written to xml, however, we replace the entitity chars with their xml
    // entity representations.
    //
    // The ReportMenuAndUserProfilesInconsistencies() function compares the data
    // stored in the m_pUserProfiles struct on the heap with those that are used in the
    // defaultProfileItems string array below. It uses wxLogDebug() calls and even an assert
    // in some cases to alert the programmer of any significant differences/inconsistencies.
    //
    // whm 6Jan12 Note: Changed the version number in the first string of the defaultProfileItems[]
    // array below to use the appVerStr constant defined near the beginning of the Adapt_It.h file.
    _T("UserProfilesSupport:profileVersion=\"1.0\":applicationCompatibility=\"") + appVerStr + _T("\":adminModified=\"No\"")
    _T(":definedProfile1=\"Novice\":descriptionProfile1=\"The Novice profile hides most of the menu items and other interface items that are not needed for basic adaptation work. The default Novice profile can be further customized to suit the preferences of the administrator.\"")
    _T(":definedProfile2=\"Experienced\":descriptionProfile2=\"The Experienced profile hides a number of menu items, but makes visible consistency checking, restoring the KB, packing/unpacking of documents and all export possibilities. The default Experienced profile can be further customized to suit the preferences of the administrator.\"")
    _T(":definedProfile3=\"Skilled\":descriptionProfile3=\"The Skilled profile hides a few menu items, but makes visible all the Experienced user items plus free translation mode, glossing mode, editing of the source text, and all the Preferences tab pages. The default Skilled profile can be further customized to suit the preferences of the administrator.\"")
    _T(":definedProfile4=\"Custom\":descriptionProfile4=\"The Custom profile can use one of the other profiles as a starting point and further customize the Custom profile to suit the preferences of the administrator.\":"),
    _T("MENU:itemID=\"ID_SAVE_AS\":itemType=\"subMenu\":itemText=\"Save &As...\tCtrl-A\":itemDescr=\"File menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_FILE_PACK_DOC\":itemType=\"subMenu\":itemText=\"Pack Document...\":itemDescr=\"File menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_FILE_UNPACK_DOC\":itemType=\"subMenu\":itemText=\"Unpack Document...\":itemDescr=\"File menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_FILE_CHANGEFOLDER\":itemType=\"subMenu\":itemText=\"Change Folder...\":itemDescr=\"File menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_FILE_BACKUP_KB\":itemType=\"subMenu\":itemText=\"&Backup Knowledge Base\":itemDescr=\"File menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_EDIT_SOURCE_TEXT\":itemType=\"subMenu\":itemText=\"Edit &Source Text...\":itemDescr=\"Edit menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_EDIT_CONSISTENCY_CHECK\":itemType=\"subMenu\":itemText=\"Consist&ency Check...\":itemDescr=\"Edit menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_MENU_CHANGE_USERNAME\":itemType=\"subMenu\":itemText=\"Change User&name...\":itemDescr=\"Edit menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_EDITMENU_CHANGE_PUNCTS_MKRS_PLACE\":itemType=\"subMenu\":itemText=\"Change Punctuation or Markers Placement\":itemDescr=\"Edit menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_EDIT_MOVE_NOTE_FORWARD\":itemType=\"subMenu\":itemText=\"Move Note Forward\tCtrl-3\":itemDescr=\"Edit menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_EDIT_MOVE_NOTE_BACKWARD\":itemType=\"subMenu\":itemText=\"Move Note Backward\tCtrl-2\":itemDescr=\"Edit menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_VIEW_TOOLBAR\":itemType=\"subMenu\":itemText=\"&Toolbar\":itemDescr=\"View menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_VIEW_MODE_BAR\":itemType=\"subMenu\":itemText=\"&Mode Bar\":itemDescr=\"View menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_VIEW_STATUS_BAR\":itemType=\"subMenu\":itemText=\"&Status Bar\":itemDescr=\"View menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_COPY_SOURCE\":itemType=\"subMenu\":itemText=\"Copy Sourc&e\":itemDescr=\"View menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_SELECT_COPIED_SOURCE\":itemType=\"subMenu\":itemText=\"Se&lect Copied Source\":itemDescr=\"View menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_MARKER_WRAPS_STRIP\":itemType=\"subMenu\":itemText=\"&Wrap At Standard Format Markers\":itemDescr=\"View menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_UNITS\":itemType=\"subMenu\":itemText=\"&Units of Measurement...\":itemDescr=\"View menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_CHANGE_INTERFACE_LANGUAGE\":itemType=\"subMenu\":itemText=\"Change Interface Language...\":itemDescr=\"View menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"wxID_REPLACE\":itemType=\"subMenu\":itemText=\"Find and &Replace...\tCtrl-H\":itemDescr=\"Tools menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_TOOLS_CLIPBOARD_ADAPT\":itemType=\"subMenu\":itemText=\"A&dapt Clipboard Text\tCtrl-7\":itemDescr=\"Tools menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_TOOLS_DEFINE_CC\":itemType=\"subMenu\":itemText=\"&Load Consistent Changes...\":itemDescr=\"Tools menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_UNLOAD_CC_TABLES\":itemType=\"subMenu\":itemText=\"&Unload Consistent Changes\":itemDescr=\"Tools menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_USE_CC\":itemType=\"subMenu\":itemText=\"Use &Consistent Changes\":itemDescr=\"Tools menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_ACCEPT_CHANGES\":itemType=\"subMenu\":itemText=\"&Accept Changes Without Stopping\":itemDescr=\"Tools menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_TOOLS_DEFINE_SILCONVERTER\":itemType=\"subMenu\":itemText=\"&SIL Converters...\":itemDescr=\"Tools menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_USE_SILCONVERTER\":itemType=\"subMenu\":itemText=\"Use S&IL Converter\":itemDescr=\"Tools menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_TOOLS_KB_EDITOR\":itemType=\"subMenu\":itemText=\"&Knowledge Base Editor...\tCtrl-K\":itemDescr=\"Tools menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_TOOLS_AUTO_CAPITALIZATION\":itemType=\"subMenu\":itemText=\"Use Automatic Ca&pitalization\":itemDescr=\"Tools menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_MENU_UPPER_AVAIL\":itemType=\"subMenu\":itemText=\"Make All Knowledge Base Entries Available\":itemDescr=\"Tools menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_TOOLS_SPLIT_DOC\":itemType=\"subMenu\":itemText=\"Split Document...\":itemDescr=\"Tools menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_TOOLS_JOIN_DOCS\":itemType=\"subMenu\":itemText=\"Join Documents...\":itemDescr=\"Tools menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_TOOLS_MOVE_DOC\":itemType=\"subMenu\":itemText=\"Move Document...\":itemDescr=\"Tools menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_TOOLS_INSTALL_GIT\":itemType=\"subMenu\":itemText=\"Install the Git program...\":itemDescr=\"Tools menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_FILE_EXPORT_SOURCE\":itemType=\"subMenu\":itemText=\"Export &Source Text...\":itemDescr=\"Export-Import menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_FILE_EXPORT\":itemType=\"subMenu\":itemText=\"&Export Translation Text...\":itemDescr=\"Export-Import menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_FILE_EXPORT_TO_RTF\":itemType=\"subMenu\":itemText=\"Export Interlinear &Text...\":itemDescr=\"Export-Import menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_EXPORT_GLOSSES\":itemType=\"subMenu\":itemText=\"Export &Glosses As Text...\":itemDescr=\"Export-Import menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_EXPORT_FREE_TRANS\":itemType=\"subMenu\":itemText=\"Export &Free Translation...\":itemDescr=\"Export-Import menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    // whm commented out 15Jun11 as per Bruce's request. OXES support not implemented until a future date
    // BEW repurposed 9Jun12, for XHTML support
    // BEW 28July12 removed Export XHTML... menu item, it's now accessible via src, tgt,
    // glosses or free translation exports
    //_T("MENU:itemID=\"ID_EXPORT_XHTML\":itemType=\"subMenu\":itemText=\"Export &XHTML...\":itemDescr=\"Export-Import menu\":adminCanChange=\"1\":"),
    //_T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    //_T("/PROFILE:"),
    //_T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"0\":factory=\"0\":"),
    //_T("/PROFILE:"),
    //_T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    //_T("/PROFILE:"),
    //_T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    //_T("/PROFILE:"),
    //_T("/MENU:"),
    _T("MENU:itemID=\"ID_FILE_EXPORT_KB\":itemType=\"subMenu\":itemText=\"Export Knowledge &Base...\":itemDescr=\"Export-Import menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_IMPORT_TO_KB\":itemType=\"subMenu\":itemText=\"&Import to Knowledge Base...\":itemDescr=\"Export-Import menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_MENU_IMPORT_EDITED_SOURCE_TEXT\":itemType=\"subMenu\":itemText=\"Imp&ort Edited Source Text...\":itemDescr=\"Export-Import menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_ADVANCED_SEE_GLOSSES\":itemType=\"subMenu\":itemText=\"&See Glosses\":itemDescr=\"Advanced menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_ADVANCED_GLOSSING_USES_NAV_FONT\":itemType=\"subMenu\":itemText=\"Glossing Uses &Navigation Text's Font\":itemDescr=\"Advanced menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_ADVANCED_TRANSFORM_ADAPTATIONS_INTO_GLOSSES\":itemType=\"subMenu\":itemText=\"Transform &Adaptations Into Glosses...\":itemDescr=\"Advanced menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_ADVANCED_DELAY\":itemType=\"subMenu\":itemText=\"&Delay...\":itemDescr=\"Advanced menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_ADVANCED_BOOKMODE\":itemType=\"subMenu\":itemText=\"Storing Documents in &Book Folders\":itemDescr=\"Advanced menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_ADVANCED_FREE_TRANSLATION_MODE\":itemType=\"subMenu\":itemText=\"&Free Translation Mode\":itemDescr=\"Advanced menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_ADVANCED_TARGET_TEXT_IS_DEFAULT\":itemType=\"subMenu\":itemText=\"Use &Target Text As Default Free Translation\":itemDescr=\"Advanced menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_ADVANCED_GLOSS_TEXT_IS_DEFAULT\":itemType=\"subMenu\":itemText=\"Use &Gloss Text As Default Free Translation\":itemDescr=\"Advanced menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_ADVANCED_REMOVE_FILTERED_FREE_TRANSLATIONS\":itemType=\"subMenu\":itemText=\"&Remove Free Translations\":itemDescr=\"Advanced menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_ADVANCED_COLLECT_BACKTRANSLATIONS\":itemType=\"subMenu\":itemText=\"Collect Back Translations...\":itemDescr=\"Advanced menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_ADVANCED_REMOVE_FILTERED_BACKTRANSLATIONS\":itemType=\"subMenu\":itemText=\"Remove Back Translations\":itemDescr=\"Advanced menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_ADVANCED_USETRANSLITERATIONMODE\":itemType=\"subMenu\":itemText=\"&Use Transliteration Mode\":itemDescr=\"Advanced menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_ADVANCED_SENDSYNCHRONIZEDSCROLLINGMESSAGES\":itemType=\"subMenu\":itemText=\"Send Synchronized Scrolling Messages\":itemDescr=\"Advanced menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_ADVANCED_RECEIVESYNCHRONIZEDSCROLLINGMESSAGES\":itemType=\"subMenu\":itemText=\"Receive Synchronized Scrolling Messages\":itemDescr=\"Advanced menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_ADVANCED_PROTECT_EDITOR_FM__GETTING_CHANGES_FOR_THIS_DOC\":itemType=\"subMenu\":itemText=\"&Prevent Paratext/Bibledit from getting changes to this document\":itemDescr=\"Advanced menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_ADVANCED_ALLOW_EDITOR_TO_GET_CHANGES_FOR_THIS_DOC\":itemType=\"subMenu\":itemText=\"Allo&w Paratext/Bibledit to get changes to this document\":itemDescr=\"Advanced menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_MENU_SHOW_KBSERVER_SETUP_DLG\":itemType=\"subMenu\":itemText=\"Setup Or Remove &Knowledge Base Sharing...\":itemDescr=\"Advanced menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_MENU_SHOW_KBSERVER_DLG\":itemType=\"subMenu\":itemText=\"&Controls For Knowledge Base Sharing...\":itemDescr=\"Advanced menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_ALIGNMENT\":itemType=\"subMenu\":itemText=\"Layout Window Right To Left\tCtrl-1\":itemDescr=\"Layout menu\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_NONE\":itemType=\"preferencesTab\":itemText=\"Fonts\":itemDescr=\"Tab in Preferences dialog\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_NONE\":itemType=\"preferencesTab\":itemText=\"Backups and Misc\":itemDescr=\"Tab in Preferences dialog\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_NONE\":itemType=\"preferencesTab\":itemText=\"Auto-Saving\":itemDescr=\"Tab in Preferences dialog\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_NONE\":itemType=\"preferencesTab\":itemText=\"Punctuation\":itemDescr=\"Tab in Preferences dialog\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_NONE\":itemType=\"preferencesTab\":itemText=\"Toolbar\":itemDescr=\"Tab in Preferences dialog\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_NONE\":itemType=\"preferencesTab\":itemText=\"Case\":itemDescr=\"Tab in Preferences dialog\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_NONE\":itemType=\"preferencesTab\":itemText=\"Units\":itemDescr=\"Tab in Preferences dialog\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_NONE\":itemType=\"preferencesTab\":itemText=\"USFM and Filtering\":itemDescr=\"Tab in Preferences dialog\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"IDC_CHECK_SINGLE_STEP\":itemType=\"modeBar\":itemText=\"Automatic\":itemDescr=\"Checkbox in Modebar\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"IDC_CHECK_FORCE_ASK\":itemType=\"modeBar\":itemText=\"Force Choice For This Item\":itemDescr=\"Checkbox in Modebar\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"IDC_EDIT_DELAY\":itemType=\"modeBar\":itemText=\"Delay\":itemDescr=\"Text box in mode bar\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"IDC_CHECK_ISGLOSSING\":itemType=\"modeBar\":itemText=\"Glossing\":itemDescr=\"Checkbox in Modebar\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_BUTTON_DELETE_ALL_NOTES\":itemType=\"toolBar\":itemText=\"Delete All Notes\":itemDescr=\"Delete all the notes currently in the document\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_EDIT_CUT\":itemType=\"toolBar\":itemText=\"Cu&t\tCtrl-X\":itemDescr=\"Cut the selection and put it on the Clipboard\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_EDIT_COPY\":itemType=\"toolBar\":itemText=\"&Copy\tCtrl-C\":itemDescr=\"Copy the selection and put it on the Clipboard\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_EDIT_PASTE\":itemType=\"toolBar\":itemText=\"&Paste\tCtrl-V\":itemDescr=\"Insert Clipboard contents\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"wxID_PRINT\":itemType=\"toolBar\":itemText=\"&Print...\tCtrl-P\":itemDescr=\"Print the active document\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"wxID_HELP\":itemType=\"toolBar\":itemText=\"&Help Topics\tShift-Ctrl-/\":itemDescr=\"Display Adapt It program help topics\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("MENU:itemID=\"ID_NONE\":itemType=\"wizardListItem\":itemText=\"<New Project>\":itemDescr=\"First List Item in Choose A Project page of Wizard\":adminCanChange=\"1\":"),
    _T("PROFILE:userProfile=\"Novice\":itemVisibility=\"0\":factory=\"0\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Experienced\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Skilled\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("PROFILE:userProfile=\"Custom\":itemVisibility=\"1\":factory=\"1\":"),
    _T("/PROFILE:"),
    _T("/MENU:"),
    _T("/UserProfilesSupport:")
};

// whm 26Apr11 added wxString arrays below for AI-PT collaboration
// Array of all book ids. (from Paratext's canon.cs source file)
wxString AllBookIds[] = {
    _T("GEN"), // 1 (array index 0)
    _T("EXO"),
    _T("LEV"),
    _T("NUM"),
    _T("DEU"),
    _T("JOS"),
    _T("JDG"),
    _T("RUT"),
    _T("1SA"),
    _T("2SA"), // 10 (array index 9)

    _T("1KI"),
    _T("2KI"),
    _T("1CH"),
    _T("2CH"),
    _T("EZR"),
    _T("NEH"),
    _T("EST"),
    _T("JOB"),
    _T("PSA"),
    _T("PRO"), // 20 (array index 19)

    _T("ECC"),
    _T("SNG"),
    _T("ISA"),
    _T("JER"),
    _T("LAM"),
    _T("EZK"),
    _T("DAN"),
    _T("HOS"),
    _T("JOL"),
    _T("AMO"), // 30 (array index 29)

    _T("OBA"),
    _T("JON"),
    _T("MIC"),
    _T("NAM"),
    _T("HAB"),
    _T("ZEP"),
    _T("HAG"),
    _T("ZEC"),
    _T("MAL"),
    _T("MAT"), // 40 (array index 39)

    _T("MRK"),
    _T("LUK"),
    _T("JHN"),
    _T("ACT"),
    _T("ROM"),
    _T("1CO"),
    _T("2CO"),
    _T("GAL"),
    _T("EPH"),
    _T("PHP"), // 50 (array index 49)

    _T("COL"),
    _T("1TH"),
    _T("2TH"),
    _T("1TI"),
    _T("2TI"),
    _T("TIT"),
    _T("PHM"),
    _T("HEB"),
    _T("JAS"),
    _T("1PE"), // 60 (array index 59)

    _T("2PE"),
    _T("1JN"),
    _T("2JN"),
    _T("3JN"),
    _T("JUD"),
    _T("REV"),
    _T("TOB"),
    _T("JDT"),
    _T("ESG"),
    _T("WIS"), // 70 (array index 69)

    _T("SIR"),
    _T("BAR"),
    _T("LJE"),
    _T("S3Y"),
    _T("SUS"),
    _T("BEL"),
    _T("1MA"),
    _T("2MA"),
    _T("3MA"),
    _T("4MA"), // 80 (array index 79)

    _T("1ES"),
    _T("2ES"),
    _T("MAN"),
    _T("PS2"),
    _T("ODA"),
    _T("PSS"),
    _T("JSA"),  // actual variant text for JOS, now in LXA text
    _T("JDB"),  // actual variant text for JDG, now in LXA text
    _T("TBS"),  // actual variant text for TOB, now in LXA text
    _T("SST"),  // actual variant text for SUS, now in LXA text // 90 (array index 89)

    _T("DNT"),  // actual variant text for DAN, now in LXA text
    _T("BLT"),  // actual variant text for BEL, now in LXA text
    _T("XXA"),
    _T("XXB"),
    _T("XXC"),
    _T("XXD"),
    _T("XXE"),
    _T("XXF"),
    _T("XXG"),
    _T("FRT"), // 100 (array index 99)

    _T("BAK"),
    _T("OTH"),
    _T("3ES"),   // Used previously but really should be 2ES
    _T("EZA"),   // Used to be called 4ES, but not actually in any known project
    _T("5EZ"),   // Used to be called 5ES, but not actually in any known project
    _T("6EZ"),   // Used to be called 6ES, but not actually in any known project
    _T("INT"),
    _T("CNC"),
    _T("GLO"),
    _T("TDX"), // 110 (array index 109)

    _T("NDX"),
    _T("DAG"),
    _T("PS3"),
    _T("2BA"),
    _T("LBA"),
    _T("JUB"),
    _T("ENO"),
    _T("1MQ"),
    _T("2MQ"),
    _T("3MQ"), // 120 (array index 119)

    _T("REP"),
    _T("4BA"),
    _T("LAO"), // 123 (array index 122)
};

// Note: In the AllBookNumStr[] array below, the string numbers do not correlate with array indices!
// This array is parallel to the array above called AllBookIds[] containing 3-letter book IDs/abbreviations,
// therefore, upon locating a book ID in AllBookIds, its array index can be used into the AllBookNumStr[]
// array to determine its book number string - useful mainly for determining the <FileNameBookNameForm>
// that Paratext assigns/uses (in Settings.xml) to that Scripture book in the project's naming scheme.
// The book numbers in AllBookNumStr[] are not zero based and skip number 40 between OT and NT; decimal counts end at 87
// whm modified 23March2017 to update/correct some misc book filename digits to conform to
// what Tom H said it their current practice. Previously some elements below had "$$" as the "number"
wxString AllBookNumStr[] = {
    _T("01"), // GEN
    _T("02"), // EXO
    _T("03"), // LEV
    _T("04"), // NUM
    _T("05"), // DEU
    _T("06"), // JOS
    _T("07"), // JDG
    _T("08"), // RUT
    _T("09"), // 1SA
    _T("10"), // 2SA

    _T("11"), // 1KI
    _T("12"), // 2KI
    _T("13"), // 1CH
    _T("14"), // 2CH
    _T("15"), // EZR
    _T("16"), // NEH
    _T("17"), // EST
    _T("18"), // JOB
    _T("19"), // PSA
    _T("20"), // PRO

    _T("21"), // ECC
    _T("22"), // SNG
    _T("23"), // ISA
    _T("24"), // JER
    _T("25"), // LAM
    _T("26"), // EZK
    _T("27"), // DAN
    _T("28"), // HOS
    _T("29"), // JOL
    _T("30"), // AMO

    _T("31"), // OBA
    _T("32"), // JON
    _T("33"), // MIC
    _T("34"), // NAM
    _T("35"), // HAB
    _T("36"), // ZEP
    _T("37"), // HAG
    _T("38"), // ZEC
    _T("39"), // MAL
    _T("41"), // MAT // Note: MAT starts with 41 instead of 40

    _T("42"), // MRK
    _T("43"), // LUK
    _T("44"), // JHN
    _T("45"), // ACT
    _T("46"), // ROM
    _T("47"), // 1CO
    _T("48"), // 2CO
    _T("49"), // GAL
    _T("50"), // EPH
    _T("51"), // PHP

    _T("52"), // COL
    _T("53"), // 1TH
    _T("54"), // 2TH
    _T("55"), // 1TI
    _T("56"), // 2TI
    _T("57"), // TIT
    _T("58"), // PHM
    _T("59"), // HEB
    _T("60"), // JAS
    _T("61"), // 1PE

    _T("62"), // 2PE
    _T("63"), // 1JN
    _T("64"), // 2JN
    _T("65"), // 3JN
    _T("66"), // JUD
    _T("67"), // REV
    _T("68"), // TOB
    _T("69"), // JDT
    _T("70"), // ESG
    _T("71"), // WIS

    _T("72"), // SIR
    _T("73"), // BAR
    _T("74"), // LJE
    _T("75"), // S3Y
    _T("76"), // SUS
    _T("77"), // BEL
    _T("78"), // 1MA
    _T("79"), // 2MA
    _T("80"), // 3MA
    _T("81"), // 4MA

    _T("82"), // 1ES
    _T("83"), // 2ES
    _T("84"), // MAN
    _T("85"), // PS2
    _T("86"), // ODA
    _T("87"), // PSS
    // whm modified 23March2017 to update/correct the following book filename digits to conform to
    // what Tom H said it their current practice. Previously some elements below had "$$" as the "number"
    _T("88"), // JSA // actual variant text for JOS, now in LXA text
    _T("89"), // JDB // actual variant text for JDG, now in LXA text
    _T("90"), // TBS // actual variant text for TOB, now in LXA text
    _T("91"), // SST // actual variant text for SUS, now in LXA text // 90

    _T("92"), // DNT // actual variant text for DAN, now in LXA text
    _T("93"), // BLT // actual variant text for BEL, now in LXA text
    _T("94"), // XXA
    _T("95"), // XXB
    _T("96"), // XXC
    _T("97"), // XXD
    _T("98"), // XXE
    _T("99"), // XXF
    _T("100"), // XXG
    _T("A0"), // FRT

    _T("A1"), // BAK
    _T("A2"), // OTH
    _T("A3"), // 3ES  // Used previously but really should be 2ES
    _T("A4"), // EZA  // Used to be called 4ES, but not actually in any known project
    _T("A5"), // 5EZ  // Used to be called 5ES, but not actually in any known project
    _T("A6"), // 6EZ  // Used to be called 6ES, but not actually in any known project
    _T("A7"), // INT
    _T("A8"), // CNC
    _T("A9"), // GLO
    _T("B0"), // TDX

    _T("B1"), // NDX
    _T("B2"), // DAG
    _T("B3"), // PS3
    _T("B4"), // 2BA
    _T("B5"), // LBA
    _T("B6"), // JUB
    _T("B7"), // ENO
    _T("B8"), // 1MQ
    _T("B9"), // 2MQ
    _T("C0"), // 3MQ

    _T("C1"), // REP
    _T("C2"), // 4BA
    _T("C3"), // LAO
};



// Array of the English names of all books - from Paratext source
// Verified and modified from code snippets provided by Tom H. on 27April2017
// Categories/Subsections:
//    All Books: array index 0 ... 122
//    OT Books: array index 0 ... 38
//    NT Books: array index 39 ... 65
//    DC Books: array index 66 ... 85, 103 ... 105, 111 ... 122;  Bibledit only recognizes: array index 66 ... 71, 76 ... 77
wxString AllBookNames[] = {
    _T("Genesis"), // array index 0
    _T("Exodus"),
    _T("Leviticus"),
    _T("Numbers"),
    _T("Deuteronomy"),
    _T("Joshua"),
    _T("Judges"),
    _T("Ruth"),
    _T("1 Samuel"),
    _T("2 Samuel"), // array index 9

    _T("1 Kings"),
    _T("2 Kings"),
    _T("1 Chronicles"),
    _T("2 Chronicles"),
    _T("Ezra"),
    _T("Nehemiah"),
    _T("Esther (Hebrew)"), // Bibledit uses "Esther"
    _T("Job"),
    _T("Psalms"),
    _T("Proverbs"), // array index 19

    _T("Ecclesiastes"),
    _T("Song of Songs"), // Bibledit uses "Song of Solomon"
    _T("Isaiah"),
    _T("Jeremiah"),
    _T("Lamentations"),
    _T("Ezekiel"),
    _T("Daniel (Hebrew)"), // Bibledit uses "Daniel"
    _T("Hosea"),
    _T("Joel"),
    _T("Amos"), // array index 29

    _T("Obadiah"),
    _T("Jonah"),
    _T("Micah"),
    _T("Nahum"),
    _T("Habakkuk"),
    _T("Zephaniah"),
    _T("Haggai"),
    _T("Zechariah"),
    _T("Malachi"),
    _T("Matthew"), // array index 39

    _T("Mark"),
    _T("Luke"),
    _T("John"),
    _T("Acts"),
    _T("Romans"),
    _T("1 Corinthians"),
    _T("2 Corinthians"),
    _T("Galatians"),
    _T("Ephesians"),
    _T("Philippians"), // array index 49

    _T("Colossians"),
    _T("1 Thessalonians"),
    _T("2 Thessalonians"),
    _T("1 Timothy"),
    _T("2 Timothy"),
    _T("Titus"),
    _T("Philemon"),
    _T("Hebrews"),
    _T("James"),
    _T("1 Peter"), // array index 59

    _T("2 Peter"),
    _T("1 John"),
    _T("2 John"),
    _T("3 John"),
    _T("Jude"),
    _T("Revelation"),
    _T("Tobit"), // array index 66
    _T("Judith"),
    _T("Esther Greek"), // Bibledit uses "Esther"
    _T("Wisdom of Solomon"), // Bibledit uses "Wisdom" // array index 69

    _T("Sirach (Ecclesiasticus)"), // Bibledit uses "Sirach"
    _T("Baruch"),
    _T("Letter of Jeremiah"), // not used in Bibledit
    _T("Song of 3 Young Men"), // not used in Bibledit
    _T("Susanna"), // not used in Bibledit
    _T("Bel and the Dragon"), // not used in Bibledit
    _T("1 Maccabees"),
    _T("2 Maccabees"),
    _T("3 Maccabees"), // not used in Bibledit
    _T("4 Maccabees"), // not used in Bibledit // array index 79

    _T("1 Esdras (Greek)"), // not used in Bibledit
    _T("2 Esdras (Latin)"), // not used in Bibledit
    _T("Prayer of Manasseh"), // not used in Bibledit
    _T("Psalm 151"), // not used in Bibledit
    _T("Odes"), // not used in Bibledit
    _T("Psalms of Solomon"), // not used in Bibledit // array index 85
    _T("Joshua A. *obsolete*"), // not used in Bibledit
    _T("Judges B. *obsolete*"), // not used in Bibledit
    _T("Tobit S. *obsolete*"), // not used in Bibledit
    _T("Susanna Th. *obsolete*"), // not used in Bibledit // array index 89

    _T("Daniel Th. *obsolete*"), // not used in Bibledit
    _T("Bel Th. *obsolete*"), // not used in Bibledit
    _T("Extra A"), // not used in Bibledit
    _T("Extra B"), // not used in Bibledit
    _T("Extra C"), // not used in Bibledit
    _T("Extra D"), // not used in Bibledit
    _T("Extra E"), // not used in Bibledit
    _T("Extra F"), // not used in Bibledit
    _T("Extra G"), // not used in Bibledit
    _T("Front Matter"), // not used in Bibledit // array index 99

    _T("Back Matter"), // not used in Bibledit
    _T("Other Matter"), // not used in Bibledit
    _T("3 Ezra *obsolete*"), // not used in Bibledit
    _T("Apocalypse of Ezra"), // not used in Bibledit // array index 103
    _T("5 Ezra"), // not used in Bibledit
    _T("6 Ezra"), // not used in Bibledit // array index 105
    _T("Introduction"), // not used in Bibledit
    _T("Concordance"), // not used in Bibledit
    _T("Glossary"), // not used in Bibledit
    _T("Topical Index"), // not used in Bibledit // array index 109

    _T("Names Index"), // not used in Bibledit
    _T("Daniel Greek"), // not used in Bibledit // array index 111
    _T("Psalms 152-155"), // not used in Bibledit
    _T("2 Baruch (Apocalypse)"), // not used in Bibledit
    _T("Letter of Baruch"), // not used in Bibledit
    _T("Jubilees"), // not used in Bibledit
    _T("Enoch"), // not used in Bibledit
    _T("1 Meqabyan"), // not used in Bibledit
    _T("2 Meqabyan"), // not used in Bibledit
    _T("3 Meqabyan"), // not used in Bibledit // array index 119

    _T("Reproof (Proverbs 25-31)"), // added parenthetical part 27April2017 // not used in Bibledit
    _T("4 Baruch (Rest of Baruch)"), // added parenthetical part 27April2017 // not used in Bibledit
    _T("Laodiceans") // not used in Bibledit // array index 122
};

// Array of the English names of all books - from Bibledit's versification_<type>.xml files.
// This array uses the same book names as Paratext, except for the cases where Bibledit
// uses a different book name. Bibledit does not itself use some of the book names that
// Paratext uses - in such cases, this array retains the Paratext book name. Hence, the
// only differences between the AllBookNamesBibledit[] array and AllBookNames[] are for
// the following array elements:
// Paratext uses:                Bibledit uses:       Array index (zero based):
// "Esther (Hebrew)"             "Esther"             16
// "Song of Songs"               "Song of Solomon"    21
// "Daniel (Hebrew)"             "Daniel"             26
// "Esther Greek"                "Esther"             68
// "Wisdom of Solomon"           "Wisdom"             69
// "Sirach (Ecclesiasticus)"     "Sirach"             70
// Note: Bibledit conflates "Esther (Hebrew)" with "Esther Greek" so in Bibledit most
// mapping processes will only map Bibledit's "Esther" to "Esther (Hebrew)" or bookID EST
// and not bookID ESG ("Ester Greek" in Paratext).
// Categories/Subsections:
//    All Books: array index 0 ... 122
//    OT Books: array index 0 ... 38
//    NT Books: array index 39 ... 65
//    DC Books: array index 66 ... 85, 103 ... 105, 111 ... 122;  Bibledit only recognizes: array index 66 ... 71, 76 ... 77
wxString AllBookNamesBibledit[] = {
    _T("Genesis"), // index 0
    _T("Exodus"),
    _T("Leviticus"),
    _T("Numbers"),
    _T("Deuteronomy"),
    _T("Joshua"),
    _T("Judges"),
    _T("Ruth"),
    _T("1 Samuel"),
    _T("2 Samuel"),

    _T("1 Kings"), // index 10
    _T("2 Kings"),
    _T("1 Chronicles"),
    _T("2 Chronicles"),
    _T("Ezra"),
    _T("Nehemiah"),
    _T("Esther"), // Paratext uses "Esther (Hebrew)" // index 16 duplicates index 68
    _T("Job"),
    _T("Psalms"),
    _T("Proverbs"),

    _T("Ecclesiastes"), // index 20
    _T("Song of Solomon"), // Paratext uses "Song of Songs" // index 21
    _T("Isaiah"),
    _T("Jeremiah"),
    _T("Lamentations"),
    _T("Ezekiel"),
    _T("Daniel"), // Paratext uses "Daniel (Hebrew)" // index 26
    _T("Hosea"),
    _T("Joel"),
    _T("Amos"),

    _T("Obadiah"), // index 30
    _T("Jonah"),
    _T("Micah"),
    _T("Nahum"),
    _T("Habakkuk"),
    _T("Zephaniah"),
    _T("Haggai"),
    _T("Zechariah"),
    _T("Malachi"),
    _T("Matthew"),

    _T("Mark"), // index 40
    _T("Luke"),
    _T("John"),
    _T("Acts"),
    _T("Romans"),
    _T("1 Corinthians"),
    _T("2 Corinthians"),
    _T("Galatians"),
    _T("Ephesians"),
    _T("Philippians"),

    _T("Colossians"), // index 50
    _T("1 Thessalonians"),
    _T("2 Thessalonians"),
    _T("1 Timothy"),
    _T("2 Timothy"),
    _T("Titus"),
    _T("Philemon"),
    _T("Hebrews"),
    _T("James"),
    _T("1 Peter"),

    _T("2 Peter"), // index 60
    _T("1 John"),
    _T("2 John"),
    _T("3 John"),
    _T("Jude"),
    _T("Revelation"), // index 65
    _T("Tobit"), // index 66
    _T("Judith"),
    _T("Esther"), // Paratext uses "Esther Greek" // index 68 duplicates index 16
    _T("Wisdom"), // Paratext uses "Wisdom of Solomon" // index 69

    _T("Sirach"), // Paratext uses "Sirach (Ecclesiasticus)" // index 70
    _T("Baruch"), // index 71
    _T("Letter of Jeremiah"), // not used in Bibledit
    _T("Song of 3 Young Men"), // not used in Bibledit
    _T("Susanna"), // not used in Bibledit
    _T("Bel and the Dragon"), // not used in Bibledit
    _T("1 Maccabees"), // index 76
    _T("2 Maccabees"), // index 77
    _T("3 Maccabees"), // not used in Bibledit
    _T("4 Maccabees"), // not used in Bibledit

    _T("1 Esdras (Greek)"), // not used in Bibledit // index 80
    _T("2 Esdras (Latin)"), // not used in Bibledit
    _T("Prayer of Manasseh"), // not used in Bibledit
    _T("Psalm 151"), // not used in Bibledit
    _T("Odes"), // not used in Bibledit
    _T("Psalms of Solomon"), // not used in Bibledit
    _T("Joshua A. *obsolete*"), // not used in Bibledit
    _T("Judges B. *obsolete*"), // not used in Bibledit
    _T("Tobit S. *obsolete*"), // not used in Bibledit
    _T("Susanna Th. *obsolete*"), // not used in Bibledit

    _T("Daniel Th. *obsolete*"), // not used in Bibledit // index 90
    _T("Bel Th. *obsolete*"), // not used in Bibledit
    _T("Extra A"), // not used in Bibledit
    _T("Extra B"), // not used in Bibledit
    _T("Extra C"), // not used in Bibledit
    _T("Extra D"), // not used in Bibledit
    _T("Extra E"), // not used in Bibledit
    _T("Extra F"), // not used in Bibledit
    _T("Extra G"), // not used in Bibledit
    _T("Front Matter"), // not used in Bibledit

    _T("Back Matter"), // not used in Bibledit // index 100
    _T("Other Matter"), // not used in Bibledit
    _T("3 Ezra *obsolete*"), // not used in Bibledit
    _T("Apocalypse of Ezra"), // not used in Bibledit
    _T("5 Ezra"), // not used in Bibledit
    _T("6 Ezra"), // not used in Bibledit
    _T("Introduction"), // not used in Bibledit
    _T("Concordance"), // not used in Bibledit
    _T("Glossary"), // not used in Bibledit
    _T("Topical Index"), // not used in Bibledit

    _T("Names Index"), // not used in Bibledit // index 110
    _T("Daniel Greek"), // not used in Bibledit
    _T("Psalms 152-155"), // not used in Bibledit
    _T("2 Baruch (Apocalypse)"), // not used in Bibledit
    _T("Letter of Baruch"), // not used in Bibledit
    _T("Jubilees"), // not used in Bibledit
    _T("Enoch"), // not used in Bibledit
    _T("1 Meqabyan"), // not used in Bibledit
    _T("2 Meqabyan"), // not used in Bibledit
    _T("3 Meqabyan"), // not used in Bibledit

    _T("Reproof (Proverbs 25-31)"), // added parenthetical part 27April2017 // not used in Bibledit // index 120
    _T("4 Baruch (Rest of Baruch)"), // added parenthetical part 27April2017 // not used in Bibledit
    _T("Laodiceans") // not used in Bibledit
};

// All books and matter classified by Canon types: OT, NT, DC, or empty string for other misc types
wxString AllBooksCanonType[] = {
    _T("OT"), // Genesis index 0
    _T("OT"),
    _T("OT"),
    _T("OT"),
    _T("OT"),
    _T("OT"),
    _T("OT"),
    _T("OT"),
    _T("OT"),
    _T("OT"),

    _T("OT"), // index 10
    _T("OT"),
    _T("OT"),
    _T("OT"),
    _T("OT"),
    _T("OT"),
    _T("OT"),
    _T("OT"),
    _T("OT"),
    _T("OT"),

    _T("OT"), // index 20
    _T("OT"),
    _T("OT"),
    _T("OT"),
    _T("OT"),
    _T("OT"),
    _T("OT"),
    _T("OT"),
    _T("OT"),
    _T("OT"),

    _T("OT"), // index 30
    _T("OT"),
    _T("OT"),
    _T("OT"),
    _T("OT"),
    _T("OT"),
    _T("OT"),
    _T("OT"),
    _T("OT"),
    _T("NT"), // Matthew

    _T("NT"), // index 40
    _T("NT"),
    _T("NT"),
    _T("NT"),
    _T("NT"),
    _T("NT"),
    _T("NT"),
    _T("NT"),
    _T("NT"),
    _T("NT"),

    _T("NT"), // index 50
    _T("NT"),
    _T("NT"),
    _T("NT"),
    _T("NT"),
    _T("NT"),
    _T("NT"),
    _T("NT"),
    _T("NT"),
    _T("NT"),

    _T("NT"), // index 60
    _T("NT"),
    _T("NT"),
    _T("NT"),
    _T("NT"),
    _T("NT"), // Revelation index 65
    _T("DC"), // Tobit index 66
    _T("DC"),
    _T("DC"), // index 68 duplicates index 16
    _T("DC"), // index 69

    _T("DC"), // index 70
    _T("DC"), // index 71
    _T("DC"), // not used in Bibledit
    _T("DC"), // not used in Bibledit
    _T("DC"), // not used in Bibledit
    _T("DC"), // not used in Bibledit
    _T("DC"), // index 76
    _T("DC"), // index 77
    _T("DC"), // not used in Bibledit
    _T("DC"), // not used in Bibledit

    _T("DC"), // not used in Bibledit // index 80
    _T("DC"), // not used in Bibledit
    _T("DC"), // not used in Bibledit
    _T("DC"), // not used in Bibledit
    _T("DC"), // not used in Bibledit
    _T("DC"), // not used in Bibledit // index 85
    _T(""), // not used in Bibledit
    _T(""), // not used in Bibledit
    _T(""), // not used in Bibledit
    _T(""), // not used in Bibledit

    _T(""), // not used in Bibledit // index 90
    _T(""), // not used in Bibledit
    _T(""), // not used in Bibledit
    _T(""), // not used in Bibledit
    _T(""), // not used in Bibledit
    _T(""), // not used in Bibledit
    _T(""), // not used in Bibledit
    _T(""), // not used in Bibledit
    _T(""), // not used in Bibledit
    _T(""), // not used in Bibledit

    _T(""), // not used in Bibledit // index 100
    _T(""), // not used in Bibledit
    _T(""), // not used in Bibledit
    _T("DC"), // not used in Bibledit // index 103
    _T("DC"), // not used in Bibledit
    _T("DC"), // not used in Bibledit // index 105
    _T(""), // not used in Bibledit
    _T(""), // not used in Bibledit
    _T(""), // not used in Bibledit
    _T(""), // not used in Bibledit

    _T(""), // not used in Bibledit // index 110
    _T("DC"), // not used in Bibledit // index 111
    _T("DC"), // not used in Bibledit
    _T("DC)"), // not used in Bibledit
    _T("DC"), // not used in Bibledit
    _T("DC"), // not used in Bibledit
    _T("DC"), // not used in Bibledit
    _T("DC"), // not used in Bibledit
    _T("DC"), // not used in Bibledit
    _T("DC"), // not used in Bibledit

    _T("DC"), // not used in Bibledit // index 120
    _T("DC"), // not used in Bibledit
    _T("DC") // not used in Bibledit
};

// whm added 19April2017 Versification arrays, borrowed from code info gleaned from Paratext
// and modified for use in parallel arrays - compliments of Tom Hindle.
wxString vrsFileNames[] = {
    _T("unk.vrs"), // Unknown - not used in Paratext as far as I know - probably falls back to English
    _T("org.vrs"), // Original
    _T("lxx.vrs"), // Septuagint
    _T("vul.vrs"), // Vulgate
    _T("eng.vrs"), // English
    _T("rsc.vrs"), // RussianProtestant
    _T("rso.vrs"), // RussianOrthodox
    _T("oth.vrs"), // Other
    _T("oth2.vrs"), // Other2
    _T("oth3.vrs"), // Other3
    _T("oth4.vrs"), // Other4
    _T("oth5.vrs"), // Other5
    _T("oth6.vrs"), // Other6
    _T("oth7.vrs"), // Other7
    _T("oth8.vrs"), // Other8
    _T("oth9.vrs"), // Other9
    _T("oth10.vrs"), // Other10
    _T("oth11.vrs"), // Other11
    _T("oth12.vrs"), // Other12
    _T("oth13.vrs"), // Other13
    _T("oth14.vrs"), // Other14
    _T("oth15.vrs"), // Other15
    _T("oth16.vrs"), // Other16
    _T("oth17.vrs"), // Other17
    _T("oth18.vrs"), // Other18
    _T("oth19.vrs"), // Other19
    _T("oth20.vrs"), // Other20
    _T("oth21.vrs"), // Other21
    _T("oth22.vrs"), // Other22
    _T("oth23.vrs"), // Other23
    _T("oth24.vrs") // Other24
};

wxString vrsNames[] = {
    _T("Unknown"), // 0 not used in Paratext as far as I know
    _T("Original"), // 1
    _T("Septuagint"), // 2
    _T("Vulgate"), // 3
    _T("English"), // 4
    _T("RussianProtestant"), // 5
    _T("RussianOrthodox"), // 6
    _T("Other"), // 7
    _T("Other2"), // 8
    _T("Other3"), // 9
    _T("Other4"), // 10
    _T("Other5"), // 11
    _T("Other6"), // 12
    _T("Other7"), // 13
    _T("Other8"), // 14
    _T("Other9"), // 15
    _T("Other10"), // 16
    _T("Other11"), // 17
    _T("Other12"), // 18
    _T("Other13"), // 19
    _T("Other14"), // 20
    _T("Other15"), // 21
    _T("Other16"), // 22
    _T("Other17"), // 23
    _T("Other18"), // 24
    _T("Other19"), // 25
    _T("Other20"), // 26
    _T("Other21"), // 27
    _T("Other22"), // 28
    _T("Other23"), // 29
    _T("Other24") // 30
};

////////////////////////////////////////////////////////////////////////////////////////
/// \return     pointer to a BookNamePair struct whose members have been assigned
/// \param      pPair      <- the struce whose members are assigned values
/// \param      dirNm      -> the book's folder name used for actual folder/dir creation
/// \param      seeNm      -> the book's visible name (localizable) for the interface
/// \param      bookcode   -> three-letter code for the book (should be same as used on \id line)
/// \remarks
/// Called from: SetupDefaultBooksArray(). Assigns the members of the BookNamePair struct
/// pointed to by pPair with the values pointed to by the function's parameters.
////////////////////////////////////////////////////////////////////////////////////////
BookNamePair* MakePair(BookNamePair*& pPair, wxChar* dirNm, wxChar* seeNm, wxChar* bookcode)
{
    pPair->dirName = dirNm;
    pPair->seeName = seeNm;
    pPair->bookCode = bookcode;
    return pPair;
}

/// A global scratch pointer. Instances of BookNamePair are stored in the m_pBibleBooks
/// pointer array.
BookNamePair* gpBookNamePair;

/// A global scratch pointer. Instances of USFMAnalysis are stored in the m_pUsfmStylesMap,
/// m_pPngStylesMap, and m_pUsfmAndPngStylesMap (of type MapSfmToUSFMAnalysisStruct).
USFMAnalysis* gpUsfmAnalysis;

/// A global scratch pointer. Instances of UserProfileItem are stored in the ProfileItemList
/// and are used in setting up user workflow profiles
//UserProfileItem* gpUserProfileItem;

////////////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \param      pBookStructs  <- the array of void pointers to hold the pointers to book
///                              structs
/// \remarks
/// Called from: the App's OnInit() if, on app startup, the app cannot find the books.xml
/// file. SetupDefaultBooksArray() is called in order to establish a default list of
/// books/divisions for the application to use in the event that a books.xml file is not
/// available.
/////////////////////////////////////////////////////////////////////////////////////////
void SetupDefaultBooksArray(wxArrayPtrVoid* pBookStructs)
{
    wxArrayPtrVoid singles;
    wxArrayPtrVoid codes;
    SetupSinglesArray(&singles);
    SetupBookCodesArray(&codes);
    for (int i = 0; i < 67; i++)
    {
        wxChar* book = (wxChar*)singles[i];
        wxChar* itsCode = (wxChar*)codes[i];
        gpBookNamePair = new BookNamePair;
        pBookStructs->Add((void*)MakePair(gpBookNamePair, book, book, itsCode));
    }
}

////////////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \param      pBooks  <- the array of void pointers to hold the pointers to book structs
/// \remarks
/// Called from: the App's SetupDefaultBooksArray().  SetupDefaultBooksArray() in turn is only
/// called if the app cannot find the books.xml file.
////////////////////////////////////////////////////////////////////////////////////////
void SetupSinglesArray(wxArrayPtrVoid* pBooks)
{
    //pBooks->SetSize(68,10); // space for all 67, with a bit to spare, and nGrowBy of 10
    pBooks->Add((void*)_00BK);
    pBooks->Add((void*)_01BK);
    pBooks->Add((void*)_02BK);
    pBooks->Add((void*)_03BK);
    pBooks->Add((void*)_04BK);
    pBooks->Add((void*)_05BK);
    pBooks->Add((void*)_06BK);
    pBooks->Add((void*)_07BK);
    pBooks->Add((void*)_08BK);
    pBooks->Add((void*)_09BK);
    pBooks->Add((void*)_10BK);
    pBooks->Add((void*)_11BK);
    pBooks->Add((void*)_12BK);
    pBooks->Add((void*)_13BK);
    pBooks->Add((void*)_14BK);
    pBooks->Add((void*)_15BK);
    pBooks->Add((void*)_16BK);
    pBooks->Add((void*)_17BK);
    pBooks->Add((void*)_18BK);
    pBooks->Add((void*)_19BK);
    pBooks->Add((void*)_20BK);
    pBooks->Add((void*)_21BK);
    pBooks->Add((void*)_22BK);
    pBooks->Add((void*)_23BK);
    pBooks->Add((void*)_24BK);
    pBooks->Add((void*)_25BK);
    pBooks->Add((void*)_26BK);
    pBooks->Add((void*)_27BK);
    pBooks->Add((void*)_28BK);
    pBooks->Add((void*)_29BK);
    pBooks->Add((void*)_30BK);
    pBooks->Add((void*)_31BK);
    pBooks->Add((void*)_32BK);
    pBooks->Add((void*)_33BK);
    pBooks->Add((void*)_34BK);
    pBooks->Add((void*)_35BK);
    pBooks->Add((void*)_36BK);
    pBooks->Add((void*)_37BK);
    pBooks->Add((void*)_38BK);
    pBooks->Add((void*)_39BK);
    pBooks->Add((void*)_40BK);
    pBooks->Add((void*)_41BK);
    pBooks->Add((void*)_42BK);
    pBooks->Add((void*)_43BK);
    pBooks->Add((void*)_44BK);
    pBooks->Add((void*)_45BK);
    pBooks->Add((void*)_46BK);
    pBooks->Add((void*)_47BK);
    pBooks->Add((void*)_48BK);
    pBooks->Add((void*)_49BK);
    pBooks->Add((void*)_50BK);
    pBooks->Add((void*)_51BK);
    pBooks->Add((void*)_52BK);
    pBooks->Add((void*)_53BK);
    pBooks->Add((void*)_54BK);
    pBooks->Add((void*)_55BK);
    pBooks->Add((void*)_56BK);
    pBooks->Add((void*)_57BK);
    pBooks->Add((void*)_58BK);
    pBooks->Add((void*)_59BK);
    pBooks->Add((void*)_60BK);
    pBooks->Add((void*)_61BK);
    pBooks->Add((void*)_62BK);
    pBooks->Add((void*)_63BK);
    pBooks->Add((void*)_64BK);
    pBooks->Add((void*)_65BK);
    pBooks->Add((void*)_66BK);
    // Access using code like this:
    // Int16 index = some value;
    // wxChar* bookP = (wxChar*)(*m_pBibleBooks)[index];
    // or wxString aBookName = (wxChar*)(*m_pBibleBooks)[index];
}

///////////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \param      pBookCodes  <-  the array of void pointers to hold the pointers to book
///                             codes
/// \remarks
/// Called from: the App's SetupDefaultBooksArray(). SetupDefaultBooksArray() in turn is
/// only called if the app cannot find the books.xml file.
////////////////////////////////////////////////////////////////////////////////////////
void SetupBookCodesArray(wxArrayPtrVoid* pBookCodes)
{
    //pBookCodes->SetSize(68,10); // space for all 67, with a bit to spare, and nGrowBy of 10
    pBookCodes->Add((void*)_00BKCODE);
    pBookCodes->Add((void*)_01BKCODE);
    pBookCodes->Add((void*)_02BKCODE);
    pBookCodes->Add((void*)_03BKCODE);
    pBookCodes->Add((void*)_04BKCODE);
    pBookCodes->Add((void*)_05BKCODE);
    pBookCodes->Add((void*)_06BKCODE);
    pBookCodes->Add((void*)_07BKCODE);
    pBookCodes->Add((void*)_08BKCODE);
    pBookCodes->Add((void*)_09BKCODE);
    pBookCodes->Add((void*)_10BKCODE);
    pBookCodes->Add((void*)_11BKCODE);
    pBookCodes->Add((void*)_12BKCODE);
    pBookCodes->Add((void*)_13BKCODE);
    pBookCodes->Add((void*)_14BKCODE);
    pBookCodes->Add((void*)_15BKCODE);
    pBookCodes->Add((void*)_16BKCODE);
    pBookCodes->Add((void*)_17BKCODE);
    pBookCodes->Add((void*)_18BKCODE);
    pBookCodes->Add((void*)_19BKCODE);
    pBookCodes->Add((void*)_20BKCODE);
    pBookCodes->Add((void*)_21BKCODE);
    pBookCodes->Add((void*)_22BKCODE);
    pBookCodes->Add((void*)_23BKCODE);
    pBookCodes->Add((void*)_24BKCODE);
    pBookCodes->Add((void*)_25BKCODE);
    pBookCodes->Add((void*)_26BKCODE);
    pBookCodes->Add((void*)_27BKCODE);
    pBookCodes->Add((void*)_28BKCODE);
    pBookCodes->Add((void*)_29BKCODE);
    pBookCodes->Add((void*)_30BKCODE);
    pBookCodes->Add((void*)_31BKCODE);
    pBookCodes->Add((void*)_32BKCODE);
    pBookCodes->Add((void*)_33BKCODE);
    pBookCodes->Add((void*)_34BKCODE);
    pBookCodes->Add((void*)_35BKCODE);
    pBookCodes->Add((void*)_36BKCODE);
    pBookCodes->Add((void*)_37BKCODE);
    pBookCodes->Add((void*)_38BKCODE);
    pBookCodes->Add((void*)_39BKCODE);
    pBookCodes->Add((void*)_40BKCODE);
    pBookCodes->Add((void*)_41BKCODE);
    pBookCodes->Add((void*)_42BKCODE);
    pBookCodes->Add((void*)_43BKCODE);
    pBookCodes->Add((void*)_44BKCODE);
    pBookCodes->Add((void*)_45BKCODE);
    pBookCodes->Add((void*)_46BKCODE);
    pBookCodes->Add((void*)_47BKCODE);
    pBookCodes->Add((void*)_48BKCODE);
    pBookCodes->Add((void*)_49BKCODE);
    pBookCodes->Add((void*)_50BKCODE);
    pBookCodes->Add((void*)_51BKCODE);
    pBookCodes->Add((void*)_52BKCODE);
    pBookCodes->Add((void*)_53BKCODE);
    pBookCodes->Add((void*)_54BKCODE);
    pBookCodes->Add((void*)_55BKCODE);
    pBookCodes->Add((void*)_56BKCODE);
    pBookCodes->Add((void*)_57BKCODE);
    pBookCodes->Add((void*)_58BKCODE);
    pBookCodes->Add((void*)_59BKCODE);
    pBookCodes->Add((void*)_60BKCODE);
    pBookCodes->Add((void*)_61BKCODE);
    pBookCodes->Add((void*)_62BKCODE);
    pBookCodes->Add((void*)_63BKCODE);
    pBookCodes->Add((void*)_64BKCODE);
    pBookCodes->Add((void*)_65BKCODE);
    pBookCodes->Add((void*)_66BKCODE);
    // Access using code like this:
    // Int16 index = some value;
    // or wxString aBookCode = ((*m_pBibleBooks)[index]).bookCode;
}

///////////////////////////////////////////////////////////////////////////////////////
/// \return     TRUE if the input string is "1", FALSE if the input string is "0".
/// \param      temp  -> input string representing either "1" or "0"
/// \remarks
/// Called from: the App's ParseAndFillStruct() which fills out the members of a
/// USFMAnalysis struct. GetBoolValueFromStr1orStr0() and ParseAndFillStruct() are only
/// called if the app cannot find the AI_USFM.xml file and it must use
/// SetupDefaultStylesMap() to establish its internal list of USFM styles.
///////////////////////////////////////////////////////////////////////////////////////
bool GetBoolValueFromStr1orStr0(wxString temp)
{
    // WX version helper for ParseAndFillStruct below
    if (temp == _T("1"))
        return TRUE;
    else if (temp == _T("0"))
        return FALSE;
    else
    {
        wxASSERT(FALSE);
        return TRUE;
    }
}

/////////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \param      pSFM        <-  pointer to the USFMAnalysis struct whose members are
///                             to be assigned
/// \param      defaultSFM  ->  The Unix-like default string representing the fields
///                             of a USFMAnalysis struct separated by colon ":" chars
/// \remarks
/// Called from: the App's SetupDefaultStylesMap() which fills out the members of a
/// USFMAnalysis struct. GetBoolValueFromStr1orStr0() and ParseAndFillStruct() are only
/// called if the app cannot find the AI_USFM.xml file and it must use
/// SetupDefaultStylesMap() to establish its internal map of USFM styles.
/////////////////////////////////////////////////////////////////////////////////////
void ParseAndFillStruct(USFMAnalysis*& pSFM, wxString defaultSFM)
{
    // parse the defaultSFM line and assign its fields to the appropriate
    // fields of the USFMAnalysis struct
    wxString temp = _T("");
    USFMAnalysisField fieldEnum = marker; //int fieldEnum = 0;
    int intValOfEnum = (int)marker;
    bool msgGiven = FALSE;
    for (int i = 0; i < (int)defaultSFM.Length(); i++)
    {
        if (defaultSFM[i] != _T(':'))
            temp += defaultSFM[i];
        else
        {
            // we're at the end of a field
            // empty non-string fields are assumed to represent a value of "0"
            // whm 9Nov2023 added || fieldEnum == occursUnder
            if (temp == _T("")
                && !(fieldEnum == marker || fieldEnum == endMarker
                    || fieldEnum == description || fieldEnum == occursUnder  
                    || fieldEnum == navigationText
                    || fieldEnum == styleName || fieldEnum == basedOn
                    || fieldEnum == nextStyle))
                temp = _T("0");
            // in the switch below:
            // strings are directly assigned the field contents
            // booleans are cast from their integral value to bool
            // enums are cast from their integral value to their enum type
            switch (fieldEnum)
            {
            case marker:           pSFM->marker = temp; break;
            case endMarker:        pSFM->endMarker = temp; break;
            case description:      pSFM->description = temp; break;
            case occursUnder:      pSFM->occursUnder = temp; break; // whm 9Nov2023 added
            case usfm:             pSFM->usfm = GetBoolValueFromStr1orStr0(temp); break;
            case png:              pSFM->png = GetBoolValueFromStr1orStr0(temp); break;
            case filter:           pSFM->filter = GetBoolValueFromStr1orStr0(temp); break;
            case userCanSetFilter: pSFM->userCanSetFilter = GetBoolValueFromStr1orStr0(temp); break;
            case inLine:           pSFM->inLine = GetBoolValueFromStr1orStr0(temp); break;
            case special:          pSFM->special = GetBoolValueFromStr1orStr0(temp); break;
            case bdryOnLast:       pSFM->bdryOnLast = GetBoolValueFromStr1orStr0(temp); break;
            case inform:           pSFM->inform = GetBoolValueFromStr1orStr0(temp); break;
            case navigationText:   pSFM->navigationText = temp; break;
            case textType:         pSFM->textType = (TextType)wxAtoi(temp); break;
            case wrap:             pSFM->wrap = GetBoolValueFromStr1orStr0(temp); break;
            case styleName:        pSFM->styleName = temp; break;
            case styleType:        pSFM->styleType = (StyleType)wxAtoi(temp); break;
            case fontSize:         pSFM->fontSize = wxAtoi(temp); break;
            case color:            pSFM->color = wxAtoi(temp); break;
            case italic:           pSFM->italic = GetBoolValueFromStr1orStr0(temp); break;
            case bold:             pSFM->bold = GetBoolValueFromStr1orStr0(temp); break;
            case underline:        pSFM->underline = GetBoolValueFromStr1orStr0(temp); break;
            case smallCaps:        pSFM->smallCaps = GetBoolValueFromStr1orStr0(temp); break;
            case superScript:      pSFM->superScript = GetBoolValueFromStr1orStr0(temp); break;
            case justification:    pSFM->justification = (Justification)wxAtoi(temp); break;
            case spaceAbove:       pSFM->spaceAbove = wxAtoi(temp); break;
            case spaceBelow:       pSFM->spaceBelow = wxAtoi(temp); break;
            case leadingMargin:    pSFM->leadingMargin = (float)wxAtof(temp); break;   // float
            case followingMargin:  pSFM->followingMargin = (float)wxAtof(temp); break; // float
            case firstLineIndent:  pSFM->firstLineIndent = (float)wxAtof(temp); break;  // float
            case basedOn:          pSFM->basedOn = temp; break;
            case nextStyle:        pSFM->nextStyle = temp; break;
            case keepTogether:     pSFM->keepTogether = GetBoolValueFromStr1orStr0(temp); break;
            case keepWithNext:     pSFM->keepWithNext = GetBoolValueFromStr1orStr0(temp); break;
            default:
            {
                // This shouldn't happen. It would be an internal error due to
                // incorrectly formatted default strings in defaultSFM[] above
                // If there is a serious problem this could be called 266 times,
                // so only give it once.
                if (!msgGiven)
                {
                    wxMessageBox(_T("The defaultSFM[] array is incorrectly formatted!!\n"));
                }
                msgGiven = TRUE;
            }
            }
            intValOfEnum++;
            fieldEnum = (USFMAnalysisField)intValOfEnum;
            temp = _T("");
        }
    }
}

/////////////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \remarks
/// Called from: the App's OnInit(). It is only called if the app cannot find the
/// AI_USFM.xml file and it must use SetupDefaultStylesMap() to establish its internal map
/// of USFM styles. When AI_USFM.xml is available (the usual case) the m_pUsfmStylesMap,
/// m_pPngStylesMap, and m_pUsfmAndPngStylesMap are populated by the AtSFMEndTag() function
/// in XML.cpp, rather than by this SetupDefaultStylesMap() function.
/////////////////////////////////////////////////////////////////////////////////////////
void SetupDefaultStylesMap()
{
    // Note: This function is only called when AI_USFM.xml is not available for some
    // reason. When AI_USFM.xml is available (the usual case) the m_pUsfmStylesMap,
    // m_pPngStylesMap, and m_pUsfmAndPngStylesMap are populated by the AtSFMEndTag()
    // function in XML.cpp, rather than here. Any changes to the filling of the
    // CMapStringToOb routines below shold also be carried over to the AtSFMEndTag()
    // routine in XML.cpp We don't want duplicate entries in any of the three maps, so
    // we'll always do a lookup first, and only add a marker if it doesn't already exist in
    // the given map.
    for (int i = 0; i < gnDefaultSFMs; i++)
    {
        gpUsfmAnalysis = new USFMAnalysis;
        // whm Note: The object pointed at by gpUsfmAnalysis will not ordinarily
        // need to be deleted by calling delete on the gpUsfmAnalysis "scratch"
        // pointer, because each such object created here will be handed off to
        // another data structure which will eventually be responsible for
        // object deletion of the objects it owns in OnExit(). It need only be
        // deleted directly if it cannot be handed off to an appropriate data
        // structure (see below).
        //
        // set the gpUsfmAnalysis struct attributes from the parsed defaultSFM
        // strings values
        ParseAndFillStruct(gpUsfmAnalysis, defaultSFM[i]);
        wxString bareMkr = gpUsfmAnalysis->marker;
        int posn = bareMkr.Find(_T('*')); // do we have an end marker?
        if (posn >= 0 && bareMkr[bareMkr.Length() - 1] == _T('*'))
        {
            bareMkr = bareMkr.Mid(0, posn - 1); // strip off asterisk for attribute lookup
        }
        // map the parsed struct to the appropriate map on the heap
        MapSfmToUSFMAnalysisStruct::iterator iter;
        if (gpUsfmAnalysis->usfm)
        {
            iter = gpApp->m_pUsfmStylesMap->find(bareMkr);
            if (iter == gpApp->m_pUsfmStylesMap->end())
            {
                // key doesn't already exist in the map, so add it
                (*gpApp->m_pUsfmStylesMap)[bareMkr] = gpUsfmAnalysis;
            }
            // for UsfmAndPng map put the Usfm marker there as priority
            iter = gpApp->m_pUsfmAndPngStylesMap->find(bareMkr);
            if (iter == gpApp->m_pUsfmAndPngStylesMap->end())
            {
                // key doesn't already exist in the map, so add it
                (*gpApp->m_pUsfmAndPngStylesMap)[bareMkr] = gpUsfmAnalysis;
            }

        }
        if (gpUsfmAnalysis->png)
        {
            iter = gpApp->m_pPngStylesMap->find(bareMkr);
            if (iter == gpApp->m_pPngStylesMap->end())
            {
                // key doesn't already exist in the map, so add it
                (*gpApp->m_pPngStylesMap)[bareMkr] = gpUsfmAnalysis;
            }
            // for UsfmAndPng map put the Usfm marker there only if unique
            iter = gpApp->m_pUsfmAndPngStylesMap->find(bareMkr);
            if (iter == gpApp->m_pUsfmAndPngStylesMap->end())
            {
                // key doesn't already exist in the map, so add it
                (*gpApp->m_pUsfmAndPngStylesMap)[bareMkr] = gpUsfmAnalysis;
            }
        }
        if (!gpUsfmAnalysis->usfm && !gpUsfmAnalysis->png)
        {
            // the marker is neither usfm nor png and therefore not stored in
            // any of the three possible maps, so we must delete it
            if (gpUsfmAnalysis != NULL) // whm 11Jun12 added NULL test
                delete gpUsfmAnalysis;
        }
        else
        {
            gpApp->m_pMappedObjectPointers->Add(gpUsfmAnalysis);
        }
        gpUsfmAnalysis = NULL;
    }
}

/////////////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \param      <- pUserProfiles  a pointer to the UserProfiles struct that is being populated
/// \remarks
/// Called from: the App's OnInit(), ReportMenuAndUserProfilesInconsistencies(), and
/// CAdminEditMenuProfile::InitDialog. It is called in OnInit() to set up a
/// factoryUserProfiles struct on the heap for use in AdminEditMenuProfile class.
/// It is also called if the app cannot find the AI_UserProfiles.xml file and it must
/// use SetupDefaultUserProfiles() to establish its internal representation of any user
/// selected User Workflow Profile.
/// When AI_UserProfiles.xml is available (the usual case) the m_pUserProfiles is
/// populated by the AtPROFILEEndTag() function in XML.cpp, rather than by this
/// SetupDefaultUserProfiles() function. After setting up the pUserProfiles struct
/// this function also calls GetAndAssignIdValuesToUserProfilesStruct().
/////////////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItApp::SetupDefaultUserProfiles(UserProfiles*& pUserProfiles)
{

    // testing below !!!
    //wxArrayString defaultProfItems;
    //defaultProfItems.Add(_T("Save &As...\tCtrl-A"));
    //defaultProfItems.Add(::wxGetTranslation(defaultProfItems.Item(0)));
    //defaultProfItems.Add(_("Save &As...\tCtrl-A"));
    //defaultProfItems.Add(_T("source"));
    //defaultProfItems.Add(_("source"));
    //int testCt;
    //int testTot = defaultProfItems.GetCount();
    //for (testCt = 0; testCt < testTot; testCt++)
    //	wxLogDebug(defaultProfItems.Item(testCt));
    //int junk;
    //junk = 1;
    // Note: testing shows that we can use ::wxGetTranslation() as long as we use the
    // exact & and \tCtrl-key embellishments.
    // testing above !!!

    wxString field = _T("");
    int nDefaultUserProfileItems;
    UserProfileItem* pUserProfileItem = NULL;
    nDefaultUserProfileItems = sizeof(defaultProfileItems) / sizeof(wxString);
    int i;
    for (i = 0; i < nDefaultUserProfileItems; i++)
    {
        // scan and parse each defaultProfileItems line
        field.Empty();
        int ct, totct;
        wxString lineStr;
        lineStr = defaultProfileItems[i];
        totct = defaultProfileItems[i].Length();
        for (ct = 0; ct < totct; ct++)
        {
            // defaultProfileItems[i] represents a whole string line of concatenated tags, attributes and values
            if (lineStr.GetChar(ct) != _T(':'))
            {
                field += lineStr.GetChar(ct);
            }
            else
            {
                // we're at the end of a field and field contains the string token
                // up to, but not including the : delimiter.
                // If the field doesn't have an '=' in it, it should be an all-caps
                // tag name; if it has an '=' in it, the field should contain an
                // attribute name followed by the '=' with the attribute's value
                // within quote marks, i.e., attributeName="value".
                // Parse the field into its parts
                if (field.Find(_T("=")) == wxNOT_FOUND)
                {
                    // No '=' in the field so field itself should be a tag name
                    // Test for most common ones first - profile and menu.
                    if (field == wxString::FromAscii(profile))
                    {
                        ;
                    }
                    else if (field == wxString::FromAscii(end_profile))
                    {
                        ;
                    }
                    else if (field == wxString::FromAscii(menu))
                    {
                        pUserProfileItem = new UserProfileItem;
                        pUserProfileItem->itemID = _T("");
                        pUserProfileItem->itemIDint = -1;
                        pUserProfileItem->itemType = _T("");
                        pUserProfileItem->itemText = _T("");
                        pUserProfileItem->itemDescr = _T("");
                        pUserProfileItem->adminCanChange = _T("");
                        pUserProfileItem->usedProfileNames.Clear();
                    }
                    else if (field == wxString::FromAscii(end_menu))
                    {
                        pUserProfiles->profileItemList.Append(pUserProfileItem);
                    }
                    else if (field == wxString::FromAscii(userprofilessupport))
                    {
                        pUserProfiles = new UserProfiles;
                        pUserProfiles->profileVersion = _T("");
                        pUserProfiles->applicationCompatibility = _T("");
                        pUserProfiles->adminModified = _T("");
                        pUserProfiles->definedProfileNames.Clear();
                        pUserProfiles->descriptionProfileTexts.Clear();
                        pUserProfiles->profileItemList.Clear();
                    }
                    else if (field == wxString::FromAscii(end_userprofilessupport))
                    {
                        ;
                    }
                }
                else
                {
                    // field has an '=' char in it so it should be an attribute/value
                    // representation
                    wxString attrStr;
                    wxString valueStr;
                    attrStr = field.Mid(0, field.Find(_T("=")));
                    attrStr.Trim(FALSE);
                    attrStr.Trim(TRUE);
                    valueStr = field.Mid(field.Find(_T("=")));
                    valueStr.Replace(_T("="), _T(""));
                    valueStr.Replace(_T("\""), _T(""));
                    valueStr.Trim(FALSE);
                    valueStr.Trim(TRUE);
                    if (attrStr == wxString::FromAscii(profileVersion))
                    {
                        wxASSERT(pUserProfiles != NULL);
                        pUserProfiles->profileVersion = valueStr;
                    }
                    else if (attrStr == wxString::FromAscii(applicationCompatibility))
                    {
                        wxASSERT(pUserProfiles != NULL);
                        pUserProfiles->applicationCompatibility = valueStr;
                    }
                    else if (attrStr == wxString::FromAscii(adminModified))
                    {
                        wxASSERT(pUserProfiles != NULL);
                        pUserProfiles->adminModified = valueStr;
                    }
                    else if (attrStr.Find(wxString::FromAscii(definedProfile)) == 0)
                    {
                        wxASSERT(pUserProfiles != NULL);
                        // whm 24May11 Note: we need to call ::wxGetTranslation to get the localized string for the definedProfile
                        pUserProfiles->definedProfileNames.Add(::wxGetTranslation(valueStr)); // whm changed 24May11 to use localization
                                                                                              //pUserProfiles->definedProfileNames.Add(valueStr);
                    }
                    else if (attrStr.Find(wxString::FromAscii(descriptionProfile)) == 0)
                    {
                        wxASSERT(pUserProfiles != NULL);
                        // Note: we keep entity characters in their non xml form here, i.e.,
                        // '<', '>', '&', ''', and '"' remain as it.
                        // whm 24May11 Note: we need to call ::wxGetTranslation to get the localized string for the descriptionProfile
                        pUserProfiles->descriptionProfileTexts.Add(::wxGetTranslation(valueStr)); // whm changed 24May11 to use localization
                                                                                                  //pUserProfiles->descriptionProfileTexts.Add(valueStr);
                    }
                    else if (attrStr == wxString::FromAscii(itemID))
                    {
                        wxASSERT(pUserProfileItem != NULL);
                        pUserProfileItem->itemID = valueStr;
                    }
                    else if (attrStr == wxString::FromAscii(itemType))
                    {
                        wxASSERT(pUserProfileItem != NULL);
                        pUserProfileItem->itemType = valueStr;
                    }
                    else if (attrStr == wxString::FromAscii(itemText))
                    {
                        wxASSERT(pUserProfileItem != NULL);
                        // whm 24May11 Note: we need to call ::wxGetTranslation to get the localized string for the itemText
                        wxString tempS = ::wxGetTranslation(valueStr); // whm changed 24May11 to use localization
                                                                       // change any embedded tab 0x09 char to explicit "\\t"
                        int posn = tempS.Find('\t');
                        if (posn != wxNOT_FOUND)
                        {
                            tempS.Remove(posn, 1);
                            tempS.insert(posn, _T("\\t"));
                        }
                        pUserProfileItem->itemText = tempS;
                        //pUserProfileItem->itemText = valueStr;
                    }
                    else if (attrStr == wxString::FromAscii(itemDescr))
                    {
                        wxASSERT(pUserProfileItem != NULL);
                        // whm 24May11 Note: we need to call ::wxGetTranslation to get the localized string for the itemDescr
                        pUserProfileItem->itemDescr = ::wxGetTranslation(valueStr); // whm changed 24May11 to use localization
                                                                                    //pUserProfileItem->itemDescr = valueStr;
                    }
                    else if (attrStr == wxString::FromAscii(itemAdminCanChange))
                    {
                        wxASSERT(pUserProfileItem != NULL);
                        pUserProfileItem->adminCanChange = valueStr;
                    }
                    else if (attrStr == wxString::FromAscii(itemUserProfile))
                    {
                        wxASSERT(pUserProfileItem != NULL);
                        // whm 24May11 Note: we need to call ::wxGetTranslation to get the localized string for the itemUserProfile
                        pUserProfileItem->usedProfileNames.Add(::wxGetTranslation(valueStr)); // whm changed 24May11 to use localization
                                                                                              //pUserProfileItem->usedProfileNames.Add(valueStr);
                    }
                    else if (attrStr == wxString::FromAscii(itemVisibility))
                    {
                        wxASSERT(pUserProfileItem != NULL);
                        pUserProfileItem->usedVisibilityValues.Add(valueStr);
                    }
                    else if (attrStr == wxString::FromAscii(factory))
                    {
                        wxASSERT(pUserProfileItem != NULL);
                        pUserProfileItem->usedFactoryValues.Add(valueStr);
                    }
                }

                field.Empty(); // ready for next field
            }
        }
        // We're at the end of a parsed line
    }
    GetAndAssignIdValuesToUserProfilesStruct(pUserProfiles);
}

/////////////////////////////////////////////////////////////////////////////////////////
/// \return     TRUE if the compareUserProfiles and baseUserProfiles differ in the significant
///             profile items that they share in common, FALSE if those items are the same
/// \param      <- compareUserProfiles  a pointer to the UserProfiles struct whose profile items
///                 are being checked/compared
/// \param      <- baseUserProfiles  a pointer to the UserProfiles struct whose profile items
///                 are the basis against which the compareUserProfiles items are being compared
/// \remarks
/// Called from: the App's UpdateAdminModifiedLineToYesOrNo().
/// Determines if the current user profile m_pUserProfiles (compareUserProfiles) differs from
/// the factory profile m_pFactoryUserProfiles (baseUserProfiles). It only check for differences in
/// profile items that the two profiles (compareUserProfiles and baseUserProfiles) have in common.
/// It ignores any profile items that are present but are not shared in common. This allows
/// upgrades to be done where different profile items might be present/absent in the course
/// of an upgrade to a newer, or downgrade to an older version of the application and the
/// AI_UserProfiles.xml file.
/////////////////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItApp::CommonItemsInProfilesDiffer(UserProfiles* compareUserProfiles, UserProfiles* baseUserProfiles)
{
    // whm 22Oct10 rewrote to allow for different numbers of items in baseUserProfiles
    // and compareUserProfiles. See MapChangesInUserProfiles().
    bool bTheyDiffer = FALSE;
    // Strategy:
    // There is an m_pFactoryUserProfiles (baseUserProfiles) struct created in OnInit()
    // that we can use for comparison with the current compareUserProfiles. This comparison
    // ignores the adminModified attributes and others which are not editable by the
    // administrator. If CommonItemsInProfilesDiffer() returns FALSE it means that the
    // compareUserProfiles struct essentially contains only baseUserProfiles (i.e., factory)
    // data.

    wxASSERT(compareUserProfiles != NULL);
    wxASSERT(baseUserProfiles != NULL);

    if (compareUserProfiles != NULL && baseUserProfiles != NULL)
    {
        // we use a temporary map tempMap to associate the necessary attribute
        // items with their associated values.
        MapProfileChangesToStringValues tempMap;
        MapProfileChangesToStringValues::iterator iter;

        // Enter all compareUserProfiles items into our tempMap
        // First enter all of compareUserProfiles->descriptionProfileTexts into the map
        int descCt;
        int descTot = (int)compareUserProfiles->descriptionProfileTexts.GetCount();
        for (descCt = 0; descCt < descTot; descCt++)
        {
            // enter all of compareUserProfiles->descriptionProfileTexts into the map
            wxString key = wxString::FromAscii(descriptionProfile);
            key << descCt + 1; // add the numerical suffix as string "1", "2", "3", or "4"
            iter = tempMap.find(key);
            if (iter != tempMap.end())
            {
                // key exists in the map
                tempMap.insert(*iter);
            }
            else
            {
                // key not in the map
                tempMap[key] = compareUserProfiles->descriptionProfileTexts[descCt];
            }
        }
        // Next, enter all of compareUserProfiles->profileItemList items into the tempMap
        ProfileItemList::Node* tpos;
        int count;
        int t_tot = (int)compareUserProfiles->profileItemList.GetCount();
        for (count = 0; count < t_tot; count++)
        {
            tpos = compareUserProfiles->profileItemList.Item(count);
            UserProfileItem* ptItem;
            ptItem = tpos->GetData();
            wxASSERT(ptItem != NULL);
            int ct;
            int ct_t;
            ct_t = (int)ptItem->usedVisibilityValues.GetCount();
            for (ct = 0; ct < ct_t; ct++)
            {
                wxString key = ptItem->itemText + _T(":") + ptItem->usedProfileNames[ct]; // key is itemText + ':' + name of the profile, i.e., "Save As...:Novice"
                iter = tempMap.find(key);
                if (iter != tempMap.end())
                {
                    // key exists in the map
                    tempMap.insert(*iter);
                }
                else
                {
                    // key not in the map
                    tempMap[key] = ptItem->usedVisibilityValues[ct];
                }
            }
        }
        // dump the map contents for testing
        //for( iter = tempMap.begin(); iter != tempMap.end(); ++iter )
        //{
        //	wxLogDebug(_T("iter->first = %s, iter->second = %s"),iter->first.c_str(),iter->second.c_str());
        //}

        // Now go through all items of the baseUserProfiles struct, and do a lookup to see if
        // each item is in the map. If so, check the map's associated value. If the map's
        // associated value is different, then we immediately return TRUE.
        int appCt;
        int appTot = (int)baseUserProfiles->descriptionProfileTexts.GetCount();
        int nAppItemsNotAmongTempItems = 0;
        int nTempItemsNotAmongAppItems = (int)compareUserProfiles->descriptionProfileTexts.GetCount() + (4 * (int)compareUserProfiles->profileItemList.GetCount());
        for (appCt = 0; appCt < appTot; appCt++)
        {
            wxString key = wxString::FromAscii(descriptionProfile);
            key << appCt + 1; // add the numerical suffix as string "1", "2", "3", or "4"

            iter = tempMap.find(key);
            if (iter != tempMap.end())
            {
                // key exists in the map
                wxString keyTemp = iter->first;
                wxString valueTemp = iter->second;
                wxString appDescrText = baseUserProfiles->descriptionProfileTexts.Item(appCt);
                // check if the valueTemp differs from the appDescrText
                if (valueTemp != appDescrText)
                {
                    bTheyDiffer = TRUE;
                    return bTheyDiffer;
                }
                nTempItemsNotAmongAppItems--; // decrement from total tempUserProfile items - remainder at end is the significant total
            }
            else
            {
                // key not in the map
                nAppItemsNotAmongTempItems++;
            }
        }
        ProfileItemList::Node* apos;
        MapProfileChangesToStringValues::iterator a_iter;
        int a_tot = (int)baseUserProfiles->profileItemList.GetCount();
        for (count = 0; count < a_tot; count++)
        {
            apos = baseUserProfiles->profileItemList.Item(count);
            UserProfileItem* paItem;
            paItem = apos->GetData();
            wxASSERT(paItem != NULL);
            int ct;
            int ct_a;
            ct_a = (int)paItem->usedVisibilityValues.GetCount();
            for (ct = 0; ct < ct_a; ct++)
            {
                wxString key = paItem->itemText + _T(":") + paItem->usedProfileNames[ct]; // key is itemText + ':' + name of the profile, i.e., "Save As...:Novice"
                iter = tempMap.find(key);
                if (iter != tempMap.end())
                {
                    // key exists in the map
                    wxString keyTemp = iter->first;
                    wxString valueTemp = iter->second;
                    wxString appVisibility = paItem->usedVisibilityValues.Item(ct);
                    // check if the valueTemp differs from the appDescrText
                    if (valueTemp != appVisibility)
                    {
                        bTheyDiffer = TRUE;
                        return bTheyDiffer;
                    }
                    nTempItemsNotAmongAppItems--; // decrement from total tempUserProfile items - remainder at end is the significant total
                }
                else
                {
                    // key not in the map
                    nAppItemsNotAmongTempItems++;
                }
            }
        }
        // dump the map contents for testing
        //for( a_iter = m_mapProfileChangesToStringValues.begin(); a_iter != m_mapProfileChangesToStringValues.end(); ++a_iter )
        //{
        //	wxLogDebug(_T("a_iter->first = %s, a_iter->second = %s"),a_iter->first.c_str(),a_iter->second.c_str());
        //}
    }
    return bTheyDiffer;
}

/////////////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \param      <- pUserProfiles  a pointer to the UserProfiles struct whose profile items
///                 are being modified
/// \remarks
/// Called from the App's OnInit(), SetupDefaultUserProfiles(), and CAdminEditMenuProfile::InitDialog().
/// Scans through pUserProfiles and assigns the itemIDint values by looking them up in the
/// m_mapMenuLabelStrToIdInt and assigning the mapped int values to the itemIDint member of
/// the UserProfileItem part of pUserProfiles.
/////////////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItApp::GetAndAssignIdValuesToUserProfilesStruct(UserProfiles*& pUserProfiles)
{
    // Use the map m_mapMenuLabelStrToIdInt
    wxASSERT(pUserProfiles != NULL);

    // scan through pUserProfiles and assign the int id values by looking them up in the
    // m_mapMenuLabelStrToIdInt and assigning the mapped int values to the itemIDint
    // member of the UserProfileItem part of pUserProfiles
    if (pUserProfiles != NULL)
    {
        ProfileItemList::Node* pos_profileList;
        int count;
        int item_count = (int)pUserProfiles->profileItemList.GetCount();
        for (count = 0; count < item_count; count++)
        {
            pos_profileList = pUserProfiles->profileItemList.Item(count);
            UserProfileItem* pItem;
            pItem = pos_profileList->GetData();
            if (pItem->itemType == _T("subMenu"))
            {

                // pItem->itemText is the string we want to look up, but remove decorations
                wxString itemTextPlain = pItem->itemText; //RemoveMenuLabelDecorations(pItem->itemText);
                                                          // Note: UserProfiles data does not list menuSeparators so itemTextPlain
                                                          // will never be menuSeparator
                                                          // now look up the mapped int value
                MapMenuLabelStrToIdInt::iterator iter;

                // Note: the \t chars in the xml and internal strings become \\t literals
                // and need to be changed to \t to work in the menus.
                wxString labelStr = itemTextPlain;
                labelStr.Replace(_T("\\t"), _T("\t"));

                iter = m_mapMenuLabelStrToIdInt.find(labelStr);
                int itemId = -1;
                if (iter != m_mapMenuLabelStrToIdInt.end())
                {
                    // we found an associated value for the plain menu label
                    itemId = (int)iter->second;
                }
                else
                {
                    // no mapping was found - this shouldn't happen
                    wxString msg = _T("Programming Error: No mapping found for menu label: %s\n\nCheck that AI_UserProfiles.xml is in sync with the defaultProfileItems[] array in the App.\n\nFor example, if a menu item was removed, remove the item's xml in AI_UserProfiles in the local copy in work folder,\nand in the adaptit > xml folder of the dev system - the latter one is crucial.");
                    msg = msg.Format(msg, labelStr.c_str());
#ifdef _DEBUG
                    wxASSERT_MSG(FALSE, msg);
#endif
                    LogUserAction(msg);
                    
                }
                pItem->itemIDint = itemId;
            }
        }
    }
}

/////////////////////////////////////////////////////////////////////////////////////////
/// \return     nothing (but three wxString parameter values passed back by reference)
/// \param      -> AIuserProfilesWorkFolderPath path and name of AI_UserProfiles.xml in the work folder
/// \param      -> profileVersionStr the string value of the profileVersion attribute in the xml file
/// \param      -> applicationCompatibilityStr the string value of the applicationCompatibility attribute
///                 in the xml file
/// \param      -> adminModifiedStr the string value of the adminModified attribute in the xml file, i.e.,
///                 which is "Yes" or "No"
/// \remarks
/// Called from the App's OnInit(), SetupDefaultUserProfiles(), and CAdminEditMenuProfile::InitDialog().
/// Opens and reads the AI_UserProfiles.xml file at the AIuserProfilesWorkFolderPath path,
/// and retrieves the string values associated with these three attribute values: profileVersion,
/// applicationCompatibility, and adminModified. It returns them in the parameters passed by
/// reference.
/////////////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItApp::GetVersionAndModInfoFromProfilesXMLFile(wxString AIuserProfilesWorkFolderPath,
    wxString& profileVersionStr, wxString& applicationCompatibilityStr, wxString& adminModifiedStr)
{
    wxTextFile f;
    bool bUserProfilesFileExists = wxFileExists(AIuserProfilesWorkFolderPath);
    if (bUserProfilesFileExists)
    {
        // Read the existing xml file into memory using wxTextFile, so we can retrieve the
        // xml comments at the beginning of the file and compare the data in memory and
        // make changes there before saving the file back to disk
        bool bOpenedOK;
        bOpenedOK = f.Open(m_userProfileFileWorkFolderPath);
        if (bOpenedOK)
        {
            // The AI_UserProfiles.xml file is now in memory and accessible line-by-line through textFile.
            bool bFoundprofileVersion = FALSE;
            wxString lineStr;
            for (lineStr = f.GetFirstLine(); !f.Eof() && !bFoundprofileVersion; lineStr = f.GetNextLine())
            {
                int chPos;
                // does this line have our itemTextStr?
                chPos = lineStr.Find(wxString::FromAscii(profileVersion));
                if (chPos != wxNOT_FOUND)
                {
                    bFoundprofileVersion = TRUE;
                    wxString str = lineStr;
                    int beginQPos, endQPos;
                    beginQPos = str.Find(_T("\""));
                    wxASSERT(beginQPos != wxNOT_FOUND);
                    str = str.Mid(beginQPos + 1);
                    endQPos = str.Find(_T("\""));
                    wxASSERT(endQPos != wxNOT_FOUND);
                    str = str.Mid(0, endQPos);
                    profileVersionStr = str;
                    break;
                }
            }
            bool bFoundapplicationCompatibility = FALSE;
            for (lineStr = f.GetFirstLine(); !f.Eof() && !bFoundapplicationCompatibility; lineStr = f.GetNextLine())
            {
                int chPos;
                // does this line have our itemTextStr?
                chPos = lineStr.Find(wxString::FromAscii(applicationCompatibility));
                if (chPos != wxNOT_FOUND)
                {
                    bFoundapplicationCompatibility = TRUE;
                    wxString str = lineStr;
                    int beginQPos, endQPos;
                    beginQPos = str.Find(_T("\""));
                    wxASSERT(beginQPos != wxNOT_FOUND);
                    str = str.Mid(beginQPos + 1);
                    endQPos = str.Find(_T("\""));
                    wxASSERT(endQPos != wxNOT_FOUND);
                    str = str.Mid(0, endQPos);
                    applicationCompatibilityStr = str;
                    break;
                }
            }
            bool bFoundadminModified = FALSE;
            for (lineStr = f.GetFirstLine(); !f.Eof() && !bFoundadminModified; lineStr = f.GetNextLine())
            {
                int chPos;
                // does this line have our itemTextStr?
                chPos = lineStr.Find(wxString::FromAscii(adminModified));
                if (chPos != wxNOT_FOUND)
                {
                    bFoundadminModified = TRUE;
                    wxString str = lineStr;
                    int beginQPos, endQPos;
                    beginQPos = str.Find(_T("\""));
                    wxASSERT(beginQPos != wxNOT_FOUND);
                    str = str.Mid(beginQPos + 1);
                    endQPos = str.Find(_T("\""));
                    wxASSERT(endQPos != wxNOT_FOUND);
                    str = str.Mid(0, endQPos);
                    adminModifiedStr = str;
                    break;
                }
            }
        }
        f.Close();
    }

}

/////////////////////////////////////////////////////////////////////////////////////////
/// \return     TRUE if backup copy was successful, FALSE if the copy process failed
/// \param      -> AIuserProfilesWorkFolderPath path and name of AI_UserProfiles.xml in the work folder
/// \param      <- backupPathNameUsed the string value returned of the backup file name generated for the
///                 backup, i.e., of the form AI_UserProfiles_Old_nn.xml where nn is 01, 02, 03, etc.
/// \remarks
/// Called from the App's OnInit().
/// Makes a backup copy of the user's AI_UserProfiles.xml file naming it to AI_UserProfiles_Oldnn.xml
/// where nn is a numerical 01, 02, 03, etc., to avoid overwriting a previous backup. The backup copy
/// is made in the user's work folder (m_userProfileFileWorkFolderPath). This function does not remove
/// the original AI_UserProfiles.xml file at m_userProfileFileWorkFolderPath.
/////////////////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItApp::BackupExistingUserProfilesFileInWorkFolder(wxString AIuserProfilesWorkFolderPath, wxString& backupPathNameUsed)
{
    bool bBackupOK = TRUE;
    bool bExists;
    bExists = ::wxFileExists(AIuserProfilesWorkFolderPath);
    wxASSERT(bExists == TRUE);
    if (bExists)
    {
        wxString backupName;
        backupName = GetUniqueIncrementedFileName(AIuserProfilesWorkFolderPath, incrementViaNextAvailableNumber, FALSE, 2, _T("_Old_"));
        // We should now have a backup name that does not yet exist as a file in the work folder.
        // Now copy the existing AI_UserProfiles.xml to the backupName (backupName is full path + filename).
        bool bCopiedOK;
        bCopiedOK = ::wxCopyFile(AIuserProfilesWorkFolderPath, backupName); // overwrite is default but shouldn't be one there with name backupName
        if (!bCopiedOK)
        {
            bBackupOK = FALSE;
        }
        backupPathNameUsed = backupName; // to return to caller via reference
    }
    return bBackupOK;
}


/////////////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \param      <- pMenuStructure  a pointer to the AI_MenuStructure struct that is being populated
/// \param      <- m_mapMenuLabelStrToIdInt a mapping of menu id strings to their menu id int values
/// \remarks
/// Called from: the App's OnInit().
/// It represents Adapt It's default menu structure as derived from a temporary version of AI's
/// menu bar (without being configured for any user profiles). Assumes pMenuStructure is NULL
/// on entry to this function. While setting up the default menu structure, this function also
/// populates the m_mapMenuLabelStrToIdInt map which is used in the
/// GetAndAssignIdValuesToUserProfilesStruct().
/////////////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItApp::SetupDefaultMenuStructure(AI_MenuStructure*& pMenuStructure, MapMenuLabelStrToIdInt& m_mapMenuLabelStrToIdInt)
{
    wxASSERT(pMenuStructure == NULL);
    AI_MainMenuItem* pMainMenuItem = NULL;
    AI_SubMenuItem* pSubMenuItem = NULL;

    pMenuStructure = new AI_MenuStructure;
    wxASSERT(pMenuStructure != NULL);
    // create a temporary AI menu bar on the heap from the wxDesigner's AIMenuBarFunc() function.
    // This represents the default menu bar, as it does not get changed to accommodate the
    // current user profile by ConfigureInterfaceForUserProfile()
    wxMenuBar* pMenuBar;
    pMenuBar = AIMenuBarFunc();
    wxASSERT(pMenuBar != NULL);

    MapMenuLabelStrToIdInt::iterator iter;
    //m_mapMenuLabelStrToIdInt.clear(); // don't call .clear() here because we've already populated the map
    // with the untranslated menu label string-to-int associations via the earlier call of
    // SetupUnTranslatedMapMenuLabelStrToIdInt() in OnInit(). Here below we further populate the map
    // with the translated menu label strings associating them with their ID ints.

    if (pMenuBar == NULL)
    {
        wxASSERT(FALSE);
        wxLogDebug(_T("The pointer to the temporary AI menu bar is NULL\n -   aborting the SetupDefaultMenuStructure() function"));
        return;
    }
    int ct;
    int mbct = pMenuBar->GetMenuCount(); // get the number of top level menu items
    for (ct = 0; ct < mbct; ct++)
    {
        wxMenu* pmbMainMenuItem = pMenuBar->GetMenu(ct); // AI menu bar
        wxASSERT(pmbMainMenuItem != NULL);
        if (pmbMainMenuItem != NULL)
        {
            pMainMenuItem = new AI_MainMenuItem;
            wxASSERT(pMainMenuItem != NULL);
            // initialize the new pMainMenuItem's members
            pMainMenuItem->mainMenuIDint = -1;
            //pMainMenuItem->mainMenuID = _T("");
            pMainMenuItem->mainMenuLabel = _T("");
            pMainMenuItem->aiSubMenuItems.Clear();

            // get values for pMainMenuItem's members from the temp AI menu bar pMenuBar
            wxString mbMainMenuText = pMenuBar->GetMenuLabel(ct); // includes accelerator chars
            pMainMenuItem->mainMenuLabel = mbMainMenuText;
            // For some reason a wxMenu item (top level or sub menu item) does not have a
            // GetId() method. Only a wxMenuItem has a GetId() method. Hence, we have to
            // determine the int ID of a main menu item in a round-about way.

            pMainMenuItem->mainMenuIDint = GetTopLevelMenuID(mbMainMenuText); // Note: a top level menu cannot be menuSeparator
            //pMainMenuItem->mainMenuID = // we can get along without this string representation mainMenuID
            // Consider: When the compiled all of the menu item IDs are determined and those const int values
            // are used at run time. They don't change during execution or even from session to session of a
            // given build/release of the application. So we should be able to ignore them in our AI_MenuStructure
            // especially since the mainMenuIDint value never changes.

            // insert the main menu id string/int association into the m_mapMenuLabelStrToIdInt if none already exists
            // Note: we remove menu decorations since we want to be able to look up the plain label in
            // the map
            wxString mainMenuItemLabelPlain = mbMainMenuText; //RemoveMenuLabelDecorations(mbMainMenuText);
            iter = m_mapMenuLabelStrToIdInt.find(mainMenuItemLabelPlain);
            if (iter != m_mapMenuLabelStrToIdInt.end())
            {
                // key exists in the map
                m_mapMenuLabelStrToIdInt.insert(*iter); // associates (any new) pMainMenuItem->mainMenuIDint value with the keyCopy
            }
            else
            {
                // key not in the map
                // The [] index operator can be used either of two ways in assignment statement
                m_mapMenuLabelStrToIdInt[mainMenuItemLabelPlain] = pMainMenuItem->mainMenuIDint; // clearest
                // or, the following is equivalent, but not so clear
                //pThisMap->operator[](mbMainMenuText) = pMainMenuItem->mainMenuIDint;
                // NOTE: The docs say of the wxHashMap::operator[] "Use it as an array subscript.
                // The only difference is that if the given key is not present in the hash map,
                // an element with the default value_type() is inserted in the table."
            }

            int i;
            int imbct;
            imbct = pmbMainMenuItem->GetMenuItemCount(); // AI menu bar
            for (i = 0; i < imbct; i++)
            {
                wxMenuItemList pmbSubMenuItems = pmbMainMenuItem->GetMenuItems(); // AI menu bar
                wxMenuItemList::Node* mbListNode; // AI menu bar
                mbListNode = pmbSubMenuItems.Item(i); // AI menu bar
                wxMenuItem* pmbSubMenuItem = mbListNode->GetData(); // AI menu bar
                wxASSERT(pmbSubMenuItem != NULL);
                pSubMenuItem = new AI_SubMenuItem;
                // initialize pSubMenuItem's members
                wxASSERT(pSubMenuItem != NULL);
                //pSubMenuItem->subMenuID = _T("");
                pSubMenuItem->subMenuIDint = -1;
                pSubMenuItem->subMenuLabel = _T("");
                pSubMenuItem->subMenuHelp = _T("");
                pSubMenuItem->subMenuKind = _T("");

                // get values for pSubMenuItem's members from the temp AI menu bar pMenuBar's
                // pmbSubMenuItem objects
                //pSubMenuItem->subMenuID = // we can get along without this string representation mainMenuID
                // Consider: When the compiled all of the menu item IDs are determined and those const int values
                // are used at run time. They don't change during execution or even from session to session of a
                // given build/release of the application. So we should be able to ignore them in our AI_MenuStructure
                // especially since the mainMenuIDint value never changes.
                pSubMenuItem->subMenuIDint = pmbSubMenuItem->GetId(); // GetId() returns -2 for menu separator
                pSubMenuItem->subMenuLabel = pmbSubMenuItem->GetItemLabel();
                pSubMenuItem->subMenuHelp = pmbSubMenuItem->GetHelp();
                pSubMenuItem->subMenuKind = GetMenuItemKindAsString(pmbSubMenuItem->GetKind());
                // insert the sub menu id string/int association into the m_mapMenuLabelStrToIdInt if none already exists
                // Note: we remove menu decorations since we want to be able to look up the plain label in
                // the map
                wxString subMenuItemLabelPlain = pSubMenuItem->subMenuLabel; //RemoveMenuLabelDecorations(pSubMenuItem->subMenuLabel);
                if (pSubMenuItem->subMenuKind == _T("wxITEM_SEPARATOR"))
                    subMenuItemLabelPlain = _T("menuSeparator");

                // Note: the \t chars in the xml and internal strings become \\t literals
                // and need to be changed to \t to work in the menus.
                wxString labelStr = subMenuItemLabelPlain;
                subMenuItemLabelPlain.Replace(_T("\\t"), _T("\t"));

                iter = m_mapMenuLabelStrToIdInt.find(subMenuItemLabelPlain);
                if (iter != m_mapMenuLabelStrToIdInt.end())
                {
                    // key exists in the map
                    m_mapMenuLabelStrToIdInt.insert(*iter); // associates (any new) pNewTU value with the keyCopy
                }
                else
                {
                    // key not in the map
                    // The [] index operator can be used either of two ways in assignment statement
                    m_mapMenuLabelStrToIdInt[subMenuItemLabelPlain] = pSubMenuItem->subMenuIDint; // clearest
                    // or, the following is equivalent, but not so clear
                    // pThisMap->operator[](keyCopy) = pSubMenuItem->subMenuIDint;
                    // NOTE: The docs say of the wxHashMap::operator[] "Use it as an array subscript.
                    // The only difference is that if the given key is not present in the hash map,
                    // an element with the default value_type() is inserted in the table."
                }
                // add pSubMenuItem to the pMainMenuItem's aiSubMenuItems list
                pMainMenuItem->aiSubMenuItems.Append(pSubMenuItem);
            }
            pMenuStructure->aiMainMenuItems.Append(pMainMenuItem);
        }
    }

    // Note: calling delete on pMenuBar is sufficient; because of its hierarchy of ownership
    // all of its child objects get destroyed automatically.
    if (pMenuBar != NULL) // whm 11Jun12 added NULL test
        delete pMenuBar;
    pMenuBar = (wxMenuBar*)NULL;
}

// This function's code borrowed brom SetupDefaultMenuStructure(). In this function, however, we do not
// build any AI_MenuStructure, but simply populate the m_mapMenuLabelStrToIdInt map with the untranslated
// unlocalized menu strings. Hence this function is called before any non-English locale catalog is loaded
// in OnInit().
void CAdapt_ItApp::SetupUnTranslatedMapMenuLabelStrToIdInt(MapMenuLabelStrToIdInt& m_mapMenuLabelStrToIdInt)
{
    wxMenuBar* pMenuBar;
    pMenuBar = AIMenuBarFunc();
    wxASSERT(pMenuBar != NULL);

    MapMenuLabelStrToIdInt::iterator iter;
    m_mapMenuLabelStrToIdInt.clear(); // OK to call clear() here

    if (pMenuBar == NULL)
    {
        wxASSERT(FALSE);
        wxLogDebug(_T("The pointer to the temporary AI menu bar is NULL\n -   aborting the SetupDefaultMenuStructure() function"));
        return;
    }
    int ct;
    int mbct = pMenuBar->GetMenuCount(); // get the number of top level menu items
    for (ct = 0; ct < mbct; ct++)
    {
        wxMenu* pmbMainMenuItem = pMenuBar->GetMenu(ct); // AI menu bar
        wxASSERT(pmbMainMenuItem != NULL);
        if (pmbMainMenuItem != NULL)
        {
            //pMainMenuItem = new AI_MainMenuItem;
            //wxASSERT(pMainMenuItem != NULL);
            //// initialize the new pMainMenuItem's members
            //pMainMenuItem->mainMenuIDint = -1;
            ////pMainMenuItem->mainMenuID = _T("");
            //pMainMenuItem->mainMenuLabel = _T("");
            //pMainMenuItem->aiSubMenuItems.Clear();

            // get values for pMainMenuItem's members from the temp AI menu bar pMenuBar
            wxString mbMainMenuText = pMenuBar->GetMenuLabel(ct); // includes accelerator chars
            //pMainMenuItem->mainMenuLabel = mbMainMenuText;
            // For some reason a wxMenu item (top level or sub menu item) does not have a
            // GetId() method. Only a wxMenuItem has a GetId() method. Hence, we have to
            // determine the int ID of a main menu item in a round-about way.

            //pMainMenuItem->mainMenuIDint = GetTopLevelMenuID(mbMainMenuText); // Note: a top level menu cannot be menuSeparator
            //pMainMenuItem->mainMenuID = // we can get along without this string representation mainMenuID
            // Consider: When the compiled all of the menu item IDs are determined and those const int values
            // are used at run time. They don't change during execution or even from session to session of a
            // given build/release of the application. So we should be able to ignore them in our AI_MenuStructure
            // especially since the mainMenuIDint value never changes.

            // insert the main menu id string/int association into the m_mapMenuLabelStrToIdInt if none already exists
            // Note: we remove menu decorations since we want to be able to look up the plain label in
            // the map
            wxString mainMenuItemLabelPlain = mbMainMenuText; //RemoveMenuLabelDecorations(mbMainMenuText);
            iter = m_mapMenuLabelStrToIdInt.find(mainMenuItemLabelPlain);
            if (iter != m_mapMenuLabelStrToIdInt.end())
            {
                // key exists in the map
                m_mapMenuLabelStrToIdInt.insert(*iter); // associates (any new) pMainMenuItem->mainMenuIDint value with the keyCopy
            }
            else
            {
                // key not in the map
                // The [] index operator can be used either of two ways in assignment statement
                m_mapMenuLabelStrToIdInt[mainMenuItemLabelPlain] = GetTopLevelMenuID(mbMainMenuText); //pMainMenuItem->mainMenuIDint; // clearest
                // or, the following is equivalent, but not so clear
                // pThisMap->operator[](mbMainMenuText) = pMainMenuItem->mainMenuIDint;
                // NOTE: The docs say of the wxHashMap::operator[] "Use it as an array subscript.
                // The only difference is that if the given key is not present in the hash map,
                // an element with the default value_type() is inserted in the table."
            }

            int i;
            int imbct;
            imbct = pmbMainMenuItem->GetMenuItemCount(); // AI menu bar
            for (i = 0; i < imbct; i++)
            {
                wxMenuItemList pmbSubMenuItems = pmbMainMenuItem->GetMenuItems(); // AI menu bar
                wxMenuItemList::Node* mbListNode; // AI menu bar
                mbListNode = pmbSubMenuItems.Item(i); // AI menu bar
                wxMenuItem* pmbSubMenuItem = mbListNode->GetData(); // AI menu bar
                wxASSERT(pmbSubMenuItem != NULL);
                //pSubMenuItem = new AI_SubMenuItem;
                //// initialize pSubMenuItem's members
                //wxASSERT(pSubMenuItem != NULL);
                ////pSubMenuItem->subMenuID = _T("");
                //pSubMenuItem->subMenuIDint = -1;
                //pSubMenuItem->subMenuLabel = _T("");
                //pSubMenuItem->subMenuHelp = _T("");
                //pSubMenuItem->subMenuKind = _T("");

                // get values for pSubMenuItem's members from the temp AI menu bar pMenuBar's
                // pmbSubMenuItem objects
                //pSubMenuItem->subMenuID = // we can get along without this string representation mainMenuID
                // Consider: When the compiled all of the menu item IDs are determined and those const int values
                // are used at run time. They don't change during execution or even from session to session of a
                // given build/release of the application. So we should be able to ignore them in our AI_MenuStructure
                // especially since the mainMenuIDint value never changes.
                //pSubMenuItem->subMenuIDint = pmbSubMenuItem->GetId(); // GetId() returns -2 for menu separator
                //pSubMenuItem->subMenuLabel = pmbSubMenuItem->GetItemLabel();
                //pSubMenuItem->subMenuHelp = pmbSubMenuItem->GetHelp();
                //pSubMenuItem->subMenuKind = GetMenuItemKindAsString(pmbSubMenuItem->GetKind());
                // insert the sub menu id string/int association into the m_mapMenuLabelStrToIdInt if none already exists
                // Note: we remove menu decorations since we want to be able to look up the plain label in
                // the map
                wxString subMenuItemLabelPlain = pmbSubMenuItem->GetItemLabel(); //pSubMenuItem->subMenuLabel; //RemoveMenuLabelDecorations(pSubMenuItem->subMenuLabel);
                if (GetMenuItemKindAsString(pmbSubMenuItem->GetKind()) == _T("wxITEM_SEPARATOR")) //if (pSubMenuItem->subMenuKind == _T("wxITEM_SEPARATOR"))
                    subMenuItemLabelPlain = _T("menuSeparator");

                // Note: the \t chars in the xml and internal strings become \\t literals
                // and need to be changed to \t to work in the menus.
                wxString labelStr = subMenuItemLabelPlain;
                subMenuItemLabelPlain.Replace(_T("\\t"), _T("\t"));

                iter = m_mapMenuLabelStrToIdInt.find(subMenuItemLabelPlain);
                if (iter != m_mapMenuLabelStrToIdInt.end())
                {
                    // key exists in the map
                    m_mapMenuLabelStrToIdInt.insert(*iter); // associates (any new) pNewTU value with the keyCopy
                }
                else
                {
                    // key not in the map
                    // The [] index operator can be used either of two ways in assignment statement
                    m_mapMenuLabelStrToIdInt[subMenuItemLabelPlain] = pmbSubMenuItem->GetId(); //pSubMenuItem->subMenuIDint; // clearest
                    // or, the following is equivalent, but not so clear
                    //pThisMap->operator[](keyCopy) = pSubMenuItem->subMenuIDint;
                    // NOTE: The docs say of the wxHashMap::operator[] "Use it as an array subscript.
                    // The only difference is that if the given key is not present in the hash map,
                    // an element with the default value_type() is inserted in the table."
                }
                // add pSubMenuItem to the pMainMenuItem's aiSubMenuItems list
                //pMainMenuItem->aiSubMenuItems.Append(pSubMenuItem);
            }
            //pMenuStructure->aiMainMenuItems.Append(pMainMenuItem);
        }
    }

    // Note: calling delete on pMenuBar is sufficient; because of its hierarchy of ownership
    // all of its child objects get destroyed automatically.
    if (pMenuBar != NULL) // whm 11Jun12 added NULL test
    {
        // whm modified 12Jan13 to use the method shown in the OnDeleteMenu()
        // function of the wxWidgets menu sample program. The Linux version
        // sometimes would otherwise crash here when the code previously just
        // did delete pMenuBar. We first delete all the wxMenu instances from
        // pMenuBar and then delete the pMenuBar itself - the reverse of the
        // new calls within the wxDesigner's AIMenuBarFunc() above that
        // created the menu bar.
        int count = (int)pMenuBar->GetMenuCount();
        wxMenu* pMenu;
        int ct;
        // To preserve the position indices remove the menu items in
        // reverse order. With a zero-based position index, the last menu
        // item's position is count-1.
        for (ct = count - 1; ct >= 0; ct--)
        {
            pMenu = pMenuBar->Remove(ct);
            delete pMenu;
        }
        delete pMenuBar;
        pMenuBar = (wxMenuBar*)NULL;
    }
}

/*
// The following version of SetupDefaultMenuStructure() was based on collecting the
// necessary data from the defaultMenuStructure[] array of strings in the App. This
// version was replaced by another version (see above) that collects the same data
// but does so from a temporary AI menu bar, thus eliminating the need to store the
// redundant defaultMenuStructure[] array.
/////////////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \param      <- pMenuStructure  a pointer to the AI_MenuStructure struct that is being populated
/// \remarks
/// Called from: the App's OnInit() and CAdminEditMenuProfile::InitDialog. It is only
/// called if the app cannot find the AI_UserProfiles.xml file and it must use
/// SetupDefaultMenuStructure() to establish its internal representation of the default
/// menu structure. When AI_UserProfiles.xml is available (the usual case) the
/// m_pAI_MenuStructure is populated by the AtPROFILEEndTag() function in XML.cpp,
/// rather than by this SetupDefaultMenuStructure() function.
/////////////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItApp::SetupDefaultMenuStructure(AI_MenuStructure*& pMenuStructure)
{
wxString field = _T("");
int nDefaultMenuStructureItems;
AI_MainMenuItem* pMainMenuItem = NULL;
AI_SubMenuItem* pSubMenuItem = NULL;
nDefaultMenuStructureItems = sizeof(defaultMenuStructure)/sizeof(wxString);
int i;
for (i = 0; i < nDefaultMenuStructureItems; i++)
{
// scan and parse each defaultProfileItems line
field.Empty();
int ct;
for (ct = 0; ct < (int)defaultMenuStructure[i].Length(); ct++)
{
// defaultMenuStructure[i] represents a whole string line of concatenated tags, attributes and values
wxString lineStr;
lineStr = defaultMenuStructure[i];
if (lineStr.GetChar(ct) != _T(':'))
{
field += lineStr.GetChar(ct);
}
else
{
// we're at the end of a field and field contains the string token
// up to, but not including the : delimiter.
// If the field doesn't have an '=' in it, it should be an all-caps
// tag name; if it has an '=' in it, the field should contain an
// attribute name followed by the '=' with the attribute's value
// within quote marks, i.e., attributeName="value".
// Parse the field into its parts
if (field.Find(_T("=")) == wxNOT_FOUND)
{
// No '=' in the field so field itself should be a tag name
if (field == wxString::FromAscii(sub_menu))
{
pSubMenuItem = new AI_SubMenuItem;
pSubMenuItem->subMenuID = _T("");
pSubMenuItem->subMenuLabel = _T("");
pSubMenuItem->subMenuHelp = _T("");
pSubMenuItem->subMenuKind = _T("");
}
else if (field == wxString::FromAscii(end_sub_menu))
{
wxASSERT(pSubMenuItem != NULL);
wxASSERT(pMainMenuItem != NULL);
pMainMenuItem->aiSubMenuItems.Append(pSubMenuItem);
pSubMenuItem = (AI_SubMenuItem*)NULL; // ready for the next use
}
else if (field == wxString::FromAscii(main_menu))
{
pMainMenuItem = new AI_MainMenuItem;
pMainMenuItem->mainMenuID = _T("");
pMainMenuItem->mainMenuLabel = _T("");
pMainMenuItem->aiSubMenuItems.Clear();
}
else if (field == wxString::FromAscii(end_main_menu))
{
wxASSERT(pMenuStructure != NULL);
wxASSERT(pMainMenuItem != NULL);
pMenuStructure->aiMainMenuItems.Append(pMainMenuItem);
pMainMenuItem = (AI_MainMenuItem*)NULL; // ready for the next use
}
else if (field == wxString::FromAscii(menuStructure))
{
pMenuStructure = new AI_MenuStructure;
pMenuStructure->aiMainMenuItems.Clear();
}
else if (field == wxString::FromAscii(end_menuStructure))
{
;
}
}
else
{
// field has an '=' char in it so it should be an attribute/value
// representation
wxString attrStr;
wxString valueStr;
attrStr = field.Mid(0,field.Find(_T("=")));
attrStr.Trim(FALSE);
attrStr.Trim(TRUE);
valueStr = field.Mid(field.Find(_T("=")));
valueStr.Replace(_T("="),_T(""));
valueStr.Replace(_T("\""),_T(""));
valueStr.Trim(FALSE);
valueStr.Trim(TRUE);
if (attrStr == wxString::FromAscii(subMenuID))
{
wxASSERT(pSubMenuItem != NULL);
pSubMenuItem->subMenuID = valueStr;
}
else if (attrStr == wxString::FromAscii(subMenuLabel))
{
wxASSERT(pSubMenuItem != NULL);
pSubMenuItem->subMenuLabel = valueStr;
}
else if (attrStr == wxString::FromAscii(subMenuHelp))
{
wxASSERT(pSubMenuItem != NULL);
pSubMenuItem->subMenuHelp = valueStr;
}
else if (attrStr == wxString::FromAscii(subMenuKind))
{
wxASSERT(pSubMenuItem != NULL);
pSubMenuItem->subMenuKind = valueStr;
}
else if (attrStr == wxString::FromAscii(mainMenuLabel))
{
wxASSERT(pMainMenuItem != NULL);
pMainMenuItem->mainMenuLabel = valueStr;
}
else if (attrStr == wxString::FromAscii(mainMenuID))
{
wxASSERT(pMainMenuItem != NULL);
pMainMenuItem->mainMenuID = valueStr;
}
}

field.Empty(); // ready for next field
}
}
// We're at the end of a parsed line
}
}
*/

/////////////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \param      <- pUserProfiles  a pointer to the UserProfiles struct that is being destroyed
/// \remarks
/// Called from: the App's OnInit(), OnExit(), CAdminEditMenuProfile's InitDialog(), and
/// its class destructor and ReportMenuAndUserProfilesInconsistencies().
/// It deallocates the memory of the profileItemList items, and finally of the pUserProfiles
/// itself.
/////////////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItApp::DestroyUserProfiles(UserProfiles*& pUserProfiles)
{
    if (pUserProfiles != NULL)
    {
        ProfileItemList::Node* pos_profileList;
        int count;
        int item_count = (int)pUserProfiles->profileItemList.GetCount();
        for (count = 0; count < item_count; count++)
        {
            pos_profileList = pUserProfiles->profileItemList.Item(count);
            UserProfileItem* pItem;
            pItem = pos_profileList->GetData();
            //wxLogDebug(_T("Deleting UserProfileItem %s"),pItem->itemText.c_str());
            if (pItem != NULL) // whm 11Jun12 added NULL test
                delete pItem;
            pItem = (UserProfileItem*)NULL;
        }
        pUserProfiles->profileItemList.Clear();
        //wxLogDebug(_T("Deleting m_pUserProfiles - end"));
        if (pUserProfiles != NULL) // whm 11Jun12 added NULL test
            delete pUserProfiles;
        pUserProfiles = (UserProfiles*)NULL;
    }
}


/////////////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \param      <- pMenuStructure  a pointer to the AI_MenuStructure struct that is
///                 being destroyed
/// \remarks
/// Called from: the App's OnExit().
/// It deallocates the memory of the individual main menu items and sub menu items,
/// and finally of the pMenuStructure itself.
/////////////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItApp::DestroyMenuStructure(AI_MenuStructure*& pMenuStructure)
{
    if (pMenuStructure != NULL)
    {
        MainMenuItemList::Node* mmpos;
        int ct_mm;
        int total_mm = (int)pMenuStructure->aiMainMenuItems.GetCount();
        for (ct_mm = 0; ct_mm < total_mm; ct_mm++)
        {
            mmpos = pMenuStructure->aiMainMenuItems.Item(ct_mm);
            AI_MainMenuItem* pmmItem;
            pmmItem = mmpos->GetData();
            wxASSERT(pmmItem != NULL);

            SubMenuItemList::Node* smpos;
            int ct_sm;
            int total_sm = (int)pmmItem->aiSubMenuItems.GetCount();
            for (ct_sm = 0; ct_sm < total_sm; ct_sm++)
            {
                smpos = pmmItem->aiSubMenuItems.Item(ct_sm);
                AI_SubMenuItem* psmItem;
                psmItem = smpos->GetData();
                wxASSERT(psmItem != NULL);
                //wxLogDebug(_T("Deleting submenu Item %s"),psmItem->subMenuLabel.c_str());
                if (psmItem != NULL) // whm 11Jun12 added NULL test
                    delete psmItem;
                psmItem = (AI_SubMenuItem*)NULL;
            }
            pmmItem->aiSubMenuItems.Clear();
            //wxLogDebug(_T("Deleting mainmenu Item %s"),pmmItem->mainMenuLabel.c_str());
            if (pmmItem != NULL) // whm 11Jun12 added NULL test
                delete pmmItem;
            pmmItem = (AI_MainMenuItem*)NULL;
        }
        pMenuStructure->aiMainMenuItems.Clear();
        //wxLogDebug(_T("Deleting m_pAI_MenuStructure - end"));
        if (pMenuStructure != NULL) // whm 11Jun12 added NULL test
            delete pMenuStructure;
        pMenuStructure = (AI_MenuStructure*)NULL;
    }
}

/////////////////////////////////////////////////////////////////////////////////////////
/// \return     TRUE on success, FALSE if a problem occurred
/// \param      -> fullFilePath  path and file name of the AI_UserProfiles.xml file being
///                 accessed (may be the one in work folder or setup install folder)
/// \remarks
/// Called from the App's OnEditUserMenuSettingsProfiles() after User Workflow
/// Profiles editing, and from the App's OnInit() to upgrade (or downgrade) a
/// modified AI_UserProfiles.xml file to a newer (or older) version after a
/// version update.
/// SaveUserProfilesMergingDataToXMLFile() saves edits of user profiles to the
/// wxTextFile representing AI_UserProfiles.xml file on disk.
/// The AI_UserProfiles.xml file is fairly small (only about 45kb) so we
/// open it as a wxTextFile (into memory), make necessary changes according
/// to the current m_pUserProfiles and write it back out in a single write
/// operation. If AI_UserProfiles.xml doesn't exist we create a new wxTextFile
/// and call BuildUserProfileXMLFile() passing our new wxTextFile to that
/// function to create one anew. We can do double duty with this function:
/// (1) Save edits made by an administrator to the User Workflow Profiles dialog
/// back to the AI_UserProfiles.xml file located in the work folder, or
/// (2) Merge the edits of a modified existing AI_UserProfiles.xml file into
/// a newer version of AI_UserProfiles.xml that was installed as an AI version
/// update since the last running of the application.
/// The path established in OnInit() to the AI_UserProfiles.xml file is stored
/// in the m_userProfileFileWorkFolderPath member variable.
/////////////////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItApp::SaveUserProfilesMergingDataToXMLFile(wxString fullFilePath)
{
    // Note: fullFilePath can be the user's work folder, or the install setup folder
    wxTextFile textFile;

    // Does AI_UserProfiles.xml exist in the work folder
    bool bUserProfilesFileExists = wxFileExists(fullFilePath);
    wxString userProfileFileSetupInstallPath = m_xmlInstallPath + PathSeparator + _T("AI_UserProfiles.xml");

    bool bThisIsAnUpgradeOfProfileFile;
    if (fullFilePath == userProfileFileSetupInstallPath)
        bThisIsAnUpgradeOfProfileFile = TRUE;
    else
        bThisIsAnUpgradeOfProfileFile = FALSE;

    if (!bUserProfilesFileExists)
    {
        // No AI_UserProfiles.xml file exists at the fullFilePath location
        // This shouldn't happen in the case we are being called to merge a newer AI_UserProfiles.xml
        // file with a modified AI_UserProfiles.xml in the user's work folder, but for safety sake:
        if (bThisIsAnUpgradeOfProfileFile)
        {
            // The fullFilePath pointed to a AI_UserProfiles.xml file in the install setup
            // folder, but no AI_UserProfiles.xml exist there. There is nothing to merge
            // and we don't want to create one there since that is the job of the AI installation
            // process, so just return FALSE from SaveUserProfilesMergingDataToXMLFile(). Any
            // error/warning messages are the responsibility of the caller.
            return FALSE;
        }
        wxString msg = _("The AI_UserProfiles.xml file was not located at the following path:\n   %s\nA new AI_UserProfiles.xml file will be created there.");
        msg = msg.Format(msg, fullFilePath.c_str());
        wxMessageBox(msg, _T(""), wxICON_EXCLAMATION | wxOK);
        // Construct a new AI_UserProfiles.xml file from our internal data
        textFile.Create(fullFilePath); // Create() must only be called when the file doesn't exist - verified above
                                       // Note textFile is empty at this point
        bool bOK;
        bOK = textFile.Open(fullFilePath);
        wxCHECK_MSG(bOK, FALSE, _T("SaveUserProfilesMergingDataToXMLFile() didn't open textFile in !bUserProfilesFileExists block"));
        BuildUserProfileXMLFile(&textFile);
        // Write the modified wxText file back out to disk
        bOK = textFile.Write(); // no need to do anything special for Unicode
        wxCHECK_MSG(bOK, FALSE, _T("SaveUserProfilesMergingDataToXMLFile() textFile.Write() failed in !bUserProfilesFileExists block"));
    }
    else
    {
        // Read the existing xml file into memory using wxTextFile, so we don't have
        // to recreate the whole xml file. All we need to do is to compare the data in
        // memory with the xml file which is in memory as a wxTextFile, and make changes
        // there before saving the file back to disk.
        // Note: fullFilePath may point to the AI_UserProfiles.xml in the setup folder (when
        // merging changes into an upgraded AI_UserProfiles.xml), or it may point to the
        // AI_UserProfiles.xml in the user's work folder (when doing a normal save/merge of
        // changes made in the User Workflow Profiles dialog).
        bool bOpenedOK;
        bOpenedOK = textFile.Open(fullFilePath);
        if (!bOpenedOK)
        {
            wxString msg = _("Unable to open the AI_UserProfiles.xml file at the following path:\n   %s\nChanges to user workflow profiles will not be saved.\nEnsure that the AI_UserProfiles.xml file is not open in another program, then try again.");
            msg = msg.Format(msg, fullFilePath.c_str());
            wxMessageBox(msg, _T(""), wxICON_EXCLAMATION | wxOK);
            return FALSE;
        }
        else
        {
            // The AI_UserProfiles.xml file is now in memory and accessible line-by-line through the
            // methods of wxTextFile.
            // Note: The AI_UserProfiles.xml file was read from the user's work folder and parsed into
            // the m_pUserProfiles struct prior to the calling of SaveUserProfileMergingDataToXMLFile().
            // (whether in InitDialog in the AdminEditMenuProfile class or in the App's OnInit). Therefore,
            // the AI_UserProfiles.xml file (just read above into memory as a wxTextFile) is either
            // identical in structure to the xml file on disk (when saving edits) or similar if not
            // identical in structure (for version upgrade). If identical, the process below should
            // account for all changes. If we are merging changes into a newer AI_UserProfiles.xml file
            // from the setup folder, there may be more candidate profile items in the setup folder's
            // version than in the current work folder's version. Those will simply retain their
            // existing defaul values. If the setup folder's version has fewer candidate profile items (not
            // likely) and a change was made for one of those now-missing items, the change will simply be
            // ignored. During editing in AdminEditMenuProfile dialog, only small parts of the xml data
            // would be modified as a result of the editing process. An administrator could have edited
            // the following from within the dialog:
            // 1. The UserProfiles' wxArrayString of descriptionProfileTexts (4 items, one for each profile)
            //    may have been edited (total of 4 strings of varying length).
            // 2. The UserProfileItem's wxArrayString of usedVisibilityValues (4 items, one for each profile
            //    x 67 profile items) may have been edited (total of 268 1-character strings of the form
            //    "1" or "0".
            // Note: When an administrator only changes the profile selected, but not any individual profile
            // item visibility checkboxes, he does not make any changes to AI_UserProfiles.xml (his change of
            // profile is simply recorded in the project config file.
            //
            // Our approach will be to go through our map of profile changes (m_mapProfileChangesToStringValues)
            // and change the individual lines in our wxTextFile that need to be changed to reflect the
            // administrator's edits. When finished we simply write the wxTextFile back to disk replacing
            // the existing AI_UserProfiles.xml file. If we read AI_UserProfiles.xml from the setup folder,
            // we don't write it back there, but we write it to the current work folder, replacing the
            // older version that was there - which will now have the new version number in its
            // applicationCompatibility attribute matching the one copied from the setup folder.
            // In order to write a wxTextFile to a different location than where we got it in the Open()
            // call, there doesn't appear to be a way to change the writing path, so we will create a new
            // wxTextFile instance, copy all lines from the one we've changed to it and write this new file
            // and simply close the original instance without writing it back to the setup folder.
            //
            // The map key values can be:
            //    1. A contatenation of the string values of itemText + ":" + userProfile for a given
            //       UserProfileItem, for example: "Save As...:Novice"
            //    2. A key may also be the string "descriptionProfileN" where N is 1, 2, 3, or 4 for
            //       those top level items, for example "description3"
            // The key maps to a variable length string for the descriptionProfileN key, and to a
            // "1" or a "2" string for UserProfileItems visibility items.
            wxString keyFromMap;
            wxString valueFromMap;
            MapProfileChangesToStringValues::iterator iter;
            for (iter = m_mapProfileChangesToStringValues.begin(); iter != m_mapProfileChangesToStringValues.end(); ++iter)
            {
                keyFromMap = iter->first;
                valueFromMap = iter->second;
                wxLogDebug(_T("iter->first = %s, iter->second = %s"), keyFromMap.c_str(), valueFromMap.c_str());
                wxString itemTextStr, userProfileStr, descriptionProfileN;
                int colonPos = keyFromMap.Find(_T(':'));
                if (colonPos != wxNOT_FOUND)
                {
                    // the keyFromMap is of the form itemText:Novice
                    itemTextStr = keyFromMap.Mid(0, colonPos);
                    userProfileStr = keyFromMap.Mid(colonPos + 1);
                    // in the wxTextFile we search for the line that has itemText="itemTextStr" and
                    // from that line we step through each succeeding line until we come to a line
                    // that has <PROFILE userProfile="userProfileStr"
                    // from that line we get the next line, i.e., itemVisibility="x" and replace
                    // the "x" part with the "valueFromMap" (see ReplaceVisibilityStrInwxTextFile).
                    int linePos;
                    linePos = ReplaceVisibilityStrInwxTextFile(&textFile, itemTextStr, userProfileStr, valueFromMap);
                    if (linePos == wxNOT_FOUND)
                    {
                        // unable to save the field in the wxTextFile
                        wxASSERT(FALSE); // notify programmer
                        return FALSE;
                    }
                }
                else
                {
                    // the keyFromMap is of the form descriptionProfileN where N is 1, 2, 3, or 4.
                    descriptionProfileN = keyFromMap;
                    // In the wxTextFile we search for the line that has descriptionProfileN="str"
                    // and we replace the "str" with "valueFromMap".
                    // Note: Entity chars are replaced by their xml mandated form (xml_lt, xml_gt,
                    // xml_amp, xml_apos, and xml_quote and xml_tab) in ReplaceDescriptionStrInwxTextFile() below.
                    int linePos;
                    linePos = ReplaceDescriptionStrInwxTextFile(&textFile, descriptionProfileN, valueFromMap);
                    if (linePos == wxNOT_FOUND)
                    {
                        // unable to save the field in the wxTextFile
                        wxASSERT(FALSE); // notify programmer
                        return FALSE;
                    }
                }
            }
            // Lastly, we update the wxTextFile line that contains the attribute: adminModified="" is
            // changed to either adminModified="Yes" or adminModified="No", depending on whether the
            // above edits changed the data to differ from the factory defaults.
            UpdateAdminModifiedLineToYesOrNo(&textFile);
        }
        // Write the modified wxText file back out to disk.
        // Note: If bThisIsAnUpgradeOfProfileFile is TRUE, we don't write the file back to its
        // original setup up folder location, but instead create a new wxTextFile, copy the contents
        // of the one we've modified and write the upgraded one to the user's work folder.
        if (bThisIsAnUpgradeOfProfileFile)
        {
            // This is an upgrade operation, so create a new wxTextFile
            wxTextFile newTextFile;
            // wxTextFile::Create() fails when there already exists the file of the same name
            // so we first remove the existing one in the work folder
            wxASSERT(!m_userProfileFileWorkFolderPath.IsEmpty());
            bool bRemovedFile = FALSE;
            wxString msg = _("Adapt It could not upgrade AI_UserProfiles.xml (modified) with the newer version from the last Adapt It installation.\nAI_UserProfiles.xml may be in use by another program.");
            wxString titleMsg;
            if (wxFileExists(m_userProfileFileWorkFolderPath))
            {
                bRemovedFile = wxRemoveFile(m_userProfileFileWorkFolderPath);
                // tell user if we couldn't remove the work folder's AI_UserProfiles.xml
                if (!bRemovedFile)
                {
                    // error message
                    titleMsg = _("Unable to remove existing AI_UserProfiles.xml file");
                    // msg = _("Adapt It could not upgrade AI_UserProfiles.xml (modified) with the newer version from the last Adapt It installation.\nAI_UserProfiles.xml may be in use by another program.");

                    // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
                    m_bUserDlgOrMessageRequested = TRUE;

                    wxMessageBox(msg, titleMsg, wxICON_EXCLAMATION | wxOK);
                    return FALSE;
                }
            }
            bool bCreatedOK, bOpenedOK;
            bCreatedOK = newTextFile.Create(m_userProfileFileWorkFolderPath);
            wxCHECK_MSG(bCreatedOK, FALSE, _T("SaveUserProfilesMergingDataToXMLFile() newTextFile.Create() failed in bThisIsAnUpgradeOfProfileFile block"));
            bOpenedOK = newTextFile.Open();
            wxCHECK_MSG(bOpenedOK, FALSE, _T("SaveUserProfilesMergingDataToXMLFile() newTextFile.Open() failed in bThisIsAnUpgradeOfProfileFile block"));
            if (newTextFile.IsOpened())
            {
                // now copy the lines from textFile to newTextFile
                int ct;
                int nLines = textFile.GetLineCount();
                for (ct = 0; ct < nLines; ct++)
                {
                    wxString lineStr = textFile.GetLine(ct);
                    newTextFile.AddLine(lineStr);
                }
                // save the newTextFile
                bool bWriteOK;
                bWriteOK = newTextFile.Write();
                wxASSERT(bWriteOK != FALSE);
                if (!bWriteOK)
                {

                    // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
                    m_bUserDlgOrMessageRequested = TRUE;
                    // error message
                    titleMsg = _("Unable to create a new AI_UserProfiles.xml file");
                    //msg = _("Adapt It could not upgrade AI_UserProfiles.xml (modified) with the newer version from the last Adapt It installation.\nAI_UserProfiles.xml may be in use by another program.");
                    wxMessageBox(msg, titleMsg, wxICON_EXCLAMATION | wxOK);
                    return FALSE;
                }
                newTextFile.Close();
            }
            else
            {
                // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
                m_bUserDlgOrMessageRequested = TRUE;
                // error message
                titleMsg = _("Unable to create a new AI_UserProfiles.xml file");
                //msg = _("Adapt It could not upgrade AI_UserProfiles.xml (modified) with the newer version from the last Adapt It installation.\nAI_UserProfiles.xml may be in use by another program.");
                wxMessageBox(msg, titleMsg, wxICON_EXCLAMATION | wxOK);
                return FALSE;
            }

        }
        else
        {
            // This is a normal save of edits that have been done in the User Workflow Profile
            // dialog, so write it back to its same location
            textFile.Write(); // no need to do anything special for Unicode
            textFile.Close();
        }
    }
    return TRUE;
}

/////////////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \param      -> tempUserProfiles  pointer to the UserProfiles* being compared
/// \param      -> appUserProfiles  pointer to the UserProfiles* the tempUserProfiles
///                 if being compared with to determine changes
/// \remarks
/// Called from the App's OnInit(), and from CAdminEditMenuProfile::OnOK().
/// Populates the App's m_mapProfileChangesToStringValues with user profile changes the user
/// has made to descriptionProfileTexts and/or to UserProfileItems' usedVisibilityValues.
/// The map is used to make changes in the wxTextFile representation of AI_UserProfiles.xml
/// before writing it back to disk in SaveUserProfilesMergingDataToXMLFile().
/// Note: the caller is responsible to call m_mapProfileChangesToStringValues.clear(),
/// to start a fresh map of changes.
/////////////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItApp::MapChangesInUserProfiles(UserProfiles* tempUserProfiles, UserProfiles* appUserProfiles)
{
    // whm 21Oct10 rewritten so that tempUserProfiles and appUserProfiles can have different counts for their
    // ->descriptionProfileTexts.GetCount() and different counts for their ->profileItemList.GetCount()
    // calls. This will avoid problems for when MapChangesInUserProfiles() is called in OnInit() in the
    // process of upgrading or downgrading versions which involve AI_UserProfiles.xml files having
    // different numbers of these items.
    // Strategy: Fill a temporary map with all items from tempUserProfiles. Then go through all items
    // in the appUserProfiles struct and lookup each item from appUserProfiles to see if it is already
    // in the map of tempUserProfiles items. If it is compare the data of those "common" items only.
    // For those which have changes, enter only the changes in the m_mapProfileChangesToStringValues map.
    // In the process, keep track of how many items were not in common and report that number back through
    // a return value or reference parameter.
    wxASSERT(tempUserProfiles != NULL);
    wxASSERT(appUserProfiles != NULL);

    if (tempUserProfiles != NULL && appUserProfiles != NULL)
    {
        MapProfileChangesToStringValues tempMap;
        MapProfileChangesToStringValues::iterator iter;
        //m_mapProfileChangesToStringValues.clear();
        // Note: The clear() method must be invoked in the caller if a fresh map of changes is desired.

        // Enter all tempUserProfiles items into our tempMap
        // First enter all of tempUserProfiles->descriptionProfileTexts into the map
        int descCt;
        int descTot = (int)tempUserProfiles->descriptionProfileTexts.GetCount();
        for (descCt = 0; descCt < descTot; descCt++)
        {
            // enter all of tempUserProfiles->descriptionProfileTexts into the map
            wxString key = wxString::FromAscii(descriptionProfile);
            key << descCt + 1; // add the numerical suffix as string "1", "2", "3", or "4"
            iter = tempMap.find(key);
            if (iter != tempMap.end())
            {
                // key exists in the map
                tempMap.insert(*iter);
            }
            else
            {
                // key not in the map
                tempMap[key] = tempUserProfiles->descriptionProfileTexts[descCt];
            }
        }
        // Next, enter all of tempUserProfiles->profileItemList items into the tempMap
        ProfileItemList::Node* tpos;
        int count;
        int t_tot = (int)tempUserProfiles->profileItemList.GetCount();
        for (count = 0; count < t_tot; count++)
        {
            tpos = tempUserProfiles->profileItemList.Item(count);
            UserProfileItem* ptItem;
            ptItem = tpos->GetData();
            wxASSERT(ptItem != NULL);
            int ct;
            int ct_t;
            ct_t = (int)ptItem->usedVisibilityValues.GetCount();
            for (ct = 0; ct < ct_t; ct++)
            {
                wxString key = ptItem->itemText + _T(":") + ptItem->usedProfileNames[ct]; // key is itemText + ':' + name of the profile, i.e., "Save As...:Novice"
                iter = tempMap.find(key);
                if (iter != tempMap.end())
                {
                    // key exists in the map
                    tempMap.insert(*iter);
                }
                else
                {
                    // key not in the map
                    tempMap[key] = ptItem->usedVisibilityValues[ct];
                }
            }
        }
        // dump the map contents for testing
        //for( iter = tempMap.begin(); iter != tempMap.end(); ++iter )
        //{
        //	wxLogDebug(_T("iter->first = %s, iter->second = %s"),iter->first.c_str(),iter->second.c_str());
        //}

        // Now go through all items of the appUserProfiles struct, and do a lookup to see if
        // each item is in the map. If so, check the map's associated value. If the map's
        // associated value is different, then add that item to the App's
        // m_mapProfileChangesToStringValues map. If any of the appUserProfiles items are
        // not found in the map, we can ignore them, but just get a count of how many such
        // ignored items we encountered.

        int appCt;
        int appTot = (int)appUserProfiles->descriptionProfileTexts.GetCount();
        int nAppItemsNotAmongTempItems = 0;
        int nTempItemsNotAmongAppItems = (int)tempUserProfiles->descriptionProfileTexts.GetCount() + (4 * (int)tempUserProfiles->profileItemList.GetCount());
        for (appCt = 0; appCt < appTot; appCt++)
        {
            wxString key = wxString::FromAscii(descriptionProfile);
            key << appCt + 1; // add the numerical suffix as string "1", "2", "3", or "4"

            iter = tempMap.find(key);
            if (iter != tempMap.end())
            {
                // key exists in the map
                wxString keyTemp = iter->first;
                wxString valueTemp = iter->second;
                wxString appDescrText = appUserProfiles->descriptionProfileTexts.Item(appCt);
                // check if the valueTemp differs from the appDescrText
                if (valueTemp != appDescrText)
                {
                    // add item to m_mapProfileChangesToStringValues, our App's map of differences/changes
                    MapProfileChangesToStringValues::iterator a_iter;
                    a_iter = m_mapProfileChangesToStringValues.find(keyTemp);
                    if (a_iter != m_mapProfileChangesToStringValues.end())
                    {
                        // key exists in the map
                        m_mapProfileChangesToStringValues.insert(*a_iter);
                    }
                    else
                    {
                        // key not in the map
                        m_mapProfileChangesToStringValues[keyTemp] = valueTemp;
                    }
                }
                nTempItemsNotAmongAppItems--; // decrement from total tempUserProfile items - remainder at end is the significant total
            }
            else
            {
                // key not in the map
                nAppItemsNotAmongTempItems++;
            }
        }
        ProfileItemList::Node* apos;
        MapProfileChangesToStringValues::iterator a_iter;
        int a_tot = (int)appUserProfiles->profileItemList.GetCount();
        for (count = 0; count < a_tot; count++)
        {
            apos = appUserProfiles->profileItemList.Item(count);
            UserProfileItem* paItem;
            paItem = apos->GetData();
            wxASSERT(paItem != NULL);
            int ct;
            int ct_a;
            ct_a = (int)paItem->usedVisibilityValues.GetCount();
            for (ct = 0; ct < ct_a; ct++)
            {
                wxString key = paItem->itemText + _T(":") + paItem->usedProfileNames[ct]; // key is itemText + ':' + name of the profile, i.e., "Save As...:Novice"
                iter = tempMap.find(key);
                if (iter != tempMap.end())
                {
                    // key exists in the map
                    wxString keyTemp = iter->first;
                    wxString valueTemp = iter->second;
                    wxString appVisibility = paItem->usedVisibilityValues.Item(ct);
                    // check if the valueTemp differs from the appDescrText
                    if (valueTemp != appVisibility)
                    {
                        // add item to m_mapProfileChangesToStringValues, our App's map of differences/changes
                        a_iter = m_mapProfileChangesToStringValues.find(keyTemp);
                        if (a_iter != m_mapProfileChangesToStringValues.end())
                        {
                            // key exists in the map
                            m_mapProfileChangesToStringValues.insert(*a_iter);
                        }
                        else
                        {
                            // key not in the map
                            m_mapProfileChangesToStringValues[keyTemp] = valueTemp;
                        }
                    }
                    nTempItemsNotAmongAppItems--; // decrement from total tempUserProfile items - remainder at end is the significant total
                }
                else
                {
                    // key not in the map
                    nAppItemsNotAmongTempItems++;
                }
            }
        }
        // dump the map contents for testing
        //for( a_iter = m_mapProfileChangesToStringValues.begin(); a_iter != m_mapProfileChangesToStringValues.end(); ++a_iter )
        //{
        //	wxLogDebug(_T("a_iter->first = %s, a_iter->second = %s"),a_iter->first.c_str(),a_iter->second.c_str());
        //}
    }
}

/////////////////////////////////////////////////////////////////////////////////////////
/// \return     a VersionComparison enum with possible values of sameAppVersion,
///             runningAppVersionIsNewer, runningAppVersionIsOlder, or profileVersionDiffers
/// \param      -> oldProfileVersion  string representing the existing profileVersion attribute
///                 value
/// \param      -> oldApplicationCompatibility  string representing the existing
///                 applicationCompatibility value
/// \remarks
/// Called from the App's OnInit().
/// Starting with AI version 6.0.0, the application checks the profileVersion and applicationCompatibility
/// version numbers of any existing AI_UserProfiles.xml file in the Adapt It (Unicode) Work folder against
/// the corresponding numbers of the running application. The version number of the existing AI_UserProfiles.xml
/// are represented in the oldProfileVersion and oldApplicationCompatibility incoming parameters. The
/// running application's corresponding numbers are set as #define constants at the beginning of Adapt_It.h.
/// When an Adapt It user upgrades to a newer version of the application, the installer places the latest version
/// of AI_UserProfiles.xml in the setup folder, but the installer does not copy it at install time to the
/// Adapt It (Unicode) Work folder. Each time the Adapt It application runs, however, this function compares
/// the version numbers of the running application with those of the existing AI_UserProfiles.xml file in the Adapt It
/// (Unicode) Work folder. The running application determines whether the newer version should be copied to
/// overwrite the older existing version, or be merged with the older existing version. This function returns
/// an enum VersionComparison which informs the caller whether comparison of version numbers is: sameAppVersion,
/// runningAppVersionIsNewer, runningAppVersionIsOlder (all comparing the 6.x.x version numbers), or
/// profileVersionDiffers in the case that the profileVersion 1.x version differs (regardless of the 6.x.x
/// versions are).
/////////////////////////////////////////////////////////////////////////////////////////
enum VersionComparison CAdapt_ItApp::CompareRunningVersionWithWorkFolderVersion(wxString oldProfileVersion, wxString oldApplicationCompatibility)
{
    // parse the oldApplicationCompatibility string into int parts
    int nWorkFolderProfileMajV, nWorkFolderProfileMinV;
    int nRunningAppProfileMajV, nRunningAppProfileMinV;
    // get the part of the profileVersion number of the running application
    nRunningAppProfileMajV = PROFILE_VERSION_MAJOR_PART;
    nRunningAppProfileMinV = PROFILE_VERSION_MINOR_PART;
    // parse out the parts of the profileVersioin number of the AI_UserProfiles.xml of
    // the work folder from the incoming oldProfileVersion parameter
    wxString tempStr, intStr;
    tempStr = oldProfileVersion;
    tempStr.Trim(FALSE);
    tempStr.Trim(TRUE);
    intStr = tempStr.Mid(0, tempStr.Find(_T('.')));
    nWorkFolderProfileMajV = wxAtoi(intStr);
    tempStr = tempStr.Mid(tempStr.Find(_T('.')) + 1);
    intStr = tempStr.Mid(0, tempStr.Find(_T('.')));
    nWorkFolderProfileMinV = wxAtoi(intStr);
    // Is the running app's profileVersion the same as the work folder's profileVersion?
    // If so, no problem - continue checking the applicationCompatibility version numbers.
    // If the app's profileVersion differs from the work folder's profileVersion we return
    // profileVersionDiffers to the caller.
    if (nRunningAppProfileMajV == nWorkFolderProfileMajV && nRunningAppProfileMinV == nWorkFolderProfileMinV)
    {
        // nothing special need be done, continue checking the applicationCompatibility version
        ;
    }
    else if (nRunningAppProfileMajV != nWorkFolderProfileMajV || nRunningAppProfileMinV != nWorkFolderProfileMinV)
    {
        return profileVersionDiffers;
    }

    int nWorkFolderAppCompatMajV, nWorkFolderAppCompatMinV, nWorkFolderAppCompatBuiV;
    int nRunningAppCompatMajV, nRunningAppCompatMinV, nRunningAppCompatBuiV;
    // get the parts of the version number of the running application
    nRunningAppCompatMajV = AI_VERSION_MAJOR;
    nRunningAppCompatMinV = AI_VERSION_MINOR;
    nRunningAppCompatBuiV = AI_VERSION_BUILD_PART;
    // parse out the parts of the version number of the AI_UserProfiles.xml of the work folder
    // from the incoming oldApplicationCompatibility parameter
    tempStr = oldApplicationCompatibility;
    tempStr.Trim(FALSE);
    tempStr.Trim(TRUE);
    intStr = tempStr.Mid(0, tempStr.Find(_T('.')));
    nWorkFolderAppCompatMajV = wxAtoi(intStr);
    tempStr = tempStr.Mid(tempStr.Find(_T('.')) + 1);
    intStr = tempStr.Mid(0, tempStr.Find(_T('.')));
    nWorkFolderAppCompatMinV = wxAtoi(intStr);
    tempStr = tempStr.Mid(tempStr.Find(_T('.')) + 1);
    intStr = tempStr.Mid(0, tempStr.Find(_T('.')));
    nWorkFolderAppCompatBuiV = wxAtoi(intStr);

    // Is the running app's version the same as the work folder's version?
    // If so, no merge is necessary (caller will simply copy and overwrite the
    // existing older AI_UserProfiles.xml in the work folder). Return FALSE.
    if (nRunningAppCompatMajV == nWorkFolderAppCompatMajV && nRunningAppCompatMinV == nWorkFolderAppCompatMinV && nRunningAppCompatBuiV == nWorkFolderAppCompatBuiV)
    {
        return sameAppVersion;
    }
    // If we get here the running version is either older or newer than the work folder version.
    //
    // Is the running app's version older than the work folder's version?
    // This might happen if the user installed and reverted to running an older
    // version in the 6.x.x series for some reason (after having installed a
    // newer version). In this case we can't really guarantee that the older
    // application will be able to successfully deal with a newer
    // AI_UserProfiles.xml file. So, we return FALSE to get the caller to
    // rename the work folder's copy of AI_UserProfiles.xml to
    // AI_UserProfiles_old.xml and copy the newer AI_UserProfiles.xml from
    // the setup folder to the work folder.
    if (nRunningAppCompatMajV < nWorkFolderAppCompatMajV)
    {
        return runningAppVersionIsOlder;
    }
    else if (nRunningAppCompatMinV < nWorkFolderAppCompatMinV)
    {
        return runningAppVersionIsOlder;
    }
    else if (nRunningAppCompatBuiV < nWorkFolderAppCompatBuiV)
    {
        return runningAppVersionIsOlder;
    }
    // If we get here the running version must be newer
    //
    // Is the running app's version newer than the work folder's version?
    // If so, we should merge the setup folder's newer AI_UserProfiles.xml with
    // the work folder's older AI_UserProfiles.xml file. Return TRUE.
    wxASSERT(nRunningAppCompatMajV > nWorkFolderAppCompatMajV || nRunningAppCompatMinV > nWorkFolderAppCompatMinV || nRunningAppCompatBuiV > nWorkFolderAppCompatBuiV);
    // the defaul bMerge value is TRUE;
    return runningAppVersionIsNewer;
}

/// \return     a wxString representing the running applications version number in 6.x.x format
/// \remarks
/// Called from the App's OnInit() and from ReportMenuAndUserProfilesInconsistencies().
/// Forms a wxString from the app's version constants that are #defined at the
/// beginning of Adapt_It.h. The constants are: AI_VERSION_MAJOR, AI_VERSION_MINOR,
/// and AI_VERSION_BUILD_PART.
/////////////////////////////////////////////////////////////////////////////////////////
wxString CAdapt_ItApp::GetAppVersionOfRunningAppAsString()
{
    wxString str;
    str.Empty();
    str << AI_VERSION_MAJOR;
    str += _T('.');
    str << AI_VERSION_MINOR;
    str += _T('.');
    str << AI_VERSION_BUILD_PART;
    return str;
}

wxString CAdapt_ItApp::GetVersionNumberAsString(int nVersionMajor, int nVersionMinor, int nVersionRevision, wxString separator)
{
    wxString str;
    str.Empty();
    str << nVersionMajor;
    str += separator;
    str << nVersionMinor;
    str += separator;
    str << nVersionRevision;
    return str;
}

/// \return     a wxString representing the running applications profile version in 1.x format
/// \remarks
/// Called from the App's OnInit() and from ReportMenuAndUserProfilesInconsistencies().
/// Forms a wxString from the app's profile version constants that are #defined at
/// the beginning of Adapt_It.h. The constants are: PROFILE_VERSION_MAJOR_PART
/// and PROFILE_VERSION_MINOR_PART.
/////////////////////////////////////////////////////////////////////////////////////////
wxString CAdapt_ItApp::GetProfileVersionOfRunningAppAsString()
{
    wxString str;
    str.Empty();
    str << PROFILE_VERSION_MAJOR_PART;
    str += _T('.');
    str << PROFILE_VERSION_MINOR_PART;
    return str;
}

/*
enum wxLanguage
{
// wxLanguage symbol		//	enum	Canonical Description in
//						val	Name	    Plain English
//					info->CanonicalName   info->Description
// user's default/preffered language as got from OS:
wxLANGUAGE_DEFAULT,			//	0	en_US
// unknown language, if wxLocale::GetSystemLanguage fails:
wxLANGUAGE_UNKNOWN,			//	1	null	null

wxLANGUAGE_ABKHAZIAN,		//	2	ab	Abkhazian
wxLANGUAGE_AFAR,			//	3	aa	Afar
wxLANGUAGE_AFRIKAANS,		//	4	af_ZA	Afrikaans
wxLANGUAGE_ALBANIAN,		//	5	sq_AL	Albanian
wxLANGUAGE_AMHARIC,			//	6	am	Amharic
wxLANGUAGE_ARABIC,			//	7	ar	Arabic
wxLANGUAGE_ARABIC_ALGERIA,	//	8	ar_DZ	Arabic (Algeria)
wxLANGUAGE_ARABIC_BAHRAIN,	//	9	ar_BH	Arabic (Bahrain)
wxLANGUAGE_ARABIC_EGYPT,		//	10	ar_EG Arabic (Egypt)
wxLANGUAGE_ARABIC_IRAQ,		//	11	ar_IQ	Arabic (Iraq)
wxLANGUAGE_ARABIC_JORDAN,		//	12	ar_JO	Arabic (Jordan)
wxLANGUAGE_ARABIC_KUWAIT,		//	13	ar_KW	Arabic (Kuwait)
wxLANGUAGE_ARABIC_LEBANON,	//	14	ar_LB Arabic (Lebanon)
wxLANGUAGE_ARABIC_LIBYA,		//	15	ar_LY	Arabic (Libya)
wxLANGUAGE_ARABIC_MOROCCO,	//	16	ar_MA	Arabic (Morocco)
wxLANGUAGE_ARABIC_OMAN,		//	17	ar_OM	Arabic (Oman)
wxLANGUAGE_ARABIC_QATAR,		//	18	ar_QA	Arabic (Qatar)
wxLANGUAGE_ARABIC_SAUDI_ARABIA,	//	19	ar_SA	Arabic (Saudi Arabia)
wxLANGUAGE_ARABIC_SUDAN,		//	20	ar_SD	Arabic (Sudan)
wxLANGUAGE_ARABIC_SYRIA,		//	21	ar_SY	Arabic (Syria)
wxLANGUAGE_ARABIC_TUNISIA,	//	22	ar_TN	Arabic (Tunisia)
wxLANGUAGE_ARABIC_UAE,		//	23	ar_AE	Arabic (Uae)
wxLANGUAGE_ARABIC_YEMEN,		//	24	ar_YE	Arabic (Yemen)
wxLANGUAGE_ARMENIAN,		//	25	hy	Armenian
wxLANGUAGE_ASSAMESE,		//	26	as	Assamese
wxLANGUAGE_AYMARA,			//	27	ay	Aymara
wxLANGUAGE_AZERI,			//	28	az	Azeri
wxLANGUAGE_AZERI_CYRILLIC,	//	29	az_Cyrl	Azeri (Cyrillic)
wxLANGUAGE_AZERI_LATIN,		//	30	az_Latn	Azeri (Latin)
wxLANGUAGE_BASHKIR,			//	31	ba	Bashkir
wxLANGUAGE_BASQUE,			//	32	eu_ES	Basque
wxLANGUAGE_BELARUSIAN,		//	33	be_BY	Belarusian
wxLANGUAGE_BENGALI,			//	34	bn	Bengali
wxLANGUAGE_BHUTANI,			//	35	dz	Bhutani // not in IANA
wxLANGUAGE_BIHARI,			//	36	bh	Bihari
wxLANGUAGE_BISLAMA,			//	37	bi	Bislama
wxLANGUAGE_BRETON,			//	38	br	Breton
wxLANGUAGE_BULGARIAN,		//	39	bg_BG	Bulgarian
wxLANGUAGE_BURMESE,			//	40	my	Burmese
wxLANGUAGE_CAMBODIAN,		//	41	km	Cambodian // not in IANA
wxLANGUAGE_CATALAN,			//	42	ca_ES	Catalan
wxLANGUAGE_CHINESE,			//	43	zh_TW	Chinese
wxLANGUAGE_CHINESE_SIMPLIFIED,	//	44	zh_CN	Chinese (Simplified)
wxLANGUAGE_CHINESE_TRADITIONAL,	//	45	zh_TW	Chinese (Traditional)
wxLANGUAGE_CHINESE_HONGKONG,	//	46	zh_HK	Chinese (Hongkong)
wxLANGUAGE_CHINESE_MACAU,		//	47	zh_MO	Chinese (Macau)
wxLANGUAGE_CHINESE_SINGAPORE,	//	48	zh_SG	Chinese (Singapore)
wxLANGUAGE_CHINESE_TAIWAN,	//	49	zh_TW	Chinese (Taiwan)
wxLANGUAGE_CORSICAN,		//	50	co	Corsican
wxLANGUAGE_CROATIAN,		//	51	hr_HR	Croatian
wxLANGUAGE_CZECH,			//	52	cs_CZ	Czech
wxLANGUAGE_DANISH,			//	53	da_DK	Danish
wxLANGUAGE_DUTCH,			//	54	nl_NL	Dutch
wxLANGUAGE_DUTCH_BELGIAN,		//	55	nl_BE	Dutch (Belgian)
wxLANGUAGE_ENGLISH,			//	56	en_GB	English
wxLANGUAGE_ENGLISH_UK,		//	57	en_GB	English (U.K.)
wxLANGUAGE_ENGLISH_US,		//	58	en_US	English (U.S.)
wxLANGUAGE_ENGLISH_AUSTRALIA,	//	59	en_AU	English (Australia)
wxLANGUAGE_ENGLISH_BELIZE,	//	60	en_BZ	English (Belize)
wxLANGUAGE_ENGLISH_BOTSWANA,	//	61	en_BW	English (Botswana)
wxLANGUAGE_ENGLISH_CANADA,	//	62	en_CA	English (Canada)
wxLANGUAGE_ENGLISH_CARIBBEAN,	//	63	en_CB	English (Caribbean)
wxLANGUAGE_ENGLISH_DENMARK,	//	64	en_DK	English (Denmark)
wxLANGUAGE_ENGLISH_EIRE,		//	65	en_IE	English (Eire)
wxLANGUAGE_ENGLISH_JAMAICA,	//	66	en_JM	English (Jamaica)
wxLANGUAGE_ENGLISH_NEW_ZEALAND,	//	67	en_NZ	English (New Zealand)
wxLANGUAGE_ENGLISH_PHILIPPINES,	//	68	en_PH	English (Philippines)
wxLANGUAGE_ENGLISH_SOUTH_AFRICA,	//	69	en_ZA	English (South Africa)
wxLANGUAGE_ENGLISH_TRINIDAD,	//	70	en_TT	English (Trinidad)
wxLANGUAGE_ENGLISH_ZIMBABWE,	//	71	en_ZW	English (Zimbabwe)
wxLANGUAGE_ESPERANTO,		//	72	eo	Esperanto
wxLANGUAGE_ESTONIAN,		//	73	et_EE	Estonian
wxLANGUAGE_FAEROESE,		//	74	fo_FO	Faeroese
wxLANGUAGE_FARSI,			//	75	fa_IR	Farsi
wxLANGUAGE_FIJI,			//	76	fj	Fiji
wxLANGUAGE_FINNISH,			//	77	fi_FI	Finnish
wxLANGUAGE_FRENCH,			//	78	fr_FR	French
wxLANGUAGE_FRENCH_BELGIAN,	//	79	fr_BE	French (Belgian)
wxLANGUAGE_FRENCH_CANADIAN,	//	80	fr_CA	French (Canadian)
wxLANGUAGE_FRENCH_LUXEMBOURG,	//	81	fr_LU	French (Luxembourg)
wxLANGUAGE_FRENCH_MONACO,		//	82	fr_MC	French (Monaco)
wxLANGUAGE_FRENCH_SWISS,		//	83	fr_CH	French (Swiss)
wxLANGUAGE_FRISIAN,			//	84	fy	Frisian
wxLANGUAGE_GALICIAN,		//	85	gl_ES	Galician
wxLANGUAGE_GEORGIAN,		//	86	ka	Georgian
wxLANGUAGE_GERMAN,			//	87	de_DE	German
wxLANGUAGE_GERMAN_AUSTRIAN,	//	88	de_AT	German (Austrian)
wxLANGUAGE_GERMAN_BELGIUM,	//	89	de_BE	German (Belgium)
wxLANGUAGE_GERMAN_LIECHTENSTEIN,	//	90	de_LI	German (Liechtenstein)
wxLANGUAGE_GERMAN_LUXEMBOURG,	//	91	de_LU	German (Luxembourg)
wxLANGUAGE_GERMAN_SWISS,		//	92	de_CH	German (Swiss)
wxLANGUAGE_GREEK,			//	93	el_GR	Greek
wxLANGUAGE_GREENLANDIC,		//	94	kl_GL	Greenlandic
wxLANGUAGE_GUARANI,			//	95	gn	Guarani
wxLANGUAGE_GUJARATI,		//	96	gu	Gujarati
wxLANGUAGE_HAUSA,			//	97	ha	Hausa
wxLANGUAGE_HEBREW,			//	98	he_IL	Hebrew
wxLANGUAGE_HINDI,			//	99	hi_IN	Hindi
wxLANGUAGE_HUNGARIAN,		//	100	hu_HU	Hungarian
wxLANGUAGE_ICELANDIC,		//	101	is_IS	Icelandic
wxLANGUAGE_INDONESIAN,		//	102	id_ID	Indonesian
wxLANGUAGE_INTERLINGUA,		//	103	ia	Interlingua
wxLANGUAGE_INTERLINGUE,		//	104	ie	Interlingue
wxLANGUAGE_INUKTITUT,		//	105	iu	Inuktitut
wxLANGUAGE_INUPIAK,			//	106	ik	Inupiak
wxLANGUAGE_IRISH,			//	107	ga_IE	Irish
wxLANGUAGE_ITALIAN,			//	108	it_IT	Italian
wxLANGUAGE_ITALIAN_SWISS,		//	109	it_CH	Italian (Swiss)
wxLANGUAGE_JAPANESE,		//	110	ja_JP	Japanese
wxLANGUAGE_JAVANESE,		//	111	jw	Javanese
wxLANGUAGE_KANNADA,			//	112	kn	kannada
wxLANGUAGE_KASHMIRI,		//	113	ks	Kashmiri
wxLANGUAGE_KASHMIRI_INDIA,	//	114	ks_IN	Kashmiri (India)
wxLANGUAGE_KAZAKH,			//	115	kk	Kazakh
wxLANGUAGE_KERNEWEK,		//	116	kw_GB	Kernewek
wxLANGUAGE_KINYARWANDA,		//	117	rw	Kinyarwanda
wxLANGUAGE_KIRGHIZ,			//	118	ky	Kirghiz
wxLANGUAGE_KIRUNDI,			//	119	rn	Kirundi
wxLANGUAGE_KONKANI,			//	120	kok	Konkani // canonical is null kok is IANA code
wxLANGUAGE_KOREAN,			//	121	ko_KR	Korean
wxLANGUAGE_KURDISH,			//	122	ku	Kurdish
wxLANGUAGE_LAOTHIAN,		//	123	lo	Laothian
wxLANGUAGE_LATIN,			//	124	la	Latin
wxLANGUAGE_LATVIAN,			//	125	lv_LV	Latvian
wxLANGUAGE_LINGALA,			//	126	ln	Lingala
wxLANGUAGE_LITHUANIAN,		//	127	lt_LT	Lithuanian
wxLANGUAGE_MACEDONIAN,		//	128	mk_MK	Macedonian
wxLANGUAGE_MALAGASY,		//	129	mg	Malagasy
wxLANGUAGE_MALAY,			//	130	ms_MY	Malay
wxLANGUAGE_MALAYALAM,		//	131	ml	Malayalam
wxLANGUAGE_MALAY_BRUNEI_DARUSSALAM,	//	132	ms_BN	Malay (Brunei Darussalam)
wxLANGUAGE_MALAY_MALAYSIA,	//	133	ms_MY	Malay (Malaysia)
wxLANGUAGE_MALTESE,			//	134	mt_MT	Maltese
wxLANGUAGE_MANIPURI,		//	135	mni	Manipuri // canonical is null mni is IANA code
wxLANGUAGE_MAORI,			//	136	mi	Maori
wxLANGUAGE_MARATHI,			//	137	mr_IN	Marathi
wxLANGUAGE_MOLDAVIAN,		//	138	mo	Moldavian
wxLANGUAGE_MONGOLIAN,		//	139	mn	Mongolian
wxLANGUAGE_NAURU,			//	140	na	Nauru
wxLANGUAGE_NEPALI,			//	141	ne	Nepali
wxLANGUAGE_NEPALI_INDIA,		//	142	ne_IN	Nepali (India)
wxLANGUAGE_NORWEGIAN_BOKMAL,	//	143	nb_NO	Norwegian (Bokmal)
wxLANGUAGE_NORWEGIAN_NYNORSK,	//	144	nn_NO	Norwegian (Nynorsk)
wxLANGUAGE_OCCITAN,			//	145	oc	Occitan
wxLANGUAGE_ORIYA,			//	146	or	Oriya
wxLANGUAGE_OROMO,			//	147	om	(Afan) Oromo
wxLANGUAGE_PASHTO,			//	148	ps	Pashto, Pushto
wxLANGUAGE_POLISH,			//	149	pl_PL	Polish
wxLANGUAGE_PORTUGUESE,		//	150	pt_PT	Portuguese
wxLANGUAGE_PORTUGUESE_BRAZILIAN,	//	151	pt_BR	Portuguese (Brazilian)
wxLANGUAGE_PUNJABI,			//	152	pa	Punjabi
wxLANGUAGE_QUECHUA,			//	153	qu	Quechua
wxLANGUAGE_RHAETO_ROMANCE,	//	154	rm	Rhaeto-Romance
wxLANGUAGE_ROMANIAN,		//	155	ro_RO	Romanian
wxLANGUAGE_RUSSIAN,			//	156	ru_RU	Russian
wxLANGUAGE_RUSSIAN_UKRAINE,	//	157	ru_UA	Russian (Ukraine)
wxLANGUAGE_SAMOAN,			//	158	sm	Samoan
wxLANGUAGE_SANGHO,			//	159	sg	Sangho
wxLANGUAGE_SANSKRIT,		//	160	sa	Sanskrit
wxLANGUAGE_SCOTS_GAELIC,		//	161	gd	Scots Gaelic
wxLANGUAGE_SERBIAN,			//	162	sr	Serbian // both null in wx; values from IANA
wxLANGUAGE_SERBIAN_CYRILLIC,	//	163	sr_YU	Serbian (Cyrillic)
wxLANGUAGE_SERBIAN_LATIN,		//	164	sr_YU	Serbian (Latin)
wxLANGUAGE_SERBO_CROATIAN,	//	165	sh	Serbo-Croatian
wxLANGUAGE_SESOTHO,			//	166	st	Sesotho
wxLANGUAGE_SETSWANA,		//	167	tn	Setswana
wxLANGUAGE_SHONA,			//	168	sn	Shona
wxLANGUAGE_SINDHI,			//	169	sd	Sindhi
wxLANGUAGE_SINHALESE,		//	170	si	Sinhalese
wxLANGUAGE_SISWATI,			//	171	ss	Siswati
wxLANGUAGE_SLOVAK,			//	172	sk_SK	Slovak
wxLANGUAGE_SLOVENIAN,		//	173	sl_SI	Slovenian
wxLANGUAGE_SOMALI,			//	174	so	Somali
wxLANGUAGE_SPANISH,			//	175	es_ES	Spanish
wxLANGUAGE_SPANISH_ARGENTINA,	//	176	es_AR	Spanish (Argentina)
wxLANGUAGE_SPANISH_BOLIVIA,	//	177	es_BO	Spanish (Bolivia)
wxLANGUAGE_SPANISH_CHILE,		//	178	es_CL	Spanish (Chile)
wxLANGUAGE_SPANISH_COLOMBIA,	//	179	es_CO	Spanish (Colombia)
wxLANGUAGE_SPANISH_COSTA_RICA,	//	180	es_CR	Spanish (Costa Rica)
wxLANGUAGE_SPANISH_DOMINICAN_REPUBLIC,	//	181	es_DO	Spanish (Dominican republic)
wxLANGUAGE_SPANISH_ECUADOR,	//	182	es_EC	Spanish (Ecuador)
wxLANGUAGE_SPANISH_EL_SALVADOR,	//	183	es_SV	Spanish (El Salvador)
wxLANGUAGE_SPANISH_GUATEMALA,	//	184	es_GT	Spanish (Guatemala)
wxLANGUAGE_SPANISH_HONDURAS,	//	185	es_HN	Spanish (Honduras)
wxLANGUAGE_SPANISH_MEXICAN,	//	186	es_MX	Spanish (Mexico)
wxLANGUAGE_SPANISH_MODERN,	//	187	es_ES	Spanish (Modern)
wxLANGUAGE_SPANISH_NICARAGUA,	//	188	es_NI	Spanish (Nicaragua)
wxLANGUAGE_SPANISH_PANAMA,	//	189	es_PA	Spanish (Panama)
wxLANGUAGE_SPANISH_PARAGUAY,	//	190	es_PY	Spanish (Paraguay)
wxLANGUAGE_SPANISH_PERU,		//	191	es_PE	Spanish (Peru)
wxLANGUAGE_SPANISH_PUERTO_RICO,	//	192	es_PR	Spanish (Puerto Rico)
wxLANGUAGE_SPANISH_URUGUAY,	//	193	es_UY	Spanish (Uruguay)
wxLANGUAGE_SPANISH_US,		//	194	es_US	Spanish (U.S.)
wxLANGUAGE_SPANISH_VENEZUELA,	//	195	es_VE	Spanish (Venezuela)
wxLANGUAGE_SUNDANESE,		//	196	su	Sundanese
wxLANGUAGE_SWAHILI,			//	197	sw_KE	Swahili
wxLANGUAGE_SWEDISH,			//	198	sv_SE	Swedish
wxLANGUAGE_SWEDISH_FINLAND,	//	199	sv_FI	Swedish (Finland)
wxLANGUAGE_TAGALOG,			//	200	tl_PH	Tagalog
wxLANGUAGE_TAJIK,			//	201	tg	Tajik
wxLANGUAGE_TAMIL,			//	202	ta	Tamil
wxLANGUAGE_TATAR,			//	203	tt	Tatar
wxLANGUAGE_TELUGU,			//	204	te	Telugu
wxLANGUAGE_THAI,			//	205	th_TH	Thai
wxLANGUAGE_TIBETAN,			//	206	bo	Tibetan
wxLANGUAGE_TIGRINYA,		//	207	ti	Tigrinya
wxLANGUAGE_TONGA,			//	208	to	Tonga
wxLANGUAGE_TSONGA,			//	209	ts	Tsonga
wxLANGUAGE_TURKISH,			//	210	tr_TR	Turkish
wxLANGUAGE_TURKMEN,			//	211	tk	Turkmen
wxLANGUAGE_TWI,				//	212	tw	Twi
wxLANGUAGE_UIGHUR,			//	213	ug	Uighur
wxLANGUAGE_UKRAINIAN,		//	214	uk_UA	Ukrainian
wxLANGUAGE_URDU,			//	215	ur	Urdu
wxLANGUAGE_URDU_INDIA,		//	216	ur_IN	Urdu (India)
wxLANGUAGE_URDU_PAKISTAN,	//	217	ur_PK	Urdu (Pakistan)
wxLANGUAGE_UZBEK,			//	218	uz	Uzbek
wxLANGUAGE_UZBEK_CYRILLIC,	//	219	uz	Uzbek (Cyrillic)
wxLANGUAGE_UZBEK_LATIN,		//	220	uz	Uzbek (Latin)
wxLANGUAGE_VIETNAMESE,		//	221	vi_VN	Vietnamese
wxLANGUAGE_VOLAPUK,			//	222	vo	Volapuk
wxLANGUAGE_WELSH,			//	223	cy	Welsh
wxLANGUAGE_WOLOF,			//	224	wo	Wolof
wxLANGUAGE_XHOSA,			//	225	xh	Xhosa
wxLANGUAGE_YIDDISH,			//	226	yi	Yiddish
wxLANGUAGE_YORUBA,			//	227	yo	Yoruba
wxLANGUAGE_ZHUANG,			//	228	za	Zhuang
wxLANGUAGE_ZULU,			//	229	zu	Zulu

// for custom, user-defined languages:
wxLANGUAGE_USER_DEFINED		//	230	null	null
};
*/

////////////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \remarks
/// Called from: The App's ChooseInterfaceLanguage(), and CLanguagesPage::InitDialog(). An
/// array consisting of triplets of full language names, the wxWidgets language enum
/// symbol wxLANGUAGE_USER_DEFINED, and the short canonical name (used for subdirectories).
/// Used to correlate full language names, enum symbols and canonical names.
/// Note: This language data is unique to Adapt It. Since - as of January 2017, Poedit no
/// longer stores the full language name as an X extension in the po/mo files, we need to
/// be able to associate our custom full language names and the appropirate ISO 639-3 3-letter
/// code for use within Adapt It.
/// whm added 28May2018 to provide long language names for custom ISO 639-3 codes not recognized
/// by the wxLocale system.
////////////////////////////////////////////////////////////////////////////////////////
LangInfo langsKnownToAI[] =
{
    { _T("Tok Pisin"), wxLANGUAGE_USER_DEFINED, _T("tpi") },
    { _T("Swahili"), wxLANGUAGE_USER_DEFINED, _T("swh") }
};

////////////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \remarks
/// Called from: The App's ChooseInterfaceLanguage(), and CLanguagesPage::InitDialog(). An
/// array consisting of triplets of full language names, the wxWidgets language enum
/// symbols, and the short canonical name (used for subdirectories). Used to correlate full
/// language names, enum symbols and canonical names. Note: This language data is taken
/// from the void wxLocale::InitLanguagesDB() function in the wxWidgets intl.cpp library
/// source file.
////////////////////////////////////////////////////////////////////////////////////////
LangInfo langsKnownToWX[] =
{
    { _T("(Use system default language) [%s]"), wxLANGUAGE_DEFAULT, _T("default") },	// 0

                                                                                        // Note: I've added a couple three-letter short canonical forms from the IANA language
                                                                                        // registry which may be found at:
                                                                                        // http://www.iana.org/assignments/language-subtag-registry

    { _T("Abkhazian"), wxLANGUAGE_ABKHAZIAN, _T("ab") },							// 2
    { _T("Afar"), wxLANGUAGE_AFAR, _T("aa") },										// 3
    { _T("Afrikaans"), wxLANGUAGE_AFRIKAANS, _T("af_ZA") },							// 4
    { _T("Albanian"), wxLANGUAGE_ALBANIAN, _T("sq_AL") },							// 5
    { _T("Amharic"), wxLANGUAGE_AMHARIC, _T("am") },								// 6
    { _T("Arabic"), wxLANGUAGE_ARABIC, _T("ar") },									// 7
    { _T("Arabic (Algeria)"), wxLANGUAGE_ARABIC_ALGERIA, _T("ar_DZ") },				// 8
    { _T("Arabic (Bahrain)"), wxLANGUAGE_ARABIC_BAHRAIN, _T("ar_BH") },				// 9
    { _T("Arabic (Egypt)"), wxLANGUAGE_ARABIC_EGYPT, _T("ar_EG") },					// 10
    { _T("Arabic (Iraq)"), wxLANGUAGE_ARABIC_IRAQ, _T("ar_IQ") },					// 11
    { _T("Arabic (Jordan)"), wxLANGUAGE_ARABIC_JORDAN, _T("ar_JO") },				// 12
    { _T("Arabic (Kuwait)"), wxLANGUAGE_ARABIC_KUWAIT, _T("ar_KW") },				// 13
    { _T("Arabic (Lebanon)"), wxLANGUAGE_ARABIC_LEBANON, _T("ar_LB") },				// 14
    { _T("Arabic (Libya)"), wxLANGUAGE_ARABIC_LIBYA, _T("ar_LY") },					// 15
    { _T("Arabic (Morocco)"), wxLANGUAGE_ARABIC_MOROCCO, _T("ar_MA") },				// 16
    { _T("Arabic (Oman)"), wxLANGUAGE_ARABIC_OMAN, _T("ar_OM") },					// 17
    { _T("Arabic (Qatar)"), wxLANGUAGE_ARABIC_QATAR, _T("ar_QA") },					// 18
    { _T("Arabic (Saudi Arabia)"), wxLANGUAGE_ARABIC_SAUDI_ARABIA, _T("ar_SA") },	// 19
    { _T("Arabic (Sudan)"), wxLANGUAGE_ARABIC_SUDAN, _T("ar_SD") },					// 20
    { _T("Arabic (Syria)"), wxLANGUAGE_ARABIC_SYRIA, _T("ar_SY") },					// 21
    { _T("Arabic (Tunisia)"), wxLANGUAGE_ARABIC_TUNISIA, _T("ar_TN") },				// 22
    { _T("Arabic (Uae)"), wxLANGUAGE_ARABIC_UAE, _T("ar_AE") },						// 23
    { _T("Arabic (Yemen)"), wxLANGUAGE_ARABIC_YEMEN, _T("ar_YE") },					// 24
    { _T("Armenian"), wxLANGUAGE_ARMENIAN, _T("hy") },								// 25
    { _T("Assamese"), wxLANGUAGE_ASSAMESE, _T("as") },								// 26
    { _T("Aymara"), wxLANGUAGE_AYMARA, _T("ay") },									// 27
    { _T("Azeri"), wxLANGUAGE_AZERI, _T("az") },									// 28
    { _T("Azeri (Cyrillic)"), wxLANGUAGE_AZERI_CYRILLIC, _T("az_Cyrl") },			// 29
    { _T("Azeri (Latin)"), wxLANGUAGE_AZERI_LATIN, _T("az_Latn") },					// 30
    { _T("Bashkir"), wxLANGUAGE_BASHKIR, _T("ba") },								// 31
    { _T("Basque"), wxLANGUAGE_BASQUE, _T("eu_ES") },								// 32
    { _T("Belarusian"), wxLANGUAGE_BELARUSIAN, _T("be_BY") },						// 33
    { _T("Bengali"), wxLANGUAGE_BENGALI, _T("bn") },								// 34
    { _T("Bhutani"), wxLANGUAGE_BHUTANI, _T("dz") },								// 35 // in IANA registry under "Dzongkha" (uses Tibt script)
    { _T("Bihari"), wxLANGUAGE_BIHARI, _T("bh") },									// 36
    { _T("Bislama"), wxLANGUAGE_BISLAMA, _T("bi") },								// 37
    { _T("Breton"), wxLANGUAGE_BRETON, _T("br") },									// 38
    { _T("Bulgarian"), wxLANGUAGE_BULGARIAN, _T("bg_BG") },							// 39
    { _T("Burmese"), wxLANGUAGE_BURMESE, _T("my") },								// 40
    { _T("Cambodian"), wxLANGUAGE_CAMBODIAN, _T("km") },							// 41 // in IANA registry under "Central Khmer" (uses Khmr script)
    { _T("Catalan"), wxLANGUAGE_CATALAN, _T("ca_ES") },								// 42
    { _T("Chinese"), wxLANGUAGE_CHINESE, _T("zh_TW") },								// 43
    { _T("Chinese (Simplified)"), wxLANGUAGE_CHINESE_SIMPLIFIED, _T("zh_CN") },		// 44
    { _T("Chinese (Traditional)"), wxLANGUAGE_CHINESE_TRADITIONAL, _T("zh_TW") },	// 45
    { _T("Chinese (Hongkong)"), wxLANGUAGE_CHINESE_HONGKONG, _T("zh_HK") },			// 46
    { _T("Chinese (Macau)"), wxLANGUAGE_CHINESE_MACAU, _T("zh_MO") },				// 47
    { _T("Chinese (Singapore)"), wxLANGUAGE_CHINESE_SINGAPORE, _T("zh_SG") },		// 48
    { _T("Chinese (Taiwan)"), wxLANGUAGE_CHINESE_TAIWAN, _T("zh_TW") },				// 49
    { _T("Corsican"), wxLANGUAGE_CORSICAN, _T("co") },								// 50
    { _T("Croatian"), wxLANGUAGE_CROATIAN, _T("hr_HR") },							// 51
    { _T("Czech"), wxLANGUAGE_CZECH, _T("cs_CZ") },									// 52
    { _T("Danish"), wxLANGUAGE_DANISH, _T("da_DK") },								// 53
    { _T("Dutch"), wxLANGUAGE_DUTCH, _T("nl_NL") },									// 54
    { _T("Dutch (Belgian)"), wxLANGUAGE_DUTCH_BELGIAN, _T("nl_BE") },				// 55
    { _T("English"), wxLANGUAGE_ENGLISH, _T("en_GB") },								// 56
    { _T("English (U.K.)"), wxLANGUAGE_ENGLISH_UK, _T("en_GB") },					// 57
    { _T("English (U.S.)"), wxLANGUAGE_ENGLISH_US, _T("en_US") },					// 58
    { _T("English (Australia)"), wxLANGUAGE_ENGLISH_AUSTRALIA, _T("en_AU") },		// 59
    { _T("English (Belize)"), wxLANGUAGE_ENGLISH_BELIZE, _T("en_BZ") },				// 60
    { _T("English (Botswana)"), wxLANGUAGE_ENGLISH_BOTSWANA, _T("en_BW") },			// 61
    { _T("English (Canada)"), wxLANGUAGE_ENGLISH_CANADA, _T("en_CA") },				// 62
    { _T("English (Caribbean)"), wxLANGUAGE_ENGLISH_CARIBBEAN, _T("en_CB") },		// 63
    { _T("English (Denmark)"), wxLANGUAGE_ENGLISH_DENMARK, _T("en_DK") },			// 64
    { _T("English (Eire)"), wxLANGUAGE_ENGLISH_EIRE, _T("en_IE") },					// 65
    { _T("English (Jamaica)"), wxLANGUAGE_ENGLISH_JAMAICA, _T("en_JM") },			// 66
    { _T("English (New Zealand)"), wxLANGUAGE_ENGLISH_NEW_ZEALAND, _T("en_NZ") },	// 67
    { _T("English (Philippines)"), wxLANGUAGE_ENGLISH_PHILIPPINES, _T("en_PH") },	// 68
    { _T("English (South Africa)"), wxLANGUAGE_ENGLISH_SOUTH_AFRICA, _T("en_ZA") },	// 69
    { _T("English (Trinidad)"), wxLANGUAGE_ENGLISH_TRINIDAD, _T("en_TT") },			// 70
    { _T("English (Zimbabwe)"), wxLANGUAGE_ENGLISH_ZIMBABWE, _T("en_ZW") },			// 71
    { _T("Esperanto"), wxLANGUAGE_ESPERANTO, _T("eo") },							// 72
    { _T("Estonian"), wxLANGUAGE_ESTONIAN, _T("et_EE") },							// 73
    { _T("Faeroese"), wxLANGUAGE_FAEROESE, _T("fo_FO") },							// 74
    { _T("Farsi"), wxLANGUAGE_FARSI, _T("fa_IR") },									// 75
    { _T("Fiji"), wxLANGUAGE_FIJI, _T("fj") },										// 76
    { _T("Finnish"), wxLANGUAGE_FINNISH, _T("fi_FI") },								// 77
    { _T("French"), wxLANGUAGE_FRENCH, _T("fr_FR") },								// 78
    { _T("French (Belgian)"), wxLANGUAGE_FRENCH_BELGIAN, _T("fr_BE") },				// 79
    { _T("French (Canadian)"), wxLANGUAGE_FRENCH_CANADIAN, _T("fr_CA") },			// 80
    { _T("French (Luxembourg)"), wxLANGUAGE_FRENCH_LUXEMBOURG, _T("fr_LU") },		// 81
    { _T("French (Monaco)"), wxLANGUAGE_FRENCH_MONACO, _T("fr_MC") },				// 82
    { _T("French (Swiss)"), wxLANGUAGE_FRENCH_SWISS, _T("fr_CH") },					// 83
    { _T("Frisian"), wxLANGUAGE_FRISIAN, _T("fy") },								// 84
    { _T("Galician"), wxLANGUAGE_GALICIAN, _T("gl_ES") },							// 85
    { _T("Georgian"), wxLANGUAGE_GEORGIAN, _T("ka") },								// 86
    { _T("German"), wxLANGUAGE_GERMAN, _T("de_DE") },								// 87
    { _T("German (Austrian)"), wxLANGUAGE_GERMAN_AUSTRIAN, _T("de_AT") },			// 88
    { _T("German (Belgium)"), wxLANGUAGE_GERMAN_BELGIUM, _T("de_BE") },				// 89
    { _T("German (Liechtenstein)"), wxLANGUAGE_GERMAN_LIECHTENSTEIN, _T("de_LI") },	// 90
    { _T("German (Luxembourg)"), wxLANGUAGE_GERMAN_LUXEMBOURG, _T("de_LU") },		// 91
    { _T("German (Swiss)"), wxLANGUAGE_GERMAN_SWISS, _T("de_CH") },					// 92
    { _T("Greek"), wxLANGUAGE_GREEK, _T("el_GR") },									// 93
    { _T("Greenlandic"), wxLANGUAGE_GREENLANDIC, _T("kl_GL") },						// 94
    { _T("Guarani"), wxLANGUAGE_GUARANI, _T("gn") },								// 95
    { _T("Gujarati"), wxLANGUAGE_GUJARATI, _T("gu") },								// 96
    { _T("Hausa"), wxLANGUAGE_HAUSA, _T("ha") },									// 97
    { _T("Hebrew"), wxLANGUAGE_HEBREW, _T("he_IL") },								// 98
    { _T("Hindi"), wxLANGUAGE_HINDI, _T("hi_IN") },									// 99
    { _T("Hungarian"), wxLANGUAGE_HUNGARIAN, _T("hu_HU") },							// 100
    { _T("Icelandic"), wxLANGUAGE_ICELANDIC, _T("is_IS") },							// 101
    { _T("Indonesian"), wxLANGUAGE_INDONESIAN, _T("id_ID") },						// 102
    { _T("Interlingua"), wxLANGUAGE_INTERLINGUA, _T("ia") },						// 103
    { _T("Interlingue"), wxLANGUAGE_INTERLINGUE, _T("ie") },						// 104
    { _T("Inuktitut"), wxLANGUAGE_INUKTITUT, _T("iu") },							// 105
    { _T("Inupiak"), wxLANGUAGE_INUPIAK, _T("ik") },								// 106
    { _T("Irish"), wxLANGUAGE_IRISH, _T("ga_IE") },									// 107
    { _T("Italian"), wxLANGUAGE_ITALIAN, _T("it_IT") },								// 108
    { _T("Italian (Swiss)"), wxLANGUAGE_ITALIAN_SWISS, _T("it_CH") },				// 109
    { _T("Japanese"), wxLANGUAGE_JAPANESE, _T("ja_JP") },							// 110
    { _T("Javanese"), wxLANGUAGE_JAVANESE, _T("jw") },								// 111
    { _T("kannada"), wxLANGUAGE_KANNADA, _T("kn") },								// 112
    { _T("Kashmiri"), wxLANGUAGE_KASHMIRI, _T("ks") },								// 113
    { _T("Kashmiri (India)"), wxLANGUAGE_KASHMIRI_INDIA, _T("ks_IN") },				// 114
    { _T("Kazakh"), wxLANGUAGE_KAZAKH, _T("kk") },									// 115
    { _T("Kernewek"), wxLANGUAGE_KERNEWEK, _T("kw_GB") },							// 116
    { _T("Kinyarwanda"), wxLANGUAGE_KINYARWANDA, _T("rw") },						// 117
    { _T("Kirghiz"), wxLANGUAGE_KIRGHIZ, _T("ky") },								// 118
    { _T("Kirundi"), wxLANGUAGE_KIRUNDI, _T("rn") },								// 119
    { _T("Konkani"), wxLANGUAGE_KONKANI, _T("kok") },								// 120 // wx's canonicalName is null; IANA registry uses 3-letter code kok
    { _T("Korean"), wxLANGUAGE_KOREAN, _T("ko_KR") },								// 121
    { _T("Kurdish"), wxLANGUAGE_KURDISH, _T("ku") },								// 122
    { _T("Kyrgyz"), wxLANGUAGE_KIRGHIZ, _T("ky") },									// 118 // same as Kirghiz (wxLANGUAGE_KIRGHIZ)
    { _T("Laothian"), wxLANGUAGE_LAOTHIAN, _T("lo") },								// 123
    { _T("Latin"), wxLANGUAGE_LATIN, _T("la") },									// 124
    { _T("Latvian"), wxLANGUAGE_LATVIAN, _T("lv_LV") },								// 125
    { _T("Lingala"), wxLANGUAGE_LINGALA, _T("ln") },								// 126
    { _T("Lithuanian"), wxLANGUAGE_LITHUANIAN, _T("lt_LT") },						// 127
    { _T("Macedonian"), wxLANGUAGE_MACEDONIAN, _T("mk_MK") },						// 128
    { _T("Malagasy"), wxLANGUAGE_MALAGASY, _T("mg") },								// 129
    { _T("Malay"), wxLANGUAGE_MALAY, _T("ms_MY") },									// 130
    { _T("Malayalam"), wxLANGUAGE_MALAYALAM, _T("ml") },							// 131
    { _T("Malay (Brunei Darussalam)"), wxLANGUAGE_MALAY_BRUNEI_DARUSSALAM, _T("ms_BN") },	// 132
    { _T("Malay (Malaysia)"), wxLANGUAGE_MALAY_MALAYSIA, _T("ms_MY") },				// 133
    { _T("Maltese"), wxLANGUAGE_MALTESE, _T("mt_MT") },								// 134
    { _T("Manipuri"), wxLANGUAGE_MANIPURI, _T("mni") },								// 135 // wx's canonicalName is null; IANA registry uses 3-letter code mni
    { _T("Maori"), wxLANGUAGE_MAORI, _T("mi") },									// 136
    { _T("Marathi"), wxLANGUAGE_MARATHI, _T("mr_IN") },								// 137
    { _T("Moldavian"), wxLANGUAGE_MOLDAVIAN, _T("mo") },							// 138
    { _T("Mongolian"), wxLANGUAGE_MONGOLIAN, _T("mn") },							// 139
    { _T("Nauru"), wxLANGUAGE_NAURU, _T("na") },									// 140
    { _T("Nepali"), wxLANGUAGE_NEPALI, _T("ne") },									// 141
    { _T("Nepali (India)"), wxLANGUAGE_NEPALI_INDIA, _T("ne_IN") },					// 142
    { _T("Norwegian Bokmal"), wxLANGUAGE_NORWEGIAN_BOKMAL, _T("nb_NO") },			// 143
    { _T("Norwegian Nynorsk"), wxLANGUAGE_NORWEGIAN_NYNORSK, _T("nn_NO") },			// 144
    { _T("Occitan"), wxLANGUAGE_OCCITAN, _T("oc") },								// 145
    { _T("Oriya"), wxLANGUAGE_ORIYA, _T("or") },									// 146
    { _T("(Afan) Oromo"), wxLANGUAGE_OROMO, _T("om") },								// 147
    { _T("Pashto, Pushto"), wxLANGUAGE_PASHTO, _T("ps") },							// 148
    { _T("Polish"), wxLANGUAGE_POLISH, _T("pl_PL") },								// 149
    { _T("Portuguese"), wxLANGUAGE_PORTUGUESE, _T("pt_PT") },						// 150
    { _T("Portuguese (Brazilian)"), wxLANGUAGE_PORTUGUESE_BRAZILIAN, _T("pt_BR") },	// 151
    { _T("Punjabi"), wxLANGUAGE_PUNJABI, _T("pa") },								// 152
    { _T("Quechua"), wxLANGUAGE_QUECHUA, _T("qu") },								// 153
    { _T("Rhaeto-Romance"), wxLANGUAGE_RHAETO_ROMANCE, _T("rm") },					// 154
    { _T("Romanian"), wxLANGUAGE_ROMANIAN, _T("ro_RO") },							// 155
    { _T("Russian"), wxLANGUAGE_RUSSIAN, _T("ru_RU") },								// 156
    { _T("Russian (Ukraine)"), wxLANGUAGE_RUSSIAN_UKRAINE, _T("ru_UA") },			// 157
    { _T("Samoan"), wxLANGUAGE_SAMOAN, _T("sm") },									// 158
    { _T("Sangho"), wxLANGUAGE_SANGHO, _T("sg") },									// 159
    { _T("Sanskrit"), wxLANGUAGE_SANSKRIT, _T("sa") },								// 160
    { _T("Scots Gaelic"), wxLANGUAGE_SCOTS_GAELIC, _T("gd") },						// 161
    { _T("Serbian"), wxLANGUAGE_SERBIAN, _T("sr") },								// 162 // wxLANGUATE_SERVIAN not in InitLanguagesDB() returns null; IANA registry has code sr
    { _T("Serbian (Cyrillic)"), wxLANGUAGE_SERBIAN_CYRILLIC, _T("sr_YU") },			// 163
    { _T("Serbian (Latin)"), wxLANGUAGE_SERBIAN_LATIN, _T("sr_YU") },				// 164
    { _T("Serbo-Croatian"), wxLANGUAGE_SERBO_CROATIAN, _T("sh") },					// 165
    { _T("Sesotho"), wxLANGUAGE_SESOTHO, _T("st") },								// 166
    { _T("Setswana"), wxLANGUAGE_SETSWANA, _T("tn") },								// 167
    { _T("Shona"), wxLANGUAGE_SHONA, _T("sn") },									// 168
    { _T("Sindhi"), wxLANGUAGE_SINDHI, _T("sd") },									// 169
    { _T("Sinhalese"), wxLANGUAGE_SINHALESE, _T("si") },							// 170
    { _T("Siswati"), wxLANGUAGE_SISWATI, _T("ss") },								// 171
    { _T("Slovak"), wxLANGUAGE_SLOVAK, _T("sk_SK") },								// 172
    { _T("Slovenian"), wxLANGUAGE_SLOVENIAN, _T("sl_SI") },							// 173
    { _T("Somali"), wxLANGUAGE_SOMALI, _T("so") },									// 174
    { _T("Spanish"), wxLANGUAGE_SPANISH, _T("es_ES") },								// 175
    { _T("Spanish (Argentina)"), wxLANGUAGE_SPANISH_ARGENTINA, _T("es_AR") },		// 176
    { _T("Spanish (Bolivia)"), wxLANGUAGE_SPANISH_BOLIVIA, _T("es_BO") },			// 177
    { _T("Spanish (Chile)"), wxLANGUAGE_SPANISH_CHILE, _T("es_CL") },				// 178
    { _T("Spanish (Colombia)"), wxLANGUAGE_SPANISH_COLOMBIA, _T("es_CO") },			// 179
    { _T("Spanish (Costa Rica)"), wxLANGUAGE_SPANISH_COSTA_RICA, _T("es_CR") },		// 180
    { _T("Spanish (Dominican republic)"), wxLANGUAGE_SPANISH_DOMINICAN_REPUBLIC, _T("es_DO") },	// 181
    { _T("Spanish (Ecuador)"), wxLANGUAGE_SPANISH_ECUADOR, _T("es_EC") },			// 182
    { _T("Spanish (El Salvador)"), wxLANGUAGE_SPANISH_EL_SALVADOR, _T("es_SV") },	// 183
    { _T("Spanish (Guatemala)"), wxLANGUAGE_SPANISH_GUATEMALA, _T("es_GT") },		// 184
    { _T("Spanish (Honduras)"), wxLANGUAGE_SPANISH_HONDURAS, _T("es_HN") },			// 185
    { _T("Spanish (Mexico)"), wxLANGUAGE_SPANISH_MEXICAN, _T("es_MX") },			// 186
    { _T("Spanish (Modern)"), wxLANGUAGE_SPANISH_MODERN, _T("es_ES") },				// 187
    { _T("Spanish (Nicaragua)"), wxLANGUAGE_SPANISH_NICARAGUA, _T("es_NI") },		// 188
    { _T("Spanish (Panama)"), wxLANGUAGE_SPANISH_PANAMA, _T("es_PA") },				// 189
    { _T("Spanish (Paraguay)"), wxLANGUAGE_SPANISH_PARAGUAY, _T("es_PY") },			// 190
    { _T("Spanish (Peru)"), wxLANGUAGE_SPANISH_PERU, _T("es_PE") },					// 191
    { _T("Spanish (Puerto Rico)"), wxLANGUAGE_SPANISH_PUERTO_RICO, _T("es_PR") },	// 192
    { _T("Spanish (Uruguay)"), wxLANGUAGE_SPANISH_URUGUAY, _T("es_UY") },			// 193
    { _T("Spanish (U.S.)"), wxLANGUAGE_SPANISH_US, _T("es_US") },					// 194
    { _T("Spanish (Venezuela)"), wxLANGUAGE_SPANISH_VENEZUELA, _T("es_VE") },		// 195
    { _T("Sundanese"), wxLANGUAGE_SUNDANESE, _T("su") },							// 196
    { _T("Swahili"), wxLANGUAGE_SWAHILI, _T("sw_KE") },								// 197
    { _T("Swedish"), wxLANGUAGE_SWEDISH, _T("sv_SE") },								// 198
    { _T("Swedish (Finland)"), wxLANGUAGE_SWEDISH_FINLAND, _T("sv_FI") },			// 199
    { _T("Tagalog"), wxLANGUAGE_TAGALOG, _T("tl_PH") },								// 200
    { _T("Tajik"), wxLANGUAGE_TAJIK, _T("tg") },									// 201
    { _T("Tamil"), wxLANGUAGE_TAMIL, _T("ta") },									// 202
    { _T("Tatar"), wxLANGUAGE_TATAR, _T("tt") },									// 203
    { _T("Telugu"), wxLANGUAGE_TELUGU, _T("te") },									// 204
    { _T("Thai"), wxLANGUAGE_THAI, _T("th_TH") },									// 205
    { _T("Tibetan"), wxLANGUAGE_TIBETAN, _T("bo") },								// 206
    { _T("Tigrinya"), wxLANGUAGE_TIGRINYA, _T("ti") },								// 207
    { _T("Tonga"), wxLANGUAGE_TONGA, _T("to") },									// 208
    { _T("Tsonga"), wxLANGUAGE_TSONGA, _T("ts") },									// 209
    { _T("Turkish"), wxLANGUAGE_TURKISH, _T("tr_TR") },								// 210
    { _T("Turkmen"), wxLANGUAGE_TURKMEN, _T("tk") },								// 211
    { _T("Twi"), wxLANGUAGE_TWI, _T("tw") },										// 212
    { _T("Uighur"), wxLANGUAGE_UIGHUR, _T("ug") },									// 213
    { _T("Ukrainian"), wxLANGUAGE_UKRAINIAN, _T("uk_UA") },							// 214
    { _T("Urdu"), wxLANGUAGE_URDU, _T("ur") },										// 215
    { _T("Urdu (India)"), wxLANGUAGE_URDU_INDIA, _T("ur_IN") },						// 216
    { _T("Urdu (Pakistan)"), wxLANGUAGE_URDU_PAKISTAN, _T("ur_PK") },				// 217
    { _T("Uzbek"), wxLANGUAGE_UZBEK, _T("uz") },									// 218
    { _T("Uzbek (Cyrillic)"), wxLANGUAGE_UZBEK_CYRILLIC, _T("uz") },				// 219 // no script indicated; canonicalName could be uz__Cyrl [see Azeri above]
    { _T("Uzbek (Latin)"), wxLANGUAGE_UZBEK_LATIN, _T("uz") },						// 220 // no script indicated; canonicalName could be uz_Latn [see Azeri above]
    { _T("Vietnamese"), wxLANGUAGE_VIETNAMESE, _T("vi_VN") },						// 221
    { _T("Volapuk"), wxLANGUAGE_VOLAPUK, _T("vo") },								// 222
    { _T("Welsh"), wxLANGUAGE_WELSH, _T("cy") },									// 223
    { _T("Wolof"), wxLANGUAGE_WOLOF, _T("wo") },									// 224
    { _T("Xhosa"), wxLANGUAGE_XHOSA, _T("xh") },									// 225
    { _T("Yiddish"), wxLANGUAGE_YIDDISH, _T("yi") },								// 226
    { _T("Yoruba"), wxLANGUAGE_YORUBA, _T("yo") },									// 227
    { _T("Zhuang"), wxLANGUAGE_ZHUANG, _T("za") },									// 228
    { _T("Zulu"), wxLANGUAGE_ZULU, _T("zu") },										// 229
                                                                                    // wxLANGUAGE_UNKNOWN needs to be here at the end of the array so we can search the array
                                                                                    // using a while loop while langsKnownToWX[ct].name != NULL.
    { NULL, wxLANGUAGE_UNKNOWN, NULL }												// 1
};

// beginning of AIModalDialog class implementation !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// whm Note: The AIModalDialog class exists as a base dialog class for Adapt It modal
// dialogs. AIModalDialog functions practically identical to its own base class wxDialog.
// It simply overrides ShowModal and the class destructor in order to suspend wxIdleEvent
// processing while the dialog is being displayed/modal, and restores idle processing when
// the dialog is destroyed. Suspending idle events helps to prevent crashes due to
// time-triggered events such as autosave that, if performed, encounter bad pointers

/////////////////////////////////////////////////////////////////////////////////////
/// \remarks
/// Constructor for the AIModalDialog class.
/// Used as a base class for all Adapt It dialogs which are invoked as modal dialogs.
/////////////////////////////////////////////////////////////////////////////////////
AIModalDialog::AIModalDialog(wxWindow *parent, const wxWindowID id, const wxString& title,
    const wxPoint& pos, const wxSize& size, const long windowStyle) :
    // whm 14Jun12 modified to use wxDialog for wxWidgets 2.9.x and later; wxScrollingDialog for pre-2.9.x
#if wxCHECK_VERSION(2,9,0)
    wxDialog(parent, id, title, pos, size, windowStyle)
#else
    wxScrollingDialog(parent, id, title, pos, size, windowStyle)
#endif
{
}

////////////////////////////////////////////////////////////////////////////////////////
/// \remarks
/// Destructor for the AIModalDialog class.
/// Used as the base class destructor all Adapt It dialogs which are invoked as modal
/// dialogs. This destructor calls the wxIdleEvent::SetMode(wxIDLE_PROCESS_ALL), and the
/// wxUpdateUIEvent::SetMode(wxUPDATE_UI_PROCESS_ALL), which allows the application to
/// resume its normal idle processing once the AIModalDialog based dialog closes.
/////////////////////////////////////////////////////////////////////////////////////////
AIModalDialog::~AIModalDialog()
{
    // override of wxDialog's destructor to start up idle processing again
    wxIdleEvent::SetMode(wxIDLE_PROCESS_ALL);
    wxUpdateUIEvent::SetMode(wxUPDATE_UI_PROCESS_ALL);
}

////////////////////////////////////////////////////////////////////////////////////////
/// \remarks
/// Override of the wxDialog's/wxScrollingDialog's ShowModal() method.
/// This override effectively turns off the wxIdleEvent and wxUpdateUIEvent idle processing
/// while any AIModalDialog based dialog is being shown in modal fashion.
////////////////////////////////////////////////////////////////////////////////////////
int AIModalDialog::ShowModal()
{
    // whm 17May2020 added - set the App's m_bUserDlgOrMessageRequested flag to TRUE for all
    // modal dialogs based on AIModalDialog
    CAdapt_ItApp* pApp = &wxGetApp();
    wxLogDebug(_T("AIModalDialog::ShowModal() setting m_bUserDlgOrMessageRequested to TRUE"));
    pApp->m_bUserDlgOrMessageRequested = TRUE;

    // override of wxDialog's ShowModal() method to stop all idle processing including
    // processing of UI events while the modal dialog is displaying.
    wxIdleEvent::SetMode(wxIDLE_PROCESS_SPECIFIED);
    wxUpdateUIEvent::SetMode(wxUPDATE_UI_PROCESS_SPECIFIED);
    // whm 14Jun12 modified to use wxDialog for wxWidgets 2.9.x and later; wxScrollingDialog for pre-2.9.x
#if wxCHECK_VERSION(2,9,0)
    return wxDialog::ShowModal();
#else
    return wxScrollingDialog::ShowModal();
#endif
}
// end of AIModalDialog class !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

// begin AutoCorrectTextCtrl class definition !!!!!!!!!!!!!!!!!!!!!!!!
// Note: This class could be declared and defined in separate source
// and header files, but it is so small that I'll do it here in the App.
// 
// whm 31Aug2021 added a simple class named AutoCorrectTextCtrl
// that derives directly from the wxWidgets wxTextCtrl.
// This is a class that will allow us to access the text control's
// OnChar() method (like CPhraseBox does), in order to implement an
// AutoCorrect feature for text controls in used in AI's dialogs that
// accept target language text where auto-correct can be of assistance.
// This class is used as a custom class within wxDesigner for certain
// dialogs that have edit boxes expecting target text entry. Pointers
// to those target text edit boxes are correspondingly created within
// these dialog's cpp source files. Those source file are:
// Authenticate2Dlg.cpp ID_TEXTCTRL_USER2, ID_TEXTCTRL_USERNAME_STATELESS
// BookNameDlg.cpp ID_TEXTCTRL_BOOKNAME
// CaseEquivPage.cpp IDC_EDIT_TGT_CASE_EQUIVALENCES
// CCTableEditDlg.cpp IDC_EDIT_CCT
// ChooseTranslation.cpp IDC_EDIT_NEW_TRANSLATION
// CollabVerseConflictDlg.cpp ID_TEXTCTRL_EDITABLE_PT_VERSION
// ConsChk_Empty_noTU_Dlg.cpp ID_TEXTCTRL_TYPED_AORG
// conschk_exists_notu_dlg.cpp ID_TEXTCTRL_TARGET_PHRASE_2
// ConsistencyCheckDlg.cpp IDC_EDIT_ADAPTATION
// CreateNewAIProjForCollab.cpp ID_TEXTCTRL_TGT_LANG_NAME
// EarlierTranslationDlg.cpp IDC_EDIT_TGT_TEXT
// FindReplace.cpp IDC_EDIT_TGT_FIND, IDC_EDIT_TGT_REPLACE
// GuesserAffixesListsDlg.cpp ID_TEXT_TGT_AFFIX
// KBEditSearch.cpp ID_TEXTCTRL_EDITBOX, ID_TEXTCTRL_LOCAL_SEARCH
// KBPage.cpp IDC_EDIT_TGT_NAME, ID_EDIT_TARGET_LANG_CODE
// KBSharingAuthenticationDlg.cpp ID_TEXTCTRL_USERNAME_STATELESS
// LanguagesPage.cpp IDC_TARGET_LANGUAGE
// NoteDlg.cpp IDC_EDIT_NOTE, IDC_EDIT_FIND_TEXT
// PlaceInternalMarkers.cpp IDC_EDIT_TGT
// PlaceInternalPunct.cpp IDC_EDIT_TGT
// PunctCorrespPage.cpp IDC_EDIT_TGT0, IDC_EDIT_TGT1, ... IDC_EDIT_TGT25; IDC_EDIT_2TGT0, IDC_EDIT_2TGT1, ... IDC_EDIT_2TGT9
// RetranslationDlg.cpp IDC_EDIT_RETRANSLATION
// SilConverterSelectDlg.cpp IDC_ED_SILCONVERTER_INFO
// UsernameInput.cpp ID_TEXTCTRL_USERNAME_INFORMAL, ID_TEXTCTRL_USERNAME_MSG
// ViewFilteredMaterialDlg.cpp IDC_EDIT_MARKER_TEXT
// Other future dialogs???

IMPLEMENT_DYNAMIC_CLASS(AutoCorrectTextCtrl, wxTextCtrl)

// event handler table
BEGIN_EVENT_TABLE(AutoCorrectTextCtrl, wxTextCtrl)
//EVT_TEXT(IDC_EDIT_COMPOSE, AutoCorrectTextCtrl::OnEditBoxChanged)
EVT_CHAR(AutoCorrectTextCtrl::OnChar)
// whm 15Mar12 added back for read-only mode handling
//EVT_KEY_DOWN(AutoCorrectTextCtrl::OnKeyDown)
//EVT_KEY_UP(AutoCorrectTextCtrl::OnKeyUp)
END_EVENT_TABLE()

// the following constructor is never executed (see constructor in ComposeBarEditBox.h)
AutoCorrectTextCtrl::AutoCorrectTextCtrl() // constructor
{

}

AutoCorrectTextCtrl::~AutoCorrectTextCtrl() // destructor
{

}

// event handling functions

void AutoCorrectTextCtrl::OnChar(wxKeyEvent& event)
{
    bool bSkip = !gpApp->AutoCorrected((AutoCorrectTextCtrl*)this, &event);
    // whm 2May2022 modified for testing. The AutoCorrectTextCtrl should be marked as dirty if AutoCorrected() above returns TRUE, i.e., bSkip is FALSE
    // Unfortunately, marking the text control here happens after the class handlers of the class derived from AutoCorrectTextCtrl are executed.
    // I'll leave the block below here, however in case I find a way for it to work properly in the derived class.
    if (!bSkip)
    {
        // An autocorrect change was made in the text control
        this->MarkDirty();
    }

    if (bSkip)
        event.Skip();
}
// end AutoCorrectTextCtrl class definition !!!!!!!!!!!!!!!!!!!!!!!!!!


IMPLEMENT_APP(CAdapt_ItApp)
// This is used in the application class implementation file to make the
// application class known to wxWidgets for dynamic construction.
// Use this instead of MyApp myApp;

BEGIN_EVENT_TABLE(CAdapt_ItApp, wxApp)
// OnIdle() handler was moved to CMainFrame. Having it here in
// the App was causing File | Exit and x App cancel to become
// unresponsive. Same code works fine there.

// File Menu handlers !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
EVT_MENU(wxID_NEW, CAdapt_ItApp::OnFileNew)

// whm added the following 10Apr11 for AI-PT collaboration
//EVT_MENU(ID_MENU_GET_SOURCE_FROM_PT, CAdapt_ItApp::OnGetSourceTextFromPT)
//EVT_UPDATE_UI(ID_MENU_GET_SOURCE_FROM_PT, CAdapt_ItApp::OnUpdateGetSourceTextFromPT)
//EVT_MENU(ID_MENU_TRANSFER_TRANS_TO_PT, CAdapt_ItApp::OnTransferTransToPT)
//EVT_UPDATE_UI(ID_MENU_TRANSFER_TRANS_TO_PT, CAdapt_ItApp::OnUpdateTransferTransToPT)

// OnFileOpen is in the Doc
EVT_MENU(wxID_PAGE_SETUP, CAdapt_ItApp::OnFilePageSetup)
EVT_UPDATE_UI(wxID_PAGE_SETUP, CAdapt_ItApp::OnUpdateFilePageSetup)
EVT_UPDATE_UI(ID_FILE_STARTUP_WIZARD, CAdapt_ItApp::OnUpdateFileStartupWizard)
EVT_MENU(ID_FILE_BACKUP_KB, CAdapt_ItApp::OnFileBackupKb)
EVT_UPDATE_UI(ID_FILE_BACKUP_KB, CAdapt_ItApp::OnUpdateFileBackupKb)
EVT_MENU(ID_FILE_RESTORE_KB, CAdapt_ItApp::OnFileRestoreKb)
EVT_UPDATE_UI(ID_FILE_RESTORE_KB, CAdapt_ItApp::OnUpdateFileRestoreKb)
EVT_MENU(ID_FILE_CHANGEFOLDER, CAdapt_ItApp::OnFileChangeFolder)
EVT_UPDATE_UI(ID_FILE_CHANGEFOLDER, CAdapt_ItApp::OnUpdateFileChangeFolder)
EVT_MENU(ID_FILE_EXPORT_KB, CAdapt_ItApp::OnFileExportKb)
EVT_UPDATE_UI(ID_FILE_EXPORT_KB, CAdapt_ItApp::OnUpdateFileExportKb)
EVT_MENU(ID_MENU_CHANGE_USERNAME, CAdapt_ItApp::OnEditChangeUsername) // is always enabled, needs no update handler
                                                                      //whm removed 1Oct12
    //EVT_MENU_RANGE(wxID_FILE1, wxID_FILE9, CAdapt_ItApp::OnOpenRecentFile)

    // We must not associate OnExit with wxID_EXIT. If we do, OnExit() executes immediately
    // upon selection of File|Exit causing all sorts of problems. Rather we must allow
    // OnExit() to be called by the doc/view framework after it has deleted the current doc
    // and view. Otherwise, if this handler below is enabled, the app won't exit without
    // crashing in the process.
    //EVT_MENU(wxID_EXIT, OnExit)

    // Edit Menu handlers !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    // OnEditUndo is in the View
    // OnUpdateEditUndo is in the View
    // OnEditCut is in the View
    // OnUpdateEditCut is in the View
    // OnEditCopy is in the View
    // OnUpdateEditCopy is in the View
    // OnEditPaste is in the View
    // OnUpdateEditPaste is in the View
    // OnGoTo is in the View
    // OnUpdateGoTo is in the View
    // OnEditPunctCorresp is in the View  // incorporated into Edit|Preferences
    // OnUpdateEditPunctCorresp is in the View  // incorporated into Edit|Preferences
    // OnEditSourceText is in the View
    // OnUpdateEditSourceText is in the View
    // OnEditConsistencyCheck is in the View -- no it's not
    // OnUpdateEditConsistencyCheck is in the View
    // Lower to Upper Case Equivalences... removed as a separate menu item from Edit
    // menu (now handled by Edit Preferences)
    // OnEditPreferences is in the View
    // OnUpdateEditPreferences is in the View

    // View Menu handlers !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    //OnViewToolBar is in the MainFrame
    //OnUpdateViewToolBar is in the MainFrame
    //OnViewStatusBar is in the MainFrame
    //OnUpdateViewStatusBar is in the MainFrame
    //OnViewComposeBar is in the MainFrame
    //OnUpdateViewComposeBar is in the MainFrame
    //OnCopySource is in the View
    //OnUpdateCopySource is in the View // not in MFC version
    //OnFitWindow is in the View
    //OnMarkerWrapsStrip is in the View
    //OnUpdateMarkerWrapsStrip is in the View
    //OnUnits is in the View
    //OnUpdateUnits is in the View

    // Tools Menu handlers !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    //OnFind is in the View
    //OnUpdateFind is in the View
    //OnReplace is in the View
    //OnUpdateReplace is in the View
    EVT_MENU(ID_TOOLS_CLIPBOARD_ADAPT, CAdapt_ItApp::OnToolsClipboardAdapt)
    EVT_UPDATE_UI(ID_TOOLS_CLIPBOARD_ADAPT, CAdapt_ItApp::OnUpdateToolsClipboardAdapt)
    EVT_UPDATE_UI(ID_BUTTON_COPY_TO_CLIPBOARD, CAdapt_ItApp::OnUpdateButtonCopyToClipboard)
    EVT_BUTTON(ID_BUTTON_COPY_TO_CLIPBOARD, CAdapt_ItApp::OnButtonCopyToClipboard)
    EVT_UPDATE_UI(ID_BUTTON_COPY_FREETRANS_TO_CLIPBOARD, CAdapt_ItApp::OnUpdateButtonCopyFreeTransToClipboard)
    EVT_BUTTON(ID_BUTTON_COPY_FREETRANS_TO_CLIPBOARD, CAdapt_ItApp::OnButtonCopyFreeTransToClipboard)
	EVT_BUTTON(ID_BUTTON_CLIPBOARD_ADAPT_CLOSE, CAdapt_ItApp::OnButtonCloseClipboardAdaptDlg)
	EVT_BUTTON(ID_BUTTON_GET_FROM_CLIPBOARD, CAdapt_ItApp::OnButtonGetFromClipboard)

    EVT_MENU(ID_TOOLS_DEFINE_CC, CAdapt_ItApp::OnToolsDefineCC)
    EVT_UPDATE_UI(ID_TOOLS_DEFINE_CC, CAdapt_ItApp::OnUpdateLoadCcTables)
    EVT_MENU(ID_UNLOAD_CC_TABLES, CAdapt_ItApp::OnToolsUnloadCcTables)
    EVT_UPDATE_UI(ID_UNLOAD_CC_TABLES, CAdapt_ItApp::OnUpdateUnloadCcTables)

    // whm added 24March2017 the next two for the "Install the Git program..." Tools menu item
    EVT_MENU(ID_TOOLS_INSTALL_GIT, CAdapt_ItApp::OnToolsInstallGit)
    EVT_UPDATE_UI(ID_TOOLS_INSTALL_GIT, CAdapt_ItApp::OnUpdateInstallGit)

	// void OnGetFromClipboard(wxCommandEvent& WXUNUSED(event)); // BEW added 27Mar18


    //OnUseConsistentChanges is in the View
    //OnUpdateUseConsistentChanges is in the View
    //OnAcceptChanges is in the View
    //OnUpdateAcceptChanges is in the View
    //OnToolsKbEditor is in the View
    //OnUpdateToolsKbEditor is in the View

    // Note: Automatic capitalization is no longer a separate menu item
    // now that there is a tab in Edit / Preferences for Capitalization
    EVT_MENU(ID_TOOLS_AUTO_CAPITALIZATION, CAdapt_ItApp::OnToolsAutoCapitalization)
    EVT_UPDATE_UI(ID_TOOLS_AUTO_CAPITALIZATION, CAdapt_ItApp::OnUpdateToolsAutoCapitalization)
    // BEW added 30Jul13, took the radio button choice out of Misc tab of preferences, to
    // make it a choosable menu item for anytime the user wants to ensure his KB lookups
    // can access as much data as possible. This isn't a setting. It's an operation that
    // is done on the KB each time it is called. (Calling it a second time after having
    // called it once will do nothing but waste some time if the user has not, since last
    // calling it, had Auto Caps turned off and produced some new upper-case-keyed
    // CTargetUnit instances (which would no be accessed in an Auto Caps lookup without
    // this feature being available
    EVT_MENU(ID_MENU_UPPER_AVAIL, CAdapt_ItApp::OnMakeAllKnowledgeBaseEntriesAvailable)
    EVT_UPDATE_UI(ID_MENU_UPPER_AVAIL, CAdapt_ItApp::OnUpdateMakeAllKnowledgeBaseEntriesAvailable)

    //OnRetransReport is in the View
    //OnUpdateRetransReport is in the View

    // Advanced Menu handlers !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    //OnAdvancedSeeGlosses is in the View
    //OnUpdateAdvancedEnableglossing  is in the View
    //OnAdvancedGlossingUsesNavFont  is in the View
    //OnUpdateAdvancedGlossingUsesNavFont  is in the View
    EVT_MENU(ID_ADVANCED_TRANSFORM_ADAPTATIONS_INTO_GLOSSES, CAdapt_ItApp::OnAdvancedTransformAdaptationsIntoGlosses)
    EVT_UPDATE_UI(ID_ADVANCED_TRANSFORM_ADAPTATIONS_INTO_GLOSSES, CAdapt_ItApp::OnUpdateAdvancedTransformAdaptationsIntoGlosses)
    EVT_MENU(ID_ADVANCED_BOOKMODE, CAdapt_ItApp::OnAdvancedBookMode)
    EVT_UPDATE_UI(ID_ADVANCED_BOOKMODE, CAdapt_ItApp::OnUpdateAdvancedBookMode)
    EVT_MENU(ID_ADVANCED_PROTECT_EDITOR_FM__GETTING_CHANGES_FOR_THIS_DOC, CAdapt_ItApp::OnAdvancedProtectEditorFmGettingChangesForThisDoc)
    EVT_UPDATE_UI(ID_ADVANCED_PROTECT_EDITOR_FM__GETTING_CHANGES_FOR_THIS_DOC, CAdapt_ItApp::OnUpdateAdvancedProtectEditorFmGettingChangesForThisDoc)
    EVT_MENU(ID_ADVANCED_ALLOW_EDITOR_TO_GET_CHANGES_FOR_THIS_DOC, CAdapt_ItApp::OnAdvancedAllowEditorToGetChangesForThisDoc)
    EVT_UPDATE_UI(ID_ADVANCED_ALLOW_EDITOR_TO_GET_CHANGES_FOR_THIS_DOC, CAdapt_ItApp::OnUpdateAdvancedAllowEditorToGetChangesForThisDoc)
    //OnAdvancedDelay  is in the View
    //OnUpdateAdvancedDelay  is in the View

    // Help menu handlers !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    //OnAppAbout is in CMainFrame in wxWidgets version

    // Administrator menu handlers !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    EVT_MENU(ID_CUSTOM_WORK_FOLDER_LOCATION, CAdapt_ItApp::OnCustomWorkFolderLocation)
    EVT_UPDATE_UI(ID_CUSTOM_WORK_FOLDER_LOCATION, CAdapt_ItApp::OnUpdateCustomWorkFolderLocation)
    EVT_MENU(ID_SET_PASSWORD_MENU, CAdapt_ItApp::OnSetPassword)
    EVT_UPDATE_UI(ID_SET_PASSWORD_MENU, CAdapt_ItApp::OnUpdateSetPassword)
    EVT_MENU(ID_LOCAL_WORK_FOLDER_MENU, CAdapt_ItApp::OnRestoreDefaultWorkFolderLocation)
    EVT_UPDATE_UI(ID_LOCAL_WORK_FOLDER_MENU, CAdapt_ItApp::OnUpdateRestoreDefaultWorkFolderLocation)
    EVT_MENU(ID_LOCK_CUSTOM_LOCATION, CAdapt_ItApp::OnLockCustomLocation)
    EVT_UPDATE_UI(ID_LOCK_CUSTOM_LOCATION, CAdapt_ItApp::OnUpdateLockCustomLocation)
    EVT_MENU(ID_UNLOCK_CUSTOM_LOCATION, CAdapt_ItApp::OnUnlockCustomLocation)
    EVT_UPDATE_UI(ID_UNLOCK_CUSTOM_LOCATION, CAdapt_ItApp::OnUpdateUnlockCustomLocation)
    EVT_MENU(ID_MOVE_OR_COPY_FOLDERS_OR_FILES, CAdapt_ItApp::OnMoveOrCopyFoldersOrFiles)
    EVT_UPDATE_UI(ID_MOVE_OR_COPY_FOLDERS_OR_FILES, CAdapt_ItApp::OnUpdateMoveOrCopyFoldersOrFiles)
    EVT_MENU(ID_ASSIGN_LOCATIONS_FOR_INPUTS_OUTPUTS, CAdapt_ItApp::OnAssignLocationsForInputsAndOutputs)
    EVT_UPDATE_UI(ID_ASSIGN_LOCATIONS_FOR_INPUTS_OUTPUTS, CAdapt_ItApp::OnUpdateAssignLocationsForInputsAndOutputs)
    EVT_MENU(ID_SETUP_EDITOR_COLLABORATION, CAdapt_ItApp::OnSetupEditorCollaboration)
    EVT_UPDATE_UI(ID_SETUP_EDITOR_COLLABORATION, CAdapt_ItApp::OnUpdateSetupEditorCollaboration)
    EVT_MENU(ID_MENU_MANAGE_DATA_TRANSFER_PROTECTIONS_TO_EDITOR, CAdapt_ItApp::OnManageDataTransfersToEditor)
    EVT_UPDATE_UI(ID_MENU_MANAGE_DATA_TRANSFER_PROTECTIONS_TO_EDITOR, CAdapt_ItApp::OnUpdateManageDataTransfersToEditor)
    //EVT_MENU(ID_PASSWORD_PROTECT_COLLAB_SWITCHING, CAdapt_ItApp::OnPasswordProtectCollaborationSwitching)
    //EVT_UPDATE_UI(ID_PASSWORD_PROTECT_COLLAB_SWITCHING, CAdapt_ItApp::OnUpdatePasswordProtectCollaborationSwitching)
    EVT_MENU(ID_MENU_TEMP_TURN_OFF_CURRENT_PROFILE, CAdapt_ItApp::OnTempRestoreUserProfiles) // whm added 14Feb12
    EVT_UPDATE_UI(ID_MENU_TEMP_TURN_OFF_CURRENT_PROFILE, CAdapt_ItApp::OnUpdateTempRestoreUserProfiles) // whm added 14Feb12
    EVT_MENU(ID_EDIT_USER_MENU_SETTINGS_PROFILE, CAdapt_ItApp::OnEditUserMenuSettingsProfiles)
    EVT_UPDATE_UI(ID_EDIT_USER_MENU_SETTINGS_PROFILE, CAdapt_ItApp::OnUpdateEditUserMenuSettingsProfiles)
    EVT_MENU(ID_MENU_HELP_FOR_ADMINISTRATORS, CAdapt_ItApp::OnHelpForAdministrators)
    EVT_UPDATE_UI(ID_MENU_HELP_FOR_ADMINISTRATORS, CAdapt_ItApp::OnUpdateHelpForAdministrators)
//#if defined(_KBSERVER)
    EVT_MENU(ID_MENU_KBSHARINGMGR, CAdapt_ItApp::OnKBSharingManagerTabbedDlg) // always potentially needed
    EVT_UPDATE_UI(ID_MENU_KBSHARINGMGR, CAdapt_ItApp::OnUpdateKBSharingManagerTabbedDlg)
	EVT_MENU(ID_MENU_ADMIN_ADD_USERS, CAdapt_ItApp::OnAddUsersToKBserver) // for creating some users to start with
	EVT_UPDATE_UI(ID_MENU_ADMIN_ADD_USERS, CAdapt_ItApp::OnUpdateAddUsersToKBserver)

		
		//    EVT_TIMER(wxID_ANY, CAdapt_ItApp::OnServiceDiscoveryTimer)

//#endif
//#if !defined(_KBSERVER)
//    EVT_UPDATE_UI(ID_MENU_KBSHARINGMGR, CAdapt_ItApp::OnUpdateKBSharingManagerTabbedDlg)
//#endif
    EVT_TIMER(wxID_ANY, CAdapt_ItApp::OnTimer)

    //EVT_WIZARD_PAGE_CHANGING(IDC_WIZARD,CAdapt_ItApp::WizardPageIsChanging)
    //EVT_WIZARD_FINISHED(-1,CAdapt_ItApp::OnWizardFinish) // not needed, can handle directly
    // by checking the return bool value of RunWizard.
    END_EVENT_TABLE()

    /////////////////////////////////////////////////////////////////////////////
    // NOTE: Under wxWidgets I've changed the following from static TCHAR arrays to
    // just wxStrings, since all the methods in wxWidgets are efficient
    // and sufficiently UNICODE aware with wxStrings.
    //
    // whm I've decided that the literal strings that are used to identify parts of
    // the configuration files should NOT be localizable. Therefore, I've used the _T()
    // literal string macro (which makes them ignored for translation when GetText
    // and/or PoEdit collects the translatable strings for localization). Reason: If
    // these strings are localized, they would create a situation in which the config
    // files would only be readable by others using the same localized interface
    // version of Adapt It. This might become a problem if say a team using the
    // French interface were to pack up their Adapt It documents and sent them to a
    // consultant who is using a different interface version of Adapt It. Packed
    // files would not be compatible except for unpacking on machines using the
    // same language interface version.

    /// The name used internally within the project settings configuration file.
    wxString szProjectSettings = _T("ProjectSettings"); // don't need \n now
                                                        /// The name used internally within the basic settings configuration file.
wxString szBasicSettings = _T("Settings"); // don't need \n now

                                           /// The name of the project configuration file without the .aic extension.
wxString szProjectConfiguration = _T("AI-ProjectConfiguration");

/// The name of the basic configuration file without the .aic extension.
wxString szBasicConfiguration = _T("AI-BasicConfiguration");

/// The name of the administrator basic configuration file without the .aic extension.
/// This name is used for a modified basic configuration file stored at a custom location
/// when the administrator is accessing someone's work folder stored on the
/// administrator's local machine at a non-standard folder location. The idea is not to
/// modify the original basic configuration file with the name given by
/// szBasicConfiguration because the latter will be what the someone else will want to be
/// unchanged when/if that work folder is checked out of DVCS to that someone else's machine
wxString szAdminBasicConfiguration = _T("AI-AdminBasicConfiguration");

/// The name of the administrator project configuration file without the .aic extension.
/// This name is used for a modified project configuration file stored in a project folder
/// at a custom location when the administrator is accessing it. The idea is not to
/// modify the original project configuration file with the name given by
/// szProjectConfiguration because the latter will be what the someone else will want to be
/// unchanged when/if that work folder is checked out of DVCS to that someone else's machine
wxString szAdminProjectConfiguration = _T("AI-AdminProjectConfiguration");

/// When its checkbox is TRUE, Shift-Ctrl-spacebar will insert a ZWSP in the focused wxTestCtrl,
/// but nothing happens if the checkbox is FALSE. Checkbox is in the View page of Preferences
wxString szEnableZWSPinsertion = _T("Enable_ZWSP_Insertion");

/// When its checkbox is TRUE, / (solidus, or 'forward slash') is supported
/// as a word-break delimiter, along with other whitespace characters, between
/// words. This applies to certain east asian languages where normally only
/// ZWSP (zero width space) would be used - but the Paratext people have
/// provided certain users with this option, since the people have no mental concept
/// of a "word". Paratext shows the / only in Unformatted view; other views
/// show ZWSP (replaced by auto-calling a Consistent Changes table, and
/// converting back to the forward slash is auto-done by a different table).
/// We have emulated this kind of support, and it is turned on by a checkbox
/// in the ViewPage class, and the app flag is m_bFwdSlashDelimiter; code
/// connected with this feature is wrapped in FWD_SLASH_DELIM conditional
/// #ifdef .... #endif blocks; only to make it easy to locate the code
/// fragments. The boolean we store in the project config file.
/// BEW added 23Apr15
//#if defined(FWD_SLASH_DELIM)
wxString szSolidusWordBreaker = _T("Support_Slash_As_Word_Separator");
//#endif

/// The name that introduces the properties of the source font within both
/// the basic and project configuration files.
wxString szSourceFont = _T("SourceFont"); // don't need \n now

                                          /// The name that introduces the properties of the target font within both
                                          /// the basic and project configuration files.
wxString szTargetFont = _T("TargetFont"); // don't need \n now

                                          /// The name that introduces the properties of the navigation font within both
                                          /// the basic and project configuration files.
wxString szNavTextFont = _T("NavTextFont"); // don't need \n now

                                            /// The label that identifies the following number as a "negative height" value
                                            /// for the current font being described in the basic and project configuration
                                            /// files. See the PointSizeToNegHeight() and NegHeightToPointSize() helper
                                            /// functions in help.cpp for information on how a "negative height" value is
                                            /// converted to a standard point size.
wxString szHeight = _T("Height");

/// The label that identifies the following number as a font "Width". This number
/// is not used in the wxWidgets version of Adapt It. It is set to zero if the
/// wx version creates the configuration file, or preserves any existing Width
/// value when loading a configuration file created by an MFC version of Adapt It.
wxString szWidth = _T("Width");

/// The label that identifies the following number as a font "Escapement".
/// This number is not used in the wxWidgets version of Adapt It. It is set to
/// zero if the wx version creates the configuration file, or preserves any
/// existing Escapement value when loading a configuration file created by an
/// MFC version of Adapt It.
wxString szEscapement = _T("Escapement");

/// The label that identifies the following number as a font "Orientation".
/// This number is not used in the wxWidgets version of Adapt It. It is set to
/// zero if the wx version creates the configuration file, or preserves any
/// existing Orientation value when loading a configuration file created by an
/// MFC version of Adapt It.
wxString szOrientation = _T("Orientation");

/// The label that identifies the following number as a font "Weight".
/// The wx version converts this value internally to its own enum value
/// for wxLIGHT (400-499), wxNORMAL (500-699), or wxBOLD (700 or more).
/// For compatability with the MFC version, the wx version writes the
/// numerical value only (as strings) in the configuration files.
wxString szWeight = _T("Weight");

/// The label that identifies the following number as font "Italic" if
/// "1", or normal if "0". The wx version converts this value internally
/// to its own enum value for wxITALIC or wxNORMAL.
/// For compatability with the MFC version, the wx version writes the
/// numerical value only (as strings) in the configuration files.
wxString szItalic = _T("Italic");

/// The label that identifies the following number as font "StrikeOut".
/// This number is not used in the wxWidgets version of Adapt It. It is set to
/// zero if the wx version creates the configuration file, or preserves any
/// existing StrikeOut value when loading a configuration file created by an
/// MFC version of Adapt It.
wxString szStrikeOut = _T("StrikeOut");

/// The label that identifies the following number as font "Underline" if
/// "1", or normal if "0". The wx version converts this value internally
/// to its own boolean values of TRUE for Underline, FALSE otherwise.
/// For compatability with the MFC version, the wx version writes the
/// numerical value only (as strings) in the configuration files.
wxString szUnderline = _T("Underline");

/// The label that identifies the following number as bitmap composite for
/// font "PitchAndFamily". The wx version is only interested in the font
/// family part of this composite value, which it determines by masking
/// out the 4 low order bits of the value. Only the font family values are
/// used within the wx version. The font "pitch" value is stored for later
/// composition again with the "family" value for saving the composite in
/// the configuration files.
/// For compatability with the MFC version, the wx version writes the
/// numerical value only (as strings) in the configuration files.
wxString szPitchAndFamily = _T("PitchAndFamily");

/// The label that identifies the following number as a font "FontEncoding". The wx version
/// makes use of this value for ANSI builds. It is not included in a configuration file
/// created by the MFC version. Note: setting the font encoding of the actual font is done
/// after CharSet value is read from the config file because, if the config file was
/// produced by the MFC app, it won't have this szFontEncoding field, but ig will have the
/// CharSet value.
wxString szFontEncoding = _T("FontEncoding");

/// The label that identifies the following number as a font "CharSet". The wx version
/// retains the CharSet value mainly for backwards compatibility with the MFC version's
/// configure files. Note: It is when the CharSet value is read from the configuration file
/// that font encoding is established for the font in ANSI builds (if the congig file has a
/// FontEncoding value. The wx version uses its MapMFCCharsetToWXFontEncoding(), and
/// MapWXFontEncodingToMFCCharset() functions to map values to and from the closest font
/// encoding equivalents that it knows about.
wxString szCharSet = _T("CharSet");

/// The label that identifies the following number as font "OutPrecision". This number is
/// not used in the wxWidgets version of Adapt It. It is set to 3 (OUT_OUTLINE_PRECIS) as
/// its default for TrueType fonts if the wx version creates the configuration file, or
/// preserves any existing OutPrecision value when loading a configuration file created by
/// an MFC version of Adapt It.
wxString szOutPrecision = _T("OutPrecision");

/// The label that identifies the following number as font "ClipPrecision". This number is
/// not used in the wxWidgets version of Adapt It. It is set to 2 (CLIP_STROKE_PRECIS) as
/// its default if the wx version creates the configuration file, or preserves any existing
/// ClipPrecision value when loading a configuration file created by an MFC version of
/// Adapt It.
wxString szClipPrecision = _T("ClipPrecision");

/// The label that identifies the following number as font "Quality". This number is not
/// used in the wxWidgets version of Adapt It. It is set to 0 (ANTIALIASED_QUALITY) as its
/// default if the wx version creates the configuration file, or preserves any existing
/// Quality value when loading a configuration file created by an MFC version of Adapt It.
wxString szQuality = _T("Quality");

/// The label that identifies the following string as font "FaceName". The wx version
/// attempts to set the FaceName of its fonts using this string value stored in the
/// configurations files by calling the font's SetFaceName() method. It SetFaceName() does
/// not succeed, the application calls the font's GetFaceName() method to have the system
/// decide on a suitable font.
wxString szFaceName = _T("FaceName");

//wxString szSystem = _("System"); // unused

/// The label that identifies the following number as a font "Color". The wx version uses
/// its Int2wxColour(), and WxColour2Int() functions to map values to and from the the
/// numerical color equivalent values. Note:
/// A font's color is handled in objects of the wxFontData class rather than in the wxFont
/// class.
wxString szColor = _T("Color");

// stuff I am not yet using is below
//wxString szWordWrap = _("WordWrap"); // unused
//wxString szTabStops = _("TabStops"); // unused

// entry names for the settings info

/// The label that identifies the following string as the project's "SourceLanguageName".
/// This value is written in the "Settings" part of the basic configuration file and in the
/// "ProjectSettings" part of the project configuration file. Adapt It stores this path in
/// the App's m_sourceName member variable.
wxString szSourceLanguageName = _T("SourceLanguageName"); // stored in the App's m_sourceName

                                                          /// The label that identifies the following string as the project's "TargetLanguageName".
                                                          /// This value is written in the "Settings" part of the basic configuration file and in the
                                                          /// "ProjectSettings" part of the project configuration file. Adapt It stores this path in
                                                          /// the App's m_targetName member variable.
wxString szTargetLanguageName = _T("TargetLanguageName");

/// The label that identifies the following string as the project's "GlossesLanguageName".
/// This value is written in the "Settings" part of the project & basic configuration files
/// Adapt It stores this path in the App's m_glossesName member variable.
wxString szGlossesLanguageName = _T("GlossesLanguageName");

// BEW added 25Jul12
/// The label that identifies the following string as the project's "FreeTranslationLanguageName".
/// This value is written in the "Settings" part of the project & basic configuration files
/// Adapt It stores this path in the App's m_freeTransName member variable.
wxString szFreeTransLanguageName = _T("FreeTranslationLanguageName");

// whm added following 10May10 for KB LIFT XML Export support
/// The label that identifies the following string as the project's "SourceLanguageCode".
/// This value is written in the "ProjectSettings" part of the project & basic configuration files.
/// Adapt It stores this path in the App's m_sourceLanguageCode member variable.
wxString szSourceLanguageCode = _T("SourceLanguageCode"); // stored in the App's m_sourceName

                                                          // whm added following 10May10 for KB LIFT XML Export support
                                                          /// The label that identifies the following string as the project's "TargetLanguageCode".
                                                          /// This value is written in the "ProjectSettings" part of the project & basic configuration files.
                                                          /// Adapt It stores this string in the App's m_targetLanguageCode member variable.
wxString szTargetLanguageCode = _T("TargetLanguageCode");

// whm added following 10May10 for KB LIFT XML Export support
/// The label that identifies the following string as the project's "GlossesLanguageCode".
/// This value is written in the "ProjectSettings" part of the project & basic configuration files.
/// Adapt It stores this string in the App's m_glossesLanguageCode member variable.
wxString szGlossesLanguageCode = _T("GlossesLanguageCode");

// BEW added 25Jul12
/// The label that identifies the following string as the project's
/// "FreeTranslationLanguageCode". This value is written in the "ProjectSettings" part of
/// the project & basic configuration files. Adapt It stores this string in the App's
/// m_freeTransLanguageCode member variable.
wxString szFreeTransLanguageCode = _T("FreeTranslationLanguageCode");

/// The label that identifies the whether or not the project is associated with sharing a
/// target language KB. This value is written in the "ProjectSettings" part of the project
/// configuration file. Adapt It stores this string in the App's m_bIsKBServerProject
/// member variable. Default is FALSE.
wxString szIsKBServerProject = _T("IsKBServerProject");

wxString szSentFinalPunctsTriggerCaps = _T("SentenceFinalPunctuationTriggeringCapitalization"); // BEW added 9May16
wxString szUpperCaseAnywhereInFirstWord = _T("UpperCaseAnywhereInFirstWordOfSource"); // BEW added 24May16,
														// for things like src: na-John -> tgt: Johan

/// The label that identifies the whether or not the project is associated with sharing a
/// glosses language KB. This value is written in the "ProjectSettings" part of the project
/// configuration file. Adapt It stores this string in the App's m_bIsGlossingKBServerProject
/// member variable. Default is FALSE.
wxString szIsGlossingKBServerProject = _T("IsGlossingKBServerProject");

// next two added 30Jan13
/// The label for the basic configuration file's line which stores the ipAddress of the last
/// used server for knowledge base sharing within a project designated as one for sharing
/// BEW 27Jul20 return URL in name (to avoid bumping docVersion) but store ipAddress now
wxString szKbServerURL = _T("KbServerURL");

// Next added 27Apr16
/// The label for the hostname associated with szKbServerURL
wxString szKbServerHostname = _T("KbServerHostname");

/// The label for the project configuration file's line which stores the assigned username
/// for the last used server for knowledge base sharing within a project designated as one
/// for sharing. Because an email address is unique, we recommend the user's email address
/// be used for the username (full address, including domain); however not all users will
/// have email access, so any likely-to-be-unique name would be acceptable;
/// 20May13, this name was made app-wide in scope, and so it to be used for DVCS, KB
/// sharing, and xhtml & Pathway export, and any other future feature needing a username
wxString szUniqueUsername = _T("UniqueUsername");
/// The following one is an informal one, can be a pseudonom, for the user - but needed
/// for KBserver, and git
wxString szInformalUsername = _T("InformalUsername");

/// The minimum interval, in minutes, from one incremental download attempt to the next
/// (defaulted to 5 minutes, in OnInit(), but project config file value will override)
wxString szKbServerDownloadInterval = _T("KbServerIncrementalDownloadInterval");

/// Default is 0. The user can use a slider control in View page of Preferences in order
/// to cause some extra pixels to be added to cell heights in the layout, up to a maximum
/// of 6 extra pixels. (This is for better support of stacked diacritics, to prevent
/// unwanted truncation visually in some circumstances.)
wxString szExtraPixelsForDiacritics = _T("ExtraPixelsForDiacritics");

/// Default is TRUE, the strips then move up relative to the phrase box as the user's work
/// moves to a new strip - this is visually unappealing to 3rd parties looking on (eg. by
/// projection of the screen on a wall). If set FALSE (in Preferences > View), the strips
/// are kept stationary in the vertical dimension, and the phrase box moves down as the
/// user's work progresses to successive strips - when it reaches the last visible strip,
/// autoscrolling is done so that the phrase box is at the second strip from the top, and
/// moves down the client area etc.
wxString szKeepPhraseBoxMidscreen = _T("KeepPhraseBoxMidscreen");

// whm 19Apr2018 removed. No longer need to save this setting
//wxString szUseChooseTransDropDown = _T("UseChooseTranslationDropDownQuickSelector");

/// Default is FALSE, auto-caps lookup only looks up lower case keys; if user sets the
/// boolean to TRUE, on fail an auto-caps upper case lookup is attempted - if it
/// succeeds, a boolean is set to TRUE temporarily - and StoreText() and
/// StoreTextGoingBack() use that boolean to create a new CTargetUnit instance and store
/// lower case source and target strings in it. Consistency Check also works a little
/// differently as well.
wxString szDoLegacyLowerCaseLookup = _T("DoLegacyLowerCaseLookup");

/// The minimum interval, in minutes, from one incremental download attempt to the next
/// (defaulted to 5 minutes, in OnInit(), but project config file value will override)
//wxString szKbServerUploadInterval = _T("KbServerIncrementalUploadInterval"); // deprecated 11Feb13

//#endif

/// The label that identifies the following string as the project's "TargetLanguageName".
/// This value is written in the "Settings" part of the basic configuration file. After
/// validating this path to ensure its validity on the local machine, Adapt It stores this
/// path in the App's m_workFolderPath member variable.
wxString szAdaptitPath = _T("AdaptItPath");

/// The label that identifies the following string as the project's "ProjectName". This
/// value is written in the "Settings" part of the basic configuration file. Adapt It
/// stores this name in the App's m_curProjectName member variable.
wxString szCurProjectName = _T("ProjectName");

/// The label that identifies the following string as the project's "ProjectFolderPath".
/// This value is written in the "ProjectSettings" part of the project configuration file.
/// Adapt It stores this path in the App's m_curProjectPath member variable.
wxString szCurLanguagesPath = _T("ProjectFolderPath");

/// The label that identifies the following string as the project's "DocumentsFolderPath".
/// This value is written in the "ProjectSettings" part of the project configuration file.
/// Adapt It stores this path in the App's m_curAdaptationsPath member variable.
wxString szCurAdaptationsPath = _T("DocumentsFolderPath");

/// The label that identifies the following string as the project's "KnowledgeBaseName".
/// This value is written in the "ProjectSettings" part of the project configuration file.
/// Adapt It stores this name in the App's m_curKBName member variable.
wxString szCurKBName = _T("KnowledgeBaseName");

/// The label that identifies the following string as the project's "KnowledgeBasePath".
/// This value is written in the "ProjectSettings" part of the project configuration file.
/// Adapt It stores this path in the App's m_curKBName member variable.
wxString szCurKBPath = _T("KnowledgeBasePath");

/// The label that identifies the following string as the project's "KBBackupPath". This
/// value is written in the "ProjectSettings" part of the project configuration file. Adapt
/// It stores this path in the App's m_curKBBackupPath member variable.
wxString szCurKBBackupPath = _T("KBBackupPath");

// BEGINNING of Last...Path variables below

/// The label that identifies the following string as the project's
/// "LastNewDocumentFolder". This value is written in the "ProjectSettings"
/// part of the project configuration file. Adapt It stores this path in the
/// App's m_lastSourceInputPath member variable.
wxString szLastSourceInputPath = _T("LastNewDocumentFolder");

/// The label that identifies the following string as the project's
/// "LastSourceTextExportPath". This value is written in the "ProjectSettings"
/// part of the project configuration file. Adapt It stores this path in the
/// App's m_lastSourceOutputPath member variable.
wxString szLastSourceOutputPath = _T("LastSourceTextExportPath");

/// The label that identifies the following string as the project's
/// "LastSourceTextRTFExportPath". This value is written in the "ProjectSettings"
/// part of the project configuration file. Adapt It stores this path in the
/// App's m_lastSourceRTFOutputPath member variable.
wxString szLastSourceRTFOutputPath = _T("LastSourceTextRTFExportPath");

/// The label that identifies the following string as the project's
/// "LastKBExportPath". This value is written in the "ProjectSettings" part
/// of the project configuration file. Adapt It stores this path in the
/// App's m_lastKbOutputPath member variable.
/// The old config label "KB_ExportPath" is retained for reading older
/// config files.
wxString szLastKBExportPath = _T("LastKBExportPath"); // new label for 6.x.x and later
wxString szKBExportPath = _T("KB_ExportPath"); // old label - retain for reading older config files

                                               /// The label that identifies the following string as the project's
                                               /// "LastKBLIFTExportPath". This value is written in the "BasicSettings"
                                               /// part of the basic configuration file. Adapt It stores this path in the
                                               /// App's m_lastKbLiftOutputPath member variable.
wxString szLastKBLIFTExportPath = _T("LastKBLIFTExportPath"); // stored in the App's m_lastKbLiftOutputPath
wxString szKBLIFTExportPath = _T("KB_LIFT_ExportPath"); // old label used only in development but retained to avoid warning

                                                        /// The label that identifies the following string as the project's
                                                        /// "RetranslationReportPath". This value is written in the "BasicSettings"
                                                        /// part of the basic configuration file. Adapt It stores this path in the
                                                        /// App's m_lastRetransReportPath member variable.
wxString szLastRetranslationReportPath = _T("LastRetranslationReportPath"); // new label for 6.x.x and later
wxString szRetranslationReportPath = _T("RetranslationReportPath"); // old label - retain for reading older config files

                                                                    /// whm 6Aug11 Note: The m_lastRtfOutputPath is no longer used, but is
                                                                    /// replaced by more specific variables that are stored in project config files.
                                                                    /// We keep the szRTFExportPath label in config reading routines however, since
                                                                    /// we want to be able to recognize when an old basic config file is being read
                                                                    /// that will have this field - we read it but just ignore it.
wxString szRTFExportPath = _T("RTFExportPath");

/// The label that identifies the following string as the project's
/// "LastInterlinearRTFOutputPath". This value is written in the "ProjectSettings"
/// part of the project configuration file. Adapt It stores this path in the
/// App's m_lastInterlinearRTFOutputPath member variable.
wxString szLastInterlinearRTFOutputPath = _T("LastInterlinearRTFOutputPath");

/// The label that identifies the following string as the project's
/// "LastGlossesExportPath". This value is written in the "ProjectSettings"
/// part of the project configuration file. Adapt It stores this path in the
/// App's m_lastGlossesOutputPath member variable.
wxString szLastGlossesOutputPath = _T("LastGlossesTextExportPath");

/// The label that identifies the following string as the project's
/// "LastGlossesRTFExportPath". This value is written in the "ProjectSettings"
/// part of the project configuration file. Adapt It stores this path in the
/// App's m_lastGlossesRTFOutputPath member variable.
wxString szLastGlossesRTFOutputPath = _T("LastGlossesTextRTFExportPath");

/// The label that identifies the following string as the project's
/// "LastFreeTranslationsExportPath". This value is written in the "ProjectSettings"
/// part of the project configuration file. Adapt It stores this path in the
/// App's m_lastFreeTransOutputPath member variable.
wxString szLastFreeTransOutputPath = _T("LastFreeTransExportPath");

/// The label that identifies the following string as the project's
/// "LastFreeTranslationsRTFExportPath". This value is written in the "ProjectSettings"
/// part of the project configuration file. Adapt It stores this path in the
/// App's m_lastFreeTransRTFOutputPath member variable.
wxString szLastFreeTransRTFOutputPath = _T("LastFreeTransRTFExportPath");

/// The label that identifies the following string as the application's
/// "LastCCTablePath". This value is written in the "Settings" part of
/// the basic configuration file. Adapt It stores this path in the
/// App's m_lastCcTablePath member variable.
/// The old "DefaultCCTablePath" label is recognized for reading of older
/// config files.
wxString szLastCCTablePath = _T("LastCCTablePath");
wxString szDefaultTablePath = _T("DefaultCCTablePath");

/// The label that identifies the following string as the application's
/// "LastPackedDocumentPath". This value is written in the "Settings"
/// part of the basic configuration file. Adapt It stores this path in the
/// App's m_lastPackedOutputPath member variable.
wxString szLastPackedDocumentPath = _T("LastPackedDocumentPath");

/// The label that identifies the following string as the application's
/// "LastDocumentPath". This value is written in the "ProjectSettings"
/// part of the project configuration file. Adapt It stores this path in the
/// App's m_lastDocPath member variable.
wxString szLastDocPath = _T("LastDocumentPath");

/// The label that identifies the following string as the application's
/// "LastExportPath". This value is written in the "ProjectSettings"
/// part of the project configuration file. Adapt It stores this path
/// in the App's m_lastTargetOutputPath member variable. The old
/// "LastExportPath" label is recognized for reading of older config
/// files.
wxString szLastTargetOutputPath = _T("LastTargetExportPath"); // new 6.x.x label for config files
wxString szLastExportPath = _T("LastExportPath"); // old pre-6.x.x label for reading old config files

/// The label that identifies the following string as the application's
/// "LastTargetRTFExportPath". This value is written in the "ProjectSettings"
/// part of the project configuration file. Adapt It stores this path in the
/// App's m_lastTargetRTFOutputPath member variable.
wxString szLastTargetRTFOutputPath = _T("LastTargetRTFExportPath");

/// The label that identifies the following string as the application's
/// "LastXhtmlExportPath". This value is written in the "ProjectSettings"
/// part of the project configuration file. Adapt It stores this path in the
/// App's m_lastXhtmlOutputPath member variable.
wxString szLastXhtmlOutputPath = _T("LastXhtmlExportPath");

/// The label that identifies the following string as the application's
/// "LastPathwayExportPath". This value is written in the "ProjectSettings"
/// part of the project configuration file. Adapt It stores this path in the
/// App's m_lastPathwayOutputPath member variable.
wxString szLastPathwayOutputPath = _T("LastPathwayExportPath");
// END of Last...Path variables

// whm 22Apr2019 added nex two for email Reports and Feedback:

/// The label that identifies the following string as the application's
/// "ServerURL". This value is written in the basic configuration file.
wxString szServerURL = _T("ServerURL"); // defaults to _T("https://adapt-it.org/"); // may be changed if basic config file changes it.

/// The label that identifies the following string as the application's
/// "PhpFileName". This value is written in the basic configuration file.
wxString szPhpFileName = _T("PhpFileName"); // defaults to _T("feedback.php"); // may be changed if basic config file changes it.

/// The label that identifies the following string as the project's
/// "FoldersProtectedFromNavigation". This value is written in the "ProjectSettings" part
/// of the project configuration file. Adapt It stores this path in the App's
/// m_foldersProtectedFromNavigation member variable.
wxString szFoldersProtectedFromNavigation = _T("FoldersProtectedFromNavigation");

// the following ones relate to view parameters

// The label that identifies the following string encoded number as the application's
// "MaxToDisplay". This value is written in the "Settings" part of the basic configuration
// file. Adapt It stores this value in the App's m_nMaxToDisplay member variable.
// BEW retained 21Mar09, but now it stores doc count of CSourcePhrase instances, no use
// made of it though - for backwards compatibility of config files
wxString szMaxToDisplay = _T("MaxToDisplay"); // stored in the App's m_nMaxToDisplay

                                              /// The label that identifies the following string encoded number as the application's
                                              /// "MinPrecedingContext". This value is written in the "Settings" part of the basic
                                              /// configuration file. Adapt It stores this path in the App's m_nPrecedingContext member
                                              /// variable.
                                              /// Jul 09 deprecated: retained for config file backwards compatibility
wxString szMinPrecContext = _T("MinPrecedingContext");

/// The label that identifies the following string encoded number as the application's
/// "MinFollowingContext". This value is written in the "Settings" part of the basic
/// configuration file. Adapt It stores this value in the App's m_nFollowingContext member
/// variable.
/// Jul 09 deprecated: retained for config file backwards compatibility
wxString szMinFollContext = _T("MinFollowingContext");

/// The label that identifies the following string encoded number as the application's
/// "Leading". This value is written in the "Settings" part of the basic configuration
/// file. Adapt It stores this value in the App's m_curLeading member variable.
wxString szLeading = _T("Leading");

/// The label that identifies the following string encoded number as the application's
/// "LeftMargin". This value is written in the "Settings" part of the basic configuration
/// file. Adapt It stores this value in the App's m_curLMargin member  variable.
wxString szLeftMargin = _T("LeftMargin");

/// The label that identifies the following string encoded number as the application's
/// "MinimumPileWidth". This value is written in the basic configuration
/// file. Adapt It stores this value in the App's m_nMinPileWidth member variable.
wxString szMinPileWidth = _T("MinimumPileWidth");

/// Forces all \f .... \f* information, including the markers, to be excluded from
/// a transfer of adaptation or free translation to to either external editor when
/// in collaboration mode. Has no effect when not in collaboration mode.
// Uses the flag m_bNoFootnotesInCollabToPTorBE, which is default FALSE
wxString szNoFootnotesToPTorBE = _T("SendNoFootnotesToParatextOrBibledit");

// Default is this feature is Off. If turned on at the Backups & Misc tab of Preferences,
// then a series of auto-inserts will start with a freeze of the canvas, and after every 7th
// OnPass() call there will be a thaw & a 1/3 second delay.
wxString szSupportFreezeAndThaw = _T("SupportFreezeAndThawInAutoInserts");

/// The label that identifies the following string encoded number as the application's
/// "InterpileGapWidth". This value is written in the "Settings" part of the basic configuration
/// file. Adapt It stores this path in the App's m_curGapWidth member  variable.
wxString szGapWidth = _T("InterpileGapWidth");

/// The label that identifies the following string encoded number as the application's
/// "SuppressFirstLine". This value is written in the "Settings" part of the basic
/// configuration file. Adapt It used this value to suppress the "no punctuation" source
/// text line when strips had a max of five lines - two source, two target, and one gloss.
/// Deprecated July09. This is not used anymore, but must be retained in order to maintain
/// backwards compatibility of the configuration files
wxString szSuppressFirst = _T("SuppressFirstLine");

/// The label that identifies the following string encoded number as the application's
/// "SuppressLastLine". This value is written in the "Settings" part of the basic
/// configuration file. Adapt It used this value to suppress the "no punctuation" target
/// text line when strips had a max of five lines - two source, two target, and one gloss.
/// Deprecated July09. This is not used anymore, but must be retained in order to maintain
/// backwards compatibility of the configuration files
wxString szSuppressLast = _T("SuppressLastLine");

/// The label that identifies the following string encoded number as the application's
/// "HidePunctuationFlag". This value is written in the "Settings" part of the basic
/// configuration file. Adapt It stores this path in the App's m_bHidePunctuation member
/// variable.
wxString szHidePunctuation = _T("HidePunctuationFlag");

/// The label that identifies the following string encoded number as the application's
/// "SpecialTextColor". This value is written in the "Settings" part of the basic
/// configuration file. Adapt It stores this path in the App's m_specialTextColor member
/// variable.
wxString szSpecialTextColor = _T("SpecialTextColor");

/// The label that identifies the following string encoded number as the application's
/// "RetranslationTextColor". This value is written in the "Settings" part of the basic
/// configuration file. Adapt It stores this path in the App's m_reTranslnTextColor member
/// variable.
wxString szReTranslnTextColor = _T("RetranslationTextColor");

/// The label that identifies the following string encoded number as the application's
/// "TargetDifferencesTextColor". This value is not written in the "Settings" part of the
/// basic configuration file. Adapt It stores this path in the App's m_tgtDiffsTextColor
/// member variable.
wxString szTgtDiffsTextColor = _T("TargetDifferencesTextColor");

/// The label that identifies the following string encoded number as the application's
/// "PhraseBoxExpansionMultiplier". This value is written in the "Settings" part of the
/// basic configuration file. Adapt It stores this path in the App's m_nBoxSlop
/// member variable.
wxString szPhraseBoxExpansionMultiplier = _T("PhraseBoxExpansionMultiplier");

/// The label that identifies the following string encoded number as the application's
/// "TooNearEndMultiplier". This value is written in the "Settings" part of the basic
/// configuration file. Adapt It stores this path in the App's m_nNearEndFactor member
/// variable.
wxString szTooNearEndMultiplier = _T("TooNearEndMultiplier");

/// The label that identifies the following string encoded number as the application's
/// "LegacyCopyForPhraseBox". This value is written in the "ProjectSettings" part of the
/// project configuration file. Adapt It stores this path in the App's
/// m_bLegacySourceTextCopy member variable.
wxString szLegacyCopyForPhraseBox = _T("LegacyCopyForPhraseBox");

/// The label that identifies the following string encoded number as the application's
/// "SelectCopiedSource". This value is written in the "ProjectSettings" part of the
/// project configuration file. Adapt It stores this value in the App's
/// m_bSelectCopiedSource member variable.
wxString szSelectCopiedSource = _T("SelectCopiedSource");

// Next two were for old punct, for when source & target are not differentiated

/// A label now unused, that was used in old versions for punctuation. It is only retained
/// for reading legacy config files safely. Deprecated.
wxString szPunctuation = _T("Punctuation");

/// A label now unused, that was used in old versions for punctuation. It is only retained
/// for reading legacy config files safely. Deprecated.
wxString szPunctAsWordBuilding = _T("PunctuationAsWordBuilding");

// Next four were for newer variables but currently unused, for when source and target
// punctuation are potentially differentiated

/// A label now unused, that was used in old versions for punctuation. It is only retained
/// for reading legacy config files safely. Deprecated.
wxString szSrcPunctuation = _T("SourcePunctuation");

/// A label now unused, that was used in old versions for punctuation. It is only retained
/// for reading legacy config files safely. Deprecated.
wxString szSrcPunctAsWordBuilding = _T("SourcePunctAsWordBuilding");

/// A label now unused, that was used in old versions for punctuation. It is only retained
/// for reading legacy config files safely. Deprecated.
wxString szTgtPunctuation = _T("TargetPunctuation");

/// A label now unused, that was used in old versions for punctuation. It is only retained
/// for reading legacy config files safely. Deprecated.
wxString szTgtPunctAsWordBuilding = _T("TargetPunctAsWordBuilding");

/// The label that identifies the following string as the application's
/// "PunctuationPairs(stores space for an empty cell)". This value is written in the
/// "Settings" part of the basic configuration file. Adapt It stores this punctuation in
/// the App's m_punctPairs global array. The application uses the PunctPairsToString() and
/// StringToPunctPairs() functions to manipulate the pairs of punctuation data.
wxString szPunctPairs = _T("PunctuationPairs(stores space for an empty cell)");

/// The label that identifies the following string as the application's
/// "PunctuationTwoCharacterPairs". Used only in the Unicode version This value is written
/// in the "Settings" part of the basic configuration. file. Adapt It stores this
/// punctuation in the App's m_twopunctPairs global array. The application uses the
/// TwoPunctPairsToString() and StringToTwoPunctPairs() functions to manipulate the pairs
/// of punctuation data.
wxString szTwoPunctPairs = _T("PunctuationTwoCharacterPairs");
#ifdef _UNICODE

/// The label that identifies the following string as the application's
/// "PunctuationPairsSourceSet(stores space for an empty cell)". This value is written in
/// the "Settings" part of the basic configuration file. Adapt It stores this punctuation
/// in the App's m_twopunctPairs global string. The application uses the
/// PunctPairsToTwoStrings() and TwoStringsToPunctPairs() functions to manipulate the pairs
/// of punctuation data, punctuation data for the source language used here.
wxString szPunctPairsSrc = _T("PunctuationPairsSourceSet(stores space for an empty cell)");

/// The label that identifies the following string as the application's
/// "PunctuationTwoCharacterPairsSourceSet(ditto)". This value is written in the "Settings"
/// part of the basic configuration file. Adapt It stores this punctuation in the App's
/// m_twopunctPairs global string. The application uses the TwoPunctPairsToTwoStrings() and
/// TwoStringsToTwoPunctPairs() functions to manipulate the pairs of punctuation data,
/// punctuation data for the source language used here.
wxString szTwoPunctPairsSrc = _T("PunctuationTwoCharacterPairsSourceSet(ditto)");

/// The label that identifies the following string as the application's
/// "PunctuationPairsTargetSet(stores space for an empty cell)". This value is written in
/// the "Settings" part of the basic configuration file. Adapt It stores this punctuation
/// in the App's m_twopunctPairs global string. The application uses the
/// PunctPairsToTwoStrings() and TwoStringsToPunctPairs() functions to manipulate the pairs
/// of punctuation data, punctuation data for the target language used here.
wxString szPunctPairsTgt = _T("PunctuationPairsTargetSet(stores space for an empty cell)");

/// The label that identifies the following string as the application's
/// "PunctuationTwoCharacterPairsTargetSet(ditto)". This value is written in the "Settings"
/// part of the basic configuration file. Adapt It stores this punctuation in the App's
/// m_twopunctPairs global string. The application uses the TwoPunctPairsToTwoStrings() and
/// TwoStringsToTwoPunctPairs() functions to manipulate the pairs of punctuation data,
/// punctuation data for the target language used here.
wxString szTwoPunctPairsTgt = _T("PunctuationTwoCharacterPairsTargetSet(ditto)");
#endif

/// The label that identifies the following string encoded number as the application's
/// "StatusBarIsVisible". This value is written in the "Settings" part of the basic
/// configuration file. Adapt It stores this path in the App's m_bStatusBarVisible member
/// variable.
wxString szStatusBarIsVisible = _T("StatusBarIsVisible");

/// The label that identifies the following string encoded number as the application's
/// "ToolBarIsVisible". This value is written in the "Settings" part of the basic
/// configuration file. Adapt It stores this path in the App's m_bToolBarVisible member
/// variable.
wxString szToolBarIsVisible = _T("ToolBarIsVisible");

/// The label that identifies the following string encoded number as the application's
/// "ModeBarIsVisible". This value is written in the "Settings" part of the basic
/// configuration file. Adapt It stores this path in the App's m_bModeBarVisible member
/// variable.
wxString szModeBarIsVisible = _T("ModeBarIsVisible");

/// The label that identifies the following string encoded number as the application's
/// "SuppressWelcome". This value is written in the "Settings" part of the basic
/// configuration file. Adapt It stores this path in the App's m_bSuppressWelcome member
/// variable.
wxString szSuppressWelcome = _T("SuppressWelcome");

/// The label that identifies the following string encoded number as the application's
/// "UsePrefixExportTypeOnFilename". This value is written in the "Settings" part of
/// the basic configuration file. Adapt It stores this value as a boolean TRUE or
/// FALSE in the App's m_bUsePrefixExportTypeOnFilename member variable.
wxString szUsePrefixExportTypeOnFilename = _T("UsePrefixExportTypeOnFilename");

/// The label that identifies the following string encoded number as the application's
/// "UseSuffixExportDateTimeOnFilename". This value is written in the "Settings" part of
/// the basic configuration file. Adapt It stores this value as a boolean TRUE or
/// FALSE in the App's m_bUseSuffixExportDateTimeOnFilename member variable.
wxString szUseSuffixExportDateTimeOnFilename = _T("UseSuffixExportDateTimeOnFilename");

/// The label that identifies the following string encoded number as the application's
/// "UsePrefixExportProjectNameOnFilename". This value is written in the "Settings" part of
/// the basic configuration file. Adapt It stores this value as a boolean TRUE or
/// FALSE in the App's m_bUsePrefixExportProjectNameOnFilename member variable.
wxString szUsePrefixExportProjectNameOnFilename = _T("UsePrefixExportProjectNameOnFilename");

// EDB Toolbar customization
/// Controls the toolbar button size displayed in the toolbar. This can be small (16x16), medium
/// (22x22) or large (32x32). Adapt It stores this value as an enum in the App's m_toolbarSize
/// member variable.
wxString szToolbarSize = _T("ToolbarSize");
/// Controls whether or not labels are displayed below each button in the toolbar. This setting
/// tends to take up a lot of screen real estate, so the default setting is FALSE (0). Adapt It
/// stores this value as a boolean TRUE or FALSE in the App's m_bShowToolbarText member variable.
wxString szShowToolbarText = _T("ShowToolbarText");
/// Controls which buttons are displayed in the toolbar. Adapt It stores this value as an array
/// of boolean in the App's m_bToolbarButtons member variable.
wxString szToolbarButtons = _T("ToolbarButtons");

/// The label that identifies the following string encoded number as the application's
/// "SuppressTargetHighlighting". This value is written in the "Settings" part of the basic
/// configuration file. Adapt It stores this path in the App's
/// m_bSuppressTargetHighlighting member variable.
wxString szSuppressTargetHighlighting = _T("SuppressTargetHighlighting");

/// The label that identifies the following string encoded number as the application's
/// "AutoInsertionsHighlightColor". This value is written in the "Settings" part of the
/// basic configuration file. Adapt It stores this path in the App's
/// m_AutoInsertionsHighlightColor member variable. Adapt It uses the WxColour2Int() and
/// Int2wxColour() helper functions to convert between the integer and wx color enum
/// symbols.
wxString szAutoInsertionsHighlightColor = _T("AutoInsertionsHighlightColor");

/// The label that identifies the following string encoded number as the application's
/// "GuessHighlightColor". This value is written in the "Settings" part of the
/// basic configuration file. Adapt It stores this path in the App's
/// m_GuessHighlightColor member variable. Adapt It uses the WxColour2Int() and
/// Int2wxColour() helper functions to convert between the integer and wx color enum
/// symbols.
wxString szGuessHighlightColor = _T("GuessHighlightColor");

/// The label that identifies the following string encoded number as the application's
/// "UseStartupWizardOnLaunch". This value is written in the "Settings" part of the basic
/// configuration file. Adapt It stores this path in the App's m_bUseStartupWizardOnLaunch
/// member variable.
wxString szUseStartupWizardOnLaunch = _T("UseStartupWizardOnLaunch");

/// The label that identifies the following string encoded number as the application's
/// "BackupKnowledgeBase(Boolean)". This value is written in the "Settings" part of the
/// basic configuration file. Adapt It stores this path in the App's m_bAutoBackupKB member
/// variable.
wxString szBackupKBFlag = _T("BackupKnowledgeBase(Boolean)");

/// The label that identifies the following string encoded number as the application's
/// "TimeSpanForDocument - minutes". This value is written in the "Settings" part of the
/// basic configuration file. Adapt It stores this path in the App's m_timeSettings member
/// variable.
wxString szTS_DOC_MINS = _T("TimeSpanForDocument - minutes");

/// The label that identifies the following string encoded number as the application's
/// "TimeSpanForDocument - seconds". This value is written in the "Settings" part of the
/// basic configuration file. Adapt It no longer makes use of the seconds time span value.
wxString szTS_DOC_SECS = _T("TimeSpanForDocument - seconds");

/// The label that identifies the following string encoded number as the application's
/// "TimeSpanForKB - minutes". This value is written in the "Settings" part of the basic
/// configuration file. Adapt It stores this path in the App's m_timeSettings member
/// variable.
wxString szTS_KB_MINS = _T("TimeSpanForKB - minutes");

/// The label that identifies the following string encoded number as the application's
/// "TimeSpanForKB - seconds". This value is written in the "Settings" part of the basic
/// configuration file. Adapt It no longer makes use of the seconds time span value.
wxString szTS_KB_SECS = _T("TimeSpanForKB - seconds");

/// The label that identifies the following string encoded number as the application's
/// "NoAutoSaveFlag(Boolean)". This value is written in the "Settings" part of the basic
/// configuration file. Adapt It stores this path in the App's m_bNoAutoSave member
/// variable.
wxString szNoAutoSaveFlag = _T("NoAutoSaveFlag(Boolean)");

/// The label that identifies the following string encoded number as the application's
/// "DocumentTimeSpanButtonIsON(Boolean)". This value is written in the "Settings" part of
/// the basic configuration file. Adapt It stores this path in the App's m_bIsDocTimeButton
/// member variable.
wxString szIsDocTimeButtonFlag = _T("DocumentTimeSpanButtonIsON(Boolean)");

/// The label that identifies the following string encoded number as the application's
/// "PhraseBoxMovesForSave". This value is written in the "Settings" part of the basic
/// configuration file. Adapt It stores this value in the App's m_nMoves member variable.
wxString szPhraseBoxMoves = _T("PhraseBoxMovesForSave");

/// The label that identifies the following string encoded number as the application's
/// "ColorOfNavigationText". This value is written in the "Settings" part of the basic
/// configuration file. Adapt It stores this path in the App's m_navTextColor member
/// variable. Adapt It uses the WxColour2Int() and Int2wxColour() helper functions to
/// convert between the integer and wx color enum symbols.
wxString szNavTextColor = _T("ColorOfNavigationText");

/// The label that identifies the following string encoded number as the application's
/// "FitWithinWindowFlag(Boolean)". This value is written in the "Settings" part of the
/// basic configuration file. Adapt It no longer uses this variable.
wxString szFitFlag = _T("FitWithinWindowFlag(Boolean)"); // unused as of version 2.4.0

                                                         /// The label that identifies the following string encoded number as the application's
                                                         /// "MarkersWrapStripsFlag(Boolean)". This value is written in the "Settings" part of the
                                                         /// basic configuration file. Adapt It stores this path in the App's m_bMarkerWrapsStrip
                                                         /// member variable.
wxString szMarkerWrapsFlag = _T("MarkersWrapStripsFlag(Boolean)");

/// The label that identifies the following string encoded number as the application's
/// "BackupDocumentFlag". This value is written in the "Settings" part of the basic
/// configuration file. Adapt It stores this path in the App's m_bBackupDocument member
/// variable.
wxString szBackupDocument = _T("BackupDocumentFlag");

// whm added 3Sep10 for user workflow profile support
/// The label that identifies the following string encoded number as the application's
/// "WorkflowProfile". This value is written in the "Settings" part of the basic
/// and project configuration files. Adapt It stores this path in the App's
/// m_nWorkflowProfile member variable.
wxString szWorkflowProfile = _T("WorkflowProfile");

// whm added 15Apr11 for Paratext collaboration support
// The label that identifies the following string encoded number as the application's
// "CollaboratingWithParatext". This value, "1" or "0", is written in the "ProjectSettings" part
/// of the project configuration file.  Adapt It stores this value as a boolean in the App's
// m_bCollaboratingWithParatext member variable.
wxString szCollaboratingWithParatext = _T("CollaboratingWithParatext");

// whm added 15Apr11 for Paratext collaboration support
// The label that identifies the following string encoded number as the application's
// "CollaboratingWithBibledit". This value, "1" or "0", is written in the "ProjectSettings" part
/// of the project configuration file.  Adapt It stores this value as a boolean in the App's
// m_bCollaboratingWithBibledit member variable.
wxString szCollaboratingWithBibledit = _T("CollaboratingWithBibledit");

// whm added 15Apr11 for Paratext/Bibledit collaboration support.
// The label that identifies the following string as the application's
// "CollabProjectForSourceInputs". This value is written in the "ProjectSettings" part
/// of the project configuration file.  Adapt It stores this value as a wxString in the App's
// m_CollabProjectForSourceInputs member variable.
wxString szCollabProjectForSourceInputs = _T("CollabProjectForSourceInputs");

// whm added 15Apr11 for Paratext/Bibledit collaboration support.
// The label that identifies the following string as the application's
// "CollabProjectForTargetExports". This value is written in the "ProjectSettings" part
/// of the project configuration file.  Adapt It stores this value as a wxString in the App's
// m_CollabProjectForTargetExports member variable.
wxString szCollabProjectForTargetExports = _T("CollabProjectForTargetExports");

// whm added 30Jun11 for Paratext/Bibledit collaboration support.
// The label that identifies the following string as the application's
// "CollabProjectForFreeTransExports". This value is written in the "ProjectSettings" part
/// of the project configuration file.  Adapt It stores this value as a wxString in the App's
// m_CollabProjectForFreeTransExports member variable.
wxString szCollabProjectForFreeTransExports = _T("CollabProjectForFreeTransExports");

// whm added 30Jun11 for Paratext/Bibledit collaboration support.
// The label that identifies the following string as the application's
// "CollabAIProjectName". This value is written in the "ProjectSettings" part
/// of the project configuration file.  Adapt It stores this value as a wxString in the App's
// m_CollabAIProjectName member variable.
wxString szCollabAIProjectName = _T("CollabAIProjectName");

// whm added 4Apr12 for Paratext/Bibledit collaboration support.
// The label that identifies the following string as the application's
// "CollaborationEditor". This value is written in the "ProjectSettings" part
/// of the project configuration file.  Adapt It stores this value as a wxString in the App's
// m_collaborationEditor member variable.
wxString szCollaborationEditor = _T("CollaborationEditor");

// whm added 20June2016 for Paratext8 collaboration support.
// The label that identifies the following string as the application's
// "CollarParatextVersionForProject". This value is written in the "ProjectSettings" part
/// of the project configuration file.  Adapt It stores this value as a wxString in the App's
// m_ParatextVersionForProject member variable.
wxString szCollabParatextVersionForProject = _T("CollabParatextVersionForProject");

// whm Note: The following string named szParatextVersionForProject was used in a pre-release
// version to developers. So, to avoid problems we should map any "ParatextVersionForProject"
// project config item label to "ParatextVersionForProject" within the project config read/write
// routines.
wxString szParatextVersionForProject = _T("ParatextVersionForProject");

// whm added 30Jun11 for Paratext/Bibledit collaboration support.
// The label that identifies the following string encoded number as the application's
// "CollabExpectsFreeTrans". This value, "1" or "0", is written in the "ProjectSettings" part
/// of the project configuration file.  Adapt It stores this value as a wxString in the App's
// m_bCollaborationExpectsFreeTrans member variable.
wxString szCollabExpectsFreeTrans = _T("CollabExpectsFreeTrans");

// whm added 27Apr11 for Paratext/Bibledit collaboration support.
// The label that identifies the following string as the application's
// "CollabBookSelected". This value is written in the "ProjectSettings" part
/// of the project configuration file.  Adapt It stores this value as a wxString in the App's
// m_CollabBookSelected member variable.
wxString szCollabBookSelected = _T("CollabBookSelected");

// whm added 27Jul11 for Paratext/Bibledit collaboration support.
// The label that identifies the following string encoded number as the application's
// "CollabByChapterOnly". This value, "1" or "0", is written in the "ProjectSettings" part
/// of the project configuration file.  Adapt It stores this value as a boolean in the App's
// m_bCollabByChapterOnly member variable.
wxString szCollabByChapterOnly = _T("CollabByChapterOnly");

// whm added 27Apr11 for Paratext/Bibledit collaboration support.
// The label that identifies the following string encoded number as the application's
// "CollabChapterSelected". This value is written in the "ProjectSettings" part
/// of the project configuration file.  Adapt It stores this value as a wxString in the App's
// m_CollabChapterSelected member variable.
wxString szCollabChapterSelected = _T("CollabChapterSelected");

// whm added 4Sep11 for Paratext/Bibledit collaboration support.
// The label that identifies the following string as the application's
// "CollabSourceLangName". This value is written in the "ProjectSettings" part
/// of the project configuration file.  Adapt It stores this value as a wxString in the App's
// m_CollabSourceLangName member variable.
wxString szCollabSourceLangName = _T("CollabSourceLangName");

// whm added 4Sep11 for Paratext/Bibledit collaboration support.
// The label that identifies the following string as the application's
// "CollabTargetLangName". This value is written in the "ProjectSettings" part
/// of the project configuration file.  Adapt It stores this value as a wxString in the App's
// m_CollabTargetLangName member variable.
wxString szCollabTargetLangName = _T("CollabTargetLangName");

// whm added 2Feb2017
/// The label that identifies the following string as a composed list of book(s), or book:chapter
/// documents who have been marked to prevent saving changes to Paratext/Bibledit. The label is
/// CollabBooksProtectedFromSavingToEditor and is written to the "ProjectSettings" part
/// of the project configuration file. Adapt It stores this value as a wxString in the App's
/// m_CollabBooksProtectedFromSavingToEditor member variable.
wxString szCollabBooksProtectedFromSavingToEditor = _T("CollabBooksProtectedFromSavingToEditor");

/// The label that identifies the following string encoded number as the application's
/// "CollabDoNotShowMigrationDialogForPT7toPT8". This value, "1" or "0", is written in the
/// "ProjectSettings" part of the project configuration file.  Adapt It stores this value as a
/// boolean in the App's m_bCollabDoNotShowMigrationDialogForPT7toPT8 member variable.
wxString szCollabDoNotShowMigrationDialogForPT7toPT8 = _T("CollabDoNotShowMigrationDialogForPT7toPT8");

/// The label that identifies the following string as an int, either 0 or 1 storing the flag
/// value which indicates whether the "Change Paratext/Bibledit Projects" button is password
/// protected in the "Setup Paratext/Bibledit Collaboration" dialog.
//wxString szCollabSwitchingPasswordProtected = _T("CollabSwitchingPasswordProtected");

/// The label that identifies the following string as a password which can be used to
/// control access to the "Change Paratext/Bibledit Projects" button in the Get Source Text
/// from Paratext/Bibledit Project" dialog. An administrator can set this password via
/// the "Set password for collaboration switching..." button in the "Setup Paratext/Bibledit
/// Collaboration" dialog.
//wxString szCollabSwitchingPassword = _T("CollabSwitchingPassword");

// window position and size

/// The label that identifies the following string encoded number as the application's
/// "TopLeftX". This value is written in the "Settings" part of the basic configuration
/// file. Adapt It stores this value in the App's m_ptViewTopLeft.x member variable.
wxString szTopLeftX = _T("TopLeftX");

/// The label that identifies the following string encoded number as the application's
/// "TopLeftY". This value is written in the "Settings" part of the basic configuration
/// file. Adapt It stores this value in the App's m_ptViewTopLeft.y member variable.
wxString szTopLeftY = _T("TopLeftY");

/// The label that identifies the following string encoded number as the application's
/// "WinSizeCX". This value is written in the "Settings" part of the basic configuration
/// file. Adapt It stores this value in the App's m_szView.x member variable.
wxString szWSizeCX = _T("WinSizeCX");

/// The label that identifies the following string encoded number as the application's
/// "WinSizeCY". This value is written in the "Settings" part of the basic configuration
/// file. Adapt It stores this value in the App's m_szView.y member variable.
wxString szWSizeCY = _T("WinSizeCY");

// restoring earlier doc location

/// The label that identifies the following string encoded number as the application's
/// "LastActiveSequenceNumber". This value is written in the "Settings" part of the basic
/// configuration file. Adapt It stores this value in the App's nLastActiveSequNum member
/// variable.
/// mrh note: as of DocVersion 8, we don't use this any more, but each doc now has an xml field
///  for this value.  But we'll keep this around for a while to smooth the transition from
///  docVersion 7 -> 8.
wxString szLastActiveSequNum = _T("LastActiveSequenceNumber");

/// The label that identifies the following string encoded number as the application's
/// "IsMainWindowMaximized". This value is written in the "Settings" part of the basic
/// configuration file. Adapt It stores this value in the App's m_bZoomed member variable.
wxString szZoomed = _T("IsMainWindowMaximized");

// The label that identifies the following string as the application's
// "CustomWorkFolderPath". This value is written in the "Settings" part of the Project
// configuration file. Adapt It stores this path in the App's m_customWorkFolderPath member
// variable. The contents of this variable are used when the App's boolean member
// m_bLockedCustomWorkFolderPath is TRUE. (The same variable is used when the administrator
// temporarily points Adapt It at a custom work folder location, but we don't track such
// usage because the flag m_bLockedCustomWorkFolderPath is FALSE when that is the case)
wxString szCustomWorkFolderPath = _T("CustomWorkFolderPath");

// The label that identifies the following string as the application's
// "m_bLockedCustomWorkFolderPath" boolean value. This value is written in the "Settings" part
// of the Basic configuration file. Adapt It stores this boolean in the App's
// m_bUseCustomWorkFolderPath member variable. When m_bLockedCustomWorkFolderPath is TRUE,
// the work folder location is taken from the contents of the CustomWorkFolderLocation file
// stored in the default work folder, and assigned to the variable m_customWorkFolderPath.
wxString szLockedCustomWorkFolderPath = _T("LockedCustomWorkFolderPath");

// print margins, etc

/// The label that identifies the following string encoded number as the application's
/// "UseInchesForMeasuring". This value is written in the "Settings" part of the basic
/// configuration file. Adapt It stores this value in the App's m_bIsInches member
/// variable.
wxString szLoEnglishFlag = _T("UseInchesForMeasuring");

/// The label that identifies the following string encoded number as the application's
/// "UsePortraitOrientation". This value is written in the "Settings" part of the basic
/// configuration file. Adapt It stores this value in the App's m_bIsPortraitOrientation
/// member variable.
wxString szUsePortraitOrientation = _T("UsePortraitOrientation");

/// The label that identifies the following string encoded number as the application's
/// "TopPrintMargin". This value is written in the "Settings" part of the basic
/// configuration file. Adapt It stores this value in the App's m_marginTop and
/// m_marginTopMM member variable.
wxString szMarginTop = _T("TopPrintMargin");

/// The label that identifies the following string encoded number as the application's
/// "BottomPrintMargin". This value is written in the "Settings" part of the basic
/// configuration file. Adapt It stores this value in the App's m_marginBottom and
/// m_marginBottomMM member variable.
wxString szMarginBottom = _T("BottomPrintMargin");

/// The label that identifies the following string encoded number as the application's
/// "LeftPrintMargin". This value is written in the "Settings" part of the basic
/// configuration file. Adapt It stores this value in the App's m_marginLeft and
/// m_marginLeftMM member variable.
wxString szMarginLeft = _T("LeftPrintMargin");

/// The label that identifies the following string encoded number as the application's
/// "RightPrintMargin". This value is written in the "Settings" part of the basic
/// configuration file. Adapt It stores this value in the App's m_marginRight and
/// m_marginRightMM member variable.
wxString szMarginRight = _T("RightPrintMargin");

/// The label that identifies the following string encoded number as the application's
/// "LastUsedPageWidth". This value is written in the "Settings" part of the basic
/// configuration file. Adapt It stores this value in the App's m_pageWidth and
/// m_pageWidthMM member variable.
wxString szLastPageWidth = _T("LastUsedPageWidth");

/// The label that identifies the following string encoded number as the application's
/// "LastUsedPageLength". This value is written in the "Settings" part of the basic
/// configuration file. Adapt It stores this value in the App's m_pageLength and
/// m_pageLengthMM member variable.
wxString szLastPageLength = _T("LastUsedPageLength");

/// The label that identifies the following string encoded number as the application's
/// "PaperSizeCode". This value is written in the "Settings" part of the basic
/// configuration file. Adapt It stores this value in the App's m_paperSizeCode member
/// variable.
wxString szPaperSizeCode = _T("PaperSizeCode");

/// The label that identifies the following string encoded number as the application's
/// "RTL_Layout". This value is written in the "Settings" part of the basic configuration
/// file. Adapt It stores this value in the App's m_bRTL_Layout member variable.
wxString szRTL_Layout = _T("RTL_Layout");

// support for user-assignable SFM escape char

/// The label that identifies the following string encoded number as the application's
/// "SFMescapeChar". This value is no longer used in Adapt I, but is retained for backward
/// compatibility of configuration files.
wxString szSFMescapechar = _T("SFMescapeChar");

/// The label that identifies the following string encoded number as the application's
/// "SFMafterNewlines". Adapt It stores this value in the App's gbSfmOnlyAfterNewlines
/// member variable.
wxString szSFMafterNewlines = _T("SFMafterNewlines");

#ifdef _RTL_FLAGS
// NR version support

/// The label that identifies the following string encoded number as the application's
/// "SourceIsRTL". Adapt It stores this value in the App's m_bSrcRTL member  variable.
/// The label is used only for the Unicode version.
wxString szRTLSource = _T("SourceIsRTL");

/// The label that identifies the following string encoded number as the application's
/// "TargetIsRTL". Adapt It stores this value in the App's m_bTgtRTL member  variable.
/// The label is used only for the Unicode version.
wxString szRTLTarget = _T("TargetIsRTL");

/// The label that identifies the following string encoded number as the application's
/// "NavTextIsRTL". Adapt It stores this value in the App's m_bNavTextRTL member  variable.
/// The label is used only for the Unicode version.
wxString szRTLNavText = _T("NavTextIsRTL");
#endif

// support for auto-capitalization

/// The label that identifies the following string as the application's
/// "LowerCaseSourceLanguageChars". This value is written in the "Settings" part of the
/// basic configuration file. Adapt It stores this value in the App's m_srcLowerCaseChars
/// global variable.
wxString szLowerCaseSourceChars = _T("LowerCaseSourceLanguageChars");

/// The label that identifies the following string as the application's
/// "UpperCaseSourceLanguageChars". This value is written in the "Settings" part of the
/// basic configuration file. Adapt It stores this value in the App's m_srcUpperCaseChars
/// global variable.
wxString szUpperCaseSourceChars = _T("UpperCaseSourceLanguageChars");

/// The label that identifies the following string as the application's
/// "LowerCaseTargetLanguageChars". This value is written in the "Settings" part of the
/// basic configuration file. Adapt It stores this path in the App's m_tgtLowerCaseChars
/// global variable.
wxString szLowerCaseTargetChars = _T("LowerCaseTargetLanguageChars");

/// The label that identifies the following string as the application's
/// "UpperCaseTargetLanguageChars". This value is written in the "Settings" part of the
/// basic configuration file. Adapt It stores this value in the App's m_tgtUpperCaseChars
/// global variable.
wxString szUpperCaseTargetChars = _T("UpperCaseTargetLanguageChars");

/// The label that identifies the following string as the application's
/// "LowerCaseGlossLanguageChars". This value is written in the "Settings" part of the
/// basic configuration file. Adapt It stores this value in the App's m_glossLowerCaseChars
/// global variable.
wxString szLowerCaseGlossChars = _T("LowerCaseGlossLanguageChars");

/// The label that identifies the following string as the application's
/// "UpperCaseGlossLanguageChars". This value is written in the "Settings" part of the
/// basic configuration file. Adapt It stores this value in the App's m_glossUpperCaseChars
/// global variable.
wxString szUpperCaseGlossChars = _T("UpperCaseGlossLanguageChars");

/// The label that identifies the following string encoded value as the application's
/// "AutoCapitalizationFlag". This value is written in the "Settings" part of the basic
/// configuration file. Adapt It stores this value in the App's gbAutoCaps global variable.
wxString szAutoCapitalization = _T("AutoCapitalizationFlag");

/// The label that identifies the following string encoded value as the application's
/// "UseSourceWordBreak" boolean choice. This value is written in the "Settings" part of the
/// project configuration file. It is stored in the App's m_bUseSrcWordBreak boolean
/// member variable.
wxString szUseSourceWordBreak = _T("UseSourceWordBreakFlag");

/// The label that identifies the following string encoded value as the application's
/// m_bForceVerseSectioning boolean choice. This value is written in the project
/// configuration file, and is settable from the Administrator menu
wxString szForceVerseSectioning = _T("ForceVerseSectioning");

/// The label that identifies the following string encoded value as the application's
/// "FreeTranslationUsesZWSP" boolean choice. This value is written in the "Settings" part of
/// the project configuration file. It is stored in the App's m_bFreeTransUsesZWSP boolean
/// member variable.
wxString szFreeTranslationUsesZWSP = _T("FreeTranslationUsesZWSPFlag");

/// The label that identifies the following string encoded value as the application's
/// "SourceHasUpperCaseAndLowerCase". This value is written in the "Settings" part of the
/// basic configuration file. Adapt It stores this value in the App's gbSrcHasUcAndLc
/// global variable.
wxString szSrcHasUcAndLc = _T("SourceHasUpperCaseAndLowerCase");// added in wx version
                                                                // for Case page simplification

                                                                // version 3.x support for USFM and SFM Filtering

                                                                /// The label that identifies the following string encoded value as the application's
                                                                /// "UseSFMarkerSet". This value is written in the "Settings" part of the basic
                                                                /// configuration file. Adapt It stores this value in the App's gProjectSfmSetForConfig
                                                                /// global variable.
wxString szUseSFMarkerSet = _T("UseSFMarkerSet");

/// The label that identifies the following string encoded value as the application's
/// "AutoOpenPhraseBoxTranslationsList". This value is written in the "Settings" part of the
/// project configuration file. Adapt It stores this value in the App's
/// m_bAutoOpenPhraseboxOnLanding member.
// whm 17Jul2018 removed check box to auto-open dropdown on arrival at location with multiple translations
// This checkbox was mainly added as a temporary option due to problems with the wxOwnerDrawnComboBox
// derived control - now fixed.
// The following szAutoOpenPhraseBoxTranslationsList is still provided so the
// GetProjectSettingsConfiguration() function can recognize, but ignore a config
// file that might have the no-longer-used "AutoOpenPhraseBoxTranslationsList"
// settings value.
wxString szAutoOpenPhraseBoxTranslationsList = _T("AutoOpenPhraseBoxTranslationsList");

/// The label that identifies the following string encoded value as the application's
/// "UsfmOnly". This value is written in the "Settings" part of the basic configuration
/// file. Adapt It stores this value in the App's gProjectSfmSetForConfig global enum
/// variable.
wxString szUsfmOnly = _T("UsfmOnly");

/// The label that identifies the following string encoded value as the application's
/// "PngOnly". This value is written in the "Settings" part of the basic configuration
/// file. Adapt It stores this value in the App's gProjectSfmSetForConfig global enum
/// variable.
wxString szPngOnly = _T("PngOnly");

/// The label that identifies the following string encoded value as the application's
/// "UsfmAndPng". This value is written in the "Settings" part of the basic configuration
/// file. Adapt It stores this value in the App's gProjectSfmSetForConfig global enum
/// variable.
wxString szUsfmAndPng = _T("UsfmAndPng");

/// The label that identifies the following string encoded value as the application's
/// "UseFilterMarkers". This value is written in the "Settings" part of the basic
/// configuration file. Adapt It stores this value in the App's
/// gProjectFilterMarkersForConfig global variable.
wxString szUseFilterMarkers = _T("UseFilterMarkers");

/// The label that identifies the following string encoded value as the application's
/// "ChangeFixedSpaceToRegularSpace". This value is written in the "Settings" part of the
/// basic configuration file. Adapt It stores this value in the App's
/// m_bChangeFixedSpaceToRegularSpace global variable.
wxString szChangeFixedSpaceToRegSpace = _T("ChangeFixedSpaceToRegularSpace");

// version 2.4.0 support for user-defined font size in dialogs The label that identifies
// the following string encoded value as the application's "FontSizeForDialogs(points)".
// This value is written in the "Settings" part of the basic configuration file. Adapt It
// stores this value in the App's m_dialogFontSize global variable.
wxString szFontSizeForDialogs = _T("FontSizeForDialogs(points)");

/// The label that identifies the following string encoded value as the application's
/// "FontSizeForRetranslationDialogs(points)". This value is written in the project
/// configuration file AI-ProjectConfiguration.aic. Adapt It stores this value in the App's
/// m_nRetransDlg_FontSize global variable.
wxString szFontSizeForRetransDialog = _T("FontSizeForRetranslationDialogs(points)");

// support for named Bible book folders (plus "Other Texts" catchall folder) for storing
// docs The label that identifies the following string encoded value as the application's
// "BookModeFlag". This value is written in the "Settings" part of the basic configuration
/// file. Adapt It stores this value in the App's m_bBookMode global variable.
wxString szBookMode = _T("BookModeFlag");

/// The label that identifies the following string encoded value as the application's
/// "BookIndexValue". This value is written in the "Settings" part of the basic
/// configuration file. Adapt It stores this value in the App's m_bBookMode global
/// variable.
wxString szBookIndex = _T("BookIndexValue");

// BEW 30Apr10, this flag is deprecated. We read it but do nothing with it, and no longer
// write it in a project config file
wxString szSaveAsXML = _T("SaveAsXML");

// rde: added support for calling EncConverters to pre-process a target word whm: the
// followng three wxString values can remain defined whether or not the USE_SIL_CONVERTERS
// define is set:

/// The label that identifies the following string encoded value as the application's
/// "SilConverterName". This value is written in the "Settings" part of the basic
/// configuration file. Adapt It stores this value in the App's m_strSilEncConverterName
/// global variable.
wxString szSilConverterName = _T("SilConverterName"); // string

                                                      /// The label that identifies the following string encoded value as the application's
                                                      /// "SilConverterDirectionForward". This value is written in the "Settings" part of the
                                                      /// basic configuration file. Adapt It stores this value in the App's
                                                      /// m_bSilConverterDirForward global variable.
wxString szSilConverterDirForward = _T("SilConverterDirectionForward");   // bool

                                                                          /// The label that identifies the following string encoded value as the application's
                                                                          /// "SilConverterNormalizeOutput". This value is written in the "Settings" part of the
                                                                          /// basic configuration file. Adapt It stores this value in the App's
                                                                          /// m_eSilConverterNormalizeOutput global variable.
wxString szSilConverterNormalize = _T("SilConverterNormalizeOutput");

/// The label that identifies the following string as a password which can be used to make
/// the Administrator menu become visible at the end of the menu bar. (A checkbox in the
/// View tab of Preferences is where an administrator can request the menu be shown or hid)
wxString szAdministratorPassword = _T("AdministratorPassword");

/// The label that identifies the following string encoded number as the application's
/// "UseAdaptationsGuesser". Adapt It stores this value in the App's m_bUseAdaptationsGuesser
/// member  variable.
wxString szUseAdaptationsGuesser = _T("UseAdaptationsGuesser");

/// The label that identifies the following string encoded number as the application's
/// "GuessingLevel". Adapt It stores this value in the App's m_nGuessingLevel
/// member  variable.
wxString szGuessingLevel = _T("GuessingLevel");

/// The label that identifies the following string encoded number as the application's
/// "AllowGuesserOnUnchangedCCOutput". Adapt It stores this value in the App's
/// m_bAllowGuesserOnUnchangedCCOutput member variable.
wxString szAllowCConUnchangedGuesserOutput = _T("AllowCConUnchangedGuesserOutput");
//  BEW 10Jun13, for version 6.4.3, due to a misunderstanding on my part, I altered the
//  internal code to be m_bAllowCConUnchangedGuesserOutput so as to match the label above,
//  but the label above was misleading. I should have just altered the label. I'm now
//  fixing this: henceforth the internal variable will be
//  m_bAllowGuesseronUnchangedCCOutput, and the label to be used for subsequent project
//  config file writes will be the one below.
wxString szAllowGuesseronUnchangedCCOutput = _T("AllowGuesseronUnchangedCCOutput");

/// The label that identifies the following string encoded number as the application's
/// maximum number of allowed guessed prefixes per word. Adapt It stores this value in
/// the App's m_iMaxPrefixes member variable.
wxString szGuesserMaxPrefixes = _T("GuesserMaxPrefixes(99 is 'no limit')");

/// The label that identifies the following string encoded number as the application's
/// maximum number of allowed guessed suffixes per word. Adapt It stores this value in
/// the App's m_iMaxSuffixes member variable.
wxString szGuesserMaxSuffixes = _T("GuesserMaxSuffixes(99 is 'no limit')");

// Note: ecDriverDynamicLibrary.Load() is called in OnInit()
wxDynamicLibrary ecDriverDynamicLibrary;
wxDynamicLibrary ptSharedDynamicLibrary;

#if defined(__WXMSW__)
const wxChar *LIB_NAME = _T("ECDriver.dll");
#elif defined(__UNIX__)
const wxChar *LIB_NAME = _T("/lib/ecdriver.so");
#else
#error "Cannot load wxDynamicLibrary ecdriver on this platform.";
#endif

const wxChar *PT_LIB_NAME = _T("ParatextShared.dll");

// whm Note: constants must be static and integral types to be initialized within a class
const wxChar *FUNC_NAME_EC_IS_INSTALLED = _T("IsEcInstalled");
const wxChar *FUNC_NAME_EC_SELECT_CONVERTER_AW = _T("EncConverterSelectConverter");
const wxChar *FUNC_NAME_EC_INITIALIZE_CONVERTER_AW = _T("EncConverterInitializeConverter");
const wxChar *FUNC_NAME_EC_CONVERTER_DESCRIPTION_AW = _T("EncConverterConverterDescription");
const wxChar *FUNC_NAME_EC_CONVERT_STRING_AW = _T("EncConverterConvertString");

/// The label that identifies the following string encoded value as the application's
/// "DoAdaptingBeforeGlossing_InVerticalEdit". This value is written in the
/// "ProjectSettings" part of the basic configuration file. Adapt It stores this value in
/// the App's gbAdaptBeforeGloss global variable.
wxString szDoAdaptingBeforeGlossing_InVerticalEdit =
_T("DoAdaptingBeforeGlossing_InVerticalEdit");   // bool -- for vertical edit settings

/* this following code from AdminMoveOrCopy class is tested below at lines 5470++
wxString BuildChangedFilenameForCopy(wxString* pFilename);
wxString BuildChangedFilenameForCopy(wxString* pFilename)
{
wxString newFilename = _T("");
//wxFileName fn(m_strDestFolderPath,*pFilename);
wxFileName fn(*pFilename);
wxString extn = _T("");
bool bHasExtension = FALSE;
if (fn.HasExt())
{
extn = fn.GetExt();
bHasExtension = TRUE; // to handle when only the . of an extension is present
}
wxString name = fn.GetName();
wxString reversed = MakeReverse(name); // our utility from helpers.cpp
// look for ")d...d(" at the start of the reversed string, where d...d is one or more
// digits; we want to get the digit(s), convert to int, increment by 1, convert back
// to digits, and build the new string with (n) at the end where n is the new larger
// value. However, mostly no such end string is present, in which case we can just
// create a name with "(2)" at the end immediately.
wxString shortname;
wxChar aChar = reversed.GetChar(0);
wxString ending = _T("");
if (aChar == _T(')'))
{
// we've got a filename with the name part in the form name(n) where n is one or
// more digits (or at least we'll assume so)
ending = aChar;
shortname = reversed.Mid(1);
// get the digits -- look for matching '(', if not found, just add "(2)" as below,
// but if found, the characters up to that point should be the digit string we want
int offset = shortname.Find(_T('('));
if (offset == wxNOT_FOUND)
{
newFilename = name + _T("(2)");
newFilename += _T(".") + extn;
}
else
{
wxString digitStr = shortname.Left(offset);
shortname = shortname.Mid(offset); // this is now "(reversednamepart"
// reverse digitStr, to make it normal order
digitStr = MakeReverse(digitStr);
// convert digitStr to an unsigned long
unsigned long value;
bool bConvertedOK = digitStr.ToULong(&value);
if (!bConvertedOK)
{
// it wasn't a valid digit string, so make a (2) at end of original name
newFilename = name + _T("(2)");
newFilename += _T(".") + extn;
}
else
{
// it converted correctly, so bump the value by 1 and rebuild the new
// string's output form
value++;
digitStr.Printf(_T("%d"),value);
// now reverse it again
digitStr = MakeReverse(digitStr);
// prepend to shortname
shortname = digitStr + shortname;
// add the ending
shortname = ending + shortname; // remember this is still reversed!
// now reverse it back to natural order
shortname = MakeReverse(shortname);
newFilename = shortname + _T(".") + extn;
}
}
}
else
{
// assume it is a normal filename with no (n) on the end
newFilename = name + _T("(2)");
newFilename += _T(".") + extn;
}
return newFilename;
}
*/

/////////////////////////////////////////////////////////////////////////////
// CAdapt_ItApp construction

// initialize static class variable
bool CAdapt_ItApp::bLookAheadMerge = FALSE;

/// **** DO NOT PUT INITIALIZATIONS IN THE APP'S CONSTRUCTOR *****
/// **** ALL INITIALIZATIONS SHOULD BE DONE IN THE APP'S OnInit() METHOD *****
CAdapt_ItApp::CAdapt_ItApp()
{
    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    // !!! NOTE: DO NOT PLACE ANY APPLICATION INITIALIZATIONS HERE IN THE APP's
    // CONSTRUCTOR!!! wxWidgets versions subsequent to 2.4.2 call this constructor much
    // earlier than version 2.4.2 and previous versions, and any initializations that
    // involve the wxWidgets library especially cannot be guaranteed to be available for
    // initialization here. Instead, DO ALL INITIALIZATION in the App's OnInit() method.
    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
}// end of CAdapt_ItApp constructor

 /// **** ALL CLEANUP SHOULD BE DONE IN THE APP'S OnExit() METHOD ****
CAdapt_ItApp::~CAdapt_ItApp()
{
    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    // !!! NOTE: DO NOT PLACE ANY APPLICATION CLEANUP CODE HERE IN THE APP's DESTRUCTOR!!!
    // wxWidgets versions subsequent to 2.4.2 call this destructor much later than version
    // 2.4.2 and previous versions, and any cleanup that involve the wxWidgets library
    // especially cannot be guaranteed to work here. Instead, DO ALL CLEANUP in the App's
    // OnExit() method.
    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
}

/////////////////////////////////////////////////////////////////////////////////////
/// \return     a pointer to the CMainFrame object
/// \remarks
/// Called from: any part of the source code where we need to obtain a pointer to the
/// application's main frame.
/////////////////////////////////////////////////////////////////////////////////////
CMainFrame* CAdapt_ItApp::GetMainFrame()
{
    wxASSERT(m_pMainFrame != NULL);
    return m_pMainFrame;
}

// whm 15Apr2019 using the App's FilterEvent() to provide a work-around in the event that
// the any drop down list's index error happens. This index error can happen when the drop
// down list has many items in the list, and the list is open near the bottom of the main
// window - usually with some items not visible below the window. The user clicks on a visible
// item in the list, but in an instant the screen/canvas scrolls up a short distande (presumably
// so that the whole list is in view) and the user's mouse click actually registers on a list
// item farther down in the list. This FilterEvent() detects a wxEVT_LEFT_DOWN mouse event
// made on the drop down list and sets the App's global m_nDropDownClickedItemIndex to the
// index of the actual item that the user intended to click on, so that the wrong index
// and list selection can be detected and corrected in the Adapt_ItCanvas::OnListBoxItemSelected()
// handler.
int CAdapt_ItApp::FilterEvent(wxEvent & event)
{
    const wxEventType t = event.GetEventType();
    if (m_pTargetBox != NULL)
    {
        // whm note: I tried catching the wxEVT_LEFT_UP event, but that is too late, the
        // index sel and str are already wrong by that time, so we have to intercept the
        // wxEVT_LEFT_DOWN event instead.
        if (t == wxEVT_LEFT_DOWN)
        {
            if (event.GetId() == ID_DROP_DOWN_LIST)
            {
                // The wxEVT_LEFT_DOWN event happened directly on the drop down list, so
                // get the list item index that is under the point where mouse was clicked.
                // GetPosition() gets the point of the mouse click on the dropdown list (screen coords).
                wxPoint point;
                point = ((wxMouseEvent&)event).GetPosition();
                int index = this->m_pTargetBox->GetDropDownList()->HitTest(point);
                // Set the global m_nDropDownClickedItemIndex with the index value, which will be
                // checked in Adapt_ItCanvas::OnListBoxItemSelected() against what propagated through
                // to that handler. If what is propagated through to OnListBoxItemSelected() differs
                // from this m_nDropDownClickedItemIndex, the code there will correct the index and
                // list selection to what it should be.
                m_nDropDownClickedItemIndex = index;
                wxLogDebug("In App's FilterEvent(): Hit test detected dropdown list item index %d was clicked on.",index);
            }
        }
    }
    // Continue processing the event normally as well.
    event.Skip();
    return -1; // Event_Skip;
}

////////////////////////////////////////////////////////////////////////////////////////
/// \return     a wxString representing the path to the base directory which contains
///             all of the localization subdirectories (es, fr, in, ru, zh_TW, etc)
///             which in turn contain LC_MESSAGES and/or .mo localization files
/// \remarks
/// Called from: the App's ChooseInterfaceLanguage().
/// Gets a platform specific absolute path of the directory where we expect to
/// be able to find the 2-letter ("xx"), 3-letter ("xxx"), or 5-letter ("xx_XX")
/// subdirectories that contain (more subdirectories that contain) localization
/// .mo files for Adapt It and/or the wxWidgets library strings. If the directory
/// cannot be determined, or there are no subdirectories of the expected form
/// containing at least one localization .mo file, an empty string is returned.
/// On wxMSW:   "C:\Program Files\Adapt It WX\Languages\ or
///             C:\Program Files\Adapt It WX Unicode\Languages\"
///             which then contain multiple xx or xxx directories which in
///             turn contain an Adapt_It.mo or Adapt_It_Unicode.mo file.
/// On wxGTK:   "/usr/share/locale/" or "/usr/local/share/locale/"
///             which then contain multiple xx or xxx directories which in
///             turn contain a LC_MESSAGES directory which contains an
///             adaptit.mo file.
/// On wxMac:   "AdaptIt.app/Contents/Resources/locale"
///             within the application bundle, which then contain multiple
///             xx or xxx directories which in turn contain a LC_MESSAGES
///             directory which contains an Adapt It.mo file. This
///             is where Poedit puts its localization files, so we'll follow
///             Poedit's example.
/////////////////////////////////////////////////////////////////////////////////////////
wxString CAdapt_ItApp::GetBasePathForLocalizationSubDirectories()
{
    // According to the wx docs:
    // Adapt It looks for its possible interface translations (localizations)
    // at the following locations, depending on the OS:
    //
    // - On Windows, there appears to be no well established location for localization files.
    // For example I looked at two wxWidgets based applications Poedit and Audacity.
    // The Poedit program places its localization files in:
    // "C:\Program Files\Poedit\share\locale\<lang>\LC_MESSAGES\"
    // The Audacity program uses a simpler method, putting its localization files in:
    // C:\Program Files\Audacity\Languages\<lang>.
    // For Windows at least, I like the simplified way that Audacity does it. So, we add a
    // "Languages" subdirectory so that the localization subdirectories and files will
    // be installed at:  "C:\Program Files\Adapt It WX\Languages\" or
    // "C:\Program Files\Adapt It WX Unicode\Languages\" and Adapt It on the Windows port
    // will look there.
    //
    // - On Unix, the localization files are installed in "<prefix>/share/locale" so Adapt
    // It looks for localization <lang> subfolders and files in the /usr/share/locale/
    // subdirectory. The <lang> subfolders have an additional LC_MESSAGES subfolder which
    // contains the adaptit.mo files.
    //
    // - On Mac OS X, localization files are installed in the
    // "<appname>.app/Contents/Resources/locale" bundle subdirectory, so Adapt It looks for
    // localization <lang> subfolders and files in the
    // Adapt It.app/Contents/Resources/locale bundle subdirectory. The <lang> subfolders
    // also have an additional LC_MESSAGES subfolder which contains the Adapt It.mo files.
    // In all cases, the <lang> subdirectory is named with the two (or five) letter short
    // canonical name of the language from the old ISO639 standard. Within these individual
    // <lang> subdirectories, the localization translations are contained in a compiled
    // <appname>.mo file. Additionally there should be a wxWidgets library file called
    // wxstd.mo in the directory if that language has also been localized for the wxWidgets
    // library itself.
    //
    //	// !!! testing only below
    //#if wxCHECK_VERSION(2, 7, 0)
    //	wxString resourcesDir,localizedResourcesDir;
    //	wxString dataDir, localDataDir, documentsDir;
    //	wxString userConfigDir, userDataDir, userLocalDataDir;
    //	wxString executablePath;
    //#ifndef __WXMSW__
    //	wxString installPrefix;
    //#endif
    //	wxStandardPaths stdPaths;
    //	resourcesDir = stdPaths.GetResourcesDir(); // GetResourcesDir() is new with wxWidgets 2.7.0
    //	wxLogDebug(_T("The wxStandardPaths::GetResourcesDir()  = %s"),resourcesDir.c_str());
    //	localizedResourcesDir = stdPaths.GetLocalizedResourcesDir(_T("es")); // GetLocalizedResourcesDir() is new with wxWidgets 2.7.0
    //	wxLogDebug(_T("The wxStandardPaths::GetLocalizedResourcesDir(_T(\"es\")) = %s"),localizedResourcesDir.c_str());
    //	dataDir = stdPaths.GetDataDir();
    //	wxLogDebug(_T("The wxStandardPaths::GetDataDir() = %s"),dataDir.c_str());
    //	localDataDir = stdPaths.GetLocalDataDir();
    //	wxLogDebug(_T("The wxStandardPaths::GetLocalDataDir() = %s"),localDataDir.c_str());
    //	documentsDir = stdPaths.GetDocumentsDir();
    //	wxLogDebug(_T("The wxStandardPaths::GetDocumentsDir() = %s"),documentsDir.c_str());
    //	userConfigDir = stdPaths.GetUserConfigDir();
    //	wxLogDebug(_T("The wxStandardPaths::GetUserConfigDir() = %s"),userConfigDir.c_str());
    //	userDataDir = stdPaths.GetUserDataDir();
    //	wxLogDebug(_T("The wxStandardPaths::GetUserDataDir() = %s"),userDataDir.c_str());
    //	userLocalDataDir = stdPaths.GetUserLocalDataDir();
    //	wxLogDebug(_T("The wxStandardPaths::GetUserLocalDataDir() = %s"),userLocalDataDir.c_str());
    //	executablePath = stdPaths.GetExecutablePath();
    //	wxLogDebug(_T("The wxStandardPaths::GetExecutablePath() = %s"),executablePath.c_str());
    //#ifndef __WXMSW__
    //	installPrefix = stdPaths.GetInstallPrefix();
    //	wxLogDebug(_T("The wxStandardPaths::GetInstallPrefix() = %s"),installPrefix.c_str());
    //#endif
    //#endif // #if wxCHECK_VERSION(2, 7, 0)
    // Test results: The wxStandardPaths::GetLocalizedResourcesDir() function returns the
    // folder we want on each platform. Note: for Debug builds, the
    // GetLocalizedResourcesDir() actually returns the parent directory of the directory in
    // which the application actually exists (on Windows at least).

    // The global m_executingAppPathName contains the application name, but I only need the
    // executable name part so I'll use the built-in wxApp function GetAppName() instead.
    wxString appName;
    appName = GetAppName();

    // Determine the path to the localization subdirectory where any localization
    // subdirectories would be located.
    // Note: Our function FindAppPath() determined the most likely path where the Adapt It
    // executable program is located and stored that path in m_appInstallPathOnly.
    wxString localizationFilePath;
    wxString pathToLocalizationFolders;
#ifdef __WXMAC__
    // On the Mac appName is "Adapt It"
    // Set a suitable default localizationFilePath for the Mac.
    //
    // Make path to the Resources folder be a combination of the path to the executable modified by
    // the relative path from the executable to the Resources/locale folder. The path to the executable
    // during UnicodeDebug on my MacBook is this:
    // "/Users/wmartin/subversion/adaptit/bin/mac/build/UnicodeDebug/Adapt It.app/Contents/MacOS/Adapt It"
    // where the last "Adapt It" represents the actual executable file's name. From the MacOS folder (where
    // the executable resides) to the Resources folder requires the path augmented by:
    // "/../Resources/locale". The combined path to find the help file would then be:
    // "/Users/wmartin/subversion/adaptit/bin/mac/build/UnicodeDebug/Adapt It.app/Contents/MacOS/Adapt
    // It/../Resources/locale" which is programmatically represented by:
    localizationFilePath = m_appInstallPathOnly + _T("/../Resources/locale"); // the path separator is added by the caller
                                                                              //wxFileName fn(localizationFilePath);
                                                                              //localizationFilePath = fn.Normalize();
    pathToLocalizationFolders = localizationFilePath;
#endif

#if defined(__WXGTK__)
    // On Linux appName is "adaptit"
    // Set a suitable default localizationFilePath for Linux.
    // There does not appear to be a wxStandardPaths method which gives us the path for locating the
    // <lang> localization subdirectories so we'll just hard code it for Ubuntu Linux.
    // Note: The actual full path and name for a given <lang> is "/usr/share/locale/<lang>/LC_MESSAGES/adaptit.mo"
    // or "/usr/local/share/locale/<lang>/LC_MESSAGES/adaptit.mo" depending on the value of m_PathPrefix
    localizationFilePath = m_PathPrefix + _T("/share/locale");
    pathToLocalizationFolders = localizationFilePath;
#endif //__WXGTK__

#ifdef __WXMSW__
    // Windows uses the m_appInstallPathOnly
    localizationFilePath = m_appInstallPathOnly; //m_setupFolder;
    if (wxDir::Exists(localizationFilePath + PathSeparator + _T("Languages")))
    {
        pathToLocalizationFolders = localizationFilePath + PathSeparator + _T("Languages");
    }
    else
    {
        pathToLocalizationFolders = localizationFilePath;
    }
#endif
    wxLogDebug(_T("pathToLocalizationFolders = %s"), pathToLocalizationFolders.c_str());
    wxFileName fn(pathToLocalizationFolders);
    // whm 22Sep2022 added explicit flags to Normalize() to avoid gcc warning
    //fn.Normalize();
    fn.Normalize(wxPATH_NORM_DOTS | wxPATH_NORM_ABSOLUTE | wxPATH_NORM_TILDE);
    return pathToLocalizationFolders;
}

////////////////////////////////////////////////////////////////////////////////////////
/// \return     a wxString representing the absolute path to the platform specific
///             .mo localization file that contains the compiled localization
///             strings for the langCode language interface.
/// \param      langCode -> the 2 or 3-letter ISO 639 code used at the base level
///             of the localization directory structure and under which the .mo
///             localization file should be found
/// \remarks
/// Called from:
/// Gets the platform appropriate absolute path for the .mo
/// localization file for a given 2 or 3-letter language code
/// parameter langCode.
/// Examples using the tpi language code:
/// On wxMSW:   "C:\Program Files\Adapt It WX\Languages\tpi\Adapt_It.mo or
///             C:\Program Files\Adapt It WX Unicode\Languages\tpi\Adapt_It_Unicode.mo"
/// On wxGTK:   "/usr/share/locale/tpi/LC_MESSAGES/adaptit.mo"
///     or      "/usr/local/share/locale/tpi/LC_MESSAGES/adaptit.mo"
/// On wxMac:  "Adapt It.app/Contents/Resources/locale/tpi/LC_MESSAGES/Adapt It.mo"
///    [within the bundle subdirectory]. This is where Poedit puts
///    its localization files, so we'll follow Poedit's example.
/// See the related function GetBasePathForLocalizationSubDirectories()
/////////////////////////////////////////////////////////////////////////////////////////
wxString CAdapt_ItApp::GetLocalizationMoFilePath(wxString langCode)
{
    wxString appName;
    appName = GetAppName();
    // Get the platform specific base path (absolute) for the initial part of
    // the path.
    wxString moFileAbsolutePath;
    wxString basePath;
    basePath = GetBasePathForLocalizationSubDirectories();
    // Now augment the base path with the platform specific remaining path
    // part that points to the specific language .mo file used for the
    // langCode localization
#ifdef __WXMAC__
    moFileAbsolutePath = basePath + PathSeparator + langCode + PathSeparator + _T("LC_MESSAGES") + PathSeparator + appName + _T(".mo");
#endif

#if defined(__WXGTK__)
    moFileAbsolutePath = basePath + PathSeparator + langCode + PathSeparator + _T("LC_MESSAGES") + PathSeparator + appName + _T(".mo");
#endif

#ifdef __WXMSW__
    moFileAbsolutePath = basePath + PathSeparator + langCode + PathSeparator + appName + _T(".mo");
#endif
    return moFileAbsolutePath;
}

////////////////////////////////////////////////////////////////////////////////////////
/// \return     a wxString representing the path to the directory which contains the XML
///             control files AI_USFM.xml and books.xml
/// \remarks
/// Called from: the App's OnInit();
/// Gets the path where we expect to find the AI_USFM.xml, AI_UserProfiles.xml, books.xml,
/// curl-ca-bundle.ctr, iso639-1codes.txt and aiDefault.css files. Adapt It reads and
/// parses the xml files at startup and accessed the other files for certain features in
/// the app. The css file isn't parsed, it's eventually just copied to the work folder. If
/// the directory cannot be determined an empty string is returned.
////////////////////////////////////////////////////////////////////////////////////////
wxString CAdapt_ItApp::GetDefaultPathForXMLControlFiles()
{
    // Adapt It looks for its possible interface translations (localizations)
    // at the following locations, depending on the OS:
    // - On Windows, there appears to be no well established location for XML control files.
    // For Windows these XML files will be installed together with the executable program at:
    // "C:\Program Files\Adapt It WX\ or C:\Program Files\Adapt It WX Unicode\"
    // and Adapt It on the Windows port will look there.
    // On Linux: "/usr/share/adaptit/" or "/usr/local/share/adaptit/" depending on the
    //           value of m_PathPrefix [adaptit here is the name of a directory]
    // - On Mac OS X, localization files are installed in the "<appname>.app/Contents/Resources"
    // bundle subdirectory, so Adapt It on the Mac looks for them there.
    //
    // Note: the wxStandardPaths::GetDataDir() could possibly be used for determining this path
    // but, since I'm not sure if it existed before version 2.7.0 of the wxWidgets library, I'll
    // hard code the paths we expect here.

    wxString appName;
    appName = GetAppName();

    wxString pathToXMLFolders;
#ifdef __WXMAC__
    // On the Mac appName is "Adapt It"
    // Set a suitable default path for the xml files on the Mac.
    pathToXMLFolders += m_appInstallPathOnly;
    pathToXMLFolders += _T("/../Resources"); // the path separator is added by the caller
#endif

#if defined(__WXGTK__)
                                             // On Linux appName is "adaptit"
                                             // Set a suitable default path for the xml files on Ubuntu Linux.
    pathToXMLFolders = m_PathPrefix + _T("/share/adaptit");
#endif //__WXGTK__

#ifdef __WXMSW__
    // Windows uses the m_appInstallPathOnly, the same place the program file is installed
    pathToXMLFolders = m_appInstallPathOnly;
#endif
    wxLogDebug(_T("pathToXMLFolders = %s"), pathToXMLFolders.c_str());
    wxFileName fn(pathToXMLFolders);
    // whm 22Sep2022 added explicit flags to Normalize() to avoid gcc warning
    //fn.Normalize();
    fn.Normalize(wxPATH_NORM_DOTS | wxPATH_NORM_ABSOLUTE | wxPATH_NORM_TILDE);
    return pathToXMLFolders;
}

////////////////////////////////////////////////////////////////////////////////////////
/// \return     a wxString representing the path to the directory which contains the HTML Help
///             files for the appropriate platform
/// \remarks
/// Called from: the App's OnInit();
/// Gets the path where we expect to find the HTML Help files.
/// If the directory cannot be determined an empty string is returned.
////////////////////////////////////////////////////////////////////////////////////////
wxString CAdapt_ItApp::GetDefaultPathForHelpFiles()
{
    // Adapt It looks for its HTML Help files at the following locations, depending on the OS:
    //
    // - On Windows, there appears to be no well established location for HTML Help files.
    // For Windows the Html Help files will be installed together with the executable program at:
    // "C:\Program Files\Adapt It WX\ or C:\Program Files\Adapt It WX Unicode\"
    // and Adapt It on the Windows port will look there.
    //
    // - On Unix, the Html Help files are installed in "/usr/share/adaptit/help/"
    // or "/usr/local/share/adaptit/help/" which in turn may contain a "common/"
    // subdirectory with .gif and .css files (pointed to by the help files).
    // The .../help/ subdirectory may also contain one or more <lang>/ folders which contain the
    // .html .hhp .hhc help files for Adapt It.
    //
    // - On Mac OS X, Html Help files are installed in the "AdaptIt.app/Contents/SharedSupport/"
    // folder of the bundle subdirectory.
    //
    // Note: the wxStandardPaths class apparently doesn't have a method for locating the help files
    // on the various ports.

    wxString appName;
    appName = GetAppName();
    m_htbHelpFileName = appName + _T(".htb");

    wxString pathToHtmlHelpFiles;
#ifdef __WXMAC__
    // On the Mac appName is "Adapt It"
    // Set a suitable default path for the Html Help files on the Mac.
    //pathToHtmlHelpFiles += appName + _T(".app/Contents/SharedSupport"); // the path separator is added by the caller
    //
    // whm modified 17Feb09 to determine the help file path as a relative adjustment to the absolute
    // path to the actual executable that is running.
    //
    // On the Mac, the .htb help file is in the dmg bundle in a different part of the directory tree from
    // the Adapt It executable. The executable is in <bundle>/Contents/MacOS/ folder but the .htb help file
    // is in the <bundle>/Contents/SharedSupport/ folder. The relative help path from executable to
    // help file then is: "../SharedSupport". The double dot backs up the tree from the MacOS folder to
    // the Contents folder, and then goes into the SharedSupport folder.
    //
    // Make path to the SharedSupport folder be a combination of the path to the executable modified by
    // the relative path from the executable to the SharedSupport folder. The path to the executable
    // during UnicodeDebug on my MacBook is this:
    // "/Users/wmartin/subversion/adaptit/bin/mac/build/UnicodeDebug/Adapt It.app/Contents/MacOS/Adapt It"
    // where the last "Adapt It" represents the actual executable file's name. From the MacOS folder (where
    // the executable resides) to the SharedSupport folder requires the path augmented by:
    // "/../SharedSupport". The combined path to find the help file would then be:
    // "/Users/wmartin/subversion/adaptit/bin/mac/build/UnicodeDebug/Adapt It.app/Contents/MacOS/Adapt
    // It/../SharedSupport" which is programmatically represented by:
    pathToHtmlHelpFiles = m_appInstallPathOnly + _T("/../SharedSupport"); // the path separator is added by the caller
                                                                          //wxFileName fn(pathToHtmlHelpFiles);
                                                                          //pathToHtmlHelpFiles = fn.Normalize();
#endif

#if defined(__WXGTK__)
                                                                          // On Linux appName is "adaptit"
                                                                          // Set a suitable default path for the Html Help files on Ubuntu Linux.
    if (!m_PathPrefix.IsEmpty())
        pathToHtmlHelpFiles = m_PathPrefix + _T("/share/adaptit/help"); // the path separator is added by the caller
    else
        pathToHtmlHelpFiles.Empty();
#endif //__WXGTK__

#ifdef __WXMSW__
    // Windows uses the m_appInstallPathOnly, the same place the program file is installed
    pathToHtmlHelpFiles = m_appInstallPathOnly;
#endif
    wxLogDebug(_T("pathToHtmlHelpFiles = %s m_htbHelpFileName = %s"), pathToHtmlHelpFiles.c_str(), m_htbHelpFileName.c_str());
    wxFileName fn(pathToHtmlHelpFiles);
    // whm 22Sep2022 added explicit flags to Normalize() to avoid gcc warning
    //fn.Normalize();
    fn.Normalize(wxPATH_NORM_DOTS | wxPATH_NORM_ABSOLUTE | wxPATH_NORM_TILDE);
    return pathToHtmlHelpFiles;
}

/////////////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \param      initialPath  -> the path where subdirectories are expected/gathered
///                             into arrayStr
/// \param      arrayStr     <- wxArrayString to receive the list of subdirectories
/// \remarks
/// Called from: the App's PathHas_mo_LocalizationFile() and
/// CChooseLanguageDlg::InitDialog(). Gets a list in the form of a wxStringArray of the
/// subdirectories that exist in the initialPath directory. GetListOfSubDirectories does
/// not empty arrayStr before adding directories to the array, so it is up to the caller to
/// empty the array if needed. If no subdirectories are found arrayStr will not be changed.
/////////////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItApp::GetListOfSubDirectories(const wxString initialPath, wxArrayString &arrayStr)
{
    if (initialPath.IsEmpty())
        return;
    wxString filename, saveDir;
    saveDir = ::wxGetCwd();
    // whm 8Apr2021 reinstated wxLogNull - it had been set below just before the dir.open() command but had been commented out
    wxLogNull logNo;	// eliminates any spurious messages from the system while reading read-only folders/files
    ::wxSetWorkingDirectory(initialPath);
    wxDir dir(initialPath);

//#if defined(_DEBUG)
//	wxLogDebug(_T("%s::%() line $d; ::wxGetCwd()= %s  initialPath= %s   Restores cwd when enumerations done")
//		__FILE__, __FUNCTION__, __LINE__, saveDir.c_str(), initialPath.c_str());
//#endif


    //wxASSERT(dir.IsOpened());
    bool bGotOne = dir.Open(initialPath) && dir.GetFirst(&filename, _T(""), wxDIR_DIRS); // wxDIR_DIRS gets only directories
                                                                                         //wxLogDebug(_T("List of subDirs:"));
    while (bGotOne)
    {
        //wxLogDebug(_T("%s"), filename.c_str());
        arrayStr.Add(filename);
        bGotOne = dir.GetNext(&filename);
    }
    // restore the previous cwd
    ::wxSetWorkingDirectory(saveDir);
    // end of scope for wxLogNull
}

////////////////////////////////////////////////////////////////////////////////////////
/// \return     a wxLanguage value if a language value for fullLangName could be found
///             otherwise wxLANGUAGE_UNKNOWN
/// \param      fullLangName  ->    a wxString representing the common language name
///                                 (Description)
/// \remarks
/// Called from: the App's ChooseInterfaceLanguage().
/// Attempts to get the wxLanguage value represented by the incoming fullLangName value. It
/// first searches the langsKnownToWX[] array comparing the langsKnownToWX[].name
/// (Description) with fullLangName. If it finds a name (Description) matching fullLangName
/// it returns its wxLanguage value. Since the string values coming in fullLangName were
/// derived originally from
////////////////////////////////////////////////////////////////////////////////////////
wxLanguage CAdapt_ItApp::GetLanguageFromFullLangName(const wxString fullLangName)
{
    // Scan through the langsKnownToWX[] array of LangInfo structs for the full language
    // name as found in langsKnownToWX[].fullName. If found return the corresponding
    // langsKnownToWX[].code.
    int ct = 0;
    while (langsKnownToWX[ct].fullName != NULL)
    {
        if (langsKnownToWX[ct].fullName == fullLangName)
        {
            // we've found the shortName in our langsKnownToWX[] array, so return its
            // langsKnownToWX[].code
            return langsKnownToWX[ct].code;
        }
        ct++;
    }
    // If we get here we've searched the whole array and not found dirStr or its prefix in
    // langsKnownToWX[].
    return wxLANGUAGE_UNKNOWN;
}

////////////////////////////////////////////////////////////////////////////////////////
/// \return     a wxLanguage value if the language value for dirStr could be found
///             otherwise wxLANGUAGE_UNKNOWN
/// \param      dirStr        ->    the wxString representing the short name of the
///                                 localization subdirectory
/// \param      fullLangName  <-    a wxString to receive the full language name
///                                 langsKnownToWX[].fullName
/// \remarks
/// Called from: the App's ChooseInterfaceLanguage().
/// Attempts to get the wxLanguage value represented by the incoming dirStr value. It first
/// searches the langsKnownToWX[] array comparing the langsKnownToWX[].shortName with
/// dirStr. If it finds a matching shortName matching dirStr it returns its wxLanguage
/// value and sets the fullLangName to the full language name in langsKnownToWX[].fullName.
/// If it does not find a match on the first run, it checks to see if shortName is of the
/// xx_XX form. If so, it strips off the _XX part of the string and uses just the initial
/// xx part of the canonical short name for comparison with dirStr. If it finds a match for
/// the basic language xx part, we consider that to be an acceptable substitute
/// localization.
/////////////////////////////////////////////////////////////////////////////////////////
wxLanguage CAdapt_ItApp::GetLanguageFromDirStr(const wxString dirStr, wxString &fullLangName)
{
    // whm 28May2018 modified to return in the fullLangName reference parameter the
    // full language name of a custom added language known to Adapt It, for example,
    // "Tok Pisin" or "Swahili" are currently the only two in the langsKnownToAI struct.
    //
    // Scan through the langsKnownToWX[] array of LangInfo structs for the dirStr
    int ct = 0;
    while (langsKnownToWX[ct].fullName != NULL)
    {
        if (langsKnownToWX[ct].shortName == dirStr)
        {
            // we've found the shortName in our langsKnownToWX[] array, so assign
            // fullLangName the string value in langsKnownToWX[ct].fullName
            fullLangName = langsKnownToWX[ct].fullName;
            return langsKnownToWX[ct].code;
        }
        ct++;
    }

    // It may be that dirStr is of the form xx_XX and we might recognize the language, but
    // not the country/region XX. Such a localization would likely be acceptable or at
    // least better than none. So, in case dirStr is of the form xx_XX we search the
    // langsKnownToWX[] array again looking for just the xx part.
    ct = 0;
    while (langsKnownToWX[ct].fullName != NULL)
    {
        wxString str;
        str = langsKnownToWX[ct].shortName;
        if (str.Length() > 2 && str.GetChar(2) == _T('_'))
        {
            str = str.Mid(0, 2);
        }
        if (str == dirStr)
        {
            // we've found the xx part of our shortName in our langsKnownToWX[] array, so
            // assign fullLangName the string value in langsKnownToWX[ct].fullName
            fullLangName = langsKnownToWX[ct].fullName;
            return langsKnownToWX[ct].code;
        }
        ct++;
    }

    // whm 28May2018 added the following block searching in our custom langsKnownToAI[] array
    ct = 0;
    while (langsKnownToAI[ct].fullName != NULL)
    {
        if (langsKnownToAI[ct].shortName == dirStr)
        {
            // we've found the shortName in our langsKnownToWX[] array, so assign
            // fullLangName the string value in langsKnownToWX[ct].fullName
            fullLangName = langsKnownToAI[ct].fullName;
            return langsKnownToAI[ct].code;
        }
        ct++;
    }

    // If we get here we've searched the whole array and not found dirStr or its prefix
    // in langsKnownToWX[].
    return wxLANGUAGE_UNKNOWN;
}

////////////////////////////////////////////////////////////////////////////////////////
/// \return     TRUE if the dirPath represents a subdirectory containing a child or grandchild
///             localization directory(s) which contain an <appName>.mo file,
///             or if the incoming subFolderName parameter is en or en_XX,
///             since English is Adapt It's default localization when no other
///             localization is chosen
/// \param      dirPath         -> the path to look for the <lang> localization subfolder
/// \param      subFolderName = -> the name of a specific subfolder to check for existence
///                                 of a localization .mo file
/// \remarks
/// Called from: the App's LocalizationFilesExist()
/// Determines if dirPath has one or more child or grandchild subfolders which contain an
/// <appName>.mo file.
/// The incoming dirPath would normally be the a path pointing to the "Languages" directory
/// (on Windows); or the /usr/share/locale/ directory on Linux; or
/// /<appName>.app/Contents/Resources directory on the Mac. These directory locations should
/// contain at least one localization <lang> subfolder containing an <appName>.mo file. If
/// subFolderName is not an empty string, this function will do a "strict search" and only
/// return TRUE if a subfolder exists at dirPath with the subFolderName. If subFolderName
/// is an empty string from the caller, the function does not require that a
/// given directory name exist on the local machine, but only checks to see if an <appName>.mo
/// file can be found in at least one such localization subfolder.
/// If subFolderName is a form of en or en_XX the function returns TRUE
/// because English is the default localization for Adapt It when no specific
/// localization is selected.
////////////////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItApp::PathHas_mo_LocalizationFile(wxString dirPath, wxString subFolderName)
{
    if (dirPath.IsEmpty())
        return FALSE;

    wxString appName;
    appName = GetAppName();

    bool bSpecificMoFileExists = FALSE;
    bool bAtLeastOneMoFileExists = FALSE;
    bool bStrictSearch;
    if (!subFolderName.IsEmpty())
        bStrictSearch = TRUE;
    else
        bStrictSearch = FALSE;
    bool bFolderNameIsAnEnglishName;
    if (subFolderName == _T("en") || subFolderName.Find(_T("en_")) != wxNOT_FOUND)
    {
        bFolderNameIsAnEnglishName = TRUE;
        // In this case we use the "default" localization of English, so
        // we can return a TRUE value here for the function
        return TRUE;
    }
    else
        bFolderNameIsAnEnglishName = FALSE;

    wxArrayString subDirList;
    subDirList.Clear();
    GetListOfSubDirectories(dirPath, subDirList);

    wxLogNull logNo;	// eliminates any spurious messages from the system while
                        // reading read-only folders/files

    int ct;
    // Scan through all localization folders present on the machine gathering
    // information about the existence of the localization files.
    for (ct = 0; ct < (int)subDirList.GetCount(); ct++)
    {
        bool bHasRegionCode = FALSE;
        bool bNamesMatch = FALSE;	// assume no match unless subFolderName parameter
                                    // value matches this folder name on the
                                    // local machine
                                    // When doing a strict search and this folder name represents a
                                    // non-English localization, determine if this folder is a match
                                    // for the strict folder parameter. A match exists if the2 or 3 letter
                                    // language code matches (ignoring the _XX region part).
                                    // English is the default interface language for Adapt It so there
                                    // won't ever be an en or en_XX localization folder (at least
                                    // not installed by Adapt It), although the subFolderName parameter
                                    // may represent an incoming en or en_XX language. Don't look for a
                                    // match if the incoming folder name code is an English name code of
                                    // some sort.
        if (bStrictSearch && !bFolderNameIsAnEnglishName)
        {
            wxString subDir = subDirList.Item(ct);
            if (subDir.Length() > 2 && subDir[2] == _T('_') && subDir.Length() >= 5)
                bHasRegionCode = TRUE;
            wxString subFldr = subFolderName;
#ifdef __WXMSW__
            // do non-case-sensitive comparison on Windows
            subDir.MakeLower();
            subFldr.MakeLower();
#endif
            // When the language code has a _XX region suffix only compare the
            // prefix language code parts for a match.
            if (bHasRegionCode && subFldr.Mid(0, 2) == subDir.Mid(0, 2))
            {
                bNamesMatch = TRUE;
            }
            else if (subFldr == subDir)
            {
                bNamesMatch = TRUE;
            }
        }

        // Check for the existence of mo file(s) within the structure of
        // this folder on the machine.
        wxString folderName = subDirList.Item(ct);
        dirPath = GetLocalizationMoFilePath(folderName);
        if (wxFileExists(dirPath))
        {
            if (bNamesMatch)
                bSpecificMoFileExists = TRUE;
            bAtLeastOneMoFileExists = TRUE;
        }
    }
    if ((bStrictSearch && bSpecificMoFileExists)
        || (!bStrictSearch && bAtLeastOneMoFileExists))
    {
        return TRUE;
    }
    // if we make it here none were found
    // end of scope for wxLogNull
    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////
/// \return     TRUE if locale and localizations were successfully created,
///             otherwise FALSE
/// \param      shortLangName -> the short (Canonical) name of the language/locale
/// \param      longLangName  -> the long (Description) name of the language/locale
/// \param      pathPrefix    -> the path prefix where localization subfolders
///                              and files are found
/// \remarks
/// Called from: the App's OnInit() and CChooseLanguageDlg::OnOK(). Deletes any existing
/// wxLocale object and creates a new one on the heap assigned to m_pLocale. Adds the
/// pathPrefix to the new locale and calls AddCatalog to load any new localization.
////////////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItApp::InitializeLanguageLocale(wxString shortLangName, wxString longLangName,
    wxString pathPrefix)
{
    // delete any existing locale object
    if (m_pLocale != NULL)
        delete m_pLocale;

    bool bLoadOK = TRUE;
    wxLogNull nolog; // avoid spurious messages from the system
    // whm 28May2018 modified. Changed the third parameter in the wxLocale constructor
    // below to use the "C" locale as default. This prevents an annoying assert message
    // that pops up in wx3.x repeatedly when a non-English localization is set. The assert
    // says,
    //    "You probably called setlocale() directly instead of using wxLocale and now there is a
    //    mismatch between C/C++ and Windows locale.
    //    Things are going to break, please only change locale by creating wxLocale objects to avoid this!"
    // The assert is tripped when each button image is created by wxGetBitmapFromMemory(), due to a problem
    // it has in wx 3.x in determining the decimal point character for the so-called locale mismatches.
#if WXWIN_COMPATIBILITY_2_8
    m_pLocale = new wxLocale(longLangName, shortLangName, _T("C"), TRUE, TRUE);
    // GDLC 9Jul12 Last parameter removed for 2.9.x
#else
    // whm 15May2023 modified the wxLocale() construction parameters to use the default
    // ones for 3rd and 4th parameter by leaving them out. The 3rd defaults to wxEmptyString,
    // and the 4th defaults to TRUE anyway. After wxWidgets-3.1.5, the library doesn't work
    // as it previous did by having _T("C") as a third parameter, but instead the constructor
    // in later versions of wxWidgets will only create the new locale for English/en and ignore
    // any other choice such as Tok Pisin/tpi, or Spanish/es.
    //m_pLocale = new wxLocale(longLangName, shortLangName, _T("C"), TRUE);
    m_pLocale = new wxLocale(longLangName, shortLangName);
#endif
    if (!pathPrefix.IsEmpty())
        m_pLocale->AddCatalogLookupPathPrefix(pathPrefix);
    if (!m_pLocale->AddCatalog(GetAppName()))
    {
        bLoadOK = FALSE;
    }
    if (shortLangName.Find(_T("en_")) == 0 // we have shortLangName with
                                           // en_ at the start of the name
        || (shortLangName.Length() == 2 && shortLangName == _T("en"))) // or,
                                                                       // we have the two-letter name en
    {
        // For our default English locale we don't need a loaded string catalog table, we
        // just use the program strings, so don't check m_pLocale->IsLoaded() for English.
        // whm added 18Sep12. An English localization is always
        // available by default
        bLoadOK = TRUE;
    }
    else
    {
        // For a non-default non-English localization we can check if the catalog is
        // loaded OK
        if (!m_pLocale->IsLoaded(GetAppName()))
        {
            bLoadOK = FALSE;
        }
    }
    return bLoadOK;
}

////////////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \remarks
/// Called from: the App's ProcessUILanguageInfoFromConfig() and ChangeUILanguage(). Stores
/// the user's choice of interface language (using the members of the CurrLocalizationInfo
/// struct) in the global configuration m_pConfig file (\Users\<user>\AppData\Roaming\Adapt_It_WX.ini
/// on Windows, or in a hidden file named .Adapt_It_WX in the user's folder on Linux/Mac.
////////////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItApp::SaveCurrentUILanguageInfoToConfig()
{
    // whm 8Dec11 revised to no longer store the ui_language_path_unicode or ui_language_path
    // This function uses the data currently in the global struct currLocalizationInfo

    wxLogNull logNo; // avoid spurious messages from the system

                     // save current CurrLocalizationInfo struct's member information in m_pConfig
                     // settings file
    wxString oldPath = m_pConfig->GetPath(); // is always absolute path
    m_pConfig->SetPath(_T("/Settings"));
    m_pConfig->Write(_T("ui_language"), (long)currLocalizationInfo.curr_UI_Language);
    m_pConfig->Write(_T("ui_language_code"), currLocalizationInfo.curr_shortName);
    m_pConfig->Write(_T("ui_language_name"), currLocalizationInfo.curr_fullName);
#ifdef _UNICODE
    m_pConfig->Write(_T("ui_language_path_unicode"), currLocalizationInfo.curr_localizationPath);
#else
    m_pConfig->Write(_T("ui_language_path"), currLocalizationInfo.curr_localizationPath);
#endif

#ifdef _DEBUG
    wxLogDebug(_T(
        "Writing to m_pConfig:\n   curr_UI_Language = %d\n   curr_shortName = %s\n   curr_fullName = %s\n   curr_localizationPath = %s"),
        currLocalizationInfo.curr_UI_Language,
        currLocalizationInfo.curr_shortName.c_str(),
        currLocalizationInfo.curr_fullName.c_str(),
        currLocalizationInfo.curr_localizationPath.c_str());
#endif
    m_pConfig->Flush(); // write now, otherwise write takes place when m_pConfig is destroyed
                        // in OnExit().
                        // restore the oldPath back to what it was on entry
    m_pConfig->SetPath(oldPath);
}

////////////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \remarks
/// Called from: CChooseLanguageDlg::OnOK(). Stores a user defined interface language in
/// the global configuration m_pConfig file (\Users\<user>\AppData\Roaming\Adapt_It_WX.ini
/// on Windows, or in a hidden file named .Adapt_It_WX in the user's folder on Linux/Mac.
/// User defined languages may be stored in the m_pConfig settings keys of the form
/// user_defined_language_n (ANSI version), or user_defined_language_u_n (Unicode
/// version) where n may be an integer from 0 through 8.
/// This function uses the incoming parameter data to create a composite unix-like string
/// delimited by colons (:), and saves this composite string to one of 9 keys in the
/// Registry or hidden settings file. Up to 9 user defined languages can be remembered in
/// this way (for ANSI or Unicode version), using keys with names such as
/// user_defined_language_u_0, user_defined_language_u_1, and so on up through
/// user_defined_language_u_8. This function first checks to see if the incoming user
/// defined language was previously saved in one of the user_defined_language_u_n keys. If
/// the incoming language is not already stored, the first available key that has not yet
/// been assigned a string is used. If all keys are currently filled with user defined
/// language info, the oldest string is replaced by the new language composite string.
////////////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItApp::SaveUserDefinedLanguageInfoStringToConfig(int &wxLangCode,
    const wxString shortName, const wxString fullName, const wxString localizationPath)
{
    // A composite unix string for a user defined language such as Tok Pisin might look like
    // this: 231:tpi:Tok Pisin:
    // The 3 fields of the unix string are parsed using the : delimiter.

    wxString oldPath = m_pConfig->GetPath(); // is always absolute path of what it was on entry
    m_pConfig->SetPath(_T("/Settings"));

    // Take stock of the user_defined_language..._n entry keys the m_pConfig
    // settings file. The keyArray[] array will contain what is stored there.
    int ct;
    const int nKeys = 9;
    wxArrayString keyArray;
    keyArray.Alloc(9);
    wxArrayString foundCodesArray;
    bool bKeysPresent = FALSE;
    bool bAllKeysAssigned = FALSE;
    for (ct = 0; ct < nKeys; ct++)
    {
        wxLogNull logNo; // eliminates spurious message from the system: "Can't read value of
                         // ...Adapt_It_WX\Settings' Error" [valid until end of this block]
        wxString str;
#ifdef _UNICODE
        str << _T("user_defined_language_u_") << ct;
#else
        str << _T("user_defined_language_") << ct;
#endif
        bool valReadOK = TRUE;
        wxString tempStr;
        valReadOK = m_pConfig->Read(str, &tempStr);
        keyArray.Add(tempStr);
        if (valReadOK && keyArray[ct] == _T("[UNASSIGNED]"))
        {
            bAllKeysAssigned = FALSE;
        }
        if (valReadOK && keyArray[ct] != _T("[UNASSIGNED]"))
        {
            bKeysPresent = TRUE;
            int nPos;
            nPos = keyArray[ct].Find(_T(':'));
            wxASSERT(nPos > 0 && nPos <= 3);	// the language code number should represented
                                            // as a three letter string between 231 and 255
            wxString codeStr = keyArray[ct].Left(nPos);
            foundCodesArray.Add(codeStr);
        }
        if (!valReadOK)
        {
            keyArray[ct] = _T("[UNASSIGNED]");	// assign "[UNASSIGNED]" string to any
                                                // keyArray element for which there is no key
        }
        // end of wxLogNull logNo scope
    }

    // Note: our keyArray[] at this point should always contain exactly 9 items regardless
    // of whether some or all of the keys were present when
    // SaveUserDefinedLanguageInfoStringToConfig() was called.

    // The array will get sorted on next run by OnInit()'s
    // ProcessUILanguageInfoFromConfig().

    // Check whether the language represented by our compositeStr has been assigned
    // previously; we don't want to store duplicate user languages, but we do want to
    // update the path part of the string if the user language already exists with a
    // different path.
    // Make a search string of just the shortName and fullName including the
    // surrounding colons.
    int nCodeAssigned = -1;
    wxString subStr;
    subStr << _T(':') << shortName << _T(':') << fullName << _T(':'); // for Tok Pisin
                                                                      // this would be ":tpi:Tok Pisin:"
    bool bAlreadyAssigned = FALSE;
    for (ct = 0; ct < nKeys; ct++)
    {
        if (keyArray[ct].Find(subStr) != -1)
        {
            bAlreadyAssigned = TRUE;
            int nPos;
            nPos = keyArray[ct].Find(_T(':'));
            wxASSERT(nPos > 0 && nPos <= 3); // whm 15May2023 the language code number should be represented as a three letter 
                                            // string between 231 and 880 ??? wxLANGUAGE_USER_DEFINED is now 879 - will assert if nPos > 3
            wxString codeStr = keyArray[ct].Left(nPos);
            nCodeAssigned = wxAtoi(codeStr);
            // Update the path part (it may have been changed by the user).
            wxString tempStr = keyArray[ct];
            int posPath = nPos + (int)subStr.Length();
            tempStr = tempStr.Left(posPath);
            tempStr = tempStr + localizationPath; // use the incoming (possibly
                                                  // updated) path
            keyArray[ct] = tempStr; // update the keyArray item
            break;
        }
    }

    if (nCodeAssigned == -1)
    {
        // This language code was not assigned previously. If other user defined languages
        // were previously assigned, we assign this one the next available number in the
        // sequence. If no other user defined languages were previously assigned, we start
        // with wxLANGUAGE_USER_DEFINED + 1.
        if (bAllKeysAssigned)
        {
            // All 9 available user_defined_language..._n keys have been previously assigned,
            // so we remove the oldest by copying keyArray[1] to keyArray[0], keyArray[2]
            // to keyArray[1], etc., all the way through keyArray[9] copied to keyArray[8].
            // Then we assign make this newest key "[UNASSIGNED]" so that it will get
            // assigned the current language in the routine below (where it will get
            // assigned the next numerical value of 240). This would ordinarily leave the
            // numerical ordering 232 through 240. At the next running of the application
            // the App's OnInit() calls ProcessUILanguageInfoFromConfig() which will detect
            // this situation and will renumber the user defined languages before calling
            // AddLangauge() to add them to the wxLanguage database.
            for (ct = 0; ct < nKeys - 1; ct++)
            {
                keyArray[ct] = keyArray[ct + 1];
            }
            keyArray[nKeys] = _T("[UNASSIGNED]");
            int nCount = (int)foundCodesArray.GetCount();
            wxASSERT(nCount > 0);
            foundCodesArray.Sort();
            wxString highestCodeStr = foundCodesArray[nCount - 1];
            nCodeAssigned = wxAtoi(highestCodeStr) + 1; // get the next number beyond the
                                                        // value for highestCodeStr
                                                        //nCodeAssigned = wxLANGUAGE_USER_DEFINED + 1 + nKeys;
        }
        else if (bKeysPresent)
        {
            // should be at least one slot available
            int nCount = (int)foundCodesArray.GetCount();
            wxASSERT(nCount > 0);
            foundCodesArray.Sort();
            wxString highestCodeStr = foundCodesArray[nCount - 1];
            nCodeAssigned = wxAtoi(highestCodeStr) + 1; // get the next number beyond
                                                        // the value for highestCodeStr
        }
        else
        {
            nCodeAssigned = wxLANGUAGE_USER_DEFINED + 1;
        }
    }
    wxASSERT(nCodeAssigned >= wxLANGUAGE_USER_DEFINED + 1); //&& nCodeAssigned <= 255); // BEW changed as per Bill's recommendation, email 5:56am 16/05/23
    wxLangCode = nCodeAssigned;

    // Assign this language, but only if it has not already been assigned.
    if (!bAlreadyAssigned)
    {
        // Make a composite unix-like string from the parameters
        wxString compositeStr;
        compositeStr << wxLangCode << _T(':') << shortName << _T(':') << fullName
            << _T(':');

        // Assign compositeStr to the first empty array element in keyArray[].
        for (ct = 0; ct < nKeys; ct++)
        {
            // if key is unassigned put the compositeStr there
            if (keyArray[ct] == _T("[UNASSIGNED]"))
            {
                keyArray[ct] = compositeStr;
                break;
            }
        }
    }

    wxLogNull logNo; // avoid spurious messages from the system

                     // Rewrite all 9 keys from keyArray[] back to the m_pConfig settings file. This
                     // is done even if we did not add a compositeStr language. This may have changed
                     // the order, but it will be reordered on next run when OnInit() calls the
                     // ProcessUILanguageInfoFromConfig() function.
    int ctkey;
    for (ctkey = 0; ctkey < nKeys; ctkey++)
    {
        wxString str;
#ifdef _UNICODE
        str << _T("user_defined_language_u_") << ctkey;
#else
        str << _T("user_defined_language_") << ctkey;
#endif
        m_pConfig->Write(str, keyArray[ctkey]);
    }

    m_pConfig->Flush(); // write now, otherwise write takes place when m_pConfig is
                        // destroyed in OnExit().
                        // restore the oldPath back to what is was on entry
    m_pConfig->SetPath(oldPath);
}

/////////////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \remarks
/// Called from: CChooseLanguageDlg::OnOK(). This function searches for a
/// user_defined_language_n or user_defined_language_u_n key using the incoming parameter
/// data. If the key is found, it effectively removes the key value by making it a null
/// string. We also sort the user_defined_language_n (or user_defined_language_u_n) keys
/// and write them back to the m_pConfig settings file.
/////////////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItApp::RemoveUserDefinedLanguageInfoStringFromConfig(const wxString shortName,
    const wxString fullName)
{
    // The string key values associated with the user_defined_language_n keys are a
    // composite unix-like string delimited by colons (:). There are 9 keys in the registry
    // or hidden settings file, so up to 9 user defined languages can be remembered there.
    // A composite unix string for a user defined language such as Tok Pisin might look
    // like this: 231:tpi:Tok Pisin:
    // The 3 fields of the unix string are parsed using the : delimiter.
    //
    // Read any existing strings associated with user_defined_language..._n keys into an array
    // called keyArray[].
    wxString oldPath = m_pConfig->GetPath(); // is always absolute path what it was on entry
    m_pConfig->SetPath(_T("/Settings"));

    int ct;
    const int nKeys = 9;
    wxArrayString keyArray;
    bool bKeysPresent = FALSE;
    for (ct = 0; ct < nKeys; ct++)
    {
        wxLogNull logNo; // eliminates spurious message from the system:
                         // "Can't read value of ...Adapt_It_WX\Settings' Error" [valid
                         // until end of this block]
        wxString str;
#ifdef _UNICODE
        str << _T("user_defined_language_u_") << ct;
#else
        str << _T("user_defined_language_") << ct;
#endif
        bool valReadOK = TRUE;
        wxString tempStr;
        valReadOK = m_pConfig->Read(str, &tempStr);
        keyArray.Add(tempStr);
        if (valReadOK && keyArray[ct] != _T("[UNASSIGNED]"))
        {
            bKeysPresent = TRUE;
        }
        if (!valReadOK)
        {
            keyArray[ct] = _T("[UNASSIGNED]");	// assign "[UNASSIGNED]" string to any
                                                // keyArray element for which there is no key
        }
        // end of wxLogNull logNo scope
    }
    // Note: our keyArray[] at this point should always contain exactly
    // 9 items regardless of whether some or all of the keys were present when
    // SaveUserDefinedLanguageInfoStringToConfig() was called.

    if (!bKeysPresent)
    {
        // there are no user_defined_language_n keys in the m_pConfig settings file,
        // so we have nothing to remove, so we quietly return to the caller.
        return;
    }
    else
    {
        // Scan through our keyArray[] parsing the composite unix-like string elements
        // to find the string key containing the language info that we want to remove.
        // Remove it by assigning the "[UNASSIGNED]" string to the key.
        // Make a search string of just the shortName and fullName including the
        // surrounding colons.
        wxString subStr;
        subStr << _T(':') << shortName << _T(':') << fullName << _T(':'); // for Tok
                                                                          // Pisin this would be ":tpi:Tok Pisin:"
        for (ct = 0; ct < nKeys; ct++)
        {
            if (keyArray[ct].Find(subStr) != -1)
            {
                keyArray[ct] = _T("[UNASSIGNED]");
                break;
            }
        }

        // Note: At the next running of the app, OnInit() calls
        // ProcessUILanguageInfoFromConfig() function which reads all the registry/hidden
        // settings file information and cleans it up if necessary, this cleanup includes
        // reordering of wxLanguage values before calling AddLanguage(), and insuring that
        // any [UNASSIGNED] keys are placed last in the list.

        wxLogNull logNo; // avoid spurious messages from the system

                         // Finally, write the 9 keys back to the registry
        for (ct = 0; ct < nKeys; ct++)
        {
            wxString str;
#ifdef _UNICODE
            str << _T("user_defined_language_u_") << ct;
#else
            str << _T("user_defined_language_") << ct;
#endif
            m_pConfig->Write(str, keyArray[ct]);
        }
    }

    m_pConfig->Flush(); // write now, otherwise write takes place when m_p is destroyed in
                        // OnExit().
                        // restore the oldPath back to what it was on entry
    m_pConfig->SetPath(oldPath);
}


/////////////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \remarks This function builds the complete content for a new default AI_UserProfiles.xml
/// file including the comment at the beginning of the file. It assumes that the caller has
/// created and opened an empty wxTextFile (the textFile parameter) before calling this
/// function. The caller only calls this function in the unlikely case that no
/// AI_UserProfiles.xml file exists at the fullFilePath location used in calling
/// SaveUserProfilesMergingDataToXMLFile().
/// Called from: SaveUserProfilesMergingDataToXMLFile().
/////////////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItApp::BuildUserProfileXMLFile(wxTextFile* textFile)
{
    wxString fileCommentBlock[] =
    {
        _T("<!--"),
        _T("Filename:	AI_UserProfiles.xml"),
        _T("Author: 	Bill Martin"),
        _T("Date Created:	27 August 2010"),
        _T("Last Updated:	24 May 2011, by Bill Martin"),
        _T("Description:	This file contains the user profile definitions and"),
        _T("		attributes for Adapt It's interface menus and settings."),
        _T("		Adapt It reads and parses this AI_UserProfiles.xml file"),
        _T("		when it starts up and when an administrator accesses the"),
        _T("		user workflow profiles dialog. Changes made to"),
        _T("		individual items in that dialog are automatically saved"),
        _T("		back to this file."),
        _T("***********************************************************************"),
        _T("**** DO NOT EDIT THIS FILE - UNLESS YOU KNOW WHAT YOU ARE DOING! ******"),
        _T("**** MAKE CHANGES TO THE USER WORKFLOW PROFILES BY SELECTING THE ******"),
        _T("**** User Workflow Profiles... ITEM ON THE ADMINISTRATOR MENU. ********"),
        _T("**** Manually changing the settings in this file may make Adapt It ****"),
        _T("**** fail or operate incorrectly. If you have edited this file and ****"),
        _T("**** and subsequently Adapt It fails or operates incorrectly, you *****"),
        _T("**** should delete AI_UserProfiles.xml from your Adapt It Work ********"),
        _T("**** folder and reinstall Adapt It. ***********************************"),
        _T("***********************************************************************"),
        _T("  -->"),
    };

    wxString composeXmlStr;
    if (textFile->IsOpened())
    {
        CBString xmlPrologue;
        wxString tab1, tab2, tab3;
        tab1 = _T("\t");
        tab2 = _T("\t\t");
        tab3 = _T("\t\t\t");
        GetEncodingStringForXmlFiles(xmlPrologue); // builds xmlPrologue and adds "\r\n" to it
        composeXmlStr = wxString::FromAscii((const char*)xmlPrologue); // first string in xml file
        composeXmlStr.Replace(_T("\r\n"), _T("")); // remove the ending \r\n added by GetEncodingStringForXmlFiles wxTextFile::AddLine adds its own eol
        textFile->AddLine(composeXmlStr);
        int nCommentItems;
        nCommentItems = sizeof(fileCommentBlock) / sizeof(wxString);
        int i;
        for (i = 0; i < nCommentItems; i++)
        {
            textFile->AddLine(fileCommentBlock[i]);
        }
        // now we start building the actual xml part of the file (remainder of file)
        // We use the data stored in m_pUserProfiles
        composeXmlStr.Empty();
        composeXmlStr += _T('<');
        composeXmlStr += wxString::FromAscii(userprofilessupport);
        textFile->AddLine(composeXmlStr);
        composeXmlStr.Empty();
        composeXmlStr = tab1 + wxString::FromAscii(profileVersion);
        wxString verStr = m_pUserProfiles->profileVersion;
        composeXmlStr += _T("=\"") + verStr + _T("\"");
        textFile->AddLine(composeXmlStr);
        composeXmlStr.Empty();

        composeXmlStr = tab1 + wxString::FromAscii(applicationCompatibility);
        wxString appCStr = m_pUserProfiles->applicationCompatibility;
        composeXmlStr += _T("=\"") + appCStr + _T("\"");
        textFile->AddLine(composeXmlStr);
        composeXmlStr.Empty();

        composeXmlStr = tab1 + wxString::FromAscii(adminModified);
        wxString adminModStr = m_pUserProfiles->adminModified;
        // Indicate "Yes" for adminModified if not already set to "Yes"
        if (adminModStr.Find(_T("Yes")) == wxNOT_FOUND)
        {
            int nPos = adminModStr.Find(_T("No"));
            wxASSERT(nPos != wxNOT_FOUND);
            if (nPos != wxNOT_FOUND)
            {
                adminModStr.Remove(nPos, 2);
                adminModStr.insert(nPos, _T("Yes"));
            }
        }
        composeXmlStr += _T("=\"") + adminModStr + _T("\"");
        textFile->AddLine(composeXmlStr);
        composeXmlStr.Empty();

        int ct;
        int tot = m_pUserProfiles->definedProfileNames.GetCount();
        wxString strVal;
        for (ct = 0; ct < tot; ct++)
        {
            strVal.Empty();
            strVal << ct + 1;
            composeXmlStr = tab1 + wxString::FromAscii(definedProfile) + strVal + _T("=\"") + m_pUserProfiles->definedProfileNames.Item(ct) + _T("\"");
            textFile->AddLine(composeXmlStr);
            composeXmlStr.Empty();

            // replace any entity chars with their xml entity representations
            wxString str = m_pUserProfiles->descriptionProfileTexts.Item(ct);
            str.Replace(_T("&"), wxString::FromAscii(xml_amp)); // replacing '&' must be done first!
            str.Replace(_T("<"), wxString::FromAscii(xml_lt));
            str.Replace(_T(">"), wxString::FromAscii(xml_gt));
            str.Replace(_T("'"), wxString::FromAscii(xml_apos));
            str.Replace(_T("\""), wxString::FromAscii(xml_quote));
            str.Replace(_T("\t"), wxString::FromAscii(xml_tab)); // whm added 24May11

            composeXmlStr = tab1 + wxString::FromAscii(descriptionProfile) + strVal + _T("=\"") + str + _T("\"");
            textFile->AddLine(composeXmlStr);
        }
        composeXmlStr.Empty();
        composeXmlStr = tab1 + _T('>');
        textFile->AddLine(composeXmlStr);
        // the top level <UserProfilesSupport tag and attributes are done, now loop through the
        // profileItemList and output the data for each item in the list
        ProfileItemList::Node* node;
        UserProfileItem* pItem;
        tot = m_pUserProfiles->profileItemList.GetCount();
        for (ct = 0; ct < tot; ct++)
        {
            node = m_pUserProfiles->profileItemList.Item(ct);
            pItem = node->GetData();
            wxASSERT(pItem != NULL);
            composeXmlStr.Empty();
            composeXmlStr = _T('<') + wxString::FromAscii(menu) + _T(' ') + wxString::FromAscii(itemID) + _T("=\"") + pItem->itemID + _T("\"");
            textFile->AddLine(composeXmlStr);
            composeXmlStr.Empty();
            composeXmlStr = tab1 + wxString::FromAscii(itemType) + _T("=\"") + pItem->itemType + _T("\"");
            textFile->AddLine(composeXmlStr);
            composeXmlStr.Empty();

            // replace any entity chars with their xml entity representations
            wxString str = pItem->itemText;
            str.Replace(_T("&"), wxString::FromAscii(xml_amp)); // replacing '&' must be done first!
            str.Replace(_T("<"), wxString::FromAscii(xml_lt));
            str.Replace(_T(">"), wxString::FromAscii(xml_gt));
            str.Replace(_T("'"), wxString::FromAscii(xml_apos));
            str.Replace(_T("\""), wxString::FromAscii(xml_quote));
            str.Replace(_T("\t"), wxString::FromAscii(xml_tab)); // whm added 24May11

            composeXmlStr = tab1 + wxString::FromAscii(itemText) + _T("=\"") + str + _T("\"");
            textFile->AddLine(composeXmlStr);
            composeXmlStr.Empty();

            // replace any entity chars with their xml entity representations
            str = pItem->itemDescr;
            str.Replace(_T("&"), wxString::FromAscii(xml_amp)); // replacing '&' must be done first!
            str.Replace(_T("<"), wxString::FromAscii(xml_lt));
            str.Replace(_T(">"), wxString::FromAscii(xml_gt));
            str.Replace(_T("'"), wxString::FromAscii(xml_apos));
            str.Replace(_T("\""), wxString::FromAscii(xml_quote));
            str.Replace(_T("\t"), wxString::FromAscii(xml_tab)); // whm added 24May11

            composeXmlStr = tab1 + wxString::FromAscii(itemDescr) + _T("=\"") + str + _T("\"");
            textFile->AddLine(composeXmlStr);
            composeXmlStr.Empty();
            composeXmlStr = tab1 + wxString::FromAscii(itemAdminCanChange) + _T("=\"") + pItem->adminCanChange + _T("\"");
            textFile->AddLine(composeXmlStr);
            composeXmlStr.Empty();
            composeXmlStr = tab1 + _T('>');
            textFile->AddLine(composeXmlStr);
            composeXmlStr.Empty();
            int ct2;
            int tot2 = pItem->usedProfileNames.GetCount();
            for (ct2 = 0; ct2 < tot2; ct2++)
            {
                composeXmlStr = tab2 + _T('<') + wxString::FromAscii(profile) + _T(' ') + wxString::FromAscii(itemUserProfile) + _T("=\"") + pItem->usedProfileNames.Item(ct2) + _T("\"");
                textFile->AddLine(composeXmlStr);
                composeXmlStr.Empty();
                composeXmlStr = tab3 + wxString::FromAscii(itemVisibility) + _T("=\"") + pItem->usedVisibilityValues.Item(ct2) + _T("\"");
                textFile->AddLine(composeXmlStr);
                composeXmlStr.Empty();
                composeXmlStr = tab3 + wxString::FromAscii(factory) + _T("=\"") + pItem->usedFactoryValues.Item(ct2) + _T("\"");
                textFile->AddLine(composeXmlStr);
                composeXmlStr.Empty();
                composeXmlStr = tab2 + _T('>');
                textFile->AddLine(composeXmlStr);
                composeXmlStr.Empty();
                composeXmlStr = tab2 + _T('<') + wxString::FromAscii(end_profile) + _T('>');
                textFile->AddLine(composeXmlStr);
                composeXmlStr.Empty();
            }
            composeXmlStr = _T('<') + wxString::FromAscii(end_menu) + _T('>');
            textFile->AddLine(composeXmlStr);
            composeXmlStr.Empty();
        }
        composeXmlStr.Empty();
        composeXmlStr += _T('<');
        composeXmlStr += wxString::FromAscii(end_userprofilessupport) + _T('>');
        textFile->AddLine(composeXmlStr);
    }
}

//////////////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \remarks
/// Called from: the App's OnInit() and OnEditUserMenuSettingsProfiles().
/// This function calls a series of functions that set the visibility of the interface's menus,
/// modeBar, toolBar, wizardListItem and other potential interface settings, all based on the
/// information stored in AI_UserProfiles.xml and the App's m_pAI_MenuStructure member.
/// Note: The MakeMenuInitializationsAndPlatformAdjustments() function should always be called
/// immediately after the ConfigureInterfaceForUserProfile() function.
//////////////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItApp::ConfigureInterfaceForUserProfile()
{
    // We use the menu and settings data in m_pUserProfiles to set visibility of interface
    // elements.
    //
    // First, configure visibility of itemType == subMenu elements
    ConfigureMenuBarForUserProfile();
    // Note: The MakeMenuInitializationsAndPlatformAdjustments() function is called in OnInit()
    // after this ConfigureInterfaceForUserProfile() completes.

    // Next, configure visibility of itemType == modeBar elements
    ConfigureModeBarForUserProfile();

    // Note: Changes in the visibility of itemType == preferencesTab elements
    // are not done here but within the CEditPreferencesDlg dialog class. The
    // tabs are hidden or shown based on the visibility flags in m_pUserProfiles
    // at the time when the Preferences dialog is instantiated.

    // Next, configure visibility of itemType == toolBar element
    ConfigureToolBarForUserProfile();

    // Next, configure visibility of itemType == wizardListItem element
    ConfigureWizardForUserProfile();

    // whm added 7Jan12 There is no "ConfigureStatusBarForUserProfile" but its
    // visibility according to the App's m_bStatusBarVisible needs to be ensured
    // with all the other Configure...ForUserProfile() calls above.
    if (m_bStatusBarVisible)
        m_pMainFrame->m_pStatusBar->Show();
    else
        m_pMainFrame->m_pStatusBar->Hide();

    // Finally, configure visibility of itemType == dialogControl elements
    // AI_UserProfiles.xml currently does not include any dialogControl
    // elements.
    // Other configuration capabilities could go here
}

//////////////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \remarks
/// Called from: the App's ConfigureInterfaceForUserProfile().
/// This function reads the UserProfile data stored in the App's m_pUserProfiles member,
/// and sets the visibility of the interface's menus based on the information
/// stored in AI_UserProfiles.xml. It also reads the App's m_pAI_MenuStructure member and
/// uses it to ensure Adapt It's menu structure is restored to a uniform state when
/// changing the user profile or reverting to the "None" default profile.
//////////////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItApp::ConfigureMenuBarForUserProfile()
{
    // whm 27Sep10 notes:
    // I tried calling delete on pMenuBar and reconstructing it from scratch as a way to
    // implement interface menu configuration. But deleting the menu bar (when it has
    // already been "set" into the main frame via the SetMenuBar() function, leads to some
    // memory leaks due to the wxDocManager::FileHistoryLoad() call that is done to load
    // the file history from our m_pConfig.
    // [whm 1Oct12 Note: All MRU code is now removed from the
    // application, so a FileHistoryLoad() call would no
    // longer be a problem for a direct delete call on
    // pMenuBar]
    // Later, I attempted to try adding menu items one-by-one to individual top level
    // menus and tidying up any menu separators that need to be added or removed for
    // the resulting menu bar. That approach also proved problematic as I could not
    // guarantee robustness of the result. Finally I decided on removing all menu items
    // from a given top level menu, and constructing the menu anew using the
    // m_pAI_Menustructure's itemVisibility info as the guide. That approach gives a
    // robust result that also allows for the insertion of menu separators at the right
    // places to fit the profile. Note: the m_pAI_MenuStructure struct is populated from
    // a temporary default menu bar in the SetupDefaultMenuStructure() function, not
    // from any internal string data, nor from any data in AI_UserProfiles.xml.

    // I don't know how to get the defined int value for an idenfifier from a string
    // representation such as "ID_SAVE_AS", so I'll just create a temporary default
    // menu bar from wxDesigners AIMenuBarFunc() so we can query it for menu id int
    // values we may need. We don't call SetMenuBar() on any frame so it won't be
    // visible. We delete it at the end of the menu bar handling part of this function.
    wxMenuBar* pTempMenuBar;
    pTempMenuBar = AIMenuBarFunc();

    // Go through the existing top level menus processing each one by removing existing
    // items and adding those that need to be visible for the current profile.
    wxString mainMenuLabel_DefaultStructure;
    wxString mainMenuLabel_CurrentMenuBar;
    MainMenuItemList::Node* mmNode;
    AI_MainMenuItem* pMainMenuItem_DefaultStructure;
    wxMenu* pMainMenuItem_CurrentMenuBar;
    wxMenuBar* pMenuBar_Current = GetMainFrame()->GetMenuBar();
    wxASSERT(pMenuBar_Current != NULL);
    pMenuBar_Current->Freeze(); // to avoid flicker while changing the menu
    int ct;
    int nMainMenuItems = (int)m_pAI_MenuStructure->aiMainMenuItems.GetCount();
    for (ct = 0; ct < nMainMenuItems; ct++)
    {
        //bool bProcessingFileMenu = FALSE;
        mmNode = m_pAI_MenuStructure->aiMainMenuItems.Item(ct);
        pMainMenuItem_DefaultStructure = mmNode->GetData();
        mainMenuLabel_DefaultStructure = pMainMenuItem_DefaultStructure->mainMenuLabel;
        //if (mainMenuLabel_DefaultStructure == GetTopLevelMenuName(fileMenu)) // fileMenu resolves to _("&File")
        //{
        //	bProcessingFileMenu = TRUE;
        //}
        // skip processing of the Help and Administrator menus
        if (mainMenuLabel_DefaultStructure == GetTopLevelMenuName(helpMenu) // helpMenu resolves to _("&Help")
            || mainMenuLabel_DefaultStructure == GetTopLevelMenuName(administratorMenu)) // administratorMenu resolves to _("Ad&ministrator")
        {
            continue;
        }
        mainMenuLabel_DefaultStructure = mainMenuLabel_DefaultStructure; //RemoveMenuLabelDecorations(mainMenuLabel_DefaultStructure); // remove any & chars for comparison
                                                                         // get the current top level wxMenu* from the menu bar
        int topLevelMenuBarIndex;
        topLevelMenuBarIndex = pMenuBar_Current->FindMenu(mainMenuLabel_DefaultStructure);
        if (topLevelMenuBarIndex != wxNOT_FOUND)
        {
            // We must establish a new index for the pMenuBar, which won't necessarily be the
            // same as the ct index we use into the top level menus in the default m_pAIMenuStructure.
            int mbCt;
            //int numFileHistoryItems = 0; // whm 1Oct12 removed
            mbCt = pMenuBar_Current->FindMenu(mainMenuLabel_DefaultStructure);
            pMainMenuItem_CurrentMenuBar = pMenuBar_Current->GetMenu(mbCt);
            if (pMainMenuItem_CurrentMenuBar != NULL)
            {
                // Remove all current menu items from the pMainMenuItem_CurrentMenuBar.
                // Note: we do not remove any File History Items from the File menu - these
                // can stay.
                wxMenuItemList menuItemListForThisMainMenu;
                menuItemListForThisMainMenu = pMainMenuItem_CurrentMenuBar->GetMenuItems();
                int numItemsToRemove;
                numItemsToRemove = (int)menuItemListForThisMainMenu.GetCount(); // could be empty already
                                                                                // Note: testing shows that a wxMenuItemList also enumerates menu separators as
                                                                                // countable items in the list.
                if (numItemsToRemove != 0)
                {
                    // remove existing items from this top level menu (pMainMenuItem_CurrentMenuBar)
                    int miCt;
                    wxMenuItem* mItem;
                    wxMenuItem* removedItem;
                    wxMenuItemList::Node* pNode;
                    for (miCt = 0; miCt < numItemsToRemove; miCt++)
                    {
                        pNode = menuItemListForThisMainMenu.Item(miCt);
                        mItem = pNode->GetData();
                        wxASSERT(mItem != NULL);

                        if (mItem->GetItemLabelText() == _("See Glosses")) //if (mItem->GetLabel() == _("See Glosses"))
                        {
                            // TODO: Check the following assumption: We should unilaterally disable Glossing here.
                            // Reasoning: An administrator cannot really force the "See Glossing" Advanced
                            // menu item to remain ticked in a persistent manner by turning it ticking it "ON",
                            // then hiding the See Glossing menu item in the current profile, because the
                            // "See Glossing" setting is not persistent - it reverts back to being "OFF" each
                            // time the app starts up. Hence, we can ensure Glossing is disabled here along with
                            // the removal of the "See Glosses" Advanced menu item in this profile.
                            gbGlossingVisible = FALSE;
                            gbIsGlossing = FALSE; // this must be FALSE if gbGlossingVisible is FALSE
                        }
                        removedItem = pMainMenuItem_CurrentMenuBar->Remove(mItem);
                        if (removedItem != NULL) // whm 11Jun12 added NULL test
                            delete removedItem;
                        removedItem = (wxMenuItem*)NULL;
                    }
                }
            }

            /*
            // whm 1Oct12 removed MRU code
            // Note: The File at this point is empty of normal menu items, but may have
            // from 1 to 9 file history items. We don't want to append menu items below
            // the group of file history items, but rather we must insert the menu items at
            // GetMenuItemCount() - numFileHistoryItems.
            */

            int insertAtIndex = 0;
            // add menu items to this top level menu (pMainMenuItem_CurrentMenuBar)
            wxArrayPtrVoid pArrayOfSubMenuItemsToAdd;
            pArrayOfSubMenuItemsToAdd = GetMenuStructureItemsArrayForThisTopLevelMenu(pMainMenuItem_DefaultStructure);
            int numPointers;
            int ct_ptr;
            AI_SubMenuItem* pSubMenuItem;
            numPointers = (int)pArrayOfSubMenuItemsToAdd.GetCount();
            for (ct_ptr = 0; ct_ptr < numPointers; ct_ptr++)
            {
                pSubMenuItem = (AI_SubMenuItem*)pArrayOfSubMenuItemsToAdd.Item(ct_ptr);
                wxASSERT(pSubMenuItem != NULL);

                if (MenuItemIsVisibleInThisProfile(m_nWorkflowProfile, pSubMenuItem->subMenuIDint))
                {
                    // In the line below the numFileHistoryItems will be zero for top level menus except for
                    // the File menu. We normally insert at the GetMenuItemCount() index, i.e., after the last
                    // item in the menu, but insert before any file history items.
                    insertAtIndex = pMainMenuItem_CurrentMenuBar->GetMenuItemCount(); // - numFileHistoryItems; // whm 1Oct12 removed
                    wxASSERT(insertAtIndex >= 0);
                    int menuItemId;
                    menuItemId = GetSubMenuItemIdFromAIMenuBar(mainMenuLabel_DefaultStructure, pSubMenuItem->subMenuLabel, pTempMenuBar);

                    wxItemKind itemKind;
                    itemKind = GetMenuItemKindFromString(pSubMenuItem->subMenuKind);
                    // do the menu item insertion
                    // Note: menuItemId will be wxID_SEPARATOR (-2) and itemKind will be
                    // wxITEM_SEPARATOR (-1) for menuSeparators.
                    // Note: apparently the \t chars in the xml and internal strings become \\t literals
                    // and need to be changed to \t to work in the menus.
                    wxString labelStr = pSubMenuItem->subMenuLabel;
                    labelStr.Replace(_T("\\t"), _T("\t"));
                    wxMenuItem* item = new wxMenuItem(pMainMenuItem_CurrentMenuBar, menuItemId, labelStr, pSubMenuItem->subMenuHelp, itemKind);
                    pMainMenuItem_CurrentMenuBar->Insert(insertAtIndex, item);
                }
            } // end of for (ct_ptr = 0; ct_ptr < numPointers; ct_ptr++)

              // Check for extraneous left-over menu separators in this top level menu
              // and delete if found.
              // Start at the bottom of the menu and remove all menu separators there.
            bool bLastItemWasSeparator = FALSE;
            wxMenuItemList::Node* pNode;
            wxMenuItem* pMenuItem;
            wxMenuItemList pMenuItemList = pMainMenuItem_CurrentMenuBar->GetMenuItems(); // refresh the list of menu items
            pNode = pMenuItemList.GetLast();
            while (pNode != NULL)
            {
                pMenuItem = pNode->GetData();
                if (pMenuItem->GetKind() != wxITEM_SEPARATOR)
                {
                    break;
                }
                else
                {
                    // This menu separator is either the last item on the menu
                    // or it is the first of two adjacent separators in the menu.
                    // In either case we delete the current menu separator.
                    wxMenuItem* pRemMenuItem;
                    pRemMenuItem = pMainMenuItem_CurrentMenuBar->Remove(pMenuItem);
                    wxASSERT(pRemMenuItem != NULL);
                    if (pRemMenuItem != NULL) // whm 11Jun12 added NULL test
                        delete pRemMenuItem; // to avoid memory leaks
                    pRemMenuItem = (wxMenuItem*)NULL;
                }
                pMenuItemList = pMainMenuItem_CurrentMenuBar->GetMenuItems(); // refresh list
                pNode = pMenuItemList.GetLast();
            }
            // remove any separators at the top of the top level menu
            pMenuItemList = pMainMenuItem_CurrentMenuBar->GetMenuItems(); // refresh the list of menu items
            int nSubMenuItems = (int)pMenuItemList.GetCount();
            pNode = pMenuItemList.GetFirst();
            while (pNode != NULL)
            {
                pMenuItem = pNode->GetData();
                if (pMenuItem->GetKind() == wxITEM_SEPARATOR)
                {
                    // This menu separator is at the top of the menu
                    // so remove it.
                    wxMenuItem* pRemMenuItem;
                    pRemMenuItem = pMainMenuItem_CurrentMenuBar->Remove(pMenuItem);
                    wxASSERT(pRemMenuItem != NULL);
                    if (pRemMenuItem != NULL) // whm 11Jun12 added NULL test
                        delete pRemMenuItem; // to avoid memory leaks
                    pRemMenuItem = (wxMenuItem*)NULL;
                }
                else
                {
                    break;
                }
                pMenuItemList = pMainMenuItem_CurrentMenuBar->GetMenuItems(); // refresh list
                pNode = pMenuItemList.GetFirst();
            }

            // change any remaining multiple sequences of menu separators to a single separator
            pMenuItemList = pMainMenuItem_CurrentMenuBar->GetMenuItems(); // refresh the list of menu items
            nSubMenuItems = (int)pMenuItemList.GetCount();
            int smCt;
            for (smCt = nSubMenuItems - 1; smCt >= 0; smCt--) // process bottom to top of menu
            {
                pNode = pMenuItemList.Item(smCt);
                pMenuItem = pNode->GetData();
                wxString smKindStr;
                wxItemKind smKind = pMenuItem->GetKind();
                if (smKind == wxITEM_SEPARATOR)
                {
                    if (smCt == nSubMenuItems - 1 || bLastItemWasSeparator)
                    {
                        // This menu separator is either the last item on the menu
                        // or it is the first of two adjacent separators in the menu.
                        // In either case we delete the current menu separator.
                        wxMenuItem* pRemMenuItem;
                        pRemMenuItem = pMainMenuItem_CurrentMenuBar->Remove(pMenuItem);
                        wxASSERT(pRemMenuItem != NULL);
                        if (pRemMenuItem != NULL) // whm 11Jun12 added NULL test
                            delete pRemMenuItem; // to avoid memory leaks
                        pRemMenuItem = (wxMenuItem*)NULL;
                    }
                    bLastItemWasSeparator = TRUE;
                }
                else
                {
                    bLastItemWasSeparator = FALSE;
                }
            }
        }
        else
        {
            // The top level menu was not found in the menu bar. This can happen for
            // the Administrator menu when it is not present, and in an ANSI build
            // where the Layout menu is not present.
            ;
        }
    } // end of for (ct = 0; ct < nMainMenuItems; ct++)

    pMenuBar_Current->Thaw(); // to avoid flicker while changing the menu
                              // remove the temporary invisible menu bar to avoid memory leaks
    if (pTempMenuBar != NULL) // whm 11Jun12 added NULL test
        delete pTempMenuBar;
}

//////////////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \remarks
/// Called from: the Doc's OnOpenDocument().
/// whm 30Aug2021 added this function to control the visibility of the [ ] Use Auto Correct
/// checkbox in the control/mode bar, hiding the checkbox when no autocorrect.txt file is available
/// for an opened document's project, showing the checkbox when there is an autocorrect.txt file
/// in the project folder of an opened document.
//////////////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItApp::ConfigureModeBarForAutoCorrect()
{
    CMainFrame* pMainFrame;
    pMainFrame = GetMainFrame();
    pMainFrame->Freeze(); // to avoid flicker
    wxCheckBox* pCheckboxUseAutoCorrect = (wxCheckBox*)pMainFrame->m_pControlBar->FindWindowById(ID_CHECKBOX_USE_AUTOCORRECT);
    if (pCheckboxUseAutoCorrect != NULL)
    {
        if (m_bUsingAutoCorrect)
        {
            pCheckboxUseAutoCorrect->Show(TRUE);
            pCheckboxUseAutoCorrect->SetValue(TRUE);
        }
        else
        {
            pCheckboxUseAutoCorrect->Show(FALSE);
        }
    }
    // Now refresh the CMainFrame's m_controlBarHeight member to ensure the visibility
    // of its controls are updated.
    pMainFrame->m_pControlBar->Layout(); // pMainFrame->m_pControlBar->Refresh(); // whm 31Aug2021 changed this to ->Layout()
    pMainFrame->Thaw(); // to avoid flicker
    //pMainFrame->SendSizeEvent(); // we need to send a size event to the main frame - 12Oct2021 whm removed - not needed
}

//////////////////////////////////////////////////////////////////////////////////////////
/// \return     TRUE if an autocorrect rule was applied to the pTextCtrl's content, FALSE otherwise
///             The return value is designed to determine whether the event.Skip() is called.
///             When an autocorrect rule has been applied, event.Skip() should NOT be called.
/// \param      -> pTextCtrl - pointer to the target language wxTextCtrl whose text we're
///                 potentially auto-correcting.
/// \param      -> pevent - pointer to the key event of the character being typed into the 
///                 pTextCtrl
/// \remarks
/// Called from: Mainly CPhraseBox::OnChar(), but also the following dialog's target text text 
/// controls: 
/// whm 31Aug2021 added this function to consolidate all of the Auto-correct functionality into
/// a single function that can be used at the end of a target text assigned text control's OnChar() 
/// handler. This function carries out the auto-correct on the pTextCtrl's text content if the key
/// being typed triggers an autocorrect.txt rule. The function's return value (TRUE or FALSE) is 
/// designed to determine whether the OnChar()'s event.Skip() is called at the end of OnChar().
//////////////////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItApp::AutoCorrected(wxTextCtrl* pTextCtrl, wxKeyEvent* pevent) // whm 31Aug2021 added
{
    bool bAutoCorrected = FALSE;
    if (m_bUsingAutoCorrect)
    {
        wxChar typedChar = pevent->GetUnicodeKey();
        if (typedChar != WXK_NONE)
        {
            // It's a "normal" character. Notice that this includes control characters in 
            // the 1..31 range, e.g. WXK_RETURN (Enter), WXK_BACK (BackSpace) and others. 
            // For auto-correct we only consider typedChar values that are above the control 
            // character range 1..31.
            if (typedChar >= 32)
            {
                //wxLogMessage("You pressed '%c'", typedChar);

                long from;
                long to;
                long InsPoint = pTextCtrl->GetInsertionPoint();
                InsPoint = InsPoint; // avoid warning
                pTextCtrl->GetSelection(&from, &to); // Note: in GetSelection() from and to will both be same as InsPoint if no selection exists
                wxString currBoxText = pTextCtrl->GetValue();
                wxString subStrPartBeforeSelOrInsertionPoint;
                wxString sbuStrSelText;
                wxString subStrPartAfterSelOrInsertionPoint;
                wxString subStrBeforeWithChar;
                // Break up currBoxText into its parts.
                // The following works whether or not there is a text selection.
                // whm 9May2022 modified further to work properly for multi-line text controls which will have embedded \n characters
                // delineating the end of lines. To accurately manipulate the substrings that can occur in multi-line text controls
                // we cannot use the wxString::mid() method but can make use of the text control's GetRange() method which properly
                // accounts for any embedded \n characters within the multi-line text control. It also works properly for single line
                // text controls
                // whm 9May2022 modification to set appropriate segments when the control is a multi-line text control (i.e., has embedded \n chars)
                subStrPartBeforeSelOrInsertionPoint = pTextCtrl->GetRange(0, from); // must use GetRange() for multi-line text control
                sbuStrSelText = pTextCtrl->GetRange(from, to); // Empty if no selection (to == from). Since typing replaces a selection, this part will be replaced by the typed char
                subStrPartAfterSelOrInsertionPoint = pTextCtrl->GetRange(to, pTextCtrl->GetLastPosition());
                subStrBeforeWithChar = subStrPartBeforeSelOrInsertionPoint + typedChar;

                // Call LookUpStringInAutoCorrectMap() to see if there is an autocorrection available based on subStrBeforeSelOrInsertionPoint and the typedChar
                bool bfound;
                wxString subStrAfterAutoCorrect = _T("");
                bfound = GetDocument()->LookUpStringInAutoCorrectMap(subStrPartBeforeSelOrInsertionPoint, typedChar, subStrAfterAutoCorrect);
                if (bfound)
                {
                    // The typedChar gets swallowed up in the auto-correction, so just add the last part of the editbox string (it would 
                    // be empty if a selection or insertion point was not already at the end of the edit box text.
                    // The insertion point should still be at the end of the autocorrect string subStrAfterAutoCorrect as it 
                    // was determined in the pTextCtrl->GetInsertionPoint() call above.
                    subStrAfterAutoCorrect += subStrPartAfterSelOrInsertionPoint;
                    pTextCtrl->SetValue(subStrAfterAutoCorrect);
                    pTextCtrl->SetInsertionPoint(InsPoint);
                    // Note: According to the wx docs, SetValue() sets the control as NOT modified, i.e., a call to IsModified() will 
                    // immediately return FALSE at this point. 
                    // The SetValue() call also generates a wxEVT_TEXT event which triggers our OnPhraseBoxChanged() method, but that
                    // method tests this->IsModified() before doing its work so we'll call this->SetModified(TRUE) here to ensure that
                    // downstream know a change has been made.
                    if (!pTextCtrl->IsModified())
                        pTextCtrl->SetModified(TRUE);
                    bAutoCorrected = TRUE;
                }
                else
                {
                    // No autocorrect rule was applied, so do nothing.
                    ;
                }
            }
            else
            {
                // It's a control character which we'll ignore for auto-correct purposes
                ;
            }
        } // end of if (typedChar != WXK_NONE)
    } // end of if (pApp->m_bUsingAutoCorrect)
    return bAutoCorrected;
}

// whm 30Sep2021 added this function to check whether two text files are identical or different
bool CAdapt_ItApp::AreTextFilesTheSame(wxString filePath1, wxString filePath2)
{
    wxTextFile f1;
    wxTextFile f2;
    bool bSame = TRUE; // assume they have same number of identical text lines, unless we find a difference
    if (f1.Open(filePath1) && f2.Open(filePath2))
    {
        int ct;
        int nLineTot1 = f1.GetLineCount();
        int nLineTot2 = f2.GetLineCount();
        if (nLineTot1 != nLineTot2)
        {
            // The two files have differing number of lines so they are different
            bSame = FALSE;
        }
        else
        {
            // The two files have same number of lines, but are the lines identical?
            for (ct = 0; ct < nLineTot1; ct++)
            {
                if (f1.GetLine(ct) != f2.GetLine(ct))
                {
                    // These two lines differ so the files are not the same
                    bSame = FALSE;
                    break; // no need to check more lines
                }
            }
        }
    }
    return bSame;
}

// whm 3Sept2021 added
// This function initializes the AutoCorrect hash map m_AutoCorrectMap to an empty state
// and initializes the other App members related to the AutoCorrect feature.
void CAdapt_ItApp::EmptyMapAndInitializeAutoCorrect()
{
    m_AutoCorrectMap.empty();
    // Assume the autocorrect.txt file is not maiformed
    m_bAutoCorrectIsMalformed = FALSE;
    // Assume we're not using Auto-Correct
    m_bUsingAutoCorrect = FALSE;
    // Always start with longest key length of 0
    m_longestAutoCorrectKeyLen = 0;
}

// whm 4Sep2021 added to convert a wxString that contains "\uxxxx" sequences, returning a wxString
// in which those "\uxxxx" values have been converted to their Unicode character equivalents.
// This function designed as a helper function for parsing an autocorrect.txt file which may
// define its rules using the \uxxxx ASCII char format on either side of the --> auto-correct symbol.
// The first parameter stringWithHexChars is the incoming string to be converted (that may or may 
// not have \uxxxx sub-strings within it. It can have a mixture of chars, some actual chars and some
// in the \uxxxx or \Uxxxx form. Internally, when we find \uxxxx or \Uxxxx we must not not change any 
// actual Unicode upper case characters to lower case, but keep their representation the same case.
// The second parameter bSuccess is a bool that returns to the caller TRUE if the conversion is 
// successful or FALSE if the \uxxxx value is malformed or the .ToLong() conversion returns
// FALSE for some reason.
// whm 6May2022 modified to ensure we don't change the case of any actual Unicode characters while 
// dealing with the possibility of upper-case \Uxxxx and lower-case \uxxxx backslash representations.
wxString CAdapt_ItApp::ConvertBackslashUxxxxHexValsInStringToStringChars(wxString stringWithHexChars, bool& bSuccess)
{
    // There may be more than one \uxxxx hex representation within the incoming
    // stringWithHexChars string, so we need to replace any and all that we find 
    // within the string. Use a while loop to replace \uxxxx sub-strings until 
    // all are replaced with their actual Unicode characters.
    wxString tempStr = stringWithHexChars;
    wxString hexStr = _T("");
    bool bOK = TRUE;
    bSuccess = TRUE;
    tempStr.Replace(_T("\\U"), _T("\\u"), TRUE); // replace any upper case \U occurrences with lower case \u substrings, leaving case of other characters in string unchanged
    while (tempStr.Find(_T("\\u")) != wxNOT_FOUND)
    {
        int posHexStr;
        posHexStr = tempStr.Find(_T("\\u"));
        hexStr = tempStr.Mid(posHexStr + 2, 4); // get the hex part - always consisting of 4 digits - after \u
        long testval = 0;
        bOK = hexStr.ToLong(&testval, 16); // 16 = base 16 or hexadecimal
        if (!bOK)
        {
            // There was an error in converting to a long so return the
            // string up to the point of the conversion error and set bSuccess to FALSE
            bSuccess = FALSE;
            return tempStr;
        }
        wxChar theChar(testval); // use wxChar constructor to convert long testval to wxChar
        // replace the \uxxxx sub-string with the actual theChar in the string and iterate 
        // for any additional \uxxxx in tempStr
        tempStr.Replace(_T("\\u" + hexStr), wxString(theChar)); // replaces all instances of the \uxxxx value in tempStr
    }
    return tempStr;
}


//////////////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \remarks
/// Called from: the App's ConfigureInterfaceForUserProfile().
/// This function destroys the existing mode bar then constructs a new mode bar and uses
/// it as the starting baseline, removing elements according to the currently selected
/// user profile. The mode bar may be either the standard 1-line mode bar or the
/// special 2-line mode bar used when the -xo command line parameter is used with
/// an OLPC XO computer.
//////////////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItApp::ConfigureModeBarForUserProfile()
{
    // Note: The ModeBar (also called "controlBar") is created on a wxPanel in the
    // CMainFrame constructor in MainFrm.cpp. Its pointer on the App is m_pControlBar.
    // Unlike the menu bar, the m_pControlBar is not managed directly by its enclosing
    // frame (CMainFrame). The m_pControlBar, once created is never optionally hidden
    // (using the View menu) as can be done for the Tool bar, Status bar and Compose
    // bar. Nevertheless, the height of m_pControlBar must be current in the
    // main frame's m_controlBarHeight member in order to correctly size the main frame.
    // The m_controlBarHeight is kept current whether the application is using the normal
    // control bar (ControlBarFunc) or the two-line control bar (ControlBar2LineFunc)
    // designed for better visibility on the OLPC XO machines.
    // We will get the control bar and recreate it for the current user profile's
    // "modeBar" item visibility specifications. As with the AI menu bar, it is easiest
    // to simply remove the items from the existing mode bar, and add back those which
    // should appear in the current profile.
    //
    // We need to get the mode bar's sizer(s) in order to remove and add controls to
    // the correct part of the mode bar. We have assigned "Access variable names" for
    // the needed sizers in both mode bars. For the normal single-line mode bar the
    // access variable name is ID_CONTROLBAR_1_LINE_SIZER; for the two-line mode bar
    // the access variable names are ID_CONTROLBAR_2_LINE_SIZER_TOP and
    // ID_CONTROLBAR_2_LINE_SIZER_BOTTOM. These sizers are created as
    // wxBoxSizer( wxHORIZONTAL ) in wxDesigner.
    // The ID_CONTROLBAR_1_LINE_SIZER sizer has its items in the following order:
    // 1. Drafting [wxRadioButton]
    // 2. Reviewing [wxRadioButton]
    // 3. Automatic [wxCheckBox]
    // 4. Save to Knowledge Base [wxCheckBox]
    // 5. Force Choice For This Item [wxCheckBox]
    // 6. <no adaptation> [wxButton]
    // 7. Delay [wxStaticText] + wxTextCtrl
    // 8. Spacer
    // 9. Glossing [wxCheckBox]
    // 10. Use Auto Correct [wxCheckBox]
    // Note: There are also two wxStaticLine controls created one above the ID_CONTROLBAR_1_LINE_SIZER and
    // one below it. We won't need to change those, just the contents of ID_CONTROLBAR_1_LINE_SIZER.

    CMainFrame* pMainFrame;
    pMainFrame = GetMainFrame();
    pMainFrame->Freeze(); // to avoid flicker
    pMainFrame->m_pControlBar->Destroy(); // removes the existing mode bar which may not be showing all items in the current profile

    // Create the new control bar using a wxPanel (see similar code in CMainFrame's constructor)
    // whm note: putting the control bar on a panel could have been done in wxDesigner
    // TODO: Make sure this works whether or not the toolbar and/or composebar are currently visible
    wxPanel *controlBar = new wxPanel(pMainFrame, -1, wxDefaultPosition, wxDefaultSize, 0);
    wxASSERT(controlBar != NULL);

    // The ControlBarFunc() and ControlBar2LineFunc() functions are located
    // in Adapt_It_wdr.cpp.
    // To populate the controlBar panel we've used wxBoxSizers. The outer
    // most sizer is a vertical box sizer which has a horizontal line in
    // the upper part of the box (for the line between the toolbar and
    // controlbar), and the row of controls laid out in wxHORIZONTAL
    // alignment within an embedded horizontal box sizer, below the line
    // within the vertical box sizer

    if (m_bExecutingOnXO) // prefix m_bExecutingOnXO with ! to test the two-line control bar configuration
    {
        // We're running on a high res screen - probably a OLPC XO, so use the 2 line control bar for
        // better fit in main frame
        ControlBar2LineFunc(controlBar, TRUE, TRUE);
        // make m_pControlBar point to the new control bar
        pMainFrame->m_pControlBar = controlBar;
        // In the case of the two line control bar, we have two
        // named wxBoxSizers.
        // The upper sizer called ID_CONTROLBAR_2_LINE_SIZER_TOP
        // has the following controls:
        //    1. Spacer
        //    2. Drafting [wxRadioButton]
        //    3. Reviewing [wxRadioButton]
        //    4. *Automatic [wxCheckBox]
        //    5. Save to Knowledge Base [wxCheckBox]
        //    6. *Delay [wxStaticText}
        //    7. wxTextCtrl named IDC_EDIT_DELAY
        // The lower sizer called ID_CONTROLBAR_2_LINE_SIZER_BOTTOM
        // has the following controls:
        //    1. Spacer
        //    2. *Force Choice For This Item [wxCheckBox]
        //    3. Spacer
        //    4. <no adaptation> [wxButton]
        //    5. Spacer
        //    6. *Glossing [wxCheckBox]
        // * These are the potentially "hidden" items depending on the selected
        // user profile.
        // Note: On the XO screen, it is the horizontal space that gets overly crowded due to
        // the system's increase in font size, rather than the vertical space, so I don't
        // think it would be worth the effort to try to consolidate the two bars into a one
        // line control bar in the case that an administrator sets up a profile in which many
        // items are not to be made visible.
        //
        // Go through the children of the two line control bar and
        // remove any that are not supposed to be visible in the current
        // profile.
        // First, the upper sizer ID_CONTROLBAR_2_LINE_SIZER_TOP
        wxSizer* pModeBarSizer = ID_CONTROLBAR_2_LINE_SIZER_TOP;
        RemoveModeBarItemsFromModeBarSizer(pModeBarSizer);

        // Second, the lower sizer ID_CONTROLBAR_2_LINE_SIZER_BOTTOM
        pModeBarSizer = ID_CONTROLBAR_2_LINE_SIZER_BOTTOM;
        RemoveModeBarItemsFromModeBarSizer(pModeBarSizer);
    }
    else
    {
        ControlBarFunc(controlBar, TRUE, TRUE);
        // make m_pControlBar point to the new control bar
        pMainFrame->m_pControlBar = controlBar;

        // Now we go through the children of the default mode bar and remove any that are
        // not supposed to be visible in the current profile
        wxSizer* pModeBarSizer = ID_CONTROLBAR_1_LINE_SIZER;
        RemoveModeBarItemsFromModeBarSizer(pModeBarSizer);
    }
    // If the "[] Glossing" check box is not removed in this profile after the above code
    // executes (i.e., NULL), check here to see if it should be visible or hidden according to the
    // current value of gbIsGlossing.
    wxCheckBox* pCheckboxIsGlossing = (wxCheckBox*)pMainFrame->m_pControlBar->FindWindowById(IDC_CHECK_ISGLOSSING);
    // pCheckboxIsGlossing coulc be null if it is not visible in the current profile
    if (pCheckboxIsGlossing != NULL)
    {
        if (gbIsGlossing)
        {
            pCheckboxIsGlossing->Show(TRUE);
        }
        else
        {
            pCheckboxIsGlossing->Show(FALSE);
        }
    }

    wxButton* pNoAdaptationOrNoGloss = (wxButton*)pMainFrame->m_pControlBar->FindWindowById(IDC_BUTTON_NO_ADAPT);
    // pNoAdaptationOrNoGloss could be null if it is not visible in the current profile
    if (pNoAdaptationOrNoGloss != NULL)
    {
        if (gbIsGlossing)
        {
            pNoAdaptationOrNoGloss->SetLabel(_("<no gloss>"));
        }
        else
        {
            pNoAdaptationOrNoGloss->SetLabel(_("<no adaptation>"));
        }
    }

    // whm added 7Jan12 set controlBar visibility according to basic config
    // file setting - as stored in the App's m_bModeBarVisible member
    if (gpApp->m_bModeBarVisible)
    {
        gpApp->GetMainFrame()->m_pControlBar->Show();
    }
    else
    {
        gpApp->GetMainFrame()->m_pControlBar->Hide();
    }

    // lastly update the CMainFrame's m_controlBarHeight member with the newly populated
    // mode bar
    wxSize controlBarSize;
    controlBarSize = pMainFrame->m_pControlBar->GetSize();
    pMainFrame->m_controlBarHeight = controlBarSize.GetHeight();
    pMainFrame->Thaw(); // to avoid flicker
    pMainFrame->m_pControlBar->Layout(); // whm 31Aug2021 added
    pMainFrame->SendSizeEvent(); // we need to send a size event to the main frame
}

//////////////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \remarks
/// Called from: the App's ConfigureModeBarForUserProfile().
/// This function is a helper function for ConfigureModeBarForUserProfile().
/// It removes any mode bar items that are not visible in the currently selected user
/// profile. It also deals with the special cases of the Glossing checkbox and the Delay's
/// wxTextCtrl. If Glossing is ON it turns it OFF if the Glossing checkbox is removed from
/// the modebar. If the Delay static text is removed, it removes the associated wxTextCtrl.
//////////////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItApp::RemoveModeBarItemsFromModeBarSizer(wxSizer* pModeBarSizer)
{
    wxASSERT(pModeBarSizer != NULL);
    wxSizerItemList modeBarItems = pModeBarSizer->GetChildren();
    wxSizerItemList::Node* node;
    int nSizerItems = (int)modeBarItems.GetCount();
    int ct;
    bool bDelayRemoved = FALSE;
    for (ct = 0; ct < nSizerItems; ct++)
    {
        node = modeBarItems.Item(ct);
        wxSizerItem* pSizerItem = node->GetData();
        wxString itemLabel;
        if (!pSizerItem->IsSpacer())
        {
            // don't call GetWindow()->GetLabel() on a spacer; it will crash
            itemLabel = pSizerItem->GetWindow()->GetLabel();
            itemLabel.Trim(FALSE);
            itemLabel.Trim(TRUE);
        }
        else
        {
            itemLabel = _T("");
        }
        if (!ModeBarItemIsVisibleInThisProfile(m_nWorkflowProfile, itemLabel))
        {
            if (itemLabel == _("Glossing") && gbIsGlossing == TRUE)
            {
                // TODO: Check the following assumption: We should unilaterally turn off Glossing here.
                // Reasoning: An administrator cannot really force Glossing to be "ON" in a persistent
                // manner by turning it on, then hiding the Glossing checkbox in the current profile,
                // because the Glossing setting is not persistent - it reverts back to being "OFF" each
                // time the app starts up. Hence, we can ensure Glossing is turned off here.
                gbIsGlossing = FALSE; // we are removing the [] Glossing checkbox so gbIsGlossing should be FALSE
            }
            if (itemLabel == _("Delay"))
            {
                // the "Delay" is actually associated with the itemLabel of the wxStaticText control and
                // not the following wxTextCtrl, so when the "Delay" wxStaticText control is removed we
                // also flag for removal (see below) the following wxTextCtrl which has the identifier of
                // IDC_EDIT_DELAY.
                bDelayRemoved = TRUE;
            }
            pSizerItem->DeleteWindows();
        }
    }
    if (bDelayRemoved)
    {
        // the Delay wxStaticText was removed, so remove the following wxTextCtrl as well
        wxTextCtrl* pDelayTextCtrl;
        pDelayTextCtrl = (wxTextCtrl*)GetMainFrame()->m_pControlBar->FindWindowById(IDC_EDIT_DELAY);
        wxASSERT(pDelayTextCtrl != NULL);
        if (pDelayTextCtrl != NULL)
        {
            pDelayTextCtrl->Destroy();
        }
    }
}

//////////////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \remarks
/// Called from: the App's ConfigureInterfaceForUserProfile().
/// This function destroys the existing tool bar then constructs a new tool bar and uses
/// it as the starting baseline, removing elements according to the currently selected
/// user profile. The tool bar may be either the standard tool bar (AIToolBarFunc) or the
/// alternate tool bar (AIToolBar32x32Func) which has fewer buttons but larger bitmaps for
/// use when the -xo command line parameter is used with an OLPC XO computer.
//////////////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItApp::ConfigureToolBarForUserProfile()
{
    CMainFrame* pMainFrame;
    pMainFrame = GetMainFrame();
    pMainFrame->m_toolBarHeight = 0;
    pMainFrame->Freeze(); // to avoid flicker

                          // remove the existing tools so we can rebuild them
    if (pMainFrame->m_auiToolbar != NULL)
    {
        pMainFrame->m_auiToolbar->ClearTools(); // remove all tools
    }

    wxAuiToolBar *pAuiToolbar = pMainFrame->m_auiToolbar;
    bool bJustAddedSeparator = true;	// make sure we don't add 2 separators in a row
    int index = 0;
    wxBitmap bmp;

    // the full set of toolbar buttons (all sizes)
    ToolbarButtonInfo tbInfo[] =
    {
        { wxID_NEW, _("New"), _("New"), _("Create a new document"), gpApp->wxGetBitmapFromMemory(document_new_png_16), gpApp->wxGetBitmapFromMemory(document_new_png_22), gpApp->wxGetBitmapFromMemory(document_new_png_32) },
        { wxID_OPEN, _("Open"), _("Open"), _("Open an existing document"), gpApp->wxGetBitmapFromMemory(document_open_png_16), gpApp->wxGetBitmapFromMemory(document_open_png_22), gpApp->wxGetBitmapFromMemory(document_open_png_32) },
        { wxID_SAVE, _("Save"), _("Save"), _("Save the active document"), gpApp->wxGetBitmapFromMemory(document_save_png_16), gpApp->wxGetBitmapFromMemory(document_save_png_22), gpApp->wxGetBitmapFromMemory(document_save_png_32) },
        { 0, _T(""), _T(""), _T(""), wxNullBitmap, wxNullBitmap, wxNullBitmap },
        { ID_EDIT_CUT, _("Cut"), _("Cut"), _("Cut the selection and put it on the Clipboard"), gpApp->wxGetBitmapFromMemory(edit_cut_png_16), gpApp->wxGetBitmapFromMemory(edit_cut_png_22), gpApp->wxGetBitmapFromMemory(edit_cut_png_32) },
        { ID_EDIT_COPY, _("Copy"), _("Copy"), _("Copy the selection and put it on the Clipboard"), gpApp->wxGetBitmapFromMemory(edit_copy_png_16), gpApp->wxGetBitmapFromMemory(edit_copy_png_22), gpApp->wxGetBitmapFromMemory(edit_copy_png_32) },
        { ID_EDIT_PASTE, _("Paste"), _("Paste"), _("Insert Clipboard contents"), gpApp->wxGetBitmapFromMemory(edit_paste_png_16), gpApp->wxGetBitmapFromMemory(edit_paste_png_22), gpApp->wxGetBitmapFromMemory(edit_paste_png_32) },
        { 0, _T(""), _T(""), _T(""), wxNullBitmap, wxNullBitmap, wxNullBitmap },
        { wxID_PRINT, _("Print"), _("Print"), _("Print the active document"), gpApp->wxGetBitmapFromMemory(document_print_png_16), gpApp->wxGetBitmapFromMemory(document_print_png_22), gpApp->wxGetBitmapFromMemory(document_print_png_32) },
        { 0, _T(""), _T(""), _T(""), wxNullBitmap, wxNullBitmap, wxNullBitmap },
        { ID_BUTTON_GUESSER, _("Guesser"), _("Change Guesser Settings"), _("Change settings for guessing the translation text"), gpApp->wxGetBitmapFromMemory(dialog_guesser_png_16), gpApp->wxGetBitmapFromMemory(dialog_guesser_png_22), gpApp->wxGetBitmapFromMemory(dialog_guesser_png_32) },
        { 0, _T(""), _T(""), _T(""), wxNullBitmap, wxNullBitmap, wxNullBitmap },
        { ID_BUTTON_CREATE_NOTE, _("Notes"), _("Open a Note dialog"), _("Create a note dialog and open it for typing"), gpApp->wxGetBitmapFromMemory(dialog_notes_png_16), gpApp->wxGetBitmapFromMemory(dialog_notes_png_22), gpApp->wxGetBitmapFromMemory(dialog_notes_png_32) },
        { ID_BUTTON_PREV_NOTE, _("Previous Note"), _("Jump to the previous Note"), _("Go back and open the previous note"), gpApp->wxGetBitmapFromMemory(note_prev_png_16), gpApp->wxGetBitmapFromMemory(note_prev_png_22), gpApp->wxGetBitmapFromMemory(note_prev_png_32) },
        { ID_BUTTON_NEXT_NOTE, _("Next Note"), _("Jump to the next Note"), _("Go forward and open the next note"), gpApp->wxGetBitmapFromMemory(note_next_png_16), gpApp->wxGetBitmapFromMemory(note_next_png_22), gpApp->wxGetBitmapFromMemory(note_next_png_32) },
        { ID_BUTTON_DELETE_ALL_NOTES, _("Delete All Notes"), _("Delete All Notes"), _("Delete all the notes currently in the document"), gpApp->wxGetBitmapFromMemory(note_delete_all_png_16), gpApp->wxGetBitmapFromMemory(note_delete_all_png_22), gpApp->wxGetBitmapFromMemory(note_delete_all_png_32) },
        { 0, _T(""), _T(""), _T(""), wxNullBitmap, wxNullBitmap, wxNullBitmap },
        { ID_BUTTON_RESPECTING_BDRY, _("Boundaries"), _("Ignore Boundaries"), _("Ignore boundaries when making selections"), gpApp->wxGetBitmapFromMemory(bounds_stop_png_16), gpApp->wxGetBitmapFromMemory(bounds_stop_png_22), gpApp->wxGetBitmapFromMemory(bounds_stop_png_32) },
        { ID_BUTTON_SHOWING_PUNCT, _("Punctuation"), _("Hide Punctuation"), _("Don't show punctuation with the text"), gpApp->wxGetBitmapFromMemory(format_show_punctuation_png_16), gpApp->wxGetBitmapFromMemory(format_show_punctuation_png_22), gpApp->wxGetBitmapFromMemory(format_show_punctuation_png_32) },
        { 0, _T(""), _T(""), _T(""), wxNullBitmap, wxNullBitmap, wxNullBitmap },
        { ID_BUTTON_TO_END, _("End"), _("Advance to End"), _("Advance to the end of the data"), gpApp->wxGetBitmapFromMemory(go_last_png_16), gpApp->wxGetBitmapFromMemory(go_last_png_22), gpApp->wxGetBitmapFromMemory(go_last_png_32) },
        { ID_BUTTON_TO_START, _("Start"), _("Back to Start"), _("Go back to the start of the data"), gpApp->wxGetBitmapFromMemory(go_first_png_16), gpApp->wxGetBitmapFromMemory(go_first_png_22), gpApp->wxGetBitmapFromMemory(go_first_png_32) },
        { ID_BUTTON_STEP_DOWN, _("Down"), _("Move down"), _("Move down one step towards the bottom of the file"), gpApp->wxGetBitmapFromMemory(go_down_png_16), gpApp->wxGetBitmapFromMemory(go_down_png_22), gpApp->wxGetBitmapFromMemory(go_down_png_32) },
        { ID_BUTTON_STEP_UP, _("Up"), _("Move up"), _("Move back up one step towards the start of the file"), gpApp->wxGetBitmapFromMemory(go_up_png_16), gpApp->wxGetBitmapFromMemory(go_up_png_22), gpApp->wxGetBitmapFromMemory(go_up_png_32) },
        //{ ID_BUTTON_BACK, _("Back"), _("Jump back"), _("Jump back to the last active location"), gpApp->wxGetBitmapFromMemory(go_previous_png_16), gpApp->wxGetBitmapFromMemory(go_previous_png_22), gpApp->wxGetBitmapFromMemory(go_previous_png_32) },
        { ID_BUTTON_GO_TO, _("Go To"), _("Go To Reference"), _("Jump to a different reference"), gpApp->wxGetBitmapFromMemory(go_to_png_16), gpApp->wxGetBitmapFromMemory(go_to_png_22), gpApp->wxGetBitmapFromMemory(go_to_png_32) },
        { 0, _T(""), _T(""), _T(""), wxNullBitmap, wxNullBitmap, wxNullBitmap },
        { ID_BUTTON_MERGE, _("New Phrase"), _("Make a phrase"), _("Merge selected words into a phrase"), gpApp->wxGetBitmapFromMemory(phrase_new_png_16), gpApp->wxGetBitmapFromMemory(phrase_new_png_22), gpApp->wxGetBitmapFromMemory(phrase_new_png_32) },
        { ID_BUTTON_RESTORE, _("Delete Phrase"), _("Unmake A Phrase"), _("Restore selected phrase to a sequence of word objects"), gpApp->wxGetBitmapFromMemory(phrase_remove_png_16), gpApp->wxGetBitmapFromMemory(phrase_remove_png_22), gpApp->wxGetBitmapFromMemory(phrase_remove_png_32) },
        { 0, _T(""), _T(""), _T(""), wxNullBitmap, wxNullBitmap, wxNullBitmap },
        { ID_BUTTON_RETRANSLATION, _("New Retrans"), _("Do A Retranslation"), _("The selected section is a retranslation, not an adaptation"), gpApp->wxGetBitmapFromMemory(retranslation_new_png_16), gpApp->wxGetBitmapFromMemory(retranslation_new_png_22), gpApp->wxGetBitmapFromMemory(retranslation_new_png_32) },
        { ID_BUTTON_EDIT_RETRANSLATION, _("Edit Retrans"), _("Edit A Retranslation"), _("Edit the retranslation at the selection or at the active location"), gpApp->wxGetBitmapFromMemory(retranslation_edit_png_16), gpApp->wxGetBitmapFromMemory(retranslation_edit_png_22), gpApp->wxGetBitmapFromMemory(retranslation_edit_png_32) },
        { ID_REMOVE_RETRANSLATION, _("Delete Retrans"), _("Remove A Retranslation"), _("Remove the whole of the retranslation"), gpApp->wxGetBitmapFromMemory(retranslation_delete_png_16), gpApp->wxGetBitmapFromMemory(retranslation_delete_png_22), gpApp->wxGetBitmapFromMemory(retranslation_delete_png_32) },
        { 0, _T(""), _T(""), _T(""), wxNullBitmap, wxNullBitmap, wxNullBitmap },
        { ID_BUTTON_NULL_SRC_LEFT, _("... Left"), _("Insert A Placeholder to Left of Selection/PhraseBox"), _("Insert a placeholder into the source language text to the left of any selection or the phrasebox location"), gpApp->wxGetBitmapFromMemory(insplaceholder_left_png_16), gpApp->wxGetBitmapFromMemory(insplaceholder_left_png_22), gpApp->wxGetBitmapFromMemory(insplaceholder_left_png_32) },
        { ID_BUTTON_NULL_SRC_RIGHT, _("... Right"), _("Insert A Placeholder to Right of Selection/PhraseBox"), _("Insert a placeholder into the source language text to the right of any selection or the phrasebox location"), gpApp->wxGetBitmapFromMemory(insplaceholder_right_png_16), gpApp->wxGetBitmapFromMemory(insplaceholder_right_png_22), gpApp->wxGetBitmapFromMemory(insplaceholder_right_png_32) },
        { ID_BUTTON_REMOVE_NULL_SRCPHRASE, _("Delete ..."), _("Remove a Placeholder"), _("Restore selected phrase to a sequence of word objects"), gpApp->wxGetBitmapFromMemory(placeholder_delete_png_16), gpApp->wxGetBitmapFromMemory(placeholder_delete_png_22), gpApp->wxGetBitmapFromMemory(placeholder_delete_png_32) },
        { 0, _T(""), _T(""), _T(""), wxNullBitmap, wxNullBitmap, wxNullBitmap },
        { ID_BUTTON_CHOOSE_TRANSLATION, _("Choose Translation"), _("Show The Choose Translation Dialog"), _("Force the Choose Translation dialog to be shown"), gpApp->wxGetBitmapFromMemory(dialog_choose_translation_png_16), gpApp->wxGetBitmapFromMemory(dialog_choose_translation_png_22), gpApp->wxGetBitmapFromMemory(dialog_choose_translation_png_32) },
        { ID_SHOWING_ALL, _("View Mode"), _("Show Target Text Only"), _("Show target text only"), gpApp->wxGetBitmapFromMemory(show_source_target_png_16), gpApp->wxGetBitmapFromMemory(show_source_target_png_22), gpApp->wxGetBitmapFromMemory(show_source_target_png_32) },
        { ID_BUTTON_EARLIER_TRANSLATION, _("View Translations"), _("View Translation or Glosses Elsewhere in the Document"),
        _("View translation or glosses elsewhere in the document; locate them by chapter and verse"), gpApp->wxGetBitmapFromMemory(dialog_view_translation_or_glosses_png_16), gpApp->wxGetBitmapFromMemory(dialog_view_translation_or_glosses_png_22), gpApp->wxGetBitmapFromMemory(dialog_view_translation_or_glosses_png_32) },
        { ID_BUTTON_NO_PUNCT_COPY, _("Punctuation Copy"), _("No Punctuation Copy"), _("Suppress the copying of source text punctuation temporarily"), gpApp->wxGetBitmapFromMemory(punctuation_copy_png_16), gpApp->wxGetBitmapFromMemory(punctuation_copy_png_22), gpApp->wxGetBitmapFromMemory(punctuation_copy_png_32) },
        { wxID_HELP, _("Help"), _("Help"), _("Display Adapt It program help topics"), gpApp->wxGetBitmapFromMemory(help_browser_png_16), gpApp->wxGetBitmapFromMemory(help_browser_png_22), gpApp->wxGetBitmapFromMemory(help_browser_png_32) },
        { -1, _T(""), _T(""), _T(""), wxNullBitmap, wxNullBitmap, wxNullBitmap },
    };

    // set the toolbar size
    if (m_toolbarSize == btnLarge)
    {
        pAuiToolbar->SetToolBitmapSize(wxSize(32, 32));
    }
    else if (m_toolbarSize == btnMedium)
    {
        pAuiToolbar->SetToolBitmapSize(wxSize(22, 22));
    }
    else
    {
        pAuiToolbar->SetToolBitmapSize(wxSize(16, 16));
    }

    // set the toolbar style
    long lStyle = pAuiToolbar->GetWindowStyleFlag();
    // if the style needs changing...
    if ((m_bShowToolbarIconAndText) != (lStyle & wxAUI_TB_TEXT))
    {
        // use bitwise xor to toggle the wxAUI_TB_TEXT style bit
        lStyle ^= wxAUI_TB_TEXT;
    }
    pAuiToolbar->SetWindowStyleFlag(lStyle);

    // loop through the tbInfo array and add the toolbar buttons / separators for the current user profile
    while (tbInfo[index].toolId != -1)
    {
        // is this a separator?
        if (tbInfo[index].toolId == 0)
        {
            // separator -- did we just add one?
            if (!bJustAddedSeparator)
            {
                // didn't just add one -- add this one and set our flag
                pAuiToolbar->AddSeparator();
                bJustAddedSeparator = true;
            }
        }
        else if (m_bToolbarButtons[index] == false)
        {
            ; // don't display this button
        }
        else if ((m_nWorkflowProfile == 0) || (ToolBarItemIsVisibleInThisProfile(m_nWorkflowProfile, tbInfo[index].longHelpString)))
        {
            // this toolbar item is visible in this profile -- add it to the toolbar
            // get the right bitmap
            switch (m_toolbarSize)
            {
            case btnLarge:
            {
                bmp = tbInfo[index].bmpLarge;
            }
                break;
            case btnMedium:
            {
                bmp = tbInfo[index].bmpMedium;
            }
                break;
            case btnSmall:
            default:
            {
                bmp = tbInfo[index].bmpSmall;
            }
                break;
            } // end of switch (m_toolbarSize)

            // add the toolbar item
            pAuiToolbar->AddTool(tbInfo[index].toolId, tbInfo[index].label, bmp,
                wxNullBitmap, wxITEM_NORMAL, tbInfo[index].shortHelpString, tbInfo[index].longHelpString, NULL);
            // reset the separator flag (we just added a button -- it's ok to add a separator now)
            bJustAddedSeparator = false;
        }
        // fetch the next item
        index++;
    }

    // Done adding the buttons -- now tell the UI to update itself
    pAuiToolbar->Realize();
    // find the toolbar height, so we can figure out the rest of the canvas dimensions in OnSize()
    wxSize auitbSize;
    auitbSize = pAuiToolbar->GetSize();
    pMainFrame->m_toolBarHeight = pMainFrame->m_auitbHeight = auitbSize.GetHeight();
    // whm added 7Jan12 set toolBar visibility according to basic config
    // file setting - as stored in the App's m_bToolBarVisible member
    if (m_bToolBarVisible)
        m_pMainFrame->m_auiMgr.GetPane(_T("auiToolbar")).Show();
    else
        m_pMainFrame->m_auiMgr.GetPane(_T("auiToolbar")).Hide();
    // unfreeze the UI and call OnSize()
    pMainFrame->Thaw();
    pMainFrame->SendSizeEvent();
}


//////////////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \remarks
/// Called from: the App's ConfigureInterfaceForUserProfile().
/// This function sets the value of m_bShowNewProjectItem to FALSE if the <New Project> user
/// profile item's itemVisibility attribute for the current profile is set to "0"; otherwise
/// sets the value of m_bShowNewProjectItem to TRUE. The CProjectPage class uses the App's
/// m_bShowNewProjectItem flag to include <New Project> as the first item in the page's
/// list of projects, or omit it from the list.
//////////////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItApp::ConfigureWizardForUserProfile()
{
    // we assume that a mode bar item is visible unless the m_pUserProfiles data
    // indicates otherwise.
    if (NewProjectItemIsVisibleInThisProfile(m_nWorkflowProfile))
    {
        m_bShowNewProjectItem = TRUE;
    }
    else
    {
        m_bShowNewProjectItem = FALSE;
    }
}

//////////////////////////////////////////////////////////////////////////////////////////
/// \return    TRUE if the "<New Project>" item is supposed to be visible in this nProfile,
///                 FALSE otherwise
/// \param      -> nProfile   the user workflow profile (zero based), i.e., m_nWorkflowProfile
///                     i.e., the tooltip
/// \remarks
/// Called from: the App's ConfigureWizardForUserProfile().
/// Determines whether the "<New Project>" item is supposed to be visible in
/// the interface for the user profile passed in as nProfile. Looks up the itemLabel in
/// the m_pUserProfiles data struct stored on the heap and reads the usedVisibilityValues
/// for that item as indexed for the nProfile.
//////////////////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItApp::NewProjectItemIsVisibleInThisProfile(const int nProfile)
{
    bool bItemIsVisible = TRUE;
    if (nProfile == 0)
    {
        // The work flow profile 0 (zero) is the "None" selection and all interface
        // items are visible by default
        return bItemIsVisible;
    }
    int ct;
    int totct;
    totct = (int)m_pUserProfiles->profileItemList.GetCount();
    for (ct = 0; ct < totct; ct++)
    {
        UserProfileItem* pUserProfileItem;
        ProfileItemList::Node* node;
        node = m_pUserProfiles->profileItemList.Item(ct);
        pUserProfileItem = node->GetData();
        wxASSERT(pUserProfileItem != NULL);
        if (pUserProfileItem->itemType != _T("wizardListItem"))
        {
            continue;
        }
        wxString itemLabelStr;
        itemLabelStr = pUserProfileItem->itemText;
        itemLabelStr.Trim(FALSE);
        itemLabelStr.Trim(TRUE);
        int indexFromProfile = 0;
        if (nProfile <= 0)
            indexFromProfile = 0;
        else if (nProfile > 0)
            indexFromProfile = nProfile - 1;
        if (itemLabelStr == _("<New Project>") && pUserProfileItem->usedVisibilityValues.Item(indexFromProfile) == _T("0"))
        {
            return FALSE;
        }
    }
    return bItemIsVisible;
}

//////////////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \param      progMenuMode -> an enum which can be: collabNotAvailableNormal, collabAvailableTurnedOn,
///                             collabAvailableTurnedOff, or collabAvailableReadOnlyOn
/// \remarks
/// Called from: the App's OnInit(), OnEditUserMenuSettingsProfiles(), and from the
/// CSetupEditorCollaboration::OnOK() handler.
/// Makes the following adjustments to AI menus:
/// 1. Adds parenthetical info in the Open... and Save menu labels of the File menu
///    when collaboration with Paratext or Bibledit is ON, removes the parenthetical
///    material when PT/BE collaboration is OFF.
/// 2. Displays or removes the top-level Administrator menu depending on the current
///    value of the App's m_bShowAdministratorMenu flag.
/// 3. Adjusts the Administrator menu's "Setup %s Collaboration" menu item to include
///    "Paratext" or "Bibledit" within its label substituted for %s.
/// 4. Make menu accelerator key adjustments required for the different platform's
///    needs - some platforms reserve certain accelerator keys for their own system
///    use.
/// 5. Remove the Layout menu if building for ANSI version (leave it for Unicode
///    version).
/// 6. Adjust the accelerator key for the Mac platform for the Layout menu's item.
/// 7. Set toggle menu items to reflect the current values of their GUI flags.
/// some menu labels and hot key assignments for the different platforms -
/// different platforms reserve certain hot key combinations for their own system use.
/// Adjustments are also made here for certain modes such as Paratext/Bibledit collaboration.
/// This function also sets the initial checked/unchecked state of menu items which are
/// checkable.
/// whm 14Aug2023 revised to remove Ctrl-Shift-E as accelerator on Mac version for Edit Source Text... 
//////////////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItApp::MakeMenuInitializationsAndPlatformAdjustments() //(enum ProgramMenuMode progMenuMode)
{
    CMainFrame* pMainFrame = GetMainFrame();
    wxMenuBar* pMenuBar = pMainFrame->GetMenuBar();
    // Get the File Menu
    wxMenu* pFileMenu;
    pFileMenu = GetTopLevelMenuFromAIMenuBar(fileMenu);

    // Make adjustments on the Windows platform for when Paratext or Bibledit
    // collaboration is in effect. We modify the labels for Open... and Save...
    // on the File menu to include parenthetical explanations as follows:
    // Open... (Get Source Text From Paratext) or Open... (Get Source Text From Bibledit)
    // Save (Transfer Translation Draft To Paratext) or Save... (Transfer Translation Draft To Bibledit)
    // Note: We do not need conditional define here for Windows because
    // m_bCollaboratingWithParatext or m_bCollaboratingWithBibledit will
    // only be TRUE on the platforms that host Paratext, i.e., Windows, or Bibledit,
    // i.e., Linux or the Mac.
    if (pFileMenu != NULL)
    {
        // whm 1Oct12 removed all MRU code

        // The Open... and Save... commands have a tabbed hot key which we have to move to the right end of
        // the new label, otherwise everything that comes after the tab will be displaced to the right side
        // of the File menu (right aligned).
        wxString label;
        wxString defaultMenuLabel;
        wxString labelFromPT;
        wxString labelFromBE;
        // For wxID_OPEN add parenthetical infor during collaboration
        label = pFileMenu->GetLabel(wxID_OPEN);
        // whm added 28Jul11. Remove any initial underscore characters that seem
        // to creep in in the Linux implementation of GetLabel()
        //while (label.Find(_T('_')) == 0)
        //{
        //	label.Remove(0,1);
        //}
        // whm revised 30Dec11. On Linux the label for wxID_OPEN doesn't have the tab and shortcut
        // key indicated. Therefore, I'm going to handle the entire label string when doing
        // adjustments for indicating the Paratext/Bibledit parenthetical material for Open and
        // Save.
        defaultMenuLabel = _("&Open...\tCtrl-O"); // must be same as in wxDesigner resource
        labelFromPT = _("&Open... (Get Source Text From Paratext)\tCtrl-O");
        labelFromBE = _("&Open... (Get Source Text From Bibledit)\tCtrl-O");
        // whm modified 22Aug14. When a project is closed, we preserve the existing values of
        // m_bCollaboratingWithParatext and m_bCollaboratingWithBibledit so that the last
        // option that was selected in the CollabOptionsDlg would still be selected. This is
        // more often desired since after a Close>Project command, the user would most likely
        // want to open the same project or another one that was at some time set up for
        // collaboration. That being said, we need to remove the parenthetical material here
        // when m_bStartWorkUsingCollaboration is set to FALSE, which happens upon a Close
        // Project situation. Otherwise, when a user selects a non-collaboration project
        // after a Project>Close, the parenthetical material would still be appended to the
        // menu item.
        if (m_bCollaboratingWithParatext)
        {
            if (m_bStartWorkUsingCollaboration == FALSE)
                label = defaultMenuLabel;
            else
                label = labelFromPT;
        }
        else if (m_bCollaboratingWithBibledit)
        {
            if (m_bStartWorkUsingCollaboration == FALSE)
                label = defaultMenuLabel;
            else
                label = labelFromBE;
        }
        else
        {
            label = defaultMenuLabel;
        }
        label.Trim(TRUE);
        label.Trim(FALSE);
        pFileMenu->SetLabel(wxID_OPEN, label);

        // For wxID_SAVE add parenthetical infor during collaboration
        label = pFileMenu->GetLabel(wxID_SAVE);
        // whm added 28Jul11. Remove any initial underscore characters that seem
        // to creep in in the Linux implementation of GetLabel()
        //while (label.Find(_T('_')) == 0)
        //{
        //	label.Remove(0,1);
        //}
        // whm modified 22Aug14. See comment above for the Open menu item. Same goes for
        // the Save menu item here.
        defaultMenuLabel = _("&Save\tCtrl-S"); // must be same as in wxDesigner resource
        labelFromPT = _("&Save (Transfer Translation Draft To Paratext)\tCtrl-S");
        labelFromBE = _("&Save (Transfer Translation Draft To Bibledit)\tCtrl-S");
        if (m_bCollaboratingWithParatext)
        {
            if (m_bStartWorkUsingCollaboration == FALSE)
                label = defaultMenuLabel;
            else
                label = labelFromPT;
        }
        else if (m_bCollaboratingWithBibledit)
        {
            if (m_bStartWorkUsingCollaboration == FALSE)
                label = defaultMenuLabel;
            else
                label = labelFromBE;
        }
        else
        {
            label = defaultMenuLabel;
        }
        label.Trim(TRUE);
        label.Trim(FALSE);
        pFileMenu->SetLabel(wxID_SAVE, label);
    }

    // Initialize the pToolsMenu pointer here - it is referenced in different blocks below
    wxMenu* pToolsMenu;
    pToolsMenu = GetTopLevelMenuFromAIMenuBar(toolsMenu);

    // remove the Administrator menu until asked for
    if (!m_bShowAdministratorMenu)
    {
        // is the Admin menu showing? If so, remove it
        if (!m_bAdminMenuRemoved)
        {
            // whm Note: Bruce designed the Administrator menu item to be
            // deleted in the CMainFrame's destructor rather than when it
            // is "Removed" here.

			// BEW 11Oct19, control goes here when the Administrator menu
			// is being shut down - so here, before anything else happens,
			// I need to get the Administrator menu while still open, test
			// for my added developer menu item being present, and if so,
			// delete it
			{ // isolate this bit of code
				int ID_MENU_ITEM_HIDDEN = 9999;
				//CMainFrame* pMainFrame = GetMainFrame();
				//wxMenuBar* pMenuBar = pMainFrame->GetMenuBar();
				// Get the Administrator Menu
				wxMenu* pAdminMenu = GetTopLevelMenuFromAIMenuBar(administratorMenu);
				if (pAdminMenu != NULL)
				{
					wxMenuItem* pDevMenuItem = pAdminMenu->FindChildItem(ID_MENU_ITEM_HIDDEN);
					if (pDevMenuItem != NULL)
					{
						bool bDestroyed = pAdminMenu->Destroy(pDevMenuItem);
						wxUnusedVar(bDestroyed);
					}
				}
			}

            int menuCount = pMenuBar->GetMenuCount();
            m_adminMenuTitle = pMenuBar->GetMenuLabelText(menuCount - 1);
            m_pRemovedAdminMenu = pMenuBar->Remove(menuCount - 1);
            m_bAdminMenuRemoved = TRUE;
        }
        pMenuBar->Refresh();
    }
    else
    {
        // is the Admin menu hidden? If so, Append it back to the pMenuBar
        if (m_bAdminMenuRemoved)
        {
            bool bAppendedOK;
            bAppendedOK = pMenuBar->Append(m_pRemovedAdminMenu, m_adminMenuTitle);
            wxASSERT(bAppendedOK);
            wxCHECK_RET(bAppendedOK, _T("MakeMenuInitializationsAndPlatformAdjustments() failed in m_bAdminMenuRemoved == TRUE block"));
            m_pRemovedAdminMenu = NULL;
            m_bAdminMenuRemoved = FALSE;
        }
        pMenuBar->Refresh();
    }

    // Format the "Setup %s Collaboration..." menu item for Paratext or Bibledit
    wxMenu* pAdministratorMenu;
    pAdministratorMenu = GetTopLevelMenuFromAIMenuBar(administratorMenu);
    if (pAdministratorMenu != NULL)
    {
        wxString label;
        // wxMenu::GetLabel() gets menu item label including any mnemonics and
        // accelerators.
        label = pAdministratorMenu->GetLabel(ID_SETUP_EDITOR_COLLABORATION);
        // whm added 28Jul11. Remove any initial underscore characters that seem
        // to creep in in the Linux implementation of GetLabel()
        while (label.Find(_T('_')) == 0)
        {
            label.Remove(0, 1);
        }
        pAdministratorMenu->SetLabel(ID_SETUP_EDITOR_COLLABORATION, label);
    }

    // MAKE MENU ACCELERATOR KEY ADJUSTMENTS REQUIRED FOR THE DIFFERENT PLATFORMS
    // See also the CMainFrame::CMainFrame constructor where accelerator key assignments
    // are made to coordinate with these menu hot key adjustments.
#if defined (__WXMAC__) || defined(__WXGTK__)
    // whm Added 11Feb09: We have to adjust the menu access keys for the wxMac port to keep
    // them from conflicting with the customary Mac access keys and accelerator keys. The
    // accelerator keys are created during the creation of the CMainFrame above, so we can
    // make adjustments here.

    // File | Start Working...
    // On Mac and Ubuntu Linux (Gnome/Gtk), Command-W is reserved for Closing the Active
    // Window, so we've defined the accelerator key on Mac for "Start Working..." as
    // Command-Shift-O, and on Linux as Ctrl-Shift-O, to avoid the conflict.
    if (pFileMenu != NULL)
    {
        pFileMenu->SetLabel(ID_FILE_STARTUP_WIZARD, _("Start Working...\tCtrl-Shift-O")); // Windows
                                                                                          // & Linux have the default Ctrl-W
    }

    // whm Added 29March2017 - remove the "Install the Git program..." menu item for Mac and Linux
    // since Git should be installed on those platforms easily enough when Adapt It is installed
    if (pToolsMenu != NULL)
    {
        // The "Install the Git program..." menu item on the Tools menu
        // should be hidden/removed for platforms other than Windows
        if (pToolsMenu->FindItem(ID_TOOLS_INSTALL_GIT) != NULL)
        {
            pToolsMenu->Remove(ID_TOOLS_INSTALL_GIT);
        }
    }

#endif

#ifdef __WXMAC__
    // File | Close Project
    // On Mac, Command-J is reserved for Scroll/Jump to a Selection on the Mac. We've used
    // it on Windows/Linux for Close Project, but the comperable hot key to close the
    // active window for Mac is Command-W.
    // Note: On Linux/wxGTK, Ctrl-W is automatically assigned to the File | Close
    // (wxID_CLOSE) menu item.
    if (pFileMenu != NULL)
    {
        if (pFileMenu->FindItem(ID_FILE_CLOSEKB) != NULL)
        {
            pFileMenu->SetLabel(ID_FILE_CLOSEKB, _("Close Project\tCtrl-W")); // Windows
                                                                              // and Linux have the default Ctrl-J
        }
    }

    // File | Exit
    // On Mac, Command-Q is reserved for Quitting the Application on the Mac. We've used it on
    // Windows/Linux for Edit menu's Edit Source Text..., so for Quitting the application we'll
    // assign a Ctrl-Q as hot key to associate with the Exit menu command here.
    if (pFileMenu != NULL)
    {
        wxMenuItem* pFileExitItem;
        pFileExitItem = pFileMenu->FindItem(wxID_EXIT);
        if (pFileExitItem != NULL)
        {
            pFileExitItem->SetItemLabel(_("Quit\tCtrl-Q")); //pFileMenu->SetLabel(wxID_EXIT,_("Exit\tCtrl-Q"));
        }
    }

    wxMenu* pEditMenu = GetTopLevelMenuFromAIMenuBar(editMenu);
    if (pEditMenu != NULL)
    {
        // Edit | Edit Source Text
        // On Mac, the hot key command to quit the application is Command-Q and we have set a
        // Ctrl-Q accelerator key to be associated with wxID_Exit, so we've set the menu to use
        // Ctrl-Shift-E for Edit Source Text here.
        // whm 14Aug2023 modified block below. We no longer have an accelerator key for Edit Source
        // Text..., so I've removed the "\tCtrl-Shift-E" part of the "Edit Source Text..." label.
        if (pEditMenu->FindItem(ID_EDIT_SOURCE_TEXT) != NULL)
        {
            pEditMenu->SetLabel(ID_EDIT_SOURCE_TEXT, _("Edit Source Text..."));
        }

        // Edit | Move Note Backward
        // On Mac, the hot key command to View as List is Command-2 and we have set a Ctrl-Shift-2
        // accelerator key to be associated with Edit | Move Note Backward, so we've set the menu to
        // use Ctrl-Shift-2 for it here.
        if (pEditMenu->FindItem(ID_EDIT_MOVE_NOTE_BACKWARD) != NULL)
        {
            pEditMenu->SetLabel(ID_EDIT_MOVE_NOTE_BACKWARD, _("Move Note Backward\tCtrl-Shift-2"));
        }

        // Edit | Move Note Forward
        // On Mac, the hot key command to View as Columns is Command-3 and we have set a Ctrl-Shift-3
        // accelerator key to be associated with Edit | Move Note Forward, so we've set the menu to
        // use Ctrl-Shift-3 for it here.
        if (pEditMenu->FindItem(ID_EDIT_MOVE_NOTE_FORWARD) != NULL)
        {
            pEditMenu->SetLabel(ID_EDIT_MOVE_NOTE_FORWARD, _("Move Note Forward\tCtrl-Shift-3"));
        }
    }

    // The pToolsMenu pointer is established above
    //wxMenu* pToolsMenu = GetTopLevelMenuFromAIMenuBar(toolsMenu);
    if (pToolsMenu != NULL)
    {
        // Tools | Find and Replace
        // On Mac, the hot key command to Hide the Active Window (close) is Command-H, and we have set a
        // Ctrl-Shift-F accelerator key to be associated with Edit | Find and Replace, so we've set the
        // menu to use Ctrl-Shift-F for it here.
        if (pToolsMenu->FindItem(wxID_REPLACE) != NULL)
        {
            pToolsMenu->SetLabel(wxID_REPLACE, _("Find and Replace...\tCtrl-Shift-F"));
        }
    }

    wxMenu* pLayoutMenu = GetTopLevelMenuFromAIMenuBar(layoutMenu);
    if (pLayoutMenu != NULL)
    {
        // Layout | Layout Window Right To Left
        // On Mac, the hot key command to View as Icons is Command-1, and we have set a Ctrl-Shift-1
        // accelerator key to be associated with Layout | Layout Window Right To Left, so we've set the
        // menu to use Ctrl-Shift-1 for it here.
        if (pLayoutMenu->FindItem(ID_ALIGNMENT) != NULL)
        {
            pLayoutMenu->SetLabel(ID_ALIGNMENT, _("Layout Window Right To Left\tCtrl-Shift-1"));
        }
    }

    // wxWidgets moves the wxID_HELP menu item from the Help menu to the Application menu, so we
    // don't assume wxID_HELP is in the Help menu.
    wxMenuItem* pHelpTopicsMenu = (wxMenuItem*)pMenuBar->FindItem(wxID_HELP); // use FindItem() for wxMenuItem
    if (pHelpTopicsMenu != NULL)
    {
        pHelpTopicsMenu->SetItemLabel(_("Help Topics\tCtrl-Shift-/"));
    }

#else
    // wxDesigner's Menubars properties doesn't allow us to set function keys as shortcuts
    // so we'll do it manually here for Windows and Linux.
    wxMenuItem* pHelpTopicsMenu = (wxMenuItem*)pMenuBar->FindItem(wxID_HELP);
    if (pHelpTopicsMenu != NULL)
    {
        pHelpTopicsMenu->SetItemLabel(_("Help Topics\tF1"));
    }

#endif

    // The wxWidgets version has the "Export Target Text As UTF-8..." Menu Item on
    // the File Menu and the Layout Menu as a top level menu in the AIMenuBarFunc() menu
    // resource. With wxDesigner handling resources, it's easier to start with the item
    // in the menu and programmatically delete it, rather than create it from scratch.
    // So, for ANSI version, we'll just remove them from the MenuBar.
#ifndef _UNICODE
    // ANSI only
    // In the wx version we started with the Layout menu loaded with
    // other menu resources. Here we'll remove it for the ANSI version.
    wxMenu* pLayoutMenu = GetTopLevelMenuFromAIMenuBar(layoutMenu);
    if (pLayoutMenu != NULL)
    {
        // first delete the "Layout Window Right To Left\tCTRL+1" menu item
        // Note: In the current profile, this item may not exist, so only
        // call Remove if it exists!
        if (pLayoutMenu->FindItem(ID_ALIGNMENT) != NULL)
        {
            wxMenuItem* pRemMenuItem;
            pRemMenuItem = pLayoutMenu->Remove(ID_ALIGNMENT);
            wxASSERT(pRemMenuItem != NULL);
            delete pRemMenuItem; // to avoid memory leaks
            pRemMenuItem = (wxMenuItem*)NULL;
        }
        // then delete the top level "Layout" menu
        wxMenu* pRemMenu;
        pRemMenu = pMenuBar->Remove(layoutMenu);
        wxASSERT(pRemMenu != NULL);
        if (pRemMenu != NULL) // whm 11Jun12 added NULL test
            delete pRemMenu; // to avoid memory leaks
        pRemMenu = (wxMenu*)NULL;
    }
#else
    // Unicode version

    // Initialize the Layout menu to LTR
    CAdapt_ItView* pView = GetView();
    gbLTRLayout = TRUE;
    gbRTLLayout = FALSE; // default is LTR layout
    if (gpApp->m_bSrcRTL == TRUE && gpApp->m_bTgtRTL == TRUE)
    {
        gbLTRLayout = FALSE; // use these to set layout direction on user's behalf, when possible
        gbRTLLayout = TRUE;
    }
    else if (gpApp->m_bSrcRTL == FALSE && gpApp->m_bTgtRTL == FALSE)
    {
        gbLTRLayout = TRUE; // use these to set layout direction on user's behalf, when possible
        gbRTLLayout = FALSE;
    }
    if (pView != NULL)
    {
        pView->AdjustAlignmentMenu(gbRTLLayout, gbLTRLayout); // fix the menu, if necessary
        // Note: AdjustAlignmentMenu above also sets the m_bRTL_Layout to match gbRTL_Layout
    }

#endif

    // These toggle menu items should be initially set as follows (TRUE=checked;
    // FALSE=unchecked):
    // whm modified 28Jul11. This MakeMenuInitializationsAndPlatformAdjustments()
    // function can now be called from places other than from OnInit(). Therefore,
    // the menu toggle items below should be set not to absolute initial values
    // but to values that reflect the current state of the GUI elements they
    // describe.
    if (pMenuBar->FindItem(ID_VIEW_TOOLBAR) != NULL)
        pMenuBar->Check(ID_VIEW_TOOLBAR, m_bToolBarVisible); // whm modified 6Jan12
    if (pMenuBar->FindItem(ID_VIEW_STATUS_BAR) != NULL)
        pMenuBar->Check(ID_VIEW_STATUS_BAR, m_bStatusBarVisible); // whm modified 6Jan12
    if (pMenuBar->FindItem(ID_VIEW_COMPOSE_BAR) != NULL)
        pMenuBar->Check(ID_VIEW_COMPOSE_BAR, pMainFrame->m_pComposeBar != NULL);
    if (pMenuBar->FindItem(ID_VIEW_MODE_BAR) != NULL)
        pMenuBar->Check(ID_VIEW_MODE_BAR, this->m_bModeBarVisible); // whm added 6Jan12
    if (pMenuBar->FindItem(ID_COPY_SOURCE) != NULL)
        pMenuBar->Check(ID_COPY_SOURCE, m_bCopySource);
    if (pMenuBar->FindItem(ID_SELECT_COPIED_SOURCE) != NULL) // whm 2Aug2018 added
        pMenuBar->Check(ID_SELECT_COPIED_SOURCE, m_bSelectCopiedSource);
    if (pMenuBar->FindItem(ID_MARKER_WRAPS_STRIP) != NULL)
        pMenuBar->Check(ID_MARKER_WRAPS_STRIP, m_bMarkerWrapsStrip);
    if (pMenuBar->FindItem(ID_USE_CC) != NULL)
        pMenuBar->Check(ID_USE_CC, m_bUseConsistentChanges);
    if (pMenuBar->FindItem(ID_ACCEPT_CHANGES) != NULL)
        pMenuBar->Check(ID_ACCEPT_CHANGES, m_bAcceptDefaults);
    if (pMenuBar->FindItem(ID_USE_SILCONVERTER) != NULL) // whm added 28Jul11
        pMenuBar->Check(ID_USE_SILCONVERTER, m_bUseSilConverter);
    if (pMenuBar->FindItem(ID_TOOLS_AUTO_CAPITALIZATION) != NULL) // whm added 28Jul11
        pMenuBar->Check(ID_TOOLS_AUTO_CAPITALIZATION, gbAutoCaps);
    if (pMenuBar->FindItem(ID_ADVANCED_SEE_GLOSSES) != NULL)
        pMenuBar->Check(ID_ADVANCED_SEE_GLOSSES, gbGlossingVisible);
    if (pMenuBar->FindItem(ID_ADVANCED_GLOSSING_USES_NAV_FONT) != NULL)
        pMenuBar->Check(ID_ADVANCED_GLOSSING_USES_NAV_FONT, gbGlossingUsesNavFont);
    if (pMenuBar->FindItem(ID_ADVANCED_BOOKMODE) != NULL) // whm added 28Jul11
        pMenuBar->Check(ID_ADVANCED_BOOKMODE, m_bBookMode);
    if (pMenuBar->FindItem(ID_ADVANCED_FREE_TRANSLATION_MODE) != NULL) // whm added 28Jul11
        pMenuBar->Check(ID_ADVANCED_FREE_TRANSLATION_MODE, m_bFreeTranslationMode);
    if (pMenuBar->FindItem(ID_ADVANCED_TARGET_TEXT_IS_DEFAULT) != NULL) // whm added 28Jul11
        pMenuBar->Check(ID_ADVANCED_TARGET_TEXT_IS_DEFAULT, m_bTargetIsDefaultFreeTrans);
    if (pMenuBar->FindItem(ID_ADVANCED_GLOSS_TEXT_IS_DEFAULT) != NULL) // whm added 28Jul11
        pMenuBar->Check(ID_ADVANCED_GLOSS_TEXT_IS_DEFAULT, m_bGlossIsDefaultFreeTrans);
    if (pMenuBar->FindItem(ID_ADVANCED_USETRANSLITERATIONMODE) != NULL) // whm added 28Jul11
        pMenuBar->Check(ID_ADVANCED_USETRANSLITERATIONMODE, m_bTransliterationMode);
    if (pMenuBar->FindItem(ID_ADVANCED_SENDSYNCHRONIZEDSCROLLINGMESSAGES) != NULL) // whm added 28Jul11
        pMenuBar->Check(ID_ADVANCED_SENDSYNCHRONIZEDSCROLLINGMESSAGES, !m_bIgnoreScriptureReference_Send);
    if (pMenuBar->FindItem(ID_ADVANCED_RECEIVESYNCHRONIZEDSCROLLINGMESSAGES) != NULL) // whm added 28Jul11
        pMenuBar->Check(ID_ADVANCED_RECEIVESYNCHRONIZEDSCROLLINGMESSAGES, !gbIgnoreScriptureReference_Receive);
    // whm added 20Jul11 to initialize the View menu's "Show Administrator Menu... (Password protected)" item
    if (pMenuBar->FindItem(ID_VIEW_SHOW_ADMIN_MENU) != NULL)
        pMenuBar->Check(ID_VIEW_SHOW_ADMIN_MENU, m_bShowAdministratorMenu);
    if (pMenuBar->FindItem(ID_MENU_TEMP_TURN_OFF_CURRENT_PROFILE) != NULL)
        pMenuBar->Check(ID_MENU_TEMP_TURN_OFF_CURRENT_PROFILE, m_bTemporarilyRestoreProfilesToDefaults); // whm added 14Feb12
            //if (pMenuBar->FindItem(ID_PASSWORD_PROTECT_COLLAB_SWITCHING) != NULL) // whm added 2Feb12
            //	pMenuBar->Check(ID_PASSWORD_PROTECT_COLLAB_SWITCHING,m_bPwdProtectCollabSwitching);
            // ensure that the Use Tooltips menu item in the Help menu is checked or unchecked
            // according to the current value of m_bUseToolTips
    if (pMenuBar->FindItem(ID_HELP_USE_TOOLTIPS) != NULL)
        pMenuBar->Check(ID_HELP_USE_TOOLTIPS, m_bUseToolTips);
}

// This menu item, Change Username, on the Edit menu, lets the user edit or type afresh a
// (hopepfully unique) username for use by the DVCS and / or KB Sharing features (and
// anything else which later may require a username within secure data or secure data
// transfers), and in a second text control, a human-friendly fullname (which can be a
// pseudonom) to enable easy identification of the human contributing the data. These are
// stored on the app as m_strUserID for the former, and m_strFullname for the latter.
// If m_strUserID or m_strFullname is empty when the user tries to use DVCS or KB Sharing,
// the utility function in helpers.cpp, CheckUsername() will detect the problem and force
// the UsernameInputDlg open so the user can type in whatever is appropriate - the dialog
// won't allow itself to be dismissed until there is something in both checkboxes. But if
// both names are defined, and the user wants to change one, it's not possible to do so
// without a GUI widget that acts to get the UsernameInputDlg open; so that's what this
// menu command is for. It's the only place to change the names, other than directly
// editing the basic config file. (Or changing m_strFullname from the KB Sharing Mgr)
void CAdapt_ItApp::OnEditChangeUsername(wxCommandEvent& WXUNUSED(event))
{
    UsernameInputDlg dlg((wxWindow*)GetMainFrame());
    dlg.Center();
    if (dlg.ShowModal() == wxID_OK)
    {
        m_strUserID = dlg.m_finalUsername;
        m_strFullname = dlg.m_finalInformalUsername;
        wxASSERT(!m_strPassword.IsEmpty());
        // BEW 15Mar24, OnOk() has already saved the user's password in 3rd box, to app->m_strPassword
        wxString aPwd = wxEmptyString;
        CMainFrame* pFrame = this->GetMainFrame();
        aPwd = pFrame->GetKBSvrPassword();       
        wxASSERT(aPwd == m_strPassword);
        pFrame->SetKBSvrPassword(m_strPassword); // ensure MainFrm stores correct value, as other funcs will grab it
        // BEW comment 16Mar24: dlg.m_finalPassword is empty, didn't expect that, but pApp->m_strPassword has accepted
        // the user's type value and copied it to pFrame's SetKBSvrPassword() accessor, so I use that value

        // whm added 24Oct13. Save the UniqueUsername and InformalUsername
        // Note: The code block here should be the same as in helpers.cpp's
        // CheckUsername().
        // values in the Adapt_It_WX.ini (.Adapt_It_WX) file for safe keeping
        // and the ability to restore these values if the user does a Shift-Down
        // startup of the application to reset the basic config file values.
        bool bWriteOK = FALSE;
        wxString oldPath = m_pConfig->GetPath(); // is always absolute path "/Recent_File_List"
        m_pConfig->SetPath(_T("/Usernames"));
        // We want even a null string value for the UniqueUsername and InformalUsername strings
        // to be saved in Adapt_It_WX.ini.
        { // block for wxLogNull
            wxLogNull logNo; // eliminates spurious message from the system
            bWriteOK = m_pConfig->Write(_T("unique_user_name"), m_strUserID);
            if (!bWriteOK)
            {
                wxMessageBox(_T("OnEditChangeUsername() m_pConfig->Write() of m_strUserID returned FALSE, processing will continue, but save, shutdown and restart would be wise"));
            }
            bWriteOK = m_pConfig->Write(_T("informal_user_name"), m_strFullname);
            if (!bWriteOK)
            {
                wxMessageBox(_T("OnEditChangeUsername() m_pConfig->Write() of m_strFullname returned FALSE, processing will continue, but save, shutdown and restart would be wise"));
            }
            m_pConfig->Flush(); // write now, otherwise write takes place when m_pConfig is destroyed in OnExit().
        }
        // restore the oldPath back to "/Recent_File_List"
        m_pConfig->SetPath(oldPath);

    }
    else
    {
        // user cancelled, so do nothing
        ;
    }
}

//////////////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \remarks
/// Called from: the App's OnInit() after the external XML file AI_UserProfiles.xml has
/// been successfully read. This function does not re-read the raw data from the
/// arrays nor the external file, but "reads" the data from the pTempUserProfiles and
/// m_pUserProfiles created on the heap. The pTempUserProfiles is created by the
/// SetupDefaultUserProfiles() function from the internal unix-like default strings.
/// It then reports any inconsistencies to the developer in the form of wxLogDebug()
/// outputs for each inconsistency found. It only displays the wxLogDebug messages
/// and a few wxASSERT_MSG() messages in debug mode, so this function doesn't issue
/// any messages to the user in the release version; it merely exists to help the
/// developer know of any inconsistencies and what they are.
//////////////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItApp::ReportMenuAndUserProfilesInconsistencies()
{
    // get temporary data structures from the internal unix-like strings
    UserProfiles* pTempUserProfiles; // destroyed at end of this function
    pTempUserProfiles = (UserProfiles*)NULL;

    SetupDefaultUserProfiles(pTempUserProfiles); // creates a new UserProfiles on heap pointed to by pTempUserProfiles; calls GetAndAssignIdValuesToUserProfilesStruct()

                                                 // First make sure we have good pointers
    if (pTempUserProfiles == NULL)
    {
        wxLogDebug(_T("The pointer to the internal UserProfiles is NULL\n -   aborting the ReportMenuAndUserProfilesInconsistencies() function"));
        return;
    }
    if (m_pUserProfiles == NULL)
    {
        wxLogDebug(_T("The pointer to the App's m_pUserProfiles is NULL\n -   aborting the ReportMenuAndUserProfilesInconsistencies() function"));
        return;
    }

    // compare the profile version
    // Note: When an administrator customizes a given profile we expect that the following things
    // will be different between our internal values and the external xml file:
    //    1. The adminModified attribute will have the value of "Yes".
    //    2. The usedVisibilityValues changed when an admin edits the profiles and clicks OK, regardless of
    //       whether the edits were done to the currently selected profile.
    //    3. The descriptionProfileTexts. These are editable by the admin.
    // Note: The definedProfileNames would not normally be edited unless the admin manually
    // attempts to change or localize the names of the profiles/tabs.

    bool bVersionsDiffer = FALSE;
    // we need to ensure that the app's version (6.x.x) and the app's profile version (1.x)
    // agree with the data in the unix-like default strings (here it is in pTempUserProfiles).
    wxString appVerOfRunningApp = GetAppVersionOfRunningAppAsString();
    wxString profVerOfRunningApp = GetProfileVersionOfRunningAppAsString();
    if (pTempUserProfiles->profileVersion != profVerOfRunningApp)
    {
        bVersionsDiffer = TRUE;
        wxString msg;
        msg = _T("The app's defaultProfileItems[] and the app's PROFILE_VERSION_MAJOR_PART.PROFILE_VERSION_MINOR_PART have different profile versions %s and %s PLEASE FIX ME!");
        msg = msg.Format(msg, pTempUserProfiles->profileVersion.c_str(), profVerOfRunningApp.c_str());
        wxLogDebug(msg);
        wxASSERT_MSG(FALSE, msg);
    }

    if (pTempUserProfiles->applicationCompatibility != appVerOfRunningApp)
    {
        bVersionsDiffer = TRUE;
        wxString msg;
        msg = _T("The app's defaultProfileItems[] and the app's AI_VERSION_MAJOR.AI_VERSION_MINOR.AI_VERSION_BUILD_PART have different compatibility versions %s and %s PLEASE FIX ME!");
        msg = msg.Format(msg, pTempUserProfiles->applicationCompatibility.c_str(), appVerOfRunningApp.c_str());
        wxLogDebug(msg);
        wxASSERT_MSG(FALSE, msg);
    }

    if (pTempUserProfiles->profileVersion != m_pUserProfiles->profileVersion)
    {
        bVersionsDiffer = TRUE;
        wxLogDebug(_T("The internal and external profileVersions have different versions %s and %s"),
            pTempUserProfiles->profileVersion.c_str(), m_pUserProfiles->profileVersion.c_str());
    }
    if (pTempUserProfiles->applicationCompatibility != m_pUserProfiles->applicationCompatibility)
    {
        bVersionsDiffer = TRUE;
        wxLogDebug(_T("The internal and external applicationCompatibility have different versions %s and %s"),
            pTempUserProfiles->applicationCompatibility.c_str(), m_pUserProfiles->applicationCompatibility.c_str());
    }
    if (pTempUserProfiles->adminModified != m_pUserProfiles->adminModified)
    {
        bVersionsDiffer = TRUE;
        wxLogDebug(_T("The internal and external adminModified have different values %s and %s"),
            pTempUserProfiles->adminModified.c_str(), m_pUserProfiles->adminModified.c_str());
    }
    // compare the number of elements - they should always be the same
    if (pTempUserProfiles->definedProfileNames.GetCount() != m_pUserProfiles->definedProfileNames.GetCount())
    {
        wxLogDebug(_T("The internal and external definedProfileNames arrays have different count %d and %d PLEASE FIX ME!"),
            (int)pTempUserProfiles->definedProfileNames.GetCount(), (int)m_pUserProfiles->definedProfileNames.GetCount());
    }
    if (pTempUserProfiles->descriptionProfileTexts.GetCount() != m_pUserProfiles->descriptionProfileTexts.GetCount())
    {
        wxLogDebug(_T("The internal and external descriptionProfileTexts arrays have different count %d and %d PLEASE FIX ME!"),
            (int)pTempUserProfiles->descriptionProfileTexts.GetCount(), (int)m_pUserProfiles->descriptionProfileTexts.GetCount());
    }
    if (pTempUserProfiles->profileItemList.GetCount() != m_pUserProfiles->profileItemList.GetCount())
    {
        wxLogDebug(_T("The internal and external profileItemLists have different count %d and %d PLEASE FIX ME!"),
            (int)pTempUserProfiles->profileItemList.GetCount(), (int)m_pUserProfiles->profileItemList.GetCount());
    }

    // Check for changes in their text and usedVisibilityValues arrays, but only assuming they have the same
    // counts.
    if (pTempUserProfiles->definedProfileNames.GetCount() == m_pUserProfiles->definedProfileNames.GetCount())
    {
        int ct;
        int tot;
        tot = (int)pTempUserProfiles->definedProfileNames.GetCount();
        for (ct = 0; ct < tot; ct++)
        {
            wxString tempStr, appStr;
            tempStr = pTempUserProfiles->definedProfileNames.Item(ct);
            appStr = m_pUserProfiles->definedProfileNames.Item(ct);
            if (pTempUserProfiles->definedProfileNames.Item(ct) != m_pUserProfiles->definedProfileNames.Item(ct))
            {
                wxLogDebug(_T("The internal and external definedProfileNames arrays have different names\n   %s and %s PLEASE FIX ME!"),
                    tempStr.c_str(), appStr.c_str());
            }
        }
    }
    if (pTempUserProfiles->descriptionProfileTexts.GetCount() == m_pUserProfiles->descriptionProfileTexts.GetCount())
    {
        int ct;
        int tot;
        tot = (int)pTempUserProfiles->descriptionProfileTexts.GetCount();
        for (ct = 0; ct < tot; ct++)
        {
            wxString tempStr, appStr, verStr, msg;
            tempStr = pTempUserProfiles->descriptionProfileTexts.Item(ct);
            appStr = m_pUserProfiles->descriptionProfileTexts.Item(ct);
            if (tempStr != appStr)
            {
                if (bVersionsDiffer)
                {
                    verStr = _T("Note: Versions Differ.");
                    msg = msg.Format(_T("The internal and external descriptionProfileTexts arrays have different descriptions\n   %s and %s %s"), tempStr.c_str(), appStr.c_str(), verStr.c_str());
                }
                else
                {
                    verStr = _T("Note: Same Versions! PLEASE FIX ME!");
                    msg = msg.Format(_T("The internal and external descriptionProfileTexts arrays have different descriptions\n   %s and %s %s"), tempStr.c_str(), appStr.c_str(), verStr.c_str());
                }

                wxLogDebug(msg);
            }
        }
    }
    if (pTempUserProfiles->profileItemList.GetCount() == m_pUserProfiles->profileItemList.GetCount())
    {
        ProfileItemList::Node* posTemp;
        ProfileItemList::Node* posApp;
        int count;
        int item_count = (int)pTempUserProfiles->profileItemList.GetCount();
        for (count = 0; count < item_count; count++)
        {
            posTemp = pTempUserProfiles->profileItemList.Item(count);
            posApp = m_pUserProfiles->profileItemList.Item(count);
            UserProfileItem* pTempItem;
            UserProfileItem* pAppItem;
            pTempItem = posTemp->GetData();
            pAppItem = posApp->GetData();
            if (pTempItem->itemID != pAppItem->itemID)
            {
                // The itemID is the most crucial/unique identifier so ensure they match and are in
                // the same order.
                wxString tempStr = pTempItem->itemID;
                wxString appStr = pAppItem->itemID;
                wxString msg = _T("AI_UserProfile.xml and internal itemID strings in defaultProfileItems[] don't match for the menu item: %s: internal (%s) and external (%s)\n   - Are they spelled the same and in the same order?\n -   aborting the ReportMenuAndUserProfilesInconsistencies() function");
                msg = msg.Format(msg, pAppItem->itemText.c_str(), tempStr.c_str(), appStr.c_str());
                wxLogDebug(msg);
#if defined(_DEBUG)
                wxASSERT_MSG(FALSE, msg + _T(" Programmer: PLEASE FIX ME!"));
#endif
                return; // no point in continuing the check
            }

            if (pTempItem->itemIDint != pAppItem->itemIDint)
            {
                // The itemIDint is also a crucial/unique identifier so ensure they match and are in
                // the same order.
                wxString msg = _T("AI_UserProfile.xml and internal itemIDint values don't match for the menu item: %s: internal (%d) and external (%d)\n   -   aborting the ReportMenuAndUserProfilesInconsistencies() function");
                msg = msg.Format(msg, pAppItem->itemText.c_str(), pTempItem->itemIDint, pAppItem->itemIDint);
                wxLogDebug(msg);
#if defined(_DEBUG)
                wxASSERT_MSG(FALSE, msg + _T(" Programmer: PLEASE FIX ME!"));
#endif
                return; // no point in continuing the check
            }

            if (pTempItem->itemText != pAppItem->itemText)
            {
                wxString tempStr = pTempItem->itemText;
                wxString appStr = pAppItem->itemText;
                wxString verStr;
                if (bVersionsDiffer)
                {
                    verStr = _T("Note: Versions Differ.");
                }
                else
                {
                    verStr = _T("Note: Same Versions! PLEASE FIX ME!");
                }
                wxString msg;
                msg = msg.Format(_T("The internal and external itemText strings differ for itemID: %s\n   (%s) and (%s) %s"),
                    pTempItem->itemID.c_str(), tempStr.c_str(), appStr.c_str(), verStr.c_str());
                wxLogDebug(msg);
            }
            if (pTempItem->itemDescr != pAppItem->itemDescr)
            {
                wxString tempStr = pTempItem->itemDescr;
                wxString appStr = pAppItem->itemDescr;
                wxLogDebug(_T("The internal and external itemDescr strings differ for itemID: %s (%s) and (%s) PLEASE FIX ME!"),
                    pTempItem->itemID.c_str(), tempStr.c_str(), appStr.c_str());
            }
            if (pTempItem->itemType != pAppItem->itemType)
            {
                // differences here would result in an item not showing in the list (for an itemType typo)
                // or not being listed in the appropriate category (for a recognized but incorrect itemType).
                wxString tempStr = pTempItem->itemType;
                wxString appStr = pAppItem->itemType;
                wxLogDebug(_T("The internal and external itemType value differs for itemID: %s (%s) and (%s) PLEASE FIX ME!"),
                    pTempItem->itemID.c_str(), tempStr.c_str(), appStr.c_str());
            }
            if (pTempItem->adminCanChange != pAppItem->adminCanChange)
            {
                // differences here may result in an item unexpectedly showing/not showing in the list
                wxString tempStr = pTempItem->adminCanChange;
                wxString appStr = pAppItem->adminCanChange;
                wxLogDebug(_T("The internal and external adminCanChange value differs for itemID: %s (%s) and (%s) PLEASE FIX ME!"),
                    pTempItem->itemID.c_str(), tempStr.c_str(), appStr.c_str());
            }
            int ct;
            int totCt;
            totCt = (int)pTempItem->usedVisibilityValues.GetCount();
            for (ct = 0; ct < totCt; ct++)
            {
                if (pTempItem->usedProfileNames.Item(ct) != pAppItem->usedProfileNames.Item(ct))
                {
                    wxString tempStr = pTempItem->usedProfileNames.Item(ct);
                    wxString appStr = pAppItem->usedProfileNames.Item(ct);
                    wxLogDebug(_T("The internal and external usedProfileNames differ for itemID: %s (%s) and (%s) PLEASE FIX ME!"),
                        pTempItem->itemID.c_str(), tempStr.c_str(), appStr.c_str());
                }
                // Note: The usedProfileNames should always correspond to the definedProfileNames in the
                // top level UserProfilesSupport tag's definedProfileN attributes. Therefore we not only
                // check for consistency between the internal and external ones (above), but also that they
                // match the defined names (see next 2 tests).
                if (pTempItem->usedProfileNames.Item(ct) != pTempUserProfiles->definedProfileNames.Item(ct))
                {
                    wxString tempStrUsed = pTempItem->usedProfileNames.Item(ct);
                    wxString tempStrDefined = pTempUserProfiles->definedProfileNames.Item(ct);
                    wxLogDebug(_T("The internal usedProfileNames differs from the defined Names for itemID: %s (%s) and (%s) PLEASE FIX ME!"),
                        pTempItem->itemID.c_str(), tempStrUsed.c_str(), tempStrDefined.c_str());
                }
                if (pAppItem->usedProfileNames.Item(ct) != m_pUserProfiles->definedProfileNames.Item(ct))
                {
                    wxString appStrUsed = pAppItem->usedProfileNames.Item(ct);
                    wxString appStrDefined = m_pUserProfiles->definedProfileNames.Item(ct);
                    wxLogDebug(_T("The internal usedProfileNames differs from the defined Names for itemID: %s (%s) and (%s) PLEASE FIX ME!"),
                        pTempItem->itemID.c_str(), appStrUsed.c_str(), appStrDefined.c_str());
                }
                if (pTempItem->usedVisibilityValues.Item(ct) != pAppItem->usedVisibilityValues.Item(ct))
                {
                    // These usedVisibility values are the main items we expect to be different so only
                    // report inconsistencies when the versions are the same
                    if (!bVersionsDiffer)
                    {
                        wxString tempStr = pTempItem->usedVisibilityValues.Item(ct);
                        wxString appStr = pAppItem->usedVisibilityValues.Item(ct);
                        wxLogDebug(_T("The internal and external usedVisibilityValues differ for itemID: %s (%s) and (%s)"),
                            pTempItem->itemID.c_str(), tempStr.c_str(), appStr.c_str());
                    }
                }
                if (pTempItem->usedFactoryValues.Item(ct) != pAppItem->usedFactoryValues.Item(ct))
                {
                    wxString tempStr = pTempItem->usedFactoryValues.Item(ct);
                    wxString appStr = pAppItem->usedFactoryValues.Item(ct);
                    wxLogDebug(_T("The internal and external usedFactoryValues differ for itemID: %s (%s) and (%s) PLEASE FIX ME!"),
                        pTempItem->itemID.c_str(), tempStr.c_str(), appStr.c_str());
                }
            }
        }
    }

    DestroyUserProfiles(pTempUserProfiles);
}

//////////////////////////////////////////////////////////////////////////////////////////
/// \return    TRUE if menuItemIDint is supposed to be visible in this nProfile, FALSE otherwise
/// \param      -> nProfile   the user workflow profile (zero based), i.e., m_nWorkflowProfile
/// \param      -> menuItemIDint the int representation of the menu item's ID
/// \remarks
/// Called from: the App's ConfigureMenuBarForUserProfile().
/// Determines whether the menu item represented in menuItemIDint is supposed to be visible in
/// the interface for the user profile passed in as nProfile. Looks up the menuItemIDint in
/// the m_pUserProfiles data struct stored on the heap. Note: this function depends on valid
/// values being assigned to the UserProfiles struct's itemIDInt attribute by a call to
/// GetAndAssignIdValuesToUserProfilesStruct().
//////////////////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItApp::MenuItemIsVisibleInThisProfile(const int nProfile, const int menuItemIDint)
{
    // we assume that a menu item is visible unless the m_pUserProfiles data
    // indicates otherwise.
    bool bItemIsVisible = TRUE;
    if (nProfile == 0)
    {
        // The work flow profile 0 (zero) is the "None" selection all all interface
        // items are visible by default
        return bItemIsVisible;
    }
    int ct;
    int totct;
    totct = (int)m_pUserProfiles->profileItemList.GetCount();
    for (ct = 0; ct < totct; ct++)
    {
        UserProfileItem* pUserProfileItem;
        ProfileItemList::Node* node;
        node = m_pUserProfiles->profileItemList.Item(ct);
        pUserProfileItem = node->GetData();
        wxASSERT(pUserProfileItem != NULL);
        if (menuItemIDint == wxID_SEPARATOR) // the value of wxID_SEPARATOR is -2
        {
            // We return TRUE for menuSeparators since they are visible when present.
            return TRUE;
        }
        if (pUserProfileItem->itemType != _T("subMenu")) // we are only checking for subMenu items
        {
            continue;
        }
        int itemIDint;
        itemIDint = pUserProfileItem->itemIDint; //itemID;
        int indexFromProfile = 0;
        if (nProfile <= 0)
            indexFromProfile = 0;
        else if (nProfile > 0)
            indexFromProfile = nProfile - 1;
        if (itemIDint == menuItemIDint && pUserProfileItem->usedVisibilityValues.Item(indexFromProfile) == _T("0"))
        {
            return FALSE;
        }
    }
    return bItemIsVisible;
}

//////////////////////////////////////////////////////////////////////////////////////////
/// \return    TRUE if itemLabel is supposed to be visible in this nProfile, FALSE otherwise
/// \param      -> nProfile   the user workflow profile (zero based), i.e., m_nWorkflowProfile
/// \param      -> itemLabel the string representation of the mode bar item's text
/// \remarks
/// Called from: the App's RemoveModeBarItemsFromModeBarSizer().
/// Determines whether the mode bar item represented in itemLabel is supposed to be visible in
/// the interface for the user profile passed in as nProfile. Looks up the itemLabel in
/// the m_pUserProfiles data struct stored on the heap and reads the usedVisibilityValues
/// for that item as indexed for the nProfile.
//////////////////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItApp::ModeBarItemIsVisibleInThisProfile(const int nProfile, const wxString itemLabel)
{
    // we assume that a mode bar item is visible unless the m_pUserProfiles data
    // indicates otherwise.
    bool bItemIsVisible = TRUE;
    if (nProfile == 0)
    {
        // The work flow profile 0 (zero) is the "None" selection and all interface
        // items are visible by default
        return bItemIsVisible;
    }
    int ct;
    int totct;
    totct = (int)m_pUserProfiles->profileItemList.GetCount();
    for (ct = 0; ct < totct; ct++)
    {
        UserProfileItem* pUserProfileItem;
        ProfileItemList::Node* node;
        node = m_pUserProfiles->profileItemList.Item(ct);
        pUserProfileItem = node->GetData();
        wxASSERT(pUserProfileItem != NULL);
        if (pUserProfileItem->itemType != _T("modeBar"))
        {
            continue;
        }
        if (itemLabel == _T("")) // the item is a spacer in the sizer (just before the Glossing wxCheckBox)
        {
            // We skip the processing of the spacer
            continue;
        }
        wxString itemLabelStr;
        itemLabelStr = pUserProfileItem->itemText;
        itemLabelStr.Trim(FALSE);
        itemLabelStr.Trim(TRUE);
        int indexFromProfile = 0;
        if (nProfile <= 0)
            indexFromProfile = 0;
        else if (nProfile > 0)
            indexFromProfile = nProfile - 1;
        if (itemLabelStr == itemLabel && pUserProfileItem->usedVisibilityValues.Item(indexFromProfile) == _T("0"))
        {
            return FALSE;
        }
    }
    return bItemIsVisible;
}

//////////////////////////////////////////////////////////////////////////////////////////
/// \return    TRUE if itemLabel is supposed to be visible in this nProfile, FALSE otherwise
/// \param      -> nProfile   the user workflow profile (zero based), i.e., m_nWorkflowProfile
/// \param      -> itemLabel the string representation of the tool bar item's (short) help text
///                     i.e., the tooltip
/// \remarks
/// Called from: the App's RemoveToolBarItemsFromToolBar().
/// Determines whether the tool bar item represented in itemLabel is supposed to be visible in
/// the interface for the user profile passed in as nProfile. Looks up the itemLabel in
/// the m_pUserProfiles data struct stored on the heap and reads the usedVisibilityValues
/// for that item as indexed for the nProfile.
//////////////////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItApp::ToolBarItemIsVisibleInThisProfile(const int nProfile, const wxString itemLongStringHelp)
{
    // we assume that a tool bar item is visible unless the m_pUserProfiles data
    // indicates otherwise.
    bool bItemIsVisible = TRUE;
    if (nProfile == 0)
    {
        // The work flow profile 0 (zero) is the "None" selection and all interface
        // items are visible by default
        return bItemIsVisible;
    }
    int ct;
    int totct;
    totct = (int)m_pUserProfiles->profileItemList.GetCount();
    for (ct = 0; ct < totct; ct++)
    {
        UserProfileItem* pUserProfileItem;
        ProfileItemList::Node* node;
        node = m_pUserProfiles->profileItemList.Item(ct);
        pUserProfileItem = node->GetData();
        wxASSERT(pUserProfileItem != NULL);
        if (pUserProfileItem->itemType != _T("toolBar"))
        {
            continue;
        }
        if (itemLongStringHelp == _T("")) // the item is a separator in the toolbar group
        {
            // We skip the processing of the separator
            continue;
        }
        wxString itemHelpStr;
        itemHelpStr = pUserProfileItem->itemDescr;
        itemHelpStr.Trim(FALSE);
        itemHelpStr.Trim(TRUE);
        int indexFromProfile = 0;
        if (nProfile <= 0)
            indexFromProfile = 0;
        else if (nProfile > 0)
            indexFromProfile = nProfile - 1;
        if (itemHelpStr == itemLongStringHelp && pUserProfileItem->usedVisibilityValues.Item(indexFromProfile) == _T("0"))
        {
            return FALSE;
        }
    }
    return bItemIsVisible;
}


/* This function is currently unused (and incomplete/untested) but might be helpful in the future
//////////////////////////////////////////////////////////////////////////////////////////
/// \return    nothing
/// \param      -> pMainMenuItem   pointer to the main menu item's struct on the heap
/// \param      -> pSubMenuItem    pointer to the sub menu item's struct on the heap
/// \remarks
/// Called from: the App's ConfigureInterfaceForUserProfile().
/// Adds the sub menu item (whose data representation is in pSubMenuItem) to AI's current
/// menu bar. Before calling this function a call to MenuItemIsVisibleInThisProfile() should
/// return TRUE and a call to MenuItemExistsInAIMenuBar() should return FALSE. This function
/// uses the AI_MenuStructure data on the heap to determine the position within the AI menu bar
/// where the sub menu item should be inserted, along with any preceding menu separator.
//////////////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItApp::AddSubMenuItemToAIMenuBar(AI_MainMenuItem* pMainMenuItem,AI_SubMenuItem* pSubMenuItem)
{
// Note: All menu items that can be added to the AI menu bar, would have
// previously been removed and stored within the m_pRemovedMenuItemArray
// array of pointers to wxMenuItems. We should be able to find the wxMenuItem*
// in that array that corresponds to pSubMenuItem, and Insert it into the
// appropriate top level menu corresponding to pMainMenuItem. The relative
// position where it gets inserted is determined by consulting the
// AI_MenuStructure data on the heap. Afterwards we also tidy up the menu
// separators.

// Verify that pSubMenuItem exists within the m_pRemovedMenuItemArray
int nIDofSubMenutoAddBack = -1;
int miCt;
int miTot;
wxString subMenuLabelPlain = RemoveMenuLabelDecorations(pSubMenuItem->subMenuLabel);
wxMenuItem* pMenuItemToAddBack = NULL;
miTot = m_pRemovedMenuItemArray->GetCount();
wxASSERT(miTot > 0); // this must be so if we are now adding back wxMenuItems!
for (miCt = 0; miCt < miTot; miCt++)
{
pMenuItemToAddBack = (wxMenuItem*)m_pRemovedMenuItemArray->Item(miCt);
if (pMenuItemToAddBack->GetLabel() == subMenuLabelPlain)
{
nIDofSubMenutoAddBack = pMenuItemToAddBack->GetId();
break;
}
}
wxASSERT(nIDofSubMenutoAddBack != -1);
wxASSERT(pMenuItemToAddBack != NULL);

// Get the menu item out of the removals list
m_pRemovedMenuItemArray->Remove(pMenuItemToAddBack); // does not delete the object, but removes it from the array
// We now have the pointer to the wxMenuItem* to be added back to the AI menu
// in pMenuItemToAddBack, along with its int ID value in nIDofSubMenutoAddBack.

// Determine in which top level menu pMenuItemToAddBack belongs
wxMenu* pTopLevelAIMenuToGetItem = NULL; //
CMainFrame* pMainFrame = GetMainFrame();
wxMenuBar* pMenuBar = pMainFrame->GetMenuBar();
int mCt;
int nMenuItems = pMenuBar->GetMenuCount();
wxString mmLabel;
wxASSERT(nMenuItems > 0);
for (mCt = 0; mCt < nMenuItems; mCt++)
{
pTopLevelAIMenuToGetItem = pMenuBar->GetMenu(mCt);
mmLabel = pMenuBar->GetMenuLabel(mCt);
if (mmLabel == pMainMenuItem->mainMenuLabel)
{
break;
}
else
{
// we're not in the right top level menu
continue;
}
}
wxASSERT(pTopLevelAIMenuToGetItem != NULL);

// Get the list of menu items currently in AI's top level menu
wxMenuItemList pAIMenuItemList = pTopLevelAIMenuToGetItem->GetMenuItems();

// Get the list of all menu items in AI_MenuStructure for this top level menu
wxArrayPtrVoid ItemsOfThisMainMenuStructure;
ItemsOfThisMainMenuStructure = GetMenuStructureItemsArrayForThisTopLevelMenu(pMainMenuItem);

// testing below!!!
// Testing shows that pMenuItemList contains menuSeparators which have empty
// strings for labels and -1 for wxItemKind; and, for the File menu, also
// contains separate menu entries for all the file history entries prefixed
// by a number and a space (1 up to a max of 9).
{
int i,tot;
tot = (int)pAIMenuItemList.GetCount();
wxMenuItem* pmItem;
wxMenuItemList::Node* pNode;
wxLogDebug(_T("AI Current %s Menu items:"),mmLabel.c_str());
for (i = 0; i < tot; i++)
{
pNode = pAIMenuItemList.Item(i);
pmItem = pNode->GetData();
wxLogDebug(_T("   %s | %s | %d"),pmItem->GetLabel().c_str(),pmItem->GetHelp().c_str(),pmItem->GetKind());
;
}
}
// Testing shows that the removed items list does NOT contain
// menuSeparators, but only the wxMenuItem information.
// m_pRemovedMenuItemArray, of course, contains removed items
// from all top level menus, whereas the pMenuItemList above
// contains the wxMenuItems that belong only to the
// pMainMenuItem parameter.
{
int i,tot;
tot = (int)m_pRemovedMenuItemArray->GetCount();
wxLogDebug(_T("Removed Menu items (all menus):"));
for (i = 0; i < tot; i++)
{
wxMenuItem* pmItem;
pmItem = (wxMenuItem*)m_pRemovedMenuItemArray->Item(i);
wxLogDebug(_T("   %s | %s | %d"),pmItem->GetLabel().c_str(),pmItem->GetHelp().c_str(),pmItem->GetKind());
;
}

}
// Testing shows that ItemsOfThisMainMenuStructure contains menuSeparators
// which have empty strings for labels and wxITEM_SEPARATOR for their item
// kind. And, for the File menu there, is NO separate menu entries for the
// file history entries.
{
int i,tot;
tot = (int)ItemsOfThisMainMenuStructure.GetCount();
wxLogDebug(_T("Top Level %s menu items:"),pMainMenuItem->mainMenuLabel.c_str());
for (i = 0; i < tot; i++)
{
AI_SubMenuItem*  smItem;
smItem = (AI_SubMenuItem*)ItemsOfThisMainMenuStructure.Item(i);
wxLogDebug(_T("   %s | %s | %s"),smItem->subMenuLabel.c_str(),smItem->subMenuHelp.c_str(),smItem->subMenuKind.c_str());
;
}

}
// testing above !!!

// Our task now is to compare the list called pAIMenuItemList with the void ptr array called
// ItemsOfThisMainMenuStructure, and figure out where the (parameter) pSubMenuItem should go
// into the pTopLevelAIMenuToGetItem.
// Plan: Try to fit the following code into the solution.
bool bInsertionMade = FALSE;
int nSubMenuItems = (int)pAIMenuItemList.GetCount();
if (nSubMenuItems == 0)
{
// the menu exists but has no items so just append the item where it will
// be the only item in the list
pTopLevelAIMenuToGetItem->Insert(0,
pMenuItemToAddBack->GetId(),
pMenuItemToAddBack->GetItemLabel(),
pMenuItemToAddBack->GetHelp(),
pMenuItemToAddBack->GetKind() );
bInsertionMade = TRUE;
}
else
{
// The menu has existing items, so we have to decide where to
// insert them.
int smCt;
for (smCt = 0; smCt < nSubMenuItems; smCt++)
{
wxMenuItemList::Node* pNode;
wxMenuItem* pMenuItemBeingScanned;
pNode = pAIMenuItemList.Item(smCt);
pMenuItemBeingScanned = pNode->GetData();
wxString smKindStr;
wxItemKind smKind = pMenuItemBeingScanned->GetKind();
smKindStr = GetMenuItemKindAsString(smKind);
wxString smLabel = pMenuItemBeingScanned->GetItemLabelText(); // GetItemLabelText removes any & and \tCtrl-key accelerator chars
wxString subMenuLabelPlain = pSubMenuItem->subMenuLabel;
subMenuLabelPlain = RemoveMenuLabelDecorations(subMenuLabelPlain);

// Q. Since the current menubar may already be missing certain menu items in
// its current profile representation, how do we know where to insert pSubMenuItem?
// A. We insert the menu item into the current menubar in its relative order
// as determined by examining the m_pAI_MenuStructure struct on the heap.
// It is sufficient to insert this item just before the first item known
// to follow this item in the default menu. To do that we need to query the
// m_pAI_MenuStructure and get a list of menu items that normally follow
// pSubMenuItem within that top level menu. The list could have one or more
// items depending on where pSubMenuItem normally appears in the menu.
// In our current scan of AI's current menubar, we are comparing the current
// menubar item with what we found in our queried list of items. When we
// arrive at any one of those items in the list we insert the pSubMenuItem
// into the menu at that point. If we get to the end of our current scan
// through the menu and haven't found any item in the list, or if our list
// was empty, we simply insert the pSubMenuItem at the end of the menu.
// Note: We'll take care of inserting any menuSeparators later after having
// inserted the item in the menu.

if (smKind != wxITEM_SEPARATOR)
{
bool bAppendInsteadOfInsert = FALSE;
if (AddMenuItemBeforeThisOne(pSubMenuItem, pMenuItemBeingScanned, bAppendInsteadOfInsert))
{
// we have found the correct sub menu item to be added before
if (bAppendInsteadOfInsert)
{
pTopLevelAIMenuToGetItem->Append(
pMenuItemToAddBack->GetId(),
pMenuItemToAddBack->GetItemLabel(),
pMenuItemToAddBack->GetHelp(),
pMenuItemToAddBack->GetKind() );
}
else
{
pTopLevelAIMenuToGetItem->Insert(smCt,
pMenuItemToAddBack->GetId(),
pMenuItemToAddBack->GetItemLabel(),
pMenuItemToAddBack->GetHelp(),
pMenuItemToAddBack->GetKind() );
}
bInsertionMade = TRUE;
break;
}
else
{
// should not get here
int junk1;
junk1 = 0;
}
}
} // end of for (smCt = 0; smCt < nSubMenuItems; smCt++)
}
int junk;
junk = 1;

// TODO: code to insert any needed menu separator
//if (bInsertionMade)
//{
//	// Check for extraneous left-over menu separators in this top level menu
//	// and delete if found.
//	// Start at the bottom of the menu and remove all menu separators there.
//	bool bLastItemWasSeparator = FALSE;
//	wxMenuItemList::Node* pNode;
//	wxMenuItem* pMenuItem;
//	pMenuItemList = pMainMenu->GetMenuItems(); // refresh the list of menu items
//	pNode = pMenuItemList.GetLast();
//	while (pNode != NULL)
//	{
//		pMenuItem = pNode->GetData();
//		if (pMenuItem->GetKind() != wxITEM_SEPARATOR)
//		{
//			break;
//		}
//		else
//		{
//			// This menu separator is either the last item on the menu
//			// or it is the first of two adjacent separators in the menu.
//			// In either case we delete the current menu separator.
//			wxMenuItem* pRemMenuItem;
//			pRemMenuItem = pMainMenu->Remove(pMenuItem);
//			wxASSERT(pRemMenuItem != NULL);
//			delete pRemMenuItem; // to avoid memory leaks
//			pRemMenuItem = (wxMenuItem*)NULL;
//		}
//		pNode = pMenuItemList.GetLast();
//	}
//	// remove any separators at the top of the top level menu
//	pMenuItemList = pMainMenu->GetMenuItems(); // refresh the list of menu items
//	nSubMenuItems = (int)pMenuItemList.GetCount();
//	pNode = pMenuItemList.GetFirst();
//	while (pNode != NULL)
//	{
//		pMenuItem = pNode->GetData();
//		if (pMenuItem->GetKind() != wxITEM_SEPARATOR)
//		{
//			break;
//		}
//		else
//		{
//			// This menu separator is at the top of the menu
//			// so remove it.
//			wxMenuItem* pRemMenuItem;
//			pRemMenuItem = pMainMenu->Remove(pMenuItem);
//			wxASSERT(pRemMenuItem != NULL);
//			delete pRemMenuItem; // to avoid memory leaks
//			pRemMenuItem = (wxMenuItem*)NULL;
//		}
//		pNode = pMenuItemList.GetFirst();
//	}
//
//	// change any remaining multiple sequences of menu separators to a single separator
//	pMenuItemList = pMainMenu->GetMenuItems(); // refresh the list of menu items
//	nSubMenuItems = (int)pMenuItemList.GetCount();
//	for (smCt = nSubMenuItems - 1; smCt >= 0; smCt--) // process bottom to top of menu
//	{
//		pNode = pMenuItemList.Item(smCt);
//		pMenuItem = pNode->GetData();
//		wxString smKindStr;
//		wxItemKind smKind = pMenuItem->GetKind();
//		if (smKind == wxITEM_SEPARATOR)
//		{
//			if (smCt == nSubMenuItems - 1 || bLastItemWasSeparator)
//			{
//				// This menu separator is either the last item on the menu
//				// or it is the first of two adjacent separators in the menu.
//				// In either case we delete the current menu separator.
//				wxMenuItem* pRemMenuItem;
//				pRemMenuItem = pMainMenu->Remove(pMenuItem);
//				wxASSERT(pRemMenuItem != NULL);
//				delete pRemMenuItem; // to avoid memory leaks
//				pRemMenuItem = (wxMenuItem*)NULL;
//			}
//			bLastItemWasSeparator = TRUE;
//		}
//		else
//		{
//			bLastItemWasSeparator = FALSE;
//		}
//	}
//
//}

//}
}
*/

/* The following function is currently unused (and incomplete/untested) but might be helpful in the future
//////////////////////////////////////////////////////////////////////////////////////////
/// \return    nothing
/// \param      -> pMainMenuItem   pointer to the main menu item's struct on the heap
/// \param      -> pSubMenuItem    pointer to the sub menu item's struct on the heap
/// \remarks
/// Called from: the App's ConfigureInterfaceForUserProfile().
/// Removes the sub menu item (whose data representation is in pSubMenuItem) from AI's current
/// menu bar. Before calling this function a call to MenuItemIsVisibleInThisProfile() should
/// return FALSE and a call to MenuItemExistsInAIMenuBar() should return TRUE. This function
/// checks the resulting AI menu bar after the deletion of the sub menu item, and removes any
/// left over menu separators that would appear as a double separator or a separator left at
/// the bottom of the top level menu.
//////////////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItApp::RemoveSubMenuItemFromAIMenuBar(AI_MainMenuItem* pMainMenuItem,AI_SubMenuItem* pSubMenuItem)
{
CMainFrame* pMainFrame = GetMainFrame();
wxMenuBar* pMenuBar = pMainFrame->GetMenuBar();
int mCt;
int nMenuItems = pMenuBar->GetMenuCount();
for (mCt = 0; mCt < nMenuItems; mCt++)
{
wxMenu* pMainMenu = pMenuBar->GetMenu(mCt);
wxString mmLabel = pMenuBar->GetMenuLabel(mCt);
if (mmLabel != pMainMenuItem->mainMenuLabel)
{
// we're not in the right top level menu
continue;
}
wxASSERT(pMainMenu != NULL);
wxMenuItemList pMenuItemList = pMainMenu->GetMenuItems();
int smCt;
int nSubMenuItems = (int)pMenuItemList.GetCount();
bool bDeletionMade = FALSE;
for (smCt = 0; smCt < nSubMenuItems; smCt++)
{
wxMenuItemList::Node* pNode;
wxMenuItem* pMenuItem;
pNode = pMenuItemList.Item(smCt);
pMenuItem = pNode->GetData();
wxString smKindStr;
wxItemKind smKind = pMenuItem->GetKind();
smKindStr = GetMenuItemKindAsString(smKind);
wxString smLabel = pMenuItem->GetItemLabelText(); // GetItemLabelText removes any & and \tCtrl-key accelerator chars
wxString subMenuLabelPlain = pSubMenuItem->subMenuLabel;
subMenuLabelPlain = RemoveMenuLabelDecorations(subMenuLabelPlain);

if (smLabel == subMenuLabelPlain && smKindStr == pSubMenuItem->subMenuKind)
{
// we have found the correct sub menu item to be removed
wxMenuItem* pRemMenuItem;
pRemMenuItem = pMainMenu->Remove(pMenuItem);
wxASSERT(pRemMenuItem != NULL);
m_pRemovedMenuItemArray->Add((void*)pRemMenuItem); // deleted in OnExit()
//delete pRemMenuItem; // to avoid memory leaks
//pRemMenuItem = (wxMenuItem*)NULL;
bDeletionMade = TRUE;
}
} // end of for (smCt = 0; smCt < nSubMenuItems; smCt++)
if (bDeletionMade)
{
// Check for extraneous left-over menu separators in this top level menu
// and delete if found.
// Start at the bottom of the menu and remove all menu separators there.
bool bLastItemWasSeparator = FALSE;
wxMenuItemList::Node* pNode;
wxMenuItem* pMenuItem;
pMenuItemList = pMainMenu->GetMenuItems(); // refresh the list of menu items
pNode = pMenuItemList.GetLast();
while (pNode != NULL)
{
pMenuItem = pNode->GetData();
if (pMenuItem->GetKind() != wxITEM_SEPARATOR)
{
break;
}
else
{
// This menu separator is either the last item on the menu
// or it is the first of two adjacent separators in the menu.
// In either case we delete the current menu separator.
wxMenuItem* pRemMenuItem;
pRemMenuItem = pMainMenu->Remove(pMenuItem);
wxASSERT(pRemMenuItem != NULL);
delete pRemMenuItem; // to avoid memory leaks
pRemMenuItem = (wxMenuItem*)NULL;
}
pNode = pMenuItemList.GetLast();
}
// remove any separators at the top of the top level menu
pMenuItemList = pMainMenu->GetMenuItems(); // refresh the list of menu items
nSubMenuItems = (int)pMenuItemList.GetCount();
pNode = pMenuItemList.GetFirst();
while (pNode != NULL)
{
pMenuItem = pNode->GetData();
if (pMenuItem->GetKind() != wxITEM_SEPARATOR)
{
break;
}
else
{
// This menu separator is at the top of the menu
// so remove it.
wxMenuItem* pRemMenuItem;
pRemMenuItem = pMainMenu->Remove(pMenuItem);
wxASSERT(pRemMenuItem != NULL);
delete pRemMenuItem; // to avoid memory leaks
pRemMenuItem = (wxMenuItem*)NULL;
}
pNode = pMenuItemList.GetFirst();
}

// change any remaining multiple sequences of menu separators to a single separator
pMenuItemList = pMainMenu->GetMenuItems(); // refresh the list of menu items
nSubMenuItems = (int)pMenuItemList.GetCount();
for (smCt = nSubMenuItems - 1; smCt >= 0; smCt--) // process bottom to top of menu
{
pNode = pMenuItemList.Item(smCt);
pMenuItem = pNode->GetData();
wxString smKindStr;
wxItemKind smKind = pMenuItem->GetKind();
if (smKind == wxITEM_SEPARATOR)
{
if (smCt == nSubMenuItems - 1 || bLastItemWasSeparator)
{
// This menu separator is either the last item on the menu
// or it is the first of two adjacent separators in the menu.
// In either case we delete the current menu separator.
wxMenuItem* pRemMenuItem;
pRemMenuItem = pMainMenu->Remove(pMenuItem);
wxASSERT(pRemMenuItem != NULL);
delete pRemMenuItem; // to avoid memory leaks
pRemMenuItem = (wxMenuItem*)NULL;
}
bLastItemWasSeparator = TRUE;
}
else
{
bLastItemWasSeparator = FALSE;
}
}

}
}
}
*/

/* The following function is currently unused (and untested/incomplete) but might be useful in the future
//////////////////////////////////////////////////////////////////////////////////////////
/// \return     TRUE if pMenuItemComingNext normally follows immediately after pMenuItemToAdd
/// \param      -> pMenuItemToAdd      the menu item to be inserted in the menu
/// \param      -> pMenuItemComingNext the menu item before which pMenuItemToAdd should go
/// \remarks
/// Called from: the App's AddSubMenuItemToAIMenuBar().
/// This function is used as a test in the AddSubMenuItemToAIMenuBar() function. It is
/// called from code that is scanning down a given menu of menu items from top to bottom.
/// It determines if the menu item represented by pMenuItemToAdd should be inserted in the
/// menu just before the menu item represented by pMenuItemComingNext, or appended to the
/// end of the menu. When this function is called, the AI Menubar and its menus may have
/// had many of its normal menu items previously removed (depending on the currently
/// active user profile). Hence, this function consults the default menu structure
/// represented in m_pAI_MenuStructure to see where the pMenuItemToAdd would normally
/// appear within the full default menus. The caller will actually add the
/// pMenuItemToAdd to the menu. This function merely determines if it should be
/// inserted before pMenuItemComingNext or appended to the end of the menu.
//////////////////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItApp::AddMenuItemBeforeThisOne(AI_SubMenuItem* pMenuItemToAdd,
wxMenuItem* pMenuItemComingNext,
bool& bAppendInsteadOfInsert)
{
bool bComesPrior = FALSE;

// First, get the top level menu in the menu structure where pMenuItemToAdd is located.
wxString topLevelMenuOfItemToAdd = GetTopLevelMenuLabelForThisSubMenuID(pMenuItemToAdd->subMenuID);
wxASSERT (!topLevelMenuOfItemToAdd.IsEmpty());

// Next, look in m_pAI_MenuStructure to get a wxArrayString of the menu item labels
// that follow pMenuItemToAdd in AI's full default menu structure
wxArrayString followingMenuItemsArray;
followingMenuItemsArray = GetMenuItemsThatFollowThisSubMenuID(pMenuItemToAdd->subMenuID,pMenuItemToAdd->subMenuLabel);
// Note: the followingMenuItemsArray now contains all sub menu item labels and menu
// separators that normally follow the pMenuItemToAdd menu item. Since it comes from
// an examination of the m_pAI_MenuStructure, it does not include any file history
// items (that may show up as items on the File menu).

// Now, determine if pMenuItemComingNext is contained within the followingMenuItemsArray.
// If it is, or if the followingMenuItemsArray is empty, we return TRUE for bComesPrior,
// otherwise FALSE for bComesPrior.
if (followingMenuItemsArray.IsEmpty())
{
bComesPrior = TRUE; // default above was FALSE
// when the array of menu items is empty it means that there were no other items
// found following the item being checked, so set the bAppendInsteadOfInsert flag
// to TRUE so it can be handled appropriately back in the caller
bAppendInsteadOfInsert = TRUE;
return bComesPrior;
}
else
{
// compare items in the array
int ct;
int tot;
tot = (int)followingMenuItemsArray.GetCount();
wxString itemLabelInArray;
wxString itemLabelOfwxMenuItem;
for (ct = 0; ct < tot; ct++)
{
itemLabelInArray = followingMenuItemsArray.Item(ct);
// We have to compare menu labels since pMenuItemComingNext is a wxMenuItem
// and, while we can query it with GetId() to get its int value, I don't know
// of any way to get the string equivalent of that int's identifier!
// We also need to compare the strings without menu decorations.
// wxMenuItem::GetItemLabelText() gets without any accelerator chars or
// other decorations. Use this because GetItemLabel() doesn't handle \t correctly.
itemLabelInArray = this->RemoveMenuLabelDecorations(itemLabelInArray);
itemLabelOfwxMenuItem = pMenuItemComingNext->GetItemLabelText(); //
if (itemLabelInArray == itemLabelOfwxMenuItem)
{
bComesPrior = TRUE;
break;
}
}
}
return bComesPrior;
}
*/

//////////////////////////////////////////////////////////////////////////////////////////
/// \return     a wxString representing the menu label in plain text with any & chars
///             and any accelerator/hot key notation such as \tCtrl-S or \tShift-Ctrl-x
///             removed from the incoming menuLabel string
/// \param      -> menuLabel  the string value of the menu label containing any "decorations"
/// \remarks
/// Called from: the App's GetAndAssignIdValuesToUserProfilesStruct(), SetupDefaultMenuStructure(),
/// ConfigureMenuBarForUserProfile() and GetSubMenuItemIdFromAIMenuBar()
/// and from PopulateListBox() and ProfileItemIsSubMenuOfThisMainMenu() in the
/// CAdminEditMenuProfile class.
/// This function is used for comparing menu label strings. It removes any '&' chars as
/// well as any accelerator/hot key strings embedded within the menu label such as
/// \tCtrl-x or \tShift-Ctrl-x. Note: This function detects the presence of both _T("\\t")
/// and _T("\t") in the menuLabel string, and removes all text following those occurrences.
/// The need for detecting both comes from the fact that strings imported from the
/// external AI_UserProfiles.xml file have embedded tabs of the form _T("\\t"). The _T("\\t")
/// form of the string is difficult to detect because they appear as "\t" within the IDE
/// debugger! Menu labels embedded with \\t do not right-align when the menu it shown, but
/// display the \t and its following Ctrl-x string suffixed on the text of the menu label
/// making for a rather ugly menu.
//////////////////////////////////////////////////////////////////////////////////////////
wxString CAdapt_ItApp::RemoveMenuLabelDecorations(wxString menuLabel)
{
    wxString tempStr = menuLabel;
    tempStr.Replace(_T("&"), _T(""));
    //int nTest;
    //nTest = tempStr.Find(_T("\\t"));
    if (tempStr.Find(_T("\\t")) != wxNOT_FOUND) // must use "\\t" since it is a string representation only
    {
        // there is a tab char in the menu label, so remove from that point to remainder of string
        tempStr = tempStr.Left(tempStr.Find(_T("\\t")));
    }
    else if (tempStr.Find(_T("\t")) != wxNOT_FOUND) // in case it has "\t" in stead of "\\t")
    {
        // there is a tab char in the menu label, so remove from that point to remainder of string
        tempStr = tempStr.Left(tempStr.Find(_T("\t")));
    }
    else
    {
        // there is no tab char in the label. Check for "Ctrl-" or "Shift-"
        if (tempStr.Find(_T("Ctrl-")) != wxNOT_FOUND)
        {
            tempStr = tempStr.Left(tempStr.Find(_T("Ctrl-")));
        }
        else if (tempStr.Find(_T("Shift-")) != wxNOT_FOUND)
        {
            tempStr = tempStr.Left(tempStr.Find(_T("Shift-")));
        }
    }
    return tempStr;
}

//////////////////////////////////////////////////////////////////////////////////////////
/// \return     a wxString representing the string equivalent of the itemKind enum value
/// \param      -> itemKind  the wxItemKind enum value of the menu item
/// \remarks
/// Called from: the App's SetupDefaultMenuStructure().
/// Returns the wxString equivalent of a menu's wxItemKind value.
//////////////////////////////////////////////////////////////////////////////////////////
wxString CAdapt_ItApp::GetMenuItemKindAsString(wxItemKind itemKind)
{
    switch (itemKind)
    {
    case wxITEM_NORMAL:
        return _T("wxITEM_NORMAL");
    case wxITEM_CHECK:
        return _T("wxITEM_CHECK");
    case wxITEM_SEPARATOR:
        return _T("wxITEM_SEPARATOR");
    case wxITEM_RADIO:
        return _T("wxITEM_RADIO");
    default: return _T("wxITEM_NORMAL");
    }
}
// BEW 15Mar24 this function was designed to support use of kbadmin with pwd kbauth. But these
// two parameters are no longer supported by kbserver. Instead 'gates' and 'rs46nha#BZ' give
// access to MariaDB's kbserver's entry and user tables. So I'll comment out the old stuff so it does nothing.
// But all instances of this function in .cpp code should be commented out; it's not to be used again
wxString  CAdapt_ItApp::GetThingieStart(wxString bilum, wxString nem, wxString larim)
{
    // bilum should be the kbserver's ipAddress, new should be an ALL PERMISSIONS possessing username
    // (now 'gates') and larim, the password which enables kbserver entry (now rs46nha#BZ)
    wxString igobek = wxEmptyString;
    //wxString koma = _T(",");
    //if (bilum.IsEmpty() || nem.IsEmpty() || larim.IsEmpty())
    //{
    //    return igobek;
    //}
    //igobek = bilum + koma + nem + koma + larim + koma;
    return igobek;
}

//////////////////////////////////////////////////////////////////////////////////////////
/// \return     the wxItemKind enum value equivalent to the input itemKindStr
/// \param      -> itemKindStr  a wxString in the form of "wxITEM_NORMAL", "wxITEM_SEPARATOR",
///                             "wxITEM_CHECK" or "wxITEM_RADIO".
/// \remarks
/// Called from: the App's ConfigureMenuBarForUserProfile().
/// A convenience function that returns the wxItemKind enum equivalent of the input
/// wxString representation.
//////////////////////////////////////////////////////////////////////////////////////////
wxItemKind CAdapt_ItApp::GetMenuItemKindFromString(wxString itemKindStr)
{
    if (itemKindStr == _T("wxITEM_NORMAL"))
    {
        return wxITEM_NORMAL;
    }
    else if (itemKindStr == _T("wxITEM_SEPARATOR"))
    {
        return wxITEM_SEPARATOR;
    }
    else if (itemKindStr == _T("wxITEM_CHECK"))
    {
        return wxITEM_CHECK;
    }
    else if (itemKindStr == _T("wxITEM_RADIO"))
    {
        return wxITEM_RADIO;
    }
    else
    {
        wxASSERT(FALSE);
        return wxITEM_NORMAL;
    }
}

//////////////////////////////////////////////////////////////////////////////////////////
/// \return     a wxString representing the top level menu label corresponding to the
///             top level menu ID (i.e., ID_FILE_MENU). The label returned will
///             still contain any & character for ALT-key access to the menu.
/// \param      -> IDint    the int value representing the top level menu ID
/// \remarks
/// Called from: the App's GetTopLevelMenuName().
/// This function determines the string value that represents the top level menu ID according
/// to the m_pAI_MenuStructure that was populated from the SetupDefaultMenuStructure() function.
/// Note: The default string representations of the top level menus are all localizable as
/// they exist in the AIMenuBarFunc() produced by wxDesigner.
//////////////////////////////////////////////////////////////////////////////////////////
wxString CAdapt_ItApp::GetTopLevelMenuLabelForThisTopLevelMenuID(int IDint)
{
    wxString nullStr = _T("");
    // do a reality check
    wxASSERT(m_pAI_MenuStructure != NULL);
    if (m_pAI_MenuStructure == NULL)
    {
        return nullStr;
    }
    wxString menuLabel;
    MainMenuItemList::Node* mmNode;
    AI_MainMenuItem* pMainMenuItem;
    int ct;
    int nMainMenuItems = (int)m_pAI_MenuStructure->aiMainMenuItems.GetCount();
    for (ct = 0; ct < nMainMenuItems; ct++)
    {
        mmNode = m_pAI_MenuStructure->aiMainMenuItems.Item(ct);
        pMainMenuItem = mmNode->GetData();
        menuLabel = pMainMenuItem->mainMenuLabel;
        if (pMainMenuItem->mainMenuIDint == IDint)
        {
            return menuLabel;
        }
    }
    return nullStr;
}

/* This function is currently unused (and possibly incomplete/untested) but might be useful in the future
// Gets the label of the top level AI menu where the submenu having IDStr is located
// according to the current information stored in the m_pAI_MenuStructure object.
wxString CAdapt_ItApp::GetTopLevelMenuLabelForThisSubMenuID(wxString IDStr)
{
wxString nullStr = _T("");
// do a reality check
wxASSERT(m_pAI_MenuStructure != NULL);
if (m_pAI_MenuStructure == NULL)
{
return nullStr;
}
wxString menuLabel;
MainMenuItemList::Node* mmNode;
AI_MainMenuItem* pMainMenuItem;
int ct;
int nMainMenuItems = (int)m_pAI_MenuStructure->aiMainMenuItems.GetCount();
for (ct = 0; ct < nMainMenuItems; ct++)
{
mmNode = m_pAI_MenuStructure->aiMainMenuItems.Item(ct);
pMainMenuItem = mmNode->GetData();
menuLabel = pMainMenuItem->mainMenuLabel;
SubMenuItemList::Node* smNode;
AI_SubMenuItem* pSubMenuItem;
int ct_sm;
int nSubMenuItems = (int)pMainMenuItem->aiSubMenuItems.GetCount();
for (ct_sm = 0; ct_sm < nSubMenuItems; ct_sm++)
{
smNode = pMainMenuItem->aiSubMenuItems.Item(ct_sm);
pSubMenuItem = smNode->GetData();
if (pSubMenuItem->subMenuID == IDStr)
{
return menuLabel;
}
}
}
return nullStr;
}
*/

/* This function is currently unused (and possibly incomplete/untested) but might be useful in the future
// Gets a wxArrayString of the menu item IDs that occur after the menu item
// represented by IDStr within the same top level menu, according to the current
// information stored in the m_pAI_MenuStructure object.
wxArrayString CAdapt_ItApp::GetMenuItemsThatFollowThisSubMenuID(wxString IDStr)
{
wxArrayString itemArray;
itemArray.Clear();
wxString nullStr = _T("");
// do a reality check
wxASSERT(m_pAI_MenuStructure != NULL);
if (m_pAI_MenuStructure == NULL)
{
return itemArray; // array will have zero items
}
wxString mainMenuLabel;
wxString sameMenuLabel = _T("");
MainMenuItemList::Node* mmNode;
AI_MainMenuItem* pMainMenuItem;
bool bStartCopying = FALSE;
int ct;
int nMainMenuItems = (int)m_pAI_MenuStructure->aiMainMenuItems.GetCount();
for (ct = 0; ct < nMainMenuItems; ct++)
{
mmNode = m_pAI_MenuStructure->aiMainMenuItems.Item(ct);
pMainMenuItem = mmNode->GetData();
mainMenuLabel = pMainMenuItem->mainMenuLabel;
SubMenuItemList::Node* smNode;
AI_SubMenuItem* pSubMenuItem;
int ct_sm;
int nSubMenuItems = (int)pMainMenuItem->aiSubMenuItems.GetCount();
for (ct_sm = 0; ct_sm < nSubMenuItems; ct_sm++)
{
smNode = pMainMenuItem->aiSubMenuItems.Item(ct_sm);
pSubMenuItem = smNode->GetData();
if (bStartCopying && mainMenuLabel == sameMenuLabel)
{
itemArray.Add(pSubMenuItem->subMenuID);
}
if (pSubMenuItem->subMenuID == IDStr)
{
bStartCopying = TRUE; //
sameMenuLabel = mainMenuLabel;
}
}
}
return itemArray;
}
*/

/* This function is currently unused (and possibly uncomplete/untested) but might be useful in the future
// This is an override of the previous function that gets an array of menu
// labels instead of menu ID strings.
// Gets a wxArrayString of the menu item IDs that occur after the menu item
// represented by IDStr within the same top level menu, according to the current
// information stored in the m_pAI_MenuStructure object.
wxArrayString CAdapt_ItApp::GetMenuItemsThatFollowThisSubMenuID(wxString IDStr, wxString Label)
{
// the wxString Label paramter is not needed other than to make the signature of this
// override function be different from the other function that returns an array of ID
// strings.
wxArrayString itemArray;
itemArray.Clear();
wxString nullStr = _T("");
// do a reality check
wxASSERT(m_pAI_MenuStructure != NULL);
if (m_pAI_MenuStructure == NULL)
{
return itemArray; // array will have zero items
}
wxString mainMenuLabel;
wxString sameMenuLabel = _T("");
MainMenuItemList::Node* mmNode;
AI_MainMenuItem* pMainMenuItem;
bool bStartCopying = FALSE;
int ct;
int nMainMenuItems = (int)m_pAI_MenuStructure->aiMainMenuItems.GetCount();
for (ct = 0; ct < nMainMenuItems; ct++)
{
mmNode = m_pAI_MenuStructure->aiMainMenuItems.Item(ct);
pMainMenuItem = mmNode->GetData();
mainMenuLabel = pMainMenuItem->mainMenuLabel;
SubMenuItemList::Node* smNode;
AI_SubMenuItem* pSubMenuItem;
int ct_sm;
int nSubMenuItems = (int)pMainMenuItem->aiSubMenuItems.GetCount();
for (ct_sm = 0; ct_sm < nSubMenuItems; ct_sm++)
{
smNode = pMainMenuItem->aiSubMenuItems.Item(ct_sm);
pSubMenuItem = smNode->GetData();
if (bStartCopying && mainMenuLabel == sameMenuLabel)
{
if (pSubMenuItem->subMenuKind == _T("wxITEM_SEPARATOR"))
itemArray.Add(_T("menuSeparator"));
else
itemArray.Add(pSubMenuItem->subMenuLabel); // Add label rather than ID string
}
if (pSubMenuItem->subMenuID == IDStr)
{
bStartCopying = TRUE; //
sameMenuLabel = mainMenuLabel;
}
}
}
return itemArray;
}
*/

//////////////////////////////////////////////////////////////////////////////////////////
/// \return     an array of pointers of wxMenuItem objects on the heap
/// \param      -> pMainMenuItem    the AI_MainMenuItem struct on the heap whose sub items are
///                                 being collected
/// \remarks
/// Called from: the App's ConfigureMenuBarForUserProfile().
/// This function scans the main menu struct of the default AI menu structure represented
/// in the pMainMenuItem incoming parameter, and collects the pointers of the structs of type
/// AI_SubMenuItem* representing the sub menu items contained in that main menu.
//////////////////////////////////////////////////////////////////////////////////////////
wxArrayPtrVoid CAdapt_ItApp::GetMenuStructureItemsArrayForThisTopLevelMenu(AI_MainMenuItem* pMainMenuItem)
{
    wxArrayPtrVoid itemArray;
    itemArray.Clear();
    wxString nullStr = _T("");
    // do a reality check
    wxASSERT(m_pAI_MenuStructure != NULL);
    if (m_pAI_MenuStructure == NULL)
    {
        return itemArray; // array will have zero items
    }
    wxString mainMenuLabel = pMainMenuItem->mainMenuLabel;
    wxString sameMenuLabel = _T("");
    int ct = 0;
    int nMainMenuItems = (int)m_pAI_MenuStructure->aiMainMenuItems.GetCount();
    AI_MainMenuItem* pmmItem = NULL;
    MainMenuItemList::Node* mmNode = m_pAI_MenuStructure->aiMainMenuItems.GetFirst();
    while (mmNode != NULL && ct < nMainMenuItems)
    {
        pmmItem = mmNode->GetData();
        mmNode = mmNode->GetNext();
        if (pmmItem->mainMenuLabel == mainMenuLabel)
            break;
        ct++;
    }
    wxASSERT(pmmItem != NULL);
    SubMenuItemList::Node* smNode;
    AI_SubMenuItem* pSubMenuItem;
    int ct_sm;
    int nSubMenuItems = (int)pmmItem->aiSubMenuItems.GetCount();
    for (ct_sm = 0; ct_sm < nSubMenuItems; ct_sm++)
    {
        smNode = pmmItem->aiSubMenuItems.Item(ct_sm);
        pSubMenuItem = smNode->GetData();
        itemArray.Add(pSubMenuItem);
    }
    return itemArray;
}

//////////////////////////////////////////////////////////////////////////////////////////
/// \return     a wxString representing the menu label of the incoming topLevelMenu enum
/// \param      -> topLevelMenu    the enum of the top level menu whose label we are
///                                 determining
/// \remarks
/// Called from: the App's ConfigureMenuBarForUserProfile() and GetTopLevelMenuFromAIMenuBar().
/// This function determines which string value label is associated (by default) with the
/// enums describing the top level menus in Adapt It.
/// Note: The default string representations of the top level menus are all localizable, but
/// a user could change the labels of AI's top level menus via the AI_UserProfiles.xml file's
/// mainMenuLabel attribute of its MENU_STRUCTURE > MAIN_MENU entires without having to do
/// an entire localization.
//////////////////////////////////////////////////////////////////////////////////////////
wxString CAdapt_ItApp::GetTopLevelMenuName(TopLevelMenu topLevelMenu)
{
    wxASSERT(m_pAI_MenuStructure != NULL);
    wxASSERT(m_pAI_MenuStructure->aiMainMenuItems.GetCount() > 0);
    switch (topLevelMenu)
    {
    case fileMenu:
        return GetTopLevelMenuLabelForThisTopLevelMenuID(ID_FILE_MENU);
    case editMenu:
        return GetTopLevelMenuLabelForThisTopLevelMenuID(ID_EDIT_MENU);
    case viewMenu:
        return GetTopLevelMenuLabelForThisTopLevelMenuID(ID_VIEW_MENU);
    case toolsMenu:
        return GetTopLevelMenuLabelForThisTopLevelMenuID(ID_TOOLS_MENU);
    case exportImportMenu:
        return GetTopLevelMenuLabelForThisTopLevelMenuID(ID_EXPORT_IMPORT_MENU);
    case advancedMenu:
        return GetTopLevelMenuLabelForThisTopLevelMenuID(ID_ADVANCED_MENU);
    case layoutMenu:
        return GetTopLevelMenuLabelForThisTopLevelMenuID(ID_LAYOUT_MENU);
    case helpMenu:
        return GetTopLevelMenuLabelForThisTopLevelMenuID(ID_HELP_MENU);
    case administratorMenu:
        return GetTopLevelMenuLabelForThisTopLevelMenuID(ID_ADMINISTRATOR_MENU);
    default:
        wxString msg = msg.Format(_T("Programming Error: The GetTopLevelMenuName() function received an illegal TopLevelFunction enum value of %d"), topLevelMenu);
        wxASSERT_MSG(FALSE, msg); // programming error
        return _T("");
    }
}

//////////////////////////////////////////////////////////////////////////////////////////
/// \return     an int representing the current value of the top level menu's identifier,
///                     i.e., an int for ID_FILE_MENU, etc.
/// \param      -> topLevelMenuLabel the wxString value of the top level menu whose int
///                                  we are determining
/// \remarks
/// Called from: the App's SetupDefaultMenuStructure().
/// This function determines int value of the top level menu's identifier which is associated
/// with the input string in topLevelMenuLabel.
//////////////////////////////////////////////////////////////////////////////////////////
int CAdapt_ItApp::GetTopLevelMenuID(const wxString topLevelMenuLabel)
{
    wxString topLevelMenuLabelPlain;
    topLevelMenuLabelPlain = topLevelMenuLabel;
    if (topLevelMenuLabelPlain == _("&File"))
        return ID_FILE_MENU;
    else if (topLevelMenuLabelPlain == _("&Edit"))
        return ID_EDIT_MENU;
    else if (topLevelMenuLabelPlain == _("&View"))
        return ID_VIEW_MENU;
    else if (topLevelMenuLabelPlain == _("&Tools"))
        return ID_TOOLS_MENU;
    else if (topLevelMenuLabelPlain == _("E&xport-Import"))
        return ID_EXPORT_IMPORT_MENU;
    else if (topLevelMenuLabelPlain == _("&Advanced"))
        return ID_ADVANCED_MENU;
    else if (topLevelMenuLabelPlain == _("&Layout"))
        return ID_LAYOUT_MENU;
    else if (topLevelMenuLabelPlain == _("&Help"))
        return ID_HELP_MENU;
    else if (topLevelMenuLabelPlain == _("Ad&ministrator"))
        return ID_ADMINISTRATOR_MENU;
    else
    {
        wxASSERT_MSG(FALSE, _T("Programmer Error in GetTopLevelMenuID() function - Unknown top level menu ID symbol."));
        return -1;
    }
}

//////////////////////////////////////////////////////////////////////////////////////////
/// \return     an int representing the current value of the top level menu's identifier,
///                     i.e., an int for ID_FILE_MENU, etc.
/// \param      -> topLevelMenu the enum value of the top level menu whose int
///                                  we are determining
/// \remarks
/// Called from: the App's ConfigureMenuBarForUserProfile().
/// This function is an override of the function that uses the menu label string as an
/// imput parameter. This one determines int value of the top level menu's identifier w
/// hich is associated with the input enum in topLevelMenu.
//////////////////////////////////////////////////////////////////////////////////////////
int CAdapt_ItApp::GetTopLevelMenuID(TopLevelMenu topLevelMenu)
{
    switch (topLevelMenu)
    {
    case fileMenu:
    {
        return ID_FILE_MENU;
        break;
    }
    case editMenu:
    {
        return ID_EDIT_MENU;
        break;
    }
    case viewMenu:
    {
        return ID_VIEW_MENU;
        break;
    }
    case toolsMenu:
    {
        return ID_TOOLS_MENU;
        break;
    }
    case exportImportMenu:
    {
        return ID_EXPORT_IMPORT_MENU;
        break;
    }
    case advancedMenu:
    {
        return ID_ADVANCED_MENU;
        break;
    }
    case layoutMenu:
    {
        return ID_LAYOUT_MENU;
        break;
    }
    case helpMenu:
    {
        return ID_HELP_MENU;
        break;
    }
    case administratorMenu:
    {
        return ID_ADMINISTRATOR_MENU;
        break;
    }
    default:
    {
        wxASSERT_MSG(FALSE, _T("Programmer Error in GetTopLevelMenuID() function - Unknown top level menu ID symbol."));
        return -1;
    }
    } // end of switch (topLevelMenu)
}

//////////////////////////////////////////////////////////////////////////////////////////
/// \return     a pointer to a wxMenu* object representing the top level menu of the AI
///             menu bar which is associated with the incoming topLevelMenu enum parameter
/// \param      -> topLevelMenu    the enum of the top level menu whose wxMenu object we are
///                                 locating
/// \remarks
/// Called from: the App's MakeMenuInitializationsAndPlatformAdjustments().
/// This function locates and returns the pointer to the wxMenu object that represents the
/// wxMenu* of the AI menu bar associated with the incoming topLevelMenu enum parameter.
//////////////////////////////////////////////////////////////////////////////////////////
wxMenu* CAdapt_ItApp::GetTopLevelMenuFromAIMenuBar(TopLevelMenu topLevelMenu)
{
    CMainFrame* pMainFrame = GetMainFrame();
    wxMenuBar* pMenuBar = pMainFrame->GetMenuBar();
    wxString tempName;
    int index;
    tempName = GetTopLevelMenuName(topLevelMenu);
    index = pMenuBar->FindMenu(tempName); // ignores & chars in name
    if (index == wxNOT_FOUND)
    {
        return (wxMenu*)NULL;
    }
    return pMenuBar->GetMenu(index);
}

//////////////////////////////////////////////////////////////////////////////////////////
/// \return     an int representing the menu item id of the AI menu bar being examined
/// \param      -> mainMenuItemLabel  the string label of the top level menu of the menu bar
/// \param      -> menuItemLabel  the string label of the sub menu item of the menu bar
/// \param      -> tempMenuBar  the AI Menu Bar we are examining (generally a temp one)
/// \remarks
/// Called from: the App's ConfigureMenuBarForUserProfile().
/// This function determines and returns the int value of the identifier which was used
/// in creating the menu item in the tempMenuBar; the menu item being specified by its
/// location as being in the mainMenuItemLabel top level menu, and menuItemLabel sub
/// menu label. This function is a work around as it seems there is no way to determine
/// what the internal int value is of a program identifier such as ID_FILE_MENU when
/// one only knows the string value "ID_FILE_MENU". Moreover, the available functions
/// wxMenuBar::FindMenuItem() and wxMenu::FindItem() only take menu item labels.
/// Note: a menu separator has the value of wxID_SEPARATOR which is -2.
/// We cannot store the int values of identifiers in AI_UserProfiles.xml since those
/// int values will change for each build in which wxDesigner's inventory of identifiers
/// changes (it assigns them afresh for each build).
//////////////////////////////////////////////////////////////////////////////////////////
int CAdapt_ItApp::GetSubMenuItemIdFromAIMenuBar(wxString mainMenuItemLabel, wxString menuItemLabel, wxMenuBar* tempMenuBar)
{
    // The only available options to get an int id are via calling wxMenu::FindItem(const wxString& itemString) const
    // or wxMenuBar::FindMenuItem(const wxString& menuString, const wxString& itemString) const
    // on the appropriate top level menu of the tempMenuBar
    wxString menuItemLabelPlain = menuItemLabel;
    menuItemLabelPlain = menuItemLabelPlain; // RemoveMenuLabelDecorations(menuItemLabelPlain); // FindMenuItem() below strips out decorations
    int menuItemId;
    if (menuItemLabelPlain.IsEmpty())
        return wxID_SEPARATOR; // wxID_SEPARATOR has value of -2.
    else
    {
        menuItemId = tempMenuBar->FindMenuItem(mainMenuItemLabel, menuItemLabelPlain);
        return menuItemId;
    }
}

//////////////////////////////////////////////////////////////////////////////////////////
/// \return     an int representing line position where replacement was done in the f wxTextFile
/// \param      -> f  the wxText file whose line we are modifying
/// \param      -> itemTextStr the highest level profile item we are looking for
/// \param      -> profileStr  the profile section under itemTextStr
/// \param      -> valueStr  the string value of the itemVisibility for the given profileStr
/// \remarks
/// Called from: the App's SaveUserProfilesMergingDataToXMLFile().
/// This function scans through the file f until it locates the line containing itemTextStr,
/// continues until the profileStr associated with itemTextStr is found, then replaces the
/// itemVisibility value associated with the above with the valueStr parameter.
//////////////////////////////////////////////////////////////////////////////////////////
int CAdapt_ItApp::ReplaceVisibilityStrInwxTextFile(wxTextFile* f, wxString itemTextStr, wxString profileStr, wxString valueStr)
{
    wxString lineStr;
    int linePos = -1;
    if (f->IsOpened())
    {
        // Note: we are scanning an in-memory representation of the xml file, so
        // our comparison string itemTextStr needs to have xml entity representations
        // to effect the comparison
        wxString str = itemTextStr;
        str.Replace(_T("&"), wxString::FromAscii(xml_amp)); // replacing '&' must be done first!
        str.Replace(_T("<"), wxString::FromAscii(xml_lt));
        str.Replace(_T(">"), wxString::FromAscii(xml_gt));
        str.Replace(_T("'"), wxString::FromAscii(xml_apos));
        str.Replace(_T("\""), wxString::FromAscii(xml_quote));
        str.Replace(_T("\t"), wxString::FromAscii(xml_tab)); // whm added 24May11

        bool bFoundItemTextLine = FALSE;
        for (lineStr = f->GetFirstLine(); !f->Eof() && !bFoundItemTextLine; lineStr = f->GetNextLine())
        {
            int chPos;
            // does this line have our itemTextStr?
            chPos = lineStr.Find(_T("itemText=\"") + str + _T("\""));
            if (chPos != wxNOT_FOUND)
            {
                bFoundItemTextLine = TRUE;
            }
        }
        if (bFoundItemTextLine)
        {
            // note: lineStr is now the next line beyond the "itemText..." line
            // so use a do ... while () loop
            bool bFoundProfileLine = FALSE;
            bool bMadeReplacement = FALSE;
            int chPos;
            do
            {
                chPos = lineStr.Find(profileStr);
                if (chPos != wxNOT_FOUND)
                {
                    bFoundProfileLine = TRUE;
                }
                lineStr = f->GetNextLine();
            } while (!bFoundProfileLine && !f->Eof());
            if (bFoundProfileLine)
            {
                // the lineStr = f->GetNextLine() call above means we should now be pointing at the
                // itemVisibility line that we want to modify
                if (lineStr.Find(_T("itemVisibility")) != wxNOT_FOUND)
                {
                    int rPos = -1;
                    if (lineStr.Find(_T("\"0\"")) != wxNOT_FOUND)
                    {
                        rPos = (int)lineStr.Replace(_T("\"0\""), _T("\"1\""));
                    }
                    else if (lineStr.Find(_T("\"1\"")) != wxNOT_FOUND)
                    {
                        rPos = (int)lineStr.Replace(_T("\"1\""), _T("\"0\""));
                    }
                    else
                    {
                        wxASSERT(FALSE); // programmer error!
                        return linePos;
                    }
                    if (rPos != wxNOT_FOUND)
                        bMadeReplacement = TRUE;
                }
                else
                {
                    wxASSERT(FALSE); // programmer error!
                    return linePos;
                }
            }
            else
            {
                wxASSERT(FALSE); // programmer error!
                return linePos;
            }
            if (bMadeReplacement)
            {
                linePos = f->GetCurrentLine();
            }
        }
        else
        {
            wxASSERT(FALSE);
            return linePos;
        }
        wxString testStr1, testStr2; // for debugging below
        if (linePos != wxNOT_FOUND)
        {
            // now remove the "current" textFile line and replace it with lineStr
            testStr1 = f->GetLine(linePos); // for debugging
            f->RemoveLine(linePos);
            f->InsertLine(lineStr, linePos);
            testStr2 = f->GetLine(linePos); // for debugging
        }
    }
    return linePos;
}


//////////////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \param      -> f  the wxText file whose line we are modifying
/// \remarks
/// Called from: the App's SaveUserProfilesMergingDataToXMLFile().
/// This function is called last after updating the wxTextFile with all other changes made
/// to the user workflow profiles. Here we update the adminModified="" line in the wxTextFile
/// to adminModified="Yes" if the data in the file differs from the factory data (determined
/// by calling CommonItemsInProfilesDiffer), otherwise we we ensure that the line reads
/// adminModified="No". Note: Working from the factory data as a baseline allows for the
/// possibility that a AI_UserProfiles.xml file that was previously modified resulting in the
/// line becoming adminModified="Yes", could now be modified again resulting in the line becoming
/// adminModified="No" in the event that the later modifications returned the data in the file
/// back to be identidal to the factory data.
//////////////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItApp::UpdateAdminModifiedLineToYesOrNo(wxTextFile* f)
{
    bool bProfilesDiffer = FALSE;
    bProfilesDiffer = CommonItemsInProfilesDiffer(m_pUserProfiles, m_pFactoryUserProfiles);

    wxString lineStr;
    int linePos = -1;
    if (f->IsOpened())
    {
        bool bFoundAdminModifiedLine = FALSE;
        for (lineStr = f->GetFirstLine(); !f->Eof() && !bFoundAdminModifiedLine; lineStr = f->GetNextLine())
        {
            int chPos;
            // does this line have our adminModified= line? If so, change it to adminModified="Yes"
            // or adminModified="No" depending on the value of bProfilesDiffer.
            chPos = lineStr.Find(_T("adminModified="));
            if (chPos != wxNOT_FOUND)
            {
                bFoundAdminModifiedLine = TRUE;
                linePos = f->GetCurrentLine();
                wxString str = lineStr;
                if (bProfilesDiffer)
                {
                    // The profiles are different so modifications were made.
                    // If adminModified="No" is in the line replace it with adminModified="Yes"
                    if (str.Find(_T("adminModified=\"No\"")) != wxNOT_FOUND)
                    {
                        str.Replace(_T("adminModified=\"No\""), _T("adminModified=\"Yes\""));
                    }
                }
                else
                {
                    // The profiles are essentially the same as factory there are now no modifications.
                    // If adminModified="Yes" is in the line replace it with adminModified="No"
                    if (str.Find(_T("adminModified=\"Yes\"")) != wxNOT_FOUND)
                    {
                        str.Replace(_T("adminModified=\"Yes\""), _T("adminModified=\"No\""));
                    }
                }
                wxString testStr1, testStr2; // for debugging below
                if (linePos != wxNOT_FOUND)
                {
                    // now remove the "current" textFile line and replace it with lineStr
                    testStr1 = f->GetLine(linePos); // for debugging
                    f->RemoveLine(linePos);
                    f->InsertLine(str, linePos);
                    testStr2 = f->GetLine(linePos); // for debugging
                }
                break;
            }
        }
    }
}

//////////////////////////////////////////////////////////////////////////////////////////
/// \return     an int representing line position where replacement was done in the f wxTextFile
/// \param      -> f   the wxTextFile whose descriptionProfileN data we are replacing
/// \param      -> descrProfileN  the descriptionProfileN we are looking for in the file
/// \param      -> valueStr  the value of the new replacement descriptionProfileN text
/// \remarks
/// Called from: the App's SaveUserProfilesMergingDataToXMLFile().
/// This function scans through the file f until it locates the line containing descrProfileN,
/// then it replaces the existing text with the text in valueSrt.
//////////////////////////////////////////////////////////////////////////////////////////
int CAdapt_ItApp::ReplaceDescriptionStrInwxTextFile(wxTextFile* f, wxString descrProfileN, wxString valueStr)
{
    wxString lineStr;
    int linePos = -1;
    if (f->IsOpened())
    {
        bool bFoundDescrLine = FALSE;
        for (lineStr = f->GetFirstLine(); !f->Eof() && !bFoundDescrLine; lineStr = f->GetNextLine())
        {
            int chPos;
            // does this line have our itemTextStr?
            chPos = lineStr.Find(descrProfileN);
            if (chPos != wxNOT_FOUND)
            {
                bFoundDescrLine = TRUE;
            }
        }
        if (bFoundDescrLine)
        {
            // note: lineStr is now the next line beyond the "itemText..." line
            // so back up one line
            lineStr = f->GetPrevLine();
            wxString testStr1, testStr2; // for debugging below
            if (lineStr.Find(descrProfileN) != wxNOT_FOUND)
            {
                // Note: the default descriptive text describing each profile does not
                // use any "entities". However, since the description field is editable
                // by the user, a user may have introduced some characters or "entities"
                // i.e., '<', '>' '&', ''', and '"'. These need to be replaced by the
                // xml form: &lt;, &gt; &amp; &apos; and &quot; respectively, otherwise
                // it will produce malformed xml. The XML.cpp file has a ReplaceEntities()
                // function but it takes a CBString. Rather than converting to and from
                // CBString to use that function, we'll simply do the conversion directly
                // here.
                wxString str = valueStr;
                // replace entities
                str.Replace(_T("&"), wxString::FromAscii(xml_amp)); // replacing '&' must be done first!
                str.Replace(_T("<"), wxString::FromAscii(xml_lt));
                str.Replace(_T(">"), wxString::FromAscii(xml_gt));
                str.Replace(_T("'"), wxString::FromAscii(xml_apos));
                str.Replace(_T("\""), wxString::FromAscii(xml_quote));
                str.Replace(_T("\t"), wxString::FromAscii(xml_tab)); // whm added 24May11

                lineStr = lineStr.Mid(0, descrProfileN.Length() + 1); // removes "="..." to right end of descr line
                lineStr += _T("=\"");
                lineStr += str;
                lineStr += _T("\"");
                linePos = f->GetCurrentLine();
                testStr1 = f->GetLine(linePos); // for debugging
                f->RemoveLine(linePos);
                f->InsertLine(lineStr, linePos);
                testStr2 = f->GetLine(linePos); // for debugging
            }
            else
            {
                wxASSERT(FALSE); // programmer error!
                return linePos;
            }
        }
    }
    return linePos;
}

//////////////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \remarks
/// Called from: the App's OnInit().
/// On Windows machines, transitions any registry information previously stored in the
/// Adapt_It_WX registry key to a Adapt_It_WX.ini file-on-disk format configuration file
/// and, once done, removes the old Adapt_It_WX registry key from the Windows registry,
/// so that this transition to using the file-on-disk format needs to happen only once.
/// As of version 6.0.0, the information saved previously in the Windows registry under
/// the HKEY_CURRENT_USER\Software\Adapt_It_WX key is now stored instead in a disk file
/// called Adapt_It_WX.ini - so that the Windows port now saves this information in the
/// same way that the Linux and Mac ports save it. It also makes Adapt It 6.0.0 more
/// compatible as a PortableApps application.
//////////////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItApp::TransitionWindowsRegistryEntriesTowxFileConfig()
{
#ifdef __WXMSW__ // only need to do this on a Windows host system
    // only transition data if the Adapt_It_WX key exists in the host Windows' registry
    wxRegKey keyAIWX(_T("HKEY_CURRENT_USER\\Software\\Adapt_It_WX"));
    if (keyAIWX.Exists())
    {
        // From version 6.0.0 Adapt It uses a wxFileConfig object instead of a wxConfig object
        // on the App called m_pConfig.
        // When TransitionWindowsRegistryEntriesTowxFileConfig() is called we don't know
        // whether AI's config info was transitioned previously from the host Windows'
        // registry or not, so we'll do this with a local object that we delete at the
        // end of this function.
        // The registry groups prior to 6.0.0 will have this heirarchical structure:
        // Adapt_It_WX
        //    Recent_File_List           [contains 11 REG_SZ entries and 8 REG_DWORD entries]
        //       wxHtmlWindow            [contains 3 REG_SZ entries and 8 REG_DWORD entries]
        //    Recent_File_List_Unicode   [contains 11 REG_SZ entries and 8 REG_DWORD entries]
        //       wxHtmlWindow            [contains 3 REG_SZ entries and 8 REG_DWORD entries]
        //    Settings                   [containes 13 REG_SZ entries and 3 REG_DWORD entries]
        //
        wxConfig* mpConfig;
        mpConfig = new wxConfig(_T("Adapt_It_WX")); // a local instance of wxConfig
        wxASSERT(mpConfig != NULL);

        wxFileConfig* mpFileConfig;
        // Note: in the wxFileConfig call below:
        // m_wxFileConfigPathAndName = m_appUserConfigDir + PathSeparator + _T("Adapt_It_WX.ini") on Windows
        // m_wxFileConfigPathAndName = m_appUserConfigDir + PathSeparator + _T(".Adapt_It_WX") on Linux and Mac
        mpFileConfig = new wxFileConfig(wxEmptyString, wxEmptyString, m_wxFileConfigPathAndName, wxEmptyString);
        wxASSERT(mpFileConfig != NULL);

        int nG;
        // Note: GetNumberOfEntries does not include the (Default) entry shown as first line in Regedit
        nG = mpConfig->GetNumberOfGroups(FALSE); // FALSE don't count groups recursively (i.e., don't include the wxHtmlWindow groups)
        bool bGroupOK;
        wxString groupName;
        long groupIndex; // we don't use this returned groupIndex
        bGroupOK = mpConfig->GetFirstGroup(groupName, groupIndex);
        int ctG = 0;
        while (bGroupOK && ctG < nG && !groupName.IsEmpty())
        {
            wxString path = _T('/') + groupName;
            // set the path to the current Group
            mpConfig->SetPath(path); // we know it exists so it won't be created
                                     // write the Group name to the mpFileConfig object
            mpFileConfig->SetPath(path); // if groupName doesn't exist it is created
                                         // read all entries for this group and write them to the wxFileConfig object
            wxString valueStr = _T("");
            int valueInt = 0;
            bool valueBool = FALSE;
            wxString entryName;
            bool bEntryOK;
            long entryIndex;
            int nE = mpConfig->GetNumberOfEntries(FALSE); // FALSE don't count entries recursively
            bEntryOK = mpConfig->GetFirstEntry(entryName, entryIndex);
            int ctE = 0;
            while (bEntryOK && ctE < nE && !entryName.IsEmpty())
            {
                bool bReadOK = FALSE;
                if (mpConfig->GetEntryType(entryName) == mpConfig->Type_String)
                    bReadOK = mpConfig->Read(entryName, &valueStr);
                else if (mpConfig->GetEntryType(entryName) == mpConfig->Type_Integer)
                    bReadOK = mpConfig->Read(entryName, &valueInt);
                else if (mpConfig->GetEntryType(entryName) == mpConfig->Type_Boolean)
                    bReadOK = mpConfig->Read(entryName, &valueBool);
                if (bReadOK)
                {
                    bool bWriteOK = FALSE;
                    if (mpConfig->GetEntryType(entryName) == mpConfig->Type_String)
                        bWriteOK = mpFileConfig->Write(entryName, valueStr);
                    else if (mpConfig->GetEntryType(entryName) == mpConfig->Type_Integer)
                        bWriteOK = mpFileConfig->Write(entryName, valueInt);
                    else if (mpConfig->GetEntryType(entryName) == mpConfig->Type_Boolean)
                        bWriteOK = mpFileConfig->Write(entryName, valueBool);
                    if (!bWriteOK)
                    {
                        wxASSERT(FALSE);
                    }
                }
                else
                {
                    wxASSERT(FALSE);
                }
                ctE++;
                bEntryOK = mpConfig->GetNextEntry(entryName, entryIndex);
            }
            // all the entries of the current Group have been copied, but
            // there are also some sub-Groups called "wxHtmlWindow" containing
            // more entries, so we now handle those before getting the next top
            // level group
            int nSubG;
            nSubG = mpConfig->GetNumberOfGroups(FALSE); // don't count recursively
            bool bSubGroupOK;
            wxString subGroupName;
            long subGroupIndex; // we don't use this returned groupIndex
            bSubGroupOK = mpConfig->GetFirstGroup(subGroupName, subGroupIndex);
            int ctSubG = 0;
            while (bSubGroupOK && ctSubG < nSubG && !subGroupName.IsEmpty())
            {
                wxString subPath = _T('/') + groupName + _T('/') + subGroupName;
                // set the path to the current Group
                mpConfig->SetPath(subPath); // we know it exists so it won't be created
                                            // write the Group name to the mpFileConfig object
                mpFileConfig->SetPath(subPath); // if groupName doesn't exist it is created
                                                // read all entries for this group and write them to the wxFileConfig object
                wxString subValueStr = _T("");
                int subValueInt = 0;
                bool subValueBool = FALSE;
                wxString subEntryName;
                bool bSubEntryOK;
                long subEntryIndex;
                int nSubE = mpConfig->GetNumberOfEntries(FALSE); // FALSE don't count entries recursively
                bSubEntryOK = mpConfig->GetFirstEntry(subEntryName, subEntryIndex);
                int ctSubE = 0;
                while (bSubEntryOK && ctSubE < nSubE && !subEntryName.IsEmpty())
                {
                    bool bSubReadOK = FALSE;
                    if (mpConfig->GetEntryType(subEntryName) == mpConfig->Type_String)
                        bSubReadOK = mpConfig->Read(subEntryName, &subValueStr);
                    else if (mpConfig->GetEntryType(subEntryName) == mpConfig->Type_Integer)
                        bSubReadOK = mpConfig->Read(subEntryName, &subValueInt);
                    else if (mpConfig->GetEntryType(subEntryName) == mpConfig->Type_Boolean)
                        bSubReadOK = mpConfig->Read(subEntryName, &subValueBool);
                    if (bSubReadOK)
                    {
                        bool bSubWriteOK = FALSE;
                        if (mpConfig->GetEntryType(subEntryName) == mpConfig->Type_String)
                            bSubWriteOK = mpFileConfig->Write(subEntryName, subValueStr);
                        else if (mpConfig->GetEntryType(subEntryName) == mpConfig->Type_Integer)
                            bSubWriteOK = mpFileConfig->Write(subEntryName, subValueInt);
                        else if (mpConfig->GetEntryType(subEntryName) == mpConfig->Type_Boolean)
                            bSubWriteOK = mpFileConfig->Write(subEntryName, subValueBool);
                        if (!bSubWriteOK)
                        {
                            wxASSERT(FALSE);
                        }
                    }
                    ctSubE++;
                    bSubEntryOK = mpConfig->GetNextEntry(subEntryName, subEntryIndex);
                }
                ctSubG++;
                bSubGroupOK = mpConfig->GetNextGroup(subGroupName, subGroupIndex);
            }
            ctG++;
            // set the paths back up to the top level
            mpConfig->SetPath(_T('/'));
            mpFileConfig->SetPath(_T('/'));
            bGroupOK = mpConfig->GetFirstGroup(groupName, groupIndex); // have to initialize group list again with GetFirstGroup
                                                                       // get the next first level group after the previous one (which is ctG steps down from top level)
            for (int i = 0; i < ctG; i++)
            {
                bGroupOK = mpConfig->GetNextGroup(groupName, groupIndex);
            }
        }
        // Delete the Adapt_It_WX key along with all of its subgroups and subentries
        bool bDeletedOK = TRUE;
        bDeletedOK = keyAIWX.DeleteSelf(); // deletes the key with all its sub entries recursively
        wxASSERT(bDeletedOK == TRUE);
        mpConfig->Flush();
        mpFileConfig->Flush();
        // Finally, delete the temporary objects we've used above.
        // Note: mpFileConfig will be created again for the duration of the running app
        // in OnInit() just after this function ends.
        if (mpConfig != NULL) // whm 11Jun12 added NULL test
            delete mpConfig;
        if (mpFileConfig != NULL) // whm 11Jun12 added NULL test
            delete mpFileConfig;
    }
#endif
}

//////////////////////////////////////////////////////////////////////////////////////////
/// \return     nothing
/// \remarks
/// Called from: the App's OnInit().
/// Removes all collaboration settings previously stored in the Adapt_It_WX.ini
/// file-on-disk format configuration file. With project-specific collaboration it
/// is no longer necessary to save collaboration settings in the Adapt_It_WX.ini
/// file. If we did the Adapt_It_WX.ini file would have to have separate settings
/// for each Adapt It project that the administrator has configured for collaboration
/// with Paratext/Bibledit.
//////////////////////////////////////////////////////////////////////////////////////////
void CAdapt_ItApp::RemoveCollabSettingsFromFailSafeStorageFile()
{
    if (m_pConfig == NULL)
    {
        wxASSERT_MSG(FALSE, _T("Programming Error: the m_pConfig pointer in RemoveCollabSettingsFromFailSafeStorageFile() was NULL"));
        return;
    }
    wxString oldPath = m_pConfig->GetPath(); // is always absolute path "/Recent_File_List"
    bool bDelOK;
    m_pConfig->SetPath(_T("/Settings"));
    wxLogNull logNo; // eliminates spurious message from the system: "Can't read value
                     // of key 'HKCU\Software\Adapt_It_WX\Settings' Error" [valid until end of this block]
                     // whm Note 27Mar12. We want to purge the Adapt_It_WX.ini (.Adapt_It_WX) file of all
                     // collaboration settings whether for pt or be, so we look for any/all such settings
                     // and delete any that are found.
    bDelOK = m_pConfig->DeleteEntry(_T("pt_collaboration"), TRUE);
    bDelOK = m_pConfig->DeleteEntry(_T("pt_collab_src_proj"), TRUE);
    bDelOK = m_pConfig->DeleteEntry(_T("pt_collab_tgt_proj"), TRUE);
    bDelOK = m_pConfig->DeleteEntry(_T("pt_collab_free_trans_proj"), TRUE);
    bDelOK = m_pConfig->DeleteEntry(_T("pt_collab_ai_proj_name"), TRUE);
    bDelOK = m_pConfig->DeleteEntry(_T("pt_collab_book_selected"), TRUE);
    bDelOK = m_pConfig->DeleteEntry(_T("pt_collab_by_chapter_only"), TRUE);
    bDelOK = m_pConfig->DeleteEntry(_T("pt_collab_chapter_selected"), TRUE);
    bDelOK = m_pConfig->DeleteEntry(_T("pt_collab_src_lang_name"), TRUE);
    bDelOK = m_pConfig->DeleteEntry(_T("pt_collab_tgt_lang_name"), TRUE);

    bDelOK = m_pConfig->DeleteEntry(_T("be_collaboration"), TRUE);
    bDelOK = m_pConfig->DeleteEntry(_T("be_collab_src_proj"), TRUE);
    bDelOK = m_pConfig->DeleteEntry(_T("be_collab_tgt_proj"), TRUE);
    bDelOK = m_pConfig->DeleteEntry(_T("be_collab_free_trans_proj"), TRUE);
    bDelOK = m_pConfig->DeleteEntry(_T("be_collab_ai_proj_name"), TRUE);
    bDelOK = m_pConfig->DeleteEntry(_T("be_collab_book_selected"), TRUE);
    bDelOK = m_pConfig->DeleteEntry(_T("be_collab_by_chapter_only"), TRUE);
    bDelOK = m_pConfig->DeleteEntry(_T("be_collab_chapter_selected"), TRUE);
    bDelOK = m_pConfig->DeleteEntry(_T("be_collab_src_lang_name"), TRUE);
    bDelOK = m_pConfig->DeleteEntry(_T("be_collab_tgt_lang_name"), TRUE);

    bDelOK = bDelOK; // to avoid warning. It is not important whether the entries get removed or not
    m_pConfig->Flush(); // write now, otherwise write takes place when m_pConfig is destroyed in OnExit().
                        // restore the oldPath back to "/Recent_File_List"
    m_pConfig->SetPath(oldPath);
}


// The XML.cpp's InsertEntities() function takes a CBString which is inconvenient
// here so we'll just insert entities manually.
// replace any entity chars with their xml entity representations
wxString CAdapt_ItApp::InsertEntities(wxString str)
{
    str.Replace(_T("&"), wxString::FromAscii(xml_amp)); // replacing '&' must be done first!
    str.Replace(_T("<"), wxString::FromAscii(xml_lt));
    str.Replace(_T(">"), wxString::FromAscii(xml_gt));
    str.Replace(_T("'"), wxString::FromAscii(xml_apos));
    str.Replace(_T("\""), wxString::FromAscii(xml_quote));
    str.Replace(_T("\t"), wxString::FromAscii(xml_tab)); // whm added 24May11
    return str;
}

void CAdapt_ItApp::LogUserAction(wxString msg)
{
    if (m_userLogFile != NULL)
    {
        // Convert any \n chars in msg to <BR> to keep each msg to one line,
        // but embedded <BR> would allow us to process line breaks for display
        // as HTML.
        msg.Replace(_T("\n"), _T("<BR>"));
        wxDateTime theTime = wxDateTime::Now(); //initialize to the current time
        wxString timeStr;
        timeStr = theTime.Format();
        m_userLogFile->Write(timeStr + _T(':') + msg + m_eolStr);
        m_userLogFile->Flush();
    }
}

// whm 6Apr2020 added to replace logging system BEW setup earlier.
// whm 13Apr2020 revised and relocated some calls to higher calling routines, added ***End-of-Document***
// logging lines, and logging of steps 1-9 of the lengthy OK_btn_delayedHandler_GetSourceTextFromEditor()
// function during collab document creation/opening.
// This log function simply appends a line to the end of the current session's doc creation
// log file which persists on the App for a given session; App's m_docCreationLogFile points to the function.
// The function that appends the string lines to this log file is called CAdapt_ItApp::LogDocCreationData().
// The LogDocCreationData() function is called only when user has specifically ticked a check box in either
// the docPage (for non-collaboration document creation/optining); or the GetSourceTextFromEditor dialog
// (for collaboration document creation/opening), which sets the App's m_bMakeDocCreationLogfile TRUE.
// The LogDocCreationData() function is only called when the App's m_bMakeDocCreationLogfile global flag
// is TRUE.
// USAGE: The LogDocCreationData() function calls are strategically located to capture log output at user
// direction at the following points in program flow:
// These calls below are for writing the log's first line only (the file path/name and date-time stamp).
//    1. In CAdapt_ItDoc::OnNewDocument() before TokenizeText() is called - when creating a new
//       non-collab AI document, i.e., gpApp->LogDocCreationData(fileNameLine);
//    2. In CAdapt_ItDoc::OnOpenDocument() just before its ReadDoc_XML() call - when opening an existing
//       non-collab AI xml document, i.e., gpApp->LogDocCreationData(fileNameLine);
//    3. In CollabUtilities.cpp's OK_btn_delayedHandler_GetSourceTextFromEditor() function - when opening
//       either an existing collab document, or creating a new collabo document, i.e., pApp->LogDocCreationData(fileNameLine);
// These calls below are for logging the data lines for each source phrase/word parsed, its sequ num, and ch:vs ref:
//    4. In CAdapt_ItDoc::TokenizeText() after ParseWord() and ParsePreWord() calls have been made - when creating
//       a new AI document, i.e., pApp->LogDocCreationData(strLine);
//    5. In XML.cpp's AtDocEndTag() - when opening an existing XML document, i.e., gpApp->LogDocCreationData(strLine);
// These calls below are for logging an ***End-of-Document*** last line in the log for a given doc creation/opening:
//    6. In CAdapt_ItDoc::OnNewDocument() - when at the end of creating a new non-collab document after successful
//       TokenizeText(), i.e., pApp->LogDocCreationData(_T("***End-of-Document***"));
//    7. In CAdapt_ItDoc::OnOpenDocument() - when at the end of opening an existing non-collab XML AI document, i.e.,
//       gpApp->LogDocCreationData(_T("***End-of-Document***"));
//    8. In CollabUtilities.cpp's OK_btn_delayedHandler_GetSourceTextFromEditor() function - when at
//       the end of either creating or opening a collab document, i.e., pApp->LogDocCreationData(_T("***End-of-Document***"));
// Note additional LogDocCreationData() calls are made between points 3 and 4 above to log Steps 1-4 and Step 5 within
// the lengthy OK_btn_delayedHandler_GetSourceTextFromEditor() function. More LogDocCreationData() calls are
// also made after the parsing points 4 and 5 above to log Steps 5, 6, 7, 8, and 9 before reaching points 6-8
// above - the logging of ***End-of-Document***.
// The m_docCreationLogFile is saved in the user's _LOGS_EMAIL_REPORTS folder.
void CAdapt_ItApp::LogDocCreationData(wxString ParsedWordDataLine)
{
    if (m_docCreationLogFile != NULL)
    {
        // Convert any \n chars in ParsedWordDataLine to <BR> to keep each output to one line,
        // but embedded <BR> would allow us to process line breaks for display
        // as HTML.
        ParsedWordDataLine.Replace(_T("\n"), _T("<BR>"));
        // For doc creation logging, a timeStr should only be included with the filename at beginning of
        // the log for a given document being opened, hence the timeStr calculation should be done before
        // the LogDocCreationData, and already be concatenated with the ParseMoreDataLine strin that
        // is input into this function via its parameter.
        //wxDateTime theTime = wxDateTime::Now(); //initialize to the current time
        //wxString timeStr;
        //timeStr = theTime.Format();
        //m_docCreationLogFile->Write(timeStr + _T(':') + ParsedWordDataLine + m_eolStr);
        m_docCreationLogFile->Write(ParsedWordDataLine + m_eolStr); // m_eolStr makes it a plain text file with appropriate eols.
        m_docCreationLogFile->Flush();
    }
}

// This function determines which versions of Paratext are installed on this
// computer. It sets a set of 13 boolean values which are stored in the App's
// global space. These global bool variables are:
//   gbPTVer7Installed
//   gbPTVer8Installed
//   gbPTVer9Installed
//   gbPTLinuxVer7Installed
//   gbPTLinuxVer8Installed
//   gbPTLinuxVer9Installed
//   gbPTVer7OnlyInstalled
//   gbPTVer8OnlyInstalled
//   gbPTVer9OnlyInstalled
//   gbPTLinuxVer7OnlyInstalled
//   gbPTLinuxVer8OnlyInstalled
//   gbPTLinuxVer9OnlyInstalled
//   gbPTNotInstalled
//
// This function is called initially from the App's OnInit() function when the
// program loads up. It is also called any time the Administrator accesses
// the SetupEditorCollaboration dialog from the Administrator menu - ensuring
// that when the Administrator accesses the SetupEditorCollaboration the above
// PT installation-related bools are up to date.
void CAdapt_ItApp::InventoryCollabEditorInstalls()
{
    // These bool values below represent what versions of Paratext are installed.
    // This function is called initially from the App's OnInit() function when the
    // program loads up. It is also called again any time the Administrator accesses
    // the SetupEditorCollaboration dialog from the Administrator menu.
    // Within the CSetupEditorCollaboration class it is called early in the InitDialog()
    // method.
    // These global bool values were all initialized to FALSE in the App's global space,
    // and then changed to TRUE below if that particular PT version is found to be installed
    // at the time this function is called (either in App's OnInit() or the
    // CSetupEditorCollaboration dialog).
    gbPTVer7Installed = IsThisParatextVersionInstalled(_T("PTVersion7"));
    gbPTVer8Installed = IsThisParatextVersionInstalled(_T("PTVersion8"));;
    gbPTVer9Installed = IsThisParatextVersionInstalled(_T("PTVersion9"));;
    gbPTLinuxVer7Installed = IsThisParatextVersionInstalled(_T("PTLinuxVersion7"));;
    gbPTLinuxVer8Installed = IsThisParatextVersionInstalled(_T("PTLinuxVersion8"));;
    gbPTLinuxVer9Installed = IsThisParatextVersionInstalled(_T("PTLinuxVersion9"));;

    // Set up some convenience boolean variables for other possible PT installations, and a boolean
    // for whan no PT installations are found.

    // First, set some convenience bools that indicate when ONLY a certain version is installed on this machine
    if (gbPTVer7Installed && !gbPTVer8Installed && !gbPTVer9Installed && !gbPTLinuxVer7Installed && !gbPTLinuxVer8Installed && !gbPTLinuxVer9Installed)
        gbPTVer7OnlyInstalled = TRUE;
    if (gbPTVer8Installed && !gbPTVer7Installed && !gbPTVer9Installed && !gbPTLinuxVer7Installed && !gbPTLinuxVer8Installed && !gbPTLinuxVer9Installed)
        gbPTVer8OnlyInstalled = TRUE;
    if (gbPTVer9Installed && !gbPTVer7Installed && !gbPTVer8Installed && !gbPTLinuxVer7Installed && !gbPTLinuxVer8Installed && !gbPTLinuxVer9Installed)
        gbPTVer9OnlyInstalled = TRUE;
    if (gbPTLinuxVer7Installed && !gbPTVer7Installed && !gbPTVer8Installed && !gbPTVer9Installed && !gbPTLinuxVer8Installed && !gbPTLinuxVer9Installed)
        gbPTLinuxVer7OnlyInstalled = TRUE;
    if (gbPTLinuxVer8Installed && !gbPTVer7Installed && !gbPTVer8Installed && !gbPTVer9Installed && !gbPTLinuxVer7Installed && !gbPTLinuxVer9Installed)
        gbPTLinuxVer8OnlyInstalled = TRUE;
    if (gbPTLinuxVer9Installed && !gbPTVer7Installed && !gbPTVer8Installed && !gbPTVer9Installed && !gbPTLinuxVer7Installed && !gbPTLinuxVer8Installed)
        gbPTLinuxVer9OnlyInstalled = TRUE;

    // Also set another convenience bool named gbPTNotInstalled if none of the PT versions are installed
    // on this machine.
    if (!gbPTVer7Installed && !gbPTVer8Installed && !gbPTVer9Installed && !gbPTLinuxVer7Installed && !gbPTLinuxVer8Installed && !gbPTLinuxVer9Installed)
        gbPTNotInstalled = TRUE;
}

//////////////////////////////////////////////////////////////////////////////////////////
/// \return     TRUE if the PT version represented by the PTVersion string is installed on the computer,
///             having a Paratext.exe file within the installation location and a data store in the
///             appropriate location for the specified PT version.
///             FALSE if the installation's Paratext.exe cannot be found, or the appropriate data store
///             folder cannot be found for the specified PT version.
/// \param   -> PTVersion  A wxString which must be one of: "PTVersion7", "PTVersion8", "PTVersion9",
///             "PTLinuxVersion7", "PTLinuxVersion8", or "PTLinuxVersion9"
/// \remarks    This function is a convenience function that uses much of the same code as the
/// ParatextVersionInstalled() function. This function just verifies whether a particular PT version is
/// actually installed on the computer - where "installed" means having the requisite Paratext.exe
/// executable within installation location/folder as determined by the registry, and has a Paratext
/// data store folder at the location as determined by the registry or failing that, the default location.
/// This function does not attempt to determine whether the PT version has any appropriate projects for
/// collaboration or not, nor whether those projects are valid projects for adaptation purposes.
/// whm 4Feb2020 added mainly to be able to enable/disable the "Paratext 7", "Paratext 8" and "Paratext 9"
/// radio buttons appropriately in the CSetupEditorCollaboration class, but it could be used elsewhere
/// when one wants to know if a single version of Paratext is installed on the computer.
/// Called from: CSetupEditorCollaboration::DoInit(),
bool CAdapt_ItApp::IsThisParatextVersionInstalled(wxString PTVersion)
{
#ifdef __WXMSW__ // Windows host -- use registry

    wxLogNull logNo; // eliminate any spurious messages from the system

    wxString dirStrValue;
    dirStrValue.Empty();
    // In this function we'll get the installation folder info from the registry only as required by the
    // specific version specified in the PTVersion input string.
    // There are two registry views where the PT 8 key might be depending on the host OS architecture
    // NOTE: With its initial relaease PT9 uses the same registry key that is used below for PT8,
    // that is ...\Paratext\8 so we'll declare the wxRegKey for PT8 here before the if blocks below
    // since the following two wxRegKey instances may be used in both the PTVersion9 block and the
    // "PTVersion8" block farther below.
    wxRegKey keyOS64PT8InstallDir(_T("HKEY_LOCAL_MACHINE\\SOFTWARE\\WOW6432Node\\Paratext\\8"));
    wxRegKey keyOS32PT8InstallDir(_T("HKEY_LOCAL_MACHINE\\SOFTWARE\\Paratext\\8"));
    if (PTVersion == _T("PTVersion9"))
    {
        // CAUTION: What if the PT developers decide to change the RegKey of a PT9 installation to make
        // it conform to the actual version number? i.e., ...\\Paratext\\9 ??? If they ever decide to do
        // so, this function will fail to detect that PT version. So, as a way to forestall that possibility,
        // we can do a little pre-emptive programming and test here for a ...\\Paratext\\9 key, and if it
        // exists use it, otherwise we go ahead and use the current ...\\Paratext\\8 key above for the
        // "PTVersion9" test.
        wxRegKey keyOS64PT9InstallDir(_T("HKEY_LOCAL_MACHINE\\SOFTWARE\\WOW6432Node\\Paratext\\9"));
        wxRegKey keyOS32PT9InstallDir(_T("HKEY_LOCAL_MACHINE\\SOFTWARE\\Paratext\\9"));
        if (keyOS64PT9InstallDir.Exists() && keyOS64PT9InstallDir.HasValues())
        {
            if (keyOS64PT9InstallDir.Open(wxRegKey::Read)) // open the key for reading only!
            {
                // get the folder path stored in the key, (i.e., C:\Program Files (x86)\Paratext9\)
                keyOS64PT9InstallDir.QueryValue(_T("Program_Files_Directory_Ptw9"), dirStrValue);
                // remove the final backslash, since our path values generally don't have a
                // trailing path separator.
                if (!dirStrValue.IsEmpty() && dirStrValue.GetChar(dirStrValue.Length() - 1) == _T('\\'))
                    dirStrValue.RemoveLast(1);
                // Note: PT9 installations don't have a ParatextShared.dll
                if (::wxDirExists(dirStrValue) && ::wxFileExists(dirStrValue + _T("\\") + _T("Paratext.exe")))
                {
                    return TRUE;
                }
            }
        }
        else if (keyOS32PT9InstallDir.Exists() && keyOS32PT9InstallDir.HasValues())
        {
            if (keyOS32PT9InstallDir.Open(wxRegKey::Read)) // open the key for reading only!
            {
                // whm 4Feb2020 added following query for "Program_Files_Directory_Ptw9"
                // get the folder path stored in the key, (i.e., C:\Program Files\Paratext9\)
                keyOS32PT9InstallDir.QueryValue(_T("Program_Files_Directory_Ptw9"), dirStrValue);
                // remove the final backslash, since our path values generally don't have a
                // trailing path separator.
                if (!dirStrValue.IsEmpty() && dirStrValue.GetChar(dirStrValue.Length() - 1) == _T('\\'))
                    dirStrValue.RemoveLast(1);
                // Note: PT9 installations don't have a ParatextShared.dll
                if (::wxDirExists(dirStrValue) && ::wxFileExists(dirStrValue + _T("\\") + _T("Paratext.exe")))
                {
                    return TRUE;
                }
            }
        }
        // Now check for the PT reg key that is \\Paratext\\8
        else if (keyOS64PT8InstallDir.Exists() && keyOS64PT8InstallDir.HasValues())
        {
            if (keyOS64PT8InstallDir.Open(wxRegKey::Read)) // open the key for reading only!
            {
                // get the folder path stored in the key, (i.e., C:\Program Files (x86)\Paratext9\)
                keyOS64PT8InstallDir.QueryValue(_T("Program_Files_Directory_Ptw9"), dirStrValue);
                // remove the final backslash, since our path values generally don't have a
                // trailing path separator.
                if (!dirStrValue.IsEmpty() && dirStrValue.GetChar(dirStrValue.Length() - 1) == _T('\\'))
                    dirStrValue.RemoveLast(1);
                // Note: PT9 installations don't have a ParatextShared.dll
                if (::wxDirExists(dirStrValue) && ::wxFileExists(dirStrValue + _T("\\") + _T("Paratext.exe")))
                {
                    return TRUE;
                }
            }
        }
        else if (keyOS32PT8InstallDir.Exists() && keyOS32PT8InstallDir.HasValues())
        {
            if (keyOS32PT8InstallDir.Open(wxRegKey::Read)) // open the key for reading only!
            {
                // whm 4Feb2020 added following query for "Program_Files_Directory_Ptw9"
                // get the folder path stored in the key, (i.e., C:\Program Files\Paratext9\)
                keyOS32PT8InstallDir.QueryValue(_T("Program_Files_Directory_Ptw9"), dirStrValue);
                // remove the final backslash, since our path values generally don't have a
                // trailing path separator.
                if (!dirStrValue.IsEmpty() && dirStrValue.GetChar(dirStrValue.Length() - 1) == _T('\\'))
                    dirStrValue.RemoveLast(1);
                // Note: PT9 installations don't have a ParatextShared.dll
                if (::wxDirExists(dirStrValue) && ::wxFileExists(dirStrValue + _T("\\") + _T("Paratext.exe")))
                {
                    return TRUE;
                }
            }
        }
        // whm 4Feb2020 added additional checks for Paratext.exe located at their default PT9
        // folder locations - this is a fallback in case wxRegKey fails above even though
        // the Paratext 9 executables exist at their normal default paths for Windows.
        if (dirStrValue.IsEmpty() || !::wxDirExists(dirStrValue))
        {
            // Check the default PT9 installation location for 32-bit/64-bit PT
            wxString exePathPT9_on_32bitOS = _T("C:\\Program Files\\Paratext 9\\Paratext.exe");
            wxString exePathPT9_on_64bitOS = _T("C:\\Program Files (x86)\\Paratext 9\\Paratext.exe");
            // whm Note: There is no ParatextShared.dll in PT 9
            if (::wxFileExists(exePathPT9_on_32bitOS))
            {
                return TRUE;
            }
            else if (::wxFileExists(exePathPT9_on_64bitOS))
            {
                return TRUE;
            }
        }
    }
    else if (PTVersion == _T("PTVersion8"))
    {
        // There are two registry views where the PT 8 key might be depending on the host OS architecture
        // NOTE: PT9 uses the same registry key that is used below for PT8 ...\Paratext\8
        // The wxRegKey's are constructed up near the beginning of this function.
        if (keyOS64PT8InstallDir.Exists() && keyOS64PT8InstallDir.HasValues())
        {
            if (keyOS64PT8InstallDir.Open(wxRegKey::Read)) // open the key for reading only!
            {
                // get the folder path stored in the key, (i.e., C:\Program Files (x86)\Paratext9\)
                keyOS64PT8InstallDir.QueryValue(_T("Program_Files_Directory_Ptw8"), dirStrValue);
                // remove the final backslash, since our path values generally don't have a
                // trailing path separator.
                if (!dirStrValue.IsEmpty() && dirStrValue.GetChar(dirStrValue.Length() - 1) == _T('\\'))
                    dirStrValue.RemoveLast(1);
                // Note: Don't bother looking for the existence of ParatextShared.dll along with Paratext.exe
                if (::wxDirExists(dirStrValue) && ::wxFileExists(dirStrValue + _T("\\") + _T("Paratext.exe")))
                {
                    return TRUE;
                }
            }
        }
        else if (keyOS32PT8InstallDir.Exists() && keyOS32PT8InstallDir.HasValues())
        {
            if (keyOS32PT8InstallDir.Open(wxRegKey::Read)) // open the key for reading only!
            {
                // get the folder path stored in the key, (i.e., C:\Program Files\Paratext9\)
                keyOS32PT8InstallDir.QueryValue(_T("Program_Files_Directory_Ptw8"), dirStrValue);
                // remove the final backslash, since our path values generally don't have a
                // trailing path separator.
                if (!dirStrValue.IsEmpty() && dirStrValue.GetChar(dirStrValue.Length() - 1) == _T('\\'))
                    dirStrValue.RemoveLast(1);
                // Note: Don't bother looking for the existence of ParatextShared.dll along with Paratext.exe
                if (::wxDirExists(dirStrValue) && ::wxFileExists(dirStrValue + _T("\\") + _T("Paratext.exe")))
                {
                    return TRUE;
                }
            }
        }
        // whm 22Jan2018 added additional checks for Paratext.exe and (possibly) ParatextShared.dll located at
        // their default PT8 folder locations - fallback in case wxRegKey fails above even though
        // the Paratext 8 executables exist at their normal default paths for Windows. See function header
        // for the reason for this default check.
        if (dirStrValue.IsEmpty() || !::wxDirExists(dirStrValue))
        {
            // Check the default PT8 installation location for 32-bit/64-bit PT
            wxString exePathPT8_on_32bitOS = _T("C:\\Program Files\\Paratext 8\\Paratext.exe");
            wxString exePathPT8_on_64bitOS = _T("C:\\Program Files (x86)\\Paratext 8\\Paratext.exe");
            // whm 4Feb2020 decided to forego the detection of ParatextShared.dll since is was being
            // discontinued at some point before PT9 release.
            //wxString dllPathPT8_on_32bitOS = _T("C:\\Program Files\\Paratext 8\\ParatextShared.dll");
            //wxString dllPathPT8_on_64bitOS = _T("C:\\Program Files (x86)\\Paratext 8\\ParatextShared.dll");
            if (::wxFileExists(exePathPT8_on_32bitOS))
            {
                return TRUE;
            }
            else if (::wxFileExists(exePathPT8_on_64bitOS))
            {
                return TRUE;
            }
        }
    }
    else if (PTVersion == _T("PTVersion7"))
    {
        wxRegKey keyPT7InstallDir(_T("HKEY_LOCAL_MACHINE\\SOFTWARE\\ScrChecks\\1.0\\Program_Files_Directory_Ptw7"));
        if (keyPT7InstallDir.Exists() && keyPT7InstallDir.HasValues())
        {
            if (keyPT7InstallDir.Open(wxRegKey::Read)) // open the key for reading only!
            {
                // get the folder path stored in the key, (i.e., C:\Program Files\Paratext7\)
                // Note: the dirStrValue path ends with a backslash so we don't add one here.
                dirStrValue = keyPT7InstallDir.QueryDefaultValue();
                // remove the final backslash, since our path values generally don't have a
                // trailing path separator.
                if (!dirStrValue.IsEmpty() && dirStrValue.GetChar(dirStrValue.Length() - 1) == _T('\\'))
                    dirStrValue.RemoveLast(1);
                // Note: Don't bother looking for the existence of ParatextShared.dll along with Paratext.exe
                if (::wxDirExists(dirStrValue) && ::wxFileExists(dirStrValue + _T("\\") + _T("Paratext.exe")))
                {
                    return TRUE;
                }
            }
        }
        // whm 22Jan2018 added additional checks for Paratext.exe and ParatextShared.dll located at
        // their default PT7 folder locations - fallback in case wxRegKey fails above even though
        // the Paratext 7 executables exist at their normal default paths for Windows.
        if (dirStrValue.IsEmpty() || !::wxDirExists(dirStrValue))
        {
            // Check the default PT7 installation location for 32-bit PT
            wxString exePathPT7_on_32bitOS = _T("C:\\Program Files\\Paratext 7\\Paratext.exe");
            wxString exePathPT7_on_64bitOS = _T("C:\\Program Files (x86)\\Paratext 7\\Paratext.exe");
            wxString dllPathPT7_on_32bitOS = _T("C:\\Program Files\\Paratext 7\\ParatextShared.dll");
            wxString dllPathPT7_on_64bitOS = _T("C:\\Program Files (x86)\\Paratext 7\\ParatextShared.dll");
            if ((::wxFileExists(exePathPT7_on_32bitOS)
                && ::wxFileExists(dllPathPT7_on_32bitOS)))
            {
                return TRUE;
            }
            else if ((::wxFileExists(exePathPT7_on_64bitOS)
                && ::wxFileExists(dllPathPT7_on_64bitOS)))
            {
                return TRUE;
            }
        }
    }
#endif

#if defined(__WXGTK__) // linux -- look for the files in /usr/lib/Paratext/ and/or /usr/lib/Paratext8

    // The following don't need to be conditionally compiled since
    // they would only be called on a Linux machine running the Linux version
    // of Paratext.
    if (PTVersion == _T("PTLinuxVersion9"))
    {
        wxString strDir = _T("/usr/lib/Paratext9");
        if (::wxDirExists(strDir))
        {
            return TRUE;
        }
    }
    else if (PTVersion == _T("PTLinuxVersion8"))
    {
        wxString strDir = _T("/usr/lib/Paratext8");
        if (::wxDirExists(strDir))
        {
            return TRUE;
        }
        else
        {
            // there was no /usr/lib/Paratext8 directory, so check for an installation of the
            // early PT8 beta that used the /usr/lib/Paratext directory - as verified by finding
            // a major version number of 8 in its PTVersion file.
            strDir = _T("/usr/lib/Paratext");
            if (::wxDirExists(strDir))
            {
                // The normal PT7 install directory exists, check if it has a PT8 early beta installation in it
                wxString PTLinuxMajorVersionNumStr;
                PTLinuxMajorVersionNumStr = GetLinuxPTVersionNumberFromPTVersionFile(strDir + PathSeparator + _T("PTVersion"));
                //wxLogDebug(_T("Linux PT Version found was version \"%s\" as found by GetLinuxPTVersionNumberFromPTVersionFile()"), PTLinuxMajorVersionNumStr.c_str());
                if (PTLinuxMajorVersionNumStr == _T("8"))
                    return TRUE;
                // if the major version is indeed 7, then we found no "PTLinuxVersion8" installation.
            }
        }
    }
    else if (PTVersion == _T("PTLinuxVersion7"))
    {
        wxString strDir = _T("/usr/lib/Paratext");
        if (::wxDirExists(strDir))
        {
            return TRUE;
        }
    }
#endif


    return FALSE; // when all tests above fail
}

// whm 4Feb2020 added the following function to consolidate same/similar code in 4 locations in SetupEditorCollaboration.
// This function validates the Collab Editor (Paratext or Bibledit), and for Paratext validates the
// Paratext version string (m_TempCollabEditorVersion). It returns the validated collab editor by
// reference via the first parameter, and the function itself returns the validated PT version that
// gets assigned to the App's m_ParatextVersionForProject, or to m_TempCollabEditorVersion string.
// If a collabEditor cannot be determined the first parameter returns an empty string by reference
// otherwise it returns either "Paratext" or "Bibledit".
// If either the collabEditor, or a valid PT version cannot be determined the function itself returns
// an empty string.
// This function is called from:
//   CAdapt_ItApp::SetCollabSettingsToNewProjDefaults() within CAdapt_ItApp::OnInit()'s,
//   CAdapt_ItApp::GetAIProjectCollabStatus(),
//   CSetupEditorCollaboration::InitDialog(), and
//   CSetupEditorCollaboration::DoSetControlsFromConfigFileCollabData() [3X].
wxString CAdapt_ItApp::ValidateCollabEditorAndVersionStrAgainstInstallationData(wxString &collabEditor, wxString collabEditorVerStr)
{
    // whm 4Feb2020 Note: Either parateter of this function can be empty strings when this function is called.
    // In fact, both parameters will be empty when it is first called in the SetCollabSettingsToNewProjectDefaults()
    // function call within the App's OnInit(). Just before that first call, the App value for m_collaborationEditor
    // and m_ParatextVersionForProject will have been initialized to empty strings, and the result of this
    // ValidateCollabEditorAndVersionStrAgainstInstallationData() function call there will be that m_collaborationEditor
    // will remain an empty string, but if any version of PT is installed, the highest version of PT installed will
    // be assigned to the m_ParatextVersionForProject App value. However, at that OnInit() call no project settings
    // will be changed since no project has yet been opened when the OnInit() call is made.
    // Only when this ValidateCollabEditorAndVersionStrAgainstInstallationData() function is called from
    wxString tempCollabEditorVerStr;
    tempCollabEditorVerStr = collabEditorVerStr;

    // The boolean values used in the test below are determined in InitDialog()
    if (gbPTVer7Installed || gbPTVer8Installed || gbPTVer9Installed || gbPTLinuxVer7Installed || gbPTLinuxVer8Installed || gbPTLinuxVer9Installed)
    {
        collabEditor = _T("Paratext");

        // Ensure the PT version for tempCollabEditorVerStr is set appropriately.
        if (gbPTVer7OnlyInstalled)
        {
            // Only PT version 7 is installed, so ensure that tempCollabEditorVerStr is set to "PTVersion7"
            // since it is the only version for possible collaboration.
            tempCollabEditorVerStr = _T("PTVersion7");
        }
        else if (gbPTVer8OnlyInstalled)
        {
            // Only PT version 8 is installed, so ensure that tempCollabEditorVerStr is set to "PTVersion8"
            // since it is the only version for possible collaboration.
            tempCollabEditorVerStr = _T("PTVersion8");
        }
        // whm 4Feb2020 added test for PTVer9
        else if (gbPTVer9OnlyInstalled)
        {
            // Only PT version 9 is installed, so ensure that tempCollabEditorVerStr is set to "PTVersion9"
            // since it is the only version for possible collaboration.
            tempCollabEditorVerStr = _T("PTVersion9");
        }
        // Now that the "Only" versions are bled off, check when two or more version are
        // installed, starting with all 3 versions are installed, and moving on to when
        // just 2 of the 3 are installed.
        else if (gbPTVer7Installed && gbPTVer8Installed && gbPTVer9Installed)
        {
            // All 3 PT versions are installed - a quite possible scenario for long-term PT users.
            // If tempCollabEditorVerStr is NOT empty when we get here, AND it points to an installed
            // version of PT, then we accept what it points to even an older PT version and the Administrator
            // can select a newer version if desired, but we should keep the older version config value
            // so start with.
            // If tempCollabEditorVerStr IS EMPTY, or it doesn't point to one of the installed PT
            // versions, set it to the highest installed version, in this case "PTVersion9".
            // Note: If tempCollabEditorVerStr has a value of "PTVersion7" or "PTVersion8", or "PTVersion9"
            // it will NOT be changed by the test below.
            if (tempCollabEditorVerStr.IsEmpty())
            {
                // A normal assignment when called from OnInit(), don't log
                tempCollabEditorVerStr = _T("PTVersion9");
            }
            else if (tempCollabEditorVerStr != _T("PTVersion9") && tempCollabEditorVerStr != _T("PTVersion8") && tempCollabEditorVerStr != _T("PTVersion7"))
            {
                // Neither PT 9 or PT 8 or PT 7 had valid projects dir path or at least 2 useable projects.
                // Log the problem in user log since it has to be fixed by administrator.
                wxString msg = _T("In ValidateCollabEditorAndVersionStrAgainstInstallationData() PT9, PT8 and PT7 are all installed but none has valid projects dir or neither has at least 2 useable projects. Setting PT version to a default of PTVersion9.");
                LogUserAction(msg);
                // Assume the administrator will fix this situation. In the mean time, since both
                // PT 9, PT 8 and PT 7 are installed, default here to the highest installed version PTVersion9.
                tempCollabEditorVerStr = _T("PTVersion9");
            }
        }
        else if (gbPTVer8Installed && gbPTVer9Installed)
        {
            // PT8 and PT9 are installed - PT7 not installed - the common case for recent PT users who
            // upgraded from PT8 to PT9.
            // If tempCollabEditorVerStr is NOT empty when we get here, AND it points to an installed
            // version of PT, then we accept what it points to even an older PT version and the Administrator
            // can select a newer version if desired, but we should keep the older version config value
            // so start with.
            // If tempCollabEditorVerStr IS EMPTY, or it doesn't point to one of the installed PT
            // versions, set it to the highest installed version, in this case "PTVersion9".
            // Note: If tempCollabEditorVerStr has a value of "PTVersion9" or "PTVersion8" it will NOT be
            // changed by the test below.
            if (tempCollabEditorVerStr.IsEmpty())
            {
                // A normal assignment when called from OnInit(), don't log
                tempCollabEditorVerStr = _T("PTVersion9");
            }
            else if (tempCollabEditorVerStr != _T("PTVersion9") && tempCollabEditorVerStr != _T("PTVersion8"))
            {
                // Neither PT 9 or PT 8 had valid projects dir path or at least 2 useable projects.
                // Log the problem in user log since it has to be fixed by administrator.
                wxString msg = _T("In ValidateCollabEditorAndVersionStrAgainstInstallationData() both PT9 and PT8 are installed but neither has valid projects dir or neither has at least 2 useable projects. Setting PT version to a default of PTVersion9.");
                LogUserAction(msg);
                // Assume the administrator will fix this situation. In the mean time, since both
                // PT 9 and PT 8 are installed, default here to the highest installed version PTVersion9.
                tempCollabEditorVerStr = _T("PTVersion9");
            }
        }
        else if (gbPTVer7Installed && gbPTVer9Installed)
        {
            // PT7 and PT9 are installed - PT8 not installed - this would be fairly uncommon unless a
            // user previously used PT7 and never migrated data to a PT8 installation before installing
            // PT9.
            // If tempCollabEditorVerStr is NOT empty when we get here, AND it points to an installed
            // version of PT, then we accept what it points to even an older PT version and the Administrator
            // can select a newer version if desired, but we should keep the older version config value
            // so start with.
            // If tempCollabEditorVerStr IS EMPTY, or it doesn't point to one of the installed PT
            // versions, set it to the highest installed version, in this case "PTVersion9".
            // Note: If tempCollabEditorVerStr has a value of "PTVersion7" or "PTVersion9" it will NOT be
            // changed by the test below.
            if (tempCollabEditorVerStr.IsEmpty())
            {
                // A normal assignment when called from OnInit(), don't log
                tempCollabEditorVerStr = _T("PTVersion9");
            }
            else if (tempCollabEditorVerStr != _T("PTVersion9") && tempCollabEditorVerStr != _T("PTVersion7"))
            {
                // Neither PT 9 or PT 7 had valid projects dir path or at least 2 useable projects, log the problem
                wxString msg = _T("In ValidateCollabEditorAndVersionStrAgainstInstallationData() both PT7 and PT9 are installed but neither has valid projects dir or neither has at least 2 useable projects. Setting PT version to PTVersion9 as default.");
                LogUserAction(msg);
                // Assume the administrator will fix this situation. In the mean time, since both
                // PT 9 and PT 7 are installed,default here to highest installed version PTVersion9.
                tempCollabEditorVerStr = _T("PTVersion9");
            }
        }
        else if (gbPTVer7Installed && gbPTVer8Installed)
        {
            // Both PT versions 7 and 8 are installed on the machine.

            // whm modified 4Feb2020. Set the PT version according to what is specified in the project
            // config file unless it is the case that tempCollabEditorVerStr is an empty string.
            // If it is an empty string then we will have to guess which PT version the user might want.
            // As of December 31, 2019 all PT7 projects were supposed to have been migrated from PT7
            // to PT8, so I think that we can set PT8 as the suggested editor as long as there are at
            // lease 2 valid PT projects available in PT8 (source and target projects).
            // If there aren't at least 2 such valid PT projects available in PT8, the collaboration
            // can't actually be set up in this session, and we will leave the suggestion set to
            // "PTVersion7".
            // Note: If tempCollabEditorVerStr has a value of "PTVersion7" or "PTVersion8" it will NOT be
            // changed by the test below.
            if (tempCollabEditorVerStr.IsEmpty()
                || (tempCollabEditorVerStr != _T("PTVersion8") && tempCollabEditorVerStr != _T("PTVersion7")))
            {
                // Assume that PT 8 will be the desired editor if it has a valid projects dir
                // and at least 2 valid/useable projects, otherwise PT 7
                wxString pt8ProjectsDirPath = GetParatextProjectsDirPath(_T("PTVersion8"));
                wxString pt7ProjectsDirPath = GetParatextProjectsDirPath(_T("PTVersion7"));
                wxArrayString pt8ListOfProj = GetListOfPTProjects(_T("PTVersion8"));
                wxArrayString pt7ListOfProj = GetListOfPTProjects(_T("PTVersion7"));
                int pt8Count = pt8ListOfProj.GetCount();
                int pt7Count = pt7ListOfProj.GetCount();
                if (!pt8ProjectsDirPath.IsEmpty() && pt8Count >= 2)
                {
                    tempCollabEditorVerStr = _T("PTVersion8");
                }
                else if (!pt7ProjectsDirPath.IsEmpty() && pt7Count >= 2)
                {
                    tempCollabEditorVerStr = _T("PTVersion7");
                }
                else
                {
                    // Neither PT 8 or PT 7 had valid projects dir path or at least 2 useable projects, log the problem
                    wxString msg = _T("In ValidateCollabEditorAndVersionStrAgainstInstallationData() both PT7 and PT8 are installed but neither has valid projects dir or neither has at least 2 useable projects. Setting PT version to PTVersion8 as default.");
                    LogUserAction(msg);
                    // Assume the administrator will fix this situation. In the mean time, since both
                    // PT 8 and PT 7 are installed, default here to highest installed version PTVersion8.
                    tempCollabEditorVerStr = _T("PTVersion8");
                }
            }
            // Note: If tempCollabEditorVerStr has a value of "PTVersion7" or "PTVersion8" it will NOT be
            // changed by the test below.
        }
        // ******************************** Now for the Linux Versions ********************************
        // whm 4Feb2020 added test for PTLinuxVer9
        else if (gbPTLinuxVer9OnlyInstalled)
        {
            // Only PT version 9 for Linux is installed, so ensure that tempCollabEditorVerStr is set to "PTLinuxVersion9"
            // since it is the only version for possible collaboration.
            tempCollabEditorVerStr = _T("PTLinuxVersion9");
        }
        else if (gbPTLinuxVer8OnlyInstalled)
        {
            // Only PT version 8 for Linux is installed, so ensure that tempCollabEditorVerStr is set to "PTLinuxVersion8"
            // since it is the only version for possible collaboration.
            tempCollabEditorVerStr = _T("PTLinuxVersion8");
        }
        else if (gbPTLinuxVer7OnlyInstalled)
        {
            // Only PT version 7 for Linux is installed, so ensure that tempCollabEditorVerStr is set to "PTLinuxVersion7"
            // since it is the only version for possible collaboration.
            tempCollabEditorVerStr = _T("PTLinuxVersion7");
        }
        // Now that the "Only" versions are bled off, check when two or more version are
        // installed, starting with all 3 versions are installed, and moving on to when
        // just 2 of the 3 are installed.
        else if (gbPTLinuxVer7Installed && gbPTLinuxVer8Installed && gbPTLinuxVer9Installed)
        {
            // All 3 PT Linux versions are installed - a quite possible scenario for long-term PT users.
            // If tempCollabEditorVerStr is NOT empty when we get here, AND it points to an installed
            // version of PT, then we accept what it points to even an older PT version and the Administrator
            // can select a newer version if desired, but we should keep the older version config value
            // so start with.
            // If tempCollabEditorVerStr IS EMPTY, or it doesn't point to one of the installed PT
            // versions, set it to the highest installed version, in this case "PTLinuxVersion9".
            // Note: If tempCollabEditorVerStr has a value of "PTLinuxVersion7" or "PTLinuxVersion8", or "PTLinuxVersion9"
            // it will NOT be changed by the test below.
            if (tempCollabEditorVerStr.IsEmpty())
            {
                // A normal assignment when called from OnInit(), don't log
                tempCollabEditorVerStr = _T("PTLinuxVersion9");
            }
            else if (tempCollabEditorVerStr != _T("PTLinuxVersion9") && tempCollabEditorVerStr != _T("PTLinuxVersion8") && tempCollabEditorVerStr != _T("PTLinuxVersion7"))
            {
                // Neither PT 9 or PT 8 or PT 7 had valid projects dir path or at least 2 useable projects.
                // Log the problem in user log since it has to be fixed by administrator.
                wxString msg = _T("In ValidateCollabEditorAndVersionStrAgainstInstallationData() PT9, PT8 and PT7 for Linux are all installed but none has valid projects dir or neither has at least 2 useable projects. Setting PT version to a default of PTLinuxVersion9.");
                LogUserAction(msg);
                // Assume the administrator will fix this situation. In the mean time, since both
                // PT 9, PT 8 and PT 7 are installed, default here to the highest installed version PTLinuxVersion9.
                tempCollabEditorVerStr = _T("PTLinuxVersion9");
            }
        }
        else if (gbPTLinuxVer8Installed && gbPTLinuxVer9Installed)
        {
            // PT8 and PT9 Linux versions are installed - PT7 Linux is not installed - the common case for
            // recent PT users who upgraded from PT8 to PT9.
            // If tempCollabEditorVerStr is NOT empty when we get here, AND it points to an installed
            // version of PT, then we accept what it points to even an older PT version and the Administrator
            // can select a newer version if desired, but we should keep the older version config value
            // so start with.
            // If tempCollabEditorVerStr IS EMPTY, or it doesn't point to one of the installed PT
            // versions, set it to the highest installed version, in this case "PTLinuxVersion9".
            // Note: If tempCollabEditorVerStr has a value of "PTLinuxVersion9" or "PTLinuxVersion8" it will NOT be
            // changed by the test below.
            if (tempCollabEditorVerStr.IsEmpty())
            {
                // A normal assignment when called from OnInit(), don't log
                tempCollabEditorVerStr = _T("PTLinuxVersion9");
            }
            else if (tempCollabEditorVerStr != _T("PTLinuxVersion9") && tempCollabEditorVerStr != _T("PTLinuxVersion8"))
            {
                // Neither PT 9 or PT 8 had valid projects dir path or at least 2 useable projects.
                // Log the problem in user log since it has to be fixed by administrator.
                wxString msg = _T("In ValidateCollabEditorAndVersionStrAgainstInstallationData() both PT9 and PT8 for Linux are installed but neither has valid projects dir or neither has at least 2 useable projects. Setting PT version to a default of PTLinuxVersion9.");
                LogUserAction(msg);
                // Assume the administrator will fix this situation. In the mean time, since both
                // PT 9 and PT 8 are installed, default here to the highest installed version PTLinuxVersion9.
                tempCollabEditorVerStr = _T("PTLinuxVersion9");
            }
        }
        else if (gbPTLinuxVer7Installed && gbPTLinuxVer9Installed)
        {
            // PT7 and PT9 Linux versions are installed - PT8 Linux is not installed - this would be
            // fairly uncommon unless a user previously used PT7 and never migrated data to a PT8
            // installation before installing PT9.
            // If tempCollabEditorVerStr is NOT empty when we get here, AND it points to an installed
            // version of PT, then we accept what it points to even an older PT version and the Administrator
            // can select a newer version if desired, but we should keep the older version config value
            // so start with.
            // If tempCollabEditorVerStr IS EMPTY, or it doesn't point to one of the installed PT
            // versions, set it to the highest installed version, in this case "PTLinuxVersion9".
            // Note: If tempCollabEditorVerStr has a value of "PTLinuxVersion7" or "PTLinuxVersion9" it will NOT be
            // changed by the test below.
            if (tempCollabEditorVerStr.IsEmpty())
            {
                // A normal assignment when called from OnInit(), don't log
                tempCollabEditorVerStr = _T("PTLinuxVersion9");
            }
            else if (tempCollabEditorVerStr != _T("PTLinuxVersion9") && tempCollabEditorVerStr != _T("PTLinuxVersion7"))
            {
                // Neither PT 9 or PT 7 had valid projects dir path or at least 2 useable projects.
                // Log the problem in user log since it has to be fixed by administrator.
                wxString msg = _T("In ValidateCollabEditorAndVersionStrAgainstInstallationData() both PT7 and PT9 are installed but neither has valid projects dir or neither has at least 2 useable projects. Setting PT version to a default of PTLinuxVersion9.");
                LogUserAction(msg);
                // Assume the administrator will fix this situation. In the mean time, since both
                // PT 9 and PT 7 are installed, default here to the highest installed version PTLinuxVersion9.
                tempCollabEditorVerStr = _T("PTLinuxVersion9");
            }
        }
        else if (gbPTLinuxVer7Installed && gbPTLinuxVer8Installed)
        {
            // Both PT Linux versions 7 and 8 are installed on the machine.

            // whm modified 4Feb2020. Set the PT version according to what is specified in the project
            // config file unless it is the case that tempCollabEditorVerStr is an empty string.
            // If it is an empty string then we will have to guess which PT version the user might want.
            // As of December 31, 2019 all PT7 projects were supposed to have been migrated from PT7
            // to PT8, so I think that we can set PT8 as the suggested editor as long as there are at
            // lease 2 valid PT projects available in PT8 (source and target projects).
            // If there aren't at least 2 such valid PT projects available in PT8, the collaboration
            // can't actually be set up in this session, and we will leave the suggestion set to
            // "PTLinuxVersion7".
            // Note: If tempCollabEditorVerStr has a value of "PTLinuxVersion7" or "PTLinuxVersion8" it
            // will NOT be changed by the test below.
            if (tempCollabEditorVerStr.IsEmpty()
                || (tempCollabEditorVerStr != _T("PTLinuxVersion8") && tempCollabEditorVerStr != _T("PTLinuxVersion7")))
            {
                // Assume that PT 8 for Linux will be the desired editor if it has a valid projects dir
                // and at least 2 valid/useable projects, otherwise PT 7
                wxString pt8ProjectsDirPath = GetParatextProjectsDirPath(_T("PTLinuxVersion8"));
                wxString pt7ProjectsDirPath = GetParatextProjectsDirPath(_T("PTLinuxVersion7"));
                wxArrayString pt8ListOfProj = GetListOfPTProjects(_T("PTLinuxVersion8"));
                wxArrayString pt7ListOfProj = GetListOfPTProjects(_T("PTLinuxVersion7"));
                int pt8Count = pt8ListOfProj.GetCount();
                int pt7Count = pt7ListOfProj.GetCount();
                if (!pt8ProjectsDirPath.IsEmpty() && pt8Count >= 2)
                {
                    tempCollabEditorVerStr = _T("PTLinuxVersion8");
                }
                else if (!pt7ProjectsDirPath.IsEmpty() && pt7Count >= 2)
                {
                    tempCollabEditorVerStr = _T("PTLinuxVersion7");
                }
                else
                {
                    // Neither PT 8 or PT 7 had valid projects dir path or at least 2 useable projects, log the problem
                    wxString msg = _T("In ValidateCollabEditorAndVersionStrAgainstInstallationData() both PT7 and PT8 for Linux are installed but neither has valid projects dir or neither has at least 2 useable projects. Setting PT version to PTLinuxVersion8 as default.");
                    LogUserAction(msg);
                    // Assume the administrator will fix this situation. In the mean time, since both
                    // PT 8 and PT 7 are installed, default here in InitDialog() to PT 8.
                    tempCollabEditorVerStr = _T("PTLinuxVersion8");
                }
            }
        }
    }
    else if (gbPTNotInstalled && BibleditIsInstalled())
    {
        collabEditor = _T("Bibledit");
        tempCollabEditorVerStr = wxEmptyString; // this should be empty when Bibledit is the editor
    }
    else
    {
        // Neither a valid editor nor a valid PT version could be determined so return empty strings for both.
        collabEditor = wxEmptyString;
        tempCollabEditorVerStr = wxEmptyString;
    }

    return tempCollabEditorVerStr;
}

//////////////////////////////////////////////////////////////////////////////////////////
/// \return     a wxString representing the Paratext for Linux's major version number
/// \param      PTVersionFilePath a wxString path to the dir of the PTVersion file on Linux
/// \remarks
/// Called from IsThisParatextVersionInstalled().
/// This method opens up the "PTVersion" text file that is located at the PTVersionFilePath
/// which will be either /usr/lib/Paratext/PTVersion, or /usr/lib/Paratext8/PTVersion,
/// or /usr/lib/Paratext9/PTVersion, and parses out the last line that has an embedded
/// reference to the PT version within parentheses and double quote marks similar to
/// this: ("7.5.100.312") or ("8.x.xxx...), etc.
/// We parse out the string value that represents the first digit of that version number,
/// which will normally be a "7" or an "8" or a "9" and return that single digit string.
/// If the PTVersion file is not found or doesn't have a recognizable major string number,
/// an empty string is returned.
/// Note that, although this method is may be called under the Windows environment, it won't
/// ordinarily find a PTVersion file at a /usr/lib/Paratext... path on a Windows computer.
//////////////////////////////////////////////////////////////////////////////////////////
wxString CAdapt_ItApp::GetLinuxPTVersionNumberFromPTVersionFile(wxString PTVersionFilePath)
{
    wxString verStr;
    verStr.Empty();
    // Probably the most reliable way to get the version of the Linux version is to examine
    // the file called "PTVersion" that is located at /usr/lib/Paratext/PTVersion. This file
    // has a content like the following:
    /*
    // ---------beginning of PTVersion file --------------
    using System.Reflection;
    using System.Runtime.CompilerServices;

    // ------------------------------------------------------------------------------
    //  <autogenerated>
    //      This code was generated by a tool.
    //      Mono Runtime Version: 4.0.30319.17020
    //
    //      Changes to this file may cause incorrect behavior and will be lost if
    //      the code is regenerated.
    //  </autogenerated>
    // ------------------------------------------------------------------------------

    [assembly:AssemblyVersion("7.5.100.312")]
    [assembly:AssemblyFileVersion("7.5.100.312")]
    // ----------end of PTVersion file-------------------
    */

    // The last two lines of the above PTVersion file has the version information within
    // parentheses and double quotes, ie, ("7.5.100.312"). A version 8 installation in
    // Linux should have a similar file with a value of something like: ("8.x.x.x")
    // We can parse the first digit from inside the quotes to get the major version number
    // - in the above examples it would be "7" or "8".
    // Note: this PTVersion file is apparently only located in a Linux/Mono installation,
    // and doesn't appear to be present in a Windows installation.

    if (PTVersionFilePath.IsEmpty())
        return verStr; // empty
    if (::wxFileExists(PTVersionFilePath))
    {
        // Open the file and parse out the line that starts with "AssemblyVersion..."
        wxTextFile tfile;
        wxString strBuf;
        wxString strAssemblyVersionPrefix = _T("AssemblyVersion");
        if (tfile.Open(PTVersionFilePath))
        {
            strBuf = tfile.GetFirstLine();
            while (!tfile.Eof())
            {
                if (strBuf.Find(strAssemblyVersionPrefix) != wxNOT_FOUND)
                {
                    // found it -- extract the variable value from this line
                    int nStart = (strBuf.Find(_T("\""))) + 1; // nStart is next position past quote mark - the version number
                    verStr = strBuf.Mid(nStart, 1); // grab the digit
                    //wxLogDebug(_T("Found version \"%s\" in PTVersion File"), verStr.c_str());
                    break; // exit the while loop -- we've found our match
                }
                strBuf = tfile.GetNextLine();
            }
            tfile.Close();
        }
        // Extract the version part, which will be something like \"7.5.100.312\")]
        //verStr.Replace(_T("\""), _T("")); // remove the quotes from verStr
        //verStr.Replace(_T(")"), _T(""), TRUE); // remove the closing ) char near right end of verStr
        //verStr.Replace(_T("]"), _T(""), TRUE); // remove the closing ] char near right end of verStr
        // what is left is just the whole version number: 7.5.100.312
        // Extract the major version number from the version part - the part before the first '.' char
        //verStr = verStr.BeforeFirst(_T('.'));
    }
    return verStr;
}

bool CAdapt_ItApp::BibleditIsInstalled()
{

    // whm added 5Jun12 for debugging purposes. The FORCE_BIBLEDIT_IS_INSTALLED_FLAG
    // is set at the beginning of Adapt_It.h. When set it does the following:
    // 1. Forces the this BibleditIsInstalled() function to return TRUE
    // 2. Forces the App's m_bBibleditIsInstalled member to be TRUE
    // 3. Forces the GetListOfBEProjects() function to return an array of three
    //    dummy Bibledit project names: Nyindrou, Tok Pisin, and Free Trans. See the
    //    GetListOfBEProjects() function.
    // 4. Forces the CollabProjectIsEditable() function (in CollabUtilities.cpp) to
    //    return TRUE.
    // 5. Forces the CollabProjectHasAtLeastOneBook() function (in CollabUtilities.cpp)
    //    to return TRUE.
#if defined(FORCE_BIBLEDIT_IS_INSTALLED_FLAG)
    return TRUE;
#else

    bool bBEInstalled;
    bBEInstalled = FALSE;
    wxString pathToExecutable;
    pathToExecutable.Empty();
#if defined(__WXGTK__)
    pathToExecutable = GetBibleditInstallDirPath() + PathSeparator + _T("bibledit-rdwrt");
    if (::wxFileExists(pathToExecutable))
        bBEInstalled = TRUE;

    // TODO: write code to determine the version of bibledit-gtk that is
    // installed on Linux. It must be at least version 4.2.93 to respond
    // to the command-line usage implemented by Teus as of version 4.2.93.
#endif
#ifdef __WXMAC__
    pathToExecutable = GetBibleditInstallDirPath() + gpApp->PathSeparator + _T("bibledit-rdwrt");

    // If the above call doesn't find it then try /opt/local/bin/
    // According to the Bibledit wesite's instructions for installing Bibledit
    // on the Mac it should install to _T("/opt/local/bin/bibledit-gtk")
    // so if the above doesn't find it on the PATH, then try the hard coded Path
    if (::wxFileExists(pathToExecutable))
        bBEInstalled = TRUE;
    else if (::wxFileExists(_T("/opt/local/bin/bibledit")))
        bBEInstalled = TRUE;

    // TODO: write code to determine the version of bibledit-gtk that is
    // installed on the Mac. It must be at least version 4.2.93 to respond
    // to the command-line usage implemented by Teus as of version 4.2.93.
#endif

    m_bBibleditIsInstalled = bBEInstalled; // set the App's flag
    return bBEInstalled;

#endif // of #if defined(FORCE_BIBLEDIT_IS_INSTALLED_FLAG)
}

//#if defined(__WXGTK__) // only used for mono / linux
//////////////////////////////////////////////////////////////////////////////////////////
/// \return     a wxString representing the Paratext environment variable
/// \remarks
/// Called from GetParatextProjectsDirPath and ParatextIsInstalled
/// This method opens up the /usr/bin/paratext shell script that launches Paratext in
/// the mono environment, and looks for the specified environment variable.  If found,
/// this method returns the string value of that variable; if not found (or if there is
/// some other issue opening / parsing the file), an empty string is returned.
/// Note that this method is not called under the Windows environment.
/// whm 27Nov2016 revised to add a wxString parameter to specify the version of
/// Paratext is being queried.
/// whm 4Feb2020 added test for PTverStr == _T("PT9")
//////////////////////////////////////////////////////////////////////////////////////////
wxString CAdapt_ItApp::GetParatextEnvVar(wxString strVariableName, wxString PTverStr)
{
    wxString strScriptFilename;
    if (PTverStr == _T("PT7"))
        strScriptFilename = _T("/usr/bin/paratext");
    else if (PTverStr == _T("PT8"))
        strScriptFilename = _T("/usr/bin/paratext8");
    else if (PTverStr == _T("PT9"))
        strScriptFilename = _T("/usr/bin/paratext9"); // whm 4Feb2020 TODO: Check this on Linux!!!
    else
        wxASSERT_MSG(FALSE, _T("Programmer Error in GetParatextEnvVar() function - Unknown parameter to function."));
    wxString value;
    value.Empty();
    // sanity check -- make sure the paratext script exists
    if (!::wxFileExists(strScriptFilename)) return value;
    // open the file and look for our variable name
    wxTextFile tfile;
    wxString strBuf;
    if (tfile.Open(strScriptFilename))
    {
        strBuf = tfile.GetFirstLine();
        while (!tfile.Eof())
        {
            if (strBuf.Contains(strVariableName))
            {
                // found it -- extract the variable value from this line
                int nStart = (strBuf.Find(_T("="))) + 1;
                value = strBuf.Mid(nStart, (strBuf.Length() - nStart));
                //wxLogDebug(value);
                break; // exit the while loop -- we've found our match
            }
            strBuf = tfile.GetNextLine();
        }
        tfile.Close();
    }
    // return what we found
    return value;
}
//#endif

//////////////////////////////////////////////////////////////////////////////////////////
/// \return     a wxString representing the path to the Paratext projects directory
/// \param      wxString PTVersion - a wxString designating the PT version to use: "PTVersion7",
///             "PTVersion8", "PTVersion9", "PTLinuxVersion7", "PTLinuxVersion8" or "PTLinuxVersion9".
///             An empty input parameter _T("") does not currently happen
/// \remarks
/// Called from: the App's GetListOfPTProjects(), AiProjectCollabStatus(),
/// SetCollabSettingsToNewProjDefaults(), GetListOfPTProjects(), CSetupEditorCollaboration::InitDialog(),
/// and CSetupEditorCollaboration::DoSetControlsFromConfigFileCollabData().
/// Looks in the Windows registry to get the path to the Paratext Projects directory.
/// whm revised 16March2017. User Jenni B reported an error from the system that said, "can't
/// open file 'C:\Users\User\Documents\My Paratext 8 Projects\... (error 3: the system cannot find the
/// path specified.)" after selecting the "Paratext 7" radio button in the "Setup Or Remove Collaboration"
/// dialog. That shouldn't happen when a user specifically asks for projects listed for Paratext 7.
/// So, I've revised this function to not give preference to Paratext 8 when both PT 7 and PT 8 are
/// installed on the same user's machine. Now the function only returns a path for the version of
/// Paratext specified in the function's wxString PTVersion parameter.
/// Windows version generally returns C:\My Paratext Projects for PT7 or C:\My Paratext 8 Projects for PT 8.
/// Linux version generally returns $HOME/ParatextProjects for PT7 or $HOME/Paratext8Projects for PT 8.
/// whm 4Feb2020 Note: PT9 continues to use the same dir path/folder that PT8 used - but only if the
/// computer already had a "My Paratext 8 Projects" directory. For a fresh installation of Paratext 9
/// on a computer that did not have a previous PT8 installation, the Paratext Full (Offline) installer
/// actually creates a "My Paratext 9 Projects" folder! Hence some users will have a "My Paratext 8 Projects"
/// folder and some (usually newer) user will have a "My Paratext 9 Projects" folder after installing PT9!
/// For Windows we first look for the specified PT installation and if found, returns its Projects Dir path
/// by inspecting the Settings_Directory key value.
/// If the incoming parameter is empty string we look first for PT 8. If no PT 8 installation is found,
/// we look for a PT 7 installation and if found, return its Projects Dir path by inspecting its
/// ...Settings_Directory key.
/// For PT 8 the following PT 8 registry key is queried for the return value (depending on architecture):
///    HKEY_LOCAL_MACHINE\\SOFTWARE\\WOW6432Node\\Paratext\\8   for a 64-bit system, or
///    HKEY_LOCAL_MACHINE\\SOFTWARE\\Paratext\\8     for a 32-bit system
///    At the "8" registry node, in the above reg key, we query for its key value of
///    "Settings_Directory" to get the PT 8 projects dir path. The PT 9 uses same dir as PT 8 does.
/// For PT 7 the following PT 7 registry key is queried for the return value:
///    HKEY_LOCAL_MACHINE\SOFTWARE\ScrChecks\1.0\Settings_Directory
/// If the key is not found, or is found but the value string does not exist on
/// the system, the function returns an empty string. This function only reads/queries
/// the Windows registry; it does not make changes to it.
/// Revised 25June2016 by whm to handle collaboration with PT 8.
/// Revised 22Jan2018 by whm to check for default paths if wxRegKey fails for some reason,
/// as reported by Ron A who uses PT8 on a Mac host running Win10 under VMWare Fusion.
/// Revised 4Feb2020 by whm to handle collaboration with PT 9.
//////////////////////////////////////////////////////////////////////////////////////////
wxString CAdapt_ItApp::GetParatextProjectsDirPath(wxString PTVersion)
{
    // The PTVersion parameter can be: "PTVersion7", "PTVersion8", "PTVersion9", "PTLinuxVersion7", "PTLinuxVersion8", or "PTLinuxVersion9"

    wxString path;
    path.Empty();
#ifdef __WXMSW__ // Windows host system - look in registry

    wxLogNull logNo; // eliminate any spurious messages from the system

    wxString dirStrValue;
    dirStrValue.Empty(); // dirStrValue is returned as empty string if no keys or matching directories are found.
    // whm 4Feb2020 Note: In the future it is possible that the PT developers may create a registry key
    // that is unique to Paratext 9, so the first test below attempts to take advantage of that possibility
    // if it should happen by checking for the existence of these keys:
    //    "HKEY_LOCAL_MACHINE\\SOFTWARE\\WOW6432Node\\Paratext\\9", and
    //    "HKEY_LOCAL_MACHINE\\SOFTWARE\\Paratext\\9"
    // If no such keys exist (as is the case in Feb2020), the test then tries to find the PT8 keys ...\\Paratext\\8
    // (which are currently used by PT 9), and extracts the Projects Dir Path from those keys.
    // There are two registry views where the PT 8 key might be depending on the host OS architecture
    // Note: Currently, as of Feb2020, PT 9 uses the same \Paratext\8 key, rather than ...\\Paratext\\9
    // Get instances of the PT8 keys here so they can be use in both the PTVersion9 and PTVersion8 tests below.
    wxRegKey keyOS64PT8InstallDir(_T("HKEY_LOCAL_MACHINE\\SOFTWARE\\WOW6432Node\\Paratext\\8"));
    wxRegKey keyOS32PT8InstallDir(_T("HKEY_LOCAL_MACHINE\\SOFTWARE\\Paratext\\8"));
    if (PTVersion == _T("PTVersion9"))
    {
        wxRegKey keyOS64PT9InstallDir(_T("HKEY_LOCAL_MACHINE\\SOFTWARE\\WOW6432Node\\Paratext\\9"));
        wxRegKey keyOS32PT9InstallDir(_T("HKEY_LOCAL_MACHINE\\SOFTWARE\\Paratext\\9"));
        if (keyOS64PT9InstallDir.Exists() && keyOS64PT9InstallDir.HasValues())
        {
            if (keyOS64PT9InstallDir.Open(wxRegKey::Read)) // open the key for reading only!
            {
                // get the folder path stored in the key, (i.e., C:\Program Files (x86)\Paratext8\)
                keyOS64PT9InstallDir.QueryValue(_T("Settings_Directory"), dirStrValue);
                // remove the final backslash, since our path values generally don't have a
                // trailing path separator.
                if (!dirStrValue.IsEmpty() && dirStrValue.GetChar(dirStrValue.Length() - 1) == _T('\\'))
                    dirStrValue.RemoveLast(1);
                if (::wxDirExists(dirStrValue))
                {
                    return dirStrValue; // path = dirStrValue;
                }
            }
        }
        else if (keyOS32PT9InstallDir.Exists() && keyOS32PT9InstallDir.HasValues())
        {
            if (keyOS32PT9InstallDir.Open(wxRegKey::Read)) // open the key for reading only!
            {
                // get the folder path stored in the key, (i.e., C:\Program Files\Paratext8\)
                keyOS32PT9InstallDir.QueryValue(_T("Settings_Directory"), dirStrValue);
                // remove the final backslash, since our path values generally don't have a
                // trailing path separator.
                if (!dirStrValue.IsEmpty() && dirStrValue.GetChar(dirStrValue.Length() - 1) == _T('\\'))
                    dirStrValue.RemoveLast(1);
                if (::wxDirExists(dirStrValue))
                {
                    return dirStrValue; //path = dirStrValue;
                }
            }
        }
        // else check for the PT reg key at ...\\Paratext\\8
        else if (keyOS64PT8InstallDir.Exists() && keyOS64PT8InstallDir.HasValues())
        {
            if (keyOS64PT8InstallDir.Open(wxRegKey::Read)) // open the key for reading only!
            {
                // get the folder path stored in the key, (i.e., C:\Program Files (x86)\Paratext8\)
                keyOS64PT8InstallDir.QueryValue(_T("Settings_Directory"), dirStrValue);
                // remove the final backslash, since our path values generally don't have a
                // trailing path separator.
                if (!dirStrValue.IsEmpty() && dirStrValue.GetChar(dirStrValue.Length() - 1) == _T('\\'))
                    dirStrValue.RemoveLast(1);
                if (::wxDirExists(dirStrValue))
                {
                    return dirStrValue; //path = dirStrValue;
                }
            }
        }
        else if (keyOS32PT8InstallDir.Exists() && keyOS32PT8InstallDir.HasValues())
        {
            if (keyOS32PT8InstallDir.Open(wxRegKey::Read)) // open the key for reading only!
            {
                // get the folder path stored in the key, (i.e., C:\Program Files\Paratext8\)
                keyOS32PT8InstallDir.QueryValue(_T("Settings_Directory"), dirStrValue);
                // remove the final backslash, since our path values generally don't have a
                // trailing path separator.
                if (!dirStrValue.IsEmpty() && dirStrValue.GetChar(dirStrValue.Length() - 1) == _T('\\'))
                    dirStrValue.RemoveLast(1);
                if (::wxDirExists(dirStrValue))
                {
                    return dirStrValue; //path = dirStrValue;
                }
            }
        }
        // whm 22Jan2018 added additional checks for default PT8 projects folder location - fallback
        // in case wxRegKey fails above, we check for projects folder at its normal default path for
        // Windows.
        if (dirStrValue.IsEmpty() || !::wxDirExists(dirStrValue))
        {
            // Check the default PT9 installation location for projects, i.e., the "My Paratext 9 Projects" is
            // the default installation location when the PT9 installer sees that no previous PT8 installation
            // created a "My Paratext 8 Projects" folder.
            // So, check first for the 9 folder
            wxString projPathPT9 = _T("C:\\My Paratext 9 Projects"); // whm 4Feb2020 Note: This is same path for PT 9
            if (::wxDirExists(projPathPT9))
            {
                return projPathPT9; //path = projPathPT9; // no final backslash on path
            }
            // Lastly check for an 8 folder
            wxString projPathPT8 = _T("C:\\My Paratext 8 Projects"); // whm 4Feb2020 Note: This is same path for PT 9
            if (::wxDirExists(projPathPT8))
            {
                return projPathPT9; //path = projPathPT8; // no final backslash on path
            }
        }
    }
    else if (PTVersion == _T("PTVersion8"))
    {
        // There are two registry views where the PT 8 key might be depending on the host OS architecture
        // Note: PT 9 uses the same \Paratext\8 key.
        //wxRegKey keyOS64PT8InstallDir(_T("HKEY_LOCAL_MACHINE\\SOFTWARE\\WOW6432Node\\Paratext\\8"));
        //wxRegKey keyOS32PT8InstallDir(_T("HKEY_LOCAL_MACHINE\\SOFTWARE\\Paratext\\8"));
        if (keyOS64PT8InstallDir.Exists() && keyOS64PT8InstallDir.HasValues())
        {
            if (keyOS64PT8InstallDir.Open(wxRegKey::Read)) // open the key for reading only!
            {
                // get the folder path stored in the key, (i.e., C:\Program Files (x86)\Paratext8\)
                keyOS64PT8InstallDir.QueryValue(_T("Settings_Directory"), dirStrValue);
                // remove the final backslash, since our path values generally don't have a
                // trailing path separator.
                if (!dirStrValue.IsEmpty() && dirStrValue.GetChar(dirStrValue.Length() - 1) == _T('\\'))
                    dirStrValue.RemoveLast(1);
                if (::wxDirExists(dirStrValue))
                {
                    return dirStrValue; //path = dirStrValue;
                }
            }
        }
        else if (keyOS32PT8InstallDir.Exists() && keyOS32PT8InstallDir.HasValues())
        {
            if (keyOS32PT8InstallDir.Open(wxRegKey::Read)) // open the key for reading only!
            {
                // get the folder path stored in the key, (i.e., C:\Program Files\Paratext8\)
                keyOS32PT8InstallDir.QueryValue(_T("Settings_Directory"), dirStrValue);
                // remove the final backslash, since our path values generally don't have a
                // trailing path separator.
                if (!dirStrValue.IsEmpty() && dirStrValue.GetChar(dirStrValue.Length() - 1) == _T('\\'))
                    dirStrValue.RemoveLast(1);
                if (::wxDirExists(dirStrValue))
                {
                    return dirStrValue; //path = dirStrValue;
                }
            }
        }
        // whm 22Jan2018 added additional checks for default PT8/PT9 projects folder location - fallback
        // in case wxRegKey fails above, we check for projects folder at its normal default path for
        // Windows.
        if (dirStrValue.IsEmpty() || !::wxDirExists(dirStrValue))
        {
            // Check the default PT8 installation location for projects
            wxString projPathPT8 = _T("C:\\My Paratext 8 Projects"); // whm 4Feb2020 Note: This is same path for PT 9
            if (::wxDirExists(projPathPT8))
            {
                return projPathPT8; //path = projPathPT8; // no final backslash on path
            }
        }
    }
    else if (PTVersion == _T("PTVersion7")) //if (PTVersion == _T("PTVersion7") || path.IsEmpty())
    {
        wxRegKey keyPTInstallDir(_T("HKEY_LOCAL_MACHINE\\SOFTWARE\\ScrChecks\\1.0\\Settings_Directory"));
        if (keyPTInstallDir.Exists() && keyPTInstallDir.HasValues())
        {
            if (keyPTInstallDir.Open(wxRegKey::Read)) // open the key for reading only!
            {
                // get the folder path stored in the key, (i.e., C:\Program Files\Paratext7\)
                dirStrValue = keyPTInstallDir.QueryDefaultValue();
                // remove the final backslash, since our path values generally don't have a
                // trailing path separator.
                if (!dirStrValue.IsEmpty() && dirStrValue.GetChar(dirStrValue.Length() - 1) == _T('\\'))
                    dirStrValue.RemoveLast(1);
                if (::wxDirExists(dirStrValue))
                {
                    return dirStrValue; //path = dirStrValue;
                }
            }
        }
        // whm 22Jan2018 added additional checks for default PT7 projects folder location - fallback
        // in case wxRegKey fails above, we check for projects folder at its normal default path for
        // Windows.
        if (dirStrValue.IsEmpty() || !::wxDirExists(dirStrValue))
        {
            // Check the default PT7 installation location for projects
            wxString projPathPT7 = _T("C:\\My Paratext Projects");
            if (::wxDirExists(projPathPT7))
            {
                return projPathPT7; //path = projPathPT7; // no final backslash on path
            }
        }
    }

#endif
#if defined(__WXGTK__) // linux -- check mono directory for values.xml file

    // whm 4Feb2020 TODO: Check the following code after PT 9 for Linux is released in Ubuntu 18.04!!!
    wxString strRegPath;
    if (PTVersion == _T("PTLinuxVersion9")) // whm 4Feb2020 added test for "PTLinuxVersion9"
        strRegPath = GetParatextEnvVar(_T("MONO_REGISTRY_PATH"), _T("PT9"));
    else if (PTVersion == _T("PTLinuxVersion8"))
        strRegPath = GetParatextEnvVar(_T("MONO_REGISTRY_PATH"), _T("PT8"));
    else if (PTVersion == _T("PTLinuxVersion7"))
        strRegPath = GetParatextEnvVar(_T("MONO_REGISTRY_PATH"), _T("PT7"));
    if (strRegPath.IsEmpty())
    {
        // problem getting shell script value -- try the default location
        strRegPath = wxGetenv(_T("HOME"));
        strRegPath += _T("/.config/paratext/registry");
    }
    else
    {
        // the shell script uses ${HOME} for the home directory, which the ::wxDirExists()
        // call chokes on -- replace that value with the system environment variable value
        // for the HOME directory before continuing
        strRegPath.Replace(_T("${HOME}"), wxGetenv(_T("HOME")));
    }
    if (::wxDirExists(strRegPath))
    {
        // MONO_REGISTRY_PATH exists -- see if we can get the projects dir out of the values.xml
        // file located in strRegPath
        wxString pt8ValuesFilePathSuffix = _T("/LocalMachine/software/paratext/8/values.xml");
        wxString pt7ValuesFilePathSuffix = _T("/LocalMachine/software/scrchecks/1.0/settings_directory/values.xml");

        // Start by checking for a PT 8 Dir Path.
        if (PTVersion == _T("PTLinuxVersion8") || PTVersion == _T("PTLinuxVersion9")) // whm 4Feb2020 added test for "PTLinuxVersion8"
        {
            // First Look for a PT 8 values file path
            wxString strValuesFile = strRegPath + pt8ValuesFilePathSuffix;
            wxString strBuf;
            strBuf.Empty();
            wxString strPath;
            strPath.Empty();
            if (wxFileExists(strValuesFile))
            {
                wxTextFile tfile;
                if (tfile.Open(strValuesFile))
                {
                    strBuf = tfile.GetFirstLine();
                    while (!tfile.Eof())
                    {
                        if (strBuf.Contains(_T("type=\"string\">")))
                        {
                            // extract the path from this string value
                            int nStart = (strBuf.Find(_T("\">"))) + 2;
                            int nEnd = strBuf.Find(_T("</value>"));
                            strPath = strBuf.Mid(nStart, (nEnd - nStart));
                            //wxLogDebug(strPath);
                            break; // exit the while loop -- we've found our match
                        }
                        strBuf = tfile.GetNextLine();
                    }
                    tfile.Close();
                }
            }

            if (!strPath.IsEmpty() && strPath.GetChar(strPath.Length() - 1) == _T('\\'))
                strPath.RemoveLast(1);
            if (::wxDirExists(strPath))
            {
                path = strPath;
            }
        } // end of if (PTVersion == _T("PTLinuxVersion8"))
        else if (PTVersion == _T("PTLinuxVersion7"))
        {
            wxString strValuesFile = strRegPath + pt7ValuesFilePathSuffix;
            wxString strBuf;
            strBuf.Empty();
            wxString strPath;
            strPath.Empty();
            if (wxFileExists(strValuesFile))
            {
                wxTextFile tfile;
                if (tfile.Open(strValuesFile))
                {
                    strBuf = tfile.GetFirstLine();
                    while (!tfile.Eof())
                    {
                        if (strBuf.Contains(_T("type=\"string\">")))
                        {
                            // extract the path from this string value
                            int nStart = (strBuf.Find(_T("\">"))) + 2;
                            int nEnd = strBuf.Find(_T("</value>"));
                            strPath = strBuf.Mid(nStart, (nEnd - nStart));
                            //wxLogDebug(strPath);
                            break; // exit the while loop -- we've found our match
                        }
                        strBuf = tfile.GetNextLine();
                    }
                    tfile.Close();
                }
            }

            if (!strPath.IsEmpty() && strPath.GetChar(strPath.Length() - 1) == _T('\\'))
                strPath.RemoveLast(1);
            if (::wxDirExists(strPath))
            {
                path = strPath;
            }
        } // end of if (PTVersion == _T("PTLinuxVersion7"))
    }
#endif

    return path;
}

wxString CAdapt_ItApp::GetBibleditProjectsDirPath()
{
    // by inspection of Bibledit-gtk version 4.2.93 (cloned from git nightly build
    // and built 13Jun11), the bibledit project folder is located at:
    // ~/.bibledit/projects and the projects folder contains an xml file called
    // configuration.1.xml and folders for each project by name of project. We can
    // get a list of bibledit projects by collecting all the folder names. Each of
    // the named project folders should have a "data" folder and a configuration.1.xml
    // file which contains the vital information for AI project setup including
    // <language>, <versification>, <editable>, <editor-font-default>, <editor-font-name>
    // which is of the form Sans 14, <right-to-left>, etc.
    wxString path;
    path.Empty();
    // On Linux systems the wxStandardPaths::GetDocumentsDir() method gets
    // the user's ~/ folder where the .bibledit folder is located. We augment
    // that path by pointing to its projects subdirectory, i.e., ~/.bibledit/projects.
    // Get the "documents" directory for the current system/platform.
    //	GDLC 11JUL13 In WX2.9.5 we can no longer create a wxStandardPaths object
    //	wxStandardPaths stdPaths;
    // TODO: Review the following line if we ever interact with BibleEdit on Mac
    path = wxStandardPaths::Get().GetDocumentsDir() + PathSeparator + _T(".bibledit") + PathSeparator + _T("projects");
    return path;
}


//////////////////////////////////////////////////////////////////////////////////////////
/// \return     a wxString representing the path to the Paratext installation directory
///             for the specified version of PT passed as parameter
/// \param      a wxString designating the PT version to use: "PTVersion7", "PTVersion8",
///             "PTVersion9","PTLinuxVersion7", "PTLinuxVersion8", or "PTLinuxVersion9"
/// \remarks
/// Called from: the App's SetCollabSettingsToNewProjDefaults() which in turn is called from OnInit()
/// and the ProjectPage's OnWizardPageChanging() function to set defaults for a <New Project>.
/// Looks in the Windows registry/system to get the path to the Paratext Install directory.
/// For PT 8 and PT 9 the following PT 8 registry key is queried for the return value (depending on architecture):
///    HKEY_LOCAL_MACHINE\\SOFTWARE\\WOW6432Node\\Paratext\\8   for a 64-bit system, or
///    HKEY_LOCAL_MACHINE\\SOFTWARE\\Paratext\\8     for a 32-bit system
///    At the "8" registry node, in the above reg key, we query for its key value of
///    "Program_Files_Directory_Ptw8" to get the PT 8 install dir path. At the same node
///    we query for the key value of "Program_Files_Directory_Ptw9" to get the PT 9 install dir path.
/// For PT 7 the following PT 7 registry key is queried for the return value:
///    HKEY_LOCAL_MACHINE\SOFTWARE\ScrChecks\1.0\Program_Files_Directory_Ptw7
/// Note: In Windows, registry calls return the path with a final backslash, so we remove
///    any final backslash from the path before returning.
/// Linux version returns /usr/lib/Paratext directory by default for PT 7
/// Linux version returns /usr/lib/Paratext8 directory by default for PT 8, unless there is
/// no /usr/lib/Paratext8 directory, and /usr/lib/Paratext is being used for the early beta
/// version of PT8 (as verified by its PTVersion file's major version number being 8), in which
/// case the /usr/lib/Paratext directory is returned for use by that early beta version of PT8.
/// If no PT installation is found for the specified version, return an empty string for the path.
/// Linux version returns /usr/lib/Paratext9 directory by default for PT 9. TODO: Check this when Linux version 9 becomes available
/// This function only reads/queries the Windows registry/system; it does not make changes to it.
/// Revised 25June2016 by whm to handle collaboration with PT 8.
/// Revised 27Nov2016 by whm to handle collaboration with the newer PT 8 that can co-exist with PT 7
/// whm 22Jan2018 added additional checks to determine PT install dir paths from
/// their default folder locations. At least one system that runs Windows 10 under
/// VMWare Fusion (Ron A), is not able to query the Windows registry for some
/// unknown reason. Therefore as a fall-back, we return their default installation
/// folders, if the installation paths cannot be determined from the normal Windows
/// registry calls using wxRegKey.
/// whm 4Feb2020 revised for Paratext 9 for Windows and Linux.
//////////////////////////////////////////////////////////////////////////////////////////
wxString CAdapt_ItApp::GetParatextInstallDirPath(wxString PTVersion)
{
    wxString path;
    path.Empty();
#ifdef __WXMSW__ // Windows host system - check the registry

    wxLogNull logNo; // eliminate any spurious messages from the system

    wxString dirStrValue;
    dirStrValue.Empty();
    // whm 4Feb2020 added test for PTVersion9 below
    if (PTVersion == _T("PTVersion9"))
    {
        // There are two registry views where the PT 8 key might be depending on the host OS architecture
        // NOTE: PT 9 uses the same registry key that is used below for ...\Paratext\8
        wxRegKey keyOS64PTInstallDir(_T("HKEY_LOCAL_MACHINE\\SOFTWARE\\WOW6432Node\\Paratext\\8"));
        wxRegKey keyOS32PTInstallDir(_T("HKEY_LOCAL_MACHINE\\SOFTWARE\\Paratext\\8"));
        if (keyOS64PTInstallDir.Exists() && keyOS64PTInstallDir.HasValues())
        {
            if (keyOS64PTInstallDir.Open(wxRegKey::Read)) // open the key for reading only!
            {
                // whm 4Feb2020 added following query for "Program_Files_Directory_Ptw9"
                // get the folder path stored in the key, (i.e., C:\Program Files (x86)\Paratext9\)
                keyOS64PTInstallDir.QueryValue(_T("Program_Files_Directory_Ptw9"), dirStrValue);
                // remove the final backslash, since our path values generally don't have a
                // trailing path separator.
                if (!dirStrValue.IsEmpty() && dirStrValue.GetChar(dirStrValue.Length() - 1) == _T('\\'))
                    dirStrValue.RemoveLast(1);
                if (::wxDirExists(dirStrValue))
                {
                    path = dirStrValue;
                }
            }
        }
        else if (keyOS32PTInstallDir.Exists() && keyOS32PTInstallDir.HasValues())
        {
            if (keyOS32PTInstallDir.Open(wxRegKey::Read)) // open the key for reading only!
            {
                // whm 4Feb2020 added following query for "Program_Files_Directory_Ptw9"
                // get the folder path stored in the key, (i.e., C:\Program Files\Paratext9\)
                keyOS32PTInstallDir.QueryValue(_T("Program_Files_Directory_Ptw9"), dirStrValue);
                // remove the final backslash, since our path values generally don't have a
                // trailing path separator.
                if (!dirStrValue.IsEmpty() && dirStrValue.GetChar(dirStrValue.Length() - 1) == _T('\\'))
                    dirStrValue.RemoveLast(1);
                if (::wxDirExists(dirStrValue))
                {
                    path = dirStrValue;
                }

            }
        }
        // whm 4Feb2020 added additional checks for Paratext.exe located at their default PT9
        // folder locations - this is a fallback in case wxRegKey fails above even though
        // the Paratext 9 executables exist at their normal default paths for Windows.
        if (dirStrValue.IsEmpty() || !::wxDirExists(dirStrValue))
        {
            // Check the default PT9 installation location for 32-bit/64-bit PT
            wxString exePathPT9_on_32bitOS = _T("C:\\Program Files\\Paratext 9\\Paratext.exe");
            wxString exePathPT9_on_64bitOS = _T("C:\\Program Files (x86)\\Paratext 9\\Paratext.exe");
            // whm Note: There is no ParatextShared.dll in PT 9
            if (::wxFileExists(exePathPT9_on_32bitOS))
            {
                path = _T("C:\\Program Files\\Paratext 9"); // no final backslash on path
            }
            else if (::wxFileExists(exePathPT9_on_64bitOS))
            {
                path = _T("C:\\Program Files (x86)\\Paratext 9"); // no final backslash on path
            }
        }
    }
    else if (PTVersion == _T("PTVersion8"))
    {
        // There are two registry views where the PT 8 key might be depending on the host OS architecture
        wxRegKey keyOS64PTInstallDir(_T("HKEY_LOCAL_MACHINE\\SOFTWARE\\WOW6432Node\\Paratext\\8"));
        wxRegKey keyOS32PTInstallDir(_T("HKEY_LOCAL_MACHINE\\SOFTWARE\\Paratext\\8"));
        if (keyOS64PTInstallDir.Exists() && keyOS64PTInstallDir.HasValues())
        {
            if (keyOS64PTInstallDir.Open(wxRegKey::Read)) // open the key for reading only!
            {
                // get the folder path stored in the key, (i.e., C:\Program Files (x86)\Paratext8\)
                keyOS64PTInstallDir.QueryValue(_T("Program_Files_Directory_Ptw8"), dirStrValue);
                // remove the final backslash, since our path values generally don't have a
                // trailing path separator.
                if (!dirStrValue.IsEmpty() && dirStrValue.GetChar(dirStrValue.Length() - 1) == _T('\\'))
                    dirStrValue.RemoveLast(1);
                if (::wxDirExists(dirStrValue))
                {
                    path = dirStrValue;
                }
            }
        }
        else if (keyOS32PTInstallDir.Exists() && keyOS32PTInstallDir.HasValues())
        {
            if (keyOS32PTInstallDir.Open(wxRegKey::Read)) // open the key for reading only!
            {
                // get the folder path stored in the key, (i.e., C:\Program Files\Paratext8\)
                keyOS32PTInstallDir.QueryValue(_T("Program_Files_Directory_Ptw8"), dirStrValue);
                // remove the final backslash, since our path values generally don't have a
                // trailing path separator.
                if (!dirStrValue.IsEmpty() && dirStrValue.GetChar(dirStrValue.Length() - 1) == _T('\\'))
                    dirStrValue.RemoveLast(1);
                if (::wxDirExists(dirStrValue))
                {
                    path = dirStrValue;
                }
            }
        }
        // whm 22Jan2018 added additional checks for Paratext.exe and (possibly) ParatextShared.dll located at
        // their default PT8 folder locations - fallback in case wxRegKey fails above even though
        // the Paratext 8 executables exist at their normal default paths for Windows.
        if (dirStrValue.IsEmpty() || !::wxDirExists(dirStrValue))
        {
            // Check the default PT8 installation location for 32-bit/64-bit PT
            wxString exePathPT8_on_32bitOS = _T("C:\\Program Files\\Paratext 8\\Paratext.exe");
            wxString exePathPT8_on_64bitOS = _T("C:\\Program Files (x86)\\Paratext 8\\Paratext.exe");
            wxString dllPathPT8_on_32bitOS = _T("C:\\Program Files\\Paratext 8\\ParatextShared.dll");
            wxString dllPathPT8_on_64bitOS = _T("C:\\Program Files (x86)\\Paratext 8\\ParatextShared.dll");
            if ((::wxFileExists(exePathPT8_on_32bitOS)
                && ::wxFileExists(dllPathPT8_on_32bitOS)))
            {
                path = _T("C:\\Program Files\\Paratext 8"); // no final backslash on path
            }
            else if ((::wxFileExists(exePathPT8_on_64bitOS)
                    && ::wxFileExists(dllPathPT8_on_64bitOS)))
            {
                path = _T("C:\\Program Files (x86)\\Paratext 8"); // no final backslash on path
            }
        }
    }
    else if (PTVersion == _T("PTVersion7"))
    {
        wxRegKey keyPTInstallDir(_T("HKEY_LOCAL_MACHINE\\SOFTWARE\\ScrChecks\\1.0\\Program_Files_Directory_Ptw7"));
        if (keyPTInstallDir.Exists() && keyPTInstallDir.HasValues())
        {
            if (keyPTInstallDir.Open(wxRegKey::Read)) // open the key for reading only!
            {
                // get the folder path stored in the key, (i.e., C:\Program Files\Paratext7\)
                // Note: the dirStrValue path ends with a backslash so we don't add one here.
                dirStrValue = keyPTInstallDir.QueryDefaultValue();
                // remove the final backslash, since our path values generally don't have a
                // trailing path separator.
                if (!dirStrValue.IsEmpty() && dirStrValue.GetChar(dirStrValue.Length() - 1) == _T('\\'))
                    dirStrValue.RemoveLast(1);
                if (::wxDirExists(dirStrValue))
                {
                    path = dirStrValue;
                }
            }
        }
        // whm 22Jan2018 added additional checks for Paratext.exe and ParatextShared.dll located at
        // their default PT7 folder locations - fallback in case wxRegKey fails above even though
        // the Paratext 7 executables exist at their normal default paths for Windows.
        if (dirStrValue.IsEmpty() || !::wxDirExists(dirStrValue))
        {
            // Check the default PT7 installation location for 32-bit PT
            wxString exePathPT7_on_32bitOS = _T("C:\\Program Files\\Paratext 7\\Paratext.exe");
            wxString exePathPT7_on_64bitOS = _T("C:\\Program Files (x86)\\Paratext 7\\Paratext.exe");
            wxString dllPathPT7_on_32bitOS = _T("C:\\Program Files\\Paratext 7\\ParatextShared.dll");
            wxString dllPathPT7_on_64bitOS = _T("C:\\Program Files (x86)\\Paratext 7\\ParatextShared.dll");
            if ((::wxFileExists(exePathPT7_on_32bitOS)
                && ::wxFileExists(dllPathPT7_on_32bitOS)))
            {
                path = _T("C:\\Program Files\\Paratext 7"); // no final backslash on path
            }
            else if ((::wxFileExists(exePathPT7_on_64bitOS)
                && ::wxFileExists(dllPathPT7_on_64bitOS)))
            {
                path = _T("C:\\Program Files (x86)\\Paratext 7"); // no final backslash on path
            }
        }
    }

#endif
#if defined(__WXGTK__) // linux

    // For Linux the passed in parameter will be "PTLinuxVersion" "or "PTLinuxVersion8".
    // Linux version returns /usr/lib/Paratext directory by default for PT 7
    if (PTVersion == _T("PTLinuxVersion7"))
    {
        wxString strDir = _T("/usr/lib/Paratext");
        if (::wxDirExists(strDir))
        {
            path = strDir;
        }
    }
    // Linux version returns /usr/lib/Paratext8 directory by default for PT 8, unless there is
    // no /usr/lib/Paratext8 directory, and /usr/lib/Paratext is being used for the early beta
    // version of PT8 (as verified by its PTVersion file's major version number being 8), in which
    // case the /usr/lib/Paratext directory is returned for use by that early beta version of PT8.
    else if (PTVersion == _T("PTLinuxVersion8"))
    {
        wxString strDir = _T("/usr/lib/Paratext8");
        if (::wxDirExists(strDir))
        {
            path = strDir;
        }
        else
        {
            // there was no /usr/lib/Paratext8 directory, so check for an installation of the
            // early PT8 beta that used the /usr/lib/Paratext directory - as verified by finding
            // a major version number of 8 in its PTVersion file.
            strDir = _T("/usr/lib/Paratext");
            if (::wxDirExists(strDir))
            {
                // The normal PT7 install directory exists, check if it has a PT8 early beta installation in it
                wxString PTLinuxMajorVersionNumStr;
                PTLinuxMajorVersionNumStr = GetLinuxPTVersionNumberFromPTVersionFile(strDir + PathSeparator + _T("PTVersion"));
                //wxLogDebug(_T("Linux PT Version found was version \"%s\" as found by GetLinuxPTVersionNumberFromPTVersionFile()"), PTLinuxMajorVersionNumStr.c_str());
                if (PTLinuxMajorVersionNumStr == _T("8"))
                    path = strDir;
                // if the major version is indeed 7, then we found no "PTLinuxVersion8" installation,
                // in which case do not assign path a value - just leave it an empty string
            }
        }
    }
    // whm 4Feb2020 added test below for PTLinuxVersion9
    else if (PTVersion == _T("PTLinuxVersion9"))
    {
        wxString strDir = _T("/usr/lib/Paratext9");
        if (::wxDirExists(strDir))
        {
            path = strDir;
        }
    }

#endif

    return path;
}

wxString CAdapt_ItApp::GetBibleditInstallDirPath()
{
    wxString dirPath;
    // By inspection of my Ubuntu 10.04 system with Bibledit on it, it appears that
    // it gets installed at /usr/bin/bibledit-gtk where the InstallDirPath() is /usr/bin
    // and the app name is bibledit-gtk.
    dirPath = GetProgramLocationFromSystemPATH(_T("bibledit-gtk"));

    // dirPath should normally be _T("/usr/bin") for a package installed version of
    // Bibledit, or possibly _T("/usr/local/bin") for a locally installed version.

    return dirPath;
}

wxString CAdapt_ItApp::GetAdaptit_Bibledit_rdwrtInstallDirPath()
{
    wxString dirPath;
    // The interim Bibledit utility is called adaptit-bibledit-rdwrt and
    // is installed by Adapt It, not by Bibledit. It will only be used if
    // Bibledit-gtk is installed, but is earlier than version 4.2.67 (the SIL
    // package at packages.sil.org/ubuntu that Neil packaged there earlier
    // in 2011. Once Balsa and the commonly-used Bibledit that is packaged
    // with Ubuntu distributions has a Bibledit version > 4.2.93 this
    // function and adaptit-bibledit-rdwrt will no longer be necessary.
    dirPath = GetProgramLocationFromSystemPATH(_T("adaptit-bibledit-rdwrt"));

    // dirPath should normally be _T("/usr/bin") for a package installed version of
    // Adapt It, or possibly _T("/usr/local/bin") for a locally installed version.

    return dirPath;
}

//////////////////////////////////////////////////////////////////////////////////////////
/// \return     a wxString representing a suitable document file name for AI's collaboration
///                    with Paratext or Bibledit
/// \param      collabPrefix       -> the USFM 3-letter book code string for a Scripture book
/// \param      bookCode           -> the USFM 3-letter book code string for a Scripture book
/// \param      ptProjectShortName -> the Paratext Project's short name the Scripture book is in
/// \param      chapterNumStr -> the chapter number as a string, optionally can be wxEmptyString
/// \param      extStr        -> the extension to use, generally will be "xml"
/// \remarks
///
/// Builds a suitable file name for Adapt It's local use based partly on the Paratext naming
/// scheme, and partly for Adapt It's own filename identification purposes. The usual resulting
/// string is of the form represented by the following example: Collab_nn_BBB_XYZ_CHcc.ext where
/// nn is the numerical book equivalent in the Paratext scheme (01 is Genesis, 39 is Malachi,
/// 41 is Matthew, 67 is Revelation); BBB is the USFM 3-letter book code; XYZ is the Paratext
/// project's short name; cc is the chapter number, and ext is the extension for the filename.
/// The format for nn and cc when < 10 has a leading '0'. If the chapterNumStr is empty
/// (wxEmptyString or _T("")), the resulting file name string is of the form: Collab_nn_BBB_XYZ.ext.
/// The incoming extStr can contain an initial dot or be just the extension itself; the
/// function puts the initial dot if it is not present in the incoming extStr. The bookCode and
/// extStr are the two manditory parameters that cannot be empty strings.
/// BEW 26Jun11, removed assert for non-empty extension, so that the function can also be
/// used for easily generating a window Title string
//////////////////////////////////////////////////////////////////////////////////////////
wxString CAdapt_ItApp::GetFileNameForCollaboration(wxString collabPrefix, wxString bookCode,
    wxString ptProjectShortName, wxString chapterNumStr, wxString extStr)
{
    wxASSERT(!bookCode.IsEmpty());
    //wxASSERT(!extStr.IsEmpty()); BEW removed 26Jun11
    wxString nameStr;
    nameStr.Empty();
    if (!collabPrefix.IsEmpty())
    {
        nameStr = collabPrefix; // don't localize
        nameStr += _T('_');
    }
    int num = GetNumberFromBookCodeForFileNaming(bookCode);
    // the number returned from GetNumberFromBookCodeForFileNaming() will never have leading zeros.
    if (num < 10)
    {
        nameStr += _T('0');
    }
    nameStr << num;
    nameStr += _T('_');
    nameStr += bookCode;
    if (!ptProjectShortName.IsEmpty())
    {
        nameStr += _T('_');
        nameStr += ptProjectShortName;
    }
    chapterNumStr.Trim(FALSE);
    chapterNumStr.Trim(TRUE);
    if (!chapterNumStr.IsEmpty())
    {
        int chNum;
        chNum = wxAtoi(chapterNumStr);
        // wxAtoi() removes any leading 0 chars, so get the normalized string form of the number for adding below
        wxString cNum;
        cNum.Empty();
        cNum << chNum;
        nameStr += _T("_CH"); // don't localize
        if (chNum < 10)
        {
            nameStr += _T('0');
        }
        nameStr += cNum;
    }
    if (extStr.Find(_T('.')) == 0)
    {
        // extStr begins with a '.' so just add it
        nameStr += extStr;
    }
    else
    {
        if (!extStr.IsEmpty()) // BEW added 27Jun11
        {
            nameStr += _T('.');
            nameStr += extStr;
        }
    }
    return nameStr;
}

wxString CAdapt_ItApp::GetCollabSettingsAsStringForLog()
{
    // Gets the collab settings from the App's values and concatenates them into
    // a wxString for use in LogUserAction()
    wxString settingsStr;
    settingsStr = _T("Collab Settings:");
    settingsStr += _T("src_proj:[");
    settingsStr += m_CollabProjectForSourceInputs;
    settingsStr += _T("]tgt_proj:[");
    settingsStr += m_CollabProjectForTargetExports;
    settingsStr += _T("]ft_proj:[");
    settingsStr += m_CollabProjectForFreeTransExports;
    settingsStr += _T("]ai_proj:[");
    settingsStr += m_CollabAIProjectName;
    settingsStr += _T("]editor:[");
    settingsStr += m_collaborationEditor;
    settingsStr += _T("]pt_version:[");
    settingsStr += m_ParatextVersionForProject;
    settingsStr += _T("]src_lang:[");
    settingsStr += m_CollabSourceLangName;
    settingsStr += _T("]tgt_lang:[");
    settingsStr += m_CollabTargetLangName;
    settingsStr += _T("]expects_ft:[");
    settingsStr << (int)m_bCollaborationExpectsFreeTrans;
    settingsStr += _T("]ch_only:[");
    settingsStr << (int)m_bCollabByChapterOnly;
    settingsStr += _T("]book:[");
    settingsStr += m_CollabBookSelected;
    settingsStr += _T("]chapter:[");
    settingsStr += m_CollabChapterSelected;
    settingsStr += _T("]books_protected_from_saving_to_editor:[");
    settingsStr += m_CollabBooksProtectedFromSavingToEditor;
    settingsStr += _T("]do_not_show_migration_dlg_pt7_to_pt8:[");
    settingsStr << (int)m_bCollabDoNotShowMigrationDialogForPT7toPT8;
    settingsStr += _T("]");

    return settingsStr;
}

// This GetCollaborationSettingsOfAIProject() function is only called from the SetupEditorCollaboration's
// DoSetControlsFromConfigFileCollabData() function. It avoids having to call the usual mechanism for reading
// an AI-ProjectConfiguration.aic file.
// whm 25June2016 modified for PT 8 support, including a work-around for having used "ParatextVersionForProject"
// as a project config file label in a pre-release version instead of "CollabParatextVersionForProject" that is
// used for this label in all subsequent versions.
// whm 2Februaty2017 - no changes needed for new m_TempCollabBooksProtectedFromSavingToEditor config label
void CAdapt_ItApp::GetCollaborationSettingsOfAIProject(wxString projectName, wxArrayString& collabLabelsArray,
    wxArrayString& collabSettingsArray)
{
    wxString curProjPathAndName;
    wxString projConfigPathAndName;
    if (!m_customWorkFolderPath.IsEmpty() && m_bUseCustomWorkFolderPath)
    {
        curProjPathAndName = m_customWorkFolderPath + PathSeparator
            + projectName; // use the incoming project name
    }
    else
    {
        curProjPathAndName = m_workFolderPath + PathSeparator
            + projectName; // use the incoming project name
    }
    projConfigPathAndName = curProjPathAndName + PathSeparator + szProjectConfiguration + _T(".aic");

    // Get the project configuration file open in memory in a wxTextFile
    // whm modified 18April2017 to check if the projConfigPathAndName exists. If not don't call
    // f.Open() on the file because in wxWidgets 3.x it generates a visible error to the user
    if (!::wxFileExists(projConfigPathAndName))
    {
        // The AI-ProjectConfiguration.aic file doesn't exist for this project so just return without
        // adding anything to the returned arrays.
        return;
    }
    wxTextFile f;
    bool bOpenedOK = f.Open(projConfigPathAndName);
    // should open ok, if not, tell the developer & abort
    if (bOpenedOK)
    {
        // Scan file for the Collab... settings and use them to populate the
        // collabLabelsArray and collabSettingsArray which are returned to the
        // caller as reference parameters.
        wxString tab = _T("\t");
        wxString lineStr;
        for (lineStr = f.GetFirstLine(); !f.Eof(); lineStr = f.GetNextLine())
        {
            int chPos;
            int tabPos;
            lineStr.Trim(FALSE); // trim any white space from left end (possibly due to manual editing of config file)
            chPos = lineStr.Find(_T("Collab"));
            tabPos = lineStr.Find(tab);
            wxString strFollowingTab = _T("");
            wxString strLabel = _T("");
            if (chPos == 0)
            {
                // parse the szLabel part and the collab settings part storing them in the
                // appropriate wxArrayStrings for return to the caller via the reference
                // parameters
                strLabel = lineStr.Mid(0, tabPos);
                strLabel.Trim(FALSE);
                strLabel.Trim(TRUE);
                collabLabelsArray.Add(strLabel);
                strFollowingTab = lineStr.Mid(tabPos);
                strFollowingTab.Trim(FALSE);
                strFollowingTab.Trim(TRUE);
                collabSettingsArray.Add(strFollowingTab);
            }
        }
        // whm added 25June2016 a work-around for having used a project config label of "ParatextVersionForProject"
        // in a pre-release version to developers. We'll scan the proj config file a second time and check for this
        // config label and its setting. If it is present, we add its label to collabLabelsArray and its setting value
        // to the colabSettingsArray.
        for (lineStr = f.GetFirstLine(); !f.Eof(); lineStr = f.GetNextLine())
        {
            int chPos;
            int tabPos;
            lineStr.Trim(FALSE); // trim any white space from left end (possibly due to manual editing of config file)
            chPos = lineStr.Find(_T("ParatextVersionForProject"));
            tabPos = lineStr.Find(tab);
            wxString strFollowingTab = _T("");
            wxString strLabel = _T("");
            if (chPos == 0)
            {
                // parse the "ParatextVersionForProject" part and its settings part storing them in the
                // appropriate wxArrayStrings for return to the caller via the reference
                // parameters
                strLabel = lineStr.Mid(0, tabPos);
                strLabel.Trim(FALSE);
                strLabel.Trim(TRUE);
                collabLabelsArray.Add(strLabel);
                strFollowingTab = lineStr.Mid(tabPos);
                strFollowingTab.Trim(FALSE);
                strFollowingTab.Trim(TRUE);
                collabSettingsArray.Add(strFollowingTab);
            }
        }

    }
    else
    {
        ; // TODO: Report Error?
    }
    f.Close();
}

// whm added 18April2017
wxString CAdapt_ItApp::GetVersificationNameFromEnumVal(int vrsEnum)
{
    // Do sanity check on vrsEnum value. If the value is 0 or negative, or greater than 30 default to 4 (English)
    if (vrsEnum < 1 || vrsEnum > 30)
        vrsEnum = 4; // fallback is English
    wxString vNameStr;
    wxArrayString versificationNames(31, vrsNames);
    vNameStr = versificationNames.Item(vrsEnum);
    return vNameStr;
}

// whm added 18April2017
wxString CAdapt_ItApp::GetVersificationFileNameFromEnumVal(int vrsEnum)
{
    // Do sanity check on vrsEnum value. If the value is 0 or negative, or greater than 30 default to 4 (English)
    if (vrsEnum < 1 || vrsEnum > 30)
        vrsEnum = 4; // fallback is English
    wxString vFileNameStr;
    wxArrayString versificationFileNames(31, vrsFileNames);
    vFileNameStr = versificationFileNames.Item(vrsEnum);
    return vFileNameStr;
}

//////////////////////////////////////////////////////////////////////////////////////////
/// \return     TRUE if an Adapt It project is open, FALSE if no Adapt It project is open
/// \remarks
/// Called from CSetupEditorCollaboration::OnInit().
/// Determines if an Adapt It project is currently open, as determined by whether the
/// KB is NULL or not. If the KB is NULL, no project is open.
//////////////////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItApp::IsAIProjectOpen()
{
    return m_pKB != NULL;
}

//////////////////////////////////////////////////////////////////////////////////////////
/// \return     TRUE if the Adaptations folder of the m_projectName has one or more AI
///                         documents within it that have a "_Collab" prefixed on the name(s).
///                         FALSE if no documents within the Adaptations folder have the
///                         "_Collab" prefix.
/// \param      m_projectName  -> a wxString containing the project name to check
/// \remarks
/// Called from CProjectPage::OnWizardPageChanging().
/// Scans the Adaptations sub-folder of the m_projectName folder looking for AI document
/// files whose names begin with "_Collab...". If any are found the function immediately
/// returns TRUE. If none are found the function returns FALSE.
//////////////////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItApp::AIProjectHasCollabDocs(wxString m_projectName)
{
    bool projHasCollabDocs = FALSE;
    wxASSERT(!m_projectName.IsEmpty());
    wxString workOrCustomFolderPath;
    if (!m_bUseCustomWorkFolderPath)
    {
        workOrCustomFolderPath = m_workFolderPath;
    }
    else
    {
        workOrCustomFolderPath = m_customWorkFolderPath;
    }
    wxString path2Adaptations = workOrCustomFolderPath + PathSeparator + m_projectName + PathSeparator + m_adaptationsFolder;

    wxString saveCurWorkingDir = ::wxGetCwd();
    // Scan the files in the Adaptations folder for any that start with a "_Collab" substring.
    wxDir finder;
    // whm 8Apr2021 added wxLogNull block below
    wxLogNull logNo;	// eliminates any spurious messages from the system if the wxSetWorkingDirectory() returns FALSE
    bool bOK = (::wxSetWorkingDirectory(path2Adaptations) && finder.Open(path2Adaptations)); // wxDir
    bOK = bOK; // avoid warning
    wxString str = _T("");
    bool bWorking = finder.GetFirst(&str, wxEmptyString, wxDIR_FILES);
    // whm note: wxDIR_FILES finds only files; it ignores directories, and . and ..
    while (bWorking)
    {
        if (str.Find(_T("_Collab")) == 0)
        {
            projHasCollabDocs = TRUE;
            break;
        }
        bWorking = finder.GetNext(&str);
    }
    ::wxSetWorkingDirectory(saveCurWorkingDir); // ignore failures
    // end of scope for wxLogNull
    return projHasCollabDocs;
}

//////////////////////////////////////////////////////////////////////////////////////////
/// \return     TRUE if the m_projectName AI project has been setup for collaboration by an
///                         administrator for collaboration with Paratext/Bibledit, FALSE
///                         otherwise
/// \param      m_projectName  -> a wxString containing the project name to check
/// \remarks
/// Called from CDocPage::OnSetActive().
/// Opens the AI-ProjectConfiguration.aic file associated with the m_projectName in a
/// wxTextFile and scans through the project config file (in memory) and determines from
/// the "Collab..." settings in the file if the project was set up for collaboration with
/// Paratext or Bibledit. We don't use the normal GetProjectConfiguration() mechanism here
/// so as to not set the App's project settings prematurely by reading the project
/// configuration file into the App's variables which might have undesirable side effects.
/// Note: This function does not validate the collaboration settings. All such validation
/// and consistency checking is done in the CProjectPage's call of GetAIProjectCollabStatus().
/// Here we only check for the existence of three of the collaboration settings:
/// "CollabProjectForSourceInputs", "CollabProjectForTargetExports" and "CollabAIProjectName".
//////////////////////////////////////////////////////////////////////////////////////////
bool CAdapt_ItApp::AIProjectIsACollabProject(wxString m_projectName)
{
    bool isCollabProject = FALSE;
    wxString curProjPathAndName;
    wxString projConfigPathAndName;
    if (!m_customWorkFolderPath.IsEmpty() && m_bUseCustomWorkFolderPath)
    {
        curProjPathAndName = m_customWorkFolderPath + PathSeparator
            + m_curProjectName;
    }
    else
    {
        curProjPathAndName = m_workFolderPath + PathSeparator
            + m_curProjectName;
    }
    projConfigPathAndName = curProjPathAndName + PathSeparator + szProjectConfiguration + _T(".aic");

    // whm added 11Mar12 if there is no project config file, it obviously is not a collab project
    // so return FALSE.
    if (!::wxFileExists(projConfigPathAndName))
        return FALSE;

    // Get the project configuration file open in memory in a wxTextFile
    wxTextFile f;
    bool bOpenedOK = f.Open(projConfigPathAndName);
    // should open ok, if not, tell the developer & abort
    if (bOpenedOK)
    {
        // Scan file for the Collab... settings and use them to determine if a collaboration
        // setup has been established by an administrator
        //
        // Note: In the config file, there are three main collaboration settings that govern
        // whether collaboration setup has been successfully established for the project:
        //   "CollabProjectForSourceInputs"
        //   "CollabProjectForTargetExports"
        //   "CollabAIProjectName"
        // If all three of these config labels are followed by string values and the string
        // stored in the "CollabAIProjectName" is identical to the m_projectName incoming
        // parameter, we can safely assume that collaboration has been established for this
        // project. We could do some sanity checks if needed but that would mainly detect if
        // someone has been manually editing the config file, in which case anything could
        // happen.
        wxString tab = _T("\t");
        wxString lineStr;
        bool bFoundCollabLineStrOK1 = FALSE;
        bool bFoundCollabLineStrOK2 = FALSE;
        bool bFoundCollabLineStrOK3 = FALSE;
        for (lineStr = f.GetFirstLine(); !f.Eof(); lineStr = f.GetNextLine())
        {
            int chPos;
            int tabPos;
            lineStr.Trim(FALSE); // trim any white space from left end (possibly due to manual editing of config file)
            chPos = lineStr.Find(szCollabProjectForSourceInputs); // CollabProjectForSourceInputs
            tabPos = lineStr.Find(tab); tabPos = tabPos; // unused, so prevent compiler warning
            wxString strFollowingTab = _T("");
            if (chPos == 0)
            {
                // check for a following non-empty string
                strFollowingTab = lineStr.Mid(szCollabProjectForSourceInputs.Length());
                strFollowingTab.Trim(FALSE);
                strFollowingTab.Trim(TRUE);
                if (!strFollowingTab.IsEmpty())
                    bFoundCollabLineStrOK1 = TRUE;
                continue;
            }
            chPos = lineStr.Find(szCollabProjectForTargetExports); // CollabProjectForTargetExports
            if (chPos == 0)
            {
                // check for a following non-empty string
                strFollowingTab = lineStr.Mid(szCollabProjectForTargetExports.Length());
                strFollowingTab.Trim(FALSE);
                strFollowingTab.Trim(TRUE);
                if (!strFollowingTab.IsEmpty())
                    bFoundCollabLineStrOK2 = TRUE;
                continue;
            }
            chPos = lineStr.Find(szCollabAIProjectName); // CollabAIProjectName
            if (chPos == 0)
            {
                // check for a following non-empty string that matches m_projectName
                strFollowingTab = lineStr.Mid(szCollabAIProjectName.Length());
                strFollowingTab.Trim(FALSE);
                strFollowingTab.Trim(TRUE);
                if (!strFollowingTab.IsEmpty())
                    bFoundCollabLineStrOK3 = TRUE;
                // whm modified 25Nov2013 a break statement was used here
                // previously and that assumed that the szCollabAIProjectName
                // would sequence after the above two config settings
                // (szCollabProjectForSourceInputs and
                // szCollabProjectForTargetExports), but I changed the order
                // of the Collab... setting values to have the
                // szCollabAIProjectName sequence first in the list of
                // Collab... values. However, that meant that was causing this
                // AIProjectIsACollabProject() function to prematurely return
                // FALSE for collab projects. Changing the break; to a
                // continue; statement allows the function to work properly
                // regardless of the ordering of values.
                continue; // break for the last string
            }
        }
        if (!bFoundCollabLineStrOK1 || !bFoundCollabLineStrOK2 || !bFoundCollabLineStrOK3)
        {
            // One or more of the necessary Collab... lines were missing from the config file
            // so we judge that this project is not a well-setup collab project. This is not
            // an error since non-collaboration projects will return FALSE.
            isCollabProject = FALSE;
        }
        else
        {
            // All three Collab... labels were found and all are followed by a
            // string and the last one's string == m_projectName, so return TRUE.
            isCollabProject = TRUE;
        }
    }
    else
    {
        // Note: In the CProjectPage::OnWizardPageChanging(), a more thorough check
        // and reporting of any condition preventing the opening of the project config
        // file is done in which the user is prevented from advancing away from the
        // ProjectPage if the project config file cannot be opened. We only get to the
        // DocPage - where this function is called - if the project config file was
        // successfully read back in the ProjectPage. Therefore, it is highly unlikely
        // that something could go wrong in the split second between the ProjectPage
        // and the DocPage. But, to cover the bases we will check whether this project's
        // Adaptations folder contains any _Collab... documents within it. If so we will
        // set isCollabProject to TRUE. If the Adaptations folder has no _Collab... docs
        // we will set isCollabProject to FALSE.
        wxString msg = _("Adapt It could not open the project configuration file (AI-ProjectConfiguration.aic) for the \"%s\" project. Please ask your administrator for help.");
        msg = msg.Format(msg, m_projectName.c_str());
        // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
        m_bUserDlgOrMessageRequested = TRUE;
        wxMessageBox(msg, _("This project's configuration settings could not be read"), wxICON_EXCLAMATION | wxOK);
        // Add the following to the msg for the user log:
        msg += _T(" ");
        if (AIProjectHasCollabDocs(m_projectName))
        {
            isCollabProject = TRUE;
            msg += _T("The project's Adaptations folder contains collaboration documents, therefore the DocPage list will not display _Collab... docs.");
        }
        else
        {
            isCollabProject = FALSE;
            msg += _T("The project's Adaptations folder contains no collaboration documents, therefore the DocPage list will display all docs.");
        }
        this->LogUserAction(_T("In AIProjectIsACollabProject(): ") + msg);
    }
    f.Close();
    return isCollabProject;
}

//////////////////////////////////////////////////////////////////////////////////////////
/// \return     returns an enum of type AiProjectCollabStatus which can be one of
///             collabProjExistsAndIsValid, collabProjExistsButIsInvalid,
///             collabProjNotConfigured, projConfigFileMissing, or
///             projConfigFileUnableToOpen
/// \param      m_projectName  -> a wxString containing the project name to check (which
///                                 the user selected in the caller)
/// \param      errorStr <- a wxString that contains an information when an error occurs
/// \param      bChangeMadeToCollabSettings <- a bool that indicates if a change was made
///                                             to the collab settings during validation
/// \param      errorProjects <- a wxString representing the kinds of projects listed in
///                              the errorProjects string, i.e. "source [target] [freetrans]"
/// \param      bBothPT7AndPT8InstalledPT8ProjectsWereMigrated <- a bool to inform the caller if
///                               both PT7 and PT8 are installed and have valid collab
///                               projects, and the projects appear to have been migrated
///                               to PT 8.
/// \remarks
/// Called only from CProjectPage::OnWizardPageChanging().
/// Opens the AI-ProjectConfiguration.aic file associated with the m_projectName in a
/// wxTextFile and scans through the project config file (in memory) and collects data about
/// the "Collab..." settings. This function also performs a number of sanity checks and
/// corrects irregularities in the collaboration settings where possible - to correct
/// manually edited typos or missing collab setting fields which can be deduced from other
/// collab settings. The names of Paratext or Bibledit projects are checked against the
/// currently installed Paratext or Bibledit projects. If the collaboration settings are
/// undefined in the project config file the function returns collabProjNotConfigured.
/// We don't use the normal GetProjectConfiguration() mechanism here for "reading" the
/// project config file, so as to not set the App's project settings prematurely by reading
/// the project configuration file into the App's variables which might have undesirable side
/// effects.
/// whm 4Feb21020 modified for compatibility with PT 9.
//////////////////////////////////////////////////////////////////////////////////////////
enum AiProjectCollabStatus CAdapt_ItApp::GetAIProjectCollabStatus(wxString m_projectName, wxString& errorStr,
    bool& bChangeMadeToCollabSettings, wxString& errorProjects, bool& bBothPT7AndPT8InstalledPT8ProjectsWereMigrated)
{
    // whm 20Apr12 created to return an enum of states and expanded sanity
    // checking of the collab values stored in the project config file.
    // Also returns an wxString errorStr and a bool bChangeMadeToCollabSettings
    // which are returned to the caller by reference, to inform the caller of
    // errors and any changes made to the collab settings (which can then be saved
    // by the caller to the project config file).
    bChangeMadeToCollabSettings = FALSE;
    bBothPT7AndPT8InstalledPT8ProjectsWereMigrated = FALSE; // whm set default 31March2017
    wxString curProjPathAndName;
    wxString projConfigPathAndName;
    if (!m_customWorkFolderPath.IsEmpty() && m_bUseCustomWorkFolderPath)
    {
        curProjPathAndName = m_customWorkFolderPath + PathSeparator
            + m_curProjectName;
    }
    else
    {
        curProjPathAndName = m_workFolderPath + PathSeparator
            + m_curProjectName;
    }
    projConfigPathAndName = curProjPathAndName + PathSeparator + szProjectConfiguration + _T(".aic");
#if defined(_DEBUG)
	//wxLogDebug(_T("GetAIProjectCollabStatus(): app:m_bDoNormalSProjectOpening = %s"), wxString(m_bDoNormalProjectOpening ? _T("TRUE") : _T("FALSE")).c_str());
#endif
    // whm added 11Mar12 if there is no project config file, it obviously is not a collab project
    // so return collabProjNotConfigured to caller to issue message to user there.
    if (!::wxFileExists(projConfigPathAndName))
    {
        // This is the exit point for an AI project whose config file is not present in
        // the project's folder.
        wxString msg = _("The Adapt It project \"%s\" is missing its project configuration file (AI-ProjectConfiguration.aic).");
        msg = msg.Format(msg, m_projectName.c_str());
        errorStr = msg; // return the errorStr to the caller by reference
        return projConfigFileMissing;
    }

    // Get the project configuration file open in memory in a wxTextFile
    wxTextFile f;
    bool bOpenedOK = f.Open(projConfigPathAndName);
    // Should open ok, if not, return projConfigFileUnableToOpen to caller to issue message
    // to user there.
    if (bOpenedOK)
    {
        // Scan file for the Collab... settings and use them to determine if a collaboration
        // setup has been established by an administrator, and for sanity checks.
        //
        // Note: In the config file, there are six main collaboration settings that minimally
        // govern whether collaboration setup has been successfully established for the project:
        //   "CollabProjectForSourceInputs"
        //   "CollabProjectForTargetExports"
        //   "CollabAIProjectName"
        //   "CollaborationEditor"
        //   "CollabSourceLangName"
        //   "CollabTargetLangName"
        // (the remaining Collab... settings in the project config file are not critical for
        // determining the state of a collaboration of an AI project).
        // If all six of these config labels are followed by string values and the strings
        // are consistent/valid, we can safely assume that collaboration has been established
        // for this project.
        // Note: We also collect any collab setting for
        //   "CollabProjectForFreeTransExports"
        //   "CollabExpectsFreeTrans"
        // The CollabProjectForFreeTransExports is an optional setting for collaboration, but
        // the CollabExpectsFreeTrans must be TRUE or FALSE depending on whether CollabProjectForFreeTransExports
        // has content or not. If CollabProjectForFreeTransExports has a string value we need to check for
        // validity in the CollabProjectsAreValid() call farther below and that CollabProjectForFreeTransExports
        // and CollabExpectsFreeTrans are in sync.
        wxString tab = _T("\t");
        wxString lineStr;
        bool bFoundCollabSrcProj = FALSE;
        bool bFoundCollabTgtProj = FALSE;
        bool bFoundCollabFreeTransProj = FALSE; // (optional)
        bool bFoundCollabExpectsFreeTrans = FALSE;
        bool bFoundCollabAiProj = FALSE;
        bool bFoundCollabEditor = FALSE;
        bool bFoundCollabPTVersion = FALSE; bFoundCollabPTVersion = bFoundCollabPTVersion; // whm 4Feb2020 this bool, while set is no longer tested for below
        bool bFoundCollabSrcLangName = FALSE;
        bool bFoundCollabTgtLangName = FALSE;
        wxString CollabSrcProjStrFound = _T("");
        wxString CollabTgtProjStrFound = _T("");
        wxString CollabFreeTransProjStrFound = _T(""); // (optional)
        wxString CollabExpectsFreeTransFound = _T("");
        wxString CollabAiProjStrFound = _T("");
        wxString CollabEditorStrFound = _T("");
        wxString collabPTVersionStrFound = _T(""); // whm added 20June2016
        wxString CollabSrcLangNameStrFound = _T("");
        wxString CollabTgtLangNameStrFound = _T("");
        // Scan through the in-memory lines of the project config file setting the boolean flags
        // indicating the presence or absence of each collab setting.
        for (lineStr = f.GetFirstLine(); !f.Eof(); lineStr = f.GetNextLine())
        {
            int chPos;
            int tabPos;
            lineStr.Trim(FALSE); // trim any white space from left end (possibly due to manual editing of config file)
            chPos = lineStr.Find(szCollabProjectForSourceInputs);
            tabPos = lineStr.Find(tab); tabPos = tabPos; // unused, so prevent compiler warning
            if (chPos == 0)
            {
                // Check for a following non-empty string, storing any string found for sanity checks (below)
                CollabSrcProjStrFound = lineStr.Mid(szCollabProjectForSourceInputs.Length());
                CollabSrcProjStrFound.Trim(FALSE);
                CollabSrcProjStrFound.Trim(TRUE);
                if (!CollabSrcProjStrFound.IsEmpty())
                    bFoundCollabSrcProj = TRUE;
                continue; // use continue in case collab values ever get set in a different order in config file
            }
            chPos = lineStr.Find(szCollabProjectForTargetExports);
            if (chPos == 0)
            {
                // Check for a following non-empty string, storing any string found for sanity checks (below)
                CollabTgtProjStrFound = lineStr.Mid(szCollabProjectForTargetExports.Length());
                CollabTgtProjStrFound.Trim(FALSE);
                CollabTgtProjStrFound.Trim(TRUE);
                if (!CollabTgtProjStrFound.IsEmpty())
                    bFoundCollabTgtProj = TRUE;
                continue;
            }
            chPos = lineStr.Find(szCollabProjectForFreeTransExports);
            if (chPos == 0)
            {
                // Check for a following non-empty string, storing any string found for sanity checks (below)
                CollabFreeTransProjStrFound = lineStr.Mid(szCollabProjectForFreeTransExports.Length());
                CollabFreeTransProjStrFound.Trim(FALSE);
                CollabFreeTransProjStrFound.Trim(TRUE);
                if (!CollabFreeTransProjStrFound.IsEmpty())
                    bFoundCollabFreeTransProj = TRUE;
                continue;
            }
            chPos = lineStr.Find(szCollabExpectsFreeTrans);
            if (chPos == 0)
            {
                // Check for a following non-empty string, storing any string found for sanity checks (below)
                CollabExpectsFreeTransFound = lineStr.Mid(szCollabExpectsFreeTrans.Length());
                CollabExpectsFreeTransFound.Trim(FALSE);
                CollabExpectsFreeTransFound.Trim(TRUE);
                if (!CollabExpectsFreeTransFound.IsEmpty())
                    bFoundCollabExpectsFreeTrans = TRUE;
                continue;
            }
            chPos = lineStr.Find(szCollabAIProjectName);
            if (chPos == 0)
            {
                // Check for a following non-empty string, storing any string found for sanity checks (below)
                CollabAiProjStrFound = lineStr.Mid(szCollabAIProjectName.Length());
                CollabAiProjStrFound.Trim(FALSE);
                CollabAiProjStrFound.Trim(TRUE);
                if (!CollabAiProjStrFound.IsEmpty())
                    bFoundCollabAiProj = TRUE;
                continue;
            }
            chPos = lineStr.Find(szCollaborationEditor);
            if (chPos == 0)
            {
                // Check for a following non-empty string, storing any string found for sanity checks (below)
                CollabEditorStrFound = lineStr.Mid(szCollaborationEditor.Length());
                CollabEditorStrFound.Trim(FALSE);
                CollabEditorStrFound.Trim(TRUE);
                if (!CollabEditorStrFound.IsEmpty())
                    bFoundCollabEditor = TRUE;
                continue;
            }
            // whm added 20June2016. Note: the following if block looks like the following one but this one looks
            // for the outdated szParatextVersionForProject config string rather than the szCollabParatextVersionForProject
            // config string. This was needed to detect the config string before all collaboration config settings got a
            // Collab... prefix on the setting string. Hence, the next block below should never be entered, except for
            // a really ancient AI version's project config file.
            chPos = lineStr.Find(szParatextVersionForProject);
            if (chPos == 0)
            {
                // Check for a following non-empty string, storing any string found for sanity checks (below)
                collabPTVersionStrFound = lineStr.Mid(szParatextVersionForProject.Length());
                collabPTVersionStrFound.Trim(FALSE);
                collabPTVersionStrFound.Trim(TRUE);
                if (!collabPTVersionStrFound.IsEmpty())
                {
                    // A hack to compensate for bad (case) spelling of the m_ParatextEditorVersion that may have gotten out in a pre-release version
                    // whm 4Feb2020 Note: no need to make adjustments below for PT9 since the spelling only involved PT7 and PT8
                    if (collabPTVersionStrFound == _T("PTversion8"))
                    {
                        collabPTVersionStrFound = _T("PTVersion8");
                    }
                    if (collabPTVersionStrFound == _T("PTversion7"))
                    {
                        collabPTVersionStrFound = _T("PTVersion7");
                    }
                    if (collabPTVersionStrFound == _T("PTLinuxversion8"))
                    {
                        collabPTVersionStrFound = _T("PTLinuxVersion8");
                    }
                    if (collabPTVersionStrFound == _T("PTLinuxversion7"))
                    {
                        collabPTVersionStrFound = _T("PTLinuxVersion7");
                    }
                    // whm 4Feb2020 moved line below from only within each if block above - always use whatever version is found in config
                    m_ParatextVersionForProject = collabPTVersionStrFound;
                    bFoundCollabPTVersion = TRUE;
                }
                continue;
            }
            // whm added 25June2016
            chPos = lineStr.Find(szCollabParatextVersionForProject); // note the use of szCollabParatextVersionForProject here, cf. block above
            if (chPos == 0)
            {
                // Check for a following non-empty string, storing any string found for sanity checks (below)
                collabPTVersionStrFound = lineStr.Mid(szCollabParatextVersionForProject.Length());
                collabPTVersionStrFound.Trim(FALSE);
                collabPTVersionStrFound.Trim(TRUE);
                if (!collabPTVersionStrFound.IsEmpty())
                {
                    // A hack to compensate for bad (case) spelling of the m_ParatextEditorVersion that may have gotten out in a pre-release version
                    // whm 4Feb2020 Note: no need to make adjustments below for PT9 since the spelling only involved PT7 and PT8
                    if (collabPTVersionStrFound == _T("PTversion8"))
                    {
                        collabPTVersionStrFound = _T("PTVersion8");
                    }
                    if (collabPTVersionStrFound == _T("PTversion7"))
                    {
                        collabPTVersionStrFound = _T("PTVersion7");
                    }
                    if (collabPTVersionStrFound == _T("PTLinuxversion8"))
                    {
                        collabPTVersionStrFound = _T("PTLinuxVersion8");
                    }
                    if (collabPTVersionStrFound == _T("PTLinuxversion7"))
                    {
                        collabPTVersionStrFound = _T("PTLinuxVersion7");
                    }
                    // whm 4Feb2020 moved line below from only within each if block above - always use whatever version is found in config
                    m_ParatextVersionForProject = collabPTVersionStrFound;
                    bFoundCollabPTVersion = TRUE;
                }
                continue;
            }
            chPos = lineStr.Find(szCollabSourceLangName);
            if (chPos == 0)
            {
                // Check for a following non-empty string, storing any string found for sanity checks (below)
                CollabSrcLangNameStrFound = lineStr.Mid(szCollabSourceLangName.Length());
                CollabSrcLangNameStrFound.Trim(FALSE);
                CollabSrcLangNameStrFound.Trim(TRUE);
                if (!CollabSrcLangNameStrFound.IsEmpty())
                    bFoundCollabSrcLangName = TRUE;
                continue;
            }
            chPos = lineStr.Find(szCollabTargetLangName);
            if (chPos == 0)
            {
                // Check for a following non-empty string, storing any string found for sanity checks (below)
                CollabTgtLangNameStrFound = lineStr.Mid(szCollabTargetLangName.Length());
                CollabTgtLangNameStrFound.Trim(FALSE);
                CollabTgtLangNameStrFound.Trim(TRUE);
                if (!CollabTgtLangNameStrFound.IsEmpty())
                    bFoundCollabTgtLangName = TRUE;
                continue;
            }
        }

        // At this point the collab settings have been examined, found flags set and strings stored.
        f.Close();

		// BEW added 15Aug16, it should not be assumed that collaboration restoration is wanted
		// every time a SHIFT_Launch to bypass the config files is done. Ask the user here...
		if (!m_bDoNormalProjectOpening)
		{
			wxString aTitle = _("Restore collaboration also?");
			wxString aMsg = _("If a collaboration was set up with Paratext or Bibledit, do you want it to be restored now, if possible?");
            // whm 15May2020 added below to supress phrasebox run-on due to handling of ENTER in CPhraseBox::OnKeyUp()
            m_bUserDlgOrMessageRequested = TRUE;
            if (wxMessageBox(aMsg, aTitle, wxICON_QUESTION | wxYES_NO | wxYES_DEFAULT) == wxYES)
			{
				; // continue processing
			}
			else
			{
				// Trick Adapt It into thinking essential collaboration recovery string values
				// are empty, and their associated booleans are false (despite the .ini file
				// having maybe valid values)
				bFoundCollabSrcProj = FALSE;
				bFoundCollabTgtProj = FALSE;
				bFoundCollabAiProj = FALSE;
				bFoundCollabSrcLangName = FALSE;
				bFoundCollabTgtLangName = FALSE;
				CollabSrcProjStrFound = wxEmptyString;
				CollabTgtProjStrFound = wxEmptyString;
				CollabSrcLangNameStrFound = wxEmptyString;
				CollabTgtLangNameStrFound = wxEmptyString;
				CollabAiProjStrFound = wxEmptyString;

				// Next bool is tested for TRUE in DocPage.cpp to suppress collab filename
				// removals in SHIFT-Launch when no collaboration restoration is wanted
				m_bUserWantsNoCollabInShiftLaunch = TRUE; // the only place this gets set TRUE
				return collabProjNotConfigured;
			}
		}
		else
		{
			m_bDoNormalProjectOpening = TRUE;
		}

        // Do some sanity checks to ensure that the crucial strings are consistent and
        // represent valid projects (guarding against corruption or erroneous editing of the
        // project config file):
        //
        // The first 6 are checks for when the CollabAIProjectName field has a string entry:
        // 1. Ensure that the CollaborationEditor field is set to either "Paratext" or "Bibledit".
        // 2. Check that the string stored in the "CollabAIProjectName" is identical to the
        // m_projectName incoming parameter.
        // 3. Check for existence of the CollabSourceLangName field. If it is missing parse the source
        // lang name from the CollabAIProjectName and assign that name to CollabSourceLangName.
        // 4. If the CollabSourceLangName exists, check whether it agrees with the parsed source lang
        // name from the CollabAIProjectName string. If not just log the fact that it differs.
        // 5. Check for existence of the CollabTargetLangName field. If it is missing parse the target
        // lang name from the CollabAIProjectName and assign that name to CollabTargetLangName.
        // 6. If the CollabTargetLangName exists, check whether it agrees with the parsed target lang
        // name from the CollabAIProjectName string. If not just log the fact that it differs.
        //
        // The next 5 checks are for when the CollabAIProjectName field is missing/empty:
        // 7. If the other 5 collab settings are present, construct a potential CollabAIProjectName
        // field entry from the CollabSourceLangName and CollabTargetLangName fields. If the
        // constructed name agrees with the currently selected AI project, go ahead and assign
        // the name of the currently selected project to the CollabAIProjectName field.
        // 8. If the constructed project name in 7 is not the same as the currently selected
        // project name, force the CollabAIProjectName, the CollabSourceLangName and the
        // CollabTargetLangName fields to agree with the currently selected AI project name.
        // 9. If all of the other 4 collab settings (not counting CollaborationEditor) are also
        // missing/empty, that is the normal situation for projects that have not been
        // configured for collaboration by the administrator.
        // 10. If the bFoundCollabSrcProj and bFoundCollabTgtProj were TRUE, but bFoundCollabAiProj was
        // FALSE, and either bFoundCollabSrcLangName or bFoundCollabTgtLangName or both were FALSE we
        // can construct the AI project names from the currently selected project (m_projectName).
        // 11. If any of the collab settings (mentioned in 9 above) are present, it is a mixed
        // bag. We just log information about the irregular settings, and consider the project
        // status is collabProjNotConfigured.
        //
        // The next checks are for validating the PT/BE collaboraion projects:
        // 12. If the CollabProjectForSourceInputs or CollabProjectForTargetExports is
        // missing/empty from the config file, pass an error message back to the caller
        // saying that the setting for the PT/BE project(s) is missing from the config
        // file, and return the collab status as collabProjMissingFromEditorList. The
        // caller (ProjectPage) will allow the user to select from available PT/BE projects
        // which, if the PT/BE projects prove valid will allow the user to continue collab
        // work.
        // 13. If the CollabProjectForSourceInputs or CollabProjectForTargetExports is
        // missing/empty from the config file, BUT a free trans project was designated in
        // the CollabProjectForFreeTransExports string setting, AND that PT/BE project
        // tests out to be INVALID, process that invalid project problem here with the
        // missing CollabProjectForSourceInputs/CollabProjectForTargetExports problem,
        // and pass it also as part of the error message back to the caller saying that
        // the setting for the PT/BE project(s) is missing from the config
        // file (or invalid in the case of the free trans proj). We still return the collab
        // status as collabProjMissingFromEditorList. The caller (ProjectPage) will allow
        // the user to select from available PT/BE projects which, if the PT/BE projects
        // prove valid will allow the user to continue collab work.
        // 14. If the CollabProjectForSourceInputs or CollabProjectForTargetExports fields
        // are present in the config file, check to ensure that they are also listed in the
        // PT/BE projList of current editor projects. If not pass an error message back to
        // the caller saying that the setting for the PT/BE project(s) could not be found
        // as a %s [external editor] project, and return the collab status as
        // collabProjMissingFromEditorList. The caller (ProjectPage) will allow the user to
        // select from available PT/BE projects which, if the PT/BE projects prove valid,
        // will allow the user to continue collab work.
        // 15. If both the CollabProjectForSourceInputs and CollabProjectForTargetExports fields
        // are present, and they exist in projList as Editor projects (see above checks), call the
        // CollabProjectsAreValid() function on them (and the CollabProjectForFreeTransExports value).
        // If the CollabProjectsAreValid() returns FALSE - along with an errStr message, return the
        // errorStr message to the caller and return the collab status as collabProjExistsButIsInvalid.
        // The caller (ProjectPage) will allow the user to select from available PT/BE projects which,
        // if the PT/BE projects prove valid, will allow the user to continue collab work.

        // 15a. whm 31March2017 added a further check.
        // If bFoundCollabSrcProj and bFoundCollabTgtProj are both TRUE,
        // and, if the current collaboration editor is specified to be PT7,
        // and, if PT7 and PT8 are both installed,
        // and, if there are now PT8 projects existing that are the same named
        //      projects being used in collaboration between AI and PT7,
        // and, if the GUID for the PT8 project is same as GUID of the PT7 projects
        // then return via a new reference bool parameter called
        // bBothPT7AndPT8InstalledPT8ProjectsWereMigrated
        // so the caller can make a one-time query to the user to determine if collaboration
        // should now be continued with the same projects that are now in the PT8 data store.

        // 16. If the GetAIProjectCollabStatus() function has not returned a state value by
        // time control reaches this point, just return the collab status as
        // collabProjNotConfigured.
        // 17. If the project config file could not be opened successfully, return an error
        // message to that fact and return the collab status as projConfigFileUnableToOpen.

        // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
        // 1. Ensure that the CollaborationEditor field is set to either "Paratext" or "Bibledit".
        // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
        //
        // First do sanity test for the bFoundCollabEditor and ensure it is specified properly
        // whm 2May12 added this sanity test for a valid external editor for collaboration. It is
        // possible that a project could be copied (including the project config file) between a
        // Linux machine and a Windows machine. In such cases the CollaborationEditor field may
        // no longer refer to an existing external edditor. If the machine receiving the data does
        // have a different external Scripture editor installed, we can adjust the value of
        // CollaborationEditor to point to that existing external editor. If no external editor is
        // installed/available we need to prevent ...
        //
        // whm 27Nov12 added check to bleed off the case in which the
        // project was never configured for collaboration. If the values
        // for CollabAiProjStrFound, CollabSrcLangNameStrFound
        // and CollabRgtLangNameStrFound are empty we can assume that
        // the project was not previously configured by an
        // administrator as a collaboration project. In this case we
        // return collabProjNotConfigured.
        if (CollabAiProjStrFound.IsEmpty() && CollabSrcLangNameStrFound.IsEmpty() && CollabTgtLangNameStrFound.IsEmpty())
        {
            // The CollabAIProjectName, CollabSourceLangName and
            // CollabTargetLangName are all empty strings, and we
            // assume the project was never setup for collaboration.
            m_bCollaboratingWithBibledit = FALSE;
            m_bCollaboratingWithParatext = FALSE;
            return collabProjNotConfigured;
        }
        //
        // If the values for CollabAiProjStrFound, CollabSrcLangNameStrFound, and
        // CollabTgtLangNameStrFound are not empty, we can assume that the project was at some
        // point configured by an administrator as a collaboration project.
        // Check whether there is an actual installation of Paratext or Bibledit on the user's
        // machine. If not we must return collabProjExistsButEditorNotInstalled.
        // NOTE:
        // BEW 23Mar15, If a unix or linux upgrade of the operating system is done, and Paratext (or
        // Bibledit if relevant) is blown away in the OS upgrade, then the InventoryCollabEditorInstalls() call
        // (or the one for BE) making gbPTNotInstalled will be FALSE - this will drop control into the error
        // block and so the StartWorking wizard is exited prematurely, with an error dialog. The
        // config settings are squirreled away in a wxConfigFile instance, and remain intact across the
        // OS upgrade - and even if I manually edit everything to remove all memory of collaboration,
        // the wxConfigFile data get used to restore the old collaboration values. So the ONLY fix in
        // this scenario is to reinstall Paratext after the OS upgrade (or BE if relevant) so as to
        // be able to get the app running - and then the collaboration can be clobbered from within
        // the running Adapt It if that is what is wanted. So BEWARE!!!
        // whm 4Feb2020 modified to use the more flexible bool value gbPTNotInstalled in test below.
        //if (!CollabAiProjStrFound.IsEmpty() && !CollabSrcLangNameStrFound.IsEmpty() && !CollabTgtLangNameStrFound.IsEmpty()
        //    && (ParatextVersionInstalled() == PTNotInstalled) && !BibleditIsInstalled())
        if (!CollabAiProjStrFound.IsEmpty() && !CollabSrcLangNameStrFound.IsEmpty() && !CollabTgtLangNameStrFound.IsEmpty()
            && (gbPTNotInstalled) && !BibleditIsInstalled())
            {
            // Although there are collaboration values in the project config file, there is currently
            // no installation of Paratext or Bibledit on the machine, so regardless of whether
            // the bFoundCollabEditor is TRUE or FALSE, the user's computer is not set up to
            // do collaboration. Return that status with collabProjExistsButEditorNotInstalled.
            // whm 30Dec2016 modified. Return a null errorStr here. Instead compose a more informative
            // message back in the caller of AiProjectCollabStatus, the CProjectPage:OnWizardPageChanging().
            //wxString msg = _("The Adapt It project \"%s\" has been setup for collaboration, but neither Paratext nor Bibledit are installed on this computer. In order to continue to work on this project, Paratext or Bibledit need to be installed with the necessary projects for collaboration with Adapt It.");
            //msg = msg.Format(msg, m_projectName.c_str());
            //errorStr = msg;
            errorStr = _T("");;
            return collabProjExistsButEditorNotInstalled;
        }

        // whm 4Feb2020 Note: With the release of Paratext versions 8 & 9, verification of an
        // AI project's collaboration status has become more complicated and the tests to validate
        // the collab editor and any PT version have been put into a separate function.
        // The ValidateCollabEditorAndVersionStrAgainstInstallationData() call below verifies
        // that the data store for that version of PT has valid PT projects for the specified
        // source and target language projects.

        // Verify that the collaboration editor specified in the config file is actually
        // installed on the computer. If not, check to see if the other external editor
        // is installed and if it is, use it instead.

        m_ParatextVersionForProject = ValidateCollabEditorAndVersionStrAgainstInstallationData(m_collaborationEditor, collabPTVersionStrFound);

        if (collabPTVersionStrFound != m_ParatextVersionForProject || CollabEditorStrFound != m_collaborationEditor)
        {
            // The project config values need to be changed for this project since the collab
            // editor was changed or the PT version was changed.
            bChangeMadeToCollabSettings = TRUE; // to force a save of project config file with new setting
        }

        // Next do sanity test for the AI Project settings (CollabAIProjectName field)
        wxString srcNameStr;
        wxString tgtNameStr;
        GetSrcAndTgtLanguageNamesFromProjectName(m_projectName, srcNameStr, tgtNameStr);
        if (bFoundCollabAiProj)
        {
            // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
            // 2. Check that the string stored in the "CollabAIProjectName" is identcial to the
            // m_projectName incoming parameter.
            // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
            //
            // A CollabAIProjectName string is stored in the config file. Do some sanity tests.
            // Test if the found string differs from the currently selected project in
            // m_projectName. If so fix it.
            if (CollabAiProjStrFound != m_projectName)
            {
                // There was an AI project name in the field, but the name doesn't match
                // the name of the incoming m_projectName. The incoming m_projectName must be
                // the name of the project being opened, so we can unilaterally set the name of
                // the AI project for collaboration to the correct project name for storing in
                // the project config file (below).
                wxString msg = _T("In GetAIProjectCollabStatus() the user selected project name (%s) differed from the config file's CollabAIProjectName (%s), so AI assigned the selected project name to the config file entry.");
                msg = msg.Format(msg, m_projectName.c_str(), CollabAiProjStrFound.c_str());
                this->LogUserAction(msg);
                m_CollabAIProjectName = m_projectName;
                // We rectified the problem programmatically, so update the CollabAiProjStrFound
                // for other validation checks below.
                CollabAiProjStrFound = m_projectName; // update the found one too
                bChangeMadeToCollabSettings = TRUE;
                // Continue on with other validation checks for this project.
            }
            // Note: The ai project name now must necessarily exists as an AI project on the
            // user's machine (after all, the user just selected it from the project page's list).
            //
            // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
            // 3. Check for existence of the CollabSourceLangName field. If it is missing parse the source
            // lang name from the CollabAIProjectName and assign that name to CollabSourceLangName.
            // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
            if (!bFoundCollabSrcLangName)
            {
                // The CollabSourceLangName was empty in the config file. We can supply the
                // lang name(s) by assigning it from the parsed ai project name taking the first part.
                if (CollabSrcLangNameStrFound.IsEmpty())
                {
                    wxString msg = _T("In GetAIProjectCollabStatus() the CollabSourceLangName was missing, so AI assigned %s to it by parsing the AI project name (%s)");
                    msg = msg.Format(msg, srcNameStr.c_str(), m_projectName.c_str());
                    this->LogUserAction(msg);
                    m_CollabSourceLangName = srcNameStr;
                    bChangeMadeToCollabSettings = TRUE;
                    // We rectified the problem programmatically, so update the flags for other
                    // validation checks below.
                    bFoundCollabSrcLangName = TRUE;
                    CollabSrcLangNameStrFound = srcNameStr;
                    // Continue on with other validation checks for this project.
                }
            }
            else
            {
                // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                // 4. If the CollabSourceLangName exists, check whether it agrees with the parsed source lang
                // name from the CollabAIProjectName string. If not just log the fact that it differs.
                // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                //
                // At this point we know that a source lang name exists, now compare it with the
                // source lang part of the ai project name, and put an entry in the user log if the
                // source lang name in the config file differs from the source language name parsed
                // from the AI project name.
                if (srcNameStr != CollabSrcLangNameStrFound)
                {
                    wxString msg = _T("In GetAIProjectCollabStatus() the Source language name from the AI project name is %s, but the name from the config file is %s");
                    msg = msg.Format(msg, srcNameStr.c_str(), CollabSrcLangNameStrFound.c_str());
                    this->LogUserAction(msg);
                    // Continue on with other validation checks for this project.
                }

            }
            // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
            // 5. Check for existence of the CollabTargetLangName field. If it is missing parse the target
            // lang name from the CollabAIProjectName and assign that name to CollabTargetLangName.
            // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
            if (!bFoundCollabTgtLangName)
            {
                // The CollabTargetLangName was empty in the config file. We can supply the
                // lang name(s) by assigning it from the parsed ai project name taking the second part.
                if (CollabTgtLangNameStrFound.IsEmpty())
                {
                    wxString msg = _T("In GetAIProjectCollabStatus() the CollabTargetLangName was missing, so AI assigned %s to it by parsing the AI project name (%s)");
                    msg = msg.Format(msg, tgtNameStr.c_str(), m_projectName.c_str());
                    this->LogUserAction(msg);
                    m_CollabTargetLangName = tgtNameStr;
                    bChangeMadeToCollabSettings = TRUE;
                    // We rectified the problem programmatically, so update the flags for other
                    // validation checks below
                    bFoundCollabTgtLangName = TRUE;
                    CollabTgtLangNameStrFound = tgtNameStr;
                    // Continue on with other validation checks for this project.
                }
            }
            else
            {
                // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                // 6. If the CollabTargetLangName exists, check whether it agrees with the parsed target lang
                // name from the CollabAIProjectName string. If not just log the fact that it differs.
                // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                //
                // At this point we know that a target lang name exists, now compare it with the
                // target lang part of the ai project name, and put an entry in the user log if the
                // source lang name in the config file differs from the source language name parsed
                // from the AI project name.
                if (tgtNameStr != CollabTgtLangNameStrFound)
                {
                    wxString msg = _T("In GetAIProjectCollabStatus() the Target language name from the AI project name is %s, but the name from the config file is %s");
                    msg = msg.Format(msg, tgtNameStr.c_str(), CollabTgtLangNameStrFound.c_str());
                    this->LogUserAction(msg);
                    // Continue on with other validation checks for this project.
                }
            }
        }
        else
        {
            // The "CollabAIProjectName" in the config file was empty. If the bFoundCollabSrcProj,
            // the bFoundCollabTgtProj, the bFoundCollabEditor, the bFoundCollabSrcLangName,
            // and the bFoundCollabTgtLangName flags are TRUE we can confidently reconstruct the
            // CollabAIProjectName from the two Lang Name fields and ensure that the reconstructed string
            // is consistent with the currently selected AI project. If so we can supply the string for the
            // CollabAIProjectName field. Otherwise, if either one or both of the PT/BE project fields, or
            // either one or both of the two Lang Name fields are empty, we presume that the project is not
            // a configured/valid collaboration project.
            if (bFoundCollabSrcProj && bFoundCollabTgtProj && bFoundCollabSrcLangName && bFoundCollabTgtLangName && bFoundCollabEditor)
            {
                // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                // 7. If the other 5 collab settings are present, construct a potential CollabAIProjectName
                // field entry from the CollabSourceLangName and CollabTargetLangName fields. If the
                // constructed name agrees with the currently selected AI project, go ahead and assign
                // the name of the currently selected project to the CollabAIProjectName field.
                // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                //
                // All the critical collab fields except for the CollabAIProjectName field were present in
                // the config file, so the CollabAIProjectName field must have been lost or corrupted from
                // manual editing. We can reconstruct the potential ai project name from the Lang Names present.
                wxString constructedAIProjName = CollabSrcLangNameStrFound + _T(" to ") + CollabTgtLangNameStrFound + _T(" adaptations");
                // Check if it is consistent with the currently selected project name. If so, we can assign
                // the constructedAIProjName to the CollabAIProjectName. If not, we have no other recourse
                // in reconstructing the complete collab settings and we must force it to be the same, and log
                // that fact.
                if (constructedAIProjName == m_projectName)
                {
                    wxString msg = _T("In GetAIProjectCollabStatus() the CollabAIProjectName was missing, but the other collab settings found allowed it to be reassigned to %s, the currently selected ai project");
                    msg = msg.Format(msg, m_projectName.c_str());
                    this->LogUserAction(msg);
                    this->m_CollabAIProjectName = m_projectName;
                    // We rectified the problem programmatically, so update the flags for other
                    // validation checks below
                    CollabAiProjStrFound = m_projectName;
                    bChangeMadeToCollabSettings = TRUE;
                    // Continue on with other validation checks for this project.
                }
                else
                {
                    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                    // 8. If the constructed project name in 7 is not the same as the currently selected
                    // project name, force the CollabAIProjectName, the CollabSourceLangName and the
                    // CollabTargetLangName fields to agree with the currently selected AI project name.
                    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                    //
                    // The constructed project name is not the same as the currenly selected project's
                    // name, so we cannot really proceed with a collaboration session unless we force the
                    // collab AI Project Name and the Lang Names to agree with the currently selected
                    // project. We will do that and log the actions that we have to take to make the
                    // collaboration settings consistent with the currently selected project.
                    // Note: Tests show that the check in 2 above and 10 below and other internal checks
                    // should remedy the issue here in 8. without the need for this test, but 8 is an
                    // additional fail-safe mechanism.
                    wxString msg = _T("In GetAIProjectCollabStatus() the CollabAIProjectName was empty and the CollabSourceLangName and CollabTargetLangName fields are inconsistent with the currently selected project (%s). All three were changed to agree with a %s project.");
                    msg = msg.Format(msg, m_projectName.c_str(), m_projectName.c_str());
                    this->LogUserAction(msg);
                    this->m_CollabAIProjectName = m_projectName;
                    this->m_CollabSourceLangName = srcNameStr;
                    this->m_CollabTargetLangName = tgtNameStr;
                    // We rectified the problem programmatically, so update the flags for other
                    // validation checks below
                    CollabAiProjStrFound = m_projectName;
                    CollabSrcLangNameStrFound = srcNameStr;
                    CollabTgtLangNameStrFound = tgtNameStr;
                    bChangeMadeToCollabSettings = TRUE;
                    // Continue on with other validation checks for this project.
                }
            }
            else
            {
                // The "CollabAIProjectName" in the config file was empty, and one or more (perhaps all)
                // of the other four important collab values were not defined as strings in the config
                // file. The obvious case is when all five values are empty - indicating the normal state
                // for an AI project that has not been configured for collaboration by an administrator.
                // We do not include the bFoundCollabEditor in the test because it should always be
                // defined at this point (see above).
                //
                // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                // 9. If all of the other 4 collab settings (not counting CollaborationEditor) are also
                // missing/empty, which is the normal situation for projects that have not been
                // configured for collaboration by the administrator.
                // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                //
                if (!bFoundCollabSrcProj && !bFoundCollabTgtProj && !bFoundCollabSrcLangName && !bFoundCollabTgtLangName)
                {
                    // This is the normal exit point for a project which has not been configured for
                    // collaboration with PT/BE.
                    return collabProjNotConfigured;
                }
                else if (!bFoundCollabSrcLangName || !bFoundCollabTgtLangName)
                {
                    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                    // 10. If the bFoundCollabSrcProj and bFoundCollabTgtProj were TRUE, but bFoundCollabAiProj was
                    // FALSE, and either bFoundCollabSrcLangName or bFoundCollabTgtLangName or both were FALSE we
                    // can construct the AI project names from the currently selected project (m_projectName).
                    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                    wxString msg = _T("In GetAIProjectCollabStatus() the CollabAIProjectName is missing and one or both of the CollabSourceLangName or CollabTargetLangName are missing, so AI parsed %s and assigned the names to those 3 config file entries.");
                    msg = msg.Format(msg, m_projectName.c_str());
                    this->LogUserAction(msg);
                    m_CollabAIProjectName = m_projectName;
                    GetSrcAndTgtLanguageNamesFromProjectName(m_CollabAIProjectName, m_CollabSourceLangName, m_CollabTargetLangName);
                    // We rectified the problem programmatically, so update the CollabAiProjStrFound
                    // for other validation checks below.
                    CollabAiProjStrFound = m_projectName; // update the found one too
                    CollabSrcLangNameStrFound = m_CollabSourceLangName;
                    CollabTgtLangNameStrFound = m_CollabTargetLangName;
                    bChangeMadeToCollabSettings = TRUE;
                    // Continue on with other validation checks for this project.
                }
                else
                {
                    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                    // 11. If any of the collab settings (mentioned in 9 above) are present, it is a mixed
                    // bag. We just log information about the irregular settings, and consider the project
                    // status is collabProjNotConfigured.
                    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                    //
                    // If any of the above four flags are TRUE (indicating the presence of a collab setting), just
                    // log that fact as an irregularity, but with the CollabAIProjectName empty and at least one of
                    // the other collab settings also empty, we judge that the project was not configured, or
                    // partially corrupted in any case. We could empty any partial settings, but probably it is
                    // better to leave them present so an advisor or administrator can inspect the project config
                    // file if desired.
                    wxString tempStr = _T("");
                    if (bFoundCollabSrcProj)
                    {
                        tempStr = _T("CollabProjectForSourceInputs: ");
                    }
                    if (bFoundCollabTgtProj)
                    {
                        if (!tempStr.IsEmpty())
                            tempStr += _T(", ");
                        tempStr += _T("CollabProjectForTargetExports: ");
                    }
                    if (bFoundCollabSrcLangName)
                    {
                        if (!tempStr.IsEmpty())
                            tempStr += _T(", ");
                        tempStr += _T("CollabSourceLangName: ");
                    }
                    if (bFoundCollabTgtLangName)
                    {
                        if (!tempStr.IsEmpty())
                            tempStr += _T(", ");
                        tempStr += _T("CollabTargetLangName: ");
                    }
                    if (!tempStr.IsEmpty())
                    {
                        wxString msg = _T("In GetAIProjectCollabStatus: The CollabAIProjectName was empty, but the following collab setting(s) had data: %s. Returning collabProjNotConfigured.");
                        msg = msg.Format(msg, tempStr.c_str());
                        this->LogUserAction(msg);
                    }
                    // This is the exit point for a project that is not configured for collaboration, but
                    // has some partial collaboration setting(s) which are now in the user log.
                    return collabProjNotConfigured;
                }
            } // end of else block where one or more of five other values (apart from CollabAIProjectName) had collab data
        } // end of else "CollabAIProjectName" in the config file was empty

          // At this point, we've completed the above sanity tests, and the AI Collab Project should exist.
        wxASSERT(!m_CollabAIProjectName.IsEmpty());

        // Finally, do sanity tests for the indicated PT/BE collab projects. Do they exist and do they
        // have the necessary empty chapter and verse markers? The tests for the presence of empty
        // chapter and verse markers that has been previously just done in the GetSourceTextFromEditor
        // dialog is also being done here (called from the wizard), earlier in the collaboration process
        // at a point where incorrect settings are easier to handle and an advisor or administrator is
        // more likely to see the problem and handle the situation.

        // Get a list of the current PT/BE projects in projList.
        wxArrayString projList;
        projList.Clear();
        if (m_collaborationEditor == _T("Paratext"))
        {
            if (this->m_ParatextVersionForProject == _T("PTVersion7"))
            {
                projList = GetListOfPTProjects(_T("PTVersion7")); // as a side effect, it populates the App's m_pArrayOfCollabProjects
            }
            else if (this->m_ParatextVersionForProject == _T("PTVersion8"))
            {
                projList = GetListOfPTProjects(_T("PTVersion8")); // as a side effect, it populates the App's m_pArrayOfCollabProjects
            }
            // whm 4Feb2020 added test below for PTVersion9
            else if (this->m_ParatextVersionForProject == _T("PTVersion9"))
            {
                projList = GetListOfPTProjects(_T("PTVersion9")); // as a side effect, it populates the App's m_pArrayOfCollabProjects
            }
            else if (this->m_ParatextVersionForProject == _T("PTLinuxVersion7"))
            {
                projList = GetListOfPTProjects(_T("PTLinuxVersion7")); // as a side effect, it populates the App's m_pArrayOfCollabProjects
            }
            else if (this->m_ParatextVersionForProject == _T("PTLinuxVersion8"))
            {
                projList = GetListOfPTProjects(_T("PTLinuxVersion8")); // as a side effect, it populates the App's m_pArrayOfCollabProjects
            }
            // whm 4Feb2020 added test below for PTLinuxVersion9
            else if (this->m_ParatextVersionForProject == _T("PTLinuxVersion9"))
            {
                projList = GetListOfPTProjects(_T("PTLinuxVersion9")); // as a side effect, it populates the App's m_pArrayOfCollabProjects
            }
        }
        else if (m_collaborationEditor == _T("Bibledit"))
        {
            projList = GetListOfBEProjects(); // as a side effect, it populates the App's m_pArrayOfCollabProjects
        }

        // If either the source or target PT/BE project name(s) are missing, we cannot proceed with
        // collaboration
        //
        // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
        // 12. If the CollabProjectForSourceInputs or CollabProjectForTargetExports is
        // missing/empty from the config file, pass an error message back to the caller
        // saying that the setting for the PT/BE project(s) is missing from the config
        // file, and return the collab status as collabProjMissingFromEditorList. The
        // caller (ProjectPage) will allow the user to select from available PT/BE projects
        // which, if the PT/BE projects prove valid will allow the user to continue collab
        // work.
        // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
        if (!bFoundCollabSrcProj || !bFoundCollabTgtProj)
        {
            wxString msg;
            wxString projects = _T("");
            if (!bFoundCollabSrcProj)
            {
                msg = _T("1. ");
                msg += _("The Adapt It project \"%s\" is missing its setting that designates its %s project for obtaining source texts.");
                msg = msg.Format(msg, m_projectName.c_str(), m_collaborationEditor.c_str());
                projects = _T("source");
            }
            if (!bFoundCollabTgtProj)
            {
                if (!msg.IsEmpty())
                    msg += _T("\n2. ");
                else
                    msg += _T("1. ");
                msg += _("The Adapt It project \"%s\" is missing its setting that designates its %s project for storing translation texts.");
                msg = msg.Format(msg, m_projectName.c_str(), m_collaborationEditor.c_str());
                if (!projects.IsEmpty())
                    projects += _T(':');
                projects += _T("target");
            }
            // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
            // 13. If the CollabProjectForSourceInputs or CollabProjectForTargetExports is
            // missing/empty from the config file, BUT a free trans project was designated in
            // the CollabProjectForFreeTransExports string setting, AND that PT/BE project
            // tests out to be INVALID, process that invalid project problem here with the
            // missing CollabProjectForSourceInputs/CollabProjectForTargetExports problem,
            // and pass it also as part of the error message back to the caller saying that
            // the setting for the PT/BE project(s) is missing from the config
            // file (or invalid in the case of the free trans proj). We still return the collab
            // status as collabProjMissingFromEditorList. The caller (ProjectPage) will allow
            // the user to select from available PT/BE projects which, if the PT/BE projects
            // prove valid will allow the user to continue collab work.
            // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
            //
            // Note: It could be that the source or target project (or both) are missing from the
            // config file, and yet a free trans project string is present, but it might not be
            // a valid PT/BE project. If that is the case we should have the problem re the free
            // trans project included with the above message - so that in the ProjectPage the user
            // can select a correct PT/BE project for the free trans.
            if (bFoundCollabFreeTransProj)
            {
                if (!CollabProjectHasAtLeastOneBook(CollabFreeTransProjStrFound, m_collaborationEditor, m_ParatextVersionForProject))
                {
                    // There is not at least one book in the Source project
                    wxString msgAdd;
                    msgAdd = _("The Adapt It project \"%s\" has a setting that designates its %s project for storing free translations, but the \"%s\" project does not have any books created in it.");
                    msgAdd = msgAdd.Format(msgAdd, m_projectName.c_str(), m_collaborationEditor.c_str(), CollabFreeTransProjStrFound.c_str());
                    if (!bFoundCollabSrcProj && !bFoundCollabTgtProj)
                    {
                        // neither src nor tgt were found and were items 1 and 2; free trans is item 3.
                        msgAdd = _T("\n3. ") + msgAdd;
                    }
                    else if ((bFoundCollabSrcProj && !bFoundCollabTgtProj) || (bFoundCollabTgtProj && !bFoundCollabSrcProj))
                    {
                        // the src or tgt was found but not both getting item 1; free trans is item 2.
                        msgAdd = _T("\n2. ") + msgAdd;
                    }
                    else
                    {
                        // both src and tgt were found, so free trans is first item, item 1
                        msgAdd = _T("\n1. ") + msgAdd;
                    }
                    msg += msgAdd;
                    if (!projects.IsEmpty())
                        projects += _T(':');
                    projects += _T("freetrans");
                }
            }

            errorStr = msg; // return the errorStr to the caller by reference
            errorProjects += projects; // return the project type ("source", "target" or "freetrans").
                                       // This is the exit point for a project whose config file is missing its
                                       // CollabProjectForSourceInputs or CollabProjectForTargetExports string value.
            return collabProjMissingFromConfigFile;
        }
        else
        {
            // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
            // 14. If the CollabProjectForSourceInputs or CollabProjectForTargetExports fields
            // are present in the config file, check to ensure that they are also listed in the
            // PT/BE projList of current editor projects. If not pass an error message back to
            // the caller saying that the setting for the PT/BE project(s) could not be found
            // as a %s [external editor] project, and return the collab status as
            // collabProjMissingFromEditorList. The caller (ProjectPage) will allow the user to
            // select from available PT/BE projects which, if the PT/BE projects prove valid,
            // will allow the user to continue collab work.
            // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
            //
            // both bFoundCollabSrcProj and bFoundBollabTgtProj are TRUE, so the project config file
            // contains strings for both. Now test that they exist in the inventory of current PT/BE
            // projects (in projList) by calling CollabProjectFoundInListOfEditorProjects() on each
            // PT/BE project name that appears in the project config file.
            wxString foundSrcProjString = _T("");
            wxString foundTgtProjString = _T("");
            wxString foundFreeTransProjString = _T("");
            // In the CollabProjectFoundInListOfEditorProjects() function calls below the short name
            // of the project is used (in PT) to match an existing PT/BE project (in projList). If
            // the returned value is FALSE, no project was found, if the returned value is TRUE the
            // project was found and the returned by reference foundProjString parameter will contain
            // the actual composed string of the project - this is used to correct any typos in the
            // full name part of a PT composite project id string.
            wxString msg = _T("");
            wxString projects = _T("");
            bool srcProjFoundInEditor = TRUE;
            bool tgtProjFoundInEditor = TRUE;
            bool freeTransProjFoundInEditor = TRUE;
            srcProjFoundInEditor = CollabProjectFoundInListOfEditorProjects(CollabSrcProjStrFound, projList, foundSrcProjString);
            tgtProjFoundInEditor = CollabProjectFoundInListOfEditorProjects(CollabTgtProjStrFound, projList, foundTgtProjString);
            if (!CollabFreeTransProjStrFound.IsEmpty())
                freeTransProjFoundInEditor = CollabProjectFoundInListOfEditorProjects(CollabFreeTransProjStrFound, projList, foundFreeTransProjString);
            if (!srcProjFoundInEditor)
            {
                // The project config file has an entry for the CollabSrcProjStrFound, but that project
                // could not be found in the PT/BE editor's list of current projects.
                wxString msgAdd = _("The \"%s\" project cannot be found as a %s project for obtaining source texts.");
                msgAdd = msgAdd.Format(msgAdd, CollabSrcProjStrFound.c_str(), m_collaborationEditor.c_str());
                msgAdd = _T("1. ") + msgAdd; // src was not found and is item 1
                msg += msgAdd;
                projects = _T("source");
            }
            else
            {
                // The project was found in the PT/BE editor's list of current projects.
                wxASSERT(!foundSrcProjString.IsEmpty());
                // Ensure the spelling of of full project name part in the config file is
                // correct as used within the actual editor's full project name (user could
                // have changed it in PT).
                if (CollabSrcProjStrFound != foundSrcProjString)
                {
                    // There was an irregularity in spelling of a token in the 2nd through 4th fields of the
                    // composite project string. Fix the App's value and set flag to save the project config
                    // file changes.
                    this->m_CollabProjectForSourceInputs = foundSrcProjString;
                    bChangeMadeToCollabSettings = TRUE;
                }
            }
            if (!tgtProjFoundInEditor)
            {
                // The project config file has an entry for the CollabTgtProjStrFound, but that project
                // could not be found in the PT/BE editor's list of current projects.
                wxString msgAdd = _("The \"%s\" project cannot be found as a %s project for storing translation texts.");
                msgAdd = msgAdd.Format(msgAdd, CollabTgtProjStrFound.c_str(), m_collaborationEditor.c_str());
                if (!srcProjFoundInEditor)
                {
                    // src was not found and was item 1; tgt is item 2.
                    msgAdd = _T("\n2. ") + msgAdd;
                }
                else
                {
                    // src was found; tgt is now item 1.
                    msgAdd = _T("1. ") + msgAdd;
                }
                msg += msgAdd;
                if (!projects.IsEmpty())
                    projects += _T(':');
                projects += _T("target");
            }
            else
            {
                // The project was found in the PT/BE editor's list of current projects.
                wxASSERT(!foundTgtProjString.IsEmpty());
                // Ensure the spelling of of full project name part in the config file is
                // correct as used within the actual editor's full project name (user could
                // have changed it in PT).
                if (CollabTgtProjStrFound != foundTgtProjString)
                {
                    // There was an irregularity in spelling of a token in the 2nd through 4th fields of the
                    // composite project string. Fix the App's value and set flag to save the project config
                    // file changes.
                    this->m_CollabProjectForTargetExports = foundTgtProjString;
                    bChangeMadeToCollabSettings = TRUE;
                }
            }
            if (!CollabFreeTransProjStrFound.IsEmpty() && !freeTransProjFoundInEditor)
            {
                // The project config file has an entry for the CollabFreeTransProjStrFound, but that project
                // could not be found in the PT/BE editor's list of current projects.
                wxString msgAdd = _("The \"%s\" project cannot be found as a %s project for storing free translation texts.");
                msgAdd = msgAdd.Format(msgAdd, CollabFreeTransProjStrFound.c_str(), m_collaborationEditor.c_str());
                if (!srcProjFoundInEditor)
                {
                    // src was not found as so was item 1
                    if (!tgtProjFoundInEditor)
                    {
                        // both src and tgt were not found (items 1 and 2); free trans is now item 3.
                        msgAdd = _T("\n3. ") + msgAdd;
                    }
                    else
                    {
                        // src was not found and was item 1, but tgt was found; free trans is now item 2.
                        msgAdd = _T("\n2. ") + msgAdd;
                    }
                }
                else
                {
                    // src was found
                    if (!tgtProjFoundInEditor)
                    {
                        // src was found but target not found and was item 1; free trans is item 2.
                        msgAdd = _T("\n2. ") + msgAdd;
                    }
                    else
                    {
                        // both src and tgt were found; free trans is first item, item 1.
                        msgAdd = _T("1. ") + msgAdd;
                    }
                }
                msg += msgAdd;
                if (!projects.IsEmpty())
                    projects += _T(':');
                projects += _T("freetrans");
            }
            else if (!CollabFreeTransProjStrFound.IsEmpty())
            {
                // The project was found in the PT/BE editor's list of current projects.
                wxASSERT(!foundFreeTransProjString.IsEmpty());
                // Ensure the spelling of of full project name part in the config file is
                // correct as used within the actual editor's full project name (user could
                // have changed it in PT).
                if (CollabFreeTransProjStrFound != foundFreeTransProjString)
                {
                    // There was an irregularity in spelling of a token in the 2nd through 4th fields of the
                    // composite project string. Fix the App's value and set flag to save the project config
                    // file changes.
                    this->m_CollabProjectForFreeTransExports = foundFreeTransProjString;
                    bChangeMadeToCollabSettings = TRUE;
                }
            }

            // Also ensure that the m_bCollaborationExpectsFreeTrans flag is FALSE if the free trans
            // string is empty, TRUE if it has valid (as checked above) content.
            bool bCollabExpectsFreeTransAsFound = CollabExpectsFreeTransFound == _T("1");
            if (!bFoundCollabExpectsFreeTrans || bCollabExpectsFreeTransAsFound != !CollabFreeTransProjStrFound.IsEmpty())
            {
                this->m_bCollaborationExpectsFreeTrans = !CollabFreeTransProjStrFound.IsEmpty();
                bChangeMadeToCollabSettings = TRUE;
            }

            if (!srcProjFoundInEditor || !tgtProjFoundInEditor || (!CollabFreeTransProjStrFound.IsEmpty() && !freeTransProjFoundInEditor))
            {
                errorStr = msg; // return the errorStr to the caller by reference
                errorProjects = projects; // return the project type ("source", "target", or "freetrans") by reference
                return collabProjMissingFromEditorList;
            }

        }
        // Also ensure that the m_bCollaborationExpectsFreeTrans flag is FALSE if the free trans
        // string is empty, TRUE if it has valid (as checked above) content.
        bool bCollabExpectsFreeTransAsFound = CollabExpectsFreeTransFound == _T("1");
        if (!bFoundCollabExpectsFreeTrans || bCollabExpectsFreeTransAsFound != !CollabFreeTransProjStrFound.IsEmpty())
        {
            this->m_bCollaborationExpectsFreeTrans = !CollabFreeTransProjStrFound.IsEmpty();
            bChangeMadeToCollabSettings = TRUE;
        }

        // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
        // 15. If both the CollabProjectForSourceInputs and CollabProjectForTargetExports fields
        // are present, and they exist in projList as Editor projects (see above checks), call the
        // CollabProjectsAreValid() function on them (and the CollabProjectForFreeTransExports value).
        // If the CollabProjectsAreValid() returns FALSE - along with an errStr message, return the
        // errorStr message to the caller and return the collab status as collabProjExistsButIsInvalid.
        // The caller (ProjectPage) will allow the user to select from available PT/BE projects which,
        // if the PT/BE projects prove valid, will allow the user to continue collab work.
        // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
        if (bFoundCollabSrcProj && bFoundCollabTgtProj)
        {
            // Check the validity of the PT/BE projects. They are valid if they are not
            // empty and calls to CollabProjectHasAtLeastOneBook() indicate that each of the
            // projects have at least one book defined.
            //
            // Note: This CollabProjectsAreValid() call is also done within the 3-button
            // ChooseCollabOptionsDlg's InitDialog() method using the App's stored values
            // for the PT/BE projects' (composite) strings.
            wxString errStr = _T("");
            wxString errProj = _T("");
            if (!CollabProjectsAreValid(CollabSrcProjStrFound, CollabTgtProjStrFound,
                CollabFreeTransProjStrFound, m_collaborationEditor, m_ParatextVersionForProject,
                errStr, errProj))
            {
                errorStr = errStr;
                errorProjects = errProj;
                return collabProjExistsButIsInvalid;
            }
            else
            {
                // the PT/BE projects of concern are valid, but before we return the collabProjExistsAndIsValid enum
                // we'll determine if the project is a PT7 project which has been migrated to PT8 so that it has
                // both valid PT7 and valid PT8 projects that are currently being used for collaboration. We'll return
                // a bool parameter by reference to the caller via this GetAIProjectCollabStatus() function, so the caller
                // can handle any interaction deemed necessary with the user. According to Tom H. we can tell if a PT8
                // project has been migrated from PT7 if its settings GUID has 