# Payment App

The Payment application is a Django-based solution for integrating PayPal payments into your web application. It
provides a set of views and models to handle the payment process and stores the payment data in the database.

## Model

The `Payment` model represents a single payment record and contains the following fields:

- `order_id`: The unique identifier for the payment order generated by PayPal.
- `reference_id`: A custom reference identifier for the payment.
- `amount`: The amount of the payment with a maximum of 10 digits and 2 decimal places.
- `currency`: The currency code for the payment (e.g., USD).
- `status`: The status of the payment (e.g., CREATED, APPROVED, COMPLETED).
- `linked_object_type`, `linked_object_id`, `linked_object`: These three fields together create a GenericForeignKey to
  link the payment to any other Django model instance.

## Views

The Payment app includes several views to handle the payment process:

### `create_order`

This view is responsible for creating a PayPal payment order for a specific object. It takes the object's ID as a
parameter, retrieves the related object, generates a unique reference ID, and sends a request to the PayPal API to
create the order. If successful, it creates a new Payment instance with the order data and returns the order ID.

### `capture_order`

This view is responsible for capturing a completed payment order. It takes the order ID as a parameter, retrieves the
related Payment instance, and updates its status to "COMPLETED". It then returns the updated order data.

### `payment`

This view handles the payment page where the user is presented with the PayPal payment button. It takes the object ID
and a custom ID request as parameters, retrieves the related object, and generates the necessary PayPal API access token
and client token. It then renders the payment template with the required context data. Once the payment is completed,
the user is redirected to the `payment_success` view. and an email is sent to the user with the payment details.

### `payment_success`

This view handles the success page after a successful payment. It takes the object ID and order ID as parameters,
retrieves the related object, updates its paid status to `True`, and sends a "Payment successful" email to the user. It
then renders the success template with the required context data.

## JavaScript

The HTML template for the payment page includes a PayPal JavaScript SDK script that handles the creation and capturing
of orders. It defines the `createOrder` and `onApprove` functions for the PayPal button, which are responsible for
calling the `create_order` and `capture_order` views, respectively. Upon successful capturing of the order, the user is
redirected to the `payment_success` view.

## Usage

To use the Payment app, you need to include it in your Django project and configure the necessary settings, such as the
PayPal client ID, client secret, and environment.

Once everything is set up, you can use the Payment app to handle payments for any Django model instance by linking it to
the `Payment` model using a GenericForeignKey.