---
title: Text fields
description: Text fields let users enter text into a UI
---

## Usage

<usage></usage>

## Props

### TextField

| Name                 | Type                                                                    | Default  | Description                                                                                                                                                                                                                           |
| -------------------- | ----------------------------------------------------------------------- | -------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `label`              | `string`                                                                | —        | Input label                                                                                                                                                                                                                           |
| `isInvalid`          | `boolean`                                                               | —        | Whether the value is invalid.                                                                                                                                                                                                         |
| `isDisabled`         | `boolean`                                                               | —        | Whether the input is disabled.                                                                                                                                                                                                        |
| `isReadOnly`         | `boolean`                                                               | —        | Whether the input can be selected but not changed by the user.                                                                                                                                                                        |
| `isRequired`         | `boolean`                                                               | —        | Whether user input is required on the input before form submission.                                                                                                                                                                   |
| `validate`           | `(value: string) => ValidationError \| true \| null \| undefined`       | —        | A function that returns an error message if a given value is invalid. Validation errors are displayed to the user when the form is submitted if validationBehavior="native". For realtime validation, use the isInvalid prop instead. |
| `autoFocus`          | `boolean`                                                               | —        | Whether the element should receive focus on render.                                                                                                                                                                                   |
| `value`              | `string`                                                                | —        | The current value (controlled).                                                                                                                                                                                                       |
| `defaultValue`       | `string`                                                                | —        | The default value (uncontrolled).                                                                                                                                                                                                     |
| `autoComplete`       | `string`                                                                | —        | Describes the type of autocomplete functionality the input should provide if any. See [MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#htmlattrdefautocomplete).                                                 |
| `maxLength`          | `number`                                                                | —        | The maximum number of characters supported by the input. See [MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#htmlattrdefmaxlength).                                                                             |
| `minLength`          | `number`                                                                | —        | The minimum number of characters required by the input. See [MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#htmlattrdefminlength).                                                                              |
| `pattern`            | `string`                                                                | —        | Regex pattern that the value of the input must match to be valid. See [MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#htmlattrdefpattern).                                                                      |
| `type`               | `text` `textarea` `search` `url` `tel` `email` `password` `string & {}` | 'text'   | The type of input to render. See [MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#htmlattrdeftype).                                                                                                              |
| `inputMode`          | `none` `text` `tel` `url` `email` `numeric` `decimal` `search`          | —        | Hints at the type of data that might be entered by the user while editing the element or its contents. See [MDN](https://html.spec.whatwg.org/multipage/interaction.html#input-modalities:-the-inputmode-attribute).                  |
| `name`               | `string`                                                                | —        | The name of the input element, used when submitting an HTML form. See [MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#htmlattrdefname).                                                                         |
| `validationBehavior` | `native` `aria`                                                         | 'native' | Whether to use native HTML form validation to prevent form submission when the value is missing or invalid, or mark the field as required or invalid via ARIA.                                                                        |
| `children`           | `React.ReactNode`                                                       | —        | The children of the component. A function may be provided to alter the children based on component state.                                                                                                                             |
| `className`          | `string`                                                                | —        | The CSS className for the element. A function may be provided to compute the class based on component state.                                                                                                                          |
| `style`              | `React.CSSProperties`                                                   | —        | The inline style for the element. A function may be provided to compute the style based on component state.                                                                                                                           |
| `variant`            | `filled` `outlined`                                                     | 'filled' |                                                                                                                                                                                                                                       |
| `suffixText`         | `string`                                                                | —        |                                                                                                                                                                                                                                       |
| `prefixText`         | `string`                                                                | —        |                                                                                                                                                                                                                                       |
| `leadingIcon`        | `React.ReactNode`                                                       | —        |                                                                                                                                                                                                                                       |
| `trailingIcon`       | `React.ReactNode`                                                       | —        |                                                                                                                                                                                                                                       |

## Events

| Name                 | Type                                        | Description                                                                                                                                                                              |
| -------------------- | ------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `onFocus`            | `(e: FocusEvent<T>) => void`                | Handler that is called when the element receives focus.                                                                                                                                  |
| `onBlur`             | `(e: FocusEvent<T>) => void`                | Handler that is called when the element loses focus.                                                                                                                                     |
| `onFocusChange`      | `(isFocused: boolean) => void`              | Handler that is called when the element's focus status changes.                                                                                                                          |
| `onKeyUp`            | `(e: KeyboardEvent) => void`                | Handler that is called when a key is released.                                                                                                                                           |
| `onChange`           | `(value: T) => void`                        | Handler that is called when the value changes.                                                                                                                                           |
| `onCopy`             | `ClipboardEventHandler<HTMLInputElement>`   | Handler that is called when the user copies text. See [MDN](https://developer.mozilla.org/en-US/docs/Web/API/HTMLElement/copy_event).                                                    |
| `onPaste`            | `ClipboardEventHandler<HTMLInputElement>`   | Handler that is called when the user pastes text. See [MDN](https://developer.mozilla.org/en-US/docs/Web/API/HTMLElement/paste_event).                                                   |
| `onCompositionStart` | `CompositionEventHandler<HTMLInputElement>` | Handler that is called when a text composition system starts a new text composition session. See [MDN](https://developer.mozilla.org/en-US/docs/Web/API/Element/compositionstart_event). |
| `onSelect`           | `ReactEventHandler<HTMLInputElement>`       | Handler that is called when text in the input is selected. See [MDN](https://developer.mozilla.org/en-US/docs/Web/API/HTMLInputElement/select_event).                                    |
| `onBeforeInput`      | `FormEventHandler<HTMLInputElement>`        | Handler that is called when the input value is about to be modified. See [MDN](https://developer.mozilla.org/en-US/docs/Web/API/Element/beforeinput_event).                              |
| `onInput`            | `FormEventHandler<HTMLInputElement>`        | Handler that is called when the input value is modified. See [MDN](https://developer.mozilla.org/en-US/docs/Web/API/Element/input_event).                                                |
