<p align="center">
  <a href="https://actifyjs.com">
    <img alt="Actify Logo" width="100" src="https://actifyjs.com/actify.svg">
  </a>
</p>

<p align="center">
  <a href="https://github.com/actifyjs/actify/blob/master/LICENSE.md">
    <img src="https://badgen.net/github/license/actifyjs/actify?color=green" alt="License">
  </a>
  <img src="https://visitor-badge.laobi.icu/badge?page_id=actifyjs.actify" alt="visitors" />
</p>

---

## 🌟Overview

Welcome to Actify, an open-source React Components Library designed to accelerate your React application development. Actify leverages TypeScript, Tailwind CSS, Reat-Aria, Framer Motion, Material Design 3, and more to provide a comprehensive set of modern and customizable UI components.

## ✨ Features

- **TypeScript**: Benefit from enhanced developer experience and static typing.
- **Tailwind CSS**: Embrace a utility-first CSS framework for effortless and flexible styling.
- **React-Aria**: React Aria implements accessibility support according to the WAI-ARIA specification, published by the W3C.
- **Framer Motion**: Bring fluid animations and transitions to your components with Framer Motion.
- **Material Design 3**: Implement the latest Material Design principles for a cohesive and visually appealing interface.

## 🚀 Getting Started

### 📦 Installation

```bash
# with pnpm
pnpm add actify
# with yarn
yarn add actify
# with npm
npm install actify
```

### 💻 Usage

```jsx
import { Button } from 'actify'

export default () => {
  return <Button>Hello Actify</Button>
}
```

Refer to the [documentation](https://actifyjs.com/getting-started/installation) for in-depth information on each component and their usage.

## 📚 Documentation

Explore our [documentation](https://actifyjs.com/getting-started/installation) for detailed insights, examples, and customization options for each component in the Actify library.

## 🚥 Roadmap

Our goals is convert all [Material Web](https://github.com/material-components/material-web) components to React Components, not just a React wrapped components.

| Component           | Web component | React Component |
| ------------------- | ------------- | --------------- |
| Ripple              |               | ✅              |
| Elevation           |               | ✅              |
| Focus ring          |               | ✅              |
| Icon                |               | ✅              |
| Button              |               | ✅              |
| Icon button         |               | ✅              |
| Checkbox            |               | ✅              |
| Slider              |               | ✅              |
| Switch              |               | ✅              |
| TextField           |               | ✅              |
| Progress indicators |               | ✅              |
| Radio               |               | ✅              |
| Divider             |               | ✅              |
| Menu                |               | ✅              |
| Dialog              |               | ✅              |
| Select              |               | ✅              |
| SegmentedButton     |               | ✅              |
| SegmentedButtonSet  |               | ✅              |

## 🤝 Contributing

Contributions are always welcome!
Thanks to everyone who has already contributed to `actify` !

<a href="https://github.com/actifyjs/actify/graphs/contributors"><img src="https://contributors.nn.ci/api?repo=actifyjs/actify" /></a>

## 📜 License

Actify React Components Library is licensed under the MIT License - see the [MIT licensed](./LICENSE.md) file for details..

## 🙏 Acknowledgments

- Special thanks to our contributors and the open-source community for making Actify possible.
- Highly inspired by [Vuetify](https://vuetifyjs.com) for its impactful contributions to UI design and development trends.

## 📧 Support

If you have any questions or need assistance, feel free to reach out to us at [hello@actifyjs.com](mailto:hello@actifyjs.com).

Happy coding with Actify! 🚀
