import { CosmosClient, Container } from "@azure/cosmos";
import { Entity, IMetadataRepository } from "./IMetadataRepository";

export class CosmosDbMetadataRepository implements IMetadataRepository {
  private _client: CosmosClient;
  private _databaseId: string;

  constructor() {
    const endpoint = process.env["COSMOS_ENDPOINT"];
    const key = process.env["COSMOS_KEY"];
    this._databaseId = process.env["COSMOS_DATABASE_ID"];
    this._client = new CosmosClient({ endpoint, key });
  }

  public async getById<TEntityType extends Entity>(typeName: string, id: string): Promise<TEntityType> {
    const container = await this.getContainer(typeName);
    const allMatchingItems = await container.items.query(`SELECT * FROM c WHERE c.id = '${id}'`).fetchAll();
    return allMatchingItems[0];
  }

  public async getByProperty<TEntityType extends Entity>(
    typeName: string,
    propertyName: string,
    value: any
  ): Promise<TEntityType[]> {
    const container = await this.getContainer(typeName);
    const results = await container.items.query(`SELECT * FROM c WHERE c.${propertyName} = '${value}'`).fetchAll();
    return results.resources as TEntityType[];
  }

  public async saveOrUpdate<TEntityType extends Entity>(entity: TEntityType): Promise<void> {
    const container = await this.getContainer(entity.type);
    const result = await container.items.upsert(entity);

    if (result.statusCode !== 201) {
      throw new Error(`Error saving or updating entity ${entity.id}`);
    }
  }

  public async delete<TEntityType extends Entity>(entity: TEntityType): Promise<boolean> {
    const container = await this.getContainer(entity.type);
    const { resource: result } = await container.item(entity.type, entity.id).delete();

    if (result.statusCode !== 201) {
      throw new Error(`Error deleting entity of type ${entity.type} and id ${entity.id}`);
    }

    return true;
  }

  public async exists(typeName: string, id: string): Promise<boolean> {
    const container = await this.getContainer(typeName);
    const countResult = await container.items.query(`SELECT count(1) FROM c WHERE c.id = '${id}'`).fetchAll();
    return countResult[0] > 0;
  }

  public async getAll<TEntityType extends Entity>(typeName: string): Promise<TEntityType[]> {
    const container = await this.getContainer(typeName);
    const results = await container.items.readAll().fetchAll();
    return results.resources as TEntityType[];
  }

  private async getContainer(typeName: string): Promise<Container> {
    const containerId = this.generateContainerName(typeName);
    const database = await this._client.database(this._databaseId);
    return await database.container(containerId);
  }

  private generateContainerName(typeName: string): string {
    return typeName.toLowerCase() + "s"; // yolo!
  }
}
