# ML Notebooks 101

The aim of this repository is to host a wide variety of ML implementations that can be useful for beginners as well as intermediate or advanced practitioners.. 

## Table of contents

This repo is in its early stages - only a few notebooks have been added so far, I will try to add as much notebooks as possible but anyone can feel free contribute to this repository.  

- [ANN](https://github.com/abhinand5/ml-notebooks-101/tree/main/ANN)
  * [Basics](https://github.com/abhinand5/ml-notebooks-101/tree/main/ANN/Basics)
    + [NN to implement Logic Gates](https://github.com/abhinand5/ml-notebooks-101/blob/main/ANN/Basics/NN_for_LogicGates.ipynb)
    + [NN to implement NOT Gate](https://github.com/abhinand5/ml-notebooks-101/blob/main/ANN/Basics/NN_for_NOT_Gate.ipynb)
    + [Predict Housing Prices with ANN](https://github.com/abhinand5/ml-notebooks-101/blob/main/ANN/Basics/Predict_House_Price_with_ANN.ipynb)
- [Computer Vision](https://github.com/abhinand5/ml-notebooks-101/tree/main/ComputerVision)
  + [In-depth Guide to Convolutional Neural Networks](https://github.com/abhinand5/ml-notebooks-101/blob/main/ComputerVision/in-depth-guide-to-convolutional-neural-networks.ipynb)
  + [Introductions to Computer Vision with PyTorch](https://github.com/abhinand5/ml-notebooks-101/blob/main/ComputerVision/introduction-to-computervision-with-pytorch.ipynb)
  + [Transfer Learning CNN Guide](https://github.com/abhinand5/ml-notebooks-101/blob/main/ComputerVision/transfer-learning-cnn-guide.ipynb)
  + [Basic OpenCV Operations](https://github.com/abhinand5/ml-notebooks-101/blob/main/ComputerVision/Basic_OpenCV_Operations.ipynb)
- [GANs - (Yet to Implement)](https://github.com/abhinand5/ml-notebooks-101/tree/main/GANs)
- [General ML](https://github.com/abhinand5/ml-notebooks-101/tree/main/General-ML)
  * [Regression 101: Predicting Housing Prices](https://github.com/abhinand5/ml-notebooks-101/blob/main/General-ML/regression-101-predicting-housingprices.ipynb)
  * [Titanic: Machine Learning from Disaster](https://github.com/abhinand5/ml-notebooks-101/blob/main/General-ML/Titanic_ML_from_disaster)
- [NLP](https://github.com/abhinand5/ml-notebooks-101/tree/main/NLP)
  * [Language Modelling](https://github.com/abhinand5/ml-notebooks-101/tree/main/NLP/LanguageModelling)
    + [Basic N-Gram Language Modelling](https://github.com/abhinand5/ml-notebooks-101/blob/main/NLP/LanguageModelling/N-Gram/ngram-language-model.ipynb)
  * [Text Classification](https://github.com/abhinand5/ml-notebooks-101/tree/main/NLP/TextClassification)
    + [Sentiment Classification using LSTM and GloVe](https://github.com/abhinand5/ml-notebooks-101/blob/main/NLP/TextClassification/sentiment-classification-using-lstm-glove.ipynb)
- [Reinforcement Learning (Yet to Implement)](https://github.com/abhinand5/ml-notebooks-101/tree/main/ReinforcementLearning)
- [Time-Series (Yet to Implemented)](https://github.com/abhinand5/ml-notebooks-101/tree/main/Time-Series)
- [Unsupervised Learning](https://github.com/abhinand5/ml-notebooks-101/tree/main/UnsupervisedLearning)
  * [K-Means Clustering](https://github.com/abhinand5/ml-notebooks-101/blob/main/UnsupervisedLearning/k-means%20clustering.ipynb)

## Anyone can contribute!

You can contribute by adding new scripts/notebooks, improving current scripts or Documentation. You can refer the [CONTRIBUTION.md](https://github.com/abhinand5/ml-notebooks-101/blob/main/CONTRIBUTING.md) file for more detailed guidelines. 

> Your work should go inside the relevant folders and make sure to create a sub-folder with the title of your work.

Below are some Instructions before making a Pull Request

### How to contribute

> **Note:** Preferably, add your own work, avoid making PRs by copying code from elsewhere. If you want to contribute someone else's work, you can let us know in the issues section, it will be decided by maintainers if it is worth merging. 


- [x] Create an issue for making any change to code. when issue will be approve you can make a change.
- [x] Pull latest change from upstream branch before starting the changing code.
- [x] Add your file in proper folder(lowercase) with README.md in it. Add requirements.txt if needed.
- [x] Exclude data files or saved model files if they are more than 20MB but include the scripts to automatically download or point to a source. 
- [x] Please use flake8 linting in your code

#### Typo fixed/minor change in docs not marked as contribution. If you're not aware of process kindly raise a query in formal manner :)
